/*
 * Copyright 2021 NXP
 * SPDX-License-Identifier: MIT
 */

#include "lvgl/lvgl.h"
#include <stdio.h>
#include "gui_guider.h"
#include "events_init.h"
#include "custom.h"


void setup_scr_screAllLightOffConfirm(lv_ui *ui){

	//Write codes screAllLightOffConfirm
	ui->screAllLightOffConfirm = lv_obj_create(NULL, NULL);

	//Write codes screAllLightOffConfirm_contBackground
	ui->screAllLightOffConfirm_contBackground = lv_cont_create(ui->screAllLightOffConfirm, NULL);

	//Write style LV_CONT_PART_MAIN for screAllLightOffConfirm_contBackground
	static lv_style_t style_screAllLightOffConfirm_contBackground_main;
	lv_style_init(&style_screAllLightOffConfirm_contBackground_main);

	//Write style state: LV_STATE_DEFAULT for style_screAllLightOffConfirm_contBackground_main
	lv_style_set_radius(&style_screAllLightOffConfirm_contBackground_main, LV_STATE_DEFAULT, 0);
	lv_style_set_bg_color(&style_screAllLightOffConfirm_contBackground_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_bg_grad_color(&style_screAllLightOffConfirm_contBackground_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_bg_grad_dir(&style_screAllLightOffConfirm_contBackground_main, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screAllLightOffConfirm_contBackground_main, LV_STATE_DEFAULT, 100);
	lv_style_set_border_color(&style_screAllLightOffConfirm_contBackground_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_border_width(&style_screAllLightOffConfirm_contBackground_main, LV_STATE_DEFAULT, 0);
	lv_style_set_border_opa(&style_screAllLightOffConfirm_contBackground_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_left(&style_screAllLightOffConfirm_contBackground_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_right(&style_screAllLightOffConfirm_contBackground_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_top(&style_screAllLightOffConfirm_contBackground_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_bottom(&style_screAllLightOffConfirm_contBackground_main, LV_STATE_DEFAULT, 0);
	lv_obj_add_style(ui->screAllLightOffConfirm_contBackground, LV_CONT_PART_MAIN, &style_screAllLightOffConfirm_contBackground_main);
	lv_obj_set_pos(ui->screAllLightOffConfirm_contBackground, 0, 0);
	lv_obj_set_size(ui->screAllLightOffConfirm_contBackground, 480, 272);
	lv_obj_set_click(ui->screAllLightOffConfirm_contBackground, false);
	lv_cont_set_layout(ui->screAllLightOffConfirm_contBackground, LV_LAYOUT_OFF);
	lv_cont_set_fit(ui->screAllLightOffConfirm_contBackground, LV_FIT_NONE);

	//Write codes screAllLightOffConfirm_contConfirmBackground
	ui->screAllLightOffConfirm_contConfirmBackground = lv_cont_create(ui->screAllLightOffConfirm, NULL);

	//Write style LV_CONT_PART_MAIN for screAllLightOffConfirm_contConfirmBackground
	static lv_style_t style_screAllLightOffConfirm_contConfirmBackground_main;
	lv_style_init(&style_screAllLightOffConfirm_contConfirmBackground_main);

	//Write style state: LV_STATE_DEFAULT for style_screAllLightOffConfirm_contConfirmBackground_main
	lv_style_set_radius(&style_screAllLightOffConfirm_contConfirmBackground_main, LV_STATE_DEFAULT, 20);
	lv_style_set_bg_color(&style_screAllLightOffConfirm_contConfirmBackground_main, LV_STATE_DEFAULT, lv_color_make(0x05, 0x05, 0x05));
	lv_style_set_bg_grad_color(&style_screAllLightOffConfirm_contConfirmBackground_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_bg_grad_dir(&style_screAllLightOffConfirm_contConfirmBackground_main, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screAllLightOffConfirm_contConfirmBackground_main, LV_STATE_DEFAULT, 255);
	lv_style_set_border_color(&style_screAllLightOffConfirm_contConfirmBackground_main, LV_STATE_DEFAULT, lv_color_make(0x99, 0x99, 0x99));
	lv_style_set_border_width(&style_screAllLightOffConfirm_contConfirmBackground_main, LV_STATE_DEFAULT, 1);
	lv_style_set_border_opa(&style_screAllLightOffConfirm_contConfirmBackground_main, LV_STATE_DEFAULT, 255);
	lv_style_set_pad_left(&style_screAllLightOffConfirm_contConfirmBackground_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_right(&style_screAllLightOffConfirm_contConfirmBackground_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_top(&style_screAllLightOffConfirm_contConfirmBackground_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_bottom(&style_screAllLightOffConfirm_contConfirmBackground_main, LV_STATE_DEFAULT, 0);
	lv_obj_add_style(ui->screAllLightOffConfirm_contConfirmBackground, LV_CONT_PART_MAIN, &style_screAllLightOffConfirm_contConfirmBackground_main);
	lv_obj_set_pos(ui->screAllLightOffConfirm_contConfirmBackground, 100, 54);
	lv_obj_set_size(ui->screAllLightOffConfirm_contConfirmBackground, 282, 143);
	lv_obj_set_click(ui->screAllLightOffConfirm_contConfirmBackground, false);
	lv_cont_set_layout(ui->screAllLightOffConfirm_contConfirmBackground, LV_LAYOUT_OFF);
	lv_cont_set_fit(ui->screAllLightOffConfirm_contConfirmBackground, LV_FIT_NONE);

	//Write codes screAllLightOffConfirm_labelConfirm
	ui->screAllLightOffConfirm_labelConfirm = lv_label_create(ui->screAllLightOffConfirm, NULL);
	lv_label_set_text(ui->screAllLightOffConfirm_labelConfirm, "Do you wan to turn all the light off?");
	lv_label_set_long_mode(ui->screAllLightOffConfirm_labelConfirm, LV_LABEL_LONG_BREAK);
	lv_label_set_align(ui->screAllLightOffConfirm_labelConfirm, LV_LABEL_ALIGN_CENTER);

	//Write style LV_LABEL_PART_MAIN for screAllLightOffConfirm_labelConfirm
	static lv_style_t style_screAllLightOffConfirm_labelConfirm_main;
	lv_style_init(&style_screAllLightOffConfirm_labelConfirm_main);

	//Write style state: LV_STATE_DEFAULT for style_screAllLightOffConfirm_labelConfirm_main
	lv_style_set_radius(&style_screAllLightOffConfirm_labelConfirm_main, LV_STATE_DEFAULT, 0);
	lv_style_set_bg_color(&style_screAllLightOffConfirm_labelConfirm_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_color(&style_screAllLightOffConfirm_labelConfirm_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_dir(&style_screAllLightOffConfirm_labelConfirm_main, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screAllLightOffConfirm_labelConfirm_main, LV_STATE_DEFAULT, 0);
	lv_style_set_text_color(&style_screAllLightOffConfirm_labelConfirm_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_text_font(&style_screAllLightOffConfirm_labelConfirm_main, LV_STATE_DEFAULT, &lv_font_simsun_20);
	lv_style_set_text_letter_space(&style_screAllLightOffConfirm_labelConfirm_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_left(&style_screAllLightOffConfirm_labelConfirm_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_right(&style_screAllLightOffConfirm_labelConfirm_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_top(&style_screAllLightOffConfirm_labelConfirm_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_bottom(&style_screAllLightOffConfirm_labelConfirm_main, LV_STATE_DEFAULT, 0);
	lv_obj_add_style(ui->screAllLightOffConfirm_labelConfirm, LV_LABEL_PART_MAIN, &style_screAllLightOffConfirm_labelConfirm_main);
	lv_obj_set_pos(ui->screAllLightOffConfirm_labelConfirm, 142, 64);
	lv_obj_set_size(ui->screAllLightOffConfirm_labelConfirm, 207, 0);

	//Write codes screAllLightOffConfirm_imgbtnCheck
	ui->screAllLightOffConfirm_imgbtnCheck = lv_imgbtn_create(ui->screAllLightOffConfirm, NULL);

	//Write style LV_IMGBTN_PART_MAIN for screAllLightOffConfirm_imgbtnCheck
	static lv_style_t style_screAllLightOffConfirm_imgbtnCheck_main;
	lv_style_init(&style_screAllLightOffConfirm_imgbtnCheck_main);

	//Write style state: LV_STATE_DEFAULT for style_screAllLightOffConfirm_imgbtnCheck_main
	lv_style_set_text_color(&style_screAllLightOffConfirm_imgbtnCheck_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_image_recolor(&style_screAllLightOffConfirm_imgbtnCheck_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_image_recolor_opa(&style_screAllLightOffConfirm_imgbtnCheck_main, LV_STATE_DEFAULT, 0);
	lv_style_set_image_opa(&style_screAllLightOffConfirm_imgbtnCheck_main, LV_STATE_DEFAULT, 255);
	lv_obj_add_style(ui->screAllLightOffConfirm_imgbtnCheck, LV_IMGBTN_PART_MAIN, &style_screAllLightOffConfirm_imgbtnCheck_main);
	lv_obj_set_pos(ui->screAllLightOffConfirm_imgbtnCheck, 143, 125);
	lv_obj_set_size(ui->screAllLightOffConfirm_imgbtnCheck, 80, 80);
	lv_imgbtn_set_src(ui->screAllLightOffConfirm_imgbtnCheck,LV_BTN_STATE_RELEASED,&_btn_ok_alpha_80x80);
	lv_imgbtn_set_src(ui->screAllLightOffConfirm_imgbtnCheck,LV_BTN_STATE_PRESSED,&_btn_ok_alpha_80x80);

	//Write codes screAllLightOffConfirm_imgbtnDeny
	ui->screAllLightOffConfirm_imgbtnDeny = lv_imgbtn_create(ui->screAllLightOffConfirm, NULL);

	//Write style LV_IMGBTN_PART_MAIN for screAllLightOffConfirm_imgbtnDeny
	static lv_style_t style_screAllLightOffConfirm_imgbtnDeny_main;
	lv_style_init(&style_screAllLightOffConfirm_imgbtnDeny_main);

	//Write style state: LV_STATE_DEFAULT for style_screAllLightOffConfirm_imgbtnDeny_main
	lv_style_set_text_color(&style_screAllLightOffConfirm_imgbtnDeny_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_image_recolor(&style_screAllLightOffConfirm_imgbtnDeny_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_image_recolor_opa(&style_screAllLightOffConfirm_imgbtnDeny_main, LV_STATE_DEFAULT, 0);
	lv_style_set_image_opa(&style_screAllLightOffConfirm_imgbtnDeny_main, LV_STATE_DEFAULT, 255);
	lv_obj_add_style(ui->screAllLightOffConfirm_imgbtnDeny, LV_IMGBTN_PART_MAIN, &style_screAllLightOffConfirm_imgbtnDeny_main);
	lv_obj_set_pos(ui->screAllLightOffConfirm_imgbtnDeny, 261, 127);
	lv_obj_set_size(ui->screAllLightOffConfirm_imgbtnDeny, 80, 80);
	lv_imgbtn_set_src(ui->screAllLightOffConfirm_imgbtnDeny,LV_BTN_STATE_RELEASED,&_btn_no_alpha_80x80);
	lv_imgbtn_set_src(ui->screAllLightOffConfirm_imgbtnDeny,LV_BTN_STATE_PRESSED,&_btn_no_alpha_80x80);

	//Init events for screen
	events_init_screAllLightOffConfirm(ui);
}