/*
 * Copyright 2021 NXP
 * SPDX-License-Identifier: MIT
 */

#include "lvgl/lvgl.h"
#include <stdio.h>
#include "gui_guider.h"
#include "events_init.h"
#include "custom.h"


void setup_scr_screAudioList(lv_ui *ui){

	//Write codes screAudioList
	ui->screAudioList = lv_obj_create(NULL, NULL);

	//Write codes screAudioList_contBackground
	ui->screAudioList_contBackground = lv_cont_create(ui->screAudioList, NULL);

	//Write style LV_CONT_PART_MAIN for screAudioList_contBackground
	static lv_style_t style_screAudioList_contBackground_main;
	lv_style_init(&style_screAudioList_contBackground_main);

	//Write style state: LV_STATE_DEFAULT for style_screAudioList_contBackground_main
	lv_style_set_radius(&style_screAudioList_contBackground_main, LV_STATE_DEFAULT, 0);
	lv_style_set_bg_color(&style_screAudioList_contBackground_main, LV_STATE_DEFAULT, lv_color_make(0xe0, 0xe0, 0xe0));
	lv_style_set_bg_grad_color(&style_screAudioList_contBackground_main, LV_STATE_DEFAULT, lv_color_make(0xf4, 0xf4, 0xf4));
	lv_style_set_bg_grad_dir(&style_screAudioList_contBackground_main, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screAudioList_contBackground_main, LV_STATE_DEFAULT, 255);
	lv_style_set_border_color(&style_screAudioList_contBackground_main, LV_STATE_DEFAULT, lv_color_make(0x99, 0x99, 0x99));
	lv_style_set_border_width(&style_screAudioList_contBackground_main, LV_STATE_DEFAULT, 0);
	lv_style_set_border_opa(&style_screAudioList_contBackground_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_left(&style_screAudioList_contBackground_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_right(&style_screAudioList_contBackground_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_top(&style_screAudioList_contBackground_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_bottom(&style_screAudioList_contBackground_main, LV_STATE_DEFAULT, 0);
	lv_obj_add_style(ui->screAudioList_contBackground, LV_CONT_PART_MAIN, &style_screAudioList_contBackground_main);
	lv_obj_set_pos(ui->screAudioList_contBackground, 0, 0);
	lv_obj_set_size(ui->screAudioList_contBackground, 480, 272);
	lv_obj_set_click(ui->screAudioList_contBackground, false);

	//Write codes screAudioList_listSong
	ui->screAudioList_listSong = lv_list_create(ui->screAudioList_contBackground, NULL);
	lv_list_set_edge_flash(ui->screAudioList_listSong, true);

	//Write style LV_LIST_PART_BG for screAudioList_listSong
	static lv_style_t style_screAudioList_listSong_bg;
	lv_style_init(&style_screAudioList_listSong_bg);

	//Write style state: LV_STATE_DEFAULT for style_screAudioList_listSong_bg
	lv_style_set_radius(&style_screAudioList_listSong_bg, LV_STATE_DEFAULT, 10);
	lv_style_set_border_color(&style_screAudioList_listSong_bg, LV_STATE_DEFAULT, lv_color_make(0xe1, 0xe6, 0xee));
	lv_style_set_border_width(&style_screAudioList_listSong_bg, LV_STATE_DEFAULT, 1);
	lv_style_set_pad_left(&style_screAudioList_listSong_bg, LV_STATE_DEFAULT, 15);
	lv_style_set_pad_right(&style_screAudioList_listSong_bg, LV_STATE_DEFAULT, 5);
	lv_style_set_pad_top(&style_screAudioList_listSong_bg, LV_STATE_DEFAULT, 5);
	lv_obj_add_style(ui->screAudioList_listSong, LV_LIST_PART_BG, &style_screAudioList_listSong_bg);

	//Write style LV_LIST_PART_SCROLLABLE for screAudioList_listSong
	static lv_style_t style_screAudioList_listSong_scrollable;
	lv_style_init(&style_screAudioList_listSong_scrollable);

	//Write style state: LV_STATE_DEFAULT for style_screAudioList_listSong_scrollable
	lv_style_set_radius(&style_screAudioList_listSong_scrollable, LV_STATE_DEFAULT, 3);
	lv_style_set_bg_color(&style_screAudioList_listSong_scrollable, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_color(&style_screAudioList_listSong_scrollable, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_dir(&style_screAudioList_listSong_scrollable, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screAudioList_listSong_scrollable, LV_STATE_DEFAULT, 255);
	lv_obj_add_style(ui->screAudioList_listSong, LV_LIST_PART_SCROLLABLE, &style_screAudioList_listSong_scrollable);

	//Write style LV_BTN_PART_MAIN for screAudioList_listSong
	static lv_style_t style_screAudioList_listSong_main_child;
	lv_style_init(&style_screAudioList_listSong_main_child);

	//Write style state: LV_STATE_DEFAULT for style_screAudioList_listSong_main_child
	lv_style_set_radius(&style_screAudioList_listSong_main_child, LV_STATE_DEFAULT, 3);
	lv_style_set_bg_color(&style_screAudioList_listSong_main_child, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_color(&style_screAudioList_listSong_main_child, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_dir(&style_screAudioList_listSong_main_child, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screAudioList_listSong_main_child, LV_STATE_DEFAULT, 255);
	lv_style_set_text_color(&style_screAudioList_listSong_main_child, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_text_font(&style_screAudioList_listSong_main_child, LV_STATE_DEFAULT, &lv_font_simsun_17);

	//Write style state: LV_STATE_FOCUSED for style_screAudioList_listSong_main_child
	lv_style_set_radius(&style_screAudioList_listSong_main_child, LV_STATE_FOCUSED, 3);
	lv_style_set_bg_color(&style_screAudioList_listSong_main_child, LV_STATE_FOCUSED, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_color(&style_screAudioList_listSong_main_child, LV_STATE_FOCUSED, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_dir(&style_screAudioList_listSong_main_child, LV_STATE_FOCUSED, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screAudioList_listSong_main_child, LV_STATE_FOCUSED, 255);
	lv_style_set_text_color(&style_screAudioList_listSong_main_child, LV_STATE_FOCUSED, lv_color_make(0x0D, 0x30, 0x55));
	lv_style_set_text_font(&style_screAudioList_listSong_main_child, LV_STATE_FOCUSED, &lv_font_simsun_12);
	lv_obj_set_pos(ui->screAudioList_listSong, 0, 40);
	lv_obj_set_size(ui->screAudioList_listSong, 480, 232);
	lv_obj_t *screAudioList_listSong_btn;
	screAudioList_listSong_btn = lv_list_add_btn(ui->screAudioList_listSong, &_img_album_1_small_53x53, "Forever young (dance mix) ");
	ui->screAudioList_listSong_item0 = screAudioList_listSong_btn;
	lv_obj_add_style(screAudioList_listSong_btn, LV_BTN_PART_MAIN, &style_screAudioList_listSong_main_child);
	screAudioList_listSong_btn = lv_list_add_btn(ui->screAudioList_listSong, &_album2_53x53, "The sound of the Shire");
	ui->screAudioList_listSong_item1 = screAudioList_listSong_btn;
	lv_obj_add_style(screAudioList_listSong_btn, LV_BTN_PART_MAIN, &style_screAudioList_listSong_main_child);
	screAudioList_listSong_btn = lv_list_add_btn(ui->screAudioList_listSong, &_gutar_53x53, "Save Tonight");
	ui->screAudioList_listSong_item2 = screAudioList_listSong_btn;
	lv_obj_add_style(screAudioList_listSong_btn, LV_BTN_PART_MAIN, &style_screAudioList_listSong_main_child);
	lv_cont_set_layout(ui->screAudioList_contBackground, LV_LAYOUT_OFF);
	lv_cont_set_fit(ui->screAudioList_contBackground, LV_FIT_NONE);

	//Write codes screAudioList_imgHead
	ui->screAudioList_imgHead = lv_img_create(ui->screAudioList, NULL);

	//Write style LV_IMG_PART_MAIN for screAudioList_imgHead
	static lv_style_t style_screAudioList_imgHead_main;
	lv_style_init(&style_screAudioList_imgHead_main);

	//Write style state: LV_STATE_DEFAULT for style_screAudioList_imgHead_main
	lv_style_set_image_recolor(&style_screAudioList_imgHead_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_image_recolor_opa(&style_screAudioList_imgHead_main, LV_STATE_DEFAULT, 0);
	lv_style_set_image_opa(&style_screAudioList_imgHead_main, LV_STATE_DEFAULT, 255);
	lv_obj_add_style(ui->screAudioList_imgHead, LV_IMG_PART_MAIN, &style_screAudioList_imgHead_main);
	lv_obj_set_pos(ui->screAudioList_imgHead, 0, 0);
	lv_obj_set_size(ui->screAudioList_imgHead, 480, 80);
	lv_obj_set_click(ui->screAudioList_imgHead, true);
	lv_img_set_src(ui->screAudioList_imgHead,&_img_header_alpha_480x80);
	lv_img_set_pivot(ui->screAudioList_imgHead, 0,0);
	lv_img_set_angle(ui->screAudioList_imgHead, 0);

	//Write codes screAudioList_labelAudioListSlogan
	ui->screAudioList_labelAudioListSlogan = lv_label_create(ui->screAudioList, NULL);
	lv_label_set_text(ui->screAudioList_labelAudioListSlogan, "SONG LIST");
	lv_label_set_long_mode(ui->screAudioList_labelAudioListSlogan, LV_LABEL_LONG_BREAK);
	lv_label_set_align(ui->screAudioList_labelAudioListSlogan, LV_LABEL_ALIGN_CENTER);

	//Write style LV_LABEL_PART_MAIN for screAudioList_labelAudioListSlogan
	static lv_style_t style_screAudioList_labelAudioListSlogan_main;
	lv_style_init(&style_screAudioList_labelAudioListSlogan_main);

	//Write style state: LV_STATE_DEFAULT for style_screAudioList_labelAudioListSlogan_main
	lv_style_set_radius(&style_screAudioList_labelAudioListSlogan_main, LV_STATE_DEFAULT, 0);
	lv_style_set_bg_color(&style_screAudioList_labelAudioListSlogan_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_bg_grad_color(&style_screAudioList_labelAudioListSlogan_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_bg_grad_dir(&style_screAudioList_labelAudioListSlogan_main, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screAudioList_labelAudioListSlogan_main, LV_STATE_DEFAULT, 0);
	lv_style_set_text_color(&style_screAudioList_labelAudioListSlogan_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_text_font(&style_screAudioList_labelAudioListSlogan_main, LV_STATE_DEFAULT, &lv_font_simsun_22);
	lv_style_set_text_letter_space(&style_screAudioList_labelAudioListSlogan_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_left(&style_screAudioList_labelAudioListSlogan_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_right(&style_screAudioList_labelAudioListSlogan_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_top(&style_screAudioList_labelAudioListSlogan_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_bottom(&style_screAudioList_labelAudioListSlogan_main, LV_STATE_DEFAULT, 0);
	lv_obj_add_style(ui->screAudioList_labelAudioListSlogan, LV_LABEL_PART_MAIN, &style_screAudioList_labelAudioListSlogan_main);
	lv_obj_set_pos(ui->screAudioList_labelAudioListSlogan, 143, 7);
	lv_obj_set_size(ui->screAudioList_labelAudioListSlogan, 206, 0);

	//Write codes screAudioList_labelTime
	ui->screAudioList_labelTime = lv_label_create(ui->screAudioList, NULL);
	lv_label_set_text(ui->screAudioList_labelTime, "10:54 AM");
	lv_label_set_long_mode(ui->screAudioList_labelTime, LV_LABEL_LONG_BREAK);
	lv_label_set_align(ui->screAudioList_labelTime, LV_LABEL_ALIGN_CENTER);

	//Write style LV_LABEL_PART_MAIN for screAudioList_labelTime
	static lv_style_t style_screAudioList_labelTime_main;
	lv_style_init(&style_screAudioList_labelTime_main);

	//Write style state: LV_STATE_DEFAULT for style_screAudioList_labelTime_main
	lv_style_set_radius(&style_screAudioList_labelTime_main, LV_STATE_DEFAULT, 0);
	lv_style_set_bg_color(&style_screAudioList_labelTime_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_bg_grad_color(&style_screAudioList_labelTime_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_dir(&style_screAudioList_labelTime_main, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screAudioList_labelTime_main, LV_STATE_DEFAULT, 0);
	lv_style_set_text_color(&style_screAudioList_labelTime_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_text_font(&style_screAudioList_labelTime_main, LV_STATE_DEFAULT, &lv_font_simsun_20);
	lv_style_set_text_letter_space(&style_screAudioList_labelTime_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_left(&style_screAudioList_labelTime_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_right(&style_screAudioList_labelTime_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_top(&style_screAudioList_labelTime_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_bottom(&style_screAudioList_labelTime_main, LV_STATE_DEFAULT, 0);
	lv_obj_add_style(ui->screAudioList_labelTime, LV_LABEL_PART_MAIN, &style_screAudioList_labelTime_main);
	lv_obj_set_pos(ui->screAudioList_labelTime, 379, 8);
	lv_obj_set_size(ui->screAudioList_labelTime, 100, 0);

	//Write codes screAudioList_imgbtnHome
	ui->screAudioList_imgbtnHome = lv_imgbtn_create(ui->screAudioList, NULL);

	//Write style LV_IMGBTN_PART_MAIN for screAudioList_imgbtnHome
	static lv_style_t style_screAudioList_imgbtnHome_main;
	lv_style_init(&style_screAudioList_imgbtnHome_main);

	//Write style state: LV_STATE_DEFAULT for style_screAudioList_imgbtnHome_main
	lv_style_set_text_color(&style_screAudioList_imgbtnHome_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_image_recolor(&style_screAudioList_imgbtnHome_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_image_recolor_opa(&style_screAudioList_imgbtnHome_main, LV_STATE_DEFAULT, 0);
	lv_style_set_image_opa(&style_screAudioList_imgbtnHome_main, LV_STATE_DEFAULT, 255);
	lv_obj_add_style(ui->screAudioList_imgbtnHome, LV_IMGBTN_PART_MAIN, &style_screAudioList_imgbtnHome_main);
	lv_obj_set_pos(ui->screAudioList_imgbtnHome, 36, 0);
	lv_obj_set_size(ui->screAudioList_imgbtnHome, 55, 50);
	lv_imgbtn_set_src(ui->screAudioList_imgbtnHome,LV_BTN_STATE_RELEASED,&_btn_long_top_house_alpha_55x50);
	lv_imgbtn_set_src(ui->screAudioList_imgbtnHome,LV_BTN_STATE_PRESSED,&_btn_long_top_house_alpha_55x50);

	//Write codes screAudioList_imgbtnAudioList
	ui->screAudioList_imgbtnAudioList = lv_imgbtn_create(ui->screAudioList, NULL);

	//Write style LV_IMGBTN_PART_MAIN for screAudioList_imgbtnAudioList
	static lv_style_t style_screAudioList_imgbtnAudioList_main;
	lv_style_init(&style_screAudioList_imgbtnAudioList_main);

	//Write style state: LV_STATE_DEFAULT for style_screAudioList_imgbtnAudioList_main
	lv_style_set_text_color(&style_screAudioList_imgbtnAudioList_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_image_recolor(&style_screAudioList_imgbtnAudioList_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_image_recolor_opa(&style_screAudioList_imgbtnAudioList_main, LV_STATE_DEFAULT, 0);
	lv_style_set_image_opa(&style_screAudioList_imgbtnAudioList_main, LV_STATE_DEFAULT, 255);
	lv_obj_add_style(ui->screAudioList_imgbtnAudioList, LV_IMGBTN_PART_MAIN, &style_screAudioList_imgbtnAudioList_main);
	lv_obj_set_pos(ui->screAudioList_imgbtnAudioList, 419, 220);
	lv_obj_set_size(ui->screAudioList_imgbtnAudioList, 49, 48);
	lv_imgbtn_set_src(ui->screAudioList_imgbtnAudioList,LV_BTN_STATE_RELEASED,&_btn_long_button_list_close_alpha_49x48);

	//Write codes screAudioList_labelSongNo1
	ui->screAudioList_labelSongNo1 = lv_label_create(ui->screAudioList, NULL);
	lv_label_set_text(ui->screAudioList_labelSongNo1, "01");
	lv_label_set_long_mode(ui->screAudioList_labelSongNo1, LV_LABEL_LONG_BREAK);
	lv_label_set_align(ui->screAudioList_labelSongNo1, LV_LABEL_ALIGN_CENTER);

	//Write style LV_LABEL_PART_MAIN for screAudioList_labelSongNo1
	static lv_style_t style_screAudioList_labelSongNo1_main;
	lv_style_init(&style_screAudioList_labelSongNo1_main);

	//Write style state: LV_STATE_DEFAULT for style_screAudioList_labelSongNo1_main
	lv_style_set_radius(&style_screAudioList_labelSongNo1_main, LV_STATE_DEFAULT, 0);
	lv_style_set_bg_color(&style_screAudioList_labelSongNo1_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_color(&style_screAudioList_labelSongNo1_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_dir(&style_screAudioList_labelSongNo1_main, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screAudioList_labelSongNo1_main, LV_STATE_DEFAULT, 255);
	lv_style_set_text_color(&style_screAudioList_labelSongNo1_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_text_font(&style_screAudioList_labelSongNo1_main, LV_STATE_DEFAULT, &lv_font_simsun_12);
	lv_style_set_text_letter_space(&style_screAudioList_labelSongNo1_main, LV_STATE_DEFAULT, 2);
	lv_style_set_pad_left(&style_screAudioList_labelSongNo1_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_right(&style_screAudioList_labelSongNo1_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_top(&style_screAudioList_labelSongNo1_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_bottom(&style_screAudioList_labelSongNo1_main, LV_STATE_DEFAULT, 0);
	lv_obj_add_style(ui->screAudioList_labelSongNo1, LV_LABEL_PART_MAIN, &style_screAudioList_labelSongNo1_main);
	lv_obj_set_pos(ui->screAudioList_labelSongNo1, 10, 73);
	lv_obj_set_size(ui->screAudioList_labelSongNo1, 17, 0);

	//Write codes screAudioList_labelSongNo2
	ui->screAudioList_labelSongNo2 = lv_label_create(ui->screAudioList, NULL);
	lv_label_set_text(ui->screAudioList_labelSongNo2, "02");
	lv_label_set_long_mode(ui->screAudioList_labelSongNo2, LV_LABEL_LONG_BREAK);
	lv_label_set_align(ui->screAudioList_labelSongNo2, LV_LABEL_ALIGN_CENTER);

	//Write style LV_LABEL_PART_MAIN for screAudioList_labelSongNo2
	static lv_style_t style_screAudioList_labelSongNo2_main;
	lv_style_init(&style_screAudioList_labelSongNo2_main);

	//Write style state: LV_STATE_DEFAULT for style_screAudioList_labelSongNo2_main
	lv_style_set_radius(&style_screAudioList_labelSongNo2_main, LV_STATE_DEFAULT, 0);
	lv_style_set_bg_color(&style_screAudioList_labelSongNo2_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_color(&style_screAudioList_labelSongNo2_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_dir(&style_screAudioList_labelSongNo2_main, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screAudioList_labelSongNo2_main, LV_STATE_DEFAULT, 255);
	lv_style_set_text_color(&style_screAudioList_labelSongNo2_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_text_font(&style_screAudioList_labelSongNo2_main, LV_STATE_DEFAULT, &lv_font_simsun_12);
	lv_style_set_text_letter_space(&style_screAudioList_labelSongNo2_main, LV_STATE_DEFAULT, 2);
	lv_style_set_pad_left(&style_screAudioList_labelSongNo2_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_right(&style_screAudioList_labelSongNo2_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_top(&style_screAudioList_labelSongNo2_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_bottom(&style_screAudioList_labelSongNo2_main, LV_STATE_DEFAULT, 0);
	lv_obj_add_style(ui->screAudioList_labelSongNo2, LV_LABEL_PART_MAIN, &style_screAudioList_labelSongNo2_main);
	lv_obj_set_pos(ui->screAudioList_labelSongNo2, 10, 147);
	lv_obj_set_size(ui->screAudioList_labelSongNo2, 17, 0);

	//Write codes screAudioList_labelSongNo3
	ui->screAudioList_labelSongNo3 = lv_label_create(ui->screAudioList, NULL);
	lv_label_set_text(ui->screAudioList_labelSongNo3, "03");
	lv_label_set_long_mode(ui->screAudioList_labelSongNo3, LV_LABEL_LONG_BREAK);
	lv_label_set_align(ui->screAudioList_labelSongNo3, LV_LABEL_ALIGN_CENTER);

	//Write style LV_LABEL_PART_MAIN for screAudioList_labelSongNo3
	static lv_style_t style_screAudioList_labelSongNo3_main;
	lv_style_init(&style_screAudioList_labelSongNo3_main);

	//Write style state: LV_STATE_DEFAULT for style_screAudioList_labelSongNo3_main
	lv_style_set_radius(&style_screAudioList_labelSongNo3_main, LV_STATE_DEFAULT, 0);
	lv_style_set_bg_color(&style_screAudioList_labelSongNo3_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_color(&style_screAudioList_labelSongNo3_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_dir(&style_screAudioList_labelSongNo3_main, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screAudioList_labelSongNo3_main, LV_STATE_DEFAULT, 255);
	lv_style_set_text_color(&style_screAudioList_labelSongNo3_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_text_font(&style_screAudioList_labelSongNo3_main, LV_STATE_DEFAULT, &lv_font_simsun_12);
	lv_style_set_text_letter_space(&style_screAudioList_labelSongNo3_main, LV_STATE_DEFAULT, 2);
	lv_style_set_pad_left(&style_screAudioList_labelSongNo3_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_right(&style_screAudioList_labelSongNo3_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_top(&style_screAudioList_labelSongNo3_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_bottom(&style_screAudioList_labelSongNo3_main, LV_STATE_DEFAULT, 0);
	lv_obj_add_style(ui->screAudioList_labelSongNo3, LV_LABEL_PART_MAIN, &style_screAudioList_labelSongNo3_main);
	lv_obj_set_pos(ui->screAudioList_labelSongNo3, 10, 225);
	lv_obj_set_size(ui->screAudioList_labelSongNo3, 17, 0);

	//Write codes screAudioList_labelSongAlbum1
	ui->screAudioList_labelSongAlbum1 = lv_label_create(ui->screAudioList, NULL);
	lv_label_set_text(ui->screAudioList_labelSongAlbum1, "Elisium - The best moment");
	lv_label_set_long_mode(ui->screAudioList_labelSongAlbum1, LV_LABEL_LONG_BREAK);
	lv_label_set_align(ui->screAudioList_labelSongAlbum1, LV_LABEL_ALIGN_CENTER);

	//Write style LV_LABEL_PART_MAIN for screAudioList_labelSongAlbum1
	static lv_style_t style_screAudioList_labelSongAlbum1_main;
	lv_style_init(&style_screAudioList_labelSongAlbum1_main);

	//Write style state: LV_STATE_DEFAULT for style_screAudioList_labelSongAlbum1_main
	lv_style_set_radius(&style_screAudioList_labelSongAlbum1_main, LV_STATE_DEFAULT, 0);
	lv_style_set_bg_color(&style_screAudioList_labelSongAlbum1_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_color(&style_screAudioList_labelSongAlbum1_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_dir(&style_screAudioList_labelSongAlbum1_main, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screAudioList_labelSongAlbum1_main, LV_STATE_DEFAULT, 255);
	lv_style_set_text_color(&style_screAudioList_labelSongAlbum1_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_text_font(&style_screAudioList_labelSongAlbum1_main, LV_STATE_DEFAULT, &lv_font_simsun_12);
	lv_style_set_text_letter_space(&style_screAudioList_labelSongAlbum1_main, LV_STATE_DEFAULT, 2);
	lv_style_set_pad_left(&style_screAudioList_labelSongAlbum1_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_right(&style_screAudioList_labelSongAlbum1_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_top(&style_screAudioList_labelSongAlbum1_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_bottom(&style_screAudioList_labelSongAlbum1_main, LV_STATE_DEFAULT, 0);
	lv_obj_add_style(ui->screAudioList_labelSongAlbum1, LV_LABEL_PART_MAIN, &style_screAudioList_labelSongAlbum1_main);
	lv_obj_set_pos(ui->screAudioList_labelSongAlbum1, 97, 96);
	lv_obj_set_size(ui->screAudioList_labelSongAlbum1, 211, 0);

	//Write codes screAudioList_labelSongAlbum2
	ui->screAudioList_labelSongAlbum2 = lv_label_create(ui->screAudioList, NULL);
	lv_label_set_text(ui->screAudioList_labelSongAlbum2, "Alphaville - Hypermass");
	lv_label_set_long_mode(ui->screAudioList_labelSongAlbum2, LV_LABEL_LONG_BREAK);
	lv_label_set_align(ui->screAudioList_labelSongAlbum2, LV_LABEL_ALIGN_CENTER);

	//Write style LV_LABEL_PART_MAIN for screAudioList_labelSongAlbum2
	static lv_style_t style_screAudioList_labelSongAlbum2_main;
	lv_style_init(&style_screAudioList_labelSongAlbum2_main);

	//Write style state: LV_STATE_DEFAULT for style_screAudioList_labelSongAlbum2_main
	lv_style_set_radius(&style_screAudioList_labelSongAlbum2_main, LV_STATE_DEFAULT, 0);
	lv_style_set_bg_color(&style_screAudioList_labelSongAlbum2_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_color(&style_screAudioList_labelSongAlbum2_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_dir(&style_screAudioList_labelSongAlbum2_main, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screAudioList_labelSongAlbum2_main, LV_STATE_DEFAULT, 255);
	lv_style_set_text_color(&style_screAudioList_labelSongAlbum2_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_text_font(&style_screAudioList_labelSongAlbum2_main, LV_STATE_DEFAULT, &lv_font_simsun_12);
	lv_style_set_text_letter_space(&style_screAudioList_labelSongAlbum2_main, LV_STATE_DEFAULT, 2);
	lv_style_set_pad_left(&style_screAudioList_labelSongAlbum2_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_right(&style_screAudioList_labelSongAlbum2_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_top(&style_screAudioList_labelSongAlbum2_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_bottom(&style_screAudioList_labelSongAlbum2_main, LV_STATE_DEFAULT, 0);
	lv_obj_add_style(ui->screAudioList_labelSongAlbum2, LV_LABEL_PART_MAIN, &style_screAudioList_labelSongAlbum2_main);
	lv_obj_set_pos(ui->screAudioList_labelSongAlbum2, 97, 172);
	lv_obj_set_size(ui->screAudioList_labelSongAlbum2, 192, 0);

	//Write codes screAudioList_labelSongAlbum3
	ui->screAudioList_labelSongAlbum3 = lv_label_create(ui->screAudioList, NULL);
	lv_label_set_text(ui->screAudioList_labelSongAlbum3, "Eagle Eye Cherry - The night");
	lv_label_set_long_mode(ui->screAudioList_labelSongAlbum3, LV_LABEL_LONG_BREAK);
	lv_label_set_align(ui->screAudioList_labelSongAlbum3, LV_LABEL_ALIGN_CENTER);

	//Write style LV_LABEL_PART_MAIN for screAudioList_labelSongAlbum3
	static lv_style_t style_screAudioList_labelSongAlbum3_main;
	lv_style_init(&style_screAudioList_labelSongAlbum3_main);

	//Write style state: LV_STATE_DEFAULT for style_screAudioList_labelSongAlbum3_main
	lv_style_set_radius(&style_screAudioList_labelSongAlbum3_main, LV_STATE_DEFAULT, 0);
	lv_style_set_bg_color(&style_screAudioList_labelSongAlbum3_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_color(&style_screAudioList_labelSongAlbum3_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_dir(&style_screAudioList_labelSongAlbum3_main, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screAudioList_labelSongAlbum3_main, LV_STATE_DEFAULT, 255);
	lv_style_set_text_color(&style_screAudioList_labelSongAlbum3_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_text_font(&style_screAudioList_labelSongAlbum3_main, LV_STATE_DEFAULT, &lv_font_simsun_12);
	lv_style_set_text_letter_space(&style_screAudioList_labelSongAlbum3_main, LV_STATE_DEFAULT, 2);
	lv_style_set_pad_left(&style_screAudioList_labelSongAlbum3_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_right(&style_screAudioList_labelSongAlbum3_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_top(&style_screAudioList_labelSongAlbum3_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_bottom(&style_screAudioList_labelSongAlbum3_main, LV_STATE_DEFAULT, 0);
	lv_obj_add_style(ui->screAudioList_labelSongAlbum3, LV_LABEL_PART_MAIN, &style_screAudioList_labelSongAlbum3_main);
	lv_obj_set_pos(ui->screAudioList_labelSongAlbum3, 98, 246);
	lv_obj_set_size(ui->screAudioList_labelSongAlbum3, 233, 0);

	//Write codes screAudioList_labelSongtime3
	ui->screAudioList_labelSongtime3 = lv_label_create(ui->screAudioList, NULL);
	lv_label_set_text(ui->screAudioList_labelSongtime3, "03:57");
	lv_label_set_long_mode(ui->screAudioList_labelSongtime3, LV_LABEL_LONG_BREAK);
	lv_label_set_align(ui->screAudioList_labelSongtime3, LV_LABEL_ALIGN_CENTER);

	//Write style LV_LABEL_PART_MAIN for screAudioList_labelSongtime3
	static lv_style_t style_screAudioList_labelSongtime3_main;
	lv_style_init(&style_screAudioList_labelSongtime3_main);

	//Write style state: LV_STATE_DEFAULT for style_screAudioList_labelSongtime3_main
	lv_style_set_radius(&style_screAudioList_labelSongtime3_main, LV_STATE_DEFAULT, 0);
	lv_style_set_bg_color(&style_screAudioList_labelSongtime3_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_color(&style_screAudioList_labelSongtime3_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_dir(&style_screAudioList_labelSongtime3_main, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screAudioList_labelSongtime3_main, LV_STATE_DEFAULT, 255);
	lv_style_set_text_color(&style_screAudioList_labelSongtime3_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_text_font(&style_screAudioList_labelSongtime3_main, LV_STATE_DEFAULT, &lv_font_simsun_12);
	lv_style_set_text_letter_space(&style_screAudioList_labelSongtime3_main, LV_STATE_DEFAULT, 2);
	lv_style_set_pad_left(&style_screAudioList_labelSongtime3_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_right(&style_screAudioList_labelSongtime3_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_top(&style_screAudioList_labelSongtime3_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_bottom(&style_screAudioList_labelSongtime3_main, LV_STATE_DEFAULT, 0);
	lv_obj_add_style(ui->screAudioList_labelSongtime3, LV_LABEL_PART_MAIN, &style_screAudioList_labelSongtime3_main);
	lv_obj_set_pos(ui->screAudioList_labelSongtime3, 355, 230);
	lv_obj_set_size(ui->screAudioList_labelSongtime3, 56, 0);

	//Write codes screAudioList_labelSongtime1
	ui->screAudioList_labelSongtime1 = lv_label_create(ui->screAudioList, NULL);
	lv_label_set_text(ui->screAudioList_labelSongtime1, "05:24");
	lv_label_set_long_mode(ui->screAudioList_labelSongtime1, LV_LABEL_LONG_BREAK);
	lv_label_set_align(ui->screAudioList_labelSongtime1, LV_LABEL_ALIGN_CENTER);

	//Write style LV_LABEL_PART_MAIN for screAudioList_labelSongtime1
	static lv_style_t style_screAudioList_labelSongtime1_main;
	lv_style_init(&style_screAudioList_labelSongtime1_main);

	//Write style state: LV_STATE_DEFAULT for style_screAudioList_labelSongtime1_main
	lv_style_set_radius(&style_screAudioList_labelSongtime1_main, LV_STATE_DEFAULT, 0);
	lv_style_set_bg_color(&style_screAudioList_labelSongtime1_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_color(&style_screAudioList_labelSongtime1_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_dir(&style_screAudioList_labelSongtime1_main, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screAudioList_labelSongtime1_main, LV_STATE_DEFAULT, 255);
	lv_style_set_text_color(&style_screAudioList_labelSongtime1_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_text_font(&style_screAudioList_labelSongtime1_main, LV_STATE_DEFAULT, &lv_font_simsun_12);
	lv_style_set_text_letter_space(&style_screAudioList_labelSongtime1_main, LV_STATE_DEFAULT, 2);
	lv_style_set_pad_left(&style_screAudioList_labelSongtime1_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_right(&style_screAudioList_labelSongtime1_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_top(&style_screAudioList_labelSongtime1_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_bottom(&style_screAudioList_labelSongtime1_main, LV_STATE_DEFAULT, 0);
	lv_obj_add_style(ui->screAudioList_labelSongtime1, LV_LABEL_PART_MAIN, &style_screAudioList_labelSongtime1_main);
	lv_obj_set_pos(ui->screAudioList_labelSongtime1, 355, 84);
	lv_obj_set_size(ui->screAudioList_labelSongtime1, 56, 0);

	//Write codes screAudioList_labelSongtime2
	ui->screAudioList_labelSongtime2 = lv_label_create(ui->screAudioList, NULL);
	lv_label_set_text(ui->screAudioList_labelSongtime2, "03:12");
	lv_label_set_long_mode(ui->screAudioList_labelSongtime2, LV_LABEL_LONG_BREAK);
	lv_label_set_align(ui->screAudioList_labelSongtime2, LV_LABEL_ALIGN_CENTER);

	//Write style LV_LABEL_PART_MAIN for screAudioList_labelSongtime2
	static lv_style_t style_screAudioList_labelSongtime2_main;
	lv_style_init(&style_screAudioList_labelSongtime2_main);

	//Write style state: LV_STATE_DEFAULT for style_screAudioList_labelSongtime2_main
	lv_style_set_radius(&style_screAudioList_labelSongtime2_main, LV_STATE_DEFAULT, 0);
	lv_style_set_bg_color(&style_screAudioList_labelSongtime2_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_color(&style_screAudioList_labelSongtime2_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_dir(&style_screAudioList_labelSongtime2_main, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screAudioList_labelSongtime2_main, LV_STATE_DEFAULT, 255);
	lv_style_set_text_color(&style_screAudioList_labelSongtime2_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_text_font(&style_screAudioList_labelSongtime2_main, LV_STATE_DEFAULT, &lv_font_simsun_12);
	lv_style_set_text_letter_space(&style_screAudioList_labelSongtime2_main, LV_STATE_DEFAULT, 2);
	lv_style_set_pad_left(&style_screAudioList_labelSongtime2_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_right(&style_screAudioList_labelSongtime2_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_top(&style_screAudioList_labelSongtime2_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_bottom(&style_screAudioList_labelSongtime2_main, LV_STATE_DEFAULT, 0);
	lv_obj_add_style(ui->screAudioList_labelSongtime2, LV_LABEL_PART_MAIN, &style_screAudioList_labelSongtime2_main);
	lv_obj_set_pos(ui->screAudioList_labelSongtime2, 355, 146);
	lv_obj_set_size(ui->screAudioList_labelSongtime2, 56, 0);

	//Init events for screen
	events_init_screAudioList(ui);
}