/*
 * Copyright 2021 NXP
 * SPDX-License-Identifier: MIT
 */

#include "lvgl/lvgl.h"
#include <stdio.h>
#include "gui_guider.h"
#include "events_init.h"
#include "custom.h"


void setup_scr_screSecurity(lv_ui *ui){

	//Write codes screSecurity
	ui->screSecurity = lv_obj_create(NULL, NULL);

	//Write codes screSecurity_contBackground
	ui->screSecurity_contBackground = lv_cont_create(ui->screSecurity, NULL);

	//Write style LV_CONT_PART_MAIN for screSecurity_contBackground
	static lv_style_t style_screSecurity_contBackground_main;
	lv_style_init(&style_screSecurity_contBackground_main);

	//Write style state: LV_STATE_DEFAULT for style_screSecurity_contBackground_main
	lv_style_set_radius(&style_screSecurity_contBackground_main, LV_STATE_DEFAULT, 0);
	lv_style_set_bg_color(&style_screSecurity_contBackground_main, LV_STATE_DEFAULT, lv_color_make(0xe0, 0xe0, 0xe0));
	lv_style_set_bg_grad_color(&style_screSecurity_contBackground_main, LV_STATE_DEFAULT, lv_color_make(0xf4, 0xf4, 0xf4));
	lv_style_set_bg_grad_dir(&style_screSecurity_contBackground_main, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screSecurity_contBackground_main, LV_STATE_DEFAULT, 255);
	lv_style_set_border_color(&style_screSecurity_contBackground_main, LV_STATE_DEFAULT, lv_color_make(0x99, 0x99, 0x99));
	lv_style_set_border_width(&style_screSecurity_contBackground_main, LV_STATE_DEFAULT, 0);
	lv_style_set_border_opa(&style_screSecurity_contBackground_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_left(&style_screSecurity_contBackground_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_right(&style_screSecurity_contBackground_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_top(&style_screSecurity_contBackground_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_bottom(&style_screSecurity_contBackground_main, LV_STATE_DEFAULT, 0);
	lv_obj_add_style(ui->screSecurity_contBackground, LV_CONT_PART_MAIN, &style_screSecurity_contBackground_main);
	lv_obj_set_pos(ui->screSecurity_contBackground, 0, 0);
	lv_obj_set_size(ui->screSecurity_contBackground, 480, 272);
	lv_obj_set_click(ui->screSecurity_contBackground, false);
	lv_cont_set_layout(ui->screSecurity_contBackground, LV_LAYOUT_OFF);
	lv_cont_set_fit(ui->screSecurity_contBackground, LV_FIT_NONE);

	//Write codes screSecurity_imgHead
	ui->screSecurity_imgHead = lv_img_create(ui->screSecurity, NULL);

	//Write style LV_IMG_PART_MAIN for screSecurity_imgHead
	static lv_style_t style_screSecurity_imgHead_main;
	lv_style_init(&style_screSecurity_imgHead_main);

	//Write style state: LV_STATE_DEFAULT for style_screSecurity_imgHead_main
	lv_style_set_image_recolor(&style_screSecurity_imgHead_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_image_recolor_opa(&style_screSecurity_imgHead_main, LV_STATE_DEFAULT, 0);
	lv_style_set_image_opa(&style_screSecurity_imgHead_main, LV_STATE_DEFAULT, 255);
	lv_obj_add_style(ui->screSecurity_imgHead, LV_IMG_PART_MAIN, &style_screSecurity_imgHead_main);
	lv_obj_set_pos(ui->screSecurity_imgHead, 0, 0);
	lv_obj_set_size(ui->screSecurity_imgHead, 480, 80);
	lv_obj_set_click(ui->screSecurity_imgHead, true);
	lv_img_set_src(ui->screSecurity_imgHead,&_img_header_alpha_480x80);
	lv_img_set_pivot(ui->screSecurity_imgHead, 0,0);
	lv_img_set_angle(ui->screSecurity_imgHead, 0);

	//Write codes screSecurity_imgbtnHome
	ui->screSecurity_imgbtnHome = lv_imgbtn_create(ui->screSecurity, NULL);

	//Write style LV_IMGBTN_PART_MAIN for screSecurity_imgbtnHome
	static lv_style_t style_screSecurity_imgbtnHome_main;
	lv_style_init(&style_screSecurity_imgbtnHome_main);

	//Write style state: LV_STATE_DEFAULT for style_screSecurity_imgbtnHome_main
	lv_style_set_text_color(&style_screSecurity_imgbtnHome_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_image_recolor(&style_screSecurity_imgbtnHome_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_image_recolor_opa(&style_screSecurity_imgbtnHome_main, LV_STATE_DEFAULT, 0);
	lv_style_set_image_opa(&style_screSecurity_imgbtnHome_main, LV_STATE_DEFAULT, 255);
	lv_obj_add_style(ui->screSecurity_imgbtnHome, LV_IMGBTN_PART_MAIN, &style_screSecurity_imgbtnHome_main);
	lv_obj_set_pos(ui->screSecurity_imgbtnHome, 36, 0);
	lv_obj_set_size(ui->screSecurity_imgbtnHome, 55, 50);
	lv_imgbtn_set_src(ui->screSecurity_imgbtnHome,LV_BTN_STATE_RELEASED,&_btn_long_top_house_alpha_55x50);
	lv_imgbtn_set_src(ui->screSecurity_imgbtnHome,LV_BTN_STATE_PRESSED,&_btn_long_top_house_alpha_55x50);

	//Write codes screSecurity_labelSecurity
	ui->screSecurity_labelSecurity = lv_label_create(ui->screSecurity, NULL);
	lv_label_set_text(ui->screSecurity_labelSecurity, "SECURITY");
	lv_label_set_long_mode(ui->screSecurity_labelSecurity, LV_LABEL_LONG_BREAK);
	lv_label_set_align(ui->screSecurity_labelSecurity, LV_LABEL_ALIGN_CENTER);

	//Write style LV_LABEL_PART_MAIN for screSecurity_labelSecurity
	static lv_style_t style_screSecurity_labelSecurity_main;
	lv_style_init(&style_screSecurity_labelSecurity_main);

	//Write style state: LV_STATE_DEFAULT for style_screSecurity_labelSecurity_main
	lv_style_set_radius(&style_screSecurity_labelSecurity_main, LV_STATE_DEFAULT, 0);
	lv_style_set_bg_color(&style_screSecurity_labelSecurity_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_bg_grad_color(&style_screSecurity_labelSecurity_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_bg_grad_dir(&style_screSecurity_labelSecurity_main, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screSecurity_labelSecurity_main, LV_STATE_DEFAULT, 0);
	lv_style_set_text_color(&style_screSecurity_labelSecurity_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_text_font(&style_screSecurity_labelSecurity_main, LV_STATE_DEFAULT, &lv_font_simsun_22);
	lv_style_set_text_letter_space(&style_screSecurity_labelSecurity_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_left(&style_screSecurity_labelSecurity_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_right(&style_screSecurity_labelSecurity_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_top(&style_screSecurity_labelSecurity_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_bottom(&style_screSecurity_labelSecurity_main, LV_STATE_DEFAULT, 0);
	lv_obj_add_style(ui->screSecurity_labelSecurity, LV_LABEL_PART_MAIN, &style_screSecurity_labelSecurity_main);
	lv_obj_set_pos(ui->screSecurity_labelSecurity, 151, 9);
	lv_obj_set_size(ui->screSecurity_labelSecurity, 206, 0);

	//Write codes screSecurity_btnNum1
	ui->screSecurity_btnNum1 = lv_btn_create(ui->screSecurity, NULL);

	//Write style LV_BTN_PART_MAIN for screSecurity_btnNum1
	static lv_style_t style_screSecurity_btnNum1_main;
	lv_style_init(&style_screSecurity_btnNum1_main);

	//Write style state: LV_STATE_DEFAULT for style_screSecurity_btnNum1_main
	lv_style_set_radius(&style_screSecurity_btnNum1_main, LV_STATE_DEFAULT, 10);
	lv_style_set_bg_color(&style_screSecurity_btnNum1_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0xff));
	lv_style_set_bg_grad_color(&style_screSecurity_btnNum1_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0xff));
	lv_style_set_bg_grad_dir(&style_screSecurity_btnNum1_main, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screSecurity_btnNum1_main, LV_STATE_DEFAULT, 255);
	lv_style_set_border_color(&style_screSecurity_btnNum1_main, LV_STATE_DEFAULT, lv_color_make(0x01, 0xa2, 0xb1));
	lv_style_set_border_width(&style_screSecurity_btnNum1_main, LV_STATE_DEFAULT, 2);
	lv_style_set_border_opa(&style_screSecurity_btnNum1_main, LV_STATE_DEFAULT, 255);
	lv_style_set_outline_color(&style_screSecurity_btnNum1_main, LV_STATE_DEFAULT, lv_color_make(0xd4, 0xd7, 0xd9));
	lv_style_set_outline_opa(&style_screSecurity_btnNum1_main, LV_STATE_DEFAULT, 255);
	lv_obj_add_style(ui->screSecurity_btnNum1, LV_BTN_PART_MAIN, &style_screSecurity_btnNum1_main);
	lv_obj_set_pos(ui->screSecurity_btnNum1, 25, 63);
	lv_obj_set_size(ui->screSecurity_btnNum1, 63, 40);
	ui->screSecurity_btnNum1_label = lv_label_create(ui->screSecurity_btnNum1, NULL);
	lv_label_set_text(ui->screSecurity_btnNum1_label, "1");
	lv_obj_set_style_local_text_color(ui->screSecurity_btnNum1_label, LV_LABEL_PART_MAIN, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_obj_set_style_local_text_font(ui->screSecurity_btnNum1_label, LV_LABEL_PART_MAIN, LV_STATE_DEFAULT, &lv_font_simsun_30);

	//Write codes screSecurity_btnNum2
	ui->screSecurity_btnNum2 = lv_btn_create(ui->screSecurity, NULL);

	//Write style LV_BTN_PART_MAIN for screSecurity_btnNum2
	static lv_style_t style_screSecurity_btnNum2_main;
	lv_style_init(&style_screSecurity_btnNum2_main);

	//Write style state: LV_STATE_DEFAULT for style_screSecurity_btnNum2_main
	lv_style_set_radius(&style_screSecurity_btnNum2_main, LV_STATE_DEFAULT, 10);
	lv_style_set_bg_color(&style_screSecurity_btnNum2_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0xff));
	lv_style_set_bg_grad_color(&style_screSecurity_btnNum2_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0xff));
	lv_style_set_bg_grad_dir(&style_screSecurity_btnNum2_main, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screSecurity_btnNum2_main, LV_STATE_DEFAULT, 255);
	lv_style_set_border_color(&style_screSecurity_btnNum2_main, LV_STATE_DEFAULT, lv_color_make(0x01, 0xa2, 0xb1));
	lv_style_set_border_width(&style_screSecurity_btnNum2_main, LV_STATE_DEFAULT, 2);
	lv_style_set_border_opa(&style_screSecurity_btnNum2_main, LV_STATE_DEFAULT, 255);
	lv_style_set_outline_color(&style_screSecurity_btnNum2_main, LV_STATE_DEFAULT, lv_color_make(0xd4, 0xd7, 0xd9));
	lv_style_set_outline_opa(&style_screSecurity_btnNum2_main, LV_STATE_DEFAULT, 255);
	lv_obj_add_style(ui->screSecurity_btnNum2, LV_BTN_PART_MAIN, &style_screSecurity_btnNum2_main);
	lv_obj_set_pos(ui->screSecurity_btnNum2, 108, 62);
	lv_obj_set_size(ui->screSecurity_btnNum2, 63, 40);
	ui->screSecurity_btnNum2_label = lv_label_create(ui->screSecurity_btnNum2, NULL);
	lv_label_set_text(ui->screSecurity_btnNum2_label, "2");
	lv_obj_set_style_local_text_color(ui->screSecurity_btnNum2_label, LV_LABEL_PART_MAIN, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_obj_set_style_local_text_font(ui->screSecurity_btnNum2_label, LV_LABEL_PART_MAIN, LV_STATE_DEFAULT, &lv_font_simsun_30);

	//Write codes screSecurity_btnNum3
	ui->screSecurity_btnNum3 = lv_btn_create(ui->screSecurity, NULL);

	//Write style LV_BTN_PART_MAIN for screSecurity_btnNum3
	static lv_style_t style_screSecurity_btnNum3_main;
	lv_style_init(&style_screSecurity_btnNum3_main);

	//Write style state: LV_STATE_DEFAULT for style_screSecurity_btnNum3_main
	lv_style_set_radius(&style_screSecurity_btnNum3_main, LV_STATE_DEFAULT, 10);
	lv_style_set_bg_color(&style_screSecurity_btnNum3_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0xff));
	lv_style_set_bg_grad_color(&style_screSecurity_btnNum3_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0xff));
	lv_style_set_bg_grad_dir(&style_screSecurity_btnNum3_main, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screSecurity_btnNum3_main, LV_STATE_DEFAULT, 255);
	lv_style_set_border_color(&style_screSecurity_btnNum3_main, LV_STATE_DEFAULT, lv_color_make(0x01, 0xa2, 0xb1));
	lv_style_set_border_width(&style_screSecurity_btnNum3_main, LV_STATE_DEFAULT, 2);
	lv_style_set_border_opa(&style_screSecurity_btnNum3_main, LV_STATE_DEFAULT, 255);
	lv_style_set_outline_color(&style_screSecurity_btnNum3_main, LV_STATE_DEFAULT, lv_color_make(0xd4, 0xd7, 0xd9));
	lv_style_set_outline_opa(&style_screSecurity_btnNum3_main, LV_STATE_DEFAULT, 255);
	lv_obj_add_style(ui->screSecurity_btnNum3, LV_BTN_PART_MAIN, &style_screSecurity_btnNum3_main);
	lv_obj_set_pos(ui->screSecurity_btnNum3, 190, 62);
	lv_obj_set_size(ui->screSecurity_btnNum3, 63, 40);
	ui->screSecurity_btnNum3_label = lv_label_create(ui->screSecurity_btnNum3, NULL);
	lv_label_set_text(ui->screSecurity_btnNum3_label, "3");
	lv_obj_set_style_local_text_color(ui->screSecurity_btnNum3_label, LV_LABEL_PART_MAIN, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_obj_set_style_local_text_font(ui->screSecurity_btnNum3_label, LV_LABEL_PART_MAIN, LV_STATE_DEFAULT, &lv_font_simsun_30);

	//Write codes screSecurity_btnNum4
	ui->screSecurity_btnNum4 = lv_btn_create(ui->screSecurity, NULL);

	//Write style LV_BTN_PART_MAIN for screSecurity_btnNum4
	static lv_style_t style_screSecurity_btnNum4_main;
	lv_style_init(&style_screSecurity_btnNum4_main);

	//Write style state: LV_STATE_DEFAULT for style_screSecurity_btnNum4_main
	lv_style_set_radius(&style_screSecurity_btnNum4_main, LV_STATE_DEFAULT, 10);
	lv_style_set_bg_color(&style_screSecurity_btnNum4_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0xff));
	lv_style_set_bg_grad_color(&style_screSecurity_btnNum4_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0xff));
	lv_style_set_bg_grad_dir(&style_screSecurity_btnNum4_main, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screSecurity_btnNum4_main, LV_STATE_DEFAULT, 255);
	lv_style_set_border_color(&style_screSecurity_btnNum4_main, LV_STATE_DEFAULT, lv_color_make(0x01, 0xa2, 0xb1));
	lv_style_set_border_width(&style_screSecurity_btnNum4_main, LV_STATE_DEFAULT, 2);
	lv_style_set_border_opa(&style_screSecurity_btnNum4_main, LV_STATE_DEFAULT, 255);
	lv_style_set_outline_color(&style_screSecurity_btnNum4_main, LV_STATE_DEFAULT, lv_color_make(0xd4, 0xd7, 0xd9));
	lv_style_set_outline_opa(&style_screSecurity_btnNum4_main, LV_STATE_DEFAULT, 255);
	lv_obj_add_style(ui->screSecurity_btnNum4, LV_BTN_PART_MAIN, &style_screSecurity_btnNum4_main);
	lv_obj_set_pos(ui->screSecurity_btnNum4, 26, 116);
	lv_obj_set_size(ui->screSecurity_btnNum4, 63, 40);
	ui->screSecurity_btnNum4_label = lv_label_create(ui->screSecurity_btnNum4, NULL);
	lv_label_set_text(ui->screSecurity_btnNum4_label, "4");
	lv_obj_set_style_local_text_color(ui->screSecurity_btnNum4_label, LV_LABEL_PART_MAIN, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_obj_set_style_local_text_font(ui->screSecurity_btnNum4_label, LV_LABEL_PART_MAIN, LV_STATE_DEFAULT, &lv_font_simsun_30);

	//Write codes screSecurity_btnNum5
	ui->screSecurity_btnNum5 = lv_btn_create(ui->screSecurity, NULL);

	//Write style LV_BTN_PART_MAIN for screSecurity_btnNum5
	static lv_style_t style_screSecurity_btnNum5_main;
	lv_style_init(&style_screSecurity_btnNum5_main);

	//Write style state: LV_STATE_DEFAULT for style_screSecurity_btnNum5_main
	lv_style_set_radius(&style_screSecurity_btnNum5_main, LV_STATE_DEFAULT, 10);
	lv_style_set_bg_color(&style_screSecurity_btnNum5_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0xff));
	lv_style_set_bg_grad_color(&style_screSecurity_btnNum5_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0xff));
	lv_style_set_bg_grad_dir(&style_screSecurity_btnNum5_main, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screSecurity_btnNum5_main, LV_STATE_DEFAULT, 255);
	lv_style_set_border_color(&style_screSecurity_btnNum5_main, LV_STATE_DEFAULT, lv_color_make(0x01, 0xa2, 0xb1));
	lv_style_set_border_width(&style_screSecurity_btnNum5_main, LV_STATE_DEFAULT, 2);
	lv_style_set_border_opa(&style_screSecurity_btnNum5_main, LV_STATE_DEFAULT, 255);
	lv_style_set_outline_color(&style_screSecurity_btnNum5_main, LV_STATE_DEFAULT, lv_color_make(0xd4, 0xd7, 0xd9));
	lv_style_set_outline_opa(&style_screSecurity_btnNum5_main, LV_STATE_DEFAULT, 255);
	lv_obj_add_style(ui->screSecurity_btnNum5, LV_BTN_PART_MAIN, &style_screSecurity_btnNum5_main);
	lv_obj_set_pos(ui->screSecurity_btnNum5, 107, 116);
	lv_obj_set_size(ui->screSecurity_btnNum5, 63, 40);
	ui->screSecurity_btnNum5_label = lv_label_create(ui->screSecurity_btnNum5, NULL);
	lv_label_set_text(ui->screSecurity_btnNum5_label, "5");
	lv_obj_set_style_local_text_color(ui->screSecurity_btnNum5_label, LV_LABEL_PART_MAIN, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_obj_set_style_local_text_font(ui->screSecurity_btnNum5_label, LV_LABEL_PART_MAIN, LV_STATE_DEFAULT, &lv_font_simsun_30);

	//Write codes screSecurity_btnNum6
	ui->screSecurity_btnNum6 = lv_btn_create(ui->screSecurity, NULL);

	//Write style LV_BTN_PART_MAIN for screSecurity_btnNum6
	static lv_style_t style_screSecurity_btnNum6_main;
	lv_style_init(&style_screSecurity_btnNum6_main);

	//Write style state: LV_STATE_DEFAULT for style_screSecurity_btnNum6_main
	lv_style_set_radius(&style_screSecurity_btnNum6_main, LV_STATE_DEFAULT, 10);
	lv_style_set_bg_color(&style_screSecurity_btnNum6_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0xff));
	lv_style_set_bg_grad_color(&style_screSecurity_btnNum6_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0xff));
	lv_style_set_bg_grad_dir(&style_screSecurity_btnNum6_main, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screSecurity_btnNum6_main, LV_STATE_DEFAULT, 255);
	lv_style_set_border_color(&style_screSecurity_btnNum6_main, LV_STATE_DEFAULT, lv_color_make(0x01, 0xa2, 0xb1));
	lv_style_set_border_width(&style_screSecurity_btnNum6_main, LV_STATE_DEFAULT, 2);
	lv_style_set_border_opa(&style_screSecurity_btnNum6_main, LV_STATE_DEFAULT, 255);
	lv_style_set_outline_color(&style_screSecurity_btnNum6_main, LV_STATE_DEFAULT, lv_color_make(0xd4, 0xd7, 0xd9));
	lv_style_set_outline_opa(&style_screSecurity_btnNum6_main, LV_STATE_DEFAULT, 255);
	lv_obj_add_style(ui->screSecurity_btnNum6, LV_BTN_PART_MAIN, &style_screSecurity_btnNum6_main);
	lv_obj_set_pos(ui->screSecurity_btnNum6, 188, 116);
	lv_obj_set_size(ui->screSecurity_btnNum6, 63, 40);
	ui->screSecurity_btnNum6_label = lv_label_create(ui->screSecurity_btnNum6, NULL);
	lv_label_set_text(ui->screSecurity_btnNum6_label, "6");
	lv_obj_set_style_local_text_color(ui->screSecurity_btnNum6_label, LV_LABEL_PART_MAIN, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_obj_set_style_local_text_font(ui->screSecurity_btnNum6_label, LV_LABEL_PART_MAIN, LV_STATE_DEFAULT, &lv_font_simsun_30);

	//Write codes screSecurity_btnNum7
	ui->screSecurity_btnNum7 = lv_btn_create(ui->screSecurity, NULL);

	//Write style LV_BTN_PART_MAIN for screSecurity_btnNum7
	static lv_style_t style_screSecurity_btnNum7_main;
	lv_style_init(&style_screSecurity_btnNum7_main);

	//Write style state: LV_STATE_DEFAULT for style_screSecurity_btnNum7_main
	lv_style_set_radius(&style_screSecurity_btnNum7_main, LV_STATE_DEFAULT, 10);
	lv_style_set_bg_color(&style_screSecurity_btnNum7_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0xff));
	lv_style_set_bg_grad_color(&style_screSecurity_btnNum7_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0xff));
	lv_style_set_bg_grad_dir(&style_screSecurity_btnNum7_main, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screSecurity_btnNum7_main, LV_STATE_DEFAULT, 255);
	lv_style_set_border_color(&style_screSecurity_btnNum7_main, LV_STATE_DEFAULT, lv_color_make(0x01, 0xa2, 0xb1));
	lv_style_set_border_width(&style_screSecurity_btnNum7_main, LV_STATE_DEFAULT, 2);
	lv_style_set_border_opa(&style_screSecurity_btnNum7_main, LV_STATE_DEFAULT, 255);
	lv_style_set_outline_color(&style_screSecurity_btnNum7_main, LV_STATE_DEFAULT, lv_color_make(0xd4, 0xd7, 0xd9));
	lv_style_set_outline_opa(&style_screSecurity_btnNum7_main, LV_STATE_DEFAULT, 255);
	lv_obj_add_style(ui->screSecurity_btnNum7, LV_BTN_PART_MAIN, &style_screSecurity_btnNum7_main);
	lv_obj_set_pos(ui->screSecurity_btnNum7, 26, 166);
	lv_obj_set_size(ui->screSecurity_btnNum7, 63, 40);
	ui->screSecurity_btnNum7_label = lv_label_create(ui->screSecurity_btnNum7, NULL);
	lv_label_set_text(ui->screSecurity_btnNum7_label, "7");
	lv_obj_set_style_local_text_color(ui->screSecurity_btnNum7_label, LV_LABEL_PART_MAIN, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_obj_set_style_local_text_font(ui->screSecurity_btnNum7_label, LV_LABEL_PART_MAIN, LV_STATE_DEFAULT, &lv_font_simsun_30);

	//Write codes screSecurity_btnNum8
	ui->screSecurity_btnNum8 = lv_btn_create(ui->screSecurity, NULL);

	//Write style LV_BTN_PART_MAIN for screSecurity_btnNum8
	static lv_style_t style_screSecurity_btnNum8_main;
	lv_style_init(&style_screSecurity_btnNum8_main);

	//Write style state: LV_STATE_DEFAULT for style_screSecurity_btnNum8_main
	lv_style_set_radius(&style_screSecurity_btnNum8_main, LV_STATE_DEFAULT, 10);
	lv_style_set_bg_color(&style_screSecurity_btnNum8_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0xff));
	lv_style_set_bg_grad_color(&style_screSecurity_btnNum8_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0xff));
	lv_style_set_bg_grad_dir(&style_screSecurity_btnNum8_main, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screSecurity_btnNum8_main, LV_STATE_DEFAULT, 255);
	lv_style_set_border_color(&style_screSecurity_btnNum8_main, LV_STATE_DEFAULT, lv_color_make(0x01, 0xa2, 0xb1));
	lv_style_set_border_width(&style_screSecurity_btnNum8_main, LV_STATE_DEFAULT, 2);
	lv_style_set_border_opa(&style_screSecurity_btnNum8_main, LV_STATE_DEFAULT, 255);
	lv_style_set_outline_color(&style_screSecurity_btnNum8_main, LV_STATE_DEFAULT, lv_color_make(0xd4, 0xd7, 0xd9));
	lv_style_set_outline_opa(&style_screSecurity_btnNum8_main, LV_STATE_DEFAULT, 255);
	lv_obj_add_style(ui->screSecurity_btnNum8, LV_BTN_PART_MAIN, &style_screSecurity_btnNum8_main);
	lv_obj_set_pos(ui->screSecurity_btnNum8, 109, 166);
	lv_obj_set_size(ui->screSecurity_btnNum8, 63, 40);
	ui->screSecurity_btnNum8_label = lv_label_create(ui->screSecurity_btnNum8, NULL);
	lv_label_set_text(ui->screSecurity_btnNum8_label, "8");
	lv_obj_set_style_local_text_color(ui->screSecurity_btnNum8_label, LV_LABEL_PART_MAIN, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_obj_set_style_local_text_font(ui->screSecurity_btnNum8_label, LV_LABEL_PART_MAIN, LV_STATE_DEFAULT, &lv_font_simsun_30);

	//Write codes screSecurity_btnNum9
	ui->screSecurity_btnNum9 = lv_btn_create(ui->screSecurity, NULL);

	//Write style LV_BTN_PART_MAIN for screSecurity_btnNum9
	static lv_style_t style_screSecurity_btnNum9_main;
	lv_style_init(&style_screSecurity_btnNum9_main);

	//Write style state: LV_STATE_DEFAULT for style_screSecurity_btnNum9_main
	lv_style_set_radius(&style_screSecurity_btnNum9_main, LV_STATE_DEFAULT, 10);
	lv_style_set_bg_color(&style_screSecurity_btnNum9_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0xff));
	lv_style_set_bg_grad_color(&style_screSecurity_btnNum9_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0xff));
	lv_style_set_bg_grad_dir(&style_screSecurity_btnNum9_main, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screSecurity_btnNum9_main, LV_STATE_DEFAULT, 255);
	lv_style_set_border_color(&style_screSecurity_btnNum9_main, LV_STATE_DEFAULT, lv_color_make(0x01, 0xa2, 0xb1));
	lv_style_set_border_width(&style_screSecurity_btnNum9_main, LV_STATE_DEFAULT, 2);
	lv_style_set_border_opa(&style_screSecurity_btnNum9_main, LV_STATE_DEFAULT, 255);
	lv_style_set_outline_color(&style_screSecurity_btnNum9_main, LV_STATE_DEFAULT, lv_color_make(0xd4, 0xd7, 0xd9));
	lv_style_set_outline_opa(&style_screSecurity_btnNum9_main, LV_STATE_DEFAULT, 255);
	lv_obj_add_style(ui->screSecurity_btnNum9, LV_BTN_PART_MAIN, &style_screSecurity_btnNum9_main);
	lv_obj_set_pos(ui->screSecurity_btnNum9, 187, 167);
	lv_obj_set_size(ui->screSecurity_btnNum9, 63, 40);
	ui->screSecurity_btnNum9_label = lv_label_create(ui->screSecurity_btnNum9, NULL);
	lv_label_set_text(ui->screSecurity_btnNum9_label, "9");
	lv_obj_set_style_local_text_color(ui->screSecurity_btnNum9_label, LV_LABEL_PART_MAIN, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_obj_set_style_local_text_font(ui->screSecurity_btnNum9_label, LV_LABEL_PART_MAIN, LV_STATE_DEFAULT, &lv_font_simsun_30);

	//Write codes screSecurity_btnNumDel
	ui->screSecurity_btnNumDel = lv_btn_create(ui->screSecurity, NULL);

	//Write style LV_BTN_PART_MAIN for screSecurity_btnNumDel
	static lv_style_t style_screSecurity_btnNumDel_main;
	lv_style_init(&style_screSecurity_btnNumDel_main);

	//Write style state: LV_STATE_DEFAULT for style_screSecurity_btnNumDel_main
	lv_style_set_radius(&style_screSecurity_btnNumDel_main, LV_STATE_DEFAULT, 10);
	lv_style_set_bg_color(&style_screSecurity_btnNumDel_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0xff));
	lv_style_set_bg_grad_color(&style_screSecurity_btnNumDel_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0xff));
	lv_style_set_bg_grad_dir(&style_screSecurity_btnNumDel_main, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screSecurity_btnNumDel_main, LV_STATE_DEFAULT, 255);
	lv_style_set_border_color(&style_screSecurity_btnNumDel_main, LV_STATE_DEFAULT, lv_color_make(0x01, 0xa2, 0xb1));
	lv_style_set_border_width(&style_screSecurity_btnNumDel_main, LV_STATE_DEFAULT, 2);
	lv_style_set_border_opa(&style_screSecurity_btnNumDel_main, LV_STATE_DEFAULT, 255);
	lv_style_set_outline_color(&style_screSecurity_btnNumDel_main, LV_STATE_DEFAULT, lv_color_make(0xd4, 0xd7, 0xd9));
	lv_style_set_outline_opa(&style_screSecurity_btnNumDel_main, LV_STATE_DEFAULT, 255);
	lv_obj_add_style(ui->screSecurity_btnNumDel, LV_BTN_PART_MAIN, &style_screSecurity_btnNumDel_main);
	lv_obj_set_pos(ui->screSecurity_btnNumDel, 26, 218);
	lv_obj_set_size(ui->screSecurity_btnNumDel, 63, 40);
	ui->screSecurity_btnNumDel_label = lv_label_create(ui->screSecurity_btnNumDel, NULL);
	lv_label_set_text(ui->screSecurity_btnNumDel_label, "Del");
	lv_obj_set_style_local_text_color(ui->screSecurity_btnNumDel_label, LV_LABEL_PART_MAIN, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_obj_set_style_local_text_font(ui->screSecurity_btnNumDel_label, LV_LABEL_PART_MAIN, LV_STATE_DEFAULT, &lv_font_simsun_26);

	//Write codes screSecurity_btnNum0
	ui->screSecurity_btnNum0 = lv_btn_create(ui->screSecurity, NULL);

	//Write style LV_BTN_PART_MAIN for screSecurity_btnNum0
	static lv_style_t style_screSecurity_btnNum0_main;
	lv_style_init(&style_screSecurity_btnNum0_main);

	//Write style state: LV_STATE_DEFAULT for style_screSecurity_btnNum0_main
	lv_style_set_radius(&style_screSecurity_btnNum0_main, LV_STATE_DEFAULT, 10);
	lv_style_set_bg_color(&style_screSecurity_btnNum0_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0xff));
	lv_style_set_bg_grad_color(&style_screSecurity_btnNum0_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0xff));
	lv_style_set_bg_grad_dir(&style_screSecurity_btnNum0_main, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screSecurity_btnNum0_main, LV_STATE_DEFAULT, 255);
	lv_style_set_border_color(&style_screSecurity_btnNum0_main, LV_STATE_DEFAULT, lv_color_make(0x01, 0xa2, 0xb1));
	lv_style_set_border_width(&style_screSecurity_btnNum0_main, LV_STATE_DEFAULT, 2);
	lv_style_set_border_opa(&style_screSecurity_btnNum0_main, LV_STATE_DEFAULT, 255);
	lv_style_set_outline_color(&style_screSecurity_btnNum0_main, LV_STATE_DEFAULT, lv_color_make(0xd4, 0xd7, 0xd9));
	lv_style_set_outline_opa(&style_screSecurity_btnNum0_main, LV_STATE_DEFAULT, 255);
	lv_obj_add_style(ui->screSecurity_btnNum0, LV_BTN_PART_MAIN, &style_screSecurity_btnNum0_main);
	lv_obj_set_pos(ui->screSecurity_btnNum0, 109, 219);
	lv_obj_set_size(ui->screSecurity_btnNum0, 63, 40);
	ui->screSecurity_btnNum0_label = lv_label_create(ui->screSecurity_btnNum0, NULL);
	lv_label_set_text(ui->screSecurity_btnNum0_label, "0");
	lv_obj_set_style_local_text_color(ui->screSecurity_btnNum0_label, LV_LABEL_PART_MAIN, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_obj_set_style_local_text_font(ui->screSecurity_btnNum0_label, LV_LABEL_PART_MAIN, LV_STATE_DEFAULT, &lv_font_simsun_30);

	//Write codes screSecurity_btnNumOk
	ui->screSecurity_btnNumOk = lv_btn_create(ui->screSecurity, NULL);

	//Write style LV_BTN_PART_MAIN for screSecurity_btnNumOk
	static lv_style_t style_screSecurity_btnNumOk_main;
	lv_style_init(&style_screSecurity_btnNumOk_main);

	//Write style state: LV_STATE_DEFAULT for style_screSecurity_btnNumOk_main
	lv_style_set_radius(&style_screSecurity_btnNumOk_main, LV_STATE_DEFAULT, 10);
	lv_style_set_bg_color(&style_screSecurity_btnNumOk_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0xff));
	lv_style_set_bg_grad_color(&style_screSecurity_btnNumOk_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0xff));
	lv_style_set_bg_grad_dir(&style_screSecurity_btnNumOk_main, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screSecurity_btnNumOk_main, LV_STATE_DEFAULT, 255);
	lv_style_set_border_color(&style_screSecurity_btnNumOk_main, LV_STATE_DEFAULT, lv_color_make(0x01, 0xa2, 0xb1));
	lv_style_set_border_width(&style_screSecurity_btnNumOk_main, LV_STATE_DEFAULT, 2);
	lv_style_set_border_opa(&style_screSecurity_btnNumOk_main, LV_STATE_DEFAULT, 255);
	lv_style_set_outline_color(&style_screSecurity_btnNumOk_main, LV_STATE_DEFAULT, lv_color_make(0xd4, 0xd7, 0xd9));
	lv_style_set_outline_opa(&style_screSecurity_btnNumOk_main, LV_STATE_DEFAULT, 255);
	lv_obj_add_style(ui->screSecurity_btnNumOk, LV_BTN_PART_MAIN, &style_screSecurity_btnNumOk_main);
	lv_obj_set_pos(ui->screSecurity_btnNumOk, 189, 219);
	lv_obj_set_size(ui->screSecurity_btnNumOk, 63, 40);
	ui->screSecurity_btnNumOk_label = lv_label_create(ui->screSecurity_btnNumOk, NULL);
	lv_label_set_text(ui->screSecurity_btnNumOk_label, "OK");
	lv_obj_set_style_local_text_color(ui->screSecurity_btnNumOk_label, LV_LABEL_PART_MAIN, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_obj_set_style_local_text_font(ui->screSecurity_btnNumOk_label, LV_LABEL_PART_MAIN, LV_STATE_DEFAULT, &lv_font_simsun_26);

	//Write codes screSecurity_labelEnterPinStr
	ui->screSecurity_labelEnterPinStr = lv_label_create(ui->screSecurity, NULL);
	lv_label_set_text(ui->screSecurity_labelEnterPinStr, "Enter pin to arm system");
	lv_label_set_long_mode(ui->screSecurity_labelEnterPinStr, LV_LABEL_LONG_BREAK);
	lv_label_set_align(ui->screSecurity_labelEnterPinStr, LV_LABEL_ALIGN_CENTER);

	//Write style LV_LABEL_PART_MAIN for screSecurity_labelEnterPinStr
	static lv_style_t style_screSecurity_labelEnterPinStr_main;
	lv_style_init(&style_screSecurity_labelEnterPinStr_main);

	//Write style state: LV_STATE_DEFAULT for style_screSecurity_labelEnterPinStr_main
	lv_style_set_radius(&style_screSecurity_labelEnterPinStr_main, LV_STATE_DEFAULT, 0);
	lv_style_set_bg_color(&style_screSecurity_labelEnterPinStr_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_color(&style_screSecurity_labelEnterPinStr_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_dir(&style_screSecurity_labelEnterPinStr_main, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screSecurity_labelEnterPinStr_main, LV_STATE_DEFAULT, 0);
	lv_style_set_text_color(&style_screSecurity_labelEnterPinStr_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_text_font(&style_screSecurity_labelEnterPinStr_main, LV_STATE_DEFAULT, &lv_font_simsun_26);
	lv_style_set_text_letter_space(&style_screSecurity_labelEnterPinStr_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_left(&style_screSecurity_labelEnterPinStr_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_right(&style_screSecurity_labelEnterPinStr_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_top(&style_screSecurity_labelEnterPinStr_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_bottom(&style_screSecurity_labelEnterPinStr_main, LV_STATE_DEFAULT, 0);
	lv_obj_add_style(ui->screSecurity_labelEnterPinStr, LV_LABEL_PART_MAIN, &style_screSecurity_labelEnterPinStr_main);
	lv_obj_set_pos(ui->screSecurity_labelEnterPinStr, 277, 92);
	lv_obj_set_size(ui->screSecurity_labelEnterPinStr, 179, 0);

	//Write codes screSecurity_linePinLine1
	ui->screSecurity_linePinLine1 = lv_line_create(ui->screSecurity, NULL);

	//Write style LV_LINE_PART_MAIN for screSecurity_linePinLine1
	static lv_style_t style_screSecurity_linePinLine1_main;
	lv_style_init(&style_screSecurity_linePinLine1_main);

	//Write style state: LV_STATE_DEFAULT for style_screSecurity_linePinLine1_main
	lv_style_set_line_color(&style_screSecurity_linePinLine1_main, LV_STATE_DEFAULT, lv_color_make(0x01, 0xa2, 0xb1));
	lv_style_set_line_width(&style_screSecurity_linePinLine1_main, LV_STATE_DEFAULT, 3);
	lv_obj_add_style(ui->screSecurity_linePinLine1, LV_LINE_PART_MAIN, &style_screSecurity_linePinLine1_main);
	lv_obj_set_pos(ui->screSecurity_linePinLine1, 283, 194);
	lv_obj_set_size(ui->screSecurity_linePinLine1, 25, 7);
	static lv_point_t screSecurity_linePinLine1[] ={{0,0},{25,0}};
	lv_line_set_points(ui->screSecurity_linePinLine1,screSecurity_linePinLine1,2);

	//Write codes screSecurity_linePinLine2
	ui->screSecurity_linePinLine2 = lv_line_create(ui->screSecurity, NULL);

	//Write style LV_LINE_PART_MAIN for screSecurity_linePinLine2
	static lv_style_t style_screSecurity_linePinLine2_main;
	lv_style_init(&style_screSecurity_linePinLine2_main);

	//Write style state: LV_STATE_DEFAULT for style_screSecurity_linePinLine2_main
	lv_style_set_line_color(&style_screSecurity_linePinLine2_main, LV_STATE_DEFAULT, lv_color_make(0x01, 0xa2, 0xb1));
	lv_style_set_line_width(&style_screSecurity_linePinLine2_main, LV_STATE_DEFAULT, 3);
	lv_obj_add_style(ui->screSecurity_linePinLine2, LV_LINE_PART_MAIN, &style_screSecurity_linePinLine2_main);
	lv_obj_set_pos(ui->screSecurity_linePinLine2, 327, 195);
	lv_obj_set_size(ui->screSecurity_linePinLine2, 25, 7);
	static lv_point_t screSecurity_linePinLine2[] ={{0,0},{25,0}};
	lv_line_set_points(ui->screSecurity_linePinLine2,screSecurity_linePinLine2,2);

	//Write codes screSecurity_linePinLine3
	ui->screSecurity_linePinLine3 = lv_line_create(ui->screSecurity, NULL);

	//Write style LV_LINE_PART_MAIN for screSecurity_linePinLine3
	static lv_style_t style_screSecurity_linePinLine3_main;
	lv_style_init(&style_screSecurity_linePinLine3_main);

	//Write style state: LV_STATE_DEFAULT for style_screSecurity_linePinLine3_main
	lv_style_set_line_color(&style_screSecurity_linePinLine3_main, LV_STATE_DEFAULT, lv_color_make(0x01, 0xa2, 0xb1));
	lv_style_set_line_width(&style_screSecurity_linePinLine3_main, LV_STATE_DEFAULT, 3);
	lv_obj_add_style(ui->screSecurity_linePinLine3, LV_LINE_PART_MAIN, &style_screSecurity_linePinLine3_main);
	lv_obj_set_pos(ui->screSecurity_linePinLine3, 368, 195);
	lv_obj_set_size(ui->screSecurity_linePinLine3, 25, 7);
	static lv_point_t screSecurity_linePinLine3[] ={{0,0},{25,0}};
	lv_line_set_points(ui->screSecurity_linePinLine3,screSecurity_linePinLine3,2);

	//Write codes screSecurity_linePinLine4
	ui->screSecurity_linePinLine4 = lv_line_create(ui->screSecurity, NULL);

	//Write style LV_LINE_PART_MAIN for screSecurity_linePinLine4
	static lv_style_t style_screSecurity_linePinLine4_main;
	lv_style_init(&style_screSecurity_linePinLine4_main);

	//Write style state: LV_STATE_DEFAULT for style_screSecurity_linePinLine4_main
	lv_style_set_line_color(&style_screSecurity_linePinLine4_main, LV_STATE_DEFAULT, lv_color_make(0x01, 0xa2, 0xb1));
	lv_style_set_line_width(&style_screSecurity_linePinLine4_main, LV_STATE_DEFAULT, 3);
	lv_obj_add_style(ui->screSecurity_linePinLine4, LV_LINE_PART_MAIN, &style_screSecurity_linePinLine4_main);
	lv_obj_set_pos(ui->screSecurity_linePinLine4, 412, 195);
	lv_obj_set_size(ui->screSecurity_linePinLine4, 25, 7);
	static lv_point_t screSecurity_linePinLine4[] ={{0,0},{25,0}};
	lv_line_set_points(ui->screSecurity_linePinLine4,screSecurity_linePinLine4,2);

	//Write codes screSecurity_labelPinNum1
	ui->screSecurity_labelPinNum1 = lv_label_create(ui->screSecurity, NULL);
	lv_label_set_text(ui->screSecurity_labelPinNum1, "");
	lv_label_set_long_mode(ui->screSecurity_labelPinNum1, LV_LABEL_LONG_BREAK);
	lv_label_set_align(ui->screSecurity_labelPinNum1, LV_LABEL_ALIGN_CENTER);

	//Write style LV_LABEL_PART_MAIN for screSecurity_labelPinNum1
	static lv_style_t style_screSecurity_labelPinNum1_main;
	lv_style_init(&style_screSecurity_labelPinNum1_main);

	//Write style state: LV_STATE_DEFAULT for style_screSecurity_labelPinNum1_main
	lv_style_set_radius(&style_screSecurity_labelPinNum1_main, LV_STATE_DEFAULT, 0);
	lv_style_set_bg_color(&style_screSecurity_labelPinNum1_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_color(&style_screSecurity_labelPinNum1_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_dir(&style_screSecurity_labelPinNum1_main, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screSecurity_labelPinNum1_main, LV_STATE_DEFAULT, 0);
	lv_style_set_text_color(&style_screSecurity_labelPinNum1_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_text_letter_space(&style_screSecurity_labelPinNum1_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_left(&style_screSecurity_labelPinNum1_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_right(&style_screSecurity_labelPinNum1_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_top(&style_screSecurity_labelPinNum1_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_bottom(&style_screSecurity_labelPinNum1_main, LV_STATE_DEFAULT, 0);
	lv_obj_add_style(ui->screSecurity_labelPinNum1, LV_LABEL_PART_MAIN, &style_screSecurity_labelPinNum1_main);
	lv_obj_set_pos(ui->screSecurity_labelPinNum1, 287, 171);
	lv_obj_set_size(ui->screSecurity_labelPinNum1, 20, 0);

	//Write codes screSecurity_labelPinNum2
	ui->screSecurity_labelPinNum2 = lv_label_create(ui->screSecurity, NULL);
	lv_label_set_text(ui->screSecurity_labelPinNum2, "");
	lv_label_set_long_mode(ui->screSecurity_labelPinNum2, LV_LABEL_LONG_BREAK);
	lv_label_set_align(ui->screSecurity_labelPinNum2, LV_LABEL_ALIGN_CENTER);

	//Write style LV_LABEL_PART_MAIN for screSecurity_labelPinNum2
	static lv_style_t style_screSecurity_labelPinNum2_main;
	lv_style_init(&style_screSecurity_labelPinNum2_main);

	//Write style state: LV_STATE_DEFAULT for style_screSecurity_labelPinNum2_main
	lv_style_set_radius(&style_screSecurity_labelPinNum2_main, LV_STATE_DEFAULT, 0);
	lv_style_set_bg_color(&style_screSecurity_labelPinNum2_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_color(&style_screSecurity_labelPinNum2_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_dir(&style_screSecurity_labelPinNum2_main, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screSecurity_labelPinNum2_main, LV_STATE_DEFAULT, 0);
	lv_style_set_text_color(&style_screSecurity_labelPinNum2_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_text_letter_space(&style_screSecurity_labelPinNum2_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_left(&style_screSecurity_labelPinNum2_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_right(&style_screSecurity_labelPinNum2_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_top(&style_screSecurity_labelPinNum2_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_bottom(&style_screSecurity_labelPinNum2_main, LV_STATE_DEFAULT, 0);
	lv_obj_add_style(ui->screSecurity_labelPinNum2, LV_LABEL_PART_MAIN, &style_screSecurity_labelPinNum2_main);
	lv_obj_set_pos(ui->screSecurity_labelPinNum2, 329, 171);
	lv_obj_set_size(ui->screSecurity_labelPinNum2, 20, 0);

	//Write codes screSecurity_labelPinNum3
	ui->screSecurity_labelPinNum3 = lv_label_create(ui->screSecurity, NULL);
	lv_label_set_text(ui->screSecurity_labelPinNum3, "");
	lv_label_set_long_mode(ui->screSecurity_labelPinNum3, LV_LABEL_LONG_BREAK);
	lv_label_set_align(ui->screSecurity_labelPinNum3, LV_LABEL_ALIGN_CENTER);

	//Write style LV_LABEL_PART_MAIN for screSecurity_labelPinNum3
	static lv_style_t style_screSecurity_labelPinNum3_main;
	lv_style_init(&style_screSecurity_labelPinNum3_main);

	//Write style state: LV_STATE_DEFAULT for style_screSecurity_labelPinNum3_main
	lv_style_set_radius(&style_screSecurity_labelPinNum3_main, LV_STATE_DEFAULT, 0);
	lv_style_set_bg_color(&style_screSecurity_labelPinNum3_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_color(&style_screSecurity_labelPinNum3_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_dir(&style_screSecurity_labelPinNum3_main, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screSecurity_labelPinNum3_main, LV_STATE_DEFAULT, 0);
	lv_style_set_text_color(&style_screSecurity_labelPinNum3_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_text_letter_space(&style_screSecurity_labelPinNum3_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_left(&style_screSecurity_labelPinNum3_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_right(&style_screSecurity_labelPinNum3_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_top(&style_screSecurity_labelPinNum3_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_bottom(&style_screSecurity_labelPinNum3_main, LV_STATE_DEFAULT, 0);
	lv_obj_add_style(ui->screSecurity_labelPinNum3, LV_LABEL_PART_MAIN, &style_screSecurity_labelPinNum3_main);
	lv_obj_set_pos(ui->screSecurity_labelPinNum3, 370, 171);
	lv_obj_set_size(ui->screSecurity_labelPinNum3, 20, 0);

	//Write codes screSecurity_labelPinNum4
	ui->screSecurity_labelPinNum4 = lv_label_create(ui->screSecurity, NULL);
	lv_label_set_text(ui->screSecurity_labelPinNum4, "");
	lv_label_set_long_mode(ui->screSecurity_labelPinNum4, LV_LABEL_LONG_BREAK);
	lv_label_set_align(ui->screSecurity_labelPinNum4, LV_LABEL_ALIGN_CENTER);

	//Write style LV_LABEL_PART_MAIN for screSecurity_labelPinNum4
	static lv_style_t style_screSecurity_labelPinNum4_main;
	lv_style_init(&style_screSecurity_labelPinNum4_main);

	//Write style state: LV_STATE_DEFAULT for style_screSecurity_labelPinNum4_main
	lv_style_set_radius(&style_screSecurity_labelPinNum4_main, LV_STATE_DEFAULT, 0);
	lv_style_set_bg_color(&style_screSecurity_labelPinNum4_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_color(&style_screSecurity_labelPinNum4_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_dir(&style_screSecurity_labelPinNum4_main, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screSecurity_labelPinNum4_main, LV_STATE_DEFAULT, 0);
	lv_style_set_text_color(&style_screSecurity_labelPinNum4_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_text_letter_space(&style_screSecurity_labelPinNum4_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_left(&style_screSecurity_labelPinNum4_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_right(&style_screSecurity_labelPinNum4_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_top(&style_screSecurity_labelPinNum4_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_bottom(&style_screSecurity_labelPinNum4_main, LV_STATE_DEFAULT, 0);
	lv_obj_add_style(ui->screSecurity_labelPinNum4, LV_LABEL_PART_MAIN, &style_screSecurity_labelPinNum4_main);
	lv_obj_set_pos(ui->screSecurity_labelPinNum4, 414, 171);
	lv_obj_set_size(ui->screSecurity_labelPinNum4, 20, 0);

	//Write codes screSecurity_labelTime
	ui->screSecurity_labelTime = lv_label_create(ui->screSecurity, NULL);
	lv_label_set_text(ui->screSecurity_labelTime, "10:54 AM");
	lv_label_set_long_mode(ui->screSecurity_labelTime, LV_LABEL_LONG_BREAK);
	lv_label_set_align(ui->screSecurity_labelTime, LV_LABEL_ALIGN_CENTER);

	//Write style LV_LABEL_PART_MAIN for screSecurity_labelTime
	static lv_style_t style_screSecurity_labelTime_main;
	lv_style_init(&style_screSecurity_labelTime_main);

	//Write style state: LV_STATE_DEFAULT for style_screSecurity_labelTime_main
	lv_style_set_radius(&style_screSecurity_labelTime_main, LV_STATE_DEFAULT, 0);
	lv_style_set_bg_color(&style_screSecurity_labelTime_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_bg_grad_color(&style_screSecurity_labelTime_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_dir(&style_screSecurity_labelTime_main, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screSecurity_labelTime_main, LV_STATE_DEFAULT, 0);
	lv_style_set_text_color(&style_screSecurity_labelTime_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_text_font(&style_screSecurity_labelTime_main, LV_STATE_DEFAULT, &lv_font_simsun_20);
	lv_style_set_text_letter_space(&style_screSecurity_labelTime_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_left(&style_screSecurity_labelTime_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_right(&style_screSecurity_labelTime_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_top(&style_screSecurity_labelTime_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_bottom(&style_screSecurity_labelTime_main, LV_STATE_DEFAULT, 0);
	lv_obj_add_style(ui->screSecurity_labelTime, LV_LABEL_PART_MAIN, &style_screSecurity_labelTime_main);
	lv_obj_set_pos(ui->screSecurity_labelTime, 380, 7);
	lv_obj_set_size(ui->screSecurity_labelTime, 96, 0);

	//Init events for screen
	events_init_screSecurity(ui);
}