/*
 * Copyright 2021 NXP
 * SPDX-License-Identifier: MIT
 */

#include "lvgl/lvgl.h"
#include <stdio.h>
#include "gui_guider.h"
#include "events_init.h"
#include "custom.h"


void setup_scr_screSecurityhome(lv_ui *ui){

	//Write codes screSecurityhome
	ui->screSecurityhome = lv_obj_create(NULL, NULL);

	//Write codes screSecurityhome_contBackground
	ui->screSecurityhome_contBackground = lv_cont_create(ui->screSecurityhome, NULL);

	//Write style LV_CONT_PART_MAIN for screSecurityhome_contBackground
	static lv_style_t style_screSecurityhome_contBackground_main;
	lv_style_init(&style_screSecurityhome_contBackground_main);

	//Write style state: LV_STATE_DEFAULT for style_screSecurityhome_contBackground_main
	lv_style_set_radius(&style_screSecurityhome_contBackground_main, LV_STATE_DEFAULT, 0);
	lv_style_set_bg_color(&style_screSecurityhome_contBackground_main, LV_STATE_DEFAULT, lv_color_make(0xe0, 0xe0, 0xe0));
	lv_style_set_bg_grad_color(&style_screSecurityhome_contBackground_main, LV_STATE_DEFAULT, lv_color_make(0xf4, 0xf4, 0xf4));
	lv_style_set_bg_grad_dir(&style_screSecurityhome_contBackground_main, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screSecurityhome_contBackground_main, LV_STATE_DEFAULT, 255);
	lv_style_set_border_color(&style_screSecurityhome_contBackground_main, LV_STATE_DEFAULT, lv_color_make(0x99, 0x99, 0x99));
	lv_style_set_border_width(&style_screSecurityhome_contBackground_main, LV_STATE_DEFAULT, 0);
	lv_style_set_border_opa(&style_screSecurityhome_contBackground_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_left(&style_screSecurityhome_contBackground_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_right(&style_screSecurityhome_contBackground_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_top(&style_screSecurityhome_contBackground_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_bottom(&style_screSecurityhome_contBackground_main, LV_STATE_DEFAULT, 0);
	lv_obj_add_style(ui->screSecurityhome_contBackground, LV_CONT_PART_MAIN, &style_screSecurityhome_contBackground_main);
	lv_obj_set_pos(ui->screSecurityhome_contBackground, 0, 0);
	lv_obj_set_size(ui->screSecurityhome_contBackground, 480, 272);
	lv_obj_set_click(ui->screSecurityhome_contBackground, false);
	lv_cont_set_layout(ui->screSecurityhome_contBackground, LV_LAYOUT_OFF);
	lv_cont_set_fit(ui->screSecurityhome_contBackground, LV_FIT_NONE);

	//Write codes screSecurityhome_btnArm
	ui->screSecurityhome_btnArm = lv_btn_create(ui->screSecurityhome, NULL);

	//Write style LV_BTN_PART_MAIN for screSecurityhome_btnArm
	static lv_style_t style_screSecurityhome_btnArm_main;
	lv_style_init(&style_screSecurityhome_btnArm_main);

	//Write style state: LV_STATE_DEFAULT for style_screSecurityhome_btnArm_main
	lv_style_set_radius(&style_screSecurityhome_btnArm_main, LV_STATE_DEFAULT, 50);
	lv_style_set_bg_color(&style_screSecurityhome_btnArm_main, LV_STATE_DEFAULT, lv_color_make(0x32, 0x32, 0xfa));
	lv_style_set_bg_grad_color(&style_screSecurityhome_btnArm_main, LV_STATE_DEFAULT, lv_color_make(0x32, 0x32, 0xfa));
	lv_style_set_bg_grad_dir(&style_screSecurityhome_btnArm_main, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screSecurityhome_btnArm_main, LV_STATE_DEFAULT, 255);
	lv_style_set_border_color(&style_screSecurityhome_btnArm_main, LV_STATE_DEFAULT, lv_color_make(0x01, 0xa2, 0xb1));
	lv_style_set_border_width(&style_screSecurityhome_btnArm_main, LV_STATE_DEFAULT, 2);
	lv_style_set_border_opa(&style_screSecurityhome_btnArm_main, LV_STATE_DEFAULT, 255);
	lv_style_set_outline_color(&style_screSecurityhome_btnArm_main, LV_STATE_DEFAULT, lv_color_make(0xd4, 0xd7, 0xd9));
	lv_style_set_outline_opa(&style_screSecurityhome_btnArm_main, LV_STATE_DEFAULT, 255);
	lv_obj_add_style(ui->screSecurityhome_btnArm, LV_BTN_PART_MAIN, &style_screSecurityhome_btnArm_main);
	lv_obj_set_pos(ui->screSecurityhome_btnArm, 269, 81);
	lv_obj_set_size(ui->screSecurityhome_btnArm, 132, 61);
	ui->screSecurityhome_btnArm_label = lv_label_create(ui->screSecurityhome_btnArm, NULL);
	lv_label_set_text(ui->screSecurityhome_btnArm_label, "ARM");
	lv_obj_set_style_local_text_color(ui->screSecurityhome_btnArm_label, LV_LABEL_PART_MAIN, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_obj_set_style_local_text_font(ui->screSecurityhome_btnArm_label, LV_LABEL_PART_MAIN, LV_STATE_DEFAULT, &lv_font_simsun_28);

	//Write codes screSecurityhome_img_1
	ui->screSecurityhome_img_1 = lv_img_create(ui->screSecurityhome, NULL);

	//Write style LV_IMG_PART_MAIN for screSecurityhome_img_1
	static lv_style_t style_screSecurityhome_img_1_main;
	lv_style_init(&style_screSecurityhome_img_1_main);

	//Write style state: LV_STATE_DEFAULT for style_screSecurityhome_img_1_main
	lv_style_set_image_recolor(&style_screSecurityhome_img_1_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_image_recolor_opa(&style_screSecurityhome_img_1_main, LV_STATE_DEFAULT, 0);
	lv_style_set_image_opa(&style_screSecurityhome_img_1_main, LV_STATE_DEFAULT, 255);
	lv_obj_add_style(ui->screSecurityhome_img_1, LV_IMG_PART_MAIN, &style_screSecurityhome_img_1_main);
	lv_obj_set_pos(ui->screSecurityhome_img_1, 0, 0);
	lv_obj_set_size(ui->screSecurityhome_img_1, 480, 80);
	lv_obj_set_click(ui->screSecurityhome_img_1, true);
	lv_img_set_src(ui->screSecurityhome_img_1,&_img_header_alpha_480x80);
	lv_img_set_pivot(ui->screSecurityhome_img_1, 0,0);
	lv_img_set_angle(ui->screSecurityhome_img_1, 0);

	//Write codes screSecurityhome_imgbtnHome
	ui->screSecurityhome_imgbtnHome = lv_imgbtn_create(ui->screSecurityhome, NULL);

	//Write style LV_IMGBTN_PART_MAIN for screSecurityhome_imgbtnHome
	static lv_style_t style_screSecurityhome_imgbtnHome_main;
	lv_style_init(&style_screSecurityhome_imgbtnHome_main);

	//Write style state: LV_STATE_DEFAULT for style_screSecurityhome_imgbtnHome_main
	lv_style_set_text_color(&style_screSecurityhome_imgbtnHome_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_image_recolor(&style_screSecurityhome_imgbtnHome_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_image_recolor_opa(&style_screSecurityhome_imgbtnHome_main, LV_STATE_DEFAULT, 0);
	lv_style_set_image_opa(&style_screSecurityhome_imgbtnHome_main, LV_STATE_DEFAULT, 255);
	lv_obj_add_style(ui->screSecurityhome_imgbtnHome, LV_IMGBTN_PART_MAIN, &style_screSecurityhome_imgbtnHome_main);
	lv_obj_set_pos(ui->screSecurityhome_imgbtnHome, 36, 0);
	lv_obj_set_size(ui->screSecurityhome_imgbtnHome, 55, 50);
	lv_imgbtn_set_src(ui->screSecurityhome_imgbtnHome,LV_BTN_STATE_RELEASED,&_btn_long_top_house_alpha_55x50);
	lv_imgbtn_set_src(ui->screSecurityhome_imgbtnHome,LV_BTN_STATE_PRESSED,&_btn_long_top_house_alpha_55x50);

	//Write codes screSecurityhome_labelTime
	ui->screSecurityhome_labelTime = lv_label_create(ui->screSecurityhome, NULL);
	lv_label_set_text(ui->screSecurityhome_labelTime, "10:54 AM");
	lv_label_set_long_mode(ui->screSecurityhome_labelTime, LV_LABEL_LONG_BREAK);
	lv_label_set_align(ui->screSecurityhome_labelTime, LV_LABEL_ALIGN_CENTER);

	//Write style LV_LABEL_PART_MAIN for screSecurityhome_labelTime
	static lv_style_t style_screSecurityhome_labelTime_main;
	lv_style_init(&style_screSecurityhome_labelTime_main);

	//Write style state: LV_STATE_DEFAULT for style_screSecurityhome_labelTime_main
	lv_style_set_radius(&style_screSecurityhome_labelTime_main, LV_STATE_DEFAULT, 0);
	lv_style_set_bg_color(&style_screSecurityhome_labelTime_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_bg_grad_color(&style_screSecurityhome_labelTime_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_dir(&style_screSecurityhome_labelTime_main, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screSecurityhome_labelTime_main, LV_STATE_DEFAULT, 0);
	lv_style_set_text_color(&style_screSecurityhome_labelTime_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_text_font(&style_screSecurityhome_labelTime_main, LV_STATE_DEFAULT, &lv_font_simsun_20);
	lv_style_set_text_letter_space(&style_screSecurityhome_labelTime_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_left(&style_screSecurityhome_labelTime_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_right(&style_screSecurityhome_labelTime_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_top(&style_screSecurityhome_labelTime_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_bottom(&style_screSecurityhome_labelTime_main, LV_STATE_DEFAULT, 0);
	lv_obj_add_style(ui->screSecurityhome_labelTime, LV_LABEL_PART_MAIN, &style_screSecurityhome_labelTime_main);
	lv_obj_set_pos(ui->screSecurityhome_labelTime, 379, 8);
	lv_obj_set_size(ui->screSecurityhome_labelTime, 96, 0);

	//Write codes screSecurityhome_labelSecurityCtrl
	ui->screSecurityhome_labelSecurityCtrl = lv_label_create(ui->screSecurityhome, NULL);
	lv_label_set_text(ui->screSecurityhome_labelSecurityCtrl, "SECURITY CONTROL");
	lv_label_set_long_mode(ui->screSecurityhome_labelSecurityCtrl, LV_LABEL_LONG_BREAK);
	lv_label_set_align(ui->screSecurityhome_labelSecurityCtrl, LV_LABEL_ALIGN_CENTER);

	//Write style LV_LABEL_PART_MAIN for screSecurityhome_labelSecurityCtrl
	static lv_style_t style_screSecurityhome_labelSecurityCtrl_main;
	lv_style_init(&style_screSecurityhome_labelSecurityCtrl_main);

	//Write style state: LV_STATE_DEFAULT for style_screSecurityhome_labelSecurityCtrl_main
	lv_style_set_radius(&style_screSecurityhome_labelSecurityCtrl_main, LV_STATE_DEFAULT, 0);
	lv_style_set_bg_color(&style_screSecurityhome_labelSecurityCtrl_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_bg_grad_color(&style_screSecurityhome_labelSecurityCtrl_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_bg_grad_dir(&style_screSecurityhome_labelSecurityCtrl_main, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screSecurityhome_labelSecurityCtrl_main, LV_STATE_DEFAULT, 0);
	lv_style_set_text_color(&style_screSecurityhome_labelSecurityCtrl_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_text_font(&style_screSecurityhome_labelSecurityCtrl_main, LV_STATE_DEFAULT, &lv_font_simsun_22);
	lv_style_set_text_letter_space(&style_screSecurityhome_labelSecurityCtrl_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_left(&style_screSecurityhome_labelSecurityCtrl_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_right(&style_screSecurityhome_labelSecurityCtrl_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_top(&style_screSecurityhome_labelSecurityCtrl_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_bottom(&style_screSecurityhome_labelSecurityCtrl_main, LV_STATE_DEFAULT, 0);
	lv_obj_add_style(ui->screSecurityhome_labelSecurityCtrl, LV_LABEL_PART_MAIN, &style_screSecurityhome_labelSecurityCtrl_main);
	lv_obj_set_pos(ui->screSecurityhome_labelSecurityCtrl, 140, 8);
	lv_obj_set_size(ui->screSecurityhome_labelSecurityCtrl, 206, 0);

	//Write codes screSecurityhome_swFDoor
	ui->screSecurityhome_swFDoor = lv_switch_create(ui->screSecurityhome, NULL);

	//Write style LV_SWITCH_PART_BG for screSecurityhome_swFDoor
	static lv_style_t style_screSecurityhome_swFDoor_bg;
	lv_style_init(&style_screSecurityhome_swFDoor_bg);

	//Write style state: LV_STATE_DEFAULT for style_screSecurityhome_swFDoor_bg
	lv_style_set_radius(&style_screSecurityhome_swFDoor_bg, LV_STATE_DEFAULT, 100);
	lv_style_set_bg_color(&style_screSecurityhome_swFDoor_bg, LV_STATE_DEFAULT, lv_color_make(0x61, 0x61, 0x61));
	lv_style_set_bg_grad_color(&style_screSecurityhome_swFDoor_bg, LV_STATE_DEFAULT, lv_color_make(0x61, 0x61, 0x61));
	lv_style_set_bg_grad_dir(&style_screSecurityhome_swFDoor_bg, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screSecurityhome_swFDoor_bg, LV_STATE_DEFAULT, 255);
	lv_obj_add_style(ui->screSecurityhome_swFDoor, LV_SWITCH_PART_BG, &style_screSecurityhome_swFDoor_bg);

	//Write style LV_SWITCH_PART_INDIC for screSecurityhome_swFDoor
	static lv_style_t style_screSecurityhome_swFDoor_indic;
	lv_style_init(&style_screSecurityhome_swFDoor_indic);

	//Write style state: LV_STATE_DEFAULT for style_screSecurityhome_swFDoor_indic
	lv_style_set_radius(&style_screSecurityhome_swFDoor_indic, LV_STATE_DEFAULT, 100);
	lv_style_set_bg_color(&style_screSecurityhome_swFDoor_indic, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0xff));
	lv_style_set_bg_grad_color(&style_screSecurityhome_swFDoor_indic, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0xff));
	lv_style_set_bg_grad_dir(&style_screSecurityhome_swFDoor_indic, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screSecurityhome_swFDoor_indic, LV_STATE_DEFAULT, 255);
	lv_obj_add_style(ui->screSecurityhome_swFDoor, LV_SWITCH_PART_INDIC, &style_screSecurityhome_swFDoor_indic);

	//Write style LV_SWITCH_PART_KNOB for screSecurityhome_swFDoor
	static lv_style_t style_screSecurityhome_swFDoor_knob;
	lv_style_init(&style_screSecurityhome_swFDoor_knob);

	//Write style state: LV_STATE_DEFAULT for style_screSecurityhome_swFDoor_knob
	lv_style_set_radius(&style_screSecurityhome_swFDoor_knob, LV_STATE_DEFAULT, 100);
	lv_style_set_bg_color(&style_screSecurityhome_swFDoor_knob, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_color(&style_screSecurityhome_swFDoor_knob, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_dir(&style_screSecurityhome_swFDoor_knob, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screSecurityhome_swFDoor_knob, LV_STATE_DEFAULT, 255);
	lv_obj_add_style(ui->screSecurityhome_swFDoor, LV_SWITCH_PART_KNOB, &style_screSecurityhome_swFDoor_knob);
	lv_obj_set_pos(ui->screSecurityhome_swFDoor, 81, 179);
	lv_obj_set_size(ui->screSecurityhome_swFDoor, 55, 27);
	lv_switch_set_anim_time(ui->screSecurityhome_swFDoor, 50);

	//Write codes screSecurityhome_swBDoor
	ui->screSecurityhome_swBDoor = lv_switch_create(ui->screSecurityhome, NULL);

	//Write style LV_SWITCH_PART_BG for screSecurityhome_swBDoor
	static lv_style_t style_screSecurityhome_swBDoor_bg;
	lv_style_init(&style_screSecurityhome_swBDoor_bg);

	//Write style state: LV_STATE_DEFAULT for style_screSecurityhome_swBDoor_bg
	lv_style_set_radius(&style_screSecurityhome_swBDoor_bg, LV_STATE_DEFAULT, 100);
	lv_style_set_bg_color(&style_screSecurityhome_swBDoor_bg, LV_STATE_DEFAULT, lv_color_make(0x61, 0x61, 0x61));
	lv_style_set_bg_grad_color(&style_screSecurityhome_swBDoor_bg, LV_STATE_DEFAULT, lv_color_make(0x61, 0x61, 0x61));
	lv_style_set_bg_grad_dir(&style_screSecurityhome_swBDoor_bg, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screSecurityhome_swBDoor_bg, LV_STATE_DEFAULT, 255);
	lv_obj_add_style(ui->screSecurityhome_swBDoor, LV_SWITCH_PART_BG, &style_screSecurityhome_swBDoor_bg);

	//Write style LV_SWITCH_PART_INDIC for screSecurityhome_swBDoor
	static lv_style_t style_screSecurityhome_swBDoor_indic;
	lv_style_init(&style_screSecurityhome_swBDoor_indic);

	//Write style state: LV_STATE_DEFAULT for style_screSecurityhome_swBDoor_indic
	lv_style_set_radius(&style_screSecurityhome_swBDoor_indic, LV_STATE_DEFAULT, 100);
	lv_style_set_bg_color(&style_screSecurityhome_swBDoor_indic, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0xff));
	lv_style_set_bg_grad_color(&style_screSecurityhome_swBDoor_indic, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0xff));
	lv_style_set_bg_grad_dir(&style_screSecurityhome_swBDoor_indic, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screSecurityhome_swBDoor_indic, LV_STATE_DEFAULT, 255);
	lv_obj_add_style(ui->screSecurityhome_swBDoor, LV_SWITCH_PART_INDIC, &style_screSecurityhome_swBDoor_indic);

	//Write style LV_SWITCH_PART_KNOB for screSecurityhome_swBDoor
	static lv_style_t style_screSecurityhome_swBDoor_knob;
	lv_style_init(&style_screSecurityhome_swBDoor_knob);

	//Write style state: LV_STATE_DEFAULT for style_screSecurityhome_swBDoor_knob
	lv_style_set_radius(&style_screSecurityhome_swBDoor_knob, LV_STATE_DEFAULT, 100);
	lv_style_set_bg_color(&style_screSecurityhome_swBDoor_knob, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_color(&style_screSecurityhome_swBDoor_knob, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_dir(&style_screSecurityhome_swBDoor_knob, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screSecurityhome_swBDoor_knob, LV_STATE_DEFAULT, 255);
	lv_obj_add_style(ui->screSecurityhome_swBDoor, LV_SWITCH_PART_KNOB, &style_screSecurityhome_swBDoor_knob);
	lv_obj_set_pos(ui->screSecurityhome_swBDoor, 205, 178);
	lv_obj_set_size(ui->screSecurityhome_swBDoor, 55, 27);
	lv_switch_set_anim_time(ui->screSecurityhome_swBDoor, 50);

	//Write codes screSecurityhome_swGDoor
	ui->screSecurityhome_swGDoor = lv_switch_create(ui->screSecurityhome, NULL);

	//Write style LV_SWITCH_PART_BG for screSecurityhome_swGDoor
	static lv_style_t style_screSecurityhome_swGDoor_bg;
	lv_style_init(&style_screSecurityhome_swGDoor_bg);

	//Write style state: LV_STATE_DEFAULT for style_screSecurityhome_swGDoor_bg
	lv_style_set_radius(&style_screSecurityhome_swGDoor_bg, LV_STATE_DEFAULT, 100);
	lv_style_set_bg_color(&style_screSecurityhome_swGDoor_bg, LV_STATE_DEFAULT, lv_color_make(0x61, 0x61, 0x61));
	lv_style_set_bg_grad_color(&style_screSecurityhome_swGDoor_bg, LV_STATE_DEFAULT, lv_color_make(0x61, 0x61, 0x61));
	lv_style_set_bg_grad_dir(&style_screSecurityhome_swGDoor_bg, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screSecurityhome_swGDoor_bg, LV_STATE_DEFAULT, 255);
	lv_obj_add_style(ui->screSecurityhome_swGDoor, LV_SWITCH_PART_BG, &style_screSecurityhome_swGDoor_bg);

	//Write style LV_SWITCH_PART_INDIC for screSecurityhome_swGDoor
	static lv_style_t style_screSecurityhome_swGDoor_indic;
	lv_style_init(&style_screSecurityhome_swGDoor_indic);

	//Write style state: LV_STATE_DEFAULT for style_screSecurityhome_swGDoor_indic
	lv_style_set_radius(&style_screSecurityhome_swGDoor_indic, LV_STATE_DEFAULT, 100);
	lv_style_set_bg_color(&style_screSecurityhome_swGDoor_indic, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0xff));
	lv_style_set_bg_grad_color(&style_screSecurityhome_swGDoor_indic, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0xff));
	lv_style_set_bg_grad_dir(&style_screSecurityhome_swGDoor_indic, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screSecurityhome_swGDoor_indic, LV_STATE_DEFAULT, 255);
	lv_obj_add_style(ui->screSecurityhome_swGDoor, LV_SWITCH_PART_INDIC, &style_screSecurityhome_swGDoor_indic);

	//Write style LV_SWITCH_PART_KNOB for screSecurityhome_swGDoor
	static lv_style_t style_screSecurityhome_swGDoor_knob;
	lv_style_init(&style_screSecurityhome_swGDoor_knob);

	//Write style state: LV_STATE_DEFAULT for style_screSecurityhome_swGDoor_knob
	lv_style_set_radius(&style_screSecurityhome_swGDoor_knob, LV_STATE_DEFAULT, 100);
	lv_style_set_bg_color(&style_screSecurityhome_swGDoor_knob, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_color(&style_screSecurityhome_swGDoor_knob, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_dir(&style_screSecurityhome_swGDoor_knob, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screSecurityhome_swGDoor_knob, LV_STATE_DEFAULT, 255);
	lv_obj_add_style(ui->screSecurityhome_swGDoor, LV_SWITCH_PART_KNOB, &style_screSecurityhome_swGDoor_knob);
	lv_obj_set_pos(ui->screSecurityhome_swGDoor, 329, 177);
	lv_obj_set_size(ui->screSecurityhome_swGDoor, 55, 27);
	lv_switch_set_anim_time(ui->screSecurityhome_swGDoor, 50);

	//Write codes screSecurityhome_labelFDoor
	ui->screSecurityhome_labelFDoor = lv_label_create(ui->screSecurityhome, NULL);
	lv_label_set_text(ui->screSecurityhome_labelFDoor, "Front Door Unlocked");
	lv_label_set_long_mode(ui->screSecurityhome_labelFDoor, LV_LABEL_LONG_BREAK);
	lv_label_set_align(ui->screSecurityhome_labelFDoor, LV_LABEL_ALIGN_LEFT);

	//Write style LV_LABEL_PART_MAIN for screSecurityhome_labelFDoor
	static lv_style_t style_screSecurityhome_labelFDoor_main;
	lv_style_init(&style_screSecurityhome_labelFDoor_main);

	//Write style state: LV_STATE_DEFAULT for style_screSecurityhome_labelFDoor_main
	lv_style_set_radius(&style_screSecurityhome_labelFDoor_main, LV_STATE_DEFAULT, 0);
	lv_style_set_bg_color(&style_screSecurityhome_labelFDoor_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_color(&style_screSecurityhome_labelFDoor_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_dir(&style_screSecurityhome_labelFDoor_main, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screSecurityhome_labelFDoor_main, LV_STATE_DEFAULT, 0);
	lv_style_set_text_color(&style_screSecurityhome_labelFDoor_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_text_font(&style_screSecurityhome_labelFDoor_main, LV_STATE_DEFAULT, &lv_font_simsun_16);
	lv_style_set_text_letter_space(&style_screSecurityhome_labelFDoor_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_left(&style_screSecurityhome_labelFDoor_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_right(&style_screSecurityhome_labelFDoor_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_top(&style_screSecurityhome_labelFDoor_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_bottom(&style_screSecurityhome_labelFDoor_main, LV_STATE_DEFAULT, 0);
	lv_obj_add_style(ui->screSecurityhome_labelFDoor, LV_LABEL_PART_MAIN, &style_screSecurityhome_labelFDoor_main);
	lv_obj_set_pos(ui->screSecurityhome_labelFDoor, 85, 215);
	lv_obj_set_size(ui->screSecurityhome_labelFDoor, 65, 0);

	//Write codes screSecurityhome_labelBDoor
	ui->screSecurityhome_labelBDoor = lv_label_create(ui->screSecurityhome, NULL);
	lv_label_set_text(ui->screSecurityhome_labelBDoor, "Back Door Unlocked");
	lv_label_set_long_mode(ui->screSecurityhome_labelBDoor, LV_LABEL_LONG_BREAK);
	lv_label_set_align(ui->screSecurityhome_labelBDoor, LV_LABEL_ALIGN_LEFT);

	//Write style LV_LABEL_PART_MAIN for screSecurityhome_labelBDoor
	static lv_style_t style_screSecurityhome_labelBDoor_main;
	lv_style_init(&style_screSecurityhome_labelBDoor_main);

	//Write style state: LV_STATE_DEFAULT for style_screSecurityhome_labelBDoor_main
	lv_style_set_radius(&style_screSecurityhome_labelBDoor_main, LV_STATE_DEFAULT, 0);
	lv_style_set_bg_color(&style_screSecurityhome_labelBDoor_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_color(&style_screSecurityhome_labelBDoor_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_dir(&style_screSecurityhome_labelBDoor_main, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screSecurityhome_labelBDoor_main, LV_STATE_DEFAULT, 0);
	lv_style_set_text_color(&style_screSecurityhome_labelBDoor_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_text_font(&style_screSecurityhome_labelBDoor_main, LV_STATE_DEFAULT, &lv_font_simsun_16);
	lv_style_set_text_letter_space(&style_screSecurityhome_labelBDoor_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_left(&style_screSecurityhome_labelBDoor_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_right(&style_screSecurityhome_labelBDoor_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_top(&style_screSecurityhome_labelBDoor_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_bottom(&style_screSecurityhome_labelBDoor_main, LV_STATE_DEFAULT, 0);
	lv_obj_add_style(ui->screSecurityhome_labelBDoor, LV_LABEL_PART_MAIN, &style_screSecurityhome_labelBDoor_main);
	lv_obj_set_pos(ui->screSecurityhome_labelBDoor, 209, 215);
	lv_obj_set_size(ui->screSecurityhome_labelBDoor, 65, 0);

	//Write codes screSecurityhome_labelGDoor
	ui->screSecurityhome_labelGDoor = lv_label_create(ui->screSecurityhome, NULL);
	lv_label_set_text(ui->screSecurityhome_labelGDoor, "Garage Door Unlocked");
	lv_label_set_long_mode(ui->screSecurityhome_labelGDoor, LV_LABEL_LONG_BREAK);
	lv_label_set_align(ui->screSecurityhome_labelGDoor, LV_LABEL_ALIGN_LEFT);

	//Write style LV_LABEL_PART_MAIN for screSecurityhome_labelGDoor
	static lv_style_t style_screSecurityhome_labelGDoor_main;
	lv_style_init(&style_screSecurityhome_labelGDoor_main);

	//Write style state: LV_STATE_DEFAULT for style_screSecurityhome_labelGDoor_main
	lv_style_set_radius(&style_screSecurityhome_labelGDoor_main, LV_STATE_DEFAULT, 0);
	lv_style_set_bg_color(&style_screSecurityhome_labelGDoor_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_color(&style_screSecurityhome_labelGDoor_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_dir(&style_screSecurityhome_labelGDoor_main, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screSecurityhome_labelGDoor_main, LV_STATE_DEFAULT, 0);
	lv_style_set_text_color(&style_screSecurityhome_labelGDoor_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_text_font(&style_screSecurityhome_labelGDoor_main, LV_STATE_DEFAULT, &lv_font_simsun_16);
	lv_style_set_text_letter_space(&style_screSecurityhome_labelGDoor_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_left(&style_screSecurityhome_labelGDoor_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_right(&style_screSecurityhome_labelGDoor_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_top(&style_screSecurityhome_labelGDoor_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_bottom(&style_screSecurityhome_labelGDoor_main, LV_STATE_DEFAULT, 0);
	lv_obj_add_style(ui->screSecurityhome_labelGDoor, LV_LABEL_PART_MAIN, &style_screSecurityhome_labelGDoor_main);
	lv_obj_set_pos(ui->screSecurityhome_labelGDoor, 332, 215);
	lv_obj_set_size(ui->screSecurityhome_labelGDoor, 65, 0);

	//Write codes screSecurityhome_labelArmed
	ui->screSecurityhome_labelArmed = lv_label_create(ui->screSecurityhome, NULL);
	lv_label_set_text(ui->screSecurityhome_labelArmed, "System Armed");
	lv_label_set_long_mode(ui->screSecurityhome_labelArmed, LV_LABEL_LONG_BREAK);
	lv_label_set_align(ui->screSecurityhome_labelArmed, LV_LABEL_ALIGN_LEFT);

	//Write style LV_LABEL_PART_MAIN for screSecurityhome_labelArmed
	static lv_style_t style_screSecurityhome_labelArmed_main;
	lv_style_init(&style_screSecurityhome_labelArmed_main);

	//Write style state: LV_STATE_DEFAULT for style_screSecurityhome_labelArmed_main
	lv_style_set_radius(&style_screSecurityhome_labelArmed_main, LV_STATE_DEFAULT, 0);
	lv_style_set_bg_color(&style_screSecurityhome_labelArmed_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_color(&style_screSecurityhome_labelArmed_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_dir(&style_screSecurityhome_labelArmed_main, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screSecurityhome_labelArmed_main, LV_STATE_DEFAULT, 0);
	lv_style_set_text_color(&style_screSecurityhome_labelArmed_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_text_font(&style_screSecurityhome_labelArmed_main, LV_STATE_DEFAULT, &lv_font_simsun_26);
	lv_style_set_text_letter_space(&style_screSecurityhome_labelArmed_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_left(&style_screSecurityhome_labelArmed_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_right(&style_screSecurityhome_labelArmed_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_top(&style_screSecurityhome_labelArmed_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_bottom(&style_screSecurityhome_labelArmed_main, LV_STATE_DEFAULT, 0);
	lv_obj_add_style(ui->screSecurityhome_labelArmed, LV_LABEL_PART_MAIN, &style_screSecurityhome_labelArmed_main);
	lv_obj_set_pos(ui->screSecurityhome_labelArmed, 142, 89);
	lv_obj_set_size(ui->screSecurityhome_labelArmed, 85, 0);

	//Write codes screSecurityhome_imgLock
	ui->screSecurityhome_imgLock = lv_img_create(ui->screSecurityhome, NULL);

	//Write style LV_IMG_PART_MAIN for screSecurityhome_imgLock
	static lv_style_t style_screSecurityhome_imgLock_main;
	lv_style_init(&style_screSecurityhome_imgLock_main);

	//Write style state: LV_STATE_DEFAULT for style_screSecurityhome_imgLock_main
	lv_style_set_image_recolor(&style_screSecurityhome_imgLock_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_image_recolor_opa(&style_screSecurityhome_imgLock_main, LV_STATE_DEFAULT, 0);
	lv_style_set_image_opa(&style_screSecurityhome_imgLock_main, LV_STATE_DEFAULT, 255);
	lv_obj_add_style(ui->screSecurityhome_imgLock, LV_IMG_PART_MAIN, &style_screSecurityhome_imgLock_main);
	lv_obj_set_pos(ui->screSecurityhome_imgLock, 53, 72);
	lv_obj_set_size(ui->screSecurityhome_imgLock, 72, 68);
	lv_obj_set_click(ui->screSecurityhome_imgLock, true);
	lv_img_set_src(ui->screSecurityhome_imgLock,&_icn_arm_alpha_72x68);
	lv_img_set_pivot(ui->screSecurityhome_imgLock, 0,0);
	lv_img_set_angle(ui->screSecurityhome_imgLock, 0);

	//Write codes screSecurityhome_contDivLineHL
	ui->screSecurityhome_contDivLineHL = lv_cont_create(ui->screSecurityhome, NULL);

	//Write style LV_CONT_PART_MAIN for screSecurityhome_contDivLineHL
	static lv_style_t style_screSecurityhome_contDivLineHL_main;
	lv_style_init(&style_screSecurityhome_contDivLineHL_main);

	//Write style state: LV_STATE_DEFAULT for style_screSecurityhome_contDivLineHL_main
	lv_style_set_radius(&style_screSecurityhome_contDivLineHL_main, LV_STATE_DEFAULT, 0);
	lv_style_set_bg_color(&style_screSecurityhome_contDivLineHL_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_color(&style_screSecurityhome_contDivLineHL_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_bg_grad_dir(&style_screSecurityhome_contDivLineHL_main, LV_STATE_DEFAULT, LV_GRAD_DIR_HOR);
	lv_style_set_bg_opa(&style_screSecurityhome_contDivLineHL_main, LV_STATE_DEFAULT, 255);
	lv_style_set_border_color(&style_screSecurityhome_contDivLineHL_main, LV_STATE_DEFAULT, lv_color_make(0xfa, 0xfa, 0xfa));
	lv_style_set_border_width(&style_screSecurityhome_contDivLineHL_main, LV_STATE_DEFAULT, 1);
	lv_style_set_border_opa(&style_screSecurityhome_contDivLineHL_main, LV_STATE_DEFAULT, 255);
	lv_style_set_pad_left(&style_screSecurityhome_contDivLineHL_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_right(&style_screSecurityhome_contDivLineHL_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_top(&style_screSecurityhome_contDivLineHL_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_bottom(&style_screSecurityhome_contDivLineHL_main, LV_STATE_DEFAULT, 0);
	lv_obj_add_style(ui->screSecurityhome_contDivLineHL, LV_CONT_PART_MAIN, &style_screSecurityhome_contDivLineHL_main);
	lv_obj_set_pos(ui->screSecurityhome_contDivLineHL, 40, 160);
	lv_obj_set_size(ui->screSecurityhome_contDivLineHL, 195, 4);
	lv_obj_set_click(ui->screSecurityhome_contDivLineHL, false);
	lv_cont_set_layout(ui->screSecurityhome_contDivLineHL, LV_LAYOUT_OFF);
	lv_cont_set_fit(ui->screSecurityhome_contDivLineHL, LV_FIT_NONE);

	//Write codes screSecurityhome_contDivLineHR
	ui->screSecurityhome_contDivLineHR = lv_cont_create(ui->screSecurityhome, NULL);

	//Write style LV_CONT_PART_MAIN for screSecurityhome_contDivLineHR
	static lv_style_t style_screSecurityhome_contDivLineHR_main;
	lv_style_init(&style_screSecurityhome_contDivLineHR_main);

	//Write style state: LV_STATE_DEFAULT for style_screSecurityhome_contDivLineHR_main
	lv_style_set_radius(&style_screSecurityhome_contDivLineHR_main, LV_STATE_DEFAULT, 0);
	lv_style_set_bg_color(&style_screSecurityhome_contDivLineHR_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_bg_grad_color(&style_screSecurityhome_contDivLineHR_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_dir(&style_screSecurityhome_contDivLineHR_main, LV_STATE_DEFAULT, LV_GRAD_DIR_HOR);
	lv_style_set_bg_opa(&style_screSecurityhome_contDivLineHR_main, LV_STATE_DEFAULT, 255);
	lv_style_set_border_color(&style_screSecurityhome_contDivLineHR_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_border_width(&style_screSecurityhome_contDivLineHR_main, LV_STATE_DEFAULT, 1);
	lv_style_set_border_opa(&style_screSecurityhome_contDivLineHR_main, LV_STATE_DEFAULT, 255);
	lv_style_set_pad_left(&style_screSecurityhome_contDivLineHR_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_right(&style_screSecurityhome_contDivLineHR_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_top(&style_screSecurityhome_contDivLineHR_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_bottom(&style_screSecurityhome_contDivLineHR_main, LV_STATE_DEFAULT, 0);
	lv_obj_add_style(ui->screSecurityhome_contDivLineHR, LV_CONT_PART_MAIN, &style_screSecurityhome_contDivLineHR_main);
	lv_obj_set_pos(ui->screSecurityhome_contDivLineHR, 234, 160);
	lv_obj_set_size(ui->screSecurityhome_contDivLineHR, 195, 4);
	lv_obj_set_click(ui->screSecurityhome_contDivLineHR, false);
	lv_cont_set_layout(ui->screSecurityhome_contDivLineHR, LV_LAYOUT_OFF);
	lv_cont_set_fit(ui->screSecurityhome_contDivLineHR, LV_FIT_NONE);

	//Write codes screSecurityhome_contDivLineVL
	ui->screSecurityhome_contDivLineVL = lv_cont_create(ui->screSecurityhome, NULL);

	//Write style LV_CONT_PART_MAIN for screSecurityhome_contDivLineVL
	static lv_style_t style_screSecurityhome_contDivLineVL_main;
	lv_style_init(&style_screSecurityhome_contDivLineVL_main);

	//Write style state: LV_STATE_DEFAULT for style_screSecurityhome_contDivLineVL_main
	lv_style_set_radius(&style_screSecurityhome_contDivLineVL_main, LV_STATE_DEFAULT, 0);
	lv_style_set_bg_color(&style_screSecurityhome_contDivLineVL_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_bg_grad_color(&style_screSecurityhome_contDivLineVL_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_dir(&style_screSecurityhome_contDivLineVL_main, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screSecurityhome_contDivLineVL_main, LV_STATE_DEFAULT, 255);
	lv_style_set_border_color(&style_screSecurityhome_contDivLineVL_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_border_width(&style_screSecurityhome_contDivLineVL_main, LV_STATE_DEFAULT, 1);
	lv_style_set_border_opa(&style_screSecurityhome_contDivLineVL_main, LV_STATE_DEFAULT, 255);
	lv_style_set_pad_left(&style_screSecurityhome_contDivLineVL_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_right(&style_screSecurityhome_contDivLineVL_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_top(&style_screSecurityhome_contDivLineVL_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_bottom(&style_screSecurityhome_contDivLineVL_main, LV_STATE_DEFAULT, 0);
	lv_obj_add_style(ui->screSecurityhome_contDivLineVL, LV_CONT_PART_MAIN, &style_screSecurityhome_contDivLineVL_main);
	lv_obj_set_pos(ui->screSecurityhome_contDivLineVL, 172, 163);
	lv_obj_set_size(ui->screSecurityhome_contDivLineVL, 4, 60);
	lv_obj_set_click(ui->screSecurityhome_contDivLineVL, false);
	lv_cont_set_layout(ui->screSecurityhome_contDivLineVL, LV_LAYOUT_OFF);
	lv_cont_set_fit(ui->screSecurityhome_contDivLineVL, LV_FIT_NONE);

	//Write codes screSecurityhome_contDivLineVR
	ui->screSecurityhome_contDivLineVR = lv_cont_create(ui->screSecurityhome, NULL);

	//Write style LV_CONT_PART_MAIN for screSecurityhome_contDivLineVR
	static lv_style_t style_screSecurityhome_contDivLineVR_main;
	lv_style_init(&style_screSecurityhome_contDivLineVR_main);

	//Write style state: LV_STATE_DEFAULT for style_screSecurityhome_contDivLineVR_main
	lv_style_set_radius(&style_screSecurityhome_contDivLineVR_main, LV_STATE_DEFAULT, 0);
	lv_style_set_bg_color(&style_screSecurityhome_contDivLineVR_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_bg_grad_color(&style_screSecurityhome_contDivLineVR_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_dir(&style_screSecurityhome_contDivLineVR_main, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screSecurityhome_contDivLineVR_main, LV_STATE_DEFAULT, 255);
	lv_style_set_border_color(&style_screSecurityhome_contDivLineVR_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_border_width(&style_screSecurityhome_contDivLineVR_main, LV_STATE_DEFAULT, 1);
	lv_style_set_border_opa(&style_screSecurityhome_contDivLineVR_main, LV_STATE_DEFAULT, 255);
	lv_style_set_pad_left(&style_screSecurityhome_contDivLineVR_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_right(&style_screSecurityhome_contDivLineVR_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_top(&style_screSecurityhome_contDivLineVR_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_bottom(&style_screSecurityhome_contDivLineVR_main, LV_STATE_DEFAULT, 0);
	lv_obj_add_style(ui->screSecurityhome_contDivLineVR, LV_CONT_PART_MAIN, &style_screSecurityhome_contDivLineVR_main);
	lv_obj_set_pos(ui->screSecurityhome_contDivLineVR, 293, 163);
	lv_obj_set_size(ui->screSecurityhome_contDivLineVR, 4, 60);
	lv_obj_set_click(ui->screSecurityhome_contDivLineVR, false);
	lv_cont_set_layout(ui->screSecurityhome_contDivLineVR, LV_LAYOUT_OFF);
	lv_cont_set_fit(ui->screSecurityhome_contDivLineVR, LV_FIT_NONE);

	//Init events for screen
	events_init_screSecurityhome(ui);
}