/*
 * Copyright 2021 NXP
 * SPDX-License-Identifier: MIT
 */

#include "lvgl/lvgl.h"
#include <stdio.h>
#include "gui_guider.h"
#include "events_init.h"
#include "custom.h"


void setup_scr_screWelcome(lv_ui *ui){

	//Write codes screWelcome
	ui->screWelcome = lv_obj_create(NULL, NULL);

	//Write codes screWelcome_contBackground
	ui->screWelcome_contBackground = lv_cont_create(ui->screWelcome, NULL);

	//Write style LV_CONT_PART_MAIN for screWelcome_contBackground
	static lv_style_t style_screWelcome_contBackground_main;
	lv_style_init(&style_screWelcome_contBackground_main);

	//Write style state: LV_STATE_DEFAULT for style_screWelcome_contBackground_main
	lv_style_set_radius(&style_screWelcome_contBackground_main, LV_STATE_DEFAULT, 0);
	lv_style_set_bg_color(&style_screWelcome_contBackground_main, LV_STATE_DEFAULT, lv_color_make(0xe0, 0xe0, 0xe0));
	lv_style_set_bg_grad_color(&style_screWelcome_contBackground_main, LV_STATE_DEFAULT, lv_color_make(0xf4, 0xf4, 0xf4));
	lv_style_set_bg_grad_dir(&style_screWelcome_contBackground_main, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screWelcome_contBackground_main, LV_STATE_DEFAULT, 255);
	lv_style_set_border_color(&style_screWelcome_contBackground_main, LV_STATE_DEFAULT, lv_color_make(0x99, 0x99, 0x99));
	lv_style_set_border_width(&style_screWelcome_contBackground_main, LV_STATE_DEFAULT, 0);
	lv_style_set_border_opa(&style_screWelcome_contBackground_main, LV_STATE_DEFAULT, 255);
	lv_style_set_pad_left(&style_screWelcome_contBackground_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_right(&style_screWelcome_contBackground_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_top(&style_screWelcome_contBackground_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_bottom(&style_screWelcome_contBackground_main, LV_STATE_DEFAULT, 0);
	lv_obj_add_style(ui->screWelcome_contBackground, LV_CONT_PART_MAIN, &style_screWelcome_contBackground_main);
	lv_obj_set_pos(ui->screWelcome_contBackground, 0, 0);
	lv_obj_set_size(ui->screWelcome_contBackground, 480, 272);
	lv_obj_set_click(ui->screWelcome_contBackground, false);
	lv_cont_set_layout(ui->screWelcome_contBackground, LV_LAYOUT_OFF);
	lv_cont_set_fit(ui->screWelcome_contBackground, LV_FIT_NONE);

	//Write codes screWelcome_imgHead
	ui->screWelcome_imgHead = lv_img_create(ui->screWelcome, NULL);

	//Write style LV_IMG_PART_MAIN for screWelcome_imgHead
	static lv_style_t style_screWelcome_imgHead_main;
	lv_style_init(&style_screWelcome_imgHead_main);

	//Write style state: LV_STATE_DEFAULT for style_screWelcome_imgHead_main
	lv_style_set_image_recolor(&style_screWelcome_imgHead_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_image_recolor_opa(&style_screWelcome_imgHead_main, LV_STATE_DEFAULT, 0);
	lv_style_set_image_opa(&style_screWelcome_imgHead_main, LV_STATE_DEFAULT, 255);
	lv_obj_add_style(ui->screWelcome_imgHead, LV_IMG_PART_MAIN, &style_screWelcome_imgHead_main);
	lv_obj_set_pos(ui->screWelcome_imgHead, 0, 0);
	lv_obj_set_size(ui->screWelcome_imgHead, 480, 80);
	lv_obj_set_click(ui->screWelcome_imgHead, true);
	lv_img_set_src(ui->screWelcome_imgHead,&_img_header_alpha_480x80);
	lv_img_set_pivot(ui->screWelcome_imgHead, 0,0);
	lv_img_set_angle(ui->screWelcome_imgHead, 0);

	//Write codes screWelcome_imgHomeLogo
	ui->screWelcome_imgHomeLogo = lv_img_create(ui->screWelcome, NULL);

	//Write style LV_IMG_PART_MAIN for screWelcome_imgHomeLogo
	static lv_style_t style_screWelcome_imgHomeLogo_main;
	lv_style_init(&style_screWelcome_imgHomeLogo_main);

	//Write style state: LV_STATE_DEFAULT for style_screWelcome_imgHomeLogo_main
	lv_style_set_image_recolor(&style_screWelcome_imgHomeLogo_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_image_recolor_opa(&style_screWelcome_imgHomeLogo_main, LV_STATE_DEFAULT, 0);
	lv_style_set_image_opa(&style_screWelcome_imgHomeLogo_main, LV_STATE_DEFAULT, 255);
	lv_obj_add_style(ui->screWelcome_imgHomeLogo, LV_IMG_PART_MAIN, &style_screWelcome_imgHomeLogo_main);
	lv_obj_set_pos(ui->screWelcome_imgHomeLogo, 26, 5);
	lv_obj_set_size(ui->screWelcome_imgHomeLogo, 40, 26);
	lv_obj_set_click(ui->screWelcome_imgHomeLogo, true);
	lv_img_set_src(ui->screWelcome_imgHomeLogo,&_icn_house_small_alpha_40x26);
	lv_img_set_pivot(ui->screWelcome_imgHomeLogo, 0,0);
	lv_img_set_angle(ui->screWelcome_imgHomeLogo, 0);

	//Write codes screWelcome_labelWelcomeSlogan
	ui->screWelcome_labelWelcomeSlogan = lv_label_create(ui->screWelcome, NULL);
	lv_label_set_text(ui->screWelcome_labelWelcomeSlogan, "GOOD MORNING");
	lv_label_set_long_mode(ui->screWelcome_labelWelcomeSlogan, LV_LABEL_LONG_BREAK);
	lv_label_set_align(ui->screWelcome_labelWelcomeSlogan, LV_LABEL_ALIGN_CENTER);

	//Write style LV_LABEL_PART_MAIN for screWelcome_labelWelcomeSlogan
	static lv_style_t style_screWelcome_labelWelcomeSlogan_main;
	lv_style_init(&style_screWelcome_labelWelcomeSlogan_main);

	//Write style state: LV_STATE_DEFAULT for style_screWelcome_labelWelcomeSlogan_main
	lv_style_set_radius(&style_screWelcome_labelWelcomeSlogan_main, LV_STATE_DEFAULT, 0);
	lv_style_set_bg_color(&style_screWelcome_labelWelcomeSlogan_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_bg_grad_color(&style_screWelcome_labelWelcomeSlogan_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_bg_grad_dir(&style_screWelcome_labelWelcomeSlogan_main, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screWelcome_labelWelcomeSlogan_main, LV_STATE_DEFAULT, 0);
	lv_style_set_text_color(&style_screWelcome_labelWelcomeSlogan_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_text_font(&style_screWelcome_labelWelcomeSlogan_main, LV_STATE_DEFAULT, &lv_font_simsun_22);
	lv_style_set_text_letter_space(&style_screWelcome_labelWelcomeSlogan_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_left(&style_screWelcome_labelWelcomeSlogan_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_right(&style_screWelcome_labelWelcomeSlogan_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_top(&style_screWelcome_labelWelcomeSlogan_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_bottom(&style_screWelcome_labelWelcomeSlogan_main, LV_STATE_DEFAULT, 0);
	lv_obj_add_style(ui->screWelcome_labelWelcomeSlogan, LV_LABEL_PART_MAIN, &style_screWelcome_labelWelcomeSlogan_main);
	lv_obj_set_pos(ui->screWelcome_labelWelcomeSlogan, 126, 9);
	lv_obj_set_size(ui->screWelcome_labelWelcomeSlogan, 206, 0);

	//Write codes screWelcome_labelTime
	ui->screWelcome_labelTime = lv_label_create(ui->screWelcome, NULL);
	lv_label_set_text(ui->screWelcome_labelTime, "10:54 AM");
	lv_label_set_long_mode(ui->screWelcome_labelTime, LV_LABEL_LONG_BREAK);
	lv_label_set_align(ui->screWelcome_labelTime, LV_LABEL_ALIGN_CENTER);

	//Write style LV_LABEL_PART_MAIN for screWelcome_labelTime
	static lv_style_t style_screWelcome_labelTime_main;
	lv_style_init(&style_screWelcome_labelTime_main);

	//Write style state: LV_STATE_DEFAULT for style_screWelcome_labelTime_main
	lv_style_set_radius(&style_screWelcome_labelTime_main, LV_STATE_DEFAULT, 0);
	lv_style_set_bg_color(&style_screWelcome_labelTime_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_bg_grad_color(&style_screWelcome_labelTime_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_dir(&style_screWelcome_labelTime_main, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screWelcome_labelTime_main, LV_STATE_DEFAULT, 0);
	lv_style_set_text_color(&style_screWelcome_labelTime_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_text_font(&style_screWelcome_labelTime_main, LV_STATE_DEFAULT, &lv_font_simsun_20);
	lv_style_set_text_letter_space(&style_screWelcome_labelTime_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_left(&style_screWelcome_labelTime_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_right(&style_screWelcome_labelTime_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_top(&style_screWelcome_labelTime_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_bottom(&style_screWelcome_labelTime_main, LV_STATE_DEFAULT, 0);
	lv_obj_add_style(ui->screWelcome_labelTime, LV_LABEL_PART_MAIN, &style_screWelcome_labelTime_main);
	lv_obj_set_pos(ui->screWelcome_labelTime, 371, 9);
	lv_obj_set_size(ui->screWelcome_labelTime, 100, 0);

	//Write codes screWelcome_contTodayInfo
	ui->screWelcome_contTodayInfo = lv_cont_create(ui->screWelcome, NULL);

	//Write style LV_CONT_PART_MAIN for screWelcome_contTodayInfo
	static lv_style_t style_screWelcome_contTodayInfo_main;
	lv_style_init(&style_screWelcome_contTodayInfo_main);

	//Write style state: LV_STATE_DEFAULT for style_screWelcome_contTodayInfo_main
	lv_style_set_radius(&style_screWelcome_contTodayInfo_main, LV_STATE_DEFAULT, 0);
	lv_style_set_bg_color(&style_screWelcome_contTodayInfo_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_color(&style_screWelcome_contTodayInfo_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_dir(&style_screWelcome_contTodayInfo_main, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screWelcome_contTodayInfo_main, LV_STATE_DEFAULT, 0);
	lv_style_set_border_color(&style_screWelcome_contTodayInfo_main, LV_STATE_DEFAULT, lv_color_make(0x99, 0x99, 0x99));
	lv_style_set_border_width(&style_screWelcome_contTodayInfo_main, LV_STATE_DEFAULT, 1);
	lv_style_set_border_opa(&style_screWelcome_contTodayInfo_main, LV_STATE_DEFAULT, 255);
	lv_style_set_pad_left(&style_screWelcome_contTodayInfo_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_right(&style_screWelcome_contTodayInfo_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_top(&style_screWelcome_contTodayInfo_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_bottom(&style_screWelcome_contTodayInfo_main, LV_STATE_DEFAULT, 0);
	lv_obj_add_style(ui->screWelcome_contTodayInfo, LV_CONT_PART_MAIN, &style_screWelcome_contTodayInfo_main);
	lv_obj_set_pos(ui->screWelcome_contTodayInfo, 93, 49);
	lv_obj_set_size(ui->screWelcome_contTodayInfo, 272, 100);
	lv_obj_set_click(ui->screWelcome_contTodayInfo, false);

	//Write codes screWelcome_imgMaxTempDegree
	ui->screWelcome_imgMaxTempDegree = lv_img_create(ui->screWelcome_contTodayInfo, NULL);

	//Write style LV_IMG_PART_MAIN for screWelcome_imgMaxTempDegree
	static lv_style_t style_screWelcome_imgMaxTempDegree_main;
	lv_style_init(&style_screWelcome_imgMaxTempDegree_main);

	//Write style state: LV_STATE_DEFAULT for style_screWelcome_imgMaxTempDegree_main
	lv_style_set_image_recolor(&style_screWelcome_imgMaxTempDegree_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_image_recolor_opa(&style_screWelcome_imgMaxTempDegree_main, LV_STATE_DEFAULT, 0);
	lv_style_set_image_opa(&style_screWelcome_imgMaxTempDegree_main, LV_STATE_DEFAULT, 255);
	lv_obj_add_style(ui->screWelcome_imgMaxTempDegree, LV_IMG_PART_MAIN, &style_screWelcome_imgMaxTempDegree_main);
	lv_obj_set_pos(ui->screWelcome_imgMaxTempDegree, 224, 62);
	lv_obj_set_size(ui->screWelcome_imgMaxTempDegree, 6, 6);
	lv_obj_set_click(ui->screWelcome_imgMaxTempDegree, true);
	lv_img_set_src(ui->screWelcome_imgMaxTempDegree,&_DegreeTrans_alpha_6x6);
	lv_img_set_pivot(ui->screWelcome_imgMaxTempDegree, 0,0);
	lv_img_set_angle(ui->screWelcome_imgMaxTempDegree, 0);

	//Write codes screWelcome_imgMinTempDegree
	ui->screWelcome_imgMinTempDegree = lv_img_create(ui->screWelcome_contTodayInfo, NULL);

	//Write style LV_IMG_PART_MAIN for screWelcome_imgMinTempDegree
	static lv_style_t style_screWelcome_imgMinTempDegree_main;
	lv_style_init(&style_screWelcome_imgMinTempDegree_main);

	//Write style state: LV_STATE_DEFAULT for style_screWelcome_imgMinTempDegree_main
	lv_style_set_image_recolor(&style_screWelcome_imgMinTempDegree_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_image_recolor_opa(&style_screWelcome_imgMinTempDegree_main, LV_STATE_DEFAULT, 0);
	lv_style_set_image_opa(&style_screWelcome_imgMinTempDegree_main, LV_STATE_DEFAULT, 255);
	lv_obj_add_style(ui->screWelcome_imgMinTempDegree, LV_IMG_PART_MAIN, &style_screWelcome_imgMinTempDegree_main);
	lv_obj_set_pos(ui->screWelcome_imgMinTempDegree, 168, 62);
	lv_obj_set_size(ui->screWelcome_imgMinTempDegree, 6, 6);
	lv_obj_set_click(ui->screWelcome_imgMinTempDegree, true);
	lv_img_set_src(ui->screWelcome_imgMinTempDegree,&_DegreeTrans_alpha_6x6);
	lv_img_set_pivot(ui->screWelcome_imgMinTempDegree, 0,0);
	lv_img_set_angle(ui->screWelcome_imgMinTempDegree, 0);

	//Write codes screWelcome_labelMaxTemp
	ui->screWelcome_labelMaxTemp = lv_label_create(ui->screWelcome_contTodayInfo, NULL);
	lv_label_set_text(ui->screWelcome_labelMaxTemp, "80");
	lv_label_set_long_mode(ui->screWelcome_labelMaxTemp, LV_LABEL_LONG_BREAK);
	lv_label_set_align(ui->screWelcome_labelMaxTemp, LV_LABEL_ALIGN_CENTER);

	//Write style LV_LABEL_PART_MAIN for screWelcome_labelMaxTemp
	static lv_style_t style_screWelcome_labelMaxTemp_main;
	lv_style_init(&style_screWelcome_labelMaxTemp_main);

	//Write style state: LV_STATE_DEFAULT for style_screWelcome_labelMaxTemp_main
	lv_style_set_radius(&style_screWelcome_labelMaxTemp_main, LV_STATE_DEFAULT, 0);
	lv_style_set_bg_color(&style_screWelcome_labelMaxTemp_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_color(&style_screWelcome_labelMaxTemp_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_dir(&style_screWelcome_labelMaxTemp_main, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screWelcome_labelMaxTemp_main, LV_STATE_DEFAULT, 0);
	lv_style_set_text_color(&style_screWelcome_labelMaxTemp_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_text_font(&style_screWelcome_labelMaxTemp_main, LV_STATE_DEFAULT, &lv_font_simsun_20);
	lv_style_set_text_letter_space(&style_screWelcome_labelMaxTemp_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_left(&style_screWelcome_labelMaxTemp_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_right(&style_screWelcome_labelMaxTemp_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_top(&style_screWelcome_labelMaxTemp_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_bottom(&style_screWelcome_labelMaxTemp_main, LV_STATE_DEFAULT, 0);
	lv_obj_add_style(ui->screWelcome_labelMaxTemp, LV_LABEL_PART_MAIN, &style_screWelcome_labelMaxTemp_main);
	lv_obj_set_pos(ui->screWelcome_labelMaxTemp, 194, 63);
	lv_obj_set_size(ui->screWelcome_labelMaxTemp, 36, 0);

	//Write codes screWelcome_labelSeparator
	ui->screWelcome_labelSeparator = lv_label_create(ui->screWelcome_contTodayInfo, NULL);
	lv_label_set_text(ui->screWelcome_labelSeparator, "|");
	lv_label_set_long_mode(ui->screWelcome_labelSeparator, LV_LABEL_LONG_BREAK);
	lv_label_set_align(ui->screWelcome_labelSeparator, LV_LABEL_ALIGN_CENTER);

	//Write style LV_LABEL_PART_MAIN for screWelcome_labelSeparator
	static lv_style_t style_screWelcome_labelSeparator_main;
	lv_style_init(&style_screWelcome_labelSeparator_main);

	//Write style state: LV_STATE_DEFAULT for style_screWelcome_labelSeparator_main
	lv_style_set_radius(&style_screWelcome_labelSeparator_main, LV_STATE_DEFAULT, 0);
	lv_style_set_bg_color(&style_screWelcome_labelSeparator_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_color(&style_screWelcome_labelSeparator_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_dir(&style_screWelcome_labelSeparator_main, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screWelcome_labelSeparator_main, LV_STATE_DEFAULT, 0);
	lv_style_set_text_color(&style_screWelcome_labelSeparator_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_text_font(&style_screWelcome_labelSeparator_main, LV_STATE_DEFAULT, &lv_font_montserratMedium_20);
	lv_style_set_text_letter_space(&style_screWelcome_labelSeparator_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_left(&style_screWelcome_labelSeparator_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_right(&style_screWelcome_labelSeparator_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_top(&style_screWelcome_labelSeparator_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_bottom(&style_screWelcome_labelSeparator_main, LV_STATE_DEFAULT, 0);
	lv_obj_add_style(ui->screWelcome_labelSeparator, LV_LABEL_PART_MAIN, &style_screWelcome_labelSeparator_main);
	lv_obj_set_pos(ui->screWelcome_labelSeparator, 181, 63);
	lv_obj_set_size(ui->screWelcome_labelSeparator, 10, 0);

	//Write codes screWelcome_labelMinTemp
	ui->screWelcome_labelMinTemp = lv_label_create(ui->screWelcome_contTodayInfo, NULL);
	lv_label_set_text(ui->screWelcome_labelMinTemp, "63");
	lv_label_set_long_mode(ui->screWelcome_labelMinTemp, LV_LABEL_LONG_BREAK);
	lv_label_set_align(ui->screWelcome_labelMinTemp, LV_LABEL_ALIGN_CENTER);

	//Write style LV_LABEL_PART_MAIN for screWelcome_labelMinTemp
	static lv_style_t style_screWelcome_labelMinTemp_main;
	lv_style_init(&style_screWelcome_labelMinTemp_main);

	//Write style state: LV_STATE_DEFAULT for style_screWelcome_labelMinTemp_main
	lv_style_set_radius(&style_screWelcome_labelMinTemp_main, LV_STATE_DEFAULT, 0);
	lv_style_set_bg_color(&style_screWelcome_labelMinTemp_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_color(&style_screWelcome_labelMinTemp_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_dir(&style_screWelcome_labelMinTemp_main, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screWelcome_labelMinTemp_main, LV_STATE_DEFAULT, 0);
	lv_style_set_text_color(&style_screWelcome_labelMinTemp_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_text_font(&style_screWelcome_labelMinTemp_main, LV_STATE_DEFAULT, &lv_font_simsun_20);
	lv_style_set_text_letter_space(&style_screWelcome_labelMinTemp_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_left(&style_screWelcome_labelMinTemp_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_right(&style_screWelcome_labelMinTemp_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_top(&style_screWelcome_labelMinTemp_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_bottom(&style_screWelcome_labelMinTemp_main, LV_STATE_DEFAULT, 0);
	lv_obj_add_style(ui->screWelcome_labelMinTemp, LV_LABEL_PART_MAIN, &style_screWelcome_labelMinTemp_main);
	lv_obj_set_pos(ui->screWelcome_labelMinTemp, 140, 63);
	lv_obj_set_size(ui->screWelcome_labelMinTemp, 38, 0);

	//Write codes screWelcome_labelWeatherDesc
	ui->screWelcome_labelWeatherDesc = lv_label_create(ui->screWelcome_contTodayInfo, NULL);
	lv_label_set_text(ui->screWelcome_labelWeatherDesc, "Partly Cloudy");
	lv_label_set_long_mode(ui->screWelcome_labelWeatherDesc, LV_LABEL_LONG_BREAK);
	lv_label_set_align(ui->screWelcome_labelWeatherDesc, LV_LABEL_ALIGN_CENTER);

	//Write style LV_LABEL_PART_MAIN for screWelcome_labelWeatherDesc
	static lv_style_t style_screWelcome_labelWeatherDesc_main;
	lv_style_init(&style_screWelcome_labelWeatherDesc_main);

	//Write style state: LV_STATE_DEFAULT for style_screWelcome_labelWeatherDesc_main
	lv_style_set_radius(&style_screWelcome_labelWeatherDesc_main, LV_STATE_DEFAULT, 0);
	lv_style_set_bg_color(&style_screWelcome_labelWeatherDesc_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_color(&style_screWelcome_labelWeatherDesc_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_dir(&style_screWelcome_labelWeatherDesc_main, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screWelcome_labelWeatherDesc_main, LV_STATE_DEFAULT, 0);
	lv_style_set_text_color(&style_screWelcome_labelWeatherDesc_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_text_font(&style_screWelcome_labelWeatherDesc_main, LV_STATE_DEFAULT, &lv_font_simsun_18);
	lv_style_set_text_letter_space(&style_screWelcome_labelWeatherDesc_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_left(&style_screWelcome_labelWeatherDesc_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_right(&style_screWelcome_labelWeatherDesc_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_top(&style_screWelcome_labelWeatherDesc_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_bottom(&style_screWelcome_labelWeatherDesc_main, LV_STATE_DEFAULT, 0);
	lv_obj_add_style(ui->screWelcome_labelWeatherDesc, LV_LABEL_PART_MAIN, &style_screWelcome_labelWeatherDesc_main);
	lv_obj_set_pos(ui->screWelcome_labelWeatherDesc, 128, 42);
	lv_obj_set_size(ui->screWelcome_labelWeatherDesc, 132, 0);

	//Write codes screWelcome_imgWeather
	ui->screWelcome_imgWeather = lv_img_create(ui->screWelcome_contTodayInfo, NULL);

	//Write style LV_IMG_PART_MAIN for screWelcome_imgWeather
	static lv_style_t style_screWelcome_imgWeather_main;
	lv_style_init(&style_screWelcome_imgWeather_main);

	//Write style state: LV_STATE_DEFAULT for style_screWelcome_imgWeather_main
	lv_style_set_image_recolor(&style_screWelcome_imgWeather_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_image_recolor_opa(&style_screWelcome_imgWeather_main, LV_STATE_DEFAULT, 0);
	lv_style_set_image_opa(&style_screWelcome_imgWeather_main, LV_STATE_DEFAULT, 255);
	lv_obj_add_style(ui->screWelcome_imgWeather, LV_IMG_PART_MAIN, &style_screWelcome_imgWeather_main);
	lv_obj_set_pos(ui->screWelcome_imgWeather, 81, 43);
	lv_obj_set_size(ui->screWelcome_imgWeather, 40, 40);
	lv_obj_set_click(ui->screWelcome_imgWeather, true);
	lv_img_set_src(ui->screWelcome_imgWeather,&_icn_p_cloud_alpha_40x40);
	lv_img_set_pivot(ui->screWelcome_imgWeather, 0,0);
	lv_img_set_angle(ui->screWelcome_imgWeather, 0);

	//Write codes screWelcome_imgDegree
	ui->screWelcome_imgDegree = lv_img_create(ui->screWelcome_contTodayInfo, NULL);

	//Write style LV_IMG_PART_MAIN for screWelcome_imgDegree
	static lv_style_t style_screWelcome_imgDegree_main;
	lv_style_init(&style_screWelcome_imgDegree_main);

	//Write style state: LV_STATE_DEFAULT for style_screWelcome_imgDegree_main
	lv_style_set_image_recolor(&style_screWelcome_imgDegree_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_image_recolor_opa(&style_screWelcome_imgDegree_main, LV_STATE_DEFAULT, 0);
	lv_style_set_image_opa(&style_screWelcome_imgDegree_main, LV_STATE_DEFAULT, 255);
	lv_obj_add_style(ui->screWelcome_imgDegree, LV_IMG_PART_MAIN, &style_screWelcome_imgDegree_main);
	lv_obj_set_pos(ui->screWelcome_imgDegree, 67, 37);
	lv_obj_set_size(ui->screWelcome_imgDegree, 10, 10);
	lv_obj_set_click(ui->screWelcome_imgDegree, true);
	lv_img_set_src(ui->screWelcome_imgDegree,&_DegreeTrans_alpha_10x10);
	lv_img_set_pivot(ui->screWelcome_imgDegree, 0,0);
	lv_img_set_angle(ui->screWelcome_imgDegree, 0);

	//Write codes screWelcome_labelCurrentTemp
	ui->screWelcome_labelCurrentTemp = lv_label_create(ui->screWelcome_contTodayInfo, NULL);
	lv_label_set_text(ui->screWelcome_labelCurrentTemp, "75");
	lv_label_set_long_mode(ui->screWelcome_labelCurrentTemp, LV_LABEL_LONG_BREAK);
	lv_label_set_align(ui->screWelcome_labelCurrentTemp, LV_LABEL_ALIGN_CENTER);

	//Write style LV_LABEL_PART_MAIN for screWelcome_labelCurrentTemp
	static lv_style_t style_screWelcome_labelCurrentTemp_main;
	lv_style_init(&style_screWelcome_labelCurrentTemp_main);

	//Write style state: LV_STATE_DEFAULT for style_screWelcome_labelCurrentTemp_main
	lv_style_set_radius(&style_screWelcome_labelCurrentTemp_main, LV_STATE_DEFAULT, 0);
	lv_style_set_bg_color(&style_screWelcome_labelCurrentTemp_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_color(&style_screWelcome_labelCurrentTemp_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_dir(&style_screWelcome_labelCurrentTemp_main, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screWelcome_labelCurrentTemp_main, LV_STATE_DEFAULT, 0);
	lv_style_set_text_color(&style_screWelcome_labelCurrentTemp_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_text_font(&style_screWelcome_labelCurrentTemp_main, LV_STATE_DEFAULT, &lv_font_simsun_48);
	lv_style_set_text_letter_space(&style_screWelcome_labelCurrentTemp_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_left(&style_screWelcome_labelCurrentTemp_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_right(&style_screWelcome_labelCurrentTemp_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_top(&style_screWelcome_labelCurrentTemp_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_bottom(&style_screWelcome_labelCurrentTemp_main, LV_STATE_DEFAULT, 0);
	lv_obj_add_style(ui->screWelcome_labelCurrentTemp, LV_LABEL_PART_MAIN, &style_screWelcome_labelCurrentTemp_main);
	lv_obj_set_pos(ui->screWelcome_labelCurrentTemp, 10, 38);
	lv_obj_set_size(ui->screWelcome_labelCurrentTemp, 62, 0);

	//Write codes screWelcome_labelDate
	ui->screWelcome_labelDate = lv_label_create(ui->screWelcome_contTodayInfo, NULL);
	lv_label_set_text(ui->screWelcome_labelDate, "Monday, May 18");
	lv_label_set_long_mode(ui->screWelcome_labelDate, LV_LABEL_LONG_BREAK);
	lv_label_set_align(ui->screWelcome_labelDate, LV_LABEL_ALIGN_CENTER);

	//Write style LV_LABEL_PART_MAIN for screWelcome_labelDate
	static lv_style_t style_screWelcome_labelDate_main;
	lv_style_init(&style_screWelcome_labelDate_main);

	//Write style state: LV_STATE_DEFAULT for style_screWelcome_labelDate_main
	lv_style_set_radius(&style_screWelcome_labelDate_main, LV_STATE_DEFAULT, 0);
	lv_style_set_bg_color(&style_screWelcome_labelDate_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_color(&style_screWelcome_labelDate_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_dir(&style_screWelcome_labelDate_main, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screWelcome_labelDate_main, LV_STATE_DEFAULT, 0);
	lv_style_set_text_color(&style_screWelcome_labelDate_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_text_font(&style_screWelcome_labelDate_main, LV_STATE_DEFAULT, &lv_font_simsun_20);
	lv_style_set_text_letter_space(&style_screWelcome_labelDate_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_left(&style_screWelcome_labelDate_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_right(&style_screWelcome_labelDate_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_top(&style_screWelcome_labelDate_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_bottom(&style_screWelcome_labelDate_main, LV_STATE_DEFAULT, 0);
	lv_obj_add_style(ui->screWelcome_labelDate, LV_LABEL_PART_MAIN, &style_screWelcome_labelDate_main);
	lv_obj_set_pos(ui->screWelcome_labelDate, 47, 7);
	lv_obj_set_size(ui->screWelcome_labelDate, 199, 0);
	lv_cont_set_layout(ui->screWelcome_contTodayInfo, LV_LAYOUT_OFF);
	lv_cont_set_fit(ui->screWelcome_contTodayInfo, LV_FIT_NONE);

	//Write codes screWelcome_imgbtnTemp
	ui->screWelcome_imgbtnTemp = lv_imgbtn_create(ui->screWelcome, NULL);

	//Write style LV_IMGBTN_PART_MAIN for screWelcome_imgbtnTemp
	static lv_style_t style_screWelcome_imgbtnTemp_main;
	lv_style_init(&style_screWelcome_imgbtnTemp_main);

	//Write style state: LV_STATE_DEFAULT for style_screWelcome_imgbtnTemp_main
	lv_style_set_text_color(&style_screWelcome_imgbtnTemp_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_image_recolor(&style_screWelcome_imgbtnTemp_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_image_recolor_opa(&style_screWelcome_imgbtnTemp_main, LV_STATE_DEFAULT, 0);
	lv_style_set_image_opa(&style_screWelcome_imgbtnTemp_main, LV_STATE_DEFAULT, 255);
	lv_obj_add_style(ui->screWelcome_imgbtnTemp, LV_IMGBTN_PART_MAIN, &style_screWelcome_imgbtnTemp_main);
	lv_obj_set_pos(ui->screWelcome_imgbtnTemp, 36, 164);
	lv_obj_set_size(ui->screWelcome_imgbtnTemp, 70, 70);
	lv_imgbtn_set_src(ui->screWelcome_imgbtnTemp,LV_BTN_STATE_RELEASED,&_btn_big_bg_temp_alpha_70x70);
	lv_imgbtn_set_src(ui->screWelcome_imgbtnTemp,LV_BTN_STATE_PRESSED,&_btn_big_bg_temp_alpha_70x70);

	//Write codes screWelcome_imgbtnLight
	ui->screWelcome_imgbtnLight = lv_imgbtn_create(ui->screWelcome, NULL);

	//Write style LV_IMGBTN_PART_MAIN for screWelcome_imgbtnLight
	static lv_style_t style_screWelcome_imgbtnLight_main;
	lv_style_init(&style_screWelcome_imgbtnLight_main);

	//Write style state: LV_STATE_DEFAULT for style_screWelcome_imgbtnLight_main
	lv_style_set_text_color(&style_screWelcome_imgbtnLight_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_image_recolor(&style_screWelcome_imgbtnLight_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_image_recolor_opa(&style_screWelcome_imgbtnLight_main, LV_STATE_DEFAULT, 0);
	lv_style_set_image_opa(&style_screWelcome_imgbtnLight_main, LV_STATE_DEFAULT, 255);
	lv_obj_add_style(ui->screWelcome_imgbtnLight, LV_IMGBTN_PART_MAIN, &style_screWelcome_imgbtnLight_main);
	lv_obj_set_pos(ui->screWelcome_imgbtnLight, 144, 164);
	lv_obj_set_size(ui->screWelcome_imgbtnLight, 70, 70);
	lv_imgbtn_set_src(ui->screWelcome_imgbtnLight,LV_BTN_STATE_RELEASED,&_btn_big_bg_light_alpha_70x70);
	lv_imgbtn_set_src(ui->screWelcome_imgbtnLight,LV_BTN_STATE_PRESSED,&_btn_big_bg_light_alpha_70x70);

	//Write codes screWelcome_imgbtnSecurity
	ui->screWelcome_imgbtnSecurity = lv_imgbtn_create(ui->screWelcome, NULL);

	//Write style LV_IMGBTN_PART_MAIN for screWelcome_imgbtnSecurity
	static lv_style_t style_screWelcome_imgbtnSecurity_main;
	lv_style_init(&style_screWelcome_imgbtnSecurity_main);

	//Write style state: LV_STATE_DEFAULT for style_screWelcome_imgbtnSecurity_main
	lv_style_set_text_color(&style_screWelcome_imgbtnSecurity_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_image_recolor(&style_screWelcome_imgbtnSecurity_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_image_recolor_opa(&style_screWelcome_imgbtnSecurity_main, LV_STATE_DEFAULT, 0);
	lv_style_set_image_opa(&style_screWelcome_imgbtnSecurity_main, LV_STATE_DEFAULT, 255);
	lv_obj_add_style(ui->screWelcome_imgbtnSecurity, LV_IMGBTN_PART_MAIN, &style_screWelcome_imgbtnSecurity_main);
	lv_obj_set_pos(ui->screWelcome_imgbtnSecurity, 252, 164);
	lv_obj_set_size(ui->screWelcome_imgbtnSecurity, 70, 70);
	lv_imgbtn_set_src(ui->screWelcome_imgbtnSecurity,LV_BTN_STATE_RELEASED,&_btn_big_bg_secure_alpha_70x70);
	lv_imgbtn_set_src(ui->screWelcome_imgbtnSecurity,LV_BTN_STATE_PRESSED,&_btn_big_bg_secure_alpha_70x70);

	//Write codes screWelcome_imgbtnMusic
	ui->screWelcome_imgbtnMusic = lv_imgbtn_create(ui->screWelcome, NULL);

	//Write style LV_IMGBTN_PART_MAIN for screWelcome_imgbtnMusic
	static lv_style_t style_screWelcome_imgbtnMusic_main;
	lv_style_init(&style_screWelcome_imgbtnMusic_main);

	//Write style state: LV_STATE_DEFAULT for style_screWelcome_imgbtnMusic_main
	lv_style_set_text_color(&style_screWelcome_imgbtnMusic_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_image_recolor(&style_screWelcome_imgbtnMusic_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_image_recolor_opa(&style_screWelcome_imgbtnMusic_main, LV_STATE_DEFAULT, 0);
	lv_style_set_image_opa(&style_screWelcome_imgbtnMusic_main, LV_STATE_DEFAULT, 255);
	lv_obj_add_style(ui->screWelcome_imgbtnMusic, LV_IMGBTN_PART_MAIN, &style_screWelcome_imgbtnMusic_main);
	lv_obj_set_pos(ui->screWelcome_imgbtnMusic, 360, 164);
	lv_obj_set_size(ui->screWelcome_imgbtnMusic, 70, 70);
	lv_imgbtn_set_src(ui->screWelcome_imgbtnMusic,LV_BTN_STATE_RELEASED,&_btn_big_bg_audio_player_alpha_70x70);
	lv_imgbtn_set_src(ui->screWelcome_imgbtnMusic,LV_BTN_STATE_PRESSED,&_btn_big_bg_audio_player_alpha_70x70);

	//Write codes screWelcome_labelTemp
	ui->screWelcome_labelTemp = lv_label_create(ui->screWelcome, NULL);
	lv_label_set_text(ui->screWelcome_labelTemp, "Temp");
	lv_label_set_long_mode(ui->screWelcome_labelTemp, LV_LABEL_LONG_BREAK);
	lv_label_set_align(ui->screWelcome_labelTemp, LV_LABEL_ALIGN_CENTER);

	//Write style LV_LABEL_PART_MAIN for screWelcome_labelTemp
	static lv_style_t style_screWelcome_labelTemp_main;
	lv_style_init(&style_screWelcome_labelTemp_main);

	//Write style state: LV_STATE_DEFAULT for style_screWelcome_labelTemp_main
	lv_style_set_radius(&style_screWelcome_labelTemp_main, LV_STATE_DEFAULT, 0);
	lv_style_set_bg_color(&style_screWelcome_labelTemp_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_color(&style_screWelcome_labelTemp_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_dir(&style_screWelcome_labelTemp_main, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screWelcome_labelTemp_main, LV_STATE_DEFAULT, 0);
	lv_style_set_text_color(&style_screWelcome_labelTemp_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_text_font(&style_screWelcome_labelTemp_main, LV_STATE_DEFAULT, &lv_font_simsun_18);
	lv_style_set_text_letter_space(&style_screWelcome_labelTemp_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_left(&style_screWelcome_labelTemp_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_right(&style_screWelcome_labelTemp_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_top(&style_screWelcome_labelTemp_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_bottom(&style_screWelcome_labelTemp_main, LV_STATE_DEFAULT, 0);
	lv_obj_add_style(ui->screWelcome_labelTemp, LV_LABEL_PART_MAIN, &style_screWelcome_labelTemp_main);
	lv_obj_set_pos(ui->screWelcome_labelTemp, 50, 242);
	lv_obj_set_size(ui->screWelcome_labelTemp, 36, 0);

	//Write codes screWelcome_labelLight
	ui->screWelcome_labelLight = lv_label_create(ui->screWelcome, NULL);
	lv_label_set_text(ui->screWelcome_labelLight, "Light");
	lv_label_set_long_mode(ui->screWelcome_labelLight, LV_LABEL_LONG_BREAK);
	lv_label_set_align(ui->screWelcome_labelLight, LV_LABEL_ALIGN_CENTER);

	//Write style LV_LABEL_PART_MAIN for screWelcome_labelLight
	static lv_style_t style_screWelcome_labelLight_main;
	lv_style_init(&style_screWelcome_labelLight_main);

	//Write style state: LV_STATE_DEFAULT for style_screWelcome_labelLight_main
	lv_style_set_radius(&style_screWelcome_labelLight_main, LV_STATE_DEFAULT, 0);
	lv_style_set_bg_color(&style_screWelcome_labelLight_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_color(&style_screWelcome_labelLight_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_dir(&style_screWelcome_labelLight_main, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screWelcome_labelLight_main, LV_STATE_DEFAULT, 0);
	lv_style_set_text_color(&style_screWelcome_labelLight_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_text_font(&style_screWelcome_labelLight_main, LV_STATE_DEFAULT, &lv_font_simsun_18);
	lv_style_set_text_letter_space(&style_screWelcome_labelLight_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_left(&style_screWelcome_labelLight_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_right(&style_screWelcome_labelLight_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_top(&style_screWelcome_labelLight_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_bottom(&style_screWelcome_labelLight_main, LV_STATE_DEFAULT, 0);
	lv_obj_add_style(ui->screWelcome_labelLight, LV_LABEL_PART_MAIN, &style_screWelcome_labelLight_main);
	lv_obj_set_pos(ui->screWelcome_labelLight, 150, 242);
	lv_obj_set_size(ui->screWelcome_labelLight, 54, 0);

	//Write codes screWelcome_labelSecurity
	ui->screWelcome_labelSecurity = lv_label_create(ui->screWelcome, NULL);
	lv_label_set_text(ui->screWelcome_labelSecurity, "Security");
	lv_label_set_long_mode(ui->screWelcome_labelSecurity, LV_LABEL_LONG_BREAK);
	lv_label_set_align(ui->screWelcome_labelSecurity, LV_LABEL_ALIGN_CENTER);

	//Write style LV_LABEL_PART_MAIN for screWelcome_labelSecurity
	static lv_style_t style_screWelcome_labelSecurity_main;
	lv_style_init(&style_screWelcome_labelSecurity_main);

	//Write style state: LV_STATE_DEFAULT for style_screWelcome_labelSecurity_main
	lv_style_set_radius(&style_screWelcome_labelSecurity_main, LV_STATE_DEFAULT, 0);
	lv_style_set_bg_color(&style_screWelcome_labelSecurity_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_color(&style_screWelcome_labelSecurity_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_dir(&style_screWelcome_labelSecurity_main, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screWelcome_labelSecurity_main, LV_STATE_DEFAULT, 0);
	lv_style_set_text_color(&style_screWelcome_labelSecurity_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_text_font(&style_screWelcome_labelSecurity_main, LV_STATE_DEFAULT, &lv_font_simsun_18);
	lv_style_set_text_letter_space(&style_screWelcome_labelSecurity_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_left(&style_screWelcome_labelSecurity_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_right(&style_screWelcome_labelSecurity_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_top(&style_screWelcome_labelSecurity_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_bottom(&style_screWelcome_labelSecurity_main, LV_STATE_DEFAULT, 0);
	lv_obj_add_style(ui->screWelcome_labelSecurity, LV_LABEL_PART_MAIN, &style_screWelcome_labelSecurity_main);
	lv_obj_set_pos(ui->screWelcome_labelSecurity, 244, 242);
	lv_obj_set_size(ui->screWelcome_labelSecurity, 92, 0);

	//Write codes screWelcome_labelAudioPlayer
	ui->screWelcome_labelAudioPlayer = lv_label_create(ui->screWelcome, NULL);
	lv_label_set_text(ui->screWelcome_labelAudioPlayer, "Audio Player");
	lv_label_set_long_mode(ui->screWelcome_labelAudioPlayer, LV_LABEL_LONG_BREAK);
	lv_label_set_align(ui->screWelcome_labelAudioPlayer, LV_LABEL_ALIGN_CENTER);

	//Write style LV_LABEL_PART_MAIN for screWelcome_labelAudioPlayer
	static lv_style_t style_screWelcome_labelAudioPlayer_main;
	lv_style_init(&style_screWelcome_labelAudioPlayer_main);

	//Write style state: LV_STATE_DEFAULT for style_screWelcome_labelAudioPlayer_main
	lv_style_set_radius(&style_screWelcome_labelAudioPlayer_main, LV_STATE_DEFAULT, 0);
	lv_style_set_bg_color(&style_screWelcome_labelAudioPlayer_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_color(&style_screWelcome_labelAudioPlayer_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_dir(&style_screWelcome_labelAudioPlayer_main, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screWelcome_labelAudioPlayer_main, LV_STATE_DEFAULT, 0);
	lv_style_set_text_color(&style_screWelcome_labelAudioPlayer_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_text_font(&style_screWelcome_labelAudioPlayer_main, LV_STATE_DEFAULT, &lv_font_simsun_18);
	lv_style_set_text_letter_space(&style_screWelcome_labelAudioPlayer_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_left(&style_screWelcome_labelAudioPlayer_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_right(&style_screWelcome_labelAudioPlayer_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_top(&style_screWelcome_labelAudioPlayer_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_bottom(&style_screWelcome_labelAudioPlayer_main, LV_STATE_DEFAULT, 0);
	lv_obj_add_style(ui->screWelcome_labelAudioPlayer, LV_LABEL_PART_MAIN, &style_screWelcome_labelAudioPlayer_main);
	lv_obj_set_pos(ui->screWelcome_labelAudioPlayer, 341, 242);
	lv_obj_set_size(ui->screWelcome_labelAudioPlayer, 133, 0);

	//Init events for screen
	events_init_screWelcome(ui);
}