/*
 * Copyright 2021 NXP
 * SPDX-License-Identifier: MIT
 */

#include "lvgl/lvgl.h"
#include <stdio.h>
#include "gui_guider.h"
#include "events_init.h"
#include "custom.h"


void setup_scr_screenTemp(lv_ui *ui){

	//Write codes screenTemp
	ui->screenTemp = lv_obj_create(NULL, NULL);

	//Write codes screenTemp_contBackground
	ui->screenTemp_contBackground = lv_cont_create(ui->screenTemp, NULL);

	//Write style LV_CONT_PART_MAIN for screenTemp_contBackground
	static lv_style_t style_screenTemp_contBackground_main;
	lv_style_init(&style_screenTemp_contBackground_main);

	//Write style state: LV_STATE_DEFAULT for style_screenTemp_contBackground_main
	lv_style_set_radius(&style_screenTemp_contBackground_main, LV_STATE_DEFAULT, 0);
	lv_style_set_bg_color(&style_screenTemp_contBackground_main, LV_STATE_DEFAULT, lv_color_make(0xe0, 0xe0, 0xe0));
	lv_style_set_bg_grad_color(&style_screenTemp_contBackground_main, LV_STATE_DEFAULT, lv_color_make(0xf4, 0xf4, 0xf4));
	lv_style_set_bg_grad_dir(&style_screenTemp_contBackground_main, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screenTemp_contBackground_main, LV_STATE_DEFAULT, 255);
	lv_style_set_border_color(&style_screenTemp_contBackground_main, LV_STATE_DEFAULT, lv_color_make(0x99, 0x99, 0x99));
	lv_style_set_border_width(&style_screenTemp_contBackground_main, LV_STATE_DEFAULT, 0);
	lv_style_set_border_opa(&style_screenTemp_contBackground_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_left(&style_screenTemp_contBackground_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_right(&style_screenTemp_contBackground_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_top(&style_screenTemp_contBackground_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_bottom(&style_screenTemp_contBackground_main, LV_STATE_DEFAULT, 0);
	lv_obj_add_style(ui->screenTemp_contBackground, LV_CONT_PART_MAIN, &style_screenTemp_contBackground_main);
	lv_obj_set_pos(ui->screenTemp_contBackground, 0, 0);
	lv_obj_set_size(ui->screenTemp_contBackground, 480, 272);
	lv_obj_set_click(ui->screenTemp_contBackground, false);
	lv_cont_set_layout(ui->screenTemp_contBackground, LV_LAYOUT_OFF);
	lv_cont_set_fit(ui->screenTemp_contBackground, LV_FIT_NONE);

	//Write codes screenTemp_imgHead
	ui->screenTemp_imgHead = lv_img_create(ui->screenTemp, NULL);

	//Write style LV_IMG_PART_MAIN for screenTemp_imgHead
	static lv_style_t style_screenTemp_imgHead_main;
	lv_style_init(&style_screenTemp_imgHead_main);

	//Write style state: LV_STATE_DEFAULT for style_screenTemp_imgHead_main
	lv_style_set_image_recolor(&style_screenTemp_imgHead_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_image_recolor_opa(&style_screenTemp_imgHead_main, LV_STATE_DEFAULT, 0);
	lv_style_set_image_opa(&style_screenTemp_imgHead_main, LV_STATE_DEFAULT, 255);
	lv_obj_add_style(ui->screenTemp_imgHead, LV_IMG_PART_MAIN, &style_screenTemp_imgHead_main);
	lv_obj_set_pos(ui->screenTemp_imgHead, 0, 0);
	lv_obj_set_size(ui->screenTemp_imgHead, 480, 80);
	lv_obj_set_click(ui->screenTemp_imgHead, true);
	lv_img_set_src(ui->screenTemp_imgHead,&_img_header_alpha_480x80);
	lv_img_set_pivot(ui->screenTemp_imgHead, 0,0);
	lv_img_set_angle(ui->screenTemp_imgHead, 0);

	//Write codes screenTemp_labelTempSlogan
	ui->screenTemp_labelTempSlogan = lv_label_create(ui->screenTemp, NULL);
	lv_label_set_text(ui->screenTemp_labelTempSlogan, "TEMPERATURE");
	lv_label_set_long_mode(ui->screenTemp_labelTempSlogan, LV_LABEL_LONG_BREAK);
	lv_label_set_align(ui->screenTemp_labelTempSlogan, LV_LABEL_ALIGN_CENTER);

	//Write style LV_LABEL_PART_MAIN for screenTemp_labelTempSlogan
	static lv_style_t style_screenTemp_labelTempSlogan_main;
	lv_style_init(&style_screenTemp_labelTempSlogan_main);

	//Write style state: LV_STATE_DEFAULT for style_screenTemp_labelTempSlogan_main
	lv_style_set_radius(&style_screenTemp_labelTempSlogan_main, LV_STATE_DEFAULT, 0);
	lv_style_set_bg_color(&style_screenTemp_labelTempSlogan_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_bg_grad_color(&style_screenTemp_labelTempSlogan_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_bg_grad_dir(&style_screenTemp_labelTempSlogan_main, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screenTemp_labelTempSlogan_main, LV_STATE_DEFAULT, 0);
	lv_style_set_text_color(&style_screenTemp_labelTempSlogan_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_text_font(&style_screenTemp_labelTempSlogan_main, LV_STATE_DEFAULT, &lv_font_simsun_22);
	lv_style_set_text_letter_space(&style_screenTemp_labelTempSlogan_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_left(&style_screenTemp_labelTempSlogan_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_right(&style_screenTemp_labelTempSlogan_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_top(&style_screenTemp_labelTempSlogan_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_bottom(&style_screenTemp_labelTempSlogan_main, LV_STATE_DEFAULT, 0);
	lv_obj_add_style(ui->screenTemp_labelTempSlogan, LV_LABEL_PART_MAIN, &style_screenTemp_labelTempSlogan_main);
	lv_obj_set_pos(ui->screenTemp_labelTempSlogan, 143, 7);
	lv_obj_set_size(ui->screenTemp_labelTempSlogan, 206, 0);

	//Write codes screenTemp_labelTime
	ui->screenTemp_labelTime = lv_label_create(ui->screenTemp, NULL);
	lv_label_set_text(ui->screenTemp_labelTime, "10:54 AM");
	lv_label_set_long_mode(ui->screenTemp_labelTime, LV_LABEL_LONG_BREAK);
	lv_label_set_align(ui->screenTemp_labelTime, LV_LABEL_ALIGN_CENTER);

	//Write style LV_LABEL_PART_MAIN for screenTemp_labelTime
	static lv_style_t style_screenTemp_labelTime_main;
	lv_style_init(&style_screenTemp_labelTime_main);

	//Write style state: LV_STATE_DEFAULT for style_screenTemp_labelTime_main
	lv_style_set_radius(&style_screenTemp_labelTime_main, LV_STATE_DEFAULT, 0);
	lv_style_set_bg_color(&style_screenTemp_labelTime_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_bg_grad_color(&style_screenTemp_labelTime_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_dir(&style_screenTemp_labelTime_main, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screenTemp_labelTime_main, LV_STATE_DEFAULT, 0);
	lv_style_set_text_color(&style_screenTemp_labelTime_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_text_font(&style_screenTemp_labelTime_main, LV_STATE_DEFAULT, &lv_font_simsun_20);
	lv_style_set_text_letter_space(&style_screenTemp_labelTime_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_left(&style_screenTemp_labelTime_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_right(&style_screenTemp_labelTime_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_top(&style_screenTemp_labelTime_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_bottom(&style_screenTemp_labelTime_main, LV_STATE_DEFAULT, 0);
	lv_obj_add_style(ui->screenTemp_labelTime, LV_LABEL_PART_MAIN, &style_screenTemp_labelTime_main);
	lv_obj_set_pos(ui->screenTemp_labelTime, 379, 8);
	lv_obj_set_size(ui->screenTemp_labelTime, 100, 0);

	//Write codes screenTemp_imgbtnCold
	ui->screenTemp_imgbtnCold = lv_imgbtn_create(ui->screenTemp, NULL);

	//Write style LV_IMGBTN_PART_MAIN for screenTemp_imgbtnCold
	static lv_style_t style_screenTemp_imgbtnCold_main;
	lv_style_init(&style_screenTemp_imgbtnCold_main);

	//Write style state: LV_STATE_DEFAULT for style_screenTemp_imgbtnCold_main
	lv_style_set_text_color(&style_screenTemp_imgbtnCold_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_image_recolor(&style_screenTemp_imgbtnCold_main, LV_STATE_DEFAULT, lv_color_make(0x78, 0x78, 0x78));
	lv_style_set_image_recolor_opa(&style_screenTemp_imgbtnCold_main, LV_STATE_DEFAULT, 0);
	lv_style_set_image_opa(&style_screenTemp_imgbtnCold_main, LV_STATE_DEFAULT, 255);

	//Write style state: LV_STATE_PRESSED for style_screenTemp_imgbtnCold_main
	lv_style_set_text_color(&style_screenTemp_imgbtnCold_main, LV_STATE_PRESSED, lv_color_make(0xFF, 0x33, 0xFF));
	lv_style_set_image_recolor(&style_screenTemp_imgbtnCold_main, LV_STATE_PRESSED, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_image_recolor_opa(&style_screenTemp_imgbtnCold_main, LV_STATE_PRESSED, 0);

	//Write style state: LV_STATE_CHECKED for style_screenTemp_imgbtnCold_main
	lv_style_set_text_color(&style_screenTemp_imgbtnCold_main, LV_STATE_CHECKED, lv_color_make(0xFF, 0x33, 0xFF));
	lv_style_set_image_recolor(&style_screenTemp_imgbtnCold_main, LV_STATE_CHECKED, lv_color_make(0x80, 0x80, 0x80));
	lv_style_set_image_recolor_opa(&style_screenTemp_imgbtnCold_main, LV_STATE_CHECKED, 100);
	lv_obj_add_style(ui->screenTemp_imgbtnCold, LV_IMGBTN_PART_MAIN, &style_screenTemp_imgbtnCold_main);
	lv_obj_set_pos(ui->screenTemp_imgbtnCold, 35, 65);
	lv_obj_set_size(ui->screenTemp_imgbtnCold, 55, 55);
	lv_imgbtn_set_src(ui->screenTemp_imgbtnCold,LV_BTN_STATE_RELEASED,&_btn_small_bg_snow_alpha_55x55);
	lv_imgbtn_set_src(ui->screenTemp_imgbtnCold,LV_BTN_STATE_PRESSED,&_btn_small_bg_snow_alpha_55x55);
	lv_imgbtn_set_src(ui->screenTemp_imgbtnCold,LV_BTN_STATE_CHECKED_RELEASED,&_btn_small_bg_snow_alpha_55x55);
	lv_imgbtn_set_src(ui->screenTemp_imgbtnCold,LV_BTN_STATE_CHECKED_PRESSED,&_btn_small_bg_snow_alpha_55x55);
	lv_imgbtn_set_checkable(ui->screenTemp_imgbtnCold, true);

	//Write codes screenTemp_imgbtnAuto
	ui->screenTemp_imgbtnAuto = lv_imgbtn_create(ui->screenTemp, NULL);

	//Write style LV_IMGBTN_PART_MAIN for screenTemp_imgbtnAuto
	static lv_style_t style_screenTemp_imgbtnAuto_main;
	lv_style_init(&style_screenTemp_imgbtnAuto_main);

	//Write style state: LV_STATE_DEFAULT for style_screenTemp_imgbtnAuto_main
	lv_style_set_text_color(&style_screenTemp_imgbtnAuto_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_image_recolor(&style_screenTemp_imgbtnAuto_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_image_recolor_opa(&style_screenTemp_imgbtnAuto_main, LV_STATE_DEFAULT, 0);
	lv_style_set_image_opa(&style_screenTemp_imgbtnAuto_main, LV_STATE_DEFAULT, 255);

	//Write style state: LV_STATE_CHECKED for style_screenTemp_imgbtnAuto_main
	lv_style_set_text_color(&style_screenTemp_imgbtnAuto_main, LV_STATE_CHECKED, lv_color_make(0xFF, 0x33, 0xFF));
	lv_style_set_image_recolor(&style_screenTemp_imgbtnAuto_main, LV_STATE_CHECKED, lv_color_make(0x80, 0x80, 0x80));
	lv_style_set_image_recolor_opa(&style_screenTemp_imgbtnAuto_main, LV_STATE_CHECKED, 100);
	lv_obj_add_style(ui->screenTemp_imgbtnAuto, LV_IMGBTN_PART_MAIN, &style_screenTemp_imgbtnAuto_main);
	lv_obj_set_pos(ui->screenTemp_imgbtnAuto, 35, 133);
	lv_obj_set_size(ui->screenTemp_imgbtnAuto, 55, 55);
	lv_imgbtn_set_src(ui->screenTemp_imgbtnAuto,LV_BTN_STATE_RELEASED,&_btn_small_bg_auto_alpha_55x55);
	lv_imgbtn_set_src(ui->screenTemp_imgbtnAuto,LV_BTN_STATE_PRESSED,&_btn_small_bg_auto_alpha_55x55);
	lv_imgbtn_set_src(ui->screenTemp_imgbtnAuto,LV_BTN_STATE_CHECKED_RELEASED,&_btn_small_bg_auto_alpha_55x55);
	lv_imgbtn_set_src(ui->screenTemp_imgbtnAuto,LV_BTN_STATE_CHECKED_PRESSED,&_btn_small_bg_auto_alpha_55x55);
	lv_imgbtn_set_checkable(ui->screenTemp_imgbtnAuto, true);

	//Write codes screenTemp_imgbtnFire
	ui->screenTemp_imgbtnFire = lv_imgbtn_create(ui->screenTemp, NULL);

	//Write style LV_IMGBTN_PART_MAIN for screenTemp_imgbtnFire
	static lv_style_t style_screenTemp_imgbtnFire_main;
	lv_style_init(&style_screenTemp_imgbtnFire_main);

	//Write style state: LV_STATE_DEFAULT for style_screenTemp_imgbtnFire_main
	lv_style_set_text_color(&style_screenTemp_imgbtnFire_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_image_recolor(&style_screenTemp_imgbtnFire_main, LV_STATE_DEFAULT, lv_color_make(0x78, 0x78, 0x78));
	lv_style_set_image_recolor_opa(&style_screenTemp_imgbtnFire_main, LV_STATE_DEFAULT, 0);
	lv_style_set_image_opa(&style_screenTemp_imgbtnFire_main, LV_STATE_DEFAULT, 255);

	//Write style state: LV_STATE_CHECKED for style_screenTemp_imgbtnFire_main
	lv_style_set_text_color(&style_screenTemp_imgbtnFire_main, LV_STATE_CHECKED, lv_color_make(0xFF, 0x33, 0xFF));
	lv_style_set_image_recolor(&style_screenTemp_imgbtnFire_main, LV_STATE_CHECKED, lv_color_make(0x80, 0x80, 0x80));
	lv_style_set_image_recolor_opa(&style_screenTemp_imgbtnFire_main, LV_STATE_CHECKED, 100);
	lv_obj_add_style(ui->screenTemp_imgbtnFire, LV_IMGBTN_PART_MAIN, &style_screenTemp_imgbtnFire_main);
	lv_obj_set_pos(ui->screenTemp_imgbtnFire, 35, 203);
	lv_obj_set_size(ui->screenTemp_imgbtnFire, 55, 55);
	lv_imgbtn_set_src(ui->screenTemp_imgbtnFire,LV_BTN_STATE_RELEASED,&_btn_small_bg_fire_alpha_55x55);
	lv_imgbtn_set_src(ui->screenTemp_imgbtnFire,LV_BTN_STATE_PRESSED,&_btn_small_bg_fire_alpha_55x55);
	lv_imgbtn_set_src(ui->screenTemp_imgbtnFire,LV_BTN_STATE_CHECKED_RELEASED,&_btn_small_bg_fire_alpha_55x55);
	lv_imgbtn_set_src(ui->screenTemp_imgbtnFire,LV_BTN_STATE_CHECKED_PRESSED,&_btn_small_bg_fire_alpha_55x55);
	lv_imgbtn_set_checkable(ui->screenTemp_imgbtnFire, true);

	//Write codes screenTemp_arcTempControl
	ui->screenTemp_arcTempControl = lv_arc_create(ui->screenTemp, NULL);

	//Write style LV_ARC_PART_BG for screenTemp_arcTempControl
	static lv_style_t style_screenTemp_arcTempControl_bg;
	lv_style_init(&style_screenTemp_arcTempControl_bg);

	//Write style state: LV_STATE_DEFAULT for style_screenTemp_arcTempControl_bg
	lv_style_set_bg_color(&style_screenTemp_arcTempControl_bg, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_color(&style_screenTemp_arcTempControl_bg, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_dir(&style_screenTemp_arcTempControl_bg, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screenTemp_arcTempControl_bg, LV_STATE_DEFAULT, 0);
	lv_style_set_border_width(&style_screenTemp_arcTempControl_bg, LV_STATE_DEFAULT, 0);
	lv_style_set_line_color(&style_screenTemp_arcTempControl_bg, LV_STATE_DEFAULT, lv_color_make(0x8a, 0x8a, 0x8a));
	lv_style_set_line_width(&style_screenTemp_arcTempControl_bg, LV_STATE_DEFAULT, 5);
	lv_obj_add_style(ui->screenTemp_arcTempControl, LV_ARC_PART_BG, &style_screenTemp_arcTempControl_bg);

	//Write style LV_ARC_PART_INDIC for screenTemp_arcTempControl
	static lv_style_t style_screenTemp_arcTempControl_indic;
	lv_style_init(&style_screenTemp_arcTempControl_indic);

	//Write style state: LV_STATE_DEFAULT for style_screenTemp_arcTempControl_indic
	lv_style_set_line_color(&style_screenTemp_arcTempControl_indic, LV_STATE_DEFAULT, lv_color_make(0x52, 0x52, 0xff));
	lv_style_set_line_width(&style_screenTemp_arcTempControl_indic, LV_STATE_DEFAULT, 5);
	lv_obj_add_style(ui->screenTemp_arcTempControl, LV_ARC_PART_INDIC, &style_screenTemp_arcTempControl_indic);
	lv_obj_set_pos(ui->screenTemp_arcTempControl, 121, 52);
	lv_obj_set_size(ui->screenTemp_arcTempControl, 230, 230);
	lv_arc_set_bg_angles(ui->screenTemp_arcTempControl, 120, 420);
	lv_arc_set_angles(ui->screenTemp_arcTempControl, 120, 255);
	lv_arc_set_rotation(ui->screenTemp_arcTempControl, 0);
	lv_obj_set_style_local_pad_top(ui->screenTemp_arcTempControl, LV_ARC_PART_BG, LV_STATE_DEFAULT, 20);
	lv_obj_set_style_local_pad_bottom(ui->screenTemp_arcTempControl, LV_ARC_PART_BG, LV_STATE_DEFAULT, 20);
	lv_obj_set_style_local_pad_left(ui->screenTemp_arcTempControl, LV_ARC_PART_BG, LV_STATE_DEFAULT, 20);
	lv_obj_set_style_local_pad_right(ui->screenTemp_arcTempControl, LV_ARC_PART_BG, LV_STATE_DEFAULT, 20);
	lv_arc_set_adjustable(ui->screenTemp_arcTempControl, true);

	//Write codes screenTemp_imgbtnHome
	ui->screenTemp_imgbtnHome = lv_imgbtn_create(ui->screenTemp, NULL);

	//Write style LV_IMGBTN_PART_MAIN for screenTemp_imgbtnHome
	static lv_style_t style_screenTemp_imgbtnHome_main;
	lv_style_init(&style_screenTemp_imgbtnHome_main);

	//Write style state: LV_STATE_DEFAULT for style_screenTemp_imgbtnHome_main
	lv_style_set_text_color(&style_screenTemp_imgbtnHome_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_image_recolor(&style_screenTemp_imgbtnHome_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_image_recolor_opa(&style_screenTemp_imgbtnHome_main, LV_STATE_DEFAULT, 0);
	lv_style_set_image_opa(&style_screenTemp_imgbtnHome_main, LV_STATE_DEFAULT, 255);
	lv_obj_add_style(ui->screenTemp_imgbtnHome, LV_IMGBTN_PART_MAIN, &style_screenTemp_imgbtnHome_main);
	lv_obj_set_pos(ui->screenTemp_imgbtnHome, 36, 0);
	lv_obj_set_size(ui->screenTemp_imgbtnHome, 55, 50);
	lv_imgbtn_set_src(ui->screenTemp_imgbtnHome,LV_BTN_STATE_RELEASED,&_btn_long_top_house_alpha_55x50);
	lv_imgbtn_set_src(ui->screenTemp_imgbtnHome,LV_BTN_STATE_PRESSED,&_btn_long_top_house_alpha_55x50);

	//Write codes screenTemp_imgbtnTempOff
	ui->screenTemp_imgbtnTempOff = lv_imgbtn_create(ui->screenTemp, NULL);

	//Write style LV_IMGBTN_PART_MAIN for screenTemp_imgbtnTempOff
	static lv_style_t style_screenTemp_imgbtnTempOff_main;
	lv_style_init(&style_screenTemp_imgbtnTempOff_main);

	//Write style state: LV_STATE_DEFAULT for style_screenTemp_imgbtnTempOff_main
	lv_style_set_text_color(&style_screenTemp_imgbtnTempOff_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_text_font(&style_screenTemp_imgbtnTempOff_main, LV_STATE_DEFAULT, &lv_font_montserratMedium_20);
	lv_style_set_image_recolor(&style_screenTemp_imgbtnTempOff_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_image_recolor_opa(&style_screenTemp_imgbtnTempOff_main, LV_STATE_DEFAULT, 0);
	lv_style_set_image_opa(&style_screenTemp_imgbtnTempOff_main, LV_STATE_DEFAULT, 255);
	lv_obj_add_style(ui->screenTemp_imgbtnTempOff, LV_IMGBTN_PART_MAIN, &style_screenTemp_imgbtnTempOff_main);
	lv_obj_set_pos(ui->screenTemp_imgbtnTempOff, 389, 222);
	lv_obj_set_size(ui->screenTemp_imgbtnTempOff, 55, 50);
	lv_imgbtn_set_src(ui->screenTemp_imgbtnTempOff,LV_BTN_STATE_RELEASED,&_btn_long_button_alpha_55x50);
	lv_imgbtn_set_src(ui->screenTemp_imgbtnTempOff,LV_BTN_STATE_PRESSED,&_btn_long_button_alpha_55x50);
	ui->screenTemp_imgbtnTempOff_label = lv_label_create(ui->screenTemp_imgbtnTempOff, NULL);
	lv_label_set_text(ui->screenTemp_imgbtnTempOff_label, "OFF");

	//Write codes screenTemp_sliderFanSpeed
	ui->screenTemp_sliderFanSpeed = lv_slider_create(ui->screenTemp, NULL);

	//Write style LV_SLIDER_PART_INDIC for screenTemp_sliderFanSpeed
	static lv_style_t style_screenTemp_sliderFanSpeed_indic;
	lv_style_init(&style_screenTemp_sliderFanSpeed_indic);

	//Write style state: LV_STATE_DEFAULT for style_screenTemp_sliderFanSpeed_indic
	lv_style_set_radius(&style_screenTemp_sliderFanSpeed_indic, LV_STATE_DEFAULT, 50);
	lv_style_set_bg_color(&style_screenTemp_sliderFanSpeed_indic, LV_STATE_DEFAULT, lv_color_make(0x52, 0x52, 0xff));
	lv_style_set_bg_grad_color(&style_screenTemp_sliderFanSpeed_indic, LV_STATE_DEFAULT, lv_color_make(0x52, 0x52, 0xff));
	lv_style_set_bg_grad_dir(&style_screenTemp_sliderFanSpeed_indic, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screenTemp_sliderFanSpeed_indic, LV_STATE_DEFAULT, 255);
	lv_obj_add_style(ui->screenTemp_sliderFanSpeed, LV_SLIDER_PART_INDIC, &style_screenTemp_sliderFanSpeed_indic);

	//Write style LV_SLIDER_PART_BG for screenTemp_sliderFanSpeed
	static lv_style_t style_screenTemp_sliderFanSpeed_bg;
	lv_style_init(&style_screenTemp_sliderFanSpeed_bg);

	//Write style state: LV_STATE_DEFAULT for style_screenTemp_sliderFanSpeed_bg
	lv_style_set_radius(&style_screenTemp_sliderFanSpeed_bg, LV_STATE_DEFAULT, 50);
	lv_style_set_bg_color(&style_screenTemp_sliderFanSpeed_bg, LV_STATE_DEFAULT, lv_color_make(0x8a, 0x8a, 0x8a));
	lv_style_set_bg_grad_color(&style_screenTemp_sliderFanSpeed_bg, LV_STATE_DEFAULT, lv_color_make(0x8a, 0x8a, 0x8a));
	lv_style_set_bg_grad_dir(&style_screenTemp_sliderFanSpeed_bg, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screenTemp_sliderFanSpeed_bg, LV_STATE_DEFAULT, 255);
	lv_style_set_outline_color(&style_screenTemp_sliderFanSpeed_bg, LV_STATE_DEFAULT, lv_color_make(0xd4, 0xd7, 0xd9));
	lv_style_set_outline_opa(&style_screenTemp_sliderFanSpeed_bg, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_left(&style_screenTemp_sliderFanSpeed_bg, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_right(&style_screenTemp_sliderFanSpeed_bg, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_top(&style_screenTemp_sliderFanSpeed_bg, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_bottom(&style_screenTemp_sliderFanSpeed_bg, LV_STATE_DEFAULT, 0);
	lv_obj_add_style(ui->screenTemp_sliderFanSpeed, LV_SLIDER_PART_BG, &style_screenTemp_sliderFanSpeed_bg);

	//Write style LV_SLIDER_PART_KNOB for screenTemp_sliderFanSpeed
	static lv_style_t style_screenTemp_sliderFanSpeed_knob;
	lv_style_init(&style_screenTemp_sliderFanSpeed_knob);

	//Write style state: LV_STATE_DEFAULT for style_screenTemp_sliderFanSpeed_knob
	lv_style_set_radius(&style_screenTemp_sliderFanSpeed_knob, LV_STATE_DEFAULT, 50);
	lv_style_set_bg_color(&style_screenTemp_sliderFanSpeed_knob, LV_STATE_DEFAULT, lv_color_make(0xf5, 0xf5, 0xf5));
	lv_style_set_bg_grad_color(&style_screenTemp_sliderFanSpeed_knob, LV_STATE_DEFAULT, lv_color_make(0xf5, 0xf5, 0xf5));
	lv_style_set_bg_grad_dir(&style_screenTemp_sliderFanSpeed_knob, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screenTemp_sliderFanSpeed_knob, LV_STATE_DEFAULT, 255);
	lv_obj_add_style(ui->screenTemp_sliderFanSpeed, LV_SLIDER_PART_KNOB, &style_screenTemp_sliderFanSpeed_knob);
	lv_obj_set_pos(ui->screenTemp_sliderFanSpeed, 410, 58);
	lv_obj_set_size(ui->screenTemp_sliderFanSpeed, 10, 120);
	lv_slider_set_range(ui->screenTemp_sliderFanSpeed,0, 100);
	lv_slider_set_value(ui->screenTemp_sliderFanSpeed,50,false);

	//Write codes screenTemp_imgFan
	ui->screenTemp_imgFan = lv_img_create(ui->screenTemp, NULL);

	//Write style LV_IMG_PART_MAIN for screenTemp_imgFan
	static lv_style_t style_screenTemp_imgFan_main;
	lv_style_init(&style_screenTemp_imgFan_main);

	//Write style state: LV_STATE_DEFAULT for style_screenTemp_imgFan_main
	lv_style_set_image_recolor(&style_screenTemp_imgFan_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_image_recolor_opa(&style_screenTemp_imgFan_main, LV_STATE_DEFAULT, 0);
	lv_style_set_image_opa(&style_screenTemp_imgFan_main, LV_STATE_DEFAULT, 255);
	lv_obj_add_style(ui->screenTemp_imgFan, LV_IMG_PART_MAIN, &style_screenTemp_imgFan_main);
	lv_obj_set_pos(ui->screenTemp_imgFan, 404, 188);
	lv_obj_set_size(ui->screenTemp_imgFan, 20, 20);
	lv_obj_set_click(ui->screenTemp_imgFan, true);
	lv_img_set_src(ui->screenTemp_imgFan,&_icn_fan_alpha_20x20);
	lv_img_set_pivot(ui->screenTemp_imgFan, 0,0);
	lv_img_set_angle(ui->screenTemp_imgFan, 0);

	//Write codes screenTemp_imgTempBackground
	ui->screenTemp_imgTempBackground = lv_img_create(ui->screenTemp, NULL);

	//Write style LV_IMG_PART_MAIN for screenTemp_imgTempBackground
	static lv_style_t style_screenTemp_imgTempBackground_main;
	lv_style_init(&style_screenTemp_imgTempBackground_main);

	//Write style state: LV_STATE_DEFAULT for style_screenTemp_imgTempBackground_main
	lv_style_set_image_recolor(&style_screenTemp_imgTempBackground_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_image_recolor_opa(&style_screenTemp_imgTempBackground_main, LV_STATE_DEFAULT, 0);
	lv_style_set_image_opa(&style_screenTemp_imgTempBackground_main, LV_STATE_DEFAULT, 255);
	lv_obj_add_style(ui->screenTemp_imgTempBackground, LV_IMG_PART_MAIN, &style_screenTemp_imgTempBackground_main);
	lv_obj_set_pos(ui->screenTemp_imgTempBackground, 163, 93);
	lv_obj_set_size(ui->screenTemp_imgTempBackground, 150, 150);
	lv_obj_set_click(ui->screenTemp_imgTempBackground, true);
	lv_img_set_src(ui->screenTemp_imgTempBackground,&_btn_big_bg_alpha_150x150);
	lv_img_set_pivot(ui->screenTemp_imgTempBackground, 0,0);
	lv_img_set_angle(ui->screenTemp_imgTempBackground, 0);

	//Write codes screenTemp_imgbtnTempUp
	ui->screenTemp_imgbtnTempUp = lv_imgbtn_create(ui->screenTemp, NULL);

	//Write style LV_IMGBTN_PART_MAIN for screenTemp_imgbtnTempUp
	static lv_style_t style_screenTemp_imgbtnTempUp_main;
	lv_style_init(&style_screenTemp_imgbtnTempUp_main);

	//Write style state: LV_STATE_DEFAULT for style_screenTemp_imgbtnTempUp_main
	lv_style_set_text_color(&style_screenTemp_imgbtnTempUp_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_image_recolor(&style_screenTemp_imgbtnTempUp_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_image_recolor_opa(&style_screenTemp_imgbtnTempUp_main, LV_STATE_DEFAULT, 0);
	lv_style_set_image_opa(&style_screenTemp_imgbtnTempUp_main, LV_STATE_DEFAULT, 255);
	lv_obj_add_style(ui->screenTemp_imgbtnTempUp, LV_IMGBTN_PART_MAIN, &style_screenTemp_imgbtnTempUp_main);
	lv_obj_set_pos(ui->screenTemp_imgbtnTempUp, 204, 105);
	lv_obj_set_size(ui->screenTemp_imgbtnTempUp, 60, 30);
	lv_imgbtn_set_src(ui->screenTemp_imgbtnTempUp,LV_BTN_STATE_RELEASED,&_icn_arrow_up_alpha_60x30);
	lv_imgbtn_set_src(ui->screenTemp_imgbtnTempUp,LV_BTN_STATE_PRESSED,&_icn_arrow_up_alpha_60x30);

	//Write codes screenTemp_imgbtnTempDown
	ui->screenTemp_imgbtnTempDown = lv_imgbtn_create(ui->screenTemp, NULL);

	//Write style LV_IMGBTN_PART_MAIN for screenTemp_imgbtnTempDown
	static lv_style_t style_screenTemp_imgbtnTempDown_main;
	lv_style_init(&style_screenTemp_imgbtnTempDown_main);

	//Write style state: LV_STATE_DEFAULT for style_screenTemp_imgbtnTempDown_main
	lv_style_set_text_color(&style_screenTemp_imgbtnTempDown_main, LV_STATE_DEFAULT, lv_color_make(0x00, 0x00, 0x00));
	lv_style_set_image_recolor(&style_screenTemp_imgbtnTempDown_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_image_recolor_opa(&style_screenTemp_imgbtnTempDown_main, LV_STATE_DEFAULT, 0);
	lv_style_set_image_opa(&style_screenTemp_imgbtnTempDown_main, LV_STATE_DEFAULT, 255);
	lv_obj_add_style(ui->screenTemp_imgbtnTempDown, LV_IMGBTN_PART_MAIN, &style_screenTemp_imgbtnTempDown_main);
	lv_obj_set_pos(ui->screenTemp_imgbtnTempDown, 206, 202);
	lv_obj_set_size(ui->screenTemp_imgbtnTempDown, 60, 30);
	lv_imgbtn_set_src(ui->screenTemp_imgbtnTempDown,LV_BTN_STATE_RELEASED,&_icn_arrow_down_alpha_60x30);
	lv_imgbtn_set_src(ui->screenTemp_imgbtnTempDown,LV_BTN_STATE_PRESSED,&_icn_arrow_down_alpha_60x30);

	//Write codes screenTemp_labelTempSet
	ui->screenTemp_labelTempSet = lv_label_create(ui->screenTemp, NULL);
	lv_label_set_text(ui->screenTemp_labelTempSet, "68");
	lv_label_set_long_mode(ui->screenTemp_labelTempSet, LV_LABEL_LONG_BREAK);
	lv_label_set_align(ui->screenTemp_labelTempSet, LV_LABEL_ALIGN_CENTER);

	//Write style LV_LABEL_PART_MAIN for screenTemp_labelTempSet
	static lv_style_t style_screenTemp_labelTempSet_main;
	lv_style_init(&style_screenTemp_labelTempSet_main);

	//Write style state: LV_STATE_DEFAULT for style_screenTemp_labelTempSet_main
	lv_style_set_radius(&style_screenTemp_labelTempSet_main, LV_STATE_DEFAULT, 0);
	lv_style_set_bg_color(&style_screenTemp_labelTempSet_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_color(&style_screenTemp_labelTempSet_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_dir(&style_screenTemp_labelTempSet_main, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screenTemp_labelTempSet_main, LV_STATE_DEFAULT, 0);
	lv_style_set_text_color(&style_screenTemp_labelTempSet_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_text_font(&style_screenTemp_labelTempSet_main, LV_STATE_DEFAULT, &lv_font_simsun_48);
	lv_style_set_text_letter_space(&style_screenTemp_labelTempSet_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_left(&style_screenTemp_labelTempSet_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_right(&style_screenTemp_labelTempSet_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_top(&style_screenTemp_labelTempSet_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_bottom(&style_screenTemp_labelTempSet_main, LV_STATE_DEFAULT, 0);
	lv_obj_add_style(ui->screenTemp_labelTempSet, LV_LABEL_PART_MAIN, &style_screenTemp_labelTempSet_main);
	lv_obj_set_pos(ui->screenTemp_labelTempSet, 202, 144);
	lv_obj_set_size(ui->screenTemp_labelTempSet, 68, 0);

	//Write codes screenTemp_labelTempDegree
	ui->screenTemp_labelTempDegree = lv_label_create(ui->screenTemp, NULL);
	lv_label_set_text(ui->screenTemp_labelTempDegree, "0");
	lv_label_set_long_mode(ui->screenTemp_labelTempDegree, LV_LABEL_LONG_BREAK);
	lv_label_set_align(ui->screenTemp_labelTempDegree, LV_LABEL_ALIGN_CENTER);

	//Write style LV_LABEL_PART_MAIN for screenTemp_labelTempDegree
	static lv_style_t style_screenTemp_labelTempDegree_main;
	lv_style_init(&style_screenTemp_labelTempDegree_main);

	//Write style state: LV_STATE_DEFAULT for style_screenTemp_labelTempDegree_main
	lv_style_set_radius(&style_screenTemp_labelTempDegree_main, LV_STATE_DEFAULT, 0);
	lv_style_set_bg_color(&style_screenTemp_labelTempDegree_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_color(&style_screenTemp_labelTempDegree_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_bg_grad_dir(&style_screenTemp_labelTempDegree_main, LV_STATE_DEFAULT, LV_GRAD_DIR_VER);
	lv_style_set_bg_opa(&style_screenTemp_labelTempDegree_main, LV_STATE_DEFAULT, 0);
	lv_style_set_text_color(&style_screenTemp_labelTempDegree_main, LV_STATE_DEFAULT, lv_color_make(0xff, 0xff, 0xff));
	lv_style_set_text_font(&style_screenTemp_labelTempDegree_main, LV_STATE_DEFAULT, &lv_font_simsun_12);
	lv_style_set_text_letter_space(&style_screenTemp_labelTempDegree_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_left(&style_screenTemp_labelTempDegree_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_right(&style_screenTemp_labelTempDegree_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_top(&style_screenTemp_labelTempDegree_main, LV_STATE_DEFAULT, 0);
	lv_style_set_pad_bottom(&style_screenTemp_labelTempDegree_main, LV_STATE_DEFAULT, 0);
	lv_obj_add_style(ui->screenTemp_labelTempDegree, LV_LABEL_PART_MAIN, &style_screenTemp_labelTempDegree_main);
	lv_obj_set_pos(ui->screenTemp_labelTempDegree, 265, 146);
	lv_obj_set_size(ui->screenTemp_labelTempDegree, 5, 0);

	//Init events for screen
	events_init_screenTemp(ui);
}