/****************************************************************************
*
*   The MIT License (MIT)
*
*   Copyright 2014 Vivante Corporation
*   All Rights Reserved.
*
*   Permission is hereby granted, free of charge, to any person obtaining a copy
*   of this software and associated documentation files (the "Software"), to
*   deal in the Software without restriction, including without limitation the
*   rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
*   sell copies of the Software, and to permit persons to whom the Software is
*   furnished to do so, subject to the following conditions:
*
*   The above copyright notice and this permission notice shall be included in
*   all copies or substantial portions of the Software.
*
*   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
*   IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
*   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
*   AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
*   LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
*   FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
*   IN THE SOFTWARE.
*
*****************************************************************************/

/*	Created by sw-builder on 6/25/14.
 *
 *	Optimization (on 02/07/20): Paths having the same colour were
 *	concatenated. This is needed to increase the performance in terms of
 *	FPS. The number of paths to be tessellated is reduced from 236 to 131.
 */

#ifndef __TIGER_PATHS_H__
#define __TIGER_PATHS_H__

#include "vg_lite.h"

/* path_data0 ===========================================*/
signed char path_data0[] = {
	2, -30.576000, 21.071251,
	8, -30.576000, 21.071251, -30.550751, 21.544750, -30.756750, 21.540001,
	8, -30.962749, 21.535250, -35.076248, 9.516500, -40.208248, 10.077250,
	8, -40.208248, 10.077250, -35.762501, 8.239000, -30.576000, 21.071251,
/* path_data1 ===========================================*/
	2, -29.693501, 20.315500,
	8, -29.693501, 20.315500, -29.830750, 20.769501, -30.023001, 20.694750,
	8, -30.215000, 20.620251, -29.994249, 7.918750, -35.010750, 6.700250,
	8, -35.010750, 6.700250, -30.205000, 6.484250, -29.693501, 20.315500,
/* path_data2 ===========================================*/
	2, -22.820999, 30.897499,
	8, -22.820999, 30.897499, -22.412001, 31.137501, -22.529499, 31.306749,
	8, -22.647249, 31.476000, -34.940750, 28.275499, -37.304501, 32.864750,
	8, -37.304501, 32.864750, -36.384750, 28.143000, -22.820999, 30.897499,
/* path_data3 ===========================================*/
	2, -23.523251, 33.450249,
	8, -23.523251, 33.450249, -23.059250, 33.549252, -23.117750, 33.747002,
	8, -23.176001, 33.944752, -35.851749, 34.780251, -36.649250, 39.880501,
	8, -36.649250, 39.880501, -37.263748, 35.109249, -23.523251, 33.450249,
/* path_data4 ===========================================*/
	2, -24.576000, 32.069000,
	8, -24.576000, 32.069000, -24.131500, 32.234749, -24.218000, 32.421749,
	8, -24.304501, 32.608749, -36.966499, 31.586500, -38.499500, 36.515999,
	8, -38.499500, 36.515999, -38.411499, 31.706249, -24.576000, 32.069000,
/* path_data5 ===========================================*/
	2, -27.252251, 27.518000,
	8, -27.252251, 27.518000, -26.925249, 27.861500, -27.084999, 27.991751,
	8, -27.244749, 28.122000, -38.180500, 21.658501, -41.717251, 25.419001,
	8, -41.717251, 25.419001, -39.532001, 21.133249, -27.252251, 27.518000,
/* path_data6 ===========================================*/
	2, -29.138500, 28.565750,
	8, -29.138500, 28.565750, -28.774500, 28.870001, -28.918501, 29.017750,
	8, -29.062500, 29.165251, -40.659500, 23.980499, -43.748001, 28.117250,
	8, -43.748001, 28.117250, -42.061749, 23.611750, -29.138500, 28.565750,
/* path_data7 ===========================================*/
	2, -29.788500, 29.583750,
	8, -29.788500, 29.583750, -29.386499, 29.835751, -29.509001, 30.001499,
	8, -29.631500, 30.167250, -41.827000, 26.611500, -44.322750, 31.130501,
	8, -44.322750, 31.130501, -43.266499, 26.437250, -29.788500, 29.583750,
	0
};

/* path_data8 ===========================================*/
signed char path_data8[] = {
	2, -27.105000, 29.737249,
	8, -27.105000, 29.737249, -26.824499, 30.120001, -26.999750, 30.228750,
	8, -27.174999, 30.337500, -37.192249, 22.525499, -41.181751, 25.801750,
	8, -41.181751, 25.801750, -38.465500, 21.831499, -27.105000, 29.737249,
/* path_data9 ===========================================*/
	2, -32.049999, 22.500000,
	8, -32.049999, 22.500000, -31.900000, 22.950001, -32.099998, 23.000000,
	8, -32.299999, 23.049999, -39.450001, 12.550000, -44.250252, 14.450000,
	8, -44.250252, 14.450000, -40.450001, 11.500000, -32.049999, 22.500000,
/* path_data10 ===========================================*/
	2, -31.876249, 24.244749,
	8, -31.876249, 24.244749, -31.632500, 24.652000, -31.817249, 24.743750,
	8, -32.001751, 24.835751, -41.248001, 16.124750, -45.525249, 19.015249,
	8, -45.525249, 19.015249, -42.451000, 15.315250, -31.876249, 24.244749,
/* path_data11 ===========================================*/
	2, -31.905001, 25.337250,
	8, -31.905001, 25.337250, -31.624500, 25.719999, -31.799749, 25.828751,
	8, -31.975000, 25.937250, -41.992249, 18.125500, -45.981750, 21.401751,
	8, -45.981750, 21.401751, -43.265499, 17.431499, -31.905001, 25.337250,
	0
};

/* path_data12 ===========================================*/
signed char path_data12[] = {
	2, -32.457500, 25.766251,
	8, -32.331749, 27.278250, -32.084751, 28.920500, -31.650000, 29.700251,
	8, -31.650000, 29.700251, -32.549999, 32.800251, -30.350000, 36.100250,
	8, -30.350000, 36.100250, -30.450001, 37.900249, -30.049999, 38.700249,
	8, -30.049999, 38.700249, -29.049999, 40.800251, -27.850000, 41.000252,
	8, -26.879000, 41.161999, -24.698250, 41.929249, -22.233000, 42.280251,
	8, -22.233000, 42.280251, -17.950001, 45.800251, -18.750000, 49.000252,
	8, -18.750000, 49.000252, -18.850000, 53.100250, -19.750000, 53.500252,
	8, -19.750000, 53.500252, -16.850000, 50.700249, -19.250000, 54.900249,
	4, -20.350000, 59.600250,
	8, -20.350000, 59.600250, -13.950000, 54.200249, -17.850000, 58.800251,
	4, -20.350000, 65.300247,
	8, -20.350000, 65.300247, -15.450000, 60.700249, -17.250000, 62.800251,
	4, -18.049999, 65.000252,
	8, -18.049999, 65.000252, -7.250000, 58.200249, -14.950000, 65.600250,
	8, -14.950000, 65.600250, -12.950000, 64.700249, -11.850000, 65.400253,
	8, -11.850000, 65.400253, -10.150000, 65.100250, -10.350000, 65.500252,
	8, -10.350000, 65.500252, -15.550000, 68.100250, -16.450001, 72.700249,
	8, -16.450001, 72.700249, -14.350000, 70.200249, -15.150000, 72.900253,
	4, -15.050000, 75.800247,
	8, -15.050000, 75.800247, -14.050000, 70.400253, -14.150000, 79.800247,
	8, -14.150000, 79.800247, -9.350000, 75.300247, -12.250000, 80.500252,
	4, -12.250000, 84.700249,
	8, -12.250000, 84.700249, -8.450000, 80.600250, -10.050000, 83.800247,
	8, -10.050000, 83.800247, -7.550000, 81.600250, -8.550000, 85.400253,
	8, -8.550000, 85.400253, -8.750000, 88.000252, -7.650000, 85.200249,
	8, -7.650000, 85.200249, -3.650000, 77.550247, -5.150000, 84.100250,
	8, -5.150000, 84.100250, -5.350000, 88.900253, -4.150000, 85.200249,
	8, -4.150000, 85.200249, -4.050000, 87.800247, -1.750000, 89.600250,
	8, -1.750000, 89.600250, -2.050000, 76.900253, 1.150000, 85.900253,
	4, 2.150000, 90.000252,
	8, 2.150000, 90.000252, 2.850000, 87.700249, 2.750000, 86.400253,
	8, 2.750000, 86.400253, 6.450000, 82.300247, 4.750000, 88.400253,
	8, 4.750000, 88.400253, 8.550000, 82.700249, 7.750000, 86.000252,
	8, 7.750000, 86.000252, 5.850000, 90.000252, 6.250000, 91.200249,
	8, 6.250000, 91.200249, 10.450000, 82.500252, 10.750000, 82.100250,
	8, 10.750000, 82.100250, 10.250000, 92.700500, 12.950000, 83.700249,
	8, 12.950000, 83.700249, 14.350000, 86.700249, 13.650000, 87.800247,
	8, 13.650000, 87.800247, 15.650000, 85.800247, 15.450000, 85.000252,
	8, 15.450000, 85.000252, 16.600000, 82.950249, 17.299999, 86.350250,
	8, 17.299999, 86.350250, 17.750000, 88.700249, 18.150000, 87.900253,
	8, 18.150000, 87.900253, 19.150000, 93.900497, 19.450001, 88.200249,
	8, 19.450001, 88.200249, 19.850000, 84.800247, 18.049999, 81.900253,
	8, 18.049999, 81.900253, 18.250000, 81.100250, 17.549999, 80.100250,
	8, 17.549999, 80.100250, 20.950001, 85.500252, 19.150000, 78.300247,
	8, 19.150000, 78.300247, 21.950251, 80.300247, 22.250250, 80.300247,
	8, 22.250250, 80.300247, 18.850000, 74.500252, 21.049999, 75.700249,
	8, 21.049999, 75.700249, 19.750000, 73.100250, 24.250250, 76.100250,
	8, 24.250250, 76.100250, 20.250000, 72.100250, 24.650249, 74.500252,
	8, 24.650249, 74.500252, 26.650249, 76.100250, 24.750250, 73.600250,
	8, 24.750250, 73.600250, 21.150000, 69.600250, 26.650249, 74.100250,
	8, 26.650249, 74.100250, 29.550249, 78.200249, 29.750250, 78.900253,
	8, 29.750250, 78.900253, 27.250250, 71.600250, 26.150249, 70.900253,
	8, 26.150249, 70.900253, 28.250250, 61.800251, 38.550251, 65.700249,
	8, 38.550251, 65.700249, 40.250252, 70.000252, 41.350250, 65.400253,
	8, 41.350250, 65.400253, 44.550251, 63.800251, 47.350250, 70.700249,
	8, 47.350250, 70.700249, 48.350250, 67.300247, 48.150249, 66.600250,
	8, 48.150249, 66.600250, 49.850250, 66.900253, 49.650249, 66.600250,
	8, 49.650249, 66.600250, 52.950249, 67.700249, 53.250252, 67.500252,
	8, 53.250252, 67.500252, 54.950249, 69.200249, 55.050251, 68.300247,
	8, 55.050251, 68.300247, 57.350250, 69.000252, 56.850250, 68.100250,
	8, 56.850250, 68.100250, 59.050251, 72.000252, 59.150249, 72.900253,
	4, 59.750252, 69.400253,
	4, 60.250252, 70.100250,
	8, 60.250252, 70.100250, 60.650249, 68.200249, 60.450249, 67.900253,
	8, 60.250252, 67.600250, 65.450249, 69.600250, 66.650253, 74.800247,
	4, 67.150253, 76.900253,
	8, 67.150253, 76.900253, 68.650253, 73.200249, 68.250252, 72.200249,
	8, 68.250252, 72.200249, 69.550247, 72.400253, 69.650253, 73.500252,
	8, 69.650253, 73.500252, 70.650253, 67.700249, 69.450249, 66.200249,
	8, 69.450249, 66.200249, 70.550247, 66.000252, 70.850250, 66.900253,
	4, 70.850250, 65.100250,
	8, 70.850250, 65.100250, 72.650253, 65.300247, 72.650253, 64.700249,
	8, 72.650253, 64.700249, 73.750252, 63.700249, 74.250252, 64.900253,
	8, 74.250252, 64.900253, 71.150253, 56.100250, 75.750252, 60.900249,
	8, 75.750252, 60.900249, 77.550247, 63.600250, 76.650253, 58.900249,
	8, 75.750252, 54.200249, 74.750252, 53.800251, 75.950249, 53.700249,
	8, 75.950249, 53.700249, 76.150253, 52.800251, 75.650253, 52.400249,
	8, 75.150253, 52.000252, 75.950249, 52.400249, 75.950249, 52.400249,
	8, 75.950249, 52.400249, 77.150253, 53.400249, 75.850250, 47.900249,
	8, 75.850250, 47.900249, 77.450249, 48.300251, 74.450249, 41.000252,
	8, 74.450249, 41.000252, 75.150253, 40.400249, 74.150253, 38.300251,
	8, 74.150253, 38.300251, 76.150253, 39.400249, 76.850250, 39.000252,
	8, 76.850250, 39.000252, 76.750252, 38.600250, 75.950249, 37.600250,
	8, 75.950249, 37.600250, 70.550247, 23.900000, 75.650253, 29.400249,
	8, 75.650253, 29.400249, 78.612747, 32.787750, 77.012749, 27.087749,
	8, 77.012749, 27.087749, 74.735001, 21.085251, 74.929253, 20.011250,
	4, -32.457500, 25.766251,
	0
};

/* path_data13 ===========================================*/
signed char path_data13[] = {
	2, 74.929253, 20.061251,
	8, 75.086250, 20.106501, 75.637749, 20.387501, 75.950249, 20.799999,
	8, 75.950249, 20.799999, 77.650253, 23.500000, 76.350250, 18.900000,
	8, 76.350250, 18.900000, 74.050247, 11.700000, 76.250252, 14.500000,
	8, 76.250252, 14.500000, 77.750252, 16.299999, 76.950249, 12.900000,
	8, 75.984001, 8.793250, 75.350250, 7.200000, 75.350250, 7.200000,
	8, 75.350250, 7.200000, 78.250252, 8.400000, 71.550247, -1.500000,
	4, 73.750252, -0.600000,
	8, 73.750252, -0.600000, 68.850250, -10.500000, 63.450249, -11.800000,
	4, 61.450249, -13.300000,
	8, 61.450249, -13.300000, 71.050247, -22.799999, 67.850250, -32.000000,
	8, 67.850250, -32.000000, 66.150253, -33.299999, 63.750252, -31.000000,
	8, 63.750252, -31.000000, 62.150249, -29.799999, 60.650249, -30.200001,
	8, 60.650249, -30.200001, 52.950249, -29.900000, 52.450249, -29.900000,
	8, 51.950249, -29.900000, 43.250252, -39.200001, 26.850250, -34.799999,
	8, 26.850250, -34.799999, 25.550249, -34.299999, 24.450251, -34.599998,
	8, 24.450251, -34.599998, 19.850000, -38.599998, 7.650000, -32.900002,
	8, 7.650000, -32.900002, 5.150000, -32.400002, 4.750000, -32.400002,
	8, 4.350000, -32.400002, 3.650000, -32.400002, 1.650000, -30.799999,
	8, -0.350000, -29.200001, -0.450000, -29.000000, -0.950000, -28.600000,
	8, -0.950000, -28.600000, -5.050000, -25.799999, -6.250000, -25.600000,
	8, -6.250000, -25.600000, -9.150000, -24.000000, -10.250000, -21.500000,
	4, -11.150000, -21.200001,
	8, -11.150000, -21.200001, -11.550000, -19.400000, -11.650000, -19.100000,
	8, -11.650000, -19.100000, -12.850000, -18.200001, -13.050000, -16.799999,
	8, -13.050000, -16.799999, -15.250000, -15.300000, -15.150000, -14.200000,
	8, -15.150000, -14.200000, -15.550000, -12.900000, -15.750000, -11.700000,
	8, -15.750000, -11.700000, -17.549999, -10.500000, -17.350000, -9.800000,
	8, -17.350000, -9.800000, -19.250000, -6.300000, -18.950001, -4.600000,
	8, -18.950001, -4.600000, -20.549999, -4.700000, -21.250000, -4.100000,
	8, -21.250000, -4.100000, -21.450001, -2.900000, -21.850000, -2.800000,
	8, -21.850000, -2.800000, -22.549999, -2.500000, -21.950001, -1.500000,
	8, -21.950001, -1.500000, -22.350000, -0.800000, -22.450001, -0.400000,
	8, -22.450001, -0.400000, -22.250000, 0.300000, -23.350000, 1.700000,
	8, -23.350000, 1.700000, -24.950001, 6.400000, -24.450001, 7.700000,
	8, -24.450001, 7.700000, -24.350000, 8.900000, -25.049999, 9.300000,
	8, -25.049999, 9.300000, -25.950001, 9.200000, -23.850000, 12.200000,
	8, -23.850000, 12.200000, -23.650000, 12.500000, -24.450001, 13.100000,
	8, -24.450001, 13.100000, -28.750000, 14.000000, -29.350000, 18.100000,
	8, -29.350000, 18.100000, -32.750000, 21.799999, -32.750000, 23.100000,
	8, -32.750000, 23.676250, -32.682251, 24.462999, -32.507500, 25.616249,
	8, -32.507500, 25.616249, -32.650002, 27.700251, -25.750000, 27.900249,
	8, -18.850000, 28.100250, 74.929253, 20.061251, 74.929253, 20.061251,
	0
};

/* path_data14 ===========================================*/
signed char path_data14[] = {
	2, -28.900000, 25.650000,
	8, -35.150002, 15.800000, -31.549999, 29.900249, -31.549999, 29.900249,
	8, -29.350000, 38.500252, 3.050000, 29.100250, 3.050000, 29.100250,
	8, 3.050000, 29.100250, 45.250252, 21.500000, 48.050251, 20.500000,
	8, 50.850250, 19.500000, 74.650253, 21.100000, 74.650253, 21.100000,
	4, 73.250252, 16.900000,
	8, 57.050251, 5.300000, 52.250252, 11.100000, 48.850250, 10.100000,
	8, 45.450249, 9.100000, 46.050251, 11.500000, 45.250252, 11.700000,
	8, 44.450249, 11.900000, 34.650249, 5.700000, 33.050251, 5.900000,
	8, 31.450251, 6.100000, 25.114750, 0.162250, 28.850250, 8.100000,
	8, 32.850250, 16.600000, 14.250000, 17.900000, 10.050000, 15.100000,
	8, 5.850000, 12.300000, 11.850000, 19.700001, 11.850000, 19.700001,
	8, 16.450001, 24.700001, 7.850000, 20.500000, 7.850000, 20.500000,
	8, -0.750000, 17.299999, -6.750000, 23.700001, -7.550000, 23.900000,
	8, -8.350000, 24.100000, -9.550000, 24.900000, -9.750000, 23.299999,
	8, -9.950000, 21.700001, -11.827500, 17.524750, -19.750000, 24.100000,
	8, -24.750000, 28.250250, -28.200001, 22.750000, -28.200001, 22.750000,
	4, -28.900000, 25.650000,
	0
};

/* path_data15 ===========================================*/
signed char path_data15[] = {
	2, 33.377499, 6.336500,
	8, 31.777500, 6.536500, 25.435749, 0.601750, 29.177500, 8.536500,
	8, 33.327499, 17.336500, 14.577500, 18.336500, 10.377500, 15.536500,
	8, 6.177250, 12.736500, 12.177500, 20.136499, 12.177500, 20.136499,
	8, 16.777500, 25.136499, 8.177250, 20.936501, 8.177250, 20.936501,
	8, -0.422750, 17.736500, -6.422750, 24.136499, -7.222750, 24.336500,
	8, -8.022750, 24.536501, -9.222750, 25.336500, -9.422750, 23.736500,
	8, -9.622750, 22.136499, -11.467500, 18.003000, -19.422750, 24.536501,
	8, -24.731750, 28.872999, -28.104500, 23.509251, -28.104500, 23.509251,
	4, -28.904499, 26.036501,
	8, -35.154499, 16.086500, -31.386499, 30.663750, -31.386499, 30.663750,
	8, -29.186251, 39.264000, 3.377250, 29.536501, 3.377250, 29.536501,
	8, 3.377250, 29.536501, 45.577499, 21.936501, 48.377499, 20.936501,
	8, 51.177502, 19.936501, 74.759499, 21.518250, 74.759499, 21.518250,
	4, 73.377502, 17.191000,
	8, 57.177502, 5.591000, 52.577499, 11.536500, 49.177502, 10.536500,
	8, 45.777500, 9.536500, 46.377499, 11.936500, 45.577499, 12.136500,
	8, 44.777500, 12.336500, 34.977501, 6.136500, 33.377499, 6.336500,
	0
};

/* path_data16 ===========================================*/
signed char path_data16[] = {
	2, 33.704750, 6.772750,
	8, 32.104752, 6.972750, 25.921249, 0.965500, 29.504749, 8.972750,
	8, 33.554749, 18.023001, 14.904750, 18.773001, 10.704750, 15.973000,
	8, 6.504750, 13.173000, 12.504750, 20.573000, 12.504750, 20.573000,
	8, 17.104750, 25.573000, 8.504750, 21.372999, 8.504750, 21.372999,
	8, -0.095250, 18.173000, -6.095500, 24.573000, -6.895500, 24.773001,
	8, -7.695500, 24.973000, -8.895500, 25.773001, -9.095500, 24.173000,
	8, -9.295500, 22.573000, -11.107500, 18.481251, -19.095501, 24.973000,
	8, -24.713751, 29.495750, -28.009001, 24.268499, -28.009001, 24.268499,
	4, -28.909000, 26.423000,
	8, -34.859001, 16.673000, -31.222750, 31.427500, -31.222750, 31.427500,
	8, -29.022751, 40.027500, 3.704750, 29.973000, 3.704750, 29.973000,
	8, 3.704750, 29.973000, 45.904751, 22.372999, 48.704750, 21.372999,
	8, 51.504749, 20.372999, 74.868500, 21.936501, 74.868500, 21.936501,
	4, 73.504997, 17.482000,
	8, 57.304749, 5.882000, 52.904751, 11.972750, 49.504749, 10.972750,
	8, 46.104752, 9.972750, 46.704750, 12.372750, 45.904751, 12.573000,
	8, 45.104752, 12.773000, 35.304749, 6.572750, 33.704750, 6.772750,
	0
};

/* path_data17 ===========================================*/
signed char path_data17[] = {
	2, 34.032001, 7.209250,
	8, 32.431999, 7.409250, 26.249750, 1.401250, 29.832001, 9.409250,
	8, 34.032001, 18.798250, 15.098500, 19.120501, 11.032000, 16.409250,
	8, 6.832000, 13.609250, 12.832000, 21.009251, 12.832000, 21.009251,
	8, 17.431999, 26.009251, 8.832000, 21.809250, 8.832000, 21.809250,
	8, 0.232000, 18.609249, -5.768000, 25.009251, -6.568000, 25.209249,
	8, -7.368000, 25.409250, -8.568000, 26.209249, -8.768000, 24.609249,
	8, -8.968000, 23.009251, -10.747250, 18.959749, -18.768250, 25.409250,
	8, -24.695499, 30.118500, -27.913750, 25.027500, -27.913750, 25.027500,
	4, -28.913750, 26.809250,
	8, -34.363750, 17.609249, -31.059000, 32.191250, -31.059000, 32.191250,
	8, -28.858999, 40.791248, 4.032000, 30.409250, 4.032000, 30.409250,
	8, 4.032000, 30.409250, 46.231998, 22.809250, 49.032249, 21.809250,
	8, 51.832249, 20.809250, 74.977753, 22.354750, 74.977753, 22.354750,
	4, 73.632248, 17.773001,
	8, 57.432251, 6.172750, 53.232250, 12.409250, 49.832249, 11.409250,
	8, 46.431999, 10.409250, 47.032001, 12.809250, 46.231998, 13.009250,
	8, 45.431999, 13.209250, 35.632000, 7.009250, 34.032001, 7.209250,
	0
};

/* path_data18 ===========================================*/
signed char path_data18[] = {
	2, 34.359501, 7.645750,
	8, 32.759251, 7.845750, 26.703501, 1.782250, 30.159250, 9.845750,
	8, 34.359501, 19.645750, 15.559250, 19.645750, 11.359250, 16.845751,
	8, 7.159250, 14.045750, 13.159250, 21.445749, 13.159250, 21.445749,
	8, 17.759251, 26.445749, 9.159250, 22.245750, 9.159250, 22.245750,
	8, 0.559250, 19.045750, -5.440750, 25.445749, -6.240750, 25.645750,
	8, -7.040750, 25.845751, -8.240750, 26.645750, -8.440750, 25.045750,
	8, -8.640750, 23.445749, -10.387000, 19.438000, -18.440750, 25.845751,
	8, -24.677250, 30.741249, -27.818251, 25.786501, -27.818251, 25.786501,
	4, -28.918249, 27.195749,
	8, -33.868252, 18.495501, -30.895500, 32.954750, -30.895500, 32.954750,
	8, -28.695499, 41.555000, 4.359250, 30.845751, 4.359250, 30.845751,
	8, 4.359250, 30.845751, 46.559502, 23.245750, 49.359501, 22.245750,
	8, 52.159500, 21.245750, 75.086746, 22.773001, 75.086746, 22.773001,
	4, 73.759499, 18.063749,
	8, 57.559502, 6.463750, 53.559502, 12.845750, 50.159500, 11.845750,
	8, 46.759499, 10.845750, 47.359501, 13.245750, 46.559502, 13.445750,
	8, 45.759499, 13.645750, 35.959499, 7.445750, 34.359501, 7.645750,
	0
};

/* path_data19 ===========================================*/
signed char path_data19[] = {
	2, 34.686749, 8.082000,
	8, 33.086750, 8.282000, 26.595751, 2.419250, 30.486750, 10.282000,
	8, 35.286751, 19.982000, 15.886500, 20.082001, 11.686500, 17.282000,
	8, 7.486500, 14.482000, 13.486500, 21.882000, 13.486500, 21.882000,
	8, 18.086500, 26.882000, 9.486500, 22.681999, 9.486500, 22.681999,
	8, 0.886500, 19.482000, -5.113500, 25.882000, -5.913500, 26.082001,
	8, -6.713500, 26.282000, -7.913500, 27.082001, -8.113500, 25.482000,
	8, -8.313500, 23.882000, -10.027000, 19.916250, -18.113501, 26.282000,
	8, -24.659000, 31.364000, -27.722750, 26.545750, -27.722750, 26.545750,
	4, -28.922750, 27.582001,
	8, -33.422749, 19.282000, -30.731750, 33.718498, -30.731750, 33.718498,
	8, -28.531750, 42.318501, 4.686500, 31.282000, 4.686500, 31.282000,
	8, 4.686500, 31.282000, 46.886749, 23.681999, 49.686749, 22.681999,
	8, 52.486752, 21.681999, 75.195747, 23.191000, 75.195747, 23.191000,
	4, 73.886749, 18.354750,
	8, 57.686749, 6.754750, 53.886749, 13.282000, 50.486752, 12.282000,
	8, 47.086750, 11.282000, 47.686749, 13.682000, 46.886749, 13.882000,
	8, 46.086750, 14.082000, 36.286751, 7.882000, 34.686749, 8.082000,
	0
};

/* path_data20 ===========================================*/
signed char path_data20[] = {
	2, 35.014000, 8.518250,
	8, 33.413750, 8.718250, 26.828251, 2.903250, 30.813749, 10.718250,
	8, 35.914001, 20.718500, 16.213751, 20.518499, 12.013750, 17.718500,
	8, 7.813750, 14.918500, 13.813750, 22.318501, 13.813750, 22.318501,
	8, 18.413750, 27.318501, 9.813750, 23.118500, 9.813750, 23.118500,
	8, 1.213750, 19.918501, -4.786250, 26.318501, -5.586250, 26.518499,
	8, -6.386250, 26.718500, -7.586250, 27.518499, -7.786250, 25.918501,
	8, -7.986250, 24.318501, -9.667000, 20.394501, -17.786249, 26.718500,
	8, -24.641001, 31.986750, -27.627251, 27.304750, -27.627251, 27.304750,
	4, -28.927250, 27.968500,
	8, -32.927250, 20.418501, -30.568251, 34.482250, -30.568251, 34.482250,
	8, -28.368250, 43.082249, 5.013750, 31.718500, 5.013750, 31.718500,
	8, 5.013750, 31.718500, 47.214001, 24.118500, 50.014000, 23.118500,
	8, 52.813999, 22.118500, 75.305000, 23.609249, 75.305000, 23.609249,
	4, 74.014000, 18.645750,
	8, 57.813999, 7.045750, 54.214001, 13.718500, 50.813999, 12.718500,
	8, 47.414001, 11.718250, 48.014000, 14.118500, 47.214001, 14.318500,
	8, 46.414001, 14.518500, 36.613998, 8.318250, 35.014000, 8.518250,
	0
};

/* path_data21 ===========================================*/
signed char path_data21[] = {
	2, 35.341251, 8.954750,
	8, 33.741249, 9.154750, 26.880751, 3.486000, 31.141251, 11.154750,
	8, 36.641251, 21.054750, 16.541000, 20.954750, 12.341000, 18.154751,
	8, 8.141000, 15.354750, 14.141000, 22.754749, 14.141000, 22.754749,
	8, 18.740999, 27.754749, 10.141000, 23.554750, 10.141000, 23.554750,
	8, 1.541000, 20.354750, -4.459000, 26.754749, -5.259000, 26.954750,
	8, -6.059000, 27.154751, -7.259000, 27.954750, -7.459000, 26.354750,
	8, -7.659000, 24.754749, -9.306750, 20.872999, -17.459000, 27.154751,
	8, -24.622749, 32.609501, -27.531750, 28.063999, -27.531750, 28.063999,
	4, -28.931749, 28.354750,
	8, -32.532001, 21.254749, -30.404499, 35.245750, -30.404499, 35.245750,
	8, -28.204500, 43.846001, 5.341000, 32.154751, 5.341000, 32.154751,
	8, 5.341000, 32.154751, 47.541248, 24.554750, 50.341251, 23.554750,
	8, 53.141251, 22.554750, 75.414001, 24.027500, 75.414001, 24.027500,
	4, 74.141251, 18.936501,
	8, 57.941250, 7.336500, 54.541248, 14.154750, 51.141251, 13.154750,
	8, 47.741249, 12.154750, 48.341251, 14.554750, 47.541248, 14.754750,
	8, 46.741249, 14.954750, 36.941250, 8.754750, 35.341251, 8.954750,
	0
};

/* path_data22 ===========================================*/
signed char path_data22[] = {
	2, 35.668499, 9.391250,
	8, 34.068501, 9.591250, 27.208000, 3.922250, 31.468500, 11.591250,
	8, 36.968498, 21.491249, 16.868500, 21.391251, 12.668500, 18.591249,
	8, 8.468500, 15.791250, 14.468500, 23.191250, 14.468500, 23.191250,
	8, 19.068501, 28.191250, 10.468500, 23.991249, 10.468500, 23.991249,
	8, 1.868250, 20.791250, -4.131750, 27.191250, -4.931750, 27.391251,
	8, -5.731750, 27.591249, -6.931750, 28.391251, -7.131750, 26.791250,
	8, -7.331750, 25.191250, -8.946500, 21.351250, -17.131750, 27.591249,
	8, -24.604500, 33.232250, -27.436251, 28.823250, -27.436251, 28.823250,
	4, -28.936251, 28.741249,
	8, -32.336498, 22.141001, -30.240749, 36.009499, -30.240749, 36.009499,
	8, -28.040751, 44.609501, 5.668250, 32.591251, 5.668250, 32.591251,
	8, 5.668250, 32.591251, 47.868500, 24.991249, 50.668499, 23.991249,
	8, 53.468498, 22.991249, 75.523247, 24.445749, 75.523247, 24.445749,
	4, 74.268753, 19.227501,
	8, 58.068501, 7.627500, 54.868500, 14.591250, 51.468498, 13.591250,
	8, 48.068501, 12.591250, 48.668499, 14.991250, 47.868500, 15.191250,
	8, 47.068501, 15.391250, 37.268501, 9.191250, 35.668499, 9.391250,
	0
};

/* path_data23 ===========================================*/
signed char path_data23[] = {
	2, 35.995751, 9.827500,
	8, 34.395748, 10.027500, 27.632250, 4.305750, 31.795750, 12.027500,
	8, 37.295750, 22.227501, 17.195749, 21.827499, 12.995751, 19.027500,
	8, 8.795750, 16.227501, 14.795750, 23.627501, 14.795750, 23.627501,
	8, 19.395750, 28.627501, 10.795750, 24.427500, 10.795750, 24.427500,
	8, 2.195750, 21.227501, -3.804250, 27.627501, -4.604250, 27.827499,
	8, -5.404500, 28.027500, -6.604500, 28.827499, -6.804500, 27.227501,
	8, -7.004500, 25.627501, -8.586500, 21.829500, -16.804501, 28.027500,
	8, -24.586250, 33.854999, -27.340750, 29.582251, -27.340750, 29.582251,
	4, -28.941000, 29.127501,
	8, -32.191002, 23.127501, -30.077250, 36.773251, -30.077250, 36.773251,
	8, -27.877251, 45.373249, 5.995750, 33.027500, 5.995750, 33.027500,
	8, 5.995750, 33.027500, 48.195751, 25.427500, 50.995751, 24.427500,
	8, 53.795750, 23.427500, 75.632248, 24.864000, 75.632248, 24.864000,
	4, 74.395752, 19.518499,
	8, 58.195751, 7.918250, 55.195751, 15.027500, 51.795750, 14.027500,
	8, 48.395748, 13.027500, 48.995751, 15.427500, 48.195751, 15.627500,
	8, 47.395748, 15.827500, 37.595749, 9.627500, 35.995751, 9.827500,
	0
};

/* path_data24 ===========================================*/
signed char path_data24[] = {
	2, 36.323002, 10.263750,
	8, 34.723000, 10.463750, 28.229250, 4.602750, 32.123001, 12.463750,
	8, 37.423000, 23.163999, 17.523001, 22.264000, 13.323000, 19.464001,
	8, 9.123000, 16.663999, 15.123000, 24.063999, 15.123000, 24.063999,
	8, 19.723000, 29.063999, 11.123000, 24.864000, 11.123000, 24.864000,
	8, 2.523000, 21.663999, -3.477000, 28.063999, -4.277000, 28.264000,
	8, -5.077000, 28.464001, -6.277000, 29.264000, -6.477000, 27.663999,
	8, -6.677000, 26.063999, -8.226250, 22.308000, -16.476999, 28.464001,
	8, -24.568251, 34.477749, -27.245500, 30.341250, -27.245500, 30.341250,
	4, -28.945500, 29.514000,
	8, -32.145500, 23.714001, -29.913500, 37.536751, -29.913500, 37.536751,
	8, -27.713499, 46.136749, 6.323000, 33.464001, 6.323000, 33.464001,
	8, 6.323000, 33.464001, 48.523251, 25.864000, 51.323250, 24.864000,
	8, 54.123249, 23.864000, 75.741249, 25.282000, 75.741249, 25.282000,
	4, 74.523247, 19.809250,
	8, 58.323002, 8.209250, 55.523251, 15.464000, 52.123249, 14.464000,
	8, 48.723251, 13.463750, 49.323250, 15.864000, 48.523251, 16.063999,
	8, 47.723000, 16.264000, 37.923000, 10.063750, 36.323002, 10.263750,
	0
};

/* path_data25 ===========================================*/
signed char path_data25[] = {
	2, -28.950001, 29.900250,
	8, -32.150002, 24.400000, -29.750000, 38.300251, -29.750000, 38.300251,
	8, -27.549999, 46.900250, 6.650000, 33.900250, 6.650000, 33.900250,
	8, 6.650000, 33.900250, 48.850250, 26.299999, 51.650250, 25.299999,
	8, 54.450249, 24.299999, 75.850250, 25.700001, 75.850250, 25.700001,
	4, 74.650253, 20.100001,
	8, 58.450249, 8.500000, 55.850250, 15.900000, 52.450249, 14.900000,
	8, 49.050251, 13.900000, 49.650250, 16.299999, 48.850250, 16.500000,
	8, 48.050251, 16.700001, 38.250252, 10.500000, 36.650250, 10.700000,
	8, 35.050251, 10.900000, 28.745251, 4.948250, 32.450249, 12.900000,
	8, 38.007000, 24.826750, 17.260250, 22.306749, 13.650000, 19.900000,
	8, 9.450000, 17.100001, 15.450000, 24.500000, 15.450000, 24.500000,
	8, 20.049999, 29.500250, 11.450000, 25.299999, 11.450000, 25.299999,
	8, 2.850000, 22.100001, -3.150000, 28.500250, -3.950000, 28.700251,
	8, -4.750000, 28.900250, -5.950000, 29.700251, -6.150000, 28.100250,
	8, -6.350000, 26.500000, -7.866250, 22.785999, -16.150000, 28.900250,
	8, -24.549999, 35.100250, -27.150000, 31.100250, -27.150000, 31.100250,
	4, -28.950001, 29.900250,
	0
};

/* path_data26 ===========================================*/
signed char path_data26[] = {
	2, -18.549999, 37.400250,
	8, -18.549999, 37.400250, -20.350001, 40.300251, -15.150000, 43.600250,
	8, -15.150000, 43.600250, -14.800000, 43.950249, -19.299999, 42.900250,
	8, -19.299999, 42.900250, -20.850001, 42.400250, -21.250000, 39.800251,
	8, -21.250000, 39.800251, -22.450001, 38.700249, -23.650000, 37.300251,
	8, -24.850001, 35.900250, -18.549999, 37.400250, -18.549999, 37.400250,
	0
};

/* path_data27 ===========================================*/
signed char path_data27[] = {
	2, 16.450001, 25.500000,
	8, 16.450001, 25.500000, 20.874500, 32.205250, 20.725001, 33.400250,
	8, 20.400000, 36.000252, 20.350001, 38.400250, 21.150000, 39.400250,
	8, 21.950251, 40.400250, 24.150250, 48.700249, 24.150250, 48.700249,
	8, 24.150250, 48.700249, 24.050249, 49.000252, 27.150250, 39.500252,
	8, 27.150250, 39.500252, 30.050249, 35.500252, 25.050249, 30.900250,
	8, 25.050249, 30.900250, 16.250000, 23.700001, 16.450001, 25.500000,
	0
};

/* path_data28 ===========================================*/
signed char path_data28[] = {
	2, -13.550000, 44.100250,
	8, -13.550000, 44.100250, -10.750000, 45.900250, -14.350001, 53.700249,
	4, -12.750000, 53.100250,
	8, -12.750000, 53.100250, -12.950000, 55.900250, -13.750000, 56.500252,
	4, -11.950000, 55.700249,
	8, -11.950000, 55.700249, -10.750000, 57.700249, -11.750000, 58.900250,
	8, -11.750000, 58.900250, -7.550000, 60.900250, -7.750000, 62.500252,
	8, -7.750000, 62.500252, -6.150000, 60.500252, -7.150000, 58.900250,
	8, -8.149999, 57.300251, -9.950000, 58.300251, -9.750000, 53.700249,
	4, -11.950000, 54.500252,
	8, -11.950000, 54.500252, -10.550000, 52.300251, -10.550000, 50.700249,
	4, -12.550000, 51.300251,
	8, -12.550000, 51.300251, -8.682750, 44.655750, -11.350001, 44.300251,
	8, -12.850001, 44.100250, -13.550000, 44.100250, -13.550000, 44.100250,
	0
};

/* path_data29 ===========================================*/
signed char path_data29[] = {
	2, -5.450000, 48.300251,
	8, -5.450000, 48.300251, -4.750000, 47.200249, -5.450000, 47.400250,
	8, -6.150000, 47.600250, -13.950000, 51.300251, -15.450000, 53.700249,
	8, -15.450000, 53.700249, -6.850000, 47.600250, -5.450000, 48.300251,
/* path_data30 ===========================================*/
	2, -2.850000, 50.300251,
	8, -2.850000, 50.300251, -2.150000, 49.200249, -2.850000, 49.400250,
	8, -3.550000, 49.600250, -11.350001, 53.300251, -12.850001, 55.700249,
	8, -12.850001, 55.700249, -4.250000, 49.600250, -2.850000, 50.300251,
/* path_data31 ===========================================*/
	2, 0.450000, 46.500252,
	8, 0.450000, 46.500252, 1.150000, 45.400250, 0.450000, 45.600250,
	8, -0.250000, 45.800251, -8.050000, 49.500252, -9.550000, 51.900250,
	8, -9.550000, 51.900250, -0.950000, 45.800251, 0.450000, 46.500252,
/* path_data32 ===========================================*/
	2, -5.350000, 57.400250,
	8, -5.350000, 57.400250, -5.350000, 55.900250, -6.050000, 56.100250,
	8, -6.750000, 56.300251, -15.750000, 60.700249, -17.250000, 63.100250,
	8, -17.250000, 63.100250, -6.750000, 56.700249, -5.350000, 57.400250,
/* path_data33 ===========================================*/
	2, -5.050000, 54.700249,
	8, -5.050000, 54.700249, -4.750000, 53.500252, -5.450000, 53.700249,
	8, -5.950000, 53.700249, -12.550000, 56.600250, -14.050000, 59.000252,
	8, -14.050000, 59.000252, -6.650000, 53.600250, -5.050000, 54.700249,
/* path_data34 ===========================================*/
	2, -8.649999, 66.600250,
	4, -11.150000, 68.500252,
	8, -11.150000, 68.500252, -8.550000, 66.600250, -7.650000, 66.900253,
	8, -7.650000, 66.900253, -9.350001, 69.700249, -9.550000, 71.000252,
	8, -9.550000, 71.000252, -6.950000, 67.800247, -5.550000, 67.900253,
	8, -5.550000, 67.900253, -3.650000, 68.000252, -3.650000, 70.700249,
	8, -3.650000, 70.700249, -2.250000, 68.100250, -1.450000, 68.200249,
	8, -1.450000, 68.200249, -1.150000, 69.800247, -1.450000, 71.500252,
	8, -1.450000, 71.500252, -0.450000, 69.600250, 0.550000, 70.000252,
	8, 0.550000, 70.000252, 2.150000, 69.500252, 1.950000, 72.400253,
	8, 1.950000, 72.400253, 1.950000, 75.000252, 1.750000, 75.700249,
	8, 1.750000, 75.700249, 3.150000, 69.100250, 3.750000, 69.000252,
	8, 3.750000, 69.000252, 5.750000, 68.700249, 6.950000, 70.900253,
	8, 6.950000, 70.900253, 5.950000, 69.000252, 7.150000, 69.500252,
	8, 7.150000, 69.500252, 9.850001, 69.900253, 10.650000, 71.600250,
	8, 10.650000, 71.600250, 8.950000, 68.600250, 10.350001, 69.400253,
	8, 10.350001, 69.400253, 12.050000, 69.400253, 12.350001, 71.000252,
	8, 12.350001, 71.000252, 14.450000, 76.300247, 14.950000, 76.700249,
	8, 14.950000, 76.700249, 13.050000, 71.300247, 13.450000, 71.300247,
	8, 13.450000, 71.300247, 12.950000, 68.300247, 14.250000, 72.000252,
	8, 14.250000, 72.000252, 13.450000, 68.500252, 14.850001, 68.700249,
	8, 16.250000, 68.900253, 17.350001, 71.400253, 19.450001, 70.800247,
	8, 19.450001, 70.800247, 21.850250, 72.200249, 22.350250, 54.900250,
	4, -8.649999, 66.600250,
	0
};

/* path_data35 ===========================================*/
signed char path_data35[] = {
	2, -7.450000, 43.400250,
	8, -7.450000, 43.400250, -3.750000, 41.900250, 6.250000, 43.400250,
	8, 6.250000, 43.400250, 8.050000, 43.500252, 9.750000, 41.300251,
	8, 11.450000, 39.100250, 18.150000, 37.300251, 19.750000, 37.800251,
	4, 22.150250, 39.400250,
	4, 22.350250, 39.700249,
	8, 22.350250, 39.700249, 25.450251, 42.300251, 25.550249, 44.200249,
	8, 25.650250, 46.100250, 21.950251, 58.100250, 19.549999, 62.100250,
	8, 17.150000, 66.100250, 14.750000, 69.200249, 9.950000, 68.600250,
	8, 9.950000, 68.600250, 4.750000, 67.600250, -1.650000, 68.600250,
	8, -1.650000, 68.600250, -8.950000, 68.200249, -9.649999, 66.200249,
	8, -10.350001, 64.200249, -6.850000, 60.400250, -6.850000, 60.400250,
	8, -6.850000, 60.400250, -5.750000, 58.300251, -6.050000, 54.700249,
	8, -6.350000, 51.100250, -6.250000, 44.100250, -7.450000, 43.400250,
	0
};

/* path_data36 ===========================================*/
signed char path_data36[] = {
	2, -1.950000, 43.900250,
	8, 0.150000, 48.500252, -7.250000, 64.800247, -7.250000, 64.800247,
	8, -7.750000, 65.200249, -4.085000, 66.711502, -1.550000, 66.100250,
	8, 1.186500, 65.440750, 11.250000, 66.500252, 11.250000, 66.500252,
	8, 17.150000, 62.600250, 20.350001, 51.500252, 20.350001, 51.500252,
	8, 20.350001, 51.500252, 22.950251, 45.500252, 18.549999, 44.700249,
	8, 14.150000, 43.900250, -1.950000, 43.900250, -1.950000, 43.900250,
	0
};

/* path_data37 ===========================================*/
signed char path_data37[] = {
	2, -2.457750, 51.624249,
	8, -1.626250, 48.426750, -1.230250, 45.476501, -1.950000, 43.900250,
	8, -1.950000, 43.900250, 13.650000, 45.500252, 16.450001, 40.300251,
	8, 17.510250, 38.331501, 21.200251, 46.000252, 21.100001, 48.400250,
	8, 21.100001, 48.400250, 5.350000, 52.000252, 1.650000, 49.200249,
	4, -2.457750, 51.624249,
	0
};

/* path_data38 ===========================================*/
signed char path_data38[] = {
	2, -1.350000, 55.700249,
	8, -1.350000, 55.700249, -0.850000, 57.500252, -1.450000, 58.500252,
	8, -1.450000, 58.500252, -1.850000, 58.700249, -2.150000, 58.800251,
	8, -2.150000, 58.800251, -1.850000, 59.700249, -0.350000, 60.100250,
	8, -0.350000, 60.100250, 0.150000, 61.200249, 0.750000, 61.300251,
	8, 1.350000, 61.400250, 2.550000, 62.800251, 3.550000, 62.500252,
	8, 4.550000, 62.200249, 7.350000, 61.200249, 7.350000, 61.200249,
	8, 7.350000, 61.200249, 8.750000, 60.400250, 10.950000, 61.300251,
	8, 10.950000, 61.300251, 11.543750, 61.099750, 11.650000, 60.100250,
	8, 11.775000, 58.925251, 12.550000, 58.000252, 13.050000, 57.500252,
	8, 13.550000, 57.000252, 15.950000, 53.800251, 15.650000, 53.700249,
	8, 15.350001, 53.600250, -1.350000, 55.700249, -1.350000, 55.700249,
	0
};

/* path_data39 ===========================================*/
signed char path_data39[] = {
	2, -2.450000, 43.600250,
	8, -2.450000, 43.600250, -3.150000, 49.200249, -2.350000, 51.300251,
	8, -1.550000, 53.400250, -1.750000, 53.900250, -1.950000, 54.900250,
	8, -2.150000, 55.900250, -1.050000, 58.400250, 0.350000, 59.900250,
	4, 3.350000, 60.300251,
	8, 3.350000, 60.300251, 7.150000, 59.400250, 9.450000, 60.100250,
	8, 9.450000, 60.100250, 11.698500, 60.436001, 12.550000, 56.700249,
	8, 12.550000, 56.700249, 13.750000, 55.100250, 15.550000, 54.400250,
	8, 17.350001, 53.700249, 19.150000, 43.300251, 18.150000, 41.300251,
	8, 17.150000, 39.300251, 13.550000, 38.200249, 9.550000, 42.100250,
	8, 5.550000, 46.000252, 5.050000, 41.800251, -2.450000, 43.600250,
	0
};

/* path_data40 ===========================================*/
signed char path_data40[] = {
	2, -2.050000, 62.300251,
	8, -2.050000, 62.300251, -2.250000, 61.800251, -3.350000, 61.700249,
	8, -3.350000, 61.700249, -8.950000, 60.800251, -11.050000, 57.700249,
	8, -11.050000, 57.700249, -12.750000, 56.300251, -11.650000, 59.200249,
	8, -11.650000, 59.200249, -9.050000, 64.300247, -7.350000, 65.000252,
	8, -7.350000, 65.000252, -3.250000, 66.000252, -2.050000, 62.300251,
	0
};

/* path_data41 ===========================================*/
signed char path_data41[] = {
	2, 17.935499, 46.307251,
	8, 18.100250, 44.330750, 18.588499, 42.177250, 18.150000, 41.300251,
	8, 16.538500, 38.076752, 12.295250, 39.423752, 9.550000, 42.100250,
	8, 5.550000, 46.000252, 5.050000, 41.800251, -2.450000, 43.600250,
	8, -2.450000, 43.600250, -2.886250, 47.091000, -2.676250, 49.594002,
	8, -2.676250, 49.594002, 6.650000, 46.700249, 6.850000, 48.100250,
	8, 6.850000, 48.100250, 7.250000, 47.300251, 9.550000, 47.300251,
	8, 11.850001, 47.300251, 17.535500, 47.007252, 17.935499, 46.307251,
	0
};

/* path_data42 ===========================================*/
signed char path_data42[] = {
	2, 7.150000, 43.800251,
	8, 7.150000, 43.800251, 8.350001, 45.000252, 7.450000, 47.400250,
	8, 7.450000, 47.400250, 3.850000, 51.400250, 4.350000, 54.900250,
	0
};

/* path_data43 ===========================================*/
signed char path_data43[] = {
	2, -4.850000, 65.000252,
	8, -4.850000, 65.000252, -5.950000, 61.800251, -3.750000, 63.500252,
	8, -3.750000, 63.500252, -2.550000, 64.000252, -2.850000, 64.400253,
	8, -3.150000, 64.800247, -4.550000, 65.800247, -4.850000, 65.000252,
	0
};

/* path_data44 ===========================================*/
signed char path_data44[] = {
	2, -3.590000, 65.300247,
	8, -3.590000, 65.300247, -4.470000, 62.740250, -2.710000, 64.100250,
	8, -2.710000, 64.100250, -1.604750, 64.712250, -1.990000, 64.820251,
	8, -3.130000, 65.140251, -1.990000, 65.780250, -3.590000, 65.300247,
	0
};

/* path_data45 ===========================================*/
signed char path_data45[] = {
	2, -2.390000, 65.300247,
	8, -2.390000, 65.300247, -3.270000, 62.740250, -1.510000, 64.100250,
	8, -1.510000, 64.100250, -0.416250, 64.677750, -0.790000, 64.820251,
	8, -1.630000, 65.140251, -0.790000, 65.780250, -2.390000, 65.300247,
	0
};

/* path_data46 ===========================================*/
signed char path_data46[] = {
	2, -0.740000, 65.350250,
	8, -0.740000, 65.350250, -1.620000, 62.790249, 0.140000, 64.150253,
	8, 0.140000, 64.150253, 1.235750, 64.733254, 0.860250, 64.870247,
	8, 0.120000, 65.140251, 0.860250, 65.830253, -0.740000, 65.350250,
	0
};

/* path_data47 ===========================================*/
signed char path_data47[] = {
	2, 0.880000, 65.330253,
	8, 0.880000, 65.330253, 0.000000, 62.770249, 1.760250, 64.130249,
	8, 1.760250, 64.130249, 2.720250, 64.530250, 2.480250, 64.850250,
	8, 2.240250, 65.170250, 2.480250, 65.810249, 0.880000, 65.330253,
	0
};

/* path_data48 ===========================================*/
signed char path_data48[] = {
	2, 2.550000, 65.500252,
	8, 2.550000, 65.500252, 1.350000, 62.400250, 3.650000, 64.000252,
	8, 3.650000, 64.000252, 4.850000, 64.500252, 4.550000, 64.900253,
	8, 4.250000, 65.300247, 4.550000, 66.100250, 2.550000, 65.500252,
	0
};

/* path_data49 ===========================================*/
signed char path_data49[] = {
	2, -4.550000, 61.200249,
	8, -4.550000, 61.200249, -1.250000, 60.500252, 0.250000, 61.300251,
	8, 0.250000, 61.300251, 1.750000, 61.600250, 2.050000, 61.500252,
	8, 2.350000, 61.400250, 3.150000, 61.300251, 3.150000, 61.300251,
/* path_data50 ===========================================*/
	2, 3.950000, 63.400250,
	8, 3.950000, 63.400250, 6.950000, 60.000252, 9.950000, 61.100250,
	8, 11.704000, 61.743500, 11.450000, 60.900250, 11.650000, 60.200249,
	8, 11.850001, 59.500252, 11.900000, 58.450249, 13.150000, 57.700249,
	0
};

/* path_data51 ===========================================*/
signed char path_data51[] = {
	2, 8.250000, 59.400250,
	8, 8.250000, 59.400250, 7.250000, 56.700249, 6.550000, 59.900250,
	8, 5.850000, 63.100250, 5.050000, 64.000252, 4.650000, 64.700249,
	8, 4.650000, 64.700249, 4.650000, 66.000252, 6.750000, 65.900253,
	8, 6.750000, 65.900253, 9.450000, 65.800247, 9.550000, 65.100250,
	8, 9.649999, 64.400253, 9.250000, 61.500252, 8.250000, 59.400250,
	0
};

/* path_data52 ===========================================*/
signed char path_data52[] = {
	2, 11.750000, 61.200249,
	8, 11.750000, 61.200249, 12.650000, 60.600250, 13.250000, 60.900250,
/* path_data53 ===========================================*/
	2, 13.375000, 57.100250,
	8, 13.375000, 57.100250, 14.100001, 55.875252, 15.300000, 55.675251,
	0
};

/* path_data54 ===========================================*/
signed char path_data54[] = {
	2, -6.450000, 66.300247,
	8, -6.450000, 66.300247, -1.950000, 67.100250, -0.850000, 66.700249,
	8, -0.850000, 66.700249, 1.350000, 66.700249, -0.750000, 67.200249,
	8, -0.750000, 67.200249, -3.950000, 67.200249, -5.950000, 66.900253,
	8, -5.950000, 66.900253, -8.850001, 65.500252, -6.450000, 66.300247,
	0
};

/* path_data55 ===========================================*/
signed char path_data55[] = {
	2, -2.950000, 43.000252,
	8, -2.950000, 43.000252, 1.450000, 43.000252, 1.950000, 43.200249,
	8, 1.950000, 43.200249, 3.750000, 50.900250, 2.850000, 52.800251,
	8, 2.850000, 52.800251, 2.550000, 53.500252, 1.850000, 52.100250,
	8, 1.850000, 52.100250, -2.750000, 43.900250, -3.550000, 43.400250,
	8, -4.350000, 42.900250, -3.250000, 43.000252, -2.950000, 43.000252,
	0
};

/* path_data56 ===========================================*/
signed char path_data56[] = {
	2, -22.225001, 42.325249,
	8, -22.225001, 42.325249, -20.000000, 42.750252, -16.850001, 43.400250,
	8, -16.850001, 43.400250, -15.650000, 49.000252, -14.850001, 50.200249,
	8, -14.050000, 51.400250, -14.950000, 51.400250, -15.850001, 50.700249,
	8, -16.750000, 50.000252, -20.450001, 46.500252, -20.950001, 45.400250,
	8, -21.450001, 44.300251, -22.225001, 42.325249, -22.225001, 42.325249,
	0
};

/* path_data57 ===========================================*/
signed char path_data57[] = {
	2, -16.759750, 43.454498,
	8, -16.759750, 43.454498, -15.309750, 43.841499, -15.057500, 44.395249,
	8, -14.805500, 44.948749, -15.358000, 45.772999, -15.358000, 45.772999,
	8, -15.358000, 45.772999, -15.608000, 46.599251, -15.908500, 46.058750,
	8, -16.209000, 45.518001, -16.927000, 43.603001, -16.759750, 43.454498,
	0
};

/* path_data58 ===========================================*/
signed char path_data58[] = {
	2, -16.750000, 43.400250,
	8, -16.750000, 43.400250, -15.850001, 44.700249, -14.950000, 44.700249,
	8, -14.050000, 44.700249, -13.954500, 44.597000, -13.250000, 44.750252,
	8, -12.100001, 45.000252, -12.200000, 44.500252, -10.550000, 44.800251,
	8, -9.890000, 44.920250, -9.250000, 44.700249, -8.550000, 45.000252,
	8, -7.850000, 45.300251, -7.050000, 45.100250, -6.750000, 44.600250,
	8, -6.450000, 44.100250, -5.250000, 43.050251, -5.250000, 43.050251,
	8, -5.250000, 43.050251, -8.450000, 43.500252, -9.149999, 43.700249,
	8, -9.149999, 43.700249, -14.750000, 44.000252, -16.750000, 43.400250,
	0
};

/* path_data59 ===========================================*/
signed char path_data59[] = {
	2, -5.600000, 43.450249,
	8, -5.600000, 43.450249, -7.212500, 44.325249, -7.312500, 44.925251,
	8, -7.412500, 45.525250, -6.000000, 46.450249, -6.000000, 46.450249,
	8, -6.000000, 46.450249, -5.312500, 47.600250, -5.162500, 47.000252,
	8, -5.012500, 46.400250, -5.400000, 43.550251, -5.600000, 43.450249,
	0
};

/* path_data60 ===========================================*/
signed char path_data60[] = {
	2, -14.971250, 44.816250,
	8, -14.971250, 44.816250, -13.219500, 47.613251, -13.165250, 44.810501,
	8, -13.165250, 44.810501, -13.026000, 44.495998, -13.466000, 44.490502,
	8, -14.984750, 44.471500, -14.604500, 43.445999, -14.971250, 44.816250,
	0
};

/* path_data61 ===========================================*/
signed char path_data61[] = {
	2, -13.176750, 44.878502,
	8, -13.176750, 44.878502, -11.196500, 47.675251, -11.355500, 44.855251,
	8, -11.355500, 44.855251, -11.353750, 44.772251, -11.792000, 44.734001,
	8, -12.978750, 44.630501, -12.892500, 43.500999, -13.176750, 44.878502,
	0
};

/* path_data62 ===========================================*/
signed char path_data62[] = {
	2, -11.373500, 44.880501,
	8, -11.373500, 44.880501, -9.383500, 47.537498, -9.550750, 45.120998,
	8, -9.550750, 45.120998, -9.521000, 44.812752, -9.934500, 44.737499,
	8, -10.907500, 44.561001, -10.960250, 43.748749, -11.373500, 44.880501,
	0
};

/* path_data63 ===========================================*/
signed char path_data63[] = {
	2, -9.654500, 44.900501,
	8, -9.654500, 44.900501, -7.679500, 47.790749, -7.592500, 45.345501,
	8, -7.592500, 45.345501, -7.181500, 45.000999, -7.618000, 44.945499,
	8, -9.072500, 44.760502, -8.873000, 43.646999, -9.654500, 44.900501,
	0
};

/* path_data64 ===========================================*/
signed char path_data64[] = {
	2, -18.698000, 45.783001,
	4, -20.612499, 45.400249,
	8, -21.262501, 44.150249, -21.787500, 42.612751, -21.787500, 42.612751,
	8, -21.787500, 42.612751, -20.200001, 42.862751, -17.075001, 43.562752,
	8, -17.075001, 43.562752, -16.856001, 44.392250, -16.488001, 45.841000,
	4, -18.698000, 45.783001,
	0
};

/* path_data65 ===========================================*/
signed char path_data65[] = {
	2, -2.431000, 44.617500,
	8, -2.847500, 43.991001, -3.176750, 43.551498, -3.339250, 43.450001,
	8, -4.092500, 42.979252, -3.056750, 43.073502, -2.774500, 43.073502,
	8, -2.774500, 43.073502, 1.368250, 43.073502, 1.839000, 43.261749,
	8, 1.839000, 43.261749, 1.970000, 43.822250, 2.141000, 44.669998,
	8, 2.141000, 44.669998, -0.381000, 44.167500, -2.431000, 44.617500,
	0
};

/* path_data66 ===========================================*/
signed char path_data66[] = {
	2, 10.970000, 10.080250,
	8, 17.900249, 11.070250, 24.280251, 2.160250, 24.720249, -0.260000,
	8, 25.160250, -2.680000, 22.630251, -5.650000, 22.630251, -5.650000,
	8, 22.960251, -6.420000, 21.750250, -9.940000, 20.430250, -12.250000,
	8, 19.110250, -14.560000, 15.135000, -14.316500, 10.750000, -14.560000,
	8, 6.790000, -14.780000, 2.170000, -8.950000, 1.840000, -8.510000,
	8, 1.510000, -8.070000, 3.050000, 1.500250, 3.380000, 2.930250,
	8, 3.710000, 4.360250, 3.050000, 10.960250, 3.050000, 10.960250,
	8, 11.610000, 8.685250, 4.040000, 9.090250, 10.970000, 10.080250,
	0
};

/* path_data67 ===========================================*/
signed char path_data67[] = {
	2, 2.022000, -8.348000,
	8, 1.698000, -7.916000, 3.210000, 1.480250, 3.534000, 2.884250,
	8, 3.858000, 4.288250, 3.210000, 10.768250, 3.210000, 10.768250,
	8, 11.378000, 8.548250, 4.182000, 8.932250, 10.986000, 9.904250,
	8, 17.790251, 10.876250, 24.054251, 2.128250, 24.486250, -0.248000,
	8, 24.918249, -2.624000, 22.434250, -5.540000, 22.434250, -5.540000,
	8, 22.758249, -6.296000, 21.570250, -9.752000, 20.274250, -12.020000,
	8, 18.978251, -14.288000, 15.075500, -14.048750, 10.770000, -14.288000,
	8, 6.882000, -14.504000, 2.346000, -8.780000, 2.022000, -8.348000,
	0
};

/* path_data68 ===========================================*/
signed char path_data68[] = {
	2, 2.204000, -8.186000,
	8, 1.886000, -7.762000, 3.370000, 1.460250, 3.688000, 2.838250,
	8, 4.006000, 4.216250, 3.370000, 10.576250, 3.370000, 10.576250,
	8, 11.221000, 8.286250, 4.324000, 8.774250, 11.002000, 9.728250,
	8, 17.680250, 10.682250, 23.828251, 2.096250, 24.252251, -0.236000,
	8, 24.676250, -2.568000, 22.238251, -5.430000, 22.238251, -5.430000,
	8, 22.556250, -6.172000, 21.390249, -9.564000, 20.118250, -11.790000,
	8, 18.846251, -14.016000, 15.015750, -13.781250, 10.790000, -14.016000,
	8, 6.974000, -14.228000, 2.522000, -8.610000, 2.204000, -8.186000,
	0
};

/* path_data69 ===========================================*/
signed char path_data69[] = {
	2, 2.386000, -8.024000,
	8, 2.074000, -7.608000, 3.530000, 1.440250, 3.842000, 2.792250,
	8, 4.154000, 4.144250, 3.530000, 10.384250, 3.530000, 10.384250,
	8, 10.889000, 8.124250, 4.466000, 8.616250, 11.018000, 9.552250,
	8, 17.570250, 10.488250, 23.602249, 2.064250, 24.018250, -0.223750,
	8, 24.434250, -2.512000, 22.042250, -5.320000, 22.042250, -5.320000,
	8, 22.354250, -6.048000, 21.210251, -9.376000, 19.962250, -11.560000,
	8, 18.714251, -13.744000, 14.956000, -13.513750, 10.810000, -13.744000,
	8, 7.066000, -13.952000, 2.698000, -8.440000, 2.386000, -8.024000,
	0
};

/* path_data70 ===========================================*/
signed char path_data70[] = {
	2, 2.568000, -7.862000,
	8, 2.262000, -7.454000, 3.690000, 1.420250, 3.996000, 2.746250,
	8, 4.302000, 4.072250, 3.690000, 10.192250, 3.690000, 10.192250,
	8, 10.657000, 7.962250, 4.608000, 8.458250, 11.034000, 9.376250,
	8, 17.460251, 10.294250, 23.376249, 2.032250, 23.784250, -0.212000,
	8, 24.192249, -2.456000, 21.846251, -5.210000, 21.846251, -5.210000,
	8, 22.152250, -5.924000, 21.030251, -9.188000, 19.806250, -11.330000,
	8, 18.582251, -13.472000, 14.896250, -13.246250, 10.830000, -13.472000,
	8, 7.158000, -13.676000, 2.874000, -8.270000, 2.568000, -7.862000,
	0
};

/* path_data71 ===========================================*/
signed char path_data71[] = {
	2, 11.050000, 9.200000,
	8, 17.350000, 10.100000, 23.150249, 2.000000, 23.550249, -0.200000,
	8, 23.950251, -2.400000, 21.650249, -5.100000, 21.650249, -5.100000,
	8, 21.950251, -5.800000, 20.850000, -9.000000, 19.650000, -11.100000,
	8, 18.450001, -13.200000, 14.836500, -12.978500, 10.850000, -13.200000,
	8, 7.250000, -13.400000, 3.050000, -8.100000, 2.750000, -7.700000,
	8, 2.450000, -7.300000, 3.850000, 1.400000, 4.150000, 2.700000,
	8, 4.450000, 4.000000, 3.850000, 10.000000, 3.850000, 10.000000,
	8, 10.225000, 7.850000, 4.750000, 8.300000, 11.050000, 9.200000,
	0
};

/* path_data72 ===========================================*/
signed char path_data72[] = {
	2, 22.650249, 0.700000,
	8, 22.650249, 0.700000, 15.700000, 2.600000, 12.800000, 2.200000,
	8, 12.800000, 2.200000, 8.850000, 0.550000, 6.650000, 6.000000,
	8, 6.650000, 6.000000, 5.750000, 7.800000, 5.250000, 8.300000,
	8, 4.750000, 8.800000, 22.650249, 0.700000, 22.650249, 0.700000,
	0
};

/* path_data73 ===========================================*/
signed char path_data73[] = {
	2, 23.600250, 0.150000,
	8, 23.600250, 0.150000, 16.350000, 3.200000, 13.850000, 3.100000,
	8, 13.850000, 3.100000, 9.750000, 1.950000, 7.650000, 5.600000,
	8, 7.650000, 5.600000, 5.550000, 7.900000, 4.750000, 8.300000,
	8, 4.750000, 8.300000, 4.650000, 8.700000, 6.250000, 7.700000,
	4, 8.850000, 9.000000,
	8, 8.850000, 9.000000, 12.550000, 11.400000, 14.950000, 7.400000,
	8, 14.950000, 7.400000, 15.950000, 4.600000, 15.950000, 4.100000,
	8, 15.950000, 3.600000, 21.250000, 2.200000, 21.650249, 2.100000,
	8, 22.050249, 2.000000, 23.700251, 0.950000, 23.600250, 0.150000,
	0
};

/* path_data74 ===========================================*/
signed char path_data74[] = {
	2, 11.750000, 9.128500,
	8, 10.032000, 9.128500, 7.938750, 8.162250, 7.938750, 6.600000,
	8, 7.938750, 5.038000, 10.032000, 3.471750, 11.750000, 3.471750,
	8, 13.468500, 3.471750, 14.861500, 4.738000, 14.861500, 6.300000,
	8, 14.861500, 7.862250, 13.468500, 9.128500, 11.750000, 9.128500,
	0
};

/* path_data75 ===========================================*/
signed char path_data75[] = {
	2, 10.844250, 4.957500,
	8, 9.632750, 5.138000, 8.360500, 5.513750, 8.378500, 5.459750,
	8, 8.763500, 4.305000, 10.353750, 3.471750, 11.750000, 3.471750,
	8, 12.824000, 3.471750, 13.771000, 3.966250, 14.330000, 4.718750,
	8, 14.330000, 4.718750, 13.001000, 4.636250, 10.844250, 4.957500,
	0
};

/* path_data76 ===========================================*/
signed char path_data76[] = {
	2, 13.850000, 4.900000,
	8, 13.850000, 4.900000, 12.750000, 4.100000, 12.750000, 4.650000,
	8, 12.750000, 4.650000, 13.650000, 5.750000, 13.850000, 4.900000,
	0
};

/* path_data77 ===========================================*/
signed char path_data77[] = {
	2, 11.350000, 6.931500,
	8, 10.725250, 6.931500, 10.218750, 6.425000, 10.218750, 5.800000,
	8, 10.218750, 5.175250, 10.725250, 4.668750, 11.350000, 4.668750,
	8, 11.975000, 4.668750, 12.481500, 5.175250, 12.481500, 5.800000,
	8, 12.481500, 6.425000, 11.975000, 6.931500, 11.350000, 6.931500,
	0
};

/* path_data78 ===========================================*/
signed char path_data78[] = {
	2, -14.650000, 3.600000,
	8, -14.650000, 3.600000, -15.450000, -1.700000, -14.850000, -2.800000,
	8, -14.850000, -2.800000, -12.150000, -5.300000, -12.250000, -6.200000,
	8, -12.250000, -6.200000, -12.350000, -10.700000, -12.650000, -10.900000,
	8, -12.950000, -11.100000, -14.850000, -12.600000, -16.350000, -11.000000,
	8, -16.350000, -11.000000, -18.950001, -6.500000, -18.750000, -4.900000,
	4, -18.750000, -4.400000,
	8, -18.750000, -4.400000, -20.650000, -4.500000, -21.049999, -4.000000,
	8, -21.049999, -4.000000, -21.350000, -2.700000, -21.650000, -2.600000,
	8, -21.650000, -2.600000, -22.350000, -2.000000, -21.850000, -1.300000,
	8, -21.850000, -1.300000, -22.350000, -0.700000, -22.250000, 0.300000,
	4, -20.350000, 1.300000,
	8, -20.350000, 1.300000, -19.850000, 4.900000, -17.150000, 6.200000,
	8, -15.941000, 6.782250, -15.150000, 5.100000, -14.650000, 3.600000,
	0
};

/* path_data79 ===========================================*/
signed char path_data79[] = {
	2, -14.900000, 3.140000,
	8, -14.900000, 3.140000, -15.620000, -1.630000, -15.080000, -2.620000,
	8, -15.080000, -2.620000, -12.650000, -4.870000, -12.740000, -5.680000,
	8, -12.740000, -5.680000, -12.830000, -9.730000, -13.100000, -9.910000,
	8, -13.370000, -10.090000, -15.080000, -11.440000, -16.430000, -10.000000,
	8, -16.430000, -10.000000, -18.770000, -5.950000, -18.590000, -4.510000,
	4, -18.590000, -4.060000,
	8, -18.590000, -4.060000, -20.299999, -4.150000, -20.660000, -3.700000,
	8, -20.660000, -3.700000, -20.930000, -2.530000, -21.200001, -2.440000,
	8, -21.200001, -2.440000, -21.830000, -1.900000, -21.379999, -1.270000,
	8, -21.379999, -1.270000, -21.830000, -0.730000, -21.740000, 0.170000,
	4, -20.030001, 1.070000,
	8, -20.030001, 1.070000, -19.580000, 4.310000, -17.150000, 5.480000,
	8, -16.062000, 6.003750, -15.350000, 4.490000, -14.900000, 3.140000,
	0
};

/* path_data80 ===========================================*/
signed char path_data80[] = {
	2, -12.762500, -10.652500,
	8, -13.035000, -10.867500, -14.907500, -12.310000, -16.370001, -10.750000,
	8, -16.370001, -10.750000, -18.905001, -6.362500, -18.709999, -4.802500,
	4, -18.709999, -4.315000,
	8, -18.709999, -4.315000, -20.562500, -4.412500, -20.952499, -3.925000,
	8, -20.952499, -3.925000, -21.245001, -2.657500, -21.537500, -2.560000,
	8, -21.537500, -2.560000, -22.219999, -1.975000, -21.732500, -1.292500,
	8, -21.732500, -1.292500, -22.219999, -0.707500, -22.122499, 0.267500,
	4, -20.270000, 1.242500,
	8, -20.270000, 1.242500, -19.782499, 4.752500, -17.150000, 6.020000,
	8, -15.971500, 6.587500, -15.200000, 4.947500, -14.712500, 3.485000,
	8, -14.712500, 3.485000, -15.492500, -1.682500, -14.907500, -2.755000,
	8, -14.907500, -2.755000, -12.275000, -5.192500, -12.372500, -6.070000,
	8, -12.372500, -6.070000, -12.470000, -10.457500, -12.762500, -10.652500,
	0
};

/* path_data81 ===========================================*/
signed char path_data81[] = {
	2, -12.875000, -10.405000,
	8, -13.120000, -10.635000, -14.965000, -12.020000, -16.389999, -10.500000,
	8, -16.389999, -10.500000, -18.860001, -6.225000, -18.670000, -4.705000,
	4, -18.670000, -4.230000,
	8, -18.670000, -4.230000, -20.475000, -4.325000, -20.855000, -3.850000,
	8, -20.855000, -3.850000, -21.139999, -2.615000, -21.424999, -2.520000,
	8, -21.424999, -2.520000, -22.090000, -1.950000, -21.615000, -1.285000,
	8, -21.615000, -1.285000, -22.090000, -0.715000, -21.995001, 0.235000,
	4, -20.190001, 1.185000,
	8, -20.190001, 1.185000, -19.715000, 4.605000, -17.150000, 5.840000,
	8, -16.001499, 6.393000, -15.250000, 4.795000, -14.775000, 3.370000,
	8, -14.775000, 3.370000, -15.535000, -1.665000, -14.965000, -2.710000,
	8, -14.965000, -2.710000, -12.400000, -5.085000, -12.495000, -5.940000,
	8, -12.495000, -5.940000, -12.590000, -10.215000, -12.875000, -10.405000,
	0
};

/* path_data82 ===========================================*/
signed char path_data82[] = {
	2, -12.987500, -10.157500,
	8, -13.205000, -10.402500, -15.022500, -11.730000, -16.410000, -10.250000,
	8, -16.410000, -10.250000, -18.815001, -6.087500, -18.629999, -4.607500,
	4, -18.629999, -4.145000,
	8, -18.629999, -4.145000, -20.387501, -4.237500, -20.757500, -3.775000,
	8, -20.757500, -3.775000, -21.035000, -2.572500, -21.312500, -2.480000,
	8, -21.312500, -2.480000, -21.959999, -1.925000, -21.497499, -1.277500,
	8, -21.497499, -1.277500, -21.959999, -0.722500, -21.867500, 0.202500,
	4, -20.110001, 1.127500,
	8, -20.110001, 1.127500, -19.647499, 4.457500, -17.150000, 5.660000,
	8, -16.031750, 6.198500, -15.300000, 4.642500, -14.837500, 3.255000,
	8, -14.837500, 3.255000, -15.577500, -1.647500, -15.022500, -2.665000,
	8, -15.022500, -2.665000, -12.525000, -4.977500, -12.617500, -5.810000,
	8, -12.617500, -5.810000, -12.710000, -9.972500, -12.987500, -10.157500,
	0
};

/* path_data83 ===========================================*/
signed char path_data83[] = {
	2, -14.900000, 3.115000,
	8, -14.900000, 3.115000, -15.620000, -1.630000, -15.080000, -2.620000,
	8, -15.080000, -2.620000, -12.650000, -4.870000, -12.740000, -5.680000,
	8, -12.740000, -5.680000, -12.830000, -9.730000, -13.100000, -9.910000,
	8, -13.290000, -10.170000, -15.080000, -11.440000, -16.430000, -10.000000,
	8, -16.430000, -10.000000, -18.770000, -5.950000, -18.590000, -4.510000,
	4, -18.590000, -4.060000,
	8, -18.590000, -4.060000, -20.299999, -4.150000, -20.660000, -3.700000,
	8, -20.660000, -3.700000, -20.930000, -2.530000, -21.200001, -2.440000,
	8, -21.200001, -2.440000, -21.830000, -1.900000, -21.379999, -1.270000,
	8, -21.379999, -1.270000, -21.830000, -0.730000, -21.740000, 0.170000,
	4, -20.030001, 1.070000,
	8, -20.030001, 1.070000, -19.580000, 4.310000, -17.150000, 5.480000,
	8, -16.062000, 6.003750, -15.350000, 4.465000, -14.900000, 3.115000,
	0
};

/* path_data84 ===========================================*/
signed char path_data84[] = {
	2, -15.675000, 1.550000,
	8, -15.675000, 1.550000, -21.075001, -1.000000, -21.299999, -1.200000,
	8, -21.299999, -1.200000, -19.025000, 0.850000, -18.825001, 0.850000,
	8, -18.625000, 0.850000, -15.675000, 1.550000, -15.675000, 1.550000,
	0
};

/* path_data85 ===========================================*/
signed char path_data85[] = {
	2, -19.950001, 0.000000,
	8, -19.950001, 0.000000, -15.350000, 0.900000, -15.350000, 2.000000,
	8, -15.350000, 2.728000, -15.410750, 6.082750, -16.750000, 5.700000,
	8, -18.850000, 5.100000, -17.950001, 1.500000, -19.950001, 0.000000,
	0
};

/* path_data86 ===========================================*/
signed char path_data86[] = {
	2, -17.850000, 0.950000,
	8, -17.850000, 0.950000, -15.605500, 1.318500, -15.350000, 2.000000,
	8, -15.200000, 2.400000, -15.034250, 4.477000, -16.400000, 4.750000,
	8, -17.538000, 4.977750, -18.095501, 2.422500, -17.850000, 0.950000,
	0
};

/* path_data87 ===========================================*/
signed char path_data87[] = {
	2, 3.648750, 11.587250,
	8, 3.524500, 11.151750, 3.852250, 11.184500, 4.300000, 11.050000,
	8, 4.800000, 10.900000, 7.850000, 9.950000, 8.050000, 9.300000,
	8, 8.250000, 8.650000, 11.550000, 9.750000, 11.550000, 9.750000,
	8, 12.000000, 9.950000, 13.100000, 10.600000, 13.100000, 10.600000,
	8, 14.300000, 10.900000, 15.950000, 11.000000, 15.950000, 11.000000,
	8, 16.549999, 11.250000, 17.400000, 11.950000, 17.400000, 11.950000,
	8, 21.049999, 14.500000, 24.150249, 12.700000, 24.150249, 12.700000,
	8, 29.150249, 11.050000, 27.650249, 6.750000, 27.650249, 6.750000,
	8, 26.900249, 4.500000, 27.700251, 3.650000, 27.700251, 3.650000,
	8, 27.750250, 2.700000, 29.550249, 4.300000, 29.550249, 4.300000,
	8, 30.200251, 5.350000, 30.400249, 6.600000, 30.400249, 6.600000,
	8, 32.400249, 9.400000, 31.550249, 4.950000, 31.550249, 4.950000,
	8, 31.600250, 4.700000, 30.900249, 3.800000, 30.900249, 3.500000,
	8, 30.900249, 3.200000, 30.450251, 2.350000, 30.450251, 2.350000,
	8, 29.700251, 1.500000, 30.300249, -0.250000, 30.300249, -0.250000,
	8, 30.750250, -3.700000, 30.200251, -3.250000, 30.200251, -3.250000,
	8, 29.900249, -3.700000, 27.600250, -1.200000, 27.600250, -1.200000,
	8, 27.050249, -0.350000, 25.550249, 0.050000, 25.550249, 0.050000,
	8, 24.850250, 0.500000, 24.000250, 0.150000, 24.000250, 0.150000,
	8, 23.350250, 0.050000, 21.950251, 1.800000, 21.950251, 1.800000,
	8, 22.650249, 1.750000, 23.250250, 2.850000, 23.850250, 2.900000,
	8, 24.450251, 2.950000, 24.900249, 2.300000, 25.300249, 2.150000,
	8, 25.700251, 2.000000, 26.400249, 3.450000, 26.400249, 3.450000,
	8, 26.500250, 4.100000, 25.100250, 5.300000, 25.100250, 5.300000,
	8, 25.000250, 6.450000, 24.600250, 6.050000, 24.600250, 6.050000,
	8, 23.850250, 5.900000, 23.550249, 6.850000, 23.300249, 8.000000,
	8, 23.050249, 9.150000, 22.000250, 9.250000, 22.000250, 9.250000,
	8, 21.600250, 11.100000, 21.299999, 10.350000, 21.299999, 10.350000,
	8, 21.250000, 8.950000, 19.750000, 10.400000, 19.750000, 10.400000,
	8, 19.450001, 10.900000, 18.299999, 10.350000, 18.299999, 10.350000,
	8, 16.600000, 9.850000, 17.200001, 9.350000, 17.200001, 9.350000,
	8, 17.650000, 8.800000, 20.450001, 9.350000, 20.450001, 9.350000,
	8, 21.000000, 8.950000, 19.000000, 7.950000, 19.000000, 7.950000,
	8, 18.850000, 7.500000, 19.100000, 6.400000, 19.100000, 6.400000,
	8, 19.400000, 5.600000, 21.100000, 4.200000, 21.100000, 4.200000,
	8, 23.450251, 3.900000, 22.750250, 3.500000, 22.750250, 3.500000,
	8, 21.200251, 2.200000, 19.750000, 4.100000, 19.750000, 4.100000,
	8, 19.200001, 5.650000, 14.850000, 9.400000, 14.850000, 9.400000,
	8, 13.650000, 10.250000, 14.300000, 8.550000, 13.300000, 9.400000,
	8, 12.300000, 10.250000, 7.150000, 8.000000, 7.150000, 8.000000,
	8, 4.259500, 7.701750, 3.576500, 11.637250, 2.694250, 10.857250,
	8, 2.694250, 10.857250, 4.048750, 12.987250, 3.648750, 11.587250,
/* path_data88 ===========================================*/
	2, 52.350250, -30.000000,
	8, 52.350250, -30.000000, 45.950249, -28.000000, 45.250252, -23.299999,
	8, 45.250252, -23.299999, 44.650249, -17.600000, 49.750252, -13.200000,
	8, 49.750252, -13.200000, 49.850250, -11.600000, 50.350250, -10.800000,
	8, 50.350250, -10.800000, 49.950249, -9.600000, 54.650249, -11.500000,
	4, 61.450249, -13.600000,
	8, 61.450249, -13.600000, 63.050251, -14.200000, 64.350250, -16.400000,
	8, 65.650253, -18.600000, 69.450249, -23.299999, 68.550247, -29.600000,
	8, 68.550247, -29.600000, 68.850250, -32.400002, 67.350250, -32.500000,
	8, 67.350250, -32.500000, 65.250252, -32.900002, 63.450249, -31.000000,
	8, 63.450249, -31.000000, 61.750252, -30.200001, 61.150249, -30.299999,
	4, 52.350250, -30.000000,
	0
};

/* path_data89 ===========================================*/
signed char path_data89[] = {
	2, 66.005501, -30.247499,
	8, 66.005501, -30.247499, 66.530502, -32.480000, 65.320503, -31.270000,
	8, 65.320503, -31.270000, 63.560501, -29.840000, 61.690250, -29.840000,
	8, 61.690250, -29.840000, 58.060249, -29.290001, 56.960251, -25.990000,
	8, 56.960251, -25.990000, 55.970249, -19.280001, 57.950249, -17.850000,
	8, 57.950249, -17.850000, 59.160252, -15.980000, 60.920250, -17.629999,
	8, 62.680500, -19.280001, 66.555496, -26.837500, 66.005501, -30.247499,
	0
};

/* path_data90 ===========================================*/
signed char path_data90[] = {
	2, 65.912003, -30.158001,
	8, 65.912003, -30.158001, 66.434502, -32.344002, 65.246498, -31.156000,
	8, 65.246498, -31.156000, 63.518501, -29.752001, 61.682251, -29.752001,
	8, 61.682251, -29.752001, 58.118252, -29.212000, 57.038250, -25.972000,
	8, 57.038250, -25.972000, 56.066250, -19.384001, 58.010250, -17.980000,
	8, 58.010250, -17.980000, 59.198250, -16.143999, 60.926250, -17.764000,
	8, 62.654499, -19.384001, 66.452003, -26.809999, 65.912003, -30.158001,
	0
};

/* path_data91 ===========================================*/
signed char path_data91[] = {
	2, 65.818497, -30.068501,
	8, 65.818497, -30.068501, 66.338501, -32.208000, 65.172501, -31.042000,
	8, 65.172501, -31.042000, 63.476501, -29.664000, 61.674252, -29.664000,
	8, 61.674252, -29.664000, 58.176250, -29.134001, 57.116249, -25.954000,
	8, 57.116249, -25.954000, 56.162251, -19.488001, 58.070251, -18.110001,
	8, 58.070251, -18.110001, 59.236252, -16.308001, 60.932251, -17.898001,
	8, 62.628502, -19.488001, 66.348503, -26.782499, 65.818497, -30.068501,
	0
};

/* path_data92 ===========================================*/
signed char path_data92[] = {
	2, 65.724998, -29.979000,
	8, 65.724998, -29.979000, 66.242500, -32.071999, 65.098503, -30.927999,
	8, 65.098503, -30.927999, 63.434502, -29.576000, 61.666248, -29.576000,
	8, 61.666248, -29.576000, 58.234249, -29.056000, 57.194248, -25.936001,
	8, 57.194248, -25.936001, 56.258251, -19.591999, 58.130249, -18.240000,
	8, 58.130249, -18.240000, 59.274250, -16.472000, 60.938251, -18.032000,
	8, 62.602501, -19.591999, 66.245003, -26.754999, 65.724998, -29.979000,
	0
};

/* path_data93 ===========================================*/
signed char path_data93[] = {
	2, 65.631500, -29.889500,
	8, 65.631500, -29.889500, 66.146500, -31.936001, 65.024498, -30.813999,
	8, 65.024498, -30.813999, 63.392250, -29.488001, 61.658249, -29.488001,
	8, 61.658249, -29.488001, 58.292252, -28.978001, 57.272251, -25.917999,
	8, 57.272251, -25.917999, 56.354252, -19.695999, 58.190250, -18.370001,
	8, 58.190250, -18.370001, 59.312248, -16.636000, 60.944248, -18.166000,
	8, 62.576248, -19.695999, 66.141502, -26.727501, 65.631500, -29.889500,
	0
};

/* path_data94 ===========================================*/
signed char path_data94[] = {
	2, 65.537750, -29.799999,
	8, 65.537750, -29.799999, 66.050247, -31.799999, 64.950249, -30.700001,
	8, 64.950249, -30.700001, 63.350250, -29.400000, 61.650249, -29.400000,
	8, 61.650249, -29.400000, 58.350250, -28.900000, 57.350250, -25.900000,
	8, 57.350250, -25.900000, 56.450249, -19.799999, 58.250252, -18.500000,
	8, 58.250252, -18.500000, 59.350250, -16.799999, 60.950249, -18.299999,
	8, 62.550251, -19.799999, 66.037750, -26.700001, 65.537750, -29.799999,
	0
};

/* path_data95 ===========================================*/
signed char path_data95[] = {
	2, 12.650000, 21.000000,
	8, 12.650000, 21.000000, 7.550000, 16.200001, 5.550000, 16.000000,
	8, 5.550000, 16.000000, -3.050000, 15.000000, -6.750000, 19.500000,
	8, -6.750000, 19.500000, -2.350000, 14.400000, 4.550000, 15.800000,
	8, 4.550000, 15.800000, -0.850000, 14.700000, -3.950000, 15.500000,
	8, -3.950000, 15.500000, -8.150000, 15.500000, -10.550000, 19.000000,
	4, -11.250000, 20.200001,
	8, -11.250000, 20.200001, -10.250000, 16.500000, -5.650000, 15.000000,
	8, -5.650000, 15.000000, 0.050000, 13.800000, 2.750000, 15.000000,
	8, 2.750000, 15.000000, -2.650000, 13.300000, -5.150000, 13.800000,
	8, -5.150000, 13.800000, -12.750000, 13.200000, -15.950000, 19.799999,
	8, -15.950000, 19.799999, -14.950000, 16.200001, -11.250000, 14.400000,
	8, -11.250000, 14.400000, -7.850000, 12.200000, -2.750000, 12.900000,
	8, -2.750000, 12.900000, 0.850000, 13.700000, 2.150000, 14.300000,
	8, 3.450000, 14.900000, 3.150000, 14.200000, 1.050000, 13.000000,
	8, 1.050000, 13.000000, -0.350000, 10.500000, -3.850000, 10.600000,
	8, -3.850000, 10.600000, -14.550000, 11.500000, -17.150000, 14.500000,
	8, -17.150000, 14.500000, -13.750000, 11.700000, -11.150000, 11.000000,
	8, -11.150000, 11.000000, -5.550000, 9.000000, -3.450000, 9.200000,
	8, -3.450000, 9.200000, 2.750000, 9.450000, 4.650000, 8.450000,
	8, 4.650000, 8.450000, 1.850000, 9.700000, 2.650000, 10.500000,
	8, 3.450000, 11.300000, 5.150000, 13.200000, 5.150000, 13.500000,
	8, 5.150000, 13.800000, 11.200000, 19.325001, 12.100000, 20.424999,
	4, 12.650000, 21.000000,
	0
};

/* path_data96 ===========================================*/
signed char path_data96[] = {
	2, 47.250000, 69.500000,
	8, 47.250000, 69.500000, 43.375000, 60.375000, 40.250000, 58.000000,
	8, 40.250000, 58.000000, 46.750000, 62.000000, 47.625000, 66.500000,
	8, 47.625000, 66.500000, 47.625000, 69.000000, 47.250000, 69.500000,
/* path_data97 ===========================================*/
	2, 59.000000, 71.375000,
	8, 59.000000, 71.375000, 52.375000, 57.625000, 47.750000, 51.625000,
	8, 47.750000, 51.625000, 58.625000, 61.000000, 59.875000, 67.625000,
	4, 60.000000, 69.000000,
	4, 59.250000, 68.375000,
	8, 59.250000, 68.375000, 59.125000, 70.625000, 59.000000, 71.375000,
/* path_data98 ===========================================*/
	2, 73.125000, 59.250000,
	8, 73.125000, 59.250000, 57.500000, 44.375000, 57.125000, 43.750000,
	8, 57.125000, 43.750000, 72.250000, 60.250000, 73.000000, 62.125000,
	8, 73.000000, 62.125000, 72.500000, 59.875000, 73.125000, 59.250000,
/* path_data99 ===========================================*/
	2, 26.000000, 70.125000,
	8, 26.000000, 70.125000, 30.875000, 57.125000, 35.625000, 62.750000,
	8, 35.625000, 62.750000, 39.375000, 65.250000, 39.250000, 66.000000,
	8, 39.250000, 66.000000, 38.250000, 64.375000, 33.750000, 64.500000,
	8, 33.750000, 64.500000, 29.000000, 63.750000, 26.000000, 70.125000,
/* path_data100 ===========================================*/
	2, 73.625000, 38.250000,
	8, 73.625000, 38.250000, 62.375000, 31.125000, 60.500000, 30.750000,
	8, 57.548248, 30.159750, 72.875000, 38.000000, 74.125000, 40.625000,
	8, 74.125000, 40.625000, 74.625000, 40.000000, 73.625000, 38.250000,
	0
};

/* path_data101 ===========================================*/
signed char path_data101[] = {
	2, 35.950249, 64.900253,
	8, 35.950249, 64.900253, 41.050251, 64.400253, 42.750252, 62.700249,
	4, 43.850250, 63.600250,
	4, 48.250252, 54.000252,
	4, 49.150249, 55.300251,
	8, 49.150249, 55.300251, 52.750252, 51.600250, 52.550251, 49.600250,
	8, 52.350250, 47.600250, 55.750252, 51.100250, 55.750252, 51.100250,
	8, 55.750252, 51.100250, 55.550251, 48.200249, 57.350250, 49.900249,
	8, 57.350250, 49.900249, 56.750252, 46.000252, 58.850250, 48.000252,
	8, 58.850250, 48.000252, 56.216000, 40.460999, 61.850250, 46.900249,
	8, 63.250252, 48.500252, 62.150249, 46.800251, 62.150249, 46.800251,
	8, 62.150249, 46.800251, 55.650249, 34.800251, 61.050251, 38.400249,
	8, 61.050251, 38.400249, 61.550251, 32.700249, 61.250252, 31.600250,
	8, 60.950249, 30.500250, 60.450249, 24.900000, 59.250252, 23.600000,
	8, 58.050251, 22.299999, 59.350250, 21.900000, 60.750252, 23.200001,
	8, 60.750252, 23.200001, 57.950249, 17.200001, 61.250252, 20.200001,
	8, 61.250252, 20.200001, 60.350250, 16.400000, 59.250252, 15.700000,
	8, 59.250252, 15.700000, 57.850250, 11.400000, 61.650249, 14.100000,
	8, 61.650249, 14.100000, 60.550251, 11.000000, 59.750252, 10.200000,
	8, 59.750252, 10.200000, 56.850250, 3.300000, 58.650249, 4.500000,
	4, 59.750252, 5.400000,
	8, 59.750252, 5.400000, 58.050251, 1.900000, 59.650249, 3.000000,
	8, 61.250252, 4.100000, 61.250252, 4.000000, 61.250252, 4.000000,
	8, 61.250252, 4.000000, 55.950249, -4.300000, 61.050251, 0.100000,
	8, 61.050251, 0.100000, 59.010502, -3.379500, 58.150249, -5.100000,
	8, 58.150249, -5.100000, 53.450249, -10.200000, 57.050251, -8.600000,
	4, 58.250252, -8.200000,
	8, 58.250252, -8.200000, 56.050251, -10.700000, 54.050251, -11.100000,
	8, 52.050251, -11.500000, 54.650249, -13.100000, 56.250252, -12.600000,
	8, 57.850250, -12.100000, 61.750252, -10.200000, 61.750252, -10.200000,
	8, 61.750252, -10.200000, 64.950249, -5.500000, 65.950249, -5.400000,
	8, 65.950249, -5.400000, 60.950249, -7.300000, 62.450249, -5.300000,
	8, 62.450249, -5.300000, 66.050247, -1.800000, 64.250252, -1.900000,
	8, 64.250252, -1.900000, 62.750252, -0.100000, 63.950249, 2.100000,
	8, 63.950249, 2.100000, 59.335499, -2.497750, 63.050251, 3.900000,
	4, 64.750252, 8.000000,
	8, 64.750252, 8.000000, 58.650249, 1.800000, 61.450249, 7.300000,
	8, 61.450249, 7.300000, 65.750252, 13.200000, 66.250252, 13.300000,
	8, 66.750252, 13.400000, 67.850250, 15.600000, 67.850250, 15.600000,
	4, 66.750252, 15.100000,
	4, 68.050247, 17.299999,
	8, 68.050247, 17.299999, 65.250252, 14.300000, 66.750252, 17.600000,
	4, 68.150253, 21.200001,
	8, 68.150253, 21.200001, 63.050251, 15.700000, 66.450249, 23.100000,
	8, 66.450249, 23.100000, 62.350250, 21.799999, 64.550247, 26.100000,
	8, 64.550247, 26.100000, 64.150253, 30.100250, 64.250252, 31.400249,
	8, 64.350250, 32.700249, 64.650253, 39.800251, 63.550251, 41.800251,
	8, 62.450249, 43.800251, 65.050247, 48.600250, 65.550247, 49.600250,
	8, 66.050247, 50.600250, 66.950249, 53.300251, 64.750252, 51.000252,
	8, 62.550251, 48.700249, 63.650249, 50.100250, 64.150253, 52.300251,
	8, 64.650253, 54.500252, 66.150253, 58.400249, 65.950249, 59.800251,
	8, 65.950249, 59.800251, 65.650253, 60.100250, 64.850250, 59.200249,
	8, 64.850250, 59.200249, 61.150249, 53.500252, 61.550251, 57.100250,
	8, 61.550251, 57.100250, 61.250252, 59.100250, 60.450249, 61.300251,
	8, 60.450249, 61.300251, 59.650249, 64.000252, 59.650249, 61.800251,
	8, 59.650249, 61.800251, 58.850250, 57.600250, 58.150249, 59.500252,
	8, 57.450249, 61.400249, 56.550251, 62.900249, 55.850250, 63.500252,
	8, 55.150249, 64.100250, 53.850250, 58.400249, 53.550251, 61.000252,
	8, 53.550251, 61.000252, 50.550251, 57.900249, 49.350250, 62.000252,
	4, 46.450249, 66.100250,
	8, 46.450249, 66.100250, 46.350250, 63.000252, 46.050251, 64.500252,
	8, 46.050251, 64.500252, 38.550251, 66.000252, 35.950249, 64.900253,
/* path_data102 ===========================================*/
	2, 27.350250, -24.299999,
	8, 27.350250, -24.299999, 24.450251, -26.299999, 23.450251, -26.200001,
	8, 22.450251, -26.100000, 30.350250, -28.400000, 40.650249, -21.500000,
	8, 40.650249, -21.500000, 41.850250, -20.799999, 42.750252, -20.900000,
	8, 42.750252, -20.900000, 43.550251, -20.299999, 42.850250, -19.400000,
	8, 42.850250, -19.400000, 40.650249, -17.000000, 43.450249, -14.200000,
	8, 43.450249, -14.200000, 48.050251, -12.500000, 46.650249, -14.700000,
	8, 46.650249, -14.700000, 49.350250, -13.700000, 49.950249, -12.700000,
	8, 50.550251, -11.700000, 50.250252, -12.700000, 50.250252, -12.700000,
	8, 50.250252, -12.700000, 48.650249, -14.500000, 47.150249, -15.800000,
	8, 47.150249, -15.800000, 45.850250, -16.299999, 45.150249, -18.400000,
	8, 44.450249, -20.500000, 43.850250, -23.000000, 44.950249, -23.799999,
	8, 44.950249, -23.799999, 43.950249, -22.700001, 44.150249, -23.700001,
	8, 44.350250, -24.700001, 45.250252, -25.600000, 45.650249, -25.700001,
	8, 46.050251, -25.799999, 50.150249, -29.750000, 51.850250, -29.850000,
	8, 51.850250, -29.850000, 49.550251, -29.500000, 48.800251, -29.750000,
	8, 48.050251, -30.000000, 41.400249, -32.849998, 39.900249, -33.150002,
	8, 39.900249, -33.150002, 35.700249, -34.799999, 38.700249, -34.299999,
	8, 38.700249, -34.299999, 47.650249, -33.349998, 52.200249, -30.049999,
	8, 52.200249, -30.049999, 50.400249, -32.150002, 45.800251, -33.900002,
	8, 45.800251, -33.900002, 40.250252, -37.049999, 31.450251, -35.799999,
	8, 31.450251, -35.799999, 27.000250, -35.000000, 25.050249, -34.549999,
	8, 25.050249, -34.549999, 24.400249, -34.700001, 24.250250, -34.799999,
	8, 24.100250, -34.900002, 21.150000, -37.150002, 14.250000, -35.400002,
	8, 14.250000, -35.400002, 10.000000, -34.250000, 7.850000, -33.049999,
	8, 7.850000, -33.049999, 4.050000, -32.750000, 3.150000, -31.950001,
	8, 3.150000, -31.950001, -1.500000, -28.299999, -2.000000, -28.100000,
	8, -2.500000, -27.900000, -5.350000, -26.000000, -5.550000, -25.900000,
	8, -5.550000, -25.900000, 0.600000, -27.549999, 1.200000, -28.150000,
	8, 1.800000, -28.750000, 6.150000, -29.400000, 6.750000, -29.049999,
	8, 7.350000, -28.700001, 9.450000, -28.850000, 7.050000, -28.700001,
	8, 7.050000, -28.700001, 25.950251, -25.000000, 26.150249, -24.500000,
	8, 26.350250, -24.000000, 27.350250, -24.299999, 27.350250, -24.299999,
	0
};

/* path_data103 ===========================================*/
signed char path_data103[] = {
	2, 45.200249, -26.600000,
	8, 45.200249, -26.600000, 42.650249, -28.450001, 42.150249, -28.450001,
	8, 41.650249, -28.450001, 38.550251, -31.000000, 37.500252, -30.900000,
	8, 36.450249, -30.799999, 33.400249, -33.299999, 26.550249, -31.250000,
	8, 26.550249, -31.250000, 26.400249, -31.750000, 27.300249, -31.950001,
	8, 27.300249, -31.950001, 28.900249, -32.500000, 29.000250, -32.650002,
	8, 29.000250, -32.650002, 34.050251, -33.700001, 35.850250, -32.799999,
	8, 35.850250, -32.799999, 38.150249, -32.150002, 39.700249, -30.600000,
	8, 39.700249, -30.600000, 42.500252, -29.799999, 43.300251, -30.049999,
	8, 43.300251, -30.049999, 45.500252, -29.500000, 45.600250, -29.049999,
	8, 45.600250, -29.049999, 47.050251, -28.299999, 46.600250, -27.650000,
	8, 46.600250, -27.650000, 46.700249, -27.250000, 45.200249, -26.600000,
/* path_data104 ===========================================*/
	2, 42.082500, -27.127251,
	8, 42.284248, -26.969250, 42.539001, -26.944750, 42.690250, -26.742500,
	8, 42.748749, -26.664000, 42.676498, -26.582500, 42.597752, -26.558250,
	8, 42.337002, -26.479000, 42.073002, -26.621500, 41.787498, -26.474501,
	8, 41.687000, -26.422750, 41.526501, -26.468250, 41.388248, -26.505501,
	8, 40.980251, -26.615749, 40.522999, -26.622000, 40.100250, -26.450001,
	8, 39.604000, -26.732250, 39.014000, -26.586250, 38.493752, -26.836500,
	8, 38.479252, -26.843250, 38.423752, -26.756750, 38.405251, -26.763500,
	8, 37.643749, -27.049749, 36.708000, -26.979000, 36.100250, -27.549999,
	8, 35.493252, -27.653000, 34.903999, -27.768499, 34.297001, -27.938499,
	8, 33.842499, -28.065750, 33.490250, -28.313000, 33.085251, -28.521000,
	8, 32.741001, -28.698000, 32.376751, -28.828501, 31.993250, -28.921499,
	8, 31.527500, -29.034500, 31.069750, -29.006500, 30.596500, -29.136499,
	8, 30.573250, -29.142750, 30.525249, -29.056749, 30.504749, -29.063499,
	8, 30.423750, -29.090500, 30.351250, -29.236250, 30.308500, -29.223000,
	8, 29.888250, -29.092501, 29.516251, -29.335501, 29.100250, -29.250000,
	8, 28.805750, -29.556000, 28.373751, -29.494749, 27.987249, -29.605249,
	8, 27.246250, -29.817249, 26.457750, -29.499750, 25.700251, -29.750000,
	8, 26.728500, -30.210501, 27.900249, -29.902500, 28.915751, -30.419750,
	8, 29.497749, -30.716249, 30.163250, -30.440750, 30.805750, -30.630751,
	8, 30.927500, -30.666750, 31.100250, -30.717251, 31.200251, -30.549999,
	8, 31.233749, -30.583750, 31.279249, -30.643499, 31.293751, -30.636499,
	8, 31.906250, -30.347250, 32.485001, -30.028749, 33.105499, -29.762251,
	8, 33.190750, -29.725750, 33.323750, -29.783751, 33.386749, -29.733250,
	8, 33.766750, -29.429251, 34.252499, -29.455000, 34.600250, -29.150000,
	8, 35.024750, -29.275499, 35.473000, -29.180500, 35.905251, -29.336500,
	8, 35.924500, -29.343250, 35.983002, -29.257999, 35.991249, -29.263500,
	8, 36.273750, -29.450500, 36.562500, -29.382750, 36.785500, -29.306749,
	8, 36.869999, -29.278000, 37.035751, -29.216249, 37.112000, -29.197750,
	8, 37.393501, -29.128750, 37.607498, -29.008751, 37.902248, -28.962999,
	8, 37.930752, -28.958500, 37.977001, -29.043501, 37.994999, -29.036501,
	8, 38.275749, -28.927000, 38.536251, -28.941000, 38.700249, -28.650000,
	8, 38.734001, -28.683750, 38.775249, -28.743250, 38.795750, -28.736500,
	8, 39.052502, -28.652000, 39.214748, -28.463249, 39.490002, -28.403000,
	8, 39.611252, -28.376499, 39.764252, -28.219999, 39.908249, -28.176001,
	8, 40.506248, -27.993250, 40.966999, -27.611000, 41.515499, -27.387251,
	8, 41.705250, -27.309750, 41.924252, -27.251249, 42.082500, -27.127251,
/* path_data105 ===========================================*/
	2, 22.924000, -30.684750,
	8, 22.294500, -31.115999, 21.702499, -31.392500, 21.091999, -31.839001,
	8, 21.046749, -31.872250, 20.956751, -31.829750, 20.906250, -31.860250,
	8, 20.654499, -32.012501, 20.432501, -32.157749, 20.187000, -32.331749,
	8, 20.052250, -32.427250, 19.847000, -32.424500, 19.719999, -32.488998,
	8, 19.084000, -32.812000, 18.426750, -32.951500, 17.799999, -33.250000,
	8, 17.970501, -33.409500, 18.250999, -33.348499, 18.400000, -33.549999,
	8, 18.448750, -33.480000, 18.508249, -33.409000, 18.596500, -33.456749,
	8, 19.016001, -33.682751, 19.478500, -33.721001, 19.897499, -33.698502,
	8, 20.323500, -33.675499, 20.753500, -33.599251, 21.197250, -33.531250,
	8, 21.274000, -33.519501, 21.323750, -33.388748, 21.404499, -33.364498,
	8, 21.961500, -33.198750, 22.558750, -33.330002, 23.088499, -33.120499,
	8, 23.486250, -32.963249, 23.878750, -32.757500, 24.188499, -32.438751,
	8, 24.251499, -32.373749, 24.170250, -32.298500, 24.100250, -32.250000,
	8, 24.197250, -32.277248, 24.265499, -32.225750, 24.293249, -32.147499,
	8, 24.314251, -32.087749, 24.314251, -32.012249, 24.293249, -31.952499,
	8, 24.265249, -31.874500, 24.195499, -31.849251, 24.101999, -31.836500,
	8, 23.750250, -31.789000, 24.193251, -32.133999, 24.018250, -32.021999,
	8, 23.700001, -31.818501, 23.886499, -31.466999, 23.700251, -31.150000,
	8, 23.630251, -31.198500, 23.572750, -31.253000, 23.600250, -31.350000,
	8, 23.658751, -31.219500, 23.508249, -31.146999, 23.466249, -31.068001,
	8, 23.370001, -30.886749, 23.145250, -30.533001, 22.924000, -30.684750,
/* path_data106 ===========================================*/
	2, 14.799500, -28.847750,
	8, 14.011000, -29.046249, 13.248500, -29.017500, 12.494500, -29.336500,
	8, 12.477750, -29.343500, 12.422000, -29.256750, 12.406000, -29.263500,
	8, 12.064500, -29.412001, 11.835000, -29.653500, 11.566000, -29.915001,
	8, 11.337750, -30.136999, 10.923250, -30.040251, 10.604750, -30.162001,
	8, 10.523750, -30.193001, 10.473000, -30.320999, 10.397750, -30.330750,
	8, 10.093000, -30.370001, 9.861250, -30.607250, 9.600000, -30.750000,
	8, 10.184000, -30.948750, 10.786750, -30.941000, 11.402250, -31.037001,
	8, 11.430500, -31.041500, 11.466750, -30.961250, 11.500000, -30.961250,
	8, 11.534000, -30.961250, 11.566500, -31.016500, 11.600000, -31.049999,
	8, 11.648750, -30.980000, 11.724250, -30.898500, 11.788500, -30.962000,
	8, 11.925500, -31.097000, 12.064500, -31.049500, 12.199500, -31.039499,
	8, 12.235500, -31.037001, 12.266750, -30.961250, 12.300000, -30.961250,
	8, 12.334000, -30.961250, 12.366750, -31.039000, 12.400000, -31.039000,
	8, 12.434000, -31.038750, 12.466750, -30.961250, 12.500000, -30.961250,
	8, 12.534000, -30.961250, 12.566500, -31.016500, 12.600000, -31.049999,
	8, 12.773000, -30.854500, 12.994250, -30.993000, 13.199750, -30.948250,
	8, 13.459250, -30.891500, 13.526000, -30.604500, 13.794500, -30.530001,
	8, 14.973250, -30.204000, 16.007500, -29.667749, 17.098249, -29.146000,
	8, 17.174999, -29.109249, 17.227501, -29.047251, 17.200001, -28.950001,
	8, 17.266750, -28.950001, 17.344999, -28.972000, 17.392500, -28.938999,
	8, 17.657000, -28.756001, 17.917250, -28.618999, 18.091499, -28.344500,
	8, 18.145500, -28.259750, 18.063250, -28.158001, 18.004999, -28.171000,
	8, 16.897751, -28.419750, 15.896250, -28.571751, 14.799500, -28.847750,
/* path_data107 ===========================================*/
	2, 11.334500, -17.794750,
	8, 10.936500, -18.099501, 10.790500, -18.607250, 10.508500, -19.055250,
	8, 10.455000, -19.140249, 10.523500, -19.218750, 10.602750, -19.240999,
	8, 10.742750, -19.280750, 10.878500, -19.161249, 10.980750, -19.110750,
	8, 11.417000, -18.895250, 11.800750, -18.584749, 12.300000, -18.549999,
	8, 12.797500, -17.991501, 13.862500, -17.895250, 13.864250, -17.049999,
	8, 13.864500, -16.835251, 13.507500, -17.064751, 13.400000, -16.850000,
	8, 12.787250, -17.100750, 12.190000, -17.075001, 11.595000, -17.441750,
	8, 11.440750, -17.537001, 11.523250, -17.650249, 11.334500, -17.794750,
/* path_data108 ===========================================*/
	2, 4.450000, -30.938999,
	8, 4.483750, -30.938749, 6.241500, -30.880501, 6.237250, -30.851999,
	8, 6.226000, -30.774750, 4.293500, -30.512501, 4.202500, -30.555000,
	8, 4.161500, -30.573999, 2.283500, -29.966499, 2.250000, -30.000000,
	8, 2.317000, -30.033751, 4.383500, -30.938999, 4.450000, -30.938999,
	0
};

/* path_data109 ===========================================*/
signed char path_data109[] = {
	2, 8.300000, -28.500000,
	8, 8.300000, -28.500000, 4.600000, -28.049999, 3.500000, -27.750000,
	8, 2.400000, -27.450001, -2.250000, -25.549999, -3.000000, -25.049999,
	8, -3.000000, -25.049999, -6.350000, -23.700001, -10.600000, -18.700001,
	8, -10.600000, -18.700001, -8.700000, -19.549999, -8.150000, -20.250000,
	8, -8.150000, -20.250000, -4.750000, -23.400000, -4.800000, -22.750000,
	8, -4.800000, -22.750000, -1.750000, -24.900000, -1.900000, -24.350000,
	8, -1.900000, -24.350000, 4.200000, -27.150000, 3.700000, -26.350000,
	8, 3.700000, -26.350000, 9.100000, -27.500000, 8.850000, -27.000000,
	8, 8.850000, -27.000000, 13.550000, -25.900000, 12.850000, -25.850000,
	8, 12.850000, -25.850000, 11.400000, -25.549999, 13.000000, -24.650000,
	8, 13.000000, -24.650000, 12.150000, -23.549999, 10.800000, -24.549999,
	8, 9.450000, -25.549999, 10.200000, -25.000000, 8.950000, -24.750000,
	8, 8.950000, -24.750000, 8.300000, -24.549999, 7.150000, -25.549999,
	8, 7.150000, -25.549999, 5.750000, -26.700001, 3.550000, -25.799999,
	8, 3.550000, -25.799999, -4.100000, -22.650000, -4.600000, -22.500000,
	8, -4.600000, -22.500000, -5.500000, -21.799999, -6.100000, -20.900000,
	8, -6.100000, -20.900000, -7.550000, -19.799999, -8.300000, -19.450001,
	8, -8.300000, -19.450001, -11.500000, -16.549999, -11.800000, -16.200001,
	8, -11.800000, -16.200001, -12.650000, -14.900000, -12.850000, -14.800000,
	8, -12.850000, -14.800000, -11.250000, -15.750000, -10.750000, -16.250000,
	8, -10.750000, -16.250000, -7.250000, -18.750000, -5.900000, -18.950001,
	8, -5.900000, -18.950001, -4.800000, -19.700001, -4.600000, -20.049999,
	8, -4.600000, -20.049999, -1.000000, -22.350000, 0.050000, -22.350000,
	8, 0.050000, -22.350000, 2.350000, -21.049999, 2.950000, -22.799999,
	8, 2.950000, -22.799999, 4.400000, -23.250000, 5.800000, -22.950001,
	8, 5.800000, -22.950001, 6.600000, -23.600000, 6.400000, -24.150000,
	8, 6.400000, -24.150000, 6.800000, -24.600000, 7.050000, -23.650000,
	8, 7.050000, -23.650000, 7.900000, -22.750000, 9.100000, -23.250000,
	8, 9.100000, -23.250000, 10.100000, -23.299999, 9.600000, -22.700001,
	8, 9.600000, -22.700001, 8.500000, -21.750000, 5.550000, -21.700001,
	8, 5.550000, -21.700001, 2.450000, -21.549999, -1.650000, -19.650000,
	8, -1.650000, -19.650000, -9.100000, -17.049999, -11.400000, -14.450000,
	8, -11.400000, -14.450000, -13.000000, -12.250000, -14.350000, -11.950000,
	8, -14.350000, -11.950000, -15.800000, -11.750000, -17.299999, -9.900000,
	8, -17.299999, -9.900000, -14.850000, -11.350000, -12.600000, -11.350000,
	8, -12.600000, -11.350000, -11.600000, -11.950000, -12.550000, -11.050000,
	8, -12.550000, -11.050000, -13.450000, -9.150000, -13.050000, -7.800000,
	8, -13.050000, -7.800000, -13.200000, -6.500000, -13.400000, -6.100000,
	8, -13.400000, -6.100000, -15.350000, -2.900000, -15.350000, -2.300000,
	8, -15.350000, -1.700000, -15.050000, 0.750000, -14.950000, 0.900000,
	8, -14.850000, 1.050000, -15.200000, 0.500000, -14.250000, 1.100000,
	8, -13.300000, 1.700000, -12.600000, 2.100000, -12.400000, 2.800000,
	8, -12.200000, 3.500000, -12.900000, 1.450000, -12.950000, 1.000000,
	8, -13.000000, 0.550000, -14.050000, -1.250000, -13.850000, -1.850000,
	8, -13.850000, -1.850000, -13.600000, -1.600000, -13.400000, -1.250000,
	8, -13.400000, -1.250000, -13.550000, -1.400000, -13.400000, -2.300000,
	8, -13.400000, -2.300000, -13.200000, -3.600000, -12.850000, -4.400000,
	8, -12.500000, -5.200000, -12.000000, -6.150000, -11.900000, -6.350000,
	8, -11.800000, -6.550000, -11.800000, -8.000000, -11.450000, -7.350000,
	4, -10.600000, -6.700000,
	8, -10.600000, -6.700000, -11.300000, -7.350000, -10.750000, -7.900000,
	8, -10.750000, -7.900000, -11.000000, -9.300000, -10.550000, -9.950000,
	8, -10.550000, -9.950000, -8.800000, -12.050000, -8.400000, -12.300000,
	8, -8.000000, -12.550000, -8.350000, -12.450000, -8.350000, -12.450000,
	8, -8.350000, -12.450000, -6.850000, -13.500000, -8.300000, -13.100000,
	8, -8.300000, -13.100000, -9.300000, -12.700000, -10.050000, -12.700000,
	8, -10.050000, -12.700000, -11.950000, -12.200000, -10.950000, -13.250000,
	8, -9.950000, -14.300000, -7.450000, -15.650000, -6.500000, -15.600000,
	4, -6.300000, -15.200000,
	4, -3.500000, -15.800000,
	4, -3.800000, -15.600000,
	8, -3.800000, -15.600000, -3.850000, -15.650000, -2.800000, -15.750000,
	8, -1.750000, -15.850000, -0.300000, -15.500000, 0.050000, -15.950000,
	8, 0.400000, -16.400000, 1.250000, -16.650000, 1.150000, -16.299999,
	8, 1.050000, -15.950000, 1.000000, -15.450000, 1.000000, -15.450000,
	8, 1.000000, -15.450000, 2.250000, -16.900000, 2.100000, -16.350000,
	8, 1.950000, -15.800000, -0.100000, -14.500000, -0.450000, -12.950000,
	4, 2.150000, -15.000000,
	4, 3.050000, -15.750000,
	8, 3.050000, -15.750000, 3.950000, -15.200000, 4.000000, -15.600000,
	8, 4.050000, -16.000000, 5.200000, -17.450001, 5.500000, -17.400000,
	8, 5.800000, -17.350000, 6.300000, -18.049999, 6.250000, -17.400000,
	8, 6.200000, -16.750000, 8.100000, -15.400000, 8.100000, -15.400000,
	8, 8.100000, -15.400000, 8.900000, -15.850000, 9.250000, -15.500000,
	8, 9.600000, -15.150000, 10.650000, -20.450001, 10.650000, -20.450001,
	4, 16.900000, -23.100000,
	4, 27.800249, -23.950001,
	4, 23.550249, -25.650000,
	4, 8.300000, -28.500000,
/* path_data110 ===========================================*/
	2, 12.850000, 21.250000,
	8, 12.850000, 21.250000, 9.100000, 17.049999, 7.000000, 16.400000,
	8, 7.000000, 16.400000, 3.650000, 14.700000, -2.500000, 16.650000,
	0
};

/* path_data111 ===========================================*/
signed char path_data111[] = {
	2, 6.200000, 16.049999,
	8, 6.200000, 16.049999, -0.100000, 14.050000, -3.950000, 15.100000,
	8, -3.950000, 15.100000, -8.550000, 15.600000, -10.650000, 19.049999,
	0
};

/* path_data112 ===========================================*/
signed char path_data112[] = {
	2, 5.300000, 15.750000,
	8, 5.300000, 15.750000, 1.050000, 13.950000, -2.650000, 13.400000,
	8, -2.650000, 13.400000, -6.800000, 12.750000, -10.950000, 14.550000,
	8, -10.950000, 14.550000, -14.000000, 16.049999, -15.350000, 18.600000,
	0
};

/* path_data113 ===========================================*/
signed char path_data113[] = {
	2, 5.550000, 15.850000,
	8, 5.550000, 15.850000, 1.700000, 13.100000, 1.450000, 12.750000,
	8, 1.450000, 12.750000, -0.300000, 10.000000, -3.550000, 9.900000,
	8, -3.550000, 9.900000, -8.900000, 10.100000, -13.200000, 12.100000,
/* path_data114 ===========================================*/
	2, 5.223750, 13.601750,
	8, 5.609250, 13.967500, 12.350000, 21.200001, 12.350000, 21.200001,
	8, 21.150000, 30.350250, 14.150000, 21.799999, 14.150000, 21.799999,
	8, 12.250000, 20.600000, 9.950000, 15.900000, 9.950000, 15.900000,
	8, 9.650000, 15.200000, 13.450000, 17.700001, 13.450000, 17.700001,
	8, 14.450000, 17.900000, 17.850000, 22.700001, 17.850000, 22.700001,
	8, 16.150000, 22.100000, 17.350000, 23.900000, 17.350000, 23.900000,
	8, 18.049999, 24.400000, 23.150249, 28.300249, 23.150249, 28.300249,
	8, 24.050249, 29.300249, 25.050249, 29.700251, 25.050249, 29.700251,
	8, 28.550249, 28.400249, 26.950251, 31.700251, 26.950251, 31.700251,
	8, 27.550249, 33.400249, 28.950251, 30.500250, 28.950251, 30.500250,
	8, 31.750250, 26.299999, 27.650249, 26.900249, 27.650249, 26.900249,
	8, 20.150000, 27.600250, 18.450001, 23.600000, 18.450001, 23.600000,
	8, 17.850000, 23.000000, 20.049999, 23.600000, 20.049999, 23.600000,
	8, 22.150249, 24.100000, 18.250000, 20.500000, 18.250000, 20.500000,
	8, 18.850000, 20.500000, 21.150000, 22.200001, 21.150000, 22.200001,
	8, 23.750250, 24.500000, 24.250250, 24.000000, 24.250250, 24.000000,
	8, 28.750250, 21.799999, 31.350250, 23.700001, 31.350250, 23.700001,
	8, 31.850250, 24.100000, 30.450251, 25.799999, 30.850250, 27.100250,
	8, 31.250250, 28.400249, 32.450249, 31.500250, 32.450249, 31.500250,
	8, 31.850250, 31.900249, 31.950251, 34.600250, 31.950251, 34.600250,
	8, 36.150249, 40.400249, 33.750254, 39.900249, 33.750254, 39.900249,
	8, 29.850250, 39.800251, 33.550251, 41.700249, 33.550251, 41.700249,
	8, 34.350250, 42.200249, 36.550251, 44.000254, 36.550251, 44.000254,
	8, 35.850250, 43.700249, 35.450249, 45.000254, 35.450249, 45.000254,
	8, 36.650249, 46.000254, 35.950249, 47.200249, 35.950249, 47.200249,
	8, 34.450249, 47.500254, 34.150249, 48.500254, 34.150249, 48.500254,
	8, 35.850250, 50.500254, 33.350250, 50.600250, 33.350250, 50.600250,
	8, 34.250254, 51.700249, 33.050251, 54.700249, 33.050251, 54.700249,
	8, 31.850250, 54.700249, 30.250250, 56.100250, 30.250250, 56.100250,
	8, 30.850250, 57.300251, 28.250250, 58.700249, 28.250250, 58.700249,
	8, 26.150249, 59.100250, 26.850250, 60.800251, 26.850250, 60.800251,
	8, 24.850250, 62.300251, 24.250250, 66.300247, 24.250250, 66.300247,
	8, 24.050249, 68.900253, 23.450251, 69.700249, 24.750250, 69.200249,
	8, 26.050249, 68.700249, 25.850250, 65.600250, 25.850250, 65.600250,
	8, 24.650249, 61.700249, 35.350250, 57.700249, 35.350250, 57.700249,
	8, 36.350250, 57.300251, 36.550251, 56.000254, 36.550251, 56.000254,
	8, 37.050251, 56.100250, 39.250254, 58.000254, 39.250254, 58.000254,
	8, 41.150249, 60.800251, 41.250254, 58.500254, 41.250254, 58.500254,
	8, 41.550251, 57.600250, 41.150249, 56.100250, 41.150249, 56.100250,
	8, 42.650249, 50.700249, 39.150249, 49.100250, 39.150249, 49.100250,
	8, 36.650249, 40.700249, 40.150249, 42.800251, 40.150249, 42.800251,
	8, 40.850250, 44.200249, 43.550251, 45.500254, 43.550251, 45.500254,
	4, 44.450249, 44.900249,
	8, 44.050251, 43.700249, 46.150249, 42.200249, 46.150249, 42.200249,
	8, 46.850250, 43.800251, 48.350250, 41.800251, 48.350250, 41.800251,
	8, 49.250254, 35.700249, 52.350250, 39.300251, 52.350250, 39.300251,
	8, 53.350250, 39.600250, 53.650249, 37.900249, 53.650249, 37.900249,
	8, 54.550251, 35.300251, 53.650249, 31.900249, 53.650249, 31.900249,
	8, 54.550251, 31.800249, 56.950249, 33.300251, 56.950249, 33.300251,
	8, 57.650249, 32.400249, 55.350250, 28.200251, 56.350250, 28.800249,
	8, 57.350250, 29.400249, 58.450249, 29.800249, 58.450249, 29.800249,
	8, 58.650249, 29.300249, 56.150249, 26.200251, 56.150249, 26.200251,
	8, 55.050251, 25.500000, 53.750254, 20.400000, 53.750254, 20.400000,
	8, 55.550251, 21.299999, 53.050251, 17.500000, 53.050251, 17.500000,
	8, 53.050251, 16.700001, 54.550251, 13.900000, 54.550251, 13.900000,
	8, 54.350250, 12.200000, 54.550251, 12.300000, 54.550251, 12.300000,
	8, 55.250254, 12.600000, 57.250254, 13.000000, 55.550251, 11.400000,
	8, 53.850250, 9.800000, 55.750254, 8.600000, 55.750254, 8.600000,
	8, 56.850250, 7.900000, 53.450249, 8.000000, 53.450249, 8.000000,
	8, 52.150249, 6.900000, 52.250254, 5.900000, 52.250254, 5.900000,
	8, 54.250254, 6.400000, 50.650249, 2.800000, 50.050251, 1.900000,
	8, 49.450249, 1.000000, 51.850250, -0.300000, 51.850250, -0.300000,
	8, 55.150249, -1.200000, 52.250254, -2.000000, 52.250254, -2.000000,
	8, 47.350250, -1.900000, 50.050251, -4.600000, 50.050251, -4.600000,
	8, 51.550251, -4.500000, 51.150249, -5.100000, 51.150249, -5.100000,
	8, 49.850250, -5.400000, 47.450249, -7.000000, 47.450249, -7.000000,
	8, 46.450249, -7.900000, 47.350250, -7.700000, 47.350250, -7.700000,
	8, 51.550251, -7.400000, 44.350250, -10.200000, 44.350250, -10.200000,
	8, 46.350250, -10.200000, 41.850250, -12.800000, 41.850250, -12.800000,
	8, 41.350250, -13.200000, 40.550251, -15.100000, 40.550251, -15.100000,
	8, 39.050251, -16.400000, 37.850250, -18.100000, 37.850250, -18.100000,
	8, 37.750254, -19.200001, 36.550251, -20.400000, 36.550251, -20.400000,
	8, 33.650249, -23.799999, 32.250254, -23.700001, 32.250254, -23.700001,
	8, 28.550249, -24.600000, 27.250250, -24.400000, 27.250250, -24.400000,
	4, 14.050000, -23.299999,
	8, 7.450000, -20.100000, 9.400000, -14.850000, 9.400000, -14.850000,
	8, 11.000000, -12.750000, 13.300000, -13.700000, 13.300000, -13.700000,
	8, 14.450000, -15.250000, 17.350000, -14.700000, 17.350000, -14.700000,
	8, 22.450251, -13.900000, 21.800249, -14.800000, 21.800249, -14.800000,
	8, 21.200251, -15.950000, 17.150000, -17.500000, 17.100000, -17.650000,
	8, 17.049999, -17.799999, 14.850000, -18.650000, 14.850000, -18.650000,
	8, 14.100000, -18.950001, 13.000000, -21.250000, 13.000000, -21.250000,
	8, 12.200000, -22.100000, 16.150000, -20.650000, 16.150000, -20.650000,
	8, 15.850000, -20.400000, 17.700001, -19.400000, 17.700001, -19.400000,
	8, 22.050249, -19.650000, 24.700251, -16.950001, 24.700251, -16.950001,
	8, 27.400249, -12.800000, 27.450251, -14.850000, 27.450251, -14.850000,
	8, 28.150249, -17.200001, 25.200251, -22.500000, 25.200251, -22.500000,
	8, 25.300249, -23.000000, 27.350250, -21.350000, 27.350250, -21.350000,
	8, 27.700251, -21.850000, 27.900249, -20.400000, 27.900249, -20.400000,
	8, 27.950251, -19.799999, 28.900249, -17.799999, 28.900249, -17.799999,
	8, 29.600250, -14.550000, 30.500250, -16.400000, 30.500250, -16.400000,
	4, 31.650249, -14.050000,
	8, 32.000254, -13.400000, 30.500250, -11.500000, 30.500250, -11.500000,
	8, 30.450251, -10.800000, 30.650249, -10.850000, 29.250250, -8.950000,
	8, 27.850250, -7.050000, 28.700251, -5.950000, 28.700251, -5.950000,
	8, 28.350250, -4.300000, 30.550249, -4.400000, 30.550249, -4.400000,
	8, 31.200251, -3.850000, 32.050251, -3.850000, 32.050251, -3.850000,
	8, 32.500254, -3.350000, 33.100250, -3.500000, 33.100250, -3.500000,
	8, 33.500254, -4.450000, 35.050251, -3.950000, 35.050251, -3.950000,
	8, 35.400249, -4.550000, 37.450249, -4.650000, 37.450249, -4.650000,
	8, 37.700249, -5.300000, 37.800251, -5.700000, 38.650249, -5.850000,
	8, 39.500254, -6.000000, 33.350250, -16.750000, 33.350250, -16.750000,
	8, 34.950249, -16.950001, 32.900249, -20.049999, 32.900249, -20.049999,
	8, 32.350250, -21.700001, 35.200249, -18.049999, 35.750254, -17.700001,
	8, 36.300251, -17.350000, 36.550251, -16.799999, 36.150249, -16.850000,
	8, 35.750254, -16.900000, 35.300251, -16.350000, 35.650249, -16.299999,
	8, 36.000254, -16.250000, 39.250254, -12.500000, 40.100250, -9.950000,
	8, 40.950249, -7.400000, 42.450249, -6.400000, 44.000254, -4.900000,
	8, 45.550251, -3.400000, 45.350250, 2.650000, 45.350250, 2.650000,
	8, 45.250254, 4.850000, 46.750254, 7.500000, 46.750254, 7.500000,
	8, 47.250254, 8.450000, 46.200249, 13.000000, 46.200249, 13.000000,
	8, 45.700249, 13.550000, 46.050251, 13.750000, 46.050251, 13.750000,
	8, 46.300251, 14.050000, 48.000254, 17.350000, 48.000254, 17.350000,
	8, 47.550251, 17.299999, 48.450249, 18.200001, 48.450249, 18.200001,
	8, 49.750254, 19.700001, 48.150249, 18.950001, 48.150249, 18.950001,
	8, 46.650249, 18.549999, 48.400249, 21.000000, 48.400249, 21.000000,
	8, 48.700249, 21.450001, 46.450249, 20.299999, 46.450249, 20.299999,
	8, 44.150249, 20.150000, 47.050251, 21.950001, 47.050251, 21.950001,
	8, 49.200249, 23.750000, 46.350250, 22.650000, 46.350250, 22.650000,
	8, 45.200249, 22.200001, 46.000254, 23.900000, 46.000254, 23.900000,
	8, 46.800251, 24.299999, 51.100250, 26.049999, 51.100250, 26.049999,
	8, 51.200249, 27.000250, 50.450249, 28.250250, 50.450249, 28.250250,
	8, 50.550251, 29.250250, 50.000254, 30.100250, 50.000254, 30.100250,
	8, 49.700249, 32.150249, 49.550251, 32.350250, 49.550251, 32.350250,
	8, 48.500254, 32.400249, 46.650249, 35.850250, 46.650249, 35.850250,
	8, 46.200249, 36.500254, 43.650249, 39.500254, 43.650249, 39.500254,
	8, 43.150249, 41.250254, 38.650249, 39.450249, 38.650249, 39.450249,
	8, 37.000254, 40.300251, 37.500254, 39.450249, 37.500254, 39.450249,
	8, 37.400249, 38.900249, 38.600250, 37.400249, 38.600250, 37.400249,
	8, 40.350250, 36.750254, 39.700249, 34.050251, 39.700249, 34.050251,
	8, 40.700249, 33.700249, 37.900249, 33.000254, 37.950249, 32.700249,
	8, 38.000254, 32.400249, 39.450249, 32.050251, 39.450249, 32.050251,
	8, 41.450249, 31.550249, 40.350250, 30.950251, 40.350250, 30.950251,
	8, 40.200249, 29.950251, 40.950249, 28.550249, 40.950249, 28.550249,
	8, 43.850250, 28.350250, 40.950249, 24.299999, 40.950249, 24.299999,
	8, 38.250254, 22.400000, 38.000254, 20.950001, 38.000254, 20.950001,
	8, 41.150249, 18.900000, 39.100250, 15.800000, 39.150249, 14.900000,
	8, 39.200249, 14.000000, 39.500254, 8.600000, 39.500254, 8.600000,
	8, 39.000254, 7.050000, 38.250254, 3.650000, 38.250254, 3.650000,
	8, 38.800251, 2.350000, 40.650249, -0.800000, 40.650249, -0.800000,
	8, 41.350250, -1.850000, 43.550251, -3.050000, 43.000254, -3.800000,
	8, 42.450249, -4.550000, 40.500254, -4.100000, 40.500254, -4.100000,
	8, 38.550251, -4.450000, 38.700249, -3.150000, 38.700249, -3.150000,
	8, 38.300251, -2.900000, 38.100250, -1.650000, 38.100250, -1.650000,
	8, 37.919998, 0.333250, 35.700249, 1.900000, 35.700249, 1.900000,
	8, 32.900249, 3.450000, 35.200249, 4.450000, 35.200249, 4.450000,
	8, 36.700249, 6.100000, 34.250254, 6.150000, 34.250254, 6.150000,
	8, 31.500250, 5.700000, 33.550251, 8.250000, 33.550251, 8.250000,
	8, 36.250254, 11.450000, 35.500254, 12.150000, 35.500254, 12.150000,
	8, 32.950249, 12.400000, 36.100250, 14.700000, 36.100250, 14.700000,
	8, 36.100250, 14.700000, 35.900249, 14.200000, 35.950249, 14.650000,
	8, 36.000254, 15.100000, 36.750254, 16.150000, 36.950249, 16.650000,
	8, 37.150249, 17.150000, 36.150249, 17.200001, 36.150249, 17.200001,
	8, 36.300251, 19.600000, 32.450249, 18.549999, 32.450249, 18.549999,
	8, 32.450249, 18.549999, 32.450249, 18.549999, 32.050251, 18.600000,
	8, 31.650249, 18.650000, 28.850250, 18.450001, 27.400249, 17.900000,
	8, 25.950251, 17.350000, 24.250250, 17.350000, 24.250250, 17.350000,
	8, 24.250250, 17.350000, 23.250250, 17.799999, 21.350000, 17.750000,
	8, 19.450001, 17.700001, 17.450001, 18.400000, 17.450001, 18.400000,
	8, 16.350000, 18.299999, 18.500000, 17.200001, 18.549999, 17.250000,
	8, 18.600000, 17.299999, 20.000000, 15.900000, 18.000000, 16.049999,
	8, 12.550750, 16.458750, 9.850000, 13.900000, 9.850000, 13.900000,
	8, 9.350000, 13.550000, 8.700000, 12.850000, 8.700000, 12.850000,
	8, 6.200000, 12.350000, 9.050000, 15.950000, 9.050000, 15.950000,
	8, 9.350000, 16.299999, 9.000000, 16.549999, 9.000000, 16.549999,
	8, 8.800000, 16.150000, 6.850000, 14.800000, 6.850000, 14.800000,
	8, 6.147250, 14.556750, 5.806500, 14.223250, 5.223750, 13.601750,
	0
};

/* path_data115 ===========================================*/
signed char path_data115[] = {
	2, -0.750000, 10.700000,
	8, -0.750000, 10.700000, 2.150000, 12.100000, 2.800000, 12.800000,
	8, 3.450000, 13.500000, 6.950000, 16.350000, 6.950000, 16.350000,
	8, 6.950000, 16.350000, 5.600000, 15.850000, 4.950000, 15.400000,
	8, 4.300000, 14.950000, 1.600000, 12.900000, 1.600000, 12.900000,
	8, 1.600000, 12.900000, 0.650000, 11.400000, -0.750000, 10.700000,
	0
};

/* path_data116 ===========================================*/
signed char path_data116[] = {
	2, -15.252250, 2.900750,
	8, -15.168000, 2.863750, -15.299000, 2.185750, -15.350000, 2.050000,
	8, -15.605500, 1.368500, -17.850000, 1.000000, -17.850000, 1.000000,
	8, -17.906750, 1.341250, -17.920500, 1.740250, -17.893999, 2.149750,
	8, -17.893999, 2.149750, -16.677000, 3.529500, -15.252250, 2.900750,
	0
};

/* path_data117 ===========================================*/
signed char path_data117[] = {
	2, -15.252250, 2.850750,
	8, -15.364500, 2.890250, -15.256000, 2.167250, -15.300000, 2.050000,
	8, -15.555500, 1.368500, -17.850000, 0.975000, -17.850000, 0.975000,
	8, -17.906750, 1.316250, -17.920500, 1.715250, -17.893999, 2.124750,
	8, -17.893999, 2.124750, -16.827000, 3.404500, -15.252250, 2.850750,
	0
};

/* path_data118 ===========================================*/
signed char path_data118[] = {
	2, -16.350000, 3.736500,
	8, -18.506250, 0.886500, -16.632750, 0.601500, -16.632750, 0.250000,
	8, -18.632750, 0.898750, -16.506250, 0.613750, -16.350000, 0.613750,
	8, -18.193750, 0.613750, -16.066999, 0.898750, -16.066999, 0.250000,
	8, -18.066999, 0.601500, -16.193750, 0.686500, -16.350000, 0.686500,
/* path_data120 ===========================================*/
	2, -27.750000, 27.400249,
	8, -27.750000, 27.400249, -29.150000, 29.900249, -22.950001, 28.400249,
	8, -22.950001, 28.400249, -19.450001, 28.100250, -18.850000, 27.500250,
	8, -18.549999, 27.700251, -16.458500, 28.433500, -15.750000, 28.600250,
	8, -14.050000, 29.000250, -11.950000, 26.500000, -11.950000, 26.500000,
	8, -11.950000, 26.500000, -10.800000, 23.875000, -10.100000, 23.875000,
	8, -9.400000, 23.875000, -10.200000, 24.275000, -10.200000, 24.275000,
	8, -10.200000, 24.275000, -11.850000, 26.800249, -11.750000, 27.200251,
	8, -11.750000, 27.200251, -13.050000, 32.200249, -17.049999, 32.400249,
	8, -17.049999, 32.400249, -21.087500, 32.637749, -20.750000, 34.100250,
	8, -20.750000, 34.100250, -18.549999, 33.500254, -17.950001, 34.100250,
	8, -17.950001, 34.100250, -15.250000, 34.000254, -17.250000, 35.600250,
	4, -18.950001, 38.500254,
	8, -18.950001, 38.500254, -18.915001, 39.479754, -21.450001, 38.600250,
	8, -23.900000, 37.750254, -26.475000, 34.525249, -26.475000, 34.525249,
	8, -26.475000, 34.525249, -30.462500, 30.887751, -27.750000, 27.400249,
	0
};

/* path_data121 ===========================================*/
signed char path_data121[] = {
	2, -28.049999, 28.400249,
	8, -28.049999, 28.400249, -28.549999, 30.800249, -19.350000, 28.200251,
	8, -19.350000, 28.200251, -18.250000, 28.200251, -17.650000, 28.400249,
	8, -17.049999, 28.600250, -14.050000, 29.300249, -13.550000, 29.000250,
	8, -13.550000, 29.000250, -15.350000, 32.400249, -18.250000, 32.000252,
	8, -18.250000, 32.000252, -21.549999, 32.400249, -21.450001, 33.600250,
	8, -21.450001, 33.600250, -20.450001, 35.400249, -19.250000, 36.000252,
	8, -19.250000, 36.000252, -18.549999, 36.600250, -18.650000, 37.400249,
	8, -18.750000, 38.200249, -19.450001, 38.600250, -19.950001, 38.800251,
	8, -20.450001, 39.000252, -21.250000, 38.200249, -21.650000, 38.200249,
	8, -22.049999, 38.200249, -24.150000, 36.600250, -25.250000, 35.400249,
	8, -26.350000, 34.200249, -28.450001, 31.200251, -28.350000, 30.500250,
	8, -28.250000, 29.800249, -28.049999, 28.400249, -28.049999, 28.400249,
	0
};

/* path_data122 ===========================================*/
signed char path_data122[] = {
	2, -27.250000, 32.762749,
	8, -26.600000, 33.750252, -25.799999, 34.800251, -25.250000, 35.400249,
	8, -24.150000, 36.600250, -22.049999, 38.200249, -21.650000, 38.200249,
	8, -21.250000, 38.200249, -20.450001, 39.000252, -19.950001, 38.800251,
	8, -19.450001, 38.600250, -18.750000, 38.200249, -18.650000, 37.400249,
	8, -18.549999, 36.600250, -19.250000, 36.000252, -19.250000, 36.000252,
	8, -20.016500, 35.617001, -20.701500, 34.743999, -21.096251, 34.163250,
	8, -21.096251, 34.163250, -21.049999, 34.800251, -22.350000, 34.600250,
	8, -23.650000, 34.400249, -24.950001, 33.700249, -25.350000, 32.900249,
	8, -25.750000, 32.100250, -26.350000, 31.500250, -25.950001, 32.400249,
	8, -25.549999, 33.300251, -24.950001, 34.200249, -24.549999, 34.300251,
	8, -24.150000, 34.400249, -24.250000, 34.700249, -24.850000, 34.600250,
	8, -25.450001, 34.500252, -26.150000, 34.400249, -27.250000, 33.100250,
	0
};

/* path_data123 ===========================================*/
signed char path_data123[] = {
	2, -27.900000, 27.500250,
	8, -27.900000, 27.500250, -27.450001, 24.100000, -27.150000, 23.100000,
	8, -27.150000, 23.100000, -27.350000, 21.400000, -26.750000, 20.350000,
	8, -26.150000, 19.299999, -25.650000, 17.750000, -24.900000, 16.400000,
	8, -24.150000, 15.050000, -24.100000, 14.050000, -23.100000, 13.650000,
	8, -22.100000, 13.250000, -20.600000, 11.100000, -19.900000, 10.850000,
	8, -19.200001, 10.600000, -19.250000, 10.800000, -19.250000, 10.800000,
	8, -19.250000, 10.800000, -17.549999, 7.100000, -14.150000, 8.100000,
	8, -14.150000, 8.100000, -18.200001, 7.400000, -14.250000, 5.050000,
	8, -14.250000, 5.050000, -15.450000, 5.325000, -14.625000, 3.575000,
	8, -14.074750, 2.408000, -14.200000, 4.100000, -16.950001, 7.050000,
	8, -16.950001, 7.050000, -18.200001, 9.200000, -19.500000, 9.950000,
	8, -20.799999, 10.700000, -23.799999, 12.450000, -24.100000, 13.400000,
	8, -24.400000, 14.350000, -25.200001, 15.800000, -25.700001, 16.200001,
	8, -26.200001, 16.600000, -26.900000, 17.650000, -27.000000, 18.500000,
	8, -27.000000, 18.500000, -27.299999, 19.500000, -27.650000, 19.799999,
	8, -28.000000, 20.100000, -28.049999, 20.900000, -28.049999, 21.400000,
	8, -28.049999, 21.900000, -28.549999, 22.600000, -28.500000, 23.200001,
	8, -28.500000, 23.200001, -28.299999, 27.950251, -28.400000, 28.450251,
	4, -27.900000, 27.500250,
	0
};

/* path_data124 ===========================================*/
signed char path_data124[] = {
	2, -30.049999, 28.650249,
	8, -30.049999, 28.650249, -30.549999, 28.300249, -31.650000, 29.800249,
	8, -31.650000, 29.800249, -29.825001, 38.050251, -29.825001, 38.400249,
	8, -29.825001, 38.400249, -29.549999, 37.875252, -29.875000, 36.075249,
	8, -30.200001, 34.275249, -30.424999, 31.100250, -30.424999, 31.100250,
	4, -30.049999, 28.650249,
	0
};

/* path_data125 ===========================================*/
signed char path_data125[] = {
	2, -24.650000, 13.500000,
	8, -24.650000, 13.500000, -29.049999, 14.300000, -28.950001, 21.600000,
	4, -29.150000, 27.800249,
	8, -29.150000, 27.800249, -29.450001, 21.400000, -29.750000, 21.000000,
	8, -30.049999, 20.600000, -29.049999, 17.799999, -29.850000, 19.299999,
	8, -29.850000, 19.299999, -33.349998, 22.799999, -31.350000, 28.100250,
	8, -31.350000, 28.100250, -30.975000, 28.925249, -31.725000, 27.775249,
	8, -31.725000, 27.775249, -32.875000, 24.625000, -32.599998, 23.025000,
	8, -32.599998, 23.025000, -32.549999, 22.475000, -32.075001, 21.775000,
	8, -32.075001, 21.775000, -29.924999, 18.850000, -29.250000, 18.275000,
	8, -29.250000, 18.275000, -28.799999, 14.675000, -24.950001, 13.375000,
	8, -24.950001, 13.375000, -23.525000, 12.800000, -24.650000, 13.500000,
	0
};

/* path_data126 ===========================================*/
signed char path_data126[] = {
	2, 10.200000, -3.050000,
	8, 10.365000, -3.138500, 10.362750, -3.381000, 10.507750, -3.424250,
	8, 10.795000, -3.510250, 10.836000, -3.777000, 10.965500, -3.973000,
	8, 11.183750, -4.302750, 11.232000, -4.686000, 11.377500, -5.058750,
	8, 11.445500, -5.233750, 11.452250, -5.472500, 11.374000, -5.637500,
	8, 11.080500, -6.257750, 10.905000, -6.870000, 10.544500, -7.476500,
	8, 10.477500, -7.589000, 10.412000, -7.787500, 10.361750, -7.937000,
	8, 10.246000, -8.283000, 9.931750, -8.530750, 9.716750, -8.860750,
	8, 9.644750, -8.971000, 9.776000, -9.202250, 9.597000, -9.223250,
	8, 9.372750, -9.249500, 9.010500, -9.394500, 8.952250, -9.138000,
	8, 8.805250, -8.491250, 9.058000, -7.860500, 9.300000, -7.250000,
	8, 9.104500, -7.077000, 9.188000, -6.846750, 9.226000, -6.655000,
	8, 9.403500, -5.753500, 9.104000, -4.915500, 8.913750, -4.047000,
	8, 8.908000, -4.021000, 8.993500, -3.971500, 8.986500, -3.956000,
	8, 8.681000, -3.284500, 8.318000, -2.673250, 7.863250, -2.078000,
	8, 7.673750, -1.830000, 7.455750, -1.601000, 7.331500, -1.335250,
	8, 7.239500, -1.138500, 7.137500, -0.897000, 7.200000, -0.650000,
	8, 6.341250, 0.045000, 5.778750, 1.006250, 5.126000, 1.967750,
	8, 5.010500, 2.137750, 5.083250, 2.440000, 5.221000, 2.507250,
	8, 5.424250, 2.606750, 5.663250, 2.350750, 5.780750, 2.139250,
	8, 5.878000, 1.964750, 5.966250, 1.802250, 6.089000, 1.641500,
	8, 6.122250, 1.597750, 6.077500, 1.493000, 6.111250, 1.462750,
	8, 6.769500, 0.876000, 7.186750, 0.142000, 7.800000, -0.450000,
	8, 8.287500, -0.532250, 8.671750, -0.781750, 9.108750, -1.035000,
	8, 9.185750, -1.079750, 9.316750, -1.017500, 9.389250, -1.066250,
	8, 9.827500, -1.360500, 9.827000, -1.869500, 9.853500, -2.347000,
	8, 9.866000, -2.568000, 9.915000, -2.897250, 10.200000, -3.050000,
	0
};

/* path_data127 ===========================================*/
signed char path_data127[] = {
	2, 7.989750, -4.166500,
	8, 8.020750, -4.185750, 7.982000, -4.291500, 8.009250, -4.345500,
	8, 8.049750, -4.426500, 8.150500, -4.473500, 8.191000, -4.554500,
	8, 8.218250, -4.608500, 8.177500, -4.703500, 8.211500, -4.739000,
	8, 8.794750, -5.350750, 8.859000, -6.106750, 8.600000, -6.850000,
	8, 8.856000, -7.005000, 8.871250, -7.320500, 8.765000, -7.532250,
	8, 8.551750, -7.957250, 8.503500, -8.438750, 8.259750, -8.824500,
	8, 8.059250, -9.141750, 7.664750, -9.452750, 7.322000, -9.127000,
	8, 7.216750, -9.027000, 7.136500, -8.830250, 7.206000, -8.652250,
	8, 7.222000, -8.611500, 7.293250, -8.575000, 7.286500, -8.554500,
	8, 7.259750, -8.473500, 7.123250, -8.417500, 7.121750, -8.349500,
	8, 7.114250, -7.975500, 6.875750, -7.597750, 7.033250, -7.265500,
	8, 7.226250, -6.858250, 7.431000, -6.394000, 7.600000, -5.950000,
	8, 7.291500, -5.421000, 7.549750, -4.808750, 7.111500, -4.339500,
	8, 7.077500, -4.303000, 7.079750, -4.206500, 7.110250, -4.156000,
	8, 7.183250, -4.034500, 7.284750, -3.933000, 7.406250, -3.860000,
	8, 7.456750, -3.829750, 7.543750, -3.829250, 7.593750, -3.860250,
	8, 7.738250, -3.950750, 7.837750, -4.072500, 7.989750, -4.166500,
/* path_data128 ===========================================*/
	2, 23.692751, -6.744250,
	8, 24.040001, -6.296250, 24.112499, -5.597500, 23.600250, -5.250000,
	8, 23.737749, -4.422750, 24.575500, -4.917500, 25.100250, -5.050000,
	8, 25.073000, -5.147000, 25.129749, -5.233000, 25.200500, -5.234250,
	8, 25.464750, -5.238000, 25.634750, -5.496000, 25.900249, -5.450000,
	8, 26.008751, -5.839250, 26.418249, -6.014750, 26.579250, -6.359750,
	8, 27.010750, -7.283500, 26.863001, -8.351750, 26.216999, -9.163250,
	8, 26.166500, -9.226750, 26.220751, -9.356000, 26.189751, -9.446500,
	8, 26.000750, -9.999250, 25.483749, -10.078000, 25.000250, -10.250000,
	8, 24.705999, -11.218750, 24.540751, -12.226500, 24.100250, -13.150000,
	8, 23.696751, -13.212500, 23.522249, -13.647250, 23.188000, -13.827250,
	8, 22.854750, -14.007000, 22.712749, -13.612250, 22.723000, -13.350750,
	8, 22.724751, -13.299500, 22.837749, -13.243500, 22.795250, -13.152250,
	8, 22.776251, -13.111250, 22.711250, -13.083500, 22.711250, -13.050000,
	8, 22.711500, -13.016250, 22.766750, -12.983500, 22.800249, -12.950000,
	8, 22.570749, -12.745000, 22.215000, -12.625750, 22.141251, -12.339500,
	8, 21.902750, -11.412000, 22.546000, -10.630750, 22.962999, -9.830500,
	8, 23.110750, -9.546750, 22.926750, -9.229000, 22.736750, -8.927000,
	8, 22.627251, -8.753250, 22.654249, -8.471500, 22.723249, -8.257500,
	8, 22.911249, -7.674750, 23.309000, -7.240000, 23.692751, -6.744250,
/* path_data129 ===========================================*/
	2, 14.402750, -2.147750,
	8, 14.031000, -1.685000, 13.178000, -1.042750, 13.907250, -0.560750,
	8, 13.955750, -0.528500, 14.048250, -0.527500, 14.091500, -0.561000,
	8, 14.596750, -0.952250, 15.097500, -1.178000, 15.706500, -1.323500,
	8, 15.737500, -1.330750, 15.806000, -1.214000, 15.898250, -1.254250,
	8, 16.301500, -1.430000, 16.804001, -1.415500, 17.100000, -1.750000,
	8, 18.041750, -1.694000, 18.933001, -1.973000, 19.780750, -2.300000,
	8, 20.070999, -2.412000, 20.388500, -2.551750, 20.688749, -2.677250,
	8, 21.032749, -2.821250, 21.333750, -3.053250, 21.611750, -3.338500,
	8, 21.645000, -3.372500, 21.733500, -3.350000, 21.800249, -3.350000,
	8, 21.790251, -3.565750, 22.030750, -3.597500, 22.092501, -3.753000,
	8, 22.115499, -3.811000, 22.077999, -3.910000, 22.111250, -3.935500,
	8, 22.645750, -4.343000, 22.875750, -4.847500, 22.583500, -5.441750,
	8, 22.512251, -5.586250, 22.450001, -5.740750, 22.308500, -5.859750,
	8, 22.037251, -6.087500, 21.761749, -5.874000, 21.500000, -5.950000,
	8, 21.460251, -5.793000, 21.278000, -5.836000, 21.181499, -5.786500,
	8, 20.966749, -5.676750, 20.633499, -5.823000, 20.418751, -5.713500,
	8, 20.078251, -5.539750, 19.768000, -5.497500, 19.412500, -5.403250,
	8, 19.334499, -5.382750, 19.139999, -5.406750, 19.100000, -5.250000,
	8, 19.066500, -5.283500, 19.029499, -5.342000, 19.003000, -5.336500,
	8, 18.525999, -5.237500, 18.211000, -5.184000, 17.885750, -4.761000,
	8, 17.860001, -4.727750, 17.749500, -4.772500, 17.709749, -4.738750,
	8, 17.470501, -4.536750, 17.369249, -4.228250, 17.094000, -4.060250,
	8, 17.043751, -4.029500, 16.955750, -4.071500, 16.907249, -4.039250,
	8, 16.745750, -3.931500, 16.653999, -3.771250, 16.493500, -3.659500,
	8, 16.411249, -3.602250, 16.311251, -3.683500, 16.319250, -3.747500,
	8, 16.380501, -4.234250, 16.543751, -4.681000, 16.400000, -5.150000,
	8, 16.919250, -5.780000, 17.548500, -6.267250, 18.000000, -6.950000,
	8, 18.003750, -7.491500, 18.176750, -8.028000, 18.148500, -8.547250,
	8, 18.146000, -8.595500, 18.073999, -8.778750, 18.042500, -8.865500,
	8, 17.964500, -9.079000, 18.191000, -9.345500, 17.980000, -9.526500,
	8, 17.629000, -9.827250, 17.306000, -9.608250, 17.100000, -9.250000,
	8, 16.640499, -9.152500, 16.124001, -8.979250, 15.729500, -9.287750,
	8, 15.477750, -9.484500, 15.333250, -9.711000, 15.133500, -9.975000,
	8, 14.887250, -10.300500, 14.971000, -10.659500, 14.988500, -11.050500,
	8, 14.990000, -11.082500, 14.911250, -11.116500, 14.911250, -11.150000,
	8, 14.911500, -11.183750, 14.966500, -11.216500, 15.000000, -11.250000,
	8, 14.823500, -11.406500, 14.754750, -11.671000, 14.500000, -11.750000,
	8, 14.576250, -12.023000, 14.407250, -12.244000, 14.189500, -12.319500,
	8, 13.690750, -12.492250, 13.271500, -12.014250, 12.798500, -11.996000,
	8, 12.670000, -11.991250, 12.553250, -12.250750, 12.391000, -12.332000,
	8, 12.283000, -12.386000, 12.107000, -12.394250, 12.016500, -12.327750,
	8, 11.844500, -12.201750, 11.697250, -12.173250, 11.507750, -12.122000,
	8, 11.103500, -12.013000, 10.784000, -11.739500, 10.414000, -11.525750,
	8, 10.042750, -11.311500, 9.804000, -10.952250, 9.534000, -10.622250,
	8, 9.298750, -10.334250, 9.264750, -9.730750, 9.619750, -9.605750,
	8, 10.080500, -9.443250, 10.406500, -10.119000, 10.898000, -10.037500,
	8, 10.976000, -10.024750, 11.027500, -9.947000, 11.000000, -9.850000,
	8, 11.097250, -9.822750, 11.151750, -9.880000, 11.200000, -9.950000,
	8, 11.414500, -9.695250, 11.705500, -9.611000, 11.940000, -9.392750,
	8, 12.182500, -9.166750, 12.619000, -9.271250, 12.872750, -9.022000,
	8, 13.255000, -8.646500, 13.115250, -7.976250, 13.600000, -7.650000,
	8, 13.453500, -7.321750, 13.301750, -7.002500, 13.218000, -6.645750,
	8, 13.147500, -6.344250, 13.396000, -6.045000, 13.698750, -6.067750,
	8, 14.013250, -6.091250, 14.078750, -6.281000, 14.200000, -6.550000,
	8, 14.266750, -6.483250, 14.384000, -6.409000, 14.373750, -6.355000,
	8, 14.259500, -5.758250, 14.002750, -5.260000, 13.888250, -4.652250,
	8, 13.873500, -4.573000, 13.797250, -4.522500, 13.700000, -4.550000,
	8, 13.583000, -3.512750, 12.570000, -2.914250, 11.933750, -2.123000,
	8, 11.833000, -1.997500, 11.832000, -1.685250, 11.934250, -1.584500,
	8, 12.285000, -1.237750, 12.775000, -1.624250, 13.200000, -1.750000,
	8, 13.253250, -2.051500, 13.468000, -2.287000, 13.801000, -2.273000,
	8, 13.865000, -2.270500, 13.923750, -2.406000, 14.004750, -2.438500,
	8, 14.091750, -2.473000, 14.217250, -2.417000, 14.288750, -2.466500,
	8, 14.721000, -2.765250, 15.073000, -3.041750, 15.507500, -3.339000,
	8, 15.555500, -3.371750, 15.641500, -3.332000, 15.695500, -3.359000,
	8, 15.776750, -3.399500, 15.823500, -3.496250, 15.904250, -3.542500,
	8, 15.991250, -3.592500, 16.051750, -3.520000, 16.100000, -3.450000,
	8, 15.938500, -3.362750, 15.937500, -3.123500, 15.792000, -3.073000,
	8, 15.598250, -3.006000, 15.458000, -2.877750, 15.289500, -2.766000,
	8, 15.216500, -2.717750, 15.051750, -2.779750, 15.025750, -2.735000,
	8, 14.876250, -2.478000, 14.580250, -2.368500, 14.402750, -2.147750,
/* path_data130 ===========================================*/
	2, 0.550000, -14.500000,
	8, 0.550000, -14.500000, -1.759500, -15.218000, -4.550000, -8.800000,
	8, -4.550000, -8.800000, -5.150000, -7.500000, -5.750000, -7.000000,
	8, -6.350000, -6.500000, -9.150000, -5.600000, -9.650000, -4.600000,
	4, -12.250000, -0.600000,
	8, -12.250000, -0.600000, -8.550000, -4.600000, -7.750000, -5.200000,
	8, -7.750000, -5.200000, -5.750000, -7.300000, -6.550000, -5.600000,
	8, -6.550000, -5.600000, -10.050000, -2.900000, -9.750000, -0.600000,
	8, -9.750000, -0.600000, -11.150000, 3.000000, -11.350000, 3.500000,
	8, -11.350000, 3.500000, -7.350000, -4.500000, -6.750000, -4.800000,
	8, -6.150000, -5.100000, -5.850000, -5.100000, -6.150000, -4.200000,
	8, -6.450000, -3.300000, -6.550000, 0.800000, -7.250000, 1.300000,
	8, -7.250000, 1.300000, -5.250000, -3.800000, -5.450000, -4.600000,
	8, -5.450000, -4.600000, -4.650000, -5.500000, -4.050000, -4.200000,
	4, -4.350000, -0.200000,
	4, -3.250000, 2.800000,
	8, -3.250000, 2.800000, -3.850000, 0.000000, -3.450000, -3.900000,
	8, -3.450000, -3.900000, -3.950000, -6.500000, -2.950000, -5.100000,
	8, -1.950000, -3.700000, 0.450000, -2.200000, 0.450000, -1.000000,
	8, 0.450000, -1.000000, -0.850000, -5.400000, -3.150000, -6.600000,
	4, -4.150000, -5.100000,
	4, -4.450000, -5.600000,
	8, -4.450000, -5.600000, -5.350000, -5.800000, -4.250000, -7.500000,
	8, -3.150000, -9.200000, -3.250000, -9.400000, -3.250000, -9.400000,
	8, -3.250000, -9.400000, -1.650000, -7.600000, -1.250000, -7.600000,
	8, -1.250000, -7.600000, 2.050000, -9.500000, 2.350000, -3.400000,
	8, 2.350000, -3.400000, 4.050000, -7.000000, 1.750000, -8.700000,
	8, 1.750000, -8.700000, -1.950000, -9.200000, -1.650000, -10.500000,
	4, 0.150000, -13.600000,
	8, 1.050000, -14.900000, 0.650000, -14.200000, 0.650000, -14.200000,
	0
};

/* path_data131 ===========================================*/
signed char path_data131[] = {
	2, -4.450000, -10.400000,
	8, -4.450000, -10.400000, -7.650000, -10.400000, -8.450000, -9.100000,
	4, -10.250000, -6.700000,
	8, -10.250000, -6.700000, -5.950000, -9.200000, -4.950000, -9.500000,
	8, -3.950000, -9.800000, -4.450000, -10.400000, -4.450000, -10.400000,
	0
};

/* path_data132 ===========================================*/
signed char path_data132[] = {
	2, -14.450000, -8.800000,
	8, -14.450000, -8.800000, -14.950000, -8.500000, -15.050000, -7.800000,
	8, -15.150000, -7.100000, -15.750000, -7.000000, -15.550000, -6.300000,
	8, -15.350000, -5.600000, -14.850000, -5.000000, -14.850000, -6.000000,
	8, -14.850000, -7.000000, -14.450000, -7.500000, -14.250000, -7.800000,
	8, -14.050000, -8.100000, -13.650000, -9.200000, -14.450000, -8.800000,
/* path_data133 ===========================================*/
	2, -16.650000, 6.500000,
	8, -16.650000, 6.500000, -18.750000, 5.500000, -19.549999, 4.600000,
	8, -20.350000, 3.700000, -20.237000, 4.991500, -21.450001, 4.900000,
	8, -22.911751, 4.789750, -22.650000, 0.800000, -22.650000, 0.800000,
	4, -23.650000, 2.700000,
	8, -23.650000, 2.700000, -23.950001, 6.300000, -21.950001, 5.700000,
	8, -20.973249, 5.407000, -20.650000, 5.800000, -21.049999, 6.000000,
	8, -21.450001, 6.200000, -19.650000, 6.300000, -20.350000, 6.700000,
	8, -21.049999, 7.100000, -17.450001, 5.800000, -18.049999, 8.400000,
	4, -16.650000, 6.500000,
/* path_data134 ===========================================*/
	2, -19.799999, 10.100000,
	8, -19.799999, 10.100000, -23.650000, 11.200000, -24.549999, 8.800000,
	8, -24.549999, 8.800000, -25.750000, 9.400000, -25.200001, 10.150000,
	8, -24.650000, 10.900000, -24.350000, 11.000000, -24.350000, 11.000000,
	8, -24.350000, 11.000000, -23.000000, 11.300000, -23.150000, 11.500000,
	8, -23.299999, 11.700000, -23.900000, 12.550000, -23.900000, 12.550000,
	8, -23.900000, 12.550000, -21.350000, 11.050000, -19.799999, 10.100000,
	0
};

/* path_data135 ===========================================*/
signed char path_data135[] = {
	2, 37.300251, 29.650249,
	8, 37.193501, 30.183750, 36.775749, 30.384001, 36.300251, 30.550249,
	8, 35.820999, 30.310749, 35.171501, 29.534250, 34.700249, 30.050249,
	8, 34.581749, 29.930250, 34.387001, 29.915251, 34.300999, 29.749750,
	8, 34.184750, 29.525249, 34.252750, 29.263750, 34.167252, 29.064251,
	8, 34.030998, 28.746250, 33.853748, 28.404751, 33.900249, 28.050249,
	8, 34.351749, 27.872250, 34.500500, 27.395750, 34.382000, 26.955000,
	8, 34.364750, 26.890751, 34.257500, 26.841499, 34.307499, 26.754250,
	8, 34.354000, 26.673500, 34.433498, 26.616751, 34.500252, 26.549999,
	8, 34.466499, 26.583750, 34.430248, 26.642000, 34.402500, 26.636999,
	8, 34.250000, 26.610500, 34.280998, 26.451250, 34.313499, 26.354500,
	8, 34.459751, 25.917999, 34.963249, 25.851999, 35.300251, 26.150000,
	8, 35.364250, 26.008751, 35.491501, 26.057249, 35.600250, 26.049999,
	8, 35.587749, 25.905251, 35.689751, 25.773500, 35.739250, 25.668501,
	8, 35.868752, 25.393999, 36.276001, 25.670500, 36.475250, 25.517500,
	8, 36.744251, 25.311251, 37.009998, 25.136499, 37.279499, 25.287251,
	8, 37.731750, 25.540501, 38.159000, 25.843500, 38.458752, 26.278749,
	8, 38.602501, 26.487249, 38.662498, 26.807501, 38.647999, 27.047001,
	8, 38.638500, 27.208750, 38.293251, 27.120750, 38.207500, 27.353001,
	8, 38.046249, 27.790001, 38.504002, 27.919750, 38.693001, 28.254250,
	8, 38.742500, 28.341499, 38.676498, 28.417500, 38.597752, 28.441999,
	8, 38.494999, 28.474001, 38.299000, 28.426750, 38.333500, 28.540001,
	8, 38.576500, 29.338249, 37.887501, 29.507750, 37.300251, 29.650249,
/* path_data136 ===========================================*/
	2, 34.900002, 34.550251,
	8, 34.898251, 34.115749, 34.498001, 33.676750, 34.800251, 33.250252,
	8, 34.834000, 33.283749, 34.866749, 33.339001, 34.900249, 33.339001,
	8, 34.933998, 33.339001, 34.966751, 33.283749, 35.000252, 33.250252,
	8, 35.374001, 33.804249, 36.286999, 34.036251, 36.251499, 34.747749,
	8, 36.245998, 34.859501, 35.974251, 35.089001, 36.200249, 35.250252,
	8, 35.747002, 35.587250, 35.733250, 36.179749, 35.500252, 36.650249,
	8, 35.190750, 36.578751, 34.887749, 36.487999, 34.600250, 36.350250,
	8, 34.688251, 35.978748, 34.659000, 35.557751, 34.863998, 35.227749,
	8, 34.972500, 35.053249, 34.900749, 34.783501, 34.900002, 34.550251,
	0
};

/* path_data137 ===========================================*/
signed char path_data137[] = {
	2, -6.650000, 32.300251,
	8, -6.650000, 32.300251, -10.864500, 34.834251, -7.350000, 31.000250,
	8, -5.150000, 28.600250, -2.650000, 27.200251, -2.650000, 27.200251,
	8, -2.650000, 27.200251, -0.050000, 26.100000, 0.850000, 25.799999,
	8, 1.750000, 25.500000, 5.550000, 24.200001, 6.350000, 24.100000,
	8, 7.150000, 24.000000, 9.550000, 23.000000, 11.250000, 24.000000,
	8, 12.950000, 25.000000, 14.950000, 26.100000, 14.950000, 26.100000,
	8, 14.950000, 26.100000, 10.850000, 24.000000, 9.950000, 24.600000,
	8, 9.050000, 25.200001, 7.250000, 25.100000, 5.750000, 25.900000,
	8, 5.750000, 25.900000, 2.050000, 27.000250, 1.250000, 27.500250,
	8, 0.450000, 28.000250, -2.150000, 30.900249, -2.550000, 30.700251,
	8, -2.950000, 30.500250, -2.450000, 30.400249, -2.150000, 29.700251,
	8, -1.850000, 29.000250, -2.350000, 28.600250, -4.350000, 30.200251,
	8, -6.350000, 31.800249, -6.650000, 32.300251, -6.650000, 32.300251,
	0
};

/* path_data138 ===========================================*/
signed char path_data138[] = {
	2, -4.798750, 30.808500,
	8, -4.798750, 30.808500, -4.446250, 27.548500, -2.326750, 27.964750,
	8, -2.326750, 27.964750, -0.270250, 26.922251, 0.410250, 26.430250,
	8, 0.410250, 26.430250, 2.445000, 26.004749, 2.772500, 25.850500,
	8, 7.392250, 23.675501, 11.072000, 24.805250, 11.208750, 24.525249,
	8, 11.345250, 24.245501, 16.251499, 26.024750, 17.153749, 27.046249,
	8, 17.251499, 27.157000, 14.596000, 25.646999, 12.171500, 25.174250,
	8, 10.103250, 24.770750, 4.702750, 25.236000, 1.976250, 26.620001,
	8, 1.233000, 26.997250, -1.003250, 28.443251, -1.636000, 28.415501,
	8, -2.268750, 28.387501, -4.798750, 30.808500, -4.798750, 30.808500,
	0
};

/* path_data139 ===========================================*/
signed char path_data139[] = {
	2, -5.750000, 37.200249,
	8, -5.750000, 37.200249, -9.550000, 36.600250, -5.350000, 36.200249,
	8, -5.350000, 36.200249, -0.850000, 35.700249, 0.150000, 34.400249,
	8, 0.150000, 34.400249, 3.550000, 32.100250, 4.250000, 32.000252,
	8, 4.950000, 31.900249, 12.450000, 30.100250, 12.550000, 29.500250,
	8, 12.650000, 28.900249, 14.050000, 28.900249, 14.450000, 29.100250,
	8, 14.850000, 29.300249, 14.650000, 29.600250, 13.950000, 29.800249,
	8, 13.250000, 30.000250, 5.450000, 34.100250, 3.850000, 34.400249,
	8, 2.250000, 34.700249, -0.650000, 36.600250, -1.850000, 36.900249,
	8, -3.050000, 37.200249, -5.750000, 37.200249, -5.750000, 37.200249,
	0
};

/* path_data140 ===========================================*/
signed char path_data140[] = {
	2, -0.870000, 35.350750,
	8, -0.870000, 35.350750, -3.015500, 35.143501, -0.865250, 34.938751,
	8, -0.865250, 34.938751, 1.338750, 34.082748, 1.850750, 33.417000,
	8, 1.850750, 33.417000, 3.591750, 32.239250, 3.950000, 32.188251,
	8, 4.308500, 32.137001, 7.798500, 31.215250, 7.849750, 30.908251,
	8, 7.901000, 30.601000, 16.417500, 27.455750, 17.522499, 28.253250,
	8, 18.250250, 28.778500, 15.775000, 28.359249, 13.366500, 29.461750,
	8, 13.027750, 29.616751, 4.564500, 33.263500, 3.745250, 33.417000,
	8, 2.926000, 33.570751, 1.441250, 34.543499, 0.826750, 34.696999,
	8, 0.212500, 34.850750, -0.870000, 35.350750, -0.870000, 35.350750,
/* path_data141 ===========================================*/
	2, -2.850000, 35.900249,
	8, -2.850000, 35.900249, -1.550000, 35.800251, -1.850000, 36.200249,
	8, -2.150000, 36.600250, -2.750000, 36.400249, -2.750000, 36.400249,
	4, -2.850000, 35.900249,
/* path_data142 ===========================================*/
	2, -4.650000, 36.300251,
	8, -4.650000, 36.300251, -3.350000, 36.200249, -3.650000, 36.600250,
	8, -3.950000, 37.000252, -4.550000, 36.800251, -4.550000, 36.800251,
	4, -4.650000, 36.300251,
/* path_data143 ===========================================*/
	2, -7.250000, 36.700249,
	8, -7.250000, 36.700249, -5.950000, 36.600250, -6.250000, 37.000252,
	8, -6.550000, 37.400249, -7.150000, 37.200249, -7.150000, 37.200249,
	4, -7.250000, 36.700249,
/* path_data144 ===========================================*/
	2, -9.150000, 36.900249,
	8, -9.150000, 36.900249, -7.850000, 36.800251, -8.150000, 37.200249,
	8, -8.450000, 37.600250, -9.050000, 37.400249, -9.050000, 37.400249,
	4, -9.150000, 36.900249,
/* path_data145 ===========================================*/
	2, 0.450000, 27.000250,
	8, 0.450000, 27.000250, 1.550000, 27.000250, 1.250000, 27.400249,
	8, 0.950000, 27.800249, 0.150000, 27.700251, 0.150000, 27.700251,
	4, 0.450000, 27.000250,
/* path_data146 ===========================================*/
	2, -2.050000, 28.400249,
	8, -2.050000, 28.400249, -0.423500, 27.865000, -1.050000, 28.700251,
	8, -1.350000, 29.100250, -1.950000, 28.900249, -1.950000, 28.900249,
	4, -2.050000, 28.400249,
/* path_data147 ===========================================*/
	2, -4.850000, 29.600250,
	8, -4.850000, 29.600250, -3.550000, 29.500250, -3.850000, 29.900249,
	8, -4.150000, 30.300249, -4.750000, 30.100250, -4.750000, 30.100250,
	4, -4.850000, 29.600250,
/* path_data148 ===========================================*/
	2, -6.750000, 31.100250,
	8, -6.750000, 31.100250, -5.450000, 31.000250, -5.750000, 31.400249,
	8, -6.050000, 31.800249, -6.650000, 31.600250, -6.650000, 31.600250,
	4, -6.750000, 31.100250,
/* path_data149 ===========================================*/
	2, -8.450000, 32.300251,
	8, -8.450000, 32.300251, -7.150000, 32.200249, -7.450000, 32.600250,
	8, -7.750000, 33.000252, -8.350000, 32.800251, -8.350000, 32.800251,
	4, -8.450000, 32.300251,
	0
};

/* path_data150 ===========================================*/
signed char path_data150[] = {
	2, 1.320500, 33.899502,
	8, 1.320500, 33.899502, 3.050750, 33.766499, 2.651500, 34.298752,
	8, 2.252250, 34.831249, 1.453500, 34.564999, 1.453500, 34.564999,
	4, 1.320500, 33.899502,
/* path_data151 ===========================================*/
	2, 3.920500, 32.699501,
	8, 3.920500, 32.699501, 5.650750, 32.566502, 5.251500, 33.098751,
	8, 4.852250, 33.631248, 4.053500, 33.365002, 4.053500, 33.365002,
	4, 3.920500, 32.699501,
/* path_data152 ===========================================*/
	2, 6.620500, 31.599501,
	8, 6.620500, 31.599501, 8.350750, 31.466499, 7.951500, 31.998751,
	8, 7.552250, 32.531250, 6.753500, 32.264999, 6.753500, 32.264999,
	4, 6.620500, 31.599501,
/* path_data153 ===========================================*/
	2, 9.220500, 30.399500,
	8, 9.220500, 30.399500, 10.950750, 30.266500, 10.551500, 30.798750,
	8, 10.152250, 31.331249, 9.353500, 31.065001, 9.353500, 31.065001,
	4, 9.220500, 30.399500,
/* path_data154 ===========================================*/
	2, 2.320500, 25.899500,
	8, 2.320500, 25.899500, 4.050750, 25.766500, 3.651500, 26.298750,
	8, 3.252250, 26.831249, 2.253500, 26.764999, 2.253500, 26.764999,
	4, 2.320500, 25.899500,
/* path_data155 ===========================================*/
	2, 4.820500, 25.099501,
	8, 4.820500, 25.099501, 6.550750, 24.966499, 6.151500, 25.498751,
	8, 5.752250, 26.031250, 4.653500, 25.965000, 4.653500, 25.965000,
	4, 4.820500, 25.099501,
/* path_data156 ===========================================*/
	2, -0.850000, 35.100250,
	8, -0.850000, 35.100250, 0.450000, 35.000252, 0.150000, 35.400249,
	8, -0.150000, 35.800251, -0.750000, 35.600250, -0.750000, 35.600250,
	4, -0.850000, 35.100250,
	0
};

/* path_data157 ===========================================*/
signed char path_data157[] = {
	2, -19.150000, 10.300000,
	8, -19.150000, 10.300000, -20.250000, 12.500000, -20.350000, 13.300000,
	8, -20.350000, 13.300000, -20.150000, 11.100000, -19.850000, 10.600000,
	8, -19.549999, 10.100000, -19.150000, 10.300000, -19.150000, 10.300000,
/* path_data158 ===========================================*/
	2, -23.750000, 13.800000,
	8, -23.750000, 13.800000, -24.549999, 17.400000, -24.450001, 18.100000,
	8, -24.450001, 18.100000, -24.750000, 15.200000, -24.650000, 14.900000,
	8, -24.549999, 14.600000, -23.750000, 13.800000, -23.750000, 13.800000,
	0
};

/* path_data159 ===========================================*/
signed char path_data159[] = {
	2, -18.549999, -4.850000,
	4, -18.600000, -4.050000,
	4, -19.150000, -4.000000,
	8, -19.150000, -4.000000, -15.600000, -0.850000, -15.450000, 1.050000,
	8, -15.450000, 1.050000, -15.250000, -1.000000, -18.549999, -4.850000,
	0
};

/* path_data160 ===========================================*/
signed char path_data160[] = {
	2, -17.554001, -4.533750,
	8, -17.661751, -4.637750, -17.607000, -4.824000, -17.709000, -4.889000,
	8, -17.911249, -5.018000, -17.384501, -5.032250, -17.441500, -5.211250,
	8, -17.537251, -5.512750, -17.490499, -5.518000, -17.521000, -5.837000,
	8, -17.535250, -5.986500, -17.388250, -6.371500, -17.292000, -6.481500,
	8, -16.930500, -6.894500, -17.261499, -7.627500, -16.851500, -8.015250,
	8, -16.775499, -8.087500, -16.681499, -8.225500, -16.610250, -8.330000,
	8, -16.445499, -8.570750, -16.149500, -8.692750, -15.912000, -8.899750,
	8, -15.832500, -8.968750, -15.882750, -9.175500, -15.740500, -9.152500,
	8, -15.562000, -9.123750, -15.251750, -9.156250, -15.263000, -8.946000,
	8, -15.291250, -8.416000, -15.623500, -7.986000, -15.943500, -7.569000,
	8, -15.830750, -7.393000, -15.945250, -7.234250, -16.016251, -7.095000,
	8, -16.350000, -6.440000, -16.302750, -5.729750, -16.346251, -5.019750,
	8, -16.347500, -4.998500, -16.424250, -4.979000, -16.422251, -4.965750,
	8, -16.334000, -4.382000, -16.188000, -3.832250, -15.968250, -3.275000,
	8, -15.876750, -3.042500, -15.759000, -2.818750, -15.721500, -2.587000,
	8, -15.693750, -2.415500, -15.668000, -2.207250, -15.770000, -2.031000,
	8, -15.261250, -1.308500, -15.588500, -0.645750, -15.296250, 0.237000,
	8, -15.244500, 0.393250, -14.821500, 0.871750, -14.937250, 0.831500,
	8, -15.565500, 0.613750, -15.593500, 0.514250, -15.637750, 0.326000,
	8, -15.674250, 0.170250, -15.756750, -0.174000, -15.816000, -0.324500,
	8, -15.832000, -0.365500, -15.874750, -0.836500, -15.894250, -0.867000,
	8, -16.272499, -1.462500, -15.933000, -1.418500, -16.275499, -2.008000,
	8, -16.632500, -2.178000, -16.874001, -2.454000, -17.154751, -2.744500,
	8, -17.204250, -2.795500, -16.918501, -2.976500, -16.963751, -3.029750,
	8, -17.236750, -3.352000, -17.525000, -3.543750, -17.441000, -3.917000,
	8, -17.402250, -4.089500, -17.368000, -4.353750, -17.554001, -4.533750,
	0
};

/* path_data161 ===========================================*/
signed char path_data161[] = {
	2, -18.450001, -4.100000,
	8, -18.450001, -4.100000, -18.350000, -2.400000, -17.750000, -2.000000,
	8, -17.150000, -1.600000, -17.450001, -1.800000, -18.250000, -2.100000,
	8, -19.049999, -2.400000, -18.750000, -2.600000, -18.750000, -2.600000,
	8, -18.750000, -2.600000, -19.450001, -2.500000, -18.850000, -2.000000,
	8, -18.250000, -1.500000, -17.350000, -0.900000, -17.750000, -0.900000,
	8, -18.150000, -0.900000, -20.049999, -1.900000, -20.049999, -2.600000,
	8, -20.049999, -3.300000, -20.299999, -4.325000, -20.299999, -4.325000,
	8, -20.299999, -4.325000, -20.025000, -4.525000, -18.825001, -4.500000,
	8, -18.825001, -4.500000, -18.475000, -4.325000, -18.450001, -4.100000,
	0
};

/* path_data162 ===========================================*/
signed char path_data162[] = {
	2, -18.650000, 0.550000,
	8, -18.650000, 0.550000, -20.780001, -0.147750, -25.400000, 0.700000,
	8, -25.400000, 0.700000, -23.142250, 0.180500, -18.450001, 0.750000,
	8, -15.875000, 1.062500, -18.650000, 0.550000, -18.650000, 0.550000,
	0
};

/* path_data163 ===========================================*/
signed char path_data163[] = {
	2, -18.125500, 0.532250,
	8, -18.125500, 0.532250, -20.187000, -0.347250, -24.863251, 0.098000,
	8, -24.863251, 0.098000, -22.568750, -0.224250, -17.943501, 0.748750,
	8, -15.405000, 1.282750, -18.125500, 0.532250, -18.125500, 0.532250,
	0
};

/* path_data164 ===========================================*/
signed char path_data164[] = {
	2, -17.678499, 0.555500,
	8, -17.678499, 0.555500, -19.669001, -0.474750, -24.365250, -0.378500,
	8, -24.365250, -0.378500, -22.053249, -0.529500, -17.513000, 0.785000,
	8, -15.021500, 1.506250, -17.678499, 0.555500, -17.678499, 0.555500,
	0
};

/* path_data165 ===========================================*/
signed char path_data165[] = {
	2, -17.361000, 0.611250,
	8, -17.361000, 0.611250, -19.066999, -0.465500, -23.285500, -0.740000,
	8, -23.285500, -0.740000, -21.200750, -0.697500, -17.230499, 0.829750,
	8, -15.051500, 1.668000, -17.361000, 0.611250, -17.361000, 0.611250,
	0
};

/* path_data166 ===========================================*/
signed char path_data166[] = {
	2, 11.460000, 3.240250,
	8, 11.460000, 3.240250, 11.227500, 3.401250, 11.281000, 3.106000,
	8, 11.334750, 2.810750, 18.386749, -0.481750, 19.290251, -0.419250,
	8, 19.290251, -0.419250, 11.728250, 2.882250, 11.460000, 3.240250,
	0
};

/* path_data167 ===========================================*/
signed char path_data167[] = {
	2, 10.611500, 3.400000,
	8, 10.611500, 3.400000, 10.392500, 3.578750, 10.422750, 3.280250,
	8, 10.453000, 2.981750, 17.224751, -0.854500, 18.130251, -0.863000,
	8, 18.130251, -0.863000, 10.851000, 3.022250, 10.611500, 3.400000,
	0
};

/* path_data168 ===========================================*/
signed char path_data168[] = {
	2, 9.790000, 3.743750,
	8, 9.790000, 3.743750, 9.583000, 3.936750, 9.593500, 3.636750,
	8, 9.604000, 3.337000, 14.558250, -0.537250, 17.011250, -1.005750,
	8, 17.011250, -1.005750, 12.503750, 1.026000, 9.790000, 3.743750,
	0
};

/* path_data169 ===========================================*/
signed char path_data169[] = {
	2, 9.071000, 4.209500,
	8, 9.071000, 4.209500, 8.884750, 4.383000, 8.894250, 4.113250,
	8, 8.903750, 3.843250, 13.362250, 0.356500, 15.570000, -0.065000,
	8, 15.570000, -0.065000, 11.513500, 1.763500, 9.071000, 4.209500,
	0
};

/* path_data170 ===========================================*/
signed char path_data170[] = {
	2, 1.150000, 41.200249,
	8, 1.150000, 41.200249, -2.650000, 40.600250, 1.550000, 40.200249,
	8, 1.550000, 40.200249, 6.050000, 39.700249, 7.050000, 38.400249,
	8, 7.050000, 38.400249, 10.450000, 36.100250, 11.150000, 36.000252,
	8, 11.850000, 35.900249, 15.950000, 35.000252, 16.049999, 34.400249,
	8, 16.150000, 33.800251, 17.650000, 33.200249, 18.049999, 33.400249,
	8, 18.450001, 33.600250, 18.450001, 35.900249, 17.750000, 36.100250,
	8, 17.049999, 36.300251, 12.350000, 38.100250, 10.750000, 38.400249,
	8, 9.150000, 38.700249, 6.250000, 40.600250, 5.050000, 40.900249,
	8, 3.850000, 41.200249, 1.150000, 41.200249, 1.150000, 41.200249,
	0
};

/* path_data171 ===========================================*/
signed char path_data171[] = {
	2, 19.400000, 31.850250,
	8, 19.400000, 31.850250, 18.650000, 32.250252, 18.350000, 32.900249,
	8, 18.350000, 32.900249, 16.750000, 35.550251, 13.200000, 36.350250,
	8, 13.200000, 36.350250, 7.450000, 38.600250, 5.500000, 39.100250,
	8, 5.500000, 39.100250, 2.150000, 40.350250, 0.300000, 40.150249,
	8, 0.300000, 40.150249, -1.450000, 40.200249, 0.100000, 40.600250,
	8, 0.100000, 40.600250, 5.150000, 40.100250, 6.000000, 39.650249,
	8, 6.000000, 39.650249, 9.900000, 38.350250, 10.650000, 37.700249,
	8, 11.400000, 37.050251, 15.950000, 35.800251, 16.500000, 35.300251,
	8, 17.049999, 34.800251, 19.500000, 32.700249, 19.400000, 31.850250,
	0
};

/* path_data172 ===========================================*/
signed char path_data172[] = {
	2, 4.720500, 39.727749,
	8, 4.720500, 39.727749, 6.027750, 39.671249, 5.739500, 40.058498,
	8, 5.451250, 40.445999, 4.839250, 40.227501, 4.839250, 40.227501,
	4, 4.720500, 39.727749,
/* path_data173 ===========================================*/
	2, 2.920000, 40.065750,
	8, 2.920000, 40.065750, 4.227000, 40.009251, 3.939000, 40.396500,
	8, 3.650750, 40.784000, 3.038750, 40.565750, 3.038750, 40.565750,
	4, 2.920000, 40.065750,
/* path_data174 ===========================================*/
	2, 0.312750, 40.377750,
	8, 0.312750, 40.377750, 1.620000, 40.320999, 1.331750, 40.708500,
	8, 1.043500, 41.095749, 0.431500, 40.877499, 0.431500, 40.877499,
	4, 0.312750, 40.377750,
	0
};

/* path_data175 ===========================================*/
signed char path_data175[] = {
	2, -1.595750, 40.513748,
	8, -1.595750, 40.513748, -0.288500, 40.457249, -0.576750, 40.844501,
	8, -0.865000, 41.231998, -1.477000, 41.013500, -1.477000, 41.013500,
	4, -1.595750, 40.513748,
/* path_data176 ===========================================*/
	2, 8.853750, 37.878250,
	8, 8.853750, 37.878250, 10.593750, 37.803001, 10.210000, 38.318501,
	8, 9.826500, 38.834000, 9.011750, 38.543499, 9.011750, 38.543499,
	4, 8.853750, 37.878250,
/* path_data177 ===========================================*/
	2, 11.432500, 36.771999,
	8, 11.432500, 36.771999, 12.922250, 35.946751, 12.788750, 37.212250,
	8, 12.721250, 37.851250, 11.590500, 37.437248, 11.590500, 37.437248,
	4, 11.432500, 36.771999,
/* path_data178 ===========================================*/
	2, 13.715500, 36.068501,
	8, 13.715500, 36.068501, 15.505250, 35.143250, 15.071750, 36.508751,
	8, 14.877250, 37.121250, 13.873250, 36.733749, 13.873250, 36.733749,
	4, 13.715500, 36.068501,
/* path_data179 ===========================================*/
	2, 16.094000, 34.862251,
	8, 16.094000, 34.862251, 17.183750, 33.637001, 17.450251, 35.302502,
	8, 17.551750, 35.937000, 16.252001, 35.527500, 16.252001, 35.527500,
	4, 16.094000, 34.862251,
/* path_data180 ===========================================*/
	2, 6.708500, 38.999249,
	8, 6.708500, 38.999249, 8.015500, 38.942501, 7.727500, 39.330002,
	8, 7.439250, 39.717251, 6.827000, 39.499001, 6.827000, 39.499001,
	4, 6.708500, 38.999249,
	0
};

/* path_data181 ===========================================*/
signed char path_data181[] = {
	2, 15.608500, 8.650750,
	8, 15.608500, 8.650750, 15.427000, 8.817000, 15.426750, 8.549250,
	8, 15.426750, 8.281750, 19.797750, 4.965750, 22.008499, 4.619750,
	8, 22.008499, 4.619750, 17.983749, 6.302000, 15.608500, 8.650750,
	0
};

/* path_data182 ===========================================*/
signed char path_data182[] = {
	2, 16.350000, 24.600000,
	8, 16.350000, 24.600000, 21.850250, 30.200251, 24.150249, 31.100250,
	8, 24.150249, 31.100250, 26.450251, 33.900249, 25.450251, 40.400249,
	8, 25.450251, 40.400249, 24.650249, 42.300251, 23.850250, 37.100250,
	8, 23.850250, 37.100250, 24.650249, 30.800249, 21.850250, 34.800251,
	8, 21.850250, 34.800251, 19.750000, 32.325249, 21.350000, 32.400249,
	8, 21.350000, 32.400249, 22.150249, 32.900249, 22.250250, 32.500252,
	8, 22.350250, 32.100250, 20.350000, 28.700251, 16.049999, 25.100000,
	8, 11.750000, 21.500000, 16.350000, 24.600000, 16.350000, 24.600000,
	0
};

/* path_data183 ===========================================*/
signed char path_data183[] = {
	2, 1.750000, 34.300251,
	8, 1.750000, 34.300251, 1.700000, 33.850250, 2.150000, 34.050251,
	8, 2.600000, 34.250252, 26.150249, 35.800251, 34.050251, 41.800251,
	8, 34.050251, 41.800251, 22.750250, 36.000252, 1.750000, 34.300251,
/* path_data184 ===========================================*/
	2, 4.350000, 33.200249,
	8, 4.350000, 33.200249, 4.300000, 32.750252, 4.750000, 32.950249,
	8, 5.200000, 33.150249, 39.350250, 32.900249, 45.250252, 41.000252,
	8, 45.250252, 41.000252, 39.750252, 34.700249, 4.350000, 33.200249,
/* path_data185 ===========================================*/
	2, 7.250000, 32.200249,
	8, 7.250000, 32.200249, 7.200000, 31.750250, 7.650000, 31.950251,
	8, 8.100000, 32.150249, 51.450249, 28.900249, 57.350250, 37.000252,
	8, 57.350250, 37.000252, 54.950249, 30.600250, 7.250000, 32.200249,
/* path_data186 ===========================================*/
	2, 9.750000, 31.000250,
	8, 9.750000, 31.000250, 9.700000, 30.550249, 10.150000, 30.750250,
	8, 10.600000, 30.950251, 41.150249, 21.299999, 47.050251, 29.400249,
	8, 47.050251, 29.400249, 43.700249, 23.250000, 9.750000, 31.000250,
/* path_data187 ===========================================*/
	2, -4.750000, 36.700249,
	8, -4.750000, 36.700249, -4.800000, 36.250252, -4.350000, 36.450249,
	8, -3.900000, 36.650249, 0.550000, 37.200249, 1.050000, 46.900249,
	8, 1.050000, 46.900249, -0.750000, 36.400249, -4.750000, 36.700249,
/* path_data188 ===========================================*/
	2, -6.950000, 37.100250,
	8, -6.950000, 37.100250, -7.000000, 36.650249, -6.550000, 36.850250,
	8, -6.100000, 37.050251, -2.550000, 35.900249, -3.250000, 45.600250,
	8, -3.250000, 45.600250, -2.950000, 36.800251, -6.950000, 37.100250,
/* path_data189 ===========================================*/
	2, -8.950000, 37.200249,
	8, -8.950000, 37.200249, -9.000000, 36.750252, -8.550000, 36.950249,
	8, -8.100000, 37.150249, -4.250000, 37.300251, -7.350000, 42.900249,
	8, -7.350000, 42.900249, -4.950000, 36.900249, -8.950000, 37.200249,
/* path_data190 ===========================================*/
	2, 2.881500, 26.116249,
	8, 2.881500, 26.116249, 2.770500, 26.615999, 3.157750, 26.311750,
	8, 7.174750, 23.155500, 15.285250, 8.430000, 29.206499, 7.021500,
	8, 29.206499, 7.021500, 19.629499, 3.994000, 2.881500, 26.116249,
/* path_data191 ===========================================*/
	2, 5.681500, 25.666250,
	8, 5.681500, 25.666250, 5.340750, 25.368000, 5.807750, 25.211750,
	8, 6.274750, 25.055500, 34.385250, 6.930000, 44.206501, 8.921500,
	8, 44.206501, 8.921500, 37.429749, 7.044000, 5.681500, 25.666250,
/* path_data192 ===========================================*/
	2, 0.471250, 27.191750,
	8, 0.471250, 27.191750, 0.344000, 27.591499, 0.771750, 27.347500,
	8, 3.015500, 26.067499, 3.919250, 11.764750, 14.813500, 11.451000,
	8, 14.813500, 11.451000, 6.710750, 7.772500, 0.471250, 27.191750,
	0
};

/* path_data193 ===========================================*/
signed char path_data193[] = {
	2, -4.509500, 29.948250,
	8, -4.509500, 29.948250, -4.778750, 30.269751, -4.290500, 30.206249,
	8, -1.729000, 29.873249, 3.622250, 19.555500, 14.732000, 20.825251,
	8, 14.732000, 20.825251, 6.740500, 17.238750, -4.509500, 29.948250,
	0
};

/* path_data194 ===========================================*/
signed char path_data194[] = {
	2, -1.700000, 28.416750,
	8, -1.700000, 28.416750, -1.902750, 28.784000, -1.435500, 28.627750,
	8, 1.014250, 27.809250, 4.285250, 16.656250, 15.432250, 15.769500,
	8, 15.432250, 15.769500, 6.900750, 13.783750, -1.700000, 28.416750,
/* path_data195 ===========================================*/
	2, -6.269500, 31.228001,
	8, -6.269500, 31.228001, -6.487750, 31.488501, -6.092250, 31.437000,
	8, -4.017500, 31.167250, 0.317000, 22.809999, 9.316000, 23.838499,
	8, 9.316000, 23.838499, 2.842750, 20.933500, -6.269500, 31.228001,
	0
};

/* path_data196 ===========================================*/
signed char path_data196[] = {
	2, -8.169250, 32.705250,
	8, -8.169250, 32.705250, -8.420500, 32.966499, -8.022750, 32.937000,
	8, -6.980750, 32.859749, 0.678750, 24.590000, 5.295750, 28.465500,
	8, 5.295750, 28.465500, 2.292000, 23.784750, -8.169250, 32.705250,
/* path_data197 ===========================================*/
	2, 9.213750, 24.724501,
	8, 9.213750, 24.724501, 8.913500, 24.385750, 9.396500, 24.289499,
	8, 9.879500, 24.193501, 40.055248, 9.765250, 49.546001, 12.981750,
	8, 49.546001, 12.981750, 43.060749, 10.263250, 9.213750, 24.724501,
/* path_data198 ===========================================*/
	2, 0.850000, 40.800251,
	8, 0.850000, 40.800251, 0.800000, 40.350250, 1.250000, 40.550251,
	8, 1.700000, 40.750252, 5.550000, 40.900249, 2.450000, 46.500252,
	8, 2.450000, 46.500252, 4.850000, 40.500252, 0.850000, 40.800251,
/* path_data199 ===========================================*/
	2, 3.450000, 40.400249,
	8, 3.450000, 40.400249, 3.400000, 39.950249, 3.850000, 40.150249,
	8, 4.300000, 40.350250, 8.750000, 40.900249, 9.250000, 50.600250,
	8, 9.250000, 50.600250, 7.450000, 40.100250, 3.450000, 40.400249,
/* path_data200 ===========================================*/
	2, 5.150000, 40.000252,
	8, 5.150000, 40.000252, 5.100000, 39.550251, 5.550000, 39.750252,
	8, 6.000000, 39.950249, 12.150000, 40.800251, 18.049999, 48.900249,
	8, 18.049999, 48.900249, 9.150000, 39.700249, 5.150000, 40.000252,
/* path_data201 ===========================================*/
	2, 7.056250, 39.493000,
	8, 7.056250, 39.493000, 6.947000, 39.053501, 7.419500, 39.192001,
	8, 7.892000, 39.330502, 13.000500, 38.855751, 22.524750, 47.399750,
	8, 22.524750, 47.399750, 10.981000, 38.664001, 7.056250, 39.493000,
/* path_data202 ===========================================*/
	2, 9.656250, 38.393002,
	8, 9.656250, 38.393002, 9.547000, 37.953499, 10.019500, 38.091999,
	8, 10.492000, 38.230499, 19.200500, 39.355751, 32.124748, 48.099751,
	8, 32.124748, 48.099751, 13.581000, 37.563999, 9.656250, 38.393002,
	0
};

/* path_data203 ===========================================*/
signed char path_data203[] = {
	2, -0.450000, 35.500252,
	8, -0.450000, 35.500252, -0.500000, 35.050251, -0.050000, 35.250252,
	8, 0.400000, 35.450249, 13.750000, 36.100250, 21.350000, 42.800251,
	8, 21.350000, 42.800251, 12.624750, 36.606499, -0.450000, 35.500252,
/* path_data204 ===========================================*/
	2, -2.950000, 36.500252,
	8, -2.950000, 36.500252, -3.000000, 36.050251, -2.550000, 36.250252,
	8, -2.100000, 36.450249, 4.050000, 37.300251, 9.950000, 45.400249,
	8, 9.950000, 45.400249, 1.050000, 36.200249, -2.950000, 36.500252,
/* path_data205 ===========================================*/
	2, 12.375750, 37.240501,
	8, 12.375750, 37.240501, 12.234500, 36.810249, 12.716000, 36.913750,
	8, 13.197500, 37.016998, 21.965000, 37.500999, 35.495251, 45.274502,
	8, 35.495251, 45.274502, 16.079250, 36.675999, 12.375750, 37.240501,
/* path_data206 ===========================================*/
	2, 14.475750, 36.640499,
	8, 14.475750, 36.640499, 14.334500, 36.210251, 14.816000, 36.313751,
	8, 15.297500, 36.417000, 24.065001, 36.901001, 37.595249, 44.674500,
	8, 37.595249, 44.674500, 18.329250, 35.976002, 14.475750, 36.640499,
/* path_data207 ===========================================*/
	2, 16.875750, 35.390499,
	8, 16.875750, 35.390499, 16.734501, 34.960251, 17.216000, 35.063751,
	8, 17.697500, 35.167000, 28.465000, 36.250999, 50.895500, 44.824501,
	8, 50.895500, 44.824501, 20.729250, 34.726002, 16.875750, 35.390499,
	0
};

/* path_data208 ===========================================*/
signed char path_data208[] = {
	2, -10.950000, 37.100250,
	8, -10.950000, 37.100250, -9.650000, 37.000252, -9.950000, 37.400249,
	8, -10.250000, 37.800251, -10.850000, 37.600250, -10.850000, 37.600250,
	4, -10.950000, 37.100250,
/* path_data209 ===========================================*/
	2, -3.250000, 40.600250,
	8, -3.250000, 40.600250, -1.950000, 40.500252, -2.250000, 40.900249,
	8, -2.550000, 41.300251, -3.150000, 41.100250, -3.150000, 41.100250,
	4, -3.250000, 40.600250,
/* path_data210 ===========================================*/
	2, -5.450000, 40.500252,
	8, -5.450000, 40.500252, -4.150000, 40.400249, -4.450000, 40.800251,
	8, -4.750000, 41.200249, -5.350000, 41.000252, -5.350000, 41.000252,
	4, -5.450000, 40.500252,
/* path_data211 ===========================================*/
	2, -29.292250, 37.545502,
	8, -29.292250, 37.545502, -28.031000, 37.876251, -28.445499, 38.155998,
	8, -28.859751, 38.436001, -29.361500, 38.050499, -29.361500, 38.050499,
	4, -29.292250, 37.545502,
/* path_data212 ===========================================*/
	2, -28.792250, 35.145500,
	8, -28.792250, 35.145500, -27.531000, 35.476250, -27.945499, 35.756001,
	8, -28.359751, 36.035999, -28.861500, 35.650501, -28.861500, 35.650501,
	4, -28.792250, 35.145500,
/* path_data213 ===========================================*/
	2, -30.592251, 34.045502,
	8, -30.592251, 34.045502, -29.330999, 34.376251, -29.745501, 34.655998,
	8, -30.159750, 34.936001, -30.661501, 34.550499, -30.661501, 34.550499,
	4, -30.592251, 34.045502,
	0
};

/* path_data214 ===========================================*/
signed char path_data214[] = {
	2, -10.650000, 52.800251,
	8, -10.650000, 52.800251, -11.050000, 52.800251, -12.050000, 53.300251,
	8, -12.550000, 53.300251, -15.350000, 54.200249, -16.750000, 56.700249,
	8, -16.750000, 56.700249, -13.650000, 54.300251, -10.650000, 52.800251,
/* path_data215 ===========================================*/
	2, 11.279000, 75.961746,
	8, 11.314250, 76.026253, 11.328000, 76.131248, 11.401000, 76.135498,
	8, 11.565500, 76.145500, 11.873750, 76.220749, 11.842500, 76.061752,
	8, 11.630500, 74.985252, 11.412000, 73.750999, 10.378750, 73.299248,
	8, 10.219000, 73.229500, 9.858500, 73.332748, 9.840000, 73.553749,
	8, 9.808250, 73.934753, 9.779000, 74.272003, 9.856250, 74.638496,
	8, 9.931250, 74.993752, 10.470750, 74.996246, 10.700000, 74.650253,
	8, 10.934000, 75.068253, 11.042000, 75.528999, 11.279000, 75.961746,
/* path_data216 ===========================================*/
	2, 8.509500, 77.145248,
	8, 8.696500, 77.498497, 8.664750, 77.963249, 9.018500, 78.103996,
	8, 9.203500, 78.177498, 9.666000, 77.933746, 9.561500, 77.665253,
	8, 9.361000, 77.150002, 9.264000, 76.590248, 8.916750, 76.137497,
	8, 8.866750, 76.071999, 8.926750, 75.938751, 8.886750, 75.856750,
	8, 8.738250, 75.551750, 8.452000, 75.367996, 8.100000, 75.450249,
	8, 7.821250, 76.000999, 8.108250, 76.533249, 8.488750, 76.960503,
	8, 8.522750, 76.998497, 8.481250, 77.092499, 8.509500, 77.145248,
/* path_data217 ===========================================*/
	2, -1.391000, 75.847748,
	8, -1.418000, 75.753502, -1.427500, 75.637749, -1.386250, 75.557503,
	8, -1.253500, 75.299248, -1.055250, 75.018753, -1.139500, 74.763252,
	8, -1.226500, 74.499252, -1.505500, 74.544746, -1.668000, 74.686996,
	8, -1.951750, 74.935501, -1.964000, 75.391998, -2.136750, 75.731750,
	8, -2.185750, 75.828247, -2.173000, 75.971497, -2.283250, 76.069252,
	8, -2.401750, 76.174500, -2.511750, 76.555496, -2.487750, 76.698250,
	8, -2.474500, 76.776497, -2.520250, 79.253502, -2.464750, 79.187752,
	8, -2.310000, 79.004501, -1.547500, 76.570999, -1.530250, 76.348000,
	8, -1.516000, 76.165253, -1.333000, 76.049004, -1.391000, 75.847748,
/* path_data218 ===========================================*/
	2, -7.800500, 74.149750,
	8, -7.142000, 73.525002, -6.444500, 72.784752, -6.555000, 71.856750,
	8, -6.584000, 71.612747, -7.027750, 71.744499, -7.074500, 71.956001,
	8, -7.275000, 72.862251, -7.784750, 73.527496, -8.426750, 74.125504,
	8, -8.975750, 74.637253, -9.441250, 76.223251, -9.500000, 76.350250,
	8, -8.575750, 75.036247, -8.011500, 74.349747, -7.800500, 74.149750,
/* path_data219 ===========================================*/
	2, -11.194000, 72.658752,
	8, -11.063250, 72.566254, -11.138750, 72.443497, -11.084500, 72.360497,
	8, -10.846250, 71.996002, -10.521000, 71.684502, -10.516500, 71.250000,
	8, -10.515750, 71.180748, -10.610250, 71.103500, -10.694000, 71.159500,
	8, -10.763250, 71.205498, -10.848750, 71.237999, -10.875750, 71.270500,
	8, -11.383250, 71.882751, -11.733250, 72.550499, -12.094000, 73.253502,
	8, -12.139750, 73.342751, -12.425750, 74.465500, -12.347500, 74.493248,
	8, -12.287750, 74.514503, -11.857750, 73.469254, -11.805250, 73.440750,
	8, -11.489500, 73.269249, -11.486500, 72.865501, -11.194000, 72.658752,
/* path_data220 ===========================================*/
	2, -7.010750, 77.544746,
	8, -6.899750, 77.327499, -6.505750, 77.027000, -6.534000, 76.804749,
	8, -6.563500, 76.572746, -6.446500, 76.211998, -6.674500, 76.384003,
	8, -6.988750, 76.621002, -7.851000, 76.958252, -7.918500, 78.410248,
	8, -7.925000, 78.553001, -7.181500, 77.879753, -7.010750, 77.544746,
/* path_data221 ===========================================*/
	2, -3.400000, 73.250252,
	8, -3.300000, 73.083252, -3.123000, 73.201500, -3.008250, 73.135750,
	8, -2.846250, 73.042747, -2.693500, 72.903252, -2.620500, 72.740997,
	8, -2.378000, 72.203751, -1.935750, 71.748749, -1.900000, 71.150253,
	8, -2.272750, 70.799004, -2.442500, 71.308998, -2.600000, 71.550247,
	8, -2.930750, 71.138496, -3.180500, 71.607002, -3.505500, 71.736748,
	8, -3.523000, 71.743752, -3.576250, 71.656998, -3.595000, 71.663750,
	8, -3.889250, 71.773750, -4.059250, 72.043999, -4.308750, 72.239250,
	8, -4.351500, 72.272751, -4.452750, 72.227753, -4.489500, 72.261749,
	8, -4.652500, 72.412498, -4.895750, 72.493752, -4.965750, 72.664253,
	8, -5.243250, 73.341003, -6.028250, 73.864754, -6.500000, 75.750252,
	8, -6.404750, 75.977501, -5.372000, 74.089752, -5.250250, 73.915253,
	8, -5.041250, 73.616249, -5.011750, 74.330498, -4.692750, 74.164001,
	8, -4.680000, 74.157249, -4.633500, 74.216751, -4.600000, 74.250252,
	8, -4.551500, 74.180252, -4.497000, 74.123001, -4.400000, 74.150253,
	8, -4.400000, 74.050247, -4.433500, 73.911247, -4.383250, 73.871498,
	8, -4.074000, 73.627251, -4.095000, 73.360252, -3.900000, 73.050247,
	8, -3.785500, 73.247498, -3.520250, 73.067749, -3.400000, 73.250252,
/* path_data222 ===========================================*/
	2, 11.550000, 86.850250,
	8, 11.550000, 86.850250, 13.400000, 81.750252, 12.300000, 78.950249,
	8, 12.300000, 78.950249, 15.150000, 84.350250, 14.000000, 87.150253,
	8, 14.000000, 87.150253, 13.900000, 84.550247, 12.900000, 83.300247,
	8, 12.900000, 83.300247, 11.900000, 86.500252, 11.550000, 86.850250,
/* path_data223 ===========================================*/
	2, 7.850000, 86.200249,
	8, 7.850000, 86.200249, 9.200000, 84.000252, 7.200000, 79.400253,
	8, 7.200000, 79.400253, 7.000000, 84.500252, 5.300000, 87.250252,
	8, 5.300000, 87.250252, 8.850000, 82.200249, 7.850000, 86.200249,
/* path_data224 ===========================================*/
	2, 5.350000, 85.700249,
	8, 5.350000, 85.700249, 5.300000, 80.700249, 5.400000, 79.950249,
	8, 5.400000, 79.950249, 4.450000, 84.100250, 1.900000, 86.500252,
	8, 1.900000, 86.500252, 5.500000, 83.500252, 5.350000, 85.700249,
/* path_data225 ===========================================*/
	2, 2.950000, 77.700249,
	8, 2.950000, 77.700249, 4.450000, 81.100250, 1.950000, 85.700249,
	8, 1.950000, 85.700249, 3.550000, 82.650253, 2.350000, 80.900253,
	8, 2.350000, 80.900253, 3.000000, 80.050247, 2.950000, 77.700249,
	0
};

/* path_data226 ===========================================*/
signed char path_data226[] = {
	2, -1.850000, 85.600250,
	8, -1.850000, 85.600250, -2.100000, 81.700249, -1.650000, 81.150253,
	8, -1.650000, 81.150253, -1.600000, 79.550247, -1.700000, 79.300247,
	8, -1.700000, 79.300247, -0.700000, 77.750252, -0.650000, 79.600250,
	8, -0.650000, 79.600250, -0.300000, 81.550247, 0.400000, 82.700249,
	8, 0.400000, 82.700249, 1.300000, 84.050247, 1.250000, 85.650253,
	8, 1.250000, 85.650253, -1.250000, 78.100250, -1.850000, 85.600250,
/* path_data227 ===========================================*/
	2, -2.750000, 78.700249,
	8, -2.750000, 78.700249, -4.400000, 81.400253, -4.850000, 86.150253,
	8, -4.850000, 86.150253, -5.200000, 84.600250, -4.250000, 81.000252,
	8, -4.250000, 81.000252, -3.200000, 77.150253, -2.750000, 78.700249,
/* path_data228 ===========================================*/
	2, -8.200000, 83.650253,
	8, -8.200000, 83.650253, -6.950000, 82.300247, -6.600000, 81.050247,
	8, -6.600000, 81.050247, -5.700000, 77.100250, -7.300000, 79.250252,
	8, -7.300000, 79.250252, -7.250000, 81.250252, -9.300000, 83.100250,
	8, -9.300000, 83.100250, -8.100000, 82.500252, -8.200000, 83.650253,
/* path_data229 ===========================================*/
	2, -9.650000, 82.400253,
	8, -9.650000, 82.400253, -8.800000, 78.050247, -8.600000, 77.850250,
	8, -8.600000, 77.850250, -8.150000, 77.000252, -8.850000, 77.800247,
	8, -8.850000, 77.800247, -11.050000, 82.600250, -12.050000, 84.250252,
	8, -12.050000, 84.250252, -10.050000, 81.950249, -9.650000, 82.400253,
/* path_data230 ===========================================*/
	2, -11.100000, 78.250252,
	8, -11.100000, 78.250252, -8.200000, 72.650253, -13.650000, 79.100250,
	8, -13.650000, 79.100250, -10.900000, 76.650253, -11.100000, 78.250252,
/* path_data231 ===========================================*/
	2, -14.950000, 74.600250,
	8, -14.950000, 74.600250, -13.750000, 69.900253, -13.100000, 69.950249,
	8, -13.100000, 69.950249, -11.050000, 67.700249, -12.700000, 70.350250,
	8, -12.700000, 70.350250, -14.200000, 72.750252, -14.050000, 75.200249,
	8, -14.050000, 75.200249, -14.200000, 72.800247, -14.950000, 74.600250,
/* path_data232 ===========================================*/
	2, 67.625000, 71.750000,
	8, 67.625000, 71.750000, 64.625000, 69.250000, 64.000000, 68.375000,
	8, 64.000000, 68.375000, 67.375000, 73.000000, 67.375000, 74.750000,
	8, 67.375000, 74.750000, 68.000000, 72.875000, 67.625000, 71.750000,
/* path_data233 ===========================================*/
	2, 69.000000, 66.250000,
	8, 69.000000, 66.250000, 63.750000, 62.500000, 62.875000, 60.625000,
	8, 62.875000, 60.625000, 69.500000, 68.000000, 69.500000, 69.125000,
	8, 69.500000, 69.125000, 69.625000, 66.875000, 69.000000, 66.250000,
/* path_data234 ===========================================*/
	2, 73.250000, 27.750000,
	8, 73.250000, 27.750000, 70.250000, 25.750000, 69.875000, 26.250000,
	8, 69.875000, 26.250000, 72.500000, 27.875000, 73.125000, 30.000000,
	8, 73.125000, 30.000000, 72.750000, 27.750000, 73.250000, 27.750000,
/* path_data235 ===========================================*/
	2, 75.375000, 47.875000,
	4, 71.000000, 44.875000,
	8, 71.000000, 44.875000, 75.750000, 49.125000, 75.875000, 50.125000,
	4, 75.375000, 47.875000,
	0
};

/* path_data236 ===========================================*/
signed char path_data236[] = {
	2, -22.312500, 42.250000,
	4, -16.812500, 43.437500,
/* path_data237 ===========================================*/
	2, -9.750000, 82.750000,
	8, -9.750000, 82.750000, -9.875000, 81.875000, -12.125000, 84.500000,
/* path_data238 ===========================================*/
	2, -8.375000, 84.000000,
	8, -8.375000, 84.000000, -7.875000, 82.375000, -9.500000, 83.500000,
/* path_data239 ===========================================*/
	2, 5.125000, 86.125000,
	8, 5.125000, 86.125000, 5.500000, 83.375000, 2.625000, 86.625000,
	0
};

int pathCount = 131;

vg_lite_path_t path[131] = {
	{
		{-80, -40, 80, 90},	/* left, top, right,bottom */
		VG_LITE_HIGH,		/* quality */
		VG_LITE_S8,		/* -128 to 127 coordinate range */
		{0},			/* uploaded */
		sizeof(path_data0),	/* path length */
		path_data0,		/* path data */
		1		/* initially, path is changed for uploaded*/
	},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data8), path_data8, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data12), path_data12, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data13), path_data13, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data14), path_data14, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data15), path_data15, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data16), path_data16, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data17), path_data17, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data18), path_data18, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data19), path_data19, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data20), path_data20, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data21), path_data21, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data22), path_data22, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data23), path_data23, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data24), path_data24, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data25), path_data25, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data26), path_data26, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data27), path_data27, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data28), path_data28, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data29), path_data29, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data35), path_data35, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data36), path_data36, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data37), path_data37, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data38), path_data38, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data39), path_data39, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data40), path_data40, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data41), path_data41, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data42), path_data42, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data43), path_data43, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data44), path_data44, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data45), path_data45, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data46), path_data46, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data47), path_data47, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data48), path_data48, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data49), path_data49, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data51), path_data51, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data52), path_data52, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data54), path_data54, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data55), path_data55, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data56), path_data56, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data57), path_data57, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data58), path_data58, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data59), path_data59, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data60), path_data60, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data61), path_data61, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data62), path_data62, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data63), path_data63, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data64), path_data64, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data65), path_data65, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data66), path_data66, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data67), path_data67, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data68), path_data68, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data69), path_data69, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data70), path_data70, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data71), path_data71, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data72), path_data72, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data73), path_data73, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data74), path_data74, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data75), path_data75, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data76), path_data76, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data77), path_data77, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data78), path_data78, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data79), path_data79, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data80), path_data80, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data81), path_data81, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data82), path_data82, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data83), path_data83, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data84), path_data84, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data85), path_data85, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data86), path_data86, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data87), path_data87, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data89), path_data89, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data90), path_data90, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data91), path_data91, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data92), path_data92, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data93), path_data93, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data94), path_data94, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data95), path_data95, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data96), path_data96, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data101), path_data101, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data103), path_data103, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data109), path_data109, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data111), path_data111, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data112), path_data112, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data113), path_data113, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data115), path_data115, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data116), path_data116, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data117), path_data117, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data118), path_data118, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data121), path_data121, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data122), path_data122, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data123), path_data123, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data124), path_data124, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data125), path_data125, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data126), path_data126, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data127), path_data127, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data131), path_data131, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data132), path_data132, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data135), path_data135, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data137), path_data137, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data138), path_data138, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data139), path_data139, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data140), path_data140, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data150), path_data150, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data157), path_data157, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data159), path_data159, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data160), path_data160, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data161), path_data161, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data162), path_data162, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data163), path_data163, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data164), path_data164, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data165), path_data165, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data166), path_data166, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data167), path_data167, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data168), path_data168, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data169), path_data169, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data170), path_data170, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data171), path_data171, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data172), path_data172, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data175), path_data175, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data181), path_data181, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data182), path_data182, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data183), path_data183, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data193), path_data193, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data194), path_data194, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data196), path_data196, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data203), path_data203, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data208), path_data208, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data214), path_data214, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data226), path_data226, 1},
	{{-80, -40, 80, 90}, VG_LITE_HIGH, VG_LITE_S8, {0},
	sizeof(path_data236), path_data236, 1}
};

uint32_t color_data[] = {
	/* path_data0 */   0xffffffff,
	/* path_data8 */   0xffffffff,
	/* path_data12 */  0xffffffff,
	/* path_data13 */  0xff2672cc,
	/* path_data14 */  0xff2672cc,
	/* path_data15 */  0xff3a7ee8,
	/* path_data16 */  0xff4d8ce9,
	/* path_data17 */  0xff6099eb,
	/* path_data18 */  0xff75a5ed,
	/* path_data19 */  0xff87b1f0,
	/* path_data20 */  0xff9cbff2,
	/* path_data21 */  0xffafccf4,
	/* path_data22 */  0xffc3d8f8,
	/* path_data23 */  0xffd6e4f9,
	/* path_data24 */  0xffebf2fb,
	/* path_data25 */  0xffffffff,
	/* path_data26 */  0xff000000,
	/* path_data27 */  0xffcccccc,
	/* path_data28 */  0xff000000,
	/* path_data29 */  0xffcccccc,
	/* path_data35 */  0xff000000,
	/* path_data36 */  0xff8c66e4,
	/* path_data37 */  0xff5931b1,
	/* path_data38 */  0xff4b26a5,
	/* path_data39 */  0xff7e72ff,
	/* path_data40 */  0xffccffff,
	/* path_data41 */  0xff4b3fcc,
	/* path_data42 */  0xff000000,
	/* path_data43 */  0xffccffff,
	/* path_data44 */  0xffccffff,
	/* path_data45 */  0xffccffff,
	/* path_data46 */  0xffccffff,
	/* path_data47 */  0xffccffff,
	/* path_data48 */  0xffccffff,
	/* path_data49 */  0xff000000,
	/* path_data51 */  0xffccffff,
	/* path_data52 */  0xff000000,
	/* path_data54 */  0xffb1b1b1,
	/* path_data55 */  0xffccffff,
	/* path_data56 */  0xffccffff,
	/* path_data57 */  0xffccffff,
	/* path_data58 */  0xff000000,
	/* path_data59 */  0xffccffff,
	/* path_data60 */  0xffccffff,
	/* path_data61 */  0xffccffff,
	/* path_data62 */  0xffccffff,
	/* path_data63 */  0xffccffff,
	/* path_data64 */  0xffb1e4e4,
	/* path_data65 */  0xffb1e4e4,
	/* path_data66 */  0xff2672cc,
	/* path_data67 */  0xff508ee9,
	/* path_data68 */  0xff7caaef,
	/* path_data69 */  0xffa8c6f4,
	/* path_data70 */  0xffd3e2f9,
	/* path_data71 */  0xffffffff,
	/* path_data72 */  0xffcccccc,
	/* path_data73 */  0xff000000,
	/* path_data74 */  0xff31cc99,
	/* path_data75 */  0xff009964,
	/* path_data76 */  0xffffffff,
	/* path_data77 */  0xff000000,
	/* path_data78 */  0xff2672cc,
	/* path_data79 */  0xffffffff,
	/* path_data80 */  0xff5b95eb,
	/* path_data81 */  0xff91b8f2,
	/* path_data82 */  0xffc8dbf8,
	/* path_data83 */  0xffffffff,
	/* path_data84 */  0xffcccccc,
	/* path_data85 */  0xff000000,
	/* path_data86 */  0xff31cc99,
	/* path_data87 */  0xff000000,
	/* path_data89 */  0xff000000,
	/* path_data90 */  0xff313131,
	/* path_data91 */  0xff666666,
	/* path_data92 */  0xff999999,
	/* path_data93 */  0xffcccccc,
	/* path_data94 */  0xffffffff,
	/* path_data95 */  0xff002699,
	/* path_data96 */  0xffcccccc,
	/* path_data101 */ 0xff000000,
	/* path_data103 */ 0xff2672cc,
	/* path_data109 */ 0xff000000,
	/* path_data111 */ 0xff000000,
	/* path_data112 */ 0xff000000,
	/* path_data113 */ 0xff000000,
	/* path_data115 */ 0xff00004b,
	/* path_data116 */ 0xff31cc99,
	/* path_data117 */ 0xff009964,
	/* path_data118 */ 0xff000000,
	/* path_data121 */ 0xff9999e4,
	/* path_data122 */ 0xff6464b1,
	/* path_data123 */ 0xff002699,
	/* path_data124 */ 0xffffffff,
	/* path_data125 */ 0xff002699,
	/* path_data126 */ 0xff000000,
	/* path_data127 */ 0xff000000,
	/* path_data131 */ 0xff000000,
	/* path_data132 */ 0xff000000,
	/* path_data135 */ 0xffffffff,
	/* path_data137 */ 0xffcccccc,
	/* path_data138 */ 0xff000000,
	/* path_data139 */ 0xffcccccc,
	/* path_data140 */ 0xff000000,
	/* path_data150 */ 0xff000000,
	/* path_data157 */ 0xff002699,
	/* path_data159 */ 0xffcccccc,
	/* path_data160 */ 0xff000000,
	/* path_data161 */ 0xff000000,
	/* path_data162 */ 0xffffffff,
	/* path_data163 */ 0xffffffff,
	/* path_data164 */ 0xffffffff,
	/* path_data165 */ 0xffffffff,
	/* path_data166 */ 0xffffffff,
	/* path_data167 */ 0xffffffff,
	/* path_data168 */ 0xffffffff,
	/* path_data169 */ 0xffffffff,
	/* path_data170 */ 0xffcccccc,
	/* path_data171 */ 0xff000000,
	/* path_data172 */ 0xff000000,
	/* path_data175 */ 0xff000000,
	/* path_data181 */ 0xffffffff,
	/* path_data182 */ 0xff000000,
	/* path_data183 */ 0xffffffff,
	/* path_data193 */ 0xffffffff,
	/* path_data194 */ 0xffffffff,
	/* path_data196 */ 0xffffffff,
	/* path_data203 */ 0xffffffff,
	/* path_data208 */ 0xff000000,
	/* path_data214 */ 0xffcccccc,
	/* path_data226 */ 0xffcccccc,
	/* path_data236 */ 0xff000000
};

#endif	/* __TIGER_PATHS_H__ */
