/**************************************************************************
MODULE:    USER_OD - Here: STANDARD USAGE OF GENERATED OD TABLES
CONTAINS:  MicroCANopen Object Dictionary and Process Image implementation
COPYRIGHT: (c) Embedded Systems Academy (EmSA) 2002-2020
           All rights reserved. www.em-sa.com/nxp
DISCLAIM:  Read and understand our disclaimer before using this code!
           www.esacademy.com/disclaim.htm
           This software was written in accordance to the guidelines at
           www.esacademy.com/software/softwarestyleguide.pdf
LICENSE:   THIS IS THE NXP SDK VERSION OF MICROCANOPEN PLUS
           Licensed under a modified BSD License. See LICENSE.INFO
           file in the project root for full license information.
VERSION:   7.10, ESA 20-SEP-02
           $LastChangedDate: 2020-09-03 22:04:52 +0200 (Thu, 03 Sep 2020) $
           $LastChangedRevision: 5038 $
***************************************************************************/

#include "mcop_inc.h"

#include "entriesandreplies.h"

// The following lines fix different sizes of entries
// auto-generated by CANopenArchitect EDS
#ifndef PIMGDEFAULTS2
#define PIMGDEFAULTS2
#endif
#ifndef PIMGDEFAULTS3
#define PIMGDEFAULTS3
#endif
#ifndef PIMGDEFAULTS4
#define PIMGDEFAULTS4
#endif
#ifndef SDOREPLY_ENTRIES2
#define SDOREPLY_ENTRIES2
#endif
#ifndef SDOREPLY_ENTRIES3
#define SDOREPLY_ENTRIES3
#endif
#ifndef SDOREPLY_ENTRIES4
#define SDOREPLY_ENTRIES4
#endif
#ifndef ODENTRY_ENTRIES2
#define ODENTRY_ENTRIES2
#endif
#ifndef ODENTRY_ENTRIES3
#define ODENTRY_ENTRIES3
#endif
#ifndef ODENTRY_ENTRIES4
#define ODENTRY_ENTRIES4
#endif

/**************************************************************************
GLOBAL VARIABLES
***************************************************************************/

uint8_t MEM_PROC gProcImg[PROCIMG_SIZE] = PIMGDEFAULTS PIMGDEFAULTS2 PIMGDEFAULTS3 PIMGDEFAULTS4;

// Table with SDO Responses for read requests to OD
uint8_t MEM_CONST gSDOResponseTable[] = {
    // Each Row has 8 Bytes:
    // Command Specifier for SDO Response (1 byte)
    //   bits 2+3 contain: '4' – {number of data bytes}
    // Object Dictionary Index (2 bytes, low first)
    // Object Dictionary Subindex (1 byte)
    // Data (4 bytes, lowest bytes first)

    // Include file generated by CANopen Architect
    SDOREPLY_ENTRIES SDOREPLY_ENTRIES2 SDOREPLY_ENTRIES3 SDOREPLY_ENTRIES4

    // End-of-table marker
    0xFF,
    0xFF,
    0xFF,
    0xFF,
    0xFF,
    0xFF,
    0xFF,
    0xFF};

// Table with Object Dictionary entries to process Data
OD_PROCESS_DATA_ENTRY MEM_CONST gODProcTable[] = {
    // Include automatically generated files from CANopenArchitect EDS
    ODENTRY_ENTRIES ODENTRY_ENTRIES2 ODENTRY_ENTRIES3 ODENTRY_ENTRIES4

#if defined(P100001_Device_Type_1)
        // Special entry to deliver CANopen-style object [1000h,0]
        ODENTRY(0x1000, 0x00, 4 + ODRD, P100001_Device_Type_1),
#endif

    // End-of-table marker
    ODENTRY(0xFFFF, 0xFF, 0xFF, 0xFF)};

#if USE_EXTENDED_SDO
// Table with generic entries to memory
OD_GENERIC_DATA_ENTRY MEM_CONST gODGenericTable[] = {ODGENTRY_ENTRIES

                                                         ODGENTRYP(0xFFFF, 0xFF, 0xFF, 0xFFFF, 0xFFFF)};
#endif // USE_EXTENDED_SDO

// Extended tables for CANopen FD

#if defined(USE_CANOPEN_FD) && USE_CANOPEN_FD

#if !defined(OD_ID_LIST) || !defined(OD_ID_TYPE) || !defined(OD_ID_TABLELOCATION)
#error Extended OD information is missing - CANopen Architect version 5.90 or higher required
#endif

MEM_CONST uint32_t gODIDList[] = {OD_ID_LIST
#if defined(OD_ID_LIST2)
                                      OD_ID_LIST2
#endif
#if defined(OD_ID_LIST3)
                                          OD_ID_LIST3
#endif
#if defined(OD_ID_LIST4)
#error Did not expect so many OD entries, add all "OD_ID_LISTn" initializers here
#endif
};
const int gSizeofgODIDList = sizeof(gODIDList) / sizeof(uint32_t);

MEM_CONST uint8_t gODIDType[] = {OD_ID_TYPE
#if defined(OD_ID_TYPE2)
                                     OD_ID_TYPE2
#endif
#if defined(OD_ID_TYPE3)
                                         OD_ID_TYPE3
#endif
#if defined(OD_ID_TYPE4)
#error Did not expect so many OD entries, add all "OD_ID_TYPEn" initializers here
#endif
};

MEM_CONST ODLocationType gODIDLocation[] = {OD_ID_TABLELOCATION
#if defined(OD_ID_TABLELOCATION2)
                                                OD_ID_TABLELOCATION2
#endif
#if defined(OD_ID_TABLELOCATION3)
                                                    OD_ID_TABLELOCATION3
#endif
#if defined(OD_ID_TABLELOCATION4)
#error Did not expect so many OD entries, add all "OD_ID_TABLELOCATIONn" initializers here
#endif
};

#endif // USE_CANOPEN_FD

/**************************************************************************
END-OF-FILE
***************************************************************************/
