/*
 * Copyright 2021 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

/***********************************************************************************************************************
 * This file was generated by the MCUXpresso Config Tools. Any manual edits made to this file
 * will be overwritten if the respective MCUXpresso Config Tools is used to update this file.
 **********************************************************************************************************************/

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
!!GlobalInfo
product: Pins v13.0
processor: LPC55S36
package_id: LPC55S36JBD100
mcu_data: ksdk2_0
processor_version: 0.13.3
board: LPCXpresso55S36
pin_labels:
- {pin_num: '4', pin_signal: PIO1_7/FC0_RTS_SCL_SSEL1/CTIMER2_MAT2/SCT_GPI4/AOI1_OUT3/ADC1_3B, label: CUR_C}
- {pin_num: '7', pin_signal: ADC1IN1B, label: VOLT_DCB}
- {pin_num: '9', pin_signal: PIO0_11/FC6_RXD_SDA_MOSI_DATA/CTIMER2_MAT2/FREQME_GPIO_CLK_A/SECURE_GPIO0_11/AOI1_OUT2/ADC1_2A, label: CUR_B}
- {pin_num: '10', pin_signal: PIO0_12/FC3_TXD_SCL_MISO_WS/FREQME_GPIO_CLK_B/SCT_GPI7/FC6_TXD_SCL_MISO_WS/SECURE_GPIO0_12/AOI1_OUT1/ADC1_3A, label: CUR_A}
- {pin_num: '19', pin_signal: PIO0_23/MCLK/CTIMER1_MAT2/CTIMER3_MAT3/SCT0_OUT4/FC0_CTS_SDA_SSEL0/SECURE_GPIO0_23/ADC0_8B, label: CUR_B}
- {pin_num: '20', pin_signal: PIO0_16/FC4_TXD_SCL_MISO_WS/CLKOUT/CT_INP4/SECURE_GPIO0_16/AOI0_OUT3/ADC0_3B, label: CUR_C}
- {pin_num: '21', pin_signal: PIO0_10/FC6_SCK/CT_INP10/CTIMER2_MAT0/FC1_TXD_SCL_MISO_WS/SCT0_OUT2/SECURE_GPIO0_10/ADC0_1A, label: VOLT_DCB}
- {pin_num: '22', pin_signal: PIO0_15/FC6_CTS_SDA_SSEL0/UTICK_CAP2/CT_INP16/SCT0_OUT2/SECURE_GPIO0_15/ADC0_3A, label: CUR_A}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

#include "fsl_common.h"
#include "fsl_gpio.h"
#include "fsl_inputmux.h"
#include "pin_mux.h"

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitBootPins
 * Description   : Calls initialization functions.
 *
 * END ****************************************************************************************************************/
void BOARD_InitBootPins(void)
{
    BOARD_InitUSART();
    BOARD_InitGPIO();
    BOARD_InitPWM0();
    BOARD_InitADC0();
    BOARD_InitHSCMP0();
    BOARD_InitENC0();
    BOARD_InitHSCMP1();
    BOARD_InitHSCMP2();
}

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_InitUSART:
- options: {callFromInitBoot: 'true', coreID: cm33_core0, enableClock: 'true'}
- pin_list:
  - {pin_num: '95', peripheral: FLEXCOMM0, signal: TXD_SCL_MISO_WS, pin_signal: PIO0_30/FC0_TXD_SCL_MISO_WS/CTIMER0_MAT0/SCT0_OUT9/TRACEDATA1/CAN0_TD/FC6_TXD_SCL_MISO_WS/SECURE_GPIO0_30/PWM1_A1/AOI1_OUT0}
  - {pin_num: '93', peripheral: FLEXCOMM0, signal: RXD_SDA_MOSI_DATA, pin_signal: PIO0_29/FC0_RXD_SDA_MOSI_DATA/CTIMER2_MAT3/SCT0_OUT8/TRACEDATA2/FC6_RXD_SDA_MOSI_DATA/CMP0_OUT/SECURE_GPIO0_29/PWM0_A1/SPI_DIN/EXTTRIG_IN3}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitUSART
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
/* Function assigned for the Cortex-M33 */
void BOARD_InitUSART(void)
{
    /* Enables the clock for the I/O controller.: Enable Clock. */
    CLOCK_EnableClock(kCLOCK_Iocon);

    IOCON->PIO[0][29] = ((IOCON->PIO[0][29] &
                          /* Mask bits to zero which are setting */
                          (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_DIGIMODE_MASK)))

                         /* Signal(function) select: PORT029 (pin 93) is configured as FC0_RXD_SDA_MOSI_DATA. */
                         | IOCON_PIO_FUNC(0x01u)

                         /* Select Digital mode: Enable Digital mode.
                          * Digital input is enabled. */
                         | IOCON_PIO_DIGIMODE(PIO0_29_DIGIMODE_DIGITAL));

    IOCON->PIO[0][30] = ((IOCON->PIO[0][30] &
                          /* Mask bits to zero which are setting */
                          (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_DIGIMODE_MASK)))

                         /* Signal(function) select: PORT030 (pin 95) is configured as FC0_TXD_SCL_MISO_WS. */
                         | IOCON_PIO_FUNC(0x01u)

                         /* Select Digital mode: Enable Digital mode.
                          * Digital input is enabled. */
                         | IOCON_PIO_DIGIMODE(PIO0_30_DIGIMODE_DIGITAL));
}

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_InitGPIO:
- options: {callFromInitBoot: 'true', coreID: cm33_core0, enableClock: 'true'}
- pin_list:
  - {pin_num: '72', peripheral: GPIO, signal: 'PIO1, 28', pin_signal: PIO1_28/FC7_SCK/CT_INP2/TRIGOUT_4/PWM1_X3/SPI_CS1_DIS/HSCMP1_OUT, direction: OUTPUT}
  - {pin_num: '78', peripheral: GPIO, signal: 'PIO0, 22', pin_signal: PIO0_22/FC6_TXD_SCL_MISO_WS/UTICK_CAP1/CT_INP15/SCT0_OUT3/FLEXSPI0_SCLK_N/FLEXSPI0_SS1_N/USB0_VBUS/FC7_RTS_SCL_SSEL1/SECURE_GPIO0_22/PWM1_X0/EXTTRIG_IN5,
    direction: OUTPUT}
  - {pin_num: '41', peripheral: PINT, signal: 'PINT, 0', pin_signal: PIO0_17/FC4_SSEL2/SCT_GPI7/SCT0_OUT0/FC5_RXD_SDA_MOSI_DATA/QSPI_SCLK/SECURE_GPIO0_17/TRIGOUT_7/HSCMP1_OUT/HSCMP2_IN0,
    identifier: SW3}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitGPIO
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
/* Function assigned for the Cortex-M33 */
void BOARD_InitGPIO(void)
{
    /* Enables the clock for the Input Mux.: Enable Clock. */
    CLOCK_EnableClock(kCLOCK_InputMux);
    /* Enables the clock for the I/O controller.: Enable Clock. */
    CLOCK_EnableClock(kCLOCK_Iocon);

    /* Enables the clock for the GPIO0 module */
    CLOCK_EnableClock(kCLOCK_Gpio0);

    /* Enables the clock for the GPIO1 module */
    CLOCK_EnableClock(kCLOCK_Gpio1);

    gpio_pin_config_t LED_GREEN_config = {
        .pinDirection = kGPIO_DigitalOutput,
        .outputLogic = 0U
    };
    /* Initialize GPIO functionality on pin PIO0_22 (pin 78)  */
    GPIO_PinInit(BOARD_INITGPIO_LED_GREEN_GPIO, BOARD_INITGPIO_LED_GREEN_PORT, BOARD_INITGPIO_LED_GREEN_PIN, &LED_GREEN_config);

    gpio_pin_config_t LED_RED_config = {
        .pinDirection = kGPIO_DigitalOutput,
        .outputLogic = 0U
    };
    /* Initialize GPIO functionality on pin PIO1_28 (pin 72)  */
    GPIO_PinInit(BOARD_INITGPIO_LED_RED_GPIO, BOARD_INITGPIO_LED_RED_PORT, BOARD_INITGPIO_LED_RED_PIN, &LED_RED_config);
    /* PIO0_17 is selected for PINT input 0 */
    INPUTMUX_AttachSignal(INPUTMUX, 0U, kINPUTMUX_GpioPort0Pin17ToPintsel);

    IOCON->PIO[0][17] = ((IOCON->PIO[0][17] &
                          /* Mask bits to zero which are setting */
                          (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_DIGIMODE_MASK)))

                         /* Signal(function) select: PORT017 (pin 41) is configured as PIO0_17. */
                         | IOCON_PIO_FUNC(0x00u)

                         /* Select Digital mode: Enable Digital mode.
                          * Digital input is enabled. */
                         | IOCON_PIO_DIGIMODE(PIO0_17_DIGIMODE_DIGITAL));

    IOCON->PIO[0][22] = ((IOCON->PIO[0][22] &
                          /* Mask bits to zero which are setting */
                          (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_DIGIMODE_MASK)))

                         /* Signal(function) select: PORT022 (pin 78) is configured as PIO0_22. */
                         | IOCON_PIO_FUNC(0x00u)

                         /* Select Digital mode: Enable Digital mode.
                          * Digital input is enabled. */
                         | IOCON_PIO_DIGIMODE(PIO0_22_DIGIMODE_DIGITAL));

    IOCON->PIO[1][28] = ((IOCON->PIO[1][28] &
                          /* Mask bits to zero which are setting */
                          (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_DIGIMODE_MASK)))

                         /* Signal(function) select: PORT128 (pin 72) is configured as PIO1_28. */
                         | IOCON_PIO_FUNC(0x00u)

                         /* Select Digital mode: Enable Digital mode.
                          * Digital input is enabled. */
                         | IOCON_PIO_DIGIMODE(PIO1_28_DIGIMODE_DIGITAL));
}

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_InitPWM0:
- options: {callFromInitBoot: 'true', coreID: cm33_core0, enableClock: 'true'}
- pin_list:
  - {pin_num: '11', peripheral: PWM0, signal: 'A, 0', pin_signal: PIO1_20/FC7_RTS_SCL_SSEL1/CT_INP14/FC4_TXD_SCL_MISO_WS/PWM0_A0/AOI0_OUT1/ADC1_8A}
  - {pin_num: '50', peripheral: PWM0, signal: 'A, 1', pin_signal: PIO1_6/FC0_TXD_SCL_MISO_WS/CTIMER2_MAT1/SCT_GPI3/PWM0_A1/TRIGOUT_5/HSCMP0_OUT}
  - {pin_num: '91', peripheral: PWM0, signal: 'B, 0', pin_signal: PIO1_17/FC6_RTS_SCL_SSEL1/SCT0_OUT4/PWM0_B0/AOI1_OUT3}
  - {pin_num: '75', peripheral: PWM0, signal: 'B, 2', pin_signal: PIO1_4/FC0_SCK/CTIMER2_MAT1/SCT0_OUT0/FREQME_GPIO_CLK_A/FC4_TXD_SCL_MISO_WS/SPI_DIN/PWM0_B2/TRIGOUT_7/EXTTRIG_IN8}
  - {pin_num: '40', peripheral: PWM0, signal: 'B, 1', pin_signal: PIO1_22/CTIMER2_MAT3/SCT_GPI5/FC4_SSEL3/CAN0_RD/QSPI_DIN3/PWM0_B1/TRIGOUT_2/HSCMP1_IN1/DAC0_OUT}
  - {pin_num: '36', peripheral: PWM0, signal: 'A, 2', pin_signal: PIO1_8/FC0_CTS_SDA_SSEL0/SCT0_OUT1/FC4_SSEL2/FC1_SCK/PWM0_A2/AOI1_OUT2/TRIGOUT_6}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitPWM0
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
/* Function assigned for the Cortex-M33 */
void BOARD_InitPWM0(void)
{
    /* Enables the clock for the I/O controller.: Enable Clock. */
    CLOCK_EnableClock(kCLOCK_Iocon);

    IOCON->PIO[1][17] = ((IOCON->PIO[1][17] &
                          /* Mask bits to zero which are setting */
                          (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_DIGIMODE_MASK)))

                         /* Signal(function) select: PORT117 (pin 91) is configured as PWM0_B0. */
                         | IOCON_PIO_FUNC(0x0Bu)

                         /* Select Digital mode: Enable Digital mode.
                          * Digital input is enabled. */
                         | IOCON_PIO_DIGIMODE(PIO1_17_DIGIMODE_DIGITAL));

    IOCON->PIO[1][20] = ((IOCON->PIO[1][20] &
                          /* Mask bits to zero which are setting */
                          (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_DIGIMODE_MASK)))

                         /* Signal(function) select: PORT120 (pin 11) is configured as PWM0_A0. */
                         | IOCON_PIO_FUNC(0x0Bu)

                         /* Select Digital mode: Enable Digital mode.
                          * Digital input is enabled. */
                         | IOCON_PIO_DIGIMODE(PIO1_20_DIGIMODE_DIGITAL));

    IOCON->PIO[1][22] = ((IOCON->PIO[1][22] &
                          /* Mask bits to zero which are setting */
                          (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_DIGIMODE_MASK)))

                         /* Signal(function) select: PORT122 (pin 40) is configured as PWM0_B1. */
                         | IOCON_PIO_FUNC(0x0Bu)

                         /* Select Digital mode: Enable Digital mode.
                          * Digital input is enabled. */
                         | IOCON_PIO_DIGIMODE(PIO1_22_DIGIMODE_DIGITAL));

    IOCON->PIO[1][4] = ((IOCON->PIO[1][4] &
                         /* Mask bits to zero which are setting */
                         (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_DIGIMODE_MASK)))

                        /* Signal(function) select: PORT14 (pin 75) is configured as PWM0_B2. */
                        | IOCON_PIO_FUNC(0x0Bu)

                        /* Select Digital mode: Enable Digital mode.
                         * Digital input is enabled. */
                        | IOCON_PIO_DIGIMODE(PIO1_4_DIGIMODE_DIGITAL));

    IOCON->PIO[1][6] = ((IOCON->PIO[1][6] &
                         /* Mask bits to zero which are setting */
                         (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_DIGIMODE_MASK)))

                        /* Signal(function) select: PORT16 (pin 50) is configured as PWM0_A1. */
                        | IOCON_PIO_FUNC(0x0Bu)

                        /* Select Digital mode: Enable Digital mode.
                         * Digital input is enabled. */
                        | IOCON_PIO_DIGIMODE(PIO1_6_DIGIMODE_DIGITAL));

    IOCON->PIO[1][8] = ((IOCON->PIO[1][8] &
                         /* Mask bits to zero which are setting */
                         (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_DIGIMODE_MASK)))

                        /* Signal(function) select: PORT18 (pin 36) is configured as PWM0_A2. */
                        | IOCON_PIO_FUNC(0x0Bu)

                        /* Select Digital mode: Enable Digital mode.
                         * Digital input is enabled. */
                        | IOCON_PIO_DIGIMODE(PIO1_8_DIGIMODE_DIGITAL));
}

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_InitADC0:
- options: {callFromInitBoot: 'true', coreID: cm33_core0, enableClock: 'true'}
- pin_list:
  - {pin_num: '21', peripheral: ADC0, signal: 'CH, 1A', pin_signal: PIO0_10/FC6_SCK/CT_INP10/CTIMER2_MAT0/FC1_TXD_SCL_MISO_WS/SCT0_OUT2/SECURE_GPIO0_10/ADC0_1A}
  - {peripheral: ADC0, signal: 'CH, 0B', pin_signal: Opamp1Out}
  - {peripheral: ADC0, signal: 'CH, 2A', pin_signal: Opamp2Out}
  - {peripheral: ADC0, signal: 'CH, 0A', pin_signal: Opamp0Out}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitADC0
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
/* Function assigned for the Cortex-M33 */
void BOARD_InitADC0(void)
{
    /* Enables the clock for the I/O controller.: Enable Clock. */
    CLOCK_EnableClock(kCLOCK_Iocon);

    /* Enables the clock for the GPIO0 module */
    CLOCK_EnableClock(kCLOCK_Gpio0);

    gpio_pin_config_t gpio0_pin21_config = {
        .pinDirection = kGPIO_DigitalInput,
        .outputLogic = 0U
    };
    /* Initialize GPIO functionality on pin PIO0_10 (pin 21)  */
    GPIO_PinInit(GPIO, 0U, 10U, &gpio0_pin21_config);

    IOCON->PIO[0][10] = ((IOCON->PIO[0][10] &
                          /* Mask bits to zero which are setting */
                          (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_DIGIMODE_MASK)))

                         /* Signal(function) select: PORT010 (pin 21) is configured as ADC0_1A. */
                         | IOCON_PIO_FUNC(0x00u)

                         /* Select Digital mode: Disable digital mode.
                          * Digital input set to 0. */
                         | IOCON_PIO_DIGIMODE(PIO0_10_DIGIMODE_ANALOG));
}

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_InitHSCMP0:
- options: {callFromInitBoot: 'true', coreID: cm33_core0, enableClock: 'true'}
- pin_list:
  - {pin_num: '25', peripheral: HSCMP0, signal: 'IN, 4', pin_signal: PIO1_9/FC1_SCK/CT_INP4/SCT0_OUT2/FC4_CTS_SDA_SSEL0/AOI1_OUT3/ADC0_0A/OPAMP0_OUT/HSCMP0_IN4}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitHSCMP0
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
/* Function assigned for the Cortex-M33 */
void BOARD_InitHSCMP0(void)
{
    /* Enables the clock for the I/O controller.: Enable Clock. */
    CLOCK_EnableClock(kCLOCK_Iocon);

    IOCON->PIO[1][9] = ((IOCON->PIO[1][9] &
                         /* Mask bits to zero which are setting */
                         (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_MODE_MASK | IOCON_PIO_DIGIMODE_MASK | IOCON_PIO_ASW0_MASK)))

                        /* Signal(function) select: PORT19 (pin 25) is configured as HSCMP0_IN4. */
                        | IOCON_PIO_FUNC(0x00u)

                        /* Mode select (on-chip pull-up/pull-down resistor control): Inactive.
                         * Inactive (no pull-down/pull-up resistor enabled). */
                        | IOCON_PIO_MODE(PIO1_9_MODE_INACTIVE)

                        /* Select Digital mode: Disable digital mode.
                         * Digital input set to 0. */
                        | IOCON_PIO_DIGIMODE(PIO1_9_DIGIMODE_ANALOG)

                        /* Analog switch input control: Analog switch is closed.
                         * (enable). */
                        | IOCON_PIO_ASW0(PIO1_9_ASW0_ENABLE));
}

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_InitENC0:
- options: {callFromInitBoot: 'true', coreID: cm33_core0, enableClock: 'true'}
- pin_list:
  - {pin_num: '70', peripheral: ENC0, signal: 'PHASE, A', pin_signal: PIO0_13/FC1_CTS_SDA_SSEL0/UTICK_CAP0/CT_INP0/SCT_GPI0/FC1_RXD_SDA_MOSI_DATA/SECURE_GPIO0_13/EXTTRIG_IN3}
  - {pin_num: '71', peripheral: ENC0, signal: 'PHASE, B', pin_signal: PIO0_14/FC1_RTS_SCL_SSEL1/UTICK_CAP1/CT_INP1/SCT_GPI1/FC1_TXD_SCL_MISO_WS/SECURE_GPIO0_14/EXTTRIG_IN2}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitENC0
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
/* Function assigned for the Cortex-M33 */
void BOARD_InitENC0(void)
{
    /* Enables the clock for the Input Mux.: Enable Clock. */
    CLOCK_EnableClock(kCLOCK_InputMux);
    /* Enables the clock for the I/O controller.: Enable Clock. */
    CLOCK_EnableClock(kCLOCK_Iocon);
    /* EXTTRIG_IN3 is selected as trigger input for ENC0 PHASEA channel 0 */
    INPUTMUX_AttachSignal(INPUTMUX, 0U, kINPUTMUX_ExtTrigIn3ToEnc0Phasea);
    /* EXTTRIG_IN2 is selected as trigger input for ENC0 PHASEB channel 0 */
    INPUTMUX_AttachSignal(INPUTMUX, 0U, kINPUTMUX_ExtTrigIn2ToEnc0Phaseb);

    IOCON->PIO[0][13] = ((IOCON->PIO[0][13] &
                          /* Mask bits to zero which are setting */
                          (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_DIGIMODE_MASK)))

                         /* Signal(function) select: PORT013 (pin 70) is configured as EXTTRIG_IN3. */
                         | IOCON_PIO_FUNC(0x0Du)

                         /* Select Digital mode: Enable Digital mode.
                          * Digital input is enabled. */
                         | IOCON_PIO_DIGIMODE(PIO0_13_DIGIMODE_DIGITAL));

    IOCON->PIO[0][14] = ((IOCON->PIO[0][14] &
                          /* Mask bits to zero which are setting */
                          (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_DIGIMODE_MASK)))

                         /* Signal(function) select: PORT014 (pin 71) is configured as EXTTRIG_IN2. */
                         | IOCON_PIO_FUNC(0x0Du)

                         /* Select Digital mode: Enable Digital mode.
                          * Digital input is enabled. */
                         | IOCON_PIO_DIGIMODE(PIO0_14_DIGIMODE_DIGITAL));
}

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_InitPWM1:
- options: {callFromInitBoot: 'false', coreID: cm33_core0, enableClock: 'true'}
- pin_list:
  - {pin_num: '37', peripheral: PWM1, signal: 'A, 0', pin_signal: PIO1_21/FC7_CTS_SDA_SSEL0/CTIMER3_MAT2/FC4_RXD_SDA_MOSI_DATA/PWM1_A0/TRIGOUT_1}
  - {pin_num: '84', peripheral: PWM1, signal: 'B, 0', pin_signal: PIO0_3/FC3_RXD_SDA_MOSI_DATA/CTIMER0_MAT1/SCT0_OUT1/SCT_GPI3/FLEXSPI0_DATA2/SECURE_GPIO0_3/PWM1_B0}
  - {pin_num: '49', peripheral: PWM1, signal: 'A, 1', pin_signal: PIO1_23/FC2_SCK/SCT0_OUT0/FC3_SSEL2/PWM1_A1/TRIGOUT_4/HSCMP2_IN1}
  - {pin_num: '76', peripheral: PWM1, signal: 'B, 1', pin_signal: PIO0_21/FC3_RTS_SCL_SSEL1/UTICK_CAP3/CTIMER3_MAT3/SCT_GPI3/SCT0_OUT7/FLEXSPI0_SS0_N/FC7_SCK/HS_SPI_SSEL3/FC7_CTS_SDA_SSEL0/SECURE_GPIO0_21/PWM1_B1/TRIGOUT_4/EXTTRIG_IN7}
  - {pin_num: '77', peripheral: PWM1, signal: 'A, 2', pin_signal: PIO1_25/FC2_TXD_SCL_MISO_WS/SCT0_OUT2/UTICK_CAP0/PWM1_A2/SPI_SCLK/AOI0_OUT3}
  - {pin_num: '92', peripheral: PWM1, signal: 'B, 2', pin_signal: PIO1_31/MCLK/CTIMER0_MAT2/SCT0_OUT6/USB0_VBUS/PWM1_B2/EXTTRIG_IN2}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitPWM1
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
/* Function assigned for the Cortex-M33 */
void BOARD_InitPWM1(void)
{
    /* Enables the clock for the I/O controller.: Enable Clock. */
    CLOCK_EnableClock(kCLOCK_Iocon);

    IOCON->PIO[0][21] = ((IOCON->PIO[0][21] &
                          /* Mask bits to zero which are setting */
                          (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_DIGIMODE_MASK)))

                         /* Signal(function) select: PORT021 (pin 76) is configured as PWM1_B1. */
                         | IOCON_PIO_FUNC(0x0Bu)

                         /* Select Digital mode: Enable Digital mode.
                          * Digital input is enabled. */
                         | IOCON_PIO_DIGIMODE(PIO0_21_DIGIMODE_DIGITAL));

    IOCON->PIO[0][3] = ((IOCON->PIO[0][3] &
                         /* Mask bits to zero which are setting */
                         (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_DIGIMODE_MASK)))

                        /* Signal(function) select: PORT03 (pin 84) is configured as PWM1_B0. */
                        | IOCON_PIO_FUNC(0x0Bu)

                        /* Select Digital mode: Enable Digital mode.
                         * Digital input is enabled. */
                        | IOCON_PIO_DIGIMODE(PIO0_3_DIGIMODE_DIGITAL));

    IOCON->PIO[1][21] = ((IOCON->PIO[1][21] &
                          /* Mask bits to zero which are setting */
                          (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_DIGIMODE_MASK)))

                         /* Signal(function) select: PORT121 (pin 37) is configured as PWM1_A0. */
                         | IOCON_PIO_FUNC(0x0Bu)

                         /* Select Digital mode: Enable Digital mode.
                          * Digital input is enabled. */
                         | IOCON_PIO_DIGIMODE(PIO1_21_DIGIMODE_DIGITAL));

    IOCON->PIO[1][23] = ((IOCON->PIO[1][23] &
                          /* Mask bits to zero which are setting */
                          (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_DIGIMODE_MASK)))

                         /* Signal(function) select: PORT123 (pin 49) is configured as PWM1_A1. */
                         | IOCON_PIO_FUNC(0x0Bu)

                         /* Select Digital mode: Enable Digital mode.
                          * Digital input is enabled. */
                         | IOCON_PIO_DIGIMODE(PIO1_23_DIGIMODE_DIGITAL));

    IOCON->PIO[1][25] = ((IOCON->PIO[1][25] &
                          /* Mask bits to zero which are setting */
                          (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_DIGIMODE_MASK)))

                         /* Signal(function) select: PORT125 (pin 77) is configured as PWM1_A2. */
                         | IOCON_PIO_FUNC(0x0Bu)

                         /* Select Digital mode: Enable Digital mode.
                          * Digital input is enabled. */
                         | IOCON_PIO_DIGIMODE(PIO1_25_DIGIMODE_DIGITAL));

    IOCON->PIO[1][31] = ((IOCON->PIO[1][31] &
                          /* Mask bits to zero which are setting */
                          (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_DIGIMODE_MASK)))

                         /* Signal(function) select: PORT131 (pin 92) is configured as PWM1_B2. */
                         | IOCON_PIO_FUNC(0x0Bu)

                         /* Select Digital mode: Enable Digital mode.
                          * Digital input is enabled. */
                         | IOCON_PIO_DIGIMODE(PIO1_31_DIGIMODE_DIGITAL));
}

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_InitADC1:
- options: {callFromInitBoot: 'false', coreID: cm33_core0, enableClock: 'true'}
- pin_list:
  - {pin_num: '10', peripheral: ADC1, signal: 'CH, 3A', pin_signal: PIO0_12/FC3_TXD_SCL_MISO_WS/FREQME_GPIO_CLK_B/SCT_GPI7/FC6_TXD_SCL_MISO_WS/SECURE_GPIO0_12/AOI1_OUT1/ADC1_3A}
  - {pin_num: '9', peripheral: ADC1, signal: 'CH, 2A', pin_signal: PIO0_11/FC6_RXD_SDA_MOSI_DATA/CTIMER2_MAT2/FREQME_GPIO_CLK_A/SECURE_GPIO0_11/AOI1_OUT2/ADC1_2A}
  - {pin_num: '4', peripheral: ADC1, signal: 'CH, 3B', pin_signal: PIO1_7/FC0_RTS_SCL_SSEL1/CTIMER2_MAT2/SCT_GPI4/AOI1_OUT3/ADC1_3B}
  - {pin_num: '7', peripheral: ADC1, signal: 'CH, 1B', pin_signal: ADC1IN1B}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitADC1
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
/* Function assigned for the Cortex-M33 */
void BOARD_InitADC1(void)
{
    /* Enables the clock for the I/O controller.: Enable Clock. */
    CLOCK_EnableClock(kCLOCK_Iocon);

    /* Enables the clock for the GPIO0 module */
    CLOCK_EnableClock(kCLOCK_Gpio0);

    /* Enables the clock for the GPIO1 module */
    CLOCK_EnableClock(kCLOCK_Gpio1);

    gpio_pin_config_t gpio0_pin9_config = {
        .pinDirection = kGPIO_DigitalInput,
        .outputLogic = 0U
    };
    /* Initialize GPIO functionality on pin PIO0_11 (pin 9)  */
    GPIO_PinInit(GPIO, 0U, 11U, &gpio0_pin9_config);

    gpio_pin_config_t gpio0_pin10_config = {
        .pinDirection = kGPIO_DigitalInput,
        .outputLogic = 0U
    };
    /* Initialize GPIO functionality on pin PIO0_12 (pin 10)  */
    GPIO_PinInit(GPIO, 0U, 12U, &gpio0_pin10_config);

    gpio_pin_config_t gpio1_pin4_config = {
        .pinDirection = kGPIO_DigitalInput,
        .outputLogic = 0U
    };
    /* Initialize GPIO functionality on pin PIO1_7 (pin 4)  */
    GPIO_PinInit(GPIO, 1U, 7U, &gpio1_pin4_config);

    IOCON->PIO[0][11] = ((IOCON->PIO[0][11] &
                          /* Mask bits to zero which are setting */
                          (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_DIGIMODE_MASK)))

                         /* Signal(function) select: PORT011 (pin 9) is configured as ADC1_2A. */
                         | IOCON_PIO_FUNC(0x00u)

                         /* Select Digital mode: Disable digital mode.
                          * Digital input set to 0. */
                         | IOCON_PIO_DIGIMODE(PIO0_11_DIGIMODE_ANALOG));

    IOCON->PIO[0][12] = ((IOCON->PIO[0][12] &
                          /* Mask bits to zero which are setting */
                          (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_DIGIMODE_MASK)))

                         /* Signal(function) select: PORT012 (pin 10) is configured as ADC1_3A. */
                         | IOCON_PIO_FUNC(0x00u)

                         /* Select Digital mode: Disable digital mode.
                          * Digital input set to 0. */
                         | IOCON_PIO_DIGIMODE(PIO0_12_DIGIMODE_ANALOG));

    IOCON->PIO[1][7] = ((IOCON->PIO[1][7] &
                         /* Mask bits to zero which are setting */
                         (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_DIGIMODE_MASK)))

                        /* Signal(function) select: PORT17 (pin 4) is configured as ADC1_3B. */
                        | IOCON_PIO_FUNC(0x00u)

                        /* Select Digital mode: Disable digital mode.
                         * Digital input set to 0. */
                        | IOCON_PIO_DIGIMODE(PIO1_7_DIGIMODE_ANALOG));
}

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_InitHSCMP1:
- options: {callFromInitBoot: 'true', coreID: cm33_core0, enableClock: 'true'}
- pin_list:
  - {peripheral: HSCMP1, signal: 'IN, 4', pin_signal: OPAMP1_OUT}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitHSCMP1
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
/* Function assigned for the Cortex-M33 */
void BOARD_InitHSCMP1(void)
{
}

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_InitENC1:
- options: {callFromInitBoot: 'false', coreID: cm33_core0, enableClock: 'true'}
- pin_list:
  - {pin_num: '89', peripheral: ENC1, signal: 'PHASE, B', pin_signal: PIO0_6/FC3_SCK/CT_INP13/CTIMER4_MAT0/SCT_GPI6/FLEXSPI0_DATA0/SCT0_OUT6/FC7_RXD_SDA_MOSI_DATA/SECURE_GPIO0_6/PWM0_B0/EXTTRIG_IN1}
  - {pin_num: '81', peripheral: ENC1, signal: 'PHASE, A', pin_signal: PIO0_2/FC3_TXD_SCL_MISO_WS/CT_INP1/SCT0_OUT0/SCT_GPI2/FLEXSPI0_DATA3/SECURE_GPIO0_2/PWM0_A2/TRIGOUT_3/EXTTRIG_IN4}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitENC1
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
/* Function assigned for the Cortex-M33 */
void BOARD_InitENC1(void)
{
    /* Enables the clock for the Input Mux.: Enable Clock. */
    CLOCK_EnableClock(kCLOCK_InputMux);
    /* Enables the clock for the I/O controller.: Enable Clock. */
    CLOCK_EnableClock(kCLOCK_Iocon);
    /* EXTTRIG_IN4 is selected as trigger input for ENC1 PHASEA channel 0 */
    INPUTMUX_AttachSignal(INPUTMUX, 0U, kINPUTMUX_ExtTrigIn4ToEnc1Phasea);
    /* EXTTRIG_IN1 is selected as trigger input for ENC1 PHASEB channel 0 */
    INPUTMUX_AttachSignal(INPUTMUX, 0U, kINPUTMUX_ExtTrigIn1ToEnc1Phaseb);

    IOCON->PIO[0][2] = ((IOCON->PIO[0][2] &
                         /* Mask bits to zero which are setting */
                         (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_DIGIMODE_MASK)))

                        /* Signal(function) select: PORT02 (pin 81) is configured as EXTTRIG_IN4. */
                        | IOCON_PIO_FUNC(0x0Du)

                        /* Select Digital mode: Enable Digital mode.
                         * Digital input is enabled. */
                        | IOCON_PIO_DIGIMODE(PIO0_2_DIGIMODE_DIGITAL));

    IOCON->PIO[0][6] = ((IOCON->PIO[0][6] &
                         /* Mask bits to zero which are setting */
                         (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_DIGIMODE_MASK)))

                        /* Signal(function) select: PORT06 (pin 89) is configured as EXTTRIG_IN1. */
                        | IOCON_PIO_FUNC(0x0Du)

                        /* Select Digital mode: Enable Digital mode.
                         * Digital input is enabled. */
                        | IOCON_PIO_DIGIMODE(PIO0_6_DIGIMODE_DIGITAL));
}

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_InitHSCMP2:
- options: {callFromInitBoot: 'true', coreID: cm33_core0, enableClock: 'true'}
- pin_list:
  - {peripheral: HSCMP2, signal: 'IN, 4', pin_signal: OPAMP2_OUT}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitHSCMP2
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
/* Function assigned for the Cortex-M33 */
void BOARD_InitHSCMP2(void)
{
}
/***********************************************************************************************************************
 * EOF
 **********************************************************************************************************************/
