/*
 * Copyright 2021 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

/***********************************************************************************************************************
 * This file was generated by the MCUXpresso Config Tools. Any manual edits made to this file
 * will be overwritten if the respective MCUXpresso Config Tools is used to update this file.
 **********************************************************************************************************************/

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
!!GlobalInfo
product: Pins v12.0
processor: LPC55S36
package_id: LPC55S36JBD100
mcu_data: ksdk2_0
processor_version: 0.12.7
board: LPCXpresso55S36
pin_labels:
- {pin_num: '11', pin_signal: PIO1_20/FC7_RTS_SCL_SSEL1/CT_INP14/FC4_TXD_SCL_MISO_WS/PWM0_A0/AOI0_OUT1/ADC1_8A, label: 'J10[15]/P1_20-ADC1_8A-PWM0_A0', identifier: PWM_A0}
- {pin_num: '4', pin_signal: PIO1_7/FC0_RTS_SCL_SSEL1/CTIMER2_MAT2/SCT_GPI4/AOI1_OUT3/ADC1_3B, label: CUR_C}
- {pin_num: '7', pin_signal: ADC1IN1B, label: VOLT_DCB}
- {pin_num: '9', pin_signal: PIO0_11/FC6_RXD_SDA_MOSI_DATA/CTIMER2_MAT2/FREQME_GPIO_CLK_A/SECURE_GPIO0_11/AOI1_OUT2/ADC1_2A, label: CUR_B}
- {pin_num: '10', pin_signal: PIO0_12/FC3_TXD_SCL_MISO_WS/FREQME_GPIO_CLK_B/SCT_GPI7/FC6_TXD_SCL_MISO_WS/SECURE_GPIO0_12/AOI1_OUT1/ADC1_3A, label: CUR_A}
- {pin_num: '19', pin_signal: PIO0_23/MCLK/CTIMER1_MAT2/CTIMER3_MAT3/SCT0_OUT4/FC0_CTS_SDA_SSEL0/SECURE_GPIO0_23/ADC0_8B, label: CUR_B, identifier: ADC_CUR_B}
- {pin_num: '20', pin_signal: PIO0_16/FC4_TXD_SCL_MISO_WS/CLKOUT/CT_INP4/SECURE_GPIO0_16/AOI0_OUT3/ADC0_3B, label: CUR_C, identifier: ADC_CUR_C}
- {pin_num: '21', pin_signal: PIO0_10/FC6_SCK/CT_INP10/CTIMER2_MAT0/FC1_TXD_SCL_MISO_WS/SCT0_OUT2/SECURE_GPIO0_10/ADC0_1A, label: VOLT_DCB, identifier: ADC_VDCB}
- {pin_num: '22', pin_signal: PIO0_15/FC6_CTS_SDA_SSEL0/UTICK_CAP2/CT_INP16/SCT0_OUT2/SECURE_GPIO0_15/ADC0_3A, label: CUR_A, identifier: ADC_CUR_A}
- {pin_num: '35', pin_signal: PIO1_5/FC0_RXD_SDA_MOSI_DATA/CTIMER2_MAT0/SCT_GPI0/PWM1_A3/TRIGOUT_0/HSCMP0_IN3, label: P1_5-HSCMP0_IN3, identifier: HSCMP0_IN3}
- {pin_num: '36', pin_signal: PIO1_8/FC0_CTS_SDA_SSEL0/SCT0_OUT1/FC4_SSEL2/FC1_SCK/PWM0_A2/AOI1_OUT2/TRIGOUT_6, label: 'J8[1]/P1_8-FC0_CTS-PWM0_A2', identifier: PWM_A2}
- {pin_num: '40', pin_signal: PIO1_22/CTIMER2_MAT3/SCT_GPI5/FC4_SSEL3/CAN0_RD/QSPI_DIN3/PWM0_B1/TRIGOUT_2/HSCMP1_IN1/DAC0_OUT, label: 'JP48[3]/J10[9]/P1_22-HSCMP1_IN1-DAC0_OUT-PWM0_B1_CAN0_RD',
  identifier: PWM_B1}
- {pin_num: '50', pin_signal: PIO1_6/FC0_TXD_SCL_MISO_WS/CTIMER2_MAT1/SCT_GPI3/PWM0_A1/TRIGOUT_5/HSCMP0_OUT, label: 'J10[11]/P1_6-PWM0_A1', identifier: PWM_A1}
- {pin_num: '70', pin_signal: PIO0_13/FC1_CTS_SDA_SSEL0/UTICK_CAP0/CT_INP0/SCT_GPI0/FC1_RXD_SDA_MOSI_DATA/SECURE_GPIO0_13/EXTTRIG_IN3, label: 'J10[3]/U27[1]/P0_13-FC1_SDA-SCT0_GPI0-EXTTRIG_IN3',
  identifier: ENC0_PHA}
- {pin_num: '71', pin_signal: PIO0_14/FC1_RTS_SCL_SSEL1/UTICK_CAP1/CT_INP1/SCT_GPI1/FC1_TXD_SCL_MISO_WS/SECURE_GPIO0_14/EXTTRIG_IN2, label: 'J10[1]/U27[8]/P0_14-FC1_SCL-SCT0_GPI1-EXTTRIG_IN2',
  identifier: ENC0_PHB}
- {pin_num: '75', pin_signal: PIO1_4/FC0_SCK/CTIMER2_MAT1/SCT0_OUT0/FREQME_GPIO_CLK_A/FC4_TXD_SCL_MISO_WS/SPI_DIN/PWM0_B2/TRIGOUT_7/EXTTRIG_IN8, label: 'J10[5]/P1_4-PWM0_B2',
  identifier: PWM_B2}
- {pin_num: '91', pin_signal: PIO1_17/FC6_RTS_SCL_SSEL1/SCT0_OUT4/PWM0_B0/AOI1_OUT3, label: 'J10[13]/P1_17-PWM0_B0', identifier: PWM_B0}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

#include "fsl_common.h"
#include "fsl_gpio.h"
#include "fsl_inputmux.h"
#include "pin_mux.h"

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitBootPins
 * Description   : Calls initialization functions.
 *
 * END ****************************************************************************************************************/
void BOARD_InitBootPins(void)
{
}

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_Init_Pins:
- options: {callFromInitBoot: 'false', coreID: cm33_core0, enableClock: 'true'}
- pin_list:
  - {pin_num: '95', peripheral: FLEXCOMM0, signal: TXD_SCL_MISO_WS, pin_signal: PIO0_30/FC0_TXD_SCL_MISO_WS/CTIMER0_MAT0/SCT0_OUT9/TRACEDATA1/CAN0_TD/FC6_TXD_SCL_MISO_WS/SECURE_GPIO0_30/PWM1_A1/AOI1_OUT0}
  - {pin_num: '93', peripheral: FLEXCOMM0, signal: RXD_SDA_MOSI_DATA, pin_signal: PIO0_29/FC0_RXD_SDA_MOSI_DATA/CTIMER2_MAT3/SCT0_OUT8/TRACEDATA2/FC6_RXD_SDA_MOSI_DATA/CMP0_OUT/SECURE_GPIO0_29/PWM0_A1/SPI_DIN/EXTTRIG_IN3}
  - {pin_num: '11', peripheral: PWM0, signal: 'A, 0', pin_signal: PIO1_20/FC7_RTS_SCL_SSEL1/CT_INP14/FC4_TXD_SCL_MISO_WS/PWM0_A0/AOI0_OUT1/ADC1_8A}
  - {pin_num: '50', peripheral: PWM0, signal: 'A, 1', pin_signal: PIO1_6/FC0_TXD_SCL_MISO_WS/CTIMER2_MAT1/SCT_GPI3/PWM0_A1/TRIGOUT_5/HSCMP0_OUT}
  - {pin_num: '91', peripheral: PWM0, signal: 'B, 0', pin_signal: PIO1_17/FC6_RTS_SCL_SSEL1/SCT0_OUT4/PWM0_B0/AOI1_OUT3}
  - {pin_num: '75', peripheral: PWM0, signal: 'B, 2', pin_signal: PIO1_4/FC0_SCK/CTIMER2_MAT1/SCT0_OUT0/FREQME_GPIO_CLK_A/FC4_TXD_SCL_MISO_WS/SPI_DIN/PWM0_B2/TRIGOUT_7/EXTTRIG_IN8}
  - {pin_num: '40', peripheral: PWM0, signal: 'B, 1', pin_signal: PIO1_22/CTIMER2_MAT3/SCT_GPI5/FC4_SSEL3/CAN0_RD/QSPI_DIN3/PWM0_B1/TRIGOUT_2/HSCMP1_IN1/DAC0_OUT}
  - {pin_num: '36', peripheral: PWM0, signal: 'A, 2', pin_signal: PIO1_8/FC0_CTS_SDA_SSEL0/SCT0_OUT1/FC4_SSEL2/FC1_SCK/PWM0_A2/AOI1_OUT2/TRIGOUT_6}
  - {pin_num: '21', peripheral: ADC0, signal: 'CH, 1A', pin_signal: PIO0_10/FC6_SCK/CT_INP10/CTIMER2_MAT0/FC1_TXD_SCL_MISO_WS/SCT0_OUT2/SECURE_GPIO0_10/ADC0_1A}
  - {pin_num: '20', peripheral: ADC0, signal: 'CH, 3B', pin_signal: PIO0_16/FC4_TXD_SCL_MISO_WS/CLKOUT/CT_INP4/SECURE_GPIO0_16/AOI0_OUT3/ADC0_3B}
  - {pin_num: '19', peripheral: ADC0, signal: 'CH, 8B', pin_signal: PIO0_23/MCLK/CTIMER1_MAT2/CTIMER3_MAT3/SCT0_OUT4/FC0_CTS_SDA_SSEL0/SECURE_GPIO0_23/ADC0_8B}
  - {pin_num: '22', peripheral: ADC0, signal: 'CH, 3A', pin_signal: PIO0_15/FC6_CTS_SDA_SSEL0/UTICK_CAP2/CT_INP16/SCT0_OUT2/SECURE_GPIO0_15/ADC0_3A}
  - {pin_num: '35', peripheral: HSCMP0, signal: 'IN, 3', pin_signal: PIO1_5/FC0_RXD_SDA_MOSI_DATA/CTIMER2_MAT0/SCT_GPI0/PWM1_A3/TRIGOUT_0/HSCMP0_IN3}
  - {pin_num: '70', peripheral: ENC0, signal: 'PHASE, A', pin_signal: PIO0_13/FC1_CTS_SDA_SSEL0/UTICK_CAP0/CT_INP0/SCT_GPI0/FC1_RXD_SDA_MOSI_DATA/SECURE_GPIO0_13/EXTTRIG_IN3}
  - {pin_num: '71', peripheral: ENC0, signal: 'PHASE, B', pin_signal: PIO0_14/FC1_RTS_SCL_SSEL1/UTICK_CAP1/CT_INP1/SCT_GPI1/FC1_TXD_SCL_MISO_WS/SECURE_GPIO0_14/EXTTRIG_IN2}
  - {pin_num: '72', peripheral: GPIO, signal: 'PIO1, 28', pin_signal: PIO1_28/FC7_SCK/CT_INP2/TRIGOUT_4/PWM1_X3/SPI_CS1_DIS/HSCMP1_OUT, direction: OUTPUT}
  - {pin_num: '78', peripheral: GPIO, signal: 'PIO0, 22', pin_signal: PIO0_22/FC6_TXD_SCL_MISO_WS/UTICK_CAP1/CT_INP15/SCT0_OUT3/FLEXSPI0_SCLK_N/FLEXSPI0_SS1_N/USB0_VBUS/FC7_RTS_SCL_SSEL1/SECURE_GPIO0_22/PWM1_X0/EXTTRIG_IN5,
    direction: OUTPUT}
  - {pin_num: '41', peripheral: PINT, signal: 'PINT, 0', pin_signal: PIO0_17/FC4_SSEL2/SCT_GPI7/SCT0_OUT0/FC5_RXD_SDA_MOSI_DATA/QSPI_SCLK/SECURE_GPIO0_17/TRIGOUT_7/HSCMP1_OUT/HSCMP2_IN0,
    identifier: SW3}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_Init_Pins
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
/* Function assigned for the Cortex-M33 */
void BOARD_Init_Pins(void)
{
    /* Enables the clock for the Input Mux.: Enable Clock. */
    CLOCK_EnableClock(kCLOCK_InputMux);
    /* Enables the clock for the I/O controller.: Enable Clock. */
    CLOCK_EnableClock(kCLOCK_Iocon);

    /* Enables the clock for the GPIO0 module */
    CLOCK_EnableClock(kCLOCK_Gpio0);

    /* Enables the clock for the GPIO1 module */
    CLOCK_EnableClock(kCLOCK_Gpio1);

    gpio_pin_config_t gpio0_pin21_config = {
        .pinDirection = kGPIO_DigitalInput,
        .outputLogic = 0U
    };
    /* Initialize GPIO functionality on pin PIO0_10 (pin 21)  */
    GPIO_PinInit(GPIO, 0U, 10U, &gpio0_pin21_config);

    gpio_pin_config_t gpio0_pin22_config = {
        .pinDirection = kGPIO_DigitalInput,
        .outputLogic = 0U
    };
    /* Initialize GPIO functionality on pin PIO0_15 (pin 22)  */
    GPIO_PinInit(GPIO, 0U, 15U, &gpio0_pin22_config);

    gpio_pin_config_t gpio0_pin20_config = {
        .pinDirection = kGPIO_DigitalInput,
        .outputLogic = 0U
    };
    /* Initialize GPIO functionality on pin PIO0_16 (pin 20)  */
    GPIO_PinInit(GPIO, 0U, 16U, &gpio0_pin20_config);

    gpio_pin_config_t LED_GREEN_config = {
        .pinDirection = kGPIO_DigitalOutput,
        .outputLogic = 0U
    };
    /* Initialize GPIO functionality on pin PIO0_22 (pin 78)  */
    GPIO_PinInit(BOARD_INIT_PINS_LED_GREEN_GPIO, BOARD_INIT_PINS_LED_GREEN_PORT, BOARD_INIT_PINS_LED_GREEN_PIN, &LED_GREEN_config);

    gpio_pin_config_t gpio0_pin19_config = {
        .pinDirection = kGPIO_DigitalInput,
        .outputLogic = 0U
    };
    /* Initialize GPIO functionality on pin PIO0_23 (pin 19)  */
    GPIO_PinInit(GPIO, 0U, 23U, &gpio0_pin19_config);

    gpio_pin_config_t LED_RED_config = {
        .pinDirection = kGPIO_DigitalOutput,
        .outputLogic = 0U
    };
    /* Initialize GPIO functionality on pin PIO1_28 (pin 72)  */
    GPIO_PinInit(BOARD_INIT_PINS_LED_RED_GPIO, BOARD_INIT_PINS_LED_RED_PORT, BOARD_INIT_PINS_LED_RED_PIN, &LED_RED_config);
    /* EXTTRIG_IN3 is selected as trigger input for ENC0 PHASEA channel 0 */
    INPUTMUX_AttachSignal(INPUTMUX, 0U, kINPUTMUX_ExtTrigIn3ToEnc0Phasea);
    /* EXTTRIG_IN2 is selected as trigger input for ENC0 PHASEB channel 0 */
    INPUTMUX_AttachSignal(INPUTMUX, 0U, kINPUTMUX_ExtTrigIn2ToEnc0Phaseb);
    /* PIO0_17 is selected for PINT input 0 */
    INPUTMUX_AttachSignal(INPUTMUX, 0U, kINPUTMUX_GpioPort0Pin17ToPintsel);

    IOCON->PIO[0][10] = ((IOCON->PIO[0][10] &
                          /* Mask bits to zero which are setting */
                          (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_DIGIMODE_MASK)))

                         /* Signal(function) select: PORT010 (pin 21) is configured as ADC0_1A. */
                         | IOCON_PIO_FUNC(0x00u)

                         /* Select Digital mode: Disable digital mode.
                          * Digital input set to 0. */
                         | IOCON_PIO_DIGIMODE(PIO0_10_DIGIMODE_ANALOG));

    IOCON->PIO[0][13] = ((IOCON->PIO[0][13] &
                          /* Mask bits to zero which are setting */
                          (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_DIGIMODE_MASK)))

                         /* Signal(function) select: PORT013 (pin 70) is configured as EXTTRIG_IN3. */
                         | IOCON_PIO_FUNC(0x0Du)

                         /* Select Digital mode: Enable Digital mode.
                          * Digital input is enabled. */
                         | IOCON_PIO_DIGIMODE(PIO0_13_DIGIMODE_DIGITAL));

    IOCON->PIO[0][14] = ((IOCON->PIO[0][14] &
                          /* Mask bits to zero which are setting */
                          (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_DIGIMODE_MASK)))

                         /* Signal(function) select: PORT014 (pin 71) is configured as EXTTRIG_IN2. */
                         | IOCON_PIO_FUNC(0x0Du)

                         /* Select Digital mode: Enable Digital mode.
                          * Digital input is enabled. */
                         | IOCON_PIO_DIGIMODE(PIO0_14_DIGIMODE_DIGITAL));

    IOCON->PIO[0][15] = ((IOCON->PIO[0][15] &
                          /* Mask bits to zero which are setting */
                          (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_DIGIMODE_MASK)))

                         /* Signal(function) select: PORT015 (pin 22) is configured as ADC0_3A. */
                         | IOCON_PIO_FUNC(0x00u)

                         /* Select Digital mode: Disable digital mode.
                          * Digital input set to 0. */
                         | IOCON_PIO_DIGIMODE(PIO0_15_DIGIMODE_ANALOG));

    IOCON->PIO[0][16] = ((IOCON->PIO[0][16] &
                          /* Mask bits to zero which are setting */
                          (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_DIGIMODE_MASK)))

                         /* Signal(function) select: PORT016 (pin 20) is configured as ADC0_3B. */
                         | IOCON_PIO_FUNC(0x00u)

                         /* Select Digital mode: Disable digital mode.
                          * Digital input set to 0. */
                         | IOCON_PIO_DIGIMODE(PIO0_16_DIGIMODE_ANALOG));

    IOCON->PIO[0][17] = ((IOCON->PIO[0][17] &
                          /* Mask bits to zero which are setting */
                          (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_DIGIMODE_MASK)))

                         /* Signal(function) select: PORT017 (pin 41) is configured as PIO0_17. */
                         | IOCON_PIO_FUNC(0x00u)

                         /* Select Digital mode: Enable Digital mode.
                          * Digital input is enabled. */
                         | IOCON_PIO_DIGIMODE(PIO0_17_DIGIMODE_DIGITAL));

    IOCON->PIO[0][22] = ((IOCON->PIO[0][22] &
                          /* Mask bits to zero which are setting */
                          (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_DIGIMODE_MASK)))

                         /* Signal(function) select: PORT022 (pin 78) is configured as PIO0_22. */
                         | IOCON_PIO_FUNC(0x00u)

                         /* Select Digital mode: Enable Digital mode.
                          * Digital input is enabled. */
                         | IOCON_PIO_DIGIMODE(PIO0_22_DIGIMODE_DIGITAL));

    IOCON->PIO[0][23] =
        ((IOCON->PIO[0][23] &
          /* Mask bits to zero which are setting */
          (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_MODE_MASK | IOCON_PIO_DIGIMODE_MASK | IOCON_PIO_ASW0_MASK)))

         /* Signal(function) select: PORT023 (pin 19) is configured as ADC0_8B. */
         | IOCON_PIO_FUNC(0x00u)

         /* Mode select (on-chip pull-up/pull-down resistor control): Inactive.
          * Inactive (no pull-down/pull-up resistor enabled). */
         | IOCON_PIO_MODE(PIO0_23_MODE_INACTIVE)

         /* Select Digital mode: Disable digital mode.
          * Digital input set to 0. */
         | IOCON_PIO_DIGIMODE(PIO0_23_DIGIMODE_ANALOG)

         /* Analog switch input control: Analog switch is closed.
          * (enable). */
         | IOCON_PIO_ASW0(PIO0_23_ASW0_ENABLE));

    IOCON->PIO[0][29] = ((IOCON->PIO[0][29] &
                          /* Mask bits to zero which are setting */
                          (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_DIGIMODE_MASK)))

                         /* Signal(function) select: PORT029 (pin 93) is configured as FC0_RXD_SDA_MOSI_DATA. */
                         | IOCON_PIO_FUNC(0x01u)

                         /* Select Digital mode: Enable Digital mode.
                          * Digital input is enabled. */
                         | IOCON_PIO_DIGIMODE(PIO0_29_DIGIMODE_DIGITAL));

    IOCON->PIO[0][30] = ((IOCON->PIO[0][30] &
                          /* Mask bits to zero which are setting */
                          (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_DIGIMODE_MASK)))

                         /* Signal(function) select: PORT030 (pin 95) is configured as FC0_TXD_SCL_MISO_WS. */
                         | IOCON_PIO_FUNC(0x01u)

                         /* Select Digital mode: Enable Digital mode.
                          * Digital input is enabled. */
                         | IOCON_PIO_DIGIMODE(PIO0_30_DIGIMODE_DIGITAL));

    IOCON->PIO[1][17] = ((IOCON->PIO[1][17] &
                          /* Mask bits to zero which are setting */
                          (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_DIGIMODE_MASK)))

                         /* Signal(function) select: PORT117 (pin 91) is configured as PWM0_B0. */
                         | IOCON_PIO_FUNC(0x0Bu)

                         /* Select Digital mode: Enable Digital mode.
                          * Digital input is enabled. */
                         | IOCON_PIO_DIGIMODE(PIO1_17_DIGIMODE_DIGITAL));

    IOCON->PIO[1][20] = ((IOCON->PIO[1][20] &
                          /* Mask bits to zero which are setting */
                          (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_DIGIMODE_MASK)))

                         /* Signal(function) select: PORT120 (pin 11) is configured as PWM0_A0. */
                         | IOCON_PIO_FUNC(0x0Bu)

                         /* Select Digital mode: Enable Digital mode.
                          * Digital input is enabled. */
                         | IOCON_PIO_DIGIMODE(PIO1_20_DIGIMODE_DIGITAL));

    IOCON->PIO[1][22] = ((IOCON->PIO[1][22] &
                          /* Mask bits to zero which are setting */
                          (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_DIGIMODE_MASK)))

                         /* Signal(function) select: PORT122 (pin 40) is configured as PWM0_B1. */
                         | IOCON_PIO_FUNC(0x0Bu)

                         /* Select Digital mode: Enable Digital mode.
                          * Digital input is enabled. */
                         | IOCON_PIO_DIGIMODE(PIO1_22_DIGIMODE_DIGITAL));

    IOCON->PIO[1][28] = ((IOCON->PIO[1][28] &
                          /* Mask bits to zero which are setting */
                          (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_DIGIMODE_MASK)))

                         /* Signal(function) select: PORT128 (pin 72) is configured as PIO1_28. */
                         | IOCON_PIO_FUNC(0x00u)

                         /* Select Digital mode: Enable Digital mode.
                          * Digital input is enabled. */
                         | IOCON_PIO_DIGIMODE(PIO1_28_DIGIMODE_DIGITAL));

    IOCON->PIO[1][4] = ((IOCON->PIO[1][4] &
                         /* Mask bits to zero which are setting */
                         (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_DIGIMODE_MASK)))

                        /* Signal(function) select: PORT14 (pin 75) is configured as PWM0_B2. */
                        | IOCON_PIO_FUNC(0x0Bu)

                        /* Select Digital mode: Enable Digital mode.
                         * Digital input is enabled. */
                        | IOCON_PIO_DIGIMODE(PIO1_4_DIGIMODE_DIGITAL));

    IOCON->PIO[1][5] = ((IOCON->PIO[1][5] &
                         /* Mask bits to zero which are setting */
                         (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_MODE_MASK | IOCON_PIO_DIGIMODE_MASK | IOCON_PIO_ASW0_MASK)))

                        /* Signal(function) select: PORT15 (pin 35) is configured as HSCMP0_IN3. */
                        | IOCON_PIO_FUNC(0x00u)

                        /* Mode select (on-chip pull-up/pull-down resistor control): Inactive.
                         * Inactive (no pull-down/pull-up resistor enabled). */
                        | IOCON_PIO_MODE(PIO1_5_MODE_INACTIVE)

                        /* Select Digital mode: Disable digital mode.
                         * Digital input set to 0. */
                        | IOCON_PIO_DIGIMODE(PIO1_5_DIGIMODE_ANALOG)

                        /* Analog switch input control: Analog switch is closed.
                         * (enable). */
                        | IOCON_PIO_ASW0(PIO1_5_ASW0_ENABLE));

    IOCON->PIO[1][6] = ((IOCON->PIO[1][6] &
                         /* Mask bits to zero which are setting */
                         (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_DIGIMODE_MASK)))

                        /* Signal(function) select: PORT16 (pin 50) is configured as PWM0_A1. */
                        | IOCON_PIO_FUNC(0x0Bu)

                        /* Select Digital mode: Enable Digital mode.
                         * Digital input is enabled. */
                        | IOCON_PIO_DIGIMODE(PIO1_6_DIGIMODE_DIGITAL));

    IOCON->PIO[1][8] = ((IOCON->PIO[1][8] &
                         /* Mask bits to zero which are setting */
                         (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_DIGIMODE_MASK)))

                        /* Signal(function) select: PORT18 (pin 36) is configured as PWM0_A2. */
                        | IOCON_PIO_FUNC(0x0Bu)

                        /* Select Digital mode: Enable Digital mode.
                         * Digital input is enabled. */
                        | IOCON_PIO_DIGIMODE(PIO1_8_DIGIMODE_DIGITAL));
}

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_InitGPIO:
- options: {callFromInitBoot: 'false', coreID: cm33_core0, enableClock: 'true'}
- pin_list:
  - {pin_num: '72', peripheral: GPIO, signal: 'PIO1, 28', pin_signal: PIO1_28/FC7_SCK/CT_INP2/TRIGOUT_4/PWM1_X3/SPI_CS1_DIS/HSCMP1_OUT, direction: OUTPUT}
  - {pin_num: '78', peripheral: GPIO, signal: 'PIO0, 22', pin_signal: PIO0_22/FC6_TXD_SCL_MISO_WS/UTICK_CAP1/CT_INP15/SCT0_OUT3/FLEXSPI0_SCLK_N/FLEXSPI0_SS1_N/USB0_VBUS/FC7_RTS_SCL_SSEL1/SECURE_GPIO0_22/PWM1_X0/EXTTRIG_IN5,
    direction: OUTPUT}
  - {pin_num: '41', peripheral: PINT, signal: 'PINT, 0', pin_signal: PIO0_17/FC4_SSEL2/SCT_GPI7/SCT0_OUT0/FC5_RXD_SDA_MOSI_DATA/QSPI_SCLK/SECURE_GPIO0_17/TRIGOUT_7/HSCMP1_OUT/HSCMP2_IN0,
    identifier: SW3}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitGPIO
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
/* Function assigned for the Cortex-M33 */
void BOARD_InitGPIO(void)
{
    /* Enables the clock for the Input Mux.: Enable Clock. */
    CLOCK_EnableClock(kCLOCK_InputMux);
    /* Enables the clock for the I/O controller.: Enable Clock. */
    CLOCK_EnableClock(kCLOCK_Iocon);

    /* Enables the clock for the GPIO0 module */
    CLOCK_EnableClock(kCLOCK_Gpio0);

    /* Enables the clock for the GPIO1 module */
    CLOCK_EnableClock(kCLOCK_Gpio1);

    gpio_pin_config_t LED_GREEN_config = {
        .pinDirection = kGPIO_DigitalOutput,
        .outputLogic = 0U
    };
    /* Initialize GPIO functionality on pin PIO0_22 (pin 78)  */
    GPIO_PinInit(BOARD_INITGPIO_LED_GREEN_GPIO, BOARD_INITGPIO_LED_GREEN_PORT, BOARD_INITGPIO_LED_GREEN_PIN, &LED_GREEN_config);

    gpio_pin_config_t LED_RED_config = {
        .pinDirection = kGPIO_DigitalOutput,
        .outputLogic = 0U
    };
    /* Initialize GPIO functionality on pin PIO1_28 (pin 72)  */
    GPIO_PinInit(BOARD_INITGPIO_LED_RED_GPIO, BOARD_INITGPIO_LED_RED_PORT, BOARD_INITGPIO_LED_RED_PIN, &LED_RED_config);
    /* PIO0_17 is selected for PINT input 0 */
    INPUTMUX_AttachSignal(INPUTMUX, 0U, kINPUTMUX_GpioPort0Pin17ToPintsel);

    IOCON->PIO[0][17] = ((IOCON->PIO[0][17] &
                          /* Mask bits to zero which are setting */
                          (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_DIGIMODE_MASK)))

                         /* Signal(function) select: PORT017 (pin 41) is configured as PIO0_17. */
                         | IOCON_PIO_FUNC(0x00u)

                         /* Select Digital mode: Enable Digital mode.
                          * Digital input is enabled. */
                         | IOCON_PIO_DIGIMODE(PIO0_17_DIGIMODE_DIGITAL));

    IOCON->PIO[0][22] = ((IOCON->PIO[0][22] &
                          /* Mask bits to zero which are setting */
                          (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_DIGIMODE_MASK)))

                         /* Signal(function) select: PORT022 (pin 78) is configured as PIO0_22. */
                         | IOCON_PIO_FUNC(0x00u)

                         /* Select Digital mode: Enable Digital mode.
                          * Digital input is enabled. */
                         | IOCON_PIO_DIGIMODE(PIO0_22_DIGIMODE_DIGITAL));

    IOCON->PIO[1][28] = ((IOCON->PIO[1][28] &
                          /* Mask bits to zero which are setting */
                          (~(IOCON_PIO_FUNC_MASK | IOCON_PIO_DIGIMODE_MASK)))

                         /* Signal(function) select: PORT128 (pin 72) is configured as PIO1_28. */
                         | IOCON_PIO_FUNC(0x00u)

                         /* Select Digital mode: Enable Digital mode.
                          * Digital input is enabled. */
                         | IOCON_PIO_DIGIMODE(PIO1_28_DIGIMODE_DIGITAL));
}
/***********************************************************************************************************************
 * EOF
 **********************************************************************************************************************/
