/*
 * Copyright 2017-2021 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

/***********************************************************************************************************************
 * This file was generated by the MCUXpresso Config Tools. Any manual edits made to this file
 * will be overwritten if the respective MCUXpresso Config Tools is used to update this file.
 **********************************************************************************************************************/

/* clang-format off */
/* TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
!!GlobalInfo
product: TEE v4.0
processor: LPC55S36
package_id: LPC55S36JBD100
mcu_data: ksdk2_0
processor_version: 0.10.4
toolOptions:
  _output_type_: c_code
  _legacy_source_names_: 'yes'
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS **********/
/* clang-format on */

/***********************************************************************************************************************
 * Included files
 **********************************************************************************************************************/
#include "fsl_common.h"
#include "tzm_config.h"

/***********************************************************************************************************************
 * Definitions
 **********************************************************************************************************************/

/* SAU region boundaries */
#define SAU_REGION_0_BASE 0
#define SAU_REGION_0_END  0x0FFFFFFFU
#define SAU_REGION_1_BASE 0x20000000U
#define SAU_REGION_1_END  0xDFFFFFFFU
#define SAU_REGION_2_BASE 0x1000FE00U
#define SAU_REGION_2_END  0x1000FFFFU

/* clang-format off */
/* TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
functional_group:
- called_from_default_init: 'true'
- id_prefix: ''
- prefix_user_defined: 'true'
- name: 'BOARD_InitTrustZone'
- description: ''
- ahb:
  - regions: [{memory: PROGRAM_FLASH, security: s_priv, start: '0x00000000', size: '0x00010000'}, {memory: PROGRAM_FLASH, security: ns_user, start: '0x00010000',
      size: '0x00030000'}, {memory: BootROM, security: ns_user, start: '0x00000000', size: '0x00020000'}, {memory: SRAMX, security: ns_user, start: '0x00000000',
      size: '0x00004000'}, {memory: FLEXSPI_FLASH, security: ns_user, start: '0x00000000', size: '0x08000000'}, {memory: SRAM0, security: s_priv, start: '0x00000000',
      size: '0x00004000'}, {memory: SRAM1, security: s_priv, start: '0x00000000', size: '0x00004000'}, {memory: SRAM2, security: ns_user, start: '0x00000000', size: '0x00008000'},
    {memory: SRAM3, security: ns_user, start: '0x00000000', size: '0x00008000'}, {memory: SRAM4, security: ns_user, start: '0x00000000', size: '0x00004000'}, {memory: AHBperipherals_port11_sectrl0_area,
      security: s_priv, start: '0x00000000', size: '0x00004000'}]
  - masters: {ns_user: {id: [CANFD, COOLFLUXD, COOLFLUXI, DMA0, DMA1, PKC, USBFSD, USBFSH]}}
  - peripherals: {ns_user: {id: [ADC0, ADC1, AOI0, CACHE64_POLSEL0, CAN0, CDOG, CRC0, CSS, CTIMER0, CTIMER1, CTIMER2, CTIMER3, CTIMER4, DAC0, DAC1, DAC2, DEBUGGER_MAILBOX0,
        DMA0, DMA1, DMIC0, ENC0, ENC1, FLEXCOMM1, FLEXCOMM2, FLEXCOMM3, FLEXCOMM4, FLEXCOMM5, FLEXCOMM6, FLEXCOMM7, FLEXSPI0, GINT0, GINT1, GPIO, HSCMP0, HSCMP1,
        HSCMP2, I3C0, INPUTMUX, ITRC0, MAILBOX, MRT0, OPAMP0, OPAMP1, OPAMP2, OSTIMER0, PINT, PKC, POWERQUAD, PRINCE0, PUF, PWM0, PWM1, RTC, SCT0, SECGPIO, SECPINT,
        SPI8, SPI_FILTER, SYSCTL, USB0, USBFSH, UTICK0, VREF, WWDT]}, s_priv: {id: [ANACTRL, FLASH, FLEXCOMM0, IOCON, PMC, SECTRL0, SYSCON]}}
  - interrupts:
    - masking: {}
    - security: {Secure: {id: [ADC0_IRQn, ADC1_IRQn, CAN0_IRQ0_IRQn, CAN0_IRQ1_IRQn, CDOG_IRQn, CTIMER0_IRQn, CTIMER1_IRQn, CTIMER2_IRQn, CTIMER3_IRQn, CTIMER4_IRQn,
          DAC0_IRQn, DAC1_IRQn, DAC2_IRQn, DMA0_IRQn, DMA1_IRQn, DMIC_IRQn, ENC0_COMPARE_IRQn, ENC0_HOME_IRQn, ENC0_IDX_IRQn, ENC0_WDG_IRQn, ENC1_COMPARE_IRQn, ENC1_HOME_IRQn,
          ENC1_IDX_IRQn, ENC1_WDG_IRQn, FLASH_IRQn, FLEXCOMM0_IRQn, FLEXCOMM1_IRQn, FLEXCOMM2_IRQn, FLEXCOMM3_IRQn, FLEXCOMM4_IRQn, FLEXCOMM5_IRQn, FLEXCOMM6_IRQn,
          FLEXCOMM7_IRQn, FLEXCOMM8_IRQn, FLEXPWM0_CAPTURE_IRQn, FLEXPWM0_COMPARE0_IRQn, FLEXPWM0_COMPARE1_IRQn, FLEXPWM0_COMPARE2_IRQn, FLEXPWM0_COMPARE3_IRQn, FLEXPWM0_FAULT_IRQn,
          FLEXPWM0_RELOAD0_IRQn, FLEXPWM0_RELOAD1_IRQn, FLEXPWM0_RELOAD2_IRQn, FLEXPWM0_RELOAD3_IRQn, FLEXPWM0_RELOAD_ERROR_IRQn, FLEXPWM1_CAPTURE_IRQn, FLEXPWM1_COMPARE0_IRQn,
          FLEXPWM1_COMPARE1_IRQn, FLEXPWM1_COMPARE2_IRQn, FLEXPWM1_COMPARE3_IRQn, FLEXPWM1_FAULT_IRQn, FLEXPWM1_RELOAD0_IRQn, FLEXPWM1_RELOAD1_IRQn, FLEXPWM1_RELOAD2_IRQn,
          FLEXPWM1_RELOAD3_IRQn, FLEXPWM1_RELOAD_ERROR_IRQn, FlexSPI0_IRQn, Freqme_IRQn, GINT0_IRQn, GINT1_IRQn, HSCMP0_IRQn, HSCMP1_IRQn, HSCMP2_IRQn, HWVAD0_IRQn,
          I3C0_IRQn, MRT0_IRQn, OS_EVENT_IRQn, PIN_INT0_IRQn, PIN_INT1_IRQn, PIN_INT2_IRQn, PIN_INT3_IRQn, PIN_INT4_IRQn, PIN_INT5_IRQn, PIN_INT6_IRQn, PIN_INT7_IRQn,
          PKC_ERR_IRQn, PKC_IRQn, PUF_IRQn, RTC_IRQn, SCT0_IRQn, SEC_GPIO_INT0_IRQ0_IRQn, SEC_GPIO_INT0_IRQ1_IRQn, SHA_IRQn, SPI_FILTER_IRQn, USB0_IRQn, USB0_NEEDCLK_IRQn,
          UTICK0_IRQn, WDT_BOD_IRQn]}}
  - pins_masks:
    - pio0: {Non-masked: {id: ['0', '1', '10', '11', '12', '13', '14', '15', '16', '17', '18', '19', '2', '20', '21', '22', '23', '24', '25', '26', '27', '28',
          '3', '31', '4', '5', '6', '7', '8', '9']}, Masked: {id: ['29', '30']}}
    - pio1: {Non-masked: {id: ['0', '1', '10', '11', '12', '13', '14', '15', '16', '17', '18', '19', '2', '20', '21', '22', '23', '24', '25', '26', '27', '28',
          '29', '3', '30', '31', '4', '5', '6', '7', '8', '9']}}
    - pio2: {Non-masked: {id: ['0', '1']}}
- sau:
  - enabled: 'true'
  - all_non_secure: 'false'
  - generate_code_for_disabled_regions: 'false'
  - regions: [{index: '0', enabled: 'true', security: ns, start: '0x00000000', size: '0x10000000'}, {index: '1', enabled: 'true', security: ns, start: '0x20000000',
      size: '0xC0000000'}, {index: '2', enabled: 'true', security: nsc, start: '0x1000FE00', size: '0x00000200'}, {index: '3', enabled: 'false', security: ns, start: '0x00000000',
      size: '0x00000020'}, {index: '4', enabled: 'false', security: ns, start: '0x00000000', size: '0x00000020'}, {index: '5', enabled: 'false', security: ns, start: '0x00000000',
      size: '0x00000020'}, {index: '6', enabled: 'false', security: ns, start: '0x00000000', size: '0x00000020'}, {index: '7', enabled: 'false', security: ns, start: '0x00000000',
      size: '0x00000020'}]
- global_options:
  - no:
    - id: [AIRCR_PRIS, AIRCR_BFHFNMINS, AIRCR_SYSRESETREQS, SCR_SLEEPDEEPS, SHCSR_SECUREFAULTENA, NSACR_CP2, NSACR_CP3, NSACR_CP4, NSACR_CP5, NSACR_CP6, NSACR_CP7,
      CPPWR_SU0, CPPWR_SUS0, CPPWR_SU1, CPPWR_SUS1, CPPWR_SU2, CPPWR_SUS2, CPPWR_SU3, CPPWR_SUS3, CPPWR_SU4, CPPWR_SUS4, CPPWR_SU5, CPPWR_SUS5, CPPWR_SU6, CPPWR_SUS6,
      CPPWR_SU7, CPPWR_SUS7, CPPWR_SU10, CPPWR_SUS10, CPPWR_SU11, CPPWR_SUS11, SEC_GPIO_MASK2_LOCK, SEC_GPIO_MASK1_LOCK, SEC_GPIO_MASK0_LOCK, MASTER_SEC_LEVEL_LOCK,
      CM33_LOCK_NS_VTOR, CM33_LOCK_NS_MPU, CM33_LOCK_S_VTAIRCR, CM33_LOCK_S_MPU, CM33_LOCK_SAU, CM33_LOCK_REG_LOCK, AHB_MISC_CTRL_REG_IDAU_ALL_NS, AHB_MISC_CTRL_REG_DISABLE_MASTER_STRICT_MODE,
      AHB_MISC_CTRL_REG_DISABLE_VIOLATION_ABORT, AHB_MISC_CTRL_REG_ENABLE_NS_PRIV_CHECK, AHB_MISC_CTRL_REG_ENABLE_S_PRIV_CHECK]
  - yes:
    - id: [NSACR_CP0, NSACR_CP1, NSACR_CP10, NSACR_CP11, AHB_MISC_CTRL_REG_ENABLE_SECURE_CHECKING, AHB_MISC_CTRL_REG_WRITE_LOCK]
- user_memory_regions: [{id: Region_1, security: s_priv, name: Secure Code, start: '0x10000000', size: '0x0000FE00'}, {id: Region_2, security: nsc_priv, name: Veneer
      Table, start: '0x1000FE00', size: '0x00000200'}, {id: Region_3, security: s_priv, name: Secure Stack and Data, start: '0x30000000', size: '0x00008000'}, {id: Region_4,
    security: ns_user, name: Non-secure Code, description: Privilege check is disabled so reset value (NS-User) can be used, start: '0x00010000', size: '0x00030000'},
  {id: Region_5, security: ns_user, name: Non-secure Stack and Data, description: 'Privilege check is disabled so reset value (NS-User) can be used. ', start: '0x20008000',
    size: '0x00014000'}]
- mpus:
  - mpu:
    - enabled: 'false'
    - id: 's'
    - priv_default_map: 'false'
    - handler_enabled: 'false'
    - generate_code_for_disabled_regions: 'false'
    - attributes: [{index: '0', id: Code, memory_type: normal, device: nGnRE}, {index: '1', id: RAM, memory_type: normal, device: nGnRE}, {index: '2', id: Peripheral,
        memory_type: device, device: nGnRE}, {index: '3', id: '3', memory_type: device, device: nGnRE}, {index: '4', id: '4', memory_type: device, device: nGnRE},
      {index: '5', id: '5', memory_type: device, device: nGnRE}, {index: '6', id: '6', memory_type: device, device: nGnRE}, {index: '7', id: '7', memory_type: device,
        device: nGnRE}]
    - regions: [{executable: 'false', read_only: 'false', attributes_index: '0', index: '0', enabled: 'false', security: priv, start: '0x00000000', size: '0x00000020'},
      {executable: 'false', read_only: 'false', attributes_index: '0', index: '1', enabled: 'false', security: priv, start: '0x00000000', size: '0x00000020'}, {executable: 'false',
        read_only: 'false', attributes_index: '0', index: '2', enabled: 'false', security: priv, start: '0x00000000', size: '0x00000020'}, {executable: 'false', read_only: 'false',
        attributes_index: '0', index: '3', enabled: 'false', security: priv, start: '0x00000000', size: '0x00000020'}, {executable: 'false', read_only: 'false', attributes_index: '0',
        index: '4', enabled: 'false', security: priv, start: '0x00000000', size: '0x00000020'}, {executable: 'false', read_only: 'false', attributes_index: '0', index: '5',
        enabled: 'false', security: priv, start: '0x00000000', size: '0x00000020'}, {executable: 'false', read_only: 'false', attributes_index: '0', index: '6', enabled: 'false',
        security: priv, start: '0x00000000', size: '0x00000020'}, {executable: 'false', read_only: 'false', attributes_index: '0', index: '7', enabled: 'false', security: priv,
        start: '0x00000000', size: '0x00000020'}]
  - mpu:
    - enabled: 'false'
    - id: 'ns'
    - priv_default_map: 'false'
    - handler_enabled: 'false'
    - generate_code_for_disabled_regions: 'false'
    - attributes: [{index: '0', id: Code, memory_type: normal, device: nGnRE}, {index: '1', id: RAM, memory_type: normal, device: nGnRE}, {index: '2', id: Peripheral,
        memory_type: device, device: nGnRE}, {index: '3', id: '3', memory_type: device, device: nGnRE}, {index: '4', id: '4', memory_type: device, device: nGnRE},
      {index: '5', id: '5', memory_type: device, device: nGnRE}, {index: '6', id: '6', memory_type: device, device: nGnRE}, {index: '7', id: '7', memory_type: device,
        device: nGnRE}]
    - regions: [{executable: 'false', read_only: 'false', attributes_index: '0', index: '0', enabled: 'false', security: priv, start: '0x00000000', size: '0x00000020'},
      {executable: 'false', read_only: 'false', attributes_index: '0', index: '1', enabled: 'false', security: priv, start: '0x00000000', size: '0x00000020'}, {executable: 'false',
        read_only: 'false', attributes_index: '0', index: '2', enabled: 'false', security: priv, start: '0x00000000', size: '0x00000020'}, {executable: 'false', read_only: 'false',
        attributes_index: '0', index: '3', enabled: 'false', security: priv, start: '0x00000000', size: '0x00000020'}, {executable: 'false', read_only: 'false', attributes_index: '0',
        index: '4', enabled: 'false', security: priv, start: '0x00000000', size: '0x00000020'}, {executable: 'false', read_only: 'false', attributes_index: '0', index: '5',
        enabled: 'false', security: priv, start: '0x00000000', size: '0x00000020'}, {executable: 'false', read_only: 'false', attributes_index: '0', index: '6', enabled: 'false',
        security: priv, start: '0x00000000', size: '0x00000020'}, {executable: 'false', read_only: 'false', attributes_index: '0', index: '7', enabled: 'false', security: priv,
        start: '0x00000000', size: '0x00000020'}]
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS **********/
/* clang-format on */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitTrustZone
 * Description   :
 *
 * END ****************************************************************************************************************/

/***********************************************************************************************************************
 * BOARD_InitTrustZone function
 **********************************************************************************************************************/
void BOARD_InitTrustZone()
{
    /* SAU configuration */

    /* Set SAU Control register: Disable SAU and All Secure */
    SAU->CTRL = 0;

    /* Set SAU region number */
    SAU->RNR = 0;
    /* Region base address */
    SAU->RBAR = SAU_REGION_0_BASE & SAU_RBAR_BADDR_Msk;
    /* Region end address */
    SAU->RLAR = (SAU_REGION_0_END & SAU_RLAR_LADDR_Msk) | ((0U << SAU_RLAR_NSC_Pos) & SAU_RLAR_NSC_Msk) |
                ((1U << SAU_RLAR_ENABLE_Pos) & SAU_RLAR_ENABLE_Msk);

    /* Set SAU region number */
    SAU->RNR = 1;
    /* Region base address */
    SAU->RBAR = SAU_REGION_1_BASE & SAU_RBAR_BADDR_Msk;
    /* Region end address */
    SAU->RLAR = (SAU_REGION_1_END & SAU_RLAR_LADDR_Msk) | ((0U << SAU_RLAR_NSC_Pos) & SAU_RLAR_NSC_Msk) |
                ((1U << SAU_RLAR_ENABLE_Pos) & SAU_RLAR_ENABLE_Msk);

    /* Set SAU region number */
    SAU->RNR = 2;
    /* Region base address */
    SAU->RBAR = SAU_REGION_2_BASE & SAU_RBAR_BADDR_Msk;
    /* Region end address */
    SAU->RLAR = (SAU_REGION_2_END & SAU_RLAR_LADDR_Msk) | ((1U << SAU_RLAR_NSC_Pos) & SAU_RLAR_NSC_Msk) |
                ((1U << SAU_RLAR_ENABLE_Pos) & SAU_RLAR_ENABLE_Msk);

    /* Force memory writes before continuing */
    __DSB();
    /* Flush and refill pipeline with updated permissions */
    __ISB();

    /* Set SAU Control register: Enable SAU and All Secure (applied only if disabled) */
    SAU->CTRL = ((0U << SAU_CTRL_ALLNS_Pos) & SAU_CTRL_ALLNS_Msk) | ((1U << SAU_CTRL_ENABLE_Pos) & SAU_CTRL_ENABLE_Msk);

    /* AHB configuration */

    /*--------------------------------------------------------------------
     - AHB Security Level Configurations
     -------------------------------------------------------------------*/
    /* Configuration of AHB Secure Controller
       Possible values for every memory sector or peripheral rule:
        0    Non-secure, User access allowed.
        1    Non-secure, Privileged access allowed.
        2    Secure, User access allowed.
        3    Secure, Privileged access allowed.
    */

    /* Security level configuration of MPC checker */
    SECTRL0->FLASH_MEM_RULE                                           = 0x00000033U;
    SECTRL0->ROM_MEM_RULE[0]                                          = 0;
    SECTRL0->ROM_MEM_RULE[1]                                          = 0;
    SECTRL0->ROM_MEM_RULE[2]                                          = 0;
    SECTRL0->ROM_MEM_RULE[3]                                          = 0;
    SECTRL0->RAMX_MEM_RULE0                                           = 0;
    SECTRL0->FLEXSPI0_REGION0_MEM_RULE[0]                             = 0;
    SECTRL0->FLEXSPI0_REGION0_MEM_RULE[1]                             = 0;
    SECTRL0->FLEXSPI0_REGION0_MEM_RULE[2]                             = 0;
    SECTRL0->FLEXSPI0_REGION0_MEM_RULE[3]                             = 0;
    SECTRL0->FLEXSPI0_REGION1_4_MEM_RULE[0].FLEXSPI0_REGION_MEM_RULE0 = 0;
    SECTRL0->FLEXSPI0_REGION1_4_MEM_RULE[1].FLEXSPI0_REGION_MEM_RULE0 = 0;
    SECTRL0->FLEXSPI0_REGION1_4_MEM_RULE[2].FLEXSPI0_REGION_MEM_RULE0 = 0;
    SECTRL0->FLEXSPI0_REGION1_4_MEM_RULE[3].FLEXSPI0_REGION_MEM_RULE0 = 0;
    SECTRL0->RAM00_MEM_RULE0                                          = 0x00003333U;
    SECTRL0->RAM10_MEM_RULE0                                          = 0x00003333U;
    SECTRL0->RAM20_MEM_RULE0                                          = 0;
    SECTRL0->RAM30_MEM_RULE0                                          = 0;
    SECTRL0->RAM40_MEM_RULE0                                          = 0;
    SECTRL0->AHB_SECURE_CTRL_PERIPHERAL_MEM_RULE0                     = 0x00003333U;

    /* Security level configuration of PPC checker */
    SECTRL0->APB_PERIPHERAL_GROUP0_MEM_RULE0            = 0xFCCCCCFFU;
    SECTRL0->APB_PERIPHERAL_GROUP0_MEM_RULE1            = 0xCCCCFFCCU;
    SECTRL0->APB_PERIPHERAL_GROUP0_MEM_RULE2            = 0xFCFFFFFFU;
    SECTRL0->APB_PERIPHERAL_GROUP1_MEM_RULE0            = 0xFFFCCFFFU;
    SECTRL0->APB_PERIPHERAL_GROUP1_MEM_RULE1            = 0xCCCCFCCCU;
    SECTRL0->APB_PERIPHERAL_GROUP1_MEM_RULE2            = 0xFFCFFFFCU;
    SECTRL0->APB_PERIPHERAL_GROUP1_MEM_RULE3            = 0xFFFFFCFFU;
    SECTRL0->AHB_PERIPHERAL0_SLAVE_PORT_P9_SLAVE_RULE0  = 0xCCCCFCCCU;
    SECTRL0->AHB_PERIPHERAL0_SLAVE_PORT_P9_SLAVE_RULE1  = 0xFFFFFFCCU;
    SECTRL0->AHB_PERIPHERAL1_SLAVE_PORT_P10_SLAVE_0     = 0xCCCCCCCCU;
    SECTRL0->AHB_PERIPHERAL2_SLAVE_PORT_P11_SLAVE_RULE0 = 0xFFCCCCCCU;
    SECTRL0->AIPS_BRIDGE_GROUP0_RULE0                   = 0xCCCCCCCFU;
    SECTRL0->AIPS_BRIDGE_GROUP0_RULE1                   = 0xFFFFCCCCU;
    SECTRL0->AIPS_BRIDGE_GROUP1_RULE0                   = 0xCCCCCFFCU;

    /* Security level configuration of masters */
    SECTRL0->MASTER_SEC_LEVEL        = 0x80000000U;
    SECTRL0->MASTER_SEC_ANTI_POL_REG = 0xBFFFFFFFU;

    /*--------------------------------------------------------------------
     - Pins: Reading GPIO state
     -------------------------------------------------------------------*/
    /* Possible values for every pin:
     *  0b0    Deny
     *  0b1    Allow */
    SECTRL0->SEC_GPIO_MASK[0] = 0x9FFFFFFFU;
    SECTRL0->SEC_GPIO_MASK[1] = 0xFFFFFFFFU;
    SECTRL0->SEC_GPIO_MASK[2] = 0xFFFFFFFFU;

    /*--------------------------------------------------------------------
     - Interrupts: Interrupt security configuration
     -------------------------------------------------------------------*/
    /* Possible values for every interrupt:
     *  0b0    Secure
     *  0b1    Non-secure */
    NVIC->ITNS[0] = 0;
    NVIC->ITNS[1] = 0;
    NVIC->ITNS[2] = 0;
    NVIC->ITNS[3] = 0;

    /* Global Options */
    SCB->AIRCR = (SCB->AIRCR & 0x000009FF7U) | 0x005FA0000U;
    SCB->SCR &= 0x0FFFFFFF7U;
    SCB->SHCSR &= 0x0FFF7FFFFU;
    SCB->NSACR                       = 0x00000C03U;
    SCnSCB->CPPWR                    = 0;
    SECTRL0->SEC_GP_REG_LOCK         = (SECTRL0->SEC_GP_REG_LOCK & 0x0FFFFFFC0U) | 0x00000002AU;
    SECTRL0->MASTER_SEC_LEVEL        = (SECTRL0->MASTER_SEC_LEVEL & 0x03FFFFFFFU) | 0x080000000U;
    SECTRL0->MASTER_SEC_ANTI_POL_REG = (SECTRL0->MASTER_SEC_ANTI_POL_REG & 0x03FFFFFFFU) | 0x080000000U;
    SECTRL0->CM33_LOCK_REG[0]        = 0x800002AAU;
    SECTRL0->MISC_CTRL_REG           = (SECTRL0->MISC_CTRL_REG & 0x0FFFF3003U) | 0x000008AA4U;
    SECTRL0->MISC_CTRL_DP_REG        = 0x00008AA5U;
}

/***********************************************************************************************************************
 * BOARD_InitBootTEE function
 **********************************************************************************************************************/
void BOARD_InitBootTEE()
{
    BOARD_InitTrustZone();
}
