/*--------------------------------------------------------------------------*/
/* Copyright 2022 NXP                                                       */
/*                                                                          */
/* NXP Confidential. This software is owned or controlled by NXP and may    */
/* only be used strictly in accordance with the applicable license terms.   */
/* By expressly accepting such terms or by downloading, installing,         */
/* activating and/or otherwise using the software, you are agreeing that    */
/* you have read, and that you agree to comply with and are bound by, such  */
/* license terms. If you do not agree to be bound by the applicable license */
/* terms, then you may not retain, install, activate or otherwise use the   */
/* software.                                                                */
/*--------------------------------------------------------------------------*/

/**
 * @file  mcuxClEcc_TwEd_Internal_VarScalarMult_FUP.c
 * @brief mcuxClEcc: FUP programs for implementation of scalar multiplication with a variable point P on a twisted Edwards curve
 */


#include <internal/mcuxClPkc_FupMacros.h>
#include <internal/mcuxClEcc_EdDSA_Internal_PkcWaLayout.h>
#include <internal/mcuxClEcc_TwEd_Internal_VarScalarMult_FUP.h>

const mcuxClPkc_FUPEntry_t mcuxClEcc_FUP_VarScalarMult_Recover_X_Coordinate[15] MCUX_FUP_ATTRIBUTE = {{0x10u,0x00u,0xffu,0x36u,0x4cu,0x27u},{0x80u,0x00u,0x21u,0x24u,0x00u,0x19u},{0x80u,0x00u,0x22u,0x25u,0x00u,0x1bu},{0x80u,0x00u,0x19u,0x26u,0x00u,0x1du},{0x80u,0x00u,0x1bu,0x27u,0x00u,0x1fu},{0x80u,0x00u,0x12u,0x1fu,0x00u,0x21u},{0x80u,0x00u,0x13u,0x1du,0x00u,0x22u},{0x80u,0x2au,0x10u,0x21u,0x22u,0x1du},{0x80u,0x00u,0x20u,0x1du,0x00u,0x1fu},{0x80u,0x00u,0x24u,0x1fu,0x00u,0x21u},{0x80u,0x00u,0x25u,0x1fu,0x00u,0x22u},{0x80u,0x00u,0x19u,0x27u,0x00u,0x1du},{0x80u,0x00u,0x1bu,0x26u,0x00u,0x1fu},{0x80u,0x2au,0x10u,0x1du,0x1fu,0x1du},{0x80u,0x00u,0x1bu,0x1du,0x00u,0x20u}};
const mcuxClPkc_FUPEntry_t mcuxClEcc_FUP_VarScalarMult_YZMontLadder_LadderStep[29] MCUX_FUP_ATTRIBUTE = {{0x10u,0x00u,0x63u,0xb7u,0xc2u,0xc2u},{0x80u,0x00u,0x0eu,0x0du,0x00u,0x19u},{0x80u,0x00u,0x0fu,0x0cu,0x00u,0x1bu},{0x80u,0x00u,0x1bu,0x1bu,0x00u,0x0fu},{0x80u,0x21u,0x10u,0x1bu,0x19u,0x1bu},{0x80u,0x00u,0x19u,0x19u,0x00u,0x0eu},{0x80u,0x00u,0x1bu,0x1bu,0x00u,0x19u},{0x80u,0x21u,0x10u,0x0fu,0x0eu,0x0fu},{0x80u,0x2au,0x10u,0x19u,0x0fu,0x19u},{0x80u,0x00u,0x21u,0x0fu,0x00u,0x0eu},{0x80u,0x00u,0x19u,0x22u,0x00u,0x1bu},{0x80u,0x2au,0x10u,0x1bu,0x0eu,0x0eu},{0x80u,0x00u,0x21u,0x19u,0x00u,0x1bu},{0x80u,0x00u,0x0fu,0x22u,0x00u,0x19u},{0x80u,0x2au,0x10u,0x19u,0x1bu,0x0fu},{0x80u,0x00u,0x0cu,0x0cu,0x00u,0x1bu},{0x80u,0x00u,0x0du,0x0du,0x00u,0x19u},{0x80u,0x00u,0x1bu,0x1bu,0x00u,0x0cu},{0x80u,0x2au,0x10u,0x1bu,0x19u,0x1bu},{0x80u,0x00u,0x19u,0x19u,0x00u,0x0du},{0x80u,0x00u,0x1bu,0x1bu,0x00u,0x19u},{0x80u,0x2au,0x10u,0x19u,0x0cu,0x19u},{0x80u,0x2au,0x10u,0x0du,0x19u,0x0du},{0x80u,0x00u,0x12u,0x19u,0x00u,0x1bu},{0x80u,0x21u,0x10u,0x0cu,0x1bu,0x0cu},{0x80u,0x2au,0x10u,0x10u,0x0du,0x1bu},{0x80u,0x00u,0x12u,0x1bu,0x00u,0x19u},{0x80u,0x2au,0x10u,0x0cu,0x19u,0x1bu},{0x80u,0x2au,0x10u,0x0du,0x1bu,0x0du}};





