/*--------------------------------------------------------------------------*/
/* Copyright 2020-2021 NXP                                                  */
/*                                                                          */
/* NXP Confidential. This software is owned or controlled by NXP and may    */
/* only be used strictly in accordance with the applicable license terms.   */
/* By expressly accepting such terms or by downloading, installing,         */
/* activating and/or otherwise using the software, you are agreeing that    */
/* you have read, and that you agree to comply with and are bound by, such  */
/* license terms. If you do not agree to be bound by the applicable license */
/* terms, then you may not retain, install, activate or otherwise use the   */
/* software.                                                                */
/*--------------------------------------------------------------------------*/

/**
 * @file  mcuxClEcc_Weier_Internal_PointArithmetic_FUP.c
 * @brief FUP programs for Weierstrass curve internal point arithmetic
 */


#include <internal/mcuxClPkc_FupMacros.h>
#include <internal/mcuxClEcc_Weier_Internal.h>
#include <internal/mcuxClEcc_Weier_Internal_PointArithmetic_FUP.h>

const mcuxClPkc_FUPEntry_t mcuxClEcc_FUP_Weier_DoubleAdd[20] MCUX_FUP_ATTRIBUTE = {{0x10u,0x00u,0xebu,0x2fu,0xf2u,0x80u},{0x80u,0x00u,0x06u,0x06u,0x00u,0x19u},{0x80u,0x00u,0x19u,0x06u,0x00u,0x1bu},{0x80u,0x00u,0x08u,0x19u,0x00u,0x0au},{0x80u,0x00u,0x09u,0x1bu,0x00u,0x0bu},{0x10u,0x00u,0x7bu,0xb3u,0xe5u,0xc3u},{0x80u,0x2au,0x10u,0x05u,0x0bu,0x1bu},{0x80u,0x2au,0x10u,0x04u,0x0au,0x0bu},{0x80u,0x00u,0x06u,0x0bu,0x00u,0x19u},{0x00u,0x1eu,0x00u,0x19u,0x03u,0x06u},{0x80u,0x00u,0x0bu,0x0bu,0x00u,0x19u},{0x80u,0x00u,0x04u,0x19u,0x00u,0x0au},{0x80u,0x00u,0x19u,0x0bu,0x00u,0x04u},{0x80u,0x00u,0x05u,0x04u,0x00u,0x0bu},{0x80u,0x00u,0x1bu,0x1bu,0x00u,0x19u},{0x81u,0x2au,0x10u,0x04u,0x0au,0x04u},{0x80u,0x21u,0x10u,0x04u,0x19u,0x04u},{0x80u,0x2au,0x10u,0x0au,0x04u,0x05u},{0x80u,0x00u,0x05u,0x1bu,0x00u,0x19u},{0x80u,0x2au,0x10u,0x19u,0x0bu,0x05u}};
const mcuxClPkc_FUPEntry_t mcuxClEcc_FUP_Weier_RepeatDouble[24] MCUX_FUP_ATTRIBUTE = {{0x10u,0x00u,0x95u,0xa1u,0x06u,0xe4u},{0x80u,0x00u,0x0eu,0x07u,0x00u,0x19u},{0x80u,0x00u,0x19u,0x19u,0x00u,0x0fu},{0x80u,0x00u,0x0fu,0x0fu,0x00u,0x19u},{0x80u,0x00u,0x12u,0x19u,0x00u,0x0fu},{0x10u,0x00u,0x1cu,0x0du,0xf9u,0x90u},{0x80u,0x00u,0x0cu,0x0cu,0x00u,0x1bu},{0x80u,0x21u,0x10u,0x0fu,0x1bu,0x19u},{0x81u,0x21u,0x10u,0x19u,0x1bu,0x19u},{0x80u,0x21u,0x10u,0x0du,0x0du,0x1bu},{0x80u,0x00u,0x1bu,0x0eu,0x00u,0x1du},{0x00u,0x1eu,0x00u,0x1du,0x03u,0x06u},{0x80u,0x00u,0x1bu,0x0du,0x00u,0x1du},{0x80u,0x21u,0x10u,0x1du,0x1du,0x1bu},{0x80u,0x00u,0x0cu,0x1bu,0x00u,0x1fu},{0x80u,0x00u,0x19u,0x19u,0x00u,0x04u},{0x81u,0x2au,0x10u,0x04u,0x1fu,0x04u},{0x80u,0x2au,0x10u,0x1fu,0x04u,0x1fu},{0x80u,0x00u,0x19u,0x1fu,0x00u,0x05u},{0x80u,0x00u,0x1bu,0x1du,0x00u,0x19u},{0x80u,0x2au,0x10u,0x05u,0x19u,0x05u},{0x10u,0x00u,0x7eu,0x91u,0x25u,0x10u},{0x80u,0x21u,0x10u,0x0fu,0x0fu,0x1bu},{0x80u,0x00u,0x19u,0x1bu,0x00u,0x0fu}};



/* FUP program: repeated point doubling.                        */
/* Prerequisites: **CAUTION** the 5th temp VT is assigned;      */
/*                coefficient a (in MR) is stored in buffer A.  */
/* Input: P = (x,y, z') in (VX2,VY2, VZ2), relative-z;          */
/*        zRef is stored in buffer VZ.                          */
/* Output: P_Dbl = 2P in (VX0,VY0, VZ0), relative-z,            */
/*         supporting result in-place.                          */


/* FUP program: point doubling-addition with mix-coordinates.          */
/* Input:                                                              */
/*   P0 = (x0,y0, z') in (VX0,VY0, VZ0), relative-z;                   */
/*   P1 = (x1,y1, z)  in (VX1,VY1, unused), Jacobian.                  */
/* Output:                                                             */
/* (1 iteration)                                                       */
/*   P'0 := P1 + P0   in relative-z, and                               */
/*   P0 will be updated (according to new z') and stored in (VT2,VT3). */
/* (2 iterations, skip the first 4 operations in the 2nd iteration)    */
/*   P"0 := P1 + 2*P0 in relative-z.                                   */
/* P'0 / P"0 will be stored in (VX0,VY0, VZ0), always result in-place. */
/* Attention:                                                          */
/*   1. P0 != +/- P1, avoid doubling and O (point at infinity);        */
/*   2. VT2 and VT3 are different buffers from VX0/VY0/VZ0/VX1/VY1.    */
