# PSA FF IPC Testcase checklist 

| Tests                                                       | Scenario Rules                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | Client- Server Test Functions Pair                                                                                                                                                                                                   | Test Algorithm/Comments/Test Limitation                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | Rule optional for API compliance? | Is scenario implemented in this release? |
|-------------------------------------------------------------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|--------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|-----------------------------------|------------------------------------------|
| test_i001                                                   | 1. psa_framework_version(): Retrieve the version of the PSA Framework API that is implemented. Manifest field- psa_framework_version: Version of the PSA Firmware Framework specification this manifest conforms to.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | [client/server]_test_psa_framework_version()                                                                                                                                                                                         | Call the psa_framework_version() API from both SPE and NSPE side and compare the return value with PSA_FRAMEWORK_VERSION.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | Mandatory                         | Yes                                      |
|                                                             | 1. psa_version() returns PSA_VERSION_NONE when the RoT Service is not implemented, or the caller is not permitted to access the service OR return > 0 with the  version of the implemented RoT Service.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | [client/server]_test_psa_version()                                                                                                                                                                                                   | 1. Pass un-implemented SID and expects PSA_VERSION_NONE as return value. <br />2. Call to API from NSPE with a SID who doesn't provide service to NSPE and expects PSA_VERSION_NONE as return value. <br />3. Pass SID who is implemented and provides service to NSPE and expect version number(>0) of given RoT service as return value. <br />Perform all above checks from SPE too.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | Mandatory                         | Yes                                      |
| test_i002                                                   | 1. psa_connect() returns the PSA_ERROR_CONNECTION_BUSY when RoT Service cannot make the connection at the moment (transient error). <br />2. psa_connect() returns the PSA_ERROR_CONNECTION_REFUSED when RoT Service has refused the connection <br />3. psa_wait() returns the Secure Partition interrupt signals that have been asserted from a subset of signals provided by the caller. Returns > 0 when at least one signal is asserted <br />4. psa_get():Get the message which corresponds to a given RoT Service signal and remove the message from the queue.  <br />5. psa_get() returns PSA_SUCCESS when *msg will contain the delivered message. <br />6. The type member of the psa_msg_t object should return PSA_IPC_CONNECT for a new connection request following a psa_get() call to psa_connect() and msg.handle must be positive. <br />7. psa_reply():  If the message type is PSA_IPC_CONNECT then server can reject the connection by sending PSA_ERROR_CONNECTION_REFUSED (permanent error) or PSA_ERROR_CONNECTION_BUSY (transient error) status code. <br />                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | [client/server]_test_connection_busy_and_reject()                                                                                                                                                                                    | 1. Client tries to connect to ROT service using psa_connect() <br />2. RoT service checks the delivery of  PSA_IPC_CONNECT message type and positive handle value returned by psa_get()  <br />3. RoT service rejects the connection by executing psa_reply(handle,PSA_ERROR_CONNECTION_BUSY) <br />4. Client tries to connect to same ROT service using psa_connect() again <br />5. This time, RoT service rejects the connection by executing psa_reply(handle,PSA_ERROR_CONNECTION_REFUSED) <br />Perform all above steps from NSPE and SPE both.                                                                                                                                                                                                                                                                                                                                                                                      | Mandatory                         | Yes                                      |
|                                                             | 1. psa_connect(): When SID is implemented and client is permitted to access the service, SPM delivers a PSA_IPC_CONNECT message from the client to the Secure Partition that implements the RoT Service and positive handle is returned to client. <br />2. psa_get():Get the message which corresponds to a given RoT Service signal and remove the message from the queue. <br />3. psa_get() returns PSA_SUCCESS when *msg will contain the delivered message <br />4. psa_get():The type member of the psa_msg_t object should return PSA_IPC_CONNECT for a new connection request following a psa_get() call to psa_connect() and msg.handle must be positive. <br />5. psa_get(): The type member of the psa_msg_t object should return PSA_IPC_DISCONNECT for a new connection request following a psa_get() call to psa_close() and msg.handle must be positive. <br />6. psa_reply():  If the message type is PSA_IPC_CONNECT then server can accept the connection by sending PSA_SUCCESS status code. If the message type is PSA_IPC_DISCONNECT then the status code is ignored. <br />7. psa_close(): Closes a connection to a RoT Service. Sends the PSA_IPC_DISCONNECT message to the RoT Service.  This function will have no effect if called with the null handle. <br />                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | [client/server]_test_accept_and_close_connect()                                                                                                                                                                                      | 1.Client tries to connect to ROT service <br /> 2. RoT service checks the delivery of  PSA_IPC_CONNECT message type and positive handle value return by psa_get() <br />3. RoT service  accepts the connection by executing psa_reply(.., PSA_CONNECTION_ACCEPTED).  <br />4. Client calls the psa_close with PSA_NULL_HANDLE and later it closes the connection using psa_close() with actual handle value <br />5. RoT service checks the delivery of  PSA_IPC_DISCONNECT message type, checks handle value eqaul to NULL returned by psa_get() and completes the PSA_IPC_DISCONNECT by executing psa_reply() . <br />Perform all above steps from NSPE and SPE both.                                                                                                                                                                                                                                                                    | Mandatory                         | Yes                                      |
|                                                             | Following are allowed  version condition to psa_connect(): <br />  1. Version policy is not mentioned and requested version is 1 which is default minimum version  <br />2. Version policy is STRICT and requested version equals minimum version  <br />3. Version policy is relaxed and requested version is smaller than the minimum version  <br /> 4. Version policy is relaxed and requested version is euqal to the minimum version  <br />                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | [client/server]_test_connect_with_allowed_version_policy()                                                                                                                                                                           | Client tries connecting ROT service of following properties and expects connection to establish: <br />  1. Version policy is not mentioned and requested version is 1 which is default minimum version  <br />   2. Version policy is STRICT and requested version equals minimum version  <br />   3. Version policy is relaxed and requested version is smaller than the minimum version  <br />  4. Version policy is relaxed and requested version is equal to the minimum version  <br />Perform all above steps from NSPE and SPE both.                                                                                                                                                                                                                                                                                                                                                                                             | Mandatory                         | Yes                                      |
|                                                             | 1. psa_call(): The valid psa_call makes SPM to send type value(>=) to msg.type of RoT service partition and the successful call should return >=0 handle value.  <br />2. psa_call() receives return value >= 0 for RoT-specific return code <br />3. psa_call() receive return value  < 0 for RoT-specific error code <br />4. psa_reply():  If the message type is request message, all status codes other than PSA_ERROR_PROGRAMMER_ERROR must be reported to the client.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | [client/server]_test_psa_call_with_allowed_status_code()                                                                                                                                                                             | 1. Client connects to RoT service <br />2. Client sends message using psa_call() <br />3.  RoT service checks the delivery of  request message type and positive handle value  return by psa_get()  <br />4. RoT service ends the call using psa_reply(status_code) <br />5. Client checks the return value of psa_call() and Client closes the connectionRepeat (1) to (5) for different status code, SUCCESS, +ve, -ve.. <br />Perform all above steps from NSPE and SPE both.                                                                                                                                                                                                                                                                                                                                                                                                                                                           | Mandatory                         | Yes                                      |
|                                                             | 1. psa_call(): The valid psa_call makes SPM to send type value(>=) to msg.type of RoT service partition<br />                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | [client/server]_test_psa_call_with_allowed_type_values()                                                                                                                                                                             | 1. Client connects to RoT service <br />2. Client sends message using psa_call() with different allowed type values one after another<br />3.  RoT service checks the delivery of different request message type values.<br />Perform all above steps from NSPE and SPE both.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | Mandatory                         | Yes                                      |
|                                                             | 1. A msg.client_id that has a positive value indicates that the client is in the SPE and this the Secure Partition ID of the client. A negative client_id indicates that the client is in the NSPE.  <br />2. Client_id is valid during connection message, request message and disconnect message. <br />3. Manifest Parameter-  name (required, unique) <br />A Partition must have an alphanumeric name for source code to directly refer to a specific Partition. The format of the name must follow the rules of a C macro.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | [client/server]_test_identity()                                                                                                                                                                                                      | - Check the value returned by msg.client_id during various message types. For NSPE connection, client_id should be <0 and for SPE, it should be >0.  <br />Perform all above steps from NSPE and SPE both. <br />- Access the Partition ID of client partition and compare the value with expected ID value.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | Mandatory                         | Yes                                      |
|                                                             | 1. psa_connect() will return the PSA_ERROR_CONNECTION_REFUSED  OR PSA_ERROR_CONNECTION_BUSY when the SPM has reached the limit of concurrent connections                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | [client/server]_test_spm_concurrent_connect_limit()                                                                                                                                                                                  | Execute psa_connect() API in a loop until it returns PSA_CONNECTION_REFUSED or PSA_CONNECTION_BUSY to indicate end of concurrent connections limit. <br />Perform above step from NSPE and SPE both.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | Mandatory                         | Yes                                      |
|                                                             | 1. psa_wait(): When MODE(PSA_BLOCK) is one, the function will block the caller until one of the requested signals is asserted.   <br />2.  psa_wait(): Callers must set RES to zero, implementations must ignore the value of RES. <br />                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | [client/server]_test_psa_block_behave()                                                                                                                                                                                              | 1. Client connects to a RoT service mutilpe times.  <br />2. RoT service psa_wait(PSA_BLOCK|(Non-zero value for timeout[30:0])) API is executed without while(1) loop.  <br />3.  RoT service serves the connections by rejecting them.   <br />This is a sanity check, a successful handshaking between client and server for requested connection  represents check pass. <br />Perform above steps from NSPE and SPE both.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | Mandatory                         | Yes                                      |
|                                                             | 1. psa_wait(): When MODE is zero, the function will return immediately with the current signal state, which can be zero if no signals are active.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | [client/server]_test_psa_poll_behave()                                                                                                                                                                                               | 1. Client connects to a RoT service mutilpe times.  <br />2. RoT service executes psa_wait(PSA_POLL)  in a while loop and checks the API's polling behaviour.  <br />3. Call psa_wait(PSA_POLL) when no request is made by client and checks the return value. <br />Perform above steps from NSPE and SPE both.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | Mandatory                         | Yes                                      |
| test_i003                                                   | 1. The reverse handle for a connection is NULL until psa_set_rhandle() is used.  psa_set_rhandle() can be used to associate some caller-provided private data with a specified client connection. And SPM must provide same rhandle for msg.rhandle with all subsequent messages delivered on this connection. On success the rhandle is retained by the implementation and provided in all future messages on that connection as part of the psa_msg_t structure.  <br />2. Setting the rhandle for a connection during disconnection has no observable effect.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | [client/server]_test_psa_set_rhandle()                                                                                                                                                                                               | 1. Client connects to RoT service and RoT service checks the value of msg.rhanlde value duing PSA_IPC_CONNECT2. Client send call msg to RoT service and RoT service checks the value of msg.rhanlde value duing PSA_IPC_CONNECT <br />3. ROT service sets the rhandle with known value. <br />4. Client send call msg to RoT service and RoT service now compare the value of msg.rhanndle  with previously set value <br />5. ROT service sets the rhandle with known value other than previously set value <br />6. Client send call msg to RoT service and RoT service now compare the value of msg.rhanndle with last set value <br />7. The reverse handle for a connection is NULL until psa_set_rhandle() is used <br />Perform above steps from NSPE and SPE both.                                                                                                                                                                 | Mandatory                         | Yes                                      |
|                                                             | 1. psa_call():The caller can optionally provide one or more buffers to receive a response (out_vec). <br />2. psa_get(): The array in_size provides the size of each client input vector in bytes. The array out_size provides the size of each client output vector in bytes. <br />3. psa_read(): parameter from the client input vector. Streams up to the next num_bytes bytes of client input vector invec_idx in the message identified by msg_handle to the Secure Partition buffer. Returns the number of bytes copied. <br />4. psa_read(): If num_bytes is less than or equal to the available data in the input vector then num_bytes are copied to buffer, and the remaining data in the input vector can be read by subsequent calls to psa_read() with the same msg_handle and invec_idx. <br />5. psa_read(): RoT Services can determine how much data is available to read from the message based on the in_size[] attribute of the psa_msg_t message returned from psa_get(). If an input vector has not been passed by the client then the corresponding in_size[] for that vector is zero. <br />6. psa_read(): If num_bytes is greater than the remaining data in the input vector then the remaining input bytes are copied to buffer and the call returns the number of bytes copied. Any space after this in buffer is not modified. Subsequent calls of psa_read() or psa_skip() with the same message input vector will report that there is no more data in the vector. <br />7. psa_skip(): Skip over part of a client input vector. Advances the current read offset by skipping up to num_bytes bytes for input vector invec_idx in the message identified by msg_handle. psa_skip(): When psa_skip returns, it returns with the number of bytes skipped  <br />8. psa_skip(): If There was no remaining data in this input vector, return zero <br />9.psa_skip(): If num_bytes is greater than the remaining size of the input vector then the remaining size of the input vector is returned. Subsequent calls of psa_read() or psa_skip() with the same message input vector will report that there is no more data in the vector. <br /> | [client/server]_test_call_read_and_skip()                                                                                                                                                                                            | 1.Client connects to RoT service <br />2.Client sends four input vectors to RoT service using psa_call <br />3. RoT service checks following: <br />    - Reporting of input vectors size through msg.in_size <br />    - Input vectors content reading through psa_read <br />    -Inbound /Outbound offset reading <br />    -Inbound/Outbound  offset skipping <br />    -Zero byte read and skip <br />    -out_len=0 check <br />4. Client recieves the status of  RoT service checks and closes the connection <br />Perform above steps from NSPE and SPE both.                                                                                                                                                                                                                                                                                                                                                                     | Mandatory                         | Yes                                      |
|                                                             | 1. psa_call(): The caller can optionally provide one or more buffers to receive a response (out_vec). On return from psa_call() the len value will have been updated to indicate the number of bytes of data written to the buffer by the RoT Service. <br />2. psa_write(): Appends num_bytes of data from buffer to the client output vector outvec_idx in the message identified by msg_handle. Sequential calls using the same msg_handle and outvec_idx will be concatenated in the output vector                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | [client/server]_test_call_and_write()                                                                                                                                                                                                | 1. Client connects to RoT service <br />2. Client sends four output vectors to RoT service using psa_call <br />3. RoT service checks following: <br />  - Reporting of output vectors size through msg.out_size <br />  - in_len=0 check <br />  - zero byte write <br />  - Out vector writes using psa_write <br />   -  Vector write concatenation <br />4. Client recieves the status of RoT service checks, cross check the content of out vectors and closes the connection <br />Perform above steps from NSPE and SPE both.                                                                                                                                                                                                                                                                                                                                                                                                       | Mandatory                         | Yes                                      |
|                                                             | 1.  psa_call():  Any I/O vector of length zero is permitted and will be treated as an empty or non-existent vector by the framework. When less than four vectors are provided to psa_call() for either input or output, then the remaining vectors have zero length and the in_size and out_size elements for these vectors will be zero.A memory reference contains a start address and an associated length. A zero-length memory reference is one where the length is zero. The start address of a zero-length memory reference can safely take any value and must be ignored by the implementation. <br />2. psa_call(): If in_len is zero then in_vec is ignored  <br />3. sa_call(): If out_len is zero then out_vec is ignored  <br />4. psa_get(): If an input and output vector has not been passed by the client then the corresponding in_size[] and out_size[] for that vector is zero.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | [client/server]_test_zero_length_invec()[client/server]_test_zero_length_outvec()                                                                                                                                                    | Test zero lenth input vector: <br />1. Client connects to RoT service <br />2. Client sends three input and one outvec vectors to RoT service using psa_call - invec 0 as zero length vector, invec 1 as NULL and invec 2 and outvec 0 as non-zero length vector <br />3. RoT service checks size of each vectors reported through msg.in_size and msg.out_size <br />4. Client recieves the status of checks and closes the connection <br />Test zero lenth output vector: <br />1. Client connects to RoT service <br />2. Client sends one  input and three outvec vectorsto RoT service using psa_call - outvec 0 as zero length vector, outvec 0 as NULL and invec 0 and outvec 2 as non-zero length vector <br />3. RoT service checks size of each vectors reported through msg.in_size and msg.out_size <br />4. Client recieves the status of checks and closes the connection <br />Perform above steps from NSPE and SPE both. | Mandatory                         | Yes                                      |
|                                                             | 1. When client provides an input and output vectors which are referencing to same memory location, a psa_read after psa_write to the same memory location can return original or modified value.  <br />2. When client provides an input and output vectors which are referencing to same memory location, a psa_write(s) to both memory vectors can return either the 1st or the 2nd value written.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | [client/server]_test_overlapping_vectors                                                                                                                                                                                             | 1. Client provides one input and 2 output vectors which are pointing to same location.  <br />2. RoT service performs read after write operation on to outvec-0 and expects return value either modified one or the original  <br />3. RoT service performs write operation to outvec-1 and unblock the connection. The write performed is to mimic write after write operatio to the overlapping vector. <br />4. Client check the value of outvec. The value should be either the value written by first psa_write or the second psa_write.                                                                                                                                                                                                                                                                                                                                                                                              | Mandatory                         | Yes                                      |
| test_i004                                                   | The call to psa_connect() is PROGRAMMER ERROR if RoT Service does not exist on platform                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | [client/server]_test_sid_does_not_exists()                                                                                                                                                                                           | Call psa_connect with SID which does not exist on a platform and expect PROGRAMMER ERROR behaviour.<br />Perform above step from NSPE and SPE both.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | Optional                          | Yes                                      |
| test_i005                                                   | The call to psa_connect() is PROGRAMMER ERROR if Version policy is STRICT and requested version is HIGHER than minimum version                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | [client/server]_test_strict_policy_higher_version()                                                                                                                                                                                  | Call psa_connect with SID whose version policy is STRICT and requested version is HIGHER than minimum version and expect PROGRAMMER ERROR behaviour.<br />Perform above step from NSPE and SPE both.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | Optional                          | Yes                                      |
| test_i006                                                   | The call to psa_connect() is PROGRAMMER ERROR if Version policy is STRICT and requested version lower than minimum version                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | [client/server]_test_strict_policy_lower_version()                                                                                                                                                                                   | Call psa_connect with SID whose version policy is STRICT and requested version is Lower than minimum version. <br />Perform above step from NSPE and SPE both.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | Optional                          | Yes                                      |
| test_i007                                                   | The call to psa_connect() is PROGRAMMER ERROR if Version policy is RELAXED and requested version is bigger than minimum version                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | [client/server]_test_relax_policy_higher_version()                                                                                                                                                                                   | Call psa_connect with SID whose version policy is RELAXED and requested version is HIGHER than minimum version and expect PROGRAMMER ERROR behaviour. <br />Perform above step from NSPE and SPE both.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | Optional                          | Yes                                      |
| test_i008                                                   | 1. The call to psa_connect() is PROGRAMMER ERROR  if service to non_secure_client is not available <br />2. Manifest parameter - The non_secure_clients field contains a boolean to indicate if it is accessible to NSPE clients. RoT Services are always accessible to SPE clients.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | [client/server]_test_secure_access_only_connection()                                                                                                                                                                                 | Call psa_connect with SID which allow secure only connection and expect PROGRAMMER ERROR behaviour.<br />Perform above step from NSPE and SPE both.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | Optional                          | Yes                                      |
| test_i009                                                   | 1. The call to psa_connect() is PROGRAMMER ERROR if SID is not mentioned in dependencies field. <br />2. Manifest parameter- dependencies (optional) <br />If access between a Secure Partition (acting as client) and a RoT Service (acting as server) is not specified in the manifest, then the client is not permitted to connect to the RoT Service.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | [client/server]_test_unspecified_dependent_sid()                                                                                                                                                                                     | Call psa_connect with SID which is not mentioned in dependencies list in manifest and expect PROGRAMMER ERROR behaviour.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | Optional                          | Yes                                      |
| test_i010                                                   | It is not required for the version or version_policy attributes to be specified. If they are not specified in the manifest, the RoT Service will have default attributes of version=1 and version_policy="STRICT". In this case, the call to psa_connect() is PROGRAMMER ERROR if requested version higher than minimum version.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | [client/server]_test_unspecified_policy_with_higher_version()                                                                                                                                                                        | Call psa_connect with SID whose version policy is not mentioned in the manifest and requested SID version is HIGHER than minimum version and expect PROGRAMMER ERROR behaviour. <br />Perform above step from NSPE and SPE both.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | Optional                          | Yes                                      |
| test_i011                                                   | 1. It is not required for the version or version_policy attributes to be specified. If they are not specified in the manifest, the RoT Service will have default attributes of version=1 and version_policy="STRICT"".  In this case, the call to psa_connect() is PROGRAMMER ERROR if requested version lower than minimum version <br />                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 |                                                                                                                                                                                                                                      |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            |                                   |                                          |
| 2. RoT Service version must be non-zero positive integer.." | [client/server]_test_unspecified_policy_with_lower_version()                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | Call psa_connect with SID whose Version policy is not mentioned in the manifest and requested SID version is lower(0) than minimum version(1) and expect PROGRAMMER ERROR behaviour.<br />Perform above step from NSPE and SPE both. | Optional                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | Yes                               |                                          |
| test_i012                                                   | The call to psa_close() is PROGRAMMER ERROR if an invalid handle was provided that is not the null handle                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | [client/server]_test_psa_close_with_invalid_handle()                                                                                                                                                                                 | Call psa_close with INVALID_HANDLE which is not NULL and expect PROGRAMMER ERROR behaviour.<br />Perform above step from NSPE and SPE both.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | Optional                          | Yes                                      |
| test_i013                                                   | The call to psa_get() is PROGRAMMER ERROR if signal has more than a single bit set                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | [client/server]_test_psa_get_with_more_than_one_signal()                                                                                                                                                                             | Call psa_get with a signal who has more than a single bit set and expect PROGRAMMER ERROR behaviour.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | Optional                          | Yes                                      |
| test_i014                                                   | After a RoT Service message is signaled, psa_get() function is used to retrieve the message details. Each message can only be retrieved once.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | [client/server]_test_psa_get_called_twice()                                                                                                                                                                                          | Call psa_get with a valid signal back to back and expect PROGRAMMER ERROR behaviour.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | Optional                          | Yes                                      |
| test_i015                                                   | The call to psa_get() is PROGRAMMER ERROR  if signal does not correspond to a RoT Service                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | [client/server]_test_psa_get_with_non_rot_signal()                                                                                                                                                                                   | Call psa_get with DOORBELL signal and expect PROGRAMMER ERROR behaviour for API call.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | Optional                          | Yes                                      |
| test_i016                                                   | The call to psa_get() is PROGRAMMER ERROR if The RoT Service signal is not currently asserted                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | [client/server]_test_psa_get_with_unasserted_signal()                                                                                                                                                                                | Call psa_get with singal which is currently not asserted and expect PROGRAMMER ERROR behaviour for API call.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | Optional                          | Yes                                      |
| test_i017                                                   | Each RoT Service listed creates a dependency from the client Partition to a server Partition. Within the resulting network of dependencies, there must be no circular dependencies between Secure Partitions. This would result in deadlock because the Service requests are always synchronous.For the same reason, a Secure Partition must not use a RoT Service that is defined within itself. Direct function calls must be used instead of IPC where there is a dependency between RoT Services within a single Secure Partition.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | [client/server]_test_partition_calling_its_own_rot_service()                                                                                                                                                                         | Partition calling its own ROT service using psa_connect and expect PROGRAMMER ERROR behaviour for API call.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | Optional                          | Yes                                      |
| test_i018                                                   | The call to psa_set_rhandle() is PROGRAMMER ERROR  if an invalid message handle was provided                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | [client/server]_test_psa_set_rhandle_with_invalid_handle()                                                                                                                                                                           | Call psa_set_rhanlde with an INVALID_HANDLE which is not NULL and expect PROGRAMMER ERROR behaviour for API call                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | Optional                          | Yes                                      |
| test_i019                                                   | The call to psa_set_rhandle() is PROGRAMMER ERROR if Null handle was passed                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | [client/server]_test_psa_set_rhandle_with_null_handle()                                                                                                                                                                              | Call psa_set_rhanlde with NULL handle and expect PROGRAMMER ERROR behaviour for API call.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | Optional                          | Yes                                      |
| test_i020                                                   | If messgae type if is PSA_IPC_CONNECT then use of status values in psa_reply() other than PSA_SUCCESS, PSA_ERROR_CONNECTION_BUSY and PSA_ERROR_CONNECTION_REFUSED is a PROGRAMMER ERROR.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | [client/server]_test_psa_reply_with_invalid_connect_status_code()                                                                                                                                                                    | Call to psa_reply during PSA_IPC_CONNECT with status code other than PSA_SUCCESS and PSA_CONNECTION_REFUSED and expect PROGRAMMER ERROR behaviour for API call.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | Optional                          | Yes                                      |
| test_i021                                                   | 1. psa_wait() returns the Secure Partition interrupt signals that have been asserted from the subset of signals indicated in the bitmask provided. (psa_wait API to recieve interrupt signal) <br />                                                                      2. psa_eoi():Informs the SPM that an interrupt has been handled (end of interrupt). This will re-enable the interrupt line. <br />3.psa_eoi(): A signal remains active until it is processed by psa_eoi <br />3. Manifest- irqs (optional, unique)<br />This attribute is a list of IRQ lines which are assigned to the Secure Partition.A Secure Partition always has exclusive access to an assigned IRQ. Secure Partitions are not allowed to share IRQs with other Secure Partitions.<br />Each IRQ specified must provide a signal field. This field contains a symbolic name for the signal, used by the SPM to indicate when the interrupt is asserted. <br />Each IRQ source is declared using the source field. This is a string which identifies the interrupt source in an IMPLEMENTATION DEFINED manner.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             |                                                                                                                                                                                                                                      | Generate interrupt for driver partition assigned irq source and checks that:<br />- interrupt is routed to driver patition <br />- psa_wait returns the required irq_signal value<br />- end of interrupt using psa_eoi<br />Test Limitation: Rules around sharing of irq lines can't be tested as specifiying it can result into build error.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | Mandatory                         | Yes                                      |
| test_i022                                                   | The call to psa_reply() is PROGRAMMER ERROR if the message handle is invalid                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | [client/server]_test_psa_reply_with_invalid_handle()                                                                                                                                                                                 | Call psa_reply with an INVALID_HANDLE which is not NULL and expect PROGRAMMER ERROR behaviour for API call.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | Optional                          | Yes                                      |
| test_i023                                                   | The call to psa_reply() is PROGRAMMER ERROR if the message handle is null handle                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | [client/server]_test_psa_reply_with_null_handle()                                                                                                                                                                                    | Call psa_reply with a NULL HANDLE                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | Optional                          | Yes                                      |
| test_i024                                                   | The call to psa_call() is PROGRAMMER ERROR if an invalid handle was passed                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | [client/server]_test_psa_call_with_invalid_handle()                                                                                                                                                                                  | Call psa_call with an INVALID_HANDLE which is not NULL and expect PROGRAMMER ERROR behaviour for API call.Perform this step from NSPE and SPE both.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | Optional                          | Yes                                      |
| test_i025                                                   | The call to psa_call() is PROGRAMMER ERROR if an null handle was passed                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | [client/server]_test_psa_call_with_null_handle()                                                                                                                                                                                     | Call psa_call with a NULL HANDLE and expect PROGRAMMER ERROR behaviour for API call.<br />Perform this step from NSPE and SPE both.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | Optional                          | Yes                                      |
| test_i026                                                   | The call to psa_call() is PROGRAMMER ERROR  if  in_len + out_len > PSA_MAX_IOVEC                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | [client/server]_test_psa_call_with_iovec_more_than_max_limit()                                                                                                                                                                       | Call psa_call with more than four IOVECs and expect PROGRAMMER ERROR behaviour for API call. <br />Perform this step from NSPE and SPE both.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | Optional                          | Yes                                      |
| test_i027                                                   | If the message type is request message and the client has made an invalid request, then the RoT Service can request for the connection to be terminated by calling psa_reply() with return value PSA_ERROR_PROGRAMMER_ERROR. After this, the RoT Service will receive no further request messages on that connection. The SPM will deliver a PSA_IPC_DISCONNECT to the RoT Service to release any resources associated with that connection. <br />If the SPM does not restart the system in response to the above PROGRAMMER ERROR, then termination of the connection has the following effects:<br />- No further request messages will be received by the RoT Service for the connection.<br />- The RoT Service will receive a PSA_IPC_DISCONNECT message for the connection to release resources and reset state associated with the connection.<br />- The failing call to psa_call() will return PSA_ERROR_PROGRAMMER_ERROR.<br />- Subsequent calls to psa_call() on the same connection will immediately return PSA_ERROR_PROGRAMMER_ERROR.<br />- The client must call psa_close() to close the connection.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | [client/server]_test_psa_drop_connection()                                                                                                                                                                                           | RoT service executes psa_reply with status code equal to PSA_ERROR_PROGRAMMER_ERROR during request message.Client expects either PSA_ERROR_PROGRAMMER_ERROR as returned status code for psa_call or system to get paniced <br />Perform above steps from NSPE and SPE both.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | Optional                          | Yes                                      |
| test_i028                                                   | The call to psa_read() is PROGRAMMER ERROR if  msg_handle does not refer to a request message                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | [client/server]_test_psa_read_at_ipc_connect()                                                                                                                                                                                       | Call psa_read during PSA_IPC_CONNECT and expect PROGRAMMER ERROR behaviour for API call.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | Optional                          | Yes                                      |
| test_i029                                                   | The call to psa_read() is PROGRAMMER ERROR  if msg_handle does not refer to a request message                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | [client/server]_test_psa_read_at_ipc_disconnect()                                                                                                                                                                                    | Call psa_read during PSA_IPC_DISCONNECT and expect PROGRAMMER ERROR behaviour for API call.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | Optional                          | Yes                                      |
| test_i030                                                   | The call to psa_read() is PROGRAMMER ERROR if Null handle was passed                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | [client/server]_test_psa_read_with_null_handle()                                                                                                                                                                                     | Call psa_read with NULL handle and expect PROGRAMMER ERROR behaviour for API call.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | Optional                          | Yes                                      |
| test_i031                                                   | The call to psa_read() is PROGRAMMER ERROR if  Invalid handle was passed                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | [client/server]_test_psa_read_with_invalid_handle()                                                                                                                                                                                  | Calll psa_read with INVALID_HANDLE which is not NULL and expect PROGRAMMER ERROR behaviour for API call.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | Optional                          | Yes                                      |
| test_i032                                                   | The call to psa_read() is PROGRAMMER ERROR if invec_idx is equal to PSA_MAX_IOVEC                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | [client/server]_test_psa_read_with_invec_equal_to_max_iovec()                                                                                                                                                                        | Call psa_read with invec_idx=PSA_MAX_IOVEC and expect PROGRAMMER ERROR behaviour for API call.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | Optional                          | Yes                                      |
| test_i033                                                   | The call to psa_read() is PROGRAMMER ERROR if  invec_idx is greater than PSA_MAX_IOVEC                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | [client/server]_test_psa_read_with_invec_greater_than_max_iovec()                                                                                                                                                                    | Call psa_read with invec_idx>PSA_MAX_IOVEC and expect PROGRAMMER ERROR behaviour for API call.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | Optional                          | Yes                                      |
| test_i034                                                   | The call to psa_skip() is PROGRAMMER ERROR  if  msg_handle does not refer to a request message                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | [client/server]_test_psa_skip_at_ipc_connect()                                                                                                                                                                                       | Call psa_skip during PSA_IPC_CONNECT and expect PROGRAMMER ERROR behaviour for API call.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | Optional                          | Yes                                      |
| test_i035                                                   | The call to psa_skip() is PROGRAMMER ERROR if  msg_handle does not refer to a request message                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | [client/server]_test_psa_skip_at_ipc_disconnect()                                                                                                                                                                                    | Call psa_skip during PSA_IPC_DISCONNECT and expect PROGRAMMER ERROR behaviour for API call.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | Optional                          | Yes                                      |
| test_i036                                                   | The call to psa_skip() is PROGRAMMER ERROR if   Null handle was passed                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | [client/server]_test_psa_skip_with_null_handle()                                                                                                                                                                                     | Call psa_skipwith NULL handle and expect PROGRAMMER ERROR behaviour for API call.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | Optional                          | Yes                                      |
| test_i037                                                   | The call to psa_skip() is PROGRAMMER ERROR if  Invalid handle was passed                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | [client/server]_test_psa_skip_with_invalid_handle()                                                                                                                                                                                  | Calll psa_skip with INVALID_HANDLE which is not NULL and expect PROGRAMMER ERROR behaviour for API call.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | Optional                          | Yes                                      |
| test_i038                                                   | The call to psa_skip() is PROGRAMMER ERROR  if  invec_idx is equal to PSA_MAX_IOVEC                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | [client/server]_test_psa_skip_with_invec_equal_to_max_iovec()                                                                                                                                                                        | Call psa_skip with invec_idx=PSA_MAX_IOVEC and expect PROGRAMMER ERROR behaviour for API call.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | Optional                          | Yes                                      |
| test_i039                                                   | The call to psa_skip() is PROGRAMMER ERROR if  invec_idx is greater than PSA_MAX_IOVEC                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | [client/server]_test_psa_skip_with_invec_greater_than_max_iovec()                                                                                                                                                                    | Call psa_skip with invec_idx>PSA_MAX_IOVEC and expect PROGRAMMER ERROR behaviour for API call.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | Optional                          | Yes                                      |
| test_i040                                                   | The call to psa_write() is PROGRAMMER ERROR if msg_handle does not refer to a request message                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | [client/server]_test_psa_write_at_ipc_connect()                                                                                                                                                                                      | Call psa_write during PSA_IPC_CONNECT and expect PROGRAMMER ERROR behaviour for API call.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | Optional                          | Yes                                      |
| test_i041                                                   | The call to psa_write() is PROGRAMMER ERROR  if  msg_handle does not refer to a request message                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | [client/server]_test_psa_write_at_ipc_disconnect()                                                                                                                                                                                   | Call psa_write during PSA_IPC_DISCONNECT and expect PROGRAMMER ERROR behaviour for API call.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | Optional                          | Yes                                      |
| test_i042                                                   | The call to psa_write() is PROGRAMMER ERROR  if Null handle was passed                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | [client/server]_test_psa_write_with_null_handle()                                                                                                                                                                                    | Call psa_write with NULL handle and expect PROGRAMMER ERROR behaviour for API call.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | Optional                          | Yes                                      |
| test_i043                                                   | The call to psa_write() is PROGRAMMER ERROR if  Invalid handle was passed                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | [client/server]_test_psa_write_with_invalid_handle()                                                                                                                                                                                 | Calll psa_write with INVALID_HANDLE which is not NULL and expect PROGRAMMER ERROR behaviour for API call.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | Optional                          | Yes                                      |
| test_i044                                                   | The call to psa_write() is PROGRAMMER ERROR  if  invec_idx is equal to PSA_MAX_IOVEC                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | [client/server]_test_psa_write_with_invec_equal_to_max_iovec()                                                                                                                                                                       | Call psa_write with invec_idx=PSA_MAX_IOVEC and expect PROGRAMMER ERROR behaviour for API call.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | Optional                          | Yes                                      |
| test_i045                                                   | The call to psa_write() is PROGRAMMER ERROR if  invec_idx is greater than PSA_MAX_IOVEC                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | [client/server]_test_psa_write_with_invec_greater_than_max_iovec()                                                                                                                                                                   | Call psa_write with invec_idx>PSA_MAX_IOVEC and expect PROGRAMMER ERROR behaviour for API call.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | Optional                          | Yes                                      |
| test_i046                                                   | The call to psa_write() is PROGRAMMER ERROR if  the call attempts to write data past the end of the client output vector                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | [client/server]_test_psa_write_with_size_overflow()                                                                                                                                                                                  | Call psa_write with a size input one byte bigger than allowed size and expect PROGRAMMER ERROR behaviour for API call.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | Optional                          | Yes                                      |
| test_i047                                                   | The call to psa_get() is PROGRAMMER ERROR if  The msg pointer provided is not a valid memory reference                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | [client/server]_test_psa_get_with_invalid_msg_pointer()                                                                                                                                                                              | Call psa_get with invalid msg pointer and expect PROGRAMMER ERROR behaviour for API call.<br /> Selection of invalid pointer is as below:<br />if (ISOLATION_LEVEL > 1)<br />     // PSA RoT Pointer <br />      psa_get(msg_pointer = driver_mmio_base);<br />else<br />      psa_get(msg_pointer = NULL);<br />                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | Optional                          | Yes                                      |
| test_i048                                                   | The call to psa_call() is PROGRAMMER ERROR  if address of in_vec is invalid for client                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | [client/server]_test_psa_call_with_invalid_invec_pointer                                                                                                                                                                             | Call psa_call with invalid address for invec and expect PROGRAMMER ERROR behaviour for API call.<br /> Selection of invalid invec pointer is as below:<br />     if caller == NONSECURE<br />        // PSA RoT pointer<br />        invec_pointer = driver_mmio_base;<br /><br />     else<br /><br />        if (ISOLATION_LEVEL > 1)<br />           invec_pointer = driver_mmio_base;<br />        else<br />           invec_pointer = NULL;                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | Optional                          | Yes                                      |
| test_i049                                                   | The call to psa_call() is PROGRAMMER ERROR if  address of out_vec is invalid for client                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | [client/server]_test_psa_call_with_invalid_outvec_pointer()                                                                                                                                                                          | Call psa_call with invalid address for outvec and expect PROGRAMMER ERROR behaviour for API call.<br /> Selection of invalid outvec pointer is as below:<br />     if caller == NONSECURE<br />        // PSA RoT pointer<br />        outvec_pointer = driver_mmio_base;<br /><br />     else<br /><br />        if (ISOLATION_LEVEL > 1)<br />           outvec_pointer = driver_mmio_base;<br />        else<br />           outvec_pointer = NULL;                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | Optional                          | Yes                                      |
| test_i050                                                   | The call to psa_call() is PROGRAMMER ERROR if psa_invec.base address is invalid for client                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | [client/server]_test_psa_call_with_invalid_invec_base()                                                                                                                                                                              | Call psa_call with invalid address for psa_invec.base and expect PROGRAMMER ERROR behaviour for API call.<br /> Selection of invalid base is as below:<br />     if caller == NONSECURE<br />        // PSA RoT pointer<br />        invalid_base = driver_mmio_base;<br /><br />     else<br /><br />        if (ISOLATION_LEVEL > 1)<br />           invalid_base = driver_mmio_base;<br />        else<br />           invalid_base = NULL;                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | Optional                          | Yes                                      |
| test_i051                                                   | The call to psa_call() is PROGRAMMER ERROR if psa_outvec.base address is invalid for client                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | [client/server]_test_psa_call_with_invalid_outvec_base()                                                                                                                                                                             | Call psa_call with invalid address for psa_outvec.base and expect PROGRAMMER ERROR behaviour for API call.<br /> Selection of invalid base is as below:<br />     if caller == NONSECURE<br />        // PSA RoT pointer<br />        invalid_base = driver_mmio_base;<br /><br />     else<br /><br />        if (ISOLATION_LEVEL > 1)<br />           invalid_base = driver_mmio_base;<br />        else<br />           invalid_base = NULL;                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | Optional                          | Yes                                      |
| test_i052                                                   | The call to psa_call() is PROGRAMMER ERROR  if psa_invec.base addr is valid but  psa_invec.base+size address is invalid for client                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | [client/server]_test_psa_call_with_invalid_invec_end_addr()                                                                                                                                                                          | Call psa_call with valid address for psa_invec.base but (psa_invec.base + psa_invec.size) pointing to invalid address and expect PROGRAMMER ERROR behaviour for API call.<br /> Selection of base and size are as below:<br />     if caller == NONSECURE<br />          valid_base = nspe_mmio_region_base;<br />          invalid_size = (driver_mmio_region_base - nspe_mmio_region_base + 1);<br /><br />     else<br /><br />        if (ISOLATION_LEVEL > 1)<br />          valid_base = server_mmio_region_base;<br />          invalid_size = (driver_mmio_region_base - server_mmio_region_base + 1);<br />                                                                                                                                                                                                                                                                                                                       | Optional                          | Yes                                      |
| test_i053                                                   | The call to psa_call() is PROGRAMMER ERROR if psa_outvec.base addr is valid but  psa_invec.base+sizeaddress is invalid for client                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | [client/server]_test_psa_call_with_invalid_outvec_end_addr()                                                                                                                                                                         | Call psa_call with valid address for psa_outvec.base but (psa_outvec.base + psa_outvec.size) pointing to invalid address and expect PROGRAMMER ERROR behaviour for API call.<br /> Selection of base and size are as below:<br />     if caller == NONSECURE<br />          valid_base = nspe_mmio_region_base;<br />          invalid_size = (driver_mmio_region_base - nspe_mmio_region_base + 1);<br /><br />     else<br /><br />        if (ISOLATION_LEVEL > 1)<br />          valid_base = server_mmio_region_base;<br />          invalid_size = (driver_mmio_region_base - server_mmio_region_base + 1);<br />                                                                                                                                                                                                                                                                                                                    | Optional                          | Yes                                      |
| test_i054                                                   | The call to psa_call() is PROGRAMMER ERROR  if psa_outvec.base is not writable                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | [client/server]_test_psa_call_with_not_writable_outvec_base()                                                                                                                                                                        | Call psa_call with not writable (code address) psa_outvec.base and expect PROGRAMMER ERROR behaviour for API call.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | Optional                          | Yes                                      |
| test_i055                                                   | The call to psa_read() is PROGRAMMER ERROR if the memory reference for buffer is invalid                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | [client/server]_test_psa_read_with_invalid_buffer_addr()                                                                                                                                                                             | Call psa_read with invalid buffer addr and expect PROGRAMMER ERROR behaviour for API call.<br />Selection of buffer address is as below:<br />if (ISOLATION_LEVEL > 1)<br />          buffer = driver_mmio_region_base;<br />else <br />         buffer = NULL; <br />                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | Optional                          | Yes                                      |
| test_i056                                                   | The call to psa_read() is PROGRAMMER ERROR if the memory reference for buffer is not writable                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | [client/server]_test_psa_read_with_not_writable_buffer_addr()                                                                                                                                                                        | Call psa_read with not writable address (function address- code memory)  and expect PROGRAMMER ERROR behaviour for API call.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | Optional                          | Yes                                      |
| test_i057                                                   | The call to psa_write() is PROGRAMMER ERROR if the memory reference for buffer is invalid                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | [client/server]_test_psa_write_with_invalid_buffer_addr()                                                                                                                                                                            | Call psa_write with invalid buffer addr and expect PROGRAMMER ERROR behaviour for API call.<br /> Selection of buffer address is as below:<br />if (ISOLATION_LEVEL > 1)<br />          buffer = driver_mmio_region_base;<br />else <br />         buffer = NULL; <br />                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | Optional                          | Yes                                      |
| test_i058                                                   | 1. psa_notify() is used to asynchronously wake up another Secure Partition. The receiving partition uses psa_wait() to detect, or wait for, assertion of its PSA_DOORBELL signal. The value of partition_id must be greater than zero as the target of notification must be a Secure Partition. <br />2. psa_clear() clears the PSA_DOORBELL signal.  <br />3. psa_clear(): The target Partition doorbell will remain asserted until it calls psa_clear().                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | [client/server]_test_psa_doorbell_signal()                                                                                                                                                                                           | 1. Client connects to RoT service. <br />2. RoT services executes asserts PSA_DOORBELL singal back to client after accepting the connection.<br />3. Client checks the delivery of PSA_DOORBELL singal using psa_wait().<br />4. Client clears the doorbell and closes the connection. <br />5. RoT service receives the closing connection request.<br />                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | Mandatory                         | Yes                                      |
| test_i059                                                   | The call to psa_notify() is PROGRAMMER ERROR  if Partition ID does not correspond to a Secure Partition                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | [client/server]_test_psa_notify_with_neg_part_id()                                                                                                                                                                                   | Call psa_notify with negative partition id and expect PROGRAMMER ERROR behaviour for API call.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | Optional                          | Yes                                      |
| test_i060                                                   | The call to psa_notify() is PROGRAMMER ERROR if Partition ID does not correspond to a Secure Partition                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | [client/server]_test_psa_notify_with_invalid_pos_part_id()                                                                                                                                                                           | Call psa_notify with positive partition id which does not exist in the platform and expect PROGRAMMER ERROR behaviour for API call.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | Optional                          | Yes                                      |
| test_i061                                                   | The call to psa_clear() is PROGRAMMER ERROR if The Secure Partitions doorbell signal is not currently asserted                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | [client/server]_test_psa_clear_at_unasserted_doorbell_sig()                                                                                                                                                                          | Call psa_clear when doorbell signal is not asserted and expect PROGRAMMER ERROR behaviour for API call.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | Optional                          | Yes                                      |
| test_i062                                                   | The call to psa_wait() is PROGRAMMER ERROR if signal_mask does not include any assigned signals.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | [client/server_test_psa_wait_with_unassigned_signal()                                                                                                                                                                                | Call psa_wait with signal mask that doesn't include any assigned signal and expect PROGRAMMER ERROR behaviour for API call.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | Optional                          | Yes                                      |
| test_i063                                                   | psa_wait() returns the Secure Partition interrupt signals that have been asserted from the subset of signals indicated in the bitmask provided. The mask must contain the set of signals the caller is interested in handling. Signals that are not in signal_mask should be ignored.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | [client/server]_test_psa_wait_signal_mask()                                                                                                                                                                                          | 1. Select signal_mask =   (SERVER_UNSPECIFED_VERSION_SIG | SERVER_RELAX_VERSION_SIG); <br />2. Server partition requests the client partition to make connection using  sid=SERVER_SECURE_CONNECT_ONLY_SID.  This connection request act as irritator to psa_wait(signal_mask) call and it is used to cover the rule - Signals that are not in signal_mask should be ignored by psa_wait.<br />3. NSPE client connects to a server partition using SID whose signal are part of signal_mask<br />4. Server partition executes psa_wait with necessary signal_mask. RoT service checks that returned signal value is subset of signals indicated in the signal_mask <br /> 5. At the end, server partition completes the starved (irritator) connection request of SERVER_SECURE_CONNECT_ONLY_SID.                                                                                                                                          | Mandatory                         | Yes                                      |
| test_i064                                                   | The call to psa_eoi() is PROGRAMMER ERROR if irq_signal is not an interrupt signal                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | driver_test_psa_eoi_with_non_intr_signal()                                                                                                                                                                                           | Call to psa_eoi with non-interrupt signal(PSA_DOORBELL) and expect PROGRAMMER ERROR behaviour for API call.<br /> Note: The interrupt related test check is captured in driver_partition.c as this is the only partition in test suite that holds the interrupt source.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | Optional                          | Yes                                      |
| test_i065                                                   | The call to psa_eoi() is PROGRAMMER ERROR if irq_signal is not currently asserted                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | driver_test_psa_eoi_with_unasserted_signal()                                                                                                                                                                                         | Call to psa_eoi with interrupt signal which is currently not asserted and expect PROGRAMMER ERROR behaviour for API call.<br /> Note: The interrupt related test check is captured in driver_partition.c as this is the only partition in test suite that holds the interrupt source.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | Optional                          | Yes                                      |
| test_i066                                                   | The call to psa_eoi() is PROGRAMMER ERROR if irq_signal indicates more than one signal                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | driver_test_psa_eoi_with_multiple_signals()                                                                                                                                                                                          | Call to psa_eoi with irq_signal provided with multiple signals and expect PROGRAMMER ERROR behaviour for API call.<br /> Note: The interrupt related test check is captured in driver_partition.c as this is the only partition in test suite that holds the interrupt source.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | Optional                          | Yes                                      |
| test_i067                                                   | A Secure Partition is guaranteed to be able to read and write its private heap regions.<br />Manifest Parameter- heap_size. Properties: Optional.<br />This attribute indicates the Secure Partitions heap size in bytes.The size value is represented either as a positive integer or as a hexadecimal string.If this field is specified in the manifest then the value must be greater than 0. If this field is not specified in the manifest then the SPM can assume the size is 0.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | [client/server]_test_dynamic_mem_alloc_fn()                                                                                                                                                                                          | Test dynamic memory service functions-malloc(), free() and realloc behaviour defined in the specification if these APIs are available to secure partition. Otherwise skip the test. <br />                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | Mandatory                         | Yes                                      |
| test_i068                                                   | Only Code is executable in secure partition. Writable region must not be executable.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | client_test_instr_exec_from_writable_mem()                                                                                                                                                                                           | Execute set of instructions from writable memory and expect internal fault.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | Optional                          | Yes                                      |
| test_i069                                                   | Only Private data is writable in secure partition. Code space must not be writable.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | client_test_write_to_code_space()                                                                                                                                                                                                    | Write to code space from secure partition and expect internal fault                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | Optional                          | Yes                                      |
| test_i070                                                   | Only Private data is writable in secure partition. Constant data space must not be writable.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | client_test_write_to_const_data()                                                                                                                                                                                                    | Write to constant data space and expect internal fault                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | Optional                          | Yes                                      |
| test_i071                                                   | The following memory manipulation functions from <string.h>must be implemented with standard C99 definitions:<br />memcmp()<br />memcpy()<br />memmove()<br />memset()                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | client_test_mem_manipulation_fn()                                                                                                                                                                                                    | 1 .Set buffer content using memset(). Check that content is set as expected.<br />2. Copy one buffer to another buffer using memcpy() and check that buffer is copied correctly. <br />3. Compare two buffers two times, once with equal data and once with unequal data.<br />2. Copy one buffer to another buffer using memmove() and check that buffer is copied correctly. <br />                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | Mandatory                         | Yes                                      |
| test_i072                                                   | If domain A needs protection from domain B, then Private data in domain A cannot be accessed by domain B. <br />Where A is Application RoT, B is NSPE and memory asset to be protected is Application RoT variables- Global variable.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | [client/server]_test_nspe_read_app_rot_variable()<br />[client/server]_test_nspe_write_app_rot_variable()                                                                                                                            | Access Application RoT global variable address from NSPE and expect internal fault behavior                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | Optional                          | Yes                                      |
| test_i073                                                   | If domain A needs protection from domain B, then Private data in domain A cannot be accessed by domain B. <br />Where A is Application RoT, B is NSPE and memory asset to be protected is Application RoT execution stack.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | [client/server]_test_nspe_read_app_rot_stack()<br />[client/server]_test_nspe_write_app_rot_stack()                                                                                                                                  | Access Application RoT local variable(stack region) address from NSPE and expect internal fault behavior                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | Optional                          | Yes                                      |
| test_i074                                                   | If domain A needs protection from domain B, then Private data in domain A cannot be accessed by domain B. <br />Where A is Application RoT, B is NSPE and memory asset to be protected is Application RoT heap memory.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | [client/server]_test_nspe_read_app_rot_heap()<br />[client/server]_test_nspe_write_app_rot_heap()                                                                                                                                    | Access Application RoT heap memory address from NSPE and expect internal fault behavior                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | Optional                          | Yes                                      |
| test_i075                                                   | If domain A needs protection from domain B, then Private data in domain A cannot be accessed by domain B. <br />Where A is Application RoT, B is NSPE and memory asset to be protected is Application RoT MMIO region.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | [client/server]_test_nspe_read_app_rot_mmio()<br />[client/server]_test_nspe_write_app_rot_mmio()                                                                                                                                    | Access Application RoT MMIO address from NSPE and expect internal fault behavior                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | Optional                          | Yes                                      |
| test_i076                                                   | If domain A needs protection from domain B, then Private data in domain A cannot be accessed by domain B. <br />Where A is PSA RoT, B is NSPE and memory asset to be protected is PSA RoT variables- Global variable.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | client_test_nspe_read_psa_rot_variable()<br />driver_test_isolation_psa_rot_data_rd()<br />client_test_nspe_write_psa_rot_variable()<br />driver_test_isolation_psa_rot_data_wr()                                                    | Access PSA RoT global variable address from NSPE and expect internal fault behavior                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | Optional                          | Yes                                      |
| test_i077                                                   | If domain A needs protection from domain B, then Private data in domain A cannot be accessed by domain B. <br />Where A is PSA RoT, B is NSPE and memory asset to be protected is PSA RoT execution stack.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | client_test_nspe_read_psa_rot_stack()<br />driver_test_isolation_psa_rot_stack_rd()<br />client_test_nspe_write_psa_stack_variable()<br />driver_test_isolation_psa_rot_stack_wr()                                                   | Access PSA RoT local variable(stack region) address from NSPE and expect internal fault behavior                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | Optional                          | Yes                                      |
| test_i078                                                   | If domain A needs protection from domain B, then Private data in domain A cannot be accessed by domain B. <br />Where A is PSA RoT, B is NSPE and memory asset to be protected is PSA RoT heap memory.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | client_test_nspe_read_psa_rot_heap()<br />driver_test_isolation_psa_rot_heap_rd()<br />client_test_nspe_write_psa_rot_heap()<br />driver_test_isolation_psa_rot_heap_wr()                                                            | Access PSA RoT partition heap memory address from NSPE and expect internal fault behavior                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | Optional                          | Yes                                      |
| test_i079                                                   | If domain A needs protection from domain B, then Private data in domain A cannot be accessed by domain B. <br />Where A is PSA RoT, B is NSPE and memory asset to be protected is PSA RoT MMIO region.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     | client_test_nspe_read_psa_rot_mmio()<br />driver_test_isolation_psa_rot_mmio_rd()<br />client_test_nspe_write_psa_rot_mmio()<br />driver_test_isolation_psa_rot_mmio_wr()                                                            | Access PSA RoT partition MMIO address from NSPE and expect internal fault behavior                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | Optional                          | Yes                                      |
| test_i080                                                   | If domain A needs protection from domain B, then Private data in domain A cannot be accessed by domain B. <br />Where A is PSA RoT, B is Application RoT and memory asset to be protected is PSA RoT variables- Global variable.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | client_test_app_rot_read_psa_rot_variable()<br />driver_test_isolation_psa_rot_data_rd()<br />client_test_app_rot_write_psa_rot_variable()<br />driver_test_isolation_psa_rot_data_wr()                                              | Access PSA RoT global variable address from Application RoT and expect internal fault behavior                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | Optional                          | Yes                                      |
| test_i081                                                   | If domain A needs protection from domain B, then Private data in domain A cannot be accessed by domain B. <br />Where A is PSA RoT, B is Application RoT and memory asset to be protected is PSA RoT execution stack.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | client_test_app_rot_read_psa_rot_stack()<br />driver_test_isolation_psa_rot_stack_rd()<br />client_test_app_rot_write_psa_stack_variable()<br />driver_test_isolation_psa_rot_stack_wr()                                             | Access PSA RoT local variable(stack region) address from Application RoT and expect internal fault behavior                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                | Optional                          | Yes                                      |
| test_i082                                                   | If domain A needs protection from domain B, then Private data in domain A cannot be accessed by domain B. <br />Where A is PSA RoT, B is Application RoT and memory asset to be protected is PSA RoT heap memory.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | client_test_app_rot_read_psa_rot_heap()<br />driver_test_isolation_psa_rot_heap_rd()<br />client_test_app_rot_write_psa_rot_heap()<br />driver_test_isolation_psa_rot_heap_wr()                                                      | Access PSA RoT partition heap memory address from Application RoT and expect internal fault behavior                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | Optional                          | Yes                                      |
| test_i083                                                   | If domain A needs protection from domain B, then Private data in domain A cannot be accessed by domain B. <br />Where A is PSA RoT, B is Application RoT and memory asset to be protected is PSA RoT MMIO region.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | client_test_app_rot_read_psa_rot_mmio()<br />driver_test_isolation_psa_rot_mmio_rd()<br />client_test_app_rot_write_psa_rot_mmio()<br />driver_test_isolation_psa_rot_mmio_wr()                                                      | Access PSA RoT partition MMIO address from Application RoT  and expect internal fault behavior                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | Optional                          | Yes                                      |
| test_i084                                                   | If domain A needs protection from domain B, then Private data in domain A cannot be accessed by domain B. <br />Where A is Application RoT Partition, B is other Application RoT partition and memory asset to be protected is A- Application RoT partition  variables- Global variable.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | [client/server]_test_sp_read_other_sp_variable()<br />[client/server]_test_sp_write_other_sp_variable()                                                                                                                              | Access Application RoT global variable address from other RoT and expect internal fault behavior                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | Optional                          | Yes                                      |
| test_i085                                                   | If domain A needs protection from domain B, then Private data in domain A cannot be accessed by domain B. <br />Where A is Application RoT Partition, B is other Application RoT partition and memory asset to be protected is A- Application RoT partition execution stack.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | [client/server]_test_sp_read_other_sp_stack()<br />[client/server]_test_sp_write_other_sp_stack()                                                                                                                                    | Access Application RoT local variable(stack region) address from other Application RoT and expect internal fault behavior                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | Optional                          | Yes                                      |
| test_i086                                                   | If domain A needs protection from domain B, then Private data in domain A cannot be accessed by domain B. <br />Where A is Application RoT Partition, B is other Application RoT partition and memory asset to be protected is A- Application RoT partition heap memory.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | [client/server]_test_sp_read_other_sp_heap()<br />[client/server]_test_sp_write_other_sp_heap()                                                                                                                                      | Access Application RoT partition heap memory address from other Application RoT and expect internal fault behavior                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         | Optional                          | Yes                                      |
| test_i087                                                   | If domain A needs protection from domain B, then Private data in domain A cannot be accessed by domain B. <br />Where A is Application RoT Partition, B is other Application RoT partition and memory asset to be protected is A- Application RoT partition MMIO region.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | [client/server]_test_sp_read_other_sp_mmio() <br />[client/server]_test_sp_write_other_sp_mmio()                                                                                                                                     | Access Application RoT partition MMIO address from other Application RoT  and expect internal fault behavior                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               | Optional                          | Optional                                 |
| test_l088                                                   | psa_rot_lifecycle_state() function retrieves the current PSA RoT lifecycle state.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | server_test_psa_rot_lifecycle_state()                                                                                                                                                                                                | Call psa_rot_lifecycle_state()  from secure side and check that return value is within the allowed range.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | Mandatory                         | Yes                                      |
| test_i089                                                   | psa_panic() will terminate execution within the calling Secure Partition and will not return.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | server_test_psa_panic()                                                                                                                                                                                                              | Call psa_panic() from the secure partition and expect PROGRAMMER ERROR behaviour for API call.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | Optional                          | Optional                                 |
| test_i090                                                   | The call to psa_call() is a PROGRAMMER ERROR if type < 0                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | [client/server]_test_psa_call_with_neg_type                                                                                                                                                                                          | Call to psa_call with negative type value and expect PROGRAMMER ERROR behaviour for API call.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | Optional                          | Optional                                 |
| NO_EXPLICIT_TEST                                            | A Secure Partition is guaranteed to be able to  read and write its private stack. <br />Manifest Parameter- stack_size (required) <br />Partition's stack size in bytes. The size value must be represented either as a positive integer or as a hexadecimal string.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | N/A                                                                                                                                                                                                                                  | No explicit test written to cover this rule. PSA IPC tests manifests are provided with tests partition required stack_size.  A successful execution of tests partition code without stack access related faults, indirectly verify this field.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | N/A                               | Yes                                      |
| NO_EXPLICIT_TEST                                            | mmio_regions (optional, unique): <br />List of memory-mapped I/O region objects which the Secure Partition needs access to.  A Secure Partition always has exclusive access to an MMIO region. Secure Partitions are not permitted to share MMIO regions with other Secure Partitions.<br />An MMIO region can be defined either as a:<br />numbered_region<br />named_region<br />A numbered region consists of a base address and a size. The size must be represented either as a positive integer or as a hexadecimal string. The base address must be represented as a hexadecimal string.<br />MMIO regions must not overlap.<br />An MMIO region must include a permission attribute. The following permissions are available:<br />READ-ONLY<br />READ-WRITE                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | N/A                                                                                                                                                                                                                                  | Comments:<br />1. PSA IPC tests device driver partition manifests are provided with these fields. A successful compilation and run of device driver partition code indirectly verify this field. <br  />2. Rules around sharing of MMIO regions is covered as part of isolation tests.<br  />3. Rules around overlapping of MMIO regions can't be tested as specifying that into manifest results into compilation fail. <br />4. Test suite partition manifests are rely on numbered_region only as named_region is subject to resolved in Implementation defined manner.                                                                                                                                                                                                                                                                                                                                                                 | N/A                               | Yes                                      |
| NO_EXPLICIT_TEST                                            | Manifest Parameter-  type (required) <br />Whether the Partition is a part of the PSA Root of Trust Services or is part of the Application Root of Trust Services.Type must be assigned one of the following values:- APPLICATION-ROT- PSA-ROT                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | N/A                                                                                                                                                                                                                                  | PSA IPC tests partition files are provided with these fields. Access permission behaviour related to these fields will be verified as part of tests covering isolation level rules.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | N/A                               | Yes                                      |
| NO_EXPLICIT_TEST                                            | Manifest Parameter - description (optional) <br />This attribute contains a human-readable description and comments for the Secure Partition.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | N/A                                                                                                                                                                                                                                  | Test suite manifests are provided with these field with adhere to manifest rules. Manifest build tool parser must parse this field without any compilation fail.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | N/A                               | Yes                                      |
| NO_EXPLICIT_TEST                                            | Manifest Parameter -entry_point (required, unique) <br />The Partition entry point in the form of an C function symbol. A single entry point must be provided and it must have the following signature: <br />void entry_point(void);                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | N/A                                                                                                                                                                                                                                  | No explicit test written to cover this rule. Test suite manifests are provided with tests partition entry_point.  A successful launch and run of tests partition code indirectly verify this field.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | N/A                               | Yes                                      |
| NO_EXPLICIT_TEST                                            | The SPM must eventually deliver all signals and IPC messages.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | N/A                                                                                                                                                                                                                                  | No explicit test written to cover this rule. However all PSA IPC tests are written with the expectation that the SPM delivers all requested signals and IPC message in a timely fashion. Failure to provide this will result in simulation time out.  <br />This rule is unbounded and cannot have full coverage. It is good to that things are delivered in a timely manner, however failure will not break compliance.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | N/A                               | Yes                                      |
| NO_EXPLICIT_TEST                                            | A Secure Partition is guaranteed to be able to  execute and read its own code regions and read its own read-only data regions.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | N/A                                                                                                                                                                                                                                  | No explicit test written to cover this rule. This is a minimum requirement to able to launch and run secure partition. Failing to provide this, will not be able to run IPC test suite.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | N/A                               | Yes                                      |
| NOT_COVERED                                                 | psa_get returns PSA_ERROR_DOES_NOT_EXIST if the SPM cannot deliver a message to the Secure Partition following the assertion of the RoT Service signal.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | N/A                                                                                                                                                                                                                                  | This scenario cannot be simulated as test can't generate stimulus where psa_get() API returns PSA_ERROR_DOES_NOT_EXIST. However every instances of psa_get() API call in test suite checks the API return value and re-waits for signal delivery if return value is PSA_ERROR_DOES_NOT_EXIST.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | N/A                               | No                                       |
| NOT_COVERED                                                 | The call to psa_call is PROGRAMMER ERROR if the connection is already handling a request.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | N/A                                                                                                                                                                                                                                  | This rule is not verified beacuse of following reasons: <br />- There is no common infrastructure to test this rule as this needs two OS specific tasks where one task interrupted during execution of psa_call or psa_close  and second task scheduled to execute psa_call using same handle.<br />- It is hard to write test stimulus where this rule is always hit as it is highly dependent of platform software scheduling policy. <br />                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             | N/A                               | No                                       |
| NOT_COVERED                                                 | The call to psa_close is PROGRAMMER ERROR  if the connection is already handling a request                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | N/A                                                                                                                                                                                                                                  | This rule is not verified beacuse of following reasons: <br />- There is no common infrastructure to test this rule as this needs two OS specific tasks where one task interrupted during execution of psa_call or psa_close  and second task scheduled to execute psa_close using same handle.<br />- It is hard to write test stimulus where this rule is always hit as it is highly dependent of platform software scheduling policy. <br />                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | N/A                               | No                                       |
| NOT_COVERED                                                 | Manifest Parameter - priority (required) <br />Partitions must be assigned one of the following priority groups: HIGH NORMAL LOWLOW is the lowest priority. Priority is ignored by SPMs that do not implement any priority-based scheduling.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            | N/A                                                                                                                                                                                                                                  | Use of these fields are highly dependent on type of SPM scheduling policy, hence can't test the behavious of this field. And test suite partition manifests are provided with priority field equal to LOW.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | N/A                               | No                                       |
| NOT_COVERED                                                 | Secure Partition IDs must be fixed across updates                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | N/A                                                                                                                                                                                                                                  | Checking for Partition IDs across SPM updates is out of scope for PSA IPC tests.                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | N/A                               | No                                       |

## License
Arm PSA test suite is distributed under Apache v2.0 License.

--------------

*Copyright (c) 2018-2019, Arm Limited and Contributors. All rights reserved.*
