/**************************************************************************/
/*                                                                        */
/*       Copyright (c) Microsoft Corporation. All rights reserved.        */
/*                                                                        */
/*       This software is licensed under the Microsoft Software License   */
/*       Terms for Microsoft Azure RTOS. Full text of the license can be  */
/*       found in the LICENSE file at https://aka.ms/AzureRTOS_EULA       */
/*       and in the root directory of this software.                      */
/*                                                                        */
/**************************************************************************/


/**************************************************************************/
/**************************************************************************/
/**                                                                       */
/** GUIX Component                                                        */
/**                                                                       */
/**   Utility (Utility)                                                   */
/**                                                                       */
/**************************************************************************/
#define GX_SOURCE_CODE


/* Include necessary system files.  */

#include "gx_api.h"
#include "gx_utility.h"

#if defined(GX_DYNAMIC_BIDI_TEXT_SUPPORT)
static GX_CONST GX_BIDI_CHARACTER_INFO _gx_bidi_character_types[] =
{
    {0x0041, 0x005A, GX_BIDI_CHARACTER_TYPE_L},
    {0x0061, 0x007A, GX_BIDI_CHARACTER_TYPE_L},
    {0x00AA, 0x00AA, GX_BIDI_CHARACTER_TYPE_L},
    {0x00B5, 0x00B5, GX_BIDI_CHARACTER_TYPE_L},
    {0x00BA, 0x00BA, GX_BIDI_CHARACTER_TYPE_L},
    {0x00C0, 0x00D6, GX_BIDI_CHARACTER_TYPE_L},
    {0x00D8, 0x00F6, GX_BIDI_CHARACTER_TYPE_L},
    {0x00F8, 0x01BA, GX_BIDI_CHARACTER_TYPE_L},
    {0x01BB, 0x01BB, GX_BIDI_CHARACTER_TYPE_L},
    {0x01BC, 0x01BF, GX_BIDI_CHARACTER_TYPE_L},
    {0x01C0, 0x01C3, GX_BIDI_CHARACTER_TYPE_L},
    {0x01C4, 0x0293, GX_BIDI_CHARACTER_TYPE_L},
    {0x0294, 0x0294, GX_BIDI_CHARACTER_TYPE_L},
    {0x0295, 0x02AF, GX_BIDI_CHARACTER_TYPE_L},
    {0x02B0, 0x02B8, GX_BIDI_CHARACTER_TYPE_L},
    {0x02BB, 0x02C1, GX_BIDI_CHARACTER_TYPE_L},
    {0x02D0, 0x02D1, GX_BIDI_CHARACTER_TYPE_L},
    {0x02E0, 0x02E4, GX_BIDI_CHARACTER_TYPE_L},
    {0x02EE, 0x02EE, GX_BIDI_CHARACTER_TYPE_L},
    {0x0370, 0x0373, GX_BIDI_CHARACTER_TYPE_L},
    {0x0376, 0x0377, GX_BIDI_CHARACTER_TYPE_L},
    {0x037A, 0x037A, GX_BIDI_CHARACTER_TYPE_L},
    {0x037B, 0x037D, GX_BIDI_CHARACTER_TYPE_L},
    {0x0386, 0x0386, GX_BIDI_CHARACTER_TYPE_L},
    {0x0388, 0x038A, GX_BIDI_CHARACTER_TYPE_L},
    {0x038C, 0x038C, GX_BIDI_CHARACTER_TYPE_L},
    {0x038E, 0x03A1, GX_BIDI_CHARACTER_TYPE_L},
    {0x03A3, 0x03F5, GX_BIDI_CHARACTER_TYPE_L},
    {0x03F7, 0x0481, GX_BIDI_CHARACTER_TYPE_L},
    {0x0482, 0x0482, GX_BIDI_CHARACTER_TYPE_L},
    {0x048A, 0x0523, GX_BIDI_CHARACTER_TYPE_L},
    {0x0531, 0x0556, GX_BIDI_CHARACTER_TYPE_L},
    {0x0559, 0x0559, GX_BIDI_CHARACTER_TYPE_L},
    {0x055A, 0x055F, GX_BIDI_CHARACTER_TYPE_L},
    {0x0561, 0x0587, GX_BIDI_CHARACTER_TYPE_L},
    {0x0589, 0x0589, GX_BIDI_CHARACTER_TYPE_L},
    {0x0903, 0x0903, GX_BIDI_CHARACTER_TYPE_L},
    {0x0904, 0x0939, GX_BIDI_CHARACTER_TYPE_L},
    {0x093D, 0x093D, GX_BIDI_CHARACTER_TYPE_L},
    {0x093E, 0x0940, GX_BIDI_CHARACTER_TYPE_L},
    {0x0949, 0x094C, GX_BIDI_CHARACTER_TYPE_L},
    {0x0950, 0x0950, GX_BIDI_CHARACTER_TYPE_L},
    {0x0958, 0x0961, GX_BIDI_CHARACTER_TYPE_L},
    {0x0964, 0x0965, GX_BIDI_CHARACTER_TYPE_L},
    {0x0966, 0x096F, GX_BIDI_CHARACTER_TYPE_L},
    {0x0970, 0x0970, GX_BIDI_CHARACTER_TYPE_L},
    {0x0971, 0x0971, GX_BIDI_CHARACTER_TYPE_L},
    {0x0972, 0x0972, GX_BIDI_CHARACTER_TYPE_L},
    {0x097B, 0x097F, GX_BIDI_CHARACTER_TYPE_L},
    {0x0982, 0x0983, GX_BIDI_CHARACTER_TYPE_L},
    {0x0985, 0x098C, GX_BIDI_CHARACTER_TYPE_L},
    {0x098F, 0x0990, GX_BIDI_CHARACTER_TYPE_L},
    {0x0993, 0x09A8, GX_BIDI_CHARACTER_TYPE_L},
    {0x09AA, 0x09B0, GX_BIDI_CHARACTER_TYPE_L},
    {0x09B2, 0x09B2, GX_BIDI_CHARACTER_TYPE_L},
    {0x09B6, 0x09B9, GX_BIDI_CHARACTER_TYPE_L},
    {0x09BD, 0x09BD, GX_BIDI_CHARACTER_TYPE_L},
    {0x09BE, 0x09C0, GX_BIDI_CHARACTER_TYPE_L},
    {0x09C7, 0x09C8, GX_BIDI_CHARACTER_TYPE_L},
    {0x09CB, 0x09CC, GX_BIDI_CHARACTER_TYPE_L},
    {0x09CE, 0x09CE, GX_BIDI_CHARACTER_TYPE_L},
    {0x09D7, 0x09D7, GX_BIDI_CHARACTER_TYPE_L},
    {0x09DC, 0x09DD, GX_BIDI_CHARACTER_TYPE_L},
    {0x09DF, 0x09E1, GX_BIDI_CHARACTER_TYPE_L},
    {0x09E6, 0x09EF, GX_BIDI_CHARACTER_TYPE_L},
    {0x09F0, 0x09F1, GX_BIDI_CHARACTER_TYPE_L},
    {0x09F4, 0x09F9, GX_BIDI_CHARACTER_TYPE_L},
    {0x09FA, 0x09FA, GX_BIDI_CHARACTER_TYPE_L},
    {0x0A03, 0x0A03, GX_BIDI_CHARACTER_TYPE_L},
    {0x0A05, 0x0A0A, GX_BIDI_CHARACTER_TYPE_L},
    {0x0A0F, 0x0A10, GX_BIDI_CHARACTER_TYPE_L},
    {0x0A13, 0x0A28, GX_BIDI_CHARACTER_TYPE_L},
    {0x0A2A, 0x0A30, GX_BIDI_CHARACTER_TYPE_L},
    {0x0A32, 0x0A33, GX_BIDI_CHARACTER_TYPE_L},
    {0x0A35, 0x0A36, GX_BIDI_CHARACTER_TYPE_L},
    {0x0A38, 0x0A39, GX_BIDI_CHARACTER_TYPE_L},
    {0x0A3E, 0x0A40, GX_BIDI_CHARACTER_TYPE_L},
    {0x0A59, 0x0A5C, GX_BIDI_CHARACTER_TYPE_L},
    {0x0A5E, 0x0A5E, GX_BIDI_CHARACTER_TYPE_L},
    {0x0A66, 0x0A6F, GX_BIDI_CHARACTER_TYPE_L},
    {0x0A72, 0x0A74, GX_BIDI_CHARACTER_TYPE_L},
    {0x0A83, 0x0A83, GX_BIDI_CHARACTER_TYPE_L},
    {0x0A85, 0x0A8D, GX_BIDI_CHARACTER_TYPE_L},
    {0x0A8F, 0x0A91, GX_BIDI_CHARACTER_TYPE_L},
    {0x0A93, 0x0AA8, GX_BIDI_CHARACTER_TYPE_L},
    {0x0AAA, 0x0AB0, GX_BIDI_CHARACTER_TYPE_L},
    {0x0AB2, 0x0AB3, GX_BIDI_CHARACTER_TYPE_L},
    {0x0AB5, 0x0AB9, GX_BIDI_CHARACTER_TYPE_L},
    {0x0ABD, 0x0ABD, GX_BIDI_CHARACTER_TYPE_L},
    {0x0ABE, 0x0AC0, GX_BIDI_CHARACTER_TYPE_L},
    {0x0AC9, 0x0AC9, GX_BIDI_CHARACTER_TYPE_L},
    {0x0ACB, 0x0ACC, GX_BIDI_CHARACTER_TYPE_L},
    {0x0AD0, 0x0AD0, GX_BIDI_CHARACTER_TYPE_L},
    {0x0AE0, 0x0AE1, GX_BIDI_CHARACTER_TYPE_L},
    {0x0AE6, 0x0AEF, GX_BIDI_CHARACTER_TYPE_L},
    {0x0B02, 0x0B03, GX_BIDI_CHARACTER_TYPE_L},
    {0x0B05, 0x0B0C, GX_BIDI_CHARACTER_TYPE_L},
    {0x0B0F, 0x0B10, GX_BIDI_CHARACTER_TYPE_L},
    {0x0B13, 0x0B28, GX_BIDI_CHARACTER_TYPE_L},
    {0x0B2A, 0x0B30, GX_BIDI_CHARACTER_TYPE_L},
    {0x0B32, 0x0B33, GX_BIDI_CHARACTER_TYPE_L},
    {0x0B35, 0x0B39, GX_BIDI_CHARACTER_TYPE_L},
    {0x0B3D, 0x0B3D, GX_BIDI_CHARACTER_TYPE_L},
    {0x0B3E, 0x0B3E, GX_BIDI_CHARACTER_TYPE_L},
    {0x0B40, 0x0B40, GX_BIDI_CHARACTER_TYPE_L},
    {0x0B47, 0x0B48, GX_BIDI_CHARACTER_TYPE_L},
    {0x0B4B, 0x0B4C, GX_BIDI_CHARACTER_TYPE_L},
    {0x0B57, 0x0B57, GX_BIDI_CHARACTER_TYPE_L},
    {0x0B5C, 0x0B5D, GX_BIDI_CHARACTER_TYPE_L},
    {0x0B5F, 0x0B61, GX_BIDI_CHARACTER_TYPE_L},
    {0x0B66, 0x0B6F, GX_BIDI_CHARACTER_TYPE_L},
    {0x0B70, 0x0B70, GX_BIDI_CHARACTER_TYPE_L},
    {0x0B71, 0x0B71, GX_BIDI_CHARACTER_TYPE_L},
    {0x0B83, 0x0B83, GX_BIDI_CHARACTER_TYPE_L},
    {0x0B85, 0x0B8A, GX_BIDI_CHARACTER_TYPE_L},
    {0x0B8E, 0x0B90, GX_BIDI_CHARACTER_TYPE_L},
    {0x0B92, 0x0B95, GX_BIDI_CHARACTER_TYPE_L},
    {0x0B99, 0x0B9A, GX_BIDI_CHARACTER_TYPE_L},
    {0x0B9C, 0x0B9C, GX_BIDI_CHARACTER_TYPE_L},
    {0x0B9E, 0x0B9F, GX_BIDI_CHARACTER_TYPE_L},
    {0x0BA3, 0x0BA4, GX_BIDI_CHARACTER_TYPE_L},
    {0x0BA8, 0x0BAA, GX_BIDI_CHARACTER_TYPE_L},
    {0x0BAE, 0x0BB9, GX_BIDI_CHARACTER_TYPE_L},
    {0x0BBE, 0x0BBF, GX_BIDI_CHARACTER_TYPE_L},
    {0x0BC1, 0x0BC2, GX_BIDI_CHARACTER_TYPE_L},
    {0x0BC6, 0x0BC8, GX_BIDI_CHARACTER_TYPE_L},
    {0x0BCA, 0x0BCC, GX_BIDI_CHARACTER_TYPE_L},
    {0x0BD0, 0x0BD0, GX_BIDI_CHARACTER_TYPE_L},
    {0x0BD7, 0x0BD7, GX_BIDI_CHARACTER_TYPE_L},
    {0x0BE6, 0x0BEF, GX_BIDI_CHARACTER_TYPE_L},
    {0x0BF0, 0x0BF2, GX_BIDI_CHARACTER_TYPE_L},
    {0x0C01, 0x0C03, GX_BIDI_CHARACTER_TYPE_L},
    {0x0C05, 0x0C0C, GX_BIDI_CHARACTER_TYPE_L},
    {0x0C0E, 0x0C10, GX_BIDI_CHARACTER_TYPE_L},
    {0x0C12, 0x0C28, GX_BIDI_CHARACTER_TYPE_L},
    {0x0C2A, 0x0C33, GX_BIDI_CHARACTER_TYPE_L},
    {0x0C35, 0x0C39, GX_BIDI_CHARACTER_TYPE_L},
    {0x0C3D, 0x0C3D, GX_BIDI_CHARACTER_TYPE_L},
    {0x0C41, 0x0C44, GX_BIDI_CHARACTER_TYPE_L},
    {0x0C58, 0x0C59, GX_BIDI_CHARACTER_TYPE_L},
    {0x0C60, 0x0C61, GX_BIDI_CHARACTER_TYPE_L},
    {0x0C66, 0x0C6F, GX_BIDI_CHARACTER_TYPE_L},
    {0x0C7F, 0x0C7F, GX_BIDI_CHARACTER_TYPE_L},
    {0x0C82, 0x0C83, GX_BIDI_CHARACTER_TYPE_L},
    {0x0C85, 0x0C8C, GX_BIDI_CHARACTER_TYPE_L},
    {0x0C8E, 0x0C90, GX_BIDI_CHARACTER_TYPE_L},
    {0x0C92, 0x0CA8, GX_BIDI_CHARACTER_TYPE_L},
    {0x0CAA, 0x0CB3, GX_BIDI_CHARACTER_TYPE_L},
    {0x0CB5, 0x0CB9, GX_BIDI_CHARACTER_TYPE_L},
    {0x0CBD, 0x0CBD, GX_BIDI_CHARACTER_TYPE_L},
    {0x0CBE, 0x0CBE, GX_BIDI_CHARACTER_TYPE_L},
    {0x0CBF, 0x0CBF, GX_BIDI_CHARACTER_TYPE_L},
    {0x0CC0, 0x0CC4, GX_BIDI_CHARACTER_TYPE_L},
    {0x0CC6, 0x0CC6, GX_BIDI_CHARACTER_TYPE_L},
    {0x0CC7, 0x0CC8, GX_BIDI_CHARACTER_TYPE_L},
    {0x0CCA, 0x0CCB, GX_BIDI_CHARACTER_TYPE_L},
    {0x0CD5, 0x0CD6, GX_BIDI_CHARACTER_TYPE_L},
    {0x0CDE, 0x0CDE, GX_BIDI_CHARACTER_TYPE_L},
    {0x0CE0, 0x0CE1, GX_BIDI_CHARACTER_TYPE_L},
    {0x0CE6, 0x0CEF, GX_BIDI_CHARACTER_TYPE_L},
    {0x0D02, 0x0D03, GX_BIDI_CHARACTER_TYPE_L},
    {0x0D05, 0x0D0C, GX_BIDI_CHARACTER_TYPE_L},
    {0x0D0E, 0x0D10, GX_BIDI_CHARACTER_TYPE_L},
    {0x0D12, 0x0D28, GX_BIDI_CHARACTER_TYPE_L},
    {0x0D2A, 0x0D39, GX_BIDI_CHARACTER_TYPE_L},
    {0x0D3D, 0x0D3D, GX_BIDI_CHARACTER_TYPE_L},
    {0x0D3E, 0x0D40, GX_BIDI_CHARACTER_TYPE_L},
    {0x0D46, 0x0D48, GX_BIDI_CHARACTER_TYPE_L},
    {0x0D4A, 0x0D4C, GX_BIDI_CHARACTER_TYPE_L},
    {0x0D57, 0x0D57, GX_BIDI_CHARACTER_TYPE_L},
    {0x0D60, 0x0D61, GX_BIDI_CHARACTER_TYPE_L},
    {0x0D66, 0x0D6F, GX_BIDI_CHARACTER_TYPE_L},
    {0x0D70, 0x0D75, GX_BIDI_CHARACTER_TYPE_L},
    {0x0D79, 0x0D79, GX_BIDI_CHARACTER_TYPE_L},
    {0x0D7A, 0x0D7F, GX_BIDI_CHARACTER_TYPE_L},
    {0x0D82, 0x0D83, GX_BIDI_CHARACTER_TYPE_L},
    {0x0D85, 0x0D96, GX_BIDI_CHARACTER_TYPE_L},
    {0x0D9A, 0x0DB1, GX_BIDI_CHARACTER_TYPE_L},
    {0x0DB3, 0x0DBB, GX_BIDI_CHARACTER_TYPE_L},
    {0x0DBD, 0x0DBD, GX_BIDI_CHARACTER_TYPE_L},
    {0x0DC0, 0x0DC6, GX_BIDI_CHARACTER_TYPE_L},
    {0x0DCF, 0x0DD1, GX_BIDI_CHARACTER_TYPE_L},
    {0x0DD8, 0x0DDF, GX_BIDI_CHARACTER_TYPE_L},
    {0x0DF2, 0x0DF3, GX_BIDI_CHARACTER_TYPE_L},
    {0x0DF4, 0x0DF4, GX_BIDI_CHARACTER_TYPE_L},
    {0x0E01, 0x0E30, GX_BIDI_CHARACTER_TYPE_L},
    {0x0E32, 0x0E33, GX_BIDI_CHARACTER_TYPE_L},
    {0x0E40, 0x0E45, GX_BIDI_CHARACTER_TYPE_L},
    {0x0E46, 0x0E46, GX_BIDI_CHARACTER_TYPE_L},
    {0x0E4F, 0x0E4F, GX_BIDI_CHARACTER_TYPE_L},
    {0x0E50, 0x0E59, GX_BIDI_CHARACTER_TYPE_L},
    {0x0E5A, 0x0E5B, GX_BIDI_CHARACTER_TYPE_L},
    {0x0E81, 0x0E82, GX_BIDI_CHARACTER_TYPE_L},
    {0x0E84, 0x0E84, GX_BIDI_CHARACTER_TYPE_L},
    {0x0E87, 0x0E88, GX_BIDI_CHARACTER_TYPE_L},
    {0x0E8A, 0x0E8A, GX_BIDI_CHARACTER_TYPE_L},
    {0x0E8D, 0x0E8D, GX_BIDI_CHARACTER_TYPE_L},
    {0x0E94, 0x0E97, GX_BIDI_CHARACTER_TYPE_L},
    {0x0E99, 0x0E9F, GX_BIDI_CHARACTER_TYPE_L},
    {0x0EA1, 0x0EA3, GX_BIDI_CHARACTER_TYPE_L},
    {0x0EA5, 0x0EA5, GX_BIDI_CHARACTER_TYPE_L},
    {0x0EA7, 0x0EA7, GX_BIDI_CHARACTER_TYPE_L},
    {0x0EAA, 0x0EAB, GX_BIDI_CHARACTER_TYPE_L},
    {0x0EAD, 0x0EB0, GX_BIDI_CHARACTER_TYPE_L},
    {0x0EB2, 0x0EB3, GX_BIDI_CHARACTER_TYPE_L},
    {0x0EBD, 0x0EBD, GX_BIDI_CHARACTER_TYPE_L},
    {0x0EC0, 0x0EC4, GX_BIDI_CHARACTER_TYPE_L},
    {0x0EC6, 0x0EC6, GX_BIDI_CHARACTER_TYPE_L},
    {0x0ED0, 0x0ED9, GX_BIDI_CHARACTER_TYPE_L},
    {0x0EDC, 0x0EDD, GX_BIDI_CHARACTER_TYPE_L},
    {0x0F00, 0x0F00, GX_BIDI_CHARACTER_TYPE_L},
    {0x0F01, 0x0F03, GX_BIDI_CHARACTER_TYPE_L},
    {0x0F04, 0x0F12, GX_BIDI_CHARACTER_TYPE_L},
    {0x0F13, 0x0F17, GX_BIDI_CHARACTER_TYPE_L},
    {0x0F1A, 0x0F1F, GX_BIDI_CHARACTER_TYPE_L},
    {0x0F20, 0x0F29, GX_BIDI_CHARACTER_TYPE_L},
    {0x0F2A, 0x0F33, GX_BIDI_CHARACTER_TYPE_L},
    {0x0F34, 0x0F34, GX_BIDI_CHARACTER_TYPE_L},
    {0x0F36, 0x0F36, GX_BIDI_CHARACTER_TYPE_L},
    {0x0F38, 0x0F38, GX_BIDI_CHARACTER_TYPE_L},
    {0x0F3E, 0x0F3F, GX_BIDI_CHARACTER_TYPE_L},
    {0x0F40, 0x0F47, GX_BIDI_CHARACTER_TYPE_L},
    {0x0F49, 0x0F6C, GX_BIDI_CHARACTER_TYPE_L},
    {0x0F7F, 0x0F7F, GX_BIDI_CHARACTER_TYPE_L},
    {0x0F85, 0x0F85, GX_BIDI_CHARACTER_TYPE_L},
    {0x0F88, 0x0F8B, GX_BIDI_CHARACTER_TYPE_L},
    {0x0FBE, 0x0FC5, GX_BIDI_CHARACTER_TYPE_L},
    {0x0FC7, 0x0FCC, GX_BIDI_CHARACTER_TYPE_L},
    {0x0FCE, 0x0FCF, GX_BIDI_CHARACTER_TYPE_L},
    {0x0FD0, 0x0FD4, GX_BIDI_CHARACTER_TYPE_L},
    {0x1000, 0x102A, GX_BIDI_CHARACTER_TYPE_L},
    {0x102B, 0x102C, GX_BIDI_CHARACTER_TYPE_L},
    {0x1031, 0x1031, GX_BIDI_CHARACTER_TYPE_L},
    {0x1038, 0x1038, GX_BIDI_CHARACTER_TYPE_L},
    {0x103B, 0x103C, GX_BIDI_CHARACTER_TYPE_L},
    {0x103F, 0x103F, GX_BIDI_CHARACTER_TYPE_L},
    {0x1040, 0x1049, GX_BIDI_CHARACTER_TYPE_L},
    {0x104A, 0x104F, GX_BIDI_CHARACTER_TYPE_L},
    {0x1050, 0x1055, GX_BIDI_CHARACTER_TYPE_L},
    {0x1056, 0x1057, GX_BIDI_CHARACTER_TYPE_L},
    {0x105A, 0x105D, GX_BIDI_CHARACTER_TYPE_L},
    {0x1061, 0x1061, GX_BIDI_CHARACTER_TYPE_L},
    {0x1062, 0x1064, GX_BIDI_CHARACTER_TYPE_L},
    {0x1065, 0x1066, GX_BIDI_CHARACTER_TYPE_L},
    {0x1067, 0x106D, GX_BIDI_CHARACTER_TYPE_L},
    {0x106E, 0x1070, GX_BIDI_CHARACTER_TYPE_L},
    {0x1075, 0x1081, GX_BIDI_CHARACTER_TYPE_L},
    {0x1083, 0x1084, GX_BIDI_CHARACTER_TYPE_L},
    {0x1087, 0x108C, GX_BIDI_CHARACTER_TYPE_L},
    {0x108E, 0x108E, GX_BIDI_CHARACTER_TYPE_L},
    {0x108F, 0x108F, GX_BIDI_CHARACTER_TYPE_L},
    {0x1090, 0x1099, GX_BIDI_CHARACTER_TYPE_L},
    {0x109E, 0x109F, GX_BIDI_CHARACTER_TYPE_L},
    {0x10A0, 0x10C5, GX_BIDI_CHARACTER_TYPE_L},
    {0x10D0, 0x10FA, GX_BIDI_CHARACTER_TYPE_L},
    {0x10FB, 0x10FB, GX_BIDI_CHARACTER_TYPE_L},
    {0x10FC, 0x10FC, GX_BIDI_CHARACTER_TYPE_L},
    {0x1100, 0x1159, GX_BIDI_CHARACTER_TYPE_L},
    {0x115F, 0x11A2, GX_BIDI_CHARACTER_TYPE_L},
    {0x11A8, 0x11F9, GX_BIDI_CHARACTER_TYPE_L},
    {0x1200, 0x1248, GX_BIDI_CHARACTER_TYPE_L},
    {0x124A, 0x124D, GX_BIDI_CHARACTER_TYPE_L},
    {0x1250, 0x1256, GX_BIDI_CHARACTER_TYPE_L},
    {0x1258, 0x1258, GX_BIDI_CHARACTER_TYPE_L},
    {0x125A, 0x125D, GX_BIDI_CHARACTER_TYPE_L},
    {0x1260, 0x1288, GX_BIDI_CHARACTER_TYPE_L},
    {0x128A, 0x128D, GX_BIDI_CHARACTER_TYPE_L},
    {0x1290, 0x12B0, GX_BIDI_CHARACTER_TYPE_L},
    {0x12B2, 0x12B5, GX_BIDI_CHARACTER_TYPE_L},
    {0x12B8, 0x12BE, GX_BIDI_CHARACTER_TYPE_L},
    {0x12C0, 0x12C0, GX_BIDI_CHARACTER_TYPE_L},
    {0x12C2, 0x12C5, GX_BIDI_CHARACTER_TYPE_L},
    {0x12C8, 0x12D6, GX_BIDI_CHARACTER_TYPE_L},
    {0x12D8, 0x1310, GX_BIDI_CHARACTER_TYPE_L},
    {0x1312, 0x1315, GX_BIDI_CHARACTER_TYPE_L},
    {0x1318, 0x135A, GX_BIDI_CHARACTER_TYPE_L},
    {0x1360, 0x1360, GX_BIDI_CHARACTER_TYPE_L},
    {0x1361, 0x1368, GX_BIDI_CHARACTER_TYPE_L},
    {0x1369, 0x137C, GX_BIDI_CHARACTER_TYPE_L},
    {0x1380, 0x138F, GX_BIDI_CHARACTER_TYPE_L},
    {0x13A0, 0x13F4, GX_BIDI_CHARACTER_TYPE_L},
    {0x1401, 0x166C, GX_BIDI_CHARACTER_TYPE_L},
    {0x166D, 0x166E, GX_BIDI_CHARACTER_TYPE_L},
    {0x166F, 0x1676, GX_BIDI_CHARACTER_TYPE_L},
    {0x1681, 0x169A, GX_BIDI_CHARACTER_TYPE_L},
    {0x16A0, 0x16EA, GX_BIDI_CHARACTER_TYPE_L},
    {0x16EB, 0x16ED, GX_BIDI_CHARACTER_TYPE_L},
    {0x16EE, 0x16F0, GX_BIDI_CHARACTER_TYPE_L},
    {0x1700, 0x170C, GX_BIDI_CHARACTER_TYPE_L},
    {0x170E, 0x1711, GX_BIDI_CHARACTER_TYPE_L},
    {0x1720, 0x1731, GX_BIDI_CHARACTER_TYPE_L},
    {0x1735, 0x1736, GX_BIDI_CHARACTER_TYPE_L},
    {0x1740, 0x1751, GX_BIDI_CHARACTER_TYPE_L},
    {0x1760, 0x176C, GX_BIDI_CHARACTER_TYPE_L},
    {0x176E, 0x1770, GX_BIDI_CHARACTER_TYPE_L},
    {0x1780, 0x17B3, GX_BIDI_CHARACTER_TYPE_L},
    {0x17B4, 0x17B5, GX_BIDI_CHARACTER_TYPE_L},
    {0x17B6, 0x17B6, GX_BIDI_CHARACTER_TYPE_L},
    {0x17BE, 0x17C5, GX_BIDI_CHARACTER_TYPE_L},
    {0x17C7, 0x17C8, GX_BIDI_CHARACTER_TYPE_L},
    {0x17D4, 0x17D6, GX_BIDI_CHARACTER_TYPE_L},
    {0x17D7, 0x17D7, GX_BIDI_CHARACTER_TYPE_L},
    {0x17D8, 0x17DA, GX_BIDI_CHARACTER_TYPE_L},
    {0x17DC, 0x17DC, GX_BIDI_CHARACTER_TYPE_L},
    {0x17E0, 0x17E9, GX_BIDI_CHARACTER_TYPE_L},
    {0x1810, 0x1819, GX_BIDI_CHARACTER_TYPE_L},
    {0x1820, 0x1842, GX_BIDI_CHARACTER_TYPE_L},
    {0x1843, 0x1843, GX_BIDI_CHARACTER_TYPE_L},
    {0x1844, 0x1877, GX_BIDI_CHARACTER_TYPE_L},
    {0x1880, 0x18A8, GX_BIDI_CHARACTER_TYPE_L},
    {0x18AA, 0x18AA, GX_BIDI_CHARACTER_TYPE_L},
    {0x1900, 0x191C, GX_BIDI_CHARACTER_TYPE_L},
    {0x1923, 0x1926, GX_BIDI_CHARACTER_TYPE_L},
    {0x1929, 0x192B, GX_BIDI_CHARACTER_TYPE_L},
    {0x1930, 0x1931, GX_BIDI_CHARACTER_TYPE_L},
    {0x1933, 0x1938, GX_BIDI_CHARACTER_TYPE_L},
    {0x1946, 0x194F, GX_BIDI_CHARACTER_TYPE_L},
    {0x1950, 0x196D, GX_BIDI_CHARACTER_TYPE_L},
    {0x1970, 0x1974, GX_BIDI_CHARACTER_TYPE_L},
    {0x1980, 0x19A9, GX_BIDI_CHARACTER_TYPE_L},
    {0x19B0, 0x19C0, GX_BIDI_CHARACTER_TYPE_L},
    {0x19C1, 0x19C7, GX_BIDI_CHARACTER_TYPE_L},
    {0x19C8, 0x19C9, GX_BIDI_CHARACTER_TYPE_L},
    {0x19D0, 0x19D9, GX_BIDI_CHARACTER_TYPE_L},
    {0x1A00, 0x1A16, GX_BIDI_CHARACTER_TYPE_L},
    {0x1A19, 0x1A1B, GX_BIDI_CHARACTER_TYPE_L},
    {0x1A1E, 0x1A1F, GX_BIDI_CHARACTER_TYPE_L},
    {0x1B04, 0x1B04, GX_BIDI_CHARACTER_TYPE_L},
    {0x1B05, 0x1B33, GX_BIDI_CHARACTER_TYPE_L},
    {0x1B35, 0x1B35, GX_BIDI_CHARACTER_TYPE_L},
    {0x1B3B, 0x1B3B, GX_BIDI_CHARACTER_TYPE_L},
    {0x1B3D, 0x1B41, GX_BIDI_CHARACTER_TYPE_L},
    {0x1B43, 0x1B44, GX_BIDI_CHARACTER_TYPE_L},
    {0x1B45, 0x1B4B, GX_BIDI_CHARACTER_TYPE_L},
    {0x1B50, 0x1B59, GX_BIDI_CHARACTER_TYPE_L},
    {0x1B5A, 0x1B60, GX_BIDI_CHARACTER_TYPE_L},
    {0x1B61, 0x1B6A, GX_BIDI_CHARACTER_TYPE_L},
    {0x1B74, 0x1B7C, GX_BIDI_CHARACTER_TYPE_L},
    {0x1B82, 0x1B82, GX_BIDI_CHARACTER_TYPE_L},
    {0x1B83, 0x1BA0, GX_BIDI_CHARACTER_TYPE_L},
    {0x1BA1, 0x1BA1, GX_BIDI_CHARACTER_TYPE_L},
    {0x1BA6, 0x1BA7, GX_BIDI_CHARACTER_TYPE_L},
    {0x1BAA, 0x1BAA, GX_BIDI_CHARACTER_TYPE_L},
    {0x1BAE, 0x1BAF, GX_BIDI_CHARACTER_TYPE_L},
    {0x1BB0, 0x1BB9, GX_BIDI_CHARACTER_TYPE_L},
    {0x1C00, 0x1C23, GX_BIDI_CHARACTER_TYPE_L},
    {0x1C24, 0x1C2B, GX_BIDI_CHARACTER_TYPE_L},
    {0x1C34, 0x1C35, GX_BIDI_CHARACTER_TYPE_L},
    {0x1C3B, 0x1C3F, GX_BIDI_CHARACTER_TYPE_L},
    {0x1C40, 0x1C49, GX_BIDI_CHARACTER_TYPE_L},
    {0x1C4D, 0x1C4F, GX_BIDI_CHARACTER_TYPE_L},
    {0x1C50, 0x1C59, GX_BIDI_CHARACTER_TYPE_L},
    {0x1C5A, 0x1C77, GX_BIDI_CHARACTER_TYPE_L},
    {0x1C78, 0x1C7D, GX_BIDI_CHARACTER_TYPE_L},
    {0x1C7E, 0x1C7F, GX_BIDI_CHARACTER_TYPE_L},
    {0x1D00, 0x1D2B, GX_BIDI_CHARACTER_TYPE_L},
    {0x1D2C, 0x1D61, GX_BIDI_CHARACTER_TYPE_L},
    {0x1D62, 0x1D77, GX_BIDI_CHARACTER_TYPE_L},
    {0x1D78, 0x1D78, GX_BIDI_CHARACTER_TYPE_L},
    {0x1D79, 0x1D9A, GX_BIDI_CHARACTER_TYPE_L},
    {0x1D9B, 0x1DBF, GX_BIDI_CHARACTER_TYPE_L},
    {0x1E00, 0x1F15, GX_BIDI_CHARACTER_TYPE_L},
    {0x1F18, 0x1F1D, GX_BIDI_CHARACTER_TYPE_L},
    {0x1F20, 0x1F45, GX_BIDI_CHARACTER_TYPE_L},
    {0x1F48, 0x1F4D, GX_BIDI_CHARACTER_TYPE_L},
    {0x1F50, 0x1F57, GX_BIDI_CHARACTER_TYPE_L},
    {0x1F59, 0x1F59, GX_BIDI_CHARACTER_TYPE_L},
    {0x1F5B, 0x1F5B, GX_BIDI_CHARACTER_TYPE_L},
    {0x1F5D, 0x1F5D, GX_BIDI_CHARACTER_TYPE_L},
    {0x1F5F, 0x1F7D, GX_BIDI_CHARACTER_TYPE_L},
    {0x1F80, 0x1FB4, GX_BIDI_CHARACTER_TYPE_L},
    {0x1FB6, 0x1FBC, GX_BIDI_CHARACTER_TYPE_L},
    {0x1FBE, 0x1FBE, GX_BIDI_CHARACTER_TYPE_L},
    {0x1FC2, 0x1FC4, GX_BIDI_CHARACTER_TYPE_L},
    {0x1FC6, 0x1FCC, GX_BIDI_CHARACTER_TYPE_L},
    {0x1FD0, 0x1FD3, GX_BIDI_CHARACTER_TYPE_L},
    {0x1FD6, 0x1FDB, GX_BIDI_CHARACTER_TYPE_L},
    {0x1FE0, 0x1FEC, GX_BIDI_CHARACTER_TYPE_L},
    {0x1FF2, 0x1FF4, GX_BIDI_CHARACTER_TYPE_L},
    {0x1FF6, 0x1FFC, GX_BIDI_CHARACTER_TYPE_L},
    {0x200E, 0x200E, GX_BIDI_CHARACTER_TYPE_L},
    {0x2071, 0x2071, GX_BIDI_CHARACTER_TYPE_L},
    {0x207F, 0x207F, GX_BIDI_CHARACTER_TYPE_L},
    {0x2090, 0x2094, GX_BIDI_CHARACTER_TYPE_L},
    {0x2102, 0x2102, GX_BIDI_CHARACTER_TYPE_L},
    {0x2107, 0x2107, GX_BIDI_CHARACTER_TYPE_L},
    {0x210A, 0x2113, GX_BIDI_CHARACTER_TYPE_L},
    {0x2115, 0x2115, GX_BIDI_CHARACTER_TYPE_L},
    {0x2119, 0x211D, GX_BIDI_CHARACTER_TYPE_L},
    {0x2124, 0x2124, GX_BIDI_CHARACTER_TYPE_L},
    {0x2126, 0x2126, GX_BIDI_CHARACTER_TYPE_L},
    {0x2128, 0x2128, GX_BIDI_CHARACTER_TYPE_L},
    {0x212A, 0x212D, GX_BIDI_CHARACTER_TYPE_L},
    {0x212F, 0x2134, GX_BIDI_CHARACTER_TYPE_L},
    {0x2135, 0x2138, GX_BIDI_CHARACTER_TYPE_L},
    {0x2139, 0x2139, GX_BIDI_CHARACTER_TYPE_L},
    {0x213C, 0x213F, GX_BIDI_CHARACTER_TYPE_L},
    {0x2145, 0x2149, GX_BIDI_CHARACTER_TYPE_L},
    {0x214E, 0x214E, GX_BIDI_CHARACTER_TYPE_L},
    {0x214F, 0x214F, GX_BIDI_CHARACTER_TYPE_L},
    {0x2160, 0x2182, GX_BIDI_CHARACTER_TYPE_L},
    {0x2183, 0x2184, GX_BIDI_CHARACTER_TYPE_L},
    {0x2185, 0x2188, GX_BIDI_CHARACTER_TYPE_L},
    {0x2336, 0x237A, GX_BIDI_CHARACTER_TYPE_L},
    {0x2395, 0x2395, GX_BIDI_CHARACTER_TYPE_L},
    {0x249C, 0x24E9, GX_BIDI_CHARACTER_TYPE_L},
    {0x26AC, 0x26AC, GX_BIDI_CHARACTER_TYPE_L},
    {0x2800, 0x28FF, GX_BIDI_CHARACTER_TYPE_L},
    {0x2C00, 0x2C2E, GX_BIDI_CHARACTER_TYPE_L},
    {0x2C30, 0x2C5E, GX_BIDI_CHARACTER_TYPE_L},
    {0x2C60, 0x2C6F, GX_BIDI_CHARACTER_TYPE_L},
    {0x2C71, 0x2C7C, GX_BIDI_CHARACTER_TYPE_L},
    {0x2C7D, 0x2C7D, GX_BIDI_CHARACTER_TYPE_L},
    {0x2C80, 0x2CE4, GX_BIDI_CHARACTER_TYPE_L},
    {0x2D00, 0x2D25, GX_BIDI_CHARACTER_TYPE_L},
    {0x2D30, 0x2D65, GX_BIDI_CHARACTER_TYPE_L},
    {0x2D6F, 0x2D6F, GX_BIDI_CHARACTER_TYPE_L},
    {0x2D80, 0x2D96, GX_BIDI_CHARACTER_TYPE_L},
    {0x2DA0, 0x2DA6, GX_BIDI_CHARACTER_TYPE_L},
    {0x2DA8, 0x2DAE, GX_BIDI_CHARACTER_TYPE_L},
    {0x2DB0, 0x2DB6, GX_BIDI_CHARACTER_TYPE_L},
    {0x2DB8, 0x2DBE, GX_BIDI_CHARACTER_TYPE_L},
    {0x2DC0, 0x2DC6, GX_BIDI_CHARACTER_TYPE_L},
    {0x2DC8, 0x2DCE, GX_BIDI_CHARACTER_TYPE_L},
    {0x2DD0, 0x2DD6, GX_BIDI_CHARACTER_TYPE_L},
    {0x2DD8, 0x2DDE, GX_BIDI_CHARACTER_TYPE_L},
    {0x3005, 0x3005, GX_BIDI_CHARACTER_TYPE_L},
    {0x3006, 0x3006, GX_BIDI_CHARACTER_TYPE_L},
    {0x3007, 0x3007, GX_BIDI_CHARACTER_TYPE_L},
    {0x3021, 0x3029, GX_BIDI_CHARACTER_TYPE_L},
    {0x3031, 0x3035, GX_BIDI_CHARACTER_TYPE_L},
    {0x3038, 0x303A, GX_BIDI_CHARACTER_TYPE_L},
    {0x303B, 0x303B, GX_BIDI_CHARACTER_TYPE_L},
    {0x303C, 0x303C, GX_BIDI_CHARACTER_TYPE_L},
    {0x3041, 0x3096, GX_BIDI_CHARACTER_TYPE_L},
    {0x309D, 0x309E, GX_BIDI_CHARACTER_TYPE_L},
    {0x309F, 0x309F, GX_BIDI_CHARACTER_TYPE_L},
    {0x30A1, 0x30FA, GX_BIDI_CHARACTER_TYPE_L},
    {0x30FC, 0x30FE, GX_BIDI_CHARACTER_TYPE_L},
    {0x30FF, 0x30FF, GX_BIDI_CHARACTER_TYPE_L},
    {0x3105, 0x312D, GX_BIDI_CHARACTER_TYPE_L},
    {0x3131, 0x318E, GX_BIDI_CHARACTER_TYPE_L},
    {0x3190, 0x3191, GX_BIDI_CHARACTER_TYPE_L},
    {0x3192, 0x3195, GX_BIDI_CHARACTER_TYPE_L},
    {0x3196, 0x319F, GX_BIDI_CHARACTER_TYPE_L},
    {0x31A0, 0x31B7, GX_BIDI_CHARACTER_TYPE_L},
    {0x31F0, 0x31FF, GX_BIDI_CHARACTER_TYPE_L},
    {0x3200, 0x321C, GX_BIDI_CHARACTER_TYPE_L},
    {0x3220, 0x3229, GX_BIDI_CHARACTER_TYPE_L},
    {0x322A, 0x3243, GX_BIDI_CHARACTER_TYPE_L},
    {0x3260, 0x327B, GX_BIDI_CHARACTER_TYPE_L},
    {0x327F, 0x327F, GX_BIDI_CHARACTER_TYPE_L},
    {0x3280, 0x3289, GX_BIDI_CHARACTER_TYPE_L},
    {0x328A, 0x32B0, GX_BIDI_CHARACTER_TYPE_L},
    {0x32C0, 0x32CB, GX_BIDI_CHARACTER_TYPE_L},
    {0x32D0, 0x32FE, GX_BIDI_CHARACTER_TYPE_L},
    {0x3300, 0x3376, GX_BIDI_CHARACTER_TYPE_L},
    {0x337B, 0x33DD, GX_BIDI_CHARACTER_TYPE_L},
    {0x33E0, 0x33FE, GX_BIDI_CHARACTER_TYPE_L},
    {0x3400, 0x4DB5, GX_BIDI_CHARACTER_TYPE_L},
    {0x4E00, 0x9FC3, GX_BIDI_CHARACTER_TYPE_L},
    {0xA000, 0xA014, GX_BIDI_CHARACTER_TYPE_L},
    {0xA015, 0xA015, GX_BIDI_CHARACTER_TYPE_L},
    {0xA016, 0xA48C, GX_BIDI_CHARACTER_TYPE_L},
    {0xA500, 0xA60B, GX_BIDI_CHARACTER_TYPE_L},
    {0xA60C, 0xA60C, GX_BIDI_CHARACTER_TYPE_L},
    {0xA610, 0xA61F, GX_BIDI_CHARACTER_TYPE_L},
    {0xA620, 0xA629, GX_BIDI_CHARACTER_TYPE_L},
    {0xA62A, 0xA62B, GX_BIDI_CHARACTER_TYPE_L},
    {0xA640, 0xA65F, GX_BIDI_CHARACTER_TYPE_L},
    {0xA662, 0xA66D, GX_BIDI_CHARACTER_TYPE_L},
    {0xA66E, 0xA66E, GX_BIDI_CHARACTER_TYPE_L},
    {0xA680, 0xA697, GX_BIDI_CHARACTER_TYPE_L},
    {0xA722, 0xA76F, GX_BIDI_CHARACTER_TYPE_L},
    {0xA770, 0xA770, GX_BIDI_CHARACTER_TYPE_L},
    {0xA771, 0xA787, GX_BIDI_CHARACTER_TYPE_L},
    {0xA789, 0xA78A, GX_BIDI_CHARACTER_TYPE_L},
    {0xA78B, 0xA78C, GX_BIDI_CHARACTER_TYPE_L},
    {0xA7FB, 0xA801, GX_BIDI_CHARACTER_TYPE_L},
    {0xA803, 0xA805, GX_BIDI_CHARACTER_TYPE_L},
    {0xA807, 0xA80A, GX_BIDI_CHARACTER_TYPE_L},
    {0xA80C, 0xA822, GX_BIDI_CHARACTER_TYPE_L},
    {0xA823, 0xA824, GX_BIDI_CHARACTER_TYPE_L},
    {0xA827, 0xA827, GX_BIDI_CHARACTER_TYPE_L},
    {0xA840, 0xA873, GX_BIDI_CHARACTER_TYPE_L},
    {0xA880, 0xA881, GX_BIDI_CHARACTER_TYPE_L},
    {0xA882, 0xA8B3, GX_BIDI_CHARACTER_TYPE_L},
    {0xA8B4, 0xA8C3, GX_BIDI_CHARACTER_TYPE_L},
    {0xA8CE, 0xA8CF, GX_BIDI_CHARACTER_TYPE_L},
    {0xA8D0, 0xA8D9, GX_BIDI_CHARACTER_TYPE_L},
    {0xA900, 0xA909, GX_BIDI_CHARACTER_TYPE_L},
    {0xA90A, 0xA925, GX_BIDI_CHARACTER_TYPE_L},
    {0xA92E, 0xA92F, GX_BIDI_CHARACTER_TYPE_L},
    {0xA930, 0xA946, GX_BIDI_CHARACTER_TYPE_L},
    {0xA952, 0xA953, GX_BIDI_CHARACTER_TYPE_L},
    {0xA95F, 0xA95F, GX_BIDI_CHARACTER_TYPE_L},
    {0xAA00, 0xAA28, GX_BIDI_CHARACTER_TYPE_L},
    {0xAA2F, 0xAA30, GX_BIDI_CHARACTER_TYPE_L},
    {0xAA33, 0xAA34, GX_BIDI_CHARACTER_TYPE_L},
    {0xAA40, 0xAA42, GX_BIDI_CHARACTER_TYPE_L},
    {0xAA44, 0xAA4B, GX_BIDI_CHARACTER_TYPE_L},
    {0xAA4D, 0xAA4D, GX_BIDI_CHARACTER_TYPE_L},
    {0xAA50, 0xAA59, GX_BIDI_CHARACTER_TYPE_L},
    {0xAA5C, 0xAA5F, GX_BIDI_CHARACTER_TYPE_L},
    {0xAC00, 0xD7A3, GX_BIDI_CHARACTER_TYPE_L},
    {0xE000, 0xF8FF, GX_BIDI_CHARACTER_TYPE_L},
    {0xF900, 0xFA2D, GX_BIDI_CHARACTER_TYPE_L},
    {0xFA30, 0xFA6A, GX_BIDI_CHARACTER_TYPE_L},
    {0xFA70, 0xFAD9, GX_BIDI_CHARACTER_TYPE_L},
    {0xFB00, 0xFB06, GX_BIDI_CHARACTER_TYPE_L},
    {0xFB13, 0xFB17, GX_BIDI_CHARACTER_TYPE_L},
    {0xFF21, 0xFF3A, GX_BIDI_CHARACTER_TYPE_L},
    {0xFF41, 0xFF5A, GX_BIDI_CHARACTER_TYPE_L},
    {0xFF66, 0xFF6F, GX_BIDI_CHARACTER_TYPE_L},
    {0xFF70, 0xFF70, GX_BIDI_CHARACTER_TYPE_L},
    {0xFF71, 0xFF9D, GX_BIDI_CHARACTER_TYPE_L},
    {0xFF9E, 0xFF9F, GX_BIDI_CHARACTER_TYPE_L},
    {0xFFA0, 0xFFBE, GX_BIDI_CHARACTER_TYPE_L},
    {0xFFC2, 0xFFC7, GX_BIDI_CHARACTER_TYPE_L},
    {0xFFCA, 0xFFCF, GX_BIDI_CHARACTER_TYPE_L},
    {0xFFD2, 0xFFD7, GX_BIDI_CHARACTER_TYPE_L},
    {0xFFDA, 0xFFDC, GX_BIDI_CHARACTER_TYPE_L},
    {0x10000, 0x1000B, GX_BIDI_CHARACTER_TYPE_L},
    {0x1000D, 0x10026, GX_BIDI_CHARACTER_TYPE_L},
    {0x10028, 0x1003A, GX_BIDI_CHARACTER_TYPE_L},
    {0x1003C, 0x1003D, GX_BIDI_CHARACTER_TYPE_L},
    {0x1003F, 0x1004D, GX_BIDI_CHARACTER_TYPE_L},
    {0x10050, 0x1005D, GX_BIDI_CHARACTER_TYPE_L},
    {0x10080, 0x100FA, GX_BIDI_CHARACTER_TYPE_L},
    {0x10100, 0x10100, GX_BIDI_CHARACTER_TYPE_L},
    {0x10102, 0x10102, GX_BIDI_CHARACTER_TYPE_L},
    {0x10107, 0x10133, GX_BIDI_CHARACTER_TYPE_L},
    {0x10137, 0x1013F, GX_BIDI_CHARACTER_TYPE_L},
    {0x101D0, 0x101FC, GX_BIDI_CHARACTER_TYPE_L},
    {0x10280, 0x1029C, GX_BIDI_CHARACTER_TYPE_L},
    {0x102A0, 0x102D0, GX_BIDI_CHARACTER_TYPE_L},
    {0x10300, 0x1031E, GX_BIDI_CHARACTER_TYPE_L},
    {0x10320, 0x10323, GX_BIDI_CHARACTER_TYPE_L},
    {0x10330, 0x10340, GX_BIDI_CHARACTER_TYPE_L},
    {0x10341, 0x10341, GX_BIDI_CHARACTER_TYPE_L},
    {0x10342, 0x10349, GX_BIDI_CHARACTER_TYPE_L},
    {0x1034A, 0x1034A, GX_BIDI_CHARACTER_TYPE_L},
    {0x10380, 0x1039D, GX_BIDI_CHARACTER_TYPE_L},
    {0x1039F, 0x1039F, GX_BIDI_CHARACTER_TYPE_L},
    {0x103A0, 0x103C3, GX_BIDI_CHARACTER_TYPE_L},
    {0x103C8, 0x103CF, GX_BIDI_CHARACTER_TYPE_L},
    {0x103D0, 0x103D0, GX_BIDI_CHARACTER_TYPE_L},
    {0x103D1, 0x103D5, GX_BIDI_CHARACTER_TYPE_L},
    {0x10400, 0x1044F, GX_BIDI_CHARACTER_TYPE_L},
    {0x10450, 0x1049D, GX_BIDI_CHARACTER_TYPE_L},
    {0x104A0, 0x104A9, GX_BIDI_CHARACTER_TYPE_L},
    {0x12000, 0x1236E, GX_BIDI_CHARACTER_TYPE_L},
    {0x12400, 0x12462, GX_BIDI_CHARACTER_TYPE_L},
    {0x12470, 0x12473, GX_BIDI_CHARACTER_TYPE_L},
    {0x1D000, 0x1D0F5, GX_BIDI_CHARACTER_TYPE_L},
    {0x1D100, 0x1D126, GX_BIDI_CHARACTER_TYPE_L},
    {0x1D129, 0x1D164, GX_BIDI_CHARACTER_TYPE_L},
    {0x1D165, 0x1D166, GX_BIDI_CHARACTER_TYPE_L},
    {0x1D16A, 0x1D16C, GX_BIDI_CHARACTER_TYPE_L},
    {0x1D16D, 0x1D172, GX_BIDI_CHARACTER_TYPE_L},
    {0x1D183, 0x1D184, GX_BIDI_CHARACTER_TYPE_L},
    {0x1D18C, 0x1D1A9, GX_BIDI_CHARACTER_TYPE_L},
    {0x1D1AE, 0x1D1DD, GX_BIDI_CHARACTER_TYPE_L},
    {0x1D360, 0x1D371, GX_BIDI_CHARACTER_TYPE_L},
    {0x1D400, 0x1D454, GX_BIDI_CHARACTER_TYPE_L},
    {0x1D456, 0x1D49C, GX_BIDI_CHARACTER_TYPE_L},
    {0x1D49E, 0x1D49F, GX_BIDI_CHARACTER_TYPE_L},
    {0x1D4A2, 0x1D4A2, GX_BIDI_CHARACTER_TYPE_L},
    {0x1D4A5, 0x1D4A6, GX_BIDI_CHARACTER_TYPE_L},
    {0x1D4A9, 0x1D4AC, GX_BIDI_CHARACTER_TYPE_L},
    {0x1D4AE, 0x1D4B9, GX_BIDI_CHARACTER_TYPE_L},
    {0x1D4BB, 0x1D4BB, GX_BIDI_CHARACTER_TYPE_L},
    {0x1D4BD, 0x1D4C3, GX_BIDI_CHARACTER_TYPE_L},
    {0x1D4C5, 0x1D505, GX_BIDI_CHARACTER_TYPE_L},
    {0x1D507, 0x1D50A, GX_BIDI_CHARACTER_TYPE_L},
    {0x1D50D, 0x1D514, GX_BIDI_CHARACTER_TYPE_L},
    {0x1D516, 0x1D51C, GX_BIDI_CHARACTER_TYPE_L},
    {0x1D51E, 0x1D539, GX_BIDI_CHARACTER_TYPE_L},
    {0x1D53B, 0x1D53E, GX_BIDI_CHARACTER_TYPE_L},
    {0x1D540, 0x1D544, GX_BIDI_CHARACTER_TYPE_L},
    {0x1D546, 0x1D546, GX_BIDI_CHARACTER_TYPE_L},
    {0x1D54A, 0x1D550, GX_BIDI_CHARACTER_TYPE_L},
    {0x1D552, 0x1D6A5, GX_BIDI_CHARACTER_TYPE_L},
    {0x1D6A8, 0x1D6C0, GX_BIDI_CHARACTER_TYPE_L},
    {0x1D6C1, 0x1D6C1, GX_BIDI_CHARACTER_TYPE_L},
    {0x1D6C2, 0x1D6DA, GX_BIDI_CHARACTER_TYPE_L},
    {0x1D6DB, 0x1D6DB, GX_BIDI_CHARACTER_TYPE_L},
    {0x1D6DC, 0x1D6FA, GX_BIDI_CHARACTER_TYPE_L},
    {0x1D6FB, 0x1D6FB, GX_BIDI_CHARACTER_TYPE_L},
    {0x1D6FC, 0x1D714, GX_BIDI_CHARACTER_TYPE_L},
    {0x1D715, 0x1D715, GX_BIDI_CHARACTER_TYPE_L},
    {0x1D716, 0x1D734, GX_BIDI_CHARACTER_TYPE_L},
    {0x1D735, 0x1D735, GX_BIDI_CHARACTER_TYPE_L},
    {0x1D736, 0x1D74E, GX_BIDI_CHARACTER_TYPE_L},
    {0x1D74F, 0x1D74F, GX_BIDI_CHARACTER_TYPE_L},
    {0x1D750, 0x1D76E, GX_BIDI_CHARACTER_TYPE_L},
    {0x1D76F, 0x1D76F, GX_BIDI_CHARACTER_TYPE_L},
    {0x1D770, 0x1D788, GX_BIDI_CHARACTER_TYPE_L},
    {0x1D789, 0x1D789, GX_BIDI_CHARACTER_TYPE_L},
    {0x1D78A, 0x1D7A8, GX_BIDI_CHARACTER_TYPE_L},
    {0x1D7A9, 0x1D7A9, GX_BIDI_CHARACTER_TYPE_L},
    {0x1D7AA, 0x1D7C2, GX_BIDI_CHARACTER_TYPE_L},
    {0x1D7C3, 0x1D7C3, GX_BIDI_CHARACTER_TYPE_L},
    {0x1D7C4, 0x1D7CB, GX_BIDI_CHARACTER_TYPE_L},
    {0x20000, 0x2A6D6, GX_BIDI_CHARACTER_TYPE_L},
    {0x2F800, 0x2FA1D, GX_BIDI_CHARACTER_TYPE_L},
    {0xF0000, 0xFFFFD, GX_BIDI_CHARACTER_TYPE_L},
    {0x100000, 0x10FFFD, GX_BIDI_CHARACTER_TYPE_L},
    {0x0590, 0x0590, GX_BIDI_CHARACTER_TYPE_R},
    {0x05BE, 0x05BE, GX_BIDI_CHARACTER_TYPE_R},
    {0x05C0, 0x05C0, GX_BIDI_CHARACTER_TYPE_R},
    {0x05C3, 0x05C3, GX_BIDI_CHARACTER_TYPE_R},
    {0x05C6, 0x05C6, GX_BIDI_CHARACTER_TYPE_R},
    {0x05C8, 0x05CF, GX_BIDI_CHARACTER_TYPE_R},
    {0x05D0, 0x05EA, GX_BIDI_CHARACTER_TYPE_R},
    {0x05EB, 0x05EF, GX_BIDI_CHARACTER_TYPE_R},
    {0x05F0, 0x05F2, GX_BIDI_CHARACTER_TYPE_R},
    {0x05F3, 0x05F4, GX_BIDI_CHARACTER_TYPE_R},
    {0x05F5, 0x05FF, GX_BIDI_CHARACTER_TYPE_R},
    {0x07C0, 0x07C9, GX_BIDI_CHARACTER_TYPE_R},
    {0x07CA, 0x07EA, GX_BIDI_CHARACTER_TYPE_R},
    {0x07F4, 0x07F5, GX_BIDI_CHARACTER_TYPE_R},
    {0x07FA, 0x07FA, GX_BIDI_CHARACTER_TYPE_R},
    {0x07FB, 0x08FF, GX_BIDI_CHARACTER_TYPE_R},
    {0x200F, 0x200F, GX_BIDI_CHARACTER_TYPE_R},
    {0xFB1D, 0xFB1D, GX_BIDI_CHARACTER_TYPE_R},
    {0xFB1F, 0xFB28, GX_BIDI_CHARACTER_TYPE_R},
    {0xFB2A, 0xFB36, GX_BIDI_CHARACTER_TYPE_R},
    {0xFB37, 0xFB37, GX_BIDI_CHARACTER_TYPE_R},
    {0xFB38, 0xFB3C, GX_BIDI_CHARACTER_TYPE_R},
    {0xFB3D, 0xFB3D, GX_BIDI_CHARACTER_TYPE_R},
    {0xFB3E, 0xFB3E, GX_BIDI_CHARACTER_TYPE_R},
    {0xFB3F, 0xFB3F, GX_BIDI_CHARACTER_TYPE_R},
    {0xFB40, 0xFB41, GX_BIDI_CHARACTER_TYPE_R},
    {0xFB42, 0xFB42, GX_BIDI_CHARACTER_TYPE_R},
    {0xFB43, 0xFB44, GX_BIDI_CHARACTER_TYPE_R},
    {0xFB45, 0xFB45, GX_BIDI_CHARACTER_TYPE_R},
    {0xFB46, 0xFB4F, GX_BIDI_CHARACTER_TYPE_R},
    {0x10800, 0x10805, GX_BIDI_CHARACTER_TYPE_R},
    {0x10806, 0x10807, GX_BIDI_CHARACTER_TYPE_R},
    {0x10808, 0x10808, GX_BIDI_CHARACTER_TYPE_R},
    {0x10809, 0x10809, GX_BIDI_CHARACTER_TYPE_R},
    {0x1080A, 0x10835, GX_BIDI_CHARACTER_TYPE_R},
    {0x10836, 0x10836, GX_BIDI_CHARACTER_TYPE_R},
    {0x10837, 0x10838, GX_BIDI_CHARACTER_TYPE_R},
    {0x10839, 0x1083B, GX_BIDI_CHARACTER_TYPE_R},
    {0x1083C, 0x1083C, GX_BIDI_CHARACTER_TYPE_R},
    {0x1083D, 0x1083E, GX_BIDI_CHARACTER_TYPE_R},
    {0x1083F, 0x1083F, GX_BIDI_CHARACTER_TYPE_R},
    {0x10840, 0x108FF, GX_BIDI_CHARACTER_TYPE_R},
    {0x10900, 0x10915, GX_BIDI_CHARACTER_TYPE_R},
    {0x10916, 0x10919, GX_BIDI_CHARACTER_TYPE_R},
    {0x1091A, 0x1091E, GX_BIDI_CHARACTER_TYPE_R},
    {0x10920, 0x10939, GX_BIDI_CHARACTER_TYPE_R},
    {0x1093A, 0x1093E, GX_BIDI_CHARACTER_TYPE_R},
    {0x1093F, 0x1093F, GX_BIDI_CHARACTER_TYPE_R},
    {0x10940, 0x109FF, GX_BIDI_CHARACTER_TYPE_R},
    {0x10A00, 0x10A00, GX_BIDI_CHARACTER_TYPE_R},
    {0x10A04, 0x10A04, GX_BIDI_CHARACTER_TYPE_R},
    {0x10A07, 0x10A0B, GX_BIDI_CHARACTER_TYPE_R},
    {0x10A10, 0x10A13, GX_BIDI_CHARACTER_TYPE_R},
    {0x10A14, 0x10A14, GX_BIDI_CHARACTER_TYPE_R},
    {0x10A15, 0x10A17, GX_BIDI_CHARACTER_TYPE_R},
    {0x10A18, 0x10A18, GX_BIDI_CHARACTER_TYPE_R},
    {0x10A19, 0x10A33, GX_BIDI_CHARACTER_TYPE_R},
    {0x10A34, 0x10A37, GX_BIDI_CHARACTER_TYPE_R},
    {0x10A3B, 0x10A3E, GX_BIDI_CHARACTER_TYPE_R},
    {0x10A40, 0x10A47, GX_BIDI_CHARACTER_TYPE_R},
    {0x10A48, 0x10A4F, GX_BIDI_CHARACTER_TYPE_R},
    {0x10A50, 0x10A58, GX_BIDI_CHARACTER_TYPE_R},
    {0x10A59, 0x10FFF, GX_BIDI_CHARACTER_TYPE_R},
    {0x0030, 0x0039, GX_BIDI_CHARACTER_TYPE_EN},
    {0x00B2, 0x00B3, GX_BIDI_CHARACTER_TYPE_EN},
    {0x00B9, 0x00B9, GX_BIDI_CHARACTER_TYPE_EN},
    {0x06F0, 0x06F9, GX_BIDI_CHARACTER_TYPE_EN},
    {0x2070, 0x2070, GX_BIDI_CHARACTER_TYPE_EN},
    {0x2074, 0x2079, GX_BIDI_CHARACTER_TYPE_EN},
    {0x2080, 0x2089, GX_BIDI_CHARACTER_TYPE_EN},
    {0x2488, 0x249B, GX_BIDI_CHARACTER_TYPE_EN},
    {0xFF10, 0xFF19, GX_BIDI_CHARACTER_TYPE_EN},
    {0x1D7CE, 0x1D7FF, GX_BIDI_CHARACTER_TYPE_EN},
    {0x002B, 0x002B, GX_BIDI_CHARACTER_TYPE_ES},
    {0x002D, 0x002D, GX_BIDI_CHARACTER_TYPE_ES},
    {0x207A, 0x207B, GX_BIDI_CHARACTER_TYPE_ES},
    {0x208A, 0x208B, GX_BIDI_CHARACTER_TYPE_ES},
    {0x2212, 0x2212, GX_BIDI_CHARACTER_TYPE_ES},
    {0xFB29, 0xFB29, GX_BIDI_CHARACTER_TYPE_ES},
    {0xFE62, 0xFE62, GX_BIDI_CHARACTER_TYPE_ES},
    {0xFE63, 0xFE63, GX_BIDI_CHARACTER_TYPE_ES},
    {0xFF0B, 0xFF0B, GX_BIDI_CHARACTER_TYPE_ES},
    {0xFF0D, 0xFF0D, GX_BIDI_CHARACTER_TYPE_ES},
    {0x0023, 0x0023, GX_BIDI_CHARACTER_TYPE_ET},
    {0x0024, 0x0024, GX_BIDI_CHARACTER_TYPE_ET},
    {0x0025, 0x0025, GX_BIDI_CHARACTER_TYPE_ET},
    {0x00A2, 0x00A5, GX_BIDI_CHARACTER_TYPE_ET},
    {0x00B0, 0x00B0, GX_BIDI_CHARACTER_TYPE_ET},
    {0x00B1, 0x00B1, GX_BIDI_CHARACTER_TYPE_ET},
    {0x0609, 0x060A, GX_BIDI_CHARACTER_TYPE_ET},
    {0x066A, 0x066A, GX_BIDI_CHARACTER_TYPE_ET},
    {0x09F2, 0x09F3, GX_BIDI_CHARACTER_TYPE_ET},
    {0x0AF1, 0x0AF1, GX_BIDI_CHARACTER_TYPE_ET},
    {0x0BF9, 0x0BF9, GX_BIDI_CHARACTER_TYPE_ET},
    {0x0E3F, 0x0E3F, GX_BIDI_CHARACTER_TYPE_ET},
    {0x17DB, 0x17DB, GX_BIDI_CHARACTER_TYPE_ET},
    {0x2030, 0x2034, GX_BIDI_CHARACTER_TYPE_ET},
    {0x20A0, 0x20B5, GX_BIDI_CHARACTER_TYPE_ET},
    {0x212E, 0x212E, GX_BIDI_CHARACTER_TYPE_ET},
    {0x2213, 0x2213, GX_BIDI_CHARACTER_TYPE_ET},
    {0xFE5F, 0xFE5F, GX_BIDI_CHARACTER_TYPE_ET},
    {0xFE69, 0xFE69, GX_BIDI_CHARACTER_TYPE_ET},
    {0xFE6A, 0xFE6A, GX_BIDI_CHARACTER_TYPE_ET},
    {0xFF03, 0xFF03, GX_BIDI_CHARACTER_TYPE_ET},
    {0xFF04, 0xFF04, GX_BIDI_CHARACTER_TYPE_ET},
    {0xFF05, 0xFF05, GX_BIDI_CHARACTER_TYPE_ET},
    {0xFFE0, 0xFFE1, GX_BIDI_CHARACTER_TYPE_ET},
    {0xFFE5, 0xFFE6, GX_BIDI_CHARACTER_TYPE_ET},
    {0x0600, 0x0603, GX_BIDI_CHARACTER_TYPE_AN},
    {0x0660, 0x0669, GX_BIDI_CHARACTER_TYPE_AN},
    {0x066B, 0x066C, GX_BIDI_CHARACTER_TYPE_AN},
    {0x06DD, 0x06DD, GX_BIDI_CHARACTER_TYPE_AN},
    {0x002C, 0x002C, GX_BIDI_CHARACTER_TYPE_CS},
    {0x002E, 0x002F, GX_BIDI_CHARACTER_TYPE_CS},
    {0x003A, 0x003A, GX_BIDI_CHARACTER_TYPE_CS},
    {0x00A0, 0x00A0, GX_BIDI_CHARACTER_TYPE_CS},
    {0x060C, 0x060C, GX_BIDI_CHARACTER_TYPE_CS},
    {0x202F, 0x202F, GX_BIDI_CHARACTER_TYPE_CS},
    {0x2044, 0x2044, GX_BIDI_CHARACTER_TYPE_CS},
    {0xFE50, 0xFE50, GX_BIDI_CHARACTER_TYPE_CS},
    {0xFE52, 0xFE52, GX_BIDI_CHARACTER_TYPE_CS},
    {0xFE55, 0xFE55, GX_BIDI_CHARACTER_TYPE_CS},
    {0xFF0C, 0xFF0C, GX_BIDI_CHARACTER_TYPE_CS},
    {0xFF0E, 0xFF0F, GX_BIDI_CHARACTER_TYPE_CS},
    {0xFF1A, 0xFF1A, GX_BIDI_CHARACTER_TYPE_CS},
    {0x000A, 0x000A, GX_BIDI_CHARACTER_TYPE_B},
    {0x000D, 0x000D, GX_BIDI_CHARACTER_TYPE_B},
    {0x001C, 0x001E, GX_BIDI_CHARACTER_TYPE_B},
    {0x0085, 0x0085, GX_BIDI_CHARACTER_TYPE_B},
    {0x2029, 0x2029, GX_BIDI_CHARACTER_TYPE_B},
    {0x0009, 0x0009, GX_BIDI_CHARACTER_TYPE_S},
    {0x000B, 0x000B, GX_BIDI_CHARACTER_TYPE_S},
    {0x001F, 0x001F, GX_BIDI_CHARACTER_TYPE_S},
    {0x000C, 0x000C, GX_BIDI_CHARACTER_TYPE_WS},
    {0x0020, 0x0020, GX_BIDI_CHARACTER_TYPE_WS},
    {0x1680, 0x1680, GX_BIDI_CHARACTER_TYPE_WS},
    {0x180E, 0x180E, GX_BIDI_CHARACTER_TYPE_WS},
    {0x2000, 0x200A, GX_BIDI_CHARACTER_TYPE_WS},
    {0x2028, 0x2028, GX_BIDI_CHARACTER_TYPE_WS},
    {0x205F, 0x205F, GX_BIDI_CHARACTER_TYPE_WS},
    {0x3000, 0x3000, GX_BIDI_CHARACTER_TYPE_WS},
    {0x0021, 0x0022, GX_BIDI_CHARACTER_TYPE_ON},
    {0x0026, 0x0027, GX_BIDI_CHARACTER_TYPE_ON},
    {0x0028, 0x0028, GX_BIDI_CHARACTER_TYPE_ON},
    {0x0029, 0x0029, GX_BIDI_CHARACTER_TYPE_ON},
    {0x002A, 0x002A, GX_BIDI_CHARACTER_TYPE_ON},
    {0x003B, 0x003B, GX_BIDI_CHARACTER_TYPE_ON},
    {0x003C, 0x003E, GX_BIDI_CHARACTER_TYPE_ON},
    {0x003F, 0x0040, GX_BIDI_CHARACTER_TYPE_ON},
    {0x005B, 0x005B, GX_BIDI_CHARACTER_TYPE_ON},
    {0x005C, 0x005C, GX_BIDI_CHARACTER_TYPE_ON},
    {0x005D, 0x005D, GX_BIDI_CHARACTER_TYPE_ON},
    {0x005E, 0x005E, GX_BIDI_CHARACTER_TYPE_ON},
    {0x005F, 0x005F, GX_BIDI_CHARACTER_TYPE_ON},
    {0x0060, 0x0060, GX_BIDI_CHARACTER_TYPE_ON},
    {0x007B, 0x007B, GX_BIDI_CHARACTER_TYPE_ON},
    {0x007C, 0x007C, GX_BIDI_CHARACTER_TYPE_ON},
    {0x007D, 0x007D, GX_BIDI_CHARACTER_TYPE_ON},
    {0x007E, 0x007E, GX_BIDI_CHARACTER_TYPE_ON},
    {0x00A1, 0x00A1, GX_BIDI_CHARACTER_TYPE_ON},
    {0x00A6, 0x00A7, GX_BIDI_CHARACTER_TYPE_ON},
    {0x00A8, 0x00A8, GX_BIDI_CHARACTER_TYPE_ON},
    {0x00A9, 0x00A9, GX_BIDI_CHARACTER_TYPE_ON},
    {0x00AB, 0x00AB, GX_BIDI_CHARACTER_TYPE_ON},
    {0x00AC, 0x00AC, GX_BIDI_CHARACTER_TYPE_ON},
    {0x00AE, 0x00AE, GX_BIDI_CHARACTER_TYPE_ON},
    {0x00AF, 0x00AF, GX_BIDI_CHARACTER_TYPE_ON},
    {0x00B4, 0x00B4, GX_BIDI_CHARACTER_TYPE_ON},
    {0x00B6, 0x00B6, GX_BIDI_CHARACTER_TYPE_ON},
    {0x00B7, 0x00B7, GX_BIDI_CHARACTER_TYPE_ON},
    {0x00B8, 0x00B8, GX_BIDI_CHARACTER_TYPE_ON},
    {0x00BB, 0x00BB, GX_BIDI_CHARACTER_TYPE_ON},
    {0x00BC, 0x00BE, GX_BIDI_CHARACTER_TYPE_ON},
    {0x00BF, 0x00BF, GX_BIDI_CHARACTER_TYPE_ON},
    {0x00D7, 0x00D7, GX_BIDI_CHARACTER_TYPE_ON},
    {0x00F7, 0x00F7, GX_BIDI_CHARACTER_TYPE_ON},
    {0x02B9, 0x02BA, GX_BIDI_CHARACTER_TYPE_ON},
    {0x02C2, 0x02C5, GX_BIDI_CHARACTER_TYPE_ON},
    {0x02C6, 0x02CF, GX_BIDI_CHARACTER_TYPE_ON},
    {0x02D2, 0x02DF, GX_BIDI_CHARACTER_TYPE_ON},
    {0x02E5, 0x02EB, GX_BIDI_CHARACTER_TYPE_ON},
    {0x02EC, 0x02EC, GX_BIDI_CHARACTER_TYPE_ON},
    {0x02ED, 0x02ED, GX_BIDI_CHARACTER_TYPE_ON},
    {0x02EF, 0x02FF, GX_BIDI_CHARACTER_TYPE_ON},
    {0x0374, 0x0374, GX_BIDI_CHARACTER_TYPE_ON},
    {0x0375, 0x0375, GX_BIDI_CHARACTER_TYPE_ON},
    {0x037E, 0x037E, GX_BIDI_CHARACTER_TYPE_ON},
    {0x0384, 0x0385, GX_BIDI_CHARACTER_TYPE_ON},
    {0x0387, 0x0387, GX_BIDI_CHARACTER_TYPE_ON},
    {0x03F6, 0x03F6, GX_BIDI_CHARACTER_TYPE_ON},
    {0x058A, 0x058A, GX_BIDI_CHARACTER_TYPE_ON},
    {0x0606, 0x0607, GX_BIDI_CHARACTER_TYPE_ON},
    {0x060E, 0x060F, GX_BIDI_CHARACTER_TYPE_ON},
    {0x06E9, 0x06E9, GX_BIDI_CHARACTER_TYPE_ON},
    {0x07F6, 0x07F6, GX_BIDI_CHARACTER_TYPE_ON},
    {0x07F7, 0x07F9, GX_BIDI_CHARACTER_TYPE_ON},
    {0x0BF3, 0x0BF8, GX_BIDI_CHARACTER_TYPE_ON},
    {0x0BFA, 0x0BFA, GX_BIDI_CHARACTER_TYPE_ON},
    {0x0C78, 0x0C7E, GX_BIDI_CHARACTER_TYPE_ON},
    {0x0CF1, 0x0CF2, GX_BIDI_CHARACTER_TYPE_ON},
    {0x0F3A, 0x0F3A, GX_BIDI_CHARACTER_TYPE_ON},
    {0x0F3B, 0x0F3B, GX_BIDI_CHARACTER_TYPE_ON},
    {0x0F3C, 0x0F3C, GX_BIDI_CHARACTER_TYPE_ON},
    {0x0F3D, 0x0F3D, GX_BIDI_CHARACTER_TYPE_ON},
    {0x1390, 0x1399, GX_BIDI_CHARACTER_TYPE_ON},
    {0x169B, 0x169B, GX_BIDI_CHARACTER_TYPE_ON},
    {0x169C, 0x169C, GX_BIDI_CHARACTER_TYPE_ON},
    {0x17F0, 0x17F9, GX_BIDI_CHARACTER_TYPE_ON},
    {0x1800, 0x1805, GX_BIDI_CHARACTER_TYPE_ON},
    {0x1806, 0x1806, GX_BIDI_CHARACTER_TYPE_ON},
    {0x1807, 0x180A, GX_BIDI_CHARACTER_TYPE_ON},
    {0x1940, 0x1940, GX_BIDI_CHARACTER_TYPE_ON},
    {0x1944, 0x1945, GX_BIDI_CHARACTER_TYPE_ON},
    {0x19DE, 0x19DF, GX_BIDI_CHARACTER_TYPE_ON},
    {0x19E0, 0x19FF, GX_BIDI_CHARACTER_TYPE_ON},
    {0x1FBD, 0x1FBD, GX_BIDI_CHARACTER_TYPE_ON},
    {0x1FBF, 0x1FC1, GX_BIDI_CHARACTER_TYPE_ON},
    {0x1FCD, 0x1FCF, GX_BIDI_CHARACTER_TYPE_ON},
    {0x1FDD, 0x1FDF, GX_BIDI_CHARACTER_TYPE_ON},
    {0x1FED, 0x1FEF, GX_BIDI_CHARACTER_TYPE_ON},
    {0x1FFD, 0x1FFE, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2010, 0x2015, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2016, 0x2017, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2018, 0x2018, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2019, 0x2019, GX_BIDI_CHARACTER_TYPE_ON},
    {0x201A, 0x201A, GX_BIDI_CHARACTER_TYPE_ON},
    {0x201B, 0x201C, GX_BIDI_CHARACTER_TYPE_ON},
    {0x201D, 0x201D, GX_BIDI_CHARACTER_TYPE_ON},
    {0x201E, 0x201E, GX_BIDI_CHARACTER_TYPE_ON},
    {0x201F, 0x201F, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2020, 0x2027, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2035, 0x2038, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2039, 0x2039, GX_BIDI_CHARACTER_TYPE_ON},
    {0x203A, 0x203A, GX_BIDI_CHARACTER_TYPE_ON},
    {0x203B, 0x203E, GX_BIDI_CHARACTER_TYPE_ON},
    {0x203F, 0x2040, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2041, 0x2043, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2045, 0x2045, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2046, 0x2046, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2047, 0x2051, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2052, 0x2052, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2053, 0x2053, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2054, 0x2054, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2055, 0x205E, GX_BIDI_CHARACTER_TYPE_ON},
    {0x207C, 0x207C, GX_BIDI_CHARACTER_TYPE_ON},
    {0x207D, 0x207D, GX_BIDI_CHARACTER_TYPE_ON},
    {0x207E, 0x207E, GX_BIDI_CHARACTER_TYPE_ON},
    {0x208C, 0x208C, GX_BIDI_CHARACTER_TYPE_ON},
    {0x208D, 0x208D, GX_BIDI_CHARACTER_TYPE_ON},
    {0x208E, 0x208E, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2100, 0x2101, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2103, 0x2106, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2108, 0x2109, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2114, 0x2114, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2116, 0x2118, GX_BIDI_CHARACTER_TYPE_ON},
    {0x211E, 0x2123, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2125, 0x2125, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2127, 0x2127, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2129, 0x2129, GX_BIDI_CHARACTER_TYPE_ON},
    {0x213A, 0x213B, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2140, 0x2144, GX_BIDI_CHARACTER_TYPE_ON},
    {0x214A, 0x214A, GX_BIDI_CHARACTER_TYPE_ON},
    {0x214B, 0x214B, GX_BIDI_CHARACTER_TYPE_ON},
    {0x214C, 0x214D, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2153, 0x215F, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2190, 0x2194, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2195, 0x2199, GX_BIDI_CHARACTER_TYPE_ON},
    {0x219A, 0x219B, GX_BIDI_CHARACTER_TYPE_ON},
    {0x219C, 0x219F, GX_BIDI_CHARACTER_TYPE_ON},
    {0x21A0, 0x21A0, GX_BIDI_CHARACTER_TYPE_ON},
    {0x21A1, 0x21A2, GX_BIDI_CHARACTER_TYPE_ON},
    {0x21A3, 0x21A3, GX_BIDI_CHARACTER_TYPE_ON},
    {0x21A4, 0x21A5, GX_BIDI_CHARACTER_TYPE_ON},
    {0x21A6, 0x21A6, GX_BIDI_CHARACTER_TYPE_ON},
    {0x21A7, 0x21AD, GX_BIDI_CHARACTER_TYPE_ON},
    {0x21AE, 0x21AE, GX_BIDI_CHARACTER_TYPE_ON},
    {0x21AF, 0x21CD, GX_BIDI_CHARACTER_TYPE_ON},
    {0x21CE, 0x21CF, GX_BIDI_CHARACTER_TYPE_ON},
    {0x21D0, 0x21D1, GX_BIDI_CHARACTER_TYPE_ON},
    {0x21D2, 0x21D2, GX_BIDI_CHARACTER_TYPE_ON},
    {0x21D3, 0x21D3, GX_BIDI_CHARACTER_TYPE_ON},
    {0x21D4, 0x21D4, GX_BIDI_CHARACTER_TYPE_ON},
    {0x21D5, 0x21F3, GX_BIDI_CHARACTER_TYPE_ON},
    {0x21F4, 0x2211, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2214, 0x22FF, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2300, 0x2307, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2308, 0x230B, GX_BIDI_CHARACTER_TYPE_ON},
    {0x230C, 0x231F, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2320, 0x2321, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2322, 0x2328, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2329, 0x2329, GX_BIDI_CHARACTER_TYPE_ON},
    {0x232A, 0x232A, GX_BIDI_CHARACTER_TYPE_ON},
    {0x232B, 0x2335, GX_BIDI_CHARACTER_TYPE_ON},
    {0x237B, 0x237B, GX_BIDI_CHARACTER_TYPE_ON},
    {0x237C, 0x237C, GX_BIDI_CHARACTER_TYPE_ON},
    {0x237D, 0x2394, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2396, 0x239A, GX_BIDI_CHARACTER_TYPE_ON},
    {0x239B, 0x23B3, GX_BIDI_CHARACTER_TYPE_ON},
    {0x23B4, 0x23DB, GX_BIDI_CHARACTER_TYPE_ON},
    {0x23DC, 0x23E1, GX_BIDI_CHARACTER_TYPE_ON},
    {0x23E2, 0x23E7, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2400, 0x2426, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2440, 0x244A, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2460, 0x2487, GX_BIDI_CHARACTER_TYPE_ON},
    {0x24EA, 0x24FF, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2500, 0x25B6, GX_BIDI_CHARACTER_TYPE_ON},
    {0x25B7, 0x25B7, GX_BIDI_CHARACTER_TYPE_ON},
    {0x25B8, 0x25C0, GX_BIDI_CHARACTER_TYPE_ON},
    {0x25C1, 0x25C1, GX_BIDI_CHARACTER_TYPE_ON},
    {0x25C2, 0x25F7, GX_BIDI_CHARACTER_TYPE_ON},
    {0x25F8, 0x25FF, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2600, 0x266E, GX_BIDI_CHARACTER_TYPE_ON},
    {0x266F, 0x266F, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2670, 0x269D, GX_BIDI_CHARACTER_TYPE_ON},
    {0x26A0, 0x26AB, GX_BIDI_CHARACTER_TYPE_ON},
    {0x26AD, 0x26BC, GX_BIDI_CHARACTER_TYPE_ON},
    {0x26C0, 0x26C3, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2701, 0x2704, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2706, 0x2709, GX_BIDI_CHARACTER_TYPE_ON},
    {0x270C, 0x2727, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2729, 0x274B, GX_BIDI_CHARACTER_TYPE_ON},
    {0x274D, 0x274D, GX_BIDI_CHARACTER_TYPE_ON},
    {0x274F, 0x2752, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2756, 0x2756, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2758, 0x275E, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2761, 0x2767, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2768, 0x2768, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2769, 0x2769, GX_BIDI_CHARACTER_TYPE_ON},
    {0x276A, 0x276A, GX_BIDI_CHARACTER_TYPE_ON},
    {0x276B, 0x276B, GX_BIDI_CHARACTER_TYPE_ON},
    {0x276C, 0x276C, GX_BIDI_CHARACTER_TYPE_ON},
    {0x276D, 0x276D, GX_BIDI_CHARACTER_TYPE_ON},
    {0x276E, 0x276E, GX_BIDI_CHARACTER_TYPE_ON},
    {0x276F, 0x276F, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2770, 0x2770, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2771, 0x2771, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2772, 0x2772, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2773, 0x2773, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2774, 0x2774, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2775, 0x2775, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2776, 0x2793, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2794, 0x2794, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2798, 0x27AF, GX_BIDI_CHARACTER_TYPE_ON},
    {0x27B1, 0x27BE, GX_BIDI_CHARACTER_TYPE_ON},
    {0x27C0, 0x27C4, GX_BIDI_CHARACTER_TYPE_ON},
    {0x27C5, 0x27C5, GX_BIDI_CHARACTER_TYPE_ON},
    {0x27C6, 0x27C6, GX_BIDI_CHARACTER_TYPE_ON},
    {0x27C7, 0x27CA, GX_BIDI_CHARACTER_TYPE_ON},
    {0x27CC, 0x27CC, GX_BIDI_CHARACTER_TYPE_ON},
    {0x27D0, 0x27E5, GX_BIDI_CHARACTER_TYPE_ON},
    {0x27E6, 0x27E6, GX_BIDI_CHARACTER_TYPE_ON},
    {0x27E7, 0x27E7, GX_BIDI_CHARACTER_TYPE_ON},
    {0x27E8, 0x27E8, GX_BIDI_CHARACTER_TYPE_ON},
    {0x27E9, 0x27E9, GX_BIDI_CHARACTER_TYPE_ON},
    {0x27EA, 0x27EA, GX_BIDI_CHARACTER_TYPE_ON},
    {0x27EB, 0x27EB, GX_BIDI_CHARACTER_TYPE_ON},
    {0x27EC, 0x27EC, GX_BIDI_CHARACTER_TYPE_ON},
    {0x27ED, 0x27ED, GX_BIDI_CHARACTER_TYPE_ON},
    {0x27EE, 0x27EE, GX_BIDI_CHARACTER_TYPE_ON},
    {0x27EF, 0x27EF, GX_BIDI_CHARACTER_TYPE_ON},
    {0x27F0, 0x27FF, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2900, 0x2982, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2983, 0x2983, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2984, 0x2984, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2985, 0x2985, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2986, 0x2986, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2987, 0x2987, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2988, 0x2988, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2989, 0x2989, GX_BIDI_CHARACTER_TYPE_ON},
    {0x298A, 0x298A, GX_BIDI_CHARACTER_TYPE_ON},
    {0x298B, 0x298B, GX_BIDI_CHARACTER_TYPE_ON},
    {0x298C, 0x298C, GX_BIDI_CHARACTER_TYPE_ON},
    {0x298D, 0x298D, GX_BIDI_CHARACTER_TYPE_ON},
    {0x298E, 0x298E, GX_BIDI_CHARACTER_TYPE_ON},
    {0x298F, 0x298F, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2990, 0x2990, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2991, 0x2991, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2992, 0x2992, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2993, 0x2993, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2994, 0x2994, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2995, 0x2995, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2996, 0x2996, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2997, 0x2997, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2998, 0x2998, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2999, 0x29D7, GX_BIDI_CHARACTER_TYPE_ON},
    {0x29D8, 0x29D8, GX_BIDI_CHARACTER_TYPE_ON},
    {0x29D9, 0x29D9, GX_BIDI_CHARACTER_TYPE_ON},
    {0x29DA, 0x29DA, GX_BIDI_CHARACTER_TYPE_ON},
    {0x29DB, 0x29DB, GX_BIDI_CHARACTER_TYPE_ON},
    {0x29DC, 0x29FB, GX_BIDI_CHARACTER_TYPE_ON},
    {0x29FC, 0x29FC, GX_BIDI_CHARACTER_TYPE_ON},
    {0x29FD, 0x29FD, GX_BIDI_CHARACTER_TYPE_ON},
    {0x29FE, 0x2AFF, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2B00, 0x2B2F, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2B30, 0x2B44, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2B45, 0x2B46, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2B47, 0x2B4C, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2B50, 0x2B54, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2CE5, 0x2CEA, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2CF9, 0x2CFC, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2CFD, 0x2CFD, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2CFE, 0x2CFF, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2E00, 0x2E01, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2E02, 0x2E02, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2E03, 0x2E03, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2E04, 0x2E04, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2E05, 0x2E05, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2E06, 0x2E08, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2E09, 0x2E09, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2E0A, 0x2E0A, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2E0B, 0x2E0B, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2E0C, 0x2E0C, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2E0D, 0x2E0D, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2E0E, 0x2E16, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2E17, 0x2E17, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2E18, 0x2E19, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2E1A, 0x2E1A, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2E1B, 0x2E1B, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2E1C, 0x2E1C, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2E1D, 0x2E1D, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2E1E, 0x2E1F, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2E20, 0x2E20, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2E21, 0x2E21, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2E22, 0x2E22, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2E23, 0x2E23, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2E24, 0x2E24, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2E25, 0x2E25, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2E26, 0x2E26, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2E27, 0x2E27, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2E28, 0x2E28, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2E29, 0x2E29, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2E2A, 0x2E2E, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2E2F, 0x2E2F, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2E30, 0x2E30, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2E80, 0x2E99, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2E9B, 0x2EF3, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2F00, 0x2FD5, GX_BIDI_CHARACTER_TYPE_ON},
    {0x2FF0, 0x2FFB, GX_BIDI_CHARACTER_TYPE_ON},
    {0x3001, 0x3003, GX_BIDI_CHARACTER_TYPE_ON},
    {0x3004, 0x3004, GX_BIDI_CHARACTER_TYPE_ON},
    {0x3008, 0x3008, GX_BIDI_CHARACTER_TYPE_ON},
    {0x3009, 0x3009, GX_BIDI_CHARACTER_TYPE_ON},
    {0x300A, 0x300A, GX_BIDI_CHARACTER_TYPE_ON},
    {0x300B, 0x300B, GX_BIDI_CHARACTER_TYPE_ON},
    {0x300C, 0x300C, GX_BIDI_CHARACTER_TYPE_ON},
    {0x300D, 0x300D, GX_BIDI_CHARACTER_TYPE_ON},
    {0x300E, 0x300E, GX_BIDI_CHARACTER_TYPE_ON},
    {0x300F, 0x300F, GX_BIDI_CHARACTER_TYPE_ON},
    {0x3010, 0x3010, GX_BIDI_CHARACTER_TYPE_ON},
    {0x3011, 0x3011, GX_BIDI_CHARACTER_TYPE_ON},
    {0x3012, 0x3013, GX_BIDI_CHARACTER_TYPE_ON},
    {0x3014, 0x3014, GX_BIDI_CHARACTER_TYPE_ON},
    {0x3015, 0x3015, GX_BIDI_CHARACTER_TYPE_ON},
    {0x3016, 0x3016, GX_BIDI_CHARACTER_TYPE_ON},
    {0x3017, 0x3017, GX_BIDI_CHARACTER_TYPE_ON},
    {0x3018, 0x3018, GX_BIDI_CHARACTER_TYPE_ON},
    {0x3019, 0x3019, GX_BIDI_CHARACTER_TYPE_ON},
    {0x301A, 0x301A, GX_BIDI_CHARACTER_TYPE_ON},
    {0x301B, 0x301B, GX_BIDI_CHARACTER_TYPE_ON},
    {0x301C, 0x301C, GX_BIDI_CHARACTER_TYPE_ON},
    {0x301D, 0x301D, GX_BIDI_CHARACTER_TYPE_ON},
    {0x301E, 0x301F, GX_BIDI_CHARACTER_TYPE_ON},
    {0x3020, 0x3020, GX_BIDI_CHARACTER_TYPE_ON},
    {0x3030, 0x3030, GX_BIDI_CHARACTER_TYPE_ON},
    {0x3036, 0x3037, GX_BIDI_CHARACTER_TYPE_ON},
    {0x303D, 0x303D, GX_BIDI_CHARACTER_TYPE_ON},
    {0x303E, 0x303F, GX_BIDI_CHARACTER_TYPE_ON},
    {0x309B, 0x309C, GX_BIDI_CHARACTER_TYPE_ON},
    {0x30A0, 0x30A0, GX_BIDI_CHARACTER_TYPE_ON},
    {0x30FB, 0x30FB, GX_BIDI_CHARACTER_TYPE_ON},
    {0x31C0, 0x31E3, GX_BIDI_CHARACTER_TYPE_ON},
    {0x321D, 0x321E, GX_BIDI_CHARACTER_TYPE_ON},
    {0x3250, 0x3250, GX_BIDI_CHARACTER_TYPE_ON},
    {0x3251, 0x325F, GX_BIDI_CHARACTER_TYPE_ON},
    {0x327C, 0x327E, GX_BIDI_CHARACTER_TYPE_ON},
    {0x32B1, 0x32BF, GX_BIDI_CHARACTER_TYPE_ON},
    {0x32CC, 0x32CF, GX_BIDI_CHARACTER_TYPE_ON},
    {0x3377, 0x337A, GX_BIDI_CHARACTER_TYPE_ON},
    {0x33DE, 0x33DF, GX_BIDI_CHARACTER_TYPE_ON},
    {0x33FF, 0x33FF, GX_BIDI_CHARACTER_TYPE_ON},
    {0x4DC0, 0x4DFF, GX_BIDI_CHARACTER_TYPE_ON},
    {0xA490, 0xA4C6, GX_BIDI_CHARACTER_TYPE_ON},
    {0xA60D, 0xA60F, GX_BIDI_CHARACTER_TYPE_ON},
    {0xA673, 0xA673, GX_BIDI_CHARACTER_TYPE_ON},
    {0xA67E, 0xA67E, GX_BIDI_CHARACTER_TYPE_ON},
    {0xA67F, 0xA67F, GX_BIDI_CHARACTER_TYPE_ON},
    {0xA700, 0xA716, GX_BIDI_CHARACTER_TYPE_ON},
    {0xA717, 0xA71F, GX_BIDI_CHARACTER_TYPE_ON},
    {0xA720, 0xA721, GX_BIDI_CHARACTER_TYPE_ON},
    {0xA788, 0xA788, GX_BIDI_CHARACTER_TYPE_ON},
    {0xA828, 0xA82B, GX_BIDI_CHARACTER_TYPE_ON},
    {0xA874, 0xA877, GX_BIDI_CHARACTER_TYPE_ON},
    {0xFD3E, 0xFD3E, GX_BIDI_CHARACTER_TYPE_ON},
    {0xFD3F, 0xFD3F, GX_BIDI_CHARACTER_TYPE_ON},
    {0xFDFD, 0xFDFD, GX_BIDI_CHARACTER_TYPE_ON},
    {0xFE10, 0xFE16, GX_BIDI_CHARACTER_TYPE_ON},
    {0xFE17, 0xFE17, GX_BIDI_CHARACTER_TYPE_ON},
    {0xFE18, 0xFE18, GX_BIDI_CHARACTER_TYPE_ON},
    {0xFE19, 0xFE19, GX_BIDI_CHARACTER_TYPE_ON},
    {0xFE30, 0xFE30, GX_BIDI_CHARACTER_TYPE_ON},
    {0xFE31, 0xFE32, GX_BIDI_CHARACTER_TYPE_ON},
    {0xFE33, 0xFE34, GX_BIDI_CHARACTER_TYPE_ON},
    {0xFE35, 0xFE35, GX_BIDI_CHARACTER_TYPE_ON},
    {0xFE36, 0xFE36, GX_BIDI_CHARACTER_TYPE_ON},
    {0xFE37, 0xFE37, GX_BIDI_CHARACTER_TYPE_ON},
    {0xFE38, 0xFE38, GX_BIDI_CHARACTER_TYPE_ON},
    {0xFE39, 0xFE39, GX_BIDI_CHARACTER_TYPE_ON},
    {0xFE3A, 0xFE3A, GX_BIDI_CHARACTER_TYPE_ON},
    {0xFE3B, 0xFE3B, GX_BIDI_CHARACTER_TYPE_ON},
    {0xFE3C, 0xFE3C, GX_BIDI_CHARACTER_TYPE_ON},
    {0xFE3D, 0xFE3D, GX_BIDI_CHARACTER_TYPE_ON},
    {0xFE3E, 0xFE3E, GX_BIDI_CHARACTER_TYPE_ON},
    {0xFE3F, 0xFE3F, GX_BIDI_CHARACTER_TYPE_ON},
    {0xFE40, 0xFE40, GX_BIDI_CHARACTER_TYPE_ON},
    {0xFE41, 0xFE41, GX_BIDI_CHARACTER_TYPE_ON},
    {0xFE42, 0xFE42, GX_BIDI_CHARACTER_TYPE_ON},
    {0xFE43, 0xFE43, GX_BIDI_CHARACTER_TYPE_ON},
    {0xFE44, 0xFE44, GX_BIDI_CHARACTER_TYPE_ON},
    {0xFE45, 0xFE46, GX_BIDI_CHARACTER_TYPE_ON},
    {0xFE47, 0xFE47, GX_BIDI_CHARACTER_TYPE_ON},
    {0xFE48, 0xFE48, GX_BIDI_CHARACTER_TYPE_ON},
    {0xFE49, 0xFE4C, GX_BIDI_CHARACTER_TYPE_ON},
    {0xFE4D, 0xFE4F, GX_BIDI_CHARACTER_TYPE_ON},
    {0xFE51, 0xFE51, GX_BIDI_CHARACTER_TYPE_ON},
    {0xFE54, 0xFE54, GX_BIDI_CHARACTER_TYPE_ON},
    {0xFE56, 0xFE57, GX_BIDI_CHARACTER_TYPE_ON},
    {0xFE58, 0xFE58, GX_BIDI_CHARACTER_TYPE_ON},
    {0xFE59, 0xFE59, GX_BIDI_CHARACTER_TYPE_ON},
    {0xFE5A, 0xFE5A, GX_BIDI_CHARACTER_TYPE_ON},
    {0xFE5B, 0xFE5B, GX_BIDI_CHARACTER_TYPE_ON},
    {0xFE5C, 0xFE5C, GX_BIDI_CHARACTER_TYPE_ON},
    {0xFE5D, 0xFE5D, GX_BIDI_CHARACTER_TYPE_ON},
    {0xFE5E, 0xFE5E, GX_BIDI_CHARACTER_TYPE_ON},
    {0xFE60, 0xFE61, GX_BIDI_CHARACTER_TYPE_ON},
    {0xFE64, 0xFE66, GX_BIDI_CHARACTER_TYPE_ON},
    {0xFE68, 0xFE68, GX_BIDI_CHARACTER_TYPE_ON},
    {0xFE6B, 0xFE6B, GX_BIDI_CHARACTER_TYPE_ON},
    {0xFF01, 0xFF02, GX_BIDI_CHARACTER_TYPE_ON},
    {0xFF06, 0xFF07, GX_BIDI_CHARACTER_TYPE_ON},
    {0xFF08, 0xFF08, GX_BIDI_CHARACTER_TYPE_ON},
    {0xFF09, 0xFF09, GX_BIDI_CHARACTER_TYPE_ON},
    {0xFF0A, 0xFF0A, GX_BIDI_CHARACTER_TYPE_ON},
    {0xFF1B, 0xFF1B, GX_BIDI_CHARACTER_TYPE_ON},
    {0xFF1C, 0xFF1E, GX_BIDI_CHARACTER_TYPE_ON},
    {0xFF1F, 0xFF20, GX_BIDI_CHARACTER_TYPE_ON},
    {0xFF3B, 0xFF3B, GX_BIDI_CHARACTER_TYPE_ON},
    {0xFF3C, 0xFF3C, GX_BIDI_CHARACTER_TYPE_ON},
    {0xFF3D, 0xFF3D, GX_BIDI_CHARACTER_TYPE_ON},
    {0xFF3E, 0xFF3E, GX_BIDI_CHARACTER_TYPE_ON},
    {0xFF3F, 0xFF3F, GX_BIDI_CHARACTER_TYPE_ON},
    {0xFF40, 0xFF40, GX_BIDI_CHARACTER_TYPE_ON},
    {0xFF5B, 0xFF5B, GX_BIDI_CHARACTER_TYPE_ON},
    {0xFF5C, 0xFF5C, GX_BIDI_CHARACTER_TYPE_ON},
    {0xFF5D, 0xFF5D, GX_BIDI_CHARACTER_TYPE_ON},
    {0xFF5E, 0xFF5E, GX_BIDI_CHARACTER_TYPE_ON},
    {0xFF5F, 0xFF5F, GX_BIDI_CHARACTER_TYPE_ON},
    {0xFF60, 0xFF60, GX_BIDI_CHARACTER_TYPE_ON},
    {0xFF61, 0xFF61, GX_BIDI_CHARACTER_TYPE_ON},
    {0xFF62, 0xFF62, GX_BIDI_CHARACTER_TYPE_ON},
    {0xFF63, 0xFF63, GX_BIDI_CHARACTER_TYPE_ON},
    {0xFF64, 0xFF65, GX_BIDI_CHARACTER_TYPE_ON},
    {0xFFE2, 0xFFE2, GX_BIDI_CHARACTER_TYPE_ON},
    {0xFFE3, 0xFFE3, GX_BIDI_CHARACTER_TYPE_ON},
    {0xFFE4, 0xFFE4, GX_BIDI_CHARACTER_TYPE_ON},
    {0xFFE8, 0xFFE8, GX_BIDI_CHARACTER_TYPE_ON},
    {0xFFE9, 0xFFEC, GX_BIDI_CHARACTER_TYPE_ON},
    {0xFFED, 0xFFEE, GX_BIDI_CHARACTER_TYPE_ON},
    {0xFFF9, 0xFFFB, GX_BIDI_CHARACTER_TYPE_ON},
    {0xFFFC, 0xFFFD, GX_BIDI_CHARACTER_TYPE_ON},
    {0x10101, 0x10101, GX_BIDI_CHARACTER_TYPE_ON},
    {0x10140, 0x10174, GX_BIDI_CHARACTER_TYPE_ON},
    {0x10175, 0x10178, GX_BIDI_CHARACTER_TYPE_ON},
    {0x10179, 0x10189, GX_BIDI_CHARACTER_TYPE_ON},
    {0x1018A, 0x1018A, GX_BIDI_CHARACTER_TYPE_ON},
    {0x10190, 0x1019B, GX_BIDI_CHARACTER_TYPE_ON},
    {0x1091F, 0x1091F, GX_BIDI_CHARACTER_TYPE_ON},
    {0x1D200, 0x1D241, GX_BIDI_CHARACTER_TYPE_ON},
    {0x1D245, 0x1D245, GX_BIDI_CHARACTER_TYPE_ON},
    {0x1D300, 0x1D356, GX_BIDI_CHARACTER_TYPE_ON},
    {0x1F000, 0x1F02B, GX_BIDI_CHARACTER_TYPE_ON},
    {0x1F030, 0x1F093, GX_BIDI_CHARACTER_TYPE_ON},
    {0x0000, 0x0008, GX_BIDI_CHARACTER_TYPE_BN},
    {0x000E, 0x001B, GX_BIDI_CHARACTER_TYPE_BN},
    {0x007F, 0x0084, GX_BIDI_CHARACTER_TYPE_BN},
    {0x0086, 0x009F, GX_BIDI_CHARACTER_TYPE_BN},
    {0x00AD, 0x00AD, GX_BIDI_CHARACTER_TYPE_BN},
    {0x070F, 0x070F, GX_BIDI_CHARACTER_TYPE_BN},
    {0x200B, 0x200D, GX_BIDI_CHARACTER_TYPE_BN},
    {0x2060, 0x2064, GX_BIDI_CHARACTER_TYPE_BN},
    {0x2065, 0x2069, GX_BIDI_CHARACTER_TYPE_BN},
    {0x206A, 0x206F, GX_BIDI_CHARACTER_TYPE_BN},
    {0xFDD0, 0xFDEF, GX_BIDI_CHARACTER_TYPE_BN},
    {0xFEFF, 0xFEFF, GX_BIDI_CHARACTER_TYPE_BN},
    {0xFFF0, 0xFFF8, GX_BIDI_CHARACTER_TYPE_BN},
    {0xFFFE, 0xFFFF, GX_BIDI_CHARACTER_TYPE_BN},
    {0x1D173, 0x1D17A, GX_BIDI_CHARACTER_TYPE_BN},
    {0x1FFFE, 0x1FFFF, GX_BIDI_CHARACTER_TYPE_BN},
    {0x2FFFE, 0x2FFFF, GX_BIDI_CHARACTER_TYPE_BN},
    {0x3FFFE, 0x3FFFF, GX_BIDI_CHARACTER_TYPE_BN},
    {0x4FFFE, 0x4FFFF, GX_BIDI_CHARACTER_TYPE_BN},
    {0x5FFFE, 0x5FFFF, GX_BIDI_CHARACTER_TYPE_BN},
    {0x6FFFE, 0x6FFFF, GX_BIDI_CHARACTER_TYPE_BN},
    {0x7FFFE, 0x7FFFF, GX_BIDI_CHARACTER_TYPE_BN},
    {0x8FFFE, 0x8FFFF, GX_BIDI_CHARACTER_TYPE_BN},
    {0x9FFFE, 0x9FFFF, GX_BIDI_CHARACTER_TYPE_BN},
    {0xAFFFE, 0xAFFFF, GX_BIDI_CHARACTER_TYPE_BN},
    {0xBFFFE, 0xBFFFF, GX_BIDI_CHARACTER_TYPE_BN},
    {0xCFFFE, 0xCFFFF, GX_BIDI_CHARACTER_TYPE_BN},
    {0xDFFFE, 0xE0000, GX_BIDI_CHARACTER_TYPE_BN},
    {0xE0001, 0xE0001, GX_BIDI_CHARACTER_TYPE_BN},
    {0xE0002, 0xE001F, GX_BIDI_CHARACTER_TYPE_BN},
    {0xE0020, 0xE007F, GX_BIDI_CHARACTER_TYPE_BN},
    {0xE0080, 0xE00FF, GX_BIDI_CHARACTER_TYPE_BN},
    {0xE01F0, 0xE0FFF, GX_BIDI_CHARACTER_TYPE_BN},
    {0xEFFFE, 0xEFFFF, GX_BIDI_CHARACTER_TYPE_BN},
    {0xFFFFE, 0xFFFFF, GX_BIDI_CHARACTER_TYPE_BN},
    {0x10FFFE, 0x10FFFF, GX_BIDI_CHARACTER_TYPE_BN},
    {0x0300, 0x036F, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x0483, 0x0487, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x0488, 0x0489, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x0591, 0x05BD, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x05BF, 0x05BF, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x05C1, 0x05C2, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x05C4, 0x05C5, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x05C7, 0x05C7, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x0610, 0x061A, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x064B, 0x065E, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x0670, 0x0670, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x06D6, 0x06DC, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x06DE, 0x06DE, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x06DF, 0x06E4, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x06E7, 0x06E8, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x06EA, 0x06ED, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x0711, 0x0711, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x0730, 0x074A, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x07A6, 0x07B0, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x07EB, 0x07F3, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x0901, 0x0902, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x093C, 0x093C, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x0941, 0x0948, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x094D, 0x094D, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x0951, 0x0954, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x0962, 0x0963, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x0981, 0x0981, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x09BC, 0x09BC, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x09C1, 0x09C4, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x09CD, 0x09CD, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x09E2, 0x09E3, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x0A01, 0x0A02, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x0A3C, 0x0A3C, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x0A41, 0x0A42, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x0A47, 0x0A48, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x0A4B, 0x0A4D, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x0A51, 0x0A51, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x0A70, 0x0A71, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x0A75, 0x0A75, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x0A81, 0x0A82, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x0ABC, 0x0ABC, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x0AC1, 0x0AC5, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x0AC7, 0x0AC8, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x0ACD, 0x0ACD, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x0AE2, 0x0AE3, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x0B01, 0x0B01, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x0B3C, 0x0B3C, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x0B3F, 0x0B3F, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x0B41, 0x0B44, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x0B4D, 0x0B4D, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x0B56, 0x0B56, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x0B62, 0x0B63, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x0B82, 0x0B82, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x0BC0, 0x0BC0, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x0BCD, 0x0BCD, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x0C3E, 0x0C40, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x0C46, 0x0C48, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x0C4A, 0x0C4D, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x0C55, 0x0C56, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x0C62, 0x0C63, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x0CBC, 0x0CBC, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x0CCC, 0x0CCD, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x0CE2, 0x0CE3, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x0D41, 0x0D44, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x0D4D, 0x0D4D, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x0D62, 0x0D63, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x0DCA, 0x0DCA, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x0DD2, 0x0DD4, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x0DD6, 0x0DD6, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x0E31, 0x0E31, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x0E34, 0x0E3A, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x0E47, 0x0E4E, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x0EB1, 0x0EB1, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x0EB4, 0x0EB9, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x0EBB, 0x0EBC, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x0EC8, 0x0ECD, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x0F18, 0x0F19, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x0F35, 0x0F35, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x0F37, 0x0F37, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x0F39, 0x0F39, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x0F71, 0x0F7E, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x0F80, 0x0F84, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x0F86, 0x0F87, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x0F90, 0x0F97, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x0F99, 0x0FBC, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x0FC6, 0x0FC6, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x102D, 0x1030, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x1032, 0x1037, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x1039, 0x103A, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x103D, 0x103E, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x1058, 0x1059, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x105E, 0x1060, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x1071, 0x1074, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x1082, 0x1082, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x1085, 0x1086, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x108D, 0x108D, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x135F, 0x135F, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x1712, 0x1714, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x1732, 0x1734, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x1752, 0x1753, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x1772, 0x1773, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x17B7, 0x17BD, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x17C6, 0x17C6, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x17C9, 0x17D3, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x17DD, 0x17DD, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x180B, 0x180D, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x18A9, 0x18A9, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x1920, 0x1922, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x1927, 0x1928, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x1932, 0x1932, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x1939, 0x193B, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x1A17, 0x1A18, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x1B00, 0x1B03, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x1B34, 0x1B34, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x1B36, 0x1B3A, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x1B3C, 0x1B3C, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x1B42, 0x1B42, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x1B6B, 0x1B73, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x1B80, 0x1B81, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x1BA2, 0x1BA5, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x1BA8, 0x1BA9, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x1C2C, 0x1C33, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x1C36, 0x1C37, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x1DC0, 0x1DE6, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x1DFE, 0x1DFF, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x20D0, 0x20DC, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x20DD, 0x20E0, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x20E1, 0x20E1, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x20E2, 0x20E4, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x20E5, 0x20F0, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x2DE0, 0x2DFF, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x302A, 0x302F, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x3099, 0x309A, GX_BIDI_CHARACTER_TYPE_NSM},
    {0xA66F, 0xA66F, GX_BIDI_CHARACTER_TYPE_NSM},
    {0xA670, 0xA672, GX_BIDI_CHARACTER_TYPE_NSM},
    {0xA67C, 0xA67D, GX_BIDI_CHARACTER_TYPE_NSM},
    {0xA802, 0xA802, GX_BIDI_CHARACTER_TYPE_NSM},
    {0xA806, 0xA806, GX_BIDI_CHARACTER_TYPE_NSM},
    {0xA80B, 0xA80B, GX_BIDI_CHARACTER_TYPE_NSM},
    {0xA825, 0xA826, GX_BIDI_CHARACTER_TYPE_NSM},
    {0xA8C4, 0xA8C4, GX_BIDI_CHARACTER_TYPE_NSM},
    {0xA926, 0xA92D, GX_BIDI_CHARACTER_TYPE_NSM},
    {0xA947, 0xA951, GX_BIDI_CHARACTER_TYPE_NSM},
    {0xAA29, 0xAA2E, GX_BIDI_CHARACTER_TYPE_NSM},
    {0xAA31, 0xAA32, GX_BIDI_CHARACTER_TYPE_NSM},
    {0xAA35, 0xAA36, GX_BIDI_CHARACTER_TYPE_NSM},
    {0xAA43, 0xAA43, GX_BIDI_CHARACTER_TYPE_NSM},
    {0xAA4C, 0xAA4C, GX_BIDI_CHARACTER_TYPE_NSM},
    {0xFB1E, 0xFB1E, GX_BIDI_CHARACTER_TYPE_NSM},
    {0xFE00, 0xFE0F, GX_BIDI_CHARACTER_TYPE_NSM},
    {0xFE20, 0xFE26, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x101FD, 0x101FD, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x10A01, 0x10A03, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x10A05, 0x10A06, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x10A0C, 0x10A0F, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x10A38, 0x10A3A, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x10A3F, 0x10A3F, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x1D167, 0x1D169, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x1D17B, 0x1D182, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x1D185, 0x1D18B, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x1D1AA, 0x1D1AD, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x1D242, 0x1D244, GX_BIDI_CHARACTER_TYPE_NSM},
    {0xE0100, 0xE01EF, GX_BIDI_CHARACTER_TYPE_NSM},
    {0x0604, 0x0605, GX_BIDI_CHARACTER_TYPE_AL},
    {0x0608, 0x0608, GX_BIDI_CHARACTER_TYPE_AL},
    {0x060B, 0x060B, GX_BIDI_CHARACTER_TYPE_AL},
    {0x060D, 0x060D, GX_BIDI_CHARACTER_TYPE_AL},
    {0x061B, 0x061B, GX_BIDI_CHARACTER_TYPE_AL},
    {0x061C, 0x061D, GX_BIDI_CHARACTER_TYPE_AL},
    {0x061E, 0x061F, GX_BIDI_CHARACTER_TYPE_AL},
    {0x0620, 0x0620, GX_BIDI_CHARACTER_TYPE_AL},
    {0x0621, 0x063F, GX_BIDI_CHARACTER_TYPE_AL},
    {0x0640, 0x0640, GX_BIDI_CHARACTER_TYPE_AL},
    {0x0641, 0x064A, GX_BIDI_CHARACTER_TYPE_AL},
    {0x065F, 0x065F, GX_BIDI_CHARACTER_TYPE_AL},
    {0x066D, 0x066D, GX_BIDI_CHARACTER_TYPE_AL},
    {0x066E, 0x066F, GX_BIDI_CHARACTER_TYPE_AL},
    {0x0671, 0x06D3, GX_BIDI_CHARACTER_TYPE_AL},
    {0x06D4, 0x06D4, GX_BIDI_CHARACTER_TYPE_AL},
    {0x06D5, 0x06D5, GX_BIDI_CHARACTER_TYPE_AL},
    {0x06E5, 0x06E6, GX_BIDI_CHARACTER_TYPE_AL},
    {0x06EE, 0x06EF, GX_BIDI_CHARACTER_TYPE_AL},
    {0x06FA, 0x06FC, GX_BIDI_CHARACTER_TYPE_AL},
    {0x06FD, 0x06FE, GX_BIDI_CHARACTER_TYPE_AL},
    {0x06FF, 0x06FF, GX_BIDI_CHARACTER_TYPE_AL},
    {0x0700, 0x070D, GX_BIDI_CHARACTER_TYPE_AL},
    {0x070E, 0x070E, GX_BIDI_CHARACTER_TYPE_AL},
    {0x0710, 0x0710, GX_BIDI_CHARACTER_TYPE_AL},
    {0x0712, 0x072F, GX_BIDI_CHARACTER_TYPE_AL},
    {0x074B, 0x074C, GX_BIDI_CHARACTER_TYPE_AL},
    {0x074D, 0x07A5, GX_BIDI_CHARACTER_TYPE_AL},
    {0x07B1, 0x07B1, GX_BIDI_CHARACTER_TYPE_AL},
    {0x07B2, 0x07BF, GX_BIDI_CHARACTER_TYPE_AL},
    {0xFB50, 0xFBB1, GX_BIDI_CHARACTER_TYPE_AL},
    {0xFBB2, 0xFBD2, GX_BIDI_CHARACTER_TYPE_AL},
    {0xFBD3, 0xFD3D, GX_BIDI_CHARACTER_TYPE_AL},
    {0xFD40, 0xFD4F, GX_BIDI_CHARACTER_TYPE_AL},
    {0xFD50, 0xFD8F, GX_BIDI_CHARACTER_TYPE_AL},
    {0xFD90, 0xFD91, GX_BIDI_CHARACTER_TYPE_AL},
    {0xFD92, 0xFDC7, GX_BIDI_CHARACTER_TYPE_AL},
    {0xFDC8, 0xFDCF, GX_BIDI_CHARACTER_TYPE_AL},
    {0xFDF0, 0xFDFB, GX_BIDI_CHARACTER_TYPE_AL},
    {0xFDFC, 0xFDFC, GX_BIDI_CHARACTER_TYPE_AL},
    {0xFDFE, 0xFDFF, GX_BIDI_CHARACTER_TYPE_AL},
    {0xFE70, 0xFE74, GX_BIDI_CHARACTER_TYPE_AL},
    {0xFE75, 0xFE75, GX_BIDI_CHARACTER_TYPE_AL},
    {0xFE76, 0xFEFC, GX_BIDI_CHARACTER_TYPE_AL},
    {0xFEFD, 0xFEFE, GX_BIDI_CHARACTER_TYPE_AL},
    {0x0600, 0x06FF, GX_BIDI_CHARACTER_TYPE_AL},        /* Arabic */
    {0x0700, 0x074F, GX_BIDI_CHARACTER_TYPE_AL},        /* Syriac */
    {0x0750, 0x077F, GX_BIDI_CHARACTER_TYPE_AL},        /* Arabic_Supplement */
    {0x0780, 0x07BF, GX_BIDI_CHARACTER_TYPE_AL},        /* Thaana */
    {0xFB50, 0xFDFF, GX_BIDI_CHARACTER_TYPE_AL},        /* Arabic_Presentation_Formas_A */
    {0xFE70, 0xFEFF, GX_BIDI_CHARACTER_TYPE_AL},        /* Arabic_Presentation_formas_B */
    {0x0590, 0x05FF, GX_BIDI_CHARACTER_TYPE_R},         /* Hebrew */
    {0x07C0, 0x07FF, GX_BIDI_CHARACTER_TYPE_R},         /* NKo*/
    {0x00010800, 0x0001083F, GX_BIDI_CHARACTER_TYPE_R}, /* Cypriot_Syllabary */
    {0x00010900, 0x0001091F, GX_BIDI_CHARACTER_TYPE_R}, /* Phoenician */
    {0x00010920, 0x0001093F, GX_BIDI_CHARACTER_TYPE_R}, /* Lydian */
    {0x00010A00, 0x00010A5F, GX_BIDI_CHARACTER_TYPE_R}, /* Kharoshthi */
    {0x0800, 0x08FF, GX_BIDI_CHARACTER_TYPE_R},
    {0xFB1D, 0xFB4F, GX_BIDI_CHARACTER_TYPE_R},
    {0x00010840, 0x00010FFF, GX_BIDI_CHARACTER_TYPE_R},
    {0, 0, 0}
};

/**************************************************************************/
/*                                                                        */
/*  FUNCTION                                               RELEASE        */
/*                                                                        */
/*    _gx_utility_bidi_character_type_get                 PORTABLE C      */
/*                                                           6.1          */
/*  AUTHOR                                                                */
/*                                                                        */
/*    Kenneth Maxwell, Microsoft Corporation                              */
/*                                                                        */
/*  DESCRIPTION                                                           */
/*                                                                        */
/*    This function gets the bidi type of a unicode.                      */
/*                                                                        */
/*  INPUT                                                                 */
/*                                                                        */
/*    code                                  Code point whose bidi type is */
/*                                            retrieved                   */
/*    type                                  Retrieved bidi type.          */
/*                                                                        */
/*  OUTPUT                                                                */
/*                                                                        */
/*    status                                Completion status             */
/*                                                                        */
/*  CALLS                                                                 */
/*                                                                        */
/*    None                                                                */
/*                                                                        */
/*  CALLED BY                                                             */
/*                                                                        */
/*    Application Code                                                    */
/*                                                                        */
/*  RELEASE HISTORY                                                       */
/*                                                                        */
/*    DATE              NAME                      DESCRIPTION             */
/*                                                                        */
/*  05-19-2020     Kenneth Maxwell          Initial Version 6.0           */
/*  09-30-2020     Kenneth Maxwell          Modified comment(s),          */
/*                                            resulting in version 6.1    */
/*                                                                        */
/**************************************************************************/
UINT _gx_utility_bidi_character_type_get(ULONG code, GX_UBYTE *type)
{
GX_UBYTE                         get_type = GX_BIDI_CHARACTER_TYPE_L;
GX_CONST GX_BIDI_CHARACTER_INFO *entry = _gx_bidi_character_types;

    switch (code)
    {
    case GX_BIDI_DIRECTION_FORMAT_LRE:
        get_type = GX_BIDI_CHARACTER_TYPE_LRE;
        break;
    case GX_BIDI_DIRECTION_FORMAT_RLE:
        get_type = GX_BIDI_CHARACTER_TYPE_RLE;
        break;
    case GX_BIDI_DIRECTION_FORMAT_LRO:
        get_type = GX_BIDI_CHARACTER_TYPE_LRO;
        break;
    case GX_BIDI_DIRECTION_FORMAT_RLO:
        get_type = GX_BIDI_CHARACTER_TYPE_RLO;
        break;
    case GX_BIDI_DIRECTION_FORMAT_PDF:
        get_type = GX_BIDI_CHARACTER_TYPE_PDF;
        break;
    case GX_BIDI_DIRECTION_FORMAT_LRI:
        get_type = GX_BIDI_CHARACTER_TYPE_LRI;
        break;
    case GX_BIDI_DIRECTION_FORMAT_RLI:
        get_type = GX_BIDI_CHARACTER_TYPE_RLI;
        break;
    case GX_BIDI_DIRECTION_FORMAT_FSI:
        get_type = GX_BIDI_CHARACTER_TYPE_FSI;
        break;
    case GX_BIDI_DIRECTION_FORMAT_PDI:
        get_type = GX_BIDI_CHARACTER_TYPE_PDI;
        break;

    default:
        while (entry -> gx_bidi_character_info_type)
        {
            if ((code >= entry -> gx_bidi_character_info_range_start) &&
                (code <= entry -> gx_bidi_character_info_range_end))
            {
                get_type = entry -> gx_bidi_character_info_type;
                break;
            }

            entry++;
        }
        break;
    }

    if (type)
    {
        *type = get_type;
    }

    return GX_SUCCESS;
}
#endif
