# Add set(CONFIG_USE_middleware_azure_rtos_ux_template true) in config.cmake to use this component

include_guard(GLOBAL)
message("${CMAKE_CURRENT_LIST_FILE} component is included.")

target_include_directories(${MCUX_SDK_PROJECT_NAME} PUBLIC
  ${CMAKE_CURRENT_LIST_DIR}/usbx/common/core/inc
  ${CMAKE_CURRENT_LIST_DIR}/usbx/common/usbx_device_classes/inc
  ${CMAKE_CURRENT_LIST_DIR}/usbx/common/usbx_host_classes/inc
  ${CMAKE_CURRENT_LIST_DIR}/usbx/common/usbx_network/inc
  ${CMAKE_CURRENT_LIST_DIR}/usbx/common/usbx_pictbridge/inc
)

if((CONFIG_TOOLCHAIN STREQUAL mcux OR CONFIG_TOOLCHAIN STREQUAL mdk OR CONFIG_TOOLCHAIN STREQUAL iar) AND CONFIG_CORE STREQUAL cm33)
target_include_directories(${MCUX_SDK_PROJECT_NAME} PUBLIC
  ${CMAKE_CURRENT_LIST_DIR}/usbx/ports/cortex_m33/inc
)
endif()

if(CONFIG_USE_COMPONENT_CONFIGURATION)
  message("===>Import configuration from ${CMAKE_CURRENT_LIST_FILE}")

  target_compile_definitions(${MCUX_SDK_PROJECT_NAME} PUBLIC
    -DUX_OTG_SUPPORT
    -DUX_INCLUDE_USER_DEFINE_FILE
  )

  if(CONFIG_TOOLCHAIN STREQUAL armgcc)
    target_compile_options(${MCUX_SDK_PROJECT_NAME} PUBLIC
    )
  endif()

endif()

