/*
 * Copyright 2021 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

/***********************************************************************************************************************
 * This file was generated by the MCUXpresso Config Tools. Any manual edits made to this file
 * will be overwritten if the respective MCUXpresso Config Tools is used to update this file.
 **********************************************************************************************************************/

/* clang-format off */
/* TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
!!GlobalInfo
product: Peripherals v12.0
processor: LPC55S36
package_id: LPC55S36JBD100
mcu_data: ksdk2_0
processor_version: 0.13.3
board: LPCXpresso55S36
functionalGroups:
- name: BOARD_InitPeripherals
  UUID: 78418e57-4e71-47c9-8faf-23f28b5459a0
  called_from_default_init: true
  selectedCore: cm33_core0
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS **********/

/* TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
component:
- type: 'system'
- type_id: 'system_54b53072540eeeb8f8e9343e71f28176'
- global_system_definitions:
  - user_definitions: ''
  - user_includes: ''
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS **********/

/* TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
component:
- type: 'uart_cmsis_common'
- type_id: 'uart_cmsis_common_9cb8e302497aa696fdbb5a4fd622c2a8'
- global_USART_CMSIS_common:
  - quick_selection: 'default'
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS **********/

/* TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
component:
- type: 'gpio_adapter_common'
- type_id: 'gpio_adapter_common_57579b9ac814fe26bf95df0a384c36b6'
- global_gpio_adapter_common:
  - quick_selection: 'default'
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS **********/
/* clang-format on */

/***********************************************************************************************************************
 * Included files
 **********************************************************************************************************************/
#include "peripherals.h"

/***********************************************************************************************************************
 * BOARD_InitPeripherals functional group
 **********************************************************************************************************************/
/***********************************************************************************************************************
 * NVIC initialization code
 **********************************************************************************************************************/
/* clang-format off */
/* TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
instance:
- name: 'NVIC'
- type: 'nvic'
- mode: 'general'
- custom_name_enabled: 'false'
- type_id: 'nvic_57b5eef3774cc60acaede6f5b8bddc67'
- functional_group: 'BOARD_InitPeripherals'
- peripheral: 'NVIC'
- config_sets:
  - nvic:
    - interrupt_table:
      - 0: []
    - interrupts: []
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS **********/
/* clang-format on */

/* Empty initialization function (commented out)
static void NVIC_init(void) {
} */

/***********************************************************************************************************************
 * FLEXCOMM0 initialization code
 **********************************************************************************************************************/
/* clang-format off */
/* TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
instance:
- name: 'FLEXCOMM0'
- type: 'flexcomm_usart'
- mode: 'polling'
- custom_name_enabled: 'false'
- type_id: 'flexcomm_usart_ed9c01c4af42506ff2efb7a71c7381a3'
- functional_group: 'BOARD_InitPeripherals'
- peripheral: 'FLEXCOMM0'
- config_sets:
  - usartConfig_t:
    - usartConfig:
      - clockSource: 'FXCOMFunctionClock'
      - clockSourceFreq: 'ClocksTool_DefaultInit'
      - baudRate_Bps: '115200'
      - syncMode: 'kUSART_SyncModeDisabled'
      - parityMode: 'kUSART_ParityDisabled'
      - stopBitCount: 'kUSART_OneStopBit'
      - bitCountPerChar: 'kUSART_8BitsPerChar'
      - loopback: 'false'
      - txWatermark: 'kUSART_TxFifo0'
      - rxWatermark: 'kUSART_RxFifo1'
      - enableMatchAddress: 'false'
      - matchAddressConfig:
        - matchAddress: '0'
        - addressMode: 'automatic'
      - enableRx: 'true'
      - enableTx: 'true'
      - enableHardwareFlowControl: 'false'
      - enableRTS: 'false'
      - clockPolarity: 'kUSART_RxSampleOnFallingEdge'
      - enableContinuousSCLK: 'false'
    - quick_selection: 'QuickSelection1'
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS **********/
/* clang-format on */
const usart_config_t FLEXCOMM0_config = {
  .baudRate_Bps = 115200UL,
  .syncMode = kUSART_SyncModeDisabled,
  .parityMode = kUSART_ParityDisabled,
  .stopBitCount = kUSART_OneStopBit,
  .bitCountPerChar = kUSART_8BitsPerChar,
  .loopback = false,
  .txWatermark = kUSART_TxFifo0,
  .rxWatermark = kUSART_RxFifo1,
  .enableRx = true,
  .enableTx = true,
  .enableHardwareFlowControl = false,
  .enableMode32k = false,
  .clockPolarity = kUSART_RxSampleOnFallingEdge,
  .enableContinuousSCLK = false
};

static void FLEXCOMM0_init(void) {
  USART_Init(FLEXCOMM0_PERIPHERAL, &FLEXCOMM0_config, FLEXCOMM0_CLOCK_SOURCE);
}

/***********************************************************************************************************************
 * PINT initialization code
 **********************************************************************************************************************/
/* clang-format off */
/* TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
instance:
- name: 'PINT'
- type: 'pint'
- mode: 'interrupt_mode'
- custom_name_enabled: 'false'
- type_id: 'pint_cf4a806bb2a6c1ffced58ae2ed7b43af'
- functional_group: 'BOARD_InitPeripherals'
- peripheral: 'PINT'
- config_sets:
  - general:
    - interrupt_array:
      - 0:
        - interrupt_id: 'INT_0'
        - interrupt_selection: 'PINT.0'
        - interrupt_type: 'kPINT_PinIntEnableFallEdge'
        - callback_function: 'BOARD_SW3_Callback'
        - enable_callback: 'true'
        - interrupt:
          - IRQn: 'PIN_INT0_IRQn'
          - enable_priority: 'true'
          - priority: '2'
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS **********/
/* clang-format on */

static void PINT_init(void) {
  /* PINT initiation  */
  PINT_Init(PINT_PERIPHERAL);
  /* Interrupt vector PIN_INT0_IRQn priority settings in the NVIC. */
  NVIC_SetPriority(PINT_PINT_0_IRQN, PINT_PINT_0_IRQ_PRIORITY);
  /* PINT PINT.0 configuration */
  PINT_PinInterruptConfig(PINT_PERIPHERAL, PINT_INT_0, kPINT_PinIntEnableFallEdge, BOARD_SW3_Callback);
  /* Enable PINT PINT.0 callback */
  PINT_EnableCallbackByIndex(PINT_PERIPHERAL, kPINT_PinInt0);
}

/***********************************************************************************************************************
 * FreeMASTER initialization code
 **********************************************************************************************************************/
/* clang-format off */
/* TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
instance:
- name: 'FreeMASTER'
- type: 'freemaster'
- mode: 'general'
- custom_name_enabled: 'false'
- type_id: 'freemaster_14894d49d87e02d0dca5f799e22554da'
- functional_group: 'BOARD_InitPeripherals'
- config_sets:
  - freemaster_config:
    - FMSTR_DISABLE: 'false'
    - initFreemaster: 'true'
    - generalConfig:
      - commInterface: 'serial'
      - interruptMode: 'polling'
      - initType: 'true'
      - serialConfig:
        - peripheralUART: 'FLEXCOMM0'
        - clockSource: 'genericUartClockSource'
        - clockSourceFreq: 'BOARD_BootClockFROHF96M'
        - baudRate_Bps: '1'
        - parityMode_usart: 'kUSART_ParityDisabled'
        - stopBitCount_usart: 'kUSART_OneStopBit'
        - bitCountPerChar: 'kUSART_7BitsPerChar'
        - enableUserInit: 'false'
        - user_init:
          - initFunctionID: 'SERIAL_communication_init'
        - enable_rx_tx_irq: 'false'
        - interrupt_rx_tx:
          - IRQn: 'FLEXCOMM0_IRQn'
          - enable_interrrupt: 'enabled'
          - enable_priority: 'false'
          - priority: '0'
          - useDefaultISR: 'false'
          - enable_custom_name: 'false'
          - handler_custom_name: ''
        - quick_selection: 'QuickSelection1'
      - canConfig:
        - peripheralCAN: 'CAN0'
        - generic_can_driver_version: '2.1.4'
        - clockSource: ''
        - clockSourceFreq: ''
        - mcanConfig:
          - baudRateA: '500000'
          - baudRateD: '1000000'
          - enableCanfdNormal: 'true'
          - enableCanfdSwitch: 'false'
        - enableUserInit: 'false'
        - user_init:
          - initFunctionID: 'CAN_communication_init'
        - enable_can0_irq: 'true'
        - mcan_interrupt_0:
          - IRQn: ''
          - enable_interrrupt: 'enabled'
          - enable_priority: 'false'
          - priority: '0'
          - useDefaultISR: 'true'
          - enable_custom_name: 'false'
          - handler_custom_name: ''
        - enable_can1_irq: 'true'
        - mcan_interrupt_1:
          - IRQn: ''
          - enable_interrrupt: 'enabled'
          - enable_priority: 'false'
          - priority: '0'
          - enable_custom_name: 'false'
          - handler_custom_name: ''
        - quick_selection: 'QuickSelection1'
      - usbConfig:
        - usbComponent: 'disabled'
        - CICIntEndpoint: ''
        - DICInEndpoint: ''
        - DICOutEndpoint: ''
        - enableUserInit: 'false'
        - user_init:
          - initFunctionID: ''
      - pdbdmConfig:
        - FMSTR_PDBDM_USER_BUFFER: 'false'
        - pdbdmBuffer: 'default'
      - FMSTR_FLEXCAN_TXMB: '0'
      - FMSTR_FLEXCAN_RXMB: '0'
      - mcanRamConfig:
        - RAMbufferType: 'default'
        - bufferAddressValue: '0'
        - bufferAddress: ''
        - bufferExternDef: ''
        - mcan_tx: '0'
        - mcan_rx: '0'
      - FMSTR_COMM_BUFFER_SIZE: 'autoSize'
      - FMSTR_COMM_RQUEUE_SIZE: '32'
      - FMSTR_USE_SCOPE: '2'
      - FMSTR_MAX_SCOPE_VARS: '8'
      - FMSTR_REC_FLOAT_TRIG: 'true'
      - recorders:
        - 0:
          - recID:
            - enableCustomID: 'false'
          - nameRec: 'Description of recorder 0'
          - recBuff:
            - customBuffer: 'false'
            - bufferAddress: ''
            - bufferExternDef: ''
            - bufferSize: '4096'
          - basePeriod_ns: '100000'
          - recInit: 'true'
      - FMSTR_USE_TSA: 'true'
      - FMSTR_USE_TSA_INROM: 'true'
      - FMSTR_USE_TSA_SAFETY: 'true'
      - FMSTR_USE_TSA_DYNAMIC: 'true'
      - tsaBufferInit: 'false'
      - tsaBuff:
        - customBuffer: 'false'
        - bufferAddress: ''
        - bufferExternDef: ''
        - bufferSize: '(5 * sizeof(FMSTR_TSA_ENTRY))'
      - pipes:
        - 0:
          - pipeID:
            - enableCustomID: 'false'
          - namePipe: 'Description of pipe 1'
          - pipePort: '1'
          - enablePipeHandler: 'false'
          - callbackFunction: 'Pipe1_Handler'
          - rxBuffer:
            - customBuffer: 'false'
            - bufferAddress: ''
            - bufferExternDef: ''
            - bufferSize: '32'
          - txBuffer:
            - customBuffer: 'false'
            - bufferAddress: ''
            - bufferExternDef: ''
            - bufferSize: '32'
          - pipeInit: 'false'
        - 1:
          - pipeID:
            - enableCustomID: 'false'
          - namePipe: 'Description of pipe 2'
          - pipePort: '2'
          - enablePipeHandler: 'false'
          - callbackFunction: 'Pipe2_Handler'
          - rxBuffer:
            - customBuffer: 'false'
            - bufferAddress: ''
            - bufferExternDef: ''
            - bufferSize: '32'
          - txBuffer:
            - customBuffer: 'false'
            - bufferAddress: ''
            - bufferExternDef: ''
            - bufferSize: '32'
          - pipeInit: 'false'
        - 2:
          - pipeID:
            - enableCustomID: 'false'
          - namePipe: 'Description of pipe 3'
          - pipePort: '3'
          - enablePipeHandler: 'false'
          - callbackFunction: 'Pipe3_Handler'
          - rxBuffer:
            - customBuffer: 'false'
            - bufferAddress: ''
            - bufferExternDef: ''
            - bufferSize: '32'
          - txBuffer:
            - customBuffer: 'false'
            - bufferAddress: ''
            - bufferExternDef: ''
            - bufferSize: '32'
          - pipeInit: 'false'
      - FMSTR_USE_READMEM: 'true'
      - FMSTR_USE_WRITEMEM: 'true'
      - FMSTR_USE_WRITEMEMMASK: 'true'
      - passR: ''
      - passRW: ''
      - passRWF: ''
      - FMSTR_USE_HASHED_PASSWORDS: 'false'
      - FMSTR_USE_APPCMD: 'true'
      - FMSTR_APPCMD_BUFF_SIZE: '32'
      - FMSTR_MAX_APPCMD_CALLS: '4'
      - FMSTR_DEBUG_LEVEL: '0'
      - FMSTR_DEBUG_PRINTF: 'debug_console'
      - FMSTR_DEBUG_TX: 'false'
      - FMSTR_CUSTOM_INCLUDES: ''
      - FMSTR_CUSTOM_OPTIONS: ''
    - freemaster_codegenerator: []
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS **********/
/* clang-format on */
/* Recorder0 configuration */
FMSTR_U8 FreeMASTER_RecBuffer0[FREEMASTER_REC_0_SIZE];
/* Pipe0 handle */
FMSTR_HPIPE FreeMASTER_Pipe_handle_1;
/* Pipe0 Rx buffer */
FMSTR_U8 FreeMASTER_RxPipe1[FREEMASTER_RX_PIPE_1_SIZE];
/* Pipe0 Tx buffer */
FMSTR_U8 FreeMASTER_TxPipe1[FREEMASTER_TX_PIPE_1_SIZE];
/* Pipe1 handle */
FMSTR_HPIPE FreeMASTER_Pipe_handle_2;
/* Pipe1 Rx buffer */
FMSTR_U8 FreeMASTER_RxPipe2[FREEMASTER_RX_PIPE_2_SIZE];
/* Pipe1 Tx buffer */
FMSTR_U8 FreeMASTER_TxPipe2[FREEMASTER_TX_PIPE_2_SIZE];
/* Pipe2 handle */
FMSTR_HPIPE FreeMASTER_Pipe_handle_3;
/* Pipe2 Rx buffer */
FMSTR_U8 FreeMASTER_RxPipe3[FREEMASTER_RX_PIPE_3_SIZE];
/* Pipe2 Tx buffer */
FMSTR_U8 FreeMASTER_TxPipe3[FREEMASTER_TX_PIPE_3_SIZE];
FMSTR_REC_BUFF FreeMASTER_Recorder_0 = {
  .name = "Description of recorder 0",
  .addr = (FMSTR_ADDR)FreeMASTER_RecBuffer0,
  .size = (FMSTR_SIZE) sizeof(FreeMASTER_RecBuffer0),
  .basePeriod_ns = 100000UL
};

static void FreeMASTER_init(void) {
  /* FreeMASTER middleware initialization */
  FMSTR_Init();
  /* FreeMASTER recorder 0 configuration initialization  */
  FMSTR_RecorderCreate(0, &FreeMASTER_Recorder_0);
}

/***********************************************************************************************************************
 * Initialization functions
 **********************************************************************************************************************/
void BOARD_InitPeripherals(void)
{
  /* Initialize components */
  FLEXCOMM0_init();
  PINT_init();
  FreeMASTER_init();
}

/***********************************************************************************************************************
 * BOARD_InitBootPeripherals function
 **********************************************************************************************************************/
void BOARD_InitBootPeripherals(void)
{
  BOARD_InitPeripherals();
}
