/*--------------------------------------------------------------------------*/
/* Copyright 2020-2021 NXP                                                  */
/*                                                                          */
/* NXP Confidential. This software is owned or controlled by NXP and may    */
/* only be used strictly in accordance with the applicable license terms.   */
/* By expressly accepting such terms or by downloading, installing,         */
/* activating and/or otherwise using the software, you are agreeing that    */
/* you have read, and that you agree to comply with and are bound by, such  */
/* license terms. If you do not agree to be bound by the applicable license */
/* terms, then you may not retain, install, activate or otherwise use the   */
/* software.                                                                */
/*--------------------------------------------------------------------------*/

/**
 * @file  mcuxClEcc_Weier_Verify_FUP.c
 * @brief FUP programs for Weierstrass curve ECDSA signature verification
 */


#include <internal/mcuxClPkc_FupMacros.h>
#include <internal/mcuxClEcc_Weier_Internal.h>
#include <internal/mcuxClEcc_Weier_Verify_FUP.h>

const mcuxClPkc_FUPEntry_t mcuxClEcc_FUP_Weier_Verify_Convert_G_PrecG_toMR[5] MCUX_FUP_ATTRIBUTE = {{0x10u,0x00u,0x34u,0x74u,0xadu,0xfbu},{0x80u,0x00u,0x26u,0x16u,0x00u,0x20u},{0x80u,0x00u,0x27u,0x16u,0x00u,0x21u},{0x80u,0x00u,0x28u,0x16u,0x00u,0x2au},{0x80u,0x00u,0x29u,0x16u,0x00u,0x2bu}};
const mcuxClPkc_FUPEntry_t mcuxClEcc_Fup_Verify_Convert_P1plusP2_toAffineNR_CalcR[10] MCUX_FUP_ATTRIBUTE = {{0x10u,0x00u,0x20u,0x77u,0x74u,0xf6u},{0x80u,0x00u,0x1bu,0x16u,0x00u,0x19u},{0x80u,0x00u,0x19u,0x16u,0x00u,0x1bu},{0x80u,0x00u,0x1bu,0x1bu,0x00u,0x1du},{0x80u,0x00u,0x1du,0x19u,0x00u,0x1fu},{0x80u,0x00u,0x20u,0x1du,0x00u,0x26u},{0x80u,0x33u,0x26u,0x00u,0x00u,0x24u},{0x80u,0x2au,0x00u,0x24u,0x00u,0x24u},{0x80u,0x00u,0x21u,0x1fu,0x00u,0x25u},{0x80u,0x2au,0x01u,0x24u,0x01u,0x26u}};
const mcuxClPkc_FUPEntry_t mcuxClEcc_Fup_Verify_Convert_pubkeyQ_toJacobianMR[6] MCUX_FUP_ATTRIBUTE = {{0x10u,0x00u,0x1fu,0x94u,0xd1u,0xbdu},{0x80u,0x00u,0x23u,0x16u,0x00u,0x1fu},{0x80u,0x00u,0x1fu,0x23u,0x00u,0x1du},{0x80u,0x00u,0x1du,0x23u,0x00u,0x1fu},{0x80u,0x00u,0x26u,0x1du,0x00u,0x24u},{0x80u,0x00u,0x27u,0x1fu,0x00u,0x25u}};
const mcuxClPkc_FUPEntry_t mcuxClEcc_Fup_Verify_InitZ_CalcU1U2[6] MCUX_FUP_ATTRIBUTE = {{0x10u,0x00u,0x6bu,0x39u,0x6cu,0xf6u},{0x00u,0x09u,0x00u,0x00u,0x00u,0x23u},{0x80u,0x00u,0x1cu,0x1bu,0x01u,0x18u},{0x80u,0x00u,0x1eu,0x1bu,0x01u,0x1au},{0x80u,0x2au,0x01u,0x1au,0x01u,0x1au},{0x80u,0x2au,0x01u,0x18u,0x01u,0x18u}};
const mcuxClPkc_FUPEntry_t mcuxClEcc_Fup_Verify_Update_G_to_Prec1[5] MCUX_FUP_ATTRIBUTE = {{0x10u,0x00u,0x6bu,0x50u,0xcau,0x35u},{0x80u,0x00u,0x23u,0x23u,0x00u,0x1du},{0x80u,0x00u,0x1du,0x23u,0x00u,0x1fu},{0x80u,0x00u,0x20u,0x1du,0x00u,0x26u},{0x80u,0x00u,0x21u,0x1fu,0x00u,0x27u}};
const mcuxClPkc_FUPEntry_t mcuxClEcc_Fup_Verify_Update_pubkeyQ_P1_z[9] MCUX_FUP_ATTRIBUTE = {{0x10u,0x00u,0x99u,0x16u,0x4du,0xffu},{0x80u,0x00u,0x22u,0x22u,0x00u,0x1du},{0x80u,0x00u,0x1du,0x22u,0x00u,0x1fu},{0x80u,0x00u,0x24u,0x1du,0x00u,0x26u},{0x80u,0x00u,0x25u,0x1fu,0x00u,0x27u},{0x80u,0x00u,0x20u,0x1du,0x00u,0x24u},{0x80u,0x00u,0x21u,0x1fu,0x00u,0x25u},{0x00u,0x1eu,0x00u,0x23u,0x03u,0x19u},{0x80u,0x00u,0x19u,0x22u,0x00u,0x23u}};



/* FUP program: calculates the scalars u1 and u2:
 *   u1 = hash * s^(-1), in range [0, n-1];
 *   u2 = r    * s^(-1), in range [0, n-1].
 */

/* FUP program: converts x- and y-coordinates of G and PrecG from NR to MR */

/* FUP program: update G: (XA,YA, 1) -> Prec1: (X1,Y1, Z) Jacobian.*/

/* FUP program: convert Q: (X1,Y1) affine NR -> (X0,Y0, Z) Jacobian. */

/* FUP program: update Q:  (X0,Y0, old Z) -> (X1,Y1, new Z) Jacobian; */
/*                     P1: (XA,YA, old Z) -> (X0,Y0, new Z) Jacobian; */
/*              update z = z * z'.                                    */

/* FUP program: convert P1 + P2 (or P2 if u1 == 0) to affine NR; */
/*              calculate r = x mod n.                           */
