/*
 * Copyright 2018-2022 NXP.
 * This software is owned or controlled by NXP and may only be used strictly in accordance with the
 * license terms that accompany it. By expressly accepting such terms or by downloading, installing,
 * activating and/or otherwise using the software, you are agreeing that you have read, and that you
 * agree to comply with and are bound by, such license terms. If you do not agree to be bound by the
 * applicable license terms, then you may not retain, install, activate or otherwise use the software.
 */

///////////////////////////////////////////////////////////////////////////////
//! \addtogroup asi_dffi
//! @{
//
// Copyright (c) 2004-2005 SigmaTel, Inc.
//
//! \file adpcm_extractmetadata.c
//! \brief Contains functionality that extracts the meta data from the file
//!                and stores it in the file_meta_data_t structure.
///////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
//  Includes
////////////////////////////////////////////////////////////////////////////////
#include "codec_interface.h"
#include "cci_metadata.h"

////////////////////////////////////////////////////////////////////////////////
//  Macros
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
//  External Definitions
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
//  External References
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
//  Equates
////////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////////
//  Prototypes
////////////////////////////////////////////////////////////////////////////////
extern RtStatus_t CodecExtractMetaDataAdpcm(file_meta_data_t *meta_data, CCI_Ctx *Ctx);

////////////////////////////////////////////////////////////////////////////////
// Variables
////////////////////////////////////////////////////////////////////////////////

/////////////////////////////////////////////////////////////////////////////////
//!  \brief         Extract the meta data.
//!
//!  \param[in]     int64_t file_handle  this key allows the file to be quickly found and opened
//!  \param[in]     file_meta_data_t *MetaData  this structure will be filled in by the function
//!
//!  \retval        SUCCESS
//!  \retval        ERROR -- various errors can be returned from this function
//!
//!  \note          This should be accessed via the generic function DffiExtractMetaData.
//!		    This function parses file up to Data chunk and gives start position.
//!
//!
/////////////////////////////////////////////////////////////////////////////////
int32_t codec_extract_metadata_wave(file_meta_data_t *meta_data, CCI_Ctx *Ctx)
{
    return ((RtStatus_t)(CodecExtractMetaDataAdpcm(meta_data, Ctx)));
}
///////////////////////////////////////////////////////////////////////////////
// End of file
///////////////////////////////////////////////////////////////////////////////
//! @}
