/**************************************************************************
MODULE:    PROCIMG.H
CONTAINS:  MicroCANopen application process image definition an access
COPYRIGHT: (c) Embedded Systems Academy (EmSA) 2002-2020
           All rights reserved. www.em-sa.com/nxp
DISCLAIM:  Read and understand our disclaimer before using this code!
           www.esacademy.com/disclaim.htm
           This software was written in accordance to the guidelines at
           www.esacademy.com/software/softwarestyleguide.pdf
LICENSE:   THIS IS THE NXP SDK VERSION OF MICROCANOPEN PLUS
           Licensed under a modified BSD License. See LICENSE.INFO
           file in the project root for full license information.
VERSION:   7.10, ESA 20-SEP-02
           $LastChangedDate: 2020-09-03 22:04:52 +0200 (Thu, 03 Sep 2020) $
           $LastChangedRevision: 5038 $
***************************************************************************/

#ifndef _PROCIMG_H
#define _PROCIMG_H

/**************************************************************************
DEFINES: Definition of the process image
Modify these for your application
**************************************************************************/

// Include files generated by CodeArchitect EDS
#include "pimg.h"

/*
 * Note: All settings below are for informational purposes only and
 *       must not be changed in projects that use the NXP SDK library
 *       version of MicroCANopen. Changes here will not affect the
 *       delivered library and may lead to applications that fail to
 *       build or perform.
 */

// Define the size of the process image
#define PROCIMG_SIZE (PIMGEND + 1)

#define PROCIMG_SIZE_MAX LIBCB_GetProcImgSize()

/**************************************************************************
DEFINES: MACROS FOR DEFAULT OBJECT DDICTIONARY ACCESS
**************************************************************************/
#if !USE_XOD_ACCESS
#define OD_SDOResponseTablePtr(offset) (&(gSDOResponseTable[offset]))
#define OD_ProcTablePtr(offset)        (&(gODProcTable[offset]))
#define OD_GenericTablePtr(offset)     (&(gODGenericTable[offset]))
#else
#define OD_SDOResponseTablePtr OD_SDOResponseTablePtr_fct
#define OD_ProcTablePtr        OD_ProcTablePtr_fct
#define OD_GenericTablePtr     OD_GenericTablePtr_fct
#endif

/**************************************************************************
DEFINES: MACROS FOR GENERIC PROCESS IMAGE ACCESS
NOTE:    Add RTOS Mutex or Semaphore lock if multiple tasks access the PI
**************************************************************************/
// Access definitions: read, write, compare (returns 0 on equal data)
#define PI_READ(level, offset, pdst, len) MEM_CPY((void *)(pdst), (const void *)&(gProcImg[(offset)]), (len))
#ifdef __SIMULATION__
#define PI_WRITE(level, offset, psrc, len)                                   \
    {                                                                        \
        MEM_CPY((void *)&(gProcImg[(offset)]), (const void *)(psrc), (len)); \
        SimDriver_UpdateProcessImage((level), (offset), (len));              \
    }
#else
#define PI_WRITE(level, offset, psrc, len) MEM_CPY((void *)&(gProcImg[(offset)]), (const void *)(psrc), (len))
#endif
#define PI_COMP(level, offset, psrc, len) MEM_CMP((const void *)&(gProcImg[(offset)]), (const void *)(psrc), (len))
// RTOS priority level definitions: access from application, PDO, SDO
#define PIACC_APP 1
#define PIACC_PDO 2
#define PIACC_SDO 3
// RTOS section definitions: for large process images, only lock a section
#define PISECT_ALL    1
#define PISECT_PDO    2
#define PISECT_NOTPDO 3
#define PISECT_CUSTOM 4

/**************************************************************************
DEFINES: Definition of macros / functions accessing the process image
Modify as required
PDO_TXCOPY, from PI to CAN msg; PDO_RXCOPY from CAN msg to PI;
PDO_TXCOMP for change of state detection
Transmit PDO, parameters: gTPDOConfig-offset and pointer to CAN data received
Receive PDO, parameters: gRPDOConfig-offset and pointer to CAN data received
**************************************************************************/
#if !USE_DYNAMIC_PDO_MAPPING
#define PDO_TXCOPY(tpdo, dat) PI_READ(PIACC_PDO, gTPDOConfig[tpdo].offset, dat, gTPDOConfig[tpdo].CANmsg.LEN)
#define PDO_RXCOPY(rpdo, dat) PI_WRITE(PIACC_PDO, gRPDOConfig[rpdo].offset, dat, gRPDOConfig[rpdo].len)
#define PDO_TXCOMP(tpdo, dat) PI_COMP(PIACC_PDO, gTPDOConfig[tpdo].offset, dat, gTPDOConfig[tpdo].CANmsg.LEN)
#else
#define PDO_TXCOPY PDO_TXCOPY_fct
#define PDO_RXCOPY PDO_RXCOPY_fct
#define PDO_TXCOMP PDO_TXCOMP_fct
#endif

/**************************************************************************
THE FOLLOWING ARE FOR BACKWARD COMPATIBILITY ONLY.
DO NOT USE FOR NEW IMPLEMENTATIONS, USE PI_READ AND PI_WRITE INSTEAD.
***************************************************************************
DEFINES: MACROS FOR PROCESS IMAGE ACCESS 8bit, 16bit and 32bit access.
NOTES:  16bit and 32bit accesses must be architecture aligned.
        Add RTOS Mutex or Semaphore lock if multiple tasks access the PI.
**************************************************************************/
/*
#define PI8ACC(offset) (gProcImg[offset])
#define PI16ACC(offset) (*((uint16_t *) &(gProcImg[offset])))
#define PI32ACC(offset) (*((uint32_t *) &(gProcImg[offset])))
*/
#endif // _PROCIMG_H
