/*
 * Boilerplate Stuff (BS) goes here
 */

#include "mc_dcvfd.h"

#include "fsl_device_registers.h"
#include "fsl_debug_console.h"
#include "board.h"
#include "pin_mux.h"
#include "clock_config.h"

#include "fsl_power.h"
#include "fsl_inputmux.h"
#include "mc_dcvfd.h"

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <float.h>

////////////////////
// Globals
////////////////////
extern unsigned int            minsp_ramp_val;
extern unsigned int            maxsp_ramp_val;
extern unsigned int            sp_ramp_val;
extern unsigned int            incr;
extern unsigned int            deadTimeVal;
extern unsigned int            pwmSourceClockInHz;
extern unsigned int            pwmSourceClockPrescaler;
extern unsigned int            PWMCLKInHz;
extern unsigned int            pwmReloadFreqInHz;
extern unsigned int            samplingFreqInHz;
extern unsigned int            pwm_reload_val;
extern unsigned int            sampling_reload_val;
extern unsigned int            zeroErrorCalcSamples;
extern unsigned int            Sirhowlongisit, Thatsarpqdythink;
extern unsigned int            save_this, save_that;
extern unsigned int            this_dividend, that_dividend;
extern float                   gain_const;
extern float                   flotsom, jetsom;
extern float                   george,jetson,harry,johnson;
extern volatile unsigned int   loop_cntr;
extern volatile float          accumulator;
extern volatile float          fnew_duty_actual;
extern volatile float          fnew_duty_limited;
extern volatile long           inew_duty_rounded;
extern volatile unsigned int   y_t;
extern volatile float          r_t;
extern volatile float          fnew_u_t_actual;
extern volatile float          fnew_u_t_limited;
extern volatile float          fnew_u_t_scaled;
extern volatile long           inew_u_t_rounded;
extern volatile unsigned int   u_t;
extern volatile float          e_t;
extern volatile float          e_tm1;
extern volatile float          e_t_minus_e_tm1;
extern volatile float          P, I, D, P_t, I_t, D_t;
extern volatile float          Kp;
extern volatile float          Kd;
extern volatile float          Ki;
extern volatile float          zero_psig_offset;
extern volatile unsigned char  adc1_flag;
extern volatile float          dt;
extern volatile float          e_t_times_dt;
extern volatile float          I_tm1;
extern volatile float          movavg;
extern volatile float          movavg_old;
extern volatile float          movavg_temp;
extern volatile float          new_in;
extern volatile float          L_movavg;
extern volatile float          envfollow;
extern volatile float          envfollow_old;
extern volatile float          filtered_y_t;
extern volatile float          pid_input_variable;
extern float                   temp1,temp2,temp3;
extern long unsigned int       ZeroPsigCnt;
extern float                   Slope;
extern float                   YInt;
extern float                   SPpsig;
extern float                   PIDInPSIG;
extern float                   PsigPerCnt;
extern float                   ErrPSIG;






///////////////////////////////////////////////////////////////////////////////
//
// The Caltrans() function
//
// Determines zero_psig_offset of the pressure transducer at ambient pressure
// by averaging a large number of ADC readings
//
///////////////////////////////////////////////////////////////////////////////

void Caltrans(void) {
   accumulator = 0.0;
   for (loop_cntr = 1; loop_cntr <= zeroErrorCalcSamples; loop_cntr++) {
      while ((ADC1->TSTAT & 1<<tcomp_flag_shift) == 0);
      ADC1->TSTAT = 1<<tcomp_flag_shift;
      accumulator += (ADC1->RESFIFO[0]&0xFFFF)>>3;
   };
   zero_psig_offset = accumulator/((float)zeroErrorCalcSamples); // This will truncate which sucks, but ... yebiga!
   loop_cntr = 0;
};







///////////////////////////////////////////////////////////////////////////////
//
// The pfilt() function
//
// Implements two selectable flavors of time-domain digital filters
// Moving average and envelope follower
//
///////////////////////////////////////////////////////////////////////////////

void pfilt(void) {
   new_in = (float)y_t;
#if (FILT_MOVAVG == 1)                  
   // Modified exponential moving average time-domain digital filter of length L (L_movavg)
   // y(n) = y(n-1) + x(n)(1/L) - y(n-1)(1/L)
   // y(n) = y(n-1) - y(n-1)(1/L) + x(n)(1/L)
   movavg_temp = (float)movavg_old - ( (float)movavg_old/(float)L_movavg );
   movavg      = movavg_temp + ( (float)new_in/(float)L_movavg );
   movavg_old  = movavg;
   filtered_y_t= movavg;
   return;
#elif (FILT_ENVFOLLOW == 1)            
   // Envelope follower time-domain digital filter
   if (new_in < envfollow_old) {
      envfollow = (envfollow_old-1);
   }
   else {
      if (new_in > envfollow_old) {
        envfollow = (envfollow_old+1);
      }
   };
   envfollow_old = envfollow;
   filtered_y_t  = envfollow;
   return;
#else
   filtered_y_t = new_in;
#endif
};  // end of pfilt







///////////////////////////////////////////////////////////////////////////////
//
// The ADC1 interrupt routine
//
// Sets a handshake flag for the main loop
// Optionally increments a counter that counts from 1 to 9 and repeats
// 
///////////////////////////////////////////////////////////////////////////////

void ADC1_IRQHandler(void){
#if (EnIntCntr == 1)                  // For system loop rate and sampling rate debug
  if (++loop_cntr == 10) loop_cntr=0; // For system loop rate and sampling rate debug
  ++loop_cntr;                        // For system loop rate and sampling rate debug
#endif                                // For system loop rate and sampling rate debug
  adc1_flag = 1;                      // Set handshake flag for the main thread
  ADC1->STAT |= 1<<tcomp_int_shift;   // Clear interrupt flag in ADC
  NVIC_ClearPendingIRQ(ADC1_IRQn);    // Clear interrupt in NVIC
};







///////////////////////////////////////////////////////////////////////////////
//
// The ADC0 interrupt routine
//
// Placeholder for future development
//
///////////////////////////////////////////////////////////////////////////////

void ADC0_IRQHandler(void){
  ADC0->TSTAT |= 1<<tcomp_int_shift;  // Clear interrupt in ADC
  NVIC_ClearPendingIRQ(ADC0_IRQn);    // Clear interrupt in NVIC
};







///////////////////////////////////////////////////////////////////////////////
//
// Simple delay loop
//
// Delays code execution for 5 clocks multiplied by the input
//
///////////////////////////////////////////////////////////////////////////////

void delay(unsigned int cnt) { // 5 clocks per iteration (Jeez)
	while((cnt--)){};
};







///////////////////////////////////////////////////////////////////////////////
//
// The ADC calibration routine (in all its naked glory)
//
///////////////////////////////////////////////////////////////////////////////

void CalADC1(void) {
	//   1. Run the CALOFS calibration by asserting CTRL[CALOFS] to 0b1 with the number of averages controlled by CTRL[CAL_AVGS].
	Sirhowlongisit = 0;
	ADC1->CTRL |= 1 << calofs_shift;

	//   2. Wait for assertion of STAT[CAL_RDY]
	while ((ADC1->STAT & 1<<cal_rdy_shift) == 0) {
		Sirhowlongisit++;
	};

	//   3. Run the GCC calibration by asserting CTRL[CAL_REQ] to 0b1 with the number of averages controlled by CTRL[CAL_AVGS].
	Thatsarpqdythink = 0;
	ADC1->CTRL |= 1 << cal_req_shift;

	//   4. Wait for assertion of both GCCa[RDY] flags (GCC[0].24 == GCC[1].24 == 1) if you know what I mean.
	while (3) {
		save_this = ADC1->GCC[0];
		save_that = ADC1->GCC[1];
		if ( (save_this > (1<<gcc_rdy_shift)) && (save_that > (1<<gcc_rdy_shift)) )
			break;
		Thatsarpqdythink++;
	};

	//   5. Having already read the GCCa[GAIN_CAL] registers, we can now proceed.
	save_this &= 0xFFFF;
	save_that &= 0xFFFF;

	//   6. Calculate gain_offset = (131072)/(131072-GCCa[GAIN_CAL]). This results in a floating point value somewhere within the range of 1 to 2.
	this_dividend = ((unsigned int)gain_const - save_this);
	that_dividend = ((unsigned int)gain_const - save_that);

	flotsom = gain_const / (float)this_dividend;
	jetsom = gain_const / (float)that_dividend;

	george = flotsom-1;
	jetson = jetsom-1;

	harry = (george * 65536);
	johnson = (jetson * 65536);

	PRINTF("\tOFFS calib. loops\t%d\r\n", Sirhowlongisit);
	PRINTF("\tGAIN calib. loops\t%d\r\n\n", Thatsarpqdythink);
	PRINTF("\tflotsom\t\t\t%a \r\n", flotsom);
	PRINTF("\tjetsom\t\t\t%a \r\n", jetsom);
	PRINTF("\tgeorge\t\t\t%a \r\n", george);
	PRINTF("\tjetson\t\t\t%a \r\n", jetson);
	PRINTF("\tharry\t\t\t0x%x \r\n", harry);
	PRINTF("\tjohnson\t\t\t0x%x \r\n\n\n", johnson);

	// 6a. Round the fractional component of each gain_offset to 16-bits, and write these values to the GCRa[GCALR] registers.
	// The Gain Calculation Result (GCRa) registers are utilized as part of the auto-calibration routine. There is a RDY status flag in
	// the GCR register which indicates whether the value GCRa[GCALR] is valid. Upon writing the GCRa[GCALR] value, the user
	// should also assert GCRa[RDY] to indicate that the offset calculation result is valid.
	// After beginning a calibration sequence by asserting CTRL[CAL_REQ], the calibration sequence will not be completed until
	// GCRa[GCALR] is calculated and GCRa[RDY] is asserted. The gain calculation will result in a floating point value between 1 and
	// 2. Since this value will always be between 1 and 2, the leading MSB 1 is redundant and doesn't need to be stored in this register.
	// GCRa[GCALR] should hold the 16-bit fractional component of the gain offset calculation. In other words, the value to be stored
	// in GCRa[GCALR] = gain_calculation - 1. To convert the GCRa[GCALR] value back into decimal format, this would be calculated
	// as: 1+0.5*GCRa[15]+0.25*GCRa[14]+0.125*GCRa[13]+ ... ad nauseum.
	ADC1->GCR[0] = 1<<gcc_rdy_shift | (unsigned int)harry;
	ADC1->GCR[1] = 1<<gcc_rdy_shift | (unsigned int)johnson;
}; // end of void CalADC1(void)







///////////////////////////////////////////////////////////////////////////////
//
// The discrete PID algorithm
//
///////////////////////////////////////////////////////////////////////////////

/******************************************************************************
// Here is pseudocode for a software loop that implements a PID algorithm:
//
// Kp      - proportional gain
// Ki      - integral gain
// Kd      - derivative gain
// dt      - loop interval time
//
// prev_error = 0;
// integral = 0;
//
// POOL:
//  error = SP - output;
//  proportional = error;
//  integral = integral + (error * dt);
//  derivative = (error - prev_error) / dt;
//  output = (Kp*proportional) + (Kd*derivative) + (Ki*integral);
//  prev_error = error;
//  wait dt;
//  goto POOL;
//
 * How to read this drawing
 *
 * r(t) is the set-point variable at time t.
 * r(t) = 0 for t<0
 * r(t) = SP for t>=0
 *
 * e(t) is the error at time t.
 * e(t)= 0 for t<0
 * e(t) = r(t)-y(t) for t>= 0
 *
 * The constants Kp, Ki, and Kd are non-negative and are determined during loop
 * tuning, which can be done either with the loop offline, or with the loop
 * online during a system calibration cycle. There are many methods of loop
 * tuning.
 *
 * u(t) is calculated at each time t based on the error e(t) at time t, which
 * is mapped to a duty-cycle and written to the PWM at time t.
 *
 * y(t) is sampled at every time t and is an unsigned integer between 0 and
 * ADCmaxval.
 *
 * So there.
 *                                  ______________________
 *                                 |                      | P_t
 *                         ------->|P     Kp*e(t)         |--------->
 *                        |        |______________________|          |
 *                        |                                          |
 *             _____      |         ______________________         _+|__        ___________
 *    r(t)    |     |e(t) |        |         t            | I_t   |     | u(t) |           |   y(t)   output
 * ---------->| SUM |->---@------->|I  Ki*Int{e(t)dt      |------>| SUM |----->|  Process  |-----@---->
 *           +|_____|     |        |_________0____________|      +|_____|      |___________|     |
 *             - ^        |                                         +|                           v
 *               |        |         ______________________           |                           |
 *               |        |        |                      | D_t      |                           |
 *               |         ------->|D     Kd*[de(t)/d(t)] |--------->                            |
 *               |                 |______________________|                                      |
 *               |                                                                               |
 *               ---------------------------------------------------------------------------------
 * 
 * 
******************************************************************************/

///////////////////////////////////////////////////////////////////////////////
//
// The pidal() function
//
// Implementation of a discrete-time PID algorithm
// Inputs:
//   pid_input_variable: the filtered or unfiltered sampled transducer output
//   r_t:                the current setpoint
//   e_tm1:              the previous value of the error e_t
//   I_tm1:              the previous value of the running sum I
// Outputs:
//   u_t:                the new value to be written to the PWM
//   inew_duty_rounded:  u_t converted to duty-cyle as a percentage
// Temp variables for debugging convenience:
//   e_t_times_dt
//   I_tm1
//   e_t_minus_e_tm1
//   fnew_u_t_limited 
//   fnew_u_t_scaled
//   inew_u_t_rounded
//
///////////////////////////////////////////////////////////////////////////////

void pidal(void) {
  e_t = (r_t - pid_input_variable); // The current error e_t
  e_t_times_dt = ((float)e_t)*dt;   // Temp variable
  e_t_minus_e_tm1 = (e_t - e_tm1);  // Temp variable
  P = (float)e_t;                   // Update the Position variable P. Always equals the current error
  if (e_t*e_tm1 <= 0) {             // Zero the integral when error changes sign, or is equal to 0.
    I = 0;
  }
  else {
//  I = I + ((float)(e_t)*dt);      // Update the Integral variable (the running sum) I
    I = I_tm1 + (e_t_times_dt);     //
  }
//D = (e_t-e_tm1)/dt;               // Update the Derivative variable, D
  D = ((float)e_t_minus_e_tm1)/dt;  //
  e_tm1 = e_t;                      // Save e_t in the previous error variable e_tm1 for the next iteration
  I_tm1 = I;                        // Temp variable

  Kp= 1.0;//1.0                     // Populate the gains for loop tuning. These variables can be changed in a Freemaster or other debugger session.
  Ki= 0.0;//1.0
  Kd= 0.0;//0.01

  P_t = Kp*P;                       // Apply the gains to the the loop tuning variables
  I_t = Ki*I;
  D_t = Kd*D;

  fnew_u_t_actual = P_t + I_t + D_t;// In terms of ADCcnts. 
                                    // Limit and scale this into the range [0:pwm_reload_val] to get the new process variable u_t for the PWM
  fnew_u_t_limited = fnew_u_t_actual;
  if (fnew_u_t_limited >= (float)(pwm_reload_val)) {
    fnew_u_t_limited = (float)(pwm_reload_val);
  }
  else if (fnew_u_t_limited <= 0.0) {
    fnew_u_t_limited = 0.0;
  };
  fnew_u_t_scaled = fnew_u_t_limited * ((float)pwm_reload_val/ADCmaxval);
  inew_u_t_rounded = lroundf(fnew_u_t_scaled); 

  u_t = inew_u_t_rounded;           // Write the new process variable u_t to the PWM

  fnew_duty_limited = (fnew_u_t_scaled/((float)ADCmaxval))*100.0;
  inew_duty_rounded = lroundf(fnew_duty_limited);

}; // end of pidal()


















void Hell (void)
{
	// Set up P1 for a good bit-bang and some cheap titillation (must be 18 years or older, not legal in California)
	CLOCK_EnableClock(kCLOCK_Gpio1);
	RESET_PeripheralReset(kGPIO1_RST_SHIFT_RSTn);
	GPIO->DIRSET[1] = 1<<20 | 1<<17; // Make outputs
	while(1) {
		GPIO->SET[1] = 1<<20;
		GPIO->CLR[1] = 1<<17;
		delay(30000000);
		GPIO->SET[1] = 1<<17;
		GPIO->CLR[1] = 1<<20;
		delay(30000000);
	};
};





