/*
 * Copyright 2021 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

/***********************************************************************************************************************
 * This file was generated by the MCUXpresso Config Tools. Any manual edits made to this file
 * will be overwritten if the respective MCUXpresso Config Tools is used to update this file.
 **********************************************************************************************************************/

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
!!GlobalInfo
product: Pins v10.0
processor: LPC55S36
package_id: LPC55S36JBD100
mcu_data: ksdk2_0
processor_version: 0.10.8
pin_labels:
- {pin_num: '61', pin_signal: PIO1_2/CAN0_TD/CTIMER0_MAT3/SCT_GPI6/PDM_CLK1/HS_SPI_SCK/PWM0_B0/AOI0_OUT0}
- {pin_num: '75', pin_signal: PIO1_4/FC0_SCK/CTIMER2_MAT1/SCT0_OUT0/FREQME_GPIO_CLK_A/FC4_TXD_SCL_MISO_WS/SPI_DIN/PWM0_B2/TRIGOUT_7/EXTTRIG_IN8}
- {pin_num: '62', pin_signal: PIO1_3/CAN0_RD/FC2_TXD_SCL_MISO_WS/SCT0_OUT4/PDM_DATA1/HS_SPI_MISO/USB0_PORTPWRN/PWM0_A3, label: GPIO_HANDSHAKE, identifier: GPIO_HANDSHAKE}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

#include "fsl_common.h"
#include "fsl_gpio.h"
#include "fsl_iocon.h"
#include "pin_mux.h"

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitBootPins
 * Description   : Calls initialization functions.
 *
 * END ****************************************************************************************************************/
void BOARD_InitBootPins(void)
{
    BOARD_InitPins();
}

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_InitPins:
- options: {callFromInitBoot: 'true', coreID: cm33_core0, enableClock: 'true'}
- pin_list:
  - {pin_num: '70', peripheral: FLEXCOMM1, signal: CTS_SDA_SSEL0, pin_signal: PIO0_13/FC1_CTS_SDA_SSEL0/UTICK_CAP0/CT_INP0/SCT_GPI0/FC1_RXD_SDA_MOSI_DATA/SECURE_GPIO0_13/EXTTRIG_IN3,
    mode: inactive, slew_rate: standard, invert: disabled, open_drain: disabled, ssel: signal3v3, filter_off: disabled, ecs: disabled, egp: i2c, i2cfilter: nonhighspeedmode}
  - {pin_num: '71', peripheral: FLEXCOMM1, signal: TXD_SCL_MISO_WS, pin_signal: PIO0_14/FC1_RTS_SCL_SSEL1/UTICK_CAP1/CT_INP1/SCT_GPI1/FC1_TXD_SCL_MISO_WS/SECURE_GPIO0_14/EXTTRIG_IN2,
    mode: inactive, slew_rate: standard, invert: disabled, open_drain: disabled, ssel: signal3v3, filter_off: disabled, ecs: disabled, egp: i2c, i2cfilter: nonhighspeedmode}
  - {pin_num: '62', peripheral: GPIO, signal: 'PIO1, 3', pin_signal: PIO1_3/CAN0_RD/FC2_TXD_SCL_MISO_WS/SCT0_OUT4/PDM_DATA1/HS_SPI_MISO/USB0_PORTPWRN/PWM0_A3, direction: OUTPUT,
    gpio_init_state: 'true', mode: inactive, slew_rate: standard, invert: disabled, open_drain: disabled}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitPins
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
/* Function assigned for the Cortex-M33 */
void BOARD_InitPins(void)
{
    /* Enables the clock for the I/O controller.: Enable Clock. */
    CLOCK_EnableClock(kCLOCK_Iocon);

    /* Enables the clock for the GPIO1 module */
    CLOCK_EnableClock(kCLOCK_Gpio1);

    gpio_pin_config_t GPIO_HANDSHAKE_config = {
        .pinDirection = kGPIO_DigitalOutput,
        .outputLogic = 1U
    };
    /* Initialize GPIO functionality on pin PIO1_3 (pin 62)  */
    GPIO_PinInit(BOARD_INITPINS_GPIO_HANDSHAKE_GPIO, BOARD_INITPINS_GPIO_HANDSHAKE_PORT, BOARD_INITPINS_GPIO_HANDSHAKE_PIN, &GPIO_HANDSHAKE_config);

    const uint32_t port0_pin13_config = (/* Pin is configured as FC1_CTS_SDA_SSEL0 */
                                         IOCON_PIO_FUNC1 |
                                         /* No addition pin function */
                                         IOCON_PIO_MODE_INACT |
                                         /* Standard mode, output slew rate control is enabled */
                                         IOCON_PIO_SLEW_STANDARD |
                                         /* Input function is not inverted */
                                         IOCON_PIO_INV_DI |
                                         /* Enables digital function */
                                         IOCON_PIO_DIGITAL_EN |
                                         /* Open drain is disabled */
                                         IOCON_PIO_OPENDRAIN_DI |
                                         /* 3V3 signaling in I2C mode */
                                         IOCON_PIO_SSEL_3V3 |
                                         /* Input filter disabled */
                                         IOCON_PIO_INPFILT_OFF |
                                         /* IO is an open drain cell */
                                         IOCON_PIO_ECS_DI |
                                         /* I2C mode */
                                         IOCON_PIO_EGP_I2C |
                                         /* I2C 50 ns glitch filter enabled. Typically used for Standard mode, Fast-mode and Fast-mode Plus I2C. */
                                         IOCON_PIO_I2CFILTER_NONHIGHSPEED);
    /* PORT0 PIN13 (coords: 70) is configured as FC1_CTS_SDA_SSEL0 */
    IOCON_PinMuxSet(IOCON, 0U, 13U, port0_pin13_config);

    const uint32_t port0_pin14_config = (/* Pin is configured as FC1_TXD_SCL_MISO_WS */
                                         IOCON_PIO_FUNC6 |
                                         /* No addition pin function */
                                         IOCON_PIO_MODE_INACT |
                                         /* Standard mode, output slew rate control is enabled */
                                         IOCON_PIO_SLEW_STANDARD |
                                         /* Input function is not inverted */
                                         IOCON_PIO_INV_DI |
                                         /* Enables digital function */
                                         IOCON_PIO_DIGITAL_EN |
                                         /* Open drain is disabled */
                                         IOCON_PIO_OPENDRAIN_DI |
                                         /* 3V3 signaling in I2C mode */
                                         IOCON_PIO_SSEL_3V3 |
                                         /* Input filter disabled */
                                         IOCON_PIO_INPFILT_OFF |
                                         /* IO is an open drain cell */
                                         IOCON_PIO_ECS_DI |
                                         /* I2C mode */
                                         IOCON_PIO_EGP_I2C |
                                         /* I2C 50 ns glitch filter enabled. Typically used for Standard mode, Fast-mode and Fast-mode Plus I2C. */
                                         IOCON_PIO_I2CFILTER_NONHIGHSPEED);
    /* PORT0 PIN14 (coords: 71) is configured as FC1_TXD_SCL_MISO_WS */
    IOCON_PinMuxSet(IOCON, 0U, 14U, port0_pin14_config);

    const uint32_t GPIO_HANDSHAKE = (/* Pin is configured as PIO1_3 */
                                     IOCON_PIO_FUNC0 |
                                     /* No addition pin function */
                                     IOCON_PIO_MODE_INACT |
                                     /* Standard mode, output slew rate control is enabled */
                                     IOCON_PIO_SLEW_STANDARD |
                                     /* Input function is not inverted */
                                     IOCON_PIO_INV_DI |
                                     /* Enables digital function */
                                     IOCON_PIO_DIGITAL_EN |
                                     /* Open drain is disabled */
                                     IOCON_PIO_OPENDRAIN_DI);
    /* PORT1 PIN3 (coords: 62) is configured as PIO1_3 */
    IOCON_PinMuxSet(IOCON, BOARD_INITPINS_GPIO_HANDSHAKE_PORT, BOARD_INITPINS_GPIO_HANDSHAKE_PIN, GPIO_HANDSHAKE);
}
/***********************************************************************************************************************
 * EOF
 **********************************************************************************************************************/
