/*--------------------------------------------------------------------------*/
/* Copyright 2021 NXP                                                       */
/*                                                                          */
/* NXP Confidential. This software is owned or controlled by NXP and may    */
/* only be used strictly in accordance with the applicable license terms.   */
/* By expressly accepting such terms or by downloading, installing,         */
/* activating and/or otherwise using the software, you are agreeing that    */
/* you have read, and that you agree to comply with and are bound by, such  */
/* license terms. If you do not agree to be bound by the applicable license */
/* terms, then you may not retain, install, activate or otherwise use the   */
/* software.                                                                */
/*--------------------------------------------------------------------------*/

/** @file  mcuxClEcc_Constants.c
 *  @brief Provides constans definitions for domain parameters
 */

#include <internal/mcuxClEcc_Mont_Internal.h>
#include <mcuxClEcc.h>

#define CURVE25519_BYTE_LEN_P      (MCUXCLECC_MONT_CURVE25519_SIZE_PRIMEP)
#define CURVE25519_BYTE_LEN_N      (MCUXCLECC_MONT_CURVE25519_SIZE_BASEPOINTORDER)

static const uint8_t pCurve25519_FullP[CURVE25519_BYTE_LEN_P + 8u] __attribute__ ((aligned (4))) =
{
  0x1bu, 0xcau, 0x6bu, 0x28u, 0xafu, 0xa1u, 0xbcu, 0x86u,
  0xedu, 0xffu, 0xffu, 0xffu, 0xffu, 0xffu, 0xffu, 0xffu, 0xffu, 0xffu, 0xffu, 0xffu, 0xffu, 0xffu, 0xffu, 0xffu,
  0xffu, 0xffu, 0xffu, 0xffu, 0xffu, 0xffu, 0xffu, 0xffu, 0xffu, 0xffu, 0xffu, 0xffu, 0xffu, 0xffu, 0xffu, 0x7fu
};

static const uint8_t pCurve25519_FullN[CURVE25519_BYTE_LEN_N + 8u] __attribute__ ((aligned (4))) =
{
    0x1bu, 0x7eu, 0x54u, 0x12u, 0xa3u, 0x1du, 0xb5u, 0xd2u,
    0xedu, 0xd3u, 0xf5u, 0x5cu, 0x1au, 0x63u, 0x12u, 0x58u, 0xd6u, 0x9cu, 0xf7u, 0xa2u, 0xdeu, 0xf9u, 0xdeu, 0x14u,
    0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x10u
};

static const uint8_t pCurve25519_R2P[CURVE25519_BYTE_LEN_P]  __attribute__ ((aligned (4))) =
{
    0xa4u, 0x05u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u,
    0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u,
};

static const uint8_t pCurve25519_R2N[CURVE25519_BYTE_LEN_N]  __attribute__ ((aligned (4))) =
{
    0x01u, 0x0fu, 0x9cu, 0x44u, 0xe3u, 0x11u, 0x06u, 0xa4u, 0x47u, 0x93u, 0x85u, 0x68u, 0xa7u, 0x1bu, 0x0eu, 0xd0u,
	0x65u, 0xbeu, 0xf5u, 0x17u, 0xd2u, 0x73u, 0xecu, 0xceu, 0x3du, 0x9au, 0x30u, 0x7cu, 0x1bu, 0x41u, 0x99u, 0x03u
};

static const uint8_t pCurve25519_PointGX[CURVE25519_BYTE_LEN_P] __attribute__ ((aligned (4))) =
{
    0x09u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u,
    0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u ,0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u
};

static const uint8_t pCurve25519_PointGY[CURVE25519_BYTE_LEN_P] __attribute__ ((aligned (4))) =
{
    0xD9u, 0xD3u, 0xCEu, 0x7Eu, 0xA2u, 0xC5u, 0xE9u, 0x29u, 0xB2u, 0x61u, 0x7Cu, 0x6Du, 0x7Eu, 0x4Du, 0x3Du, 0x92u,
    0x4Cu, 0xD1u, 0x48u, 0x77u, 0x2Cu, 0xDDu, 0x1Eu, 0xE0u, 0xB4u, 0x86u, 0xA0u, 0xB8u, 0xA1u, 0x19u, 0xAEu, 0x20u
};

static const uint8_t pCurve25519_LadderConst[CURVE25519_BYTE_LEN_P] __attribute__ ((aligned (4))) =
{
    0x42u, 0xDBu, 0x01u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u,
    0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u
};

static const uint8_t pCurve25519_A[CURVE25519_BYTE_LEN_P] __attribute__ ((aligned (4))) =
{
    0x06u, 0x6Du, 0x07u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u,
    0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u
};

static const uint8_t pCurve25519_B[CURVE25519_BYTE_LEN_P] __attribute__ ((aligned (4))) =
{
    0x01u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u,
    0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u, 0x00u
};

const mcuxClEcc_Mont_DomainParams_t mcuxClEcc_Mont_DomainParams_Curve25519 =
{
    .common.curveID = MCUXCLECC_CURVEID_MONT_X25519,
    .common.byteLenP = CURVE25519_BYTE_LEN_P,
    .common.byteLenN = CURVE25519_BYTE_LEN_N,
    .common.pFullModulusP = (uint8_t*)&pCurve25519_FullP,
    .common.pFullModulusN = (uint8_t*)&pCurve25519_FullN,
    .common.pR2P = (uint8_t*)&pCurve25519_R2P,
    .common.pR2N = (uint8_t*)&pCurve25519_R2N,
    .c = 3u,
    .t = 254u,
    .pA = (uint8_t*)&pCurve25519_A,
    .pB = (uint8_t*)&pCurve25519_B,
    .pGx = (uint8_t*)&pCurve25519_PointGX,
    .pGy = (uint8_t*)&pCurve25519_PointGY,
    .pA24 = (uint8_t*)&pCurve25519_LadderConst
};
