/*--------------------------------------------------------------------------*/
/* Copyright 2020 NXP                                                       */
/*                                                                          */
/* NXP Confidential. This software is owned or controlled by NXP and may    */
/* only be used strictly in accordance with the applicable license terms.   */
/* By expressly accepting such terms or by downloading, installing,         */
/* activating and/or otherwise using the software, you are agreeing that    */
/* you have read, and that you agree to comply with and are bound by, such  */
/* license terms. If you do not agree to be bound by the applicable license */
/* terms, then you may not retain, install, activate or otherwise use the   */
/* software.                                                                */
/*--------------------------------------------------------------------------*/

/** @file  mcuxClMac_MemoryConsumption.h
 *  @brief Defines the memory consumption for the mcuxClMac component */

#ifndef MCUXCLMAC_MEMORYCONSUMPTION_H_
#define MCUXCLMAC_MEMORYCONSUMPTION_H_

/**
 * @defgroup mcuxClMac_MemoryConsumption mcuxClMac_MemoryConsumption
 * @brief Defines the memory consumption for the mcuxClMac component
 * @ingroup mcuxClMac
 * @{
 */

/**********************************************
 * TYPEDEFS
 **********************************************/

/** @def MCUXCLMAC_WA_SIZE_MAX
 *  @brief Define the max workarea size required for this component
 */
#define MCUXCLMAC_WA_SIZE_MAX (16)

/**
 * @}
 */ /* mcuxClMac_MemoryConsumption */

#endif /* MCUXCLMAC_MEMORYCONSUMPTION_H_ */
