/*--------------------------------------------------------------------------*/
/* Copyright 2021 NXP                                                       */
/*                                                                          */
/* NXP Confidential. This software is owned or controlled by NXP and may    */
/* only be used strictly in accordance with the applicable license terms.   */
/* By expressly accepting such terms or by downloading, installing,         */
/* activating and/or otherwise using the software, you are agreeing that    */
/* you have read, and that you agree to comply with and are bound by, such  */
/* license terms. If you do not agree to be bound by the applicable license */
/* terms, then you may not retain, install, activate or otherwise use the   */
/* software.                                                                */
/*--------------------------------------------------------------------------*/

/**
 * @file  mcuxClMath_SecModExp.fup.c
 * @brief mcuxClMath: FUP programs of secure modular exponentiation
 */

#include <mcuxClMath_SecModExp_FUP.h>

SDK_ALIGN(const mcuxClPkc_FUPEntry_t mcuxClMath_Fup_Aws_Init[5], 4u) = {{0x10u,0x00u,0x03u,0x38u,0x08u,0x40u},{0x80u,0x00u,0x02u,0x01u,0x07u,0x04u},{0x00u,0x1eu,0x00u,0x04u,0x0du,0x03u},{0x00u,0x09u,0x00u,0x00u,0x07u,0x00u},{0x00u,0x09u,0x00u,0x00u,0x07u,0x04u}};

SDK_ALIGN(const mcuxClPkc_FUPEntry_t mcuxClMath_Fup_EuclideanSplit_1[8], 4u) = {{0x10u,0x00u,0x7bu,0xd7u,0x1du,0xa7u},{0xc0u,0x00u,0x04u,0x00u,0x0au,0x01u},{0xc0u,0x00u,0x05u,0x00u,0x0au,0x03u},{0x80u,0x33u,0x01u,0x00u,0x0au,0x00u},{0x80u,0x33u,0x03u,0x00u,0x0au,0x01u},{0x80u,0x2au,0x0au,0x00u,0x0au,0x00u},{0x80u,0x2au,0x0au,0x01u,0x0au,0x01u},{0x80u,0x2au,0x0au,0x00u,0x01u,0x0bu}};

SDK_ALIGN(const mcuxClPkc_FUPEntry_t mcuxClMath_Fup_EuclideanSplit_2[7], 4u) = {{0x10u,0x00u,0x2cu,0xa9u,0x8au,0xa5u},{0x40u,0x09u,0x00u,0x00u,0x04u,0x04u},{0x40u,0x6au,0x00u,0x04u,0x01u,0x04u},{0x40u,0x6au,0x00u,0x04u,0x0bu,0x04u},{0x40u,0x09u,0x00u,0x00u,0x05u,0x05u},{0x40u,0x6au,0x00u,0x05u,0x01u,0x05u},{0x40u,0x3eu,0x00u,0x00u,0x0du,0x00u}};

SDK_ALIGN(const mcuxClPkc_FUPEntry_t mcuxClMath_Fup_ExactDivideLoop[9], 4u) = {{0x10u,0x00u,0xbbu,0x42u,0x33u,0x63u},{0x00u,0x00u,0x08u,0x06u,0x00u,0x0cu},{0x00u,0x00u,0x0cu,0x0au,0x00u,0x00u},{0x40u,0x0au,0x00u,0x08u,0x00u,0x08u},{0x00u,0x1eu,0x00u,0x0cu,0x0du,0x08u},{0x00u,0x00u,0x09u,0x06u,0x00u,0x0cu},{0x00u,0x00u,0x0cu,0x0au,0x00u,0x00u},{0x40u,0x0au,0x00u,0x09u,0x00u,0x09u},{0x00u,0x1eu,0x00u,0x0cu,0x0du,0x09u}};


