# PSA Crypto Testcase checklist 



| Group                        | Test      | Function                         | Scenario                                                                               | Return Value                                | Steps                                                                                                            | Test Case                                                                                |   |
|------------------------------|-----------|----------------------------------|----------------------------------------------------------------------------------------|---------------------------------------------|------------------------------------------------------------------------------------------------------------------|------------------------------------------------------------------------------------------|---|
| Library Initialization       | test_c001 | psa_crypto_init                  | Library initialization                                                                 | PSA_SUCCESS                                 | Calling this function should return SUCCESS                                                                      |                                                                                          |   |
|                              |           |                                  | Applications must call this function before calling any other function in this module. | PSA_SUCCESS                                 | Try calling crypto operations doing a crypto_init should be successful(can be covered as part of other testcase) |                                                                                          |   |
|                              |           |                                  | Applications may call this function more than once. Once a call succeeds               | subsequent calls are guaranteed to succeed. | PSA_SUCCESS                                                                                                      | Try calling multiple crypto init and should return SUCCESS                               |   |
|                              |           |                                  | Applications must call this function before calling any other function in this module. | PSA_ERROR_BAD_STATE                         | Try calling crypto operations without doing a crypto_init should return FAILURE                                  |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  |                                                                                          |   |
| Key Management               | test_c002 | psa_import_key                   | Import a key in binary format.                                                         | PSA_SUCCESS                                 | 1. Initialize the PSA crypto library                                                                             | 1. 16 Byte AES                                                                           |   |
|                              |           |                                  |                                                                                        |                                             | 2. Setup the attributes for the key                                                                              | 2. 24 Byte AES                                                                           |   |
|                              |           |                                  |                                                                                        |                                             | 3. Import the key data into the key slot                                                                         | 3. 32 Byte AES                                                                           |   |
|                              |           |                                  |                                                                                        |                                             | 4. Get basic metadata about a key                                                                                | 4. 2048 RSA public key                                                                   |   |
|                              |           |                                  |                                                                                        |                                             | 5. Export a key in binary format                                                                                 | 5. 2048 RSA keypair                                                                      |   |
|                              |           |                                  |                                                                                        |                                             | 6. Check if original key data matches with the exported data                                                     | 6. DES 64 bit key                                                                        |   |
|                              |           |                                  |                                                                                        |                                             | 7. Reset the key attributes                                                                                      | 7. Triple DES 2-Key                                                                      |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 8. Triple DES 3-Key                                                                      |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 9. EC Public key                                                                         |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 10. EC keypair                                                                           |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_NOT_SUPPORTED                     | Calling this function with incorrect key type                                                                    | Incorrect key type                                                                       |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_INVALID_ARGUMENT                  | Calling this function with invalid parameter should return this error                                            | 1. Key data greater than the algorithm size                                              |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 2. Incorrect key data size                                                               |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_INVALID_HANDLE                    | Calling this function with invalid key handle should return this error                                           |                                                                                          |   |
| Key Management               | test_c003 | psa_export_key                   | Export a key in binary format                                                          | PSA_SUCCESS                                 | 1. Initialize the PSA crypto library                                                                             | 1. 16 Byte AES                                                                           |   |
|                              |           |                                  |                                                                                        |                                             | 2. Setup the attributes for the key                                                                              | 2. 24 Byte AES                                                                           |   |
|                              |           |                                  |                                                                                        |                                             | 3. Import the key data into the key slot                                                                         | 3. 32 Byte AES                                                                           |   |
|                              |           |                                  |                                                                                        |                                             | 4. Get basic metadata about a key                                                                                | 4. 2048 RSA public key                                                                   |   |
|                              |           |                                  |                                                                                        |                                             | 5. Export a key in binary format                                                                                 | 5. 2048 RSA keypair                                                                      |   |
|                              |           |                                  |                                                                                        |                                             | 6. Check if original key data matches with the exported data                                                     | 6. DES 64 bit key                                                                        |   |
|                              |           |                                  |                                                                                        |                                             | 7. Reset the key attributes                                                                                      | 7. Triple DES 2-Key                                                                      |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 8. Triple DES 3-Key                                                                      |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 9. EC Public key                                                                         |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 10. EC keypair                                                                           |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_BUFFER_TOO_SMALL                  | Calling this function with buffer size less than required                                                        | Less buffer size                                                                         |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_NOT_PERMITTED                     | Calling this function with with key policy as verify should return this error                                    | Key policy as PSA_KEY_USAGE_VERIFY                                                       |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_INVALID_HANDLE                    | Calling this function with invalid parameter should return this error                                            | 1. Destroyed key slot                                                                    |   |
| Key Management               | test_c004 | psa_export_public_key            | Export a public key or the public part of a key pair in binary format.                 | PSA_SUCCESS                                 | 1. Initialize the PSA crypto library                                                                             | 1. 2048 RSA public key                                                                   |   |
|                              |           |                                  |                                                                                        |                                             | 2. Setup the attributes for the key                                                                              | 2. 2048 RSA keypair                                                                      |   |
|                              |           |                                  |                                                                                        |                                             | 3. Import the key data into the key slot                                                                         | 3. EC Public key                                                                         |   |
|                              |           |                                  |                                                                                        |                                             | 4. Get basic metadata about a key                                                                                | 4. EC keypair                                                                            |   |
|                              |           |                                  |                                                                                        |                                             | 5. Export a key in binary format                                                                                 |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 6. Check if original key data matches with the exported data                                                     |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 7. Reset the key attributes                                                                                      |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  |                                                                                          |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_BUFFER_TOO_SMALL                  | Calling this function with buffer size less than required                                                        | Less buffer size                                                                         |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_INVALID_ARGUMENT                  | Calling this function with invalid  parameter should return this error                                           | 1. DES 64 bit key                                                                        |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 2. Triple DES 2-Key                                                                      |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 3. Triple DES 3-Key                                                                      |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_NOT_PERMITTED                     | Calling this function with with key policy as verify should return this error                                    | Key usage as PSA_KEY_USAGE_VERIFY                                                        |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_INVALID_HANDLE                    | Calling this function with invalid key handle should return this error                                           | 1. Destroyed key slot                                                                    |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_BAD_STATE                         | Calling this function with key policy that cannot be exported                                                    | Invalid key policy usage                                                                 |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_DOES_NOT_EXIST                    | Calling this function with empty key slot                                                                        | Empty key slot                                                                           |   |
| Key Management               | test_c005 | psa_destroy_key                  | Destroy a key and restore the slot to its default state.                               | PSA_SUCCESS                                 | 1. Initialize the PSA crypto library                                                                             | 1. 16 Byte AES                                                                           |   |
|                              |           |                                  |                                                                                        |                                             | 2. Setup the attributes for the key                                                                              | 2. 24 Byte AES                                                                           |   |
|                              |           |                                  |                                                                                        |                                             | 3. Import the key data into the key slot                                                                         | 3. 32 Byte AES                                                                           |   |
|                              |           |                                  |                                                                                        |                                             | 4. Get basic metadata about a key                                                                                | 4. 2048 RSA public key                                                                   |   |
|                              |           |                                  |                                                                                        |                                             | 5. Destroy a key and restore the slot to its default state                                                       | 5. 2048 RSA keypair                                                                      |   |
|                              |           |                                  |                                                                                        |                                             | 6. Check that if the key metadata are destroyed                                                                  | 6. DES 64 bit key                                                                        |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 7. Triple DES 2-Key                                                                      |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 8. Triple DES 3-Key                                                                      |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 9. EC Public key                                                                         |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 10. EC keypair                                                                           |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_INVALID_HANDLE                    | Calling this function with invalid parameter should return this error                                            | Already destroyed key slot                                                               |   |
| Message Digests              | test_c006 | psa_hash_compute                 | Calculate the hash (digest) of a message                                               | PSA_SUCCESS                                 | 1. Initialize the PSA crypto library                                                                             | 1. MD2                                                                                   |   |
|                              |           |                                  |                                                                                        |                                             | 2. Calculate the hash (digest) of a message                                                                      | 2. MD4                                                                                   |   |
|                              |           |                                  |                                                                                        |                                             | 3. Check if it matches with the expected values                                                                  | 3. MD5                                                                                   |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 4. RIPEMD160                                                                             |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 5. SHA1                                                                                  |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 6. SHA224                                                                                |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 7. SHA256                                                                                |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 8. SHA384                                                                                |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 9. SHA512                                                                                |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_BUFFER_TOO_SMALL                  | Calling this function with small buffer size  should return this error                                           | small buffer size                                                                        |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_NOT_SUPPORTED                     | Calling this function with invalid algorithm  should return this error                                           | Invalid algorithm                                                                        |   |
| Message Digests              | test_c007 | psa_hash_compare                 | Calculate the hash (digest) of a message and compare it with a reference value         | PSA_SUCCESS                                 | 1. Initialize the PSA crypto library                                                                             | 1. MD2                                                                                   |   |
|                              |           |                                  |                                                                                        |                                             | 2. Calculate the hash (digest) of a message and compare it with a reference value                                | 2. MD4                                                                                   |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 3. MD5                                                                                   |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 4. RIPEMD160                                                                             |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 5. SHA1                                                                                  |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 6. SHA224                                                                                |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 7. SHA256                                                                                |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 8. SHA384                                                                                |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 9. SHA512                                                                                |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_INVALID_SIGNATURE                 | Calling this function with incorrect expected hash                                                               | Incorrect expected hash                                                                  |   |
|                              |           |                                  |                                                                                        |                                             | Calling this function with incorrect expected hash                                                               | Incorrect expected hash length                                                           |   |
| Key Derivation               | test_c008 | psa_key_derivation_setup         | Set up a key derivation operation.                                                     | PSA_SUCCESS                                 | 1. Initialize the PSA crypto library                                                                             | 1. ECDH + HKDF-SHA-256                                                                   |   |
|                              |           |                                  |                                                                                        |                                             | 2.  Set up a key derivation operation                                                                            |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 3. Abort the key derivation operation                                                                            |                                                                                          |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_INVALID_ARGUMENT                  | Calling this function with invalid parameter should return this error                                            | 1. Bad key derivation algorithm                                                          |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 2. Invalid Algorithm                                                                     |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_NOT_SUPPORTED                     | Calling this function with unsupported parameter should return this error                                        | ECDH, unknown KDF                                                                        |   |
| Key Derivation               | test_c009 | psa_key_derivation_input_bytes   | Provide an input for key derivation or key agreement                                   | PSA_SUCCESS                                 | 1. Initialize the PSA crypto library                                                                             | 1. Step as Info                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 2. Initialize a key policy structure to a default that forbids all usage of the key                              | 2. Step as salt                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 3. Provide an input for key derivation or key agreement                                                          | 3. Step as label                                                                         |   |
|                              |           |                                  |                                                                                        |                                             | 4. Allocate a key slot for a transient key                                                                       | 4. Step as seed                                                                          |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_INVALID_ARGUMENT                  | Calling this function with invalid parameter should return this error                                            | 1. Step as secret                                                                        |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 2. Invalid step                                                                          |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_BAD_STATE                         | Key derivation on an aborted operation                                                                           | Aborted operation                                                                        |   |
| Key Attributes               | test_c010 | psa_set_key_id                   | Set the attributes for the key                                                         | NA                                          | 1. Initialize the PSA crypto library                                                                             | Testing only volatile keys and persistence key types will be supported in future release |   |
|                              |           | psa_set_key_lifetime             |                                                                                        |                                             | 2. Check if all the attributes are initialized to zero                                                           |                                                                                          |   |
|                              |           | psa_set_key_type                 |                                                                                        |                                             | 3. Setup the attributes for the key                                                                              |                                                                                          |   |
|                              |           | psa_set_key_bits                 |                                                                                        |                                             | 4. Check if all the attributes are as per the input                                                              |                                                                                          |   |
|                              |           | psa_set_key_usage_flags          |                                                                                        |                                             | 5. Reset the attributes                                                                                          |                                                                                          |   |
|                              |           | psa_set_key_algorithm            |                                                                                        |                                             | 6. Check if all the attributes are erased                                                                        |                                                                                          |   |
|                              |           | psa_get_key_id                   | Get the attributes for the key                                                         |                                             |                                                                                                                  |                                                                                          |   |
|                              |           | psa_get_key_lifetime             |                                                                                        |                                             |                                                                                                                  |                                                                                          |   |
|                              |           | psa_get_key_type                 |                                                                                        |                                             |                                                                                                                  |                                                                                          |   |
|                              |           | psa_get_key_bits                 |                                                                                        |                                             |                                                                                                                  |                                                                                          |   |
|                              |           | psa_get_key_usage_flags          |                                                                                        |                                             |                                                                                                                  |                                                                                          |   |
|                              |           | psa_get_key_algorithm            |                                                                                        |                                             |                                                                                                                  |                                                                                          |   |
|                              |           | psa_reset_key_attributes         |                                                                                        |                                             |                                                                                                                  |                                                                                          |   |
| Message Digests              | test_c011 | psa_hash_start                   | Start a multipart hash operation.                                                      | PSA_SUCCESS                                 | 1. Initialize the PSA crypto library                                                                             | 1. MD2                                                                                   |   |
|                              |           |                                  |                                                                                        |                                             | 2. Start a multipart hash operation                                                                              | 2. MD4                                                                                   |   |
|                              |           |                                  |                                                                                        |                                             | 3. Abort the hash operation                                                                                      | 3. MD5                                                                                   |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 4. RIPEMD160                                                                             |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 5. SHA1                                                                                  |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 6. SHA224                                                                                |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 7. SHA256                                                                                |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 8. SHA512                                                                                |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 9. SHA512_224                                                                            |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 10. SHA512_256                                                                           |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 11. SHA3_224 1                                                                           |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 2. SHA3_256 1                                                                            |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 3. SHA3_384 1                                                                            |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 4. SHA3_512                                                                              |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_NOT_SUPPORTED                     | Calling this function with unsupported algorithm should return error                                             | Invalid hash algorithm                                                                   |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_BAD_STATE                         | Calling this function again after setup                                                                          | Multiple setup calls after one another                                                   |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_INVALID_ARGUMENT                  | Calling this function with invalid parameter should return this error                                            | 1. Invalid algorithm                                                                     |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 2. CTR algorithm                                                                         |   |
| Message Digests              | test_c012 | psa_hash_update                  | Add a message fragment to a multipart hash operation.                                  | PSA_SUCCESS                                 | 1. Initialize the PSA crypto library                                                                             | 1. MD2                                                                                   |   |
|                              |           |                                  |                                                                                        |                                             | 2. Start a multipart hash operation                                                                              | 2. MD4                                                                                   |   |
|                              |           |                                  |                                                                                        |                                             | 3. Add a message fragment to a multipart hash operation                                                          | 3. MD5                                                                                   |   |
|                              |           |                                  |                                                                                        |                                             | 4. Abort the hash operation                                                                                      | 4. RIPEMD160                                                                             |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 5. SHA1                                                                                  |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 6. SHA224                                                                                |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 7. SHA256                                                                                |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 8. SHA384                                                                                |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 9. SHA512                                                                                |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_BAD_STATE                         | 1. Calling this function without calling the psa_hash_setup() should return error                                | Operation handle without setup                                                           |   |
|                              |           |                                  |                                                                                        |                                             | 2. Calling this function with completed operation handle should return error                                     | Completed operation handle                                                               |   |
| Message Digests              | test_c013 | psa_hash_verify                  | Finish the calculation of the hash of a message and compare it with an expected value. | PSA_SUCCESS                                 | 1. Initialize the PSA crypto library                                                                             | 1. MD2                                                                                   |   |
|                              |           |                                  |                                                                                        |                                             | 2. Start a multipart hash operation                                                                              | 2. MD4                                                                                   |   |
|                              |           |                                  |                                                                                        |                                             | 3. Add a message fragment to a multipart hash operation                                                          | 3. MD5                                                                                   |   |
|                              |           |                                  |                                                                                        |                                             | 4. Finish the calculation of the hash of a message and compare it with an expected value                         | 4. RIPEMD160                                                                             |   |
|                              |           |                                  |                                                                                        |                                             | 5. Abort the hash operation                                                                                      | 5. SHA1                                                                                  |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 6. SHA224                                                                                |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 7. SHA256                                                                                |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 8. SHA384                                                                                |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 9. SHA512                                                                                |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_BAD_STATE                         | Calling this function with inactive operation handle should return error                                         | 1. Inactive operation handle                                                             |   |
|                              |           |                                  |                                                                                        |                                             | Calling this function with invalid operation handle should return error                                          | 2. Invalid operation handle                                                              |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_INVALID_SIGNATURE                 | Calling this function with incorrect expected value should return error                                          | 1. Incorrect expected hash value                                                         |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 2. Incorrect expected hash length                                                        |   |
| Message Digests              | test_c014 | psa_hash_finish                  | Finish the calculation of the hash of a message.                                       | PSA_SUCCESS                                 | 1. Initialize the PSA crypto library                                                                             | 1. MD2                                                                                   |   |
|                              |           |                                  |                                                                                        |                                             | 2. Start a multipart hash operation                                                                              | 2. MD4                                                                                   |   |
|                              |           |                                  |                                                                                        |                                             | 3. Add a message fragment to a multipart hash operation                                                          | 3. MD5                                                                                   |   |
|                              |           |                                  |                                                                                        |                                             | 4. Finish the calculation of the hash of a message                                                               | 4. RIPEMD160                                                                             |   |
|                              |           |                                  |                                                                                        |                                             | 5. Compare it with the expected value                                                                            | 5. SHA1                                                                                  |   |
|                              |           |                                  |                                                                                        |                                             | 6. Abort the hash operation                                                                                      | 6. SHA224                                                                                |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 7. SHA256                                                                                |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 8. SHA384                                                                                |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 9. SHA512                                                                                |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_INVALID_ARGUMENT                  | Calling this function with an inactive operation handle should return error                                      | Inactive operation handle                                                                |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_BUFFER_TOO_SMALL                  | Calling this function with a hash buffer whose size is less than the algorithm output should return error        | Buffer size less than required                                                           |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_BAD_STATE                         | Calling this function with completed operation handle                                                            | completed operation handle                                                               |   |
| Message Digests              | test_c015 | psa_hash_abort                   | Abort a hash operation.                                                                | PSA_SUCCESS                                 | 1. Initialize the PSA crypto library                                                                             | 1. MD2                                                                                   |   |
|                              |           |                                  |                                                                                        |                                             | 2. Start a multipart hash operation                                                                              | 2. MD4                                                                                   |   |
|                              |           |                                  |                                                                                        |                                             | 3. Abort a hash operation                                                                                        | 3. MD5                                                                                   |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 4. RIPEMD160                                                                             |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 5. SHA1                                                                                  |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 6. SHA224                                                                                |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 7. SHA256                                                                                |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 8. SHA384                                                                                |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 9. SHA512                                                                                |   |
| Generation                   | test_c016 | psa_generate_key                 | Generate a key or key pair                                                             | PSA_SUCCESS                                 | 1. Initialize the PSA crypto library                                                                             | 1. AES                                                                                   |   |
|                              |           |                                  |                                                                                        |                                             | 2. Setup the attributes for the key                                                                              | 2. DES                                                                                   |   |
|                              |           |                                  |                                                                                        |                                             | 3. Generate a key or key pair                                                                                    | 3. ECC                                                                                   |   |
|                              |           |                                  |                                                                                        |                                             | 4. Get basic metadata about a key                                                                                | 4. RSA                                                                                   |   |
|                              |           |                                  |                                                                                        |                                             | 5. Check if key type and key length matches                                                                      |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 6. Export a key in binary format                                                                                 |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 7. Check if the metadata matches                                                                                 |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 8. Reset and destroy the key                                                                                     |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  |                                                                                          |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_INVALID_ARGUMENT                  | Calling this function with invalid usage flags                                                                   | invalid usage flags                                                                      |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_ALREADY_EXISTS                    | Calling this function with pre-occupied key slot should return this error                                        | Pre-occupied key slot                                                                    |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_NOT_SUPPORTED                     | Calling this function to generate only public key should return this error                                       | 1. Key type as public key                                                                |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 2. Invalid key type                                                                      |   |
| Generation                   | test_c017 | psa_generate_random              | Generate random bytes                                                                  | PSA_SUCCESS                                 | 1. Initialize the PSA crypto library                                                                             | 1. 16 Byte data                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 2. Generate random bytes Run several times to ensure that every output byte will be nonzero at least once        | 2. 24 Byte data                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 3. Check that no more than bytes have been overwritten                                                           | 3. 32 Byte data                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 4. Check that every byte was changed to nonzero at least once.                                                   | 4. 64 Byte data                                                                          |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 5. 128 Byte data                                                                         |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 6. 256 Byte data                                                                         |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 7. 512 Byte data                                                                         |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 8. 1000 Byte data                                                                        |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 9. 1024 Byte data                                                                        |   |
| Key Derivation               | test_c018 | psa_key_derivation_input_key     | Provide an input for key derivation in the form of a key                               | PSA_SUCCESS                                 | 1. Initialize the PSA crypto library                                                                             | 1. 16 Byte key                                                                           |   |
|                              |           |                                  |                                                                                        |                                             | 2. Setup the attributes for the key                                                                              |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 3. Import the key data into the key slot                                                                         |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 4. Set up a key derivation operation                                                                             |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 5. Provide an input for key derivation or key agreement                                                          |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 6. Abort the key derivation operation                                                                            |                                                                                          |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_NOT_PERMITTED                     | Calling this function with incorrect data                                                                        | 1. Invalid usage                                                                         |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 2. Incorrect key algorithm                                                               |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_INVALID_ARGUMENT                  | Calling this function with invalid parameter should return this error                                            | 1. Step as label                                                                         |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 2. Step as info                                                                          |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 3. Step as seed                                                                          |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 4. Step as salt                                                                          |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 5. Input key type as AES (not derive)                                                    |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 6. Key type a RSA public key                                                             |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 7. Key type as RSA Keypair                                                               |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_INVALID_HANDLE                    | Calling this function with destroyed key handle                                                                  | 1. No key in slot                                                                        |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_BAD_STATE                         | Calling this function without setup should return this error                                                     |                                                                                          |   |
| Key Derivation               | test_c019 | psa_key_derivation_key_agreement | Perform a key agreement and use the shared secret as input to a key derivation         | PSA_SUCCESS                                 | 1. Initialize the PSA crypto library                                                                             | 1. ECDH SECP256R1                                                                        |   |
|                              |           |                                  |                                                                                        |                                             | 2. Setup the attributes for the key                                                                              | 2. ECDH SECP384R1                                                                        |   |
|                              |           |                                  |                                                                                        |                                             | 3. Import the key data into the key slot                                                                         |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 4. Set up a key agreement operation                                                                              |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 5. Perform a key agreement                                                                                       |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 6. Abort                                                                                                         |                                                                                          |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_INVALID_ARGUMENT                  | Calling this function with invalid parameter should return this error                                            | 1. Invalid step                                                                          |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 2. Invalid usage                                                                         |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 3. KDF instead of a key agreement algorithm                                              |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 4. Public key on different curve                                                         |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 5. Public key instead of private key                                                     |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_INVALID_HANDLE                    |                                                                                                                  | 1. Zero as key slot                                                                      |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 2. Empty key handle                                                                      |   |
| Key Derivation               | test_c020 | psa_key_derivation_output_bytes  | Read some data from a key derivation operation                                         | PSA_SUCCESS                                 | 1. Initialize the PSA crypto library                                                                             | 1. Key                                                                                   |   |
|                              |           |                                  |                                                                                        |                                             | 2. Setup the attributes for the key                                                                              | 2. Info                                                                                  |   |
|                              |           |                                  |                                                                                        |                                             | 3. Import the key if the derivation input is key                                                                 |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 4. Set up a key derivation operation                                                                             |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 5. Set the capacity for the generator                                                                            |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 6. Provide input as key or data depending on the step                                                            |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 7. Read some data from a key derivation operation                                                                |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 8. Abort the derivation operation                                                                                |                                                                                          |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_BAD_STATE                         | Calling this function with only supportive step                                                                  | 1. Salt                                                                                  |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 2. Label                                                                                 |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 3. Seed                                                                                  |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 4. Aborted operation                                                                     |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_INSUFFICIENT_DATA                 | Calling this function when there are no capacity                                                                 | 1. Requesting greater capacity than available                                            |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 2. No data available in the operation                                                    |   |
| Key Derivation               | test_c021 | psa_key_derivation_output_key    | Derive a key from an ongoing key derivation operation                                  | PSA_SUCCESS                                 | 1. Initialize the PSA crypto library                                                                             | 1. Key                                                                                   |   |
|                              |           |                                  |                                                                                        |                                             | 2. Setup the attributes for the key                                                                              | 2. Indo                                                                                  |   |
|                              |           |                                  |                                                                                        |                                             | 3. Import the key if the derivation input is key                                                                 | 3. Label                                                                                 |   |
|                              |           |                                  |                                                                                        |                                             | 4. Set up a key derivation operation                                                                             | 4. Seed                                                                                  |   |
|                              |           |                                  |                                                                                        |                                             | 5. Set the capacity for the generator                                                                            | 5. Salt                                                                                  |   |
|                              |           |                                  |                                                                                        |                                             | 6. Provide input as key or data depending on the step                                                            | 6. DES key export                                                                        |   |
|                              |           |                                  |                                                                                        |                                             | 7. Setup the attributes for the new key                                                                          | 7. ECC keypair                                                                           |   |
|                              |           |                                  |                                                                                        |                                             | 8. Derive a key from an ongoing key derivation operation                                                         | 9. RSA keypair                                                                           |   |
|                              |           |                                  |                                                                                        |                                             | 9. Abort the derivation operation                                                                                |                                                                                          |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_INSUFFICIENT_DATA                 | Calling this function with insufficient data                                                                     | 1. Requesting greater capacity than available                                            |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 2. No data available in the operation                                                    |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_BAD_STATE                         | Calling this function on an aborted operation shoukd return this error                                           | Aborted operation                                                                        |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_NOT_SUPPORTED                     | Generating public key                                                                                            | 1. RSA public key                                                                        |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 2. ECC public key                                                                        |   |
| Key Derivation               | test_c022 | psa_key_derivation_abort         | Abort a key derivation operation                                                       | PSA_SUCCESS                                 | 1. Initialize the PSA crypto library                                                                             |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 2. Abort the key derivation operation for the different types of initialization                                  |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 3. Read some data from a key derivation operation with no data in the operation                                  |                                                                                          |   |
| Key Derivation               | test_c023 | psa_key_derivation_set_capacity  | Set the maximum capacity of a key derivation operation                                 | PSA_SUCCESS                                 | 1. Initialize the PSA crypto library                                                                             | 1. Less than operation's capacity                                                        |   |
|                              |           | psa_key_derivation_get_capacity  | Retrieve the current capacity of a key derivation operation                            |                                             | 2. Start the key derivation operation                                                                            | 2. Equal to operation's capacity                                                         |   |
|                              |           |                                  |                                                                                        |                                             | 3. Set the capacity for the generator                                                                            |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 4. Get the capacity for the generator                                                                            |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 5. Check if the capacity as per the expected value                                                               |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 6. Abort the operation                                                                                           |                                                                                          |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_INVALID_ARGUMENT                  | Calling this function with invalid parameter should return this error                                            | More than operation's capacity                                                           |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_BAD_STATE                         | Calling this function on an aborted operation shoukd return this error                                           | 1. Get capacity on an aborted operation                                                  |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 2. Set capacity on an aborted operation                                                  |   |
| AEAD                         | test_c024 | psa_aead_encrypt                 | Process an authenticated encryption operation                                          | PSA_SUCCESS                                 | 1. Initialize the PSA crypto library                                                                             | 1. CCM - 16B AES - 13B Nounce & 8B addi data                                             |   |
|                              |           |                                  |                                                                                        |                                             | 2. Setup the attributes for the key                                                                              | 2. AES-CCM                                                                               |   |
|                              |           |                                  |                                                                                        |                                             | 3. Import the key data into the key slot                                                                         | 3. AES-CCM 24 bytes Tag length = 4                                                       |   |
|                              |           |                                  |                                                                                        |                                             | 4. Call aead encrypt                                                                                             | 4. GCM - 16B AES - 12B Nounce & 12B addi data                                            |   |
|                              |           |                                  |                                                                                        |                                             | 5. Check if the status is expected                                                                               | 5                                                                                        |   |
|                              |           |                                  |                                                                                        |                                             | 6. Check if the cipher text and length is as expected                                                            |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 7. Destroy and reset the key                                                                                     |                                                                                          |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_NOT_SUPPORTED                     |                                                                                                                  | 1. DES key                                                                               |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 2. Unsupported algorithm                                                                 |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_INVALID_HANDLE                    |                                                                                                                  | Operation on a destroyed key handle                                                      |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_NOT_PERMITTED                     |                                                                                                                  | 1. Small output buffer size                                                              |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 2. Invalid key usage                                                                     |   |
| AEAD                         | test_c025 | psa_aead_decrypt                 | Process an authenticated decryption operation                                          | PSA_SUCCESS                                 | 1. Initialize the PSA crypto library                                                                             | 1. GCM -16B AES - 12B Nounce & 12B addi data                                             |   |
|                              |           |                                  |                                                                                        |                                             | 2. Setup the attributes for the key                                                                              | 2. CCM - 16B AES - 13B Nounce & 8B addi data                                             |   |
|                              |           |                                  |                                                                                        |                                             | 3. Import the key data into the key slot                                                                         | 3. AES CCM                                                                               |   |
|                              |           |                                  |                                                                                        |                                             | 4. Call aead decrypt                                                                                             | 4. AES-CCM 24 bytes Tag length = 4                                                       |   |
|                              |           |                                  |                                                                                        |                                             | 5. Check if the status is expected                                                                               |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 6. Check if the cipher text and length is as expected                                                            |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 7. Destroy and reset the key                                                                                     |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  |                                                                                          |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_NOT_SUPPORTED                     |                                                                                                                  | 1. DES key                                                                               |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 2. Unsupported algorithm                                                                 |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_BUFFER_TOO_SMALL                  |                                                                                                                  | Small output buffer size                                                                 |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_INVALID_ARGUMENT                  |                                                                                                                  | Invalid tag length                                                                       |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_INVALID_HANDLE                    |                                                                                                                  | Destroyed key handle                                                                     |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_NOT_PERMITTED                     |                                                                                                                  | Invalid key usage                                                                        |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_INVALID_SIGNATURE                 |                                                                                                                  | 1. Invalid cipher text                                                                   |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 2. Invalid cipher text size                                                              |   |
| Message Authentication Codes | test_c026 | psa_mac_sign_setup               | Start a multipart MAC calculation operation                                            | PSA_SUCCESS                                 | 1. Initialize the PSA crypto library                                                                             | 1. 64 Byte HMAC                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 2. Setup the attributes for the key                                                                              | 2. 16 Byte AES - CMAC                                                                    |   |
|                              |           |                                  |                                                                                        |                                             | 3. Import the key data into the key slot                                                                         |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 4. Start a multipart MAC calculation operation                                                                   |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 5. Abort the MAC operation                                                                                       |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 6. Destroy the key                                                                                               |                                                                                          |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_NOT_SUPPORTED                     |                                                                                                                  | 1. 16 Byte AES - GMAC                                                                    |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 2. Incompatible HMAC for CMAC                                                            |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 3. Bad algorithm (unknown MAC algorithm)                                                 |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 4. Truncated MAC too small                                                               |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_NOT_PERMITTED                     |                                                                                                                  | Invalid usage                                                                            |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_INVALID_ARGUMENT                  |                                                                                                                  | 1. Invalid key type                                                                      |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 2. Truncated MAC too large                                                               |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 3. Bad algorithm (not a MAC algorithm)                                                   |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_INVALID_HANDLE                    |                                                                                                                  | 1. Invalid key handle                                                                    |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 2. Zero as key handle                                                                    |   |
| Message Authentication Codes | test_c027 | psa_mac_update                   | Add a message fragment to a multipart MAC operation                                    | PSA_SUCCESS                                 | 1. Initialize the PSA crypto library                                                                             | 1.64 Byte HMAC SHA256                                                                    |   |
|                              |           |                                  |                                                                                        |                                             | 2. Setup the attributes for the key                                                                              | 2. 16 Byte AES - CMAC                                                                    |   |
|                              |           |                                  |                                                                                        |                                             | 3. Import the key data into the key slot                                                                         | 3. 32 Byte HMAC SHA512                                                                   |   |
|                              |           |                                  |                                                                                        |                                             | 4. Start a multipart MAC calculation operation                                                                   |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 5. Add a message fragment to a multipart MAC operation                                                           |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 6. Finish the calculation of the MAC of a message                                                                |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 7. Abort a MAC operation                                                                                         |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 8. Destroy the key                                                                                               |                                                                                          |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_BAD_STATE                         |                                                                                                                  | 1. Completed operation as input                                                          |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 2. Uninitialized operation as input                                                      |   |
| Message Authentication Codes | test_c028 | psa_mac_sign_finish              | Finish the calculation of the MAC of a message                                         | PSA_SUCCESS                                 | 1. Initialize the PSA crypto library                                                                             | 1. HMAC SHA 224                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 2. Setup the attributes for the key                                                                              | 2. HMAC SHA 256                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 3. Import the key data into the key slot                                                                         | 3. HMAC SHA 512                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 4. Start a multipart MAC calculation operation                                                                   | 4. HMAC SHA 224 (truncated to 8 Byte)                                                    |   |
|                              |           |                                  |                                                                                        |                                             | 5. Add a message fragment to a multipart MAC operation                                                           | 5. CMAC AES 128                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 6. Finish the calculation of the MAC of a message                                                                |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 7.  Check if the MAC length matches with the expected length                                                     |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 8. Check if the MAC data matches with the expected data                                                          |                                                                                          |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_BUFFER_TOO_SMALL                  |                                                                                                                  | Small size buffer                                                                        |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_BAD_STATE                         | Finish the calculation of the MAC of a message using same operation should return error                          | Aborted operation as input                                                               |   |
| Message Authentication Codes | test_c029 | psa_mac_verify_setup             |                                                                                        | PSA_SUCCESS                                 | 1. Initialize the PSA crypto library                                                                             | 1. 64 Byte HMAC                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 2. Setup the attributes for the key                                                                              | 2. 16 Byte AES - CMAC                                                                    |   |
|                              |           |                                  |                                                                                        |                                             | 3. Import the key data into the key slot                                                                         |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 4. Start a multipart MAC calculation operation                                                                   |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 5. Abort the MAC operation                                                                                       |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 6. Destroy the key                                                                                               |                                                                                          |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_NOT_SUPPORTED                     |                                                                                                                  | 1. 16 Byte AES - GMAC                                                                    |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 2. Incompatible HMAC for CMAC                                                            |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 3. Bad algorithm (unknown MAC algorithm)                                                 |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 4. Truncated MAC too small                                                               |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_NOT_PERMITTED                     |                                                                                                                  | Invalid usage                                                                            |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_INVALID_ARGUMENT                  |                                                                                                                  | 1. Invalid key type                                                                      |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 2. Truncated MAC too large                                                               |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 3. Bad algorithm (unknown MAC algorithm)                                                 |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_INVALID_HANDLE                    |                                                                                                                  | 1. Invalid key handle                                                                    |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 2. Zero as key handle                                                                    |   |
| Message Authentication Codes | test_c030 | psa_mac_verify_finish            | Finish the calculation of the MAC of a message and compare it with an expected value   | PSA_SUCCESS                                 | 1. Initialize the PSA crypto library                                                                             | 1. HMAC SHA 224                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 2. Setup the attributes for the key                                                                              | 2. HMAC SHA 256                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 3. Import the key data into the key slot                                                                         | 3. HMAC SHA 512                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 4. Start a multipart MAC calculation operation                                                                   | 4. HMAC SHA 224 (truncated to 8 Byte)                                                    |   |
|                              |           |                                  |                                                                                        |                                             | 5. Add a message fragment to a multipart MAC operation                                                           | 5. CMAC AES 128                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 6. Finish the calculation of the MAC of a message and compare with expected value                                |                                                                                          |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_INVALID_SIGNATURE                 |                                                                                                                  | 1. Small size buffer                                                                     |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 2. Incorrect expected hash                                                               |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_BAD_STATE                         |                                                                                                                  | Invalid operation as input                                                               |   |
| Message Authentication Codes | test_c031 | psa_mac_abort                    | Abort a MAC operation                                                                  | PSA_SUCCESS                                 | 1. Initialize the PSA crypto library                                                                             | 1. HMAC SHA 224                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 2. Setup the attributes for the key                                                                              | 2. HMAC SHA 256                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 3. Import the key data into the key slot                                                                         | 3. HMAC SHA 512                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 4. Start a multipart MAC calculation operation                                                                   | 4. CMAC AES 128                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 5. Abort the MAC operation                                                                                       | 5. HMAC truncated                                                                        |   |
|                              |           |                                  |                                                                                        |                                             | 6. Destroy the key                                                                                               | 6. Multiple abort                                                                        |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 7. psa_mac_finish after psa_mac_abort should return failure                              |   |
| Symmetric Ciphers            | test_c032 | psa_cipher_encrypt_setup         | Set the key for a multipart symmetric encryption operation                             | PSA_SUCCESS                                 | 1. Initialize the PSA crypto library                                                                             | 1. 16 Byte AES                                                                           |   |
|                              |           |                                  |                                                                                        |                                             | 2. Setup the attributes for the key                                                                              | 2. 24 Byte AES                                                                           |   |
|                              |           |                                  |                                                                                        |                                             | 3. Import the key data into the key slot                                                                         | 3. 32 Byte AES                                                                           |   |
|                              |           |                                  |                                                                                        |                                             | 4. Set the key for a multipart symmetric encryption operation                                                    | 4. DES 64 bit key                                                                        |   |
|                              |           |                                  |                                                                                        |                                             | 5. Reset and destroy the key                                                                                     | 5. Triple DES 2-Key                                                                      |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 6. Triple DES 3-Key                                                                      |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_NOT_SUPPORTED                     |                                                                                                                  | 1. 16 Byte raw data                                                                      |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 2. Unknown cipher algorithm                                                              |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 3. Incompatible key ARC4                                                                 |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_INVALID_ARGUMENT                  |                                                                                                                  | 1. Not a cipher algorithm                                                                |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 2. RSA public key                                                                        |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 3. RSA keypair                                                                           |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 4. EC Public key                                                                         |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 5. EC keypair                                                                            |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_NOT_PERMITTED                     |                                                                                                                  | Incorrect usage                                                                          |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_INVALID_HANDLE                    |                                                                                                                  | 1. Unallocated key handle                                                                |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 2. Zero as key handle                                                                    |   |
| Symmetric Ciphers            | test_c033 | psa_cipher_decrypt_setup         | Set the key for a multipart symmetric decryption operation                             | PSA_SUCCESS                                 | 1. Initialize the PSA crypto library                                                                             | 1. 16 Byte AES                                                                           |   |
|                              |           |                                  |                                                                                        |                                             | 2. Setup the attributes for the key                                                                              | 2. 24 Byte AES                                                                           |   |
|                              |           |                                  |                                                                                        |                                             | 3. Import the key data into the key slot                                                                         | 3. 32 Byte AES                                                                           |   |
|                              |           |                                  |                                                                                        |                                             | 4. Set the key for a multipart symmetric decryption operation                                                    | 4. DES 64 bit key                                                                        |   |
|                              |           |                                  |                                                                                        |                                             | 5. Reset and destroy the key                                                                                     | 5. Triple DES 2-Key                                                                      |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 6. Triple DES 3-Key                                                                      |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_NOT_SUPPORTED                     |                                                                                                                  | 1. 16 Byte raw data                                                                      |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 2. Unknown cipher algorithm                                                              |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 3. Incompatible key ARC4                                                                 |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_INVALID_ARGUMENT                  |                                                                                                                  | 1. Not a cipher algorithm                                                                |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 2. RSA public key                                                                        |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 3. RSA keypair                                                                           |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 4. EC Public key                                                                         |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 5. EC keypair                                                                            |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_INVALID_HANDLE                    |                                                                                                                  | 1. Unallocated key handle                                                                |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 2. Zero as key handle                                                                    |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_NOT_PERMITTED                     |                                                                                                                  | Invalid usage                                                                            |   |
| Symmetric Ciphers            | test_c034 | psa_cipher_generate_iv           | Generate an IV for a symmetric encryption operation                                    | PSA_SUCCESS                                 | 1. Initialize the PSA crypto library                                                                             | 1. 16 Byte AES                                                                           |   |
|                              |           |                                  |                                                                                        |                                             | 2. Setup the attributes for the key                                                                              | 2. 24 Byte AES                                                                           |   |
|                              |           |                                  |                                                                                        |                                             | 3. Import the key data into the key slot                                                                         | 3. 32 Byte AES                                                                           |   |
|                              |           |                                  |                                                                                        |                                             | 4. Set the key for a multipart symmetric decryption operation                                                    | 4. DES 64 bit key                                                                        |   |
|                              |           |                                  |                                                                                        |                                             | 5. Generate an IV for a symmetric encryption operation                                                           | 5. Triple DES 2-Key                                                                      |   |
|                              |           |                                  |                                                                                        |                                             | 6. Check that if generated iv length match the expected length                                                   | 6. Triple DES 3-Key                                                                      |   |
|                              |           |                                  |                                                                                        |                                             | 7. Check that if generated iv are not zero                                                                       | 7. AES - large iv buffer                                                                 |   |
|                              |           |                                  |                                                                                        |                                             | 8. Reset and destroy the key                                                                                     | 8. DES - large iv buffer                                                                 |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_BUFFER_TOO_SMALL                  |                                                                                                                  | 1. AES - small iv buffer                                                                 |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 2. DES - small iv buffer                                                                 |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_BAD_STATE                         |                                                                                                                  | 1. Completed operation handle                                                            |   |
| Symmetric Ciphers            | test_c035 | psa_cipher_set_iv                | Set the IV for a symmetric encryption or decryption operation                          | PSA_SUCCESS                                 | 1. Initialize the PSA crypto library                                                                             | 1. 16 Byte AES                                                                           |   |
|                              |           |                                  |                                                                                        |                                             | 2. Setup the attributes for the key                                                                              | 2. 24 Byte AES                                                                           |   |
|                              |           |                                  |                                                                                        |                                             | 3. Import the key data into the key slot                                                                         | 3. 32 Byte AES                                                                           |   |
|                              |           |                                  |                                                                                        |                                             | 4. Set the key for a multipart symmetric encryption/decryption operation                                         | 4. DES 64 bit key                                                                        |   |
|                              |           |                                  |                                                                                        |                                             | 5. Set an IV for a symmetric encryption/decryption operation                                                     | 5. Triple DES 2-Key                                                                      |   |
|                              |           |                                  |                                                                                        |                                             | 6. Reset and destroy the key                                                                                     | 6. Triple DES 3-Key                                                                      |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_INVALID_ARGUMENT                  |                                                                                                                  | 1. AES - small iv buffer                                                                 |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 2. DES - small iv buffer                                                                 |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 3. AES - large iv buffer                                                                 |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 4. DES - large iv buffer                                                                 |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_BAD_STATE                         | Setting an IV for a symmetric encryption/decryption operation using the same operator should fail                | 1. Completed operation handle                                                            |   |
| Symmetric Ciphers            | test_c036 | psa_cipher_update                | Encrypt or decrypt a message fragment in an active cipher operation                    | PSA_SUCCESS                                 | 1. Initialize the PSA crypto library                                                                             | 1. AES CBC_NO_PADDING                                                                    |   |
|                              |           |                                  |                                                                                        |                                             | 2. Setup the attributes for the key                                                                              | 2. AES CBC_NO_PADDING (Short input)                                                      |   |
|                              |           |                                  |                                                                                        |                                             | 3. Import the key data into the key slot                                                                         | 3. AES CBC_PKCS7                                                                         |   |
|                              |           |                                  |                                                                                        |                                             | 4. Set the key for a multipart symmetric encryption operation                                                    | 4. AES CBC_PKCS7 (Short input)                                                           |   |
|                              |           |                                  |                                                                                        |                                             | 5. Set an IV for a symmetric encryption operation                                                                | 5. AES CTR                                                                               |   |
|                              |           |                                  |                                                                                        |                                             | 6. Encrypt or decrypt a message fragment in an active cipher operation                                           | 6. DES CBC (nopad)                                                                       |   |
|                              |           |                                  |                                                                                        |                                             | 7. Check if the output length matches the expected length                                                        | 7. 2-key 3DE -CBC (nopad)                                                                |   |
|                              |           |                                  |                                                                                        |                                             | 8. Check if the output data matches the expected data                                                            | 8. 3-key 3DE -CBC (nopad)                                                                |   |
|                              |           |                                  |                                                                                        |                                             | 9. Reset and destroy the key                                                                                     |                                                                                          |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_BAD_STATE                         | Encrypt or decrypt a message fragment in an invalid cipher operation should fail                                 | Invalid operation as input                                                               |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_BUFFER_TOO_SMALL                  |                                                                                                                  | Small output buffer size                                                                 |   |
| Symmetric Ciphers            | test_c037 | psa_cipher_finish                | Finish encrypting or decrypting a message in a cipher operation                        | PSA_SUCCESS                                 | 1. Initialize the PSA crypto library                                                                             | 1. AES CBC_NO_PADDING                                                                    |   |
|                              |           |                                  |                                                                                        |                                             | 2. Setup the attributes for the key                                                                              | 2. AES CBC_PKCS7                                                                         |   |
|                              |           |                                  |                                                                                        |                                             | 3. Import the key data into the key slot                                                                         | 3. AES CBC_PKCS7 (Short input)                                                           |   |
|                              |           |                                  |                                                                                        |                                             | 4. Set the key for a multipart symmetric encryption operation                                                    | 4. AES CTR                                                                               |   |
|                              |           |                                  |                                                                                        |                                             | 5. Set an IV for a symmetric encryption operation                                                                | 5. DES CBC (nopad)                                                                       |   |
|                              |           |                                  |                                                                                        |                                             | 6. Encrypt or decrypt a message fragment in an active cipher operation                                           | 6. 2-key 3DE -CBC (nopad)                                                                |   |
|                              |           |                                  |                                                                                        |                                             | 7. Finish encrypting or decrypting a message in a cipher operation                                               | 7. 3-key 3DE -CBC (nopad)                                                                |   |
|                              |           |                                  |                                                                                        |                                             | 8. Check if the output length matches the expected length                                                        |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 9. Check if the output data matches the expected data                                                            |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 10. Reset and destroy the key                                                                                    |                                                                                          |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_BAD_STATE                         | Encrypt or decrypt a message fragment in an invalid cipher operation should fail                                 | Invalid operation as input                                                               |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_BUFFER_TOO_SMALL                  |                                                                                                                  | Small output buffer size                                                                 |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_INVALID_ARGUMENT                  |                                                                                                                  | AES CBC_NO_PADDING (Short input)                                                         |   |
| Symmetric Ciphers            | test_c038 | psa_cipher_abort                 | Abort a cipher operation                                                               | PSA_SUCCESS                                 | 1. Initialize the PSA crypto library                                                                             | 1. Encrypt - AES CBC_NO_PADDING                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 2. Setup the attributes for the key                                                                              | 2. Encrypt - AES CBC_PKCS7                                                               |   |
|                              |           |                                  |                                                                                        |                                             | 3. Import the key data into the key slot                                                                         | 3. Encrypt - AES CTR                                                                     |   |
|                              |           |                                  |                                                                                        |                                             | 4. Set the key for a multipart symmetric encryption/decryption operation                                         | 4. Encrypt - DES CBC (nopad)                                                             |   |
|                              |           |                                  |                                                                                        |                                             | 5. Abort a cipher operation                                                                                      | 5. Encrypt - 2-key 3DE -CBC (nopad)                                                      |   |
|                              |           |                                  |                                                                                        |                                             | 6. Multiple abort cipher operation should return success                                                         | 6. Encrypt - 3-key 3DE -CBC (nopad)                                                      |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 7. Decrypt - AES CBC_NO_PADDING                                                          |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 8. Decrypt - AES CBC_PKCS7                                                               |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 9. Decrypt - AES CTR                                                                     |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 10. Decrypt - DES CBC (nopad)                                                            |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 11. Decrypt - 2-key 3DE -CBC (nopad)                                                     |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 12. Decrypt - 3-key 3DE -CBC (nopad)                                                     |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 13. psa_cipher_update after psa_cipher_abort should fail                                 |   |
| Asymmetric Cryptography      | test_c039 | psa_asymmetric_encrypt           | Encrypt a short message with a public key                                              | PSA_SUCCESS                                 | 1. Initialize the PSA crypto library                                                                             | 1. RSA PKCS1V15                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 2. Setup the attributes for the key                                                                              | 2. RSA OAEP SHA256                                                                       |   |
|                              |           |                                  |                                                                                        |                                             | 3. Import the key data into the key slot                                                                         | 3. RSA OAEP SHA256 with label                                                            |   |
|                              |           |                                  |                                                                                        |                                             | 4. Encrypt a short message with a public key                                                                     | 4. RSA KEYPAIR PKCS1V15                                                                  |   |
|                              |           |                                  |                                                                                        |                                             | 5. Check if the output length matches with the expected output length                                            |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 6. Decrypt the cipher text                                                                                       |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 7. Check if the output length matches with the input length                                                      |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 8. Check if the output matches with the given input data                                                         |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 9. Reset and destroy the key                                                                                     |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  |                                                                                          |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_INVALID_ARGUMENT                  |                                                                                                                  | 1. Invalid key type                                                                      |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 2. Invalid algorithm                                                                     |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_NOT_PERMITTED                     |                                                                                                                  | Invalid usage                                                                            |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_BUFFER_TOO_SMALL                  |                                                                                                                  | Small output buffer                                                                      |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_INVALID_HANDLE                    |                                                                                                                  | 1. Invalid handle                                                                        |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 2. Zero as key handle                                                                    |   |
| Asymmetric Cryptography      | test_c040 | psa_asymmetric_decrypt           | Decrypt a short message with a private key                                             | PSA_SUCCESS                                 | 1. Initialize the PSA crypto library                                                                             | 1. RSA KEYPAIR PKCS1V15                                                                  |   |
|                              |           |                                  |                                                                                        |                                             | 2. Setup the attributes for the key                                                                              | 2. RSA KEYPAIR OAEP SHA256                                                               |   |
|                              |           |                                  |                                                                                        |                                             | 3. Import the key data into the key slot                                                                         | 3. RSA KEYPAIR OAEP SHA256 with label                                                    |   |
|                              |           |                                  |                                                                                        |                                             | 4. Decrypt a short message with a private key                                                                    |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 5. Check if the output length matches with the expected length                                                   |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 6. Check if the output matches with the expected data                                                            |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 7. Reset and destroy the key                                                                                     |                                                                                          |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_INVALID_ARGUMENT+E524             |                                                                                                                  | 1. Invalid key type (RSA public key)                                                     |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 2. Invalid algorithm                                                                     |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 3. Invalid key type (AES Key)                                                            |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_DOES_NOT_EXIST                    |                                                                                                                  | Empty key slot                                                                           |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_NOT_PERMITTED                     |                                                                                                                  | Invalid usage                                                                            |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_INVALID_HANDLE                    |                                                                                                                  | Uninitialized key handle                                                                 |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_BUFFER_TOO_SMALL                  |                                                                                                                  | Small output buffer                                                                      |   |
| Asymmetric Cryptography      | test_c041 | psa_asymmetric_sign              | Sign a hash or short message with a private key                                        | PSA_SUCCESS                                 | 1. Initialize the PSA crypto library                                                                             | 1. RSA KEYPAIR PKCS1V15 RAW                                                              |   |
|                              |           |                                  |                                                                                        |                                             | 2. Setup the attributes for the key                                                                              | 2. RSA KEYPAIR PKCS1V15 SHA-256                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 3. Import the key data into the key slot                                                                         | 3. ECDSA KEYPAIR SECP256R1 SHA-256                                                       |   |
|                              |           |                                  |                                                                                        |                                             | 4. Sign a hash or short message with a private key                                                               |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 4. Check if the output length matches with the expected length                                                   |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 5. Check if the output matches with the expected data                                                            |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 6. Reset and destroy the key                                                                                     |                                                                                          |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_INVALID_ARGUMENT                  |                                                                                                                  | 1. Invalid key type (RSA public key)                                                     |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 2. Invalid algorithm                                                                     |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 3. Invalid key type (AES Key)                                                            |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 4. Wrong hash size                                                                       |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_INVALID_HANDLE                    |                                                                                                                  | Uninitialized key handle                                                                 |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_DOES_NOT_EXIST                    |                                                                                                                  | Empty key slot                                                                           |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_NOT_PERMITTED                     |                                                                                                                  | Invalid usage                                                                            |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_BUFFER_TOO_SMALL                  |                                                                                                                  | Small output buffer                                                                      |   |
| Asymmetric Cryptography      | test_c042 | psa_asymmetric_verify            | Verify the signature a hash or short message using a public key                        | PSA_SUCCESS                                 | 1. Initialize the PSA crypto library                                                                             | 1. RSA KEYPAIR PKCS1V15 RAW                                                              |   |
|                              |           |                                  |                                                                                        |                                             | 2. Setup the attributes for the key                                                                              | 2. RSA KEYPAIR PKCS1V15 SHA-256                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 3. Import the key data into the key slot                                                                         | 3. ECDSA KEYPAIR SECP256R1 SHA-256                                                       |   |
|                              |           |                                  |                                                                                        |                                             | 4. Verify the signature a hash or short message using a public key                                               | 4. RSA public key                                                                        |   |
|                              |           |                                  |                                                                                        |                                             | 5. Reset and destroy the key                                                                                     | 5. EC public key                                                                         |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_INVALID_ARGUMENT                  |                                                                                                                  | 1. Invalid algorithm                                                                     |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 2. Wrong hash size                                                                       |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_INVALID_HANDLE                    |                                                                                                                  |                                                                                          |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_INVALID_SIGNATURE                 |                                                                                                                  | Wrong signature size                                                                     |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | Wrong signature                                                                          |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_DOES_NOT_EXIST                    |                                                                                                                  | Empty key slot                                                                           |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_NOT_PERMITTED                     |                                                                                                                  | Invalid usage                                                                            |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_NOT_SUPPORTED                     |                                                                                                                  | Invalid key type (AES Key)                                                               |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_BUFFER_TOO_SMALL                  |                                                                                                                  | Small output buffer                                                                      |   |
| Key Derivation               | test_c043 | psa_raw_key_agreement            | Perform a key agreement and return the raw shared secret                               | PSA_SUCCESS                                 | 1. Initialize the PSA crypto library                                                                             | 1. ECDH SECP256R1                                                                        |   |
|                              |           |                                  |                                                                                        |                                             | 2. Setup the attributes for the key                                                                              | 2. ECDH SECP384R1                                                                        |   |
|                              |           |                                  |                                                                                        |                                             | 3. Import the key data into the key slot                                                                         |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 4. Set up a key agreement operation                                                                              |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 5. Reset and destroy the key                                                                                     |                                                                                          |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_INVALID_ARGUMENT                  |                                                                                                                  | 1. Not a key agreement alg                                                               |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 2. Public key on different curve                                                         |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 3. Public key instead of private key                                                     |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 4. Unknown KDF                                                                           |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 5. Small size buffer                                                                     |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_INVALID_HANDLE                    |                                                                                                                  | Uninitialized key handle                                                                 |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_NOT_PERMITTED                     |                                                                                                                  | Invalid usage                                                                            |   |
| Key Management               | test_c044 | psa_copy_key                     | Copy key material from one location to another                                         | PSA_SUCCESS                                 | 1. Initialize the PSA crypto library                                                                             | 1. 16 Byte AES                                                                           |   |
|                              |           |                                  |                                                                                        |                                             | 2. Setup the attributes for the key                                                                              | 2. 24 Byte AES                                                                           |   |
|                              |           |                                  |                                                                                        |                                             | 3. Import the key data into the key slot                                                                         | 3. 32 Byte AES with constraints                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 4. Setup the attributes for the target key                                                                       | 4. 2048 RSA public key                                                                   |   |
|                              |           |                                  |                                                                                        |                                             | 5. Make a copy of a key                                                                                          | 5. 2048 RSA key pair                                                                     |   |
|                              |           |                                  |                                                                                        |                                             | 6. Destroy the source to ensure that this doesn't affect the target                                              | 6. DES 64 bit key                                                                        |   |
|                              |           |                                  |                                                                                        |                                             | 7. Export a key in binary format and check if it matches with source material                                    | 7. Triple DES 2-Key                                                                      |   |
|                              |           |                                  |                                                                                        |                                             | 8. Reset and destroy the key                                                                                     | 8. Triple DES 3-Key                                                                      |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 9. EC Public key                                                                         |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 10. EC key pair                                                                          |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_INVALID_ARGUMENT                  |                                                                                                                  | 1. Incompatible target policy(source and target)                                         |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 2. Incompatible constraint                                                               |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 3. Incompatible target policy                                                            |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 4. Copy on a destroyed source                                                            |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_INVALID_HANDLE                    |                                                                                                                  | 1. Unallocated target key slot                                                           |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_NOT_PERMITTED                     |                                                                                                                  | Usage set as export (not copy)                                                           |   |
| Key Management               | test_c045 | psa_hash_clone                   | Clone a hash operation.                                                                | PSA_SUCCESS                                 | 1. Initialize the PSA crypto library                                                                             | 1. MD2                                                                                   |   |
|                              |           |                                  |                                                                                        |                                             | 2. Start a multipart hash operation                                                                              | 2. MD4                                                                                   |   |
|                              |           |                                  |                                                                                        |                                             | 3. Clone a hash operation                                                                                        | 3. MD5                                                                                   |   |
|                              |           |                                  |                                                                                        |                                             | 4. Add a message fragment to a multipart hash source_operation                                                   | 4. RIPEMD160                                                                             |   |
|                              |           |                                  |                                                                                        |                                             | 5. Finish the calculation of the hash of a message                                                               | 5. SHA1                                                                                  |   |
|                              |           |                                  |                                                                                        |                                             | 6. Abort the hash operation                                                                                      | 6. SHA224                                                                                |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 7. SHA256                                                                                |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 8. SHA512                                                                                |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_BAD_STATE                         | Cloning to an active hash operation should be an error                                                           | 1. Active clone hash                                                                     |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 2. Aborted operator                                                                      |   |
| Message Authentication Codes | test_c046 | psa_mac_compute                  | Calculate the MAC (message authentication code) of a message.                          | PSA_SUCCESS                                 | 1. Initialize the PSA crypto library                                                                             | 1. HMAC SHA 224                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 2. Setup the attributes for the key                                                                              | 2. CMAC AES 128                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 3. Import the key data into the key slot                                                                         | 3. HMAC SHA 224 (truncated to 8 Byte                                                     |   |
|                              |           |                                  |                                                                                        |                                             | 4. Calculate the MAC (message authentication code) of a message                                                  | 4. HMAC SHA 512                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 5. Check if the MAC length and data  matches with the expected  values                                           | 5. HMAC SHA 256                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 6. Reset and destroy the key                                                                                     |                                                                                          |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_NOT_SUPPORTED                     | Calling this function with unsupported values                                                                    | 1. Incompactible HMAC for CMAC                                                           |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 2. Invalid usage                                                                         |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 3. Truncated MAC too small                                                               |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 4. Bad algorithm (unknown MAC algorithm)                                                 |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_INVALID_ARGUMENT                  | Calling this function with invalid parameter should return this error                                            | 1. Invalid key type                                                                      |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 2. Truncated MAC too large                                                               |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_BUFFER_TOO_SMALL                  |                                                                                                                  | Small size buffer                                                                        |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_INVALID_HANDLE                    |                                                                                                                  | Destroyed key handle                                                                     |   |
| Message Authentication Codes | test_c047 | psa_mac_verify                   | Calculate the MAC of a message and compare it with a reference value                   | PSA_SUCCESS                                 | 1. Initialize the PSA crypto library                                                                             | 1. HMAC SHA 224                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 2. Setup the attributes for the key                                                                              | 2. HMAC SHA 256                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 3. Import the key data into the key slot                                                                         | 3. HMAC SHA 512                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 4. Calculate and verify MAC with reference value                                                                 | 4. HMAC SHA 224 (truncated to 8 Byte)                                                    |   |
|                              |           |                                  |                                                                                        |                                             | 5. Reset and destroy the key                                                                                     | 5. CMAC AES 128                                                                          |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_NOT_SUPPORTED                     | Calling this function with unsupported values                                                                    | 1. Incompactible HMAC for CMAC                                                           |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 2. Invalid usage                                                                         |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 3. Truncated MAC too small                                                               |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 4. Bad algorithm (unknown MAC algorithm)                                                 |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_INVALID_SIGNATURE                 |                                                                                                                  | 1. Small size buffer                                                                     |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 2. Incorrect expected MAC                                                                |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_INVALID_ARGUMENT                  |                                                                                                                  | 1. Truncated MAC too large                                                               |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 2. Invalid key type                                                                      |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_INVALID_HANDLE                    |                                                                                                                  | Destroyed key handle                                                                     |   |
| Symmetric Ciphers            | test_c048 | psa_cipher_encrypt               | Encrypt a message using a symmetric cipher.                                            | PSA_SUCCESS                                 | 1. Initialize the PSA crypto library                                                                             | 1. AES CBC_NO_PADDING                                                                    |   |
|                              |           |                                  |                                                                                        |                                             | 2. Setup the attributes for the key                                                                              | 2. AES CBC_PKCS7                                                                         |   |
|                              |           |                                  |                                                                                        |                                             | 3. Import the key data into the key slot                                                                         | 3. AES CBC_PKCS7 (Short input)                                                           |   |
|                              |           |                                  |                                                                                        |                                             | 4. Encrypt a message using a symmetric cipher                                                                    | 4. AES CTR                                                                               |   |
|                              |           |                                  |                                                                                        |                                             | 5. Check if the output  matches the expected value                                                               | 5. AES CTR (short input)                                                                 |   |
|                              |           |                                  |                                                                                        |                                             | 6. Reset and destroy the key                                                                                     | 6. DES CBC (nopad)                                                                       |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 7. 2-key 3DE -CBC (nopad)                                                                |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 8. 3-key 3DE -CBC (nopad)                                                                |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_NOT_PERMITTED                     |                                                                                                                  | Decrypt - AES CBC_NO_PADDING                                                             |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_BUFFER_TOO_SMALL                  |                                                                                                                  | Small output buffer size                                                                 |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_INVALID_ARGUMENT                  |                                                                                                                  | AES CBC_NO_PADDING (Short input)                                                         |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_INVALID_HANDLE                    |                                                                                                                  | Aborted key handle                                                                       |   |
| Symmetric Ciphers            | test_c049 | psa_cipher_decrypt               | Decrypt a message using a symmetric cipher.                                            | PSA_SUCCESS                                 | 1. Initialize the PSA crypto library                                                                             | 1. AES CBC_NO_PADDING                                                                    |   |
|                              |           |                                  |                                                                                        |                                             | 2. Setup the attributes for the key                                                                              | 2. AES CBC_PKCS7                                                                         |   |
|                              |           |                                  |                                                                                        |                                             | 3. Import the key data into the key slot                                                                         | 3. AES CBC_PKCS7 (Short input)                                                           |   |
|                              |           |                                  |                                                                                        |                                             | 4. Encrypt a message using a symmetric cipher                                                                    | 4. AES CTR                                                                               |   |
|                              |           |                                  |                                                                                        |                                             | 5. Check if the output  matches the expected value                                                               | 5. AES CTR (short input)                                                                 |   |
|                              |           |                                  |                                                                                        |                                             | 6. Reset and destroy the key                                                                                     | 6. DES CBC (nopad)                                                                       |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 7. 2-key 3DE -CBC (nopad)                                                                |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 8. 3-key 3DE -CBC (nopad)                                                                |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_INVALID_ARGUMENT                  |                                                                                                                  | AES CBC_NO_PADDING (Short input)                                                         |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_NOT_PERMITTED                     |                                                                                                                  | AES CBC_NO_PADDING                                                                       |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_BUFFER_TOO_SMALL                  |                                                                                                                  | Small output buffer size                                                                 |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_INVALID_HANDLE                    |                                                                                                                  | Aborted key handle                                                                       |   |
| Key Management               | test_c050 | psa_open_key                     | Open a handle to an existing persistent key                                            | PSA_SUCCESS                                 | 1. Initialize the PSA crypto library                                                                             | 1. 16 Byte AES                                                                           |   |
|                              |           |                                  |                                                                                        |                                             | 2. Setup the attributes for the key                                                                              | 2. 24 Byte AES                                                                           |   |
|                              |           |                                  |                                                                                        |                                             | 3. Import the key data into the key slot                                                                         | 3. 32 Byte AES                                                                           |   |
|                              |           |                                  |                                                                                        |                                             | 4. Save the details of current check, key id and key handle value in NV memory                                   | 4. 2048 RSA public key                                                                   |   |
|                              |           |                                  |                                                                                        |                                             | 5. Reset the system                                                                                              | 5. 2048 RSA keypair                                                                      |   |
|                              |           |                                  |                                                                                        |                                             | 6. After reset, get the values of check, key id and key handle value before the system was reset from NV         | 6. DES 64 bit key                                                                        |   |
|                              |           |                                  |                                                                                        |                                             | 7. Get the attributes of the imported key and check if it matches the given value                                | 7. Triple DES 2-Key                                                                      |   |
|                              |           |                                  |                                                                                        |                                             | 8. Export a key in binary format                                                                                 | 8. Triple DES 3-Key                                                                      |   |
|                              |           |                                  |                                                                                        |                                             | 9. Check the value of the exported key                                                                           | 9. EC Public key                                                                         |   |
|                              |           |                                  |                                                                                        |                                             | 10. Reset and destroy the key                                                                                    | 10. EC keypair                                                                           |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_INVALID_ARGUMENT                  |                                                                                                                  | Key data greater than the algorithm size                                                 |   |
| Key Management               | test_c051 | psa_close_key                    | Close a key handle                                                                     | PSA_SUCCESS                                 | 1. Initialize the PSA crypto library                                                                             | 1. 16 Byte AES                                                                           |   |
|                              |           |                                  |                                                                                        |                                             | 2. Setup the attributes for the key                                                                              | 2. 24 Byte AES                                                                           |   |
|                              |           |                                  |                                                                                        |                                             | 3. Import the key data into the key slot                                                                         | 3. 32 Byte AES                                                                           |   |
|                              |           |                                  |                                                                                        |                                             | 4. Close the key handle                                                                                          | 4. 2048 RSA public key                                                                   |   |
|                              |           |                                  |                                                                                        |                                             | 5. Check if all the attributes are erased                                                                        | 5. 2048 RSA keypair                                                                      |   |
|                              |           |                                  |                                                                                        |                                             | 6. Open the key handle and retrieve the data                                                                     | 6. DES 64 bit key                                                                        |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 7. Triple DES 2-Key                                                                      |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 8. Triple DES 3-Key                                                                      |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 9. EC Public key                                                                         |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 10. EC keypair                                                                           |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_INVALID_HANDLE                    |                                                                                                                  | Closing an empty key handle                                                              |   |
| AEAD                         | test_c052 | psa_aead_encrypt_setup           | Set the key for a multipart authenticated encryption operation                         | PSA_SUCCESS                                 | 1. Initialize the PSA crypto library                                                                             | 1. AES-CCM                                                                               |   |
|                              |           |                                  |                                                                                        |                                             | 2. Setup the attributes for the key                                                                              | 2. AES-CCM 24 bytes Tag length = 4                                                       |   |
|                              |           |                                  |                                                                                        |                                             | 3. Import the key data into the key slot                                                                         | 3. GCM - 16B AES - 12B Nounce & 12B addi data                                            |   |
|                              |           |                                  |                                                                                        |                                             | 4. Set the key for a multipart authenticated encryption operation                                                |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 5. Destroy the key                                                                                               |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 6. Abort the AEAD operation                                                                                      |                                                                                          |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_NOT_SUPPORTED                     |                                                                                                                  | 1. DES Key                                                                               |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 2. Unsupported Algorithm                                                                 |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_NOT_PERMITTED                     |                                                                                                                  | Invalid key usage                                                                        |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_INVALID_HANDLE                    |                                                                                                                  | Destroyed key handle                                                                     |   |
| AEAD                         | test_c053 | psa_aead_decrypt_setup           | Set the key for a multipart authenticated decryption operation                         | PSA_SUCCESS                                 | 1. Initialize the PSA crypto library                                                                             | 1. AES-CCM                                                                               |   |
|                              |           |                                  |                                                                                        |                                             | 2. Setup the attributes for the key                                                                              | 2. AES-CCM 24 bytes Tag length = 4                                                       |   |
|                              |           |                                  |                                                                                        |                                             | 3. Import the key data into the key slot                                                                         | 3. GCM - 16B AES - 12B Nounce & 12B addi data                                            |   |
|                              |           |                                  |                                                                                        |                                             | 4. Set the key for a multipart authenticated decryption operation                                                |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 5. Destroy the key                                                                                               |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 6. Abort the AEAD operation                                                                                      |                                                                                          |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_NOT_SUPPORTED                     |                                                                                                                  | 1. DES Key                                                                               |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 2. Unsupported Algorithm                                                                 |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_NOT_PERMITTED                     |                                                                                                                  | Invalid key usage                                                                        |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_INVALID_HANDLE                    |                                                                                                                  | Destroyed key handle                                                                     |   |
| AEAD                         | test_c054 | psa_aead_generate_nonce          | Generate a random nonce for an authenticated encryption operation                      | PSA_SUCCESS                                 | 1. Initialize the PSA crypto library                                                                             | 1. AES-CCM                                                                               |   |
|                              |           |                                  |                                                                                        |                                             | 2. Setup the attributes for the key                                                                              | 2. AES-CCM 24 bytes Tag length = 4                                                       |   |
|                              |           |                                  |                                                                                        |                                             | 3. Import the key data into the key slot                                                                         | 3. GCM - 16B AES - 12B Nounce & 12B addi data                                            |   |
|                              |           |                                  |                                                                                        |                                             | 4. Set the key for a multipart authenticated decryption operation                                                |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 5. Generate a random nonce for an authenticated encryption operation                                             |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 6. Check that if generated iv are non zero                                                                       |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 7. Destroy the key                                                                                               |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 8. Reset the key attributes                                                                                      |                                                                                          |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_BUFFER_TOO_SMALL                  |                                                                                                                  | Small buffer size                                                                        |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_BAD_STATE                         |                                                                                                                  | 1. Call generate a random nonce twice                                                    |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 2. Aborted operation                                                                     |   |
| AEAD                         | test_c055 | psa_aead_set_nonce               | Set the nonce for an authenticated encryption or decryption operation                  | PSA_SUCCESS                                 | 1. Initialize the PSA crypto library                                                                             | 1. AES-CCM                                                                               |   |
|                              |           |                                  |                                                                                        |                                             | 2. Setup the attributes for the key                                                                              | 2. AES-CCM 24 bytes Tag length = 4                                                       |   |
|                              |           |                                  |                                                                                        |                                             | 3. Import the key data into the key slot                                                                         | 3. GCM - 16B AES - 12B Nounce & 12B addi data                                            |   |
|                              |           |                                  |                                                                                        |                                             | 4. Set the key for a multipart authenticated decryption operation                                                |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 5. Set the nonce for an authenticated encryption operation                                                       |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 6. Reset and destroy the key                                                                                     |                                                                                          |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_INVALID_ARGUMENT                  |                                                                                                                  | 1. Small nounce size                                                                     |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 2. Large nonce size                                                                      |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_BAD_STATE                         |                                                                                                                  | 1. Call set nonce twice                                                                  |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 2. Aborted operation                                                                     |   |
| AEAD                         | test_c056 | psa_aead_set_lengths             | Declare the lengths of the message and additional data for AEAD                        | PSA_SUCCESS                                 | 1. Initialize the PSA crypto library                                                                             | 1. AES-CCM                                                                               |   |
|                              |           |                                  |                                                                                        |                                             | 2. Setup the attributes for the key                                                                              | 2. AES-CCM 24 bytes Tag length = 4                                                       |   |
|                              |           |                                  |                                                                                        |                                             | 3. Import the key data into the key slot                                                                         |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 4. Set the key for a multipart authenticated decryption operation                                                |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 5. Set the nonce for an authenticated encryption operation                                                       |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 6. Declare the lengths of the message and additional data for AEAD                                               |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 7. Abort the AEAD operation                                                                                      |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 8. Reset and destroy the key                                                                                     |                                                                                          |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_INVALID_ARGUMENT                  |                                                                                                                  | 1. Zero ad size                                                                          |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 2. Zero plaintext size                                                                   |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 3. Invalid lengths                                                                       |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 4. Vey large lengths                                                                     |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_BAD_STATE                         |                                                                                                                  | 1. Failed operation                                                                      |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 2. Aborted operation                                                                     |   |
| AEAD                         | test_c057 | psa_aead_update_ad               | Pass additional data to an active AEAD operation                                       | PSA_SUCCESS                                 | 1. Initialize the PSA crypto library                                                                             | 1. AES-CCM                                                                               |   |
|                              |           |                                  |                                                                                        |                                             | 2. Setup the attributes for the key                                                                              | 2. AES-CCM 24 bytes Tag length = 4                                                       |   |
|                              |           |                                  |                                                                                        |                                             | 3. Import the key data into the key slot                                                                         |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 4. Set the key for a multipart authenticated decryption operation                                                |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 5. Set the nonce for an authenticated encryption operation                                                       |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 6. Declare the lengths of the message and additional data for AEAD                                               |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 7. Pass additional data to an active AEAD operation                                                              |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 8. Reset and destroy the key                                                                                     |                                                                                          |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_INVALID_ARGUMENT                  |                                                                                                                  | 1. Zero ad size                                                                          |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 2. Zero plaintext size                                                                   |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 3. Invalid lengths                                                                       |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 4. Vey large lengths                                                                     |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_BAD_STATE                         |                                                                                                                  | Inactive AEAD operation                                                                  |   |
| AEAD                         | test_c058 | psa_aead_update                  | Encrypt or decrypt a message fragment in an active AEAD operation                      | PSA_SUCCESS                                 | 1. Initialize the PSA crypto library                                                                             | 1. AES-CCM                                                                               |   |
|                              |           |                                  |                                                                                        |                                             | 2. Setup the attributes for the key                                                                              | 2. AES-CCM 24 bytes Tag length = 4                                                       |   |
|                              |           |                                  |                                                                                        |                                             | 3. Import the key data into the key slot                                                                         | 3. GCM - 16B AES - 12B Nounce & 12B addi data                                            |   |
|                              |           |                                  |                                                                                        |                                             | 4. Set the key for a multipart authenticated decryption operation                                                |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 5. Set the nonce for an authenticated encryption operation                                                       |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 6. Declare the lengths of the message and additional data for AEAD                                               |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 7. Pass additional data to an active AEAD operation                                                              |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 8. Encrypt or decrypt a message fragment in an active AEAD operation                                             |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 9. Compare the output and its length with the expected values                                                    |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 10. Abort the AEAD operation                                                                                     |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 11. Reset and destroy the key                                                                                    |                                                                                          |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_INVALID_ARGUMENT                  |                                                                                                                  | 1. Zero plaintext size                                                                   |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 2. Input length overflows plaintext length                                               |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_BUFFER_TOO_SMALL                  |                                                                                                                  | Small buffer size                                                                        |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_BAD_STATE                         |                                                                                                                  | Inactive AEAD operation                                                                  |   |
| AEAD                         | test_c059 | psa_aead_finish                  | Finish encrypting a message in an AEAD operation                                       | PSA_SUCCESS                                 | 1. Initialize the PSA crypto library                                                                             | 1. AES-CCM                                                                               |   |
|                              |           |                                  |                                                                                        |                                             | 2. Setup the attributes for the key                                                                              | 2. AES-CCM 24 bytes Tag length = 4                                                       |   |
|                              |           |                                  |                                                                                        |                                             | 3. Import the key data into the key slot                                                                         | 3. GCM - 16B AES - 12B Nounce & 12B addi data                                            |   |
|                              |           |                                  |                                                                                        |                                             | 4. Set the key for a multipart authenticated decryption operation                                                |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 5. Set the nonce for an authenticated encryption operation                                                       |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 6. Declare the lengths of the message and additional data for AEAD                                               |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 7. Pass additional data to an active AEAD operation                                                              |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 8. Encrypt or decrypt a message fragment in an active AEAD operation                                             |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 9. Finish encrypting a message in an AEAD operation                                                              |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 10. Compare the output and its length with the expected values                                                   |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 11. Abort the AEAD operation                                                                                     |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 12. Reset and destroy the key                                                                                    |                                                                                          |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_INVALID_ARGUMENT                  |                                                                                                                  | 1. Zero plaintext size                                                                   |   |
|                              |           |                                  |                                                                                        |                                             |                                                                                                                  | 2. Input length overflows plaintext length                                               |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_BUFFER_TOO_SMALL                  |                                                                                                                  | Small buffer size                                                                        |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_BAD_STATE                         |                                                                                                                  | Inactive AEAD operation                                                                  |   |
| AEAD                         | test_c060 | psa_aead_abort                   | Abort an AEAD operation                                                                | PSA_SUCCESS                                 | 1. Initialize the PSA crypto library                                                                             | 1. AES-CCM                                                                               |   |
|                              |           |                                  |                                                                                        |                                             | 2. Setup the attributes for the key                                                                              | 2. AES-CCM 24 bytes Tag length = 4                                                       |   |
|                              |           |                                  |                                                                                        |                                             | 3. Import the key data into the key slot                                                                         | 3. GCM - 16B AES - 12B Nounce & 12B addi data                                            |   |
|                              |           |                                  |                                                                                        |                                             | 4. Set the key for a multipart authenticated decryption operation                                                |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 5. Abort the AEAD operation                                                                                      |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 6. Reset and destroy the key                                                                                     |                                                                                          |   |
| AEAD                         | test_c061 | psa_aead_verify                  | Finish authenticating and decrypting a message in an AEAD operation                    | PSA_SUCCESS                                 | 1. Initialize the PSA crypto library                                                                             | 1. AES-CCM                                                                               |   |
|                              |           |                                  |                                                                                        |                                             | 2. Setup the attributes for the key                                                                              | 2. AES-CCM 24 bytes Tag length = 4                                                       |   |
|                              |           |                                  |                                                                                        |                                             | 3. Import the key data into the key slot                                                                         | 3. GCM - 16B AES - 12B Nounce & 12B addi data                                            |   |
|                              |           |                                  |                                                                                        |                                             | 4. Set the key for a multipart authenticated decryption operation                                                |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 5. Set the nonce for an authenticated encryption operation                                                       |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 6. Declare the lengths of the message and additional data for AEAD                                               |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 7. Pass additional data to an active AEAD operation                                                              |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 8. Encrypt or decrypt a message fragment in an active AEAD operation                                             |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 9. Finish decrypting a message in an AEAD operation                                                              |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 10. Compare the output and its length with the expected values                                                   |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 11. Abort the AEAD operation                                                                                     |                                                                                          |   |
|                              |           |                                  |                                                                                        |                                             | 12. Reset and destroy the key                                                                                    |                                                                                          |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_INVALID_ARGUMENT                  |                                                                                                                  | Input length is less than plaintext length                                               |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_BUFFER_TOO_SMALL                  |                                                                                                                  | Small buffer size                                                                        |   |
|                              |           |                                  |                                                                                        | PSA_ERROR_BAD_STATE                         |                                                                                                                  | Inactive operator                                                                        |   |

## License
Arm PSA test suite is distributed under Apache v2.0 License.

--------------

*Copyright (c) 2018-2019, Arm Limited and Contributors. All rights reserved.*
