# PSA Storage (Internal Trusted Storage and Protected Storage) Testcase checklist

## Requirements for Storage Test Suite

Following are the requirements of the Storage Test Suite. <br />

1. Unless described in this document, any behaviour that is defined as IMPLEMENTATION_DEFINED in PSA Storage API document is not verified in this document. <br />
2. Storage Test Cases use UID value starting from 1 onwards. These UID needs to be free for successfull test execution.<br />
3. UID values 1 and 2 are reserved as WRITE_ONCE UID. These UID can't be free from testcase. Make sure these are free.<br />

| Test      | Test Scenario                         | API Verified   | Return Value            | Test Algorithm      | UID Usage              |
|-----------|---------------------------------------|----------------|-------------------------|---------------------|------------------------|
| test_s001 | get_info and remove API's call for <br /> non-existent and removed assest | psa_its(ps)_get<br />psa_its(ps)_get_info <br />psa_its(ps)_remove<br />                                 | PSA_ERROR_DOES_NOT_EXIST                                 | 1. Call get API with UID for which no UID/Data pair is created<br />2. Call get_info API for which no UID/Data pair is created<br />3. Call remove API for which no UID/Data pair is created<br />4. Set valid  UID/Data pair with uid1<br />5. Set one more set of UID/Data pair, with different uid, than previous<br />6. Remove the uid of step 4.<br />7. Call get API for  removed UID/data pair<br />8. Call get_info API for  removed UID/Data pair<br />9. Call remove API for  removed UID/Data pair<br />10. Set valid UID/Data pair<br />11. Call get API for different uid , then created<br />12. Call get_info API for different uid, then created<br />13. Call remove API for different uid, then created<br />14. Remove the created UID/Data pair.<br />15. Remove the stray uid.<br />                                                                                                         | UID value used are 5,6,7                                                                                                                     |
| test_s002 | Overwriting data for asset created with<br /> WRITE_ONCE flag                 | psa_its(ps)_set<br />psa_its(ps)_remove<br />                                                            | PSA_ERROR_NOT_PERMITTED                                  | 1. Set valid UID/data value pair , with create flag value none.<br />2. Call get and get_info API to validate the data, attributes associated with data<br />3. Call set API again with same uid and create flag  PSA_STORAGE_WRITE_ONCE_FLAG<br />4. Call get and get_info API to validate the data, attributes associated with data<br /> is not changed after second set operation<br />5. try to remove the UID/data pair.<br />6. Create new UID/data value pair, with create flag PSA_STORAGE_WRITE_ONCE_FLAG<br />7. Try to remove the created UID.<br />8. Call get and get_info API to validate the data, attributes associated with data<br />9. Again call SET with same UID , create flag PSA_STORAGE_WRITE_ONCE_FLAG but <br />different data length<br />10. Try to remove the UID, PSA_ERROR_NOT_PERMITTED error should be returned<br />11. Call get and get_info API to validate the data, attributes associated with data<br /> | UID value used are 1 and 2                                                                                                                                                                     |
| test_s003 | Exhaust storage space                                                         | psa_its(ps)_set<br />                                                                                    | PSA_ERROR_INSUFFICIENT_STORAGE                           | 1. Create UID/data pairs, with data_len of ARCH_TEST_STORAGE_UID_MAX_SIZE bytes. Do this with incrementing<br /> uid values till we have INSUFFICENT_SPACE.<br />2. Remove all the UID/data pairs created.<br />3. Repeat the steps once more, to check all previous uid are removed successfully<br />                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | UID value starts from 5 and keep on incrementing till all space is exhausted                                                                                                                    |
| test_s004 | Overwriting data for asset created without WRITE_ONCE flag                    | psa_its(ps)_set<br />psa_its(ps)_get<br />psa_its(ps)_get_info<br />psa_its(ps)_remove<br />             | PSA_SUCCESS                                              | 1. Set a valid uid/data pair<br />2. Validate the data using get api<br />3. Change the data length to half of previous.<br />4. Call GET api with original data length , expect the success result and the read buffer to match for half of original length <br />5. Call REMOVE api to delete the UID/data pair<br />                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | UID value used is 5                                                                                                                                                                            |
| test_s005 | Get, get_info and remove API call for valid assest                            | psa_its(ps)_set<br />psa_its(ps)_get<br />psa_its(ps)_get_info<br />psa_its(ps)_remove<br />             | PSA_SUCCESS                                              | 1. Set valid UID/data pair with varying uid and data_len <br />2. Call GET api and validate the set data<br />3. Call GET info api and validate the data attributes<br />4. Call REMOVE api to delete the UID/data pair<br />                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      | UID value used are 4                                                                                                                           |
| test_s006 | Storage asset creation with supported create flag values                      | psa_its(ps)_set<br />                                                                                    | PSA_ERROR_NOT_SUPPORTED                                  | 1. Call the SET API with available create flag values <br />2. Call GET_INFO api and validate the flag value<br />3. Remove the uid/data pair<br />                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | UID value used is 5                                                                                                                          |
| test_s007 | Get API call with length different than asset <br /> data length              | psa_its(ps)_set<br /> psa_its(ps)_get <br />                                                             | PSA_SUCCESS                                              | 1. Create valid uid/data pair. <br />2. Increase the length of storage.<br />3. Try to access the old length using get api.<br />4. Try to access with valid length less than stored size.<br />5. Decrease the length of storage.<br />6. Try to access the old length.<br />7. Remove the uid<br />                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                           | UID value used is 5                                                                                                                       |
| test_s008 | Get API call with invalid offset                                              | psa_its(ps)_get<br />                                                                                    | PSA_ERROR_INVALID_ARGUMENT                               | 1. Set valid UID/data pair<br />2. Call GET api with valid offset and offset + data_len equal to stored data size.<br />3. Call GET api with valid offset and offset + data_len less than stored data size.<br />4. Call get api with invalid offset.<br />5. Call get api with zero offset , but data len greater than data size.<br />6. Remove the uid.<br />                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  | UID value used is  5 |
| test_s009 | API call with NULL pointer and zero length                                    | psa_its(ps)_get<br />psa_its(ps)_set<br />psa_its(ps)_get_info<br />                                     | PSA_ERROR_DOES_NOT_EXIST                                 | 1. Call the SET API with NULL pointer and data_len zero <br />2. Validate using get_info api storage should be present.<br />3. Call get API with NULL pointer.<br />4. Remove the UID.<br />5. Call get_info API to validate storage is removed.<br />6. Set storage entity with valid write_buffer , but length zero.<br />7. Call get_info API to validate storage attributes.<br />8. Call get_info api with NULL pointer and valid uid.<br />9. Remove the uid<br />                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    | UID value used is 5 <br />                                                                                                                                                                     |
| test_s010 | Storage assest creation with UID value 0                                      | psa_its(ps)_set<br />                                                                                    | PSA_ERROR_INVALID_ARGUMENT                               | 1. Call the SET API with UID value 0.<br />2. Check that storage creation fails.<br /> | UID value used is 0 <br />
| NA        | Storage Failure                                                               | NA                                                                                                       | PSA_ERROR_STORAGE_FAILURE                                | 1. The failure cause will depend on the underlying <br /> platform and vary for each implementation.<br /> It is skipped in current suite  <br /> | NA <br />                                                                                                                                                                     |
| test_s011 | Set_extended API's call for <br /> non-existent and removed assest            | psa_ps_set_extended<br />                                                                                | PSA_ERROR_DOES_NOT_EXIST                                 | Below Steps will be run only if optional API are not supported.<br />1. Call the SET Extended API when no uid present.<br />2. Create a valid storage using set. <br /> 3. Call create api with different length for existing uid.<br /> 4. Call create api to set WRITE_ONCE flag.<br /> 5. Validate data attributes are maintained.<br />6. Remove the uid.<br /> 7. Create valid storage using create api.<br /> 8. Try to change length using create api.<br /> 9. Validate storage is empty.<br /> 10. Again call create api with original parameters.<br />11. Remove the uid.<br /> 12. Check no duplicate entry present.<br />                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | UID value used is 5 <br />                                                                                                                                                                     |
| test_s012 | Set_extended API's call <br /> with invalid offset                            | psa_ps_set_extended<br />                                                                                | PSA_ERROR_INVALID_ARGUMENT                               | Below Steps will be run only if optional API are not supported.<br />1. Create a valid storage using set.<br /> 2. Set data on first half of buffer.<br /> 3. Try to set data at incorrect offset +length. <br /> 4. Try to set data at incorrect offset.<br />5. Try to set at correct offset but zero length buffer.<br />6. Try to set data at incorrect length and valid offset.<br /> 7. Overwrite the storage using set api.<br /> 8. Validate data is correctly written.<br \> 9. Call set_extended with NULL write buffer.<br /> 10. Overwrite storage using set_extended api.<br /> 11. Remove the uid.<br />                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   | UID value used is 6 <br />
| test_s013 | Create and set_extended API call for valid assest                             | psa_ps_set_extended<br /> psa_ps_create                                                                  | PSA_SUCCESS                                              | Below Steps will be run only if optional API are not supported.<br />1.  Create Storage of zero length using create.<br />2. Try to set some data in the storage created.<br />3. Validate the storage attributes.<br /> 4. Remove the storage.<br /> 5. Create a valid storage with non-zero length.<br /> 6. Set data in the buffer.<br /> 7. Validate the data attributes.<br /> 8. Overwrite data using set api.<br /> 9. Validate the data.<br /> 10. Call create api for existing uid with same parameters.<br /> 11. Remove the uid.<br /> 12. Check with set_extended no duplicate uid exists.<br />                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | UID value used is 4
| test_s014 | Create and set_extended API call<br /> when API's not supported               | psa_ps_create<br />psa_ps_set_extended<br />                                                             | PSA_ERROR_NOT_SUPPORTED                                  | Below Steps will be run only if optional API are not supported.<br />1. Create API call should fail.<br />2. Check the UID should not exist.<br /> 3. Create storage using set API.<br /> 4. Try to partially write using set_extended API.<br /> 5. Validate data is not modified.<br /> 6. Remove the uid.<br />                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | UID value used is 5
| test_s015 | Create API call with<br /> WRITE_ONCE flag                                    | psa_ps_create<br />                                                                                      | PSA_ERROR_NOT_SUPPORTED                                  | Below Step will be run only if optional API are supported.<br />1. Create API call with WRITE_ONCE flag should fail.<br />                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          | UID value used is 5 <br />
| test_s016 | Create API call for capacity check                                            | psa_ps_create<br /> psa_ps_set<br /> psa_ps_get_info<br /> psa_ps_set_extended<br /> psa_ps_remove<br /> | PSA_ERROR_ALREADY_EXISTS<br /> PSA_ERROR_STORAGE_FAILURE | Below Steps will be run only if optional API are supported.<br /> 1. Create storage with valid UID and capacity using create<br /> 2. Check create for existing UID fails<br /> 3. Check the attributes of storage are unchanged<br /> 4. Override the storage using SET API<br /> 5. Check the attributes of storage are changed<br /> 6. Accessing old capacity with set_extended API fails<br /> 7. Remove the storage<br /> 8. Create new storage with valid UID/data pair using set API<br /> 9. Check create API for existing UID fails<br /> 10. Remove the storage | UID value used is 5                                                                                                                                                           <br />
| test_s017 | Partial write check with set extended API                                     | psa_ps_create<br /> psa_ps_set_extended<br /> psa_ps_get_info<br /> psa_ps_remove<br />                  | PSA_ERROR_STORAGE_FAILURE                                | Below Steps will be run only if optional API are supported.<br /> 1. Create storage with valid UID and capacity using create<br /> 2. Set partial data using set extended API<br /> 3. Check set extended API fails for data with gaps<br /> 4. Set full length data using set extended API<br /> 5. Check the valid attributes of storage<br /> 6. Remove the storage<br /> | UID value used is 5 <br />
| NA        | Fatal error <br />                                                            | NA                                                                                                       | PSA_ERROR_STORAGE_FAILURE                                | 1. The failure cause will depend on the underlying <br /> platform and vary for each implementation.<br /> It is skipped in current suite  <br /> | NA <br /> |
| NA        | Data Corruption  <br />                                                       | NA                                                                                                       | PSA_ERROR_DATA_CORRUPT                                   | 1. The failure cause will depend on the underlying <br /> platform and vary for each implementation.<br /> It is skipped in current suite  <br /> | NA <br /> |
| NA        | Invalid Signature <br />                                                      | NA                                                                                                       | PSA_ERROR_INVALID_SIGNATURE                              | 1. The failure cause will depend on the underlying <br /> platform and vary for each implementation.<br /> It is skipped in current suite  <br /> | NA <br /> |

## License
Arm PSA test suite is distributed under Apache v2.0 License.

--------------

*Copyright (c) 2019-2020, Arm Limited and Contributors. All rights reserved.*
