/*
 * FreeRTOS PKCS #11 V2.1.0
 * Copyright (C) 2019 Amazon.com, Inc. or its affiliates.  All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of
 * this software and associated documentation files (the "Software"), to deal in
 * the Software without restriction, including without limitation the rights to
 * use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
 * the Software, and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * http://aws.amazon.com/freertos
 * http://www.FreeRTOS.org
 */

/*------------------------------------------------------------------------------ */
/* */
/* This code was auto-generated by a tool. */
/* */
/* Changes to this file may cause incorrect behavior and will be */
/* lost if the code is regenerated. */
/* */
/*----------------------------------------------------------------------------- */

#include "iot_test_pkcs11_globals.h"

static CK_BYTE sha256HashOfDigestInput[] =
{
    0xcf, 0x5b, 0x16, 0xa7, 0x78, 0xaf, 0x83, 0x80, 0x03, 0x6c, 0xe5, 0x9e, 0x7b, 0x04, 0x92, 0x37,
    0x0b, 0x24, 0x9b, 0x11, 0xe8, 0xf0, 0x7a, 0x51, 0xaf, 0xac, 0x45, 0x03, 0x7a, 0xfe, 0xe9, 0xd1
};

void C_DigestFinal_normal_behavior()
{
    CK_SESSION_HANDLE hSession = xGlobalSession;
    CK_BYTE pDigest_val[ pkcs11SHA256_DIGEST_LENGTH ] = { 0 };
    CK_BYTE_PTR pDigest = pDigest_val;
    CK_ULONG pulDigestLen_val = 0;
    CK_ULONG_PTR pulDigestLen = &pulDigestLen_val;

    CK_RV rv = pxGlobalFunctionList->C_DigestFinal( hSession, NULL, pulDigestLen );

    TEST_ASSERT_EQUAL( CKR_OK, rv );
    TEST_ASSERT_EQUAL( pkcs11SHA256_DIGEST_LENGTH, pulDigestLen_val );

    rv = pxGlobalFunctionList->C_DigestFinal( hSession, pDigest, pulDigestLen );
    TEST_ASSERT_EQUAL( CKR_OK, rv );
    TEST_ASSERT_EQUAL_INT8_ARRAY( sha256HashOfDigestInput, pDigest, pulDigestLen_val );
}

void C_DigestFinal_exceptional_behavior_0()
{
    CK_SESSION_HANDLE hSession = xGlobalSession;
    CK_BYTE pDigest_val[ pkcs11SHA256_DIGEST_LENGTH ] = { 0 };
    CK_BYTE_PTR pDigest = pDigest_val;
    CK_ULONG pulDigestLen_val = 0;
    CK_ULONG_PTR pulDigestLen = &pulDigestLen_val;

    CK_RV rv = pxGlobalFunctionList->C_DigestFinal( hSession, NULL, pulDigestLen );

    TEST_ASSERT_EQUAL( CKR_OPERATION_NOT_INITIALIZED, rv );
}

void C_DigestFinal_exceptional_behavior_1()
{
    CK_SESSION_HANDLE hSession = xGlobalSession;
    CK_BYTE_PTR pDigest = NULL_PTR;
    CK_ULONG_PTR pulDigestLen = NULL_PTR;

    CK_RV rv = pxGlobalFunctionList->C_DigestFinal( hSession, pDigest, pulDigestLen );

    TEST_ASSERT_EQUAL( CKR_ARGUMENTS_BAD, rv );
}

void C_DigestFinal_exceptional_behavior_2()
{
    CK_SESSION_HANDLE hSession = CK_INVALID_HANDLE;
    CK_BYTE_PTR pDigest = NULL_PTR;
    CK_ULONG pulDigestLen_val = 0;
    CK_ULONG_PTR pulDigestLen = &pulDigestLen_val;

    CK_RV rv = pxGlobalFunctionList->C_DigestFinal( hSession, pDigest, pulDigestLen );

    TEST_ASSERT_EQUAL( CKR_SESSION_HANDLE_INVALID, rv );
}

void C_DigestFinal_exceptional_behavior_3()
{
    CK_SESSION_HANDLE hSession = xGlobalSession;
    CK_BYTE pDigest_val[ pkcs11SHA256_DIGEST_LENGTH ] = { 0 };
    CK_BYTE_PTR pDigest = pDigest_val;
    CK_ULONG pulDigestLen_val = 0;
    CK_ULONG_PTR pulDigestLen = &pulDigestLen_val;

    CK_RV rv = pxGlobalFunctionList->C_DigestFinal( hSession, NULL, pulDigestLen );

    TEST_ASSERT_EQUAL( CKR_OK, rv );

    pulDigestLen_val = 3;
    rv = pxGlobalFunctionList->C_DigestFinal( hSession, pDigest, pulDigestLen );

    TEST_ASSERT_EQUAL( CKR_BUFFER_TOO_SMALL, rv );
}

void C_DigestFinal_exceptional_behavior_4()
{
    CK_SESSION_HANDLE hSession = xGlobalSession;
    CK_BYTE pDigest_val[ pkcs11SHA256_DIGEST_LENGTH ] = { 0 };
    CK_BYTE_PTR pDigest = pDigest_val;
    CK_ULONG pulDigestLen_val = 0;
    CK_ULONG_PTR pulDigestLen = &pulDigestLen_val;

    CK_RV rv = pxGlobalFunctionList->C_DigestFinal( hSession, NULL, pulDigestLen );

    TEST_ASSERT_EQUAL( CKR_CRYPTOKI_NOT_INITIALIZED, rv );
}
