/*
 * FreeRTOS PKCS #11 V2.1.0
 * Copyright (C) 2019 Amazon.com, Inc. or its affiliates.  All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of
 * this software and associated documentation files (the "Software"), to deal in
 * the Software without restriction, including without limitation the rights to
 * use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
 * the Software, and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * http://aws.amazon.com/freertos
 * http://www.FreeRTOS.org
 */

/*------------------------------------------------------------------------------ */
/* */
/* This code was auto-generated by a tool. */
/* */
/* Changes to this file may cause incorrect behavior and will be */
/* lost if the code is regenerated. */
/* */
/*----------------------------------------------------------------------------- */

#include "iot_test_pkcs11_globals.h"

#include <string.h>

char * privLabel = "Test EC Private Key";
char * pubLabel = "Test EC Public Key";

void C_GenerateKeyPair_normal_behavior()
{
    CK_SESSION_HANDLE hSession = xGlobalSession;
    CK_MECHANISM pMechansim_val = ( CK_MECHANISM ) {
        CKM_EC_KEY_PAIR_GEN, NULL_PTR, 0
    };
    CK_MECHANISM_PTR pMechansim = &pMechansim_val;
    CK_ATTRIBUTE_PTR pPublicKeyTempalte;
    CK_ULONG ulPublicKeyAttributeCount;
    CK_ATTRIBUTE_PTR pPrivateKeyTemplate;
    CK_ULONG ulPrivateKeyAttributeCount;
    CK_OBJECT_HANDLE phPublicKey_val;
    CK_OBJECT_HANDLE_PTR phPublicKey = &phPublicKey_val;
    CK_OBJECT_HANDLE phPrivateKey_val;
    CK_OBJECT_HANDLE_PTR phPrivateKey = &phPrivateKey_val;

    CK_KEY_TYPE xKeyType = CKK_EC;
    CK_BYTE xEcParams[] = pkcs11DER_ENCODED_OID_P256;

    CK_ATTRIBUTE publicKeyTemplate[] =
    {
        { CKA_KEY_TYPE,  &xKeyType, sizeof( xKeyType )  },
        { CKA_VERIFY,    &xCkTrue,  sizeof( CK_BBOOL )  },
        { CKA_EC_PARAMS, xEcParams, sizeof( xEcParams ) },
        { CKA_LABEL,     pubLabel,  strlen( pubLabel )  }
    };

    CK_ATTRIBUTE privateKeyTemplate[] =
    {
        { CKA_KEY_TYPE, &xKeyType, sizeof( xKeyType )  },
        { CKA_TOKEN,    &xCkTrue,  sizeof( CK_BBOOL )  },
        { CKA_PRIVATE,  &xCkTrue,  sizeof( CK_BBOOL )  },
        { CKA_SIGN,     &xCkTrue,  sizeof( CK_BBOOL )  },
        { CKA_LABEL,    privLabel, strlen( privLabel ) }
    };

    pPublicKeyTempalte = publicKeyTemplate;
    ulPublicKeyAttributeCount = sizeof( publicKeyTemplate ) / sizeof( CK_ATTRIBUTE );

    pPrivateKeyTemplate = privateKeyTemplate;
    ulPrivateKeyAttributeCount = sizeof( privateKeyTemplate ) / sizeof( CK_ATTRIBUTE );

    CK_RV rv = pxGlobalFunctionList->C_GenerateKeyPair( hSession, pMechansim, pPublicKeyTempalte, ulPublicKeyAttributeCount, pPrivateKeyTemplate, ulPrivateKeyAttributeCount, phPublicKey, phPrivateKey );

    TEST_ASSERT_EQUAL( CKR_OK, rv );
}

void C_GenerateKeyPair_exceptional_behavior_0()
{
    CK_SESSION_HANDLE hSession = xGlobalSession;
    CK_MECHANISM_PTR pMechansim = NULL_PTR;
    CK_ATTRIBUTE_PTR pPublicKeyTempalte = NULL_PTR;
    CK_ATTRIBUTE_PTR pPrivateKeyTemplate = NULL_PTR;
    CK_OBJECT_HANDLE_PTR phPublicKey = NULL_PTR;
    CK_OBJECT_HANDLE_PTR phPrivateKey = NULL_PTR;
    CK_ULONG ulPublicKeyAttributeCount = 0;
    CK_ULONG ulPrivateKeyAttributeCount = 0;

    CK_RV rv = pxGlobalFunctionList->C_GenerateKeyPair( hSession, pMechansim, pPublicKeyTempalte, ulPublicKeyAttributeCount, pPrivateKeyTemplate, ulPrivateKeyAttributeCount, phPublicKey, phPrivateKey );

    TEST_ASSERT_EQUAL( CKR_ARGUMENTS_BAD, rv );
}

void C_GenerateKeyPair_exceptional_behavior_1()
{
    CK_SESSION_HANDLE hSession = xGlobalSession;
    CK_MECHANISM pMechansim_val = ( CK_MECHANISM ) {
        CKM_AES_CBC, NULL_PTR, 0
    };
    CK_MECHANISM_PTR pMechansim = &pMechansim_val;
    CK_ATTRIBUTE_PTR pPublicKeyTempalte;
    CK_ULONG ulPublicKeyAttributeCount;
    CK_ATTRIBUTE_PTR pPrivateKeyTemplate;
    CK_ULONG ulPrivateKeyAttributeCount;
    CK_OBJECT_HANDLE phPublicKey_val;
    CK_OBJECT_HANDLE_PTR phPublicKey = &phPublicKey_val;
    CK_OBJECT_HANDLE phPrivateKey_val;
    CK_OBJECT_HANDLE_PTR phPrivateKey = &phPrivateKey_val;

    CK_KEY_TYPE xKeyType = CKK_EC;
    CK_BYTE xEcParams[] = pkcs11DER_ENCODED_OID_P256;

    CK_ATTRIBUTE publicKeyTemplate[] =
    {
        { CKA_KEY_TYPE,  &xKeyType, sizeof( xKeyType )  },
        { CKA_VERIFY,    &xCkTrue,  sizeof( CK_BBOOL )  },
        { CKA_EC_PARAMS, xEcParams, sizeof( xEcParams ) },
        { CKA_LABEL,     pubLabel,  strlen( pubLabel )  }
    };

    CK_ATTRIBUTE privateKeyTemplate[] =
    {
        { CKA_KEY_TYPE, &xKeyType, sizeof( xKeyType )  },
        { CKA_TOKEN,    &xCkTrue,  sizeof( CK_BBOOL )  },
        { CKA_PRIVATE,  &xCkTrue,  sizeof( CK_BBOOL )  },
        { CKA_SIGN,     &xCkTrue,  sizeof( CK_BBOOL )  },
        { CKA_LABEL,    privLabel, strlen( privLabel ) }
    };

    pPublicKeyTempalte = publicKeyTemplate;
    ulPublicKeyAttributeCount = sizeof( publicKeyTemplate ) / sizeof( CK_ATTRIBUTE );

    pPrivateKeyTemplate = privateKeyTemplate;
    ulPrivateKeyAttributeCount = sizeof( privateKeyTemplate ) / sizeof( CK_ATTRIBUTE );

    CK_RV rv = pxGlobalFunctionList->C_GenerateKeyPair( hSession, pMechansim, pPublicKeyTempalte, ulPublicKeyAttributeCount, pPrivateKeyTemplate, ulPrivateKeyAttributeCount, phPublicKey, phPrivateKey );

    TEST_ASSERT_EQUAL( CKR_MECHANISM_INVALID, rv );
}

void C_GenerateKeyPair_exceptional_behavior_2()
{
    CK_SESSION_HANDLE hSession = CK_INVALID_HANDLE;
    CK_MECHANISM pMechansim_val = ( CK_MECHANISM ) {
        CKM_EC_KEY_PAIR_GEN, NULL_PTR, 0
    };
    CK_MECHANISM_PTR pMechansim = &pMechansim_val;
    CK_ATTRIBUTE_PTR pPublicKeyTempalte;
    CK_ULONG ulPublicKeyAttributeCount;
    CK_ATTRIBUTE_PTR pPrivateKeyTemplate;
    CK_ULONG ulPrivateKeyAttributeCount;
    CK_OBJECT_HANDLE phPublicKey_val;
    CK_OBJECT_HANDLE_PTR phPublicKey = &phPublicKey_val;
    CK_OBJECT_HANDLE phPrivateKey_val;
    CK_OBJECT_HANDLE_PTR phPrivateKey = &phPrivateKey_val;

    CK_KEY_TYPE xKeyType = CKK_EC;
    CK_BYTE xEcParams[] = pkcs11DER_ENCODED_OID_P256;

    CK_ATTRIBUTE publicKeyTemplate[] =
    {
        { CKA_KEY_TYPE,  &xKeyType, sizeof( xKeyType )  },
        { CKA_VERIFY,    &xCkTrue,  sizeof( CK_BBOOL )  },
        { CKA_EC_PARAMS, xEcParams, sizeof( xEcParams ) },
        { CKA_LABEL,     pubLabel,  strlen( pubLabel )  }
    };

    CK_ATTRIBUTE privateKeyTemplate[] =
    {
        { CKA_KEY_TYPE, &xKeyType, sizeof( xKeyType )  },
        { CKA_TOKEN,    &xCkTrue,  sizeof( CK_BBOOL )  },
        { CKA_PRIVATE,  &xCkTrue,  sizeof( CK_BBOOL )  },
        { CKA_SIGN,     &xCkTrue,  sizeof( CK_BBOOL )  },
        { CKA_LABEL,    privLabel, strlen( privLabel ) }
    };

    pPublicKeyTempalte = publicKeyTemplate;
    ulPublicKeyAttributeCount = sizeof( publicKeyTemplate ) / sizeof( CK_ATTRIBUTE );

    pPrivateKeyTemplate = privateKeyTemplate;
    ulPrivateKeyAttributeCount = sizeof( privateKeyTemplate ) / sizeof( CK_ATTRIBUTE );

    CK_RV rv = pxGlobalFunctionList->C_GenerateKeyPair( hSession, pMechansim, pPublicKeyTempalte, ulPublicKeyAttributeCount, pPrivateKeyTemplate, ulPrivateKeyAttributeCount, phPublicKey, phPrivateKey );

    TEST_ASSERT_EQUAL( CKR_SESSION_HANDLE_INVALID, rv );
}

void C_GenerateKeyPair_exceptional_behavior_3()
{
    CK_SESSION_HANDLE hSession = xGlobalSession;
    CK_MECHANISM pMechansim_val = ( CK_MECHANISM ) {
        CKM_EC_KEY_PAIR_GEN, NULL_PTR, 0
    };
    CK_MECHANISM_PTR pMechansim = &pMechansim_val;
    CK_ATTRIBUTE_PTR pPublicKeyTempalte;
    CK_ULONG ulPublicKeyAttributeCount;
    CK_ATTRIBUTE_PTR pPrivateKeyTemplate;
    CK_ULONG ulPrivateKeyAttributeCount;
    CK_OBJECT_HANDLE phPublicKey_val;
    CK_OBJECT_HANDLE_PTR phPublicKey = &phPublicKey_val;
    CK_OBJECT_HANDLE phPrivateKey_val;
    CK_OBJECT_HANDLE_PTR phPrivateKey = &phPrivateKey_val;

    CK_KEY_TYPE xKeyType = CKK_EC;
    CK_BYTE xEcParams[] = pkcs11DER_ENCODED_OID_P256;

    CK_ATTRIBUTE publicKeyTemplate[] =
    {
        { CKA_KEY_TYPE,  &xKeyType, sizeof( xKeyType )  },
        { CKA_VERIFY,    &xCkTrue,  sizeof( CK_BBOOL )  },
        { CKA_EC_PARAMS, xEcParams, sizeof( xEcParams ) },
        { CKA_LABEL,     pubLabel,  strlen( pubLabel )  }
    };

    CK_ATTRIBUTE privateKeyTemplate[] =
    {
        { CKA_KEY_TYPE, &xKeyType, sizeof( xKeyType )  },
        { CKA_TOKEN,    &xCkTrue,  sizeof( CK_BBOOL )  },
        { CKA_PRIVATE,  &xCkTrue,  sizeof( CK_BBOOL )  },
        { CKA_SIGN,     &xCkTrue,  sizeof( CK_BBOOL )  },
        { CKA_LABEL,    privLabel, strlen( privLabel ) }
    };

    pPublicKeyTempalte = publicKeyTemplate;
    ulPublicKeyAttributeCount = 0;

    pPrivateKeyTemplate = privateKeyTemplate;
    ulPrivateKeyAttributeCount = 0;

    CK_RV rv = pxGlobalFunctionList->C_GenerateKeyPair( hSession, pMechansim, pPublicKeyTempalte, ulPublicKeyAttributeCount, pPrivateKeyTemplate, ulPrivateKeyAttributeCount, phPublicKey, phPrivateKey );

    TEST_ASSERT_EQUAL( CKR_TEMPLATE_INCOMPLETE, rv );
}

void C_GenerateKeyPair_exceptional_behavior_4()
{
    CK_SESSION_HANDLE hSession = xGlobalSession;
    CK_MECHANISM pMechansim_val = ( CK_MECHANISM ) {
        CKM_EC_KEY_PAIR_GEN, NULL_PTR, 0
    };
    CK_MECHANISM_PTR pMechansim = &pMechansim_val;
    CK_ATTRIBUTE_PTR pPublicKeyTempalte;
    CK_ULONG ulPublicKeyAttributeCount;
    CK_ATTRIBUTE_PTR pPrivateKeyTemplate;
    CK_ULONG ulPrivateKeyAttributeCount;
    CK_OBJECT_HANDLE phPublicKey_val;
    CK_OBJECT_HANDLE_PTR phPublicKey = &phPublicKey_val;
    CK_OBJECT_HANDLE phPrivateKey_val;
    CK_OBJECT_HANDLE_PTR phPrivateKey = &phPrivateKey_val;

    CK_KEY_TYPE xKeyType = CKK_EC;
    CK_BYTE xEcParams[] = pkcs11DER_ENCODED_OID_P256;

    CK_ATTRIBUTE publicKeyTemplate[] =
    {
        { CKA_KEY_TYPE,  &xKeyType, sizeof( xKeyType )  },
        { CKA_VERIFY,    &xCkTrue,  sizeof( CK_BBOOL )  },
        { CKA_VERIFY,    &xCkFalse, sizeof( CK_BBOOL )  },
        { CKA_EC_PARAMS, xEcParams, sizeof( xEcParams ) },
        { CKA_LABEL,     pubLabel,  strlen( pubLabel )  }
    };

    CK_ATTRIBUTE privateKeyTemplate[] =
    {
        { CKA_KEY_TYPE, &xKeyType, sizeof( xKeyType )  },
        { CKA_TOKEN,    &xCkTrue,  sizeof( CK_BBOOL )  },
        { CKA_PRIVATE,  &xCkTrue,  sizeof( CK_BBOOL )  },
        { CKA_SIGN,     &xCkTrue,  sizeof( CK_BBOOL )  },
        { CKA_LABEL,    privLabel, strlen( privLabel ) }
    };

    pPublicKeyTempalte = publicKeyTemplate;
    ulPublicKeyAttributeCount = sizeof( publicKeyTemplate ) / sizeof( CK_ATTRIBUTE );

    pPrivateKeyTemplate = privateKeyTemplate;
    ulPrivateKeyAttributeCount = sizeof( privateKeyTemplate ) / sizeof( CK_ATTRIBUTE );

    CK_RV rv = pxGlobalFunctionList->C_GenerateKeyPair( hSession, pMechansim, pPublicKeyTempalte, ulPublicKeyAttributeCount, pPrivateKeyTemplate, ulPrivateKeyAttributeCount, phPublicKey, phPrivateKey );

    TEST_ASSERT_EQUAL( CKR_TEMPLATE_INCONSISTENT, rv );
}

void C_GenerateKeyPair_exceptional_behavior_5()
{
    CK_SESSION_HANDLE hSession = xGlobalSession;
    CK_MECHANISM pMechansim_val = ( CK_MECHANISM ) {
        CKM_EC_KEY_PAIR_GEN, NULL_PTR, 0
    };
    CK_MECHANISM_PTR pMechansim = &pMechansim_val;
    CK_ATTRIBUTE_PTR pPublicKeyTempalte;
    CK_ULONG ulPublicKeyAttributeCount;
    CK_ATTRIBUTE_PTR pPrivateKeyTemplate;
    CK_ULONG ulPrivateKeyAttributeCount;
    CK_OBJECT_HANDLE phPublicKey_val;
    CK_OBJECT_HANDLE_PTR phPublicKey = &phPublicKey_val;
    CK_OBJECT_HANDLE phPrivateKey_val;
    CK_OBJECT_HANDLE_PTR phPrivateKey = &phPrivateKey_val;

    CK_KEY_TYPE xKeyType = CKK_EC;
    CK_BYTE xEcParams[] = pkcs11DER_ENCODED_OID_P256;

    CK_ATTRIBUTE publicKeyTemplate[] =
    {
        { CKA_KEY_TYPE,  &xKeyType, sizeof( xKeyType )  },
        { CKA_VERIFY,    &xCkTrue,  sizeof( CK_BBOOL )  },
        { CKA_EC_PARAMS, xEcParams, sizeof( xEcParams ) },
        { CKA_LABEL,     pubLabel,  strlen( pubLabel )  }
    };

    CK_ATTRIBUTE privateKeyTemplate[] =
    {
        { CKA_KEY_TYPE, &xKeyType, sizeof( xKeyType )  },
        { CKA_TOKEN,    &xCkTrue,  sizeof( CK_BBOOL )  },
        { CKA_PRIVATE,  &xCkTrue,  sizeof( CK_BBOOL )  },
        { CKA_SIGN,     &xCkTrue,  sizeof( CK_BBOOL )  },
        { CKA_LABEL,    privLabel, strlen( privLabel ) }
    };

    pPublicKeyTempalte = publicKeyTemplate;
    ulPublicKeyAttributeCount = sizeof( publicKeyTemplate ) / sizeof( CK_ATTRIBUTE );

    pPrivateKeyTemplate = privateKeyTemplate;
    ulPrivateKeyAttributeCount = sizeof( privateKeyTemplate ) / sizeof( CK_ATTRIBUTE );

    CK_RV rv = pxGlobalFunctionList->C_GenerateKeyPair( hSession, pMechansim, pPublicKeyTempalte, ulPublicKeyAttributeCount, pPrivateKeyTemplate, ulPrivateKeyAttributeCount, phPublicKey, phPrivateKey );

    TEST_ASSERT_EQUAL( CKR_CRYPTOKI_NOT_INITIALIZED, rv );
}
