include("${CMAKE_CURRENT_LIST_DIR}/afr_utils.cmake")
set(AFR_VENDORS_DIR "${AFR_ROOT_DIR}/vendors")
file(REMOVE "${AFR_ROOT_DIR}/cmake_supported_boards.yml")
set(cmake_supported_boards_file "${AFR_ROOT_DIR}/cmake_supported_boards.yml")

afr_get_vendors(vendors)
file(APPEND "${cmake_supported_boards_file}" "vendors:\n")

foreach(vendor IN LISTS vendors)
    file(APPEND "${cmake_supported_boards_file}" "- vendorName: ${vendor}\n")
    file(APPEND "${cmake_supported_boards_file}" "  vendorPath: vendors/${vendor}\n")
    file(APPEND "${cmake_supported_boards_file}" "  boards:\n")
    afr_get_vendor_boards("${vendor}" boards)
    foreach(board IN LISTS boards)
        if("${board}" STREQUAL "linux")
            continue()
        endif()
        file(APPEND "${cmake_supported_boards_file}" "   - boardName: ${board}\n")
        include("${AFR_VENDORS_DIR}/${vendor}/manifest.cmake")
        if(DEFINED AFR_MANIFEST_BOARD_DIR_${board})
            file(APPEND "${cmake_supported_boards_file}" "     boardPath: ${AFR_MANIFEST_BOARD_DIR_${board}}\n")
        else()
            file(APPEND "${cmake_supported_boards_file}" "     boardPath: ${AFR_MANIFEST_BOARD_DIR}/${board}\n")
        endif()
    endforeach()
endforeach()
