/*
 * Copyright 2021 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef _FSL_SENSOR_COMMON_H_
#define _FSL_SENSOR_COMMON_H_

#include "fsl_common.h"
#include "fsl_component_i3c.h"

/*! @brief Define sensor access function. */
typedef status_t (*sensor_write_transfer_func_t)(i3c_device_t *device_handle,
                                                 uint32_t regAddress,
                                                 uint8_t *regData,
                                                 size_t dataSize);
typedef status_t (*sensor_read_transfer_func_t)(i3c_device_t *device_handle,
                                                uint32_t regAddress,
                                                uint8_t *regData,
                                                size_t dataSize);


#if defined(__cplusplus)
extern "C" {
#endif

#if defined(__cplusplus)
}
#endif /* __cplusplus */

#endif /* _FSL_SENSOR_COMMON_H_ */
