/*
Copyright 2018 Embedded Microprocessor Benchmark Consortium (EEMBC)

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Original Author: Shay Gal-on
*/
/*
 * Copyright (c) 2017 - 2018 , NXP
 * All rights reserved.
 */

#include <stdio.h>
#include <stdlib.h>
#include "coremark.h"

/* added for LPC55S1x platform */
#include "fsl_common.h"
#include "fsl_clock.h"
#include "fsl_gpio.h"
#include "fsl_iocon.h"
#include "fsl_usart.h"
#include "fsl_power.h"
#include "clock_config.h"
#include "pin_mux.h"
#include "board.h"
#include <stdbool.h>

/* User should consider ITERATIONS values */
#define ITERATIONS 4000

#define RESULT_OUTPUT 1

#define SYST_CVR_ADDR 0xE000E018
#define SYST_CSR_ADDR 0xE000E010

#define REG(addr) (*((volatile unsigned*) (addr)))

#if VALIDATION_RUN
  volatile ee_s32 seed1_volatile=0x3415;
  volatile ee_s32 seed2_volatile=0x3415;
  volatile ee_s32 seed3_volatile=0x66;
#endif
#if PERFORMANCE_RUN
  volatile ee_s32 seed1_volatile=0x0;
  volatile ee_s32 seed2_volatile=0x0;
  volatile ee_s32 seed3_volatile=0x66;
#endif
#if PROFILE_RUN
  volatile ee_s32 seed1_volatile=0x8;
  volatile ee_s32 seed2_volatile=0x8;
  volatile ee_s32 seed3_volatile=0x8;
#endif
  volatile ee_s32 seed4_volatile=ITERATIONS;
  volatile ee_s32 seed5_volatile=0;
  
/* Porting : Timing functions
   How to capture time and convert to seconds must be ported to whatever is supported by the platform.
   e.g. Read value from on board RTC, read value from cpu clock cycles performance counter etc. 
   Sample implementation for standard time.h and windows.h definitions included.
*/
  
/* Porting : Timing functions
	How to capture time and convert to seconds must be ported to whatever is supported by the platform.
	e.g. Read value from on board RTC, read value from cpu clock cycles performance counter etc. 
	Sample implementation for standard time.h and windows.h definitions included.
*/
CORETIMETYPE barebones_clock() {
///	#error "You must implement a method to measure time in barebones_clock()! This function should return current time.\r\n"
//	return TIM32_0->TC;
//	return 1;
//	int cvr, csr;
//	cvr = REG(SYST_CVR_ADDR);
//	csr = REG(SYST_CSR_ADDR);
//	rtr = (csr(16)<<31) | (csr(2)<<30) | (csr(1)<<29) | (csr (0)<<28) | cvr(23:0);
//	return rtr;
	return REG(SYST_CVR_ADDR); 
}
/* Define : TIMER_RES_DIVIDER
	Divider to trade off timer resolution and total time that can be measured.

	Use lower values to increase resolution, but make sure that overflow does not occur.
	If there are issues with the return value overflowing, increase this value.
	*/
#define GETMYTIME(_t) (*_t=barebones_clock())

// #define MYTIMEDIFF(fin,ini) ((fin)-(ini))
CORETIMETYPE MYTIMEDIFF(CORETIMETYPE fin, CORETIMETYPE ini)
{
    /* ARM Systick is 24 bits wide down counter */

    CORETIMETYPE ini_int = ini & 0x00FFFFFF;
    CORETIMETYPE fin_int = fin & 0x00FFFFFF;

    return (ini_int - fin_int);
}
#define TIMER_RES_DIVIDER 1
#define SAMPLE_TIME_IMPLEMENTATION 1
#define CLOCK_PER_SEC_LPC55 1000000
#define EE_TICKS_PER_SEC (CLOCK_PER_SEC_LPC55 / TIMER_RES_DIVIDER)

/** Define Host specific (POSIX), or target specific global time variables. */
static CORETIMETYPE start_time_val, stop_time_val;

/* Function : start_time
	This function will be called right before starting the timed portion of the benchmark.

	Implementation may be capturing a system timer (as implemented in the example code) 
	or zeroing some system parameters - e.g. setting the cpu clocks cycles to 0.
*/
void start_time(void) {
	GETMYTIME(&start_time_val);      
}
/* Function : stop_time
	This function will be called right after ending the timed portion of the benchmark.

	Implementation may be capturing a system timer (as implemented in the example code) 
	or other system parameters - e.g. reading the current value of cpu cycles counter.
*/
void stop_time(void) {
	GETMYTIME(&stop_time_val);      
}
/* Function : get_time
	Return an abstract "ticks" number that signifies time on the system.
	
	Actual value returned may be cpu cycles, milliseconds or any other value,
	as long as it can be converted to seconds by <time_in_secs>.
	This methodology is taken to accomodate any hardware or simulated platform.
	The sample implementation returns millisecs by default, 
	and the resolution is controlled by <TIMER_RES_DIVIDER>
*/
CORE_TICKS get_time(void) {
	CORE_TICKS elapsed=(CORE_TICKS)(MYTIMEDIFF(stop_time_val, start_time_val));
	return elapsed;
}
/* Function : time_in_secs
	Convert the value returned by get_time to seconds.

	The <secs_ret> type is used to accomodate systems with no support for floating point.
	Default implementation implemented by the EE_TICKS_PER_SEC macro above.
*/
secs_ret time_in_secs(CORE_TICKS ticks) {
	secs_ret retval=((secs_ret)ticks) / ((secs_ret)EE_TICKS_PER_SEC);
	return retval;
}

ee_u32 default_num_contexts=1;
//#define  FLASH_SETTING   ( (0x01 << 5))
/* Function : portable_init
   Target specific initialization code 
   Test for some common mistakes.
*/

void portable_init(core_portable *p, int *argc, char *argv[])
{
    /* added intialize function here for LPC5500 */
    usart_config_t config;
    volatile uint8_t s_CmdRecv = 0;

  
    /* Enables the clock for the IOCON block. 0 = Disable; 1 = Enable.: 0x01u */
    CLOCK_EnableClock(kCLOCK_Iocon);
    /* Debug Usart Pin Init */
    IOCON->PIO[0][30] = (IOCON_FUNC1 | IOCON_MODE_INACT  | IOCON_DIGITAL_EN |  IOCON_PIO_SLEW(0) );  // Debug Usart TXD pin
    IOCON->PIO[0][29] = (IOCON_FUNC1 | IOCON_MODE_INACT  | IOCON_DIGITAL_EN |  IOCON_PIO_SLEW(0) );  // Debug Usart TXD pin
    CLOCK_DisableClock(kCLOCK_Iocon);
    /* attach 12 MHz clock to FLEXCOMM0 (debug console) */
    CLOCK_AttachClk(kFRO12M_to_FLEXCOMM0);
    /*
     * config.baudRate_Bps = 115200U;
     * config.parityMode = kUSART_ParityDisabled;
     * config.stopBitCount = kUSART_OneStopBit;
     * config.loopback = false;
     * config.enableTx = false;
     * config.enableRx = false;
     */
    USART_GetDefaultConfig(&config);
    config.baudRate_Bps = 115200;
    config.enableTx = true;
    config.enableRx = true;
    USART_Init(USART0, &config, 12000000);
    
#ifdef RUN_ON_RAMX
    /* Re-allicate interrput VTOR table to SRAM-0 */
    memcpy((uint32_t*)0x20004000, (uint32_t*)SCB->VTOR, 0x400);
    SCB->VTOR = (uint32_t)0x20004000;
#endif
    
    ee_printf("\r\nLPC55S3x CoreMark Test Program Start\r\n");
    ee_printf("Please Select CorePower Source 0/1\r\n");
    ee_printf("0 - DCDC\r\n");
    ee_printf("1 - LDOCoreHP\r\n");
    USART_ReadBlocking(USART0, (uint8_t *)&s_CmdRecv, 1);

#ifdef RUN_ON_FLASH
    if(s_CmdRecv == '0')
    {
       POWER_SetCorePowerSource(kPOWER_CoreSrcDCDC);
       ee_printf("CorePower Source: DCDC\r\n");
       ee_printf("Please Select Core Freqency first by input 1/2/3/4/5/6/7/8\r\n");
       ee_printf("1 - 12MHz  Running on Flash with cache\r\n");
       ee_printf("2 - 96MHz  Running on Flash with cache\r\n");
       ee_printf("3 - 100MHz Running on Flash with cache\r\n");
       ee_printf("4 - 150MHz Running on Flash with cache\r\n");
       ee_printf("5 - 12MHz  Running on Flash without cache\r\n");
       ee_printf("6 - 96MHz  Running on Flash without cache\r\n");
       ee_printf("7 - 100MHz Running on Flash without cache\r\n");
       ee_printf("8 - 150MHz Running on Flash without cache\r\n");
    }
    if(s_CmdRecv == '1')
    {
       POWER_SetCorePowerSource(kPOWER_CoreSrcLDOCoreHP);
       ee_printf("CorePower Source: LDOCoreHP\r\n");
       ee_printf("Please Select Core Freqency first by input 1/2/3/4/5/6/7/8\r\n");
       ee_printf("1 - 12MHz  Running on Flash with cache\r\n");
       ee_printf("2 - 96MHz  Running on Flash with cache\r\n");
       ee_printf("3 - 100MHz Running on Flash with cache\r\n");
       ee_printf("4 - 150MHz Running on Flash with cache\r\n");
       ee_printf("5 - 12MHz  Running on Flash without cache\r\n");
       ee_printf("6 - 96MHz  Running on Flash without cache\r\n");
       ee_printf("7 - 100MHz Running on Flash without cache\r\n");
       ee_printf("8 - 150MHz Running on Flash without cache\r\n");
    }

#endif

#ifdef RUN_ON_RAMX
    if(s_CmdRecv == '0')
    {
       POWER_SetCorePowerSource(kPOWER_CoreSrcDCDC);
       ee_printf("Please Select Core Freqency first by input 1/2/3/4\r\n");
       ee_printf("1 - 12MHz  Running on SRAM-X \r\n");
       ee_printf("2 - 96MHz  Running on SRAM-X \r\n");
       ee_printf("3 - 100MHz Running on SRAM-X \r\n");
       ee_printf("4 - 150MHz Running on SRAM-X \r\n");
    }
    if(s_CmdRecv == '1')
    {
       POWER_SetCorePowerSource(kPOWER_CoreSrcLDOCoreHP);
       ee_printf("Please Select Core Freqency first by input 1/2/3/4\r\n");
       ee_printf("1 - 12MHz  Running on SRAM-X \r\n");
       ee_printf("2 - 96MHz  Running on SRAM-X \r\n");
       ee_printf("3 - 100MHz Running on SRAM-X \r\n");
       ee_printf("4 - 150MHz Running on SRAM-X \r\n");
    }
#endif
  //  USART_ReadBlocking(USART0, (uint8_t *)&s_CmdRecv, 1);
    
   
    /* Set System Clock to 12 MHz :
    * - Switch Main clock to FRO 12 MHz
    * - Set Main clock divider to 'divide by 1
    * - Disable FRO96MHz 
    * - Switch off DTRNG clocks
    */    
    CLOCK_AttachClk(kFRO12M_to_MAIN_CLK);
    CLOCK_SetClkDiv(kCLOCK_DivAhbClk, 1, 0);    
    ANACTRL->FRO192M_CTRL = ANACTRL->FRO192M_CTRL & (~ANACTRL_FRO192M_CTRL_ENA_96MHZCLK_MASK); /* Disable 96 MHz clock source */      
    #define SYSCON_CSS_CLK_CTRL_CLR_REG (*((volatile unsigned int *)(0x400009B8)))
    SYSCON_CSS_CLK_CTRL_CLR_REG = (1U << 1); /* Switch off DTRNG clocks */
    
    /* Enable Automatic Clock gating (for all modules) */    
    SYSCON->AUTOCLKGATEOVERRIDE  = 0xC0DE0000;
  
    /* Enable clocks only for all modules required at boot time */
    SYSCON->AHBCLKCTRL0 = SYSCON_AHBCLKCTRL0_ROM_MASK | SYSCON_AHBCLKCTRL0_SRAM_CTRL1_MASK | SYSCON_AHBCLKCTRL0_SRAM_CTRL2_MASK |
                          SYSCON_AHBCLKCTRL0_SRAM_CTRL3_MASK | SYSCON_AHBCLKCTRL0_SRAM_CTRL4_MASK | SYSCON_AHBCLKCTRL0_FLASH_MASK | SYSCON_AHBCLKCTRL0_FMC_MASK;
    /* Flexcomm 0 */
    SYSCON->AHBCLKCTRL1 = SYSCON_AHBCLKCTRL1_FC0_MASK ;

    /* Analog Controller */
    SYSCON->AHBCLKCTRL2 = SYSCON_AHBCLKCTRL2_ANALOG_CTRL_MASK;
    
    /* Set Core power supply source*/    
//    POWER_SetCorePowerSource(kPOWER_CoreSrcLDOCoreHP);
    
    USART_ReadBlocking(USART0, (uint8_t *)&s_CmdRecv, 1);
    if(s_CmdRecv == '1')
    {
        BOARD_BootClockFRO12M();     /* Set Main Freq as 12MHz */
        seed4_volatile = 500;
#ifdef RUN_ON_FLASH
        /* Enable Flash Cache */
        SYSCON->LPCAC_CTRL = 0;
#endif
    }
    if(s_CmdRecv == '2')
    {
        BOARD_BootClockFROHF96M();   /* Set Main Freq as 96MHz */
        seed4_volatile = 4000;
#ifdef RUN_ON_FLASH
        /* Enable Flash Cache */
        SYSCON->LPCAC_CTRL = 0;
#endif
    }
    if(s_CmdRecv == '3')
    {
        BOARD_BootClockPLL100M();    /* Set Main Freq as 100MHz */
        seed4_volatile = 5000;
#ifdef RUN_ON_FLASH
        /* Enable Flash Cache */
        SYSCON->LPCAC_CTRL = 0;
#endif
    } 
    if(s_CmdRecv == '4')
    {
        BOARD_BootClockPLL150M();    /* Set Main Freq as 150MHz */
        seed4_volatile = 7000;
#ifdef RUN_ON_FLASH 
        /* Enable Flash Cache */
        SYSCON->LPCAC_CTRL = 0;
#endif
    }
    if(s_CmdRecv == '5')
    {
        BOARD_BootClockFRO12M();    /* Set Main Freq as 12MHz */
        seed4_volatile = 600;
#ifdef RUN_ON_FLASH

        SYSCON->LPCAC_CTRL |= SYSCON_LPCAC_CTRL_DIS_LPCAC_MASK;
        SYSCON->LPCAC_CTRL |= SYSCON_LPCAC_CTRL_CLR_LPCAC_MASK;
#endif
        ee_printf("Flash Cache Disable\r\n");
    }
    if(s_CmdRecv == '6')
    {
        BOARD_BootClockFROHF96M();    /* Set Main Freq as 96MHz */
        seed4_volatile = 3500;
#ifdef RUN_ON_FLASH

        SYSCON->LPCAC_CTRL |= SYSCON_LPCAC_CTRL_DIS_LPCAC_MASK;
        SYSCON->LPCAC_CTRL |= SYSCON_LPCAC_CTRL_CLR_LPCAC_MASK;
#endif
        ee_printf("Flash Cache Disable\r\n");
    }
    if(s_CmdRecv == '7')
    {
        BOARD_BootClockPLL100M();    /* Set Main Freq as 100MHz */
        seed4_volatile = 3700;
#ifdef RUN_ON_FLASH
 
        SYSCON->LPCAC_CTRL |= SYSCON_LPCAC_CTRL_DIS_LPCAC_MASK;
        SYSCON->LPCAC_CTRL |= SYSCON_LPCAC_CTRL_CLR_LPCAC_MASK;
#endif
        ee_printf("Flash Cache Disable\r\n");
    }
    if(s_CmdRecv == '8')
    {
        BOARD_BootClockPLL150M();    /* Set Main Freq as 150MHz */
        seed4_volatile = 4200;
#ifdef RUN_ON_FLASH

        SYSCON->LPCAC_CTRL |= SYSCON_LPCAC_CTRL_DIS_LPCAC_MASK;
        SYSCON->LPCAC_CTRL |= SYSCON_LPCAC_CTRL_CLR_LPCAC_MASK;
#endif
        ee_printf("Flash Cache Disable\r\n");
    }

    /* Update System Frequency Value */
//    SystemCoreClockUpdate();

    /* 
     * Configure the CPU Systick clock source : Select FRO 1-MHz
     * FRO 1-MHz is chosen so that system frequency change will not 
     * impact the tick rate.
     * (Required by N4APWR_WaitUs() and N4APWR_WaitMs() functions)
     */
    SYSCON->CLOCK_CTRL      |= SYSCON_CLOCK_CTRL_FRO1MHZ_CLK_ENA_MASK;
    SYSCON->SYSTICKCLKSEL0   = SYSCON_SYSTICKCLKSEL0_SEL(1); /* Select FRO 1 MHz */
    SYSCON->SYSTICKCLKDIV[0] = SYSCON_SYSTICKCLKDIV_HALT(0) | SYSCON_SYSTICKCLKDIV_DIV(0); /* Divided by 1, clock running */   
    
    /* Initializes the CORTEX-M33 Systick (used in COREMARK) */
    SysTick->CTRL = 0x0;           /* Disable SysTick                     */
    SysTick->LOAD = 0xFFFFFF;      /* Set Reload value                    */
    SysTick->VAL  = 0x0;           /* Clear current value to 0            */
    SysTick->CTRL = 0x1;           /* Enable SysTick, use external clock */
    
    /* Print main clock frequency information */ 
    ee_printf("SystemCoreClock: %d", SystemCoreClock);

    if (sizeof(ee_ptr_int) != sizeof(ee_u8 *)) {
        ee_printf("ERROR! Please define ee_ptr_int to a type that holds a pointer!\n");
    }
    if (sizeof(ee_u32) != 4) {
        ee_printf("ERROR! Please define ee_u32 to a 32b unsigned type!\n");
    }
    p->portable_id=1;

    /* If peripherals are turned on by the ROM and left on, once in the user code, if not used, they should be shut off. */		

#ifndef COREMARK_SCORE_TEST
    CLOCK_EnableClock(kCLOCK_Iocon);
    // Measurement Core average current need disable UART and restore IO Pin Status
    IOCON->PIO[0][30] &= 0xFFFFF800;
    IOCON->PIO[0][29] &= 0xFFFFF800;
    CLOCK_DisableClock(kCLOCK_Iocon);
    /* De-attach clock to FLEXCOMM0 */
    USART0->CFG &= ~(USART_CFG_ENABLE_MASK);
    CLOCK_AttachClk(kNONE_to_FLEXCOMM0);
#endif
    
}

/* Function : portable_fini
	Target specific final code 
*/
void portable_fini(core_portable *p)
{
    p->portable_id=0;
    volatile uint8_t s_CmdRecv;
#ifndef COREMARK_SCORE_TEST
    usart_config_t config;

    /* Board pin init */
    /* Enables the clock for the IOCON block. 0 = Disable; 1 = Enable.: 0x01u */
    CLOCK_EnableClock(kCLOCK_Iocon);
    /* Debug Usart Pin Init */
    IOCON->PIO[0][30] = (IOCON_FUNC1 | IOCON_MODE_INACT  | IOCON_DIGITAL_EN |  IOCON_PIO_SLEW(0) );  // Debug Usart TXD pin
    IOCON->PIO[0][29] = (IOCON_FUNC1 | IOCON_MODE_INACT  | IOCON_DIGITAL_EN |  IOCON_PIO_SLEW(0) );  // Debug Usart TXD pin
    CLOCK_DisableClock(kCLOCK_Iocon);
    /* attach 12 MHz clock to FLEXCOMM0 (debug console) */
    CLOCK_AttachClk(kFRO12M_to_FLEXCOMM0);
    /*
     * config.baudRate_Bps = 115200U;
     * config.parityMode = kUSART_ParityDisabled;
     * config.stopBitCount = kUSART_OneStopBit;
     * config.loopback = false;
     * config.enableTx = false;
     * config.enableRx = false;
     */
    USART_GetDefaultConfig(&config);
    config.baudRate_Bps = 115200;
    config.enableTx = true;
    config.enableRx = true;
    USART_Init(USART0, &config, 12000000);
#endif
    ee_printf("Test DONE, Press anykey to start again\r\n");
    USART_ReadBlocking(USART0, (uint8_t *)&s_CmdRecv, 1);
//    NVIC_SystemReset();     /* Reboot System */

    while(1)
   {
        __WFI();
    }
}

// end file
