/*
 * Copyright 2020 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#include "frequency_response.h"

static float32_t window[STFT_TAPS_SIZE];
static int16_t freq_response[STFT_TAPS_SIZE + 1];


void init_window(void) {
	int32_t i = 0;
	/* Hamming window */
	while(i < STFT_TAPS_SIZE)
	{
		window[i++] = 0.54 + 0.46 * scl_cosinef(2*3.1416*i/(STFT_TAPS_SIZE - 1) + 3.1416);
	}
}

void apply_window(int16_t *pAudio)
{
	int32_t i = 0;
	while(i < STFT_TAPS_SIZE) {
		float32_t f = window[i] * pAudio[i];
		pAudio[i++] = scl_float2int(f, 0);
	}
}

void audio_frequency_response(int16_t *pAudio, int32_t samplerate, AudioFreqResp *pfr, int32_t freq_num)
{
	float bw_scale = (samplerate >> 1)/4096.0;
	int32_t i, slot;
	fft_real16x16(freq_response, pAudio, rfft16_4096, 3);
	for (i = 0; i < freq_num; i++) {
        slot = pfr[i].samplerate / bw_scale + 0.5;
        pfr[i].volume = abs(freq_response[slot]);
	}

}

