/*
 * Copyright 2020 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */
 
#ifndef AUDIO_FREQUENCY_RESPONSE
#define AUDIO_FREQUENCY_RESPONSE

#include "NatureDSP_types.h"
#include "NatureDSP_Signal.h"

#define STFT_TAPS_SIZE (4096) // 4096 samples

typedef struct _AudioFreqResp {
    int32_t samplerate;
    int32_t volume;
} AudioFreqResp;

void init_window(void);
void apply_window(int16_t *pAudio);
void audio_frequency_response(int16_t *pAudio, int32_t samplerate, AudioFreqResp *pfr, int32_t freq_num);

#endif

