/*
 * Copyright 2019 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef AUDIO_RING_BUFFER_H
#define AUDIO_RING_BUFFER_H

#include "fsl_common.h"

typedef short AudioSample;

void audiobuf_init(void);
void audiobuf_reset(void);
int32_t audiobuf_fill(AudioSample *data, uint32_t size);
int32_t audiobuf_retrive(AudioSample *data, uint32_t size);
int32_t audiobuf_data_avail(void);
int32_t audiobuf_maxsize(void);
int32_t audiobuf_retrive_dsp(AudioSample *data, uint32_t size_in_sample,uint32_t write_pt,uint32_t size);

#endif
