/*
 * Copyright 2021 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */
 
#ifndef VIT_GLUE_H
#define VIT_GLUE_H


#include "PL_platformTypes_HIFI4_FUSIONF1.h"
#include "fsl_common.h"
#include "Vit.h"
#include "PL_memoryRegion.h"

#define VIT_MODEL_ALIGNMENT 64
#define INSTALLOC_OFFSET           ((PL_UINTPTR) (VIT_MODEL_ALIGNMENT-1))
#define INSTALLOC_MASK             ((PL_UINTPTR)~INSTALLOC_OFFSET)
#define INSTALLOC_ALIGN(ptr)       (((PL_UINTPTR)ptr + INSTALLOC_OFFSET)&INSTALLOC_MASK)

typedef uint32_t UWORD32;
typedef int32_t WORD32;
typedef int16_t WORD16;
typedef uint64_t UWORD64;

/* ...API structure */
typedef struct vit_pre_proc_t
{
    /* ...pcm gain module state */
    UWORD32                 state;

    /* ...number of channels (channel mask?) */
    UWORD32                 channels;

    /* ...PCM sample width */
    UWORD32                 pcm_width;

    /* ...sampling rate */
    UWORD32                 sample_rate;

    /* ...number of bytes in input/output buffer */
    UWORD32                 buffer_size;

    /* ...input buffer */
    void               *input;

    /* ...output buffer */
    void               *output;

    /* ...scratch buffer pointer */
    void               *scratch;

    /* ...number of available bytes in the input buffer */
    UWORD32                 input_avail;

    /* ...number of bytes consumed from input buffer */
    UWORD32                 consumed;

    /* ...number of produced bytes */
    UWORD32                 produced;

    UWORD32 frame_size_us;

}   vit_pre_proc_t;

int32_t xa_vit_pre_proc_do_execute_16bit(vit_pre_proc_t *d);
VIT_ReturnStatus_en VIT_Initialize(vit_pre_proc_t *d);

#endif

