/*
 * Copyright 2020 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */
 
#ifndef AUDIO_CAPTURE_RENDER_H
#define AUDIO_CAPTURE_RENDER_H

#ifdef __XCC__
#include <xtensa/config/core.h>
#include <xtensa/xos.h>
#endif

#include "fsl_common.h"
typedef struct _AudioSource_Queue_Element
{
    int16_t *pBufAddress;
    uint32_t uBufSize;
} AudioSource_Queue_Element;
/* Different TX/RX sample rate only 
When using DMIC for audio input and audio codec for audio ouput */

#define AUDIO_RENDER_SAMPLERATE 48000
#define AUDIO_RENDER_SAMPLERATE_MS 48
#define AUDIO_RENDER_CHANNELS 2

#define AUDIO_CAPTURE_SAMPLERATE 16000
#define AUDIO_CAPTURE_SAMPLERATE_MS 16
#define AUDIO_CAPTURE_CHANNELS 1

#define AUDIO_RENDER_TRANSFER_SIZE (AUDIO_RENDER_SAMPLERATE_MS * AUDIO_RENDER_CHANNELS * 1) //1ms
#define AUDIO_CAPTURE_TRANSFER_SIZE (AUDIO_CAPTURE_SAMPLERATE_MS * AUDIO_CAPTURE_CHANNELS * 10) //1ms

#define AUDIO_SOURCE_ARM_INTERVAL (1)

#define AUDIO_RENDER_BUFFER_COUNT (2)
#define AUDIO_CAPTURE_BUFFER_COUNT (2)

#endif
