/*
 * Copyright 2019 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "pin_mux.h"
#include "clock_config.h"
#include "board.h"
#include "fsl_debug_console.h"
#include "fsl_i2s.h"
#include "dsp_support.h"
#include "fsl_power.h"
/*******************************************************************************
 * Definitions
 ******************************************************************************/


/*******************************************************************************
 * Prototypes
 ******************************************************************************/
/*******************************************************************************
 * Code
 ******************************************************************************/

void VIT_Launcher(void *Handle);
void HardFault_Handler(void);
/*!
 * @brief Main function
 */
#if defined(__CC_ARM) || (defined(__ARMCC_VERSION)) || defined(__GNUC__)
int main(void)
#else
int main(void)
#endif
{
   /* Init board hardware. */
    gpio_pin_config_t led_config = {
        kGPIO_DigitalOutput,
        0,
    };
    /* Initialize standard SDK demo application pins */
    BOARD_InitPins();
    BOARD_BootClockRUN();
    BOARD_InitDebugConsole();
    POWER_SetDeepSleepClock(kDeepSleepClk_Fro);
    CLOCK_EnableClock(kCLOCK_InputMux);
    
    GPIO_PortInit(GPIO, 0U);
    GPIO_PinInit(GPIO, 0U, 14U, &led_config);

    
    VIT_Launcher(NULL);
    
#if (defined(__CC_ARM) || (defined(__ARMCC_VERSION)) || defined(__GNUC__))
    return 1;
#endif
}



