# Copyright 2022 NXP
# SPDX-License-Identifier: MIT
# The auto-generated can only be used on NXP devices

import SDL
import utime as time
import usys as sys
import lvgl as lv
import lodepng as png
import ustruct

lv.init()
SDL.init(w=480,h=272)

# Register SDL display driver.
disp_buf1 = lv.disp_draw_buf_t()
buf1_1 = bytearray(480*10)
disp_buf1.init(buf1_1, None, len(buf1_1)//4)
disp_drv = lv.disp_drv_t()
disp_drv.init()
disp_drv.draw_buf = disp_buf1
disp_drv.flush_cb = SDL.monitor_flush
disp_drv.hor_res = 480
disp_drv.ver_res = 272
disp_drv.register()

# Regsiter SDL mouse driver
indev_drv = lv.indev_drv_t()
indev_drv.init() 
indev_drv.type = lv.INDEV_TYPE.POINTER
indev_drv.read_cb = SDL.mouse_read
indev_drv.register()

# Below: Taken from https://github.com/lvgl/lv_binding_micropython/blob/master/driver/js/imagetools.py#L22-L94

COLOR_SIZE = lv.color_t.__SIZE__
COLOR_IS_SWAPPED = hasattr(lv.color_t().ch,'green_h')

class lodepng_error(RuntimeError):
    def __init__(self, err):
        if type(err) is int:
            super().__init__(png.error_text(err))
        else:
            super().__init__(err)

# Parse PNG file header
# Taken from https://github.com/shibukawa/imagesize_py/blob/ffef30c1a4715c5acf90e8945ceb77f4a2ed2d45/imagesize.py#L63-L85

def get_png_info(decoder, src, header):
    # Only handle variable image types

    if lv.img.src_get_type(src) != lv.img.SRC.VARIABLE:
        return lv.RES.INV

    data = lv.img_dsc_t.__cast__(src).data
    if data == None:
        return lv.RES.INV

    png_header = bytes(data.__dereference__(24))

    if png_header.startswith(b'\211PNG\r\n\032\n'):
        if png_header[12:16] == b'IHDR':
            start = 16
        # Maybe this is for an older PNG version.
        else:
            start = 8
        try:
            width, height = ustruct.unpack(">LL", png_header[start:start+8])
        except ustruct.error:
            return lv.RES.INV
    else:
        return lv.RES.INV

    header.always_zero = 0
    header.w = width
    header.h = height
    header.cf = lv.img.CF.TRUE_COLOR_ALPHA

    return lv.RES.OK

def convert_rgba8888_to_bgra8888(img_view):
    for i in range(0, len(img_view), lv.color_t.__SIZE__):
        ch = lv.color_t.__cast__(img_view[i:i]).ch
        ch.red, ch.blue = ch.blue, ch.red

# Read and parse PNG file

def open_png(decoder, dsc):
    img_dsc = lv.img_dsc_t.__cast__(dsc.src)
    png_data = img_dsc.data
    png_size = img_dsc.data_size
    png_decoded = png.C_Pointer()
    png_width = png.C_Pointer()
    png_height = png.C_Pointer()
    error = png.decode32(png_decoded, png_width, png_height, png_data, png_size)
    if error:
        raise lodepng_error(error)
    img_size = png_width.int_val * png_height.int_val * 4
    img_data = png_decoded.ptr_val
    img_view = img_data.__dereference__(img_size)

    if COLOR_SIZE == 4:
        convert_rgba8888_to_bgra8888(img_view)
    else:
        raise lodepng_error("Error: Color mode not supported yet!")

    dsc.img_data = img_data
    return lv.RES.OK

# Above: Taken from https://github.com/lvgl/lv_binding_micropython/blob/master/driver/js/imagetools.py#L22-L94

decoder = lv.img.decoder_create()
decoder.info_cb = get_png_info
decoder.open_cb = open_png

def anim_x_cb(obj, v):
    obj.set_x(v)

def anim_y_cb(obj, v):
    obj.set_y(v)

def ta_event_cb(e,kb):
    code = e.get_code()
    ta = e.get_target()
    if code == lv.EVENT.FOCUSED:
        kb.set_textarea(ta)
        kb.clear_flag(lv.obj.FLAG.HIDDEN)

    if code == lv.EVENT.DEFOCUSED:
        kb.set_textarea(None)
        kb.add_flag(lv.obj.FLAG.HIDDEN)


Overview = lv.obj()
# create style style_overview_main_main_default
style_overview_main_main_default = lv.style_t()
style_overview_main_main_default.init()
style_overview_main_main_default.set_bg_color(lv.color_make(0xff,0xff,0xff))
style_overview_main_main_default.set_bg_opa(0)

# add style for Overview
Overview.add_style(style_overview_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

Overview_bg_img = lv.img(Overview)
Overview_bg_img.set_pos(0,0)
Overview_bg_img.set_size(480,272)
Overview_bg_img.add_flag(lv.obj.FLAG.CLICKABLE)
try:
    with open('C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp1436734276.png','rb') as f:
        Overview_bg_img_img_data = f.read()
except:
    print('Could not open C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp1436734276.png')
    sys.exit()

Overview_bg_img_img = lv.img_dsc_t({
  'data_size': len(Overview_bg_img_img_data),
  'header': {'always_zero': 0, 'w': 480, 'h': 272, 'cf': lv.img.CF.TRUE_COLOR_ALPHA},
  'data': Overview_bg_img_img_data
})

Overview_bg_img.set_src(Overview_bg_img_img)
Overview_bg_img.set_pivot(0,0)
Overview_bg_img.set_angle(0)
# create style style_overview_bg_img_main_main_default
style_overview_bg_img_main_main_default = lv.style_t()
style_overview_bg_img_main_main_default.init()
style_overview_bg_img_main_main_default.set_img_recolor(lv.color_make(0xff,0xff,0xff))
style_overview_bg_img_main_main_default.set_img_recolor_opa(0)
style_overview_bg_img_main_main_default.set_img_opa(255)

# add style for Overview_bg_img
Overview_bg_img.add_style(style_overview_bg_img_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

Overview_hdr_img = lv.img(Overview)
Overview_hdr_img.set_pos(0,0)
Overview_hdr_img.set_size(480,51)
Overview_hdr_img.add_flag(lv.obj.FLAG.CLICKABLE)
try:
    with open('C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp-871685027.png','rb') as f:
        Overview_hdr_img_img_data = f.read()
except:
    print('Could not open C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp-871685027.png')
    sys.exit()

Overview_hdr_img_img = lv.img_dsc_t({
  'data_size': len(Overview_hdr_img_img_data),
  'header': {'always_zero': 0, 'w': 480, 'h': 51, 'cf': lv.img.CF.TRUE_COLOR_ALPHA},
  'data': Overview_hdr_img_img_data
})

Overview_hdr_img.set_src(Overview_hdr_img_img)
Overview_hdr_img.set_pivot(0,0)
Overview_hdr_img.set_angle(0)
# create style style_overview_hdr_img_main_main_default
style_overview_hdr_img_main_main_default = lv.style_t()
style_overview_hdr_img_main_main_default.init()
style_overview_hdr_img_main_main_default.set_img_recolor(lv.color_make(0xff,0xff,0xff))
style_overview_hdr_img_main_main_default.set_img_recolor_opa(0)
style_overview_hdr_img_main_main_default.set_img_opa(255)

# add style for Overview_hdr_img
Overview_hdr_img.add_style(style_overview_hdr_img_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

Overview_date_label = lv.label(Overview)
Overview_date_label.set_pos(20,5)
Overview_date_label.set_size(100,32)
Overview_date_label.set_text("May 5, 2022")
Overview_date_label.set_long_mode(lv.label.LONG.WRAP)
Overview_date_label.set_style_text_align(lv.TEXT_ALIGN.LEFT, 0)
# create style style_overview_date_label_main_main_default
style_overview_date_label_main_main_default = lv.style_t()
style_overview_date_label_main_main_default.init()
style_overview_date_label_main_main_default.set_radius(0)
style_overview_date_label_main_main_default.set_bg_color(lv.color_make(0xff,0xff,0xff))
style_overview_date_label_main_main_default.set_bg_grad_color(lv.color_make(0xff,0xff,0xff))
style_overview_date_label_main_main_default.set_bg_grad_dir(lv.GRAD_DIR.VER)
style_overview_date_label_main_main_default.set_bg_opa(0)
style_overview_date_label_main_main_default.set_text_color(lv.color_make(0xff,0xff,0xff))
try:
    style_overview_date_label_main_main_default.set_text_font(lv.font_montserratMedium_12)
except AttributeError:
    try:
        style_overview_date_label_main_main_default.set_text_font(lv.font_montserrat_12)
    except AttributeError:
        style_overview_date_label_main_main_default.set_text_font(lv.font_montserrat_16)
style_overview_date_label_main_main_default.set_text_letter_space(1)
style_overview_date_label_main_main_default.set_pad_left(0)
style_overview_date_label_main_main_default.set_pad_right(0)
style_overview_date_label_main_main_default.set_pad_top(0)
style_overview_date_label_main_main_default.set_pad_bottom(0)

# add style for Overview_date_label
Overview_date_label.add_style(style_overview_date_label_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

Overview_time_label = lv.label(Overview)
Overview_time_label.set_pos(360,5)
Overview_time_label.set_size(100,32)
Overview_time_label.set_text("10:28 AM")
Overview_time_label.set_long_mode(lv.label.LONG.WRAP)
Overview_time_label.set_style_text_align(lv.TEXT_ALIGN.RIGHT, 0)
# create style style_overview_time_label_main_main_default
style_overview_time_label_main_main_default = lv.style_t()
style_overview_time_label_main_main_default.init()
style_overview_time_label_main_main_default.set_radius(0)
style_overview_time_label_main_main_default.set_bg_color(lv.color_make(0xff,0xff,0xff))
style_overview_time_label_main_main_default.set_bg_grad_color(lv.color_make(0xff,0xff,0xff))
style_overview_time_label_main_main_default.set_bg_grad_dir(lv.GRAD_DIR.VER)
style_overview_time_label_main_main_default.set_bg_opa(0)
style_overview_time_label_main_main_default.set_text_color(lv.color_make(0xff,0xff,0xff))
try:
    style_overview_time_label_main_main_default.set_text_font(lv.font_montserratMedium_12)
except AttributeError:
    try:
        style_overview_time_label_main_main_default.set_text_font(lv.font_montserrat_12)
    except AttributeError:
        style_overview_time_label_main_main_default.set_text_font(lv.font_montserrat_16)
style_overview_time_label_main_main_default.set_text_letter_space(1)
style_overview_time_label_main_main_default.set_pad_left(0)
style_overview_time_label_main_main_default.set_pad_right(0)
style_overview_time_label_main_main_default.set_pad_top(0)
style_overview_time_label_main_main_default.set_pad_bottom(0)

# add style for Overview_time_label
Overview_time_label.add_style(style_overview_time_label_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

Overview_sub_label = lv.label(Overview)
Overview_sub_label.set_pos(175,5)
Overview_sub_label.set_size(130,32)
Overview_sub_label.set_text("OVERVIEW")
Overview_sub_label.set_long_mode(lv.label.LONG.WRAP)
Overview_sub_label.set_style_text_align(lv.TEXT_ALIGN.LEFT, 0)
# create style style_overview_sub_label_main_main_default
style_overview_sub_label_main_main_default = lv.style_t()
style_overview_sub_label_main_main_default.init()
style_overview_sub_label_main_main_default.set_radius(0)
style_overview_sub_label_main_main_default.set_bg_color(lv.color_make(0xff,0xff,0xff))
style_overview_sub_label_main_main_default.set_bg_grad_color(lv.color_make(0xff,0xff,0xff))
style_overview_sub_label_main_main_default.set_bg_grad_dir(lv.GRAD_DIR.VER)
style_overview_sub_label_main_main_default.set_bg_opa(0)
style_overview_sub_label_main_main_default.set_text_color(lv.color_make(0xff,0xff,0xff))
try:
    style_overview_sub_label_main_main_default.set_text_font(lv.font_montserratMedium_20)
except AttributeError:
    try:
        style_overview_sub_label_main_main_default.set_text_font(lv.font_montserrat_20)
    except AttributeError:
        style_overview_sub_label_main_main_default.set_text_font(lv.font_montserrat_16)
style_overview_sub_label_main_main_default.set_text_letter_space(1)
style_overview_sub_label_main_main_default.set_pad_left(0)
style_overview_sub_label_main_main_default.set_pad_right(0)
style_overview_sub_label_main_main_default.set_pad_top(0)
style_overview_sub_label_main_main_default.set_pad_bottom(0)

# add style for Overview_sub_label
Overview_sub_label.add_style(style_overview_sub_label_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

Overview_gps_icon = lv.img(Overview)
Overview_gps_icon.set_pos(274,50)
Overview_gps_icon.set_size(28,48)
Overview_gps_icon.add_flag(lv.obj.FLAG.CLICKABLE)
try:
    with open('C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp-1179468466.png','rb') as f:
        Overview_gps_icon_img_data = f.read()
except:
    print('Could not open C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp-1179468466.png')
    sys.exit()

Overview_gps_icon_img = lv.img_dsc_t({
  'data_size': len(Overview_gps_icon_img_data),
  'header': {'always_zero': 0, 'w': 28, 'h': 48, 'cf': lv.img.CF.TRUE_COLOR_ALPHA},
  'data': Overview_gps_icon_img_data
})

Overview_gps_icon.set_src(Overview_gps_icon_img)
Overview_gps_icon.set_pivot(0,0)
Overview_gps_icon.set_angle(0)
# create style style_overview_gps_icon_main_main_default
style_overview_gps_icon_main_main_default = lv.style_t()
style_overview_gps_icon_main_main_default.init()
style_overview_gps_icon_main_main_default.set_img_recolor(lv.color_make(0xff,0xff,0xff))
style_overview_gps_icon_main_main_default.set_img_recolor_opa(0)
style_overview_gps_icon_main_main_default.set_img_opa(255)

# add style for Overview_gps_icon
Overview_gps_icon.add_style(style_overview_gps_icon_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

Overview_travelled_icon = lv.img(Overview)
Overview_travelled_icon.set_pos(244,120)
Overview_travelled_icon.set_size(21,14)
Overview_travelled_icon.add_flag(lv.obj.FLAG.CLICKABLE)
try:
    with open('C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp1575784982.png','rb') as f:
        Overview_travelled_icon_img_data = f.read()
except:
    print('Could not open C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp1575784982.png')
    sys.exit()

Overview_travelled_icon_img = lv.img_dsc_t({
  'data_size': len(Overview_travelled_icon_img_data),
  'header': {'always_zero': 0, 'w': 21, 'h': 14, 'cf': lv.img.CF.TRUE_COLOR_ALPHA},
  'data': Overview_travelled_icon_img_data
})

Overview_travelled_icon.set_src(Overview_travelled_icon_img)
Overview_travelled_icon.set_pivot(0,0)
Overview_travelled_icon.set_angle(0)
# create style style_overview_travelled_icon_main_main_default
style_overview_travelled_icon_main_main_default = lv.style_t()
style_overview_travelled_icon_main_main_default.init()
style_overview_travelled_icon_main_main_default.set_img_recolor(lv.color_make(0xff,0xff,0xff))
style_overview_travelled_icon_main_main_default.set_img_recolor_opa(0)
style_overview_travelled_icon_main_main_default.set_img_opa(255)

# add style for Overview_travelled_icon
Overview_travelled_icon.add_style(style_overview_travelled_icon_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

Overview_speed_icon = lv.img(Overview)
Overview_speed_icon.set_pos(360,120)
Overview_speed_icon.set_size(23,17)
Overview_speed_icon.add_flag(lv.obj.FLAG.CLICKABLE)
try:
    with open('C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp1164908543.png','rb') as f:
        Overview_speed_icon_img_data = f.read()
except:
    print('Could not open C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp1164908543.png')
    sys.exit()

Overview_speed_icon_img = lv.img_dsc_t({
  'data_size': len(Overview_speed_icon_img_data),
  'header': {'always_zero': 0, 'w': 23, 'h': 17, 'cf': lv.img.CF.TRUE_COLOR_ALPHA},
  'data': Overview_speed_icon_img_data
})

Overview_speed_icon.set_src(Overview_speed_icon_img)
Overview_speed_icon.set_pivot(0,0)
Overview_speed_icon.set_angle(0)
# create style style_overview_speed_icon_main_main_default
style_overview_speed_icon_main_main_default = lv.style_t()
style_overview_speed_icon_main_main_default.init()
style_overview_speed_icon_main_main_default.set_img_recolor(lv.color_make(0xff,0xff,0xff))
style_overview_speed_icon_main_main_default.set_img_recolor_opa(0)
style_overview_speed_icon_main_main_default.set_img_opa(255)

# add style for Overview_speed_icon
Overview_speed_icon.add_style(style_overview_speed_icon_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

Overview_remaining_icon = lv.img(Overview)
Overview_remaining_icon.set_pos(244,183)
Overview_remaining_icon.set_size(20,20)
Overview_remaining_icon.add_flag(lv.obj.FLAG.CLICKABLE)
try:
    with open('C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp-2116477785.png','rb') as f:
        Overview_remaining_icon_img_data = f.read()
except:
    print('Could not open C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp-2116477785.png')
    sys.exit()

Overview_remaining_icon_img = lv.img_dsc_t({
  'data_size': len(Overview_remaining_icon_img_data),
  'header': {'always_zero': 0, 'w': 20, 'h': 20, 'cf': lv.img.CF.TRUE_COLOR_ALPHA},
  'data': Overview_remaining_icon_img_data
})

Overview_remaining_icon.set_src(Overview_remaining_icon_img)
Overview_remaining_icon.set_pivot(0,0)
Overview_remaining_icon.set_angle(0)
# create style style_overview_remaining_icon_main_main_default
style_overview_remaining_icon_main_main_default = lv.style_t()
style_overview_remaining_icon_main_main_default.init()
style_overview_remaining_icon_main_main_default.set_img_recolor(lv.color_make(0xff,0xff,0xff))
style_overview_remaining_icon_main_main_default.set_img_recolor_opa(0)
style_overview_remaining_icon_main_main_default.set_img_opa(255)

# add style for Overview_remaining_icon
Overview_remaining_icon.add_style(style_overview_remaining_icon_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

Overview_elapsed_icon = lv.img(Overview)
Overview_elapsed_icon.set_pos(360,183)
Overview_elapsed_icon.set_size(20,25)
Overview_elapsed_icon.add_flag(lv.obj.FLAG.CLICKABLE)
try:
    with open('C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp1992887665.png','rb') as f:
        Overview_elapsed_icon_img_data = f.read()
except:
    print('Could not open C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp1992887665.png')
    sys.exit()

Overview_elapsed_icon_img = lv.img_dsc_t({
  'data_size': len(Overview_elapsed_icon_img_data),
  'header': {'always_zero': 0, 'w': 20, 'h': 25, 'cf': lv.img.CF.TRUE_COLOR_ALPHA},
  'data': Overview_elapsed_icon_img_data
})

Overview_elapsed_icon.set_src(Overview_elapsed_icon_img)
Overview_elapsed_icon.set_pivot(0,0)
Overview_elapsed_icon.set_angle(0)
# create style style_overview_elapsed_icon_main_main_default
style_overview_elapsed_icon_main_main_default = lv.style_t()
style_overview_elapsed_icon_main_main_default.init()
style_overview_elapsed_icon_main_main_default.set_img_recolor(lv.color_make(0xff,0xff,0xff))
style_overview_elapsed_icon_main_main_default.set_img_recolor_opa(0)
style_overview_elapsed_icon_main_main_default.set_img_opa(255)

# add style for Overview_elapsed_icon
Overview_elapsed_icon.add_style(style_overview_elapsed_icon_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

Overview_dist_label = lv.label(Overview)
Overview_dist_label.set_pos(320,45)
Overview_dist_label.set_size(100,32)
Overview_dist_label.set_text("3.1 KM")
Overview_dist_label.set_long_mode(lv.label.LONG.WRAP)
Overview_dist_label.set_style_text_align(lv.TEXT_ALIGN.LEFT, 0)
# create style style_overview_dist_label_main_main_default
style_overview_dist_label_main_main_default = lv.style_t()
style_overview_dist_label_main_main_default.init()
style_overview_dist_label_main_main_default.set_radius(0)
style_overview_dist_label_main_main_default.set_bg_color(lv.color_make(0xff,0xff,0xff))
style_overview_dist_label_main_main_default.set_bg_grad_color(lv.color_make(0xff,0xff,0xff))
style_overview_dist_label_main_main_default.set_bg_grad_dir(lv.GRAD_DIR.VER)
style_overview_dist_label_main_main_default.set_bg_opa(0)
style_overview_dist_label_main_main_default.set_text_color(lv.color_make(0xff,0xff,0xff))
try:
    style_overview_dist_label_main_main_default.set_text_font(lv.font_montserratMedium_28)
except AttributeError:
    try:
        style_overview_dist_label_main_main_default.set_text_font(lv.font_montserrat_28)
    except AttributeError:
        style_overview_dist_label_main_main_default.set_text_font(lv.font_montserrat_16)
style_overview_dist_label_main_main_default.set_text_letter_space(1)
style_overview_dist_label_main_main_default.set_pad_left(0)
style_overview_dist_label_main_main_default.set_pad_right(0)
style_overview_dist_label_main_main_default.set_pad_top(0)
style_overview_dist_label_main_main_default.set_pad_bottom(0)

# add style for Overview_dist_label
Overview_dist_label.add_style(style_overview_dist_label_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

Overview_dir_label = lv.label(Overview)
Overview_dir_label.set_pos(320,73)
Overview_dir_label.set_size(100,32)
Overview_dir_label.set_text("Turn right to")
Overview_dir_label.set_long_mode(lv.label.LONG.WRAP)
Overview_dir_label.set_style_text_align(lv.TEXT_ALIGN.LEFT, 0)
# create style style_overview_dir_label_main_main_default
style_overview_dir_label_main_main_default = lv.style_t()
style_overview_dir_label_main_main_default.init()
style_overview_dir_label_main_main_default.set_radius(0)
style_overview_dir_label_main_main_default.set_bg_color(lv.color_make(0xff,0xff,0xff))
style_overview_dir_label_main_main_default.set_bg_grad_color(lv.color_make(0xff,0xff,0xff))
style_overview_dir_label_main_main_default.set_bg_grad_dir(lv.GRAD_DIR.VER)
style_overview_dir_label_main_main_default.set_bg_opa(0)
style_overview_dir_label_main_main_default.set_text_color(lv.color_make(0x9e,0x9e,0x9e))
try:
    style_overview_dir_label_main_main_default.set_text_font(lv.font_montserratMedium_12)
except AttributeError:
    try:
        style_overview_dir_label_main_main_default.set_text_font(lv.font_montserrat_12)
    except AttributeError:
        style_overview_dir_label_main_main_default.set_text_font(lv.font_montserrat_16)
style_overview_dir_label_main_main_default.set_text_letter_space(0)
style_overview_dir_label_main_main_default.set_pad_left(0)
style_overview_dir_label_main_main_default.set_pad_right(0)
style_overview_dir_label_main_main_default.set_pad_top(0)
style_overview_dir_label_main_main_default.set_pad_bottom(0)

# add style for Overview_dir_label
Overview_dir_label.add_style(style_overview_dir_label_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

Overview_str_label = lv.label(Overview)
Overview_str_label.set_pos(320,87)
Overview_str_label.set_size(120,32)
Overview_str_label.set_text("Ed Bluestein Blvd")
Overview_str_label.set_long_mode(lv.label.LONG.WRAP)
Overview_str_label.set_style_text_align(lv.TEXT_ALIGN.LEFT, 0)
# create style style_overview_str_label_main_main_default
style_overview_str_label_main_main_default = lv.style_t()
style_overview_str_label_main_main_default.init()
style_overview_str_label_main_main_default.set_radius(0)
style_overview_str_label_main_main_default.set_bg_color(lv.color_make(0xff,0xff,0xff))
style_overview_str_label_main_main_default.set_bg_grad_color(lv.color_make(0xff,0xff,0xff))
style_overview_str_label_main_main_default.set_bg_grad_dir(lv.GRAD_DIR.VER)
style_overview_str_label_main_main_default.set_bg_opa(0)
style_overview_str_label_main_main_default.set_text_color(lv.color_make(0xcc,0xcc,0xcc))
try:
    style_overview_str_label_main_main_default.set_text_font(lv.font_montserratMedium_12)
except AttributeError:
    try:
        style_overview_str_label_main_main_default.set_text_font(lv.font_montserrat_12)
    except AttributeError:
        style_overview_str_label_main_main_default.set_text_font(lv.font_montserrat_16)
style_overview_str_label_main_main_default.set_text_letter_space(0)
style_overview_str_label_main_main_default.set_pad_left(0)
style_overview_str_label_main_main_default.set_pad_right(0)
style_overview_str_label_main_main_default.set_pad_top(0)
style_overview_str_label_main_main_default.set_pad_bottom(0)

# add style for Overview_str_label
Overview_str_label.add_style(style_overview_str_label_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

Overview_info1_label_1 = lv.label(Overview)
Overview_info1_label_1.set_pos(274,116)
Overview_info1_label_1.set_size(60,32)
Overview_info1_label_1.set_text("Distance")
Overview_info1_label_1.set_long_mode(lv.label.LONG.WRAP)
Overview_info1_label_1.set_style_text_align(lv.TEXT_ALIGN.LEFT, 0)
# create style style_overview_info1_label_1_main_main_default
style_overview_info1_label_1_main_main_default = lv.style_t()
style_overview_info1_label_1_main_main_default.init()
style_overview_info1_label_1_main_main_default.set_radius(0)
style_overview_info1_label_1_main_main_default.set_bg_color(lv.color_make(0xff,0xff,0xff))
style_overview_info1_label_1_main_main_default.set_bg_grad_color(lv.color_make(0xff,0xff,0xff))
style_overview_info1_label_1_main_main_default.set_bg_grad_dir(lv.GRAD_DIR.VER)
style_overview_info1_label_1_main_main_default.set_bg_opa(0)
style_overview_info1_label_1_main_main_default.set_text_color(lv.color_make(0x9e,0x9e,0x9e))
try:
    style_overview_info1_label_1_main_main_default.set_text_font(lv.font_montserratMedium_12)
except AttributeError:
    try:
        style_overview_info1_label_1_main_main_default.set_text_font(lv.font_montserrat_12)
    except AttributeError:
        style_overview_info1_label_1_main_main_default.set_text_font(lv.font_montserrat_16)
style_overview_info1_label_1_main_main_default.set_text_letter_space(0)
style_overview_info1_label_1_main_main_default.set_pad_left(0)
style_overview_info1_label_1_main_main_default.set_pad_right(0)
style_overview_info1_label_1_main_main_default.set_pad_top(0)
style_overview_info1_label_1_main_main_default.set_pad_bottom(0)

# add style for Overview_info1_label_1
Overview_info1_label_1.add_style(style_overview_info1_label_1_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

Overview_info1_label_2 = lv.label(Overview)
Overview_info1_label_2.set_pos(274,128)
Overview_info1_label_2.set_size(60,32)
Overview_info1_label_2.set_text("Travelled")
Overview_info1_label_2.set_long_mode(lv.label.LONG.WRAP)
Overview_info1_label_2.set_style_text_align(lv.TEXT_ALIGN.LEFT, 0)
# create style style_overview_info1_label_2_main_main_default
style_overview_info1_label_2_main_main_default = lv.style_t()
style_overview_info1_label_2_main_main_default.init()
style_overview_info1_label_2_main_main_default.set_radius(0)
style_overview_info1_label_2_main_main_default.set_bg_color(lv.color_make(0xff,0xff,0xff))
style_overview_info1_label_2_main_main_default.set_bg_grad_color(lv.color_make(0xff,0xff,0xff))
style_overview_info1_label_2_main_main_default.set_bg_grad_dir(lv.GRAD_DIR.VER)
style_overview_info1_label_2_main_main_default.set_bg_opa(0)
style_overview_info1_label_2_main_main_default.set_text_color(lv.color_make(0x9e,0x9e,0x9e))
try:
    style_overview_info1_label_2_main_main_default.set_text_font(lv.font_montserratMedium_12)
except AttributeError:
    try:
        style_overview_info1_label_2_main_main_default.set_text_font(lv.font_montserrat_12)
    except AttributeError:
        style_overview_info1_label_2_main_main_default.set_text_font(lv.font_montserrat_16)
style_overview_info1_label_2_main_main_default.set_text_letter_space(0)
style_overview_info1_label_2_main_main_default.set_pad_left(0)
style_overview_info1_label_2_main_main_default.set_pad_right(0)
style_overview_info1_label_2_main_main_default.set_pad_top(0)
style_overview_info1_label_2_main_main_default.set_pad_bottom(0)

# add style for Overview_info1_label_2
Overview_info1_label_2.add_style(style_overview_info1_label_2_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

Overview_info2_label_1 = lv.label(Overview)
Overview_info2_label_1.set_pos(394,116)
Overview_info2_label_1.set_size(60,32)
Overview_info2_label_1.set_text("Average")
Overview_info2_label_1.set_long_mode(lv.label.LONG.WRAP)
Overview_info2_label_1.set_style_text_align(lv.TEXT_ALIGN.LEFT, 0)
# create style style_overview_info2_label_1_main_main_default
style_overview_info2_label_1_main_main_default = lv.style_t()
style_overview_info2_label_1_main_main_default.init()
style_overview_info2_label_1_main_main_default.set_radius(0)
style_overview_info2_label_1_main_main_default.set_bg_color(lv.color_make(0xff,0xff,0xff))
style_overview_info2_label_1_main_main_default.set_bg_grad_color(lv.color_make(0xff,0xff,0xff))
style_overview_info2_label_1_main_main_default.set_bg_grad_dir(lv.GRAD_DIR.VER)
style_overview_info2_label_1_main_main_default.set_bg_opa(0)
style_overview_info2_label_1_main_main_default.set_text_color(lv.color_make(0x9e,0x9e,0x9e))
try:
    style_overview_info2_label_1_main_main_default.set_text_font(lv.font_montserratMedium_12)
except AttributeError:
    try:
        style_overview_info2_label_1_main_main_default.set_text_font(lv.font_montserrat_12)
    except AttributeError:
        style_overview_info2_label_1_main_main_default.set_text_font(lv.font_montserrat_16)
style_overview_info2_label_1_main_main_default.set_text_letter_space(0)
style_overview_info2_label_1_main_main_default.set_pad_left(0)
style_overview_info2_label_1_main_main_default.set_pad_right(0)
style_overview_info2_label_1_main_main_default.set_pad_top(0)
style_overview_info2_label_1_main_main_default.set_pad_bottom(0)

# add style for Overview_info2_label_1
Overview_info2_label_1.add_style(style_overview_info2_label_1_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

Overview_info2_label_2 = lv.label(Overview)
Overview_info2_label_2.set_pos(394,128)
Overview_info2_label_2.set_size(60,32)
Overview_info2_label_2.set_text("Speed")
Overview_info2_label_2.set_long_mode(lv.label.LONG.WRAP)
Overview_info2_label_2.set_style_text_align(lv.TEXT_ALIGN.LEFT, 0)
# create style style_overview_info2_label_2_main_main_default
style_overview_info2_label_2_main_main_default = lv.style_t()
style_overview_info2_label_2_main_main_default.init()
style_overview_info2_label_2_main_main_default.set_radius(0)
style_overview_info2_label_2_main_main_default.set_bg_color(lv.color_make(0xff,0xff,0xff))
style_overview_info2_label_2_main_main_default.set_bg_grad_color(lv.color_make(0xff,0xff,0xff))
style_overview_info2_label_2_main_main_default.set_bg_grad_dir(lv.GRAD_DIR.VER)
style_overview_info2_label_2_main_main_default.set_bg_opa(0)
style_overview_info2_label_2_main_main_default.set_text_color(lv.color_make(0x9e,0x9e,0x9e))
try:
    style_overview_info2_label_2_main_main_default.set_text_font(lv.font_montserratMedium_12)
except AttributeError:
    try:
        style_overview_info2_label_2_main_main_default.set_text_font(lv.font_montserrat_12)
    except AttributeError:
        style_overview_info2_label_2_main_main_default.set_text_font(lv.font_montserrat_16)
style_overview_info2_label_2_main_main_default.set_text_letter_space(0)
style_overview_info2_label_2_main_main_default.set_pad_left(0)
style_overview_info2_label_2_main_main_default.set_pad_right(0)
style_overview_info2_label_2_main_main_default.set_pad_top(0)
style_overview_info2_label_2_main_main_default.set_pad_bottom(0)

# add style for Overview_info2_label_2
Overview_info2_label_2.add_style(style_overview_info2_label_2_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

Overview_info3_label_1 = lv.label(Overview)
Overview_info3_label_1.set_pos(274,178)
Overview_info3_label_1.set_size(80,32)
Overview_info3_label_1.set_text("Remaining")
Overview_info3_label_1.set_long_mode(lv.label.LONG.WRAP)
Overview_info3_label_1.set_style_text_align(lv.TEXT_ALIGN.LEFT, 0)
# create style style_overview_info3_label_1_main_main_default
style_overview_info3_label_1_main_main_default = lv.style_t()
style_overview_info3_label_1_main_main_default.init()
style_overview_info3_label_1_main_main_default.set_radius(0)
style_overview_info3_label_1_main_main_default.set_bg_color(lv.color_make(0xff,0xff,0xff))
style_overview_info3_label_1_main_main_default.set_bg_grad_color(lv.color_make(0xff,0xff,0xff))
style_overview_info3_label_1_main_main_default.set_bg_grad_dir(lv.GRAD_DIR.VER)
style_overview_info3_label_1_main_main_default.set_bg_opa(0)
style_overview_info3_label_1_main_main_default.set_text_color(lv.color_make(0x9e,0x9e,0x9e))
try:
    style_overview_info3_label_1_main_main_default.set_text_font(lv.font_montserratMedium_12)
except AttributeError:
    try:
        style_overview_info3_label_1_main_main_default.set_text_font(lv.font_montserrat_12)
    except AttributeError:
        style_overview_info3_label_1_main_main_default.set_text_font(lv.font_montserrat_16)
style_overview_info3_label_1_main_main_default.set_text_letter_space(0)
style_overview_info3_label_1_main_main_default.set_pad_left(0)
style_overview_info3_label_1_main_main_default.set_pad_right(0)
style_overview_info3_label_1_main_main_default.set_pad_top(0)
style_overview_info3_label_1_main_main_default.set_pad_bottom(0)

# add style for Overview_info3_label_1
Overview_info3_label_1.add_style(style_overview_info3_label_1_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

Overview_info3_label_2 = lv.label(Overview)
Overview_info3_label_2.set_pos(274,190)
Overview_info3_label_2.set_size(60,32)
Overview_info3_label_2.set_text("Distance")
Overview_info3_label_2.set_long_mode(lv.label.LONG.WRAP)
Overview_info3_label_2.set_style_text_align(lv.TEXT_ALIGN.LEFT, 0)
# create style style_overview_info3_label_2_main_main_default
style_overview_info3_label_2_main_main_default = lv.style_t()
style_overview_info3_label_2_main_main_default.init()
style_overview_info3_label_2_main_main_default.set_radius(0)
style_overview_info3_label_2_main_main_default.set_bg_color(lv.color_make(0xff,0xff,0xff))
style_overview_info3_label_2_main_main_default.set_bg_grad_color(lv.color_make(0xff,0xff,0xff))
style_overview_info3_label_2_main_main_default.set_bg_grad_dir(lv.GRAD_DIR.VER)
style_overview_info3_label_2_main_main_default.set_bg_opa(0)
style_overview_info3_label_2_main_main_default.set_text_color(lv.color_make(0x9e,0x9e,0x9e))
try:
    style_overview_info3_label_2_main_main_default.set_text_font(lv.font_montserratMedium_12)
except AttributeError:
    try:
        style_overview_info3_label_2_main_main_default.set_text_font(lv.font_montserrat_12)
    except AttributeError:
        style_overview_info3_label_2_main_main_default.set_text_font(lv.font_montserrat_16)
style_overview_info3_label_2_main_main_default.set_text_letter_space(0)
style_overview_info3_label_2_main_main_default.set_pad_left(0)
style_overview_info3_label_2_main_main_default.set_pad_right(0)
style_overview_info3_label_2_main_main_default.set_pad_top(0)
style_overview_info3_label_2_main_main_default.set_pad_bottom(0)

# add style for Overview_info3_label_2
Overview_info3_label_2.add_style(style_overview_info3_label_2_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

Overview_linfo4_label_1 = lv.label(Overview)
Overview_linfo4_label_1.set_pos(394,178)
Overview_linfo4_label_1.set_size(60,32)
Overview_linfo4_label_1.set_text("Elapsed")
Overview_linfo4_label_1.set_long_mode(lv.label.LONG.WRAP)
Overview_linfo4_label_1.set_style_text_align(lv.TEXT_ALIGN.LEFT, 0)
# create style style_overview_linfo4_label_1_main_main_default
style_overview_linfo4_label_1_main_main_default = lv.style_t()
style_overview_linfo4_label_1_main_main_default.init()
style_overview_linfo4_label_1_main_main_default.set_radius(0)
style_overview_linfo4_label_1_main_main_default.set_bg_color(lv.color_make(0xff,0xff,0xff))
style_overview_linfo4_label_1_main_main_default.set_bg_grad_color(lv.color_make(0xff,0xff,0xff))
style_overview_linfo4_label_1_main_main_default.set_bg_grad_dir(lv.GRAD_DIR.VER)
style_overview_linfo4_label_1_main_main_default.set_bg_opa(0)
style_overview_linfo4_label_1_main_main_default.set_text_color(lv.color_make(0x9e,0x9e,0x9e))
try:
    style_overview_linfo4_label_1_main_main_default.set_text_font(lv.font_montserratMedium_12)
except AttributeError:
    try:
        style_overview_linfo4_label_1_main_main_default.set_text_font(lv.font_montserrat_12)
    except AttributeError:
        style_overview_linfo4_label_1_main_main_default.set_text_font(lv.font_montserrat_16)
style_overview_linfo4_label_1_main_main_default.set_text_letter_space(0)
style_overview_linfo4_label_1_main_main_default.set_pad_left(0)
style_overview_linfo4_label_1_main_main_default.set_pad_right(0)
style_overview_linfo4_label_1_main_main_default.set_pad_top(0)
style_overview_linfo4_label_1_main_main_default.set_pad_bottom(0)

# add style for Overview_linfo4_label_1
Overview_linfo4_label_1.add_style(style_overview_linfo4_label_1_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

Overview_linfo4_label_2 = lv.label(Overview)
Overview_linfo4_label_2.set_pos(394,190)
Overview_linfo4_label_2.set_size(60,32)
Overview_linfo4_label_2.set_text("Time")
Overview_linfo4_label_2.set_long_mode(lv.label.LONG.WRAP)
Overview_linfo4_label_2.set_style_text_align(lv.TEXT_ALIGN.LEFT, 0)
# create style style_overview_linfo4_label_2_main_main_default
style_overview_linfo4_label_2_main_main_default = lv.style_t()
style_overview_linfo4_label_2_main_main_default.init()
style_overview_linfo4_label_2_main_main_default.set_radius(0)
style_overview_linfo4_label_2_main_main_default.set_bg_color(lv.color_make(0xff,0xff,0xff))
style_overview_linfo4_label_2_main_main_default.set_bg_grad_color(lv.color_make(0xff,0xff,0xff))
style_overview_linfo4_label_2_main_main_default.set_bg_grad_dir(lv.GRAD_DIR.VER)
style_overview_linfo4_label_2_main_main_default.set_bg_opa(0)
style_overview_linfo4_label_2_main_main_default.set_text_color(lv.color_make(0x9e,0x9e,0x9e))
try:
    style_overview_linfo4_label_2_main_main_default.set_text_font(lv.font_montserratMedium_12)
except AttributeError:
    try:
        style_overview_linfo4_label_2_main_main_default.set_text_font(lv.font_montserrat_12)
    except AttributeError:
        style_overview_linfo4_label_2_main_main_default.set_text_font(lv.font_montserrat_16)
style_overview_linfo4_label_2_main_main_default.set_text_letter_space(0)
style_overview_linfo4_label_2_main_main_default.set_pad_left(0)
style_overview_linfo4_label_2_main_main_default.set_pad_right(0)
style_overview_linfo4_label_2_main_main_default.set_pad_top(0)
style_overview_linfo4_label_2_main_main_default.set_pad_bottom(0)

# add style for Overview_linfo4_label_2
Overview_linfo4_label_2.add_style(style_overview_linfo4_label_2_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

Overview_info1_label_3 = lv.label(Overview)
Overview_info1_label_3.set_pos(244,145)
Overview_info1_label_3.set_size(50,32)
Overview_info1_label_3.set_text("12.7")
Overview_info1_label_3.set_long_mode(lv.label.LONG.WRAP)
Overview_info1_label_3.set_style_text_align(lv.TEXT_ALIGN.LEFT, 0)
# create style style_overview_info1_label_3_main_main_default
style_overview_info1_label_3_main_main_default = lv.style_t()
style_overview_info1_label_3_main_main_default.init()
style_overview_info1_label_3_main_main_default.set_radius(0)
style_overview_info1_label_3_main_main_default.set_bg_color(lv.color_make(0xff,0xff,0xff))
style_overview_info1_label_3_main_main_default.set_bg_grad_color(lv.color_make(0xff,0xff,0xff))
style_overview_info1_label_3_main_main_default.set_bg_grad_dir(lv.GRAD_DIR.VER)
style_overview_info1_label_3_main_main_default.set_bg_opa(0)
style_overview_info1_label_3_main_main_default.set_text_color(lv.color_make(0x00,0x80,0xff))
try:
    style_overview_info1_label_3_main_main_default.set_text_font(lv.font_montserratMedium_20)
except AttributeError:
    try:
        style_overview_info1_label_3_main_main_default.set_text_font(lv.font_montserrat_20)
    except AttributeError:
        style_overview_info1_label_3_main_main_default.set_text_font(lv.font_montserrat_16)
style_overview_info1_label_3_main_main_default.set_text_letter_space(0)
style_overview_info1_label_3_main_main_default.set_pad_left(0)
style_overview_info1_label_3_main_main_default.set_pad_right(0)
style_overview_info1_label_3_main_main_default.set_pad_top(0)
style_overview_info1_label_3_main_main_default.set_pad_bottom(0)

# add style for Overview_info1_label_3
Overview_info1_label_3.add_style(style_overview_info1_label_3_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

Overview_info2_label_3 = lv.label(Overview)
Overview_info2_label_3.set_pos(360,145)
Overview_info2_label_3.set_size(50,32)
Overview_info2_label_3.set_text("16.1")
Overview_info2_label_3.set_long_mode(lv.label.LONG.WRAP)
Overview_info2_label_3.set_style_text_align(lv.TEXT_ALIGN.LEFT, 0)
# create style style_overview_info2_label_3_main_main_default
style_overview_info2_label_3_main_main_default = lv.style_t()
style_overview_info2_label_3_main_main_default.init()
style_overview_info2_label_3_main_main_default.set_radius(0)
style_overview_info2_label_3_main_main_default.set_bg_color(lv.color_make(0xff,0xff,0xff))
style_overview_info2_label_3_main_main_default.set_bg_grad_color(lv.color_make(0xff,0xff,0xff))
style_overview_info2_label_3_main_main_default.set_bg_grad_dir(lv.GRAD_DIR.VER)
style_overview_info2_label_3_main_main_default.set_bg_opa(0)
style_overview_info2_label_3_main_main_default.set_text_color(lv.color_make(0x00,0x80,0xff))
try:
    style_overview_info2_label_3_main_main_default.set_text_font(lv.font_montserratMedium_20)
except AttributeError:
    try:
        style_overview_info2_label_3_main_main_default.set_text_font(lv.font_montserrat_20)
    except AttributeError:
        style_overview_info2_label_3_main_main_default.set_text_font(lv.font_montserrat_16)
style_overview_info2_label_3_main_main_default.set_text_letter_space(0)
style_overview_info2_label_3_main_main_default.set_pad_left(0)
style_overview_info2_label_3_main_main_default.set_pad_right(0)
style_overview_info2_label_3_main_main_default.set_pad_top(0)
style_overview_info2_label_3_main_main_default.set_pad_bottom(0)

# add style for Overview_info2_label_3
Overview_info2_label_3.add_style(style_overview_info2_label_3_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

Overview_info3_label_3 = lv.label(Overview)
Overview_info3_label_3.set_pos(244,215)
Overview_info3_label_3.set_size(50,32)
Overview_info3_label_3.set_text("18.3")
Overview_info3_label_3.set_long_mode(lv.label.LONG.WRAP)
Overview_info3_label_3.set_style_text_align(lv.TEXT_ALIGN.LEFT, 0)
# create style style_overview_info3_label_3_main_main_default
style_overview_info3_label_3_main_main_default = lv.style_t()
style_overview_info3_label_3_main_main_default.init()
style_overview_info3_label_3_main_main_default.set_radius(0)
style_overview_info3_label_3_main_main_default.set_bg_color(lv.color_make(0xff,0xff,0xff))
style_overview_info3_label_3_main_main_default.set_bg_grad_color(lv.color_make(0xff,0xff,0xff))
style_overview_info3_label_3_main_main_default.set_bg_grad_dir(lv.GRAD_DIR.VER)
style_overview_info3_label_3_main_main_default.set_bg_opa(0)
style_overview_info3_label_3_main_main_default.set_text_color(lv.color_make(0x00,0x80,0xff))
try:
    style_overview_info3_label_3_main_main_default.set_text_font(lv.font_montserratMedium_20)
except AttributeError:
    try:
        style_overview_info3_label_3_main_main_default.set_text_font(lv.font_montserrat_20)
    except AttributeError:
        style_overview_info3_label_3_main_main_default.set_text_font(lv.font_montserrat_16)
style_overview_info3_label_3_main_main_default.set_text_letter_space(0)
style_overview_info3_label_3_main_main_default.set_pad_left(0)
style_overview_info3_label_3_main_main_default.set_pad_right(0)
style_overview_info3_label_3_main_main_default.set_pad_top(0)
style_overview_info3_label_3_main_main_default.set_pad_bottom(0)

# add style for Overview_info3_label_3
Overview_info3_label_3.add_style(style_overview_info3_label_3_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

Overview_info4_label_3 = lv.label(Overview)
Overview_info4_label_3.set_pos(360,215)
Overview_info4_label_3.set_size(100,32)
Overview_info4_label_3.set_text("46:28")
Overview_info4_label_3.set_long_mode(lv.label.LONG.WRAP)
Overview_info4_label_3.set_style_text_align(lv.TEXT_ALIGN.LEFT, 0)
# create style style_overview_info4_label_3_main_main_default
style_overview_info4_label_3_main_main_default = lv.style_t()
style_overview_info4_label_3_main_main_default.init()
style_overview_info4_label_3_main_main_default.set_radius(0)
style_overview_info4_label_3_main_main_default.set_bg_color(lv.color_make(0xff,0xff,0xff))
style_overview_info4_label_3_main_main_default.set_bg_grad_color(lv.color_make(0xff,0xff,0xff))
style_overview_info4_label_3_main_main_default.set_bg_grad_dir(lv.GRAD_DIR.VER)
style_overview_info4_label_3_main_main_default.set_bg_opa(0)
style_overview_info4_label_3_main_main_default.set_text_color(lv.color_make(0x00,0x80,0xff))
try:
    style_overview_info4_label_3_main_main_default.set_text_font(lv.font_montserratMedium_20)
except AttributeError:
    try:
        style_overview_info4_label_3_main_main_default.set_text_font(lv.font_montserrat_20)
    except AttributeError:
        style_overview_info4_label_3_main_main_default.set_text_font(lv.font_montserrat_16)
style_overview_info4_label_3_main_main_default.set_text_letter_space(0)
style_overview_info4_label_3_main_main_default.set_pad_left(0)
style_overview_info4_label_3_main_main_default.set_pad_right(0)
style_overview_info4_label_3_main_main_default.set_pad_top(0)
style_overview_info4_label_3_main_main_default.set_pad_bottom(0)

# add style for Overview_info4_label_3
Overview_info4_label_3.add_style(style_overview_info4_label_3_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

Overview_info1_label_4 = lv.label(Overview)
Overview_info1_label_4.set_pos(286,150)
Overview_info1_label_4.set_size(30,32)
Overview_info1_label_4.set_text("km")
Overview_info1_label_4.set_long_mode(lv.label.LONG.WRAP)
Overview_info1_label_4.set_style_text_align(lv.TEXT_ALIGN.LEFT, 0)
# create style style_overview_info1_label_4_main_main_default
style_overview_info1_label_4_main_main_default = lv.style_t()
style_overview_info1_label_4_main_main_default.init()
style_overview_info1_label_4_main_main_default.set_radius(0)
style_overview_info1_label_4_main_main_default.set_bg_color(lv.color_make(0xff,0xff,0xff))
style_overview_info1_label_4_main_main_default.set_bg_grad_color(lv.color_make(0xff,0xff,0xff))
style_overview_info1_label_4_main_main_default.set_bg_grad_dir(lv.GRAD_DIR.VER)
style_overview_info1_label_4_main_main_default.set_bg_opa(0)
style_overview_info1_label_4_main_main_default.set_text_color(lv.color_make(0x9e,0x9e,0x9e))
try:
    style_overview_info1_label_4_main_main_default.set_text_font(lv.font_montserratMedium_12)
except AttributeError:
    try:
        style_overview_info1_label_4_main_main_default.set_text_font(lv.font_montserrat_12)
    except AttributeError:
        style_overview_info1_label_4_main_main_default.set_text_font(lv.font_montserrat_16)
style_overview_info1_label_4_main_main_default.set_text_letter_space(0)
style_overview_info1_label_4_main_main_default.set_pad_left(0)
style_overview_info1_label_4_main_main_default.set_pad_right(0)
style_overview_info1_label_4_main_main_default.set_pad_top(0)
style_overview_info1_label_4_main_main_default.set_pad_bottom(0)

# add style for Overview_info1_label_4
Overview_info1_label_4.add_style(style_overview_info1_label_4_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

Overview_info2_label_4 = lv.label(Overview)
Overview_info2_label_4.set_pos(402,150)
Overview_info2_label_4.set_size(50,32)
Overview_info2_label_4.set_text("km/h")
Overview_info2_label_4.set_long_mode(lv.label.LONG.WRAP)
Overview_info2_label_4.set_style_text_align(lv.TEXT_ALIGN.LEFT, 0)
# create style style_overview_info2_label_4_main_main_default
style_overview_info2_label_4_main_main_default = lv.style_t()
style_overview_info2_label_4_main_main_default.init()
style_overview_info2_label_4_main_main_default.set_radius(0)
style_overview_info2_label_4_main_main_default.set_bg_color(lv.color_make(0xff,0xff,0xff))
style_overview_info2_label_4_main_main_default.set_bg_grad_color(lv.color_make(0xff,0xff,0xff))
style_overview_info2_label_4_main_main_default.set_bg_grad_dir(lv.GRAD_DIR.VER)
style_overview_info2_label_4_main_main_default.set_bg_opa(0)
style_overview_info2_label_4_main_main_default.set_text_color(lv.color_make(0x9e,0x9e,0x9e))
try:
    style_overview_info2_label_4_main_main_default.set_text_font(lv.font_montserratMedium_12)
except AttributeError:
    try:
        style_overview_info2_label_4_main_main_default.set_text_font(lv.font_montserrat_12)
    except AttributeError:
        style_overview_info2_label_4_main_main_default.set_text_font(lv.font_montserrat_16)
style_overview_info2_label_4_main_main_default.set_text_letter_space(0)
style_overview_info2_label_4_main_main_default.set_pad_left(0)
style_overview_info2_label_4_main_main_default.set_pad_right(0)
style_overview_info2_label_4_main_main_default.set_pad_top(0)
style_overview_info2_label_4_main_main_default.set_pad_bottom(0)

# add style for Overview_info2_label_4
Overview_info2_label_4.add_style(style_overview_info2_label_4_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

Overview_info3_label_4 = lv.label(Overview)
Overview_info3_label_4.set_pos(286,220)
Overview_info3_label_4.set_size(30,32)
Overview_info3_label_4.set_text("km")
Overview_info3_label_4.set_long_mode(lv.label.LONG.WRAP)
Overview_info3_label_4.set_style_text_align(lv.TEXT_ALIGN.LEFT, 0)
# create style style_overview_info3_label_4_main_main_default
style_overview_info3_label_4_main_main_default = lv.style_t()
style_overview_info3_label_4_main_main_default.init()
style_overview_info3_label_4_main_main_default.set_radius(0)
style_overview_info3_label_4_main_main_default.set_bg_color(lv.color_make(0xff,0xff,0xff))
style_overview_info3_label_4_main_main_default.set_bg_grad_color(lv.color_make(0xff,0xff,0xff))
style_overview_info3_label_4_main_main_default.set_bg_grad_dir(lv.GRAD_DIR.VER)
style_overview_info3_label_4_main_main_default.set_bg_opa(0)
style_overview_info3_label_4_main_main_default.set_text_color(lv.color_make(0x9e,0x9e,0x9e))
try:
    style_overview_info3_label_4_main_main_default.set_text_font(lv.font_montserratMedium_12)
except AttributeError:
    try:
        style_overview_info3_label_4_main_main_default.set_text_font(lv.font_montserrat_12)
    except AttributeError:
        style_overview_info3_label_4_main_main_default.set_text_font(lv.font_montserrat_16)
style_overview_info3_label_4_main_main_default.set_text_letter_space(0)
style_overview_info3_label_4_main_main_default.set_pad_left(0)
style_overview_info3_label_4_main_main_default.set_pad_right(0)
style_overview_info3_label_4_main_main_default.set_pad_top(0)
style_overview_info3_label_4_main_main_default.set_pad_bottom(0)

# add style for Overview_info3_label_4
Overview_info3_label_4.add_style(style_overview_info3_label_4_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

Overview_info_img_v = lv.img(Overview)
Overview_info_img_v.set_pos(240,170)
Overview_info_img_v.set_size(210,3)
Overview_info_img_v.add_flag(lv.obj.FLAG.CLICKABLE)
try:
    with open('C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp1913112770.png','rb') as f:
        Overview_info_img_v_img_data = f.read()
except:
    print('Could not open C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp1913112770.png')
    sys.exit()

Overview_info_img_v_img = lv.img_dsc_t({
  'data_size': len(Overview_info_img_v_img_data),
  'header': {'always_zero': 0, 'w': 210, 'h': 3, 'cf': lv.img.CF.TRUE_COLOR_ALPHA},
  'data': Overview_info_img_v_img_data
})

Overview_info_img_v.set_src(Overview_info_img_v_img)
Overview_info_img_v.set_pivot(0,0)
Overview_info_img_v.set_angle(0)
# create style style_overview_info_img_v_main_main_default
style_overview_info_img_v_main_main_default = lv.style_t()
style_overview_info_img_v_main_main_default.init()
style_overview_info_img_v_main_main_default.set_img_recolor(lv.color_make(0xff,0xff,0xff))
style_overview_info_img_v_main_main_default.set_img_recolor_opa(0)
style_overview_info_img_v_main_main_default.set_img_opa(255)

# add style for Overview_info_img_v
Overview_info_img_v.add_style(style_overview_info_img_v_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

Overview_info_img_h = lv.img(Overview)
Overview_info_img_h.set_pos(348,116)
Overview_info_img_h.set_size(3,120)
Overview_info_img_h.add_flag(lv.obj.FLAG.CLICKABLE)
try:
    with open('C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp729022314.png','rb') as f:
        Overview_info_img_h_img_data = f.read()
except:
    print('Could not open C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp729022314.png')
    sys.exit()

Overview_info_img_h_img = lv.img_dsc_t({
  'data_size': len(Overview_info_img_h_img_data),
  'header': {'always_zero': 0, 'w': 3, 'h': 120, 'cf': lv.img.CF.TRUE_COLOR_ALPHA},
  'data': Overview_info_img_h_img_data
})

Overview_info_img_h.set_src(Overview_info_img_h_img)
Overview_info_img_h.set_pivot(0,0)
Overview_info_img_h.set_angle(0)
# create style style_overview_info_img_h_main_main_default
style_overview_info_img_h_main_main_default = lv.style_t()
style_overview_info_img_h_main_main_default.init()
style_overview_info_img_h_main_main_default.set_img_recolor(lv.color_make(0xff,0xff,0xff))
style_overview_info_img_h_main_main_default.set_img_recolor_opa(0)
style_overview_info_img_h_main_main_default.set_img_opa(255)

# add style for Overview_info_img_h
Overview_info_img_h.add_style(style_overview_info_img_h_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

Overview_gauge_bg_img = lv.img(Overview)
Overview_gauge_bg_img.set_pos(5,25)
Overview_gauge_bg_img.set_size(233,234)
Overview_gauge_bg_img.add_flag(lv.obj.FLAG.CLICKABLE)
try:
    with open('C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp-1651174002.png','rb') as f:
        Overview_gauge_bg_img_img_data = f.read()
except:
    print('Could not open C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp-1651174002.png')
    sys.exit()

Overview_gauge_bg_img_img = lv.img_dsc_t({
  'data_size': len(Overview_gauge_bg_img_img_data),
  'header': {'always_zero': 0, 'w': 233, 'h': 234, 'cf': lv.img.CF.TRUE_COLOR_ALPHA},
  'data': Overview_gauge_bg_img_img_data
})

Overview_gauge_bg_img.set_src(Overview_gauge_bg_img_img)
Overview_gauge_bg_img.set_pivot(0,0)
Overview_gauge_bg_img.set_angle(0)
# create style style_overview_gauge_bg_img_main_main_default
style_overview_gauge_bg_img_main_main_default = lv.style_t()
style_overview_gauge_bg_img_main_main_default.init()
style_overview_gauge_bg_img_main_main_default.set_img_recolor(lv.color_make(0xff,0xff,0xff))
style_overview_gauge_bg_img_main_main_default.set_img_recolor_opa(0)
style_overview_gauge_bg_img_main_main_default.set_img_opa(255)

# add style for Overview_gauge_bg_img
Overview_gauge_bg_img.add_style(style_overview_gauge_bg_img_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

Overview_gaugeL_img = lv.img(Overview)
Overview_gaugeL_img.set_pos(25,45)
Overview_gaugeL_img.set_size(193,164)
Overview_gaugeL_img.add_flag(lv.obj.FLAG.CLICKABLE)
try:
    with open('C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp1796719003.png','rb') as f:
        Overview_gaugeL_img_img_data = f.read()
except:
    print('Could not open C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp1796719003.png')
    sys.exit()

Overview_gaugeL_img_img = lv.img_dsc_t({
  'data_size': len(Overview_gaugeL_img_img_data),
  'header': {'always_zero': 0, 'w': 193, 'h': 164, 'cf': lv.img.CF.TRUE_COLOR_ALPHA},
  'data': Overview_gaugeL_img_img_data
})

Overview_gaugeL_img.set_src(Overview_gaugeL_img_img)
Overview_gaugeL_img.set_pivot(0,0)
Overview_gaugeL_img.set_angle(0)
# create style style_overview_gaugel_img_main_main_default
style_overview_gaugel_img_main_main_default = lv.style_t()
style_overview_gaugel_img_main_main_default.init()
style_overview_gaugel_img_main_main_default.set_img_recolor(lv.color_make(0xff,0xff,0xff))
style_overview_gaugel_img_main_main_default.set_img_recolor_opa(0)
style_overview_gaugel_img_main_main_default.set_img_opa(255)

# add style for Overview_gaugeL_img
Overview_gaugeL_img.add_style(style_overview_gaugel_img_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

Overview_gaugeN_img = lv.img(Overview)
Overview_gaugeN_img.set_pos(37,55)
Overview_gaugeN_img.set_size(166,134)
Overview_gaugeN_img.add_flag(lv.obj.FLAG.CLICKABLE)
try:
    with open('C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp-750564509.png','rb') as f:
        Overview_gaugeN_img_img_data = f.read()
except:
    print('Could not open C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp-750564509.png')
    sys.exit()

Overview_gaugeN_img_img = lv.img_dsc_t({
  'data_size': len(Overview_gaugeN_img_img_data),
  'header': {'always_zero': 0, 'w': 166, 'h': 134, 'cf': lv.img.CF.TRUE_COLOR_ALPHA},
  'data': Overview_gaugeN_img_img_data
})

Overview_gaugeN_img.set_src(Overview_gaugeN_img_img)
Overview_gaugeN_img.set_pivot(0,0)
Overview_gaugeN_img.set_angle(0)
# create style style_overview_gaugen_img_main_main_default
style_overview_gaugen_img_main_main_default = lv.style_t()
style_overview_gaugen_img_main_main_default.init()
style_overview_gaugen_img_main_main_default.set_img_recolor(lv.color_make(0xff,0xff,0xff))
style_overview_gaugen_img_main_main_default.set_img_recolor_opa(0)
style_overview_gaugen_img_main_main_default.set_img_opa(255)

# add style for Overview_gaugeN_img
Overview_gaugeN_img.add_style(style_overview_gaugen_img_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

Overview_needle_img = lv.img(Overview)
Overview_needle_img.set_pos(22,42)
Overview_needle_img.set_size(200,200)
Overview_needle_img.add_flag(lv.obj.FLAG.CLICKABLE)
try:
    with open('C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp514579287.png','rb') as f:
        Overview_needle_img_img_data = f.read()
except:
    print('Could not open C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp514579287.png')
    sys.exit()

Overview_needle_img_img = lv.img_dsc_t({
  'data_size': len(Overview_needle_img_img_data),
  'header': {'always_zero': 0, 'w': 200, 'h': 200, 'cf': lv.img.CF.TRUE_COLOR_ALPHA},
  'data': Overview_needle_img_img_data
})

Overview_needle_img.set_src(Overview_needle_img_img)
Overview_needle_img.set_pivot(100,100)
Overview_needle_img.set_angle(1500)
# create style style_overview_needle_img_main_main_default
style_overview_needle_img_main_main_default = lv.style_t()
style_overview_needle_img_main_main_default.init()
style_overview_needle_img_main_main_default.set_img_recolor(lv.color_make(0xff,0xff,0xff))
style_overview_needle_img_main_main_default.set_img_recolor_opa(0)
style_overview_needle_img_main_main_default.set_img_opa(255)

# add style for Overview_needle_img
Overview_needle_img.add_style(style_overview_needle_img_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

Overview_battery_line_img = lv.img(Overview)
Overview_battery_line_img.set_pos(5,139)
Overview_battery_line_img.set_size(237,120)
Overview_battery_line_img.add_flag(lv.obj.FLAG.CLICKABLE)
try:
    with open('C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp-2064831353.png','rb') as f:
        Overview_battery_line_img_img_data = f.read()
except:
    print('Could not open C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp-2064831353.png')
    sys.exit()

Overview_battery_line_img_img = lv.img_dsc_t({
  'data_size': len(Overview_battery_line_img_img_data),
  'header': {'always_zero': 0, 'w': 237, 'h': 120, 'cf': lv.img.CF.TRUE_COLOR_ALPHA},
  'data': Overview_battery_line_img_img_data
})

Overview_battery_line_img.set_src(Overview_battery_line_img_img)
Overview_battery_line_img.set_pivot(0,0)
Overview_battery_line_img.set_angle(0)
# create style style_overview_battery_line_img_main_main_default
style_overview_battery_line_img_main_main_default = lv.style_t()
style_overview_battery_line_img_main_main_default.init()
style_overview_battery_line_img_main_main_default.set_img_recolor(lv.color_make(0xff,0xff,0xff))
style_overview_battery_line_img_main_main_default.set_img_recolor_opa(0)
style_overview_battery_line_img_main_main_default.set_img_opa(255)

# add style for Overview_battery_line_img
Overview_battery_line_img.add_style(style_overview_battery_line_img_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

Overview_battery_icon = lv.img(Overview)
Overview_battery_icon.set_pos(110,200)
Overview_battery_icon.set_size(15,12)
Overview_battery_icon.add_flag(lv.obj.FLAG.CLICKABLE)
try:
    with open('C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp-2052837718.png','rb') as f:
        Overview_battery_icon_img_data = f.read()
except:
    print('Could not open C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp-2052837718.png')
    sys.exit()

Overview_battery_icon_img = lv.img_dsc_t({
  'data_size': len(Overview_battery_icon_img_data),
  'header': {'always_zero': 0, 'w': 15, 'h': 12, 'cf': lv.img.CF.TRUE_COLOR_ALPHA},
  'data': Overview_battery_icon_img_data
})

Overview_battery_icon.set_src(Overview_battery_icon_img)
Overview_battery_icon.set_pivot(0,0)
Overview_battery_icon.set_angle(0)
# create style style_overview_battery_icon_main_main_default
style_overview_battery_icon_main_main_default = lv.style_t()
style_overview_battery_icon_main_main_default.init()
style_overview_battery_icon_main_main_default.set_img_recolor(lv.color_make(0xff,0xff,0xff))
style_overview_battery_icon_main_main_default.set_img_recolor_opa(0)
style_overview_battery_icon_main_main_default.set_img_opa(255)

# add style for Overview_battery_icon
Overview_battery_icon.add_style(style_overview_battery_icon_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

Overview_battery_label = lv.label(Overview)
Overview_battery_label.set_pos(130,200)
Overview_battery_label.set_size(50,32)
Overview_battery_label.set_text("56%")
Overview_battery_label.set_long_mode(lv.label.LONG.WRAP)
Overview_battery_label.set_style_text_align(lv.TEXT_ALIGN.LEFT, 0)
# create style style_overview_battery_label_main_main_default
style_overview_battery_label_main_main_default = lv.style_t()
style_overview_battery_label_main_main_default.init()
style_overview_battery_label_main_main_default.set_radius(0)
style_overview_battery_label_main_main_default.set_bg_color(lv.color_make(0xff,0xff,0xff))
style_overview_battery_label_main_main_default.set_bg_grad_color(lv.color_make(0xff,0xff,0xff))
style_overview_battery_label_main_main_default.set_bg_grad_dir(lv.GRAD_DIR.VER)
style_overview_battery_label_main_main_default.set_bg_opa(0)
style_overview_battery_label_main_main_default.set_text_color(lv.color_make(0x00,0x80,0xff))
try:
    style_overview_battery_label_main_main_default.set_text_font(lv.font_montserratMedium_12)
except AttributeError:
    try:
        style_overview_battery_label_main_main_default.set_text_font(lv.font_montserrat_12)
    except AttributeError:
        style_overview_battery_label_main_main_default.set_text_font(lv.font_montserrat_16)
style_overview_battery_label_main_main_default.set_text_letter_space(0)
style_overview_battery_label_main_main_default.set_pad_left(0)
style_overview_battery_label_main_main_default.set_pad_right(0)
style_overview_battery_label_main_main_default.set_pad_top(0)
style_overview_battery_label_main_main_default.set_pad_bottom(0)

# add style for Overview_battery_label
Overview_battery_label.add_style(style_overview_battery_label_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

Overview_battery_arc = lv.arc(Overview)
Overview_battery_arc.set_pos(25,38)
Overview_battery_arc.set_size(200,200)
Overview_battery_arc.set_bg_angles(85, 130)
Overview_battery_arc.set_angles(85, 130)
Overview_battery_arc.set_rotation(0)
Overview_battery_arc.set_style_pad_top(0, lv.PART.MAIN | lv.STATE.DEFAULT)
Overview_battery_arc.set_style_pad_bottom(0, lv.PART.MAIN | lv.STATE.DEFAULT)
Overview_battery_arc.set_style_pad_left(0, lv.PART.MAIN | lv.STATE.DEFAULT)
Overview_battery_arc.set_style_pad_right(0, lv.PART.MAIN | lv.STATE.DEFAULT)
# create style style_overview_battery_arc_main_main_default
style_overview_battery_arc_main_main_default = lv.style_t()
style_overview_battery_arc_main_main_default.init()
style_overview_battery_arc_main_main_default.set_bg_color(lv.color_make(0x09,0x80,0xff))
style_overview_battery_arc_main_main_default.set_bg_grad_color(lv.color_make(0x00,0x80,0xff))
style_overview_battery_arc_main_main_default.set_bg_grad_dir(lv.GRAD_DIR.VER)
style_overview_battery_arc_main_main_default.set_bg_opa(0)
style_overview_battery_arc_main_main_default.set_border_width(0)
style_overview_battery_arc_main_main_default.set_arc_color(lv.color_make(0x00,0x80,0xff))
style_overview_battery_arc_main_main_default.set_arc_width(5)

# add style for Overview_battery_arc
Overview_battery_arc.add_style(style_overview_battery_arc_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

# create style style_overview_battery_arc_main_indicator_default
style_overview_battery_arc_main_indicator_default = lv.style_t()
style_overview_battery_arc_main_indicator_default.init()
style_overview_battery_arc_main_indicator_default.set_arc_color(lv.color_make(0x21,0x95,0xf6))
style_overview_battery_arc_main_indicator_default.set_arc_width(5)

# add style for Overview_battery_arc
Overview_battery_arc.add_style(style_overview_battery_arc_main_indicator_default, lv.PART.INDICATOR|lv.STATE.DEFAULT)

# create style style_overview_battery_arc_main_knob_default
style_overview_battery_arc_main_knob_default = lv.style_t()
style_overview_battery_arc_main_knob_default.init()
style_overview_battery_arc_main_knob_default.set_bg_color(lv.color_make(0x00,0x80,0xff))
style_overview_battery_arc_main_knob_default.set_bg_grad_color(lv.color_make(0x00,0x80,0xff))
style_overview_battery_arc_main_knob_default.set_bg_grad_dir(lv.GRAD_DIR.VER)
style_overview_battery_arc_main_knob_default.set_bg_opa(0)
style_overview_battery_arc_main_knob_default.set_pad_all(5)

# add style for Overview_battery_arc
Overview_battery_arc.add_style(style_overview_battery_arc_main_knob_default, lv.PART.KNOB|lv.STATE.DEFAULT)

Overview_footer_bg_img = lv.img(Overview)
Overview_footer_bg_img.set_pos(0,237)
Overview_footer_bg_img.set_size(480,35)
Overview_footer_bg_img.add_flag(lv.obj.FLAG.CLICKABLE)
try:
    with open('C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp-1226003919.png','rb') as f:
        Overview_footer_bg_img_img_data = f.read()
except:
    print('Could not open C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp-1226003919.png')
    sys.exit()

Overview_footer_bg_img_img = lv.img_dsc_t({
  'data_size': len(Overview_footer_bg_img_img_data),
  'header': {'always_zero': 0, 'w': 480, 'h': 35, 'cf': lv.img.CF.TRUE_COLOR_ALPHA},
  'data': Overview_footer_bg_img_img_data
})

Overview_footer_bg_img.set_src(Overview_footer_bg_img_img)
Overview_footer_bg_img.set_pivot(0,0)
Overview_footer_bg_img.set_angle(0)
# create style style_overview_footer_bg_img_main_main_default
style_overview_footer_bg_img_main_main_default = lv.style_t()
style_overview_footer_bg_img_main_main_default.init()
style_overview_footer_bg_img_main_main_default.set_img_recolor(lv.color_make(0xff,0xff,0xff))
style_overview_footer_bg_img_main_main_default.set_img_recolor_opa(0)
style_overview_footer_bg_img_main_main_default.set_img_opa(255)

# add style for Overview_footer_bg_img
Overview_footer_bg_img.add_style(style_overview_footer_bg_img_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

Overview_footer_line_1 = lv.img(Overview)
Overview_footer_line_1.set_pos(190,260)
Overview_footer_line_1.set_size(22,4)
Overview_footer_line_1.add_flag(lv.obj.FLAG.CLICKABLE)
try:
    with open('C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp-272595050.png','rb') as f:
        Overview_footer_line_1_img_data = f.read()
except:
    print('Could not open C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp-272595050.png')
    sys.exit()

Overview_footer_line_1_img = lv.img_dsc_t({
  'data_size': len(Overview_footer_line_1_img_data),
  'header': {'always_zero': 0, 'w': 22, 'h': 4, 'cf': lv.img.CF.TRUE_COLOR_ALPHA},
  'data': Overview_footer_line_1_img_data
})

Overview_footer_line_1.set_src(Overview_footer_line_1_img)
Overview_footer_line_1.set_pivot(0,0)
Overview_footer_line_1.set_angle(0)
# create style style_overview_footer_line_1_main_main_default
style_overview_footer_line_1_main_main_default = lv.style_t()
style_overview_footer_line_1_main_main_default.init()
style_overview_footer_line_1_main_main_default.set_img_recolor(lv.color_make(0xff,0xff,0xff))
style_overview_footer_line_1_main_main_default.set_img_recolor_opa(0)
style_overview_footer_line_1_main_main_default.set_img_opa(255)

# add style for Overview_footer_line_1
Overview_footer_line_1.add_style(style_overview_footer_line_1_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

Overview_footer_line_2 = lv.img(Overview)
Overview_footer_line_2.set_pos(230,260)
Overview_footer_line_2.set_size(22,4)
Overview_footer_line_2.add_flag(lv.obj.FLAG.CLICKABLE)
try:
    with open('C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp-339601803.png','rb') as f:
        Overview_footer_line_2_img_data = f.read()
except:
    print('Could not open C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp-339601803.png')
    sys.exit()

Overview_footer_line_2_img = lv.img_dsc_t({
  'data_size': len(Overview_footer_line_2_img_data),
  'header': {'always_zero': 0, 'w': 22, 'h': 4, 'cf': lv.img.CF.TRUE_COLOR_ALPHA},
  'data': Overview_footer_line_2_img_data
})

Overview_footer_line_2.set_src(Overview_footer_line_2_img)
Overview_footer_line_2.set_pivot(0,0)
Overview_footer_line_2.set_angle(0)
# create style style_overview_footer_line_2_main_main_default
style_overview_footer_line_2_main_main_default = lv.style_t()
style_overview_footer_line_2_main_main_default.init()
style_overview_footer_line_2_main_main_default.set_img_recolor(lv.color_make(0xff,0xff,0xff))
style_overview_footer_line_2_main_main_default.set_img_recolor_opa(0)
style_overview_footer_line_2_main_main_default.set_img_opa(255)

# add style for Overview_footer_line_2
Overview_footer_line_2.add_style(style_overview_footer_line_2_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

Overview_footer_line_3 = lv.img(Overview)
Overview_footer_line_3.set_pos(270,260)
Overview_footer_line_3.set_size(22,4)
Overview_footer_line_3.add_flag(lv.obj.FLAG.CLICKABLE)
try:
    with open('C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp-339601803.png','rb') as f:
        Overview_footer_line_3_img_data = f.read()
except:
    print('Could not open C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp-339601803.png')
    sys.exit()

Overview_footer_line_3_img = lv.img_dsc_t({
  'data_size': len(Overview_footer_line_3_img_data),
  'header': {'always_zero': 0, 'w': 22, 'h': 4, 'cf': lv.img.CF.TRUE_COLOR_ALPHA},
  'data': Overview_footer_line_3_img_data
})

Overview_footer_line_3.set_src(Overview_footer_line_3_img)
Overview_footer_line_3.set_pivot(0,0)
Overview_footer_line_3.set_angle(0)
# create style style_overview_footer_line_3_main_main_default
style_overview_footer_line_3_main_main_default = lv.style_t()
style_overview_footer_line_3_main_main_default.init()
style_overview_footer_line_3_main_main_default.set_img_recolor(lv.color_make(0xff,0xff,0xff))
style_overview_footer_line_3_main_main_default.set_img_recolor_opa(0)
style_overview_footer_line_3_main_main_default.set_img_opa(255)

# add style for Overview_footer_line_3
Overview_footer_line_3.add_style(style_overview_footer_line_3_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

Overview_gauge_label_1 = lv.label(Overview)
Overview_gauge_label_1.set_pos(70,110)
Overview_gauge_label_1.set_size(100,40)
Overview_gauge_label_1.set_text("0")
Overview_gauge_label_1.set_long_mode(lv.label.LONG.WRAP)
Overview_gauge_label_1.set_style_text_align(lv.TEXT_ALIGN.CENTER, 0)
# create style style_overview_gauge_label_1_main_main_default
style_overview_gauge_label_1_main_main_default = lv.style_t()
style_overview_gauge_label_1_main_main_default.init()
style_overview_gauge_label_1_main_main_default.set_radius(0)
style_overview_gauge_label_1_main_main_default.set_bg_color(lv.color_make(0xff,0xff,0xff))
style_overview_gauge_label_1_main_main_default.set_bg_grad_color(lv.color_make(0xff,0xff,0xff))
style_overview_gauge_label_1_main_main_default.set_bg_grad_dir(lv.GRAD_DIR.VER)
style_overview_gauge_label_1_main_main_default.set_bg_opa(0)
style_overview_gauge_label_1_main_main_default.set_text_color(lv.color_make(0xff,0xff,0xff))
try:
    style_overview_gauge_label_1_main_main_default.set_text_font(lv.font_montserratMedium_42)
except AttributeError:
    try:
        style_overview_gauge_label_1_main_main_default.set_text_font(lv.font_montserrat_42)
    except AttributeError:
        style_overview_gauge_label_1_main_main_default.set_text_font(lv.font_montserrat_16)
style_overview_gauge_label_1_main_main_default.set_text_letter_space(1)
style_overview_gauge_label_1_main_main_default.set_pad_left(0)
style_overview_gauge_label_1_main_main_default.set_pad_right(0)
style_overview_gauge_label_1_main_main_default.set_pad_top(0)
style_overview_gauge_label_1_main_main_default.set_pad_bottom(0)

# add style for Overview_gauge_label_1
Overview_gauge_label_1.add_style(style_overview_gauge_label_1_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

Overview_gauge_label_2 = lv.label(Overview)
Overview_gauge_label_2.set_pos(75,155)
Overview_gauge_label_2.set_size(100,32)
Overview_gauge_label_2.set_text("km/h")
Overview_gauge_label_2.set_long_mode(lv.label.LONG.WRAP)
Overview_gauge_label_2.set_style_text_align(lv.TEXT_ALIGN.CENTER, 0)
# create style style_overview_gauge_label_2_main_main_default
style_overview_gauge_label_2_main_main_default = lv.style_t()
style_overview_gauge_label_2_main_main_default.init()
style_overview_gauge_label_2_main_main_default.set_radius(0)
style_overview_gauge_label_2_main_main_default.set_bg_color(lv.color_make(0xff,0xff,0xff))
style_overview_gauge_label_2_main_main_default.set_bg_grad_color(lv.color_make(0xff,0xff,0xff))
style_overview_gauge_label_2_main_main_default.set_bg_grad_dir(lv.GRAD_DIR.VER)
style_overview_gauge_label_2_main_main_default.set_bg_opa(0)
style_overview_gauge_label_2_main_main_default.set_text_color(lv.color_make(0xff,0xff,0xff))
try:
    style_overview_gauge_label_2_main_main_default.set_text_font(lv.font_montserratMedium_12)
except AttributeError:
    try:
        style_overview_gauge_label_2_main_main_default.set_text_font(lv.font_montserrat_12)
    except AttributeError:
        style_overview_gauge_label_2_main_main_default.set_text_font(lv.font_montserrat_16)
style_overview_gauge_label_2_main_main_default.set_text_letter_space(0)
style_overview_gauge_label_2_main_main_default.set_pad_left(0)
style_overview_gauge_label_2_main_main_default.set_pad_right(0)
style_overview_gauge_label_2_main_main_default.set_pad_top(0)
style_overview_gauge_label_2_main_main_default.set_pad_bottom(0)

# add style for Overview_gauge_label_2
Overview_gauge_label_2.add_style(style_overview_gauge_label_2_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

Overview_cover_imgbtn = lv.imgbtn(Overview)
Overview_cover_imgbtn.set_pos(0,0)
Overview_cover_imgbtn.set_size(480,272)
try:
    with open('C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp1436734276.png','rb') as f:
        Overview_cover_imgbtn_imgReleased_data = f.read()
except:
    print('Could not open C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp1436734276.png')
    sys.exit()

Overview_cover_imgbtn_imgReleased = lv.img_dsc_t({
  'data_size': len(Overview_cover_imgbtn_imgReleased_data),
  'header': {'always_zero': 0, 'w': 480, 'h': 272, 'cf': lv.img.CF.TRUE_COLOR_ALPHA},
  'data': Overview_cover_imgbtn_imgReleased_data
})
Overview_cover_imgbtn.set_src(lv.imgbtn.STATE.RELEASED, Overview_cover_imgbtn_imgReleased, None, None)

try:
    with open('C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp1436734276.png','rb') as f:
        Overview_cover_imgbtn_imgPressed_data = f.read()
except:
    print('Could not open C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp1436734276.png')
    sys.exit()

Overview_cover_imgbtn_imgPressed = lv.img_dsc_t({
  'data_size': len(Overview_cover_imgbtn_imgPressed_data),
  'header': {'always_zero': 0, 'w': 480, 'h': 272, 'cf': lv.img.CF.TRUE_COLOR_ALPHA},
  'data': Overview_cover_imgbtn_imgPressed_data
})
Overview_cover_imgbtn.set_src(lv.imgbtn.STATE.PRESSED, Overview_cover_imgbtn_imgPressed, None, None)




# create style style_overview_cover_imgbtn_main_main_default
style_overview_cover_imgbtn_main_main_default = lv.style_t()
style_overview_cover_imgbtn_main_main_default.init()
style_overview_cover_imgbtn_main_main_default.set_text_color(lv.color_make(0x00,0x00,0x00))
try:
    style_overview_cover_imgbtn_main_main_default.set_text_font(lv.font_simsun_12)
except AttributeError:
    try:
        style_overview_cover_imgbtn_main_main_default.set_text_font(lv.font_montserrat_12)
    except AttributeError:
        style_overview_cover_imgbtn_main_main_default.set_text_font(lv.font_montserrat_16)
style_overview_cover_imgbtn_main_main_default.set_img_recolor(lv.color_make(0xff,0xff,0xff))
style_overview_cover_imgbtn_main_main_default.set_img_recolor_opa(0)
style_overview_cover_imgbtn_main_main_default.set_img_opa(0)

# add style for Overview_cover_imgbtn
Overview_cover_imgbtn.add_style(style_overview_cover_imgbtn_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

# create style style_overview_cover_imgbtn_main_main_pressed
style_overview_cover_imgbtn_main_main_pressed = lv.style_t()
style_overview_cover_imgbtn_main_main_pressed.init()
style_overview_cover_imgbtn_main_main_pressed.set_text_color(lv.color_make(0xFF,0x33,0xFF))
try:
    style_overview_cover_imgbtn_main_main_pressed.set_text_font(lv.font_simsun_16)
except AttributeError:
    try:
        style_overview_cover_imgbtn_main_main_pressed.set_text_font(lv.font_montserrat_16)
    except AttributeError:
        style_overview_cover_imgbtn_main_main_pressed.set_text_font(lv.font_montserrat_16)
style_overview_cover_imgbtn_main_main_pressed.set_img_recolor(lv.color_make(0x00,0x00,0x00))
style_overview_cover_imgbtn_main_main_pressed.set_img_recolor_opa(0)

# add style for Overview_cover_imgbtn
Overview_cover_imgbtn.add_style(style_overview_cover_imgbtn_main_main_pressed, lv.PART.MAIN|lv.STATE.PRESSED)

# create style style_overview_cover_imgbtn_main_main_checked
style_overview_cover_imgbtn_main_main_checked = lv.style_t()
style_overview_cover_imgbtn_main_main_checked.init()
style_overview_cover_imgbtn_main_main_checked.set_text_color(lv.color_make(0xFF,0x33,0xFF))
try:
    style_overview_cover_imgbtn_main_main_checked.set_text_font(lv.font_simsun_16)
except AttributeError:
    try:
        style_overview_cover_imgbtn_main_main_checked.set_text_font(lv.font_montserrat_16)
    except AttributeError:
        style_overview_cover_imgbtn_main_main_checked.set_text_font(lv.font_montserrat_16)
style_overview_cover_imgbtn_main_main_checked.set_img_recolor(lv.color_make(0x00,0x00,0x00))
style_overview_cover_imgbtn_main_main_checked.set_img_recolor_opa(0)

# add style for Overview_cover_imgbtn
Overview_cover_imgbtn.add_style(style_overview_cover_imgbtn_main_main_checked, lv.PART.MAIN|lv.STATE.CHECKED)

RideInfo1 = lv.obj()
# create style style_rideinfo1_main_main_default
style_rideinfo1_main_main_default = lv.style_t()
style_rideinfo1_main_main_default.init()
style_rideinfo1_main_main_default.set_bg_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo1_main_main_default.set_bg_opa(0)

# add style for RideInfo1
RideInfo1.add_style(style_rideinfo1_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

RideInfo1_bg_img = lv.img(RideInfo1)
RideInfo1_bg_img.set_pos(0,0)
RideInfo1_bg_img.set_size(480,272)
RideInfo1_bg_img.add_flag(lv.obj.FLAG.CLICKABLE)
try:
    with open('C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp1436734276.png','rb') as f:
        RideInfo1_bg_img_img_data = f.read()
except:
    print('Could not open C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp1436734276.png')
    sys.exit()

RideInfo1_bg_img_img = lv.img_dsc_t({
  'data_size': len(RideInfo1_bg_img_img_data),
  'header': {'always_zero': 0, 'w': 480, 'h': 272, 'cf': lv.img.CF.TRUE_COLOR_ALPHA},
  'data': RideInfo1_bg_img_img_data
})

RideInfo1_bg_img.set_src(RideInfo1_bg_img_img)
RideInfo1_bg_img.set_pivot(0,0)
RideInfo1_bg_img.set_angle(0)
# create style style_rideinfo1_bg_img_main_main_default
style_rideinfo1_bg_img_main_main_default = lv.style_t()
style_rideinfo1_bg_img_main_main_default.init()
style_rideinfo1_bg_img_main_main_default.set_img_recolor(lv.color_make(0xff,0xff,0xff))
style_rideinfo1_bg_img_main_main_default.set_img_recolor_opa(0)
style_rideinfo1_bg_img_main_main_default.set_img_opa(255)

# add style for RideInfo1_bg_img
RideInfo1_bg_img.add_style(style_rideinfo1_bg_img_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

RideInfo1_hdr_img = lv.img(RideInfo1)
RideInfo1_hdr_img.set_pos(0,0)
RideInfo1_hdr_img.set_size(480,51)
RideInfo1_hdr_img.add_flag(lv.obj.FLAG.CLICKABLE)
try:
    with open('C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp-871685027.png','rb') as f:
        RideInfo1_hdr_img_img_data = f.read()
except:
    print('Could not open C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp-871685027.png')
    sys.exit()

RideInfo1_hdr_img_img = lv.img_dsc_t({
  'data_size': len(RideInfo1_hdr_img_img_data),
  'header': {'always_zero': 0, 'w': 480, 'h': 51, 'cf': lv.img.CF.TRUE_COLOR_ALPHA},
  'data': RideInfo1_hdr_img_img_data
})

RideInfo1_hdr_img.set_src(RideInfo1_hdr_img_img)
RideInfo1_hdr_img.set_pivot(0,0)
RideInfo1_hdr_img.set_angle(0)
# create style style_rideinfo1_hdr_img_main_main_default
style_rideinfo1_hdr_img_main_main_default = lv.style_t()
style_rideinfo1_hdr_img_main_main_default.init()
style_rideinfo1_hdr_img_main_main_default.set_img_recolor(lv.color_make(0xff,0xff,0xff))
style_rideinfo1_hdr_img_main_main_default.set_img_recolor_opa(0)
style_rideinfo1_hdr_img_main_main_default.set_img_opa(255)

# add style for RideInfo1_hdr_img
RideInfo1_hdr_img.add_style(style_rideinfo1_hdr_img_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

RideInfo1_date_label = lv.label(RideInfo1)
RideInfo1_date_label.set_pos(20,5)
RideInfo1_date_label.set_size(100,32)
RideInfo1_date_label.set_text("May 5, 2022")
RideInfo1_date_label.set_long_mode(lv.label.LONG.WRAP)
RideInfo1_date_label.set_style_text_align(lv.TEXT_ALIGN.LEFT, 0)
# create style style_rideinfo1_date_label_main_main_default
style_rideinfo1_date_label_main_main_default = lv.style_t()
style_rideinfo1_date_label_main_main_default.init()
style_rideinfo1_date_label_main_main_default.set_radius(0)
style_rideinfo1_date_label_main_main_default.set_bg_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo1_date_label_main_main_default.set_bg_grad_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo1_date_label_main_main_default.set_bg_grad_dir(lv.GRAD_DIR.VER)
style_rideinfo1_date_label_main_main_default.set_bg_opa(0)
style_rideinfo1_date_label_main_main_default.set_text_color(lv.color_make(0xff,0xff,0xff))
try:
    style_rideinfo1_date_label_main_main_default.set_text_font(lv.font_montserratMedium_12)
except AttributeError:
    try:
        style_rideinfo1_date_label_main_main_default.set_text_font(lv.font_montserrat_12)
    except AttributeError:
        style_rideinfo1_date_label_main_main_default.set_text_font(lv.font_montserrat_16)
style_rideinfo1_date_label_main_main_default.set_text_letter_space(1)
style_rideinfo1_date_label_main_main_default.set_pad_left(0)
style_rideinfo1_date_label_main_main_default.set_pad_right(0)
style_rideinfo1_date_label_main_main_default.set_pad_top(0)
style_rideinfo1_date_label_main_main_default.set_pad_bottom(0)

# add style for RideInfo1_date_label
RideInfo1_date_label.add_style(style_rideinfo1_date_label_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

RideInfo1_time_label = lv.label(RideInfo1)
RideInfo1_time_label.set_pos(360,5)
RideInfo1_time_label.set_size(100,32)
RideInfo1_time_label.set_text("10:28 AM")
RideInfo1_time_label.set_long_mode(lv.label.LONG.WRAP)
RideInfo1_time_label.set_style_text_align(lv.TEXT_ALIGN.RIGHT, 0)
# create style style_rideinfo1_time_label_main_main_default
style_rideinfo1_time_label_main_main_default = lv.style_t()
style_rideinfo1_time_label_main_main_default.init()
style_rideinfo1_time_label_main_main_default.set_radius(0)
style_rideinfo1_time_label_main_main_default.set_bg_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo1_time_label_main_main_default.set_bg_grad_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo1_time_label_main_main_default.set_bg_grad_dir(lv.GRAD_DIR.VER)
style_rideinfo1_time_label_main_main_default.set_bg_opa(0)
style_rideinfo1_time_label_main_main_default.set_text_color(lv.color_make(0xff,0xff,0xff))
try:
    style_rideinfo1_time_label_main_main_default.set_text_font(lv.font_montserratMedium_12)
except AttributeError:
    try:
        style_rideinfo1_time_label_main_main_default.set_text_font(lv.font_montserrat_12)
    except AttributeError:
        style_rideinfo1_time_label_main_main_default.set_text_font(lv.font_montserrat_16)
style_rideinfo1_time_label_main_main_default.set_text_letter_space(1)
style_rideinfo1_time_label_main_main_default.set_pad_left(0)
style_rideinfo1_time_label_main_main_default.set_pad_right(0)
style_rideinfo1_time_label_main_main_default.set_pad_top(0)
style_rideinfo1_time_label_main_main_default.set_pad_bottom(0)

# add style for RideInfo1_time_label
RideInfo1_time_label.add_style(style_rideinfo1_time_label_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

RideInfo1_sub_label = lv.label(RideInfo1)
RideInfo1_sub_label.set_pos(160,5)
RideInfo1_sub_label.set_size(180,32)
RideInfo1_sub_label.set_text("RIDE DETAILS")
RideInfo1_sub_label.set_long_mode(lv.label.LONG.WRAP)
RideInfo1_sub_label.set_style_text_align(lv.TEXT_ALIGN.LEFT, 0)
# create style style_rideinfo1_sub_label_main_main_default
style_rideinfo1_sub_label_main_main_default = lv.style_t()
style_rideinfo1_sub_label_main_main_default.init()
style_rideinfo1_sub_label_main_main_default.set_radius(0)
style_rideinfo1_sub_label_main_main_default.set_bg_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo1_sub_label_main_main_default.set_bg_grad_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo1_sub_label_main_main_default.set_bg_grad_dir(lv.GRAD_DIR.VER)
style_rideinfo1_sub_label_main_main_default.set_bg_opa(0)
style_rideinfo1_sub_label_main_main_default.set_text_color(lv.color_make(0xff,0xff,0xff))
try:
    style_rideinfo1_sub_label_main_main_default.set_text_font(lv.font_montserratMedium_20)
except AttributeError:
    try:
        style_rideinfo1_sub_label_main_main_default.set_text_font(lv.font_montserrat_20)
    except AttributeError:
        style_rideinfo1_sub_label_main_main_default.set_text_font(lv.font_montserrat_16)
style_rideinfo1_sub_label_main_main_default.set_text_letter_space(1)
style_rideinfo1_sub_label_main_main_default.set_pad_left(0)
style_rideinfo1_sub_label_main_main_default.set_pad_right(0)
style_rideinfo1_sub_label_main_main_default.set_pad_top(0)
style_rideinfo1_sub_label_main_main_default.set_pad_bottom(0)

# add style for RideInfo1_sub_label
RideInfo1_sub_label.add_style(style_rideinfo1_sub_label_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

RideInfo1_gain_img = lv.img(RideInfo1)
RideInfo1_gain_img.set_pos(244,183)
RideInfo1_gain_img.set_size(22,18)
RideInfo1_gain_img.add_flag(lv.obj.FLAG.CLICKABLE)
try:
    with open('C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp567637940.png','rb') as f:
        RideInfo1_gain_img_img_data = f.read()
except:
    print('Could not open C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp567637940.png')
    sys.exit()

RideInfo1_gain_img_img = lv.img_dsc_t({
  'data_size': len(RideInfo1_gain_img_img_data),
  'header': {'always_zero': 0, 'w': 22, 'h': 18, 'cf': lv.img.CF.TRUE_COLOR_ALPHA},
  'data': RideInfo1_gain_img_img_data
})

RideInfo1_gain_img.set_src(RideInfo1_gain_img_img)
RideInfo1_gain_img.set_pivot(0,0)
RideInfo1_gain_img.set_angle(0)
# create style style_rideinfo1_gain_img_main_main_default
style_rideinfo1_gain_img_main_main_default = lv.style_t()
style_rideinfo1_gain_img_main_main_default.init()
style_rideinfo1_gain_img_main_main_default.set_img_recolor(lv.color_make(0xff,0xff,0xff))
style_rideinfo1_gain_img_main_main_default.set_img_recolor_opa(0)
style_rideinfo1_gain_img_main_main_default.set_img_opa(255)

# add style for RideInfo1_gain_img
RideInfo1_gain_img.add_style(style_rideinfo1_gain_img_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

RideInfo1_lost_img = lv.img(RideInfo1)
RideInfo1_lost_img.set_pos(360,183)
RideInfo1_lost_img.set_size(21,18)
RideInfo1_lost_img.add_flag(lv.obj.FLAG.CLICKABLE)
try:
    with open('C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp-1686926727.png','rb') as f:
        RideInfo1_lost_img_img_data = f.read()
except:
    print('Could not open C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp-1686926727.png')
    sys.exit()

RideInfo1_lost_img_img = lv.img_dsc_t({
  'data_size': len(RideInfo1_lost_img_img_data),
  'header': {'always_zero': 0, 'w': 21, 'h': 18, 'cf': lv.img.CF.TRUE_COLOR_ALPHA},
  'data': RideInfo1_lost_img_img_data
})

RideInfo1_lost_img.set_src(RideInfo1_lost_img_img)
RideInfo1_lost_img.set_pivot(0,0)
RideInfo1_lost_img.set_angle(0)
# create style style_rideinfo1_lost_img_main_main_default
style_rideinfo1_lost_img_main_main_default = lv.style_t()
style_rideinfo1_lost_img_main_main_default.init()
style_rideinfo1_lost_img_main_main_default.set_img_recolor(lv.color_make(0xff,0xff,0xff))
style_rideinfo1_lost_img_main_main_default.set_img_recolor_opa(0)
style_rideinfo1_lost_img_main_main_default.set_img_opa(255)

# add style for RideInfo1_lost_img
RideInfo1_lost_img.add_style(style_rideinfo1_lost_img_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

RideInfo1_info1_label_1 = lv.label(RideInfo1)
RideInfo1_info1_label_1.set_pos(290,40)
RideInfo1_info1_label_1.set_size(130,32)
RideInfo1_info1_label_1.set_text("Distance Travelled")
RideInfo1_info1_label_1.set_long_mode(lv.label.LONG.WRAP)
RideInfo1_info1_label_1.set_style_text_align(lv.TEXT_ALIGN.LEFT, 0)
# create style style_rideinfo1_info1_label_1_main_main_default
style_rideinfo1_info1_label_1_main_main_default = lv.style_t()
style_rideinfo1_info1_label_1_main_main_default.init()
style_rideinfo1_info1_label_1_main_main_default.set_radius(0)
style_rideinfo1_info1_label_1_main_main_default.set_bg_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo1_info1_label_1_main_main_default.set_bg_grad_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo1_info1_label_1_main_main_default.set_bg_grad_dir(lv.GRAD_DIR.VER)
style_rideinfo1_info1_label_1_main_main_default.set_bg_opa(0)
style_rideinfo1_info1_label_1_main_main_default.set_text_color(lv.color_make(0x9e,0x9e,0x9e))
try:
    style_rideinfo1_info1_label_1_main_main_default.set_text_font(lv.font_montserratMedium_12)
except AttributeError:
    try:
        style_rideinfo1_info1_label_1_main_main_default.set_text_font(lv.font_montserrat_12)
    except AttributeError:
        style_rideinfo1_info1_label_1_main_main_default.set_text_font(lv.font_montserrat_16)
style_rideinfo1_info1_label_1_main_main_default.set_text_letter_space(0)
style_rideinfo1_info1_label_1_main_main_default.set_pad_left(0)
style_rideinfo1_info1_label_1_main_main_default.set_pad_right(0)
style_rideinfo1_info1_label_1_main_main_default.set_pad_top(0)
style_rideinfo1_info1_label_1_main_main_default.set_pad_bottom(0)

# add style for RideInfo1_info1_label_1
RideInfo1_info1_label_1.add_style(style_rideinfo1_info1_label_1_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

RideInfo1_info2_label_1 = lv.label(RideInfo1)
RideInfo1_info2_label_1.set_pos(290,112)
RideInfo1_info2_label_1.set_size(150,32)
RideInfo1_info2_label_1.set_text("Average Speed")
RideInfo1_info2_label_1.set_long_mode(lv.label.LONG.WRAP)
RideInfo1_info2_label_1.set_style_text_align(lv.TEXT_ALIGN.LEFT, 0)
# create style style_rideinfo1_info2_label_1_main_main_default
style_rideinfo1_info2_label_1_main_main_default = lv.style_t()
style_rideinfo1_info2_label_1_main_main_default.init()
style_rideinfo1_info2_label_1_main_main_default.set_radius(0)
style_rideinfo1_info2_label_1_main_main_default.set_bg_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo1_info2_label_1_main_main_default.set_bg_grad_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo1_info2_label_1_main_main_default.set_bg_grad_dir(lv.GRAD_DIR.VER)
style_rideinfo1_info2_label_1_main_main_default.set_bg_opa(0)
style_rideinfo1_info2_label_1_main_main_default.set_text_color(lv.color_make(0x9e,0x9e,0x9e))
try:
    style_rideinfo1_info2_label_1_main_main_default.set_text_font(lv.font_montserratMedium_12)
except AttributeError:
    try:
        style_rideinfo1_info2_label_1_main_main_default.set_text_font(lv.font_montserrat_12)
    except AttributeError:
        style_rideinfo1_info2_label_1_main_main_default.set_text_font(lv.font_montserrat_16)
style_rideinfo1_info2_label_1_main_main_default.set_text_letter_space(0)
style_rideinfo1_info2_label_1_main_main_default.set_pad_left(0)
style_rideinfo1_info2_label_1_main_main_default.set_pad_right(0)
style_rideinfo1_info2_label_1_main_main_default.set_pad_top(0)
style_rideinfo1_info2_label_1_main_main_default.set_pad_bottom(0)

# add style for RideInfo1_info2_label_1
RideInfo1_info2_label_1.add_style(style_rideinfo1_info2_label_1_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

RideInfo1_info3_label_1 = lv.label(RideInfo1)
RideInfo1_info3_label_1.set_pos(274,178)
RideInfo1_info3_label_1.set_size(80,32)
RideInfo1_info3_label_1.set_text("Elevation")
RideInfo1_info3_label_1.set_long_mode(lv.label.LONG.WRAP)
RideInfo1_info3_label_1.set_style_text_align(lv.TEXT_ALIGN.LEFT, 0)
# create style style_rideinfo1_info3_label_1_main_main_default
style_rideinfo1_info3_label_1_main_main_default = lv.style_t()
style_rideinfo1_info3_label_1_main_main_default.init()
style_rideinfo1_info3_label_1_main_main_default.set_radius(0)
style_rideinfo1_info3_label_1_main_main_default.set_bg_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo1_info3_label_1_main_main_default.set_bg_grad_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo1_info3_label_1_main_main_default.set_bg_grad_dir(lv.GRAD_DIR.VER)
style_rideinfo1_info3_label_1_main_main_default.set_bg_opa(0)
style_rideinfo1_info3_label_1_main_main_default.set_text_color(lv.color_make(0x9e,0x9e,0x9e))
try:
    style_rideinfo1_info3_label_1_main_main_default.set_text_font(lv.font_montserratMedium_12)
except AttributeError:
    try:
        style_rideinfo1_info3_label_1_main_main_default.set_text_font(lv.font_montserrat_12)
    except AttributeError:
        style_rideinfo1_info3_label_1_main_main_default.set_text_font(lv.font_montserrat_16)
style_rideinfo1_info3_label_1_main_main_default.set_text_letter_space(0)
style_rideinfo1_info3_label_1_main_main_default.set_pad_left(0)
style_rideinfo1_info3_label_1_main_main_default.set_pad_right(0)
style_rideinfo1_info3_label_1_main_main_default.set_pad_top(0)
style_rideinfo1_info3_label_1_main_main_default.set_pad_bottom(0)

# add style for RideInfo1_info3_label_1
RideInfo1_info3_label_1.add_style(style_rideinfo1_info3_label_1_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

RideInfo1_info3_label_2 = lv.label(RideInfo1)
RideInfo1_info3_label_2.set_pos(274,190)
RideInfo1_info3_label_2.set_size(60,32)
RideInfo1_info3_label_2.set_text("Gained")
RideInfo1_info3_label_2.set_long_mode(lv.label.LONG.WRAP)
RideInfo1_info3_label_2.set_style_text_align(lv.TEXT_ALIGN.LEFT, 0)
# create style style_rideinfo1_info3_label_2_main_main_default
style_rideinfo1_info3_label_2_main_main_default = lv.style_t()
style_rideinfo1_info3_label_2_main_main_default.init()
style_rideinfo1_info3_label_2_main_main_default.set_radius(0)
style_rideinfo1_info3_label_2_main_main_default.set_bg_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo1_info3_label_2_main_main_default.set_bg_grad_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo1_info3_label_2_main_main_default.set_bg_grad_dir(lv.GRAD_DIR.VER)
style_rideinfo1_info3_label_2_main_main_default.set_bg_opa(0)
style_rideinfo1_info3_label_2_main_main_default.set_text_color(lv.color_make(0x9e,0x9e,0x9e))
try:
    style_rideinfo1_info3_label_2_main_main_default.set_text_font(lv.font_montserratMedium_12)
except AttributeError:
    try:
        style_rideinfo1_info3_label_2_main_main_default.set_text_font(lv.font_montserrat_12)
    except AttributeError:
        style_rideinfo1_info3_label_2_main_main_default.set_text_font(lv.font_montserrat_16)
style_rideinfo1_info3_label_2_main_main_default.set_text_letter_space(0)
style_rideinfo1_info3_label_2_main_main_default.set_pad_left(0)
style_rideinfo1_info3_label_2_main_main_default.set_pad_right(0)
style_rideinfo1_info3_label_2_main_main_default.set_pad_top(0)
style_rideinfo1_info3_label_2_main_main_default.set_pad_bottom(0)

# add style for RideInfo1_info3_label_2
RideInfo1_info3_label_2.add_style(style_rideinfo1_info3_label_2_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

RideInfo1_linfo4_label_1 = lv.label(RideInfo1)
RideInfo1_linfo4_label_1.set_pos(394,178)
RideInfo1_linfo4_label_1.set_size(60,32)
RideInfo1_linfo4_label_1.set_text("Elevation")
RideInfo1_linfo4_label_1.set_long_mode(lv.label.LONG.WRAP)
RideInfo1_linfo4_label_1.set_style_text_align(lv.TEXT_ALIGN.LEFT, 0)
# create style style_rideinfo1_linfo4_label_1_main_main_default
style_rideinfo1_linfo4_label_1_main_main_default = lv.style_t()
style_rideinfo1_linfo4_label_1_main_main_default.init()
style_rideinfo1_linfo4_label_1_main_main_default.set_radius(0)
style_rideinfo1_linfo4_label_1_main_main_default.set_bg_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo1_linfo4_label_1_main_main_default.set_bg_grad_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo1_linfo4_label_1_main_main_default.set_bg_grad_dir(lv.GRAD_DIR.VER)
style_rideinfo1_linfo4_label_1_main_main_default.set_bg_opa(0)
style_rideinfo1_linfo4_label_1_main_main_default.set_text_color(lv.color_make(0x9e,0x9e,0x9e))
try:
    style_rideinfo1_linfo4_label_1_main_main_default.set_text_font(lv.font_montserratMedium_12)
except AttributeError:
    try:
        style_rideinfo1_linfo4_label_1_main_main_default.set_text_font(lv.font_montserrat_12)
    except AttributeError:
        style_rideinfo1_linfo4_label_1_main_main_default.set_text_font(lv.font_montserrat_16)
style_rideinfo1_linfo4_label_1_main_main_default.set_text_letter_space(0)
style_rideinfo1_linfo4_label_1_main_main_default.set_pad_left(0)
style_rideinfo1_linfo4_label_1_main_main_default.set_pad_right(0)
style_rideinfo1_linfo4_label_1_main_main_default.set_pad_top(0)
style_rideinfo1_linfo4_label_1_main_main_default.set_pad_bottom(0)

# add style for RideInfo1_linfo4_label_1
RideInfo1_linfo4_label_1.add_style(style_rideinfo1_linfo4_label_1_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

RideInfo1_linfo4_label_2 = lv.label(RideInfo1)
RideInfo1_linfo4_label_2.set_pos(394,190)
RideInfo1_linfo4_label_2.set_size(60,32)
RideInfo1_linfo4_label_2.set_text("Lost")
RideInfo1_linfo4_label_2.set_long_mode(lv.label.LONG.WRAP)
RideInfo1_linfo4_label_2.set_style_text_align(lv.TEXT_ALIGN.LEFT, 0)
# create style style_rideinfo1_linfo4_label_2_main_main_default
style_rideinfo1_linfo4_label_2_main_main_default = lv.style_t()
style_rideinfo1_linfo4_label_2_main_main_default.init()
style_rideinfo1_linfo4_label_2_main_main_default.set_radius(0)
style_rideinfo1_linfo4_label_2_main_main_default.set_bg_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo1_linfo4_label_2_main_main_default.set_bg_grad_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo1_linfo4_label_2_main_main_default.set_bg_grad_dir(lv.GRAD_DIR.VER)
style_rideinfo1_linfo4_label_2_main_main_default.set_bg_opa(0)
style_rideinfo1_linfo4_label_2_main_main_default.set_text_color(lv.color_make(0x9e,0x9e,0x9e))
try:
    style_rideinfo1_linfo4_label_2_main_main_default.set_text_font(lv.font_montserratMedium_12)
except AttributeError:
    try:
        style_rideinfo1_linfo4_label_2_main_main_default.set_text_font(lv.font_montserrat_12)
    except AttributeError:
        style_rideinfo1_linfo4_label_2_main_main_default.set_text_font(lv.font_montserrat_16)
style_rideinfo1_linfo4_label_2_main_main_default.set_text_letter_space(0)
style_rideinfo1_linfo4_label_2_main_main_default.set_pad_left(0)
style_rideinfo1_linfo4_label_2_main_main_default.set_pad_right(0)
style_rideinfo1_linfo4_label_2_main_main_default.set_pad_top(0)
style_rideinfo1_linfo4_label_2_main_main_default.set_pad_bottom(0)

# add style for RideInfo1_linfo4_label_2
RideInfo1_linfo4_label_2.add_style(style_rideinfo1_linfo4_label_2_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

RideInfo1_info1_label_3 = lv.label(RideInfo1)
RideInfo1_info1_label_3.set_pos(319,70)
RideInfo1_info1_label_3.set_size(70,32)
RideInfo1_info1_label_3.set_text("12.7")
RideInfo1_info1_label_3.set_long_mode(lv.label.LONG.WRAP)
RideInfo1_info1_label_3.set_style_text_align(lv.TEXT_ALIGN.LEFT, 0)
# create style style_rideinfo1_info1_label_3_main_main_default
style_rideinfo1_info1_label_3_main_main_default = lv.style_t()
style_rideinfo1_info1_label_3_main_main_default.init()
style_rideinfo1_info1_label_3_main_main_default.set_radius(0)
style_rideinfo1_info1_label_3_main_main_default.set_bg_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo1_info1_label_3_main_main_default.set_bg_grad_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo1_info1_label_3_main_main_default.set_bg_grad_dir(lv.GRAD_DIR.VER)
style_rideinfo1_info1_label_3_main_main_default.set_bg_opa(0)
style_rideinfo1_info1_label_3_main_main_default.set_text_color(lv.color_make(0x00,0x80,0xff))
try:
    style_rideinfo1_info1_label_3_main_main_default.set_text_font(lv.font_montserratMedium_28)
except AttributeError:
    try:
        style_rideinfo1_info1_label_3_main_main_default.set_text_font(lv.font_montserrat_28)
    except AttributeError:
        style_rideinfo1_info1_label_3_main_main_default.set_text_font(lv.font_montserrat_16)
style_rideinfo1_info1_label_3_main_main_default.set_text_letter_space(0)
style_rideinfo1_info1_label_3_main_main_default.set_pad_left(0)
style_rideinfo1_info1_label_3_main_main_default.set_pad_right(0)
style_rideinfo1_info1_label_3_main_main_default.set_pad_top(0)
style_rideinfo1_info1_label_3_main_main_default.set_pad_bottom(0)

# add style for RideInfo1_info1_label_3
RideInfo1_info1_label_3.add_style(style_rideinfo1_info1_label_3_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

RideInfo1_info2_label_3 = lv.label(RideInfo1)
RideInfo1_info2_label_3.set_pos(320,140)
RideInfo1_info2_label_3.set_size(70,32)
RideInfo1_info2_label_3.set_text("16.1")
RideInfo1_info2_label_3.set_long_mode(lv.label.LONG.WRAP)
RideInfo1_info2_label_3.set_style_text_align(lv.TEXT_ALIGN.LEFT, 0)
# create style style_rideinfo1_info2_label_3_main_main_default
style_rideinfo1_info2_label_3_main_main_default = lv.style_t()
style_rideinfo1_info2_label_3_main_main_default.init()
style_rideinfo1_info2_label_3_main_main_default.set_radius(0)
style_rideinfo1_info2_label_3_main_main_default.set_bg_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo1_info2_label_3_main_main_default.set_bg_grad_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo1_info2_label_3_main_main_default.set_bg_grad_dir(lv.GRAD_DIR.VER)
style_rideinfo1_info2_label_3_main_main_default.set_bg_opa(0)
style_rideinfo1_info2_label_3_main_main_default.set_text_color(lv.color_make(0x00,0x80,0xff))
try:
    style_rideinfo1_info2_label_3_main_main_default.set_text_font(lv.font_montserratMedium_28)
except AttributeError:
    try:
        style_rideinfo1_info2_label_3_main_main_default.set_text_font(lv.font_montserrat_28)
    except AttributeError:
        style_rideinfo1_info2_label_3_main_main_default.set_text_font(lv.font_montserrat_16)
style_rideinfo1_info2_label_3_main_main_default.set_text_letter_space(0)
style_rideinfo1_info2_label_3_main_main_default.set_pad_left(0)
style_rideinfo1_info2_label_3_main_main_default.set_pad_right(0)
style_rideinfo1_info2_label_3_main_main_default.set_pad_top(0)
style_rideinfo1_info2_label_3_main_main_default.set_pad_bottom(0)

# add style for RideInfo1_info2_label_3
RideInfo1_info2_label_3.add_style(style_rideinfo1_info2_label_3_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

RideInfo1_info3_label_3 = lv.label(RideInfo1)
RideInfo1_info3_label_3.set_pos(244,212)
RideInfo1_info3_label_3.set_size(50,32)
RideInfo1_info3_label_3.set_text("25.1")
RideInfo1_info3_label_3.set_long_mode(lv.label.LONG.WRAP)
RideInfo1_info3_label_3.set_style_text_align(lv.TEXT_ALIGN.LEFT, 0)
# create style style_rideinfo1_info3_label_3_main_main_default
style_rideinfo1_info3_label_3_main_main_default = lv.style_t()
style_rideinfo1_info3_label_3_main_main_default.init()
style_rideinfo1_info3_label_3_main_main_default.set_radius(0)
style_rideinfo1_info3_label_3_main_main_default.set_bg_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo1_info3_label_3_main_main_default.set_bg_grad_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo1_info3_label_3_main_main_default.set_bg_grad_dir(lv.GRAD_DIR.VER)
style_rideinfo1_info3_label_3_main_main_default.set_bg_opa(0)
style_rideinfo1_info3_label_3_main_main_default.set_text_color(lv.color_make(0x00,0x80,0xff))
try:
    style_rideinfo1_info3_label_3_main_main_default.set_text_font(lv.font_montserratMedium_20)
except AttributeError:
    try:
        style_rideinfo1_info3_label_3_main_main_default.set_text_font(lv.font_montserrat_20)
    except AttributeError:
        style_rideinfo1_info3_label_3_main_main_default.set_text_font(lv.font_montserrat_16)
style_rideinfo1_info3_label_3_main_main_default.set_text_letter_space(0)
style_rideinfo1_info3_label_3_main_main_default.set_pad_left(0)
style_rideinfo1_info3_label_3_main_main_default.set_pad_right(0)
style_rideinfo1_info3_label_3_main_main_default.set_pad_top(0)
style_rideinfo1_info3_label_3_main_main_default.set_pad_bottom(0)

# add style for RideInfo1_info3_label_3
RideInfo1_info3_label_3.add_style(style_rideinfo1_info3_label_3_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

RideInfo1_info4_label_3 = lv.label(RideInfo1)
RideInfo1_info4_label_3.set_pos(360,212)
RideInfo1_info4_label_3.set_size(50,32)
RideInfo1_info4_label_3.set_text("10.2")
RideInfo1_info4_label_3.set_long_mode(lv.label.LONG.WRAP)
RideInfo1_info4_label_3.set_style_text_align(lv.TEXT_ALIGN.LEFT, 0)
# create style style_rideinfo1_info4_label_3_main_main_default
style_rideinfo1_info4_label_3_main_main_default = lv.style_t()
style_rideinfo1_info4_label_3_main_main_default.init()
style_rideinfo1_info4_label_3_main_main_default.set_radius(0)
style_rideinfo1_info4_label_3_main_main_default.set_bg_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo1_info4_label_3_main_main_default.set_bg_grad_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo1_info4_label_3_main_main_default.set_bg_grad_dir(lv.GRAD_DIR.VER)
style_rideinfo1_info4_label_3_main_main_default.set_bg_opa(0)
style_rideinfo1_info4_label_3_main_main_default.set_text_color(lv.color_make(0x00,0x80,0xff))
try:
    style_rideinfo1_info4_label_3_main_main_default.set_text_font(lv.font_montserratMedium_20)
except AttributeError:
    try:
        style_rideinfo1_info4_label_3_main_main_default.set_text_font(lv.font_montserrat_20)
    except AttributeError:
        style_rideinfo1_info4_label_3_main_main_default.set_text_font(lv.font_montserrat_16)
style_rideinfo1_info4_label_3_main_main_default.set_text_letter_space(0)
style_rideinfo1_info4_label_3_main_main_default.set_pad_left(0)
style_rideinfo1_info4_label_3_main_main_default.set_pad_right(0)
style_rideinfo1_info4_label_3_main_main_default.set_pad_top(0)
style_rideinfo1_info4_label_3_main_main_default.set_pad_bottom(0)

# add style for RideInfo1_info4_label_3
RideInfo1_info4_label_3.add_style(style_rideinfo1_info4_label_3_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

RideInfo1_info1_label_2 = lv.label(RideInfo1)
RideInfo1_info1_label_2.set_pos(374,77)
RideInfo1_info1_label_2.set_size(50,32)
RideInfo1_info1_label_2.set_text("km")
RideInfo1_info1_label_2.set_long_mode(lv.label.LONG.WRAP)
RideInfo1_info1_label_2.set_style_text_align(lv.TEXT_ALIGN.LEFT, 0)
# create style style_rideinfo1_info1_label_2_main_main_default
style_rideinfo1_info1_label_2_main_main_default = lv.style_t()
style_rideinfo1_info1_label_2_main_main_default.init()
style_rideinfo1_info1_label_2_main_main_default.set_radius(0)
style_rideinfo1_info1_label_2_main_main_default.set_bg_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo1_info1_label_2_main_main_default.set_bg_grad_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo1_info1_label_2_main_main_default.set_bg_grad_dir(lv.GRAD_DIR.VER)
style_rideinfo1_info1_label_2_main_main_default.set_bg_opa(0)
style_rideinfo1_info1_label_2_main_main_default.set_text_color(lv.color_make(0x9e,0x9e,0x9e))
try:
    style_rideinfo1_info1_label_2_main_main_default.set_text_font(lv.font_montserratMedium_12)
except AttributeError:
    try:
        style_rideinfo1_info1_label_2_main_main_default.set_text_font(lv.font_montserrat_12)
    except AttributeError:
        style_rideinfo1_info1_label_2_main_main_default.set_text_font(lv.font_montserrat_16)
style_rideinfo1_info1_label_2_main_main_default.set_text_letter_space(0)
style_rideinfo1_info1_label_2_main_main_default.set_pad_left(0)
style_rideinfo1_info1_label_2_main_main_default.set_pad_right(0)
style_rideinfo1_info1_label_2_main_main_default.set_pad_top(0)
style_rideinfo1_info1_label_2_main_main_default.set_pad_bottom(0)

# add style for RideInfo1_info1_label_2
RideInfo1_info1_label_2.add_style(style_rideinfo1_info1_label_2_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

RideInfo1_info3_label_4 = lv.label(RideInfo1)
RideInfo1_info3_label_4.set_pos(288,219)
RideInfo1_info3_label_4.set_size(30,32)
RideInfo1_info3_label_4.set_text("m")
RideInfo1_info3_label_4.set_long_mode(lv.label.LONG.WRAP)
RideInfo1_info3_label_4.set_style_text_align(lv.TEXT_ALIGN.LEFT, 0)
# create style style_rideinfo1_info3_label_4_main_main_default
style_rideinfo1_info3_label_4_main_main_default = lv.style_t()
style_rideinfo1_info3_label_4_main_main_default.init()
style_rideinfo1_info3_label_4_main_main_default.set_radius(0)
style_rideinfo1_info3_label_4_main_main_default.set_bg_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo1_info3_label_4_main_main_default.set_bg_grad_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo1_info3_label_4_main_main_default.set_bg_grad_dir(lv.GRAD_DIR.VER)
style_rideinfo1_info3_label_4_main_main_default.set_bg_opa(0)
style_rideinfo1_info3_label_4_main_main_default.set_text_color(lv.color_make(0x9e,0x9e,0x9e))
try:
    style_rideinfo1_info3_label_4_main_main_default.set_text_font(lv.font_montserratMedium_12)
except AttributeError:
    try:
        style_rideinfo1_info3_label_4_main_main_default.set_text_font(lv.font_montserrat_12)
    except AttributeError:
        style_rideinfo1_info3_label_4_main_main_default.set_text_font(lv.font_montserrat_16)
style_rideinfo1_info3_label_4_main_main_default.set_text_letter_space(0)
style_rideinfo1_info3_label_4_main_main_default.set_pad_left(0)
style_rideinfo1_info3_label_4_main_main_default.set_pad_right(0)
style_rideinfo1_info3_label_4_main_main_default.set_pad_top(0)
style_rideinfo1_info3_label_4_main_main_default.set_pad_bottom(0)

# add style for RideInfo1_info3_label_4
RideInfo1_info3_label_4.add_style(style_rideinfo1_info3_label_4_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

RideInfo1_info2_label_2 = lv.label(RideInfo1)
RideInfo1_info2_label_2.set_pos(374,147)
RideInfo1_info2_label_2.set_size(60,32)
RideInfo1_info2_label_2.set_text("km/h")
RideInfo1_info2_label_2.set_long_mode(lv.label.LONG.WRAP)
RideInfo1_info2_label_2.set_style_text_align(lv.TEXT_ALIGN.LEFT, 0)
# create style style_rideinfo1_info2_label_2_main_main_default
style_rideinfo1_info2_label_2_main_main_default = lv.style_t()
style_rideinfo1_info2_label_2_main_main_default.init()
style_rideinfo1_info2_label_2_main_main_default.set_radius(0)
style_rideinfo1_info2_label_2_main_main_default.set_bg_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo1_info2_label_2_main_main_default.set_bg_grad_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo1_info2_label_2_main_main_default.set_bg_grad_dir(lv.GRAD_DIR.VER)
style_rideinfo1_info2_label_2_main_main_default.set_bg_opa(0)
style_rideinfo1_info2_label_2_main_main_default.set_text_color(lv.color_make(0x9e,0x9e,0x9e))
try:
    style_rideinfo1_info2_label_2_main_main_default.set_text_font(lv.font_montserratMedium_12)
except AttributeError:
    try:
        style_rideinfo1_info2_label_2_main_main_default.set_text_font(lv.font_montserrat_12)
    except AttributeError:
        style_rideinfo1_info2_label_2_main_main_default.set_text_font(lv.font_montserrat_16)
style_rideinfo1_info2_label_2_main_main_default.set_text_letter_space(0)
style_rideinfo1_info2_label_2_main_main_default.set_pad_left(0)
style_rideinfo1_info2_label_2_main_main_default.set_pad_right(0)
style_rideinfo1_info2_label_2_main_main_default.set_pad_top(0)
style_rideinfo1_info2_label_2_main_main_default.set_pad_bottom(0)

# add style for RideInfo1_info2_label_2
RideInfo1_info2_label_2.add_style(style_rideinfo1_info2_label_2_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

RideInfo1_info4_label_4 = lv.label(RideInfo1)
RideInfo1_info4_label_4.set_pos(402,219)
RideInfo1_info4_label_4.set_size(30,32)
RideInfo1_info4_label_4.set_text("m")
RideInfo1_info4_label_4.set_long_mode(lv.label.LONG.WRAP)
RideInfo1_info4_label_4.set_style_text_align(lv.TEXT_ALIGN.LEFT, 0)
# create style style_rideinfo1_info4_label_4_main_main_default
style_rideinfo1_info4_label_4_main_main_default = lv.style_t()
style_rideinfo1_info4_label_4_main_main_default.init()
style_rideinfo1_info4_label_4_main_main_default.set_radius(0)
style_rideinfo1_info4_label_4_main_main_default.set_bg_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo1_info4_label_4_main_main_default.set_bg_grad_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo1_info4_label_4_main_main_default.set_bg_grad_dir(lv.GRAD_DIR.VER)
style_rideinfo1_info4_label_4_main_main_default.set_bg_opa(0)
style_rideinfo1_info4_label_4_main_main_default.set_text_color(lv.color_make(0x9e,0x9e,0x9e))
try:
    style_rideinfo1_info4_label_4_main_main_default.set_text_font(lv.font_montserratMedium_12)
except AttributeError:
    try:
        style_rideinfo1_info4_label_4_main_main_default.set_text_font(lv.font_montserrat_12)
    except AttributeError:
        style_rideinfo1_info4_label_4_main_main_default.set_text_font(lv.font_montserrat_16)
style_rideinfo1_info4_label_4_main_main_default.set_text_letter_space(0)
style_rideinfo1_info4_label_4_main_main_default.set_pad_left(0)
style_rideinfo1_info4_label_4_main_main_default.set_pad_right(0)
style_rideinfo1_info4_label_4_main_main_default.set_pad_top(0)
style_rideinfo1_info4_label_4_main_main_default.set_pad_bottom(0)

# add style for RideInfo1_info4_label_4
RideInfo1_info4_label_4.add_style(style_rideinfo1_info4_label_4_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

RideInfo1_info_img_v = lv.img(RideInfo1)
RideInfo1_info_img_v.set_pos(240,170)
RideInfo1_info_img_v.set_size(210,3)
RideInfo1_info_img_v.add_flag(lv.obj.FLAG.CLICKABLE)
try:
    with open('C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp1913112770.png','rb') as f:
        RideInfo1_info_img_v_img_data = f.read()
except:
    print('Could not open C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp1913112770.png')
    sys.exit()

RideInfo1_info_img_v_img = lv.img_dsc_t({
  'data_size': len(RideInfo1_info_img_v_img_data),
  'header': {'always_zero': 0, 'w': 210, 'h': 3, 'cf': lv.img.CF.TRUE_COLOR_ALPHA},
  'data': RideInfo1_info_img_v_img_data
})

RideInfo1_info_img_v.set_src(RideInfo1_info_img_v_img)
RideInfo1_info_img_v.set_pivot(0,0)
RideInfo1_info_img_v.set_angle(0)
# create style style_rideinfo1_info_img_v_main_main_default
style_rideinfo1_info_img_v_main_main_default = lv.style_t()
style_rideinfo1_info_img_v_main_main_default.init()
style_rideinfo1_info_img_v_main_main_default.set_img_recolor(lv.color_make(0xff,0xff,0xff))
style_rideinfo1_info_img_v_main_main_default.set_img_recolor_opa(0)
style_rideinfo1_info_img_v_main_main_default.set_img_opa(255)

# add style for RideInfo1_info_img_v
RideInfo1_info_img_v.add_style(style_rideinfo1_info_img_v_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

RideInfo1_info_img_h = lv.img(RideInfo1)
RideInfo1_info_img_h.set_pos(342,176)
RideInfo1_info_img_h.set_size(3,60)
RideInfo1_info_img_h.add_flag(lv.obj.FLAG.CLICKABLE)
try:
    with open('C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp1366387753.png','rb') as f:
        RideInfo1_info_img_h_img_data = f.read()
except:
    print('Could not open C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp1366387753.png')
    sys.exit()

RideInfo1_info_img_h_img = lv.img_dsc_t({
  'data_size': len(RideInfo1_info_img_h_img_data),
  'header': {'always_zero': 0, 'w': 3, 'h': 60, 'cf': lv.img.CF.TRUE_COLOR_ALPHA},
  'data': RideInfo1_info_img_h_img_data
})

RideInfo1_info_img_h.set_src(RideInfo1_info_img_h_img)
RideInfo1_info_img_h.set_pivot(0,0)
RideInfo1_info_img_h.set_angle(0)
# create style style_rideinfo1_info_img_h_main_main_default
style_rideinfo1_info_img_h_main_main_default = lv.style_t()
style_rideinfo1_info_img_h_main_main_default.init()
style_rideinfo1_info_img_h_main_main_default.set_img_recolor(lv.color_make(0xff,0xff,0xff))
style_rideinfo1_info_img_h_main_main_default.set_img_recolor_opa(0)
style_rideinfo1_info_img_h_main_main_default.set_img_opa(255)

# add style for RideInfo1_info_img_h
RideInfo1_info_img_h.add_style(style_rideinfo1_info_img_h_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

RideInfo1_img_1 = lv.img(RideInfo1)
RideInfo1_img_1.set_pos(240,105)
RideInfo1_img_1.set_size(210,3)
RideInfo1_img_1.add_flag(lv.obj.FLAG.CLICKABLE)
try:
    with open('C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp1913112770.png','rb') as f:
        RideInfo1_img_1_img_data = f.read()
except:
    print('Could not open C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp1913112770.png')
    sys.exit()

RideInfo1_img_1_img = lv.img_dsc_t({
  'data_size': len(RideInfo1_img_1_img_data),
  'header': {'always_zero': 0, 'w': 210, 'h': 3, 'cf': lv.img.CF.TRUE_COLOR_ALPHA},
  'data': RideInfo1_img_1_img_data
})

RideInfo1_img_1.set_src(RideInfo1_img_1_img)
RideInfo1_img_1.set_pivot(0,0)
RideInfo1_img_1.set_angle(0)
# create style style_rideinfo1_img_1_main_main_default
style_rideinfo1_img_1_main_main_default = lv.style_t()
style_rideinfo1_img_1_main_main_default.init()
style_rideinfo1_img_1_main_main_default.set_img_recolor(lv.color_make(0xff,0xff,0xff))
style_rideinfo1_img_1_main_main_default.set_img_recolor_opa(0)
style_rideinfo1_img_1_main_main_default.set_img_opa(255)

# add style for RideInfo1_img_1
RideInfo1_img_1.add_style(style_rideinfo1_img_1_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

RideInfo1_footer_bg_img = lv.img(RideInfo1)
RideInfo1_footer_bg_img.set_pos(0,237)
RideInfo1_footer_bg_img.set_size(480,35)
RideInfo1_footer_bg_img.add_flag(lv.obj.FLAG.CLICKABLE)
try:
    with open('C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp-1226003919.png','rb') as f:
        RideInfo1_footer_bg_img_img_data = f.read()
except:
    print('Could not open C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp-1226003919.png')
    sys.exit()

RideInfo1_footer_bg_img_img = lv.img_dsc_t({
  'data_size': len(RideInfo1_footer_bg_img_img_data),
  'header': {'always_zero': 0, 'w': 480, 'h': 35, 'cf': lv.img.CF.TRUE_COLOR_ALPHA},
  'data': RideInfo1_footer_bg_img_img_data
})

RideInfo1_footer_bg_img.set_src(RideInfo1_footer_bg_img_img)
RideInfo1_footer_bg_img.set_pivot(0,0)
RideInfo1_footer_bg_img.set_angle(0)
# create style style_rideinfo1_footer_bg_img_main_main_default
style_rideinfo1_footer_bg_img_main_main_default = lv.style_t()
style_rideinfo1_footer_bg_img_main_main_default.init()
style_rideinfo1_footer_bg_img_main_main_default.set_img_recolor(lv.color_make(0xff,0xff,0xff))
style_rideinfo1_footer_bg_img_main_main_default.set_img_recolor_opa(0)
style_rideinfo1_footer_bg_img_main_main_default.set_img_opa(255)

# add style for RideInfo1_footer_bg_img
RideInfo1_footer_bg_img.add_style(style_rideinfo1_footer_bg_img_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

RideInfo1_footer_line_1 = lv.img(RideInfo1)
RideInfo1_footer_line_1.set_pos(190,260)
RideInfo1_footer_line_1.set_size(22,4)
RideInfo1_footer_line_1.add_flag(lv.obj.FLAG.CLICKABLE)
try:
    with open('C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp-339601803.png','rb') as f:
        RideInfo1_footer_line_1_img_data = f.read()
except:
    print('Could not open C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp-339601803.png')
    sys.exit()

RideInfo1_footer_line_1_img = lv.img_dsc_t({
  'data_size': len(RideInfo1_footer_line_1_img_data),
  'header': {'always_zero': 0, 'w': 22, 'h': 4, 'cf': lv.img.CF.TRUE_COLOR_ALPHA},
  'data': RideInfo1_footer_line_1_img_data
})

RideInfo1_footer_line_1.set_src(RideInfo1_footer_line_1_img)
RideInfo1_footer_line_1.set_pivot(0,0)
RideInfo1_footer_line_1.set_angle(0)
# create style style_rideinfo1_footer_line_1_main_main_default
style_rideinfo1_footer_line_1_main_main_default = lv.style_t()
style_rideinfo1_footer_line_1_main_main_default.init()
style_rideinfo1_footer_line_1_main_main_default.set_img_recolor(lv.color_make(0xff,0xff,0xff))
style_rideinfo1_footer_line_1_main_main_default.set_img_recolor_opa(0)
style_rideinfo1_footer_line_1_main_main_default.set_img_opa(255)

# add style for RideInfo1_footer_line_1
RideInfo1_footer_line_1.add_style(style_rideinfo1_footer_line_1_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

RideInfo1_footer_line_2 = lv.img(RideInfo1)
RideInfo1_footer_line_2.set_pos(230,260)
RideInfo1_footer_line_2.set_size(22,4)
RideInfo1_footer_line_2.add_flag(lv.obj.FLAG.CLICKABLE)
try:
    with open('C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp-272595050.png','rb') as f:
        RideInfo1_footer_line_2_img_data = f.read()
except:
    print('Could not open C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp-272595050.png')
    sys.exit()

RideInfo1_footer_line_2_img = lv.img_dsc_t({
  'data_size': len(RideInfo1_footer_line_2_img_data),
  'header': {'always_zero': 0, 'w': 22, 'h': 4, 'cf': lv.img.CF.TRUE_COLOR_ALPHA},
  'data': RideInfo1_footer_line_2_img_data
})

RideInfo1_footer_line_2.set_src(RideInfo1_footer_line_2_img)
RideInfo1_footer_line_2.set_pivot(0,0)
RideInfo1_footer_line_2.set_angle(0)
# create style style_rideinfo1_footer_line_2_main_main_default
style_rideinfo1_footer_line_2_main_main_default = lv.style_t()
style_rideinfo1_footer_line_2_main_main_default.init()
style_rideinfo1_footer_line_2_main_main_default.set_img_recolor(lv.color_make(0xff,0xff,0xff))
style_rideinfo1_footer_line_2_main_main_default.set_img_recolor_opa(0)
style_rideinfo1_footer_line_2_main_main_default.set_img_opa(255)

# add style for RideInfo1_footer_line_2
RideInfo1_footer_line_2.add_style(style_rideinfo1_footer_line_2_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

RideInfo1_footer_line_3 = lv.img(RideInfo1)
RideInfo1_footer_line_3.set_pos(270,260)
RideInfo1_footer_line_3.set_size(22,4)
RideInfo1_footer_line_3.add_flag(lv.obj.FLAG.CLICKABLE)
try:
    with open('C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp-339601803.png','rb') as f:
        RideInfo1_footer_line_3_img_data = f.read()
except:
    print('Could not open C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp-339601803.png')
    sys.exit()

RideInfo1_footer_line_3_img = lv.img_dsc_t({
  'data_size': len(RideInfo1_footer_line_3_img_data),
  'header': {'always_zero': 0, 'w': 22, 'h': 4, 'cf': lv.img.CF.TRUE_COLOR_ALPHA},
  'data': RideInfo1_footer_line_3_img_data
})

RideInfo1_footer_line_3.set_src(RideInfo1_footer_line_3_img)
RideInfo1_footer_line_3.set_pivot(0,0)
RideInfo1_footer_line_3.set_angle(0)
# create style style_rideinfo1_footer_line_3_main_main_default
style_rideinfo1_footer_line_3_main_main_default = lv.style_t()
style_rideinfo1_footer_line_3_main_main_default.init()
style_rideinfo1_footer_line_3_main_main_default.set_img_recolor(lv.color_make(0xff,0xff,0xff))
style_rideinfo1_footer_line_3_main_main_default.set_img_recolor_opa(0)
style_rideinfo1_footer_line_3_main_main_default.set_img_opa(255)

# add style for RideInfo1_footer_line_3
RideInfo1_footer_line_3.add_style(style_rideinfo1_footer_line_3_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

RideInfo1_dis_img = lv.img(RideInfo1)
RideInfo1_dis_img.set_pos(274,65)
RideInfo1_dis_img.set_size(42,28)
RideInfo1_dis_img.add_flag(lv.obj.FLAG.CLICKABLE)
try:
    with open('C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp-388361735.png','rb') as f:
        RideInfo1_dis_img_img_data = f.read()
except:
    print('Could not open C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp-388361735.png')
    sys.exit()

RideInfo1_dis_img_img = lv.img_dsc_t({
  'data_size': len(RideInfo1_dis_img_img_data),
  'header': {'always_zero': 0, 'w': 42, 'h': 28, 'cf': lv.img.CF.TRUE_COLOR_ALPHA},
  'data': RideInfo1_dis_img_img_data
})

RideInfo1_dis_img.set_src(RideInfo1_dis_img_img)
RideInfo1_dis_img.set_pivot(0,0)
RideInfo1_dis_img.set_angle(0)
# create style style_rideinfo1_dis_img_main_main_default
style_rideinfo1_dis_img_main_main_default = lv.style_t()
style_rideinfo1_dis_img_main_main_default.init()
style_rideinfo1_dis_img_main_main_default.set_img_recolor(lv.color_make(0xff,0xff,0xff))
style_rideinfo1_dis_img_main_main_default.set_img_recolor_opa(0)
style_rideinfo1_dis_img_main_main_default.set_img_opa(255)

# add style for RideInfo1_dis_img
RideInfo1_dis_img.add_style(style_rideinfo1_dis_img_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

RideInfo1_ava_img = lv.img(RideInfo1)
RideInfo1_ava_img.set_pos(274,135)
RideInfo1_ava_img.set_size(40,31)
RideInfo1_ava_img.add_flag(lv.obj.FLAG.CLICKABLE)
try:
    with open('C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp-657492749.png','rb') as f:
        RideInfo1_ava_img_img_data = f.read()
except:
    print('Could not open C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp-657492749.png')
    sys.exit()

RideInfo1_ava_img_img = lv.img_dsc_t({
  'data_size': len(RideInfo1_ava_img_img_data),
  'header': {'always_zero': 0, 'w': 40, 'h': 31, 'cf': lv.img.CF.TRUE_COLOR_ALPHA},
  'data': RideInfo1_ava_img_img_data
})

RideInfo1_ava_img.set_src(RideInfo1_ava_img_img)
RideInfo1_ava_img.set_pivot(0,0)
RideInfo1_ava_img.set_angle(0)
# create style style_rideinfo1_ava_img_main_main_default
style_rideinfo1_ava_img_main_main_default = lv.style_t()
style_rideinfo1_ava_img_main_main_default.init()
style_rideinfo1_ava_img_main_main_default.set_img_recolor(lv.color_make(0xff,0xff,0xff))
style_rideinfo1_ava_img_main_main_default.set_img_recolor_opa(0)
style_rideinfo1_ava_img_main_main_default.set_img_opa(255)

# add style for RideInfo1_ava_img
RideInfo1_ava_img.add_style(style_rideinfo1_ava_img_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

RideInfo1_ride_chart = lv.chart(RideInfo1)
RideInfo1_ride_chart.set_pos(30,62)
RideInfo1_ride_chart.set_size(180,155)
RideInfo1_ride_chart.set_type(lv.chart.TYPE.LINE)
RideInfo1_ride_chart.set_range(lv.chart.AXIS.PRIMARY_Y, 0, 100)
RideInfo1_ride_chart.set_div_line_count(5, 5)
RideInfo1_ride_chart.set_point_count(5)
chart_series_0 = lv.chart.add_series(RideInfo1_ride_chart, lv.color_make(0x00,0x80,0xff), lv.chart.AXIS.PRIMARY_Y);
RideInfo1_ride_chart.set_next_value(chart_series_0, 10)
RideInfo1_ride_chart.set_next_value(chart_series_0, 20)
RideInfo1_ride_chart.set_next_value(chart_series_0, 30)
RideInfo1_ride_chart.set_next_value(chart_series_0, 40)
RideInfo1_ride_chart.set_next_value(chart_series_0, 20)
RideInfo1_ride_chart.set_next_value(chart_series_0, 50)
RideInfo1_ride_chart.set_next_value(chart_series_0, 40)
RideInfo1_ride_chart.set_next_value(chart_series_0, 30)
RideInfo1_ride_chart.set_next_value(chart_series_0, 40)
RideInfo1_ride_chart.set_next_value(chart_series_0, 30)
# create style style_rideinfo1_ride_chart_main_main_default
style_rideinfo1_ride_chart_main_main_default = lv.style_t()
style_rideinfo1_ride_chart_main_main_default.init()
style_rideinfo1_ride_chart_main_main_default.set_bg_color(lv.color_make(0x00,0x00,0x00))
style_rideinfo1_ride_chart_main_main_default.set_bg_grad_color(lv.color_make(0x40,0x40,0x40))
style_rideinfo1_ride_chart_main_main_default.set_bg_grad_dir(lv.GRAD_DIR.VER)
style_rideinfo1_ride_chart_main_main_default.set_bg_opa(0)
style_rideinfo1_ride_chart_main_main_default.set_pad_left(0)
style_rideinfo1_ride_chart_main_main_default.set_pad_right(0)
style_rideinfo1_ride_chart_main_main_default.set_pad_top(0)
style_rideinfo1_ride_chart_main_main_default.set_pad_bottom(0)
style_rideinfo1_ride_chart_main_main_default.set_line_color(lv.color_make(0xe8,0xe8,0xe8))
style_rideinfo1_ride_chart_main_main_default.set_line_width(1)
style_rideinfo1_ride_chart_main_main_default.set_line_opa(0)

# add style for RideInfo1_ride_chart
RideInfo1_ride_chart.add_style(style_rideinfo1_ride_chart_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

# create style style_rideinfo1_ride_chart_main_main_focused
style_rideinfo1_ride_chart_main_main_focused = lv.style_t()
style_rideinfo1_ride_chart_main_main_focused.init()
style_rideinfo1_ride_chart_main_main_focused.set_border_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo1_ride_chart_main_main_focused.set_border_width(0)

# add style for RideInfo1_ride_chart
RideInfo1_ride_chart.add_style(style_rideinfo1_ride_chart_main_main_focused, lv.PART.MAIN|lv.STATE.FOCUSED)

RideInfo1_elev_label_0 = lv.label(RideInfo1)
RideInfo1_elev_label_0.set_pos(46,81)
RideInfo1_elev_label_0.set_size(150,32)
RideInfo1_elev_label_0.set_text("Elevation Graph")
RideInfo1_elev_label_0.set_long_mode(lv.label.LONG.WRAP)
RideInfo1_elev_label_0.set_style_text_align(lv.TEXT_ALIGN.LEFT, 0)
# create style style_rideinfo1_elev_label_0_main_main_default
style_rideinfo1_elev_label_0_main_main_default = lv.style_t()
style_rideinfo1_elev_label_0_main_main_default.init()
style_rideinfo1_elev_label_0_main_main_default.set_radius(0)
style_rideinfo1_elev_label_0_main_main_default.set_bg_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo1_elev_label_0_main_main_default.set_bg_grad_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo1_elev_label_0_main_main_default.set_bg_grad_dir(lv.GRAD_DIR.VER)
style_rideinfo1_elev_label_0_main_main_default.set_bg_opa(0)
style_rideinfo1_elev_label_0_main_main_default.set_text_color(lv.color_make(0x9e,0x9e,0x9e))
try:
    style_rideinfo1_elev_label_0_main_main_default.set_text_font(lv.font_montserratMedium_16)
except AttributeError:
    try:
        style_rideinfo1_elev_label_0_main_main_default.set_text_font(lv.font_montserrat_16)
    except AttributeError:
        style_rideinfo1_elev_label_0_main_main_default.set_text_font(lv.font_montserrat_16)
style_rideinfo1_elev_label_0_main_main_default.set_text_letter_space(0)
style_rideinfo1_elev_label_0_main_main_default.set_pad_left(0)
style_rideinfo1_elev_label_0_main_main_default.set_pad_right(0)
style_rideinfo1_elev_label_0_main_main_default.set_pad_top(0)
style_rideinfo1_elev_label_0_main_main_default.set_pad_bottom(0)

# add style for RideInfo1_elev_label_0
RideInfo1_elev_label_0.add_style(style_rideinfo1_elev_label_0_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

RideInfo1_elev_label_1 = lv.label(RideInfo1)
RideInfo1_elev_label_1.set_pos(90,111)
RideInfo1_elev_label_1.set_size(50,32)
RideInfo1_elev_label_1.set_text("15.3")
RideInfo1_elev_label_1.set_long_mode(lv.label.LONG.WRAP)
RideInfo1_elev_label_1.set_style_text_align(lv.TEXT_ALIGN.LEFT, 0)
# create style style_rideinfo1_elev_label_1_main_main_default
style_rideinfo1_elev_label_1_main_main_default = lv.style_t()
style_rideinfo1_elev_label_1_main_main_default.init()
style_rideinfo1_elev_label_1_main_main_default.set_radius(0)
style_rideinfo1_elev_label_1_main_main_default.set_bg_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo1_elev_label_1_main_main_default.set_bg_grad_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo1_elev_label_1_main_main_default.set_bg_grad_dir(lv.GRAD_DIR.VER)
style_rideinfo1_elev_label_1_main_main_default.set_bg_opa(0)
style_rideinfo1_elev_label_1_main_main_default.set_text_color(lv.color_make(0x00,0x80,0xff))
try:
    style_rideinfo1_elev_label_1_main_main_default.set_text_font(lv.font_montserratMedium_20)
except AttributeError:
    try:
        style_rideinfo1_elev_label_1_main_main_default.set_text_font(lv.font_montserrat_20)
    except AttributeError:
        style_rideinfo1_elev_label_1_main_main_default.set_text_font(lv.font_montserrat_16)
style_rideinfo1_elev_label_1_main_main_default.set_text_letter_space(0)
style_rideinfo1_elev_label_1_main_main_default.set_pad_left(0)
style_rideinfo1_elev_label_1_main_main_default.set_pad_right(0)
style_rideinfo1_elev_label_1_main_main_default.set_pad_top(0)
style_rideinfo1_elev_label_1_main_main_default.set_pad_bottom(0)

# add style for RideInfo1_elev_label_1
RideInfo1_elev_label_1.add_style(style_rideinfo1_elev_label_1_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

RideInfo1_elev_label_2 = lv.label(RideInfo1)
RideInfo1_elev_label_2.set_pos(131,118)
RideInfo1_elev_label_2.set_size(30,32)
RideInfo1_elev_label_2.set_text("m")
RideInfo1_elev_label_2.set_long_mode(lv.label.LONG.WRAP)
RideInfo1_elev_label_2.set_style_text_align(lv.TEXT_ALIGN.LEFT, 0)
# create style style_rideinfo1_elev_label_2_main_main_default
style_rideinfo1_elev_label_2_main_main_default = lv.style_t()
style_rideinfo1_elev_label_2_main_main_default.init()
style_rideinfo1_elev_label_2_main_main_default.set_radius(0)
style_rideinfo1_elev_label_2_main_main_default.set_bg_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo1_elev_label_2_main_main_default.set_bg_grad_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo1_elev_label_2_main_main_default.set_bg_grad_dir(lv.GRAD_DIR.VER)
style_rideinfo1_elev_label_2_main_main_default.set_bg_opa(0)
style_rideinfo1_elev_label_2_main_main_default.set_text_color(lv.color_make(0x9e,0x9e,0x9e))
try:
    style_rideinfo1_elev_label_2_main_main_default.set_text_font(lv.font_montserratMedium_12)
except AttributeError:
    try:
        style_rideinfo1_elev_label_2_main_main_default.set_text_font(lv.font_montserrat_12)
    except AttributeError:
        style_rideinfo1_elev_label_2_main_main_default.set_text_font(lv.font_montserrat_16)
style_rideinfo1_elev_label_2_main_main_default.set_text_letter_space(0)
style_rideinfo1_elev_label_2_main_main_default.set_pad_left(0)
style_rideinfo1_elev_label_2_main_main_default.set_pad_right(0)
style_rideinfo1_elev_label_2_main_main_default.set_pad_top(0)
style_rideinfo1_elev_label_2_main_main_default.set_pad_bottom(0)

# add style for RideInfo1_elev_label_2
RideInfo1_elev_label_2.add_style(style_rideinfo1_elev_label_2_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

RideInfo1_elev_label_3 = lv.label(RideInfo1)
RideInfo1_elev_label_3.set_pos(215,208)
RideInfo1_elev_label_3.set_size(30,32)
RideInfo1_elev_label_3.set_text("Km")
RideInfo1_elev_label_3.set_long_mode(lv.label.LONG.WRAP)
RideInfo1_elev_label_3.set_style_text_align(lv.TEXT_ALIGN.LEFT, 0)
# create style style_rideinfo1_elev_label_3_main_main_default
style_rideinfo1_elev_label_3_main_main_default = lv.style_t()
style_rideinfo1_elev_label_3_main_main_default.init()
style_rideinfo1_elev_label_3_main_main_default.set_radius(0)
style_rideinfo1_elev_label_3_main_main_default.set_bg_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo1_elev_label_3_main_main_default.set_bg_grad_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo1_elev_label_3_main_main_default.set_bg_grad_dir(lv.GRAD_DIR.VER)
style_rideinfo1_elev_label_3_main_main_default.set_bg_opa(0)
style_rideinfo1_elev_label_3_main_main_default.set_text_color(lv.color_make(0x9e,0x9e,0x9e))
try:
    style_rideinfo1_elev_label_3_main_main_default.set_text_font(lv.font_montserratMedium_12)
except AttributeError:
    try:
        style_rideinfo1_elev_label_3_main_main_default.set_text_font(lv.font_montserrat_12)
    except AttributeError:
        style_rideinfo1_elev_label_3_main_main_default.set_text_font(lv.font_montserrat_16)
style_rideinfo1_elev_label_3_main_main_default.set_text_letter_space(0)
style_rideinfo1_elev_label_3_main_main_default.set_pad_left(0)
style_rideinfo1_elev_label_3_main_main_default.set_pad_right(0)
style_rideinfo1_elev_label_3_main_main_default.set_pad_top(0)
style_rideinfo1_elev_label_3_main_main_default.set_pad_bottom(0)

# add style for RideInfo1_elev_label_3
RideInfo1_elev_label_3.add_style(style_rideinfo1_elev_label_3_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

RideInfo1_elev_label_4 = lv.label(RideInfo1)
RideInfo1_elev_label_4.set_pos(15,60)
RideInfo1_elev_label_4.set_size(40,32)
RideInfo1_elev_label_4.set_text("Meter")
RideInfo1_elev_label_4.set_long_mode(lv.label.LONG.WRAP)
RideInfo1_elev_label_4.set_style_text_align(lv.TEXT_ALIGN.LEFT, 0)
# create style style_rideinfo1_elev_label_4_main_main_default
style_rideinfo1_elev_label_4_main_main_default = lv.style_t()
style_rideinfo1_elev_label_4_main_main_default.init()
style_rideinfo1_elev_label_4_main_main_default.set_radius(0)
style_rideinfo1_elev_label_4_main_main_default.set_bg_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo1_elev_label_4_main_main_default.set_bg_grad_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo1_elev_label_4_main_main_default.set_bg_grad_dir(lv.GRAD_DIR.VER)
style_rideinfo1_elev_label_4_main_main_default.set_bg_opa(0)
style_rideinfo1_elev_label_4_main_main_default.set_text_color(lv.color_make(0x9e,0x9e,0x9e))
try:
    style_rideinfo1_elev_label_4_main_main_default.set_text_font(lv.font_montserratMedium_12)
except AttributeError:
    try:
        style_rideinfo1_elev_label_4_main_main_default.set_text_font(lv.font_montserrat_12)
    except AttributeError:
        style_rideinfo1_elev_label_4_main_main_default.set_text_font(lv.font_montserrat_16)
style_rideinfo1_elev_label_4_main_main_default.set_text_letter_space(0)
style_rideinfo1_elev_label_4_main_main_default.set_pad_left(0)
style_rideinfo1_elev_label_4_main_main_default.set_pad_right(0)
style_rideinfo1_elev_label_4_main_main_default.set_pad_top(0)
style_rideinfo1_elev_label_4_main_main_default.set_pad_bottom(0)

# add style for RideInfo1_elev_label_4
RideInfo1_elev_label_4.add_style(style_rideinfo1_elev_label_4_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

RideInfo1_elev_label_5 = lv.label(RideInfo1)
RideInfo1_elev_label_5.set_pos(43,222)
RideInfo1_elev_label_5.set_size(16,32)
RideInfo1_elev_label_5.set_text("5")
RideInfo1_elev_label_5.set_long_mode(lv.label.LONG.WRAP)
RideInfo1_elev_label_5.set_style_text_align(lv.TEXT_ALIGN.CENTER, 0)
# create style style_rideinfo1_elev_label_5_main_main_default
style_rideinfo1_elev_label_5_main_main_default = lv.style_t()
style_rideinfo1_elev_label_5_main_main_default.init()
style_rideinfo1_elev_label_5_main_main_default.set_radius(0)
style_rideinfo1_elev_label_5_main_main_default.set_bg_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo1_elev_label_5_main_main_default.set_bg_grad_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo1_elev_label_5_main_main_default.set_bg_grad_dir(lv.GRAD_DIR.VER)
style_rideinfo1_elev_label_5_main_main_default.set_bg_opa(0)
style_rideinfo1_elev_label_5_main_main_default.set_text_color(lv.color_make(0x9e,0x9e,0x9e))
try:
    style_rideinfo1_elev_label_5_main_main_default.set_text_font(lv.font_montserratMedium_12)
except AttributeError:
    try:
        style_rideinfo1_elev_label_5_main_main_default.set_text_font(lv.font_montserrat_12)
    except AttributeError:
        style_rideinfo1_elev_label_5_main_main_default.set_text_font(lv.font_montserrat_16)
style_rideinfo1_elev_label_5_main_main_default.set_text_letter_space(0)
style_rideinfo1_elev_label_5_main_main_default.set_pad_left(0)
style_rideinfo1_elev_label_5_main_main_default.set_pad_right(0)
style_rideinfo1_elev_label_5_main_main_default.set_pad_top(0)
style_rideinfo1_elev_label_5_main_main_default.set_pad_bottom(0)

# add style for RideInfo1_elev_label_5
RideInfo1_elev_label_5.add_style(style_rideinfo1_elev_label_5_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

RideInfo1_elev_label_6 = lv.label(RideInfo1)
RideInfo1_elev_label_6.set_pos(71,222)
RideInfo1_elev_label_6.set_size(16,32)
RideInfo1_elev_label_6.set_text("10")
RideInfo1_elev_label_6.set_long_mode(lv.label.LONG.WRAP)
RideInfo1_elev_label_6.set_style_text_align(lv.TEXT_ALIGN.CENTER, 0)
# create style style_rideinfo1_elev_label_6_main_main_default
style_rideinfo1_elev_label_6_main_main_default = lv.style_t()
style_rideinfo1_elev_label_6_main_main_default.init()
style_rideinfo1_elev_label_6_main_main_default.set_radius(0)
style_rideinfo1_elev_label_6_main_main_default.set_bg_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo1_elev_label_6_main_main_default.set_bg_grad_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo1_elev_label_6_main_main_default.set_bg_grad_dir(lv.GRAD_DIR.VER)
style_rideinfo1_elev_label_6_main_main_default.set_bg_opa(0)
style_rideinfo1_elev_label_6_main_main_default.set_text_color(lv.color_make(0x9e,0x9e,0x9e))
try:
    style_rideinfo1_elev_label_6_main_main_default.set_text_font(lv.font_montserratMedium_12)
except AttributeError:
    try:
        style_rideinfo1_elev_label_6_main_main_default.set_text_font(lv.font_montserrat_12)
    except AttributeError:
        style_rideinfo1_elev_label_6_main_main_default.set_text_font(lv.font_montserrat_16)
style_rideinfo1_elev_label_6_main_main_default.set_text_letter_space(0)
style_rideinfo1_elev_label_6_main_main_default.set_pad_left(0)
style_rideinfo1_elev_label_6_main_main_default.set_pad_right(0)
style_rideinfo1_elev_label_6_main_main_default.set_pad_top(0)
style_rideinfo1_elev_label_6_main_main_default.set_pad_bottom(0)

# add style for RideInfo1_elev_label_6
RideInfo1_elev_label_6.add_style(style_rideinfo1_elev_label_6_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

RideInfo1_elev_label_7 = lv.label(RideInfo1)
RideInfo1_elev_label_7.set_pos(101,222)
RideInfo1_elev_label_7.set_size(16,32)
RideInfo1_elev_label_7.set_text("15")
RideInfo1_elev_label_7.set_long_mode(lv.label.LONG.WRAP)
RideInfo1_elev_label_7.set_style_text_align(lv.TEXT_ALIGN.LEFT, 0)
# create style style_rideinfo1_elev_label_7_main_main_default
style_rideinfo1_elev_label_7_main_main_default = lv.style_t()
style_rideinfo1_elev_label_7_main_main_default.init()
style_rideinfo1_elev_label_7_main_main_default.set_radius(0)
style_rideinfo1_elev_label_7_main_main_default.set_bg_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo1_elev_label_7_main_main_default.set_bg_grad_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo1_elev_label_7_main_main_default.set_bg_grad_dir(lv.GRAD_DIR.VER)
style_rideinfo1_elev_label_7_main_main_default.set_bg_opa(0)
style_rideinfo1_elev_label_7_main_main_default.set_text_color(lv.color_make(0x9e,0x9e,0x9e))
try:
    style_rideinfo1_elev_label_7_main_main_default.set_text_font(lv.font_montserratMedium_12)
except AttributeError:
    try:
        style_rideinfo1_elev_label_7_main_main_default.set_text_font(lv.font_montserrat_12)
    except AttributeError:
        style_rideinfo1_elev_label_7_main_main_default.set_text_font(lv.font_montserrat_16)
style_rideinfo1_elev_label_7_main_main_default.set_text_letter_space(0)
style_rideinfo1_elev_label_7_main_main_default.set_pad_left(0)
style_rideinfo1_elev_label_7_main_main_default.set_pad_right(0)
style_rideinfo1_elev_label_7_main_main_default.set_pad_top(0)
style_rideinfo1_elev_label_7_main_main_default.set_pad_bottom(0)

# add style for RideInfo1_elev_label_7
RideInfo1_elev_label_7.add_style(style_rideinfo1_elev_label_7_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

RideInfo1_elev_label_8 = lv.label(RideInfo1)
RideInfo1_elev_label_8.set_pos(130,222)
RideInfo1_elev_label_8.set_size(20,32)
RideInfo1_elev_label_8.set_text("20")
RideInfo1_elev_label_8.set_long_mode(lv.label.LONG.WRAP)
RideInfo1_elev_label_8.set_style_text_align(lv.TEXT_ALIGN.LEFT, 0)
# create style style_rideinfo1_elev_label_8_main_main_default
style_rideinfo1_elev_label_8_main_main_default = lv.style_t()
style_rideinfo1_elev_label_8_main_main_default.init()
style_rideinfo1_elev_label_8_main_main_default.set_radius(0)
style_rideinfo1_elev_label_8_main_main_default.set_bg_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo1_elev_label_8_main_main_default.set_bg_grad_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo1_elev_label_8_main_main_default.set_bg_grad_dir(lv.GRAD_DIR.VER)
style_rideinfo1_elev_label_8_main_main_default.set_bg_opa(0)
style_rideinfo1_elev_label_8_main_main_default.set_text_color(lv.color_make(0x9e,0x9e,0x9e))
try:
    style_rideinfo1_elev_label_8_main_main_default.set_text_font(lv.font_montserratMedium_12)
except AttributeError:
    try:
        style_rideinfo1_elev_label_8_main_main_default.set_text_font(lv.font_montserrat_12)
    except AttributeError:
        style_rideinfo1_elev_label_8_main_main_default.set_text_font(lv.font_montserrat_16)
style_rideinfo1_elev_label_8_main_main_default.set_text_letter_space(0)
style_rideinfo1_elev_label_8_main_main_default.set_pad_left(0)
style_rideinfo1_elev_label_8_main_main_default.set_pad_right(0)
style_rideinfo1_elev_label_8_main_main_default.set_pad_top(0)
style_rideinfo1_elev_label_8_main_main_default.set_pad_bottom(0)

# add style for RideInfo1_elev_label_8
RideInfo1_elev_label_8.add_style(style_rideinfo1_elev_label_8_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

RideInfo1_elev_label_9 = lv.label(RideInfo1)
RideInfo1_elev_label_9.set_pos(159,222)
RideInfo1_elev_label_9.set_size(16,32)
RideInfo1_elev_label_9.set_text("25")
RideInfo1_elev_label_9.set_long_mode(lv.label.LONG.WRAP)
RideInfo1_elev_label_9.set_style_text_align(lv.TEXT_ALIGN.LEFT, 0)
# create style style_rideinfo1_elev_label_9_main_main_default
style_rideinfo1_elev_label_9_main_main_default = lv.style_t()
style_rideinfo1_elev_label_9_main_main_default.init()
style_rideinfo1_elev_label_9_main_main_default.set_radius(0)
style_rideinfo1_elev_label_9_main_main_default.set_bg_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo1_elev_label_9_main_main_default.set_bg_grad_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo1_elev_label_9_main_main_default.set_bg_grad_dir(lv.GRAD_DIR.VER)
style_rideinfo1_elev_label_9_main_main_default.set_bg_opa(0)
style_rideinfo1_elev_label_9_main_main_default.set_text_color(lv.color_make(0x9e,0x9e,0x9e))
try:
    style_rideinfo1_elev_label_9_main_main_default.set_text_font(lv.font_montserratMedium_12)
except AttributeError:
    try:
        style_rideinfo1_elev_label_9_main_main_default.set_text_font(lv.font_montserrat_12)
    except AttributeError:
        style_rideinfo1_elev_label_9_main_main_default.set_text_font(lv.font_montserrat_16)
style_rideinfo1_elev_label_9_main_main_default.set_text_letter_space(0)
style_rideinfo1_elev_label_9_main_main_default.set_pad_left(0)
style_rideinfo1_elev_label_9_main_main_default.set_pad_right(0)
style_rideinfo1_elev_label_9_main_main_default.set_pad_top(0)
style_rideinfo1_elev_label_9_main_main_default.set_pad_bottom(0)

# add style for RideInfo1_elev_label_9
RideInfo1_elev_label_9.add_style(style_rideinfo1_elev_label_9_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

RideInfo1_elev_label_10 = lv.label(RideInfo1)
RideInfo1_elev_label_10.set_pos(189,222)
RideInfo1_elev_label_10.set_size(18,32)
RideInfo1_elev_label_10.set_text("30")
RideInfo1_elev_label_10.set_long_mode(lv.label.LONG.WRAP)
RideInfo1_elev_label_10.set_style_text_align(lv.TEXT_ALIGN.LEFT, 0)
# create style style_rideinfo1_elev_label_10_main_main_default
style_rideinfo1_elev_label_10_main_main_default = lv.style_t()
style_rideinfo1_elev_label_10_main_main_default.init()
style_rideinfo1_elev_label_10_main_main_default.set_radius(0)
style_rideinfo1_elev_label_10_main_main_default.set_bg_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo1_elev_label_10_main_main_default.set_bg_grad_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo1_elev_label_10_main_main_default.set_bg_grad_dir(lv.GRAD_DIR.VER)
style_rideinfo1_elev_label_10_main_main_default.set_bg_opa(0)
style_rideinfo1_elev_label_10_main_main_default.set_text_color(lv.color_make(0x9e,0x9e,0x9e))
try:
    style_rideinfo1_elev_label_10_main_main_default.set_text_font(lv.font_montserratMedium_12)
except AttributeError:
    try:
        style_rideinfo1_elev_label_10_main_main_default.set_text_font(lv.font_montserrat_12)
    except AttributeError:
        style_rideinfo1_elev_label_10_main_main_default.set_text_font(lv.font_montserrat_16)
style_rideinfo1_elev_label_10_main_main_default.set_text_letter_space(0)
style_rideinfo1_elev_label_10_main_main_default.set_pad_left(0)
style_rideinfo1_elev_label_10_main_main_default.set_pad_right(0)
style_rideinfo1_elev_label_10_main_main_default.set_pad_top(0)
style_rideinfo1_elev_label_10_main_main_default.set_pad_bottom(0)

# add style for RideInfo1_elev_label_10
RideInfo1_elev_label_10.add_style(style_rideinfo1_elev_label_10_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

RideInfo1_elev_label_11 = lv.label(RideInfo1)
RideInfo1_elev_label_11.set_pos(12,200)
RideInfo1_elev_label_11.set_size(16,32)
RideInfo1_elev_label_11.set_text("10")
RideInfo1_elev_label_11.set_long_mode(lv.label.LONG.WRAP)
RideInfo1_elev_label_11.set_style_text_align(lv.TEXT_ALIGN.LEFT, 0)
# create style style_rideinfo1_elev_label_11_main_main_default
style_rideinfo1_elev_label_11_main_main_default = lv.style_t()
style_rideinfo1_elev_label_11_main_main_default.init()
style_rideinfo1_elev_label_11_main_main_default.set_radius(0)
style_rideinfo1_elev_label_11_main_main_default.set_bg_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo1_elev_label_11_main_main_default.set_bg_grad_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo1_elev_label_11_main_main_default.set_bg_grad_dir(lv.GRAD_DIR.VER)
style_rideinfo1_elev_label_11_main_main_default.set_bg_opa(0)
style_rideinfo1_elev_label_11_main_main_default.set_text_color(lv.color_make(0x9e,0x9e,0x9e))
try:
    style_rideinfo1_elev_label_11_main_main_default.set_text_font(lv.font_montserratMedium_12)
except AttributeError:
    try:
        style_rideinfo1_elev_label_11_main_main_default.set_text_font(lv.font_montserrat_12)
    except AttributeError:
        style_rideinfo1_elev_label_11_main_main_default.set_text_font(lv.font_montserrat_16)
style_rideinfo1_elev_label_11_main_main_default.set_text_letter_space(0)
style_rideinfo1_elev_label_11_main_main_default.set_pad_left(0)
style_rideinfo1_elev_label_11_main_main_default.set_pad_right(0)
style_rideinfo1_elev_label_11_main_main_default.set_pad_top(0)
style_rideinfo1_elev_label_11_main_main_default.set_pad_bottom(0)

# add style for RideInfo1_elev_label_11
RideInfo1_elev_label_11.add_style(style_rideinfo1_elev_label_11_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

RideInfo1_elev_label_12 = lv.label(RideInfo1)
RideInfo1_elev_label_12.set_pos(12,175)
RideInfo1_elev_label_12.set_size(18,32)
RideInfo1_elev_label_12.set_text("20")
RideInfo1_elev_label_12.set_long_mode(lv.label.LONG.WRAP)
RideInfo1_elev_label_12.set_style_text_align(lv.TEXT_ALIGN.LEFT, 0)
# create style style_rideinfo1_elev_label_12_main_main_default
style_rideinfo1_elev_label_12_main_main_default = lv.style_t()
style_rideinfo1_elev_label_12_main_main_default.init()
style_rideinfo1_elev_label_12_main_main_default.set_radius(0)
style_rideinfo1_elev_label_12_main_main_default.set_bg_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo1_elev_label_12_main_main_default.set_bg_grad_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo1_elev_label_12_main_main_default.set_bg_grad_dir(lv.GRAD_DIR.VER)
style_rideinfo1_elev_label_12_main_main_default.set_bg_opa(0)
style_rideinfo1_elev_label_12_main_main_default.set_text_color(lv.color_make(0x9e,0x9e,0x9e))
try:
    style_rideinfo1_elev_label_12_main_main_default.set_text_font(lv.font_montserratMedium_12)
except AttributeError:
    try:
        style_rideinfo1_elev_label_12_main_main_default.set_text_font(lv.font_montserrat_12)
    except AttributeError:
        style_rideinfo1_elev_label_12_main_main_default.set_text_font(lv.font_montserrat_16)
style_rideinfo1_elev_label_12_main_main_default.set_text_letter_space(0)
style_rideinfo1_elev_label_12_main_main_default.set_pad_left(0)
style_rideinfo1_elev_label_12_main_main_default.set_pad_right(0)
style_rideinfo1_elev_label_12_main_main_default.set_pad_top(0)
style_rideinfo1_elev_label_12_main_main_default.set_pad_bottom(0)

# add style for RideInfo1_elev_label_12
RideInfo1_elev_label_12.add_style(style_rideinfo1_elev_label_12_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

RideInfo1_elev_label_13 = lv.label(RideInfo1)
RideInfo1_elev_label_13.set_pos(12,150)
RideInfo1_elev_label_13.set_size(18,32)
RideInfo1_elev_label_13.set_text("30")
RideInfo1_elev_label_13.set_long_mode(lv.label.LONG.WRAP)
RideInfo1_elev_label_13.set_style_text_align(lv.TEXT_ALIGN.LEFT, 0)
# create style style_rideinfo1_elev_label_13_main_main_default
style_rideinfo1_elev_label_13_main_main_default = lv.style_t()
style_rideinfo1_elev_label_13_main_main_default.init()
style_rideinfo1_elev_label_13_main_main_default.set_radius(0)
style_rideinfo1_elev_label_13_main_main_default.set_bg_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo1_elev_label_13_main_main_default.set_bg_grad_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo1_elev_label_13_main_main_default.set_bg_grad_dir(lv.GRAD_DIR.VER)
style_rideinfo1_elev_label_13_main_main_default.set_bg_opa(0)
style_rideinfo1_elev_label_13_main_main_default.set_text_color(lv.color_make(0x9e,0x9e,0x9e))
try:
    style_rideinfo1_elev_label_13_main_main_default.set_text_font(lv.font_montserratMedium_12)
except AttributeError:
    try:
        style_rideinfo1_elev_label_13_main_main_default.set_text_font(lv.font_montserrat_12)
    except AttributeError:
        style_rideinfo1_elev_label_13_main_main_default.set_text_font(lv.font_montserrat_16)
style_rideinfo1_elev_label_13_main_main_default.set_text_letter_space(0)
style_rideinfo1_elev_label_13_main_main_default.set_pad_left(0)
style_rideinfo1_elev_label_13_main_main_default.set_pad_right(0)
style_rideinfo1_elev_label_13_main_main_default.set_pad_top(0)
style_rideinfo1_elev_label_13_main_main_default.set_pad_bottom(0)

# add style for RideInfo1_elev_label_13
RideInfo1_elev_label_13.add_style(style_rideinfo1_elev_label_13_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

RideInfo1_elev_label_14 = lv.label(RideInfo1)
RideInfo1_elev_label_14.set_pos(12,125)
RideInfo1_elev_label_14.set_size(18,32)
RideInfo1_elev_label_14.set_text("40")
RideInfo1_elev_label_14.set_long_mode(lv.label.LONG.WRAP)
RideInfo1_elev_label_14.set_style_text_align(lv.TEXT_ALIGN.LEFT, 0)
# create style style_rideinfo1_elev_label_14_main_main_default
style_rideinfo1_elev_label_14_main_main_default = lv.style_t()
style_rideinfo1_elev_label_14_main_main_default.init()
style_rideinfo1_elev_label_14_main_main_default.set_radius(0)
style_rideinfo1_elev_label_14_main_main_default.set_bg_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo1_elev_label_14_main_main_default.set_bg_grad_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo1_elev_label_14_main_main_default.set_bg_grad_dir(lv.GRAD_DIR.VER)
style_rideinfo1_elev_label_14_main_main_default.set_bg_opa(0)
style_rideinfo1_elev_label_14_main_main_default.set_text_color(lv.color_make(0x9e,0x9e,0x9e))
try:
    style_rideinfo1_elev_label_14_main_main_default.set_text_font(lv.font_montserratMedium_12)
except AttributeError:
    try:
        style_rideinfo1_elev_label_14_main_main_default.set_text_font(lv.font_montserrat_12)
    except AttributeError:
        style_rideinfo1_elev_label_14_main_main_default.set_text_font(lv.font_montserrat_16)
style_rideinfo1_elev_label_14_main_main_default.set_text_letter_space(0)
style_rideinfo1_elev_label_14_main_main_default.set_pad_left(0)
style_rideinfo1_elev_label_14_main_main_default.set_pad_right(0)
style_rideinfo1_elev_label_14_main_main_default.set_pad_top(0)
style_rideinfo1_elev_label_14_main_main_default.set_pad_bottom(0)

# add style for RideInfo1_elev_label_14
RideInfo1_elev_label_14.add_style(style_rideinfo1_elev_label_14_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

RideInfo1_elev_label_15 = lv.label(RideInfo1)
RideInfo1_elev_label_15.set_pos(12,100)
RideInfo1_elev_label_15.set_size(18,32)
RideInfo1_elev_label_15.set_text("50")
RideInfo1_elev_label_15.set_long_mode(lv.label.LONG.WRAP)
RideInfo1_elev_label_15.set_style_text_align(lv.TEXT_ALIGN.LEFT, 0)
# create style style_rideinfo1_elev_label_15_main_main_default
style_rideinfo1_elev_label_15_main_main_default = lv.style_t()
style_rideinfo1_elev_label_15_main_main_default.init()
style_rideinfo1_elev_label_15_main_main_default.set_radius(0)
style_rideinfo1_elev_label_15_main_main_default.set_bg_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo1_elev_label_15_main_main_default.set_bg_grad_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo1_elev_label_15_main_main_default.set_bg_grad_dir(lv.GRAD_DIR.VER)
style_rideinfo1_elev_label_15_main_main_default.set_bg_opa(0)
style_rideinfo1_elev_label_15_main_main_default.set_text_color(lv.color_make(0x9e,0x9e,0x9e))
try:
    style_rideinfo1_elev_label_15_main_main_default.set_text_font(lv.font_montserratMedium_12)
except AttributeError:
    try:
        style_rideinfo1_elev_label_15_main_main_default.set_text_font(lv.font_montserrat_12)
    except AttributeError:
        style_rideinfo1_elev_label_15_main_main_default.set_text_font(lv.font_montserrat_16)
style_rideinfo1_elev_label_15_main_main_default.set_text_letter_space(0)
style_rideinfo1_elev_label_15_main_main_default.set_pad_left(0)
style_rideinfo1_elev_label_15_main_main_default.set_pad_right(0)
style_rideinfo1_elev_label_15_main_main_default.set_pad_top(0)
style_rideinfo1_elev_label_15_main_main_default.set_pad_bottom(0)

# add style for RideInfo1_elev_label_15
RideInfo1_elev_label_15.add_style(style_rideinfo1_elev_label_15_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

RideInfo1_cover_imgbtn = lv.imgbtn(RideInfo1)
RideInfo1_cover_imgbtn.set_pos(0,0)
RideInfo1_cover_imgbtn.set_size(480,272)
try:
    with open('C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp1436734276.png','rb') as f:
        RideInfo1_cover_imgbtn_imgReleased_data = f.read()
except:
    print('Could not open C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp1436734276.png')
    sys.exit()

RideInfo1_cover_imgbtn_imgReleased = lv.img_dsc_t({
  'data_size': len(RideInfo1_cover_imgbtn_imgReleased_data),
  'header': {'always_zero': 0, 'w': 480, 'h': 272, 'cf': lv.img.CF.TRUE_COLOR_ALPHA},
  'data': RideInfo1_cover_imgbtn_imgReleased_data
})
RideInfo1_cover_imgbtn.set_src(lv.imgbtn.STATE.RELEASED, RideInfo1_cover_imgbtn_imgReleased, None, None)

try:
    with open('C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp1436734276.png','rb') as f:
        RideInfo1_cover_imgbtn_imgPressed_data = f.read()
except:
    print('Could not open C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp1436734276.png')
    sys.exit()

RideInfo1_cover_imgbtn_imgPressed = lv.img_dsc_t({
  'data_size': len(RideInfo1_cover_imgbtn_imgPressed_data),
  'header': {'always_zero': 0, 'w': 480, 'h': 272, 'cf': lv.img.CF.TRUE_COLOR_ALPHA},
  'data': RideInfo1_cover_imgbtn_imgPressed_data
})
RideInfo1_cover_imgbtn.set_src(lv.imgbtn.STATE.PRESSED, RideInfo1_cover_imgbtn_imgPressed, None, None)




# create style style_rideinfo1_cover_imgbtn_main_main_default
style_rideinfo1_cover_imgbtn_main_main_default = lv.style_t()
style_rideinfo1_cover_imgbtn_main_main_default.init()
style_rideinfo1_cover_imgbtn_main_main_default.set_text_color(lv.color_make(0x00,0x00,0x00))
try:
    style_rideinfo1_cover_imgbtn_main_main_default.set_text_font(lv.font_simsun_12)
except AttributeError:
    try:
        style_rideinfo1_cover_imgbtn_main_main_default.set_text_font(lv.font_montserrat_12)
    except AttributeError:
        style_rideinfo1_cover_imgbtn_main_main_default.set_text_font(lv.font_montserrat_16)
style_rideinfo1_cover_imgbtn_main_main_default.set_img_recolor(lv.color_make(0xff,0xff,0xff))
style_rideinfo1_cover_imgbtn_main_main_default.set_img_recolor_opa(0)
style_rideinfo1_cover_imgbtn_main_main_default.set_img_opa(0)

# add style for RideInfo1_cover_imgbtn
RideInfo1_cover_imgbtn.add_style(style_rideinfo1_cover_imgbtn_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

# create style style_rideinfo1_cover_imgbtn_main_main_pressed
style_rideinfo1_cover_imgbtn_main_main_pressed = lv.style_t()
style_rideinfo1_cover_imgbtn_main_main_pressed.init()
style_rideinfo1_cover_imgbtn_main_main_pressed.set_text_color(lv.color_make(0xFF,0x33,0xFF))
try:
    style_rideinfo1_cover_imgbtn_main_main_pressed.set_text_font(lv.font_simsun_16)
except AttributeError:
    try:
        style_rideinfo1_cover_imgbtn_main_main_pressed.set_text_font(lv.font_montserrat_16)
    except AttributeError:
        style_rideinfo1_cover_imgbtn_main_main_pressed.set_text_font(lv.font_montserrat_16)
style_rideinfo1_cover_imgbtn_main_main_pressed.set_img_recolor(lv.color_make(0x00,0x00,0x00))
style_rideinfo1_cover_imgbtn_main_main_pressed.set_img_recolor_opa(0)

# add style for RideInfo1_cover_imgbtn
RideInfo1_cover_imgbtn.add_style(style_rideinfo1_cover_imgbtn_main_main_pressed, lv.PART.MAIN|lv.STATE.PRESSED)

# create style style_rideinfo1_cover_imgbtn_main_main_checked
style_rideinfo1_cover_imgbtn_main_main_checked = lv.style_t()
style_rideinfo1_cover_imgbtn_main_main_checked.init()
style_rideinfo1_cover_imgbtn_main_main_checked.set_text_color(lv.color_make(0xFF,0x33,0xFF))
try:
    style_rideinfo1_cover_imgbtn_main_main_checked.set_text_font(lv.font_simsun_16)
except AttributeError:
    try:
        style_rideinfo1_cover_imgbtn_main_main_checked.set_text_font(lv.font_montserrat_16)
    except AttributeError:
        style_rideinfo1_cover_imgbtn_main_main_checked.set_text_font(lv.font_montserrat_16)
style_rideinfo1_cover_imgbtn_main_main_checked.set_img_recolor(lv.color_make(0x00,0x00,0x00))
style_rideinfo1_cover_imgbtn_main_main_checked.set_img_recolor_opa(0)

# add style for RideInfo1_cover_imgbtn
RideInfo1_cover_imgbtn.add_style(style_rideinfo1_cover_imgbtn_main_main_checked, lv.PART.MAIN|lv.STATE.CHECKED)

RideInfo2 = lv.obj()
# create style style_rideinfo2_main_main_default
style_rideinfo2_main_main_default = lv.style_t()
style_rideinfo2_main_main_default.init()
style_rideinfo2_main_main_default.set_bg_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo2_main_main_default.set_bg_opa(0)

# add style for RideInfo2
RideInfo2.add_style(style_rideinfo2_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

RideInfo2_bg_img = lv.img(RideInfo2)
RideInfo2_bg_img.set_pos(0,0)
RideInfo2_bg_img.set_size(480,272)
RideInfo2_bg_img.add_flag(lv.obj.FLAG.CLICKABLE)
try:
    with open('C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp1436734276.png','rb') as f:
        RideInfo2_bg_img_img_data = f.read()
except:
    print('Could not open C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp1436734276.png')
    sys.exit()

RideInfo2_bg_img_img = lv.img_dsc_t({
  'data_size': len(RideInfo2_bg_img_img_data),
  'header': {'always_zero': 0, 'w': 480, 'h': 272, 'cf': lv.img.CF.TRUE_COLOR_ALPHA},
  'data': RideInfo2_bg_img_img_data
})

RideInfo2_bg_img.set_src(RideInfo2_bg_img_img)
RideInfo2_bg_img.set_pivot(0,0)
RideInfo2_bg_img.set_angle(0)
# create style style_rideinfo2_bg_img_main_main_default
style_rideinfo2_bg_img_main_main_default = lv.style_t()
style_rideinfo2_bg_img_main_main_default.init()
style_rideinfo2_bg_img_main_main_default.set_img_recolor(lv.color_make(0xff,0xff,0xff))
style_rideinfo2_bg_img_main_main_default.set_img_recolor_opa(0)
style_rideinfo2_bg_img_main_main_default.set_img_opa(255)

# add style for RideInfo2_bg_img
RideInfo2_bg_img.add_style(style_rideinfo2_bg_img_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

RideInfo2_hdr_img = lv.img(RideInfo2)
RideInfo2_hdr_img.set_pos(0,0)
RideInfo2_hdr_img.set_size(480,51)
RideInfo2_hdr_img.add_flag(lv.obj.FLAG.CLICKABLE)
try:
    with open('C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp-871685027.png','rb') as f:
        RideInfo2_hdr_img_img_data = f.read()
except:
    print('Could not open C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp-871685027.png')
    sys.exit()

RideInfo2_hdr_img_img = lv.img_dsc_t({
  'data_size': len(RideInfo2_hdr_img_img_data),
  'header': {'always_zero': 0, 'w': 480, 'h': 51, 'cf': lv.img.CF.TRUE_COLOR_ALPHA},
  'data': RideInfo2_hdr_img_img_data
})

RideInfo2_hdr_img.set_src(RideInfo2_hdr_img_img)
RideInfo2_hdr_img.set_pivot(0,0)
RideInfo2_hdr_img.set_angle(0)
# create style style_rideinfo2_hdr_img_main_main_default
style_rideinfo2_hdr_img_main_main_default = lv.style_t()
style_rideinfo2_hdr_img_main_main_default.init()
style_rideinfo2_hdr_img_main_main_default.set_img_recolor(lv.color_make(0xff,0xff,0xff))
style_rideinfo2_hdr_img_main_main_default.set_img_recolor_opa(0)
style_rideinfo2_hdr_img_main_main_default.set_img_opa(255)

# add style for RideInfo2_hdr_img
RideInfo2_hdr_img.add_style(style_rideinfo2_hdr_img_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

RideInfo2_date_label = lv.label(RideInfo2)
RideInfo2_date_label.set_pos(20,5)
RideInfo2_date_label.set_size(100,32)
RideInfo2_date_label.set_text("May 5, 2022")
RideInfo2_date_label.set_long_mode(lv.label.LONG.WRAP)
RideInfo2_date_label.set_style_text_align(lv.TEXT_ALIGN.LEFT, 0)
# create style style_rideinfo2_date_label_main_main_default
style_rideinfo2_date_label_main_main_default = lv.style_t()
style_rideinfo2_date_label_main_main_default.init()
style_rideinfo2_date_label_main_main_default.set_radius(0)
style_rideinfo2_date_label_main_main_default.set_bg_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo2_date_label_main_main_default.set_bg_grad_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo2_date_label_main_main_default.set_bg_grad_dir(lv.GRAD_DIR.VER)
style_rideinfo2_date_label_main_main_default.set_bg_opa(0)
style_rideinfo2_date_label_main_main_default.set_text_color(lv.color_make(0xff,0xff,0xff))
try:
    style_rideinfo2_date_label_main_main_default.set_text_font(lv.font_montserratMedium_12)
except AttributeError:
    try:
        style_rideinfo2_date_label_main_main_default.set_text_font(lv.font_montserrat_12)
    except AttributeError:
        style_rideinfo2_date_label_main_main_default.set_text_font(lv.font_montserrat_16)
style_rideinfo2_date_label_main_main_default.set_text_letter_space(1)
style_rideinfo2_date_label_main_main_default.set_pad_left(0)
style_rideinfo2_date_label_main_main_default.set_pad_right(0)
style_rideinfo2_date_label_main_main_default.set_pad_top(0)
style_rideinfo2_date_label_main_main_default.set_pad_bottom(0)

# add style for RideInfo2_date_label
RideInfo2_date_label.add_style(style_rideinfo2_date_label_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

RideInfo2_time_label = lv.label(RideInfo2)
RideInfo2_time_label.set_pos(360,5)
RideInfo2_time_label.set_size(100,32)
RideInfo2_time_label.set_text("10:28 AM")
RideInfo2_time_label.set_long_mode(lv.label.LONG.WRAP)
RideInfo2_time_label.set_style_text_align(lv.TEXT_ALIGN.RIGHT, 0)
# create style style_rideinfo2_time_label_main_main_default
style_rideinfo2_time_label_main_main_default = lv.style_t()
style_rideinfo2_time_label_main_main_default.init()
style_rideinfo2_time_label_main_main_default.set_radius(0)
style_rideinfo2_time_label_main_main_default.set_bg_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo2_time_label_main_main_default.set_bg_grad_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo2_time_label_main_main_default.set_bg_grad_dir(lv.GRAD_DIR.VER)
style_rideinfo2_time_label_main_main_default.set_bg_opa(0)
style_rideinfo2_time_label_main_main_default.set_text_color(lv.color_make(0xff,0xff,0xff))
try:
    style_rideinfo2_time_label_main_main_default.set_text_font(lv.font_montserratMedium_12)
except AttributeError:
    try:
        style_rideinfo2_time_label_main_main_default.set_text_font(lv.font_montserrat_12)
    except AttributeError:
        style_rideinfo2_time_label_main_main_default.set_text_font(lv.font_montserrat_16)
style_rideinfo2_time_label_main_main_default.set_text_letter_space(1)
style_rideinfo2_time_label_main_main_default.set_pad_left(0)
style_rideinfo2_time_label_main_main_default.set_pad_right(0)
style_rideinfo2_time_label_main_main_default.set_pad_top(0)
style_rideinfo2_time_label_main_main_default.set_pad_bottom(0)

# add style for RideInfo2_time_label
RideInfo2_time_label.add_style(style_rideinfo2_time_label_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

RideInfo2_sub_label = lv.label(RideInfo2)
RideInfo2_sub_label.set_pos(160,5)
RideInfo2_sub_label.set_size(180,32)
RideInfo2_sub_label.set_text("RIDE DETAILS")
RideInfo2_sub_label.set_long_mode(lv.label.LONG.WRAP)
RideInfo2_sub_label.set_style_text_align(lv.TEXT_ALIGN.LEFT, 0)
# create style style_rideinfo2_sub_label_main_main_default
style_rideinfo2_sub_label_main_main_default = lv.style_t()
style_rideinfo2_sub_label_main_main_default.init()
style_rideinfo2_sub_label_main_main_default.set_radius(0)
style_rideinfo2_sub_label_main_main_default.set_bg_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo2_sub_label_main_main_default.set_bg_grad_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo2_sub_label_main_main_default.set_bg_grad_dir(lv.GRAD_DIR.VER)
style_rideinfo2_sub_label_main_main_default.set_bg_opa(0)
style_rideinfo2_sub_label_main_main_default.set_text_color(lv.color_make(0xff,0xff,0xff))
try:
    style_rideinfo2_sub_label_main_main_default.set_text_font(lv.font_montserratMedium_20)
except AttributeError:
    try:
        style_rideinfo2_sub_label_main_main_default.set_text_font(lv.font_montserrat_20)
    except AttributeError:
        style_rideinfo2_sub_label_main_main_default.set_text_font(lv.font_montserrat_16)
style_rideinfo2_sub_label_main_main_default.set_text_letter_space(1)
style_rideinfo2_sub_label_main_main_default.set_pad_left(0)
style_rideinfo2_sub_label_main_main_default.set_pad_right(0)
style_rideinfo2_sub_label_main_main_default.set_pad_top(0)
style_rideinfo2_sub_label_main_main_default.set_pad_bottom(0)

# add style for RideInfo2_sub_label
RideInfo2_sub_label.add_style(style_rideinfo2_sub_label_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

RideInfo2_gps_icon = lv.img(RideInfo2)
RideInfo2_gps_icon.set_pos(274,50)
RideInfo2_gps_icon.set_size(28,48)
RideInfo2_gps_icon.add_flag(lv.obj.FLAG.CLICKABLE)
try:
    with open('C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp-1179468466.png','rb') as f:
        RideInfo2_gps_icon_img_data = f.read()
except:
    print('Could not open C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp-1179468466.png')
    sys.exit()

RideInfo2_gps_icon_img = lv.img_dsc_t({
  'data_size': len(RideInfo2_gps_icon_img_data),
  'header': {'always_zero': 0, 'w': 28, 'h': 48, 'cf': lv.img.CF.TRUE_COLOR_ALPHA},
  'data': RideInfo2_gps_icon_img_data
})

RideInfo2_gps_icon.set_src(RideInfo2_gps_icon_img)
RideInfo2_gps_icon.set_pivot(0,0)
RideInfo2_gps_icon.set_angle(0)
# create style style_rideinfo2_gps_icon_main_main_default
style_rideinfo2_gps_icon_main_main_default = lv.style_t()
style_rideinfo2_gps_icon_main_main_default.init()
style_rideinfo2_gps_icon_main_main_default.set_img_recolor(lv.color_make(0xff,0xff,0xff))
style_rideinfo2_gps_icon_main_main_default.set_img_recolor_opa(0)
style_rideinfo2_gps_icon_main_main_default.set_img_opa(255)

# add style for RideInfo2_gps_icon
RideInfo2_gps_icon.add_style(style_rideinfo2_gps_icon_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

RideInfo2_calories_icon = lv.img(RideInfo2)
RideInfo2_calories_icon.set_pos(244,120)
RideInfo2_calories_icon.set_size(21,14)
RideInfo2_calories_icon.add_flag(lv.obj.FLAG.CLICKABLE)
try:
    with open('C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp-71590372.png','rb') as f:
        RideInfo2_calories_icon_img_data = f.read()
except:
    print('Could not open C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp-71590372.png')
    sys.exit()

RideInfo2_calories_icon_img = lv.img_dsc_t({
  'data_size': len(RideInfo2_calories_icon_img_data),
  'header': {'always_zero': 0, 'w': 21, 'h': 14, 'cf': lv.img.CF.TRUE_COLOR_ALPHA},
  'data': RideInfo2_calories_icon_img_data
})

RideInfo2_calories_icon.set_src(RideInfo2_calories_icon_img)
RideInfo2_calories_icon.set_pivot(0,0)
RideInfo2_calories_icon.set_angle(0)
# create style style_rideinfo2_calories_icon_main_main_default
style_rideinfo2_calories_icon_main_main_default = lv.style_t()
style_rideinfo2_calories_icon_main_main_default.init()
style_rideinfo2_calories_icon_main_main_default.set_img_recolor(lv.color_make(0xff,0xff,0xff))
style_rideinfo2_calories_icon_main_main_default.set_img_recolor_opa(0)
style_rideinfo2_calories_icon_main_main_default.set_img_opa(255)

# add style for RideInfo2_calories_icon
RideInfo2_calories_icon.add_style(style_rideinfo2_calories_icon_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

RideInfo2_hr_icon = lv.img(RideInfo2)
RideInfo2_hr_icon.set_pos(360,120)
RideInfo2_hr_icon.set_size(23,17)
RideInfo2_hr_icon.add_flag(lv.obj.FLAG.CLICKABLE)
try:
    with open('C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp-1339364627.png','rb') as f:
        RideInfo2_hr_icon_img_data = f.read()
except:
    print('Could not open C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp-1339364627.png')
    sys.exit()

RideInfo2_hr_icon_img = lv.img_dsc_t({
  'data_size': len(RideInfo2_hr_icon_img_data),
  'header': {'always_zero': 0, 'w': 23, 'h': 17, 'cf': lv.img.CF.TRUE_COLOR_ALPHA},
  'data': RideInfo2_hr_icon_img_data
})

RideInfo2_hr_icon.set_src(RideInfo2_hr_icon_img)
RideInfo2_hr_icon.set_pivot(0,0)
RideInfo2_hr_icon.set_angle(0)
# create style style_rideinfo2_hr_icon_main_main_default
style_rideinfo2_hr_icon_main_main_default = lv.style_t()
style_rideinfo2_hr_icon_main_main_default.init()
style_rideinfo2_hr_icon_main_main_default.set_img_recolor(lv.color_make(0xff,0xff,0xff))
style_rideinfo2_hr_icon_main_main_default.set_img_recolor_opa(0)
style_rideinfo2_hr_icon_main_main_default.set_img_opa(255)

# add style for RideInfo2_hr_icon
RideInfo2_hr_icon.add_style(style_rideinfo2_hr_icon_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

RideInfo2_cadence_icon = lv.img(RideInfo2)
RideInfo2_cadence_icon.set_pos(244,183)
RideInfo2_cadence_icon.set_size(20,20)
RideInfo2_cadence_icon.add_flag(lv.obj.FLAG.CLICKABLE)
try:
    with open('C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp136501136.png','rb') as f:
        RideInfo2_cadence_icon_img_data = f.read()
except:
    print('Could not open C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp136501136.png')
    sys.exit()

RideInfo2_cadence_icon_img = lv.img_dsc_t({
  'data_size': len(RideInfo2_cadence_icon_img_data),
  'header': {'always_zero': 0, 'w': 20, 'h': 20, 'cf': lv.img.CF.TRUE_COLOR_ALPHA},
  'data': RideInfo2_cadence_icon_img_data
})

RideInfo2_cadence_icon.set_src(RideInfo2_cadence_icon_img)
RideInfo2_cadence_icon.set_pivot(0,0)
RideInfo2_cadence_icon.set_angle(0)
# create style style_rideinfo2_cadence_icon_main_main_default
style_rideinfo2_cadence_icon_main_main_default = lv.style_t()
style_rideinfo2_cadence_icon_main_main_default.init()
style_rideinfo2_cadence_icon_main_main_default.set_img_recolor(lv.color_make(0xff,0xff,0xff))
style_rideinfo2_cadence_icon_main_main_default.set_img_recolor_opa(0)
style_rideinfo2_cadence_icon_main_main_default.set_img_opa(255)

# add style for RideInfo2_cadence_icon
RideInfo2_cadence_icon.add_style(style_rideinfo2_cadence_icon_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

RideInfo2_elapsed_icon = lv.img(RideInfo2)
RideInfo2_elapsed_icon.set_pos(360,183)
RideInfo2_elapsed_icon.set_size(20,25)
RideInfo2_elapsed_icon.add_flag(lv.obj.FLAG.CLICKABLE)
try:
    with open('C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp1992887665.png','rb') as f:
        RideInfo2_elapsed_icon_img_data = f.read()
except:
    print('Could not open C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp1992887665.png')
    sys.exit()

RideInfo2_elapsed_icon_img = lv.img_dsc_t({
  'data_size': len(RideInfo2_elapsed_icon_img_data),
  'header': {'always_zero': 0, 'w': 20, 'h': 25, 'cf': lv.img.CF.TRUE_COLOR_ALPHA},
  'data': RideInfo2_elapsed_icon_img_data
})

RideInfo2_elapsed_icon.set_src(RideInfo2_elapsed_icon_img)
RideInfo2_elapsed_icon.set_pivot(0,0)
RideInfo2_elapsed_icon.set_angle(0)
# create style style_rideinfo2_elapsed_icon_main_main_default
style_rideinfo2_elapsed_icon_main_main_default = lv.style_t()
style_rideinfo2_elapsed_icon_main_main_default.init()
style_rideinfo2_elapsed_icon_main_main_default.set_img_recolor(lv.color_make(0xff,0xff,0xff))
style_rideinfo2_elapsed_icon_main_main_default.set_img_recolor_opa(0)
style_rideinfo2_elapsed_icon_main_main_default.set_img_opa(255)

# add style for RideInfo2_elapsed_icon
RideInfo2_elapsed_icon.add_style(style_rideinfo2_elapsed_icon_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

RideInfo2_dist_label = lv.label(RideInfo2)
RideInfo2_dist_label.set_pos(320,45)
RideInfo2_dist_label.set_size(100,32)
RideInfo2_dist_label.set_text("3.1 KM")
RideInfo2_dist_label.set_long_mode(lv.label.LONG.WRAP)
RideInfo2_dist_label.set_style_text_align(lv.TEXT_ALIGN.LEFT, 0)
# create style style_rideinfo2_dist_label_main_main_default
style_rideinfo2_dist_label_main_main_default = lv.style_t()
style_rideinfo2_dist_label_main_main_default.init()
style_rideinfo2_dist_label_main_main_default.set_radius(0)
style_rideinfo2_dist_label_main_main_default.set_bg_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo2_dist_label_main_main_default.set_bg_grad_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo2_dist_label_main_main_default.set_bg_grad_dir(lv.GRAD_DIR.VER)
style_rideinfo2_dist_label_main_main_default.set_bg_opa(0)
style_rideinfo2_dist_label_main_main_default.set_text_color(lv.color_make(0xff,0xff,0xff))
try:
    style_rideinfo2_dist_label_main_main_default.set_text_font(lv.font_montserratMedium_28)
except AttributeError:
    try:
        style_rideinfo2_dist_label_main_main_default.set_text_font(lv.font_montserrat_28)
    except AttributeError:
        style_rideinfo2_dist_label_main_main_default.set_text_font(lv.font_montserrat_16)
style_rideinfo2_dist_label_main_main_default.set_text_letter_space(1)
style_rideinfo2_dist_label_main_main_default.set_pad_left(0)
style_rideinfo2_dist_label_main_main_default.set_pad_right(0)
style_rideinfo2_dist_label_main_main_default.set_pad_top(0)
style_rideinfo2_dist_label_main_main_default.set_pad_bottom(0)

# add style for RideInfo2_dist_label
RideInfo2_dist_label.add_style(style_rideinfo2_dist_label_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

RideInfo2_dir_label = lv.label(RideInfo2)
RideInfo2_dir_label.set_pos(320,73)
RideInfo2_dir_label.set_size(100,32)
RideInfo2_dir_label.set_text("Turn right to")
RideInfo2_dir_label.set_long_mode(lv.label.LONG.WRAP)
RideInfo2_dir_label.set_style_text_align(lv.TEXT_ALIGN.LEFT, 0)
# create style style_rideinfo2_dir_label_main_main_default
style_rideinfo2_dir_label_main_main_default = lv.style_t()
style_rideinfo2_dir_label_main_main_default.init()
style_rideinfo2_dir_label_main_main_default.set_radius(0)
style_rideinfo2_dir_label_main_main_default.set_bg_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo2_dir_label_main_main_default.set_bg_grad_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo2_dir_label_main_main_default.set_bg_grad_dir(lv.GRAD_DIR.VER)
style_rideinfo2_dir_label_main_main_default.set_bg_opa(0)
style_rideinfo2_dir_label_main_main_default.set_text_color(lv.color_make(0x9e,0x9e,0x9e))
try:
    style_rideinfo2_dir_label_main_main_default.set_text_font(lv.font_montserratMedium_12)
except AttributeError:
    try:
        style_rideinfo2_dir_label_main_main_default.set_text_font(lv.font_montserrat_12)
    except AttributeError:
        style_rideinfo2_dir_label_main_main_default.set_text_font(lv.font_montserrat_16)
style_rideinfo2_dir_label_main_main_default.set_text_letter_space(0)
style_rideinfo2_dir_label_main_main_default.set_pad_left(0)
style_rideinfo2_dir_label_main_main_default.set_pad_right(0)
style_rideinfo2_dir_label_main_main_default.set_pad_top(0)
style_rideinfo2_dir_label_main_main_default.set_pad_bottom(0)

# add style for RideInfo2_dir_label
RideInfo2_dir_label.add_style(style_rideinfo2_dir_label_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

RideInfo2_str_label = lv.label(RideInfo2)
RideInfo2_str_label.set_pos(320,87)
RideInfo2_str_label.set_size(120,32)
RideInfo2_str_label.set_text("Ed Bluestein Blvd")
RideInfo2_str_label.set_long_mode(lv.label.LONG.WRAP)
RideInfo2_str_label.set_style_text_align(lv.TEXT_ALIGN.LEFT, 0)
# create style style_rideinfo2_str_label_main_main_default
style_rideinfo2_str_label_main_main_default = lv.style_t()
style_rideinfo2_str_label_main_main_default.init()
style_rideinfo2_str_label_main_main_default.set_radius(0)
style_rideinfo2_str_label_main_main_default.set_bg_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo2_str_label_main_main_default.set_bg_grad_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo2_str_label_main_main_default.set_bg_grad_dir(lv.GRAD_DIR.VER)
style_rideinfo2_str_label_main_main_default.set_bg_opa(0)
style_rideinfo2_str_label_main_main_default.set_text_color(lv.color_make(0xcc,0xcc,0xcc))
try:
    style_rideinfo2_str_label_main_main_default.set_text_font(lv.font_montserratMedium_12)
except AttributeError:
    try:
        style_rideinfo2_str_label_main_main_default.set_text_font(lv.font_montserrat_12)
    except AttributeError:
        style_rideinfo2_str_label_main_main_default.set_text_font(lv.font_montserrat_16)
style_rideinfo2_str_label_main_main_default.set_text_letter_space(0)
style_rideinfo2_str_label_main_main_default.set_pad_left(0)
style_rideinfo2_str_label_main_main_default.set_pad_right(0)
style_rideinfo2_str_label_main_main_default.set_pad_top(0)
style_rideinfo2_str_label_main_main_default.set_pad_bottom(0)

# add style for RideInfo2_str_label
RideInfo2_str_label.add_style(style_rideinfo2_str_label_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

RideInfo2_info1_label_1 = lv.label(RideInfo2)
RideInfo2_info1_label_1.set_pos(274,116)
RideInfo2_info1_label_1.set_size(60,32)
RideInfo2_info1_label_1.set_text("Calories")
RideInfo2_info1_label_1.set_long_mode(lv.label.LONG.WRAP)
RideInfo2_info1_label_1.set_style_text_align(lv.TEXT_ALIGN.LEFT, 0)
# create style style_rideinfo2_info1_label_1_main_main_default
style_rideinfo2_info1_label_1_main_main_default = lv.style_t()
style_rideinfo2_info1_label_1_main_main_default.init()
style_rideinfo2_info1_label_1_main_main_default.set_radius(0)
style_rideinfo2_info1_label_1_main_main_default.set_bg_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo2_info1_label_1_main_main_default.set_bg_grad_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo2_info1_label_1_main_main_default.set_bg_grad_dir(lv.GRAD_DIR.VER)
style_rideinfo2_info1_label_1_main_main_default.set_bg_opa(0)
style_rideinfo2_info1_label_1_main_main_default.set_text_color(lv.color_make(0x9e,0x9e,0x9e))
try:
    style_rideinfo2_info1_label_1_main_main_default.set_text_font(lv.font_montserratMedium_12)
except AttributeError:
    try:
        style_rideinfo2_info1_label_1_main_main_default.set_text_font(lv.font_montserrat_12)
    except AttributeError:
        style_rideinfo2_info1_label_1_main_main_default.set_text_font(lv.font_montserrat_16)
style_rideinfo2_info1_label_1_main_main_default.set_text_letter_space(0)
style_rideinfo2_info1_label_1_main_main_default.set_pad_left(0)
style_rideinfo2_info1_label_1_main_main_default.set_pad_right(0)
style_rideinfo2_info1_label_1_main_main_default.set_pad_top(0)
style_rideinfo2_info1_label_1_main_main_default.set_pad_bottom(0)

# add style for RideInfo2_info1_label_1
RideInfo2_info1_label_1.add_style(style_rideinfo2_info1_label_1_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

RideInfo2_info1_label_2 = lv.label(RideInfo2)
RideInfo2_info1_label_2.set_pos(274,128)
RideInfo2_info1_label_2.set_size(60,32)
RideInfo2_info1_label_2.set_text("Burned")
RideInfo2_info1_label_2.set_long_mode(lv.label.LONG.WRAP)
RideInfo2_info1_label_2.set_style_text_align(lv.TEXT_ALIGN.LEFT, 0)
# create style style_rideinfo2_info1_label_2_main_main_default
style_rideinfo2_info1_label_2_main_main_default = lv.style_t()
style_rideinfo2_info1_label_2_main_main_default.init()
style_rideinfo2_info1_label_2_main_main_default.set_radius(0)
style_rideinfo2_info1_label_2_main_main_default.set_bg_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo2_info1_label_2_main_main_default.set_bg_grad_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo2_info1_label_2_main_main_default.set_bg_grad_dir(lv.GRAD_DIR.VER)
style_rideinfo2_info1_label_2_main_main_default.set_bg_opa(0)
style_rideinfo2_info1_label_2_main_main_default.set_text_color(lv.color_make(0x9e,0x9e,0x9e))
try:
    style_rideinfo2_info1_label_2_main_main_default.set_text_font(lv.font_montserratMedium_12)
except AttributeError:
    try:
        style_rideinfo2_info1_label_2_main_main_default.set_text_font(lv.font_montserrat_12)
    except AttributeError:
        style_rideinfo2_info1_label_2_main_main_default.set_text_font(lv.font_montserrat_16)
style_rideinfo2_info1_label_2_main_main_default.set_text_letter_space(0)
style_rideinfo2_info1_label_2_main_main_default.set_pad_left(0)
style_rideinfo2_info1_label_2_main_main_default.set_pad_right(0)
style_rideinfo2_info1_label_2_main_main_default.set_pad_top(0)
style_rideinfo2_info1_label_2_main_main_default.set_pad_bottom(0)

# add style for RideInfo2_info1_label_2
RideInfo2_info1_label_2.add_style(style_rideinfo2_info1_label_2_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

RideInfo2_info2_label_1 = lv.label(RideInfo2)
RideInfo2_info2_label_1.set_pos(394,116)
RideInfo2_info2_label_1.set_size(60,32)
RideInfo2_info2_label_1.set_text("Heart")
RideInfo2_info2_label_1.set_long_mode(lv.label.LONG.WRAP)
RideInfo2_info2_label_1.set_style_text_align(lv.TEXT_ALIGN.LEFT, 0)
# create style style_rideinfo2_info2_label_1_main_main_default
style_rideinfo2_info2_label_1_main_main_default = lv.style_t()
style_rideinfo2_info2_label_1_main_main_default.init()
style_rideinfo2_info2_label_1_main_main_default.set_radius(0)
style_rideinfo2_info2_label_1_main_main_default.set_bg_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo2_info2_label_1_main_main_default.set_bg_grad_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo2_info2_label_1_main_main_default.set_bg_grad_dir(lv.GRAD_DIR.VER)
style_rideinfo2_info2_label_1_main_main_default.set_bg_opa(0)
style_rideinfo2_info2_label_1_main_main_default.set_text_color(lv.color_make(0x9e,0x9e,0x9e))
try:
    style_rideinfo2_info2_label_1_main_main_default.set_text_font(lv.font_montserratMedium_12)
except AttributeError:
    try:
        style_rideinfo2_info2_label_1_main_main_default.set_text_font(lv.font_montserrat_12)
    except AttributeError:
        style_rideinfo2_info2_label_1_main_main_default.set_text_font(lv.font_montserrat_16)
style_rideinfo2_info2_label_1_main_main_default.set_text_letter_space(0)
style_rideinfo2_info2_label_1_main_main_default.set_pad_left(0)
style_rideinfo2_info2_label_1_main_main_default.set_pad_right(0)
style_rideinfo2_info2_label_1_main_main_default.set_pad_top(0)
style_rideinfo2_info2_label_1_main_main_default.set_pad_bottom(0)

# add style for RideInfo2_info2_label_1
RideInfo2_info2_label_1.add_style(style_rideinfo2_info2_label_1_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

RideInfo2_info2_label_2 = lv.label(RideInfo2)
RideInfo2_info2_label_2.set_pos(394,128)
RideInfo2_info2_label_2.set_size(60,32)
RideInfo2_info2_label_2.set_text("Rate")
RideInfo2_info2_label_2.set_long_mode(lv.label.LONG.WRAP)
RideInfo2_info2_label_2.set_style_text_align(lv.TEXT_ALIGN.LEFT, 0)
# create style style_rideinfo2_info2_label_2_main_main_default
style_rideinfo2_info2_label_2_main_main_default = lv.style_t()
style_rideinfo2_info2_label_2_main_main_default.init()
style_rideinfo2_info2_label_2_main_main_default.set_radius(0)
style_rideinfo2_info2_label_2_main_main_default.set_bg_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo2_info2_label_2_main_main_default.set_bg_grad_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo2_info2_label_2_main_main_default.set_bg_grad_dir(lv.GRAD_DIR.VER)
style_rideinfo2_info2_label_2_main_main_default.set_bg_opa(0)
style_rideinfo2_info2_label_2_main_main_default.set_text_color(lv.color_make(0x9e,0x9e,0x9e))
try:
    style_rideinfo2_info2_label_2_main_main_default.set_text_font(lv.font_montserratMedium_12)
except AttributeError:
    try:
        style_rideinfo2_info2_label_2_main_main_default.set_text_font(lv.font_montserrat_12)
    except AttributeError:
        style_rideinfo2_info2_label_2_main_main_default.set_text_font(lv.font_montserrat_16)
style_rideinfo2_info2_label_2_main_main_default.set_text_letter_space(0)
style_rideinfo2_info2_label_2_main_main_default.set_pad_left(0)
style_rideinfo2_info2_label_2_main_main_default.set_pad_right(0)
style_rideinfo2_info2_label_2_main_main_default.set_pad_top(0)
style_rideinfo2_info2_label_2_main_main_default.set_pad_bottom(0)

# add style for RideInfo2_info2_label_2
RideInfo2_info2_label_2.add_style(style_rideinfo2_info2_label_2_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

RideInfo2_info3_label_1 = lv.label(RideInfo2)
RideInfo2_info3_label_1.set_pos(274,178)
RideInfo2_info3_label_1.set_size(80,32)
RideInfo2_info3_label_1.set_text("Cadence")
RideInfo2_info3_label_1.set_long_mode(lv.label.LONG.WRAP)
RideInfo2_info3_label_1.set_style_text_align(lv.TEXT_ALIGN.LEFT, 0)
# create style style_rideinfo2_info3_label_1_main_main_default
style_rideinfo2_info3_label_1_main_main_default = lv.style_t()
style_rideinfo2_info3_label_1_main_main_default.init()
style_rideinfo2_info3_label_1_main_main_default.set_radius(0)
style_rideinfo2_info3_label_1_main_main_default.set_bg_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo2_info3_label_1_main_main_default.set_bg_grad_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo2_info3_label_1_main_main_default.set_bg_grad_dir(lv.GRAD_DIR.VER)
style_rideinfo2_info3_label_1_main_main_default.set_bg_opa(0)
style_rideinfo2_info3_label_1_main_main_default.set_text_color(lv.color_make(0x9e,0x9e,0x9e))
try:
    style_rideinfo2_info3_label_1_main_main_default.set_text_font(lv.font_montserratMedium_12)
except AttributeError:
    try:
        style_rideinfo2_info3_label_1_main_main_default.set_text_font(lv.font_montserrat_12)
    except AttributeError:
        style_rideinfo2_info3_label_1_main_main_default.set_text_font(lv.font_montserrat_16)
style_rideinfo2_info3_label_1_main_main_default.set_text_letter_space(0)
style_rideinfo2_info3_label_1_main_main_default.set_pad_left(0)
style_rideinfo2_info3_label_1_main_main_default.set_pad_right(0)
style_rideinfo2_info3_label_1_main_main_default.set_pad_top(0)
style_rideinfo2_info3_label_1_main_main_default.set_pad_bottom(0)

# add style for RideInfo2_info3_label_1
RideInfo2_info3_label_1.add_style(style_rideinfo2_info3_label_1_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

RideInfo2_linfo4_label_1 = lv.label(RideInfo2)
RideInfo2_linfo4_label_1.set_pos(394,178)
RideInfo2_linfo4_label_1.set_size(60,32)
RideInfo2_linfo4_label_1.set_text("Elapsed")
RideInfo2_linfo4_label_1.set_long_mode(lv.label.LONG.WRAP)
RideInfo2_linfo4_label_1.set_style_text_align(lv.TEXT_ALIGN.LEFT, 0)
# create style style_rideinfo2_linfo4_label_1_main_main_default
style_rideinfo2_linfo4_label_1_main_main_default = lv.style_t()
style_rideinfo2_linfo4_label_1_main_main_default.init()
style_rideinfo2_linfo4_label_1_main_main_default.set_radius(0)
style_rideinfo2_linfo4_label_1_main_main_default.set_bg_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo2_linfo4_label_1_main_main_default.set_bg_grad_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo2_linfo4_label_1_main_main_default.set_bg_grad_dir(lv.GRAD_DIR.VER)
style_rideinfo2_linfo4_label_1_main_main_default.set_bg_opa(0)
style_rideinfo2_linfo4_label_1_main_main_default.set_text_color(lv.color_make(0x9e,0x9e,0x9e))
try:
    style_rideinfo2_linfo4_label_1_main_main_default.set_text_font(lv.font_montserratMedium_12)
except AttributeError:
    try:
        style_rideinfo2_linfo4_label_1_main_main_default.set_text_font(lv.font_montserrat_12)
    except AttributeError:
        style_rideinfo2_linfo4_label_1_main_main_default.set_text_font(lv.font_montserrat_16)
style_rideinfo2_linfo4_label_1_main_main_default.set_text_letter_space(0)
style_rideinfo2_linfo4_label_1_main_main_default.set_pad_left(0)
style_rideinfo2_linfo4_label_1_main_main_default.set_pad_right(0)
style_rideinfo2_linfo4_label_1_main_main_default.set_pad_top(0)
style_rideinfo2_linfo4_label_1_main_main_default.set_pad_bottom(0)

# add style for RideInfo2_linfo4_label_1
RideInfo2_linfo4_label_1.add_style(style_rideinfo2_linfo4_label_1_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

RideInfo2_linfo4_label_2 = lv.label(RideInfo2)
RideInfo2_linfo4_label_2.set_pos(394,190)
RideInfo2_linfo4_label_2.set_size(60,32)
RideInfo2_linfo4_label_2.set_text("Time")
RideInfo2_linfo4_label_2.set_long_mode(lv.label.LONG.WRAP)
RideInfo2_linfo4_label_2.set_style_text_align(lv.TEXT_ALIGN.LEFT, 0)
# create style style_rideinfo2_linfo4_label_2_main_main_default
style_rideinfo2_linfo4_label_2_main_main_default = lv.style_t()
style_rideinfo2_linfo4_label_2_main_main_default.init()
style_rideinfo2_linfo4_label_2_main_main_default.set_radius(0)
style_rideinfo2_linfo4_label_2_main_main_default.set_bg_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo2_linfo4_label_2_main_main_default.set_bg_grad_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo2_linfo4_label_2_main_main_default.set_bg_grad_dir(lv.GRAD_DIR.VER)
style_rideinfo2_linfo4_label_2_main_main_default.set_bg_opa(0)
style_rideinfo2_linfo4_label_2_main_main_default.set_text_color(lv.color_make(0x9e,0x9e,0x9e))
try:
    style_rideinfo2_linfo4_label_2_main_main_default.set_text_font(lv.font_montserratMedium_12)
except AttributeError:
    try:
        style_rideinfo2_linfo4_label_2_main_main_default.set_text_font(lv.font_montserrat_12)
    except AttributeError:
        style_rideinfo2_linfo4_label_2_main_main_default.set_text_font(lv.font_montserrat_16)
style_rideinfo2_linfo4_label_2_main_main_default.set_text_letter_space(0)
style_rideinfo2_linfo4_label_2_main_main_default.set_pad_left(0)
style_rideinfo2_linfo4_label_2_main_main_default.set_pad_right(0)
style_rideinfo2_linfo4_label_2_main_main_default.set_pad_top(0)
style_rideinfo2_linfo4_label_2_main_main_default.set_pad_bottom(0)

# add style for RideInfo2_linfo4_label_2
RideInfo2_linfo4_label_2.add_style(style_rideinfo2_linfo4_label_2_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

RideInfo2_info1_label_3 = lv.label(RideInfo2)
RideInfo2_info1_label_3.set_pos(244,145)
RideInfo2_info1_label_3.set_size(50,32)
RideInfo2_info1_label_3.set_text("462")
RideInfo2_info1_label_3.set_long_mode(lv.label.LONG.WRAP)
RideInfo2_info1_label_3.set_style_text_align(lv.TEXT_ALIGN.LEFT, 0)
# create style style_rideinfo2_info1_label_3_main_main_default
style_rideinfo2_info1_label_3_main_main_default = lv.style_t()
style_rideinfo2_info1_label_3_main_main_default.init()
style_rideinfo2_info1_label_3_main_main_default.set_radius(0)
style_rideinfo2_info1_label_3_main_main_default.set_bg_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo2_info1_label_3_main_main_default.set_bg_grad_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo2_info1_label_3_main_main_default.set_bg_grad_dir(lv.GRAD_DIR.VER)
style_rideinfo2_info1_label_3_main_main_default.set_bg_opa(0)
style_rideinfo2_info1_label_3_main_main_default.set_text_color(lv.color_make(0x00,0x80,0xff))
try:
    style_rideinfo2_info1_label_3_main_main_default.set_text_font(lv.font_montserratMedium_20)
except AttributeError:
    try:
        style_rideinfo2_info1_label_3_main_main_default.set_text_font(lv.font_montserrat_20)
    except AttributeError:
        style_rideinfo2_info1_label_3_main_main_default.set_text_font(lv.font_montserrat_16)
style_rideinfo2_info1_label_3_main_main_default.set_text_letter_space(0)
style_rideinfo2_info1_label_3_main_main_default.set_pad_left(0)
style_rideinfo2_info1_label_3_main_main_default.set_pad_right(0)
style_rideinfo2_info1_label_3_main_main_default.set_pad_top(0)
style_rideinfo2_info1_label_3_main_main_default.set_pad_bottom(0)

# add style for RideInfo2_info1_label_3
RideInfo2_info1_label_3.add_style(style_rideinfo2_info1_label_3_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

RideInfo2_info2_label_3 = lv.label(RideInfo2)
RideInfo2_info2_label_3.set_pos(360,145)
RideInfo2_info2_label_3.set_size(50,32)
RideInfo2_info2_label_3.set_text("118")
RideInfo2_info2_label_3.set_long_mode(lv.label.LONG.WRAP)
RideInfo2_info2_label_3.set_style_text_align(lv.TEXT_ALIGN.LEFT, 0)
# create style style_rideinfo2_info2_label_3_main_main_default
style_rideinfo2_info2_label_3_main_main_default = lv.style_t()
style_rideinfo2_info2_label_3_main_main_default.init()
style_rideinfo2_info2_label_3_main_main_default.set_radius(0)
style_rideinfo2_info2_label_3_main_main_default.set_bg_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo2_info2_label_3_main_main_default.set_bg_grad_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo2_info2_label_3_main_main_default.set_bg_grad_dir(lv.GRAD_DIR.VER)
style_rideinfo2_info2_label_3_main_main_default.set_bg_opa(0)
style_rideinfo2_info2_label_3_main_main_default.set_text_color(lv.color_make(0x00,0x80,0xff))
try:
    style_rideinfo2_info2_label_3_main_main_default.set_text_font(lv.font_montserratMedium_20)
except AttributeError:
    try:
        style_rideinfo2_info2_label_3_main_main_default.set_text_font(lv.font_montserrat_20)
    except AttributeError:
        style_rideinfo2_info2_label_3_main_main_default.set_text_font(lv.font_montserrat_16)
style_rideinfo2_info2_label_3_main_main_default.set_text_letter_space(0)
style_rideinfo2_info2_label_3_main_main_default.set_pad_left(0)
style_rideinfo2_info2_label_3_main_main_default.set_pad_right(0)
style_rideinfo2_info2_label_3_main_main_default.set_pad_top(0)
style_rideinfo2_info2_label_3_main_main_default.set_pad_bottom(0)

# add style for RideInfo2_info2_label_3
RideInfo2_info2_label_3.add_style(style_rideinfo2_info2_label_3_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

RideInfo2_info3_label_3 = lv.label(RideInfo2)
RideInfo2_info3_label_3.set_pos(244,215)
RideInfo2_info3_label_3.set_size(50,32)
RideInfo2_info3_label_3.set_text("86")
RideInfo2_info3_label_3.set_long_mode(lv.label.LONG.WRAP)
RideInfo2_info3_label_3.set_style_text_align(lv.TEXT_ALIGN.LEFT, 0)
# create style style_rideinfo2_info3_label_3_main_main_default
style_rideinfo2_info3_label_3_main_main_default = lv.style_t()
style_rideinfo2_info3_label_3_main_main_default.init()
style_rideinfo2_info3_label_3_main_main_default.set_radius(0)
style_rideinfo2_info3_label_3_main_main_default.set_bg_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo2_info3_label_3_main_main_default.set_bg_grad_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo2_info3_label_3_main_main_default.set_bg_grad_dir(lv.GRAD_DIR.VER)
style_rideinfo2_info3_label_3_main_main_default.set_bg_opa(0)
style_rideinfo2_info3_label_3_main_main_default.set_text_color(lv.color_make(0x00,0x80,0xff))
try:
    style_rideinfo2_info3_label_3_main_main_default.set_text_font(lv.font_montserratMedium_20)
except AttributeError:
    try:
        style_rideinfo2_info3_label_3_main_main_default.set_text_font(lv.font_montserrat_20)
    except AttributeError:
        style_rideinfo2_info3_label_3_main_main_default.set_text_font(lv.font_montserrat_16)
style_rideinfo2_info3_label_3_main_main_default.set_text_letter_space(0)
style_rideinfo2_info3_label_3_main_main_default.set_pad_left(0)
style_rideinfo2_info3_label_3_main_main_default.set_pad_right(0)
style_rideinfo2_info3_label_3_main_main_default.set_pad_top(0)
style_rideinfo2_info3_label_3_main_main_default.set_pad_bottom(0)

# add style for RideInfo2_info3_label_3
RideInfo2_info3_label_3.add_style(style_rideinfo2_info3_label_3_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

RideInfo2_info4_label_3 = lv.label(RideInfo2)
RideInfo2_info4_label_3.set_pos(360,215)
RideInfo2_info4_label_3.set_size(100,32)
RideInfo2_info4_label_3.set_text("46:28")
RideInfo2_info4_label_3.set_long_mode(lv.label.LONG.WRAP)
RideInfo2_info4_label_3.set_style_text_align(lv.TEXT_ALIGN.LEFT, 0)
# create style style_rideinfo2_info4_label_3_main_main_default
style_rideinfo2_info4_label_3_main_main_default = lv.style_t()
style_rideinfo2_info4_label_3_main_main_default.init()
style_rideinfo2_info4_label_3_main_main_default.set_radius(0)
style_rideinfo2_info4_label_3_main_main_default.set_bg_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo2_info4_label_3_main_main_default.set_bg_grad_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo2_info4_label_3_main_main_default.set_bg_grad_dir(lv.GRAD_DIR.VER)
style_rideinfo2_info4_label_3_main_main_default.set_bg_opa(0)
style_rideinfo2_info4_label_3_main_main_default.set_text_color(lv.color_make(0x00,0x80,0xff))
try:
    style_rideinfo2_info4_label_3_main_main_default.set_text_font(lv.font_montserratMedium_20)
except AttributeError:
    try:
        style_rideinfo2_info4_label_3_main_main_default.set_text_font(lv.font_montserrat_20)
    except AttributeError:
        style_rideinfo2_info4_label_3_main_main_default.set_text_font(lv.font_montserrat_16)
style_rideinfo2_info4_label_3_main_main_default.set_text_letter_space(0)
style_rideinfo2_info4_label_3_main_main_default.set_pad_left(0)
style_rideinfo2_info4_label_3_main_main_default.set_pad_right(0)
style_rideinfo2_info4_label_3_main_main_default.set_pad_top(0)
style_rideinfo2_info4_label_3_main_main_default.set_pad_bottom(0)

# add style for RideInfo2_info4_label_3
RideInfo2_info4_label_3.add_style(style_rideinfo2_info4_label_3_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

RideInfo2_info1_label_4 = lv.label(RideInfo2)
RideInfo2_info1_label_4.set_pos(286,150)
RideInfo2_info1_label_4.set_size(30,32)
RideInfo2_info1_label_4.set_text("kcal")
RideInfo2_info1_label_4.set_long_mode(lv.label.LONG.WRAP)
RideInfo2_info1_label_4.set_style_text_align(lv.TEXT_ALIGN.LEFT, 0)
# create style style_rideinfo2_info1_label_4_main_main_default
style_rideinfo2_info1_label_4_main_main_default = lv.style_t()
style_rideinfo2_info1_label_4_main_main_default.init()
style_rideinfo2_info1_label_4_main_main_default.set_radius(0)
style_rideinfo2_info1_label_4_main_main_default.set_bg_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo2_info1_label_4_main_main_default.set_bg_grad_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo2_info1_label_4_main_main_default.set_bg_grad_dir(lv.GRAD_DIR.VER)
style_rideinfo2_info1_label_4_main_main_default.set_bg_opa(0)
style_rideinfo2_info1_label_4_main_main_default.set_text_color(lv.color_make(0x9e,0x9e,0x9e))
try:
    style_rideinfo2_info1_label_4_main_main_default.set_text_font(lv.font_montserratMedium_12)
except AttributeError:
    try:
        style_rideinfo2_info1_label_4_main_main_default.set_text_font(lv.font_montserrat_12)
    except AttributeError:
        style_rideinfo2_info1_label_4_main_main_default.set_text_font(lv.font_montserrat_16)
style_rideinfo2_info1_label_4_main_main_default.set_text_letter_space(0)
style_rideinfo2_info1_label_4_main_main_default.set_pad_left(0)
style_rideinfo2_info1_label_4_main_main_default.set_pad_right(0)
style_rideinfo2_info1_label_4_main_main_default.set_pad_top(0)
style_rideinfo2_info1_label_4_main_main_default.set_pad_bottom(0)

# add style for RideInfo2_info1_label_4
RideInfo2_info1_label_4.add_style(style_rideinfo2_info1_label_4_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

RideInfo2_info2_label_4 = lv.label(RideInfo2)
RideInfo2_info2_label_4.set_pos(402,150)
RideInfo2_info2_label_4.set_size(50,32)
RideInfo2_info2_label_4.set_text("BPM")
RideInfo2_info2_label_4.set_long_mode(lv.label.LONG.WRAP)
RideInfo2_info2_label_4.set_style_text_align(lv.TEXT_ALIGN.LEFT, 0)
# create style style_rideinfo2_info2_label_4_main_main_default
style_rideinfo2_info2_label_4_main_main_default = lv.style_t()
style_rideinfo2_info2_label_4_main_main_default.init()
style_rideinfo2_info2_label_4_main_main_default.set_radius(0)
style_rideinfo2_info2_label_4_main_main_default.set_bg_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo2_info2_label_4_main_main_default.set_bg_grad_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo2_info2_label_4_main_main_default.set_bg_grad_dir(lv.GRAD_DIR.VER)
style_rideinfo2_info2_label_4_main_main_default.set_bg_opa(0)
style_rideinfo2_info2_label_4_main_main_default.set_text_color(lv.color_make(0x9e,0x9e,0x9e))
try:
    style_rideinfo2_info2_label_4_main_main_default.set_text_font(lv.font_montserratMedium_12)
except AttributeError:
    try:
        style_rideinfo2_info2_label_4_main_main_default.set_text_font(lv.font_montserrat_12)
    except AttributeError:
        style_rideinfo2_info2_label_4_main_main_default.set_text_font(lv.font_montserrat_16)
style_rideinfo2_info2_label_4_main_main_default.set_text_letter_space(0)
style_rideinfo2_info2_label_4_main_main_default.set_pad_left(0)
style_rideinfo2_info2_label_4_main_main_default.set_pad_right(0)
style_rideinfo2_info2_label_4_main_main_default.set_pad_top(0)
style_rideinfo2_info2_label_4_main_main_default.set_pad_bottom(0)

# add style for RideInfo2_info2_label_4
RideInfo2_info2_label_4.add_style(style_rideinfo2_info2_label_4_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

RideInfo2_info3_label_4 = lv.label(RideInfo2)
RideInfo2_info3_label_4.set_pos(286,220)
RideInfo2_info3_label_4.set_size(32,32)
RideInfo2_info3_label_4.set_text("RPM")
RideInfo2_info3_label_4.set_long_mode(lv.label.LONG.WRAP)
RideInfo2_info3_label_4.set_style_text_align(lv.TEXT_ALIGN.LEFT, 0)
# create style style_rideinfo2_info3_label_4_main_main_default
style_rideinfo2_info3_label_4_main_main_default = lv.style_t()
style_rideinfo2_info3_label_4_main_main_default.init()
style_rideinfo2_info3_label_4_main_main_default.set_radius(0)
style_rideinfo2_info3_label_4_main_main_default.set_bg_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo2_info3_label_4_main_main_default.set_bg_grad_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo2_info3_label_4_main_main_default.set_bg_grad_dir(lv.GRAD_DIR.VER)
style_rideinfo2_info3_label_4_main_main_default.set_bg_opa(0)
style_rideinfo2_info3_label_4_main_main_default.set_text_color(lv.color_make(0x9e,0x9e,0x9e))
try:
    style_rideinfo2_info3_label_4_main_main_default.set_text_font(lv.font_montserratMedium_12)
except AttributeError:
    try:
        style_rideinfo2_info3_label_4_main_main_default.set_text_font(lv.font_montserrat_12)
    except AttributeError:
        style_rideinfo2_info3_label_4_main_main_default.set_text_font(lv.font_montserrat_16)
style_rideinfo2_info3_label_4_main_main_default.set_text_letter_space(0)
style_rideinfo2_info3_label_4_main_main_default.set_pad_left(0)
style_rideinfo2_info3_label_4_main_main_default.set_pad_right(0)
style_rideinfo2_info3_label_4_main_main_default.set_pad_top(0)
style_rideinfo2_info3_label_4_main_main_default.set_pad_bottom(0)

# add style for RideInfo2_info3_label_4
RideInfo2_info3_label_4.add_style(style_rideinfo2_info3_label_4_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

RideInfo2_info_img_v = lv.img(RideInfo2)
RideInfo2_info_img_v.set_pos(240,170)
RideInfo2_info_img_v.set_size(210,3)
RideInfo2_info_img_v.add_flag(lv.obj.FLAG.CLICKABLE)
try:
    with open('C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp1913112770.png','rb') as f:
        RideInfo2_info_img_v_img_data = f.read()
except:
    print('Could not open C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp1913112770.png')
    sys.exit()

RideInfo2_info_img_v_img = lv.img_dsc_t({
  'data_size': len(RideInfo2_info_img_v_img_data),
  'header': {'always_zero': 0, 'w': 210, 'h': 3, 'cf': lv.img.CF.TRUE_COLOR_ALPHA},
  'data': RideInfo2_info_img_v_img_data
})

RideInfo2_info_img_v.set_src(RideInfo2_info_img_v_img)
RideInfo2_info_img_v.set_pivot(0,0)
RideInfo2_info_img_v.set_angle(0)
# create style style_rideinfo2_info_img_v_main_main_default
style_rideinfo2_info_img_v_main_main_default = lv.style_t()
style_rideinfo2_info_img_v_main_main_default.init()
style_rideinfo2_info_img_v_main_main_default.set_img_recolor(lv.color_make(0xff,0xff,0xff))
style_rideinfo2_info_img_v_main_main_default.set_img_recolor_opa(0)
style_rideinfo2_info_img_v_main_main_default.set_img_opa(255)

# add style for RideInfo2_info_img_v
RideInfo2_info_img_v.add_style(style_rideinfo2_info_img_v_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

RideInfo2_info_img_h = lv.img(RideInfo2)
RideInfo2_info_img_h.set_pos(342,116)
RideInfo2_info_img_h.set_size(3,120)
RideInfo2_info_img_h.add_flag(lv.obj.FLAG.CLICKABLE)
try:
    with open('C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp729022314.png','rb') as f:
        RideInfo2_info_img_h_img_data = f.read()
except:
    print('Could not open C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp729022314.png')
    sys.exit()

RideInfo2_info_img_h_img = lv.img_dsc_t({
  'data_size': len(RideInfo2_info_img_h_img_data),
  'header': {'always_zero': 0, 'w': 3, 'h': 120, 'cf': lv.img.CF.TRUE_COLOR_ALPHA},
  'data': RideInfo2_info_img_h_img_data
})

RideInfo2_info_img_h.set_src(RideInfo2_info_img_h_img)
RideInfo2_info_img_h.set_pivot(0,0)
RideInfo2_info_img_h.set_angle(0)
# create style style_rideinfo2_info_img_h_main_main_default
style_rideinfo2_info_img_h_main_main_default = lv.style_t()
style_rideinfo2_info_img_h_main_main_default.init()
style_rideinfo2_info_img_h_main_main_default.set_img_recolor(lv.color_make(0xff,0xff,0xff))
style_rideinfo2_info_img_h_main_main_default.set_img_recolor_opa(0)
style_rideinfo2_info_img_h_main_main_default.set_img_opa(255)

# add style for RideInfo2_info_img_h
RideInfo2_info_img_h.add_style(style_rideinfo2_info_img_h_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

RideInfo2_gauge_bg_img = lv.img(RideInfo2)
RideInfo2_gauge_bg_img.set_pos(5,25)
RideInfo2_gauge_bg_img.set_size(233,234)
RideInfo2_gauge_bg_img.add_flag(lv.obj.FLAG.CLICKABLE)
try:
    with open('C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp-1651174002.png','rb') as f:
        RideInfo2_gauge_bg_img_img_data = f.read()
except:
    print('Could not open C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp-1651174002.png')
    sys.exit()

RideInfo2_gauge_bg_img_img = lv.img_dsc_t({
  'data_size': len(RideInfo2_gauge_bg_img_img_data),
  'header': {'always_zero': 0, 'w': 233, 'h': 234, 'cf': lv.img.CF.TRUE_COLOR_ALPHA},
  'data': RideInfo2_gauge_bg_img_img_data
})

RideInfo2_gauge_bg_img.set_src(RideInfo2_gauge_bg_img_img)
RideInfo2_gauge_bg_img.set_pivot(0,0)
RideInfo2_gauge_bg_img.set_angle(0)
# create style style_rideinfo2_gauge_bg_img_main_main_default
style_rideinfo2_gauge_bg_img_main_main_default = lv.style_t()
style_rideinfo2_gauge_bg_img_main_main_default.init()
style_rideinfo2_gauge_bg_img_main_main_default.set_img_recolor(lv.color_make(0xff,0xff,0xff))
style_rideinfo2_gauge_bg_img_main_main_default.set_img_recolor_opa(0)
style_rideinfo2_gauge_bg_img_main_main_default.set_img_opa(255)

# add style for RideInfo2_gauge_bg_img
RideInfo2_gauge_bg_img.add_style(style_rideinfo2_gauge_bg_img_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

RideInfo2_battery_line_img = lv.img(RideInfo2)
RideInfo2_battery_line_img.set_pos(5,139)
RideInfo2_battery_line_img.set_size(237,120)
RideInfo2_battery_line_img.add_flag(lv.obj.FLAG.CLICKABLE)
try:
    with open('C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp-2064831353.png','rb') as f:
        RideInfo2_battery_line_img_img_data = f.read()
except:
    print('Could not open C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp-2064831353.png')
    sys.exit()

RideInfo2_battery_line_img_img = lv.img_dsc_t({
  'data_size': len(RideInfo2_battery_line_img_img_data),
  'header': {'always_zero': 0, 'w': 237, 'h': 120, 'cf': lv.img.CF.TRUE_COLOR_ALPHA},
  'data': RideInfo2_battery_line_img_img_data
})

RideInfo2_battery_line_img.set_src(RideInfo2_battery_line_img_img)
RideInfo2_battery_line_img.set_pivot(0,0)
RideInfo2_battery_line_img.set_angle(0)
# create style style_rideinfo2_battery_line_img_main_main_default
style_rideinfo2_battery_line_img_main_main_default = lv.style_t()
style_rideinfo2_battery_line_img_main_main_default.init()
style_rideinfo2_battery_line_img_main_main_default.set_img_recolor(lv.color_make(0xff,0xff,0xff))
style_rideinfo2_battery_line_img_main_main_default.set_img_recolor_opa(0)
style_rideinfo2_battery_line_img_main_main_default.set_img_opa(255)

# add style for RideInfo2_battery_line_img
RideInfo2_battery_line_img.add_style(style_rideinfo2_battery_line_img_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

RideInfo2_battery_icon = lv.img(RideInfo2)
RideInfo2_battery_icon.set_pos(110,200)
RideInfo2_battery_icon.set_size(15,12)
RideInfo2_battery_icon.add_flag(lv.obj.FLAG.CLICKABLE)
try:
    with open('C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp-2052837718.png','rb') as f:
        RideInfo2_battery_icon_img_data = f.read()
except:
    print('Could not open C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp-2052837718.png')
    sys.exit()

RideInfo2_battery_icon_img = lv.img_dsc_t({
  'data_size': len(RideInfo2_battery_icon_img_data),
  'header': {'always_zero': 0, 'w': 15, 'h': 12, 'cf': lv.img.CF.TRUE_COLOR_ALPHA},
  'data': RideInfo2_battery_icon_img_data
})

RideInfo2_battery_icon.set_src(RideInfo2_battery_icon_img)
RideInfo2_battery_icon.set_pivot(0,0)
RideInfo2_battery_icon.set_angle(0)
# create style style_rideinfo2_battery_icon_main_main_default
style_rideinfo2_battery_icon_main_main_default = lv.style_t()
style_rideinfo2_battery_icon_main_main_default.init()
style_rideinfo2_battery_icon_main_main_default.set_img_recolor(lv.color_make(0xff,0xff,0xff))
style_rideinfo2_battery_icon_main_main_default.set_img_recolor_opa(0)
style_rideinfo2_battery_icon_main_main_default.set_img_opa(255)

# add style for RideInfo2_battery_icon
RideInfo2_battery_icon.add_style(style_rideinfo2_battery_icon_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

RideInfo2_battery_label = lv.label(RideInfo2)
RideInfo2_battery_label.set_pos(130,200)
RideInfo2_battery_label.set_size(50,32)
RideInfo2_battery_label.set_text("56%")
RideInfo2_battery_label.set_long_mode(lv.label.LONG.WRAP)
RideInfo2_battery_label.set_style_text_align(lv.TEXT_ALIGN.LEFT, 0)
# create style style_rideinfo2_battery_label_main_main_default
style_rideinfo2_battery_label_main_main_default = lv.style_t()
style_rideinfo2_battery_label_main_main_default.init()
style_rideinfo2_battery_label_main_main_default.set_radius(0)
style_rideinfo2_battery_label_main_main_default.set_bg_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo2_battery_label_main_main_default.set_bg_grad_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo2_battery_label_main_main_default.set_bg_grad_dir(lv.GRAD_DIR.VER)
style_rideinfo2_battery_label_main_main_default.set_bg_opa(0)
style_rideinfo2_battery_label_main_main_default.set_text_color(lv.color_make(0x00,0x80,0xff))
try:
    style_rideinfo2_battery_label_main_main_default.set_text_font(lv.font_montserratMedium_12)
except AttributeError:
    try:
        style_rideinfo2_battery_label_main_main_default.set_text_font(lv.font_montserrat_12)
    except AttributeError:
        style_rideinfo2_battery_label_main_main_default.set_text_font(lv.font_montserrat_16)
style_rideinfo2_battery_label_main_main_default.set_text_letter_space(0)
style_rideinfo2_battery_label_main_main_default.set_pad_left(0)
style_rideinfo2_battery_label_main_main_default.set_pad_right(0)
style_rideinfo2_battery_label_main_main_default.set_pad_top(0)
style_rideinfo2_battery_label_main_main_default.set_pad_bottom(0)

# add style for RideInfo2_battery_label
RideInfo2_battery_label.add_style(style_rideinfo2_battery_label_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

RideInfo2_battery_arc = lv.arc(RideInfo2)
RideInfo2_battery_arc.set_pos(25,38)
RideInfo2_battery_arc.set_size(200,200)
RideInfo2_battery_arc.set_bg_angles(85, 130)
RideInfo2_battery_arc.set_angles(85, 130)
RideInfo2_battery_arc.set_rotation(0)
RideInfo2_battery_arc.set_style_pad_top(0, lv.PART.MAIN | lv.STATE.DEFAULT)
RideInfo2_battery_arc.set_style_pad_bottom(0, lv.PART.MAIN | lv.STATE.DEFAULT)
RideInfo2_battery_arc.set_style_pad_left(0, lv.PART.MAIN | lv.STATE.DEFAULT)
RideInfo2_battery_arc.set_style_pad_right(0, lv.PART.MAIN | lv.STATE.DEFAULT)
# create style style_rideinfo2_battery_arc_main_main_default
style_rideinfo2_battery_arc_main_main_default = lv.style_t()
style_rideinfo2_battery_arc_main_main_default.init()
style_rideinfo2_battery_arc_main_main_default.set_bg_color(lv.color_make(0x09,0x80,0xff))
style_rideinfo2_battery_arc_main_main_default.set_bg_grad_color(lv.color_make(0x00,0x80,0xff))
style_rideinfo2_battery_arc_main_main_default.set_bg_grad_dir(lv.GRAD_DIR.VER)
style_rideinfo2_battery_arc_main_main_default.set_bg_opa(0)
style_rideinfo2_battery_arc_main_main_default.set_border_width(0)
style_rideinfo2_battery_arc_main_main_default.set_arc_color(lv.color_make(0x00,0x80,0xff))
style_rideinfo2_battery_arc_main_main_default.set_arc_width(5)

# add style for RideInfo2_battery_arc
RideInfo2_battery_arc.add_style(style_rideinfo2_battery_arc_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

# create style style_rideinfo2_battery_arc_main_indicator_default
style_rideinfo2_battery_arc_main_indicator_default = lv.style_t()
style_rideinfo2_battery_arc_main_indicator_default.init()
style_rideinfo2_battery_arc_main_indicator_default.set_arc_color(lv.color_make(0x21,0x95,0xf6))
style_rideinfo2_battery_arc_main_indicator_default.set_arc_width(5)

# add style for RideInfo2_battery_arc
RideInfo2_battery_arc.add_style(style_rideinfo2_battery_arc_main_indicator_default, lv.PART.INDICATOR|lv.STATE.DEFAULT)

# create style style_rideinfo2_battery_arc_main_knob_default
style_rideinfo2_battery_arc_main_knob_default = lv.style_t()
style_rideinfo2_battery_arc_main_knob_default.init()
style_rideinfo2_battery_arc_main_knob_default.set_bg_color(lv.color_make(0x00,0x80,0xff))
style_rideinfo2_battery_arc_main_knob_default.set_bg_grad_color(lv.color_make(0x00,0x80,0xff))
style_rideinfo2_battery_arc_main_knob_default.set_bg_grad_dir(lv.GRAD_DIR.VER)
style_rideinfo2_battery_arc_main_knob_default.set_bg_opa(0)
style_rideinfo2_battery_arc_main_knob_default.set_pad_all(5)

# add style for RideInfo2_battery_arc
RideInfo2_battery_arc.add_style(style_rideinfo2_battery_arc_main_knob_default, lv.PART.KNOB|lv.STATE.DEFAULT)

RideInfo2_footer_bg_img = lv.img(RideInfo2)
RideInfo2_footer_bg_img.set_pos(0,237)
RideInfo2_footer_bg_img.set_size(480,35)
RideInfo2_footer_bg_img.add_flag(lv.obj.FLAG.CLICKABLE)
try:
    with open('C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp-1226003919.png','rb') as f:
        RideInfo2_footer_bg_img_img_data = f.read()
except:
    print('Could not open C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp-1226003919.png')
    sys.exit()

RideInfo2_footer_bg_img_img = lv.img_dsc_t({
  'data_size': len(RideInfo2_footer_bg_img_img_data),
  'header': {'always_zero': 0, 'w': 480, 'h': 35, 'cf': lv.img.CF.TRUE_COLOR_ALPHA},
  'data': RideInfo2_footer_bg_img_img_data
})

RideInfo2_footer_bg_img.set_src(RideInfo2_footer_bg_img_img)
RideInfo2_footer_bg_img.set_pivot(0,0)
RideInfo2_footer_bg_img.set_angle(0)
# create style style_rideinfo2_footer_bg_img_main_main_default
style_rideinfo2_footer_bg_img_main_main_default = lv.style_t()
style_rideinfo2_footer_bg_img_main_main_default.init()
style_rideinfo2_footer_bg_img_main_main_default.set_img_recolor(lv.color_make(0xff,0xff,0xff))
style_rideinfo2_footer_bg_img_main_main_default.set_img_recolor_opa(0)
style_rideinfo2_footer_bg_img_main_main_default.set_img_opa(255)

# add style for RideInfo2_footer_bg_img
RideInfo2_footer_bg_img.add_style(style_rideinfo2_footer_bg_img_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

RideInfo2_footer_line_1 = lv.img(RideInfo2)
RideInfo2_footer_line_1.set_pos(190,260)
RideInfo2_footer_line_1.set_size(22,4)
RideInfo2_footer_line_1.add_flag(lv.obj.FLAG.CLICKABLE)
try:
    with open('C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp-339601803.png','rb') as f:
        RideInfo2_footer_line_1_img_data = f.read()
except:
    print('Could not open C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp-339601803.png')
    sys.exit()

RideInfo2_footer_line_1_img = lv.img_dsc_t({
  'data_size': len(RideInfo2_footer_line_1_img_data),
  'header': {'always_zero': 0, 'w': 22, 'h': 4, 'cf': lv.img.CF.TRUE_COLOR_ALPHA},
  'data': RideInfo2_footer_line_1_img_data
})

RideInfo2_footer_line_1.set_src(RideInfo2_footer_line_1_img)
RideInfo2_footer_line_1.set_pivot(0,0)
RideInfo2_footer_line_1.set_angle(0)
# create style style_rideinfo2_footer_line_1_main_main_default
style_rideinfo2_footer_line_1_main_main_default = lv.style_t()
style_rideinfo2_footer_line_1_main_main_default.init()
style_rideinfo2_footer_line_1_main_main_default.set_img_recolor(lv.color_make(0xff,0xff,0xff))
style_rideinfo2_footer_line_1_main_main_default.set_img_recolor_opa(0)
style_rideinfo2_footer_line_1_main_main_default.set_img_opa(255)

# add style for RideInfo2_footer_line_1
RideInfo2_footer_line_1.add_style(style_rideinfo2_footer_line_1_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

RideInfo2_footer_line_2 = lv.img(RideInfo2)
RideInfo2_footer_line_2.set_pos(230,260)
RideInfo2_footer_line_2.set_size(22,4)
RideInfo2_footer_line_2.add_flag(lv.obj.FLAG.CLICKABLE)
try:
    with open('C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp-339601803.png','rb') as f:
        RideInfo2_footer_line_2_img_data = f.read()
except:
    print('Could not open C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp-339601803.png')
    sys.exit()

RideInfo2_footer_line_2_img = lv.img_dsc_t({
  'data_size': len(RideInfo2_footer_line_2_img_data),
  'header': {'always_zero': 0, 'w': 22, 'h': 4, 'cf': lv.img.CF.TRUE_COLOR_ALPHA},
  'data': RideInfo2_footer_line_2_img_data
})

RideInfo2_footer_line_2.set_src(RideInfo2_footer_line_2_img)
RideInfo2_footer_line_2.set_pivot(0,0)
RideInfo2_footer_line_2.set_angle(0)
# create style style_rideinfo2_footer_line_2_main_main_default
style_rideinfo2_footer_line_2_main_main_default = lv.style_t()
style_rideinfo2_footer_line_2_main_main_default.init()
style_rideinfo2_footer_line_2_main_main_default.set_img_recolor(lv.color_make(0xff,0xff,0xff))
style_rideinfo2_footer_line_2_main_main_default.set_img_recolor_opa(0)
style_rideinfo2_footer_line_2_main_main_default.set_img_opa(255)

# add style for RideInfo2_footer_line_2
RideInfo2_footer_line_2.add_style(style_rideinfo2_footer_line_2_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

RideInfo2_footer_line_3 = lv.img(RideInfo2)
RideInfo2_footer_line_3.set_pos(270,260)
RideInfo2_footer_line_3.set_size(22,4)
RideInfo2_footer_line_3.add_flag(lv.obj.FLAG.CLICKABLE)
try:
    with open('C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp-272595050.png','rb') as f:
        RideInfo2_footer_line_3_img_data = f.read()
except:
    print('Could not open C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp-272595050.png')
    sys.exit()

RideInfo2_footer_line_3_img = lv.img_dsc_t({
  'data_size': len(RideInfo2_footer_line_3_img_data),
  'header': {'always_zero': 0, 'w': 22, 'h': 4, 'cf': lv.img.CF.TRUE_COLOR_ALPHA},
  'data': RideInfo2_footer_line_3_img_data
})

RideInfo2_footer_line_3.set_src(RideInfo2_footer_line_3_img)
RideInfo2_footer_line_3.set_pivot(0,0)
RideInfo2_footer_line_3.set_angle(0)
# create style style_rideinfo2_footer_line_3_main_main_default
style_rideinfo2_footer_line_3_main_main_default = lv.style_t()
style_rideinfo2_footer_line_3_main_main_default.init()
style_rideinfo2_footer_line_3_main_main_default.set_img_recolor(lv.color_make(0xff,0xff,0xff))
style_rideinfo2_footer_line_3_main_main_default.set_img_recolor_opa(0)
style_rideinfo2_footer_line_3_main_main_default.set_img_opa(255)

# add style for RideInfo2_footer_line_3
RideInfo2_footer_line_3.add_style(style_rideinfo2_footer_line_3_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

RideInfo2_watts_label_1 = lv.label(RideInfo2)
RideInfo2_watts_label_1.set_pos(100,65)
RideInfo2_watts_label_1.set_size(50,40)
RideInfo2_watts_label_1.set_text("15.7")
RideInfo2_watts_label_1.set_long_mode(lv.label.LONG.WRAP)
RideInfo2_watts_label_1.set_style_text_align(lv.TEXT_ALIGN.LEFT, 0)
# create style style_rideinfo2_watts_label_1_main_main_default
style_rideinfo2_watts_label_1_main_main_default = lv.style_t()
style_rideinfo2_watts_label_1_main_main_default.init()
style_rideinfo2_watts_label_1_main_main_default.set_radius(0)
style_rideinfo2_watts_label_1_main_main_default.set_bg_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo2_watts_label_1_main_main_default.set_bg_grad_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo2_watts_label_1_main_main_default.set_bg_grad_dir(lv.GRAD_DIR.VER)
style_rideinfo2_watts_label_1_main_main_default.set_bg_opa(0)
style_rideinfo2_watts_label_1_main_main_default.set_text_color(lv.color_make(0x00,0x80,0xff))
try:
    style_rideinfo2_watts_label_1_main_main_default.set_text_font(lv.font_montserratMedium_20)
except AttributeError:
    try:
        style_rideinfo2_watts_label_1_main_main_default.set_text_font(lv.font_montserrat_20)
    except AttributeError:
        style_rideinfo2_watts_label_1_main_main_default.set_text_font(lv.font_montserrat_16)
style_rideinfo2_watts_label_1_main_main_default.set_text_letter_space(0)
style_rideinfo2_watts_label_1_main_main_default.set_pad_left(0)
style_rideinfo2_watts_label_1_main_main_default.set_pad_right(0)
style_rideinfo2_watts_label_1_main_main_default.set_pad_top(0)
style_rideinfo2_watts_label_1_main_main_default.set_pad_bottom(0)

# add style for RideInfo2_watts_label_1
RideInfo2_watts_label_1.add_style(style_rideinfo2_watts_label_1_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

RideInfo2_watts_label_2 = lv.label(RideInfo2)
RideInfo2_watts_label_2.set_pos(100,86)
RideInfo2_watts_label_2.set_size(80,32)
RideInfo2_watts_label_2.set_text("Watts")
RideInfo2_watts_label_2.set_long_mode(lv.label.LONG.WRAP)
RideInfo2_watts_label_2.set_style_text_align(lv.TEXT_ALIGN.LEFT, 0)
# create style style_rideinfo2_watts_label_2_main_main_default
style_rideinfo2_watts_label_2_main_main_default = lv.style_t()
style_rideinfo2_watts_label_2_main_main_default.init()
style_rideinfo2_watts_label_2_main_main_default.set_radius(0)
style_rideinfo2_watts_label_2_main_main_default.set_bg_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo2_watts_label_2_main_main_default.set_bg_grad_color(lv.color_make(0xff,0xff,0xff))
style_rideinfo2_watts_label_2_main_main_default.set_bg_grad_dir(lv.GRAD_DIR.VER)
style_rideinfo2_watts_label_2_main_main_default.set_bg_opa(0)
style_rideinfo2_watts_label_2_main_main_default.set_text_color(lv.color_make(0x9e,0x9e,0x9e))
try:
    style_rideinfo2_watts_label_2_main_main_default.set_text_font(lv.font_montserratMedium_12)
except AttributeError:
    try:
        style_rideinfo2_watts_label_2_main_main_default.set_text_font(lv.font_montserrat_12)
    except AttributeError:
        style_rideinfo2_watts_label_2_main_main_default.set_text_font(lv.font_montserrat_16)
style_rideinfo2_watts_label_2_main_main_default.set_text_letter_space(0)
style_rideinfo2_watts_label_2_main_main_default.set_pad_left(0)
style_rideinfo2_watts_label_2_main_main_default.set_pad_right(0)
style_rideinfo2_watts_label_2_main_main_default.set_pad_top(0)
style_rideinfo2_watts_label_2_main_main_default.set_pad_bottom(0)

# add style for RideInfo2_watts_label_2
RideInfo2_watts_label_2.add_style(style_rideinfo2_watts_label_2_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

RideInfo2_watts_img = lv.img(RideInfo2)
RideInfo2_watts_img.set_pos(31,112)
RideInfo2_watts_img.set_size(182,75)
RideInfo2_watts_img.add_flag(lv.obj.FLAG.CLICKABLE)
try:
    with open('C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp693463635.png','rb') as f:
        RideInfo2_watts_img_img_data = f.read()
except:
    print('Could not open C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp693463635.png')
    sys.exit()

RideInfo2_watts_img_img = lv.img_dsc_t({
  'data_size': len(RideInfo2_watts_img_img_data),
  'header': {'always_zero': 0, 'w': 182, 'h': 75, 'cf': lv.img.CF.TRUE_COLOR_ALPHA},
  'data': RideInfo2_watts_img_img_data
})

RideInfo2_watts_img.set_src(RideInfo2_watts_img_img)
RideInfo2_watts_img.set_pivot(0,0)
RideInfo2_watts_img.set_angle(0)
# create style style_rideinfo2_watts_img_main_main_default
style_rideinfo2_watts_img_main_main_default = lv.style_t()
style_rideinfo2_watts_img_main_main_default.init()
style_rideinfo2_watts_img_main_main_default.set_img_recolor(lv.color_make(0xff,0xff,0xff))
style_rideinfo2_watts_img_main_main_default.set_img_recolor_opa(0)
style_rideinfo2_watts_img_main_main_default.set_img_opa(255)

# add style for RideInfo2_watts_img
RideInfo2_watts_img.add_style(style_rideinfo2_watts_img_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

RideInfo2_cover_imgbtn = lv.imgbtn(RideInfo2)
RideInfo2_cover_imgbtn.set_pos(0,0)
RideInfo2_cover_imgbtn.set_size(480,272)
try:
    with open('C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp1436734276.png','rb') as f:
        RideInfo2_cover_imgbtn_imgReleased_data = f.read()
except:
    print('Could not open C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp1436734276.png')
    sys.exit()

RideInfo2_cover_imgbtn_imgReleased = lv.img_dsc_t({
  'data_size': len(RideInfo2_cover_imgbtn_imgReleased_data),
  'header': {'always_zero': 0, 'w': 480, 'h': 272, 'cf': lv.img.CF.TRUE_COLOR_ALPHA},
  'data': RideInfo2_cover_imgbtn_imgReleased_data
})
RideInfo2_cover_imgbtn.set_src(lv.imgbtn.STATE.RELEASED, RideInfo2_cover_imgbtn_imgReleased, None, None)

try:
    with open('C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp1436734276.png','rb') as f:
        RideInfo2_cover_imgbtn_imgPressed_data = f.read()
except:
    print('Could not open C:\\Users\\nxa13700\\Documents\\MCUXpressoIDE_11.5.0_7232\\workspace\\evkmimxrt1060_ebike_lvgl8\\ebike_demo_gg\\generated\\mPythonImages\\mp1436734276.png')
    sys.exit()

RideInfo2_cover_imgbtn_imgPressed = lv.img_dsc_t({
  'data_size': len(RideInfo2_cover_imgbtn_imgPressed_data),
  'header': {'always_zero': 0, 'w': 480, 'h': 272, 'cf': lv.img.CF.TRUE_COLOR_ALPHA},
  'data': RideInfo2_cover_imgbtn_imgPressed_data
})
RideInfo2_cover_imgbtn.set_src(lv.imgbtn.STATE.PRESSED, RideInfo2_cover_imgbtn_imgPressed, None, None)




# create style style_rideinfo2_cover_imgbtn_main_main_default
style_rideinfo2_cover_imgbtn_main_main_default = lv.style_t()
style_rideinfo2_cover_imgbtn_main_main_default.init()
style_rideinfo2_cover_imgbtn_main_main_default.set_text_color(lv.color_make(0x00,0x00,0x00))
try:
    style_rideinfo2_cover_imgbtn_main_main_default.set_text_font(lv.font_simsun_12)
except AttributeError:
    try:
        style_rideinfo2_cover_imgbtn_main_main_default.set_text_font(lv.font_montserrat_12)
    except AttributeError:
        style_rideinfo2_cover_imgbtn_main_main_default.set_text_font(lv.font_montserrat_16)
style_rideinfo2_cover_imgbtn_main_main_default.set_img_recolor(lv.color_make(0xff,0xff,0xff))
style_rideinfo2_cover_imgbtn_main_main_default.set_img_recolor_opa(0)
style_rideinfo2_cover_imgbtn_main_main_default.set_img_opa(0)

# add style for RideInfo2_cover_imgbtn
RideInfo2_cover_imgbtn.add_style(style_rideinfo2_cover_imgbtn_main_main_default, lv.PART.MAIN|lv.STATE.DEFAULT)

# create style style_rideinfo2_cover_imgbtn_main_main_pressed
style_rideinfo2_cover_imgbtn_main_main_pressed = lv.style_t()
style_rideinfo2_cover_imgbtn_main_main_pressed.init()
style_rideinfo2_cover_imgbtn_main_main_pressed.set_text_color(lv.color_make(0xFF,0x33,0xFF))
try:
    style_rideinfo2_cover_imgbtn_main_main_pressed.set_text_font(lv.font_simsun_16)
except AttributeError:
    try:
        style_rideinfo2_cover_imgbtn_main_main_pressed.set_text_font(lv.font_montserrat_16)
    except AttributeError:
        style_rideinfo2_cover_imgbtn_main_main_pressed.set_text_font(lv.font_montserrat_16)
style_rideinfo2_cover_imgbtn_main_main_pressed.set_img_recolor(lv.color_make(0x00,0x00,0x00))
style_rideinfo2_cover_imgbtn_main_main_pressed.set_img_recolor_opa(0)

# add style for RideInfo2_cover_imgbtn
RideInfo2_cover_imgbtn.add_style(style_rideinfo2_cover_imgbtn_main_main_pressed, lv.PART.MAIN|lv.STATE.PRESSED)

# create style style_rideinfo2_cover_imgbtn_main_main_checked
style_rideinfo2_cover_imgbtn_main_main_checked = lv.style_t()
style_rideinfo2_cover_imgbtn_main_main_checked.init()
style_rideinfo2_cover_imgbtn_main_main_checked.set_text_color(lv.color_make(0xFF,0x33,0xFF))
try:
    style_rideinfo2_cover_imgbtn_main_main_checked.set_text_font(lv.font_simsun_16)
except AttributeError:
    try:
        style_rideinfo2_cover_imgbtn_main_main_checked.set_text_font(lv.font_montserrat_16)
    except AttributeError:
        style_rideinfo2_cover_imgbtn_main_main_checked.set_text_font(lv.font_montserrat_16)
style_rideinfo2_cover_imgbtn_main_main_checked.set_img_recolor(lv.color_make(0x00,0x00,0x00))
style_rideinfo2_cover_imgbtn_main_main_checked.set_img_recolor_opa(0)

# add style for RideInfo2_cover_imgbtn
RideInfo2_cover_imgbtn.add_style(style_rideinfo2_cover_imgbtn_main_main_checked, lv.PART.MAIN|lv.STATE.CHECKED)



def RideInfo2_cover_imgbtn_clicked_1_event_cb(e,Overview):
    src = e.get_target()
    code = e.get_code()
    lv.scr_load_anim(Overview, lv.SCR_LOAD_ANIM.MOVE_LEFT, 1, 0, False)
RideInfo2_cover_imgbtn.add_event_cb(lambda e: RideInfo2_cover_imgbtn_clicked_1_event_cb(e,Overview), lv.EVENT.CLICKED, None)


def RideInfo1_cover_imgbtn_clicked_1_event_cb(e,RideInfo2):
    src = e.get_target()
    code = e.get_code()
    lv.scr_load_anim(RideInfo2, lv.SCR_LOAD_ANIM.MOVE_LEFT, 1, 0, False)
RideInfo1_cover_imgbtn.add_event_cb(lambda e: RideInfo1_cover_imgbtn_clicked_1_event_cb(e,RideInfo2), lv.EVENT.CLICKED, None)


def Overview_cover_imgbtn_clicked_1_event_cb(e,RideInfo1):
    src = e.get_target()
    code = e.get_code()
    lv.scr_load_anim(RideInfo1, lv.SCR_LOAD_ANIM.MOVE_LEFT, 1, 0, False)
Overview_cover_imgbtn.add_event_cb(lambda e: Overview_cover_imgbtn_clicked_1_event_cb(e,RideInfo1), lv.EVENT.CLICKED, None)



# content from custom.py

# Load the default screen
lv.scr_load(Overview)

while SDL.check():
    time.sleep_ms(5)
