/*
** ###################################################################
**     Processors:          MIMXRT685SFAWBR_dsp
**                          MIMXRT685SFFOB_dsp
**                          MIMXRT685SFVKB_dsp
**
**     Compiler:            XCC Compiler
**     Reference manual:    MIMXRT685 User manual Rev. 0.95 11 November 2019
**     Version:             rev. 2.0, 2019-11-12
**     Build:               b220401
**
**     Abstract:
**         Peripheral Access Layer for MIMXRT685S_dsp
**
**     Copyright 1997-2016 Freescale Semiconductor, Inc.
**     Copyright 2016-2022 NXP
**     All rights reserved.
**
**     SPDX-License-Identifier: BSD-3-Clause
**
**     http:                 www.nxp.com
**     mail:                 support@nxp.com
**
**     Revisions:
**     - rev. 1.0 (2018-06-19)
**         Initial version.
**     - rev. 2.0 (2019-11-12)
**         Base on rev 0.95 RM (B0 Header)
**
** ###################################################################
*/

/*!
 * @file MIMXRT685S_dsp.h
 * @version 2.0
 * @date 2019-11-12
 * @brief Peripheral Access Layer for MIMXRT685S_dsp
 *
 * Peripheral Access Layer for MIMXRT685S_dsp
 */

#ifndef _MIMXRT685S_DSP_H_
#define _MIMXRT685S_DSP_H_                       /**< Symbol preventing repeated inclusion */

/** Memory map major version (memory maps with equal major version number are
 * compatible) */
#define MCU_MEM_MAP_VERSION 0x0200U
/** Memory map minor version */
#define MCU_MEM_MAP_VERSION_MINOR 0x0000U

/* ----------------------------------------------------------------------------
   --
   ---------------------------------------------------------------------------- */

/* IO definitions (access restrictions to peripheral registers) */
/**
    \defgroup CMSIS_glob_defs CMSIS Global Defines
    <strong>IO Type Qualifiers</strong> are used
    \li to specify the access to peripheral variables.
    \li for automatic generation of peripheral register debug information.
*/
#define     __I     volatile const       /*!< Defines 'read only' permissions */
#define     __O     volatile             /*!< Defines 'write only' permissions */
#define     __IO    volatile             /*!< Defines 'read / write' permissions */

/* following defines should be used for structure members */
#define     __IM     volatile const      /*! Defines 'read only' structure member permissions */
#define     __OM     volatile            /*! Defines 'write only' structure member permissions */
#define     __IOM    volatile            /*! Defines 'read / write' structure member permissions */

#define __STATIC_INLINE static inline

#define __BKPT(value) do {} while(0)
#define __NOP() do {} while(0)

#include "system_MIMXRT685S_dsp.h"     /* Device specific configuration file */



/* ----------------------------------------------------------------------------
   -- Interrupt vector numbers
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup Interrupt_vector_numbers Interrupt vector numbers
 * @{
 */

/** Interrupt Number Definitions */
#define NUMBER_OF_INT_VECTORS 67                 /**< Number of interrupts in the Vector table */

typedef enum IRQn {
  /* Auxiliary constants */
  NotAvail_IRQn                = -128,             /**< Not available device specific interrupt */

  /* Core interrupts */
  NonMaskableInt_IRQn          = 0,                /**< SysIRQ, Non Maskable Interrupt */
  Software_IRQn                = 1,                /**< Software triggered Interrupt */
  RtosTimer0_IRQn              = 2,                /**< Internal RTOS Timer0 Interrupt */
  RtosTimer1_IRQn              = 3,                /**< Internal RTOS Timer1 Interrupt */
  Profiling_IRQn               = 4,                /**< Profiling Interrupt */

  /* Device specific interrupts */
  DSP_INT0_SEL0_IRQn           = 5,                /**< Interrupt selected by DSP_INT0_SEL0 */
  DSP_INT0_SEL1_IRQn           = 6,                /**< Interrupt selected by DSP_INT0_SEL1 */
  DSP_INT0_SEL2_IRQn           = 7,                /**< Interrupt selected by DSP_INT0_SEL2 */
  DSP_INT0_SEL3_IRQn           = 8,                /**< Interrupt selected by DSP_INT0_SEL3 */
  DSP_INT0_SEL4_IRQn           = 9,                /**< Interrupt selected by DSP_INT0_SEL4 */
  DSP_INT0_SEL5_IRQn           = 10,               /**< Interrupt selected by DSP_INT0_SEL5 */
  DSP_INT0_SEL6_IRQn           = 11,               /**< Interrupt selected by DSP_INT0_SEL6 */
  DSP_INT0_SEL7_IRQn           = 12,               /**< Interrupt selected by DSP_INT0_SEL7 */
  DSP_INT0_SEL8_IRQn           = 13,               /**< Interrupt selected by DSP_INT0_SEL8 */
  DSP_INT0_SEL9_IRQn           = 14,               /**< Interrupt selected by DSP_INT0_SEL9 */
  DSP_INT0_SEL10_IRQn          = 15,               /**< Interrupt selected by DSP_INT0_SEL10 */
  DSP_INT0_SEL11_IRQn          = 16,               /**< Interrupt selected by DSP_INT0_SEL11 */
  DSP_INT0_SEL12_IRQn          = 17,               /**< Interrupt selected by DSP_INT0_SEL12 */
  DSP_INT0_SEL13_IRQn          = 18,               /**< Interrupt selected by DSP_INT0_SEL13 */
  DSP_INT0_SEL14_IRQn          = 19,               /**< Interrupt selected by DSP_INT0_SEL14 */
  DSP_INT0_SEL15_IRQn          = 20,               /**< Interrupt selected by DSP_INT0_SEL15 */
  DSP_INT0_SEL16_IRQn          = 21,               /**< Interrupt selected by DSP_INT0_SEL16 */
  DSP_INT0_SEL17_IRQn          = 22,               /**< Interrupt selected by DSP_INT0_SEL17 */
  DSP_INT0_SEL18_IRQn          = 23,               /**< Interrupt selected by DSP_INT0_SEL18 */
  DSP_INT0_SEL19_IRQn          = 24,               /**< Interrupt selected by DSP_INT0_SEL19 */
  DSP_INT0_SEL20_IRQn          = 25,               /**< Interrupt selected by DSP_INT0_SEL20 */
  DSP_INT0_SEL21_IRQn          = 26,               /**< Interrupt selected by DSP_INT0_SEL21 */
  DSP_INT0_SEL22_IRQn          = 27,               /**< Interrupt selected by DSP_INT0_SEL22 */
  DSP_INT0_SEL23_IRQn          = 28,               /**< Interrupt selected by DSP_INT0_SEL23 */
  DSP_INT0_SEL24_IRQn          = 29,               /**< Interrupt selected by DSP_INT0_SEL24 */
  DSP_INT0_SEL25_IRQn          = 30,               /**< Interrupt selected by DSP_INT0_SEL25 */
  DSP_INT0_SEL26_IRQn          = 31,               /**< Interrupt selected by DSP_INT0_SEL26 */
  FLEXCOMM0_IRQn               = 32,               /**< Flexcomm Interface 0 (USART, SPI, I2C, I2S)(DSP_INT_SELn source IRQ0) */
  FLEXCOMM1_IRQn               = 33,               /**< Flexcomm Interface 1 (USART, SPI, I2C, I2S)(DSP_INT_SELn source IRQ1) */
  FLEXCOMM2_IRQn               = 34,               /**< Flexcomm Interface 2 (USART, SPI, I2C, I2S)(DSP_INT_SELn source IRQ2) */
  FLEXCOMM3_IRQn               = 35,               /**< Flexcomm Interface 3 (USART, SPI, I2C, I2S)(DSP_INT_SELn source IRQ3) */
  FLEXCOMM4_IRQn               = 36,               /**< Flexcomm Interface 4 (USART, SPI, I2C, I2S)(DSP_INT_SELn source IRQ4) */
  FLEXCOMM5_IRQn               = 37,               /**< Flexcomm Interface 5 (USART, SPI, I2C, I2S)(DSP_INT_SELn source IRQ5) */
  FLEXCOMM6_IRQn               = 38,               /**< Flexcomm Interface 6 (USART, SPI, I2C, I3S)(DSP_INT_SELn source IRQ6) */
  FLEXCOMM7_IRQn               = 39,               /**< Flexcomm Interface 7 (USART, SPI, I2C, I4S)(DSP_INT_SELn source IRQ7) */
  PIN_INT0_IRQn                = 40,               /**< Pin interrupt 0 or pattern match engine slice 0 int(DSP_INT_SELn source IRQ8) */
  PIN_INT1_IRQn                = 41,               /**< Pin interrupt 1 or pattern match engine slice 1 int(DSP_INT_SELn source IRQ9) */
  PIN_INT2_IRQn                = 42,               /**< Pin interrupt 2 or pattern match engine slice 2 int(DSP_INT_SELn source IRQ10) */
  PIN_INT3_IRQn                = 43,               /**< Pin interrupt 3 or pattern match engine slice 3 int(DSP_INT_SELn source IRQ11) */
  PIN_INT4_IRQn                = 44,               /**< Pin interrupt 4 or pattern match engine slice 4 int(DSP_INT_SELn source IRQ12) */
  PIN_INT5_IRQn                = 45,               /**< Pin interrupt 5 or pattern match engine slice 5 int(DSP_INT_SELn source IRQ13) */
  PIN_INT6_IRQn                = 46,               /**< Pin interrupt 6 or pattern match engine slice 6 int(DSP_INT_SELn source IRQ14) */
  PIN_INT7_IRQn                = 47,               /**< Pin interrupt 7 or pattern match engine slice 7 int(DSP_INT_SELn source IRQ15) */
  GPIO_INTA_IRQn               = 48,               /**< GPIO interrupt A(DSP_INT_SELn source IRQ16) */
  GPIO_INTB_IRQn               = 49,               /**< GPIO interrupt B(DSP_INT_SELn source IRQ17) */
  WDT1_IRQn                    = 50,               /**< Windowed watchdog timer 1 (HiFi 4 watchdog)(DSP_INT_SELn source IRQ18) */
  DMA0_IRQn                    = 51,               /**< DMA controller 0 (secure or CM33 DMA)(DSP_INT_SELn source IRQ19) */
  DMA1_IRQn                    = 52,               /**< DMA controller 1 (non-secure or HiFi 4 DMA)(DSP_INT_SELn source IRQ20) */
  MU_B_IRQn                    = 53,               /**< Messaging Unit port B for HiFi 4(DSP_INT_SELn source IRQ21) */
  UTICK0_IRQn                  = 54,               /**< Micro-tick Timer(DSP_INT_SELn source IRQ22) */
  MRT0_IRQn                    = 55,               /**< Multi-Rate Timer(DSP_INT_SELn source IRQ23) */
  OS_EVENT_IRQn                = 56,               /**< OS event timer(DSP_INT_SELn source IRQ24) */
  CTIMER0_IRQn                 = 57,               /**< Standard counter/timer CTIMER0(DSP_INT_SELn source IRQ25) */
  CTIMER1_IRQn                 = 58,               /**< Standard counter/timer CTIMER1(DSP_INT_SELn source IRQ26) */
  CTIMER2_IRQn                 = 59,               /**< Standard counter/timer CTIMER2(DSP_INT_SELn source IRQ27) */
  CTIMER3_IRQn                 = 60,               /**< Standard counter/timer CTIMER3(DSP_INT_SELn source IRQ28) */
  CTIMER4_IRQn                 = 61,               /**< Standard counter/timer CTIMER4(DSP_INT_SELn source IRQ29) */
  RTC_IRQn                     = 62,               /**< RTC alarm and wake-up(DSP_INT_SELn source IRQ30) */
  I3C0_IRQn                    = 63,               /**< I3C interface 0(DSP_INT_SELn source IRQ31) */
  DMIC0_IRQn                   = 64,               /**< Digital microphone and DMIC subsystem(DSP_INT_SELn source IRQ32) */
  HWVAD0_IRQn                  = 65,               /**< Hardware Voice Activity Detector(DSP_INT_SELn source IRQ33) */
  FLEXSPI_IRQn                 = 66                /**< FLEXSPI interface(DSP_INT_SELn source IRQ34) */
} IRQn_Type;

/*!
 * @}
 */ /* end of group Interrupt_vector_numbers */


/* ----------------------------------------------------------------------------
   -- Device Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup Peripheral_access_layer Device Peripheral Access Layer
 * @{
 */


/*
** Start of section using anonymous unions
*/

#if defined(__XCC__)
  /* anonymous unions are enabled by default */
#else
  #error Not supported compiler type
#endif

/* ----------------------------------------------------------------------------
   -- ADC Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ADC_Peripheral_Access_Layer ADC Peripheral Access Layer
 * @{
 */

/** ADC - Register Layout Typedef */
typedef struct {
       uint8_t RESERVED_0[4];
  __I  uint32_t PARAM;                             /**< Parameter Register, offset: 0x4 */
       uint8_t RESERVED_1[8];
  __IO uint32_t CTRL;                              /**< ADC Control Register, offset: 0x10 */
  __IO uint32_t STAT;                              /**< ADC Status Register, offset: 0x14 */
  __IO uint32_t IE;                                /**< Interrupt Enable Register, offset: 0x18 */
  __IO uint32_t DE;                                /**< DMA Enable Register, offset: 0x1C */
  __IO uint32_t CFG;                               /**< ADC Configuration Register, offset: 0x20 */
  __IO uint32_t PAUSE;                             /**< ADC Pause Register, offset: 0x24 */
       uint8_t RESERVED_2[8];
  __IO uint32_t FCTRL;                             /**< ADC FIFO Control Register, offset: 0x30 */
  __IO uint32_t SWTRIG;                            /**< Software Trigger Register, offset: 0x34 */
       uint8_t RESERVED_3[136];
  __IO uint32_t TCTRL[16];                         /**< Trigger Control Register, array offset: 0xC0, array step: 0x4 */
  struct {                                         /* offset: 0x100, array step: 0x8 */
    __IO uint32_t CMDL;                              /**< ADC Command Low Buffer Register, array offset: 0x100, array step: 0x8 */
    __IO uint32_t CMDH;                              /**< ADC Command High Buffer Register, array offset: 0x104, array step: 0x8 */
  } CMD[15];
       uint8_t RESERVED_4[136];
  __IO uint32_t CV[4];                             /**< Compare Value Register, array offset: 0x200, array step: 0x4 */
       uint8_t RESERVED_5[240];
  __I  uint32_t RESFIFO;                           /**< ADC Data Result FIFO Register, offset: 0x300 */
} ADC_Type;

/* ----------------------------------------------------------------------------
   -- ADC Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ADC_Register_Masks ADC Register Masks
 * @{
 */

/*! @name PARAM - Parameter Register */
/*! @{ */

#define ADC_PARAM_TRIG_NUM_MASK                  (0xFFU)
#define ADC_PARAM_TRIG_NUM_SHIFT                 (0U)
/*! TRIG_NUM - Trigger Number
 */
#define ADC_PARAM_TRIG_NUM(x)                    (((uint32_t)(((uint32_t)(x)) << ADC_PARAM_TRIG_NUM_SHIFT)) & ADC_PARAM_TRIG_NUM_MASK)

#define ADC_PARAM_FIFOSIZE_MASK                  (0xFF00U)
#define ADC_PARAM_FIFOSIZE_SHIFT                 (8U)
/*! FIFOSIZE - Result FIFO Depth
 *  0b00000001..Result FIFO depth = 1 dataword.
 *  0b00000100..Result FIFO depth = 4 datawords.
 *  0b00001000..Result FIFO depth = 8 datawords.
 *  0b00010000..Result FIFO depth = 16 datawords.
 *  0b00100000..Result FIFO depth = 32 datawords.
 *  0b01000000..Result FIFO depth = 64 datawords.
 */
#define ADC_PARAM_FIFOSIZE(x)                    (((uint32_t)(((uint32_t)(x)) << ADC_PARAM_FIFOSIZE_SHIFT)) & ADC_PARAM_FIFOSIZE_MASK)

#define ADC_PARAM_CV_NUM_MASK                    (0xFF0000U)
#define ADC_PARAM_CV_NUM_SHIFT                   (16U)
/*! CV_NUM - Compare Value Number
 */
#define ADC_PARAM_CV_NUM(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_PARAM_CV_NUM_SHIFT)) & ADC_PARAM_CV_NUM_MASK)

#define ADC_PARAM_CMD_NUM_MASK                   (0xFF000000U)
#define ADC_PARAM_CMD_NUM_SHIFT                  (24U)
/*! CMD_NUM - Command Buffer Number
 */
#define ADC_PARAM_CMD_NUM(x)                     (((uint32_t)(((uint32_t)(x)) << ADC_PARAM_CMD_NUM_SHIFT)) & ADC_PARAM_CMD_NUM_MASK)
/*! @} */

/*! @name CTRL - ADC Control Register */
/*! @{ */

#define ADC_CTRL_ADCEN_MASK                      (0x1U)
#define ADC_CTRL_ADCEN_SHIFT                     (0U)
/*! ADCEN - ADC Enable
 *  0b0..ADC is disabled.
 *  0b1..ADC is enabled.
 */
#define ADC_CTRL_ADCEN(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_CTRL_ADCEN_SHIFT)) & ADC_CTRL_ADCEN_MASK)

#define ADC_CTRL_RST_MASK                        (0x2U)
#define ADC_CTRL_RST_SHIFT                       (1U)
/*! RST - Software Reset
 *  0b0..ADC logic is not reset.
 *  0b1..ADC logic is reset.
 */
#define ADC_CTRL_RST(x)                          (((uint32_t)(((uint32_t)(x)) << ADC_CTRL_RST_SHIFT)) & ADC_CTRL_RST_MASK)

#define ADC_CTRL_DOZEN_MASK                      (0x4U)
#define ADC_CTRL_DOZEN_SHIFT                     (2U)
/*! DOZEN - Doze Enable
 *  0b0..ADC is enabled in Doze mode.
 *  0b1..ADC is disabled in Doze mode.
 */
#define ADC_CTRL_DOZEN(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_CTRL_DOZEN_SHIFT)) & ADC_CTRL_DOZEN_MASK)

#define ADC_CTRL_RSTFIFO_MASK                    (0x100U)
#define ADC_CTRL_RSTFIFO_SHIFT                   (8U)
/*! RSTFIFO - Reset FIFO
 *  0b0..No effect.
 *  0b1..FIFO is reset.
 */
#define ADC_CTRL_RSTFIFO(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_CTRL_RSTFIFO_SHIFT)) & ADC_CTRL_RSTFIFO_MASK)
/*! @} */

/*! @name STAT - ADC Status Register */
/*! @{ */

#define ADC_STAT_RDY_MASK                        (0x1U)
#define ADC_STAT_RDY_SHIFT                       (0U)
/*! RDY - Result FIFO Ready Flag
 *  0b0..Result FIFO data level not above watermark level.
 *  0b1..Result FIFO holding data above watermark level.
 */
#define ADC_STAT_RDY(x)                          (((uint32_t)(((uint32_t)(x)) << ADC_STAT_RDY_SHIFT)) & ADC_STAT_RDY_MASK)

#define ADC_STAT_FOF_MASK                        (0x2U)
#define ADC_STAT_FOF_SHIFT                       (1U)
/*! FOF - Result FIFO Overflow Flag
 *  0b0..No result FIFO overflow has occurred since the last time the flag was cleared.
 *  0b1..At least one result FIFO overflow has occurred since the last time the flag was cleared.
 */
#define ADC_STAT_FOF(x)                          (((uint32_t)(((uint32_t)(x)) << ADC_STAT_FOF_SHIFT)) & ADC_STAT_FOF_MASK)

#define ADC_STAT_TRGACT_MASK                     (0xF0000U)
#define ADC_STAT_TRGACT_SHIFT                    (16U)
/*! TRGACT - Trigger Active
 *  0b0000..Command (sequence) associated with Trigger 0 currently being executed.
 *  0b0001..Command (sequence) associated with Trigger 1 currently being executed.
 *  0b1111..Command (sequence) associated with Trigger 15 currently being executed.
 */
#define ADC_STAT_TRGACT(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_STAT_TRGACT_SHIFT)) & ADC_STAT_TRGACT_MASK)

#define ADC_STAT_CMDACT_MASK                     (0xF000000U)
#define ADC_STAT_CMDACT_SHIFT                    (24U)
/*! CMDACT - Command Active
 *  0b0000..No command is currently in progress.
 *  0b0001..Command 1 currently being executed.
 *  0b0010..Command 2 currently being executed.
 *  0b1111..Command 15 currently being executed.
 */
#define ADC_STAT_CMDACT(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_STAT_CMDACT_SHIFT)) & ADC_STAT_CMDACT_MASK)
/*! @} */

/*! @name IE - Interrupt Enable Register */
/*! @{ */

#define ADC_IE_FWMIE_MASK                        (0x1U)
#define ADC_IE_FWMIE_SHIFT                       (0U)
/*! FWMIE - FIFO Watermark Interrupt Enable
 *  0b0..FIFO watermark interrupts are not enabled.
 *  0b1..FIFO watermark interrupts are enabled.
 */
#define ADC_IE_FWMIE(x)                          (((uint32_t)(((uint32_t)(x)) << ADC_IE_FWMIE_SHIFT)) & ADC_IE_FWMIE_MASK)

#define ADC_IE_FOFIE_MASK                        (0x2U)
#define ADC_IE_FOFIE_SHIFT                       (1U)
/*! FOFIE - Result FIFO Overflow Interrupt Enable
 *  0b0..FIFO overflow interrupts are not enabled.
 *  0b1..FIFO overflow interrupts are enabled.
 */
#define ADC_IE_FOFIE(x)                          (((uint32_t)(((uint32_t)(x)) << ADC_IE_FOFIE_SHIFT)) & ADC_IE_FOFIE_MASK)
/*! @} */

/*! @name DE - DMA Enable Register */
/*! @{ */

#define ADC_DE_FWMDE_MASK                        (0x1U)
#define ADC_DE_FWMDE_SHIFT                       (0U)
/*! FWMDE - FIFO Watermark DMA Enable
 *  0b0..DMA request disabled.
 *  0b1..DMA request enabled.
 */
#define ADC_DE_FWMDE(x)                          (((uint32_t)(((uint32_t)(x)) << ADC_DE_FWMDE_SHIFT)) & ADC_DE_FWMDE_MASK)
/*! @} */

/*! @name CFG - ADC Configuration Register */
/*! @{ */

#define ADC_CFG_TPRICTRL_MASK                    (0x1U)
#define ADC_CFG_TPRICTRL_SHIFT                   (0U)
/*! TPRICTRL - ADC trigger priority control
 *  0b0..If a higher priority trigger is detected during command processing, the current conversion is aborted and
 *       the new command specified by the trigger is started.
 *  0b1..If a higher priority trigger is received during command processing, the current conversion is completed
 *       (including averaging iterations and compare function if enabled) and stored to the RESFIFO before the
 *       higher priority trigger/command is initiated.
 */
#define ADC_CFG_TPRICTRL(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_CFG_TPRICTRL_SHIFT)) & ADC_CFG_TPRICTRL_MASK)

#define ADC_CFG_PWRSEL_MASK                      (0x30U)
#define ADC_CFG_PWRSEL_SHIFT                     (4U)
/*! PWRSEL - Power Configuration Select
 *  0b00..Lowest power setting.
 *  0b01..Next lowest power setting.
 *  0b10......
 *  0b11..Highest power setting.
 */
#define ADC_CFG_PWRSEL(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_CFG_PWRSEL_SHIFT)) & ADC_CFG_PWRSEL_MASK)

#define ADC_CFG_REFSEL_MASK                      (0xC0U)
#define ADC_CFG_REFSEL_SHIFT                     (6U)
/*! REFSEL - Voltage Reference Selection
 *  0b00..(Default) Option 1 setting.
 *  0b01..Option 2 setting.
 *  0b10..Option 3 setting.
 *  0b11..Reserved
 */
#define ADC_CFG_REFSEL(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_CFG_REFSEL_SHIFT)) & ADC_CFG_REFSEL_MASK)

#define ADC_CFG_PUDLY_MASK                       (0xFF0000U)
#define ADC_CFG_PUDLY_SHIFT                      (16U)
/*! PUDLY - Power Up Delay
 */
#define ADC_CFG_PUDLY(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CFG_PUDLY_SHIFT)) & ADC_CFG_PUDLY_MASK)

#define ADC_CFG_PWREN_MASK                       (0x10000000U)
#define ADC_CFG_PWREN_SHIFT                      (28U)
/*! PWREN - ADC Analog Pre-Enable
 *  0b0..ADC analog circuits are only enabled while conversions are active. Performance is affected due to analog startup delays.
 *  0b1..ADC analog circuits are pre-enabled and ready to execute conversions without startup delays (at the cost
 *       of higher DC current consumption). When PWREN is set, the power up delay is enforced such that any
 *       detected trigger does not begin ADC operation until the power up delay time has passed.
 */
#define ADC_CFG_PWREN(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CFG_PWREN_SHIFT)) & ADC_CFG_PWREN_MASK)
/*! @} */

/*! @name PAUSE - ADC Pause Register */
/*! @{ */

#define ADC_PAUSE_PAUSEDLY_MASK                  (0x1FFU)
#define ADC_PAUSE_PAUSEDLY_SHIFT                 (0U)
/*! PAUSEDLY - Pause Delay
 */
#define ADC_PAUSE_PAUSEDLY(x)                    (((uint32_t)(((uint32_t)(x)) << ADC_PAUSE_PAUSEDLY_SHIFT)) & ADC_PAUSE_PAUSEDLY_MASK)

#define ADC_PAUSE_PAUSEEN_MASK                   (0x80000000U)
#define ADC_PAUSE_PAUSEEN_SHIFT                  (31U)
/*! PAUSEEN - PAUSE Option Enable
 *  0b0..Pause operation disabled
 *  0b1..Pause operation enabled
 */
#define ADC_PAUSE_PAUSEEN(x)                     (((uint32_t)(((uint32_t)(x)) << ADC_PAUSE_PAUSEEN_SHIFT)) & ADC_PAUSE_PAUSEEN_MASK)
/*! @} */

/*! @name FCTRL - ADC FIFO Control Register */
/*! @{ */

#define ADC_FCTRL_FCOUNT_MASK                    (0x1FU)
#define ADC_FCTRL_FCOUNT_SHIFT                   (0U)
/*! FCOUNT - Result FIFO counter
 */
#define ADC_FCTRL_FCOUNT(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_FCTRL_FCOUNT_SHIFT)) & ADC_FCTRL_FCOUNT_MASK)

#define ADC_FCTRL_FWMARK_MASK                    (0xF0000U)
#define ADC_FCTRL_FWMARK_SHIFT                   (16U)
/*! FWMARK - Watermark level selection
 */
#define ADC_FCTRL_FWMARK(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_FCTRL_FWMARK_SHIFT)) & ADC_FCTRL_FWMARK_MASK)
/*! @} */

/*! @name SWTRIG - Software Trigger Register */
/*! @{ */

#define ADC_SWTRIG_SWT0_MASK                     (0x1U)
#define ADC_SWTRIG_SWT0_SHIFT                    (0U)
/*! SWT0 - Software trigger 0 event
 *  0b0..No trigger 0 event generated.
 *  0b1..Trigger 0 event generated.
 */
#define ADC_SWTRIG_SWT0(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_SWTRIG_SWT0_SHIFT)) & ADC_SWTRIG_SWT0_MASK)

#define ADC_SWTRIG_SWT1_MASK                     (0x2U)
#define ADC_SWTRIG_SWT1_SHIFT                    (1U)
/*! SWT1 - Software trigger 1 event
 *  0b0..No trigger 1 event generated.
 *  0b1..Trigger 1 event generated.
 */
#define ADC_SWTRIG_SWT1(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_SWTRIG_SWT1_SHIFT)) & ADC_SWTRIG_SWT1_MASK)

#define ADC_SWTRIG_SWT2_MASK                     (0x4U)
#define ADC_SWTRIG_SWT2_SHIFT                    (2U)
/*! SWT2 - Software trigger 2 event
 *  0b0..No trigger 2 event generated.
 *  0b1..Trigger 2 event generated.
 */
#define ADC_SWTRIG_SWT2(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_SWTRIG_SWT2_SHIFT)) & ADC_SWTRIG_SWT2_MASK)

#define ADC_SWTRIG_SWT3_MASK                     (0x8U)
#define ADC_SWTRIG_SWT3_SHIFT                    (3U)
/*! SWT3 - Software trigger 3 event
 *  0b0..No trigger 3 event generated.
 *  0b1..Trigger 3 event generated.
 */
#define ADC_SWTRIG_SWT3(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_SWTRIG_SWT3_SHIFT)) & ADC_SWTRIG_SWT3_MASK)

#define ADC_SWTRIG_SWT4_MASK                     (0x10U)
#define ADC_SWTRIG_SWT4_SHIFT                    (4U)
/*! SWT4 - Software trigger 4 event
 *  0b0..No trigger 4 event generated.
 *  0b1..Trigger 4 event generated.
 */
#define ADC_SWTRIG_SWT4(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_SWTRIG_SWT4_SHIFT)) & ADC_SWTRIG_SWT4_MASK)

#define ADC_SWTRIG_SWT5_MASK                     (0x20U)
#define ADC_SWTRIG_SWT5_SHIFT                    (5U)
/*! SWT5 - Software trigger 5 event
 *  0b0..No trigger 5 event generated.
 *  0b1..Trigger 5 event generated.
 */
#define ADC_SWTRIG_SWT5(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_SWTRIG_SWT5_SHIFT)) & ADC_SWTRIG_SWT5_MASK)

#define ADC_SWTRIG_SWT6_MASK                     (0x40U)
#define ADC_SWTRIG_SWT6_SHIFT                    (6U)
/*! SWT6 - Software trigger 6 event
 *  0b0..No trigger 6 event generated.
 *  0b1..Trigger 6 event generated.
 */
#define ADC_SWTRIG_SWT6(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_SWTRIG_SWT6_SHIFT)) & ADC_SWTRIG_SWT6_MASK)

#define ADC_SWTRIG_SWT7_MASK                     (0x80U)
#define ADC_SWTRIG_SWT7_SHIFT                    (7U)
/*! SWT7 - Software trigger 7 event
 *  0b0..No trigger 7 event generated.
 *  0b1..Trigger 7 event generated.
 */
#define ADC_SWTRIG_SWT7(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_SWTRIG_SWT7_SHIFT)) & ADC_SWTRIG_SWT7_MASK)

#define ADC_SWTRIG_SWT8_MASK                     (0x100U)
#define ADC_SWTRIG_SWT8_SHIFT                    (8U)
/*! SWT8 - Software trigger 8 event
 *  0b0..No trigger 8 event generated.
 *  0b1..Trigger 8 event generated.
 */
#define ADC_SWTRIG_SWT8(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_SWTRIG_SWT8_SHIFT)) & ADC_SWTRIG_SWT8_MASK)

#define ADC_SWTRIG_SWT9_MASK                     (0x200U)
#define ADC_SWTRIG_SWT9_SHIFT                    (9U)
/*! SWT9 - Software trigger 9 event
 *  0b0..No trigger 9 event generated.
 *  0b1..Trigger 9 event generated.
 */
#define ADC_SWTRIG_SWT9(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_SWTRIG_SWT9_SHIFT)) & ADC_SWTRIG_SWT9_MASK)

#define ADC_SWTRIG_SWT10_MASK                    (0x400U)
#define ADC_SWTRIG_SWT10_SHIFT                   (10U)
/*! SWT10 - Software trigger 10 event
 *  0b0..No trigger 10 event generated.
 *  0b1..Trigger 10 event generated.
 */
#define ADC_SWTRIG_SWT10(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_SWTRIG_SWT10_SHIFT)) & ADC_SWTRIG_SWT10_MASK)

#define ADC_SWTRIG_SWT11_MASK                    (0x800U)
#define ADC_SWTRIG_SWT11_SHIFT                   (11U)
/*! SWT11 - Software trigger 11 event
 *  0b0..No trigger 11 event generated.
 *  0b1..Trigger 11 event generated.
 */
#define ADC_SWTRIG_SWT11(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_SWTRIG_SWT11_SHIFT)) & ADC_SWTRIG_SWT11_MASK)

#define ADC_SWTRIG_SWT12_MASK                    (0x1000U)
#define ADC_SWTRIG_SWT12_SHIFT                   (12U)
/*! SWT12 - Software trigger 12 event
 *  0b0..No trigger 12 event generated.
 *  0b1..Trigger 12 event generated.
 */
#define ADC_SWTRIG_SWT12(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_SWTRIG_SWT12_SHIFT)) & ADC_SWTRIG_SWT12_MASK)

#define ADC_SWTRIG_SWT13_MASK                    (0x2000U)
#define ADC_SWTRIG_SWT13_SHIFT                   (13U)
/*! SWT13 - Software trigger 13 event
 *  0b0..No trigger 13 event generated.
 *  0b1..Trigger 13 event generated.
 */
#define ADC_SWTRIG_SWT13(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_SWTRIG_SWT13_SHIFT)) & ADC_SWTRIG_SWT13_MASK)

#define ADC_SWTRIG_SWT14_MASK                    (0x4000U)
#define ADC_SWTRIG_SWT14_SHIFT                   (14U)
/*! SWT14 - Software trigger 14 event
 *  0b0..No trigger 14 event generated.
 *  0b1..Trigger 14 event generated.
 */
#define ADC_SWTRIG_SWT14(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_SWTRIG_SWT14_SHIFT)) & ADC_SWTRIG_SWT14_MASK)

#define ADC_SWTRIG_SWT15_MASK                    (0x8000U)
#define ADC_SWTRIG_SWT15_SHIFT                   (15U)
/*! SWT15 - Software trigger 15 event
 *  0b0..No trigger 15 event generated.
 *  0b1..Trigger 15 event generated.
 */
#define ADC_SWTRIG_SWT15(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_SWTRIG_SWT15_SHIFT)) & ADC_SWTRIG_SWT15_MASK)
/*! @} */

/*! @name TCTRL - Trigger Control Register */
/*! @{ */

#define ADC_TCTRL_HTEN_MASK                      (0x1U)
#define ADC_TCTRL_HTEN_SHIFT                     (0U)
/*! HTEN - Trigger enable
 *  0b0..Hardware trigger source disabled
 *  0b1..Hardware trigger source enabled
 */
#define ADC_TCTRL_HTEN(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_TCTRL_HTEN_SHIFT)) & ADC_TCTRL_HTEN_MASK)

#define ADC_TCTRL_TPRI_MASK                      (0xF00U)
#define ADC_TCTRL_TPRI_SHIFT                     (8U)
/*! TPRI - Trigger priority setting
 *  0b0000..Set to highest priority, Level 1
 *  0b0001-0b1110..Set to corresponding priority level
 *  0b1111..Set to lowest priority, Level 16
 */
#define ADC_TCTRL_TPRI(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_TCTRL_TPRI_SHIFT)) & ADC_TCTRL_TPRI_MASK)

#define ADC_TCTRL_TDLY_MASK                      (0xF0000U)
#define ADC_TCTRL_TDLY_SHIFT                     (16U)
/*! TDLY - Trigger delay select
 */
#define ADC_TCTRL_TDLY(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_TCTRL_TDLY_SHIFT)) & ADC_TCTRL_TDLY_MASK)

#define ADC_TCTRL_TCMD_MASK                      (0xF000000U)
#define ADC_TCTRL_TCMD_SHIFT                     (24U)
/*! TCMD - Trigger command select
 *  0b0000..Not a valid selection from the command buffer. Trigger event is ignored.
 *  0b0001..CMD1 is executed
 *  0b0010-0b1110..Corresponding CMD is executed
 *  0b1111..CMD15 is executed
 */
#define ADC_TCTRL_TCMD(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_TCTRL_TCMD_SHIFT)) & ADC_TCTRL_TCMD_MASK)
/*! @} */

/* The count of ADC_TCTRL */
#define ADC_TCTRL_COUNT                          (16U)

/*! @name CMDL - ADC Command Low Buffer Register */
/*! @{ */

#define ADC_CMDL_ADCH_MASK                       (0x1FU)
#define ADC_CMDL_ADCH_SHIFT                      (0U)
/*! ADCH - Input channel select
 *  0b00000..Select CH0A or CH0B or CH0A/CH0B pair.
 *  0b00001..Select CH1A or CH1B or CH1A/CH1B pair.
 *  0b00010..Select CH2A or CH2B or CH2A/CH2B pair.
 *  0b00011..Select CH3A or CH3B or CH3A/CH3B pair.
 *  0b00100-0b11101..Select corresponding channel CHnA or CHnB or CHnA/CHnB pair.
 *  0b11110..Select CH30A or CH30B or CH30A/CH30B pair.
 *  0b11111..Select CH31A or CH31B or CH31A/CH31B pair.
 */
#define ADC_CMDL_ADCH(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CMDL_ADCH_SHIFT)) & ADC_CMDL_ADCH_MASK)

#define ADC_CMDL_ABSEL_MASK                      (0x20U)
#define ADC_CMDL_ABSEL_SHIFT                     (5U)
/*! ABSEL - A-side vs. B-side Select
 *  0b0..When DIFF=0b0, the associated A-side channel is converted as single-ended. When DIFF=0b1, the ADC result is (CHnA-CHnB).
 *  0b1..When DIFF=0b0, the associated B-side channel is converted as single-ended. When DIFF=0b1, the ADC result is (CHnB-CHnA).
 */
#define ADC_CMDL_ABSEL(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_CMDL_ABSEL_SHIFT)) & ADC_CMDL_ABSEL_MASK)

#define ADC_CMDL_DIFF_MASK                       (0x40U)
#define ADC_CMDL_DIFF_SHIFT                      (6U)
/*! DIFF - Differential Mode Enable
 *  0b0..Single-ended mode.
 *  0b1..Differential mode.
 */
#define ADC_CMDL_DIFF(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CMDL_DIFF_SHIFT)) & ADC_CMDL_DIFF_MASK)

#define ADC_CMDL_CSCALE_MASK                     (0x2000U)
#define ADC_CMDL_CSCALE_SHIFT                    (13U)
/*! CSCALE - Channel Scale
 *  0b0..Scale selected analog channel (Factor of 30/64)
 *  0b1..(Default) Full scale (Factor of 1)
 */
#define ADC_CMDL_CSCALE(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_CMDL_CSCALE_SHIFT)) & ADC_CMDL_CSCALE_MASK)
/*! @} */

/* The count of ADC_CMDL */
#define ADC_CMDL_COUNT                           (15U)

/*! @name CMDH - ADC Command High Buffer Register */
/*! @{ */

#define ADC_CMDH_CMPEN_MASK                      (0x3U)
#define ADC_CMDH_CMPEN_SHIFT                     (0U)
/*! CMPEN - Compare Function Enable
 *  0b00..Compare disabled.
 *  0b01..Reserved
 *  0b10..Compare enabled. Store on true.
 *  0b11..Compare enabled. Repeat channel acquisition (sample/convert/compare) until true.
 */
#define ADC_CMDH_CMPEN(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_CMDH_CMPEN_SHIFT)) & ADC_CMDH_CMPEN_MASK)

#define ADC_CMDH_LWI_MASK                        (0x80U)
#define ADC_CMDH_LWI_SHIFT                       (7U)
/*! LWI - Loop with Increment
 *  0b0..Auto channel increment disabled
 *  0b1..Auto channel increment enabled
 */
#define ADC_CMDH_LWI(x)                          (((uint32_t)(((uint32_t)(x)) << ADC_CMDH_LWI_SHIFT)) & ADC_CMDH_LWI_MASK)

#define ADC_CMDH_STS_MASK                        (0x700U)
#define ADC_CMDH_STS_SHIFT                       (8U)
/*! STS - Sample Time Select
 *  0b000..Minimum sample time of 3 ADCK cycles.
 *  0b001..3 + 2^1 ADCK cycles; 5 ADCK cycles total sample time.
 *  0b010..3 + 2^2 ADCK cycles; 7 ADCK cycles total sample time.
 *  0b011..3 + 2^3 ADCK cycles; 11 ADCK cycles total sample time.
 *  0b100..3 + 2^4 ADCK cycles; 19 ADCK cycles total sample time.
 *  0b101..3 + 2^5 ADCK cycles; 35 ADCK cycles total sample time.
 *  0b110..3 + 2^6 ADCK cycles; 67 ADCK cycles total sample time.
 *  0b111..3 + 2^7 ADCK cycles; 131 ADCK cycles total sample time.
 */
#define ADC_CMDH_STS(x)                          (((uint32_t)(((uint32_t)(x)) << ADC_CMDH_STS_SHIFT)) & ADC_CMDH_STS_MASK)

#define ADC_CMDH_AVGS_MASK                       (0x7000U)
#define ADC_CMDH_AVGS_SHIFT                      (12U)
/*! AVGS - Hardware Average Select
 *  0b000..Single conversion.
 *  0b001..2 conversions averaged.
 *  0b010..4 conversions averaged.
 *  0b011..8 conversions averaged.
 *  0b100..16 conversions averaged.
 *  0b101..32 conversions averaged.
 *  0b110..64 conversions averaged.
 *  0b111..128 conversions averaged.
 */
#define ADC_CMDH_AVGS(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CMDH_AVGS_SHIFT)) & ADC_CMDH_AVGS_MASK)

#define ADC_CMDH_LOOP_MASK                       (0xF0000U)
#define ADC_CMDH_LOOP_SHIFT                      (16U)
/*! LOOP - Loop Count Select
 *  0b0000..Looping not enabled. Command executes 1 time.
 *  0b0001..Loop 1 time. Command executes 2 times.
 *  0b0010..Loop 2 times. Command executes 3 times.
 *  0b0011-0b1110..Loop corresponding number of times. Command executes LOOP+1 times.
 *  0b1111..Loop 15 times. Command executes 16 times.
 */
#define ADC_CMDH_LOOP(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CMDH_LOOP_SHIFT)) & ADC_CMDH_LOOP_MASK)

#define ADC_CMDH_NEXT_MASK                       (0xF000000U)
#define ADC_CMDH_NEXT_SHIFT                      (24U)
/*! NEXT - Next Command Select
 *  0b0000..No next command defined. Terminate conversions at completion of current command. If lower priority
 *          trigger pending, begin command associated with lower priority trigger.
 *  0b0001..Select CMD1 command buffer register as next command.
 *  0b0010-0b1110..Select corresponding CMD command buffer register as next command
 *  0b1111..Select CMD15 command buffer register as next command.
 */
#define ADC_CMDH_NEXT(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CMDH_NEXT_SHIFT)) & ADC_CMDH_NEXT_MASK)
/*! @} */

/* The count of ADC_CMDH */
#define ADC_CMDH_COUNT                           (15U)

/*! @name CV - Compare Value Register */
/*! @{ */

#define ADC_CV_CVL_MASK                          (0xFFFFU)
#define ADC_CV_CVL_SHIFT                         (0U)
/*! CVL - Compare Value Low.
 */
#define ADC_CV_CVL(x)                            (((uint32_t)(((uint32_t)(x)) << ADC_CV_CVL_SHIFT)) & ADC_CV_CVL_MASK)

#define ADC_CV_CVH_MASK                          (0xFFFF0000U)
#define ADC_CV_CVH_SHIFT                         (16U)
/*! CVH - Compare Value High.
 */
#define ADC_CV_CVH(x)                            (((uint32_t)(((uint32_t)(x)) << ADC_CV_CVH_SHIFT)) & ADC_CV_CVH_MASK)
/*! @} */

/* The count of ADC_CV */
#define ADC_CV_COUNT                             (4U)

/*! @name RESFIFO - ADC Data Result FIFO Register */
/*! @{ */

#define ADC_RESFIFO_D_MASK                       (0xFFFFU)
#define ADC_RESFIFO_D_SHIFT                      (0U)
/*! D - Data result
 */
#define ADC_RESFIFO_D(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_RESFIFO_D_SHIFT)) & ADC_RESFIFO_D_MASK)

#define ADC_RESFIFO_TSRC_MASK                    (0xF0000U)
#define ADC_RESFIFO_TSRC_SHIFT                   (16U)
/*! TSRC - Trigger Source
 *  0b0000..Trigger source 0 initiated this conversion.
 *  0b0001..Trigger source 1 initiated this conversion.
 *  0b0010-0b1110..Corresponding trigger source initiated this conversion.
 *  0b1111..Trigger source 15 initiated this conversion.
 */
#define ADC_RESFIFO_TSRC(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_RESFIFO_TSRC_SHIFT)) & ADC_RESFIFO_TSRC_MASK)

#define ADC_RESFIFO_LOOPCNT_MASK                 (0xF00000U)
#define ADC_RESFIFO_LOOPCNT_SHIFT                (20U)
/*! LOOPCNT - Loop count value
 *  0b0000..Result is from initial conversion in command.
 *  0b0001..Result is from second conversion in command.
 *  0b0010-0b1110..Result is from LOOPCNT+1 conversion in command.
 *  0b1111..Result is from 16th conversion in command.
 */
#define ADC_RESFIFO_LOOPCNT(x)                   (((uint32_t)(((uint32_t)(x)) << ADC_RESFIFO_LOOPCNT_SHIFT)) & ADC_RESFIFO_LOOPCNT_MASK)

#define ADC_RESFIFO_CMDSRC_MASK                  (0xF000000U)
#define ADC_RESFIFO_CMDSRC_SHIFT                 (24U)
/*! CMDSRC - Command Buffer Source
 *  0b0000..Not a valid value CMDSRC value for a dataword in RESFIFO. 0x0 is only found in initial FIFO state
 *          prior to an ADC conversion result dataword being stored to a RESFIFO buffer.
 *  0b0001..CMD1 buffer used as control settings for this conversion.
 *  0b0010-0b1110..Corresponding command buffer used as control settings for this conversion.
 *  0b1111..CMD15 buffer used as control settings for this conversion.
 */
#define ADC_RESFIFO_CMDSRC(x)                    (((uint32_t)(((uint32_t)(x)) << ADC_RESFIFO_CMDSRC_SHIFT)) & ADC_RESFIFO_CMDSRC_MASK)

#define ADC_RESFIFO_VALID_MASK                   (0x80000000U)
#define ADC_RESFIFO_VALID_SHIFT                  (31U)
/*! VALID - FIFO entry is valid
 *  0b0..FIFO is empty. Discard any read from RESFIFO.
 *  0b1..FIFO record read from RESFIFO is valid.
 */
#define ADC_RESFIFO_VALID(x)                     (((uint32_t)(((uint32_t)(x)) << ADC_RESFIFO_VALID_SHIFT)) & ADC_RESFIFO_VALID_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group ADC_Register_Masks */


/* ADC - Peripheral instance base addresses */
/** Peripheral ADC0 base address */
#define ADC0_BASE                                (0x4013A000u)
/** Peripheral ADC0 base pointer */
#define ADC0                                     ((ADC_Type *)ADC0_BASE)
/** Array initializer of ADC peripheral base addresses */
#define ADC_BASE_ADDRS                           { ADC0_BASE }
/** Array initializer of ADC peripheral base pointers */
#define ADC_BASE_PTRS                            { ADC0 }

/*!
 * @}
 */ /* end of group ADC_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- CACHE64_CTRL Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CACHE64_CTRL_Peripheral_Access_Layer CACHE64_CTRL Peripheral Access Layer
 * @{
 */

/** CACHE64_CTRL - Register Layout Typedef */
typedef struct {
       uint8_t RESERVED_0[2048];
  __IO uint32_t CCR;                               /**< Cache control register, offset: 0x800 */
  __IO uint32_t CLCR;                              /**< Cache line control register, offset: 0x804 */
  __IO uint32_t CSAR;                              /**< Cache search address register, offset: 0x808 */
  __IO uint32_t CCVR;                              /**< Cache read/write value register, offset: 0x80C */
} CACHE64_CTRL_Type;

/* ----------------------------------------------------------------------------
   -- CACHE64_CTRL Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CACHE64_CTRL_Register_Masks CACHE64_CTRL Register Masks
 * @{
 */

/*! @name CCR - Cache control register */
/*! @{ */

#define CACHE64_CTRL_CCR_ENCACHE_MASK            (0x1U)
#define CACHE64_CTRL_CCR_ENCACHE_SHIFT           (0U)
/*! ENCACHE - Cache enable
 *  0b0..Cache disabled
 *  0b1..Cache enabled
 */
#define CACHE64_CTRL_CCR_ENCACHE(x)              (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CCR_ENCACHE_SHIFT)) & CACHE64_CTRL_CCR_ENCACHE_MASK)

#define CACHE64_CTRL_CCR_ENWRBUF_MASK            (0x2U)
#define CACHE64_CTRL_CCR_ENWRBUF_SHIFT           (1U)
/*! ENWRBUF - Enable Write Buffer
 *  0b0..Write buffer disabled
 *  0b1..Write buffer enabled
 */
#define CACHE64_CTRL_CCR_ENWRBUF(x)              (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CCR_ENWRBUF_SHIFT)) & CACHE64_CTRL_CCR_ENWRBUF_MASK)

#define CACHE64_CTRL_CCR_INVW0_MASK              (0x1000000U)
#define CACHE64_CTRL_CCR_INVW0_SHIFT             (24U)
/*! INVW0 - Invalidate Way 0
 *  0b0..No operation
 *  0b1..When setting the GO bit, invalidate all lines in way 0.
 */
#define CACHE64_CTRL_CCR_INVW0(x)                (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CCR_INVW0_SHIFT)) & CACHE64_CTRL_CCR_INVW0_MASK)

#define CACHE64_CTRL_CCR_PUSHW0_MASK             (0x2000000U)
#define CACHE64_CTRL_CCR_PUSHW0_SHIFT            (25U)
/*! PUSHW0 - Push Way 0
 *  0b0..No operation
 *  0b1..When setting the GO bit, push all modified lines in way 0
 */
#define CACHE64_CTRL_CCR_PUSHW0(x)               (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CCR_PUSHW0_SHIFT)) & CACHE64_CTRL_CCR_PUSHW0_MASK)

#define CACHE64_CTRL_CCR_INVW1_MASK              (0x4000000U)
#define CACHE64_CTRL_CCR_INVW1_SHIFT             (26U)
/*! INVW1 - Invalidate Way 1
 *  0b0..No operation
 *  0b1..When setting the GO bit, invalidate all lines in way 1
 */
#define CACHE64_CTRL_CCR_INVW1(x)                (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CCR_INVW1_SHIFT)) & CACHE64_CTRL_CCR_INVW1_MASK)

#define CACHE64_CTRL_CCR_PUSHW1_MASK             (0x8000000U)
#define CACHE64_CTRL_CCR_PUSHW1_SHIFT            (27U)
/*! PUSHW1 - Push Way 1
 *  0b0..No operation
 *  0b1..When setting the GO bit, push all modified lines in way 1
 */
#define CACHE64_CTRL_CCR_PUSHW1(x)               (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CCR_PUSHW1_SHIFT)) & CACHE64_CTRL_CCR_PUSHW1_MASK)

#define CACHE64_CTRL_CCR_GO_MASK                 (0x80000000U)
#define CACHE64_CTRL_CCR_GO_SHIFT                (31U)
/*! GO - Initiate Cache Command
 *  0b0..Write: no effect. Read: no cache command active.
 *  0b1..Write: initiate command indicated by bits 27-24. Read: cache command active.
 */
#define CACHE64_CTRL_CCR_GO(x)                   (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CCR_GO_SHIFT)) & CACHE64_CTRL_CCR_GO_MASK)
/*! @} */

/*! @name CLCR - Cache line control register */
/*! @{ */

#define CACHE64_CTRL_CLCR_LGO_MASK               (0x1U)
#define CACHE64_CTRL_CLCR_LGO_SHIFT              (0U)
/*! LGO - Initiate Cache Line Command
 *  0b0..Write: no effect. Read: no line command active.
 *  0b1..Write: initiate line command indicated by bits 27-24. Read: line command active.
 */
#define CACHE64_CTRL_CLCR_LGO(x)                 (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CLCR_LGO_SHIFT)) & CACHE64_CTRL_CLCR_LGO_MASK)

#define CACHE64_CTRL_CLCR_CACHEADDR_MASK         (0x3FFCU)
#define CACHE64_CTRL_CLCR_CACHEADDR_SHIFT        (2U)
/*! CACHEADDR - Cache address
 */
#define CACHE64_CTRL_CLCR_CACHEADDR(x)           (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CLCR_CACHEADDR_SHIFT)) & CACHE64_CTRL_CLCR_CACHEADDR_MASK)

#define CACHE64_CTRL_CLCR_WSEL_MASK              (0x4000U)
#define CACHE64_CTRL_CLCR_WSEL_SHIFT             (14U)
/*! WSEL - Way select
 *  0b0..Way 0
 *  0b1..Way 1
 */
#define CACHE64_CTRL_CLCR_WSEL(x)                (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CLCR_WSEL_SHIFT)) & CACHE64_CTRL_CLCR_WSEL_MASK)

#define CACHE64_CTRL_CLCR_TDSEL_MASK             (0x10000U)
#define CACHE64_CTRL_CLCR_TDSEL_SHIFT            (16U)
/*! TDSEL - Tag/Data Select
 *  0b0..Data
 *  0b1..Tag
 */
#define CACHE64_CTRL_CLCR_TDSEL(x)               (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CLCR_TDSEL_SHIFT)) & CACHE64_CTRL_CLCR_TDSEL_MASK)

#define CACHE64_CTRL_CLCR_LCIVB_MASK             (0x100000U)
#define CACHE64_CTRL_CLCR_LCIVB_SHIFT            (20U)
/*! LCIVB - Line Command Initial Valid Bit
 */
#define CACHE64_CTRL_CLCR_LCIVB(x)               (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CLCR_LCIVB_SHIFT)) & CACHE64_CTRL_CLCR_LCIVB_MASK)

#define CACHE64_CTRL_CLCR_LCIMB_MASK             (0x200000U)
#define CACHE64_CTRL_CLCR_LCIMB_SHIFT            (21U)
/*! LCIMB - Line Command Initial Modified Bit
 */
#define CACHE64_CTRL_CLCR_LCIMB(x)               (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CLCR_LCIMB_SHIFT)) & CACHE64_CTRL_CLCR_LCIMB_MASK)

#define CACHE64_CTRL_CLCR_LCWAY_MASK             (0x400000U)
#define CACHE64_CTRL_CLCR_LCWAY_SHIFT            (22U)
/*! LCWAY - Line Command Way
 */
#define CACHE64_CTRL_CLCR_LCWAY(x)               (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CLCR_LCWAY_SHIFT)) & CACHE64_CTRL_CLCR_LCWAY_MASK)

#define CACHE64_CTRL_CLCR_LCMD_MASK              (0x3000000U)
#define CACHE64_CTRL_CLCR_LCMD_SHIFT             (24U)
/*! LCMD - Line Command
 *  0b00..Search and read or write
 *  0b01..Invalidate
 *  0b10..Push
 *  0b11..Clear
 */
#define CACHE64_CTRL_CLCR_LCMD(x)                (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CLCR_LCMD_SHIFT)) & CACHE64_CTRL_CLCR_LCMD_MASK)

#define CACHE64_CTRL_CLCR_LADSEL_MASK            (0x4000000U)
#define CACHE64_CTRL_CLCR_LADSEL_SHIFT           (26U)
/*! LADSEL - Line Address Select
 *  0b0..Cache address
 *  0b1..Physical address
 */
#define CACHE64_CTRL_CLCR_LADSEL(x)              (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CLCR_LADSEL_SHIFT)) & CACHE64_CTRL_CLCR_LADSEL_MASK)

#define CACHE64_CTRL_CLCR_LACC_MASK              (0x8000000U)
#define CACHE64_CTRL_CLCR_LACC_SHIFT             (27U)
/*! LACC - Line access type
 *  0b0..Read
 *  0b1..Write
 */
#define CACHE64_CTRL_CLCR_LACC(x)                (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CLCR_LACC_SHIFT)) & CACHE64_CTRL_CLCR_LACC_MASK)
/*! @} */

/*! @name CSAR - Cache search address register */
/*! @{ */

#define CACHE64_CTRL_CSAR_LGO_MASK               (0x1U)
#define CACHE64_CTRL_CSAR_LGO_SHIFT              (0U)
/*! LGO - Initiate Cache Line Command
 *  0b0..Write: no effect. Read: no line command active.
 *  0b1..Write: initiate line command indicated by bits CLCR[27:24]. Read: line command active.
 */
#define CACHE64_CTRL_CSAR_LGO(x)                 (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CSAR_LGO_SHIFT)) & CACHE64_CTRL_CSAR_LGO_MASK)

#define CACHE64_CTRL_CSAR_PHYADDR27_1_MASK       (0xFFFFFFEU)
#define CACHE64_CTRL_CSAR_PHYADDR27_1_SHIFT      (1U)
/*! PHYADDR27_1 - Physical Address
 */
#define CACHE64_CTRL_CSAR_PHYADDR27_1(x)         (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CSAR_PHYADDR27_1_SHIFT)) & CACHE64_CTRL_CSAR_PHYADDR27_1_MASK)

#define CACHE64_CTRL_CSAR_PHYADDR31_29_MASK      (0xE0000000U)
#define CACHE64_CTRL_CSAR_PHYADDR31_29_SHIFT     (29U)
/*! PHYADDR31_29 - Physical Address
 */
#define CACHE64_CTRL_CSAR_PHYADDR31_29(x)        (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CSAR_PHYADDR31_29_SHIFT)) & CACHE64_CTRL_CSAR_PHYADDR31_29_MASK)
/*! @} */

/*! @name CCVR - Cache read/write value register */
/*! @{ */

#define CACHE64_CTRL_CCVR_DATA_MASK              (0xFFFFFFFFU)
#define CACHE64_CTRL_CCVR_DATA_SHIFT             (0U)
/*! DATA - Cache read/write Data
 */
#define CACHE64_CTRL_CCVR_DATA(x)                (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CCVR_DATA_SHIFT)) & CACHE64_CTRL_CCVR_DATA_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group CACHE64_CTRL_Register_Masks */


/* CACHE64_CTRL - Peripheral instance base addresses */
/** Peripheral CACHE64 base address */
#define CACHE64_BASE                             (0x40033000u)
/** Peripheral CACHE64 base pointer */
#define CACHE64                                  ((CACHE64_CTRL_Type *)CACHE64_BASE)
/** Array initializer of CACHE64_CTRL peripheral base addresses */
#define CACHE64_CTRL_BASE_ADDRS                  { CACHE64_BASE }
/** Array initializer of CACHE64_CTRL peripheral base pointers */
#define CACHE64_CTRL_BASE_PTRS                   { CACHE64 }
/* Backward compatibility */
#define CACHE64_CTRL_CSAR_PHYADDR_MASK (CACHE64_CTRL_CSAR_PHYADDR27_1_MASK | CACHE64_CTRL_CSAR_PHYADDR31_29_MASK)


/*!
 * @}
 */ /* end of group CACHE64_CTRL_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- CACHE64_POLSEL Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CACHE64_POLSEL_Peripheral_Access_Layer CACHE64_POLSEL Peripheral Access Layer
 * @{
 */

/** CACHE64_POLSEL - Register Layout Typedef */
typedef struct {
       uint8_t RESERVED_0[20];
  __IO uint32_t REG0_TOP;                          /**< Region 0 Top Boundary, offset: 0x14 */
  __IO uint32_t REG1_TOP;                          /**< Region 1 Top Boundary, offset: 0x18 */
  __IO uint32_t POLSEL;                            /**< Policy Select, offset: 0x1C */
} CACHE64_POLSEL_Type;

/* ----------------------------------------------------------------------------
   -- CACHE64_POLSEL Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CACHE64_POLSEL_Register_Masks CACHE64_POLSEL Register Masks
 * @{
 */

/*! @name REG0_TOP - Region 0 Top Boundary */
/*! @{ */

#define CACHE64_POLSEL_REG0_TOP_REG0_TOP_MASK    (0x7FFFC00U)
#define CACHE64_POLSEL_REG0_TOP_REG0_TOP_SHIFT   (10U)
/*! REG0_TOP - Upper limit of Region 0
 */
#define CACHE64_POLSEL_REG0_TOP_REG0_TOP(x)      (((uint32_t)(((uint32_t)(x)) << CACHE64_POLSEL_REG0_TOP_REG0_TOP_SHIFT)) & CACHE64_POLSEL_REG0_TOP_REG0_TOP_MASK)
/*! @} */

/*! @name REG1_TOP - Region 1 Top Boundary */
/*! @{ */

#define CACHE64_POLSEL_REG1_TOP_REG1_TOP_MASK    (0x7FFFC00U)
#define CACHE64_POLSEL_REG1_TOP_REG1_TOP_SHIFT   (10U)
/*! REG1_TOP - Upper limit of Region 1
 */
#define CACHE64_POLSEL_REG1_TOP_REG1_TOP(x)      (((uint32_t)(((uint32_t)(x)) << CACHE64_POLSEL_REG1_TOP_REG1_TOP_SHIFT)) & CACHE64_POLSEL_REG1_TOP_REG1_TOP_MASK)
/*! @} */

/*! @name POLSEL - Policy Select */
/*! @{ */

#define CACHE64_POLSEL_POLSEL_REG0_POLICY_MASK   (0x3U)
#define CACHE64_POLSEL_POLSEL_REG0_POLICY_SHIFT  (0U)
/*! REG0_POLICY - Policy Select for Region 0
 *  0b00..Non-cache
 *  0b01..Write-thru
 *  0b10..Write-back
 *  0b11..Invalid
 */
#define CACHE64_POLSEL_POLSEL_REG0_POLICY(x)     (((uint32_t)(((uint32_t)(x)) << CACHE64_POLSEL_POLSEL_REG0_POLICY_SHIFT)) & CACHE64_POLSEL_POLSEL_REG0_POLICY_MASK)

#define CACHE64_POLSEL_POLSEL_REG1_POLICY_MASK   (0xCU)
#define CACHE64_POLSEL_POLSEL_REG1_POLICY_SHIFT  (2U)
/*! REG1_POLICY - Policy Select for Region 0
 *  0b00..Non-cache
 *  0b01..Write-thru
 *  0b10..Write-back
 *  0b11..Invalid
 */
#define CACHE64_POLSEL_POLSEL_REG1_POLICY(x)     (((uint32_t)(((uint32_t)(x)) << CACHE64_POLSEL_POLSEL_REG1_POLICY_SHIFT)) & CACHE64_POLSEL_POLSEL_REG1_POLICY_MASK)

#define CACHE64_POLSEL_POLSEL_REG02_POLICY_MASK  (0x30U)
#define CACHE64_POLSEL_POLSEL_REG02_POLICY_SHIFT (4U)
/*! REG02_POLICY - Policy Select for Region 0
 *  0b00..Non-cache
 *  0b01..Write-thru
 *  0b10..Write-back
 *  0b11..Invalid
 */
#define CACHE64_POLSEL_POLSEL_REG02_POLICY(x)    (((uint32_t)(((uint32_t)(x)) << CACHE64_POLSEL_POLSEL_REG02_POLICY_SHIFT)) & CACHE64_POLSEL_POLSEL_REG02_POLICY_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group CACHE64_POLSEL_Register_Masks */


/* CACHE64_POLSEL - Peripheral instance base addresses */
/** Peripheral CACHE64_POLSEL base address */
#define CACHE64_POLSEL_BASE                      (0x40033000u)
/** Peripheral CACHE64_POLSEL base pointer */
#define CACHE64_POLSEL                           ((CACHE64_POLSEL_Type *)CACHE64_POLSEL_BASE)
/** Array initializer of CACHE64_POLSEL peripheral base addresses */
#define CACHE64_POLSEL_BASE_ADDRS                { CACHE64_POLSEL_BASE }
/** Array initializer of CACHE64_POLSEL peripheral base pointers */
#define CACHE64_POLSEL_BASE_PTRS                 { CACHE64_POLSEL }

/*!
 * @}
 */ /* end of group CACHE64_POLSEL_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- CLKCTL0 Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CLKCTL0_Peripheral_Access_Layer CLKCTL0 Peripheral Access Layer
 * @{
 */

/** CLKCTL0 - Register Layout Typedef */
typedef struct {
       uint8_t RESERVED_0[16];
  __IO uint32_t PSCCTL0;                           /**< clock control register 0, offset: 0x10 */
  __IO uint32_t PSCCTL1;                           /**< clock control register 1, offset: 0x14 */
  __IO uint32_t PSCCTL2;                           /**< clock control register 2, offset: 0x18 */
       uint8_t RESERVED_1[36];
  __O  uint32_t PSCCTL0_SET;                       /**< clock set register 0, offset: 0x40 */
  __O  uint32_t PSCCTL1_SET;                       /**< clock set register 1, offset: 0x44 */
  __O  uint32_t PSCCTL2_SET;                       /**< clock set register 2, offset: 0x48 */
       uint8_t RESERVED_2[36];
  __O  uint32_t PSCCTL0_CLR;                       /**< clock clear register 0, offset: 0x70 */
  __O  uint32_t PSCCTL1_CLR;                       /**< clock clear register 1, offset: 0x74 */
  __O  uint32_t PSCCTL2_CLR;                       /**< clock clear register 2, offset: 0x78 */
       uint8_t RESERVED_3[132];
  __IO uint32_t FFROCTL0;                          /**< FFRO control 0, offset: 0x100 */
  __IO uint32_t FFROCTL1;                          /**< FFRO control 1, offset: 0x104 */
       uint8_t RESERVED_4[88];
  __IO uint32_t SYSOSCCTL0;                        /**< system oscillator control 0, offset: 0x160 */
       uint8_t RESERVED_5[4];
  __IO uint32_t SYSOSCBYPASS;                      /**< system oscillator bypass, offset: 0x168 */
       uint8_t RESERVED_6[36];
  __IO uint32_t LPOSCCTL0;                         /**< low power oscillator control 0, offset: 0x190 */
       uint8_t RESERVED_7[44];
  __IO uint32_t OSC32KHZCTL0;                      /**< 32k oscillator control0, offset: 0x1C0 */
       uint8_t RESERVED_8[60];
  __IO uint32_t SYSPLL0CLKSEL;                     /**< system pll0 clock selection, offset: 0x200 */
  __IO uint32_t SYSPLL0CTL0;                       /**< system pll0 control0, offset: 0x204 */
       uint8_t RESERVED_9[4];
  __IO uint32_t SYSPLL0LOCKTIMEDIV2;               /**< system pll0 lock time, offset: 0x20C */
  __IO uint32_t SYSPLL0NUM;                        /**< system pll0 number, offset: 0x210 */
  __IO uint32_t SYSPLL0DENOM;                      /**< system pll0 denom, offset: 0x214 */
  __IO uint32_t SYSPLL0PFD;                        /**< sys pll0 PFD, offset: 0x218 */
       uint8_t RESERVED_10[36];
  __IO uint32_t MAINPLLCLKDIV;                     /**< main pll clk divider, offset: 0x240 */
  __IO uint32_t DSPPLLCLKDIV;                      /**< dsp pll clk divider, offset: 0x244 */
  __IO uint32_t AUX0PLLCLKDIV;                     /**< aux0 pll clk divider, offset: 0x248 */
  __IO uint32_t AUX1PLLCLKDIV;                     /**< aux1 pll clk divider, offset: 0x24C */
       uint8_t RESERVED_11[432];
  __IO uint32_t SYSCPUAHBCLKDIV;                   /**< system cpu AHB clock divider, offset: 0x400 */
       uint8_t RESERVED_12[44];
  __IO uint32_t MAINCLKSELA;                       /**< main clock selection A, offset: 0x430 */
  __IO uint32_t MAINCLKSELB;                       /**< main clock selection B, offset: 0x434 */
       uint8_t RESERVED_13[200];
  __IO uint32_t PFCDIV[2];                         /**< PFC divider register N, array offset: 0x500, array step: 0x4 */
       uint8_t RESERVED_14[280];
  __IO uint32_t FLEXSPIFCLKSEL;                    /**< FlexSPI FCLK selection, offset: 0x620 */
  __IO uint32_t FLEXSPIFCLKDIV;                    /**< FlexSPI FCLK divider, offset: 0x624 */
       uint8_t RESERVED_15[24];
  __IO uint32_t SCTFCLKSEL;                        /**< SCT FCLK selection, offset: 0x640 */
  __IO uint32_t SCTFCLKDIV;                        /**< SCT fclk divider, offset: 0x644 */
       uint8_t RESERVED_16[24];
  __IO uint32_t USBHSFCLKSEL;                      /**< USBHS Fclk selection, offset: 0x660 */
  __IO uint32_t USBHSFCLKDIV;                      /**< USBHS Fclk divider, offset: 0x664 */
       uint8_t RESERVED_17[24];
  __IO uint32_t SDIO0FCLKSEL;                      /**< SDIO0 FCLK selection, offset: 0x680 */
  __IO uint32_t SDIO0FCLKDIV;                      /**< SDIO0 FCLK divider, offset: 0x684 */
       uint8_t RESERVED_18[8];
  __IO uint32_t SDIO1FCLKSEL;                      /**< SDIO1 FCLK selection, offset: 0x690 */
  __IO uint32_t SDIO1FCLKDIV;                      /**< SDIO1 FCLK divider, offset: 0x694 */
       uint8_t RESERVED_19[56];
  __IO uint32_t ADC0FCLKSEL0;                      /**< ADC0 fclk selection 0, offset: 0x6D0 */
  __IO uint32_t ADC0FCLKSEL1;                      /**< ADC0 fclk selection 1, offset: 0x6D4 */
  __IO uint32_t ADC0FCLKDIV;                       /**< ADC0 fclk divider, offset: 0x6D8 */
       uint8_t RESERVED_20[36];
  __IO uint32_t UTICKFCLKSEL;                      /**< UTICK fclk selection, offset: 0x700 */
       uint8_t RESERVED_21[28];
  __IO uint32_t WDT0FCLKSEL;                       /**< wdt clock selection, offset: 0x720 */
       uint8_t RESERVED_22[12];
  __IO uint32_t WAKECLK32KHZSEL;                   /**< 32k wake clock selection, offset: 0x730 */
  __IO uint32_t WAKECLK32KHZDIV;                   /**< 32k wake clock divider, offset: 0x734 */
       uint8_t RESERVED_23[40];
  __IO uint32_t SYSTICKFCLKSEL;                    /**< system tick fclk selection, offset: 0x760 */
  __IO uint32_t SYSTICKFCLKDIV;                    /**< system tick fclk divider, offset: 0x764 */
} CLKCTL0_Type;

/* ----------------------------------------------------------------------------
   -- CLKCTL0 Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CLKCTL0_Register_Masks CLKCTL0 Register Masks
 * @{
 */

/*! @name PSCCTL0 - clock control register 0 */
/*! @{ */

#define CLKCTL0_PSCCTL0_ROM_CTL_128KB_MASK       (0x4U)
#define CLKCTL0_PSCCTL0_ROM_CTL_128KB_SHIFT      (2U)
/*! ROM_CTL_128KB - 128KB ROM control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL0_PSCCTL0_ROM_CTL_128KB(x)         (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_ROM_CTL_128KB_SHIFT)) & CLKCTL0_PSCCTL0_ROM_CTL_128KB_MASK)

#define CLKCTL0_PSCCTL0_POWERQUAD_CLK_MASK       (0x100U)
#define CLKCTL0_PSCCTL0_POWERQUAD_CLK_SHIFT      (8U)
/*! POWERQUAD_CLK - powerquad clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL0_PSCCTL0_POWERQUAD_CLK(x)         (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_POWERQUAD_CLK_SHIFT)) & CLKCTL0_PSCCTL0_POWERQUAD_CLK_MASK)

#define CLKCTL0_PSCCTL0_CASPER_CLK_MASK          (0x200U)
#define CLKCTL0_PSCCTL0_CASPER_CLK_SHIFT         (9U)
/*! CASPER_CLK - CAPSER clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL0_PSCCTL0_CASPER_CLK(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_CASPER_CLK_SHIFT)) & CLKCTL0_PSCCTL0_CASPER_CLK_MASK)

#define CLKCTL0_PSCCTL0_HASHCRYPT_CLK_MASK       (0x400U)
#define CLKCTL0_PSCCTL0_HASHCRYPT_CLK_SHIFT      (10U)
/*! HASHCRYPT_CLK - HASHCRYPT clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL0_PSCCTL0_HASHCRYPT_CLK(x)         (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_HASHCRYPT_CLK_SHIFT)) & CLKCTL0_PSCCTL0_HASHCRYPT_CLK_MASK)

#define CLKCTL0_PSCCTL0_PUF_CLK_MASK             (0x800U)
#define CLKCTL0_PSCCTL0_PUF_CLK_SHIFT            (11U)
/*! PUF_CLK - PUF clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL0_PSCCTL0_PUF_CLK(x)               (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_PUF_CLK_SHIFT)) & CLKCTL0_PSCCTL0_PUF_CLK_MASK)

#define CLKCTL0_PSCCTL0_RNG_CLK_MASK             (0x1000U)
#define CLKCTL0_PSCCTL0_RNG_CLK_SHIFT            (12U)
/*! RNG_CLK - RNG clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL0_PSCCTL0_RNG_CLK(x)               (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_RNG_CLK_SHIFT)) & CLKCTL0_PSCCTL0_RNG_CLK_MASK)

#define CLKCTL0_PSCCTL0_FLEXSPI_OTFAD_CLK_MASK   (0x10000U)
#define CLKCTL0_PSCCTL0_FLEXSPI_OTFAD_CLK_SHIFT  (16U)
/*! FLEXSPI_OTFAD_CLK - FLEXSPI clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL0_PSCCTL0_FLEXSPI_OTFAD_CLK(x)     (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_FLEXSPI_OTFAD_CLK_SHIFT)) & CLKCTL0_PSCCTL0_FLEXSPI_OTFAD_CLK_MASK)

#define CLKCTL0_PSCCTL0_OTP_CLK_MASK             (0x20000U)
#define CLKCTL0_PSCCTL0_OTP_CLK_SHIFT            (17U)
/*! OTP_CLK - OTP clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL0_PSCCTL0_OTP_CLK(x)               (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_OTP_CLK_SHIFT)) & CLKCTL0_PSCCTL0_OTP_CLK_MASK)

#define CLKCTL0_PSCCTL0_USBHS_PHY_CLK_MASK       (0x100000U)
#define CLKCTL0_PSCCTL0_USBHS_PHY_CLK_SHIFT      (20U)
/*! USBHS_PHY_CLK - USB PHY clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL0_PSCCTL0_USBHS_PHY_CLK(x)         (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_USBHS_PHY_CLK_SHIFT)) & CLKCTL0_PSCCTL0_USBHS_PHY_CLK_MASK)

#define CLKCTL0_PSCCTL0_USBHS_DEVICE_CLK_MASK    (0x200000U)
#define CLKCTL0_PSCCTL0_USBHS_DEVICE_CLK_SHIFT   (21U)
/*! USBHS_DEVICE_CLK - USB DEVICE clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL0_PSCCTL0_USBHS_DEVICE_CLK(x)      (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_USBHS_DEVICE_CLK_SHIFT)) & CLKCTL0_PSCCTL0_USBHS_DEVICE_CLK_MASK)

#define CLKCTL0_PSCCTL0_USBHS_HOST_CLK_MASK      (0x400000U)
#define CLKCTL0_PSCCTL0_USBHS_HOST_CLK_SHIFT     (22U)
/*! USBHS_HOST_CLK - USB HOST clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL0_PSCCTL0_USBHS_HOST_CLK(x)        (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_USBHS_HOST_CLK_SHIFT)) & CLKCTL0_PSCCTL0_USBHS_HOST_CLK_MASK)

#define CLKCTL0_PSCCTL0_USBHS_SRAM_CLK_MASK      (0x800000U)
#define CLKCTL0_PSCCTL0_USBHS_SRAM_CLK_SHIFT     (23U)
/*! USBHS_SRAM_CLK - USBHS RAM clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL0_PSCCTL0_USBHS_SRAM_CLK(x)        (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_USBHS_SRAM_CLK_SHIFT)) & CLKCTL0_PSCCTL0_USBHS_SRAM_CLK_MASK)

#define CLKCTL0_PSCCTL0_SCT_CLK_MASK             (0x1000000U)
#define CLKCTL0_PSCCTL0_SCT_CLK_SHIFT            (24U)
/*! SCT_CLK - SCT clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL0_PSCCTL0_SCT_CLK(x)               (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_SCT_CLK_SHIFT)) & CLKCTL0_PSCCTL0_SCT_CLK_MASK)
/*! @} */

/*! @name PSCCTL1 - clock control register 1 */
/*! @{ */

#define CLKCTL0_PSCCTL1_SDIO0_CLK_MASK           (0x4U)
#define CLKCTL0_PSCCTL1_SDIO0_CLK_SHIFT          (2U)
/*! SDIO0_CLK - SDIO0 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL0_PSCCTL1_SDIO0_CLK(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL1_SDIO0_CLK_SHIFT)) & CLKCTL0_PSCCTL1_SDIO0_CLK_MASK)

#define CLKCTL0_PSCCTL1_SDIO1_CLK_MASK           (0x8U)
#define CLKCTL0_PSCCTL1_SDIO1_CLK_SHIFT          (3U)
/*! SDIO1_CLK - SDIO1 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL0_PSCCTL1_SDIO1_CLK(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL1_SDIO1_CLK_SHIFT)) & CLKCTL0_PSCCTL1_SDIO1_CLK_MASK)

#define CLKCTL0_PSCCTL1_ACMP0_CLK_MASK           (0x8000U)
#define CLKCTL0_PSCCTL1_ACMP0_CLK_SHIFT          (15U)
/*! ACMP0_CLK - Analog comparator clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL0_PSCCTL1_ACMP0_CLK(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL1_ACMP0_CLK_SHIFT)) & CLKCTL0_PSCCTL1_ACMP0_CLK_MASK)

#define CLKCTL0_PSCCTL1_ADC0_CLK_MASK            (0x10000U)
#define CLKCTL0_PSCCTL1_ADC0_CLK_SHIFT           (16U)
/*! ADC0_CLK - ADC clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL0_PSCCTL1_ADC0_CLK(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL1_ADC0_CLK_SHIFT)) & CLKCTL0_PSCCTL1_ADC0_CLK_MASK)

#define CLKCTL0_PSCCTL1_SHSGPIO0_CLK_MASK        (0x1000000U)
#define CLKCTL0_PSCCTL1_SHSGPIO0_CLK_SHIFT       (24U)
/*! SHSGPIO0_CLK - SHSGPIO0 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL0_PSCCTL1_SHSGPIO0_CLK(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL1_SHSGPIO0_CLK_SHIFT)) & CLKCTL0_PSCCTL1_SHSGPIO0_CLK_MASK)
/*! @} */

/*! @name PSCCTL2 - clock control register 2 */
/*! @{ */

#define CLKCTL0_PSCCTL2_UTICK0_CLK_MASK          (0x1U)
#define CLKCTL0_PSCCTL2_UTICK0_CLK_SHIFT         (0U)
/*! UTICK0_CLK - utick clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL0_PSCCTL2_UTICK0_CLK(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL2_UTICK0_CLK_SHIFT)) & CLKCTL0_PSCCTL2_UTICK0_CLK_MASK)

#define CLKCTL0_PSCCTL2_WWDT0_CLK_MASK           (0x2U)
#define CLKCTL0_PSCCTL2_WWDT0_CLK_SHIFT          (1U)
/*! WWDT0_CLK - wdt clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL0_PSCCTL2_WWDT0_CLK(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL2_WWDT0_CLK_SHIFT)) & CLKCTL0_PSCCTL2_WWDT0_CLK_MASK)
/*! @} */

/*! @name PSCCTL0_SET - clock set register 0 */
/*! @{ */

#define CLKCTL0_PSCCTL0_SET_ROM_CTL_128KB_CLK_MASK (0x4U)
#define CLKCTL0_PSCCTL0_SET_ROM_CTL_128KB_CLK_SHIFT (2U)
/*! ROM_CTL_128KB_CLK - 128KB ROM controller clock set
 *  0b0..No Effect
 *  0b1..Sets the PSCCTL0 Bit
 */
#define CLKCTL0_PSCCTL0_SET_ROM_CTL_128KB_CLK(x) (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_SET_ROM_CTL_128KB_CLK_SHIFT)) & CLKCTL0_PSCCTL0_SET_ROM_CTL_128KB_CLK_MASK)

#define CLKCTL0_PSCCTL0_SET_POWERQUAD_CLK_MASK   (0x100U)
#define CLKCTL0_PSCCTL0_SET_POWERQUAD_CLK_SHIFT  (8U)
/*! POWERQUAD_CLK - powerquad clock set
 *  0b0..No Effect
 *  0b1..Sets the PSCCTL0 Bit
 */
#define CLKCTL0_PSCCTL0_SET_POWERQUAD_CLK(x)     (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_SET_POWERQUAD_CLK_SHIFT)) & CLKCTL0_PSCCTL0_SET_POWERQUAD_CLK_MASK)

#define CLKCTL0_PSCCTL0_SET_CASPER_CLK_MASK      (0x200U)
#define CLKCTL0_PSCCTL0_SET_CASPER_CLK_SHIFT     (9U)
/*! CASPER_CLK - CAPSER clock set
 *  0b0..No Effect
 *  0b1..Sets the PSCCTL0 Bit
 */
#define CLKCTL0_PSCCTL0_SET_CASPER_CLK(x)        (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_SET_CASPER_CLK_SHIFT)) & CLKCTL0_PSCCTL0_SET_CASPER_CLK_MASK)

#define CLKCTL0_PSCCTL0_SET_HASHCRYPT_CLK_MASK   (0x400U)
#define CLKCTL0_PSCCTL0_SET_HASHCRYPT_CLK_SHIFT  (10U)
/*! HASHCRYPT_CLK - HASHCRYPT clock set
 *  0b0..No Effect
 *  0b1..Sets the PSCCTL0 Bit
 */
#define CLKCTL0_PSCCTL0_SET_HASHCRYPT_CLK(x)     (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_SET_HASHCRYPT_CLK_SHIFT)) & CLKCTL0_PSCCTL0_SET_HASHCRYPT_CLK_MASK)

#define CLKCTL0_PSCCTL0_SET_PUF_CLK_MASK         (0x800U)
#define CLKCTL0_PSCCTL0_SET_PUF_CLK_SHIFT        (11U)
/*! PUF_CLK - PUF clock set
 *  0b0..No Effect
 *  0b1..Sets the PSCCTL0 Bit
 */
#define CLKCTL0_PSCCTL0_SET_PUF_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_SET_PUF_CLK_SHIFT)) & CLKCTL0_PSCCTL0_SET_PUF_CLK_MASK)

#define CLKCTL0_PSCCTL0_SET_RNG_CLK_MASK         (0x1000U)
#define CLKCTL0_PSCCTL0_SET_RNG_CLK_SHIFT        (12U)
/*! RNG_CLK - RNG clock set
 *  0b0..No Effect
 *  0b1..Sets the PSCCTL0 Bit
 */
#define CLKCTL0_PSCCTL0_SET_RNG_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_SET_RNG_CLK_SHIFT)) & CLKCTL0_PSCCTL0_SET_RNG_CLK_MASK)

#define CLKCTL0_PSCCTL0_SET_FLEXSPI_OTFAD_CLK_MASK (0x10000U)
#define CLKCTL0_PSCCTL0_SET_FLEXSPI_OTFAD_CLK_SHIFT (16U)
/*! FLEXSPI_OTFAD_CLK - FLEXSPI clock set
 *  0b0..No Effect
 *  0b1..Sets the PSCCTL0 Bit
 */
#define CLKCTL0_PSCCTL0_SET_FLEXSPI_OTFAD_CLK(x) (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_SET_FLEXSPI_OTFAD_CLK_SHIFT)) & CLKCTL0_PSCCTL0_SET_FLEXSPI_OTFAD_CLK_MASK)

#define CLKCTL0_PSCCTL0_SET_OTP_CLK_MASK         (0x20000U)
#define CLKCTL0_PSCCTL0_SET_OTP_CLK_SHIFT        (17U)
/*! OTP_CLK - OTP clock set
 *  0b0..No Effect
 *  0b1..Sets the PSCCTL0 Bit
 */
#define CLKCTL0_PSCCTL0_SET_OTP_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_SET_OTP_CLK_SHIFT)) & CLKCTL0_PSCCTL0_SET_OTP_CLK_MASK)

#define CLKCTL0_PSCCTL0_SET_USBHS_PHY_CLK_MASK   (0x100000U)
#define CLKCTL0_PSCCTL0_SET_USBHS_PHY_CLK_SHIFT  (20U)
/*! USBHS_PHY_CLK - USB PHY clock set
 *  0b0..No Effect
 *  0b1..Sets the PSCCTL0 Bit
 */
#define CLKCTL0_PSCCTL0_SET_USBHS_PHY_CLK(x)     (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_SET_USBHS_PHY_CLK_SHIFT)) & CLKCTL0_PSCCTL0_SET_USBHS_PHY_CLK_MASK)

#define CLKCTL0_PSCCTL0_SET_USBHS_DEVICE_CLK_MASK (0x200000U)
#define CLKCTL0_PSCCTL0_SET_USBHS_DEVICE_CLK_SHIFT (21U)
/*! USBHS_DEVICE_CLK - USB DEVICE clock set
 *  0b0..No Effect
 *  0b1..Sets the PSCCTL0 Bit
 */
#define CLKCTL0_PSCCTL0_SET_USBHS_DEVICE_CLK(x)  (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_SET_USBHS_DEVICE_CLK_SHIFT)) & CLKCTL0_PSCCTL0_SET_USBHS_DEVICE_CLK_MASK)

#define CLKCTL0_PSCCTL0_SET_USBHS_HOST_CLK_MASK  (0x400000U)
#define CLKCTL0_PSCCTL0_SET_USBHS_HOST_CLK_SHIFT (22U)
/*! USBHS_HOST_CLK - USB HOST clock set
 *  0b0..No Effect
 *  0b1..Sets the PSCCTL0 Bit
 */
#define CLKCTL0_PSCCTL0_SET_USBHS_HOST_CLK(x)    (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_SET_USBHS_HOST_CLK_SHIFT)) & CLKCTL0_PSCCTL0_SET_USBHS_HOST_CLK_MASK)

#define CLKCTL0_PSCCTL0_SET_USBHS_SRAM_CLK_MASK  (0x800000U)
#define CLKCTL0_PSCCTL0_SET_USBHS_SRAM_CLK_SHIFT (23U)
/*! USBHS_SRAM_CLK - USBHS RAM clock set
 *  0b0..No Effect
 *  0b1..Sets the PSCCTL0 Bit
 */
#define CLKCTL0_PSCCTL0_SET_USBHS_SRAM_CLK(x)    (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_SET_USBHS_SRAM_CLK_SHIFT)) & CLKCTL0_PSCCTL0_SET_USBHS_SRAM_CLK_MASK)

#define CLKCTL0_PSCCTL0_SET_SCT_CLK_MASK         (0x1000000U)
#define CLKCTL0_PSCCTL0_SET_SCT_CLK_SHIFT        (24U)
/*! SCT_CLK - SCT clock set
 *  0b0..No Effect
 *  0b1..Sets the PSCCTL0 Bit
 */
#define CLKCTL0_PSCCTL0_SET_SCT_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_SET_SCT_CLK_SHIFT)) & CLKCTL0_PSCCTL0_SET_SCT_CLK_MASK)
/*! @} */

/*! @name PSCCTL1_SET - clock set register 1 */
/*! @{ */

#define CLKCTL0_PSCCTL1_SET_SDIO0_CLK_MASK       (0x4U)
#define CLKCTL0_PSCCTL1_SET_SDIO0_CLK_SHIFT      (2U)
/*! SDIO0_CLK - SDIO0 clock set
 *  0b0..No Effect
 *  0b1..Sets the PSCCTL1 Bit
 */
#define CLKCTL0_PSCCTL1_SET_SDIO0_CLK(x)         (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL1_SET_SDIO0_CLK_SHIFT)) & CLKCTL0_PSCCTL1_SET_SDIO0_CLK_MASK)

#define CLKCTL0_PSCCTL1_SET_SDIO1_CLK_MASK       (0x8U)
#define CLKCTL0_PSCCTL1_SET_SDIO1_CLK_SHIFT      (3U)
/*! SDIO1_CLK - SDIO1 clock set
 *  0b0..No Effect
 *  0b1..Sets the PSCCTL1 Bit
 */
#define CLKCTL0_PSCCTL1_SET_SDIO1_CLK(x)         (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL1_SET_SDIO1_CLK_SHIFT)) & CLKCTL0_PSCCTL1_SET_SDIO1_CLK_MASK)

#define CLKCTL0_PSCCTL1_SET_ACMP0_CLK_MASK       (0x8000U)
#define CLKCTL0_PSCCTL1_SET_ACMP0_CLK_SHIFT      (15U)
/*! ACMP0_CLK - Analog comparator clock set
 *  0b0..No Effect
 *  0b1..Sets the PSCCTL1 Bit
 */
#define CLKCTL0_PSCCTL1_SET_ACMP0_CLK(x)         (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL1_SET_ACMP0_CLK_SHIFT)) & CLKCTL0_PSCCTL1_SET_ACMP0_CLK_MASK)

#define CLKCTL0_PSCCTL1_SET_ADC0_CLK_MASK        (0x10000U)
#define CLKCTL0_PSCCTL1_SET_ADC0_CLK_SHIFT       (16U)
/*! ADC0_CLK - ADC clock set
 *  0b0..No Effect
 *  0b1..Sets the PSCCTL1 Bit
 */
#define CLKCTL0_PSCCTL1_SET_ADC0_CLK(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL1_SET_ADC0_CLK_SHIFT)) & CLKCTL0_PSCCTL1_SET_ADC0_CLK_MASK)

#define CLKCTL0_PSCCTL1_SET_SHSGPIO0_CLK_MASK    (0x1000000U)
#define CLKCTL0_PSCCTL1_SET_SHSGPIO0_CLK_SHIFT   (24U)
/*! SHSGPIO0_CLK - SHSGPIO0 clock set
 *  0b0..No Effect
 *  0b1..Sets the PSCCTL1 Bit
 */
#define CLKCTL0_PSCCTL1_SET_SHSGPIO0_CLK(x)      (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL1_SET_SHSGPIO0_CLK_SHIFT)) & CLKCTL0_PSCCTL1_SET_SHSGPIO0_CLK_MASK)
/*! @} */

/*! @name PSCCTL2_SET - clock set register 2 */
/*! @{ */

#define CLKCTL0_PSCCTL2_SET_UTICK0_CLK_MASK      (0x1U)
#define CLKCTL0_PSCCTL2_SET_UTICK0_CLK_SHIFT     (0U)
/*! UTICK0_CLK - utick clock set
 *  0b0..No Effect
 *  0b1..Sets the PSCCTL2 Bit
 */
#define CLKCTL0_PSCCTL2_SET_UTICK0_CLK(x)        (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL2_SET_UTICK0_CLK_SHIFT)) & CLKCTL0_PSCCTL2_SET_UTICK0_CLK_MASK)

#define CLKCTL0_PSCCTL2_SET_WWDT0_CLK_MASK       (0x2U)
#define CLKCTL0_PSCCTL2_SET_WWDT0_CLK_SHIFT      (1U)
/*! WWDT0_CLK - wdt clock set
 *  0b0..No Effect
 *  0b1..Sets the PSCCTL2 Bit
 */
#define CLKCTL0_PSCCTL2_SET_WWDT0_CLK(x)         (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL2_SET_WWDT0_CLK_SHIFT)) & CLKCTL0_PSCCTL2_SET_WWDT0_CLK_MASK)
/*! @} */

/*! @name PSCCTL0_CLR - clock clear register 0 */
/*! @{ */

#define CLKCTL0_PSCCTL0_CLR_ROM_CTL_128KB_CLK_MASK (0x4U)
#define CLKCTL0_PSCCTL0_CLR_ROM_CTL_128KB_CLK_SHIFT (2U)
/*! ROM_CTL_128KB_CLK - ROM controller clock clear
 *  0b0..No Effect
 *  0b1..Clears the PSCCTL0 Bit
 */
#define CLKCTL0_PSCCTL0_CLR_ROM_CTL_128KB_CLK(x) (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_CLR_ROM_CTL_128KB_CLK_SHIFT)) & CLKCTL0_PSCCTL0_CLR_ROM_CTL_128KB_CLK_MASK)

#define CLKCTL0_PSCCTL0_CLR_POWERQUAD_CLK_MASK   (0x100U)
#define CLKCTL0_PSCCTL0_CLR_POWERQUAD_CLK_SHIFT  (8U)
/*! POWERQUAD_CLK - powerquad clock clear
 *  0b0..No Effect
 *  0b1..Clears the PSCCTL0 Bit
 */
#define CLKCTL0_PSCCTL0_CLR_POWERQUAD_CLK(x)     (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_CLR_POWERQUAD_CLK_SHIFT)) & CLKCTL0_PSCCTL0_CLR_POWERQUAD_CLK_MASK)

#define CLKCTL0_PSCCTL0_CLR_CASPER_CLK_MASK      (0x200U)
#define CLKCTL0_PSCCTL0_CLR_CASPER_CLK_SHIFT     (9U)
/*! CASPER_CLK - CAPSER clock clear
 *  0b0..No Effect
 *  0b1..Clears the PSCCTL0 Bit
 */
#define CLKCTL0_PSCCTL0_CLR_CASPER_CLK(x)        (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_CLR_CASPER_CLK_SHIFT)) & CLKCTL0_PSCCTL0_CLR_CASPER_CLK_MASK)

#define CLKCTL0_PSCCTL0_CLR_HASHCRYPT_CLK_MASK   (0x400U)
#define CLKCTL0_PSCCTL0_CLR_HASHCRYPT_CLK_SHIFT  (10U)
/*! HASHCRYPT_CLK - HASHCRYPT clock clear
 *  0b0..No Effect
 *  0b1..Clears the PSCCTL0 Bit
 */
#define CLKCTL0_PSCCTL0_CLR_HASHCRYPT_CLK(x)     (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_CLR_HASHCRYPT_CLK_SHIFT)) & CLKCTL0_PSCCTL0_CLR_HASHCRYPT_CLK_MASK)

#define CLKCTL0_PSCCTL0_CLR_PUF_CLK_MASK         (0x800U)
#define CLKCTL0_PSCCTL0_CLR_PUF_CLK_SHIFT        (11U)
/*! PUF_CLK - PUF clock clear
 *  0b0..No Effect
 *  0b1..Clears the PSCCTL0 Bit
 */
#define CLKCTL0_PSCCTL0_CLR_PUF_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_CLR_PUF_CLK_SHIFT)) & CLKCTL0_PSCCTL0_CLR_PUF_CLK_MASK)

#define CLKCTL0_PSCCTL0_CLR_RNG_CLK_MASK         (0x1000U)
#define CLKCTL0_PSCCTL0_CLR_RNG_CLK_SHIFT        (12U)
/*! RNG_CLK - RNG clock clear
 *  0b0..No Effect
 *  0b1..Clears the PSCCTL0 Bit
 */
#define CLKCTL0_PSCCTL0_CLR_RNG_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_CLR_RNG_CLK_SHIFT)) & CLKCTL0_PSCCTL0_CLR_RNG_CLK_MASK)

#define CLKCTL0_PSCCTL0_CLR_FLEXSPI_OTFAD_CLK_MASK (0x10000U)
#define CLKCTL0_PSCCTL0_CLR_FLEXSPI_OTFAD_CLK_SHIFT (16U)
/*! FLEXSPI_OTFAD_CLK - FLEXSPI clock clear
 *  0b0..No Effect
 *  0b1..Clears the PSCCTL0 Bit
 */
#define CLKCTL0_PSCCTL0_CLR_FLEXSPI_OTFAD_CLK(x) (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_CLR_FLEXSPI_OTFAD_CLK_SHIFT)) & CLKCTL0_PSCCTL0_CLR_FLEXSPI_OTFAD_CLK_MASK)

#define CLKCTL0_PSCCTL0_CLR_OTP_CLK_MASK         (0x20000U)
#define CLKCTL0_PSCCTL0_CLR_OTP_CLK_SHIFT        (17U)
/*! OTP_CLK - OTP clock clear
 *  0b0..No Effect
 *  0b1..Clears the PSCCTL0 Bit
 */
#define CLKCTL0_PSCCTL0_CLR_OTP_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_CLR_OTP_CLK_SHIFT)) & CLKCTL0_PSCCTL0_CLR_OTP_CLK_MASK)

#define CLKCTL0_PSCCTL0_CLR_USBHS_PHY_CLK_MASK   (0x100000U)
#define CLKCTL0_PSCCTL0_CLR_USBHS_PHY_CLK_SHIFT  (20U)
/*! USBHS_PHY_CLK - USB PHY clock clear
 *  0b0..No Effect
 *  0b1..Clears the PSCCTL0 Bit
 */
#define CLKCTL0_PSCCTL0_CLR_USBHS_PHY_CLK(x)     (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_CLR_USBHS_PHY_CLK_SHIFT)) & CLKCTL0_PSCCTL0_CLR_USBHS_PHY_CLK_MASK)

#define CLKCTL0_PSCCTL0_CLR_USBHS_DEVICE_CLK_MASK (0x200000U)
#define CLKCTL0_PSCCTL0_CLR_USBHS_DEVICE_CLK_SHIFT (21U)
/*! USBHS_DEVICE_CLK - USB DEVICE clock clear
 *  0b0..No Effect
 *  0b1..Clears the PSCCTL0 Bit
 */
#define CLKCTL0_PSCCTL0_CLR_USBHS_DEVICE_CLK(x)  (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_CLR_USBHS_DEVICE_CLK_SHIFT)) & CLKCTL0_PSCCTL0_CLR_USBHS_DEVICE_CLK_MASK)

#define CLKCTL0_PSCCTL0_CLR_USBHS_HOST_CLK_MASK  (0x400000U)
#define CLKCTL0_PSCCTL0_CLR_USBHS_HOST_CLK_SHIFT (22U)
/*! USBHS_HOST_CLK - USB HOST clock clear
 *  0b0..No Effect
 *  0b1..Clears the PSCCTL0 Bit
 */
#define CLKCTL0_PSCCTL0_CLR_USBHS_HOST_CLK(x)    (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_CLR_USBHS_HOST_CLK_SHIFT)) & CLKCTL0_PSCCTL0_CLR_USBHS_HOST_CLK_MASK)

#define CLKCTL0_PSCCTL0_CLR_USBHS_SRAM_CLK_MASK  (0x800000U)
#define CLKCTL0_PSCCTL0_CLR_USBHS_SRAM_CLK_SHIFT (23U)
/*! USBHS_SRAM_CLK - USBHS RAM clock clear
 *  0b0..No Effect
 *  0b1..Clears the PSCCTL0 Bit
 */
#define CLKCTL0_PSCCTL0_CLR_USBHS_SRAM_CLK(x)    (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_CLR_USBHS_SRAM_CLK_SHIFT)) & CLKCTL0_PSCCTL0_CLR_USBHS_SRAM_CLK_MASK)

#define CLKCTL0_PSCCTL0_CLR_SCT_CLK_MASK         (0x1000000U)
#define CLKCTL0_PSCCTL0_CLR_SCT_CLK_SHIFT        (24U)
/*! SCT_CLK - SCT clock clear
 *  0b0..No Effect
 *  0b1..Clears the PSCCTL0 Bit
 */
#define CLKCTL0_PSCCTL0_CLR_SCT_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_CLR_SCT_CLK_SHIFT)) & CLKCTL0_PSCCTL0_CLR_SCT_CLK_MASK)
/*! @} */

/*! @name PSCCTL1_CLR - clock clear register 1 */
/*! @{ */

#define CLKCTL0_PSCCTL1_CLR_SDIO0_CLK_MASK       (0x4U)
#define CLKCTL0_PSCCTL1_CLR_SDIO0_CLK_SHIFT      (2U)
/*! SDIO0_CLK - SDIO0 clock clear
 *  0b0..No Effect
 *  0b1..Clears the PSCCTL1 Bit
 */
#define CLKCTL0_PSCCTL1_CLR_SDIO0_CLK(x)         (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL1_CLR_SDIO0_CLK_SHIFT)) & CLKCTL0_PSCCTL1_CLR_SDIO0_CLK_MASK)

#define CLKCTL0_PSCCTL1_CLR_SDIO1_CLK_MASK       (0x8U)
#define CLKCTL0_PSCCTL1_CLR_SDIO1_CLK_SHIFT      (3U)
/*! SDIO1_CLK - SDIO1 clock clear
 *  0b0..No Effect
 *  0b1..Clears the PSCCTL1 Bit
 */
#define CLKCTL0_PSCCTL1_CLR_SDIO1_CLK(x)         (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL1_CLR_SDIO1_CLK_SHIFT)) & CLKCTL0_PSCCTL1_CLR_SDIO1_CLK_MASK)

#define CLKCTL0_PSCCTL1_CLR_ACMP0_CLK_MASK       (0x8000U)
#define CLKCTL0_PSCCTL1_CLR_ACMP0_CLK_SHIFT      (15U)
/*! ACMP0_CLK - Analog comparator clock clear
 *  0b0..No Effect
 *  0b1..Clears the PSCCTL1 Bit
 */
#define CLKCTL0_PSCCTL1_CLR_ACMP0_CLK(x)         (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL1_CLR_ACMP0_CLK_SHIFT)) & CLKCTL0_PSCCTL1_CLR_ACMP0_CLK_MASK)

#define CLKCTL0_PSCCTL1_CLR_ADC0_CLK_MASK        (0x10000U)
#define CLKCTL0_PSCCTL1_CLR_ADC0_CLK_SHIFT       (16U)
/*! ADC0_CLK - ADC clock clear
 *  0b0..No Effect
 *  0b1..Clears the PSCCTL1 Bit
 */
#define CLKCTL0_PSCCTL1_CLR_ADC0_CLK(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL1_CLR_ADC0_CLK_SHIFT)) & CLKCTL0_PSCCTL1_CLR_ADC0_CLK_MASK)

#define CLKCTL0_PSCCTL1_CLR_SHSGPIO0_CLK_MASK    (0x1000000U)
#define CLKCTL0_PSCCTL1_CLR_SHSGPIO0_CLK_SHIFT   (24U)
/*! SHSGPIO0_CLK - SHSGPIO0 clock clear
 *  0b0..No Effect
 *  0b1..Clears the PSCCTL1 Bit
 */
#define CLKCTL0_PSCCTL1_CLR_SHSGPIO0_CLK(x)      (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL1_CLR_SHSGPIO0_CLK_SHIFT)) & CLKCTL0_PSCCTL1_CLR_SHSGPIO0_CLK_MASK)
/*! @} */

/*! @name PSCCTL2_CLR - clock clear register 2 */
/*! @{ */

#define CLKCTL0_PSCCTL2_CLR_UTICK0_CLK_MASK      (0x1U)
#define CLKCTL0_PSCCTL2_CLR_UTICK0_CLK_SHIFT     (0U)
/*! UTICK0_CLK - utick clock clear
 *  0b0..No Effect
 *  0b1..Clears the PSCCTL2 Bit
 */
#define CLKCTL0_PSCCTL2_CLR_UTICK0_CLK(x)        (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL2_CLR_UTICK0_CLK_SHIFT)) & CLKCTL0_PSCCTL2_CLR_UTICK0_CLK_MASK)

#define CLKCTL0_PSCCTL2_CLR_WWDT0_CLK_MASK       (0x2U)
#define CLKCTL0_PSCCTL2_CLR_WWDT0_CLK_SHIFT      (1U)
/*! WWDT0_CLK - wdt clock clear
 *  0b0..No Effect
 *  0b1..Clears the PSCCTL2 Bit
 */
#define CLKCTL0_PSCCTL2_CLR_WWDT0_CLK(x)         (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL2_CLR_WWDT0_CLK_SHIFT)) & CLKCTL0_PSCCTL2_CLR_WWDT0_CLK_MASK)
/*! @} */

/*! @name FFROCTL0 - FFRO control 0 */
/*! @{ */

#define CLKCTL0_FFROCTL0_TRIM_TEMPCO_MASK        (0x1FU)
#define CLKCTL0_FFROCTL0_TRIM_TEMPCO_SHIFT       (0U)
/*! TRIM_TEMPCO - Trims temperature compensation of FFRO.
 */
#define CLKCTL0_FFROCTL0_TRIM_TEMPCO(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL0_FFROCTL0_TRIM_TEMPCO_SHIFT)) & CLKCTL0_FFROCTL0_TRIM_TEMPCO_MASK)

#define CLKCTL0_FFROCTL0_TRIM_COARSE_MASK        (0x7E0U)
#define CLKCTL0_FFROCTL0_TRIM_COARSE_SHIFT       (5U)
/*! TRIM_COARSE - Trims coarse frequency of FFRO.
 */
#define CLKCTL0_FFROCTL0_TRIM_COARSE(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL0_FFROCTL0_TRIM_COARSE_SHIFT)) & CLKCTL0_FFROCTL0_TRIM_COARSE_MASK)

#define CLKCTL0_FFROCTL0_TRIM_FINE_MASK          (0x3F800U)
#define CLKCTL0_FFROCTL0_TRIM_FINE_SHIFT         (11U)
/*! TRIM_FINE - Trims fine frequency of FFRO.
 */
#define CLKCTL0_FFROCTL0_TRIM_FINE(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL0_FFROCTL0_TRIM_FINE_SHIFT)) & CLKCTL0_FFROCTL0_TRIM_FINE_MASK)

#define CLKCTL0_FFROCTL0_TRIM_RANGE_MASK         (0xC0000U)
#define CLKCTL0_FFROCTL0_TRIM_RANGE_SHIFT        (18U)
/*! TRIM_RANGE - Trims frequency range of FFRO.
 *  0b00..48MHz.
 *  0b01..RESERVED.
 *  0b10..RESERVED.
 *  0b11..60MHz.
 */
#define CLKCTL0_FFROCTL0_TRIM_RANGE(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL0_FFROCTL0_TRIM_RANGE_SHIFT)) & CLKCTL0_FFROCTL0_TRIM_RANGE_MASK)
/*! @} */

/*! @name FFROCTL1 - FFRO control 1 */
/*! @{ */

#define CLKCTL0_FFROCTL1_UPDATE_MASK             (0x1U)
#define CLKCTL0_FFROCTL1_UPDATE_SHIFT            (0U)
/*! UPDATE - Update Safe Mode Control. In order to change any of the TRIM values, the user first
 *    needs to set the update safe mode bit, then proceed to change the respective TRIM values needed,
 *    followed by clearing the update safe mode bit.
 *  0b0..Normal Mode.
 *  0b1..Update Safe Mode.
 */
#define CLKCTL0_FFROCTL1_UPDATE(x)               (((uint32_t)(((uint32_t)(x)) << CLKCTL0_FFROCTL1_UPDATE_SHIFT)) & CLKCTL0_FFROCTL1_UPDATE_MASK)
/*! @} */

/*! @name SYSOSCCTL0 - system oscillator control 0 */
/*! @{ */

#define CLKCTL0_SYSOSCCTL0_LP_ENABLE_MASK        (0x1U)
#define CLKCTL0_SYSOSCCTL0_LP_ENABLE_SHIFT       (0U)
/*! LP_ENABLE - Enable signal for low power mode. . .
 *  0b0..High Gain Mode(HP).
 *  0b1..Low Power mode (LP).
 */
#define CLKCTL0_SYSOSCCTL0_LP_ENABLE(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SYSOSCCTL0_LP_ENABLE_SHIFT)) & CLKCTL0_SYSOSCCTL0_LP_ENABLE_MASK)

#define CLKCTL0_SYSOSCCTL0_BYPASS_ENABLE_MASK    (0x2U)
#define CLKCTL0_SYSOSCCTL0_BYPASS_ENABLE_SHIFT   (1U)
/*! BYPASS_ENABLE - Enable signal for external bypass clock. . .
 *  0b0..Normal Mode.
 *  0b1..Bypass Mode.
 */
#define CLKCTL0_SYSOSCCTL0_BYPASS_ENABLE(x)      (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SYSOSCCTL0_BYPASS_ENABLE_SHIFT)) & CLKCTL0_SYSOSCCTL0_BYPASS_ENABLE_MASK)
/*! @} */

/*! @name SYSOSCBYPASS - system oscillator bypass */
/*! @{ */

#define CLKCTL0_SYSOSCBYPASS_SEL_MASK            (0x7U)
#define CLKCTL0_SYSOSCBYPASS_SEL_SHIFT           (0U)
/*! SEL - Extenal Clock Source Selection.
 *  0b000..External XTAL Clock.
 *  0b001..Clock IN Clock.
 *  0b010..Reserved.
 *  0b011..Reserved.
 *  0b100..Reserved.
 *  0b101..Reserved.
 *  0b110..Reserved.
 *  0b111..NONE.this may be selected in order to reduce power when no output is needed.
 */
#define CLKCTL0_SYSOSCBYPASS_SEL(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SYSOSCBYPASS_SEL_SHIFT)) & CLKCTL0_SYSOSCBYPASS_SEL_MASK)
/*! @} */

/*! @name LPOSCCTL0 - low power oscillator control 0 */
/*! @{ */

#define CLKCTL0_LPOSCCTL0_CLKRDY_MASK            (0x80000000U)
#define CLKCTL0_LPOSCCTL0_CLKRDY_SHIFT           (31U)
/*! CLKRDY - Clock ready flag status. LPOSC clock ready takes 64uS.
 */
#define CLKCTL0_LPOSCCTL0_CLKRDY(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL0_LPOSCCTL0_CLKRDY_SHIFT)) & CLKCTL0_LPOSCCTL0_CLKRDY_MASK)
/*! @} */

/*! @name OSC32KHZCTL0 - 32k oscillator control0 */
/*! @{ */

#define CLKCTL0_OSC32KHZCTL0_ENA32KHZ_MASK       (0x1U)
#define CLKCTL0_OSC32KHZCTL0_ENA32KHZ_SHIFT      (0U)
/*! ENA32KHZ - 32KHz Enable.
 *  0b0..disable
 *  0b1..enable
 */
#define CLKCTL0_OSC32KHZCTL0_ENA32KHZ(x)         (((uint32_t)(((uint32_t)(x)) << CLKCTL0_OSC32KHZCTL0_ENA32KHZ_SHIFT)) & CLKCTL0_OSC32KHZCTL0_ENA32KHZ_MASK)
/*! @} */

/*! @name SYSPLL0CLKSEL - system pll0 clock selection */
/*! @{ */

#define CLKCTL0_SYSPLL0CLKSEL_SEL_MASK           (0x7U)
#define CLKCTL0_SYSPLL0CLKSEL_SEL_SHIFT          (0U)
/*! SEL - System PLL Clock Source Selection. . .
 *  0b000..SFRO Clock.
 *  0b001..SYSXTALIN Clock.
 *  0b010..FFRO Clock Divided by 2.
 *  0b011..Reserved.
 *  0b100..Reserved.
 *  0b101..Reserved.
 *  0b110..Reserved.
 *  0b111..None, this may be selected in order to reduce power when no output is needed.
 */
#define CLKCTL0_SYSPLL0CLKSEL_SEL(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SYSPLL0CLKSEL_SEL_SHIFT)) & CLKCTL0_SYSPLL0CLKSEL_SEL_MASK)
/*! @} */

/*! @name SYSPLL0CTL0 - system pll0 control0 */
/*! @{ */

#define CLKCTL0_SYSPLL0CTL0_BYPASS_MASK          (0x1U)
#define CLKCTL0_SYSPLL0CTL0_BYPASS_SHIFT         (0U)
/*! BYPASS - SYSPLL0 BYPASS Mode
 *  0b0..PFD output is PFD programmed clock.
 *  0b1..PFD output is PLL Input clock. (Bypass)
 */
#define CLKCTL0_SYSPLL0CTL0_BYPASS(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SYSPLL0CTL0_BYPASS_SHIFT)) & CLKCTL0_SYSPLL0CTL0_BYPASS_MASK)

#define CLKCTL0_SYSPLL0CTL0_RESET_MASK           (0x2U)
#define CLKCTL0_SYSPLL0CTL0_RESET_SHIFT          (1U)
/*! RESET - SYSPLL0 Reset:
 *  0b0..SYSPLL0 reset is removed.
 *  0b1..SYSPLL0 is placed into reset.
 */
#define CLKCTL0_SYSPLL0CTL0_RESET(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SYSPLL0CTL0_RESET_SHIFT)) & CLKCTL0_SYSPLL0CTL0_RESET_MASK)

#define CLKCTL0_SYSPLL0CTL0_HOLDRINGOFF_ENA_MASK (0x2000U)
#define CLKCTL0_SYSPLL0CTL0_HOLDRINGOFF_ENA_SHIFT (13U)
/*! HOLDRINGOFF_ENA - Hold Ring Off Control: This bit is used to avoid multi wave within the VCO.
 *  0b0..disbale
 *  0b1..enable
 */
#define CLKCTL0_SYSPLL0CTL0_HOLDRINGOFF_ENA(x)   (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SYSPLL0CTL0_HOLDRINGOFF_ENA_SHIFT)) & CLKCTL0_SYSPLL0CTL0_HOLDRINGOFF_ENA_MASK)

#define CLKCTL0_SYSPLL0CTL0_MULT_MASK            (0xFF0000U)
#define CLKCTL0_SYSPLL0CTL0_MULT_SHIFT           (16U)
/*! MULT - Multiplication Factor for FSYSPLL0_OUTPUT:
 *  0b00100001..Div 33
 *  0b00011011..Div 27
 *  0b00010110..Div 22
 *  0b00010100..Div 20
 *  0b00010001..Div 17
 *  0b00010000..Div 16
 */
#define CLKCTL0_SYSPLL0CTL0_MULT(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SYSPLL0CTL0_MULT_SHIFT)) & CLKCTL0_SYSPLL0CTL0_MULT_MASK)
/*! @} */

/*! @name SYSPLL0LOCKTIMEDIV2 - system pll0 lock time */
/*! @{ */

#define CLKCTL0_SYSPLL0LOCKTIMEDIV2_LOCKTIMEDIV2_MASK (0xFFFFU)
#define CLKCTL0_SYSPLL0LOCKTIMEDIV2_LOCKTIMEDIV2_SHIFT (0U)
/*! LOCKTIMEDIV2 - SYSPLL0 Lock Time Divide by 2: Programmed lock time is in uS (micro-seconds) and
 *    is programmed as half the actual lock time value.
 */
#define CLKCTL0_SYSPLL0LOCKTIMEDIV2_LOCKTIMEDIV2(x) (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SYSPLL0LOCKTIMEDIV2_LOCKTIMEDIV2_SHIFT)) & CLKCTL0_SYSPLL0LOCKTIMEDIV2_LOCKTIMEDIV2_MASK)
/*! @} */

/*! @name SYSPLL0NUM - system pll0 number */
/*! @{ */

#define CLKCTL0_SYSPLL0NUM_NUM_MASK              (0x3FFFFFFFU)
#define CLKCTL0_SYSPLL0NUM_NUM_SHIFT             (0U)
/*! NUM - This field contains the numerator of the SYSPLL0 fractional loop divider.
 */
#define CLKCTL0_SYSPLL0NUM_NUM(x)                (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SYSPLL0NUM_NUM_SHIFT)) & CLKCTL0_SYSPLL0NUM_NUM_MASK)
/*! @} */

/*! @name SYSPLL0DENOM - system pll0 denom */
/*! @{ */

#define CLKCTL0_SYSPLL0DENOM_DENOM_MASK          (0x3FFFFFFFU)
#define CLKCTL0_SYSPLL0DENOM_DENOM_SHIFT         (0U)
/*! DENOM - This field contains the denominator of the SYSPLL0 fractional loop divider.
 */
#define CLKCTL0_SYSPLL0DENOM_DENOM(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SYSPLL0DENOM_DENOM_SHIFT)) & CLKCTL0_SYSPLL0DENOM_DENOM_MASK)
/*! @} */

/*! @name SYSPLL0PFD - sys pll0 PFD */
/*! @{ */

#define CLKCTL0_SYSPLL0PFD_PFD0_MASK             (0x3FU)
#define CLKCTL0_SYSPLL0PFD_PFD0_SHIFT            (0U)
/*! PFD0 - PLL Fractional Divider 0: Controls the fractional divider value. Valid PFD values are decimal 12-35.
 */
#define CLKCTL0_SYSPLL0PFD_PFD0(x)               (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SYSPLL0PFD_PFD0_SHIFT)) & CLKCTL0_SYSPLL0PFD_PFD0_MASK)

#define CLKCTL0_SYSPLL0PFD_PFD0_CLKRDY_MASK      (0x40U)
#define CLKCTL0_SYSPLL0PFD_PFD0_CLKRDY_SHIFT     (6U)
/*! PFD0_CLKRDY - PFD0 Clock Ready Status Flag: Read as '1' clock ready. Cleared by writing a '1'.
 */
#define CLKCTL0_SYSPLL0PFD_PFD0_CLKRDY(x)        (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SYSPLL0PFD_PFD0_CLKRDY_SHIFT)) & CLKCTL0_SYSPLL0PFD_PFD0_CLKRDY_MASK)

#define CLKCTL0_SYSPLL0PFD_PFD0_CLKGATE_MASK     (0x80U)
#define CLKCTL0_SYSPLL0PFD_PFD0_CLKGATE_SHIFT    (7U)
/*! PFD0_CLKGATE - PFD0 Clock Gate: 0: PFD0 clock is not gated. 1: PFD0 clock is gated
 *  0b0..PFD0 clock is not gated.
 *  0b1..PFD0 clock is gated.
 */
#define CLKCTL0_SYSPLL0PFD_PFD0_CLKGATE(x)       (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SYSPLL0PFD_PFD0_CLKGATE_SHIFT)) & CLKCTL0_SYSPLL0PFD_PFD0_CLKGATE_MASK)

#define CLKCTL0_SYSPLL0PFD_PFD1_MASK             (0x3F00U)
#define CLKCTL0_SYSPLL0PFD_PFD1_SHIFT            (8U)
/*! PFD1 - PLL Fractional Divider 1: Controls the fractional divider value. Valid PFD values are decimal 12-35.
 */
#define CLKCTL0_SYSPLL0PFD_PFD1(x)               (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SYSPLL0PFD_PFD1_SHIFT)) & CLKCTL0_SYSPLL0PFD_PFD1_MASK)

#define CLKCTL0_SYSPLL0PFD_PFD1_CLKRDY_MASK      (0x4000U)
#define CLKCTL0_SYSPLL0PFD_PFD1_CLKRDY_SHIFT     (14U)
/*! PFD1_CLKRDY - PFD1 Clock Ready Status Flag: Read as '1' clock ready. Cleared by writing a '1'.
 */
#define CLKCTL0_SYSPLL0PFD_PFD1_CLKRDY(x)        (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SYSPLL0PFD_PFD1_CLKRDY_SHIFT)) & CLKCTL0_SYSPLL0PFD_PFD1_CLKRDY_MASK)

#define CLKCTL0_SYSPLL0PFD_PFD1_CLKGATE_MASK     (0x8000U)
#define CLKCTL0_SYSPLL0PFD_PFD1_CLKGATE_SHIFT    (15U)
/*! PFD1_CLKGATE - PFD1 Clock Gate: 0: PFD1 clock is not gated. 1: PFD1 clock is gated.
 *  0b0..PFD1 clock is not gated.
 *  0b1..PFD1 clock is gated.
 */
#define CLKCTL0_SYSPLL0PFD_PFD1_CLKGATE(x)       (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SYSPLL0PFD_PFD1_CLKGATE_SHIFT)) & CLKCTL0_SYSPLL0PFD_PFD1_CLKGATE_MASK)

#define CLKCTL0_SYSPLL0PFD_PFD2_MASK             (0x3F0000U)
#define CLKCTL0_SYSPLL0PFD_PFD2_SHIFT            (16U)
/*! PFD2 - PLL Fractional Divider 2: Controls the fractional divider value. Valid PFD values are decimal 12-35.
 */
#define CLKCTL0_SYSPLL0PFD_PFD2(x)               (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SYSPLL0PFD_PFD2_SHIFT)) & CLKCTL0_SYSPLL0PFD_PFD2_MASK)

#define CLKCTL0_SYSPLL0PFD_PFD2_CLKRDY_MASK      (0x400000U)
#define CLKCTL0_SYSPLL0PFD_PFD2_CLKRDY_SHIFT     (22U)
/*! PFD2_CLKRDY - PFD2 Clock Ready Status Flag: Read as '1' clock ready. Cleared by writing a '1'.
 */
#define CLKCTL0_SYSPLL0PFD_PFD2_CLKRDY(x)        (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SYSPLL0PFD_PFD2_CLKRDY_SHIFT)) & CLKCTL0_SYSPLL0PFD_PFD2_CLKRDY_MASK)

#define CLKCTL0_SYSPLL0PFD_PFD2_CLKGATE_MASK     (0x800000U)
#define CLKCTL0_SYSPLL0PFD_PFD2_CLKGATE_SHIFT    (23U)
/*! PFD2_CLKGATE - PFD2 Clock Gate: 0: PFD2 clock is not gated. 1: PFD2 clock is gated.
 *  0b0..PFD2 clock is not gated.
 *  0b1..PFD2 clock is gated.
 */
#define CLKCTL0_SYSPLL0PFD_PFD2_CLKGATE(x)       (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SYSPLL0PFD_PFD2_CLKGATE_SHIFT)) & CLKCTL0_SYSPLL0PFD_PFD2_CLKGATE_MASK)

#define CLKCTL0_SYSPLL0PFD_PFD3_MASK             (0x3F000000U)
#define CLKCTL0_SYSPLL0PFD_PFD3_SHIFT            (24U)
/*! PFD3 - PLL Fractional Divider 3: Controls the fractional divider value. Valid PFD values are decimal 12-35.
 */
#define CLKCTL0_SYSPLL0PFD_PFD3(x)               (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SYSPLL0PFD_PFD3_SHIFT)) & CLKCTL0_SYSPLL0PFD_PFD3_MASK)

#define CLKCTL0_SYSPLL0PFD_PFD3_CLKRDY_MASK      (0x40000000U)
#define CLKCTL0_SYSPLL0PFD_PFD3_CLKRDY_SHIFT     (30U)
/*! PFD3_CLKRDY - PFD3 Clock Ready Status Flag: Read as '1' clock ready. Cleared by writing a '1'.
 */
#define CLKCTL0_SYSPLL0PFD_PFD3_CLKRDY(x)        (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SYSPLL0PFD_PFD3_CLKRDY_SHIFT)) & CLKCTL0_SYSPLL0PFD_PFD3_CLKRDY_MASK)

#define CLKCTL0_SYSPLL0PFD_PFD3_CLKGATE_MASK     (0x80000000U)
#define CLKCTL0_SYSPLL0PFD_PFD3_CLKGATE_SHIFT    (31U)
/*! PFD3_CLKGATE - PFD3 Clock Gate: 0: PFD3 clock is not gated. 1: PFD3 clock is gated.
 *  0b0..PFD3 clock is not gated.
 *  0b1..PFD3 clock is gated.
 */
#define CLKCTL0_SYSPLL0PFD_PFD3_CLKGATE(x)       (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SYSPLL0PFD_PFD3_CLKGATE_SHIFT)) & CLKCTL0_SYSPLL0PFD_PFD3_CLKGATE_MASK)
/*! @} */

/*! @name MAINPLLCLKDIV - main pll clk divider */
/*! @{ */

#define CLKCTL0_MAINPLLCLKDIV_DIV_MASK           (0xFFU)
#define CLKCTL0_MAINPLLCLKDIV_DIV_SHIFT          (0U)
/*! DIV - Clock Divider Value Selection. . . 0: Divide by 1. ... 255: Divide by 256.
 */
#define CLKCTL0_MAINPLLCLKDIV_DIV(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL0_MAINPLLCLKDIV_DIV_SHIFT)) & CLKCTL0_MAINPLLCLKDIV_DIV_MASK)

#define CLKCTL0_MAINPLLCLKDIV_RESET_MASK         (0x20000000U)
#define CLKCTL0_MAINPLLCLKDIV_RESET_SHIFT        (29U)
/*! RESET - Resets the divider counter. Can be used to make sure a new divider value is used right
 *    away rather than completing the previous count.
 */
#define CLKCTL0_MAINPLLCLKDIV_RESET(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL0_MAINPLLCLKDIV_RESET_SHIFT)) & CLKCTL0_MAINPLLCLKDIV_RESET_MASK)

#define CLKCTL0_MAINPLLCLKDIV_HALT_MASK          (0x40000000U)
#define CLKCTL0_MAINPLLCLKDIV_HALT_SHIFT         (30U)
/*! HALT - Halts the divider counter. The intent is to allow the divider's clock source to be
 *    changed without the risk of a glitch at the output.
 */
#define CLKCTL0_MAINPLLCLKDIV_HALT(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL0_MAINPLLCLKDIV_HALT_SHIFT)) & CLKCTL0_MAINPLLCLKDIV_HALT_MASK)

#define CLKCTL0_MAINPLLCLKDIV_REQFLAG_MASK       (0x80000000U)
#define CLKCTL0_MAINPLLCLKDIV_REQFLAG_SHIFT      (31U)
/*! REQFLAG - Divider status flag. Set when a change is made to the divider value, cleared when the change is complete.
 */
#define CLKCTL0_MAINPLLCLKDIV_REQFLAG(x)         (((uint32_t)(((uint32_t)(x)) << CLKCTL0_MAINPLLCLKDIV_REQFLAG_SHIFT)) & CLKCTL0_MAINPLLCLKDIV_REQFLAG_MASK)
/*! @} */

/*! @name DSPPLLCLKDIV - dsp pll clk divider */
/*! @{ */

#define CLKCTL0_DSPPLLCLKDIV_DIV_MASK            (0xFFU)
#define CLKCTL0_DSPPLLCLKDIV_DIV_SHIFT           (0U)
/*! DIV - Clock Divider Value Selection. . . 0: Divide by 1. ... 255: Divide by 256.
 */
#define CLKCTL0_DSPPLLCLKDIV_DIV(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL0_DSPPLLCLKDIV_DIV_SHIFT)) & CLKCTL0_DSPPLLCLKDIV_DIV_MASK)

#define CLKCTL0_DSPPLLCLKDIV_RESET_MASK          (0x20000000U)
#define CLKCTL0_DSPPLLCLKDIV_RESET_SHIFT         (29U)
/*! RESET - Resets the divider counter. Can be used to make sure a new divider value is used right
 *    away rather than completing the previous count.
 */
#define CLKCTL0_DSPPLLCLKDIV_RESET(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL0_DSPPLLCLKDIV_RESET_SHIFT)) & CLKCTL0_DSPPLLCLKDIV_RESET_MASK)

#define CLKCTL0_DSPPLLCLKDIV_HALT_MASK           (0x40000000U)
#define CLKCTL0_DSPPLLCLKDIV_HALT_SHIFT          (30U)
/*! HALT - Halts the divider counter. The intent is to allow the divider's clock source to be
 *    changed without the risk of a glitch at the output.
 */
#define CLKCTL0_DSPPLLCLKDIV_HALT(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL0_DSPPLLCLKDIV_HALT_SHIFT)) & CLKCTL0_DSPPLLCLKDIV_HALT_MASK)

#define CLKCTL0_DSPPLLCLKDIV_REQFLAG_MASK        (0x80000000U)
#define CLKCTL0_DSPPLLCLKDIV_REQFLAG_SHIFT       (31U)
/*! REQFLAG - Divider status flag. Set when a change is made to the divider value, cleared when the change is complete.
 */
#define CLKCTL0_DSPPLLCLKDIV_REQFLAG(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL0_DSPPLLCLKDIV_REQFLAG_SHIFT)) & CLKCTL0_DSPPLLCLKDIV_REQFLAG_MASK)
/*! @} */

/*! @name AUX0PLLCLKDIV - aux0 pll clk divider */
/*! @{ */

#define CLKCTL0_AUX0PLLCLKDIV_DIV_MASK           (0xFFU)
#define CLKCTL0_AUX0PLLCLKDIV_DIV_SHIFT          (0U)
/*! DIV - Clock Divider Value Selection. . . 0: Divide by 1. ... 255: Divide by 256.
 */
#define CLKCTL0_AUX0PLLCLKDIV_DIV(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL0_AUX0PLLCLKDIV_DIV_SHIFT)) & CLKCTL0_AUX0PLLCLKDIV_DIV_MASK)

#define CLKCTL0_AUX0PLLCLKDIV_RESET_MASK         (0x20000000U)
#define CLKCTL0_AUX0PLLCLKDIV_RESET_SHIFT        (29U)
/*! RESET - Resets the divider counter. Can be used to make sure a new divider value is used right
 *    away rather than completing the previous count.
 */
#define CLKCTL0_AUX0PLLCLKDIV_RESET(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL0_AUX0PLLCLKDIV_RESET_SHIFT)) & CLKCTL0_AUX0PLLCLKDIV_RESET_MASK)

#define CLKCTL0_AUX0PLLCLKDIV_HALT_MASK          (0x40000000U)
#define CLKCTL0_AUX0PLLCLKDIV_HALT_SHIFT         (30U)
/*! HALT - Halts the divider counter. The intent is to allow the divider's clock source to be
 *    changed without the risk of a glitch at the output.
 */
#define CLKCTL0_AUX0PLLCLKDIV_HALT(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL0_AUX0PLLCLKDIV_HALT_SHIFT)) & CLKCTL0_AUX0PLLCLKDIV_HALT_MASK)

#define CLKCTL0_AUX0PLLCLKDIV_REQFLAG_MASK       (0x80000000U)
#define CLKCTL0_AUX0PLLCLKDIV_REQFLAG_SHIFT      (31U)
/*! REQFLAG - Divider status flag. Set when a change is made to the divider value, cleared when the change is complete.
 */
#define CLKCTL0_AUX0PLLCLKDIV_REQFLAG(x)         (((uint32_t)(((uint32_t)(x)) << CLKCTL0_AUX0PLLCLKDIV_REQFLAG_SHIFT)) & CLKCTL0_AUX0PLLCLKDIV_REQFLAG_MASK)
/*! @} */

/*! @name AUX1PLLCLKDIV - aux1 pll clk divider */
/*! @{ */

#define CLKCTL0_AUX1PLLCLKDIV_DIV_MASK           (0xFFU)
#define CLKCTL0_AUX1PLLCLKDIV_DIV_SHIFT          (0U)
/*! DIV - Clock Divider Value Selection. . . 0: Divide by 1. ... 255: Divide by 256.
 */
#define CLKCTL0_AUX1PLLCLKDIV_DIV(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL0_AUX1PLLCLKDIV_DIV_SHIFT)) & CLKCTL0_AUX1PLLCLKDIV_DIV_MASK)

#define CLKCTL0_AUX1PLLCLKDIV_RESET_MASK         (0x20000000U)
#define CLKCTL0_AUX1PLLCLKDIV_RESET_SHIFT        (29U)
/*! RESET - Resets the divider counter. Can be used to make sure a new divider value is used right
 *    away rather than completing the previous count.
 */
#define CLKCTL0_AUX1PLLCLKDIV_RESET(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL0_AUX1PLLCLKDIV_RESET_SHIFT)) & CLKCTL0_AUX1PLLCLKDIV_RESET_MASK)

#define CLKCTL0_AUX1PLLCLKDIV_HALT_MASK          (0x40000000U)
#define CLKCTL0_AUX1PLLCLKDIV_HALT_SHIFT         (30U)
/*! HALT - Halts the divider counter. The intent is to allow the divider's clock source to be
 *    changed without the risk of a glitch at the output.
 */
#define CLKCTL0_AUX1PLLCLKDIV_HALT(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL0_AUX1PLLCLKDIV_HALT_SHIFT)) & CLKCTL0_AUX1PLLCLKDIV_HALT_MASK)

#define CLKCTL0_AUX1PLLCLKDIV_REQFLAG_MASK       (0x80000000U)
#define CLKCTL0_AUX1PLLCLKDIV_REQFLAG_SHIFT      (31U)
/*! REQFLAG - Divider status flag. Set when a change is made to the divider value, cleared when the change is complete.
 */
#define CLKCTL0_AUX1PLLCLKDIV_REQFLAG(x)         (((uint32_t)(((uint32_t)(x)) << CLKCTL0_AUX1PLLCLKDIV_REQFLAG_SHIFT)) & CLKCTL0_AUX1PLLCLKDIV_REQFLAG_MASK)
/*! @} */

/*! @name SYSCPUAHBCLKDIV - system cpu AHB clock divider */
/*! @{ */

#define CLKCTL0_SYSCPUAHBCLKDIV_DIV_MASK         (0xFFU)
#define CLKCTL0_SYSCPUAHBCLKDIV_DIV_SHIFT        (0U)
/*! DIV - Clock Divider Value Selection. . . 0: Divide by 1. ... 255: Divide by 256.
 */
#define CLKCTL0_SYSCPUAHBCLKDIV_DIV(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SYSCPUAHBCLKDIV_DIV_SHIFT)) & CLKCTL0_SYSCPUAHBCLKDIV_DIV_MASK)

#define CLKCTL0_SYSCPUAHBCLKDIV_REQFLAG_MASK     (0x80000000U)
#define CLKCTL0_SYSCPUAHBCLKDIV_REQFLAG_SHIFT    (31U)
/*! REQFLAG - Divider status flag. Set when a change is made to the divider value, cleared when the change is complete.
 */
#define CLKCTL0_SYSCPUAHBCLKDIV_REQFLAG(x)       (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SYSCPUAHBCLKDIV_REQFLAG_SHIFT)) & CLKCTL0_SYSCPUAHBCLKDIV_REQFLAG_MASK)
/*! @} */

/*! @name MAINCLKSELA - main clock selection A */
/*! @{ */

#define CLKCTL0_MAINCLKSELA_SEL_MASK             (0x3U)
#define CLKCTL0_MAINCLKSELA_SEL_SHIFT            (0U)
/*! SEL - Control Main 1st Stage Control Clock Source. . .
 *  0b00..FFRO Clock Divided by 4.
 *  0b01..SYSXTALIN Clock.
 *  0b10..Low Power Oscillator Clock (LPOSC).
 *  0b11..FFRO Clock.
 */
#define CLKCTL0_MAINCLKSELA_SEL(x)               (((uint32_t)(((uint32_t)(x)) << CLKCTL0_MAINCLKSELA_SEL_SHIFT)) & CLKCTL0_MAINCLKSELA_SEL_MASK)
/*! @} */

/*! @name MAINCLKSELB - main clock selection B */
/*! @{ */

#define CLKCTL0_MAINCLKSELB_SEL_MASK             (0x3U)
#define CLKCTL0_MAINCLKSELB_SEL_SHIFT            (0U)
/*! SEL - Main Clock Source Selection. . .
 *  0b00..MAINCLKSELA 1st Stage Clock.
 *  0b01..SFRO Clock.
 *  0b10..Main System PLL Clock.
 *  0b11..RTC 32KHz Clock.
 */
#define CLKCTL0_MAINCLKSELB_SEL(x)               (((uint32_t)(((uint32_t)(x)) << CLKCTL0_MAINCLKSELB_SEL_SHIFT)) & CLKCTL0_MAINCLKSELB_SEL_MASK)
/*! @} */

/*! @name PFCDIV - PFC divider register N */
/*! @{ */

#define CLKCTL0_PFCDIV_DIV_MASK                  (0xFFU)
#define CLKCTL0_PFCDIV_DIV_SHIFT                 (0U)
/*! DIV - Clock Divider Value Selection. . . 0: Divide by 1. ... 255: Divide by 256.
 */
#define CLKCTL0_PFCDIV_DIV(x)                    (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PFCDIV_DIV_SHIFT)) & CLKCTL0_PFCDIV_DIV_MASK)

#define CLKCTL0_PFCDIV_RESET_MASK                (0x20000000U)
#define CLKCTL0_PFCDIV_RESET_SHIFT               (29U)
/*! RESET - Resets the divider counter. Can be used to make sure a new divider value is used right
 *    away rather than completing the previous count.
 */
#define CLKCTL0_PFCDIV_RESET(x)                  (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PFCDIV_RESET_SHIFT)) & CLKCTL0_PFCDIV_RESET_MASK)

#define CLKCTL0_PFCDIV_HALT_MASK                 (0x40000000U)
#define CLKCTL0_PFCDIV_HALT_SHIFT                (30U)
/*! HALT - Halts the divider counter. The intent is to allow the divider clock source to be changed
 *    without the risk of a glitch at the output.
 */
#define CLKCTL0_PFCDIV_HALT(x)                   (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PFCDIV_HALT_SHIFT)) & CLKCTL0_PFCDIV_HALT_MASK)

#define CLKCTL0_PFCDIV_REQFLAG_MASK              (0x80000000U)
#define CLKCTL0_PFCDIV_REQFLAG_SHIFT             (31U)
/*! REQFLAG - Divider status flag. Set when a change is made to the divider value, cleared when the change is complete.
 */
#define CLKCTL0_PFCDIV_REQFLAG(x)                (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PFCDIV_REQFLAG_SHIFT)) & CLKCTL0_PFCDIV_REQFLAG_MASK)
/*! @} */

/* The count of CLKCTL0_PFCDIV */
#define CLKCTL0_PFCDIV_COUNT                     (2U)

/*! @name FLEXSPIFCLKSEL - FlexSPI FCLK selection */
/*! @{ */

#define CLKCTL0_FLEXSPIFCLKSEL_SEL_MASK          (0x7U)
#define CLKCTL0_FLEXSPIFCLKSEL_SEL_SHIFT         (0U)
/*! SEL - FlexSPI Functional Clock Source Selection. . .
 *  0b000..Main Clock.
 *  0b001..Main System PLL Clock.
 *  0b010..SYSPLL0 AUX0_PLL_Clock.
 *  0b011..FFRO Clock.
 *  0b100..SYSPLL0 AUX1_PLL_Clock.
 *  0b101..Reserved.
 *  0b110..Reserved.
 *  0b111..None, this may be selected in order to reduce power when no output is needed.
 */
#define CLKCTL0_FLEXSPIFCLKSEL_SEL(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL0_FLEXSPIFCLKSEL_SEL_SHIFT)) & CLKCTL0_FLEXSPIFCLKSEL_SEL_MASK)
/*! @} */

/*! @name FLEXSPIFCLKDIV - FlexSPI FCLK divider */
/*! @{ */

#define CLKCTL0_FLEXSPIFCLKDIV_DIV_MASK          (0xFFU)
#define CLKCTL0_FLEXSPIFCLKDIV_DIV_SHIFT         (0U)
/*! DIV - Clock Divider Value Selection. . . 0: Divide by 1. ... 255: Divide by 256.
 */
#define CLKCTL0_FLEXSPIFCLKDIV_DIV(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL0_FLEXSPIFCLKDIV_DIV_SHIFT)) & CLKCTL0_FLEXSPIFCLKDIV_DIV_MASK)

#define CLKCTL0_FLEXSPIFCLKDIV_RESET_MASK        (0x20000000U)
#define CLKCTL0_FLEXSPIFCLKDIV_RESET_SHIFT       (29U)
/*! RESET - Resets the divider counter. Can be used to make sure a new divider value is used right
 *    away rather than completing the previous count.
 */
#define CLKCTL0_FLEXSPIFCLKDIV_RESET(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL0_FLEXSPIFCLKDIV_RESET_SHIFT)) & CLKCTL0_FLEXSPIFCLKDIV_RESET_MASK)

#define CLKCTL0_FLEXSPIFCLKDIV_HALT_MASK         (0x40000000U)
#define CLKCTL0_FLEXSPIFCLKDIV_HALT_SHIFT        (30U)
/*! HALT - Halts the divider counter. The intent is to allow the divider's clock source to be
 *    changed without the risk of a glitch at the output.
 */
#define CLKCTL0_FLEXSPIFCLKDIV_HALT(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL0_FLEXSPIFCLKDIV_HALT_SHIFT)) & CLKCTL0_FLEXSPIFCLKDIV_HALT_MASK)

#define CLKCTL0_FLEXSPIFCLKDIV_REQFLAG_MASK      (0x80000000U)
#define CLKCTL0_FLEXSPIFCLKDIV_REQFLAG_SHIFT     (31U)
/*! REQFLAG - Divider status flag. Set when a change is made to the divider value, cleared when the change is complete.
 */
#define CLKCTL0_FLEXSPIFCLKDIV_REQFLAG(x)        (((uint32_t)(((uint32_t)(x)) << CLKCTL0_FLEXSPIFCLKDIV_REQFLAG_SHIFT)) & CLKCTL0_FLEXSPIFCLKDIV_REQFLAG_MASK)
/*! @} */

/*! @name SCTFCLKSEL - SCT FCLK selection */
/*! @{ */

#define CLKCTL0_SCTFCLKSEL_SEL_MASK              (0x7U)
#define CLKCTL0_SCTFCLKSEL_SEL_SHIFT             (0U)
/*! SEL - SCT Functional Clock Source Selection. . .
 *  0b000..Main Clock.
 *  0b001..Main System PLL Clock.
 *  0b010..SYSPLL0 AUX0_PLL_Clock.
 *  0b011..FFRO Clock.
 *  0b100..SYSPLL0 AUX1_PLL_Clock.
 *  0b101..AUDIO PLL Clock
 *  0b110..Reserved.
 *  0b111..None, this may be selected in order to reduce power when no output is needed.
 */
#define CLKCTL0_SCTFCLKSEL_SEL(x)                (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SCTFCLKSEL_SEL_SHIFT)) & CLKCTL0_SCTFCLKSEL_SEL_MASK)
/*! @} */

/*! @name SCTFCLKDIV - SCT fclk divider */
/*! @{ */

#define CLKCTL0_SCTFCLKDIV_DIV_MASK              (0xFFU)
#define CLKCTL0_SCTFCLKDIV_DIV_SHIFT             (0U)
/*! DIV - Clock Divider Value Selection. . . 0: Divide by 1. ... 255: Divide by 256.
 */
#define CLKCTL0_SCTFCLKDIV_DIV(x)                (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SCTFCLKDIV_DIV_SHIFT)) & CLKCTL0_SCTFCLKDIV_DIV_MASK)

#define CLKCTL0_SCTFCLKDIV_RESET_MASK            (0x20000000U)
#define CLKCTL0_SCTFCLKDIV_RESET_SHIFT           (29U)
/*! RESET - Resets the divider counter. Can be used to make sure a new divider value is used right
 *    away rather than completing the previous count.
 */
#define CLKCTL0_SCTFCLKDIV_RESET(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SCTFCLKDIV_RESET_SHIFT)) & CLKCTL0_SCTFCLKDIV_RESET_MASK)

#define CLKCTL0_SCTFCLKDIV_HALT_MASK             (0x40000000U)
#define CLKCTL0_SCTFCLKDIV_HALT_SHIFT            (30U)
/*! HALT - Halts the divider counter. The intent is to allow the divider clock source to be changed
 *    without the risk of a glitch at the output.
 */
#define CLKCTL0_SCTFCLKDIV_HALT(x)               (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SCTFCLKDIV_HALT_SHIFT)) & CLKCTL0_SCTFCLKDIV_HALT_MASK)

#define CLKCTL0_SCTFCLKDIV_REQFLAG_MASK          (0x80000000U)
#define CLKCTL0_SCTFCLKDIV_REQFLAG_SHIFT         (31U)
/*! REQFLAG - Divider status flag. Set when a change is made to the divider value, cleared when the change is complete.
 */
#define CLKCTL0_SCTFCLKDIV_REQFLAG(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SCTFCLKDIV_REQFLAG_SHIFT)) & CLKCTL0_SCTFCLKDIV_REQFLAG_MASK)
/*! @} */

/*! @name USBHSFCLKSEL - USBHS Fclk selection */
/*! @{ */

#define CLKCTL0_USBHSFCLKSEL_SEL_MASK            (0x7U)
#define CLKCTL0_USBHSFCLKSEL_SEL_SHIFT           (0U)
/*! SEL - USB HS Functional Clock Source Selection. . .
 *  0b000..XTALIN Clock.
 *  0b001..Main Clock.
 *  0b010..Reserved.
 *  0b011..Reserved.
 *  0b100..reserved.
 *  0b101..Reserved.
 *  0b110..Reserved.
 *  0b111..None, this may be selected in order to reduce power when no output is needed.
 */
#define CLKCTL0_USBHSFCLKSEL_SEL(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL0_USBHSFCLKSEL_SEL_SHIFT)) & CLKCTL0_USBHSFCLKSEL_SEL_MASK)
/*! @} */

/*! @name USBHSFCLKDIV - USBHS Fclk divider */
/*! @{ */

#define CLKCTL0_USBHSFCLKDIV_DIV_MASK            (0xFFU)
#define CLKCTL0_USBHSFCLKDIV_DIV_SHIFT           (0U)
/*! DIV - Clock Divider Value Selection. . . 0: Divide by 1. ... 255: Divide by 256.
 */
#define CLKCTL0_USBHSFCLKDIV_DIV(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL0_USBHSFCLKDIV_DIV_SHIFT)) & CLKCTL0_USBHSFCLKDIV_DIV_MASK)

#define CLKCTL0_USBHSFCLKDIV_RESET_MASK          (0x20000000U)
#define CLKCTL0_USBHSFCLKDIV_RESET_SHIFT         (29U)
/*! RESET - Resets the divider counter. Can be used to make sure a new divider value is used right
 *    away rather than completing the previous count.
 */
#define CLKCTL0_USBHSFCLKDIV_RESET(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL0_USBHSFCLKDIV_RESET_SHIFT)) & CLKCTL0_USBHSFCLKDIV_RESET_MASK)

#define CLKCTL0_USBHSFCLKDIV_HALT_MASK           (0x40000000U)
#define CLKCTL0_USBHSFCLKDIV_HALT_SHIFT          (30U)
/*! HALT - Halts the divider counter. The intent is to allow the divider clock source to be changed
 *    without the risk of a glitch at the output.
 */
#define CLKCTL0_USBHSFCLKDIV_HALT(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL0_USBHSFCLKDIV_HALT_SHIFT)) & CLKCTL0_USBHSFCLKDIV_HALT_MASK)

#define CLKCTL0_USBHSFCLKDIV_REQFLAG_MASK        (0x80000000U)
#define CLKCTL0_USBHSFCLKDIV_REQFLAG_SHIFT       (31U)
/*! REQFLAG - Divider status flag. Set when a change is made to the divider value, cleared when the change is complete.
 */
#define CLKCTL0_USBHSFCLKDIV_REQFLAG(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL0_USBHSFCLKDIV_REQFLAG_SHIFT)) & CLKCTL0_USBHSFCLKDIV_REQFLAG_MASK)
/*! @} */

/*! @name SDIO0FCLKSEL - SDIO0 FCLK selection */
/*! @{ */

#define CLKCTL0_SDIO0FCLKSEL_SEL_MASK            (0x7U)
#define CLKCTL0_SDIO0FCLKSEL_SEL_SHIFT           (0U)
/*! SEL - SDIO0 Functional Clock Source Selection. .
 *  0b000..Main Clock.
 *  0b001..Main System PLL Clock.
 *  0b010..SYSPLL0 AUX0_PLL_Clock.
 *  0b011..FFRO Clock.
 *  0b100..SYSPLL0 AUX1_PLL_Clock.
 *  0b101..Reserved.
 *  0b110..Reserved.
 *  0b111..None, this may be selected in order to reduce power when no output is needed.
 */
#define CLKCTL0_SDIO0FCLKSEL_SEL(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SDIO0FCLKSEL_SEL_SHIFT)) & CLKCTL0_SDIO0FCLKSEL_SEL_MASK)
/*! @} */

/*! @name SDIO0FCLKDIV - SDIO0 FCLK divider */
/*! @{ */

#define CLKCTL0_SDIO0FCLKDIV_DIV_MASK            (0xFFU)
#define CLKCTL0_SDIO0FCLKDIV_DIV_SHIFT           (0U)
/*! DIV - Clock Divider Value Selection. . . 0: Divide by 1. ... 255: Divide by 256.
 */
#define CLKCTL0_SDIO0FCLKDIV_DIV(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SDIO0FCLKDIV_DIV_SHIFT)) & CLKCTL0_SDIO0FCLKDIV_DIV_MASK)

#define CLKCTL0_SDIO0FCLKDIV_RESET_MASK          (0x20000000U)
#define CLKCTL0_SDIO0FCLKDIV_RESET_SHIFT         (29U)
/*! RESET - Resets the divider counter. Can be used to make sure a new divider value is used right
 *    away rather than completing the previous count.
 */
#define CLKCTL0_SDIO0FCLKDIV_RESET(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SDIO0FCLKDIV_RESET_SHIFT)) & CLKCTL0_SDIO0FCLKDIV_RESET_MASK)

#define CLKCTL0_SDIO0FCLKDIV_HALT_MASK           (0x40000000U)
#define CLKCTL0_SDIO0FCLKDIV_HALT_SHIFT          (30U)
/*! HALT - Halts the divider counter. The intent is to allow the divider clock source to be changed
 *    without the risk of a glitch at the output.
 */
#define CLKCTL0_SDIO0FCLKDIV_HALT(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SDIO0FCLKDIV_HALT_SHIFT)) & CLKCTL0_SDIO0FCLKDIV_HALT_MASK)

#define CLKCTL0_SDIO0FCLKDIV_REQFLAG_MASK        (0x80000000U)
#define CLKCTL0_SDIO0FCLKDIV_REQFLAG_SHIFT       (31U)
/*! REQFLAG - Divider status flag. Set when a change is made to the divider value, cleared when the change is complete.
 */
#define CLKCTL0_SDIO0FCLKDIV_REQFLAG(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SDIO0FCLKDIV_REQFLAG_SHIFT)) & CLKCTL0_SDIO0FCLKDIV_REQFLAG_MASK)
/*! @} */

/*! @name SDIO1FCLKSEL - SDIO1 FCLK selection */
/*! @{ */

#define CLKCTL0_SDIO1FCLKSEL_SEL_MASK            (0x7U)
#define CLKCTL0_SDIO1FCLKSEL_SEL_SHIFT           (0U)
/*! SEL - SDIO1 Functional Clock Source Selection. .
 *  0b000..Main Clock.
 *  0b001..Main System PLL Clock.
 *  0b010..SYSPLL0 AUX0_PLL_Clock.
 *  0b011..FFRO Clock.
 *  0b100..SYSPLL0 AUX1_PLL_Clock.
 *  0b101..Reserved.
 *  0b110..Reserved.
 *  0b111..None, this may be selected in order to reduce power when no output is needed.
 */
#define CLKCTL0_SDIO1FCLKSEL_SEL(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SDIO1FCLKSEL_SEL_SHIFT)) & CLKCTL0_SDIO1FCLKSEL_SEL_MASK)
/*! @} */

/*! @name SDIO1FCLKDIV - SDIO1 FCLK divider */
/*! @{ */

#define CLKCTL0_SDIO1FCLKDIV_DIV_MASK            (0xFFU)
#define CLKCTL0_SDIO1FCLKDIV_DIV_SHIFT           (0U)
/*! DIV - Clock Divider Value Selection. . . 0: Divide by 1. ... 255: Divide by 256.
 */
#define CLKCTL0_SDIO1FCLKDIV_DIV(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SDIO1FCLKDIV_DIV_SHIFT)) & CLKCTL0_SDIO1FCLKDIV_DIV_MASK)

#define CLKCTL0_SDIO1FCLKDIV_RESET_MASK          (0x20000000U)
#define CLKCTL0_SDIO1FCLKDIV_RESET_SHIFT         (29U)
/*! RESET - Resets the divider counter. Can be used to make sure a new divider value is used right
 *    away rather than completing the previous count.
 */
#define CLKCTL0_SDIO1FCLKDIV_RESET(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SDIO1FCLKDIV_RESET_SHIFT)) & CLKCTL0_SDIO1FCLKDIV_RESET_MASK)

#define CLKCTL0_SDIO1FCLKDIV_HALT_MASK           (0x40000000U)
#define CLKCTL0_SDIO1FCLKDIV_HALT_SHIFT          (30U)
/*! HALT - Halts the divider counter. The intent is to allow the divider's clock source to be
 *    changed without the risk of a glitch at the output.
 */
#define CLKCTL0_SDIO1FCLKDIV_HALT(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SDIO1FCLKDIV_HALT_SHIFT)) & CLKCTL0_SDIO1FCLKDIV_HALT_MASK)

#define CLKCTL0_SDIO1FCLKDIV_REQFLAG_MASK        (0x80000000U)
#define CLKCTL0_SDIO1FCLKDIV_REQFLAG_SHIFT       (31U)
/*! REQFLAG - Divider status flag. Set when a change is made to the divider value, cleared when the change is complete.
 */
#define CLKCTL0_SDIO1FCLKDIV_REQFLAG(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SDIO1FCLKDIV_REQFLAG_SHIFT)) & CLKCTL0_SDIO1FCLKDIV_REQFLAG_MASK)
/*! @} */

/*! @name ADC0FCLKSEL0 - ADC0 fclk selection 0 */
/*! @{ */

#define CLKCTL0_ADC0FCLKSEL0_SEL_MASK            (0x7U)
#define CLKCTL0_ADC0FCLKSEL0_SEL_SHIFT           (0U)
/*! SEL - Clock Output Select 1st Stage. . .
 *  0b000..SFRO Clock.
 *  0b001..XTALIN Clock.
 *  0b010..Low Power Oscillator Clock (LPOSC).
 *  0b011..FFRO Clock.
 *  0b100..reserved.
 *  0b101..Reserved.
 *  0b110..Reserved.
 *  0b111..None, this may be selected in order to reduce power when no output is needed.
 */
#define CLKCTL0_ADC0FCLKSEL0_SEL(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL0_ADC0FCLKSEL0_SEL_SHIFT)) & CLKCTL0_ADC0FCLKSEL0_SEL_MASK)
/*! @} */

/*! @name ADC0FCLKSEL1 - ADC0 fclk selection 1 */
/*! @{ */

#define CLKCTL0_ADC0FCLKSEL1_SEL_MASK            (0x7U)
#define CLKCTL0_ADC0FCLKSEL1_SEL_SHIFT           (0U)
/*! SEL - ADC Functional Clock Source Selection. . .
 *  0b000..ADC0FCLKSEL0 Multiplexed Output.
 *  0b001..SYSPLL0 MAIN_CLK (PFD0 Output)
 *  0b010..reserved.
 *  0b011..SYSPLL0 AUX0_PLL_Clock.
 *  0b100..reserved.
 *  0b101..SYSPLL0 AUX1_PLL_Clock.
 *  0b110..Reserved.
 *  0b111..None, this may be selected in order to reduce power when no output is needed.
 */
#define CLKCTL0_ADC0FCLKSEL1_SEL(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL0_ADC0FCLKSEL1_SEL_SHIFT)) & CLKCTL0_ADC0FCLKSEL1_SEL_MASK)
/*! @} */

/*! @name ADC0FCLKDIV - ADC0 fclk divider */
/*! @{ */

#define CLKCTL0_ADC0FCLKDIV_DIV_MASK             (0xFFU)
#define CLKCTL0_ADC0FCLKDIV_DIV_SHIFT            (0U)
/*! DIV - Clock Divider Value Selection. . . 0: Divide by 1. ... 255: Divide by 256.
 */
#define CLKCTL0_ADC0FCLKDIV_DIV(x)               (((uint32_t)(((uint32_t)(x)) << CLKCTL0_ADC0FCLKDIV_DIV_SHIFT)) & CLKCTL0_ADC0FCLKDIV_DIV_MASK)

#define CLKCTL0_ADC0FCLKDIV_RESET_MASK           (0x20000000U)
#define CLKCTL0_ADC0FCLKDIV_RESET_SHIFT          (29U)
/*! RESET - Resets the divider counter. Can be used to make sure a new divider value is used right
 *    away rather than completing the previous count.
 */
#define CLKCTL0_ADC0FCLKDIV_RESET(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL0_ADC0FCLKDIV_RESET_SHIFT)) & CLKCTL0_ADC0FCLKDIV_RESET_MASK)

#define CLKCTL0_ADC0FCLKDIV_HALT_MASK            (0x40000000U)
#define CLKCTL0_ADC0FCLKDIV_HALT_SHIFT           (30U)
/*! HALT - Halts the divider counter. The intent is to allow the divider's clock source to be
 *    changed without the risk of a glitch at the output.
 */
#define CLKCTL0_ADC0FCLKDIV_HALT(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL0_ADC0FCLKDIV_HALT_SHIFT)) & CLKCTL0_ADC0FCLKDIV_HALT_MASK)

#define CLKCTL0_ADC0FCLKDIV_REQFLAG_MASK         (0x80000000U)
#define CLKCTL0_ADC0FCLKDIV_REQFLAG_SHIFT        (31U)
/*! REQFLAG - Divider status flag. Set when a change is made to the divider value, cleared when the change is complete.
 */
#define CLKCTL0_ADC0FCLKDIV_REQFLAG(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL0_ADC0FCLKDIV_REQFLAG_SHIFT)) & CLKCTL0_ADC0FCLKDIV_REQFLAG_MASK)
/*! @} */

/*! @name UTICKFCLKSEL - UTICK fclk selection */
/*! @{ */

#define CLKCTL0_UTICKFCLKSEL_SEL_MASK            (0x7U)
#define CLKCTL0_UTICKFCLKSEL_SEL_SHIFT           (0U)
/*! SEL - uTICK Functional Clock Source Selection. .
 *  0b000..Low Power Oscillator Clock (LPOSC).
 *  0b001..reserved.
 *  0b010..reserved.
 *  0b011..reserved.
 *  0b100..reserved.
 *  0b101..reserved.
 *  0b110..Reserved.
 *  0b111..None, this may be selected in order to reduce power when no output is needed.
 */
#define CLKCTL0_UTICKFCLKSEL_SEL(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL0_UTICKFCLKSEL_SEL_SHIFT)) & CLKCTL0_UTICKFCLKSEL_SEL_MASK)
/*! @} */

/*! @name WDT0FCLKSEL - wdt clock selection */
/*! @{ */

#define CLKCTL0_WDT0FCLKSEL_SEL_MASK             (0x7U)
#define CLKCTL0_WDT0FCLKSEL_SEL_SHIFT            (0U)
/*! SEL - WDT0 Functional Clock Source Selection. .
 *  0b000..Low Power Oscillator Clock (LPOSC).
 *  0b001..reserved.
 *  0b010..reserved.
 *  0b011..reserved.
 *  0b100..reserved.
 *  0b101..reserved.
 *  0b110..Reserved.
 *  0b111..None, this may be selected in order to reduce power when no output is needed.
 */
#define CLKCTL0_WDT0FCLKSEL_SEL(x)               (((uint32_t)(((uint32_t)(x)) << CLKCTL0_WDT0FCLKSEL_SEL_SHIFT)) & CLKCTL0_WDT0FCLKSEL_SEL_MASK)
/*! @} */

/*! @name WAKECLK32KHZSEL - 32k wake clock selection */
/*! @{ */

#define CLKCTL0_WAKECLK32KHZSEL_SEL_MASK         (0x7U)
#define CLKCTL0_WAKECLK32KHZSEL_SEL_SHIFT        (0U)
/*! SEL - 32KHz Wake Clock Low Power Functional Clock Source Selection. . .
 *  0b000..32KHz
 *  0b001..LPOSC (Divided by 32 by default).
 *  0b010..reserved.
 *  0b011..reserved.
 *  0b100..reserved.
 *  0b101..reserved.
 *  0b110..Reserved.
 *  0b111..None, this may be selected in order to reduce power when no output is needed.
 */
#define CLKCTL0_WAKECLK32KHZSEL_SEL(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL0_WAKECLK32KHZSEL_SEL_SHIFT)) & CLKCTL0_WAKECLK32KHZSEL_SEL_MASK)
/*! @} */

/*! @name WAKECLK32KHZDIV - 32k wake clock divider */
/*! @{ */

#define CLKCTL0_WAKECLK32KHZDIV_HALT_MASK        (0x40000000U)
#define CLKCTL0_WAKECLK32KHZDIV_HALT_SHIFT       (30U)
/*! HALT - Halts the divider counter. The intent is to allow the divider's clock source to be
 *    changed without the risk of a glitch at the output.
 */
#define CLKCTL0_WAKECLK32KHZDIV_HALT(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL0_WAKECLK32KHZDIV_HALT_SHIFT)) & CLKCTL0_WAKECLK32KHZDIV_HALT_MASK)
/*! @} */

/*! @name SYSTICKFCLKSEL - system tick fclk selection */
/*! @{ */

#define CLKCTL0_SYSTICKFCLKSEL_SEL_MASK          (0x7U)
#define CLKCTL0_SYSTICKFCLKSEL_SEL_SHIFT         (0U)
/*! SEL - SYSTICK Functional Clock Source Selection. . .
 *  0b000..Systick Divider Output Clock.
 *  0b001..Low Power Oscillator Clock (LPOSC).
 *  0b010..32KHz RTC Clock.
 *  0b011..SFRO Clock.
 *  0b100..reserved.
 *  0b101..reserved.
 *  0b110..Reserved.
 *  0b111..None, this may be selected in order to reduce power when no output is needed.
 */
#define CLKCTL0_SYSTICKFCLKSEL_SEL(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SYSTICKFCLKSEL_SEL_SHIFT)) & CLKCTL0_SYSTICKFCLKSEL_SEL_MASK)
/*! @} */

/*! @name SYSTICKFCLKDIV - system tick fclk divider */
/*! @{ */

#define CLKCTL0_SYSTICKFCLKDIV_DIV_MASK          (0xFFU)
#define CLKCTL0_SYSTICKFCLKDIV_DIV_SHIFT         (0U)
/*! DIV - Clock Divider Value Selection. . . 0: Divide by 1. ... 255: Divide by 256.
 */
#define CLKCTL0_SYSTICKFCLKDIV_DIV(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SYSTICKFCLKDIV_DIV_SHIFT)) & CLKCTL0_SYSTICKFCLKDIV_DIV_MASK)

#define CLKCTL0_SYSTICKFCLKDIV_RESET_MASK        (0x20000000U)
#define CLKCTL0_SYSTICKFCLKDIV_RESET_SHIFT       (29U)
/*! RESET - Resets the divider counter. Can be used to make sure a new divider value is used right
 *    away rather than completing the previous count.
 */
#define CLKCTL0_SYSTICKFCLKDIV_RESET(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SYSTICKFCLKDIV_RESET_SHIFT)) & CLKCTL0_SYSTICKFCLKDIV_RESET_MASK)

#define CLKCTL0_SYSTICKFCLKDIV_HALT_MASK         (0x40000000U)
#define CLKCTL0_SYSTICKFCLKDIV_HALT_SHIFT        (30U)
/*! HALT - Halts the divider counter. The intent is to allow the divider's clock source to be
 *    changed without the risk of a glitch at the output.
 */
#define CLKCTL0_SYSTICKFCLKDIV_HALT(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SYSTICKFCLKDIV_HALT_SHIFT)) & CLKCTL0_SYSTICKFCLKDIV_HALT_MASK)

#define CLKCTL0_SYSTICKFCLKDIV_REQFLAG_MASK      (0x80000000U)
#define CLKCTL0_SYSTICKFCLKDIV_REQFLAG_SHIFT     (31U)
/*! REQFLAG - Divider status flag. Set when a change is made to the divider value, cleared when the change is complete.
 */
#define CLKCTL0_SYSTICKFCLKDIV_REQFLAG(x)        (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SYSTICKFCLKDIV_REQFLAG_SHIFT)) & CLKCTL0_SYSTICKFCLKDIV_REQFLAG_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group CLKCTL0_Register_Masks */


/* CLKCTL0 - Peripheral instance base addresses */
/** Peripheral CLKCTL0 base address */
#define CLKCTL0_BASE                             (0x40001000u)
/** Peripheral CLKCTL0 base pointer */
#define CLKCTL0                                  ((CLKCTL0_Type *)CLKCTL0_BASE)
/** Array initializer of CLKCTL0 peripheral base addresses */
#define CLKCTL0_BASE_ADDRS                       { CLKCTL0_BASE }
/** Array initializer of CLKCTL0 peripheral base pointers */
#define CLKCTL0_BASE_PTRS                        { CLKCTL0 }

/*!
 * @}
 */ /* end of group CLKCTL0_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- CLKCTL1 Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CLKCTL1_Peripheral_Access_Layer CLKCTL1 Peripheral Access Layer
 * @{
 */

/** CLKCTL1 - Register Layout Typedef */
typedef struct {
       uint8_t RESERVED_0[16];
  __IO uint32_t PSCCTL0;                           /**< clock control register 0, offset: 0x10 */
  __IO uint32_t PSCCTL1;                           /**< clock control register 1, offset: 0x14 */
  __IO uint32_t PSCCTL2;                           /**< clock control register 2, offset: 0x18 */
       uint8_t RESERVED_1[36];
  __O  uint32_t PSCCTL0_SET;                       /**< clock set register 0, offset: 0x40 */
  __O  uint32_t PSCCTL1_SET;                       /**< clock set register 1, offset: 0x44 */
  __O  uint32_t PSCCTL2_SET;                       /**< clock set register 2, offset: 0x48 */
       uint8_t RESERVED_2[36];
  __O  uint32_t PSCCTL0_CLR;                       /**< clock clear register 0, offset: 0x70 */
  __O  uint32_t PSCCTL1_CLR;                       /**< clock clear register 1, offset: 0x74 */
  __O  uint32_t PSCCTL2_CLR;                       /**< clock clear register 2, offset: 0x78 */
       uint8_t RESERVED_3[388];
  __IO uint32_t AUDIOPLL0CLKSEL;                   /**< audio pll0 clock selection, offset: 0x200 */
  __IO uint32_t AUDIOPLL0CTL0;                     /**< audio pll0 control0, offset: 0x204 */
       uint8_t RESERVED_4[4];
  __IO uint32_t AUDIOPLL0LOCKTIMEDIV2;             /**< audio pll0 lock time, offset: 0x20C */
  __IO uint32_t AUDIOPLL0NUM;                      /**< audio pll0 number, offset: 0x210 */
  __IO uint32_t AUDIOPLL0DENOM;                    /**< Audio pll0 denom, offset: 0x214 */
  __IO uint32_t AUDIOPLL0PFD;                      /**< audio pll0 PFD, offset: 0x218 */
       uint8_t RESERVED_5[36];
  __IO uint32_t AUDIOPLLCLKDIV;                    /**< audio pll0 clock divider, offset: 0x240 */
       uint8_t RESERVED_6[444];
  __IO uint32_t DSPCPUCLKDIV;                      /**< DSP cpu clock divider, offset: 0x400 */
  __IO uint32_t DSPMAINRAMCLKDIV;                  /**< DSP main ram clock divider, offset: 0x404 */
       uint8_t RESERVED_7[40];
  __IO uint32_t DSPCPUCLKSELA;                     /**< DSP clock selection A, offset: 0x430 */
  __IO uint32_t DSPCPUCLKSELB;                     /**< DSP clock selection B, offset: 0x434 */
       uint8_t RESERVED_8[72];
  __IO uint32_t OSEVENTFCLKSEL;                    /**< OS EVENT clock selection, offset: 0x480 */
       uint8_t RESERVED_9[124];
  struct {                                         /* offset: 0x500, array step: 0x20 */
    __IO uint32_t FRGCLKSEL;                         /**< FRG clock selection register N, array offset: 0x500, array step: 0x20 */
    __IO uint32_t FRGCTL;                            /**< FRG clock controller, array offset: 0x504, array step: 0x20 */
    __IO uint32_t FCFCLKSEL;                         /**< flexcomm clock selection, array offset: 0x508, array step: 0x20 */
         uint8_t RESERVED_0[20];
  } FLEXCOMM[8];
       uint8_t RESERVED_10[192];
  __IO uint32_t FRG14CLKSEL;                       /**< FRG clock selection register 14, offset: 0x6C0 */
  __IO uint32_t FRG14CTL;                          /**< FRG clock controller 14, offset: 0x6C4 */
  __IO uint32_t FC14FCLKSEL;                       /**< flexcomm14 clock selection, offset: 0x6C8 */
       uint8_t RESERVED_11[20];
  __IO uint32_t FRG15CLKSEL;                       /**< FRG clock selection register 15, offset: 0x6E0 */
  __IO uint32_t FRG15CTL;                          /**< FRG clock controller 15, offset: 0x6E4 */
  __IO uint32_t FC15FCLKSEL;                       /**< flexcomm15 clock selection, offset: 0x6E8 */
       uint8_t RESERVED_12[16];
  __IO uint32_t FRGPLLCLKDIV;                      /**< FRG pll clock divider, offset: 0x6FC */
  __IO uint32_t DMIC0FCLKSEL;                      /**< DMIC0 clk selection, offset: 0x700 */
  __IO uint32_t DMIC0FCLKDIV;                      /**< DMIC clock clock divider, offset: 0x704 */
       uint8_t RESERVED_13[24];
  __IO uint32_t CT32BITFCLKSEL[5];                 /**< ct32bit timer N clock selection, array offset: 0x720, array step: 0x4 */
       uint8_t RESERVED_14[12];
  __IO uint32_t AUDIOMCLKSEL;                      /**< audio mclock selection, offset: 0x740 */
  __IO uint32_t AUDIOMCLKDIV;                      /**< audio mclock divider, offset: 0x744 */
       uint8_t RESERVED_15[24];
  __IO uint32_t CLKOUTSEL0;                        /**< clock out selection 0, offset: 0x760 */
  __IO uint32_t CLKOUTSEL1;                        /**< clock out selection 1, offset: 0x764 */
  __IO uint32_t CLKOUTDIV;                         /**< clock_out divider, offset: 0x768 */
       uint8_t RESERVED_16[20];
  __IO uint32_t I3C0FCLKSEL;                       /**< I3C0 fclk selection, offset: 0x780 */
  __IO uint32_t I3C0FCLKSTCSEL;                    /**< I3C0 fclk STC selection, offset: 0x784 */
  __IO uint32_t I3C0FCLKSTCDIV;                    /**< I3C0 fclk STC divider, offset: 0x788 */
  __IO uint32_t I3C0FCLKSDIV;                      /**< I3C0 fclks divider, offset: 0x78C */
  __IO uint32_t I3C0FCLKDIV;                       /**< I3C0 fclk divider, offset: 0x790 */
       uint8_t RESERVED_17[12];
  __IO uint32_t WDT1FCLKSEL;                       /**< WDT1 clock selection, offset: 0x7A0 */
       uint8_t RESERVED_18[28];
  __IO uint32_t ACMP0FCLKSEL;                      /**< acomparator 0 clock selection, offset: 0x7C0 */
  __IO uint32_t ACMP0FCLKDIV;                      /**< acomparator 0 fclk divider, offset: 0x7C4 */
} CLKCTL1_Type;

/* ----------------------------------------------------------------------------
   -- CLKCTL1 Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CLKCTL1_Register_Masks CLKCTL1 Register Masks
 * @{
 */

/*! @name PSCCTL0 - clock control register 0 */
/*! @{ */

#define CLKCTL1_PSCCTL0_FC0_CLK_MASK             (0x100U)
#define CLKCTL1_PSCCTL0_FC0_CLK_SHIFT            (8U)
/*! FC0_CLK - flexcomm 0 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL0_FC0_CLK(x)               (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_FC0_CLK_SHIFT)) & CLKCTL1_PSCCTL0_FC0_CLK_MASK)

#define CLKCTL1_PSCCTL0_FC1_CLK_MASK             (0x200U)
#define CLKCTL1_PSCCTL0_FC1_CLK_SHIFT            (9U)
/*! FC1_CLK - flexcomm 1 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL0_FC1_CLK(x)               (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_FC1_CLK_SHIFT)) & CLKCTL1_PSCCTL0_FC1_CLK_MASK)

#define CLKCTL1_PSCCTL0_FC2_CLK_MASK             (0x400U)
#define CLKCTL1_PSCCTL0_FC2_CLK_SHIFT            (10U)
/*! FC2_CLK - flexcomm 2 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL0_FC2_CLK(x)               (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_FC2_CLK_SHIFT)) & CLKCTL1_PSCCTL0_FC2_CLK_MASK)

#define CLKCTL1_PSCCTL0_FC3_CLK_MASK             (0x800U)
#define CLKCTL1_PSCCTL0_FC3_CLK_SHIFT            (11U)
/*! FC3_CLK - flexcomm 3 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL0_FC3_CLK(x)               (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_FC3_CLK_SHIFT)) & CLKCTL1_PSCCTL0_FC3_CLK_MASK)

#define CLKCTL1_PSCCTL0_FC4_CLK_MASK             (0x1000U)
#define CLKCTL1_PSCCTL0_FC4_CLK_SHIFT            (12U)
/*! FC4_CLK - flexcomm 4 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL0_FC4_CLK(x)               (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_FC4_CLK_SHIFT)) & CLKCTL1_PSCCTL0_FC4_CLK_MASK)

#define CLKCTL1_PSCCTL0_FC5_CLK_MASK             (0x2000U)
#define CLKCTL1_PSCCTL0_FC5_CLK_SHIFT            (13U)
/*! FC5_CLK - flexcomm 5 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL0_FC5_CLK(x)               (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_FC5_CLK_SHIFT)) & CLKCTL1_PSCCTL0_FC5_CLK_MASK)

#define CLKCTL1_PSCCTL0_FC6_CLK_MASK             (0x4000U)
#define CLKCTL1_PSCCTL0_FC6_CLK_SHIFT            (14U)
/*! FC6_CLK - flexcomm 6 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL0_FC6_CLK(x)               (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_FC6_CLK_SHIFT)) & CLKCTL1_PSCCTL0_FC6_CLK_MASK)

#define CLKCTL1_PSCCTL0_FC7_CLK_MASK             (0x8000U)
#define CLKCTL1_PSCCTL0_FC7_CLK_SHIFT            (15U)
/*! FC7_CLK - flexcomm 7 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL0_FC7_CLK(x)               (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_FC7_CLK_SHIFT)) & CLKCTL1_PSCCTL0_FC7_CLK_MASK)

#define CLKCTL1_PSCCTL0_FC14_SPI_CLK_MASK        (0x400000U)
#define CLKCTL1_PSCCTL0_FC14_SPI_CLK_SHIFT       (22U)
/*! FC14_SPI_CLK - flexcomm 14 spi clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL0_FC14_SPI_CLK(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_FC14_SPI_CLK_SHIFT)) & CLKCTL1_PSCCTL0_FC14_SPI_CLK_MASK)

#define CLKCTL1_PSCCTL0_FC15_I2C_CLK_MASK        (0x800000U)
#define CLKCTL1_PSCCTL0_FC15_I2C_CLK_SHIFT       (23U)
/*! FC15_I2C_CLK - flexcomm 15 i2c clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL0_FC15_I2C_CLK(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_FC15_I2C_CLK_SHIFT)) & CLKCTL1_PSCCTL0_FC15_I2C_CLK_MASK)

#define CLKCTL1_PSCCTL0_DMIC0_CLK_MASK           (0x1000000U)
#define CLKCTL1_PSCCTL0_DMIC0_CLK_SHIFT          (24U)
/*! DMIC0_CLK - DMIC0 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL0_DMIC0_CLK(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_DMIC0_CLK_SHIFT)) & CLKCTL1_PSCCTL0_DMIC0_CLK_MASK)

#define CLKCTL1_PSCCTL0_OSEVENT_TIMER_CLK_MASK   (0x8000000U)
#define CLKCTL1_PSCCTL0_OSEVENT_TIMER_CLK_SHIFT  (27U)
/*! OSEVENT_TIMER_CLK - OS event timer clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL0_OSEVENT_TIMER_CLK(x)     (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_OSEVENT_TIMER_CLK_SHIFT)) & CLKCTL1_PSCCTL0_OSEVENT_TIMER_CLK_MASK)
/*! @} */

/*! @name PSCCTL1 - clock control register 1 */
/*! @{ */

#define CLKCTL1_PSCCTL1_HSGPIO0_CLK_MASK         (0x1U)
#define CLKCTL1_PSCCTL1_HSGPIO0_CLK_SHIFT        (0U)
/*! HSGPIO0_CLK - HSGPIO0 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL1_HSGPIO0_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_HSGPIO0_CLK_SHIFT)) & CLKCTL1_PSCCTL1_HSGPIO0_CLK_MASK)

#define CLKCTL1_PSCCTL1_HSGPIO1_CLK_MASK         (0x2U)
#define CLKCTL1_PSCCTL1_HSGPIO1_CLK_SHIFT        (1U)
/*! HSGPIO1_CLK - HSGPIO1 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL1_HSGPIO1_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_HSGPIO1_CLK_SHIFT)) & CLKCTL1_PSCCTL1_HSGPIO1_CLK_MASK)

#define CLKCTL1_PSCCTL1_HSGPIO2_CLK_MASK         (0x4U)
#define CLKCTL1_PSCCTL1_HSGPIO2_CLK_SHIFT        (2U)
/*! HSGPIO2_CLK - HSGPIO2 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL1_HSGPIO2_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_HSGPIO2_CLK_SHIFT)) & CLKCTL1_PSCCTL1_HSGPIO2_CLK_MASK)

#define CLKCTL1_PSCCTL1_HSGPIO3_CLK_MASK         (0x8U)
#define CLKCTL1_PSCCTL1_HSGPIO3_CLK_SHIFT        (3U)
/*! HSGPIO3_CLK - HSGPIO3 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL1_HSGPIO3_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_HSGPIO3_CLK_SHIFT)) & CLKCTL1_PSCCTL1_HSGPIO3_CLK_MASK)

#define CLKCTL1_PSCCTL1_HSGPIO4_CLK_MASK         (0x10U)
#define CLKCTL1_PSCCTL1_HSGPIO4_CLK_SHIFT        (4U)
/*! HSGPIO4_CLK - HSGPIO4 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL1_HSGPIO4_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_HSGPIO4_CLK_SHIFT)) & CLKCTL1_PSCCTL1_HSGPIO4_CLK_MASK)

#define CLKCTL1_PSCCTL1_HSGPIO5_CLK_MASK         (0x20U)
#define CLKCTL1_PSCCTL1_HSGPIO5_CLK_SHIFT        (5U)
/*! HSGPIO5_CLK - HSGPIO5 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL1_HSGPIO5_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_HSGPIO5_CLK_SHIFT)) & CLKCTL1_PSCCTL1_HSGPIO5_CLK_MASK)

#define CLKCTL1_PSCCTL1_HSGPIO6_CLK_MASK         (0x40U)
#define CLKCTL1_PSCCTL1_HSGPIO6_CLK_SHIFT        (6U)
/*! HSGPIO6_CLK - HSGPIO6 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL1_HSGPIO6_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_HSGPIO6_CLK_SHIFT)) & CLKCTL1_PSCCTL1_HSGPIO6_CLK_MASK)

#define CLKCTL1_PSCCTL1_HSGPIO7_CLK_MASK         (0x80U)
#define CLKCTL1_PSCCTL1_HSGPIO7_CLK_SHIFT        (7U)
/*! HSGPIO7_CLK - HSGPIO7 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL1_HSGPIO7_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_HSGPIO7_CLK_SHIFT)) & CLKCTL1_PSCCTL1_HSGPIO7_CLK_MASK)

#define CLKCTL1_PSCCTL1_CRC_CLK_MASK             (0x10000U)
#define CLKCTL1_PSCCTL1_CRC_CLK_SHIFT            (16U)
/*! CRC_CLK - CRC clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL1_CRC_CLK(x)               (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_CRC_CLK_SHIFT)) & CLKCTL1_PSCCTL1_CRC_CLK_MASK)

#define CLKCTL1_PSCCTL1_DMAC0_CLK_MASK           (0x800000U)
#define CLKCTL1_PSCCTL1_DMAC0_CLK_SHIFT          (23U)
/*! DMAC0_CLK - DMAC0 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL1_DMAC0_CLK(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_DMAC0_CLK_SHIFT)) & CLKCTL1_PSCCTL1_DMAC0_CLK_MASK)

#define CLKCTL1_PSCCTL1_DMAC1_CLK_MASK           (0x1000000U)
#define CLKCTL1_PSCCTL1_DMAC1_CLK_SHIFT          (24U)
/*! DMAC1_CLK - DMAC1 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL1_DMAC1_CLK(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_DMAC1_CLK_SHIFT)) & CLKCTL1_PSCCTL1_DMAC1_CLK_MASK)

#define CLKCTL1_PSCCTL1_MU_CLK_MASK              (0x10000000U)
#define CLKCTL1_PSCCTL1_MU_CLK_SHIFT             (28U)
/*! MU_CLK - MU clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL1_MU_CLK(x)                (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_MU_CLK_SHIFT)) & CLKCTL1_PSCCTL1_MU_CLK_MASK)

#define CLKCTL1_PSCCTL1_SEMA_CLK_MASK            (0x20000000U)
#define CLKCTL1_PSCCTL1_SEMA_CLK_SHIFT           (29U)
/*! SEMA_CLK - SEMA clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL1_SEMA_CLK(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_SEMA_CLK_SHIFT)) & CLKCTL1_PSCCTL1_SEMA_CLK_MASK)

#define CLKCTL1_PSCCTL1_FREQME_CLK_MASK          (0x80000000U)
#define CLKCTL1_PSCCTL1_FREQME_CLK_SHIFT         (31U)
/*! FREQME_CLK - FREQME clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL1_FREQME_CLK(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_FREQME_CLK_SHIFT)) & CLKCTL1_PSCCTL1_FREQME_CLK_MASK)
/*! @} */

/*! @name PSCCTL2 - clock control register 2 */
/*! @{ */

#define CLKCTL1_PSCCTL2_CT32BIT0_CLK_MASK        (0x1U)
#define CLKCTL1_PSCCTL2_CT32BIT0_CLK_SHIFT       (0U)
/*! CT32BIT0_CLK - ct32bit timer 0 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL2_CT32BIT0_CLK(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_CT32BIT0_CLK_SHIFT)) & CLKCTL1_PSCCTL2_CT32BIT0_CLK_MASK)

#define CLKCTL1_PSCCTL2_CT32BIT1_CLK_MASK        (0x2U)
#define CLKCTL1_PSCCTL2_CT32BIT1_CLK_SHIFT       (1U)
/*! CT32BIT1_CLK - ct32bit timer 1 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL2_CT32BIT1_CLK(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_CT32BIT1_CLK_SHIFT)) & CLKCTL1_PSCCTL2_CT32BIT1_CLK_MASK)

#define CLKCTL1_PSCCTL2_CT32BIT2_CLK_MASK        (0x4U)
#define CLKCTL1_PSCCTL2_CT32BIT2_CLK_SHIFT       (2U)
/*! CT32BIT2_CLK - ct32bit timer 2 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL2_CT32BIT2_CLK(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_CT32BIT2_CLK_SHIFT)) & CLKCTL1_PSCCTL2_CT32BIT2_CLK_MASK)

#define CLKCTL1_PSCCTL2_CT32BIT3_CLK_MASK        (0x8U)
#define CLKCTL1_PSCCTL2_CT32BIT3_CLK_SHIFT       (3U)
/*! CT32BIT3_CLK - ct32bit timer 3 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL2_CT32BIT3_CLK(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_CT32BIT3_CLK_SHIFT)) & CLKCTL1_PSCCTL2_CT32BIT3_CLK_MASK)

#define CLKCTL1_PSCCTL2_CT32BIT4_CLK_MASK        (0x10U)
#define CLKCTL1_PSCCTL2_CT32BIT4_CLK_SHIFT       (4U)
/*! CT32BIT4_CLK - ct32bit timer 4 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL2_CT32BIT4_CLK(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_CT32BIT4_CLK_SHIFT)) & CLKCTL1_PSCCTL2_CT32BIT4_CLK_MASK)

#define CLKCTL1_PSCCTL2_RTC_LITE_CLK_MASK        (0x80U)
#define CLKCTL1_PSCCTL2_RTC_LITE_CLK_SHIFT       (7U)
/*! RTC_LITE_CLK - rtc lite clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL2_RTC_LITE_CLK(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_RTC_LITE_CLK_SHIFT)) & CLKCTL1_PSCCTL2_RTC_LITE_CLK_MASK)

#define CLKCTL1_PSCCTL2_MRT0_CLK_MASK            (0x100U)
#define CLKCTL1_PSCCTL2_MRT0_CLK_SHIFT           (8U)
/*! MRT0_CLK - mrt0 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL2_MRT0_CLK(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_MRT0_CLK_SHIFT)) & CLKCTL1_PSCCTL2_MRT0_CLK_MASK)

#define CLKCTL1_PSCCTL2_WWDT1_CLK_MASK           (0x400U)
#define CLKCTL1_PSCCTL2_WWDT1_CLK_SHIFT          (10U)
/*! WWDT1_CLK - wdt1 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL2_WWDT1_CLK(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_WWDT1_CLK_SHIFT)) & CLKCTL1_PSCCTL2_WWDT1_CLK_MASK)

#define CLKCTL1_PSCCTL2_I3C0_CLK_MASK            (0x10000U)
#define CLKCTL1_PSCCTL2_I3C0_CLK_SHIFT           (16U)
/*! I3C0_CLK - i3c0 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL2_I3C0_CLK(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_I3C0_CLK_SHIFT)) & CLKCTL1_PSCCTL2_I3C0_CLK_MASK)

#define CLKCTL1_PSCCTL2_GPIOINTCTL_CLK_MASK      (0x40000000U)
#define CLKCTL1_PSCCTL2_GPIOINTCTL_CLK_SHIFT     (30U)
/*! GPIOINTCTL_CLK - GPIOINTCTL clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL2_GPIOINTCTL_CLK(x)        (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_GPIOINTCTL_CLK_SHIFT)) & CLKCTL1_PSCCTL2_GPIOINTCTL_CLK_MASK)

#define CLKCTL1_PSCCTL2_PIMCTL_CLK_MASK          (0x80000000U)
#define CLKCTL1_PSCCTL2_PIMCTL_CLK_SHIFT         (31U)
/*! PIMCTL_CLK - PIMCTL clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL2_PIMCTL_CLK(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_PIMCTL_CLK_SHIFT)) & CLKCTL1_PSCCTL2_PIMCTL_CLK_MASK)
/*! @} */

/*! @name PSCCTL0_SET - clock set register 0 */
/*! @{ */

#define CLKCTL1_PSCCTL0_SET_FC0_CLK_SET_MASK     (0x100U)
#define CLKCTL1_PSCCTL0_SET_FC0_CLK_SET_SHIFT    (8U)
/*! FC0_CLK_SET - flexcomm 0 clock set
 *  0b0..No Effect
 *  0b1..Sets the PSCCTL0 Bit
 */
#define CLKCTL1_PSCCTL0_SET_FC0_CLK_SET(x)       (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_SET_FC0_CLK_SET_SHIFT)) & CLKCTL1_PSCCTL0_SET_FC0_CLK_SET_MASK)

#define CLKCTL1_PSCCTL0_SET_FC1_CLK_SET_MASK     (0x200U)
#define CLKCTL1_PSCCTL0_SET_FC1_CLK_SET_SHIFT    (9U)
/*! FC1_CLK_SET - flexcomm 1 clock set
 *  0b0..No Effect
 *  0b1..Sets the PSCCTL0 Bit
 */
#define CLKCTL1_PSCCTL0_SET_FC1_CLK_SET(x)       (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_SET_FC1_CLK_SET_SHIFT)) & CLKCTL1_PSCCTL0_SET_FC1_CLK_SET_MASK)

#define CLKCTL1_PSCCTL0_SET_FC2_CLK_SET_MASK     (0x400U)
#define CLKCTL1_PSCCTL0_SET_FC2_CLK_SET_SHIFT    (10U)
/*! FC2_CLK_SET - flexcomm 2 clock set
 *  0b0..No Effect
 *  0b1..Sets the PSCCTL0 Bit
 */
#define CLKCTL1_PSCCTL0_SET_FC2_CLK_SET(x)       (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_SET_FC2_CLK_SET_SHIFT)) & CLKCTL1_PSCCTL0_SET_FC2_CLK_SET_MASK)

#define CLKCTL1_PSCCTL0_SET_FC3_CLK_SET_MASK     (0x800U)
#define CLKCTL1_PSCCTL0_SET_FC3_CLK_SET_SHIFT    (11U)
/*! FC3_CLK_SET - flexcomm 3 clock set
 *  0b0..No Effect
 *  0b1..Sets the PSCCTL0 Bit
 */
#define CLKCTL1_PSCCTL0_SET_FC3_CLK_SET(x)       (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_SET_FC3_CLK_SET_SHIFT)) & CLKCTL1_PSCCTL0_SET_FC3_CLK_SET_MASK)

#define CLKCTL1_PSCCTL0_SET_FC4_CLK_SET_MASK     (0x1000U)
#define CLKCTL1_PSCCTL0_SET_FC4_CLK_SET_SHIFT    (12U)
/*! FC4_CLK_SET - flexcomm 4 clock set
 *  0b0..No Effect
 *  0b1..Sets the PSCCTL0 Bit
 */
#define CLKCTL1_PSCCTL0_SET_FC4_CLK_SET(x)       (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_SET_FC4_CLK_SET_SHIFT)) & CLKCTL1_PSCCTL0_SET_FC4_CLK_SET_MASK)

#define CLKCTL1_PSCCTL0_SET_FC5_CLK_SET_MASK     (0x2000U)
#define CLKCTL1_PSCCTL0_SET_FC5_CLK_SET_SHIFT    (13U)
/*! FC5_CLK_SET - flexcomm 5 clock set
 *  0b0..No Effect
 *  0b1..Sets the PSCCTL0 Bit
 */
#define CLKCTL1_PSCCTL0_SET_FC5_CLK_SET(x)       (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_SET_FC5_CLK_SET_SHIFT)) & CLKCTL1_PSCCTL0_SET_FC5_CLK_SET_MASK)

#define CLKCTL1_PSCCTL0_SET_FC6_CLK_SET_MASK     (0x4000U)
#define CLKCTL1_PSCCTL0_SET_FC6_CLK_SET_SHIFT    (14U)
/*! FC6_CLK_SET - flexcomm 6 clock set
 *  0b0..No Effect
 *  0b1..Sets the PSCCTL0 Bit
 */
#define CLKCTL1_PSCCTL0_SET_FC6_CLK_SET(x)       (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_SET_FC6_CLK_SET_SHIFT)) & CLKCTL1_PSCCTL0_SET_FC6_CLK_SET_MASK)

#define CLKCTL1_PSCCTL0_SET_FC7_CLK_SET_MASK     (0x8000U)
#define CLKCTL1_PSCCTL0_SET_FC7_CLK_SET_SHIFT    (15U)
/*! FC7_CLK_SET - flexcomm 7 clock set
 *  0b0..No Effect
 *  0b1..Sets the PSCCTL0 Bit
 */
#define CLKCTL1_PSCCTL0_SET_FC7_CLK_SET(x)       (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_SET_FC7_CLK_SET_SHIFT)) & CLKCTL1_PSCCTL0_SET_FC7_CLK_SET_MASK)

#define CLKCTL1_PSCCTL0_SET_FC14_SPI_CLK_SET_MASK (0x400000U)
#define CLKCTL1_PSCCTL0_SET_FC14_SPI_CLK_SET_SHIFT (22U)
/*! FC14_SPI_CLK_SET - flexcomm 14 spi clock set
 *  0b0..No Effect
 *  0b1..Sets the PSCCTL0 Bit
 */
#define CLKCTL1_PSCCTL0_SET_FC14_SPI_CLK_SET(x)  (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_SET_FC14_SPI_CLK_SET_SHIFT)) & CLKCTL1_PSCCTL0_SET_FC14_SPI_CLK_SET_MASK)

#define CLKCTL1_PSCCTL0_SET_FC15_I2C_CLK_SET_MASK (0x800000U)
#define CLKCTL1_PSCCTL0_SET_FC15_I2C_CLK_SET_SHIFT (23U)
/*! FC15_I2C_CLK_SET - flexcomm 15 i2c clock set
 *  0b0..No Effect
 *  0b1..Sets the PSCCTL0 Bit
 */
#define CLKCTL1_PSCCTL0_SET_FC15_I2C_CLK_SET(x)  (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_SET_FC15_I2C_CLK_SET_SHIFT)) & CLKCTL1_PSCCTL0_SET_FC15_I2C_CLK_SET_MASK)

#define CLKCTL1_PSCCTL0_SET_DMIC0_CLK_SET_MASK   (0x1000000U)
#define CLKCTL1_PSCCTL0_SET_DMIC0_CLK_SET_SHIFT  (24U)
/*! DMIC0_CLK_SET - DMIC0 clock set
 *  0b0..No Effect
 *  0b1..Sets the PSCCTL0 Bit
 */
#define CLKCTL1_PSCCTL0_SET_DMIC0_CLK_SET(x)     (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_SET_DMIC0_CLK_SET_SHIFT)) & CLKCTL1_PSCCTL0_SET_DMIC0_CLK_SET_MASK)

#define CLKCTL1_PSCCTL0_SET_OSEVENT_TIMER_CLK_SET_MASK (0x8000000U)
#define CLKCTL1_PSCCTL0_SET_OSEVENT_TIMER_CLK_SET_SHIFT (27U)
/*! OSEVENT_TIMER_CLK_SET - OS event timer clock set
 *  0b0..No Effect
 *  0b1..Sets the PSCCTL0 Bit
 */
#define CLKCTL1_PSCCTL0_SET_OSEVENT_TIMER_CLK_SET(x) (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_SET_OSEVENT_TIMER_CLK_SET_SHIFT)) & CLKCTL1_PSCCTL0_SET_OSEVENT_TIMER_CLK_SET_MASK)
/*! @} */

/*! @name PSCCTL1_SET - clock set register 1 */
/*! @{ */

#define CLKCTL1_PSCCTL1_SET_HSGPIO0_CLK_SET_MASK (0x1U)
#define CLKCTL1_PSCCTL1_SET_HSGPIO0_CLK_SET_SHIFT (0U)
/*! HSGPIO0_CLK_SET - HSGPIO0 clock set
 *  0b0..No Effect
 *  0b1..Sets the PSCCTL1 Bit
 */
#define CLKCTL1_PSCCTL1_SET_HSGPIO0_CLK_SET(x)   (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_SET_HSGPIO0_CLK_SET_SHIFT)) & CLKCTL1_PSCCTL1_SET_HSGPIO0_CLK_SET_MASK)

#define CLKCTL1_PSCCTL1_SET_HSGPIO1_CLK_SET_MASK (0x2U)
#define CLKCTL1_PSCCTL1_SET_HSGPIO1_CLK_SET_SHIFT (1U)
/*! HSGPIO1_CLK_SET - HSGPIO1 clock set
 *  0b0..No Effect
 *  0b1..Sets the PSCCTL1 Bit
 */
#define CLKCTL1_PSCCTL1_SET_HSGPIO1_CLK_SET(x)   (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_SET_HSGPIO1_CLK_SET_SHIFT)) & CLKCTL1_PSCCTL1_SET_HSGPIO1_CLK_SET_MASK)

#define CLKCTL1_PSCCTL1_SET_HSGPIO2_CLK_SET_MASK (0x4U)
#define CLKCTL1_PSCCTL1_SET_HSGPIO2_CLK_SET_SHIFT (2U)
/*! HSGPIO2_CLK_SET - HSGPIO2 clock set
 *  0b0..No Effect
 *  0b1..Sets the PSCCTL1 Bit
 */
#define CLKCTL1_PSCCTL1_SET_HSGPIO2_CLK_SET(x)   (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_SET_HSGPIO2_CLK_SET_SHIFT)) & CLKCTL1_PSCCTL1_SET_HSGPIO2_CLK_SET_MASK)

#define CLKCTL1_PSCCTL1_SET_HSGPIO3_CLK_SET_MASK (0x8U)
#define CLKCTL1_PSCCTL1_SET_HSGPIO3_CLK_SET_SHIFT (3U)
/*! HSGPIO3_CLK_SET - HSGPIO3 clock set
 *  0b0..No Effect
 *  0b1..Sets the PSCCTL1 Bit
 */
#define CLKCTL1_PSCCTL1_SET_HSGPIO3_CLK_SET(x)   (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_SET_HSGPIO3_CLK_SET_SHIFT)) & CLKCTL1_PSCCTL1_SET_HSGPIO3_CLK_SET_MASK)

#define CLKCTL1_PSCCTL1_SET_HSGPIO4_CLK_SET_MASK (0x10U)
#define CLKCTL1_PSCCTL1_SET_HSGPIO4_CLK_SET_SHIFT (4U)
/*! HSGPIO4_CLK_SET - HSGPIO4 clock set
 *  0b0..No Effect
 *  0b1..Sets the PSCCTL1 Bit
 */
#define CLKCTL1_PSCCTL1_SET_HSGPIO4_CLK_SET(x)   (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_SET_HSGPIO4_CLK_SET_SHIFT)) & CLKCTL1_PSCCTL1_SET_HSGPIO4_CLK_SET_MASK)

#define CLKCTL1_PSCCTL1_SET_HSGPIO5_CLK_SET_MASK (0x20U)
#define CLKCTL1_PSCCTL1_SET_HSGPIO5_CLK_SET_SHIFT (5U)
/*! HSGPIO5_CLK_SET - HSGPIO5 clock set
 *  0b0..No Effect
 *  0b1..Sets the PSCCTL1 Bit
 */
#define CLKCTL1_PSCCTL1_SET_HSGPIO5_CLK_SET(x)   (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_SET_HSGPIO5_CLK_SET_SHIFT)) & CLKCTL1_PSCCTL1_SET_HSGPIO5_CLK_SET_MASK)

#define CLKCTL1_PSCCTL1_SET_HSGPIO6_CLK_SET_MASK (0x40U)
#define CLKCTL1_PSCCTL1_SET_HSGPIO6_CLK_SET_SHIFT (6U)
/*! HSGPIO6_CLK_SET - HSGPIO6 clock set
 *  0b0..No Effect
 *  0b1..Sets the PSCCTL1 Bit
 */
#define CLKCTL1_PSCCTL1_SET_HSGPIO6_CLK_SET(x)   (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_SET_HSGPIO6_CLK_SET_SHIFT)) & CLKCTL1_PSCCTL1_SET_HSGPIO6_CLK_SET_MASK)

#define CLKCTL1_PSCCTL1_SET_HSGPIO7_CLK_SET_MASK (0x80U)
#define CLKCTL1_PSCCTL1_SET_HSGPIO7_CLK_SET_SHIFT (7U)
/*! HSGPIO7_CLK_SET - HSGPIO7 clock set
 *  0b0..No Effect
 *  0b1..Sets the PSCCTL1 Bit
 */
#define CLKCTL1_PSCCTL1_SET_HSGPIO7_CLK_SET(x)   (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_SET_HSGPIO7_CLK_SET_SHIFT)) & CLKCTL1_PSCCTL1_SET_HSGPIO7_CLK_SET_MASK)

#define CLKCTL1_PSCCTL1_SET_CRC_CLK_SET_MASK     (0x10000U)
#define CLKCTL1_PSCCTL1_SET_CRC_CLK_SET_SHIFT    (16U)
/*! CRC_CLK_SET - CRC clock set
 *  0b0..No Effect
 *  0b1..Sets the PSCCTL1 Bit
 */
#define CLKCTL1_PSCCTL1_SET_CRC_CLK_SET(x)       (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_SET_CRC_CLK_SET_SHIFT)) & CLKCTL1_PSCCTL1_SET_CRC_CLK_SET_MASK)

#define CLKCTL1_PSCCTL1_SET_DMAC0_CLK_SET_MASK   (0x800000U)
#define CLKCTL1_PSCCTL1_SET_DMAC0_CLK_SET_SHIFT  (23U)
/*! DMAC0_CLK_SET - DMAC0 clock set
 *  0b0..No Effect
 *  0b1..Sets the PSCCTL1 Bit
 */
#define CLKCTL1_PSCCTL1_SET_DMAC0_CLK_SET(x)     (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_SET_DMAC0_CLK_SET_SHIFT)) & CLKCTL1_PSCCTL1_SET_DMAC0_CLK_SET_MASK)

#define CLKCTL1_PSCCTL1_SET_DMAC1_CLK_SET_MASK   (0x1000000U)
#define CLKCTL1_PSCCTL1_SET_DMAC1_CLK_SET_SHIFT  (24U)
/*! DMAC1_CLK_SET - DMAC1 clock set
 *  0b0..No Effect
 *  0b1..Sets the PSCCTL1 Bit
 */
#define CLKCTL1_PSCCTL1_SET_DMAC1_CLK_SET(x)     (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_SET_DMAC1_CLK_SET_SHIFT)) & CLKCTL1_PSCCTL1_SET_DMAC1_CLK_SET_MASK)

#define CLKCTL1_PSCCTL1_SET_MU_CLK_SET_MASK      (0x10000000U)
#define CLKCTL1_PSCCTL1_SET_MU_CLK_SET_SHIFT     (28U)
/*! MU_CLK_SET - MU clock set
 *  0b0..No Effect
 *  0b1..Sets the PSCCTL1 Bit
 */
#define CLKCTL1_PSCCTL1_SET_MU_CLK_SET(x)        (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_SET_MU_CLK_SET_SHIFT)) & CLKCTL1_PSCCTL1_SET_MU_CLK_SET_MASK)

#define CLKCTL1_PSCCTL1_SET_SEMA_CLK_SET_MASK    (0x20000000U)
#define CLKCTL1_PSCCTL1_SET_SEMA_CLK_SET_SHIFT   (29U)
/*! SEMA_CLK_SET - SEMA clock set
 *  0b0..No Effect
 *  0b1..Sets the PSCCTL1 Bit
 */
#define CLKCTL1_PSCCTL1_SET_SEMA_CLK_SET(x)      (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_SET_SEMA_CLK_SET_SHIFT)) & CLKCTL1_PSCCTL1_SET_SEMA_CLK_SET_MASK)

#define CLKCTL1_PSCCTL1_SET_FREQME_CLK_SET_MASK  (0x80000000U)
#define CLKCTL1_PSCCTL1_SET_FREQME_CLK_SET_SHIFT (31U)
/*! FREQME_CLK_SET - FREQME clock set
 *  0b0..No Effect
 *  0b1..Sets the PSCCTL1 Bit
 */
#define CLKCTL1_PSCCTL1_SET_FREQME_CLK_SET(x)    (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_SET_FREQME_CLK_SET_SHIFT)) & CLKCTL1_PSCCTL1_SET_FREQME_CLK_SET_MASK)
/*! @} */

/*! @name PSCCTL2_SET - clock set register 2 */
/*! @{ */

#define CLKCTL1_PSCCTL2_SET_CT32BIT0_CLK_SET_MASK (0x1U)
#define CLKCTL1_PSCCTL2_SET_CT32BIT0_CLK_SET_SHIFT (0U)
/*! CT32BIT0_CLK_SET - ct32bit timer 0 clock set
 *  0b0..No Effect
 *  0b1..Sets the PSCCTL2 Bit
 */
#define CLKCTL1_PSCCTL2_SET_CT32BIT0_CLK_SET(x)  (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_SET_CT32BIT0_CLK_SET_SHIFT)) & CLKCTL1_PSCCTL2_SET_CT32BIT0_CLK_SET_MASK)

#define CLKCTL1_PSCCTL2_SET_CT32BIT1_CLK_SET_MASK (0x2U)
#define CLKCTL1_PSCCTL2_SET_CT32BIT1_CLK_SET_SHIFT (1U)
/*! CT32BIT1_CLK_SET - ct32bit timer 1 clock set
 *  0b0..No Effect
 *  0b1..Sets the PSCCTL2 Bit
 */
#define CLKCTL1_PSCCTL2_SET_CT32BIT1_CLK_SET(x)  (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_SET_CT32BIT1_CLK_SET_SHIFT)) & CLKCTL1_PSCCTL2_SET_CT32BIT1_CLK_SET_MASK)

#define CLKCTL1_PSCCTL2_SET_CT32BIT2_CLK_SET_MASK (0x4U)
#define CLKCTL1_PSCCTL2_SET_CT32BIT2_CLK_SET_SHIFT (2U)
/*! CT32BIT2_CLK_SET - ct32bit timer 2 clock set
 *  0b0..No Effect
 *  0b1..Sets the PSCCTL2 Bit
 */
#define CLKCTL1_PSCCTL2_SET_CT32BIT2_CLK_SET(x)  (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_SET_CT32BIT2_CLK_SET_SHIFT)) & CLKCTL1_PSCCTL2_SET_CT32BIT2_CLK_SET_MASK)

#define CLKCTL1_PSCCTL2_SET_CT32BIT3_CLK_SET_MASK (0x8U)
#define CLKCTL1_PSCCTL2_SET_CT32BIT3_CLK_SET_SHIFT (3U)
/*! CT32BIT3_CLK_SET - ct32bit timer 3 clock set
 *  0b0..No Effect
 *  0b1..Sets the PSCCTL2 Bit
 */
#define CLKCTL1_PSCCTL2_SET_CT32BIT3_CLK_SET(x)  (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_SET_CT32BIT3_CLK_SET_SHIFT)) & CLKCTL1_PSCCTL2_SET_CT32BIT3_CLK_SET_MASK)

#define CLKCTL1_PSCCTL2_SET_CT32BIT4_CLK_SET_MASK (0x10U)
#define CLKCTL1_PSCCTL2_SET_CT32BIT4_CLK_SET_SHIFT (4U)
/*! CT32BIT4_CLK_SET - ct32bit timer 4 clock set
 *  0b0..No Effect
 *  0b1..Sets the PSCCTL2 Bit
 */
#define CLKCTL1_PSCCTL2_SET_CT32BIT4_CLK_SET(x)  (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_SET_CT32BIT4_CLK_SET_SHIFT)) & CLKCTL1_PSCCTL2_SET_CT32BIT4_CLK_SET_MASK)

#define CLKCTL1_PSCCTL2_SET_RTC_LITE_CLK_SET_MASK (0x80U)
#define CLKCTL1_PSCCTL2_SET_RTC_LITE_CLK_SET_SHIFT (7U)
/*! RTC_LITE_CLK_SET - rtc lite clock set
 *  0b0..No Effect
 *  0b1..Sets the PSCCTL2 Bit
 */
#define CLKCTL1_PSCCTL2_SET_RTC_LITE_CLK_SET(x)  (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_SET_RTC_LITE_CLK_SET_SHIFT)) & CLKCTL1_PSCCTL2_SET_RTC_LITE_CLK_SET_MASK)

#define CLKCTL1_PSCCTL2_SET_MRT0_CLK_SET_MASK    (0x100U)
#define CLKCTL1_PSCCTL2_SET_MRT0_CLK_SET_SHIFT   (8U)
/*! MRT0_CLK_SET - mrt0 clock set
 *  0b0..No Effect
 *  0b1..Sets the PSCCTL2 Bit
 */
#define CLKCTL1_PSCCTL2_SET_MRT0_CLK_SET(x)      (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_SET_MRT0_CLK_SET_SHIFT)) & CLKCTL1_PSCCTL2_SET_MRT0_CLK_SET_MASK)

#define CLKCTL1_PSCCTL2_SET_WWDT1_CLK_SET_MASK   (0x400U)
#define CLKCTL1_PSCCTL2_SET_WWDT1_CLK_SET_SHIFT  (10U)
/*! WWDT1_CLK_SET - wdt1 clock set
 *  0b0..No Effect
 *  0b1..Sets the PSCCTL2 Bit
 */
#define CLKCTL1_PSCCTL2_SET_WWDT1_CLK_SET(x)     (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_SET_WWDT1_CLK_SET_SHIFT)) & CLKCTL1_PSCCTL2_SET_WWDT1_CLK_SET_MASK)

#define CLKCTL1_PSCCTL2_SET_I3C0_CLK_SET_MASK    (0x10000U)
#define CLKCTL1_PSCCTL2_SET_I3C0_CLK_SET_SHIFT   (16U)
/*! I3C0_CLK_SET - i3c0 clock set
 *  0b0..No Effect
 *  0b1..Sets the PSCCTL2 Bit
 */
#define CLKCTL1_PSCCTL2_SET_I3C0_CLK_SET(x)      (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_SET_I3C0_CLK_SET_SHIFT)) & CLKCTL1_PSCCTL2_SET_I3C0_CLK_SET_MASK)

#define CLKCTL1_PSCCTL2_SET_GPIOINTCTL_CLK_SET_MASK (0x40000000U)
#define CLKCTL1_PSCCTL2_SET_GPIOINTCTL_CLK_SET_SHIFT (30U)
/*! GPIOINTCTL_CLK_SET - GPIOINTCTL clock set
 *  0b0..No Effect
 *  0b1..Sets the PSCCTL2 Bit
 */
#define CLKCTL1_PSCCTL2_SET_GPIOINTCTL_CLK_SET(x) (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_SET_GPIOINTCTL_CLK_SET_SHIFT)) & CLKCTL1_PSCCTL2_SET_GPIOINTCTL_CLK_SET_MASK)

#define CLKCTL1_PSCCTL2_SET_PIMCTL_CLK_SET_MASK  (0x80000000U)
#define CLKCTL1_PSCCTL2_SET_PIMCTL_CLK_SET_SHIFT (31U)
/*! PIMCTL_CLK_SET - PIMCTL clock set
 *  0b0..No Effect
 *  0b1..Sets the PSCCTL2 Bit
 */
#define CLKCTL1_PSCCTL2_SET_PIMCTL_CLK_SET(x)    (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_SET_PIMCTL_CLK_SET_SHIFT)) & CLKCTL1_PSCCTL2_SET_PIMCTL_CLK_SET_MASK)
/*! @} */

/*! @name PSCCTL0_CLR - clock clear register 0 */
/*! @{ */

#define CLKCTL1_PSCCTL0_CLR_FC0_CLK_CLR_MASK     (0x100U)
#define CLKCTL1_PSCCTL0_CLR_FC0_CLK_CLR_SHIFT    (8U)
/*! FC0_CLK_CLR - flexcomm 0 clock clear
 *  0b0..No Effect
 *  0b1..Clears the PSCCTL0 Bit
 */
#define CLKCTL1_PSCCTL0_CLR_FC0_CLK_CLR(x)       (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_CLR_FC0_CLK_CLR_SHIFT)) & CLKCTL1_PSCCTL0_CLR_FC0_CLK_CLR_MASK)

#define CLKCTL1_PSCCTL0_CLR_FC1_CLK_CLR_MASK     (0x200U)
#define CLKCTL1_PSCCTL0_CLR_FC1_CLK_CLR_SHIFT    (9U)
/*! FC1_CLK_CLR - flexcomm 1 clock clear
 *  0b0..No Effect
 *  0b1..Clears the PSCCTL0 Bit
 */
#define CLKCTL1_PSCCTL0_CLR_FC1_CLK_CLR(x)       (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_CLR_FC1_CLK_CLR_SHIFT)) & CLKCTL1_PSCCTL0_CLR_FC1_CLK_CLR_MASK)

#define CLKCTL1_PSCCTL0_CLR_FC2_CLK_CLR_MASK     (0x400U)
#define CLKCTL1_PSCCTL0_CLR_FC2_CLK_CLR_SHIFT    (10U)
/*! FC2_CLK_CLR - flexcomm 2 clock clear
 *  0b0..No Effect
 *  0b1..Clears the PSCCTL0 Bit
 */
#define CLKCTL1_PSCCTL0_CLR_FC2_CLK_CLR(x)       (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_CLR_FC2_CLK_CLR_SHIFT)) & CLKCTL1_PSCCTL0_CLR_FC2_CLK_CLR_MASK)

#define CLKCTL1_PSCCTL0_CLR_FC3_CLK_CLR_MASK     (0x800U)
#define CLKCTL1_PSCCTL0_CLR_FC3_CLK_CLR_SHIFT    (11U)
/*! FC3_CLK_CLR - flexcomm 3 clock clear
 *  0b0..No Effect
 *  0b1..Clears the PSCCTL0 Bit
 */
#define CLKCTL1_PSCCTL0_CLR_FC3_CLK_CLR(x)       (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_CLR_FC3_CLK_CLR_SHIFT)) & CLKCTL1_PSCCTL0_CLR_FC3_CLK_CLR_MASK)

#define CLKCTL1_PSCCTL0_CLR_FC4_CLK_CLR_MASK     (0x1000U)
#define CLKCTL1_PSCCTL0_CLR_FC4_CLK_CLR_SHIFT    (12U)
/*! FC4_CLK_CLR - flexcomm 4 clock clear
 *  0b0..No Effect
 *  0b1..Clears the PSCCTL0 Bit
 */
#define CLKCTL1_PSCCTL0_CLR_FC4_CLK_CLR(x)       (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_CLR_FC4_CLK_CLR_SHIFT)) & CLKCTL1_PSCCTL0_CLR_FC4_CLK_CLR_MASK)

#define CLKCTL1_PSCCTL0_CLR_FC5_CLK_CLR_MASK     (0x2000U)
#define CLKCTL1_PSCCTL0_CLR_FC5_CLK_CLR_SHIFT    (13U)
/*! FC5_CLK_CLR - flexcomm 5 clock clear
 *  0b0..No Effect
 *  0b1..Clears the PSCCTL0 Bit
 */
#define CLKCTL1_PSCCTL0_CLR_FC5_CLK_CLR(x)       (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_CLR_FC5_CLK_CLR_SHIFT)) & CLKCTL1_PSCCTL0_CLR_FC5_CLK_CLR_MASK)

#define CLKCTL1_PSCCTL0_CLR_FC6_CLK_CLR_MASK     (0x4000U)
#define CLKCTL1_PSCCTL0_CLR_FC6_CLK_CLR_SHIFT    (14U)
/*! FC6_CLK_CLR - flexcomm 6 clock clear
 *  0b0..No Effect
 *  0b1..Clears the PSCCTL0 Bit
 */
#define CLKCTL1_PSCCTL0_CLR_FC6_CLK_CLR(x)       (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_CLR_FC6_CLK_CLR_SHIFT)) & CLKCTL1_PSCCTL0_CLR_FC6_CLK_CLR_MASK)

#define CLKCTL1_PSCCTL0_CLR_FC7_CLK_CLR_MASK     (0x8000U)
#define CLKCTL1_PSCCTL0_CLR_FC7_CLK_CLR_SHIFT    (15U)
/*! FC7_CLK_CLR - flexcomm 7 clock clear
 *  0b0..No Effect
 *  0b1..Clears the PSCCTL0 Bit
 */
#define CLKCTL1_PSCCTL0_CLR_FC7_CLK_CLR(x)       (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_CLR_FC7_CLK_CLR_SHIFT)) & CLKCTL1_PSCCTL0_CLR_FC7_CLK_CLR_MASK)

#define CLKCTL1_PSCCTL0_CLR_FC14_SPI_CLK_CLR_MASK (0x400000U)
#define CLKCTL1_PSCCTL0_CLR_FC14_SPI_CLK_CLR_SHIFT (22U)
/*! FC14_SPI_CLK_CLR - flexcomm 14 spi clock clear
 *  0b0..No Effect
 *  0b1..Clears the PSCCTL0 Bit
 */
#define CLKCTL1_PSCCTL0_CLR_FC14_SPI_CLK_CLR(x)  (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_CLR_FC14_SPI_CLK_CLR_SHIFT)) & CLKCTL1_PSCCTL0_CLR_FC14_SPI_CLK_CLR_MASK)

#define CLKCTL1_PSCCTL0_CLR_FC15_I2C_CLK_CLR_MASK (0x800000U)
#define CLKCTL1_PSCCTL0_CLR_FC15_I2C_CLK_CLR_SHIFT (23U)
/*! FC15_I2C_CLK_CLR - flexcomm 15 i2c clock clear
 *  0b0..No Effect
 *  0b1..Clears the PSCCTL0 Bit
 */
#define CLKCTL1_PSCCTL0_CLR_FC15_I2C_CLK_CLR(x)  (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_CLR_FC15_I2C_CLK_CLR_SHIFT)) & CLKCTL1_PSCCTL0_CLR_FC15_I2C_CLK_CLR_MASK)

#define CLKCTL1_PSCCTL0_CLR_DMIC0_CLK_CLR_MASK   (0x1000000U)
#define CLKCTL1_PSCCTL0_CLR_DMIC0_CLK_CLR_SHIFT  (24U)
/*! DMIC0_CLK_CLR - DMIC0 clock set
 *  0b0..No Effect
 *  0b1..Clears the PSCCTL0 Bit
 */
#define CLKCTL1_PSCCTL0_CLR_DMIC0_CLK_CLR(x)     (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_CLR_DMIC0_CLK_CLR_SHIFT)) & CLKCTL1_PSCCTL0_CLR_DMIC0_CLK_CLR_MASK)

#define CLKCTL1_PSCCTL0_CLR_OSEVENT_TIMER_CLK_CLR_MASK (0x8000000U)
#define CLKCTL1_PSCCTL0_CLR_OSEVENT_TIMER_CLK_CLR_SHIFT (27U)
/*! OSEVENT_TIMER_CLK_CLR - OS event timer clock clear
 *  0b0..No Effect
 *  0b1..Clears the PSCCTL0 Bit
 */
#define CLKCTL1_PSCCTL0_CLR_OSEVENT_TIMER_CLK_CLR(x) (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_CLR_OSEVENT_TIMER_CLK_CLR_SHIFT)) & CLKCTL1_PSCCTL0_CLR_OSEVENT_TIMER_CLK_CLR_MASK)
/*! @} */

/*! @name PSCCTL1_CLR - clock clear register 1 */
/*! @{ */

#define CLKCTL1_PSCCTL1_CLR_HSGPIO0_CLK_CLR_MASK (0x1U)
#define CLKCTL1_PSCCTL1_CLR_HSGPIO0_CLK_CLR_SHIFT (0U)
/*! HSGPIO0_CLK_CLR - HSGPIO0 clock clear
 *  0b0..No Effect
 *  0b1..Clears the PSCCTL1 Bit
 */
#define CLKCTL1_PSCCTL1_CLR_HSGPIO0_CLK_CLR(x)   (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_CLR_HSGPIO0_CLK_CLR_SHIFT)) & CLKCTL1_PSCCTL1_CLR_HSGPIO0_CLK_CLR_MASK)

#define CLKCTL1_PSCCTL1_CLR_HSGPIO1_CLK_CLR_MASK (0x2U)
#define CLKCTL1_PSCCTL1_CLR_HSGPIO1_CLK_CLR_SHIFT (1U)
/*! HSGPIO1_CLK_CLR - HSGPIO1 clock clear
 *  0b0..No Effect
 *  0b1..Clears the PSCCTL1 Bit
 */
#define CLKCTL1_PSCCTL1_CLR_HSGPIO1_CLK_CLR(x)   (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_CLR_HSGPIO1_CLK_CLR_SHIFT)) & CLKCTL1_PSCCTL1_CLR_HSGPIO1_CLK_CLR_MASK)

#define CLKCTL1_PSCCTL1_CLR_HSGPIO2_CLK_CLR_MASK (0x4U)
#define CLKCTL1_PSCCTL1_CLR_HSGPIO2_CLK_CLR_SHIFT (2U)
/*! HSGPIO2_CLK_CLR - HSGPIO2 clock clear
 *  0b0..No Effect
 *  0b1..Clears the PSCCTL1 Bit
 */
#define CLKCTL1_PSCCTL1_CLR_HSGPIO2_CLK_CLR(x)   (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_CLR_HSGPIO2_CLK_CLR_SHIFT)) & CLKCTL1_PSCCTL1_CLR_HSGPIO2_CLK_CLR_MASK)

#define CLKCTL1_PSCCTL1_CLR_HSGPIO3_CLK_CLR_MASK (0x8U)
#define CLKCTL1_PSCCTL1_CLR_HSGPIO3_CLK_CLR_SHIFT (3U)
/*! HSGPIO3_CLK_CLR - HSGPIO3 clock clear
 *  0b0..No Effect
 *  0b1..Clears the PSCCTL1 Bit
 */
#define CLKCTL1_PSCCTL1_CLR_HSGPIO3_CLK_CLR(x)   (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_CLR_HSGPIO3_CLK_CLR_SHIFT)) & CLKCTL1_PSCCTL1_CLR_HSGPIO3_CLK_CLR_MASK)

#define CLKCTL1_PSCCTL1_CLR_HSGPIO4_CLK_CLR_MASK (0x10U)
#define CLKCTL1_PSCCTL1_CLR_HSGPIO4_CLK_CLR_SHIFT (4U)
/*! HSGPIO4_CLK_CLR - HSGPIO4 clock clear
 *  0b0..No Effect
 *  0b1..Clears the PSCCTL1 Bit
 */
#define CLKCTL1_PSCCTL1_CLR_HSGPIO4_CLK_CLR(x)   (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_CLR_HSGPIO4_CLK_CLR_SHIFT)) & CLKCTL1_PSCCTL1_CLR_HSGPIO4_CLK_CLR_MASK)

#define CLKCTL1_PSCCTL1_CLR_HSGPIO5_CLK_CLR_MASK (0x20U)
#define CLKCTL1_PSCCTL1_CLR_HSGPIO5_CLK_CLR_SHIFT (5U)
/*! HSGPIO5_CLK_CLR - HSGPIO5 clock clear
 *  0b0..No Effect
 *  0b1..Clears the PSCCTL1 Bit
 */
#define CLKCTL1_PSCCTL1_CLR_HSGPIO5_CLK_CLR(x)   (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_CLR_HSGPIO5_CLK_CLR_SHIFT)) & CLKCTL1_PSCCTL1_CLR_HSGPIO5_CLK_CLR_MASK)

#define CLKCTL1_PSCCTL1_CLR_HSGPIO6_CLK_CLR_MASK (0x40U)
#define CLKCTL1_PSCCTL1_CLR_HSGPIO6_CLK_CLR_SHIFT (6U)
/*! HSGPIO6_CLK_CLR - HSGPIO6 clock clear
 *  0b0..No Effect
 *  0b1..Clears the PSCCTL1 Bit
 */
#define CLKCTL1_PSCCTL1_CLR_HSGPIO6_CLK_CLR(x)   (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_CLR_HSGPIO6_CLK_CLR_SHIFT)) & CLKCTL1_PSCCTL1_CLR_HSGPIO6_CLK_CLR_MASK)

#define CLKCTL1_PSCCTL1_CLR_HSGPIO7_CLK_CLR_MASK (0x80U)
#define CLKCTL1_PSCCTL1_CLR_HSGPIO7_CLK_CLR_SHIFT (7U)
/*! HSGPIO7_CLK_CLR - HSGPIO7 clock clear
 *  0b0..No Effect
 *  0b1..Clears the PSCCTL1 Bit
 */
#define CLKCTL1_PSCCTL1_CLR_HSGPIO7_CLK_CLR(x)   (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_CLR_HSGPIO7_CLK_CLR_SHIFT)) & CLKCTL1_PSCCTL1_CLR_HSGPIO7_CLK_CLR_MASK)

#define CLKCTL1_PSCCTL1_CLR_CRC_CLK_CLR_MASK     (0x10000U)
#define CLKCTL1_PSCCTL1_CLR_CRC_CLK_CLR_SHIFT    (16U)
/*! CRC_CLK_CLR - CRC clock clear
 *  0b0..No Effect
 *  0b1..Clears the PSCCTL1 Bit
 */
#define CLKCTL1_PSCCTL1_CLR_CRC_CLK_CLR(x)       (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_CLR_CRC_CLK_CLR_SHIFT)) & CLKCTL1_PSCCTL1_CLR_CRC_CLK_CLR_MASK)

#define CLKCTL1_PSCCTL1_CLR_DMAC0_CLK_CLR_MASK   (0x800000U)
#define CLKCTL1_PSCCTL1_CLR_DMAC0_CLK_CLR_SHIFT  (23U)
/*! DMAC0_CLK_CLR - DMAC0 clock clear
 *  0b0..No Effect
 *  0b1..Clears the PSCCTL1 Bit
 */
#define CLKCTL1_PSCCTL1_CLR_DMAC0_CLK_CLR(x)     (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_CLR_DMAC0_CLK_CLR_SHIFT)) & CLKCTL1_PSCCTL1_CLR_DMAC0_CLK_CLR_MASK)

#define CLKCTL1_PSCCTL1_CLR_DMAC1_CLK_CLR_MASK   (0x1000000U)
#define CLKCTL1_PSCCTL1_CLR_DMAC1_CLK_CLR_SHIFT  (24U)
/*! DMAC1_CLK_CLR - DMAC1 clock clear
 *  0b0..No Effect
 *  0b1..Clears the PSCCTL1 Bit
 */
#define CLKCTL1_PSCCTL1_CLR_DMAC1_CLK_CLR(x)     (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_CLR_DMAC1_CLK_CLR_SHIFT)) & CLKCTL1_PSCCTL1_CLR_DMAC1_CLK_CLR_MASK)

#define CLKCTL1_PSCCTL1_CLR_MU_CLK_CLR_MASK      (0x10000000U)
#define CLKCTL1_PSCCTL1_CLR_MU_CLK_CLR_SHIFT     (28U)
/*! MU_CLK_CLR - MU clock clear
 *  0b0..No Effect
 *  0b1..Clears the PSCCTL1 Bit
 */
#define CLKCTL1_PSCCTL1_CLR_MU_CLK_CLR(x)        (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_CLR_MU_CLK_CLR_SHIFT)) & CLKCTL1_PSCCTL1_CLR_MU_CLK_CLR_MASK)

#define CLKCTL1_PSCCTL1_CLR_SEMA_CLK_CLR_MASK    (0x20000000U)
#define CLKCTL1_PSCCTL1_CLR_SEMA_CLK_CLR_SHIFT   (29U)
/*! SEMA_CLK_CLR - SEMA clock clear
 *  0b0..No Effect
 *  0b1..Clears the PSCCTL1 Bit
 */
#define CLKCTL1_PSCCTL1_CLR_SEMA_CLK_CLR(x)      (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_CLR_SEMA_CLK_CLR_SHIFT)) & CLKCTL1_PSCCTL1_CLR_SEMA_CLK_CLR_MASK)

#define CLKCTL1_PSCCTL1_CLR_FREQME_CLK_CLR_MASK  (0x80000000U)
#define CLKCTL1_PSCCTL1_CLR_FREQME_CLK_CLR_SHIFT (31U)
/*! FREQME_CLK_CLR - FREQME clock clear
 *  0b0..No Effect
 *  0b1..Clears the PSCCTL1 Bit
 */
#define CLKCTL1_PSCCTL1_CLR_FREQME_CLK_CLR(x)    (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_CLR_FREQME_CLK_CLR_SHIFT)) & CLKCTL1_PSCCTL1_CLR_FREQME_CLK_CLR_MASK)
/*! @} */

/*! @name PSCCTL2_CLR - clock clear register 2 */
/*! @{ */

#define CLKCTL1_PSCCTL2_CLR_CT32BIT0_CLK_CLR_MASK (0x1U)
#define CLKCTL1_PSCCTL2_CLR_CT32BIT0_CLK_CLR_SHIFT (0U)
/*! CT32BIT0_CLK_CLR - ct32bit timer 0 clock clear
 *  0b0..No Effect
 *  0b1..Clears the PSCCTL2 Bit
 */
#define CLKCTL1_PSCCTL2_CLR_CT32BIT0_CLK_CLR(x)  (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_CLR_CT32BIT0_CLK_CLR_SHIFT)) & CLKCTL1_PSCCTL2_CLR_CT32BIT0_CLK_CLR_MASK)

#define CLKCTL1_PSCCTL2_CLR_CT32BIT1_CLK_CLR_MASK (0x2U)
#define CLKCTL1_PSCCTL2_CLR_CT32BIT1_CLK_CLR_SHIFT (1U)
/*! CT32BIT1_CLK_CLR - ct32bit timer 1 clock clear
 *  0b0..No Effect
 *  0b1..Clears the PSCCTL2 Bit
 */
#define CLKCTL1_PSCCTL2_CLR_CT32BIT1_CLK_CLR(x)  (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_CLR_CT32BIT1_CLK_CLR_SHIFT)) & CLKCTL1_PSCCTL2_CLR_CT32BIT1_CLK_CLR_MASK)

#define CLKCTL1_PSCCTL2_CLR_CT32BIT2_CLK_CLR_MASK (0x4U)
#define CLKCTL1_PSCCTL2_CLR_CT32BIT2_CLK_CLR_SHIFT (2U)
/*! CT32BIT2_CLK_CLR - ct32bit timer 2 clock clear
 *  0b0..No Effect
 *  0b1..Clears the PSCCTL2 Bit
 */
#define CLKCTL1_PSCCTL2_CLR_CT32BIT2_CLK_CLR(x)  (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_CLR_CT32BIT2_CLK_CLR_SHIFT)) & CLKCTL1_PSCCTL2_CLR_CT32BIT2_CLK_CLR_MASK)

#define CLKCTL1_PSCCTL2_CLR_CT32BIT3_CLK_CLR_MASK (0x8U)
#define CLKCTL1_PSCCTL2_CLR_CT32BIT3_CLK_CLR_SHIFT (3U)
/*! CT32BIT3_CLK_CLR - ct32bit timer 3 clock clear
 *  0b0..No Effect
 *  0b1..Clears the PSCCTL2 Bit
 */
#define CLKCTL1_PSCCTL2_CLR_CT32BIT3_CLK_CLR(x)  (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_CLR_CT32BIT3_CLK_CLR_SHIFT)) & CLKCTL1_PSCCTL2_CLR_CT32BIT3_CLK_CLR_MASK)

#define CLKCTL1_PSCCTL2_CLR_CT32BIT4_CLK_CLR_MASK (0x10U)
#define CLKCTL1_PSCCTL2_CLR_CT32BIT4_CLK_CLR_SHIFT (4U)
/*! CT32BIT4_CLK_CLR - ct32bit timer 4 clock clear
 *  0b0..No Effect
 *  0b1..Clears the PSCCTL2 Bit
 */
#define CLKCTL1_PSCCTL2_CLR_CT32BIT4_CLK_CLR(x)  (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_CLR_CT32BIT4_CLK_CLR_SHIFT)) & CLKCTL1_PSCCTL2_CLR_CT32BIT4_CLK_CLR_MASK)

#define CLKCTL1_PSCCTL2_CLR_RTC_LITE_CLK_CLR_MASK (0x80U)
#define CLKCTL1_PSCCTL2_CLR_RTC_LITE_CLK_CLR_SHIFT (7U)
/*! RTC_LITE_CLK_CLR - rtc lite clock clear
 *  0b0..No Effect
 *  0b1..Clears the PSCCTL2 Bit
 */
#define CLKCTL1_PSCCTL2_CLR_RTC_LITE_CLK_CLR(x)  (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_CLR_RTC_LITE_CLK_CLR_SHIFT)) & CLKCTL1_PSCCTL2_CLR_RTC_LITE_CLK_CLR_MASK)

#define CLKCTL1_PSCCTL2_CLR_MRT0_CLK_CLR_MASK    (0x100U)
#define CLKCTL1_PSCCTL2_CLR_MRT0_CLK_CLR_SHIFT   (8U)
/*! MRT0_CLK_CLR - mrt0 clock clear
 *  0b0..No Effect
 *  0b1..Clears the PSCCTL2 Bit
 */
#define CLKCTL1_PSCCTL2_CLR_MRT0_CLK_CLR(x)      (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_CLR_MRT0_CLK_CLR_SHIFT)) & CLKCTL1_PSCCTL2_CLR_MRT0_CLK_CLR_MASK)

#define CLKCTL1_PSCCTL2_CLR_WWDT1_CLK_CLR_MASK   (0x400U)
#define CLKCTL1_PSCCTL2_CLR_WWDT1_CLK_CLR_SHIFT  (10U)
/*! WWDT1_CLK_CLR - wdt1 clock clear
 *  0b0..No Effect
 *  0b1..Clears the PSCCTL2 Bit
 */
#define CLKCTL1_PSCCTL2_CLR_WWDT1_CLK_CLR(x)     (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_CLR_WWDT1_CLK_CLR_SHIFT)) & CLKCTL1_PSCCTL2_CLR_WWDT1_CLK_CLR_MASK)

#define CLKCTL1_PSCCTL2_CLR_I3C0_CLK_CLR_MASK    (0x10000U)
#define CLKCTL1_PSCCTL2_CLR_I3C0_CLK_CLR_SHIFT   (16U)
/*! I3C0_CLK_CLR - i3c0 clock clear
 *  0b0..No Effect
 *  0b1..Clears the PSCCTL2 Bit
 */
#define CLKCTL1_PSCCTL2_CLR_I3C0_CLK_CLR(x)      (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_CLR_I3C0_CLK_CLR_SHIFT)) & CLKCTL1_PSCCTL2_CLR_I3C0_CLK_CLR_MASK)

#define CLKCTL1_PSCCTL2_CLR_GPIOINTCTL_CLK_CLR_MASK (0x40000000U)
#define CLKCTL1_PSCCTL2_CLR_GPIOINTCTL_CLK_CLR_SHIFT (30U)
/*! GPIOINTCTL_CLK_CLR - GPIOINTCTL clock clear
 *  0b0..No Effect
 *  0b1..Clears the PSCCTL2 Bit
 */
#define CLKCTL1_PSCCTL2_CLR_GPIOINTCTL_CLK_CLR(x) (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_CLR_GPIOINTCTL_CLK_CLR_SHIFT)) & CLKCTL1_PSCCTL2_CLR_GPIOINTCTL_CLK_CLR_MASK)

#define CLKCTL1_PSCCTL2_CLR_PIMCTL_CLK_CLR_MASK  (0x80000000U)
#define CLKCTL1_PSCCTL2_CLR_PIMCTL_CLK_CLR_SHIFT (31U)
/*! PIMCTL_CLK_CLR - PIMCTL clock clear
 *  0b0..No Effect
 *  0b1..Clears the PSCCTL2 Bit
 */
#define CLKCTL1_PSCCTL2_CLR_PIMCTL_CLK_CLR(x)    (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_CLR_PIMCTL_CLK_CLR_SHIFT)) & CLKCTL1_PSCCTL2_CLR_PIMCTL_CLK_CLR_MASK)
/*! @} */

/*! @name AUDIOPLL0CLKSEL - audio pll0 clock selection */
/*! @{ */

#define CLKCTL1_AUDIOPLL0CLKSEL_SEL_MASK         (0x7U)
#define CLKCTL1_AUDIOPLL0CLKSEL_SEL_SHIFT        (0U)
/*! SEL - System PLL Clock Source Selection. . .
 *  0b000..SFRO Clock.
 *  0b001..XTALIN Clock.
 *  0b010..FFRO Clock Divided by 2.
 *  0b011..Reserved.
 *  0b100..Reserved.
 *  0b101..Reserved.
 *  0b110..Reserved.
 *  0b111..None, this may be selected in order to reduce power when no output is needed.
 */
#define CLKCTL1_AUDIOPLL0CLKSEL_SEL(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL1_AUDIOPLL0CLKSEL_SEL_SHIFT)) & CLKCTL1_AUDIOPLL0CLKSEL_SEL_MASK)
/*! @} */

/*! @name AUDIOPLL0CTL0 - audio pll0 control0 */
/*! @{ */

#define CLKCTL1_AUDIOPLL0CTL0_BYPASS_MASK        (0x1U)
#define CLKCTL1_AUDIOPLL0CTL0_BYPASS_SHIFT       (0U)
/*! BYPASS - AUDIOPLL0 BYPASS Mode
 *  0b0..PFD output is PFD programmed clock.
 *  0b1..PFD output is AUDIOPLL0 reference input clock. (Bypass Mode)
 */
#define CLKCTL1_AUDIOPLL0CTL0_BYPASS(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL1_AUDIOPLL0CTL0_BYPASS_SHIFT)) & CLKCTL1_AUDIOPLL0CTL0_BYPASS_MASK)

#define CLKCTL1_AUDIOPLL0CTL0_RESET_MASK         (0x2U)
#define CLKCTL1_AUDIOPLL0CTL0_RESET_SHIFT        (1U)
/*! RESET - AUDIOPLL0 Reset:
 *  0b0..AUDIOPLL0 reset is removed.
 *  0b1..AUDIOPLL0 is placed into reset.
 */
#define CLKCTL1_AUDIOPLL0CTL0_RESET(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL1_AUDIOPLL0CTL0_RESET_SHIFT)) & CLKCTL1_AUDIOPLL0CTL0_RESET_MASK)

#define CLKCTL1_AUDIOPLL0CTL0_HOLDRINGOFF_ENA_MASK (0x2000U)
#define CLKCTL1_AUDIOPLL0CTL0_HOLDRINGOFF_ENA_SHIFT (13U)
/*! HOLDRINGOFF_ENA - Hold Ring Off Control
 *  0b0..disbale
 *  0b1..enable
 */
#define CLKCTL1_AUDIOPLL0CTL0_HOLDRINGOFF_ENA(x) (((uint32_t)(((uint32_t)(x)) << CLKCTL1_AUDIOPLL0CTL0_HOLDRINGOFF_ENA_SHIFT)) & CLKCTL1_AUDIOPLL0CTL0_HOLDRINGOFF_ENA_MASK)

#define CLKCTL1_AUDIOPLL0CTL0_MULT_MASK          (0xFF0000U)
#define CLKCTL1_AUDIOPLL0CTL0_MULT_SHIFT         (16U)
/*! MULT - Multiplication Factor for FAUDIOPLL0_OUTPUT:
 *  0b00100001..Div 33
 *  0b00011011..Div 27
 *  0b00010110..Div 22
 *  0b00010100..Div 20
 *  0b00010001..Div 17
 *  0b00010000..Div 16
 */
#define CLKCTL1_AUDIOPLL0CTL0_MULT(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL1_AUDIOPLL0CTL0_MULT_SHIFT)) & CLKCTL1_AUDIOPLL0CTL0_MULT_MASK)
/*! @} */

/*! @name AUDIOPLL0LOCKTIMEDIV2 - audio pll0 lock time */
/*! @{ */

#define CLKCTL1_AUDIOPLL0LOCKTIMEDIV2_LOCKTIMEDIV2_MASK (0xFFFFU)
#define CLKCTL1_AUDIOPLL0LOCKTIMEDIV2_LOCKTIMEDIV2_SHIFT (0U)
/*! LOCKTIMEDIV2 - AUDIOPLL0 Lock Time Divide by 2: Programmed lock time is in uS (micro-seconds)
 *    and is programmed as half the actual lock time value.
 */
#define CLKCTL1_AUDIOPLL0LOCKTIMEDIV2_LOCKTIMEDIV2(x) (((uint32_t)(((uint32_t)(x)) << CLKCTL1_AUDIOPLL0LOCKTIMEDIV2_LOCKTIMEDIV2_SHIFT)) & CLKCTL1_AUDIOPLL0LOCKTIMEDIV2_LOCKTIMEDIV2_MASK)
/*! @} */

/*! @name AUDIOPLL0NUM - audio pll0 number */
/*! @{ */

#define CLKCTL1_AUDIOPLL0NUM_NUM_MASK            (0x3FFFFFFFU)
#define CLKCTL1_AUDIOPLL0NUM_NUM_SHIFT           (0U)
/*! NUM - This field contains the numerator of the AUDIOPLL0 fractional loop divider. NOTES: 1. The
 *    value of numerator must always be configured to be less than the value of the denominator. 2.
 *    The AUDIOPLL0NUM register can only be changed when the AUDIOPLL0 is disabled.
 */
#define CLKCTL1_AUDIOPLL0NUM_NUM(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL1_AUDIOPLL0NUM_NUM_SHIFT)) & CLKCTL1_AUDIOPLL0NUM_NUM_MASK)
/*! @} */

/*! @name AUDIOPLL0DENOM - Audio pll0 denom */
/*! @{ */

#define CLKCTL1_AUDIOPLL0DENOM_DENOM_MASK        (0x3FFFFFFFU)
#define CLKCTL1_AUDIOPLL0DENOM_DENOM_SHIFT       (0U)
/*! DENOM - This field contains the denominator of the AUDIOPLL0 fractional loop divider. NOTES: 1.
 *    The value of numerator must always be configured to be less than the value of the denominator.
 *    2. The AUDIOPLL0DENOM register can only be changed when the AUDIOPLL0 is disabled.
 */
#define CLKCTL1_AUDIOPLL0DENOM_DENOM(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL1_AUDIOPLL0DENOM_DENOM_SHIFT)) & CLKCTL1_AUDIOPLL0DENOM_DENOM_MASK)
/*! @} */

/*! @name AUDIOPLL0PFD - audio pll0 PFD */
/*! @{ */

#define CLKCTL1_AUDIOPLL0PFD_PFD0_MASK           (0x3FU)
#define CLKCTL1_AUDIOPLL0PFD_PFD0_SHIFT          (0U)
/*! PFD0 - PLL Fractional Divider 0: Controls the fractional divider value. Valid PFD values are decimal 12-35.
 */
#define CLKCTL1_AUDIOPLL0PFD_PFD0(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL1_AUDIOPLL0PFD_PFD0_SHIFT)) & CLKCTL1_AUDIOPLL0PFD_PFD0_MASK)

#define CLKCTL1_AUDIOPLL0PFD_PFD0_CLKRDY_MASK    (0x40U)
#define CLKCTL1_AUDIOPLL0PFD_PFD0_CLKRDY_SHIFT   (6U)
/*! PFD0_CLKRDY - PFD0 Clock Ready Status Flag: Read as 1 clock ready. Cleared by writing a 1.
 */
#define CLKCTL1_AUDIOPLL0PFD_PFD0_CLKRDY(x)      (((uint32_t)(((uint32_t)(x)) << CLKCTL1_AUDIOPLL0PFD_PFD0_CLKRDY_SHIFT)) & CLKCTL1_AUDIOPLL0PFD_PFD0_CLKRDY_MASK)

#define CLKCTL1_AUDIOPLL0PFD_PFD0_CLKGATE_MASK   (0x80U)
#define CLKCTL1_AUDIOPLL0PFD_PFD0_CLKGATE_SHIFT  (7U)
/*! PFD0_CLKGATE - PFD0 Clock Gate: 0: PFD0 clock is not gated. 1: PFD0 clock is gated
 *  0b0..PFD0 clock is not gated.
 *  0b1..PFD0 clock is gated.
 */
#define CLKCTL1_AUDIOPLL0PFD_PFD0_CLKGATE(x)     (((uint32_t)(((uint32_t)(x)) << CLKCTL1_AUDIOPLL0PFD_PFD0_CLKGATE_SHIFT)) & CLKCTL1_AUDIOPLL0PFD_PFD0_CLKGATE_MASK)

#define CLKCTL1_AUDIOPLL0PFD_PFD1_MASK           (0x3F00U)
#define CLKCTL1_AUDIOPLL0PFD_PFD1_SHIFT          (8U)
/*! PFD1 - PLL Fractional Divider 1: Controls the fractional divider value. Valid PFD values are decimal 12-35.
 */
#define CLKCTL1_AUDIOPLL0PFD_PFD1(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL1_AUDIOPLL0PFD_PFD1_SHIFT)) & CLKCTL1_AUDIOPLL0PFD_PFD1_MASK)

#define CLKCTL1_AUDIOPLL0PFD_PFD1_CLKRDY_MASK    (0x4000U)
#define CLKCTL1_AUDIOPLL0PFD_PFD1_CLKRDY_SHIFT   (14U)
/*! PFD1_CLKRDY - PFD1 Clock Ready Status Flag: Read as 1 clock ready. Cleared by writing a 1.
 */
#define CLKCTL1_AUDIOPLL0PFD_PFD1_CLKRDY(x)      (((uint32_t)(((uint32_t)(x)) << CLKCTL1_AUDIOPLL0PFD_PFD1_CLKRDY_SHIFT)) & CLKCTL1_AUDIOPLL0PFD_PFD1_CLKRDY_MASK)

#define CLKCTL1_AUDIOPLL0PFD_PFD1_CLKGATE_MASK   (0x8000U)
#define CLKCTL1_AUDIOPLL0PFD_PFD1_CLKGATE_SHIFT  (15U)
/*! PFD1_CLKGATE - PFD1 Clock Gate: 0: PFD1 clock is not gated. 1: PFD1 clock is gated.
 *  0b0..PFD1 clock is not gated.
 *  0b1..PFD1 clock is gated.
 */
#define CLKCTL1_AUDIOPLL0PFD_PFD1_CLKGATE(x)     (((uint32_t)(((uint32_t)(x)) << CLKCTL1_AUDIOPLL0PFD_PFD1_CLKGATE_SHIFT)) & CLKCTL1_AUDIOPLL0PFD_PFD1_CLKGATE_MASK)

#define CLKCTL1_AUDIOPLL0PFD_PFD2_MASK           (0x3F0000U)
#define CLKCTL1_AUDIOPLL0PFD_PFD2_SHIFT          (16U)
/*! PFD2 - PLL Fractional Divider 2: Controls the fractional divider value. Valid PFD values are decimal 12-35.
 */
#define CLKCTL1_AUDIOPLL0PFD_PFD2(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL1_AUDIOPLL0PFD_PFD2_SHIFT)) & CLKCTL1_AUDIOPLL0PFD_PFD2_MASK)

#define CLKCTL1_AUDIOPLL0PFD_PFD2_CLKRDY_MASK    (0x400000U)
#define CLKCTL1_AUDIOPLL0PFD_PFD2_CLKRDY_SHIFT   (22U)
/*! PFD2_CLKRDY - PFD2 Clock Ready Status Flag: Read as 1 clock ready. Cleared by writing a 1.
 */
#define CLKCTL1_AUDIOPLL0PFD_PFD2_CLKRDY(x)      (((uint32_t)(((uint32_t)(x)) << CLKCTL1_AUDIOPLL0PFD_PFD2_CLKRDY_SHIFT)) & CLKCTL1_AUDIOPLL0PFD_PFD2_CLKRDY_MASK)

#define CLKCTL1_AUDIOPLL0PFD_PFD2_CLKGATE_MASK   (0x800000U)
#define CLKCTL1_AUDIOPLL0PFD_PFD2_CLKGATE_SHIFT  (23U)
/*! PFD2_CLKGATE - PFD2 Clock Gate: 0: PFD2 clock is not gated. 1: PFD2 clock is gated.
 *  0b0..PFD2 clock is not gated.
 *  0b1..PFD2 clock is gated.
 */
#define CLKCTL1_AUDIOPLL0PFD_PFD2_CLKGATE(x)     (((uint32_t)(((uint32_t)(x)) << CLKCTL1_AUDIOPLL0PFD_PFD2_CLKGATE_SHIFT)) & CLKCTL1_AUDIOPLL0PFD_PFD2_CLKGATE_MASK)

#define CLKCTL1_AUDIOPLL0PFD_PFD3_MASK           (0x3F000000U)
#define CLKCTL1_AUDIOPLL0PFD_PFD3_SHIFT          (24U)
/*! PFD3 - PLL Fractional Divider 3: Controls the fractional divider value. Valid PFD values are decimal 12-35.
 */
#define CLKCTL1_AUDIOPLL0PFD_PFD3(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL1_AUDIOPLL0PFD_PFD3_SHIFT)) & CLKCTL1_AUDIOPLL0PFD_PFD3_MASK)

#define CLKCTL1_AUDIOPLL0PFD_PFD3_CLKRDY_MASK    (0x40000000U)
#define CLKCTL1_AUDIOPLL0PFD_PFD3_CLKRDY_SHIFT   (30U)
/*! PFD3_CLKRDY - PFD3 Clock Ready Status Flag: Read as 1 clock ready. Cleared by writing a 1.
 */
#define CLKCTL1_AUDIOPLL0PFD_PFD3_CLKRDY(x)      (((uint32_t)(((uint32_t)(x)) << CLKCTL1_AUDIOPLL0PFD_PFD3_CLKRDY_SHIFT)) & CLKCTL1_AUDIOPLL0PFD_PFD3_CLKRDY_MASK)

#define CLKCTL1_AUDIOPLL0PFD_PFD3_CLKGATE_MASK   (0x80000000U)
#define CLKCTL1_AUDIOPLL0PFD_PFD3_CLKGATE_SHIFT  (31U)
/*! PFD3_CLKGATE - PFD3 Clock Gate: 0: PFD3 clock is not gated. 1: PFD3 clock is gated.
 *  0b0..PFD3 clock is not gated.
 *  0b1..PFD3 clock is gated.
 */
#define CLKCTL1_AUDIOPLL0PFD_PFD3_CLKGATE(x)     (((uint32_t)(((uint32_t)(x)) << CLKCTL1_AUDIOPLL0PFD_PFD3_CLKGATE_SHIFT)) & CLKCTL1_AUDIOPLL0PFD_PFD3_CLKGATE_MASK)
/*! @} */

/*! @name AUDIOPLLCLKDIV - audio pll0 clock divider */
/*! @{ */

#define CLKCTL1_AUDIOPLLCLKDIV_DIV_MASK          (0xFFU)
#define CLKCTL1_AUDIOPLLCLKDIV_DIV_SHIFT         (0U)
/*! DIV - Clock Divider Value Selection. . . 0: Divide by 1. ... 255: Divide by 256.
 */
#define CLKCTL1_AUDIOPLLCLKDIV_DIV(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL1_AUDIOPLLCLKDIV_DIV_SHIFT)) & CLKCTL1_AUDIOPLLCLKDIV_DIV_MASK)

#define CLKCTL1_AUDIOPLLCLKDIV_RESET_MASK        (0x20000000U)
#define CLKCTL1_AUDIOPLLCLKDIV_RESET_SHIFT       (29U)
/*! RESET - Resets the divider counter. Can be used to make sure a new divider value is used right
 *    away rather than completing the previous count.
 */
#define CLKCTL1_AUDIOPLLCLKDIV_RESET(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL1_AUDIOPLLCLKDIV_RESET_SHIFT)) & CLKCTL1_AUDIOPLLCLKDIV_RESET_MASK)

#define CLKCTL1_AUDIOPLLCLKDIV_HALT_MASK         (0x40000000U)
#define CLKCTL1_AUDIOPLLCLKDIV_HALT_SHIFT        (30U)
/*! HALT - Halts the divider counter. The intent is to allow the divider's clock source to be
 *    changed without the risk of a glitch at the output.
 */
#define CLKCTL1_AUDIOPLLCLKDIV_HALT(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL1_AUDIOPLLCLKDIV_HALT_SHIFT)) & CLKCTL1_AUDIOPLLCLKDIV_HALT_MASK)

#define CLKCTL1_AUDIOPLLCLKDIV_REQFLAG_MASK      (0x80000000U)
#define CLKCTL1_AUDIOPLLCLKDIV_REQFLAG_SHIFT     (31U)
/*! REQFLAG - Divider status flag. Set when a change is made to the divider value, cleared when the change is complete.
 */
#define CLKCTL1_AUDIOPLLCLKDIV_REQFLAG(x)        (((uint32_t)(((uint32_t)(x)) << CLKCTL1_AUDIOPLLCLKDIV_REQFLAG_SHIFT)) & CLKCTL1_AUDIOPLLCLKDIV_REQFLAG_MASK)
/*! @} */

/*! @name DSPCPUCLKDIV - DSP cpu clock divider */
/*! @{ */

#define CLKCTL1_DSPCPUCLKDIV_DIV_MASK            (0xFFU)
#define CLKCTL1_DSPCPUCLKDIV_DIV_SHIFT           (0U)
/*! DIV - Clock Divider Value Selection. . . 0: Divide by 1. ... 255: Divide by 256.
 */
#define CLKCTL1_DSPCPUCLKDIV_DIV(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL1_DSPCPUCLKDIV_DIV_SHIFT)) & CLKCTL1_DSPCPUCLKDIV_DIV_MASK)

#define CLKCTL1_DSPCPUCLKDIV_RESET_MASK          (0x20000000U)
#define CLKCTL1_DSPCPUCLKDIV_RESET_SHIFT         (29U)
/*! RESET - Resets the divider counter. Can be used to make sure a new divider value is used right
 *    away rather than completing the previous count.
 */
#define CLKCTL1_DSPCPUCLKDIV_RESET(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL1_DSPCPUCLKDIV_RESET_SHIFT)) & CLKCTL1_DSPCPUCLKDIV_RESET_MASK)

#define CLKCTL1_DSPCPUCLKDIV_HALT_MASK           (0x40000000U)
#define CLKCTL1_DSPCPUCLKDIV_HALT_SHIFT          (30U)
/*! HALT - Halts the divider counter. The intent is to allow the divider's clock source to be
 *    changed without the risk of a glitch at the output.
 */
#define CLKCTL1_DSPCPUCLKDIV_HALT(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL1_DSPCPUCLKDIV_HALT_SHIFT)) & CLKCTL1_DSPCPUCLKDIV_HALT_MASK)

#define CLKCTL1_DSPCPUCLKDIV_REQFLAG_MASK        (0x80000000U)
#define CLKCTL1_DSPCPUCLKDIV_REQFLAG_SHIFT       (31U)
/*! REQFLAG - Divider status flag. Set when a change is made to the divider value, cleared when the change is complete.
 */
#define CLKCTL1_DSPCPUCLKDIV_REQFLAG(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL1_DSPCPUCLKDIV_REQFLAG_SHIFT)) & CLKCTL1_DSPCPUCLKDIV_REQFLAG_MASK)
/*! @} */

/*! @name DSPMAINRAMCLKDIV - DSP main ram clock divider */
/*! @{ */

#define CLKCTL1_DSPMAINRAMCLKDIV_DSPMRAMCLKDIV_MASK (0x3U)
#define CLKCTL1_DSPMAINRAMCLKDIV_DSPMRAMCLKDIV_SHIFT (0U)
/*! DSPMRAMCLKDIV - DSP MAINRAM Clock Ratio Control:
 *  0b00..DSP MAINRAM Clk = DSP Core CLK / 1.
 *  0b01..DSP MAINRAM Clk = DSP Core CLK / 2.
 *  0b10..DSP MAINRAM Clk = DSP Core CLK / 3.
 *  0b11..DSP MAINRAM Clk = DSP Core CLK / 4.
 */
#define CLKCTL1_DSPMAINRAMCLKDIV_DSPMRAMCLKDIV(x) (((uint32_t)(((uint32_t)(x)) << CLKCTL1_DSPMAINRAMCLKDIV_DSPMRAMCLKDIV_SHIFT)) & CLKCTL1_DSPMAINRAMCLKDIV_DSPMRAMCLKDIV_MASK)
/*! @} */

/*! @name DSPCPUCLKSELA - DSP clock selection A */
/*! @{ */

#define CLKCTL1_DSPCPUCLKSELA_SEL_MASK           (0x3U)
#define CLKCTL1_DSPCPUCLKSELA_SEL_SHIFT          (0U)
/*! SEL - Control Main 1st Stage Control Clock Source. . .
 *  0b00..FFRO Clock.
 *  0b01..XTALIN Clock.
 *  0b10..Low Power Oscillator Clock (LPOSC).
 *  0b11..SFRO Clock.
 */
#define CLKCTL1_DSPCPUCLKSELA_SEL(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL1_DSPCPUCLKSELA_SEL_SHIFT)) & CLKCTL1_DSPCPUCLKSELA_SEL_MASK)
/*! @} */

/*! @name DSPCPUCLKSELB - DSP clock selection B */
/*! @{ */

#define CLKCTL1_DSPCPUCLKSELB_SEL_MASK           (0x3U)
#define CLKCTL1_DSPCPUCLKSELB_SEL_SHIFT          (0U)
/*! SEL - Main Clock Source Selection. . .
 *  0b00..MAINCLKSELA 1st Stage Clock.
 *  0b01..Main System PLL Clock.
 *  0b10..DSP System PLL Clock.
 *  0b11..RTC 32KHz Clock.
 */
#define CLKCTL1_DSPCPUCLKSELB_SEL(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL1_DSPCPUCLKSELB_SEL_SHIFT)) & CLKCTL1_DSPCPUCLKSELB_SEL_MASK)
/*! @} */

/*! @name OSEVENTFCLKSEL - OS EVENT clock selection */
/*! @{ */

#define CLKCTL1_OSEVENTFCLKSEL_SEL_MASK          (0x7U)
#define CLKCTL1_OSEVENTFCLKSEL_SEL_SHIFT         (0U)
/*! SEL - OS Event Timer Functional Clock Source Selection. . .
 *  0b000..Low Power Oscillator Clock (LPOSC).
 *  0b001..RTC 32KHz Clock.
 *  0b010..Teal Free Running Clock (Global Time Stamping)
 *  0b011..reserved
 *  0b100..reserved
 *  0b101..reserved
 *  0b110..reserved
 *  0b111..None, this may be selected in order to reduce power when no output is needed.
 */
#define CLKCTL1_OSEVENTFCLKSEL_SEL(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL1_OSEVENTFCLKSEL_SEL_SHIFT)) & CLKCTL1_OSEVENTFCLKSEL_SEL_MASK)
/*! @} */

/*! @name FRGCLKSEL - FRG clock selection register N */
/*! @{ */

#define CLKCTL1_FRGCLKSEL_SEL_MASK               (0x7U)
#define CLKCTL1_FRGCLKSEL_SEL_SHIFT              (0U)
/*! SEL - Fractional Gen. Clock Source Selection. . .
 *  0b000..Main Clock.
 *  0b001..FRG PLL Clock.
 *  0b010..SFRO Clock.
 *  0b011..FFRO Clock.
 *  0b100..reserved
 *  0b101..reserved
 *  0b110..reserved
 *  0b111..None, this may be selected in order to reduce power when no output is needed.
 */
#define CLKCTL1_FRGCLKSEL_SEL(x)                 (((uint32_t)(((uint32_t)(x)) << CLKCTL1_FRGCLKSEL_SEL_SHIFT)) & CLKCTL1_FRGCLKSEL_SEL_MASK)
/*! @} */

/* The count of CLKCTL1_FRGCLKSEL */
#define CLKCTL1_FRGCLKSEL_COUNT                  (8U)

/*! @name FRGCTL - FRG clock controller */
/*! @{ */

#define CLKCTL1_FRGCTL_DIV_MASK                  (0xFFU)
#define CLKCTL1_FRGCTL_DIV_SHIFT                 (0U)
/*! DIV - Denominator of the fractional divider. DIV is equal to the programmed value +1. Always set
 *    to 0xFF to use with the fractional baud rate generator.
 */
#define CLKCTL1_FRGCTL_DIV(x)                    (((uint32_t)(((uint32_t)(x)) << CLKCTL1_FRGCTL_DIV_SHIFT)) & CLKCTL1_FRGCTL_DIV_MASK)

#define CLKCTL1_FRGCTL_MULT_MASK                 (0xFF00U)
#define CLKCTL1_FRGCTL_MULT_SHIFT                (8U)
/*! MULT - Numerator of the fractional divider. MULT is equal to the programmed value.
 */
#define CLKCTL1_FRGCTL_MULT(x)                   (((uint32_t)(((uint32_t)(x)) << CLKCTL1_FRGCTL_MULT_SHIFT)) & CLKCTL1_FRGCTL_MULT_MASK)
/*! @} */

/* The count of CLKCTL1_FRGCTL */
#define CLKCTL1_FRGCTL_COUNT                     (8U)

/*! @name FCFCLKSEL - flexcomm clock selection */
/*! @{ */

#define CLKCTL1_FCFCLKSEL_SEL_MASK               (0x7U)
#define CLKCTL1_FCFCLKSEL_SEL_SHIFT              (0U)
/*! SEL - Flexxcomm Functional Clock Source Selection. . .
 *  0b000..SFRO Clock.
 *  0b001..FFRO Clock.
 *  0b010..Audio PLL Clock.
 *  0b011..Master Clock In.
 *  0b100..FCn FRG Clock.
 *  0b101..reserved
 *  0b110..reserved
 *  0b111..None, this may be selected in order to reduce power when no output is needed.
 */
#define CLKCTL1_FCFCLKSEL_SEL(x)                 (((uint32_t)(((uint32_t)(x)) << CLKCTL1_FCFCLKSEL_SEL_SHIFT)) & CLKCTL1_FCFCLKSEL_SEL_MASK)
/*! @} */

/* The count of CLKCTL1_FCFCLKSEL */
#define CLKCTL1_FCFCLKSEL_COUNT                  (8U)

/*! @name FRG14CLKSEL - FRG clock selection register 14 */
/*! @{ */

#define CLKCTL1_FRG14CLKSEL_SEL_MASK             (0x7U)
#define CLKCTL1_FRG14CLKSEL_SEL_SHIFT            (0U)
/*! SEL - Fractional Gen. Clock Source Selection. . .
 *  0b000..Main Clock.
 *  0b001..Main System PLL Clock.
 *  0b010..SFRO Clock.
 *  0b011..FFRO Clock.
 *  0b100..reserved
 *  0b101..reserved
 *  0b110..reserved
 *  0b111..None, this may be selected in order to reduce power when no output is needed.
 */
#define CLKCTL1_FRG14CLKSEL_SEL(x)               (((uint32_t)(((uint32_t)(x)) << CLKCTL1_FRG14CLKSEL_SEL_SHIFT)) & CLKCTL1_FRG14CLKSEL_SEL_MASK)
/*! @} */

/*! @name FRG14CTL - FRG clock controller 14 */
/*! @{ */

#define CLKCTL1_FRG14CTL_DIV_MASK                (0xFFU)
#define CLKCTL1_FRG14CTL_DIV_SHIFT               (0U)
/*! DIV - Denominator of the fractional divider. DIV is equal to the programmed value +1. Always set
 *    to 0xFF to use with the fractional baud rate generator.
 */
#define CLKCTL1_FRG14CTL_DIV(x)                  (((uint32_t)(((uint32_t)(x)) << CLKCTL1_FRG14CTL_DIV_SHIFT)) & CLKCTL1_FRG14CTL_DIV_MASK)

#define CLKCTL1_FRG14CTL_MULT_MASK               (0xFF00U)
#define CLKCTL1_FRG14CTL_MULT_SHIFT              (8U)
/*! MULT - Numerator of the fractional divider. MULT is equal to the programmed value.
 */
#define CLKCTL1_FRG14CTL_MULT(x)                 (((uint32_t)(((uint32_t)(x)) << CLKCTL1_FRG14CTL_MULT_SHIFT)) & CLKCTL1_FRG14CTL_MULT_MASK)
/*! @} */

/*! @name FC14FCLKSEL - flexcomm14 clock selection */
/*! @{ */

#define CLKCTL1_FC14FCLKSEL_SEL_MASK             (0x7U)
#define CLKCTL1_FC14FCLKSEL_SEL_SHIFT            (0U)
/*! SEL - Flexxcomm Functional Clock Source Selection. . .
 *  0b000..SFRO Clock.
 *  0b001..FFRO Clock.
 *  0b010..Audio PLL Clock.
 *  0b011..Master Clock In.
 *  0b100..FCn FRG Clock.
 *  0b101..reserved
 *  0b110..reserved
 *  0b111..None, this may be selected in order to reduce power when no output is needed.
 */
#define CLKCTL1_FC14FCLKSEL_SEL(x)               (((uint32_t)(((uint32_t)(x)) << CLKCTL1_FC14FCLKSEL_SEL_SHIFT)) & CLKCTL1_FC14FCLKSEL_SEL_MASK)
/*! @} */

/*! @name FRG15CLKSEL - FRG clock selection register 15 */
/*! @{ */

#define CLKCTL1_FRG15CLKSEL_SEL_MASK             (0x7U)
#define CLKCTL1_FRG15CLKSEL_SEL_SHIFT            (0U)
/*! SEL - Fractional Gen. Clock Source Selection. . .
 *  0b000..Main Clock.
 *  0b001..Main System PLL Clock.
 *  0b010..SFRO Clock.
 *  0b011..FFRO Clock.
 *  0b100..reserved
 *  0b101..reserved
 *  0b110..reserved
 *  0b111..None, this may be selected in order to reduce power when no output is needed.
 */
#define CLKCTL1_FRG15CLKSEL_SEL(x)               (((uint32_t)(((uint32_t)(x)) << CLKCTL1_FRG15CLKSEL_SEL_SHIFT)) & CLKCTL1_FRG15CLKSEL_SEL_MASK)
/*! @} */

/*! @name FRG15CTL - FRG clock controller 15 */
/*! @{ */

#define CLKCTL1_FRG15CTL_DIV_MASK                (0xFFU)
#define CLKCTL1_FRG15CTL_DIV_SHIFT               (0U)
/*! DIV - Denominator of the fractional divider. DIV is equal to the programmed value +1. Always set
 *    to 0xFF to use with the fractional baud rate generator.
 */
#define CLKCTL1_FRG15CTL_DIV(x)                  (((uint32_t)(((uint32_t)(x)) << CLKCTL1_FRG15CTL_DIV_SHIFT)) & CLKCTL1_FRG15CTL_DIV_MASK)

#define CLKCTL1_FRG15CTL_MULT_MASK               (0xFF00U)
#define CLKCTL1_FRG15CTL_MULT_SHIFT              (8U)
/*! MULT - Numerator of the fractional divider. MULT is equal to the programmed value.
 */
#define CLKCTL1_FRG15CTL_MULT(x)                 (((uint32_t)(((uint32_t)(x)) << CLKCTL1_FRG15CTL_MULT_SHIFT)) & CLKCTL1_FRG15CTL_MULT_MASK)
/*! @} */

/*! @name FC15FCLKSEL - flexcomm15 clock selection */
/*! @{ */

#define CLKCTL1_FC15FCLKSEL_SEL_MASK             (0x7U)
#define CLKCTL1_FC15FCLKSEL_SEL_SHIFT            (0U)
/*! SEL - Flexxcomm Functional Clock Source Selection. . .
 *  0b000..SFRO Clock.
 *  0b001..FFRO Clock.
 *  0b010..Audio PLL Clock.
 *  0b011..Master Clock In.
 *  0b100..FCn FRG Clock.
 *  0b101..reserved
 *  0b110..reserved
 *  0b111..None, this may be selected in order to reduce power when no output is needed.
 */
#define CLKCTL1_FC15FCLKSEL_SEL(x)               (((uint32_t)(((uint32_t)(x)) << CLKCTL1_FC15FCLKSEL_SEL_SHIFT)) & CLKCTL1_FC15FCLKSEL_SEL_MASK)
/*! @} */

/*! @name FRGPLLCLKDIV - FRG pll clock divider */
/*! @{ */

#define CLKCTL1_FRGPLLCLKDIV_DIV_MASK            (0xFFU)
#define CLKCTL1_FRGPLLCLKDIV_DIV_SHIFT           (0U)
/*! DIV - Clock Divider Value Selection. . . 0: Divide by 1. ... 255: Divide by 256.
 */
#define CLKCTL1_FRGPLLCLKDIV_DIV(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL1_FRGPLLCLKDIV_DIV_SHIFT)) & CLKCTL1_FRGPLLCLKDIV_DIV_MASK)

#define CLKCTL1_FRGPLLCLKDIV_RESET_MASK          (0x20000000U)
#define CLKCTL1_FRGPLLCLKDIV_RESET_SHIFT         (29U)
/*! RESET - Resets the divider counter. Can be used to make sure a new divider value is used right
 *    away rather than completing the previous count.
 */
#define CLKCTL1_FRGPLLCLKDIV_RESET(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL1_FRGPLLCLKDIV_RESET_SHIFT)) & CLKCTL1_FRGPLLCLKDIV_RESET_MASK)

#define CLKCTL1_FRGPLLCLKDIV_HALT_MASK           (0x40000000U)
#define CLKCTL1_FRGPLLCLKDIV_HALT_SHIFT          (30U)
/*! HALT - Halts the divider counter. The intent is to allow the divider clock source to be changed
 *    without the risk of a glitch at the output.
 */
#define CLKCTL1_FRGPLLCLKDIV_HALT(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL1_FRGPLLCLKDIV_HALT_SHIFT)) & CLKCTL1_FRGPLLCLKDIV_HALT_MASK)

#define CLKCTL1_FRGPLLCLKDIV_REQFLAG_MASK        (0x80000000U)
#define CLKCTL1_FRGPLLCLKDIV_REQFLAG_SHIFT       (31U)
/*! REQFLAG - Divider status flag. Set when a change is made to the divider value, cleared when the change is complete.
 */
#define CLKCTL1_FRGPLLCLKDIV_REQFLAG(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL1_FRGPLLCLKDIV_REQFLAG_SHIFT)) & CLKCTL1_FRGPLLCLKDIV_REQFLAG_MASK)
/*! @} */

/*! @name DMIC0FCLKSEL - DMIC0 clk selection */
/*! @{ */

#define CLKCTL1_DMIC0FCLKSEL_SEL_MASK            (0x7U)
#define CLKCTL1_DMIC0FCLKSEL_SEL_SHIFT           (0U)
/*! SEL - DMIC Functional Clock Source Selection. . .
 *  0b000..SFRO Clock.
 *  0b001..FFRO Clock.
 *  0b010..Audio PLL Clock.
 *  0b011..Master Clock In.
 *  0b100..Low Power Oscillator Clock (LPOSC).
 *  0b101..32KHZ Wake Clk.
 *  0b110..reserved
 *  0b111..None, this may be selected in order to reduce power when no output is needed.
 */
#define CLKCTL1_DMIC0FCLKSEL_SEL(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL1_DMIC0FCLKSEL_SEL_SHIFT)) & CLKCTL1_DMIC0FCLKSEL_SEL_MASK)
/*! @} */

/*! @name DMIC0FCLKDIV - DMIC clock clock divider */
/*! @{ */

#define CLKCTL1_DMIC0FCLKDIV_DIV_MASK            (0xFFU)
#define CLKCTL1_DMIC0FCLKDIV_DIV_SHIFT           (0U)
/*! DIV - Clock Divider Value Selection. . . 0: Divide by 1. ... 255: Divide by 256.
 */
#define CLKCTL1_DMIC0FCLKDIV_DIV(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL1_DMIC0FCLKDIV_DIV_SHIFT)) & CLKCTL1_DMIC0FCLKDIV_DIV_MASK)

#define CLKCTL1_DMIC0FCLKDIV_RESET_MASK          (0x20000000U)
#define CLKCTL1_DMIC0FCLKDIV_RESET_SHIFT         (29U)
/*! RESET - Resets the divider counter. Can be used to make sure a new divider value is used right
 *    away rather than completing the previous count.
 */
#define CLKCTL1_DMIC0FCLKDIV_RESET(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL1_DMIC0FCLKDIV_RESET_SHIFT)) & CLKCTL1_DMIC0FCLKDIV_RESET_MASK)

#define CLKCTL1_DMIC0FCLKDIV_HALT_MASK           (0x40000000U)
#define CLKCTL1_DMIC0FCLKDIV_HALT_SHIFT          (30U)
/*! HALT - Halts the divider counter. The intent is to allow the divider's clock source to be
 *    changed without the risk of a glitch at the output.
 */
#define CLKCTL1_DMIC0FCLKDIV_HALT(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL1_DMIC0FCLKDIV_HALT_SHIFT)) & CLKCTL1_DMIC0FCLKDIV_HALT_MASK)

#define CLKCTL1_DMIC0FCLKDIV_REQFLAG_MASK        (0x80000000U)
#define CLKCTL1_DMIC0FCLKDIV_REQFLAG_SHIFT       (31U)
/*! REQFLAG - Divider status flag. Set when a change is made to the divider value, cleared when the change is complete.
 */
#define CLKCTL1_DMIC0FCLKDIV_REQFLAG(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL1_DMIC0FCLKDIV_REQFLAG_SHIFT)) & CLKCTL1_DMIC0FCLKDIV_REQFLAG_MASK)
/*! @} */

/*! @name CT32BITFCLKSEL - ct32bit timer N clock selection */
/*! @{ */

#define CLKCTL1_CT32BITFCLKSEL_SEL_MASK          (0x7U)
#define CLKCTL1_CT32BITFCLKSEL_SEL_SHIFT         (0U)
/*! SEL - CT32Bit Functional Clock Source Selection. . .
 *  0b000..Main Clock.
 *  0b001..SFRO Clock.
 *  0b010..FFRO Clock.
 *  0b011..Audio PLL Clock.
 *  0b100..Master Clock In.
 *  0b101..Low Power Oscillator Clock (LPOSC).
 *  0b110..reserved
 *  0b111..None, this may be selected in order to reduce power when no output is needed.
 */
#define CLKCTL1_CT32BITFCLKSEL_SEL(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL1_CT32BITFCLKSEL_SEL_SHIFT)) & CLKCTL1_CT32BITFCLKSEL_SEL_MASK)
/*! @} */

/* The count of CLKCTL1_CT32BITFCLKSEL */
#define CLKCTL1_CT32BITFCLKSEL_COUNT             (5U)

/*! @name AUDIOMCLKSEL - audio mclock selection */
/*! @{ */

#define CLKCTL1_AUDIOMCLKSEL_SEL_MASK            (0x7U)
#define CLKCTL1_AUDIOMCLKSEL_SEL_SHIFT           (0U)
/*! SEL - Audio MCLK Clock Source Selection. . .
 *  0b000..FFRO Clock.
 *  0b001..AUDIO PLL Clock. (Shared Domain)
 *  0b010..reserved
 *  0b011..reserved.
 *  0b100..reserved.
 *  0b101..reserved.
 *  0b110..Reserved.
 *  0b111..None, this may be selected in order to reduce power when no output is needed.
 */
#define CLKCTL1_AUDIOMCLKSEL_SEL(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL1_AUDIOMCLKSEL_SEL_SHIFT)) & CLKCTL1_AUDIOMCLKSEL_SEL_MASK)
/*! @} */

/*! @name AUDIOMCLKDIV - audio mclock divider */
/*! @{ */

#define CLKCTL1_AUDIOMCLKDIV_DIV_MASK            (0xFFU)
#define CLKCTL1_AUDIOMCLKDIV_DIV_SHIFT           (0U)
/*! DIV - Clock Divider Value Selection. . . 0: Divide by 1. ... 255: Divide by 256.
 */
#define CLKCTL1_AUDIOMCLKDIV_DIV(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL1_AUDIOMCLKDIV_DIV_SHIFT)) & CLKCTL1_AUDIOMCLKDIV_DIV_MASK)

#define CLKCTL1_AUDIOMCLKDIV_RESET_MASK          (0x20000000U)
#define CLKCTL1_AUDIOMCLKDIV_RESET_SHIFT         (29U)
/*! RESET - Resets the divider counter. Can be used to make sure a new divider value is used right
 *    away rather than completing the previous count.
 */
#define CLKCTL1_AUDIOMCLKDIV_RESET(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL1_AUDIOMCLKDIV_RESET_SHIFT)) & CLKCTL1_AUDIOMCLKDIV_RESET_MASK)

#define CLKCTL1_AUDIOMCLKDIV_HALT_MASK           (0x40000000U)
#define CLKCTL1_AUDIOMCLKDIV_HALT_SHIFT          (30U)
/*! HALT - Halts the divider counter. The intent is to allow the divider's clock source to be
 *    changed without the risk of a glitch at the output.
 */
#define CLKCTL1_AUDIOMCLKDIV_HALT(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL1_AUDIOMCLKDIV_HALT_SHIFT)) & CLKCTL1_AUDIOMCLKDIV_HALT_MASK)

#define CLKCTL1_AUDIOMCLKDIV_REQFLAG_MASK        (0x80000000U)
#define CLKCTL1_AUDIOMCLKDIV_REQFLAG_SHIFT       (31U)
/*! REQFLAG - Divider status flag. Set when a change is made to the divider value, cleared when the change is complete.
 */
#define CLKCTL1_AUDIOMCLKDIV_REQFLAG(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL1_AUDIOMCLKDIV_REQFLAG_SHIFT)) & CLKCTL1_AUDIOMCLKDIV_REQFLAG_MASK)
/*! @} */

/*! @name CLKOUTSEL0 - clock out selection 0 */
/*! @{ */

#define CLKCTL1_CLKOUTSEL0_SEL_MASK              (0x7U)
#define CLKCTL1_CLKOUTSEL0_SEL_SHIFT             (0U)
/*! SEL - Clock Output Select 1st Stage. . .
 *  0b000..SFRO Clock.
 *  0b001..XTALIN Clock.
 *  0b010..Low Power Oscillator Clock (LPOSC).
 *  0b011..FFRO Clock.
 *  0b100..Main Clock.
 *  0b101..reserved
 *  0b110..DSP Main Clock.
 *  0b111..None, this may be selected in order to reduce power when no output is needed.
 */
#define CLKCTL1_CLKOUTSEL0_SEL(x)                (((uint32_t)(((uint32_t)(x)) << CLKCTL1_CLKOUTSEL0_SEL_SHIFT)) & CLKCTL1_CLKOUTSEL0_SEL_MASK)
/*! @} */

/*! @name CLKOUTSEL1 - clock out selection 1 */
/*! @{ */

#define CLKCTL1_CLKOUTSEL1_SEL_MASK              (0x7U)
#define CLKCTL1_CLKOUTSEL1_SEL_SHIFT             (0U)
/*! SEL - Clock out clock Source Selection. . .
 *  0b000..CLKOUTSEL0 Multiplexed Output.
 *  0b001..Main System PLL Clock.
 *  0b010..SYSPLL0 AUX0_PLL_Clock.
 *  0b011..DSP PLL clock.
 *  0b100..SYSPLL0 AUX1_PLL_Clock.
 *  0b101..AUDIO PLL Clock.
 *  0b110..32KHz RTC Clock.
 *  0b111..None, this may be selected in order to reduce power when no output is needed.
 */
#define CLKCTL1_CLKOUTSEL1_SEL(x)                (((uint32_t)(((uint32_t)(x)) << CLKCTL1_CLKOUTSEL1_SEL_SHIFT)) & CLKCTL1_CLKOUTSEL1_SEL_MASK)
/*! @} */

/*! @name CLKOUTDIV - clock_out divider */
/*! @{ */

#define CLKCTL1_CLKOUTDIV_DIV_MASK               (0xFFU)
#define CLKCTL1_CLKOUTDIV_DIV_SHIFT              (0U)
/*! DIV - Clock Divider Value Selection. . . 0: Divide by 1. ... 255: Divide by 256.
 */
#define CLKCTL1_CLKOUTDIV_DIV(x)                 (((uint32_t)(((uint32_t)(x)) << CLKCTL1_CLKOUTDIV_DIV_SHIFT)) & CLKCTL1_CLKOUTDIV_DIV_MASK)

#define CLKCTL1_CLKOUTDIV_RESET_MASK             (0x20000000U)
#define CLKCTL1_CLKOUTDIV_RESET_SHIFT            (29U)
/*! RESET - Resets the divider counter. Can be used to make sure a new divider value is used right
 *    away rather than completing the previous count.
 */
#define CLKCTL1_CLKOUTDIV_RESET(x)               (((uint32_t)(((uint32_t)(x)) << CLKCTL1_CLKOUTDIV_RESET_SHIFT)) & CLKCTL1_CLKOUTDIV_RESET_MASK)

#define CLKCTL1_CLKOUTDIV_HALT_MASK              (0x40000000U)
#define CLKCTL1_CLKOUTDIV_HALT_SHIFT             (30U)
/*! HALT - Halts the divider counter. The intent is to allow the divider's clock source to be
 *    changed without the risk of a glitch at the output.
 */
#define CLKCTL1_CLKOUTDIV_HALT(x)                (((uint32_t)(((uint32_t)(x)) << CLKCTL1_CLKOUTDIV_HALT_SHIFT)) & CLKCTL1_CLKOUTDIV_HALT_MASK)

#define CLKCTL1_CLKOUTDIV_REQFLAG_MASK           (0x80000000U)
#define CLKCTL1_CLKOUTDIV_REQFLAG_SHIFT          (31U)
/*! REQFLAG - Divider status flag. Set when a change is made to the divider value, cleared when the change is complete.
 */
#define CLKCTL1_CLKOUTDIV_REQFLAG(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL1_CLKOUTDIV_REQFLAG_SHIFT)) & CLKCTL1_CLKOUTDIV_REQFLAG_MASK)
/*! @} */

/*! @name I3C0FCLKSEL - I3C0 fclk selection */
/*! @{ */

#define CLKCTL1_I3C0FCLKSEL_SEL_MASK             (0x7U)
#define CLKCTL1_I3C0FCLKSEL_SEL_SHIFT            (0U)
/*! SEL - I3C0 FClock Source Selection. . .
 *  0b000..Main Clock.
 *  0b001..FFRO Clock.
 *  0b010..reserved.
 *  0b011..reserved.
 *  0b100..reserved.
 *  0b101..reserved.
 *  0b110..Reserved.
 *  0b111..None, this may be selected in order to reduce power when no output is needed.
 */
#define CLKCTL1_I3C0FCLKSEL_SEL(x)               (((uint32_t)(((uint32_t)(x)) << CLKCTL1_I3C0FCLKSEL_SEL_SHIFT)) & CLKCTL1_I3C0FCLKSEL_SEL_MASK)
/*! @} */

/*! @name I3C0FCLKSTCSEL - I3C0 fclk STC selection */
/*! @{ */

#define CLKCTL1_I3C0FCLKSTCSEL_SEL_MASK          (0x7U)
#define CLKCTL1_I3C0FCLKSTCSEL_SEL_SHIFT         (0U)
/*! SEL - I3C0 Clock Source Selection. . .
 *  0b000..I3C0 FCLK Selection.
 *  0b001..Low Power Oscillator Clock (LPOSC).
 *  0b010..Reserved.
 *  0b011..Reserved.
 *  0b100..reserved.
 *  0b101..reserved.
 *  0b110..Reserved.
 *  0b111..None, this may be selected in order to reduce power when no output is needed.
 */
#define CLKCTL1_I3C0FCLKSTCSEL_SEL(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL1_I3C0FCLKSTCSEL_SEL_SHIFT)) & CLKCTL1_I3C0FCLKSTCSEL_SEL_MASK)
/*! @} */

/*! @name I3C0FCLKSTCDIV - I3C0 fclk STC divider */
/*! @{ */

#define CLKCTL1_I3C0FCLKSTCDIV_DIV_MASK          (0xFFU)
#define CLKCTL1_I3C0FCLKSTCDIV_DIV_SHIFT         (0U)
/*! DIV - Clock Divider Value Selection. . . 0: Divide by 1. ... 255: Divide by 256.
 */
#define CLKCTL1_I3C0FCLKSTCDIV_DIV(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL1_I3C0FCLKSTCDIV_DIV_SHIFT)) & CLKCTL1_I3C0FCLKSTCDIV_DIV_MASK)

#define CLKCTL1_I3C0FCLKSTCDIV_RESET_MASK        (0x20000000U)
#define CLKCTL1_I3C0FCLKSTCDIV_RESET_SHIFT       (29U)
/*! RESET - Resets the divider counter. Can be used to make sure a new divider value is used right
 *    away rather than completing the previous count.
 */
#define CLKCTL1_I3C0FCLKSTCDIV_RESET(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL1_I3C0FCLKSTCDIV_RESET_SHIFT)) & CLKCTL1_I3C0FCLKSTCDIV_RESET_MASK)

#define CLKCTL1_I3C0FCLKSTCDIV_HALT_MASK         (0x40000000U)
#define CLKCTL1_I3C0FCLKSTCDIV_HALT_SHIFT        (30U)
/*! HALT - Halts the divider counter. The intent is to allow the divider's clock source to be
 *    changed without the risk of a glitch at the output.
 */
#define CLKCTL1_I3C0FCLKSTCDIV_HALT(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL1_I3C0FCLKSTCDIV_HALT_SHIFT)) & CLKCTL1_I3C0FCLKSTCDIV_HALT_MASK)

#define CLKCTL1_I3C0FCLKSTCDIV_REQFLAG_MASK      (0x80000000U)
#define CLKCTL1_I3C0FCLKSTCDIV_REQFLAG_SHIFT     (31U)
/*! REQFLAG - Divider status flag. Set when a change is made to the divider value, cleared when the change is complete.
 */
#define CLKCTL1_I3C0FCLKSTCDIV_REQFLAG(x)        (((uint32_t)(((uint32_t)(x)) << CLKCTL1_I3C0FCLKSTCDIV_REQFLAG_SHIFT)) & CLKCTL1_I3C0FCLKSTCDIV_REQFLAG_MASK)
/*! @} */

/*! @name I3C0FCLKSDIV - I3C0 fclks divider */
/*! @{ */

#define CLKCTL1_I3C0FCLKSDIV_DIV_MASK            (0xFFU)
#define CLKCTL1_I3C0FCLKSDIV_DIV_SHIFT           (0U)
/*! DIV - Clock Divider Value Selection. . . 0: Divide by 1. ... 255: Divide by 256.
 */
#define CLKCTL1_I3C0FCLKSDIV_DIV(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL1_I3C0FCLKSDIV_DIV_SHIFT)) & CLKCTL1_I3C0FCLKSDIV_DIV_MASK)

#define CLKCTL1_I3C0FCLKSDIV_RESET_MASK          (0x20000000U)
#define CLKCTL1_I3C0FCLKSDIV_RESET_SHIFT         (29U)
/*! RESET - Resets the divider counter. Can be used to make sure a new divider value is used right
 *    away rather than completing the previous count.
 */
#define CLKCTL1_I3C0FCLKSDIV_RESET(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL1_I3C0FCLKSDIV_RESET_SHIFT)) & CLKCTL1_I3C0FCLKSDIV_RESET_MASK)

#define CLKCTL1_I3C0FCLKSDIV_HALT_MASK           (0x40000000U)
#define CLKCTL1_I3C0FCLKSDIV_HALT_SHIFT          (30U)
/*! HALT - Halts the divider counter. The intent is to allow the divider clock source to be changed
 *    without the risk of a glitch at the output.
 */
#define CLKCTL1_I3C0FCLKSDIV_HALT(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL1_I3C0FCLKSDIV_HALT_SHIFT)) & CLKCTL1_I3C0FCLKSDIV_HALT_MASK)

#define CLKCTL1_I3C0FCLKSDIV_REQFLAG_MASK        (0x80000000U)
#define CLKCTL1_I3C0FCLKSDIV_REQFLAG_SHIFT       (31U)
/*! REQFLAG - Divider status flag. Set when a change is made to the divider value, cleared when the change is complete.
 */
#define CLKCTL1_I3C0FCLKSDIV_REQFLAG(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL1_I3C0FCLKSDIV_REQFLAG_SHIFT)) & CLKCTL1_I3C0FCLKSDIV_REQFLAG_MASK)
/*! @} */

/*! @name I3C0FCLKDIV - I3C0 fclk divider */
/*! @{ */

#define CLKCTL1_I3C0FCLKDIV_DIV_MASK             (0xFFU)
#define CLKCTL1_I3C0FCLKDIV_DIV_SHIFT            (0U)
/*! DIV - Clock Divider Value Selection. . . 0: Divide by 1. ... 255: Divide by 256.
 */
#define CLKCTL1_I3C0FCLKDIV_DIV(x)               (((uint32_t)(((uint32_t)(x)) << CLKCTL1_I3C0FCLKDIV_DIV_SHIFT)) & CLKCTL1_I3C0FCLKDIV_DIV_MASK)

#define CLKCTL1_I3C0FCLKDIV_RESET_MASK           (0x20000000U)
#define CLKCTL1_I3C0FCLKDIV_RESET_SHIFT          (29U)
/*! RESET - Resets the divider counter. Can be used to make sure a new divider value is used right
 *    away rather than completing the previous count.
 */
#define CLKCTL1_I3C0FCLKDIV_RESET(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL1_I3C0FCLKDIV_RESET_SHIFT)) & CLKCTL1_I3C0FCLKDIV_RESET_MASK)

#define CLKCTL1_I3C0FCLKDIV_HALT_MASK            (0x40000000U)
#define CLKCTL1_I3C0FCLKDIV_HALT_SHIFT           (30U)
/*! HALT - Halts the divider counter. The intent is to allow the divider clock source to be changed
 *    without the risk of a glitch at the output.
 */
#define CLKCTL1_I3C0FCLKDIV_HALT(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL1_I3C0FCLKDIV_HALT_SHIFT)) & CLKCTL1_I3C0FCLKDIV_HALT_MASK)

#define CLKCTL1_I3C0FCLKDIV_REQFLAG_MASK         (0x80000000U)
#define CLKCTL1_I3C0FCLKDIV_REQFLAG_SHIFT        (31U)
/*! REQFLAG - Divider status flag. Set when a change is made to the divider value, cleared when the change is complete.
 */
#define CLKCTL1_I3C0FCLKDIV_REQFLAG(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL1_I3C0FCLKDIV_REQFLAG_SHIFT)) & CLKCTL1_I3C0FCLKDIV_REQFLAG_MASK)
/*! @} */

/*! @name WDT1FCLKSEL - WDT1 clock selection */
/*! @{ */

#define CLKCTL1_WDT1FCLKSEL_SEL_MASK             (0x7U)
#define CLKCTL1_WDT1FCLKSEL_SEL_SHIFT            (0U)
/*! SEL - WDT1 Functional Clock Source Selection. . .
 *  0b000..Low Power Oscillator Clock (LPOSC).
 *  0b001..reserved
 *  0b010..Reserved.
 *  0b011..Reserved.
 *  0b100..reserved.
 *  0b101..reserved.
 *  0b110..Reserved.
 *  0b111..None, this may be selected in order to reduce power when no output is needed.
 */
#define CLKCTL1_WDT1FCLKSEL_SEL(x)               (((uint32_t)(((uint32_t)(x)) << CLKCTL1_WDT1FCLKSEL_SEL_SHIFT)) & CLKCTL1_WDT1FCLKSEL_SEL_MASK)
/*! @} */

/*! @name ACMP0FCLKSEL - acomparator 0 clock selection */
/*! @{ */

#define CLKCTL1_ACMP0FCLKSEL_SEL_MASK            (0x7U)
#define CLKCTL1_ACMP0FCLKSEL_SEL_SHIFT           (0U)
/*! SEL - ACMP0 Fast Functional Clock Source Selection. . .
 *  0b000..Main Clock.
 *  0b001..SFRO Clock.
 *  0b010..FFRO Clock.
 *  0b011..SYSPLL0 AUX0_PLL_Clock.
 *  0b100..SYSPLL0 AUX1_PLL_Clock.
 *  0b101..reserved.
 *  0b110..Reserved.
 *  0b111..None, this may be selected in order to reduce power when no output is needed.
 */
#define CLKCTL1_ACMP0FCLKSEL_SEL(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL1_ACMP0FCLKSEL_SEL_SHIFT)) & CLKCTL1_ACMP0FCLKSEL_SEL_MASK)
/*! @} */

/*! @name ACMP0FCLKDIV - acomparator 0 fclk divider */
/*! @{ */

#define CLKCTL1_ACMP0FCLKDIV_DIV_MASK            (0xFFU)
#define CLKCTL1_ACMP0FCLKDIV_DIV_SHIFT           (0U)
/*! DIV - Clock Divider Value Selection. . . 0: Divide by 1. ... 255: Divide by 256.
 */
#define CLKCTL1_ACMP0FCLKDIV_DIV(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL1_ACMP0FCLKDIV_DIV_SHIFT)) & CLKCTL1_ACMP0FCLKDIV_DIV_MASK)

#define CLKCTL1_ACMP0FCLKDIV_RESET_MASK          (0x20000000U)
#define CLKCTL1_ACMP0FCLKDIV_RESET_SHIFT         (29U)
/*! RESET - Resets the divider counter. Can be used to make sure a new divider value is used right
 *    away rather than completing the previous count.
 */
#define CLKCTL1_ACMP0FCLKDIV_RESET(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL1_ACMP0FCLKDIV_RESET_SHIFT)) & CLKCTL1_ACMP0FCLKDIV_RESET_MASK)

#define CLKCTL1_ACMP0FCLKDIV_HALT_MASK           (0x40000000U)
#define CLKCTL1_ACMP0FCLKDIV_HALT_SHIFT          (30U)
/*! HALT - Halts the divider counter. The intent is to allow the divider clock source to be changed
 *    without the risk of a glitch at the output.
 */
#define CLKCTL1_ACMP0FCLKDIV_HALT(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL1_ACMP0FCLKDIV_HALT_SHIFT)) & CLKCTL1_ACMP0FCLKDIV_HALT_MASK)

#define CLKCTL1_ACMP0FCLKDIV_REQFLAG_MASK        (0x80000000U)
#define CLKCTL1_ACMP0FCLKDIV_REQFLAG_SHIFT       (31U)
/*! REQFLAG - Divider status flag. Set when a change is made to the divider value, cleared when the change is complete.
 */
#define CLKCTL1_ACMP0FCLKDIV_REQFLAG(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL1_ACMP0FCLKDIV_REQFLAG_SHIFT)) & CLKCTL1_ACMP0FCLKDIV_REQFLAG_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group CLKCTL1_Register_Masks */


/* CLKCTL1 - Peripheral instance base addresses */
/** Peripheral CLKCTL1 base address */
#define CLKCTL1_BASE                             (0x40021000u)
/** Peripheral CLKCTL1 base pointer */
#define CLKCTL1                                  ((CLKCTL1_Type *)CLKCTL1_BASE)
/** Array initializer of CLKCTL1 peripheral base addresses */
#define CLKCTL1_BASE_ADDRS                       { CLKCTL1_BASE }
/** Array initializer of CLKCTL1 peripheral base pointers */
#define CLKCTL1_BASE_PTRS                        { CLKCTL1 }

/*!
 * @}
 */ /* end of group CLKCTL1_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- CMP Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CMP_Peripheral_Access_Layer CMP Peripheral Access Layer
 * @{
 */

/** CMP - Register Layout Typedef */
typedef struct {
  __I  uint32_t VERID;                             /**< Version ID Register, offset: 0x0 */
  __I  uint32_t PARAM;                             /**< Parameter Register, offset: 0x4 */
  __IO uint32_t C0;                                /**< CMP Control Register 0, offset: 0x8 */
  __IO uint32_t C1;                                /**< CMP Control Register 1, offset: 0xC */
  __IO uint32_t C2;                                /**< CMP Control Register 2, offset: 0x10 */
  __IO uint32_t C3;                                /**< CMP Control Register 3, offset: 0x14 */
  __IO uint32_t RR_TIMER_CR;                       /**< Round-Robin Timer Control Register, offset: 0x18 */
} CMP_Type;

/* ----------------------------------------------------------------------------
   -- CMP Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CMP_Register_Masks CMP Register Masks
 * @{
 */

/*! @name VERID - Version ID Register */
/*! @{ */

#define CMP_VERID_FEATURE_MASK                   (0xFFFFU)
#define CMP_VERID_FEATURE_SHIFT                  (0U)
/*! FEATURE - Feature Specification Number. This read only filed returns the feature set number.
 */
#define CMP_VERID_FEATURE(x)                     (((uint32_t)(((uint32_t)(x)) << CMP_VERID_FEATURE_SHIFT)) & CMP_VERID_FEATURE_MASK)

#define CMP_VERID_MINOR_MASK                     (0xFF0000U)
#define CMP_VERID_MINOR_SHIFT                    (16U)
/*! MINOR - Minor Version Number. This read only field returns the minor version number for the module specification.
 */
#define CMP_VERID_MINOR(x)                       (((uint32_t)(((uint32_t)(x)) << CMP_VERID_MINOR_SHIFT)) & CMP_VERID_MINOR_MASK)

#define CMP_VERID_MAJOR_MASK                     (0xFF000000U)
#define CMP_VERID_MAJOR_SHIFT                    (24U)
/*! MAJOR - Major Version Number. This read only field returns the major version number for the module specification.
 */
#define CMP_VERID_MAJOR(x)                       (((uint32_t)(((uint32_t)(x)) << CMP_VERID_MAJOR_SHIFT)) & CMP_VERID_MAJOR_MASK)
/*! @} */

/*! @name PARAM - Parameter Register */
/*! @{ */

#define CMP_PARAM_PARAM_MASK                     (0xFFFFFFFFU)
#define CMP_PARAM_PARAM_SHIFT                    (0U)
/*! PARAM - Parameter Registers. This read only filed returns the feature parameters implemented along with the Version ID register.
 */
#define CMP_PARAM_PARAM(x)                       (((uint32_t)(((uint32_t)(x)) << CMP_PARAM_PARAM_SHIFT)) & CMP_PARAM_PARAM_MASK)
/*! @} */

/*! @name C0 - CMP Control Register 0 */
/*! @{ */

#define CMP_C0_HYSTCTR_MASK                      (0x3U)
#define CMP_C0_HYSTCTR_SHIFT                     (0U)
/*! HYSTCTR - Comparator hard block hysteresis control. See chip data sheet to get the actual hystersis value with each level
 *  0b00..The hard block output has level 0 hysteresis internally.
 *  0b01..The hard block output has level 1 hysteresis internally.
 *  0b10..The hard block output has level 2 hysteresis internally.
 *  0b11..The hard block output has level 3 hysteresis internally.
 */
#define CMP_C0_HYSTCTR(x)                        (((uint32_t)(((uint32_t)(x)) << CMP_C0_HYSTCTR_SHIFT)) & CMP_C0_HYSTCTR_MASK)

#define CMP_C0_FILTER_CNT_MASK                   (0x70U)
#define CMP_C0_FILTER_CNT_SHIFT                  (4U)
/*! FILTER_CNT - Filter Sample Count
 *  0b000..Filter is disabled. If SE = 1, then COUT is a logic zero (this is not a legal state, and is not recommended). If SE = 0, COUT = COUTA.
 *  0b001..1 consecutive sample must agree (comparator output is simply sampled).
 *  0b010..2 consecutive samples must agree.
 *  0b011..3 consecutive samples must agree.
 *  0b100..4 consecutive samples must agree.
 *  0b101..5 consecutive samples must agree.
 *  0b110..6 consecutive samples must agree.
 *  0b111..7 consecutive samples must agree.
 */
#define CMP_C0_FILTER_CNT(x)                     (((uint32_t)(((uint32_t)(x)) << CMP_C0_FILTER_CNT_SHIFT)) & CMP_C0_FILTER_CNT_MASK)

#define CMP_C0_EN_MASK                           (0x100U)
#define CMP_C0_EN_SHIFT                          (8U)
/*! EN - Comparator Module Enable
 *  0b0..Analog Comparator is disabled.
 *  0b1..Analog Comparator is enabled.
 */
#define CMP_C0_EN(x)                             (((uint32_t)(((uint32_t)(x)) << CMP_C0_EN_SHIFT)) & CMP_C0_EN_MASK)

#define CMP_C0_OPE_MASK                          (0x200U)
#define CMP_C0_OPE_SHIFT                         (9U)
/*! OPE - Comparator Output Pin Enable
 *  0b0..When OPE is 0, the comparator output (after window/filter settings dependent on software configuration) is not available to a packaged pin.
 *  0b1..When OPE is 1, and if the software has configured the comparator to own a packaged pin, the comparator is available in a packaged pin.
 */
#define CMP_C0_OPE(x)                            (((uint32_t)(((uint32_t)(x)) << CMP_C0_OPE_SHIFT)) & CMP_C0_OPE_MASK)

#define CMP_C0_COS_MASK                          (0x400U)
#define CMP_C0_COS_SHIFT                         (10U)
/*! COS - Comparator Output Select
 *  0b0..Set CMPO to equal COUT (filtered comparator output).
 *  0b1..Set CMPO to equal COUTA (unfiltered comparator output).
 */
#define CMP_C0_COS(x)                            (((uint32_t)(((uint32_t)(x)) << CMP_C0_COS_SHIFT)) & CMP_C0_COS_MASK)

#define CMP_C0_INVT_MASK                         (0x800U)
#define CMP_C0_INVT_SHIFT                        (11U)
/*! INVT - Comparator invert
 *  0b0..Does not invert the comparator output.
 *  0b1..Inverts the comparator output.
 */
#define CMP_C0_INVT(x)                           (((uint32_t)(((uint32_t)(x)) << CMP_C0_INVT_SHIFT)) & CMP_C0_INVT_MASK)

#define CMP_C0_PMODE_MASK                        (0x1000U)
#define CMP_C0_PMODE_SHIFT                       (12U)
/*! PMODE - Power Mode Select
 *  0b0..Low Speed (LS) comparison mode is selected.
 *  0b1..High Speed (HS) comparison mode is selected.
 */
#define CMP_C0_PMODE(x)                          (((uint32_t)(((uint32_t)(x)) << CMP_C0_PMODE_SHIFT)) & CMP_C0_PMODE_MASK)

#define CMP_C0_WE_MASK                           (0x4000U)
#define CMP_C0_WE_SHIFT                          (14U)
/*! WE - Windowing Enable
 *  0b0..Windowing mode is not selected.
 *  0b1..Windowing mode is selected.
 */
#define CMP_C0_WE(x)                             (((uint32_t)(((uint32_t)(x)) << CMP_C0_WE_SHIFT)) & CMP_C0_WE_MASK)

#define CMP_C0_SE_MASK                           (0x8000U)
#define CMP_C0_SE_SHIFT                          (15U)
/*! SE - Sample Enable
 *  0b0..Sampling mode is not selected.
 *  0b1..Sampling mode is selected.
 */
#define CMP_C0_SE(x)                             (((uint32_t)(((uint32_t)(x)) << CMP_C0_SE_SHIFT)) & CMP_C0_SE_MASK)

#define CMP_C0_FPR_MASK                          (0xFF0000U)
#define CMP_C0_FPR_SHIFT                         (16U)
/*! FPR - Filter Sample Period
 */
#define CMP_C0_FPR(x)                            (((uint32_t)(((uint32_t)(x)) << CMP_C0_FPR_SHIFT)) & CMP_C0_FPR_MASK)

#define CMP_C0_COUT_MASK                         (0x1000000U)
#define CMP_C0_COUT_SHIFT                        (24U)
/*! COUT - Analog Comparator Output
 */
#define CMP_C0_COUT(x)                           (((uint32_t)(((uint32_t)(x)) << CMP_C0_COUT_SHIFT)) & CMP_C0_COUT_MASK)

#define CMP_C0_CFF_MASK                          (0x2000000U)
#define CMP_C0_CFF_SHIFT                         (25U)
/*! CFF - Analog Comparator Flag Falling
 *  0b0..A falling edge has not been detected on COUT.
 *  0b1..A falling edge on COUT has occurred.
 */
#define CMP_C0_CFF(x)                            (((uint32_t)(((uint32_t)(x)) << CMP_C0_CFF_SHIFT)) & CMP_C0_CFF_MASK)

#define CMP_C0_CFR_MASK                          (0x4000000U)
#define CMP_C0_CFR_SHIFT                         (26U)
/*! CFR - Analog Comparator Flag Rising
 *  0b0..A rising edge has not been detected on COUT.
 *  0b1..A rising edge on COUT has occurred.
 */
#define CMP_C0_CFR(x)                            (((uint32_t)(((uint32_t)(x)) << CMP_C0_CFR_SHIFT)) & CMP_C0_CFR_MASK)

#define CMP_C0_IEF_MASK                          (0x8000000U)
#define CMP_C0_IEF_SHIFT                         (27U)
/*! IEF - Comparator Interrupt Enable Falling
 *  0b0..Interrupt is disabled.
 *  0b1..Interrupt is enabled.
 */
#define CMP_C0_IEF(x)                            (((uint32_t)(((uint32_t)(x)) << CMP_C0_IEF_SHIFT)) & CMP_C0_IEF_MASK)

#define CMP_C0_IER_MASK                          (0x10000000U)
#define CMP_C0_IER_SHIFT                         (28U)
/*! IER - Comparator Interrupt Enable Rising
 *  0b0..Interrupt is disabled.
 *  0b1..Interrupt is enabled.
 */
#define CMP_C0_IER(x)                            (((uint32_t)(((uint32_t)(x)) << CMP_C0_IER_SHIFT)) & CMP_C0_IER_MASK)

#define CMP_C0_DMAEN_MASK                        (0x40000000U)
#define CMP_C0_DMAEN_SHIFT                       (30U)
/*! DMAEN - DMA Enable
 *  0b0..DMA is disabled.
 *  0b1..DMA is enabled.
 */
#define CMP_C0_DMAEN(x)                          (((uint32_t)(((uint32_t)(x)) << CMP_C0_DMAEN_SHIFT)) & CMP_C0_DMAEN_MASK)

#define CMP_C0_LINKEN_MASK                       (0x80000000U)
#define CMP_C0_LINKEN_SHIFT                      (31U)
/*! LINKEN - CMP to DAC link enable.
 *  0b0..CMP to DAC link is disabled
 *  0b1..CMP to DAC link is enabled.
 */
#define CMP_C0_LINKEN(x)                         (((uint32_t)(((uint32_t)(x)) << CMP_C0_LINKEN_SHIFT)) & CMP_C0_LINKEN_MASK)
/*! @} */

/*! @name C1 - CMP Control Register 1 */
/*! @{ */

#define CMP_C1_VOSEL_MASK                        (0xFFU)
#define CMP_C1_VOSEL_SHIFT                       (0U)
/*! VOSEL - DAC Output Voltage Select
 */
#define CMP_C1_VOSEL(x)                          (((uint32_t)(((uint32_t)(x)) << CMP_C1_VOSEL_SHIFT)) & CMP_C1_VOSEL_MASK)

#define CMP_C1_DMODE_MASK                        (0x100U)
#define CMP_C1_DMODE_SHIFT                       (8U)
/*! DMODE - DAC Mode Selection
 *  0b0..DAC is selected to work in low speed and low power mode.
 *  0b1..DAC is selected to work in high speed high power mode.
 */
#define CMP_C1_DMODE(x)                          (((uint32_t)(((uint32_t)(x)) << CMP_C1_DMODE_SHIFT)) & CMP_C1_DMODE_MASK)

#define CMP_C1_VRSEL_MASK                        (0x200U)
#define CMP_C1_VRSEL_SHIFT                       (9U)
/*! VRSEL - Supply Voltage Reference Source Select
 *  0b0..Vin1 is selected as resistor ladder network supply reference Vin. Vin1 is from internal PMC.
 *  0b1..Vin2 is selected as resistor ladder network supply reference Vin. Vin2 is from PAD.
 */
#define CMP_C1_VRSEL(x)                          (((uint32_t)(((uint32_t)(x)) << CMP_C1_VRSEL_SHIFT)) & CMP_C1_VRSEL_MASK)

#define CMP_C1_DACEN_MASK                        (0x400U)
#define CMP_C1_DACEN_SHIFT                       (10U)
/*! DACEN - DAC Enable
 *  0b0..DAC is disabled.
 *  0b1..DAC is enabled.
 */
#define CMP_C1_DACEN(x)                          (((uint32_t)(((uint32_t)(x)) << CMP_C1_DACEN_SHIFT)) & CMP_C1_DACEN_MASK)

#define CMP_C1_CHN0_MASK                         (0x10000U)
#define CMP_C1_CHN0_SHIFT                        (16U)
/*! CHN0 - Channel 0 input enable
 */
#define CMP_C1_CHN0(x)                           (((uint32_t)(((uint32_t)(x)) << CMP_C1_CHN0_SHIFT)) & CMP_C1_CHN0_MASK)

#define CMP_C1_CHN1_MASK                         (0x20000U)
#define CMP_C1_CHN1_SHIFT                        (17U)
/*! CHN1 - Channel 1 input enable
 */
#define CMP_C1_CHN1(x)                           (((uint32_t)(((uint32_t)(x)) << CMP_C1_CHN1_SHIFT)) & CMP_C1_CHN1_MASK)

#define CMP_C1_CHN2_MASK                         (0x40000U)
#define CMP_C1_CHN2_SHIFT                        (18U)
/*! CHN2 - Channel 2 input enable
 */
#define CMP_C1_CHN2(x)                           (((uint32_t)(((uint32_t)(x)) << CMP_C1_CHN2_SHIFT)) & CMP_C1_CHN2_MASK)

#define CMP_C1_CHN3_MASK                         (0x80000U)
#define CMP_C1_CHN3_SHIFT                        (19U)
/*! CHN3 - Channel 3 input enable
 */
#define CMP_C1_CHN3(x)                           (((uint32_t)(((uint32_t)(x)) << CMP_C1_CHN3_SHIFT)) & CMP_C1_CHN3_MASK)

#define CMP_C1_CHN4_MASK                         (0x100000U)
#define CMP_C1_CHN4_SHIFT                        (20U)
/*! CHN4 - Channel 4 input enable
 */
#define CMP_C1_CHN4(x)                           (((uint32_t)(((uint32_t)(x)) << CMP_C1_CHN4_SHIFT)) & CMP_C1_CHN4_MASK)

#define CMP_C1_CHN5_MASK                         (0x200000U)
#define CMP_C1_CHN5_SHIFT                        (21U)
/*! CHN5 - Channel 5 input enable
 */
#define CMP_C1_CHN5(x)                           (((uint32_t)(((uint32_t)(x)) << CMP_C1_CHN5_SHIFT)) & CMP_C1_CHN5_MASK)

#define CMP_C1_MSEL_MASK                         (0x7000000U)
#define CMP_C1_MSEL_SHIFT                        (24U)
/*! MSEL - Minus Input MUX Control
 *  0b000..Internal Negative Input 0 for Minus Channel -- Internal Minus Input
 *  0b001..External Input 1 for Minus Channel -- Reference Input 0
 *  0b010..External Input 2 for Minus Channel -- Reference Input 1
 *  0b011..External Input 3 for Minus Channel -- Reference Input 2
 *  0b100..External Input 4 for Minus Channel -- Reference Input 3
 *  0b101..External Input 5 for Minus Channel -- Reference Input 4
 *  0b110..External Input 6 for Minus Channel -- Reference Input 5
 *  0b111..Internal 8b DAC output
 */
#define CMP_C1_MSEL(x)                           (((uint32_t)(((uint32_t)(x)) << CMP_C1_MSEL_SHIFT)) & CMP_C1_MSEL_MASK)

#define CMP_C1_PSEL_MASK                         (0x70000000U)
#define CMP_C1_PSEL_SHIFT                        (28U)
/*! PSEL - Plus Input MUX Control
 *  0b000..Internal Posivite Input 0 for Plus Channel -- Internal Minus Input
 *  0b001..External Input 1 for Plus Channel -- Reference Input 0
 *  0b010..External Input 2 for Plus Channel -- Reference Input 1
 *  0b011..External Input 3 for Plus Channel -- Reference Input 2
 *  0b100..External Input 4 for Plus Channel -- Reference Input 3
 *  0b101..External Input 4 for Plus Channel -- Reference Input 4
 *  0b110..External Input 4 for Plus Channel -- Reference Input 5
 *  0b111..Internal 8b DAC output
 */
#define CMP_C1_PSEL(x)                           (((uint32_t)(((uint32_t)(x)) << CMP_C1_PSEL_SHIFT)) & CMP_C1_PSEL_MASK)
/*! @} */

/*! @name C2 - CMP Control Register 2 */
/*! @{ */

#define CMP_C2_ACOn_MASK                         (0x3FU)
#define CMP_C2_ACOn_SHIFT                        (0U)
/*! ACOn - ACOn
 */
#define CMP_C2_ACOn(x)                           (((uint32_t)(((uint32_t)(x)) << CMP_C2_ACOn_SHIFT)) & CMP_C2_ACOn_MASK)

#define CMP_C2_INITMOD_MASK                      (0x3F00U)
#define CMP_C2_INITMOD_SHIFT                     (8U)
/*! INITMOD - Comparator and DAC initialization delay modulus.
 */
#define CMP_C2_INITMOD(x)                        (((uint32_t)(((uint32_t)(x)) << CMP_C2_INITMOD_SHIFT)) & CMP_C2_INITMOD_MASK)

#define CMP_C2_NSAM_MASK                         (0xC000U)
#define CMP_C2_NSAM_SHIFT                        (14U)
/*! NSAM - Number of sample clocks
 *  0b00..The comparison result is sampled as soon as the active channel is scanned in one round-robin clock.
 *  0b01..The sampling takes place 1 round-robin clock cycle after the next cycle of the round-robin clock.
 *  0b10..The sampling takes place 2 round-robin clock cycles after the next cycle of the round-robin clock.
 *  0b11..The sampling takes place 3 round-robin clock cycles after the next cycle of the round-robin clock.
 */
#define CMP_C2_NSAM(x)                           (((uint32_t)(((uint32_t)(x)) << CMP_C2_NSAM_SHIFT)) & CMP_C2_NSAM_MASK)

#define CMP_C2_CH0F_MASK                         (0x10000U)
#define CMP_C2_CH0F_SHIFT                        (16U)
/*! CH0F - CH0F
 */
#define CMP_C2_CH0F(x)                           (((uint32_t)(((uint32_t)(x)) << CMP_C2_CH0F_SHIFT)) & CMP_C2_CH0F_MASK)

#define CMP_C2_CH1F_MASK                         (0x20000U)
#define CMP_C2_CH1F_SHIFT                        (17U)
/*! CH1F - CH1F
 */
#define CMP_C2_CH1F(x)                           (((uint32_t)(((uint32_t)(x)) << CMP_C2_CH1F_SHIFT)) & CMP_C2_CH1F_MASK)

#define CMP_C2_CH2F_MASK                         (0x40000U)
#define CMP_C2_CH2F_SHIFT                        (18U)
/*! CH2F - CH2F
 */
#define CMP_C2_CH2F(x)                           (((uint32_t)(((uint32_t)(x)) << CMP_C2_CH2F_SHIFT)) & CMP_C2_CH2F_MASK)

#define CMP_C2_CH3F_MASK                         (0x80000U)
#define CMP_C2_CH3F_SHIFT                        (19U)
/*! CH3F - CH3F
 */
#define CMP_C2_CH3F(x)                           (((uint32_t)(((uint32_t)(x)) << CMP_C2_CH3F_SHIFT)) & CMP_C2_CH3F_MASK)

#define CMP_C2_CH4F_MASK                         (0x100000U)
#define CMP_C2_CH4F_SHIFT                        (20U)
/*! CH4F - CH4F
 */
#define CMP_C2_CH4F(x)                           (((uint32_t)(((uint32_t)(x)) << CMP_C2_CH4F_SHIFT)) & CMP_C2_CH4F_MASK)

#define CMP_C2_CH5F_MASK                         (0x200000U)
#define CMP_C2_CH5F_SHIFT                        (21U)
/*! CH5F - CH5F
 */
#define CMP_C2_CH5F(x)                           (((uint32_t)(((uint32_t)(x)) << CMP_C2_CH5F_SHIFT)) & CMP_C2_CH5F_MASK)

#define CMP_C2_FXMXCH_MASK                       (0xE000000U)
#define CMP_C2_FXMXCH_SHIFT                      (25U)
/*! FXMXCH - Fixed channel selection
 *  0b000..External Reference Input 0 is selected as the fixed reference input for the fixed mux port.
 *  0b001..External Reference Input 1 is selected as the fixed reference input for the fixed mux port.
 *  0b010..External Reference Input 2 is selected as the fixed reference input for the fixed mux port.
 *  0b011..External Reference Input 3 is selected as the fixed reference input for the fixed mux port.
 *  0b100..External Reference Input 4 is selected as the fixed reference input for the fixed mux port.
 *  0b101..External Reference Input 5 is selected as the fixed reference input for the fixed mux port.
 *  0b110..Reserved.
 *  0b111..The 8bit DAC is selected as the fixed reference input for the fixed mux port.
 */
#define CMP_C2_FXMXCH(x)                         (((uint32_t)(((uint32_t)(x)) << CMP_C2_FXMXCH_SHIFT)) & CMP_C2_FXMXCH_MASK)

#define CMP_C2_FXMP_MASK                         (0x20000000U)
#define CMP_C2_FXMP_SHIFT                        (29U)
/*! FXMP - Fixed MUX Port
 *  0b0..The Plus port is fixed. Only the inputs to the Minus port are swept in each round.
 *  0b1..The Minus port is fixed. Only the inputs to the Plus port are swept in each round.
 */
#define CMP_C2_FXMP(x)                           (((uint32_t)(((uint32_t)(x)) << CMP_C2_FXMP_SHIFT)) & CMP_C2_FXMP_MASK)

#define CMP_C2_RRIE_MASK                         (0x40000000U)
#define CMP_C2_RRIE_SHIFT                        (30U)
/*! RRIE - Round-Robin interrupt enable
 *  0b0..The round-robin interrupt is disabled.
 *  0b1..The round-robin interrupt is enabled when a comparison result changes from the last sample.
 */
#define CMP_C2_RRIE(x)                           (((uint32_t)(((uint32_t)(x)) << CMP_C2_RRIE_SHIFT)) & CMP_C2_RRIE_MASK)
/*! @} */

/*! @name C3 - CMP Control Register 3 */
/*! @{ */

#define CMP_C3_ACPH2TC_MASK                      (0x70U)
#define CMP_C3_ACPH2TC_SHIFT                     (4U)
/*! ACPH2TC - Analog Comparator Phase2 Timing Control.
 *  0b000..Phase2 active time in one sampling period equals to T
 *  0b001..Phase2 active time in one sampling period equals to 2*T
 *  0b010..Phase2 active time in one sampling period equals to 4*T
 *  0b011..Phase2 active time in one sampling period equals to 8*T
 *  0b100..Phase2 active time in one sampling period equals to 16*T
 *  0b101..Phase2 active time in one sampling period equals to 32*T
 *  0b110..Phase2 active time in one sampling period equals to 64*T
 *  0b111..Phase2 active time in one sampling period equals to 16*T
 */
#define CMP_C3_ACPH2TC(x)                        (((uint32_t)(((uint32_t)(x)) << CMP_C3_ACPH2TC_SHIFT)) & CMP_C3_ACPH2TC_MASK)

#define CMP_C3_ACPH1TC_MASK                      (0x700U)
#define CMP_C3_ACPH1TC_SHIFT                     (8U)
/*! ACPH1TC - Analog Comparator Phase1 Timing Control.
 *  0b000..Phase1 active time in one sampling period equals to T
 *  0b001..Phase1 active time in one sampling period equals to 2*T
 *  0b010..Phase1 active time in one sampling period equals to 4*T
 *  0b011..Phase1 active time in one sampling period equals to 8*T
 *  0b100..Phase1 active time in one sampling period equals to T
 *  0b101..Phase1 active time in one sampling period equals to T
 *  0b110..Phase1 active time in one sampling period equals to T
 *  0b111..Phase1 active time in one sampling period equals to 0
 */
#define CMP_C3_ACPH1TC(x)                        (((uint32_t)(((uint32_t)(x)) << CMP_C3_ACPH1TC_SHIFT)) & CMP_C3_ACPH1TC_MASK)

#define CMP_C3_ACSAT_MASK                        (0x7000U)
#define CMP_C3_ACSAT_SHIFT                       (12U)
/*! ACSAT - Analog Comparator Sampling Time control.
 *  0b000..The sampling time equals to T
 *  0b001..The sampling time equasl to 2*T
 *  0b010..The sampling time equasl to 4*T
 *  0b011..The sampling time equasl to 8*T
 *  0b100..The sampling time equasl to 16*T
 *  0b101..The sampling time equasl to 32*T
 *  0b110..The sampling time equasl to 64*T
 *  0b111..The sampling time equasl to 256*T
 */
#define CMP_C3_ACSAT(x)                          (((uint32_t)(((uint32_t)(x)) << CMP_C3_ACSAT_SHIFT)) & CMP_C3_ACSAT_MASK)

#define CMP_C3_DMCS_MASK                         (0x10000U)
#define CMP_C3_DMCS_SHIFT                        (16U)
/*! DMCS - Discrete Mode Clock Selection
 *  0b0..Slow clock is selected for the timing generation.
 *  0b1..Fast clock is selected for the timing generation.
 */
#define CMP_C3_DMCS(x)                           (((uint32_t)(((uint32_t)(x)) << CMP_C3_DMCS_SHIFT)) & CMP_C3_DMCS_MASK)

#define CMP_C3_RDIVE_MASK                        (0x100000U)
#define CMP_C3_RDIVE_SHIFT                       (20U)
/*! RDIVE - Resistor Divider Enable
 *  0b0..The resistor is not enabled even when either NCHEN or PCHEN is set to1 but the actual input is in the range of 0 - 1.8v.
 *  0b1..The resistor is enabled because the inputs are above 1.8v.
 */
#define CMP_C3_RDIVE(x)                          (((uint32_t)(((uint32_t)(x)) << CMP_C3_RDIVE_SHIFT)) & CMP_C3_RDIVE_MASK)

#define CMP_C3_NCHCTEN_MASK                      (0x1000000U)
#define CMP_C3_NCHCTEN_SHIFT                     (24U)
/*! NCHCTEN - Negative Channel Continuous Mode Enable.
 *  0b0..Negative channel is in Discrete Mode and special timing needs to be configured.
 *  0b1..Negative channel is in Continuous Mode and no special timing is requried.
 */
#define CMP_C3_NCHCTEN(x)                        (((uint32_t)(((uint32_t)(x)) << CMP_C3_NCHCTEN_SHIFT)) & CMP_C3_NCHCTEN_MASK)

#define CMP_C3_PCHCTEN_MASK                      (0x10000000U)
#define CMP_C3_PCHCTEN_SHIFT                     (28U)
/*! PCHCTEN - Positive Channel Continuous Mode Enable.
 *  0b0..Positive channel is in Discrete Mode and special timing needs to be configured.
 *  0b1..Positive channel is in Continuous Mode and no special timing is requried.
 */
#define CMP_C3_PCHCTEN(x)                        (((uint32_t)(((uint32_t)(x)) << CMP_C3_PCHCTEN_SHIFT)) & CMP_C3_PCHCTEN_MASK)
/*! @} */

/*! @name RR_TIMER_CR - Round-Robin Timer Control Register */
/*! @{ */

#define CMP_RR_TIMER_CR_RR_TIMER_RELOAD_MASK     (0xFFFFFFFU)
#define CMP_RR_TIMER_CR_RR_TIMER_RELOAD_SHIFT    (0U)
/*! RR_TIMER_RELOAD - This field establishes the repetitive count rate for the timer. Each time the
 *    timer counts down to zero it is reloaded with this value. The rr_trig signal will be generated
 *    at a rate of (rr_timer_reload + 1) times the rr_clock period (typically 30.6 uS)
 */
#define CMP_RR_TIMER_CR_RR_TIMER_RELOAD(x)       (((uint32_t)(((uint32_t)(x)) << CMP_RR_TIMER_CR_RR_TIMER_RELOAD_SHIFT)) & CMP_RR_TIMER_CR_RR_TIMER_RELOAD_MASK)

#define CMP_RR_TIMER_CR_RR_TIMER_ENA_MASK        (0x80000000U)
#define CMP_RR_TIMER_CR_RR_TIMER_ENA_SHIFT       (31U)
/*! RR_TIMER_ENA - RR_TIMER enable. When low, rr_timer count will be held at zero. When set, timer
 *    will commence continuous, repetitive counting beginning with the 1st or 2nd rising edge of the
 *    32 KHz rr_clock.1
 */
#define CMP_RR_TIMER_CR_RR_TIMER_ENA(x)          (((uint32_t)(((uint32_t)(x)) << CMP_RR_TIMER_CR_RR_TIMER_ENA_SHIFT)) & CMP_RR_TIMER_CR_RR_TIMER_ENA_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group CMP_Register_Masks */


/* CMP - Peripheral instance base addresses */
/** Peripheral CMP base address */
#define CMP_BASE                                 (0x40139000u)
/** Peripheral CMP base pointer */
#define CMP                                      ((CMP_Type *)CMP_BASE)
/** Array initializer of CMP peripheral base addresses */
#define CMP_BASE_ADDRS                           { CMP_BASE }
/** Array initializer of CMP peripheral base pointers */
#define CMP_BASE_PTRS                            { CMP }

/*!
 * @}
 */ /* end of group CMP_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- CRC Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CRC_Peripheral_Access_Layer CRC Peripheral Access Layer
 * @{
 */

/** CRC - Register Layout Typedef */
typedef struct {
  __IO uint32_t MODE;                              /**< CRC mode register, offset: 0x0 */
  __IO uint32_t SEED;                              /**< CRC seed register, offset: 0x4 */
  union {                                          /* offset: 0x8 */
    __I  uint32_t SUM;                               /**< CRC checksum register, offset: 0x8 */
    __O  uint32_t WR_DATA;                           /**< CRC data register, offset: 0x8 */
  };
} CRC_Type;

/* ----------------------------------------------------------------------------
   -- CRC Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CRC_Register_Masks CRC Register Masks
 * @{
 */

/*! @name MODE - CRC mode register */
/*! @{ */

#define CRC_MODE_CRC_POLY_MASK                   (0x3U)
#define CRC_MODE_CRC_POLY_SHIFT                  (0U)
/*! CRC_POLY - CRC polynomial: 1X = CRC-32 polynomial 01 = CRC-16 polynomial 00 = CRC-CCITT polynomial
 */
#define CRC_MODE_CRC_POLY(x)                     (((uint32_t)(((uint32_t)(x)) << CRC_MODE_CRC_POLY_SHIFT)) & CRC_MODE_CRC_POLY_MASK)

#define CRC_MODE_BIT_RVS_WR_MASK                 (0x4U)
#define CRC_MODE_BIT_RVS_WR_SHIFT                (2U)
/*! BIT_RVS_WR - Data bit order: 1 = Bit order reverse for CRC_WR_DATA (per byte) 0 = No bit order reverse for CRC_WR_DATA (per byte)
 */
#define CRC_MODE_BIT_RVS_WR(x)                   (((uint32_t)(((uint32_t)(x)) << CRC_MODE_BIT_RVS_WR_SHIFT)) & CRC_MODE_BIT_RVS_WR_MASK)

#define CRC_MODE_CMPL_WR_MASK                    (0x8U)
#define CRC_MODE_CMPL_WR_SHIFT                   (3U)
/*! CMPL_WR - Data complement: 1 = 1's complement for CRC_WR_DATA 0 = No 1's complement for CRC_WR_DATA
 */
#define CRC_MODE_CMPL_WR(x)                      (((uint32_t)(((uint32_t)(x)) << CRC_MODE_CMPL_WR_SHIFT)) & CRC_MODE_CMPL_WR_MASK)

#define CRC_MODE_BIT_RVS_SUM_MASK                (0x10U)
#define CRC_MODE_BIT_RVS_SUM_SHIFT               (4U)
/*! BIT_RVS_SUM - CRC sum bit order: 1 = Bit order reverse for CRC_SUM 0 = No bit order reverse for CRC_SUM
 */
#define CRC_MODE_BIT_RVS_SUM(x)                  (((uint32_t)(((uint32_t)(x)) << CRC_MODE_BIT_RVS_SUM_SHIFT)) & CRC_MODE_BIT_RVS_SUM_MASK)

#define CRC_MODE_CMPL_SUM_MASK                   (0x20U)
#define CRC_MODE_CMPL_SUM_SHIFT                  (5U)
/*! CMPL_SUM - CRC sum complement: 1 = 1's complement for CRC_SUM 0 = No 1's complement for CRC_SUM
 */
#define CRC_MODE_CMPL_SUM(x)                     (((uint32_t)(((uint32_t)(x)) << CRC_MODE_CMPL_SUM_SHIFT)) & CRC_MODE_CMPL_SUM_MASK)
/*! @} */

/*! @name SEED - CRC seed register */
/*! @{ */

#define CRC_SEED_CRC_SEED_MASK                   (0xFFFFFFFFU)
#define CRC_SEED_CRC_SEED_SHIFT                  (0U)
/*! CRC_SEED - A write access to this register will load CRC seed value to CRC_SUM register with
 *    selected bit order and 1's complement pre-processes. A write access to this register will
 *    overrule the CRC calculation in progresses.
 */
#define CRC_SEED_CRC_SEED(x)                     (((uint32_t)(((uint32_t)(x)) << CRC_SEED_CRC_SEED_SHIFT)) & CRC_SEED_CRC_SEED_MASK)
/*! @} */

/*! @name SUM - CRC checksum register */
/*! @{ */

#define CRC_SUM_CRC_SUM_MASK                     (0xFFFFFFFFU)
#define CRC_SUM_CRC_SUM_SHIFT                    (0U)
/*! CRC_SUM - The most recent CRC sum can be read through this register with selected bit order and 1's complement post-processes.
 */
#define CRC_SUM_CRC_SUM(x)                       (((uint32_t)(((uint32_t)(x)) << CRC_SUM_CRC_SUM_SHIFT)) & CRC_SUM_CRC_SUM_MASK)
/*! @} */

/*! @name WR_DATA - CRC data register */
/*! @{ */

#define CRC_WR_DATA_CRC_WR_DATA_MASK             (0xFFFFFFFFU)
#define CRC_WR_DATA_CRC_WR_DATA_SHIFT            (0U)
/*! CRC_WR_DATA - Data written to this register will be taken to perform CRC calculation with
 *    selected bit order and 1's complement pre-process. Any write size 8, 16 or 32-bit are allowed and
 *    accept back-to-back transactions.
 */
#define CRC_WR_DATA_CRC_WR_DATA(x)               (((uint32_t)(((uint32_t)(x)) << CRC_WR_DATA_CRC_WR_DATA_SHIFT)) & CRC_WR_DATA_CRC_WR_DATA_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group CRC_Register_Masks */


/* CRC - Peripheral instance base addresses */
/** Peripheral CRC_ENGINE base address */
#define CRC_ENGINE_BASE                          (0x40120000u)
/** Peripheral CRC_ENGINE base pointer */
#define CRC_ENGINE                               ((CRC_Type *)CRC_ENGINE_BASE)
/** Array initializer of CRC peripheral base addresses */
#define CRC_BASE_ADDRS                           { CRC_ENGINE_BASE }
/** Array initializer of CRC peripheral base pointers */
#define CRC_BASE_PTRS                            { CRC_ENGINE }

/*!
 * @}
 */ /* end of group CRC_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- CTIMER Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CTIMER_Peripheral_Access_Layer CTIMER Peripheral Access Layer
 * @{
 */

/** CTIMER - Register Layout Typedef */
typedef struct {
  __IO uint32_t IR;                                /**< Interrupt Register. The IR can be written to clear interrupts. The IR can be read to identify which of eight possible interrupt sources are pending., offset: 0x0 */
  __IO uint32_t TCR;                               /**< Timer Control Register. The TCR is used to control the Timer Counter functions. The Timer Counter can be disabled or reset through the TCR., offset: 0x4 */
  __IO uint32_t TC;                                /**< Timer Counter. The 32 bit TC is incremented every PR+1 cycles of the APB bus clock. The TC is controlled through the TCR., offset: 0x8 */
  __IO uint32_t PR;                                /**< Prescale Register. When the Prescale Counter (PC) is equal to this value, the next clock increments the TC and clears the PC., offset: 0xC */
  __IO uint32_t PC;                                /**< Prescale Counter. The 32 bit PC is a counter which is incremented to the value stored in PR. When the value in PR is reached, the TC is incremented and the PC is cleared. The PC is observable and controllable through the bus interface., offset: 0x10 */
  __IO uint32_t MCR;                               /**< Match Control Register. The MCR is used to control if an interrupt is generated and if the TC is reset when a Match occurs., offset: 0x14 */
  __IO uint32_t MR[4];                             /**< Match Register . MR can be enabled through the MCR to reset the TC, stop both the TC and PC, and/or generate an interrupt every time MR matches the TC., array offset: 0x18, array step: 0x4 */
  __IO uint32_t CCR;                               /**< Capture Control Register. The CCR controls which edges of the capture inputs are used to load the Capture Registers and whether or not an interrupt is generated when a capture takes place., offset: 0x28 */
  __I  uint32_t CR[4];                             /**< Capture Register . CR is loaded with the value of TC when there is an event on the CAPn. input., array offset: 0x2C, array step: 0x4 */
  __IO uint32_t EMR;                               /**< External Match Register. The EMR controls the match function and the external match pins., offset: 0x3C */
       uint8_t RESERVED_0[48];
  __IO uint32_t CTCR;                              /**< Count Control Register. The CTCR selects between Timer and Counter mode, and in Counter mode selects the signal and edge(s) for counting., offset: 0x70 */
  __IO uint32_t PWMC;                              /**< PWM Control Register. The PWMCON enables PWM mode for the external match pins., offset: 0x74 */
  __IO uint32_t MSR[4];                            /**< Match Shadow Register . If enabled, the Match Register will be automatically reloaded with the contents of this register whenever the TC is reset to zero., array offset: 0x78, array step: 0x4 */
} CTIMER_Type;

/* ----------------------------------------------------------------------------
   -- CTIMER Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CTIMER_Register_Masks CTIMER Register Masks
 * @{
 */

/*! @name IR - Interrupt Register. The IR can be written to clear interrupts. The IR can be read to identify which of eight possible interrupt sources are pending. */
/*! @{ */

#define CTIMER_IR_MR0INT_MASK                    (0x1U)
#define CTIMER_IR_MR0INT_SHIFT                   (0U)
/*! MR0INT - Interrupt flag for match channel 0.
 */
#define CTIMER_IR_MR0INT(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_IR_MR0INT_SHIFT)) & CTIMER_IR_MR0INT_MASK)

#define CTIMER_IR_MR1INT_MASK                    (0x2U)
#define CTIMER_IR_MR1INT_SHIFT                   (1U)
/*! MR1INT - Interrupt flag for match channel 1.
 */
#define CTIMER_IR_MR1INT(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_IR_MR1INT_SHIFT)) & CTIMER_IR_MR1INT_MASK)

#define CTIMER_IR_MR2INT_MASK                    (0x4U)
#define CTIMER_IR_MR2INT_SHIFT                   (2U)
/*! MR2INT - Interrupt flag for match channel 2.
 */
#define CTIMER_IR_MR2INT(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_IR_MR2INT_SHIFT)) & CTIMER_IR_MR2INT_MASK)

#define CTIMER_IR_MR3INT_MASK                    (0x8U)
#define CTIMER_IR_MR3INT_SHIFT                   (3U)
/*! MR3INT - Interrupt flag for match channel 3.
 */
#define CTIMER_IR_MR3INT(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_IR_MR3INT_SHIFT)) & CTIMER_IR_MR3INT_MASK)

#define CTIMER_IR_CR0INT_MASK                    (0x10U)
#define CTIMER_IR_CR0INT_SHIFT                   (4U)
/*! CR0INT - Interrupt flag for capture channel 0 event.
 */
#define CTIMER_IR_CR0INT(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_IR_CR0INT_SHIFT)) & CTIMER_IR_CR0INT_MASK)

#define CTIMER_IR_CR1INT_MASK                    (0x20U)
#define CTIMER_IR_CR1INT_SHIFT                   (5U)
/*! CR1INT - Interrupt flag for capture channel 1 event.
 */
#define CTIMER_IR_CR1INT(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_IR_CR1INT_SHIFT)) & CTIMER_IR_CR1INT_MASK)

#define CTIMER_IR_CR2INT_MASK                    (0x40U)
#define CTIMER_IR_CR2INT_SHIFT                   (6U)
/*! CR2INT - Interrupt flag for capture channel 2 event.
 */
#define CTIMER_IR_CR2INT(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_IR_CR2INT_SHIFT)) & CTIMER_IR_CR2INT_MASK)

#define CTIMER_IR_CR3INT_MASK                    (0x80U)
#define CTIMER_IR_CR3INT_SHIFT                   (7U)
/*! CR3INT - Interrupt flag for capture channel 3 event.
 */
#define CTIMER_IR_CR3INT(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_IR_CR3INT_SHIFT)) & CTIMER_IR_CR3INT_MASK)
/*! @} */

/*! @name TCR - Timer Control Register. The TCR is used to control the Timer Counter functions. The Timer Counter can be disabled or reset through the TCR. */
/*! @{ */

#define CTIMER_TCR_CEN_MASK                      (0x1U)
#define CTIMER_TCR_CEN_SHIFT                     (0U)
/*! CEN - Counter enable.
 *  0b0..Disabled.The counters are disabled.
 *  0b1..Enabled. The Timer Counter and Prescale Counter are enabled.
 */
#define CTIMER_TCR_CEN(x)                        (((uint32_t)(((uint32_t)(x)) << CTIMER_TCR_CEN_SHIFT)) & CTIMER_TCR_CEN_MASK)

#define CTIMER_TCR_CRST_MASK                     (0x2U)
#define CTIMER_TCR_CRST_SHIFT                    (1U)
/*! CRST - Counter reset.
 *  0b0..Disabled. Do nothing.
 *  0b1..Enabled. The Timer Counter and the Prescale Counter are synchronously reset on the next positive edge of
 *       the APB bus clock. The counters remain reset until TCR[1] is returned to zero.
 */
#define CTIMER_TCR_CRST(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_TCR_CRST_SHIFT)) & CTIMER_TCR_CRST_MASK)
/*! @} */

/*! @name TC - Timer Counter. The 32 bit TC is incremented every PR+1 cycles of the APB bus clock. The TC is controlled through the TCR. */
/*! @{ */

#define CTIMER_TC_TCVAL_MASK                     (0xFFFFFFFFU)
#define CTIMER_TC_TCVAL_SHIFT                    (0U)
/*! TCVAL - Timer counter value.
 */
#define CTIMER_TC_TCVAL(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_TC_TCVAL_SHIFT)) & CTIMER_TC_TCVAL_MASK)
/*! @} */

/*! @name PR - Prescale Register. When the Prescale Counter (PC) is equal to this value, the next clock increments the TC and clears the PC. */
/*! @{ */

#define CTIMER_PR_PRVAL_MASK                     (0xFFFFFFFFU)
#define CTIMER_PR_PRVAL_SHIFT                    (0U)
/*! PRVAL - Prescale counter value.
 */
#define CTIMER_PR_PRVAL(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_PR_PRVAL_SHIFT)) & CTIMER_PR_PRVAL_MASK)
/*! @} */

/*! @name PC - Prescale Counter. The 32 bit PC is a counter which is incremented to the value stored in PR. When the value in PR is reached, the TC is incremented and the PC is cleared. The PC is observable and controllable through the bus interface. */
/*! @{ */

#define CTIMER_PC_PCVAL_MASK                     (0xFFFFFFFFU)
#define CTIMER_PC_PCVAL_SHIFT                    (0U)
/*! PCVAL - Prescale counter value.
 */
#define CTIMER_PC_PCVAL(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_PC_PCVAL_SHIFT)) & CTIMER_PC_PCVAL_MASK)
/*! @} */

/*! @name MCR - Match Control Register. The MCR is used to control if an interrupt is generated and if the TC is reset when a Match occurs. */
/*! @{ */

#define CTIMER_MCR_MR0I_MASK                     (0x1U)
#define CTIMER_MCR_MR0I_SHIFT                    (0U)
/*! MR0I - Interrupt on MR0: an interrupt is generated when MR0 matches the value in the TC. 0 = disabled. 1 = enabled.
 */
#define CTIMER_MCR_MR0I(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR0I_SHIFT)) & CTIMER_MCR_MR0I_MASK)

#define CTIMER_MCR_MR0R_MASK                     (0x2U)
#define CTIMER_MCR_MR0R_SHIFT                    (1U)
/*! MR0R - Reset on MR0: the TC will be reset if MR0 matches it. 0 = disabled. 1 = enabled.
 */
#define CTIMER_MCR_MR0R(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR0R_SHIFT)) & CTIMER_MCR_MR0R_MASK)

#define CTIMER_MCR_MR0S_MASK                     (0x4U)
#define CTIMER_MCR_MR0S_SHIFT                    (2U)
/*! MR0S - Stop on MR0: the TC and PC will be stopped and TCR[0] will be set to 0 if MR0 matches the TC. 0 = disabled. 1 = enabled.
 */
#define CTIMER_MCR_MR0S(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR0S_SHIFT)) & CTIMER_MCR_MR0S_MASK)

#define CTIMER_MCR_MR1I_MASK                     (0x8U)
#define CTIMER_MCR_MR1I_SHIFT                    (3U)
/*! MR1I - Interrupt on MR1: an interrupt is generated when MR1 matches the value in the TC. 0 =
 *    disabled. 1 = enabled. 0 = disabled. 1 = enabled.
 */
#define CTIMER_MCR_MR1I(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR1I_SHIFT)) & CTIMER_MCR_MR1I_MASK)

#define CTIMER_MCR_MR1R_MASK                     (0x10U)
#define CTIMER_MCR_MR1R_SHIFT                    (4U)
/*! MR1R - Reset on MR1: the TC will be reset if MR1 matches it. 0 = disabled. 1 = enabled.
 */
#define CTIMER_MCR_MR1R(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR1R_SHIFT)) & CTIMER_MCR_MR1R_MASK)

#define CTIMER_MCR_MR1S_MASK                     (0x20U)
#define CTIMER_MCR_MR1S_SHIFT                    (5U)
/*! MR1S - Stop on MR1: the TC and PC will be stopped and TCR[0] will be set to 0 if MR1 matches the TC. 0 = disabled. 1 = enabled.
 */
#define CTIMER_MCR_MR1S(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR1S_SHIFT)) & CTIMER_MCR_MR1S_MASK)

#define CTIMER_MCR_MR2I_MASK                     (0x40U)
#define CTIMER_MCR_MR2I_SHIFT                    (6U)
/*! MR2I - Interrupt on MR2: an interrupt is generated when MR2 matches the value in the TC. 0 = disabled. 1 = enabled.
 */
#define CTIMER_MCR_MR2I(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR2I_SHIFT)) & CTIMER_MCR_MR2I_MASK)

#define CTIMER_MCR_MR2R_MASK                     (0x80U)
#define CTIMER_MCR_MR2R_SHIFT                    (7U)
/*! MR2R - Reset on MR2: the TC will be reset if MR2 matches it. 0 = disabled. 1 = enabled.
 */
#define CTIMER_MCR_MR2R(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR2R_SHIFT)) & CTIMER_MCR_MR2R_MASK)

#define CTIMER_MCR_MR2S_MASK                     (0x100U)
#define CTIMER_MCR_MR2S_SHIFT                    (8U)
/*! MR2S - Stop on MR2: the TC and PC will be stopped and TCR[0] will be set to 0 if MR2 matches the TC. 0 = disabled. 1 = enabled.
 */
#define CTIMER_MCR_MR2S(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR2S_SHIFT)) & CTIMER_MCR_MR2S_MASK)

#define CTIMER_MCR_MR3I_MASK                     (0x200U)
#define CTIMER_MCR_MR3I_SHIFT                    (9U)
/*! MR3I - Interrupt on MR3: an interrupt is generated when MR3 matches the value in the TC. 0 = disabled. 1 = enabled.
 */
#define CTIMER_MCR_MR3I(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR3I_SHIFT)) & CTIMER_MCR_MR3I_MASK)

#define CTIMER_MCR_MR3R_MASK                     (0x400U)
#define CTIMER_MCR_MR3R_SHIFT                    (10U)
/*! MR3R - Reset on MR3: the TC will be reset if MR3 matches it. 0 = disabled. 1 = enabled.
 */
#define CTIMER_MCR_MR3R(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR3R_SHIFT)) & CTIMER_MCR_MR3R_MASK)

#define CTIMER_MCR_MR3S_MASK                     (0x800U)
#define CTIMER_MCR_MR3S_SHIFT                    (11U)
/*! MR3S - Stop on MR3: the TC and PC will be stopped and TCR[0] will be set to 0 if MR3 matches the TC. 0 = disabled. 1 = enabled.
 */
#define CTIMER_MCR_MR3S(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR3S_SHIFT)) & CTIMER_MCR_MR3S_MASK)

#define CTIMER_MCR_MR0RL_MASK                    (0x1000000U)
#define CTIMER_MCR_MR0RL_SHIFT                   (24U)
/*! MR0RL - Reload MR0 with the contents of the Match 0 Shadow Register when the TC is reset to zero
 *    (either via a match event or a write to bit 1 of the TCR). 0 = disabled. 1 = enabled.
 */
#define CTIMER_MCR_MR0RL(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR0RL_SHIFT)) & CTIMER_MCR_MR0RL_MASK)

#define CTIMER_MCR_MR1RL_MASK                    (0x2000000U)
#define CTIMER_MCR_MR1RL_SHIFT                   (25U)
/*! MR1RL - Reload MR1 with the contents of the Match 1 Shadow Register when the TC is reset to zero
 *    (either via a match event or a write to bit 1 of the TCR). 0 = disabled. 1 = enabled.
 */
#define CTIMER_MCR_MR1RL(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR1RL_SHIFT)) & CTIMER_MCR_MR1RL_MASK)

#define CTIMER_MCR_MR2RL_MASK                    (0x4000000U)
#define CTIMER_MCR_MR2RL_SHIFT                   (26U)
/*! MR2RL - Reload MR2 with the contents of the Match 2 Shadow Register when the TC is reset to zero
 *    (either via a match event or a write to bit 1 of the TCR). 0 = disabled. 1 = enabled.
 */
#define CTIMER_MCR_MR2RL(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR2RL_SHIFT)) & CTIMER_MCR_MR2RL_MASK)

#define CTIMER_MCR_MR3RL_MASK                    (0x8000000U)
#define CTIMER_MCR_MR3RL_SHIFT                   (27U)
/*! MR3RL - Reload MR3 with the contents of the Match 3 Shadow Register when the TC is reset to zero
 *    (either via a match event or a write to bit 1 of the TCR). 0 = disabled. 1 = enabled.
 */
#define CTIMER_MCR_MR3RL(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR3RL_SHIFT)) & CTIMER_MCR_MR3RL_MASK)
/*! @} */

/*! @name MR - Match Register . MR can be enabled through the MCR to reset the TC, stop both the TC and PC, and/or generate an interrupt every time MR matches the TC. */
/*! @{ */

#define CTIMER_MR_MATCH_MASK                     (0xFFFFFFFFU)
#define CTIMER_MR_MATCH_SHIFT                    (0U)
/*! MATCH - Timer counter match value.
 */
#define CTIMER_MR_MATCH(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MR_MATCH_SHIFT)) & CTIMER_MR_MATCH_MASK)
/*! @} */

/* The count of CTIMER_MR */
#define CTIMER_MR_COUNT                          (4U)

/*! @name CCR - Capture Control Register. The CCR controls which edges of the capture inputs are used to load the Capture Registers and whether or not an interrupt is generated when a capture takes place. */
/*! @{ */

#define CTIMER_CCR_CAP0RE_MASK                   (0x1U)
#define CTIMER_CCR_CAP0RE_SHIFT                  (0U)
/*! CAP0RE - Rising edge of capture channel 0: a sequence of 0 then 1 causes CR0 to be loaded with
 *    the contents of TC. 0 = disabled. 1 = enabled.
 */
#define CTIMER_CCR_CAP0RE(x)                     (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP0RE_SHIFT)) & CTIMER_CCR_CAP0RE_MASK)

#define CTIMER_CCR_CAP0FE_MASK                   (0x2U)
#define CTIMER_CCR_CAP0FE_SHIFT                  (1U)
/*! CAP0FE - Falling edge of capture channel 0: a sequence of 1 then 0 causes CR0 to be loaded with
 *    the contents of TC. 0 = disabled. 1 = enabled.
 */
#define CTIMER_CCR_CAP0FE(x)                     (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP0FE_SHIFT)) & CTIMER_CCR_CAP0FE_MASK)

#define CTIMER_CCR_CAP0I_MASK                    (0x4U)
#define CTIMER_CCR_CAP0I_SHIFT                   (2U)
/*! CAP0I - Generate interrupt on channel 0 capture event: a CR0 load generates an interrupt.
 */
#define CTIMER_CCR_CAP0I(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP0I_SHIFT)) & CTIMER_CCR_CAP0I_MASK)

#define CTIMER_CCR_CAP1RE_MASK                   (0x8U)
#define CTIMER_CCR_CAP1RE_SHIFT                  (3U)
/*! CAP1RE - Rising edge of capture channel 1: a sequence of 0 then 1 causes CR1 to be loaded with
 *    the contents of TC. 0 = disabled. 1 = enabled.
 */
#define CTIMER_CCR_CAP1RE(x)                     (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP1RE_SHIFT)) & CTIMER_CCR_CAP1RE_MASK)

#define CTIMER_CCR_CAP1FE_MASK                   (0x10U)
#define CTIMER_CCR_CAP1FE_SHIFT                  (4U)
/*! CAP1FE - Falling edge of capture channel 1: a sequence of 1 then 0 causes CR1 to be loaded with
 *    the contents of TC. 0 = disabled. 1 = enabled.
 */
#define CTIMER_CCR_CAP1FE(x)                     (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP1FE_SHIFT)) & CTIMER_CCR_CAP1FE_MASK)

#define CTIMER_CCR_CAP1I_MASK                    (0x20U)
#define CTIMER_CCR_CAP1I_SHIFT                   (5U)
/*! CAP1I - Generate interrupt on channel 1 capture event: a CR1 load generates an interrupt.
 */
#define CTIMER_CCR_CAP1I(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP1I_SHIFT)) & CTIMER_CCR_CAP1I_MASK)

#define CTIMER_CCR_CAP2RE_MASK                   (0x40U)
#define CTIMER_CCR_CAP2RE_SHIFT                  (6U)
/*! CAP2RE - Rising edge of capture channel 2: a sequence of 0 then 1 causes CR2 to be loaded with
 *    the contents of TC. 0 = disabled. 1 = enabled.
 */
#define CTIMER_CCR_CAP2RE(x)                     (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP2RE_SHIFT)) & CTIMER_CCR_CAP2RE_MASK)

#define CTIMER_CCR_CAP2FE_MASK                   (0x80U)
#define CTIMER_CCR_CAP2FE_SHIFT                  (7U)
/*! CAP2FE - Falling edge of capture channel 2: a sequence of 1 then 0 causes CR2 to be loaded with
 *    the contents of TC. 0 = disabled. 1 = enabled.
 */
#define CTIMER_CCR_CAP2FE(x)                     (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP2FE_SHIFT)) & CTIMER_CCR_CAP2FE_MASK)

#define CTIMER_CCR_CAP2I_MASK                    (0x100U)
#define CTIMER_CCR_CAP2I_SHIFT                   (8U)
/*! CAP2I - Generate interrupt on channel 2 capture event: a CR2 load generates an interrupt.
 */
#define CTIMER_CCR_CAP2I(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP2I_SHIFT)) & CTIMER_CCR_CAP2I_MASK)

#define CTIMER_CCR_CAP3RE_MASK                   (0x200U)
#define CTIMER_CCR_CAP3RE_SHIFT                  (9U)
/*! CAP3RE - Rising edge of capture channel 3: a sequence of 0 then 1 causes CR3 to be loaded with
 *    the contents of TC. 0 = disabled. 1 = enabled.
 */
#define CTIMER_CCR_CAP3RE(x)                     (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP3RE_SHIFT)) & CTIMER_CCR_CAP3RE_MASK)

#define CTIMER_CCR_CAP3FE_MASK                   (0x400U)
#define CTIMER_CCR_CAP3FE_SHIFT                  (10U)
/*! CAP3FE - Falling edge of capture channel 3: a sequence of 1 then 0 causes CR3 to be loaded with
 *    the contents of TC. 0 = disabled. 1 = enabled.
 */
#define CTIMER_CCR_CAP3FE(x)                     (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP3FE_SHIFT)) & CTIMER_CCR_CAP3FE_MASK)

#define CTIMER_CCR_CAP3I_MASK                    (0x800U)
#define CTIMER_CCR_CAP3I_SHIFT                   (11U)
/*! CAP3I - Generate interrupt on channel 3 capture event: a CR3 load generates an interrupt.
 */
#define CTIMER_CCR_CAP3I(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP3I_SHIFT)) & CTIMER_CCR_CAP3I_MASK)
/*! @} */

/*! @name CR - Capture Register . CR is loaded with the value of TC when there is an event on the CAPn. input. */
/*! @{ */

#define CTIMER_CR_CAP_MASK                       (0xFFFFFFFFU)
#define CTIMER_CR_CAP_SHIFT                      (0U)
/*! CAP - Timer counter capture value.
 */
#define CTIMER_CR_CAP(x)                         (((uint32_t)(((uint32_t)(x)) << CTIMER_CR_CAP_SHIFT)) & CTIMER_CR_CAP_MASK)
/*! @} */

/* The count of CTIMER_CR */
#define CTIMER_CR_COUNT                          (4U)

/*! @name EMR - External Match Register. The EMR controls the match function and the external match pins. */
/*! @{ */

#define CTIMER_EMR_EM0_MASK                      (0x1U)
#define CTIMER_EMR_EM0_SHIFT                     (0U)
/*! EM0 - External Match 0. This bit reflects the state of output MAT0, whether or not this output
 *    is connected to a pin. When a match occurs between the TC and MR0, this bit can either toggle,
 *    go LOW, go HIGH, or do nothing, as selected by EMR[5:4]. This bit is driven to the MAT pins if
 *    the match function is selected via IOCON. 0 = LOW. 1 = HIGH.
 */
#define CTIMER_EMR_EM0(x)                        (((uint32_t)(((uint32_t)(x)) << CTIMER_EMR_EM0_SHIFT)) & CTIMER_EMR_EM0_MASK)

#define CTIMER_EMR_EM1_MASK                      (0x2U)
#define CTIMER_EMR_EM1_SHIFT                     (1U)
/*! EM1 - External Match 1. This bit reflects the state of output MAT1, whether or not this output
 *    is connected to a pin. When a match occurs between the TC and MR1, this bit can either toggle,
 *    go LOW, go HIGH, or do nothing, as selected by EMR[7:6]. This bit is driven to the MAT pins if
 *    the match function is selected via IOCON. 0 = LOW. 1 = HIGH.
 */
#define CTIMER_EMR_EM1(x)                        (((uint32_t)(((uint32_t)(x)) << CTIMER_EMR_EM1_SHIFT)) & CTIMER_EMR_EM1_MASK)

#define CTIMER_EMR_EM2_MASK                      (0x4U)
#define CTIMER_EMR_EM2_SHIFT                     (2U)
/*! EM2 - External Match 2. This bit reflects the state of output MAT2, whether or not this output
 *    is connected to a pin. When a match occurs between the TC and MR2, this bit can either toggle,
 *    go LOW, go HIGH, or do nothing, as selected by EMR[9:8]. This bit is driven to the MAT pins if
 *    the match function is selected via IOCON. 0 = LOW. 1 = HIGH.
 */
#define CTIMER_EMR_EM2(x)                        (((uint32_t)(((uint32_t)(x)) << CTIMER_EMR_EM2_SHIFT)) & CTIMER_EMR_EM2_MASK)

#define CTIMER_EMR_EM3_MASK                      (0x8U)
#define CTIMER_EMR_EM3_SHIFT                     (3U)
/*! EM3 - External Match 3. This bit reflects the state of output MAT3, whether or not this output
 *    is connected to a pin. When a match occurs between the TC and MR3, this bit can either toggle,
 *    go LOW, go HIGH, or do nothing, as selected by MR[11:10]. This bit is driven to the MAT pins
 *    if the match function is selected via IOCON. 0 = LOW. 1 = HIGH.
 */
#define CTIMER_EMR_EM3(x)                        (((uint32_t)(((uint32_t)(x)) << CTIMER_EMR_EM3_SHIFT)) & CTIMER_EMR_EM3_MASK)

#define CTIMER_EMR_EMC0_MASK                     (0x30U)
#define CTIMER_EMR_EMC0_SHIFT                    (4U)
/*! EMC0 - External Match Control 0. Determines the functionality of External Match 0.
 *  0b00..Do Nothing.
 *  0b01..Clear. Clear the corresponding External Match bit/output to 0 (MAT0 pin is LOW if pinned out).
 *  0b10..Set. Set the corresponding External Match bit/output to 1 (MAT0 pin is HIGH if pinned out).
 *  0b11..Toggle. Toggle the corresponding External Match bit/output.
 */
#define CTIMER_EMR_EMC0(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_EMR_EMC0_SHIFT)) & CTIMER_EMR_EMC0_MASK)

#define CTIMER_EMR_EMC1_MASK                     (0xC0U)
#define CTIMER_EMR_EMC1_SHIFT                    (6U)
/*! EMC1 - External Match Control 1. Determines the functionality of External Match 1.
 *  0b00..Do Nothing.
 *  0b01..Clear. Clear the corresponding External Match bit/output to 0 (MAT1 pin is LOW if pinned out).
 *  0b10..Set. Set the corresponding External Match bit/output to 1 (MAT1 pin is HIGH if pinned out).
 *  0b11..Toggle. Toggle the corresponding External Match bit/output.
 */
#define CTIMER_EMR_EMC1(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_EMR_EMC1_SHIFT)) & CTIMER_EMR_EMC1_MASK)

#define CTIMER_EMR_EMC2_MASK                     (0x300U)
#define CTIMER_EMR_EMC2_SHIFT                    (8U)
/*! EMC2 - External Match Control 2. Determines the functionality of External Match 2.
 *  0b00..Do Nothing.
 *  0b01..Clear. Clear the corresponding External Match bit/output to 0 (MAT2 pin is LOW if pinned out).
 *  0b10..Set. Set the corresponding External Match bit/output to 1 (MAT2 pin is HIGH if pinned out).
 *  0b11..Toggle. Toggle the corresponding External Match bit/output.
 */
#define CTIMER_EMR_EMC2(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_EMR_EMC2_SHIFT)) & CTIMER_EMR_EMC2_MASK)

#define CTIMER_EMR_EMC3_MASK                     (0xC00U)
#define CTIMER_EMR_EMC3_SHIFT                    (10U)
/*! EMC3 - External Match Control 3. Determines the functionality of External Match 3.
 *  0b00..Do Nothing.
 *  0b01..Clear. Clear the corresponding External Match bit/output to 0 (MAT3 pin is LOW if pinned out).
 *  0b10..Set. Set the corresponding External Match bit/output to 1 (MAT3 pin is HIGH if pinned out).
 *  0b11..Toggle. Toggle the corresponding External Match bit/output.
 */
#define CTIMER_EMR_EMC3(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_EMR_EMC3_SHIFT)) & CTIMER_EMR_EMC3_MASK)
/*! @} */

/*! @name CTCR - Count Control Register. The CTCR selects between Timer and Counter mode, and in Counter mode selects the signal and edge(s) for counting. */
/*! @{ */

#define CTIMER_CTCR_CTMODE_MASK                  (0x3U)
#define CTIMER_CTCR_CTMODE_SHIFT                 (0U)
/*! CTMODE - Counter/Timer Mode This field selects which rising APB bus clock edges can increment
 *    Timer's Prescale Counter (PC), or clear PC and increment Timer Counter (TC). Timer Mode: the TC
 *    is incremented when the Prescale Counter matches the Prescale Register.
 *  0b00..Timer Mode. Incremented every rising APB bus clock edge.
 *  0b01..Counter Mode rising edge. TC is incremented on rising edges on the CAP input selected by bits 3:2.
 *  0b10..Counter Mode falling edge. TC is incremented on falling edges on the CAP input selected by bits 3:2.
 *  0b11..Counter Mode dual edge. TC is incremented on both edges on the CAP input selected by bits 3:2.
 */
#define CTIMER_CTCR_CTMODE(x)                    (((uint32_t)(((uint32_t)(x)) << CTIMER_CTCR_CTMODE_SHIFT)) & CTIMER_CTCR_CTMODE_MASK)

#define CTIMER_CTCR_CINSEL_MASK                  (0xCU)
#define CTIMER_CTCR_CINSEL_SHIFT                 (2U)
/*! CINSEL - Count Input Select When bits 1:0 in this register are not 00, these bits select which
 *    CAP pin is sampled for clocking. Note: If Counter mode is selected for a particular CAPn input
 *    in the CTCR, the 3 bits for that input in the Capture Control Register (CCR) must be
 *    programmed as 000. However, capture and/or interrupt can be selected for the other 3 CAPn inputs in the
 *    same timer.
 *  0b00..Channel 0. CAPn.0 for CTIMERn
 *  0b01..Channel 1. CAPn.1 for CTIMERn
 *  0b10..Channel 2. CAPn.2 for CTIMERn
 *  0b11..Channel 3. CAPn.3 for CTIMERn
 */
#define CTIMER_CTCR_CINSEL(x)                    (((uint32_t)(((uint32_t)(x)) << CTIMER_CTCR_CINSEL_SHIFT)) & CTIMER_CTCR_CINSEL_MASK)

#define CTIMER_CTCR_ENCC_MASK                    (0x10U)
#define CTIMER_CTCR_ENCC_SHIFT                   (4U)
/*! ENCC - Setting this bit to 1 enables clearing of the timer and the prescaler when the
 *    capture-edge event specified in bits 7:5 occurs.
 */
#define CTIMER_CTCR_ENCC(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_CTCR_ENCC_SHIFT)) & CTIMER_CTCR_ENCC_MASK)

#define CTIMER_CTCR_SELCC_MASK                   (0xE0U)
#define CTIMER_CTCR_SELCC_SHIFT                  (5U)
/*! SELCC - Edge select. When bit 4 is 1, these bits select which capture input edge will cause the
 *    timer and prescaler to be cleared. These bits have no effect when bit 4 is low. Values 0x2 to
 *    0x3 and 0x6 to 0x7 are reserved.
 *  0b000..Channel 0 Rising Edge. Rising edge of the signal on capture channel 0 clears the timer (if bit 4 is set).
 *  0b001..Channel 0 Falling Edge. Falling edge of the signal on capture channel 0 clears the timer (if bit 4 is set).
 *  0b010..Channel 1 Rising Edge. Rising edge of the signal on capture channel 1 clears the timer (if bit 4 is set).
 *  0b011..Channel 1 Falling Edge. Falling edge of the signal on capture channel 1 clears the timer (if bit 4 is set).
 *  0b100..Channel 2 Rising Edge. Rising edge of the signal on capture channel 2 clears the timer (if bit 4 is set).
 *  0b101..Channel 2 Falling Edge. Falling edge of the signal on capture channel 2 clears the timer (if bit 4 is set).
 */
#define CTIMER_CTCR_SELCC(x)                     (((uint32_t)(((uint32_t)(x)) << CTIMER_CTCR_SELCC_SHIFT)) & CTIMER_CTCR_SELCC_MASK)
/*! @} */

/*! @name PWMC - PWM Control Register. The PWMCON enables PWM mode for the external match pins. */
/*! @{ */

#define CTIMER_PWMC_PWMEN0_MASK                  (0x1U)
#define CTIMER_PWMC_PWMEN0_SHIFT                 (0U)
/*! PWMEN0 - PWM mode enable for channel0.
 *  0b0..Match. CTIMERn_MAT0 is controlled by EM0.
 *  0b1..PWM. PWM mode is enabled for CTIMERn_MAT0.
 */
#define CTIMER_PWMC_PWMEN0(x)                    (((uint32_t)(((uint32_t)(x)) << CTIMER_PWMC_PWMEN0_SHIFT)) & CTIMER_PWMC_PWMEN0_MASK)

#define CTIMER_PWMC_PWMEN1_MASK                  (0x2U)
#define CTIMER_PWMC_PWMEN1_SHIFT                 (1U)
/*! PWMEN1 - PWM mode enable for channel1.
 *  0b0..Match. CTIMERn_MAT01 is controlled by EM1.
 *  0b1..PWM. PWM mode is enabled for CTIMERn_MAT1.
 */
#define CTIMER_PWMC_PWMEN1(x)                    (((uint32_t)(((uint32_t)(x)) << CTIMER_PWMC_PWMEN1_SHIFT)) & CTIMER_PWMC_PWMEN1_MASK)

#define CTIMER_PWMC_PWMEN2_MASK                  (0x4U)
#define CTIMER_PWMC_PWMEN2_SHIFT                 (2U)
/*! PWMEN2 - PWM mode enable for channel2.
 *  0b0..Match. CTIMERn_MAT2 is controlled by EM2.
 *  0b1..PWM. PWM mode is enabled for CTIMERn_MAT2.
 */
#define CTIMER_PWMC_PWMEN2(x)                    (((uint32_t)(((uint32_t)(x)) << CTIMER_PWMC_PWMEN2_SHIFT)) & CTIMER_PWMC_PWMEN2_MASK)

#define CTIMER_PWMC_PWMEN3_MASK                  (0x8U)
#define CTIMER_PWMC_PWMEN3_SHIFT                 (3U)
/*! PWMEN3 - PWM mode enable for channel3. Note: It is recommended to use match channel 3 to set the PWM cycle.
 *  0b0..Match. CTIMERn_MAT3 is controlled by EM3.
 *  0b1..PWM. PWM mode is enabled for CT132Bn_MAT3.
 */
#define CTIMER_PWMC_PWMEN3(x)                    (((uint32_t)(((uint32_t)(x)) << CTIMER_PWMC_PWMEN3_SHIFT)) & CTIMER_PWMC_PWMEN3_MASK)
/*! @} */

/*! @name MSR - Match Shadow Register . If enabled, the Match Register will be automatically reloaded with the contents of this register whenever the TC is reset to zero. */
/*! @{ */

#define CTIMER_MSR_MATCH_SHADOW_MASK             (0xFFFFFFFFU)
#define CTIMER_MSR_MATCH_SHADOW_SHIFT            (0U)
/*! MATCH_Shadow - Timer counter match value.
 */
#define CTIMER_MSR_MATCH_SHADOW(x)               (((uint32_t)(((uint32_t)(x)) << CTIMER_MSR_MATCH_SHADOW_SHIFT)) & CTIMER_MSR_MATCH_SHADOW_MASK)
/*! @} */

/* The count of CTIMER_MSR */
#define CTIMER_MSR_COUNT                         (4U)


/*!
 * @}
 */ /* end of group CTIMER_Register_Masks */


/* CTIMER - Peripheral instance base addresses */
/** Peripheral CTIMER0 base address */
#define CTIMER0_BASE                             (0x40028000u)
/** Peripheral CTIMER0 base pointer */
#define CTIMER0                                  ((CTIMER_Type *)CTIMER0_BASE)
/** Peripheral CTIMER1 base address */
#define CTIMER1_BASE                             (0x40029000u)
/** Peripheral CTIMER1 base pointer */
#define CTIMER1                                  ((CTIMER_Type *)CTIMER1_BASE)
/** Peripheral CTIMER2 base address */
#define CTIMER2_BASE                             (0x4002A000u)
/** Peripheral CTIMER2 base pointer */
#define CTIMER2                                  ((CTIMER_Type *)CTIMER2_BASE)
/** Peripheral CTIMER3 base address */
#define CTIMER3_BASE                             (0x4002B000u)
/** Peripheral CTIMER3 base pointer */
#define CTIMER3                                  ((CTIMER_Type *)CTIMER3_BASE)
/** Peripheral CTIMER4 base address */
#define CTIMER4_BASE                             (0x4002C000u)
/** Peripheral CTIMER4 base pointer */
#define CTIMER4                                  ((CTIMER_Type *)CTIMER4_BASE)
/** Array initializer of CTIMER peripheral base addresses */
#define CTIMER_BASE_ADDRS                        { CTIMER0_BASE, CTIMER1_BASE, CTIMER2_BASE, CTIMER3_BASE, CTIMER4_BASE }
/** Array initializer of CTIMER peripheral base pointers */
#define CTIMER_BASE_PTRS                         { CTIMER0, CTIMER1, CTIMER2, CTIMER3, CTIMER4 }
/** Interrupt vectors for the CTIMER peripheral type */
#define CTIMER_IRQS                              { CTIMER0_IRQn, CTIMER1_IRQn, CTIMER2_IRQn, CTIMER3_IRQn, CTIMER4_IRQn }

/*!
 * @}
 */ /* end of group CTIMER_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- DMA Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DMA_Peripheral_Access_Layer DMA Peripheral Access Layer
 * @{
 */

/** DMA - Register Layout Typedef */
typedef struct {
  __IO uint32_t CTRL;                              /**< DMA control., offset: 0x0 */
  __I  uint32_t INTSTAT;                           /**< Interrupt status., offset: 0x4 */
  __IO uint32_t SRAMBASE;                          /**< SRAM address of the channel configuration table., offset: 0x8 */
       uint8_t RESERVED_0[20];
  struct {                                         /* offset: 0x20, array step: 0x60 */
    __IO uint32_t ENABLESET;                         /**< Channel Enable read and Set for all DMA channels., array offset: 0x20, array step: 0x60 */
    __IO uint32_t ENABLESET1;                        /**< Channel Enable read and Set for all DMA channels., array offset: 0x24, array step: 0x60 */
    __O  uint32_t ENABLECLR;                         /**< Channel Enable Clear for all DMA channels., array offset: 0x28, array step: 0x60 */
    __O  uint32_t ENABLECLR1;                        /**< Channel Enable Clear for all DMA channels., array offset: 0x2C, array step: 0x60 */
    __I  uint32_t ACTIVE;                            /**< Channel Active status for all DMA channels., array offset: 0x30, array step: 0x60 */
    __I  uint32_t ACTIVE1;                           /**< Channel Active status for all DMA channels., array offset: 0x34, array step: 0x60 */
    __I  uint32_t BUSY;                              /**< Channel Busy status for all DMA channels., array offset: 0x38, array step: 0x60 */
    __I  uint32_t BUSY1;                             /**< Channel Busy status for all DMA channels., array offset: 0x3C, array step: 0x60 */
    __IO uint32_t ERRINT;                            /**< Error Interrupt status for all DMA channels., array offset: 0x40, array step: 0x60 */
    __IO uint32_t ERRINT1;                           /**< Error Interrupt status for all DMA channels., array offset: 0x44, array step: 0x60 */
    __IO uint32_t INTENSET;                          /**< Interrupt Enable read and Set for all DMA channels., array offset: 0x48, array step: 0x60 */
    __IO uint32_t INTENSET1;                         /**< Interrupt Enable read and Set for all DMA channels., array offset: 0x4C, array step: 0x60 */
    __O  uint32_t INTENCLR;                          /**< Interrupt Enable Clear for all DMA channels., array offset: 0x50, array step: 0x60 */
    __O  uint32_t INTENCLR1;                         /**< Interrupt Enable Clear for all DMA channels., array offset: 0x54, array step: 0x60 */
    __IO uint32_t INTA;                              /**< Interrupt A status for all DMA channels., array offset: 0x58, array step: 0x60 */
    __IO uint32_t INTA1;                             /**< Interrupt A status for all DMA channels., array offset: 0x5C, array step: 0x60 */
    __IO uint32_t INTB;                              /**< Interrupt B status for all DMA channels., array offset: 0x60, array step: 0x60 */
    __IO uint32_t INTB1;                             /**< Interrupt B status for all DMA channels., array offset: 0x64, array step: 0x60 */
    __O  uint32_t SETVALID;                          /**< Set ValidPending control bits for all DMA channels., array offset: 0x68, array step: 0x60 */
    __O  uint32_t SETVALID1;                         /**< Set ValidPending control bits for all DMA channels., array offset: 0x6C, array step: 0x60 */
    __O  uint32_t SETTRIG;                           /**< Set Trigger control bits for all DMA channels., array offset: 0x70, array step: 0x60 */
    __O  uint32_t SETTRIG1;                          /**< Set Trigger control bits for all DMA channels., array offset: 0x74, array step: 0x60 */
    __O  uint32_t ABORT;                             /**< Channel Abort control for all DMA channels., array offset: 0x78, array step: 0x60 */
    __O  uint32_t ABORT1;                            /**< Channel Abort control for all DMA channels., array offset: 0x7C, array step: 0x60 */
  } COMMON[1];
       uint8_t RESERVED_1[896];
  struct {                                         /* offset: 0x400, array step: 0x10 */
    __IO uint32_t CFG;                               /**< Configuration register for DMA channel ., array offset: 0x400, array step: 0x10 */
    __I  uint32_t CTLSTAT;                           /**< Control and status register for DMA channel ., array offset: 0x404, array step: 0x10 */
    __IO uint32_t XFERCFG;                           /**< Transfer configuration register for DMA channel ., array offset: 0x408, array step: 0x10 */
         uint8_t RESERVED_0[4];
  } CHANNEL[33];
} DMA_Type;

/* ----------------------------------------------------------------------------
   -- DMA Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DMA_Register_Masks DMA Register Masks
 * @{
 */

/*! @name CTRL - DMA control. */
/*! @{ */

#define DMA_CTRL_ENABLE_MASK                     (0x1U)
#define DMA_CTRL_ENABLE_SHIFT                    (0U)
/*! ENABLE - DMA controller master enable.
 *  0b0..Disabled. The DMA controller is disabled. This clears any triggers that were asserted at the point when
 *       disabled, but does not prevent re-triggering when the DMA controller is re-enabled.
 *  0b1..Enabled. The DMA controller is enabled.
 */
#define DMA_CTRL_ENABLE(x)                       (((uint32_t)(((uint32_t)(x)) << DMA_CTRL_ENABLE_SHIFT)) & DMA_CTRL_ENABLE_MASK)
/*! @} */

/*! @name INTSTAT - Interrupt status. */
/*! @{ */

#define DMA_INTSTAT_ACTIVEINT_MASK               (0x2U)
#define DMA_INTSTAT_ACTIVEINT_SHIFT              (1U)
/*! ACTIVEINT - Summarizes whether any enabled interrupts (other than error interrupts) are pending.
 *  0b0..Not pending. No enabled interrupts are pending.
 *  0b1..Pending. At least one enabled interrupt is pending.
 */
#define DMA_INTSTAT_ACTIVEINT(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_INTSTAT_ACTIVEINT_SHIFT)) & DMA_INTSTAT_ACTIVEINT_MASK)

#define DMA_INTSTAT_ACTIVEERRINT_MASK            (0x4U)
#define DMA_INTSTAT_ACTIVEERRINT_SHIFT           (2U)
/*! ACTIVEERRINT - Summarizes whether any error interrupts are pending.
 *  0b0..Not pending. No error interrupts are pending.
 *  0b1..Pending. At least one error interrupt is pending.
 */
#define DMA_INTSTAT_ACTIVEERRINT(x)              (((uint32_t)(((uint32_t)(x)) << DMA_INTSTAT_ACTIVEERRINT_SHIFT)) & DMA_INTSTAT_ACTIVEERRINT_MASK)
/*! @} */

/*! @name SRAMBASE - SRAM address of the channel configuration table. */
/*! @{ */

#define DMA_SRAMBASE_OFFSET_MASK                 (0xFFFFFE00U)
#define DMA_SRAMBASE_OFFSET_SHIFT                (9U)
/*! OFFSET - Address bits 31:9 of the beginning of the DMA descriptor table. For 18 channels, the
 *    table must begin on a 512 byte boundary.
 */
#define DMA_SRAMBASE_OFFSET(x)                   (((uint32_t)(((uint32_t)(x)) << DMA_SRAMBASE_OFFSET_SHIFT)) & DMA_SRAMBASE_OFFSET_MASK)
/*! @} */

/*! @name COMMON_ENABLESET - Channel Enable read and Set for all DMA channels. */
/*! @{ */

#define DMA_COMMON_ENABLESET_ENA_MASK            (0xFFFFFFFFU)
#define DMA_COMMON_ENABLESET_ENA_SHIFT           (0U)
/*! ENA - Enable for DMA channel 0
 *  0b00000000000000000000000000000000..DMAchannel 0 is disabled.
 *  0b00000000000000000000000000000001..DMAchannel 0 is enabled.
 */
#define DMA_COMMON_ENABLESET_ENA(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENA_SHIFT)) & DMA_COMMON_ENABLESET_ENA_MASK)
/*! @} */

/* The count of DMA_COMMON_ENABLESET */
#define DMA_COMMON_ENABLESET_COUNT               (1U)

/*! @name COMMON_ENABLESET1 - Channel Enable read and Set for all DMA channels. */
/*! @{ */

#define DMA_COMMON_ENABLESET1_ENABLE32_MASK      (0x1U)
#define DMA_COMMON_ENABLESET1_ENABLE32_SHIFT     (0U)
/*! ENABLE32 - Enable for DMA channel 32
 *  0b0..DMAchannel 32 is disabled.
 *  0b1..DMAchannel 32 is enabled.
 */
#define DMA_COMMON_ENABLESET1_ENABLE32(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET1_ENABLE32_SHIFT)) & DMA_COMMON_ENABLESET1_ENABLE32_MASK)

#define DMA_COMMON_ENABLESET1_ENABLE63_33_MASK   (0xFFFFFFFEU)
#define DMA_COMMON_ENABLESET1_ENABLE63_33_SHIFT  (1U)
/*! ENABLE63_33 - Additional enables for remaining DMA channels in the range 63 to 33.
 *  0b0000000000000000000000000000000..The relevant DMA channel is disabled.
 *  0b0000000000000000000000000000001..The relevant DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET1_ENABLE63_33(x)     (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET1_ENABLE63_33_SHIFT)) & DMA_COMMON_ENABLESET1_ENABLE63_33_MASK)
/*! @} */

/* The count of DMA_COMMON_ENABLESET1 */
#define DMA_COMMON_ENABLESET1_COUNT              (1U)

/*! @name COMMON_ENABLECLR - Channel Enable Clear for all DMA channels. */
/*! @{ */

#define DMA_COMMON_ENABLECLR_CLR_MASK            (0xFFFFFFFFU)
#define DMA_COMMON_ENABLECLR_CLR_SHIFT           (0U)
/*! CLR - Writing ones to this register clears the corresponding bits in ENABLESET0.
 */
#define DMA_COMMON_ENABLECLR_CLR(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR_SHIFT)) & DMA_COMMON_ENABLECLR_CLR_MASK)
/*! @} */

/* The count of DMA_COMMON_ENABLECLR */
#define DMA_COMMON_ENABLECLR_COUNT               (1U)

/*! @name COMMON_ENABLECLR1 - Channel Enable Clear for all DMA channels. */
/*! @{ */

#define DMA_COMMON_ENABLECLR1_CLR_MASK           (0xFFFFFFFFU)
#define DMA_COMMON_ENABLECLR1_CLR_SHIFT          (0U)
/*! CLR - Writing ones to this register clears the corresponding bits in ENABLESET1.
 */
#define DMA_COMMON_ENABLECLR1_CLR(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR1_CLR_SHIFT)) & DMA_COMMON_ENABLECLR1_CLR_MASK)
/*! @} */

/* The count of DMA_COMMON_ENABLECLR1 */
#define DMA_COMMON_ENABLECLR1_COUNT              (1U)

/*! @name COMMON_ACTIVE - Channel Active status for all DMA channels. */
/*! @{ */

#define DMA_COMMON_ACTIVE_ACT_MASK               (0xFFFFFFFFU)
#define DMA_COMMON_ACTIVE_ACT_SHIFT              (0U)
/*! ACT - Active flag for DMA channel 0.
 *  0b00000000000000000000000000000000..DMAchannel 0 is not active.
 *  0b00000000000000000000000000000001..DMAchannel 0 is active.
 */
#define DMA_COMMON_ACTIVE_ACT(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACT_SHIFT)) & DMA_COMMON_ACTIVE_ACT_MASK)
/*! @} */

/* The count of DMA_COMMON_ACTIVE */
#define DMA_COMMON_ACTIVE_COUNT                  (1U)

/*! @name COMMON_ACTIVE1 - Channel Active status for all DMA channels. */
/*! @{ */

#define DMA_COMMON_ACTIVE1_ACTIVE32_MASK         (0x1U)
#define DMA_COMMON_ACTIVE1_ACTIVE32_SHIFT        (0U)
/*! ACTIVE32 - Active flag for DMA channel 32.
 *  0b0..DMAchannel 32 is not active.
 *  0b1..DMAchannel 32 is active.
 */
#define DMA_COMMON_ACTIVE1_ACTIVE32(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE1_ACTIVE32_SHIFT)) & DMA_COMMON_ACTIVE1_ACTIVE32_MASK)

#define DMA_COMMON_ACTIVE1_ACTIVE63_33_MASK      (0xFFFFFFFEU)
#define DMA_COMMON_ACTIVE1_ACTIVE63_33_SHIFT     (1U)
/*! ACTIVE63_33 - Additional Active flags for remaining DMA channels in the range 63 to 33. Any bits
 *    above the actually implemented channels are reserved.
 *  0b0000000000000000000000000000000..The relevant DMA channel is not active.
 *  0b0000000000000000000000000000001..The relevant DMA channel is active.
 */
#define DMA_COMMON_ACTIVE1_ACTIVE63_33(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE1_ACTIVE63_33_SHIFT)) & DMA_COMMON_ACTIVE1_ACTIVE63_33_MASK)
/*! @} */

/* The count of DMA_COMMON_ACTIVE1 */
#define DMA_COMMON_ACTIVE1_COUNT                 (1U)

/*! @name COMMON_BUSY - Channel Busy status for all DMA channels. */
/*! @{ */

#define DMA_COMMON_BUSY_BSY_MASK                 (0xFFFFFFFFU)
#define DMA_COMMON_BUSY_BSY_SHIFT                (0U)
/*! BSY - Busy flag for DMA channel 0.
 *  0b00000000000000000000000000000000..DMAchannel 0 is not busy.
 *  0b00000000000000000000000000000001..DMAchannel 0 is busy.
 */
#define DMA_COMMON_BUSY_BSY(x)                   (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BSY_SHIFT)) & DMA_COMMON_BUSY_BSY_MASK)
/*! @} */

/* The count of DMA_COMMON_BUSY */
#define DMA_COMMON_BUSY_COUNT                    (1U)

/*! @name COMMON_BUSY1 - Channel Busy status for all DMA channels. */
/*! @{ */

#define DMA_COMMON_BUSY1_BUSY32_MASK             (0x1U)
#define DMA_COMMON_BUSY1_BUSY32_SHIFT            (0U)
/*! BUSY32 - Busy flag for DMA channel 32.
 *  0b0..DMAchannel 32 is not busy.
 *  0b1..DMAchannel 0 is busy.
 */
#define DMA_COMMON_BUSY1_BUSY32(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY1_BUSY32_SHIFT)) & DMA_COMMON_BUSY1_BUSY32_MASK)

#define DMA_COMMON_BUSY1_BUSY63_33_MASK          (0xFFFFFFFEU)
#define DMA_COMMON_BUSY1_BUSY63_33_SHIFT         (1U)
/*! BUSY63_33 - Additional Active flags for remaining DMA channels in the range 63 to 33. Any bits
 *    above the actually implemented channels are reserved.
 *  0b0000000000000000000000000000000..The relevant DMA channel is not busy.
 *  0b0000000000000000000000000000001..The relevant DMA channel is busy.
 */
#define DMA_COMMON_BUSY1_BUSY63_33(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY1_BUSY63_33_SHIFT)) & DMA_COMMON_BUSY1_BUSY63_33_MASK)
/*! @} */

/* The count of DMA_COMMON_BUSY1 */
#define DMA_COMMON_BUSY1_COUNT                   (1U)

/*! @name COMMON_ERRINT - Error Interrupt status for all DMA channels. */
/*! @{ */

#define DMA_COMMON_ERRINT_ERR_MASK               (0xFFFFFFFFU)
#define DMA_COMMON_ERRINT_ERR_SHIFT              (0U)
/*! ERR - Error Interrupt flag for DMA channel 0.
 *  0b00000000000000000000000000000000..The Error Interrupt is not active for DMA channel 0.
 *  0b00000000000000000000000000000001..The Error Interrupt is pending for DMA channel 0.
 */
#define DMA_COMMON_ERRINT_ERR(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR_SHIFT)) & DMA_COMMON_ERRINT_ERR_MASK)
/*! @} */

/* The count of DMA_COMMON_ERRINT */
#define DMA_COMMON_ERRINT_COUNT                  (1U)

/*! @name COMMON_ERRINT1 - Error Interrupt status for all DMA channels. */
/*! @{ */

#define DMA_COMMON_ERRINT1_ERR32_MASK            (0x1U)
#define DMA_COMMON_ERRINT1_ERR32_SHIFT           (0U)
/*! ERR32 - Error Interrupt flag for DMA channel 32.
 *  0b0..The Error Interrupt is not active for DMA channel 32.
 *  0b1..The Error Interrupt is pending for DMA channel 32.
 */
#define DMA_COMMON_ERRINT1_ERR32(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT1_ERR32_SHIFT)) & DMA_COMMON_ERRINT1_ERR32_MASK)

#define DMA_COMMON_ERRINT1_ERR63_33_MASK         (0xFFFFFFFEU)
#define DMA_COMMON_ERRINT1_ERR63_33_SHIFT        (1U)
/*! ERR63_33 - Additional error Interrupt flags for remaining DMA channels in the range 63 to 33.
 *    Any bits above the actually implemented channels are reserved.
 *  0b0000000000000000000000000000000..The Error Interrupt is not active for the relevant DMA channel.
 *  0b0000000000000000000000000000001..The Error Interrupt is pending for the relevant DMA channel.
 */
#define DMA_COMMON_ERRINT1_ERR63_33(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT1_ERR63_33_SHIFT)) & DMA_COMMON_ERRINT1_ERR63_33_MASK)
/*! @} */

/* The count of DMA_COMMON_ERRINT1 */
#define DMA_COMMON_ERRINT1_COUNT                 (1U)

/*! @name COMMON_INTENSET - Interrupt Enable read and Set for all DMA channels. */
/*! @{ */

#define DMA_COMMON_INTENSET_INTEN_MASK           (0xFFFFFFFFU)
#define DMA_COMMON_INTENSET_INTEN_SHIFT          (0U)
/*! INTEN - Interrupt Enable read and set for DMA channel 0.
 *  0b00000000000000000000000000000000..The Interrupt for DMA channel 0 is disabled.
 *  0b00000000000000000000000000000001..The Interrupt for DMA channel 0 is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN_SHIFT)) & DMA_COMMON_INTENSET_INTEN_MASK)
/*! @} */

/* The count of DMA_COMMON_INTENSET */
#define DMA_COMMON_INTENSET_COUNT                (1U)

/*! @name COMMON_INTENSET1 - Interrupt Enable read and Set for all DMA channels. */
/*! @{ */

#define DMA_COMMON_INTENSET1_INTEN32_MASK        (0x1U)
#define DMA_COMMON_INTENSET1_INTEN32_SHIFT       (0U)
/*! INTEN32 - Interrupt Enable read and set for DMA channel 32.
 *  0b0..The Interrupt for DMA channel 32 is disabled.
 *  0b1..The Interrupt for DMA channel 32 is enabled.
 */
#define DMA_COMMON_INTENSET1_INTEN32(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET1_INTEN32_SHIFT)) & DMA_COMMON_INTENSET1_INTEN32_MASK)

#define DMA_COMMON_INTENSET1_INTEN63_33_MASK     (0xFFFFFFFEU)
#define DMA_COMMON_INTENSET1_INTEN63_33_SHIFT    (1U)
/*! INTEN63_33 - Additional Interrupt Enable read and set bits for remaining DMA channels in the
 *    range 63 to 33. Any bits above the actually implemented channels are reserved.
 *  0b0000000000000000000000000000000..The Interrupt for the relevant DMA channel is disabled.
 *  0b0000000000000000000000000000001..The Interrupt for the relevant DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET1_INTEN63_33(x)       (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET1_INTEN63_33_SHIFT)) & DMA_COMMON_INTENSET1_INTEN63_33_MASK)
/*! @} */

/* The count of DMA_COMMON_INTENSET1 */
#define DMA_COMMON_INTENSET1_COUNT               (1U)

/*! @name COMMON_INTENCLR - Interrupt Enable Clear for all DMA channels. */
/*! @{ */

#define DMA_COMMON_INTENCLR_CLR_MASK             (0xFFFFFFFFU)
#define DMA_COMMON_INTENCLR_CLR_SHIFT            (0U)
/*! CLR - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR_SHIFT)) & DMA_COMMON_INTENCLR_CLR_MASK)
/*! @} */

/* The count of DMA_COMMON_INTENCLR */
#define DMA_COMMON_INTENCLR_COUNT                (1U)

/*! @name COMMON_INTENCLR1 - Interrupt Enable Clear for all DMA channels. */
/*! @{ */

#define DMA_COMMON_INTENCLR1_CLR_MASK            (0xFFFFFFFFU)
#define DMA_COMMON_INTENCLR1_CLR_SHIFT           (0U)
/*! CLR - Writing ones to this register clears corresponding bits in the DMAIntEnSet1.
 */
#define DMA_COMMON_INTENCLR1_CLR(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR1_CLR_SHIFT)) & DMA_COMMON_INTENCLR1_CLR_MASK)
/*! @} */

/* The count of DMA_COMMON_INTENCLR1 */
#define DMA_COMMON_INTENCLR1_COUNT               (1U)

/*! @name COMMON_INTA - Interrupt A status for all DMA channels. */
/*! @{ */

#define DMA_COMMON_INTA_IA_MASK                  (0xFFFFFFFFU)
#define DMA_COMMON_INTA_IA_SHIFT                 (0U)
/*! IA - Interrupt A status for DMA channel 0.
 *  0b00000000000000000000000000000000..The DMAchannel 0 interrupt A is not active.
 *  0b00000000000000000000000000000001..The DMAchannel 0 interrupt A is active.
 */
#define DMA_COMMON_INTA_IA(x)                    (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_IA_SHIFT)) & DMA_COMMON_INTA_IA_MASK)
/*! @} */

/* The count of DMA_COMMON_INTA */
#define DMA_COMMON_INTA_COUNT                    (1U)

/*! @name COMMON_INTA1 - Interrupt A status for all DMA channels. */
/*! @{ */

#define DMA_COMMON_INTA1_INTA32_MASK             (0x1U)
#define DMA_COMMON_INTA1_INTA32_SHIFT            (0U)
/*! INTA32 - Interrupt A status for DMA channel 32.
 *  0b0..The DMAchannel 32 interrupt A is not active.
 *  0b1..The DMAchannel 0 interrupt A is active.
 */
#define DMA_COMMON_INTA1_INTA32(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA1_INTA32_SHIFT)) & DMA_COMMON_INTA1_INTA32_MASK)

#define DMA_COMMON_INTA1_INTA63_33_MASK          (0xFFFFFFFEU)
#define DMA_COMMON_INTA1_INTA63_33_SHIFT         (1U)
/*! INTA63_33 - Additional Interrupt A status bits for remaining DMA channels in the range 63 to 33.
 *    Any bits above the actually implemented channels are reserved.
 *  0b0000000000000000000000000000000..Interrupt A is not active for the relevant DMA channel.
 *  0b0000000000000000000000000000001..Interrupt A is active for the relevant DMA channel.
 */
#define DMA_COMMON_INTA1_INTA63_33(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA1_INTA63_33_SHIFT)) & DMA_COMMON_INTA1_INTA63_33_MASK)
/*! @} */

/* The count of DMA_COMMON_INTA1 */
#define DMA_COMMON_INTA1_COUNT                   (1U)

/*! @name COMMON_INTB - Interrupt B status for all DMA channels. */
/*! @{ */

#define DMA_COMMON_INTB_IB_MASK                  (0xFFFFFFFFU)
#define DMA_COMMON_INTB_IB_SHIFT                 (0U)
/*! IB - Interrupt B status for DMA channel 0.
 *  0b00000000000000000000000000000000..The DMAchannel 0 interrupt B is not active.
 *  0b00000000000000000000000000000001..The DMAchannel 0 interrupt B is active.
 */
#define DMA_COMMON_INTB_IB(x)                    (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_IB_SHIFT)) & DMA_COMMON_INTB_IB_MASK)
/*! @} */

/* The count of DMA_COMMON_INTB */
#define DMA_COMMON_INTB_COUNT                    (1U)

/*! @name COMMON_INTB1 - Interrupt B status for all DMA channels. */
/*! @{ */

#define DMA_COMMON_INTB1_INTB32_MASK             (0x1U)
#define DMA_COMMON_INTB1_INTB32_SHIFT            (0U)
/*! INTB32 - Interrupt B status for DMA channel 32.
 *  0b0..The DMAchannel 32 interrupt B is not active.
 *  0b1..The DMAchannel 32 interrupt B is active.
 */
#define DMA_COMMON_INTB1_INTB32(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB1_INTB32_SHIFT)) & DMA_COMMON_INTB1_INTB32_MASK)

#define DMA_COMMON_INTB1_INTB63_33_MASK          (0xFFFFFFFEU)
#define DMA_COMMON_INTB1_INTB63_33_SHIFT         (1U)
/*! INTB63_33 - Additional Interrupt B status bits for remaining DMA channels in the range 63 to 33.
 *    Any bits above the actually implemented channels are reserved.
 *  0b0000000000000000000000000000000..Interrupt B is not active for the relevant DMA channel.
 *  0b0000000000000000000000000000001..Interrupt B is active for the relevant DMA channel.
 */
#define DMA_COMMON_INTB1_INTB63_33(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB1_INTB63_33_SHIFT)) & DMA_COMMON_INTB1_INTB63_33_MASK)
/*! @} */

/* The count of DMA_COMMON_INTB1 */
#define DMA_COMMON_INTB1_COUNT                   (1U)

/*! @name COMMON_SETVALID - Set ValidPending control bits for all DMA channels. */
/*! @{ */

#define DMA_COMMON_SETVALID_SV_MASK              (0xFFFFFFFFU)
#define DMA_COMMON_SETVALID_SV_SHIFT             (0U)
/*! SV - SetValid control for DMA channel 0.
 *  0b00000000000000000000000000000000..No effect.
 *  0b00000000000000000000000000000001..Sets the ValidPending control bit for DMA channel 0.
 */
#define DMA_COMMON_SETVALID_SV(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SV_SHIFT)) & DMA_COMMON_SETVALID_SV_MASK)
/*! @} */

/* The count of DMA_COMMON_SETVALID */
#define DMA_COMMON_SETVALID_COUNT                (1U)

/*! @name COMMON_SETVALID1 - Set ValidPending control bits for all DMA channels. */
/*! @{ */

#define DMA_COMMON_SETVALID1_SETVALID32_MASK     (0x1U)
#define DMA_COMMON_SETVALID1_SETVALID32_SHIFT    (0U)
/*! SETVALID32 - SetValid control for DMA channel 32.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel 32.
 */
#define DMA_COMMON_SETVALID1_SETVALID32(x)       (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID1_SETVALID32_SHIFT)) & DMA_COMMON_SETVALID1_SETVALID32_MASK)

#define DMA_COMMON_SETVALID1_SETVALID63_33_MASK  (0xFFFFFFFEU)
#define DMA_COMMON_SETVALID1_SETVALID63_33_SHIFT (1U)
/*! SETVALID63_33 - Additional SetValid controls for remaining DMA channels in the range 63 to 33.
 *    Any bits above the actually implemented channels are reserved.
 *  0b0000000000000000000000000000000..No effect.
 *  0b0000000000000000000000000000001..Sets the ValidPending control bit for the relevant DMA channel.
 */
#define DMA_COMMON_SETVALID1_SETVALID63_33(x)    (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID1_SETVALID63_33_SHIFT)) & DMA_COMMON_SETVALID1_SETVALID63_33_MASK)
/*! @} */

/* The count of DMA_COMMON_SETVALID1 */
#define DMA_COMMON_SETVALID1_COUNT               (1U)

/*! @name COMMON_SETTRIG - Set Trigger control bits for all DMA channels. */
/*! @{ */

#define DMA_COMMON_SETTRIG_TRIG_MASK             (0xFFFFFFFFU)
#define DMA_COMMON_SETTRIG_TRIG_SHIFT            (0U)
/*! TRIG - Set Trigger control bit for DMA channel 0.
 *  0b00000000000000000000000000000000..No effect.
 *  0b00000000000000000000000000000001..Sets the Trig bit for DMA channel 0.
 */
#define DMA_COMMON_SETTRIG_TRIG(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_TRIG_SHIFT)) & DMA_COMMON_SETTRIG_TRIG_MASK)
/*! @} */

/* The count of DMA_COMMON_SETTRIG */
#define DMA_COMMON_SETTRIG_COUNT                 (1U)

/*! @name COMMON_SETTRIG1 - Set Trigger control bits for all DMA channels. */
/*! @{ */

#define DMA_COMMON_SETTRIG1_SETTRIG32_MASK       (0x1U)
#define DMA_COMMON_SETTRIG1_SETTRIG32_SHIFT      (0U)
/*! SETTRIG32 - Set Trigger control bit for DMA channel 32.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel 32.
 */
#define DMA_COMMON_SETTRIG1_SETTRIG32(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG1_SETTRIG32_SHIFT)) & DMA_COMMON_SETTRIG1_SETTRIG32_MASK)

#define DMA_COMMON_SETTRIG1_SETTRIG63_33_MASK    (0xFFFFFFFEU)
#define DMA_COMMON_SETTRIG1_SETTRIG63_33_SHIFT   (1U)
/*! SETTRIG63_33 - Additional Set Trigger control bits for remaining DMA channels in the range 63 to
 *    33. Any bits above the actually implemented channels are reserved.
 *  0b0000000000000000000000000000000..No effect.
 *  0b0000000000000000000000000000001..Sets the Trig bit for DMA channel for the relevant DMA channel.
 */
#define DMA_COMMON_SETTRIG1_SETTRIG63_33(x)      (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG1_SETTRIG63_33_SHIFT)) & DMA_COMMON_SETTRIG1_SETTRIG63_33_MASK)
/*! @} */

/* The count of DMA_COMMON_SETTRIG1 */
#define DMA_COMMON_SETTRIG1_COUNT                (1U)

/*! @name COMMON_ABORT - Channel Abort control for all DMA channels. */
/*! @{ */

#define DMA_COMMON_ABORT_ABORTCTRL_MASK          (0xFFFFFFFFU)
#define DMA_COMMON_ABORT_ABORTCTRL_SHIFT         (0U)
/*! ABORTCTRL - Abort control for DMA channel 0.
 *  0b00000000000000000000000000000000..No effect.
 *  0b00000000000000000000000000000001..Aborts DMA operations on channel 0.
 */
#define DMA_COMMON_ABORT_ABORTCTRL(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORTCTRL_SHIFT)) & DMA_COMMON_ABORT_ABORTCTRL_MASK)
/*! @} */

/* The count of DMA_COMMON_ABORT */
#define DMA_COMMON_ABORT_COUNT                   (1U)

/*! @name COMMON_ABORT1 - Channel Abort control for all DMA channels. */
/*! @{ */

#define DMA_COMMON_ABORT1_ABORT32_MASK           (0x1U)
#define DMA_COMMON_ABORT1_ABORT32_SHIFT          (0U)
/*! ABORT32 - Abort control for DMA channel 32.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel 32.
 */
#define DMA_COMMON_ABORT1_ABORT32(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT1_ABORT32_SHIFT)) & DMA_COMMON_ABORT1_ABORT32_MASK)

#define DMA_COMMON_ABORT1_ABORT63_33_MASK        (0xFFFFFFFEU)
#define DMA_COMMON_ABORT1_ABORT63_33_SHIFT       (1U)
/*! ABORT63_33 - Additional Abort controls for remaining DMA channels in the range 63 to 33. Any
 *    bits above the actually implemented channels are reserved.
 *  0b0000000000000000000000000000000..No effect.
 *  0b0000000000000000000000000000001..Aborts DMA operations on the relevant channel.
 */
#define DMA_COMMON_ABORT1_ABORT63_33(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT1_ABORT63_33_SHIFT)) & DMA_COMMON_ABORT1_ABORT63_33_MASK)
/*! @} */

/* The count of DMA_COMMON_ABORT1 */
#define DMA_COMMON_ABORT1_COUNT                  (1U)

/*! @name CHANNEL_CFG - Configuration register for DMA channel . */
/*! @{ */

#define DMA_CHANNEL_CFG_PERIPHREQEN_MASK         (0x1U)
#define DMA_CHANNEL_CFG_PERIPHREQEN_SHIFT        (0U)
/*! PERIPHREQEN - Peripheral request Enable. If a DMA channel is used to perform a memory-to-memory
 *    move, any peripheral DMA request associated with that channel can be disabled to prevent any
 *    interaction between the peripheral and the DMA controller.
 *  0b0..Disabled. Peripheral DMA requests are disabled.
 *  0b1..Enabled. Peripheral DMA requests are enabled.
 */
#define DMA_CHANNEL_CFG_PERIPHREQEN(x)           (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_CFG_PERIPHREQEN_SHIFT)) & DMA_CHANNEL_CFG_PERIPHREQEN_MASK)

#define DMA_CHANNEL_CFG_HWTRIGEN_MASK            (0x2U)
#define DMA_CHANNEL_CFG_HWTRIGEN_SHIFT           (1U)
/*! HWTRIGEN - Hardware Triggering Enable for this channel.
 *  0b0..Disabled. Hardware triggering is not used.
 *  0b1..Enabled. Use hardware triggering.
 */
#define DMA_CHANNEL_CFG_HWTRIGEN(x)              (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_CFG_HWTRIGEN_SHIFT)) & DMA_CHANNEL_CFG_HWTRIGEN_MASK)

#define DMA_CHANNEL_CFG_TRIGPOL_MASK             (0x10U)
#define DMA_CHANNEL_CFG_TRIGPOL_SHIFT            (4U)
/*! TRIGPOL - Trigger Polarity. Selects the polarity of a hardware trigger for this channel.
 *  0b0..Active low - falling edge. Hardware trigger is active low or falling edge triggered, based on TRIGTYPE.
 *  0b1..Active high - rising edge. Hardware trigger is active high or rising edge triggered, based on TRIGTYPE.
 */
#define DMA_CHANNEL_CFG_TRIGPOL(x)               (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_CFG_TRIGPOL_SHIFT)) & DMA_CHANNEL_CFG_TRIGPOL_MASK)

#define DMA_CHANNEL_CFG_TRIGTYPE_MASK            (0x20U)
#define DMA_CHANNEL_CFG_TRIGTYPE_SHIFT           (5U)
/*! TRIGTYPE - Trigger Type. Selects hardware trigger as edge triggered or level triggered.
 *  0b0..Edge. Hardware trigger is edge triggered. Transfers will be initiated and completed, as specified for a single trigger.
 *  0b1..Level. Hardware trigger is level triggered. Note that when level triggering without burst (BURSTPOWER =
 *       0) is selected, only hardware triggers should be used on that channel. Transfers continue as long as the
 *       trigger level is asserted. Once the trigger is de-asserted, the transfer will be paused until the trigger
 *       is, again, asserted. However, the transfer will not be paused until any remaining transfers within the
 *       current BURSTPOWER length are completed.
 */
#define DMA_CHANNEL_CFG_TRIGTYPE(x)              (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_CFG_TRIGTYPE_SHIFT)) & DMA_CHANNEL_CFG_TRIGTYPE_MASK)

#define DMA_CHANNEL_CFG_TRIGBURST_MASK           (0x40U)
#define DMA_CHANNEL_CFG_TRIGBURST_SHIFT          (6U)
/*! TRIGBURST - Trigger Burst. Selects whether hardware triggers cause a single or burst transfer.
 *  0b0..Single transfer. Hardware trigger causes a single transfer.
 *  0b1..Burst transfer. When the trigger for this channel is set to edge triggered, a hardware trigger causes a
 *       burst transfer, as defined by BURSTPOWER. When the trigger for this channel is set to level triggered, a
 *       hardware trigger causes transfers to continue as long as the trigger is asserted, unless the transfer is
 *       complete.
 */
#define DMA_CHANNEL_CFG_TRIGBURST(x)             (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_CFG_TRIGBURST_SHIFT)) & DMA_CHANNEL_CFG_TRIGBURST_MASK)

#define DMA_CHANNEL_CFG_BURSTPOWER_MASK          (0xF00U)
#define DMA_CHANNEL_CFG_BURSTPOWER_SHIFT         (8U)
/*! BURSTPOWER - Burst Power is used in two ways. It always selects the address wrap size when
 *    SRCBURSTWRAP and/or DSTBURSTWRAP modes are selected (see descriptions elsewhere in this register).
 *    When the TRIGBURST field elsewhere in this register = 1, Burst Power selects how many
 *    transfers are performed for each DMA trigger. This can be used, for example, with peripherals that
 *    contain a FIFO that can initiate a DMA operation when the FIFO reaches a certain level. 0000:
 *    Burst size = 1 (20). 0001: Burst size = 2 (21). 0010: Burst size = 4 (22). 1010: Burst size =
 *    1024 (210). This corresponds to the maximum supported transfer count. others: not supported. The
 *    total transfer length as defined in the XFERCOUNT bits in the XFERCFG register must be an even
 *    multiple of the burst size.
 */
#define DMA_CHANNEL_CFG_BURSTPOWER(x)            (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_CFG_BURSTPOWER_SHIFT)) & DMA_CHANNEL_CFG_BURSTPOWER_MASK)

#define DMA_CHANNEL_CFG_SRCBURSTWRAP_MASK        (0x4000U)
#define DMA_CHANNEL_CFG_SRCBURSTWRAP_SHIFT       (14U)
/*! SRCBURSTWRAP - Source Burst Wrap. When enabled, the source data address for the DMA is
 *    'wrapped', meaning that the source address range for each burst will be the same. As an example, this
 *    could be used to read several sequential registers from a peripheral for each DMA burst,
 *    reading the same registers again for each burst.
 *  0b0..Disabled. Source burst wrapping is not enabled for this DMA channel.
 *  0b1..Enabled. Source burst wrapping is enabled for this DMA channel.
 */
#define DMA_CHANNEL_CFG_SRCBURSTWRAP(x)          (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_CFG_SRCBURSTWRAP_SHIFT)) & DMA_CHANNEL_CFG_SRCBURSTWRAP_MASK)

#define DMA_CHANNEL_CFG_DSTBURSTWRAP_MASK        (0x8000U)
#define DMA_CHANNEL_CFG_DSTBURSTWRAP_SHIFT       (15U)
/*! DSTBURSTWRAP - Destination Burst Wrap. When enabled, the destination data address for the DMA is
 *    'wrapped', meaning that the destination address range for each burst will be the same. As an
 *    example, this could be used to write several sequential registers to a peripheral for each DMA
 *    burst, writing the same registers again for each burst.
 *  0b0..Disabled. Destination burst wrapping is not enabled for this DMA channel.
 *  0b1..Enabled. Destination burst wrapping is enabled for this DMA channel.
 */
#define DMA_CHANNEL_CFG_DSTBURSTWRAP(x)          (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_CFG_DSTBURSTWRAP_SHIFT)) & DMA_CHANNEL_CFG_DSTBURSTWRAP_MASK)

#define DMA_CHANNEL_CFG_CHPRIORITY_MASK          (0x70000U)
#define DMA_CHANNEL_CFG_CHPRIORITY_SHIFT         (16U)
/*! CHPRIORITY - Priority of this channel when multiple DMA requests are pending. Eight priority
 *    levels are supported: 0x0 = highest priority. 0x7 = lowest priority.
 */
#define DMA_CHANNEL_CFG_CHPRIORITY(x)            (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_CFG_CHPRIORITY_SHIFT)) & DMA_CHANNEL_CFG_CHPRIORITY_MASK)
/*! @} */

/* The count of DMA_CHANNEL_CFG */
#define DMA_CHANNEL_CFG_COUNT                    (33U)

/*! @name CHANNEL_CTLSTAT - Control and status register for DMA channel . */
/*! @{ */

#define DMA_CHANNEL_CTLSTAT_VALIDPENDING_MASK    (0x1U)
#define DMA_CHANNEL_CTLSTAT_VALIDPENDING_SHIFT   (0U)
/*! VALIDPENDING - Valid pending flag for this channel. This bit is set when a 1 is written to the
 *    corresponding bit in the related SETVALID register when CFGVALID = 1 for the same channel.
 *  0b0..No effect. No effect on DMA operation.
 *  0b1..Valid pending.
 */
#define DMA_CHANNEL_CTLSTAT_VALIDPENDING(x)      (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_CTLSTAT_VALIDPENDING_SHIFT)) & DMA_CHANNEL_CTLSTAT_VALIDPENDING_MASK)

#define DMA_CHANNEL_CTLSTAT_TRIG_MASK            (0x4U)
#define DMA_CHANNEL_CTLSTAT_TRIG_SHIFT           (2U)
/*! TRIG - Trigger flag. Indicates that the trigger for this channel is currently set. This bit is
 *    cleared at the end of an entire transfer or upon reload when CLRTRIG = 1.
 *  0b0..Not triggered. The trigger for this DMA channel is not set. DMA operations will not be carried out.
 *  0b1..Triggered. The trigger for this DMA channel is set. DMA operations will be carried out.
 */
#define DMA_CHANNEL_CTLSTAT_TRIG(x)              (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_CTLSTAT_TRIG_SHIFT)) & DMA_CHANNEL_CTLSTAT_TRIG_MASK)
/*! @} */

/* The count of DMA_CHANNEL_CTLSTAT */
#define DMA_CHANNEL_CTLSTAT_COUNT                (33U)

/*! @name CHANNEL_XFERCFG - Transfer configuration register for DMA channel . */
/*! @{ */

#define DMA_CHANNEL_XFERCFG_CFGVALID_MASK        (0x1U)
#define DMA_CHANNEL_XFERCFG_CFGVALID_SHIFT       (0U)
/*! CFGVALID - Configuration Valid flag. This bit indicates whether the current channel descriptor
 *    is valid and can potentially be acted upon, if all other activation criteria are fulfilled.
 *  0b0..Not valid. The channel descriptor is not considered valid until validated by an associated SETVALID0 setting.
 *  0b1..Valid. The current channel descriptor is considered valid.
 */
#define DMA_CHANNEL_XFERCFG_CFGVALID(x)          (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_XFERCFG_CFGVALID_SHIFT)) & DMA_CHANNEL_XFERCFG_CFGVALID_MASK)

#define DMA_CHANNEL_XFERCFG_RELOAD_MASK          (0x2U)
#define DMA_CHANNEL_XFERCFG_RELOAD_SHIFT         (1U)
/*! RELOAD - Indicates whether the channel's control structure will be reloaded when the current
 *    descriptor is exhausted. Reloading allows ping-pong and linked transfers.
 *  0b0..Disabled. Do not reload the channels' control structure when the current descriptor is exhausted.
 *  0b1..Enabled. Reload the channels' control structure when the current descriptor is exhausted.
 */
#define DMA_CHANNEL_XFERCFG_RELOAD(x)            (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_XFERCFG_RELOAD_SHIFT)) & DMA_CHANNEL_XFERCFG_RELOAD_MASK)

#define DMA_CHANNEL_XFERCFG_SWTRIG_MASK          (0x4U)
#define DMA_CHANNEL_XFERCFG_SWTRIG_SHIFT         (2U)
/*! SWTRIG - Software Trigger.
 *  0b0..Not set. When written by software, the trigger for this channel is not set. A new trigger, as defined by
 *       the HWTRIGEN, TRIGPOL, and TRIGTYPE will be needed to start the channel.
 *  0b1..Set. When written by software, the trigger for this channel is set immediately. This feature should not
 *       be used with level triggering when TRIGBURST = 0.
 */
#define DMA_CHANNEL_XFERCFG_SWTRIG(x)            (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_XFERCFG_SWTRIG_SHIFT)) & DMA_CHANNEL_XFERCFG_SWTRIG_MASK)

#define DMA_CHANNEL_XFERCFG_CLRTRIG_MASK         (0x8U)
#define DMA_CHANNEL_XFERCFG_CLRTRIG_SHIFT        (3U)
/*! CLRTRIG - Clear Trigger.
 *  0b0..Not cleared. The trigger is not cleared when this descriptor is exhausted. If there is a reload, the next descriptor will be started.
 *  0b1..Cleared. The trigger is cleared when this descriptor is exhausted
 */
#define DMA_CHANNEL_XFERCFG_CLRTRIG(x)           (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_XFERCFG_CLRTRIG_SHIFT)) & DMA_CHANNEL_XFERCFG_CLRTRIG_MASK)

#define DMA_CHANNEL_XFERCFG_SETINTA_MASK         (0x10U)
#define DMA_CHANNEL_XFERCFG_SETINTA_SHIFT        (4U)
/*! SETINTA - Set Interrupt flag A for this channel. There is no hardware distinction between
 *    interrupt A and B. They can be used by software to assist with more complex descriptor usage. By
 *    convention, interrupt A may be used when only one interrupt flag is needed.
 *  0b0..No effect.
 *  0b1..Set. The INTA flag for this channel will be set when the current descriptor is exhausted.
 */
#define DMA_CHANNEL_XFERCFG_SETINTA(x)           (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_XFERCFG_SETINTA_SHIFT)) & DMA_CHANNEL_XFERCFG_SETINTA_MASK)

#define DMA_CHANNEL_XFERCFG_SETINTB_MASK         (0x20U)
#define DMA_CHANNEL_XFERCFG_SETINTB_SHIFT        (5U)
/*! SETINTB - Set Interrupt flag B for this channel. There is no hardware distinction between
 *    interrupt A and B. They can be used by software to assist with more complex descriptor usage. By
 *    convention, interrupt A may be used when only one interrupt flag is needed.
 *  0b0..No effect.
 *  0b1..Set. The INTB flag for this channel will be set when the current descriptor is exhausted.
 */
#define DMA_CHANNEL_XFERCFG_SETINTB(x)           (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_XFERCFG_SETINTB_SHIFT)) & DMA_CHANNEL_XFERCFG_SETINTB_MASK)

#define DMA_CHANNEL_XFERCFG_WIDTH_MASK           (0x300U)
#define DMA_CHANNEL_XFERCFG_WIDTH_SHIFT          (8U)
/*! WIDTH - Transfer width used for this DMA channel.
 *  0b00..8-bit. 8-bit transfers are performed (8-bit source reads and destination writes).
 *  0b01..16-bit. 6-bit transfers are performed (16-bit source reads and destination writes).
 *  0b10..32-bit. 32-bit transfers are performed (32-bit source reads and destination writes).
 *  0b11..Reserved. Reserved setting, do not use.
 */
#define DMA_CHANNEL_XFERCFG_WIDTH(x)             (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_XFERCFG_WIDTH_SHIFT)) & DMA_CHANNEL_XFERCFG_WIDTH_MASK)

#define DMA_CHANNEL_XFERCFG_SRCINC_MASK          (0x3000U)
#define DMA_CHANNEL_XFERCFG_SRCINC_SHIFT         (12U)
/*! SRCINC - Determines whether the source address is incremented for each DMA transfer.
 *  0b00..No increment. The source address is not incremented for each transfer. This is the usual case when the source is a peripheral device.
 *  0b01..1 x width. The source address is incremented by the amount specified by Width for each transfer. This is
 *        the usual case when the source is memory.
 *  0b10..2 x width. The source address is incremented by 2 times the amount specified by Width for each transfer.
 *  0b11..4 x width. The source address is incremented by 4 times the amount specified by Width for each transfer.
 */
#define DMA_CHANNEL_XFERCFG_SRCINC(x)            (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_XFERCFG_SRCINC_SHIFT)) & DMA_CHANNEL_XFERCFG_SRCINC_MASK)

#define DMA_CHANNEL_XFERCFG_DSTINC_MASK          (0xC000U)
#define DMA_CHANNEL_XFERCFG_DSTINC_SHIFT         (14U)
/*! DSTINC - Determines whether the destination address is incremented for each DMA transfer.
 *  0b00..No increment. The destination address is not incremented for each transfer. This is the usual case when
 *        the destination is a peripheral device.
 *  0b01..1 x width. The destination address is incremented by the amount specified by Width for each transfer.
 *        This is the usual case when the destination is memory.
 *  0b10..2 x width. The destination address is incremented by 2 times the amount specified by Width for each transfer.
 *  0b11..4 x width. The destination address is incremented by 4 times the amount specified by Width for each transfer.
 */
#define DMA_CHANNEL_XFERCFG_DSTINC(x)            (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_XFERCFG_DSTINC_SHIFT)) & DMA_CHANNEL_XFERCFG_DSTINC_MASK)

#define DMA_CHANNEL_XFERCFG_XFERCOUNT_MASK       (0x3FF0000U)
#define DMA_CHANNEL_XFERCFG_XFERCOUNT_SHIFT      (16U)
/*! XFERCOUNT - Total number of transfers to be performed, minus 1 encoded. The number of bytes
 *    transferred is: (XFERCOUNT + 1) x data width (as defined by the WIDTH field). The DMA controller
 *    uses this bit field during transfer to count down. Hence, it cannot be used by software to read
 *    back the size of the transfer, for instance, in an interrupt handler. 0x0 = a total of 1
 *    transfer will be performed. 0x1 = a total of 2 transfers will be performed. 0x3FF = a total of
 *    1,024 transfers will be performed.
 */
#define DMA_CHANNEL_XFERCFG_XFERCOUNT(x)         (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_XFERCFG_XFERCOUNT_SHIFT)) & DMA_CHANNEL_XFERCFG_XFERCOUNT_MASK)
/*! @} */

/* The count of DMA_CHANNEL_XFERCFG */
#define DMA_CHANNEL_XFERCFG_COUNT                (33U)


/*!
 * @}
 */ /* end of group DMA_Register_Masks */


/* DMA - Peripheral instance base addresses */
/** Peripheral DMA0 base address */
#define DMA0_BASE                                (0x40104000u)
/** Peripheral DMA0 base pointer */
#define DMA0                                     ((DMA_Type *)DMA0_BASE)
/** Peripheral DMA1 base address */
#define DMA1_BASE                                (0x40105000u)
/** Peripheral DMA1 base pointer */
#define DMA1                                     ((DMA_Type *)DMA1_BASE)
/** Array initializer of DMA peripheral base addresses */
#define DMA_BASE_ADDRS                           { DMA0_BASE, DMA1_BASE }
/** Array initializer of DMA peripheral base pointers */
#define DMA_BASE_PTRS                            { DMA0, DMA1 }
/** Interrupt vectors for the DMA peripheral type */
#define DMA_IRQS                                 { DMA0_IRQn, DMA1_IRQn }

/*!
 * @}
 */ /* end of group DMA_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- DMIC Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DMIC_Peripheral_Access_Layer DMIC Peripheral Access Layer
 * @{
 */

/** DMIC - Register Layout Typedef */
typedef struct {
  struct {                                         /* offset: 0x0, array step: 0x100 */
    __IO uint32_t OSR;                               /**< CIC Filter decimation rate, array offset: 0x0, array step: 0x100 */
    __IO uint32_t DIVHFCLK;                          /**< Divider for generating PDM clock from DMIC clock input, array offset: 0x4, array step: 0x100 */
    __IO uint32_t PREAC2FSCOEF;                      /**< Compensation filter for 2FS, array offset: 0x8, array step: 0x100 */
    __IO uint32_t PREAC4FSCOEF;                      /**< Compensation filter for 4FS, array offset: 0xC, array step: 0x100 */
    __IO uint32_t GAINSHIFT;                         /**< Decimator output gain adjustment, array offset: 0x10, array step: 0x100 */
         uint8_t RESERVED_0[108];
    __IO uint32_t FIFO_CTRL;                         /**< FIFO Control, array offset: 0x80, array step: 0x100 */
    __IO uint32_t FIFO_STATUS;                       /**< FIFO Status, array offset: 0x84, array step: 0x100 */
    __I  uint32_t FIFO_DATA;                         /**< FIFO Data, array offset: 0x88, array step: 0x100 */
    __IO uint32_t PHY_CTRL;                          /**< Phy Ctrl, array offset: 0x8C, array step: 0x100 */
    __IO uint32_t DC_CTRL;                           /**< DC Filter Control, array offset: 0x90, array step: 0x100 */
         uint8_t RESERVED_1[108];
  } CHANNEL[8];
       uint8_t RESERVED_0[1792];
  __IO uint32_t CHANEN;                            /**< Channel Enable register, offset: 0xF00 */
       uint8_t RESERVED_1[12];
  __IO uint32_t USE2FS;                            /**< Use 2FS register, offset: 0xF10 */
  __IO uint32_t GLOBAL_SYNC_EN;                    /**< global sync enable, offset: 0xF14 */
  __IO uint32_t GLOBAL_COUNT_VAL;                  /**< , offset: 0xF18 */
  __IO uint32_t DECRESET;                          /**< , offset: 0xF1C */
       uint8_t RESERVED_2[96];
  __IO uint32_t HWVADGAIN;                         /**< HWVAD input gain register, offset: 0xF80 */
  __IO uint32_t HWVADHPFS;                         /**< HWVAD filter control register, offset: 0xF84 */
  __IO uint32_t HWVADST10;                         /**< HWVAD control register, offset: 0xF88 */
  __IO uint32_t HWVADRSTT;                         /**< HWVAD filter reset register, offset: 0xF8C */
  __IO uint32_t HWVADTHGN;                         /**< HWVAD noise estimator gain register, offset: 0xF90 */
  __IO uint32_t HWVADTHGS;                         /**< HWVAD signal estimator gain register, offset: 0xF94 */
  __I  uint32_t HWVADLOWZ;                         /**< HWVAD noise envelope estimator register, offset: 0xF98 */
} DMIC_Type;

/* ----------------------------------------------------------------------------
   -- DMIC Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DMIC_Register_Masks DMIC Register Masks
 * @{
 */

/*! @name CHANNEL_OSR - CIC Filter decimation rate */
/*! @{ */

#define DMIC_CHANNEL_OSR_OSR_MASK                (0xFFU)
#define DMIC_CHANNEL_OSR_OSR_SHIFT               (0U)
/*! OSR - Selects the oversample rate for the related input channel.
 */
#define DMIC_CHANNEL_OSR_OSR(x)                  (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_OSR_OSR_SHIFT)) & DMIC_CHANNEL_OSR_OSR_MASK)
/*! @} */

/* The count of DMIC_CHANNEL_OSR */
#define DMIC_CHANNEL_OSR_COUNT                   (8U)

/*! @name CHANNEL_DIVHFCLK - Divider for generating PDM clock from DMIC clock input */
/*! @{ */

#define DMIC_CHANNEL_DIVHFCLK_PDMDIV_MASK        (0xFU)
#define DMIC_CHANNEL_DIVHFCLK_PDMDIV_SHIFT       (0U)
/*! PDMDIV - Divide by factor to create PDM Clock (enumerated type)
 */
#define DMIC_CHANNEL_DIVHFCLK_PDMDIV(x)          (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_DIVHFCLK_PDMDIV_SHIFT)) & DMIC_CHANNEL_DIVHFCLK_PDMDIV_MASK)
/*! @} */

/* The count of DMIC_CHANNEL_DIVHFCLK */
#define DMIC_CHANNEL_DIVHFCLK_COUNT              (8U)

/*! @name CHANNEL_PREAC2FSCOEF - Compensation filter for 2FS */
/*! @{ */

#define DMIC_CHANNEL_PREAC2FSCOEF_COMP_MASK      (0x3U)
#define DMIC_CHANNEL_PREAC2FSCOEF_COMP_SHIFT     (0U)
/*! COMP - Co-efficient choice for CIC droop compensation droop filter
 */
#define DMIC_CHANNEL_PREAC2FSCOEF_COMP(x)        (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_PREAC2FSCOEF_COMP_SHIFT)) & DMIC_CHANNEL_PREAC2FSCOEF_COMP_MASK)
/*! @} */

/* The count of DMIC_CHANNEL_PREAC2FSCOEF */
#define DMIC_CHANNEL_PREAC2FSCOEF_COUNT          (8U)

/*! @name CHANNEL_PREAC4FSCOEF - Compensation filter for 4FS */
/*! @{ */

#define DMIC_CHANNEL_PREAC4FSCOEF_COMP_MASK      (0x3U)
#define DMIC_CHANNEL_PREAC4FSCOEF_COMP_SHIFT     (0U)
/*! COMP - Co-efficient choice for CIC droop compensation droop filter
 */
#define DMIC_CHANNEL_PREAC4FSCOEF_COMP(x)        (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_PREAC4FSCOEF_COMP_SHIFT)) & DMIC_CHANNEL_PREAC4FSCOEF_COMP_MASK)
/*! @} */

/* The count of DMIC_CHANNEL_PREAC4FSCOEF */
#define DMIC_CHANNEL_PREAC4FSCOEF_COUNT          (8U)

/*! @name CHANNEL_GAINSHIFT - Decimator output gain adjustment */
/*! @{ */

#define DMIC_CHANNEL_GAINSHIFT_GAIN_MASK         (0x3FU)
#define DMIC_CHANNEL_GAINSHIFT_GAIN_SHIFT        (0U)
/*! GAIN - Gain shift for decimator output (can be positive or negative number)
 */
#define DMIC_CHANNEL_GAINSHIFT_GAIN(x)           (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_GAINSHIFT_GAIN_SHIFT)) & DMIC_CHANNEL_GAINSHIFT_GAIN_MASK)
/*! @} */

/* The count of DMIC_CHANNEL_GAINSHIFT */
#define DMIC_CHANNEL_GAINSHIFT_COUNT             (8U)

/*! @name CHANNEL_FIFO_CTRL - FIFO Control */
/*! @{ */

#define DMIC_CHANNEL_FIFO_CTRL_ENABLE_MASK       (0x1U)
#define DMIC_CHANNEL_FIFO_CTRL_ENABLE_SHIFT      (0U)
/*! ENABLE - FIFO enable.
 *  0b0..FIFO is not enabled. Enabling a DMIC channel with the FIFO disabled could be useful while data is being
 *       streamed to the I2S, or in order to avoid a filter settling delay when a channel is re-enabled after a
 *       period when the data was not needed.
 *  0b1..FIFO is enabled. The FIFO must be enabled in order for the CPU or DMA to read data from the DMIC via the FIFODATA register.
 */
#define DMIC_CHANNEL_FIFO_CTRL_ENABLE(x)         (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_FIFO_CTRL_ENABLE_SHIFT)) & DMIC_CHANNEL_FIFO_CTRL_ENABLE_MASK)

#define DMIC_CHANNEL_FIFO_CTRL_RESETN_MASK       (0x2U)
#define DMIC_CHANNEL_FIFO_CTRL_RESETN_SHIFT      (1U)
/*! RESETN - FIFO reset.
 *  0b0..Reset the FIFO.
 *  0b1..Normal operation
 */
#define DMIC_CHANNEL_FIFO_CTRL_RESETN(x)         (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_FIFO_CTRL_RESETN_SHIFT)) & DMIC_CHANNEL_FIFO_CTRL_RESETN_MASK)

#define DMIC_CHANNEL_FIFO_CTRL_INTEN_MASK        (0x4U)
#define DMIC_CHANNEL_FIFO_CTRL_INTEN_SHIFT       (2U)
/*! INTEN - Interrupt enable.
 *  0b0..FIFO level interrupts are not enabled.
 *  0b1..FIFO level interrupts are enabled.
 */
#define DMIC_CHANNEL_FIFO_CTRL_INTEN(x)          (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_FIFO_CTRL_INTEN_SHIFT)) & DMIC_CHANNEL_FIFO_CTRL_INTEN_MASK)

#define DMIC_CHANNEL_FIFO_CTRL_DMAEN_MASK        (0x8U)
#define DMIC_CHANNEL_FIFO_CTRL_DMAEN_SHIFT       (3U)
/*! DMAEN - DMA enable
 *  0b0..DMA requests are not enabled.
 *  0b1..DMA requests based on FIFO level are enabled.
 */
#define DMIC_CHANNEL_FIFO_CTRL_DMAEN(x)          (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_FIFO_CTRL_DMAEN_SHIFT)) & DMIC_CHANNEL_FIFO_CTRL_DMAEN_MASK)

#define DMIC_CHANNEL_FIFO_CTRL_TRIGLVL_MASK      (0x1F0000U)
#define DMIC_CHANNEL_FIFO_CTRL_TRIGLVL_SHIFT     (16U)
/*! TRIGLVL - Trigger level for interrupt
 */
#define DMIC_CHANNEL_FIFO_CTRL_TRIGLVL(x)        (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_FIFO_CTRL_TRIGLVL_SHIFT)) & DMIC_CHANNEL_FIFO_CTRL_TRIGLVL_MASK)
/*! @} */

/* The count of DMIC_CHANNEL_FIFO_CTRL */
#define DMIC_CHANNEL_FIFO_CTRL_COUNT             (8U)

/*! @name CHANNEL_FIFO_STATUS - FIFO Status */
/*! @{ */

#define DMIC_CHANNEL_FIFO_STATUS_INT_MASK        (0x1U)
#define DMIC_CHANNEL_FIFO_STATUS_INT_SHIFT       (0U)
/*! INT - Status of Interrupt (write 1 to clear)
 */
#define DMIC_CHANNEL_FIFO_STATUS_INT(x)          (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_FIFO_STATUS_INT_SHIFT)) & DMIC_CHANNEL_FIFO_STATUS_INT_MASK)

#define DMIC_CHANNEL_FIFO_STATUS_OVERRUN_MASK    (0x2U)
#define DMIC_CHANNEL_FIFO_STATUS_OVERRUN_SHIFT   (1U)
/*! OVERRUN - Overrun Detected (write 1 to clear)
 */
#define DMIC_CHANNEL_FIFO_STATUS_OVERRUN(x)      (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_FIFO_STATUS_OVERRUN_SHIFT)) & DMIC_CHANNEL_FIFO_STATUS_OVERRUN_MASK)

#define DMIC_CHANNEL_FIFO_STATUS_UNDERRUN_MASK   (0x4U)
#define DMIC_CHANNEL_FIFO_STATUS_UNDERRUN_SHIFT  (2U)
/*! UNDERRUN - Underrun Detected (write 1 to clear)
 */
#define DMIC_CHANNEL_FIFO_STATUS_UNDERRUN(x)     (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_FIFO_STATUS_UNDERRUN_SHIFT)) & DMIC_CHANNEL_FIFO_STATUS_UNDERRUN_MASK)
/*! @} */

/* The count of DMIC_CHANNEL_FIFO_STATUS */
#define DMIC_CHANNEL_FIFO_STATUS_COUNT           (8U)

/*! @name CHANNEL_FIFO_DATA - FIFO Data */
/*! @{ */

#define DMIC_CHANNEL_FIFO_DATA_DATA_MASK         (0xFFFFFFU)
#define DMIC_CHANNEL_FIFO_DATA_DATA_SHIFT        (0U)
/*! DATA - PCM Data
 */
#define DMIC_CHANNEL_FIFO_DATA_DATA(x)           (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_FIFO_DATA_DATA_SHIFT)) & DMIC_CHANNEL_FIFO_DATA_DATA_MASK)
/*! @} */

/* The count of DMIC_CHANNEL_FIFO_DATA */
#define DMIC_CHANNEL_FIFO_DATA_COUNT             (8U)

/*! @name CHANNEL_PHY_CTRL - Phy Ctrl */
/*! @{ */

#define DMIC_CHANNEL_PHY_CTRL_PHY_FALL_MASK      (0x1U)
#define DMIC_CHANNEL_PHY_CTRL_PHY_FALL_SHIFT     (0U)
/*! PHY_FALL - Capture DMIC on Falling edge (0 means on rising)
 *  0b0..Capture PDM_DATA on the rising edge of PDM_CLK.
 *  0b1..Capture PDM_DATA on the falling edge of PDM_CLK.
 */
#define DMIC_CHANNEL_PHY_CTRL_PHY_FALL(x)        (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_PHY_CTRL_PHY_FALL_SHIFT)) & DMIC_CHANNEL_PHY_CTRL_PHY_FALL_MASK)

#define DMIC_CHANNEL_PHY_CTRL_PHY_HALF_MASK      (0x2U)
#define DMIC_CHANNEL_PHY_CTRL_PHY_HALF_SHIFT     (1U)
/*! PHY_HALF - Use Half rate sampling (ie Clock to dmic is sent at half the speed than the decimator is providing)
 *  0b0..Standard half rate sampling. The clock to the DMIC is sent at the same rate as the decimator is providing.
 *  0b1..Use half rate sampling. The clock to the DMIC is sent at half the rate as the decimator is providing.
 */
#define DMIC_CHANNEL_PHY_CTRL_PHY_HALF(x)        (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_PHY_CTRL_PHY_HALF_SHIFT)) & DMIC_CHANNEL_PHY_CTRL_PHY_HALF_MASK)
/*! @} */

/* The count of DMIC_CHANNEL_PHY_CTRL */
#define DMIC_CHANNEL_PHY_CTRL_COUNT              (8U)

/*! @name CHANNEL_DC_CTRL - DC Filter Control */
/*! @{ */

#define DMIC_CHANNEL_DC_CTRL_DCPOLE_MASK         (0x3U)
#define DMIC_CHANNEL_DC_CTRL_DCPOLE_SHIFT        (0U)
/*! DCPOLE - DC block filter
 *  0b00..Flat response, no filter.
 *  0b01..155 Hz.
 *  0b10..78 Hz.
 *  0b11..39 Hz
 */
#define DMIC_CHANNEL_DC_CTRL_DCPOLE(x)           (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_DC_CTRL_DCPOLE_SHIFT)) & DMIC_CHANNEL_DC_CTRL_DCPOLE_MASK)

#define DMIC_CHANNEL_DC_CTRL_DCGAIN_MASK         (0xF0U)
#define DMIC_CHANNEL_DC_CTRL_DCGAIN_SHIFT        (4U)
/*! DCGAIN - Fine gain adjustment in the form of a number of bits to downshift.
 */
#define DMIC_CHANNEL_DC_CTRL_DCGAIN(x)           (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_DC_CTRL_DCGAIN_SHIFT)) & DMIC_CHANNEL_DC_CTRL_DCGAIN_MASK)

#define DMIC_CHANNEL_DC_CTRL_SATURATEAT16BIT_MASK (0x100U)
#define DMIC_CHANNEL_DC_CTRL_SATURATEAT16BIT_SHIFT (8U)
/*! SATURATEAT16BIT - Selects 16-bit saturation.
 *  0b0..Results roll over if out range and do not saturate.
 *  0b1..If the result overflows, it saturates at 0xFFFF for positive overflow and 0x8000 for negative overflow.
 */
#define DMIC_CHANNEL_DC_CTRL_SATURATEAT16BIT(x)  (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_DC_CTRL_SATURATEAT16BIT_SHIFT)) & DMIC_CHANNEL_DC_CTRL_SATURATEAT16BIT_MASK)

#define DMIC_CHANNEL_DC_CTRL_SIGNEXTEND_MASK     (0x200U)
#define DMIC_CHANNEL_DC_CTRL_SIGNEXTEND_SHIFT    (9U)
/*! SIGNEXTEND - Sign extend.
 *  0b0..The top byte of the FIFODATA register is always 0.
 *  0b1..The top byte of the FIFODATA register is sign extended. This allows processing of 24-bit audio data on 32-bit machines.
 */
#define DMIC_CHANNEL_DC_CTRL_SIGNEXTEND(x)       (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_DC_CTRL_SIGNEXTEND_SHIFT)) & DMIC_CHANNEL_DC_CTRL_SIGNEXTEND_MASK)
/*! @} */

/* The count of DMIC_CHANNEL_DC_CTRL */
#define DMIC_CHANNEL_DC_CTRL_COUNT               (8U)

/*! @name CHANEN - Channel Enable register */
/*! @{ */

#define DMIC_CHANEN_EN_CH0_MASK                  (0x1U)
#define DMIC_CHANEN_EN_CH0_SHIFT                 (0U)
/*! EN_CH0 - Enable channel 0. When 1, PDM channel 0 is enabled.
 */
#define DMIC_CHANEN_EN_CH0(x)                    (((uint32_t)(((uint32_t)(x)) << DMIC_CHANEN_EN_CH0_SHIFT)) & DMIC_CHANEN_EN_CH0_MASK)

#define DMIC_CHANEN_EN_CH1_MASK                  (0x2U)
#define DMIC_CHANEN_EN_CH1_SHIFT                 (1U)
/*! EN_CH1 - Enable channel 1. When 1, PDM channel 1 is enabled.
 */
#define DMIC_CHANEN_EN_CH1(x)                    (((uint32_t)(((uint32_t)(x)) << DMIC_CHANEN_EN_CH1_SHIFT)) & DMIC_CHANEN_EN_CH1_MASK)

#define DMIC_CHANEN_EN_CH2_MASK                  (0x4U)
#define DMIC_CHANEN_EN_CH2_SHIFT                 (2U)
/*! EN_CH2 - Enable channel 2. When 1, PDM channel 2 is enabled.
 */
#define DMIC_CHANEN_EN_CH2(x)                    (((uint32_t)(((uint32_t)(x)) << DMIC_CHANEN_EN_CH2_SHIFT)) & DMIC_CHANEN_EN_CH2_MASK)

#define DMIC_CHANEN_EN_CH3_MASK                  (0x8U)
#define DMIC_CHANEN_EN_CH3_SHIFT                 (3U)
/*! EN_CH3 - Enable channel 3. When 1, PDM channel 3 is enabled.
 */
#define DMIC_CHANEN_EN_CH3(x)                    (((uint32_t)(((uint32_t)(x)) << DMIC_CHANEN_EN_CH3_SHIFT)) & DMIC_CHANEN_EN_CH3_MASK)

#define DMIC_CHANEN_EN_CH4_MASK                  (0x10U)
#define DMIC_CHANEN_EN_CH4_SHIFT                 (4U)
/*! EN_CH4 - Enable channel 4. When 1, PDM channel 4 is enabled.
 */
#define DMIC_CHANEN_EN_CH4(x)                    (((uint32_t)(((uint32_t)(x)) << DMIC_CHANEN_EN_CH4_SHIFT)) & DMIC_CHANEN_EN_CH4_MASK)

#define DMIC_CHANEN_EN_CH5_MASK                  (0x20U)
#define DMIC_CHANEN_EN_CH5_SHIFT                 (5U)
/*! EN_CH5 - Enable channel 5. When 1, PDM channel 5 is enabled.
 */
#define DMIC_CHANEN_EN_CH5(x)                    (((uint32_t)(((uint32_t)(x)) << DMIC_CHANEN_EN_CH5_SHIFT)) & DMIC_CHANEN_EN_CH5_MASK)

#define DMIC_CHANEN_EN_CH6_MASK                  (0x40U)
#define DMIC_CHANEN_EN_CH6_SHIFT                 (6U)
/*! EN_CH6 - Enable channel 6. When 1, PDM channel 6 is enabled.
 */
#define DMIC_CHANEN_EN_CH6(x)                    (((uint32_t)(((uint32_t)(x)) << DMIC_CHANEN_EN_CH6_SHIFT)) & DMIC_CHANEN_EN_CH6_MASK)

#define DMIC_CHANEN_EN_CH7_MASK                  (0x80U)
#define DMIC_CHANEN_EN_CH7_SHIFT                 (7U)
/*! EN_CH7 - Enable channel 7. When 1, PDM channel 7 is enabled.
 */
#define DMIC_CHANEN_EN_CH7(x)                    (((uint32_t)(((uint32_t)(x)) << DMIC_CHANEN_EN_CH7_SHIFT)) & DMIC_CHANEN_EN_CH7_MASK)
/*! @} */

/*! @name USE2FS - Use 2FS register */
/*! @{ */

#define DMIC_USE2FS_USE2FS_MASK                  (0x1U)
#define DMIC_USE2FS_USE2FS_SHIFT                 (0U)
/*! USE2FS - Use 2FS register
 *  0b0..Use 1FS output for PCM data.
 *  0b1..Use 2FS output for PCM data.
 */
#define DMIC_USE2FS_USE2FS(x)                    (((uint32_t)(((uint32_t)(x)) << DMIC_USE2FS_USE2FS_SHIFT)) & DMIC_USE2FS_USE2FS_MASK)
/*! @} */

/*! @name GLOBAL_SYNC_EN - global sync enable */
/*! @{ */

#define DMIC_GLOBAL_SYNC_EN_CH_SYNC_EN_MASK      (0xFFU)
#define DMIC_GLOBAL_SYNC_EN_CH_SYNC_EN_SHIFT     (0U)
#define DMIC_GLOBAL_SYNC_EN_CH_SYNC_EN(x)        (((uint32_t)(((uint32_t)(x)) << DMIC_GLOBAL_SYNC_EN_CH_SYNC_EN_SHIFT)) & DMIC_GLOBAL_SYNC_EN_CH_SYNC_EN_MASK)
/*! @} */

/*! @name GLOBAL_COUNT_VAL -  */
/*! @{ */

#define DMIC_GLOBAL_COUNT_VAL_CCOUNTVAL_MASK     (0xFFFFFFFFU)
#define DMIC_GLOBAL_COUNT_VAL_CCOUNTVAL_SHIFT    (0U)
#define DMIC_GLOBAL_COUNT_VAL_CCOUNTVAL(x)       (((uint32_t)(((uint32_t)(x)) << DMIC_GLOBAL_COUNT_VAL_CCOUNTVAL_SHIFT)) & DMIC_GLOBAL_COUNT_VAL_CCOUNTVAL_MASK)
/*! @} */

/*! @name DECRESET -  */
/*! @{ */

#define DMIC_DECRESET_DECRESET_MASK              (0xFFU)
#define DMIC_DECRESET_DECRESET_SHIFT             (0U)
/*! DECRESET
 *  0b00000000..release reset to decimator
 *  0b00000001..assert reset to decimator Note : resets are applied in pairs. So bit 0 corresponds to channels
 *              0/1, bit1 corresponds to channels 2/3, bit2 to channel 4/5 and bit3 to channel 6/7
 */
#define DMIC_DECRESET_DECRESET(x)                (((uint32_t)(((uint32_t)(x)) << DMIC_DECRESET_DECRESET_SHIFT)) & DMIC_DECRESET_DECRESET_MASK)
/*! @} */

/*! @name HWVADGAIN - HWVAD input gain register */
/*! @{ */

#define DMIC_HWVADGAIN_INPUTGAIN_MASK            (0xFU)
#define DMIC_HWVADGAIN_INPUTGAIN_SHIFT           (0U)
/*! INPUTGAIN - Gain factor for input signal into HWVAD
 */
#define DMIC_HWVADGAIN_INPUTGAIN(x)              (((uint32_t)(((uint32_t)(x)) << DMIC_HWVADGAIN_INPUTGAIN_SHIFT)) & DMIC_HWVADGAIN_INPUTGAIN_MASK)
/*! @} */

/*! @name HWVADHPFS - HWVAD filter control register */
/*! @{ */

#define DMIC_HWVADHPFS_HPFS_MASK                 (0x3U)
#define DMIC_HWVADHPFS_HPFS_SHIFT                (0U)
/*! HPFS - This field chooses the High Pass filter in first part of HWVAD
 *  0b00..First filter by-pass.
 *  0b01..High pass filter with -3dB cut-off at 1750Hz.
 *  0b10..High pass filter with -3dB cut-off at 215Hz.
 *  0b11..Reserved.
 */
#define DMIC_HWVADHPFS_HPFS(x)                   (((uint32_t)(((uint32_t)(x)) << DMIC_HWVADHPFS_HPFS_SHIFT)) & DMIC_HWVADHPFS_HPFS_MASK)
/*! @} */

/*! @name HWVADST10 - HWVAD control register */
/*! @{ */

#define DMIC_HWVADST10_ST10_MASK                 (0x1U)
#define DMIC_HWVADST10_ST10_SHIFT                (0U)
/*! ST10 - 1' means enter stage 1 of VAD, ie a sound change has been detected and the HWVAD is being
 *    allowed to settle. Use 0 when changing back to detection mode. Allow several milliseconds in
 *    stage 1 for settling.
 *  0b0..Normal operation, waiting for HWVAD trigger event (stage 0).
 *  0b1..Reset internal interrupt flag by writing a '1' pulse.
 */
#define DMIC_HWVADST10_ST10(x)                   (((uint32_t)(((uint32_t)(x)) << DMIC_HWVADST10_ST10_SHIFT)) & DMIC_HWVADST10_ST10_MASK)
/*! @} */

/*! @name HWVADRSTT - HWVAD filter reset register */
/*! @{ */

#define DMIC_HWVADRSTT_RSTT_MASK                 (0x1U)
#define DMIC_HWVADRSTT_RSTT_SHIFT                (0U)
/*! RSTT - Reset HWVAD. Write back to 0 to release reset.
 */
#define DMIC_HWVADRSTT_RSTT(x)                   (((uint32_t)(((uint32_t)(x)) << DMIC_HWVADRSTT_RSTT_SHIFT)) & DMIC_HWVADRSTT_RSTT_MASK)
/*! @} */

/*! @name HWVADTHGN - HWVAD noise estimator gain register */
/*! @{ */

#define DMIC_HWVADTHGN_THGN_MASK                 (0xFU)
#define DMIC_HWVADTHGN_THGN_SHIFT                (0U)
/*! THGN - Gain Factor for Noise-floor - use a positive number to make average less sensitive to sudden changes
 */
#define DMIC_HWVADTHGN_THGN(x)                   (((uint32_t)(((uint32_t)(x)) << DMIC_HWVADTHGN_THGN_SHIFT)) & DMIC_HWVADTHGN_THGN_MASK)
/*! @} */

/*! @name HWVADTHGS - HWVAD signal estimator gain register */
/*! @{ */

#define DMIC_HWVADTHGS_THGS_MASK                 (0xFU)
#define DMIC_HWVADTHGS_THGS_SHIFT                (0U)
/*! THGS - Signal Gain factor - use a postive number to make current signal stand out more over longer term average
 */
#define DMIC_HWVADTHGS_THGS(x)                   (((uint32_t)(((uint32_t)(x)) << DMIC_HWVADTHGS_THGS_SHIFT)) & DMIC_HWVADTHGS_THGS_MASK)
/*! @} */

/*! @name HWVADLOWZ - HWVAD noise envelope estimator register */
/*! @{ */

#define DMIC_HWVADLOWZ_LOWZ_MASK                 (0xFFFFU)
#define DMIC_HWVADLOWZ_LOWZ_SHIFT                (0U)
/*! LOWZ - Average noise-floor value
 */
#define DMIC_HWVADLOWZ_LOWZ(x)                   (((uint32_t)(((uint32_t)(x)) << DMIC_HWVADLOWZ_LOWZ_SHIFT)) & DMIC_HWVADLOWZ_LOWZ_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group DMIC_Register_Masks */


/* DMIC - Peripheral instance base addresses */
/** Peripheral DMIC0 base address */
#define DMIC0_BASE                               (0x40121000u)
/** Peripheral DMIC0 base pointer */
#define DMIC0                                    ((DMIC_Type *)DMIC0_BASE)
/** Array initializer of DMIC peripheral base addresses */
#define DMIC_BASE_ADDRS                          { DMIC0_BASE }
/** Array initializer of DMIC peripheral base pointers */
#define DMIC_BASE_PTRS                           { DMIC0 }
/** Interrupt vectors for the DMIC peripheral type */
#define DMIC_IRQS                                { DMIC0_IRQn }
#define DMIC_HWVAD_IRQS                          { HWVAD0_IRQn }

/*!
 * @}
 */ /* end of group DMIC_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- FLEXCOMM Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FLEXCOMM_Peripheral_Access_Layer FLEXCOMM Peripheral Access Layer
 * @{
 */

/** FLEXCOMM - Register Layout Typedef */
typedef struct {
       uint8_t RESERVED_0[4088];
  __IO uint32_t PSELID;                            /**< Peripheral Select and Flexcomm ID register., offset: 0xFF8 */
  __I  uint32_t PID;                               /**< Peripheral identification register., offset: 0xFFC */
} FLEXCOMM_Type;

/* ----------------------------------------------------------------------------
   -- FLEXCOMM Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FLEXCOMM_Register_Masks FLEXCOMM Register Masks
 * @{
 */

/*! @name PSELID - Peripheral Select and Flexcomm ID register. */
/*! @{ */

#define FLEXCOMM_PSELID_PERSEL_MASK              (0x7U)
#define FLEXCOMM_PSELID_PERSEL_SHIFT             (0U)
/*! PERSEL - Peripheral Select. This field is writable by software.
 *  0b000..No peripheral selected.
 *  0b001..USART function selected.
 *  0b010..SPI function selected.
 *  0b011..I2C function selected.
 *  0b100..I2S transmit function selected.
 *  0b101..I2S receive function selected.
 *  0b110..Reserved
 *  0b111..Reserved
 */
#define FLEXCOMM_PSELID_PERSEL(x)                (((uint32_t)(((uint32_t)(x)) << FLEXCOMM_PSELID_PERSEL_SHIFT)) & FLEXCOMM_PSELID_PERSEL_MASK)

#define FLEXCOMM_PSELID_LOCK_MASK                (0x8U)
#define FLEXCOMM_PSELID_LOCK_SHIFT               (3U)
/*! LOCK - Lock the peripheral select. This field is writable by software.
 *  0b0..Peripheral select can be changed by software.
 *  0b1..Peripheral select is locked and cannot be changed until this Flexcomm or the entire device is reset.
 */
#define FLEXCOMM_PSELID_LOCK(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXCOMM_PSELID_LOCK_SHIFT)) & FLEXCOMM_PSELID_LOCK_MASK)

#define FLEXCOMM_PSELID_USARTPRESENT_MASK        (0x10U)
#define FLEXCOMM_PSELID_USARTPRESENT_SHIFT       (4U)
/*! USARTPRESENT - USART present indicator. This field is Read-only.
 *  0b0..This Flexcomm does not include the USART function.
 *  0b1..This Flexcomm includes the USART function.
 */
#define FLEXCOMM_PSELID_USARTPRESENT(x)          (((uint32_t)(((uint32_t)(x)) << FLEXCOMM_PSELID_USARTPRESENT_SHIFT)) & FLEXCOMM_PSELID_USARTPRESENT_MASK)

#define FLEXCOMM_PSELID_SPIPRESENT_MASK          (0x20U)
#define FLEXCOMM_PSELID_SPIPRESENT_SHIFT         (5U)
/*! SPIPRESENT - SPI present indicator. This field is Read-only.
 *  0b0..This Flexcomm does not include the SPI function.
 *  0b1..This Flexcomm includes the SPI function.
 */
#define FLEXCOMM_PSELID_SPIPRESENT(x)            (((uint32_t)(((uint32_t)(x)) << FLEXCOMM_PSELID_SPIPRESENT_SHIFT)) & FLEXCOMM_PSELID_SPIPRESENT_MASK)

#define FLEXCOMM_PSELID_I2CPRESENT_MASK          (0x40U)
#define FLEXCOMM_PSELID_I2CPRESENT_SHIFT         (6U)
/*! I2CPRESENT - I2C present indicator. This field is Read-only.
 *  0b0..This Flexcomm does not include the I2C function.
 *  0b1..This Flexcomm includes the I2C function.
 */
#define FLEXCOMM_PSELID_I2CPRESENT(x)            (((uint32_t)(((uint32_t)(x)) << FLEXCOMM_PSELID_I2CPRESENT_SHIFT)) & FLEXCOMM_PSELID_I2CPRESENT_MASK)

#define FLEXCOMM_PSELID_I2SPRESENT_MASK          (0x80U)
#define FLEXCOMM_PSELID_I2SPRESENT_SHIFT         (7U)
/*! I2SPRESENT - I 2S present indicator. This field is Read-only.
 *  0b0..This Flexcomm does not include the I2S function.
 *  0b1..This Flexcomm includes the I2S function.
 */
#define FLEXCOMM_PSELID_I2SPRESENT(x)            (((uint32_t)(((uint32_t)(x)) << FLEXCOMM_PSELID_I2SPRESENT_SHIFT)) & FLEXCOMM_PSELID_I2SPRESENT_MASK)

#define FLEXCOMM_PSELID_ID_MASK                  (0xFFFFF000U)
#define FLEXCOMM_PSELID_ID_SHIFT                 (12U)
/*! ID - Flexcomm ID.
 */
#define FLEXCOMM_PSELID_ID(x)                    (((uint32_t)(((uint32_t)(x)) << FLEXCOMM_PSELID_ID_SHIFT)) & FLEXCOMM_PSELID_ID_MASK)
/*! @} */

/*! @name PID - Peripheral identification register. */
/*! @{ */

#define FLEXCOMM_PID_Minor_Rev_MASK              (0xF00U)
#define FLEXCOMM_PID_Minor_Rev_SHIFT             (8U)
/*! Minor_Rev - Minor revision of module implementation.
 */
#define FLEXCOMM_PID_Minor_Rev(x)                (((uint32_t)(((uint32_t)(x)) << FLEXCOMM_PID_Minor_Rev_SHIFT)) & FLEXCOMM_PID_Minor_Rev_MASK)

#define FLEXCOMM_PID_Major_Rev_MASK              (0xF000U)
#define FLEXCOMM_PID_Major_Rev_SHIFT             (12U)
/*! Major_Rev - Major revision of module implementation.
 */
#define FLEXCOMM_PID_Major_Rev(x)                (((uint32_t)(((uint32_t)(x)) << FLEXCOMM_PID_Major_Rev_SHIFT)) & FLEXCOMM_PID_Major_Rev_MASK)

#define FLEXCOMM_PID_ID_MASK                     (0xFFFF0000U)
#define FLEXCOMM_PID_ID_SHIFT                    (16U)
/*! ID - Module identifier for the selected function.
 */
#define FLEXCOMM_PID_ID(x)                       (((uint32_t)(((uint32_t)(x)) << FLEXCOMM_PID_ID_SHIFT)) & FLEXCOMM_PID_ID_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group FLEXCOMM_Register_Masks */


/* FLEXCOMM - Peripheral instance base addresses */
/** Peripheral FLEXCOMM0 base address */
#define FLEXCOMM0_BASE                           (0x40106000u)
/** Peripheral FLEXCOMM0 base pointer */
#define FLEXCOMM0                                ((FLEXCOMM_Type *)FLEXCOMM0_BASE)
/** Peripheral FLEXCOMM1 base address */
#define FLEXCOMM1_BASE                           (0x40107000u)
/** Peripheral FLEXCOMM1 base pointer */
#define FLEXCOMM1                                ((FLEXCOMM_Type *)FLEXCOMM1_BASE)
/** Peripheral FLEXCOMM2 base address */
#define FLEXCOMM2_BASE                           (0x40108000u)
/** Peripheral FLEXCOMM2 base pointer */
#define FLEXCOMM2                                ((FLEXCOMM_Type *)FLEXCOMM2_BASE)
/** Peripheral FLEXCOMM3 base address */
#define FLEXCOMM3_BASE                           (0x40109000u)
/** Peripheral FLEXCOMM3 base pointer */
#define FLEXCOMM3                                ((FLEXCOMM_Type *)FLEXCOMM3_BASE)
/** Peripheral FLEXCOMM4 base address */
#define FLEXCOMM4_BASE                           (0x40122000u)
/** Peripheral FLEXCOMM4 base pointer */
#define FLEXCOMM4                                ((FLEXCOMM_Type *)FLEXCOMM4_BASE)
/** Peripheral FLEXCOMM5 base address */
#define FLEXCOMM5_BASE                           (0x40123000u)
/** Peripheral FLEXCOMM5 base pointer */
#define FLEXCOMM5                                ((FLEXCOMM_Type *)FLEXCOMM5_BASE)
/** Peripheral FLEXCOMM6 base address */
#define FLEXCOMM6_BASE                           (0x40124000u)
/** Peripheral FLEXCOMM6 base pointer */
#define FLEXCOMM6                                ((FLEXCOMM_Type *)FLEXCOMM6_BASE)
/** Peripheral FLEXCOMM7 base address */
#define FLEXCOMM7_BASE                           (0x40125000u)
/** Peripheral FLEXCOMM7 base pointer */
#define FLEXCOMM7                                ((FLEXCOMM_Type *)FLEXCOMM7_BASE)
/** Peripheral FLEXCOMM14 base address */
#define FLEXCOMM14_BASE                          (0x40126000u)
/** Peripheral FLEXCOMM14 base pointer */
#define FLEXCOMM14                               ((FLEXCOMM_Type *)FLEXCOMM14_BASE)
/** Peripheral FLEXCOMM15 base address */
#define FLEXCOMM15_BASE                          (0x40127000u)
/** Peripheral FLEXCOMM15 base pointer */
#define FLEXCOMM15                               ((FLEXCOMM_Type *)FLEXCOMM15_BASE)
/** Array initializer of FLEXCOMM peripheral base addresses */
#define FLEXCOMM_BASE_ADDRS                      { FLEXCOMM0_BASE, FLEXCOMM1_BASE, FLEXCOMM2_BASE, FLEXCOMM3_BASE, FLEXCOMM4_BASE, FLEXCOMM5_BASE, FLEXCOMM6_BASE, FLEXCOMM7_BASE, FLEXCOMM14_BASE, FLEXCOMM15_BASE }
/** Array initializer of FLEXCOMM peripheral base pointers */
#define FLEXCOMM_BASE_PTRS                       { FLEXCOMM0, FLEXCOMM1, FLEXCOMM2, FLEXCOMM3, FLEXCOMM4, FLEXCOMM5, FLEXCOMM6, FLEXCOMM7, FLEXCOMM14, FLEXCOMM15 }
/** Interrupt vectors for the FLEXCOMM peripheral type */
#define FLEXCOMM_IRQS                            { FLEXCOMM0_IRQn, FLEXCOMM1_IRQn, FLEXCOMM2_IRQn, FLEXCOMM3_IRQn, FLEXCOMM4_IRQn, FLEXCOMM5_IRQn, FLEXCOMM6_IRQn, FLEXCOMM7_IRQn, NotAvail_IRQn, NotAvail_IRQn }

/*!
 * @}
 */ /* end of group FLEXCOMM_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- FLEXSPI Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FLEXSPI_Peripheral_Access_Layer FLEXSPI Peripheral Access Layer
 * @{
 */

/** FLEXSPI - Register Layout Typedef */
typedef struct {
  __IO uint32_t MCR0;                              /**< Module Control Register 0, offset: 0x0 */
  __IO uint32_t MCR1;                              /**< Module Control Register 1, offset: 0x4 */
  __IO uint32_t MCR2;                              /**< Module Control Register 2, offset: 0x8 */
  __IO uint32_t AHBCR;                             /**< AHB Bus Control Register, offset: 0xC */
  __IO uint32_t INTEN;                             /**< Interrupt Enable Register, offset: 0x10 */
  __IO uint32_t INTR;                              /**< Interrupt Register, offset: 0x14 */
  __IO uint32_t LUTKEY;                            /**< LUT Key Register, offset: 0x18 */
  __IO uint32_t LUTCR;                             /**< LUT Control Register, offset: 0x1C */
  __IO uint32_t AHBRXBUFCR0[8];                    /**< AHB RX Buffer 0 Control Register 0..AHB RX Buffer 7 Control Register 0, array offset: 0x20, array step: 0x4 */
       uint8_t RESERVED_0[32];
  __IO uint32_t FLSHCR0[4];                        /**< Flash Control Register 0, array offset: 0x60, array step: 0x4 */
  __IO uint32_t FLSHCR1[4];                        /**< Flash Control Register 1, array offset: 0x70, array step: 0x4 */
  __IO uint32_t FLSHCR2[4];                        /**< Flash Control Register 2, array offset: 0x80, array step: 0x4 */
       uint8_t RESERVED_1[4];
  __IO uint32_t FLSHCR4;                           /**< Flash Control Register 4, offset: 0x94 */
       uint8_t RESERVED_2[8];
  __IO uint32_t IPCR0;                             /**< IP Control Register 0, offset: 0xA0 */
  __IO uint32_t IPCR1;                             /**< IP Control Register 1, offset: 0xA4 */
       uint8_t RESERVED_3[8];
  __IO uint32_t IPCMD;                             /**< IP Command Register, offset: 0xB0 */
  __IO uint32_t DLPR;                              /**< Data Learn Pattern Register, offset: 0xB4 */
  __IO uint32_t IPRXFCR;                           /**< IP RX FIFO Control Register, offset: 0xB8 */
  __IO uint32_t IPTXFCR;                           /**< IP TX FIFO Control Register, offset: 0xBC */
  __IO uint32_t DLLCR[2];                          /**< DLL Control Register 0, array offset: 0xC0, array step: 0x4 */
       uint8_t RESERVED_4[24];
  __I  uint32_t STS0;                              /**< Status Register 0, offset: 0xE0 */
  __I  uint32_t STS1;                              /**< Status Register 1, offset: 0xE4 */
  __I  uint32_t STS2;                              /**< Status Register 2, offset: 0xE8 */
  __I  uint32_t AHBSPNDSTS;                        /**< AHB Suspend Status Register, offset: 0xEC */
  __I  uint32_t IPRXFSTS;                          /**< IP RX FIFO Status Register, offset: 0xF0 */
  __I  uint32_t IPTXFSTS;                          /**< IP TX FIFO Status Register, offset: 0xF4 */
       uint8_t RESERVED_5[8];
  __I  uint32_t RFDR[32];                          /**< IP RX FIFO Data Register 0..IP RX FIFO Data Register 31, array offset: 0x100, array step: 0x4 */
  __O  uint32_t TFDR[32];                          /**< IP TX FIFO Data Register 0..IP TX FIFO Data Register 31, array offset: 0x180, array step: 0x4 */
  __IO uint32_t LUT[128];                          /**< LUT 0..LUT 127, array offset: 0x200, array step: 0x4 */
} FLEXSPI_Type;

/* ----------------------------------------------------------------------------
   -- FLEXSPI Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FLEXSPI_Register_Masks FLEXSPI Register Masks
 * @{
 */

/*! @name MCR0 - Module Control Register 0 */
/*! @{ */

#define FLEXSPI_MCR0_SWRESET_MASK                (0x1U)
#define FLEXSPI_MCR0_SWRESET_SHIFT               (0U)
/*! SWRESET - Software Reset
 */
#define FLEXSPI_MCR0_SWRESET(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXSPI_MCR0_SWRESET_SHIFT)) & FLEXSPI_MCR0_SWRESET_MASK)

#define FLEXSPI_MCR0_MDIS_MASK                   (0x2U)
#define FLEXSPI_MCR0_MDIS_SHIFT                  (1U)
/*! MDIS - Module Disable
 */
#define FLEXSPI_MCR0_MDIS(x)                     (((uint32_t)(((uint32_t)(x)) << FLEXSPI_MCR0_MDIS_SHIFT)) & FLEXSPI_MCR0_MDIS_MASK)

#define FLEXSPI_MCR0_RXCLKSRC_MASK               (0x30U)
#define FLEXSPI_MCR0_RXCLKSRC_SHIFT              (4U)
/*! RXCLKSRC - Sample Clock source selection for Flash Reading
 *  0b00..Dummy Read strobe generated by FlexSPI Controller and loopback internally.
 *  0b01..Dummy Read strobe generated by FlexSPI Controller and loopback from DQS pad.
 *  0b10..Reserved
 *  0b11..Flash provided Read strobe and input from DQS pad
 */
#define FLEXSPI_MCR0_RXCLKSRC(x)                 (((uint32_t)(((uint32_t)(x)) << FLEXSPI_MCR0_RXCLKSRC_SHIFT)) & FLEXSPI_MCR0_RXCLKSRC_MASK)

#define FLEXSPI_MCR0_SERCLKDIV_MASK              (0x700U)
#define FLEXSPI_MCR0_SERCLKDIV_SHIFT             (8U)
/*! SERCLKDIV - The serial root clock could be divided inside FlexSPI wrapper. Refer Clocks chapter for more details on clocking.
 *  0b000..Divided by 1
 *  0b001..Divided by 2
 *  0b010..Divided by 3
 *  0b011..Divided by 4
 *  0b100..Divided by 5
 *  0b101..Divided by 6
 *  0b110..Divided by 7
 *  0b111..Divided by 8
 */
#define FLEXSPI_MCR0_SERCLKDIV(x)                (((uint32_t)(((uint32_t)(x)) << FLEXSPI_MCR0_SERCLKDIV_SHIFT)) & FLEXSPI_MCR0_SERCLKDIV_MASK)

#define FLEXSPI_MCR0_HSEN_MASK                   (0x800U)
#define FLEXSPI_MCR0_HSEN_SHIFT                  (11U)
/*! HSEN - Half Speed Serial Flash access Enable.
 *  0b0..Disable divide by 2 of serial flash clock for half speed commands.
 *  0b1..Enable divide by 2 of serial flash clock for half speed commands.
 */
#define FLEXSPI_MCR0_HSEN(x)                     (((uint32_t)(((uint32_t)(x)) << FLEXSPI_MCR0_HSEN_SHIFT)) & FLEXSPI_MCR0_HSEN_MASK)

#define FLEXSPI_MCR0_DOZEEN_MASK                 (0x1000U)
#define FLEXSPI_MCR0_DOZEEN_SHIFT                (12U)
/*! DOZEEN - Doze mode enable bit
 *  0b0..Doze mode support disabled. AHB clock and serial clock will not be gated off when there is doze mode request from system.
 *  0b1..Doze mode support enabled. AHB clock and serial clock will be gated off when there is doze mode request from system.
 */
#define FLEXSPI_MCR0_DOZEEN(x)                   (((uint32_t)(((uint32_t)(x)) << FLEXSPI_MCR0_DOZEEN_SHIFT)) & FLEXSPI_MCR0_DOZEEN_MASK)

#define FLEXSPI_MCR0_SCKFREERUNEN_MASK           (0x4000U)
#define FLEXSPI_MCR0_SCKFREERUNEN_SHIFT          (14U)
/*! SCKFREERUNEN - This bit is used to force SCLK output free-running. For FPGA applications,
 *    external device may use SCLK as reference clock to its internal PLL. If SCLK free-running is
 *    enabled, data sampling with loopback clock from SCLK pad is not supported (MCR0[RXCLKSRC]=2).
 *  0b0..Disable.
 *  0b1..Enable.
 */
#define FLEXSPI_MCR0_SCKFREERUNEN(x)             (((uint32_t)(((uint32_t)(x)) << FLEXSPI_MCR0_SCKFREERUNEN_SHIFT)) & FLEXSPI_MCR0_SCKFREERUNEN_MASK)

#define FLEXSPI_MCR0_LEARNEN_MASK                (0x8000U)
#define FLEXSPI_MCR0_LEARNEN_SHIFT               (15U)
/*! LEARNEN - This bit is used to enable/disable data learning feature. When data learning is
 *    disabled, the sampling clock phase 0 is always used for RX data sampling even if LEARN instruction
 *    is correctly executed.
 *  0b0..Disable.
 *  0b1..Enable.
 */
#define FLEXSPI_MCR0_LEARNEN(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXSPI_MCR0_LEARNEN_SHIFT)) & FLEXSPI_MCR0_LEARNEN_MASK)

#define FLEXSPI_MCR0_IPGRANTWAIT_MASK            (0xFF0000U)
#define FLEXSPI_MCR0_IPGRANTWAIT_SHIFT           (16U)
/*! IPGRANTWAIT - Time out wait cycle for IP command grant.
 */
#define FLEXSPI_MCR0_IPGRANTWAIT(x)              (((uint32_t)(((uint32_t)(x)) << FLEXSPI_MCR0_IPGRANTWAIT_SHIFT)) & FLEXSPI_MCR0_IPGRANTWAIT_MASK)

#define FLEXSPI_MCR0_AHBGRANTWAIT_MASK           (0xFF000000U)
#define FLEXSPI_MCR0_AHBGRANTWAIT_SHIFT          (24U)
/*! AHBGRANTWAIT - Timeout wait cycle for AHB command grant.
 */
#define FLEXSPI_MCR0_AHBGRANTWAIT(x)             (((uint32_t)(((uint32_t)(x)) << FLEXSPI_MCR0_AHBGRANTWAIT_SHIFT)) & FLEXSPI_MCR0_AHBGRANTWAIT_MASK)
/*! @} */

/*! @name MCR1 - Module Control Register 1 */
/*! @{ */

#define FLEXSPI_MCR1_AHBBUSWAIT_MASK             (0xFFFFU)
#define FLEXSPI_MCR1_AHBBUSWAIT_SHIFT            (0U)
#define FLEXSPI_MCR1_AHBBUSWAIT(x)               (((uint32_t)(((uint32_t)(x)) << FLEXSPI_MCR1_AHBBUSWAIT_SHIFT)) & FLEXSPI_MCR1_AHBBUSWAIT_MASK)

#define FLEXSPI_MCR1_SEQWAIT_MASK                (0xFFFF0000U)
#define FLEXSPI_MCR1_SEQWAIT_SHIFT               (16U)
#define FLEXSPI_MCR1_SEQWAIT(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXSPI_MCR1_SEQWAIT_SHIFT)) & FLEXSPI_MCR1_SEQWAIT_MASK)
/*! @} */

/*! @name MCR2 - Module Control Register 2 */
/*! @{ */

#define FLEXSPI_MCR2_CLRAHBBUFOPT_MASK           (0x800U)
#define FLEXSPI_MCR2_CLRAHBBUFOPT_SHIFT          (11U)
/*! CLRAHBBUFOPT - This bit determines whether AHB RX Buffer and AHB TX Buffer will be cleaned
 *    automatically when FlexSPI returns STOP mode ACK. Software should set this bit if AHB RX Buffer or
 *    AHB TX Buffer will be powered off in STOP mode. Otherwise AHB read access after exiting STOP
 *    mode may hit AHB RX Buffer or AHB TX Buffer but their data entries are invalid.
 *  0b0..AHB RX/TX Buffer will not be cleaned automatically when FlexSPI return Stop mode ACK.
 *  0b1..AHB RX/TX Buffer will be cleaned automatically when FlexSPI return Stop mode ACK.
 */
#define FLEXSPI_MCR2_CLRAHBBUFOPT(x)             (((uint32_t)(((uint32_t)(x)) << FLEXSPI_MCR2_CLRAHBBUFOPT_SHIFT)) & FLEXSPI_MCR2_CLRAHBBUFOPT_MASK)

#define FLEXSPI_MCR2_CLRLEARNPHASE_MASK          (0x4000U)
#define FLEXSPI_MCR2_CLRLEARNPHASE_SHIFT         (14U)
/*! CLRLEARNPHASE - The sampling clock phase selection will be reset to phase 0 when this bit is
 *    written with 0x1. This bit will be auto-cleared immediately.
 */
#define FLEXSPI_MCR2_CLRLEARNPHASE(x)            (((uint32_t)(((uint32_t)(x)) << FLEXSPI_MCR2_CLRLEARNPHASE_SHIFT)) & FLEXSPI_MCR2_CLRLEARNPHASE_MASK)

#define FLEXSPI_MCR2_SAMEDEVICEEN_MASK           (0x8000U)
#define FLEXSPI_MCR2_SAMEDEVICEEN_SHIFT          (15U)
/*! SAMEDEVICEEN - All external devices are same devices (both in types and size) for A1/A2/B1/B2.
 *  0b0..In Individual mode, FLSHA1CRx/FLSHA2CRx/FLSHB1CRx/FLSHB2CRx register setting will be applied to Flash
 *       A1/A2/B1/B2 separately. In Parallel mode, FLSHA1CRx register setting will be applied to Flash A1 and B1,
 *       FLSHA2CRx register setting will be applied to Flash A2 and B2. FLSHB1CRx/FLSHB2CRx register settings will be
 *       ignored.
 *  0b1..FLSHA1CR0/FLSHA1CR1/FLSHA1CR2 register settings will be applied to Flash A1/A2/B1/B2. FLSHA2CRx/FLSHB1CRx/FLSHB2CRx will be ignored.
 */
#define FLEXSPI_MCR2_SAMEDEVICEEN(x)             (((uint32_t)(((uint32_t)(x)) << FLEXSPI_MCR2_SAMEDEVICEEN_SHIFT)) & FLEXSPI_MCR2_SAMEDEVICEEN_MASK)

#define FLEXSPI_MCR2_SCKBDIFFOPT_MASK            (0x80000U)
#define FLEXSPI_MCR2_SCKBDIFFOPT_SHIFT           (19U)
/*! SCKBDIFFOPT - B_SCLK pad can be used as A_SCLK differential clock output (inverted clock to
 *    A_SCLK). In this case, port B flash access is not available. After changing the value of this
 *    field, MCR0[SWRESET] should be set.
 *  0b1..B_SCLK pad is used as port A SCLK inverted clock output (Differential clock to A_SCLK). Port B flash access is not available.
 *  0b0..B_SCLK pad is used as port B SCLK clock output. Port B flash access is available.
 */
#define FLEXSPI_MCR2_SCKBDIFFOPT(x)              (((uint32_t)(((uint32_t)(x)) << FLEXSPI_MCR2_SCKBDIFFOPT_SHIFT)) & FLEXSPI_MCR2_SCKBDIFFOPT_MASK)

#define FLEXSPI_MCR2_RESUMEWAIT_MASK             (0xFF000000U)
#define FLEXSPI_MCR2_RESUMEWAIT_SHIFT            (24U)
/*! RESUMEWAIT - Wait cycle (in AHB clock cycle) for idle state before suspended command sequence resumed.
 */
#define FLEXSPI_MCR2_RESUMEWAIT(x)               (((uint32_t)(((uint32_t)(x)) << FLEXSPI_MCR2_RESUMEWAIT_SHIFT)) & FLEXSPI_MCR2_RESUMEWAIT_MASK)
/*! @} */

/*! @name AHBCR - AHB Bus Control Register */
/*! @{ */

#define FLEXSPI_AHBCR_APAREN_MASK                (0x1U)
#define FLEXSPI_AHBCR_APAREN_SHIFT               (0U)
/*! APAREN - Parallel mode enabled for AHB triggered Command (both read and write) .
 *  0b0..Flash will be accessed in Individual mode.
 *  0b1..Flash will be accessed in Parallel mode.
 */
#define FLEXSPI_AHBCR_APAREN(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXSPI_AHBCR_APAREN_SHIFT)) & FLEXSPI_AHBCR_APAREN_MASK)

#define FLEXSPI_AHBCR_CACHABLEEN_MASK            (0x8U)
#define FLEXSPI_AHBCR_CACHABLEEN_SHIFT           (3U)
/*! CACHABLEEN - Enable AHB bus cachable read access support.
 *  0b0..Disabled. When there is AHB bus cachable read access, FlexSPI will not check whether it hit AHB TX Buffer.
 *  0b1..Enabled. When there is AHB bus cachable read access, FlexSPI will check whether it hit AHB TX Buffer first.
 */
#define FLEXSPI_AHBCR_CACHABLEEN(x)              (((uint32_t)(((uint32_t)(x)) << FLEXSPI_AHBCR_CACHABLEEN_SHIFT)) & FLEXSPI_AHBCR_CACHABLEEN_MASK)

#define FLEXSPI_AHBCR_BUFFERABLEEN_MASK          (0x10U)
#define FLEXSPI_AHBCR_BUFFERABLEEN_SHIFT         (4U)
/*! BUFFERABLEEN - Enable AHB bus bufferable write access support. This field affects the last beat
 *    of AHB write access, refer for more details about AHB bufferable write.
 *  0b0..Disabled. For all AHB write access (no matter bufferable or non-bufferable ), FlexSPI will return AHB Bus
 *       ready after all data is transmitted to External device and AHB command finished.
 *  0b1..Enabled. For AHB bufferable write access, FlexSPI will return AHB Bus ready when the AHB command is
 *       granted by arbitrator and will not wait for AHB command finished.
 */
#define FLEXSPI_AHBCR_BUFFERABLEEN(x)            (((uint32_t)(((uint32_t)(x)) << FLEXSPI_AHBCR_BUFFERABLEEN_SHIFT)) & FLEXSPI_AHBCR_BUFFERABLEEN_MASK)

#define FLEXSPI_AHBCR_PREFETCHEN_MASK            (0x20U)
#define FLEXSPI_AHBCR_PREFETCHEN_SHIFT           (5U)
/*! PREFETCHEN - AHB Read Prefetch Enable.
 */
#define FLEXSPI_AHBCR_PREFETCHEN(x)              (((uint32_t)(((uint32_t)(x)) << FLEXSPI_AHBCR_PREFETCHEN_SHIFT)) & FLEXSPI_AHBCR_PREFETCHEN_MASK)

#define FLEXSPI_AHBCR_READADDROPT_MASK           (0x40U)
#define FLEXSPI_AHBCR_READADDROPT_SHIFT          (6U)
/*! READADDROPT - AHB Read Address option bit. This option bit is intend to remove AHB burst start address alignment limitation.
 *  0b0..There is AHB read burst start address alignment limitation when flash is accessed in parallel mode or flash is wordaddressable.
 *  0b1..There is no AHB read burst start address alignment limitation. FlexSPI will fetch more data than AHB
 *       burst required to meet the alignment requirement.
 */
#define FLEXSPI_AHBCR_READADDROPT(x)             (((uint32_t)(((uint32_t)(x)) << FLEXSPI_AHBCR_READADDROPT_SHIFT)) & FLEXSPI_AHBCR_READADDROPT_MASK)
/*! @} */

/*! @name INTEN - Interrupt Enable Register */
/*! @{ */

#define FLEXSPI_INTEN_IPCMDDONEEN_MASK           (0x1U)
#define FLEXSPI_INTEN_IPCMDDONEEN_SHIFT          (0U)
/*! IPCMDDONEEN - IP triggered Command Sequences Execution finished interrupt enable.
 */
#define FLEXSPI_INTEN_IPCMDDONEEN(x)             (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTEN_IPCMDDONEEN_SHIFT)) & FLEXSPI_INTEN_IPCMDDONEEN_MASK)

#define FLEXSPI_INTEN_IPCMDGEEN_MASK             (0x2U)
#define FLEXSPI_INTEN_IPCMDGEEN_SHIFT            (1U)
/*! IPCMDGEEN - IP triggered Command Sequences Grant Timeout interrupt enable.
 */
#define FLEXSPI_INTEN_IPCMDGEEN(x)               (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTEN_IPCMDGEEN_SHIFT)) & FLEXSPI_INTEN_IPCMDGEEN_MASK)

#define FLEXSPI_INTEN_AHBCMDGEEN_MASK            (0x4U)
#define FLEXSPI_INTEN_AHBCMDGEEN_SHIFT           (2U)
/*! AHBCMDGEEN - AHB triggered Command Sequences Grant Timeout interrupt enable.
 */
#define FLEXSPI_INTEN_AHBCMDGEEN(x)              (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTEN_AHBCMDGEEN_SHIFT)) & FLEXSPI_INTEN_AHBCMDGEEN_MASK)

#define FLEXSPI_INTEN_IPCMDERREN_MASK            (0x8U)
#define FLEXSPI_INTEN_IPCMDERREN_SHIFT           (3U)
/*! IPCMDERREN - IP triggered Command Sequences Error Detected interrupt enable.
 */
#define FLEXSPI_INTEN_IPCMDERREN(x)              (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTEN_IPCMDERREN_SHIFT)) & FLEXSPI_INTEN_IPCMDERREN_MASK)

#define FLEXSPI_INTEN_AHBCMDERREN_MASK           (0x10U)
#define FLEXSPI_INTEN_AHBCMDERREN_SHIFT          (4U)
/*! AHBCMDERREN - AHB triggered Command Sequences Error Detected interrupt enable.
 */
#define FLEXSPI_INTEN_AHBCMDERREN(x)             (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTEN_AHBCMDERREN_SHIFT)) & FLEXSPI_INTEN_AHBCMDERREN_MASK)

#define FLEXSPI_INTEN_IPRXWAEN_MASK              (0x20U)
#define FLEXSPI_INTEN_IPRXWAEN_SHIFT             (5U)
/*! IPRXWAEN - IP RX FIFO WaterMark available interrupt enable.
 */
#define FLEXSPI_INTEN_IPRXWAEN(x)                (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTEN_IPRXWAEN_SHIFT)) & FLEXSPI_INTEN_IPRXWAEN_MASK)

#define FLEXSPI_INTEN_IPTXWEEN_MASK              (0x40U)
#define FLEXSPI_INTEN_IPTXWEEN_SHIFT             (6U)
/*! IPTXWEEN - IP TX FIFO WaterMark empty interrupt enable.
 */
#define FLEXSPI_INTEN_IPTXWEEN(x)                (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTEN_IPTXWEEN_SHIFT)) & FLEXSPI_INTEN_IPTXWEEN_MASK)

#define FLEXSPI_INTEN_DATALEARNFAILEN_MASK       (0x80U)
#define FLEXSPI_INTEN_DATALEARNFAILEN_SHIFT      (7U)
/*! DATALEARNFAILEN - Data Learning failed interrupt enable.
 */
#define FLEXSPI_INTEN_DATALEARNFAILEN(x)         (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTEN_DATALEARNFAILEN_SHIFT)) & FLEXSPI_INTEN_DATALEARNFAILEN_MASK)

#define FLEXSPI_INTEN_SCKSTOPBYRDEN_MASK         (0x100U)
#define FLEXSPI_INTEN_SCKSTOPBYRDEN_SHIFT        (8U)
/*! SCKSTOPBYRDEN - SCLK is stopped during command sequence because Async RX FIFO full interrupt enable.
 */
#define FLEXSPI_INTEN_SCKSTOPBYRDEN(x)           (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTEN_SCKSTOPBYRDEN_SHIFT)) & FLEXSPI_INTEN_SCKSTOPBYRDEN_MASK)

#define FLEXSPI_INTEN_SCKSTOPBYWREN_MASK         (0x200U)
#define FLEXSPI_INTEN_SCKSTOPBYWREN_SHIFT        (9U)
/*! SCKSTOPBYWREN - SCLK is stopped during command sequence because Async TX FIFO empty interrupt enable.
 */
#define FLEXSPI_INTEN_SCKSTOPBYWREN(x)           (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTEN_SCKSTOPBYWREN_SHIFT)) & FLEXSPI_INTEN_SCKSTOPBYWREN_MASK)

#define FLEXSPI_INTEN_AHBBUSTIMEOUTEN_MASK       (0x400U)
#define FLEXSPI_INTEN_AHBBUSTIMEOUTEN_SHIFT      (10U)
/*! AHBBUSTIMEOUTEN - AHB Bus timeout interrupt.Refer Interrupts chapter for more details.
 */
#define FLEXSPI_INTEN_AHBBUSTIMEOUTEN(x)         (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTEN_AHBBUSTIMEOUTEN_SHIFT)) & FLEXSPI_INTEN_AHBBUSTIMEOUTEN_MASK)

#define FLEXSPI_INTEN_SEQTIMEOUTEN_MASK          (0x800U)
#define FLEXSPI_INTEN_SEQTIMEOUTEN_SHIFT         (11U)
/*! SEQTIMEOUTEN - Sequence execution timeout interrupt enable.Refer Interrupts chapter for more details.
 */
#define FLEXSPI_INTEN_SEQTIMEOUTEN(x)            (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTEN_SEQTIMEOUTEN_SHIFT)) & FLEXSPI_INTEN_SEQTIMEOUTEN_MASK)
/*! @} */

/*! @name INTR - Interrupt Register */
/*! @{ */

#define FLEXSPI_INTR_IPCMDDONE_MASK              (0x1U)
#define FLEXSPI_INTR_IPCMDDONE_SHIFT             (0U)
/*! IPCMDDONE - IP triggered Command Sequences Execution finished interrupt. This interrupt is also
 *    generated when there is IPCMDGE or IPCMDERR interrupt generated.
 */
#define FLEXSPI_INTR_IPCMDDONE(x)                (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTR_IPCMDDONE_SHIFT)) & FLEXSPI_INTR_IPCMDDONE_MASK)

#define FLEXSPI_INTR_IPCMDGE_MASK                (0x2U)
#define FLEXSPI_INTR_IPCMDGE_SHIFT               (1U)
/*! IPCMDGE - IP triggered Command Sequences Grant Timeout interrupt.
 */
#define FLEXSPI_INTR_IPCMDGE(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTR_IPCMDGE_SHIFT)) & FLEXSPI_INTR_IPCMDGE_MASK)

#define FLEXSPI_INTR_AHBCMDGE_MASK               (0x4U)
#define FLEXSPI_INTR_AHBCMDGE_SHIFT              (2U)
/*! AHBCMDGE - AHB triggered Command Sequences Grant Timeout interrupt.
 */
#define FLEXSPI_INTR_AHBCMDGE(x)                 (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTR_AHBCMDGE_SHIFT)) & FLEXSPI_INTR_AHBCMDGE_MASK)

#define FLEXSPI_INTR_IPCMDERR_MASK               (0x8U)
#define FLEXSPI_INTR_IPCMDERR_SHIFT              (3U)
/*! IPCMDERR - IP triggered Command Sequences Error Detected interrupt. When an error detected for
 *    IP command, this command will be ignored and not executed at all.
 */
#define FLEXSPI_INTR_IPCMDERR(x)                 (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTR_IPCMDERR_SHIFT)) & FLEXSPI_INTR_IPCMDERR_MASK)

#define FLEXSPI_INTR_AHBCMDERR_MASK              (0x10U)
#define FLEXSPI_INTR_AHBCMDERR_SHIFT             (4U)
/*! AHBCMDERR - AHB triggered Command Sequences Error Detected interrupt. When an error detected for
 *    AHB command, this command will be ignored and not executed at all.
 */
#define FLEXSPI_INTR_AHBCMDERR(x)                (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTR_AHBCMDERR_SHIFT)) & FLEXSPI_INTR_AHBCMDERR_MASK)

#define FLEXSPI_INTR_IPRXWA_MASK                 (0x20U)
#define FLEXSPI_INTR_IPRXWA_SHIFT                (5U)
/*! IPRXWA - IP RX FIFO watermark available interrupt.
 */
#define FLEXSPI_INTR_IPRXWA(x)                   (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTR_IPRXWA_SHIFT)) & FLEXSPI_INTR_IPRXWA_MASK)

#define FLEXSPI_INTR_IPTXWE_MASK                 (0x40U)
#define FLEXSPI_INTR_IPTXWE_SHIFT                (6U)
/*! IPTXWE - IP TX FIFO watermark empty interrupt.
 */
#define FLEXSPI_INTR_IPTXWE(x)                   (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTR_IPTXWE_SHIFT)) & FLEXSPI_INTR_IPTXWE_MASK)

#define FLEXSPI_INTR_DATALEARNFAIL_MASK          (0x80U)
#define FLEXSPI_INTR_DATALEARNFAIL_SHIFT         (7U)
/*! DATALEARNFAIL - Data Learning failed interrupt.
 */
#define FLEXSPI_INTR_DATALEARNFAIL(x)            (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTR_DATALEARNFAIL_SHIFT)) & FLEXSPI_INTR_DATALEARNFAIL_MASK)

#define FLEXSPI_INTR_SCKSTOPBYRD_MASK            (0x100U)
#define FLEXSPI_INTR_SCKSTOPBYRD_SHIFT           (8U)
/*! SCKSTOPBYRD - SCLK is stopped during command sequence because Async RX FIFO full interrupt.
 */
#define FLEXSPI_INTR_SCKSTOPBYRD(x)              (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTR_SCKSTOPBYRD_SHIFT)) & FLEXSPI_INTR_SCKSTOPBYRD_MASK)

#define FLEXSPI_INTR_SCKSTOPBYWR_MASK            (0x200U)
#define FLEXSPI_INTR_SCKSTOPBYWR_SHIFT           (9U)
/*! SCKSTOPBYWR - SCLK is stopped during command sequence because Async TX FIFO empty interrupt.
 */
#define FLEXSPI_INTR_SCKSTOPBYWR(x)              (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTR_SCKSTOPBYWR_SHIFT)) & FLEXSPI_INTR_SCKSTOPBYWR_MASK)

#define FLEXSPI_INTR_AHBBUSTIMEOUT_MASK          (0x400U)
#define FLEXSPI_INTR_AHBBUSTIMEOUT_SHIFT         (10U)
/*! AHBBUSTIMEOUT - AHB Bus timeout interrupt.Refer Interrupts chapter for more details.
 */
#define FLEXSPI_INTR_AHBBUSTIMEOUT(x)            (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTR_AHBBUSTIMEOUT_SHIFT)) & FLEXSPI_INTR_AHBBUSTIMEOUT_MASK)

#define FLEXSPI_INTR_SEQTIMEOUT_MASK             (0x800U)
#define FLEXSPI_INTR_SEQTIMEOUT_SHIFT            (11U)
/*! SEQTIMEOUT - Sequence execution timeout interrupt.
 */
#define FLEXSPI_INTR_SEQTIMEOUT(x)               (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTR_SEQTIMEOUT_SHIFT)) & FLEXSPI_INTR_SEQTIMEOUT_MASK)
/*! @} */

/*! @name LUTKEY - LUT Key Register */
/*! @{ */

#define FLEXSPI_LUTKEY_KEY_MASK                  (0xFFFFFFFFU)
#define FLEXSPI_LUTKEY_KEY_SHIFT                 (0U)
/*! KEY - The Key to lock or unlock LUT.
 */
#define FLEXSPI_LUTKEY_KEY(x)                    (((uint32_t)(((uint32_t)(x)) << FLEXSPI_LUTKEY_KEY_SHIFT)) & FLEXSPI_LUTKEY_KEY_MASK)
/*! @} */

/*! @name LUTCR - LUT Control Register */
/*! @{ */

#define FLEXSPI_LUTCR_LOCK_MASK                  (0x1U)
#define FLEXSPI_LUTCR_LOCK_SHIFT                 (0U)
/*! LOCK - Lock LUT
 */
#define FLEXSPI_LUTCR_LOCK(x)                    (((uint32_t)(((uint32_t)(x)) << FLEXSPI_LUTCR_LOCK_SHIFT)) & FLEXSPI_LUTCR_LOCK_MASK)

#define FLEXSPI_LUTCR_UNLOCK_MASK                (0x2U)
#define FLEXSPI_LUTCR_UNLOCK_SHIFT               (1U)
/*! UNLOCK - Unlock LUT
 */
#define FLEXSPI_LUTCR_UNLOCK(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXSPI_LUTCR_UNLOCK_SHIFT)) & FLEXSPI_LUTCR_UNLOCK_MASK)
/*! @} */

/*! @name AHBRXBUFCR0 - AHB RX Buffer 0 Control Register 0..AHB RX Buffer 7 Control Register 0 */
/*! @{ */

#define FLEXSPI_AHBRXBUFCR0_BUFSZ_MASK           (0x1FFU)
#define FLEXSPI_AHBRXBUFCR0_BUFSZ_SHIFT          (0U)
/*! BUFSZ - AHB RX Buffer Size in 64 bits.
 */
#define FLEXSPI_AHBRXBUFCR0_BUFSZ(x)             (((uint32_t)(((uint32_t)(x)) << FLEXSPI_AHBRXBUFCR0_BUFSZ_SHIFT)) & FLEXSPI_AHBRXBUFCR0_BUFSZ_MASK)

#define FLEXSPI_AHBRXBUFCR0_MSTRID_MASK          (0xF0000U)
#define FLEXSPI_AHBRXBUFCR0_MSTRID_SHIFT         (16U)
/*! MSTRID - This AHB RX Buffer is assigned according to AHB Master with ID (MSTR_ID).
 */
#define FLEXSPI_AHBRXBUFCR0_MSTRID(x)            (((uint32_t)(((uint32_t)(x)) << FLEXSPI_AHBRXBUFCR0_MSTRID_SHIFT)) & FLEXSPI_AHBRXBUFCR0_MSTRID_MASK)

#define FLEXSPI_AHBRXBUFCR0_PRIORITY_MASK        (0x7000000U)
#define FLEXSPI_AHBRXBUFCR0_PRIORITY_SHIFT       (24U)
/*! PRIORITY - This priority for AHB Master Read which this AHB RX Buffer is assigned. 7 is the highest priority, 0 the lowest.
 */
#define FLEXSPI_AHBRXBUFCR0_PRIORITY(x)          (((uint32_t)(((uint32_t)(x)) << FLEXSPI_AHBRXBUFCR0_PRIORITY_SHIFT)) & FLEXSPI_AHBRXBUFCR0_PRIORITY_MASK)

#define FLEXSPI_AHBRXBUFCR0_PREFETCHEN_MASK      (0x80000000U)
#define FLEXSPI_AHBRXBUFCR0_PREFETCHEN_SHIFT     (31U)
/*! PREFETCHEN - AHB Read Prefetch Enable for current AHB RX Buffer corresponding Master.
 */
#define FLEXSPI_AHBRXBUFCR0_PREFETCHEN(x)        (((uint32_t)(((uint32_t)(x)) << FLEXSPI_AHBRXBUFCR0_PREFETCHEN_SHIFT)) & FLEXSPI_AHBRXBUFCR0_PREFETCHEN_MASK)
/*! @} */

/* The count of FLEXSPI_AHBRXBUFCR0 */
#define FLEXSPI_AHBRXBUFCR0_COUNT                (8U)

/*! @name FLSHCR0 - Flash Control Register 0 */
/*! @{ */

#define FLEXSPI_FLSHCR0_FLSHSZ_MASK              (0x7FFFFFU)
#define FLEXSPI_FLSHCR0_FLSHSZ_SHIFT             (0U)
/*! FLSHSZ - Flash Size in KByte.
 */
#define FLEXSPI_FLSHCR0_FLSHSZ(x)                (((uint32_t)(((uint32_t)(x)) << FLEXSPI_FLSHCR0_FLSHSZ_SHIFT)) & FLEXSPI_FLSHCR0_FLSHSZ_MASK)
/*! @} */

/* The count of FLEXSPI_FLSHCR0 */
#define FLEXSPI_FLSHCR0_COUNT                    (4U)

/*! @name FLSHCR1 - Flash Control Register 1 */
/*! @{ */

#define FLEXSPI_FLSHCR1_TCSS_MASK                (0x1FU)
#define FLEXSPI_FLSHCR1_TCSS_SHIFT               (0U)
/*! TCSS - Serial Flash CS setup time.
 */
#define FLEXSPI_FLSHCR1_TCSS(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXSPI_FLSHCR1_TCSS_SHIFT)) & FLEXSPI_FLSHCR1_TCSS_MASK)

#define FLEXSPI_FLSHCR1_TCSH_MASK                (0x3E0U)
#define FLEXSPI_FLSHCR1_TCSH_SHIFT               (5U)
/*! TCSH - Serial Flash CS Hold time.
 */
#define FLEXSPI_FLSHCR1_TCSH(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXSPI_FLSHCR1_TCSH_SHIFT)) & FLEXSPI_FLSHCR1_TCSH_MASK)

#define FLEXSPI_FLSHCR1_WA_MASK                  (0x400U)
#define FLEXSPI_FLSHCR1_WA_SHIFT                 (10U)
/*! WA - Word Addressable.
 */
#define FLEXSPI_FLSHCR1_WA(x)                    (((uint32_t)(((uint32_t)(x)) << FLEXSPI_FLSHCR1_WA_SHIFT)) & FLEXSPI_FLSHCR1_WA_MASK)

#define FLEXSPI_FLSHCR1_CAS_MASK                 (0x7800U)
#define FLEXSPI_FLSHCR1_CAS_SHIFT                (11U)
/*! CAS - Column Address Size.
 */
#define FLEXSPI_FLSHCR1_CAS(x)                   (((uint32_t)(((uint32_t)(x)) << FLEXSPI_FLSHCR1_CAS_SHIFT)) & FLEXSPI_FLSHCR1_CAS_MASK)

#define FLEXSPI_FLSHCR1_CSINTERVALUNIT_MASK      (0x8000U)
#define FLEXSPI_FLSHCR1_CSINTERVALUNIT_SHIFT     (15U)
/*! CSINTERVALUNIT - CS interval unit
 *  0b0..The CS interval unit is 1 serial clock cycle
 *  0b1..The CS interval unit is 256 serial clock cycle
 */
#define FLEXSPI_FLSHCR1_CSINTERVALUNIT(x)        (((uint32_t)(((uint32_t)(x)) << FLEXSPI_FLSHCR1_CSINTERVALUNIT_SHIFT)) & FLEXSPI_FLSHCR1_CSINTERVALUNIT_MASK)

#define FLEXSPI_FLSHCR1_CSINTERVAL_MASK          (0xFFFF0000U)
#define FLEXSPI_FLSHCR1_CSINTERVAL_SHIFT         (16U)
/*! CSINTERVAL - This field is used to set the minimum interval between flash device Chip selection
 *    deassertion and flash device Chip selection assertion. If external flash has a limitation on
 *    the interval between command sequences, this field should be set accordingly. If there is no
 *    limitation, set this field with value 0x0.
 */
#define FLEXSPI_FLSHCR1_CSINTERVAL(x)            (((uint32_t)(((uint32_t)(x)) << FLEXSPI_FLSHCR1_CSINTERVAL_SHIFT)) & FLEXSPI_FLSHCR1_CSINTERVAL_MASK)
/*! @} */

/* The count of FLEXSPI_FLSHCR1 */
#define FLEXSPI_FLSHCR1_COUNT                    (4U)

/*! @name FLSHCR2 - Flash Control Register 2 */
/*! @{ */

#define FLEXSPI_FLSHCR2_ARDSEQID_MASK            (0x1FU)
#define FLEXSPI_FLSHCR2_ARDSEQID_SHIFT           (0U)
/*! ARDSEQID - Sequence Index for AHB Read triggered Command in LUT.
 */
#define FLEXSPI_FLSHCR2_ARDSEQID(x)              (((uint32_t)(((uint32_t)(x)) << FLEXSPI_FLSHCR2_ARDSEQID_SHIFT)) & FLEXSPI_FLSHCR2_ARDSEQID_MASK)

#define FLEXSPI_FLSHCR2_ARDSEQNUM_MASK           (0xE0U)
#define FLEXSPI_FLSHCR2_ARDSEQNUM_SHIFT          (5U)
/*! ARDSEQNUM - Sequence Number for AHB Read triggered Command in LUT.
 */
#define FLEXSPI_FLSHCR2_ARDSEQNUM(x)             (((uint32_t)(((uint32_t)(x)) << FLEXSPI_FLSHCR2_ARDSEQNUM_SHIFT)) & FLEXSPI_FLSHCR2_ARDSEQNUM_MASK)

#define FLEXSPI_FLSHCR2_AWRSEQID_MASK            (0x1F00U)
#define FLEXSPI_FLSHCR2_AWRSEQID_SHIFT           (8U)
/*! AWRSEQID - Sequence Index for AHB Write triggered Command.
 */
#define FLEXSPI_FLSHCR2_AWRSEQID(x)              (((uint32_t)(((uint32_t)(x)) << FLEXSPI_FLSHCR2_AWRSEQID_SHIFT)) & FLEXSPI_FLSHCR2_AWRSEQID_MASK)

#define FLEXSPI_FLSHCR2_AWRSEQNUM_MASK           (0xE000U)
#define FLEXSPI_FLSHCR2_AWRSEQNUM_SHIFT          (13U)
/*! AWRSEQNUM - Sequence Number for AHB Write triggered Command.
 */
#define FLEXSPI_FLSHCR2_AWRSEQNUM(x)             (((uint32_t)(((uint32_t)(x)) << FLEXSPI_FLSHCR2_AWRSEQNUM_SHIFT)) & FLEXSPI_FLSHCR2_AWRSEQNUM_MASK)

#define FLEXSPI_FLSHCR2_AWRWAIT_MASK             (0xFFF0000U)
#define FLEXSPI_FLSHCR2_AWRWAIT_SHIFT            (16U)
#define FLEXSPI_FLSHCR2_AWRWAIT(x)               (((uint32_t)(((uint32_t)(x)) << FLEXSPI_FLSHCR2_AWRWAIT_SHIFT)) & FLEXSPI_FLSHCR2_AWRWAIT_MASK)

#define FLEXSPI_FLSHCR2_AWRWAITUNIT_MASK         (0x70000000U)
#define FLEXSPI_FLSHCR2_AWRWAITUNIT_SHIFT        (28U)
/*! AWRWAITUNIT - AWRWAIT unit
 *  0b000..The AWRWAIT unit is 2 ahb clock cycle
 *  0b001..The AWRWAIT unit is 8 ahb clock cycle
 *  0b010..The AWRWAIT unit is 32 ahb clock cycle
 *  0b011..The AWRWAIT unit is 128 ahb clock cycle
 *  0b100..The AWRWAIT unit is 512 ahb clock cycle
 *  0b101..The AWRWAIT unit is 2048 ahb clock cycle
 *  0b110..The AWRWAIT unit is 8192 ahb clock cycle
 *  0b111..The AWRWAIT unit is 32768 ahb clock cycle
 */
#define FLEXSPI_FLSHCR2_AWRWAITUNIT(x)           (((uint32_t)(((uint32_t)(x)) << FLEXSPI_FLSHCR2_AWRWAITUNIT_SHIFT)) & FLEXSPI_FLSHCR2_AWRWAITUNIT_MASK)

#define FLEXSPI_FLSHCR2_CLRINSTRPTR_MASK         (0x80000000U)
#define FLEXSPI_FLSHCR2_CLRINSTRPTR_SHIFT        (31U)
/*! CLRINSTRPTR - Clear the instruction pointer which is internally saved pointer by JMP_ON_CS.
 *    Refer Programmable Sequence Engine for details.
 */
#define FLEXSPI_FLSHCR2_CLRINSTRPTR(x)           (((uint32_t)(((uint32_t)(x)) << FLEXSPI_FLSHCR2_CLRINSTRPTR_SHIFT)) & FLEXSPI_FLSHCR2_CLRINSTRPTR_MASK)
/*! @} */

/* The count of FLEXSPI_FLSHCR2 */
#define FLEXSPI_FLSHCR2_COUNT                    (4U)

/*! @name FLSHCR4 - Flash Control Register 4 */
/*! @{ */

#define FLEXSPI_FLSHCR4_WMOPT1_MASK              (0x1U)
#define FLEXSPI_FLSHCR4_WMOPT1_SHIFT             (0U)
/*! WMOPT1 - Write mask option bit 1. This option bit could be used to remove AHB write burst start address alignment limitation.
 *  0b0..DQS pin will be used as Write Mask when writing to external device. There is no limitation on AHB write
 *       burst start address alignment when flash is accessed in individual mode.
 *  0b1..DQS pin will not be used as Write Mask when writing to external device. There is limitation on AHB write
 *       burst start address alignment when flash is accessed in individual mode.
 */
#define FLEXSPI_FLSHCR4_WMOPT1(x)                (((uint32_t)(((uint32_t)(x)) << FLEXSPI_FLSHCR4_WMOPT1_SHIFT)) & FLEXSPI_FLSHCR4_WMOPT1_MASK)

#define FLEXSPI_FLSHCR4_WMENA_MASK               (0x4U)
#define FLEXSPI_FLSHCR4_WMENA_SHIFT              (2U)
/*! WMENA - Write mask enable bit for flash device on port A. When write mask function is needed for
 *    memory device on port A, this bit must be set.
 *  0b0..Write mask is disabled, DQS(RWDS) pin will be un-driven when writing to external device.
 *  0b1..Write mask is enabled, DQS(RWDS) pin will be driven by FlexSPI as write mask output when writing to external device.
 */
#define FLEXSPI_FLSHCR4_WMENA(x)                 (((uint32_t)(((uint32_t)(x)) << FLEXSPI_FLSHCR4_WMENA_SHIFT)) & FLEXSPI_FLSHCR4_WMENA_MASK)

#define FLEXSPI_FLSHCR4_WMENB_MASK               (0x8U)
#define FLEXSPI_FLSHCR4_WMENB_SHIFT              (3U)
/*! WMENB - Write mask enable bit for flash device on port B. When write mask function is needed for
 *    memory device on port B, this bit must be set.
 *  0b0..Write mask is disabled, DQS(RWDS) pin will be un-driven when writing to external device.
 *  0b1..Write mask is enabled, DQS(RWDS) pin will be driven by FlexSPI as write mask output when writing to external device.
 */
#define FLEXSPI_FLSHCR4_WMENB(x)                 (((uint32_t)(((uint32_t)(x)) << FLEXSPI_FLSHCR4_WMENB_SHIFT)) & FLEXSPI_FLSHCR4_WMENB_MASK)
/*! @} */

/*! @name IPCR0 - IP Control Register 0 */
/*! @{ */

#define FLEXSPI_IPCR0_SFAR_MASK                  (0xFFFFFFFFU)
#define FLEXSPI_IPCR0_SFAR_SHIFT                 (0U)
/*! SFAR - Serial Flash Address for IP command.
 */
#define FLEXSPI_IPCR0_SFAR(x)                    (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPCR0_SFAR_SHIFT)) & FLEXSPI_IPCR0_SFAR_MASK)
/*! @} */

/*! @name IPCR1 - IP Control Register 1 */
/*! @{ */

#define FLEXSPI_IPCR1_IDATSZ_MASK                (0xFFFFU)
#define FLEXSPI_IPCR1_IDATSZ_SHIFT               (0U)
/*! IDATSZ - Flash Read/Program Data Size (in Bytes) for IP command.
 */
#define FLEXSPI_IPCR1_IDATSZ(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPCR1_IDATSZ_SHIFT)) & FLEXSPI_IPCR1_IDATSZ_MASK)

#define FLEXSPI_IPCR1_ISEQID_MASK                (0x1F0000U)
#define FLEXSPI_IPCR1_ISEQID_SHIFT               (16U)
/*! ISEQID - Sequence Index in LUT for IP command.
 */
#define FLEXSPI_IPCR1_ISEQID(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPCR1_ISEQID_SHIFT)) & FLEXSPI_IPCR1_ISEQID_MASK)

#define FLEXSPI_IPCR1_ISEQNUM_MASK               (0x7000000U)
#define FLEXSPI_IPCR1_ISEQNUM_SHIFT              (24U)
/*! ISEQNUM - Sequence Number for IP command: ISEQNUM+1.
 */
#define FLEXSPI_IPCR1_ISEQNUM(x)                 (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPCR1_ISEQNUM_SHIFT)) & FLEXSPI_IPCR1_ISEQNUM_MASK)

#define FLEXSPI_IPCR1_IPAREN_MASK                (0x80000000U)
#define FLEXSPI_IPCR1_IPAREN_SHIFT               (31U)
/*! IPAREN - Parallel mode Enabled for IP command.
 *  0b0..Flash will be accessed in Individual mode.
 *  0b1..Flash will be accessed in Parallel mode.
 */
#define FLEXSPI_IPCR1_IPAREN(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPCR1_IPAREN_SHIFT)) & FLEXSPI_IPCR1_IPAREN_MASK)
/*! @} */

/*! @name IPCMD - IP Command Register */
/*! @{ */

#define FLEXSPI_IPCMD_TRG_MASK                   (0x1U)
#define FLEXSPI_IPCMD_TRG_SHIFT                  (0U)
/*! TRG - Setting this bit will trigger an IP Command.
 */
#define FLEXSPI_IPCMD_TRG(x)                     (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPCMD_TRG_SHIFT)) & FLEXSPI_IPCMD_TRG_MASK)
/*! @} */

/*! @name DLPR - Data Learn Pattern Register */
/*! @{ */

#define FLEXSPI_DLPR_DLP_MASK                    (0xFFFFFFFFU)
#define FLEXSPI_DLPR_DLP_SHIFT                   (0U)
/*! DLP - Data Learning Pattern.
 */
#define FLEXSPI_DLPR_DLP(x)                      (((uint32_t)(((uint32_t)(x)) << FLEXSPI_DLPR_DLP_SHIFT)) & FLEXSPI_DLPR_DLP_MASK)
/*! @} */

/*! @name IPRXFCR - IP RX FIFO Control Register */
/*! @{ */

#define FLEXSPI_IPRXFCR_CLRIPRXF_MASK            (0x1U)
#define FLEXSPI_IPRXFCR_CLRIPRXF_SHIFT           (0U)
/*! CLRIPRXF - Clear all valid data entries in IP RX FIFO.
 */
#define FLEXSPI_IPRXFCR_CLRIPRXF(x)              (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPRXFCR_CLRIPRXF_SHIFT)) & FLEXSPI_IPRXFCR_CLRIPRXF_MASK)

#define FLEXSPI_IPRXFCR_RXDMAEN_MASK             (0x2U)
#define FLEXSPI_IPRXFCR_RXDMAEN_SHIFT            (1U)
/*! RXDMAEN - IP RX FIFO reading by DMA enabled.
 *  0b0..IP RX FIFO would be read by processor.
 *  0b1..IP RX FIFO would be read by DMA.
 */
#define FLEXSPI_IPRXFCR_RXDMAEN(x)               (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPRXFCR_RXDMAEN_SHIFT)) & FLEXSPI_IPRXFCR_RXDMAEN_MASK)

#define FLEXSPI_IPRXFCR_RXWMRK_MASK              (0xFCU)
#define FLEXSPI_IPRXFCR_RXWMRK_SHIFT             (2U)
/*! RXWMRK - Watermark level is (RXWMRK+1)*64 Bits.
 */
#define FLEXSPI_IPRXFCR_RXWMRK(x)                (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPRXFCR_RXWMRK_SHIFT)) & FLEXSPI_IPRXFCR_RXWMRK_MASK)
/*! @} */

/*! @name IPTXFCR - IP TX FIFO Control Register */
/*! @{ */

#define FLEXSPI_IPTXFCR_CLRIPTXF_MASK            (0x1U)
#define FLEXSPI_IPTXFCR_CLRIPTXF_SHIFT           (0U)
/*! CLRIPTXF - Clear all valid data entries in IP TX FIFO.
 */
#define FLEXSPI_IPTXFCR_CLRIPTXF(x)              (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPTXFCR_CLRIPTXF_SHIFT)) & FLEXSPI_IPTXFCR_CLRIPTXF_MASK)

#define FLEXSPI_IPTXFCR_TXDMAEN_MASK             (0x2U)
#define FLEXSPI_IPTXFCR_TXDMAEN_SHIFT            (1U)
/*! TXDMAEN - IP TX FIFO filling by DMA enabled.
 *  0b0..IP TX FIFO would be filled by processor.
 *  0b1..IP TX FIFO would be filled by DMA.
 */
#define FLEXSPI_IPTXFCR_TXDMAEN(x)               (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPTXFCR_TXDMAEN_SHIFT)) & FLEXSPI_IPTXFCR_TXDMAEN_MASK)

#define FLEXSPI_IPTXFCR_TXWMRK_MASK              (0x1FCU)
#define FLEXSPI_IPTXFCR_TXWMRK_SHIFT             (2U)
/*! TXWMRK - Watermark level is (TXWMRK+1)*64 Bits.
 */
#define FLEXSPI_IPTXFCR_TXWMRK(x)                (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPTXFCR_TXWMRK_SHIFT)) & FLEXSPI_IPTXFCR_TXWMRK_MASK)
/*! @} */

/*! @name DLLCR - DLL Control Register 0 */
/*! @{ */

#define FLEXSPI_DLLCR_DLLEN_MASK                 (0x1U)
#define FLEXSPI_DLLCR_DLLEN_SHIFT                (0U)
/*! DLLEN - DLL calibration enable.
 */
#define FLEXSPI_DLLCR_DLLEN(x)                   (((uint32_t)(((uint32_t)(x)) << FLEXSPI_DLLCR_DLLEN_SHIFT)) & FLEXSPI_DLLCR_DLLEN_MASK)

#define FLEXSPI_DLLCR_DLLRESET_MASK              (0x2U)
#define FLEXSPI_DLLCR_DLLRESET_SHIFT             (1U)
/*! DLLRESET - Software could force a reset on DLL by setting this field to 0x1. This will cause the
 *    DLL to lose lock and re-calibrate to detect an ref_clock half period phase shift. The reset
 *    action is edge triggered, so software need to clear this bit after set this bit (no delay
 *    limitation).
 */
#define FLEXSPI_DLLCR_DLLRESET(x)                (((uint32_t)(((uint32_t)(x)) << FLEXSPI_DLLCR_DLLRESET_SHIFT)) & FLEXSPI_DLLCR_DLLRESET_MASK)

#define FLEXSPI_DLLCR_SLVDLYTARGET_MASK          (0x78U)
#define FLEXSPI_DLLCR_SLVDLYTARGET_SHIFT         (3U)
/*! SLVDLYTARGET - The delay target for slave delay line is: ((SLVDLYTARGET+1) * 1/32 * clock cycle
 *    of reference clock (serial root clock). If serial root clock is >= 100 MHz, DLLEN set to 0x1,
 *    OVRDEN set to =0x0, then SLVDLYTARGET setting of 0xF is recommended.
 */
#define FLEXSPI_DLLCR_SLVDLYTARGET(x)            (((uint32_t)(((uint32_t)(x)) << FLEXSPI_DLLCR_SLVDLYTARGET_SHIFT)) & FLEXSPI_DLLCR_SLVDLYTARGET_MASK)

#define FLEXSPI_DLLCR_OVRDEN_MASK                (0x100U)
#define FLEXSPI_DLLCR_OVRDEN_SHIFT               (8U)
/*! OVRDEN - Slave clock delay line delay cell number selection override enable.
 */
#define FLEXSPI_DLLCR_OVRDEN(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXSPI_DLLCR_OVRDEN_SHIFT)) & FLEXSPI_DLLCR_OVRDEN_MASK)

#define FLEXSPI_DLLCR_OVRDVAL_MASK               (0x7E00U)
#define FLEXSPI_DLLCR_OVRDVAL_SHIFT              (9U)
/*! OVRDVAL - Slave clock delay line delay cell number selection override value.
 */
#define FLEXSPI_DLLCR_OVRDVAL(x)                 (((uint32_t)(((uint32_t)(x)) << FLEXSPI_DLLCR_OVRDVAL_SHIFT)) & FLEXSPI_DLLCR_OVRDVAL_MASK)
/*! @} */

/* The count of FLEXSPI_DLLCR */
#define FLEXSPI_DLLCR_COUNT                      (2U)

/*! @name STS0 - Status Register 0 */
/*! @{ */

#define FLEXSPI_STS0_SEQIDLE_MASK                (0x1U)
#define FLEXSPI_STS0_SEQIDLE_SHIFT               (0U)
/*! SEQIDLE - This status bit indicates the state machine in SEQ_CTL is idle and there is command
 *    sequence executing on FlexSPI interface.
 */
#define FLEXSPI_STS0_SEQIDLE(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXSPI_STS0_SEQIDLE_SHIFT)) & FLEXSPI_STS0_SEQIDLE_MASK)

#define FLEXSPI_STS0_ARBIDLE_MASK                (0x2U)
#define FLEXSPI_STS0_ARBIDLE_SHIFT               (1U)
/*! ARBIDLE - This status bit indicates the state machine in ARB_CTL is busy and there is command
 *    sequence granted by arbitrator and not finished yet on FlexSPI interface. When ARB_CTL state
 *    (ARBIDLE=0x1) is idle, there will be no transaction on FlexSPI interface also (SEQIDLE=0x1). So
 *    this bit should be polled to wait for FlexSPI controller become idle instead of SEQIDLE.
 */
#define FLEXSPI_STS0_ARBIDLE(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXSPI_STS0_ARBIDLE_SHIFT)) & FLEXSPI_STS0_ARBIDLE_MASK)

#define FLEXSPI_STS0_ARBCMDSRC_MASK              (0xCU)
#define FLEXSPI_STS0_ARBCMDSRC_SHIFT             (2U)
/*! ARBCMDSRC - This status field indicates the trigger source of current command sequence granted
 *    by arbitrator. This field value is meaningless when ARB_CTL is not busy (STS0[ARBIDLE]=0x1).
 *  0b00..Triggered by AHB read command (triggered by AHB read).
 *  0b01..Triggered by AHB write command (triggered by AHB Write).
 *  0b10..Triggered by IP command (triggered by setting register bit IPCMD.TRG).
 *  0b11..Triggered by suspended command (resumed).
 */
#define FLEXSPI_STS0_ARBCMDSRC(x)                (((uint32_t)(((uint32_t)(x)) << FLEXSPI_STS0_ARBCMDSRC_SHIFT)) & FLEXSPI_STS0_ARBCMDSRC_MASK)

#define FLEXSPI_STS0_DATALEARNPHASEA_MASK        (0xF0U)
#define FLEXSPI_STS0_DATALEARNPHASEA_SHIFT       (4U)
/*! DATALEARNPHASEA - Indicate the sampling clock phase selection on Port A after Data Learning.
 */
#define FLEXSPI_STS0_DATALEARNPHASEA(x)          (((uint32_t)(((uint32_t)(x)) << FLEXSPI_STS0_DATALEARNPHASEA_SHIFT)) & FLEXSPI_STS0_DATALEARNPHASEA_MASK)

#define FLEXSPI_STS0_DATALEARNPHASEB_MASK        (0xF00U)
#define FLEXSPI_STS0_DATALEARNPHASEB_SHIFT       (8U)
/*! DATALEARNPHASEB - Indicate the sampling clock phase selection on Port B after Data Learning.
 */
#define FLEXSPI_STS0_DATALEARNPHASEB(x)          (((uint32_t)(((uint32_t)(x)) << FLEXSPI_STS0_DATALEARNPHASEB_SHIFT)) & FLEXSPI_STS0_DATALEARNPHASEB_MASK)
/*! @} */

/*! @name STS1 - Status Register 1 */
/*! @{ */

#define FLEXSPI_STS1_AHBCMDERRID_MASK            (0x1FU)
#define FLEXSPI_STS1_AHBCMDERRID_SHIFT           (0U)
/*! AHBCMDERRID - Indicates the sequence index when an AHB command error is detected. This field
 *    will be cleared when INTR[AHBCMDERR] is write-1-clear(w1c).
 */
#define FLEXSPI_STS1_AHBCMDERRID(x)              (((uint32_t)(((uint32_t)(x)) << FLEXSPI_STS1_AHBCMDERRID_SHIFT)) & FLEXSPI_STS1_AHBCMDERRID_MASK)

#define FLEXSPI_STS1_AHBCMDERRCODE_MASK          (0xF00U)
#define FLEXSPI_STS1_AHBCMDERRCODE_SHIFT         (8U)
/*! AHBCMDERRCODE - Indicates the Error Code when AHB command Error detected. This field will be
 *    cleared when INTR[AHBCMDERR] is write-1-clear(w1c).
 *  0b0000..No error.
 *  0b0010..AHB Write command with JMP_ON_CS instruction used in the sequence.
 *  0b0011..There is unknown instruction opcode in the sequence.
 *  0b0100..Instruction DUMMY_SDR/DUMMY_RWDS_SDR used in DDR sequence.
 *  0b0101..Instruction DUMMY_DDR/DUMMY_RWDS_DDR used in SDR sequence.
 *  0b1110..Sequence execution timeout.
 */
#define FLEXSPI_STS1_AHBCMDERRCODE(x)            (((uint32_t)(((uint32_t)(x)) << FLEXSPI_STS1_AHBCMDERRCODE_SHIFT)) & FLEXSPI_STS1_AHBCMDERRCODE_MASK)

#define FLEXSPI_STS1_IPCMDERRID_MASK             (0x1F0000U)
#define FLEXSPI_STS1_IPCMDERRID_SHIFT            (16U)
/*! IPCMDERRID - Indicates the sequence Index when IP command error detected. This field will be
 *    cleared when INTR[IPCMDERR] is write-1-clear(w1c).
 */
#define FLEXSPI_STS1_IPCMDERRID(x)               (((uint32_t)(((uint32_t)(x)) << FLEXSPI_STS1_IPCMDERRID_SHIFT)) & FLEXSPI_STS1_IPCMDERRID_MASK)

#define FLEXSPI_STS1_IPCMDERRCODE_MASK           (0xF000000U)
#define FLEXSPI_STS1_IPCMDERRCODE_SHIFT          (24U)
/*! IPCMDERRCODE - Indicates the Error Code when IP command Error detected. This field will be
 *    cleared when INTR[IPCMDERR] is write-1-clear(w1c).
 *  0b0000..No error.
 *  0b0010..IP command with JMP_ON_CS instruction used in the sequence.
 *  0b0011..There is unknown instruction opcode in the sequence.
 *  0b0100..Instruction DUMMY_SDR/DUMMY_RWDS_SDR used in DDR sequence.
 *  0b0101..Instruction DUMMY_DDR/DUMMY_RWDS_DDR used in SDR sequence.
 *  0b0110..Flash access start address exceed the whole flash address range (A1/A2/B1/B2).
 *  0b1110..Sequence execution timeout.
 *  0b1111..Flash boundary crossed.
 */
#define FLEXSPI_STS1_IPCMDERRCODE(x)             (((uint32_t)(((uint32_t)(x)) << FLEXSPI_STS1_IPCMDERRCODE_SHIFT)) & FLEXSPI_STS1_IPCMDERRCODE_MASK)
/*! @} */

/*! @name STS2 - Status Register 2 */
/*! @{ */

#define FLEXSPI_STS2_ASLVLOCK_MASK               (0x1U)
#define FLEXSPI_STS2_ASLVLOCK_SHIFT              (0U)
/*! ASLVLOCK - Flash A sample clock slave delay line locked.
 */
#define FLEXSPI_STS2_ASLVLOCK(x)                 (((uint32_t)(((uint32_t)(x)) << FLEXSPI_STS2_ASLVLOCK_SHIFT)) & FLEXSPI_STS2_ASLVLOCK_MASK)

#define FLEXSPI_STS2_AREFLOCK_MASK               (0x2U)
#define FLEXSPI_STS2_AREFLOCK_SHIFT              (1U)
/*! AREFLOCK - Flash A sample clock reference delay line locked.
 */
#define FLEXSPI_STS2_AREFLOCK(x)                 (((uint32_t)(((uint32_t)(x)) << FLEXSPI_STS2_AREFLOCK_SHIFT)) & FLEXSPI_STS2_AREFLOCK_MASK)

#define FLEXSPI_STS2_ASLVSEL_MASK                (0xFCU)
#define FLEXSPI_STS2_ASLVSEL_SHIFT               (2U)
/*! ASLVSEL - Flash A sample clock slave delay line delay cell number selection .
 */
#define FLEXSPI_STS2_ASLVSEL(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXSPI_STS2_ASLVSEL_SHIFT)) & FLEXSPI_STS2_ASLVSEL_MASK)

#define FLEXSPI_STS2_AREFSEL_MASK                (0x3F00U)
#define FLEXSPI_STS2_AREFSEL_SHIFT               (8U)
/*! AREFSEL - Flash A sample clock reference delay line delay cell number selection.
 */
#define FLEXSPI_STS2_AREFSEL(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXSPI_STS2_AREFSEL_SHIFT)) & FLEXSPI_STS2_AREFSEL_MASK)

#define FLEXSPI_STS2_BSLVLOCK_MASK               (0x10000U)
#define FLEXSPI_STS2_BSLVLOCK_SHIFT              (16U)
/*! BSLVLOCK - Flash B sample clock slave delay line locked.
 */
#define FLEXSPI_STS2_BSLVLOCK(x)                 (((uint32_t)(((uint32_t)(x)) << FLEXSPI_STS2_BSLVLOCK_SHIFT)) & FLEXSPI_STS2_BSLVLOCK_MASK)

#define FLEXSPI_STS2_BREFLOCK_MASK               (0x20000U)
#define FLEXSPI_STS2_BREFLOCK_SHIFT              (17U)
/*! BREFLOCK - Flash B sample clock reference delay line locked.
 */
#define FLEXSPI_STS2_BREFLOCK(x)                 (((uint32_t)(((uint32_t)(x)) << FLEXSPI_STS2_BREFLOCK_SHIFT)) & FLEXSPI_STS2_BREFLOCK_MASK)

#define FLEXSPI_STS2_BSLVSEL_MASK                (0xFC0000U)
#define FLEXSPI_STS2_BSLVSEL_SHIFT               (18U)
/*! BSLVSEL - Flash B sample clock slave delay line delay cell number selection.
 */
#define FLEXSPI_STS2_BSLVSEL(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXSPI_STS2_BSLVSEL_SHIFT)) & FLEXSPI_STS2_BSLVSEL_MASK)

#define FLEXSPI_STS2_BREFSEL_MASK                (0x3F000000U)
#define FLEXSPI_STS2_BREFSEL_SHIFT               (24U)
/*! BREFSEL - Flash B sample clock reference delay line delay cell number selection.
 */
#define FLEXSPI_STS2_BREFSEL(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXSPI_STS2_BREFSEL_SHIFT)) & FLEXSPI_STS2_BREFSEL_MASK)
/*! @} */

/*! @name AHBSPNDSTS - AHB Suspend Status Register */
/*! @{ */

#define FLEXSPI_AHBSPNDSTS_ACTIVE_MASK           (0x1U)
#define FLEXSPI_AHBSPNDSTS_ACTIVE_SHIFT          (0U)
/*! ACTIVE - Indicates if an AHB read prefetch command sequence has been suspended.
 */
#define FLEXSPI_AHBSPNDSTS_ACTIVE(x)             (((uint32_t)(((uint32_t)(x)) << FLEXSPI_AHBSPNDSTS_ACTIVE_SHIFT)) & FLEXSPI_AHBSPNDSTS_ACTIVE_MASK)

#define FLEXSPI_AHBSPNDSTS_BUFID_MASK            (0xEU)
#define FLEXSPI_AHBSPNDSTS_BUFID_SHIFT           (1U)
/*! BUFID - AHB RX BUF ID for suspended command sequence.
 */
#define FLEXSPI_AHBSPNDSTS_BUFID(x)              (((uint32_t)(((uint32_t)(x)) << FLEXSPI_AHBSPNDSTS_BUFID_SHIFT)) & FLEXSPI_AHBSPNDSTS_BUFID_MASK)

#define FLEXSPI_AHBSPNDSTS_DATLFT_MASK           (0xFFFF0000U)
#define FLEXSPI_AHBSPNDSTS_DATLFT_SHIFT          (16U)
/*! DATLFT - Left Data size for suspended command sequence (in byte).
 */
#define FLEXSPI_AHBSPNDSTS_DATLFT(x)             (((uint32_t)(((uint32_t)(x)) << FLEXSPI_AHBSPNDSTS_DATLFT_SHIFT)) & FLEXSPI_AHBSPNDSTS_DATLFT_MASK)
/*! @} */

/*! @name IPRXFSTS - IP RX FIFO Status Register */
/*! @{ */

#define FLEXSPI_IPRXFSTS_FILL_MASK               (0xFFU)
#define FLEXSPI_IPRXFSTS_FILL_SHIFT              (0U)
/*! FILL - Fill level of IP RX FIFO.
 */
#define FLEXSPI_IPRXFSTS_FILL(x)                 (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPRXFSTS_FILL_SHIFT)) & FLEXSPI_IPRXFSTS_FILL_MASK)

#define FLEXSPI_IPRXFSTS_RDCNTR_MASK             (0xFFFF0000U)
#define FLEXSPI_IPRXFSTS_RDCNTR_SHIFT            (16U)
/*! RDCNTR - Total Read Data Counter: RDCNTR * 64 Bits.
 */
#define FLEXSPI_IPRXFSTS_RDCNTR(x)               (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPRXFSTS_RDCNTR_SHIFT)) & FLEXSPI_IPRXFSTS_RDCNTR_MASK)
/*! @} */

/*! @name IPTXFSTS - IP TX FIFO Status Register */
/*! @{ */

#define FLEXSPI_IPTXFSTS_FILL_MASK               (0xFFU)
#define FLEXSPI_IPTXFSTS_FILL_SHIFT              (0U)
/*! FILL - Fill level of IP TX FIFO.
 */
#define FLEXSPI_IPTXFSTS_FILL(x)                 (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPTXFSTS_FILL_SHIFT)) & FLEXSPI_IPTXFSTS_FILL_MASK)

#define FLEXSPI_IPTXFSTS_WRCNTR_MASK             (0xFFFF0000U)
#define FLEXSPI_IPTXFSTS_WRCNTR_SHIFT            (16U)
/*! WRCNTR - Total Write Data Counter: WRCNTR * 64 Bits.
 */
#define FLEXSPI_IPTXFSTS_WRCNTR(x)               (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPTXFSTS_WRCNTR_SHIFT)) & FLEXSPI_IPTXFSTS_WRCNTR_MASK)
/*! @} */

/*! @name RFDR - IP RX FIFO Data Register 0..IP RX FIFO Data Register 31 */
/*! @{ */

#define FLEXSPI_RFDR_RXDATA_MASK                 (0xFFFFFFFFU)
#define FLEXSPI_RFDR_RXDATA_SHIFT                (0U)
/*! RXDATA - RX Data
 */
#define FLEXSPI_RFDR_RXDATA(x)                   (((uint32_t)(((uint32_t)(x)) << FLEXSPI_RFDR_RXDATA_SHIFT)) & FLEXSPI_RFDR_RXDATA_MASK)
/*! @} */

/* The count of FLEXSPI_RFDR */
#define FLEXSPI_RFDR_COUNT                       (32U)

/*! @name TFDR - IP TX FIFO Data Register 0..IP TX FIFO Data Register 31 */
/*! @{ */

#define FLEXSPI_TFDR_TXDATA_MASK                 (0xFFFFFFFFU)
#define FLEXSPI_TFDR_TXDATA_SHIFT                (0U)
/*! TXDATA - TX Data
 */
#define FLEXSPI_TFDR_TXDATA(x)                   (((uint32_t)(((uint32_t)(x)) << FLEXSPI_TFDR_TXDATA_SHIFT)) & FLEXSPI_TFDR_TXDATA_MASK)
/*! @} */

/* The count of FLEXSPI_TFDR */
#define FLEXSPI_TFDR_COUNT                       (32U)

/*! @name LUT - LUT 0..LUT 127 */
/*! @{ */

#define FLEXSPI_LUT_OPERAND0_MASK                (0xFFU)
#define FLEXSPI_LUT_OPERAND0_SHIFT               (0U)
/*! OPERAND0 - OPERAND0
 */
#define FLEXSPI_LUT_OPERAND0(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXSPI_LUT_OPERAND0_SHIFT)) & FLEXSPI_LUT_OPERAND0_MASK)

#define FLEXSPI_LUT_NUM_PADS0_MASK               (0x300U)
#define FLEXSPI_LUT_NUM_PADS0_SHIFT              (8U)
/*! NUM_PADS0 - NUM_PADS0
 */
#define FLEXSPI_LUT_NUM_PADS0(x)                 (((uint32_t)(((uint32_t)(x)) << FLEXSPI_LUT_NUM_PADS0_SHIFT)) & FLEXSPI_LUT_NUM_PADS0_MASK)

#define FLEXSPI_LUT_OPCODE0_MASK                 (0xFC00U)
#define FLEXSPI_LUT_OPCODE0_SHIFT                (10U)
/*! OPCODE0 - OPCODE
 */
#define FLEXSPI_LUT_OPCODE0(x)                   (((uint32_t)(((uint32_t)(x)) << FLEXSPI_LUT_OPCODE0_SHIFT)) & FLEXSPI_LUT_OPCODE0_MASK)

#define FLEXSPI_LUT_OPERAND1_MASK                (0xFF0000U)
#define FLEXSPI_LUT_OPERAND1_SHIFT               (16U)
/*! OPERAND1 - OPERAND1
 */
#define FLEXSPI_LUT_OPERAND1(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXSPI_LUT_OPERAND1_SHIFT)) & FLEXSPI_LUT_OPERAND1_MASK)

#define FLEXSPI_LUT_NUM_PADS1_MASK               (0x3000000U)
#define FLEXSPI_LUT_NUM_PADS1_SHIFT              (24U)
/*! NUM_PADS1 - NUM_PADS1
 */
#define FLEXSPI_LUT_NUM_PADS1(x)                 (((uint32_t)(((uint32_t)(x)) << FLEXSPI_LUT_NUM_PADS1_SHIFT)) & FLEXSPI_LUT_NUM_PADS1_MASK)

#define FLEXSPI_LUT_OPCODE1_MASK                 (0xFC000000U)
#define FLEXSPI_LUT_OPCODE1_SHIFT                (26U)
/*! OPCODE1 - OPCODE1
 */
#define FLEXSPI_LUT_OPCODE1(x)                   (((uint32_t)(((uint32_t)(x)) << FLEXSPI_LUT_OPCODE1_SHIFT)) & FLEXSPI_LUT_OPCODE1_MASK)
/*! @} */

/* The count of FLEXSPI_LUT */
#define FLEXSPI_LUT_COUNT                        (128U)


/*!
 * @}
 */ /* end of group FLEXSPI_Register_Masks */


/* FLEXSPI - Peripheral instance base addresses */
/** Peripheral FLEXSPI base address */
#define FLEXSPI_BASE                             (0x40134000u)
/** Peripheral FLEXSPI base pointer */
#define FLEXSPI                                  ((FLEXSPI_Type *)FLEXSPI_BASE)
/** Array initializer of FLEXSPI peripheral base addresses */
#define FLEXSPI_BASE_ADDRS                       { FLEXSPI_BASE }
/** Array initializer of FLEXSPI peripheral base pointers */
#define FLEXSPI_BASE_PTRS                        { FLEXSPI }
/** Interrupt vectors for the FLEXSPI peripheral type */
#define FLEXSPI_IRQS                             { FLEXSPI_IRQn }
/* FlexSPI AMBA address. */
#define FlexSPI_AMBA_BASE                       (0x08000000U)
/* FlexSPI ASFM address. */
#define FlexSPI_ASFM_BASE                        (0x00000000U)
/* Base Address of AHB address space mapped to IP RX FIFO. */
#define FlexSPI_ARDF_BASE                        (0x10000000U)
/* Base Address of AHB address space mapped to IP TX FIFO. */
#define FlexSPI_ATDF_BASE                        (0x11000000U)


/*!
 * @}
 */ /* end of group FLEXSPI_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- FREQME Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FREQME_Peripheral_Access_Layer FREQME Peripheral Access Layer
 * @{
 */

/** FREQME - Register Layout Typedef */
typedef struct {
  union {                                          /* offset: 0x0 */
    __I  uint32_t FREQMECTRL_R;                      /**< Frequency Measurement (in Read mode), offset: 0x0 */
    __O  uint32_t FREQMECTRL_W;                      /**< Freqeuncy Measurement (in Write mode), offset: 0x0 */
  };
} FREQME_Type;

/* ----------------------------------------------------------------------------
   -- FREQME Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FREQME_Register_Masks FREQME Register Masks
 * @{
 */

/*! @name FREQMECTRL_R - Frequency Measurement (in Read mode) */
/*! @{ */

#define FREQME_FREQMECTRL_R_RESULT_MASK          (0x7FFFFFFFU)
#define FREQME_FREQMECTRL_R_RESULT_SHIFT         (0U)
/*! RESULT - Result
 */
#define FREQME_FREQMECTRL_R_RESULT(x)            (((uint32_t)(((uint32_t)(x)) << FREQME_FREQMECTRL_R_RESULT_SHIFT)) & FREQME_FREQMECTRL_R_RESULT_MASK)

#define FREQME_FREQMECTRL_R_MEASURE_IN_PROGRESS_MASK (0x80000000U)
#define FREQME_FREQMECTRL_R_MEASURE_IN_PROGRESS_SHIFT (31U)
/*! MEASURE_IN_PROGRESS - Measure in Progress
 *  0b0..Process complete. Measurement cycle is complete. The results are ready in the RESULT field.
 *  0b1..In Progress. Measurement cycle is in progress.
 */
#define FREQME_FREQMECTRL_R_MEASURE_IN_PROGRESS(x) (((uint32_t)(((uint32_t)(x)) << FREQME_FREQMECTRL_R_MEASURE_IN_PROGRESS_SHIFT)) & FREQME_FREQMECTRL_R_MEASURE_IN_PROGRESS_MASK)
/*! @} */

/*! @name FREQMECTRL_W - Freqeuncy Measurement (in Write mode) */
/*! @{ */

#define FREQME_FREQMECTRL_W_REF_SCALE_MASK       (0x1FU)
#define FREQME_FREQMECTRL_W_REF_SCALE_SHIFT      (0U)
/*! REF_SCALE - Reference Clock Scaling Factor
 *  0b00000..Count cycle = 2^0 = 1
 *  0b00001..Count cycle = 2^1 = 2
 *  0b00010..Count cycle = 2^4 = 4
 *  0b11111..Count cycle = 2^31 = 2,147,483,648
 */
#define FREQME_FREQMECTRL_W_REF_SCALE(x)         (((uint32_t)(((uint32_t)(x)) << FREQME_FREQMECTRL_W_REF_SCALE_SHIFT)) & FREQME_FREQMECTRL_W_REF_SCALE_MASK)

#define FREQME_FREQMECTRL_W_PULSE_MODE_MASK      (0x100U)
#define FREQME_FREQMECTRL_W_PULSE_MODE_SHIFT     (8U)
/*! PULSE_MODE - Pulse Width Measurement mode select
 *  0b0..Frequency Measurement Mode. FREQMECTRL works in a Frequency Measurement mode. Once the measurement starts
 *       (real count start is aligned at rising edge arrival on reference clock), the target counter increments by
 *       the target clock until the reference counter running by the reference clock reaches the count end point
 *       selected by REF_SCALE.
 *  0b1..Pulse Width Measurement mode. FREQMECTRL works in a Pulse Width Measurement mode, measuring the high or
 *       low period of reference clock input selected by PULSE_POL. The target counter starts incrementing by the
 *       target clock once a corresponding trigger edge (rising edge for high period measurement and falling edge for
 *       low period) occurs.
 */
#define FREQME_FREQMECTRL_W_PULSE_MODE(x)        (((uint32_t)(((uint32_t)(x)) << FREQME_FREQMECTRL_W_PULSE_MODE_SHIFT)) & FREQME_FREQMECTRL_W_PULSE_MODE_MASK)

#define FREQME_FREQMECTRL_W_PULSE_POL_MASK       (0x200U)
#define FREQME_FREQMECTRL_W_PULSE_POL_SHIFT      (9U)
/*! PULSE_POL - Pulse Polarity
 *  0b0..High Period. High period of reference clock is measured in Pulse Width Measurement mode triggered by the
 *       rising edge on the reference clock input.
 *  0b1..Low Period. Low period of reference clock is measured in Pulse Width Measurement mode triggered by the
 *       falling edge on the reference clock input.
 */
#define FREQME_FREQMECTRL_W_PULSE_POL(x)         (((uint32_t)(((uint32_t)(x)) << FREQME_FREQMECTRL_W_PULSE_POL_SHIFT)) & FREQME_FREQMECTRL_W_PULSE_POL_MASK)

#define FREQME_FREQMECTRL_W_MEASURE_IN_PROGRESS_MASK (0x80000000U)
#define FREQME_FREQMECTRL_W_MEASURE_IN_PROGRESS_SHIFT (31U)
/*! MEASURE_IN_PROGRESS - Measure in Progress
 *  0b0..Force Terminate. Forces the termination of any measurement cycle currently in progress and resets RESULT or just resets RESULT if in idle.
 *  0b1..Initiates Measurement Cycle. Initiates frequency or pulse width measurement process. Hardware clears the
 *       MEASURE_IN_PROGRESS bit when the measurement cycle completes. A new measurement starts if there is an
 *       active measurement in progress.
 */
#define FREQME_FREQMECTRL_W_MEASURE_IN_PROGRESS(x) (((uint32_t)(((uint32_t)(x)) << FREQME_FREQMECTRL_W_MEASURE_IN_PROGRESS_SHIFT)) & FREQME_FREQMECTRL_W_MEASURE_IN_PROGRESS_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group FREQME_Register_Masks */


/* FREQME - Peripheral instance base addresses */
/** Peripheral FREQME base address */
#define FREQME_BASE                              (0x4002F000u)
/** Peripheral FREQME base pointer */
#define FREQME                                   ((FREQME_Type *)FREQME_BASE)
/** Array initializer of FREQME peripheral base addresses */
#define FREQME_BASE_ADDRS                        { FREQME_BASE }
/** Array initializer of FREQME peripheral base pointers */
#define FREQME_BASE_PTRS                         { FREQME }

/*!
 * @}
 */ /* end of group FREQME_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- GPIO Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup GPIO_Peripheral_Access_Layer GPIO Peripheral Access Layer
 * @{
 */

/** GPIO - Register Layout Typedef */
typedef struct {
  __IO uint8_t B[8][32];                           /**< Byte pin registers for all port 0 and 1 GPIO pins, array offset: 0x0, array step: index*0x20, index2*0x1 */
       uint8_t RESERVED_0[3840];
  __IO uint32_t W[8][32];                          /**< Word pin registers for all port 0 and 1 GPIO pins, array offset: 0x1000, array step: index*0x80, index2*0x4 */
       uint8_t RESERVED_1[3072];
  __IO uint32_t DIR[8];                            /**< Direction registers, array offset: 0x2000, array step: 0x4 */
       uint8_t RESERVED_2[96];
  __IO uint32_t MASK[8];                           /**< Mask register, array offset: 0x2080, array step: 0x4 */
       uint8_t RESERVED_3[96];
  __IO uint32_t PIN[8];                            /**< Port pin register, array offset: 0x2100, array step: 0x4 */
       uint8_t RESERVED_4[96];
  __IO uint32_t MPIN[8];                           /**< Masked port register, array offset: 0x2180, array step: 0x4 */
       uint8_t RESERVED_5[96];
  __IO uint32_t SET[8];                            /**< Write: Set register for port Read: output bits for port, array offset: 0x2200, array step: 0x4 */
       uint8_t RESERVED_6[96];
  __O  uint32_t CLR[8];                            /**< Clear port, array offset: 0x2280, array step: 0x4 */
       uint8_t RESERVED_7[96];
  __O  uint32_t NOT[8];                            /**< Toggle port, array offset: 0x2300, array step: 0x4 */
       uint8_t RESERVED_8[96];
  __O  uint32_t DIRSET[8];                         /**< Set pin direction bits for port, array offset: 0x2380, array step: 0x4 */
       uint8_t RESERVED_9[96];
  __O  uint32_t DIRCLR[8];                         /**< Clear pin direction bits for port, array offset: 0x2400, array step: 0x4 */
       uint8_t RESERVED_10[96];
  __O  uint32_t DIRNOT[8];                         /**< Toggle pin direction bits for port, array offset: 0x2480, array step: 0x4 */
       uint8_t RESERVED_11[96];
  __IO uint32_t INTENA[8];                         /**< interrupt A enable control register, array offset: 0x2500, array step: 0x4 */
       uint8_t RESERVED_12[96];
  __IO uint32_t INTENB[8];                         /**< interrupt B enable control register, array offset: 0x2580, array step: 0x4 */
       uint8_t RESERVED_13[96];
  __IO uint32_t INTPOL[8];                         /**< interupt polarity control register, array offset: 0x2600, array step: 0x4 */
       uint8_t RESERVED_14[96];
  __IO uint32_t INTEDG[8];                         /**< choose edge or level for interrupt, array offset: 0x2680, array step: 0x4 */
       uint8_t RESERVED_15[96];
  __IO uint32_t INTSTATA[8];                       /**< interrupt status for interrupt A, array offset: 0x2700, array step: 0x4 */
       uint8_t RESERVED_16[96];
  __IO uint32_t INTSTATB[8];                       /**< interrupt status for interrupt B, array offset: 0x2780, array step: 0x4 */
} GPIO_Type;

/* ----------------------------------------------------------------------------
   -- GPIO Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup GPIO_Register_Masks GPIO Register Masks
 * @{
 */

/*! @name B - Byte pin registers for all port 0 and 1 GPIO pins */
/*! @{ */

#define GPIO_B_PBYTE_MASK                        (0x1U)
#define GPIO_B_PBYTE_SHIFT                       (0U)
/*! PBYTE - Read: state of the pin PIOm_n, regardless of direction, masking, or alternate function,
 *    except that pins configured as analog I/O always read as 0. One register for each port pin.
 *    Supported pins depends on the specific device and package. Write: loads the pin's output bit.
 *    One register for each port pin. Supported pins depends on the specific device and package.
 */
#define GPIO_B_PBYTE(x)                          (((uint8_t)(((uint8_t)(x)) << GPIO_B_PBYTE_SHIFT)) & GPIO_B_PBYTE_MASK)
/*! @} */

/* The count of GPIO_B */
#define GPIO_B_COUNT                             (8U)

/* The count of GPIO_B */
#define GPIO_B_COUNT2                            (32U)

/*! @name W - Word pin registers for all port 0 and 1 GPIO pins */
/*! @{ */

#define GPIO_W_PWORD_MASK                        (0xFFFFFFFFU)
#define GPIO_W_PWORD_SHIFT                       (0U)
/*! PWORD - Read 0: pin PIOm_n is LOW. Write 0: clear output bit. Read 0xFFFF FFFF: pin PIOm_n is
 *    HIGH. Write any value 0x0000 0001 to 0xFFFF FFFF: set output bit. Only 0 or 0xFFFF FFFF can be
 *    read. Writing any value other than 0 will set the output bit. One register for each port pin.
 *    Supported pins depends on the specific device and package.
 */
#define GPIO_W_PWORD(x)                          (((uint32_t)(((uint32_t)(x)) << GPIO_W_PWORD_SHIFT)) & GPIO_W_PWORD_MASK)
/*! @} */

/* The count of GPIO_W */
#define GPIO_W_COUNT                             (8U)

/* The count of GPIO_W */
#define GPIO_W_COUNT2                            (32U)

/*! @name DIR - Direction registers */
/*! @{ */

#define GPIO_DIR_DIRP_MASK                       (0xFFFFFFFFU)
#define GPIO_DIR_DIRP_SHIFT                      (0U)
/*! DIRP - Selects pin direction for pin PIOm_n (bit 0 = PIOn_0, bit 1 = PIOn_1, etc.). Supported
 *    pins depends on the specific device and package. 0 = input. 1 = output.
 */
#define GPIO_DIR_DIRP(x)                         (((uint32_t)(((uint32_t)(x)) << GPIO_DIR_DIRP_SHIFT)) & GPIO_DIR_DIRP_MASK)
/*! @} */

/* The count of GPIO_DIR */
#define GPIO_DIR_COUNT                           (8U)

/*! @name MASK - Mask register */
/*! @{ */

#define GPIO_MASK_MASKP_MASK                     (0xFFFFFFFFU)
#define GPIO_MASK_MASKP_SHIFT                    (0U)
/*! MASKP - Controls which bits corresponding to PIOm_n are active in the MPORT register (bit 0 =
 *    PIOn_0, bit 1 = PIOn_1, etc.). Supported pins depends on the specific device and package. 0 =
 *    Read MPORT: pin state; write MPORT: load output bit. 1 = Read MPORT: 0; write MPORT: output bit
 *    not affected.
 */
#define GPIO_MASK_MASKP(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_MASK_MASKP_SHIFT)) & GPIO_MASK_MASKP_MASK)
/*! @} */

/* The count of GPIO_MASK */
#define GPIO_MASK_COUNT                          (8U)

/*! @name PIN - Port pin register */
/*! @{ */

#define GPIO_PIN_PORT_MASK                       (0xFFFFFFFFU)
#define GPIO_PIN_PORT_SHIFT                      (0U)
/*! PORT - Reads pin states or loads output bits (bit 0 = PIOn_0, bit 1 = PIOn_1, etc.). Supported
 *    pins depends on the specific device and package. 0 = Read: pin is low; write: clear output bit.
 *    1 = Read: pin is high; write: set output bit.
 */
#define GPIO_PIN_PORT(x)                         (((uint32_t)(((uint32_t)(x)) << GPIO_PIN_PORT_SHIFT)) & GPIO_PIN_PORT_MASK)
/*! @} */

/* The count of GPIO_PIN */
#define GPIO_PIN_COUNT                           (8U)

/*! @name MPIN - Masked port register */
/*! @{ */

#define GPIO_MPIN_MPORTP_MASK                    (0xFFFFFFFFU)
#define GPIO_MPIN_MPORTP_SHIFT                   (0U)
/*! MPORTP - Masked port register (bit 0 = PIOn_0, bit 1 = PIOn_1, etc.). Supported pins depends on
 *    the specific device and package. 0 = Read: pin is LOW and/or the corresponding bit in the MASK
 *    register is 1; write: clear output bit if the corresponding bit in the MASK register is 0. 1
 *    = Read: pin is HIGH and the corresponding bit in the MASK register is 0; write: set output bit
 *    if the corresponding bit in the MASK register is 0.
 */
#define GPIO_MPIN_MPORTP(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_MPIN_MPORTP_SHIFT)) & GPIO_MPIN_MPORTP_MASK)
/*! @} */

/* The count of GPIO_MPIN */
#define GPIO_MPIN_COUNT                          (8U)

/*! @name SET - Write: Set register for port Read: output bits for port */
/*! @{ */

#define GPIO_SET_SETP_MASK                       (0xFFFFFFFFU)
#define GPIO_SET_SETP_SHIFT                      (0U)
/*! SETP - Read or set output bits (bit 0 = PIOn_0, bit 1 = PIOn_1, etc.). Supported pins depends on
 *    the specific device and package. 0 = Read: output bit: write: no operation. 1 = Read: output
 *    bit; write: set output bit.
 */
#define GPIO_SET_SETP(x)                         (((uint32_t)(((uint32_t)(x)) << GPIO_SET_SETP_SHIFT)) & GPIO_SET_SETP_MASK)
/*! @} */

/* The count of GPIO_SET */
#define GPIO_SET_COUNT                           (8U)

/*! @name CLR - Clear port */
/*! @{ */

#define GPIO_CLR_CLRP_MASK                       (0xFFFFFFFFU)
#define GPIO_CLR_CLRP_SHIFT                      (0U)
/*! CLRP - Clear output bits (bit 0 = PIOn_0, bit 1 = PIOn_1, etc.). Supported pins depends on the
 *    specific device and package. 0 = No operation. 1 = Clear output bit.
 */
#define GPIO_CLR_CLRP(x)                         (((uint32_t)(((uint32_t)(x)) << GPIO_CLR_CLRP_SHIFT)) & GPIO_CLR_CLRP_MASK)
/*! @} */

/* The count of GPIO_CLR */
#define GPIO_CLR_COUNT                           (8U)

/*! @name NOT - Toggle port */
/*! @{ */

#define GPIO_NOT_NOTP_MASK                       (0xFFFFFFFFU)
#define GPIO_NOT_NOTP_SHIFT                      (0U)
/*! NOTP - Toggle output bits (bit 0 = PIOn_0, bit 1 = PIOn_1, etc.). Supported pins depends on the
 *    specific device and package. 0 = no operation. 1 = Toggle output bit.
 */
#define GPIO_NOT_NOTP(x)                         (((uint32_t)(((uint32_t)(x)) << GPIO_NOT_NOTP_SHIFT)) & GPIO_NOT_NOTP_MASK)
/*! @} */

/* The count of GPIO_NOT */
#define GPIO_NOT_COUNT                           (8U)

/*! @name DIRSET - Set pin direction bits for port */
/*! @{ */

#define GPIO_DIRSET_DIRSETP_MASK                 (0xFFFFFFFFU)
#define GPIO_DIRSET_DIRSETP_SHIFT                (0U)
/*! DIRSETP - Set direction bits (bit 0 = PIOn_0, bit 1 = PIOn_1, etc.). Supported pins depends on
 *    the specific device and package. 0 = No operation. 1 = Set direction bit.
 */
#define GPIO_DIRSET_DIRSETP(x)                   (((uint32_t)(((uint32_t)(x)) << GPIO_DIRSET_DIRSETP_SHIFT)) & GPIO_DIRSET_DIRSETP_MASK)
/*! @} */

/* The count of GPIO_DIRSET */
#define GPIO_DIRSET_COUNT                        (8U)

/*! @name DIRCLR - Clear pin direction bits for port */
/*! @{ */

#define GPIO_DIRCLR_DIRCLRP_MASK                 (0xFFFFFFFFU)
#define GPIO_DIRCLR_DIRCLRP_SHIFT                (0U)
/*! DIRCLRP - Clear direction bits (bit 0 = PIOn_0, bit 1 = PIOn_1, etc.). Supported pins depends on
 *    the specific device and package. 0 = No operation. 1 = Clear direction bit.
 */
#define GPIO_DIRCLR_DIRCLRP(x)                   (((uint32_t)(((uint32_t)(x)) << GPIO_DIRCLR_DIRCLRP_SHIFT)) & GPIO_DIRCLR_DIRCLRP_MASK)
/*! @} */

/* The count of GPIO_DIRCLR */
#define GPIO_DIRCLR_COUNT                        (8U)

/*! @name DIRNOT - Toggle pin direction bits for port */
/*! @{ */

#define GPIO_DIRNOT_DIRNOTP_MASK                 (0xFFFFFFFFU)
#define GPIO_DIRNOT_DIRNOTP_SHIFT                (0U)
/*! DIRNOTP - Toggle direction bits (bit 0 = PIOn_0, bit 1 = PIOn_1, etc.). Supported pins depends
 *    on the specific device and package. 0 = no operation. 1 = Toggle direction bit.
 */
#define GPIO_DIRNOT_DIRNOTP(x)                   (((uint32_t)(((uint32_t)(x)) << GPIO_DIRNOT_DIRNOTP_SHIFT)) & GPIO_DIRNOT_DIRNOTP_MASK)
/*! @} */

/* The count of GPIO_DIRNOT */
#define GPIO_DIRNOT_COUNT                        (8U)

/*! @name INTENA - interrupt A enable control register */
/*! @{ */

#define GPIO_INTENA_INT_EN_MASK                  (0xFFFFFFFFU)
#define GPIO_INTENA_INT_EN_SHIFT                 (0U)
/*! INT_EN - interrupt enable control for each pin(bit 0 for pion_0, bin 1 for pion_1, etc)
 */
#define GPIO_INTENA_INT_EN(x)                    (((uint32_t)(((uint32_t)(x)) << GPIO_INTENA_INT_EN_SHIFT)) & GPIO_INTENA_INT_EN_MASK)
/*! @} */

/* The count of GPIO_INTENA */
#define GPIO_INTENA_COUNT                        (8U)

/*! @name INTENB - interrupt B enable control register */
/*! @{ */

#define GPIO_INTENB_INT_EN_MASK                  (0xFFFFFFFFU)
#define GPIO_INTENB_INT_EN_SHIFT                 (0U)
/*! INT_EN - interrupt enable control for each pin(bit 0 for pion_0, bin 1 for pion_1, etc)
 */
#define GPIO_INTENB_INT_EN(x)                    (((uint32_t)(((uint32_t)(x)) << GPIO_INTENB_INT_EN_SHIFT)) & GPIO_INTENB_INT_EN_MASK)
/*! @} */

/* The count of GPIO_INTENB */
#define GPIO_INTENB_COUNT                        (8U)

/*! @name INTPOL - interupt polarity control register */
/*! @{ */

#define GPIO_INTPOL_POL_CTL_MASK                 (0xFFFFFFFFU)
#define GPIO_INTPOL_POL_CTL_SHIFT                (0U)
/*! POL_CTL - polarity control for each pin(bit 0 for pion_0, bit 1 for pion_1, etc.)
 *  0b00000000000000000000000000000000..interrupt when gpio high
 *  0b00000000000000000000000000000001..interrupt when gpio low
 */
#define GPIO_INTPOL_POL_CTL(x)                   (((uint32_t)(((uint32_t)(x)) << GPIO_INTPOL_POL_CTL_SHIFT)) & GPIO_INTPOL_POL_CTL_MASK)
/*! @} */

/* The count of GPIO_INTPOL */
#define GPIO_INTPOL_COUNT                        (8U)

/*! @name INTEDG - choose edge or level for interrupt */
/*! @{ */

#define GPIO_INTEDG_EDGE_MASK                    (0xFFFFFFFFU)
#define GPIO_INTEDG_EDGE_SHIFT                   (0U)
/*! EDGE - choose level or edge based detection for each pin(bit0 for pion_0, bit1 for pion_1, etc)
 *  0b00000000000000000000000000000000..level
 *  0b00000000000000000000000000000001..edge
 */
#define GPIO_INTEDG_EDGE(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_INTEDG_EDGE_SHIFT)) & GPIO_INTEDG_EDGE_MASK)
/*! @} */

/* The count of GPIO_INTEDG */
#define GPIO_INTEDG_COUNT                        (8U)

/*! @name INTSTATA - interrupt status for interrupt A */
/*! @{ */

#define GPIO_INTSTATA_STATUS_MASK                (0xFFFFFFFFU)
#define GPIO_INTSTATA_STATUS_SHIFT               (0U)
/*! STATUS - interrupt status
 */
#define GPIO_INTSTATA_STATUS(x)                  (((uint32_t)(((uint32_t)(x)) << GPIO_INTSTATA_STATUS_SHIFT)) & GPIO_INTSTATA_STATUS_MASK)
/*! @} */

/* The count of GPIO_INTSTATA */
#define GPIO_INTSTATA_COUNT                      (8U)

/*! @name INTSTATB - interrupt status for interrupt B */
/*! @{ */

#define GPIO_INTSTATB_STATUS_MASK                (0xFFFFFFFFU)
#define GPIO_INTSTATB_STATUS_SHIFT               (0U)
/*! STATUS - interrupt status
 */
#define GPIO_INTSTATB_STATUS(x)                  (((uint32_t)(((uint32_t)(x)) << GPIO_INTSTATB_STATUS_SHIFT)) & GPIO_INTSTATB_STATUS_MASK)
/*! @} */

/* The count of GPIO_INTSTATB */
#define GPIO_INTSTATB_COUNT                      (8U)


/*!
 * @}
 */ /* end of group GPIO_Register_Masks */


/* GPIO - Peripheral instance base addresses */
/** Peripheral GPIO base address */
#define GPIO_BASE                                (0x40100000u)
/** Peripheral GPIO base pointer */
#define GPIO                                     ((GPIO_Type *)GPIO_BASE)
/** Array initializer of GPIO peripheral base addresses */
#define GPIO_BASE_ADDRS                          { GPIO_BASE }
/** Array initializer of GPIO peripheral base pointers */
#define GPIO_BASE_PTRS                           { GPIO }

/*!
 * @}
 */ /* end of group GPIO_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- I2C Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup I2C_Peripheral_Access_Layer I2C Peripheral Access Layer
 * @{
 */

/** I2C - Register Layout Typedef */
typedef struct {
       uint8_t RESERVED_0[2048];
  __IO uint32_t CFG;                               /**< Configuration for shared functions., offset: 0x800 */
  __IO uint32_t STAT;                              /**< Status register for Master, Slave, and Monitor functions., offset: 0x804 */
  __IO uint32_t INTENSET;                          /**< Interrupt Enable Set and read register., offset: 0x808 */
  __O  uint32_t INTENCLR;                          /**< Interrupt Enable Clear register., offset: 0x80C */
  __IO uint32_t TIMEOUT;                           /**< Time-out value register., offset: 0x810 */
  __IO uint32_t CLKDIV;                            /**< Clock pre-divider for the entire I2C interface. This determines what time increments are used for the MSTTIME register, and controls some timing of the Slave function., offset: 0x814 */
  __I  uint32_t INTSTAT;                           /**< Interrupt Status register for Master, Slave, and Monitor functions., offset: 0x818 */
       uint8_t RESERVED_1[4];
  __IO uint32_t MSTCTL;                            /**< Master control register., offset: 0x820 */
  __IO uint32_t MSTTIME;                           /**< Master timing configuration., offset: 0x824 */
  __IO uint32_t MSTDAT;                            /**< Combined Master receiver and transmitter data register., offset: 0x828 */
       uint8_t RESERVED_2[20];
  __IO uint32_t SLVCTL;                            /**< Slave control register., offset: 0x840 */
  __IO uint32_t SLVDAT;                            /**< Combined Slave receiver and transmitter data register., offset: 0x844 */
  __IO uint32_t SLVADR[4];                         /**< Slave address register., array offset: 0x848, array step: 0x4 */
  __IO uint32_t SLVQUAL0;                          /**< Slave Qualification for address 0., offset: 0x858 */
       uint8_t RESERVED_3[36];
  __I  uint32_t MONRXDAT;                          /**< Monitor receiver data register., offset: 0x880 */
       uint8_t RESERVED_4[1912];
  __I  uint32_t ID;                                /**< Peripheral identification register., offset: 0xFFC */
} I2C_Type;

/* ----------------------------------------------------------------------------
   -- I2C Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup I2C_Register_Masks I2C Register Masks
 * @{
 */

/*! @name CFG - Configuration for shared functions. */
/*! @{ */

#define I2C_CFG_MSTEN_MASK                       (0x1U)
#define I2C_CFG_MSTEN_SHIFT                      (0U)
/*! MSTEN - Master Enable. When disabled, configurations settings for the Master function are not
 *    changed, but the Master function is internally reset.
 *  0b0..Disabled. The I2C Master function is disabled.
 *  0b1..Enabled. The I2C Master function is enabled.
 */
#define I2C_CFG_MSTEN(x)                         (((uint32_t)(((uint32_t)(x)) << I2C_CFG_MSTEN_SHIFT)) & I2C_CFG_MSTEN_MASK)

#define I2C_CFG_SLVEN_MASK                       (0x2U)
#define I2C_CFG_SLVEN_SHIFT                      (1U)
/*! SLVEN - Slave Enable. When disabled, configurations settings for the Slave function are not
 *    changed, but the Slave function is internally reset.
 *  0b0..Disabled. The I2C slave function is disabled.
 *  0b1..Enabled. The I2C slave function is enabled.
 */
#define I2C_CFG_SLVEN(x)                         (((uint32_t)(((uint32_t)(x)) << I2C_CFG_SLVEN_SHIFT)) & I2C_CFG_SLVEN_MASK)

#define I2C_CFG_MONEN_MASK                       (0x4U)
#define I2C_CFG_MONEN_SHIFT                      (2U)
/*! MONEN - Monitor Enable. When disabled, configurations settings for the Monitor function are not
 *    changed, but the Monitor function is internally reset.
 *  0b0..Disabled. The I2C Monitor function is disabled.
 *  0b1..Enabled. The I2C Monitor function is enabled.
 */
#define I2C_CFG_MONEN(x)                         (((uint32_t)(((uint32_t)(x)) << I2C_CFG_MONEN_SHIFT)) & I2C_CFG_MONEN_MASK)

#define I2C_CFG_TIMEOUTEN_MASK                   (0x8U)
#define I2C_CFG_TIMEOUTEN_SHIFT                  (3U)
/*! TIMEOUTEN - I2C bus Time-out Enable. When disabled, the time-out function is internally reset.
 *  0b0..Disabled. Time-out function is disabled.
 *  0b1..Enabled. Time-out function is enabled. Both types of time-out flags will be generated and will cause
 *       interrupts if they are enabled. Typically, only one time-out will be used in a system.
 */
#define I2C_CFG_TIMEOUTEN(x)                     (((uint32_t)(((uint32_t)(x)) << I2C_CFG_TIMEOUTEN_SHIFT)) & I2C_CFG_TIMEOUTEN_MASK)

#define I2C_CFG_MONCLKSTR_MASK                   (0x10U)
#define I2C_CFG_MONCLKSTR_SHIFT                  (4U)
/*! MONCLKSTR - Monitor function Clock Stretching.
 *  0b0..Disabled. The Monitor function will not perform clock stretching. Software or DMA may not always be able
 *       to read data provided by the Monitor function before it is overwritten. This mode may be used when
 *       non-invasive monitoring is critical.
 *  0b1..Enabled. The Monitor function will perform clock stretching in order to ensure that software or DMA can
 *       read all incoming data supplied by the Monitor function.
 */
#define I2C_CFG_MONCLKSTR(x)                     (((uint32_t)(((uint32_t)(x)) << I2C_CFG_MONCLKSTR_SHIFT)) & I2C_CFG_MONCLKSTR_MASK)

#define I2C_CFG_HSCAPABLE_MASK                   (0x20U)
#define I2C_CFG_HSCAPABLE_SHIFT                  (5U)
/*! HSCAPABLE - High-speed mode Capable enable. Since High Speed mode alters the way I2C pins drive
 *    and filter, as well as the timing for certain I2C signalling, enabling High-speed mode applies
 *    to all functions: Master, Slave, and Monitor.
 *  0b0..Fast-mode plus. The I 2C interface will support Standard-mode, Fast-mode, and Fast-mode Plus, to the
 *       extent that the pin electronics support these modes. Any changes that need to be made to the pin controls,
 *       such as changing the drive strength or filtering, must be made by software via the IOCON register associated
 *       with each I2C pin,
 *  0b1..High-speed. In addition to Standard-mode, Fast-mode, and Fast-mode Plus, the I 2C interface will support
 *       High-speed mode to the extent that the pin electronics support these modes. See Section 25.7.2.2 for more
 *       information.
 */
#define I2C_CFG_HSCAPABLE(x)                     (((uint32_t)(((uint32_t)(x)) << I2C_CFG_HSCAPABLE_SHIFT)) & I2C_CFG_HSCAPABLE_MASK)
/*! @} */

/*! @name STAT - Status register for Master, Slave, and Monitor functions. */
/*! @{ */

#define I2C_STAT_MSTPENDING_MASK                 (0x1U)
#define I2C_STAT_MSTPENDING_SHIFT                (0U)
/*! MSTPENDING - Master Pending. Indicates that the Master is waiting to continue communication on
 *    the I2C-bus (pending) or is idle. When the master is pending, the MSTSTATE bits indicate what
 *    type of software service if any the master expects. This flag will cause an interrupt when set
 *    if, enabled via the INTENSET register. The MSTPENDING flag is not set when the DMA is handling
 *    an event (if the MSTDMA bit in the MSTCTL register is set). If the master is in the idle
 *    state, and no communication is needed, mask this interrupt.
 *  0b0..In progress. Communication is in progress and the Master function is busy and cannot currently accept a command.
 *  0b1..Pending. The Master function needs software service or is in the idle state. If the master is not in the
 *       idle state, it is waiting to receive or transmit data or the NACK bit.
 */
#define I2C_STAT_MSTPENDING(x)                   (((uint32_t)(((uint32_t)(x)) << I2C_STAT_MSTPENDING_SHIFT)) & I2C_STAT_MSTPENDING_MASK)

#define I2C_STAT_MSTSTATE_MASK                   (0xEU)
#define I2C_STAT_MSTSTATE_SHIFT                  (1U)
/*! MSTSTATE - Master State code. The master state code reflects the master state when the
 *    MSTPENDING bit is set, that is the master is pending or in the idle state. Each value of this field
 *    indicates a specific required service for the Master function. All other values are reserved. See
 *    Table 400 for details of state values and appropriate responses.
 *  0b000..Idle. The Master function is available to be used for a new transaction.
 *  0b001..Receive ready. Received data available (Master Receiver mode). Address plus Read was previously sent and Acknowledged by slave.
 *  0b010..Transmit ready. Data can be transmitted (Master Transmitter mode). Address plus Write was previously sent and Acknowledged by slave.
 *  0b011..NACK Address. Slave NACKed address.
 *  0b100..NACK Data. Slave NACKed transmitted data.
 */
#define I2C_STAT_MSTSTATE(x)                     (((uint32_t)(((uint32_t)(x)) << I2C_STAT_MSTSTATE_SHIFT)) & I2C_STAT_MSTSTATE_MASK)

#define I2C_STAT_MSTARBLOSS_MASK                 (0x10U)
#define I2C_STAT_MSTARBLOSS_SHIFT                (4U)
/*! MSTARBLOSS - Master Arbitration Loss flag. This flag can be cleared by software writing a 1 to
 *    this bit. It is also cleared automatically a 1 is written to MSTCONTINUE.
 *  0b0..No Arbitration Loss has occurred.
 *  0b1..Arbitration loss. The Master function has experienced an Arbitration Loss. At this point, the Master
 *       function has already stopped driving the bus and gone to an idle state. Software can respond by doing nothing,
 *       or by sending a Start in order to attempt to gain control of the bus when it next becomes idle.
 */
#define I2C_STAT_MSTARBLOSS(x)                   (((uint32_t)(((uint32_t)(x)) << I2C_STAT_MSTARBLOSS_SHIFT)) & I2C_STAT_MSTARBLOSS_MASK)

#define I2C_STAT_MSTSTSTPERR_MASK                (0x40U)
#define I2C_STAT_MSTSTSTPERR_SHIFT               (6U)
/*! MSTSTSTPERR - Master Start/Stop Error flag. This flag can be cleared by software writing a 1 to
 *    this bit. It is also cleared automatically a 1 is written to MSTCONTINUE.
 *  0b0..No Start/Stop Error has occurred.
 *  0b1..The Master function has experienced a Start/Stop Error. A Start or Stop was detected at a time when it is
 *       not allowed by the I2C specification. The Master interface has stopped driving the bus and gone to an
 *       idle state, no action is required. A request for a Start could be made, or software could attempt to insure
 *       that the bus has not stalled.
 */
#define I2C_STAT_MSTSTSTPERR(x)                  (((uint32_t)(((uint32_t)(x)) << I2C_STAT_MSTSTSTPERR_SHIFT)) & I2C_STAT_MSTSTSTPERR_MASK)

#define I2C_STAT_SLVPENDING_MASK                 (0x100U)
#define I2C_STAT_SLVPENDING_SHIFT                (8U)
/*! SLVPENDING - Slave Pending. Indicates that the Slave function is waiting to continue
 *    communication on the I2C-bus and needs software service. This flag will cause an interrupt when set if
 *    enabled via INTENSET. The SLVPENDING flag is not set when the DMA is handling an event (if the
 *    SLVDMA bit in the SLVCTL register is set). The SLVPENDING flag is read-only and is
 *    automatically cleared when a 1 is written to the SLVCONTINUE bit in the SLVCTL register. The point in time
 *    when SlvPending is set depends on whether the I2C interface is in HSCAPABLE mode. See Section
 *    25.7.2.2.2. When the I2C interface is configured to be HSCAPABLE, HS master codes are
 *    detected automatically. Due to the requirements of the HS I2C specification, slave addresses must
 *    also be detected automatically, since the address must be acknowledged before the clock can be
 *    stretched.
 *  0b0..In progress. The Slave function does not currently need service.
 *  0b1..Pending. The Slave function needs service. Information on what is needed can be found in the adjacent SLVSTATE field.
 */
#define I2C_STAT_SLVPENDING(x)                   (((uint32_t)(((uint32_t)(x)) << I2C_STAT_SLVPENDING_SHIFT)) & I2C_STAT_SLVPENDING_MASK)

#define I2C_STAT_SLVSTATE_MASK                   (0x600U)
#define I2C_STAT_SLVSTATE_SHIFT                  (9U)
/*! SLVSTATE - Slave State code. Each value of this field indicates a specific required service for
 *    the Slave function. All other values are reserved. See Table 401 for state values and actions.
 *    note that the occurrence of some states and how they are handled are affected by DMA mode and
 *    Automatic Operation modes.
 *  0b00..Slave address. Address plus R/W received. At least one of the four slave addresses has been matched by hardware.
 *  0b01..Slave receive. Received data is available (Slave Receiver mode).
 *  0b10..Slave transmit. Data can be transmitted (Slave Transmitter mode).
 */
#define I2C_STAT_SLVSTATE(x)                     (((uint32_t)(((uint32_t)(x)) << I2C_STAT_SLVSTATE_SHIFT)) & I2C_STAT_SLVSTATE_MASK)

#define I2C_STAT_SLVNOTSTR_MASK                  (0x800U)
#define I2C_STAT_SLVNOTSTR_SHIFT                 (11U)
/*! SLVNOTSTR - Slave Not Stretching. Indicates when the slave function is stretching the I2C clock.
 *    This is needed in order to gracefully invoke Deep Sleep or Power-down modes during slave
 *    operation. This read-only flag reflects the slave function status in real time.
 *  0b0..Stretching. The slave function is currently stretching the I2C bus clock. Deep-Sleep or Power-down mode cannot be entered at this time.
 *  0b1..Not stretching. The slave function is not currently stretching the I 2C bus clock. Deep-sleep or
 *       Power-down mode could be entered at this time.
 */
#define I2C_STAT_SLVNOTSTR(x)                    (((uint32_t)(((uint32_t)(x)) << I2C_STAT_SLVNOTSTR_SHIFT)) & I2C_STAT_SLVNOTSTR_MASK)

#define I2C_STAT_SLVIDX_MASK                     (0x3000U)
#define I2C_STAT_SLVIDX_SHIFT                    (12U)
/*! SLVIDX - Slave address match Index. This field is valid when the I2C slave function has been
 *    selected by receiving an address that matches one of the slave addresses defined by any enabled
 *    slave address registers, and provides an identification of the address that was matched. It is
 *    possible that more than one address could be matched, but only one match can be reported here.
 *  0b00..Address 0. Slave address 0 was matched.
 *  0b01..Address 1. Slave address 1 was matched.
 *  0b10..Address 2. Slave address 2 was matched.
 *  0b11..Address 3. Slave address 3 was matched.
 */
#define I2C_STAT_SLVIDX(x)                       (((uint32_t)(((uint32_t)(x)) << I2C_STAT_SLVIDX_SHIFT)) & I2C_STAT_SLVIDX_MASK)

#define I2C_STAT_SLVSEL_MASK                     (0x4000U)
#define I2C_STAT_SLVSEL_SHIFT                    (14U)
/*! SLVSEL - Slave selected flag. SLVSEL is set after an address match when software tells the Slave
 *    function to acknowledge the address, or when the address has been automatically acknowledged.
 *    It is cleared when another address cycle presents an address that does not match an enabled
 *    address on the Slave function, when slave software decides to NACK a matched address, when
 *    there is a Stop detected on the bus, when the master NACKs slave data, and in some combinations of
 *    Automatic Operation. SLVSEL is not cleared if software NACKs data.
 *  0b0..Not selected. The Slave function is not currently selected.
 *  0b1..Selected. The Slave function is currently selected.
 */
#define I2C_STAT_SLVSEL(x)                       (((uint32_t)(((uint32_t)(x)) << I2C_STAT_SLVSEL_SHIFT)) & I2C_STAT_SLVSEL_MASK)

#define I2C_STAT_SLVDESEL_MASK                   (0x8000U)
#define I2C_STAT_SLVDESEL_SHIFT                  (15U)
/*! SLVDESEL - Slave Deselected flag. This flag will cause an interrupt when set if enabled via
 *    INTENSET. This flag can be cleared by writing a 1 to this bit.
 *  0b0..Not deselected. The Slave function has not become deselected. This does not mean that it is currently
 *       selected. That information can be found in the SLVSEL flag.
 *  0b1..Deselected. The Slave function has become deselected. This is specifically caused by the SLVSEL flag
 *       changing from 1 to 0. See the description of SLVSEL for details on when that event occurs.
 */
#define I2C_STAT_SLVDESEL(x)                     (((uint32_t)(((uint32_t)(x)) << I2C_STAT_SLVDESEL_SHIFT)) & I2C_STAT_SLVDESEL_MASK)

#define I2C_STAT_MONRDY_MASK                     (0x10000U)
#define I2C_STAT_MONRDY_SHIFT                    (16U)
/*! MONRDY - Monitor Ready. This flag is cleared when the MONRXDAT register is read.
 *  0b0..No data. The Monitor function does not currently have data available.
 *  0b1..Data waiting. The Monitor function has data waiting to be read.
 */
#define I2C_STAT_MONRDY(x)                       (((uint32_t)(((uint32_t)(x)) << I2C_STAT_MONRDY_SHIFT)) & I2C_STAT_MONRDY_MASK)

#define I2C_STAT_MONOV_MASK                      (0x20000U)
#define I2C_STAT_MONOV_SHIFT                     (17U)
/*! MONOV - Monitor Overflow flag.
 *  0b0..No overrun. Monitor data has not overrun.
 *  0b1..Overrun. A Monitor data overrun has occurred. This can only happen when Monitor clock stretching not
 *       enabled via the MONCLKSTR bit in the CFG register. Writing 1 to this bit clears the flag.
 */
#define I2C_STAT_MONOV(x)                        (((uint32_t)(((uint32_t)(x)) << I2C_STAT_MONOV_SHIFT)) & I2C_STAT_MONOV_MASK)

#define I2C_STAT_MONACTIVE_MASK                  (0x40000U)
#define I2C_STAT_MONACTIVE_SHIFT                 (18U)
/*! MONACTIVE - Monitor Active flag. Indicates when the Monitor function considers the I 2C bus to
 *    be active. Active is defined here as when some Master is on the bus: a bus Start has occurred
 *    more recently than a bus Stop.
 *  0b0..Inactive. The Monitor function considers the I2C bus to be inactive.
 *  0b1..Active. The Monitor function considers the I2C bus to be active.
 */
#define I2C_STAT_MONACTIVE(x)                    (((uint32_t)(((uint32_t)(x)) << I2C_STAT_MONACTIVE_SHIFT)) & I2C_STAT_MONACTIVE_MASK)

#define I2C_STAT_MONIDLE_MASK                    (0x80000U)
#define I2C_STAT_MONIDLE_SHIFT                   (19U)
/*! MONIDLE - Monitor Idle flag. This flag is set when the Monitor function sees the I2C bus change
 *    from active to inactive. This can be used by software to decide when to process data
 *    accumulated by the Monitor function. This flag will cause an interrupt when set if enabled via the
 *    INTENSET register. The flag can be cleared by writing a 1 to this bit.
 *  0b0..Not idle. The I2C bus is not idle, or this flag has been cleared by software.
 *  0b1..Idle. The I2C bus has gone idle at least once since the last time this flag was cleared by software.
 */
#define I2C_STAT_MONIDLE(x)                      (((uint32_t)(((uint32_t)(x)) << I2C_STAT_MONIDLE_SHIFT)) & I2C_STAT_MONIDLE_MASK)

#define I2C_STAT_EVENTTIMEOUT_MASK               (0x1000000U)
#define I2C_STAT_EVENTTIMEOUT_SHIFT              (24U)
/*! EVENTTIMEOUT - Event Time-out Interrupt flag. Indicates when the time between events has been
 *    longer than the time specified by the TIMEOUT register. Events include Start, Stop, and clock
 *    edges. The flag is cleared by writing a 1 to this bit. No time-out is created when the I2C-bus
 *    is idle.
 *  0b0..No time-out. I2C bus events have not caused a time-out.
 *  0b1..Event time-out. The time between I2C bus events has been longer than the time specified by the TIMEOUT register.
 */
#define I2C_STAT_EVENTTIMEOUT(x)                 (((uint32_t)(((uint32_t)(x)) << I2C_STAT_EVENTTIMEOUT_SHIFT)) & I2C_STAT_EVENTTIMEOUT_MASK)

#define I2C_STAT_SCLTIMEOUT_MASK                 (0x2000000U)
#define I2C_STAT_SCLTIMEOUT_SHIFT                (25U)
/*! SCLTIMEOUT - SCL Time-out Interrupt flag. Indicates when SCL has remained low longer than the
 *    time specific by the TIMEOUT register. The flag is cleared by writing a 1 to this bit.
 *  0b0..No time-out. SCL low time has not caused a time-out.
 *  0b1..Time-out. SCL low time has caused a time-out.
 */
#define I2C_STAT_SCLTIMEOUT(x)                   (((uint32_t)(((uint32_t)(x)) << I2C_STAT_SCLTIMEOUT_SHIFT)) & I2C_STAT_SCLTIMEOUT_MASK)
/*! @} */

/*! @name INTENSET - Interrupt Enable Set and read register. */
/*! @{ */

#define I2C_INTENSET_MSTPENDINGEN_MASK           (0x1U)
#define I2C_INTENSET_MSTPENDINGEN_SHIFT          (0U)
/*! MSTPENDINGEN - Master Pending interrupt Enable.
 *  0b0..Disabled. The MstPending interrupt is disabled.
 *  0b1..Enabled. The MstPending interrupt is enabled.
 */
#define I2C_INTENSET_MSTPENDINGEN(x)             (((uint32_t)(((uint32_t)(x)) << I2C_INTENSET_MSTPENDINGEN_SHIFT)) & I2C_INTENSET_MSTPENDINGEN_MASK)

#define I2C_INTENSET_MSTARBLOSSEN_MASK           (0x10U)
#define I2C_INTENSET_MSTARBLOSSEN_SHIFT          (4U)
/*! MSTARBLOSSEN - Master Arbitration Loss interrupt Enable.
 *  0b0..Disabled. The MstArbLoss interrupt is disabled.
 *  0b1..Enabled. The MstArbLoss interrupt is enabled.
 */
#define I2C_INTENSET_MSTARBLOSSEN(x)             (((uint32_t)(((uint32_t)(x)) << I2C_INTENSET_MSTARBLOSSEN_SHIFT)) & I2C_INTENSET_MSTARBLOSSEN_MASK)

#define I2C_INTENSET_MSTSTSTPERREN_MASK          (0x40U)
#define I2C_INTENSET_MSTSTSTPERREN_SHIFT         (6U)
/*! MSTSTSTPERREN - Master Start/Stop Error interrupt Enable.
 *  0b0..Disabled. The MstStStpErr interrupt is disabled.
 *  0b1..Enabled. The MstStStpErr interrupt is enabled.
 */
#define I2C_INTENSET_MSTSTSTPERREN(x)            (((uint32_t)(((uint32_t)(x)) << I2C_INTENSET_MSTSTSTPERREN_SHIFT)) & I2C_INTENSET_MSTSTSTPERREN_MASK)

#define I2C_INTENSET_SLVPENDINGEN_MASK           (0x100U)
#define I2C_INTENSET_SLVPENDINGEN_SHIFT          (8U)
/*! SLVPENDINGEN - Slave Pending interrupt Enable.
 *  0b0..Disabled. The SlvPending interrupt is disabled.
 *  0b1..Enabled. The SlvPending interrupt is enabled.
 */
#define I2C_INTENSET_SLVPENDINGEN(x)             (((uint32_t)(((uint32_t)(x)) << I2C_INTENSET_SLVPENDINGEN_SHIFT)) & I2C_INTENSET_SLVPENDINGEN_MASK)

#define I2C_INTENSET_SLVNOTSTREN_MASK            (0x800U)
#define I2C_INTENSET_SLVNOTSTREN_SHIFT           (11U)
/*! SLVNOTSTREN - Slave Not Stretching interrupt Enable.
 *  0b0..Disabled. The SlvNotStr interrupt is disabled.
 *  0b1..Enabled. The SlvNotStr interrupt is enabled.
 */
#define I2C_INTENSET_SLVNOTSTREN(x)              (((uint32_t)(((uint32_t)(x)) << I2C_INTENSET_SLVNOTSTREN_SHIFT)) & I2C_INTENSET_SLVNOTSTREN_MASK)

#define I2C_INTENSET_SLVDESELEN_MASK             (0x8000U)
#define I2C_INTENSET_SLVDESELEN_SHIFT            (15U)
/*! SLVDESELEN - Slave Deselect interrupt Enable.
 *  0b0..Disabled. The SlvDeSel interrupt is disabled.
 *  0b1..Enabled. The SlvDeSel interrupt is enabled.
 */
#define I2C_INTENSET_SLVDESELEN(x)               (((uint32_t)(((uint32_t)(x)) << I2C_INTENSET_SLVDESELEN_SHIFT)) & I2C_INTENSET_SLVDESELEN_MASK)

#define I2C_INTENSET_MONRDYEN_MASK               (0x10000U)
#define I2C_INTENSET_MONRDYEN_SHIFT              (16U)
/*! MONRDYEN - Monitor data Ready interrupt Enable.
 *  0b0..Disabled. The MonRdy interrupt is disabled.
 *  0b1..Enabled. The MonRdy interrupt is enabled.
 */
#define I2C_INTENSET_MONRDYEN(x)                 (((uint32_t)(((uint32_t)(x)) << I2C_INTENSET_MONRDYEN_SHIFT)) & I2C_INTENSET_MONRDYEN_MASK)

#define I2C_INTENSET_MONOVEN_MASK                (0x20000U)
#define I2C_INTENSET_MONOVEN_SHIFT               (17U)
/*! MONOVEN - Monitor Overrun interrupt Enable.
 *  0b0..Disabled. The MonOv interrupt is disabled.
 *  0b1..Enabled. The MonOv interrupt is enabled.
 */
#define I2C_INTENSET_MONOVEN(x)                  (((uint32_t)(((uint32_t)(x)) << I2C_INTENSET_MONOVEN_SHIFT)) & I2C_INTENSET_MONOVEN_MASK)

#define I2C_INTENSET_MONIDLEEN_MASK              (0x80000U)
#define I2C_INTENSET_MONIDLEEN_SHIFT             (19U)
/*! MONIDLEEN - Monitor Idle interrupt Enable.
 *  0b0..Disabled. The MonIdle interrupt is disabled.
 *  0b1..Enabled. The MonIdle interrupt is enabled.
 */
#define I2C_INTENSET_MONIDLEEN(x)                (((uint32_t)(((uint32_t)(x)) << I2C_INTENSET_MONIDLEEN_SHIFT)) & I2C_INTENSET_MONIDLEEN_MASK)

#define I2C_INTENSET_EVENTTIMEOUTEN_MASK         (0x1000000U)
#define I2C_INTENSET_EVENTTIMEOUTEN_SHIFT        (24U)
/*! EVENTTIMEOUTEN - Event time-out interrupt Enable.
 *  0b0..Disabled. The Event time-out interrupt is disabled.
 *  0b1..Enabled. The Event time-out interrupt is enabled.
 */
#define I2C_INTENSET_EVENTTIMEOUTEN(x)           (((uint32_t)(((uint32_t)(x)) << I2C_INTENSET_EVENTTIMEOUTEN_SHIFT)) & I2C_INTENSET_EVENTTIMEOUTEN_MASK)

#define I2C_INTENSET_SCLTIMEOUTEN_MASK           (0x2000000U)
#define I2C_INTENSET_SCLTIMEOUTEN_SHIFT          (25U)
/*! SCLTIMEOUTEN - SCL time-out interrupt Enable.
 *  0b0..Disabled. The SCL time-out interrupt is disabled.
 *  0b1..Enabled. The SCL time-out interrupt is enabled.
 */
#define I2C_INTENSET_SCLTIMEOUTEN(x)             (((uint32_t)(((uint32_t)(x)) << I2C_INTENSET_SCLTIMEOUTEN_SHIFT)) & I2C_INTENSET_SCLTIMEOUTEN_MASK)
/*! @} */

/*! @name INTENCLR - Interrupt Enable Clear register. */
/*! @{ */

#define I2C_INTENCLR_MSTPENDINGCLR_MASK          (0x1U)
#define I2C_INTENCLR_MSTPENDINGCLR_SHIFT         (0U)
/*! MSTPENDINGCLR - Master Pending interrupt clear. Writing 1 to this bit clears the corresponding
 *    bit in the INTENSET register if implemented.
 */
#define I2C_INTENCLR_MSTPENDINGCLR(x)            (((uint32_t)(((uint32_t)(x)) << I2C_INTENCLR_MSTPENDINGCLR_SHIFT)) & I2C_INTENCLR_MSTPENDINGCLR_MASK)

#define I2C_INTENCLR_MSTARBLOSSCLR_MASK          (0x10U)
#define I2C_INTENCLR_MSTARBLOSSCLR_SHIFT         (4U)
/*! MSTARBLOSSCLR - Master Arbitration Loss interrupt clear.
 */
#define I2C_INTENCLR_MSTARBLOSSCLR(x)            (((uint32_t)(((uint32_t)(x)) << I2C_INTENCLR_MSTARBLOSSCLR_SHIFT)) & I2C_INTENCLR_MSTARBLOSSCLR_MASK)

#define I2C_INTENCLR_MSTSTSTPERRCLR_MASK         (0x40U)
#define I2C_INTENCLR_MSTSTSTPERRCLR_SHIFT        (6U)
/*! MSTSTSTPERRCLR - Master Start/Stop Error interrupt clear.
 */
#define I2C_INTENCLR_MSTSTSTPERRCLR(x)           (((uint32_t)(((uint32_t)(x)) << I2C_INTENCLR_MSTSTSTPERRCLR_SHIFT)) & I2C_INTENCLR_MSTSTSTPERRCLR_MASK)

#define I2C_INTENCLR_SLVPENDINGCLR_MASK          (0x100U)
#define I2C_INTENCLR_SLVPENDINGCLR_SHIFT         (8U)
/*! SLVPENDINGCLR - Slave Pending interrupt clear.
 */
#define I2C_INTENCLR_SLVPENDINGCLR(x)            (((uint32_t)(((uint32_t)(x)) << I2C_INTENCLR_SLVPENDINGCLR_SHIFT)) & I2C_INTENCLR_SLVPENDINGCLR_MASK)

#define I2C_INTENCLR_SLVNOTSTRCLR_MASK           (0x800U)
#define I2C_INTENCLR_SLVNOTSTRCLR_SHIFT          (11U)
/*! SLVNOTSTRCLR - Slave Not Stretching interrupt clear.
 */
#define I2C_INTENCLR_SLVNOTSTRCLR(x)             (((uint32_t)(((uint32_t)(x)) << I2C_INTENCLR_SLVNOTSTRCLR_SHIFT)) & I2C_INTENCLR_SLVNOTSTRCLR_MASK)

#define I2C_INTENCLR_SLVDESELCLR_MASK            (0x8000U)
#define I2C_INTENCLR_SLVDESELCLR_SHIFT           (15U)
/*! SLVDESELCLR - Slave Deselect interrupt clear.
 */
#define I2C_INTENCLR_SLVDESELCLR(x)              (((uint32_t)(((uint32_t)(x)) << I2C_INTENCLR_SLVDESELCLR_SHIFT)) & I2C_INTENCLR_SLVDESELCLR_MASK)

#define I2C_INTENCLR_MONRDYCLR_MASK              (0x10000U)
#define I2C_INTENCLR_MONRDYCLR_SHIFT             (16U)
/*! MONRDYCLR - Monitor data Ready interrupt clear.
 */
#define I2C_INTENCLR_MONRDYCLR(x)                (((uint32_t)(((uint32_t)(x)) << I2C_INTENCLR_MONRDYCLR_SHIFT)) & I2C_INTENCLR_MONRDYCLR_MASK)

#define I2C_INTENCLR_MONOVCLR_MASK               (0x20000U)
#define I2C_INTENCLR_MONOVCLR_SHIFT              (17U)
/*! MONOVCLR - Monitor Overrun interrupt clear.
 */
#define I2C_INTENCLR_MONOVCLR(x)                 (((uint32_t)(((uint32_t)(x)) << I2C_INTENCLR_MONOVCLR_SHIFT)) & I2C_INTENCLR_MONOVCLR_MASK)

#define I2C_INTENCLR_MONIDLECLR_MASK             (0x80000U)
#define I2C_INTENCLR_MONIDLECLR_SHIFT            (19U)
/*! MONIDLECLR - Monitor Idle interrupt clear.
 */
#define I2C_INTENCLR_MONIDLECLR(x)               (((uint32_t)(((uint32_t)(x)) << I2C_INTENCLR_MONIDLECLR_SHIFT)) & I2C_INTENCLR_MONIDLECLR_MASK)

#define I2C_INTENCLR_EVENTTIMEOUTCLR_MASK        (0x1000000U)
#define I2C_INTENCLR_EVENTTIMEOUTCLR_SHIFT       (24U)
/*! EVENTTIMEOUTCLR - Event time-out interrupt clear.
 */
#define I2C_INTENCLR_EVENTTIMEOUTCLR(x)          (((uint32_t)(((uint32_t)(x)) << I2C_INTENCLR_EVENTTIMEOUTCLR_SHIFT)) & I2C_INTENCLR_EVENTTIMEOUTCLR_MASK)

#define I2C_INTENCLR_SCLTIMEOUTCLR_MASK          (0x2000000U)
#define I2C_INTENCLR_SCLTIMEOUTCLR_SHIFT         (25U)
/*! SCLTIMEOUTCLR - SCL time-out interrupt clear.
 */
#define I2C_INTENCLR_SCLTIMEOUTCLR(x)            (((uint32_t)(((uint32_t)(x)) << I2C_INTENCLR_SCLTIMEOUTCLR_SHIFT)) & I2C_INTENCLR_SCLTIMEOUTCLR_MASK)
/*! @} */

/*! @name TIMEOUT - Time-out value register. */
/*! @{ */

#define I2C_TIMEOUT_TOMIN_MASK                   (0xFU)
#define I2C_TIMEOUT_TOMIN_SHIFT                  (0U)
/*! TOMIN - Time-out time value, bottom four bits. These are hard-wired to 0xF. This gives a minimum
 *    time-out of 16 I2C function clocks and also a time-out resolution of 16 I2C function clocks.
 */
#define I2C_TIMEOUT_TOMIN(x)                     (((uint32_t)(((uint32_t)(x)) << I2C_TIMEOUT_TOMIN_SHIFT)) & I2C_TIMEOUT_TOMIN_MASK)

#define I2C_TIMEOUT_TO_MASK                      (0xFFF0U)
#define I2C_TIMEOUT_TO_SHIFT                     (4U)
/*! TO - Time-out time value. Specifies the time-out interval value in increments of 16 I 2C
 *    function clocks, as defined by the CLKDIV register. To change this value while I2C is in operation,
 *    disable all time-outs, write a new value to TIMEOUT, then re-enable time-outs. 0x000 = A
 *    time-out will occur after 16 counts of the I2C function clock. 0x001 = A time-out will occur after
 *    32 counts of the I2C function clock. 0xFFF = A time-out will occur after 65,536 counts of the
 *    I2C function clock.
 */
#define I2C_TIMEOUT_TO(x)                        (((uint32_t)(((uint32_t)(x)) << I2C_TIMEOUT_TO_SHIFT)) & I2C_TIMEOUT_TO_MASK)
/*! @} */

/*! @name CLKDIV - Clock pre-divider for the entire I2C interface. This determines what time increments are used for the MSTTIME register, and controls some timing of the Slave function. */
/*! @{ */

#define I2C_CLKDIV_DIVVAL_MASK                   (0xFFFFU)
#define I2C_CLKDIV_DIVVAL_SHIFT                  (0U)
/*! DIVVAL - This field controls how the Flexcomm clock (FCLK) is used by the I2C functions that
 *    need an internal clock in order to operate. 0x0000 = FCLK is used directly by the I2C. 0x0001 =
 *    FCLK is divided by 2 before use. 0x0002 = FCLK is divided by 3 before use. 0xFFFF = FCLK is
 *    divided by 65,536 before use.
 */
#define I2C_CLKDIV_DIVVAL(x)                     (((uint32_t)(((uint32_t)(x)) << I2C_CLKDIV_DIVVAL_SHIFT)) & I2C_CLKDIV_DIVVAL_MASK)
/*! @} */

/*! @name INTSTAT - Interrupt Status register for Master, Slave, and Monitor functions. */
/*! @{ */

#define I2C_INTSTAT_MSTPENDING_MASK              (0x1U)
#define I2C_INTSTAT_MSTPENDING_SHIFT             (0U)
/*! MSTPENDING - Master Pending.
 */
#define I2C_INTSTAT_MSTPENDING(x)                (((uint32_t)(((uint32_t)(x)) << I2C_INTSTAT_MSTPENDING_SHIFT)) & I2C_INTSTAT_MSTPENDING_MASK)

#define I2C_INTSTAT_MSTARBLOSS_MASK              (0x10U)
#define I2C_INTSTAT_MSTARBLOSS_SHIFT             (4U)
/*! MSTARBLOSS - Master Arbitration Loss flag.
 */
#define I2C_INTSTAT_MSTARBLOSS(x)                (((uint32_t)(((uint32_t)(x)) << I2C_INTSTAT_MSTARBLOSS_SHIFT)) & I2C_INTSTAT_MSTARBLOSS_MASK)

#define I2C_INTSTAT_MSTSTSTPERR_MASK             (0x40U)
#define I2C_INTSTAT_MSTSTSTPERR_SHIFT            (6U)
/*! MSTSTSTPERR - Master Start/Stop Error flag.
 */
#define I2C_INTSTAT_MSTSTSTPERR(x)               (((uint32_t)(((uint32_t)(x)) << I2C_INTSTAT_MSTSTSTPERR_SHIFT)) & I2C_INTSTAT_MSTSTSTPERR_MASK)

#define I2C_INTSTAT_SLVPENDING_MASK              (0x100U)
#define I2C_INTSTAT_SLVPENDING_SHIFT             (8U)
/*! SLVPENDING - Slave Pending.
 */
#define I2C_INTSTAT_SLVPENDING(x)                (((uint32_t)(((uint32_t)(x)) << I2C_INTSTAT_SLVPENDING_SHIFT)) & I2C_INTSTAT_SLVPENDING_MASK)

#define I2C_INTSTAT_SLVNOTSTR_MASK               (0x800U)
#define I2C_INTSTAT_SLVNOTSTR_SHIFT              (11U)
/*! SLVNOTSTR - Slave Not Stretching status.
 */
#define I2C_INTSTAT_SLVNOTSTR(x)                 (((uint32_t)(((uint32_t)(x)) << I2C_INTSTAT_SLVNOTSTR_SHIFT)) & I2C_INTSTAT_SLVNOTSTR_MASK)

#define I2C_INTSTAT_SLVDESEL_MASK                (0x8000U)
#define I2C_INTSTAT_SLVDESEL_SHIFT               (15U)
/*! SLVDESEL - Slave Deselected flag.
 */
#define I2C_INTSTAT_SLVDESEL(x)                  (((uint32_t)(((uint32_t)(x)) << I2C_INTSTAT_SLVDESEL_SHIFT)) & I2C_INTSTAT_SLVDESEL_MASK)

#define I2C_INTSTAT_MONRDY_MASK                  (0x10000U)
#define I2C_INTSTAT_MONRDY_SHIFT                 (16U)
/*! MONRDY - Monitor Ready.
 */
#define I2C_INTSTAT_MONRDY(x)                    (((uint32_t)(((uint32_t)(x)) << I2C_INTSTAT_MONRDY_SHIFT)) & I2C_INTSTAT_MONRDY_MASK)

#define I2C_INTSTAT_MONOV_MASK                   (0x20000U)
#define I2C_INTSTAT_MONOV_SHIFT                  (17U)
/*! MONOV - Monitor Overflow flag.
 */
#define I2C_INTSTAT_MONOV(x)                     (((uint32_t)(((uint32_t)(x)) << I2C_INTSTAT_MONOV_SHIFT)) & I2C_INTSTAT_MONOV_MASK)

#define I2C_INTSTAT_MONIDLE_MASK                 (0x80000U)
#define I2C_INTSTAT_MONIDLE_SHIFT                (19U)
/*! MONIDLE - Monitor Idle flag.
 */
#define I2C_INTSTAT_MONIDLE(x)                   (((uint32_t)(((uint32_t)(x)) << I2C_INTSTAT_MONIDLE_SHIFT)) & I2C_INTSTAT_MONIDLE_MASK)

#define I2C_INTSTAT_EVENTTIMEOUT_MASK            (0x1000000U)
#define I2C_INTSTAT_EVENTTIMEOUT_SHIFT           (24U)
/*! EVENTTIMEOUT - Event time-out Interrupt flag.
 */
#define I2C_INTSTAT_EVENTTIMEOUT(x)              (((uint32_t)(((uint32_t)(x)) << I2C_INTSTAT_EVENTTIMEOUT_SHIFT)) & I2C_INTSTAT_EVENTTIMEOUT_MASK)

#define I2C_INTSTAT_SCLTIMEOUT_MASK              (0x2000000U)
#define I2C_INTSTAT_SCLTIMEOUT_SHIFT             (25U)
/*! SCLTIMEOUT - SCL time-out Interrupt flag.
 */
#define I2C_INTSTAT_SCLTIMEOUT(x)                (((uint32_t)(((uint32_t)(x)) << I2C_INTSTAT_SCLTIMEOUT_SHIFT)) & I2C_INTSTAT_SCLTIMEOUT_MASK)
/*! @} */

/*! @name MSTCTL - Master control register. */
/*! @{ */

#define I2C_MSTCTL_MSTCONTINUE_MASK              (0x1U)
#define I2C_MSTCTL_MSTCONTINUE_SHIFT             (0U)
/*! MSTCONTINUE - Master Continue. This bit is write-only.
 *  0b0..No effect.
 *  0b1..Continue. Informs the Master function to continue to the next operation. This must done after writing
 *       transmit data, reading received data, or any other housekeeping related to the next bus operation.
 */
#define I2C_MSTCTL_MSTCONTINUE(x)                (((uint32_t)(((uint32_t)(x)) << I2C_MSTCTL_MSTCONTINUE_SHIFT)) & I2C_MSTCTL_MSTCONTINUE_MASK)

#define I2C_MSTCTL_MSTSTART_MASK                 (0x2U)
#define I2C_MSTCTL_MSTSTART_SHIFT                (1U)
/*! MSTSTART - Master Start control. This bit is write-only.
 *  0b0..No effect.
 *  0b1..Start. A Start will be generated on the I2C bus at the next allowed time.
 */
#define I2C_MSTCTL_MSTSTART(x)                   (((uint32_t)(((uint32_t)(x)) << I2C_MSTCTL_MSTSTART_SHIFT)) & I2C_MSTCTL_MSTSTART_MASK)

#define I2C_MSTCTL_MSTSTOP_MASK                  (0x4U)
#define I2C_MSTCTL_MSTSTOP_SHIFT                 (2U)
/*! MSTSTOP - Master Stop control. This bit is write-only.
 *  0b0..No effect.
 *  0b1..Stop. A Stop will be generated on the I2C bus at the next allowed time, preceded by a NACK to the slave
 *       if the master is receiving data from the slave (Master Receiver mode).
 */
#define I2C_MSTCTL_MSTSTOP(x)                    (((uint32_t)(((uint32_t)(x)) << I2C_MSTCTL_MSTSTOP_SHIFT)) & I2C_MSTCTL_MSTSTOP_MASK)

#define I2C_MSTCTL_MSTDMA_MASK                   (0x8U)
#define I2C_MSTCTL_MSTDMA_SHIFT                  (3U)
/*! MSTDMA - Master DMA enable. Data operations of the I2C can be performed with DMA. Protocol type
 *    operations such as Start, address, Stop, and address match must always be done with software,
 *    typically via an interrupt. Address acknowledgement must also be done by software except when
 *    the I2C is configured to be HSCAPABLE (and address acknowledgement is handled entirely by
 *    hardware) or when Automatic Operation is enabled. When a DMA data transfer is complete, MSTDMA
 *    must be cleared prior to beginning the next operation, typically a Start or Stop.This bit is
 *    read/write.
 *  0b0..Disable. No DMA requests are generated for master operation.
 *  0b1..Enable. A DMA request is generated for I2C master data operations. When this I2C master is generating
 *       Acknowledge bits in Master Receiver mode, the acknowledge is generated automatically.
 */
#define I2C_MSTCTL_MSTDMA(x)                     (((uint32_t)(((uint32_t)(x)) << I2C_MSTCTL_MSTDMA_SHIFT)) & I2C_MSTCTL_MSTDMA_MASK)
/*! @} */

/*! @name MSTTIME - Master timing configuration. */
/*! @{ */

#define I2C_MSTTIME_MSTSCLLOW_MASK               (0x7U)
#define I2C_MSTTIME_MSTSCLLOW_SHIFT              (0U)
/*! MSTSCLLOW - Master SCL Low time. Specifies the minimum low time that will be asserted by this
 *    master on SCL. Other devices on the bus (masters or slaves) could lengthen this time. This
 *    corresponds to the parameter t LOW in the I2C bus specification. I2C bus specification parameters
 *    tBUF and tSU;STA have the same values and are also controlled by MSTSCLLOW.
 *  0b000..2 clocks. Minimum SCL low time is 2 clocks of the I2C clock pre-divider.
 *  0b001..3 clocks. Minimum SCL low time is 3 clocks of the I2C clock pre-divider.
 *  0b010..4 clocks. Minimum SCL low time is 4 clocks of the I2C clock pre-divider.
 *  0b011..5 clocks. Minimum SCL low time is 5 clocks of the I2C clock pre-divider.
 *  0b100..6 clocks. Minimum SCL low time is 6 clocks of the I2C clock pre-divider.
 *  0b101..7 clocks. Minimum SCL low time is 7 clocks of the I2C clock pre-divider.
 *  0b110..8 clocks. Minimum SCL low time is 8 clocks of the I2C clock pre-divider.
 *  0b111..9 clocks. Minimum SCL low time is 9 clocks of the I2C clock pre-divider.
 */
#define I2C_MSTTIME_MSTSCLLOW(x)                 (((uint32_t)(((uint32_t)(x)) << I2C_MSTTIME_MSTSCLLOW_SHIFT)) & I2C_MSTTIME_MSTSCLLOW_MASK)

#define I2C_MSTTIME_MSTSCLHIGH_MASK              (0x70U)
#define I2C_MSTTIME_MSTSCLHIGH_SHIFT             (4U)
/*! MSTSCLHIGH - Master SCL High time. Specifies the minimum high time that will be asserted by this
 *    master on SCL. Other masters in a multi-master system could shorten this time. This
 *    corresponds to the parameter tHIGH in the I2C bus specification. I2C bus specification parameters
 *    tSU;STO and tHD;STA have the same values and are also controlled by MSTSCLHIGH.
 *  0b000..2 clocks. Minimum SCL high time is 2 clock of the I2C clock pre-divider.
 *  0b001..3 clocks. Minimum SCL high time is 3 clocks of the I2C clock pre-divider .
 *  0b010..4 clocks. Minimum SCL high time is 4 clock of the I2C clock pre-divider.
 *  0b011..5 clocks. Minimum SCL high time is 5 clock of the I2C clock pre-divider.
 *  0b100..6 clocks. Minimum SCL high time is 6 clock of the I2C clock pre-divider.
 *  0b101..7 clocks. Minimum SCL high time is 7 clock of the I2C clock pre-divider.
 *  0b110..8 clocks. Minimum SCL high time is 8 clock of the I2C clock pre-divider.
 *  0b111..9 clocks. Minimum SCL high time is 9 clocks of the I2C clock pre-divider.
 */
#define I2C_MSTTIME_MSTSCLHIGH(x)                (((uint32_t)(((uint32_t)(x)) << I2C_MSTTIME_MSTSCLHIGH_SHIFT)) & I2C_MSTTIME_MSTSCLHIGH_MASK)
/*! @} */

/*! @name MSTDAT - Combined Master receiver and transmitter data register. */
/*! @{ */

#define I2C_MSTDAT_DATA_MASK                     (0xFFU)
#define I2C_MSTDAT_DATA_SHIFT                    (0U)
/*! DATA - Master function data register. Read: read the most recently received data for the Master
 *    function. Write: transmit data using the Master function.
 */
#define I2C_MSTDAT_DATA(x)                       (((uint32_t)(((uint32_t)(x)) << I2C_MSTDAT_DATA_SHIFT)) & I2C_MSTDAT_DATA_MASK)
/*! @} */

/*! @name SLVCTL - Slave control register. */
/*! @{ */

#define I2C_SLVCTL_SLVCONTINUE_MASK              (0x1U)
#define I2C_SLVCTL_SLVCONTINUE_SHIFT             (0U)
/*! SLVCONTINUE - Slave Continue.
 *  0b0..No effect.
 *  0b1..Continue. Informs the Slave function to continue to the next operation, by clearing the SLVPENDING flag
 *       in the STAT register. This must be done after writing transmit data, reading received data, or any other
 *       housekeeping related to the next bus operation. Automatic Operation has different requirements. SLVCONTINUE
 *       should not be set unless SLVPENDING = 1.
 */
#define I2C_SLVCTL_SLVCONTINUE(x)                (((uint32_t)(((uint32_t)(x)) << I2C_SLVCTL_SLVCONTINUE_SHIFT)) & I2C_SLVCTL_SLVCONTINUE_MASK)

#define I2C_SLVCTL_SLVNACK_MASK                  (0x2U)
#define I2C_SLVCTL_SLVNACK_SHIFT                 (1U)
/*! SLVNACK - Slave NACK.
 *  0b0..No effect.
 *  0b1..NACK. Causes the Slave function to NACK the master when the slave is receiving data from the master (Slave Receiver mode).
 */
#define I2C_SLVCTL_SLVNACK(x)                    (((uint32_t)(((uint32_t)(x)) << I2C_SLVCTL_SLVNACK_SHIFT)) & I2C_SLVCTL_SLVNACK_MASK)

#define I2C_SLVCTL_SLVDMA_MASK                   (0x8U)
#define I2C_SLVCTL_SLVDMA_SHIFT                  (3U)
/*! SLVDMA - Slave DMA enable.
 *  0b0..Disabled. No DMA requests are issued for Slave mode operation.
 *  0b1..Enabled. DMA requests are issued for I2C slave data transmission and reception.
 */
#define I2C_SLVCTL_SLVDMA(x)                     (((uint32_t)(((uint32_t)(x)) << I2C_SLVCTL_SLVDMA_SHIFT)) & I2C_SLVCTL_SLVDMA_MASK)

#define I2C_SLVCTL_AUTOACK_MASK                  (0x100U)
#define I2C_SLVCTL_AUTOACK_SHIFT                 (8U)
/*! AUTOACK - Automatic Acknowledge.When this bit is set, it will cause an I2C header which matches
 *    SLVADR0 and the direction set by AUTOMATCHREAD to be ACKed immediately; this is used with DMA
 *    to allow processing of the data without intervention. If this bit is clear and a header
 *    matches SLVADR0, the behavior is controlled by AUTONACK in the SLVADR0 register: allowing NACK or
 *    interrupt.
 *  0b0..Normal, non-automatic operation. If AUTONACK = 0, an SlvPending interrupt is generated when a matching
 *       address is received. If AUTONACK = 1, received addresses are NACKed (ignored).
 *  0b1..A header with matching SLVADR0 and matching direction as set by AUTOMATCHREAD will be ACKed immediately,
 *       allowing the master to move on to the data bytes. If the address matches SLVADR0, but the direction does
 *       not match AUTOMATCHREAD, the behavior will depend on the AUTONACK bit in the SLVADR0 register: if AUTONACK
 *       is set, then it will be Nacked; else if AUTONACK is clear, then a SlvPending interrupt is generated.
 */
#define I2C_SLVCTL_AUTOACK(x)                    (((uint32_t)(((uint32_t)(x)) << I2C_SLVCTL_AUTOACK_SHIFT)) & I2C_SLVCTL_AUTOACK_MASK)

#define I2C_SLVCTL_AUTOMATCHREAD_MASK            (0x200U)
#define I2C_SLVCTL_AUTOMATCHREAD_SHIFT           (9U)
/*! AUTOMATCHREAD - When AUTOACK is set, this bit controls whether it matches a read or write
 *    request on the next header with an address matching SLVADR0. Since DMA needs to be configured to
 *    match the transfer direction, the direction needs to be specified. This bit allows a direction to
 *    be chosen for the next operation.
 *  0b0..The expected next operation in Automatic Mode is an I2C write.
 *  0b1..The expected next operation in Automatic Mode is an I2C read.
 */
#define I2C_SLVCTL_AUTOMATCHREAD(x)              (((uint32_t)(((uint32_t)(x)) << I2C_SLVCTL_AUTOMATCHREAD_SHIFT)) & I2C_SLVCTL_AUTOMATCHREAD_MASK)
/*! @} */

/*! @name SLVDAT - Combined Slave receiver and transmitter data register. */
/*! @{ */

#define I2C_SLVDAT_DATA_MASK                     (0xFFU)
#define I2C_SLVDAT_DATA_SHIFT                    (0U)
/*! DATA - Slave function data register. Read: read the most recently received data for the Slave
 *    function. Write: transmit data using the Slave function.
 */
#define I2C_SLVDAT_DATA(x)                       (((uint32_t)(((uint32_t)(x)) << I2C_SLVDAT_DATA_SHIFT)) & I2C_SLVDAT_DATA_MASK)
/*! @} */

/*! @name SLVADR - Slave address register. */
/*! @{ */

#define I2C_SLVADR_SADISABLE_MASK                (0x1U)
#define I2C_SLVADR_SADISABLE_SHIFT               (0U)
/*! SADISABLE - Slave Address n Disable.
 *  0b0..Enabled. Slave Address n is enabled.
 *  0b1..Ignored Slave Address n is ignored.
 */
#define I2C_SLVADR_SADISABLE(x)                  (((uint32_t)(((uint32_t)(x)) << I2C_SLVADR_SADISABLE_SHIFT)) & I2C_SLVADR_SADISABLE_MASK)

#define I2C_SLVADR_SLVADR_MASK                   (0xFEU)
#define I2C_SLVADR_SLVADR_SHIFT                  (1U)
/*! SLVADR - Slave Address. Seven bit slave address that is compared to received addresses if enabled.
 */
#define I2C_SLVADR_SLVADR(x)                     (((uint32_t)(((uint32_t)(x)) << I2C_SLVADR_SLVADR_SHIFT)) & I2C_SLVADR_SLVADR_MASK)

#define I2C_SLVADR_AUTONACK_MASK                 (0x8000U)
#define I2C_SLVADR_AUTONACK_SHIFT                (15U)
/*! AUTONACK - Automatic NACK operation. Used in conjunction with AUTOACK and AUTOMATCHREAD, allows
 *    software to ignore I2C traffic while handling previous I2C data or other operations.
 *  0b0..Normal operation, matching I2C addresses are not ignored.
 *  0b1..Automatic-only mode. All incoming addresses are ignored (NACKed), unless AUTOACK is set, it matches
 *       SLVADRn, and AUTOMATCHREAD matches the direction.
 */
#define I2C_SLVADR_AUTONACK(x)                   (((uint32_t)(((uint32_t)(x)) << I2C_SLVADR_AUTONACK_SHIFT)) & I2C_SLVADR_AUTONACK_MASK)
/*! @} */

/* The count of I2C_SLVADR */
#define I2C_SLVADR_COUNT                         (4U)

/*! @name SLVQUAL0 - Slave Qualification for address 0. */
/*! @{ */

#define I2C_SLVQUAL0_QUALMODE0_MASK              (0x1U)
#define I2C_SLVQUAL0_QUALMODE0_SHIFT             (0U)
/*! QUALMODE0 - Qualify mode for slave address 0.
 *  0b0..Mask. The SLVQUAL0 field is used as a logical mask for matching address 0.
 *  0b1..Extend. The SLVQUAL0 field is used to extend address 0 matching in a range of addresses.
 */
#define I2C_SLVQUAL0_QUALMODE0(x)                (((uint32_t)(((uint32_t)(x)) << I2C_SLVQUAL0_QUALMODE0_SHIFT)) & I2C_SLVQUAL0_QUALMODE0_MASK)

#define I2C_SLVQUAL0_SLVQUAL0_MASK               (0xFEU)
#define I2C_SLVQUAL0_SLVQUAL0_SHIFT              (1U)
/*! SLVQUAL0 - Slave address Qualifier for address 0. A value of 0 causes the address in SLVADR0 to
 *    be used as-is, assuming that it is enabled. If QUALMODE0 = 0, any bit in this field which is
 *    set to 1 will cause an automatic match of the corresponding bit of the received address when it
 *    is compared to the SLVADR0 register. If QUALMODE0 = 1, an address range is matched for
 *    address 0. This range extends from the value defined by SLVADR0 to the address defined by SLVQUAL0
 *    (address matches when SLVADR0[7:1] <= received address <= SLVQUAL0[7:1]).
 */
#define I2C_SLVQUAL0_SLVQUAL0(x)                 (((uint32_t)(((uint32_t)(x)) << I2C_SLVQUAL0_SLVQUAL0_SHIFT)) & I2C_SLVQUAL0_SLVQUAL0_MASK)
/*! @} */

/*! @name MONRXDAT - Monitor receiver data register. */
/*! @{ */

#define I2C_MONRXDAT_MONRXDAT_MASK               (0xFFU)
#define I2C_MONRXDAT_MONRXDAT_SHIFT              (0U)
/*! MONRXDAT - Monitor function Receiver Data. This reflects every data byte that passes on the I2C pins.
 */
#define I2C_MONRXDAT_MONRXDAT(x)                 (((uint32_t)(((uint32_t)(x)) << I2C_MONRXDAT_MONRXDAT_SHIFT)) & I2C_MONRXDAT_MONRXDAT_MASK)

#define I2C_MONRXDAT_MONSTART_MASK               (0x100U)
#define I2C_MONRXDAT_MONSTART_SHIFT              (8U)
/*! MONSTART - Monitor Received Start.
 *  0b0..No start detected. The Monitor function has not detected a Start event on the I2C bus.
 *  0b1..Start detected. The Monitor function has detected a Start event on the I2C bus.
 */
#define I2C_MONRXDAT_MONSTART(x)                 (((uint32_t)(((uint32_t)(x)) << I2C_MONRXDAT_MONSTART_SHIFT)) & I2C_MONRXDAT_MONSTART_MASK)

#define I2C_MONRXDAT_MONRESTART_MASK             (0x200U)
#define I2C_MONRXDAT_MONRESTART_SHIFT            (9U)
/*! MONRESTART - Monitor Received Repeated Start.
 *  0b0..No repeated start detected. The Monitor function has not detected a Repeated Start event on the I2C bus.
 *  0b1..Repeated start detected. The Monitor function has detected a Repeated Start event on the I2C bus.
 */
#define I2C_MONRXDAT_MONRESTART(x)               (((uint32_t)(((uint32_t)(x)) << I2C_MONRXDAT_MONRESTART_SHIFT)) & I2C_MONRXDAT_MONRESTART_MASK)

#define I2C_MONRXDAT_MONNACK_MASK                (0x400U)
#define I2C_MONRXDAT_MONNACK_SHIFT               (10U)
/*! MONNACK - Monitor Received NACK.
 *  0b0..Acknowledged. The data currently being provided by the Monitor function was acknowledged by at least one master or slave receiver.
 *  0b1..Not acknowledged. The data currently being provided by the Monitor function was not acknowledged by any receiver.
 */
#define I2C_MONRXDAT_MONNACK(x)                  (((uint32_t)(((uint32_t)(x)) << I2C_MONRXDAT_MONNACK_SHIFT)) & I2C_MONRXDAT_MONNACK_MASK)
/*! @} */

/*! @name ID - Peripheral identification register. */
/*! @{ */

#define I2C_ID_APERTURE_MASK                     (0xFFU)
#define I2C_ID_APERTURE_SHIFT                    (0U)
/*! APERTURE - Aperture: encoded as (aperture size/4K) -1, so 0x00 means a 4K aperture.
 */
#define I2C_ID_APERTURE(x)                       (((uint32_t)(((uint32_t)(x)) << I2C_ID_APERTURE_SHIFT)) & I2C_ID_APERTURE_MASK)

#define I2C_ID_MINOR_REV_MASK                    (0xF00U)
#define I2C_ID_MINOR_REV_SHIFT                   (8U)
/*! MINOR_REV - Minor revision of module implementation.
 */
#define I2C_ID_MINOR_REV(x)                      (((uint32_t)(((uint32_t)(x)) << I2C_ID_MINOR_REV_SHIFT)) & I2C_ID_MINOR_REV_MASK)

#define I2C_ID_MAJOR_REV_MASK                    (0xF000U)
#define I2C_ID_MAJOR_REV_SHIFT                   (12U)
/*! MAJOR_REV - Major revision of module implementation.
 */
#define I2C_ID_MAJOR_REV(x)                      (((uint32_t)(((uint32_t)(x)) << I2C_ID_MAJOR_REV_SHIFT)) & I2C_ID_MAJOR_REV_MASK)

#define I2C_ID_ID_MASK                           (0xFFFF0000U)
#define I2C_ID_ID_SHIFT                          (16U)
/*! ID - Module identifier for the selected function.
 */
#define I2C_ID_ID(x)                             (((uint32_t)(((uint32_t)(x)) << I2C_ID_ID_SHIFT)) & I2C_ID_ID_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group I2C_Register_Masks */


/* I2C - Peripheral instance base addresses */
/** Peripheral I2C0 base address */
#define I2C0_BASE                                (0x40106000u)
/** Peripheral I2C0 base pointer */
#define I2C0                                     ((I2C_Type *)I2C0_BASE)
/** Peripheral I2C1 base address */
#define I2C1_BASE                                (0x40107000u)
/** Peripheral I2C1 base pointer */
#define I2C1                                     ((I2C_Type *)I2C1_BASE)
/** Peripheral I2C2 base address */
#define I2C2_BASE                                (0x40108000u)
/** Peripheral I2C2 base pointer */
#define I2C2                                     ((I2C_Type *)I2C2_BASE)
/** Peripheral I2C3 base address */
#define I2C3_BASE                                (0x40109000u)
/** Peripheral I2C3 base pointer */
#define I2C3                                     ((I2C_Type *)I2C3_BASE)
/** Peripheral I2C4 base address */
#define I2C4_BASE                                (0x40122000u)
/** Peripheral I2C4 base pointer */
#define I2C4                                     ((I2C_Type *)I2C4_BASE)
/** Peripheral I2C5 base address */
#define I2C5_BASE                                (0x40123000u)
/** Peripheral I2C5 base pointer */
#define I2C5                                     ((I2C_Type *)I2C5_BASE)
/** Peripheral I2C6 base address */
#define I2C6_BASE                                (0x40124000u)
/** Peripheral I2C6 base pointer */
#define I2C6                                     ((I2C_Type *)I2C6_BASE)
/** Peripheral I2C7 base address */
#define I2C7_BASE                                (0x40125000u)
/** Peripheral I2C7 base pointer */
#define I2C7                                     ((I2C_Type *)I2C7_BASE)
/** Peripheral I2C15 base address */
#define I2C15_BASE                               (0x40127000u)
/** Peripheral I2C15 base pointer */
#define I2C15                                    ((I2C_Type *)I2C15_BASE)
/** Array initializer of I2C peripheral base addresses */
#define I2C_BASE_ADDRS                           { I2C0_BASE, I2C1_BASE, I2C2_BASE, I2C3_BASE, I2C4_BASE, I2C5_BASE, I2C6_BASE, I2C7_BASE, I2C15_BASE }
/** Array initializer of I2C peripheral base pointers */
#define I2C_BASE_PTRS                            { I2C0, I2C1, I2C2, I2C3, I2C4, I2C5, I2C6, I2C7, I2C15 }
/** Interrupt vectors for the I2C peripheral type */
#define I2C_IRQS                                 { FLEXCOMM0_IRQn, FLEXCOMM1_IRQn, FLEXCOMM2_IRQn, FLEXCOMM3_IRQn, FLEXCOMM4_IRQn, FLEXCOMM5_IRQn, FLEXCOMM6_IRQn, FLEXCOMM7_IRQn, NotAvail_IRQn }

/*!
 * @}
 */ /* end of group I2C_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- I2S Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup I2S_Peripheral_Access_Layer I2S Peripheral Access Layer
 * @{
 */

/** I2S - Register Layout Typedef */
typedef struct {
       uint8_t RESERVED_0[3072];
  __IO uint32_t CFG1;                              /**< Configuration register 1 for the primary channel pair., offset: 0xC00 */
  __IO uint32_t CFG2;                              /**< Configuration register 2 for the primary channel pair., offset: 0xC04 */
  __IO uint32_t STAT;                              /**< Status register for the primary channel pair., offset: 0xC08 */
       uint8_t RESERVED_1[16];
  __IO uint32_t DIV;                               /**< Clock divider, used by all channel pairs., offset: 0xC1C */
  struct {                                         /* offset: 0xC20, array step: 0x20 */
    __IO uint32_t PCFG1;                             /**< Configuration register 1 for channel pair, array offset: 0xC20, array step: 0x20 */
    __IO uint32_t PCFG2;                             /**< Configuration register 2 for channel pair, array offset: 0xC24, array step: 0x20 */
    __IO uint32_t PSTAT;                             /**< Status register for channel pair, array offset: 0xC28, array step: 0x20 */
         uint8_t RESERVED_0[20];
  } SECCHANNEL[3];
       uint8_t RESERVED_2[384];
  __IO uint32_t FIFOCFG;                           /**< FIFO configuration and enable register., offset: 0xE00 */
  __IO uint32_t FIFOSTAT;                          /**< FIFO status register., offset: 0xE04 */
  __IO uint32_t FIFOTRIG;                          /**< FIFO trigger settings for interrupt and DMA request., offset: 0xE08 */
       uint8_t RESERVED_3[4];
  __IO uint32_t FIFOINTENSET;                      /**< FIFO interrupt enable set (enable) and read register., offset: 0xE10 */
  __IO uint32_t FIFOINTENCLR;                      /**< FIFO interrupt enable clear (disable) and read register., offset: 0xE14 */
  __I  uint32_t FIFOINTSTAT;                       /**< FIFO interrupt status register., offset: 0xE18 */
       uint8_t RESERVED_4[4];
  __O  uint32_t FIFOWR;                            /**< FIFO write data., offset: 0xE20 */
  __O  uint32_t FIFOWR48H;                         /**< FIFO write data for upper data bits. May only be used if the I2S is configured for 2x 24-bit data and not using DMA., offset: 0xE24 */
       uint8_t RESERVED_5[8];
  __I  uint32_t FIFORD;                            /**< FIFO read data., offset: 0xE30 */
  __I  uint32_t FIFORD48H;                         /**< FIFO read data for upper data bits. May only be used if the I2S is configured for 2x 24-bit data and not using DMA., offset: 0xE34 */
       uint8_t RESERVED_6[8];
  __I  uint32_t FIFORDNOPOP;                       /**< FIFO data read with no FIFO pop., offset: 0xE40 */
  __I  uint32_t FIFORD48HNOPOP;                    /**< FIFO data read for upper data bits with no FIFO pop. May only be used if the I2S is configured for 2x 24-bit data and not using DMA., offset: 0xE44 */
  __I  uint32_t FIFOSIZE;                          /**< FIFO size register, offset: 0xE48 */
       uint8_t RESERVED_7[432];
  __I  uint32_t ID;                                /**< I2S Module identification, offset: 0xFFC */
} I2S_Type;

/* ----------------------------------------------------------------------------
   -- I2S Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup I2S_Register_Masks I2S Register Masks
 * @{
 */

/*! @name CFG1 - Configuration register 1 for the primary channel pair. */
/*! @{ */

#define I2S_CFG1_MAINENABLE_MASK                 (0x1U)
#define I2S_CFG1_MAINENABLE_SHIFT                (0U)
/*! MAINENABLE - Main enable for I 2S function in this Flexcomm
 *  0b0..All I 2S channel pairs in this Flexcomm are disabled and the internal state machines, counters, and flags
 *       are reset. No other channel pairs can be enabled.
 *  0b1..This I 2S channel pair is enabled. Other channel pairs in this Flexcomm may be enabled in their individual PAIRENABLE bits.
 */
#define I2S_CFG1_MAINENABLE(x)                   (((uint32_t)(((uint32_t)(x)) << I2S_CFG1_MAINENABLE_SHIFT)) & I2S_CFG1_MAINENABLE_MASK)

#define I2S_CFG1_DATAPAUSE_MASK                  (0x2U)
#define I2S_CFG1_DATAPAUSE_SHIFT                 (1U)
/*! DATAPAUSE - Data flow Pause. Allows pausing data flow between the I2S serializer/deserializer
 *    and the FIFO. This could be done in order to change streams, or while restarting after a data
 *    underflow or overflow. When paused, FIFO operations can be done without corrupting data that is
 *    in the process of being sent or received. Once a data pause has been requested, the interface
 *    may need to complete sending data that was in progress before interrupting the flow of data.
 *    Software must check that the pause is actually in effect before taking action. This is done by
 *    monitoring the DATAPAUSED flag in the STAT register. When DATAPAUSE is cleared, data transfer
 *    will resume at the beginning of the next frame.
 *  0b0..Normal operation, or resuming normal operation at the next frame if the I2S has already been paused.
 *  0b1..A pause in the data flow is being requested. It is in effect when DATAPAUSED in STAT = 1.
 */
#define I2S_CFG1_DATAPAUSE(x)                    (((uint32_t)(((uint32_t)(x)) << I2S_CFG1_DATAPAUSE_SHIFT)) & I2S_CFG1_DATAPAUSE_MASK)

#define I2S_CFG1_PAIRCOUNT_MASK                  (0xCU)
#define I2S_CFG1_PAIRCOUNT_SHIFT                 (2U)
/*! PAIRCOUNT - Provides the number of I2S channel pairs in this Flexcomm This is a read-only field
 *    whose value may be different in other Flexcomms. 00 = there is 1 I2S channel pair in this
 *    Flexcomm. 01 = there are 2 I2S channel pairs in this Flexcomm. 10 = there are 3 I2S channel pairs
 *    in this Flexcomm. 11 = there are 4 I2S channel pairs in this Flexcomm.
 *  0b00..1 I2S channel pairs in this flexcomm
 *  0b01..2 I2S channel pairs in this flexcomm
 *  0b10..3 I2S channel pairs in this flexcomm
 *  0b11..4 I2S channel pairs in this flexcomm
 */
#define I2S_CFG1_PAIRCOUNT(x)                    (((uint32_t)(((uint32_t)(x)) << I2S_CFG1_PAIRCOUNT_SHIFT)) & I2S_CFG1_PAIRCOUNT_MASK)

#define I2S_CFG1_MSTSLVCFG_MASK                  (0x30U)
#define I2S_CFG1_MSTSLVCFG_SHIFT                 (4U)
/*! MSTSLVCFG - Master / slave configuration selection, determining how SCK and WS are used by all channel pairs in this Flexcomm.
 *  0b00..Normal slave mode, the default mode. SCK and WS are received from a master and used to transmit or receive data.
 *  0b01..WS synchronized master. WS is received from another master and used to synchronize the generation of
 *        SCK, when divided from the Flexcomm function clock.
 *  0b10..Master using an existing SCK. SCK is received and used directly to generate WS, as well as transmitting or receiving data.
 *  0b11..Normal master mode. SCK and WS are generated so they can be sent to one or more slave devices.
 */
#define I2S_CFG1_MSTSLVCFG(x)                    (((uint32_t)(((uint32_t)(x)) << I2S_CFG1_MSTSLVCFG_SHIFT)) & I2S_CFG1_MSTSLVCFG_MASK)

#define I2S_CFG1_MODE_MASK                       (0xC0U)
#define I2S_CFG1_MODE_SHIFT                      (6U)
/*! MODE - Selects the basic I2S operating mode. Other configurations modify this to obtain all
 *    supported cases. See Formats and modes for examples.
 *  0b00..I2S mode a.k.a. 'classic' mode. WS has a 50% duty cycle, with (for each enabled channel pair) one piece
 *        of left channel data occurring during the first phase, and one pieces of right channel data occurring
 *        during the second phase. In this mode, the data region begins one clock after the leading WS edge for the
 *        frame. For a 50% WS duty cycle, FRAMELEN must define an even number of I2S clocks for the frame. If
 *        FRAMELEN defines an odd number of clocks per frame, the extra clock will occur on the right.
 *  0b01..DSP mode where WS has a 50% duty cycle. See remark for mode 0.
 *  0b10..DSP mode where WS has a one clock long pulse at the beginning of each data frame.
 *  0b11..DSP mode where WS has a one data slot long pulse at the beginning of each data frame.
 */
#define I2S_CFG1_MODE(x)                         (((uint32_t)(((uint32_t)(x)) << I2S_CFG1_MODE_SHIFT)) & I2S_CFG1_MODE_MASK)

#define I2S_CFG1_RIGHTLOW_MASK                   (0x100U)
#define I2S_CFG1_RIGHTLOW_SHIFT                  (8U)
/*! RIGHTLOW - Right channel data is in the Low portion of FIFO data. Essentially, this swaps left
 *    and right channel data as it is transferred to or from the FIFO. This bit is not used if the
 *    data width is greater than 24 bits or if PDMDATA = 1. Note that if the ONECHANNEL field (bit 10
 *    of this register) = 1, the one channel to be used is the nominally the left channel. POSITION
 *    can still place that data in the frame where right channel data is normally located. if all
 *    enabled channel pairs have ONECHANNEL = 1, then RIGHTLOW = 1 is not allowed.
 *  0b0..The right channel is taken from the high part of the FIFO data. For example, when data is 16 bits, FIFO
 *       bits 31:16 are used for the right channel.
 *  0b1..The right channel is taken from the low part of the FIFO data. For example, when data is 16 bits, FIFO
 *       bits 15:0 are used for the right channel.
 */
#define I2S_CFG1_RIGHTLOW(x)                     (((uint32_t)(((uint32_t)(x)) << I2S_CFG1_RIGHTLOW_SHIFT)) & I2S_CFG1_RIGHTLOW_MASK)

#define I2S_CFG1_LEFTJUST_MASK                   (0x200U)
#define I2S_CFG1_LEFTJUST_SHIFT                  (9U)
/*! LEFTJUST - Left Justify data.
 *  0b0..Data is transferred between the FIFO and the I2S serializer/deserializer right justified, i.e. starting
 *       from bit 0 and continuing to the position defined by DATALEN. This would correspond to right justified data
 *       in the stream on the data bus.
 *  0b1..Data is transferred between the FIFO and the I2S serializer/deserializer left justified, i.e. starting
 *       from the MSB of the FIFO entry and continuing for the number of bits defined by DATALEN. This would
 *       correspond to left justified data in the stream on the data bus.
 */
#define I2S_CFG1_LEFTJUST(x)                     (((uint32_t)(((uint32_t)(x)) << I2S_CFG1_LEFTJUST_SHIFT)) & I2S_CFG1_LEFTJUST_MASK)

#define I2S_CFG1_ONECHANNEL_MASK                 (0x400U)
#define I2S_CFG1_ONECHANNEL_SHIFT                (10U)
/*! ONECHANNEL - Single channel mode. Applies to both transmit and receive. This configuration bit
 *    applies only to the first I2S channel pair. Other channel pairs may select this mode
 *    independently in their separate CFG1 registers.
 *  0b0..I2S data for this channel pair is treated as left and right channels.
 *  0b1..I2S data for this channel pair is treated as a single channel, functionally the left channel for this
 *       pair. In mode 0 only, the right side of the frame begins at POSITION = 0x100. This is because mode 0 makes a
 *       clear distinction between the left and right sides of the frame. When ONECHANNEL = 1, the single channel
 *       of data may be placed on the right by setting POSITION to 0x100 + the data position within the right side
 *       (e.g. 0x108 would place data starting at the 8th clock after the middle of the frame). In other modes, data
 *       for the single channel of data is placed at the clock defined by POSITION.
 */
#define I2S_CFG1_ONECHANNEL(x)                   (((uint32_t)(((uint32_t)(x)) << I2S_CFG1_ONECHANNEL_SHIFT)) & I2S_CFG1_ONECHANNEL_MASK)

#define I2S_CFG1_PDMDATA_MASK                    (0x800U)
#define I2S_CFG1_PDMDATA_SHIFT                   (11U)
/*! PDMDATA - PDM Data selection. This bit controls the data source for I2S transmit, and cannot be
 *    set in Rx mode. This bit only has an effect if the device the Flexcomm resides in includes a
 *    D-Mic subsystem. For the LPC5411x, this bit applies only to Flexcomm 7.
 *  0b0..Normal operation, data is transferred to or from the Flexcomm FIFO.
 *  0b1..The data source is the D-Mic subsystem. When PDMDATA = 1, only the primary channel pair can be used in
 *       this Flexcomm. If ONECHANNEL = 1, only the PDM left data is used. the WS rate must match the Fs (sample
 *       rate) of the D-Mic decimator. A rate mismatch will at some point cause the I2S to overrun or underrun.
 */
#define I2S_CFG1_PDMDATA(x)                      (((uint32_t)(((uint32_t)(x)) << I2S_CFG1_PDMDATA_SHIFT)) & I2S_CFG1_PDMDATA_MASK)

#define I2S_CFG1_SCK_POL_MASK                    (0x1000U)
#define I2S_CFG1_SCK_POL_SHIFT                   (12U)
/*! SCK_POL - SCK polarity.
 *  0b0..Data is launched on SCK falling edges and sampled on SCK rising edges (standard for I2S).
 *  0b1..Data is launched on SCK rising edges and sampled on SCK falling edges.
 */
#define I2S_CFG1_SCK_POL(x)                      (((uint32_t)(((uint32_t)(x)) << I2S_CFG1_SCK_POL_SHIFT)) & I2S_CFG1_SCK_POL_MASK)

#define I2S_CFG1_WS_POL_MASK                     (0x2000U)
#define I2S_CFG1_WS_POL_SHIFT                    (13U)
/*! WS_POL - WS polarity.
 *  0b0..Data frames begin at a falling edge of WS (standard for classic I2S).
 *  0b1..WS is inverted, resulting in a data frame beginning at a rising edge of WS (standard for most 'non-classic' variations of I2S).
 */
#define I2S_CFG1_WS_POL(x)                       (((uint32_t)(((uint32_t)(x)) << I2S_CFG1_WS_POL_SHIFT)) & I2S_CFG1_WS_POL_MASK)

#define I2S_CFG1_DATALEN_MASK                    (0x1F0000U)
#define I2S_CFG1_DATALEN_SHIFT                   (16U)
/*! DATALEN - Data Length, minus 1 encoded, defines the number of data bits to be transmitted or
 *    received for all I2S channel pairs in this Flexcomm. Note that data is only driven to or received
 *    from SDA for the number of bits defined by DATALEN. DATALEN is also used in these ways by the
 *    I2S: Determines the size of data transfers between the FIFO and the I2S
 *    serializer/deserializer. See FIFO buffer configurations and usage In mode 1, 2, and 3, determines the location of
 *    right data following left data in the frame. In mode 3 (where WS has a one data slot long pulse
 *    at the beginning of each data frame) determines the duration of the WS pulse. Values: 0x00 to
 *    0x02 = not supported 0x03 = data is 4 bits in length 0x04 = data is 5 bits in length 0x1F =
 *    data is 32 bits in length
 */
#define I2S_CFG1_DATALEN(x)                      (((uint32_t)(((uint32_t)(x)) << I2S_CFG1_DATALEN_SHIFT)) & I2S_CFG1_DATALEN_MASK)
/*! @} */

/*! @name CFG2 - Configuration register 2 for the primary channel pair. */
/*! @{ */

#define I2S_CFG2_FRAMELEN_MASK                   (0x7FFU)
#define I2S_CFG2_FRAMELEN_SHIFT                  (0U)
/*! FRAMELEN - Frame Length, minus 1 encoded, defines the number of clocks and data bits in the
 *    frames that this channel pair participates in.
 */
#define I2S_CFG2_FRAMELEN(x)                     (((uint32_t)(((uint32_t)(x)) << I2S_CFG2_FRAMELEN_SHIFT)) & I2S_CFG2_FRAMELEN_MASK)

#define I2S_CFG2_POSITION_MASK                   (0x7FF0000U)
#define I2S_CFG2_POSITION_SHIFT                  (16U)
/*! POSITION - Data Position.
 */
#define I2S_CFG2_POSITION(x)                     (((uint32_t)(((uint32_t)(x)) << I2S_CFG2_POSITION_SHIFT)) & I2S_CFG2_POSITION_MASK)
/*! @} */

/*! @name STAT - Status register for the primary channel pair. */
/*! @{ */

#define I2S_STAT_BUSY_MASK                       (0x1U)
#define I2S_STAT_BUSY_SHIFT                      (0U)
/*! BUSY - Busy status for the primary channel pair. Other BUSY flags may be found in the STAT register for each channel pair.
 *  0b0..The transmitter/receiver for channel pair is currently idle.
 *  0b1..The transmitter/receiver for channel pair is currently processing data.
 */
#define I2S_STAT_BUSY(x)                         (((uint32_t)(((uint32_t)(x)) << I2S_STAT_BUSY_SHIFT)) & I2S_STAT_BUSY_MASK)

#define I2S_STAT_SLVFRMERR_MASK                  (0x2U)
#define I2S_STAT_SLVFRMERR_SHIFT                 (1U)
/*! SLVFRMERR - Slave Frame Error flag. This applies when at least one channel pair is operating as
 *    a slave. An error indicates that the incoming WS signal did not transition as expected due to
 *    a mismatch between FRAMELEN and the actual incoming I2S stream.
 *  0b0..No error has been recorded.
 *  0b1..An error has been recorded for some channel pair that is operating in slave mode. ERROR is cleared by writing a 1 to this bit position.
 */
#define I2S_STAT_SLVFRMERR(x)                    (((uint32_t)(((uint32_t)(x)) << I2S_STAT_SLVFRMERR_SHIFT)) & I2S_STAT_SLVFRMERR_MASK)

#define I2S_STAT_LR_MASK                         (0x4U)
#define I2S_STAT_LR_SHIFT                        (2U)
/*! LR - Left/Right indication. This flag is considered to be a debugging aid and is not expected to
 *    be used by an I2S driver. Valid when one channel pair is busy. Indicates left or right data
 *    being processed for the currently busy channel pair.
 *  0b0..Left channel.
 *  0b1..Right channel.
 */
#define I2S_STAT_LR(x)                           (((uint32_t)(((uint32_t)(x)) << I2S_STAT_LR_SHIFT)) & I2S_STAT_LR_MASK)

#define I2S_STAT_DATAPAUSED_MASK                 (0x8U)
#define I2S_STAT_DATAPAUSED_SHIFT                (3U)
/*! DATAPAUSED - Data Paused status flag. Applies to all I2S channels
 *  0b0..Data is not currently paused. A data pause may have been requested but is not yet in force, waiting for
 *       an allowed pause point. Refer to the description of the DATAPAUSE control bit in the CFG1 register.
 *  0b1..A data pause has been requested and is now in force.
 */
#define I2S_STAT_DATAPAUSED(x)                   (((uint32_t)(((uint32_t)(x)) << I2S_STAT_DATAPAUSED_SHIFT)) & I2S_STAT_DATAPAUSED_MASK)
/*! @} */

/*! @name DIV - Clock divider, used by all channel pairs. */
/*! @{ */

#define I2S_DIV_DIV_MASK                         (0xFFFU)
#define I2S_DIV_DIV_SHIFT                        (0U)
/*! DIV - This field controls how this I2S block uses the Flexcomm function clock. 0x000 = The
 *    Flexcomm function clock is used directly. 0x001 = The Flexcomm function clock is divided by 2.
 *    0x002 = The Flexcomm function clock is divided by 3. 0xFFF = The Flexcomm function clock is
 *    divided by 4,096.
 */
#define I2S_DIV_DIV(x)                           (((uint32_t)(((uint32_t)(x)) << I2S_DIV_DIV_SHIFT)) & I2S_DIV_DIV_MASK)
/*! @} */

/*! @name SECCHANNEL_PCFG1 - Configuration register 1 for channel pair */
/*! @{ */

#define I2S_SECCHANNEL_PCFG1_PAIRENABLE_MASK     (0x1U)
#define I2S_SECCHANNEL_PCFG1_PAIRENABLE_SHIFT    (0U)
/*! PAIRENABLE - Enable for this channel pair..
 */
#define I2S_SECCHANNEL_PCFG1_PAIRENABLE(x)       (((uint32_t)(((uint32_t)(x)) << I2S_SECCHANNEL_PCFG1_PAIRENABLE_SHIFT)) & I2S_SECCHANNEL_PCFG1_PAIRENABLE_MASK)

#define I2S_SECCHANNEL_PCFG1_ONECHANNEL_MASK     (0x400U)
#define I2S_SECCHANNEL_PCFG1_ONECHANNEL_SHIFT    (10U)
/*! ONECHANNEL - Single channel mode.
 */
#define I2S_SECCHANNEL_PCFG1_ONECHANNEL(x)       (((uint32_t)(((uint32_t)(x)) << I2S_SECCHANNEL_PCFG1_ONECHANNEL_SHIFT)) & I2S_SECCHANNEL_PCFG1_ONECHANNEL_MASK)
/*! @} */

/* The count of I2S_SECCHANNEL_PCFG1 */
#define I2S_SECCHANNEL_PCFG1_COUNT               (3U)

/*! @name SECCHANNEL_PCFG2 - Configuration register 2 for channel pair */
/*! @{ */

#define I2S_SECCHANNEL_PCFG2_POSITION_MASK       (0x1FF0000U)
#define I2S_SECCHANNEL_PCFG2_POSITION_SHIFT      (16U)
/*! POSITION - Data Position.
 */
#define I2S_SECCHANNEL_PCFG2_POSITION(x)         (((uint32_t)(((uint32_t)(x)) << I2S_SECCHANNEL_PCFG2_POSITION_SHIFT)) & I2S_SECCHANNEL_PCFG2_POSITION_MASK)
/*! @} */

/* The count of I2S_SECCHANNEL_PCFG2 */
#define I2S_SECCHANNEL_PCFG2_COUNT               (3U)

/*! @name SECCHANNEL_PSTAT - Status register for channel pair */
/*! @{ */

#define I2S_SECCHANNEL_PSTAT_BUSY_MASK           (0x1U)
#define I2S_SECCHANNEL_PSTAT_BUSY_SHIFT          (0U)
/*! BUSY - Busy status for this channel pair.
 */
#define I2S_SECCHANNEL_PSTAT_BUSY(x)             (((uint32_t)(((uint32_t)(x)) << I2S_SECCHANNEL_PSTAT_BUSY_SHIFT)) & I2S_SECCHANNEL_PSTAT_BUSY_MASK)

#define I2S_SECCHANNEL_PSTAT_SLVFRMERR_MASK      (0x2U)
#define I2S_SECCHANNEL_PSTAT_SLVFRMERR_SHIFT     (1U)
/*! SLVFRMERR - Save Frame Error flag.
 */
#define I2S_SECCHANNEL_PSTAT_SLVFRMERR(x)        (((uint32_t)(((uint32_t)(x)) << I2S_SECCHANNEL_PSTAT_SLVFRMERR_SHIFT)) & I2S_SECCHANNEL_PSTAT_SLVFRMERR_MASK)

#define I2S_SECCHANNEL_PSTAT_LR_MASK             (0x4U)
#define I2S_SECCHANNEL_PSTAT_LR_SHIFT            (2U)
/*! LR - Left/Right indication.
 */
#define I2S_SECCHANNEL_PSTAT_LR(x)               (((uint32_t)(((uint32_t)(x)) << I2S_SECCHANNEL_PSTAT_LR_SHIFT)) & I2S_SECCHANNEL_PSTAT_LR_MASK)

#define I2S_SECCHANNEL_PSTAT_DATAPAUSED_MASK     (0x8U)
#define I2S_SECCHANNEL_PSTAT_DATAPAUSED_SHIFT    (3U)
/*! DATAPAUSED - Data Paused status flag.
 */
#define I2S_SECCHANNEL_PSTAT_DATAPAUSED(x)       (((uint32_t)(((uint32_t)(x)) << I2S_SECCHANNEL_PSTAT_DATAPAUSED_SHIFT)) & I2S_SECCHANNEL_PSTAT_DATAPAUSED_MASK)
/*! @} */

/* The count of I2S_SECCHANNEL_PSTAT */
#define I2S_SECCHANNEL_PSTAT_COUNT               (3U)

/*! @name FIFOCFG - FIFO configuration and enable register. */
/*! @{ */

#define I2S_FIFOCFG_ENABLETX_MASK                (0x1U)
#define I2S_FIFOCFG_ENABLETX_SHIFT               (0U)
/*! ENABLETX - Enable the transmit FIFO.
 *  0b0..The transmit FIFO is not enabled.
 *  0b1..The transmit FIFO is enabled.
 */
#define I2S_FIFOCFG_ENABLETX(x)                  (((uint32_t)(((uint32_t)(x)) << I2S_FIFOCFG_ENABLETX_SHIFT)) & I2S_FIFOCFG_ENABLETX_MASK)

#define I2S_FIFOCFG_ENABLERX_MASK                (0x2U)
#define I2S_FIFOCFG_ENABLERX_SHIFT               (1U)
/*! ENABLERX - Enable the receive FIFO.
 *  0b0..The receive FIFO is not enabled.
 *  0b1..The receive FIFO is enabled.
 */
#define I2S_FIFOCFG_ENABLERX(x)                  (((uint32_t)(((uint32_t)(x)) << I2S_FIFOCFG_ENABLERX_SHIFT)) & I2S_FIFOCFG_ENABLERX_MASK)

#define I2S_FIFOCFG_TXI2SE0_MASK                 (0x4U)
#define I2S_FIFOCFG_TXI2SE0_SHIFT                (2U)
/*! TXI2SE0 - Transmit I2S empty 0. Determines the value sent by the I2S in transmit mode if the TX
 *    FIFO becomes empty. This value is sent repeatedly until the I2S is paused, the error is
 *    cleared, new data is provided, and the I2S is un-paused.
 *  0b0..If the TX FIFO becomes empty, the last value is sent. This setting may be used when the data length is 24
 *       bits or less, or when MONO = 1 for this channel pair.
 *  0b1..If the TX FIFO becomes empty, 0 is sent. Use if the data length is greater than 24 bits or if zero fill is preferred.
 */
#define I2S_FIFOCFG_TXI2SE0(x)                   (((uint32_t)(((uint32_t)(x)) << I2S_FIFOCFG_TXI2SE0_SHIFT)) & I2S_FIFOCFG_TXI2SE0_MASK)

#define I2S_FIFOCFG_PACK48_MASK                  (0x8U)
#define I2S_FIFOCFG_PACK48_SHIFT                 (3U)
/*! PACK48 - Packing format for 48-bit data. This relates to how data is entered into or taken from the FIFO by software or DMA.
 *  0b0..48-bit I2S FIFO entries are handled as all 24-bit values.
 *  0b1..48-bit I2S FIFO entries are handled as alternating 32-bit and 16-bit values.
 */
#define I2S_FIFOCFG_PACK48(x)                    (((uint32_t)(((uint32_t)(x)) << I2S_FIFOCFG_PACK48_SHIFT)) & I2S_FIFOCFG_PACK48_MASK)

#define I2S_FIFOCFG_SIZE_MASK                    (0x30U)
#define I2S_FIFOCFG_SIZE_SHIFT                   (4U)
/*! SIZE - FIFO size configuration. This is a read-only field. 0x0 = FIFO is configured as 16
 *    entries of 8 bits. 0x1, 0x2, 0x3 = not applicable to USART.
 */
#define I2S_FIFOCFG_SIZE(x)                      (((uint32_t)(((uint32_t)(x)) << I2S_FIFOCFG_SIZE_SHIFT)) & I2S_FIFOCFG_SIZE_MASK)

#define I2S_FIFOCFG_DMATX_MASK                   (0x1000U)
#define I2S_FIFOCFG_DMATX_SHIFT                  (12U)
/*! DMATX - DMA configuration for transmit.
 *  0b0..DMA is not used for the transmit function.
 *  0b1..Trigger DMA for the transmit function if the FIFO is not full. Generally, data interrupts would be disabled if DMA is enabled.
 */
#define I2S_FIFOCFG_DMATX(x)                     (((uint32_t)(((uint32_t)(x)) << I2S_FIFOCFG_DMATX_SHIFT)) & I2S_FIFOCFG_DMATX_MASK)

#define I2S_FIFOCFG_DMARX_MASK                   (0x2000U)
#define I2S_FIFOCFG_DMARX_SHIFT                  (13U)
/*! DMARX - DMA configuration for receive.
 *  0b0..DMA is not used for the receive function.
 *  0b1..Trigger DMA for the receive function if the FIFO is not empty. Generally, data interrupts would be disabled if DMA is enabled.
 */
#define I2S_FIFOCFG_DMARX(x)                     (((uint32_t)(((uint32_t)(x)) << I2S_FIFOCFG_DMARX_SHIFT)) & I2S_FIFOCFG_DMARX_MASK)

#define I2S_FIFOCFG_WAKETX_MASK                  (0x4000U)
#define I2S_FIFOCFG_WAKETX_SHIFT                 (14U)
/*! WAKETX - Wake-up for transmit FIFO level. This allows the device to be woken from reduced power
 *    modes (up to power-down, as long as the peripheral function works in that power mode) without
 *    enabling the TXLVL interrupt. Only DMA wakes up, processes data, and goes back to sleep. The
 *    CPU will remain stopped until woken by another cause, such as DMA completion. See Hardware
 *    Wake-up control register.
 *  0b0..Only enabled interrupts will wake up the device form reduced power modes.
 *  0b1..A device wake-up for DMA will occur if the transmit FIFO level reaches the value specified by TXLVL in
 *       FIFOTRIG, even when the TXLVL interrupt is not enabled.
 */
#define I2S_FIFOCFG_WAKETX(x)                    (((uint32_t)(((uint32_t)(x)) << I2S_FIFOCFG_WAKETX_SHIFT)) & I2S_FIFOCFG_WAKETX_MASK)

#define I2S_FIFOCFG_WAKERX_MASK                  (0x8000U)
#define I2S_FIFOCFG_WAKERX_SHIFT                 (15U)
/*! WAKERX - Wake-up for receive FIFO level. This allows the device to be woken from reduced power
 *    modes (up to power-down, as long as the peripheral function works in that power mode) without
 *    enabling the TXLVL interrupt. Only DMA wakes up, processes data, and goes back to sleep. The
 *    CPU will remain stopped until woken by another cause, such as DMA completion. See Hardware
 *    Wake-up control register.
 *  0b0..Only enabled interrupts will wake up the device form reduced power modes.
 *  0b1..A device wake-up for DMA will occur if the receive FIFO level reaches the value specified by RXLVL in
 *       FIFOTRIG, even when the RXLVL interrupt is not enabled.
 */
#define I2S_FIFOCFG_WAKERX(x)                    (((uint32_t)(((uint32_t)(x)) << I2S_FIFOCFG_WAKERX_SHIFT)) & I2S_FIFOCFG_WAKERX_MASK)

#define I2S_FIFOCFG_EMPTYTX_MASK                 (0x10000U)
#define I2S_FIFOCFG_EMPTYTX_SHIFT                (16U)
/*! EMPTYTX - Empty command for the transmit FIFO. When a 1 is written to this bit, the TX FIFO is emptied.
 */
#define I2S_FIFOCFG_EMPTYTX(x)                   (((uint32_t)(((uint32_t)(x)) << I2S_FIFOCFG_EMPTYTX_SHIFT)) & I2S_FIFOCFG_EMPTYTX_MASK)

#define I2S_FIFOCFG_EMPTYRX_MASK                 (0x20000U)
#define I2S_FIFOCFG_EMPTYRX_SHIFT                (17U)
/*! EMPTYRX - Empty command for the receive FIFO. When a 1 is written to this bit, the RX FIFO is emptied.
 */
#define I2S_FIFOCFG_EMPTYRX(x)                   (((uint32_t)(((uint32_t)(x)) << I2S_FIFOCFG_EMPTYRX_SHIFT)) & I2S_FIFOCFG_EMPTYRX_MASK)
/*! @} */

/*! @name FIFOSTAT - FIFO status register. */
/*! @{ */

#define I2S_FIFOSTAT_TXERR_MASK                  (0x1U)
#define I2S_FIFOSTAT_TXERR_SHIFT                 (0U)
/*! TXERR - TX FIFO error. Will be set if a transmit FIFO error occurs. This could be an overflow
 *    caused by pushing data into a full FIFO, or by an underflow if the FIFO is empty when data is
 *    needed. Cleared by writing a 1 to this bit.
 */
#define I2S_FIFOSTAT_TXERR(x)                    (((uint32_t)(((uint32_t)(x)) << I2S_FIFOSTAT_TXERR_SHIFT)) & I2S_FIFOSTAT_TXERR_MASK)

#define I2S_FIFOSTAT_RXERR_MASK                  (0x2U)
#define I2S_FIFOSTAT_RXERR_SHIFT                 (1U)
/*! RXERR - RX FIFO error. Will be set if a receive FIFO overflow occurs, caused by software or DMA
 *    not emptying the FIFO fast enough. Cleared by writing a 1 to this bit.
 */
#define I2S_FIFOSTAT_RXERR(x)                    (((uint32_t)(((uint32_t)(x)) << I2S_FIFOSTAT_RXERR_SHIFT)) & I2S_FIFOSTAT_RXERR_MASK)

#define I2S_FIFOSTAT_PERINT_MASK                 (0x8U)
#define I2S_FIFOSTAT_PERINT_SHIFT                (3U)
/*! PERINT - Peripheral interrupt. When 1, this indicates that the peripheral function has asserted
 *    an interrupt. The details can be found by reading the peripheral's STAT register.
 */
#define I2S_FIFOSTAT_PERINT(x)                   (((uint32_t)(((uint32_t)(x)) << I2S_FIFOSTAT_PERINT_SHIFT)) & I2S_FIFOSTAT_PERINT_MASK)

#define I2S_FIFOSTAT_TXEMPTY_MASK                (0x10U)
#define I2S_FIFOSTAT_TXEMPTY_SHIFT               (4U)
/*! TXEMPTY - Transmit FIFO empty. When 1, the transmit FIFO is empty. The peripheral may still be processing the last piece of data.
 */
#define I2S_FIFOSTAT_TXEMPTY(x)                  (((uint32_t)(((uint32_t)(x)) << I2S_FIFOSTAT_TXEMPTY_SHIFT)) & I2S_FIFOSTAT_TXEMPTY_MASK)

#define I2S_FIFOSTAT_TXNOTFULL_MASK              (0x20U)
#define I2S_FIFOSTAT_TXNOTFULL_SHIFT             (5U)
/*! TXNOTFULL - Transmit FIFO not full. When 1, the transmit FIFO is not full, so more data can be
 *    written. When 0, the transmit FIFO is full and another write would cause it to overflow.
 */
#define I2S_FIFOSTAT_TXNOTFULL(x)                (((uint32_t)(((uint32_t)(x)) << I2S_FIFOSTAT_TXNOTFULL_SHIFT)) & I2S_FIFOSTAT_TXNOTFULL_MASK)

#define I2S_FIFOSTAT_RXNOTEMPTY_MASK             (0x40U)
#define I2S_FIFOSTAT_RXNOTEMPTY_SHIFT            (6U)
/*! RXNOTEMPTY - Receive FIFO not empty. When 1, the receive FIFO is not empty, so data can be read. When 0, the receive FIFO is empty.
 */
#define I2S_FIFOSTAT_RXNOTEMPTY(x)               (((uint32_t)(((uint32_t)(x)) << I2S_FIFOSTAT_RXNOTEMPTY_SHIFT)) & I2S_FIFOSTAT_RXNOTEMPTY_MASK)

#define I2S_FIFOSTAT_RXFULL_MASK                 (0x80U)
#define I2S_FIFOSTAT_RXFULL_SHIFT                (7U)
/*! RXFULL - Receive FIFO full. When 1, the receive FIFO is full. Data needs to be read out to
 *    prevent the peripheral from causing an overflow.
 */
#define I2S_FIFOSTAT_RXFULL(x)                   (((uint32_t)(((uint32_t)(x)) << I2S_FIFOSTAT_RXFULL_SHIFT)) & I2S_FIFOSTAT_RXFULL_MASK)

#define I2S_FIFOSTAT_TXLVL_MASK                  (0x1F00U)
#define I2S_FIFOSTAT_TXLVL_SHIFT                 (8U)
/*! TXLVL - Transmit FIFO current level. A 0 means the TX FIFO is currently empty, and the TXEMPTY
 *    and TXNOTFULL flags will be 1. Other values tell how much data is actually in the TX FIFO at
 *    the point where the read occurs. If the TX FIFO is full, the TXEMPTY and TXNOTFULL flags will be
 *    0.
 */
#define I2S_FIFOSTAT_TXLVL(x)                    (((uint32_t)(((uint32_t)(x)) << I2S_FIFOSTAT_TXLVL_SHIFT)) & I2S_FIFOSTAT_TXLVL_MASK)

#define I2S_FIFOSTAT_RXLVL_MASK                  (0x1F0000U)
#define I2S_FIFOSTAT_RXLVL_SHIFT                 (16U)
/*! RXLVL - Receive FIFO current level. A 0 means the RX FIFO is currently empty, and the RXFULL and
 *    RXNOTEMPTY flags will be 0. Other values tell how much data is actually in the RX FIFO at the
 *    point where the read occurs. If the RX FIFO is full, the RXFULL and RXNOTEMPTY flags will be
 *    1.
 */
#define I2S_FIFOSTAT_RXLVL(x)                    (((uint32_t)(((uint32_t)(x)) << I2S_FIFOSTAT_RXLVL_SHIFT)) & I2S_FIFOSTAT_RXLVL_MASK)
/*! @} */

/*! @name FIFOTRIG - FIFO trigger settings for interrupt and DMA request. */
/*! @{ */

#define I2S_FIFOTRIG_TXLVLENA_MASK               (0x1U)
#define I2S_FIFOTRIG_TXLVLENA_SHIFT              (0U)
/*! TXLVLENA - Transmit FIFO level trigger enable. This trigger will become an interrupt if enabled
 *    in FIFOINTENSET, or a DMA trigger if DMATX in FIFOCFG is set.
 *  0b0..Transmit FIFO level does not generate a FIFO level trigger.
 *  0b1..An trigger will be generated if the transmit FIFO level reaches the value specified by the TXLVL field in this register.
 */
#define I2S_FIFOTRIG_TXLVLENA(x)                 (((uint32_t)(((uint32_t)(x)) << I2S_FIFOTRIG_TXLVLENA_SHIFT)) & I2S_FIFOTRIG_TXLVLENA_MASK)

#define I2S_FIFOTRIG_RXLVLENA_MASK               (0x2U)
#define I2S_FIFOTRIG_RXLVLENA_SHIFT              (1U)
/*! RXLVLENA - Receive FIFO level trigger enable. This trigger will become an interrupt if enabled
 *    in FIFOINTENSET, or a DMA trigger if DMARX in FIFOCFG is set.
 *  0b0..Receive FIFO level does not generate a FIFO level trigger.
 *  0b1..An trigger will be generated if the receive FIFO level reaches the value specified by the RXLVL field in this register.
 */
#define I2S_FIFOTRIG_RXLVLENA(x)                 (((uint32_t)(((uint32_t)(x)) << I2S_FIFOTRIG_RXLVLENA_SHIFT)) & I2S_FIFOTRIG_RXLVLENA_MASK)

#define I2S_FIFOTRIG_TXLVL_MASK                  (0xF00U)
#define I2S_FIFOTRIG_TXLVL_SHIFT                 (8U)
/*! TXLVL - Transmit FIFO level trigger point. This field is used only when TXLVLENA = 1. If enabled
 *    to do so, the FIFO level can wake up the device just enough to perform DMA, then return to
 *    the reduced power mode. See Hardware Wake-up control register. 0 = trigger when the TX FIFO
 *    becomes empty. 1 = trigger when the TX FIFO level decreases to one entry. 15 = trigger when the TX
 *    FIFO level decreases to 15 entries (is no longer full).
 */
#define I2S_FIFOTRIG_TXLVL(x)                    (((uint32_t)(((uint32_t)(x)) << I2S_FIFOTRIG_TXLVL_SHIFT)) & I2S_FIFOTRIG_TXLVL_MASK)

#define I2S_FIFOTRIG_RXLVL_MASK                  (0xF0000U)
#define I2S_FIFOTRIG_RXLVL_SHIFT                 (16U)
/*! RXLVL - Receive FIFO level trigger point. The RX FIFO level is checked when a new piece of data
 *    is received. This field is used only when RXLVLENA = 1. If enabled to do so, the FIFO level
 *    can wake up the device just enough to perform DMA, then return to the reduced power mode. See
 *    Hardware Wake-up control register. 0 = trigger when the RX FIFO has received one entry (is no
 *    longer empty). 1 = trigger when the RX FIFO has received two entries. 15 = trigger when the RX
 *    FIFO has received 16 entries (has become full).
 */
#define I2S_FIFOTRIG_RXLVL(x)                    (((uint32_t)(((uint32_t)(x)) << I2S_FIFOTRIG_RXLVL_SHIFT)) & I2S_FIFOTRIG_RXLVL_MASK)
/*! @} */

/*! @name FIFOINTENSET - FIFO interrupt enable set (enable) and read register. */
/*! @{ */

#define I2S_FIFOINTENSET_TXERR_MASK              (0x1U)
#define I2S_FIFOINTENSET_TXERR_SHIFT             (0U)
/*! TXERR - Determines whether an interrupt occurs when a transmit error occurs, based on the TXERR flag in the FIFOSTAT register.
 *  0b0..No interrupt will be generated for a transmit error.
 *  0b1..An interrupt will be generated when a transmit error occurs.
 */
#define I2S_FIFOINTENSET_TXERR(x)                (((uint32_t)(((uint32_t)(x)) << I2S_FIFOINTENSET_TXERR_SHIFT)) & I2S_FIFOINTENSET_TXERR_MASK)

#define I2S_FIFOINTENSET_RXERR_MASK              (0x2U)
#define I2S_FIFOINTENSET_RXERR_SHIFT             (1U)
/*! RXERR - Determines whether an interrupt occurs when a receive error occurs, based on the RXERR flag in the FIFOSTAT register.
 *  0b0..No interrupt will be generated for a receive error.
 *  0b1..An interrupt will be generated when a receive error occurs.
 */
#define I2S_FIFOINTENSET_RXERR(x)                (((uint32_t)(((uint32_t)(x)) << I2S_FIFOINTENSET_RXERR_SHIFT)) & I2S_FIFOINTENSET_RXERR_MASK)

#define I2S_FIFOINTENSET_TXLVL_MASK              (0x4U)
#define I2S_FIFOINTENSET_TXLVL_SHIFT             (2U)
/*! TXLVL - Determines whether an interrupt occurs when a the transmit FIFO reaches the level
 *    specified by the TXLVL field in the FIFOTRIG register.
 *  0b0..No interrupt will be generated based on the TX FIFO level.
 *  0b1..If TXLVLENA in the FIFOTRIG register = 1, an interrupt will be generated when the TX FIFO level decreases
 *       to the level specified by TXLVL in the FIFOTRIG register.
 */
#define I2S_FIFOINTENSET_TXLVL(x)                (((uint32_t)(((uint32_t)(x)) << I2S_FIFOINTENSET_TXLVL_SHIFT)) & I2S_FIFOINTENSET_TXLVL_MASK)

#define I2S_FIFOINTENSET_RXLVL_MASK              (0x8U)
#define I2S_FIFOINTENSET_RXLVL_SHIFT             (3U)
/*! RXLVL - Determines whether an interrupt occurs when a the receive FIFO reaches the level
 *    specified by the TXLVL field in the FIFOTRIG register.
 *  0b0..No interrupt will be generated based on the RX FIFO level.
 *  0b1..If RXLVLENA in the FIFOTRIG register = 1, an interrupt will be generated when the when the RX FIFO level
 *       increases to the level specified by RXLVL in the FIFOTRIG register.
 */
#define I2S_FIFOINTENSET_RXLVL(x)                (((uint32_t)(((uint32_t)(x)) << I2S_FIFOINTENSET_RXLVL_SHIFT)) & I2S_FIFOINTENSET_RXLVL_MASK)
/*! @} */

/*! @name FIFOINTENCLR - FIFO interrupt enable clear (disable) and read register. */
/*! @{ */

#define I2S_FIFOINTENCLR_TXERR_MASK              (0x1U)
#define I2S_FIFOINTENCLR_TXERR_SHIFT             (0U)
/*! TXERR - Writing one clears the corresponding bits in the FIFOINTENSET register.
 */
#define I2S_FIFOINTENCLR_TXERR(x)                (((uint32_t)(((uint32_t)(x)) << I2S_FIFOINTENCLR_TXERR_SHIFT)) & I2S_FIFOINTENCLR_TXERR_MASK)

#define I2S_FIFOINTENCLR_RXERR_MASK              (0x2U)
#define I2S_FIFOINTENCLR_RXERR_SHIFT             (1U)
/*! RXERR - Writing one clears the corresponding bits in the FIFOINTENSET register.
 */
#define I2S_FIFOINTENCLR_RXERR(x)                (((uint32_t)(((uint32_t)(x)) << I2S_FIFOINTENCLR_RXERR_SHIFT)) & I2S_FIFOINTENCLR_RXERR_MASK)

#define I2S_FIFOINTENCLR_TXLVL_MASK              (0x4U)
#define I2S_FIFOINTENCLR_TXLVL_SHIFT             (2U)
/*! TXLVL - Writing one clears the corresponding bits in the FIFOINTENSET register.
 */
#define I2S_FIFOINTENCLR_TXLVL(x)                (((uint32_t)(((uint32_t)(x)) << I2S_FIFOINTENCLR_TXLVL_SHIFT)) & I2S_FIFOINTENCLR_TXLVL_MASK)

#define I2S_FIFOINTENCLR_RXLVL_MASK              (0x8U)
#define I2S_FIFOINTENCLR_RXLVL_SHIFT             (3U)
/*! RXLVL - Writing one clears the corresponding bits in the FIFOINTENSET register.
 */
#define I2S_FIFOINTENCLR_RXLVL(x)                (((uint32_t)(((uint32_t)(x)) << I2S_FIFOINTENCLR_RXLVL_SHIFT)) & I2S_FIFOINTENCLR_RXLVL_MASK)
/*! @} */

/*! @name FIFOINTSTAT - FIFO interrupt status register. */
/*! @{ */

#define I2S_FIFOINTSTAT_TXERR_MASK               (0x1U)
#define I2S_FIFOINTSTAT_TXERR_SHIFT              (0U)
/*! TXERR - TX FIFO error.
 */
#define I2S_FIFOINTSTAT_TXERR(x)                 (((uint32_t)(((uint32_t)(x)) << I2S_FIFOINTSTAT_TXERR_SHIFT)) & I2S_FIFOINTSTAT_TXERR_MASK)

#define I2S_FIFOINTSTAT_RXERR_MASK               (0x2U)
#define I2S_FIFOINTSTAT_RXERR_SHIFT              (1U)
/*! RXERR - RX FIFO error.
 */
#define I2S_FIFOINTSTAT_RXERR(x)                 (((uint32_t)(((uint32_t)(x)) << I2S_FIFOINTSTAT_RXERR_SHIFT)) & I2S_FIFOINTSTAT_RXERR_MASK)

#define I2S_FIFOINTSTAT_TXLVL_MASK               (0x4U)
#define I2S_FIFOINTSTAT_TXLVL_SHIFT              (2U)
/*! TXLVL - Transmit FIFO level interrupt.
 */
#define I2S_FIFOINTSTAT_TXLVL(x)                 (((uint32_t)(((uint32_t)(x)) << I2S_FIFOINTSTAT_TXLVL_SHIFT)) & I2S_FIFOINTSTAT_TXLVL_MASK)

#define I2S_FIFOINTSTAT_RXLVL_MASK               (0x8U)
#define I2S_FIFOINTSTAT_RXLVL_SHIFT              (3U)
/*! RXLVL - Receive FIFO level interrupt.
 */
#define I2S_FIFOINTSTAT_RXLVL(x)                 (((uint32_t)(((uint32_t)(x)) << I2S_FIFOINTSTAT_RXLVL_SHIFT)) & I2S_FIFOINTSTAT_RXLVL_MASK)

#define I2S_FIFOINTSTAT_PERINT_MASK              (0x10U)
#define I2S_FIFOINTSTAT_PERINT_SHIFT             (4U)
/*! PERINT - Peripheral interrupt.
 */
#define I2S_FIFOINTSTAT_PERINT(x)                (((uint32_t)(((uint32_t)(x)) << I2S_FIFOINTSTAT_PERINT_SHIFT)) & I2S_FIFOINTSTAT_PERINT_MASK)
/*! @} */

/*! @name FIFOWR - FIFO write data. */
/*! @{ */

#define I2S_FIFOWR_TXDATA_MASK                   (0xFFFFFFFFU)
#define I2S_FIFOWR_TXDATA_SHIFT                  (0U)
/*! TXDATA - Transmit data to the FIFO. The number of bits used depends on configuration details.
 */
#define I2S_FIFOWR_TXDATA(x)                     (((uint32_t)(((uint32_t)(x)) << I2S_FIFOWR_TXDATA_SHIFT)) & I2S_FIFOWR_TXDATA_MASK)
/*! @} */

/*! @name FIFOWR48H - FIFO write data for upper data bits. May only be used if the I2S is configured for 2x 24-bit data and not using DMA. */
/*! @{ */

#define I2S_FIFOWR48H_TXDATA_MASK                (0xFFFFFFU)
#define I2S_FIFOWR48H_TXDATA_SHIFT               (0U)
/*! TXDATA - Transmit data to the FIFO. Whether this register is used and the number of bits used depends on configuration details.
 */
#define I2S_FIFOWR48H_TXDATA(x)                  (((uint32_t)(((uint32_t)(x)) << I2S_FIFOWR48H_TXDATA_SHIFT)) & I2S_FIFOWR48H_TXDATA_MASK)
/*! @} */

/*! @name FIFORD - FIFO read data. */
/*! @{ */

#define I2S_FIFORD_RXDATA_MASK                   (0xFFFFFFFFU)
#define I2S_FIFORD_RXDATA_SHIFT                  (0U)
/*! RXDATA - Received data from the FIFO. The number of bits used depends on configuration details.
 */
#define I2S_FIFORD_RXDATA(x)                     (((uint32_t)(((uint32_t)(x)) << I2S_FIFORD_RXDATA_SHIFT)) & I2S_FIFORD_RXDATA_MASK)
/*! @} */

/*! @name FIFORD48H - FIFO read data for upper data bits. May only be used if the I2S is configured for 2x 24-bit data and not using DMA. */
/*! @{ */

#define I2S_FIFORD48H_RXDATA_MASK                (0xFFFFFFU)
#define I2S_FIFORD48H_RXDATA_SHIFT               (0U)
/*! RXDATA - Received data from the FIFO. Whether this register is used and the number of bits used depends on configuration details.
 */
#define I2S_FIFORD48H_RXDATA(x)                  (((uint32_t)(((uint32_t)(x)) << I2S_FIFORD48H_RXDATA_SHIFT)) & I2S_FIFORD48H_RXDATA_MASK)
/*! @} */

/*! @name FIFORDNOPOP - FIFO data read with no FIFO pop. */
/*! @{ */

#define I2S_FIFORDNOPOP_RXDATA_MASK              (0xFFFFFFFFU)
#define I2S_FIFORDNOPOP_RXDATA_SHIFT             (0U)
/*! RXDATA - Received data from the FIFO.
 */
#define I2S_FIFORDNOPOP_RXDATA(x)                (((uint32_t)(((uint32_t)(x)) << I2S_FIFORDNOPOP_RXDATA_SHIFT)) & I2S_FIFORDNOPOP_RXDATA_MASK)
/*! @} */

/*! @name FIFORD48HNOPOP - FIFO data read for upper data bits with no FIFO pop. May only be used if the I2S is configured for 2x 24-bit data and not using DMA. */
/*! @{ */

#define I2S_FIFORD48HNOPOP_RXDATA_MASK           (0xFFFFFFU)
#define I2S_FIFORD48HNOPOP_RXDATA_SHIFT          (0U)
/*! RXDATA - Received data from the FIFO. Whether this register is used and the number of bits used depends on configuration details.
 */
#define I2S_FIFORD48HNOPOP_RXDATA(x)             (((uint32_t)(((uint32_t)(x)) << I2S_FIFORD48HNOPOP_RXDATA_SHIFT)) & I2S_FIFORD48HNOPOP_RXDATA_MASK)
/*! @} */

/*! @name FIFOSIZE - FIFO size register */
/*! @{ */

#define I2S_FIFOSIZE_FIFOSIZE_MASK               (0x1FU)
#define I2S_FIFOSIZE_FIFOSIZE_SHIFT              (0U)
/*! FIFOSIZE - the fifo size is equal to the template parameter "fifo"/2 .
 */
#define I2S_FIFOSIZE_FIFOSIZE(x)                 (((uint32_t)(((uint32_t)(x)) << I2S_FIFOSIZE_FIFOSIZE_SHIFT)) & I2S_FIFOSIZE_FIFOSIZE_MASK)
/*! @} */

/*! @name ID - I2S Module identification */
/*! @{ */

#define I2S_ID_APERTURE_MASK                     (0xFFU)
#define I2S_ID_APERTURE_SHIFT                    (0U)
/*! Aperture - Aperture: encoded as (aperture size/4K) -1, so 0x00 means a 4K aperture.
 */
#define I2S_ID_APERTURE(x)                       (((uint32_t)(((uint32_t)(x)) << I2S_ID_APERTURE_SHIFT)) & I2S_ID_APERTURE_MASK)

#define I2S_ID_MINOR_REV_MASK                    (0xF00U)
#define I2S_ID_MINOR_REV_SHIFT                   (8U)
/*! Minor_Rev - Minor revision of module implementation, starting at 0.
 */
#define I2S_ID_MINOR_REV(x)                      (((uint32_t)(((uint32_t)(x)) << I2S_ID_MINOR_REV_SHIFT)) & I2S_ID_MINOR_REV_MASK)

#define I2S_ID_MAJOR_REV_MASK                    (0xF000U)
#define I2S_ID_MAJOR_REV_SHIFT                   (12U)
/*! Major_Rev - Major revision of module implementation, starting at 0.
 */
#define I2S_ID_MAJOR_REV(x)                      (((uint32_t)(((uint32_t)(x)) << I2S_ID_MAJOR_REV_SHIFT)) & I2S_ID_MAJOR_REV_MASK)

#define I2S_ID_ID_MASK                           (0xFFFF0000U)
#define I2S_ID_ID_SHIFT                          (16U)
/*! ID - Unique module identifier for this IP block.
 */
#define I2S_ID_ID(x)                             (((uint32_t)(((uint32_t)(x)) << I2S_ID_ID_SHIFT)) & I2S_ID_ID_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group I2S_Register_Masks */


/* I2S - Peripheral instance base addresses */
/** Peripheral I2S0 base address */
#define I2S0_BASE                                (0x40106000u)
/** Peripheral I2S0 base pointer */
#define I2S0                                     ((I2S_Type *)I2S0_BASE)
/** Peripheral I2S1 base address */
#define I2S1_BASE                                (0x40107000u)
/** Peripheral I2S1 base pointer */
#define I2S1                                     ((I2S_Type *)I2S1_BASE)
/** Peripheral I2S2 base address */
#define I2S2_BASE                                (0x40108000u)
/** Peripheral I2S2 base pointer */
#define I2S2                                     ((I2S_Type *)I2S2_BASE)
/** Peripheral I2S3 base address */
#define I2S3_BASE                                (0x40109000u)
/** Peripheral I2S3 base pointer */
#define I2S3                                     ((I2S_Type *)I2S3_BASE)
/** Peripheral I2S4 base address */
#define I2S4_BASE                                (0x40122000u)
/** Peripheral I2S4 base pointer */
#define I2S4                                     ((I2S_Type *)I2S4_BASE)
/** Peripheral I2S5 base address */
#define I2S5_BASE                                (0x40123000u)
/** Peripheral I2S5 base pointer */
#define I2S5                                     ((I2S_Type *)I2S5_BASE)
/** Peripheral I2S6 base address */
#define I2S6_BASE                                (0x40124000u)
/** Peripheral I2S6 base pointer */
#define I2S6                                     ((I2S_Type *)I2S6_BASE)
/** Peripheral I2S7 base address */
#define I2S7_BASE                                (0x40125000u)
/** Peripheral I2S7 base pointer */
#define I2S7                                     ((I2S_Type *)I2S7_BASE)
/** Array initializer of I2S peripheral base addresses */
#define I2S_BASE_ADDRS                           { I2S0_BASE, I2S1_BASE, I2S2_BASE, I2S3_BASE, I2S4_BASE, I2S5_BASE, I2S6_BASE, I2S7_BASE }
/** Array initializer of I2S peripheral base pointers */
#define I2S_BASE_PTRS                            { I2S0, I2S1, I2S2, I2S3, I2S4, I2S5, I2S6, I2S7 }
/** Interrupt vectors for the I2S peripheral type */
#define I2S_IRQS                                 { FLEXCOMM0_IRQn, FLEXCOMM1_IRQn, FLEXCOMM2_IRQn, FLEXCOMM3_IRQn, FLEXCOMM4_IRQn, FLEXCOMM5_IRQn, FLEXCOMM6_IRQn, FLEXCOMM7_IRQn }

/*!
 * @}
 */ /* end of group I2S_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- I3C Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup I3C_Peripheral_Access_Layer I3C Peripheral Access Layer
 * @{
 */

/** I3C - Register Layout Typedef */
typedef struct {
  __IO uint32_t MCONFIG;                           /**< Master Configuration Register, offset: 0x0 */
  __IO uint32_t SCONFIG;                           /**< Slave Configuration Register, offset: 0x4 */
  __IO uint32_t SSTATUS;                           /**< Slave Status Register, offset: 0x8 */
  __IO uint32_t SCTRL;                             /**< Slave Control Register, offset: 0xC */
  __IO uint32_t SINTSET;                           /**< Slave Interrupt Set Register, offset: 0x10 */
  __IO uint32_t SINTCLR;                           /**< Slave Interrupt Clear Register, offset: 0x14 */
  __I  uint32_t SINTMASKED;                        /**< Slave Interrupt Mask Register, offset: 0x18 */
  __IO uint32_t SERRWARN;                          /**< Slave Errors and Warnings Register, offset: 0x1C */
  __IO uint32_t SDMACTRL;                          /**< Slave DMA Control Register, offset: 0x20 */
       uint8_t RESERVED_0[8];
  __IO uint32_t SDATACTRL;                         /**< Slave Data Control Register, offset: 0x2C */
  __O  uint32_t SWDATAB;                           /**< Slave Write Data Byte Register, offset: 0x30 */
  __O  uint32_t SWDATABE;                          /**< Slave Write Data Byte End, offset: 0x34 */
  __O  uint32_t SWDATAH;                           /**< Slave Write Data Half-word Register, offset: 0x38 */
  __O  uint32_t SWDATAHE;                          /**< Slave Write Data Half-word End Register, offset: 0x3C */
  __I  uint32_t SRDATAB;                           /**< Slave Read Data Byte Register, offset: 0x40 */
       uint8_t RESERVED_1[4];
  __I  uint32_t SRDATAH;                           /**< Slave Read Data Half-word Register, offset: 0x48 */
       uint8_t RESERVED_2[20];
  __I  uint32_t SCAPABILITIES;                     /**< Slave Capabilities Register, offset: 0x60 */
  __IO uint32_t SDYNADDR;                          /**< Slave Dynamic Address Register, offset: 0x64 */
  __IO uint32_t SMAXLIMITS;                        /**< Slave Maximum Limits Register, offset: 0x68 */
  __IO uint32_t SIDPARTNO;                         /**< Slave ID Part Number Register, offset: 0x6C */
  __IO uint32_t SIDEXT;                            /**< Slave ID Extension Register, offset: 0x70 */
  __IO uint32_t SVENDORID;                         /**< Slave Vendor ID Register, offset: 0x74 */
  __IO uint32_t STCCLOCK;                          /**< Slave Time Control Clock Register, offset: 0x78 */
  __I  uint32_t SMSGMAPADDR;                       /**< Slave Message-Mapped Address Register, offset: 0x7C */
       uint8_t RESERVED_3[4];
  __IO uint32_t MCTRL;                             /**< Master Main Control Register, offset: 0x84 */
  __IO uint32_t MSTATUS;                           /**< Master Status Register, offset: 0x88 */
  __IO uint32_t MIBIRULES;                         /**< Master In-band Interrupt Registry and Rules Register, offset: 0x8C */
  __IO uint32_t MINTSET;                           /**< Master Interrupt Set Register, offset: 0x90 */
  __O  uint32_t MINTCLR;                           /**< Master Interrupt Clear Register, offset: 0x94 */
  __I  uint32_t MINTMASKED;                        /**< Master Interrupt Mask Register, offset: 0x98 */
  __IO uint32_t MERRWARN;                          /**< Master Errors and Warnings Register, offset: 0x9C */
  __IO uint32_t MDMACTRL;                          /**< Master DMA Control Register, offset: 0xA0 */
       uint8_t RESERVED_4[8];
  __IO uint32_t MDATACTRL;                         /**< Master Data Control Register, offset: 0xAC */
  __O  uint32_t MWDATAB;                           /**< Master Write Data Byte Register, offset: 0xB0 */
  __O  uint32_t MWDATABE;                          /**< Master Write Data Byte End Register, offset: 0xB4 */
  __O  uint32_t MWDATAH;                           /**< Master Write Data Half-word Register, offset: 0xB8 */
  __O  uint32_t MWDATAHE;                          /**< Master Write Data Byte End Register, offset: 0xBC */
  __I  uint32_t MRDATAB;                           /**< Master Read Data Byte Register, offset: 0xC0 */
       uint8_t RESERVED_5[4];
  __I  uint32_t MRDATAH;                           /**< Master Read Data Half-word Register, offset: 0xC8 */
       uint8_t RESERVED_6[4];
  union {                                          /* offset: 0xD0 */
    __O  uint32_t MWMSG_SDR_CONTROL;                 /**< Master Write Message in SDR mode, offset: 0xD0 */
    __O  uint32_t MWMSG_SDR_DATA;                    /**< Master Write Message Data in SDR mode, offset: 0xD0 */
  };
  __I  uint32_t MRMSG_SDR;                         /**< Master Read Message in SDR mode, offset: 0xD4 */
  union {                                          /* offset: 0xD8 */
    __O  uint32_t MWMSG_DDR_CONTROL;                 /**< Master Write Message in DDR mode, offset: 0xD8 */
    __O  uint32_t MWMSG_DDR_DATA;                    /**< Master Write Message Data in DDR mode, offset: 0xD8 */
  };
  __IO uint32_t MRMSG_DDR;                         /**< Master Read Message in DDR mode, offset: 0xDC */
       uint8_t RESERVED_7[4];
  __IO uint32_t MDYNADDR;                          /**< Master Dynamic Address Register, offset: 0xE4 */
       uint8_t RESERVED_8[3860];
  __I  uint32_t SID;                               /**< Slave Module ID Register, offset: 0xFFC */
} I3C_Type;

/* ----------------------------------------------------------------------------
   -- I3C Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup I3C_Register_Masks I3C Register Masks
 * @{
 */

/*! @name MCONFIG - Master Configuration Register */
/*! @{ */

#define I3C_MCONFIG_MSTENA_MASK                  (0x3U)
#define I3C_MCONFIG_MSTENA_SHIFT                 (0U)
/*! MSTENA - Master enable
 *  0b00..MASTER_OFF: Master is off (is not enabled). If MASTER_OFF is enabled, then the I3C module can only use slave mode.
 *  0b01..MASTER_ON: Master is on (is enabled). When used from start-up, this I3C module is master by default (the
 *        main master). The module will control the bus unless the master is handed off. If the master is handed
 *        off, then MSTENA must move to 2 after that happens. The handoff means emitting GETACCMST and if accepted,
 *        the module will emit a STOP and set the MSTENA bit to 2 (or 0).
 *  0b10..MASTER_CAPABLE: The I3C module is master-capable; however the module is operating as a slave now. When
 *        used from the start, the I3C module will start as a slave, but will be prepared to switch to master mode.
 *        To switch to master mode, the slave emits an Master Request (MR), or gets a GETACCMST CCC command and
 *        accepts it (to switch on the STOP).
 *  0b11..RESERVED
 */
#define I3C_MCONFIG_MSTENA(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_MCONFIG_MSTENA_SHIFT)) & I3C_MCONFIG_MSTENA_MASK)

#define I3C_MCONFIG_DISTO_MASK                   (0x8U)
#define I3C_MCONFIG_DISTO_SHIFT                  (3U)
/*! DISTO - Disable Timeout
 */
#define I3C_MCONFIG_DISTO(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_MCONFIG_DISTO_SHIFT)) & I3C_MCONFIG_DISTO_MASK)

#define I3C_MCONFIG_HKEEP_MASK                   (0x30U)
#define I3C_MCONFIG_HKEEP_SHIFT                  (4U)
/*! HKEEP - High-Keeper
 *  0b00..NONE: Use PUR (Pull-Up Resistor). Hold SCL High.
 *  0b01..WIRED_IN: Wired-in High Keeper controls; use pin_HK (High Keeper) controls.
 *  0b10..PASSIVE_SDA: Passive on SDA; can Hi-Z (high impedance) for Bus Free (IDLE) and hold.
 *  0b11..PASSIVE_ON_SDA_SCL: Passive on SDA and SCL; can Hi-Z (high impedance) both for Bus Free (IDLE), and can Hi-Z SDA for hold.
 */
#define I3C_MCONFIG_HKEEP(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_MCONFIG_HKEEP_SHIFT)) & I3C_MCONFIG_HKEEP_MASK)

#define I3C_MCONFIG_ODSTOP_MASK                  (0x40U)
#define I3C_MCONFIG_ODSTOP_SHIFT                 (6U)
/*! ODSTOP - Open drain stop
 */
#define I3C_MCONFIG_ODSTOP(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_MCONFIG_ODSTOP_SHIFT)) & I3C_MCONFIG_ODSTOP_MASK)

#define I3C_MCONFIG_PPBAUD_MASK                  (0xF00U)
#define I3C_MCONFIG_PPBAUD_SHIFT                 (8U)
/*! PPBAUD - Push-pull baud rate
 */
#define I3C_MCONFIG_PPBAUD(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_MCONFIG_PPBAUD_SHIFT)) & I3C_MCONFIG_PPBAUD_MASK)

#define I3C_MCONFIG_PPLOW_MASK                   (0xF000U)
#define I3C_MCONFIG_PPLOW_SHIFT                  (12U)
/*! PPLOW - Push-Pull low
 */
#define I3C_MCONFIG_PPLOW(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_MCONFIG_PPLOW_SHIFT)) & I3C_MCONFIG_PPLOW_MASK)

#define I3C_MCONFIG_ODBAUD_MASK                  (0xFF0000U)
#define I3C_MCONFIG_ODBAUD_SHIFT                 (16U)
/*! ODBAUD - Open drain baud rate
 */
#define I3C_MCONFIG_ODBAUD(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_MCONFIG_ODBAUD_SHIFT)) & I3C_MCONFIG_ODBAUD_MASK)

#define I3C_MCONFIG_ODHPP_MASK                   (0x1000000U)
#define I3C_MCONFIG_ODHPP_SHIFT                  (24U)
/*! ODHPP - Open drain high push-pull
 */
#define I3C_MCONFIG_ODHPP(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_MCONFIG_ODHPP_SHIFT)) & I3C_MCONFIG_ODHPP_MASK)

#define I3C_MCONFIG_SKEW_MASK                    (0xE000000U)
#define I3C_MCONFIG_SKEW_SHIFT                   (25U)
/*! SKEW - Skew
 */
#define I3C_MCONFIG_SKEW(x)                      (((uint32_t)(((uint32_t)(x)) << I3C_MCONFIG_SKEW_SHIFT)) & I3C_MCONFIG_SKEW_MASK)

#define I3C_MCONFIG_I2CBAUD_MASK                 (0xF0000000U)
#define I3C_MCONFIG_I2CBAUD_SHIFT                (28U)
/*! I2CBAUD - I2C baud rate
 */
#define I3C_MCONFIG_I2CBAUD(x)                   (((uint32_t)(((uint32_t)(x)) << I3C_MCONFIG_I2CBAUD_SHIFT)) & I3C_MCONFIG_I2CBAUD_MASK)
/*! @} */

/*! @name SCONFIG - Slave Configuration Register */
/*! @{ */

#define I3C_SCONFIG_SLVENA_MASK                  (0x1U)
#define I3C_SCONFIG_SLVENA_SHIFT                 (0U)
/*! SLVENA - Slave enable
 */
#define I3C_SCONFIG_SLVENA(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_SCONFIG_SLVENA_SHIFT)) & I3C_SCONFIG_SLVENA_MASK)

#define I3C_SCONFIG_NACK_MASK                    (0x2U)
#define I3C_SCONFIG_NACK_SHIFT                   (1U)
/*! NACK - Not acknowledge
 */
#define I3C_SCONFIG_NACK(x)                      (((uint32_t)(((uint32_t)(x)) << I3C_SCONFIG_NACK_SHIFT)) & I3C_SCONFIG_NACK_MASK)

#define I3C_SCONFIG_MATCHSS_MASK                 (0x4U)
#define I3C_SCONFIG_MATCHSS_SHIFT                (2U)
/*! MATCHSS - Match START or STOP
 */
#define I3C_SCONFIG_MATCHSS(x)                   (((uint32_t)(((uint32_t)(x)) << I3C_SCONFIG_MATCHSS_SHIFT)) & I3C_SCONFIG_MATCHSS_MASK)

#define I3C_SCONFIG_S0IGNORE_MASK                (0x8U)
#define I3C_SCONFIG_S0IGNORE_SHIFT               (3U)
/*! S0IGNORE - S0/S1 errors ignore
 */
#define I3C_SCONFIG_S0IGNORE(x)                  (((uint32_t)(((uint32_t)(x)) << I3C_SCONFIG_S0IGNORE_SHIFT)) & I3C_SCONFIG_S0IGNORE_MASK)

#define I3C_SCONFIG_DDROK_MASK                   (0x10U)
#define I3C_SCONFIG_DDROK_SHIFT                  (4U)
/*! DDROK - Double Data Rate OK
 */
#define I3C_SCONFIG_DDROK(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SCONFIG_DDROK_SHIFT)) & I3C_SCONFIG_DDROK_MASK)

#define I3C_SCONFIG_IDRAND_MASK                  (0x100U)
#define I3C_SCONFIG_IDRAND_SHIFT                 (8U)
/*! IDRAND - ID random
 */
#define I3C_SCONFIG_IDRAND(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_SCONFIG_IDRAND_SHIFT)) & I3C_SCONFIG_IDRAND_MASK)

#define I3C_SCONFIG_OFFLINE_MASK                 (0x200U)
#define I3C_SCONFIG_OFFLINE_SHIFT                (9U)
/*! OFFLINE - Offline
 */
#define I3C_SCONFIG_OFFLINE(x)                   (((uint32_t)(((uint32_t)(x)) << I3C_SCONFIG_OFFLINE_SHIFT)) & I3C_SCONFIG_OFFLINE_MASK)

#define I3C_SCONFIG_BAMATCH_MASK                 (0xFF0000U)
#define I3C_SCONFIG_BAMATCH_SHIFT                (16U)
/*! BAMATCH - Bus available match
 */
#define I3C_SCONFIG_BAMATCH(x)                   (((uint32_t)(((uint32_t)(x)) << I3C_SCONFIG_BAMATCH_SHIFT)) & I3C_SCONFIG_BAMATCH_MASK)

#define I3C_SCONFIG_SADDR_MASK                   (0xFE000000U)
#define I3C_SCONFIG_SADDR_SHIFT                  (25U)
/*! SADDR - Static address
 */
#define I3C_SCONFIG_SADDR(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SCONFIG_SADDR_SHIFT)) & I3C_SCONFIG_SADDR_MASK)
/*! @} */

/*! @name SSTATUS - Slave Status Register */
/*! @{ */

#define I3C_SSTATUS_STNOTSTOP_MASK               (0x1U)
#define I3C_SSTATUS_STNOTSTOP_SHIFT              (0U)
/*! STNOTSTOP - Status not stop
 */
#define I3C_SSTATUS_STNOTSTOP(x)                 (((uint32_t)(((uint32_t)(x)) << I3C_SSTATUS_STNOTSTOP_SHIFT)) & I3C_SSTATUS_STNOTSTOP_MASK)

#define I3C_SSTATUS_STMSG_MASK                   (0x2U)
#define I3C_SSTATUS_STMSG_SHIFT                  (1U)
/*! STMSG - Status message
 */
#define I3C_SSTATUS_STMSG(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SSTATUS_STMSG_SHIFT)) & I3C_SSTATUS_STMSG_MASK)

#define I3C_SSTATUS_STCCCH_MASK                  (0x4U)
#define I3C_SSTATUS_STCCCH_SHIFT                 (2U)
/*! STCCCH - Status Common Command Code Handler
 */
#define I3C_SSTATUS_STCCCH(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_SSTATUS_STCCCH_SHIFT)) & I3C_SSTATUS_STCCCH_MASK)

#define I3C_SSTATUS_STREQRD_MASK                 (0x8U)
#define I3C_SSTATUS_STREQRD_SHIFT                (3U)
/*! STREQRD - Status required
 */
#define I3C_SSTATUS_STREQRD(x)                   (((uint32_t)(((uint32_t)(x)) << I3C_SSTATUS_STREQRD_SHIFT)) & I3C_SSTATUS_STREQRD_MASK)

#define I3C_SSTATUS_STREQWR_MASK                 (0x10U)
#define I3C_SSTATUS_STREQWR_SHIFT                (4U)
/*! STREQWR - Status request write
 */
#define I3C_SSTATUS_STREQWR(x)                   (((uint32_t)(((uint32_t)(x)) << I3C_SSTATUS_STREQWR_SHIFT)) & I3C_SSTATUS_STREQWR_MASK)

#define I3C_SSTATUS_STDAA_MASK                   (0x20U)
#define I3C_SSTATUS_STDAA_SHIFT                  (5U)
/*! STDAA - Status Dynamic Address Assignment
 */
#define I3C_SSTATUS_STDAA(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SSTATUS_STDAA_SHIFT)) & I3C_SSTATUS_STDAA_MASK)

#define I3C_SSTATUS_STHDR_MASK                   (0x40U)
#define I3C_SSTATUS_STHDR_SHIFT                  (6U)
/*! STHDR - Status High Data Rate
 */
#define I3C_SSTATUS_STHDR(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SSTATUS_STHDR_SHIFT)) & I3C_SSTATUS_STHDR_MASK)

#define I3C_SSTATUS_START_MASK                   (0x100U)
#define I3C_SSTATUS_START_SHIFT                  (8U)
/*! START - Start
 */
#define I3C_SSTATUS_START(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SSTATUS_START_SHIFT)) & I3C_SSTATUS_START_MASK)

#define I3C_SSTATUS_MATCHED_MASK                 (0x200U)
#define I3C_SSTATUS_MATCHED_SHIFT                (9U)
/*! MATCHED - Matched
 */
#define I3C_SSTATUS_MATCHED(x)                   (((uint32_t)(((uint32_t)(x)) << I3C_SSTATUS_MATCHED_SHIFT)) & I3C_SSTATUS_MATCHED_MASK)

#define I3C_SSTATUS_STOP_MASK                    (0x400U)
#define I3C_SSTATUS_STOP_SHIFT                   (10U)
/*! STOP - Stop
 */
#define I3C_SSTATUS_STOP(x)                      (((uint32_t)(((uint32_t)(x)) << I3C_SSTATUS_STOP_SHIFT)) & I3C_SSTATUS_STOP_MASK)

#define I3C_SSTATUS_RX_PEND_MASK                 (0x800U)
#define I3C_SSTATUS_RX_PEND_SHIFT                (11U)
/*! RX_PEND - Received message pending
 */
#define I3C_SSTATUS_RX_PEND(x)                   (((uint32_t)(((uint32_t)(x)) << I3C_SSTATUS_RX_PEND_SHIFT)) & I3C_SSTATUS_RX_PEND_MASK)

#define I3C_SSTATUS_TXNOTFULL_MASK               (0x1000U)
#define I3C_SSTATUS_TXNOTFULL_SHIFT              (12U)
/*! TXNOTFULL - Transmit buffer is not full
 */
#define I3C_SSTATUS_TXNOTFULL(x)                 (((uint32_t)(((uint32_t)(x)) << I3C_SSTATUS_TXNOTFULL_SHIFT)) & I3C_SSTATUS_TXNOTFULL_MASK)

#define I3C_SSTATUS_DACHG_MASK                   (0x2000U)
#define I3C_SSTATUS_DACHG_SHIFT                  (13U)
/*! DACHG - DACHG
 */
#define I3C_SSTATUS_DACHG(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SSTATUS_DACHG_SHIFT)) & I3C_SSTATUS_DACHG_MASK)

#define I3C_SSTATUS_CCC_MASK                     (0x4000U)
#define I3C_SSTATUS_CCC_SHIFT                    (14U)
/*! CCC - Common Command Code
 */
#define I3C_SSTATUS_CCC(x)                       (((uint32_t)(((uint32_t)(x)) << I3C_SSTATUS_CCC_SHIFT)) & I3C_SSTATUS_CCC_MASK)

#define I3C_SSTATUS_ERRWARN_MASK                 (0x8000U)
#define I3C_SSTATUS_ERRWARN_SHIFT                (15U)
/*! ERRWARN - Error warning
 */
#define I3C_SSTATUS_ERRWARN(x)                   (((uint32_t)(((uint32_t)(x)) << I3C_SSTATUS_ERRWARN_SHIFT)) & I3C_SSTATUS_ERRWARN_MASK)

#define I3C_SSTATUS_HDRMATCH_MASK                (0x10000U)
#define I3C_SSTATUS_HDRMATCH_SHIFT               (16U)
/*! HDRMATCH - High Data Rate command match
 */
#define I3C_SSTATUS_HDRMATCH(x)                  (((uint32_t)(((uint32_t)(x)) << I3C_SSTATUS_HDRMATCH_SHIFT)) & I3C_SSTATUS_HDRMATCH_MASK)

#define I3C_SSTATUS_CHANDLED_MASK                (0x20000U)
#define I3C_SSTATUS_CHANDLED_SHIFT               (17U)
/*! CHANDLED - Common-Command-Code handled
 */
#define I3C_SSTATUS_CHANDLED(x)                  (((uint32_t)(((uint32_t)(x)) << I3C_SSTATUS_CHANDLED_SHIFT)) & I3C_SSTATUS_CHANDLED_MASK)

#define I3C_SSTATUS_EVENT_MASK                   (0x40000U)
#define I3C_SSTATUS_EVENT_SHIFT                  (18U)
/*! EVENT - Event
 */
#define I3C_SSTATUS_EVENT(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SSTATUS_EVENT_SHIFT)) & I3C_SSTATUS_EVENT_MASK)

#define I3C_SSTATUS_EVDET_MASK                   (0x300000U)
#define I3C_SSTATUS_EVDET_SHIFT                  (20U)
/*! EVDET - Event details
 *  0b00..NONE: no event or no pending event
 *  0b01..NO_REQUEST: Request not sent yet. Either there was no START yet, or is waiting for Bus-Available or Bus-Idle (HJ).
 *  0b10..NACKED: Not acknowledged(Request sent and NACKed); the module will try again.
 *  0b11..ACKED: Acknowledged (Request sent and ACKed), so Done (unless the time control data is still being sent).
 */
#define I3C_SSTATUS_EVDET(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SSTATUS_EVDET_SHIFT)) & I3C_SSTATUS_EVDET_MASK)

#define I3C_SSTATUS_IBIDIS_MASK                  (0x1000000U)
#define I3C_SSTATUS_IBIDIS_SHIFT                 (24U)
/*! IBIDIS - In-Band Interrupts are disabled
 */
#define I3C_SSTATUS_IBIDIS(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_SSTATUS_IBIDIS_SHIFT)) & I3C_SSTATUS_IBIDIS_MASK)

#define I3C_SSTATUS_MRDIS_MASK                   (0x2000000U)
#define I3C_SSTATUS_MRDIS_SHIFT                  (25U)
/*! MRDIS - Master requests are disabled
 */
#define I3C_SSTATUS_MRDIS(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SSTATUS_MRDIS_SHIFT)) & I3C_SSTATUS_MRDIS_MASK)

#define I3C_SSTATUS_HJDIS_MASK                   (0x8000000U)
#define I3C_SSTATUS_HJDIS_SHIFT                  (27U)
/*! HJDIS - Hot-Join is disabled
 */
#define I3C_SSTATUS_HJDIS(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SSTATUS_HJDIS_SHIFT)) & I3C_SSTATUS_HJDIS_MASK)

#define I3C_SSTATUS_ACTSTATE_MASK                (0x30000000U)
#define I3C_SSTATUS_ACTSTATE_SHIFT               (28U)
/*! ACTSTATE - Activity state from Common Command Codes (CCC)
 *  0b00..NO_LATENCY: normal bus operations
 *  0b01..LATENCY_1MS: 1 ms of latency
 *  0b10..LATENCY_100MS: 100 ms of latency
 *  0b11..LATENCY_10S: 10 seconds of latency
 */
#define I3C_SSTATUS_ACTSTATE(x)                  (((uint32_t)(((uint32_t)(x)) << I3C_SSTATUS_ACTSTATE_SHIFT)) & I3C_SSTATUS_ACTSTATE_MASK)

#define I3C_SSTATUS_TIMECTRL_MASK                (0xC0000000U)
#define I3C_SSTATUS_TIMECTRL_SHIFT               (30U)
/*! TIMECTRL - Time control
 *  0b00..NO_TIME_CONTROL: No time control is enabled
 *  0b01..Reserved
 *  0b10..ASYNC_MODE: Asynchronous standard mode (0) is enabled
 *  0b11..RESERVED
 */
#define I3C_SSTATUS_TIMECTRL(x)                  (((uint32_t)(((uint32_t)(x)) << I3C_SSTATUS_TIMECTRL_SHIFT)) & I3C_SSTATUS_TIMECTRL_MASK)
/*! @} */

/*! @name SCTRL - Slave Control Register */
/*! @{ */

#define I3C_SCTRL_EVENT_MASK                     (0x3U)
#define I3C_SCTRL_EVENT_SHIFT                    (0U)
/*! EVENT - EVENT
 *  0b00..NORMAL_MODE: If EVENT is set to 0 after was a non-0 value, event processing will cancel if the event
 *        processing has not yet started; if event processing has already been started, then event processing will not
 *        be be cancelled.
 *  0b01..IBI: Start an In-Band Interrupt. This will try to push an IBI interrupt onto the I3C bus. If data is
 *        associated with the IBI, then the data will be read from the SCTRL.IBIDATA field. If time control is
 *        enabled, then this data will also include any time control-related bytes; additionally, the IBIDATA byte will
 *        have bit 7 set to 1 automatically (as is required for time control). The IBI interrupt will occur after the
 *        1st (mandatory) IBIDATA, if any.
 *  0b10..MASTER_REQUEST: Start a Master-Request.
 *  0b11..HOT_JOIN_REQUEST: Start a Hot-Join request. A Hot-Join Request should only be used when the device is
 *        powered on after the I3C bus is already powered up, or when the device is connected using hot insertion
 *        methods (the device is powered up when it is physically inserted onto the powered-up I3C bus). The hot join
 *        will wait for Bus Idle, and SCTRL.EVENT=HOT_JOIN_REQUEST must be set before the slave enable
 *        (SCONFIG.SLVENA).
 */
#define I3C_SCTRL_EVENT(x)                       (((uint32_t)(((uint32_t)(x)) << I3C_SCTRL_EVENT_SHIFT)) & I3C_SCTRL_EVENT_MASK)

#define I3C_SCTRL_IBIDATA_MASK                   (0xFF00U)
#define I3C_SCTRL_IBIDATA_SHIFT                  (8U)
/*! IBIDATA - In-Band Interrupt data
 */
#define I3C_SCTRL_IBIDATA(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SCTRL_IBIDATA_SHIFT)) & I3C_SCTRL_IBIDATA_MASK)

#define I3C_SCTRL_PENDINT_MASK                   (0xF0000U)
#define I3C_SCTRL_PENDINT_SHIFT                  (16U)
/*! PENDINT - Pending interrupt
 */
#define I3C_SCTRL_PENDINT(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SCTRL_PENDINT_SHIFT)) & I3C_SCTRL_PENDINT_MASK)

#define I3C_SCTRL_ACTSTATE_MASK                  (0x300000U)
#define I3C_SCTRL_ACTSTATE_SHIFT                 (20U)
/*! ACTSTATE - Activity state (of slave)
 */
#define I3C_SCTRL_ACTSTATE(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_SCTRL_ACTSTATE_SHIFT)) & I3C_SCTRL_ACTSTATE_MASK)

#define I3C_SCTRL_VENDINFO_MASK                  (0xFF000000U)
#define I3C_SCTRL_VENDINFO_SHIFT                 (24U)
/*! VENDINFO - Vendor information
 */
#define I3C_SCTRL_VENDINFO(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_SCTRL_VENDINFO_SHIFT)) & I3C_SCTRL_VENDINFO_MASK)
/*! @} */

/*! @name SINTSET - Slave Interrupt Set Register */
/*! @{ */

#define I3C_SINTSET_START_MASK                   (0x100U)
#define I3C_SINTSET_START_SHIFT                  (8U)
/*! START - Start interrupt enable
 */
#define I3C_SINTSET_START(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SINTSET_START_SHIFT)) & I3C_SINTSET_START_MASK)

#define I3C_SINTSET_MATCHED_MASK                 (0x200U)
#define I3C_SINTSET_MATCHED_SHIFT                (9U)
/*! MATCHED - Match interrupt enable
 */
#define I3C_SINTSET_MATCHED(x)                   (((uint32_t)(((uint32_t)(x)) << I3C_SINTSET_MATCHED_SHIFT)) & I3C_SINTSET_MATCHED_MASK)

#define I3C_SINTSET_STOP_MASK                    (0x400U)
#define I3C_SINTSET_STOP_SHIFT                   (10U)
/*! STOP - Stop interrupt enable
 */
#define I3C_SINTSET_STOP(x)                      (((uint32_t)(((uint32_t)(x)) << I3C_SINTSET_STOP_SHIFT)) & I3C_SINTSET_STOP_MASK)

#define I3C_SINTSET_RXPEND_MASK                  (0x800U)
#define I3C_SINTSET_RXPEND_SHIFT                 (11U)
/*! RXPEND - Receive interrupt enable
 */
#define I3C_SINTSET_RXPEND(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_SINTSET_RXPEND_SHIFT)) & I3C_SINTSET_RXPEND_MASK)

#define I3C_SINTSET_TXSEND_MASK                  (0x1000U)
#define I3C_SINTSET_TXSEND_SHIFT                 (12U)
/*! TXSEND - Transmit interrupt enable
 */
#define I3C_SINTSET_TXSEND(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_SINTSET_TXSEND_SHIFT)) & I3C_SINTSET_TXSEND_MASK)

#define I3C_SINTSET_DACHG_MASK                   (0x2000U)
#define I3C_SINTSET_DACHG_SHIFT                  (13U)
/*! DACHG - Dynamic address change interrupt enable
 */
#define I3C_SINTSET_DACHG(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SINTSET_DACHG_SHIFT)) & I3C_SINTSET_DACHG_MASK)

#define I3C_SINTSET_CCC_MASK                     (0x4000U)
#define I3C_SINTSET_CCC_SHIFT                    (14U)
/*! CCC - Common Command Code (CCC) (that was not handled by I3C module) interrupt enable
 */
#define I3C_SINTSET_CCC(x)                       (((uint32_t)(((uint32_t)(x)) << I3C_SINTSET_CCC_SHIFT)) & I3C_SINTSET_CCC_MASK)

#define I3C_SINTSET_ERRWARN_MASK                 (0x8000U)
#define I3C_SINTSET_ERRWARN_SHIFT                (15U)
/*! ERRWARN - Error/warning interrupt enable
 */
#define I3C_SINTSET_ERRWARN(x)                   (((uint32_t)(((uint32_t)(x)) << I3C_SINTSET_ERRWARN_SHIFT)) & I3C_SINTSET_ERRWARN_MASK)

#define I3C_SINTSET_DDRMATCHED_MASK              (0x10000U)
#define I3C_SINTSET_DDRMATCHED_SHIFT             (16U)
/*! DDRMATCHED - Double Data Rate (DDR) interrupt enable
 */
#define I3C_SINTSET_DDRMATCHED(x)                (((uint32_t)(((uint32_t)(x)) << I3C_SINTSET_DDRMATCHED_SHIFT)) & I3C_SINTSET_DDRMATCHED_MASK)

#define I3C_SINTSET_CHANDLED_MASK                (0x20000U)
#define I3C_SINTSET_CHANDLED_SHIFT               (17U)
/*! CHANDLED - Common Command Code (CCC) (that was handled by I3C module) interrupt enable
 */
#define I3C_SINTSET_CHANDLED(x)                  (((uint32_t)(((uint32_t)(x)) << I3C_SINTSET_CHANDLED_SHIFT)) & I3C_SINTSET_CHANDLED_MASK)

#define I3C_SINTSET_EVENT_MASK                   (0x40000U)
#define I3C_SINTSET_EVENT_SHIFT                  (18U)
/*! EVENT - Event interrupt enable
 */
#define I3C_SINTSET_EVENT(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SINTSET_EVENT_SHIFT)) & I3C_SINTSET_EVENT_MASK)
/*! @} */

/*! @name SINTCLR - Slave Interrupt Clear Register */
/*! @{ */

#define I3C_SINTCLR_START_MASK                   (0x100U)
#define I3C_SINTCLR_START_SHIFT                  (8U)
/*! START - START interrupt enable clear
 */
#define I3C_SINTCLR_START(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SINTCLR_START_SHIFT)) & I3C_SINTCLR_START_MASK)

#define I3C_SINTCLR_MATCHED_MASK                 (0x200U)
#define I3C_SINTCLR_MATCHED_SHIFT                (9U)
/*! MATCHED - MATCHED interrupt enable clear
 */
#define I3C_SINTCLR_MATCHED(x)                   (((uint32_t)(((uint32_t)(x)) << I3C_SINTCLR_MATCHED_SHIFT)) & I3C_SINTCLR_MATCHED_MASK)

#define I3C_SINTCLR_STOP_MASK                    (0x400U)
#define I3C_SINTCLR_STOP_SHIFT                   (10U)
/*! STOP - STOP interrupt enable clear
 */
#define I3C_SINTCLR_STOP(x)                      (((uint32_t)(((uint32_t)(x)) << I3C_SINTCLR_STOP_SHIFT)) & I3C_SINTCLR_STOP_MASK)

#define I3C_SINTCLR_RXPEND_MASK                  (0x800U)
#define I3C_SINTCLR_RXPEND_SHIFT                 (11U)
/*! RXPEND - RXPEND interrupt enable clear
 */
#define I3C_SINTCLR_RXPEND(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_SINTCLR_RXPEND_SHIFT)) & I3C_SINTCLR_RXPEND_MASK)

#define I3C_SINTCLR_TXSEND_MASK                  (0x1000U)
#define I3C_SINTCLR_TXSEND_SHIFT                 (12U)
/*! TXSEND - TXSEND interrupt enable clear
 */
#define I3C_SINTCLR_TXSEND(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_SINTCLR_TXSEND_SHIFT)) & I3C_SINTCLR_TXSEND_MASK)

#define I3C_SINTCLR_DACHG_MASK                   (0x2000U)
#define I3C_SINTCLR_DACHG_SHIFT                  (13U)
/*! DACHG - DACHG interrupt enable clear
 */
#define I3C_SINTCLR_DACHG(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SINTCLR_DACHG_SHIFT)) & I3C_SINTCLR_DACHG_MASK)

#define I3C_SINTCLR_CCC_MASK                     (0x4000U)
#define I3C_SINTCLR_CCC_SHIFT                    (14U)
/*! CCC - CCC interrupt enable clear
 */
#define I3C_SINTCLR_CCC(x)                       (((uint32_t)(((uint32_t)(x)) << I3C_SINTCLR_CCC_SHIFT)) & I3C_SINTCLR_CCC_MASK)

#define I3C_SINTCLR_ERRWARN_MASK                 (0x8000U)
#define I3C_SINTCLR_ERRWARN_SHIFT                (15U)
/*! ERRWARN - ERRWARN interrupt enable clear
 */
#define I3C_SINTCLR_ERRWARN(x)                   (((uint32_t)(((uint32_t)(x)) << I3C_SINTCLR_ERRWARN_SHIFT)) & I3C_SINTCLR_ERRWARN_MASK)

#define I3C_SINTCLR_DDRMATCHED_MASK              (0x10000U)
#define I3C_SINTCLR_DDRMATCHED_SHIFT             (16U)
/*! DDRMATCHED - DDRMATCHED interrupt enable clear
 */
#define I3C_SINTCLR_DDRMATCHED(x)                (((uint32_t)(((uint32_t)(x)) << I3C_SINTCLR_DDRMATCHED_SHIFT)) & I3C_SINTCLR_DDRMATCHED_MASK)

#define I3C_SINTCLR_CHANDLED_MASK                (0x20000U)
#define I3C_SINTCLR_CHANDLED_SHIFT               (17U)
/*! CHANDLED - CHANDLED interrupt enable clear
 */
#define I3C_SINTCLR_CHANDLED(x)                  (((uint32_t)(((uint32_t)(x)) << I3C_SINTCLR_CHANDLED_SHIFT)) & I3C_SINTCLR_CHANDLED_MASK)

#define I3C_SINTCLR_EVENT_MASK                   (0x40000U)
#define I3C_SINTCLR_EVENT_SHIFT                  (18U)
/*! EVENT - EVENT interrupt enable clear
 */
#define I3C_SINTCLR_EVENT(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SINTCLR_EVENT_SHIFT)) & I3C_SINTCLR_EVENT_MASK)
/*! @} */

/*! @name SINTMASKED - Slave Interrupt Mask Register */
/*! @{ */

#define I3C_SINTMASKED_START_MASK                (0x100U)
#define I3C_SINTMASKED_START_SHIFT               (8U)
/*! START - START interrupt mask
 */
#define I3C_SINTMASKED_START(x)                  (((uint32_t)(((uint32_t)(x)) << I3C_SINTMASKED_START_SHIFT)) & I3C_SINTMASKED_START_MASK)

#define I3C_SINTMASKED_MATCHED_MASK              (0x200U)
#define I3C_SINTMASKED_MATCHED_SHIFT             (9U)
/*! MATCHED - MATCHED interrupt mask
 */
#define I3C_SINTMASKED_MATCHED(x)                (((uint32_t)(((uint32_t)(x)) << I3C_SINTMASKED_MATCHED_SHIFT)) & I3C_SINTMASKED_MATCHED_MASK)

#define I3C_SINTMASKED_STOP_MASK                 (0x400U)
#define I3C_SINTMASKED_STOP_SHIFT                (10U)
/*! STOP - STOP interrupt mask
 */
#define I3C_SINTMASKED_STOP(x)                   (((uint32_t)(((uint32_t)(x)) << I3C_SINTMASKED_STOP_SHIFT)) & I3C_SINTMASKED_STOP_MASK)

#define I3C_SINTMASKED_RXPEND_MASK               (0x800U)
#define I3C_SINTMASKED_RXPEND_SHIFT              (11U)
/*! RXPEND - RXPEND interrupt mask
 */
#define I3C_SINTMASKED_RXPEND(x)                 (((uint32_t)(((uint32_t)(x)) << I3C_SINTMASKED_RXPEND_SHIFT)) & I3C_SINTMASKED_RXPEND_MASK)

#define I3C_SINTMASKED_TXSEND_MASK               (0x1000U)
#define I3C_SINTMASKED_TXSEND_SHIFT              (12U)
/*! TXSEND - TXSEND interrupt mask
 */
#define I3C_SINTMASKED_TXSEND(x)                 (((uint32_t)(((uint32_t)(x)) << I3C_SINTMASKED_TXSEND_SHIFT)) & I3C_SINTMASKED_TXSEND_MASK)

#define I3C_SINTMASKED_DACHG_MASK                (0x2000U)
#define I3C_SINTMASKED_DACHG_SHIFT               (13U)
/*! DACHG - DACHG interrupt mask
 */
#define I3C_SINTMASKED_DACHG(x)                  (((uint32_t)(((uint32_t)(x)) << I3C_SINTMASKED_DACHG_SHIFT)) & I3C_SINTMASKED_DACHG_MASK)

#define I3C_SINTMASKED_CCC_MASK                  (0x4000U)
#define I3C_SINTMASKED_CCC_SHIFT                 (14U)
/*! CCC - CCC interrupt mask
 */
#define I3C_SINTMASKED_CCC(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_SINTMASKED_CCC_SHIFT)) & I3C_SINTMASKED_CCC_MASK)

#define I3C_SINTMASKED_ERRWARN_MASK              (0x8000U)
#define I3C_SINTMASKED_ERRWARN_SHIFT             (15U)
/*! ERRWARN - ERRWARN interrupt mask
 */
#define I3C_SINTMASKED_ERRWARN(x)                (((uint32_t)(((uint32_t)(x)) << I3C_SINTMASKED_ERRWARN_SHIFT)) & I3C_SINTMASKED_ERRWARN_MASK)

#define I3C_SINTMASKED_DDRMATCHED_MASK           (0x10000U)
#define I3C_SINTMASKED_DDRMATCHED_SHIFT          (16U)
/*! DDRMATCHED - DDRMATCHED interrupt mask
 */
#define I3C_SINTMASKED_DDRMATCHED(x)             (((uint32_t)(((uint32_t)(x)) << I3C_SINTMASKED_DDRMATCHED_SHIFT)) & I3C_SINTMASKED_DDRMATCHED_MASK)

#define I3C_SINTMASKED_CHANDLED_MASK             (0x20000U)
#define I3C_SINTMASKED_CHANDLED_SHIFT            (17U)
/*! CHANDLED - CHANDLED interrupt mask
 */
#define I3C_SINTMASKED_CHANDLED(x)               (((uint32_t)(((uint32_t)(x)) << I3C_SINTMASKED_CHANDLED_SHIFT)) & I3C_SINTMASKED_CHANDLED_MASK)

#define I3C_SINTMASKED_EVENT_MASK                (0x40000U)
#define I3C_SINTMASKED_EVENT_SHIFT               (18U)
/*! EVENT - EVENT interrupt mask
 */
#define I3C_SINTMASKED_EVENT(x)                  (((uint32_t)(((uint32_t)(x)) << I3C_SINTMASKED_EVENT_SHIFT)) & I3C_SINTMASKED_EVENT_MASK)
/*! @} */

/*! @name SERRWARN - Slave Errors and Warnings Register */
/*! @{ */

#define I3C_SERRWARN_ORUN_MASK                   (0x1U)
#define I3C_SERRWARN_ORUN_SHIFT                  (0U)
/*! ORUN - Overrun error
 */
#define I3C_SERRWARN_ORUN(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SERRWARN_ORUN_SHIFT)) & I3C_SERRWARN_ORUN_MASK)

#define I3C_SERRWARN_URUN_MASK                   (0x2U)
#define I3C_SERRWARN_URUN_SHIFT                  (1U)
/*! URUN - Underrun error
 */
#define I3C_SERRWARN_URUN(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SERRWARN_URUN_SHIFT)) & I3C_SERRWARN_URUN_MASK)

#define I3C_SERRWARN_URUNNACK_MASK               (0x4U)
#define I3C_SERRWARN_URUNNACK_SHIFT              (2U)
/*! URUNNACK - Underrun and Not Acknowledged (NACKed) error
 */
#define I3C_SERRWARN_URUNNACK(x)                 (((uint32_t)(((uint32_t)(x)) << I3C_SERRWARN_URUNNACK_SHIFT)) & I3C_SERRWARN_URUNNACK_MASK)

#define I3C_SERRWARN_TERM_MASK                   (0x8U)
#define I3C_SERRWARN_TERM_SHIFT                  (3U)
/*! TERM - Terminated error
 */
#define I3C_SERRWARN_TERM(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SERRWARN_TERM_SHIFT)) & I3C_SERRWARN_TERM_MASK)

#define I3C_SERRWARN_INVSTART_MASK               (0x10U)
#define I3C_SERRWARN_INVSTART_SHIFT              (4U)
/*! INVSTART - Invalid start error
 */
#define I3C_SERRWARN_INVSTART(x)                 (((uint32_t)(((uint32_t)(x)) << I3C_SERRWARN_INVSTART_SHIFT)) & I3C_SERRWARN_INVSTART_MASK)

#define I3C_SERRWARN_SPAR_MASK                   (0x100U)
#define I3C_SERRWARN_SPAR_SHIFT                  (8U)
/*! SPAR - SDR parity error
 */
#define I3C_SERRWARN_SPAR(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SERRWARN_SPAR_SHIFT)) & I3C_SERRWARN_SPAR_MASK)

#define I3C_SERRWARN_HPAR_MASK                   (0x200U)
#define I3C_SERRWARN_HPAR_SHIFT                  (9U)
/*! HPAR - HDR parity error
 */
#define I3C_SERRWARN_HPAR(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SERRWARN_HPAR_SHIFT)) & I3C_SERRWARN_HPAR_MASK)

#define I3C_SERRWARN_HCRC_MASK                   (0x400U)
#define I3C_SERRWARN_HCRC_SHIFT                  (10U)
/*! HCRC - HDR-DDR CRC error
 */
#define I3C_SERRWARN_HCRC(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SERRWARN_HCRC_SHIFT)) & I3C_SERRWARN_HCRC_MASK)

#define I3C_SERRWARN_S0S1_MASK                   (0x800U)
#define I3C_SERRWARN_S0S1_SHIFT                  (11U)
/*! S0S1 - S0 or S1 error
 */
#define I3C_SERRWARN_S0S1(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SERRWARN_S0S1_SHIFT)) & I3C_SERRWARN_S0S1_MASK)

#define I3C_SERRWARN_OREAD_MASK                  (0x10000U)
#define I3C_SERRWARN_OREAD_SHIFT                 (16U)
/*! OREAD - Over-read error
 */
#define I3C_SERRWARN_OREAD(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_SERRWARN_OREAD_SHIFT)) & I3C_SERRWARN_OREAD_MASK)

#define I3C_SERRWARN_OWRITE_MASK                 (0x20000U)
#define I3C_SERRWARN_OWRITE_SHIFT                (17U)
/*! OWRITE - Over-write error
 */
#define I3C_SERRWARN_OWRITE(x)                   (((uint32_t)(((uint32_t)(x)) << I3C_SERRWARN_OWRITE_SHIFT)) & I3C_SERRWARN_OWRITE_MASK)
/*! @} */

/*! @name SDMACTRL - Slave DMA Control Register */
/*! @{ */

#define I3C_SDMACTRL_DMAFB_MASK                  (0x3U)
#define I3C_SDMACTRL_DMAFB_SHIFT                 (0U)
/*! DMAFB - DMA Read (From-bus) trigger
 *  0b00..DMA not used
 *  0b01..DMA is enabled for 1 frame
 *  0b10..DMA enable
 */
#define I3C_SDMACTRL_DMAFB(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_SDMACTRL_DMAFB_SHIFT)) & I3C_SDMACTRL_DMAFB_MASK)

#define I3C_SDMACTRL_DMATB_MASK                  (0xCU)
#define I3C_SDMACTRL_DMATB_SHIFT                 (2U)
/*! DMATB - DMA Write (To-bus) trigger
 *  0b00..NOT_USED: DMA is not used
 *  0b01..ENABLE_ONE_FRAME: DMA is enabled for 1 Frame (ended by DMA or terminated). DMATB auto-clears on a STOP
 *        or START (see the Match START or STOP bit (SCONFIG.MATCHSS).
 *  0b10..ENABLE: DMA is enabled until turned off. Normally, ENABLE should only be used with Master Message mode.
 */
#define I3C_SDMACTRL_DMATB(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_SDMACTRL_DMATB_SHIFT)) & I3C_SDMACTRL_DMATB_MASK)

#define I3C_SDMACTRL_DMAWIDTH_MASK               (0x30U)
#define I3C_SDMACTRL_DMAWIDTH_SHIFT              (4U)
/*! DMAWIDTH - Width of DMA operations
 *  0b00..BYTE
 *  0b01..BYTE_AGAIN
 *  0b10..HALF_WORD: Half word (16 bits). This will make sure that 2 bytes are free/available in the FIFO.
 *  0b11..RESERVED
 */
#define I3C_SDMACTRL_DMAWIDTH(x)                 (((uint32_t)(((uint32_t)(x)) << I3C_SDMACTRL_DMAWIDTH_SHIFT)) & I3C_SDMACTRL_DMAWIDTH_MASK)
/*! @} */

/*! @name SDATACTRL - Slave Data Control Register */
/*! @{ */

#define I3C_SDATACTRL_FLUSHTB_MASK               (0x1U)
#define I3C_SDATACTRL_FLUSHTB_SHIFT              (0U)
/*! FLUSHTB - Flush the to-bus buffer/FIFO
 */
#define I3C_SDATACTRL_FLUSHTB(x)                 (((uint32_t)(((uint32_t)(x)) << I3C_SDATACTRL_FLUSHTB_SHIFT)) & I3C_SDATACTRL_FLUSHTB_MASK)

#define I3C_SDATACTRL_FLUSHFB_MASK               (0x2U)
#define I3C_SDATACTRL_FLUSHFB_SHIFT              (1U)
/*! FLUSHFB - Flushes the from-bus buffer/FIFO
 */
#define I3C_SDATACTRL_FLUSHFB(x)                 (((uint32_t)(((uint32_t)(x)) << I3C_SDATACTRL_FLUSHFB_SHIFT)) & I3C_SDATACTRL_FLUSHFB_MASK)

#define I3C_SDATACTRL_UNLOCK_MASK                (0x8U)
#define I3C_SDATACTRL_UNLOCK_SHIFT               (3U)
/*! UNLOCK - Unlock
 */
#define I3C_SDATACTRL_UNLOCK(x)                  (((uint32_t)(((uint32_t)(x)) << I3C_SDATACTRL_UNLOCK_SHIFT)) & I3C_SDATACTRL_UNLOCK_MASK)

#define I3C_SDATACTRL_TXTRIG_MASK                (0x30U)
#define I3C_SDATACTRL_TXTRIG_SHIFT               (4U)
/*! TXTRIG - Trigger level for TX FIFO emptiness
 *  0b00..Trigger on empty
 *  0b01..Trigger on ¼ full or less
 *  0b10..Trigger on .5 full or less
 *  0b11..Trigger on 1 less than full or less (Default)
 */
#define I3C_SDATACTRL_TXTRIG(x)                  (((uint32_t)(((uint32_t)(x)) << I3C_SDATACTRL_TXTRIG_SHIFT)) & I3C_SDATACTRL_TXTRIG_MASK)

#define I3C_SDATACTRL_RXTRIG_MASK                (0xC0U)
#define I3C_SDATACTRL_RXTRIG_SHIFT               (6U)
/*! RXTRIG - Trigger level for RX FIFO fullness
 *  0b00..Trigger on not empty
 *  0b01..Trigger on ¼ or more full
 *  0b10..Trigger on .5 or more full
 *  0b11..Trigger on 3/4 or more full
 */
#define I3C_SDATACTRL_RXTRIG(x)                  (((uint32_t)(((uint32_t)(x)) << I3C_SDATACTRL_RXTRIG_SHIFT)) & I3C_SDATACTRL_RXTRIG_MASK)

#define I3C_SDATACTRL_TXCOUNT_MASK               (0x1F0000U)
#define I3C_SDATACTRL_TXCOUNT_SHIFT              (16U)
/*! TXCOUNT - Count of bytes in TX
 */
#define I3C_SDATACTRL_TXCOUNT(x)                 (((uint32_t)(((uint32_t)(x)) << I3C_SDATACTRL_TXCOUNT_SHIFT)) & I3C_SDATACTRL_TXCOUNT_MASK)

#define I3C_SDATACTRL_RXCOUNT_MASK               (0x1F000000U)
#define I3C_SDATACTRL_RXCOUNT_SHIFT              (24U)
/*! RXCOUNT - Count of bytes in RX
 */
#define I3C_SDATACTRL_RXCOUNT(x)                 (((uint32_t)(((uint32_t)(x)) << I3C_SDATACTRL_RXCOUNT_SHIFT)) & I3C_SDATACTRL_RXCOUNT_MASK)

#define I3C_SDATACTRL_TXFULL_MASK                (0x40000000U)
#define I3C_SDATACTRL_TXFULL_SHIFT               (30U)
/*! TXFULL - TX is full
 *  0b1..TX is full
 *  0b0..TX is not full
 */
#define I3C_SDATACTRL_TXFULL(x)                  (((uint32_t)(((uint32_t)(x)) << I3C_SDATACTRL_TXFULL_SHIFT)) & I3C_SDATACTRL_TXFULL_MASK)

#define I3C_SDATACTRL_RXEMPTY_MASK               (0x80000000U)
#define I3C_SDATACTRL_RXEMPTY_SHIFT              (31U)
/*! RXEMPTY - RX is empty
 *  0b1..RX is empty
 *  0b0..RX is not empty
 */
#define I3C_SDATACTRL_RXEMPTY(x)                 (((uint32_t)(((uint32_t)(x)) << I3C_SDATACTRL_RXEMPTY_SHIFT)) & I3C_SDATACTRL_RXEMPTY_MASK)
/*! @} */

/*! @name SWDATAB - Slave Write Data Byte Register */
/*! @{ */

#define I3C_SWDATAB_DATA_MASK                    (0xFFU)
#define I3C_SWDATAB_DATA_SHIFT                   (0U)
/*! DATA - The data byte to send to the master
 */
#define I3C_SWDATAB_DATA(x)                      (((uint32_t)(((uint32_t)(x)) << I3C_SWDATAB_DATA_SHIFT)) & I3C_SWDATAB_DATA_MASK)

#define I3C_SWDATAB_END_MASK                     (0x100U)
#define I3C_SWDATAB_END_SHIFT                    (8U)
/*! END - End
 */
#define I3C_SWDATAB_END(x)                       (((uint32_t)(((uint32_t)(x)) << I3C_SWDATAB_END_SHIFT)) & I3C_SWDATAB_END_MASK)

#define I3C_SWDATAB_END_ALSO_MASK                (0x10000U)
#define I3C_SWDATAB_END_ALSO_SHIFT               (16U)
/*! END_ALSO - End also
 */
#define I3C_SWDATAB_END_ALSO(x)                  (((uint32_t)(((uint32_t)(x)) << I3C_SWDATAB_END_ALSO_SHIFT)) & I3C_SWDATAB_END_ALSO_MASK)
/*! @} */

/*! @name SWDATABE - Slave Write Data Byte End */
/*! @{ */

#define I3C_SWDATABE_DATA_MASK                   (0xFFU)
#define I3C_SWDATABE_DATA_SHIFT                  (0U)
/*! DATA - The data byte to send to the master
 */
#define I3C_SWDATABE_DATA(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SWDATABE_DATA_SHIFT)) & I3C_SWDATABE_DATA_MASK)
/*! @} */

/*! @name SWDATAH - Slave Write Data Half-word Register */
/*! @{ */

#define I3C_SWDATAH_DATA0_MASK                   (0xFFU)
#define I3C_SWDATAH_DATA0_SHIFT                  (0U)
/*! DATA0 - The 1st byte to send to the master
 */
#define I3C_SWDATAH_DATA0(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SWDATAH_DATA0_SHIFT)) & I3C_SWDATAH_DATA0_MASK)

#define I3C_SWDATAH_DATA1_MASK                   (0xFF00U)
#define I3C_SWDATAH_DATA1_SHIFT                  (8U)
/*! DATA1 - The 2nd byte to send to the master
 */
#define I3C_SWDATAH_DATA1(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SWDATAH_DATA1_SHIFT)) & I3C_SWDATAH_DATA1_MASK)

#define I3C_SWDATAH_END_MASK                     (0x10000U)
#define I3C_SWDATAH_END_SHIFT                    (16U)
/*! END - End of message
 */
#define I3C_SWDATAH_END(x)                       (((uint32_t)(((uint32_t)(x)) << I3C_SWDATAH_END_SHIFT)) & I3C_SWDATAH_END_MASK)
/*! @} */

/*! @name SWDATAHE - Slave Write Data Half-word End Register */
/*! @{ */

#define I3C_SWDATAHE_DATA0_MASK                  (0xFFU)
#define I3C_SWDATAHE_DATA0_SHIFT                 (0U)
/*! DATA0 - The 1st byte to send to the master
 */
#define I3C_SWDATAHE_DATA0(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_SWDATAHE_DATA0_SHIFT)) & I3C_SWDATAHE_DATA0_MASK)

#define I3C_SWDATAHE_DATA1_MASK                  (0xFF00U)
#define I3C_SWDATAHE_DATA1_SHIFT                 (8U)
/*! DATA1 - The 2nd byte to send to the master
 */
#define I3C_SWDATAHE_DATA1(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_SWDATAHE_DATA1_SHIFT)) & I3C_SWDATAHE_DATA1_MASK)
/*! @} */

/*! @name SRDATAB - Slave Read Data Byte Register */
/*! @{ */

#define I3C_SRDATAB_DATA0_MASK                   (0xFFU)
#define I3C_SRDATAB_DATA0_SHIFT                  (0U)
/*! DATA0 - Byte read from the master
 */
#define I3C_SRDATAB_DATA0(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SRDATAB_DATA0_SHIFT)) & I3C_SRDATAB_DATA0_MASK)
/*! @} */

/*! @name SRDATAH - Slave Read Data Half-word Register */
/*! @{ */

#define I3C_SRDATAH_LSB_MASK                     (0xFFU)
#define I3C_SRDATAH_LSB_SHIFT                    (0U)
/*! LSB - The 1st byte read from the slave
 */
#define I3C_SRDATAH_LSB(x)                       (((uint32_t)(((uint32_t)(x)) << I3C_SRDATAH_LSB_SHIFT)) & I3C_SRDATAH_LSB_MASK)

#define I3C_SRDATAH_MSB_MASK                     (0xFF00U)
#define I3C_SRDATAH_MSB_SHIFT                    (8U)
/*! MSB - The 2nd byte read from the slave
 */
#define I3C_SRDATAH_MSB(x)                       (((uint32_t)(((uint32_t)(x)) << I3C_SRDATAH_MSB_SHIFT)) & I3C_SRDATAH_MSB_MASK)
/*! @} */

/*! @name SCAPABILITIES - Slave Capabilities Register */
/*! @{ */

#define I3C_SCAPABILITIES_IDENA_MASK             (0x3U)
#define I3C_SCAPABILITIES_IDENA_SHIFT            (0U)
/*! IDENA - ID 48b handler
 *  0b00..APPLICATION: Application handles ID 48b
 *  0b01..HW: Hardware handles ID 48b
 *  0b10..HW_BUT: in hardware but the I3C module instance handles ID 48b.
 *  0b11..PARTNO: a part number register (PARTNO) handles ID 48b
 */
#define I3C_SCAPABILITIES_IDENA(x)               (((uint32_t)(((uint32_t)(x)) << I3C_SCAPABILITIES_IDENA_SHIFT)) & I3C_SCAPABILITIES_IDENA_MASK)

#define I3C_SCAPABILITIES_IDREG_MASK             (0x3CU)
#define I3C_SCAPABILITIES_IDREG_SHIFT            (2U)
/*! IDREG - ID register
 */
#define I3C_SCAPABILITIES_IDREG(x)               (((uint32_t)(((uint32_t)(x)) << I3C_SCAPABILITIES_IDREG_SHIFT)) & I3C_SCAPABILITIES_IDREG_MASK)

#define I3C_SCAPABILITIES_HDRSUPP_MASK           (0x1C0U)
#define I3C_SCAPABILITIES_HDRSUPP_SHIFT          (6U)
/*! HDRSUPP - HDR support
 */
#define I3C_SCAPABILITIES_HDRSUPP(x)             (((uint32_t)(((uint32_t)(x)) << I3C_SCAPABILITIES_HDRSUPP_SHIFT)) & I3C_SCAPABILITIES_HDRSUPP_MASK)

#define I3C_SCAPABILITIES_MASTER_MASK            (0x200U)
#define I3C_SCAPABILITIES_MASTER_SHIFT           (9U)
/*! MASTER - Master
 *  0b0..MASTERNOTSUPPORTED: master capability is not supported.
 *  0b1..MASTERSUPPORTED: master capability is supported.
 */
#define I3C_SCAPABILITIES_MASTER(x)              (((uint32_t)(((uint32_t)(x)) << I3C_SCAPABILITIES_MASTER_SHIFT)) & I3C_SCAPABILITIES_MASTER_MASK)

#define I3C_SCAPABILITIES_SADDR_MASK             (0xC00U)
#define I3C_SCAPABILITIES_SADDR_SHIFT            (10U)
/*! SADDR - Static address
 *  0b00..NO_STATIC: No static address
 *  0b01..STATIC: Static address is fixed in hardware
 *  0b10..HW_CONTROL: Hardware controls the static address dynamically (for example, from the pin strap)
 *  0b11..CONFIG: SCONFIG register supplies the static address
 */
#define I3C_SCAPABILITIES_SADDR(x)               (((uint32_t)(((uint32_t)(x)) << I3C_SCAPABILITIES_SADDR_SHIFT)) & I3C_SCAPABILITIES_SADDR_MASK)

#define I3C_SCAPABILITIES_CCCHANDLE_MASK         (0xF000U)
#define I3C_SCAPABILITIES_CCCHANDLE_SHIFT        (12U)
/*! CCCHANDLE - Common Command Codes (CCC) handling
 */
#define I3C_SCAPABILITIES_CCCHANDLE(x)           (((uint32_t)(((uint32_t)(x)) << I3C_SCAPABILITIES_CCCHANDLE_SHIFT)) & I3C_SCAPABILITIES_CCCHANDLE_MASK)

#define I3C_SCAPABILITIES_IBI_MR_HJ_MASK         (0x1F0000U)
#define I3C_SCAPABILITIES_IBI_MR_HJ_SHIFT        (16U)
/*! IBI_MR_HJ - In-Band Interrupts, Master Requests, Hot Join events
 */
#define I3C_SCAPABILITIES_IBI_MR_HJ(x)           (((uint32_t)(((uint32_t)(x)) << I3C_SCAPABILITIES_IBI_MR_HJ_SHIFT)) & I3C_SCAPABILITIES_IBI_MR_HJ_MASK)

#define I3C_SCAPABILITIES_TIMECTRL_MASK          (0x200000U)
#define I3C_SCAPABILITIES_TIMECTRL_SHIFT         (21U)
/*! TIMECTRL - Time control
 *  0b0..NO_TIME_CONTROL_TYPE: No time control is enabled
 *  0b1..ATLEAST1_TIME_CONTROL: at least one time-control type is supported
 */
#define I3C_SCAPABILITIES_TIMECTRL(x)            (((uint32_t)(((uint32_t)(x)) << I3C_SCAPABILITIES_TIMECTRL_SHIFT)) & I3C_SCAPABILITIES_TIMECTRL_MASK)

#define I3C_SCAPABILITIES_EXTFIFO_MASK           (0x3800000U)
#define I3C_SCAPABILITIES_EXTFIFO_SHIFT          (23U)
/*! EXTFIFO - External FIFO
 *  0b001..STD_EXT_FIFO: standard available/free external FIFO
 *  0b011..RESERVED
 */
#define I3C_SCAPABILITIES_EXTFIFO(x)             (((uint32_t)(((uint32_t)(x)) << I3C_SCAPABILITIES_EXTFIFO_SHIFT)) & I3C_SCAPABILITIES_EXTFIFO_MASK)

#define I3C_SCAPABILITIES_FIFOTX_MASK            (0xC000000U)
#define I3C_SCAPABILITIES_FIFOTX_SHIFT           (26U)
/*! FIFOTX - FIFO transmit
 *  0b00..FIFO_2BYTE: 2-byte TX FIFO, the default FIFO transmit value (FIFOTX)
 *  0b01..FIFO_4BYTE: 4-byte TX FIFO
 *  0b10..FIFO_8BYTE: 8-byte TX FIFO
 *  0b11..FIFO_16BYTE: 16-byte TX FIFO
 */
#define I3C_SCAPABILITIES_FIFOTX(x)              (((uint32_t)(((uint32_t)(x)) << I3C_SCAPABILITIES_FIFOTX_SHIFT)) & I3C_SCAPABILITIES_FIFOTX_MASK)

#define I3C_SCAPABILITIES_FIFORX_MASK            (0x30000000U)
#define I3C_SCAPABILITIES_FIFORX_SHIFT           (28U)
/*! FIFORX - FIFO receive
 *  0b00..FIFO_2BYTE: 2 (or 3)-byte RX FIFO, the default FIFO receive value (FIFORX)
 *  0b01..FIFO_4BYTE: 4-byte RX FIFO
 *  0b10..FIFO_8BYTE: 8-byte RX FIFO
 *  0b11..FIFO_16BYTE: 16-byte RX FIFO
 */
#define I3C_SCAPABILITIES_FIFORX(x)              (((uint32_t)(((uint32_t)(x)) << I3C_SCAPABILITIES_FIFORX_SHIFT)) & I3C_SCAPABILITIES_FIFORX_MASK)

#define I3C_SCAPABILITIES_INT_MASK               (0x40000000U)
#define I3C_SCAPABILITIES_INT_SHIFT              (30U)
/*! INT - INT
 *  0b1..Interrupts are supported
 *  0b0..Interrupts are not supported
 */
#define I3C_SCAPABILITIES_INT(x)                 (((uint32_t)(((uint32_t)(x)) << I3C_SCAPABILITIES_INT_SHIFT)) & I3C_SCAPABILITIES_INT_MASK)

#define I3C_SCAPABILITIES_DMA_MASK               (0x80000000U)
#define I3C_SCAPABILITIES_DMA_SHIFT              (31U)
/*! DMA - DMA
 *  0b1..DMA is supported
 *  0b0..DMA is not supported
 */
#define I3C_SCAPABILITIES_DMA(x)                 (((uint32_t)(((uint32_t)(x)) << I3C_SCAPABILITIES_DMA_SHIFT)) & I3C_SCAPABILITIES_DMA_MASK)
/*! @} */

/*! @name SDYNADDR - Slave Dynamic Address Register */
/*! @{ */

#define I3C_SDYNADDR_DAVALID_MASK                (0x1U)
#define I3C_SDYNADDR_DAVALID_SHIFT               (0U)
/*! DAVALID - DAVALID
 *  0b0..DANOTASSIGNED: a Dynamic Address is not assigned
 *  0b1..DAASSIGNED: a Dynamic Address is assigned
 */
#define I3C_SDYNADDR_DAVALID(x)                  (((uint32_t)(((uint32_t)(x)) << I3C_SDYNADDR_DAVALID_SHIFT)) & I3C_SDYNADDR_DAVALID_MASK)

#define I3C_SDYNADDR_DADDR_MASK                  (0xFEU)
#define I3C_SDYNADDR_DADDR_SHIFT                 (1U)
/*! DADDR - Dynamic address
 */
#define I3C_SDYNADDR_DADDR(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_SDYNADDR_DADDR_SHIFT)) & I3C_SDYNADDR_DADDR_MASK)

#define I3C_SDYNADDR_MAPIDX_MASK                 (0xF00U)
#define I3C_SDYNADDR_MAPIDX_SHIFT                (8U)
/*! MAPIDX - Mapped Dynamic Address
 */
#define I3C_SDYNADDR_MAPIDX(x)                   (((uint32_t)(((uint32_t)(x)) << I3C_SDYNADDR_MAPIDX_SHIFT)) & I3C_SDYNADDR_MAPIDX_MASK)

#define I3C_SDYNADDR_MAPSA_MASK                  (0x1000U)
#define I3C_SDYNADDR_MAPSA_SHIFT                 (12U)
/*! MAPSA - Map a Static Address
 */
#define I3C_SDYNADDR_MAPSA(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_SDYNADDR_MAPSA_SHIFT)) & I3C_SDYNADDR_MAPSA_MASK)

#define I3C_SDYNADDR_KEY_MASK                    (0xFFFF0000U)
#define I3C_SDYNADDR_KEY_SHIFT                   (16U)
/*! KEY - Key
 */
#define I3C_SDYNADDR_KEY(x)                      (((uint32_t)(((uint32_t)(x)) << I3C_SDYNADDR_KEY_SHIFT)) & I3C_SDYNADDR_KEY_MASK)
/*! @} */

/*! @name SMAXLIMITS - Slave Maximum Limits Register */
/*! @{ */

#define I3C_SMAXLIMITS_MAXRD_MASK                (0xFFFU)
#define I3C_SMAXLIMITS_MAXRD_SHIFT               (0U)
/*! MAXRD - Maximum read length
 */
#define I3C_SMAXLIMITS_MAXRD(x)                  (((uint32_t)(((uint32_t)(x)) << I3C_SMAXLIMITS_MAXRD_SHIFT)) & I3C_SMAXLIMITS_MAXRD_MASK)

#define I3C_SMAXLIMITS_MAXWR_MASK                (0xFFF0000U)
#define I3C_SMAXLIMITS_MAXWR_SHIFT               (16U)
/*! MAXWR - Maximum write length
 */
#define I3C_SMAXLIMITS_MAXWR(x)                  (((uint32_t)(((uint32_t)(x)) << I3C_SMAXLIMITS_MAXWR_SHIFT)) & I3C_SMAXLIMITS_MAXWR_MASK)
/*! @} */

/*! @name SIDPARTNO - Slave ID Part Number Register */
/*! @{ */

#define I3C_SIDPARTNO_PARTNO_MASK                (0xFFFFFFFFU)
#define I3C_SIDPARTNO_PARTNO_SHIFT               (0U)
/*! PARTNO - Part number
 */
#define I3C_SIDPARTNO_PARTNO(x)                  (((uint32_t)(((uint32_t)(x)) << I3C_SIDPARTNO_PARTNO_SHIFT)) & I3C_SIDPARTNO_PARTNO_MASK)
/*! @} */

/*! @name SIDEXT - Slave ID Extension Register */
/*! @{ */

#define I3C_SIDEXT_DCR_MASK                      (0xFF00U)
#define I3C_SIDEXT_DCR_SHIFT                     (8U)
/*! DCR - Device Characteristic Register
 */
#define I3C_SIDEXT_DCR(x)                        (((uint32_t)(((uint32_t)(x)) << I3C_SIDEXT_DCR_SHIFT)) & I3C_SIDEXT_DCR_MASK)

#define I3C_SIDEXT_BCR_MASK                      (0xFF0000U)
#define I3C_SIDEXT_BCR_SHIFT                     (16U)
/*! BCR - Bus Characteristics Register
 */
#define I3C_SIDEXT_BCR(x)                        (((uint32_t)(((uint32_t)(x)) << I3C_SIDEXT_BCR_SHIFT)) & I3C_SIDEXT_BCR_MASK)
/*! @} */

/*! @name SVENDORID - Slave Vendor ID Register */
/*! @{ */

#define I3C_SVENDORID_VID_MASK                   (0x7FFFU)
#define I3C_SVENDORID_VID_SHIFT                  (0U)
/*! VID - Vendor ID
 */
#define I3C_SVENDORID_VID(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SVENDORID_VID_SHIFT)) & I3C_SVENDORID_VID_MASK)
/*! @} */

/*! @name STCCLOCK - Slave Time Control Clock Register */
/*! @{ */

#define I3C_STCCLOCK_ACCURACY_MASK               (0xFFU)
#define I3C_STCCLOCK_ACCURACY_SHIFT              (0U)
/*! ACCURACY - Clock accuracy
 */
#define I3C_STCCLOCK_ACCURACY(x)                 (((uint32_t)(((uint32_t)(x)) << I3C_STCCLOCK_ACCURACY_SHIFT)) & I3C_STCCLOCK_ACCURACY_MASK)

#define I3C_STCCLOCK_FREQ_MASK                   (0xFF00U)
#define I3C_STCCLOCK_FREQ_SHIFT                  (8U)
/*! FREQ - Clock frequency
 */
#define I3C_STCCLOCK_FREQ(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_STCCLOCK_FREQ_SHIFT)) & I3C_STCCLOCK_FREQ_MASK)
/*! @} */

/*! @name SMSGMAPADDR - Slave Message-Mapped Address Register */
/*! @{ */

#define I3C_SMSGMAPADDR_MAPLAST_MASK             (0xFU)
#define I3C_SMSGMAPADDR_MAPLAST_SHIFT            (0U)
/*! MAPLAST - Matched address index
 */
#define I3C_SMSGMAPADDR_MAPLAST(x)               (((uint32_t)(((uint32_t)(x)) << I3C_SMSGMAPADDR_MAPLAST_SHIFT)) & I3C_SMSGMAPADDR_MAPLAST_MASK)

#define I3C_SMSGMAPADDR_MAPLASTM1_MASK           (0xF00U)
#define I3C_SMSGMAPADDR_MAPLASTM1_SHIFT          (8U)
/*! MAPLASTM1 - Previous match index 1
 */
#define I3C_SMSGMAPADDR_MAPLASTM1(x)             (((uint32_t)(((uint32_t)(x)) << I3C_SMSGMAPADDR_MAPLASTM1_SHIFT)) & I3C_SMSGMAPADDR_MAPLASTM1_MASK)

#define I3C_SMSGMAPADDR_MAPLASTM2_MASK           (0xF0000U)
#define I3C_SMSGMAPADDR_MAPLASTM2_SHIFT          (16U)
/*! MAPLASTM2 - Previous match index 2
 */
#define I3C_SMSGMAPADDR_MAPLASTM2(x)             (((uint32_t)(((uint32_t)(x)) << I3C_SMSGMAPADDR_MAPLASTM2_SHIFT)) & I3C_SMSGMAPADDR_MAPLASTM2_MASK)
/*! @} */

/*! @name MCTRL - Master Main Control Register */
/*! @{ */

#define I3C_MCTRL_REQUEST_MASK                   (0x7U)
#define I3C_MCTRL_REQUEST_SHIFT                  (0U)
/*! REQUEST - Request
 *  0b000..NONE: Returns to this when finished with any request. The MSTATUS register indicates the master's
 *         state. See also AutoIBI mode. NONE is only written as 0: when setting RDTERM to 1 (to stop a read in
 *         progress) or when setting IBI reponse field (IBIRESP) for MSG use
 *  0b001..EMITSTARTADDR: Emit START with address and direction from a stopped state or in the middle of a Single
 *         Data Rate (SDR) message. If from a stopped state (IDLE), then emit start may be prevented by an event
 *         (like IBI, MR, HJ), in which case the appropriate interrupt is signaled; note that Emit START can be
 *         resubmitted.
 *  0b010..EMITSTOP: Emit a STOP on bus. Must be in Single Data Rate (SDR) mode. If in Dynamic Address Assignment
 *         (DAA) mode, Emit stop will exit DAA mode.
 *  0b011..IBIACKNACK: Manual In-Band Interrupt (IBI) Acknowledge (ACK) or Not Acknowledge (NACK). When IBIRESP
 *         has indicated a hold on an In-Band Interrupt to allow a manual decision, this request completes it. Uses
 *         IBIRESP to provide the information.
 *  0b100..PROCESSDAA: If not in Dynamic Address Assignment (DAA) mode now, will issue START, 7E, ENTDAA, and then
 *         will emit 7E/R to process each slave. Will stop just before the new Dynamic Address (DA) is to be
 *         emitted. The next Process DAA request will use the Addr field as the new DA to assign. If NACKed on the 7E/R,
 *         then the interrupt will indicate this situation, and a STOP will be emitted.
 *  0b101..RESERVED
 *  0b110..FORCEEXIT and IBHR: Emit an Exit Pattern from any state, but end Double Data Rate (DDR) (including
 *         MSGDDR), if in DDR mode now. Includes a STOP afterward. If TYPE != 0, then it will perform an IBHR (In-Band
 *         Hardware Reset). If TYPE=2, then it does a normal reset (DEFRST can prevent the reset). If TYPE=3, it
 *         does a forced reset (will always reset).
 *  0b111..AUTOIBI: Hold in a stopped state, but auto-emit START,7E when the slave is holding down SDA to get an
 *         In-Band Interrupt (IBI). Actual In-Band Interrupt handling is defined by IBIRESP.
 */
#define I3C_MCTRL_REQUEST(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_MCTRL_REQUEST_SHIFT)) & I3C_MCTRL_REQUEST_MASK)

#define I3C_MCTRL_TYPE_MASK                      (0x30U)
#define I3C_MCTRL_TYPE_SHIFT                     (4U)
/*! TYPE - Bus type with START
 *  0b00..I3C: Normally the SDR mode of I3C. For ForceExit, the Exit pattern.
 *  0b01..I2C: Normally the Standard I2C protocol.
 *  0b10..DDR: (Double Data Rate): Normally the HDR-DDR mode of I3C. Enter DDR mode (7E and then ENTHDR0), if the
 *        module is not already in DDR mode. The 1st byte written to the TX FIFO should be a command, and should
 *        already be in the FIFO. To end DDR mode, use ForceExit. For ForceExit, the normal IBHR (In-Band Hardware
 *        Reset).
 *  0b11..For ForcedExit, this is forced IBHR.
 */
#define I3C_MCTRL_TYPE(x)                        (((uint32_t)(((uint32_t)(x)) << I3C_MCTRL_TYPE_SHIFT)) & I3C_MCTRL_TYPE_MASK)

#define I3C_MCTRL_IBIRESP_MASK                   (0xC0U)
#define I3C_MCTRL_IBIRESP_SHIFT                  (6U)
/*! IBIRESP - In-Band Interrupt (IBI) response
 *  0b00..ACK: Acknowledge. A mandatory byte (or not) is decided by the Master In-band Interrupt Registry and
 *        Rules Register (MIBIRULES). To limit the maximum number of IBI bytes, configure the Read Termination field
 *        (MCTRL.RDTERM).
 *  0b01..NACK: Not acknowledge
 *  0b10..ACK_WITH_MANDATORY: Acknowledge with mandatory byte (ignores the MIBIRULES register). Acknowledge with
 *        mandatory byte should not be used, unless only slaves with a mandatory byte can cause an In-Band Interrupt.
 *  0b11..MANUAL: stop and wait for a decision using the IBIAckNack request
 */
#define I3C_MCTRL_IBIRESP(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_MCTRL_IBIRESP_SHIFT)) & I3C_MCTRL_IBIRESP_MASK)

#define I3C_MCTRL_DIR_MASK                       (0x100U)
#define I3C_MCTRL_DIR_SHIFT                      (8U)
/*! DIR - DIR
 *  0b0..DIRWRITE: Write
 *  0b1..DIRREAD: Read
 */
#define I3C_MCTRL_DIR(x)                         (((uint32_t)(((uint32_t)(x)) << I3C_MCTRL_DIR_SHIFT)) & I3C_MCTRL_DIR_MASK)

#define I3C_MCTRL_ADDR_MASK                      (0xFE00U)
#define I3C_MCTRL_ADDR_SHIFT                     (9U)
/*! ADDR - ADDR
 */
#define I3C_MCTRL_ADDR(x)                        (((uint32_t)(((uint32_t)(x)) << I3C_MCTRL_ADDR_SHIFT)) & I3C_MCTRL_ADDR_MASK)

#define I3C_MCTRL_RDTERM_MASK                    (0xFF0000U)
#define I3C_MCTRL_RDTERM_SHIFT                   (16U)
/*! RDTERM - Read terminate
 */
#define I3C_MCTRL_RDTERM(x)                      (((uint32_t)(((uint32_t)(x)) << I3C_MCTRL_RDTERM_SHIFT)) & I3C_MCTRL_RDTERM_MASK)
/*! @} */

/*! @name MSTATUS - Master Status Register */
/*! @{ */

#define I3C_MSTATUS_STATE_MASK                   (0x7U)
#define I3C_MSTATUS_STATE_SHIFT                  (0U)
/*! STATE - State of the master
 *  0b000..IDLE: the bus has STOPped.
 *  0b001..SLVREQ: (Slave Request state) the bus has STOPped but a slave is holding SDA low. If using auto-emit
 *         IBI (MCTRL.AutoIBI), then the master will not stay in the Slave Request state.
 *  0b010..MSGSDR: in Single Data Rate (SDR) Message state (from using MWMSG_SDR)
 *  0b011..NORMACT: normal active Single Data Rate (SDR) state (from using MCTRL and MWDATAn and MRDATAn
 *         registers). The master will stay in the NORMACT state until a STOP is issued.
 *  0b100..MSGDDR: in Double Data Rate (DDR) Message mode (from using MWMSG_DDR or using the normal method with
 *         DDR). The master will stay in the DDR state, until the master exits using EXIT (emits the Exit pattern).
 *  0b101..DAA: in Enter Dynamic Address Assignment (ENTDAA) mode
 *  0b110..IBIACK: waiting for an In-Band Interrupt (IBI) ACK/NACK decision
 *  0b111..IBIRCV: Receiving an In-Band Interrupt (IBI); this IBIRCV state is used after IBI/MR/HJ has won the
 *         arbitration, and IBIRCV state is also used for IBI mandatory byte (if any) and any bytes that follow.
 */
#define I3C_MSTATUS_STATE(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_MSTATUS_STATE_SHIFT)) & I3C_MSTATUS_STATE_MASK)

#define I3C_MSTATUS_BETWEEN_MASK                 (0x10U)
#define I3C_MSTATUS_BETWEEN_SHIFT                (4U)
/*! BETWEEN - Between messages or Dynamic Address Assignments (DAA)
 */
#define I3C_MSTATUS_BETWEEN(x)                   (((uint32_t)(((uint32_t)(x)) << I3C_MSTATUS_BETWEEN_SHIFT)) & I3C_MSTATUS_BETWEEN_MASK)

#define I3C_MSTATUS_NACKED_MASK                  (0x20U)
#define I3C_MSTATUS_NACKED_SHIFT                 (5U)
/*! NACKED - Not acknowledged
 */
#define I3C_MSTATUS_NACKED(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_MSTATUS_NACKED_SHIFT)) & I3C_MSTATUS_NACKED_MASK)

#define I3C_MSTATUS_IBITYPE_MASK                 (0xC0U)
#define I3C_MSTATUS_IBITYPE_SHIFT                (6U)
/*! IBITYPE - In-Band Interrupt (IBI) type
 *  0b00..NONE: cleared when IBI Won bit (MSTATUS.IBIWON) is cleared
 *  0b01..IBI: In-Band Interrupt
 *  0b10..MR: Master Request
 *  0b11..HJ: Hot-Join
 */
#define I3C_MSTATUS_IBITYPE(x)                   (((uint32_t)(((uint32_t)(x)) << I3C_MSTATUS_IBITYPE_SHIFT)) & I3C_MSTATUS_IBITYPE_MASK)

#define I3C_MSTATUS_SLVSTART_MASK                (0x100U)
#define I3C_MSTATUS_SLVSTART_SHIFT               (8U)
/*! SLVSTART - Slave start
 */
#define I3C_MSTATUS_SLVSTART(x)                  (((uint32_t)(((uint32_t)(x)) << I3C_MSTATUS_SLVSTART_SHIFT)) & I3C_MSTATUS_SLVSTART_MASK)

#define I3C_MSTATUS_MCTRLDONE_MASK               (0x200U)
#define I3C_MSTATUS_MCTRLDONE_SHIFT              (9U)
/*! MCTRLDONE - Master control done
 */
#define I3C_MSTATUS_MCTRLDONE(x)                 (((uint32_t)(((uint32_t)(x)) << I3C_MSTATUS_MCTRLDONE_SHIFT)) & I3C_MSTATUS_MCTRLDONE_MASK)

#define I3C_MSTATUS_COMPLETE_MASK                (0x400U)
#define I3C_MSTATUS_COMPLETE_SHIFT               (10U)
/*! COMPLETE - COMPLETE
 */
#define I3C_MSTATUS_COMPLETE(x)                  (((uint32_t)(((uint32_t)(x)) << I3C_MSTATUS_COMPLETE_SHIFT)) & I3C_MSTATUS_COMPLETE_MASK)

#define I3C_MSTATUS_RXPEND_MASK                  (0x800U)
#define I3C_MSTATUS_RXPEND_SHIFT                 (11U)
/*! RXPEND - RXPEND
 */
#define I3C_MSTATUS_RXPEND(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_MSTATUS_RXPEND_SHIFT)) & I3C_MSTATUS_RXPEND_MASK)

#define I3C_MSTATUS_TXNOTFULL_MASK               (0x1000U)
#define I3C_MSTATUS_TXNOTFULL_SHIFT              (12U)
/*! TXNOTFULL - TX buffer/FIFO not yet full
 */
#define I3C_MSTATUS_TXNOTFULL(x)                 (((uint32_t)(((uint32_t)(x)) << I3C_MSTATUS_TXNOTFULL_SHIFT)) & I3C_MSTATUS_TXNOTFULL_MASK)

#define I3C_MSTATUS_IBIWON_MASK                  (0x2000U)
#define I3C_MSTATUS_IBIWON_SHIFT                 (13U)
/*! IBIWON - In-Band Interrupt (IBI) won
 */
#define I3C_MSTATUS_IBIWON(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_MSTATUS_IBIWON_SHIFT)) & I3C_MSTATUS_IBIWON_MASK)

#define I3C_MSTATUS_ERRWARN_MASK                 (0x8000U)
#define I3C_MSTATUS_ERRWARN_SHIFT                (15U)
/*! ERRWARN - Error or warning
 */
#define I3C_MSTATUS_ERRWARN(x)                   (((uint32_t)(((uint32_t)(x)) << I3C_MSTATUS_ERRWARN_SHIFT)) & I3C_MSTATUS_ERRWARN_MASK)

#define I3C_MSTATUS_NOWMASTER_MASK               (0x80000U)
#define I3C_MSTATUS_NOWMASTER_SHIFT              (19U)
/*! NOWMASTER - Now master (now this module is a master)
 */
#define I3C_MSTATUS_NOWMASTER(x)                 (((uint32_t)(((uint32_t)(x)) << I3C_MSTATUS_NOWMASTER_SHIFT)) & I3C_MSTATUS_NOWMASTER_MASK)

#define I3C_MSTATUS_IBIADDR_MASK                 (0x7F000000U)
#define I3C_MSTATUS_IBIADDR_SHIFT                (24U)
/*! IBIADDR - IBI address
 */
#define I3C_MSTATUS_IBIADDR(x)                   (((uint32_t)(((uint32_t)(x)) << I3C_MSTATUS_IBIADDR_SHIFT)) & I3C_MSTATUS_IBIADDR_MASK)
/*! @} */

/*! @name MIBIRULES - Master In-band Interrupt Registry and Rules Register */
/*! @{ */

#define I3C_MIBIRULES_ADDR0_MASK                 (0x3FU)
#define I3C_MIBIRULES_ADDR0_SHIFT                (0U)
/*! ADDR0 - ADDR0
 */
#define I3C_MIBIRULES_ADDR0(x)                   (((uint32_t)(((uint32_t)(x)) << I3C_MIBIRULES_ADDR0_SHIFT)) & I3C_MIBIRULES_ADDR0_MASK)

#define I3C_MIBIRULES_ADDR1_MASK                 (0xFC0U)
#define I3C_MIBIRULES_ADDR1_SHIFT                (6U)
/*! ADDR1 - ADDR1
 */
#define I3C_MIBIRULES_ADDR1(x)                   (((uint32_t)(((uint32_t)(x)) << I3C_MIBIRULES_ADDR1_SHIFT)) & I3C_MIBIRULES_ADDR1_MASK)

#define I3C_MIBIRULES_ADDR2_MASK                 (0x3F000U)
#define I3C_MIBIRULES_ADDR2_SHIFT                (12U)
/*! ADDR2 - ADDR2
 */
#define I3C_MIBIRULES_ADDR2(x)                   (((uint32_t)(((uint32_t)(x)) << I3C_MIBIRULES_ADDR2_SHIFT)) & I3C_MIBIRULES_ADDR2_MASK)

#define I3C_MIBIRULES_ADDR3_MASK                 (0xFC0000U)
#define I3C_MIBIRULES_ADDR3_SHIFT                (18U)
/*! ADDR3 - ADDR3
 */
#define I3C_MIBIRULES_ADDR3(x)                   (((uint32_t)(((uint32_t)(x)) << I3C_MIBIRULES_ADDR3_SHIFT)) & I3C_MIBIRULES_ADDR3_MASK)

#define I3C_MIBIRULES_ADDR4_MASK                 (0x3F000000U)
#define I3C_MIBIRULES_ADDR4_SHIFT                (24U)
/*! ADDR4 - ADDR4
 */
#define I3C_MIBIRULES_ADDR4(x)                   (((uint32_t)(((uint32_t)(x)) << I3C_MIBIRULES_ADDR4_SHIFT)) & I3C_MIBIRULES_ADDR4_MASK)

#define I3C_MIBIRULES_MSB0_MASK                  (0x40000000U)
#define I3C_MIBIRULES_MSB0_SHIFT                 (30U)
/*! MSB0 - Set Most Significant address Bit to 0
 */
#define I3C_MIBIRULES_MSB0(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_MIBIRULES_MSB0_SHIFT)) & I3C_MIBIRULES_MSB0_MASK)

#define I3C_MIBIRULES_NOBYTE_MASK                (0x80000000U)
#define I3C_MIBIRULES_NOBYTE_SHIFT               (31U)
/*! NOBYTE - No IBI byte
 */
#define I3C_MIBIRULES_NOBYTE(x)                  (((uint32_t)(((uint32_t)(x)) << I3C_MIBIRULES_NOBYTE_SHIFT)) & I3C_MIBIRULES_NOBYTE_MASK)
/*! @} */

/*! @name MINTSET - Master Interrupt Set Register */
/*! @{ */

#define I3C_MINTSET_SLVSTART_MASK                (0x100U)
#define I3C_MINTSET_SLVSTART_SHIFT               (8U)
/*! SLVSTART - Slave start interrupt enable
 */
#define I3C_MINTSET_SLVSTART(x)                  (((uint32_t)(((uint32_t)(x)) << I3C_MINTSET_SLVSTART_SHIFT)) & I3C_MINTSET_SLVSTART_MASK)

#define I3C_MINTSET_MCTRLDONE_MASK               (0x200U)
#define I3C_MINTSET_MCTRLDONE_SHIFT              (9U)
/*! MCTRLDONE - Master control done interrupt enable
 */
#define I3C_MINTSET_MCTRLDONE(x)                 (((uint32_t)(((uint32_t)(x)) << I3C_MINTSET_MCTRLDONE_SHIFT)) & I3C_MINTSET_MCTRLDONE_MASK)

#define I3C_MINTSET_COMPLETE_MASK                (0x400U)
#define I3C_MINTSET_COMPLETE_SHIFT               (10U)
/*! COMPLETE - Completed message interrupt enable
 */
#define I3C_MINTSET_COMPLETE(x)                  (((uint32_t)(((uint32_t)(x)) << I3C_MINTSET_COMPLETE_SHIFT)) & I3C_MINTSET_COMPLETE_MASK)

#define I3C_MINTSET_RXPEND_MASK                  (0x800U)
#define I3C_MINTSET_RXPEND_SHIFT                 (11U)
/*! RXPEND - RX pending interrupt enable
 */
#define I3C_MINTSET_RXPEND(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_MINTSET_RXPEND_SHIFT)) & I3C_MINTSET_RXPEND_MASK)

#define I3C_MINTSET_TXNOTFULL_MASK               (0x1000U)
#define I3C_MINTSET_TXNOTFULL_SHIFT              (12U)
/*! TXNOTFULL - TX buffer/FIFO is not full interrupt enable
 */
#define I3C_MINTSET_TXNOTFULL(x)                 (((uint32_t)(((uint32_t)(x)) << I3C_MINTSET_TXNOTFULL_SHIFT)) & I3C_MINTSET_TXNOTFULL_MASK)

#define I3C_MINTSET_IBIWON_MASK                  (0x2000U)
#define I3C_MINTSET_IBIWON_SHIFT                 (13U)
/*! IBIWON - In-Band Interrupt (IBI) won interrupt enable
 */
#define I3C_MINTSET_IBIWON(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_MINTSET_IBIWON_SHIFT)) & I3C_MINTSET_IBIWON_MASK)

#define I3C_MINTSET_ERRWARN_MASK                 (0x8000U)
#define I3C_MINTSET_ERRWARN_SHIFT                (15U)
/*! ERRWARN - Error or warning (ERRWARN) interrupt enable
 */
#define I3C_MINTSET_ERRWARN(x)                   (((uint32_t)(((uint32_t)(x)) << I3C_MINTSET_ERRWARN_SHIFT)) & I3C_MINTSET_ERRWARN_MASK)

#define I3C_MINTSET_NOWMASTER_MASK               (0x80000U)
#define I3C_MINTSET_NOWMASTER_SHIFT              (19U)
/*! NOWMASTER - Now master (now this I3C module is a master) interrupt enable
 */
#define I3C_MINTSET_NOWMASTER(x)                 (((uint32_t)(((uint32_t)(x)) << I3C_MINTSET_NOWMASTER_SHIFT)) & I3C_MINTSET_NOWMASTER_MASK)
/*! @} */

/*! @name MINTCLR - Master Interrupt Clear Register */
/*! @{ */

#define I3C_MINTCLR_SLVSTART_MASK                (0x100U)
#define I3C_MINTCLR_SLVSTART_SHIFT               (8U)
/*! SLVSTART - SLVSTART interrupt enable clear
 */
#define I3C_MINTCLR_SLVSTART(x)                  (((uint32_t)(((uint32_t)(x)) << I3C_MINTCLR_SLVSTART_SHIFT)) & I3C_MINTCLR_SLVSTART_MASK)

#define I3C_MINTCLR_MCTRLDONE_MASK               (0x200U)
#define I3C_MINTCLR_MCTRLDONE_SHIFT              (9U)
/*! MCTRLDONE - MCTRLDONE interrupt enable clear
 */
#define I3C_MINTCLR_MCTRLDONE(x)                 (((uint32_t)(((uint32_t)(x)) << I3C_MINTCLR_MCTRLDONE_SHIFT)) & I3C_MINTCLR_MCTRLDONE_MASK)

#define I3C_MINTCLR_COMPLETE_MASK                (0x400U)
#define I3C_MINTCLR_COMPLETE_SHIFT               (10U)
/*! COMPLETE - COMPLETE interrupt enable clear
 */
#define I3C_MINTCLR_COMPLETE(x)                  (((uint32_t)(((uint32_t)(x)) << I3C_MINTCLR_COMPLETE_SHIFT)) & I3C_MINTCLR_COMPLETE_MASK)

#define I3C_MINTCLR_RXPEND_MASK                  (0x800U)
#define I3C_MINTCLR_RXPEND_SHIFT                 (11U)
/*! RXPEND - RXPEND interrupt enable clear
 */
#define I3C_MINTCLR_RXPEND(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_MINTCLR_RXPEND_SHIFT)) & I3C_MINTCLR_RXPEND_MASK)

#define I3C_MINTCLR_TXNOTFULL_MASK               (0x1000U)
#define I3C_MINTCLR_TXNOTFULL_SHIFT              (12U)
/*! TXNOTFULL - TXNOTFULL interrupt enable clear
 */
#define I3C_MINTCLR_TXNOTFULL(x)                 (((uint32_t)(((uint32_t)(x)) << I3C_MINTCLR_TXNOTFULL_SHIFT)) & I3C_MINTCLR_TXNOTFULL_MASK)

#define I3C_MINTCLR_IBIWON_MASK                  (0x2000U)
#define I3C_MINTCLR_IBIWON_SHIFT                 (13U)
/*! IBIWON - IBIWON interrupt enable clear
 */
#define I3C_MINTCLR_IBIWON(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_MINTCLR_IBIWON_SHIFT)) & I3C_MINTCLR_IBIWON_MASK)

#define I3C_MINTCLR_ERRWARN_MASK                 (0x8000U)
#define I3C_MINTCLR_ERRWARN_SHIFT                (15U)
/*! ERRWARN - ERRWARN interrupt enable clear
 */
#define I3C_MINTCLR_ERRWARN(x)                   (((uint32_t)(((uint32_t)(x)) << I3C_MINTCLR_ERRWARN_SHIFT)) & I3C_MINTCLR_ERRWARN_MASK)

#define I3C_MINTCLR_NOWMASTER_MASK               (0x80000U)
#define I3C_MINTCLR_NOWMASTER_SHIFT              (19U)
/*! NOWMASTER - NOWMASTER interrupt enable clear
 */
#define I3C_MINTCLR_NOWMASTER(x)                 (((uint32_t)(((uint32_t)(x)) << I3C_MINTCLR_NOWMASTER_SHIFT)) & I3C_MINTCLR_NOWMASTER_MASK)
/*! @} */

/*! @name MINTMASKED - Master Interrupt Mask Register */
/*! @{ */

#define I3C_MINTMASKED_SLVSTART_MASK             (0x100U)
#define I3C_MINTMASKED_SLVSTART_SHIFT            (8U)
/*! SLVSTART - SLVSTART interrupt mask
 */
#define I3C_MINTMASKED_SLVSTART(x)               (((uint32_t)(((uint32_t)(x)) << I3C_MINTMASKED_SLVSTART_SHIFT)) & I3C_MINTMASKED_SLVSTART_MASK)

#define I3C_MINTMASKED_MCTRLDONE_MASK            (0x200U)
#define I3C_MINTMASKED_MCTRLDONE_SHIFT           (9U)
/*! MCTRLDONE - MCTRLDONE interrupt mask
 */
#define I3C_MINTMASKED_MCTRLDONE(x)              (((uint32_t)(((uint32_t)(x)) << I3C_MINTMASKED_MCTRLDONE_SHIFT)) & I3C_MINTMASKED_MCTRLDONE_MASK)

#define I3C_MINTMASKED_COMPLETE_MASK             (0x400U)
#define I3C_MINTMASKED_COMPLETE_SHIFT            (10U)
/*! COMPLETE - COMPLETE interrupt mask
 */
#define I3C_MINTMASKED_COMPLETE(x)               (((uint32_t)(((uint32_t)(x)) << I3C_MINTMASKED_COMPLETE_SHIFT)) & I3C_MINTMASKED_COMPLETE_MASK)

#define I3C_MINTMASKED_RXPEND_MASK               (0x800U)
#define I3C_MINTMASKED_RXPEND_SHIFT              (11U)
/*! RXPEND - RXPEND interrupt mask
 */
#define I3C_MINTMASKED_RXPEND(x)                 (((uint32_t)(((uint32_t)(x)) << I3C_MINTMASKED_RXPEND_SHIFT)) & I3C_MINTMASKED_RXPEND_MASK)

#define I3C_MINTMASKED_TXNOTFULL_MASK            (0x1000U)
#define I3C_MINTMASKED_TXNOTFULL_SHIFT           (12U)
/*! TXNOTFULL - TXNOTFULL interrupt mask
 */
#define I3C_MINTMASKED_TXNOTFULL(x)              (((uint32_t)(((uint32_t)(x)) << I3C_MINTMASKED_TXNOTFULL_SHIFT)) & I3C_MINTMASKED_TXNOTFULL_MASK)

#define I3C_MINTMASKED_IBIWON_MASK               (0x2000U)
#define I3C_MINTMASKED_IBIWON_SHIFT              (13U)
/*! IBIWON - IBIWON interrupt mask
 */
#define I3C_MINTMASKED_IBIWON(x)                 (((uint32_t)(((uint32_t)(x)) << I3C_MINTMASKED_IBIWON_SHIFT)) & I3C_MINTMASKED_IBIWON_MASK)

#define I3C_MINTMASKED_ERRWARN_MASK              (0x8000U)
#define I3C_MINTMASKED_ERRWARN_SHIFT             (15U)
/*! ERRWARN - ERRWARN interrupt mask
 */
#define I3C_MINTMASKED_ERRWARN(x)                (((uint32_t)(((uint32_t)(x)) << I3C_MINTMASKED_ERRWARN_SHIFT)) & I3C_MINTMASKED_ERRWARN_MASK)

#define I3C_MINTMASKED_NOWMASTER_MASK            (0x80000U)
#define I3C_MINTMASKED_NOWMASTER_SHIFT           (19U)
/*! NOWMASTER - NOWMASTER interrupt mask
 */
#define I3C_MINTMASKED_NOWMASTER(x)              (((uint32_t)(((uint32_t)(x)) << I3C_MINTMASKED_NOWMASTER_SHIFT)) & I3C_MINTMASKED_NOWMASTER_MASK)
/*! @} */

/*! @name MERRWARN - Master Errors and Warnings Register */
/*! @{ */

#define I3C_MERRWARN_NACK_MASK                   (0x4U)
#define I3C_MERRWARN_NACK_SHIFT                  (2U)
/*! NACK - Not acknowledge (NACK) error
 */
#define I3C_MERRWARN_NACK(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_MERRWARN_NACK_SHIFT)) & I3C_MERRWARN_NACK_MASK)

#define I3C_MERRWARN_WRABT_MASK                  (0x8U)
#define I3C_MERRWARN_WRABT_SHIFT                 (3U)
/*! WRABT - WRABT (Write abort) error
 */
#define I3C_MERRWARN_WRABT(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_MERRWARN_WRABT_SHIFT)) & I3C_MERRWARN_WRABT_MASK)

#define I3C_MERRWARN_TERM_MASK                   (0x10U)
#define I3C_MERRWARN_TERM_SHIFT                  (4U)
/*! TERM - Terminate error
 */
#define I3C_MERRWARN_TERM(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_MERRWARN_TERM_SHIFT)) & I3C_MERRWARN_TERM_MASK)

#define I3C_MERRWARN_HPAR_MASK                   (0x200U)
#define I3C_MERRWARN_HPAR_SHIFT                  (9U)
/*! HPAR - High data rate parity
 */
#define I3C_MERRWARN_HPAR(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_MERRWARN_HPAR_SHIFT)) & I3C_MERRWARN_HPAR_MASK)

#define I3C_MERRWARN_HCRC_MASK                   (0x400U)
#define I3C_MERRWARN_HCRC_SHIFT                  (10U)
/*! HCRC - High data rate CRC error
 */
#define I3C_MERRWARN_HCRC(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_MERRWARN_HCRC_SHIFT)) & I3C_MERRWARN_HCRC_MASK)

#define I3C_MERRWARN_OREAD_MASK                  (0x10000U)
#define I3C_MERRWARN_OREAD_SHIFT                 (16U)
/*! OREAD - Over-read error
 */
#define I3C_MERRWARN_OREAD(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_MERRWARN_OREAD_SHIFT)) & I3C_MERRWARN_OREAD_MASK)

#define I3C_MERRWARN_OWRITE_MASK                 (0x20000U)
#define I3C_MERRWARN_OWRITE_SHIFT                (17U)
/*! OWRITE - Over-write error
 */
#define I3C_MERRWARN_OWRITE(x)                   (((uint32_t)(((uint32_t)(x)) << I3C_MERRWARN_OWRITE_SHIFT)) & I3C_MERRWARN_OWRITE_MASK)

#define I3C_MERRWARN_MSGERR_MASK                 (0x40000U)
#define I3C_MERRWARN_MSGERR_SHIFT                (18U)
/*! MSGERR - Message error
 */
#define I3C_MERRWARN_MSGERR(x)                   (((uint32_t)(((uint32_t)(x)) << I3C_MERRWARN_MSGERR_SHIFT)) & I3C_MERRWARN_MSGERR_MASK)

#define I3C_MERRWARN_INVREQ_MASK                 (0x80000U)
#define I3C_MERRWARN_INVREQ_SHIFT                (19U)
/*! INVREQ - Invalid request error
 */
#define I3C_MERRWARN_INVREQ(x)                   (((uint32_t)(((uint32_t)(x)) << I3C_MERRWARN_INVREQ_SHIFT)) & I3C_MERRWARN_INVREQ_MASK)

#define I3C_MERRWARN_TIMEOUT_MASK                (0x100000U)
#define I3C_MERRWARN_TIMEOUT_SHIFT               (20U)
/*! TIMEOUT - TIMEOUT error
 */
#define I3C_MERRWARN_TIMEOUT(x)                  (((uint32_t)(((uint32_t)(x)) << I3C_MERRWARN_TIMEOUT_SHIFT)) & I3C_MERRWARN_TIMEOUT_MASK)
/*! @} */

/*! @name MDMACTRL - Master DMA Control Register */
/*! @{ */

#define I3C_MDMACTRL_DMAFB_MASK                  (0x3U)
#define I3C_MDMACTRL_DMAFB_SHIFT                 (0U)
/*! DMAFB - DMA from bus
 *  0b00..NOT_USED: DMA is not used
 *  0b01..ENABLE_ONE_FRAME: DMA is enabled for 1 frame. DMAFB auto-clears on STOP or repeated START. See MCONFIG.MATCHSS.
 *  0b10..ENABLE: DMA is enabled until the DMA is turned off.
 */
#define I3C_MDMACTRL_DMAFB(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_MDMACTRL_DMAFB_SHIFT)) & I3C_MDMACTRL_DMAFB_MASK)

#define I3C_MDMACTRL_DMATB_MASK                  (0xCU)
#define I3C_MDMACTRL_DMATB_SHIFT                 (2U)
/*! DMATB - DMA to bus
 *  0b00..NOT_USED: DMA is not used
 *  0b01..ENABLE_ONE_FRAME: DMA is enabled for 1 frame (ended by DMA or Terminated). DMATB auto-clears on STOP or START. See MCONFIG.MATCHSS.
 *  0b10..ENABLE: DMA is enabled until DMA is turned off. Normally DMA ENABLE should only be used in Master Message mode.
 */
#define I3C_MDMACTRL_DMATB(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_MDMACTRL_DMATB_SHIFT)) & I3C_MDMACTRL_DMATB_MASK)

#define I3C_MDMACTRL_DMAWIDTH_MASK               (0x30U)
#define I3C_MDMACTRL_DMAWIDTH_SHIFT              (4U)
/*! DMAWIDTH - DMA width
 *  0b00..BYTE
 *  0b01..BYTE_AGAIN
 *  0b10..HALF_WORD: Half-word (16 bits). This will make sure that 2 bytes are free/available in FIFO.
 *  0b11..RESERVED
 */
#define I3C_MDMACTRL_DMAWIDTH(x)                 (((uint32_t)(((uint32_t)(x)) << I3C_MDMACTRL_DMAWIDTH_SHIFT)) & I3C_MDMACTRL_DMAWIDTH_MASK)
/*! @} */

/*! @name MDATACTRL - Master Data Control Register */
/*! @{ */

#define I3C_MDATACTRL_FLUSHTB_MASK               (0x1U)
#define I3C_MDATACTRL_FLUSHTB_SHIFT              (0U)
/*! FLUSHTB - Flush to-bus buffer/FIFO
 */
#define I3C_MDATACTRL_FLUSHTB(x)                 (((uint32_t)(((uint32_t)(x)) << I3C_MDATACTRL_FLUSHTB_SHIFT)) & I3C_MDATACTRL_FLUSHTB_MASK)

#define I3C_MDATACTRL_FLUSHFB_MASK               (0x2U)
#define I3C_MDATACTRL_FLUSHFB_SHIFT              (1U)
/*! FLUSHFB - Flush from-bus buffer/FIFO
 */
#define I3C_MDATACTRL_FLUSHFB(x)                 (((uint32_t)(((uint32_t)(x)) << I3C_MDATACTRL_FLUSHFB_SHIFT)) & I3C_MDATACTRL_FLUSHFB_MASK)

#define I3C_MDATACTRL_UNLOCK_MASK                (0x4U)
#define I3C_MDATACTRL_UNLOCK_SHIFT               (2U)
/*! UNLOCK - Unlock
 */
#define I3C_MDATACTRL_UNLOCK(x)                  (((uint32_t)(((uint32_t)(x)) << I3C_MDATACTRL_UNLOCK_SHIFT)) & I3C_MDATACTRL_UNLOCK_MASK)

#define I3C_MDATACTRL_TXTRIG_MASK                (0x30U)
#define I3C_MDATACTRL_TXTRIG_SHIFT               (4U)
/*! TXTRIG - TX trigger level
 */
#define I3C_MDATACTRL_TXTRIG(x)                  (((uint32_t)(((uint32_t)(x)) << I3C_MDATACTRL_TXTRIG_SHIFT)) & I3C_MDATACTRL_TXTRIG_MASK)

#define I3C_MDATACTRL_RXTRIG_MASK                (0xC0U)
#define I3C_MDATACTRL_RXTRIG_SHIFT               (6U)
/*! RXTRIG - RX trigger level
 */
#define I3C_MDATACTRL_RXTRIG(x)                  (((uint32_t)(((uint32_t)(x)) << I3C_MDATACTRL_RXTRIG_SHIFT)) & I3C_MDATACTRL_RXTRIG_MASK)

#define I3C_MDATACTRL_TXCOUNT_MASK               (0x1F0000U)
#define I3C_MDATACTRL_TXCOUNT_SHIFT              (16U)
/*! TXCOUNT - TX byte count
 */
#define I3C_MDATACTRL_TXCOUNT(x)                 (((uint32_t)(((uint32_t)(x)) << I3C_MDATACTRL_TXCOUNT_SHIFT)) & I3C_MDATACTRL_TXCOUNT_MASK)

#define I3C_MDATACTRL_RXCOUNT_MASK               (0x1F000000U)
#define I3C_MDATACTRL_RXCOUNT_SHIFT              (24U)
/*! RXCOUNT - RX byte count
 */
#define I3C_MDATACTRL_RXCOUNT(x)                 (((uint32_t)(((uint32_t)(x)) << I3C_MDATACTRL_RXCOUNT_SHIFT)) & I3C_MDATACTRL_RXCOUNT_MASK)

#define I3C_MDATACTRL_TXFULL_MASK                (0x40000000U)
#define I3C_MDATACTRL_TXFULL_SHIFT               (30U)
/*! TXFULL - TX is full
 */
#define I3C_MDATACTRL_TXFULL(x)                  (((uint32_t)(((uint32_t)(x)) << I3C_MDATACTRL_TXFULL_SHIFT)) & I3C_MDATACTRL_TXFULL_MASK)

#define I3C_MDATACTRL_RXEMPTY_MASK               (0x80000000U)
#define I3C_MDATACTRL_RXEMPTY_SHIFT              (31U)
/*! RXEMPTY - RX is empty
 */
#define I3C_MDATACTRL_RXEMPTY(x)                 (((uint32_t)(((uint32_t)(x)) << I3C_MDATACTRL_RXEMPTY_SHIFT)) & I3C_MDATACTRL_RXEMPTY_MASK)
/*! @} */

/*! @name MWDATAB - Master Write Data Byte Register */
/*! @{ */

#define I3C_MWDATAB_DATA_MASK                    (0xFFU)
#define I3C_MWDATAB_DATA_SHIFT                   (0U)
/*! DATA - Data byte
 */
#define I3C_MWDATAB_DATA(x)                      (((uint32_t)(((uint32_t)(x)) << I3C_MWDATAB_DATA_SHIFT)) & I3C_MWDATAB_DATA_MASK)

#define I3C_MWDATAB_END_MASK                     (0x100U)
#define I3C_MWDATAB_END_SHIFT                    (8U)
/*! END - End of message
 */
#define I3C_MWDATAB_END(x)                       (((uint32_t)(((uint32_t)(x)) << I3C_MWDATAB_END_SHIFT)) & I3C_MWDATAB_END_MASK)

#define I3C_MWDATAB_END_ALSO_MASK                (0x10000U)
#define I3C_MWDATAB_END_ALSO_SHIFT               (16U)
/*! END_ALSO - End of message also
 */
#define I3C_MWDATAB_END_ALSO(x)                  (((uint32_t)(((uint32_t)(x)) << I3C_MWDATAB_END_ALSO_SHIFT)) & I3C_MWDATAB_END_ALSO_MASK)
/*! @} */

/*! @name MWDATABE - Master Write Data Byte End Register */
/*! @{ */

#define I3C_MWDATABE_DATA_MASK                   (0xFFU)
#define I3C_MWDATABE_DATA_SHIFT                  (0U)
/*! DATA - Data
 */
#define I3C_MWDATABE_DATA(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_MWDATABE_DATA_SHIFT)) & I3C_MWDATABE_DATA_MASK)
/*! @} */

/*! @name MWDATAH - Master Write Data Half-word Register */
/*! @{ */

#define I3C_MWDATAH_DATA0_MASK                   (0xFFU)
#define I3C_MWDATAH_DATA0_SHIFT                  (0U)
/*! DATA0 - Data byte 0
 */
#define I3C_MWDATAH_DATA0(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_MWDATAH_DATA0_SHIFT)) & I3C_MWDATAH_DATA0_MASK)

#define I3C_MWDATAH_DATA1_MASK                   (0xFF00U)
#define I3C_MWDATAH_DATA1_SHIFT                  (8U)
/*! DATA1 - Data byte 1
 */
#define I3C_MWDATAH_DATA1(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_MWDATAH_DATA1_SHIFT)) & I3C_MWDATAH_DATA1_MASK)

#define I3C_MWDATAH_END_MASK                     (0x10000U)
#define I3C_MWDATAH_END_SHIFT                    (16U)
/*! END - End of message
 */
#define I3C_MWDATAH_END(x)                       (((uint32_t)(((uint32_t)(x)) << I3C_MWDATAH_END_SHIFT)) & I3C_MWDATAH_END_MASK)
/*! @} */

/*! @name MWDATAHE - Master Write Data Byte End Register */
/*! @{ */

#define I3C_MWDATAHE_DATA0_MASK                  (0xFFU)
#define I3C_MWDATAHE_DATA0_SHIFT                 (0U)
/*! DATA0 - DATA 0
 */
#define I3C_MWDATAHE_DATA0(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_MWDATAHE_DATA0_SHIFT)) & I3C_MWDATAHE_DATA0_MASK)

#define I3C_MWDATAHE_DATA1_MASK                  (0xFF00U)
#define I3C_MWDATAHE_DATA1_SHIFT                 (8U)
/*! DATA1 - DATA 1
 */
#define I3C_MWDATAHE_DATA1(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_MWDATAHE_DATA1_SHIFT)) & I3C_MWDATAHE_DATA1_MASK)
/*! @} */

/*! @name MRDATAB - Master Read Data Byte Register */
/*! @{ */

#define I3C_MRDATAB_VALUE_MASK                   (0xFFU)
#define I3C_MRDATAB_VALUE_SHIFT                  (0U)
/*! VALUE - VALUE
 */
#define I3C_MRDATAB_VALUE(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_MRDATAB_VALUE_SHIFT)) & I3C_MRDATAB_VALUE_MASK)
/*! @} */

/*! @name MRDATAH - Master Read Data Half-word Register */
/*! @{ */

#define I3C_MRDATAH_LSB_MASK                     (0xFFU)
#define I3C_MRDATAH_LSB_SHIFT                    (0U)
/*! LSB - LSB
 */
#define I3C_MRDATAH_LSB(x)                       (((uint32_t)(((uint32_t)(x)) << I3C_MRDATAH_LSB_SHIFT)) & I3C_MRDATAH_LSB_MASK)

#define I3C_MRDATAH_MSB_MASK                     (0xFF00U)
#define I3C_MRDATAH_MSB_SHIFT                    (8U)
/*! MSB - MSB
 */
#define I3C_MRDATAH_MSB(x)                       (((uint32_t)(((uint32_t)(x)) << I3C_MRDATAH_MSB_SHIFT)) & I3C_MRDATAH_MSB_MASK)
/*! @} */

/*! @name MWMSG_SDR_CONTROL - Master Write Message in SDR mode */
/*! @{ */

#define I3C_MWMSG_SDR_CONTROL_DIR_MASK           (0x1U)
#define I3C_MWMSG_SDR_CONTROL_DIR_SHIFT          (0U)
/*! DIR - Direction
 *  0b0..Write
 *  0b1..Read
 */
#define I3C_MWMSG_SDR_CONTROL_DIR(x)             (((uint32_t)(((uint32_t)(x)) << I3C_MWMSG_SDR_CONTROL_DIR_SHIFT)) & I3C_MWMSG_SDR_CONTROL_DIR_MASK)

#define I3C_MWMSG_SDR_CONTROL_ADDR_MASK          (0xFEU)
#define I3C_MWMSG_SDR_CONTROL_ADDR_SHIFT         (1U)
/*! ADDR - Address to be written to
 */
#define I3C_MWMSG_SDR_CONTROL_ADDR(x)            (((uint32_t)(((uint32_t)(x)) << I3C_MWMSG_SDR_CONTROL_ADDR_SHIFT)) & I3C_MWMSG_SDR_CONTROL_ADDR_MASK)

#define I3C_MWMSG_SDR_CONTROL_END_MASK           (0x100U)
#define I3C_MWMSG_SDR_CONTROL_END_SHIFT          (8U)
/*! END - End of SDR message
 */
#define I3C_MWMSG_SDR_CONTROL_END(x)             (((uint32_t)(((uint32_t)(x)) << I3C_MWMSG_SDR_CONTROL_END_SHIFT)) & I3C_MWMSG_SDR_CONTROL_END_MASK)

#define I3C_MWMSG_SDR_CONTROL_I2C_MASK           (0x400U)
#define I3C_MWMSG_SDR_CONTROL_I2C_SHIFT          (10U)
/*! I2C - I2C
 *  0b0..I3C message
 *  0b1..I2C message
 */
#define I3C_MWMSG_SDR_CONTROL_I2C(x)             (((uint32_t)(((uint32_t)(x)) << I3C_MWMSG_SDR_CONTROL_I2C_SHIFT)) & I3C_MWMSG_SDR_CONTROL_I2C_MASK)

#define I3C_MWMSG_SDR_CONTROL_LEN_MASK           (0xF800U)
#define I3C_MWMSG_SDR_CONTROL_LEN_SHIFT          (11U)
/*! LEN - Length
 */
#define I3C_MWMSG_SDR_CONTROL_LEN(x)             (((uint32_t)(((uint32_t)(x)) << I3C_MWMSG_SDR_CONTROL_LEN_SHIFT)) & I3C_MWMSG_SDR_CONTROL_LEN_MASK)
/*! @} */

/*! @name MWMSG_SDR_DATA - Master Write Message Data in SDR mode */
/*! @{ */

#define I3C_MWMSG_SDR_DATA_DATA16B_MASK          (0xFFFFU)
#define I3C_MWMSG_SDR_DATA_DATA16B_SHIFT         (0U)
/*! DATA16B - Data
 */
#define I3C_MWMSG_SDR_DATA_DATA16B(x)            (((uint32_t)(((uint32_t)(x)) << I3C_MWMSG_SDR_DATA_DATA16B_SHIFT)) & I3C_MWMSG_SDR_DATA_DATA16B_MASK)

#define I3C_MWMSG_SDR_DATA_END_MASK              (0x10000U)
#define I3C_MWMSG_SDR_DATA_END_SHIFT             (16U)
/*! END - End of message
 */
#define I3C_MWMSG_SDR_DATA_END(x)                (((uint32_t)(((uint32_t)(x)) << I3C_MWMSG_SDR_DATA_END_SHIFT)) & I3C_MWMSG_SDR_DATA_END_MASK)
/*! @} */

/*! @name MRMSG_SDR - Master Read Message in SDR mode */
/*! @{ */

#define I3C_MRMSG_SDR_DATA_MASK                  (0xFFFFU)
#define I3C_MRMSG_SDR_DATA_SHIFT                 (0U)
/*! DATA - Data
 */
#define I3C_MRMSG_SDR_DATA(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_MRMSG_SDR_DATA_SHIFT)) & I3C_MRMSG_SDR_DATA_MASK)
/*! @} */

/*! @name MWMSG_DDR_CONTROL - Master Write Message in DDR mode */
/*! @{ */

#define I3C_MWMSG_DDR_CONTROL_LEN_MASK           (0x3FFU)
#define I3C_MWMSG_DDR_CONTROL_LEN_SHIFT          (0U)
/*! LEN - Length of message
 */
#define I3C_MWMSG_DDR_CONTROL_LEN(x)             (((uint32_t)(((uint32_t)(x)) << I3C_MWMSG_DDR_CONTROL_LEN_SHIFT)) & I3C_MWMSG_DDR_CONTROL_LEN_MASK)

#define I3C_MWMSG_DDR_CONTROL_END_MASK           (0x4000U)
#define I3C_MWMSG_DDR_CONTROL_END_SHIFT          (14U)
/*! END - End of message
 */
#define I3C_MWMSG_DDR_CONTROL_END(x)             (((uint32_t)(((uint32_t)(x)) << I3C_MWMSG_DDR_CONTROL_END_SHIFT)) & I3C_MWMSG_DDR_CONTROL_END_MASK)
/*! @} */

/*! @name MWMSG_DDR_DATA - Master Write Message Data in DDR mode */
/*! @{ */

#define I3C_MWMSG_DDR_DATA_DATA16B_MASK          (0xFFFFU)
#define I3C_MWMSG_DDR_DATA_DATA16B_SHIFT         (0U)
/*! DATA16B - Data
 */
#define I3C_MWMSG_DDR_DATA_DATA16B(x)            (((uint32_t)(((uint32_t)(x)) << I3C_MWMSG_DDR_DATA_DATA16B_SHIFT)) & I3C_MWMSG_DDR_DATA_DATA16B_MASK)

#define I3C_MWMSG_DDR_DATA_END_MASK              (0x10000U)
#define I3C_MWMSG_DDR_DATA_END_SHIFT             (16U)
/*! END - End of message
 */
#define I3C_MWMSG_DDR_DATA_END(x)                (((uint32_t)(((uint32_t)(x)) << I3C_MWMSG_DDR_DATA_END_SHIFT)) & I3C_MWMSG_DDR_DATA_END_MASK)
/*! @} */

/*! @name MRMSG_DDR - Master Read Message in DDR mode */
/*! @{ */

#define I3C_MRMSG_DDR_DATA_MASK                  (0xFFFFU)
#define I3C_MRMSG_DDR_DATA_SHIFT                 (0U)
/*! DATA - Data
 */
#define I3C_MRMSG_DDR_DATA(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_MRMSG_DDR_DATA_SHIFT)) & I3C_MRMSG_DDR_DATA_MASK)

#define I3C_MRMSG_DDR_CLEN_MASK                  (0x3FF0000U)
#define I3C_MRMSG_DDR_CLEN_SHIFT                 (16U)
/*! CLEN - Current length
 */
#define I3C_MRMSG_DDR_CLEN(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_MRMSG_DDR_CLEN_SHIFT)) & I3C_MRMSG_DDR_CLEN_MASK)
/*! @} */

/*! @name MDYNADDR - Master Dynamic Address Register */
/*! @{ */

#define I3C_MDYNADDR_DAVALID_MASK                (0x1U)
#define I3C_MDYNADDR_DAVALID_SHIFT               (0U)
/*! DAVALID - Dynamic address valid
 */
#define I3C_MDYNADDR_DAVALID(x)                  (((uint32_t)(((uint32_t)(x)) << I3C_MDYNADDR_DAVALID_SHIFT)) & I3C_MDYNADDR_DAVALID_MASK)

#define I3C_MDYNADDR_DADDR_MASK                  (0xFEU)
#define I3C_MDYNADDR_DADDR_SHIFT                 (1U)
/*! DADDR - Dynamic address
 */
#define I3C_MDYNADDR_DADDR(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_MDYNADDR_DADDR_SHIFT)) & I3C_MDYNADDR_DADDR_MASK)
/*! @} */

/*! @name SID - Slave Module ID Register */
/*! @{ */

#define I3C_SID_ID_MASK                          (0xFFFFFFFFU)
#define I3C_SID_ID_SHIFT                         (0U)
/*! ID - ID
 */
#define I3C_SID_ID(x)                            (((uint32_t)(((uint32_t)(x)) << I3C_SID_ID_SHIFT)) & I3C_SID_ID_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group I3C_Register_Masks */


/* I3C - Peripheral instance base addresses */
/** Peripheral I3C base address */
#define I3C_BASE                                 (0x40036000u)
/** Peripheral I3C base pointer */
#define I3C                                      ((I3C_Type *)I3C_BASE)
/** Array initializer of I3C peripheral base addresses */
#define I3C_BASE_ADDRS                           { I3C_BASE }
/** Array initializer of I3C peripheral base pointers */
#define I3C_BASE_PTRS                            { I3C }
/** Interrupt vectors for the I3C peripheral type */
#define I3C_IRQS                                 { I3C0_IRQn }

/*!
 * @}
 */ /* end of group I3C_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- INPUTMUX Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup INPUTMUX_Peripheral_Access_Layer INPUTMUX Peripheral Access Layer
 * @{
 */

/** INPUTMUX - Register Layout Typedef */
typedef struct {
  __IO uint32_t SCT0_IN_SEL[7];                    /**< SCT Peripheral Input Multiplexers N, array offset: 0x0, array step: 0x4 */
       uint8_t RESERVED_0[228];
  __IO uint32_t PINT_SEL[8];                       /**< GPIO Pin Input Multiplexer N, array offset: 0x100, array step: 0x4 */
       uint8_t RESERVED_1[32];
  __IO uint32_t DSP_INT_SEL[27];                   /**< DSP Interrupt Input Multiplexers N, array offset: 0x140, array step: 0x4 */
       uint8_t RESERVED_2[84];
  __IO uint32_t DMAC0_ITRIG_SEL[33];               /**< DMAC0 Input Trigger Multiplexers N, array offset: 0x200, array step: 0x4 */
       uint8_t RESERVED_3[124];
  __IO uint32_t DMAC0_OTRIG_SEL[4];                /**< DMAC0 Output Trigger Multiplexers N, array offset: 0x300, array step: 0x4 */
       uint8_t RESERVED_4[240];
  __IO uint32_t DMAC1_ITRIG_SEL[33];               /**< DMAC1 Input Trigger Multiplexers N, array offset: 0x400, array step: 0x4 */
       uint8_t RESERVED_5[124];
  __IO uint32_t DMAC1_OTRIG_SEL[4];                /**< DMAC1 Output Trigger Multiplexers N, array offset: 0x500, array step: 0x4 */
       uint8_t RESERVED_6[240];
  __IO uint32_t CT32BIT_CAP_SEL[5][4];             /**< CT32BIT N Counter Timer Capture Trigger Multiplexers M, array offset: 0x600, array step: index*0x10, index2*0x4 */
       uint8_t RESERVED_7[176];
  __IO uint32_t FMEASURE_CH_SEL[2];                /**< Frequency Measurement Input Channel Multiplexers, array offset: 0x700, array step: 0x4 */
       uint8_t RESERVED_8[56];
  __IO uint32_t DMAC0_REQ_ENA0;                    /**< DMAC0 request enable 0, offset: 0x740 */
       uint8_t RESERVED_9[4];
  __O  uint32_t DMAC0_REQ_ENA0_SET;                /**< DMAC0 request enable set 0, offset: 0x748 */
       uint8_t RESERVED_10[4];
  __O  uint32_t DMAC0_REQ_ENA0_CLR;                /**< DMAC0 request enable clear 0, offset: 0x750 */
       uint8_t RESERVED_11[12];
  __IO uint32_t DMAC1_REQ_ENA0;                    /**< DMAC1 request enable 0, offset: 0x760 */
       uint8_t RESERVED_12[4];
  __O  uint32_t DMAC1_REQ_ENA0_SET;                /**< DMAC1 request enable set 0, offset: 0x768 */
       uint8_t RESERVED_13[4];
  __O  uint32_t DMAC1_REQ_ENA0_CLR;                /**< DMAC1 request enable clear 0, offset: 0x770 */
       uint8_t RESERVED_14[12];
  __IO uint32_t DMAC0_ITRIG_ENA0;                  /**< DMAC0 input trigger enable 0, offset: 0x780 */
       uint8_t RESERVED_15[4];
  __O  uint32_t DMAC0_ITRIG_ENA0_SET;              /**< DMAC0 input trigger enable set 0, offset: 0x788 */
       uint8_t RESERVED_16[4];
  __O  uint32_t DMAC0_ITRIG_ENA0_CLR;              /**< DMAC0 input trigger enable clear 0, offset: 0x790 */
       uint8_t RESERVED_17[12];
  __IO uint32_t DMAC1_ITRIG_ENA0;                  /**< DMAC1 input trigger enable 0, offset: 0x7A0 */
       uint8_t RESERVED_18[4];
  __O  uint32_t DMAC1_ITRIG_ENA0_SET;              /**< DMAC1 input trigger enable set 0, offset: 0x7A8 */
       uint8_t RESERVED_19[4];
  __O  uint32_t DMAC1_ITRIG_ENA0_CLR;              /**< DMAC1 input trigger enable clear 0, offset: 0x7B0 */
} INPUTMUX_Type;

/* ----------------------------------------------------------------------------
   -- INPUTMUX Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup INPUTMUX_Register_Masks INPUTMUX Register Masks
 * @{
 */

/*! @name SCT0_IN_SEL - SCT Peripheral Input Multiplexers N */
/*! @{ */

#define INPUTMUX_SCT0_IN_SEL_SCT_IN_SEL_MASK     (0x1FU)
#define INPUTMUX_SCT0_IN_SEL_SCT_IN_SEL_SHIFT    (0U)
/*! SCT_IN_SEL - SCT0 Input(n) Selection. 24:1 Selection for each. . .
 *  0b00000..SCT0_PIN_INP0
 *  0b00001..SCT0_PIN_INP1
 *  0b00010..SCT0_PIN_INP2
 *  0b00011..SCT0_PIN_INP3
 *  0b00100..SCT0_PIN_INP4
 *  0b00101..SCT0_PIN_INP5
 *  0b00110..SCT0_PIN_INP6
 *  0b00111..SCT0_PIN_INP7
 *  0b01000..CT32BIT0_MAT0
 *  0b01001..CT32BIT1_MAT0
 *  0b01010..CT32BIT2_MAT0
 *  0b01011..CT32BIT3_MAT0
 *  0b01100..CT32BIT4_MAT0
 *  0b01101..ADCIRQ
 *  0b01110..GPIOINT_BMATCH
 *  0b01111..USB1_FRAME_TOGGLE
 *  0b10000..CMP0_OUT
 *  0b10001..SHARED I2S0_SCLK
 *  0b10010..SHARED I2S1_SCLK
 *  0b10011..SHARED I2S0_WS
 *  0b10100..SHARED I2S1_WS
 *  0b10101..MCLK
 *  0b10110..ARM_TXEV
 *  0b10111..DEBUG_HALTED
 *  0b11000..RESERVED
 *  0b11001..RESERVED
 *  0b11010..RESERVED
 *  0b11011..RESERVED
 *  0b11100..RESERVED
 *  0b11101..RESERVED
 *  0b11110..RESERVED
 *  0b11111..RESERVED
 */
#define INPUTMUX_SCT0_IN_SEL_SCT_IN_SEL(x)       (((uint32_t)(((uint32_t)(x)) << INPUTMUX_SCT0_IN_SEL_SCT_IN_SEL_SHIFT)) & INPUTMUX_SCT0_IN_SEL_SCT_IN_SEL_MASK)
/*! @} */

/* The count of INPUTMUX_SCT0_IN_SEL */
#define INPUTMUX_SCT0_IN_SEL_COUNT               (7U)

/*! @name PINT_SEL - GPIO Pin Input Multiplexer N */
/*! @{ */

#define INPUTMUX_PINT_SEL_PINT_SEL_MASK          (0xFFU)
#define INPUTMUX_PINT_SEL_PINT_SEL_SHIFT         (0U)
/*! PINT_SEL - Port Input (PIOx.y) 64 to 8 Mux Select. . . Pin number select for pin interrupt or
 *    pattern match engine input. (For PIOx_y: INTPIN = (x * 32) + y. PIO0_0 to PIO1_31 correspond to
 *    numbers 0 to 63.
 */
#define INPUTMUX_PINT_SEL_PINT_SEL(x)            (((uint32_t)(((uint32_t)(x)) << INPUTMUX_PINT_SEL_PINT_SEL_SHIFT)) & INPUTMUX_PINT_SEL_PINT_SEL_MASK)
/*! @} */

/* The count of INPUTMUX_PINT_SEL */
#define INPUTMUX_PINT_SEL_COUNT                  (8U)

/*! @name DSP_INT_SEL - DSP Interrupt Input Multiplexers N */
/*! @{ */

#define INPUTMUX_DSP_INT_SEL_DSP_INT_SEL_MASK    (0x3FU)
#define INPUTMUX_DSP_INT_SEL_DSP_INT_SEL_SHIFT   (0U)
/*! DSP_INT_SEL - DSP Input(n) Selection. 34:1 Selection for each. . .
 *  0b000000..FLEXCOMM0
 *  0b000001..FLEXCOMM1
 *  0b000010..FLEXCOMM2
 *  0b000011..FLEXCOMM3
 *  0b000100..FLEXCOMM4
 *  0b000101..FLEXCOMM5
 *  0b000110..FLEXCOMM6
 *  0b000111..FLEXCOMM7
 *  0b001000..GPIO_INT0_IRQ0
 *  0b001001..GPIO_INT0_IRQ1
 *  0b001010..GPIO_INT0_IRQ2
 *  0b001011..GPIO_INT0_IRQ3
 *  0b001100..GPIO_INT0_IRQ4
 *  0b001101..GPIO_INT0_IRQ5
 *  0b001110..GPIO_INT0_IRQ6
 *  0b001111..GPIO_INT0_IRQ7
 *  0b010000..NSHSGPIO_INT0
 *  0b010001..NSHSGPIO_INT1
 *  0b010010..WDT1
 *  0b010011..DMAC0
 *  0b010100..DMAC1
 *  0b010101..MU
 *  0b010110..UTICK0
 *  0b010111..MRT0
 *  0b011000..OS_EVENT_TIMER or OS_EVENT_WAKEUP
 *  0b011001..CT32BIT0
 *  0b011010..CT32BIT1
 *  0b011011..CT32BIT2
 *  0b011100..CT32BIT3
 *  0b011101..CT32BIT4
 *  0b011110..RTC_LITE0_ALARM or RTC_LITE0_WAKEUP
 *  0b011111..I3C0
 *  0b100000..DMIC0
 *  0b100001..HWVAD0
 *  0b100010..FLEXSPI
 *  0b100011..RESERVED
 *  0b100100..RESERVED
 *  0b100101..RESERVED
 *  0b100110..RESERVED
 *  0b100111..RESERVED
 *  0b101000..RESERVED
 *  0b101001..RESERVED
 *  0b101010..RESERVED
 *  0b101011..RESERVED
 *  0b101100..RESERVED
 *  0b101101..RESERVED
 *  0b101110..RESERVED
 *  0b101111..RESERVED
 *  0b110000..RESERVED
 *  0b110001..RESERVED
 *  0b110010..RESERVED
 *  0b110011..RESERVED
 *  0b110100..RESERVED
 *  0b110101..RESERVED
 *  0b110110..RESERVED
 *  0b110111..RESERVED
 *  0b111000..RESERVED
 *  0b111001..RESERVED
 *  0b111010..RESERVED
 *  0b111011..RESERVED
 *  0b111100..RESERVED
 *  0b111101..RESERVED
 *  0b111110..RESERVED
 *  0b111111..RESERVED
 */
#define INPUTMUX_DSP_INT_SEL_DSP_INT_SEL(x)      (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DSP_INT_SEL_DSP_INT_SEL_SHIFT)) & INPUTMUX_DSP_INT_SEL_DSP_INT_SEL_MASK)
/*! @} */

/* The count of INPUTMUX_DSP_INT_SEL */
#define INPUTMUX_DSP_INT_SEL_COUNT               (27U)

/*! @name DMAC0_ITRIG_SEL - DMAC0 Input Trigger Multiplexers N */
/*! @{ */

#define INPUTMUX_DMAC0_ITRIG_SEL_DMA0_ITRIG_SEL_MASK (0x1FU)
#define INPUTMUX_DMAC0_ITRIG_SEL_DMA0_ITRIG_SEL_SHIFT (0U)
/*! DMA0_ITRIG_SEL - DMA Input Triggers(n) Selection. 22:1 Selection for each. . .
 *  0b00000..NSGPIOPINT0_INT0
 *  0b00001..NSGPIOPINT0_INT1
 *  0b00010..NSGPIOPINT0_INT2
 *  0b00011..NSGPIOPINT0_INT3
 *  0b00100..CT32BIT0_DMAREQ_M0
 *  0b00101..CT32BIT0_DMAREQ_M1
 *  0b00110..CT32BIT1_DMAREQ_M0
 *  0b00111..CT32BIT1_DMAREQ_M1
 *  0b01000..CT32BIT2_DMAREQ_M0
 *  0b01001..CT32BIT2_DMAREQ_M1
 *  0b01010..CT32BIT3_DMAREQ_M0
 *  0b01011..CT32BIT3_DMAREQ_M1
 *  0b01100..CT32BIT4_DMAREQ_M0
 *  0b01101..CT32BIT4_DMAREQ_M1
 *  0b01110..DMAC0_TRIGOUT_A
 *  0b01111..DMAC0_TRIGOUT_B
 *  0b10000..DMAC0_TRIGOUT_C
 *  0b10001..DMAC0_TRIGOUT_D
 *  0b10010..SCT0_DMA0
 *  0b10011..SCT0_DMA1
 *  0b10100..HASHCRYPT_OUT_DMA
 *  0b10101..ACMP_DMA
 *  0b10110..RESERVED16
 *  0b10111..RESERVED17
 *  0b11000..ADC_DMAC
 *  0b11001..RESERVED
 *  0b11010..RESERVED
 *  0b11011..RESERVED
 *  0b11100..FLEXSPI_RX
 *  0b11101..FLEXSPI_TX
 *  0b11110..RESERVED
 *  0b11111..RESERVED
 */
#define INPUTMUX_DMAC0_ITRIG_SEL_DMA0_ITRIG_SEL(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_SEL_DMA0_ITRIG_SEL_SHIFT)) & INPUTMUX_DMAC0_ITRIG_SEL_DMA0_ITRIG_SEL_MASK)
/*! @} */

/* The count of INPUTMUX_DMAC0_ITRIG_SEL */
#define INPUTMUX_DMAC0_ITRIG_SEL_COUNT           (33U)

/*! @name DMAC0_OTRIG_SEL - DMAC0 Output Trigger Multiplexers N */
/*! @{ */

#define INPUTMUX_DMAC0_OTRIG_SEL_DMAC0_OTRIG_SEL_MASK (0x3FU)
#define INPUTMUX_DMAC0_OTRIG_SEL_DMAC0_OTRIG_SEL_SHIFT (0U)
/*! DMAC0_OTRIG_SEL - DMAC0 Output Triggers Select for A, B, C, D IE.,DMAC0_OTRIG_A, DMAC0_OTRIG_B,
 *    DMAC0_OTRIG_C, DMAC0_OTRIG_D DMA0 Output Triggers(n) Selection. 32:1 Selection for each. . .
 *  0b000000..DMAC0_OTRIG_CH0
 *  0b000001..DMAC0_OTRIG_CH1
 *  0b000010..DMAC0_OTRIG_CH2
 *  0b000011..DMAC0_OTRIG_CH3
 *  0b000100..DMAC0_OTRIG_CH4
 *  0b000101..DMAC0_OTRIG_CH5
 *  0b000110..DMAC0_OTRIG_CH6
 *  0b000111..DMAC0_OTRIG_CH7
 *  0b001000..DMAC0_OTRIG_CH8
 *  0b001001..DMAC0_OTRIG_CH9
 *  0b001010..DMAC0_OTRIG_CH10
 *  0b001011..DMAC0_OTRIG_CH11
 *  0b001100..DMAC0_OTRIG_CH12
 *  0b001101..DMAC0_OTRIG_CH13
 *  0b001110..DMAC0_OTRIG_CH14
 *  0b001111..DMAC0_OTRIG_CH15
 *  0b010000..DMAC0_OTRIG_CH16
 *  0b010001..DMAC0_OTRIG_CH17
 *  0b010010..DMAC0_OTRIG_CH18
 *  0b010011..DMAC0_OTRIG_CH19
 *  0b010100..DMAC0_OTRIG_CH20
 *  0b010101..DMAC0_OTRIG_CH21
 *  0b010110..DMAC0_OTRIG_CH22
 *  0b010111..DMAC0_OTRIG_CH23
 *  0b011000..DMAC0_OTRIG_CH24
 *  0b011001..DMAC0_OTRIG_CH25
 *  0b011010..DMAC0_OTRIG_CH26
 *  0b011011..DMAC0_OTRIG_CH27
 *  0b011100..DMAC0_OTRIG_CH28
 *  0b011101..DMAC0_OTRIG_CH29
 *  0b011110..DMAC0_OTRIG_CH30
 *  0b011111..DMAC0_OTRIG_CH31
 *  0b100000..DMAC0_OTRIG_CH32
 */
#define INPUTMUX_DMAC0_OTRIG_SEL_DMAC0_OTRIG_SEL(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_OTRIG_SEL_DMAC0_OTRIG_SEL_SHIFT)) & INPUTMUX_DMAC0_OTRIG_SEL_DMAC0_OTRIG_SEL_MASK)
/*! @} */

/* The count of INPUTMUX_DMAC0_OTRIG_SEL */
#define INPUTMUX_DMAC0_OTRIG_SEL_COUNT           (4U)

/*! @name DMAC1_ITRIG_SEL - DMAC1 Input Trigger Multiplexers N */
/*! @{ */

#define INPUTMUX_DMAC1_ITRIG_SEL_DMA1_ITRIG_SEL_MASK (0x1FU)
#define INPUTMUX_DMAC1_ITRIG_SEL_DMA1_ITRIG_SEL_SHIFT (0U)
/*! DMA1_ITRIG_SEL - DMA Input Triggers(n) Selection. 18:1 Selection for each. . .
 *  0b00000..NSGPIOPINT0_INT0
 *  0b00001..NSGPIOPINT0_INT1
 *  0b00010..NSGPIOPINT0_INT2
 *  0b00011..NSGPIOPINT0_INT3
 *  0b00100..CT32BIT0_DMAREQ_M0
 *  0b00101..CT32BIT0_DMAREQ_M1
 *  0b00110..CT32BIT1_DMAREQ_M0
 *  0b00111..CT32BIT1_DMAREQ_M1
 *  0b01000..CT32BIT2_DMAREQ_M0
 *  0b01001..CT32BIT2_DMAREQ_M1
 *  0b01010..CT32BIT3_DMAREQ_M0
 *  0b01011..CT32BIT3_DMAREQ_M1
 *  0b01100..CT32BIT4_DMAREQ_M0
 *  0b01101..CT32BIT4_DMAREQ_M1
 *  0b01110..DMAC1_TRIGOUT_A
 *  0b01111..DMAC1_TRIGOUT_B
 *  0b10000..DMAC1_TRIGOUT_C
 *  0b10001..DMAC0_TRIGOUT_D
 *  0b10010..SCT0_DMAC0
 *  0b10011..SCT0_DMAC1
 *  0b10100..HASHCRYPT_OUT_DMA
 *  0b10101..ACMP_DMA
 *  0b10110..RESERVED16
 *  0b10111..RESERVED17
 *  0b11000..ADC_DMAC
 *  0b11001..RESERVED
 *  0b11010..RESERVED
 *  0b11011..RESERVED
 *  0b11100..FLEXSPI_RX
 *  0b11101..FLEXSPI_TX
 *  0b11110..RESERVED
 *  0b11111..RESERVED
 */
#define INPUTMUX_DMAC1_ITRIG_SEL_DMA1_ITRIG_SEL(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_SEL_DMA1_ITRIG_SEL_SHIFT)) & INPUTMUX_DMAC1_ITRIG_SEL_DMA1_ITRIG_SEL_MASK)
/*! @} */

/* The count of INPUTMUX_DMAC1_ITRIG_SEL */
#define INPUTMUX_DMAC1_ITRIG_SEL_COUNT           (33U)

/*! @name DMAC1_OTRIG_SEL - DMAC1 Output Trigger Multiplexers N */
/*! @{ */

#define INPUTMUX_DMAC1_OTRIG_SEL_DMAC1_OTRIG_SEL_MASK (0x3FU)
#define INPUTMUX_DMAC1_OTRIG_SEL_DMAC1_OTRIG_SEL_SHIFT (0U)
/*! DMAC1_OTRIG_SEL - DMA1 Output Triggers Select for A, B, C, D IE., DMA1_OTRIG_A, DMA1_OTRIG_B,
 *    DM1_OTRIG_C, DMA1_OTRIG_D DMA0 Output Triggers(n) Selection. 32:1 Selection for each. . .
 *  0b000000..DMAC1_OTRIG_CH0
 *  0b000001..DMAC1_OTRIG_CH1
 *  0b000010..DMAC1_OTRIG_CH2
 *  0b000011..DMAC1_OTRIG_CH3
 *  0b000100..DMAC1_OTRIG_CH4
 *  0b000101..DMAC1_OTRIG_CH5
 *  0b000110..DMAC1_OTRIG_CH6
 *  0b000111..DMAC1_OTRIG_CH7
 *  0b001000..DMAC1_OTRIG_CH8
 *  0b001001..DMAC1_OTRIG_CH9
 *  0b001010..DMAC1_OTRIG_CH10
 *  0b001011..DMAC1_OTRIG_CH11
 *  0b001100..DMAC1_OTRIG_CH12
 *  0b001101..DMAC1_OTRIG_CH13
 *  0b001110..DMAC1_OTRIG_CH14
 *  0b001111..DMAC1_OTRIG_CH15
 *  0b010000..DMAC1_OTRIG_CH16
 *  0b010001..DMAC1_OTRIG_CH17
 *  0b010010..DMAC1_OTRIG_CH18
 *  0b010011..DMAC1_OTRIG_CH19
 *  0b010100..DMAC1_OTRIG_CH20
 *  0b010101..DMAC1_OTRIG_CH21
 *  0b010110..DMAC1_OTRIG_CH22
 *  0b010111..DMAC1_OTRIG_CH23
 *  0b011000..DMAC1_OTRIG_CH24
 *  0b011001..DMAC1_OTRIG_CH25
 *  0b011010..DMAC1_OTRIG_CH26
 *  0b011011..DMAC1_OTRIG_CH27
 *  0b011100..DMAC1_OTRIG_CH28
 *  0b011101..DMAC1_OTRIG_CH29
 *  0b011110..DMAC1_OTRIG_CH30
 *  0b011111..DMAC1_OTRIG_CH31
 *  0b100000..DMAC1_OTRIG_CH32
 */
#define INPUTMUX_DMAC1_OTRIG_SEL_DMAC1_OTRIG_SEL(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_OTRIG_SEL_DMAC1_OTRIG_SEL_SHIFT)) & INPUTMUX_DMAC1_OTRIG_SEL_DMAC1_OTRIG_SEL_MASK)
/*! @} */

/* The count of INPUTMUX_DMAC1_OTRIG_SEL */
#define INPUTMUX_DMAC1_OTRIG_SEL_COUNT           (4U)

/*! @name CT32BITN_CAPM_SEL_CT32BIT_CAP_SEL - CT32BIT N Counter Timer Capture Trigger Multiplexers M */
/*! @{ */

#define INPUTMUX_CT32BITN_CAPM_SEL_CT32BIT_CAP_SEL_CAPn_SEL_MASK (0x1FU)
#define INPUTMUX_CT32BITN_CAPM_SEL_CT32BIT_CAP_SEL_CAPn_SEL_SHIFT (0U)
/*! CAPn_SEL - Counter Timer m, Capture Port Input n 19:1 Mux Select. . .
 *  0b00000..CT_INP0
 *  0b00001..CT_INP1
 *  0b00010..CT_INP2
 *  0b00011..CT_INP3
 *  0b00100..CT_INP4
 *  0b00101..CT_INP5
 *  0b00110..CT_INP6
 *  0b00111..CT_INP7
 *  0b01000..CT_INP8
 *  0b01001..CT_INP9
 *  0b01010..CT_INP10
 *  0b01011..CT_INP11
 *  0b01100..CT_INP12
 *  0b01101..CT_INP13
 *  0b01110..CT_INP14
 *  0b01111..CT_INP15
 *  0b10000..SHARED I2S0_WS
 *  0b10001..SHARED I2S1_WS
 *  0b10010..USB1_FRAME_TOGGLE
 *  0b10011..RESERVED
 *  0b10100..RESERVED
 *  0b10101..RESERVED
 *  0b10110..RESERVED
 *  0b10111..RESERVED
 *  0b11000..RESERVED
 *  0b11001..RESERVED
 *  0b11010..RESERVED
 *  0b11011..RESERVED
 *  0b11100..RESERVED
 *  0b11101..RESERVED
 *  0b11110..RESERVED
 *  0b11111..RESERVED
 */
#define INPUTMUX_CT32BITN_CAPM_SEL_CT32BIT_CAP_SEL_CAPn_SEL(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_CT32BITN_CAPM_SEL_CT32BIT_CAP_SEL_CAPn_SEL_SHIFT)) & INPUTMUX_CT32BITN_CAPM_SEL_CT32BIT_CAP_SEL_CAPn_SEL_MASK)
/*! @} */

/* The count of INPUTMUX_CT32BITN_CAPM_SEL_CT32BIT_CAP_SEL */
#define INPUTMUX_CT32BITN_CAPM_SEL_CT32BIT_CAP_SEL_COUNT (5U)

/* The count of INPUTMUX_CT32BITN_CAPM_SEL_CT32BIT_CAP_SEL */
#define INPUTMUX_CT32BITN_CAPM_SEL_CT32BIT_CAP_SEL_COUNT2 (4U)

/*! @name FMEASURE_CH_SEL - Frequency Measurement Input Channel Multiplexers */
/*! @{ */

#define INPUTMUX_FMEASURE_CH_SEL_FMEASURE_SEL_MASK (0x1FU)
#define INPUTMUX_FMEASURE_CH_SEL_FMEASURE_SEL_SHIFT (0U)
/*! FMEASURE_SEL - Frequency Measure Channel n Selection 7:1 Mux Select. . .
 *  0b00000..XTALIN
 *  0b00001..SFRO
 *  0b00010..FFRO
 *  0b00011..Low Power Oscillator Clock (LPOSC)
 *  0b00100..RTC 32KHz OSC
 *  0b00101..MAIN_SYS_CLOCK
 *  0b00110..FREQME_GPIO_CLK
 *  0b00111..RESERVED
 *  0b01000..RESERVED
 *  0b01001..RESERVED
 *  0b01010..RESERVED
 *  0b01011..RESERVED
 *  0b01100..RESERVED
 *  0b01101..RESERVED
 *  0b01110..RESERVED
 *  0b01111..RESERVED
 *  0b10000..RESERVED
 *  0b10001..RESERVED
 *  0b10010..RESERVED
 *  0b10011..RESERVED
 *  0b10100..RESERVED
 *  0b10101..RESERVED
 *  0b10110..RESERVED
 *  0b10111..RESERVED
 *  0b11000..RESERVED
 *  0b11001..RESERVED
 *  0b11010..RESERVED
 *  0b11011..RESERVED
 *  0b11100..RESERVED
 *  0b11101..RESERVED
 *  0b11110..RESERVED
 *  0b11111..RESERVED
 */
#define INPUTMUX_FMEASURE_CH_SEL_FMEASURE_SEL(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_FMEASURE_CH_SEL_FMEASURE_SEL_SHIFT)) & INPUTMUX_FMEASURE_CH_SEL_FMEASURE_SEL_MASK)
/*! @} */

/* The count of INPUTMUX_FMEASURE_CH_SEL */
#define INPUTMUX_FMEASURE_CH_SEL_COUNT           (2U)

/*! @name DMAC0_REQ_ENA0 - DMAC0 request enable 0 */
/*! @{ */

#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM0_RX_MASK (0x1U)
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM0_RX_SHIFT (0U)
/*! FLEXCOMM0_RX - FLEXCOMM0 RX enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM0_RX(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM0_RX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM0_RX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM0_TX_MASK (0x2U)
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM0_TX_SHIFT (1U)
/*! FLEXCOMM0_TX - FLEXCOMM0 TX enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM0_TX(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM0_TX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM0_TX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM1_RX_MASK (0x4U)
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM1_RX_SHIFT (2U)
/*! FLEXCOMM1_RX - FLEXCOMM1 RX enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM1_RX(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM1_RX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM1_RX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM1_TX_MASK (0x8U)
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM1_TX_SHIFT (3U)
/*! FLEXCOMM1_TX - FLEXCOMM1 TX enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM1_TX(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM1_TX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM1_TX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM2_RX_MASK (0x10U)
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM2_RX_SHIFT (4U)
/*! FLEXCOMM2_RX - FLEXCOMM2 RX enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM2_RX(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM2_RX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM2_RX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM2_TX_MASK (0x20U)
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM2_TX_SHIFT (5U)
/*! FLEXCOMM2_TX - FLEXCOMM2 TX enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM2_TX(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM2_TX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM2_TX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM3_RX_MASK (0x40U)
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM3_RX_SHIFT (6U)
/*! FLEXCOMM3_RX - FLEXCOMM3 RX enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM3_RX(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM3_RX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM3_RX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM3_TX_MASK (0x80U)
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM3_TX_SHIFT (7U)
/*! FLEXCOMM3_TX - FLEXCOMM3 TX enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM3_TX(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM3_TX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM3_TX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM4_RX_MASK (0x100U)
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM4_RX_SHIFT (8U)
/*! FLEXCOMM4_RX - FLEXCOMM4 RX enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM4_RX(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM4_RX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM4_RX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM4_TX_MASK (0x200U)
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM4_TX_SHIFT (9U)
/*! FLEXCOMM4_TX - FLEXCOMM4 TX enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM4_TX(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM4_TX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM4_TX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM5_RX_MASK (0x400U)
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM5_RX_SHIFT (10U)
/*! FLEXCOMM5_RX - FLEXCOMM5 RX enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM5_RX(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM5_RX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM5_RX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM5_TX_MASK (0x800U)
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM5_TX_SHIFT (11U)
/*! FLEXCOMM5_TX - FLEXCOMM5 TX enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM5_TX(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM5_TX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM5_TX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM6_RX_MASK (0x1000U)
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM6_RX_SHIFT (12U)
/*! FLEXCOMM6_RX - FLEXCOMM6 RX enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM6_RX(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM6_RX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM6_RX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM6_TX_MASK (0x2000U)
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM6_TX_SHIFT (13U)
/*! FLEXCOMM6_TX - FLEXCOMM6 TX enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM6_TX(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM6_TX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM6_TX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM7_RX_MASK (0x4000U)
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM7_RX_SHIFT (14U)
/*! FLEXCOMM7_RX - FLEXCOMM7 RX enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM7_RX(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM7_RX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM7_RX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM7_TX_MASK (0x8000U)
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM7_TX_SHIFT (15U)
/*! FLEXCOMM7_TX - FLEXCOMM7 TX enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM7_TX(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM7_TX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM7_TX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_DMIC0CH0_MASK    (0x10000U)
#define INPUTMUX_DMAC0_REQ_ENA0_DMIC0CH0_SHIFT   (16U)
/*! DMIC0CH0 - DMIC0 channel 0 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_REQ_ENA0_DMIC0CH0(x)      (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_DMIC0CH0_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_DMIC0CH0_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_DMIC0CH1_MASK    (0x20000U)
#define INPUTMUX_DMAC0_REQ_ENA0_DMIC0CH1_SHIFT   (17U)
/*! DMIC0CH1 - DMIC0 channel 1 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_REQ_ENA0_DMIC0CH1(x)      (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_DMIC0CH1_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_DMIC0CH1_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_DMIC0CH2_MASK    (0x40000U)
#define INPUTMUX_DMAC0_REQ_ENA0_DMIC0CH2_SHIFT   (18U)
/*! DMIC0CH2 - DMIC0 channel 2 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_REQ_ENA0_DMIC0CH2(x)      (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_DMIC0CH2_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_DMIC0CH2_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_DMIC0CH3_MASK    (0x80000U)
#define INPUTMUX_DMAC0_REQ_ENA0_DMIC0CH3_SHIFT   (19U)
/*! DMIC0CH3 - DMIC0 channel 3 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_REQ_ENA0_DMIC0CH3(x)      (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_DMIC0CH3_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_DMIC0CH3_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_DMIC0CH4_MASK    (0x100000U)
#define INPUTMUX_DMAC0_REQ_ENA0_DMIC0CH4_SHIFT   (20U)
/*! DMIC0CH4 - DMIC0 channel 4 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_REQ_ENA0_DMIC0CH4(x)      (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_DMIC0CH4_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_DMIC0CH4_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_DMIC0CH5_MASK    (0x200000U)
#define INPUTMUX_DMAC0_REQ_ENA0_DMIC0CH5_SHIFT   (21U)
/*! DMIC0CH5 - DMIC0 channel 5 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_REQ_ENA0_DMIC0CH5(x)      (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_DMIC0CH5_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_DMIC0CH5_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_DMIC0CH6_MASK    (0x400000U)
#define INPUTMUX_DMAC0_REQ_ENA0_DMIC0CH6_SHIFT   (22U)
/*! DMIC0CH6 - DMIC0 channel 6 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_REQ_ENA0_DMIC0CH6(x)      (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_DMIC0CH6_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_DMIC0CH6_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_DMIC0CH7_MASK    (0x800000U)
#define INPUTMUX_DMAC0_REQ_ENA0_DMIC0CH7_SHIFT   (23U)
/*! DMIC0CH7 - DMIC0 channel 7 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_REQ_ENA0_DMIC0CH7(x)      (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_DMIC0CH7_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_DMIC0CH7_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_I3C0_RX_MASK     (0x1000000U)
#define INPUTMUX_DMAC0_REQ_ENA0_I3C0_RX_SHIFT    (24U)
/*! I3C0_RX - I3C RX enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_REQ_ENA0_I3C0_RX(x)       (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_I3C0_RX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_I3C0_RX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_I3C0_TX_MASK     (0x2000000U)
#define INPUTMUX_DMAC0_REQ_ENA0_I3C0_TX_SHIFT    (25U)
/*! I3C0_TX - I3C TX enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_REQ_ENA0_I3C0_TX(x)       (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_I3C0_TX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_I3C0_TX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM14_RX_MASK (0x4000000U)
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM14_RX_SHIFT (26U)
/*! FLEXCOMM14_RX - FLEXCOMM14 RX enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM14_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM14_RX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM14_RX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM14_TX_MASK (0x8000000U)
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM14_TX_SHIFT (27U)
/*! FLEXCOMM14_TX - FLEXCOMM14 TX enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM14_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM14_TX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_FLEXCOMM14_TX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_HASHCRYPT_MASK   (0x40000000U)
#define INPUTMUX_DMAC0_REQ_ENA0_HASHCRYPT_SHIFT  (30U)
/*! HASHCRYPT - hash enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_REQ_ENA0_HASHCRYPT(x)     (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_HASHCRYPT_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_HASHCRYPT_MASK)
/*! @} */

/*! @name DMAC0_REQ_ENA0_SET - DMAC0 request enable set 0 */
/*! @{ */

#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM0_RX_MASK (0x1U)
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM0_RX_SHIFT (0U)
/*! FLEXCOMM0_RX - FLEXCOMM0 RX enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM0_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM0_RX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM0_RX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM0_TX_MASK (0x2U)
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM0_TX_SHIFT (1U)
/*! FLEXCOMM0_TX - FLEXCOMM0 TX enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM0_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM0_TX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM0_TX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM1_RX_MASK (0x4U)
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM1_RX_SHIFT (2U)
/*! FLEXCOMM1_RX - FLEXCOMM1 RX enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM1_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM1_RX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM1_RX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM1_TX_MASK (0x8U)
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM1_TX_SHIFT (3U)
/*! FLEXCOMM1_TX - FLEXCOMM1 TX enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM1_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM1_TX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM1_TX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM2_RX_MASK (0x10U)
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM2_RX_SHIFT (4U)
/*! FLEXCOMM2_RX - FLEXCOMM2 RX enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM2_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM2_RX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM2_RX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM2_TX_MASK (0x20U)
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM2_TX_SHIFT (5U)
/*! FLEXCOMM2_TX - FLEXCOMM2 TX enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM2_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM2_TX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM2_TX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM3_RX_MASK (0x40U)
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM3_RX_SHIFT (6U)
/*! FLEXCOMM3_RX - FLEXCOMM3 RX enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM3_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM3_RX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM3_RX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM3_TX_MASK (0x80U)
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM3_TX_SHIFT (7U)
/*! FLEXCOMM3_TX - FLEXCOMM3 TX enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM3_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM3_TX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM3_TX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM4_RX_MASK (0x100U)
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM4_RX_SHIFT (8U)
/*! FLEXCOMM4_RX - FLEXCOMM4 RX enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM4_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM4_RX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM4_RX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM4_TX_MASK (0x200U)
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM4_TX_SHIFT (9U)
/*! FLEXCOMM4_TX - FLEXCOMM4 TX enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM4_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM4_TX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM4_TX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM5_RX_MASK (0x400U)
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM5_RX_SHIFT (10U)
/*! FLEXCOMM5_RX - FLEXCOMM5 RX enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM5_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM5_RX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM5_RX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM5_TX_MASK (0x800U)
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM5_TX_SHIFT (11U)
/*! FLEXCOMM5_TX - FLEXCOMM5 TX enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM5_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM5_TX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM5_TX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM6_RX_MASK (0x1000U)
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM6_RX_SHIFT (12U)
/*! FLEXCOMM6_RX - FLEXCOMM6 RX enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM6_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM6_RX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM6_RX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM6_TX_MASK (0x2000U)
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM6_TX_SHIFT (13U)
/*! FLEXCOMM6_TX - FLEXCOMM6 TX enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM6_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM6_TX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM6_TX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM7_RX_MASK (0x4000U)
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM7_RX_SHIFT (14U)
/*! FLEXCOMM7_RX - FLEXCOMM7 RX enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM7_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM7_RX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM7_RX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM7_TX_MASK (0x8000U)
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM7_TX_SHIFT (15U)
/*! FLEXCOMM7_TX - FLEXCOMM7 TX enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM7_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM7_TX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM7_TX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0CH0_MASK (0x10000U)
#define INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0CH0_SHIFT (16U)
/*! DMIC0CH0 - DMIC0 channel 0 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0CH0(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0CH0_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0CH0_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0CH1_MASK (0x20000U)
#define INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0CH1_SHIFT (17U)
/*! DMIC0CH1 - DMIC0 channel 1 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0CH1(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0CH1_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0CH1_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0CH2_MASK (0x40000U)
#define INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0CH2_SHIFT (18U)
/*! DMIC0CH2 - DMIC0 channel 2 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0CH2(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0CH2_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0CH2_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0CH3_MASK (0x80000U)
#define INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0CH3_SHIFT (19U)
/*! DMIC0CH3 - DMIC0 channel 3 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0CH3(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0CH3_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0CH3_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0CH4_MASK (0x100000U)
#define INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0CH4_SHIFT (20U)
/*! DMIC0CH4 - DMIC0 channel 4 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0CH4(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0CH4_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0CH4_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0CH5_MASK (0x200000U)
#define INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0CH5_SHIFT (21U)
/*! DMIC0CH5 - DMIC0 channel 5 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0CH5(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0CH5_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0CH5_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0CH6_MASK (0x400000U)
#define INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0CH6_SHIFT (22U)
/*! DMIC0CH6 - DMIC0 channel 6 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0CH6(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0CH6_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0CH6_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0CH7_MASK (0x800000U)
#define INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0CH7_SHIFT (23U)
/*! DMIC0CH7 - DMIC0 channel 7 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0CH7(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0CH7_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_SET_DMIC0CH7_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_SET_I3C0_RX_MASK (0x1000000U)
#define INPUTMUX_DMAC0_REQ_ENA0_SET_I3C0_RX_SHIFT (24U)
/*! I3C0_RX - I3C RX enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_SET_I3C0_RX(x)   (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_SET_I3C0_RX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_SET_I3C0_RX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_SET_I3C0_TX_MASK (0x2000000U)
#define INPUTMUX_DMAC0_REQ_ENA0_SET_I3C0_TX_SHIFT (25U)
/*! I3C0_TX - I3C TX enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_SET_I3C0_TX(x)   (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_SET_I3C0_TX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_SET_I3C0_TX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM14_RX_MASK (0x4000000U)
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM14_RX_SHIFT (26U)
/*! FLEXCOMM14_RX - FLEXCOMM14 TX enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM14_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM14_RX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM14_RX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM14_TX_MASK (0x8000000U)
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM14_TX_SHIFT (27U)
/*! FLEXCOMM14_TX - FLEXCOMM15 RX enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM14_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM14_TX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_SET_FLEXCOMM14_TX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_SET_HASHCRYPT_MASK (0x40000000U)
#define INPUTMUX_DMAC0_REQ_ENA0_SET_HASHCRYPT_SHIFT (30U)
/*! HASHCRYPT - Hash enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_SET_HASHCRYPT(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_SET_HASHCRYPT_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_SET_HASHCRYPT_MASK)
/*! @} */

/*! @name DMAC0_REQ_ENA0_CLR - DMAC0 request enable clear 0 */
/*! @{ */

#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM0_RX_MASK (0x1U)
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM0_RX_SHIFT (0U)
/*! FLEXCOMM0_RX - FLEXCOMM0 RX enable clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM0_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM0_RX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM0_RX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM0_TX_MASK (0x2U)
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM0_TX_SHIFT (1U)
/*! FLEXCOMM0_TX - FLEXCOMM0 TX enable clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM0_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM0_TX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM0_TX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM1_RX_MASK (0x4U)
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM1_RX_SHIFT (2U)
/*! FLEXCOMM1_RX - FLEXCOMM1 RX enable clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM1_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM1_RX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM1_RX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM1_TX_MASK (0x8U)
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM1_TX_SHIFT (3U)
/*! FLEXCOMM1_TX - FLEXCOMM1 TX enable clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM1_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM1_TX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM1_TX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM2_RX_MASK (0x10U)
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM2_RX_SHIFT (4U)
/*! FLEXCOMM2_RX - FLEXCOMM2 RX enable clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM2_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM2_RX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM2_RX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM2_TX_MASK (0x20U)
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM2_TX_SHIFT (5U)
/*! FLEXCOMM2_TX - FLEXCOMM2 TX enable clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM2_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM2_TX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM2_TX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM3_RX_MASK (0x40U)
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM3_RX_SHIFT (6U)
/*! FLEXCOMM3_RX - FLEXCOMM3 RX enable clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM3_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM3_RX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM3_RX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM3_TX_MASK (0x80U)
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM3_TX_SHIFT (7U)
/*! FLEXCOMM3_TX - FLEXCOMM3 TX enable clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM3_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM3_TX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM3_TX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM4_RX_MASK (0x100U)
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM4_RX_SHIFT (8U)
/*! FLEXCOMM4_RX - FLEXCOMM4 RX enable clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM4_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM4_RX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM4_RX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM4_TX_MASK (0x200U)
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM4_TX_SHIFT (9U)
/*! FLEXCOMM4_TX - FLEXCOMM4 TX enable clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM4_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM4_TX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM4_TX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM5_RX_MASK (0x400U)
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM5_RX_SHIFT (10U)
/*! FLEXCOMM5_RX - FLEXCOMM5 RX enable clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM5_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM5_RX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM5_RX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM5_TX_MASK (0x800U)
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM5_TX_SHIFT (11U)
/*! FLEXCOMM5_TX - FLEXCOMM5 TX enable clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM5_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM5_TX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM5_TX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM6_RX_MASK (0x1000U)
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM6_RX_SHIFT (12U)
/*! FLEXCOMM6_RX - FLEXCOMM6 RX enable clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM6_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM6_RX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM6_RX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM6_TX_MASK (0x2000U)
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM6_TX_SHIFT (13U)
/*! FLEXCOMM6_TX - FLEXCOMM6 TX enable clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM6_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM6_TX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM6_TX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM7_RX_MASK (0x4000U)
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM7_RX_SHIFT (14U)
/*! FLEXCOMM7_RX - FLEXCOMM7 RX enable clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM7_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM7_RX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM7_RX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM7_TX_MASK (0x8000U)
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM7_TX_SHIFT (15U)
/*! FLEXCOMM7_TX - FLEXCOMM7 TX enable clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM7_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM7_TX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM7_TX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0CH0_MASK (0x10000U)
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0CH0_SHIFT (16U)
/*! DMIC0CH0 - DMIC0 channel 0 enable clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0CH0(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0CH0_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0CH0_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0CH1_MASK (0x20000U)
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0CH1_SHIFT (17U)
/*! DMIC0CH1 - DMIC0 channel 1 enable clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0CH1(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0CH1_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0CH1_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0CH2_MASK (0x40000U)
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0CH2_SHIFT (18U)
/*! DMIC0CH2 - DMIC0 channel 2 enable clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0CH2(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0CH2_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0CH2_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0CH3_MASK (0x80000U)
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0CH3_SHIFT (19U)
/*! DMIC0CH3 - DMIC0 channel 3 enable clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0CH3(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0CH3_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0CH3_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0CH4_MASK (0x100000U)
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0CH4_SHIFT (20U)
/*! DMIC0CH4 - DMIC0 channel 4 enable clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0CH4(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0CH4_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0CH4_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0CH5_MASK (0x200000U)
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0CH5_SHIFT (21U)
/*! DMIC0CH5 - DMIC0 channel 5 enable clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0CH5(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0CH5_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0CH5_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0CH6_MASK (0x400000U)
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0CH6_SHIFT (22U)
/*! DMIC0CH6 - DMIC0 channel 6 enable clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0CH6(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0CH6_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0CH6_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0CH7_MASK (0x800000U)
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0CH7_SHIFT (23U)
/*! DMIC0CH7 - DMIC0 channel 7 enable clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0CH7(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0CH7_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_CLR_DMIC0CH7_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_CLR_I3C0_RX_MASK (0x1000000U)
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_I3C0_RX_SHIFT (24U)
/*! I3C0_RX - I3C RX enable clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_I3C0_RX(x)   (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_CLR_I3C0_RX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_CLR_I3C0_RX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_CLR_I3C0_TX_MASK (0x2000000U)
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_I3C0_TX_SHIFT (25U)
/*! I3C0_TX - I3C TX enable clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_I3C0_TX(x)   (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_CLR_I3C0_TX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_CLR_I3C0_TX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM14_RX_MASK (0x4000000U)
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM14_RX_SHIFT (26U)
/*! FLEXCOMM14_RX - FLEXCOMM14 RX enable clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM14_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM14_RX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM14_RX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM14_TX_MASK (0x8000000U)
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM14_TX_SHIFT (27U)
/*! FLEXCOMM14_TX - FLEXCOMM14 TX enable clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM14_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM14_TX_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_CLR_FLEXCOMM14_TX_MASK)

#define INPUTMUX_DMAC0_REQ_ENA0_CLR_HASHCRYPT_MASK (0x40000000U)
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_HASHCRYPT_SHIFT (30U)
/*! HASHCRYPT - Hash enable clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_REQ_ENA0_CLR_HASHCRYPT(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_REQ_ENA0_CLR_HASHCRYPT_SHIFT)) & INPUTMUX_DMAC0_REQ_ENA0_CLR_HASHCRYPT_MASK)
/*! @} */

/*! @name DMAC1_REQ_ENA0 - DMAC1 request enable 0 */
/*! @{ */

#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM0_RX_MASK (0x1U)
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM0_RX_SHIFT (0U)
/*! FLEXCOMM0_RX - FLEXCOMM0 RX enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM0_RX(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM0_RX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM0_RX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM0_TX_MASK (0x2U)
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM0_TX_SHIFT (1U)
/*! FLEXCOMM0_TX - FLEXCOMM0 TX enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM0_TX(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM0_TX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM0_TX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM1_RX_MASK (0x4U)
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM1_RX_SHIFT (2U)
/*! FLEXCOMM1_RX - FLEXCOMM1 RX enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM1_RX(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM1_RX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM1_RX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM1_TX_MASK (0x8U)
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM1_TX_SHIFT (3U)
/*! FLEXCOMM1_TX - FLEXCOMM1 TX enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM1_TX(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM1_TX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM1_TX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM2_RX_MASK (0x10U)
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM2_RX_SHIFT (4U)
/*! FLEXCOMM2_RX - FLEXCOMM2 RX enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM2_RX(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM2_RX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM2_RX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM2_TX_MASK (0x20U)
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM2_TX_SHIFT (5U)
/*! FLEXCOMM2_TX - FLEXCOMM2 TX enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM2_TX(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM2_TX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM2_TX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM3_RX_MASK (0x40U)
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM3_RX_SHIFT (6U)
/*! FLEXCOMM3_RX - FLEXCOMM3 RX enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM3_RX(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM3_RX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM3_RX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM3_TX_MASK (0x80U)
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM3_TX_SHIFT (7U)
/*! FLEXCOMM3_TX - FLEXCOMM3 TX enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM3_TX(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM3_TX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM3_TX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM4_RX_MASK (0x100U)
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM4_RX_SHIFT (8U)
/*! FLEXCOMM4_RX - FLEXCOMM4 RX enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM4_RX(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM4_RX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM4_RX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM4_TX_MASK (0x200U)
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM4_TX_SHIFT (9U)
/*! FLEXCOMM4_TX - FLEXCOMM4 TX enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM4_TX(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM4_TX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM4_TX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM5_RX_MASK (0x400U)
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM5_RX_SHIFT (10U)
/*! FLEXCOMM5_RX - FLEXCOMM5 RX enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM5_RX(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM5_RX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM5_RX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM5_TX_MASK (0x800U)
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM5_TX_SHIFT (11U)
/*! FLEXCOMM5_TX - FLEXCOMM5 TX enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM5_TX(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM5_TX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM5_TX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM6_RX_MASK (0x1000U)
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM6_RX_SHIFT (12U)
/*! FLEXCOMM6_RX - FLEXCOMM6 RX enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM6_RX(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM6_RX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM6_RX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM6_TX_MASK (0x2000U)
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM6_TX_SHIFT (13U)
/*! FLEXCOMM6_TX - FLEXCOMM6 TX enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM6_TX(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM6_TX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM6_TX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM7_RX_MASK (0x4000U)
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM7_RX_SHIFT (14U)
/*! FLEXCOMM7_RX - FLEXCOMM7 RX enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM7_RX(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM7_RX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM7_RX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM7_TX_MASK (0x8000U)
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM7_TX_SHIFT (15U)
/*! FLEXCOMM7_TX - FLEXCOMM7 TX enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM7_TX(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM7_TX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM7_TX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_DMIC0CH0_MASK    (0x10000U)
#define INPUTMUX_DMAC1_REQ_ENA0_DMIC0CH0_SHIFT   (16U)
/*! DMIC0CH0 - DMIC0 channel 0 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_REQ_ENA0_DMIC0CH0(x)      (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_DMIC0CH0_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_DMIC0CH0_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_DMIC0CH1_MASK    (0x20000U)
#define INPUTMUX_DMAC1_REQ_ENA0_DMIC0CH1_SHIFT   (17U)
/*! DMIC0CH1 - DMIC0 channel 1 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_REQ_ENA0_DMIC0CH1(x)      (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_DMIC0CH1_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_DMIC0CH1_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_DMIC0CH2_MASK    (0x40000U)
#define INPUTMUX_DMAC1_REQ_ENA0_DMIC0CH2_SHIFT   (18U)
/*! DMIC0CH2 - DMIC0 channel 2 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_REQ_ENA0_DMIC0CH2(x)      (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_DMIC0CH2_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_DMIC0CH2_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_DMIC0CH3_MASK    (0x80000U)
#define INPUTMUX_DMAC1_REQ_ENA0_DMIC0CH3_SHIFT   (19U)
/*! DMIC0CH3 - DMIC0 channel 3 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_REQ_ENA0_DMIC0CH3(x)      (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_DMIC0CH3_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_DMIC0CH3_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_DMIC0CH4_MASK    (0x100000U)
#define INPUTMUX_DMAC1_REQ_ENA0_DMIC0CH4_SHIFT   (20U)
/*! DMIC0CH4 - DMIC0 channel 4 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_REQ_ENA0_DMIC0CH4(x)      (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_DMIC0CH4_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_DMIC0CH4_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_DMIC0CH5_MASK    (0x200000U)
#define INPUTMUX_DMAC1_REQ_ENA0_DMIC0CH5_SHIFT   (21U)
/*! DMIC0CH5 - DMIC0 channel 5 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_REQ_ENA0_DMIC0CH5(x)      (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_DMIC0CH5_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_DMIC0CH5_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_DMIC0CH6_MASK    (0x400000U)
#define INPUTMUX_DMAC1_REQ_ENA0_DMIC0CH6_SHIFT   (22U)
/*! DMIC0CH6 - DMIC0 channel 6 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_REQ_ENA0_DMIC0CH6(x)      (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_DMIC0CH6_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_DMIC0CH6_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_DMIC0CH7_MASK    (0x800000U)
#define INPUTMUX_DMAC1_REQ_ENA0_DMIC0CH7_SHIFT   (23U)
/*! DMIC0CH7 - DMIC0 channel 7 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_REQ_ENA0_DMIC0CH7(x)      (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_DMIC0CH7_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_DMIC0CH7_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_I3C0_RX_MASK     (0x1000000U)
#define INPUTMUX_DMAC1_REQ_ENA0_I3C0_RX_SHIFT    (24U)
/*! I3C0_RX - I3C RX enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_REQ_ENA0_I3C0_RX(x)       (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_I3C0_RX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_I3C0_RX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_I3C0_TX_MASK     (0x2000000U)
#define INPUTMUX_DMAC1_REQ_ENA0_I3C0_TX_SHIFT    (25U)
/*! I3C0_TX - I3C TX enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_REQ_ENA0_I3C0_TX(x)       (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_I3C0_TX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_I3C0_TX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM14_RX_MASK (0x4000000U)
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM14_RX_SHIFT (26U)
/*! FLEXCOMM14_RX - FLEXCOMM14 RX enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM14_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM14_RX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM14_RX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM14_TX_MASK (0x8000000U)
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM14_TX_SHIFT (27U)
/*! FLEXCOMM14_TX - FLEXCOMM14 TX enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM14_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM14_TX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_FLEXCOMM14_TX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_HASHCRYPT_MASK   (0x40000000U)
#define INPUTMUX_DMAC1_REQ_ENA0_HASHCRYPT_SHIFT  (30U)
/*! HASHCRYPT - hash enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_REQ_ENA0_HASHCRYPT(x)     (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_HASHCRYPT_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_HASHCRYPT_MASK)
/*! @} */

/*! @name DMAC1_REQ_ENA0_SET - DMAC1 request enable set 0 */
/*! @{ */

#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM0_RX_MASK (0x1U)
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM0_RX_SHIFT (0U)
/*! FLEXCOMM0_RX - FLEXCOMM0 RX enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM0_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM0_RX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM0_RX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM0_TX_MASK (0x2U)
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM0_TX_SHIFT (1U)
/*! FLEXCOMM0_TX - FLEXCOMM0 TX enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM0_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM0_TX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM0_TX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM1_RX_MASK (0x4U)
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM1_RX_SHIFT (2U)
/*! FLEXCOMM1_RX - FLEXCOMM1 RX enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM1_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM1_RX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM1_RX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM1_TX_MASK (0x8U)
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM1_TX_SHIFT (3U)
/*! FLEXCOMM1_TX - FLEXCOMM1 TX enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM1_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM1_TX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM1_TX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM2_RX_MASK (0x10U)
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM2_RX_SHIFT (4U)
/*! FLEXCOMM2_RX - FLEXCOMM2 RX enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM2_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM2_RX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM2_RX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM2_TX_MASK (0x20U)
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM2_TX_SHIFT (5U)
/*! FLEXCOMM2_TX - FLEXCOMM2 TX enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM2_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM2_TX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM2_TX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM3_RX_MASK (0x40U)
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM3_RX_SHIFT (6U)
/*! FLEXCOMM3_RX - FLEXCOMM3 RX enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM3_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM3_RX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM3_RX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM3_TX_MASK (0x80U)
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM3_TX_SHIFT (7U)
/*! FLEXCOMM3_TX - FLEXCOMM3 TX enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM3_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM3_TX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM3_TX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM4_RX_MASK (0x100U)
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM4_RX_SHIFT (8U)
/*! FLEXCOMM4_RX - FLEXCOMM4 RX enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM4_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM4_RX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM4_RX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM4_TX_MASK (0x200U)
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM4_TX_SHIFT (9U)
/*! FLEXCOMM4_TX - FLEXCOMM4 TX enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM4_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM4_TX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM4_TX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM5_RX_MASK (0x400U)
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM5_RX_SHIFT (10U)
/*! FLEXCOMM5_RX - FLEXCOMM5 RX enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM5_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM5_RX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM5_RX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM5_TX_MASK (0x800U)
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM5_TX_SHIFT (11U)
/*! FLEXCOMM5_TX - FLEXCOMM5 TX enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM5_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM5_TX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM5_TX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM6_RX_MASK (0x1000U)
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM6_RX_SHIFT (12U)
/*! FLEXCOMM6_RX - FLEXCOMM6 RX enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM6_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM6_RX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM6_RX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM6_TX_MASK (0x2000U)
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM6_TX_SHIFT (13U)
/*! FLEXCOMM6_TX - FLEXCOMM6 TX enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM6_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM6_TX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM6_TX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM7_RX_MASK (0x4000U)
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM7_RX_SHIFT (14U)
/*! FLEXCOMM7_RX - FLEXCOMM7 RX enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM7_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM7_RX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM7_RX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM7_TX_MASK (0x8000U)
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM7_TX_SHIFT (15U)
/*! FLEXCOMM7_TX - FLEXCOMM7 TX enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM7_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM7_TX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM7_TX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0CH0_MASK (0x10000U)
#define INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0CH0_SHIFT (16U)
/*! DMIC0CH0 - DMIC0 channel 0 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0CH0(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0CH0_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0CH0_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0CH1_MASK (0x20000U)
#define INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0CH1_SHIFT (17U)
/*! DMIC0CH1 - DMIC0 channel 1 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0CH1(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0CH1_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0CH1_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0CH2_MASK (0x40000U)
#define INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0CH2_SHIFT (18U)
/*! DMIC0CH2 - DMIC0 channel 2 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0CH2(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0CH2_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0CH2_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0CH3_MASK (0x80000U)
#define INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0CH3_SHIFT (19U)
/*! DMIC0CH3 - DMIC0 channel 3 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0CH3(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0CH3_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0CH3_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0CH4_MASK (0x100000U)
#define INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0CH4_SHIFT (20U)
/*! DMIC0CH4 - DMIC0 channel 4 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0CH4(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0CH4_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0CH4_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0CH5_MASK (0x200000U)
#define INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0CH5_SHIFT (21U)
/*! DMIC0CH5 - DMIC0 channel 5 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0CH5(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0CH5_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0CH5_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0CH6_MASK (0x400000U)
#define INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0CH6_SHIFT (22U)
/*! DMIC0CH6 - DMIC0 channel 6 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0CH6(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0CH6_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0CH6_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0CH7_MASK (0x800000U)
#define INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0CH7_SHIFT (23U)
/*! DMIC0CH7 - DMIC0 channel 7 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0CH7(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0CH7_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_SET_DMIC0CH7_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_SET_I3C0_RX_MASK (0x1000000U)
#define INPUTMUX_DMAC1_REQ_ENA0_SET_I3C0_RX_SHIFT (24U)
/*! I3C0_RX - I3C RX enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_SET_I3C0_RX(x)   (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_SET_I3C0_RX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_SET_I3C0_RX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_SET_I3C0_TX_MASK (0x2000000U)
#define INPUTMUX_DMAC1_REQ_ENA0_SET_I3C0_TX_SHIFT (25U)
/*! I3C0_TX - I3C TX enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_SET_I3C0_TX(x)   (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_SET_I3C0_TX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_SET_I3C0_TX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM14_RX_MASK (0x4000000U)
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM14_RX_SHIFT (26U)
/*! FLEXCOMM14_RX - FLEXCOMM14 TX enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM14_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM14_RX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM14_RX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM14_TX_MASK (0x8000000U)
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM14_TX_SHIFT (27U)
/*! FLEXCOMM14_TX - FLEXCOMM15 RX enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM14_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM14_TX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_SET_FLEXCOMM14_TX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_SET_HASHCRYPT_MASK (0x40000000U)
#define INPUTMUX_DMAC1_REQ_ENA0_SET_HASHCRYPT_SHIFT (30U)
/*! HASHCRYPT - Hash enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_SET_HASHCRYPT(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_SET_HASHCRYPT_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_SET_HASHCRYPT_MASK)
/*! @} */

/*! @name DMAC1_REQ_ENA0_CLR - DMAC1 request enable clear 0 */
/*! @{ */

#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM0_RX_MASK (0x1U)
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM0_RX_SHIFT (0U)
/*! FLEXCOMM0_RX - FLEXCOMM0 RX enable clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM0_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM0_RX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM0_RX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM0_TX_MASK (0x2U)
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM0_TX_SHIFT (1U)
/*! FLEXCOMM0_TX - FLEXCOMM0 TX enable clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM0_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM0_TX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM0_TX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM1_RX_MASK (0x4U)
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM1_RX_SHIFT (2U)
/*! FLEXCOMM1_RX - FLEXCOMM1 RX enable clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM1_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM1_RX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM1_RX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM1_TX_MASK (0x8U)
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM1_TX_SHIFT (3U)
/*! FLEXCOMM1_TX - FLEXCOMM1 TX enable clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM1_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM1_TX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM1_TX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM2_RX_MASK (0x10U)
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM2_RX_SHIFT (4U)
/*! FLEXCOMM2_RX - FLEXCOMM2 RX enable clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM2_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM2_RX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM2_RX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM2_TX_MASK (0x20U)
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM2_TX_SHIFT (5U)
/*! FLEXCOMM2_TX - FLEXCOMM2 TX enable clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM2_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM2_TX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM2_TX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM3_RX_MASK (0x40U)
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM3_RX_SHIFT (6U)
/*! FLEXCOMM3_RX - FLEXCOMM3 RX enable clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM3_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM3_RX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM3_RX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM3_TX_MASK (0x80U)
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM3_TX_SHIFT (7U)
/*! FLEXCOMM3_TX - FLEXCOMM3 TX enable clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM3_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM3_TX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM3_TX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM4_RX_MASK (0x100U)
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM4_RX_SHIFT (8U)
/*! FLEXCOMM4_RX - FLEXCOMM4 RX enable clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM4_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM4_RX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM4_RX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM4_TX_MASK (0x200U)
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM4_TX_SHIFT (9U)
/*! FLEXCOMM4_TX - FLEXCOMM4 TX enable clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM4_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM4_TX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM4_TX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM5_RX_MASK (0x400U)
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM5_RX_SHIFT (10U)
/*! FLEXCOMM5_RX - FLEXCOMM5 RX enable clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM5_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM5_RX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM5_RX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM5_TX_MASK (0x800U)
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM5_TX_SHIFT (11U)
/*! FLEXCOMM5_TX - FLEXCOMM5 TX enable clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM5_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM5_TX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM5_TX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM6_RX_MASK (0x1000U)
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM6_RX_SHIFT (12U)
/*! FLEXCOMM6_RX - FLEXCOMM6 RX enable clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM6_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM6_RX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM6_RX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM6_TX_MASK (0x2000U)
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM6_TX_SHIFT (13U)
/*! FLEXCOMM6_TX - FLEXCOMM6 TX enable clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM6_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM6_TX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM6_TX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM7_RX_MASK (0x4000U)
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM7_RX_SHIFT (14U)
/*! FLEXCOMM7_RX - FLEXCOMM7 RX enable clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM7_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM7_RX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM7_RX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM7_TX_MASK (0x8000U)
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM7_TX_SHIFT (15U)
/*! FLEXCOMM7_TX - FLEXCOMM7 TX enable clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM7_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM7_TX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM7_TX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0CH0_MASK (0x10000U)
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0CH0_SHIFT (16U)
/*! DMIC0CH0 - DMIC0 channel 0 enable clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0CH0(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0CH0_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0CH0_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0CH1_MASK (0x20000U)
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0CH1_SHIFT (17U)
/*! DMIC0CH1 - DMIC0 channel 1 enable clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0CH1(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0CH1_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0CH1_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0CH2_MASK (0x40000U)
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0CH2_SHIFT (18U)
/*! DMIC0CH2 - DMIC0 channel 2 enable clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0CH2(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0CH2_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0CH2_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0CH3_MASK (0x80000U)
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0CH3_SHIFT (19U)
/*! DMIC0CH3 - DMIC0 channel 3 enable clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0CH3(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0CH3_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0CH3_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0CH4_MASK (0x100000U)
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0CH4_SHIFT (20U)
/*! DMIC0CH4 - DMIC0 channel 4 enable clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0CH4(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0CH4_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0CH4_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0CH5_MASK (0x200000U)
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0CH5_SHIFT (21U)
/*! DMIC0CH5 - DMIC0 channel 5 enable clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0CH5(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0CH5_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0CH5_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0CH6_MASK (0x400000U)
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0CH6_SHIFT (22U)
/*! DMIC0CH6 - DMIC0 channel 6 enable clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0CH6(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0CH6_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0CH6_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0CH7_MASK (0x800000U)
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0CH7_SHIFT (23U)
/*! DMIC0CH7 - DMIC0 channel 7 enable clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0CH7(x)  (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0CH7_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_CLR_DMIC0CH7_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_CLR_I3C0_RX_MASK (0x1000000U)
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_I3C0_RX_SHIFT (24U)
/*! I3C0_RX - I3C RX enable clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_I3C0_RX(x)   (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_CLR_I3C0_RX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_CLR_I3C0_RX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_CLR_I3C0_TX_MASK (0x2000000U)
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_I3C0_TX_SHIFT (25U)
/*! I3C0_TX - I3C TX enable clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_I3C0_TX(x)   (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_CLR_I3C0_TX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_CLR_I3C0_TX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM14_RX_MASK (0x4000000U)
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM14_RX_SHIFT (26U)
/*! FLEXCOMM14_RX - FLEXCOMM14 RX enable clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM14_RX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM14_RX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM14_RX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM14_TX_MASK (0x8000000U)
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM14_TX_SHIFT (27U)
/*! FLEXCOMM14_TX - FLEXCOMM14 TX enable clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM14_TX(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM14_TX_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_CLR_FLEXCOMM14_TX_MASK)

#define INPUTMUX_DMAC1_REQ_ENA0_CLR_HASHCRYPT_MASK (0x40000000U)
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_HASHCRYPT_SHIFT (30U)
/*! HASHCRYPT - Hash enable clear
 *  0b0..No Effect
 *  0b1..Clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_REQ_ENA0_CLR_HASHCRYPT(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_REQ_ENA0_CLR_HASHCRYPT_SHIFT)) & INPUTMUX_DMAC1_REQ_ENA0_CLR_HASHCRYPT_MASK)
/*! @} */

/*! @name DMAC0_ITRIG_ENA0 - DMAC0 input trigger enable 0 */
/*! @{ */

#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX0_MASK (0x1U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX0_SHIFT (0U)
/*! DMAC0_ITRIG_INMUX0 - DMAC0 input trigger inmux 0 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX0(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX0_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX0_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX1_MASK (0x2U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX1_SHIFT (1U)
/*! DMAC0_ITRIG_INMUX1 - DMAC0 input trigger inmux 1 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX1(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX1_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX1_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX2_MASK (0x4U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX2_SHIFT (2U)
/*! DMAC0_ITRIG_INMUX2 - DMAC0 input trigger inmux 2 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX2(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX2_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX2_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX3_MASK (0x8U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX3_SHIFT (3U)
/*! DMAC0_ITRIG_INMUX3 - DMAC0 input trigger inmux 3 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX3(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX3_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX3_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX4_MASK (0x10U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX4_SHIFT (4U)
/*! DMAC0_ITRIG_INMUX4 - DMAC0 input trigger inmux 4 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX4(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX4_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX4_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX5_MASK (0x20U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX5_SHIFT (5U)
/*! DMAC0_ITRIG_INMUX5 - DMAC0 input trigger inmux 5 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX5(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX5_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX5_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX6_MASK (0x40U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX6_SHIFT (6U)
/*! DMAC0_ITRIG_INMUX6 - DMAC0 input trigger inmux 6 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX6(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX6_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX6_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX7_MASK (0x80U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX7_SHIFT (7U)
/*! DMAC0_ITRIG_INMUX7 - DMAC0 input trigger inmux 7 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX7(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX7_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX7_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX8_MASK (0x100U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX8_SHIFT (8U)
/*! DMAC0_ITRIG_INMUX8 - DMAC0 input trigger inmux 8 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX8(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX8_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX8_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX9_MASK (0x200U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX9_SHIFT (9U)
/*! DMAC0_ITRIG_INMUX9 - DMAC0 input trigger inmux 9 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX9(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX9_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX9_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX10_MASK (0x400U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX10_SHIFT (10U)
/*! DMAC0_ITRIG_INMUX10 - DMAC0 input trigger inmux 10 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX10(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX10_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX10_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX11_MASK (0x800U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX11_SHIFT (11U)
/*! DMAC0_ITRIG_INMUX11 - DMAC0 input trigger inmux 11 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX11(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX11_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX11_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX12_MASK (0x1000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX12_SHIFT (12U)
/*! DMAC0_ITRIG_INMUX12 - DMAC0 input trigger inmux 12 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX12(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX12_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX12_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX13_MASK (0x2000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX13_SHIFT (13U)
/*! DMAC0_ITRIG_INMUX13 - DMAC0 input trigger inmux 13 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX13(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX13_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX13_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX14_MASK (0x4000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX14_SHIFT (14U)
/*! DMAC0_ITRIG_INMUX14 - DMAC0 input trigger inmux 14 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX14(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX14_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX14_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX15_MASK (0x8000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX15_SHIFT (15U)
/*! DMAC0_ITRIG_INMUX15 - DMAC0 input trigger inmux 15 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX15(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX15_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX15_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX16_MASK (0x10000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX16_SHIFT (16U)
/*! DMAC0_ITRIG_INMUX16 - DMAC0 input trigger inmux 16 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX16(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX16_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX16_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX17_MASK (0x20000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX17_SHIFT (17U)
/*! DMAC0_ITRIG_INMUX17 - DMAC0 input trigger inmux 17 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX17(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX17_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX17_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX18_MASK (0x40000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX18_SHIFT (18U)
/*! DMAC0_ITRIG_INMUX18 - DMAC0 input trigger inmux 18 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX18(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX18_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX18_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX19_MASK (0x80000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX19_SHIFT (19U)
/*! DMAC0_ITRIG_INMUX19 - DMAC0 input trigger inmux 19 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX19(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX19_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX19_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX20_MASK (0x100000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX20_SHIFT (20U)
/*! DMAC0_ITRIG_INMUX20 - DMAC0 input trigger inmux 20 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX20(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX20_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX20_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX21_MASK (0x200000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX21_SHIFT (21U)
/*! DMAC0_ITRIG_INMUX21 - DMAC0 input trigger inmux 21 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX21(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX21_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX21_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX22_MASK (0x400000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX22_SHIFT (22U)
/*! DMAC0_ITRIG_INMUX22 - DMAC0 input trigger inmux 22 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX22(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX22_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX22_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX23_MASK (0x800000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX23_SHIFT (23U)
/*! DMAC0_ITRIG_INMUX23 - DMAC0 input trigger inmux 23 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX23(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX23_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX23_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX24_MASK (0x1000000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX24_SHIFT (24U)
/*! DMAC0_ITRIG_INMUX24 - DMAC0 input trigger inmux 24 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX24(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX24_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX24_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX25_MASK (0x2000000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX25_SHIFT (25U)
/*! DMAC0_ITRIG_INMUX25 - DMAC0 input trigger inmux 25 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX25(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX25_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX25_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX26_MASK (0x4000000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX26_SHIFT (26U)
/*! DMAC0_ITRIG_INMUX26 - DMAC0 input trigger inmux 26 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX26(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX26_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX26_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX27_MASK (0x8000000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX27_SHIFT (27U)
/*! DMAC0_ITRIG_INMUX27 - DMAC0 input trigger inmux 27 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX27(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX27_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX27_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX28_MASK (0x10000000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX28_SHIFT (28U)
/*! DMAC0_ITRIG_INMUX28 - DMAC0 input trigger inmux 28 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX28(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX28_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX28_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX29_MASK (0x20000000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX29_SHIFT (29U)
/*! DMAC0_ITRIG_INMUX29 - DMAC0 input trigger inmux 29 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX29(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX29_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX29_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX30_MASK (0x40000000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX30_SHIFT (30U)
/*! DMAC0_ITRIG_INMUX30 - DMAC0 input trigger inmux 30 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX30(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX30_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX30_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX31_MASK (0x80000000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX31_SHIFT (31U)
/*! DMAC0_ITRIG_INMUX31 - DMAC0 input trigger inmux 31 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX31(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX31_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_DMAC0_ITRIG_INMUX31_MASK)
/*! @} */

/*! @name DMAC0_ITRIG_ENA0_SET - DMAC0 input trigger enable set 0 */
/*! @{ */

#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX0_MASK (0x1U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX0_SHIFT (0U)
/*! DMAC0_ITRIG_INMUX0 - DMAC0 input trigger inmux 0 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX0(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX0_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX0_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX1_MASK (0x2U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX1_SHIFT (1U)
/*! DMAC0_ITRIG_INMUX1 - DMAC0 input trigger inmux 1 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX1(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX1_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX1_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX2_MASK (0x4U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX2_SHIFT (2U)
/*! DMAC0_ITRIG_INMUX2 - DMAC0 input trigger inmux 2 enable set
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX2(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX2_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX2_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX3_MASK (0x8U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX3_SHIFT (3U)
/*! DMAC0_ITRIG_INMUX3 - DMAC0 input trigger inmux 3 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX3(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX3_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX3_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX4_MASK (0x10U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX4_SHIFT (4U)
/*! DMAC0_ITRIG_INMUX4 - DMAC0 input trigger inmux 4 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX4(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX4_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX4_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX5_MASK (0x20U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX5_SHIFT (5U)
/*! DMAC0_ITRIG_INMUX5 - DMAC0 input trigger inmux 5 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX5(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX5_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX5_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX6_MASK (0x40U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX6_SHIFT (6U)
/*! DMAC0_ITRIG_INMUX6 - DMAC0 input trigger inmux 6 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX6(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX6_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX6_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX7_MASK (0x80U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX7_SHIFT (7U)
/*! DMAC0_ITRIG_INMUX7 - DMAC0 input trigger inmux 7 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX7(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX7_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX7_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX8_MASK (0x100U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX8_SHIFT (8U)
/*! DMAC0_ITRIG_INMUX8 - DMAC0 input trigger inmux 8 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX8(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX8_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX8_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX9_MASK (0x200U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX9_SHIFT (9U)
/*! DMAC0_ITRIG_INMUX9 - DMAC0 input trigger inmux 9 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX9(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX9_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX9_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX10_MASK (0x400U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX10_SHIFT (10U)
/*! DMAC0_ITRIG_INMUX10 - DMAC0 input trigger inmux 10 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX10(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX10_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX10_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX11_MASK (0x800U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX11_SHIFT (11U)
/*! DMAC0_ITRIG_INMUX11 - DMAC0 input trigger inmux 11 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX11(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX11_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX11_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX12_MASK (0x1000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX12_SHIFT (12U)
/*! DMAC0_ITRIG_INMUX12 - DMAC0 input trigger inmux 12 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX12(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX12_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX12_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX13_MASK (0x2000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX13_SHIFT (13U)
/*! DMAC0_ITRIG_INMUX13 - DMAC0 input trigger inmux 13 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX13(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX13_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX13_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX14_MASK (0x4000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX14_SHIFT (14U)
/*! DMAC0_ITRIG_INMUX14 - DMAC0 input trigger inmux 14 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX14(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX14_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX14_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX15_MASK (0x8000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX15_SHIFT (15U)
/*! DMAC0_ITRIG_INMUX15 - DMAC0 input trigger inmux 15 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX15(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX15_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX15_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX16_MASK (0x10000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX16_SHIFT (16U)
/*! DMAC0_ITRIG_INMUX16 - DMAC0 input trigger inmux 16 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX16(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX16_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX16_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX17_MASK (0x20000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX17_SHIFT (17U)
/*! DMAC0_ITRIG_INMUX17 - DMAC0 input trigger inmux 17 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX17(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX17_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX17_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX18_MASK (0x40000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX18_SHIFT (18U)
/*! DMAC0_ITRIG_INMUX18 - DMAC0 input trigger inmux 18 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX18(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX18_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX18_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX19_MASK (0x80000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX19_SHIFT (19U)
/*! DMAC0_ITRIG_INMUX19 - DMAC0 input trigger inmux 19 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX19(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX19_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX19_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX20_MASK (0x100000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX20_SHIFT (20U)
/*! DMAC0_ITRIG_INMUX20 - DMAC0 input trigger inmux 20 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX20(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX20_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX20_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX21_MASK (0x200000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX21_SHIFT (21U)
/*! DMAC0_ITRIG_INMUX21 - DMAC0 input trigger inmux 21 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX21(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX21_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX21_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX22_MASK (0x400000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX22_SHIFT (22U)
/*! DMAC0_ITRIG_INMUX22 - DMAC0 input trigger inmux 22 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX22(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX22_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX22_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX23_MASK (0x800000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX23_SHIFT (23U)
/*! DMAC0_ITRIG_INMUX23 - DMAC0 input trigger inmux 23 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX23(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX23_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX23_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX24_MASK (0x1000000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX24_SHIFT (24U)
/*! DMAC0_ITRIG_INMUX24 - DMAC0 input trigger inmux 24 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX24(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX24_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX24_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX25_MASK (0x2000000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX25_SHIFT (25U)
/*! DMAC0_ITRIG_INMUX25 - DMAC0 input trigger inmux 25 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX25(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX25_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX25_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX26_MASK (0x4000000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX26_SHIFT (26U)
/*! DMAC0_ITRIG_INMUX26 - DMAC0 input trigger inmux 26 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX26(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX26_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX26_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX27_MASK (0x8000000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX27_SHIFT (27U)
/*! DMAC0_ITRIG_INMUX27 - DMAC0 input trigger inmux 27 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX27(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX27_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX27_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX28_MASK (0x10000000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX28_SHIFT (28U)
/*! DMAC0_ITRIG_INMUX28 - DMAC0 input trigger inmux 28 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX28(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX28_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX28_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX29_MASK (0x20000000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX29_SHIFT (29U)
/*! DMAC0_ITRIG_INMUX29 - DMAC0 input trigger inmux 29 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX29(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX29_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX29_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX30_MASK (0x40000000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX30_SHIFT (30U)
/*! DMAC0_ITRIG_INMUX30 - DMAC0 input trigger inmux 30 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX30(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX30_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX30_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX31_MASK (0x80000000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX31_SHIFT (31U)
/*! DMAC0_ITRIG_INMUX31 - DMAC0 input trigger inmux 31 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX31(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX31_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_SET_DMAC0_ITRIG_INMUX31_MASK)
/*! @} */

/*! @name DMAC0_ITRIG_ENA0_CLR - DMAC0 input trigger enable clear 0 */
/*! @{ */

#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX0_MASK (0x1U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX0_SHIFT (0U)
/*! DMAC0_ITRIG_INMUX0 - DMAC0 input trigger inmux 0 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX0(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX0_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX0_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX1_MASK (0x2U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX1_SHIFT (1U)
/*! DMAC0_ITRIG_INMUX1 - DMAC0 input trigger inmux 1 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX1(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX1_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX1_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX2_MASK (0x4U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX2_SHIFT (2U)
/*! DMAC0_ITRIG_INMUX2 - DMAC0 input trigger inmux 2 enable clear
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX2(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX2_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX2_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX3_MASK (0x8U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX3_SHIFT (3U)
/*! DMAC0_ITRIG_INMUX3 - DMAC0 input trigger inmux 3 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX3(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX3_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX3_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX4_MASK (0x10U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX4_SHIFT (4U)
/*! DMAC0_ITRIG_INMUX4 - DMAC0 input trigger inmux 4 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX4(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX4_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX4_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX5_MASK (0x20U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX5_SHIFT (5U)
/*! DMAC0_ITRIG_INMUX5 - DMAC0 input trigger inmux 5 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX5(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX5_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX5_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX6_MASK (0x40U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX6_SHIFT (6U)
/*! DMAC0_ITRIG_INMUX6 - DMAC0 input trigger inmux 6 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX6(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX6_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX6_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX7_MASK (0x80U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX7_SHIFT (7U)
/*! DMAC0_ITRIG_INMUX7 - DMAC0 input trigger inmux 7 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX7(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX7_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX7_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX8_MASK (0x100U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX8_SHIFT (8U)
/*! DMAC0_ITRIG_INMUX8 - DMAC0 input trigger inmux 8 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX8(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX8_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX8_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX9_MASK (0x200U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX9_SHIFT (9U)
/*! DMAC0_ITRIG_INMUX9 - DMAC0 input trigger inmux 9 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX9(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX9_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX9_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX10_MASK (0x400U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX10_SHIFT (10U)
/*! DMAC0_ITRIG_INMUX10 - DMAC0 input trigger inmux 10 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX10(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX10_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX10_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX11_MASK (0x800U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX11_SHIFT (11U)
/*! DMAC0_ITRIG_INMUX11 - DMAC0 input trigger inmux 11 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX11(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX11_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX11_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX12_MASK (0x1000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX12_SHIFT (12U)
/*! DMAC0_ITRIG_INMUX12 - DMAC0 input trigger inmux 12 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX12(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX12_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX12_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX13_MASK (0x2000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX13_SHIFT (13U)
/*! DMAC0_ITRIG_INMUX13 - DMAC0 input trigger inmux 13 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX13(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX13_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX13_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX14_MASK (0x4000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX14_SHIFT (14U)
/*! DMAC0_ITRIG_INMUX14 - DMAC0 input trigger inmux 14 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX14(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX14_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX14_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX15_MASK (0x8000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX15_SHIFT (15U)
/*! DMAC0_ITRIG_INMUX15 - DMAC0 input trigger inmux 15 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX15(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX15_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX15_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX16_MASK (0x10000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX16_SHIFT (16U)
/*! DMAC0_ITRIG_INMUX16 - DMAC0 input trigger inmux 16 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX16(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX16_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX16_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX17_MASK (0x20000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX17_SHIFT (17U)
/*! DMAC0_ITRIG_INMUX17 - DMAC0 input trigger inmux 17 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX17(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX17_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX17_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX18_MASK (0x40000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX18_SHIFT (18U)
/*! DMAC0_ITRIG_INMUX18 - DMAC0 input trigger inmux 18 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX18(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX18_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX18_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX19_MASK (0x80000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX19_SHIFT (19U)
/*! DMAC0_ITRIG_INMUX19 - DMAC0 input trigger inmux 19 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX19(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX19_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX19_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX20_MASK (0x100000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX20_SHIFT (20U)
/*! DMAC0_ITRIG_INMUX20 - DMAC0 input trigger inmux 20 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX20(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX20_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX20_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX21_MASK (0x200000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX21_SHIFT (21U)
/*! DMAC0_ITRIG_INMUX21 - DMAC0 input trigger inmux 21 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX21(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX21_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX21_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX22_MASK (0x400000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX22_SHIFT (22U)
/*! DMAC0_ITRIG_INMUX22 - DMAC0 input trigger inmux 22 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX22(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX22_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX22_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX23_MASK (0x800000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX23_SHIFT (23U)
/*! DMAC0_ITRIG_INMUX23 - DMAC0 input trigger inmux 23 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX23(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX23_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX23_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX24_MASK (0x1000000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX24_SHIFT (24U)
/*! DMAC0_ITRIG_INMUX24 - DMAC0 input trigger inmux 24 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX24(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX24_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX24_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX25_MASK (0x2000000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX25_SHIFT (25U)
/*! DMAC0_ITRIG_INMUX25 - DMAC0 input trigger inmux 25 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX25(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX25_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX25_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX26_MASK (0x4000000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX26_SHIFT (26U)
/*! DMAC0_ITRIG_INMUX26 - DMAC0 input trigger inmux 26 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX26(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX26_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX26_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX27_MASK (0x8000000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX27_SHIFT (27U)
/*! DMAC0_ITRIG_INMUX27 - DMAC0 input trigger inmux 27 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX27(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX27_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX27_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX28_MASK (0x10000000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX28_SHIFT (28U)
/*! DMAC0_ITRIG_INMUX28 - DMAC0 input trigger inmux 28 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX28(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX28_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX28_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX29_MASK (0x20000000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX29_SHIFT (29U)
/*! DMAC0_ITRIG_INMUX29 - DMAC0 input trigger inmux 29 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX29(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX29_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX29_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX30_MASK (0x40000000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX30_SHIFT (30U)
/*! DMAC0_ITRIG_INMUX30 - DMAC0 input trigger inmux 30 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX30(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX30_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX30_MASK)

#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX31_MASK (0x80000000U)
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX31_SHIFT (31U)
/*! DMAC0_ITRIG_INMUX31 - DMAC0 input trigger inmux 31 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX31(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX31_SHIFT)) & INPUTMUX_DMAC0_ITRIG_ENA0_CLR_DMAC0_ITRIG_INMUX31_MASK)
/*! @} */

/*! @name DMAC1_ITRIG_ENA0 - DMAC1 input trigger enable 0 */
/*! @{ */

#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX0_MASK (0x1U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX0_SHIFT (0U)
/*! DMAC1_ITRIG_INMUX0 - DMAC1 input trigger inmux 0 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX0(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX0_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX0_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX1_MASK (0x2U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX1_SHIFT (1U)
/*! DMAC1_ITRIG_INMUX1 - DMAC1 input trigger inmux 1 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX1(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX1_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX1_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX2_MASK (0x4U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX2_SHIFT (2U)
/*! DMAC1_ITRIG_INMUX2 - DMAC1 input trigger inmux 2 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX2(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX2_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX2_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX3_MASK (0x8U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX3_SHIFT (3U)
/*! DMAC1_ITRIG_INMUX3 - DMAC1 input trigger inmux 3 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX3(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX3_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX3_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX4_MASK (0x10U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX4_SHIFT (4U)
/*! DMAC1_ITRIG_INMUX4 - DMAC1 input trigger inmux 4 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX4(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX4_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX4_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX5_MASK (0x20U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX5_SHIFT (5U)
/*! DMAC1_ITRIG_INMUX5 - DMAC1 input trigger inmux 5 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX5(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX5_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX5_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX6_MASK (0x40U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX6_SHIFT (6U)
/*! DMAC1_ITRIG_INMUX6 - DMAC1 input trigger inmux 6 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX6(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX6_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX6_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX7_MASK (0x80U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX7_SHIFT (7U)
/*! DMAC1_ITRIG_INMUX7 - DMAC1 input trigger inmux 7 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX7(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX7_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX7_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX8_MASK (0x100U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX8_SHIFT (8U)
/*! DMAC1_ITRIG_INMUX8 - DMAC1 input trigger inmux 8 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX8(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX8_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX8_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX9_MASK (0x200U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX9_SHIFT (9U)
/*! DMAC1_ITRIG_INMUX9 - DMAC1 input trigger inmux 9 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX9(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX9_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX9_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX10_MASK (0x400U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX10_SHIFT (10U)
/*! DMAC1_ITRIG_INMUX10 - DMAC1 input trigger inmux 10 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX10(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX10_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX10_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX11_MASK (0x800U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX11_SHIFT (11U)
/*! DMAC1_ITRIG_INMUX11 - DMAC1 input trigger inmux 11 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX11(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX11_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX11_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX12_MASK (0x1000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX12_SHIFT (12U)
/*! DMAC1_ITRIG_INMUX12 - DMAC1 input trigger inmux 12 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX12(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX12_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX12_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX13_MASK (0x2000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX13_SHIFT (13U)
/*! DMAC1_ITRIG_INMUX13 - DMAC1 input trigger inmux 13 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX13(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX13_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX13_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX14_MASK (0x4000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX14_SHIFT (14U)
/*! DMAC1_ITRIG_INMUX14 - DMAC1 input trigger inmux 14 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX14(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX14_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX14_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX15_MASK (0x8000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX15_SHIFT (15U)
/*! DMAC1_ITRIG_INMUX15 - DMAC1 input trigger inmux 15 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX15(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX15_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX15_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX16_MASK (0x10000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX16_SHIFT (16U)
/*! DMAC1_ITRIG_INMUX16 - DMAC1 input trigger inmux 16 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX16(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX16_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX16_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX17_MASK (0x20000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX17_SHIFT (17U)
/*! DMAC1_ITRIG_INMUX17 - DMAC1 input trigger inmux 17 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX17(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX17_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX17_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX18_MASK (0x40000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX18_SHIFT (18U)
/*! DMAC1_ITRIG_INMUX18 - DMAC1 input trigger inmux 18 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX18(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX18_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX18_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX19_MASK (0x80000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX19_SHIFT (19U)
/*! DMAC1_ITRIG_INMUX19 - DMAC1 input trigger inmux 19 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX19(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX19_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX19_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX20_MASK (0x100000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX20_SHIFT (20U)
/*! DMAC1_ITRIG_INMUX20 - DMAC1 input trigger inmux 20 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX20(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX20_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX20_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX21_MASK (0x200000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX21_SHIFT (21U)
/*! DMAC1_ITRIG_INMUX21 - DMAC1 input trigger inmux 21 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX21(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX21_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX21_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX22_MASK (0x400000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX22_SHIFT (22U)
/*! DMAC1_ITRIG_INMUX22 - DMAC1 input trigger inmux 22 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX22(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX22_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX22_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX23_MASK (0x800000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX23_SHIFT (23U)
/*! DMAC1_ITRIG_INMUX23 - DMAC1 input trigger inmux 23 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX23(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX23_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX23_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX24_MASK (0x1000000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX24_SHIFT (24U)
/*! DMAC1_ITRIG_INMUX24 - DMAC1 input trigger inmux 24 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX24(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX24_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX24_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX25_MASK (0x2000000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX25_SHIFT (25U)
/*! DMAC1_ITRIG_INMUX25 - DMAC1 input trigger inmux 25 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX25(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX25_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX25_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX26_MASK (0x4000000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX26_SHIFT (26U)
/*! DMAC1_ITRIG_INMUX26 - DMAC1 input trigger inmux 25 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX26(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX26_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX26_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX27_MASK (0x8000000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX27_SHIFT (27U)
/*! DMAC1_ITRIG_INMUX27 - DMAC1 input trigger inmux 25 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX27(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX27_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX27_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX28_MASK (0x10000000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX28_SHIFT (28U)
/*! DMAC1_ITRIG_INMUX28 - DMAC1 input trigger inmux 25 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX28(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX28_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX28_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX29_MASK (0x20000000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX29_SHIFT (29U)
/*! DMAC1_ITRIG_INMUX29 - DMAC1 input trigger inmux 25 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX29(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX29_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX29_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX30_MASK (0x40000000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX30_SHIFT (30U)
/*! DMAC1_ITRIG_INMUX30 - DMAC1 input trigger inmux 25 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX30(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX30_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX30_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX31_MASK (0x80000000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX31_SHIFT (31U)
/*! DMAC1_ITRIG_INMUX31 - DMAC1 input trigger inmux 25 enable
 *  0b0..disable
 *  0b1..enable
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX31(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX31_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_DMAC1_ITRIG_INMUX31_MASK)
/*! @} */

/*! @name DMAC1_ITRIG_ENA0_SET - DMAC1 input trigger enable set 0 */
/*! @{ */

#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX0_MASK (0x1U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX0_SHIFT (0U)
/*! DMAC1_ITRIG_INMUX0 - DMAC1 input trigger inmux 0 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX0(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX0_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX0_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX1_MASK (0x2U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX1_SHIFT (1U)
/*! DMAC1_ITRIG_INMUX1 - DMAC1 input trigger inmux 1 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX1(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX1_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX1_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX2_MASK (0x4U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX2_SHIFT (2U)
/*! DMAC1_ITRIG_INMUX2 - DMAC1 input trigger inmux 2 enable set
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX2(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX2_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX2_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX3_MASK (0x8U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX3_SHIFT (3U)
/*! DMAC1_ITRIG_INMUX3 - DMAC1 input trigger inmux 3 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX3(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX3_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX3_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX4_MASK (0x10U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX4_SHIFT (4U)
/*! DMAC1_ITRIG_INMUX4 - DMAC1 input trigger inmux 4 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX4(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX4_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX4_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX5_MASK (0x20U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX5_SHIFT (5U)
/*! DMAC1_ITRIG_INMUX5 - DMAC1 input trigger inmux 5 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX5(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX5_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX5_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX6_MASK (0x40U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX6_SHIFT (6U)
/*! DMAC1_ITRIG_INMUX6 - DMAC1 input trigger inmux 6 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX6(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX6_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX6_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX7_MASK (0x80U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX7_SHIFT (7U)
/*! DMAC1_ITRIG_INMUX7 - DMAC1 input trigger inmux 7 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX7(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX7_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX7_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX8_MASK (0x100U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX8_SHIFT (8U)
/*! DMAC1_ITRIG_INMUX8 - DMAC1 input trigger inmux 8 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX8(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX8_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX8_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX9_MASK (0x200U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX9_SHIFT (9U)
/*! DMAC1_ITRIG_INMUX9 - DMAC1 input trigger inmux 9 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX9(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX9_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX9_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX10_MASK (0x400U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX10_SHIFT (10U)
/*! DMAC1_ITRIG_INMUX10 - DMAC1 input trigger inmux 10 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX10(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX10_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX10_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX11_MASK (0x800U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX11_SHIFT (11U)
/*! DMAC1_ITRIG_INMUX11 - DMAC1 input trigger inmux 11 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX11(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX11_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX11_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX12_MASK (0x1000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX12_SHIFT (12U)
/*! DMAC1_ITRIG_INMUX12 - DMAC1 input trigger inmux 12 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX12(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX12_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX12_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX13_MASK (0x2000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX13_SHIFT (13U)
/*! DMAC1_ITRIG_INMUX13 - DMAC1 input trigger inmux 13 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX13(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX13_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX13_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX14_MASK (0x4000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX14_SHIFT (14U)
/*! DMAC1_ITRIG_INMUX14 - DMAC1 input trigger inmux 14 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX14(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX14_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX14_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX15_MASK (0x8000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX15_SHIFT (15U)
/*! DMAC1_ITRIG_INMUX15 - DMAC1 input trigger inmux 15 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX15(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX15_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX15_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX16_MASK (0x10000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX16_SHIFT (16U)
/*! DMAC1_ITRIG_INMUX16 - DMAC1 input trigger inmux 16 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX16(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX16_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX16_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX17_MASK (0x20000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX17_SHIFT (17U)
/*! DMAC1_ITRIG_INMUX17 - DMAC1 input trigger inmux 17 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX17(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX17_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX17_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX18_MASK (0x40000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX18_SHIFT (18U)
/*! DMAC1_ITRIG_INMUX18 - DMAC1 input trigger inmux 18 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX18(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX18_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX18_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX19_MASK (0x80000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX19_SHIFT (19U)
/*! DMAC1_ITRIG_INMUX19 - DMAC1 input trigger inmux 19 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX19(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX19_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX19_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX20_MASK (0x100000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX20_SHIFT (20U)
/*! DMAC1_ITRIG_INMUX20 - DMAC1 input trigger inmux 20 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX20(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX20_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX20_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX21_MASK (0x200000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX21_SHIFT (21U)
/*! DMAC1_ITRIG_INMUX21 - DMAC1 input trigger inmux 21 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX21(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX21_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX21_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX22_MASK (0x400000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX22_SHIFT (22U)
/*! DMAC1_ITRIG_INMUX22 - DMAC1 input trigger inmux 22 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX22(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX22_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX22_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX23_MASK (0x800000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX23_SHIFT (23U)
/*! DMAC1_ITRIG_INMUX23 - DMAC1 input trigger inmux 23 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX23(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX23_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX23_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX24_MASK (0x1000000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX24_SHIFT (24U)
/*! DMAC1_ITRIG_INMUX24 - DMAC1 input trigger inmux 24 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX24(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX24_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX24_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX25_MASK (0x2000000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX25_SHIFT (25U)
/*! DMAC1_ITRIG_INMUX25 - DMAC1 input trigger inmux 25 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX25(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX25_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX25_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX26_MASK (0x4000000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX26_SHIFT (26U)
/*! DMAC1_ITRIG_INMUX26 - DMAC1 input trigger inmux 25 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX26(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX26_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX26_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX27_MASK (0x8000000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX27_SHIFT (27U)
/*! DMAC1_ITRIG_INMUX27 - DMAC1 input trigger inmux 25 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX27(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX27_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX27_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX28_MASK (0x10000000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX28_SHIFT (28U)
/*! DMAC1_ITRIG_INMUX28 - DMAC1 input trigger inmux 25 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX28(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX28_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX28_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX29_MASK (0x20000000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX29_SHIFT (29U)
/*! DMAC1_ITRIG_INMUX29 - DMAC1 input trigger inmux 25 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX29(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX29_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX29_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX30_MASK (0x40000000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX30_SHIFT (30U)
/*! DMAC1_ITRIG_INMUX30 - DMAC1 input trigger inmux 25 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX30(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX30_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX30_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX31_MASK (0x80000000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX31_SHIFT (31U)
/*! DMAC1_ITRIG_INMUX31 - DMAC1 input trigger inmux 25 enable set
 *  0b0..No Effect
 *  0b1..Sets the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX31(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX31_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_SET_DMAC1_ITRIG_INMUX31_MASK)
/*! @} */

/*! @name DMAC1_ITRIG_ENA0_CLR - DMAC1 input trigger enable clear 0 */
/*! @{ */

#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX0_MASK (0x1U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX0_SHIFT (0U)
/*! DMAC1_ITRIG_INMUX0 - DMAC1 input trigger inmux 0 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX0(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX0_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX0_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX1_MASK (0x2U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX1_SHIFT (1U)
/*! DMAC1_ITRIG_INMUX1 - DMAC1 input trigger inmux 1 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX1(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX1_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX1_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX2_MASK (0x4U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX2_SHIFT (2U)
/*! DMAC1_ITRIG_INMUX2 - DMAC1 input trigger inmux 2 enable clear
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX2(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX2_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX2_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX3_MASK (0x8U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX3_SHIFT (3U)
/*! DMAC1_ITRIG_INMUX3 - DMAC1 input trigger inmux 3 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX3(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX3_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX3_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX4_MASK (0x10U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX4_SHIFT (4U)
/*! DMAC1_ITRIG_INMUX4 - DMAC1 input trigger inmux 4 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX4(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX4_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX4_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX5_MASK (0x20U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX5_SHIFT (5U)
/*! DMAC1_ITRIG_INMUX5 - DMAC1 input trigger inmux 5 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX5(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX5_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX5_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX6_MASK (0x40U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX6_SHIFT (6U)
/*! DMAC1_ITRIG_INMUX6 - DMAC1 input trigger inmux 6 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX6(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX6_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX6_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX7_MASK (0x80U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX7_SHIFT (7U)
/*! DMAC1_ITRIG_INMUX7 - DMAC1 input trigger inmux 7 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX7(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX7_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX7_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX8_MASK (0x100U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX8_SHIFT (8U)
/*! DMAC1_ITRIG_INMUX8 - DMAC1 input trigger inmux 8 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX8(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX8_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX8_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX9_MASK (0x200U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX9_SHIFT (9U)
/*! DMAC1_ITRIG_INMUX9 - DMAC1 input trigger inmux 9 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX9(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX9_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX9_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX10_MASK (0x400U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX10_SHIFT (10U)
/*! DMAC1_ITRIG_INMUX10 - DMAC1 input trigger inmux 10 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX10(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX10_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX10_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX11_MASK (0x800U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX11_SHIFT (11U)
/*! DMAC1_ITRIG_INMUX11 - DMAC1 input trigger inmux 11 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX11(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX11_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX11_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX12_MASK (0x1000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX12_SHIFT (12U)
/*! DMAC1_ITRIG_INMUX12 - DMAC1 input trigger inmux 12 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX12(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX12_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX12_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX13_MASK (0x2000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX13_SHIFT (13U)
/*! DMAC1_ITRIG_INMUX13 - DMAC1 input trigger inmux 13 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX13(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX13_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX13_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX14_MASK (0x4000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX14_SHIFT (14U)
/*! DMAC1_ITRIG_INMUX14 - DMAC1 input trigger inmux 14 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX14(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX14_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX14_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX15_MASK (0x8000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX15_SHIFT (15U)
/*! DMAC1_ITRIG_INMUX15 - DMAC1 input trigger inmux 15 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX15(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX15_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX15_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX16_MASK (0x10000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX16_SHIFT (16U)
/*! DMAC1_ITRIG_INMUX16 - DMAC1 input trigger inmux 16 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX16(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX16_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX16_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX17_MASK (0x20000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX17_SHIFT (17U)
/*! DMAC1_ITRIG_INMUX17 - DMAC1 input trigger inmux 17 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX17(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX17_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX17_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX18_MASK (0x40000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX18_SHIFT (18U)
/*! DMAC1_ITRIG_INMUX18 - DMAC1 input trigger inmux 18 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX18(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX18_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX18_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX19_MASK (0x80000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX19_SHIFT (19U)
/*! DMAC1_ITRIG_INMUX19 - DMAC1 input trigger inmux 19 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX19(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX19_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX19_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX20_MASK (0x100000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX20_SHIFT (20U)
/*! DMAC1_ITRIG_INMUX20 - DMAC1 input trigger inmux 20 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX20(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX20_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX20_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX21_MASK (0x200000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX21_SHIFT (21U)
/*! DMAC1_ITRIG_INMUX21 - DMAC1 input trigger inmux 21 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX21(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX21_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX21_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX22_MASK (0x400000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX22_SHIFT (22U)
/*! DMAC1_ITRIG_INMUX22 - DMAC1 input trigger inmux 22 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX22(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX22_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX22_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX23_MASK (0x800000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX23_SHIFT (23U)
/*! DMAC1_ITRIG_INMUX23 - DMAC1 input trigger inmux 23 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX23(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX23_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX23_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX24_MASK (0x1000000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX24_SHIFT (24U)
/*! DMAC1_ITRIG_INMUX24 - DMAC1 input trigger inmux 24 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX24(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX24_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX24_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX25_MASK (0x2000000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX25_SHIFT (25U)
/*! DMAC1_ITRIG_INMUX25 - DMAC1 input trigger inmux 25 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX25(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX25_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX25_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX26_MASK (0x4000000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX26_SHIFT (26U)
/*! DMAC1_ITRIG_INMUX26 - DMAC1 input trigger inmux 25 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX26(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX26_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX26_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX27_MASK (0x8000000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX27_SHIFT (27U)
/*! DMAC1_ITRIG_INMUX27 - DMAC1 input trigger inmux 25 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX27(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX27_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX27_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX28_MASK (0x10000000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX28_SHIFT (28U)
/*! DMAC1_ITRIG_INMUX28 - DMAC1 input trigger inmux 25 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX28(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX28_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX28_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX29_MASK (0x20000000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX29_SHIFT (29U)
/*! DMAC1_ITRIG_INMUX29 - DMAC1 input trigger inmux 25 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX29(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX29_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX29_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX30_MASK (0x40000000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX30_SHIFT (30U)
/*! DMAC1_ITRIG_INMUX30 - DMAC1 input trigger inmux 25 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX30(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX30_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX30_MASK)

#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX31_MASK (0x80000000U)
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX31_SHIFT (31U)
/*! DMAC1_ITRIG_INMUX31 - DMAC1 input trigger inmux 25 enable clear
 *  0b0..No Effect
 *  0b1..clears the ENA0 Bit
 */
#define INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX31(x) (((uint32_t)(((uint32_t)(x)) << INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX31_SHIFT)) & INPUTMUX_DMAC1_ITRIG_ENA0_CLR_DMAC1_ITRIG_INMUX31_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group INPUTMUX_Register_Masks */


/* INPUTMUX - Peripheral instance base addresses */
/** Peripheral INPUTMUX base address */
#define INPUTMUX_BASE                            (0x40026000u)
/** Peripheral INPUTMUX base pointer */
#define INPUTMUX                                 ((INPUTMUX_Type *)INPUTMUX_BASE)
/** Array initializer of INPUTMUX peripheral base addresses */
#define INPUTMUX_BASE_ADDRS                      { INPUTMUX_BASE }
/** Array initializer of INPUTMUX peripheral base pointers */
#define INPUTMUX_BASE_PTRS                       { INPUTMUX }

/*!
 * @}
 */ /* end of group INPUTMUX_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- IOPCTL Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup IOPCTL_Peripheral_Access_Layer IOPCTL Peripheral Access Layer
 * @{
 */

/** IOPCTL - Register Layout Typedef */
typedef struct {
  __IO uint32_t PIO[8][32];                        /**< iop pad control register for port0 to port5, array offset: 0x0, array step: index*0x80, index2*0x4 */
  __IO uint32_t FC15_I2C_SCL;                      /**< Special Registers (No GPIO Function), offset: 0x400 */
  __IO uint32_t FC15_I2C_SDA;                      /**< Special Registers (No GPIO Function), offset: 0x404 */
} IOPCTL_Type;

/* ----------------------------------------------------------------------------
   -- IOPCTL Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup IOPCTL_Register_Masks IOPCTL Register Masks
 * @{
 */

/*! @name PIO - iop pad control register for port0 to port5 */
/*! @{ */

#define IOPCTL_PIO_FSEL_MASK                     (0xFU)
#define IOPCTL_PIO_FSEL_SHIFT                    (0U)
/*! FSEL - Function Selector. . .(FSELs Sources can be found in the next several pages.)
 *  0b0000..Function 0.
 *  0b0001..Function 1.
 *  0b0010..Function 2.
 *  0b0011..Function 3.
 *  0b0100..Function 4.
 *  0b0101..Function 5.
 *  0b0110..Function 6.
 *  0b0111..Function 7.
 *  0b1000..Function 8.
 *  0b1001..Function 9.
 *  0b1010..Function 10.
 *  0b1011..Function 11.
 *  0b1100..Function 12.
 *  0b1101..Function 13.
 *  0b1110..Function 14.
 *  0b1111..Function 15.
 */
#define IOPCTL_PIO_FSEL(x)                       (((uint32_t)(((uint32_t)(x)) << IOPCTL_PIO_FSEL_SHIFT)) & IOPCTL_PIO_FSEL_MASK)

#define IOPCTL_PIO_PUPDENA_MASK                  (0x10U)
#define IOPCTL_PIO_PUPDENA_SHIFT                 (4U)
/*! PUPDENA - Pullup / Pulldown Enable. . .
 *  0b0..Disable.
 *  0b1..Enable.
 */
#define IOPCTL_PIO_PUPDENA(x)                    (((uint32_t)(((uint32_t)(x)) << IOPCTL_PIO_PUPDENA_SHIFT)) & IOPCTL_PIO_PUPDENA_MASK)

#define IOPCTL_PIO_PUPDSEL_MASK                  (0x20U)
#define IOPCTL_PIO_PUPDSEL_SHIFT                 (5U)
/*! PUPDSEL - Pullup or Pulldown Selector. . .
 *  0b0..Pull-down.
 *  0b1..Pull-up.
 */
#define IOPCTL_PIO_PUPDSEL(x)                    (((uint32_t)(((uint32_t)(x)) << IOPCTL_PIO_PUPDSEL_SHIFT)) & IOPCTL_PIO_PUPDSEL_MASK)

#define IOPCTL_PIO_IBENA_MASK                    (0x40U)
#define IOPCTL_PIO_IBENA_SHIFT                   (6U)
/*! IBENA - Input Buffer Enable. .
 *  0b0..Disable.
 *  0b1..Enable.
 */
#define IOPCTL_PIO_IBENA(x)                      (((uint32_t)(((uint32_t)(x)) << IOPCTL_PIO_IBENA_SHIFT)) & IOPCTL_PIO_IBENA_MASK)

#define IOPCTL_PIO_SLEWRATE_MASK                 (0x80U)
#define IOPCTL_PIO_SLEWRATE_SHIFT                (7U)
/*! SLEWRATE - Slew Rate Control. . .
 *  0b0..Slew Rate is Normal.
 *  0b1..Slew Rate Slow.
 */
#define IOPCTL_PIO_SLEWRATE(x)                   (((uint32_t)(((uint32_t)(x)) << IOPCTL_PIO_SLEWRATE_SHIFT)) & IOPCTL_PIO_SLEWRATE_MASK)

#define IOPCTL_PIO_FULLDRIVE_MASK                (0x100U)
#define IOPCTL_PIO_FULLDRIVE_SHIFT               (8U)
/*! FULLDRIVE - Drive Selector. . .
 *  0b0..Normal Drive.
 *  0b1..Full Drive.
 */
#define IOPCTL_PIO_FULLDRIVE(x)                  (((uint32_t)(((uint32_t)(x)) << IOPCTL_PIO_FULLDRIVE_SHIFT)) & IOPCTL_PIO_FULLDRIVE_MASK)

#define IOPCTL_PIO_AMENA_MASK                    (0x200U)
#define IOPCTL_PIO_AMENA_SHIFT                   (9U)
/*! AMENA - Analog Mux Enable. . .
 *  0b0..Disable.
 *  0b1..Enable.
 */
#define IOPCTL_PIO_AMENA(x)                      (((uint32_t)(((uint32_t)(x)) << IOPCTL_PIO_AMENA_SHIFT)) & IOPCTL_PIO_AMENA_MASK)

#define IOPCTL_PIO_ODENA_MASK                    (0x400U)
#define IOPCTL_PIO_ODENA_SHIFT                   (10U)
/*! ODENA - Pseudo Output Drain Enable. . .
 *  0b0..Disable.
 *  0b1..Enable.
 */
#define IOPCTL_PIO_ODENA(x)                      (((uint32_t)(((uint32_t)(x)) << IOPCTL_PIO_ODENA_SHIFT)) & IOPCTL_PIO_ODENA_MASK)

#define IOPCTL_PIO_IIENA_MASK                    (0x800U)
#define IOPCTL_PIO_IIENA_SHIFT                   (11U)
/*! IIENA - Input Invert Enable. . .
 *  0b0..Disable.
 *  0b1..Enable.
 */
#define IOPCTL_PIO_IIENA(x)                      (((uint32_t)(((uint32_t)(x)) << IOPCTL_PIO_IIENA_SHIFT)) & IOPCTL_PIO_IIENA_MASK)
/*! @} */

/* The count of IOPCTL_PIO */
#define IOPCTL_PIO_COUNT                         (8U)

/* The count of IOPCTL_PIO */
#define IOPCTL_PIO_COUNT2                        (32U)

/*! @name FC15_I2C_SCL - Special Registers (No GPIO Function) */
/*! @{ */

#define IOPCTL_FC15_I2C_SCL_FSEL_MASK            (0xFU)
#define IOPCTL_FC15_I2C_SCL_FSEL_SHIFT           (0U)
/*! FSEL - Function Selector. . .(FSELs Sources can be found in the next several pages.)
 *  0b0000..Function 0.
 *  0b0001..Function 1.
 *  0b0010..Function 2.
 *  0b0011..Function 3.
 *  0b0100..Function 4.
 *  0b0101..Function 5.
 *  0b0110..Function 6.
 *  0b0111..Function 7.
 *  0b1000..Function 8.
 *  0b1001..Function 9.
 *  0b1010..Function 10.
 *  0b1011..Function 11.
 *  0b1100..Function 12.
 *  0b1101..Function 13.
 *  0b1110..Function 14.
 *  0b1111..Function 15.
 */
#define IOPCTL_FC15_I2C_SCL_FSEL(x)              (((uint32_t)(((uint32_t)(x)) << IOPCTL_FC15_I2C_SCL_FSEL_SHIFT)) & IOPCTL_FC15_I2C_SCL_FSEL_MASK)

#define IOPCTL_FC15_I2C_SCL_PUPDENA_MASK         (0x10U)
#define IOPCTL_FC15_I2C_SCL_PUPDENA_SHIFT        (4U)
/*! PUPDENA - Pullup / Pulldown Enable. . .
 *  0b0..Disable.
 *  0b1..Enable.
 */
#define IOPCTL_FC15_I2C_SCL_PUPDENA(x)           (((uint32_t)(((uint32_t)(x)) << IOPCTL_FC15_I2C_SCL_PUPDENA_SHIFT)) & IOPCTL_FC15_I2C_SCL_PUPDENA_MASK)

#define IOPCTL_FC15_I2C_SCL_PUPDSEL_MASK         (0x20U)
#define IOPCTL_FC15_I2C_SCL_PUPDSEL_SHIFT        (5U)
/*! PUPDSEL - Pullup or Pulldown Selector. . .
 *  0b0..Pull-down.
 *  0b1..Pull-up.
 */
#define IOPCTL_FC15_I2C_SCL_PUPDSEL(x)           (((uint32_t)(((uint32_t)(x)) << IOPCTL_FC15_I2C_SCL_PUPDSEL_SHIFT)) & IOPCTL_FC15_I2C_SCL_PUPDSEL_MASK)

#define IOPCTL_FC15_I2C_SCL_IBENA_MASK           (0x40U)
#define IOPCTL_FC15_I2C_SCL_IBENA_SHIFT          (6U)
/*! IBENA - Input Buffer Enable. .
 *  0b0..Disable.
 *  0b1..Enable.
 */
#define IOPCTL_FC15_I2C_SCL_IBENA(x)             (((uint32_t)(((uint32_t)(x)) << IOPCTL_FC15_I2C_SCL_IBENA_SHIFT)) & IOPCTL_FC15_I2C_SCL_IBENA_MASK)

#define IOPCTL_FC15_I2C_SCL_SLEWRATE_MASK        (0x80U)
#define IOPCTL_FC15_I2C_SCL_SLEWRATE_SHIFT       (7U)
/*! SLEWRATE - Slew Rate Control. . .
 *  0b0..Slew Rate is Normal.
 *  0b1..Slew Rate Slow.
 */
#define IOPCTL_FC15_I2C_SCL_SLEWRATE(x)          (((uint32_t)(((uint32_t)(x)) << IOPCTL_FC15_I2C_SCL_SLEWRATE_SHIFT)) & IOPCTL_FC15_I2C_SCL_SLEWRATE_MASK)

#define IOPCTL_FC15_I2C_SCL_FULLDRIVE_MASK       (0x100U)
#define IOPCTL_FC15_I2C_SCL_FULLDRIVE_SHIFT      (8U)
/*! FULLDRIVE - Drive Selector. . .
 *  0b0..Normal Drive.
 *  0b1..Full Drive.
 */
#define IOPCTL_FC15_I2C_SCL_FULLDRIVE(x)         (((uint32_t)(((uint32_t)(x)) << IOPCTL_FC15_I2C_SCL_FULLDRIVE_SHIFT)) & IOPCTL_FC15_I2C_SCL_FULLDRIVE_MASK)

#define IOPCTL_FC15_I2C_SCL_AMENA_MASK           (0x200U)
#define IOPCTL_FC15_I2C_SCL_AMENA_SHIFT          (9U)
/*! AMENA - Analog Mux Enable. . .
 *  0b0..Disable.
 *  0b1..Enable.
 */
#define IOPCTL_FC15_I2C_SCL_AMENA(x)             (((uint32_t)(((uint32_t)(x)) << IOPCTL_FC15_I2C_SCL_AMENA_SHIFT)) & IOPCTL_FC15_I2C_SCL_AMENA_MASK)

#define IOPCTL_FC15_I2C_SCL_ODENA_MASK           (0x400U)
#define IOPCTL_FC15_I2C_SCL_ODENA_SHIFT          (10U)
/*! ODENA - Pseudo Output Drain Enable. . .
 *  0b0..Disable.
 *  0b1..Enable.
 */
#define IOPCTL_FC15_I2C_SCL_ODENA(x)             (((uint32_t)(((uint32_t)(x)) << IOPCTL_FC15_I2C_SCL_ODENA_SHIFT)) & IOPCTL_FC15_I2C_SCL_ODENA_MASK)

#define IOPCTL_FC15_I2C_SCL_IIENA_MASK           (0x800U)
#define IOPCTL_FC15_I2C_SCL_IIENA_SHIFT          (11U)
/*! IIENA - Input Invert Enable. . .
 *  0b0..Disable.
 *  0b1..Enable.
 */
#define IOPCTL_FC15_I2C_SCL_IIENA(x)             (((uint32_t)(((uint32_t)(x)) << IOPCTL_FC15_I2C_SCL_IIENA_SHIFT)) & IOPCTL_FC15_I2C_SCL_IIENA_MASK)
/*! @} */

/*! @name FC15_I2C_SDA - Special Registers (No GPIO Function) */
/*! @{ */

#define IOPCTL_FC15_I2C_SDA_FSEL_MASK            (0xFU)
#define IOPCTL_FC15_I2C_SDA_FSEL_SHIFT           (0U)
/*! FSEL - Function Selector. . .(FSELs Sources can be found in the next several pages.)
 *  0b0000..Function 0.
 *  0b0001..Function 1.
 *  0b0010..Function 2.
 *  0b0011..Function 3.
 *  0b0100..Function 4.
 *  0b0101..Function 5.
 *  0b0110..Function 6.
 *  0b0111..Function 7.
 *  0b1000..Function 8.
 *  0b1001..Function 9.
 *  0b1010..Function 10.
 *  0b1011..Function 11.
 *  0b1100..Function 12.
 *  0b1101..Function 13.
 *  0b1110..Function 14.
 *  0b1111..Function 15.
 */
#define IOPCTL_FC15_I2C_SDA_FSEL(x)              (((uint32_t)(((uint32_t)(x)) << IOPCTL_FC15_I2C_SDA_FSEL_SHIFT)) & IOPCTL_FC15_I2C_SDA_FSEL_MASK)

#define IOPCTL_FC15_I2C_SDA_PUPDENA_MASK         (0x10U)
#define IOPCTL_FC15_I2C_SDA_PUPDENA_SHIFT        (4U)
/*! PUPDENA - Pullup / Pulldown Enable. . .
 *  0b0..Disable.
 *  0b1..Enable.
 */
#define IOPCTL_FC15_I2C_SDA_PUPDENA(x)           (((uint32_t)(((uint32_t)(x)) << IOPCTL_FC15_I2C_SDA_PUPDENA_SHIFT)) & IOPCTL_FC15_I2C_SDA_PUPDENA_MASK)

#define IOPCTL_FC15_I2C_SDA_PUPDSEL_MASK         (0x20U)
#define IOPCTL_FC15_I2C_SDA_PUPDSEL_SHIFT        (5U)
/*! PUPDSEL - Pullup or Pulldown Selector. . .
 *  0b0..Pull-down.
 *  0b1..Pull-up.
 */
#define IOPCTL_FC15_I2C_SDA_PUPDSEL(x)           (((uint32_t)(((uint32_t)(x)) << IOPCTL_FC15_I2C_SDA_PUPDSEL_SHIFT)) & IOPCTL_FC15_I2C_SDA_PUPDSEL_MASK)

#define IOPCTL_FC15_I2C_SDA_IBENA_MASK           (0x40U)
#define IOPCTL_FC15_I2C_SDA_IBENA_SHIFT          (6U)
/*! IBENA - Input Buffer Enable. .
 *  0b0..Disable.
 *  0b1..Enable.
 */
#define IOPCTL_FC15_I2C_SDA_IBENA(x)             (((uint32_t)(((uint32_t)(x)) << IOPCTL_FC15_I2C_SDA_IBENA_SHIFT)) & IOPCTL_FC15_I2C_SDA_IBENA_MASK)

#define IOPCTL_FC15_I2C_SDA_SLEWRATE_MASK        (0x80U)
#define IOPCTL_FC15_I2C_SDA_SLEWRATE_SHIFT       (7U)
/*! SLEWRATE - Slew Rate Control. . .
 *  0b0..Slew Rate is Normal.
 *  0b1..Slew Rate Slow.
 */
#define IOPCTL_FC15_I2C_SDA_SLEWRATE(x)          (((uint32_t)(((uint32_t)(x)) << IOPCTL_FC15_I2C_SDA_SLEWRATE_SHIFT)) & IOPCTL_FC15_I2C_SDA_SLEWRATE_MASK)

#define IOPCTL_FC15_I2C_SDA_FULLDRIVE_MASK       (0x100U)
#define IOPCTL_FC15_I2C_SDA_FULLDRIVE_SHIFT      (8U)
/*! FULLDRIVE - Drive Selector. . .
 *  0b0..Normal Drive.
 *  0b1..Full Drive.
 */
#define IOPCTL_FC15_I2C_SDA_FULLDRIVE(x)         (((uint32_t)(((uint32_t)(x)) << IOPCTL_FC15_I2C_SDA_FULLDRIVE_SHIFT)) & IOPCTL_FC15_I2C_SDA_FULLDRIVE_MASK)

#define IOPCTL_FC15_I2C_SDA_AMENA_MASK           (0x200U)
#define IOPCTL_FC15_I2C_SDA_AMENA_SHIFT          (9U)
/*! AMENA - Analog Mux Enable. . .
 *  0b0..Disable.
 *  0b1..Enable.
 */
#define IOPCTL_FC15_I2C_SDA_AMENA(x)             (((uint32_t)(((uint32_t)(x)) << IOPCTL_FC15_I2C_SDA_AMENA_SHIFT)) & IOPCTL_FC15_I2C_SDA_AMENA_MASK)

#define IOPCTL_FC15_I2C_SDA_ODENA_MASK           (0x400U)
#define IOPCTL_FC15_I2C_SDA_ODENA_SHIFT          (10U)
/*! ODENA - Pseudo Output Drain Enable. . .
 *  0b0..Disable.
 *  0b1..Enable.
 */
#define IOPCTL_FC15_I2C_SDA_ODENA(x)             (((uint32_t)(((uint32_t)(x)) << IOPCTL_FC15_I2C_SDA_ODENA_SHIFT)) & IOPCTL_FC15_I2C_SDA_ODENA_MASK)

#define IOPCTL_FC15_I2C_SDA_IIENA_MASK           (0x800U)
#define IOPCTL_FC15_I2C_SDA_IIENA_SHIFT          (11U)
/*! IIENA - Input Invert Enable. . .
 *  0b0..Disable.
 *  0b1..Enable.
 */
#define IOPCTL_FC15_I2C_SDA_IIENA(x)             (((uint32_t)(((uint32_t)(x)) << IOPCTL_FC15_I2C_SDA_IIENA_SHIFT)) & IOPCTL_FC15_I2C_SDA_IIENA_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group IOPCTL_Register_Masks */


/* IOPCTL - Peripheral instance base addresses */
/** Peripheral IOPCTL base address */
#define IOPCTL_BASE                              (0x40004000u)
/** Peripheral IOPCTL base pointer */
#define IOPCTL                                   ((IOPCTL_Type *)IOPCTL_BASE)
/** Array initializer of IOPCTL peripheral base addresses */
#define IOPCTL_BASE_ADDRS                        { IOPCTL_BASE }
/** Array initializer of IOPCTL peripheral base pointers */
#define IOPCTL_BASE_PTRS                         { IOPCTL }

/*!
 * @}
 */ /* end of group IOPCTL_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- MRT Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup MRT_Peripheral_Access_Layer MRT Peripheral Access Layer
 * @{
 */

/** MRT - Register Layout Typedef */
typedef struct {
  struct {                                         /* offset: 0x0, array step: 0x10 */
    __IO uint32_t INTVAL;                            /**< MRT Time interval value register. This value is loaded into the TIMER register., array offset: 0x0, array step: 0x10 */
    __I  uint32_t TIMER;                             /**< MRT Timer register. This register reads the value of the down-counter., array offset: 0x4, array step: 0x10 */
    __IO uint32_t CTRL;                              /**< MRT Control register. This register controls the MRT modes., array offset: 0x8, array step: 0x10 */
    __IO uint32_t STAT;                              /**< MRT Status register., array offset: 0xC, array step: 0x10 */
  } CHANNEL[4];
       uint8_t RESERVED_0[176];
  __IO uint32_t MODCFG;                            /**< Module Configuration register. This register provides information about this particular MRT instance, and allows choosing an overall mode for the idle channel feature., offset: 0xF0 */
  __I  uint32_t IDLE_CH;                           /**< Idle channel register. This register returns the number of the first idle channel., offset: 0xF4 */
  __IO uint32_t IRQ_FLAG;                          /**< Global interrupt flag register, offset: 0xF8 */
} MRT_Type;

/* ----------------------------------------------------------------------------
   -- MRT Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup MRT_Register_Masks MRT Register Masks
 * @{
 */

/*! @name CHANNEL_INTVAL - MRT Time interval value register. This value is loaded into the TIMER register. */
/*! @{ */

#define MRT_CHANNEL_INTVAL_IVALUE_MASK           (0xFFFFFFU)
#define MRT_CHANNEL_INTVAL_IVALUE_SHIFT          (0U)
/*! IVALUE - Time interval load value. This value is loaded into the TIMERn register and the MRT
 *    channel n starts counting down from IVALUE -1. If the timer is idle, writing a non-zero value to
 *    this bit field starts the timer immediately. If the timer is running, writing a zero to this
 *    bit field does the following: If LOAD = 1, the timer stops immediately. If LOAD = 0, the timer
 *    stops at the end of the time interval.
 */
#define MRT_CHANNEL_INTVAL_IVALUE(x)             (((uint32_t)(((uint32_t)(x)) << MRT_CHANNEL_INTVAL_IVALUE_SHIFT)) & MRT_CHANNEL_INTVAL_IVALUE_MASK)

#define MRT_CHANNEL_INTVAL_LOAD_MASK             (0x80000000U)
#define MRT_CHANNEL_INTVAL_LOAD_SHIFT            (31U)
/*! LOAD - Determines how the timer interval value IVALUE -1 is loaded into the TIMERn register.
 *    This bit is write-only. Reading this bit always returns 0.
 *  0b0..No force load. The load from the INTVALn register to the TIMERn register is processed at the end of the
 *       time interval if the repeat mode is selected.
 *  0b1..Force load. The INTVALn interval value IVALUE -1 is immediately loaded into the TIMERn register while TIMERn is running.
 */
#define MRT_CHANNEL_INTVAL_LOAD(x)               (((uint32_t)(((uint32_t)(x)) << MRT_CHANNEL_INTVAL_LOAD_SHIFT)) & MRT_CHANNEL_INTVAL_LOAD_MASK)
/*! @} */

/* The count of MRT_CHANNEL_INTVAL */
#define MRT_CHANNEL_INTVAL_COUNT                 (4U)

/*! @name CHANNEL_TIMER - MRT Timer register. This register reads the value of the down-counter. */
/*! @{ */

#define MRT_CHANNEL_TIMER_VALUE_MASK             (0xFFFFFFU)
#define MRT_CHANNEL_TIMER_VALUE_SHIFT            (0U)
/*! VALUE - Holds the current timer value of the down-counter. The initial value of the TIMERn
 *    register is loaded as IVALUE - 1 from the INTVALn register either at the end of the time interval
 *    or immediately in the following cases: INTVALn register is updated in the idle state. INTVALn
 *    register is updated with LOAD = 1. When the timer is in idle state, reading this bit fields
 *    returns -1 (0x00FF FFFF).
 */
#define MRT_CHANNEL_TIMER_VALUE(x)               (((uint32_t)(((uint32_t)(x)) << MRT_CHANNEL_TIMER_VALUE_SHIFT)) & MRT_CHANNEL_TIMER_VALUE_MASK)
/*! @} */

/* The count of MRT_CHANNEL_TIMER */
#define MRT_CHANNEL_TIMER_COUNT                  (4U)

/*! @name CHANNEL_CTRL - MRT Control register. This register controls the MRT modes. */
/*! @{ */

#define MRT_CHANNEL_CTRL_INTEN_MASK              (0x1U)
#define MRT_CHANNEL_CTRL_INTEN_SHIFT             (0U)
/*! INTEN - Enable the TIMERn interrupt.
 *  0b0..Disabled. TIMERn interrupt is disabled.
 *  0b1..Enabled. TIMERn interrupt is enabled.
 */
#define MRT_CHANNEL_CTRL_INTEN(x)                (((uint32_t)(((uint32_t)(x)) << MRT_CHANNEL_CTRL_INTEN_SHIFT)) & MRT_CHANNEL_CTRL_INTEN_MASK)

#define MRT_CHANNEL_CTRL_MODE_MASK               (0x6U)
#define MRT_CHANNEL_CTRL_MODE_SHIFT              (1U)
/*! MODE - Selects timer mode.
 *  0b00..Repeat interrupt mode.
 *  0b01..One-shot interrupt mode.
 *  0b10..One-shot stall mode.
 *  0b11..Reserved.
 */
#define MRT_CHANNEL_CTRL_MODE(x)                 (((uint32_t)(((uint32_t)(x)) << MRT_CHANNEL_CTRL_MODE_SHIFT)) & MRT_CHANNEL_CTRL_MODE_MASK)
/*! @} */

/* The count of MRT_CHANNEL_CTRL */
#define MRT_CHANNEL_CTRL_COUNT                   (4U)

/*! @name CHANNEL_STAT - MRT Status register. */
/*! @{ */

#define MRT_CHANNEL_STAT_INTFLAG_MASK            (0x1U)
#define MRT_CHANNEL_STAT_INTFLAG_SHIFT           (0U)
/*! INTFLAG - Monitors the interrupt flag.
 *  0b0..No pending interrupt. Writing a zero is equivalent to no operation.
 *  0b1..Pending interrupt. The interrupt is pending because TIMERn has reached the end of the time interval. If
 *       the INTEN bit in the CONTROLn is also set to 1, the interrupt for timer channel n and the global interrupt
 *       are raised. Writing a 1 to this bit clears the interrupt request.
 */
#define MRT_CHANNEL_STAT_INTFLAG(x)              (((uint32_t)(((uint32_t)(x)) << MRT_CHANNEL_STAT_INTFLAG_SHIFT)) & MRT_CHANNEL_STAT_INTFLAG_MASK)

#define MRT_CHANNEL_STAT_RUN_MASK                (0x2U)
#define MRT_CHANNEL_STAT_RUN_SHIFT               (1U)
/*! RUN - Indicates the state of TIMERn. This bit is read-only.
 *  0b0..Idle state. TIMERn is stopped.
 *  0b1..Running. TIMERn is running.
 */
#define MRT_CHANNEL_STAT_RUN(x)                  (((uint32_t)(((uint32_t)(x)) << MRT_CHANNEL_STAT_RUN_SHIFT)) & MRT_CHANNEL_STAT_RUN_MASK)

#define MRT_CHANNEL_STAT_INUSE_MASK              (0x4U)
#define MRT_CHANNEL_STAT_INUSE_SHIFT             (2U)
/*! INUSE - Channel In Use flag. Operating details depend on the MULTITASK bit in the MODCFG
 *    register, and affects the use of IDLE_CH. See Idle channel register for details of the two operating
 *    modes.
 *  0b0..This channel is not in use.
 *  0b1..This channel is in use.
 */
#define MRT_CHANNEL_STAT_INUSE(x)                (((uint32_t)(((uint32_t)(x)) << MRT_CHANNEL_STAT_INUSE_SHIFT)) & MRT_CHANNEL_STAT_INUSE_MASK)
/*! @} */

/* The count of MRT_CHANNEL_STAT */
#define MRT_CHANNEL_STAT_COUNT                   (4U)

/*! @name MODCFG - Module Configuration register. This register provides information about this particular MRT instance, and allows choosing an overall mode for the idle channel feature. */
/*! @{ */

#define MRT_MODCFG_NOC_MASK                      (0xFU)
#define MRT_MODCFG_NOC_SHIFT                     (0U)
/*! NOC - Identifies the number of channels in this MRT.(4 channels on this device.)
 */
#define MRT_MODCFG_NOC(x)                        (((uint32_t)(((uint32_t)(x)) << MRT_MODCFG_NOC_SHIFT)) & MRT_MODCFG_NOC_MASK)

#define MRT_MODCFG_NOB_MASK                      (0x1F0U)
#define MRT_MODCFG_NOB_SHIFT                     (4U)
/*! NOB - Identifies the number of timer bits in this MRT. (24 bits wide on this device.)
 */
#define MRT_MODCFG_NOB(x)                        (((uint32_t)(((uint32_t)(x)) << MRT_MODCFG_NOB_SHIFT)) & MRT_MODCFG_NOB_MASK)

#define MRT_MODCFG_MULTITASK_MASK                (0x80000000U)
#define MRT_MODCFG_MULTITASK_SHIFT               (31U)
/*! MULTITASK - Selects the operating mode for the INUSE flags and the IDLE_CH register.
 *  0b0..Hardware status mode. In this mode, the INUSE(n) flags for all channels are reset.
 *  0b1..Multi-task mode.
 */
#define MRT_MODCFG_MULTITASK(x)                  (((uint32_t)(((uint32_t)(x)) << MRT_MODCFG_MULTITASK_SHIFT)) & MRT_MODCFG_MULTITASK_MASK)
/*! @} */

/*! @name IDLE_CH - Idle channel register. This register returns the number of the first idle channel. */
/*! @{ */

#define MRT_IDLE_CH_CHAN_MASK                    (0xF0U)
#define MRT_IDLE_CH_CHAN_SHIFT                   (4U)
/*! CHAN - Idle channel. Reading the CHAN bits, returns the lowest idle timer channel. The number is
 *    positioned such that it can be used as an offset from the MRT base address in order to access
 *    the registers for the allocated channel. If all timer channels are running, CHAN = 0xF. See
 *    text above for more details.
 */
#define MRT_IDLE_CH_CHAN(x)                      (((uint32_t)(((uint32_t)(x)) << MRT_IDLE_CH_CHAN_SHIFT)) & MRT_IDLE_CH_CHAN_MASK)
/*! @} */

/*! @name IRQ_FLAG - Global interrupt flag register */
/*! @{ */

#define MRT_IRQ_FLAG_GFLAG0_MASK                 (0x1U)
#define MRT_IRQ_FLAG_GFLAG0_SHIFT                (0U)
/*! GFLAG0 - Monitors the interrupt flag of TIMER0.
 *  0b0..No pending interrupt. Writing a zero is equivalent to no operation.
 *  0b1..Pending interrupt. The interrupt is pending because TIMER0 has reached the end of the time interval. If
 *       the INTEN bit in the CONTROL0 register is also set to 1, the interrupt for timer channel 0 and the global
 *       interrupt are raised. Writing a 1 to this bit clears the interrupt request.
 */
#define MRT_IRQ_FLAG_GFLAG0(x)                   (((uint32_t)(((uint32_t)(x)) << MRT_IRQ_FLAG_GFLAG0_SHIFT)) & MRT_IRQ_FLAG_GFLAG0_MASK)

#define MRT_IRQ_FLAG_GFLAG1_MASK                 (0x2U)
#define MRT_IRQ_FLAG_GFLAG1_SHIFT                (1U)
/*! GFLAG1 - Monitors the interrupt flag of TIMER1. See description of channel 0.
 */
#define MRT_IRQ_FLAG_GFLAG1(x)                   (((uint32_t)(((uint32_t)(x)) << MRT_IRQ_FLAG_GFLAG1_SHIFT)) & MRT_IRQ_FLAG_GFLAG1_MASK)

#define MRT_IRQ_FLAG_GFLAG2_MASK                 (0x4U)
#define MRT_IRQ_FLAG_GFLAG2_SHIFT                (2U)
/*! GFLAG2 - Monitors the interrupt flag of TIMER2. See description of channel 0.
 */
#define MRT_IRQ_FLAG_GFLAG2(x)                   (((uint32_t)(((uint32_t)(x)) << MRT_IRQ_FLAG_GFLAG2_SHIFT)) & MRT_IRQ_FLAG_GFLAG2_MASK)

#define MRT_IRQ_FLAG_GFLAG3_MASK                 (0x8U)
#define MRT_IRQ_FLAG_GFLAG3_SHIFT                (3U)
/*! GFLAG3 - Monitors the interrupt flag of TIMER3. See description of channel 0.
 */
#define MRT_IRQ_FLAG_GFLAG3(x)                   (((uint32_t)(((uint32_t)(x)) << MRT_IRQ_FLAG_GFLAG3_SHIFT)) & MRT_IRQ_FLAG_GFLAG3_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group MRT_Register_Masks */


/* MRT - Peripheral instance base addresses */
/** Peripheral MRT0 base address */
#define MRT0_BASE                                (0x4002D000u)
/** Peripheral MRT0 base pointer */
#define MRT0                                     ((MRT_Type *)MRT0_BASE)
/** Array initializer of MRT peripheral base addresses */
#define MRT_BASE_ADDRS                           { MRT0_BASE }
/** Array initializer of MRT peripheral base pointers */
#define MRT_BASE_PTRS                            { MRT0 }
/** Interrupt vectors for the MRT peripheral type */
#define MRT_IRQS                                 { MRT0_IRQn }

/*!
 * @}
 */ /* end of group MRT_Peripheral_Access_Layer */

/*!
 * @brief Power mode definition.
 */
typedef enum _mu_power_mode
{
    kMU_PowerModeRun = 0x00U,   /*!< Run mode.           */
    kMU_PowerModeWait  = 0x01U, /*!< WAIT mode.          */
    kMU_PowerModeStop  = 0x02U, /*!< STOP/VLPS mode.     */
} mu_power_mode_t;


/* ----------------------------------------------------------------------------
   -- MU Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup MU_Peripheral_Access_Layer MU Peripheral Access Layer
 * @{
 */

/** MU - Register Layout Typedef */
typedef struct {
  __I  uint32_t VER;                               /**< Version ID Register, offset: 0x0 */
  __I  uint32_t PAR;                               /**< Use Parameter register to determine the parameter settings of MUA., offset: 0x4 */
       uint8_t RESERVED_0[24];
  __IO uint32_t TR[4];                             /**< Transmit Register, array offset: 0x20, array step: 0x4 */
       uint8_t RESERVED_1[16];
  __IO uint32_t RR[4];                             /**< Receive Register., array offset: 0x40, array step: 0x4 */
       uint8_t RESERVED_2[16];
  __IO uint32_t SR;                                /**< Status Register, offset: 0x60 */
  __IO uint32_t CR;                                /**< Control Register, offset: 0x64 */
} MU_Type;

/* ----------------------------------------------------------------------------
   -- MU Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup MU_Register_Masks MU Register Masks
 * @{
 */

/*! @name VER - Version ID Register */
/*! @{ */

#define MU_VER_FEATURE_MASK                      (0xFFFFU)
#define MU_VER_FEATURE_SHIFT                     (0U)
/*! FEATURE - Feature Specification Number
 *  0b0000000000000000..Standard features implemented
 *  0b0000000000000001..RAIP and RAIE register bits implemented on MUA side
 *  0b0000000000000010..MUA and MUB implemented with the same function. some bits in CR register are moved to CCR register.
 *  0b0000000000000100..some sync logic are deleted for synchronized MUA and MUB. RAIP and RDIP monitor Core reset
 *                      instead of MU reset. Add HRIP and MURIP and their interrupt enable bits on both sides.
 *                      Delete RS bit. Add COO mode in PM state.
 */
#define MU_VER_FEATURE(x)                        (((uint32_t)(((uint32_t)(x)) << MU_VER_FEATURE_SHIFT)) & MU_VER_FEATURE_MASK)

#define MU_VER_MINOR_MASK                        (0xFF0000U)
#define MU_VER_MINOR_SHIFT                       (16U)
/*! MINOR - Minor Version Number
 */
#define MU_VER_MINOR(x)                          (((uint32_t)(((uint32_t)(x)) << MU_VER_MINOR_SHIFT)) & MU_VER_MINOR_MASK)

#define MU_VER_MAJOR_MASK                        (0xFF000000U)
#define MU_VER_MAJOR_SHIFT                       (24U)
/*! MAJOR - Major Version Number
 */
#define MU_VER_MAJOR(x)                          (((uint32_t)(((uint32_t)(x)) << MU_VER_MAJOR_SHIFT)) & MU_VER_MAJOR_MASK)
/*! @} */

/*! @name PAR - Use Parameter register to determine the parameter settings of MUA. */
/*! @{ */

#define MU_PAR_PARAMETER_MASK                    (0xFFFFFFFFU)
#define MU_PAR_PARAMETER_SHIFT                   (0U)
#define MU_PAR_PARAMETER(x)                      (((uint32_t)(((uint32_t)(x)) << MU_PAR_PARAMETER_SHIFT)) & MU_PAR_PARAMETER_MASK)
/*! @} */

/*! @name TR - Transmit Register */
/*! @{ */

#define MU_TR_DATA_MASK                          (0xFFFFFFFFU)
#define MU_TR_DATA_SHIFT                         (0U)
/*! DATA - DATA
 */
#define MU_TR_DATA(x)                            (((uint32_t)(((uint32_t)(x)) << MU_TR_DATA_SHIFT)) & MU_TR_DATA_MASK)
/*! @} */

/* The count of MU_TR */
#define MU_TR_COUNT                              (4U)

/*! @name RR - Receive Register. */
/*! @{ */

#define MU_RR_DATA_MASK                          (0xFFFFFFFFU)
#define MU_RR_DATA_SHIFT                         (0U)
/*! DATA - DATA
 */
#define MU_RR_DATA(x)                            (((uint32_t)(((uint32_t)(x)) << MU_RR_DATA_SHIFT)) & MU_RR_DATA_MASK)
/*! @} */

/* The count of MU_RR */
#define MU_RR_COUNT                              (4U)

/*! @name SR - Status Register */
/*! @{ */

#define MU_SR_Fn_MASK                            (0x7U)
#define MU_SR_Fn_SHIFT                           (0U)
/*! Fn - Fn
 *  0b000..MUA Fn bit in the CR register is written 0 (default).
 *  0b001..MUA Fn bit in the CR register is written 1.
 */
#define MU_SR_Fn(x)                              (((uint32_t)(((uint32_t)(x)) << MU_SR_Fn_SHIFT)) & MU_SR_Fn_MASK)

#define MU_SR_EP_MASK                            (0x10U)
#define MU_SR_EP_SHIFT                           (4U)
/*! EP - EP
 *  0b0..The MUB side event is not pending (default).
 *  0b1..The MUB side event is pending.
 */
#define MU_SR_EP(x)                              (((uint32_t)(((uint32_t)(x)) << MU_SR_EP_SHIFT)) & MU_SR_EP_MASK)

#define MU_SR_PM_MASK                            (0x60U)
#define MU_SR_PM_SHIFT                           (5U)
/*! PM - PM
 *  0b00..The MUA processor is in Run Mode.
 *  0b01..The MUA processor is in WAIT Mode.
 */
#define MU_SR_PM(x)                              (((uint32_t)(((uint32_t)(x)) << MU_SR_PM_SHIFT)) & MU_SR_PM_MASK)

#define MU_SR_RS_MASK                            (0x80U)
#define MU_SR_RS_SHIFT                           (7U)
/*! RS - RS
 *  0b0..The MUA side of the MU is not in reset.
 *  0b1..The MUA side of the MU is in reset.
 */
#define MU_SR_RS(x)                              (((uint32_t)(((uint32_t)(x)) << MU_SR_RS_SHIFT)) & MU_SR_RS_MASK)

#define MU_SR_FUP_MASK                           (0x100U)
#define MU_SR_FUP_SHIFT                          (8U)
/*! FUP - FUP
 *  0b0..No flags updated, initiated by the MUB, in progress (default)
 *  0b1..MUB initiated flags update, processing
 */
#define MU_SR_FUP(x)                             (((uint32_t)(((uint32_t)(x)) << MU_SR_FUP_SHIFT)) & MU_SR_FUP_MASK)

#define MU_SR_TEn_MASK                           (0xF00000U)
#define MU_SR_TEn_SHIFT                          (20U)
/*! TEn - TEn
 *  0b0000..MUB TRn register is not empty.
 *  0b0001..MUB TRn register is empty (default).
 */
#define MU_SR_TEn(x)                             (((uint32_t)(((uint32_t)(x)) << MU_SR_TEn_SHIFT)) & MU_SR_TEn_MASK)

#define MU_SR_RFn_MASK                           (0xF000000U)
#define MU_SR_RFn_SHIFT                          (24U)
/*! RFn - RFn
 *  0b0000..MUB RRn register is not full (default).
 *  0b0001..MUB RRn register has received data from MUA TRn register and is ready to be read by the MUB.
 */
#define MU_SR_RFn(x)                             (((uint32_t)(((uint32_t)(x)) << MU_SR_RFn_SHIFT)) & MU_SR_RFn_MASK)

#define MU_SR_GIPn_MASK                          (0xF0000000U)
#define MU_SR_GIPn_SHIFT                         (28U)
/*! GIPn - GIPn
 *  0b0000..MUB general purpose interrupt n is not pending. (default)
 *  0b0001..MUB general purpose interrupt n is pending.
 */
#define MU_SR_GIPn(x)                            (((uint32_t)(((uint32_t)(x)) << MU_SR_GIPn_SHIFT)) & MU_SR_GIPn_MASK)
/*! @} */

/*! @name CR - Control Register */
/*! @{ */

#define MU_CR_Fn_MASK                            (0x7U)
#define MU_CR_Fn_SHIFT                           (0U)
/*! Fn - Fn
 *  0b000..Clears the Fn bit in the SR register.
 *  0b001..Sets the Fn bit in the SR register.
 */
#define MU_CR_Fn(x)                              (((uint32_t)(((uint32_t)(x)) << MU_CR_Fn_SHIFT)) & MU_CR_Fn_MASK)

#define MU_CR_GIRn_MASK                          (0xF0000U)
#define MU_CR_GIRn_SHIFT                         (16U)
/*! GIRn - GIRn
 *  0b0000..MUB General Interrupt n is not requested to the MUA (default).
 *  0b0001..MUB General Interrupt n is requested to the MUA.
 */
#define MU_CR_GIRn(x)                            (((uint32_t)(((uint32_t)(x)) << MU_CR_GIRn_SHIFT)) & MU_CR_GIRn_MASK)

#define MU_CR_TIEn_MASK                          (0xF00000U)
#define MU_CR_TIEn_SHIFT                         (20U)
/*! TIEn - TIEn
 *  0b0000..Disables MUB Transmit Interrupt n. (default)
 *  0b0001..Enables MUB Transmit Interrupt n.
 */
#define MU_CR_TIEn(x)                            (((uint32_t)(((uint32_t)(x)) << MU_CR_TIEn_SHIFT)) & MU_CR_TIEn_MASK)

#define MU_CR_RIEn_MASK                          (0xF000000U)
#define MU_CR_RIEn_SHIFT                         (24U)
/*! RIEn - RIEn
 *  0b0000..Disables MUB Receive Interrupt n. (default)
 *  0b0001..Enables MUB Receive Interrupt n.
 */
#define MU_CR_RIEn(x)                            (((uint32_t)(((uint32_t)(x)) << MU_CR_RIEn_SHIFT)) & MU_CR_RIEn_MASK)

#define MU_CR_GIEn_MASK                          (0xF0000000U)
#define MU_CR_GIEn_SHIFT                         (28U)
/*! GIEn - GIEn
 *  0b0000..Disables MUB General Interrupt n. (default)
 *  0b0001..Enables MUB General Interrupt n.
 */
#define MU_CR_GIEn(x)                            (((uint32_t)(((uint32_t)(x)) << MU_CR_GIEn_SHIFT)) & MU_CR_GIEn_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group MU_Register_Masks */


/* MU - Peripheral instance base addresses */
/** Peripheral MUB base address */
#define MUB_BASE                                 (0x40111000u)
/** Peripheral MUB base pointer */
#define MUB                                      ((MU_Type *)MUB_BASE)
/** Array initializer of MU peripheral base addresses */
#define MU_BASE_ADDRS                            { MUB_BASE }
/** Array initializer of MU peripheral base pointers */
#define MU_BASE_PTRS                             { MUB }
/** Interrupt vectors for the MU peripheral type */
#define MU_IRQS                                  { MU_B_IRQn }

/*!
 * @}
 */ /* end of group MU_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- OCOTP Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup OCOTP_Peripheral_Access_Layer OCOTP Peripheral Access Layer
 * @{
 */

/** OCOTP - Register Layout Typedef */
typedef struct {
  __IO uint32_t OTP_SHADOW[496];                   /**< OTP shadow register N, array offset: 0x0, array step: 0x4 */
       uint8_t RESERVED_0[64];
  __IO uint32_t OTP_CTRL;                          /**< Control/address register, offset: 0x800 */
  __IO uint32_t OTP_PDN;                           /**< Power-down register, offset: 0x804 */
  __I  uint32_t OTP_WRITE_DATA;                    /**< OTP programming data register, offset: 0x808 */
  __IO uint32_t OTP_READ_CTRL;                     /**< OTP read start register, offset: 0x80C */
  __I  uint32_t OTP_READ_DATA;                     /**< OTP read data register, offset: 0x810 */
  __IO uint32_t OTP_CLK_DIV;                       /**< OTP clock divider register, offset: 0x814 */
       uint8_t RESERVED_1[4];
  __IO uint32_t OTP_CRC_ADDR;                      /**< CRC address range register, offset: 0x81C */
  __IO uint32_t OTP_CRC_VALUE;                     /**< CRC result register, offset: 0x820 */
  __IO uint32_t OTP_STATUS;                        /**< Status register, offset: 0x824 */
       uint8_t RESERVED_2[4];
  __I  uint32_t OTP_VERSION;                       /**< VERSION ID register, offset: 0x82C */
} OCOTP_Type;

/* ----------------------------------------------------------------------------
   -- OCOTP Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup OCOTP_Register_Masks OCOTP Register Masks
 * @{
 */

/*! @name OTP_SHADOW - OTP shadow register N */
/*! @{ */

#define OCOTP_OTP_SHADOW_shadow_MASK             (0xFFFFFFFFU)
#define OCOTP_OTP_SHADOW_shadow_SHIFT            (0U)
/*! shadow - OTP shadow register
 */
#define OCOTP_OTP_SHADOW_shadow(x)               (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_SHADOW_shadow_SHIFT)) & OCOTP_OTP_SHADOW_shadow_MASK)
/*! @} */

/* The count of OCOTP_OTP_SHADOW */
#define OCOTP_OTP_SHADOW_COUNT                   (496U)

/*! @name OTP_CTRL - Control/address register */
/*! @{ */

#define OCOTP_OTP_CTRL_ADDR_MASK                 (0x1FFU)
#define OCOTP_OTP_CTRL_ADDR_SHIFT                (0U)
/*! ADDR - OTP word address for read/programming
 */
#define OCOTP_OTP_CTRL_ADDR(x)                   (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_CTRL_ADDR_SHIFT)) & OCOTP_OTP_CTRL_ADDR_MASK)

#define OCOTP_OTP_CTRL_RELOAD_SHADOWS_MASK       (0x800U)
#define OCOTP_OTP_CTRL_RELOAD_SHADOWS_SHIFT      (11U)
/*! RELOAD_SHADOWS - Set to force re-loading the shadow registers (HW/SW capability and LOCK). This
 *    operation will automatically set OTP_STATUS.BUSY. Once the shadow registers have been
 *    re-loaded, OTP_STATUS.BUSY and RELOAD_SHADOWS are automatically cleared by the controller
 */
#define OCOTP_OTP_CTRL_RELOAD_SHADOWS(x)         (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_CTRL_RELOAD_SHADOWS_SHIFT)) & OCOTP_OTP_CTRL_RELOAD_SHADOWS_MASK)

#define OCOTP_OTP_CTRL_CRC_TEST_MASK             (0x1000U)
#define OCOTP_OTP_CTRL_CRC_TEST_SHIFT            (12U)
/*! CRC_TEST - Set to start CRC calculation. This operation will automatically set OTP_STATUS.BUSY.
 *    Once CRC is calculation done, OTP_STATUS.BUSY and CRC_TEST are automatically cleared by the
 *    controller
 */
#define OCOTP_OTP_CTRL_CRC_TEST(x)               (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_CTRL_CRC_TEST_SHIFT)) & OCOTP_OTP_CTRL_CRC_TEST_MASK)

#define OCOTP_OTP_CTRL_WORDLOCK_MASK             (0x8000U)
#define OCOTP_OTP_CTRL_WORDLOCK_SHIFT            (15U)
/*! WORDLOCK - Set to write-lock the fuse word when it's being programming. When programming with
 *    ECC mode, it recommends to set this bit.
 */
#define OCOTP_OTP_CTRL_WORDLOCK(x)               (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_CTRL_WORDLOCK_SHIFT)) & OCOTP_OTP_CTRL_WORDLOCK_MASK)

#define OCOTP_OTP_CTRL_WR_UNLOCK_MASK            (0xFFFF0000U)
#define OCOTP_OTP_CTRL_WR_UNLOCK_SHIFT           (16U)
/*! WR_UNLOCK - Write 0x3E77 to enable OTP write accesses. NOTE: The write operation must be
 *    unlocked for each word by writing 0x3E77 to WR_UNLOCK field. Then writing to OTP_WRITE_DATA register
 *    will automatically start the programming procedure.
 */
#define OCOTP_OTP_CTRL_WR_UNLOCK(x)              (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_CTRL_WR_UNLOCK_SHIFT)) & OCOTP_OTP_CTRL_WR_UNLOCK_MASK)
/*! @} */

/*! @name OTP_PDN - Power-down register */
/*! @{ */

#define OCOTP_OTP_PDN_PDN_MASK                   (0x1U)
#define OCOTP_OTP_PDN_PDN_SHIFT                  (0U)
/*! PDN - This bit indicates the PDN value of OTP memory. Writing 1 to the bit to clear PDN. Writing
 *    0 has no effect. Note: Software need to write 1 to this bit to shut off power of OTP memory
 *    after system power up. At the beginning of every fuse operation, the controller will
 *    automatically turn-on power to the OPT memory. After every fuse operation, software also need to write 1
 *    to this bit to shut off power to the OTP memory to reduce power consumption.
 */
#define OCOTP_OTP_PDN_PDN(x)                     (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_PDN_PDN_SHIFT)) & OCOTP_OTP_PDN_PDN_MASK)
/*! @} */

/*! @name OTP_WRITE_DATA - OTP programming data register */
/*! @{ */

#define OCOTP_OTP_WRITE_DATA_WRITE_DATA_MASK     (0xFFFFFFFFU)
#define OCOTP_OTP_WRITE_DATA_WRITE_DATA_SHIFT    (0U)
/*! WRITE_DATA - Fuse word programming data. After the write operation is unlocked in OTP_CTRL
 *    register, writing data to this register automatically start the programming procedure.
 */
#define OCOTP_OTP_WRITE_DATA_WRITE_DATA(x)       (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_WRITE_DATA_WRITE_DATA_SHIFT)) & OCOTP_OTP_WRITE_DATA_WRITE_DATA_MASK)
/*! @} */

/*! @name OTP_READ_CTRL - OTP read start register */
/*! @{ */

#define OCOTP_OTP_READ_CTRL_READ_MASK            (0x1U)
#define OCOTP_OTP_READ_CTRL_READ_SHIFT           (0U)
#define OCOTP_OTP_READ_CTRL_READ(x)              (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_READ_CTRL_READ_SHIFT)) & OCOTP_OTP_READ_CTRL_READ_MASK)
/*! @} */

/*! @name OTP_READ_DATA - OTP read data register */
/*! @{ */

#define OCOTP_OTP_READ_DATA_READ_DATA_MASK       (0xFFFFFFFFU)
#define OCOTP_OTP_READ_DATA_READ_DATA_SHIFT      (0U)
/*! READ_DATA - Fuse word read data from read operation
 */
#define OCOTP_OTP_READ_DATA_READ_DATA(x)         (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_READ_DATA_READ_DATA_SHIFT)) & OCOTP_OTP_READ_DATA_READ_DATA_MASK)
/*! @} */

/*! @name OTP_CLK_DIV - OTP clock divider register */
/*! @{ */

#define OCOTP_OTP_CLK_DIV_DIV_MASK               (0xFU)
#define OCOTP_OTP_CLK_DIV_DIV_SHIFT              (0U)
/*! DIV - Clock divider value by -1 encoding. It's used to generate the clock to OTP memory
 *    (otp_clk) with apb_clk. The maximum otp_clk frequency is 120Mhz. 0: Divide by 1
 *  0b0000..Divide by 1
 *  0b0001..Divide by 2
 *  0b0010..Divide by 3
 *  0b0011..Divide by 4
 *  0b0100..Divide by 5
 *  0b0101..Divide by 6
 *  0b0110..Divide by 7
 *  0b0111..Divide by 8
 *  0b1000..Divide by 9
 *  0b1001..Divide by 10
 *  0b1010..Divide by 11
 *  0b1011..Divide by 12
 *  0b1100..Divide by 13
 *  0b1101..Divide by 14
 *  0b1110..Divide by 15
 *  0b1111..Divide by 16
 */
#define OCOTP_OTP_CLK_DIV_DIV(x)                 (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_CLK_DIV_DIV_SHIFT)) & OCOTP_OTP_CLK_DIV_DIV_MASK)

#define OCOTP_OTP_CLK_DIV_RESET_MASK             (0x20000000U)
#define OCOTP_OTP_CLK_DIV_RESET_SHIFT            (29U)
/*! RESET - Resets the divider counter. Can be used to make sure a new divider value is used right
 *    away rather than completing the previous count.
 */
#define OCOTP_OTP_CLK_DIV_RESET(x)               (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_CLK_DIV_RESET_SHIFT)) & OCOTP_OTP_CLK_DIV_RESET_MASK)

#define OCOTP_OTP_CLK_DIV_HALT_MASK              (0x40000000U)
#define OCOTP_OTP_CLK_DIV_HALT_SHIFT             (30U)
/*! HALT - Halts the divider counter. The intent is to allow the divider's clock source to be
 *    changed without the risk of a glitch at the output.
 */
#define OCOTP_OTP_CLK_DIV_HALT(x)                (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_CLK_DIV_HALT_SHIFT)) & OCOTP_OTP_CLK_DIV_HALT_MASK)

#define OCOTP_OTP_CLK_DIV_REQFLAG_MASK           (0x80000000U)
#define OCOTP_OTP_CLK_DIV_REQFLAG_SHIFT          (31U)
/*! REQFLAG - Divider status flag. Set when a change is made to the divider value, cleared when the change is complete.
 */
#define OCOTP_OTP_CLK_DIV_REQFLAG(x)             (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_CLK_DIV_REQFLAG_SHIFT)) & OCOTP_OTP_CLK_DIV_REQFLAG_MASK)
/*! @} */

/*! @name OTP_CRC_ADDR - CRC address range register */
/*! @{ */

#define OCOTP_OTP_CRC_ADDR_CRC_START_ADDR_MASK   (0x1FFU)
#define OCOTP_OTP_CRC_ADDR_CRC_START_ADDR_SHIFT  (0U)
/*! CRC_START_ADDR - CRC starting fuse word address
 */
#define OCOTP_OTP_CRC_ADDR_CRC_START_ADDR(x)     (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_CRC_ADDR_CRC_START_ADDR_SHIFT)) & OCOTP_OTP_CRC_ADDR_CRC_START_ADDR_MASK)

#define OCOTP_OTP_CRC_ADDR_CRC_END_ADDR_MASK     (0x1FF000U)
#define OCOTP_OTP_CRC_ADDR_CRC_END_ADDR_SHIFT    (12U)
/*! CRC_END_ADDR - CRC ending fuse word address
 */
#define OCOTP_OTP_CRC_ADDR_CRC_END_ADDR(x)       (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_CRC_ADDR_CRC_END_ADDR_SHIFT)) & OCOTP_OTP_CRC_ADDR_CRC_END_ADDR_MASK)

#define OCOTP_OTP_CRC_ADDR_CRC_REF_ADDR_MASK     (0x7000000U)
#define OCOTP_OTP_CRC_ADDR_CRC_REF_ADDR_SHIFT    (24U)
/*! CRC_REF_ADDR - Specify which of the 8 CRC reference value to use for CRC calculation. When the
 *    CRC result for the fuse data from CRC_START_ADDR to CRC_AND_ADDR and this CRC reference value
 *    is 0, the CRC check passes.
 */
#define OCOTP_OTP_CRC_ADDR_CRC_REF_ADDR(x)       (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_CRC_ADDR_CRC_REF_ADDR_SHIFT)) & OCOTP_OTP_CRC_ADDR_CRC_REF_ADDR_MASK)
/*! @} */

/*! @name OTP_CRC_VALUE - CRC result register */
/*! @{ */

#define OCOTP_OTP_CRC_VALUE_CRC_VALUE_MASK       (0xFFFFFFFFU)
#define OCOTP_OTP_CRC_VALUE_CRC_VALUE_SHIFT      (0U)
/*! CRC_VALUE - The CRC result value. When it is locked, reading from it returns value 32âhBADA_BADA
 */
#define OCOTP_OTP_CRC_VALUE_CRC_VALUE(x)         (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_CRC_VALUE_CRC_VALUE_SHIFT)) & OCOTP_OTP_CRC_VALUE_CRC_VALUE_MASK)
/*! @} */

/*! @name OTP_STATUS - Status register */
/*! @{ */

#define OCOTP_OTP_STATUS_SEC_MASK                (0x200U)
#define OCOTP_OTP_STATUS_SEC_SHIFT               (9U)
/*! SEC - OTP Single Error Corrected status of ECC during read operation. Write 1 to clear.
 */
#define OCOTP_OTP_STATUS_SEC(x)                  (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_STATUS_SEC_SHIFT)) & OCOTP_OTP_STATUS_SEC_MASK)

#define OCOTP_OTP_STATUS_DED_MASK                (0x400U)
#define OCOTP_OTP_STATUS_DED_SHIFT               (10U)
/*! DED - OTP Double Error Detection status of ECC during read operation. Write 1 to clear.
 */
#define OCOTP_OTP_STATUS_DED(x)                  (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_STATUS_DED_SHIFT)) & OCOTP_OTP_STATUS_DED_MASK)

#define OCOTP_OTP_STATUS_LOCKED_MASK             (0x800U)
#define OCOTP_OTP_STATUS_LOCKED_SHIFT            (11U)
/*! LOCKED - OTP LOCKED status during read/write operation. Write 1 to clear.
 */
#define OCOTP_OTP_STATUS_LOCKED(x)               (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_STATUS_LOCKED_SHIFT)) & OCOTP_OTP_STATUS_LOCKED_MASK)

#define OCOTP_OTP_STATUS_PROGFAIL_MASK           (0x1000U)
#define OCOTP_OTP_STATUS_PROGFAIL_SHIFT          (12U)
/*! PROGFAIL - OTP PROGFAIL status. Write 1 to clear.
 */
#define OCOTP_OTP_STATUS_PROGFAIL(x)             (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_STATUS_PROGFAIL_SHIFT)) & OCOTP_OTP_STATUS_PROGFAIL_MASK)

#define OCOTP_OTP_STATUS_ACK_MASK                (0x2000U)
#define OCOTP_OTP_STATUS_ACK_SHIFT               (13U)
/*! ACK - OTP ACK value
 */
#define OCOTP_OTP_STATUS_ACK(x)                  (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_STATUS_ACK_SHIFT)) & OCOTP_OTP_STATUS_ACK_MASK)

#define OCOTP_OTP_STATUS_PWOK_MASK               (0x4000U)
#define OCOTP_OTP_STATUS_PWOK_SHIFT              (14U)
/*! PWOK - OTP Power OK status. Indicate that power VDD are in the operating range.
 */
#define OCOTP_OTP_STATUS_PWOK(x)                 (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_STATUS_PWOK_SHIFT)) & OCOTP_OTP_STATUS_PWOK_MASK)

#define OCOTP_OTP_STATUS_SEC_RELOAD_MASK         (0x100000U)
#define OCOTP_OTP_STATUS_SEC_RELOAD_SHIFT        (20U)
/*! SEC_RELOAD - OTP Single Error Corrected status of ECC during reload process. Write 1 to clear.
 */
#define OCOTP_OTP_STATUS_SEC_RELOAD(x)           (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_STATUS_SEC_RELOAD_SHIFT)) & OCOTP_OTP_STATUS_SEC_RELOAD_MASK)

#define OCOTP_OTP_STATUS_DED_RELOAD_MASK         (0x200000U)
#define OCOTP_OTP_STATUS_DED_RELOAD_SHIFT        (21U)
/*! DED_RELOAD - OTP Double Error Detect status of ECC during reload process. Write 1 to clear.
 */
#define OCOTP_OTP_STATUS_DED_RELOAD(x)           (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_STATUS_DED_RELOAD_SHIFT)) & OCOTP_OTP_STATUS_DED_RELOAD_MASK)

#define OCOTP_OTP_STATUS_BUSY_MASK               (0x400000U)
#define OCOTP_OTP_STATUS_BUSY_SHIFT              (22U)
/*! BUSY - OTP controller status bit. When active, no new write or read access to OTP (including
 *    RELOAD_SHADOWS) can be performed. Cleared by the controller when the access completes. After
 *    reset (or after setting RELOAD_SHADOWS), this bit is set by the controller and cleared after all
 *    the shadow registers are successfully loaded.
 */
#define OCOTP_OTP_STATUS_BUSY(x)                 (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_STATUS_BUSY_SHIFT)) & OCOTP_OTP_STATUS_BUSY_MASK)

#define OCOTP_OTP_STATUS_ERROR_MASK              (0x800000U)
#define OCOTP_OTP_STATUS_ERROR_SHIFT             (23U)
/*! ERROR - Set by the controller when a read/write access to a locked region (OTP or shadow
 *    register) is requested. Writing 1 to clear it before any further access can be performed. This bit
 *    can only be set by the controller.
 */
#define OCOTP_OTP_STATUS_ERROR(x)                (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_STATUS_ERROR_SHIFT)) & OCOTP_OTP_STATUS_ERROR_MASK)

#define OCOTP_OTP_STATUS_CRC_FAIL_MASK           (0x1000000U)
#define OCOTP_OTP_STATUS_CRC_FAIL_SHIFT          (24U)
/*! CRC_FAIL - CRC failed when set by hardware for CRC operation. Write 1 to clear.
 */
#define OCOTP_OTP_STATUS_CRC_FAIL(x)             (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_STATUS_CRC_FAIL_SHIFT)) & OCOTP_OTP_STATUS_CRC_FAIL_MASK)

#define OCOTP_OTP_STATUS_FUSE_LATCHED_MASK       (0x2000000U)
#define OCOTP_OTP_STATUS_FUSE_LATCHED_SHIFT      (25U)
/*! FUSE_LATCHED - Indicate all shadows registers have been loaded with their corresponding fuse
 *    words when set by the controller after reset.
 */
#define OCOTP_OTP_STATUS_FUSE_LATCHED(x)         (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_STATUS_FUSE_LATCHED_SHIFT)) & OCOTP_OTP_STATUS_FUSE_LATCHED_MASK)
/*! @} */

/*! @name OTP_VERSION - VERSION ID register */
/*! @{ */

#define OCOTP_OTP_VERSION_STEP_VER_MASK          (0xFFFFU)
#define OCOTP_OTP_VERSION_STEP_VER_SHIFT         (0U)
/*! STEP_VER - OTP controller step version
 */
#define OCOTP_OTP_VERSION_STEP_VER(x)            (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_VERSION_STEP_VER_SHIFT)) & OCOTP_OTP_VERSION_STEP_VER_MASK)

#define OCOTP_OTP_VERSION_MINOR_VER_MASK         (0xFF0000U)
#define OCOTP_OTP_VERSION_MINOR_VER_SHIFT        (16U)
/*! MINOR_VER - OTP controller minor version
 */
#define OCOTP_OTP_VERSION_MINOR_VER(x)           (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_VERSION_MINOR_VER_SHIFT)) & OCOTP_OTP_VERSION_MINOR_VER_MASK)

#define OCOTP_OTP_VERSION_MAJOR_VER_MASK         (0xFF000000U)
#define OCOTP_OTP_VERSION_MAJOR_VER_SHIFT        (24U)
/*! MAJOR_VER - OTP controller major version
 */
#define OCOTP_OTP_VERSION_MAJOR_VER(x)           (((uint32_t)(((uint32_t)(x)) << OCOTP_OTP_VERSION_MAJOR_VER_SHIFT)) & OCOTP_OTP_VERSION_MAJOR_VER_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group OCOTP_Register_Masks */


/* OCOTP - Peripheral instance base addresses */
/** Peripheral OCOTP base address */
#define OCOTP_BASE                               (0x40130000u)
/** Peripheral OCOTP base pointer */
#define OCOTP                                    ((OCOTP_Type *)OCOTP_BASE)
/** Array initializer of OCOTP peripheral base addresses */
#define OCOTP_BASE_ADDRS                         { OCOTP_BASE }
/** Array initializer of OCOTP peripheral base pointers */
#define OCOTP_BASE_PTRS                          { OCOTP }

/*!
 * @}
 */ /* end of group OCOTP_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- OSTIMER Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup OSTIMER_Peripheral_Access_Layer OSTIMER Peripheral Access Layer
 * @{
 */

/** OSTIMER - Register Layout Typedef */
typedef struct {
  __I  uint32_t EVTIMERL;                          /**< EVTIMER Low Register, offset: 0x0 */
  __I  uint32_t EVTIMERH;                          /**< EVTIMER High Register, offset: 0x4 */
  __I  uint32_t CAPTURE_L;                         /**< Local Capture Low Register, offset: 0x8 */
  __I  uint32_t CAPTURE_H;                         /**< Local Capture High Register, offset: 0xC */
  __IO uint32_t MATCH_L;                           /**< Local Match Low Register, offset: 0x10 */
  __IO uint32_t MATCH_H;                           /**< Match High Register, offset: 0x14 */
       uint8_t RESERVED_0[4];
  __IO uint32_t OSEVENT_CTRL;                      /**< OS_EVENT TIMER Control Register, offset: 0x1C */
} OSTIMER_Type;

/* ----------------------------------------------------------------------------
   -- OSTIMER Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup OSTIMER_Register_Masks OSTIMER Register Masks
 * @{
 */

/*! @name EVTIMERL - EVTIMER Low Register */
/*! @{ */

#define OSTIMER_EVTIMERL_EVTIMER_COUNT_VALUE_MASK (0xFFFFFFFFU)
#define OSTIMER_EVTIMERL_EVTIMER_COUNT_VALUE_SHIFT (0U)
/*! EVTIMER_COUNT_VALUE - A read reflects the current value of the lower 32 bits of the EVTIMER.
 *    Note there is physically only one EVTimer, readable from all domains.
 */
#define OSTIMER_EVTIMERL_EVTIMER_COUNT_VALUE(x)  (((uint32_t)(((uint32_t)(x)) << OSTIMER_EVTIMERL_EVTIMER_COUNT_VALUE_SHIFT)) & OSTIMER_EVTIMERL_EVTIMER_COUNT_VALUE_MASK)
/*! @} */

/*! @name EVTIMERH - EVTIMER High Register */
/*! @{ */

#define OSTIMER_EVTIMERH_EVTIMER_COUNT_VALUE_MASK (0xFFFFFFFFU)
#define OSTIMER_EVTIMERH_EVTIMER_COUNT_VALUE_SHIFT (0U)
/*! EVTIMER_COUNT_VALUE - A read reflects the current value of the upper 32 bits of the EVTIMER.
 *    Note there is physically only one EVTimer, readable from all domains.
 */
#define OSTIMER_EVTIMERH_EVTIMER_COUNT_VALUE(x)  (((uint32_t)(((uint32_t)(x)) << OSTIMER_EVTIMERH_EVTIMER_COUNT_VALUE_SHIFT)) & OSTIMER_EVTIMERH_EVTIMER_COUNT_VALUE_MASK)
/*! @} */

/*! @name CAPTURE_L - Local Capture Low Register */
/*! @{ */

#define OSTIMER_CAPTURE_L_CAPTURE_VALUE_MASK     (0xFFFFFFFFU)
#define OSTIMER_CAPTURE_L_CAPTURE_VALUE_SHIFT    (0U)
/*! CAPTURE_VALUE - A read reflects the value of the lower 32 bits of the central EVTIMER at the
 *    time the last capture signal was generated by the CPU. A separate pair of CAPTURE registers are
 *    implemented for each CPU. Each CPU reads its own capture value at the same pair of addresses.
 */
#define OSTIMER_CAPTURE_L_CAPTURE_VALUE(x)       (((uint32_t)(((uint32_t)(x)) << OSTIMER_CAPTURE_L_CAPTURE_VALUE_SHIFT)) & OSTIMER_CAPTURE_L_CAPTURE_VALUE_MASK)
/*! @} */

/*! @name CAPTURE_H - Local Capture High Register */
/*! @{ */

#define OSTIMER_CAPTURE_H_CAPTURE_VALUE_MASK     (0xFFFFFFFFU)
#define OSTIMER_CAPTURE_H_CAPTURE_VALUE_SHIFT    (0U)
/*! CAPTURE_VALUE - A read reflects the value of the upper 32 bits of the central EVTIMER at the
 *    time the last capture signal was generated by the CPU. A separate pair of CAPTURE registers are
 *    implemented for each CPU. Each CPU reads its own capture value at the same pair of addresses.
 */
#define OSTIMER_CAPTURE_H_CAPTURE_VALUE(x)       (((uint32_t)(((uint32_t)(x)) << OSTIMER_CAPTURE_H_CAPTURE_VALUE_SHIFT)) & OSTIMER_CAPTURE_H_CAPTURE_VALUE_MASK)
/*! @} */

/*! @name MATCH_L - Local Match Low Register */
/*! @{ */

#define OSTIMER_MATCH_L_MATCH_VALUE_MASK         (0xFFFFFFFFU)
#define OSTIMER_MATCH_L_MATCH_VALUE_SHIFT        (0U)
/*! MATCH_VALUE - The value written to the MATCH (L/H) register pair is compared against the central
 *    EVTIMER. When a match occurs, an interrupt request is generated if enabled. A separate pair
 *    of MATCH registers are implemented for each CPU. Each CPU reads its own local value at the same
 *    pair of addresses.
 */
#define OSTIMER_MATCH_L_MATCH_VALUE(x)           (((uint32_t)(((uint32_t)(x)) << OSTIMER_MATCH_L_MATCH_VALUE_SHIFT)) & OSTIMER_MATCH_L_MATCH_VALUE_MASK)
/*! @} */

/*! @name MATCH_H - Match High Register */
/*! @{ */

#define OSTIMER_MATCH_H_MATCH_VALUE_MASK         (0xFFFFFFFFU)
#define OSTIMER_MATCH_H_MATCH_VALUE_SHIFT        (0U)
/*! MATCH_VALUE - The value written to the MATCH (L/H) register pair is compared against the central
 *    EVTIMER. When a match occurs, an interrupt request is generated if enabled. A separate pair
 *    of MATCH registers are implemented for each CPU. Each CPU reads its own local value at the same
 *    pair of addresses.
 */
#define OSTIMER_MATCH_H_MATCH_VALUE(x)           (((uint32_t)(((uint32_t)(x)) << OSTIMER_MATCH_H_MATCH_VALUE_SHIFT)) & OSTIMER_MATCH_H_MATCH_VALUE_MASK)
/*! @} */

/*! @name OSEVENT_CTRL - OS_EVENT TIMER Control Register */
/*! @{ */

#define OSTIMER_OSEVENT_CTRL_OSTIMER_INTRFLAG_MASK (0x1U)
#define OSTIMER_OSEVENT_CTRL_OSTIMER_INTRFLAG_SHIFT (0U)
/*! OSTIMER_INTRFLAG - This bit is set when a match occurs between the central 64-bit EVTIMER and
 *    the value programmed in the Match-register pair for the associated CPU This bit is cleared by
 *    writing a '1'. Writes to clear this bit are asynchronous. This should be done before a new match
 *    value is written into the MATCH_L/H registers
 */
#define OSTIMER_OSEVENT_CTRL_OSTIMER_INTRFLAG(x) (((uint32_t)(((uint32_t)(x)) << OSTIMER_OSEVENT_CTRL_OSTIMER_INTRFLAG_SHIFT)) & OSTIMER_OSEVENT_CTRL_OSTIMER_INTRFLAG_MASK)

#define OSTIMER_OSEVENT_CTRL_OSTIMER_INTENA_MASK (0x2U)
#define OSTIMER_OSEVENT_CTRL_OSTIMER_INTENA_SHIFT (1U)
/*! OSTIMER_INTENA - When this bit is '1' an interrupt/wakeup request to the Domainn processor will
 *    be asserted when the OSTIMER_INTR flag is set. When this bit is '0', interrupt/wakeup requests
 *    due to the OSTIMER_INTR flag are blocked.A separate OSEVENT_CTRL register is implemented for
 *    each CPU. Each CPU reads its own local value at the same address.
 */
#define OSTIMER_OSEVENT_CTRL_OSTIMER_INTENA(x)   (((uint32_t)(((uint32_t)(x)) << OSTIMER_OSEVENT_CTRL_OSTIMER_INTENA_SHIFT)) & OSTIMER_OSEVENT_CTRL_OSTIMER_INTENA_MASK)

#define OSTIMER_OSEVENT_CTRL_MATCH_WR_RDY_MASK   (0x4U)
#define OSTIMER_OSEVENT_CTRL_MATCH_WR_RDY_SHIFT  (2U)
/*! MATCH_WR_RDY - This bit will be low when it is safe to write to reload the Match Registers. In
 *    typical applications it should not be necessary to test this bit.
 */
#define OSTIMER_OSEVENT_CTRL_MATCH_WR_RDY(x)     (((uint32_t)(((uint32_t)(x)) << OSTIMER_OSEVENT_CTRL_MATCH_WR_RDY_SHIFT)) & OSTIMER_OSEVENT_CTRL_MATCH_WR_RDY_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group OSTIMER_Register_Masks */


/* OSTIMER - Peripheral instance base addresses */
/** Peripheral OSTIMER1 base address */
#define OSTIMER1_BASE                            (0x40114000u)
/** Peripheral OSTIMER1 base pointer */
#define OSTIMER1                                 ((OSTIMER_Type *)OSTIMER1_BASE)
/** Array initializer of OSTIMER peripheral base addresses */
#define OSTIMER_BASE_ADDRS                       { OSTIMER1_BASE }
/** Array initializer of OSTIMER peripheral base pointers */
#define OSTIMER_BASE_PTRS                        { OSTIMER1 }
/** Interrupt vectors for the OSTIMER peripheral type */
#define OSTIMER_IRQS                             { OS_EVENT_IRQn }

/*!
 * @}
 */ /* end of group OSTIMER_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- OTFAD Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup OTFAD_Peripheral_Access_Layer OTFAD Peripheral Access Layer
 * @{
 */

/** OTFAD - Register Layout Typedef */
typedef struct {
       uint8_t RESERVED_0[3072];
  __IO uint32_t CR;                                /**< Control Register, offset: 0xC00 */
  __I  uint32_t SR;                                /**< Status Register, offset: 0xC04 */
       uint8_t RESERVED_1[248];
  struct {                                         /* offset: 0xD00, array step: 0x40 */
    __IO uint32_t KEY[4];                            /**< AES Key Word, array offset: 0xD00, array step: index*0x40, index2*0x4 */
    __IO uint32_t CTR[2];                            /**< AES Counter Word, array offset: 0xD10, array step: index*0x40, index2*0x4 */
    __IO uint32_t RGD_W0;                            /**< AES Region Descriptor Word0, array offset: 0xD18, array step: 0x40 */
    __IO uint32_t RGD_W1;                            /**< AES Region Descriptor Word1, array offset: 0xD1C, array step: 0x40 */
         uint8_t RESERVED_0[32];
  } CTX[4];
} OTFAD_Type;

/* ----------------------------------------------------------------------------
   -- OTFAD Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup OTFAD_Register_Masks OTFAD Register Masks
 * @{
 */

/*! @name CR - Control Register */
/*! @{ */

#define OTFAD_CR_FLDM_MASK                       (0x8U)
#define OTFAD_CR_FLDM_SHIFT                      (3U)
/*! FLDM - Force Logically Disabled Mode
 *  0b0..No effect on the operating mode.
 *  0b1..Force entry into LDM after a write with this data bit set. SR[MODE] signals the operating mode.
 */
#define OTFAD_CR_FLDM(x)                         (((uint32_t)(((uint32_t)(x)) << OTFAD_CR_FLDM_SHIFT)) & OTFAD_CR_FLDM_MASK)

#define OTFAD_CR_RRAE_MASK                       (0x80U)
#define OTFAD_CR_RRAE_SHIFT                      (7U)
/*! RRAE - Restricted Register Access Enable
 *  0b0..Register access is fully enabled. The OTFAD programming model registers can be accessed "normally".
 *  0b1..Register access is restricted and only the CR, SR and optional MDPC registers can be accessed; others are treated as RAZ/WI.
 */
#define OTFAD_CR_RRAE(x)                         (((uint32_t)(((uint32_t)(x)) << OTFAD_CR_RRAE_SHIFT)) & OTFAD_CR_RRAE_MASK)

#define OTFAD_CR_GE_MASK                         (0x80000000U)
#define OTFAD_CR_GE_SHIFT                        (31U)
/*! GE - Global OTFAD Enable
 *  0b0..OTFAD has decryption disabled. All data fetched by the FLEXSPI bypasses OTFAD processing.
 *  0b1..OTFAD has decryption enabled, and processes data fetched by the FLEXSPI as defined by the hardware configuration.
 */
#define OTFAD_CR_GE(x)                           (((uint32_t)(((uint32_t)(x)) << OTFAD_CR_GE_SHIFT)) & OTFAD_CR_GE_MASK)
/*! @} */

/*! @name SR - Status Register */
/*! @{ */

#define OTFAD_SR_MDPCP_MASK                      (0x2U)
#define OTFAD_SR_MDPCP_SHIFT                     (1U)
/*! MDPCP - MDPC Present
 */
#define OTFAD_SR_MDPCP(x)                        (((uint32_t)(((uint32_t)(x)) << OTFAD_SR_MDPCP_SHIFT)) & OTFAD_SR_MDPCP_MASK)

#define OTFAD_SR_MODE_MASK                       (0xCU)
#define OTFAD_SR_MODE_SHIFT                      (2U)
/*! MODE - Operating Mode
 *  0b00..Operating in Normal mode (NRM)
 *  0b01..Unused (reserved)
 *  0b10..Unused (reserved)
 *  0b11..Operating in Logically Disabled Mode (LDM)
 */
#define OTFAD_SR_MODE(x)                         (((uint32_t)(((uint32_t)(x)) << OTFAD_SR_MODE_SHIFT)) & OTFAD_SR_MODE_MASK)

#define OTFAD_SR_NCTX_MASK                       (0xF0U)
#define OTFAD_SR_NCTX_SHIFT                      (4U)
/*! NCTX - Number of Contexts
 */
#define OTFAD_SR_NCTX(x)                         (((uint32_t)(((uint32_t)(x)) << OTFAD_SR_NCTX_SHIFT)) & OTFAD_SR_NCTX_MASK)

#define OTFAD_SR_HRL_MASK                        (0xF000000U)
#define OTFAD_SR_HRL_SHIFT                       (24U)
/*! HRL - Hardware Revision Level
 */
#define OTFAD_SR_HRL(x)                          (((uint32_t)(((uint32_t)(x)) << OTFAD_SR_HRL_SHIFT)) & OTFAD_SR_HRL_MASK)

#define OTFAD_SR_RRAM_MASK                       (0x10000000U)
#define OTFAD_SR_RRAM_SHIFT                      (28U)
/*! RRAM - Restricted Register Access Mode
 *  0b0..Register access is fully enabled. The OTFAD programming model registers can be accessed "normally".
 *  0b1..Register access is restricted and only the CR, SR and optional MDPC registers can be accessed; others are treated as RAZ/WI.
 */
#define OTFAD_SR_RRAM(x)                         (((uint32_t)(((uint32_t)(x)) << OTFAD_SR_RRAM_SHIFT)) & OTFAD_SR_RRAM_MASK)

#define OTFAD_SR_GEM_MASK                        (0x20000000U)
#define OTFAD_SR_GEM_SHIFT                       (29U)
/*! GEM - Global Enable Mode
 *  0b0..OTFAD is disabled. All data fetched by the FLEXSPI bypasses OTFAD processing.
 *  0b1..OTFAD is enabled, and processes data fetched by the FLEXSPI as defined by the hardware configuration.
 */
#define OTFAD_SR_GEM(x)                          (((uint32_t)(((uint32_t)(x)) << OTFAD_SR_GEM_SHIFT)) & OTFAD_SR_GEM_MASK)
/*! @} */

/*! @name KEY - AES Key Word */
/*! @{ */

#define OTFAD_KEY_KEY_MASK                       (0xFFFFFFFFU)
#define OTFAD_KEY_KEY_SHIFT                      (0U)
/*! KEY - AES Key
 */
#define OTFAD_KEY_KEY(x)                         (((uint32_t)(((uint32_t)(x)) << OTFAD_KEY_KEY_SHIFT)) & OTFAD_KEY_KEY_MASK)
/*! @} */

/* The count of OTFAD_KEY */
#define OTFAD_KEY_COUNT                          (4U)

/* The count of OTFAD_KEY */
#define OTFAD_KEY_COUNT2                         (4U)

/*! @name CTR - AES Counter Word */
/*! @{ */

#define OTFAD_CTR_CTR_MASK                       (0xFFFFFFFFU)
#define OTFAD_CTR_CTR_SHIFT                      (0U)
/*! CTR - AES Counter
 */
#define OTFAD_CTR_CTR(x)                         (((uint32_t)(((uint32_t)(x)) << OTFAD_CTR_CTR_SHIFT)) & OTFAD_CTR_CTR_MASK)
/*! @} */

/* The count of OTFAD_CTR */
#define OTFAD_CTR_COUNT                          (4U)

/* The count of OTFAD_CTR */
#define OTFAD_CTR_COUNT2                         (2U)

/*! @name RGD_W0 - AES Region Descriptor Word0 */
/*! @{ */

#define OTFAD_RGD_W0_SRTADDR_MASK                (0xFFFFFC00U)
#define OTFAD_RGD_W0_SRTADDR_SHIFT               (10U)
/*! SRTADDR - Start Address
 */
#define OTFAD_RGD_W0_SRTADDR(x)                  (((uint32_t)(((uint32_t)(x)) << OTFAD_RGD_W0_SRTADDR_SHIFT)) & OTFAD_RGD_W0_SRTADDR_MASK)
/*! @} */

/* The count of OTFAD_RGD_W0 */
#define OTFAD_RGD_W0_COUNT                       (4U)

/*! @name RGD_W1 - AES Region Descriptor Word1 */
/*! @{ */

#define OTFAD_RGD_W1_VLD_MASK                    (0x1U)
#define OTFAD_RGD_W1_VLD_SHIFT                   (0U)
/*! VLD - Valid
 *  0b0..Context is invalid.
 *  0b1..Context is valid.
 */
#define OTFAD_RGD_W1_VLD(x)                      (((uint32_t)(((uint32_t)(x)) << OTFAD_RGD_W1_VLD_SHIFT)) & OTFAD_RGD_W1_VLD_MASK)

#define OTFAD_RGD_W1_ADE_MASK                    (0x2U)
#define OTFAD_RGD_W1_ADE_SHIFT                   (1U)
/*! ADE - AES Decryption Enable.
 *  0b0..Bypass the fetched data.
 *  0b1..Perform the CTR-AES128 mode decryption on the fetched data.
 */
#define OTFAD_RGD_W1_ADE(x)                      (((uint32_t)(((uint32_t)(x)) << OTFAD_RGD_W1_ADE_SHIFT)) & OTFAD_RGD_W1_ADE_MASK)

#define OTFAD_RGD_W1_RO_MASK                     (0x4U)
#define OTFAD_RGD_W1_RO_SHIFT                    (2U)
/*! RO - Read-Only
 *  0b0..The context registers can be accessed normally (as defined by SR[RRAM]).
 *  0b1..The context registers are read-only and accesses may be further restricted based on SR[RRAM].
 */
#define OTFAD_RGD_W1_RO(x)                       (((uint32_t)(((uint32_t)(x)) << OTFAD_RGD_W1_RO_SHIFT)) & OTFAD_RGD_W1_RO_MASK)

#define OTFAD_RGD_W1_ENDADDR_MASK                (0xFFFFFC00U)
#define OTFAD_RGD_W1_ENDADDR_SHIFT               (10U)
/*! ENDADDR - End Address
 */
#define OTFAD_RGD_W1_ENDADDR(x)                  (((uint32_t)(((uint32_t)(x)) << OTFAD_RGD_W1_ENDADDR_SHIFT)) & OTFAD_RGD_W1_ENDADDR_MASK)
/*! @} */

/* The count of OTFAD_RGD_W1 */
#define OTFAD_RGD_W1_COUNT                       (4U)


/*!
 * @}
 */ /* end of group OTFAD_Register_Masks */


/* OTFAD - Peripheral instance base addresses */
/** Peripheral OTFAD base address */
#define OTFAD_BASE                               (0x40134000u)
/** Peripheral OTFAD base pointer */
#define OTFAD                                    ((OTFAD_Type *)OTFAD_BASE)
/** Array initializer of OTFAD peripheral base addresses */
#define OTFAD_BASE_ADDRS                         { OTFAD_BASE }
/** Array initializer of OTFAD peripheral base pointers */
#define OTFAD_BASE_PTRS                          { OTFAD }

/*!
 * @}
 */ /* end of group OTFAD_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- PINT Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup PINT_Peripheral_Access_Layer PINT Peripheral Access Layer
 * @{
 */

/** PINT - Register Layout Typedef */
typedef struct {
  __IO uint32_t ISEL;                              /**< Pin Interrupt Mode register, offset: 0x0 */
  __IO uint32_t IENR;                              /**< Pin interrupt level or rising edge interrupt enable register, offset: 0x4 */
  __O  uint32_t SIENR;                             /**< Pin interrupt level or rising edge interrupt set register, offset: 0x8 */
  __O  uint32_t CIENR;                             /**< Pin interrupt level (rising edge interrupt) clear register, offset: 0xC */
  __IO uint32_t IENF;                              /**< Pin interrupt active level or falling edge interrupt enable register, offset: 0x10 */
  __O  uint32_t SIENF;                             /**< Pin interrupt active level or falling edge interrupt set register, offset: 0x14 */
  __O  uint32_t CIENF;                             /**< Pin interrupt active level or falling edge interrupt clear register, offset: 0x18 */
  __IO uint32_t RISE;                              /**< Pin interrupt rising edge register, offset: 0x1C */
  __IO uint32_t FALL;                              /**< Pin interrupt falling edge register, offset: 0x20 */
  __IO uint32_t IST;                               /**< Pin interrupt status register, offset: 0x24 */
  __IO uint32_t PMCTRL;                            /**< Pattern match interrupt control register, offset: 0x28 */
  __IO uint32_t PMSRC;                             /**< Pattern match interrupt bit-slice source register, offset: 0x2C */
  __IO uint32_t PMCFG;                             /**< Pattern match interrupt bit slice configuration register, offset: 0x30 */
} PINT_Type;

/* ----------------------------------------------------------------------------
   -- PINT Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup PINT_Register_Masks PINT Register Masks
 * @{
 */

/*! @name ISEL - Pin Interrupt Mode register */
/*! @{ */

#define PINT_ISEL_PMODE_MASK                     (0xFFU)
#define PINT_ISEL_PMODE_SHIFT                    (0U)
/*! PMODE - Selects the interrupt mode for each pin interrupt. Bit n configures the pin interrupt
 *    selected in PINTSELn. 0 = Edge sensitive 1 = Level sensitive
 */
#define PINT_ISEL_PMODE(x)                       (((uint32_t)(((uint32_t)(x)) << PINT_ISEL_PMODE_SHIFT)) & PINT_ISEL_PMODE_MASK)
/*! @} */

/*! @name IENR - Pin interrupt level or rising edge interrupt enable register */
/*! @{ */

#define PINT_IENR_ENRL_MASK                      (0xFFU)
#define PINT_IENR_ENRL_SHIFT                     (0U)
/*! ENRL - Enables the rising edge or level interrupt for each pin interrupt. Bit n configures the
 *    pin interrupt selected in PINTSELn. 0 = Disable rising edge or level interrupt. 1 = Enable
 *    rising edge or level interrupt.
 */
#define PINT_IENR_ENRL(x)                        (((uint32_t)(((uint32_t)(x)) << PINT_IENR_ENRL_SHIFT)) & PINT_IENR_ENRL_MASK)
/*! @} */

/*! @name SIENR - Pin interrupt level or rising edge interrupt set register */
/*! @{ */

#define PINT_SIENR_SETENRL_MASK                  (0xFFU)
#define PINT_SIENR_SETENRL_SHIFT                 (0U)
/*! SETENRL - Ones written to this address set bits in the IENR, thus enabling interrupts. Bit n
 *    sets bit n in the IENR register. 0 = No operation. 1 = Enable rising edge or level interrupt.
 */
#define PINT_SIENR_SETENRL(x)                    (((uint32_t)(((uint32_t)(x)) << PINT_SIENR_SETENRL_SHIFT)) & PINT_SIENR_SETENRL_MASK)
/*! @} */

/*! @name CIENR - Pin interrupt level (rising edge interrupt) clear register */
/*! @{ */

#define PINT_CIENR_CENRL_MASK                    (0xFFU)
#define PINT_CIENR_CENRL_SHIFT                   (0U)
/*! CENRL - Ones written to this address clear bits in the IENR, thus disabling the interrupts. Bit
 *    n clears bit n in the IENR register. 0 = No operation. 1 = Disable rising edge or level
 *    interrupt.
 */
#define PINT_CIENR_CENRL(x)                      (((uint32_t)(((uint32_t)(x)) << PINT_CIENR_CENRL_SHIFT)) & PINT_CIENR_CENRL_MASK)
/*! @} */

/*! @name IENF - Pin interrupt active level or falling edge interrupt enable register */
/*! @{ */

#define PINT_IENF_ENAF_MASK                      (0xFFU)
#define PINT_IENF_ENAF_SHIFT                     (0U)
/*! ENAF - Enables the falling edge or configures the active level interrupt for each pin interrupt.
 *    Bit n configures the pin interrupt selected in PINTSELn. 0 = Disable falling edge interrupt
 *    or set active interrupt level LOW. 1 = Enable falling edge interrupt enabled or set active
 *    interrupt level HIGH.
 */
#define PINT_IENF_ENAF(x)                        (((uint32_t)(((uint32_t)(x)) << PINT_IENF_ENAF_SHIFT)) & PINT_IENF_ENAF_MASK)
/*! @} */

/*! @name SIENF - Pin interrupt active level or falling edge interrupt set register */
/*! @{ */

#define PINT_SIENF_SETENAF_MASK                  (0xFFU)
#define PINT_SIENF_SETENAF_SHIFT                 (0U)
/*! SETENAF - Ones written to this address set bits in the IENF, thus enabling interrupts. Bit n
 *    sets bit n in the IENF register. 0 = No operation. 1 = Select HIGH-active interrupt or enable
 *    falling edge interrupt.
 */
#define PINT_SIENF_SETENAF(x)                    (((uint32_t)(((uint32_t)(x)) << PINT_SIENF_SETENAF_SHIFT)) & PINT_SIENF_SETENAF_MASK)
/*! @} */

/*! @name CIENF - Pin interrupt active level or falling edge interrupt clear register */
/*! @{ */

#define PINT_CIENF_CENAF_MASK                    (0xFFU)
#define PINT_CIENF_CENAF_SHIFT                   (0U)
/*! CENAF - Ones written to this address clears bits in the IENF, thus disabling interrupts. Bit n
 *    clears bit n in the IENF register. 0 = No operation. 1 = LOW-active interrupt selected or
 *    falling edge interrupt disabled.
 */
#define PINT_CIENF_CENAF(x)                      (((uint32_t)(((uint32_t)(x)) << PINT_CIENF_CENAF_SHIFT)) & PINT_CIENF_CENAF_MASK)
/*! @} */

/*! @name RISE - Pin interrupt rising edge register */
/*! @{ */

#define PINT_RISE_RDET_MASK                      (0xFFU)
#define PINT_RISE_RDET_SHIFT                     (0U)
/*! RDET - Rising edge detect. Bit n detects the rising edge of the pin selected in PINTSELn. Read
 *    0: No rising edge has been detected on this pin since Reset or the last time a one was written
 *    to this bit. Write 0: no operation. Read 1: a rising edge has been detected since Reset or the
 *    last time a one was written to this bit. Write 1: clear rising edge detection for this pin.
 */
#define PINT_RISE_RDET(x)                        (((uint32_t)(((uint32_t)(x)) << PINT_RISE_RDET_SHIFT)) & PINT_RISE_RDET_MASK)
/*! @} */

/*! @name FALL - Pin interrupt falling edge register */
/*! @{ */

#define PINT_FALL_FDET_MASK                      (0xFFU)
#define PINT_FALL_FDET_SHIFT                     (0U)
/*! FDET - Falling edge detect. Bit n detects the falling edge of the pin selected in PINTSELn. Read
 *    0: No falling edge has been detected on this pin since Reset or the last time a one was
 *    written to this bit. Write 0: no operation. Read 1: a falling edge has been detected since Reset or
 *    the last time a one was written to this bit. Write 1: clear falling edge detection for this
 *    pin.
 */
#define PINT_FALL_FDET(x)                        (((uint32_t)(((uint32_t)(x)) << PINT_FALL_FDET_SHIFT)) & PINT_FALL_FDET_MASK)
/*! @} */

/*! @name IST - Pin interrupt status register */
/*! @{ */

#define PINT_IST_PSTAT_MASK                      (0xFFU)
#define PINT_IST_PSTAT_SHIFT                     (0U)
/*! PSTAT - Pin interrupt status. Bit n returns the status, clears the edge interrupt, or inverts
 *    the active level of the pin selected in PINTSELn. Read 0: interrupt is not being requested for
 *    this interrupt pin. Write 0: no operation. Read 1: interrupt is being requested for this
 *    interrupt pin. Write 1 (edge-sensitive): clear rising- and falling-edge detection for this pin.
 *    Write 1 (level-sensitive): switch the active level for this pin (in the IENF register).
 */
#define PINT_IST_PSTAT(x)                        (((uint32_t)(((uint32_t)(x)) << PINT_IST_PSTAT_SHIFT)) & PINT_IST_PSTAT_MASK)
/*! @} */

/*! @name PMCTRL - Pattern match interrupt control register */
/*! @{ */

#define PINT_PMCTRL_SEL_PMATCH_MASK              (0x1U)
#define PINT_PMCTRL_SEL_PMATCH_SHIFT             (0U)
/*! SEL_PMATCH - Specifies whether the 8 pin interrupts are controlled by the pin interrupt function or by the pattern match function.
 *  0b0..Pin interrupt. Interrupts are driven in response to the standard pin interrupt function.
 *  0b1..Pattern match. Interrupts are driven in response to pattern matches.
 */
#define PINT_PMCTRL_SEL_PMATCH(x)                (((uint32_t)(((uint32_t)(x)) << PINT_PMCTRL_SEL_PMATCH_SHIFT)) & PINT_PMCTRL_SEL_PMATCH_MASK)

#define PINT_PMCTRL_ENA_RXEV_MASK                (0x2U)
#define PINT_PMCTRL_ENA_RXEV_SHIFT               (1U)
/*! ENA_RXEV - Enables the RXEV output to the CPU and/or to a GPIO output when the specified boolean expression evaluates to true.
 *  0b0..Disabled. RXEV output to the CPU is disabled.
 *  0b1..Enabled. RXEV output to the CPU is enabled.
 */
#define PINT_PMCTRL_ENA_RXEV(x)                  (((uint32_t)(((uint32_t)(x)) << PINT_PMCTRL_ENA_RXEV_SHIFT)) & PINT_PMCTRL_ENA_RXEV_MASK)

#define PINT_PMCTRL_PMAT_MASK                    (0xFF000000U)
#define PINT_PMCTRL_PMAT_SHIFT                   (24U)
/*! PMAT - This field displays the current state of pattern matches. A 1 in any bit of this field
 *    indicates that the corresponding product term is matched by the current state of the appropriate
 *    inputs.
 */
#define PINT_PMCTRL_PMAT(x)                      (((uint32_t)(((uint32_t)(x)) << PINT_PMCTRL_PMAT_SHIFT)) & PINT_PMCTRL_PMAT_MASK)
/*! @} */

/*! @name PMSRC - Pattern match interrupt bit-slice source register */
/*! @{ */

#define PINT_PMSRC_SRC0_MASK                     (0x700U)
#define PINT_PMSRC_SRC0_SHIFT                    (8U)
/*! SRC0 - Selects the input source for bit slice 0
 *  0b000..Input 0. Selects the pin selected in the PINTSEL0 register as the source to bit slice 0.
 *  0b001..Input 1. Selects the pin selected in the PINTSEL1 register as the source to bit slice 0.
 *  0b010..Input 2. Selects the pin selected in the PINTSEL2 register as the source to bit slice 0.
 *  0b011..Input 3. Selects the pin selected in the PINTSEL3 register as the source to bit slice 0.
 *  0b100..Input 4. Selects the pin selected in the PINTSEL4 register as the source to bit slice 0.
 *  0b101..Input 5. Selects the pin selected in the PINTSEL5 register as the source to bit slice 0.
 *  0b110..Input 6. Selects the pin selected in the PINTSEL6 register as the source to bit slice 0.
 *  0b111..Input 7. Selects the pin selected in the PINTSEL7 register as the source to bit slice 0.
 */
#define PINT_PMSRC_SRC0(x)                       (((uint32_t)(((uint32_t)(x)) << PINT_PMSRC_SRC0_SHIFT)) & PINT_PMSRC_SRC0_MASK)

#define PINT_PMSRC_SRC1_MASK                     (0x3800U)
#define PINT_PMSRC_SRC1_SHIFT                    (11U)
/*! SRC1 - Selects the input source for bit slice 1
 *  0b000..Input 0. Selects the pin selected in the PINTSEL0 register as the source to bit slice 1.
 *  0b001..Input 1. Selects the pin selected in the PINTSEL1 register as the source to bit slice 1.
 *  0b010..Input 2. Selects the pin selected in the PINTSEL2 register as the source to bit slice 1.
 *  0b011..Input 3. Selects the pin selected in the PINTSEL3 register as the source to bit slice 1.
 *  0b100..Input 4. Selects the pin selected in the PINTSEL4 register as the source to bit slice 1.
 *  0b101..Input 5. Selects the pin selected in the PINTSEL5 register as the source to bit slice 1.
 *  0b110..Input 6. Selects the pin selected in the PINTSEL6 register as the source to bit slice 1.
 *  0b111..Input 7. Selects the pin selected in the PINTSEL7 register as the source to bit slice 1.
 */
#define PINT_PMSRC_SRC1(x)                       (((uint32_t)(((uint32_t)(x)) << PINT_PMSRC_SRC1_SHIFT)) & PINT_PMSRC_SRC1_MASK)

#define PINT_PMSRC_SRC2_MASK                     (0x1C000U)
#define PINT_PMSRC_SRC2_SHIFT                    (14U)
/*! SRC2 - Selects the input source for bit slice 2
 *  0b000..Input 0. Selects the pin selected in the PINTSEL0 register as the source to bit slice 2.
 *  0b001..Input 1. Selects the pin selected in the PINTSEL1 register as the source to bit slice 2.
 *  0b010..Input 2. Selects the pin selected in the PINTSEL2 register as the source to bit slice 2.
 *  0b011..Input 3. Selects the pin selected in the PINTSEL3 register as the source to bit slice 2.
 *  0b100..Input 4. Selects the pin selected in the PINTSEL4 register as the source to bit slice 2.
 *  0b101..Input 5. Selects the pin selected in the PINTSEL5 register as the source to bit slice 2.
 *  0b110..Input 6. Selects the pin selected in the PINTSEL6 register as the source to bit slice 2.
 *  0b111..Input 7. Selects the pin selected in the PINTSEL7 register as the source to bit slice 2.
 */
#define PINT_PMSRC_SRC2(x)                       (((uint32_t)(((uint32_t)(x)) << PINT_PMSRC_SRC2_SHIFT)) & PINT_PMSRC_SRC2_MASK)

#define PINT_PMSRC_SRC3_MASK                     (0xE0000U)
#define PINT_PMSRC_SRC3_SHIFT                    (17U)
/*! SRC3 - Selects the input source for bit slice 3
 *  0b000..Input 0. Selects the pin selected in the PINTSEL0 register as the source to bit slice 3.
 *  0b001..Input 1. Selects the pin selected in the PINTSEL1 register as the source to bit slice 3.
 *  0b010..Input 2. Selects the pin selected in the PINTSEL2 register as the source to bit slice 3.
 *  0b011..Input 3. Selects the pin selected in the PINTSEL3 register as the source to bit slice 3.
 *  0b100..Input 4. Selects the pin selected in the PINTSEL4 register as the source to bit slice 3.
 *  0b101..Input 5. Selects the pin selected in the PINTSEL5 register as the source to bit slice 3.
 *  0b110..Input 6. Selects the pin selected in the PINTSEL6 register as the source to bit slice 3.
 *  0b111..Input 7. Selects the pin selected in the PINTSEL7 register as the source to bit slice 3.
 */
#define PINT_PMSRC_SRC3(x)                       (((uint32_t)(((uint32_t)(x)) << PINT_PMSRC_SRC3_SHIFT)) & PINT_PMSRC_SRC3_MASK)

#define PINT_PMSRC_SRC4_MASK                     (0x700000U)
#define PINT_PMSRC_SRC4_SHIFT                    (20U)
/*! SRC4 - Selects the input source for bit slice 4
 *  0b000..Input 0. Selects the pin selected in the PINTSEL0 register as the source to bit slice 4.
 *  0b001..Input 1. Selects the pin selected in the PINTSEL1 register as the source to bit slice 4.
 *  0b010..Input 2. Selects the pin selected in the PINTSEL2 register as the source to bit slice 4.
 *  0b011..Input 3. Selects the pin selected in the PINTSEL3 register as the source to bit slice 4.
 *  0b100..Input 4. Selects the pin selected in the PINTSEL4 register as the source to bit slice 4.
 *  0b101..Input 5. Selects the pin selected in the PINTSEL5 register as the source to bit slice 4.
 *  0b110..Input 6. Selects the pin selected in the PINTSEL6 register as the source to bit slice 4.
 *  0b111..Input 7. Selects the pin selected in the PINTSEL7 register as the source to bit slice 4.
 */
#define PINT_PMSRC_SRC4(x)                       (((uint32_t)(((uint32_t)(x)) << PINT_PMSRC_SRC4_SHIFT)) & PINT_PMSRC_SRC4_MASK)

#define PINT_PMSRC_SRC5_MASK                     (0x3800000U)
#define PINT_PMSRC_SRC5_SHIFT                    (23U)
/*! SRC5 - Selects the input source for bit slice 5
 *  0b000..Input 0. Selects the pin selected in the PINTSEL0 register as the source to bit slice 5.
 *  0b001..Input 1. Selects the pin selected in the PINTSEL1 register as the source to bit slice 5.
 *  0b010..Input 2. Selects the pin selected in the PINTSEL2 register as the source to bit slice 5.
 *  0b011..Input 3. Selects the pin selected in the PINTSEL3 register as the source to bit slice 5.
 *  0b100..Input 4. Selects the pin selected in the PINTSEL4 register as the source to bit slice 5.
 *  0b101..Input 5. Selects the pin selected in the PINTSEL5 register as the source to bit slice 5.
 *  0b110..Input 6. Selects the pin selected in the PINTSEL6 register as the source to bit slice 5.
 *  0b111..Input 7. Selects the pin selected in the PINTSEL7 register as the source to bit slice 5.
 */
#define PINT_PMSRC_SRC5(x)                       (((uint32_t)(((uint32_t)(x)) << PINT_PMSRC_SRC5_SHIFT)) & PINT_PMSRC_SRC5_MASK)

#define PINT_PMSRC_SRC6_MASK                     (0x1C000000U)
#define PINT_PMSRC_SRC6_SHIFT                    (26U)
/*! SRC6 - Selects the input source for bit slice 6
 *  0b000..Input 0. Selects the pin selected in the PINTSEL0 register as the source to bit slice 6.
 *  0b001..Input 1. Selects the pin selected in the PINTSEL1 register as the source to bit slice 6.
 *  0b010..Input 2. Selects the pin selected in the PINTSEL2 register as the source to bit slice 6.
 *  0b011..Input 3. Selects the pin selected in the PINTSEL3 register as the source to bit slice 6.
 *  0b100..Input 4. Selects the pin selected in the PINTSEL4 register as the source to bit slice 6.
 *  0b101..Input 5. Selects the pin selected in the PINTSEL5 register as the source to bit slice 6.
 *  0b110..Input 6. Selects the pin selected in the PINTSEL6 register as the source to bit slice 6.
 *  0b111..Input 7. Selects the pin selected in the PINTSEL7 register as the source to bit slice 6.
 */
#define PINT_PMSRC_SRC6(x)                       (((uint32_t)(((uint32_t)(x)) << PINT_PMSRC_SRC6_SHIFT)) & PINT_PMSRC_SRC6_MASK)

#define PINT_PMSRC_SRC7_MASK                     (0xE0000000U)
#define PINT_PMSRC_SRC7_SHIFT                    (29U)
/*! SRC7 - Selects the input source for bit slice 7
 *  0b000..Input 0. Selects the pin selected in the PINTSEL0 register as the source to bit slice 7.
 *  0b001..Input 1. Selects the pin selected in the PINTSEL1 register as the source to bit slice 7.
 *  0b010..Input 2. Selects the pin selected in the PINTSEL2 register as the source to bit slice 7.
 *  0b011..Input 3. Selects the pin selected in the PINTSEL3 register as the source to bit slice 7.
 *  0b100..Input 4. Selects the pin selected in the PINTSEL4 register as the source to bit slice 7.
 *  0b101..Input 5. Selects the pin selected in the PINTSEL5 register as the source to bit slice 7.
 *  0b110..Input 6. Selects the pin selected in the PINTSEL6 register as the source to bit slice 7.
 *  0b111..Input 7. Selects the pin selected in the PINTSEL7 register as the source to bit slice 7.
 */
#define PINT_PMSRC_SRC7(x)                       (((uint32_t)(((uint32_t)(x)) << PINT_PMSRC_SRC7_SHIFT)) & PINT_PMSRC_SRC7_MASK)
/*! @} */

/*! @name PMCFG - Pattern match interrupt bit slice configuration register */
/*! @{ */

#define PINT_PMCFG_PROD_ENDPTS0_MASK             (0x1U)
#define PINT_PMCFG_PROD_ENDPTS0_SHIFT            (0U)
/*! PROD_ENDPTS0 - Determines whether slice 0 is an endpoint.
 *  0b0..No effect. Slice 0 is not an endpoint.
 *  0b1..endpoint. Slice 0 is the endpoint of a product term (minterm). Pin interrupt 0 in the NVIC is raised if the minterm evaluates as true.
 */
#define PINT_PMCFG_PROD_ENDPTS0(x)               (((uint32_t)(((uint32_t)(x)) << PINT_PMCFG_PROD_ENDPTS0_SHIFT)) & PINT_PMCFG_PROD_ENDPTS0_MASK)

#define PINT_PMCFG_PROD_ENDPTS1_MASK             (0x2U)
#define PINT_PMCFG_PROD_ENDPTS1_SHIFT            (1U)
/*! PROD_ENDPTS1 - Determines whether slice 1 is an endpoint.
 *  0b0..No effect. Slice 1 is not an endpoint.
 *  0b1..endpoint. Slice 1 is the endpoint of a product term (minterm). Pin interrupt 1 in the NVIC is raised if the minterm evaluates as true.
 */
#define PINT_PMCFG_PROD_ENDPTS1(x)               (((uint32_t)(((uint32_t)(x)) << PINT_PMCFG_PROD_ENDPTS1_SHIFT)) & PINT_PMCFG_PROD_ENDPTS1_MASK)

#define PINT_PMCFG_PROD_ENDPTS2_MASK             (0x4U)
#define PINT_PMCFG_PROD_ENDPTS2_SHIFT            (2U)
/*! PROD_ENDPTS2 - Determines whether slice 2 is an endpoint.
 *  0b0..No effect. Slice 2 is not an endpoint.
 *  0b1..endpoint. Slice 2 is the endpoint of a product term (minterm). Pin interrupt 2 in the NVIC is raised if the minterm evaluates as true.
 */
#define PINT_PMCFG_PROD_ENDPTS2(x)               (((uint32_t)(((uint32_t)(x)) << PINT_PMCFG_PROD_ENDPTS2_SHIFT)) & PINT_PMCFG_PROD_ENDPTS2_MASK)

#define PINT_PMCFG_PROD_ENDPTS3_MASK             (0x8U)
#define PINT_PMCFG_PROD_ENDPTS3_SHIFT            (3U)
/*! PROD_ENDPTS3 - Determines whether slice 3 is an endpoint.
 *  0b0..No effect. Slice 3 is not an endpoint.
 *  0b1..endpoint. Slice 3 is the endpoint of a product term (minterm). Pin interrupt 3 in the NVIC is raised if the minterm evaluates as true.
 */
#define PINT_PMCFG_PROD_ENDPTS3(x)               (((uint32_t)(((uint32_t)(x)) << PINT_PMCFG_PROD_ENDPTS3_SHIFT)) & PINT_PMCFG_PROD_ENDPTS3_MASK)

#define PINT_PMCFG_PROD_ENDPTS4_MASK             (0x10U)
#define PINT_PMCFG_PROD_ENDPTS4_SHIFT            (4U)
/*! PROD_ENDPTS4 - Determines whether slice 4 is an endpoint.
 *  0b0..No effect. Slice 4 is not an endpoint.
 *  0b1..endpoint. Slice 4 is the endpoint of a product term (minterm). Pin interrupt 4 in the NVIC is raised if the minterm evaluates as true.
 */
#define PINT_PMCFG_PROD_ENDPTS4(x)               (((uint32_t)(((uint32_t)(x)) << PINT_PMCFG_PROD_ENDPTS4_SHIFT)) & PINT_PMCFG_PROD_ENDPTS4_MASK)

#define PINT_PMCFG_PROD_ENDPTS5_MASK             (0x20U)
#define PINT_PMCFG_PROD_ENDPTS5_SHIFT            (5U)
/*! PROD_ENDPTS5 - Determines whether slice 5 is an endpoint.
 *  0b0..No effect. Slice 5 is not an endpoint.
 *  0b1..endpoint. Slice 5 is the endpoint of a product term (minterm). Pin interrupt 5 in the NVIC is raised if the minterm evaluates as true.
 */
#define PINT_PMCFG_PROD_ENDPTS5(x)               (((uint32_t)(((uint32_t)(x)) << PINT_PMCFG_PROD_ENDPTS5_SHIFT)) & PINT_PMCFG_PROD_ENDPTS5_MASK)

#define PINT_PMCFG_PROD_ENDPTS6_MASK             (0x40U)
#define PINT_PMCFG_PROD_ENDPTS6_SHIFT            (6U)
/*! PROD_ENDPTS6 - Determines whether slice 6 is an endpoint.
 *  0b0..No effect. Slice 6 is not an endpoint.
 *  0b1..endpoint. Slice 6 is the endpoint of a product term (minterm). Pin interrupt 6 in the NVIC is raised if the minterm evaluates as true.
 */
#define PINT_PMCFG_PROD_ENDPTS6(x)               (((uint32_t)(((uint32_t)(x)) << PINT_PMCFG_PROD_ENDPTS6_SHIFT)) & PINT_PMCFG_PROD_ENDPTS6_MASK)

#define PINT_PMCFG_CFG0_MASK                     (0x700U)
#define PINT_PMCFG_CFG0_SHIFT                    (8U)
/*! CFG0 - Specifies the match contribution condition for bit slice 0.
 *  0b000..Constant HIGH. This bit slice always contributes to a product term match.
 *  0b001..Sticky rising edge. Match occurs if a rising edge on the specified input has occurred since the last
 *         time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the
 *         PMSRC registers are written to.
 *  0b010..Sticky falling edge. Match occurs if a falling edge on the specified input has occurred since the last
 *         time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the
 *         PMSRC registers are written to.
 *  0b011..Sticky rising or falling edge. Match occurs if either a rising or falling edge on the specified input
 *         has occurred since the last time the edge detection for this bit slice was cleared. This bit is only
 *         cleared when the PMCFG or the PMSRC registers are written to.
 *  0b100..High level. Match (for this bit slice) occurs when there is a high level on the input specified for this bit slice in the PMSRC register.
 *  0b101..Low level. Match occurs when there is a low level on the specified input.
 *  0b110..Constant 0. This bit slice never contributes to a match (should be used to disable any unused bit slices).
 *  0b111..Event. Non-sticky rising or falling edge. Match occurs on an event - i.e. when either a rising or
 *         falling edge is first detected on the specified input (this is a non-sticky version of value 0x3) . This bit
 *         is cleared after one clock cycle.
 */
#define PINT_PMCFG_CFG0(x)                       (((uint32_t)(((uint32_t)(x)) << PINT_PMCFG_CFG0_SHIFT)) & PINT_PMCFG_CFG0_MASK)

#define PINT_PMCFG_CFG1_MASK                     (0x3800U)
#define PINT_PMCFG_CFG1_SHIFT                    (11U)
/*! CFG1 - Specifies the match contribution condition for bit slice 1.
 *  0b000..Constant HIGH. This bit slice always contributes to a product term match.
 *  0b001..Sticky rising edge. Match occurs if a rising edge on the specified input has occurred since the last
 *         time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the
 *         PMSRC registers are written to.
 *  0b010..Sticky falling edge. Match occurs if a falling edge on the specified input has occurred since the last
 *         time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the
 *         PMSRC registers are written to.
 *  0b011..Sticky rising or falling edge. Match occurs if either a rising or falling edge on the specified input
 *         has occurred since the last time the edge detection for this bit slice was cleared. This bit is only
 *         cleared when the PMCFG or the PMSRC registers are written to.
 *  0b100..High level. Match (for this bit slice) occurs when there is a high level on the input specified for this bit slice in the PMSRC register.
 *  0b101..Low level. Match occurs when there is a low level on the specified input.
 *  0b110..Constant 0. This bit slice never contributes to a match (should be used to disable any unused bit slices).
 *  0b111..Event. Non-sticky rising or falling edge. Match occurs on an event - i.e. when either a rising or
 *         falling edge is first detected on the specified input (this is a non-sticky version of value 0x3) . This bit
 *         is cleared after one clock cycle.
 */
#define PINT_PMCFG_CFG1(x)                       (((uint32_t)(((uint32_t)(x)) << PINT_PMCFG_CFG1_SHIFT)) & PINT_PMCFG_CFG1_MASK)

#define PINT_PMCFG_CFG2_MASK                     (0x1C000U)
#define PINT_PMCFG_CFG2_SHIFT                    (14U)
/*! CFG2 - Specifies the match contribution condition for bit slice 2.
 *  0b000..Constant HIGH. This bit slice always contributes to a product term match.
 *  0b001..Sticky rising edge. Match occurs if a rising edge on the specified input has occurred since the last
 *         time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the
 *         PMSRC registers are written to.
 *  0b010..Sticky falling edge. Match occurs if a falling edge on the specified input has occurred since the last
 *         time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the
 *         PMSRC registers are written to.
 *  0b011..Sticky rising or falling edge. Match occurs if either a rising or falling edge on the specified input
 *         has occurred since the last time the edge detection for this bit slice was cleared. This bit is only
 *         cleared when the PMCFG or the PMSRC registers are written to.
 *  0b100..High level. Match (for this bit slice) occurs when there is a high level on the input specified for this bit slice in the PMSRC register.
 *  0b101..Low level. Match occurs when there is a low level on the specified input.
 *  0b110..Constant 0. This bit slice never contributes to a match (should be used to disable any unused bit slices).
 *  0b111..Event. Non-sticky rising or falling edge. Match occurs on an event - i.e. when either a rising or
 *         falling edge is first detected on the specified input (this is a non-sticky version of value 0x3) . This bit
 *         is cleared after one clock cycle.
 */
#define PINT_PMCFG_CFG2(x)                       (((uint32_t)(((uint32_t)(x)) << PINT_PMCFG_CFG2_SHIFT)) & PINT_PMCFG_CFG2_MASK)

#define PINT_PMCFG_CFG3_MASK                     (0xE0000U)
#define PINT_PMCFG_CFG3_SHIFT                    (17U)
/*! CFG3 - Specifies the match contribution condition for bit slice 3.
 *  0b000..Constant HIGH. This bit slice always contributes to a product term match.
 *  0b001..Sticky rising edge. Match occurs if a rising edge on the specified input has occurred since the last
 *         time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the
 *         PMSRC registers are written to.
 *  0b010..Sticky falling edge. Match occurs if a falling edge on the specified input has occurred since the last
 *         time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the
 *         PMSRC registers are written to.
 *  0b011..Sticky rising or falling edge. Match occurs if either a rising or falling edge on the specified input
 *         has occurred since the last time the edge detection for this bit slice was cleared. This bit is only
 *         cleared when the PMCFG or the PMSRC registers are written to.
 *  0b100..High level. Match (for this bit slice) occurs when there is a high level on the input specified for this bit slice in the PMSRC register.
 *  0b101..Low level. Match occurs when there is a low level on the specified input.
 *  0b110..Constant 0. This bit slice never contributes to a match (should be used to disable any unused bit slices).
 *  0b111..Event. Non-sticky rising or falling edge. Match occurs on an event - i.e. when either a rising or
 *         falling edge is first detected on the specified input (this is a non-sticky version of value 0x3) . This bit
 *         is cleared after one clock cycle.
 */
#define PINT_PMCFG_CFG3(x)                       (((uint32_t)(((uint32_t)(x)) << PINT_PMCFG_CFG3_SHIFT)) & PINT_PMCFG_CFG3_MASK)

#define PINT_PMCFG_CFG4_MASK                     (0x700000U)
#define PINT_PMCFG_CFG4_SHIFT                    (20U)
/*! CFG4 - Specifies the match contribution condition for bit slice 4.
 *  0b000..Constant HIGH. This bit slice always contributes to a product term match.
 *  0b001..Sticky rising edge. Match occurs if a rising edge on the specified input has occurred since the last
 *         time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the
 *         PMSRC registers are written to.
 *  0b010..Sticky falling edge. Match occurs if a falling edge on the specified input has occurred since the last
 *         time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the
 *         PMSRC registers are written to.
 *  0b011..Sticky rising or falling edge. Match occurs if either a rising or falling edge on the specified input
 *         has occurred since the last time the edge detection for this bit slice was cleared. This bit is only
 *         cleared when the PMCFG or the PMSRC registers are written to.
 *  0b100..High level. Match (for this bit slice) occurs when there is a high level on the input specified for this bit slice in the PMSRC register.
 *  0b101..Low level. Match occurs when there is a low level on the specified input.
 *  0b110..Constant 0. This bit slice never contributes to a match (should be used to disable any unused bit slices).
 *  0b111..Event. Non-sticky rising or falling edge. Match occurs on an event - i.e. when either a rising or
 *         falling edge is first detected on the specified input (this is a non-sticky version of value 0x3) . This bit
 *         is cleared after one clock cycle.
 */
#define PINT_PMCFG_CFG4(x)                       (((uint32_t)(((uint32_t)(x)) << PINT_PMCFG_CFG4_SHIFT)) & PINT_PMCFG_CFG4_MASK)

#define PINT_PMCFG_CFG5_MASK                     (0x3800000U)
#define PINT_PMCFG_CFG5_SHIFT                    (23U)
/*! CFG5 - Specifies the match contribution condition for bit slice 5.
 *  0b000..Constant HIGH. This bit slice always contributes to a product term match.
 *  0b001..Sticky rising edge. Match occurs if a rising edge on the specified input has occurred since the last
 *         time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the
 *         PMSRC registers are written to.
 *  0b010..Sticky falling edge. Match occurs if a falling edge on the specified input has occurred since the last
 *         time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the
 *         PMSRC registers are written to.
 *  0b011..Sticky rising or falling edge. Match occurs if either a rising or falling edge on the specified input
 *         has occurred since the last time the edge detection for this bit slice was cleared. This bit is only
 *         cleared when the PMCFG or the PMSRC registers are written to.
 *  0b100..High level. Match (for this bit slice) occurs when there is a high level on the input specified for this bit slice in the PMSRC register.
 *  0b101..Low level. Match occurs when there is a low level on the specified input.
 *  0b110..Constant 0. This bit slice never contributes to a match (should be used to disable any unused bit slices).
 *  0b111..Event. Non-sticky rising or falling edge. Match occurs on an event - i.e. when either a rising or
 *         falling edge is first detected on the specified input (this is a non-sticky version of value 0x3) . This bit
 *         is cleared after one clock cycle.
 */
#define PINT_PMCFG_CFG5(x)                       (((uint32_t)(((uint32_t)(x)) << PINT_PMCFG_CFG5_SHIFT)) & PINT_PMCFG_CFG5_MASK)

#define PINT_PMCFG_CFG6_MASK                     (0x1C000000U)
#define PINT_PMCFG_CFG6_SHIFT                    (26U)
/*! CFG6 - Specifies the match contribution condition for bit slice 6.
 *  0b000..Constant HIGH. This bit slice always contributes to a product term match.
 *  0b001..Sticky rising edge. Match occurs if a rising edge on the specified input has occurred since the last
 *         time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the
 *         PMSRC registers are written to.
 *  0b010..Sticky falling edge. Match occurs if a falling edge on the specified input has occurred since the last
 *         time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the
 *         PMSRC registers are written to.
 *  0b011..Sticky rising or falling edge. Match occurs if either a rising or falling edge on the specified input
 *         has occurred since the last time the edge detection for this bit slice was cleared. This bit is only
 *         cleared when the PMCFG or the PMSRC registers are written to.
 *  0b100..High level. Match (for this bit slice) occurs when there is a high level on the input specified for this bit slice in the PMSRC register.
 *  0b101..Low level. Match occurs when there is a low level on the specified input.
 *  0b110..Constant 0. This bit slice never contributes to a match (should be used to disable any unused bit slices).
 *  0b111..Event. Non-sticky rising or falling edge. Match occurs on an event - i.e. when either a rising or
 *         falling edge is first detected on the specified input (this is a non-sticky version of value 0x3) . This bit
 *         is cleared after one clock cycle.
 */
#define PINT_PMCFG_CFG6(x)                       (((uint32_t)(((uint32_t)(x)) << PINT_PMCFG_CFG6_SHIFT)) & PINT_PMCFG_CFG6_MASK)

#define PINT_PMCFG_CFG7_MASK                     (0xE0000000U)
#define PINT_PMCFG_CFG7_SHIFT                    (29U)
/*! CFG7 - Specifies the match contribution condition for bit slice 7.
 *  0b000..Constant HIGH. This bit slice always contributes to a product term match.
 *  0b001..Sticky rising edge. Match occurs if a rising edge on the specified input has occurred since the last
 *         time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the
 *         PMSRC registers are written to.
 *  0b010..Sticky falling edge. Match occurs if a falling edge on the specified input has occurred since the last
 *         time the edge detection for this bit slice was cleared. This bit is only cleared when the PMCFG or the
 *         PMSRC registers are written to.
 *  0b011..Sticky rising or falling edge. Match occurs if either a rising or falling edge on the specified input
 *         has occurred since the last time the edge detection for this bit slice was cleared. This bit is only
 *         cleared when the PMCFG or the PMSRC registers are written to.
 *  0b100..High level. Match (for this bit slice) occurs when there is a high level on the input specified for this bit slice in the PMSRC register.
 *  0b101..Low level. Match occurs when there is a low level on the specified input.
 *  0b110..Constant 0. This bit slice never contributes to a match (should be used to disable any unused bit slices).
 *  0b111..Event. Non-sticky rising or falling edge. Match occurs on an event - i.e. when either a rising or
 *         falling edge is first detected on the specified input (this is a non-sticky version of value 0x3) . This bit
 *         is cleared after one clock cycle.
 */
#define PINT_PMCFG_CFG7(x)                       (((uint32_t)(((uint32_t)(x)) << PINT_PMCFG_CFG7_SHIFT)) & PINT_PMCFG_CFG7_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group PINT_Register_Masks */


/* PINT - Peripheral instance base addresses */
/** Peripheral PINT base address */
#define PINT_BASE                                (0x40025000u)
/** Peripheral PINT base pointer */
#define PINT                                     ((PINT_Type *)PINT_BASE)
/** Array initializer of PINT peripheral base addresses */
#define PINT_BASE_ADDRS                          { PINT_BASE }
/** Array initializer of PINT peripheral base pointers */
#define PINT_BASE_PTRS                           { PINT }
/** Interrupt vectors for the PINT peripheral type */
#define PINT_IRQS                                { PIN_INT0_IRQn, PIN_INT1_IRQn, PIN_INT2_IRQn, PIN_INT3_IRQn, PIN_INT4_IRQn, PIN_INT5_IRQn, PIN_INT6_IRQn, PIN_INT7_IRQn }

/*!
 * @}
 */ /* end of group PINT_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- PUF Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup PUF_Peripheral_Access_Layer PUF Peripheral Access Layer
 * @{
 */

/** PUF - Register Layout Typedef */
typedef struct {
  __IO uint32_t CTRL;                              /**< PUF Control, offset: 0x0 */
  __IO uint32_t KEYINDEX;                          /**< PUF Key Index, offset: 0x4 */
  __IO uint32_t KEYSIZE;                           /**< PUF Key Size, offset: 0x8 */
       uint8_t RESERVED_0[20];
  __I  uint32_t STAT;                              /**< PUF Status, offset: 0x20 */
       uint8_t RESERVED_1[4];
  __I  uint32_t ALLOW;                             /**< PUF Allow, offset: 0x28 */
       uint8_t RESERVED_2[20];
  __O  uint32_t KEYINPUT;                          /**< PUF Key Input, offset: 0x40 */
  __O  uint32_t CODEINPUT;                         /**< PUF Code Input, offset: 0x44 */
  __I  uint32_t CODEOUTPUT;                        /**< PUF Code Output, offset: 0x48 */
       uint8_t RESERVED_3[20];
  __I  uint32_t KEYOUTINDEX;                       /**< PUF Key Output Index, offset: 0x60 */
  __I  uint32_t KEYOUTPUT;                         /**< PUF Key Output, offset: 0x64 */
       uint8_t RESERVED_4[116];
  __IO uint32_t IFSTAT;                            /**< PUF Interface Status and Clear, offset: 0xDC */
       uint8_t RESERVED_5[28];
  __I  uint32_t VERSION;                           /**< PUF Version, offset: 0xFC */
  __IO uint32_t INTEN;                             /**< PUF Interrupt Enable, offset: 0x100 */
  __IO uint32_t INTSTAT;                           /**< PUF Interrupt Status, offset: 0x104 */
  __IO uint32_t PWRCTRL;                           /**< PUF Power Control, offset: 0x108 */
  __IO uint32_t CFG;                               /**< PUF Configuration, offset: 0x10C */
       uint8_t RESERVED_6[240];
  __IO uint32_t KEYLOCK;                           /**< Key Lock, offset: 0x200 */
  __IO uint32_t KEYENABLE;                         /**< Key Enable, offset: 0x204 */
  __O  uint32_t KEYRESET;                          /**< Key Reset, offset: 0x208 */
  __IO uint32_t IDXBLK_L;                          /**< Index Block Low, offset: 0x20C */
  __IO uint32_t IDXBLK_H_DP;                       /**< Index Block High Duplicate, offset: 0x210 */
  __O  uint32_t KEYMASK[2];                        /**< Key Mask 0..Key Mask 1, array offset: 0x214, array step: 0x4 */
       uint8_t RESERVED_7[56];
  __IO uint32_t IDXBLK_H;                          /**< Index Block High, offset: 0x254 */
  __IO uint32_t IDXBLK_L_DP;                       /**< Index Block Low Duplicate, offset: 0x258 */
} PUF_Type;

/* ----------------------------------------------------------------------------
   -- PUF Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup PUF_Register_Masks PUF Register Masks
 * @{
 */

/*! @name CTRL - PUF Control */
/*! @{ */

#define PUF_CTRL_ZEROIZE_MASK                    (0x1U)
#define PUF_CTRL_ZEROIZE_SHIFT                   (0U)
#define PUF_CTRL_ZEROIZE(x)                      (((uint32_t)(((uint32_t)(x)) << PUF_CTRL_ZEROIZE_SHIFT)) & PUF_CTRL_ZEROIZE_MASK)

#define PUF_CTRL_ENROLL_MASK                     (0x2U)
#define PUF_CTRL_ENROLL_SHIFT                    (1U)
#define PUF_CTRL_ENROLL(x)                       (((uint32_t)(((uint32_t)(x)) << PUF_CTRL_ENROLL_SHIFT)) & PUF_CTRL_ENROLL_MASK)

#define PUF_CTRL_START_MASK                      (0x4U)
#define PUF_CTRL_START_SHIFT                     (2U)
#define PUF_CTRL_START(x)                        (((uint32_t)(((uint32_t)(x)) << PUF_CTRL_START_SHIFT)) & PUF_CTRL_START_MASK)

#define PUF_CTRL_GENERATEKEY_MASK                (0x8U)
#define PUF_CTRL_GENERATEKEY_SHIFT               (3U)
#define PUF_CTRL_GENERATEKEY(x)                  (((uint32_t)(((uint32_t)(x)) << PUF_CTRL_GENERATEKEY_SHIFT)) & PUF_CTRL_GENERATEKEY_MASK)

#define PUF_CTRL_SETKEY_MASK                     (0x10U)
#define PUF_CTRL_SETKEY_SHIFT                    (4U)
#define PUF_CTRL_SETKEY(x)                       (((uint32_t)(((uint32_t)(x)) << PUF_CTRL_SETKEY_SHIFT)) & PUF_CTRL_SETKEY_MASK)

#define PUF_CTRL_GETKEY_MASK                     (0x40U)
#define PUF_CTRL_GETKEY_SHIFT                    (6U)
#define PUF_CTRL_GETKEY(x)                       (((uint32_t)(((uint32_t)(x)) << PUF_CTRL_GETKEY_SHIFT)) & PUF_CTRL_GETKEY_MASK)
/*! @} */

/*! @name KEYINDEX - PUF Key Index */
/*! @{ */

#define PUF_KEYINDEX_KEYIDX_MASK                 (0xFU)
#define PUF_KEYINDEX_KEYIDX_SHIFT                (0U)
#define PUF_KEYINDEX_KEYIDX(x)                   (((uint32_t)(((uint32_t)(x)) << PUF_KEYINDEX_KEYIDX_SHIFT)) & PUF_KEYINDEX_KEYIDX_MASK)
/*! @} */

/*! @name KEYSIZE - PUF Key Size */
/*! @{ */

#define PUF_KEYSIZE_KEYSIZE_MASK                 (0x3FU)
#define PUF_KEYSIZE_KEYSIZE_SHIFT                (0U)
/*! KEYSIZE - Key Size for Set Key operations
 */
#define PUF_KEYSIZE_KEYSIZE(x)                   (((uint32_t)(((uint32_t)(x)) << PUF_KEYSIZE_KEYSIZE_SHIFT)) & PUF_KEYSIZE_KEYSIZE_MASK)
/*! @} */

/*! @name STAT - PUF Status */
/*! @{ */

#define PUF_STAT_BUSY_MASK                       (0x1U)
#define PUF_STAT_BUSY_SHIFT                      (0U)
/*! BUSY - Busy
 */
#define PUF_STAT_BUSY(x)                         (((uint32_t)(((uint32_t)(x)) << PUF_STAT_BUSY_SHIFT)) & PUF_STAT_BUSY_MASK)

#define PUF_STAT_SUCCESS_MASK                    (0x2U)
#define PUF_STAT_SUCCESS_SHIFT                   (1U)
/*! SUCCESS - Success
 */
#define PUF_STAT_SUCCESS(x)                      (((uint32_t)(((uint32_t)(x)) << PUF_STAT_SUCCESS_SHIFT)) & PUF_STAT_SUCCESS_MASK)

#define PUF_STAT_ERROR_MASK                      (0x4U)
#define PUF_STAT_ERROR_SHIFT                     (2U)
/*! ERROR - Error
 */
#define PUF_STAT_ERROR(x)                        (((uint32_t)(((uint32_t)(x)) << PUF_STAT_ERROR_SHIFT)) & PUF_STAT_ERROR_MASK)

#define PUF_STAT_KEYINREQ_MASK                   (0x10U)
#define PUF_STAT_KEYINREQ_SHIFT                  (4U)
/*! KEYINREQ - Key In Request
 */
#define PUF_STAT_KEYINREQ(x)                     (((uint32_t)(((uint32_t)(x)) << PUF_STAT_KEYINREQ_SHIFT)) & PUF_STAT_KEYINREQ_MASK)

#define PUF_STAT_KEYOUTAVAIL_MASK                (0x20U)
#define PUF_STAT_KEYOUTAVAIL_SHIFT               (5U)
/*! KEYOUTAVAIL - Key Out Available
 */
#define PUF_STAT_KEYOUTAVAIL(x)                  (((uint32_t)(((uint32_t)(x)) << PUF_STAT_KEYOUTAVAIL_SHIFT)) & PUF_STAT_KEYOUTAVAIL_MASK)

#define PUF_STAT_CODEINREQ_MASK                  (0x40U)
#define PUF_STAT_CODEINREQ_SHIFT                 (6U)
/*! CODEINREQ - Code In Request
 */
#define PUF_STAT_CODEINREQ(x)                    (((uint32_t)(((uint32_t)(x)) << PUF_STAT_CODEINREQ_SHIFT)) & PUF_STAT_CODEINREQ_MASK)

#define PUF_STAT_CODEOUTAVAIL_MASK               (0x80U)
#define PUF_STAT_CODEOUTAVAIL_SHIFT              (7U)
/*! CODEOUTAVAIL - Code Out Available
 */
#define PUF_STAT_CODEOUTAVAIL(x)                 (((uint32_t)(((uint32_t)(x)) << PUF_STAT_CODEOUTAVAIL_SHIFT)) & PUF_STAT_CODEOUTAVAIL_MASK)
/*! @} */

/*! @name ALLOW - PUF Allow */
/*! @{ */

#define PUF_ALLOW_ALLOWENROLL_MASK               (0x1U)
#define PUF_ALLOW_ALLOWENROLL_SHIFT              (0U)
/*! ALLOWENROLL - Allow Enroll
 */
#define PUF_ALLOW_ALLOWENROLL(x)                 (((uint32_t)(((uint32_t)(x)) << PUF_ALLOW_ALLOWENROLL_SHIFT)) & PUF_ALLOW_ALLOWENROLL_MASK)

#define PUF_ALLOW_ALLOWSTART_MASK                (0x2U)
#define PUF_ALLOW_ALLOWSTART_SHIFT               (1U)
/*! ALLOWSTART - Allow Start
 */
#define PUF_ALLOW_ALLOWSTART(x)                  (((uint32_t)(((uint32_t)(x)) << PUF_ALLOW_ALLOWSTART_SHIFT)) & PUF_ALLOW_ALLOWSTART_MASK)

#define PUF_ALLOW_ALLOWSETKEY_MASK               (0x4U)
#define PUF_ALLOW_ALLOWSETKEY_SHIFT              (2U)
/*! ALLOWSETKEY - Allow Set Key
 */
#define PUF_ALLOW_ALLOWSETKEY(x)                 (((uint32_t)(((uint32_t)(x)) << PUF_ALLOW_ALLOWSETKEY_SHIFT)) & PUF_ALLOW_ALLOWSETKEY_MASK)

#define PUF_ALLOW_ALLOWGETKEY_MASK               (0x8U)
#define PUF_ALLOW_ALLOWGETKEY_SHIFT              (3U)
/*! ALLOWGETKEY - Allow Get Key
 */
#define PUF_ALLOW_ALLOWGETKEY(x)                 (((uint32_t)(((uint32_t)(x)) << PUF_ALLOW_ALLOWGETKEY_SHIFT)) & PUF_ALLOW_ALLOWGETKEY_MASK)
/*! @} */

/*! @name KEYINPUT - PUF Key Input */
/*! @{ */

#define PUF_KEYINPUT_KEYIN_MASK                  (0xFFFFFFFFU)
#define PUF_KEYINPUT_KEYIN_SHIFT                 (0U)
/*! KEYIN - Key Input Data
 */
#define PUF_KEYINPUT_KEYIN(x)                    (((uint32_t)(((uint32_t)(x)) << PUF_KEYINPUT_KEYIN_SHIFT)) & PUF_KEYINPUT_KEYIN_MASK)
/*! @} */

/*! @name CODEINPUT - PUF Code Input */
/*! @{ */

#define PUF_CODEINPUT_CODEIN_MASK                (0xFFFFFFFFU)
#define PUF_CODEINPUT_CODEIN_SHIFT               (0U)
/*! CODEIN - AC/KC Input Data
 */
#define PUF_CODEINPUT_CODEIN(x)                  (((uint32_t)(((uint32_t)(x)) << PUF_CODEINPUT_CODEIN_SHIFT)) & PUF_CODEINPUT_CODEIN_MASK)
/*! @} */

/*! @name CODEOUTPUT - PUF Code Output */
/*! @{ */

#define PUF_CODEOUTPUT_CODEOUT_MASK              (0xFFFFFFFFU)
#define PUF_CODEOUTPUT_CODEOUT_SHIFT             (0U)
/*! CODEOUT - AC/KC Output Data
 */
#define PUF_CODEOUTPUT_CODEOUT(x)                (((uint32_t)(((uint32_t)(x)) << PUF_CODEOUTPUT_CODEOUT_SHIFT)) & PUF_CODEOUTPUT_CODEOUT_MASK)
/*! @} */

/*! @name KEYOUTINDEX - PUF Key Output Index */
/*! @{ */

#define PUF_KEYOUTINDEX_KEYOUTIDX_MASK           (0xFU)
#define PUF_KEYOUTINDEX_KEYOUTIDX_SHIFT          (0U)
/*! KEYOUTIDX - Key Output Index
 */
#define PUF_KEYOUTINDEX_KEYOUTIDX(x)             (((uint32_t)(((uint32_t)(x)) << PUF_KEYOUTINDEX_KEYOUTIDX_SHIFT)) & PUF_KEYOUTINDEX_KEYOUTIDX_MASK)
/*! @} */

/*! @name KEYOUTPUT - PUF Key Output */
/*! @{ */

#define PUF_KEYOUTPUT_KEYOUT_MASK                (0xFFFFFFFFU)
#define PUF_KEYOUTPUT_KEYOUT_SHIFT               (0U)
/*! KEYOUT - Key Output Data
 */
#define PUF_KEYOUTPUT_KEYOUT(x)                  (((uint32_t)(((uint32_t)(x)) << PUF_KEYOUTPUT_KEYOUT_SHIFT)) & PUF_KEYOUTPUT_KEYOUT_MASK)
/*! @} */

/*! @name IFSTAT - PUF Interface Status and Clear */
/*! @{ */

#define PUF_IFSTAT_ERROR_MASK                    (0x1U)
#define PUF_IFSTAT_ERROR_SHIFT                   (0U)
/*! ERROR - Error
 */
#define PUF_IFSTAT_ERROR(x)                      (((uint32_t)(((uint32_t)(x)) << PUF_IFSTAT_ERROR_SHIFT)) & PUF_IFSTAT_ERROR_MASK)
/*! @} */

/*! @name VERSION - PUF Version */
/*! @{ */

#define PUF_VERSION_VERSION_MASK                 (0xFFFFFFFFU)
#define PUF_VERSION_VERSION_SHIFT                (0U)
/*! VERSION - Version
 */
#define PUF_VERSION_VERSION(x)                   (((uint32_t)(((uint32_t)(x)) << PUF_VERSION_VERSION_SHIFT)) & PUF_VERSION_VERSION_MASK)
/*! @} */

/*! @name INTEN - PUF Interrupt Enable */
/*! @{ */

#define PUF_INTEN_READYEN_MASK                   (0x1U)
#define PUF_INTEN_READYEN_SHIFT                  (0U)
/*! READYEN - Enable corresponding interrupt in STAT, which indicates that the initialization or a operation is completed.
 */
#define PUF_INTEN_READYEN(x)                     (((uint32_t)(((uint32_t)(x)) << PUF_INTEN_READYEN_SHIFT)) & PUF_INTEN_READYEN_MASK)

#define PUF_INTEN_SUCCESEN_MASK                  (0x2U)
#define PUF_INTEN_SUCCESEN_SHIFT                 (1U)
/*! SUCCESEN - Enable corresponding interrupt in STAT, which indicates last operation was successful.
 */
#define PUF_INTEN_SUCCESEN(x)                    (((uint32_t)(((uint32_t)(x)) << PUF_INTEN_SUCCESEN_SHIFT)) & PUF_INTEN_SUCCESEN_MASK)

#define PUF_INTEN_ERROREN_MASK                   (0x4U)
#define PUF_INTEN_ERROREN_SHIFT                  (2U)
/*! ERROREN - Enable corresponding interrupt in STAT, which indicates that PUF is in the error state
 *    and no operations can be performed.
 */
#define PUF_INTEN_ERROREN(x)                     (((uint32_t)(((uint32_t)(x)) << PUF_INTEN_ERROREN_SHIFT)) & PUF_INTEN_ERROREN_MASK)

#define PUF_INTEN_KEYINREQEN_MASK                (0x10U)
#define PUF_INTEN_KEYINREQEN_SHIFT               (4U)
/*! KEYINREQEN - Enable corresponding interrupt in STAT, which is request for next part of key.
 */
#define PUF_INTEN_KEYINREQEN(x)                  (((uint32_t)(((uint32_t)(x)) << PUF_INTEN_KEYINREQEN_SHIFT)) & PUF_INTEN_KEYINREQEN_MASK)

#define PUF_INTEN_KEYOUTAVAILEN_MASK             (0x20U)
#define PUF_INTEN_KEYOUTAVAILEN_SHIFT            (5U)
/*! KEYOUTAVAILEN - Enable corresponding interrupt in STAT, which is next part of key is available.
 */
#define PUF_INTEN_KEYOUTAVAILEN(x)               (((uint32_t)(((uint32_t)(x)) << PUF_INTEN_KEYOUTAVAILEN_SHIFT)) & PUF_INTEN_KEYOUTAVAILEN_MASK)

#define PUF_INTEN_CODEINREQEN_MASK               (0x40U)
#define PUF_INTEN_CODEINREQEN_SHIFT              (6U)
/*! CODEINREQEN - Enable corresponding interrupt in STAT, which is request for next part of AC/KC.
 */
#define PUF_INTEN_CODEINREQEN(x)                 (((uint32_t)(((uint32_t)(x)) << PUF_INTEN_CODEINREQEN_SHIFT)) & PUF_INTEN_CODEINREQEN_MASK)

#define PUF_INTEN_CODEOUTAVAILEN_MASK            (0x80U)
#define PUF_INTEN_CODEOUTAVAILEN_SHIFT           (7U)
/*! CODEOUTAVAILEN - Enable corresponding interrupt in STAT, which is next part of AC/KC is available.
 */
#define PUF_INTEN_CODEOUTAVAILEN(x)              (((uint32_t)(((uint32_t)(x)) << PUF_INTEN_CODEOUTAVAILEN_SHIFT)) & PUF_INTEN_CODEOUTAVAILEN_MASK)
/*! @} */

/*! @name INTSTAT - PUF Interrupt Status */
/*! @{ */

#define PUF_INTSTAT_READY_MASK                   (0x1U)
#define PUF_INTSTAT_READY_SHIFT                  (0U)
/*! READY - Ready
 */
#define PUF_INTSTAT_READY(x)                     (((uint32_t)(((uint32_t)(x)) << PUF_INTSTAT_READY_SHIFT)) & PUF_INTSTAT_READY_MASK)

#define PUF_INTSTAT_SUCCESS_MASK                 (0x2U)
#define PUF_INTSTAT_SUCCESS_SHIFT                (1U)
/*! SUCCESS - Success
 */
#define PUF_INTSTAT_SUCCESS(x)                   (((uint32_t)(((uint32_t)(x)) << PUF_INTSTAT_SUCCESS_SHIFT)) & PUF_INTSTAT_SUCCESS_MASK)

#define PUF_INTSTAT_ERROR_MASK                   (0x4U)
#define PUF_INTSTAT_ERROR_SHIFT                  (2U)
/*! ERROR - Error
 */
#define PUF_INTSTAT_ERROR(x)                     (((uint32_t)(((uint32_t)(x)) << PUF_INTSTAT_ERROR_SHIFT)) & PUF_INTSTAT_ERROR_MASK)

#define PUF_INTSTAT_KEYINREQ_MASK                (0x10U)
#define PUF_INTSTAT_KEYINREQ_SHIFT               (4U)
/*! KEYINREQ - Key In Request
 */
#define PUF_INTSTAT_KEYINREQ(x)                  (((uint32_t)(((uint32_t)(x)) << PUF_INTSTAT_KEYINREQ_SHIFT)) & PUF_INTSTAT_KEYINREQ_MASK)

#define PUF_INTSTAT_KEYOUTAVAIL_MASK             (0x20U)
#define PUF_INTSTAT_KEYOUTAVAIL_SHIFT            (5U)
/*! KEYOUTAVAIL - Key Out Available
 */
#define PUF_INTSTAT_KEYOUTAVAIL(x)               (((uint32_t)(((uint32_t)(x)) << PUF_INTSTAT_KEYOUTAVAIL_SHIFT)) & PUF_INTSTAT_KEYOUTAVAIL_MASK)

#define PUF_INTSTAT_CODEINREQ_MASK               (0x40U)
#define PUF_INTSTAT_CODEINREQ_SHIFT              (6U)
/*! CODEINREQ - Code In Request
 */
#define PUF_INTSTAT_CODEINREQ(x)                 (((uint32_t)(((uint32_t)(x)) << PUF_INTSTAT_CODEINREQ_SHIFT)) & PUF_INTSTAT_CODEINREQ_MASK)

#define PUF_INTSTAT_CODEOUTAVAIL_MASK            (0x80U)
#define PUF_INTSTAT_CODEOUTAVAIL_SHIFT           (7U)
/*! CODEOUTAVAIL - Code Out Available
 */
#define PUF_INTSTAT_CODEOUTAVAIL(x)              (((uint32_t)(((uint32_t)(x)) << PUF_INTSTAT_CODEOUTAVAIL_SHIFT)) & PUF_INTSTAT_CODEOUTAVAIL_MASK)
/*! @} */

/*! @name PWRCTRL - PUF Power Control */
/*! @{ */

#define PUF_PWRCTRL_RAM_ON_MASK                  (0x1U)
#define PUF_PWRCTRL_RAM_ON_SHIFT                 (0U)
/*! RAM_ON - RAM Power On
 *  0b0..Power Off
 *  0b1..Power On
 */
#define PUF_PWRCTRL_RAM_ON(x)                    (((uint32_t)(((uint32_t)(x)) << PUF_PWRCTRL_RAM_ON_SHIFT)) & PUF_PWRCTRL_RAM_ON_MASK)

#define PUF_PWRCTRL_CK_DIS_MASK                  (0x4U)
#define PUF_PWRCTRL_CK_DIS_SHIFT                 (2U)
/*! CK_DIS - PUF Clock control.
 *  0b0..PUF RAM clock is disabled.
 *  0b1..PUF RAM clock is enabled.
 */
#define PUF_PWRCTRL_CK_DIS(x)                    (((uint32_t)(((uint32_t)(x)) << PUF_PWRCTRL_CK_DIS_SHIFT)) & PUF_PWRCTRL_CK_DIS_MASK)
/*! @} */

/*! @name CFG - PUF Configuration */
/*! @{ */

#define PUF_CFG_BLOCKENROLL_SETKEY_MASK          (0x1U)
#define PUF_CFG_BLOCKENROLL_SETKEY_SHIFT         (0U)
/*! BLOCKENROLL_SETKEY - Block Enroll and Set Key Operation
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define PUF_CFG_BLOCKENROLL_SETKEY(x)            (((uint32_t)(((uint32_t)(x)) << PUF_CFG_BLOCKENROLL_SETKEY_SHIFT)) & PUF_CFG_BLOCKENROLL_SETKEY_MASK)

#define PUF_CFG_BLOCKKEYOUTPUT_MASK              (0x2U)
#define PUF_CFG_BLOCKKEYOUTPUT_SHIFT             (1U)
/*! BLOCKKEYOUTPUT - Block Key Output Data
 *  0b0..Disabled. BLOCKKEYOUTPUT is cleared on reset.
 *  0b1..Enabled.
 */
#define PUF_CFG_BLOCKKEYOUTPUT(x)                (((uint32_t)(((uint32_t)(x)) << PUF_CFG_BLOCKKEYOUTPUT_SHIFT)) & PUF_CFG_BLOCKKEYOUTPUT_MASK)
/*! @} */

/*! @name KEYLOCK - Key Lock */
/*! @{ */

#define PUF_KEYLOCK_KEY0_MASK                    (0x3U)
#define PUF_KEYLOCK_KEY0_SHIFT                   (0U)
/*! KEY0 - Key 0
 *  0b00, 0b01, 0b11..Write access to KEY0MASK, KEYENABLE[KEY0] and KEYRESET[KEY0] is NOT allowed.
 *  0b10..Write access to KEY0MASK, KEYENABLE[KEY0] and KEYRESET[KEY0] is allowed.
 */
#define PUF_KEYLOCK_KEY0(x)                      (((uint32_t)(((uint32_t)(x)) << PUF_KEYLOCK_KEY0_SHIFT)) & PUF_KEYLOCK_KEY0_MASK)

#define PUF_KEYLOCK_KEY1_MASK                    (0xCU)
#define PUF_KEYLOCK_KEY1_SHIFT                   (2U)
/*! KEY1 - Key 1
 *  0b00, 0b01, 0b11..Write access to KEY1MASK, KEYENABLE[KEY1] and KEYRESET[KEY1] is NOT allowed.
 *  0b10..Write access to KEY1MASK, KEYENABLE[KEY1] and KEYRESET[KEY1] is allowed.
 */
#define PUF_KEYLOCK_KEY1(x)                      (((uint32_t)(((uint32_t)(x)) << PUF_KEYLOCK_KEY1_SHIFT)) & PUF_KEYLOCK_KEY1_MASK)

#define PUF_KEYLOCK_KEY2_MASK                    (0x30U)
#define PUF_KEYLOCK_KEY2_SHIFT                   (4U)
/*! KEY2 - Key 2
 *  0b00, 0b01, 0b11..Write access to KEY2MASK, KEYENABLE[KEY2] and KEYRESET[KEY2] is NOT allowed.
 *  0b10..Write access to KEY2MASK, KEYENABLE[KEY2] and KEYRESET[KEY2] is allowed.
 */
#define PUF_KEYLOCK_KEY2(x)                      (((uint32_t)(((uint32_t)(x)) << PUF_KEYLOCK_KEY2_SHIFT)) & PUF_KEYLOCK_KEY2_MASK)

#define PUF_KEYLOCK_KEY3_MASK                    (0xC0U)
#define PUF_KEYLOCK_KEY3_SHIFT                   (6U)
/*! KEY3 - Key 3
 *  0b00, 0b01, 0b11..Write access to KEY3MASK, KEYENABLE[KEY3] and KEYRESET[KEY3] is NOT allowed.
 *  0b10..Write access to KEY3MASK, KEYENABLE[KEY3] and KEYRESET[KEY3] is allowed.
 */
#define PUF_KEYLOCK_KEY3(x)                      (((uint32_t)(((uint32_t)(x)) << PUF_KEYLOCK_KEY3_SHIFT)) & PUF_KEYLOCK_KEY3_MASK)
/*! @} */

/*! @name KEYENABLE - Key Enable */
/*! @{ */

#define PUF_KEYENABLE_KEY0_MASK                  (0x3U)
#define PUF_KEYENABLE_KEY0_SHIFT                 (0U)
/*! KEY0 - Key 0
 *  0b00, 0b01, 0b11..Data coming from the PUF Index 0 interface are NOT shifted in the KEY0 register.
 *  0b10..Data coming from the PUF Index 0 interface are shifted in the KEY0 register.
 */
#define PUF_KEYENABLE_KEY0(x)                    (((uint32_t)(((uint32_t)(x)) << PUF_KEYENABLE_KEY0_SHIFT)) & PUF_KEYENABLE_KEY0_MASK)

#define PUF_KEYENABLE_KEY1_MASK                  (0xCU)
#define PUF_KEYENABLE_KEY1_SHIFT                 (2U)
/*! KEY1 - Key 1
 *  0b00, 0b01, 0b11..Data coming from the PUF Index 0 interface are NOT shifted in the KEY1 register.
 *  0b10..Data coming from the PUF Index 0 interface are shifted in the KEY1 register.
 */
#define PUF_KEYENABLE_KEY1(x)                    (((uint32_t)(((uint32_t)(x)) << PUF_KEYENABLE_KEY1_SHIFT)) & PUF_KEYENABLE_KEY1_MASK)

#define PUF_KEYENABLE_KEY2_MASK                  (0x30U)
#define PUF_KEYENABLE_KEY2_SHIFT                 (4U)
/*! KEY2 - Key 2
 *  0b00, 0b01, 0b11..Data coming from the PUF Index 0 interface are NOT shifted in the KEY2 register.
 *  0b10..Data coming from the PUF Index 0 interface are shifted in the KEY2 register.
 */
#define PUF_KEYENABLE_KEY2(x)                    (((uint32_t)(((uint32_t)(x)) << PUF_KEYENABLE_KEY2_SHIFT)) & PUF_KEYENABLE_KEY2_MASK)

#define PUF_KEYENABLE_KEY3_MASK                  (0xC0U)
#define PUF_KEYENABLE_KEY3_SHIFT                 (6U)
/*! KEY3 - Key 3
 *  0b00, 0b01, 0b11..Data coming from the PUF Index 0 interface are NOT shifted in the KEY3 register.
 *  0b10..Data coming from the PUF Index 0 interface are shifted in the KEY3 register.
 */
#define PUF_KEYENABLE_KEY3(x)                    (((uint32_t)(((uint32_t)(x)) << PUF_KEYENABLE_KEY3_SHIFT)) & PUF_KEYENABLE_KEY3_MASK)
/*! @} */

/*! @name KEYRESET - Key Reset */
/*! @{ */

#define PUF_KEYRESET_KEY0_MASK                   (0x3U)
#define PUF_KEYRESET_KEY0_SHIFT                  (0U)
/*! KEY0 - Key 0
 *  0b10..Reset KEY0 Hold register and SHIFT_STATUS[KEY0].
 */
#define PUF_KEYRESET_KEY0(x)                     (((uint32_t)(((uint32_t)(x)) << PUF_KEYRESET_KEY0_SHIFT)) & PUF_KEYRESET_KEY0_MASK)

#define PUF_KEYRESET_KEY1_MASK                   (0xCU)
#define PUF_KEYRESET_KEY1_SHIFT                  (2U)
/*! KEY1 - Key 1
 *  0b10..Reset KEY1 Hold register and SHIFT_STATUS[KEY1].
 */
#define PUF_KEYRESET_KEY1(x)                     (((uint32_t)(((uint32_t)(x)) << PUF_KEYRESET_KEY1_SHIFT)) & PUF_KEYRESET_KEY1_MASK)

#define PUF_KEYRESET_KEY2_MASK                   (0x30U)
#define PUF_KEYRESET_KEY2_SHIFT                  (4U)
/*! KEY2 - Key 2
 *  0b10..Reset KEY2 Hold register and SHIFT_STATUS[KEY2].
 */
#define PUF_KEYRESET_KEY2(x)                     (((uint32_t)(((uint32_t)(x)) << PUF_KEYRESET_KEY2_SHIFT)) & PUF_KEYRESET_KEY2_MASK)

#define PUF_KEYRESET_KEY3_MASK                   (0xC0U)
#define PUF_KEYRESET_KEY3_SHIFT                  (6U)
/*! KEY3 - Key 3
 *  0b10..Reset KEY3 Hold register and SHIFT_STATUS[KEY3].
 */
#define PUF_KEYRESET_KEY3(x)                     (((uint32_t)(((uint32_t)(x)) << PUF_KEYRESET_KEY3_SHIFT)) & PUF_KEYRESET_KEY3_MASK)
/*! @} */

/*! @name IDXBLK_L - Index Block Low */
/*! @{ */

#define PUF_IDXBLK_L_IDX1_MASK                   (0xCU)
#define PUF_IDXBLK_L_IDX1_SHIFT                  (2U)
/*! IDX1 - Index 1
 */
#define PUF_IDXBLK_L_IDX1(x)                     (((uint32_t)(((uint32_t)(x)) << PUF_IDXBLK_L_IDX1_SHIFT)) & PUF_IDXBLK_L_IDX1_MASK)

#define PUF_IDXBLK_L_IDX2_MASK                   (0x30U)
#define PUF_IDXBLK_L_IDX2_SHIFT                  (4U)
/*! IDX2 - Index 2
 */
#define PUF_IDXBLK_L_IDX2(x)                     (((uint32_t)(((uint32_t)(x)) << PUF_IDXBLK_L_IDX2_SHIFT)) & PUF_IDXBLK_L_IDX2_MASK)

#define PUF_IDXBLK_L_IDX3_MASK                   (0xC0U)
#define PUF_IDXBLK_L_IDX3_SHIFT                  (6U)
/*! IDX3 - Index 3
 */
#define PUF_IDXBLK_L_IDX3(x)                     (((uint32_t)(((uint32_t)(x)) << PUF_IDXBLK_L_IDX3_SHIFT)) & PUF_IDXBLK_L_IDX3_MASK)

#define PUF_IDXBLK_L_IDX4_MASK                   (0x300U)
#define PUF_IDXBLK_L_IDX4_SHIFT                  (8U)
/*! IDX4 - Index 4
 */
#define PUF_IDXBLK_L_IDX4(x)                     (((uint32_t)(((uint32_t)(x)) << PUF_IDXBLK_L_IDX4_SHIFT)) & PUF_IDXBLK_L_IDX4_MASK)

#define PUF_IDXBLK_L_IDX5_MASK                   (0xC00U)
#define PUF_IDXBLK_L_IDX5_SHIFT                  (10U)
/*! IDX5 - Index 5
 */
#define PUF_IDXBLK_L_IDX5(x)                     (((uint32_t)(((uint32_t)(x)) << PUF_IDXBLK_L_IDX5_SHIFT)) & PUF_IDXBLK_L_IDX5_MASK)

#define PUF_IDXBLK_L_IDX6_MASK                   (0x3000U)
#define PUF_IDXBLK_L_IDX6_SHIFT                  (12U)
/*! IDX6 - Index 6
 */
#define PUF_IDXBLK_L_IDX6(x)                     (((uint32_t)(((uint32_t)(x)) << PUF_IDXBLK_L_IDX6_SHIFT)) & PUF_IDXBLK_L_IDX6_MASK)

#define PUF_IDXBLK_L_IDX7_MASK                   (0xC000U)
#define PUF_IDXBLK_L_IDX7_SHIFT                  (14U)
/*! IDX7 - Index 7
 */
#define PUF_IDXBLK_L_IDX7(x)                     (((uint32_t)(((uint32_t)(x)) << PUF_IDXBLK_L_IDX7_SHIFT)) & PUF_IDXBLK_L_IDX7_MASK)

#define PUF_IDXBLK_L_LOCK_IDX_MASK               (0xC0000000U)
#define PUF_IDXBLK_L_LOCK_IDX_SHIFT              (30U)
/*! LOCK_IDX - Lock Index
 */
#define PUF_IDXBLK_L_LOCK_IDX(x)                 (((uint32_t)(((uint32_t)(x)) << PUF_IDXBLK_L_LOCK_IDX_SHIFT)) & PUF_IDXBLK_L_LOCK_IDX_MASK)
/*! @} */

/*! @name IDXBLK_H_DP - Index Block High Duplicate */
/*! @{ */

#define PUF_IDXBLK_H_DP_IDX8_MASK                (0x3U)
#define PUF_IDXBLK_H_DP_IDX8_SHIFT               (0U)
/*! IDX8 - Index 8
 */
#define PUF_IDXBLK_H_DP_IDX8(x)                  (((uint32_t)(((uint32_t)(x)) << PUF_IDXBLK_H_DP_IDX8_SHIFT)) & PUF_IDXBLK_H_DP_IDX8_MASK)

#define PUF_IDXBLK_H_DP_IDX9_MASK                (0xCU)
#define PUF_IDXBLK_H_DP_IDX9_SHIFT               (2U)
/*! IDX9 - Index 9
 */
#define PUF_IDXBLK_H_DP_IDX9(x)                  (((uint32_t)(((uint32_t)(x)) << PUF_IDXBLK_H_DP_IDX9_SHIFT)) & PUF_IDXBLK_H_DP_IDX9_MASK)

#define PUF_IDXBLK_H_DP_IDX10_MASK               (0x30U)
#define PUF_IDXBLK_H_DP_IDX10_SHIFT              (4U)
/*! IDX10 - Index 10
 */
#define PUF_IDXBLK_H_DP_IDX10(x)                 (((uint32_t)(((uint32_t)(x)) << PUF_IDXBLK_H_DP_IDX10_SHIFT)) & PUF_IDXBLK_H_DP_IDX10_MASK)

#define PUF_IDXBLK_H_DP_IDX11_MASK               (0xC0U)
#define PUF_IDXBLK_H_DP_IDX11_SHIFT              (6U)
/*! IDX11 - Index 11
 */
#define PUF_IDXBLK_H_DP_IDX11(x)                 (((uint32_t)(((uint32_t)(x)) << PUF_IDXBLK_H_DP_IDX11_SHIFT)) & PUF_IDXBLK_H_DP_IDX11_MASK)

#define PUF_IDXBLK_H_DP_IDX12_MASK               (0x300U)
#define PUF_IDXBLK_H_DP_IDX12_SHIFT              (8U)
/*! IDX12 - Index 12
 */
#define PUF_IDXBLK_H_DP_IDX12(x)                 (((uint32_t)(((uint32_t)(x)) << PUF_IDXBLK_H_DP_IDX12_SHIFT)) & PUF_IDXBLK_H_DP_IDX12_MASK)

#define PUF_IDXBLK_H_DP_IDX13_MASK               (0xC00U)
#define PUF_IDXBLK_H_DP_IDX13_SHIFT              (10U)
/*! IDX13 - Index 13
 */
#define PUF_IDXBLK_H_DP_IDX13(x)                 (((uint32_t)(((uint32_t)(x)) << PUF_IDXBLK_H_DP_IDX13_SHIFT)) & PUF_IDXBLK_H_DP_IDX13_MASK)

#define PUF_IDXBLK_H_DP_IDX14_MASK               (0x3000U)
#define PUF_IDXBLK_H_DP_IDX14_SHIFT              (12U)
/*! IDX14 - Index 14
 */
#define PUF_IDXBLK_H_DP_IDX14(x)                 (((uint32_t)(((uint32_t)(x)) << PUF_IDXBLK_H_DP_IDX14_SHIFT)) & PUF_IDXBLK_H_DP_IDX14_MASK)

#define PUF_IDXBLK_H_DP_IDX15_MASK               (0xC000U)
#define PUF_IDXBLK_H_DP_IDX15_SHIFT              (14U)
/*! IDX15 - Index 15
 */
#define PUF_IDXBLK_H_DP_IDX15(x)                 (((uint32_t)(((uint32_t)(x)) << PUF_IDXBLK_H_DP_IDX15_SHIFT)) & PUF_IDXBLK_H_DP_IDX15_MASK)
/*! @} */

/*! @name KEYMASK - Key Mask 0..Key Mask 1 */
/*! @{ */

#define PUF_KEYMASK_KEYMASK_MASK                 (0xFFFFFFFFU)
#define PUF_KEYMASK_KEYMASK_SHIFT                (0U)
/*! KEYMASK - Key a Mask
 */
#define PUF_KEYMASK_KEYMASK(x)                   (((uint32_t)(((uint32_t)(x)) << PUF_KEYMASK_KEYMASK_SHIFT)) & PUF_KEYMASK_KEYMASK_MASK)
/*! @} */

/* The count of PUF_KEYMASK */
#define PUF_KEYMASK_COUNT                        (2U)

/*! @name IDXBLK_H - Index Block High */
/*! @{ */

#define PUF_IDXBLK_H_IDX8_MASK                   (0x3U)
#define PUF_IDXBLK_H_IDX8_SHIFT                  (0U)
/*! IDX8 - Index 8
 */
#define PUF_IDXBLK_H_IDX8(x)                     (((uint32_t)(((uint32_t)(x)) << PUF_IDXBLK_H_IDX8_SHIFT)) & PUF_IDXBLK_H_IDX8_MASK)

#define PUF_IDXBLK_H_IDX9_MASK                   (0xCU)
#define PUF_IDXBLK_H_IDX9_SHIFT                  (2U)
/*! IDX9 - Index 9
 */
#define PUF_IDXBLK_H_IDX9(x)                     (((uint32_t)(((uint32_t)(x)) << PUF_IDXBLK_H_IDX9_SHIFT)) & PUF_IDXBLK_H_IDX9_MASK)

#define PUF_IDXBLK_H_IDX10_MASK                  (0x30U)
#define PUF_IDXBLK_H_IDX10_SHIFT                 (4U)
/*! IDX10 - Index 10
 */
#define PUF_IDXBLK_H_IDX10(x)                    (((uint32_t)(((uint32_t)(x)) << PUF_IDXBLK_H_IDX10_SHIFT)) & PUF_IDXBLK_H_IDX10_MASK)

#define PUF_IDXBLK_H_IDX11_MASK                  (0xC0U)
#define PUF_IDXBLK_H_IDX11_SHIFT                 (6U)
/*! IDX11 - Index 11
 */
#define PUF_IDXBLK_H_IDX11(x)                    (((uint32_t)(((uint32_t)(x)) << PUF_IDXBLK_H_IDX11_SHIFT)) & PUF_IDXBLK_H_IDX11_MASK)

#define PUF_IDXBLK_H_IDX12_MASK                  (0x300U)
#define PUF_IDXBLK_H_IDX12_SHIFT                 (8U)
/*! IDX12 - Index 12
 */
#define PUF_IDXBLK_H_IDX12(x)                    (((uint32_t)(((uint32_t)(x)) << PUF_IDXBLK_H_IDX12_SHIFT)) & PUF_IDXBLK_H_IDX12_MASK)

#define PUF_IDXBLK_H_IDX13_MASK                  (0xC00U)
#define PUF_IDXBLK_H_IDX13_SHIFT                 (10U)
/*! IDX13 - Index 13
 */
#define PUF_IDXBLK_H_IDX13(x)                    (((uint32_t)(((uint32_t)(x)) << PUF_IDXBLK_H_IDX13_SHIFT)) & PUF_IDXBLK_H_IDX13_MASK)

#define PUF_IDXBLK_H_IDX14_MASK                  (0x3000U)
#define PUF_IDXBLK_H_IDX14_SHIFT                 (12U)
/*! IDX14 - Index 14
 */
#define PUF_IDXBLK_H_IDX14(x)                    (((uint32_t)(((uint32_t)(x)) << PUF_IDXBLK_H_IDX14_SHIFT)) & PUF_IDXBLK_H_IDX14_MASK)

#define PUF_IDXBLK_H_IDX15_MASK                  (0xC000U)
#define PUF_IDXBLK_H_IDX15_SHIFT                 (14U)
/*! IDX15 - Index 15
 */
#define PUF_IDXBLK_H_IDX15(x)                    (((uint32_t)(((uint32_t)(x)) << PUF_IDXBLK_H_IDX15_SHIFT)) & PUF_IDXBLK_H_IDX15_MASK)

#define PUF_IDXBLK_H_LOCK_IDX_MASK               (0xC0000000U)
#define PUF_IDXBLK_H_LOCK_IDX_SHIFT              (30U)
/*! LOCK_IDX - Lock Index
 */
#define PUF_IDXBLK_H_LOCK_IDX(x)                 (((uint32_t)(((uint32_t)(x)) << PUF_IDXBLK_H_LOCK_IDX_SHIFT)) & PUF_IDXBLK_H_LOCK_IDX_MASK)
/*! @} */

/*! @name IDXBLK_L_DP - Index Block Low Duplicate */
/*! @{ */

#define PUF_IDXBLK_L_DP_IDX0_MASK                (0x3U)
#define PUF_IDXBLK_L_DP_IDX0_SHIFT               (0U)
/*! IDX0 - Index 0
 */
#define PUF_IDXBLK_L_DP_IDX0(x)                  (((uint32_t)(((uint32_t)(x)) << PUF_IDXBLK_L_DP_IDX0_SHIFT)) & PUF_IDXBLK_L_DP_IDX0_MASK)

#define PUF_IDXBLK_L_DP_IDX1_MASK                (0xCU)
#define PUF_IDXBLK_L_DP_IDX1_SHIFT               (2U)
/*! IDX1 - Index 1
 */
#define PUF_IDXBLK_L_DP_IDX1(x)                  (((uint32_t)(((uint32_t)(x)) << PUF_IDXBLK_L_DP_IDX1_SHIFT)) & PUF_IDXBLK_L_DP_IDX1_MASK)

#define PUF_IDXBLK_L_DP_IDX2_MASK                (0x30U)
#define PUF_IDXBLK_L_DP_IDX2_SHIFT               (4U)
/*! IDX2 - Index 2
 */
#define PUF_IDXBLK_L_DP_IDX2(x)                  (((uint32_t)(((uint32_t)(x)) << PUF_IDXBLK_L_DP_IDX2_SHIFT)) & PUF_IDXBLK_L_DP_IDX2_MASK)

#define PUF_IDXBLK_L_DP_IDX3_MASK                (0xC0U)
#define PUF_IDXBLK_L_DP_IDX3_SHIFT               (6U)
/*! IDX3 - Index 3
 */
#define PUF_IDXBLK_L_DP_IDX3(x)                  (((uint32_t)(((uint32_t)(x)) << PUF_IDXBLK_L_DP_IDX3_SHIFT)) & PUF_IDXBLK_L_DP_IDX3_MASK)

#define PUF_IDXBLK_L_DP_IDX4_MASK                (0x300U)
#define PUF_IDXBLK_L_DP_IDX4_SHIFT               (8U)
/*! IDX4 - Index 4
 */
#define PUF_IDXBLK_L_DP_IDX4(x)                  (((uint32_t)(((uint32_t)(x)) << PUF_IDXBLK_L_DP_IDX4_SHIFT)) & PUF_IDXBLK_L_DP_IDX4_MASK)

#define PUF_IDXBLK_L_DP_IDX5_MASK                (0xC00U)
#define PUF_IDXBLK_L_DP_IDX5_SHIFT               (10U)
/*! IDX5 - Index 5
 */
#define PUF_IDXBLK_L_DP_IDX5(x)                  (((uint32_t)(((uint32_t)(x)) << PUF_IDXBLK_L_DP_IDX5_SHIFT)) & PUF_IDXBLK_L_DP_IDX5_MASK)

#define PUF_IDXBLK_L_DP_IDX6_MASK                (0x3000U)
#define PUF_IDXBLK_L_DP_IDX6_SHIFT               (12U)
/*! IDX6 - Index 6
 */
#define PUF_IDXBLK_L_DP_IDX6(x)                  (((uint32_t)(((uint32_t)(x)) << PUF_IDXBLK_L_DP_IDX6_SHIFT)) & PUF_IDXBLK_L_DP_IDX6_MASK)

#define PUF_IDXBLK_L_DP_IDX7_MASK                (0xC000U)
#define PUF_IDXBLK_L_DP_IDX7_SHIFT               (14U)
/*! IDX7 - Index 7
 */
#define PUF_IDXBLK_L_DP_IDX7(x)                  (((uint32_t)(((uint32_t)(x)) << PUF_IDXBLK_L_DP_IDX7_SHIFT)) & PUF_IDXBLK_L_DP_IDX7_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group PUF_Register_Masks */


/* PUF - Peripheral instance base addresses */
/** Peripheral PUF base address */
#define PUF_BASE                                 (0x40006000u)
/** Peripheral PUF base pointer */
#define PUF                                      ((PUF_Type *)PUF_BASE)
/** Array initializer of PUF peripheral base addresses */
#define PUF_BASE_ADDRS                           { PUF_BASE }
/** Array initializer of PUF peripheral base pointers */
#define PUF_BASE_PTRS                            { PUF }

/*!
 * @}
 */ /* end of group PUF_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- RSTCTL0 Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup RSTCTL0_Peripheral_Access_Layer RSTCTL0 Peripheral Access Layer
 * @{
 */

/** RSTCTL0 - Register Layout Typedef */
typedef struct {
  __IO uint32_t SYSRSTSTAT;                        /**< system reset status register, offset: 0x0 */
       uint8_t RESERVED_0[12];
  __IO uint32_t PRSTCTL0;                          /**< peripheral reset control register 0, offset: 0x10 */
  __IO uint32_t PRSTCTL1;                          /**< peripheral reset control register 1, offset: 0x14 */
  __IO uint32_t PRSTCTL2;                          /**< peripheral reset control register 2, offset: 0x18 */
       uint8_t RESERVED_1[36];
  __O  uint32_t PRSTCTL0_SET;                      /**< peripheral reset set register 0, offset: 0x40 */
  __O  uint32_t PRSTCTL1_SET;                      /**< peripheral reset set register 1, offset: 0x44 */
  __O  uint32_t PRSTCTL2_SET;                      /**< peripheral reset set register 2, offset: 0x48 */
       uint8_t RESERVED_2[36];
  __O  uint32_t PRSTCTL0_CLR;                      /**< peripheral reset clear register 0, offset: 0x70 */
  __O  uint32_t PRSTCTL1_CLR;                      /**< peripheral reset clear register 1, offset: 0x74 */
  __O  uint32_t PRSTCTL2_CLR;                      /**< peripheral reset clear register 2, offset: 0x78 */
} RSTCTL0_Type;

/* ----------------------------------------------------------------------------
   -- RSTCTL0 Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup RSTCTL0_Register_Masks RSTCTL0 Register Masks
 * @{
 */

/*! @name SYSRSTSTAT - system reset status register */
/*! @{ */

#define RSTCTL0_SYSRSTSTAT_VDD_POR_MASK          (0x1U)
#define RSTCTL0_SYSRSTSTAT_VDD_POR_SHIFT         (0U)
/*! VDD_POR - VDD POR Event Detected:
 *  0b0..No event detected.
 *  0b1..VDD POR event detected. (Writing a '1' to this bit clears this status).
 */
#define RSTCTL0_SYSRSTSTAT_VDD_POR(x)            (((uint32_t)(((uint32_t)(x)) << RSTCTL0_SYSRSTSTAT_VDD_POR_SHIFT)) & RSTCTL0_SYSRSTSTAT_VDD_POR_MASK)

#define RSTCTL0_SYSRSTSTAT_PAD_RESET_MASK        (0x10U)
#define RSTCTL0_SYSRSTSTAT_PAD_RESET_SHIFT       (4U)
/*! PAD_RESET - PAD RESET Event Detected:
 *  0b0..No EVENT Detected.
 *  0b1..RESET Detected. (Write 1 to CLR),
 */
#define RSTCTL0_SYSRSTSTAT_PAD_RESET(x)          (((uint32_t)(((uint32_t)(x)) << RSTCTL0_SYSRSTSTAT_PAD_RESET_SHIFT)) & RSTCTL0_SYSRSTSTAT_PAD_RESET_MASK)

#define RSTCTL0_SYSRSTSTAT_ARM_APD_RESET_MASK    (0x20U)
#define RSTCTL0_SYSRSTSTAT_ARM_APD_RESET_SHIFT   (5U)
/*! ARM_APD_RESET - ARM RESET Event Detected:
 *  0b0..No event detected.
 *  0b1..ARM reset event detected. (Writing a '1' to this bit clears this status).
 */
#define RSTCTL0_SYSRSTSTAT_ARM_APD_RESET(x)      (((uint32_t)(((uint32_t)(x)) << RSTCTL0_SYSRSTSTAT_ARM_APD_RESET_SHIFT)) & RSTCTL0_SYSRSTSTAT_ARM_APD_RESET_MASK)

#define RSTCTL0_SYSRSTSTAT_WDT0_RESET_MASK       (0x40U)
#define RSTCTL0_SYSRSTSTAT_WDT0_RESET_SHIFT      (6U)
/*! WDT0_RESET - WDT0 RESET Event Detected:
 *  0b0..No EVENT Detected.
 *  0b1..WDT0 reset event detected. (Writing a '1' to this bit clears this status).
 */
#define RSTCTL0_SYSRSTSTAT_WDT0_RESET(x)         (((uint32_t)(((uint32_t)(x)) << RSTCTL0_SYSRSTSTAT_WDT0_RESET_SHIFT)) & RSTCTL0_SYSRSTSTAT_WDT0_RESET_MASK)

#define RSTCTL0_SYSRSTSTAT_WDT1_RESET_MASK       (0x80U)
#define RSTCTL0_SYSRSTSTAT_WDT1_RESET_SHIFT      (7U)
/*! WDT1_RESET - WDT1 RESET Event Detected:
 *  0b0..No EVENT Detected.
 *  0b1..WDT1 reset event detected. (Writing a 1 to this bit clears this status).
 */
#define RSTCTL0_SYSRSTSTAT_WDT1_RESET(x)         (((uint32_t)(((uint32_t)(x)) << RSTCTL0_SYSRSTSTAT_WDT1_RESET_SHIFT)) & RSTCTL0_SYSRSTSTAT_WDT1_RESET_MASK)
/*! @} */

/*! @name PRSTCTL0 - peripheral reset control register 0 */
/*! @{ */

#define RSTCTL0_PRSTCTL0_HIFI_DSP_MASK           (0x2U)
#define RSTCTL0_PRSTCTL0_HIFI_DSP_SHIFT          (1U)
/*! HIFI_DSP - HIFI DSP reset control
 *  0b0..clear reset
 *  0b1..set reset
 */
#define RSTCTL0_PRSTCTL0_HIFI_DSP(x)             (((uint32_t)(((uint32_t)(x)) << RSTCTL0_PRSTCTL0_HIFI_DSP_SHIFT)) & RSTCTL0_PRSTCTL0_HIFI_DSP_MASK)

#define RSTCTL0_PRSTCTL0_POWERQUAD_MASK          (0x100U)
#define RSTCTL0_PRSTCTL0_POWERQUAD_SHIFT         (8U)
/*! POWERQUAD - powerquad reset control
 *  0b0..clear reset
 *  0b1..set reset
 */
#define RSTCTL0_PRSTCTL0_POWERQUAD(x)            (((uint32_t)(((uint32_t)(x)) << RSTCTL0_PRSTCTL0_POWERQUAD_SHIFT)) & RSTCTL0_PRSTCTL0_POWERQUAD_MASK)

#define RSTCTL0_PRSTCTL0_CASPER_MASK             (0x200U)
#define RSTCTL0_PRSTCTL0_CASPER_SHIFT            (9U)
/*! CASPER - CAPSER reset control
 *  0b0..clear reset
 *  0b1..set reset
 */
#define RSTCTL0_PRSTCTL0_CASPER(x)               (((uint32_t)(((uint32_t)(x)) << RSTCTL0_PRSTCTL0_CASPER_SHIFT)) & RSTCTL0_PRSTCTL0_CASPER_MASK)

#define RSTCTL0_PRSTCTL0_HASHCRYPT_MASK          (0x400U)
#define RSTCTL0_PRSTCTL0_HASHCRYPT_SHIFT         (10U)
/*! HASHCRYPT - HASHCRYPT reset control
 *  0b0..clear reset
 *  0b1..set reset
 */
#define RSTCTL0_PRSTCTL0_HASHCRYPT(x)            (((uint32_t)(((uint32_t)(x)) << RSTCTL0_PRSTCTL0_HASHCRYPT_SHIFT)) & RSTCTL0_PRSTCTL0_HASHCRYPT_MASK)

#define RSTCTL0_PRSTCTL0_PUF_MASK                (0x800U)
#define RSTCTL0_PRSTCTL0_PUF_SHIFT               (11U)
/*! PUF - PUF reset control
 *  0b0..clear reset
 *  0b1..set reset
 */
#define RSTCTL0_PRSTCTL0_PUF(x)                  (((uint32_t)(((uint32_t)(x)) << RSTCTL0_PRSTCTL0_PUF_SHIFT)) & RSTCTL0_PRSTCTL0_PUF_MASK)

#define RSTCTL0_PRSTCTL0_RNG_MASK                (0x1000U)
#define RSTCTL0_PRSTCTL0_RNG_SHIFT               (12U)
/*! RNG - RNG reset control
 *  0b0..clear reset
 *  0b1..set reset
 */
#define RSTCTL0_PRSTCTL0_RNG(x)                  (((uint32_t)(((uint32_t)(x)) << RSTCTL0_PRSTCTL0_RNG_SHIFT)) & RSTCTL0_PRSTCTL0_RNG_MASK)

#define RSTCTL0_PRSTCTL0_FLEXSPI_OTFAD_MASK      (0x10000U)
#define RSTCTL0_PRSTCTL0_FLEXSPI_OTFAD_SHIFT     (16U)
/*! FLEXSPI_OTFAD - FLEXSPI reset control
 *  0b0..clear reset
 *  0b1..set reset
 */
#define RSTCTL0_PRSTCTL0_FLEXSPI_OTFAD(x)        (((uint32_t)(((uint32_t)(x)) << RSTCTL0_PRSTCTL0_FLEXSPI_OTFAD_SHIFT)) & RSTCTL0_PRSTCTL0_FLEXSPI_OTFAD_MASK)

#define RSTCTL0_PRSTCTL0_USBHS_PHY_MASK          (0x100000U)
#define RSTCTL0_PRSTCTL0_USBHS_PHY_SHIFT         (20U)
/*! USBHS_PHY - USB PHY reset control
 *  0b0..clear reset
 *  0b1..set reset
 */
#define RSTCTL0_PRSTCTL0_USBHS_PHY(x)            (((uint32_t)(((uint32_t)(x)) << RSTCTL0_PRSTCTL0_USBHS_PHY_SHIFT)) & RSTCTL0_PRSTCTL0_USBHS_PHY_MASK)

#define RSTCTL0_PRSTCTL0_USBHS_DEVICE_MASK       (0x200000U)
#define RSTCTL0_PRSTCTL0_USBHS_DEVICE_SHIFT      (21U)
/*! USBHS_DEVICE - USB DEVICE reset control
 *  0b0..clear reset
 *  0b1..set reset
 */
#define RSTCTL0_PRSTCTL0_USBHS_DEVICE(x)         (((uint32_t)(((uint32_t)(x)) << RSTCTL0_PRSTCTL0_USBHS_DEVICE_SHIFT)) & RSTCTL0_PRSTCTL0_USBHS_DEVICE_MASK)

#define RSTCTL0_PRSTCTL0_USBHS_HOST_MASK         (0x400000U)
#define RSTCTL0_PRSTCTL0_USBHS_HOST_SHIFT        (22U)
/*! USBHS_HOST - USB HOST reset control
 *  0b0..clear reset
 *  0b1..set reset
 */
#define RSTCTL0_PRSTCTL0_USBHS_HOST(x)           (((uint32_t)(((uint32_t)(x)) << RSTCTL0_PRSTCTL0_USBHS_HOST_SHIFT)) & RSTCTL0_PRSTCTL0_USBHS_HOST_MASK)

#define RSTCTL0_PRSTCTL0_USBHS_SRAM_MASK         (0x800000U)
#define RSTCTL0_PRSTCTL0_USBHS_SRAM_SHIFT        (23U)
/*! USBHS_SRAM - USBHS RAM reset control
 *  0b0..clear reset
 *  0b1..set reset
 */
#define RSTCTL0_PRSTCTL0_USBHS_SRAM(x)           (((uint32_t)(((uint32_t)(x)) << RSTCTL0_PRSTCTL0_USBHS_SRAM_SHIFT)) & RSTCTL0_PRSTCTL0_USBHS_SRAM_MASK)

#define RSTCTL0_PRSTCTL0_SCT_MASK                (0x1000000U)
#define RSTCTL0_PRSTCTL0_SCT_SHIFT               (24U)
/*! SCT - SCT reset control
 *  0b0..clear reset
 *  0b1..set reset
 */
#define RSTCTL0_PRSTCTL0_SCT(x)                  (((uint32_t)(((uint32_t)(x)) << RSTCTL0_PRSTCTL0_SCT_SHIFT)) & RSTCTL0_PRSTCTL0_SCT_MASK)
/*! @} */

/*! @name PRSTCTL1 - peripheral reset control register 1 */
/*! @{ */

#define RSTCTL0_PRSTCTL1_SDIO0_MASK              (0x4U)
#define RSTCTL0_PRSTCTL1_SDIO0_SHIFT             (2U)
/*! SDIO0 - SDIO0 reset control
 *  0b0..clear reset
 *  0b1..set reset
 */
#define RSTCTL0_PRSTCTL1_SDIO0(x)                (((uint32_t)(((uint32_t)(x)) << RSTCTL0_PRSTCTL1_SDIO0_SHIFT)) & RSTCTL0_PRSTCTL1_SDIO0_MASK)

#define RSTCTL0_PRSTCTL1_SDIO1_MASK              (0x8U)
#define RSTCTL0_PRSTCTL1_SDIO1_SHIFT             (3U)
/*! SDIO1 - SDIO1 reset control
 *  0b0..clear reset
 *  0b1..set reset
 */
#define RSTCTL0_PRSTCTL1_SDIO1(x)                (((uint32_t)(((uint32_t)(x)) << RSTCTL0_PRSTCTL1_SDIO1_SHIFT)) & RSTCTL0_PRSTCTL1_SDIO1_MASK)

#define RSTCTL0_PRSTCTL1_ACMP0_MASK              (0x8000U)
#define RSTCTL0_PRSTCTL1_ACMP0_SHIFT             (15U)
/*! ACMP0 - Analog comparator reset control
 *  0b0..clear reset
 *  0b1..set reset
 */
#define RSTCTL0_PRSTCTL1_ACMP0(x)                (((uint32_t)(((uint32_t)(x)) << RSTCTL0_PRSTCTL1_ACMP0_SHIFT)) & RSTCTL0_PRSTCTL1_ACMP0_MASK)

#define RSTCTL0_PRSTCTL1_ADC0_MASK               (0x10000U)
#define RSTCTL0_PRSTCTL1_ADC0_SHIFT              (16U)
/*! ADC0 - ADC reset control
 *  0b0..clear reset
 *  0b1..set reset
 */
#define RSTCTL0_PRSTCTL1_ADC0(x)                 (((uint32_t)(((uint32_t)(x)) << RSTCTL0_PRSTCTL1_ADC0_SHIFT)) & RSTCTL0_PRSTCTL1_ADC0_MASK)

#define RSTCTL0_PRSTCTL1_SHSGPIO0_MASK           (0x1000000U)
#define RSTCTL0_PRSTCTL1_SHSGPIO0_SHIFT          (24U)
/*! SHSGPIO0 - SHSGPIO0 reset control
 *  0b0..clear reset
 *  0b1..set reset
 */
#define RSTCTL0_PRSTCTL1_SHSGPIO0(x)             (((uint32_t)(((uint32_t)(x)) << RSTCTL0_PRSTCTL1_SHSGPIO0_SHIFT)) & RSTCTL0_PRSTCTL1_SHSGPIO0_MASK)
/*! @} */

/*! @name PRSTCTL2 - peripheral reset control register 2 */
/*! @{ */

#define RSTCTL0_PRSTCTL2_UTICK0_MASK             (0x1U)
#define RSTCTL0_PRSTCTL2_UTICK0_SHIFT            (0U)
/*! UTICK0 - utick reset control
 *  0b0..clear reset
 *  0b1..set reset
 */
#define RSTCTL0_PRSTCTL2_UTICK0(x)               (((uint32_t)(((uint32_t)(x)) << RSTCTL0_PRSTCTL2_UTICK0_SHIFT)) & RSTCTL0_PRSTCTL2_UTICK0_MASK)

#define RSTCTL0_PRSTCTL2_WWDT0_MASK              (0x2U)
#define RSTCTL0_PRSTCTL2_WWDT0_SHIFT             (1U)
/*! WWDT0 - wdt reset control
 *  0b0..clear reset
 *  0b1..set reset
 */
#define RSTCTL0_PRSTCTL2_WWDT0(x)                (((uint32_t)(((uint32_t)(x)) << RSTCTL0_PRSTCTL2_WWDT0_SHIFT)) & RSTCTL0_PRSTCTL2_WWDT0_MASK)
/*! @} */

/*! @name PRSTCTL0_SET - peripheral reset set register 0 */
/*! @{ */

#define RSTCTL0_PRSTCTL0_SET_HIFI_DSP_MASK       (0x2U)
#define RSTCTL0_PRSTCTL0_SET_HIFI_DSP_SHIFT      (1U)
/*! HIFI_DSP - HIFI DSP reset set
 *  0b0..No Effect
 *  0b1..Sets the PRSTCTL0 Bit
 */
#define RSTCTL0_PRSTCTL0_SET_HIFI_DSP(x)         (((uint32_t)(((uint32_t)(x)) << RSTCTL0_PRSTCTL0_SET_HIFI_DSP_SHIFT)) & RSTCTL0_PRSTCTL0_SET_HIFI_DSP_MASK)

#define RSTCTL0_PRSTCTL0_SET_POWERQUAD_MASK      (0x100U)
#define RSTCTL0_PRSTCTL0_SET_POWERQUAD_SHIFT     (8U)
/*! POWERQUAD - powerquad reset set
 *  0b0..No Effect
 *  0b1..Sets the PRSTCTL0 Bit
 */
#define RSTCTL0_PRSTCTL0_SET_POWERQUAD(x)        (((uint32_t)(((uint32_t)(x)) << RSTCTL0_PRSTCTL0_SET_POWERQUAD_SHIFT)) & RSTCTL0_PRSTCTL0_SET_POWERQUAD_MASK)

#define RSTCTL0_PRSTCTL0_SET_CASPER_MASK         (0x200U)
#define RSTCTL0_PRSTCTL0_SET_CASPER_SHIFT        (9U)
/*! CASPER - CAPSER reset set
 *  0b0..No Effect
 *  0b1..Sets the PRSTCTL0 Bit
 */
#define RSTCTL0_PRSTCTL0_SET_CASPER(x)           (((uint32_t)(((uint32_t)(x)) << RSTCTL0_PRSTCTL0_SET_CASPER_SHIFT)) & RSTCTL0_PRSTCTL0_SET_CASPER_MASK)

#define RSTCTL0_PRSTCTL0_SET_HASHCRYPT_MASK      (0x400U)
#define RSTCTL0_PRSTCTL0_SET_HASHCRYPT_SHIFT     (10U)
/*! HASHCRYPT - HASHCRYPT reset set
 *  0b0..No Effect
 *  0b1..Sets the PRSTCTL0 Bit
 */
#define RSTCTL0_PRSTCTL0_SET_HASHCRYPT(x)        (((uint32_t)(((uint32_t)(x)) << RSTCTL0_PRSTCTL0_SET_HASHCRYPT_SHIFT)) & RSTCTL0_PRSTCTL0_SET_HASHCRYPT_MASK)

#define RSTCTL0_PRSTCTL0_SET_PUF_MASK            (0x800U)
#define RSTCTL0_PRSTCTL0_SET_PUF_SHIFT           (11U)
/*! PUF - PUF reset set
 *  0b0..No Effect
 *  0b1..Sets the PRSTCTL0 Bit
 */
#define RSTCTL0_PRSTCTL0_SET_PUF(x)              (((uint32_t)(((uint32_t)(x)) << RSTCTL0_PRSTCTL0_SET_PUF_SHIFT)) & RSTCTL0_PRSTCTL0_SET_PUF_MASK)

#define RSTCTL0_PRSTCTL0_SET_RNG_MASK            (0x1000U)
#define RSTCTL0_PRSTCTL0_SET_RNG_SHIFT           (12U)
/*! RNG - RNG reset set
 *  0b0..No Effect
 *  0b1..Sets the PRSTCTL0 Bit
 */
#define RSTCTL0_PRSTCTL0_SET_RNG(x)              (((uint32_t)(((uint32_t)(x)) << RSTCTL0_PRSTCTL0_SET_RNG_SHIFT)) & RSTCTL0_PRSTCTL0_SET_RNG_MASK)

#define RSTCTL0_PRSTCTL0_SET_FLEXSPI_OTFAD_MASK  (0x10000U)
#define RSTCTL0_PRSTCTL0_SET_FLEXSPI_OTFAD_SHIFT (16U)
/*! FLEXSPI_OTFAD - FLEXSPI reset set
 *  0b0..No Effect
 *  0b1..Sets the PRSTCTL0 Bit
 */
#define RSTCTL0_PRSTCTL0_SET_FLEXSPI_OTFAD(x)    (((uint32_t)(((uint32_t)(x)) << RSTCTL0_PRSTCTL0_SET_FLEXSPI_OTFAD_SHIFT)) & RSTCTL0_PRSTCTL0_SET_FLEXSPI_OTFAD_MASK)

#define RSTCTL0_PRSTCTL0_SET_USBHS_PHY_MASK      (0x100000U)
#define RSTCTL0_PRSTCTL0_SET_USBHS_PHY_SHIFT     (20U)
/*! USBHS_PHY - USB PHY reset set
 *  0b0..No Effect
 *  0b1..Sets the PRSTCTL0 Bit
 */
#define RSTCTL0_PRSTCTL0_SET_USBHS_PHY(x)        (((uint32_t)(((uint32_t)(x)) << RSTCTL0_PRSTCTL0_SET_USBHS_PHY_SHIFT)) & RSTCTL0_PRSTCTL0_SET_USBHS_PHY_MASK)

#define RSTCTL0_PRSTCTL0_SET_USBHS_DEVICE_MASK   (0x200000U)
#define RSTCTL0_PRSTCTL0_SET_USBHS_DEVICE_SHIFT  (21U)
/*! USBHS_DEVICE - USB DEVICE reset set
 *  0b0..No Effect
 *  0b1..Sets the PRSTCTL0 Bit
 */
#define RSTCTL0_PRSTCTL0_SET_USBHS_DEVICE(x)     (((uint32_t)(((uint32_t)(x)) << RSTCTL0_PRSTCTL0_SET_USBHS_DEVICE_SHIFT)) & RSTCTL0_PRSTCTL0_SET_USBHS_DEVICE_MASK)

#define RSTCTL0_PRSTCTL0_SET_USBHS_HOST_MASK     (0x400000U)
#define RSTCTL0_PRSTCTL0_SET_USBHS_HOST_SHIFT    (22U)
/*! USBHS_HOST - USB HOST reset set
 *  0b0..No Effect
 *  0b1..Sets the PRSTCTL0 Bit
 */
#define RSTCTL0_PRSTCTL0_SET_USBHS_HOST(x)       (((uint32_t)(((uint32_t)(x)) << RSTCTL0_PRSTCTL0_SET_USBHS_HOST_SHIFT)) & RSTCTL0_PRSTCTL0_SET_USBHS_HOST_MASK)

#define RSTCTL0_PRSTCTL0_SET_USBHS_SRAM_MASK     (0x800000U)
#define RSTCTL0_PRSTCTL0_SET_USBHS_SRAM_SHIFT    (23U)
/*! USBHS_SRAM - USBHS RAM reset set
 *  0b0..No Effect
 *  0b1..Sets the PRSTCTL0 Bit
 */
#define RSTCTL0_PRSTCTL0_SET_USBHS_SRAM(x)       (((uint32_t)(((uint32_t)(x)) << RSTCTL0_PRSTCTL0_SET_USBHS_SRAM_SHIFT)) & RSTCTL0_PRSTCTL0_SET_USBHS_SRAM_MASK)

#define RSTCTL0_PRSTCTL0_SET_SCT_MASK            (0x1000000U)
#define RSTCTL0_PRSTCTL0_SET_SCT_SHIFT           (24U)
/*! SCT - SCT reset set
 *  0b0..No Effect
 *  0b1..Sets the PRSTCTL0 Bit
 */
#define RSTCTL0_PRSTCTL0_SET_SCT(x)              (((uint32_t)(((uint32_t)(x)) << RSTCTL0_PRSTCTL0_SET_SCT_SHIFT)) & RSTCTL0_PRSTCTL0_SET_SCT_MASK)
/*! @} */

/*! @name PRSTCTL1_SET - peripheral reset set register 1 */
/*! @{ */

#define RSTCTL0_PRSTCTL1_SET_SDIO0_MASK          (0x4U)
#define RSTCTL0_PRSTCTL1_SET_SDIO0_SHIFT         (2U)
/*! SDIO0 - SDIO0 reset set
 *  0b0..No Effect
 *  0b1..Sets the PRSTCTL1 Bit
 */
#define RSTCTL0_PRSTCTL1_SET_SDIO0(x)            (((uint32_t)(((uint32_t)(x)) << RSTCTL0_PRSTCTL1_SET_SDIO0_SHIFT)) & RSTCTL0_PRSTCTL1_SET_SDIO0_MASK)

#define RSTCTL0_PRSTCTL1_SET_SDIO1_MASK          (0x8U)
#define RSTCTL0_PRSTCTL1_SET_SDIO1_SHIFT         (3U)
/*! SDIO1 - SDIO1 reset set
 *  0b0..No Effect
 *  0b1..Sets the PRSTCTL1 Bit
 */
#define RSTCTL0_PRSTCTL1_SET_SDIO1(x)            (((uint32_t)(((uint32_t)(x)) << RSTCTL0_PRSTCTL1_SET_SDIO1_SHIFT)) & RSTCTL0_PRSTCTL1_SET_SDIO1_MASK)

#define RSTCTL0_PRSTCTL1_SET_ACMP0_MASK          (0x8000U)
#define RSTCTL0_PRSTCTL1_SET_ACMP0_SHIFT         (15U)
/*! ACMP0 - Analog comparator reset set
 *  0b0..No Effect
 *  0b1..Sets the PRSTCTL1 Bit
 */
#define RSTCTL0_PRSTCTL1_SET_ACMP0(x)            (((uint32_t)(((uint32_t)(x)) << RSTCTL0_PRSTCTL1_SET_ACMP0_SHIFT)) & RSTCTL0_PRSTCTL1_SET_ACMP0_MASK)

#define RSTCTL0_PRSTCTL1_SET_ADC0_MASK           (0x10000U)
#define RSTCTL0_PRSTCTL1_SET_ADC0_SHIFT          (16U)
/*! ADC0 - ADC reset set
 *  0b0..No Effect
 *  0b1..Sets the PRSTCTL1 Bit
 */
#define RSTCTL0_PRSTCTL1_SET_ADC0(x)             (((uint32_t)(((uint32_t)(x)) << RSTCTL0_PRSTCTL1_SET_ADC0_SHIFT)) & RSTCTL0_PRSTCTL1_SET_ADC0_MASK)

#define RSTCTL0_PRSTCTL1_SET_SHSGPIO0_MASK       (0x1000000U)
#define RSTCTL0_PRSTCTL1_SET_SHSGPIO0_SHIFT      (24U)
/*! SHSGPIO0 - SHSGPIO0 reset set
 *  0b0..No Effect
 *  0b1..Sets the PRSTCTL1 Bit
 */
#define RSTCTL0_PRSTCTL1_SET_SHSGPIO0(x)         (((uint32_t)(((uint32_t)(x)) << RSTCTL0_PRSTCTL1_SET_SHSGPIO0_SHIFT)) & RSTCTL0_PRSTCTL1_SET_SHSGPIO0_MASK)
/*! @} */

/*! @name PRSTCTL2_SET - peripheral reset set register 2 */
/*! @{ */

#define RSTCTL0_PRSTCTL2_SET_UTICK0_MASK         (0x1U)
#define RSTCTL0_PRSTCTL2_SET_UTICK0_SHIFT        (0U)
/*! UTICK0 - utick reset set
 *  0b0..No Effect
 *  0b1..Sets the PRSTCTL2 Bit
 */
#define RSTCTL0_PRSTCTL2_SET_UTICK0(x)           (((uint32_t)(((uint32_t)(x)) << RSTCTL0_PRSTCTL2_SET_UTICK0_SHIFT)) & RSTCTL0_PRSTCTL2_SET_UTICK0_MASK)

#define RSTCTL0_PRSTCTL2_SET_WWDT0_MASK          (0x2U)
#define RSTCTL0_PRSTCTL2_SET_WWDT0_SHIFT         (1U)
/*! WWDT0 - wdt reset set
 *  0b0..No Effect
 *  0b1..Sets the PRSTCTL2 Bit
 */
#define RSTCTL0_PRSTCTL2_SET_WWDT0(x)            (((uint32_t)(((uint32_t)(x)) << RSTCTL0_PRSTCTL2_SET_WWDT0_SHIFT)) & RSTCTL0_PRSTCTL2_SET_WWDT0_MASK)
/*! @} */

/*! @name PRSTCTL0_CLR - peripheral reset clear register 0 */
/*! @{ */

#define RSTCTL0_PRSTCTL0_CLR_HIFI_DSP_MASK       (0x2U)
#define RSTCTL0_PRSTCTL0_CLR_HIFI_DSP_SHIFT      (1U)
/*! HIFI_DSP - HIFI DSP reset clear
 *  0b0..No Effect
 *  0b1..Clears the PRSTCTL0 Bit
 */
#define RSTCTL0_PRSTCTL0_CLR_HIFI_DSP(x)         (((uint32_t)(((uint32_t)(x)) << RSTCTL0_PRSTCTL0_CLR_HIFI_DSP_SHIFT)) & RSTCTL0_PRSTCTL0_CLR_HIFI_DSP_MASK)

#define RSTCTL0_PRSTCTL0_CLR_POWERQUAD_MASK      (0x100U)
#define RSTCTL0_PRSTCTL0_CLR_POWERQUAD_SHIFT     (8U)
/*! POWERQUAD - powerquad reset clear
 *  0b0..No Effect
 *  0b1..Clears the PRSTCTL0 Bit
 */
#define RSTCTL0_PRSTCTL0_CLR_POWERQUAD(x)        (((uint32_t)(((uint32_t)(x)) << RSTCTL0_PRSTCTL0_CLR_POWERQUAD_SHIFT)) & RSTCTL0_PRSTCTL0_CLR_POWERQUAD_MASK)

#define RSTCTL0_PRSTCTL0_CLR_CASPER_MASK         (0x200U)
#define RSTCTL0_PRSTCTL0_CLR_CASPER_SHIFT        (9U)
/*! CASPER - CAPSER reset clear
 *  0b0..No Effect
 *  0b1..Clears the PRSTCTL0 Bit
 */
#define RSTCTL0_PRSTCTL0_CLR_CASPER(x)           (((uint32_t)(((uint32_t)(x)) << RSTCTL0_PRSTCTL0_CLR_CASPER_SHIFT)) & RSTCTL0_PRSTCTL0_CLR_CASPER_MASK)

#define RSTCTL0_PRSTCTL0_CLR_HASHCRYPT_MASK      (0x400U)
#define RSTCTL0_PRSTCTL0_CLR_HASHCRYPT_SHIFT     (10U)
/*! HASHCRYPT - HASHCRYPT reset clear
 *  0b0..No Effect
 *  0b1..Clears the PRSTCTL0 Bit
 */
#define RSTCTL0_PRSTCTL0_CLR_HASHCRYPT(x)        (((uint32_t)(((uint32_t)(x)) << RSTCTL0_PRSTCTL0_CLR_HASHCRYPT_SHIFT)) & RSTCTL0_PRSTCTL0_CLR_HASHCRYPT_MASK)

#define RSTCTL0_PRSTCTL0_CLR_PUF_MASK            (0x800U)
#define RSTCTL0_PRSTCTL0_CLR_PUF_SHIFT           (11U)
/*! PUF - PUF reset clear
 *  0b0..No Effect
 *  0b1..Clears the PRSTCTL0 Bit
 */
#define RSTCTL0_PRSTCTL0_CLR_PUF(x)              (((uint32_t)(((uint32_t)(x)) << RSTCTL0_PRSTCTL0_CLR_PUF_SHIFT)) & RSTCTL0_PRSTCTL0_CLR_PUF_MASK)

#define RSTCTL0_PRSTCTL0_CLR_RNG_MASK            (0x1000U)
#define RSTCTL0_PRSTCTL0_CLR_RNG_SHIFT           (12U)
/*! RNG - RNG reset clear
 *  0b0..No Effect
 *  0b1..Clears the PRSTCTL0 Bit
 */
#define RSTCTL0_PRSTCTL0_CLR_RNG(x)              (((uint32_t)(((uint32_t)(x)) << RSTCTL0_PRSTCTL0_CLR_RNG_SHIFT)) & RSTCTL0_PRSTCTL0_CLR_RNG_MASK)

#define RSTCTL0_PRSTCTL0_CLR_FLEXSPI_OTFAD_MASK  (0x10000U)
#define RSTCTL0_PRSTCTL0_CLR_FLEXSPI_OTFAD_SHIFT (16U)
/*! FLEXSPI_OTFAD - FLEXSPI reset clear
 *  0b0..No Effect
 *  0b1..Clears the PRSTCTL0 Bit
 */
#define RSTCTL0_PRSTCTL0_CLR_FLEXSPI_OTFAD(x)    (((uint32_t)(((uint32_t)(x)) << RSTCTL0_PRSTCTL0_CLR_FLEXSPI_OTFAD_SHIFT)) & RSTCTL0_PRSTCTL0_CLR_FLEXSPI_OTFAD_MASK)

#define RSTCTL0_PRSTCTL0_CLR_USBHS_PHY_MASK      (0x100000U)
#define RSTCTL0_PRSTCTL0_CLR_USBHS_PHY_SHIFT     (20U)
/*! USBHS_PHY - USB PHY reset clear
 *  0b0..No Effect
 *  0b1..Clears the PRSTCTL0 Bit
 */
#define RSTCTL0_PRSTCTL0_CLR_USBHS_PHY(x)        (((uint32_t)(((uint32_t)(x)) << RSTCTL0_PRSTCTL0_CLR_USBHS_PHY_SHIFT)) & RSTCTL0_PRSTCTL0_CLR_USBHS_PHY_MASK)

#define RSTCTL0_PRSTCTL0_CLR_USBHS_DEVICE_MASK   (0x200000U)
#define RSTCTL0_PRSTCTL0_CLR_USBHS_DEVICE_SHIFT  (21U)
/*! USBHS_DEVICE - USB DEVICE reset clear
 *  0b0..No Effect
 *  0b1..Clears the PRSTCTL0 Bit
 */
#define RSTCTL0_PRSTCTL0_CLR_USBHS_DEVICE(x)     (((uint32_t)(((uint32_t)(x)) << RSTCTL0_PRSTCTL0_CLR_USBHS_DEVICE_SHIFT)) & RSTCTL0_PRSTCTL0_CLR_USBHS_DEVICE_MASK)

#define RSTCTL0_PRSTCTL0_CLR_USBHS_HOST_MASK     (0x400000U)
#define RSTCTL0_PRSTCTL0_CLR_USBHS_HOST_SHIFT    (22U)
/*! USBHS_HOST - USB HOST reset clear
 *  0b0..No Effect
 *  0b1..Clears the PRSTCTL0 Bit
 */
#define RSTCTL0_PRSTCTL0_CLR_USBHS_HOST(x)       (((uint32_t)(((uint32_t)(x)) << RSTCTL0_PRSTCTL0_CLR_USBHS_HOST_SHIFT)) & RSTCTL0_PRSTCTL0_CLR_USBHS_HOST_MASK)

#define RSTCTL0_PRSTCTL0_CLR_USBHS_SRAM_MASK     (0x800000U)
#define RSTCTL0_PRSTCTL0_CLR_USBHS_SRAM_SHIFT    (23U)
/*! USBHS_SRAM - USBHS RAM reset clear
 *  0b0..No Effect
 *  0b1..Clears the PRSTCTL0 Bit
 */
#define RSTCTL0_PRSTCTL0_CLR_USBHS_SRAM(x)       (((uint32_t)(((uint32_t)(x)) << RSTCTL0_PRSTCTL0_CLR_USBHS_SRAM_SHIFT)) & RSTCTL0_PRSTCTL0_CLR_USBHS_SRAM_MASK)

#define RSTCTL0_PRSTCTL0_CLR_SCT_MASK            (0x1000000U)
#define RSTCTL0_PRSTCTL0_CLR_SCT_SHIFT           (24U)
/*! SCT - SCT reset clear
 *  0b0..No Effect
 *  0b1..Clears the PRSTCTL0 Bit
 */
#define RSTCTL0_PRSTCTL0_CLR_SCT(x)              (((uint32_t)(((uint32_t)(x)) << RSTCTL0_PRSTCTL0_CLR_SCT_SHIFT)) & RSTCTL0_PRSTCTL0_CLR_SCT_MASK)
/*! @} */

/*! @name PRSTCTL1_CLR - peripheral reset clear register 1 */
/*! @{ */

#define RSTCTL0_PRSTCTL1_CLR_SDIO0_MASK          (0x4U)
#define RSTCTL0_PRSTCTL1_CLR_SDIO0_SHIFT         (2U)
/*! SDIO0 - SDIO0 reset clear
 *  0b0..No Effect
 *  0b1..Clears the PRSTCTL1 Bit
 */
#define RSTCTL0_PRSTCTL1_CLR_SDIO0(x)            (((uint32_t)(((uint32_t)(x)) << RSTCTL0_PRSTCTL1_CLR_SDIO0_SHIFT)) & RSTCTL0_PRSTCTL1_CLR_SDIO0_MASK)

#define RSTCTL0_PRSTCTL1_CLR_SDIO1_MASK          (0x8U)
#define RSTCTL0_PRSTCTL1_CLR_SDIO1_SHIFT         (3U)
/*! SDIO1 - SDIO1 reset clear
 *  0b0..No Effect
 *  0b1..Clears the PRSTCTL1 Bit
 */
#define RSTCTL0_PRSTCTL1_CLR_SDIO1(x)            (((uint32_t)(((uint32_t)(x)) << RSTCTL0_PRSTCTL1_CLR_SDIO1_SHIFT)) & RSTCTL0_PRSTCTL1_CLR_SDIO1_MASK)

#define RSTCTL0_PRSTCTL1_CLR_ACMP0_MASK          (0x8000U)
#define RSTCTL0_PRSTCTL1_CLR_ACMP0_SHIFT         (15U)
/*! ACMP0 - Analog comparator reset clear
 *  0b0..No Effect
 *  0b1..Clears the PRSTCTL1 Bit
 */
#define RSTCTL0_PRSTCTL1_CLR_ACMP0(x)            (((uint32_t)(((uint32_t)(x)) << RSTCTL0_PRSTCTL1_CLR_ACMP0_SHIFT)) & RSTCTL0_PRSTCTL1_CLR_ACMP0_MASK)

#define RSTCTL0_PRSTCTL1_CLR_ADC0_MASK           (0x10000U)
#define RSTCTL0_PRSTCTL1_CLR_ADC0_SHIFT          (16U)
/*! ADC0 - ADC reset clear
 *  0b0..No Effect
 *  0b1..Clears the PRSTCTL1 Bit
 */
#define RSTCTL0_PRSTCTL1_CLR_ADC0(x)             (((uint32_t)(((uint32_t)(x)) << RSTCTL0_PRSTCTL1_CLR_ADC0_SHIFT)) & RSTCTL0_PRSTCTL1_CLR_ADC0_MASK)

#define RSTCTL0_PRSTCTL1_CLR_SHSGPIO0_MASK       (0x1000000U)
#define RSTCTL0_PRSTCTL1_CLR_SHSGPIO0_SHIFT      (24U)
/*! SHSGPIO0 - SHSGPIO0 reset clear
 *  0b0..No Effect
 *  0b1..Clears the PRSTCTL1 Bit
 */
#define RSTCTL0_PRSTCTL1_CLR_SHSGPIO0(x)         (((uint32_t)(((uint32_t)(x)) << RSTCTL0_PRSTCTL1_CLR_SHSGPIO0_SHIFT)) & RSTCTL0_PRSTCTL1_CLR_SHSGPIO0_MASK)
/*! @} */

/*! @name PRSTCTL2_CLR - peripheral reset clear register 2 */
/*! @{ */

#define RSTCTL0_PRSTCTL2_CLR_UTICK0_MASK         (0x1U)
#define RSTCTL0_PRSTCTL2_CLR_UTICK0_SHIFT        (0U)
/*! UTICK0 - utick reset clear
 *  0b0..No Effect
 *  0b1..Clears the PRSTCTL2 Bit
 */
#define RSTCTL0_PRSTCTL2_CLR_UTICK0(x)           (((uint32_t)(((uint32_t)(x)) << RSTCTL0_PRSTCTL2_CLR_UTICK0_SHIFT)) & RSTCTL0_PRSTCTL2_CLR_UTICK0_MASK)

#define RSTCTL0_PRSTCTL2_CLR_WWDT0_MASK          (0x2U)
#define RSTCTL0_PRSTCTL2_CLR_WWDT0_SHIFT         (1U)
/*! WWDT0 - wdt reset clear
 *  0b0..No Effect
 *  0b1..Clears the PRSTCTL2 Bit
 */
#define RSTCTL0_PRSTCTL2_CLR_WWDT0(x)            (((uint32_t)(((uint32_t)(x)) << RSTCTL0_PRSTCTL2_CLR_WWDT0_SHIFT)) & RSTCTL0_PRSTCTL2_CLR_WWDT0_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group RSTCTL0_Register_Masks */


/* RSTCTL0 - Peripheral instance base addresses */
/** Peripheral RSTCTL0 base address */
#define RSTCTL0_BASE                             (0x40000000u)
/** Peripheral RSTCTL0 base pointer */
#define RSTCTL0                                  ((RSTCTL0_Type *)RSTCTL0_BASE)
/** Array initializer of RSTCTL0 peripheral base addresses */
#define RSTCTL0_BASE_ADDRS                       { RSTCTL0_BASE }
/** Array initializer of RSTCTL0 peripheral base pointers */
#define RSTCTL0_BASE_PTRS                        { RSTCTL0 }

/*!
 * @}
 */ /* end of group RSTCTL0_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- RSTCTL1 Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup RSTCTL1_Peripheral_Access_Layer RSTCTL1 Peripheral Access Layer
 * @{
 */

/** RSTCTL1 - Register Layout Typedef */
typedef struct {
  __IO uint32_t SYSRSTSTAT;                        /**< system reset status register, offset: 0x0 */
       uint8_t RESERVED_0[12];
  __IO uint32_t PRSTCTL0;                          /**< peripheral reset control register 0, offset: 0x10 */
  __IO uint32_t PRSTCTL1;                          /**< peripheral reset control register 1, offset: 0x14 */
  __IO uint32_t PRSTCTL2;                          /**< peripheral reset control register 2, offset: 0x18 */
       uint8_t RESERVED_1[36];
  __O  uint32_t PRSTCTL0_SET;                      /**< peripheral reset set register 0, offset: 0x40 */
  __O  uint32_t PRSTCTL1_SET;                      /**< peripheral reset set register 1, offset: 0x44 */
  __O  uint32_t PRSTCTL2_SET;                      /**< peripheral reset set register 2, offset: 0x48 */
       uint8_t RESERVED_2[36];
  __O  uint32_t PRSTCTL0_CLR;                      /**< peripheral reset clear register 0, offset: 0x70 */
  __O  uint32_t PRSTCTL1_CLR;                      /**< peripheral reset clear register 1, offset: 0x74 */
  __O  uint32_t PRSTCTL2_CLR;                      /**< peripheral reset clear register 2, offset: 0x78 */
} RSTCTL1_Type;

/* ----------------------------------------------------------------------------
   -- RSTCTL1 Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup RSTCTL1_Register_Masks RSTCTL1 Register Masks
 * @{
 */

/*! @name SYSRSTSTAT - system reset status register */
/*! @{ */

#define RSTCTL1_SYSRSTSTAT_VDD_POR_MASK          (0x1U)
#define RSTCTL1_SYSRSTSTAT_VDD_POR_SHIFT         (0U)
/*! VDD_POR - VDD POR Event Detected:
 *  0b0..No event detected.
 *  0b1..VDD POR event detected. (Writing a 1 to this bit clears this status).
 */
#define RSTCTL1_SYSRSTSTAT_VDD_POR(x)            (((uint32_t)(((uint32_t)(x)) << RSTCTL1_SYSRSTSTAT_VDD_POR_SHIFT)) & RSTCTL1_SYSRSTSTAT_VDD_POR_MASK)

#define RSTCTL1_SYSRSTSTAT_PAD_RESET_MASK        (0x10U)
#define RSTCTL1_SYSRSTSTAT_PAD_RESET_SHIFT       (4U)
/*! PAD_RESET - PAD RESET Event Detected:
 *  0b0..No EVENT Detected.
 *  0b1..RESET Detected. (Write 1 to CLR),
 */
#define RSTCTL1_SYSRSTSTAT_PAD_RESET(x)          (((uint32_t)(((uint32_t)(x)) << RSTCTL1_SYSRSTSTAT_PAD_RESET_SHIFT)) & RSTCTL1_SYSRSTSTAT_PAD_RESET_MASK)

#define RSTCTL1_SYSRSTSTAT_ARM_APD_RESET_MASK    (0x20U)
#define RSTCTL1_SYSRSTSTAT_ARM_APD_RESET_SHIFT   (5U)
/*! ARM_APD_RESET - ARM RESET Event Detected:
 *  0b0..No event detected.
 *  0b1..ARM reset event detected. (Writing a 1 to this bit clears this status).
 */
#define RSTCTL1_SYSRSTSTAT_ARM_APD_RESET(x)      (((uint32_t)(((uint32_t)(x)) << RSTCTL1_SYSRSTSTAT_ARM_APD_RESET_SHIFT)) & RSTCTL1_SYSRSTSTAT_ARM_APD_RESET_MASK)

#define RSTCTL1_SYSRSTSTAT_WDT0_RESET_MASK       (0x40U)
#define RSTCTL1_SYSRSTSTAT_WDT0_RESET_SHIFT      (6U)
/*! WDT0_RESET - WDT0 RESET Event Detected:
 *  0b0..No EVENT Detected.
 *  0b1..WDT0 reset event detected. (Writing a 1 to this bit clears this status).
 */
#define RSTCTL1_SYSRSTSTAT_WDT0_RESET(x)         (((uint32_t)(((uint32_t)(x)) << RSTCTL1_SYSRSTSTAT_WDT0_RESET_SHIFT)) & RSTCTL1_SYSRSTSTAT_WDT0_RESET_MASK)

#define RSTCTL1_SYSRSTSTAT_WDT1_RESET_MASK       (0x80U)
#define RSTCTL1_SYSRSTSTAT_WDT1_RESET_SHIFT      (7U)
/*! WDT1_RESET - WDT1 RESET Event Detected:
 *  0b0..No EVENT Detected.
 *  0b1..WDT1 reset event detected. (Writing a 1 to this bit clears this status).
 */
#define RSTCTL1_SYSRSTSTAT_WDT1_RESET(x)         (((uint32_t)(((uint32_t)(x)) << RSTCTL1_SYSRSTSTAT_WDT1_RESET_SHIFT)) & RSTCTL1_SYSRSTSTAT_WDT1_RESET_MASK)
/*! @} */

/*! @name PRSTCTL0 - peripheral reset control register 0 */
/*! @{ */

#define RSTCTL1_PRSTCTL0_FLEXCOMM0_RST_MASK      (0x100U)
#define RSTCTL1_PRSTCTL0_FLEXCOMM0_RST_SHIFT     (8U)
/*! FLEXCOMM0_RST - FLEXCOMM0 reset control
 *  0b0..clear reset
 *  0b1..set reset
 */
#define RSTCTL1_PRSTCTL0_FLEXCOMM0_RST(x)        (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL0_FLEXCOMM0_RST_SHIFT)) & RSTCTL1_PRSTCTL0_FLEXCOMM0_RST_MASK)

#define RSTCTL1_PRSTCTL0_FLEXCOMM1_RST_MASK      (0x200U)
#define RSTCTL1_PRSTCTL0_FLEXCOMM1_RST_SHIFT     (9U)
/*! FLEXCOMM1_RST - FLEXCOMM1 reset control
 *  0b0..clear reset
 *  0b1..set reset
 */
#define RSTCTL1_PRSTCTL0_FLEXCOMM1_RST(x)        (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL0_FLEXCOMM1_RST_SHIFT)) & RSTCTL1_PRSTCTL0_FLEXCOMM1_RST_MASK)

#define RSTCTL1_PRSTCTL0_FLEXCOMM2_RST_MASK      (0x400U)
#define RSTCTL1_PRSTCTL0_FLEXCOMM2_RST_SHIFT     (10U)
/*! FLEXCOMM2_RST - FLEXCOMM2 reset control
 *  0b0..clear reset
 *  0b1..set reset
 */
#define RSTCTL1_PRSTCTL0_FLEXCOMM2_RST(x)        (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL0_FLEXCOMM2_RST_SHIFT)) & RSTCTL1_PRSTCTL0_FLEXCOMM2_RST_MASK)

#define RSTCTL1_PRSTCTL0_FLEXCOMM3_RST_MASK      (0x800U)
#define RSTCTL1_PRSTCTL0_FLEXCOMM3_RST_SHIFT     (11U)
/*! FLEXCOMM3_RST - FLEXCOMM3 reset control
 *  0b0..clear reset
 *  0b1..set reset
 */
#define RSTCTL1_PRSTCTL0_FLEXCOMM3_RST(x)        (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL0_FLEXCOMM3_RST_SHIFT)) & RSTCTL1_PRSTCTL0_FLEXCOMM3_RST_MASK)

#define RSTCTL1_PRSTCTL0_FLEXCOMM4_RST_MASK      (0x1000U)
#define RSTCTL1_PRSTCTL0_FLEXCOMM4_RST_SHIFT     (12U)
/*! FLEXCOMM4_RST - FLEXCOMM4 reset control
 *  0b0..clear reset
 *  0b1..set reset
 */
#define RSTCTL1_PRSTCTL0_FLEXCOMM4_RST(x)        (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL0_FLEXCOMM4_RST_SHIFT)) & RSTCTL1_PRSTCTL0_FLEXCOMM4_RST_MASK)

#define RSTCTL1_PRSTCTL0_FLEXCOMM5_RST_MASK      (0x2000U)
#define RSTCTL1_PRSTCTL0_FLEXCOMM5_RST_SHIFT     (13U)
/*! FLEXCOMM5_RST - FLEXCOMM5 reset control
 *  0b0..clear reset
 *  0b1..set reset
 */
#define RSTCTL1_PRSTCTL0_FLEXCOMM5_RST(x)        (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL0_FLEXCOMM5_RST_SHIFT)) & RSTCTL1_PRSTCTL0_FLEXCOMM5_RST_MASK)

#define RSTCTL1_PRSTCTL0_FLEXCOMM6_RST_MASK      (0x4000U)
#define RSTCTL1_PRSTCTL0_FLEXCOMM6_RST_SHIFT     (14U)
/*! FLEXCOMM6_RST - FLEXCOMM6 reset control
 *  0b0..clear reset
 *  0b1..set reset
 */
#define RSTCTL1_PRSTCTL0_FLEXCOMM6_RST(x)        (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL0_FLEXCOMM6_RST_SHIFT)) & RSTCTL1_PRSTCTL0_FLEXCOMM6_RST_MASK)

#define RSTCTL1_PRSTCTL0_FLEXCOMM7_RST_MASK      (0x8000U)
#define RSTCTL1_PRSTCTL0_FLEXCOMM7_RST_SHIFT     (15U)
/*! FLEXCOMM7_RST - FLEXCOMM7 reset control
 *  0b0..clear reset
 *  0b1..set reset
 */
#define RSTCTL1_PRSTCTL0_FLEXCOMM7_RST(x)        (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL0_FLEXCOMM7_RST_SHIFT)) & RSTCTL1_PRSTCTL0_FLEXCOMM7_RST_MASK)

#define RSTCTL1_PRSTCTL0_FLEXCOMM14_SPI_RST_MASK (0x400000U)
#define RSTCTL1_PRSTCTL0_FLEXCOMM14_SPI_RST_SHIFT (22U)
/*! FLEXCOMM14_SPI_RST - FLEXCOMM14 SPI reset control
 *  0b0..clear reset
 *  0b1..set reset
 */
#define RSTCTL1_PRSTCTL0_FLEXCOMM14_SPI_RST(x)   (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL0_FLEXCOMM14_SPI_RST_SHIFT)) & RSTCTL1_PRSTCTL0_FLEXCOMM14_SPI_RST_MASK)

#define RSTCTL1_PRSTCTL0_FLEXCOMM15_I2C_RST_MASK (0x800000U)
#define RSTCTL1_PRSTCTL0_FLEXCOMM15_I2C_RST_SHIFT (23U)
/*! FLEXCOMM15_I2C_RST - FLEXCOMM15 I2C reset control
 *  0b0..clear reset
 *  0b1..set reset
 */
#define RSTCTL1_PRSTCTL0_FLEXCOMM15_I2C_RST(x)   (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL0_FLEXCOMM15_I2C_RST_SHIFT)) & RSTCTL1_PRSTCTL0_FLEXCOMM15_I2C_RST_MASK)

#define RSTCTL1_PRSTCTL0_DMIC0_RST_MASK          (0x1000000U)
#define RSTCTL1_PRSTCTL0_DMIC0_RST_SHIFT         (24U)
/*! DMIC0_RST - DMIC0 reset control
 *  0b0..clear reset
 *  0b1..set reset
 */
#define RSTCTL1_PRSTCTL0_DMIC0_RST(x)            (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL0_DMIC0_RST_SHIFT)) & RSTCTL1_PRSTCTL0_DMIC0_RST_MASK)

#define RSTCTL1_PRSTCTL0_OSEVT_TIMER_RST_MASK    (0x8000000U)
#define RSTCTL1_PRSTCTL0_OSEVT_TIMER_RST_SHIFT   (27U)
/*! OSEVT_TIMER_RST - osevent timer reset control
 *  0b0..clear reset
 *  0b1..set reset
 */
#define RSTCTL1_PRSTCTL0_OSEVT_TIMER_RST(x)      (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL0_OSEVT_TIMER_RST_SHIFT)) & RSTCTL1_PRSTCTL0_OSEVT_TIMER_RST_MASK)
/*! @} */

/*! @name PRSTCTL1 - peripheral reset control register 1 */
/*! @{ */

#define RSTCTL1_PRSTCTL1_HSGPIO0_RST_MASK        (0x1U)
#define RSTCTL1_PRSTCTL1_HSGPIO0_RST_SHIFT       (0U)
/*! HSGPIO0_RST - HSGPIO0 reset control
 *  0b0..clear reset
 *  0b1..set reset
 */
#define RSTCTL1_PRSTCTL1_HSGPIO0_RST(x)          (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL1_HSGPIO0_RST_SHIFT)) & RSTCTL1_PRSTCTL1_HSGPIO0_RST_MASK)

#define RSTCTL1_PRSTCTL1_HSGPIO1_RST_MASK        (0x2U)
#define RSTCTL1_PRSTCTL1_HSGPIO1_RST_SHIFT       (1U)
/*! HSGPIO1_RST - HSGPIO1 reset control
 *  0b0..clear reset
 *  0b1..set reset
 */
#define RSTCTL1_PRSTCTL1_HSGPIO1_RST(x)          (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL1_HSGPIO1_RST_SHIFT)) & RSTCTL1_PRSTCTL1_HSGPIO1_RST_MASK)

#define RSTCTL1_PRSTCTL1_HSGPIO2_RST_MASK        (0x4U)
#define RSTCTL1_PRSTCTL1_HSGPIO2_RST_SHIFT       (2U)
/*! HSGPIO2_RST - HSGPIO2 reset control
 *  0b0..clear reset
 *  0b1..set reset
 */
#define RSTCTL1_PRSTCTL1_HSGPIO2_RST(x)          (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL1_HSGPIO2_RST_SHIFT)) & RSTCTL1_PRSTCTL1_HSGPIO2_RST_MASK)

#define RSTCTL1_PRSTCTL1_HSGPIO3_RST_MASK        (0x8U)
#define RSTCTL1_PRSTCTL1_HSGPIO3_RST_SHIFT       (3U)
/*! HSGPIO3_RST - HSGPIO3 reset control
 *  0b0..clear reset
 *  0b1..set reset
 */
#define RSTCTL1_PRSTCTL1_HSGPIO3_RST(x)          (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL1_HSGPIO3_RST_SHIFT)) & RSTCTL1_PRSTCTL1_HSGPIO3_RST_MASK)

#define RSTCTL1_PRSTCTL1_HSGPIO4_RST_MASK        (0x10U)
#define RSTCTL1_PRSTCTL1_HSGPIO4_RST_SHIFT       (4U)
/*! HSGPIO4_RST - HSGPIO4 reset control
 *  0b0..clear reset
 *  0b1..set reset
 */
#define RSTCTL1_PRSTCTL1_HSGPIO4_RST(x)          (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL1_HSGPIO4_RST_SHIFT)) & RSTCTL1_PRSTCTL1_HSGPIO4_RST_MASK)

#define RSTCTL1_PRSTCTL1_HSGPIO5_RST_MASK        (0x20U)
#define RSTCTL1_PRSTCTL1_HSGPIO5_RST_SHIFT       (5U)
/*! HSGPIO5_RST - HSGPIO5 reset control
 *  0b0..clear reset
 *  0b1..set reset
 */
#define RSTCTL1_PRSTCTL1_HSGPIO5_RST(x)          (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL1_HSGPIO5_RST_SHIFT)) & RSTCTL1_PRSTCTL1_HSGPIO5_RST_MASK)

#define RSTCTL1_PRSTCTL1_HSGPIO6_RST_MASK        (0x40U)
#define RSTCTL1_PRSTCTL1_HSGPIO6_RST_SHIFT       (6U)
/*! HSGPIO6_RST - HSGPIO6 reset control
 *  0b0..clear reset
 *  0b1..set reset
 */
#define RSTCTL1_PRSTCTL1_HSGPIO6_RST(x)          (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL1_HSGPIO6_RST_SHIFT)) & RSTCTL1_PRSTCTL1_HSGPIO6_RST_MASK)

#define RSTCTL1_PRSTCTL1_HSGPIO7_RST_MASK        (0x80U)
#define RSTCTL1_PRSTCTL1_HSGPIO7_RST_SHIFT       (7U)
/*! HSGPIO7_RST - HSGPIO7 reset control
 *  0b0..clear reset
 *  0b1..set reset
 */
#define RSTCTL1_PRSTCTL1_HSGPIO7_RST(x)          (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL1_HSGPIO7_RST_SHIFT)) & RSTCTL1_PRSTCTL1_HSGPIO7_RST_MASK)

#define RSTCTL1_PRSTCTL1_CRC_RST_MASK            (0x10000U)
#define RSTCTL1_PRSTCTL1_CRC_RST_SHIFT           (16U)
/*! CRC_RST - CRC reset control
 *  0b0..clear reset
 *  0b1..set reset
 */
#define RSTCTL1_PRSTCTL1_CRC_RST(x)              (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL1_CRC_RST_SHIFT)) & RSTCTL1_PRSTCTL1_CRC_RST_MASK)

#define RSTCTL1_PRSTCTL1_DMAC0_RST_MASK          (0x800000U)
#define RSTCTL1_PRSTCTL1_DMAC0_RST_SHIFT         (23U)
/*! DMAC0_RST - DMAC0 reset control
 *  0b0..clear reset
 *  0b1..set reset
 */
#define RSTCTL1_PRSTCTL1_DMAC0_RST(x)            (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL1_DMAC0_RST_SHIFT)) & RSTCTL1_PRSTCTL1_DMAC0_RST_MASK)

#define RSTCTL1_PRSTCTL1_DMAC1_RST_MASK          (0x1000000U)
#define RSTCTL1_PRSTCTL1_DMAC1_RST_SHIFT         (24U)
/*! DMAC1_RST - DMAC1 reset control
 *  0b0..clear reset
 *  0b1..set reset
 */
#define RSTCTL1_PRSTCTL1_DMAC1_RST(x)            (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL1_DMAC1_RST_SHIFT)) & RSTCTL1_PRSTCTL1_DMAC1_RST_MASK)

#define RSTCTL1_PRSTCTL1_MU_RST_MASK             (0x10000000U)
#define RSTCTL1_PRSTCTL1_MU_RST_SHIFT            (28U)
/*! MU_RST - MU reset control
 *  0b0..clear reset
 *  0b1..set reset
 */
#define RSTCTL1_PRSTCTL1_MU_RST(x)               (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL1_MU_RST_SHIFT)) & RSTCTL1_PRSTCTL1_MU_RST_MASK)

#define RSTCTL1_PRSTCTL1_SEMA_RST_MASK           (0x20000000U)
#define RSTCTL1_PRSTCTL1_SEMA_RST_SHIFT          (29U)
/*! SEMA_RST - SEMA reset control
 *  0b0..clear reset
 *  0b1..set reset
 */
#define RSTCTL1_PRSTCTL1_SEMA_RST(x)             (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL1_SEMA_RST_SHIFT)) & RSTCTL1_PRSTCTL1_SEMA_RST_MASK)

#define RSTCTL1_PRSTCTL1_FREQME_RST_MASK         (0x80000000U)
#define RSTCTL1_PRSTCTL1_FREQME_RST_SHIFT        (31U)
/*! FREQME_RST - FREQME reset control
 *  0b0..clear reset
 *  0b1..set reset
 */
#define RSTCTL1_PRSTCTL1_FREQME_RST(x)           (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL1_FREQME_RST_SHIFT)) & RSTCTL1_PRSTCTL1_FREQME_RST_MASK)
/*! @} */

/*! @name PRSTCTL2 - peripheral reset control register 2 */
/*! @{ */

#define RSTCTL1_PRSTCTL2_CT32BIT0_RST_MASK       (0x1U)
#define RSTCTL1_PRSTCTL2_CT32BIT0_RST_SHIFT      (0U)
/*! CT32BIT0_RST - CT32BIT0 reset control
 *  0b0..clear reset
 *  0b1..set reset
 */
#define RSTCTL1_PRSTCTL2_CT32BIT0_RST(x)         (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL2_CT32BIT0_RST_SHIFT)) & RSTCTL1_PRSTCTL2_CT32BIT0_RST_MASK)

#define RSTCTL1_PRSTCTL2_CT32BIT1_RST_MASK       (0x2U)
#define RSTCTL1_PRSTCTL2_CT32BIT1_RST_SHIFT      (1U)
/*! CT32BIT1_RST - CT32BIT1 reset control
 *  0b0..clear reset
 *  0b1..set reset
 */
#define RSTCTL1_PRSTCTL2_CT32BIT1_RST(x)         (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL2_CT32BIT1_RST_SHIFT)) & RSTCTL1_PRSTCTL2_CT32BIT1_RST_MASK)

#define RSTCTL1_PRSTCTL2_CT32BIT2_RST_MASK       (0x4U)
#define RSTCTL1_PRSTCTL2_CT32BIT2_RST_SHIFT      (2U)
/*! CT32BIT2_RST - CT32BIT2 reset control
 *  0b0..clear reset
 *  0b1..set reset
 */
#define RSTCTL1_PRSTCTL2_CT32BIT2_RST(x)         (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL2_CT32BIT2_RST_SHIFT)) & RSTCTL1_PRSTCTL2_CT32BIT2_RST_MASK)

#define RSTCTL1_PRSTCTL2_CT32BIT3_RST_MASK       (0x8U)
#define RSTCTL1_PRSTCTL2_CT32BIT3_RST_SHIFT      (3U)
/*! CT32BIT3_RST - CT32BIT3 reset control
 *  0b0..clear reset
 *  0b1..set reset
 */
#define RSTCTL1_PRSTCTL2_CT32BIT3_RST(x)         (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL2_CT32BIT3_RST_SHIFT)) & RSTCTL1_PRSTCTL2_CT32BIT3_RST_MASK)

#define RSTCTL1_PRSTCTL2_CT32BIT4_RST_MASK       (0x10U)
#define RSTCTL1_PRSTCTL2_CT32BIT4_RST_SHIFT      (4U)
/*! CT32BIT4_RST - CT32BIT4 reset control
 *  0b0..clear reset
 *  0b1..set reset
 */
#define RSTCTL1_PRSTCTL2_CT32BIT4_RST(x)         (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL2_CT32BIT4_RST_SHIFT)) & RSTCTL1_PRSTCTL2_CT32BIT4_RST_MASK)

#define RSTCTL1_PRSTCTL2_MRT0_RST_MASK           (0x100U)
#define RSTCTL1_PRSTCTL2_MRT0_RST_SHIFT          (8U)
/*! MRT0_RST - MRT0 reset control
 *  0b0..clear reset
 *  0b1..set reset
 */
#define RSTCTL1_PRSTCTL2_MRT0_RST(x)             (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL2_MRT0_RST_SHIFT)) & RSTCTL1_PRSTCTL2_MRT0_RST_MASK)

#define RSTCTL1_PRSTCTL2_WWDT1_RST_MASK          (0x400U)
#define RSTCTL1_PRSTCTL2_WWDT1_RST_SHIFT         (10U)
/*! WWDT1_RST - WWDT1 reset control
 *  0b0..clear reset
 *  0b1..set reset
 */
#define RSTCTL1_PRSTCTL2_WWDT1_RST(x)            (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL2_WWDT1_RST_SHIFT)) & RSTCTL1_PRSTCTL2_WWDT1_RST_MASK)

#define RSTCTL1_PRSTCTL2_I3C0_RST_MASK           (0x10000U)
#define RSTCTL1_PRSTCTL2_I3C0_RST_SHIFT          (16U)
/*! I3C0_RST - I3C0 reset control
 *  0b0..clear reset
 *  0b1..set reset
 */
#define RSTCTL1_PRSTCTL2_I3C0_RST(x)             (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL2_I3C0_RST_SHIFT)) & RSTCTL1_PRSTCTL2_I3C0_RST_MASK)

#define RSTCTL1_PRSTCTL2_GPIOINTCTL_RST_MASK     (0x40000000U)
#define RSTCTL1_PRSTCTL2_GPIOINTCTL_RST_SHIFT    (30U)
/*! GPIOINTCTL_RST - GPIOINTCTL reset control
 *  0b0..clear reset
 *  0b1..set reset
 */
#define RSTCTL1_PRSTCTL2_GPIOINTCTL_RST(x)       (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL2_GPIOINTCTL_RST_SHIFT)) & RSTCTL1_PRSTCTL2_GPIOINTCTL_RST_MASK)

#define RSTCTL1_PRSTCTL2_PIMCTL_RST_MASK         (0x80000000U)
#define RSTCTL1_PRSTCTL2_PIMCTL_RST_SHIFT        (31U)
/*! PIMCTL_RST - PMC reset control
 *  0b0..clear reset
 *  0b1..set reset
 */
#define RSTCTL1_PRSTCTL2_PIMCTL_RST(x)           (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL2_PIMCTL_RST_SHIFT)) & RSTCTL1_PRSTCTL2_PIMCTL_RST_MASK)
/*! @} */

/*! @name PRSTCTL0_SET - peripheral reset set register 0 */
/*! @{ */

#define RSTCTL1_PRSTCTL0_SET_FLEXCOMM0_RST_SET_MASK (0x100U)
#define RSTCTL1_PRSTCTL0_SET_FLEXCOMM0_RST_SET_SHIFT (8U)
/*! FLEXCOMM0_RST_SET - FLEXCOMM0 reset set
 *  0b0..No Effect
 *  0b1..Sets the PRSTCTL0 Bit
 */
#define RSTCTL1_PRSTCTL0_SET_FLEXCOMM0_RST_SET(x) (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL0_SET_FLEXCOMM0_RST_SET_SHIFT)) & RSTCTL1_PRSTCTL0_SET_FLEXCOMM0_RST_SET_MASK)

#define RSTCTL1_PRSTCTL0_SET_FLEXCOMM1_RST_SET_MASK (0x200U)
#define RSTCTL1_PRSTCTL0_SET_FLEXCOMM1_RST_SET_SHIFT (9U)
/*! FLEXCOMM1_RST_SET - FLEXCOMM1 reset set
 *  0b0..No Effect
 *  0b1..Sets the PRSTCTL0 Bit
 */
#define RSTCTL1_PRSTCTL0_SET_FLEXCOMM1_RST_SET(x) (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL0_SET_FLEXCOMM1_RST_SET_SHIFT)) & RSTCTL1_PRSTCTL0_SET_FLEXCOMM1_RST_SET_MASK)

#define RSTCTL1_PRSTCTL0_SET_FLEXCOMM2_RST_SET_MASK (0x400U)
#define RSTCTL1_PRSTCTL0_SET_FLEXCOMM2_RST_SET_SHIFT (10U)
/*! FLEXCOMM2_RST_SET - FLEXCOMM2 reset set
 *  0b0..No Effect
 *  0b1..Sets the PRSTCTL0 Bit
 */
#define RSTCTL1_PRSTCTL0_SET_FLEXCOMM2_RST_SET(x) (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL0_SET_FLEXCOMM2_RST_SET_SHIFT)) & RSTCTL1_PRSTCTL0_SET_FLEXCOMM2_RST_SET_MASK)

#define RSTCTL1_PRSTCTL0_SET_FLEXCOMM3_RST_SET_MASK (0x800U)
#define RSTCTL1_PRSTCTL0_SET_FLEXCOMM3_RST_SET_SHIFT (11U)
/*! FLEXCOMM3_RST_SET - FLEXCOMM3 reset set
 *  0b0..No Effect
 *  0b1..Sets the PRSTCTL0 Bit
 */
#define RSTCTL1_PRSTCTL0_SET_FLEXCOMM3_RST_SET(x) (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL0_SET_FLEXCOMM3_RST_SET_SHIFT)) & RSTCTL1_PRSTCTL0_SET_FLEXCOMM3_RST_SET_MASK)

#define RSTCTL1_PRSTCTL0_SET_FLEXCOMM4_RST_SET_MASK (0x1000U)
#define RSTCTL1_PRSTCTL0_SET_FLEXCOMM4_RST_SET_SHIFT (12U)
/*! FLEXCOMM4_RST_SET - FLEXCOMM4 reset set
 *  0b0..No Effect
 *  0b1..Sets the PRSTCTL0 Bit
 */
#define RSTCTL1_PRSTCTL0_SET_FLEXCOMM4_RST_SET(x) (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL0_SET_FLEXCOMM4_RST_SET_SHIFT)) & RSTCTL1_PRSTCTL0_SET_FLEXCOMM4_RST_SET_MASK)

#define RSTCTL1_PRSTCTL0_SET_FLEXCOMM5_RST_SET_MASK (0x2000U)
#define RSTCTL1_PRSTCTL0_SET_FLEXCOMM5_RST_SET_SHIFT (13U)
/*! FLEXCOMM5_RST_SET - FLEXCOMM5 reset set
 *  0b0..No Effect
 *  0b1..Sets the PRSTCTL0 Bit
 */
#define RSTCTL1_PRSTCTL0_SET_FLEXCOMM5_RST_SET(x) (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL0_SET_FLEXCOMM5_RST_SET_SHIFT)) & RSTCTL1_PRSTCTL0_SET_FLEXCOMM5_RST_SET_MASK)

#define RSTCTL1_PRSTCTL0_SET_FLEXCOMM6_RST_SET_MASK (0x4000U)
#define RSTCTL1_PRSTCTL0_SET_FLEXCOMM6_RST_SET_SHIFT (14U)
/*! FLEXCOMM6_RST_SET - FLEXCOMM6 reset set
 *  0b0..No Effect
 *  0b1..Sets the PRSTCTL0 Bit
 */
#define RSTCTL1_PRSTCTL0_SET_FLEXCOMM6_RST_SET(x) (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL0_SET_FLEXCOMM6_RST_SET_SHIFT)) & RSTCTL1_PRSTCTL0_SET_FLEXCOMM6_RST_SET_MASK)

#define RSTCTL1_PRSTCTL0_SET_FLEXCOMM7_RST_SET_MASK (0x8000U)
#define RSTCTL1_PRSTCTL0_SET_FLEXCOMM7_RST_SET_SHIFT (15U)
/*! FLEXCOMM7_RST_SET - FLEXCOMM7 reset set
 *  0b0..No Effect
 *  0b1..Sets the PRSTCTL0 Bit
 */
#define RSTCTL1_PRSTCTL0_SET_FLEXCOMM7_RST_SET(x) (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL0_SET_FLEXCOMM7_RST_SET_SHIFT)) & RSTCTL1_PRSTCTL0_SET_FLEXCOMM7_RST_SET_MASK)

#define RSTCTL1_PRSTCTL0_SET_FLEXCOMM14_SPI_RST_SET_MASK (0x400000U)
#define RSTCTL1_PRSTCTL0_SET_FLEXCOMM14_SPI_RST_SET_SHIFT (22U)
/*! FLEXCOMM14_SPI_RST_SET - FLEXCOMM14 SPI reset set
 *  0b0..No Effect
 *  0b1..Sets the PRSTCTL0 Bit
 */
#define RSTCTL1_PRSTCTL0_SET_FLEXCOMM14_SPI_RST_SET(x) (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL0_SET_FLEXCOMM14_SPI_RST_SET_SHIFT)) & RSTCTL1_PRSTCTL0_SET_FLEXCOMM14_SPI_RST_SET_MASK)

#define RSTCTL1_PRSTCTL0_SET_FLEXCOMM15_I2C_RST_SET_MASK (0x800000U)
#define RSTCTL1_PRSTCTL0_SET_FLEXCOMM15_I2C_RST_SET_SHIFT (23U)
/*! FLEXCOMM15_I2C_RST_SET - FLEXCOMM15 I2C reset set
 *  0b0..No Effect
 *  0b1..Sets the PRSTCTL0 Bit
 */
#define RSTCTL1_PRSTCTL0_SET_FLEXCOMM15_I2C_RST_SET(x) (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL0_SET_FLEXCOMM15_I2C_RST_SET_SHIFT)) & RSTCTL1_PRSTCTL0_SET_FLEXCOMM15_I2C_RST_SET_MASK)

#define RSTCTL1_PRSTCTL0_SET_DMIC0_RST_SET_MASK  (0x1000000U)
#define RSTCTL1_PRSTCTL0_SET_DMIC0_RST_SET_SHIFT (24U)
/*! DMIC0_RST_SET - DMIC0 reset set
 *  0b0..No Effect
 *  0b1..Sets the PRSTCTL0 Bit
 */
#define RSTCTL1_PRSTCTL0_SET_DMIC0_RST_SET(x)    (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL0_SET_DMIC0_RST_SET_SHIFT)) & RSTCTL1_PRSTCTL0_SET_DMIC0_RST_SET_MASK)

#define RSTCTL1_PRSTCTL0_SET_OSEVT_TIMER_RST_SET_MASK (0x8000000U)
#define RSTCTL1_PRSTCTL0_SET_OSEVT_TIMER_RST_SET_SHIFT (27U)
/*! OSEVT_TIMER_RST_SET - osevent timer reset set
 *  0b0..No Effect
 *  0b1..Sets the PRSTCTL0 Bit
 */
#define RSTCTL1_PRSTCTL0_SET_OSEVT_TIMER_RST_SET(x) (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL0_SET_OSEVT_TIMER_RST_SET_SHIFT)) & RSTCTL1_PRSTCTL0_SET_OSEVT_TIMER_RST_SET_MASK)
/*! @} */

/*! @name PRSTCTL1_SET - peripheral reset set register 1 */
/*! @{ */

#define RSTCTL1_PRSTCTL1_SET_HSGPIO0_RST_SET_MASK (0x1U)
#define RSTCTL1_PRSTCTL1_SET_HSGPIO0_RST_SET_SHIFT (0U)
/*! HSGPIO0_RST_SET - HSGPIO0 reset set
 *  0b0..No Effect
 *  0b1..Sets the PRSTCTL1 Bit
 */
#define RSTCTL1_PRSTCTL1_SET_HSGPIO0_RST_SET(x)  (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL1_SET_HSGPIO0_RST_SET_SHIFT)) & RSTCTL1_PRSTCTL1_SET_HSGPIO0_RST_SET_MASK)

#define RSTCTL1_PRSTCTL1_SET_HSGPIO1_RST_SET_MASK (0x2U)
#define RSTCTL1_PRSTCTL1_SET_HSGPIO1_RST_SET_SHIFT (1U)
/*! HSGPIO1_RST_SET - HSGPIO1 reset set
 *  0b0..No Effect
 *  0b1..Sets the PRSTCTL1 Bit
 */
#define RSTCTL1_PRSTCTL1_SET_HSGPIO1_RST_SET(x)  (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL1_SET_HSGPIO1_RST_SET_SHIFT)) & RSTCTL1_PRSTCTL1_SET_HSGPIO1_RST_SET_MASK)

#define RSTCTL1_PRSTCTL1_SET_HSGPIO2_RST_SET_MASK (0x4U)
#define RSTCTL1_PRSTCTL1_SET_HSGPIO2_RST_SET_SHIFT (2U)
/*! HSGPIO2_RST_SET - HSGPIO2 reset set
 *  0b0..No Effect
 *  0b1..Sets the PRSTCTL1 Bit
 */
#define RSTCTL1_PRSTCTL1_SET_HSGPIO2_RST_SET(x)  (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL1_SET_HSGPIO2_RST_SET_SHIFT)) & RSTCTL1_PRSTCTL1_SET_HSGPIO2_RST_SET_MASK)

#define RSTCTL1_PRSTCTL1_SET_HSGPIO3_RST_SET_MASK (0x8U)
#define RSTCTL1_PRSTCTL1_SET_HSGPIO3_RST_SET_SHIFT (3U)
/*! HSGPIO3_RST_SET - HSGPIO3 reset set
 *  0b0..No Effect
 *  0b1..Sets the PRSTCTL1 Bit
 */
#define RSTCTL1_PRSTCTL1_SET_HSGPIO3_RST_SET(x)  (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL1_SET_HSGPIO3_RST_SET_SHIFT)) & RSTCTL1_PRSTCTL1_SET_HSGPIO3_RST_SET_MASK)

#define RSTCTL1_PRSTCTL1_SET_HSGPIO4_RST_SET_MASK (0x10U)
#define RSTCTL1_PRSTCTL1_SET_HSGPIO4_RST_SET_SHIFT (4U)
/*! HSGPIO4_RST_SET - HSGPIO4 reset set
 *  0b0..No Effect
 *  0b1..Sets the PRSTCTL1 Bit
 */
#define RSTCTL1_PRSTCTL1_SET_HSGPIO4_RST_SET(x)  (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL1_SET_HSGPIO4_RST_SET_SHIFT)) & RSTCTL1_PRSTCTL1_SET_HSGPIO4_RST_SET_MASK)

#define RSTCTL1_PRSTCTL1_SET_HSGPIO5_RST_SET_MASK (0x20U)
#define RSTCTL1_PRSTCTL1_SET_HSGPIO5_RST_SET_SHIFT (5U)
/*! HSGPIO5_RST_SET - HSGPIO5 reset set
 *  0b0..No Effect
 *  0b1..Sets the PRSTCTL1 Bit
 */
#define RSTCTL1_PRSTCTL1_SET_HSGPIO5_RST_SET(x)  (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL1_SET_HSGPIO5_RST_SET_SHIFT)) & RSTCTL1_PRSTCTL1_SET_HSGPIO5_RST_SET_MASK)

#define RSTCTL1_PRSTCTL1_SET_HSGPIO6_RST_SET_MASK (0x40U)
#define RSTCTL1_PRSTCTL1_SET_HSGPIO6_RST_SET_SHIFT (6U)
/*! HSGPIO6_RST_SET - HSGPIO6 reset set
 *  0b0..No Effect
 *  0b1..Sets the PRSTCTL1 Bit
 */
#define RSTCTL1_PRSTCTL1_SET_HSGPIO6_RST_SET(x)  (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL1_SET_HSGPIO6_RST_SET_SHIFT)) & RSTCTL1_PRSTCTL1_SET_HSGPIO6_RST_SET_MASK)

#define RSTCTL1_PRSTCTL1_SET_HSGPIO7_RST_SET_MASK (0x80U)
#define RSTCTL1_PRSTCTL1_SET_HSGPIO7_RST_SET_SHIFT (7U)
/*! HSGPIO7_RST_SET - HSGPIO7 reset set
 *  0b0..No Effect
 *  0b1..Sets the PRSTCTL1 Bit
 */
#define RSTCTL1_PRSTCTL1_SET_HSGPIO7_RST_SET(x)  (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL1_SET_HSGPIO7_RST_SET_SHIFT)) & RSTCTL1_PRSTCTL1_SET_HSGPIO7_RST_SET_MASK)

#define RSTCTL1_PRSTCTL1_SET_CRC_RST_SET_MASK    (0x10000U)
#define RSTCTL1_PRSTCTL1_SET_CRC_RST_SET_SHIFT   (16U)
/*! CRC_RST_SET - CRC reset set
 *  0b0..No Effect
 *  0b1..Sets the PRSTCTL1 Bit
 */
#define RSTCTL1_PRSTCTL1_SET_CRC_RST_SET(x)      (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL1_SET_CRC_RST_SET_SHIFT)) & RSTCTL1_PRSTCTL1_SET_CRC_RST_SET_MASK)

#define RSTCTL1_PRSTCTL1_SET_DMAC0_RST_SET_MASK  (0x800000U)
#define RSTCTL1_PRSTCTL1_SET_DMAC0_RST_SET_SHIFT (23U)
/*! DMAC0_RST_SET - DMAC0 reset set
 *  0b0..No Effect
 *  0b1..Sets the PRSTCTL1 Bit
 */
#define RSTCTL1_PRSTCTL1_SET_DMAC0_RST_SET(x)    (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL1_SET_DMAC0_RST_SET_SHIFT)) & RSTCTL1_PRSTCTL1_SET_DMAC0_RST_SET_MASK)

#define RSTCTL1_PRSTCTL1_SET_DMAC1_RST_SET_MASK  (0x1000000U)
#define RSTCTL1_PRSTCTL1_SET_DMAC1_RST_SET_SHIFT (24U)
/*! DMAC1_RST_SET - DMAC1 reset set
 *  0b0..No Effect
 *  0b1..Sets the PRSTCTL1 Bit
 */
#define RSTCTL1_PRSTCTL1_SET_DMAC1_RST_SET(x)    (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL1_SET_DMAC1_RST_SET_SHIFT)) & RSTCTL1_PRSTCTL1_SET_DMAC1_RST_SET_MASK)

#define RSTCTL1_PRSTCTL1_SET_MU_RST_SET_MASK     (0x10000000U)
#define RSTCTL1_PRSTCTL1_SET_MU_RST_SET_SHIFT    (28U)
/*! MU_RST_SET - MU reset set
 *  0b0..No Effect
 *  0b1..Sets the PRSTCTL1 Bit
 */
#define RSTCTL1_PRSTCTL1_SET_MU_RST_SET(x)       (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL1_SET_MU_RST_SET_SHIFT)) & RSTCTL1_PRSTCTL1_SET_MU_RST_SET_MASK)

#define RSTCTL1_PRSTCTL1_SET_SEMA_RST_SET_MASK   (0x20000000U)
#define RSTCTL1_PRSTCTL1_SET_SEMA_RST_SET_SHIFT  (29U)
/*! SEMA_RST_SET - SEMA reset set
 *  0b0..No Effect
 *  0b1..Sets the PRSTCTL1 Bit
 */
#define RSTCTL1_PRSTCTL1_SET_SEMA_RST_SET(x)     (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL1_SET_SEMA_RST_SET_SHIFT)) & RSTCTL1_PRSTCTL1_SET_SEMA_RST_SET_MASK)

#define RSTCTL1_PRSTCTL1_SET_FREQME_RST_SET_MASK (0x80000000U)
#define RSTCTL1_PRSTCTL1_SET_FREQME_RST_SET_SHIFT (31U)
/*! FREQME_RST_SET - FREQME reset set
 *  0b0..No Effect
 *  0b1..Sets the PRSTCTL1 Bit
 */
#define RSTCTL1_PRSTCTL1_SET_FREQME_RST_SET(x)   (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL1_SET_FREQME_RST_SET_SHIFT)) & RSTCTL1_PRSTCTL1_SET_FREQME_RST_SET_MASK)
/*! @} */

/*! @name PRSTCTL2_SET - peripheral reset set register 2 */
/*! @{ */

#define RSTCTL1_PRSTCTL2_SET_CT32BIT0_RST_SET_MASK (0x1U)
#define RSTCTL1_PRSTCTL2_SET_CT32BIT0_RST_SET_SHIFT (0U)
/*! CT32BIT0_RST_SET - CT32BIT0 reset set
 *  0b0..No Effect
 *  0b1..Sets the PRSTCTL2 Bit
 */
#define RSTCTL1_PRSTCTL2_SET_CT32BIT0_RST_SET(x) (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL2_SET_CT32BIT0_RST_SET_SHIFT)) & RSTCTL1_PRSTCTL2_SET_CT32BIT0_RST_SET_MASK)

#define RSTCTL1_PRSTCTL2_SET_CT32BIT1_RST_SET_MASK (0x2U)
#define RSTCTL1_PRSTCTL2_SET_CT32BIT1_RST_SET_SHIFT (1U)
/*! CT32BIT1_RST_SET - CT32BIT1 reset set
 *  0b0..No Effect
 *  0b1..Sets the PRSTCTL2 Bit
 */
#define RSTCTL1_PRSTCTL2_SET_CT32BIT1_RST_SET(x) (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL2_SET_CT32BIT1_RST_SET_SHIFT)) & RSTCTL1_PRSTCTL2_SET_CT32BIT1_RST_SET_MASK)

#define RSTCTL1_PRSTCTL2_SET_CT32BIT2_RST_SET_MASK (0x4U)
#define RSTCTL1_PRSTCTL2_SET_CT32BIT2_RST_SET_SHIFT (2U)
/*! CT32BIT2_RST_SET - CT32BIT2 reset set
 *  0b0..No Effect
 *  0b1..Sets the PRSTCTL2 Bit
 */
#define RSTCTL1_PRSTCTL2_SET_CT32BIT2_RST_SET(x) (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL2_SET_CT32BIT2_RST_SET_SHIFT)) & RSTCTL1_PRSTCTL2_SET_CT32BIT2_RST_SET_MASK)

#define RSTCTL1_PRSTCTL2_SET_CT32BIT3_RST_SET_MASK (0x8U)
#define RSTCTL1_PRSTCTL2_SET_CT32BIT3_RST_SET_SHIFT (3U)
/*! CT32BIT3_RST_SET - CT32BIT3 reset set
 *  0b0..No Effect
 *  0b1..Sets the PRSTCTL2 Bit
 */
#define RSTCTL1_PRSTCTL2_SET_CT32BIT3_RST_SET(x) (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL2_SET_CT32BIT3_RST_SET_SHIFT)) & RSTCTL1_PRSTCTL2_SET_CT32BIT3_RST_SET_MASK)

#define RSTCTL1_PRSTCTL2_SET_CT32BIT4_RST_SET_MASK (0x10U)
#define RSTCTL1_PRSTCTL2_SET_CT32BIT4_RST_SET_SHIFT (4U)
/*! CT32BIT4_RST_SET - CT32BIT4 reset set
 *  0b0..No Effect
 *  0b1..Sets the PRSTCTL2 Bit
 */
#define RSTCTL1_PRSTCTL2_SET_CT32BIT4_RST_SET(x) (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL2_SET_CT32BIT4_RST_SET_SHIFT)) & RSTCTL1_PRSTCTL2_SET_CT32BIT4_RST_SET_MASK)

#define RSTCTL1_PRSTCTL2_SET_MRT0_RST_SET_MASK   (0x100U)
#define RSTCTL1_PRSTCTL2_SET_MRT0_RST_SET_SHIFT  (8U)
/*! MRT0_RST_SET - MRT0 reset set
 *  0b0..No Effect
 *  0b1..Sets the PRSTCTL2 Bit
 */
#define RSTCTL1_PRSTCTL2_SET_MRT0_RST_SET(x)     (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL2_SET_MRT0_RST_SET_SHIFT)) & RSTCTL1_PRSTCTL2_SET_MRT0_RST_SET_MASK)

#define RSTCTL1_PRSTCTL2_SET_WWDT1_RST_SET_MASK  (0x400U)
#define RSTCTL1_PRSTCTL2_SET_WWDT1_RST_SET_SHIFT (10U)
/*! WWDT1_RST_SET - WWDT1 reset set
 *  0b0..No Effect
 *  0b1..Sets the PRSTCTL2 Bit
 */
#define RSTCTL1_PRSTCTL2_SET_WWDT1_RST_SET(x)    (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL2_SET_WWDT1_RST_SET_SHIFT)) & RSTCTL1_PRSTCTL2_SET_WWDT1_RST_SET_MASK)

#define RSTCTL1_PRSTCTL2_SET_I3C0_RST_SET_MASK   (0x10000U)
#define RSTCTL1_PRSTCTL2_SET_I3C0_RST_SET_SHIFT  (16U)
/*! I3C0_RST_SET - I3C0 reset set
 *  0b0..No Effect
 *  0b1..Sets the PRSTCTL2 Bit
 */
#define RSTCTL1_PRSTCTL2_SET_I3C0_RST_SET(x)     (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL2_SET_I3C0_RST_SET_SHIFT)) & RSTCTL1_PRSTCTL2_SET_I3C0_RST_SET_MASK)

#define RSTCTL1_PRSTCTL2_SET_GPIOINTCTL_RST_SET_MASK (0x40000000U)
#define RSTCTL1_PRSTCTL2_SET_GPIOINTCTL_RST_SET_SHIFT (30U)
/*! GPIOINTCTL_RST_SET - GPIOINTCTL reset set
 *  0b0..No Effect
 *  0b1..Sets the PRSTCTL2 Bit
 */
#define RSTCTL1_PRSTCTL2_SET_GPIOINTCTL_RST_SET(x) (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL2_SET_GPIOINTCTL_RST_SET_SHIFT)) & RSTCTL1_PRSTCTL2_SET_GPIOINTCTL_RST_SET_MASK)

#define RSTCTL1_PRSTCTL2_SET_PIMCTL_RST_SET_MASK (0x80000000U)
#define RSTCTL1_PRSTCTL2_SET_PIMCTL_RST_SET_SHIFT (31U)
/*! PIMCTL_RST_SET - PMC reset set
 *  0b0..No Effect
 *  0b1..Sets the PRSTCTL2 Bit
 */
#define RSTCTL1_PRSTCTL2_SET_PIMCTL_RST_SET(x)   (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL2_SET_PIMCTL_RST_SET_SHIFT)) & RSTCTL1_PRSTCTL2_SET_PIMCTL_RST_SET_MASK)
/*! @} */

/*! @name PRSTCTL0_CLR - peripheral reset clear register 0 */
/*! @{ */

#define RSTCTL1_PRSTCTL0_CLR_FLEXCOMM0_RST_CLR_MASK (0x100U)
#define RSTCTL1_PRSTCTL0_CLR_FLEXCOMM0_RST_CLR_SHIFT (8U)
/*! FLEXCOMM0_RST_CLR - FLEXCOMM0 reset clear
 *  0b0..No Effect
 *  0b1..clears the PRSTCTL0 Bit
 */
#define RSTCTL1_PRSTCTL0_CLR_FLEXCOMM0_RST_CLR(x) (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL0_CLR_FLEXCOMM0_RST_CLR_SHIFT)) & RSTCTL1_PRSTCTL0_CLR_FLEXCOMM0_RST_CLR_MASK)

#define RSTCTL1_PRSTCTL0_CLR_FLEXCOMM1_RST_CLR_MASK (0x200U)
#define RSTCTL1_PRSTCTL0_CLR_FLEXCOMM1_RST_CLR_SHIFT (9U)
/*! FLEXCOMM1_RST_CLR - FLEXCOMM1 reset clear
 *  0b0..No Effect
 *  0b1..clears the PRSTCTL0 Bit
 */
#define RSTCTL1_PRSTCTL0_CLR_FLEXCOMM1_RST_CLR(x) (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL0_CLR_FLEXCOMM1_RST_CLR_SHIFT)) & RSTCTL1_PRSTCTL0_CLR_FLEXCOMM1_RST_CLR_MASK)

#define RSTCTL1_PRSTCTL0_CLR_FLEXCOMM2_RST_CLR_MASK (0x400U)
#define RSTCTL1_PRSTCTL0_CLR_FLEXCOMM2_RST_CLR_SHIFT (10U)
/*! FLEXCOMM2_RST_CLR - FLEXCOMM2 reset clear
 *  0b0..No Effect
 *  0b1..clears the PRSTCTL0 Bit
 */
#define RSTCTL1_PRSTCTL0_CLR_FLEXCOMM2_RST_CLR(x) (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL0_CLR_FLEXCOMM2_RST_CLR_SHIFT)) & RSTCTL1_PRSTCTL0_CLR_FLEXCOMM2_RST_CLR_MASK)

#define RSTCTL1_PRSTCTL0_CLR_FLEXCOMM3_RST_CLR_MASK (0x800U)
#define RSTCTL1_PRSTCTL0_CLR_FLEXCOMM3_RST_CLR_SHIFT (11U)
/*! FLEXCOMM3_RST_CLR - FLEXCOMM3 reset clear
 *  0b0..No Effect
 *  0b1..clears the PRSTCTL0 Bit
 */
#define RSTCTL1_PRSTCTL0_CLR_FLEXCOMM3_RST_CLR(x) (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL0_CLR_FLEXCOMM3_RST_CLR_SHIFT)) & RSTCTL1_PRSTCTL0_CLR_FLEXCOMM3_RST_CLR_MASK)

#define RSTCTL1_PRSTCTL0_CLR_FLEXCOMM4_RST_CLR_MASK (0x1000U)
#define RSTCTL1_PRSTCTL0_CLR_FLEXCOMM4_RST_CLR_SHIFT (12U)
/*! FLEXCOMM4_RST_CLR - FLEXCOMM4 reset clear
 *  0b0..No Effect
 *  0b1..clears the PRSTCTL0 Bit
 */
#define RSTCTL1_PRSTCTL0_CLR_FLEXCOMM4_RST_CLR(x) (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL0_CLR_FLEXCOMM4_RST_CLR_SHIFT)) & RSTCTL1_PRSTCTL0_CLR_FLEXCOMM4_RST_CLR_MASK)

#define RSTCTL1_PRSTCTL0_CLR_FLEXCOMM5_RST_CLR_MASK (0x2000U)
#define RSTCTL1_PRSTCTL0_CLR_FLEXCOMM5_RST_CLR_SHIFT (13U)
/*! FLEXCOMM5_RST_CLR - FLEXCOMM5 reset clear
 *  0b0..No Effect
 *  0b1..clears the PRSTCTL0 Bit
 */
#define RSTCTL1_PRSTCTL0_CLR_FLEXCOMM5_RST_CLR(x) (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL0_CLR_FLEXCOMM5_RST_CLR_SHIFT)) & RSTCTL1_PRSTCTL0_CLR_FLEXCOMM5_RST_CLR_MASK)

#define RSTCTL1_PRSTCTL0_CLR_FLEXCOMM6_RST_CLR_MASK (0x4000U)
#define RSTCTL1_PRSTCTL0_CLR_FLEXCOMM6_RST_CLR_SHIFT (14U)
/*! FLEXCOMM6_RST_CLR - FLEXCOMM6 reset clear
 *  0b0..No Effect
 *  0b1..clears the PRSTCTL0 Bit
 */
#define RSTCTL1_PRSTCTL0_CLR_FLEXCOMM6_RST_CLR(x) (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL0_CLR_FLEXCOMM6_RST_CLR_SHIFT)) & RSTCTL1_PRSTCTL0_CLR_FLEXCOMM6_RST_CLR_MASK)

#define RSTCTL1_PRSTCTL0_CLR_FLEXCOMM7_RST_CLR_MASK (0x8000U)
#define RSTCTL1_PRSTCTL0_CLR_FLEXCOMM7_RST_CLR_SHIFT (15U)
/*! FLEXCOMM7_RST_CLR - FLEXCOMM7 reset clear
 *  0b0..No Effect
 *  0b1..clears the PRSTCTL0 Bit
 */
#define RSTCTL1_PRSTCTL0_CLR_FLEXCOMM7_RST_CLR(x) (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL0_CLR_FLEXCOMM7_RST_CLR_SHIFT)) & RSTCTL1_PRSTCTL0_CLR_FLEXCOMM7_RST_CLR_MASK)

#define RSTCTL1_PRSTCTL0_CLR_FLEXCOMM14_SPI_RST_CLR_MASK (0x400000U)
#define RSTCTL1_PRSTCTL0_CLR_FLEXCOMM14_SPI_RST_CLR_SHIFT (22U)
/*! FLEXCOMM14_SPI_RST_CLR - FLEXCOMM14 SPI reset clear
 *  0b0..No Effect
 *  0b1..clears the PRSTCTL0 Bit
 */
#define RSTCTL1_PRSTCTL0_CLR_FLEXCOMM14_SPI_RST_CLR(x) (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL0_CLR_FLEXCOMM14_SPI_RST_CLR_SHIFT)) & RSTCTL1_PRSTCTL0_CLR_FLEXCOMM14_SPI_RST_CLR_MASK)

#define RSTCTL1_PRSTCTL0_CLR_FLEXCOMM15_I2C_RST_CLR_MASK (0x800000U)
#define RSTCTL1_PRSTCTL0_CLR_FLEXCOMM15_I2C_RST_CLR_SHIFT (23U)
/*! FLEXCOMM15_I2C_RST_CLR - FLEXCOMM15 I2C reset clear
 *  0b0..No Effect
 *  0b1..clears the PRSTCTL0 Bit
 */
#define RSTCTL1_PRSTCTL0_CLR_FLEXCOMM15_I2C_RST_CLR(x) (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL0_CLR_FLEXCOMM15_I2C_RST_CLR_SHIFT)) & RSTCTL1_PRSTCTL0_CLR_FLEXCOMM15_I2C_RST_CLR_MASK)

#define RSTCTL1_PRSTCTL0_CLR_DMIC0_RST_CLR_MASK  (0x1000000U)
#define RSTCTL1_PRSTCTL0_CLR_DMIC0_RST_CLR_SHIFT (24U)
/*! DMIC0_RST_CLR - DMIC0 reset clear
 *  0b0..No Effect
 *  0b1..clears the PRSTCTL0 Bit
 */
#define RSTCTL1_PRSTCTL0_CLR_DMIC0_RST_CLR(x)    (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL0_CLR_DMIC0_RST_CLR_SHIFT)) & RSTCTL1_PRSTCTL0_CLR_DMIC0_RST_CLR_MASK)

#define RSTCTL1_PRSTCTL0_CLR_OSEVT_TIMER_RST_CLR_MASK (0x8000000U)
#define RSTCTL1_PRSTCTL0_CLR_OSEVT_TIMER_RST_CLR_SHIFT (27U)
/*! OSEVT_TIMER_RST_CLR - osevent timer reset clear
 *  0b0..No Effect
 *  0b1..clears the PRSTCTL0 Bit
 */
#define RSTCTL1_PRSTCTL0_CLR_OSEVT_TIMER_RST_CLR(x) (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL0_CLR_OSEVT_TIMER_RST_CLR_SHIFT)) & RSTCTL1_PRSTCTL0_CLR_OSEVT_TIMER_RST_CLR_MASK)
/*! @} */

/*! @name PRSTCTL1_CLR - peripheral reset clear register 1 */
/*! @{ */

#define RSTCTL1_PRSTCTL1_CLR_HSGPIO0_RST_CLR_MASK (0x1U)
#define RSTCTL1_PRSTCTL1_CLR_HSGPIO0_RST_CLR_SHIFT (0U)
/*! HSGPIO0_RST_CLR - HSGPIO0 reset clear
 *  0b0..No Effect
 *  0b1..clears the PRSTCTL1 Bit
 */
#define RSTCTL1_PRSTCTL1_CLR_HSGPIO0_RST_CLR(x)  (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL1_CLR_HSGPIO0_RST_CLR_SHIFT)) & RSTCTL1_PRSTCTL1_CLR_HSGPIO0_RST_CLR_MASK)

#define RSTCTL1_PRSTCTL1_CLR_HSGPIO1_RST_CLR_MASK (0x2U)
#define RSTCTL1_PRSTCTL1_CLR_HSGPIO1_RST_CLR_SHIFT (1U)
/*! HSGPIO1_RST_CLR - HSGPIO1 reset clear
 *  0b0..No Effect
 *  0b1..clears the PRSTCTL1 Bit
 */
#define RSTCTL1_PRSTCTL1_CLR_HSGPIO1_RST_CLR(x)  (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL1_CLR_HSGPIO1_RST_CLR_SHIFT)) & RSTCTL1_PRSTCTL1_CLR_HSGPIO1_RST_CLR_MASK)

#define RSTCTL1_PRSTCTL1_CLR_HSGPIO2_RST_CLR_MASK (0x4U)
#define RSTCTL1_PRSTCTL1_CLR_HSGPIO2_RST_CLR_SHIFT (2U)
/*! HSGPIO2_RST_CLR - HSGPIO2 reset clear
 *  0b0..No Effect
 *  0b1..clears the PRSTCTL1 Bit
 */
#define RSTCTL1_PRSTCTL1_CLR_HSGPIO2_RST_CLR(x)  (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL1_CLR_HSGPIO2_RST_CLR_SHIFT)) & RSTCTL1_PRSTCTL1_CLR_HSGPIO2_RST_CLR_MASK)

#define RSTCTL1_PRSTCTL1_CLR_HSGPIO3_RST_CLR_MASK (0x8U)
#define RSTCTL1_PRSTCTL1_CLR_HSGPIO3_RST_CLR_SHIFT (3U)
/*! HSGPIO3_RST_CLR - HSGPIO3 reset clear
 *  0b0..No Effect
 *  0b1..clears the PRSTCTL1 Bit
 */
#define RSTCTL1_PRSTCTL1_CLR_HSGPIO3_RST_CLR(x)  (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL1_CLR_HSGPIO3_RST_CLR_SHIFT)) & RSTCTL1_PRSTCTL1_CLR_HSGPIO3_RST_CLR_MASK)

#define RSTCTL1_PRSTCTL1_CLR_HSGPIO4_RST_CLR_MASK (0x10U)
#define RSTCTL1_PRSTCTL1_CLR_HSGPIO4_RST_CLR_SHIFT (4U)
/*! HSGPIO4_RST_CLR - HSGPIO4 reset clear
 *  0b0..No Effect
 *  0b1..clears the PRSTCTL1 Bit
 */
#define RSTCTL1_PRSTCTL1_CLR_HSGPIO4_RST_CLR(x)  (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL1_CLR_HSGPIO4_RST_CLR_SHIFT)) & RSTCTL1_PRSTCTL1_CLR_HSGPIO4_RST_CLR_MASK)

#define RSTCTL1_PRSTCTL1_CLR_HSGPIO5_RST_CLR_MASK (0x20U)
#define RSTCTL1_PRSTCTL1_CLR_HSGPIO5_RST_CLR_SHIFT (5U)
/*! HSGPIO5_RST_CLR - HSGPIO5 reset clear
 *  0b0..No Effect
 *  0b1..clears the PRSTCTL1 Bit
 */
#define RSTCTL1_PRSTCTL1_CLR_HSGPIO5_RST_CLR(x)  (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL1_CLR_HSGPIO5_RST_CLR_SHIFT)) & RSTCTL1_PRSTCTL1_CLR_HSGPIO5_RST_CLR_MASK)

#define RSTCTL1_PRSTCTL1_CLR_HSGPIO6_RST_CLR_MASK (0x40U)
#define RSTCTL1_PRSTCTL1_CLR_HSGPIO6_RST_CLR_SHIFT (6U)
/*! HSGPIO6_RST_CLR - HSGPIO6 reset clear
 *  0b0..No Effect
 *  0b1..clears the PRSTCTL1 Bit
 */
#define RSTCTL1_PRSTCTL1_CLR_HSGPIO6_RST_CLR(x)  (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL1_CLR_HSGPIO6_RST_CLR_SHIFT)) & RSTCTL1_PRSTCTL1_CLR_HSGPIO6_RST_CLR_MASK)

#define RSTCTL1_PRSTCTL1_CLR_HSGPIO7_RST_CLR_MASK (0x80U)
#define RSTCTL1_PRSTCTL1_CLR_HSGPIO7_RST_CLR_SHIFT (7U)
/*! HSGPIO7_RST_CLR - HSGPIO7 reset clear
 *  0b0..No Effect
 *  0b1..clears the PRSTCTL1 Bit
 */
#define RSTCTL1_PRSTCTL1_CLR_HSGPIO7_RST_CLR(x)  (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL1_CLR_HSGPIO7_RST_CLR_SHIFT)) & RSTCTL1_PRSTCTL1_CLR_HSGPIO7_RST_CLR_MASK)

#define RSTCTL1_PRSTCTL1_CLR_CRC_RST_CLR_MASK    (0x10000U)
#define RSTCTL1_PRSTCTL1_CLR_CRC_RST_CLR_SHIFT   (16U)
/*! CRC_RST_CLR - CRC reset clear
 *  0b0..No Effect
 *  0b1..clears the PRSTCTL1 Bit
 */
#define RSTCTL1_PRSTCTL1_CLR_CRC_RST_CLR(x)      (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL1_CLR_CRC_RST_CLR_SHIFT)) & RSTCTL1_PRSTCTL1_CLR_CRC_RST_CLR_MASK)

#define RSTCTL1_PRSTCTL1_CLR_DMAC0_RST_CLR_MASK  (0x800000U)
#define RSTCTL1_PRSTCTL1_CLR_DMAC0_RST_CLR_SHIFT (23U)
/*! DMAC0_RST_CLR - DMAC0 reset clear
 *  0b0..No Effect
 *  0b1..clears the PRSTCTL1 Bit
 */
#define RSTCTL1_PRSTCTL1_CLR_DMAC0_RST_CLR(x)    (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL1_CLR_DMAC0_RST_CLR_SHIFT)) & RSTCTL1_PRSTCTL1_CLR_DMAC0_RST_CLR_MASK)

#define RSTCTL1_PRSTCTL1_CLR_DMAC1_RST_CLR_MASK  (0x1000000U)
#define RSTCTL1_PRSTCTL1_CLR_DMAC1_RST_CLR_SHIFT (24U)
/*! DMAC1_RST_CLR - DMAC1 reset clear
 *  0b0..No Effect
 *  0b1..clears the PRSTCTL1 Bit
 */
#define RSTCTL1_PRSTCTL1_CLR_DMAC1_RST_CLR(x)    (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL1_CLR_DMAC1_RST_CLR_SHIFT)) & RSTCTL1_PRSTCTL1_CLR_DMAC1_RST_CLR_MASK)

#define RSTCTL1_PRSTCTL1_CLR_MU_RST_CLR_MASK     (0x10000000U)
#define RSTCTL1_PRSTCTL1_CLR_MU_RST_CLR_SHIFT    (28U)
/*! MU_RST_CLR - MU reset clear
 *  0b0..No Effect
 *  0b1..clears the PRSTCTL1 Bit
 */
#define RSTCTL1_PRSTCTL1_CLR_MU_RST_CLR(x)       (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL1_CLR_MU_RST_CLR_SHIFT)) & RSTCTL1_PRSTCTL1_CLR_MU_RST_CLR_MASK)

#define RSTCTL1_PRSTCTL1_CLR_SEMA_RST_CLR_MASK   (0x20000000U)
#define RSTCTL1_PRSTCTL1_CLR_SEMA_RST_CLR_SHIFT  (29U)
/*! SEMA_RST_CLR - SEMA reset clear
 *  0b0..No Effect
 *  0b1..clears the PRSTCTL1 Bit
 */
#define RSTCTL1_PRSTCTL1_CLR_SEMA_RST_CLR(x)     (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL1_CLR_SEMA_RST_CLR_SHIFT)) & RSTCTL1_PRSTCTL1_CLR_SEMA_RST_CLR_MASK)

#define RSTCTL1_PRSTCTL1_CLR_FREQME_RST_CLR_MASK (0x80000000U)
#define RSTCTL1_PRSTCTL1_CLR_FREQME_RST_CLR_SHIFT (31U)
/*! FREQME_RST_CLR - FREQME reset clear
 *  0b0..No Effect
 *  0b1..clears the PRSTCTL1 Bit
 */
#define RSTCTL1_PRSTCTL1_CLR_FREQME_RST_CLR(x)   (((uint32_t)(((uint32_t)(x)) << RSTCTL1_PRSTCTL1_CLR_FREQME_RST_CLR_SHIFT)) & RSTCTL1_PRSTCTL1_CLR