/*
 * Copyright 2022 NXP
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */
/***********************************************************************************************************************
 * This file was generated by the MCUXpresso Config Tools. Any manual edits made to this file
 * will be overwritten if the respective MCUXpresso Config Tools is used to update this file.
 **********************************************************************************************************************/

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
!!GlobalInfo
product: Pins v12.0
processor: KW45B41Z83xxxA
package_id: KW45B41Z83AFTA
mcu_data: ksdk2_0
processor_version: 0.12.2
pin_labels:
- {pin_num: '44', pin_signal: ADC0_A8/PTC6/WUU0_P11/LPSPI1_PCS1/TPM1_CH5/FLEXIO0_D22, label: SW2/SW3/SW3, identifier: SW;SW2;SW3}
- {pin_num: '24', pin_signal: ADC0_B5/PTD1/SPC0_LPREQ/NMI_b/RF_GPO_4, label: SW3/SW2/SW2, identifier: SW3;SW2}
- {pin_num: '18', pin_signal: ADC0_A15/CMP0_IN2/PTA21/WUU0_P5/LPSPI0_PCS3/LPUART0_RX/EWM0_OUT_b/TPM0_CH0/RF_GPO_3/RF_GPO_7/FLEXIO0_D8/RF_GPO_10, label: LED_R, identifier: LED_R}
- {pin_num: '46', pin_signal: ADC0_B10/PTB0/WUU0_P13/LPSPI1_PCS0/TPM1_CH0/FLEXIO0_D26, label: LED1/LPSPI1_PCS0, identifier: LED1;LPSPI1_PCS0}
- {pin_num: '14', pin_signal: CMP1_IN0/PTA19/WUU0_P4/LPSPI0_SCK/LPUART0_RTS_b/LPI2C0_SCL/TPM0_CH2/RF_GPO_1, label: LED_G, identifier: LED_G}
- {pin_num: '17', pin_signal: ADC0_A14/CMP0_IN3/PTA20/LPSPI0_PCS2/LPUART0_TX/EWM0_IN/TPM0_CH1/RF_GPO_2/FLEXIO0_D7, label: LED_B, identifier: LED_B}
- {pin_num: '1', pin_signal: ADC0_B13/PTB3/WUU0_P14/LPSPI1_SOUT/LPUART1_RX/TPM1_CH3/FLEXIO0_D29, label: SO_IO1/SO-IO1/SO-IO1, identifier: SO_IO1}
- {pin_num: '2', pin_signal: PTB4/WUU0_P15/LPSPI1_PCS3/LPUART1_CTS_b/LPI2C1_SDA/I3C0_SDA/TRGMUX0_IN0/FLEXIO0_D30, label: HLD_RST/HOLD-RESET/HOLD-RESET, identifier: HLD_RST;HOLD_RESET}
- {pin_num: '3', pin_signal: PTB5/LPSPI1_PCS2/LPUART1_RTS_b/LPI2C1_SCL/I3C0_SCL/TRGMUX0_OUT0/FLEXIO0_D31, label: WP_IO2/WP-IO2/WP-IO2, identifier: WP_IO2}
- {pin_num: '48', pin_signal: ADC0_B12/PTB2/LPSPI1_SCK/LPUART1_TX/TPM1_CH2/FLEXIO0_D28, label: SCK, identifier: SCKSI_IO1}
- {pin_num: '47', pin_signal: ADC0_B11/PTB1/LPSPI1_SIN/TPM1_CH1/FLEXIO0_D27, label: SI_IO1/SI-IO1/SI-IO1, identifier: SI_IO1}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

#include "fsl_common.h"
#include "fsl_port.h"
#include "fsl_gpio.h"
#include "pin_mux.h"

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_InitPinButton0:
- options: {callFromInitBoot: 'false', prefix: BOARD_INITPINBUTTON0_, coreID: cm33, enableClock: 'true'}
- pin_list:
  - {pin_num: '24', peripheral: GPIOD, signal: 'GPIO, 1', pin_signal: ADC0_B5/PTD1/SPC0_LPREQ/NMI_b/RF_GPO_4, identifier: SW2, pull_select: up, pull_enable: enable,
    pull_value: high, passive_filter: disable, open_drain: enable}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitPinButton0
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
void BOARD_InitPinButton0(void)
{

    const port_pin_config_t SW2 = {/* Internal pull-up resistor is enabled */
                                   (uint16_t)kPORT_PullUp,
                                   /* High internal pull resistor value is selected. */
                                   (uint16_t)kPORT_HighPullResistor,
                                   /* Fast slew rate is configured */
                                   (uint16_t)kPORT_FastSlewRate,
                                   /* Passive input filter is disabled */
                                   (uint16_t)kPORT_PassiveFilterDisable,
                                   /* Open drain output is enabled */
                                   (uint16_t)kPORT_OpenDrainEnable,
                                   /* Low drive strength is configured */
                                   (uint16_t)kPORT_LowDriveStrength,
                                   /* Normal drive strength is configured */
                                   (uint16_t)kPORT_NormalDriveStrength,
                                   /* Pin is configured as PTD1 */
                                   (uint16_t)kPORT_MuxAsGpio,
                                   /* Pin Control Register fields [15:0] are not locked */
                                   (uint16_t)kPORT_UnlockRegister};
    /* PORTD1 (pin 24) is configured as PTD1 */
    PORT_SetPinConfig(BOARD_INITPINBUTTON0_SW2_PORT, BOARD_INITPINBUTTON0_SW2_PIN, &SW2);
}

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_InitPinButton1:
- options: {callFromInitBoot: 'false', prefix: BOARD_INITPINBUTTON1_, coreID: cm33, enableClock: 'true'}
- pin_list:
  - {pin_num: '44', peripheral: GPIOC, signal: 'GPIO, 6', pin_signal: ADC0_A8/PTC6/WUU0_P11/LPSPI1_PCS1/TPM1_CH5/FLEXIO0_D22, identifier: SW3, pull_select: up, pull_enable: enable,
    slew_rate: slow, open_drain: enable, drive_strength: low}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitPinButton1
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
void BOARD_InitPinButton1(void)
{
    /* Clock Configuration: Peripheral clocks are enabled; module does not stall low power mode entry */
    CLOCK_EnableClock(kCLOCK_PortC);

    const port_pin_config_t SW3 = {/* Internal pull-up resistor is enabled */
                                   (uint16_t)kPORT_PullUp,
                                   /* Low internal pull resistor value is selected. */
                                   (uint16_t)kPORT_LowPullResistor,
                                   /* Slow slew rate is configured */
                                   (uint16_t)kPORT_SlowSlewRate,
                                   /* Passive input filter is disabled */
                                   (uint16_t)kPORT_PassiveFilterDisable,
                                   /* Open drain output is enabled */
                                   (uint16_t)kPORT_OpenDrainEnable,
                                   /* Low drive strength is configured */
                                   (uint16_t)kPORT_LowDriveStrength,
                                   /* Normal drive strength is configured */
                                   (uint16_t)kPORT_NormalDriveStrength,
                                   /* Pin is configured as PTC6 */
                                   (uint16_t)kPORT_MuxAsGpio,
                                   /* Pin Control Register fields [15:0] are not locked */
                                   (uint16_t)kPORT_UnlockRegister};
    /* PORTC6 (pin 44) is configured as PTC6 */
    PORT_SetPinConfig(BOARD_INITPINBUTTON1_SW3_PORT, BOARD_INITPINBUTTON1_SW3_PIN, &SW3);
}

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_InitPinLED1:
- options: {callFromInitBoot: 'false', prefix: BOARD_INITPINLED1_, coreID: cm33, enableClock: 'true'}
- pin_list:
  - {pin_num: '46', peripheral: GPIOB, signal: 'GPIO, 0', pin_signal: ADC0_B10/PTB0/WUU0_P13/LPSPI1_PCS0/TPM1_CH0/FLEXIO0_D26, identifier: LED1, pull_select: down,
    pull_enable: disable, slew_rate: slow, open_drain: disable, drive_strength: low}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitPinLED1
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
void BOARD_InitPinLED1(void)
{
    /* Clock Configuration: Peripheral clocks are enabled; module does not stall low power mode entry */
    CLOCK_EnableClock(kCLOCK_PortB);

    const port_pin_config_t LED1 = {/* Internal pull-up/down resistor is disabled */
                                    (uint16_t)kPORT_PullDisable,
                                    /* Low internal pull resistor value is selected. */
                                    (uint16_t)kPORT_LowPullResistor,
                                    /* Slow slew rate is configured */
                                    (uint16_t)kPORT_SlowSlewRate,
                                    /* Passive input filter is disabled */
                                    (uint16_t)kPORT_PassiveFilterDisable,
                                    /* Open drain output is disabled */
                                    (uint16_t)kPORT_OpenDrainDisable,
                                    /* Low drive strength is configured */
                                    (uint16_t)kPORT_LowDriveStrength,
                                    /* Normal drive strength is configured */
                                    (uint16_t)kPORT_NormalDriveStrength,
                                    /* Pin is configured as PTB0 */
                                    (uint16_t)kPORT_MuxAsGpio,
                                    /* Pin Control Register fields [15:0] are not locked */
                                    (uint16_t)kPORT_UnlockRegister};
    /* PORTB0 (pin 46) is configured as PTB0 */
    PORT_SetPinConfig(BOARD_INITPINLED1_LED1_PORT, BOARD_INITPINLED1_LED1_PIN, &LED1);
}

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_InitPinLED2:
- options: {callFromInitBoot: 'false', prefix: BOARD_INITPINLED2_, coreID: cm33, enableClock: 'true'}
- pin_list:
  - {pin_num: '18', peripheral: GPIOA, signal: 'GPIO, 21', pin_signal: ADC0_A15/CMP0_IN2/PTA21/WUU0_P5/LPSPI0_PCS3/LPUART0_RX/EWM0_OUT_b/TPM0_CH0/RF_GPO_3/RF_GPO_7/FLEXIO0_D8/RF_GPO_10,
    pull_select: down, pull_enable: disable, slew_rate: slow, open_drain: disable, drive_strength: low}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitPinLED2
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
void BOARD_InitPinLED2(void)
{
    /* Clock Configuration: Peripheral clocks are enabled; module does not stall low power mode entry */
    CLOCK_EnableClock(kCLOCK_PortA);

    const port_pin_config_t LED_R = {/* Internal pull-up/down resistor is disabled */
                                     (uint16_t)kPORT_PullDisable,
                                     /* Low internal pull resistor value is selected. */
                                     (uint16_t)kPORT_LowPullResistor,
                                     /* Slow slew rate is configured */
                                     (uint16_t)kPORT_SlowSlewRate,
                                     /* Passive input filter is disabled */
                                     (uint16_t)kPORT_PassiveFilterDisable,
                                     /* Open drain output is disabled */
                                     (uint16_t)kPORT_OpenDrainDisable,
                                     /* Low drive strength is configured */
                                     (uint16_t)kPORT_LowDriveStrength,
                                     /* Normal drive strength is configured */
                                     (uint16_t)kPORT_NormalDriveStrength,
                                     /* Pin is configured as PTA21 */
                                     (uint16_t)kPORT_MuxAsGpio,
                                     /* Pin Control Register fields [15:0] are not locked */
                                     (uint16_t)kPORT_UnlockRegister};
    /* PORTA21 (pin 18) is configured as PTA21 */
    PORT_SetPinConfig(BOARD_INITPINLED2_LED_R_PORT, BOARD_INITPINLED2_LED_R_PIN, &LED_R);
}

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_InitPinLED3:
- options: {callFromInitBoot: 'false', prefix: BOARD_INITPINLED3_, coreID: cm33, enableClock: 'true'}
- pin_list:
  - {pin_num: '14', peripheral: GPIOA, signal: 'GPIO, 19', pin_signal: CMP1_IN0/PTA19/WUU0_P4/LPSPI0_SCK/LPUART0_RTS_b/LPI2C0_SCL/TPM0_CH2/RF_GPO_1, pull_select: down,
    pull_enable: disable, pull_value: low, slew_rate: slow, passive_filter: disable, open_drain: disable, drive_strength: low, drive_strength_1: normal}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitPinLED3
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
void BOARD_InitPinLED3(void)
{
    /* Clock Configuration: Peripheral clocks are enabled; module does not stall low power mode entry */
    CLOCK_EnableClock(kCLOCK_PortA);

    const port_pin_config_t LED_G = {/* Internal pull-up/down resistor is disabled */
                                     (uint16_t)kPORT_PullDisable,
                                     /* Low internal pull resistor value is selected. */
                                     (uint16_t)kPORT_LowPullResistor,
                                     /* Slow slew rate is configured */
                                     (uint16_t)kPORT_SlowSlewRate,
                                     /* Passive input filter is disabled */
                                     (uint16_t)kPORT_PassiveFilterDisable,
                                     /* Open drain output is disabled */
                                     (uint16_t)kPORT_OpenDrainDisable,
                                     /* Low drive strength is configured */
                                     (uint16_t)kPORT_LowDriveStrength,
                                     /* Normal drive strength is configured */
                                     (uint16_t)kPORT_NormalDriveStrength,
                                     /* Pin is configured as PTA19 */
                                     (uint16_t)kPORT_MuxAsGpio,
                                     /* Pin Control Register fields [15:0] are not locked */
                                     (uint16_t)kPORT_UnlockRegister};
    /* PORTA19 (pin 14) is configured as PTA19 */
    PORT_SetPinConfig(BOARD_INITPINLED3_LED_G_PORT, BOARD_INITPINLED3_LED_G_PIN, &LED_G);
}

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_InitPinLED4:
- options: {callFromInitBoot: 'false', prefix: BOARD_INITPINLED4_, coreID: cm33, enableClock: 'true'}
- pin_list:
  - {pin_num: '17', peripheral: GPIOA, signal: 'GPIO, 20', pin_signal: ADC0_A14/CMP0_IN3/PTA20/LPSPI0_PCS2/LPUART0_TX/EWM0_IN/TPM0_CH1/RF_GPO_2/FLEXIO0_D7, pull_select: down,
    pull_enable: disable, slew_rate: slow, open_drain: disable, drive_strength: low}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitPinLED4
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
void BOARD_InitPinLED4(void)
{
    /* Clock Configuration: Peripheral clocks are enabled; module does not stall low power mode entry */
    CLOCK_EnableClock(kCLOCK_PortA);

    const port_pin_config_t LED_B = {/* Internal pull-up/down resistor is disabled */
                                     (uint16_t)kPORT_PullDisable,
                                     /* Low internal pull resistor value is selected. */
                                     (uint16_t)kPORT_LowPullResistor,
                                     /* Slow slew rate is configured */
                                     (uint16_t)kPORT_SlowSlewRate,
                                     /* Passive input filter is disabled */
                                     (uint16_t)kPORT_PassiveFilterDisable,
                                     /* Open drain output is disabled */
                                     (uint16_t)kPORT_OpenDrainDisable,
                                     /* Low drive strength is configured */
                                     (uint16_t)kPORT_LowDriveStrength,
                                     /* Normal drive strength is configured */
                                     (uint16_t)kPORT_NormalDriveStrength,
                                     /* Pin is configured as PTA20 */
                                     (uint16_t)kPORT_MuxAsGpio,
                                     /* Pin Control Register fields [15:0] are not locked */
                                     (uint16_t)kPORT_UnlockRegister};
    /* PORTA20 (pin 17) is configured as PTA20 */
    PORT_SetPinConfig(BOARD_INITPINLED4_LED_B_PORT, BOARD_INITPINLED4_LED_B_PIN, &LED_B);
}

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_InitPinLPUART0_RX:
- options: {callFromInitBoot: 'false', coreID: cm33, enableClock: 'true'}
- pin_list:
  - {pin_num: '11', peripheral: LPUART0, signal: RX, pin_signal: ADC0_A12/PTA16/LPSPI0_PCS0/EWM0_OUT_b/LPI2C0_SCLS/TPM0_CH4/LPUART0_RX/RF_GPO_8/FLEXIO0_D5}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitPinLPUART0_RX
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
void BOARD_InitPinLPUART0_RX(void)
{
    /* Clock Configuration: Peripheral clocks are enabled; module does not stall low power mode entry */
    CLOCK_EnableClock(kCLOCK_PortA);

    /* PORTA16 (pin 11) is configured as LPUART0_RX */
    PORT_SetPinMux(PORTA, 16U, kPORT_MuxAlt6);
}

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_InitPinLPUART0_TX:
- options: {callFromInitBoot: 'false', coreID: cm33, enableClock: 'true'}
- pin_list:
  - {pin_num: '12', peripheral: LPUART0, signal: TX, pin_signal: ADC0_A13/PTA17/WUU0_P3/LPSPI0_SIN/EWM0_IN/LPI2C0_SDAS/TPM0_CH5/LPUART0_TX/RF_GPO_7/RF_GPO_8/FLEXIO0_D6}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitPinLPUART0_TX
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
void BOARD_InitPinLPUART0_TX(void)
{
    /* Clock Configuration: Peripheral clocks are enabled; module does not stall low power mode entry */
    CLOCK_EnableClock(kCLOCK_PortA);

    /* PORTA17 (pin 12) is configured as LPUART0_TX */
    PORT_SetPinMux(PORTA, 17U, kPORT_MuxAlt6);
}

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_InitPinLPUART1_RX:
- options: {callFromInitBoot: 'false', coreID: cm33, enableClock: 'true'}
- pin_list:
  - {pin_num: '39', peripheral: LPUART1, signal: RX, pin_signal: PTC2/WUU0_P9/LPSPI1_SOUT/LPUART1_RX/LPI2C1_SCLS/TPM1_CH2/I3C0_PUR/FLEXIO0_D18}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitPinLPUART1_RX
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
void BOARD_InitPinLPUART1_RX(void)
{
    /* Clock Configuration: Peripheral clocks are enabled; module does not stall low power mode entry */
    CLOCK_EnableClock(kCLOCK_PortC);

    /* PORTC2 (pin 39) is configured as LPUART1_RX */
    PORT_SetPinMux(PORTC, 2U, kPORT_MuxAlt3);
}

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_InitPinLPUART1_TX:
- options: {callFromInitBoot: 'false', coreID: cm33, enableClock: 'true'}
- pin_list:
  - {pin_num: '40', peripheral: LPUART1, signal: TX, pin_signal: PTC3/LPSPI1_SCK/LPUART1_TX/LPI2C1_SDAS/TPM1_CH3/FLEXIO0_D19}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitPinLPUART1_TX
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
void BOARD_InitPinLPUART1_TX(void)
{
    /* Clock Configuration: Peripheral clocks are enabled; module does not stall low power mode entry */
    CLOCK_EnableClock(kCLOCK_PortC);

    /* PORTC3 (pin 40) is configured as LPUART1_TX */
    PORT_SetPinMux(PORTC, 3U, kPORT_MuxAlt3);
}

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_UnInitPinLPUART0_RX:
- options: {callFromInitBoot: 'false', coreID: cm33, enableClock: 'true'}
- pin_list:
  - {pin_num: '11', peripheral: ADC0, signal: 'A, 12', pin_signal: ADC0_A12/PTA16/LPSPI0_PCS0/EWM0_OUT_b/LPI2C0_SCLS/TPM0_CH4/LPUART0_RX/RF_GPO_8/FLEXIO0_D5}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_UnInitPinLPUART0_RX
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
void BOARD_UnInitPinLPUART0_RX(void)
{
    /* Clock Configuration: Peripheral clocks are enabled; module does not stall low power mode entry */
    CLOCK_EnableClock(kCLOCK_PortA);

    /* PORTA16 (pin 11) is configured as ADC0_A12 */
    PORT_SetPinMux(PORTA, 16U, kPORT_PinDisabledOrAnalog);
}

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_UnInitPinLPUART0_TX:
- options: {callFromInitBoot: 'false', coreID: cm33, enableClock: 'true'}
- pin_list:
  - {pin_num: '12', peripheral: ADC0, signal: 'A, 13', pin_signal: ADC0_A13/PTA17/WUU0_P3/LPSPI0_SIN/EWM0_IN/LPI2C0_SDAS/TPM0_CH5/LPUART0_TX/RF_GPO_7/RF_GPO_8/FLEXIO0_D6}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_UnInitPinLPUART0_TX
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
void BOARD_UnInitPinLPUART0_TX(void)
{
    /* Clock Configuration: Peripheral clocks are enabled; module does not stall low power mode entry */
    CLOCK_EnableClock(kCLOCK_PortA);

    /* PORTA17 (pin 12) is configured as ADC0_A13 */
    PORT_SetPinMux(PORTA, 17U, kPORT_PinDisabledOrAnalog);
}

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_UnInitPinLPUART1_RX:
- options: {callFromInitBoot: 'false', coreID: cm33, enableClock: 'true'}
- pin_list:
  - {pin_num: '39', peripheral: n/a, signal: disabled, pin_signal: PTC2/WUU0_P9/LPSPI1_SOUT/LPUART1_RX/LPI2C1_SCLS/TPM1_CH2/I3C0_PUR/FLEXIO0_D18}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_UnInitPinLPUART1_RX
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
void BOARD_UnInitPinLPUART1_RX(void)
{
    /* Clock Configuration: Peripheral clocks are enabled; module does not stall low power mode entry */
    CLOCK_EnableClock(kCLOCK_PortC);

    /* PORTC2 (pin 39) is disabled */
    PORT_SetPinMux(PORTC, 2U, kPORT_PinDisabledOrAnalog);
}

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_UnInitPinLPUART1_TX:
- options: {callFromInitBoot: 'false', coreID: cm33, enableClock: 'true'}
- pin_list:
  - {pin_num: '40', peripheral: n/a, signal: disabled, pin_signal: PTC3/LPSPI1_SCK/LPUART1_TX/LPI2C1_SDAS/TPM1_CH3/FLEXIO0_D19}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_UnInitPinLPUART1_TX
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
void BOARD_UnInitPinLPUART1_TX(void)
{
    /* Clock Configuration: Peripheral clocks are enabled; module does not stall low power mode entry */
    CLOCK_EnableClock(kCLOCK_PortC);

    /* PORTC3 (pin 40) is disabled */
    PORT_SetPinMux(PORTC, 3U, kPORT_PinDisabledOrAnalog);
}

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_UnInitPinButton1:
- options: {callFromInitBoot: 'false', coreID: cm33, enableClock: 'true'}
- pin_list:
  - {pin_num: '44', peripheral: ADC0, signal: 'A, 8', pin_signal: ADC0_A8/PTC6/WUU0_P11/LPSPI1_PCS1/TPM1_CH5/FLEXIO0_D22, identifier: SW3}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_UnInitPinButton1
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
void BOARD_UnInitPinButton1(void)
{
    /* Clock Configuration: Peripheral clocks are enabled; module does not stall low power mode entry */
    CLOCK_EnableClock(kCLOCK_PortC);

    /* PORTC6 (pin 44) is configured as ADC0_A8 */
    PORT_SetPinMux(BOARD_UNINITPINBUTTON1_SW3_PORT, BOARD_UNINITPINBUTTON1_SW3_PIN, kPORT_PinDisabledOrAnalog);
}

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_UnInitPinButton0:
- options: {callFromInitBoot: 'false', coreID: cm33, enableClock: 'true'}
- pin_list:
  - {pin_num: '24', peripheral: ADC0, signal: 'B, 5', pin_signal: ADC0_B5/PTD1/SPC0_LPREQ/NMI_b/RF_GPO_4, identifier: SW2}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_UnInitPinButton0
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
void BOARD_UnInitPinButton0(void)
{

    /* PORTD1 (pin 24) is configured as ADC0_B5 */
    PORT_SetPinMux(BOARD_UNINITPINBUTTON0_SW2_PORT, BOARD_UNINITPINBUTTON0_SW2_PIN, kPORT_PinDisabledOrAnalog);
}

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_UnInitPinLED1:
- options: {callFromInitBoot: 'false', coreID: cm33, enableClock: 'true'}
- pin_list:
  - {pin_num: '46', peripheral: ADC0, signal: 'B, 10', pin_signal: ADC0_B10/PTB0/WUU0_P13/LPSPI1_PCS0/TPM1_CH0/FLEXIO0_D26, identifier: LED1}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_UnInitPinLED1
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
void BOARD_UnInitPinLED1(void)
{
    /* Clock Configuration: Peripheral clocks are enabled; module does not stall low power mode entry */
    CLOCK_EnableClock(kCLOCK_PortB);

    /* PORTB0 (pin 46) is configured as ADC0_B10 */
    PORT_SetPinMux(BOARD_UNINITPINLED1_LED1_PORT, BOARD_UNINITPINLED1_LED1_PIN, kPORT_PinDisabledOrAnalog);
}

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_UnInitPinLED2:
- options: {callFromInitBoot: 'false', coreID: cm33, enableClock: 'true'}
- pin_list:
  - {pin_num: '18', peripheral: ADC0, signal: 'A, 15', pin_signal: ADC0_A15/CMP0_IN2/PTA21/WUU0_P5/LPSPI0_PCS3/LPUART0_RX/EWM0_OUT_b/TPM0_CH0/RF_GPO_3/RF_GPO_7/FLEXIO0_D8/RF_GPO_10}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_UnInitPinLED2
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
void BOARD_UnInitPinLED2(void)
{
    /* Clock Configuration: Peripheral clocks are enabled; module does not stall low power mode entry */
    CLOCK_EnableClock(kCLOCK_PortA);

    /* PORTA21 (pin 18) is configured as ADC0_A15 */
    PORT_SetPinMux(BOARD_UNINITPINLED2_LED_R_PORT, BOARD_UNINITPINLED2_LED_R_PIN, kPORT_PinDisabledOrAnalog);
}

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_UnInitPinLED3:
- options: {callFromInitBoot: 'false', coreID: cm33, enableClock: 'true'}
- pin_list:
  - {pin_num: '14', peripheral: LPCMP1, signal: 'IN, 0', pin_signal: CMP1_IN0/PTA19/WUU0_P4/LPSPI0_SCK/LPUART0_RTS_b/LPI2C0_SCL/TPM0_CH2/RF_GPO_1}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_UnInitPinLED3
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
void BOARD_UnInitPinLED3(void)
{
    /* Clock Configuration: Peripheral clocks are enabled; module does not stall low power mode entry */
    CLOCK_EnableClock(kCLOCK_PortA);

    /* PORTA19 (pin 14) is configured as CMP1_IN0 */
    PORT_SetPinMux(BOARD_UNINITPINLED3_LED_G_PORT, BOARD_UNINITPINLED3_LED_G_PIN, kPORT_PinDisabledOrAnalog);
}

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_UnInitPinLED4:
- options: {callFromInitBoot: 'false', coreID: cm33, enableClock: 'true'}
- pin_list:
  - {pin_num: '17', peripheral: ADC0, signal: 'A, 14', pin_signal: ADC0_A14/CMP0_IN3/PTA20/LPSPI0_PCS2/LPUART0_TX/EWM0_IN/TPM0_CH1/RF_GPO_2/FLEXIO0_D7}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_UnInitPinLED4
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
void BOARD_UnInitPinLED4(void)
{
    /* Clock Configuration: Peripheral clocks are enabled; module does not stall low power mode entry */
    CLOCK_EnableClock(kCLOCK_PortA);

    /* PORTA20 (pin 17) is configured as ADC0_A14 */
    PORT_SetPinMux(BOARD_UNINITPINLED4_LED_B_PORT, BOARD_UNINITPINLED4_LED_B_PIN, kPORT_PinDisabledOrAnalog);
}

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_InitExtFlashPins:
- options: {callFromInitBoot: 'false', coreID: cm33, enableClock: 'true'}
- pin_list:
  - {pin_num: '48', peripheral: LPSPI1, signal: SCK, pin_signal: ADC0_B12/PTB2/LPSPI1_SCK/LPUART1_TX/TPM1_CH2/FLEXIO0_D28, pull_select: down, pull_enable: disable,
    slew_rate: fast, open_drain: disable, drive_strength: high}
  - {pin_num: '47', peripheral: LPSPI1, signal: IN, pin_signal: ADC0_B11/PTB1/LPSPI1_SIN/TPM1_CH1/FLEXIO0_D27, pull_select: down, pull_enable: disable, slew_rate: fast,
    open_drain: disable, drive_strength: high}
  - {pin_num: '1', peripheral: LPSPI1, signal: OUT, pin_signal: ADC0_B13/PTB3/WUU0_P14/LPSPI1_SOUT/LPUART1_RX/TPM1_CH3/FLEXIO0_D29, pull_select: down, pull_enable: disable,
    slew_rate: fast, open_drain: disable, drive_strength: high}
  - {pin_num: '46', peripheral: GPIOB, signal: 'GPIO, 0', pin_signal: ADC0_B10/PTB0/WUU0_P13/LPSPI1_PCS0/TPM1_CH0/FLEXIO0_D26, identifier: LPSPI1_PCS0, direction: OUTPUT,
    gpio_init_state: 'true', pull_select: up, pull_enable: enable, slew_rate: fast, open_drain: disable, drive_strength: high}
  - {pin_num: '2', peripheral: GPIOB, signal: 'GPIO, 4', pin_signal: PTB4/WUU0_P15/LPSPI1_PCS3/LPUART1_CTS_b/LPI2C1_SDA/I3C0_SDA/TRGMUX0_IN0/FLEXIO0_D30, direction: OUTPUT,
    gpio_init_state: 'true', pull_select: down, pull_enable: disable, pull_value: low, slew_rate: fast, passive_filter: disable, open_drain: disable, drive_strength: low,
    drive_strength_1: normal}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitExtFlashPins
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
void BOARD_InitExtFlashPins(void)
{
    /* Clock Configuration: Peripheral clocks are enabled; module does not stall low power mode entry */
    CLOCK_EnableClock(kCLOCK_GpioB);
    /* Clock Configuration: Peripheral clocks are enabled; module does not stall low power mode entry */
    CLOCK_EnableClock(kCLOCK_PortB);

    gpio_pin_config_t LPSPI1_PCS0_config = {
        .pinDirection = kGPIO_DigitalOutput,
        .outputLogic = 1U
    };
    /* Initialize GPIO functionality on pin PTB0 (pin 46)  */
    GPIO_PinInit(BOARD_INITEXTFLASHPINS_LPSPI1_PCS0_GPIO, BOARD_INITEXTFLASHPINS_LPSPI1_PCS0_PIN, &LPSPI1_PCS0_config);

    gpio_pin_config_t LPSPI1_PCS3_config = {
        .pinDirection = kGPIO_DigitalOutput,
        .outputLogic = 1U
    };
    /* Initialize GPIO functionality on pin PTB4 (pin 2)  */
    GPIO_PinInit(BOARD_INITEXTFLASHPINS_LPSPI1_PCS3_GPIO, BOARD_INITEXTFLASHPINS_LPSPI1_PCS3_PIN, &LPSPI1_PCS3_config);

    const port_pin_config_t LPSPI1_PCS0 = {/* Internal pull-up resistor is enabled */
                                           (uint16_t)kPORT_PullUp,
                                           /* Low internal pull resistor value is selected. */
                                           (uint16_t)kPORT_LowPullResistor,
                                           /* Fast slew rate is configured */
                                           (uint16_t)kPORT_FastSlewRate,
                                           /* Passive input filter is disabled */
                                           (uint16_t)kPORT_PassiveFilterDisable,
                                           /* Open drain output is disabled */
                                           (uint16_t)kPORT_OpenDrainDisable,
                                           /* High drive strength is configured */
                                           (uint16_t)kPORT_HighDriveStrength,
                                           /* Normal drive strength is configured */
                                           (uint16_t)kPORT_NormalDriveStrength,
                                           /* Pin is configured as PTB0 */
                                           (uint16_t)kPORT_MuxAsGpio,
                                           /* Pin Control Register fields [15:0] are not locked */
                                           (uint16_t)kPORT_UnlockRegister};
    /* PORTB0 (pin 46) is configured as PTB0 */
    PORT_SetPinConfig(BOARD_INITEXTFLASHPINS_LPSPI1_PCS0_PORT, BOARD_INITEXTFLASHPINS_LPSPI1_PCS0_PIN, &LPSPI1_PCS0);

    const port_pin_config_t portb1_pin47_config = {/* Internal pull-up/down resistor is disabled */
                                                   (uint16_t)kPORT_PullDisable,
                                                   /* Low internal pull resistor value is selected. */
                                                   (uint16_t)kPORT_LowPullResistor,
                                                   /* Fast slew rate is configured */
                                                   (uint16_t)kPORT_FastSlewRate,
                                                   /* Passive input filter is disabled */
                                                   (uint16_t)kPORT_PassiveFilterDisable,
                                                   /* Open drain output is disabled */
                                                   (uint16_t)kPORT_OpenDrainDisable,
                                                   /* High drive strength is configured */
                                                   (uint16_t)kPORT_HighDriveStrength,
                                                   /* Normal drive strength is configured */
                                                   (uint16_t)kPORT_NormalDriveStrength,
                                                   /* Pin is configured as LPSPI1_SIN */
                                                   (uint16_t)kPORT_MuxAlt2,
                                                   /* Pin Control Register fields [15:0] are not locked */
                                                   (uint16_t)kPORT_UnlockRegister};
    /* PORTB1 (pin 47) is configured as LPSPI1_SIN */
    PORT_SetPinConfig(PORTB, 1U, &portb1_pin47_config);

    const port_pin_config_t portb2_pin48_config = {/* Internal pull-up/down resistor is disabled */
                                                   (uint16_t)kPORT_PullDisable,
                                                   /* Low internal pull resistor value is selected. */
                                                   (uint16_t)kPORT_LowPullResistor,
                                                   /* Fast slew rate is configured */
                                                   (uint16_t)kPORT_FastSlewRate,
                                                   /* Passive input filter is disabled */
                                                   (uint16_t)kPORT_PassiveFilterDisable,
                                                   /* Open drain output is disabled */
                                                   (uint16_t)kPORT_OpenDrainDisable,
                                                   /* High drive strength is configured */
                                                   (uint16_t)kPORT_HighDriveStrength,
                                                   /* Normal drive strength is configured */
                                                   (uint16_t)kPORT_NormalDriveStrength,
                                                   /* Pin is configured as LPSPI1_SCK */
                                                   (uint16_t)kPORT_MuxAlt2,
                                                   /* Pin Control Register fields [15:0] are not locked */
                                                   (uint16_t)kPORT_UnlockRegister};
    /* PORTB2 (pin 48) is configured as LPSPI1_SCK */
    PORT_SetPinConfig(PORTB, 2U, &portb2_pin48_config);

    const port_pin_config_t portb3_pin1_config = {/* Internal pull-up/down resistor is disabled */
                                                  (uint16_t)kPORT_PullDisable,
                                                  /* Low internal pull resistor value is selected. */
                                                  (uint16_t)kPORT_LowPullResistor,
                                                  /* Fast slew rate is configured */
                                                  (uint16_t)kPORT_FastSlewRate,
                                                  /* Passive input filter is disabled */
                                                  (uint16_t)kPORT_PassiveFilterDisable,
                                                  /* Open drain output is disabled */
                                                  (uint16_t)kPORT_OpenDrainDisable,
                                                  /* High drive strength is configured */
                                                  (uint16_t)kPORT_HighDriveStrength,
                                                  /* Normal drive strength is configured */
                                                  (uint16_t)kPORT_NormalDriveStrength,
                                                  /* Pin is configured as LPSPI1_SOUT */
                                                  (uint16_t)kPORT_MuxAlt2,
                                                  /* Pin Control Register fields [15:0] are not locked */
                                                  (uint16_t)kPORT_UnlockRegister};
    /* PORTB3 (pin 1) is configured as LPSPI1_SOUT */
    PORT_SetPinConfig(PORTB, 3U, &portb3_pin1_config);

    const port_pin_config_t LPSPI1_PCS3 = {/* Internal pull-up/down resistor is disabled */
                                           (uint16_t)kPORT_PullDisable,
                                           /* Low internal pull resistor value is selected. */
                                           (uint16_t)kPORT_LowPullResistor,
                                           /* Fast slew rate is configured */
                                           (uint16_t)kPORT_FastSlewRate,
                                           /* Passive input filter is disabled */
                                           (uint16_t)kPORT_PassiveFilterDisable,
                                           /* Open drain output is disabled */
                                           (uint16_t)kPORT_OpenDrainDisable,
                                           /* Low drive strength is configured */
                                           (uint16_t)kPORT_LowDriveStrength,
                                           /* Normal drive strength is configured */
                                           (uint16_t)kPORT_NormalDriveStrength,
                                           /* Pin is configured as PTB4 */
                                           (uint16_t)kPORT_MuxAsGpio,
                                           /* Pin Control Register fields [15:0] are not locked */
                                           (uint16_t)kPORT_UnlockRegister};
    /* PORTB4 (pin 2) is configured as PTB4 */
    PORT_SetPinConfig(BOARD_INITEXTFLASHPINS_LPSPI1_PCS3_PORT, BOARD_INITEXTFLASHPINS_LPSPI1_PCS3_PIN, &LPSPI1_PCS3);
}

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_DeinitExtFlashPins:
- options: {callFromInitBoot: 'false', coreID: cm33, enableClock: 'true'}
- pin_list:
  - {pin_num: '46', peripheral: GPIOB, signal: 'GPIO, 0', pin_signal: ADC0_B10/PTB0/WUU0_P13/LPSPI1_PCS0/TPM1_CH0/FLEXIO0_D26, identifier: LPSPI1_PCS0, direction: OUTPUT,
    gpio_init_state: 'false', pull_select: down, pull_enable: disable, slew_rate: fast, open_drain: disable, drive_strength: low}
  - {pin_num: '47', peripheral: GPIOB, signal: 'GPIO, 1', pin_signal: ADC0_B11/PTB1/LPSPI1_SIN/TPM1_CH1/FLEXIO0_D27, pull_select: down, pull_enable: disable, slew_rate: fast,
    open_drain: disable, drive_strength: low}
  - {pin_num: '48', peripheral: GPIOB, signal: 'GPIO, 2', pin_signal: ADC0_B12/PTB2/LPSPI1_SCK/LPUART1_TX/TPM1_CH2/FLEXIO0_D28, pull_select: down, pull_enable: disable,
    slew_rate: fast, open_drain: disable, drive_strength: low}
  - {pin_num: '1', peripheral: GPIOB, signal: 'GPIO, 3', pin_signal: ADC0_B13/PTB3/WUU0_P14/LPSPI1_SOUT/LPUART1_RX/TPM1_CH3/FLEXIO0_D29, pull_select: down, pull_enable: disable,
    slew_rate: fast, open_drain: disable, drive_strength: low}
  - {pin_num: '2', peripheral: GPIOB, signal: 'GPIO, 4', pin_signal: PTB4/WUU0_P15/LPSPI1_PCS3/LPUART1_CTS_b/LPI2C1_SDA/I3C0_SDA/TRGMUX0_IN0/FLEXIO0_D30, direction: OUTPUT,
    gpio_init_state: 'false', pull_select: down, pull_enable: disable, pull_value: low, slew_rate: fast, passive_filter: disable, open_drain: disable, drive_strength: low,
    drive_strength_1: normal}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_DeinitExtFlashPins
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
void BOARD_DeinitExtFlashPins(void)
{
    /* Clock Configuration: Peripheral clocks are enabled; module does not stall low power mode entry */
    CLOCK_EnableClock(kCLOCK_GpioB);
    /* Clock Configuration: Peripheral clocks are enabled; module does not stall low power mode entry */
    CLOCK_EnableClock(kCLOCK_PortB);

    gpio_pin_config_t LPSPI1_PCS0_config = {
        .pinDirection = kGPIO_DigitalOutput,
        .outputLogic = 0U
    };
    /* Initialize GPIO functionality on pin PTB0 (pin 46)  */
    GPIO_PinInit(BOARD_DEINITEXTFLASHPINS_LPSPI1_PCS0_GPIO, BOARD_DEINITEXTFLASHPINS_LPSPI1_PCS0_PIN, &LPSPI1_PCS0_config);

    gpio_pin_config_t LPSPI1_PCS3_config = {
        .pinDirection = kGPIO_DigitalOutput,
        .outputLogic = 0U
    };
    /* Initialize GPIO functionality on pin PTB4 (pin 2)  */
    GPIO_PinInit(BOARD_DEINITEXTFLASHPINS_LPSPI1_PCS3_GPIO, BOARD_DEINITEXTFLASHPINS_LPSPI1_PCS3_PIN, &LPSPI1_PCS3_config);

    const port_pin_config_t LPSPI1_PCS0 = {/* Internal pull-up/down resistor is disabled */
                                           (uint16_t)kPORT_PullDisable,
                                           /* Low internal pull resistor value is selected. */
                                           (uint16_t)kPORT_LowPullResistor,
                                           /* Fast slew rate is configured */
                                           (uint16_t)kPORT_FastSlewRate,
                                           /* Passive input filter is disabled */
                                           (uint16_t)kPORT_PassiveFilterDisable,
                                           /* Open drain output is disabled */
                                           (uint16_t)kPORT_OpenDrainDisable,
                                           /* Low drive strength is configured */
                                           (uint16_t)kPORT_LowDriveStrength,
                                           /* Normal drive strength is configured */
                                           (uint16_t)kPORT_NormalDriveStrength,
                                           /* Pin is configured as PTB0 */
                                           (uint16_t)kPORT_MuxAsGpio,
                                           /* Pin Control Register fields [15:0] are not locked */
                                           (uint16_t)kPORT_UnlockRegister};
    /* PORTB0 (pin 46) is configured as PTB0 */
    PORT_SetPinConfig(BOARD_DEINITEXTFLASHPINS_LPSPI1_PCS0_PORT, BOARD_DEINITEXTFLASHPINS_LPSPI1_PCS0_PIN, &LPSPI1_PCS0);

    const port_pin_config_t portb1_pin47_config = {/* Internal pull-up/down resistor is disabled */
                                                   (uint16_t)kPORT_PullDisable,
                                                   /* Low internal pull resistor value is selected. */
                                                   (uint16_t)kPORT_LowPullResistor,
                                                   /* Fast slew rate is configured */
                                                   (uint16_t)kPORT_FastSlewRate,
                                                   /* Passive input filter is disabled */
                                                   (uint16_t)kPORT_PassiveFilterDisable,
                                                   /* Open drain output is disabled */
                                                   (uint16_t)kPORT_OpenDrainDisable,
                                                   /* Low drive strength is configured */
                                                   (uint16_t)kPORT_LowDriveStrength,
                                                   /* Normal drive strength is configured */
                                                   (uint16_t)kPORT_NormalDriveStrength,
                                                   /* Pin is configured as PTB1 */
                                                   (uint16_t)kPORT_MuxAsGpio,
                                                   /* Pin Control Register fields [15:0] are not locked */
                                                   (uint16_t)kPORT_UnlockRegister};
    /* PORTB1 (pin 47) is configured as PTB1 */
    PORT_SetPinConfig(PORTB, 1U, &portb1_pin47_config);

    const port_pin_config_t portb2_pin48_config = {/* Internal pull-up/down resistor is disabled */
                                                   (uint16_t)kPORT_PullDisable,
                                                   /* Low internal pull resistor value is selected. */
                                                   (uint16_t)kPORT_LowPullResistor,
                                                   /* Fast slew rate is configured */
                                                   (uint16_t)kPORT_FastSlewRate,
                                                   /* Passive input filter is disabled */
                                                   (uint16_t)kPORT_PassiveFilterDisable,
                                                   /* Open drain output is disabled */
                                                   (uint16_t)kPORT_OpenDrainDisable,
                                                   /* Low drive strength is configured */
                                                   (uint16_t)kPORT_LowDriveStrength,
                                                   /* Normal drive strength is configured */
                                                   (uint16_t)kPORT_NormalDriveStrength,
                                                   /* Pin is configured as PTB2 */
                                                   (uint16_t)kPORT_MuxAsGpio,
                                                   /* Pin Control Register fields [15:0] are not locked */
                                                   (uint16_t)kPORT_UnlockRegister};
    /* PORTB2 (pin 48) is configured as PTB2 */
    PORT_SetPinConfig(PORTB, 2U, &portb2_pin48_config);

    const port_pin_config_t portb3_pin1_config = {/* Internal pull-up/down resistor is disabled */
                                                  (uint16_t)kPORT_PullDisable,
                                                  /* Low internal pull resistor value is selected. */
                                                  (uint16_t)kPORT_LowPullResistor,
                                                  /* Fast slew rate is configured */
                                                  (uint16_t)kPORT_FastSlewRate,
                                                  /* Passive input filter is disabled */
                                                  (uint16_t)kPORT_PassiveFilterDisable,
                                                  /* Open drain output is disabled */
                                                  (uint16_t)kPORT_OpenDrainDisable,
                                                  /* Low drive strength is configured */
                                                  (uint16_t)kPORT_LowDriveStrength,
                                                  /* Normal drive strength is configured */
                                                  (uint16_t)kPORT_NormalDriveStrength,
                                                  /* Pin is configured as PTB3 */
                                                  (uint16_t)kPORT_MuxAsGpio,
                                                  /* Pin Control Register fields [15:0] are not locked */
                                                  (uint16_t)kPORT_UnlockRegister};
    /* PORTB3 (pin 1) is configured as PTB3 */
    PORT_SetPinConfig(PORTB, 3U, &portb3_pin1_config);

    const port_pin_config_t LPSPI1_PCS3 = {/* Internal pull-up/down resistor is disabled */
                                           (uint16_t)kPORT_PullDisable,
                                           /* Low internal pull resistor value is selected. */
                                           (uint16_t)kPORT_LowPullResistor,
                                           /* Fast slew rate is configured */
                                           (uint16_t)kPORT_FastSlewRate,
                                           /* Passive input filter is disabled */
                                           (uint16_t)kPORT_PassiveFilterDisable,
                                           /* Open drain output is disabled */
                                           (uint16_t)kPORT_OpenDrainDisable,
                                           /* Low drive strength is configured */
                                           (uint16_t)kPORT_LowDriveStrength,
                                           /* Normal drive strength is configured */
                                           (uint16_t)kPORT_NormalDriveStrength,
                                           /* Pin is configured as PTB4 */
                                           (uint16_t)kPORT_MuxAsGpio,
                                           /* Pin Control Register fields [15:0] are not locked */
                                           (uint16_t)kPORT_UnlockRegister};
    /* PORTB4 (pin 2) is configured as PTB4 */
    PORT_SetPinConfig(BOARD_DEINITEXTFLASHPINS_LPSPI1_PCS3_PORT, BOARD_DEINITEXTFLASHPINS_LPSPI1_PCS3_PIN, &LPSPI1_PCS3);
}

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_InitPinLPUART0_RTS:
- options: {callFromInitBoot: 'false', coreID: cm33, enableClock: 'true'}
- pin_list:
  - {pin_num: '14', peripheral: LPUART0, signal: RTS, pin_signal: CMP1_IN0/PTA19/WUU0_P4/LPSPI0_SCK/LPUART0_RTS_b/LPI2C0_SCL/TPM0_CH2/RF_GPO_1, identifier: '', eft_interrupt: disable,
    pull_select: down, pull_enable: disable, pull_value: low, slew_rate: fast, passive_filter: disable, open_drain: disable, drive_strength: low, drive_strength_1: normal}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitPinLPUART0_RTS
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
void BOARD_InitPinLPUART0_RTS(void)
{
    /* Clock Configuration: Peripheral clocks are enabled; module does not stall low power mode entry */
    CLOCK_EnableClock(kCLOCK_PortA);

    /* EFT detect interrupts configuration on PORTA */
    PORT_DisableEFTDetectInterrupts(PORTA, 0x080000u);

    const port_pin_config_t porta19_pin14_config = {/* Internal pull-up/down resistor is disabled */
                                                    (uint16_t)kPORT_PullDisable,
                                                    /* Low internal pull resistor value is selected. */
                                                    (uint16_t)kPORT_LowPullResistor,
                                                    /* Fast slew rate is configured */
                                                    (uint16_t)kPORT_FastSlewRate,
                                                    /* Passive input filter is disabled */
                                                    (uint16_t)kPORT_PassiveFilterDisable,
                                                    /* Open drain output is disabled */
                                                    (uint16_t)kPORT_OpenDrainDisable,
                                                    /* Low drive strength is configured */
                                                    (uint16_t)kPORT_LowDriveStrength,
                                                    /* Normal drive strength is configured */
                                                    (uint16_t)kPORT_NormalDriveStrength,
                                                    /* Pin is configured as LPUART0_RTS_b */
                                                    (uint16_t)kPORT_MuxAlt3,
                                                    /* Pin Control Register fields [15:0] are not locked */
                                                    (uint16_t)kPORT_UnlockRegister};
    /* PORTA19 (pin 14) is configured as LPUART0_RTS_b */
    PORT_SetPinConfig(PORTA, 19U, &porta19_pin14_config);
}

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_InitPinLPUART0_CTS:
- options: {callFromInitBoot: 'false', coreID: cm33, enableClock: 'true'}
- pin_list:
  - {pin_num: '13', peripheral: LPUART0, signal: CTS, pin_signal: CMP1_IN1/PTA18/LPSPI0_SOUT/LPUART0_CTS_b/LPI2C0_SDA/TPM0_CH3/RF_GPO_0/LPUART0_RX, eft_interrupt: disable,
    pull_select: down, pull_enable: disable, pull_value: low, slew_rate: fast, passive_filter: disable, open_drain: disable, drive_strength: low, drive_strength_1: normal}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitPinLPUART0_CTS
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
void BOARD_InitPinLPUART0_CTS(void)
{
    /* Clock Configuration: Peripheral clocks are enabled; module does not stall low power mode entry */
    CLOCK_EnableClock(kCLOCK_PortA);

    /* EFT detect interrupts configuration on PORTA */
    PORT_DisableEFTDetectInterrupts(PORTA, 0x040000u);

    const port_pin_config_t porta18_pin13_config = {/* Internal pull-up/down resistor is disabled */
                                                    (uint16_t)kPORT_PullDisable,
                                                    /* Low internal pull resistor value is selected. */
                                                    (uint16_t)kPORT_LowPullResistor,
                                                    /* Fast slew rate is configured */
                                                    (uint16_t)kPORT_FastSlewRate,
                                                    /* Passive input filter is disabled */
                                                    (uint16_t)kPORT_PassiveFilterDisable,
                                                    /* Open drain output is disabled */
                                                    (uint16_t)kPORT_OpenDrainDisable,
                                                    /* Low drive strength is configured */
                                                    (uint16_t)kPORT_LowDriveStrength,
                                                    /* Normal drive strength is configured */
                                                    (uint16_t)kPORT_NormalDriveStrength,
                                                    /* Pin is configured as LPUART0_CTS_b */
                                                    (uint16_t)kPORT_MuxAlt3,
                                                    /* Pin Control Register fields [15:0] are not locked */
                                                    (uint16_t)kPORT_UnlockRegister};
    /* PORTA18 (pin 13) is configured as LPUART0_CTS_b */
    PORT_SetPinConfig(PORTA, 18U, &porta18_pin13_config);
}
/***********************************************************************************************************************
 * EOF
 **********************************************************************************************************************/
