/*
** ###################################################################
**     Processors:          KW45B41Z83AFPA
**                          KW45B41Z83AFTA
**
**     Compilers:           GNU C Compiler
**                          IAR ANSI C/C++ Compiler for ARM
**                          Keil ARM C/C++ Compiler
**                          MCUXpresso Compiler
**
**     Reference manual:    Rev. 6, 05/22/2022
**     Version:             rev. 1.0, 2020-05-12
**     Build:               b220804
**
**     Abstract:
**         CMSIS Peripheral Access Layer for KW45B41Z83
**
**     Copyright 1997-2016 Freescale Semiconductor, Inc.
**     Copyright 2016-2022 NXP
**     All rights reserved.
**
**     SPDX-License-Identifier: BSD-3-Clause
**
**     http:                 www.nxp.com
**     mail:                 support@nxp.com
**
**     Revisions:
**     - rev. 1.0 (2020-05-12)
**         Initial version.
**
** ###################################################################
*/

/*!
 * @file KW45B41Z83.h
 * @version 1.0
 * @date 2020-05-12
 * @brief CMSIS Peripheral Access Layer for KW45B41Z83
 *
 * CMSIS Peripheral Access Layer for KW45B41Z83
 */

#ifndef _KW45B41Z83_H_
#define _KW45B41Z83_H_                           /**< Symbol preventing repeated inclusion */

/** Memory map major version (memory maps with equal major version number are
 * compatible) */
#define MCU_MEM_MAP_VERSION 0x0100U
/** Memory map minor version */
#define MCU_MEM_MAP_VERSION_MINOR 0x0000U


/* ----------------------------------------------------------------------------
   -- Interrupt vector numbers
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup Interrupt_vector_numbers Interrupt vector numbers
 * @{
 */

/** Interrupt Number Definitions */
#define NUMBER_OF_INT_VECTORS 92                 /**< Number of interrupts in the Vector table */

typedef enum IRQn {
  /* Auxiliary constants */
  NotAvail_IRQn                = -128,             /**< Not available device specific interrupt */

  /* Core interrupts */
  NonMaskableInt_IRQn          = -14,              /**< Non Maskable Interrupt */
  HardFault_IRQn               = -13,              /**< Cortex-M33 SV Hard Fault Interrupt */
  MemoryManagement_IRQn        = -12,              /**< Cortex-M33 Memory Management Interrupt */
  BusFault_IRQn                = -11,              /**< Cortex-M33 Bus Fault Interrupt */
  UsageFault_IRQn              = -10,              /**< Cortex-M33 Usage Fault Interrupt */
  SecureFault_IRQn             = -9,               /**< Cortex-M33 Secure Fault Interrupt */
  SVCall_IRQn                  = -5,               /**< Cortex-M33 SV Call Interrupt */
  DebugMonitor_IRQn            = -4,               /**< Cortex-M33 Debug Monitor Interrupt */
  PendSV_IRQn                  = -2,               /**< Cortex-M33 Pend SV Interrupt */
  SysTick_IRQn                 = -1,               /**< Cortex-M33 System Tick Interrupt */

  /* Device specific interrupts */
  CTI_IRQn                     = 0,                /**< Cross Trigger Interface interrupt */
  CMC0_IRQn                    = 1,                /**< Core Mode Controller interrupt */
  DMA0_CH0_IRQn                = 2,                /**< eDMA channel 0 error or transfer complete */
  DMA0_CH1_IRQn                = 3,                /**< eDMA channel 1 error or transfer complete */
  DMA0_CH2_IRQn                = 4,                /**< eDMA channel 2 error or transfer complete */
  DMA0_CH3_IRQn                = 5,                /**< eDMA channel 3 error or transfer complete */
  DMA0_CH4_IRQn                = 6,                /**< eDMA channel 4 error or transfer complete */
  DMA0_CH5_IRQn                = 7,                /**< eDMA channel 5 error or transfer complete */
  DMA0_CH6_IRQn                = 8,                /**< eDMA channel 6 error or transfer complete */
  DMA0_CH7_IRQn                = 9,                /**< eDMA channel 7 error or transfer complete */
  DMA0_CH8_IRQn                = 10,               /**< eDMA channel 8 error or transfer complete */
  DMA0_CH9_IRQn                = 11,               /**< eDMA channel 9 error or transfer complete */
  DMA0_CH10_IRQn               = 12,               /**< eDMA channel 10 error or transfer complete */
  DMA0_CH11_IRQn               = 13,               /**< eDMA channel 11 error or transfer complete */
  DMA0_CH12_IRQn               = 14,               /**< eDMA channel 12 error or transfer complete */
  DMA0_CH13_IRQn               = 15,               /**< eDMA channel 13 error or transfer complete */
  DMA0_CH14_IRQn               = 16,               /**< eDMA channel 14 error or transfer complete */
  DMA0_CH15_IRQn               = 17,               /**< eDMA channel 15 error or transfer complete */
  EWM0_IRQn                    = 18,               /**< External Watchdog Monitor 0 interrupt */
  MCM0_IRQn                    = 19,               /**< Miscellaneous Control Module interrupt */
  MSCM0_IRQn                   = 20,               /**< Miscellaneous System Control Module interrupt */
  SPC0_IRQn                    = 21,               /**< System Power Controller 0 interrupt */
  WUU0_IRQn                    = 22,               /**< Wake-Up Unit 0 interrupt */
  WDOG0_IRQn                   = 23,               /**< Watchdog Timer 0 interrupt */
  WDOG1_IRQn                   = 24,               /**< Watchdog Timer 1 interrupt */
  SCG0_IRQn                    = 25,               /**< System Clock Generator 0 interrupt */
  SFA0_IRQn                    = 26,               /**< Singal Frequency Analyzer 0 interrupt */
  FMU0_IRQn                    = 27,               /**< Flash Memory Unit 0 interrupt */
  ELE_CMD_IRQn                 = 28,               /**< EdgeLock enclave command interface interrupt */
  ELE_SECURE_IRQn              = 29,               /**< EdgeLock enclave interrupt */
  ELE_NONSECURE_IRQn           = 30,               /**< EdgeLock enclave non-secure interrupt */
  TRDC0_IRQn                   = 31,               /**< Trusted Resource Domain Controller 0 interrupt */
  RTC_Alarm_IRQn               = 32,               /**< Real Time Clock 0 alarm interrupt */
  RTC_Seconds_IRQn             = 33,               /**< Real Time Clock 0 seconds interrupt */
  LPTMR0_IRQn                  = 34,               /**< Low-Power Timer0 interrupt */
  LPTMR1_IRQn                  = 35,               /**< Low-Power Timer1 interrupt */
  LPIT0_IRQn                   = 36,               /**< Low-Power Periodic Interrupt Timer 0 interrupt */
  TPM0_IRQn                    = 37,               /**< Timer / PWM Module 0 interrupt */
  TPM1_IRQn                    = 38,               /**< Timer / PWM Module 1 interrupt */
  LPI2C0_IRQn                  = 39,               /**< Low-Power Inter Integrated Circuit 0 interrupt */
  LPI2C1_IRQn                  = 40,               /**< Low-Power Inter Integrated Circuit 1 interrupt */
  I3C0_IRQn                    = 41,               /**< Improved Inter-Integrated Circuit 0 interrupt */
  LPSPI0_IRQn                  = 42,               /**< Low-Power Serial Peripheral Interface 0 interrupt */
  LPSPI1_IRQn                  = 43,               /**< Low-Power Serial Peripheral Interface 1 interrupt */
  LPUART0_IRQn                 = 44,               /**< Low-Power Universal Asynchronous Receiver/Transmitter 0 interrupt */
  LPUART1_IRQn                 = 45,               /**< Low-Power Universal Asynchronous Receiver/Transmitter 1 interrupt */
  FLEXIO0_IRQn                 = 46,               /**< Flexible Input/Output 0 interrupt */
  CAN0_IRQn                    = 47,               /**< Controller Area Network 0 interrupt */
  RF_IMU0_IRQn                 = 48,               /**< Radio IMU interrupt 0 (msg_rdy_imu) */
  RF_IMU1_IRQn                 = 49,               /**< Radio IMU interrupt 1(msg_space_avail_imu) */
  RF_NBU_IRQn                  = 50,               /**< Radio NBU timeout interrupt */
  RF_FMU_IRQn                  = 51,               /**< Radio FMU interrupt */
  RF_WOR_IRQn                  = 52,               /**< Radio WOR RX FAIL interrupt */
  Reserved69_IRQn              = 53,               /**< Reserved interrupt */
  RF_Generic_IRQn              = 54,               /**< Radio Frequency 2.4 GHz - Generic Link Layer interrupt */
  RF_BRIC_IRQn                 = 55,               /**< Radio Frequency 2.4 GHz - BRIC interrupt */
  RF_LANT_SW_IRQn              = 56,               /**< Radio Transceiver - Radio LANT_SW interrupt */
  RFMC_IRQn                    = 57,               /**< RFMC interrupt */
  DSB_IRQn                     = 58,               /**< Data Stream Buffer interrupt */
  GPIOA_INT0_IRQn              = 59,               /**< General Purpose Input/Output A interrupt 0 */
  GPIOA_INT1_IRQn              = 60,               /**< General Purpose Input/Output A interrupt 1 */
  GPIOB_INT0_IRQn              = 61,               /**< General Purpose Input/Output B interrupt 0 */
  GPIOB_INT1_IRQn              = 62,               /**< General Purpose Input/Output B interrupt 1 */
  GPIOC_INT0_IRQn              = 63,               /**< General Purpose Input/Output C interrupt 0 */
  GPIOC_INT1_IRQn              = 64,               /**< General Purpose Input/Output C interrupt 1 */
  GPIOD_INT0_IRQn              = 65,               /**< General Purpose Input/Output D interrupt 0 */
  GPIOD_INT1_IRQn              = 66,               /**< General Purpose Input/Output D interrupt 1 */
  PORTA_IRQn                   = 67,               /**< PortA EFT interrupt */
  PORTB_IRQn                   = 68,               /**< PortB EFT interrupt */
  PORTC_IRQn                   = 69,               /**< PortC EFT interrupt */
  PORTD_IRQn                   = 70,               /**< PortD EFT interrupt */
  ADC0_IRQn                    = 71,               /**< Analog-to-Digital Converter 0 interrupt */
  LPCMP0_IRQn                  = 72,               /**< Low-Power Comparator 0 interrupt */
  LPCMP1_IRQn                  = 73,               /**< Low-Power Comparator 1 interrupt */
  VBAT_IRQn                    = 74,               /**< Smart Power Switch Domain interrupt */
  Reserved91_IRQn              = 75                /**< Reserved interrupt */
} IRQn_Type;

/*!
 * @}
 */ /* end of group Interrupt_vector_numbers */


/* ----------------------------------------------------------------------------
   -- Cortex M33 Core Configuration
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup Cortex_Core_Configuration Cortex M33 Core Configuration
 * @{
 */

#define __MPU_PRESENT                  1         /**< Defines if an MPU is present or not */
#define __NVIC_PRIO_BITS               3         /**< Number of priority bits implemented in the NVIC */
#define __Vendor_SysTickConfig         0         /**< Vendor specific implementation of SysTickConfig is defined */
#define __FPU_PRESENT                  1         /**< Defines if an FPU is present or not */
#define __DSP_PRESENT                  1         /**< Defines if Armv8-M Mainline core supports DSP instructions */
#define __SAUREGION_PRESENT            1         /**< Defines if an SAU is present or not */

#include "core_cm33.h"                 /* Core Peripheral Access Layer */
#include "system_KW45B41Z83.h"         /* Device specific configuration file */

/*!
 * @}
 */ /* end of group Cortex_Core_Configuration */


/* ----------------------------------------------------------------------------
   -- Mapping Information
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup Mapping_Information Mapping Information
 * @{
 */

/** Mapping Information */
/*!
 * @addtogroup edma_request
 * @{
 */

/*******************************************************************************
 * Definitions
*******************************************************************************/

/*!
 * @brief Enumeration for the DMA hardware request
 *
 * Defines the enumeration for the DMA hardware request collections.
 */

typedef enum _dma_request_source
{
    kDmaRequestDisabled             = 0U,          /**< Disabled */
    kDmaRequestWUU0                 = 1U,          /**< WUU0 Wake up event */
    kDmaRequestELE                  = 2U,          /**< EdgeLocK enclave Data request */
    kDmaRequestLPTMR0               = 3U,          /**< LPTMR0 Counter match event */
    kDmaRequestLPTMR1               = 4U,          /**< LPTMR1 Counter match event */
    kDmaRequestTPM0Channel0         = 5U,          /**< TPM0 Channel 0 request */
    kDmaRequestTPM0Channel1         = 6U,          /**< TPM0 Channel 1 request */
    kDmaRequestTPM0Channel2         = 7U,          /**< TPM0 Channel 2 request */
    kDmaRequestTPM0Channel3         = 8U,          /**< TPM0 Channel 3 request */
    kDmaRequestTPM0Channel4         = 9U,          /**< TPM0 Channel 4 request */
    kDmaRequestTPM0Channel5         = 10U,         /**< TPM0 Channel 5 request */
    kDmaRequestTPM0Overflow         = 11U,         /**< TPM0 Counter overflow request */
    kDmaRequestTPM1Channel0         = 12U,         /**< TPM1 Channel 0 request */
    kDmaRequestTPM1Channel1         = 13U,         /**< TPM1 Channel 1 request */
    kDmaRequestTPM1Channel2         = 14U,         /**< TPM1 Channel 2 request */
    kDmaRequestTPM1Channel3         = 15U,         /**< TPM1 Channel 3 request */
    kDmaRequestTPM1Channel4         = 16U,         /**< TPM1 Channel 4 request */
    kDmaRequestTPM1Channel5         = 17U,         /**< TPM1 Channel 5 request */
    kDmaRequestTPM1Overflow         = 18U,         /**< TPM1 Counter overflow request */
    kDmaRequestRFInputData          = 19U,         /**< Radio Bric Input data request */
    kDmaRequestRFOutputData         = 20U,         /**< Radio Bric Output data request */
    kDmaRequestLPI2C0Rx             = 21U,         /**< LPI2C0 Master / Slave receive request */
    kDmaRequestLPI2C0Tx             = 22U,         /**< LPI2C0 Master / Slave transmit request */
    kDmaRequestLPI2C1Rx             = 23U,         /**< LPI2C1 Master / Slave receive request */
    kDmaRequestLPI2C1Tx             = 24U,         /**< LPI2C1 Master / Slave transmit request */
    kDmaRequestI3C0Rx               = 25U,         /**< I3C0 Master / Slave receive request */
    kDmaRequestI3C0Tx               = 26U,         /**< I3C0 Master / Slave transmit request */
    kDmaRequestLPSPI0Rx             = 27U,         /**< LPSPI0 Master / Slave receive request */
    kDmaRequestLPSPI0Tx             = 28U,         /**< LPSPI0 Master / Slave transmit request */
    kDmaRequestLPSPI1Rx             = 29U,         /**< LPSPI1 Master / Slave receive request */
    kDmaRequestLPSPI1Tx             = 30U,         /**< LPSPI1 Master / Slave transmit request */
    kDmaRequestLPUART0Rx            = 31U,         /**< LPUART0 receive request */
    kDmaRequestLPUART0Tx            = 32U,         /**< LPUART0 transmit request */
    kDmaRequestLPUART1Rx            = 33U,         /**< LPUART1 receive request */
    kDmaRequestLPUART1Tx            = 34U,         /**< LPUART1 transmit request */
    kDmaRequestFLEXIO0ShiftReg0     = 35U,         /**< FLEXIO0 Shift register 0 request */
    kDmaRequestFLEXIO0ShiftReg1     = 36U,         /**< FLEXIO0 Shift register 1 request */
    kDmaRequestFLEXIO0ShiftReg2     = 37U,         /**< FLEXIO0 Shift register 2 request */
    kDmaRequestFLEXIO0ShiftReg3     = 38U,         /**< FLEXIO0 Shift register 3 request */
    kDmaRequestFLEXIO0ShiftReg4     = 39U,         /**< FLEXIO0 Shift register 4 request */
    kDmaRequestFLEXIO0ShiftReg5     = 40U,         /**< FLEXIO0 Shift register 5 request */
    kDmaRequestFLEXIO0ShiftReg6     = 41U,         /**< FLEXIO0 Shift register 6 request */
    kDmaRequestFLEXIO0ShiftReg7     = 42U,         /**< FLEXIO0 Shift register 7 request */
    kDmaRequestCAN0                 = 43U,         /**< CAN0 DMA request */
    kDmaRequestGPIOAPinEvent0       = 44U,         /**< GPIOA Pin event request 0 */
    kDmaRequestGPIOAPinEvent1       = 45U,         /**< GPIOA Pin event request 1 */
    kDmaRequestGPIOBPinEvent0       = 46U,         /**< GPIOB Pin event request 0 */
    kDmaRequestGPIOBPinEvent1       = 47U,         /**< GPIOB Pin event request 1 */
    kDmaRequestGPIOCPinEvent0       = 48U,         /**< GPIOC Pin event request 0 */
    kDmaRequestGPIOCPinEvent1       = 49U,         /**< GPIOC Pin event request 1 */
    kDmaRequestGPIODPinEvent0       = 50U,         /**< GPIOD Pin event request 0 */
    kDmaRequestGPIODPinEvent1       = 51U,         /**< GPIOD Pin event request 1 */
    kDmaRequestADCFifoA             = 52U,         /**< ADC FIFO A request */
    kDmaRequestADCFifoB             = 53U,         /**< ADC FIFO B request */
    kDmaRequestCMP0                 = 54U,         /**< CMP0 DMA request */
    kDmaRequestCMP1                 = 55U,         /**< CMP1 DMA request */
} dma_request_source_t;

/* @} */

/*!
 * @addtogroup trdc_mapping
 * @{
 */

/*******************************************************************************
 * Definitions
*******************************************************************************/

/*!
 * @brief Enumeration for the TRDC master mapping
 *
 * Defines the enumeration for the TRDC master resource collections.
 */

typedef enum _trdc_master
{
    kTRDC_MasterCM33                = 0U,          /**< CM33 */
    kTRDC_MasterDMA3                = 1U,          /**< DMA3 */
    kTRDC_MasterDataSteamBuffer     = 2U,          /**< Data stream buffer */
    kTRDC_MasterRadioNBU            = 3U,          /**< Radio NBU */
} trdc_master_t;

/* @} */

/*!
 * @brief Enumeration for the TRDC MBC0 slave mapping
 *
 * Defines the enumeration for the TRDC MBC0 slave resource collections.
 */
typedef enum _trdc_mbc0_slave
{
    kTRDC_SlaveFlash                = 0U,          /**< Flash - 1MB */
    kTRDC_SlaveFlashIFR0            = 1U,          /**< Flash IFR0 - 32 KB */
    kTRDC_SlaveFlashIFR1            = 2U,          /**< Flash IFR1 - 8 KB */
    kTRDC_SlaveROM                  = 3U,          /**< ROM - 96KB */
} trdc_mbc0_slave_t;

/*!
 * @brief Enumeration for the TRDC MBC1 slave mapping
 *
 * Defines the enumeration for the TRDC MBC1 slave resource collections.
 */
typedef enum _trdc_mbc1_slave
{
    kTRDC_SlaveCTCM0_1              = 0U,          /**< CTCM0,1 - 16 KB (with ECC) */
    kTRDC_SlaveSTCM0_1_2            = 1U,          /**< STCM0,1,2 - 16,16,32 KB (with ECC) */
    kTRDC_SlaveSTCM3_4              = 2U,          /**< STCM3,4 - 32,8 KB (with ECC) */
    kTRDC_SlaveSTCM5                = 3U,          /**< STCM5 - 8 KB (with ECC) */
} trdc_mbc1_slave_t;

/*!
 * @brief Enumeration for the TRDC MBC2 slave mapping
 *
 * Defines the enumeration for the TRDC MBC2 slave resource collections.
 */
typedef enum _trdc_mbc2_slave
{
    kTRDC_SlavePBRIDGE2             = 0U,          /**< PBRIDGE2 */
    kTRDC_SlaveRadioPridge          = 1U,          /**< Radio Pridge in Fast Peripheral 1 */
    kTRDC_SlaveNBU                  = 2U,          /**< NBU part in Fast Peripheral 1 */
} trdc_mbc2_slave_t;

/*!
 * @addtogroup trgmux_source
 * @{ */

/*******************************************************************************
 * Definitions
*******************************************************************************/

/*!
 * @brief Enumeration for the TRGMUX source
 *
 * Defines the enumeration for the TRGMUX source collections.
 */
typedef enum _trgmux_source
{
    kTRGMUX_SourceDisabled          = 0U,          /**< Trigger function is disabled */
    kTRGMUX_SourceAlwaysHigh        = 1U,          /**< Trigger function is always high */
    kTRGMUX_SourceTrgmux0Input0     = 2U,          /**< TRGMUX0 Input 0 is selected */
    kTRGMUX_SourceTrgmux0Input1     = 3U,          /**< TRGMUX0 Input 1 is selected */
    kTRGMUX_SourceTrgmux0Input2     = 4U,          /**< TRGMUX0 Input 2 is selected */
    kTRGMUX_SourceTrgmux0Input3     = 5U,          /**< TRGMUX0 Input 3 is selected */
    kTRGMUX_SourceWuu0Trigger       = 6U,          /**< WUU0 Trigger Event is selected */
    kTRGMUX_SourceRtcAlarm          = 7U,          /**< RTC Alarm Event is selected */
    kTRGMUX_SourceRtcSeconds        = 8U,          /**< RTC Seconds Match is selected */
    kTRGMUX_SourceLptmr0Trigger     = 9U,          /**< LPTMR0 Counter Match is selected */
    kTRGMUX_SourceLptmr1Trigger     = 10U,         /**< LPTMR1 Counter Match is selected */
    kTRGMUX_SourceLpit0Channel0     = 11U,         /**< LPIT0 Channel 0 is selected */
    kTRGMUX_SourceLpit0Channel1     = 12U,         /**< LPIT0 Channel 1 is selected */
    kTRGMUX_SourceLpit0Channel2     = 13U,         /**< LPIT0 Channel 2 is selected */
    kTRGMUX_SourceLpit0Channel3     = 14U,         /**< LPIT0 Channel 3 is selected */
    kTRGMUX_SourceTpm0Channel0      = 15U,         /**< TPM0 Channel 0 is selected */
    kTRGMUX_SourceTpm0Channel1      = 16U,         /**< TPM0 Channel 1 is selected */
    kTRGMUX_SourceTpm0Channel2      = 17U,         /**< TPM0 Channel 2 is selected */
    kTRGMUX_SourceTpm0Channel3      = 18U,         /**< TPM0 Channel 3 is selected */
    kTRGMUX_SourceTpm0Channel4      = 19U,         /**< TPM0 Channel 4 is selected */
    kTRGMUX_SourceTpm0Channel5      = 20U,         /**< TPM0 Channel 5 is selected */
    kTRGMUX_SourceTpm0Overflow      = 21U,         /**< TPM0 Overflow is selected */
    kTRGMUX_SourceTpm1Channel0      = 22U,         /**< TPM1 Channel 0 is selected */
    kTRGMUX_SourceTpm1Channel1      = 23U,         /**< TPM1 Channel 1 is selected */
    kTRGMUX_SourceTpm1Channel2      = 24U,         /**< TPM1 Channel 2 is selected */
    kTRGMUX_SourceTpm1Channel3      = 25U,         /**< TPM1 Channel 3 is selected */
    kTRGMUX_SourceTpm1Channel4      = 26U,         /**< TPM1 Channel 4 is selected */
    kTRGMUX_SourceTpm1Channel5      = 27U,         /**< TPM1 Channel 5 is selected */
    kTRGMUX_SourceTpm1Overflow      = 28U,         /**< TPM1 Overflow is selected */
    kTRGMUX_SourceLpi2c0MasterStop  = 29U,         /**< LPI2C0 Master End of Packet is selected */
    kTRGMUX_SourceLpi2c0SlaveStop   = 30U,         /**< LPI2C0 Slave End of Packet is selected */
    kTRGMUX_SourceLpi2c1MasterStop  = 31U,         /**< LPI2C1 Master End of Packet is selected */
    kTRGMUX_SourceLpi2c1SlaveStop   = 32U,         /**< LPI2C1 Slave End of Packet is selected */
    kTRGMUX_SourceLpspi0Frame       = 33U,         /**< LPSPI0 End of Frame is selected */
    kTRGMUX_SourceLpspi0Rx          = 34U,         /**< LPSPI0 Received Data Word is selected */
    kTRGMUX_SourceLpspi1Frame       = 35U,         /**< LPSPI1 End of Frame is selected */
    kTRGMUX_SourceLpspi1Rx          = 36U,         /**< LPSPI1 Received Data Word is selected */
    kTRGMUX_SourceLpuart0RxData     = 37U,         /**< LPUART0 Received Data Word is selected */
    kTRGMUX_SourceLpuart0TxData     = 38U,         /**< LPUART0 Transmitted Data Word is selected */
    kTRGMUX_SourceLpuart0RxIdle     = 39U,         /**< LPUART0 Receive Line Idle is selected */
    kTRGMUX_SourceLpuart1RxData     = 40U,         /**< LPUART1 Received Data Word is selected */
    kTRGMUX_SourceLpuart1TxData     = 41U,         /**< LPUART1 Transmitted Data Word is selected */
    kTRGMUX_SourceLpuart1RxIdle     = 42U,         /**< LPUART1 Receive Line Idle is selected */
    kTRGMUX_SourceFlexIO0Timer0     = 43U,         /**< FlexIO0 Channel 0 is selected */
    kTRGMUX_SourceFlexIO0Timer1     = 44U,         /**< FlexIO0 Channel 1 is selected */
    kTRGMUX_SourceFlexIO0Timer2     = 45U,         /**< FlexIO0 Channel 2 is selected */
    kTRGMUX_SourceFlexIO0Timer3     = 46U,         /**< FlexIO0 Channel 3 is selected */
    kTRGMUX_SourceFlexIO0Timer4     = 47U,         /**< FLexIO0 Channel 4 is selected */
    kTRGMUX_SourceFlexIO0Timer5     = 48U,         /**< FlexIO0 Channel 5 is selected */
    kTRGMUX_SourceFlexIO0Timer6     = 49U,         /**< FlexIO0 Channel 6 is selected */
    kTRGMUX_SourceFlexIO0Timer7     = 50U,         /**< FlexIO0 Channel 7 is selected */
    kTRGMUX_SourceGpioAPinTrigger0  = 51U,         /**< GPIOA Pin event Trigger 0 is selected */
    kTRGMUX_SourceGpioAPinTrigger1  = 52U,         /**< GPIOA Pin event Trigger 1 is selected */
    kTRGMUX_SourceGpioBPinTrigger0  = 53U,         /**< GPIOB Pin event Trigger 0 is selected */
    kTRGMUX_SourceGpioBPinTrigger1  = 54U,         /**< GPIOB Pin event Trigger 1 is selected */
    kTRGMUX_SourceGpioCPinTrigger0  = 55U,         /**< GPIOC Pin event Trigger 0 is selected */
    kTRGMUX_SourceGpioCPinTrigger1  = 56U,         /**< GPIOC Pin event Trigger 1 is selected */
    kTRGMUX_SourceGpioDPinTrigger0  = 57U,         /**< GPIOD Pin event Trigger 0 is selected */
    kTRGMUX_SourceGpioDPinTrigger1  = 58U,         /**< GPIOD Pin event Trigger 1 is selected */
    kTRGMUX_SourceAdcGp0Output0     = 59U,         /**< ADC-GP0 Trigger Output 0 is selected */
    kTRGMUX_SourceAdcGp0Output1     = 60U,         /**< ADC-GP0 Trigger Output 1 is selected */
    kTRGMUX_SourceAdcGp0Output2     = 61U,         /**< ADC-GP0 Trigger Output 2 is selected */
    kTRGMUX_SourceAdcGp0Output3     = 62U,         /**< ADC-GP0 Trigger Output 3 is selected */
    kTRGMUX_SourceCmpGp0Output      = 63U,         /**< CMP-GP0 Comparator Output is selected */
    kTRGMUX_SourceCmpGp1Output      = 64U,         /**< CMP-GP1 Comparator Output is selected */
    kTRGMUX_SourceSpc0DcdcBurst     = 65U,         /**< SPC0 DCDC Burst Trig is selected */
    kTRGMUX_SourceRf2p4gTofTimestamp = 66U,        /**< RF-2.4G TOF TIMESTAMP TRIG is selected */
    kTRGMUX_SourceRf2p4gLantSw      = 67U,         /**< RF-2.4G LANT_SW is selected */
} trgmux_source_t;

/* @} */

/*!
 * @brief Enumeration for the TRGMUX device
 *
 * Defines the enumeration for the TRGMUX device collections.
 */
typedef enum _trgmux_device
{
    kTRGMUX_Trgmux0Output0          = 0U,          /**< TRGMUX_OUT0 device trigger input */
    kTRGMUX_Trgmux0Lpit0            = 1U,          /**< LPIT0 device trigger input */
    kTRGMUX_Trgmux0Tpm0             = 2U,          /**< TPM0 device trigger input */
    kTRGMUX_Trgmux0Tpm1             = 3U,          /**< TPM1 device trigger input */
    kTRGMUX_Trgmux0Lpi2c0           = 4U,          /**< LPI2C0 device trigger input */
    kTRGMUX_Trgmux0Lpi2c1           = 5U,          /**< LPI2C1 device trigger input */
    kTRGMUX_Trgmux0Lpspi0           = 6U,          /**< LPSPI0 device trigger input */
    kTRGMUX_Trgmux0Lpspi1           = 7U,          /**< LPSPI1 device trigger input */
    kTRGMUX_Trgmux0Lpuart0          = 8U,          /**< LPUART0 device trigger input */
    kTRGMUX_Trgmux0Lpuart1          = 9U,          /**< LPUART1 device trigger input */
    kTRGMUX_Trgmux0Flexio0          = 10U,         /**< FlexIO0 device trigger input */
    kTRGMUX_Trgmux0AdcGp0           = 11U,         /**< ADC_GP0 device trigger input */
    kTRGMUX_Trgmux0CmpGp0           = 12U,         /**< CMP_GP0 device trigger input */
    kTRGMUX_Trgmux0CmpGp1           = 13U,         /**< CMP_GP1 device trigger input */
} trgmux_device_t;

/* @} */


/*!
 * @}
 */ /* end of group Mapping_Information */


/* ----------------------------------------------------------------------------
   -- Device Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup Peripheral_access_layer Device Peripheral Access Layer
 * @{
 */


/*
** Start of section using anonymous unions
*/

#if defined(__ARMCC_VERSION)
  #if (__ARMCC_VERSION >= 6010050)
    #pragma clang diagnostic push
  #else
    #pragma push
    #pragma anon_unions
  #endif
#elif defined(__GNUC__)
  /* anonymous unions are enabled by default */
#elif defined(__IAR_SYSTEMS_ICC__)
  #pragma language=extended
#else
  #error Not supported compiler type
#endif

/* ----------------------------------------------------------------------------
   -- ADC Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ADC_Peripheral_Access_Layer ADC Peripheral Access Layer
 * @{
 */

/** ADC - Register Layout Typedef */
typedef struct {
  __I  uint32_t VERID;                             /**< Version ID Register, offset: 0x0 */
  __I  uint32_t PARAM;                             /**< Parameter Register, offset: 0x4 */
       uint8_t RESERVED_0[8];
  __IO uint32_t CTRL;                              /**< ADC Control Register, offset: 0x10 */
  __IO uint32_t STAT;                              /**< ADC Status Register, offset: 0x14 */
  __IO uint32_t IE;                                /**< Interrupt Enable Register, offset: 0x18 */
  __IO uint32_t DE;                                /**< DMA Enable Register, offset: 0x1C */
  __IO uint32_t CFG;                               /**< ADC Configuration Register, offset: 0x20 */
  __IO uint32_t PAUSE;                             /**< ADC Pause Register, offset: 0x24 */
       uint8_t RESERVED_1[12];
  __O  uint32_t SWTRIG;                            /**< Software Trigger Register, offset: 0x34 */
  __IO uint32_t TSTAT;                             /**< Trigger Status Register, offset: 0x38 */
       uint8_t RESERVED_2[4];
  __IO uint32_t OFSTRIM;                           /**< ADC Offset Trim Register, offset: 0x40 */
       uint8_t RESERVED_3[92];
  __IO uint32_t TCTRL[4];                          /**< Trigger Control Register, array offset: 0xA0, array step: 0x4 */
       uint8_t RESERVED_4[48];
  __IO uint32_t FCTRL[2];                          /**< FIFO Control Register, array offset: 0xE0, array step: 0x4 */
       uint8_t RESERVED_5[8];
  __I  uint32_t GCC[2];                            /**< Gain Calibration Control, array offset: 0xF0, array step: 0x4 */
  __IO uint32_t GCR[2];                            /**< Gain Calculation Result, array offset: 0xF8, array step: 0x4 */
  struct {                                         /* offset: 0x100, array step: 0x8 */
    __IO uint32_t CMDL;                              /**< ADC Command Low Buffer Register, array offset: 0x100, array step: 0x8 */
    __IO uint32_t CMDH;                              /**< ADC Command High Buffer Register, array offset: 0x104, array step: 0x8 */
  } CMD[15];
       uint8_t RESERVED_6[136];
  __IO uint32_t CV[15];                            /**< Compare Value Register, array offset: 0x200, array step: 0x4 */
       uint8_t RESERVED_7[196];
  __I  uint32_t RESFIFO[2];                        /**< ADC Data Result FIFO Register, array offset: 0x300, array step: 0x4 */
       uint8_t RESERVED_8[248];
  __IO uint32_t CAL_GAR0;                          /**< Calibration General A-Side Registers, offset: 0x400 */
  __IO uint32_t CAL_GAR1;                          /**< Calibration General A-Side Registers, offset: 0x404 */
  __IO uint32_t CAL_GAR2;                          /**< Calibration General A-Side Registers, offset: 0x408 */
  __IO uint32_t CAL_GAR3;                          /**< Calibration General A-Side Registers, offset: 0x40C */
  __IO uint32_t CAL_GAR4;                          /**< Calibration General A-Side Registers, offset: 0x410 */
  __IO uint32_t CAL_GAR5;                          /**< Calibration General A-Side Registers, offset: 0x414 */
  __IO uint32_t CAL_GAR6;                          /**< Calibration General A-Side Registers, offset: 0x418 */
  __IO uint32_t CAL_GAR7;                          /**< Calibration General A-Side Registers, offset: 0x41C */
  __IO uint32_t CAL_GAR8;                          /**< Calibration General A-Side Registers, offset: 0x420 */
  __IO uint32_t CAL_GAR9;                          /**< Calibration General A-Side Registers, offset: 0x424 */
  __IO uint32_t CAL_GAR10;                         /**< Calibration General A-Side Registers, offset: 0x428 */
  __IO uint32_t CAL_GAR11;                         /**< Calibration General A-Side Registers, offset: 0x42C */
  __IO uint32_t CAL_GAR12;                         /**< Calibration General A-Side Registers, offset: 0x430 */
  __IO uint32_t CAL_GAR13;                         /**< Calibration General A-Side Registers, offset: 0x434 */
  __IO uint32_t CAL_GAR14;                         /**< Calibration General A-Side Registers, offset: 0x438 */
  __IO uint32_t CAL_GAR15;                         /**< Calibration General A-Side Registers, offset: 0x43C */
  __IO uint32_t CAL_GAR16;                         /**< Calibration General A-Side Registers, offset: 0x440 */
  __IO uint32_t CAL_GAR17;                         /**< Calibration General A-Side Registers, offset: 0x444 */
  __IO uint32_t CAL_GAR18;                         /**< Calibration General A-Side Registers, offset: 0x448 */
  __IO uint32_t CAL_GAR19;                         /**< Calibration General A-Side Registers, offset: 0x44C */
  __IO uint32_t CAL_GAR20;                         /**< Calibration General A-Side Registers, offset: 0x450 */
  __IO uint32_t CAL_GAR21;                         /**< Calibration General A-Side Registers, offset: 0x454 */
  __IO uint32_t CAL_GAR22;                         /**< Calibration General A-Side Registers, offset: 0x458 */
  __IO uint32_t CAL_GAR23;                         /**< Calibration General A-Side Registers, offset: 0x45C */
  __IO uint32_t CAL_GAR24;                         /**< Calibration General A-Side Registers, offset: 0x460 */
  __IO uint32_t CAL_GAR25;                         /**< Calibration General A-Side Registers, offset: 0x464 */
  __IO uint32_t CAL_GAR26;                         /**< Calibration General A-Side Registers, offset: 0x468 */
  __IO uint32_t CAL_GAR27;                         /**< Calibration General A-Side Registers, offset: 0x46C */
  __IO uint32_t CAL_GAR28;                         /**< Calibration General A-Side Registers, offset: 0x470 */
  __IO uint32_t CAL_GAR29;                         /**< Calibration General A-Side Registers, offset: 0x474 */
  __IO uint32_t CAL_GAR30;                         /**< Calibration General A-Side Registers, offset: 0x478 */
  __IO uint32_t CAL_GAR31;                         /**< Calibration General A-Side Registers, offset: 0x47C */
  __IO uint32_t CAL_GAR32;                         /**< Calibration General A-Side Registers, offset: 0x480 */
       uint8_t RESERVED_9[124];
  __IO uint32_t CAL_GBR0;                          /**< Calibration General B-Side Registers, offset: 0x500 */
  __IO uint32_t CAL_GBR1;                          /**< Calibration General B-Side Registers, offset: 0x504 */
  __IO uint32_t CAL_GBR2;                          /**< Calibration General B-Side Registers, offset: 0x508 */
  __IO uint32_t CAL_GBR3;                          /**< Calibration General B-Side Registers, offset: 0x50C */
  __IO uint32_t CAL_GBR4;                          /**< Calibration General B-Side Registers, offset: 0x510 */
  __IO uint32_t CAL_GBR5;                          /**< Calibration General B-Side Registers, offset: 0x514 */
  __IO uint32_t CAL_GBR6;                          /**< Calibration General B-Side Registers, offset: 0x518 */
  __IO uint32_t CAL_GBR7;                          /**< Calibration General B-Side Registers, offset: 0x51C */
  __IO uint32_t CAL_GBR8;                          /**< Calibration General B-Side Registers, offset: 0x520 */
  __IO uint32_t CAL_GBR9;                          /**< Calibration General B-Side Registers, offset: 0x524 */
  __IO uint32_t CAL_GBR10;                         /**< Calibration General B-Side Registers, offset: 0x528 */
  __IO uint32_t CAL_GBR11;                         /**< Calibration General B-Side Registers, offset: 0x52C */
  __IO uint32_t CAL_GBR12;                         /**< Calibration General B-Side Registers, offset: 0x530 */
  __IO uint32_t CAL_GBR13;                         /**< Calibration General B-Side Registers, offset: 0x534 */
  __IO uint32_t CAL_GBR14;                         /**< Calibration General B-Side Registers, offset: 0x538 */
  __IO uint32_t CAL_GBR15;                         /**< Calibration General B-Side Registers, offset: 0x53C */
  __IO uint32_t CAL_GBR16;                         /**< Calibration General B-Side Registers, offset: 0x540 */
  __IO uint32_t CAL_GBR17;                         /**< Calibration General B-Side Registers, offset: 0x544 */
  __IO uint32_t CAL_GBR18;                         /**< Calibration General B-Side Registers, offset: 0x548 */
  __IO uint32_t CAL_GBR19;                         /**< Calibration General B-Side Registers, offset: 0x54C */
  __IO uint32_t CAL_GBR20;                         /**< Calibration General B-Side Registers, offset: 0x550 */
  __IO uint32_t CAL_GBR21;                         /**< Calibration General B-Side Registers, offset: 0x554 */
  __IO uint32_t CAL_GBR22;                         /**< Calibration General B-Side Registers, offset: 0x558 */
  __IO uint32_t CAL_GBR23;                         /**< Calibration General B-Side Registers, offset: 0x55C */
  __IO uint32_t CAL_GBR24;                         /**< Calibration General B-Side Registers, offset: 0x560 */
  __IO uint32_t CAL_GBR25;                         /**< Calibration General B-Side Registers, offset: 0x564 */
  __IO uint32_t CAL_GBR26;                         /**< Calibration General B-Side Registers, offset: 0x568 */
  __IO uint32_t CAL_GBR27;                         /**< Calibration General B-Side Registers, offset: 0x56C */
  __IO uint32_t CAL_GBR28;                         /**< Calibration General B-Side Registers, offset: 0x570 */
  __IO uint32_t CAL_GBR29;                         /**< Calibration General B-Side Registers, offset: 0x574 */
  __IO uint32_t CAL_GBR30;                         /**< Calibration General B-Side Registers, offset: 0x578 */
  __IO uint32_t CAL_GBR31;                         /**< Calibration General B-Side Registers, offset: 0x57C */
  __IO uint32_t CAL_GBR32;                         /**< Calibration General B-Side Registers, offset: 0x580 */
} ADC_Type;

/* ----------------------------------------------------------------------------
   -- ADC Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ADC_Register_Masks ADC Register Masks
 * @{
 */

/*! @name VERID - Version ID Register */
/*! @{ */

#define ADC_VERID_RES_MASK                       (0x1U)
#define ADC_VERID_RES_SHIFT                      (0U)
/*! RES - Resolution
 *  0b0..Up to 13-bit differential/12-bit single ended resolution supported.
 *  0b1..Up to 16-bit differential/16-bit single ended resolution supported.
 */
#define ADC_VERID_RES(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_VERID_RES_SHIFT)) & ADC_VERID_RES_MASK)

#define ADC_VERID_DIFFEN_MASK                    (0x2U)
#define ADC_VERID_DIFFEN_SHIFT                   (1U)
/*! DIFFEN - Differential Supported
 *  0b0..Differential operation not supported.
 *  0b1..Differential operation supported. CMDLa[CTYPE] controls fields implemented.
 */
#define ADC_VERID_DIFFEN(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_VERID_DIFFEN_SHIFT)) & ADC_VERID_DIFFEN_MASK)

#define ADC_VERID_MVI_MASK                       (0x8U)
#define ADC_VERID_MVI_SHIFT                      (3U)
/*! MVI - Multi Vref Implemented
 *  0b0..Single voltage reference high (VREFH) input supported.
 *  0b1..Multiple voltage reference high (VREFH) inputs supported.
 */
#define ADC_VERID_MVI(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_VERID_MVI_SHIFT)) & ADC_VERID_MVI_MASK)

#define ADC_VERID_CSW_MASK                       (0x70U)
#define ADC_VERID_CSW_SHIFT                      (4U)
/*! CSW - Channel Scale Width
 *  0b000..Channel scaling not supported.
 *  0b001..Channel scaling supported. 1-bit CSCALE control field.
 *  0b110..Channel scaling supported. 6-bit CSCALE control field.
 */
#define ADC_VERID_CSW(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_VERID_CSW_SHIFT)) & ADC_VERID_CSW_MASK)

#define ADC_VERID_VR1RNGI_MASK                   (0x100U)
#define ADC_VERID_VR1RNGI_SHIFT                  (8U)
/*! VR1RNGI - Voltage Reference 1 Range Control Bit Implemented
 *  0b0..Range control not required. CFG[VREF1RNG] is not implemented.
 *  0b1..Range control required. CFG[VREF1RNG] is implemented.
 */
#define ADC_VERID_VR1RNGI(x)                     (((uint32_t)(((uint32_t)(x)) << ADC_VERID_VR1RNGI_SHIFT)) & ADC_VERID_VR1RNGI_MASK)

#define ADC_VERID_IADCKI_MASK                    (0x200U)
#define ADC_VERID_IADCKI_SHIFT                   (9U)
/*! IADCKI - Internal ADC Clock implemented
 *  0b0..Internal clock source not implemented.
 *  0b1..Internal clock source (and CFG[ADCKEN]) implemented.
 */
#define ADC_VERID_IADCKI(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_VERID_IADCKI_SHIFT)) & ADC_VERID_IADCKI_MASK)

#define ADC_VERID_CALOFSI_MASK                   (0x400U)
#define ADC_VERID_CALOFSI_SHIFT                  (10U)
/*! CALOFSI - Calibration Function Implemented
 *  0b0..Calibration Not Implemented.
 *  0b1..Calibration Implemented.
 */
#define ADC_VERID_CALOFSI(x)                     (((uint32_t)(((uint32_t)(x)) << ADC_VERID_CALOFSI_SHIFT)) & ADC_VERID_CALOFSI_MASK)

#define ADC_VERID_NUM_SEC_MASK                   (0x800U)
#define ADC_VERID_NUM_SEC_SHIFT                  (11U)
/*! NUM_SEC - Number of Single Ended Outputs Supported
 *  0b0..This design supports one single ended conversion at a time.
 *  0b1..This design supports two simultanious single ended conversions.
 */
#define ADC_VERID_NUM_SEC(x)                     (((uint32_t)(((uint32_t)(x)) << ADC_VERID_NUM_SEC_SHIFT)) & ADC_VERID_NUM_SEC_MASK)

#define ADC_VERID_NUM_FIFO_MASK                  (0x7000U)
#define ADC_VERID_NUM_FIFO_SHIFT                 (12U)
/*! NUM_FIFO - Number of FIFOs
 *  0b000..N/A
 *  0b001..This design supports one result FIFO.
 *  0b010..This design supports two result FIFOs.
 *  0b011..This design supports three result FIFOs.
 *  0b100..This design supports four result FIFOs.
 */
#define ADC_VERID_NUM_FIFO(x)                    (((uint32_t)(((uint32_t)(x)) << ADC_VERID_NUM_FIFO_SHIFT)) & ADC_VERID_NUM_FIFO_MASK)

#define ADC_VERID_MINOR_MASK                     (0xFF0000U)
#define ADC_VERID_MINOR_SHIFT                    (16U)
/*! MINOR - Minor Version Number
 */
#define ADC_VERID_MINOR(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_VERID_MINOR_SHIFT)) & ADC_VERID_MINOR_MASK)

#define ADC_VERID_MAJOR_MASK                     (0xFF000000U)
#define ADC_VERID_MAJOR_SHIFT                    (24U)
/*! MAJOR - Major Version Number
 */
#define ADC_VERID_MAJOR(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_VERID_MAJOR_SHIFT)) & ADC_VERID_MAJOR_MASK)
/*! @} */

/*! @name PARAM - Parameter Register */
/*! @{ */

#define ADC_PARAM_TRIG_NUM_MASK                  (0xFFU)
#define ADC_PARAM_TRIG_NUM_SHIFT                 (0U)
/*! TRIG_NUM - Trigger Number
 */
#define ADC_PARAM_TRIG_NUM(x)                    (((uint32_t)(((uint32_t)(x)) << ADC_PARAM_TRIG_NUM_SHIFT)) & ADC_PARAM_TRIG_NUM_MASK)

#define ADC_PARAM_FIFOSIZE_MASK                  (0xFF00U)
#define ADC_PARAM_FIFOSIZE_SHIFT                 (8U)
/*! FIFOSIZE - Result FIFO Depth
 *  0b00000001..Result FIFO depth = 2 dataword.
 *  0b00000100..Result FIFO depth = 4 datawords.
 *  0b00001000..Result FIFO depth = 8 datawords.
 *  0b00010000..Result FIFO depth = 16 datawords.
 *  0b00100000..Result FIFO depth = 32 datawords.
 *  0b01000000..Result FIFO depth = 64 datawords.
 */
#define ADC_PARAM_FIFOSIZE(x)                    (((uint32_t)(((uint32_t)(x)) << ADC_PARAM_FIFOSIZE_SHIFT)) & ADC_PARAM_FIFOSIZE_MASK)

#define ADC_PARAM_CV_NUM_MASK                    (0xFF0000U)
#define ADC_PARAM_CV_NUM_SHIFT                   (16U)
/*! CV_NUM - Compare Value Number
 */
#define ADC_PARAM_CV_NUM(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_PARAM_CV_NUM_SHIFT)) & ADC_PARAM_CV_NUM_MASK)

#define ADC_PARAM_CMD_NUM_MASK                   (0xFF000000U)
#define ADC_PARAM_CMD_NUM_SHIFT                  (24U)
/*! CMD_NUM - Command Buffer Number
 */
#define ADC_PARAM_CMD_NUM(x)                     (((uint32_t)(((uint32_t)(x)) << ADC_PARAM_CMD_NUM_SHIFT)) & ADC_PARAM_CMD_NUM_MASK)
/*! @} */

/*! @name CTRL - ADC Control Register */
/*! @{ */

#define ADC_CTRL_ADCEN_MASK                      (0x1U)
#define ADC_CTRL_ADCEN_SHIFT                     (0U)
/*! ADCEN - ADC Enable
 *  0b0..ADC is disabled.
 *  0b1..ADC is enabled.
 */
#define ADC_CTRL_ADCEN(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_CTRL_ADCEN_SHIFT)) & ADC_CTRL_ADCEN_MASK)

#define ADC_CTRL_RST_MASK                        (0x2U)
#define ADC_CTRL_RST_SHIFT                       (1U)
/*! RST - Software Reset
 *  0b0..ADC logic is not reset.
 *  0b1..ADC logic is reset.
 */
#define ADC_CTRL_RST(x)                          (((uint32_t)(((uint32_t)(x)) << ADC_CTRL_RST_SHIFT)) & ADC_CTRL_RST_MASK)

#define ADC_CTRL_DOZEN_MASK                      (0x4U)
#define ADC_CTRL_DOZEN_SHIFT                     (2U)
/*! DOZEN - Doze Enable
 *  0b0..ADC is enabled in low power mode.
 *  0b1..ADC is disabled in low power mode.
 */
#define ADC_CTRL_DOZEN(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_CTRL_DOZEN_SHIFT)) & ADC_CTRL_DOZEN_MASK)

#define ADC_CTRL_CAL_REQ_MASK                    (0x8U)
#define ADC_CTRL_CAL_REQ_SHIFT                   (3U)
/*! CAL_REQ - Auto-Calibration Request
 *  0b0..No request for hardware calibration has been made.
 *  0b1..A request for hardware calibration has been made
 */
#define ADC_CTRL_CAL_REQ(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_CTRL_CAL_REQ_SHIFT)) & ADC_CTRL_CAL_REQ_MASK)

#define ADC_CTRL_CALOFS_MASK                     (0x10U)
#define ADC_CTRL_CALOFS_SHIFT                    (4U)
/*! CALOFS - Offset Calibration Request
 *  0b0..Calibration function disabled
 *  0b1..Request for offset calibration function
 */
#define ADC_CTRL_CALOFS(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_CTRL_CALOFS_SHIFT)) & ADC_CTRL_CALOFS_MASK)

#define ADC_CTRL_RSTFIFO0_MASK                   (0x100U)
#define ADC_CTRL_RSTFIFO0_SHIFT                  (8U)
/*! RSTFIFO0 - Reset FIFO 0
 *  0b0..No effect.
 *  0b1..FIFO 0 is reset.
 */
#define ADC_CTRL_RSTFIFO0(x)                     (((uint32_t)(((uint32_t)(x)) << ADC_CTRL_RSTFIFO0_SHIFT)) & ADC_CTRL_RSTFIFO0_MASK)

#define ADC_CTRL_RSTFIFO1_MASK                   (0x200U)
#define ADC_CTRL_RSTFIFO1_SHIFT                  (9U)
/*! RSTFIFO1 - Reset FIFO 1
 *  0b0..No effect.
 *  0b1..FIFO 1 is reset.
 */
#define ADC_CTRL_RSTFIFO1(x)                     (((uint32_t)(((uint32_t)(x)) << ADC_CTRL_RSTFIFO1_SHIFT)) & ADC_CTRL_RSTFIFO1_MASK)

#define ADC_CTRL_CAL_AVGS_MASK                   (0x70000U)
#define ADC_CTRL_CAL_AVGS_SHIFT                  (16U)
/*! CAL_AVGS - Auto-Calibration Averages
 *  0b000..Single conversion.
 *  0b001..2 conversions averaged.
 *  0b010..4 conversions averaged.
 *  0b011..8 conversions averaged.
 *  0b100..16 conversions averaged.
 *  0b101..32 conversions averaged.
 *  0b110..64 conversions averaged.
 *  0b111..128 conversions averaged.
 */
#define ADC_CTRL_CAL_AVGS(x)                     (((uint32_t)(((uint32_t)(x)) << ADC_CTRL_CAL_AVGS_SHIFT)) & ADC_CTRL_CAL_AVGS_MASK)
/*! @} */

/*! @name STAT - ADC Status Register */
/*! @{ */

#define ADC_STAT_RDY0_MASK                       (0x1U)
#define ADC_STAT_RDY0_SHIFT                      (0U)
/*! RDY0 - Result FIFO 0 Ready Flag
 *  0b0..Result FIFO 0 data level not above watermark level.
 *  0b1..Result FIFO 0 holding data above watermark level.
 */
#define ADC_STAT_RDY0(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_STAT_RDY0_SHIFT)) & ADC_STAT_RDY0_MASK)

#define ADC_STAT_FOF0_MASK                       (0x2U)
#define ADC_STAT_FOF0_SHIFT                      (1U)
/*! FOF0 - Result FIFO 0 Overflow Flag
 *  0b0..No result FIFO 0 overflow has occurred since the last time the flag was cleared.
 *  0b1..At least one result FIFO 0 overflow has occurred since the last time the flag was cleared.
 */
#define ADC_STAT_FOF0(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_STAT_FOF0_SHIFT)) & ADC_STAT_FOF0_MASK)

#define ADC_STAT_RDY1_MASK                       (0x4U)
#define ADC_STAT_RDY1_SHIFT                      (2U)
/*! RDY1 - Result FIFO1 Ready Flag
 *  0b0..Result FIFO1 data level not above watermark level.
 *  0b1..Result FIFO1 holding data above watermark level.
 */
#define ADC_STAT_RDY1(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_STAT_RDY1_SHIFT)) & ADC_STAT_RDY1_MASK)

#define ADC_STAT_FOF1_MASK                       (0x8U)
#define ADC_STAT_FOF1_SHIFT                      (3U)
/*! FOF1 - Result FIFO1 Overflow Flag
 *  0b0..No result FIFO1 overflow has occurred since the last time the flag was cleared.
 *  0b1..At least one result FIFO1 overflow has occurred since the last time the flag was cleared.
 */
#define ADC_STAT_FOF1(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_STAT_FOF1_SHIFT)) & ADC_STAT_FOF1_MASK)

#define ADC_STAT_TEXC_INT_MASK                   (0x100U)
#define ADC_STAT_TEXC_INT_SHIFT                  (8U)
/*! TEXC_INT - Interrupt Flag For High Priority Trigger Exception
 *  0b0..No trigger exceptions have occurred.
 *  0b1..A trigger exception has occurred and is pending acknowledgement.
 */
#define ADC_STAT_TEXC_INT(x)                     (((uint32_t)(((uint32_t)(x)) << ADC_STAT_TEXC_INT_SHIFT)) & ADC_STAT_TEXC_INT_MASK)

#define ADC_STAT_TCOMP_INT_MASK                  (0x200U)
#define ADC_STAT_TCOMP_INT_SHIFT                 (9U)
/*! TCOMP_INT - Interrupt Flag For Trigger Completion
 *  0b0..Either IE[TCOMP_IE] is set to 0, or no trigger sequences have run to completion.
 *  0b1..Trigger sequence has been completed and all data is stored in the associated FIFO.
 */
#define ADC_STAT_TCOMP_INT(x)                    (((uint32_t)(((uint32_t)(x)) << ADC_STAT_TCOMP_INT_SHIFT)) & ADC_STAT_TCOMP_INT_MASK)

#define ADC_STAT_CAL_RDY_MASK                    (0x400U)
#define ADC_STAT_CAL_RDY_SHIFT                   (10U)
/*! CAL_RDY - Calibration Ready
 *  0b0..Calibration is incomplete or hasn't been ran.
 *  0b1..The ADC is calibrated.
 */
#define ADC_STAT_CAL_RDY(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_STAT_CAL_RDY_SHIFT)) & ADC_STAT_CAL_RDY_MASK)

#define ADC_STAT_ADC_ACTIVE_MASK                 (0x800U)
#define ADC_STAT_ADC_ACTIVE_SHIFT                (11U)
/*! ADC_ACTIVE - ADC Active
 *  0b0..The ADC is IDLE. There are no pending triggers to service and no active commands are being processed.
 *  0b1..The ADC is processing a conversion, running through the power up delay, or servicing a trigger.
 */
#define ADC_STAT_ADC_ACTIVE(x)                   (((uint32_t)(((uint32_t)(x)) << ADC_STAT_ADC_ACTIVE_SHIFT)) & ADC_STAT_ADC_ACTIVE_MASK)

#define ADC_STAT_TRGACT_MASK                     (0x30000U)
#define ADC_STAT_TRGACT_SHIFT                    (16U)
/*! TRGACT - Trigger Active
 *  0b00..Command (sequence) associated with Trigger 0 currently being executed.
 *  0b01..Command (sequence) associated with Trigger 1 currently being executed.
 *  0b10..Command (sequence) associated with Trigger 2 currently being executed.
 *  0b11..Command (sequence) associated with Trigger 3 currently being executed.
 */
#define ADC_STAT_TRGACT(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_STAT_TRGACT_SHIFT)) & ADC_STAT_TRGACT_MASK)

#define ADC_STAT_CMDACT_MASK                     (0xF000000U)
#define ADC_STAT_CMDACT_SHIFT                    (24U)
/*! CMDACT - Command Active
 *  0b0000..No command is currently in progress.
 *  0b0001..Command 1 currently being executed.
 *  0b0010..Command 2 currently being executed.
 *  0b0011-0b1111..Associated command number is currently being executed.
 */
#define ADC_STAT_CMDACT(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_STAT_CMDACT_SHIFT)) & ADC_STAT_CMDACT_MASK)
/*! @} */

/*! @name IE - Interrupt Enable Register */
/*! @{ */

#define ADC_IE_FWMIE0_MASK                       (0x1U)
#define ADC_IE_FWMIE0_SHIFT                      (0U)
/*! FWMIE0 - FIFO 0 Watermark Interrupt Enable
 *  0b0..FIFO 0 watermark interrupts are not enabled.
 *  0b1..FIFO 0 watermark interrupts are enabled.
 */
#define ADC_IE_FWMIE0(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_IE_FWMIE0_SHIFT)) & ADC_IE_FWMIE0_MASK)

#define ADC_IE_FOFIE0_MASK                       (0x2U)
#define ADC_IE_FOFIE0_SHIFT                      (1U)
/*! FOFIE0 - Result FIFO 0 Overflow Interrupt Enable
 *  0b0..FIFO 0 overflow interrupts are not enabled.
 *  0b1..FIFO 0 overflow interrupts are enabled.
 */
#define ADC_IE_FOFIE0(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_IE_FOFIE0_SHIFT)) & ADC_IE_FOFIE0_MASK)

#define ADC_IE_FWMIE1_MASK                       (0x4U)
#define ADC_IE_FWMIE1_SHIFT                      (2U)
/*! FWMIE1 - FIFO1 Watermark Interrupt Enable
 *  0b0..FIFO1 watermark interrupts are not enabled.
 *  0b1..FIFO1 watermark interrupts are enabled.
 */
#define ADC_IE_FWMIE1(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_IE_FWMIE1_SHIFT)) & ADC_IE_FWMIE1_MASK)

#define ADC_IE_FOFIE1_MASK                       (0x8U)
#define ADC_IE_FOFIE1_SHIFT                      (3U)
/*! FOFIE1 - Result FIFO1 Overflow Interrupt Enable
 *  0b0..No result FIFO1 overflow has occurred since the last time the flag was cleared.
 *  0b1..At least one result FIFO1 overflow has occurred since the last time the flag was cleared.
 */
#define ADC_IE_FOFIE1(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_IE_FOFIE1_SHIFT)) & ADC_IE_FOFIE1_MASK)

#define ADC_IE_TEXC_IE_MASK                      (0x100U)
#define ADC_IE_TEXC_IE_SHIFT                     (8U)
/*! TEXC_IE - Trigger Exception Interrupt Enable
 *  0b0..Trigger exception interrupts are disabled.
 *  0b1..Trigger exception interrupts are enabled.
 */
#define ADC_IE_TEXC_IE(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_IE_TEXC_IE_SHIFT)) & ADC_IE_TEXC_IE_MASK)

#define ADC_IE_TCOMP_IE_MASK                     (0xF0000U)
#define ADC_IE_TCOMP_IE_SHIFT                    (16U)
/*! TCOMP_IE - Trigger Completion Interrupt Enable
 *  0b0000..Trigger completion interrupts are disabled.
 *  0b0001..Trigger completion interrupts are enabled for trigger source 0 only.
 *  0b0010..Trigger completion interrupts are enabled for trigger source 1 only.
 *  0b0011-0b1110..Associated trigger completion interrupts are enabled.
 *  0b1111..Trigger completion interrupts are enabled for every trigger source.
 */
#define ADC_IE_TCOMP_IE(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_IE_TCOMP_IE_SHIFT)) & ADC_IE_TCOMP_IE_MASK)
/*! @} */

/*! @name DE - DMA Enable Register */
/*! @{ */

#define ADC_DE_FWMDE0_MASK                       (0x1U)
#define ADC_DE_FWMDE0_SHIFT                      (0U)
/*! FWMDE0 - FIFO 0 Watermark DMA Enable
 *  0b0..DMA request disabled.
 *  0b1..DMA request enabled.
 */
#define ADC_DE_FWMDE0(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_DE_FWMDE0_SHIFT)) & ADC_DE_FWMDE0_MASK)

#define ADC_DE_FWMDE1_MASK                       (0x2U)
#define ADC_DE_FWMDE1_SHIFT                      (1U)
/*! FWMDE1 - FIFO1 Watermark DMA Enable
 *  0b0..DMA request disabled.
 *  0b1..DMA request enabled.
 */
#define ADC_DE_FWMDE1(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_DE_FWMDE1_SHIFT)) & ADC_DE_FWMDE1_MASK)
/*! @} */

/*! @name CFG - ADC Configuration Register */
/*! @{ */

#define ADC_CFG_TPRICTRL_MASK                    (0x3U)
#define ADC_CFG_TPRICTRL_SHIFT                   (0U)
/*! TPRICTRL - ADC trigger priority control
 *  0b00..If a higher priority trigger is detected during command processing, the current conversion is aborted
 *        and the new command specified by the trigger is started.
 *  0b01..If a higher priority trigger is received during command processing, the current command is stopped after
 *        completing the current conversion. If averaging is enabled, the averaging loop will be completed.
 *        However, CMDHa[LOOP] will be ignored and the higher priority trigger will be serviced.
 *  0b10..If a higher priority trigger is received during command processing, the current command will be
 *        completed (averaging, looping, compare) before servicing the higher priority trigger.
 *  0b11..RESERVED
 */
#define ADC_CFG_TPRICTRL(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_CFG_TPRICTRL_SHIFT)) & ADC_CFG_TPRICTRL_MASK)

#define ADC_CFG_PWRSEL_MASK                      (0x30U)
#define ADC_CFG_PWRSEL_SHIFT                     (4U)
/*! PWRSEL - Power Configuration Select
 *  0b0x..Low power setting.
 *  0b1x..High power setting.
 */
#define ADC_CFG_PWRSEL(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_CFG_PWRSEL_SHIFT)) & ADC_CFG_PWRSEL_MASK)

#define ADC_CFG_REFSEL_MASK                      (0xC0U)
#define ADC_CFG_REFSEL_SHIFT                     (6U)
/*! REFSEL - Voltage Reference Selection
 *  0b00..(Default) Option 1 setting.
 *  0b01..Option 2 setting.
 *  0b10..Option 3 setting.
 *  0b11..Reserved
 */
#define ADC_CFG_REFSEL(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_CFG_REFSEL_SHIFT)) & ADC_CFG_REFSEL_MASK)

#define ADC_CFG_TRES_MASK                        (0x100U)
#define ADC_CFG_TRES_SHIFT                       (8U)
/*! TRES - Trigger Resume Enable
 *  0b0..Trigger sequences interrupted by a high priority trigger exception are not automatically resumed or restarted.
 *  0b1..Trigger sequences interrupted by a high priority trigger exception are automatically resumed or restarted.
 */
#define ADC_CFG_TRES(x)                          (((uint32_t)(((uint32_t)(x)) << ADC_CFG_TRES_SHIFT)) & ADC_CFG_TRES_MASK)

#define ADC_CFG_TCMDRES_MASK                     (0x200U)
#define ADC_CFG_TCMDRES_SHIFT                    (9U)
/*! TCMDRES - Trigger Command Resume
 *  0b0..Trigger sequences interrupted by a high priority trigger exception is automatically restarted.
 *  0b1..Trigger sequences interrupted by a high priority trigger exception is resumed from the command executing before the exception.
 */
#define ADC_CFG_TCMDRES(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_CFG_TCMDRES_SHIFT)) & ADC_CFG_TCMDRES_MASK)

#define ADC_CFG_HPT_EXDI_MASK                    (0x400U)
#define ADC_CFG_HPT_EXDI_SHIFT                   (10U)
/*! HPT_EXDI - High Priority Trigger Exception Disable
 *  0b0..High priority trigger exceptions are enabled.
 *  0b1..High priority trigger exceptions are disabled.
 */
#define ADC_CFG_HPT_EXDI(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_CFG_HPT_EXDI_SHIFT)) & ADC_CFG_HPT_EXDI_MASK)

#define ADC_CFG_PUDLY_MASK                       (0xFF0000U)
#define ADC_CFG_PUDLY_SHIFT                      (16U)
/*! PUDLY - Power Up Delay
 */
#define ADC_CFG_PUDLY(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CFG_PUDLY_SHIFT)) & ADC_CFG_PUDLY_MASK)

#define ADC_CFG_PWREN_MASK                       (0x10000000U)
#define ADC_CFG_PWREN_SHIFT                      (28U)
/*! PWREN - ADC Analog Pre-Enable
 *  0b0..ADC analog circuits are only enabled while conversions are active. Performance is affected due to analog startup delays.
 *  0b1..ADC analog circuits are pre-enabled and ready to execute conversions without startup delays (at the cost
 *       of higher DC current consumption). Note that a single power up delay (CFG[PUDLY]) is executed immediately
 *       once PWREN is set, and any detected trigger does not begin ADC operation until the power up delay time has
 *       passed. After this initial delay expires the analog remains pre-enabled and no additional delays are
 *       executed.
 */
#define ADC_CFG_PWREN(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CFG_PWREN_SHIFT)) & ADC_CFG_PWREN_MASK)
/*! @} */

/*! @name PAUSE - ADC Pause Register */
/*! @{ */

#define ADC_PAUSE_PAUSEDLY_MASK                  (0x1FFU)
#define ADC_PAUSE_PAUSEDLY_SHIFT                 (0U)
/*! PAUSEDLY - Pause Delay
 */
#define ADC_PAUSE_PAUSEDLY(x)                    (((uint32_t)(((uint32_t)(x)) << ADC_PAUSE_PAUSEDLY_SHIFT)) & ADC_PAUSE_PAUSEDLY_MASK)

#define ADC_PAUSE_PAUSEEN_MASK                   (0x80000000U)
#define ADC_PAUSE_PAUSEEN_SHIFT                  (31U)
/*! PAUSEEN - PAUSE Option Enable
 *  0b0..Pause operation disabled
 *  0b1..Pause operation enabled
 */
#define ADC_PAUSE_PAUSEEN(x)                     (((uint32_t)(((uint32_t)(x)) << ADC_PAUSE_PAUSEEN_SHIFT)) & ADC_PAUSE_PAUSEEN_MASK)
/*! @} */

/*! @name SWTRIG - Software Trigger Register */
/*! @{ */

#define ADC_SWTRIG_SWT0_MASK                     (0x1U)
#define ADC_SWTRIG_SWT0_SHIFT                    (0U)
/*! SWT0 - Software trigger 0 event
 *  0b0..No trigger 0 event generated.
 *  0b1..Trigger 0 event generated.
 */
#define ADC_SWTRIG_SWT0(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_SWTRIG_SWT0_SHIFT)) & ADC_SWTRIG_SWT0_MASK)

#define ADC_SWTRIG_SWT1_MASK                     (0x2U)
#define ADC_SWTRIG_SWT1_SHIFT                    (1U)
/*! SWT1 - Software trigger 1 event
 *  0b0..No trigger 1 event generated.
 *  0b1..Trigger 1 event generated.
 */
#define ADC_SWTRIG_SWT1(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_SWTRIG_SWT1_SHIFT)) & ADC_SWTRIG_SWT1_MASK)

#define ADC_SWTRIG_SWT2_MASK                     (0x4U)
#define ADC_SWTRIG_SWT2_SHIFT                    (2U)
/*! SWT2 - Software trigger 2 event
 *  0b0..No trigger 2 event generated.
 *  0b1..Trigger 2 event generated.
 */
#define ADC_SWTRIG_SWT2(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_SWTRIG_SWT2_SHIFT)) & ADC_SWTRIG_SWT2_MASK)

#define ADC_SWTRIG_SWT3_MASK                     (0x8U)
#define ADC_SWTRIG_SWT3_SHIFT                    (3U)
/*! SWT3 - Software trigger 3 event
 *  0b0..No trigger 3 event generated.
 *  0b1..Trigger 3 event generated.
 */
#define ADC_SWTRIG_SWT3(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_SWTRIG_SWT3_SHIFT)) & ADC_SWTRIG_SWT3_MASK)
/*! @} */

/*! @name TSTAT - Trigger Status Register */
/*! @{ */

#define ADC_TSTAT_TEXC_NUM_MASK                  (0xFU)
#define ADC_TSTAT_TEXC_NUM_SHIFT                 (0U)
/*! TEXC_NUM - Trigger Exception Number
 *  0b0000..No triggers have been interrupted by a high priority exception. Or CFG[TRES] = 1.
 *  0b0001..Trigger 0 has been interrupted by a high priority exception.
 *  0b0010..Trigger 1 has been interrupted by a high priority exception.
 *  0b0011-0b1110..Associated trigger sequence has interrupted by a high priority exception.
 *  0b1111..Every trigger sequence has been interrupted by a high priority exception.
 */
#define ADC_TSTAT_TEXC_NUM(x)                    (((uint32_t)(((uint32_t)(x)) << ADC_TSTAT_TEXC_NUM_SHIFT)) & ADC_TSTAT_TEXC_NUM_MASK)

#define ADC_TSTAT_TCOMP_FLAG_MASK                (0xF0000U)
#define ADC_TSTAT_TCOMP_FLAG_SHIFT               (16U)
/*! TCOMP_FLAG - Trigger Completion Flag
 *  0b0000..No triggers have been completed. Trigger completion interrupts are disabled.
 *  0b0001..Trigger 0 has been completed and trigger 0 has enabled completion interrupts.
 *  0b0010..Trigger 1 has been completed and trigger 1 has enabled completion interrupts.
 *  0b0011-0b1110..Associated trigger sequence has completed and has enabled completion interrupts.
 *  0b1111..Every trigger sequence has been completed and every trigger has enabled completion interrupts.
 */
#define ADC_TSTAT_TCOMP_FLAG(x)                  (((uint32_t)(((uint32_t)(x)) << ADC_TSTAT_TCOMP_FLAG_SHIFT)) & ADC_TSTAT_TCOMP_FLAG_MASK)
/*! @} */

/*! @name OFSTRIM - ADC Offset Trim Register */
/*! @{ */

#define ADC_OFSTRIM_OFSTRIM_A_MASK               (0x1FU)
#define ADC_OFSTRIM_OFSTRIM_A_SHIFT              (0U)
/*! OFSTRIM_A - Trim for offset
 */
#define ADC_OFSTRIM_OFSTRIM_A(x)                 (((uint32_t)(((uint32_t)(x)) << ADC_OFSTRIM_OFSTRIM_A_SHIFT)) & ADC_OFSTRIM_OFSTRIM_A_MASK)

#define ADC_OFSTRIM_OFSTRIM_B_MASK               (0x1F0000U)
#define ADC_OFSTRIM_OFSTRIM_B_SHIFT              (16U)
/*! OFSTRIM_B - Trim for offset
 */
#define ADC_OFSTRIM_OFSTRIM_B(x)                 (((uint32_t)(((uint32_t)(x)) << ADC_OFSTRIM_OFSTRIM_B_SHIFT)) & ADC_OFSTRIM_OFSTRIM_B_MASK)
/*! @} */

/*! @name TCTRL - Trigger Control Register */
/*! @{ */

#define ADC_TCTRL_HTEN_MASK                      (0x1U)
#define ADC_TCTRL_HTEN_SHIFT                     (0U)
/*! HTEN - Trigger enable
 *  0b0..Hardware trigger source disabled
 *  0b1..Hardware trigger source enabled
 */
#define ADC_TCTRL_HTEN(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_TCTRL_HTEN_SHIFT)) & ADC_TCTRL_HTEN_MASK)

#define ADC_TCTRL_FIFO_SEL_A_MASK                (0x2U)
#define ADC_TCTRL_FIFO_SEL_A_SHIFT               (1U)
/*! FIFO_SEL_A - SAR Result Destination For Channel A
 *  0b0..Result written to FIFO 0
 *  0b1..Result written to FIFO 1
 */
#define ADC_TCTRL_FIFO_SEL_A(x)                  (((uint32_t)(((uint32_t)(x)) << ADC_TCTRL_FIFO_SEL_A_SHIFT)) & ADC_TCTRL_FIFO_SEL_A_MASK)

#define ADC_TCTRL_FIFO_SEL_B_MASK                (0x4U)
#define ADC_TCTRL_FIFO_SEL_B_SHIFT               (2U)
/*! FIFO_SEL_B - SAR Result Destination For Channel B
 *  0b0..Result written to FIFO 0
 *  0b1..Result written to FIFO 1
 */
#define ADC_TCTRL_FIFO_SEL_B(x)                  (((uint32_t)(((uint32_t)(x)) << ADC_TCTRL_FIFO_SEL_B_SHIFT)) & ADC_TCTRL_FIFO_SEL_B_MASK)

#define ADC_TCTRL_TPRI_MASK                      (0x300U)
#define ADC_TCTRL_TPRI_SHIFT                     (8U)
/*! TPRI - Trigger priority setting
 *  0b00..Set to highest priority, Level 1
 *  0b01-0b10..Set to corresponding priority level
 *  0b11..Set to lowest priority, Level 4
 */
#define ADC_TCTRL_TPRI(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_TCTRL_TPRI_SHIFT)) & ADC_TCTRL_TPRI_MASK)

#define ADC_TCTRL_RSYNC_MASK                     (0x8000U)
#define ADC_TCTRL_RSYNC_SHIFT                    (15U)
/*! RSYNC - Trigger Resync
 */
#define ADC_TCTRL_RSYNC(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_TCTRL_RSYNC_SHIFT)) & ADC_TCTRL_RSYNC_MASK)

#define ADC_TCTRL_TDLY_MASK                      (0xF0000U)
#define ADC_TCTRL_TDLY_SHIFT                     (16U)
/*! TDLY - Trigger delay select
 */
#define ADC_TCTRL_TDLY(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_TCTRL_TDLY_SHIFT)) & ADC_TCTRL_TDLY_MASK)

#define ADC_TCTRL_TCMD_MASK                      (0xF000000U)
#define ADC_TCTRL_TCMD_SHIFT                     (24U)
/*! TCMD - Trigger command select
 *  0b0000..Not a valid selection from the command buffer. Trigger event is ignored.
 *  0b0001..CMD1 is executed
 *  0b0010-0b1110..Corresponding CMD is executed
 *  0b1111..CMD15 is executed
 */
#define ADC_TCTRL_TCMD(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_TCTRL_TCMD_SHIFT)) & ADC_TCTRL_TCMD_MASK)
/*! @} */

/* The count of ADC_TCTRL */
#define ADC_TCTRL_COUNT                          (4U)

/*! @name FCTRL - FIFO Control Register */
/*! @{ */

#define ADC_FCTRL_FCOUNT_MASK                    (0x1FU)
#define ADC_FCTRL_FCOUNT_SHIFT                   (0U)
/*! FCOUNT - Result FIFO counter
 */
#define ADC_FCTRL_FCOUNT(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_FCTRL_FCOUNT_SHIFT)) & ADC_FCTRL_FCOUNT_MASK)

#define ADC_FCTRL_FWMARK_MASK                    (0xF0000U)
#define ADC_FCTRL_FWMARK_SHIFT                   (16U)
/*! FWMARK - Watermark level selection
 */
#define ADC_FCTRL_FWMARK(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_FCTRL_FWMARK_SHIFT)) & ADC_FCTRL_FWMARK_MASK)
/*! @} */

/* The count of ADC_FCTRL */
#define ADC_FCTRL_COUNT                          (2U)

/*! @name GCC - Gain Calibration Control */
/*! @{ */

#define ADC_GCC_GAIN_CAL_MASK                    (0xFFFFU)
#define ADC_GCC_GAIN_CAL_SHIFT                   (0U)
/*! GAIN_CAL - Gain Calibration Value
 */
#define ADC_GCC_GAIN_CAL(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_GCC_GAIN_CAL_SHIFT)) & ADC_GCC_GAIN_CAL_MASK)

#define ADC_GCC_RDY_MASK                         (0x1000000U)
#define ADC_GCC_RDY_SHIFT                        (24U)
/*! RDY - Gain Calibration Value Valid
 *  0b0..The GAIN_CAL value is invalid. Run the hardware calibration routine for this value to be set.
 *  0b1..The GAIN_CAL value is valid. GAIN_CAL should be used by software to derive GCRa[GCALR].
 */
#define ADC_GCC_RDY(x)                           (((uint32_t)(((uint32_t)(x)) << ADC_GCC_RDY_SHIFT)) & ADC_GCC_RDY_MASK)
/*! @} */

/* The count of ADC_GCC */
#define ADC_GCC_COUNT                            (2U)

/*! @name GCR - Gain Calculation Result */
/*! @{ */

#define ADC_GCR_GCALR_MASK                       (0xFFFFU)
#define ADC_GCR_GCALR_SHIFT                      (0U)
/*! GCALR - Gain Calculation Result
 */
#define ADC_GCR_GCALR(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_GCR_GCALR_SHIFT)) & ADC_GCR_GCALR_MASK)

#define ADC_GCR_RDY_MASK                         (0x1000000U)
#define ADC_GCR_RDY_SHIFT                        (24U)
/*! RDY - Gain Calculation Ready
 *  0b0..The GCALR value is invalid.
 *  0b1..The GCALR value is valid.
 */
#define ADC_GCR_RDY(x)                           (((uint32_t)(((uint32_t)(x)) << ADC_GCR_RDY_SHIFT)) & ADC_GCR_RDY_MASK)
/*! @} */

/* The count of ADC_GCR */
#define ADC_GCR_COUNT                            (2U)

/*! @name CMDL - ADC Command Low Buffer Register */
/*! @{ */

#define ADC_CMDL_ADCH_MASK                       (0x1FU)
#define ADC_CMDL_ADCH_SHIFT                      (0U)
/*! ADCH - Input channel select
 *  0b00000..Select CH0A or CH0B or CH0A/CH0B pair.
 *  0b00001..Select CH1A or CH1B or CH1A/CH1B pair.
 *  0b00010..Select CH2A or CH2B or CH2A/CH2B pair.
 *  0b00011..Select CH3A or CH3B or CH3A/CH3B pair.
 *  0b00100-0b11101..Select corresponding channel CHnA or CHnB or CHnA/CHnB pair.
 *  0b11110..Select CH30A or CH30B or CH30A/CH30B pair.
 *  0b11111..Select CH31A or CH31B or CH31A/CH31B pair.
 */
#define ADC_CMDL_ADCH(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CMDL_ADCH_SHIFT)) & ADC_CMDL_ADCH_MASK)

#define ADC_CMDL_CTYPE_MASK                      (0x60U)
#define ADC_CMDL_CTYPE_SHIFT                     (5U)
/*! CTYPE - Conversion Type
 *  0b00..Single-Ended Mode. Only A side channel is converted.
 *  0b01..Single-Ended Mode. Only B side channel is converted.
 *  0b10..Differential Mode. A-B.
 *  0b11..Dual-Single-Ended Mode. Both A side and B side channels are converted independently.
 */
#define ADC_CMDL_CTYPE(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_CMDL_CTYPE_SHIFT)) & ADC_CMDL_CTYPE_MASK)

#define ADC_CMDL_MODE_MASK                       (0x80U)
#define ADC_CMDL_MODE_SHIFT                      (7U)
/*! MODE - Select resolution of conversions
 *  0b0..Standard resolution. Single-ended 12-bit conversion; Differential 13-bit conversion with 2's complement output.
 *  0b1..High resolution. Single-ended 16-bit conversion; Differential 16-bit conversion with 2's complement output.
 */
#define ADC_CMDL_MODE(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CMDL_MODE_SHIFT)) & ADC_CMDL_MODE_MASK)
/*! @} */

/* The count of ADC_CMDL */
#define ADC_CMDL_COUNT                           (15U)

/*! @name CMDH - ADC Command High Buffer Register */
/*! @{ */

#define ADC_CMDH_CMPEN_MASK                      (0x3U)
#define ADC_CMDH_CMPEN_SHIFT                     (0U)
/*! CMPEN - Compare Function Enable
 *  0b00..Compare disabled.
 *  0b01..Reserved
 *  0b10..Compare enabled. Store on true.
 *  0b11..Compare enabled. Repeat channel acquisition (sample/convert/compare) until true.
 */
#define ADC_CMDH_CMPEN(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_CMDH_CMPEN_SHIFT)) & ADC_CMDH_CMPEN_MASK)

#define ADC_CMDH_WAIT_TRIG_MASK                  (0x4U)
#define ADC_CMDH_WAIT_TRIG_SHIFT                 (2U)
/*! WAIT_TRIG - Wait for trigger assertion before execution.
 *  0b0..This command will be automatically executed.
 *  0b1..The active trigger must be asserted again before executing this command.
 */
#define ADC_CMDH_WAIT_TRIG(x)                    (((uint32_t)(((uint32_t)(x)) << ADC_CMDH_WAIT_TRIG_SHIFT)) & ADC_CMDH_WAIT_TRIG_MASK)

#define ADC_CMDH_LWI_MASK                        (0x80U)
#define ADC_CMDH_LWI_SHIFT                       (7U)
/*! LWI - Loop with Increment
 *  0b0..Auto channel increment disabled
 *  0b1..Auto channel increment enabled
 */
#define ADC_CMDH_LWI(x)                          (((uint32_t)(((uint32_t)(x)) << ADC_CMDH_LWI_SHIFT)) & ADC_CMDH_LWI_MASK)

#define ADC_CMDH_STS_MASK                        (0x700U)
#define ADC_CMDH_STS_SHIFT                       (8U)
/*! STS - Sample Time Select
 *  0b000..Minimum sample time of 3.5 ADCK cycles.
 *  0b001..3.5 + 21 ADCK cycles; 5.5 ADCK cycles total sample time.
 *  0b010..3.5 + 22 ADCK cycles; 7.5 ADCK cycles total sample time.
 *  0b011..3.5 + 23 ADCK cycles; 11.5 ADCK cycles total sample time.
 *  0b100..3.5 + 24 ADCK cycles; 19.5 ADCK cycles total sample time.
 *  0b101..3.5 + 25 ADCK cycles; 35.5 ADCK cycles total sample time.
 *  0b110..3.5 + 26 ADCK cycles; 67.5 ADCK cycles total sample time.
 *  0b111..3.5 + 27 ADCK cycles; 131.5 ADCK cycles total sample time.
 */
#define ADC_CMDH_STS(x)                          (((uint32_t)(((uint32_t)(x)) << ADC_CMDH_STS_SHIFT)) & ADC_CMDH_STS_MASK)

#define ADC_CMDH_AVGS_MASK                       (0x7000U)
#define ADC_CMDH_AVGS_SHIFT                      (12U)
/*! AVGS - Hardware Average Select
 *  0b000..Single conversion.
 *  0b001..2 conversions averaged.
 *  0b010..4 conversions averaged.
 *  0b011..8 conversions averaged.
 *  0b100..16 conversions averaged.
 *  0b101..32 conversions averaged.
 *  0b110..64 conversions averaged.
 *  0b111..128 conversions averaged.
 */
#define ADC_CMDH_AVGS(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CMDH_AVGS_SHIFT)) & ADC_CMDH_AVGS_MASK)

#define ADC_CMDH_LOOP_MASK                       (0xF0000U)
#define ADC_CMDH_LOOP_SHIFT                      (16U)
/*! LOOP - Loop Count Select
 *  0b0000..Looping not enabled. Command executes 1 time.
 *  0b0001..Loop 1 time. Command executes 2 times.
 *  0b0010..Loop 2 times. Command executes 3 times.
 *  0b0011-0b1110..Loop corresponding number of times. Command executes LOOP+1 times.
 *  0b1111..Loop 15 times. Command executes 16 times.
 */
#define ADC_CMDH_LOOP(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CMDH_LOOP_SHIFT)) & ADC_CMDH_LOOP_MASK)

#define ADC_CMDH_NEXT_MASK                       (0xF000000U)
#define ADC_CMDH_NEXT_SHIFT                      (24U)
/*! NEXT - Next Command Select
 *  0b0000..No next command defined. Terminate conversions at completion of current command. If lower priority
 *          trigger pending, begin command associated with lower priority trigger.
 *  0b0001..Select CMD1 command buffer register as next command.
 *  0b0010-0b1110..Select corresponding CMD command buffer register as next command
 *  0b1111..Select CMD15 command buffer register as next command.
 */
#define ADC_CMDH_NEXT(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CMDH_NEXT_SHIFT)) & ADC_CMDH_NEXT_MASK)
/*! @} */

/* The count of ADC_CMDH */
#define ADC_CMDH_COUNT                           (15U)

/*! @name CV - Compare Value Register */
/*! @{ */

#define ADC_CV_CVL_MASK                          (0xFFFFU)
#define ADC_CV_CVL_SHIFT                         (0U)
/*! CVL - Compare Value Low.
 */
#define ADC_CV_CVL(x)                            (((uint32_t)(((uint32_t)(x)) << ADC_CV_CVL_SHIFT)) & ADC_CV_CVL_MASK)

#define ADC_CV_CVH_MASK                          (0xFFFF0000U)
#define ADC_CV_CVH_SHIFT                         (16U)
/*! CVH - Compare Value High.
 */
#define ADC_CV_CVH(x)                            (((uint32_t)(((uint32_t)(x)) << ADC_CV_CVH_SHIFT)) & ADC_CV_CVH_MASK)
/*! @} */

/* The count of ADC_CV */
#define ADC_CV_COUNT                             (15U)

/*! @name RESFIFO - ADC Data Result FIFO Register */
/*! @{ */

#define ADC_RESFIFO_D_MASK                       (0xFFFFU)
#define ADC_RESFIFO_D_SHIFT                      (0U)
/*! D - Data result
 */
#define ADC_RESFIFO_D(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_RESFIFO_D_SHIFT)) & ADC_RESFIFO_D_MASK)

#define ADC_RESFIFO_TSRC_MASK                    (0x30000U)
#define ADC_RESFIFO_TSRC_SHIFT                   (16U)
/*! TSRC - Trigger Source
 *  0b00..Trigger source 0 initiated this conversion.
 *  0b01..Trigger source 1 initiated this conversion.
 *  0b10-0b10..Corresponding trigger source initiated this conversion.
 *  0b11..Trigger source 3 initiated this conversion.
 */
#define ADC_RESFIFO_TSRC(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_RESFIFO_TSRC_SHIFT)) & ADC_RESFIFO_TSRC_MASK)

#define ADC_RESFIFO_LOOPCNT_MASK                 (0xF00000U)
#define ADC_RESFIFO_LOOPCNT_SHIFT                (20U)
/*! LOOPCNT - Loop count value
 *  0b0000..Result is from initial conversion in command.
 *  0b0001..Result is from second conversion in command.
 *  0b0010-0b1110..Result is from LOOPCNT+1 conversion in command.
 *  0b1111..Result is from 16th conversion in command.
 */
#define ADC_RESFIFO_LOOPCNT(x)                   (((uint32_t)(((uint32_t)(x)) << ADC_RESFIFO_LOOPCNT_SHIFT)) & ADC_RESFIFO_LOOPCNT_MASK)

#define ADC_RESFIFO_CMDSRC_MASK                  (0xF000000U)
#define ADC_RESFIFO_CMDSRC_SHIFT                 (24U)
/*! CMDSRC - Command Buffer Source
 *  0b0000..Not a valid value CMDSRC value for a dataword in RESFIFO. 0x0 is only found in initial FIFO state
 *          prior to an ADC conversion result dataword being stored to a RESFIFO buffer.
 *  0b0001..CMD1 buffer used as control settings for this conversion.
 *  0b0010-0b1110..Corresponding command buffer used as control settings for this conversion.
 *  0b1111..CMD15 buffer used as control settings for this conversion.
 */
#define ADC_RESFIFO_CMDSRC(x)                    (((uint32_t)(((uint32_t)(x)) << ADC_RESFIFO_CMDSRC_SHIFT)) & ADC_RESFIFO_CMDSRC_MASK)

#define ADC_RESFIFO_VALID_MASK                   (0x80000000U)
#define ADC_RESFIFO_VALID_SHIFT                  (31U)
/*! VALID - FIFO entry is valid
 *  0b0..FIFO is empty. Discard any read from RESFIFO.
 *  0b1..FIFO record read from RESFIFO is valid.
 */
#define ADC_RESFIFO_VALID(x)                     (((uint32_t)(((uint32_t)(x)) << ADC_RESFIFO_VALID_SHIFT)) & ADC_RESFIFO_VALID_MASK)
/*! @} */

/* The count of ADC_RESFIFO */
#define ADC_RESFIFO_COUNT                        (2U)

/*! @name CAL_GAR0 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR0_CAL_GAR_VAL_MASK            (0x7FFU)
#define ADC_CAL_GAR0_CAL_GAR_VAL_SHIFT           (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element
 */
#define ADC_CAL_GAR0_CAL_GAR_VAL(x)              (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR0_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR0_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR1 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR1_CAL_GAR_VAL_MASK            (0xFFFU)
#define ADC_CAL_GAR1_CAL_GAR_VAL_SHIFT           (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element
 */
#define ADC_CAL_GAR1_CAL_GAR_VAL(x)              (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR1_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR1_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR2 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR2_CAL_GAR_VAL_MASK            (0x1FFFU)
#define ADC_CAL_GAR2_CAL_GAR_VAL_SHIFT           (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element
 */
#define ADC_CAL_GAR2_CAL_GAR_VAL(x)              (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR2_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR2_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR3 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR3_CAL_GAR_VAL_MASK            (0x1FFFU)
#define ADC_CAL_GAR3_CAL_GAR_VAL_SHIFT           (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element
 */
#define ADC_CAL_GAR3_CAL_GAR_VAL(x)              (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR3_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR3_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR4 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR4_CAL_GAR_VAL_MASK            (0x3FFFU)
#define ADC_CAL_GAR4_CAL_GAR_VAL_SHIFT           (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element
 */
#define ADC_CAL_GAR4_CAL_GAR_VAL(x)              (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR4_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR4_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR5 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR5_CAL_GAR_VAL_MASK            (0x3FFFU)
#define ADC_CAL_GAR5_CAL_GAR_VAL_SHIFT           (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element
 */
#define ADC_CAL_GAR5_CAL_GAR_VAL(x)              (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR5_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR5_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR6 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR6_CAL_GAR_VAL_MASK            (0x3FFFU)
#define ADC_CAL_GAR6_CAL_GAR_VAL_SHIFT           (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element
 */
#define ADC_CAL_GAR6_CAL_GAR_VAL(x)              (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR6_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR6_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR7 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR7_CAL_GAR_VAL_MASK            (0x3FFFU)
#define ADC_CAL_GAR7_CAL_GAR_VAL_SHIFT           (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element
 */
#define ADC_CAL_GAR7_CAL_GAR_VAL(x)              (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR7_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR7_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR8 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR8_CAL_GAR_VAL_MASK            (0x7FFFU)
#define ADC_CAL_GAR8_CAL_GAR_VAL_SHIFT           (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element
 */
#define ADC_CAL_GAR8_CAL_GAR_VAL(x)              (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR8_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR8_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR9 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR9_CAL_GAR_VAL_MASK            (0x7FFFU)
#define ADC_CAL_GAR9_CAL_GAR_VAL_SHIFT           (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element
 */
#define ADC_CAL_GAR9_CAL_GAR_VAL(x)              (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR9_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR9_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR10 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR10_CAL_GAR_VAL_MASK           (0x7FFFU)
#define ADC_CAL_GAR10_CAL_GAR_VAL_SHIFT          (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element
 */
#define ADC_CAL_GAR10_CAL_GAR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR10_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR10_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR11 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR11_CAL_GAR_VAL_MASK           (0x7FFFU)
#define ADC_CAL_GAR11_CAL_GAR_VAL_SHIFT          (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element
 */
#define ADC_CAL_GAR11_CAL_GAR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR11_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR11_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR12 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR12_CAL_GAR_VAL_MASK           (0x7FFFU)
#define ADC_CAL_GAR12_CAL_GAR_VAL_SHIFT          (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element
 */
#define ADC_CAL_GAR12_CAL_GAR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR12_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR12_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR13 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR13_CAL_GAR_VAL_MASK           (0x7FFFU)
#define ADC_CAL_GAR13_CAL_GAR_VAL_SHIFT          (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element
 */
#define ADC_CAL_GAR13_CAL_GAR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR13_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR13_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR14 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR14_CAL_GAR_VAL_MASK           (0x7FFFU)
#define ADC_CAL_GAR14_CAL_GAR_VAL_SHIFT          (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element
 */
#define ADC_CAL_GAR14_CAL_GAR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR14_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR14_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR15 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR15_CAL_GAR_VAL_MASK           (0x7FFFU)
#define ADC_CAL_GAR15_CAL_GAR_VAL_SHIFT          (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element
 */
#define ADC_CAL_GAR15_CAL_GAR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR15_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR15_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR16 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR16_CAL_GAR_VAL_MASK           (0xFFFFU)
#define ADC_CAL_GAR16_CAL_GAR_VAL_SHIFT          (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element
 */
#define ADC_CAL_GAR16_CAL_GAR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR16_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR16_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR17 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR17_CAL_GAR_VAL_MASK           (0xFFFFU)
#define ADC_CAL_GAR17_CAL_GAR_VAL_SHIFT          (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element
 */
#define ADC_CAL_GAR17_CAL_GAR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR17_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR17_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR18 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR18_CAL_GAR_VAL_MASK           (0xFFFFU)
#define ADC_CAL_GAR18_CAL_GAR_VAL_SHIFT          (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element
 */
#define ADC_CAL_GAR18_CAL_GAR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR18_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR18_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR19 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR19_CAL_GAR_VAL_MASK           (0xFFFFU)
#define ADC_CAL_GAR19_CAL_GAR_VAL_SHIFT          (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element
 */
#define ADC_CAL_GAR19_CAL_GAR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR19_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR19_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR20 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR20_CAL_GAR_VAL_MASK           (0xFFFFU)
#define ADC_CAL_GAR20_CAL_GAR_VAL_SHIFT          (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element
 */
#define ADC_CAL_GAR20_CAL_GAR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR20_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR20_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR21 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR21_CAL_GAR_VAL_MASK           (0xFFFFU)
#define ADC_CAL_GAR21_CAL_GAR_VAL_SHIFT          (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element
 */
#define ADC_CAL_GAR21_CAL_GAR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR21_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR21_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR22 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR22_CAL_GAR_VAL_MASK           (0xFFFFU)
#define ADC_CAL_GAR22_CAL_GAR_VAL_SHIFT          (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element
 */
#define ADC_CAL_GAR22_CAL_GAR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR22_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR22_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR23 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR23_CAL_GAR_VAL_MASK           (0xFFFFU)
#define ADC_CAL_GAR23_CAL_GAR_VAL_SHIFT          (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element
 */
#define ADC_CAL_GAR23_CAL_GAR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR23_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR23_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR24 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR24_CAL_GAR_VAL_MASK           (0xFFFFU)
#define ADC_CAL_GAR24_CAL_GAR_VAL_SHIFT          (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element
 */
#define ADC_CAL_GAR24_CAL_GAR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR24_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR24_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR25 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR25_CAL_GAR_VAL_MASK           (0xFFFFU)
#define ADC_CAL_GAR25_CAL_GAR_VAL_SHIFT          (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element
 */
#define ADC_CAL_GAR25_CAL_GAR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR25_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR25_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR26 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR26_CAL_GAR_VAL_MASK           (0xFFFFU)
#define ADC_CAL_GAR26_CAL_GAR_VAL_SHIFT          (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element
 */
#define ADC_CAL_GAR26_CAL_GAR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR26_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR26_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR27 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR27_CAL_GAR_VAL_MASK           (0xFFFFU)
#define ADC_CAL_GAR27_CAL_GAR_VAL_SHIFT          (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element
 */
#define ADC_CAL_GAR27_CAL_GAR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR27_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR27_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR28 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR28_CAL_GAR_VAL_MASK           (0xFFFFU)
#define ADC_CAL_GAR28_CAL_GAR_VAL_SHIFT          (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element
 */
#define ADC_CAL_GAR28_CAL_GAR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR28_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR28_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR29 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR29_CAL_GAR_VAL_MASK           (0xFFFFU)
#define ADC_CAL_GAR29_CAL_GAR_VAL_SHIFT          (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element
 */
#define ADC_CAL_GAR29_CAL_GAR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR29_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR29_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR30 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR30_CAL_GAR_VAL_MASK           (0xFFFFU)
#define ADC_CAL_GAR30_CAL_GAR_VAL_SHIFT          (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element
 */
#define ADC_CAL_GAR30_CAL_GAR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR30_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR30_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR31 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR31_CAL_GAR_VAL_MASK           (0xFFFFU)
#define ADC_CAL_GAR31_CAL_GAR_VAL_SHIFT          (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element
 */
#define ADC_CAL_GAR31_CAL_GAR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR31_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR31_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GAR32 - Calibration General A-Side Registers */
/*! @{ */

#define ADC_CAL_GAR32_CAL_GAR_VAL_MASK           (0x7FFU)
#define ADC_CAL_GAR32_CAL_GAR_VAL_SHIFT          (0U)
/*! CAL_GAR_VAL - Calibration General A Side Register Element
 */
#define ADC_CAL_GAR32_CAL_GAR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GAR32_CAL_GAR_VAL_SHIFT)) & ADC_CAL_GAR32_CAL_GAR_VAL_MASK)
/*! @} */

/*! @name CAL_GBR0 - Calibration General B-Side Registers */
/*! @{ */

#define ADC_CAL_GBR0_CAL_GBR_VAL_MASK            (0x7FFU)
#define ADC_CAL_GBR0_CAL_GBR_VAL_SHIFT           (0U)
/*! CAL_GBR_VAL - Calibration General B Side Register Element
 */
#define ADC_CAL_GBR0_CAL_GBR_VAL(x)              (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GBR0_CAL_GBR_VAL_SHIFT)) & ADC_CAL_GBR0_CAL_GBR_VAL_MASK)
/*! @} */

/*! @name CAL_GBR1 - Calibration General B-Side Registers */
/*! @{ */

#define ADC_CAL_GBR1_CAL_GBR_VAL_MASK            (0xFFFU)
#define ADC_CAL_GBR1_CAL_GBR_VAL_SHIFT           (0U)
/*! CAL_GBR_VAL - Calibration General B Side Register Element
 */
#define ADC_CAL_GBR1_CAL_GBR_VAL(x)              (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GBR1_CAL_GBR_VAL_SHIFT)) & ADC_CAL_GBR1_CAL_GBR_VAL_MASK)
/*! @} */

/*! @name CAL_GBR2 - Calibration General B-Side Registers */
/*! @{ */

#define ADC_CAL_GBR2_CAL_GBR_VAL_MASK            (0x1FFFU)
#define ADC_CAL_GBR2_CAL_GBR_VAL_SHIFT           (0U)
/*! CAL_GBR_VAL - Calibration General B Side Register Element
 */
#define ADC_CAL_GBR2_CAL_GBR_VAL(x)              (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GBR2_CAL_GBR_VAL_SHIFT)) & ADC_CAL_GBR2_CAL_GBR_VAL_MASK)
/*! @} */

/*! @name CAL_GBR3 - Calibration General B-Side Registers */
/*! @{ */

#define ADC_CAL_GBR3_CAL_GBR_VAL_MASK            (0x1FFFU)
#define ADC_CAL_GBR3_CAL_GBR_VAL_SHIFT           (0U)
/*! CAL_GBR_VAL - Calibration General B Side Register Element
 */
#define ADC_CAL_GBR3_CAL_GBR_VAL(x)              (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GBR3_CAL_GBR_VAL_SHIFT)) & ADC_CAL_GBR3_CAL_GBR_VAL_MASK)
/*! @} */

/*! @name CAL_GBR4 - Calibration General B-Side Registers */
/*! @{ */

#define ADC_CAL_GBR4_CAL_GBR_VAL_MASK            (0x3FFFU)
#define ADC_CAL_GBR4_CAL_GBR_VAL_SHIFT           (0U)
/*! CAL_GBR_VAL - Calibration General B Side Register Element
 */
#define ADC_CAL_GBR4_CAL_GBR_VAL(x)              (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GBR4_CAL_GBR_VAL_SHIFT)) & ADC_CAL_GBR4_CAL_GBR_VAL_MASK)
/*! @} */

/*! @name CAL_GBR5 - Calibration General B-Side Registers */
/*! @{ */

#define ADC_CAL_GBR5_CAL_GBR_VAL_MASK            (0x3FFFU)
#define ADC_CAL_GBR5_CAL_GBR_VAL_SHIFT           (0U)
/*! CAL_GBR_VAL - Calibration General B Side Register Element
 */
#define ADC_CAL_GBR5_CAL_GBR_VAL(x)              (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GBR5_CAL_GBR_VAL_SHIFT)) & ADC_CAL_GBR5_CAL_GBR_VAL_MASK)
/*! @} */

/*! @name CAL_GBR6 - Calibration General B-Side Registers */
/*! @{ */

#define ADC_CAL_GBR6_CAL_GBR_VAL_MASK            (0x3FFFU)
#define ADC_CAL_GBR6_CAL_GBR_VAL_SHIFT           (0U)
/*! CAL_GBR_VAL - Calibration General B Side Register Element
 */
#define ADC_CAL_GBR6_CAL_GBR_VAL(x)              (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GBR6_CAL_GBR_VAL_SHIFT)) & ADC_CAL_GBR6_CAL_GBR_VAL_MASK)
/*! @} */

/*! @name CAL_GBR7 - Calibration General B-Side Registers */
/*! @{ */

#define ADC_CAL_GBR7_CAL_GBR_VAL_MASK            (0x3FFFU)
#define ADC_CAL_GBR7_CAL_GBR_VAL_SHIFT           (0U)
/*! CAL_GBR_VAL - Calibration General B Side Register Element
 */
#define ADC_CAL_GBR7_CAL_GBR_VAL(x)              (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GBR7_CAL_GBR_VAL_SHIFT)) & ADC_CAL_GBR7_CAL_GBR_VAL_MASK)
/*! @} */

/*! @name CAL_GBR8 - Calibration General B-Side Registers */
/*! @{ */

#define ADC_CAL_GBR8_CAL_GBR_VAL_MASK            (0x7FFFU)
#define ADC_CAL_GBR8_CAL_GBR_VAL_SHIFT           (0U)
/*! CAL_GBR_VAL - Calibration General B Side Register Element
 */
#define ADC_CAL_GBR8_CAL_GBR_VAL(x)              (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GBR8_CAL_GBR_VAL_SHIFT)) & ADC_CAL_GBR8_CAL_GBR_VAL_MASK)
/*! @} */

/*! @name CAL_GBR9 - Calibration General B-Side Registers */
/*! @{ */

#define ADC_CAL_GBR9_CAL_GBR_VAL_MASK            (0x7FFFU)
#define ADC_CAL_GBR9_CAL_GBR_VAL_SHIFT           (0U)
/*! CAL_GBR_VAL - Calibration General B Side Register Element
 */
#define ADC_CAL_GBR9_CAL_GBR_VAL(x)              (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GBR9_CAL_GBR_VAL_SHIFT)) & ADC_CAL_GBR9_CAL_GBR_VAL_MASK)
/*! @} */

/*! @name CAL_GBR10 - Calibration General B-Side Registers */
/*! @{ */

#define ADC_CAL_GBR10_CAL_GBR_VAL_MASK           (0x7FFFU)
#define ADC_CAL_GBR10_CAL_GBR_VAL_SHIFT          (0U)
/*! CAL_GBR_VAL - Calibration General B Side Register Element
 */
#define ADC_CAL_GBR10_CAL_GBR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GBR10_CAL_GBR_VAL_SHIFT)) & ADC_CAL_GBR10_CAL_GBR_VAL_MASK)
/*! @} */

/*! @name CAL_GBR11 - Calibration General B-Side Registers */
/*! @{ */

#define ADC_CAL_GBR11_CAL_GBR_VAL_MASK           (0x7FFFU)
#define ADC_CAL_GBR11_CAL_GBR_VAL_SHIFT          (0U)
/*! CAL_GBR_VAL - Calibration General B Side Register Element
 */
#define ADC_CAL_GBR11_CAL_GBR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GBR11_CAL_GBR_VAL_SHIFT)) & ADC_CAL_GBR11_CAL_GBR_VAL_MASK)
/*! @} */

/*! @name CAL_GBR12 - Calibration General B-Side Registers */
/*! @{ */

#define ADC_CAL_GBR12_CAL_GBR_VAL_MASK           (0x7FFFU)
#define ADC_CAL_GBR12_CAL_GBR_VAL_SHIFT          (0U)
/*! CAL_GBR_VAL - Calibration General B Side Register Element
 */
#define ADC_CAL_GBR12_CAL_GBR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GBR12_CAL_GBR_VAL_SHIFT)) & ADC_CAL_GBR12_CAL_GBR_VAL_MASK)
/*! @} */

/*! @name CAL_GBR13 - Calibration General B-Side Registers */
/*! @{ */

#define ADC_CAL_GBR13_CAL_GBR_VAL_MASK           (0x7FFFU)
#define ADC_CAL_GBR13_CAL_GBR_VAL_SHIFT          (0U)
/*! CAL_GBR_VAL - Calibration General B Side Register Element
 */
#define ADC_CAL_GBR13_CAL_GBR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GBR13_CAL_GBR_VAL_SHIFT)) & ADC_CAL_GBR13_CAL_GBR_VAL_MASK)
/*! @} */

/*! @name CAL_GBR14 - Calibration General B-Side Registers */
/*! @{ */

#define ADC_CAL_GBR14_CAL_GBR_VAL_MASK           (0x7FFFU)
#define ADC_CAL_GBR14_CAL_GBR_VAL_SHIFT          (0U)
/*! CAL_GBR_VAL - Calibration General B Side Register Element
 */
#define ADC_CAL_GBR14_CAL_GBR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GBR14_CAL_GBR_VAL_SHIFT)) & ADC_CAL_GBR14_CAL_GBR_VAL_MASK)
/*! @} */

/*! @name CAL_GBR15 - Calibration General B-Side Registers */
/*! @{ */

#define ADC_CAL_GBR15_CAL_GBR_VAL_MASK           (0x7FFFU)
#define ADC_CAL_GBR15_CAL_GBR_VAL_SHIFT          (0U)
/*! CAL_GBR_VAL - Calibration General B Side Register Element
 */
#define ADC_CAL_GBR15_CAL_GBR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GBR15_CAL_GBR_VAL_SHIFT)) & ADC_CAL_GBR15_CAL_GBR_VAL_MASK)
/*! @} */

/*! @name CAL_GBR16 - Calibration General B-Side Registers */
/*! @{ */

#define ADC_CAL_GBR16_CAL_GBR_VAL_MASK           (0xFFFFU)
#define ADC_CAL_GBR16_CAL_GBR_VAL_SHIFT          (0U)
/*! CAL_GBR_VAL - Calibration General B Side Register Element
 */
#define ADC_CAL_GBR16_CAL_GBR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GBR16_CAL_GBR_VAL_SHIFT)) & ADC_CAL_GBR16_CAL_GBR_VAL_MASK)
/*! @} */

/*! @name CAL_GBR17 - Calibration General B-Side Registers */
/*! @{ */

#define ADC_CAL_GBR17_CAL_GBR_VAL_MASK           (0xFFFFU)
#define ADC_CAL_GBR17_CAL_GBR_VAL_SHIFT          (0U)
/*! CAL_GBR_VAL - Calibration General B Side Register Element
 */
#define ADC_CAL_GBR17_CAL_GBR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GBR17_CAL_GBR_VAL_SHIFT)) & ADC_CAL_GBR17_CAL_GBR_VAL_MASK)
/*! @} */

/*! @name CAL_GBR18 - Calibration General B-Side Registers */
/*! @{ */

#define ADC_CAL_GBR18_CAL_GBR_VAL_MASK           (0xFFFFU)
#define ADC_CAL_GBR18_CAL_GBR_VAL_SHIFT          (0U)
/*! CAL_GBR_VAL - Calibration General B Side Register Element
 */
#define ADC_CAL_GBR18_CAL_GBR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GBR18_CAL_GBR_VAL_SHIFT)) & ADC_CAL_GBR18_CAL_GBR_VAL_MASK)
/*! @} */

/*! @name CAL_GBR19 - Calibration General B-Side Registers */
/*! @{ */

#define ADC_CAL_GBR19_CAL_GBR_VAL_MASK           (0xFFFFU)
#define ADC_CAL_GBR19_CAL_GBR_VAL_SHIFT          (0U)
/*! CAL_GBR_VAL - Calibration General B Side Register Element
 */
#define ADC_CAL_GBR19_CAL_GBR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GBR19_CAL_GBR_VAL_SHIFT)) & ADC_CAL_GBR19_CAL_GBR_VAL_MASK)
/*! @} */

/*! @name CAL_GBR20 - Calibration General B-Side Registers */
/*! @{ */

#define ADC_CAL_GBR20_CAL_GBR_VAL_MASK           (0xFFFFU)
#define ADC_CAL_GBR20_CAL_GBR_VAL_SHIFT          (0U)
/*! CAL_GBR_VAL - Calibration General B Side Register Element
 */
#define ADC_CAL_GBR20_CAL_GBR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GBR20_CAL_GBR_VAL_SHIFT)) & ADC_CAL_GBR20_CAL_GBR_VAL_MASK)
/*! @} */

/*! @name CAL_GBR21 - Calibration General B-Side Registers */
/*! @{ */

#define ADC_CAL_GBR21_CAL_GBR_VAL_MASK           (0xFFFFU)
#define ADC_CAL_GBR21_CAL_GBR_VAL_SHIFT          (0U)
/*! CAL_GBR_VAL - Calibration General B Side Register Element
 */
#define ADC_CAL_GBR21_CAL_GBR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GBR21_CAL_GBR_VAL_SHIFT)) & ADC_CAL_GBR21_CAL_GBR_VAL_MASK)
/*! @} */

/*! @name CAL_GBR22 - Calibration General B-Side Registers */
/*! @{ */

#define ADC_CAL_GBR22_CAL_GBR_VAL_MASK           (0xFFFFU)
#define ADC_CAL_GBR22_CAL_GBR_VAL_SHIFT          (0U)
/*! CAL_GBR_VAL - Calibration General B Side Register Element
 */
#define ADC_CAL_GBR22_CAL_GBR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GBR22_CAL_GBR_VAL_SHIFT)) & ADC_CAL_GBR22_CAL_GBR_VAL_MASK)
/*! @} */

/*! @name CAL_GBR23 - Calibration General B-Side Registers */
/*! @{ */

#define ADC_CAL_GBR23_CAL_GBR_VAL_MASK           (0xFFFFU)
#define ADC_CAL_GBR23_CAL_GBR_VAL_SHIFT          (0U)
/*! CAL_GBR_VAL - Calibration General B Side Register Element
 */
#define ADC_CAL_GBR23_CAL_GBR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GBR23_CAL_GBR_VAL_SHIFT)) & ADC_CAL_GBR23_CAL_GBR_VAL_MASK)
/*! @} */

/*! @name CAL_GBR24 - Calibration General B-Side Registers */
/*! @{ */

#define ADC_CAL_GBR24_CAL_GBR_VAL_MASK           (0xFFFFU)
#define ADC_CAL_GBR24_CAL_GBR_VAL_SHIFT          (0U)
/*! CAL_GBR_VAL - Calibration General B Side Register Element
 */
#define ADC_CAL_GBR24_CAL_GBR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GBR24_CAL_GBR_VAL_SHIFT)) & ADC_CAL_GBR24_CAL_GBR_VAL_MASK)
/*! @} */

/*! @name CAL_GBR25 - Calibration General B-Side Registers */
/*! @{ */

#define ADC_CAL_GBR25_CAL_GBR_VAL_MASK           (0xFFFFU)
#define ADC_CAL_GBR25_CAL_GBR_VAL_SHIFT          (0U)
/*! CAL_GBR_VAL - Calibration General B Side Register Element
 */
#define ADC_CAL_GBR25_CAL_GBR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GBR25_CAL_GBR_VAL_SHIFT)) & ADC_CAL_GBR25_CAL_GBR_VAL_MASK)
/*! @} */

/*! @name CAL_GBR26 - Calibration General B-Side Registers */
/*! @{ */

#define ADC_CAL_GBR26_CAL_GBR_VAL_MASK           (0xFFFFU)
#define ADC_CAL_GBR26_CAL_GBR_VAL_SHIFT          (0U)
/*! CAL_GBR_VAL - Calibration General B Side Register Element
 */
#define ADC_CAL_GBR26_CAL_GBR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GBR26_CAL_GBR_VAL_SHIFT)) & ADC_CAL_GBR26_CAL_GBR_VAL_MASK)
/*! @} */

/*! @name CAL_GBR27 - Calibration General B-Side Registers */
/*! @{ */

#define ADC_CAL_GBR27_CAL_GBR_VAL_MASK           (0xFFFFU)
#define ADC_CAL_GBR27_CAL_GBR_VAL_SHIFT          (0U)
/*! CAL_GBR_VAL - Calibration General B Side Register Element
 */
#define ADC_CAL_GBR27_CAL_GBR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GBR27_CAL_GBR_VAL_SHIFT)) & ADC_CAL_GBR27_CAL_GBR_VAL_MASK)
/*! @} */

/*! @name CAL_GBR28 - Calibration General B-Side Registers */
/*! @{ */

#define ADC_CAL_GBR28_CAL_GBR_VAL_MASK           (0xFFFFU)
#define ADC_CAL_GBR28_CAL_GBR_VAL_SHIFT          (0U)
/*! CAL_GBR_VAL - Calibration General B Side Register Element
 */
#define ADC_CAL_GBR28_CAL_GBR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GBR28_CAL_GBR_VAL_SHIFT)) & ADC_CAL_GBR28_CAL_GBR_VAL_MASK)
/*! @} */

/*! @name CAL_GBR29 - Calibration General B-Side Registers */
/*! @{ */

#define ADC_CAL_GBR29_CAL_GBR_VAL_MASK           (0xFFFFU)
#define ADC_CAL_GBR29_CAL_GBR_VAL_SHIFT          (0U)
/*! CAL_GBR_VAL - Calibration General B Side Register Element
 */
#define ADC_CAL_GBR29_CAL_GBR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GBR29_CAL_GBR_VAL_SHIFT)) & ADC_CAL_GBR29_CAL_GBR_VAL_MASK)
/*! @} */

/*! @name CAL_GBR30 - Calibration General B-Side Registers */
/*! @{ */

#define ADC_CAL_GBR30_CAL_GBR_VAL_MASK           (0xFFFFU)
#define ADC_CAL_GBR30_CAL_GBR_VAL_SHIFT          (0U)
/*! CAL_GBR_VAL - Calibration General B Side Register Element
 */
#define ADC_CAL_GBR30_CAL_GBR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GBR30_CAL_GBR_VAL_SHIFT)) & ADC_CAL_GBR30_CAL_GBR_VAL_MASK)
/*! @} */

/*! @name CAL_GBR31 - Calibration General B-Side Registers */
/*! @{ */

#define ADC_CAL_GBR31_CAL_GBR_VAL_MASK           (0xFFFFU)
#define ADC_CAL_GBR31_CAL_GBR_VAL_SHIFT          (0U)
/*! CAL_GBR_VAL - Calibration General B Side Register Element
 */
#define ADC_CAL_GBR31_CAL_GBR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GBR31_CAL_GBR_VAL_SHIFT)) & ADC_CAL_GBR31_CAL_GBR_VAL_MASK)
/*! @} */

/*! @name CAL_GBR32 - Calibration General B-Side Registers */
/*! @{ */

#define ADC_CAL_GBR32_CAL_GBR_VAL_MASK           (0x7FFU)
#define ADC_CAL_GBR32_CAL_GBR_VAL_SHIFT          (0U)
/*! CAL_GBR_VAL - Calibration General B Side Register Element
 */
#define ADC_CAL_GBR32_CAL_GBR_VAL(x)             (((uint32_t)(((uint32_t)(x)) << ADC_CAL_GBR32_CAL_GBR_VAL_SHIFT)) & ADC_CAL_GBR32_CAL_GBR_VAL_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group ADC_Register_Masks */


/* ADC - Peripheral instance base addresses */
#if (defined(__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE & 0x2))
  /** Peripheral ADC0 base address */
  #define ADC0_BASE                                (0x50047000u)
  /** Peripheral ADC0 base address */
  #define ADC0_BASE_NS                             (0x40047000u)
  /** Peripheral ADC0 base pointer */
  #define ADC0                                     ((ADC_Type *)ADC0_BASE)
  /** Peripheral ADC0 base pointer */
  #define ADC0_NS                                  ((ADC_Type *)ADC0_BASE_NS)
  /** Array initializer of ADC peripheral base addresses */
  #define ADC_BASE_ADDRS                           { ADC0_BASE }
  /** Array initializer of ADC peripheral base pointers */
  #define ADC_BASE_PTRS                            { ADC0 }
  /** Array initializer of ADC peripheral base addresses */
  #define ADC_BASE_ADDRS_NS                        { ADC0_BASE_NS }
  /** Array initializer of ADC peripheral base pointers */
  #define ADC_BASE_PTRS_NS                         { ADC0_NS }
#else
  /** Peripheral ADC0 base address */
  #define ADC0_BASE                                (0x40047000u)
  /** Peripheral ADC0 base pointer */
  #define ADC0                                     ((ADC_Type *)ADC0_BASE)
  /** Array initializer of ADC peripheral base addresses */
  #define ADC_BASE_ADDRS                           { ADC0_BASE }
  /** Array initializer of ADC peripheral base pointers */
  #define ADC_BASE_PTRS                            { ADC0 }
#endif
/** Interrupt vectors for the ADC peripheral type */
#define ADC_IRQS                                 { ADC0_IRQn }

/*!
 * @}
 */ /* end of group ADC_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- AXBS Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup AXBS_Peripheral_Access_Layer AXBS Peripheral Access Layer
 * @{
 */

/** AXBS - Register Layout Typedef */
typedef struct {
  __IO uint32_t PRS0;                              /**< Priority Slave Registers, offset: 0x0 */
       uint8_t RESERVED_0[12];
  __IO uint32_t CRS0;                              /**< Control Register, offset: 0x10 */
       uint8_t RESERVED_1[236];
  __IO uint32_t PRS1;                              /**< Priority Slave Registers, offset: 0x100 */
       uint8_t RESERVED_2[12];
  __IO uint32_t CRS1;                              /**< Control Register, offset: 0x110 */
       uint8_t RESERVED_3[236];
  __IO uint32_t PRS2;                              /**< Priority Slave Registers, offset: 0x200 */
       uint8_t RESERVED_4[12];
  __IO uint32_t CRS2;                              /**< Control Register, offset: 0x210 */
       uint8_t RESERVED_5[236];
  __IO uint32_t PRS3;                              /**< Priority Slave Registers, offset: 0x300 */
       uint8_t RESERVED_6[12];
  __IO uint32_t CRS3;                              /**< Control Register, offset: 0x310 */
       uint8_t RESERVED_7[236];
  __IO uint32_t PRS4;                              /**< Priority Slave Registers, offset: 0x400 */
       uint8_t RESERVED_8[12];
  __IO uint32_t CRS4;                              /**< Control Register, offset: 0x410 */
       uint8_t RESERVED_9[236];
  __IO uint32_t PRS5;                              /**< Priority Slave Registers, offset: 0x500 */
       uint8_t RESERVED_10[12];
  __IO uint32_t CRS5;                              /**< Control Register, offset: 0x510 */
       uint8_t RESERVED_11[236];
  __IO uint32_t PRS6;                              /**< Priority Slave Registers, offset: 0x600 */
       uint8_t RESERVED_12[12];
  __IO uint32_t CRS6;                              /**< Control Register, offset: 0x610 */
       uint8_t RESERVED_13[236];
  __IO uint32_t PRS7;                              /**< Priority Slave Registers, offset: 0x700 */
       uint8_t RESERVED_14[12];
  __IO uint32_t CRS7;                              /**< Control Register, offset: 0x710 */
       uint8_t RESERVED_15[236];
  __IO uint32_t MGPCR0;                            /**< Master General Purpose Control Register, offset: 0x800 */
       uint8_t RESERVED_16[252];
  __IO uint32_t MGPCR1;                            /**< Master General Purpose Control Register, offset: 0x900 */
       uint8_t RESERVED_17[252];
  __IO uint32_t MGPCR2;                            /**< Master General Purpose Control Register, offset: 0xA00 */
       uint8_t RESERVED_18[252];
  __IO uint32_t MGPCR3;                            /**< Master General Purpose Control Register, offset: 0xB00 */
       uint8_t RESERVED_19[252];
  __IO uint32_t MGPCR4;                            /**< Master General Purpose Control Register, offset: 0xC00 */
       uint8_t RESERVED_20[252];
  __IO uint32_t MGPCR5;                            /**< Master General Purpose Control Register, offset: 0xD00 */
} AXBS_Type;

/* ----------------------------------------------------------------------------
   -- AXBS Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup AXBS_Register_Masks AXBS Register Masks
 * @{
 */

/*! @name PRS0 - Priority Slave Registers */
/*! @{ */

#define AXBS_PRS0_M0_MASK                        (0x7U)
#define AXBS_PRS0_M0_SHIFT                       (0U)
/*! M0 - Master 0 Priority
 *  0b000..This master has level 1 or highest priority when accessing the slave port.
 *  0b001..This master has level 2 priority when accessing the slave port.
 *  0b010..This master has level 3 priority when accessing the slave port.
 *  0b011..This master has level 4 priority when accessing the slave port.
 *  0b100..This master has level 5 priority when accessing the slave port.
 *  0b101..This master has level 6 priority when accessing the slave port.
 *  0b110..This master has level 7 priority when accessing the slave port.
 *  0b111..This master has level 8 or lowest priority when accessing the slave port.
 */
#define AXBS_PRS0_M0(x)                          (((uint32_t)(((uint32_t)(x)) << AXBS_PRS0_M0_SHIFT)) & AXBS_PRS0_M0_MASK)

#define AXBS_PRS0_M1_MASK                        (0x70U)
#define AXBS_PRS0_M1_SHIFT                       (4U)
/*! M1 - Master 1 Priority
 *  0b000..This master has level 1 or highest priority when accessing the slave port.
 *  0b001..This master has level 2 priority when accessing the slave port.
 *  0b010..This master has level 3 priority when accessing the slave port.
 *  0b011..This master has level 4 priority when accessing the slave port.
 *  0b100..This master has level 5 priority when accessing the slave port.
 *  0b101..This master has level 6 priority when accessing the slave port.
 *  0b110..This master has level 7 priority when accessing the slave port.
 *  0b111..This master has level 8 or lowest priority when accessing the slave port.
 */
#define AXBS_PRS0_M1(x)                          (((uint32_t)(((uint32_t)(x)) << AXBS_PRS0_M1_SHIFT)) & AXBS_PRS0_M1_MASK)

#define AXBS_PRS0_M2_MASK                        (0x700U)
#define AXBS_PRS0_M2_SHIFT                       (8U)
/*! M2 - Master 2 Priority
 *  0b000..This master has level 1 or highest priority when accessing the slave port.
 *  0b001..This master has level 2 priority when accessing the slave port.
 *  0b010..This master has level 3 priority when accessing the slave port.
 *  0b011..This master has level 4 priority when accessing the slave port.
 *  0b100..This master has level 5 priority when accessing the slave port.
 *  0b101..This master has level 6 priority when accessing the slave port.
 *  0b110..This master has level 7 priority when accessing the slave port.
 *  0b111..This master has level 8 or lowest priority when accessing the slave port.
 */
#define AXBS_PRS0_M2(x)                          (((uint32_t)(((uint32_t)(x)) << AXBS_PRS0_M2_SHIFT)) & AXBS_PRS0_M2_MASK)

#define AXBS_PRS0_M3_MASK                        (0x7000U)
#define AXBS_PRS0_M3_SHIFT                       (12U)
/*! M3 - Master 3 Priority
 *  0b000..This master has level 1 or highest priority when accessing the slave port.
 *  0b001..This master has level 2 priority when accessing the slave port.
 *  0b010..This master has level 3 priority when accessing the slave port.
 *  0b011..This master has level 4 priority when accessing the slave port.
 *  0b100..This master has level 5 priority when accessing the slave port.
 *  0b101..This master has level 6 priority when accessing the slave port.
 *  0b110..This master has level 7 priority when accessing the slave port.
 *  0b111..This master has level 8 or lowest priority when accessing the slave port.
 */
#define AXBS_PRS0_M3(x)                          (((uint32_t)(((uint32_t)(x)) << AXBS_PRS0_M3_SHIFT)) & AXBS_PRS0_M3_MASK)

#define AXBS_PRS0_M4_MASK                        (0x70000U)
#define AXBS_PRS0_M4_SHIFT                       (16U)
/*! M4 - Master 4 Priority
 *  0b000..This master has level 1 or highest priority when accessing the slave port.
 *  0b001..This master has level 2 priority when accessing the slave port.
 *  0b010..This master has level 3 priority when accessing the slave port.
 *  0b011..This master has level 4 priority when accessing the slave port.
 *  0b100..This master has level 5 priority when accessing the slave port.
 *  0b101..This master has level 6 priority when accessing the slave port.
 *  0b110..This master has level 7 priority when accessing the slave port.
 *  0b111..This master has level 8 or lowest priority when accessing the slave port.
 */
#define AXBS_PRS0_M4(x)                          (((uint32_t)(((uint32_t)(x)) << AXBS_PRS0_M4_SHIFT)) & AXBS_PRS0_M4_MASK)

#define AXBS_PRS0_M5_MASK                        (0x700000U)
#define AXBS_PRS0_M5_SHIFT                       (20U)
/*! M5 - Master 5 Priority
 *  0b000..This master has level 1 or highest priority when accessing the slave port.
 *  0b001..This master has level 2 priority when accessing the slave port.
 *  0b010..This master has level 3 priority when accessing the slave port.
 *  0b011..This master has level 4 priority when accessing the slave port.
 *  0b100..This master has level 5 priority when accessing the slave port.
 *  0b101..This master has level 6 priority when accessing the slave port.
 *  0b110..This master has level 7 priority when accessing the slave port.
 *  0b111..This master has level 8 or lowest priority when accessing the slave port.
 */
#define AXBS_PRS0_M5(x)                          (((uint32_t)(((uint32_t)(x)) << AXBS_PRS0_M5_SHIFT)) & AXBS_PRS0_M5_MASK)
/*! @} */

/*! @name CRS0 - Control Register */
/*! @{ */

#define AXBS_CRS0_PARK_MASK                      (0x7U)
#define AXBS_CRS0_PARK_SHIFT                     (0U)
/*! PARK - Park
 *  0b111..Park on master port M0.
 *  0b001..Park on master port M1.
 *  0b010..Park on master port M2.
 *  0b011..Park on master port M3.
 *  0b100..Park on master port M4.
 *  0b101..Park on master port M5.
 */
#define AXBS_CRS0_PARK(x)                        (((uint32_t)(((uint32_t)(x)) << AXBS_CRS0_PARK_SHIFT)) & AXBS_CRS0_PARK_MASK)

#define AXBS_CRS0_PCTL_MASK                      (0x30U)
#define AXBS_CRS0_PCTL_SHIFT                     (4U)
/*! PCTL - Parking Control
 *  0b00..When no master makes a request, the arbiter parks the slave port on the master port defined by the PARK field.
 *  0b01..When no master makes a request, the arbiter parks the slave port on the last master to be in control of the slave port.
 *  0b10..When no master makes a request, the slave port is not parked on a master and the arbiter drives all outputs to a constant safe state.
 *  0b11..Reserved
 */
#define AXBS_CRS0_PCTL(x)                        (((uint32_t)(((uint32_t)(x)) << AXBS_CRS0_PCTL_SHIFT)) & AXBS_CRS0_PCTL_MASK)

#define AXBS_CRS0_ARB_MASK                       (0x300U)
#define AXBS_CRS0_ARB_SHIFT                      (8U)
/*! ARB - Arbitration Mode
 *  0b00..Fixed priority
 *  0b01..Round-robin(RR) or rotating priority
 *  0b10..Reserved
 *  0b11..Reserved
 */
#define AXBS_CRS0_ARB(x)                         (((uint32_t)(((uint32_t)(x)) << AXBS_CRS0_ARB_SHIFT)) & AXBS_CRS0_ARB_MASK)

#define AXBS_CRS0_HLP_MASK                       (0x40000000U)
#define AXBS_CRS0_HLP_SHIFT                      (30U)
/*! HLP - Halt Low Priority
 *  0b0..The low-power mode request has the highest priority for arbitration on this slave port.
 *  0b1..The low-power mode request has the lowest initial priority for arbitration on this slave port.
 */
#define AXBS_CRS0_HLP(x)                         (((uint32_t)(((uint32_t)(x)) << AXBS_CRS0_HLP_SHIFT)) & AXBS_CRS0_HLP_MASK)

#define AXBS_CRS0_RO_MASK                        (0x80000000U)
#define AXBS_CRS0_RO_SHIFT                       (31U)
/*! RO - Read Only
 *  0b0..The slave port's registers are writeable.
 *  0b1..The slave port's registers are read-only and cannot be written. Attempted writes have no effect on the
 *       registers and result in a bus error response.
 */
#define AXBS_CRS0_RO(x)                          (((uint32_t)(((uint32_t)(x)) << AXBS_CRS0_RO_SHIFT)) & AXBS_CRS0_RO_MASK)
/*! @} */

/*! @name PRS1 - Priority Slave Registers */
/*! @{ */

#define AXBS_PRS1_M0_MASK                        (0x7U)
#define AXBS_PRS1_M0_SHIFT                       (0U)
/*! M0 - Master 0 Priority
 *  0b000..This master has level 1 or highest priority when accessing the slave port.
 *  0b001..This master has level 2 priority when accessing the slave port.
 *  0b010..This master has level 3 priority when accessing the slave port.
 *  0b011..This master has level 4 priority when accessing the slave port.
 *  0b100..This master has level 5 priority when accessing the slave port.
 *  0b101..This master has level 6 priority when accessing the slave port.
 *  0b110..This master has level 7 priority when accessing the slave port.
 *  0b111..This master has level 8 or lowest priority when accessing the slave port.
 */
#define AXBS_PRS1_M0(x)                          (((uint32_t)(((uint32_t)(x)) << AXBS_PRS1_M0_SHIFT)) & AXBS_PRS1_M0_MASK)

#define AXBS_PRS1_M1_MASK                        (0x70U)
#define AXBS_PRS1_M1_SHIFT                       (4U)
/*! M1 - Master 1 Priority
 *  0b000..This master has level 1 or highest priority when accessing the slave port.
 *  0b001..This master has level 2 priority when accessing the slave port.
 *  0b010..This master has level 3 priority when accessing the slave port.
 *  0b011..This master has level 4 priority when accessing the slave port.
 *  0b100..This master has level 5 priority when accessing the slave port.
 *  0b101..This master has level 6 priority when accessing the slave port.
 *  0b110..This master has level 7 priority when accessing the slave port.
 *  0b111..This master has level 8 or lowest priority when accessing the slave port.
 */
#define AXBS_PRS1_M1(x)                          (((uint32_t)(((uint32_t)(x)) << AXBS_PRS1_M1_SHIFT)) & AXBS_PRS1_M1_MASK)

#define AXBS_PRS1_M2_MASK                        (0x700U)
#define AXBS_PRS1_M2_SHIFT                       (8U)
/*! M2 - Master 2 Priority
 *  0b000..This master has level 1 or highest priority when accessing the slave port.
 *  0b001..This master has level 2 priority when accessing the slave port.
 *  0b010..This master has level 3 priority when accessing the slave port.
 *  0b011..This master has level 4 priority when accessing the slave port.
 *  0b100..This master has level 5 priority when accessing the slave port.
 *  0b101..This master has level 6 priority when accessing the slave port.
 *  0b110..This master has level 7 priority when accessing the slave port.
 *  0b111..This master has level 8 or lowest priority when accessing the slave port.
 */
#define AXBS_PRS1_M2(x)                          (((uint32_t)(((uint32_t)(x)) << AXBS_PRS1_M2_SHIFT)) & AXBS_PRS1_M2_MASK)

#define AXBS_PRS1_M3_MASK                        (0x7000U)
#define AXBS_PRS1_M3_SHIFT                       (12U)
/*! M3 - Master 3 Priority
 *  0b000..This master has level 1 or highest priority when accessing the slave port.
 *  0b001..This master has level 2 priority when accessing the slave port.
 *  0b010..This master has level 3 priority when accessing the slave port.
 *  0b011..This master has level 4 priority when accessing the slave port.
 *  0b100..This master has level 5 priority when accessing the slave port.
 *  0b101..This master has level 6 priority when accessing the slave port.
 *  0b110..This master has level 7 priority when accessing the slave port.
 *  0b111..This master has level 8 or lowest priority when accessing the slave port.
 */
#define AXBS_PRS1_M3(x)                          (((uint32_t)(((uint32_t)(x)) << AXBS_PRS1_M3_SHIFT)) & AXBS_PRS1_M3_MASK)

#define AXBS_PRS1_M4_MASK                        (0x70000U)
#define AXBS_PRS1_M4_SHIFT                       (16U)
/*! M4 - Master 4 Priority
 *  0b000..This master has level 1 or highest priority when accessing the slave port.
 *  0b001..This master has level 2 priority when accessing the slave port.
 *  0b010..This master has level 3 priority when accessing the slave port.
 *  0b011..This master has level 4 priority when accessing the slave port.
 *  0b100..This master has level 5 priority when accessing the slave port.
 *  0b101..This master has level 6 priority when accessing the slave port.
 *  0b110..This master has level 7 priority when accessing the slave port.
 *  0b111..This master has level 8 or lowest priority when accessing the slave port.
 */
#define AXBS_PRS1_M4(x)                          (((uint32_t)(((uint32_t)(x)) << AXBS_PRS1_M4_SHIFT)) & AXBS_PRS1_M4_MASK)

#define AXBS_PRS1_M5_MASK                        (0x700000U)
#define AXBS_PRS1_M5_SHIFT                       (20U)
/*! M5 - Master 5 Priority
 *  0b000..This master has level 1 or highest priority when accessing the slave port.
 *  0b001..This master has level 2 priority when accessing the slave port.
 *  0b010..This master has level 3 priority when accessing the slave port.
 *  0b011..This master has level 4 priority when accessing the slave port.
 *  0b100..This master has level 5 priority when accessing the slave port.
 *  0b101..This master has level 6 priority when accessing the slave port.
 *  0b110..This master has level 7 priority when accessing the slave port.
 *  0b111..This master has level 8 or lowest priority when accessing the slave port.
 */
#define AXBS_PRS1_M5(x)                          (((uint32_t)(((uint32_t)(x)) << AXBS_PRS1_M5_SHIFT)) & AXBS_PRS1_M5_MASK)
/*! @} */

/*! @name CRS1 - Control Register */
/*! @{ */

#define AXBS_CRS1_PARK_MASK                      (0x7U)
#define AXBS_CRS1_PARK_SHIFT                     (0U)
/*! PARK - Park
 *  0b111..Park on master port M0.
 *  0b001..Park on master port M1.
 *  0b010..Park on master port M2.
 *  0b011..Park on master port M3.
 *  0b100..Park on master port M4.
 *  0b101..Park on master port M5.
 */
#define AXBS_CRS1_PARK(x)                        (((uint32_t)(((uint32_t)(x)) << AXBS_CRS1_PARK_SHIFT)) & AXBS_CRS1_PARK_MASK)

#define AXBS_CRS1_PCTL_MASK                      (0x30U)
#define AXBS_CRS1_PCTL_SHIFT                     (4U)
/*! PCTL - Parking Control
 *  0b00..When no master makes a request, the arbiter parks the slave port on the master port defined by the PARK field.
 *  0b01..When no master makes a request, the arbiter parks the slave port on the last master to be in control of the slave port.
 *  0b10..When no master makes a request, the slave port is not parked on a master and the arbiter drives all outputs to a constant safe state.
 *  0b11..Reserved
 */
#define AXBS_CRS1_PCTL(x)                        (((uint32_t)(((uint32_t)(x)) << AXBS_CRS1_PCTL_SHIFT)) & AXBS_CRS1_PCTL_MASK)

#define AXBS_CRS1_ARB_MASK                       (0x300U)
#define AXBS_CRS1_ARB_SHIFT                      (8U)
/*! ARB - Arbitration Mode
 *  0b00..Fixed priority
 *  0b01..Round-robin(RR) or rotating priority
 *  0b10..Reserved
 *  0b11..Reserved
 */
#define AXBS_CRS1_ARB(x)                         (((uint32_t)(((uint32_t)(x)) << AXBS_CRS1_ARB_SHIFT)) & AXBS_CRS1_ARB_MASK)

#define AXBS_CRS1_HLP_MASK                       (0x40000000U)
#define AXBS_CRS1_HLP_SHIFT                      (30U)
/*! HLP - Halt Low Priority
 *  0b0..The low-power mode request has the highest priority for arbitration on this slave port.
 *  0b1..The low-power mode request has the lowest initial priority for arbitration on this slave port.
 */
#define AXBS_CRS1_HLP(x)                         (((uint32_t)(((uint32_t)(x)) << AXBS_CRS1_HLP_SHIFT)) & AXBS_CRS1_HLP_MASK)

#define AXBS_CRS1_RO_MASK                        (0x80000000U)
#define AXBS_CRS1_RO_SHIFT                       (31U)
/*! RO - Read Only
 *  0b0..The slave port's registers are writeable.
 *  0b1..The slave port's registers are read-only and cannot be written. Attempted writes have no effect on the
 *       registers and result in a bus error response.
 */
#define AXBS_CRS1_RO(x)                          (((uint32_t)(((uint32_t)(x)) << AXBS_CRS1_RO_SHIFT)) & AXBS_CRS1_RO_MASK)
/*! @} */

/*! @name PRS2 - Priority Slave Registers */
/*! @{ */

#define AXBS_PRS2_M0_MASK                        (0x7U)
#define AXBS_PRS2_M0_SHIFT                       (0U)
/*! M0 - Master 0 Priority
 *  0b000..This master has level 1 or highest priority when accessing the slave port.
 *  0b001..This master has level 2 priority when accessing the slave port.
 *  0b010..This master has level 3 priority when accessing the slave port.
 *  0b011..This master has level 4 priority when accessing the slave port.
 *  0b100..This master has level 5 priority when accessing the slave port.
 *  0b101..This master has level 6 priority when accessing the slave port.
 *  0b110..This master has level 7 priority when accessing the slave port.
 *  0b111..This master has level 8 or lowest priority when accessing the slave port.
 */
#define AXBS_PRS2_M0(x)                          (((uint32_t)(((uint32_t)(x)) << AXBS_PRS2_M0_SHIFT)) & AXBS_PRS2_M0_MASK)

#define AXBS_PRS2_M1_MASK                        (0x70U)
#define AXBS_PRS2_M1_SHIFT                       (4U)
/*! M1 - Master 1 Priority
 *  0b000..This master has level 1 or highest priority when accessing the slave port.
 *  0b001..This master has level 2 priority when accessing the slave port.
 *  0b010..This master has level 3 priority when accessing the slave port.
 *  0b011..This master has level 4 priority when accessing the slave port.
 *  0b100..This master has level 5 priority when accessing the slave port.
 *  0b101..This master has level 6 priority when accessing the slave port.
 *  0b110..This master has level 7 priority when accessing the slave port.
 *  0b111..This master has level 8 or lowest priority when accessing the slave port.
 */
#define AXBS_PRS2_M1(x)                          (((uint32_t)(((uint32_t)(x)) << AXBS_PRS2_M1_SHIFT)) & AXBS_PRS2_M1_MASK)

#define AXBS_PRS2_M2_MASK                        (0x700U)
#define AXBS_PRS2_M2_SHIFT                       (8U)
/*! M2 - Master 2 Priority
 *  0b000..This master has level 1 or highest priority when accessing the slave port.
 *  0b001..This master has level 2 priority when accessing the slave port.
 *  0b010..This master has level 3 priority when accessing the slave port.
 *  0b011..This master has level 4 priority when accessing the slave port.
 *  0b100..This master has level 5 priority when accessing the slave port.
 *  0b101..This master has level 6 priority when accessing the slave port.
 *  0b110..This master has level 7 priority when accessing the slave port.
 *  0b111..This master has level 8 or lowest priority when accessing the slave port.
 */
#define AXBS_PRS2_M2(x)                          (((uint32_t)(((uint32_t)(x)) << AXBS_PRS2_M2_SHIFT)) & AXBS_PRS2_M2_MASK)

#define AXBS_PRS2_M3_MASK                        (0x7000U)
#define AXBS_PRS2_M3_SHIFT                       (12U)
/*! M3 - Master 3 Priority
 *  0b000..This master has level 1 or highest priority when accessing the slave port.
 *  0b001..This master has level 2 priority when accessing the slave port.
 *  0b010..This master has level 3 priority when accessing the slave port.
 *  0b011..This master has level 4 priority when accessing the slave port.
 *  0b100..This master has level 5 priority when accessing the slave port.
 *  0b101..This master has level 6 priority when accessing the slave port.
 *  0b110..This master has level 7 priority when accessing the slave port.
 *  0b111..This master has level 8 or lowest priority when accessing the slave port.
 */
#define AXBS_PRS2_M3(x)                          (((uint32_t)(((uint32_t)(x)) << AXBS_PRS2_M3_SHIFT)) & AXBS_PRS2_M3_MASK)

#define AXBS_PRS2_M4_MASK                        (0x70000U)
#define AXBS_PRS2_M4_SHIFT                       (16U)
/*! M4 - Master 4 Priority
 *  0b000..This master has level 1 or highest priority when accessing the slave port.
 *  0b001..This master has level 2 priority when accessing the slave port.
 *  0b010..This master has level 3 priority when accessing the slave port.
 *  0b011..This master has level 4 priority when accessing the slave port.
 *  0b100..This master has level 5 priority when accessing the slave port.
 *  0b101..This master has level 6 priority when accessing the slave port.
 *  0b110..This master has level 7 priority when accessing the slave port.
 *  0b111..This master has level 8 or lowest priority when accessing the slave port.
 */
#define AXBS_PRS2_M4(x)                          (((uint32_t)(((uint32_t)(x)) << AXBS_PRS2_M4_SHIFT)) & AXBS_PRS2_M4_MASK)

#define AXBS_PRS2_M5_MASK                        (0x700000U)
#define AXBS_PRS2_M5_SHIFT                       (20U)
/*! M5 - Master 5 Priority
 *  0b000..This master has level 1 or highest priority when accessing the slave port.
 *  0b001..This master has level 2 priority when accessing the slave port.
 *  0b010..This master has level 3 priority when accessing the slave port.
 *  0b011..This master has level 4 priority when accessing the slave port.
 *  0b100..This master has level 5 priority when accessing the slave port.
 *  0b101..This master has level 6 priority when accessing the slave port.
 *  0b110..This master has level 7 priority when accessing the slave port.
 *  0b111..This master has level 8 or lowest priority when accessing the slave port.
 */
#define AXBS_PRS2_M5(x)                          (((uint32_t)(((uint32_t)(x)) << AXBS_PRS2_M5_SHIFT)) & AXBS_PRS2_M5_MASK)
/*! @} */

/*! @name CRS2 - Control Register */
/*! @{ */

#define AXBS_CRS2_PARK_MASK                      (0x7U)
#define AXBS_CRS2_PARK_SHIFT                     (0U)
/*! PARK - Park
 *  0b111..Park on master port M0.
 *  0b001..Park on master port M1.
 *  0b010..Park on master port M2.
 *  0b011..Park on master port M3.
 *  0b100..Park on master port M4.
 *  0b101..Park on master port M5.
 */
#define AXBS_CRS2_PARK(x)                        (((uint32_t)(((uint32_t)(x)) << AXBS_CRS2_PARK_SHIFT)) & AXBS_CRS2_PARK_MASK)

#define AXBS_CRS2_PCTL_MASK                      (0x30U)
#define AXBS_CRS2_PCTL_SHIFT                     (4U)
/*! PCTL - Parking Control
 *  0b00..When no master makes a request, the arbiter parks the slave port on the master port defined by the PARK field.
 *  0b01..When no master makes a request, the arbiter parks the slave port on the last master to be in control of the slave port.
 *  0b10..When no master makes a request, the slave port is not parked on a master and the arbiter drives all outputs to a constant safe state.
 *  0b11..Reserved
 */
#define AXBS_CRS2_PCTL(x)                        (((uint32_t)(((uint32_t)(x)) << AXBS_CRS2_PCTL_SHIFT)) & AXBS_CRS2_PCTL_MASK)

#define AXBS_CRS2_ARB_MASK                       (0x300U)
#define AXBS_CRS2_ARB_SHIFT                      (8U)
/*! ARB - Arbitration Mode
 *  0b00..Fixed priority
 *  0b01..Round-robin(RR) or rotating priority
 *  0b10..Reserved
 *  0b11..Reserved
 */
#define AXBS_CRS2_ARB(x)                         (((uint32_t)(((uint32_t)(x)) << AXBS_CRS2_ARB_SHIFT)) & AXBS_CRS2_ARB_MASK)

#define AXBS_CRS2_HLP_MASK                       (0x40000000U)
#define AXBS_CRS2_HLP_SHIFT                      (30U)
/*! HLP - Halt Low Priority
 *  0b0..The low-power mode request has the highest priority for arbitration on this slave port.
 *  0b1..The low-power mode request has the lowest initial priority for arbitration on this slave port.
 */
#define AXBS_CRS2_HLP(x)                         (((uint32_t)(((uint32_t)(x)) << AXBS_CRS2_HLP_SHIFT)) & AXBS_CRS2_HLP_MASK)

#define AXBS_CRS2_RO_MASK                        (0x80000000U)
#define AXBS_CRS2_RO_SHIFT                       (31U)
/*! RO - Read Only
 *  0b0..The slave port's registers are writeable.
 *  0b1..The slave port's registers are read-only and cannot be written. Attempted writes have no effect on the
 *       registers and result in a bus error response.
 */
#define AXBS_CRS2_RO(x)                          (((uint32_t)(((uint32_t)(x)) << AXBS_CRS2_RO_SHIFT)) & AXBS_CRS2_RO_MASK)
/*! @} */

/*! @name PRS3 - Priority Slave Registers */
/*! @{ */

#define AXBS_PRS3_M0_MASK                        (0x7U)
#define AXBS_PRS3_M0_SHIFT                       (0U)
/*! M0 - Master 0 Priority
 *  0b000..This master has level 1 or highest priority when accessing the slave port.
 *  0b001..This master has level 2 priority when accessing the slave port.
 *  0b010..This master has level 3 priority when accessing the slave port.
 *  0b011..This master has level 4 priority when accessing the slave port.
 *  0b100..This master has level 5 priority when accessing the slave port.
 *  0b101..This master has level 6 priority when accessing the slave port.
 *  0b110..This master has level 7 priority when accessing the slave port.
 *  0b111..This master has level 8 or lowest priority when accessing the slave port.
 */
#define AXBS_PRS3_M0(x)                          (((uint32_t)(((uint32_t)(x)) << AXBS_PRS3_M0_SHIFT)) & AXBS_PRS3_M0_MASK)

#define AXBS_PRS3_M1_MASK                        (0x70U)
#define AXBS_PRS3_M1_SHIFT                       (4U)
/*! M1 - Master 1 Priority
 *  0b000..This master has level 1 or highest priority when accessing the slave port.
 *  0b001..This master has level 2 priority when accessing the slave port.
 *  0b010..This master has level 3 priority when accessing the slave port.
 *  0b011..This master has level 4 priority when accessing the slave port.
 *  0b100..This master has level 5 priority when accessing the slave port.
 *  0b101..This master has level 6 priority when accessing the slave port.
 *  0b110..This master has level 7 priority when accessing the slave port.
 *  0b111..This master has level 8 or lowest priority when accessing the slave port.
 */
#define AXBS_PRS3_M1(x)                          (((uint32_t)(((uint32_t)(x)) << AXBS_PRS3_M1_SHIFT)) & AXBS_PRS3_M1_MASK)

#define AXBS_PRS3_M2_MASK                        (0x700U)
#define AXBS_PRS3_M2_SHIFT                       (8U)
/*! M2 - Master 2 Priority
 *  0b000..This master has level 1 or highest priority when accessing the slave port.
 *  0b001..This master has level 2 priority when accessing the slave port.
 *  0b010..This master has level 3 priority when accessing the slave port.
 *  0b011..This master has level 4 priority when accessing the slave port.
 *  0b100..This master has level 5 priority when accessing the slave port.
 *  0b101..This master has level 6 priority when accessing the slave port.
 *  0b110..This master has level 7 priority when accessing the slave port.
 *  0b111..This master has level 8 or lowest priority when accessing the slave port.
 */
#define AXBS_PRS3_M2(x)                          (((uint32_t)(((uint32_t)(x)) << AXBS_PRS3_M2_SHIFT)) & AXBS_PRS3_M2_MASK)

#define AXBS_PRS3_M3_MASK                        (0x7000U)
#define AXBS_PRS3_M3_SHIFT                       (12U)
/*! M3 - Master 3 Priority
 *  0b000..This master has level 1 or highest priority when accessing the slave port.
 *  0b001..This master has level 2 priority when accessing the slave port.
 *  0b010..This master has level 3 priority when accessing the slave port.
 *  0b011..This master has level 4 priority when accessing the slave port.
 *  0b100..This master has level 5 priority when accessing the slave port.
 *  0b101..This master has level 6 priority when accessing the slave port.
 *  0b110..This master has level 7 priority when accessing the slave port.
 *  0b111..This master has level 8 or lowest priority when accessing the slave port.
 */
#define AXBS_PRS3_M3(x)                          (((uint32_t)(((uint32_t)(x)) << AXBS_PRS3_M3_SHIFT)) & AXBS_PRS3_M3_MASK)

#define AXBS_PRS3_M4_MASK                        (0x70000U)
#define AXBS_PRS3_M4_SHIFT                       (16U)
/*! M4 - Master 4 Priority
 *  0b000..This master has level 1 or highest priority when accessing the slave port.
 *  0b001..This master has level 2 priority when accessing the slave port.
 *  0b010..This master has level 3 priority when accessing the slave port.
 *  0b011..This master has level 4 priority when accessing the slave port.
 *  0b100..This master has level 5 priority when accessing the slave port.
 *  0b101..This master has level 6 priority when accessing the slave port.
 *  0b110..This master has level 7 priority when accessing the slave port.
 *  0b111..This master has level 8 or lowest priority when accessing the slave port.
 */
#define AXBS_PRS3_M4(x)                          (((uint32_t)(((uint32_t)(x)) << AXBS_PRS3_M4_SHIFT)) & AXBS_PRS3_M4_MASK)

#define AXBS_PRS3_M5_MASK                        (0x700000U)
#define AXBS_PRS3_M5_SHIFT                       (20U)
/*! M5 - Master 5 Priority
 *  0b000..This master has level 1 or highest priority when accessing the slave port.
 *  0b001..This master has level 2 priority when accessing the slave port.
 *  0b010..This master has level 3 priority when accessing the slave port.
 *  0b011..This master has level 4 priority when accessing the slave port.
 *  0b100..This master has level 5 priority when accessing the slave port.
 *  0b101..This master has level 6 priority when accessing the slave port.
 *  0b110..This master has level 7 priority when accessing the slave port.
 *  0b111..This master has level 8 or lowest priority when accessing the slave port.
 */
#define AXBS_PRS3_M5(x)                          (((uint32_t)(((uint32_t)(x)) << AXBS_PRS3_M5_SHIFT)) & AXBS_PRS3_M5_MASK)
/*! @} */

/*! @name CRS3 - Control Register */
/*! @{ */

#define AXBS_CRS3_PARK_MASK                      (0x7U)
#define AXBS_CRS3_PARK_SHIFT                     (0U)
/*! PARK - Park
 *  0b111..Park on master port M0.
 *  0b001..Park on master port M1.
 *  0b010..Park on master port M2.
 *  0b011..Park on master port M3.
 *  0b100..Park on master port M4.
 *  0b101..Park on master port M5.
 */
#define AXBS_CRS3_PARK(x)                        (((uint32_t)(((uint32_t)(x)) << AXBS_CRS3_PARK_SHIFT)) & AXBS_CRS3_PARK_MASK)

#define AXBS_CRS3_PCTL_MASK                      (0x30U)
#define AXBS_CRS3_PCTL_SHIFT                     (4U)
/*! PCTL - Parking Control
 *  0b00..When no master makes a request, the arbiter parks the slave port on the master port defined by the PARK field.
 *  0b01..When no master makes a request, the arbiter parks the slave port on the last master to be in control of the slave port.
 *  0b10..When no master makes a request, the slave port is not parked on a master and the arbiter drives all outputs to a constant safe state.
 *  0b11..Reserved
 */
#define AXBS_CRS3_PCTL(x)                        (((uint32_t)(((uint32_t)(x)) << AXBS_CRS3_PCTL_SHIFT)) & AXBS_CRS3_PCTL_MASK)

#define AXBS_CRS3_ARB_MASK                       (0x300U)
#define AXBS_CRS3_ARB_SHIFT                      (8U)
/*! ARB - Arbitration Mode
 *  0b00..Fixed priority
 *  0b01..Round-robin(RR) or rotating priority
 *  0b10..Reserved
 *  0b11..Reserved
 */
#define AXBS_CRS3_ARB(x)                         (((uint32_t)(((uint32_t)(x)) << AXBS_CRS3_ARB_SHIFT)) & AXBS_CRS3_ARB_MASK)

#define AXBS_CRS3_HLP_MASK                       (0x40000000U)
#define AXBS_CRS3_HLP_SHIFT                      (30U)
/*! HLP - Halt Low Priority
 *  0b0..The low-power mode request has the highest priority for arbitration on this slave port.
 *  0b1..The low-power mode request has the lowest initial priority for arbitration on this slave port.
 */
#define AXBS_CRS3_HLP(x)                         (((uint32_t)(((uint32_t)(x)) << AXBS_CRS3_HLP_SHIFT)) & AXBS_CRS3_HLP_MASK)

#define AXBS_CRS3_RO_MASK                        (0x80000000U)
#define AXBS_CRS3_RO_SHIFT                       (31U)
/*! RO - Read Only
 *  0b0..The slave port's registers are writeable.
 *  0b1..The slave port's registers are read-only and cannot be written. Attempted writes have no effect on the
 *       registers and result in a bus error response.
 */
#define AXBS_CRS3_RO(x)                          (((uint32_t)(((uint32_t)(x)) << AXBS_CRS3_RO_SHIFT)) & AXBS_CRS3_RO_MASK)
/*! @} */

/*! @name PRS4 - Priority Slave Registers */
/*! @{ */

#define AXBS_PRS4_M0_MASK                        (0x7U)
#define AXBS_PRS4_M0_SHIFT                       (0U)
/*! M0 - Master 0 Priority
 *  0b000..This master has level 1 or highest priority when accessing the slave port.
 *  0b001..This master has level 2 priority when accessing the slave port.
 *  0b010..This master has level 3 priority when accessing the slave port.
 *  0b011..This master has level 4 priority when accessing the slave port.
 *  0b100..This master has level 5 priority when accessing the slave port.
 *  0b101..This master has level 6 priority when accessing the slave port.
 *  0b110..This master has level 7 priority when accessing the slave port.
 *  0b111..This master has level 8 or lowest priority when accessing the slave port.
 */
#define AXBS_PRS4_M0(x)                          (((uint32_t)(((uint32_t)(x)) << AXBS_PRS4_M0_SHIFT)) & AXBS_PRS4_M0_MASK)

#define AXBS_PRS4_M1_MASK                        (0x70U)
#define AXBS_PRS4_M1_SHIFT                       (4U)
/*! M1 - Master 1 Priority
 *  0b000..This master has level 1 or highest priority when accessing the slave port.
 *  0b001..This master has level 2 priority when accessing the slave port.
 *  0b010..This master has level 3 priority when accessing the slave port.
 *  0b011..This master has level 4 priority when accessing the slave port.
 *  0b100..This master has level 5 priority when accessing the slave port.
 *  0b101..This master has level 6 priority when accessing the slave port.
 *  0b110..This master has level 7 priority when accessing the slave port.
 *  0b111..This master has level 8 or lowest priority when accessing the slave port.
 */
#define AXBS_PRS4_M1(x)                          (((uint32_t)(((uint32_t)(x)) << AXBS_PRS4_M1_SHIFT)) & AXBS_PRS4_M1_MASK)

#define AXBS_PRS4_M2_MASK                        (0x700U)
#define AXBS_PRS4_M2_SHIFT                       (8U)
/*! M2 - Master 2 Priority
 *  0b000..This master has level 1 or highest priority when accessing the slave port.
 *  0b001..This master has level 2 priority when accessing the slave port.
 *  0b010..This master has level 3 priority when accessing the slave port.
 *  0b011..This master has level 4 priority when accessing the slave port.
 *  0b100..This master has level 5 priority when accessing the slave port.
 *  0b101..This master has level 6 priority when accessing the slave port.
 *  0b110..This master has level 7 priority when accessing the slave port.
 *  0b111..This master has level 8 or lowest priority when accessing the slave port.
 */
#define AXBS_PRS4_M2(x)                          (((uint32_t)(((uint32_t)(x)) << AXBS_PRS4_M2_SHIFT)) & AXBS_PRS4_M2_MASK)

#define AXBS_PRS4_M3_MASK                        (0x7000U)
#define AXBS_PRS4_M3_SHIFT                       (12U)
/*! M3 - Master 3 Priority
 *  0b000..This master has level 1 or highest priority when accessing the slave port.
 *  0b001..This master has level 2 priority when accessing the slave port.
 *  0b010..This master has level 3 priority when accessing the slave port.
 *  0b011..This master has level 4 priority when accessing the slave port.
 *  0b100..This master has level 5 priority when accessing the slave port.
 *  0b101..This master has level 6 priority when accessing the slave port.
 *  0b110..This master has level 7 priority when accessing the slave port.
 *  0b111..This master has level 8 or lowest priority when accessing the slave port.
 */
#define AXBS_PRS4_M3(x)                          (((uint32_t)(((uint32_t)(x)) << AXBS_PRS4_M3_SHIFT)) & AXBS_PRS4_M3_MASK)

#define AXBS_PRS4_M4_MASK                        (0x70000U)
#define AXBS_PRS4_M4_SHIFT                       (16U)
/*! M4 - Master 4 Priority
 *  0b000..This master has level 1 or highest priority when accessing the slave port.
 *  0b001..This master has level 2 priority when accessing the slave port.
 *  0b010..This master has level 3 priority when accessing the slave port.
 *  0b011..This master has level 4 priority when accessing the slave port.
 *  0b100..This master has level 5 priority when accessing the slave port.
 *  0b101..This master has level 6 priority when accessing the slave port.
 *  0b110..This master has level 7 priority when accessing the slave port.
 *  0b111..This master has level 8 or lowest priority when accessing the slave port.
 */
#define AXBS_PRS4_M4(x)                          (((uint32_t)(((uint32_t)(x)) << AXBS_PRS4_M4_SHIFT)) & AXBS_PRS4_M4_MASK)

#define AXBS_PRS4_M5_MASK                        (0x700000U)
#define AXBS_PRS4_M5_SHIFT                       (20U)
/*! M5 - Master 5 Priority
 *  0b000..This master has level 1 or highest priority when accessing the slave port.
 *  0b001..This master has level 2 priority when accessing the slave port.
 *  0b010..This master has level 3 priority when accessing the slave port.
 *  0b011..This master has level 4 priority when accessing the slave port.
 *  0b100..This master has level 5 priority when accessing the slave port.
 *  0b101..This master has level 6 priority when accessing the slave port.
 *  0b110..This master has level 7 priority when accessing the slave port.
 *  0b111..This master has level 8 or lowest priority when accessing the slave port.
 */
#define AXBS_PRS4_M5(x)                          (((uint32_t)(((uint32_t)(x)) << AXBS_PRS4_M5_SHIFT)) & AXBS_PRS4_M5_MASK)
/*! @} */

/*! @name CRS4 - Control Register */
/*! @{ */

#define AXBS_CRS4_PARK_MASK                      (0x7U)
#define AXBS_CRS4_PARK_SHIFT                     (0U)
/*! PARK - Park
 *  0b111..Park on master port M0.
 *  0b001..Park on master port M1.
 *  0b010..Park on master port M2.
 *  0b011..Park on master port M3.
 *  0b100..Park on master port M4.
 *  0b101..Park on master port M5.
 */
#define AXBS_CRS4_PARK(x)                        (((uint32_t)(((uint32_t)(x)) << AXBS_CRS4_PARK_SHIFT)) & AXBS_CRS4_PARK_MASK)

#define AXBS_CRS4_PCTL_MASK                      (0x30U)
#define AXBS_CRS4_PCTL_SHIFT                     (4U)
/*! PCTL - Parking Control
 *  0b00..When no master makes a request, the arbiter parks the slave port on the master port defined by the PARK field.
 *  0b01..When no master makes a request, the arbiter parks the slave port on the last master to be in control of the slave port.
 *  0b10..When no master makes a request, the slave port is not parked on a master and the arbiter drives all outputs to a constant safe state.
 *  0b11..Reserved
 */
#define AXBS_CRS4_PCTL(x)                        (((uint32_t)(((uint32_t)(x)) << AXBS_CRS4_PCTL_SHIFT)) & AXBS_CRS4_PCTL_MASK)

#define AXBS_CRS4_ARB_MASK                       (0x300U)
#define AXBS_CRS4_ARB_SHIFT                      (8U)
/*! ARB - Arbitration Mode
 *  0b00..Fixed priority
 *  0b01..Round-robin(RR) or rotating priority
 *  0b10..Reserved
 *  0b11..Reserved
 */
#define AXBS_CRS4_ARB(x)                         (((uint32_t)(((uint32_t)(x)) << AXBS_CRS4_ARB_SHIFT)) & AXBS_CRS4_ARB_MASK)

#define AXBS_CRS4_HLP_MASK                       (0x40000000U)
#define AXBS_CRS4_HLP_SHIFT                      (30U)
/*! HLP - Halt Low Priority
 *  0b0..The low-power mode request has the highest priority for arbitration on this slave port.
 *  0b1..The low-power mode request has the lowest initial priority for arbitration on this slave port.
 */
#define AXBS_CRS4_HLP(x)                         (((uint32_t)(((uint32_t)(x)) << AXBS_CRS4_HLP_SHIFT)) & AXBS_CRS4_HLP_MASK)

#define AXBS_CRS4_RO_MASK                        (0x80000000U)
#define AXBS_CRS4_RO_SHIFT                       (31U)
/*! RO - Read Only
 *  0b0..The slave port's registers are writeable.
 *  0b1..The slave port's registers are read-only and cannot be written. Attempted writes have no effect on the
 *       registers and result in a bus error response.
 */
#define AXBS_CRS4_RO(x)                          (((uint32_t)(((uint32_t)(x)) << AXBS_CRS4_RO_SHIFT)) & AXBS_CRS4_RO_MASK)
/*! @} */

/*! @name PRS5 - Priority Slave Registers */
/*! @{ */

#define AXBS_PRS5_M0_MASK                        (0x7U)
#define AXBS_PRS5_M0_SHIFT                       (0U)
/*! M0 - Master 0 Priority
 *  0b000..This master has level 1 or highest priority when accessing the slave port.
 *  0b001..This master has level 2 priority when accessing the slave port.
 *  0b010..This master has level 3 priority when accessing the slave port.
 *  0b011..This master has level 4 priority when accessing the slave port.
 *  0b100..This master has level 5 priority when accessing the slave port.
 *  0b101..This master has level 6 priority when accessing the slave port.
 *  0b110..This master has level 7 priority when accessing the slave port.
 *  0b111..This master has level 8 or lowest priority when accessing the slave port.
 */
#define AXBS_PRS5_M0(x)                          (((uint32_t)(((uint32_t)(x)) << AXBS_PRS5_M0_SHIFT)) & AXBS_PRS5_M0_MASK)

#define AXBS_PRS5_M1_MASK                        (0x70U)
#define AXBS_PRS5_M1_SHIFT                       (4U)
/*! M1 - Master 1 Priority
 *  0b000..This master has level 1 or highest priority when accessing the slave port.
 *  0b001..This master has level 2 priority when accessing the slave port.
 *  0b010..This master has level 3 priority when accessing the slave port.
 *  0b011..This master has level 4 priority when accessing the slave port.
 *  0b100..This master has level 5 priority when accessing the slave port.
 *  0b101..This master has level 6 priority when accessing the slave port.
 *  0b110..This master has level 7 priority when accessing the slave port.
 *  0b111..This master has level 8 or lowest priority when accessing the slave port.
 */
#define AXBS_PRS5_M1(x)                          (((uint32_t)(((uint32_t)(x)) << AXBS_PRS5_M1_SHIFT)) & AXBS_PRS5_M1_MASK)

#define AXBS_PRS5_M2_MASK                        (0x700U)
#define AXBS_PRS5_M2_SHIFT                       (8U)
/*! M2 - Master 2 Priority
 *  0b000..This master has level 1 or highest priority when accessing the slave port.
 *  0b001..This master has level 2 priority when accessing the slave port.
 *  0b010..This master has level 3 priority when accessing the slave port.
 *  0b011..This master has level 4 priority when accessing the slave port.
 *  0b100..This master has level 5 priority when accessing the slave port.
 *  0b101..This master has level 6 priority when accessing the slave port.
 *  0b110..This master has level 7 priority when accessing the slave port.
 *  0b111..This master has level 8 or lowest priority when accessing the slave port.
 */
#define AXBS_PRS5_M2(x)                          (((uint32_t)(((uint32_t)(x)) << AXBS_PRS5_M2_SHIFT)) & AXBS_PRS5_M2_MASK)

#define AXBS_PRS5_M3_MASK                        (0x7000U)
#define AXBS_PRS5_M3_SHIFT                       (12U)
/*! M3 - Master 3 Priority
 *  0b000..This master has level 1 or highest priority when accessing the slave port.
 *  0b001..This master has level 2 priority when accessing the slave port.
 *  0b010..This master has level 3 priority when accessing the slave port.
 *  0b011..This master has level 4 priority when accessing the slave port.
 *  0b100..This master has level 5 priority when accessing the slave port.
 *  0b101..This master has level 6 priority when accessing the slave port.
 *  0b110..This master has level 7 priority when accessing the slave port.
 *  0b111..This master has level 8 or lowest priority when accessing the slave port.
 */
#define AXBS_PRS5_M3(x)                          (((uint32_t)(((uint32_t)(x)) << AXBS_PRS5_M3_SHIFT)) & AXBS_PRS5_M3_MASK)

#define AXBS_PRS5_M4_MASK                        (0x70000U)
#define AXBS_PRS5_M4_SHIFT                       (16U)
/*! M4 - Master 4 Priority
 *  0b000..This master has level 1 or highest priority when accessing the slave port.
 *  0b001..This master has level 2 priority when accessing the slave port.
 *  0b010..This master has level 3 priority when accessing the slave port.
 *  0b011..This master has level 4 priority when accessing the slave port.
 *  0b100..This master has level 5 priority when accessing the slave port.
 *  0b101..This master has level 6 priority when accessing the slave port.
 *  0b110..This master has level 7 priority when accessing the slave port.
 *  0b111..This master has level 8 or lowest priority when accessing the slave port.
 */
#define AXBS_PRS5_M4(x)                          (((uint32_t)(((uint32_t)(x)) << AXBS_PRS5_M4_SHIFT)) & AXBS_PRS5_M4_MASK)

#define AXBS_PRS5_M5_MASK                        (0x700000U)
#define AXBS_PRS5_M5_SHIFT                       (20U)
/*! M5 - Master 5 Priority
 *  0b000..This master has level 1 or highest priority when accessing the slave port.
 *  0b001..This master has level 2 priority when accessing the slave port.
 *  0b010..This master has level 3 priority when accessing the slave port.
 *  0b011..This master has level 4 priority when accessing the slave port.
 *  0b100..This master has level 5 priority when accessing the slave port.
 *  0b101..This master has level 6 priority when accessing the slave port.
 *  0b110..This master has level 7 priority when accessing the slave port.
 *  0b111..This master has level 8 or lowest priority when accessing the slave port.
 */
#define AXBS_PRS5_M5(x)                          (((uint32_t)(((uint32_t)(x)) << AXBS_PRS5_M5_SHIFT)) & AXBS_PRS5_M5_MASK)
/*! @} */

/*! @name CRS5 - Control Register */
/*! @{ */

#define AXBS_CRS5_PARK_MASK                      (0x7U)
#define AXBS_CRS5_PARK_SHIFT                     (0U)
/*! PARK - Park
 *  0b111..Park on master port M0.
 *  0b001..Park on master port M1.
 *  0b010..Park on master port M2.
 *  0b011..Park on master port M3.
 *  0b100..Park on master port M4.
 *  0b101..Park on master port M5.
 */
#define AXBS_CRS5_PARK(x)                        (((uint32_t)(((uint32_t)(x)) << AXBS_CRS5_PARK_SHIFT)) & AXBS_CRS5_PARK_MASK)

#define AXBS_CRS5_PCTL_MASK                      (0x30U)
#define AXBS_CRS5_PCTL_SHIFT                     (4U)
/*! PCTL - Parking Control
 *  0b00..When no master makes a request, the arbiter parks the slave port on the master port defined by the PARK field.
 *  0b01..When no master makes a request, the arbiter parks the slave port on the last master to be in control of the slave port.
 *  0b10..When no master makes a request, the slave port is not parked on a master and the arbiter drives all outputs to a constant safe state.
 *  0b11..Reserved
 */
#define AXBS_CRS5_PCTL(x)                        (((uint32_t)(((uint32_t)(x)) << AXBS_CRS5_PCTL_SHIFT)) & AXBS_CRS5_PCTL_MASK)

#define AXBS_CRS5_ARB_MASK                       (0x300U)
#define AXBS_CRS5_ARB_SHIFT                      (8U)
/*! ARB - Arbitration Mode
 *  0b00..Fixed priority
 *  0b01..Round-robin(RR) or rotating priority
 *  0b10..Reserved
 *  0b11..Reserved
 */
#define AXBS_CRS5_ARB(x)                         (((uint32_t)(((uint32_t)(x)) << AXBS_CRS5_ARB_SHIFT)) & AXBS_CRS5_ARB_MASK)

#define AXBS_CRS5_HLP_MASK                       (0x40000000U)
#define AXBS_CRS5_HLP_SHIFT                      (30U)
/*! HLP - Halt Low Priority
 *  0b0..The low-power mode request has the highest priority for arbitration on this slave port.
 *  0b1..The low-power mode request has the lowest initial priority for arbitration on this slave port.
 */
#define AXBS_CRS5_HLP(x)                         (((uint32_t)(((uint32_t)(x)) << AXBS_CRS5_HLP_SHIFT)) & AXBS_CRS5_HLP_MASK)

#define AXBS_CRS5_RO_MASK                        (0x80000000U)
#define AXBS_CRS5_RO_SHIFT                       (31U)
/*! RO - Read Only
 *  0b0..The slave port's registers are writeable.
 *  0b1..The slave port's registers are read-only and cannot be written. Attempted writes have no effect on the
 *       registers and result in a bus error response.
 */
#define AXBS_CRS5_RO(x)                          (((uint32_t)(((uint32_t)(x)) << AXBS_CRS5_RO_SHIFT)) & AXBS_CRS5_RO_MASK)
/*! @} */

/*! @name PRS6 - Priority Slave Registers */
/*! @{ */

#define AXBS_PRS6_M0_MASK                        (0x7U)
#define AXBS_PRS6_M0_SHIFT                       (0U)
/*! M0 - Master 0 Priority
 *  0b000..This master has level 1 or highest priority when accessing the slave port.
 *  0b001..This master has level 2 priority when accessing the slave port.
 *  0b010..This master has level 3 priority when accessing the slave port.
 *  0b011..This master has level 4 priority when accessing the slave port.
 *  0b100..This master has level 5 priority when accessing the slave port.
 *  0b101..This master has level 6 priority when accessing the slave port.
 *  0b110..This master has level 7 priority when accessing the slave port.
 *  0b111..This master has level 8 or lowest priority when accessing the slave port.
 */
#define AXBS_PRS6_M0(x)                          (((uint32_t)(((uint32_t)(x)) << AXBS_PRS6_M0_SHIFT)) & AXBS_PRS6_M0_MASK)

#define AXBS_PRS6_M1_MASK                        (0x70U)
#define AXBS_PRS6_M1_SHIFT                       (4U)
/*! M1 - Master 1 Priority
 *  0b000..This master has level 1 or highest priority when accessing the slave port.
 *  0b001..This master has level 2 priority when accessing the slave port.
 *  0b010..This master has level 3 priority when accessing the slave port.
 *  0b011..This master has level 4 priority when accessing the slave port.
 *  0b100..This master has level 5 priority when accessing the slave port.
 *  0b101..This master has level 6 priority when accessing the slave port.
 *  0b110..This master has level 7 priority when accessing the slave port.
 *  0b111..This master has level 8 or lowest priority when accessing the slave port.
 */
#define AXBS_PRS6_M1(x)                          (((uint32_t)(((uint32_t)(x)) << AXBS_PRS6_M1_SHIFT)) & AXBS_PRS6_M1_MASK)

#define AXBS_PRS6_M2_MASK                        (0x700U)
#define AXBS_PRS6_M2_SHIFT                       (8U)
/*! M2 - Master 2 Priority
 *  0b000..This master has level 1 or highest priority when accessing the slave port.
 *  0b001..This master has level 2 priority when accessing the slave port.
 *  0b010..This master has level 3 priority when accessing the slave port.
 *  0b011..This master has level 4 priority when accessing the slave port.
 *  0b100..This master has level 5 priority when accessing the slave port.
 *  0b101..This master has level 6 priority when accessing the slave port.
 *  0b110..This master has level 7 priority when accessing the slave port.
 *  0b111..This master has level 8 or lowest priority when accessing the slave port.
 */
#define AXBS_PRS6_M2(x)                          (((uint32_t)(((uint32_t)(x)) << AXBS_PRS6_M2_SHIFT)) & AXBS_PRS6_M2_MASK)

#define AXBS_PRS6_M3_MASK                        (0x7000U)
#define AXBS_PRS6_M3_SHIFT                       (12U)
/*! M3 - Master 3 Priority
 *  0b000..This master has level 1 or highest priority when accessing the slave port.
 *  0b001..This master has level 2 priority when accessing the slave port.
 *  0b010..This master has level 3 priority when accessing the slave port.
 *  0b011..This master has level 4 priority when accessing the slave port.
 *  0b100..This master has level 5 priority when accessing the slave port.
 *  0b101..This master has level 6 priority when accessing the slave port.
 *  0b110..This master has level 7 priority when accessing the slave port.
 *  0b111..This master has level 8 or lowest priority when accessing the slave port.
 */
#define AXBS_PRS6_M3(x)                          (((uint32_t)(((uint32_t)(x)) << AXBS_PRS6_M3_SHIFT)) & AXBS_PRS6_M3_MASK)

#define AXBS_PRS6_M4_MASK                        (0x70000U)
#define AXBS_PRS6_M4_SHIFT                       (16U)
/*! M4 - Master 4 Priority
 *  0b000..This master has level 1 or highest priority when accessing the slave port.
 *  0b001..This master has level 2 priority when accessing the slave port.
 *  0b010..This master has level 3 priority when accessing the slave port.
 *  0b011..This master has level 4 priority when accessing the slave port.
 *  0b100..This master has level 5 priority when accessing the slave port.
 *  0b101..This master has level 6 priority when accessing the slave port.
 *  0b110..This master has level 7 priority when accessing the slave port.
 *  0b111..This master has level 8 or lowest priority when accessing the slave port.
 */
#define AXBS_PRS6_M4(x)                          (((uint32_t)(((uint32_t)(x)) << AXBS_PRS6_M4_SHIFT)) & AXBS_PRS6_M4_MASK)

#define AXBS_PRS6_M5_MASK                        (0x700000U)
#define AXBS_PRS6_M5_SHIFT                       (20U)
/*! M5 - Master 5 Priority
 *  0b000..This master has level 1 or highest priority when accessing the slave port.
 *  0b001..This master has level 2 priority when accessing the slave port.
 *  0b010..This master has level 3 priority when accessing the slave port.
 *  0b011..This master has level 4 priority when accessing the slave port.
 *  0b100..This master has level 5 priority when accessing the slave port.
 *  0b101..This master has level 6 priority when accessing the slave port.
 *  0b110..This master has level 7 priority when accessing the slave port.
 *  0b111..This master has level 8 or lowest priority when accessing the slave port.
 */
#define AXBS_PRS6_M5(x)                          (((uint32_t)(((uint32_t)(x)) << AXBS_PRS6_M5_SHIFT)) & AXBS_PRS6_M5_MASK)
/*! @} */

/*! @name CRS6 - Control Register */
/*! @{ */

#define AXBS_CRS6_PARK_MASK                      (0x7U)
#define AXBS_CRS6_PARK_SHIFT                     (0U)
/*! PARK - Park
 *  0b111..Park on master port M0.
 *  0b001..Park on master port M1.
 *  0b010..Park on master port M2.
 *  0b011..Park on master port M3.
 *  0b100..Park on master port M4.
 *  0b101..Park on master port M5.
 */
#define AXBS_CRS6_PARK(x)                        (((uint32_t)(((uint32_t)(x)) << AXBS_CRS6_PARK_SHIFT)) & AXBS_CRS6_PARK_MASK)

#define AXBS_CRS6_PCTL_MASK                      (0x30U)
#define AXBS_CRS6_PCTL_SHIFT                     (4U)
/*! PCTL - Parking Control
 *  0b00..When no master makes a request, the arbiter parks the slave port on the master port defined by the PARK field.
 *  0b01..When no master makes a request, the arbiter parks the slave port on the last master to be in control of the slave port.
 *  0b10..When no master makes a request, the slave port is not parked on a master and the arbiter drives all outputs to a constant safe state.
 *  0b11..Reserved
 */
#define AXBS_CRS6_PCTL(x)                        (((uint32_t)(((uint32_t)(x)) << AXBS_CRS6_PCTL_SHIFT)) & AXBS_CRS6_PCTL_MASK)

#define AXBS_CRS6_ARB_MASK                       (0x300U)
#define AXBS_CRS6_ARB_SHIFT                      (8U)
/*! ARB - Arbitration Mode
 *  0b00..Fixed priority
 *  0b01..Round-robin(RR) or rotating priority
 *  0b10..Reserved
 *  0b11..Reserved
 */
#define AXBS_CRS6_ARB(x)                         (((uint32_t)(((uint32_t)(x)) << AXBS_CRS6_ARB_SHIFT)) & AXBS_CRS6_ARB_MASK)

#define AXBS_CRS6_HLP_MASK                       (0x40000000U)
#define AXBS_CRS6_HLP_SHIFT                      (30U)
/*! HLP - Halt Low Priority
 *  0b0..The low-power mode request has the highest priority for arbitration on this slave port.
 *  0b1..The low-power mode request has the lowest initial priority for arbitration on this slave port.
 */
#define AXBS_CRS6_HLP(x)                         (((uint32_t)(((uint32_t)(x)) << AXBS_CRS6_HLP_SHIFT)) & AXBS_CRS6_HLP_MASK)

#define AXBS_CRS6_RO_MASK                        (0x80000000U)
#define AXBS_CRS6_RO_SHIFT                       (31U)
/*! RO - Read Only
 *  0b0..The slave port's registers are writeable.
 *  0b1..The slave port's registers are read-only and cannot be written. Attempted writes have no effect on the
 *       registers and result in a bus error response.
 */
#define AXBS_CRS6_RO(x)                          (((uint32_t)(((uint32_t)(x)) << AXBS_CRS6_RO_SHIFT)) & AXBS_CRS6_RO_MASK)
/*! @} */

/*! @name PRS7 - Priority Slave Registers */
/*! @{ */

#define AXBS_PRS7_M0_MASK                        (0x7U)
#define AXBS_PRS7_M0_SHIFT                       (0U)
/*! M0 - Master 0 Priority
 *  0b000..This master has level 1 or highest priority when accessing the slave port.
 *  0b001..This master has level 2 priority when accessing the slave port.
 *  0b010..This master has level 3 priority when accessing the slave port.
 *  0b011..This master has level 4 priority when accessing the slave port.
 *  0b100..This master has level 5 priority when accessing the slave port.
 *  0b101..This master has level 6 priority when accessing the slave port.
 *  0b110..This master has level 7 priority when accessing the slave port.
 *  0b111..This master has level 8 or lowest priority when accessing the slave port.
 */
#define AXBS_PRS7_M0(x)                          (((uint32_t)(((uint32_t)(x)) << AXBS_PRS7_M0_SHIFT)) & AXBS_PRS7_M0_MASK)

#define AXBS_PRS7_M1_MASK                        (0x70U)
#define AXBS_PRS7_M1_SHIFT                       (4U)
/*! M1 - Master 1 Priority
 *  0b000..This master has level 1 or highest priority when accessing the slave port.
 *  0b001..This master has level 2 priority when accessing the slave port.
 *  0b010..This master has level 3 priority when accessing the slave port.
 *  0b011..This master has level 4 priority when accessing the slave port.
 *  0b100..This master has level 5 priority when accessing the slave port.
 *  0b101..This master has level 6 priority when accessing the slave port.
 *  0b110..This master has level 7 priority when accessing the slave port.
 *  0b111..This master has level 8 or lowest priority when accessing the slave port.
 */
#define AXBS_PRS7_M1(x)                          (((uint32_t)(((uint32_t)(x)) << AXBS_PRS7_M1_SHIFT)) & AXBS_PRS7_M1_MASK)

#define AXBS_PRS7_M2_MASK                        (0x700U)
#define AXBS_PRS7_M2_SHIFT                       (8U)
/*! M2 - Master 2 Priority
 *  0b000..This master has level 1 or highest priority when accessing the slave port.
 *  0b001..This master has level 2 priority when accessing the slave port.
 *  0b010..This master has level 3 priority when accessing the slave port.
 *  0b011..This master has level 4 priority when accessing the slave port.
 *  0b100..This master has level 5 priority when accessing the slave port.
 *  0b101..This master has level 6 priority when accessing the slave port.
 *  0b110..This master has level 7 priority when accessing the slave port.
 *  0b111..This master has level 8 or lowest priority when accessing the slave port.
 */
#define AXBS_PRS7_M2(x)                          (((uint32_t)(((uint32_t)(x)) << AXBS_PRS7_M2_SHIFT)) & AXBS_PRS7_M2_MASK)

#define AXBS_PRS7_M3_MASK                        (0x7000U)
#define AXBS_PRS7_M3_SHIFT                       (12U)
/*! M3 - Master 3 Priority
 *  0b000..This master has level 1 or highest priority when accessing the slave port.
 *  0b001..This master has level 2 priority when accessing the slave port.
 *  0b010..This master has level 3 priority when accessing the slave port.
 *  0b011..This master has level 4 priority when accessing the slave port.
 *  0b100..This master has level 5 priority when accessing the slave port.
 *  0b101..This master has level 6 priority when accessing the slave port.
 *  0b110..This master has level 7 priority when accessing the slave port.
 *  0b111..This master has level 8 or lowest priority when accessing the slave port.
 */
#define AXBS_PRS7_M3(x)                          (((uint32_t)(((uint32_t)(x)) << AXBS_PRS7_M3_SHIFT)) & AXBS_PRS7_M3_MASK)

#define AXBS_PRS7_M4_MASK                        (0x70000U)
#define AXBS_PRS7_M4_SHIFT                       (16U)
/*! M4 - Master 4 Priority
 *  0b000..This master has level 1 or highest priority when accessing the slave port.
 *  0b001..This master has level 2 priority when accessing the slave port.
 *  0b010..This master has level 3 priority when accessing the slave port.
 *  0b011..This master has level 4 priority when accessing the slave port.
 *  0b100..This master has level 5 priority when accessing the slave port.
 *  0b101..This master has level 6 priority when accessing the slave port.
 *  0b110..This master has level 7 priority when accessing the slave port.
 *  0b111..This master has level 8 or lowest priority when accessing the slave port.
 */
#define AXBS_PRS7_M4(x)                          (((uint32_t)(((uint32_t)(x)) << AXBS_PRS7_M4_SHIFT)) & AXBS_PRS7_M4_MASK)

#define AXBS_PRS7_M5_MASK                        (0x700000U)
#define AXBS_PRS7_M5_SHIFT                       (20U)
/*! M5 - Master 5 Priority
 *  0b000..This master has level 1 or highest priority when accessing the slave port.
 *  0b001..This master has level 2 priority when accessing the slave port.
 *  0b010..This master has level 3 priority when accessing the slave port.
 *  0b011..This master has level 4 priority when accessing the slave port.
 *  0b100..This master has level 5 priority when accessing the slave port.
 *  0b101..This master has level 6 priority when accessing the slave port.
 *  0b110..This master has level 7 priority when accessing the slave port.
 *  0b111..This master has level 8 or lowest priority when accessing the slave port.
 */
#define AXBS_PRS7_M5(x)                          (((uint32_t)(((uint32_t)(x)) << AXBS_PRS7_M5_SHIFT)) & AXBS_PRS7_M5_MASK)
/*! @} */

/*! @name CRS7 - Control Register */
/*! @{ */

#define AXBS_CRS7_PARK_MASK                      (0x7U)
#define AXBS_CRS7_PARK_SHIFT                     (0U)
/*! PARK - Park
 *  0b111..Park on master port M0.
 *  0b001..Park on master port M1.
 *  0b010..Park on master port M2.
 *  0b011..Park on master port M3.
 *  0b100..Park on master port M4.
 *  0b101..Park on master port M5.
 */
#define AXBS_CRS7_PARK(x)                        (((uint32_t)(((uint32_t)(x)) << AXBS_CRS7_PARK_SHIFT)) & AXBS_CRS7_PARK_MASK)

#define AXBS_CRS7_PCTL_MASK                      (0x30U)
#define AXBS_CRS7_PCTL_SHIFT                     (4U)
/*! PCTL - Parking Control
 *  0b00..When no master makes a request, the arbiter parks the slave port on the master port defined by the PARK field.
 *  0b01..When no master makes a request, the arbiter parks the slave port on the last master to be in control of the slave port.
 *  0b10..When no master makes a request, the slave port is not parked on a master and the arbiter drives all outputs to a constant safe state.
 *  0b11..Reserved
 */
#define AXBS_CRS7_PCTL(x)                        (((uint32_t)(((uint32_t)(x)) << AXBS_CRS7_PCTL_SHIFT)) & AXBS_CRS7_PCTL_MASK)

#define AXBS_CRS7_ARB_MASK                       (0x300U)
#define AXBS_CRS7_ARB_SHIFT                      (8U)
/*! ARB - Arbitration Mode
 *  0b00..Fixed priority
 *  0b01..Round-robin(RR) or rotating priority
 *  0b10..Reserved
 *  0b11..Reserved
 */
#define AXBS_CRS7_ARB(x)                         (((uint32_t)(((uint32_t)(x)) << AXBS_CRS7_ARB_SHIFT)) & AXBS_CRS7_ARB_MASK)

#define AXBS_CRS7_HLP_MASK                       (0x40000000U)
#define AXBS_CRS7_HLP_SHIFT                      (30U)
/*! HLP - Halt Low Priority
 *  0b0..The low-power mode request has the highest priority for arbitration on this slave port.
 *  0b1..The low-power mode request has the lowest initial priority for arbitration on this slave port.
 */
#define AXBS_CRS7_HLP(x)                         (((uint32_t)(((uint32_t)(x)) << AXBS_CRS7_HLP_SHIFT)) & AXBS_CRS7_HLP_MASK)

#define AXBS_CRS7_RO_MASK                        (0x80000000U)
#define AXBS_CRS7_RO_SHIFT                       (31U)
/*! RO - Read Only
 *  0b0..The slave port's registers are writeable.
 *  0b1..The slave port's registers are read-only and cannot be written. Attempted writes have no effect on the
 *       registers and result in a bus error response.
 */
#define AXBS_CRS7_RO(x)                          (((uint32_t)(((uint32_t)(x)) << AXBS_CRS7_RO_SHIFT)) & AXBS_CRS7_RO_MASK)
/*! @} */

/*! @name MGPCR0 - Master General Purpose Control Register */
/*! @{ */

#define AXBS_MGPCR0_AULB_MASK                    (0x7U)
#define AXBS_MGPCR0_AULB_SHIFT                   (0U)
/*! AULB - Arbitrates On Undefined Length Bursts
 *  0b000..No arbitration is allowed during an undefined length burst.
 *  0b001..Arbitration is allowed at any time during an undefined length burst.
 *  0b010..Arbitration is allowed after four beats of an undefined length burst.
 *  0b011..Arbitration is allowed after eight beats of an undefined length burst.
 *  0b100..Arbitration is allowed after 16 beats of an undefined length burst.
 *  0b101..Reserved
 *  0b110..Reserved
 *  0b111..Reserved
 */
#define AXBS_MGPCR0_AULB(x)                      (((uint32_t)(((uint32_t)(x)) << AXBS_MGPCR0_AULB_SHIFT)) & AXBS_MGPCR0_AULB_MASK)
/*! @} */

/*! @name MGPCR1 - Master General Purpose Control Register */
/*! @{ */

#define AXBS_MGPCR1_AULB_MASK                    (0x7U)
#define AXBS_MGPCR1_AULB_SHIFT                   (0U)
/*! AULB - Arbitrates On Undefined Length Bursts
 *  0b000..No arbitration is allowed during an undefined length burst.
 *  0b001..Arbitration is allowed at any time during an undefined length burst.
 *  0b010..Arbitration is allowed after four beats of an undefined length burst.
 *  0b011..Arbitration is allowed after eight beats of an undefined length burst.
 *  0b100..Arbitration is allowed after 16 beats of an undefined length burst.
 *  0b101..Reserved
 *  0b110..Reserved
 *  0b111..Reserved
 */
#define AXBS_MGPCR1_AULB(x)                      (((uint32_t)(((uint32_t)(x)) << AXBS_MGPCR1_AULB_SHIFT)) & AXBS_MGPCR1_AULB_MASK)
/*! @} */

/*! @name MGPCR2 - Master General Purpose Control Register */
/*! @{ */

#define AXBS_MGPCR2_AULB_MASK                    (0x7U)
#define AXBS_MGPCR2_AULB_SHIFT                   (0U)
/*! AULB - Arbitrates On Undefined Length Bursts
 *  0b000..No arbitration is allowed during an undefined length burst.
 *  0b001..Arbitration is allowed at any time during an undefined length burst.
 *  0b010..Arbitration is allowed after four beats of an undefined length burst.
 *  0b011..Arbitration is allowed after eight beats of an undefined length burst.
 *  0b100..Arbitration is allowed after 16 beats of an undefined length burst.
 *  0b101..Reserved
 *  0b110..Reserved
 *  0b111..Reserved
 */
#define AXBS_MGPCR2_AULB(x)                      (((uint32_t)(((uint32_t)(x)) << AXBS_MGPCR2_AULB_SHIFT)) & AXBS_MGPCR2_AULB_MASK)
/*! @} */

/*! @name MGPCR3 - Master General Purpose Control Register */
/*! @{ */

#define AXBS_MGPCR3_AULB_MASK                    (0x7U)
#define AXBS_MGPCR3_AULB_SHIFT                   (0U)
/*! AULB - Arbitrates On Undefined Length Bursts
 *  0b000..No arbitration is allowed during an undefined length burst.
 *  0b001..Arbitration is allowed at any time during an undefined length burst.
 *  0b010..Arbitration is allowed after four beats of an undefined length burst.
 *  0b011..Arbitration is allowed after eight beats of an undefined length burst.
 *  0b100..Arbitration is allowed after 16 beats of an undefined length burst.
 *  0b101..Reserved
 *  0b110..Reserved
 *  0b111..Reserved
 */
#define AXBS_MGPCR3_AULB(x)                      (((uint32_t)(((uint32_t)(x)) << AXBS_MGPCR3_AULB_SHIFT)) & AXBS_MGPCR3_AULB_MASK)
/*! @} */

/*! @name MGPCR4 - Master General Purpose Control Register */
/*! @{ */

#define AXBS_MGPCR4_AULB_MASK                    (0x7U)
#define AXBS_MGPCR4_AULB_SHIFT                   (0U)
/*! AULB - Arbitrates On Undefined Length Bursts
 *  0b000..No arbitration is allowed during an undefined length burst.
 *  0b001..Arbitration is allowed at any time during an undefined length burst.
 *  0b010..Arbitration is allowed after four beats of an undefined length burst.
 *  0b011..Arbitration is allowed after eight beats of an undefined length burst.
 *  0b100..Arbitration is allowed after 16 beats of an undefined length burst.
 *  0b101..Reserved
 *  0b110..Reserved
 *  0b111..Reserved
 */
#define AXBS_MGPCR4_AULB(x)                      (((uint32_t)(((uint32_t)(x)) << AXBS_MGPCR4_AULB_SHIFT)) & AXBS_MGPCR4_AULB_MASK)
/*! @} */

/*! @name MGPCR5 - Master General Purpose Control Register */
/*! @{ */

#define AXBS_MGPCR5_AULB_MASK                    (0x7U)
#define AXBS_MGPCR5_AULB_SHIFT                   (0U)
/*! AULB - Arbitrates On Undefined Length Bursts
 *  0b000..No arbitration is allowed during an undefined length burst.
 *  0b001..Arbitration is allowed at any time during an undefined length burst.
 *  0b010..Arbitration is allowed after four beats of an undefined length burst.
 *  0b011..Arbitration is allowed after eight beats of an undefined length burst.
 *  0b100..Arbitration is allowed after 16 beats of an undefined length burst.
 *  0b101..Reserved
 *  0b110..Reserved
 *  0b111..Reserved
 */
#define AXBS_MGPCR5_AULB(x)                      (((uint32_t)(((uint32_t)(x)) << AXBS_MGPCR5_AULB_SHIFT)) & AXBS_MGPCR5_AULB_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group AXBS_Register_Masks */


/* AXBS - Peripheral instance base addresses */
#if (defined(__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE & 0x2))
  /** Peripheral AXBS0 base address */
  #define AXBS0_BASE                               (0x50000000u)
  /** Peripheral AXBS0 base address */
  #define AXBS0_BASE_NS                            (0x40000000u)
  /** Peripheral AXBS0 base pointer */
  #define AXBS0                                    ((AXBS_Type *)AXBS0_BASE)
  /** Peripheral AXBS0 base pointer */
  #define AXBS0_NS                                 ((AXBS_Type *)AXBS0_BASE_NS)
  /** Array initializer of AXBS peripheral base addresses */
  #define AXBS_BASE_ADDRS                          { AXBS0_BASE }
  /** Array initializer of AXBS peripheral base pointers */
  #define AXBS_BASE_PTRS                           { AXBS0 }
  /** Array initializer of AXBS peripheral base addresses */
  #define AXBS_BASE_ADDRS_NS                       { AXBS0_BASE_NS }
  /** Array initializer of AXBS peripheral base pointers */
  #define AXBS_BASE_PTRS_NS                        { AXBS0_NS }
#else
  /** Peripheral AXBS0 base address */
  #define AXBS0_BASE                               (0x40000000u)
  /** Peripheral AXBS0 base pointer */
  #define AXBS0                                    ((AXBS_Type *)AXBS0_BASE)
  /** Array initializer of AXBS peripheral base addresses */
  #define AXBS_BASE_ADDRS                          { AXBS0_BASE }
  /** Array initializer of AXBS peripheral base pointers */
  #define AXBS_BASE_PTRS                           { AXBS0 }
#endif

/*!
 * @}
 */ /* end of group AXBS_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- BRIC Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup BRIC_Peripheral_Access_Layer BRIC Peripheral Access Layer
 * @{
 */

/** BRIC - Register Layout Typedef */
typedef struct {
  __O  uint32_t KEY0[4];                           /**< KEY0 Registers (PKB), array offset: 0x0, array step: 0x4 */
  __O  uint32_t KEY1[4];                           /**< KEY1 Registers (PKB), array offset: 0x10, array step: 0x4 */
  __IO uint32_t BRIC_CONFIG;                       /**< BRIC CONFIG register, offset: 0x20 */
} BRIC_Type;

/* ----------------------------------------------------------------------------
   -- BRIC Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup BRIC_Register_Masks BRIC Register Masks
 * @{
 */

/*! @name KEY0 - KEY0 Registers (PKB) */
/*! @{ */

#define BRIC_KEY0_KEY0_x_MASK                    (0xFFFFFFFFU)
#define BRIC_KEY0_KEY0_x_SHIFT                   (0U)
/*! KEY0_x - KEY0 written through PKB interface
 */
#define BRIC_KEY0_KEY0_x(x)                      (((uint32_t)(((uint32_t)(x)) << BRIC_KEY0_KEY0_x_SHIFT)) & BRIC_KEY0_KEY0_x_MASK)
/*! @} */

/* The count of BRIC_KEY0 */
#define BRIC_KEY0_COUNT                          (4U)

/*! @name KEY1 - KEY1 Registers (PKB) */
/*! @{ */

#define BRIC_KEY1_KEY1_x_MASK                    (0xFFFFFFFFU)
#define BRIC_KEY1_KEY1_x_SHIFT                   (0U)
/*! KEY1_x - KEY1 written through PKB interface
 */
#define BRIC_KEY1_KEY1_x(x)                      (((uint32_t)(((uint32_t)(x)) << BRIC_KEY1_KEY1_x_SHIFT)) & BRIC_KEY1_KEY1_x_MASK)
/*! @} */

/* The count of BRIC_KEY1 */
#define BRIC_KEY1_COUNT                          (4U)

/*! @name BRIC_CONFIG - BRIC CONFIG register */
/*! @{ */

#define BRIC_BRIC_CONFIG_KEY_INDEX_MASK          (0xFFU)
#define BRIC_BRIC_CONFIG_KEY_INDEX_SHIFT         (0U)
/*! KEY_INDEX - KEY INDEX
 */
#define BRIC_BRIC_CONFIG_KEY_INDEX(x)            (((uint32_t)(((uint32_t)(x)) << BRIC_BRIC_CONFIG_KEY_INDEX_SHIFT)) & BRIC_BRIC_CONFIG_KEY_INDEX_MASK)

#define BRIC_BRIC_CONFIG_IPS_XFR_ERR_EN_MASK     (0x100U)
#define BRIC_BRIC_CONFIG_IPS_XFR_ERR_EN_SHIFT    (8U)
#define BRIC_BRIC_CONFIG_IPS_XFR_ERR_EN(x)       (((uint32_t)(((uint32_t)(x)) << BRIC_BRIC_CONFIG_IPS_XFR_ERR_EN_SHIFT)) & BRIC_BRIC_CONFIG_IPS_XFR_ERR_EN_MASK)

#define BRIC_BRIC_CONFIG_IPS_XFR_WAIT_EN_MASK    (0x200U)
#define BRIC_BRIC_CONFIG_IPS_XFR_WAIT_EN_SHIFT   (9U)
#define BRIC_BRIC_CONFIG_IPS_XFR_WAIT_EN(x)      (((uint32_t)(((uint32_t)(x)) << BRIC_BRIC_CONFIG_IPS_XFR_WAIT_EN_SHIFT)) & BRIC_BRIC_CONFIG_IPS_XFR_WAIT_EN_MASK)

#define BRIC_BRIC_CONFIG_HI_MODE_MASK            (0x400U)
#define BRIC_BRIC_CONFIG_HI_MODE_SHIFT           (10U)
#define BRIC_BRIC_CONFIG_HI_MODE(x)              (((uint32_t)(((uint32_t)(x)) << BRIC_BRIC_CONFIG_HI_MODE_SHIFT)) & BRIC_BRIC_CONFIG_HI_MODE_MASK)

#define BRIC_BRIC_CONFIG_HI_READY_MASK           (0x800U)
#define BRIC_BRIC_CONFIG_HI_READY_SHIFT          (11U)
#define BRIC_BRIC_CONFIG_HI_READY(x)             (((uint32_t)(((uint32_t)(x)) << BRIC_BRIC_CONFIG_HI_READY_SHIFT)) & BRIC_BRIC_CONFIG_HI_READY_MASK)

#define BRIC_BRIC_CONFIG_DIS_PKB_ERR_RESP_MASK   (0x1000U)
#define BRIC_BRIC_CONFIG_DIS_PKB_ERR_RESP_SHIFT  (12U)
#define BRIC_BRIC_CONFIG_DIS_PKB_ERR_RESP(x)     (((uint32_t)(((uint32_t)(x)) << BRIC_BRIC_CONFIG_DIS_PKB_ERR_RESP_SHIFT)) & BRIC_BRIC_CONFIG_DIS_PKB_ERR_RESP_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group BRIC_Register_Masks */


/* BRIC - Peripheral instance base addresses */
#if (defined(__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE & 0x2))
  /** Peripheral BRIC base address */
  #define BRIC_BASE                                (0x58A06700u)
  /** Peripheral BRIC base address */
  #define BRIC_BASE_NS                             (0x48A06700u)
  /** Peripheral BRIC base pointer */
  #define BRIC                                     ((BRIC_Type *)BRIC_BASE)
  /** Peripheral BRIC base pointer */
  #define BRIC_NS                                  ((BRIC_Type *)BRIC_BASE_NS)
  /** Array initializer of BRIC peripheral base addresses */
  #define BRIC_BASE_ADDRS                          { BRIC_BASE }
  /** Array initializer of BRIC peripheral base pointers */
  #define BRIC_BASE_PTRS                           { BRIC }
  /** Array initializer of BRIC peripheral base addresses */
  #define BRIC_BASE_ADDRS_NS                       { BRIC_BASE_NS }
  /** Array initializer of BRIC peripheral base pointers */
  #define BRIC_BASE_PTRS_NS                        { BRIC_NS }
#else
  /** Peripheral BRIC base address */
  #define BRIC_BASE                                (0x48A06700u)
  /** Peripheral BRIC base pointer */
  #define BRIC                                     ((BRIC_Type *)BRIC_BASE)
  /** Array initializer of BRIC peripheral base addresses */
  #define BRIC_BASE_ADDRS                          { BRIC_BASE }
  /** Array initializer of BRIC peripheral base pointers */
  #define BRIC_BASE_PTRS                           { BRIC }
#endif

/*!
 * @}
 */ /* end of group BRIC_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- CAN Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CAN_Peripheral_Access_Layer CAN Peripheral Access Layer
 * @{
 */

/** CAN - Register Layout Typedef */
typedef struct {
  __IO uint32_t MCR;                               /**< Module Configuration Register, offset: 0x0 */
  __IO uint32_t CTRL1;                             /**< Control 1 Register, offset: 0x4 */
  __IO uint32_t TIMER;                             /**< Free Running Timer, offset: 0x8 */
       uint8_t RESERVED_0[4];
  __IO uint32_t RXMGMASK;                          /**< Rx Mailboxes Global Mask Register, offset: 0x10 */
  __IO uint32_t RX14MASK;                          /**< Rx 14 Mask Register, offset: 0x14 */
  __IO uint32_t RX15MASK;                          /**< Rx 15 Mask Register, offset: 0x18 */
  __IO uint32_t ECR;                               /**< Error Counter, offset: 0x1C */
  __IO uint32_t ESR1;                              /**< Error and Status 1 Register, offset: 0x20 */
       uint8_t RESERVED_1[4];
  __IO uint32_t IMASK1;                            /**< Interrupt Masks 1 Register, offset: 0x28 */
       uint8_t RESERVED_2[4];
  __IO uint32_t IFLAG1;                            /**< Interrupt Flags 1 Register, offset: 0x30 */
  __IO uint32_t CTRL2;                             /**< Control 2 Register, offset: 0x34 */
  __I  uint32_t ESR2;                              /**< Error and Status 2 Register, offset: 0x38 */
       uint8_t RESERVED_3[8];
  __I  uint32_t CRCR;                              /**< CRC Register, offset: 0x44 */
  __IO uint32_t RXFGMASK;                          /**< Legacy Rx FIFO Global Mask Register, offset: 0x48 */
  __I  uint32_t RXFIR;                             /**< Legacy Rx FIFO Information Register, offset: 0x4C */
  __IO uint32_t CBT;                               /**< CAN Bit Timing Register, offset: 0x50 */
       uint8_t RESERVED_4[44];
  union {                                          /* offset: 0x80 */
    struct {                                         /* offset: 0x80, array step: 0x10 */
      __IO uint32_t CS;                                /**< Message Buffer 0 CS Register..Message Buffer 31 CS Register, array offset: 0x80, array step: 0x10 */
      __IO uint32_t ID;                                /**< Message Buffer 0 ID Register..Message Buffer 31 ID Register, array offset: 0x84, array step: 0x10 */
      __IO uint32_t WORD[2];                           /**< Message Buffer 0 WORD_8B Register..Message Buffer 31 WORD_8B Register, array offset: 0x88, array step: index*0x10, index2*0x4 */
    } MB_8B[32];
    struct {                                         /* offset: 0x80, array step: 0x18 */
      __IO uint32_t CS;                                /**< Message Buffer 0 CS Register..Message Buffer 20 CS Register, array offset: 0x80, array step: 0x18 */
      __IO uint32_t ID;                                /**< Message Buffer 0 ID Register..Message Buffer 20 ID Register, array offset: 0x84, array step: 0x18 */
      __IO uint32_t WORD[4];                           /**< Message Buffer 0 WORD_16B Register..Message Buffer 20 WORD_16B Register, array offset: 0x88, array step: index*0x18, index2*0x4 */
    } MB_16B[21];
    struct {                                         /* offset: 0x80, array step: 0x28 */
      __IO uint32_t CS;                                /**< Message Buffer 0 CS Register..Message Buffer 11 CS Register, array offset: 0x80, array step: 0x28 */
      __IO uint32_t ID;                                /**< Message Buffer 0 ID Register..Message Buffer 11 ID Register, array offset: 0x84, array step: 0x28 */
      __IO uint32_t WORD[8];                           /**< Message Buffer 0 WORD_32B Register..Message Buffer 11 WORD_32B Register, array offset: 0x88, array step: index*0x28, index2*0x4 */
    } MB_32B[12];
    struct {                                         /* offset: 0x80, array step: 0x48 */
      __IO uint32_t CS;                                /**< Message Buffer 0 CS Register..Message Buffer 6 CS Register, array offset: 0x80, array step: 0x48 */
      __IO uint32_t ID;                                /**< Message Buffer 0 ID Register..Message Buffer 6 ID Register, array offset: 0x84, array step: 0x48 */
      __IO uint32_t WORD[16];                          /**< Message Buffer 0 WORD_64B Register..Message Buffer 6 WORD_64B Register, array offset: 0x88, array step: index*0x48, index2*0x4 */
    } MB_64B[7];
    struct {                                         /* offset: 0x80, array step: 0x10 */
      __IO uint32_t CS;                                /**< Message Buffer 0 CS Register..Message Buffer 31 CS Register, array offset: 0x80, array step: 0x10 */
      __IO uint32_t ID;                                /**< Message Buffer 0 ID Register..Message Buffer 31 ID Register, array offset: 0x84, array step: 0x10 */
      __IO uint32_t WORD0;                             /**< Message Buffer 0 WORD0 Register..Message Buffer 31 WORD0 Register, array offset: 0x88, array step: 0x10 */
      __IO uint32_t WORD1;                             /**< Message Buffer 0 WORD1 Register..Message Buffer 31 WORD1 Register, array offset: 0x8C, array step: 0x10 */
    } MB[32];
  };
       uint8_t RESERVED_5[1536];
  __IO uint32_t RXIMR[32];                         /**< Rx Individual Mask Registers, array offset: 0x880, array step: 0x4 */
       uint8_t RESERVED_6[512];
  __IO uint32_t CTRL1_PN;                          /**< Pretended Networking Control 1 Register, offset: 0xB00 */
  __IO uint32_t CTRL2_PN;                          /**< Pretended Networking Control 2 Register, offset: 0xB04 */
  __IO uint32_t WU_MTC;                            /**< Pretended Networking Wake Up Match Register, offset: 0xB08 */
  __IO uint32_t FLT_ID1;                           /**< Pretended Networking ID Filter 1 Register, offset: 0xB0C */
  __IO uint32_t FLT_DLC;                           /**< Pretended Networking DLC Filter Register, offset: 0xB10 */
  __IO uint32_t PL1_LO;                            /**< Pretended Networking Payload Low Filter 1 Register, offset: 0xB14 */
  __IO uint32_t PL1_HI;                            /**< Pretended Networking Payload High Filter 1 Register, offset: 0xB18 */
  __IO uint32_t FLT_ID2_IDMASK;                    /**< Pretended Networking ID Filter 2 Register / ID Mask Register, offset: 0xB1C */
  __IO uint32_t PL2_PLMASK_LO;                     /**< Pretended Networking Payload Low Filter 2 Register / Payload Low Mask register, offset: 0xB20 */
  __IO uint32_t PL2_PLMASK_HI;                     /**< Pretended Networking Payload High Filter 2 low order bits / Payload High Mask register, offset: 0xB24 */
       uint8_t RESERVED_7[24];
  struct {                                         /* offset: 0xB40, array step: 0x10 */
    __I  uint32_t CS;                                /**< Wake Up Message Buffer register for C/S, array offset: 0xB40, array step: 0x10 */
    __I  uint32_t ID;                                /**< Wake Up Message Buffer Register for ID, array offset: 0xB44, array step: 0x10 */
    __I  uint32_t D03;                               /**< Wake Up Message Buffer Register for Data 0-3, array offset: 0xB48, array step: 0x10 */
    __I  uint32_t D47;                               /**< Wake Up Message Buffer Register Data 4-7, array offset: 0xB4C, array step: 0x10 */
  } WMB[4];
       uint8_t RESERVED_8[112];
  __IO uint32_t EPRS;                              /**< Enhanced CAN Bit Timing Prescalers, offset: 0xBF0 */
  __IO uint32_t ENCBT;                             /**< Enhanced Nominal CAN Bit Timing, offset: 0xBF4 */
  __IO uint32_t EDCBT;                             /**< Enhanced Data Phase CAN bit Timing, offset: 0xBF8 */
  __IO uint32_t ETDC;                              /**< Enhanced Transceiver Delay Compensation, offset: 0xBFC */
  __IO uint32_t FDCTRL;                            /**< CAN FD Control Register, offset: 0xC00 */
  __IO uint32_t FDCBT;                             /**< CAN FD Bit Timing Register, offset: 0xC04 */
  __I  uint32_t FDCRC;                             /**< CAN FD CRC Register, offset: 0xC08 */
  __IO uint32_t ERFCR;                             /**< Enhanced Rx FIFO Control Register, offset: 0xC0C */
  __IO uint32_t ERFIER;                            /**< Enhanced Rx FIFO Interrupt Enable Register, offset: 0xC10 */
  __IO uint32_t ERFSR;                             /**< Enhanced Rx FIFO Status Register, offset: 0xC14 */
       uint8_t RESERVED_9[9192];
  __IO uint32_t ERFFEL[32];                        /**< Enhanced Rx FIFO Filter Element, array offset: 0x3000, array step: 0x4 */
} CAN_Type;

/* ----------------------------------------------------------------------------
   -- CAN Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CAN_Register_Masks CAN Register Masks
 * @{
 */

/*! @name MCR - Module Configuration Register */
/*! @{ */

#define CAN_MCR_MAXMB_MASK                       (0x7FU)
#define CAN_MCR_MAXMB_SHIFT                      (0U)
/*! MAXMB - Number Of The Last Message Buffer
 */
#define CAN_MCR_MAXMB(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_MCR_MAXMB_SHIFT)) & CAN_MCR_MAXMB_MASK)

#define CAN_MCR_IDAM_MASK                        (0x300U)
#define CAN_MCR_IDAM_SHIFT                       (8U)
/*! IDAM - ID Acceptance Mode
 *  0b00..Format A: One full ID (standard and extended) per ID filter table element.
 *  0b01..Format B: Two full standard IDs or two partial 14-bit (standard and extended) IDs per ID filter table element.
 *  0b10..Format C: Four partial 8-bit standard IDs per ID filter table element.
 *  0b11..Format D: All frames rejected.
 */
#define CAN_MCR_IDAM(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_MCR_IDAM_SHIFT)) & CAN_MCR_IDAM_MASK)

#define CAN_MCR_FDEN_MASK                        (0x800U)
#define CAN_MCR_FDEN_SHIFT                       (11U)
/*! FDEN - CAN FD operation enable
 *  0b1..CAN FD is enabled. FlexCAN is able to receive and transmit messages in both CAN FD and CAN 2.0 formats.
 *  0b0..CAN FD is disabled. FlexCAN is able to receive and transmit messages in CAN 2.0 format.
 */
#define CAN_MCR_FDEN(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_MCR_FDEN_SHIFT)) & CAN_MCR_FDEN_MASK)

#define CAN_MCR_AEN_MASK                         (0x1000U)
#define CAN_MCR_AEN_SHIFT                        (12U)
/*! AEN - Abort Enable
 *  0b0..Abort disabled.
 *  0b1..Abort enabled.
 */
#define CAN_MCR_AEN(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_MCR_AEN_SHIFT)) & CAN_MCR_AEN_MASK)

#define CAN_MCR_LPRIOEN_MASK                     (0x2000U)
#define CAN_MCR_LPRIOEN_SHIFT                    (13U)
/*! LPRIOEN - Local Priority Enable
 *  0b0..Local Priority disabled.
 *  0b1..Local Priority enabled.
 */
#define CAN_MCR_LPRIOEN(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_MCR_LPRIOEN_SHIFT)) & CAN_MCR_LPRIOEN_MASK)

#define CAN_MCR_PNET_EN_MASK                     (0x4000U)
#define CAN_MCR_PNET_EN_SHIFT                    (14U)
/*! PNET_EN - Pretended Networking Enable
 *  0b0..Pretended Networking mode is disabled.
 *  0b1..Pretended Networking mode is enabled.
 */
#define CAN_MCR_PNET_EN(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_MCR_PNET_EN_SHIFT)) & CAN_MCR_PNET_EN_MASK)

#define CAN_MCR_DMA_MASK                         (0x8000U)
#define CAN_MCR_DMA_SHIFT                        (15U)
/*! DMA - DMA Enable
 *  0b0..DMA feature for Legacy RX FIFO or Enhanced Rx FIFO disabled.
 *  0b1..DMA feature for Legacy RX FIFO or Enhanced Rx FIFO enabled.
 */
#define CAN_MCR_DMA(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_MCR_DMA_SHIFT)) & CAN_MCR_DMA_MASK)

#define CAN_MCR_IRMQ_MASK                        (0x10000U)
#define CAN_MCR_IRMQ_SHIFT                       (16U)
/*! IRMQ - Individual Rx Masking And Queue Enable
 *  0b0..Individual Rx masking and queue feature are disabled. For backward compatibility with legacy
 *       applications, the reading of C/S word locks the MB even if it is EMPTY.
 *  0b1..Individual Rx masking and queue feature are enabled.
 */
#define CAN_MCR_IRMQ(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_MCR_IRMQ_SHIFT)) & CAN_MCR_IRMQ_MASK)

#define CAN_MCR_SRXDIS_MASK                      (0x20000U)
#define CAN_MCR_SRXDIS_SHIFT                     (17U)
/*! SRXDIS - Self Reception Disable
 *  0b0..Self-reception enabled.
 *  0b1..Self-reception disabled.
 */
#define CAN_MCR_SRXDIS(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_MCR_SRXDIS_SHIFT)) & CAN_MCR_SRXDIS_MASK)

#define CAN_MCR_DOZE_MASK                        (0x40000U)
#define CAN_MCR_DOZE_SHIFT                       (18U)
/*! DOZE - Doze Mode Enable
 *  0b0..FlexCAN is not enabled to enter low-power mode when Doze mode is requested.
 *  0b1..FlexCAN is enabled to enter low-power mode when Doze mode is requested.
 */
#define CAN_MCR_DOZE(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_MCR_DOZE_SHIFT)) & CAN_MCR_DOZE_MASK)

#define CAN_MCR_WAKSRC_MASK                      (0x80000U)
#define CAN_MCR_WAKSRC_SHIFT                     (19U)
/*! WAKSRC - Wake Up Source
 *  0b0..FlexCAN uses the unfiltered Rx input to detect recessive to dominant edges on the CAN bus.
 *  0b1..FlexCAN uses the filtered Rx input to detect recessive to dominant edges on the CAN bus.
 */
#define CAN_MCR_WAKSRC(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_MCR_WAKSRC_SHIFT)) & CAN_MCR_WAKSRC_MASK)

#define CAN_MCR_LPMACK_MASK                      (0x100000U)
#define CAN_MCR_LPMACK_SHIFT                     (20U)
/*! LPMACK - Low-Power Mode Acknowledge
 *  0b0..FlexCAN is not in a low-power mode.
 *  0b1..FlexCAN is in a low-power mode.
 */
#define CAN_MCR_LPMACK(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_MCR_LPMACK_SHIFT)) & CAN_MCR_LPMACK_MASK)

#define CAN_MCR_WRNEN_MASK                       (0x200000U)
#define CAN_MCR_WRNEN_SHIFT                      (21U)
/*! WRNEN - Warning Interrupt Enable
 *  0b0..TWRNINT and RWRNINT bits are zero, independent of the values in the error counters.
 *  0b1..TWRNINT and RWRNINT bits are set when the respective error counter transitions from less than 96 to greater than or equal to 96.
 */
#define CAN_MCR_WRNEN(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_MCR_WRNEN_SHIFT)) & CAN_MCR_WRNEN_MASK)

#define CAN_MCR_SLFWAK_MASK                      (0x400000U)
#define CAN_MCR_SLFWAK_SHIFT                     (22U)
/*! SLFWAK - Self Wake Up
 *  0b0..FlexCAN Self Wake Up feature is disabled.
 *  0b1..FlexCAN Self Wake Up feature is enabled.
 */
#define CAN_MCR_SLFWAK(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_MCR_SLFWAK_SHIFT)) & CAN_MCR_SLFWAK_MASK)

#define CAN_MCR_FRZACK_MASK                      (0x1000000U)
#define CAN_MCR_FRZACK_SHIFT                     (24U)
/*! FRZACK - Freeze Mode Acknowledge
 *  0b0..FlexCAN not in Freeze mode, prescaler running.
 *  0b1..FlexCAN in Freeze mode, prescaler stopped.
 */
#define CAN_MCR_FRZACK(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_MCR_FRZACK_SHIFT)) & CAN_MCR_FRZACK_MASK)

#define CAN_MCR_SOFTRST_MASK                     (0x2000000U)
#define CAN_MCR_SOFTRST_SHIFT                    (25U)
/*! SOFTRST - Soft Reset
 *  0b0..No reset request.
 *  0b1..Resets the registers affected by soft reset.
 */
#define CAN_MCR_SOFTRST(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_MCR_SOFTRST_SHIFT)) & CAN_MCR_SOFTRST_MASK)

#define CAN_MCR_WAKMSK_MASK                      (0x4000000U)
#define CAN_MCR_WAKMSK_SHIFT                     (26U)
/*! WAKMSK - Wake Up Interrupt Mask
 *  0b0..Wake Up interrupt is disabled.
 *  0b1..Wake Up interrupt is enabled.
 */
#define CAN_MCR_WAKMSK(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_MCR_WAKMSK_SHIFT)) & CAN_MCR_WAKMSK_MASK)

#define CAN_MCR_NOTRDY_MASK                      (0x8000000U)
#define CAN_MCR_NOTRDY_SHIFT                     (27U)
/*! NOTRDY - FlexCAN Not Ready
 *  0b0..FlexCAN module is either in Normal mode, Listen-Only mode, or Loop-Back mode.
 *  0b1..FlexCAN module is either in Disable mode, Doze mode, Stop mode, or Freeze mode.
 */
#define CAN_MCR_NOTRDY(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_MCR_NOTRDY_SHIFT)) & CAN_MCR_NOTRDY_MASK)

#define CAN_MCR_HALT_MASK                        (0x10000000U)
#define CAN_MCR_HALT_SHIFT                       (28U)
/*! HALT - Halt FlexCAN
 *  0b0..No Freeze mode request.
 *  0b1..Enters Freeze mode if the FRZ bit is asserted.
 */
#define CAN_MCR_HALT(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_MCR_HALT_SHIFT)) & CAN_MCR_HALT_MASK)

#define CAN_MCR_RFEN_MASK                        (0x20000000U)
#define CAN_MCR_RFEN_SHIFT                       (29U)
/*! RFEN - Legacy Rx FIFO Enable
 *  0b0..Legacy Rx FIFO not enabled.
 *  0b1..Legacy Rx FIFO enabled.
 */
#define CAN_MCR_RFEN(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_MCR_RFEN_SHIFT)) & CAN_MCR_RFEN_MASK)

#define CAN_MCR_FRZ_MASK                         (0x40000000U)
#define CAN_MCR_FRZ_SHIFT                        (30U)
/*! FRZ - Freeze Enable
 *  0b0..Not enabled to enter Freeze mode.
 *  0b1..Enabled to enter Freeze mode.
 */
#define CAN_MCR_FRZ(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_MCR_FRZ_SHIFT)) & CAN_MCR_FRZ_MASK)

#define CAN_MCR_MDIS_MASK                        (0x80000000U)
#define CAN_MCR_MDIS_SHIFT                       (31U)
/*! MDIS - Module Disable
 *  0b0..Enable the FlexCAN module.
 *  0b1..Disable the FlexCAN module.
 */
#define CAN_MCR_MDIS(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_MCR_MDIS_SHIFT)) & CAN_MCR_MDIS_MASK)
/*! @} */

/*! @name CTRL1 - Control 1 Register */
/*! @{ */

#define CAN_CTRL1_PROPSEG_MASK                   (0x7U)
#define CAN_CTRL1_PROPSEG_SHIFT                  (0U)
/*! PROPSEG - Propagation Segment
 */
#define CAN_CTRL1_PROPSEG(x)                     (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_PROPSEG_SHIFT)) & CAN_CTRL1_PROPSEG_MASK)

#define CAN_CTRL1_LOM_MASK                       (0x8U)
#define CAN_CTRL1_LOM_SHIFT                      (3U)
/*! LOM - Listen-Only Mode
 *  0b0..Listen-Only mode is deactivated.
 *  0b1..FlexCAN module operates in Listen-Only mode.
 */
#define CAN_CTRL1_LOM(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_LOM_SHIFT)) & CAN_CTRL1_LOM_MASK)

#define CAN_CTRL1_LBUF_MASK                      (0x10U)
#define CAN_CTRL1_LBUF_SHIFT                     (4U)
/*! LBUF - Lowest Buffer Transmitted First
 *  0b0..Buffer with highest priority is transmitted first.
 *  0b1..Lowest number buffer is transmitted first.
 */
#define CAN_CTRL1_LBUF(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_LBUF_SHIFT)) & CAN_CTRL1_LBUF_MASK)

#define CAN_CTRL1_TSYN_MASK                      (0x20U)
#define CAN_CTRL1_TSYN_SHIFT                     (5U)
/*! TSYN - Timer Sync
 *  0b0..Timer sync feature disabled
 *  0b1..Timer sync feature enabled
 */
#define CAN_CTRL1_TSYN(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_TSYN_SHIFT)) & CAN_CTRL1_TSYN_MASK)

#define CAN_CTRL1_BOFFREC_MASK                   (0x40U)
#define CAN_CTRL1_BOFFREC_SHIFT                  (6U)
/*! BOFFREC - Bus Off Recovery
 *  0b0..Automatic recovering from Bus Off state enabled.
 *  0b1..Automatic recovering from Bus Off state disabled.
 */
#define CAN_CTRL1_BOFFREC(x)                     (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_BOFFREC_SHIFT)) & CAN_CTRL1_BOFFREC_MASK)

#define CAN_CTRL1_SMP_MASK                       (0x80U)
#define CAN_CTRL1_SMP_SHIFT                      (7U)
/*! SMP - CAN Bit Sampling
 *  0b0..Just one sample is used to determine the bit value.
 *  0b1..Three samples are used to determine the value of the received bit: the regular one (sample point) and two
 *       preceding samples; a majority rule is used.
 */
#define CAN_CTRL1_SMP(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_SMP_SHIFT)) & CAN_CTRL1_SMP_MASK)

#define CAN_CTRL1_RWRNMSK_MASK                   (0x400U)
#define CAN_CTRL1_RWRNMSK_SHIFT                  (10U)
/*! RWRNMSK - Rx Warning Interrupt Mask
 *  0b0..Rx Warning interrupt disabled.
 *  0b1..Rx Warning interrupt enabled.
 */
#define CAN_CTRL1_RWRNMSK(x)                     (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_RWRNMSK_SHIFT)) & CAN_CTRL1_RWRNMSK_MASK)

#define CAN_CTRL1_TWRNMSK_MASK                   (0x800U)
#define CAN_CTRL1_TWRNMSK_SHIFT                  (11U)
/*! TWRNMSK - Tx Warning Interrupt Mask
 *  0b0..Tx Warning interrupt disabled.
 *  0b1..Tx Warning interrupt enabled.
 */
#define CAN_CTRL1_TWRNMSK(x)                     (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_TWRNMSK_SHIFT)) & CAN_CTRL1_TWRNMSK_MASK)

#define CAN_CTRL1_LPB_MASK                       (0x1000U)
#define CAN_CTRL1_LPB_SHIFT                      (12U)
/*! LPB - Loop Back Mode
 *  0b0..Loop Back disabled.
 *  0b1..Loop Back enabled.
 */
#define CAN_CTRL1_LPB(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_LPB_SHIFT)) & CAN_CTRL1_LPB_MASK)

#define CAN_CTRL1_ERRMSK_MASK                    (0x4000U)
#define CAN_CTRL1_ERRMSK_SHIFT                   (14U)
/*! ERRMSK - Error Interrupt Mask
 *  0b0..Error interrupt disabled.
 *  0b1..Error interrupt enabled.
 */
#define CAN_CTRL1_ERRMSK(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_ERRMSK_SHIFT)) & CAN_CTRL1_ERRMSK_MASK)

#define CAN_CTRL1_BOFFMSK_MASK                   (0x8000U)
#define CAN_CTRL1_BOFFMSK_SHIFT                  (15U)
/*! BOFFMSK - Bus Off Interrupt Mask
 *  0b0..Bus Off interrupt disabled.
 *  0b1..Bus Off interrupt enabled.
 */
#define CAN_CTRL1_BOFFMSK(x)                     (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_BOFFMSK_SHIFT)) & CAN_CTRL1_BOFFMSK_MASK)

#define CAN_CTRL1_PSEG2_MASK                     (0x70000U)
#define CAN_CTRL1_PSEG2_SHIFT                    (16U)
/*! PSEG2 - Phase Segment 2
 */
#define CAN_CTRL1_PSEG2(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_PSEG2_SHIFT)) & CAN_CTRL1_PSEG2_MASK)

#define CAN_CTRL1_PSEG1_MASK                     (0x380000U)
#define CAN_CTRL1_PSEG1_SHIFT                    (19U)
/*! PSEG1 - Phase Segment 1
 */
#define CAN_CTRL1_PSEG1(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_PSEG1_SHIFT)) & CAN_CTRL1_PSEG1_MASK)

#define CAN_CTRL1_RJW_MASK                       (0xC00000U)
#define CAN_CTRL1_RJW_SHIFT                      (22U)
/*! RJW - Resync Jump Width
 */
#define CAN_CTRL1_RJW(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_RJW_SHIFT)) & CAN_CTRL1_RJW_MASK)

#define CAN_CTRL1_PRESDIV_MASK                   (0xFF000000U)
#define CAN_CTRL1_PRESDIV_SHIFT                  (24U)
/*! PRESDIV - Prescaler Division Factor
 */
#define CAN_CTRL1_PRESDIV(x)                     (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_PRESDIV_SHIFT)) & CAN_CTRL1_PRESDIV_MASK)
/*! @} */

/*! @name TIMER - Free Running Timer */
/*! @{ */

#define CAN_TIMER_TIMER_MASK                     (0xFFFFU)
#define CAN_TIMER_TIMER_SHIFT                    (0U)
/*! TIMER - Timer Value
 */
#define CAN_TIMER_TIMER(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_TIMER_TIMER_SHIFT)) & CAN_TIMER_TIMER_MASK)
/*! @} */

/*! @name RXMGMASK - Rx Mailboxes Global Mask Register */
/*! @{ */

#define CAN_RXMGMASK_MG_MASK                     (0xFFFFFFFFU)
#define CAN_RXMGMASK_MG_SHIFT                    (0U)
/*! MG - Rx Mailboxes Global Mask Bits
 */
#define CAN_RXMGMASK_MG(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_RXMGMASK_MG_SHIFT)) & CAN_RXMGMASK_MG_MASK)
/*! @} */

/*! @name RX14MASK - Rx 14 Mask Register */
/*! @{ */

#define CAN_RX14MASK_RX14M_MASK                  (0xFFFFFFFFU)
#define CAN_RX14MASK_RX14M_SHIFT                 (0U)
/*! RX14M - Rx Buffer 14 Mask Bits
 */
#define CAN_RX14MASK_RX14M(x)                    (((uint32_t)(((uint32_t)(x)) << CAN_RX14MASK_RX14M_SHIFT)) & CAN_RX14MASK_RX14M_MASK)
/*! @} */

/*! @name RX15MASK - Rx 15 Mask Register */
/*! @{ */

#define CAN_RX15MASK_RX15M_MASK                  (0xFFFFFFFFU)
#define CAN_RX15MASK_RX15M_SHIFT                 (0U)
/*! RX15M - Rx Buffer 15 Mask Bits
 */
#define CAN_RX15MASK_RX15M(x)                    (((uint32_t)(((uint32_t)(x)) << CAN_RX15MASK_RX15M_SHIFT)) & CAN_RX15MASK_RX15M_MASK)
/*! @} */

/*! @name ECR - Error Counter */
/*! @{ */

#define CAN_ECR_TXERRCNT_MASK                    (0xFFU)
#define CAN_ECR_TXERRCNT_SHIFT                   (0U)
/*! TXERRCNT - Transmit Error Counter
 */
#define CAN_ECR_TXERRCNT(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_ECR_TXERRCNT_SHIFT)) & CAN_ECR_TXERRCNT_MASK)

#define CAN_ECR_RXERRCNT_MASK                    (0xFF00U)
#define CAN_ECR_RXERRCNT_SHIFT                   (8U)
/*! RXERRCNT - Receive Error Counter
 */
#define CAN_ECR_RXERRCNT(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_ECR_RXERRCNT_SHIFT)) & CAN_ECR_RXERRCNT_MASK)

#define CAN_ECR_TXERRCNT_FAST_MASK               (0xFF0000U)
#define CAN_ECR_TXERRCNT_FAST_SHIFT              (16U)
/*! TXERRCNT_FAST - Transmit Error Counter for fast bits
 */
#define CAN_ECR_TXERRCNT_FAST(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_ECR_TXERRCNT_FAST_SHIFT)) & CAN_ECR_TXERRCNT_FAST_MASK)

#define CAN_ECR_RXERRCNT_FAST_MASK               (0xFF000000U)
#define CAN_ECR_RXERRCNT_FAST_SHIFT              (24U)
/*! RXERRCNT_FAST - Receive Error Counter for fast bits
 */
#define CAN_ECR_RXERRCNT_FAST(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_ECR_RXERRCNT_FAST_SHIFT)) & CAN_ECR_RXERRCNT_FAST_MASK)
/*! @} */

/*! @name ESR1 - Error and Status 1 Register */
/*! @{ */

#define CAN_ESR1_WAKINT_MASK                     (0x1U)
#define CAN_ESR1_WAKINT_SHIFT                    (0U)
/*! WAKINT - Wake-Up Interrupt
 *  0b0..No such occurrence.
 *  0b1..Indicates a recessive to dominant transition was received on the CAN bus.
 */
#define CAN_ESR1_WAKINT(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_WAKINT_SHIFT)) & CAN_ESR1_WAKINT_MASK)

#define CAN_ESR1_ERRINT_MASK                     (0x2U)
#define CAN_ESR1_ERRINT_SHIFT                    (1U)
/*! ERRINT - Error Interrupt
 *  0b0..No such occurrence.
 *  0b1..Indicates setting of any error bit in the Error and Status register.
 */
#define CAN_ESR1_ERRINT(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_ERRINT_SHIFT)) & CAN_ESR1_ERRINT_MASK)

#define CAN_ESR1_BOFFINT_MASK                    (0x4U)
#define CAN_ESR1_BOFFINT_SHIFT                   (2U)
/*! BOFFINT - Bus Off Interrupt
 *  0b0..No such occurrence.
 *  0b1..FlexCAN module entered Bus Off state.
 */
#define CAN_ESR1_BOFFINT(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_BOFFINT_SHIFT)) & CAN_ESR1_BOFFINT_MASK)

#define CAN_ESR1_RX_MASK                         (0x8U)
#define CAN_ESR1_RX_SHIFT                        (3U)
/*! RX - FlexCAN In Reception
 *  0b0..FlexCAN is not receiving a message.
 *  0b1..FlexCAN is receiving a message.
 */
#define CAN_ESR1_RX(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_RX_SHIFT)) & CAN_ESR1_RX_MASK)

#define CAN_ESR1_FLTCONF_MASK                    (0x30U)
#define CAN_ESR1_FLTCONF_SHIFT                   (4U)
/*! FLTCONF - Fault Confinement State
 *  0b00..Error Active
 *  0b01..Error Passive
 *  0b1x..Bus Off
 */
#define CAN_ESR1_FLTCONF(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_FLTCONF_SHIFT)) & CAN_ESR1_FLTCONF_MASK)

#define CAN_ESR1_TX_MASK                         (0x40U)
#define CAN_ESR1_TX_SHIFT                        (6U)
/*! TX - FlexCAN In Transmission
 *  0b0..FlexCAN is not transmitting a message.
 *  0b1..FlexCAN is transmitting a message.
 */
#define CAN_ESR1_TX(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_TX_SHIFT)) & CAN_ESR1_TX_MASK)

#define CAN_ESR1_IDLE_MASK                       (0x80U)
#define CAN_ESR1_IDLE_SHIFT                      (7U)
/*! IDLE - IDLE
 *  0b0..No such occurrence.
 *  0b1..CAN bus is now IDLE.
 */
#define CAN_ESR1_IDLE(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_IDLE_SHIFT)) & CAN_ESR1_IDLE_MASK)

#define CAN_ESR1_RXWRN_MASK                      (0x100U)
#define CAN_ESR1_RXWRN_SHIFT                     (8U)
/*! RXWRN - Rx Error Warning
 *  0b0..No such occurrence.
 *  0b1..RXERRCNT is greater than or equal to 96.
 */
#define CAN_ESR1_RXWRN(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_RXWRN_SHIFT)) & CAN_ESR1_RXWRN_MASK)

#define CAN_ESR1_TXWRN_MASK                      (0x200U)
#define CAN_ESR1_TXWRN_SHIFT                     (9U)
/*! TXWRN - TX Error Warning
 *  0b0..No such occurrence.
 *  0b1..TXERRCNT is greater than or equal to 96.
 */
#define CAN_ESR1_TXWRN(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_TXWRN_SHIFT)) & CAN_ESR1_TXWRN_MASK)

#define CAN_ESR1_STFERR_MASK                     (0x400U)
#define CAN_ESR1_STFERR_SHIFT                    (10U)
/*! STFERR - Stuffing Error
 *  0b0..No such occurrence.
 *  0b1..A stuffing error occurred since last read of this register.
 */
#define CAN_ESR1_STFERR(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_STFERR_SHIFT)) & CAN_ESR1_STFERR_MASK)

#define CAN_ESR1_FRMERR_MASK                     (0x800U)
#define CAN_ESR1_FRMERR_SHIFT                    (11U)
/*! FRMERR - Form Error
 *  0b0..No such occurrence.
 *  0b1..A Form Error occurred since last read of this register.
 */
#define CAN_ESR1_FRMERR(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_FRMERR_SHIFT)) & CAN_ESR1_FRMERR_MASK)

#define CAN_ESR1_CRCERR_MASK                     (0x1000U)
#define CAN_ESR1_CRCERR_SHIFT                    (12U)
/*! CRCERR - Cyclic Redundancy Check Error
 *  0b0..No such occurrence.
 *  0b1..A CRC error occurred since last read of this register.
 */
#define CAN_ESR1_CRCERR(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_CRCERR_SHIFT)) & CAN_ESR1_CRCERR_MASK)

#define CAN_ESR1_ACKERR_MASK                     (0x2000U)
#define CAN_ESR1_ACKERR_SHIFT                    (13U)
/*! ACKERR - Acknowledge Error
 *  0b0..No such occurrence.
 *  0b1..An ACK error occurred since last read of this register.
 */
#define CAN_ESR1_ACKERR(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_ACKERR_SHIFT)) & CAN_ESR1_ACKERR_MASK)

#define CAN_ESR1_BIT0ERR_MASK                    (0x4000U)
#define CAN_ESR1_BIT0ERR_SHIFT                   (14U)
/*! BIT0ERR - Bit0 Error
 *  0b0..No such occurrence.
 *  0b1..At least one bit sent as dominant is received as recessive.
 */
#define CAN_ESR1_BIT0ERR(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_BIT0ERR_SHIFT)) & CAN_ESR1_BIT0ERR_MASK)

#define CAN_ESR1_BIT1ERR_MASK                    (0x8000U)
#define CAN_ESR1_BIT1ERR_SHIFT                   (15U)
/*! BIT1ERR - Bit1 Error
 *  0b0..No such occurrence.
 *  0b1..At least one bit sent as recessive is received as dominant.
 */
#define CAN_ESR1_BIT1ERR(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_BIT1ERR_SHIFT)) & CAN_ESR1_BIT1ERR_MASK)

#define CAN_ESR1_RWRNINT_MASK                    (0x10000U)
#define CAN_ESR1_RWRNINT_SHIFT                   (16U)
/*! RWRNINT - Rx Warning Interrupt Flag
 *  0b0..No such occurrence.
 *  0b1..The Rx error counter transitioned from less than 96 to greater than or equal to 96.
 */
#define CAN_ESR1_RWRNINT(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_RWRNINT_SHIFT)) & CAN_ESR1_RWRNINT_MASK)

#define CAN_ESR1_TWRNINT_MASK                    (0x20000U)
#define CAN_ESR1_TWRNINT_SHIFT                   (17U)
/*! TWRNINT - Tx Warning Interrupt Flag
 *  0b0..No such occurrence.
 *  0b1..The Tx error counter transitioned from less than 96 to greater than or equal to 96.
 */
#define CAN_ESR1_TWRNINT(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_TWRNINT_SHIFT)) & CAN_ESR1_TWRNINT_MASK)

#define CAN_ESR1_SYNCH_MASK                      (0x40000U)
#define CAN_ESR1_SYNCH_SHIFT                     (18U)
/*! SYNCH - CAN Synchronization Status
 *  0b0..FlexCAN is not synchronized to the CAN bus.
 *  0b1..FlexCAN is synchronized to the CAN bus.
 */
#define CAN_ESR1_SYNCH(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_SYNCH_SHIFT)) & CAN_ESR1_SYNCH_MASK)

#define CAN_ESR1_BOFFDONEINT_MASK                (0x80000U)
#define CAN_ESR1_BOFFDONEINT_SHIFT               (19U)
/*! BOFFDONEINT - Bus Off Done Interrupt
 *  0b0..No such occurrence.
 *  0b1..FlexCAN module has completed Bus Off process.
 */
#define CAN_ESR1_BOFFDONEINT(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_BOFFDONEINT_SHIFT)) & CAN_ESR1_BOFFDONEINT_MASK)

#define CAN_ESR1_ERRINT_FAST_MASK                (0x100000U)
#define CAN_ESR1_ERRINT_FAST_SHIFT               (20U)
/*! ERRINT_FAST - Error interrupt for errors detected in Data Phase of CAN FD frames with BRS bit set
 *  0b0..No such occurrence.
 *  0b1..Indicates setting of any error bit detected in the data phase of CAN FD frames with the BRS bit set.
 */
#define CAN_ESR1_ERRINT_FAST(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_ERRINT_FAST_SHIFT)) & CAN_ESR1_ERRINT_FAST_MASK)

#define CAN_ESR1_ERROVR_MASK                     (0x200000U)
#define CAN_ESR1_ERROVR_SHIFT                    (21U)
/*! ERROVR - Error Overrun
 *  0b0..Overrun has not occurred.
 *  0b1..Overrun has occurred.
 */
#define CAN_ESR1_ERROVR(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_ERROVR_SHIFT)) & CAN_ESR1_ERROVR_MASK)

#define CAN_ESR1_STFERR_FAST_MASK                (0x4000000U)
#define CAN_ESR1_STFERR_FAST_SHIFT               (26U)
/*! STFERR_FAST - Stuffing Error in the Data Phase of CAN FD frames with the BRS bit set
 *  0b0..No such occurrence.
 *  0b1..A stuffing error occurred since last read of this register.
 */
#define CAN_ESR1_STFERR_FAST(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_STFERR_FAST_SHIFT)) & CAN_ESR1_STFERR_FAST_MASK)

#define CAN_ESR1_FRMERR_FAST_MASK                (0x8000000U)
#define CAN_ESR1_FRMERR_FAST_SHIFT               (27U)
/*! FRMERR_FAST - Form Error in the Data Phase of CAN FD frames with the BRS bit set
 *  0b0..No such occurrence.
 *  0b1..A form error occurred since last read of this register.
 */
#define CAN_ESR1_FRMERR_FAST(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_FRMERR_FAST_SHIFT)) & CAN_ESR1_FRMERR_FAST_MASK)

#define CAN_ESR1_CRCERR_FAST_MASK                (0x10000000U)
#define CAN_ESR1_CRCERR_FAST_SHIFT               (28U)
/*! CRCERR_FAST - Cyclic Redundancy Check Error in the CRC field of CAN FD frames with the BRS bit set
 *  0b0..No such occurrence.
 *  0b1..A CRC error occurred since last read of this register.
 */
#define CAN_ESR1_CRCERR_FAST(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_CRCERR_FAST_SHIFT)) & CAN_ESR1_CRCERR_FAST_MASK)

#define CAN_ESR1_BIT0ERR_FAST_MASK               (0x40000000U)
#define CAN_ESR1_BIT0ERR_FAST_SHIFT              (30U)
/*! BIT0ERR_FAST - Bit0 Error in the Data Phase of CAN FD frames with the BRS bit set
 *  0b0..No such occurrence.
 *  0b1..At least one bit sent as dominant is received as recessive.
 */
#define CAN_ESR1_BIT0ERR_FAST(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_BIT0ERR_FAST_SHIFT)) & CAN_ESR1_BIT0ERR_FAST_MASK)

#define CAN_ESR1_BIT1ERR_FAST_MASK               (0x80000000U)
#define CAN_ESR1_BIT1ERR_FAST_SHIFT              (31U)
/*! BIT1ERR_FAST - Bit1 Error in the Data Phase of CAN FD frames with the BRS bit set
 *  0b0..No such occurrence.
 *  0b1..At least one bit sent as recessive is received as dominant.
 */
#define CAN_ESR1_BIT1ERR_FAST(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_ESR1_BIT1ERR_FAST_SHIFT)) & CAN_ESR1_BIT1ERR_FAST_MASK)
/*! @} */

/*! @name IMASK1 - Interrupt Masks 1 Register */
/*! @{ */

#define CAN_IMASK1_BUF31TO0M_MASK                (0xFFFFFFFFU)
#define CAN_IMASK1_BUF31TO0M_SHIFT               (0U)
/*! BUF31TO0M - Buffer MBi Mask
 */
#define CAN_IMASK1_BUF31TO0M(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_IMASK1_BUF31TO0M_SHIFT)) & CAN_IMASK1_BUF31TO0M_MASK)
/*! @} */

/*! @name IFLAG1 - Interrupt Flags 1 Register */
/*! @{ */

#define CAN_IFLAG1_BUF0I_MASK                    (0x1U)
#define CAN_IFLAG1_BUF0I_SHIFT                   (0U)
/*! BUF0I - Buffer MB0 Interrupt Or Clear Legacy FIFO bit
 *  0b0..The corresponding buffer has no occurrence of successfully completed transmission or reception when MCR[RFEN]=0.
 *  0b1..The corresponding buffer has successfully completed transmission or reception when MCR[RFEN]=0.
 */
#define CAN_IFLAG1_BUF0I(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_IFLAG1_BUF0I_SHIFT)) & CAN_IFLAG1_BUF0I_MASK)

#define CAN_IFLAG1_BUF4TO1I_MASK                 (0x1EU)
#define CAN_IFLAG1_BUF4TO1I_SHIFT                (1U)
/*! BUF4TO1I - Buffer MBi Interrupt Or Reserved
 */
#define CAN_IFLAG1_BUF4TO1I(x)                   (((uint32_t)(((uint32_t)(x)) << CAN_IFLAG1_BUF4TO1I_SHIFT)) & CAN_IFLAG1_BUF4TO1I_MASK)

#define CAN_IFLAG1_BUF5I_MASK                    (0x20U)
#define CAN_IFLAG1_BUF5I_SHIFT                   (5U)
/*! BUF5I - Buffer MB5 Interrupt Or Frames available in Legacy Rx FIFO
 *  0b0..No occurrence of MB5 completing transmission/reception when MCR[RFEN]=0, or of frame(s) available in the Legacy FIFO, when MCR[RFEN]=1
 *  0b1..MB5 completed transmission/reception when MCR[RFEN]=0, or frame(s) available in the Legacy Rx FIFO when
 *       MCR[RFEN]=1. It generates a DMA request in case of MCR[RFEN] and MCR[DMA] are enabled.
 */
#define CAN_IFLAG1_BUF5I(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_IFLAG1_BUF5I_SHIFT)) & CAN_IFLAG1_BUF5I_MASK)

#define CAN_IFLAG1_BUF6I_MASK                    (0x40U)
#define CAN_IFLAG1_BUF6I_SHIFT                   (6U)
/*! BUF6I - Buffer MB6 Interrupt Or Legacy Rx FIFO Warning
 *  0b0..No occurrence of MB6 completing transmission/reception when MCR[RFEN]=0, or of Legacy Rx FIFO almost full when MCR[RFEN]=1
 *  0b1..MB6 completed transmission/reception when MCR[RFEN]=0, or Legacy Rx FIFO almost full when MCR[RFEN]=1
 */
#define CAN_IFLAG1_BUF6I(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_IFLAG1_BUF6I_SHIFT)) & CAN_IFLAG1_BUF6I_MASK)

#define CAN_IFLAG1_BUF7I_MASK                    (0x80U)
#define CAN_IFLAG1_BUF7I_SHIFT                   (7U)
/*! BUF7I - Buffer MB7 Interrupt Or Legacy Rx FIFO Overflow
 *  0b0..No occurrence of MB7 completing transmission/reception when MCR[RFEN]=0, or of Legacy Rx FIFO overflow when MCR[RFEN]=1
 *  0b1..MB7 completed transmission/reception when MCR[RFEN]=0, or Legacy Rx FIFO overflow when MCR[RFEN]=1
 */
#define CAN_IFLAG1_BUF7I(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_IFLAG1_BUF7I_SHIFT)) & CAN_IFLAG1_BUF7I_MASK)

#define CAN_IFLAG1_BUF31TO8I_MASK                (0xFFFFFF00U)
#define CAN_IFLAG1_BUF31TO8I_SHIFT               (8U)
/*! BUF31TO8I - Buffer MBi Interrupt
 */
#define CAN_IFLAG1_BUF31TO8I(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_IFLAG1_BUF31TO8I_SHIFT)) & CAN_IFLAG1_BUF31TO8I_MASK)
/*! @} */

/*! @name CTRL2 - Control 2 Register */
/*! @{ */

#define CAN_CTRL2_EDFLTDIS_MASK                  (0x800U)
#define CAN_CTRL2_EDFLTDIS_SHIFT                 (11U)
/*! EDFLTDIS - Edge Filter Disable
 *  0b0..Edge filter is enabled
 *  0b1..Edge filter is disabled
 */
#define CAN_CTRL2_EDFLTDIS(x)                    (((uint32_t)(((uint32_t)(x)) << CAN_CTRL2_EDFLTDIS_SHIFT)) & CAN_CTRL2_EDFLTDIS_MASK)

#define CAN_CTRL2_ISOCANFDEN_MASK                (0x1000U)
#define CAN_CTRL2_ISOCANFDEN_SHIFT               (12U)
/*! ISOCANFDEN - ISO CAN FD Enable
 *  0b0..FlexCAN operates using the non-ISO CAN FD protocol.
 *  0b1..FlexCAN operates using the ISO CAN FD protocol (ISO 11898-1:2015).
 */
#define CAN_CTRL2_ISOCANFDEN(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_CTRL2_ISOCANFDEN_SHIFT)) & CAN_CTRL2_ISOCANFDEN_MASK)

#define CAN_CTRL2_BTE_MASK                       (0x2000U)
#define CAN_CTRL2_BTE_SHIFT                      (13U)
/*! BTE - Bit Timing Expansion enable
 *  0b0..CAN Bit timing expansion is disabled.
 *  0b1..CAN bit timing expansion is enabled.
 */
#define CAN_CTRL2_BTE(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_CTRL2_BTE_SHIFT)) & CAN_CTRL2_BTE_MASK)

#define CAN_CTRL2_PREXCEN_MASK                   (0x4000U)
#define CAN_CTRL2_PREXCEN_SHIFT                  (14U)
/*! PREXCEN - Protocol Exception Enable
 *  0b0..Protocol exception is disabled.
 *  0b1..Protocol exception is enabled.
 */
#define CAN_CTRL2_PREXCEN(x)                     (((uint32_t)(((uint32_t)(x)) << CAN_CTRL2_PREXCEN_SHIFT)) & CAN_CTRL2_PREXCEN_MASK)

#define CAN_CTRL2_EACEN_MASK                     (0x10000U)
#define CAN_CTRL2_EACEN_SHIFT                    (16U)
/*! EACEN - Entire Frame Arbitration Field Comparison Enable For Rx Mailboxes
 *  0b0..Rx mailbox filter's IDE bit is always compared and RTR is never compared despite mask bits.
 *  0b1..Enables the comparison of both Rx mailbox filter's IDE and RTR bit with their corresponding bits within
 *       the incoming frame. Mask bits do apply.
 */
#define CAN_CTRL2_EACEN(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_CTRL2_EACEN_SHIFT)) & CAN_CTRL2_EACEN_MASK)

#define CAN_CTRL2_RRS_MASK                       (0x20000U)
#define CAN_CTRL2_RRS_SHIFT                      (17U)
/*! RRS - Remote Request Storing
 *  0b0..Remote response frame is generated.
 *  0b1..Remote request frame is stored.
 */
#define CAN_CTRL2_RRS(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_CTRL2_RRS_SHIFT)) & CAN_CTRL2_RRS_MASK)

#define CAN_CTRL2_MRP_MASK                       (0x40000U)
#define CAN_CTRL2_MRP_SHIFT                      (18U)
/*! MRP - Mailboxes Reception Priority
 *  0b0..Matching starts from Legacy Rx FIFO or Enhanced Rx FIFO and continues on mailboxes.
 *  0b1..Matching starts from mailboxes and continues on Legacy Rx FIFO or Enhanced Rx FIFO.
 */
#define CAN_CTRL2_MRP(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_CTRL2_MRP_SHIFT)) & CAN_CTRL2_MRP_MASK)

#define CAN_CTRL2_TASD_MASK                      (0xF80000U)
#define CAN_CTRL2_TASD_SHIFT                     (19U)
/*! TASD - Tx Arbitration Start Delay
 */
#define CAN_CTRL2_TASD(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_CTRL2_TASD_SHIFT)) & CAN_CTRL2_TASD_MASK)

#define CAN_CTRL2_RFFN_MASK                      (0xF000000U)
#define CAN_CTRL2_RFFN_SHIFT                     (24U)
/*! RFFN - Number Of Legacy Rx FIFO Filters
 */
#define CAN_CTRL2_RFFN(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_CTRL2_RFFN_SHIFT)) & CAN_CTRL2_RFFN_MASK)

#define CAN_CTRL2_BOFFDONEMSK_MASK               (0x40000000U)
#define CAN_CTRL2_BOFFDONEMSK_SHIFT              (30U)
/*! BOFFDONEMSK - Bus Off Done Interrupt Mask
 *  0b0..Bus off done interrupt disabled.
 *  0b1..Bus off done interrupt enabled.
 */
#define CAN_CTRL2_BOFFDONEMSK(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_CTRL2_BOFFDONEMSK_SHIFT)) & CAN_CTRL2_BOFFDONEMSK_MASK)

#define CAN_CTRL2_ERRMSK_FAST_MASK               (0x80000000U)
#define CAN_CTRL2_ERRMSK_FAST_SHIFT              (31U)
/*! ERRMSK_FAST - Error Interrupt Mask for errors detected in the data phase of fast CAN FD frames
 *  0b0..ERRINT_FAST error interrupt disabled.
 *  0b1..ERRINT_FAST error interrupt enabled.
 */
#define CAN_CTRL2_ERRMSK_FAST(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_CTRL2_ERRMSK_FAST_SHIFT)) & CAN_CTRL2_ERRMSK_FAST_MASK)
/*! @} */

/*! @name ESR2 - Error and Status 2 Register */
/*! @{ */

#define CAN_ESR2_IMB_MASK                        (0x2000U)
#define CAN_ESR2_IMB_SHIFT                       (13U)
/*! IMB - Inactive Mailbox
 *  0b0..If ESR2[VPS] is asserted, the ESR2[LPTM] is not an inactive mailbox.
 *  0b1..If ESR2[VPS] is asserted, there is at least one inactive mailbox. LPTM content is the number of the first one.
 */
#define CAN_ESR2_IMB(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_ESR2_IMB_SHIFT)) & CAN_ESR2_IMB_MASK)

#define CAN_ESR2_VPS_MASK                        (0x4000U)
#define CAN_ESR2_VPS_SHIFT                       (14U)
/*! VPS - Valid Priority Status
 *  0b0..Contents of IMB and LPTM are invalid.
 *  0b1..Contents of IMB and LPTM are valid.
 */
#define CAN_ESR2_VPS(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_ESR2_VPS_SHIFT)) & CAN_ESR2_VPS_MASK)

#define CAN_ESR2_LPTM_MASK                       (0x7F0000U)
#define CAN_ESR2_LPTM_SHIFT                      (16U)
/*! LPTM - Lowest Priority Tx Mailbox
 */
#define CAN_ESR2_LPTM(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_ESR2_LPTM_SHIFT)) & CAN_ESR2_LPTM_MASK)
/*! @} */

/*! @name CRCR - CRC Register */
/*! @{ */

#define CAN_CRCR_TXCRC_MASK                      (0x7FFFU)
#define CAN_CRCR_TXCRC_SHIFT                     (0U)
/*! TXCRC - Transmitted CRC value
 */
#define CAN_CRCR_TXCRC(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_CRCR_TXCRC_SHIFT)) & CAN_CRCR_TXCRC_MASK)

#define CAN_CRCR_MBCRC_MASK                      (0x7F0000U)
#define CAN_CRCR_MBCRC_SHIFT                     (16U)
/*! MBCRC - CRC Mailbox
 */
#define CAN_CRCR_MBCRC(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_CRCR_MBCRC_SHIFT)) & CAN_CRCR_MBCRC_MASK)
/*! @} */

/*! @name RXFGMASK - Legacy Rx FIFO Global Mask Register */
/*! @{ */

#define CAN_RXFGMASK_FGM_MASK                    (0xFFFFFFFFU)
#define CAN_RXFGMASK_FGM_SHIFT                   (0U)
/*! FGM - Legacy Rx FIFO Global Mask Bits
 */
#define CAN_RXFGMASK_FGM(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_RXFGMASK_FGM_SHIFT)) & CAN_RXFGMASK_FGM_MASK)
/*! @} */

/*! @name RXFIR - Legacy Rx FIFO Information Register */
/*! @{ */

#define CAN_RXFIR_IDHIT_MASK                     (0x1FFU)
#define CAN_RXFIR_IDHIT_SHIFT                    (0U)
/*! IDHIT - Identifier Acceptance Filter Hit Indicator
 */
#define CAN_RXFIR_IDHIT(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_RXFIR_IDHIT_SHIFT)) & CAN_RXFIR_IDHIT_MASK)
/*! @} */

/*! @name CBT - CAN Bit Timing Register */
/*! @{ */

#define CAN_CBT_EPSEG2_MASK                      (0x1FU)
#define CAN_CBT_EPSEG2_SHIFT                     (0U)
/*! EPSEG2 - Extended Phase Segment 2
 */
#define CAN_CBT_EPSEG2(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_CBT_EPSEG2_SHIFT)) & CAN_CBT_EPSEG2_MASK)

#define CAN_CBT_EPSEG1_MASK                      (0x3E0U)
#define CAN_CBT_EPSEG1_SHIFT                     (5U)
/*! EPSEG1 - Extended Phase Segment 1
 */
#define CAN_CBT_EPSEG1(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_CBT_EPSEG1_SHIFT)) & CAN_CBT_EPSEG1_MASK)

#define CAN_CBT_EPROPSEG_MASK                    (0xFC00U)
#define CAN_CBT_EPROPSEG_SHIFT                   (10U)
/*! EPROPSEG - Extended Propagation Segment
 */
#define CAN_CBT_EPROPSEG(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_CBT_EPROPSEG_SHIFT)) & CAN_CBT_EPROPSEG_MASK)

#define CAN_CBT_ERJW_MASK                        (0x1F0000U)
#define CAN_CBT_ERJW_SHIFT                       (16U)
/*! ERJW - Extended Resync Jump Width
 */
#define CAN_CBT_ERJW(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_CBT_ERJW_SHIFT)) & CAN_CBT_ERJW_MASK)

#define CAN_CBT_EPRESDIV_MASK                    (0x7FE00000U)
#define CAN_CBT_EPRESDIV_SHIFT                   (21U)
/*! EPRESDIV - Extended Prescaler Division Factor
 */
#define CAN_CBT_EPRESDIV(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_CBT_EPRESDIV_SHIFT)) & CAN_CBT_EPRESDIV_MASK)

#define CAN_CBT_BTF_MASK                         (0x80000000U)
#define CAN_CBT_BTF_SHIFT                        (31U)
/*! BTF - Bit Timing Format Enable
 *  0b0..Extended bit time definitions disabled.
 *  0b1..Extended bit time definitions enabled.
 */
#define CAN_CBT_BTF(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_CBT_BTF_SHIFT)) & CAN_CBT_BTF_MASK)
/*! @} */

/* The count of CAN_CS */
#define CAN_CS_COUNT_MB8B                        (32U)

/* The count of CAN_ID */
#define CAN_ID_COUNT_MB8B                        (32U)

/* The count of CAN_WORD */
#define CAN_WORD_COUNT_MB8B                      (32U)

/* The count of CAN_WORD */
#define CAN_WORD_COUNT_MB8B2                     (2U)

/* The count of CAN_CS */
#define CAN_CS_COUNT_MB16B                       (21U)

/* The count of CAN_ID */
#define CAN_ID_COUNT_MB16B                       (21U)

/* The count of CAN_WORD */
#define CAN_WORD_COUNT_MB16B                     (21U)

/* The count of CAN_WORD */
#define CAN_WORD_COUNT_MB16B2                    (4U)

/* The count of CAN_CS */
#define CAN_CS_COUNT_MB32B                       (12U)

/* The count of CAN_ID */
#define CAN_ID_COUNT_MB32B                       (12U)

/* The count of CAN_WORD */
#define CAN_WORD_COUNT_MB32B                     (12U)

/* The count of CAN_WORD */
#define CAN_WORD_COUNT_MB32B2                    (8U)

/*! @name CS - Message Buffer 0 CS Register..Message Buffer 6 CS Register */
/*! @{ */

#define CAN_CS_TIME_STAMP_MASK                   (0xFFFFU)
#define CAN_CS_TIME_STAMP_SHIFT                  (0U)
/*! TIME_STAMP - Free-Running Counter Time stamp. This 16-bit field is a copy of the Free-Running
 *    Timer, captured for Tx and Rx frames at the time when the beginning of the Identifier field
 *    appears on the CAN bus.
 */
#define CAN_CS_TIME_STAMP(x)                     (((uint32_t)(((uint32_t)(x)) << CAN_CS_TIME_STAMP_SHIFT)) & CAN_CS_TIME_STAMP_MASK)

#define CAN_CS_DLC_MASK                          (0xF0000U)
#define CAN_CS_DLC_SHIFT                         (16U)
/*! DLC - Length of the data to be stored/transmitted.
 */
#define CAN_CS_DLC(x)                            (((uint32_t)(((uint32_t)(x)) << CAN_CS_DLC_SHIFT)) & CAN_CS_DLC_MASK)

#define CAN_CS_RTR_MASK                          (0x100000U)
#define CAN_CS_RTR_SHIFT                         (20U)
/*! RTR - Remote Transmission Request. One/zero for remote/data frame.
 */
#define CAN_CS_RTR(x)                            (((uint32_t)(((uint32_t)(x)) << CAN_CS_RTR_SHIFT)) & CAN_CS_RTR_MASK)

#define CAN_CS_IDE_MASK                          (0x200000U)
#define CAN_CS_IDE_SHIFT                         (21U)
/*! IDE - ID Extended. One/zero for extended/standard format frame.
 */
#define CAN_CS_IDE(x)                            (((uint32_t)(((uint32_t)(x)) << CAN_CS_IDE_SHIFT)) & CAN_CS_IDE_MASK)

#define CAN_CS_SRR_MASK                          (0x400000U)
#define CAN_CS_SRR_SHIFT                         (22U)
/*! SRR - Substitute Remote Request. Contains a fixed recessive bit.
 */
#define CAN_CS_SRR(x)                            (((uint32_t)(((uint32_t)(x)) << CAN_CS_SRR_SHIFT)) & CAN_CS_SRR_MASK)

#define CAN_CS_CODE_MASK                         (0xF000000U)
#define CAN_CS_CODE_SHIFT                        (24U)
/*! CODE - Message Buffer Code. This 4-bit field can be accessed (read or write) by the CPU and by
 *    the FlexCAN module itself, as part of the message buffer matching and arbitration process.
 */
#define CAN_CS_CODE(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_CS_CODE_SHIFT)) & CAN_CS_CODE_MASK)

#define CAN_CS_ESI_MASK                          (0x20000000U)
#define CAN_CS_ESI_SHIFT                         (29U)
/*! ESI - Error State Indicator. This bit indicates if the transmitting node is error active or error passive.
 */
#define CAN_CS_ESI(x)                            (((uint32_t)(((uint32_t)(x)) << CAN_CS_ESI_SHIFT)) & CAN_CS_ESI_MASK)

#define CAN_CS_BRS_MASK                          (0x40000000U)
#define CAN_CS_BRS_SHIFT                         (30U)
/*! BRS - Bit Rate Switch. This bit defines whether the bit rate is switched inside a CAN FD format frame.
 */
#define CAN_CS_BRS(x)                            (((uint32_t)(((uint32_t)(x)) << CAN_CS_BRS_SHIFT)) & CAN_CS_BRS_MASK)

#define CAN_CS_EDL_MASK                          (0x80000000U)
#define CAN_CS_EDL_SHIFT                         (31U)
/*! EDL - Extended Data Length. This bit distinguishes between CAN format and CAN FD format frames.
 *    The EDL bit must not be set for Message Buffers configured to RANSWER with code field 0b1010.
 */
#define CAN_CS_EDL(x)                            (((uint32_t)(((uint32_t)(x)) << CAN_CS_EDL_SHIFT)) & CAN_CS_EDL_MASK)
/*! @} */

/* The count of CAN_CS */
#define CAN_CS_COUNT_MB64B                       (7U)

/*! @name ID - Message Buffer 0 ID Register..Message Buffer 6 ID Register */
/*! @{ */

#define CAN_ID_EXT_MASK                          (0x3FFFFU)
#define CAN_ID_EXT_SHIFT                         (0U)
/*! EXT - Contains extended (LOW word) identifier of message buffer.
 */
#define CAN_ID_EXT(x)                            (((uint32_t)(((uint32_t)(x)) << CAN_ID_EXT_SHIFT)) & CAN_ID_EXT_MASK)

#define CAN_ID_STD_MASK                          (0x1FFC0000U)
#define CAN_ID_STD_SHIFT                         (18U)
/*! STD - Contains standard/extended (HIGH word) identifier of message buffer.
 */
#define CAN_ID_STD(x)                            (((uint32_t)(((uint32_t)(x)) << CAN_ID_STD_SHIFT)) & CAN_ID_STD_MASK)

#define CAN_ID_PRIO_MASK                         (0xE0000000U)
#define CAN_ID_PRIO_SHIFT                        (29U)
/*! PRIO - Local priority. This 3-bit fieldis only used when LPRIO_EN bit is set in MCR and it only
 *    makes sense for Tx buffers. These bits are not transmitted. They are appended to the regular
 *    ID to define the transmission priority.
 */
#define CAN_ID_PRIO(x)                           (((uint32_t)(((uint32_t)(x)) << CAN_ID_PRIO_SHIFT)) & CAN_ID_PRIO_MASK)
/*! @} */

/* The count of CAN_ID */
#define CAN_ID_COUNT_MB64B                       (7U)

/*! @name WORD - Message Buffer 0 WORD_64B Register..Message Buffer 6 WORD_64B Register */
/*! @{ */

#define CAN_WORD_DATA_BYTE_3_MASK                (0xFFU)
#define CAN_WORD_DATA_BYTE_3_SHIFT               (0U)
/*! DATA_BYTE_3 - Data byte 0 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_3(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_3_SHIFT)) & CAN_WORD_DATA_BYTE_3_MASK)

#define CAN_WORD_DATA_BYTE_7_MASK                (0xFFU)
#define CAN_WORD_DATA_BYTE_7_SHIFT               (0U)
/*! DATA_BYTE_7 - Data byte 0 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_7(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_7_SHIFT)) & CAN_WORD_DATA_BYTE_7_MASK)

#define CAN_WORD_DATA_BYTE_11_MASK               (0xFFU)
#define CAN_WORD_DATA_BYTE_11_SHIFT              (0U)
/*! DATA_BYTE_11 - Data byte 0 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_11(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_11_SHIFT)) & CAN_WORD_DATA_BYTE_11_MASK)

#define CAN_WORD_DATA_BYTE_15_MASK               (0xFFU)
#define CAN_WORD_DATA_BYTE_15_SHIFT              (0U)
/*! DATA_BYTE_15 - Data byte 0 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_15(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_15_SHIFT)) & CAN_WORD_DATA_BYTE_15_MASK)

#define CAN_WORD_DATA_BYTE_19_MASK               (0xFFU)
#define CAN_WORD_DATA_BYTE_19_SHIFT              (0U)
/*! DATA_BYTE_19 - Data byte 0 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_19(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_19_SHIFT)) & CAN_WORD_DATA_BYTE_19_MASK)

#define CAN_WORD_DATA_BYTE_23_MASK               (0xFFU)
#define CAN_WORD_DATA_BYTE_23_SHIFT              (0U)
/*! DATA_BYTE_23 - Data byte 0 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_23(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_23_SHIFT)) & CAN_WORD_DATA_BYTE_23_MASK)

#define CAN_WORD_DATA_BYTE_27_MASK               (0xFFU)
#define CAN_WORD_DATA_BYTE_27_SHIFT              (0U)
/*! DATA_BYTE_27 - Data byte 0 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_27(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_27_SHIFT)) & CAN_WORD_DATA_BYTE_27_MASK)

#define CAN_WORD_DATA_BYTE_31_MASK               (0xFFU)
#define CAN_WORD_DATA_BYTE_31_SHIFT              (0U)
/*! DATA_BYTE_31 - Data byte 0 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_31(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_31_SHIFT)) & CAN_WORD_DATA_BYTE_31_MASK)

#define CAN_WORD_DATA_BYTE_35_MASK               (0xFFU)
#define CAN_WORD_DATA_BYTE_35_SHIFT              (0U)
/*! DATA_BYTE_35 - Data byte 0 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_35(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_35_SHIFT)) & CAN_WORD_DATA_BYTE_35_MASK)

#define CAN_WORD_DATA_BYTE_39_MASK               (0xFFU)
#define CAN_WORD_DATA_BYTE_39_SHIFT              (0U)
/*! DATA_BYTE_39 - Data byte 0 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_39(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_39_SHIFT)) & CAN_WORD_DATA_BYTE_39_MASK)

#define CAN_WORD_DATA_BYTE_43_MASK               (0xFFU)
#define CAN_WORD_DATA_BYTE_43_SHIFT              (0U)
/*! DATA_BYTE_43 - Data byte 0 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_43(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_43_SHIFT)) & CAN_WORD_DATA_BYTE_43_MASK)

#define CAN_WORD_DATA_BYTE_47_MASK               (0xFFU)
#define CAN_WORD_DATA_BYTE_47_SHIFT              (0U)
/*! DATA_BYTE_47 - Data byte 0 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_47(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_47_SHIFT)) & CAN_WORD_DATA_BYTE_47_MASK)

#define CAN_WORD_DATA_BYTE_51_MASK               (0xFFU)
#define CAN_WORD_DATA_BYTE_51_SHIFT              (0U)
/*! DATA_BYTE_51 - Data byte 0 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_51(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_51_SHIFT)) & CAN_WORD_DATA_BYTE_51_MASK)

#define CAN_WORD_DATA_BYTE_55_MASK               (0xFFU)
#define CAN_WORD_DATA_BYTE_55_SHIFT              (0U)
/*! DATA_BYTE_55 - Data byte 0 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_55(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_55_SHIFT)) & CAN_WORD_DATA_BYTE_55_MASK)

#define CAN_WORD_DATA_BYTE_59_MASK               (0xFFU)
#define CAN_WORD_DATA_BYTE_59_SHIFT              (0U)
/*! DATA_BYTE_59 - Data byte 0 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_59(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_59_SHIFT)) & CAN_WORD_DATA_BYTE_59_MASK)

#define CAN_WORD_DATA_BYTE_63_MASK               (0xFFU)
#define CAN_WORD_DATA_BYTE_63_SHIFT              (0U)
/*! DATA_BYTE_63 - Data byte 0 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_63(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_63_SHIFT)) & CAN_WORD_DATA_BYTE_63_MASK)

#define CAN_WORD_DATA_BYTE_2_MASK                (0xFF00U)
#define CAN_WORD_DATA_BYTE_2_SHIFT               (8U)
/*! DATA_BYTE_2 - Data byte 1 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_2(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_2_SHIFT)) & CAN_WORD_DATA_BYTE_2_MASK)

#define CAN_WORD_DATA_BYTE_6_MASK                (0xFF00U)
#define CAN_WORD_DATA_BYTE_6_SHIFT               (8U)
/*! DATA_BYTE_6 - Data byte 1 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_6(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_6_SHIFT)) & CAN_WORD_DATA_BYTE_6_MASK)

#define CAN_WORD_DATA_BYTE_10_MASK               (0xFF00U)
#define CAN_WORD_DATA_BYTE_10_SHIFT              (8U)
/*! DATA_BYTE_10 - Data byte 1 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_10(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_10_SHIFT)) & CAN_WORD_DATA_BYTE_10_MASK)

#define CAN_WORD_DATA_BYTE_14_MASK               (0xFF00U)
#define CAN_WORD_DATA_BYTE_14_SHIFT              (8U)
/*! DATA_BYTE_14 - Data byte 1 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_14(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_14_SHIFT)) & CAN_WORD_DATA_BYTE_14_MASK)

#define CAN_WORD_DATA_BYTE_18_MASK               (0xFF00U)
#define CAN_WORD_DATA_BYTE_18_SHIFT              (8U)
/*! DATA_BYTE_18 - Data byte 1 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_18(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_18_SHIFT)) & CAN_WORD_DATA_BYTE_18_MASK)

#define CAN_WORD_DATA_BYTE_22_MASK               (0xFF00U)
#define CAN_WORD_DATA_BYTE_22_SHIFT              (8U)
/*! DATA_BYTE_22 - Data byte 1 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_22(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_22_SHIFT)) & CAN_WORD_DATA_BYTE_22_MASK)

#define CAN_WORD_DATA_BYTE_26_MASK               (0xFF00U)
#define CAN_WORD_DATA_BYTE_26_SHIFT              (8U)
/*! DATA_BYTE_26 - Data byte 1 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_26(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_26_SHIFT)) & CAN_WORD_DATA_BYTE_26_MASK)

#define CAN_WORD_DATA_BYTE_30_MASK               (0xFF00U)
#define CAN_WORD_DATA_BYTE_30_SHIFT              (8U)
/*! DATA_BYTE_30 - Data byte 1 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_30(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_30_SHIFT)) & CAN_WORD_DATA_BYTE_30_MASK)

#define CAN_WORD_DATA_BYTE_34_MASK               (0xFF00U)
#define CAN_WORD_DATA_BYTE_34_SHIFT              (8U)
/*! DATA_BYTE_34 - Data byte 1 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_34(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_34_SHIFT)) & CAN_WORD_DATA_BYTE_34_MASK)

#define CAN_WORD_DATA_BYTE_38_MASK               (0xFF00U)
#define CAN_WORD_DATA_BYTE_38_SHIFT              (8U)
/*! DATA_BYTE_38 - Data byte 1 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_38(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_38_SHIFT)) & CAN_WORD_DATA_BYTE_38_MASK)

#define CAN_WORD_DATA_BYTE_42_MASK               (0xFF00U)
#define CAN_WORD_DATA_BYTE_42_SHIFT              (8U)
/*! DATA_BYTE_42 - Data byte 1 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_42(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_42_SHIFT)) & CAN_WORD_DATA_BYTE_42_MASK)

#define CAN_WORD_DATA_BYTE_46_MASK               (0xFF00U)
#define CAN_WORD_DATA_BYTE_46_SHIFT              (8U)
/*! DATA_BYTE_46 - Data byte 1 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_46(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_46_SHIFT)) & CAN_WORD_DATA_BYTE_46_MASK)

#define CAN_WORD_DATA_BYTE_50_MASK               (0xFF00U)
#define CAN_WORD_DATA_BYTE_50_SHIFT              (8U)
/*! DATA_BYTE_50 - Data byte 1 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_50(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_50_SHIFT)) & CAN_WORD_DATA_BYTE_50_MASK)

#define CAN_WORD_DATA_BYTE_54_MASK               (0xFF00U)
#define CAN_WORD_DATA_BYTE_54_SHIFT              (8U)
/*! DATA_BYTE_54 - Data byte 1 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_54(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_54_SHIFT)) & CAN_WORD_DATA_BYTE_54_MASK)

#define CAN_WORD_DATA_BYTE_58_MASK               (0xFF00U)
#define CAN_WORD_DATA_BYTE_58_SHIFT              (8U)
/*! DATA_BYTE_58 - Data byte 1 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_58(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_58_SHIFT)) & CAN_WORD_DATA_BYTE_58_MASK)

#define CAN_WORD_DATA_BYTE_62_MASK               (0xFF00U)
#define CAN_WORD_DATA_BYTE_62_SHIFT              (8U)
/*! DATA_BYTE_62 - Data byte 1 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_62(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_62_SHIFT)) & CAN_WORD_DATA_BYTE_62_MASK)

#define CAN_WORD_DATA_BYTE_1_MASK                (0xFF0000U)
#define CAN_WORD_DATA_BYTE_1_SHIFT               (16U)
/*! DATA_BYTE_1 - Data byte 2 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_1(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_1_SHIFT)) & CAN_WORD_DATA_BYTE_1_MASK)

#define CAN_WORD_DATA_BYTE_5_MASK                (0xFF0000U)
#define CAN_WORD_DATA_BYTE_5_SHIFT               (16U)
/*! DATA_BYTE_5 - Data byte 2 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_5(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_5_SHIFT)) & CAN_WORD_DATA_BYTE_5_MASK)

#define CAN_WORD_DATA_BYTE_9_MASK                (0xFF0000U)
#define CAN_WORD_DATA_BYTE_9_SHIFT               (16U)
/*! DATA_BYTE_9 - Data byte 2 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_9(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_9_SHIFT)) & CAN_WORD_DATA_BYTE_9_MASK)

#define CAN_WORD_DATA_BYTE_13_MASK               (0xFF0000U)
#define CAN_WORD_DATA_BYTE_13_SHIFT              (16U)
/*! DATA_BYTE_13 - Data byte 2 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_13(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_13_SHIFT)) & CAN_WORD_DATA_BYTE_13_MASK)

#define CAN_WORD_DATA_BYTE_17_MASK               (0xFF0000U)
#define CAN_WORD_DATA_BYTE_17_SHIFT              (16U)
/*! DATA_BYTE_17 - Data byte 2 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_17(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_17_SHIFT)) & CAN_WORD_DATA_BYTE_17_MASK)

#define CAN_WORD_DATA_BYTE_21_MASK               (0xFF0000U)
#define CAN_WORD_DATA_BYTE_21_SHIFT              (16U)
/*! DATA_BYTE_21 - Data byte 2 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_21(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_21_SHIFT)) & CAN_WORD_DATA_BYTE_21_MASK)

#define CAN_WORD_DATA_BYTE_25_MASK               (0xFF0000U)
#define CAN_WORD_DATA_BYTE_25_SHIFT              (16U)
/*! DATA_BYTE_25 - Data byte 2 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_25(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_25_SHIFT)) & CAN_WORD_DATA_BYTE_25_MASK)

#define CAN_WORD_DATA_BYTE_29_MASK               (0xFF0000U)
#define CAN_WORD_DATA_BYTE_29_SHIFT              (16U)
/*! DATA_BYTE_29 - Data byte 2 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_29(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_29_SHIFT)) & CAN_WORD_DATA_BYTE_29_MASK)

#define CAN_WORD_DATA_BYTE_33_MASK               (0xFF0000U)
#define CAN_WORD_DATA_BYTE_33_SHIFT              (16U)
/*! DATA_BYTE_33 - Data byte 2 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_33(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_33_SHIFT)) & CAN_WORD_DATA_BYTE_33_MASK)

#define CAN_WORD_DATA_BYTE_37_MASK               (0xFF0000U)
#define CAN_WORD_DATA_BYTE_37_SHIFT              (16U)
/*! DATA_BYTE_37 - Data byte 2 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_37(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_37_SHIFT)) & CAN_WORD_DATA_BYTE_37_MASK)

#define CAN_WORD_DATA_BYTE_41_MASK               (0xFF0000U)
#define CAN_WORD_DATA_BYTE_41_SHIFT              (16U)
/*! DATA_BYTE_41 - Data byte 2 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_41(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_41_SHIFT)) & CAN_WORD_DATA_BYTE_41_MASK)

#define CAN_WORD_DATA_BYTE_45_MASK               (0xFF0000U)
#define CAN_WORD_DATA_BYTE_45_SHIFT              (16U)
/*! DATA_BYTE_45 - Data byte 2 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_45(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_45_SHIFT)) & CAN_WORD_DATA_BYTE_45_MASK)

#define CAN_WORD_DATA_BYTE_49_MASK               (0xFF0000U)
#define CAN_WORD_DATA_BYTE_49_SHIFT              (16U)
/*! DATA_BYTE_49 - Data byte 2 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_49(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_49_SHIFT)) & CAN_WORD_DATA_BYTE_49_MASK)

#define CAN_WORD_DATA_BYTE_53_MASK               (0xFF0000U)
#define CAN_WORD_DATA_BYTE_53_SHIFT              (16U)
/*! DATA_BYTE_53 - Data byte 2 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_53(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_53_SHIFT)) & CAN_WORD_DATA_BYTE_53_MASK)

#define CAN_WORD_DATA_BYTE_57_MASK               (0xFF0000U)
#define CAN_WORD_DATA_BYTE_57_SHIFT              (16U)
/*! DATA_BYTE_57 - Data byte 2 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_57(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_57_SHIFT)) & CAN_WORD_DATA_BYTE_57_MASK)

#define CAN_WORD_DATA_BYTE_61_MASK               (0xFF0000U)
#define CAN_WORD_DATA_BYTE_61_SHIFT              (16U)
/*! DATA_BYTE_61 - Data byte 2 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_61(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_61_SHIFT)) & CAN_WORD_DATA_BYTE_61_MASK)

#define CAN_WORD_DATA_BYTE_0_MASK                (0xFF000000U)
#define CAN_WORD_DATA_BYTE_0_SHIFT               (24U)
/*! DATA_BYTE_0 - Data byte 3 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_0(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_0_SHIFT)) & CAN_WORD_DATA_BYTE_0_MASK)

#define CAN_WORD_DATA_BYTE_4_MASK                (0xFF000000U)
#define CAN_WORD_DATA_BYTE_4_SHIFT               (24U)
/*! DATA_BYTE_4 - Data byte 3 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_4(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_4_SHIFT)) & CAN_WORD_DATA_BYTE_4_MASK)

#define CAN_WORD_DATA_BYTE_8_MASK                (0xFF000000U)
#define CAN_WORD_DATA_BYTE_8_SHIFT               (24U)
/*! DATA_BYTE_8 - Data byte 3 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_8(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_8_SHIFT)) & CAN_WORD_DATA_BYTE_8_MASK)

#define CAN_WORD_DATA_BYTE_12_MASK               (0xFF000000U)
#define CAN_WORD_DATA_BYTE_12_SHIFT              (24U)
/*! DATA_BYTE_12 - Data byte 3 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_12(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_12_SHIFT)) & CAN_WORD_DATA_BYTE_12_MASK)

#define CAN_WORD_DATA_BYTE_16_MASK               (0xFF000000U)
#define CAN_WORD_DATA_BYTE_16_SHIFT              (24U)
/*! DATA_BYTE_16 - Data byte 3 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_16(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_16_SHIFT)) & CAN_WORD_DATA_BYTE_16_MASK)

#define CAN_WORD_DATA_BYTE_20_MASK               (0xFF000000U)
#define CAN_WORD_DATA_BYTE_20_SHIFT              (24U)
/*! DATA_BYTE_20 - Data byte 3 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_20(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_20_SHIFT)) & CAN_WORD_DATA_BYTE_20_MASK)

#define CAN_WORD_DATA_BYTE_24_MASK               (0xFF000000U)
#define CAN_WORD_DATA_BYTE_24_SHIFT              (24U)
/*! DATA_BYTE_24 - Data byte 3 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_24(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_24_SHIFT)) & CAN_WORD_DATA_BYTE_24_MASK)

#define CAN_WORD_DATA_BYTE_28_MASK               (0xFF000000U)
#define CAN_WORD_DATA_BYTE_28_SHIFT              (24U)
/*! DATA_BYTE_28 - Data byte 3 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_28(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_28_SHIFT)) & CAN_WORD_DATA_BYTE_28_MASK)

#define CAN_WORD_DATA_BYTE_32_MASK               (0xFF000000U)
#define CAN_WORD_DATA_BYTE_32_SHIFT              (24U)
/*! DATA_BYTE_32 - Data byte 3 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_32(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_32_SHIFT)) & CAN_WORD_DATA_BYTE_32_MASK)

#define CAN_WORD_DATA_BYTE_36_MASK               (0xFF000000U)
#define CAN_WORD_DATA_BYTE_36_SHIFT              (24U)
/*! DATA_BYTE_36 - Data byte 3 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_36(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_36_SHIFT)) & CAN_WORD_DATA_BYTE_36_MASK)

#define CAN_WORD_DATA_BYTE_40_MASK               (0xFF000000U)
#define CAN_WORD_DATA_BYTE_40_SHIFT              (24U)
/*! DATA_BYTE_40 - Data byte 3 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_40(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_40_SHIFT)) & CAN_WORD_DATA_BYTE_40_MASK)

#define CAN_WORD_DATA_BYTE_44_MASK               (0xFF000000U)
#define CAN_WORD_DATA_BYTE_44_SHIFT              (24U)
/*! DATA_BYTE_44 - Data byte 3 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_44(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_44_SHIFT)) & CAN_WORD_DATA_BYTE_44_MASK)

#define CAN_WORD_DATA_BYTE_48_MASK               (0xFF000000U)
#define CAN_WORD_DATA_BYTE_48_SHIFT              (24U)
/*! DATA_BYTE_48 - Data byte 3 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_48(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_48_SHIFT)) & CAN_WORD_DATA_BYTE_48_MASK)

#define CAN_WORD_DATA_BYTE_52_MASK               (0xFF000000U)
#define CAN_WORD_DATA_BYTE_52_SHIFT              (24U)
/*! DATA_BYTE_52 - Data byte 3 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_52(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_52_SHIFT)) & CAN_WORD_DATA_BYTE_52_MASK)

#define CAN_WORD_DATA_BYTE_56_MASK               (0xFF000000U)
#define CAN_WORD_DATA_BYTE_56_SHIFT              (24U)
/*! DATA_BYTE_56 - Data byte 3 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_56(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_56_SHIFT)) & CAN_WORD_DATA_BYTE_56_MASK)

#define CAN_WORD_DATA_BYTE_60_MASK               (0xFF000000U)
#define CAN_WORD_DATA_BYTE_60_SHIFT              (24U)
/*! DATA_BYTE_60 - Data byte 3 of Rx/Tx frame.
 */
#define CAN_WORD_DATA_BYTE_60(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD_DATA_BYTE_60_SHIFT)) & CAN_WORD_DATA_BYTE_60_MASK)
/*! @} */

/* The count of CAN_WORD */
#define CAN_WORD_COUNT_MB64B                     (7U)

/* The count of CAN_WORD */
#define CAN_WORD_COUNT_MB64B2                    (16U)

/* The count of CAN_CS */
#define CAN_CS_COUNT                             (32U)

/* The count of CAN_ID */
#define CAN_ID_COUNT                             (32U)

/*! @name WORD0 - Message Buffer 0 WORD0 Register..Message Buffer 31 WORD0 Register */
/*! @{ */

#define CAN_WORD0_DATA_BYTE_3_MASK               (0xFFU)
#define CAN_WORD0_DATA_BYTE_3_SHIFT              (0U)
/*! DATA_BYTE_3 - Data byte 0 of Rx/Tx frame.
 */
#define CAN_WORD0_DATA_BYTE_3(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD0_DATA_BYTE_3_SHIFT)) & CAN_WORD0_DATA_BYTE_3_MASK)

#define CAN_WORD0_DATA_BYTE_2_MASK               (0xFF00U)
#define CAN_WORD0_DATA_BYTE_2_SHIFT              (8U)
/*! DATA_BYTE_2 - Data byte 1 of Rx/Tx frame.
 */
#define CAN_WORD0_DATA_BYTE_2(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD0_DATA_BYTE_2_SHIFT)) & CAN_WORD0_DATA_BYTE_2_MASK)

#define CAN_WORD0_DATA_BYTE_1_MASK               (0xFF0000U)
#define CAN_WORD0_DATA_BYTE_1_SHIFT              (16U)
/*! DATA_BYTE_1 - Data byte 2 of Rx/Tx frame.
 */
#define CAN_WORD0_DATA_BYTE_1(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD0_DATA_BYTE_1_SHIFT)) & CAN_WORD0_DATA_BYTE_1_MASK)

#define CAN_WORD0_DATA_BYTE_0_MASK               (0xFF000000U)
#define CAN_WORD0_DATA_BYTE_0_SHIFT              (24U)
/*! DATA_BYTE_0 - Data byte 3 of Rx/Tx frame.
 */
#define CAN_WORD0_DATA_BYTE_0(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD0_DATA_BYTE_0_SHIFT)) & CAN_WORD0_DATA_BYTE_0_MASK)
/*! @} */

/* The count of CAN_WORD0 */
#define CAN_WORD0_COUNT                          (32U)

/*! @name WORD1 - Message Buffer 0 WORD1 Register..Message Buffer 31 WORD1 Register */
/*! @{ */

#define CAN_WORD1_DATA_BYTE_7_MASK               (0xFFU)
#define CAN_WORD1_DATA_BYTE_7_SHIFT              (0U)
/*! DATA_BYTE_7 - Data byte 0 of Rx/Tx frame.
 */
#define CAN_WORD1_DATA_BYTE_7(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD1_DATA_BYTE_7_SHIFT)) & CAN_WORD1_DATA_BYTE_7_MASK)

#define CAN_WORD1_DATA_BYTE_6_MASK               (0xFF00U)
#define CAN_WORD1_DATA_BYTE_6_SHIFT              (8U)
/*! DATA_BYTE_6 - Data byte 1 of Rx/Tx frame.
 */
#define CAN_WORD1_DATA_BYTE_6(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD1_DATA_BYTE_6_SHIFT)) & CAN_WORD1_DATA_BYTE_6_MASK)

#define CAN_WORD1_DATA_BYTE_5_MASK               (0xFF0000U)
#define CAN_WORD1_DATA_BYTE_5_SHIFT              (16U)
/*! DATA_BYTE_5 - Data byte 2 of Rx/Tx frame.
 */
#define CAN_WORD1_DATA_BYTE_5(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD1_DATA_BYTE_5_SHIFT)) & CAN_WORD1_DATA_BYTE_5_MASK)

#define CAN_WORD1_DATA_BYTE_4_MASK               (0xFF000000U)
#define CAN_WORD1_DATA_BYTE_4_SHIFT              (24U)
/*! DATA_BYTE_4 - Data byte 3 of Rx/Tx frame.
 */
#define CAN_WORD1_DATA_BYTE_4(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_WORD1_DATA_BYTE_4_SHIFT)) & CAN_WORD1_DATA_BYTE_4_MASK)
/*! @} */

/* The count of CAN_WORD1 */
#define CAN_WORD1_COUNT                          (32U)

/*! @name RXIMR - Rx Individual Mask Registers */
/*! @{ */

#define CAN_RXIMR_MI_MASK                        (0xFFFFFFFFU)
#define CAN_RXIMR_MI_SHIFT                       (0U)
/*! MI - Individual Mask Bits
 */
#define CAN_RXIMR_MI(x)                          (((uint32_t)(((uint32_t)(x)) << CAN_RXIMR_MI_SHIFT)) & CAN_RXIMR_MI_MASK)
/*! @} */

/* The count of CAN_RXIMR */
#define CAN_RXIMR_COUNT                          (32U)

/*! @name CTRL1_PN - Pretended Networking Control 1 Register */
/*! @{ */

#define CAN_CTRL1_PN_FCS_MASK                    (0x3U)
#define CAN_CTRL1_PN_FCS_SHIFT                   (0U)
/*! FCS - Filtering Combination Selection
 *  0b00..Message ID filtering only
 *  0b01..Message ID filtering and payload filtering
 *  0b10..Message ID filtering occurring a specified number of times
 *  0b11..Message ID filtering and payload filtering a specified number of times
 */
#define CAN_CTRL1_PN_FCS(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_PN_FCS_SHIFT)) & CAN_CTRL1_PN_FCS_MASK)

#define CAN_CTRL1_PN_IDFS_MASK                   (0xCU)
#define CAN_CTRL1_PN_IDFS_SHIFT                  (2U)
/*! IDFS - ID Filtering Selection
 *  0b00..Match upon ID contents against an exact target value
 *  0b01..Match upon an ID value greater than or equal to a specified target value
 *  0b10..Match upon an ID value smaller than or equal to a specified target value
 *  0b11..Match upon an ID value inside a range, greater than or equal to a specified lower limit, and smaller
 *        than or equal to a specified upper limit
 */
#define CAN_CTRL1_PN_IDFS(x)                     (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_PN_IDFS_SHIFT)) & CAN_CTRL1_PN_IDFS_MASK)

#define CAN_CTRL1_PN_PLFS_MASK                   (0x30U)
#define CAN_CTRL1_PN_PLFS_SHIFT                  (4U)
/*! PLFS - Payload Filtering Selection
 *  0b00..Match upon a payload contents against an exact target value
 *  0b01..Match upon a payload value greater than or equal to a specified target value
 *  0b10..Match upon a payload value smaller than or equal to a specified target value
 *  0b11..Match upon a payload value inside a range, greater than or equal to a specified lower limit, and smaller
 *        than or equal to a specified upper limit
 */
#define CAN_CTRL1_PN_PLFS(x)                     (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_PN_PLFS_SHIFT)) & CAN_CTRL1_PN_PLFS_MASK)

#define CAN_CTRL1_PN_NMATCH_MASK                 (0xFF00U)
#define CAN_CTRL1_PN_NMATCH_SHIFT                (8U)
/*! NMATCH - Number of Messages Matching the Same Filtering Criteria
 *  0b00000001..Received message must match the predefined filtering criteria for ID and/or PL once before generating a wakeup event.
 *  0b00000010..Received message must match the predefined filtering criteria for ID and/or PL twice before generating a wakeup event.
 *  0b11111111..Received message must match the predefined filtering criteria for ID and/or PL 255 times before generating a wakeup event.
 */
#define CAN_CTRL1_PN_NMATCH(x)                   (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_PN_NMATCH_SHIFT)) & CAN_CTRL1_PN_NMATCH_MASK)

#define CAN_CTRL1_PN_WUMF_MSK_MASK               (0x10000U)
#define CAN_CTRL1_PN_WUMF_MSK_SHIFT              (16U)
/*! WUMF_MSK - Wake Up by Match Flag Mask Bit
 *  0b0..Wakeup match event is disabled
 *  0b1..Wakeup match event is enabled
 */
#define CAN_CTRL1_PN_WUMF_MSK(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_PN_WUMF_MSK_SHIFT)) & CAN_CTRL1_PN_WUMF_MSK_MASK)

#define CAN_CTRL1_PN_WTOF_MSK_MASK               (0x20000U)
#define CAN_CTRL1_PN_WTOF_MSK_SHIFT              (17U)
/*! WTOF_MSK - Wake Up by Timeout Flag Mask Bit
 *  0b0..Timeout wakeup event is disabled
 *  0b1..Timeout wakeup event is enabled
 */
#define CAN_CTRL1_PN_WTOF_MSK(x)                 (((uint32_t)(((uint32_t)(x)) << CAN_CTRL1_PN_WTOF_MSK_SHIFT)) & CAN_CTRL1_PN_WTOF_MSK_MASK)
/*! @} */

/*! @name CTRL2_PN - Pretended Networking Control 2 Register */
/*! @{ */

#define CAN_CTRL2_PN_MATCHTO_MASK                (0xFFFFU)
#define CAN_CTRL2_PN_MATCHTO_SHIFT               (0U)
/*! MATCHTO - Timeout for No Message Matching the Filtering Criteria
 */
#define CAN_CTRL2_PN_MATCHTO(x)                  (((uint32_t)(((uint32_t)(x)) << CAN_CTRL2_PN_MATCHTO_SHIFT)) & CAN_CTRL2_PN_MATCHTO_MASK)
/*! @} */

/*! @name WU_MTC - Pretended Networking Wake Up Match Register */
/*! @{ */

#define CAN_WU_MTC_MCOUNTER_MASK                 (0xFF00U)
#define CAN_WU_MTC_MCOUNTER_SHIFT                (8U)
/*! MCOUNTER - Number of Matches when in Pretended Networking
 */
#define CAN_WU_MTC_MCOUNTER(x)                   (((uint32_t)(((uint32_t)(x)) << CAN_WU_MTC_MCOUNTER_SHIFT)) & CAN_WU_MTC_MCOUNTER_MASK)

#define CAN_WU_MTC_WUMF_MASK                     (0x10000U)
#define CAN_WU_MTC_WUMF_SHIFT                    (16U)
/*! WUMF - Wake Up by Match Flag Bit
 *  0b0..No wakeup by match event detected
 *  0b1..Wakeup by match event detected
 */
#define CAN_WU_MTC_WUMF(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_WU_MTC_WUMF_SHIFT)) & CAN_WU_MTC_WUMF_MASK)

#define CAN_WU_MTC_WTOF_MASK                     (0x20000U)
#define CAN_WU_MTC_WTOF_SHIFT                    (17U)
/*! WTOF - Wake Up by Timeout Flag Bit
 *  0b0..No wakeup by timeout event detected
 *  0b1..Wakeup by timeout event detected
 */
#define CAN_WU_MTC_WTOF(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_WU_MTC_WTOF_SHIFT)) & CAN_WU_MTC_WTOF_MASK)
/*! @} */

/*! @name FLT_ID1 - Pretended Networking ID Filter 1 Register */
/*! @{ */

#define CAN_FLT_ID1_FLT_ID1_MASK                 (0x1FFFFFFFU)
#define CAN_FLT_ID1_FLT_ID1_SHIFT                (0U)
/*! FLT_ID1 - ID Filter 1 for Pretended Networking filtering
 */
#define CAN_FLT_ID1_FLT_ID1(x)                   (((uint32_t)(((uint32_t)(x)) << CAN_FLT_ID1_FLT_ID1_SHIFT)) & CAN_FLT_ID1_FLT_ID1_MASK)

#define CAN_FLT_ID1_FLT_RTR_MASK                 (0x20000000U)
#define CAN_FLT_ID1_FLT_RTR_SHIFT                (29U)
/*! FLT_RTR - Remote Transmission Request Filter
 *  0b0..Reject remote frame (accept data frame)
 *  0b1..Accept remote frame
 */
#define CAN_FLT_ID1_FLT_RTR(x)                   (((uint32_t)(((uint32_t)(x)) << CAN_FLT_ID1_FLT_RTR_SHIFT)) & CAN_FLT_ID1_FLT_RTR_MASK)

#define CAN_FLT_ID1_FLT_IDE_MASK                 (0x40000000U)
#define CAN_FLT_ID1_FLT_IDE_SHIFT                (30U)
/*! FLT_IDE - ID Extended Filter
 *  0b0..Accept standard frame format
 *  0b1..Accept extended frame format
 */
#define CAN_FLT_ID1_FLT_IDE(x)                   (((uint32_t)(((uint32_t)(x)) << CAN_FLT_ID1_FLT_IDE_SHIFT)) & CAN_FLT_ID1_FLT_IDE_MASK)
/*! @} */

/*! @name FLT_DLC - Pretended Networking DLC Filter Register */
/*! @{ */

#define CAN_FLT_DLC_FLT_DLC_HI_MASK              (0xFU)
#define CAN_FLT_DLC_FLT_DLC_HI_SHIFT             (0U)
/*! FLT_DLC_HI - Upper Limit for Length of Data Bytes Filter
 */
#define CAN_FLT_DLC_FLT_DLC_HI(x)                (((uint32_t)(((uint32_t)(x)) << CAN_FLT_DLC_FLT_DLC_HI_SHIFT)) & CAN_FLT_DLC_FLT_DLC_HI_MASK)

#define CAN_FLT_DLC_FLT_DLC_LO_MASK              (0xF0000U)
#define CAN_FLT_DLC_FLT_DLC_LO_SHIFT             (16U)
/*! FLT_DLC_LO - Lower Limit for Length of Data Bytes Filter
 */
#define CAN_FLT_DLC_FLT_DLC_LO(x)                (((uint32_t)(((uint32_t)(x)) << CAN_FLT_DLC_FLT_DLC_LO_SHIFT)) & CAN_FLT_DLC_FLT_DLC_LO_MASK)
/*! @} */

/*! @name PL1_LO - Pretended Networking Payload Low Filter 1 Register */
/*! @{ */

#define CAN_PL1_LO_Data_byte_3_MASK              (0xFFU)
#define CAN_PL1_LO_Data_byte_3_SHIFT             (0U)
/*! Data_byte_3 - Payload Filter 1 low order bits for Pretended Networking payload filtering corresponding to data byte 3.
 */
#define CAN_PL1_LO_Data_byte_3(x)                (((uint32_t)(((uint32_t)(x)) << CAN_PL1_LO_Data_byte_3_SHIFT)) & CAN_PL1_LO_Data_byte_3_MASK)

#define CAN_PL1_LO_Data_byte_2_MASK              (0xFF00U)
#define CAN_PL1_LO_Data_byte_2_SHIFT             (8U)
/*! Data_byte_2 - Payload Filter 1 low order bits for Pretended Networking payload filtering corresponding to data byte 2.
 */
#define CAN_PL1_LO_Data_byte_2(x)                (((uint32_t)(((uint32_t)(x)) << CAN_PL1_LO_Data_byte_2_SHIFT)) & CAN_PL1_LO_Data_byte_2_MASK)

#define CAN_PL1_LO_Data_byte_1_MASK              (0xFF0000U)
#define CAN_PL1_LO_Data_byte_1_SHIFT             (16U)
/*! Data_byte_1 - Payload Filter 1 low order bits for Pretended Networking payload filtering corresponding to data byte 1.
 */
#define CAN_PL1_LO_Data_byte_1(x)                (((uint32_t)(((uint32_t)(x)) << CAN_PL1_LO_Data_byte_1_SHIFT)) & CAN_PL1_LO_Data_byte_1_MASK)

#define CAN_PL1_LO_Data_byte_0_MASK              (0xFF000000U)
#define CAN_PL1_LO_Data_byte_0_SHIFT             (24U)
/*! Data_byte_0 - Payload Filter 1 low order bits for Pretended Networking payload filtering corresponding to data byte 0.
 */
#define CAN_PL1_LO_Data_byte_0(x)                (((uint32_t)(((uint32_t)(x)) << CAN_PL1_LO_Data_byte_0_SHIFT)) & CAN_PL1_LO_Data_byte_0_MASK)
/*! @} */

/*! @name PL1_HI - Pretended Networking Payload High Filter 1 Register */
/*! @{ */

#define CAN_PL1_HI_Data_byte_7_MASK              (0xFFU)
#define CAN_PL1_HI_Data_byte_7_SHIFT             (0U)
/*! Data_byte_7 - Payload Filter 1 high order bits for Pretended Networking payload filtering corresponding to data byte 7.
 */
#define CAN_PL1_HI_Data_byte_7(x)                (((uint32_t)(((uint32_t)(x)) << CAN_PL1_HI_Data_byte_7_SHIFT)) & CAN_PL1_HI_Data_byte_7_MASK)

#define CAN_PL1_HI_Data_byte_6_MASK              (0xFF00U)
#define CAN_PL1_HI_Data_byte_6_SHIFT             (8U)
/*! Data_byte_6 - Payload Filter 1 high order bits for Pretended Networking payload filtering corresponding to data byte 6.
 */
#define CAN_PL1_HI_Data_byte_6(x)                (((uint32_t)(((uint32_t)(x)) << CAN_PL1_HI_Data_byte_6_SHIFT)) & CAN_PL1_HI_Data_byte_6_MASK)

#define CAN_PL1_HI_Data_byte_5_MASK              (0xFF0000U)
#define CAN_PL1_HI_Data_byte_5_SHIFT             (16U)
/*! Data_byte_5 - Payload Filter 1 high order bits for Pretended Networking payload filtering corresponding to data byte 5.
 */
#define CAN_PL1_HI_Data_byte_5(x)                (((uint32_t)(((uint32_t)(x)) << CAN_PL1_HI_Data_byte_5_SHIFT)) & CAN_PL1_HI_Data_byte_5_MASK)

#define CAN_PL1_HI_Data_byte_4_MASK              (0xFF000000U)
#define CAN_PL1_HI_Data_byte_4_SHIFT             (24U)
/*! Data_byte_4 - Payload Filter 1 high order bits for Pretended Networking payload filtering corresponding to data byte 4.
 */
#define CAN_PL1_HI_Data_byte_4(x)                (((uint32_t)(((uint32_t)(x)) << CAN_PL1_HI_Data_byte_4_SHIFT)) & CAN_PL1_HI_Data_byte_4_MASK)
/*! @} */

/*! @name FLT_ID2_IDMASK - Pretended Networking ID Filter 2 Register / ID Mask Register */
/*! @{ */

#define CAN_FLT_ID2_IDMASK_FLT_ID2_IDMASK_MASK   (0x1FFFFFFFU)
#define CAN_FLT_ID2_IDMASK_FLT_ID2_IDMASK_SHIFT  (0U)
/*! FLT_ID2_IDMASK - ID Filter 2 for Pretended Networking Filtering / ID Mask Bits for Pretended Networking ID Filtering
 */
#define CAN_FLT_ID2_IDMASK_FLT_ID2_IDMASK(x)     (((uint32_t)(((uint32_t)(x)) << CAN_FLT_ID2_IDMASK_FLT_ID2_IDMASK_SHIFT)) & CAN_FLT_ID2_IDMASK_FLT_ID2_IDMASK_MASK)

#define CAN_FLT_ID2_IDMASK_RTR_MSK_MASK          (0x20000000U)
#define CAN_FLT_ID2_IDMASK_RTR_MSK_SHIFT         (29U)
/*! RTR_MSK - Remote Transmission Request Mask Bit
 *  0b0..The corresponding bit in the filter is "don't care"
 *  0b1..The corresponding bit in the filter is checked
 */
#define CAN_FLT_ID2_IDMASK_RTR_MSK(x)            (((uint32_t)(((uint32_t)(x)) << CAN_FLT_ID2_IDMASK_RTR_MSK_SHIFT)) & CAN_FLT_ID2_IDMASK_RTR_MSK_MASK)

#define CAN_FLT_ID2_IDMASK_IDE_MSK_MASK          (0x40000000U)
#define CAN_FLT_ID2_IDMASK_IDE_MSK_SHIFT         (30U)
/*! IDE_MSK - ID Extended Mask Bit
 *  0b0..The corresponding bit in the filter is "don't care"
 *  0b1..The corresponding bit in the filter is checked
 */
#define CAN_FLT_ID2_IDMASK_IDE_MSK(x)            (((uint32_t)(((uint32_t)(x)) << CAN_FLT_ID2_IDMASK_IDE_MSK_SHIFT)) & CAN_FLT_ID2_IDMASK_IDE_MSK_MASK)
/*! @} */

/*! @name PL2_PLMASK_LO - Pretended Networking Payload Low Filter 2 Register / Payload Low Mask register */
/*! @{ */

#define CAN_PL2_PLMASK_LO_Data_byte_3_MASK       (0xFFU)
#define CAN_PL2_PLMASK_LO_Data_byte_3_SHIFT      (0U)
/*! Data_byte_3 - Payload Filter 2 low order bits / Payload Mask low order bits for Pretended
 *    Networking payload filtering corresponding to the data byte 3.
 */
#define CAN_PL2_PLMASK_LO_Data_byte_3(x)         (((uint32_t)(((uint32_t)(x)) << CAN_PL2_PLMASK_LO_Data_byte_3_SHIFT)) & CAN_PL2_PLMASK_LO_Data_byte_3_MASK)

#define CAN_PL2_PLMASK_LO_Data_byte_2_MASK       (0xFF00U)
#define CAN_PL2_PLMASK_LO_Data_byte_2_SHIFT      (8U)
/*! Data_byte_2 - Payload Filter 2 low order bits / Payload Mask low order bits for Pretended
 *    Networking payload filtering corresponding to the data byte 2.
 */
#define CAN_PL2_PLMASK_LO_Data_byte_2(x)         (((uint32_t)(((uint32_t)(x)) << CAN_PL2_PLMASK_LO_Data_byte_2_SHIFT)) & CAN_PL2_PLMASK_LO_Data_byte_2_MASK)

#define CAN_PL2_PLMASK_LO_Data_byte_1_MASK       (0xFF0000U)
#define CAN_PL2_PLMASK_LO_Data_byte_1_SHIFT      (16U)
/*! Data_byte_1 - Payload Filter 2 low order bits / Payload Mask low order bits for Pretended
 *    Networking payload filtering corresponding to the data byte 1.
 */
#define CAN_PL2_PLMASK_LO_Data_byte_1(x)         (((uint32_t)(((uint32_t)(x)) << CAN_PL2_PLMASK_LO_Data_byte_1_SHIFT)) & CAN_PL2_PLMASK_LO_Data_byte_1_MASK)

#define CAN_PL2_PLMASK_LO_Data_byte_0_MASK       (0xFF000000U)
#define CAN_PL2_PLMASK_LO_Data_byte_0_SHIFT      (24U)
/*! Data_byte_0 - Payload Filter 2 low order bits / Payload Mask low order bits for Pretended
 *    Networking payload filtering corresponding to the data byte 0.
 */
#define CAN_PL2_PLMASK_LO_Data_byte_0(x)         (((uint32_t)(((uint32_t)(x)) << CAN_PL2_PLMASK_LO_Data_byte_0_SHIFT)) & CAN_PL2_PLMASK_LO_Data_byte_0_MASK)
/*! @} */

/*! @name PL2_PLMASK_HI - Pretended Networking Payload High Filter 2 low order bits / Payload High Mask register */
/*! @{ */

#define CAN_PL2_PLMASK_HI_Data_byte_7_MASK       (0xFFU)
#define CAN_PL2_PLMASK_HI_Data_byte_7_SHIFT      (0U)
/*! Data_byte_7 - Payload Filter 2 high order bits / Payload Mask high order bits for Pretended
 *    Networking payload filtering corresponding to the data byte 7.
 */
#define CAN_PL2_PLMASK_HI_Data_byte_7(x)         (((uint32_t)(((uint32_t)(x)) << CAN_PL2_PLMASK_HI_Data_byte_7_SHIFT)) & CAN_PL2_PLMASK_HI_Data_byte_7_MASK)

#define CAN_PL2_PLMASK_HI_Data_byte_6_MASK       (0xFF00U)
#define CAN_PL2_PLMASK_HI_Data_byte_6_SHIFT      (8U)
/*! Data_byte_6 - Payload Filter 2 high order bits / Payload Mask high order bits for Pretended
 *    Networking payload filtering corresponding to the data byte 6.
 */
#define CAN_PL2_PLMASK_HI_Data_byte_6(x)         (((uint32_t)(((uint32_t)(x)) << CAN_PL2_PLMASK_HI_Data_byte_6_SHIFT)) & CAN_PL2_PLMASK_HI_Data_byte_6_MASK)

#define CAN_PL2_PLMASK_HI_Data_byte_5_MASK       (0xFF0000U)
#define CAN_PL2_PLMASK_HI_Data_byte_5_SHIFT      (16U)
/*! Data_byte_5 - Payload Filter 2 high order bits / Payload Mask high order bits for Pretended
 *    Networking payload filtering corresponding to the data byte 5.
 */
#define CAN_PL2_PLMASK_HI_Data_byte_5(x)         (((uint32_t)(((uint32_t)(x)) << CAN_PL2_PLMASK_HI_Data_byte_5_SHIFT)) & CAN_PL2_PLMASK_HI_Data_byte_5_MASK)

#define CAN_PL2_PLMASK_HI_Data_byte_4_MASK       (0xFF000000U)
#define CAN_PL2_PLMASK_HI_Data_byte_4_SHIFT      (24U)
/*! Data_byte_4 - Payload Filter 2 high order bits / Payload Mask high order bits for Pretended
 *    Networking payload filtering corresponding to the data byte 4.
 */
#define CAN_PL2_PLMASK_HI_Data_byte_4(x)         (((uint32_t)(((uint32_t)(x)) << CAN_PL2_PLMASK_HI_Data_byte_4_SHIFT)) & CAN_PL2_PLMASK_HI_Data_byte_4_MASK)
/*! @} */

/*! @name WMB_CS - Wake Up Message Buffer register for C/S */
/*! @{ */

#define CAN_WMB_CS_DLC_MASK                      (0xF0000U)
#define CAN_WMB_CS_DLC_SHIFT                     (16U)
/*! DLC - Length of Data in Bytes
 */
#define CAN_WMB_CS_DLC(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_WMB_CS_DLC_SHIFT)) & CAN_WMB_CS_DLC_MASK)

#define CAN_WMB_CS_RTR_MASK                      (0x100000U)
#define CAN_WMB_CS_RTR_SHIFT                     (20U)
/*! RTR - Remote Transmission Request Bit
 *  0b0..Frame is data one (not remote)
 *  0b1..Frame is a remote one
 */
#define CAN_WMB_CS_RTR(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_WMB_CS_RTR_SHIFT)) & CAN_WMB_CS_RTR_MASK)

#define CAN_WMB_CS_IDE_MASK                      (0x200000U)
#define CAN_WMB_CS_IDE_SHIFT                     (21U)
/*! IDE - ID Extended Bit
 *  0b0..Frame format is standard
 *  0b1..Frame format is extended
 */
#define CAN_WMB_CS_IDE(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_WMB_CS_IDE_SHIFT)) & CAN_WMB_CS_IDE_MASK)

#define CAN_WMB_CS_SRR_MASK                      (0x400000U)
#define CAN_WMB_CS_SRR_SHIFT                     (22U)
/*! SRR - Substitute Remote Request
 */
#define CAN_WMB_CS_SRR(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_WMB_CS_SRR_SHIFT)) & CAN_WMB_CS_SRR_MASK)
/*! @} */

/* The count of CAN_WMB_CS */
#define CAN_WMB_CS_COUNT                         (4U)

/*! @name WMB_ID - Wake Up Message Buffer Register for ID */
/*! @{ */

#define CAN_WMB_ID_ID_MASK                       (0x1FFFFFFFU)
#define CAN_WMB_ID_ID_SHIFT                      (0U)
/*! ID - Received ID under Pretended Networking mode
 */
#define CAN_WMB_ID_ID(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_WMB_ID_ID_SHIFT)) & CAN_WMB_ID_ID_MASK)
/*! @} */

/* The count of CAN_WMB_ID */
#define CAN_WMB_ID_COUNT                         (4U)

/*! @name WMB_D03 - Wake Up Message Buffer Register for Data 0-3 */
/*! @{ */

#define CAN_WMB_D03_Data_byte_3_MASK             (0xFFU)
#define CAN_WMB_D03_Data_byte_3_SHIFT            (0U)
/*! Data_byte_3 - Received payload corresponding to the data byte 3 under Pretended Networking mode
 */
#define CAN_WMB_D03_Data_byte_3(x)               (((uint32_t)(((uint32_t)(x)) << CAN_WMB_D03_Data_byte_3_SHIFT)) & CAN_WMB_D03_Data_byte_3_MASK)

#define CAN_WMB_D03_Data_byte_2_MASK             (0xFF00U)
#define CAN_WMB_D03_Data_byte_2_SHIFT            (8U)
/*! Data_byte_2 - Received payload corresponding to the data byte 2 under Pretended Networking mode
 */
#define CAN_WMB_D03_Data_byte_2(x)               (((uint32_t)(((uint32_t)(x)) << CAN_WMB_D03_Data_byte_2_SHIFT)) & CAN_WMB_D03_Data_byte_2_MASK)

#define CAN_WMB_D03_Data_byte_1_MASK             (0xFF0000U)
#define CAN_WMB_D03_Data_byte_1_SHIFT            (16U)
/*! Data_byte_1 - Received payload corresponding to the data byte 1 under Pretended Networking mode
 */
#define CAN_WMB_D03_Data_byte_1(x)               (((uint32_t)(((uint32_t)(x)) << CAN_WMB_D03_Data_byte_1_SHIFT)) & CAN_WMB_D03_Data_byte_1_MASK)

#define CAN_WMB_D03_Data_byte_0_MASK             (0xFF000000U)
#define CAN_WMB_D03_Data_byte_0_SHIFT            (24U)
/*! Data_byte_0 - Received payload corresponding to the data byte 0 under Pretended Networking mode
 */
#define CAN_WMB_D03_Data_byte_0(x)               (((uint32_t)(((uint32_t)(x)) << CAN_WMB_D03_Data_byte_0_SHIFT)) & CAN_WMB_D03_Data_byte_0_MASK)
/*! @} */

/* The count of CAN_WMB_D03 */
#define CAN_WMB_D03_COUNT                        (4U)

/*! @name WMB_D47 - Wake Up Message Buffer Register Data 4-7 */
/*! @{ */

#define CAN_WMB_D47_Data_byte_7_MASK             (0xFFU)
#define CAN_WMB_D47_Data_byte_7_SHIFT            (0U)
/*! Data_byte_7 - Received payload corresponding to the data byte 7 under Pretended Networking mode
 */
#define CAN_WMB_D47_Data_byte_7(x)               (((uint32_t)(((uint32_t)(x)) << CAN_WMB_D47_Data_byte_7_SHIFT)) & CAN_WMB_D47_Data_byte_7_MASK)

#define CAN_WMB_D47_Data_byte_6_MASK             (0xFF00U)
#define CAN_WMB_D47_Data_byte_6_SHIFT            (8U)
/*! Data_byte_6 - Received payload corresponding to the data byte 6 under Pretended Networking mode
 */
#define CAN_WMB_D47_Data_byte_6(x)               (((uint32_t)(((uint32_t)(x)) << CAN_WMB_D47_Data_byte_6_SHIFT)) & CAN_WMB_D47_Data_byte_6_MASK)

#define CAN_WMB_D47_Data_byte_5_MASK             (0xFF0000U)
#define CAN_WMB_D47_Data_byte_5_SHIFT            (16U)
/*! Data_byte_5 - Received payload corresponding to the data byte 5 under Pretended Networking mode
 */
#define CAN_WMB_D47_Data_byte_5(x)               (((uint32_t)(((uint32_t)(x)) << CAN_WMB_D47_Data_byte_5_SHIFT)) & CAN_WMB_D47_Data_byte_5_MASK)

#define CAN_WMB_D47_Data_byte_4_MASK             (0xFF000000U)
#define CAN_WMB_D47_Data_byte_4_SHIFT            (24U)
/*! Data_byte_4 - Received payload corresponding to the data byte 4 under Pretended Networking mode
 */
#define CAN_WMB_D47_Data_byte_4(x)               (((uint32_t)(((uint32_t)(x)) << CAN_WMB_D47_Data_byte_4_SHIFT)) & CAN_WMB_D47_Data_byte_4_MASK)
/*! @} */

/* The count of CAN_WMB_D47 */
#define CAN_WMB_D47_COUNT                        (4U)

/*! @name EPRS - Enhanced CAN Bit Timing Prescalers */
/*! @{ */

#define CAN_EPRS_ENPRESDIV_MASK                  (0x3FFU)
#define CAN_EPRS_ENPRESDIV_SHIFT                 (0U)
/*! ENPRESDIV - Extended Nominal Prescaler Division Factor
 */
#define CAN_EPRS_ENPRESDIV(x)                    (((uint32_t)(((uint32_t)(x)) << CAN_EPRS_ENPRESDIV_SHIFT)) & CAN_EPRS_ENPRESDIV_MASK)

#define CAN_EPRS_EDPRESDIV_MASK                  (0x3FF0000U)
#define CAN_EPRS_EDPRESDIV_SHIFT                 (16U)
/*! EDPRESDIV - Extended Data Phase Prescaler Division Factor
 */
#define CAN_EPRS_EDPRESDIV(x)                    (((uint32_t)(((uint32_t)(x)) << CAN_EPRS_EDPRESDIV_SHIFT)) & CAN_EPRS_EDPRESDIV_MASK)
/*! @} */

/*! @name ENCBT - Enhanced Nominal CAN Bit Timing */
/*! @{ */

#define CAN_ENCBT_NTSEG1_MASK                    (0xFFU)
#define CAN_ENCBT_NTSEG1_SHIFT                   (0U)
/*! NTSEG1 - Nominal Time Segment 1
 */
#define CAN_ENCBT_NTSEG1(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_ENCBT_NTSEG1_SHIFT)) & CAN_ENCBT_NTSEG1_MASK)

#define CAN_ENCBT_NTSEG2_MASK                    (0x7F000U)
#define CAN_ENCBT_NTSEG2_SHIFT                   (12U)
/*! NTSEG2 - Nominal Time Segment 2
 */
#define CAN_ENCBT_NTSEG2(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_ENCBT_NTSEG2_SHIFT)) & CAN_ENCBT_NTSEG2_MASK)

#define CAN_ENCBT_NRJW_MASK                      (0x1FC00000U)
#define CAN_ENCBT_NRJW_SHIFT                     (22U)
/*! NRJW - Nominal Resynchronization Jump Width
 */
#define CAN_ENCBT_NRJW(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_ENCBT_NRJW_SHIFT)) & CAN_ENCBT_NRJW_MASK)
/*! @} */

/*! @name EDCBT - Enhanced Data Phase CAN bit Timing */
/*! @{ */

#define CAN_EDCBT_DTSEG1_MASK                    (0x1FU)
#define CAN_EDCBT_DTSEG1_SHIFT                   (0U)
/*! DTSEG1 - Data Phase Segment 1
 */
#define CAN_EDCBT_DTSEG1(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_EDCBT_DTSEG1_SHIFT)) & CAN_EDCBT_DTSEG1_MASK)

#define CAN_EDCBT_DTSEG2_MASK                    (0xF000U)
#define CAN_EDCBT_DTSEG2_SHIFT                   (12U)
/*! DTSEG2 - Data Phase Time Segment 2
 */
#define CAN_EDCBT_DTSEG2(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_EDCBT_DTSEG2_SHIFT)) & CAN_EDCBT_DTSEG2_MASK)

#define CAN_EDCBT_DRJW_MASK                      (0x3C00000U)
#define CAN_EDCBT_DRJW_SHIFT                     (22U)
/*! DRJW - Data Phase Resynchronization Jump Width
 */
#define CAN_EDCBT_DRJW(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_EDCBT_DRJW_SHIFT)) & CAN_EDCBT_DRJW_MASK)
/*! @} */

/*! @name ETDC - Enhanced Transceiver Delay Compensation */
/*! @{ */

#define CAN_ETDC_ETDCVAL_MASK                    (0xFFU)
#define CAN_ETDC_ETDCVAL_SHIFT                   (0U)
/*! ETDCVAL - Enhanced Transceiver Delay Compensation Value
 */
#define CAN_ETDC_ETDCVAL(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_ETDC_ETDCVAL_SHIFT)) & CAN_ETDC_ETDCVAL_MASK)

#define CAN_ETDC_ETDCFAIL_MASK                   (0x8000U)
#define CAN_ETDC_ETDCFAIL_SHIFT                  (15U)
/*! ETDCFAIL - Transceiver Delay Compensation Fail
 *  0b0..Measured loop delay is in range.
 *  0b1..Measured loop delay is out of range.
 */
#define CAN_ETDC_ETDCFAIL(x)                     (((uint32_t)(((uint32_t)(x)) << CAN_ETDC_ETDCFAIL_SHIFT)) & CAN_ETDC_ETDCFAIL_MASK)

#define CAN_ETDC_ETDCOFF_MASK                    (0x7F0000U)
#define CAN_ETDC_ETDCOFF_SHIFT                   (16U)
/*! ETDCOFF - Enhanced Transceiver Delay Compensation Offset
 */
#define CAN_ETDC_ETDCOFF(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_ETDC_ETDCOFF_SHIFT)) & CAN_ETDC_ETDCOFF_MASK)

#define CAN_ETDC_TDMDIS_MASK                     (0x40000000U)
#define CAN_ETDC_TDMDIS_SHIFT                    (30U)
/*! TDMDIS - Transceiver Delay Measurement Disable
 *  0b0..TDC measurement is enabled
 *  0b1..TDC measurement is disabled
 */
#define CAN_ETDC_TDMDIS(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_ETDC_TDMDIS_SHIFT)) & CAN_ETDC_TDMDIS_MASK)

#define CAN_ETDC_ETDCEN_MASK                     (0x80000000U)
#define CAN_ETDC_ETDCEN_SHIFT                    (31U)
/*! ETDCEN - Transceiver Delay Compensation Enable
 *  0b0..TDC is disabled
 *  0b1..TDC is enabled
 */
#define CAN_ETDC_ETDCEN(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_ETDC_ETDCEN_SHIFT)) & CAN_ETDC_ETDCEN_MASK)
/*! @} */

/*! @name FDCTRL - CAN FD Control Register */
/*! @{ */

#define CAN_FDCTRL_TDCVAL_MASK                   (0x3FU)
#define CAN_FDCTRL_TDCVAL_SHIFT                  (0U)
/*! TDCVAL - Transceiver Delay Compensation Value
 */
#define CAN_FDCTRL_TDCVAL(x)                     (((uint32_t)(((uint32_t)(x)) << CAN_FDCTRL_TDCVAL_SHIFT)) & CAN_FDCTRL_TDCVAL_MASK)

#define CAN_FDCTRL_TDCOFF_MASK                   (0x1F00U)
#define CAN_FDCTRL_TDCOFF_SHIFT                  (8U)
/*! TDCOFF - Transceiver Delay Compensation Offset
 */
#define CAN_FDCTRL_TDCOFF(x)                     (((uint32_t)(((uint32_t)(x)) << CAN_FDCTRL_TDCOFF_SHIFT)) & CAN_FDCTRL_TDCOFF_MASK)

#define CAN_FDCTRL_TDCFAIL_MASK                  (0x4000U)
#define CAN_FDCTRL_TDCFAIL_SHIFT                 (14U)
/*! TDCFAIL - Transceiver Delay Compensation Fail
 *  0b0..Measured loop delay is in range.
 *  0b1..Measured loop delay is out of range.
 */
#define CAN_FDCTRL_TDCFAIL(x)                    (((uint32_t)(((uint32_t)(x)) << CAN_FDCTRL_TDCFAIL_SHIFT)) & CAN_FDCTRL_TDCFAIL_MASK)

#define CAN_FDCTRL_TDCEN_MASK                    (0x8000U)
#define CAN_FDCTRL_TDCEN_SHIFT                   (15U)
/*! TDCEN - Transceiver Delay Compensation Enable
 *  0b0..TDC is disabled
 *  0b1..TDC is enabled
 */
#define CAN_FDCTRL_TDCEN(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_FDCTRL_TDCEN_SHIFT)) & CAN_FDCTRL_TDCEN_MASK)

#define CAN_FDCTRL_MBDSR0_MASK                   (0x30000U)
#define CAN_FDCTRL_MBDSR0_SHIFT                  (16U)
/*! MBDSR0 - Message Buffer Data Size for Region 0
 *  0b00..Selects 8 bytes per message buffer.
 *  0b01..Selects 16 bytes per message buffer.
 *  0b10..Selects 32 bytes per message buffer.
 *  0b11..Selects 64 bytes per message buffer.
 */
#define CAN_FDCTRL_MBDSR0(x)                     (((uint32_t)(((uint32_t)(x)) << CAN_FDCTRL_MBDSR0_SHIFT)) & CAN_FDCTRL_MBDSR0_MASK)

#define CAN_FDCTRL_FDRATE_MASK                   (0x80000000U)
#define CAN_FDCTRL_FDRATE_SHIFT                  (31U)
/*! FDRATE - Bit Rate Switch Enable
 *  0b0..Transmit a frame in nominal rate. The BRS bit in the Tx MB has no effect.
 *  0b1..Transmit a frame with bit rate switching if the BRS bit in the Tx MB is recessive.
 */
#define CAN_FDCTRL_FDRATE(x)                     (((uint32_t)(((uint32_t)(x)) << CAN_FDCTRL_FDRATE_SHIFT)) & CAN_FDCTRL_FDRATE_MASK)
/*! @} */

/*! @name FDCBT - CAN FD Bit Timing Register */
/*! @{ */

#define CAN_FDCBT_FPSEG2_MASK                    (0x7U)
#define CAN_FDCBT_FPSEG2_SHIFT                   (0U)
/*! FPSEG2 - Fast Phase Segment 2
 */
#define CAN_FDCBT_FPSEG2(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_FDCBT_FPSEG2_SHIFT)) & CAN_FDCBT_FPSEG2_MASK)

#define CAN_FDCBT_FPSEG1_MASK                    (0xE0U)
#define CAN_FDCBT_FPSEG1_SHIFT                   (5U)
/*! FPSEG1 - Fast Phase Segment 1
 */
#define CAN_FDCBT_FPSEG1(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_FDCBT_FPSEG1_SHIFT)) & CAN_FDCBT_FPSEG1_MASK)

#define CAN_FDCBT_FPROPSEG_MASK                  (0x7C00U)
#define CAN_FDCBT_FPROPSEG_SHIFT                 (10U)
/*! FPROPSEG - Fast Propagation Segment
 */
#define CAN_FDCBT_FPROPSEG(x)                    (((uint32_t)(((uint32_t)(x)) << CAN_FDCBT_FPROPSEG_SHIFT)) & CAN_FDCBT_FPROPSEG_MASK)

#define CAN_FDCBT_FRJW_MASK                      (0x70000U)
#define CAN_FDCBT_FRJW_SHIFT                     (16U)
/*! FRJW - Fast Resync Jump Width
 */
#define CAN_FDCBT_FRJW(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_FDCBT_FRJW_SHIFT)) & CAN_FDCBT_FRJW_MASK)

#define CAN_FDCBT_FPRESDIV_MASK                  (0x3FF00000U)
#define CAN_FDCBT_FPRESDIV_SHIFT                 (20U)
/*! FPRESDIV - Fast Prescaler Division Factor
 */
#define CAN_FDCBT_FPRESDIV(x)                    (((uint32_t)(((uint32_t)(x)) << CAN_FDCBT_FPRESDIV_SHIFT)) & CAN_FDCBT_FPRESDIV_MASK)
/*! @} */

/*! @name FDCRC - CAN FD CRC Register */
/*! @{ */

#define CAN_FDCRC_FD_TXCRC_MASK                  (0x1FFFFFU)
#define CAN_FDCRC_FD_TXCRC_SHIFT                 (0U)
/*! FD_TXCRC - Extended Transmitted CRC value
 */
#define CAN_FDCRC_FD_TXCRC(x)                    (((uint32_t)(((uint32_t)(x)) << CAN_FDCRC_FD_TXCRC_SHIFT)) & CAN_FDCRC_FD_TXCRC_MASK)

#define CAN_FDCRC_FD_MBCRC_MASK                  (0x7F000000U)
#define CAN_FDCRC_FD_MBCRC_SHIFT                 (24U)
/*! FD_MBCRC - CRC Mailbox Number for FD_TXCRC
 */
#define CAN_FDCRC_FD_MBCRC(x)                    (((uint32_t)(((uint32_t)(x)) << CAN_FDCRC_FD_MBCRC_SHIFT)) & CAN_FDCRC_FD_MBCRC_MASK)
/*! @} */

/*! @name ERFCR - Enhanced Rx FIFO Control Register */
/*! @{ */

#define CAN_ERFCR_ERFWM_MASK                     (0x1FU)
#define CAN_ERFCR_ERFWM_SHIFT                    (0U)
/*! ERFWM - Enhanced Rx FIFO Watermark
 */
#define CAN_ERFCR_ERFWM(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_ERFCR_ERFWM_SHIFT)) & CAN_ERFCR_ERFWM_MASK)

#define CAN_ERFCR_NFE_MASK                       (0x3F00U)
#define CAN_ERFCR_NFE_SHIFT                      (8U)
/*! NFE - Number of Enhanced Rx FIFO Filter Elements
 */
#define CAN_ERFCR_NFE(x)                         (((uint32_t)(((uint32_t)(x)) << CAN_ERFCR_NFE_SHIFT)) & CAN_ERFCR_NFE_MASK)

#define CAN_ERFCR_NEXIF_MASK                     (0x7F0000U)
#define CAN_ERFCR_NEXIF_SHIFT                    (16U)
/*! NEXIF - Number of Extended ID Filter Elements
 */
#define CAN_ERFCR_NEXIF(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_ERFCR_NEXIF_SHIFT)) & CAN_ERFCR_NEXIF_MASK)

#define CAN_ERFCR_DMALW_MASK                     (0x7C000000U)
#define CAN_ERFCR_DMALW_SHIFT                    (26U)
/*! DMALW - DMA Last Word
 */
#define CAN_ERFCR_DMALW(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_ERFCR_DMALW_SHIFT)) & CAN_ERFCR_DMALW_MASK)

#define CAN_ERFCR_ERFEN_MASK                     (0x80000000U)
#define CAN_ERFCR_ERFEN_SHIFT                    (31U)
/*! ERFEN - Enhanced Rx FIFO enable
 *  0b0..Enhanced Rx FIFO is disabled
 *  0b1..Enhanced Rx FIFO is enabled
 */
#define CAN_ERFCR_ERFEN(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_ERFCR_ERFEN_SHIFT)) & CAN_ERFCR_ERFEN_MASK)
/*! @} */

/*! @name ERFIER - Enhanced Rx FIFO Interrupt Enable Register */
/*! @{ */

#define CAN_ERFIER_ERFDAIE_MASK                  (0x10000000U)
#define CAN_ERFIER_ERFDAIE_SHIFT                 (28U)
/*! ERFDAIE - Enhanced Rx FIFO Data Available Interrupt Enable
 *  0b0..Enhanced Rx FIFO Data Available interrupt is disabled
 *  0b1..Enhanced Rx FIFO Data Available interrupt is enabled
 */
#define CAN_ERFIER_ERFDAIE(x)                    (((uint32_t)(((uint32_t)(x)) << CAN_ERFIER_ERFDAIE_SHIFT)) & CAN_ERFIER_ERFDAIE_MASK)

#define CAN_ERFIER_ERFWMIIE_MASK                 (0x20000000U)
#define CAN_ERFIER_ERFWMIIE_SHIFT                (29U)
/*! ERFWMIIE - Enhanced Rx FIFO Watermark Indication Interrupt Enable
 *  0b0..Enhanced Rx FIFO Watermark interrupt is disabled
 *  0b1..Enhanced Rx FIFO Watermark interrupt is enabled
 */
#define CAN_ERFIER_ERFWMIIE(x)                   (((uint32_t)(((uint32_t)(x)) << CAN_ERFIER_ERFWMIIE_SHIFT)) & CAN_ERFIER_ERFWMIIE_MASK)

#define CAN_ERFIER_ERFOVFIE_MASK                 (0x40000000U)
#define CAN_ERFIER_ERFOVFIE_SHIFT                (30U)
/*! ERFOVFIE - Enhanced Rx FIFO Overflow Interrupt Enable
 *  0b0..Enhanced Rx FIFO Overflow is disabled
 *  0b1..Enhanced Rx FIFO Overflow is enabled
 */
#define CAN_ERFIER_ERFOVFIE(x)                   (((uint32_t)(((uint32_t)(x)) << CAN_ERFIER_ERFOVFIE_SHIFT)) & CAN_ERFIER_ERFOVFIE_MASK)

#define CAN_ERFIER_ERFUFWIE_MASK                 (0x80000000U)
#define CAN_ERFIER_ERFUFWIE_SHIFT                (31U)
/*! ERFUFWIE - Enhanced Rx FIFO Underflow Interrupt Enable
 *  0b0..Enhanced Rx FIFO Underflow interrupt is disabled
 *  0b1..Enhanced Rx FIFO Underflow interrupt is enabled
 */
#define CAN_ERFIER_ERFUFWIE(x)                   (((uint32_t)(((uint32_t)(x)) << CAN_ERFIER_ERFUFWIE_SHIFT)) & CAN_ERFIER_ERFUFWIE_MASK)
/*! @} */

/*! @name ERFSR - Enhanced Rx FIFO Status Register */
/*! @{ */

#define CAN_ERFSR_ERFEL_MASK                     (0x3FU)
#define CAN_ERFSR_ERFEL_SHIFT                    (0U)
/*! ERFEL - Enhanced Rx FIFO Elements
 */
#define CAN_ERFSR_ERFEL(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_ERFSR_ERFEL_SHIFT)) & CAN_ERFSR_ERFEL_MASK)

#define CAN_ERFSR_ERFF_MASK                      (0x10000U)
#define CAN_ERFSR_ERFF_SHIFT                     (16U)
/*! ERFF - Enhanced Rx FIFO full
 *  0b0..Enhanced Rx FIFO is not full
 *  0b1..Enhanced Rx FIFO is full
 */
#define CAN_ERFSR_ERFF(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_ERFSR_ERFF_SHIFT)) & CAN_ERFSR_ERFF_MASK)

#define CAN_ERFSR_ERFE_MASK                      (0x20000U)
#define CAN_ERFSR_ERFE_SHIFT                     (17U)
/*! ERFE - Enhanced Rx FIFO empty
 *  0b0..Enhanced Rx FIFO is not empty
 *  0b1..Enhanced Rx FIFO is empty
 */
#define CAN_ERFSR_ERFE(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_ERFSR_ERFE_SHIFT)) & CAN_ERFSR_ERFE_MASK)

#define CAN_ERFSR_ERFCLR_MASK                    (0x8000000U)
#define CAN_ERFSR_ERFCLR_SHIFT                   (27U)
/*! ERFCLR - Enhanced Rx FIFO Clear
 *  0b0..No effect
 *  0b1..Clear Enhanced Rx FIFO content
 */
#define CAN_ERFSR_ERFCLR(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_ERFSR_ERFCLR_SHIFT)) & CAN_ERFSR_ERFCLR_MASK)

#define CAN_ERFSR_ERFDA_MASK                     (0x10000000U)
#define CAN_ERFSR_ERFDA_SHIFT                    (28U)
/*! ERFDA - Enhanced Rx FIFO Data Available
 *  0b0..No such occurrence
 *  0b1..There is at least one message stored in Enhanced Rx FIFO
 */
#define CAN_ERFSR_ERFDA(x)                       (((uint32_t)(((uint32_t)(x)) << CAN_ERFSR_ERFDA_SHIFT)) & CAN_ERFSR_ERFDA_MASK)

#define CAN_ERFSR_ERFWMI_MASK                    (0x20000000U)
#define CAN_ERFSR_ERFWMI_SHIFT                   (29U)
/*! ERFWMI - Enhanced Rx FIFO Watermark Indication
 *  0b0..No such occurrence
 *  0b1..The number of messages in FIFO is greater than the watermark
 */
#define CAN_ERFSR_ERFWMI(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_ERFSR_ERFWMI_SHIFT)) & CAN_ERFSR_ERFWMI_MASK)

#define CAN_ERFSR_ERFOVF_MASK                    (0x40000000U)
#define CAN_ERFSR_ERFOVF_SHIFT                   (30U)
/*! ERFOVF - Enhanced Rx FIFO Overflow
 *  0b0..No such occurrence
 *  0b1..Enhanced Rx FIFO overflow
 */
#define CAN_ERFSR_ERFOVF(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_ERFSR_ERFOVF_SHIFT)) & CAN_ERFSR_ERFOVF_MASK)

#define CAN_ERFSR_ERFUFW_MASK                    (0x80000000U)
#define CAN_ERFSR_ERFUFW_SHIFT                   (31U)
/*! ERFUFW - Enhanced Rx FIFO Underflow
 *  0b0..No such occurrence
 *  0b1..Enhanced Rx FIFO underflow
 */
#define CAN_ERFSR_ERFUFW(x)                      (((uint32_t)(((uint32_t)(x)) << CAN_ERFSR_ERFUFW_SHIFT)) & CAN_ERFSR_ERFUFW_MASK)
/*! @} */

/*! @name ERFFEL - Enhanced Rx FIFO Filter Element */
/*! @{ */

#define CAN_ERFFEL_FEL_MASK                      (0xFFFFFFFFU)
#define CAN_ERFFEL_FEL_SHIFT                     (0U)
/*! FEL - Filter Element Bits
 */
#define CAN_ERFFEL_FEL(x)                        (((uint32_t)(((uint32_t)(x)) << CAN_ERFFEL_FEL_SHIFT)) & CAN_ERFFEL_FEL_MASK)
/*! @} */

/* The count of CAN_ERFFEL */
#define CAN_ERFFEL_COUNT                         (32U)


/*!
 * @}
 */ /* end of group CAN_Register_Masks */


/* CAN - Peripheral instance base addresses */
#if (defined(__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE & 0x2))
  /** Peripheral CAN0 base address */
  #define CAN0_BASE                                (0x5003B000u)
  /** Peripheral CAN0 base address */
  #define CAN0_BASE_NS                             (0x4003B000u)
  /** Peripheral CAN0 base pointer */
  #define CAN0                                     ((CAN_Type *)CAN0_BASE)
  /** Peripheral CAN0 base pointer */
  #define CAN0_NS                                  ((CAN_Type *)CAN0_BASE_NS)
  /** Array initializer of CAN peripheral base addresses */
  #define CAN_BASE_ADDRS                           { CAN0_BASE }
  /** Array initializer of CAN peripheral base pointers */
  #define CAN_BASE_PTRS                            { CAN0 }
  /** Array initializer of CAN peripheral base addresses */
  #define CAN_BASE_ADDRS_NS                        { CAN0_BASE_NS }
  /** Array initializer of CAN peripheral base pointers */
  #define CAN_BASE_PTRS_NS                         { CAN0_NS }
#else
  /** Peripheral CAN0 base address */
  #define CAN0_BASE                                (0x4003B000u)
  /** Peripheral CAN0 base pointer */
  #define CAN0                                     ((CAN_Type *)CAN0_BASE)
  /** Array initializer of CAN peripheral base addresses */
  #define CAN_BASE_ADDRS                           { CAN0_BASE }
  /** Array initializer of CAN peripheral base pointers */
  #define CAN_BASE_PTRS                            { CAN0 }
#endif
/** Interrupt vectors for the CAN peripheral type */
#define CAN_Rx_Warning_IRQS                      { CAN0_IRQn }
#define CAN_Tx_Warning_IRQS                      { CAN0_IRQn }
#define CAN_Wake_Up_IRQS                         { CAN0_IRQn }
#define CAN_Error_IRQS                           { CAN0_IRQn }
#define CAN_Bus_Off_IRQS                         { CAN0_IRQn }
#define CAN_ORed_Message_buffer_IRQS             { CAN0_IRQn }

/*!
 * @}
 */ /* end of group CAN_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- CCM32K Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CCM32K_Peripheral_Access_Layer CCM32K Peripheral Access Layer
 * @{
 */

/** CCM32K - Register Layout Typedef */
typedef struct {
  __IO uint32_t FRO32K_CTRL;                       /**< Free Running 32 kHz Oscillator Control Register, offset: 0x0 */
  __IO uint32_t FRO32K_TRIM;                       /**< Free Running 32 kHz Oscillator Trim Register, offset: 0x4 */
  __IO uint32_t OSC32K_CTRL;                       /**< 32 kHz OSC Control Register, offset: 0x8 */
  __I  uint32_t STATUS;                            /**< Status Register, offset: 0xC */
       uint8_t RESERVED_0[4];
  __IO uint32_t CLKMON_CTRL;                       /**< Clock Monitor Control Register, offset: 0x14 */
       uint8_t RESERVED_1[4];
  __IO uint32_t CGC32K;                            /**< 32 kHz Clock Gate Control Register, offset: 0x1C */
} CCM32K_Type;

/* ----------------------------------------------------------------------------
   -- CCM32K Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CCM32K_Register_Masks CCM32K Register Masks
 * @{
 */

/*! @name FRO32K_CTRL - Free Running 32 kHz Oscillator Control Register */
/*! @{ */

#define CCM32K_FRO32K_CTRL_FRO_EN_MASK           (0x1U)
#define CCM32K_FRO32K_CTRL_FRO_EN_SHIFT          (0U)
/*! FRO_EN - FRO Enable
 *  0b0..FRO is disabled
 *  0b1..FRO is enabled
 */
#define CCM32K_FRO32K_CTRL_FRO_EN(x)             (((uint32_t)(((uint32_t)(x)) << CCM32K_FRO32K_CTRL_FRO_EN_SHIFT)) & CCM32K_FRO32K_CTRL_FRO_EN_MASK)

#define CCM32K_FRO32K_CTRL_LOCK_EN_MASK          (0x80000000U)
#define CCM32K_FRO32K_CTRL_LOCK_EN_SHIFT         (31U)
/*! LOCK_EN - Write Access Lock
 *  0b0..Register write access is unlocked
 *  0b1..Register write access is locked
 */
#define CCM32K_FRO32K_CTRL_LOCK_EN(x)            (((uint32_t)(((uint32_t)(x)) << CCM32K_FRO32K_CTRL_LOCK_EN_SHIFT)) & CCM32K_FRO32K_CTRL_LOCK_EN_MASK)
/*! @} */

/*! @name FRO32K_TRIM - Free Running 32 kHz Oscillator Trim Register */
/*! @{ */

#define CCM32K_FRO32K_TRIM_FREQ_TRIM_MASK        (0x7FFU)
#define CCM32K_FRO32K_TRIM_FREQ_TRIM_SHIFT       (0U)
/*! FREQ_TRIM - Frequency Trim
 *  0b10000000000..Default trim value
 */
#define CCM32K_FRO32K_TRIM_FREQ_TRIM(x)          (((uint32_t)(((uint32_t)(x)) << CCM32K_FRO32K_TRIM_FREQ_TRIM_SHIFT)) & CCM32K_FRO32K_TRIM_FREQ_TRIM_MASK)

#define CCM32K_FRO32K_TRIM_IFR_DIS_MASK          (0x20000000U)
#define CCM32K_FRO32K_TRIM_IFR_DIS_SHIFT         (29U)
/*! IFR_DIS - IFR Loading Disable Control
 *  0b0..IFR loading is enabled
 *  0b1..IFR loading is disabled
 */
#define CCM32K_FRO32K_TRIM_IFR_DIS(x)            (((uint32_t)(((uint32_t)(x)) << CCM32K_FRO32K_TRIM_IFR_DIS_SHIFT)) & CCM32K_FRO32K_TRIM_IFR_DIS_MASK)

#define CCM32K_FRO32K_TRIM_LOCK_EN_MASK          (0x80000000U)
#define CCM32K_FRO32K_TRIM_LOCK_EN_SHIFT         (31U)
/*! LOCK_EN - Write Access Lock
 *  0b0..Register write access is unlocked
 *  0b1..Register write access is locked
 */
#define CCM32K_FRO32K_TRIM_LOCK_EN(x)            (((uint32_t)(((uint32_t)(x)) << CCM32K_FRO32K_TRIM_LOCK_EN_SHIFT)) & CCM32K_FRO32K_TRIM_LOCK_EN_MASK)
/*! @} */

/*! @name OSC32K_CTRL - 32 kHz OSC Control Register */
/*! @{ */

#define CCM32K_OSC32K_CTRL_OSC_EN_MASK           (0x1U)
#define CCM32K_OSC32K_CTRL_OSC_EN_SHIFT          (0U)
/*! OSC_EN - Crystal Oscillator Enable
 *  0b0..Oscillator is disabled
 *  0b1..Oscillator is enabled
 */
#define CCM32K_OSC32K_CTRL_OSC_EN(x)             (((uint32_t)(((uint32_t)(x)) << CCM32K_OSC32K_CTRL_OSC_EN_SHIFT)) & CCM32K_OSC32K_CTRL_OSC_EN_MASK)

#define CCM32K_OSC32K_CTRL_OSC_BYP_EN_MASK       (0x2U)
#define CCM32K_OSC32K_CTRL_OSC_BYP_EN_SHIFT      (1U)
/*! OSC_BYP_EN - Crystal Oscillator Bypass Enable
 *  0b0..Crystal oscillator is not bypassed
 *  0b1..Crystal oscillator is bypassed
 */
#define CCM32K_OSC32K_CTRL_OSC_BYP_EN(x)         (((uint32_t)(((uint32_t)(x)) << CCM32K_OSC32K_CTRL_OSC_BYP_EN_SHIFT)) & CCM32K_OSC32K_CTRL_OSC_BYP_EN_MASK)

#define CCM32K_OSC32K_CTRL_CAP_SEL_EN_MASK       (0x80U)
#define CCM32K_OSC32K_CTRL_CAP_SEL_EN_SHIFT      (7U)
/*! CAP_SEL_EN - Crystal Load Capacitance Selection Enable
 *  0b0..Internal capacitance bank is not enabled
 *  0b1..Internal capacitance bank is enabled
 */
#define CCM32K_OSC32K_CTRL_CAP_SEL_EN(x)         (((uint32_t)(((uint32_t)(x)) << CCM32K_OSC32K_CTRL_CAP_SEL_EN_SHIFT)) & CCM32K_OSC32K_CTRL_CAP_SEL_EN_MASK)

#define CCM32K_OSC32K_CTRL_EXTAL_CAP_SEL_MASK    (0xF00U)
#define CCM32K_OSC32K_CTRL_EXTAL_CAP_SEL_SHIFT   (8U)
/*! EXTAL_CAP_SEL - Crystal load capacitance selection bits
 *  0b0000..0 pF
 *  0b0001..2 pF
 *  0b0010..4 pF
 *  0b0011..6 pF
 *  0b0100..8 pF
 *  0b0101..10 pF
 *  0b0110..12 pF
 *  0b0111..14 pF
 *  0b1000..16 pF
 *  0b1001..18 pF
 *  0b1010..20 pF
 *  0b1011..22 pF
 *  0b1100..24 pF
 *  0b1101..26 pF
 *  0b1110..28 pF
 *  0b1111..30 pF
 */
#define CCM32K_OSC32K_CTRL_EXTAL_CAP_SEL(x)      (((uint32_t)(((uint32_t)(x)) << CCM32K_OSC32K_CTRL_EXTAL_CAP_SEL_SHIFT)) & CCM32K_OSC32K_CTRL_EXTAL_CAP_SEL_MASK)

#define CCM32K_OSC32K_CTRL_XTAL_CAP_SEL_MASK     (0xF000U)
#define CCM32K_OSC32K_CTRL_XTAL_CAP_SEL_SHIFT    (12U)
/*! XTAL_CAP_SEL - Crystal load capacitance selection bits
 *  0b0000..0 pF
 *  0b0001..2 pF
 *  0b0010..4 pF
 *  0b0011..6 pF
 *  0b0100..8 pF
 *  0b0101..10 pF
 *  0b0110..12 pF
 *  0b0111..14 pF
 *  0b1000..16 pF
 *  0b1001..18 pF
 *  0b1010..20 pF
 *  0b1011..22 pF
 *  0b1100..24 pF
 *  0b1101..26 pF
 *  0b1110..28 pF
 *  0b1111..30 pF
 */
#define CCM32K_OSC32K_CTRL_XTAL_CAP_SEL(x)       (((uint32_t)(((uint32_t)(x)) << CCM32K_OSC32K_CTRL_XTAL_CAP_SEL_SHIFT)) & CCM32K_OSC32K_CTRL_XTAL_CAP_SEL_MASK)

#define CCM32K_OSC32K_CTRL_COARSE_AMP_GAIN_MASK  (0x300000U)
#define CCM32K_OSC32K_CTRL_COARSE_AMP_GAIN_SHIFT (20U)
/*! COARSE_AMP_GAIN - Amplifier gain adjustment bits to allow the use of a wide range of external crystal ESR values.
 *  0b00..ESR_Range0
 *  0b01..ESR_Range1
 *  0b10..ESR_Range2
 *  0b11..ESR_Range3
 */
#define CCM32K_OSC32K_CTRL_COARSE_AMP_GAIN(x)    (((uint32_t)(((uint32_t)(x)) << CCM32K_OSC32K_CTRL_COARSE_AMP_GAIN_SHIFT)) & CCM32K_OSC32K_CTRL_COARSE_AMP_GAIN_MASK)

#define CCM32K_OSC32K_CTRL_SOX_EN_MASK           (0x1000000U)
#define CCM32K_OSC32K_CTRL_SOX_EN_SHIFT          (24U)
/*! SOX_EN - SOX Mode Enable
 *  0b1..SOX mode is enabled.
 *  0b0..SOX mode is disabled.
 */
#define CCM32K_OSC32K_CTRL_SOX_EN(x)             (((uint32_t)(((uint32_t)(x)) << CCM32K_OSC32K_CTRL_SOX_EN_SHIFT)) & CCM32K_OSC32K_CTRL_SOX_EN_MASK)

#define CCM32K_OSC32K_CTRL_LOCK_EN_MASK          (0x80000000U)
#define CCM32K_OSC32K_CTRL_LOCK_EN_SHIFT         (31U)
/*! LOCK_EN - Write Access Lock bit
 *  0b0..Register write access is unlocked
 *  0b1..Register write access is locked
 */
#define CCM32K_OSC32K_CTRL_LOCK_EN(x)            (((uint32_t)(((uint32_t)(x)) << CCM32K_OSC32K_CTRL_LOCK_EN_SHIFT)) & CCM32K_OSC32K_CTRL_LOCK_EN_MASK)
/*! @} */

/*! @name STATUS - Status Register */
/*! @{ */

#define CCM32K_STATUS_OSC32K_RDY_MASK            (0x1U)
#define CCM32K_STATUS_OSC32K_RDY_SHIFT           (0U)
/*! OSC32K_RDY - 32 kHz Oscillator ready bit.
 *  0b0..Clock output from crystal oscillator is not stable.
 *  0b1..Clock output from crystal oscillator is stable.
 */
#define CCM32K_STATUS_OSC32K_RDY(x)              (((uint32_t)(((uint32_t)(x)) << CCM32K_STATUS_OSC32K_RDY_SHIFT)) & CCM32K_STATUS_OSC32K_RDY_MASK)

#define CCM32K_STATUS_OSC32K_ACTIVE_MASK         (0x4U)
#define CCM32K_STATUS_OSC32K_ACTIVE_SHIFT        (2U)
/*! OSC32K_ACTIVE - 32 kHz Oscillator active bit
 *  0b1..OSC32K is the active clock source
 *  0b0..OSC32K is not the active clock source
 */
#define CCM32K_STATUS_OSC32K_ACTIVE(x)           (((uint32_t)(((uint32_t)(x)) << CCM32K_STATUS_OSC32K_ACTIVE_SHIFT)) & CCM32K_STATUS_OSC32K_ACTIVE_MASK)

#define CCM32K_STATUS_FRO32K_ACTIVE_MASK         (0x10U)
#define CCM32K_STATUS_FRO32K_ACTIVE_SHIFT        (4U)
/*! FRO32K_ACTIVE - 32 kHz FRO active bit
 *  0b1..FRO32K is the active clock source
 *  0b0..FRO32K is not the active clock source
 */
#define CCM32K_STATUS_FRO32K_ACTIVE(x)           (((uint32_t)(((uint32_t)(x)) << CCM32K_STATUS_FRO32K_ACTIVE_SHIFT)) & CCM32K_STATUS_FRO32K_ACTIVE_MASK)

#define CCM32K_STATUS_CLOCK_DET_MASK             (0x40U)
#define CCM32K_STATUS_CLOCK_DET_SHIFT            (6U)
/*! CLOCK_DET - Clock Detect
 *  0b1..Clock error is detected
 *  0b0..Clock error is not detected
 */
#define CCM32K_STATUS_CLOCK_DET(x)               (((uint32_t)(((uint32_t)(x)) << CCM32K_STATUS_CLOCK_DET_SHIFT)) & CCM32K_STATUS_CLOCK_DET_MASK)
/*! @} */

/*! @name CLKMON_CTRL - Clock Monitor Control Register */
/*! @{ */

#define CCM32K_CLKMON_CTRL_MON_EN_MASK           (0x1U)
#define CCM32K_CLKMON_CTRL_MON_EN_SHIFT          (0U)
/*! MON_EN - CLKMON Enable
 *  0b0..CLKMON is disabled
 *  0b1..CLKMON is enabled
 */
#define CCM32K_CLKMON_CTRL_MON_EN(x)             (((uint32_t)(((uint32_t)(x)) << CCM32K_CLKMON_CTRL_MON_EN_SHIFT)) & CCM32K_CLKMON_CTRL_MON_EN_MASK)

#define CCM32K_CLKMON_CTRL_FREQ_TRIM_MASK        (0x6U)
#define CCM32K_CLKMON_CTRL_FREQ_TRIM_SHIFT       (1U)
/*! FREQ_TRIM - Frequency trim bits
 *  0b00..Clock monitor asserts 2 cycle after expected edge (assert after 10 cycles with no edge)
 *  0b01..Clock monitor asserts 4 cycles after expected edge (assert after 12 cycles with no edge)
 *  0b10..Clock monitor asserts 6 cycles after expected edge (assert after 14 cycles with no edge)
 *  0b11..Clock monitor asserts 8 cycles after expected edge (assert after 16 cycles with no edge)
 */
#define CCM32K_CLKMON_CTRL_FREQ_TRIM(x)          (((uint32_t)(((uint32_t)(x)) << CCM32K_CLKMON_CTRL_FREQ_TRIM_SHIFT)) & CCM32K_CLKMON_CTRL_FREQ_TRIM_MASK)

#define CCM32K_CLKMON_CTRL_DIVIDE_TRIM_MASK      (0x18U)
#define CCM32K_CLKMON_CTRL_DIVIDE_TRIM_SHIFT     (3U)
/*! DIVIDE_TRIM - Divide Trim
 *  0b00..Clock monitor operates at 1 kHz for both FRO32K and OSC32K
 *  0b01..Clock monitor operates at 64 Hz for FRO32K and clock monitor operates at 1 kHz for OSC32K (Reserved)
 *  0b10..Clock monitor operates at 1 kHz for FRO32K and clock monitor operates at 64 Hz for OSC32K (Reserved)
 *  0b11..Clock monitor operates at 64 Hz for both FRO32K and OSC32K
 */
#define CCM32K_CLKMON_CTRL_DIVIDE_TRIM(x)        (((uint32_t)(((uint32_t)(x)) << CCM32K_CLKMON_CTRL_DIVIDE_TRIM_SHIFT)) & CCM32K_CLKMON_CTRL_DIVIDE_TRIM_MASK)

#define CCM32K_CLKMON_CTRL_LOCK_EN_MASK          (0x80000000U)
#define CCM32K_CLKMON_CTRL_LOCK_EN_SHIFT         (31U)
/*! LOCK_EN - Write Access Lock bit
 *  0b0..Register write access is unlocked
 *  0b1..Register write access is locked
 */
#define CCM32K_CLKMON_CTRL_LOCK_EN(x)            (((uint32_t)(((uint32_t)(x)) << CCM32K_CLKMON_CTRL_LOCK_EN_SHIFT)) & CCM32K_CLKMON_CTRL_LOCK_EN_MASK)
/*! @} */

/*! @name CGC32K - 32 kHz Clock Gate Control Register */
/*! @{ */

#define CCM32K_CGC32K_CLK_OE_32K_MASK            (0x1FU)
#define CCM32K_CGC32K_CLK_OE_32K_SHIFT           (0U)
/*! CLK_OE_32K - 32 kHz clock output enable bits
 *  0b00000..Clock output is disabled
 *  0b00001..Clock output is enabled
 */
#define CCM32K_CGC32K_CLK_OE_32K(x)              (((uint32_t)(((uint32_t)(x)) << CCM32K_CGC32K_CLK_OE_32K_SHIFT)) & CCM32K_CGC32K_CLK_OE_32K_MASK)

#define CCM32K_CGC32K_CLK_SEL_32K_MASK           (0x20U)
#define CCM32K_CGC32K_CLK_SEL_32K_SHIFT          (5U)
/*! CLK_SEL_32K - 32 kHz clock source selection bit
 *  0b0..FRO32K clock output is selected as clock source
 *  0b1..OSC32K clock output is selected as clock source
 */
#define CCM32K_CGC32K_CLK_SEL_32K(x)             (((uint32_t)(((uint32_t)(x)) << CCM32K_CGC32K_CLK_SEL_32K_SHIFT)) & CCM32K_CGC32K_CLK_SEL_32K_MASK)

#define CCM32K_CGC32K_LOCK_EN_MASK               (0x80000000U)
#define CCM32K_CGC32K_LOCK_EN_SHIFT              (31U)
/*! LOCK_EN - Write Access Lock bit
 *  0b0..Register write access is unlocked
 *  0b1..Register write access is locked
 */
#define CCM32K_CGC32K_LOCK_EN(x)                 (((uint32_t)(((uint32_t)(x)) << CCM32K_CGC32K_LOCK_EN_SHIFT)) & CCM32K_CGC32K_LOCK_EN_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group CCM32K_Register_Masks */


/* CCM32K - Peripheral instance base addresses */
#if (defined(__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE & 0x2))
  /** Peripheral CCM32K base address */
  #define CCM32K_BASE                              (0x5001F000u)
  /** Peripheral CCM32K base address */
  #define CCM32K_BASE_NS                           (0x4001F000u)
  /** Peripheral CCM32K base pointer */
  #define CCM32K                                   ((CCM32K_Type *)CCM32K_BASE)
  /** Peripheral CCM32K base pointer */
  #define CCM32K_NS                                ((CCM32K_Type *)CCM32K_BASE_NS)
  /** Array initializer of CCM32K peripheral base addresses */
  #define CCM32K_BASE_ADDRS                        { CCM32K_BASE }
  /** Array initializer of CCM32K peripheral base pointers */
  #define CCM32K_BASE_PTRS                         { CCM32K }
  /** Array initializer of CCM32K peripheral base addresses */
  #define CCM32K_BASE_ADDRS_NS                     { CCM32K_BASE_NS }
  /** Array initializer of CCM32K peripheral base pointers */
  #define CCM32K_BASE_PTRS_NS                      { CCM32K_NS }
#else
  /** Peripheral CCM32K base address */
  #define CCM32K_BASE                              (0x4001F000u)
  /** Peripheral CCM32K base pointer */
  #define CCM32K                                   ((CCM32K_Type *)CCM32K_BASE)
  /** Array initializer of CCM32K peripheral base addresses */
  #define CCM32K_BASE_ADDRS                        { CCM32K_BASE }
  /** Array initializer of CCM32K peripheral base pointers */
  #define CCM32K_BASE_PTRS                         { CCM32K }
#endif

/*!
 * @}
 */ /* end of group CCM32K_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- CIU2 Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CIU2_Peripheral_Access_Layer CIU2 Peripheral Access Layer
 * @{
 */

/** CIU2 - Register Layout Typedef */
typedef struct {
  __IO uint32_t CIU2_CLK_ENABLE;                   /**< Clock enable, offset: 0x0 */
  __IO uint32_t CIU2_ECO_0;                        /**< ECO Register 0, offset: 0x4 */
  __IO uint32_t CIU2_ECO_1;                        /**< ECO Register 1, offset: 0x8 */
  __IO uint32_t CIU2_ECO_2;                        /**< ECO Register 2, offset: 0xC */
  __IO uint32_t CIU2_ECO_3;                        /**< ECO Register 3, offset: 0x10 */
  __IO uint32_t CIU2_ECO_4;                        /**< ECO Register 4, offset: 0x14 */
  __IO uint32_t CIU2_ECO_5;                        /**< ECO Register 5, offset: 0x18 */
  __IO uint32_t CIU2_ECO_6;                        /**< ECO Register 6, offset: 0x1C */
  __IO uint32_t CIU2_ECO_7;                        /**< ECO Register 7, offset: 0x20 */
  __IO uint32_t CIU2_ECO_8;                        /**< ECO Register 8, offset: 0x24 */
  __IO uint32_t CIU2_ECO_9;                        /**< ECO Register 9, offset: 0x28 */
  __IO uint32_t CIU2_ECO_10;                       /**< ECO Register 10, offset: 0x2C */
  __IO uint32_t CIU2_ECO_11;                       /**< ECO Register 11, offset: 0x30 */
  __IO uint32_t CIU2_ECO_12;                       /**< ECO Register 12, offset: 0x34 */
  __IO uint32_t CIU2_ECO_13;                       /**< ECO Register 13, offset: 0x38 */
  __IO uint32_t CIU2_ECO_14;                       /**< ECO Register 14, offset: 0x3C */
  __IO uint32_t CIU2_ECO_15;                       /**< ECO Register 15, offset: 0x40 */
       uint8_t RESERVED_0[188];
  __IO uint32_t CIU2_CLK_ENABLE4;                  /**< Clock Enable 4, offset: 0x100 */
  __IO uint32_t CIU2_CLK_ENABLE5;                  /**< Clock Enable 5, offset: 0x104 */
  __IO uint32_t CIU2_CLK_CPU2CLK_CTRL;             /**< CPU2_AHB2 Clock Control, offset: 0x108 */
  __IO uint32_t CIU2_CLK_UARTCLK_CTRL;             /**< UART Clock Control, offset: 0x10C */
  __IO uint32_t CIU2_CLK_LBU2_BTRTU1_CTRL;         /**< LBU2 BT_RTU1 Clock Control, offset: 0x110 */
       uint8_t RESERVED_1[4];
  __IO uint32_t CIU2_CLK_CP15_DIS3;                /**< Clock Auto Shut-off Enable3, offset: 0x118 */
  __IO uint32_t CIU2_RST_SW3;                      /**< Software Module Reset, offset: 0x11C */
  __IO uint32_t CIU2_MEM_WRTC3;                    /**< Memory WRTC Control 3, offset: 0x120 */
  __IO uint32_t CIU2_MEM_WRTC4;                    /**< Memory WRTC Control 4, offset: 0x124 */
  __IO uint32_t CIU2_MEM_PWDN3;                    /**< Memory Powerdown Control, offset: 0x128 */
       uint8_t RESERVED_2[20];
  __IO uint32_t CIU2_BLE_CTRL;                     /**< BLE Control and Status, offset: 0x140 */
  __I  uint32_t CIU2_AHB2_TO_LAST_ADDR;            /**< AHB2 Timeout Last Address, offset: 0x144 */
  __I  uint32_t CIU2_AHB2_TO_CUR_ADDR;             /**< AHB2 Current Timeout Address, offset: 0x148 */
  __IO uint32_t CIU2_AHB2_TO_CTRL;                 /**< AHB2 ARB Control, offset: 0x14C */
  __IO uint32_t CIU2_AHB2_SMU1_ACCESS_ADDR;        /**< AHB2 to SMU1 Accessible Address, offset: 0x150 */
  __IO uint32_t CIU2_AHB2_SMU1_ACCESS_MASK;        /**< AHB2 to SMU1 Accessible Mask, offset: 0x154 */
  __IO uint32_t CIU2_CPU2_FABRIC_ARB_CTRL;         /**< CPU2 fabric arbiter control, offset: 0x158 */
  __IO uint32_t CIU2_CPU2_ICODE_INV_ADDR_CTRL;     /**< CPU2 Icode invalid address access control, offset: 0x15C */
  __I  uint32_t CIU2_CPU2_ICODE_INV_ADDR;          /**< CPU2 Icode invalid address, offset: 0x160 */
  __IO uint32_t CIU2_CPU2_DCODE_INV_ADDR_CTRL;     /**< CPU2 Dcode invalid address access control, offset: 0x164 */
  __I  uint32_t CIU2_CPU2_DCODE_INV_ADDR;          /**< CPU2 Dcode invalid address, offset: 0x168 */
  __IO uint32_t CIU2_CPU_CPU2_CTRL;                /**< CPU2 control register, offset: 0x16C */
  __IO uint32_t CIU2_BRF_CTRL;                     /**< BRF Control and Status, offset: 0x170 */
  __IO uint32_t CIU2_BRF_EXTRA_PORT;               /**< BRF Extra Port Connection, offset: 0x174 */
       uint8_t RESERVED_3[4];
  __IO uint32_t CIU2_BRF_ECO_CTRL;                 /**< BRF ECO Control, offset: 0x17C */
  __IO uint32_t CIU2_BTU_CTRL;                     /**< BTU Control and Status, offset: 0x180 */
  __IO uint32_t CIU2_BT_PS;                        /**< BT Clock Power Save, offset: 0x184 */
  __IO uint32_t CIU2_BT_PS2;                       /**< BT Clock Power Save 2, offset: 0x188 */
  __IO uint32_t CIU2_BT_REF_CTRL;                  /**< BT Ref Control, offset: 0x18C */
       uint8_t RESERVED_4[4];
  __IO uint32_t CIU2_BT_PS3;                       /**< BT Clock Power Save 3, offset: 0x194 */
  __IO uint32_t CIU2_BTU_ECO_CTRL;                 /**< BTU ECO Control, offset: 0x198 */
       uint8_t RESERVED_5[4];
  __IO uint32_t CIU2_INT_MASK;                     /**< CIU2 Interrupt Mask, offset: 0x1A0 */
  __IO uint32_t CIU2_INT_SELECT;                   /**< CIU2 Interrupt Select, offset: 0x1A4 */
  __IO uint32_t CIU2_INT_EVENT_MASK;               /**< CIU2 Interrupt Event Mask, offset: 0x1A8 */
  __I  uint32_t CIU2_INT_STATUS;                   /**< CIU2 Interrupt Status, offset: 0x1AC */
  __IO uint32_t CPU2_ERR_INT_MASK;                 /**< CPU2 ERR Interrupt Mask, offset: 0x1B0 */
  __IO uint32_t CPU2_ERR_INT_SELECT;               /**< CPU2 ERR Interrupt Clear Select, offset: 0x1B4 */
  __IO uint32_t CPU2_ERR_INT_EVENT_MASK;           /**< CPU2 ERR Interrupt Event Mask, offset: 0x1B8 */
  __I  uint32_t CPU2_ERR_INT_STATUS;               /**< CPU2 ERR Interrupt Status, offset: 0x1BC */
  __IO uint32_t CPU2_ERR_INT2_MASK;                /**< CPU2 ERR Interrupt 2 Mask, offset: 0x1C0 */
  __IO uint32_t CPU2_ERR_INT2_SELECT;              /**< CPU2 ERR Interrupt 2 Clear Select, offset: 0x1C4 */
  __IO uint32_t CPU2_ERR_INT2_EVENT_MASK;          /**< CPU2 ERR Interrupt 2 Event Mask, offset: 0x1C8 */
  __I  uint32_t CPU2_ERR_INT2_STATUS;              /**< CPU2 ERR Interrupt 2 Status, offset: 0x1CC */
  __IO uint32_t CIU2_CPU_CPU2_MSG_CTRL;            /**< CPU2 message register, offset: 0x1D0 */
  __IO uint32_t CIU2_IMU_CPU1_WR_MSG_TO_CPU2;      /**< CPU1 write message to CPU2, offset: 0x1D4 */
  __I  uint32_t CIU2_IMU_CPU1_RD_MSG_FROM_CPU2;    /**< CPU1 read message from CPU2, offset: 0x1D8 */
  __I  uint32_t CIU2_IMU_CPU1_CPU2_MSG_FIFO_STATUS; /**< CPU1 to CPU2 message FIFO status, offset: 0x1DC */
  __IO uint32_t CIU2_IMU_CPU1_CPU2_MSG_FIFO_CNTL;  /**< CPU1 to CPU2 message FIFO control, offset: 0x1E0 */
  __I  uint32_t CIU2_IMU_CPU2_RD_MSG_FROM_CPU1_VAL_DBG; /**< CPU2 last message read (from cpu1), offset: 0x1E4 */
  __IO uint32_t CIU2_IMU_CPU2_WR_MSG_TO_CPU1;      /**< CPU2 write message to CPU1, offset: 0x1E8 */
  __I  uint32_t CIU2_IMU_CPU2_RD_MSG_FROM_CPU1;    /**< CPU2 read message from CPU1, offset: 0x1EC */
  __I  uint32_t CIU2_IMU_CPU2_CPU1_MSG_FIFO_STATUS; /**< CPU2 to CPU1 message FIFO status, offset: 0x1F0 */
  __IO uint32_t CIU2_IMU_CPU2_CPU1_MSG_FIFO_CNTL;  /**< CPU2 to CPU1 message FIFO control, offset: 0x1F4 */
  __I  uint32_t CIU2_IMU_CPU1_RD_MSG_FROM_CPU2_VAL_DBG; /**< CPU1 last message read (from cpu2), offset: 0x1F8 */
       uint8_t RESERVED_6[4];
  __IO uint32_t CIU2_BCA1_CPU2_INT_MASK;           /**< BCA1 to CPU2 Interrupt Mask, offset: 0x200 */
  __IO uint32_t CIU2_BCA1_CPU2_INT_SELECT;         /**< BCA1 to CPU2 Interrupt Select, offset: 0x204 */
  __IO uint32_t CIU2_BCA1_CPU2_INT_EVENT_MASK;     /**< BCA1 to CPU2 Interrupt Event Mask, offset: 0x208 */
  __I  uint32_t CIU2_BCA1_CPU2_INT_STATUS;         /**< BCA1 to CPU2 Interrupt Status, offset: 0x20C */
  __IO uint32_t CIU2_APU_BYPASS1;                  /**< CIU2 APU Bypass Register 1, offset: 0x210 */
  __IO uint32_t CIU2_CPU2_LMU_STA_BYPASS0;         /**< LMU static bank control byapss0 Register for CPU2 mem, offset: 0x214 */
  __IO uint32_t CIU2_CPU2_LMU_STA_BYPASS1;         /**< LMU static bank control byapss1 Register for CPU2, offset: 0x218 */
  __IO uint32_t CIU2_CPU2_LMU_STA_BYPASS2;         /**< LMU static bank byapss2 Register for CPU2, offset: 0x21C */
  __IO uint32_t CIU2_CPU2_LMU_G2BIST_CTRL_BYPASS;  /**< LMU G2Bist control byapss Register for CPU2, offset: 0x220 */
       uint8_t RESERVED_7[8];
  __IO uint32_t CIU2_APU_PWR_CTRL_BYPASS1;         /**< APU power control Bypass Register 1, offset: 0x22C */
  __IO uint32_t CIU2_AHB2AHB_BRIDGE_CTRL;          /**< AHB2AHB Bridge Control Register, offset: 0x230 */
  __IO uint32_t CIU2_AHB1_AHB2_TO_CLEAR;           /**< AHB1 AHB2 timeout logic clear register, offset: 0x234 */
  __I  uint32_t CIU2_CPU_CPU2_DBG_STAT;            /**< CPU2 debug register, offset: 0x238 */
  __IO uint32_t CIU2_CPU_CPU1_CTRL;                /**< CPU1 control register, offset: 0x23C */
  __IO uint32_t CIU2_TESTBUS_CTRL;                 /**< CPU2 debug register, offset: 0x240 */
       uint8_t RESERVED_8[12];
  __IO uint32_t CIU2_LBC_CTRL;                     /**< LBC Control and Status, offset: 0x250 */
  __IO uint32_t CIU2_LBC_SLPCLK_NCO;               /**< LBC NCO Step for Sleep Clock, offset: 0x254 */
} CIU2_Type;

/* ----------------------------------------------------------------------------
   -- CIU2 Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CIU2_Register_Masks CIU2 Register Masks
 * @{
 */

/*! @name CIU2_CLK_ENABLE - Clock enable */
/*! @{ */

#define CIU2_CIU2_CLK_ENABLE_AHB2_CLK_ENABLE_MASK (0x20000000U)
#define CIU2_CIU2_CLK_ENABLE_AHB2_CLK_ENABLE_SHIFT (29U)
/*! ahb2_clk_enable - Clock ahb2_clk enable signal. Ahb2_clk enable. 1: enable, 0: disable
 */
#define CIU2_CIU2_CLK_ENABLE_AHB2_CLK_ENABLE(x)  (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CLK_ENABLE_AHB2_CLK_ENABLE_SHIFT)) & CIU2_CIU2_CLK_ENABLE_AHB2_CLK_ENABLE_MASK)

#define CIU2_CIU2_CLK_ENABLE_CPU1_DIV_CLK_ENABLE_MASK (0x40000000U)
#define CIU2_CIU2_CLK_ENABLE_CPU1_DIV_CLK_ENABLE_SHIFT (30U)
/*! cpu1_div_clk_enable - Clock cpu1_div_clk enable signal. cpu1_div_clk enable. 1: enable, 0: disable
 */
#define CIU2_CIU2_CLK_ENABLE_CPU1_DIV_CLK_ENABLE(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CLK_ENABLE_CPU1_DIV_CLK_ENABLE_SHIFT)) & CIU2_CIU2_CLK_ENABLE_CPU1_DIV_CLK_ENABLE_MASK)

#define CIU2_CIU2_CLK_ENABLE_SOC_AHB_CLK_SEL_MASK (0x80000000U)
#define CIU2_CIU2_CLK_ENABLE_SOC_AHB_CLK_SEL_SHIFT (31U)
/*! soc_ahb_clk_sel - Clock selection for soc_ahb_clk. 0: AHB2_CLK, 1: CPU1_CLK_DIV
 */
#define CIU2_CIU2_CLK_ENABLE_SOC_AHB_CLK_SEL(x)  (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CLK_ENABLE_SOC_AHB_CLK_SEL_SHIFT)) & CIU2_CIU2_CLK_ENABLE_SOC_AHB_CLK_SEL_MASK)
/*! @} */

/*! @name CIU2_ECO_0 - ECO Register 0 */
/*! @{ */

#define CIU2_CIU2_ECO_0_SPARE_MASK               (0xFFFFFFFFU)
#define CIU2_CIU2_ECO_0_SPARE_SHIFT              (0U)
/*! spare - Eco Reserve Register
 */
#define CIU2_CIU2_ECO_0_SPARE(x)                 (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_ECO_0_SPARE_SHIFT)) & CIU2_CIU2_ECO_0_SPARE_MASK)
/*! @} */

/*! @name CIU2_ECO_1 - ECO Register 1 */
/*! @{ */

#define CIU2_CIU2_ECO_1_SPARE_MASK               (0xFFFFFFFFU)
#define CIU2_CIU2_ECO_1_SPARE_SHIFT              (0U)
/*! spare - Eco Reserve Register
 */
#define CIU2_CIU2_ECO_1_SPARE(x)                 (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_ECO_1_SPARE_SHIFT)) & CIU2_CIU2_ECO_1_SPARE_MASK)
/*! @} */

/*! @name CIU2_ECO_2 - ECO Register 2 */
/*! @{ */

#define CIU2_CIU2_ECO_2_SPARE_MASK               (0xFFFFFFFFU)
#define CIU2_CIU2_ECO_2_SPARE_SHIFT              (0U)
/*! spare - Eco Reserve Register
 */
#define CIU2_CIU2_ECO_2_SPARE(x)                 (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_ECO_2_SPARE_SHIFT)) & CIU2_CIU2_ECO_2_SPARE_MASK)
/*! @} */

/*! @name CIU2_ECO_3 - ECO Register 3 */
/*! @{ */

#define CIU2_CIU2_ECO_3_SPARE_MASK               (0xFFFFFFFFU)
#define CIU2_CIU2_ECO_3_SPARE_SHIFT              (0U)
/*! spare - Eco Reserve Register
 */
#define CIU2_CIU2_ECO_3_SPARE(x)                 (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_ECO_3_SPARE_SHIFT)) & CIU2_CIU2_ECO_3_SPARE_MASK)
/*! @} */

/*! @name CIU2_ECO_4 - ECO Register 4 */
/*! @{ */

#define CIU2_CIU2_ECO_4_SPARE_MASK               (0xFFFFFFFFU)
#define CIU2_CIU2_ECO_4_SPARE_SHIFT              (0U)
/*! spare - Eco Reserve Register
 */
#define CIU2_CIU2_ECO_4_SPARE(x)                 (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_ECO_4_SPARE_SHIFT)) & CIU2_CIU2_ECO_4_SPARE_MASK)
/*! @} */

/*! @name CIU2_ECO_5 - ECO Register 5 */
/*! @{ */

#define CIU2_CIU2_ECO_5_SPARE_MASK               (0xFFFFFFFFU)
#define CIU2_CIU2_ECO_5_SPARE_SHIFT              (0U)
/*! spare - Eco Reserve Register
 */
#define CIU2_CIU2_ECO_5_SPARE(x)                 (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_ECO_5_SPARE_SHIFT)) & CIU2_CIU2_ECO_5_SPARE_MASK)
/*! @} */

/*! @name CIU2_ECO_6 - ECO Register 6 */
/*! @{ */

#define CIU2_CIU2_ECO_6_SPARE_MASK               (0xFFFFFFFFU)
#define CIU2_CIU2_ECO_6_SPARE_SHIFT              (0U)
/*! spare - Eco Reserve Register
 */
#define CIU2_CIU2_ECO_6_SPARE(x)                 (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_ECO_6_SPARE_SHIFT)) & CIU2_CIU2_ECO_6_SPARE_MASK)
/*! @} */

/*! @name CIU2_ECO_7 - ECO Register 7 */
/*! @{ */

#define CIU2_CIU2_ECO_7_SPARE_MASK               (0xFFFFFFFFU)
#define CIU2_CIU2_ECO_7_SPARE_SHIFT              (0U)
/*! spare - Eco Reserve Register
 */
#define CIU2_CIU2_ECO_7_SPARE(x)                 (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_ECO_7_SPARE_SHIFT)) & CIU2_CIU2_ECO_7_SPARE_MASK)
/*! @} */

/*! @name CIU2_ECO_8 - ECO Register 8 */
/*! @{ */

#define CIU2_CIU2_ECO_8_SPARE_MASK               (0xFFFFFFFFU)
#define CIU2_CIU2_ECO_8_SPARE_SHIFT              (0U)
/*! spare - Eco Reserve Register
 */
#define CIU2_CIU2_ECO_8_SPARE(x)                 (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_ECO_8_SPARE_SHIFT)) & CIU2_CIU2_ECO_8_SPARE_MASK)
/*! @} */

/*! @name CIU2_ECO_9 - ECO Register 9 */
/*! @{ */

#define CIU2_CIU2_ECO_9_SPARE_MASK               (0xFFFFFFFFU)
#define CIU2_CIU2_ECO_9_SPARE_SHIFT              (0U)
/*! spare - Eco Reserve Register
 */
#define CIU2_CIU2_ECO_9_SPARE(x)                 (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_ECO_9_SPARE_SHIFT)) & CIU2_CIU2_ECO_9_SPARE_MASK)
/*! @} */

/*! @name CIU2_ECO_10 - ECO Register 10 */
/*! @{ */

#define CIU2_CIU2_ECO_10_SPARE_MASK              (0xFFFFFFFFU)
#define CIU2_CIU2_ECO_10_SPARE_SHIFT             (0U)
/*! spare - Eco Reserve Register
 */
#define CIU2_CIU2_ECO_10_SPARE(x)                (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_ECO_10_SPARE_SHIFT)) & CIU2_CIU2_ECO_10_SPARE_MASK)
/*! @} */

/*! @name CIU2_ECO_11 - ECO Register 11 */
/*! @{ */

#define CIU2_CIU2_ECO_11_SPARE_MASK              (0xFFFFFFFFU)
#define CIU2_CIU2_ECO_11_SPARE_SHIFT             (0U)
/*! spare - Eco Reserve Register
 */
#define CIU2_CIU2_ECO_11_SPARE(x)                (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_ECO_11_SPARE_SHIFT)) & CIU2_CIU2_ECO_11_SPARE_MASK)
/*! @} */

/*! @name CIU2_ECO_12 - ECO Register 12 */
/*! @{ */

#define CIU2_CIU2_ECO_12_SPARE_MASK              (0xFFFFFFFFU)
#define CIU2_CIU2_ECO_12_SPARE_SHIFT             (0U)
/*! spare - Eco Reserve Register
 */
#define CIU2_CIU2_ECO_12_SPARE(x)                (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_ECO_12_SPARE_SHIFT)) & CIU2_CIU2_ECO_12_SPARE_MASK)
/*! @} */

/*! @name CIU2_ECO_13 - ECO Register 13 */
/*! @{ */

#define CIU2_CIU2_ECO_13_SPARE_MASK              (0xFFFFFFFFU)
#define CIU2_CIU2_ECO_13_SPARE_SHIFT             (0U)
/*! spare - Eco Reserve Register
 */
#define CIU2_CIU2_ECO_13_SPARE(x)                (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_ECO_13_SPARE_SHIFT)) & CIU2_CIU2_ECO_13_SPARE_MASK)
/*! @} */

/*! @name CIU2_ECO_14 - ECO Register 14 */
/*! @{ */

#define CIU2_CIU2_ECO_14_SPARE_MASK              (0xFFFFFFFFU)
#define CIU2_CIU2_ECO_14_SPARE_SHIFT             (0U)
/*! spare - Eco Reserve Register
 */
#define CIU2_CIU2_ECO_14_SPARE(x)                (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_ECO_14_SPARE_SHIFT)) & CIU2_CIU2_ECO_14_SPARE_MASK)
/*! @} */

/*! @name CIU2_ECO_15 - ECO Register 15 */
/*! @{ */

#define CIU2_CIU2_ECO_15_SPARE_MASK              (0xFFFFFFFFU)
#define CIU2_CIU2_ECO_15_SPARE_SHIFT             (0U)
/*! spare - Eco Reserve Register
 */
#define CIU2_CIU2_ECO_15_SPARE(x)                (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_ECO_15_SPARE_SHIFT)) & CIU2_CIU2_ECO_15_SPARE_MASK)
/*! @} */

/*! @name CIU2_CLK_ENABLE4 - Clock Enable 4 */
/*! @{ */

#define CIU2_CIU2_CLK_ENABLE4_BIST_AHB2_CLK_GATING_EN_MASK (0x1U)
#define CIU2_CIU2_CLK_ENABLE4_BIST_AHB2_CLK_GATING_EN_SHIFT (0U)
/*! bist_ahb2_clk_gating_en - CPU2 Redbist and Rombist Clock for ITCM/DTCM/SQU/BROM
 */
#define CIU2_CIU2_CLK_ENABLE4_BIST_AHB2_CLK_GATING_EN(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CLK_ENABLE4_BIST_AHB2_CLK_GATING_EN_SHIFT)) & CIU2_CIU2_CLK_ENABLE4_BIST_AHB2_CLK_GATING_EN_MASK)

#define CIU2_CIU2_CLK_ENABLE4_BRU_AHB2_ADDR_MASK_DIS_MASK (0x2U)
#define CIU2_CIU2_CLK_ENABLE4_BRU_AHB2_ADDR_MASK_DIS_SHIFT (1U)
/*! bru_ahb2_addr_mask_dis - CPU2 ROM Address Mask Selection
 */
#define CIU2_CIU2_CLK_ENABLE4_BRU_AHB2_ADDR_MASK_DIS(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CLK_ENABLE4_BRU_AHB2_ADDR_MASK_DIS_SHIFT)) & CIU2_CIU2_CLK_ENABLE4_BRU_AHB2_ADDR_MASK_DIS_MASK)

#define CIU2_CIU2_CLK_ENABLE4_ITCM_AHB2_DYN_CLK_GATING_DIS_MASK (0x4U)
#define CIU2_CIU2_CLK_ENABLE4_ITCM_AHB2_DYN_CLK_GATING_DIS_SHIFT (2U)
/*! itcm_ahb2_dyn_clk_gating_dis - CPU2 ITCM Dynamic Clock Gating Feature
 */
#define CIU2_CIU2_CLK_ENABLE4_ITCM_AHB2_DYN_CLK_GATING_DIS(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CLK_ENABLE4_ITCM_AHB2_DYN_CLK_GATING_DIS_SHIFT)) & CIU2_CIU2_CLK_ENABLE4_ITCM_AHB2_DYN_CLK_GATING_DIS_MASK)

#define CIU2_CIU2_CLK_ENABLE4_DTCM_AHB2_DYN_CLK_GATING_DIS_MASK (0x8U)
#define CIU2_CIU2_CLK_ENABLE4_DTCM_AHB2_DYN_CLK_GATING_DIS_SHIFT (3U)
/*! dtcm_ahb2_dyn_clk_gating_dis - CPU2 DTCM Dynamic Clock Gating Feature
 */
#define CIU2_CIU2_CLK_ENABLE4_DTCM_AHB2_DYN_CLK_GATING_DIS(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CLK_ENABLE4_DTCM_AHB2_DYN_CLK_GATING_DIS_SHIFT)) & CIU2_CIU2_CLK_ENABLE4_DTCM_AHB2_DYN_CLK_GATING_DIS_MASK)

#define CIU2_CIU2_CLK_ENABLE4_BRU_AHB2_DYN_CLK_GATING_DIS_MASK (0x10U)
#define CIU2_CIU2_CLK_ENABLE4_BRU_AHB2_DYN_CLK_GATING_DIS_SHIFT (4U)
/*! bru_ahb2_dyn_clk_gating_dis - CPU2 ROM Dynamic Clock Gating Feature
 */
#define CIU2_CIU2_CLK_ENABLE4_BRU_AHB2_DYN_CLK_GATING_DIS(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CLK_ENABLE4_BRU_AHB2_DYN_CLK_GATING_DIS_SHIFT)) & CIU2_CIU2_CLK_ENABLE4_BRU_AHB2_DYN_CLK_GATING_DIS_MASK)

#define CIU2_CIU2_CLK_ENABLE4_SMU2_DYN_CLK_GATING_DIS_MASK (0x20U)
#define CIU2_CIU2_CLK_ENABLE4_SMU2_DYN_CLK_GATING_DIS_SHIFT (5U)
/*! smu2_dyn_clk_gating_dis - SMU2 Dynamic Clock Gating Feature
 */
#define CIU2_CIU2_CLK_ENABLE4_SMU2_DYN_CLK_GATING_DIS(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CLK_ENABLE4_SMU2_DYN_CLK_GATING_DIS_SHIFT)) & CIU2_CIU2_CLK_ENABLE4_SMU2_DYN_CLK_GATING_DIS_MASK)

#define CIU2_CIU2_CLK_ENABLE4_EBRAM_BIST_CLK_EN_MASK (0x100U)
#define CIU2_CIU2_CLK_ENABLE4_EBRAM_BIST_CLK_EN_SHIFT (8U)
/*! ebram_bist_clk_en - EBRAM BIST Clock Enable
 */
#define CIU2_CIU2_CLK_ENABLE4_EBRAM_BIST_CLK_EN(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CLK_ENABLE4_EBRAM_BIST_CLK_EN_SHIFT)) & CIU2_CIU2_CLK_ENABLE4_EBRAM_BIST_CLK_EN_MASK)

#define CIU2_CIU2_CLK_ENABLE4_BT_ECLK_EN_MASK    (0x200U)
#define CIU2_CIU2_CLK_ENABLE4_BT_ECLK_EN_SHIFT   (9U)
/*! bt_eclk_en - BTU EBC Clock Enable
 */
#define CIU2_CIU2_CLK_ENABLE4_BT_ECLK_EN(x)      (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CLK_ENABLE4_BT_ECLK_EN_SHIFT)) & CIU2_CIU2_CLK_ENABLE4_BT_ECLK_EN_MASK)

#define CIU2_CIU2_CLK_ENABLE4_BT_4MCLK_EN_MASK   (0x400U)
#define CIU2_CIU2_CLK_ENABLE4_BT_4MCLK_EN_SHIFT  (10U)
/*! bt_4mclk_en - BTU 4 MHz Clock Enable
 */
#define CIU2_CIU2_CLK_ENABLE4_BT_4MCLK_EN(x)     (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CLK_ENABLE4_BT_4MCLK_EN_SHIFT)) & CIU2_CIU2_CLK_ENABLE4_BT_4MCLK_EN_MASK)

#define CIU2_CIU2_CLK_ENABLE4_BTU_AHB_CLK_EN_MASK (0x2000U)
#define CIU2_CIU2_CLK_ENABLE4_BTU_AHB_CLK_EN_SHIFT (13U)
/*! btu_ahb_clk_en - BTU AHB Clock Enable
 */
#define CIU2_CIU2_CLK_ENABLE4_BTU_AHB_CLK_EN(x)  (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CLK_ENABLE4_BTU_AHB_CLK_EN_SHIFT)) & CIU2_CIU2_CLK_ENABLE4_BTU_AHB_CLK_EN_MASK)

#define CIU2_CIU2_CLK_ENABLE4_SIU_CLK_EN_MASK    (0x4000U)
#define CIU2_CIU2_CLK_ENABLE4_SIU_CLK_EN_SHIFT   (14U)
/*! siu_clk_en - BT SIU (UART) clock enable
 */
#define CIU2_CIU2_CLK_ENABLE4_SIU_CLK_EN(x)      (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CLK_ENABLE4_SIU_CLK_EN_SHIFT)) & CIU2_CIU2_CLK_ENABLE4_SIU_CLK_EN_MASK)

#define CIU2_CIU2_CLK_ENABLE4_SMU2_AHB_CLK_EN_MASK (0x10000U)
#define CIU2_CIU2_CLK_ENABLE4_SMU2_AHB_CLK_EN_SHIFT (16U)
/*! smu2_ahb_clk_en - SMU2 AHB Clock Enable
 */
#define CIU2_CIU2_CLK_ENABLE4_SMU2_AHB_CLK_EN(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CLK_ENABLE4_SMU2_AHB_CLK_EN_SHIFT)) & CIU2_CIU2_CLK_ENABLE4_SMU2_AHB_CLK_EN_MASK)

#define CIU2_CIU2_CLK_ENABLE4_HPU2_CIU_CLK_EN_MASK (0x80000U)
#define CIU2_CIU2_CLK_ENABLE4_HPU2_CIU_CLK_EN_SHIFT (19U)
/*! hpu2_ciu_clk_en - HPU2 CIU Clock Enable
 */
#define CIU2_CIU2_CLK_ENABLE4_HPU2_CIU_CLK_EN(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CLK_ENABLE4_HPU2_CIU_CLK_EN_SHIFT)) & CIU2_CIU2_CLK_ENABLE4_HPU2_CIU_CLK_EN_MASK)

#define CIU2_CIU2_CLK_ENABLE4_BLE_AHB_CLK_EN_MASK (0x100000U)
#define CIU2_CIU2_CLK_ENABLE4_BLE_AHB_CLK_EN_SHIFT (20U)
/*! ble_ahb_clk_en - BLE ARM Clock Enable
 */
#define CIU2_CIU2_CLK_ENABLE4_BLE_AHB_CLK_EN(x)  (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CLK_ENABLE4_BLE_AHB_CLK_EN_SHIFT)) & CIU2_CIU2_CLK_ENABLE4_BLE_AHB_CLK_EN_MASK)

#define CIU2_CIU2_CLK_ENABLE4_BLE_SYS_CLK_EN_MASK (0x200000U)
#define CIU2_CIU2_CLK_ENABLE4_BLE_SYS_CLK_EN_SHIFT (21U)
/*! ble_sys_clk_en - BLE SYS Clock Enable
 */
#define CIU2_CIU2_CLK_ENABLE4_BLE_SYS_CLK_EN(x)  (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CLK_ENABLE4_BLE_SYS_CLK_EN_SHIFT)) & CIU2_CIU2_CLK_ENABLE4_BLE_SYS_CLK_EN_MASK)

#define CIU2_CIU2_CLK_ENABLE4_BLE_AEU_CLK_EN_MASK (0x400000U)
#define CIU2_CIU2_CLK_ENABLE4_BLE_AEU_CLK_EN_SHIFT (22U)
/*! ble_aeu_clk_en - BT/BLE AEU Clock Enable
 */
#define CIU2_CIU2_CLK_ENABLE4_BLE_AEU_CLK_EN(x)  (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CLK_ENABLE4_BLE_AEU_CLK_EN_SHIFT)) & CIU2_CIU2_CLK_ENABLE4_BLE_AEU_CLK_EN_MASK)

#define CIU2_CIU2_CLK_ENABLE4_BT_16M_CLK_EN_MASK (0x800000U)
#define CIU2_CIU2_CLK_ENABLE4_BT_16M_CLK_EN_SHIFT (23U)
/*! bt_16m_clk_en - BT 16MHz Clock Enable
 */
#define CIU2_CIU2_CLK_ENABLE4_BT_16M_CLK_EN(x)   (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CLK_ENABLE4_BT_16M_CLK_EN_SHIFT)) & CIU2_CIU2_CLK_ENABLE4_BT_16M_CLK_EN_MASK)

#define CIU2_CIU2_CLK_ENABLE4_DBUS_CLK_EN_MASK   (0x1000000U)
#define CIU2_CIU2_CLK_ENABLE4_DBUS_CLK_EN_SHIFT  (24U)
/*! dbus_clk_en - BLE DBUS Clock Enable
 */
#define CIU2_CIU2_CLK_ENABLE4_DBUS_CLK_EN(x)     (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CLK_ENABLE4_DBUS_CLK_EN_SHIFT)) & CIU2_CIU2_CLK_ENABLE4_DBUS_CLK_EN_MASK)

#define CIU2_CIU2_CLK_ENABLE4_SIU_AHB2_CLK_EN_MASK (0x20000000U)
#define CIU2_CIU2_CLK_ENABLE4_SIU_AHB2_CLK_EN_SHIFT (29U)
/*! siu_ahb2_clk_en - BT SIU (UART) AHB clock enable
 */
#define CIU2_CIU2_CLK_ENABLE4_SIU_AHB2_CLK_EN(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CLK_ENABLE4_SIU_AHB2_CLK_EN_SHIFT)) & CIU2_CIU2_CLK_ENABLE4_SIU_AHB2_CLK_EN_MASK)

#define CIU2_CIU2_CLK_ENABLE4_BTRTU1_CLK_EN_MASK (0x40000000U)
#define CIU2_CIU2_CLK_ENABLE4_BTRTU1_CLK_EN_SHIFT (30U)
/*! btrtu1_clk_en - BT RTU1 clock enable
 */
#define CIU2_CIU2_CLK_ENABLE4_BTRTU1_CLK_EN(x)   (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CLK_ENABLE4_BTRTU1_CLK_EN_SHIFT)) & CIU2_CIU2_CLK_ENABLE4_BTRTU1_CLK_EN_MASK)
/*! @} */

/*! @name CIU2_CLK_ENABLE5 - Clock Enable 5 */
/*! @{ */

#define CIU2_CIU2_CLK_ENABLE5_ITCM_AHB2_CLK_EN_MASK (0x7U)
#define CIU2_CIU2_CLK_ENABLE5_ITCM_AHB2_CLK_EN_SHIFT (0U)
/*! itcm_ahb2_clk_en - Enable CPU2 ITCM Banks 1-2
 */
#define CIU2_CIU2_CLK_ENABLE5_ITCM_AHB2_CLK_EN(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CLK_ENABLE5_ITCM_AHB2_CLK_EN_SHIFT)) & CIU2_CIU2_CLK_ENABLE5_ITCM_AHB2_CLK_EN_MASK)

#define CIU2_CIU2_CLK_ENABLE5_BT_ADMA_AHB_CLK_EN_MASK (0x8U)
#define CIU2_CIU2_CLK_ENABLE5_BT_ADMA_AHB_CLK_EN_SHIFT (3U)
/*! bt_adma_ahb_clk_en - BT ADMA AHB Clock Enable
 */
#define CIU2_CIU2_CLK_ENABLE5_BT_ADMA_AHB_CLK_EN(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CLK_ENABLE5_BT_ADMA_AHB_CLK_EN_SHIFT)) & CIU2_CIU2_CLK_ENABLE5_BT_ADMA_AHB_CLK_EN_MASK)

#define CIU2_CIU2_CLK_ENABLE5_CIU2_REG_CLK_EN_MASK (0x80U)
#define CIU2_CIU2_CLK_ENABLE5_CIU2_REG_CLK_EN_SHIFT (7U)
/*! ciu2_reg_clk_en - CIU2 Reg Clock Enable
 */
#define CIU2_CIU2_CLK_ENABLE5_CIU2_REG_CLK_EN(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CLK_ENABLE5_CIU2_REG_CLK_EN_SHIFT)) & CIU2_CIU2_CLK_ENABLE5_CIU2_REG_CLK_EN_MASK)

#define CIU2_CIU2_CLK_ENABLE5_BR_AHB2_CLK_EN_MASK (0x7FFF00U)
#define CIU2_CIU2_CLK_ENABLE5_BR_AHB2_CLK_EN_SHIFT (8U)
/*! br_ahb2_clk_en - CPU2 BROM AHB Clock Enable
 */
#define CIU2_CIU2_CLK_ENABLE5_BR_AHB2_CLK_EN(x)  (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CLK_ENABLE5_BR_AHB2_CLK_EN_SHIFT)) & CIU2_CIU2_CLK_ENABLE5_BR_AHB2_CLK_EN_MASK)

#define CIU2_CIU2_CLK_ENABLE5_BTU_MCLK_EN_MASK   (0x800000U)
#define CIU2_CIU2_CLK_ENABLE5_BTU_MCLK_EN_SHIFT  (23U)
/*! btu_mclk_en - BTU MCLK Enalbe
 */
#define CIU2_CIU2_CLK_ENABLE5_BTU_MCLK_EN(x)     (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CLK_ENABLE5_BTU_MCLK_EN_SHIFT)) & CIU2_CIU2_CLK_ENABLE5_BTU_MCLK_EN_MASK)

#define CIU2_CIU2_CLK_ENABLE5_SMU2_BANK_CLK_EN_MASK (0x7000000U)
#define CIU2_CIU2_CLK_ENABLE5_SMU2_BANK_CLK_EN_SHIFT (24U)
/*! smu2_bank_clk_en - SMU2 bank Clock Enable
 */
#define CIU2_CIU2_CLK_ENABLE5_SMU2_BANK_CLK_EN(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CLK_ENABLE5_SMU2_BANK_CLK_EN_SHIFT)) & CIU2_CIU2_CLK_ENABLE5_SMU2_BANK_CLK_EN_MASK)

#define CIU2_CIU2_CLK_ENABLE5_SIF_CLK_SEL_MASK   (0x8000000U)
#define CIU2_CIU2_CLK_ENABLE5_SIF_CLK_SEL_SHIFT  (27U)
/*! sif_clk_sel - SIF Clock Select
 */
#define CIU2_CIU2_CLK_ENABLE5_SIF_CLK_SEL(x)     (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CLK_ENABLE5_SIF_CLK_SEL_SHIFT)) & CIU2_CIU2_CLK_ENABLE5_SIF_CLK_SEL_MASK)

#define CIU2_CIU2_CLK_ENABLE5_CPU2_GATEHCLK_EN_MASK (0x10000000U)
#define CIU2_CIU2_CLK_ENABLE5_CPU2_GATEHCLK_EN_SHIFT (28U)
#define CIU2_CIU2_CLK_ENABLE5_CPU2_GATEHCLK_EN(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CLK_ENABLE5_CPU2_GATEHCLK_EN_SHIFT)) & CIU2_CIU2_CLK_ENABLE5_CPU2_GATEHCLK_EN_MASK)

#define CIU2_CIU2_CLK_ENABLE5_CPU2_FABRIC_CLK_EN_MASK (0x20000000U)
#define CIU2_CIU2_CLK_ENABLE5_CPU2_FABRIC_CLK_EN_SHIFT (29U)
#define CIU2_CIU2_CLK_ENABLE5_CPU2_FABRIC_CLK_EN(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CLK_ENABLE5_CPU2_FABRIC_CLK_EN_SHIFT)) & CIU2_CIU2_CLK_ENABLE5_CPU2_FABRIC_CLK_EN_MASK)

#define CIU2_CIU2_CLK_ENABLE5_CPU2_MEM_SLV_CLK_EN_MASK (0x40000000U)
#define CIU2_CIU2_CLK_ENABLE5_CPU2_MEM_SLV_CLK_EN_SHIFT (30U)
#define CIU2_CIU2_CLK_ENABLE5_CPU2_MEM_SLV_CLK_EN(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CLK_ENABLE5_CPU2_MEM_SLV_CLK_EN_SHIFT)) & CIU2_CIU2_CLK_ENABLE5_CPU2_MEM_SLV_CLK_EN_MASK)

#define CIU2_CIU2_CLK_ENABLE5_SIF_AHB2_CLK_EN_MASK (0x80000000U)
#define CIU2_CIU2_CLK_ENABLE5_SIF_AHB2_CLK_EN_SHIFT (31U)
/*! sif_ahb2_clk_en - SIF ahb2 Clock Enalbe
 */
#define CIU2_CIU2_CLK_ENABLE5_SIF_AHB2_CLK_EN(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CLK_ENABLE5_SIF_AHB2_CLK_EN_SHIFT)) & CIU2_CIU2_CLK_ENABLE5_SIF_AHB2_CLK_EN_MASK)
/*! @} */

/*! @name CIU2_CLK_CPU2CLK_CTRL - CPU2_AHB2 Clock Control */
/*! @{ */

#define CIU2_CIU2_CLK_CPU2CLK_CTRL_T1_FREQ_SEL_MASK (0xFU)
#define CIU2_CIU2_CLK_CPU2CLK_CTRL_T1_FREQ_SEL_SHIFT (0U)
/*! t1_freq_sel - AHB2 Clock Frequency Select
 */
#define CIU2_CIU2_CLK_CPU2CLK_CTRL_T1_FREQ_SEL(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CLK_CPU2CLK_CTRL_T1_FREQ_SEL_SHIFT)) & CIU2_CIU2_CLK_CPU2CLK_CTRL_T1_FREQ_SEL_MASK)
/*! @} */

/*! @name CIU2_CLK_UARTCLK_CTRL - UART Clock Control */
/*! @{ */

#define CIU2_CIU2_CLK_UARTCLK_CTRL_REFCLK_SEL_MASK (0x1U)
#define CIU2_CIU2_CLK_UARTCLK_CTRL_REFCLK_SEL_SHIFT (0U)
/*! refclk_sel - Reference Clock Select
 */
#define CIU2_CIU2_CLK_UARTCLK_CTRL_REFCLK_SEL(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CLK_UARTCLK_CTRL_REFCLK_SEL_SHIFT)) & CIU2_CIU2_CLK_UARTCLK_CTRL_REFCLK_SEL_MASK)

#define CIU2_CIU2_CLK_UARTCLK_CTRL_NCO_STEP_SIZE_MASK (0xFFFFFF80U)
#define CIU2_CIU2_CLK_UARTCLK_CTRL_NCO_STEP_SIZE_SHIFT (7U)
/*! nco_step_size - Programmable UART Clock Frequency
 */
#define CIU2_CIU2_CLK_UARTCLK_CTRL_NCO_STEP_SIZE(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CLK_UARTCLK_CTRL_NCO_STEP_SIZE_SHIFT)) & CIU2_CIU2_CLK_UARTCLK_CTRL_NCO_STEP_SIZE_MASK)
/*! @} */

/*! @name CIU2_CLK_LBU2_BTRTU1_CTRL - LBU2 BT_RTU1 Clock Control */
/*! @{ */

#define CIU2_CIU2_CLK_LBU2_BTRTU1_CTRL_LBU2_USE_REFCLK_MASK (0x2U)
#define CIU2_CIU2_CLK_LBU2_BTRTU1_CTRL_LBU2_USE_REFCLK_SHIFT (1U)
/*! lbu2_use_refclk - Static bit set by FW based on Reference Clock Frequency. If reference clock
 *    frequency is lower and LBU can not support high baud rate of UART, then FW will set
 *    soc_use_ref_mode = 0. This is an indication for Bluetooth subsystem that there is some IP which need PLL
 *    to function which is LBU in this case.
 */
#define CIU2_CIU2_CLK_LBU2_BTRTU1_CTRL_LBU2_USE_REFCLK(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CLK_LBU2_BTRTU1_CTRL_LBU2_USE_REFCLK_SHIFT)) & CIU2_CIU2_CLK_LBU2_BTRTU1_CTRL_LBU2_USE_REFCLK_MASK)

#define CIU2_CIU2_CLK_LBU2_BTRTU1_CTRL_BTRTU1_TIMER1_USE_SLP_CLK_MASK (0x800U)
#define CIU2_CIU2_CLK_LBU2_BTRTU1_CTRL_BTRTU1_TIMER1_USE_SLP_CLK_SHIFT (11U)
/*! btrtu1_timer1_use_slp_clk - Timer 1 BT_RTU1 Clock
 */
#define CIU2_CIU2_CLK_LBU2_BTRTU1_CTRL_BTRTU1_TIMER1_USE_SLP_CLK(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CLK_LBU2_BTRTU1_CTRL_BTRTU1_TIMER1_USE_SLP_CLK_SHIFT)) & CIU2_CIU2_CLK_LBU2_BTRTU1_CTRL_BTRTU1_TIMER1_USE_SLP_CLK_MASK)

#define CIU2_CIU2_CLK_LBU2_BTRTU1_CTRL_BTRTU1_USE_REF_CLK_MASK (0x1000U)
#define CIU2_CIU2_CLK_LBU2_BTRTU1_CTRL_BTRTU1_USE_REF_CLK_SHIFT (12U)
/*! btrtu1_use_ref_clk - Static bit set by FW. If it is required that timers need not be programmed
 *    with dynamic switching of T1/Reference, the BT_RTU1 source clock is set on reference clock so
 *    that the timer are not distrubed.
 */
#define CIU2_CIU2_CLK_LBU2_BTRTU1_CTRL_BTRTU1_USE_REF_CLK(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CLK_LBU2_BTRTU1_CTRL_BTRTU1_USE_REF_CLK_SHIFT)) & CIU2_CIU2_CLK_LBU2_BTRTU1_CTRL_BTRTU1_USE_REF_CLK_MASK)

#define CIU2_CIU2_CLK_LBU2_BTRTU1_CTRL_BTRTU1_DBG_CLK_CTRL_MASK (0x8000U)
#define CIU2_CIU2_CLK_LBU2_BTRTU1_CTRL_BTRTU1_DBG_CLK_CTRL_SHIFT (15U)
#define CIU2_CIU2_CLK_LBU2_BTRTU1_CTRL_BTRTU1_DBG_CLK_CTRL(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CLK_LBU2_BTRTU1_CTRL_BTRTU1_DBG_CLK_CTRL_SHIFT)) & CIU2_CIU2_CLK_LBU2_BTRTU1_CTRL_BTRTU1_DBG_CLK_CTRL_MASK)
/*! @} */

/*! @name CIU2_CLK_CP15_DIS3 - Clock Auto Shut-off Enable3 */
/*! @{ */

#define CIU2_CIU2_CLK_CP15_DIS3_BR_AHB2_CLK_MASK (0xFFFFU)
#define CIU2_CIU2_CLK_CP15_DIS3_BR_AHB2_CLK_SHIFT (0U)
/*! br_ahb2_clk - BRU_AHB2 Shut Off
 */
#define CIU2_CIU2_CLK_CP15_DIS3_BR_AHB2_CLK(x)   (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CLK_CP15_DIS3_BR_AHB2_CLK_SHIFT)) & CIU2_CIU2_CLK_CP15_DIS3_BR_AHB2_CLK_MASK)

#define CIU2_CIU2_CLK_CP15_DIS3_IMEM_AHB2_CLK_MASK (0x1E00000U)
#define CIU2_CIU2_CLK_CP15_DIS3_IMEM_AHB2_CLK_SHIFT (21U)
/*! imem_ahb2_clk - IMEM_AHB2 Shut Off
 */
#define CIU2_CIU2_CLK_CP15_DIS3_IMEM_AHB2_CLK(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CLK_CP15_DIS3_IMEM_AHB2_CLK_SHIFT)) & CIU2_CIU2_CLK_CP15_DIS3_IMEM_AHB2_CLK_MASK)

#define CIU2_CIU2_CLK_CP15_DIS3_DMEM_AHB2_CLK_MASK (0x6000000U)
#define CIU2_CIU2_CLK_CP15_DIS3_DMEM_AHB2_CLK_SHIFT (25U)
/*! dmem_ahb2_clk - DMEM_AHB2 Shut Off
 */
#define CIU2_CIU2_CLK_CP15_DIS3_DMEM_AHB2_CLK(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CLK_CP15_DIS3_DMEM_AHB2_CLK_SHIFT)) & CIU2_CIU2_CLK_CP15_DIS3_DMEM_AHB2_CLK_MASK)

#define CIU2_CIU2_CLK_CP15_DIS3_ARB_AHB2_CLK_MASK (0x10000000U)
#define CIU2_CIU2_CLK_CP15_DIS3_ARB_AHB2_CLK_SHIFT (28U)
/*! arb_ahb2_clk - AHB2 Arbiter Shut Off
 */
#define CIU2_CIU2_CLK_CP15_DIS3_ARB_AHB2_CLK(x)  (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CLK_CP15_DIS3_ARB_AHB2_CLK_SHIFT)) & CIU2_CIU2_CLK_CP15_DIS3_ARB_AHB2_CLK_MASK)

#define CIU2_CIU2_CLK_CP15_DIS3_DEC_AHB2_CLK_MASK (0x20000000U)
#define CIU2_CIU2_CLK_CP15_DIS3_DEC_AHB2_CLK_SHIFT (29U)
/*! dec_ahb2_clk - AHB2 Decoder Shut Off
 */
#define CIU2_CIU2_CLK_CP15_DIS3_DEC_AHB2_CLK(x)  (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CLK_CP15_DIS3_DEC_AHB2_CLK_SHIFT)) & CIU2_CIU2_CLK_CP15_DIS3_DEC_AHB2_CLK_MASK)

#define CIU2_CIU2_CLK_CP15_DIS3_BTU_AHB_CLK_MASK (0x40000000U)
#define CIU2_CIU2_CLK_CP15_DIS3_BTU_AHB_CLK_SHIFT (30U)
/*! btu_ahb_clk - BTU Shut Off
 */
#define CIU2_CIU2_CLK_CP15_DIS3_BTU_AHB_CLK(x)   (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CLK_CP15_DIS3_BTU_AHB_CLK_SHIFT)) & CIU2_CIU2_CLK_CP15_DIS3_BTU_AHB_CLK_MASK)

#define CIU2_CIU2_CLK_CP15_DIS3_BLE_AHB_CLK_MASK (0x80000000U)
#define CIU2_CIU2_CLK_CP15_DIS3_BLE_AHB_CLK_SHIFT (31U)
/*! ble_ahb_clk - BLE Shut Off
 */
#define CIU2_CIU2_CLK_CP15_DIS3_BLE_AHB_CLK(x)   (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CLK_CP15_DIS3_BLE_AHB_CLK_SHIFT)) & CIU2_CIU2_CLK_CP15_DIS3_BLE_AHB_CLK_MASK)
/*! @} */

/*! @name CIU2_RST_SW3 - Software Module Reset */
/*! @{ */

#define CIU2_CIU2_RST_SW3_BTU_AHB_CLK__MASK      (0x1U)
#define CIU2_CIU2_RST_SW3_BTU_AHB_CLK__SHIFT     (0U)
/*! btu_ahb_clk_ - BTU (ARM_Clk) Soft Reset
 */
#define CIU2_CIU2_RST_SW3_BTU_AHB_CLK_(x)        (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_RST_SW3_BTU_AHB_CLK__SHIFT)) & CIU2_CIU2_RST_SW3_BTU_AHB_CLK__MASK)

#define CIU2_CIU2_RST_SW3_BLE_SOC__MASK          (0x2U)
#define CIU2_CIU2_RST_SW3_BLE_SOC__SHIFT         (1U)
/*! ble_soc_ - BLE SoC Soft Reset
 */
#define CIU2_CIU2_RST_SW3_BLE_SOC_(x)            (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_RST_SW3_BLE_SOC__SHIFT)) & CIU2_CIU2_RST_SW3_BLE_SOC__MASK)

#define CIU2_CIU2_RST_SW3_BT_COMMON__MASK        (0x4U)
#define CIU2_CIU2_RST_SW3_BT_COMMON__SHIFT       (2U)
/*! bt_common_ - BT Common Soft Rest
 */
#define CIU2_CIU2_RST_SW3_BT_COMMON_(x)          (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_RST_SW3_BT_COMMON__SHIFT)) & CIU2_CIU2_RST_SW3_BT_COMMON__MASK)

#define CIU2_CIU2_RST_SW3_CPU2_CORE__MASK        (0x10U)
#define CIU2_CIU2_RST_SW3_CPU2_CORE__SHIFT       (4U)
/*! cpu2_core_ - CPU2 core reset
 */
#define CIU2_CIU2_RST_SW3_CPU2_CORE_(x)          (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_RST_SW3_CPU2_CORE__SHIFT)) & CIU2_CIU2_RST_SW3_CPU2_CORE__MASK)

#define CIU2_CIU2_RST_SW3_CPU2_TCM__MASK         (0x20U)
#define CIU2_CIU2_RST_SW3_CPU2_TCM__SHIFT        (5U)
/*! cpu2_tcm_ - CPU2 TCM/DMA/Arbiter reset
 */
#define CIU2_CIU2_RST_SW3_CPU2_TCM_(x)           (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_RST_SW3_CPU2_TCM__SHIFT)) & CIU2_CIU2_RST_SW3_CPU2_TCM__MASK)

#define CIU2_CIU2_RST_SW3_ARB_AHB2_CLK__MASK     (0x80U)
#define CIU2_CIU2_RST_SW3_ARB_AHB2_CLK__SHIFT    (7U)
/*! arb_ahb2_clk_ - AHB2 Arbiter Soft Reset
 */
#define CIU2_CIU2_RST_SW3_ARB_AHB2_CLK_(x)       (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_RST_SW3_ARB_AHB2_CLK__SHIFT)) & CIU2_CIU2_RST_SW3_ARB_AHB2_CLK__MASK)

#define CIU2_CIU2_RST_SW3_DEC_AHB2_CLK__MASK     (0x100U)
#define CIU2_CIU2_RST_SW3_DEC_AHB2_CLK__SHIFT    (8U)
/*! dec_ahb2_clk_ - AHB2 Decoder Mux Soft Reset
 */
#define CIU2_CIU2_RST_SW3_DEC_AHB2_CLK_(x)       (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_RST_SW3_DEC_AHB2_CLK__SHIFT)) & CIU2_CIU2_RST_SW3_DEC_AHB2_CLK__MASK)

#define CIU2_CIU2_RST_SW3_BRU_AHB2_CLK__MASK     (0x200U)
#define CIU2_CIU2_RST_SW3_BRU_AHB2_CLK__SHIFT    (9U)
/*! bru_ahb2_clk_ - BRU_AHB2 Soft Reset
 */
#define CIU2_CIU2_RST_SW3_BRU_AHB2_CLK_(x)       (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_RST_SW3_BRU_AHB2_CLK__SHIFT)) & CIU2_CIU2_RST_SW3_BRU_AHB2_CLK__MASK)

#define CIU2_CIU2_RST_SW3_BT_UART_N_MASK         (0x400U)
#define CIU2_CIU2_RST_SW3_BT_UART_N_SHIFT        (10U)
/*! bt_uart_n - BT UART soft reset
 */
#define CIU2_CIU2_RST_SW3_BT_UART_N(x)           (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_RST_SW3_BT_UART_N_SHIFT)) & CIU2_CIU2_RST_SW3_BT_UART_N_MASK)

#define CIU2_CIU2_RST_SW3_SIU_AHB2_CLK_N_MASK    (0x800U)
#define CIU2_CIU2_RST_SW3_SIU_AHB2_CLK_N_SHIFT   (11U)
/*! siu_ahb2_clk_n - BT SIU (UART) AHB soft reset
 */
#define CIU2_CIU2_RST_SW3_SIU_AHB2_CLK_N(x)      (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_RST_SW3_SIU_AHB2_CLK_N_SHIFT)) & CIU2_CIU2_RST_SW3_SIU_AHB2_CLK_N_MASK)

#define CIU2_CIU2_RST_SW3_SMU2_AHB_CLK__MASK     (0x10000U)
#define CIU2_CIU2_RST_SW3_SMU2_AHB_CLK__SHIFT    (16U)
/*! smu2_ahb_clk_ - SMU2 (AHB_Clk) Soft Reset
 */
#define CIU2_CIU2_RST_SW3_SMU2_AHB_CLK_(x)       (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_RST_SW3_SMU2_AHB_CLK__SHIFT)) & CIU2_CIU2_RST_SW3_SMU2_AHB_CLK__MASK)

#define CIU2_CIU2_RST_SW3_SIF__MASK              (0x40000U)
#define CIU2_CIU2_RST_SW3_SIF__SHIFT             (18U)
/*! sif_ - sif clock Soft Reset
 */
#define CIU2_CIU2_RST_SW3_SIF_(x)                (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_RST_SW3_SIF__SHIFT)) & CIU2_CIU2_RST_SW3_SIF__MASK)

#define CIU2_CIU2_RST_SW3_SIF_AHB2_CLK__MASK     (0x80000U)
#define CIU2_CIU2_RST_SW3_SIF_AHB2_CLK__SHIFT    (19U)
/*! sif_ahb2_clk_ - sif ahb2 Clock Soft Reset
 */
#define CIU2_CIU2_RST_SW3_SIF_AHB2_CLK_(x)       (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_RST_SW3_SIF_AHB2_CLK__SHIFT)) & CIU2_CIU2_RST_SW3_SIF_AHB2_CLK__MASK)

#define CIU2_CIU2_RST_SW3_HPU2__MASK             (0x100000U)
#define CIU2_CIU2_RST_SW3_HPU2__SHIFT            (20U)
/*! hpu2_ - HPU2 Reset
 */
#define CIU2_CIU2_RST_SW3_HPU2_(x)               (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_RST_SW3_HPU2__SHIFT)) & CIU2_CIU2_RST_SW3_HPU2__MASK)

#define CIU2_CIU2_RST_SW3_CIU2_AHB_CLK__MASK     (0x400000U)
#define CIU2_CIU2_RST_SW3_CIU2_AHB_CLK__SHIFT    (22U)
/*! ciu2_ahb_clk_ - CIU2 AHB Soft Reset
 */
#define CIU2_CIU2_RST_SW3_CIU2_AHB_CLK_(x)       (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_RST_SW3_CIU2_AHB_CLK__SHIFT)) & CIU2_CIU2_RST_SW3_CIU2_AHB_CLK__MASK)

#define CIU2_CIU2_RST_SW3_BRF_PR__MASK           (0x4000000U)
#define CIU2_CIU2_RST_SW3_BRF_PR__SHIFT          (26U)
/*! brf_pr_ - BRF_PR Reset
 */
#define CIU2_CIU2_RST_SW3_BRF_PR_(x)             (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_RST_SW3_BRF_PR__SHIFT)) & CIU2_CIU2_RST_SW3_BRF_PR__MASK)

#define CIU2_CIU2_RST_SW3_WD2_CHIP_RST_DISABLE_MASK (0x10000000U)
#define CIU2_CIU2_RST_SW3_WD2_CHIP_RST_DISABLE_SHIFT (28U)
#define CIU2_CIU2_RST_SW3_WD2_CHIP_RST_DISABLE(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_RST_SW3_WD2_CHIP_RST_DISABLE_SHIFT)) & CIU2_CIU2_RST_SW3_WD2_CHIP_RST_DISABLE_MASK)

#define CIU2_CIU2_RST_SW3_WD2_CPU2_RST_DISABLE_MASK (0x20000000U)
#define CIU2_CIU2_RST_SW3_WD2_CPU2_RST_DISABLE_SHIFT (29U)
#define CIU2_CIU2_RST_SW3_WD2_CPU2_RST_DISABLE(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_RST_SW3_WD2_CPU2_RST_DISABLE_SHIFT)) & CIU2_CIU2_RST_SW3_WD2_CPU2_RST_DISABLE_MASK)

#define CIU2_CIU2_RST_SW3_BT_16M_CLK__MASK       (0x40000000U)
#define CIU2_CIU2_RST_SW3_BT_16M_CLK__SHIFT      (30U)
/*! bt_16m_clk_ - Bt 16M clock reset
 */
#define CIU2_CIU2_RST_SW3_BT_16M_CLK_(x)         (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_RST_SW3_BT_16M_CLK__SHIFT)) & CIU2_CIU2_RST_SW3_BT_16M_CLK__MASK)

#define CIU2_CIU2_RST_SW3_BT_ADMA__MASK          (0x80000000U)
#define CIU2_CIU2_RST_SW3_BT_ADMA__SHIFT         (31U)
/*! bt_adma_ - BT ADMA Soft Reset
 */
#define CIU2_CIU2_RST_SW3_BT_ADMA_(x)            (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_RST_SW3_BT_ADMA__SHIFT)) & CIU2_CIU2_RST_SW3_BT_ADMA__MASK)
/*! @} */

/*! @name CIU2_MEM_WRTC3 - Memory WRTC Control 3 */
/*! @{ */

#define CIU2_CIU2_MEM_WRTC3_BLE_ROM_RTC_MASK     (0x700U)
#define CIU2_CIU2_MEM_WRTC3_BLE_ROM_RTC_SHIFT    (8U)
/*! ble_rom_rtc - BLE ROM RTC
 */
#define CIU2_CIU2_MEM_WRTC3_BLE_ROM_RTC(x)       (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_MEM_WRTC3_BLE_ROM_RTC_SHIFT)) & CIU2_CIU2_MEM_WRTC3_BLE_ROM_RTC_MASK)

#define CIU2_CIU2_MEM_WRTC3_BLE_ROM_RTC_REF_MASK (0x3000U)
#define CIU2_CIU2_MEM_WRTC3_BLE_ROM_RTC_REF_SHIFT (12U)
/*! ble_rom_rtc_ref - BLE ROM RTC_REF
 */
#define CIU2_CIU2_MEM_WRTC3_BLE_ROM_RTC_REF(x)   (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_MEM_WRTC3_BLE_ROM_RTC_REF_SHIFT)) & CIU2_CIU2_MEM_WRTC3_BLE_ROM_RTC_REF_MASK)
/*! @} */

/*! @name CIU2_MEM_WRTC4 - Memory WRTC Control 4 */
/*! @{ */

#define CIU2_CIU2_MEM_WRTC4_CPU2_ITCM_RTC_MASK   (0x3U)
#define CIU2_CIU2_MEM_WRTC4_CPU2_ITCM_RTC_SHIFT  (0U)
/*! cpu2_itcm_rtc - CPU2 ITCM RTC
 */
#define CIU2_CIU2_MEM_WRTC4_CPU2_ITCM_RTC(x)     (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_MEM_WRTC4_CPU2_ITCM_RTC_SHIFT)) & CIU2_CIU2_MEM_WRTC4_CPU2_ITCM_RTC_MASK)

#define CIU2_CIU2_MEM_WRTC4_CPU2_ITCM_WTC_MASK   (0xCU)
#define CIU2_CIU2_MEM_WRTC4_CPU2_ITCM_WTC_SHIFT  (2U)
/*! cpu2_itcm_wtc - CPU2 ITCM WTC
 */
#define CIU2_CIU2_MEM_WRTC4_CPU2_ITCM_WTC(x)     (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_MEM_WRTC4_CPU2_ITCM_WTC_SHIFT)) & CIU2_CIU2_MEM_WRTC4_CPU2_ITCM_WTC_MASK)

#define CIU2_CIU2_MEM_WRTC4_CPU2_DTCM_RTC_MASK   (0x30U)
#define CIU2_CIU2_MEM_WRTC4_CPU2_DTCM_RTC_SHIFT  (4U)
/*! cpu2_dtcm_rtc - CPU2 DTCM RTC
 */
#define CIU2_CIU2_MEM_WRTC4_CPU2_DTCM_RTC(x)     (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_MEM_WRTC4_CPU2_DTCM_RTC_SHIFT)) & CIU2_CIU2_MEM_WRTC4_CPU2_DTCM_RTC_MASK)

#define CIU2_CIU2_MEM_WRTC4_CPU2_DTCM_WTC_MASK   (0xC0U)
#define CIU2_CIU2_MEM_WRTC4_CPU2_DTCM_WTC_SHIFT  (6U)
/*! cpu2_dtcm_wtc - CPU2 DTCM WTC
 */
#define CIU2_CIU2_MEM_WRTC4_CPU2_DTCM_WTC(x)     (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_MEM_WRTC4_CPU2_DTCM_WTC_SHIFT)) & CIU2_CIU2_MEM_WRTC4_CPU2_DTCM_WTC_MASK)

#define CIU2_CIU2_MEM_WRTC4_SMU2_RTC_MASK        (0x300U)
#define CIU2_CIU2_MEM_WRTC4_SMU2_RTC_SHIFT       (8U)
/*! smu2_rtc - SMU2 RTC
 */
#define CIU2_CIU2_MEM_WRTC4_SMU2_RTC(x)          (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_MEM_WRTC4_SMU2_RTC_SHIFT)) & CIU2_CIU2_MEM_WRTC4_SMU2_RTC_MASK)

#define CIU2_CIU2_MEM_WRTC4_SMU2_WTC_MASK        (0xC00U)
#define CIU2_CIU2_MEM_WRTC4_SMU2_WTC_SHIFT       (10U)
/*! smu2_wtc - SMU2 WTC
 */
#define CIU2_CIU2_MEM_WRTC4_SMU2_WTC(x)          (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_MEM_WRTC4_SMU2_WTC_SHIFT)) & CIU2_CIU2_MEM_WRTC4_SMU2_WTC_MASK)

#define CIU2_CIU2_MEM_WRTC4_CPU2_BRU_RTC_MASK    (0x7000U)
#define CIU2_CIU2_MEM_WRTC4_CPU2_BRU_RTC_SHIFT   (12U)
/*! cpu2_bru_rtc - CPU2 BROM RTC
 */
#define CIU2_CIU2_MEM_WRTC4_CPU2_BRU_RTC(x)      (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_MEM_WRTC4_CPU2_BRU_RTC_SHIFT)) & CIU2_CIU2_MEM_WRTC4_CPU2_BRU_RTC_MASK)

#define CIU2_CIU2_MEM_WRTC4_CPU2_BRU_RTC_REF_MASK (0x30000U)
#define CIU2_CIU2_MEM_WRTC4_CPU2_BRU_RTC_REF_SHIFT (16U)
/*! cpu2_bru_rtc_ref - CPU2 BROM RTC_REF
 */
#define CIU2_CIU2_MEM_WRTC4_CPU2_BRU_RTC_REF(x)  (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_MEM_WRTC4_CPU2_BRU_RTC_REF_SHIFT)) & CIU2_CIU2_MEM_WRTC4_CPU2_BRU_RTC_REF_MASK)

#define CIU2_CIU2_MEM_WRTC4_BTU_RTC_MASK         (0xC0000U)
#define CIU2_CIU2_MEM_WRTC4_BTU_RTC_SHIFT        (18U)
/*! btu_rtc - BTU EBRAM RTC
 */
#define CIU2_CIU2_MEM_WRTC4_BTU_RTC(x)           (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_MEM_WRTC4_BTU_RTC_SHIFT)) & CIU2_CIU2_MEM_WRTC4_BTU_RTC_MASK)

#define CIU2_CIU2_MEM_WRTC4_BTU_WTC_MASK         (0x300000U)
#define CIU2_CIU2_MEM_WRTC4_BTU_WTC_SHIFT        (20U)
/*! btu_wtc - BTU EBRAM WTC
 */
#define CIU2_CIU2_MEM_WRTC4_BTU_WTC(x)           (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_MEM_WRTC4_BTU_WTC_SHIFT)) & CIU2_CIU2_MEM_WRTC4_BTU_WTC_MASK)

#define CIU2_CIU2_MEM_WRTC4_BLE_RTC_MASK         (0xC000000U)
#define CIU2_CIU2_MEM_WRTC4_BLE_RTC_SHIFT        (26U)
/*! ble_rtc - ble RTC
 */
#define CIU2_CIU2_MEM_WRTC4_BLE_RTC(x)           (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_MEM_WRTC4_BLE_RTC_SHIFT)) & CIU2_CIU2_MEM_WRTC4_BLE_RTC_MASK)

#define CIU2_CIU2_MEM_WRTC4_BLE_WTC_MASK         (0x30000000U)
#define CIU2_CIU2_MEM_WRTC4_BLE_WTC_SHIFT        (28U)
/*! ble_wtc - ble WTC
 */
#define CIU2_CIU2_MEM_WRTC4_BLE_WTC(x)           (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_MEM_WRTC4_BLE_WTC_SHIFT)) & CIU2_CIU2_MEM_WRTC4_BLE_WTC_MASK)
/*! @} */

/*! @name CIU2_MEM_PWDN3 - Memory Powerdown Control */
/*! @{ */

#define CIU2_CIU2_MEM_PWDN3_CPU2_BRU_BYPASS_VAL_MASK (0x1U)
#define CIU2_CIU2_MEM_PWDN3_CPU2_BRU_BYPASS_VAL_SHIFT (0U)
/*! cpu2_bru_bypass_val - Firmware Bypass value for CPU2 Boot ROM Memories Power Down
 */
#define CIU2_CIU2_MEM_PWDN3_CPU2_BRU_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_MEM_PWDN3_CPU2_BRU_BYPASS_VAL_SHIFT)) & CIU2_CIU2_MEM_PWDN3_CPU2_BRU_BYPASS_VAL_MASK)

#define CIU2_CIU2_MEM_PWDN3_CPU2_DTCM_BYPASS_VAL_MASK (0x2U)
#define CIU2_CIU2_MEM_PWDN3_CPU2_DTCM_BYPASS_VAL_SHIFT (1U)
/*! cpu2_dtcm_bypass_val - Firmware Bypass value for CPU2 DTCM Memories Power Down
 */
#define CIU2_CIU2_MEM_PWDN3_CPU2_DTCM_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_MEM_PWDN3_CPU2_DTCM_BYPASS_VAL_SHIFT)) & CIU2_CIU2_MEM_PWDN3_CPU2_DTCM_BYPASS_VAL_MASK)

#define CIU2_CIU2_MEM_PWDN3_CPU2_ITCM_BYPASS_VAL_MASK (0x4U)
#define CIU2_CIU2_MEM_PWDN3_CPU2_ITCM_BYPASS_VAL_SHIFT (2U)
/*! cpu2_itcm_bypass_val - Firmware Bypass value for CPU2 ITCM Memories Power Down
 */
#define CIU2_CIU2_MEM_PWDN3_CPU2_ITCM_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_MEM_PWDN3_CPU2_ITCM_BYPASS_VAL_SHIFT)) & CIU2_CIU2_MEM_PWDN3_CPU2_ITCM_BYPASS_VAL_MASK)

#define CIU2_CIU2_MEM_PWDN3_SMU2_BYPASS_VAL_MASK (0x10U)
#define CIU2_CIU2_MEM_PWDN3_SMU2_BYPASS_VAL_SHIFT (4U)
/*! smu2_bypass_val - Firmware Bypass value for SMU2 Memories Power Down
 */
#define CIU2_CIU2_MEM_PWDN3_SMU2_BYPASS_VAL(x)   (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_MEM_PWDN3_SMU2_BYPASS_VAL_SHIFT)) & CIU2_CIU2_MEM_PWDN3_SMU2_BYPASS_VAL_MASK)

#define CIU2_CIU2_MEM_PWDN3_SIU_BYPASS_VAL_MASK  (0x20U)
#define CIU2_CIU2_MEM_PWDN3_SIU_BYPASS_VAL_SHIFT (5U)
/*! siu_bypass_val - Firmware Bypass value for UART Memories Power Down
 */
#define CIU2_CIU2_MEM_PWDN3_SIU_BYPASS_VAL(x)    (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_MEM_PWDN3_SIU_BYPASS_VAL_SHIFT)) & CIU2_CIU2_MEM_PWDN3_SIU_BYPASS_VAL_MASK)

#define CIU2_CIU2_MEM_PWDN3_BTU_BYPASS_VAL_MASK  (0x40U)
#define CIU2_CIU2_MEM_PWDN3_BTU_BYPASS_VAL_SHIFT (6U)
/*! btu_bypass_val - Firmware Bypass value for BTU Memories Power Down
 */
#define CIU2_CIU2_MEM_PWDN3_BTU_BYPASS_VAL(x)    (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_MEM_PWDN3_BTU_BYPASS_VAL_SHIFT)) & CIU2_CIU2_MEM_PWDN3_BTU_BYPASS_VAL_MASK)

#define CIU2_CIU2_MEM_PWDN3_BT_ADMA_BYPASS_VAL_MASK (0x200U)
#define CIU2_CIU2_MEM_PWDN3_BT_ADMA_BYPASS_VAL_SHIFT (9U)
/*! bt_adma_bypass_val - Firmware Bypass value for BT ADMA Memories Power Down
 */
#define CIU2_CIU2_MEM_PWDN3_BT_ADMA_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_MEM_PWDN3_BT_ADMA_BYPASS_VAL_SHIFT)) & CIU2_CIU2_MEM_PWDN3_BT_ADMA_BYPASS_VAL_MASK)

#define CIU2_CIU2_MEM_PWDN3_CPU2_BRU_BYPASS_EN_MASK (0x10000U)
#define CIU2_CIU2_MEM_PWDN3_CPU2_BRU_BYPASS_EN_SHIFT (16U)
/*! cpu2_bru_bypass_en - Firmware Bypass Enable for CPU2 Boot ROM Memories Power Down
 */
#define CIU2_CIU2_MEM_PWDN3_CPU2_BRU_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_MEM_PWDN3_CPU2_BRU_BYPASS_EN_SHIFT)) & CIU2_CIU2_MEM_PWDN3_CPU2_BRU_BYPASS_EN_MASK)

#define CIU2_CIU2_MEM_PWDN3_CPU2_DTCM_BYPASS_EN_MASK (0x20000U)
#define CIU2_CIU2_MEM_PWDN3_CPU2_DTCM_BYPASS_EN_SHIFT (17U)
/*! cpu2_dtcm_bypass_en - Firmware Bypass Enable for CPU2 DTCM Memories Power Down
 */
#define CIU2_CIU2_MEM_PWDN3_CPU2_DTCM_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_MEM_PWDN3_CPU2_DTCM_BYPASS_EN_SHIFT)) & CIU2_CIU2_MEM_PWDN3_CPU2_DTCM_BYPASS_EN_MASK)

#define CIU2_CIU2_MEM_PWDN3_CPU2_ITCM_BYPASS_EN_MASK (0x40000U)
#define CIU2_CIU2_MEM_PWDN3_CPU2_ITCM_BYPASS_EN_SHIFT (18U)
/*! cpu2_itcm_bypass_en - Firmware Bypass Enable for CPU2 ITCM Memories Power Down
 */
#define CIU2_CIU2_MEM_PWDN3_CPU2_ITCM_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_MEM_PWDN3_CPU2_ITCM_BYPASS_EN_SHIFT)) & CIU2_CIU2_MEM_PWDN3_CPU2_ITCM_BYPASS_EN_MASK)

#define CIU2_CIU2_MEM_PWDN3_SMU2_BYPASS_EN_MASK  (0x100000U)
#define CIU2_CIU2_MEM_PWDN3_SMU2_BYPASS_EN_SHIFT (20U)
/*! smu2_bypass_en - Firmware Bypass Enable for SMU2 Memories Power Down
 */
#define CIU2_CIU2_MEM_PWDN3_SMU2_BYPASS_EN(x)    (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_MEM_PWDN3_SMU2_BYPASS_EN_SHIFT)) & CIU2_CIU2_MEM_PWDN3_SMU2_BYPASS_EN_MASK)

#define CIU2_CIU2_MEM_PWDN3_SIU_BYPASS_EN_MASK   (0x200000U)
#define CIU2_CIU2_MEM_PWDN3_SIU_BYPASS_EN_SHIFT  (21U)
/*! siu_bypass_en - Firmware Bypass Enable for UART Memories Power Down
 */
#define CIU2_CIU2_MEM_PWDN3_SIU_BYPASS_EN(x)     (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_MEM_PWDN3_SIU_BYPASS_EN_SHIFT)) & CIU2_CIU2_MEM_PWDN3_SIU_BYPASS_EN_MASK)

#define CIU2_CIU2_MEM_PWDN3_BTU_BYPASS_EN_MASK   (0x400000U)
#define CIU2_CIU2_MEM_PWDN3_BTU_BYPASS_EN_SHIFT  (22U)
/*! btu_bypass_en - Firmware Bypass Enable for BTU Memories Power Down
 */
#define CIU2_CIU2_MEM_PWDN3_BTU_BYPASS_EN(x)     (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_MEM_PWDN3_BTU_BYPASS_EN_SHIFT)) & CIU2_CIU2_MEM_PWDN3_BTU_BYPASS_EN_MASK)

#define CIU2_CIU2_MEM_PWDN3_BT_ADMA_BYPASS_EN_MASK (0x2000000U)
#define CIU2_CIU2_MEM_PWDN3_BT_ADMA_BYPASS_EN_SHIFT (25U)
/*! bt_adma_bypass_en - Firmware Bypass Enable for BT ADMA Memories Power Down
 */
#define CIU2_CIU2_MEM_PWDN3_BT_ADMA_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_MEM_PWDN3_BT_ADMA_BYPASS_EN_SHIFT)) & CIU2_CIU2_MEM_PWDN3_BT_ADMA_BYPASS_EN_MASK)
/*! @} */

/*! @name CIU2_BLE_CTRL - BLE Control and Status */
/*! @{ */

#define CIU2_CIU2_BLE_CTRL_BT_AES_CLK_FREQ_SEL_MASK (0x100U)
#define CIU2_CIU2_BLE_CTRL_BT_AES_CLK_FREQ_SEL_SHIFT (8U)
/*! bt_aes_clk_freq_sel - btu_aes_clk Frequency Select
 */
#define CIU2_CIU2_BLE_CTRL_BT_AES_CLK_FREQ_SEL(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_BLE_CTRL_BT_AES_CLK_FREQ_SEL_SHIFT)) & CIU2_CIU2_BLE_CTRL_BT_AES_CLK_FREQ_SEL_MASK)
/*! @} */

/*! @name CIU2_AHB2_TO_LAST_ADDR - AHB2 Timeout Last Address */
/*! @{ */

#define CIU2_CIU2_AHB2_TO_LAST_ADDR_ADDRESS_MASK (0xFFFFFFFFU)
#define CIU2_CIU2_AHB2_TO_LAST_ADDR_ADDRESS_SHIFT (0U)
/*! address - Last AHB2 Address Right Before the Current Timeout
 */
#define CIU2_CIU2_AHB2_TO_LAST_ADDR_ADDRESS(x)   (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_AHB2_TO_LAST_ADDR_ADDRESS_SHIFT)) & CIU2_CIU2_AHB2_TO_LAST_ADDR_ADDRESS_MASK)
/*! @} */

/*! @name CIU2_AHB2_TO_CUR_ADDR - AHB2 Current Timeout Address */
/*! @{ */

#define CIU2_CIU2_AHB2_TO_CUR_ADDR_ADDRESS_MASK  (0xFFFFFFFFU)
#define CIU2_CIU2_AHB2_TO_CUR_ADDR_ADDRESS_SHIFT (0U)
/*! address - Current_TO_Addr
 */
#define CIU2_CIU2_AHB2_TO_CUR_ADDR_ADDRESS(x)    (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_AHB2_TO_CUR_ADDR_ADDRESS_SHIFT)) & CIU2_CIU2_AHB2_TO_CUR_ADDR_ADDRESS_MASK)
/*! @} */

/*! @name CIU2_AHB2_TO_CTRL - AHB2 ARB Control */
/*! @{ */

#define CIU2_CIU2_AHB2_TO_CTRL_CURRENT_TO_SLAVE_ID_MASK (0xFU)
#define CIU2_CIU2_AHB2_TO_CTRL_CURRENT_TO_SLAVE_ID_SHIFT (0U)
/*! current_to_slave_id - Current_TO_Slave_ID
 */
#define CIU2_CIU2_AHB2_TO_CTRL_CURRENT_TO_SLAVE_ID(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_AHB2_TO_CTRL_CURRENT_TO_SLAVE_ID_SHIFT)) & CIU2_CIU2_AHB2_TO_CTRL_CURRENT_TO_SLAVE_ID_MASK)

#define CIU2_CIU2_AHB2_TO_CTRL_LAST_TO_SLAVE_ID_MASK (0xF0U)
#define CIU2_CIU2_AHB2_TO_CTRL_LAST_TO_SLAVE_ID_SHIFT (4U)
/*! last_to_slave_id - Last_TO_Slave_ID
 */
#define CIU2_CIU2_AHB2_TO_CTRL_LAST_TO_SLAVE_ID(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_AHB2_TO_CTRL_LAST_TO_SLAVE_ID_SHIFT)) & CIU2_CIU2_AHB2_TO_CTRL_LAST_TO_SLAVE_ID_MASK)

#define CIU2_CIU2_AHB2_TO_CTRL_CURRENT_TO_MASTER_ID_MASK (0xF00U)
#define CIU2_CIU2_AHB2_TO_CTRL_CURRENT_TO_MASTER_ID_SHIFT (8U)
/*! current_to_master_id - AHB2 Current_TO_Master_ID
 */
#define CIU2_CIU2_AHB2_TO_CTRL_CURRENT_TO_MASTER_ID(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_AHB2_TO_CTRL_CURRENT_TO_MASTER_ID_SHIFT)) & CIU2_CIU2_AHB2_TO_CTRL_CURRENT_TO_MASTER_ID_MASK)

#define CIU2_CIU2_AHB2_TO_CTRL_LAST_TO_MASTER_ID_MASK (0xF000U)
#define CIU2_CIU2_AHB2_TO_CTRL_LAST_TO_MASTER_ID_SHIFT (12U)
/*! last_to_master_id - AHB2 Last_TO_Master_ID
 */
#define CIU2_CIU2_AHB2_TO_CTRL_LAST_TO_MASTER_ID(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_AHB2_TO_CTRL_LAST_TO_MASTER_ID_SHIFT)) & CIU2_CIU2_AHB2_TO_CTRL_LAST_TO_MASTER_ID_MASK)

#define CIU2_CIU2_AHB2_TO_CTRL_AHB2_SMU1_MEM_PROT_DIS_MASK (0x10000U)
#define CIU2_CIU2_AHB2_TO_CTRL_AHB2_SMU1_MEM_PROT_DIS_SHIFT (16U)
/*! ahb2_smu1_mem_prot_dis - Disable SMU1 Memory Protection from AHB2 side
 */
#define CIU2_CIU2_AHB2_TO_CTRL_AHB2_SMU1_MEM_PROT_DIS(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_AHB2_TO_CTRL_AHB2_SMU1_MEM_PROT_DIS_SHIFT)) & CIU2_CIU2_AHB2_TO_CTRL_AHB2_SMU1_MEM_PROT_DIS_MASK)

#define CIU2_CIU2_AHB2_TO_CTRL_AHB2_CPU2_IMEM_PROT_DIS_MASK (0x20000U)
#define CIU2_CIU2_AHB2_TO_CTRL_AHB2_CPU2_IMEM_PROT_DIS_SHIFT (17U)
/*! ahb2_cpu2_imem_prot_dis - 1 = Disable CPU2 Imem Memory Protection from AHB2 side and allow AHB2 to read/write Imem
 */
#define CIU2_CIU2_AHB2_TO_CTRL_AHB2_CPU2_IMEM_PROT_DIS(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_AHB2_TO_CTRL_AHB2_CPU2_IMEM_PROT_DIS_SHIFT)) & CIU2_CIU2_AHB2_TO_CTRL_AHB2_CPU2_IMEM_PROT_DIS_MASK)

#define CIU2_CIU2_AHB2_TO_CTRL_AHB2_CPU2_DMEM_PROT_DIS_MASK (0x40000U)
#define CIU2_CIU2_AHB2_TO_CTRL_AHB2_CPU2_DMEM_PROT_DIS_SHIFT (18U)
/*! ahb2_cpu2_dmem_prot_dis - 1 = Disable CPU2 Dmem Memory Protection from AHB2 side and allow AHB2 to read/write Dmem
 */
#define CIU2_CIU2_AHB2_TO_CTRL_AHB2_CPU2_DMEM_PROT_DIS(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_AHB2_TO_CTRL_AHB2_CPU2_DMEM_PROT_DIS_SHIFT)) & CIU2_CIU2_AHB2_TO_CTRL_AHB2_CPU2_DMEM_PROT_DIS_MASK)

#define CIU2_CIU2_AHB2_TO_CTRL_AHB2_TIMEOUT_MODE_MASK (0xC0000000U)
#define CIU2_CIU2_AHB2_TO_CTRL_AHB2_TIMEOUT_MODE_SHIFT (30U)
/*! ahb2_timeout_mode - AHB2_TimeoutMode[1:0]
 */
#define CIU2_CIU2_AHB2_TO_CTRL_AHB2_TIMEOUT_MODE(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_AHB2_TO_CTRL_AHB2_TIMEOUT_MODE_SHIFT)) & CIU2_CIU2_AHB2_TO_CTRL_AHB2_TIMEOUT_MODE_MASK)
/*! @} */

/*! @name CIU2_AHB2_SMU1_ACCESS_ADDR - AHB2 to SMU1 Accessible Address */
/*! @{ */

#define CIU2_CIU2_AHB2_SMU1_ACCESS_ADDR_AHB2_SMU1_ACCESS_ADDR_MASK (0xFFFFFFFFU)
#define CIU2_CIU2_AHB2_SMU1_ACCESS_ADDR_AHB2_SMU1_ACCESS_ADDR_SHIFT (0U)
/*! ahb2_smu1_access_addr - SMU1 Accessible Memory Address from AHB2 side
 */
#define CIU2_CIU2_AHB2_SMU1_ACCESS_ADDR_AHB2_SMU1_ACCESS_ADDR(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_AHB2_SMU1_ACCESS_ADDR_AHB2_SMU1_ACCESS_ADDR_SHIFT)) & CIU2_CIU2_AHB2_SMU1_ACCESS_ADDR_AHB2_SMU1_ACCESS_ADDR_MASK)
/*! @} */

/*! @name CIU2_AHB2_SMU1_ACCESS_MASK - AHB2 to SMU1 Accessible Mask */
/*! @{ */

#define CIU2_CIU2_AHB2_SMU1_ACCESS_MASK_AHB2_SMU1_ACCESS_MASK_MASK (0xFFFFFFFFU)
#define CIU2_CIU2_AHB2_SMU1_ACCESS_MASK_AHB2_SMU1_ACCESS_MASK_SHIFT (0U)
/*! ahb2_smu1_access_mask - SMU1 Accessible Memory Mask from AHB2 side
 */
#define CIU2_CIU2_AHB2_SMU1_ACCESS_MASK_AHB2_SMU1_ACCESS_MASK(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_AHB2_SMU1_ACCESS_MASK_AHB2_SMU1_ACCESS_MASK_SHIFT)) & CIU2_CIU2_AHB2_SMU1_ACCESS_MASK_AHB2_SMU1_ACCESS_MASK_MASK)
/*! @} */

/*! @name CIU2_CPU2_FABRIC_ARB_CTRL - CPU2 fabric arbiter control */
/*! @{ */

#define CIU2_CIU2_CPU2_FABRIC_ARB_CTRL_DMEM_BRST_TERM_CNT_MASK (0x3U)
#define CIU2_CIU2_CPU2_FABRIC_ARB_CTRL_DMEM_BRST_TERM_CNT_SHIFT (0U)
#define CIU2_CIU2_CPU2_FABRIC_ARB_CTRL_DMEM_BRST_TERM_CNT(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CPU2_FABRIC_ARB_CTRL_DMEM_BRST_TERM_CNT_SHIFT)) & CIU2_CIU2_CPU2_FABRIC_ARB_CTRL_DMEM_BRST_TERM_CNT_MASK)

#define CIU2_CIU2_CPU2_FABRIC_ARB_CTRL_IMEM_BRST_TERM_CNT_MASK (0xCU)
#define CIU2_CIU2_CPU2_FABRIC_ARB_CTRL_IMEM_BRST_TERM_CNT_SHIFT (2U)
#define CIU2_CIU2_CPU2_FABRIC_ARB_CTRL_IMEM_BRST_TERM_CNT(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CPU2_FABRIC_ARB_CTRL_IMEM_BRST_TERM_CNT_SHIFT)) & CIU2_CIU2_CPU2_FABRIC_ARB_CTRL_IMEM_BRST_TERM_CNT_MASK)

#define CIU2_CIU2_CPU2_FABRIC_ARB_CTRL_DMEM_NOBURSTTERM_MASK (0x10U)
#define CIU2_CIU2_CPU2_FABRIC_ARB_CTRL_DMEM_NOBURSTTERM_SHIFT (4U)
#define CIU2_CIU2_CPU2_FABRIC_ARB_CTRL_DMEM_NOBURSTTERM(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CPU2_FABRIC_ARB_CTRL_DMEM_NOBURSTTERM_SHIFT)) & CIU2_CIU2_CPU2_FABRIC_ARB_CTRL_DMEM_NOBURSTTERM_MASK)

#define CIU2_CIU2_CPU2_FABRIC_ARB_CTRL_DMEM_PRIORITY_MASK (0x60U)
#define CIU2_CIU2_CPU2_FABRIC_ARB_CTRL_DMEM_PRIORITY_SHIFT (5U)
#define CIU2_CIU2_CPU2_FABRIC_ARB_CTRL_DMEM_PRIORITY(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CPU2_FABRIC_ARB_CTRL_DMEM_PRIORITY_SHIFT)) & CIU2_CIU2_CPU2_FABRIC_ARB_CTRL_DMEM_PRIORITY_MASK)

#define CIU2_CIU2_CPU2_FABRIC_ARB_CTRL_DMEM_ROUND_ROBIN_EN_MASK (0x80U)
#define CIU2_CIU2_CPU2_FABRIC_ARB_CTRL_DMEM_ROUND_ROBIN_EN_SHIFT (7U)
#define CIU2_CIU2_CPU2_FABRIC_ARB_CTRL_DMEM_ROUND_ROBIN_EN(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CPU2_FABRIC_ARB_CTRL_DMEM_ROUND_ROBIN_EN_SHIFT)) & CIU2_CIU2_CPU2_FABRIC_ARB_CTRL_DMEM_ROUND_ROBIN_EN_MASK)

#define CIU2_CIU2_CPU2_FABRIC_ARB_CTRL_IMEM_NOBURSTTERM_MASK (0x100U)
#define CIU2_CIU2_CPU2_FABRIC_ARB_CTRL_IMEM_NOBURSTTERM_SHIFT (8U)
#define CIU2_CIU2_CPU2_FABRIC_ARB_CTRL_IMEM_NOBURSTTERM(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CPU2_FABRIC_ARB_CTRL_IMEM_NOBURSTTERM_SHIFT)) & CIU2_CIU2_CPU2_FABRIC_ARB_CTRL_IMEM_NOBURSTTERM_MASK)

#define CIU2_CIU2_CPU2_FABRIC_ARB_CTRL_IMEM_PRIORITY_MASK (0x600U)
#define CIU2_CIU2_CPU2_FABRIC_ARB_CTRL_IMEM_PRIORITY_SHIFT (9U)
#define CIU2_CIU2_CPU2_FABRIC_ARB_CTRL_IMEM_PRIORITY(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CPU2_FABRIC_ARB_CTRL_IMEM_PRIORITY_SHIFT)) & CIU2_CIU2_CPU2_FABRIC_ARB_CTRL_IMEM_PRIORITY_MASK)

#define CIU2_CIU2_CPU2_FABRIC_ARB_CTRL_IMEM_ROUND_ROBIN_EN_MASK (0x800U)
#define CIU2_CIU2_CPU2_FABRIC_ARB_CTRL_IMEM_ROUND_ROBIN_EN_SHIFT (11U)
#define CIU2_CIU2_CPU2_FABRIC_ARB_CTRL_IMEM_ROUND_ROBIN_EN(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CPU2_FABRIC_ARB_CTRL_IMEM_ROUND_ROBIN_EN_SHIFT)) & CIU2_CIU2_CPU2_FABRIC_ARB_CTRL_IMEM_ROUND_ROBIN_EN_MASK)
/*! @} */

/*! @name CIU2_CPU2_ICODE_INV_ADDR_CTRL - CPU2 Icode invalid address access control */
/*! @{ */

#define CIU2_CIU2_CPU2_ICODE_INV_ADDR_CTRL_LAST2_INV_ADDR_SLAVE_ID_MASK (0xFU)
#define CIU2_CIU2_CPU2_ICODE_INV_ADDR_CTRL_LAST2_INV_ADDR_SLAVE_ID_SHIFT (0U)
/*! last2_inv_addr_slave_id - Last2_inv_addr_Slave_ID
 */
#define CIU2_CIU2_CPU2_ICODE_INV_ADDR_CTRL_LAST2_INV_ADDR_SLAVE_ID(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CPU2_ICODE_INV_ADDR_CTRL_LAST2_INV_ADDR_SLAVE_ID_SHIFT)) & CIU2_CIU2_CPU2_ICODE_INV_ADDR_CTRL_LAST2_INV_ADDR_SLAVE_ID_MASK)

#define CIU2_CIU2_CPU2_ICODE_INV_ADDR_CTRL_LAST_INV_ADDR_SLAVE_ID_MASK (0xF0U)
#define CIU2_CIU2_CPU2_ICODE_INV_ADDR_CTRL_LAST_INV_ADDR_SLAVE_ID_SHIFT (4U)
/*! last_inv_addr_slave_id - Last_inv_addr_Slave_ID
 */
#define CIU2_CIU2_CPU2_ICODE_INV_ADDR_CTRL_LAST_INV_ADDR_SLAVE_ID(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CPU2_ICODE_INV_ADDR_CTRL_LAST_INV_ADDR_SLAVE_ID_SHIFT)) & CIU2_CIU2_CPU2_ICODE_INV_ADDR_CTRL_LAST_INV_ADDR_SLAVE_ID_MASK)

#define CIU2_CIU2_CPU2_ICODE_INV_ADDR_CTRL_CUR_INV_ADDR_SLAVE_ID_MASK (0xF00U)
#define CIU2_CIU2_CPU2_ICODE_INV_ADDR_CTRL_CUR_INV_ADDR_SLAVE_ID_SHIFT (8U)
/*! cur_inv_addr_slave_id - Cur_inv_addr_Slave_ID
 */
#define CIU2_CIU2_CPU2_ICODE_INV_ADDR_CTRL_CUR_INV_ADDR_SLAVE_ID(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CPU2_ICODE_INV_ADDR_CTRL_CUR_INV_ADDR_SLAVE_ID_SHIFT)) & CIU2_CIU2_CPU2_ICODE_INV_ADDR_CTRL_CUR_INV_ADDR_SLAVE_ID_MASK)

#define CIU2_CIU2_CPU2_ICODE_INV_ADDR_CTRL_HADDR_ICOD_SEL_MASK (0xC0000000U)
#define CIU2_CIU2_CPU2_ICODE_INV_ADDR_CTRL_HADDR_ICOD_SEL_SHIFT (30U)
/*! haddr_icod_sel - There are 3 haddr which can be observed by selecting this:
 */
#define CIU2_CIU2_CPU2_ICODE_INV_ADDR_CTRL_HADDR_ICOD_SEL(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CPU2_ICODE_INV_ADDR_CTRL_HADDR_ICOD_SEL_SHIFT)) & CIU2_CIU2_CPU2_ICODE_INV_ADDR_CTRL_HADDR_ICOD_SEL_MASK)
/*! @} */

/*! @name CIU2_CPU2_ICODE_INV_ADDR - CPU2 Icode invalid address */
/*! @{ */

#define CIU2_CIU2_CPU2_ICODE_INV_ADDR_HADDR_INV_ADDR_MASK (0xFFFFFFFFU)
#define CIU2_CIU2_CPU2_ICODE_INV_ADDR_HADDR_INV_ADDR_SHIFT (0U)
/*! haddr_inv_addr - based on CIU_CPU2_ICODE_INV_ADDR_CTRL[31:30], the address status is obsrved in this register
 */
#define CIU2_CIU2_CPU2_ICODE_INV_ADDR_HADDR_INV_ADDR(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CPU2_ICODE_INV_ADDR_HADDR_INV_ADDR_SHIFT)) & CIU2_CIU2_CPU2_ICODE_INV_ADDR_HADDR_INV_ADDR_MASK)
/*! @} */

/*! @name CIU2_CPU2_DCODE_INV_ADDR_CTRL - CPU2 Dcode invalid address access control */
/*! @{ */

#define CIU2_CIU2_CPU2_DCODE_INV_ADDR_CTRL_LAST2_INV_ADDR_SLAVE_ID_MASK (0xFU)
#define CIU2_CIU2_CPU2_DCODE_INV_ADDR_CTRL_LAST2_INV_ADDR_SLAVE_ID_SHIFT (0U)
/*! last2_inv_addr_slave_id - Last2_inv_addr_Slave_ID
 */
#define CIU2_CIU2_CPU2_DCODE_INV_ADDR_CTRL_LAST2_INV_ADDR_SLAVE_ID(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CPU2_DCODE_INV_ADDR_CTRL_LAST2_INV_ADDR_SLAVE_ID_SHIFT)) & CIU2_CIU2_CPU2_DCODE_INV_ADDR_CTRL_LAST2_INV_ADDR_SLAVE_ID_MASK)

#define CIU2_CIU2_CPU2_DCODE_INV_ADDR_CTRL_LAST_INV_ADDR_SLAVE_ID_MASK (0xF0U)
#define CIU2_CIU2_CPU2_DCODE_INV_ADDR_CTRL_LAST_INV_ADDR_SLAVE_ID_SHIFT (4U)
/*! last_inv_addr_slave_id - Last_inv_addr_Slave_ID
 */
#define CIU2_CIU2_CPU2_DCODE_INV_ADDR_CTRL_LAST_INV_ADDR_SLAVE_ID(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CPU2_DCODE_INV_ADDR_CTRL_LAST_INV_ADDR_SLAVE_ID_SHIFT)) & CIU2_CIU2_CPU2_DCODE_INV_ADDR_CTRL_LAST_INV_ADDR_SLAVE_ID_MASK)

#define CIU2_CIU2_CPU2_DCODE_INV_ADDR_CTRL_CUR_INV_ADDR_SLAVE_ID_MASK (0xF00U)
#define CIU2_CIU2_CPU2_DCODE_INV_ADDR_CTRL_CUR_INV_ADDR_SLAVE_ID_SHIFT (8U)
/*! cur_inv_addr_slave_id - Cur_inv_addr_Slave_ID
 */
#define CIU2_CIU2_CPU2_DCODE_INV_ADDR_CTRL_CUR_INV_ADDR_SLAVE_ID(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CPU2_DCODE_INV_ADDR_CTRL_CUR_INV_ADDR_SLAVE_ID_SHIFT)) & CIU2_CIU2_CPU2_DCODE_INV_ADDR_CTRL_CUR_INV_ADDR_SLAVE_ID_MASK)

#define CIU2_CIU2_CPU2_DCODE_INV_ADDR_CTRL_LAST2_INV_ADDR_MASTER_ID_MASK (0xF000U)
#define CIU2_CIU2_CPU2_DCODE_INV_ADDR_CTRL_LAST2_INV_ADDR_MASTER_ID_SHIFT (12U)
/*! last2_inv_addr_master_id - Last2_inv_addr_master_ID
 */
#define CIU2_CIU2_CPU2_DCODE_INV_ADDR_CTRL_LAST2_INV_ADDR_MASTER_ID(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CPU2_DCODE_INV_ADDR_CTRL_LAST2_INV_ADDR_MASTER_ID_SHIFT)) & CIU2_CIU2_CPU2_DCODE_INV_ADDR_CTRL_LAST2_INV_ADDR_MASTER_ID_MASK)

#define CIU2_CIU2_CPU2_DCODE_INV_ADDR_CTRL_LAST_INV_ADDR_MASTER_ID_MASK (0xF0000U)
#define CIU2_CIU2_CPU2_DCODE_INV_ADDR_CTRL_LAST_INV_ADDR_MASTER_ID_SHIFT (16U)
/*! last_inv_addr_master_id - Last_inv_addr_master_ID
 */
#define CIU2_CIU2_CPU2_DCODE_INV_ADDR_CTRL_LAST_INV_ADDR_MASTER_ID(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CPU2_DCODE_INV_ADDR_CTRL_LAST_INV_ADDR_MASTER_ID_SHIFT)) & CIU2_CIU2_CPU2_DCODE_INV_ADDR_CTRL_LAST_INV_ADDR_MASTER_ID_MASK)

#define CIU2_CIU2_CPU2_DCODE_INV_ADDR_CTRL_CUR_INV_ADDR_MASTER_ID_MASK (0xF00000U)
#define CIU2_CIU2_CPU2_DCODE_INV_ADDR_CTRL_CUR_INV_ADDR_MASTER_ID_SHIFT (20U)
/*! cur_inv_addr_master_id - Cur_inv_addr_master_ID
 */
#define CIU2_CIU2_CPU2_DCODE_INV_ADDR_CTRL_CUR_INV_ADDR_MASTER_ID(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CPU2_DCODE_INV_ADDR_CTRL_CUR_INV_ADDR_MASTER_ID_SHIFT)) & CIU2_CIU2_CPU2_DCODE_INV_ADDR_CTRL_CUR_INV_ADDR_MASTER_ID_MASK)

#define CIU2_CIU2_CPU2_DCODE_INV_ADDR_CTRL_HADDR_ICOD_SEL_MASK (0xC0000000U)
#define CIU2_CIU2_CPU2_DCODE_INV_ADDR_CTRL_HADDR_ICOD_SEL_SHIFT (30U)
/*! haddr_icod_sel - There are 3 haddr which can be observed by selecting this:
 */
#define CIU2_CIU2_CPU2_DCODE_INV_ADDR_CTRL_HADDR_ICOD_SEL(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CPU2_DCODE_INV_ADDR_CTRL_HADDR_ICOD_SEL_SHIFT)) & CIU2_CIU2_CPU2_DCODE_INV_ADDR_CTRL_HADDR_ICOD_SEL_MASK)
/*! @} */

/*! @name CIU2_CPU2_DCODE_INV_ADDR - CPU2 Dcode invalid address */
/*! @{ */

#define CIU2_CIU2_CPU2_DCODE_INV_ADDR_HADDR_INV_ADDR_MASK (0xFFFFFFFFU)
#define CIU2_CIU2_CPU2_DCODE_INV_ADDR_HADDR_INV_ADDR_SHIFT (0U)
/*! haddr_inv_addr - based on CIU_CPU2_DCODE_INV_ADDR_CTRL[31:30], the address status is obsrved in this register
 */
#define CIU2_CIU2_CPU2_DCODE_INV_ADDR_HADDR_INV_ADDR(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CPU2_DCODE_INV_ADDR_HADDR_INV_ADDR_SHIFT)) & CIU2_CIU2_CPU2_DCODE_INV_ADDR_HADDR_INV_ADDR_MASK)
/*! @} */

/*! @name CIU2_CPU_CPU2_CTRL - CPU2 control register */
/*! @{ */

#define CIU2_CIU2_CPU_CPU2_CTRL_VINITHI_MASK     (0x1U)
#define CIU2_CIU2_CPU_CPU2_CTRL_VINITHI_SHIFT    (0U)
#define CIU2_CIU2_CPU_CPU2_CTRL_VINITHI(x)       (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CPU_CPU2_CTRL_VINITHI_SHIFT)) & CIU2_CIU2_CPU_CPU2_CTRL_VINITHI_MASK)

#define CIU2_CIU2_CPU_CPU2_CTRL_CPU2_JTAG_CHAIN_BYPASS_MASK (0x4U)
#define CIU2_CIU2_CPU_CPU2_CTRL_CPU2_JTAG_CHAIN_BYPASS_SHIFT (2U)
#define CIU2_CIU2_CPU_CPU2_CTRL_CPU2_JTAG_CHAIN_BYPASS(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CPU_CPU2_CTRL_CPU2_JTAG_CHAIN_BYPASS_SHIFT)) & CIU2_CIU2_CPU_CPU2_CTRL_CPU2_JTAG_CHAIN_BYPASS_MASK)

#define CIU2_CIU2_CPU_CPU2_CTRL_CPU2_BOOT_IMEM_MUX_EN_MASK (0x10U)
#define CIU2_CIU2_CPU_CPU2_CTRL_CPU2_BOOT_IMEM_MUX_EN_SHIFT (4U)
#define CIU2_CIU2_CPU_CPU2_CTRL_CPU2_BOOT_IMEM_MUX_EN(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CPU_CPU2_CTRL_CPU2_BOOT_IMEM_MUX_EN_SHIFT)) & CIU2_CIU2_CPU_CPU2_CTRL_CPU2_BOOT_IMEM_MUX_EN_MASK)

#define CIU2_CIU2_CPU_CPU2_CTRL_CPU2_BOOT_DMEM_MUX_EN_MASK (0x20U)
#define CIU2_CIU2_CPU_CPU2_CTRL_CPU2_BOOT_DMEM_MUX_EN_SHIFT (5U)
#define CIU2_CIU2_CPU_CPU2_CTRL_CPU2_BOOT_DMEM_MUX_EN(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CPU_CPU2_CTRL_CPU2_BOOT_DMEM_MUX_EN_SHIFT)) & CIU2_CIU2_CPU_CPU2_CTRL_CPU2_BOOT_DMEM_MUX_EN_MASK)

#define CIU2_CIU2_CPU_CPU2_CTRL_CPU2_DBG_CTRL_MASK (0xFFF0000U)
#define CIU2_CIU2_CPU_CPU2_CTRL_CPU2_DBG_CTRL_SHIFT (16U)
/*! cpu2_dbg_ctrl - cpu2 debug control
 */
#define CIU2_CIU2_CPU_CPU2_CTRL_CPU2_DBG_CTRL(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CPU_CPU2_CTRL_CPU2_DBG_CTRL_SHIFT)) & CIU2_CIU2_CPU_CPU2_CTRL_CPU2_DBG_CTRL_MASK)

#define CIU2_CIU2_CPU_CPU2_CTRL_CPU3_RESET_INT_MASK (0x20000000U)
#define CIU2_CIU2_CPU_CPU2_CTRL_CPU3_RESET_INT_SHIFT (29U)
/*! cpu3_reset_int - cpu2 fw resets cpu3(or cpu3 fw resets cpu2 if this register is used by cpu3)
 */
#define CIU2_CIU2_CPU_CPU2_CTRL_CPU3_RESET_INT(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CPU_CPU2_CTRL_CPU3_RESET_INT_SHIFT)) & CIU2_CIU2_CPU_CPU2_CTRL_CPU3_RESET_INT_MASK)

#define CIU2_CIU2_CPU_CPU2_CTRL_DSR_WKUP_IN_USE_MASK (0x40000000U)
#define CIU2_CIU2_CPU_CPU2_CTRL_DSR_WKUP_IN_USE_SHIFT (30U)
/*! dsr_wkup_in_use - dsr wkup when dsr_wkup_in_use = 1'b1
 */
#define CIU2_CIU2_CPU_CPU2_CTRL_DSR_WKUP_IN_USE(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CPU_CPU2_CTRL_DSR_WKUP_IN_USE_SHIFT)) & CIU2_CIU2_CPU_CPU2_CTRL_DSR_WKUP_IN_USE_MASK)

#define CIU2_CIU2_CPU_CPU2_CTRL_CPU1_RESET_INT_MASK (0x80000000U)
#define CIU2_CIU2_CPU_CPU2_CTRL_CPU1_RESET_INT_SHIFT (31U)
/*! cpu1_reset_int - cpu2 fw resets cpu1( or cpu3 fw resets cpu1 if this register is used by cpu3)
 */
#define CIU2_CIU2_CPU_CPU2_CTRL_CPU1_RESET_INT(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CPU_CPU2_CTRL_CPU1_RESET_INT_SHIFT)) & CIU2_CIU2_CPU_CPU2_CTRL_CPU1_RESET_INT_MASK)
/*! @} */

/*! @name CIU2_BRF_CTRL - BRF Control and Status */
/*! @{ */

#define CIU2_CIU2_BRF_CTRL_AHB_SLV_BRF_SER_EN_MASK (0x1U)
#define CIU2_CIU2_BRF_CTRL_AHB_SLV_BRF_SER_EN_SHIFT (0U)
/*! ahb_slv_brf_ser_en - When set to 1, BRF serial interface will be accessed thru AHB slave memory mapped from 0xA800A000 to 0xA8011FFF
 */
#define CIU2_CIU2_BRF_CTRL_AHB_SLV_BRF_SER_EN(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_BRF_CTRL_AHB_SLV_BRF_SER_EN_SHIFT)) & CIU2_CIU2_BRF_CTRL_AHB_SLV_BRF_SER_EN_MASK)

#define CIU2_CIU2_BRF_CTRL_SEL_BRF_TO_SSU_DUMP_PATH_MASK (0x2U)
#define CIU2_CIU2_BRF_CTRL_SEL_BRF_TO_SSU_DUMP_PATH_SHIFT (1U)
/*! sel_brf_to_ssu_dump_path - When set to 0, select BRF to SSU dump path
 */
#define CIU2_CIU2_BRF_CTRL_SEL_BRF_TO_SSU_DUMP_PATH(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_BRF_CTRL_SEL_BRF_TO_SSU_DUMP_PATH_SHIFT)) & CIU2_CIU2_BRF_CTRL_SEL_BRF_TO_SSU_DUMP_PATH_MASK)

#define CIU2_CIU2_BRF_CTRL_CIU_BRF_REF1X_CLK_CTRL_BYPASS_EN_MASK (0x100U)
#define CIU2_CIU2_BRF_CTRL_CIU_BRF_REF1X_CLK_CTRL_BYPASS_EN_SHIFT (8U)
#define CIU2_CIU2_BRF_CTRL_CIU_BRF_REF1X_CLK_CTRL_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_BRF_CTRL_CIU_BRF_REF1X_CLK_CTRL_BYPASS_EN_SHIFT)) & CIU2_CIU2_BRF_CTRL_CIU_BRF_REF1X_CLK_CTRL_BYPASS_EN_MASK)

#define CIU2_CIU2_BRF_CTRL_CIU_BRF_REF1X_CLK_CTRL_BYPASS_VAL_MASK (0x200U)
#define CIU2_CIU2_BRF_CTRL_CIU_BRF_REF1X_CLK_CTRL_BYPASS_VAL_SHIFT (9U)
/*! ciu_brf_ref1x_clk_ctrl_bypass_val - 1. brf ref clk 1x is enabled
 */
#define CIU2_CIU2_BRF_CTRL_CIU_BRF_REF1X_CLK_CTRL_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_BRF_CTRL_CIU_BRF_REF1X_CLK_CTRL_BYPASS_VAL_SHIFT)) & CIU2_CIU2_BRF_CTRL_CIU_BRF_REF1X_CLK_CTRL_BYPASS_VAL_MASK)

#define CIU2_CIU2_BRF_CTRL_BRF_CHIP_RDY_MASK     (0x80000000U)
#define CIU2_CIU2_BRF_CTRL_BRF_CHIP_RDY_SHIFT    (31U)
/*! brf_chip_rdy - BRF Chip_Rdy Status
 */
#define CIU2_CIU2_BRF_CTRL_BRF_CHIP_RDY(x)       (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_BRF_CTRL_BRF_CHIP_RDY_SHIFT)) & CIU2_CIU2_BRF_CTRL_BRF_CHIP_RDY_MASK)
/*! @} */

/*! @name CIU2_BRF_EXTRA_PORT - BRF Extra Port Connection */
/*! @{ */

#define CIU2_CIU2_BRF_EXTRA_PORT_SOC_BRF_EXTRA_MASK (0xFU)
#define CIU2_CIU2_BRF_EXTRA_PORT_SOC_BRF_EXTRA_SHIFT (0U)
/*! soc_brf_extra - SOC_BRF_EXTRA[3:0]
 */
#define CIU2_CIU2_BRF_EXTRA_PORT_SOC_BRF_EXTRA(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_BRF_EXTRA_PORT_SOC_BRF_EXTRA_SHIFT)) & CIU2_CIU2_BRF_EXTRA_PORT_SOC_BRF_EXTRA_MASK)
/*! @} */

/*! @name CIU2_BRF_ECO_CTRL - BRF ECO Control */
/*! @{ */

#define CIU2_CIU2_BRF_ECO_CTRL_ECO_BITS_MASK     (0xFFFFFFFFU)
#define CIU2_CIU2_BRF_ECO_CTRL_ECO_BITS_SHIFT    (0U)
/*! eco_bits - Reserved
 */
#define CIU2_CIU2_BRF_ECO_CTRL_ECO_BITS(x)       (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_BRF_ECO_CTRL_ECO_BITS_SHIFT)) & CIU2_CIU2_BRF_ECO_CTRL_ECO_BITS_MASK)
/*! @} */

/*! @name CIU2_BTU_CTRL - BTU Control and Status */
/*! @{ */

#define CIU2_CIU2_BTU_CTRL_BTU_CIPHER_EN_MASK    (0x1U)
#define CIU2_CIU2_BTU_CTRL_BTU_CIPHER_EN_SHIFT   (0U)
/*! btu_cipher_en - Bluetooth Cipher Logic
 */
#define CIU2_CIU2_BTU_CTRL_BTU_CIPHER_EN(x)      (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_BTU_CTRL_BTU_CIPHER_EN_SHIFT)) & CIU2_CIU2_BTU_CTRL_BTU_CIPHER_EN_MASK)

#define CIU2_CIU2_BTU_CTRL_DBUS_HIGH_SPEED_SEL_MASK (0x2U)
#define CIU2_CIU2_BTU_CTRL_DBUS_HIGH_SPEED_SEL_SHIFT (1U)
/*! dbus_high_speed_sel - Dbus High Speed Select Signal for Greater than 4 MHz
 */
#define CIU2_CIU2_BTU_CTRL_DBUS_HIGH_SPEED_SEL(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_BTU_CTRL_DBUS_HIGH_SPEED_SEL_SHIFT)) & CIU2_CIU2_BTU_CTRL_DBUS_HIGH_SPEED_SEL_MASK)

#define CIU2_CIU2_BTU_CTRL_BT_CLK_SEL_MASK       (0xCU)
#define CIU2_CIU2_BTU_CTRL_BT_CLK_SEL_SHIFT      (2U)
/*! bt_clk_sel - Bluetooth sys Clock Select
 */
#define CIU2_CIU2_BTU_CTRL_BT_CLK_SEL(x)         (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_BTU_CTRL_BT_CLK_SEL_SHIFT)) & CIU2_CIU2_BTU_CTRL_BT_CLK_SEL_MASK)

#define CIU2_CIU2_BTU_CTRL_BT_IP_SER_SEL_MASK    (0x700U)
#define CIU2_CIU2_BTU_CTRL_BT_IP_SER_SEL_SHIFT   (8U)
/*! bt_ip_ser_sel - bt_ip_ser_sel
 */
#define CIU2_CIU2_BTU_CTRL_BT_IP_SER_SEL(x)      (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_BTU_CTRL_BT_IP_SER_SEL_SHIFT)) & CIU2_CIU2_BTU_CTRL_BT_IP_SER_SEL_MASK)

#define CIU2_CIU2_BTU_CTRL_BTU_MC_WAKEUP_MASK    (0x80000000U)
#define CIU2_CIU2_BTU_CTRL_BTU_MC_WAKEUP_SHIFT   (31U)
/*! btu_mc_wakeup - BTU MC_Wakeup Status
 */
#define CIU2_CIU2_BTU_CTRL_BTU_MC_WAKEUP(x)      (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_BTU_CTRL_BTU_MC_WAKEUP_SHIFT)) & CIU2_CIU2_BTU_CTRL_BTU_MC_WAKEUP_MASK)
/*! @} */

/*! @name CIU2_BT_PS - BT Clock Power Save */
/*! @{ */

#define CIU2_CIU2_BT_PS_BT_MCLK_NCO_MVAL_MASK    (0x3FFFFFFU)
#define CIU2_CIU2_BT_PS_BT_MCLK_NCO_MVAL_SHIFT   (0U)
/*! bt_mclk_nco_mval - BT_MCLK NCO Module Step Control (default 0x0)
 */
#define CIU2_CIU2_BT_PS_BT_MCLK_NCO_MVAL(x)      (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_BT_PS_BT_MCLK_NCO_MVAL_SHIFT)) & CIU2_CIU2_BT_PS_BT_MCLK_NCO_MVAL_MASK)

#define CIU2_CIU2_BT_PS_BT_MCLK_NCO_EN_MASK      (0x4000000U)
#define CIU2_CIU2_BT_PS_BT_MCLK_NCO_EN_SHIFT     (26U)
/*! bt_mclk_nco_en - BT_MCLK_NCO logic to count
 */
#define CIU2_CIU2_BT_PS_BT_MCLK_NCO_EN(x)        (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_BT_PS_BT_MCLK_NCO_EN_SHIFT)) & CIU2_CIU2_BT_PS_BT_MCLK_NCO_EN_MASK)

#define CIU2_CIU2_BT_PS_BT_MCLK_TBG_NCO_SEL_MASK (0x8000000U)
#define CIU2_CIU2_BT_PS_BT_MCLK_TBG_NCO_SEL_SHIFT (27U)
/*! bt_mclk_tbg_nco_sel - BT_4M_PCM_CLK
 */
#define CIU2_CIU2_BT_PS_BT_MCLK_TBG_NCO_SEL(x)   (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_BT_PS_BT_MCLK_TBG_NCO_SEL_SHIFT)) & CIU2_CIU2_BT_PS_BT_MCLK_TBG_NCO_SEL_MASK)

#define CIU2_CIU2_BT_PS_BT_MCLK_FROM_SOC_SEL_MASK (0x10000000U)
#define CIU2_CIU2_BT_PS_BT_MCLK_FROM_SOC_SEL_SHIFT (28U)
/*! bt_mclk_from_soc_sel - BT_MCLK
 */
#define CIU2_CIU2_BT_PS_BT_MCLK_FROM_SOC_SEL(x)  (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_BT_PS_BT_MCLK_FROM_SOC_SEL_SHIFT)) & CIU2_CIU2_BT_PS_BT_MCLK_FROM_SOC_SEL_MASK)
/*! @} */

/*! @name CIU2_BT_PS2 - BT Clock Power Save 2 */
/*! @{ */

#define CIU2_CIU2_BT_PS2_BT_PCM_CLK_NCO_MVAL_MASK (0x3FFFFFFU)
#define CIU2_CIU2_BT_PS2_BT_PCM_CLK_NCO_MVAL_SHIFT (0U)
/*! bt_pcm_clk_nco_mval - BT_PCM_CLK NCO Module Step Control (default 0x0)
 */
#define CIU2_CIU2_BT_PS2_BT_PCM_CLK_NCO_MVAL(x)  (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_BT_PS2_BT_PCM_CLK_NCO_MVAL_SHIFT)) & CIU2_CIU2_BT_PS2_BT_PCM_CLK_NCO_MVAL_MASK)

#define CIU2_CIU2_BT_PS2_BT_PCM_CLK_NCO_EN_MASK  (0x4000000U)
#define CIU2_CIU2_BT_PS2_BT_PCM_CLK_NCO_EN_SHIFT (26U)
/*! bt_pcm_clk_nco_en - BT_PCM_CLK_NCO logic to count
 */
#define CIU2_CIU2_BT_PS2_BT_PCM_CLK_NCO_EN(x)    (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_BT_PS2_BT_PCM_CLK_NCO_EN_SHIFT)) & CIU2_CIU2_BT_PS2_BT_PCM_CLK_NCO_EN_MASK)

#define CIU2_CIU2_BT_PS2_BT_PCM_CLK_TBG_NCO_SEL_MASK (0x8000000U)
#define CIU2_CIU2_BT_PS2_BT_PCM_CLK_TBG_NCO_SEL_SHIFT (27U)
/*! bt_pcm_clk_tbg_nco_sel - BT_4M_PCM_CLK
 */
#define CIU2_CIU2_BT_PS2_BT_PCM_CLK_TBG_NCO_SEL(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_BT_PS2_BT_PCM_CLK_TBG_NCO_SEL_SHIFT)) & CIU2_CIU2_BT_PS2_BT_PCM_CLK_TBG_NCO_SEL_MASK)
/*! @} */

/*! @name CIU2_BT_REF_CTRL - BT Ref Control */
/*! @{ */

#define CIU2_CIU2_BT_REF_CTRL_NCO_EN_MASK        (0x1U)
#define CIU2_CIU2_BT_REF_CTRL_NCO_EN_SHIFT       (0U)
/*! nco_en - Bluetooth Reference Clock NCO Enable information to APU.
 */
#define CIU2_CIU2_BT_REF_CTRL_NCO_EN(x)          (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_BT_REF_CTRL_NCO_EN_SHIFT)) & CIU2_CIU2_BT_REF_CTRL_NCO_EN_MASK)

#define CIU2_CIU2_BT_REF_CTRL_NCO_SEL_MASK       (0x2U)
#define CIU2_CIU2_BT_REF_CTRL_NCO_SEL_SHIFT      (1U)
/*! nco_sel - Bluetooth Reference Clock NCO Select Value
 */
#define CIU2_CIU2_BT_REF_CTRL_NCO_SEL(x)         (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_BT_REF_CTRL_NCO_SEL_SHIFT)) & CIU2_CIU2_BT_REF_CTRL_NCO_SEL_MASK)

#define CIU2_CIU2_BT_REF_CTRL_NCO_GEN_MASK       (0x3FFFCU)
#define CIU2_CIU2_BT_REF_CTRL_NCO_GEN_SHIFT      (2U)
/*! nco_gen - Bluetooth Reference Clock NCO Gen Value
 */
#define CIU2_CIU2_BT_REF_CTRL_NCO_GEN(x)         (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_BT_REF_CTRL_NCO_GEN_SHIFT)) & CIU2_CIU2_BT_REF_CTRL_NCO_GEN_MASK)

#define CIU2_CIU2_BT_REF_CTRL_BT_CLK_NCO_REFCLK_SEL_MASK (0x100000U)
#define CIU2_CIU2_BT_REF_CTRL_BT_CLK_NCO_REFCLK_SEL_SHIFT (20U)
/*! bt_clk_nco_refclk_sel - BT clk (bt sys clk) selection
 */
#define CIU2_CIU2_BT_REF_CTRL_BT_CLK_NCO_REFCLK_SEL(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_BT_REF_CTRL_BT_CLK_NCO_REFCLK_SEL_SHIFT)) & CIU2_CIU2_BT_REF_CTRL_BT_CLK_NCO_REFCLK_SEL_MASK)
/*! @} */

/*! @name CIU2_BT_PS3 - BT Clock Power Save 3 */
/*! @{ */

#define CIU2_CIU2_BT_PS3_BTU_16M_CLK_NCO_STEP_CTRL_MASK (0x3FFFFFFU)
#define CIU2_CIU2_BT_PS3_BTU_16M_CLK_NCO_STEP_CTRL_SHIFT (0U)
/*! btu_16m_clk_nco_step_ctrl - BT_16M_CLK NCO Module Step Control
 */
#define CIU2_CIU2_BT_PS3_BTU_16M_CLK_NCO_STEP_CTRL(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_BT_PS3_BTU_16M_CLK_NCO_STEP_CTRL_SHIFT)) & CIU2_CIU2_BT_PS3_BTU_16M_CLK_NCO_STEP_CTRL_MASK)

#define CIU2_CIU2_BT_PS3_BTU_16M_CLK_NCO_EN_MASK (0x4000000U)
#define CIU2_CIU2_BT_PS3_BTU_16M_CLK_NCO_EN_SHIFT (26U)
/*! btu_16m_clk_nco_en - BTU 16M Clock NCO Enable
 */
#define CIU2_CIU2_BT_PS3_BTU_16M_CLK_NCO_EN(x)   (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_BT_PS3_BTU_16M_CLK_NCO_EN_SHIFT)) & CIU2_CIU2_BT_PS3_BTU_16M_CLK_NCO_EN_MASK)

#define CIU2_CIU2_BT_PS3_BTU_16M_CLK_NCO_SEL_MASK (0x8000000U)
#define CIU2_CIU2_BT_PS3_BTU_16M_CLK_NCO_SEL_SHIFT (27U)
/*! btu_16m_clk_nco_sel - BTU 16M clock NCO Select Value
 */
#define CIU2_CIU2_BT_PS3_BTU_16M_CLK_NCO_SEL(x)  (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_BT_PS3_BTU_16M_CLK_NCO_SEL_SHIFT)) & CIU2_CIU2_BT_PS3_BTU_16M_CLK_NCO_SEL_MASK)

#define CIU2_CIU2_BT_PS3_BTU_CLK_NCO_MODE_MASK   (0x20000000U)
#define CIU2_CIU2_BT_PS3_BTU_CLK_NCO_MODE_SHIFT  (29U)
/*! btu_clk_nco_mode - BTU Clock source from ref clock (nco mode)
 */
#define CIU2_CIU2_BT_PS3_BTU_CLK_NCO_MODE(x)     (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_BT_PS3_BTU_CLK_NCO_MODE_SHIFT)) & CIU2_CIU2_BT_PS3_BTU_CLK_NCO_MODE_MASK)
/*! @} */

/*! @name CIU2_BTU_ECO_CTRL - BTU ECO Control */
/*! @{ */

#define CIU2_CIU2_BTU_ECO_CTRL_ECO_BITS_MASK     (0xFFFFFFFFU)
#define CIU2_CIU2_BTU_ECO_CTRL_ECO_BITS_SHIFT    (0U)
/*! eco_bits - Reserved
 */
#define CIU2_CIU2_BTU_ECO_CTRL_ECO_BITS(x)       (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_BTU_ECO_CTRL_ECO_BITS_SHIFT)) & CIU2_CIU2_BTU_ECO_CTRL_ECO_BITS_MASK)
/*! @} */

/*! @name CIU2_INT_MASK - CIU2 Interrupt Mask */
/*! @{ */

#define CIU2_CIU2_INT_MASK_MASK_MASK             (0xFFFFFFFFU)
#define CIU2_CIU2_INT_MASK_MASK_SHIFT            (0U)
/*! mask - Interrupt Mask for CIU2 Interrupts
 */
#define CIU2_CIU2_INT_MASK_MASK(x)               (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_INT_MASK_MASK_SHIFT)) & CIU2_CIU2_INT_MASK_MASK_MASK)
/*! @} */

/*! @name CIU2_INT_SELECT - CIU2 Interrupt Select */
/*! @{ */

#define CIU2_CIU2_INT_SELECT_SEL_MASK            (0xFFFFFFFFU)
#define CIU2_CIU2_INT_SELECT_SEL_SHIFT           (0U)
/*! sel - Interrupt Read/Write Clear for CIU2 Interrupts
 */
#define CIU2_CIU2_INT_SELECT_SEL(x)              (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_INT_SELECT_SEL_SHIFT)) & CIU2_CIU2_INT_SELECT_SEL_MASK)
/*! @} */

/*! @name CIU2_INT_EVENT_MASK - CIU2 Interrupt Event Mask */
/*! @{ */

#define CIU2_CIU2_INT_EVENT_MASK_MASK_MASK       (0xFFFFFFFFU)
#define CIU2_CIU2_INT_EVENT_MASK_MASK_SHIFT      (0U)
/*! mask - Interrupt Event Mask for CIU2 Interrupts
 */
#define CIU2_CIU2_INT_EVENT_MASK_MASK(x)         (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_INT_EVENT_MASK_MASK_SHIFT)) & CIU2_CIU2_INT_EVENT_MASK_MASK_MASK)
/*! @} */

/*! @name CIU2_INT_STATUS - CIU2 Interrupt Status */
/*! @{ */

#define CIU2_CIU2_INT_STATUS_CIU_ISR_MASK        (0xFFFFFFFFU)
#define CIU2_CIU2_INT_STATUS_CIU_ISR_SHIFT       (0U)
/*! ciu_isr - CIU2 Interrupt Status (ISR)
 */
#define CIU2_CIU2_INT_STATUS_CIU_ISR(x)          (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_INT_STATUS_CIU_ISR_SHIFT)) & CIU2_CIU2_INT_STATUS_CIU_ISR_MASK)
/*! @} */

/*! @name CPU2_ERR_INT_MASK - CPU2 ERR Interrupt Mask */
/*! @{ */

#define CIU2_CPU2_ERR_INT_MASK_MASK_MASK         (0xFFFFFFFFU)
#define CIU2_CPU2_ERR_INT_MASK_MASK_SHIFT        (0U)
/*! mask - Interrupt Mask for CPU2 ERR Interrupts
 */
#define CIU2_CPU2_ERR_INT_MASK_MASK(x)           (((uint32_t)(((uint32_t)(x)) << CIU2_CPU2_ERR_INT_MASK_MASK_SHIFT)) & CIU2_CPU2_ERR_INT_MASK_MASK_MASK)
/*! @} */

/*! @name CPU2_ERR_INT_SELECT - CPU2 ERR Interrupt Clear Select */
/*! @{ */

#define CIU2_CPU2_ERR_INT_SELECT_SEL_MASK        (0xFFFFFFFFU)
#define CIU2_CPU2_ERR_INT_SELECT_SEL_SHIFT       (0U)
/*! sel - Interrupt Read/Write Clear for CPU2 ERR Interrupts
 */
#define CIU2_CPU2_ERR_INT_SELECT_SEL(x)          (((uint32_t)(((uint32_t)(x)) << CIU2_CPU2_ERR_INT_SELECT_SEL_SHIFT)) & CIU2_CPU2_ERR_INT_SELECT_SEL_MASK)
/*! @} */

/*! @name CPU2_ERR_INT_EVENT_MASK - CPU2 ERR Interrupt Event Mask */
/*! @{ */

#define CIU2_CPU2_ERR_INT_EVENT_MASK_MASK_MASK   (0xFFFFFFFFU)
#define CIU2_CPU2_ERR_INT_EVENT_MASK_MASK_SHIFT  (0U)
/*! mask - Interrupt Event Mask for CPU2 ERR Interrupts
 */
#define CIU2_CPU2_ERR_INT_EVENT_MASK_MASK(x)     (((uint32_t)(((uint32_t)(x)) << CIU2_CPU2_ERR_INT_EVENT_MASK_MASK_SHIFT)) & CIU2_CPU2_ERR_INT_EVENT_MASK_MASK_MASK)
/*! @} */

/*! @name CPU2_ERR_INT_STATUS - CPU2 ERR Interrupt Status */
/*! @{ */

#define CIU2_CPU2_ERR_INT_STATUS_ERR_ISR_MASK    (0xFFFFFFFFU)
#define CIU2_CPU2_ERR_INT_STATUS_ERR_ISR_SHIFT   (0U)
/*! err_isr - CPU2 ERR Interrupt Status (ISR)
 */
#define CIU2_CPU2_ERR_INT_STATUS_ERR_ISR(x)      (((uint32_t)(((uint32_t)(x)) << CIU2_CPU2_ERR_INT_STATUS_ERR_ISR_SHIFT)) & CIU2_CPU2_ERR_INT_STATUS_ERR_ISR_MASK)
/*! @} */

/*! @name CPU2_ERR_INT2_MASK - CPU2 ERR Interrupt 2 Mask */
/*! @{ */

#define CIU2_CPU2_ERR_INT2_MASK_MASK_MASK        (0xFFFFFFFFU)
#define CIU2_CPU2_ERR_INT2_MASK_MASK_SHIFT       (0U)
/*! mask - Interrupt Mask for CPU2 ERR Interrupts 2
 */
#define CIU2_CPU2_ERR_INT2_MASK_MASK(x)          (((uint32_t)(((uint32_t)(x)) << CIU2_CPU2_ERR_INT2_MASK_MASK_SHIFT)) & CIU2_CPU2_ERR_INT2_MASK_MASK_MASK)
/*! @} */

/*! @name CPU2_ERR_INT2_SELECT - CPU2 ERR Interrupt 2 Clear Select */
/*! @{ */

#define CIU2_CPU2_ERR_INT2_SELECT_SEL_MASK       (0xFFFFFFFFU)
#define CIU2_CPU2_ERR_INT2_SELECT_SEL_SHIFT      (0U)
/*! sel - Interrupt Read/Write Clear for CPU2 ERR Interrupts 2
 */
#define CIU2_CPU2_ERR_INT2_SELECT_SEL(x)         (((uint32_t)(((uint32_t)(x)) << CIU2_CPU2_ERR_INT2_SELECT_SEL_SHIFT)) & CIU2_CPU2_ERR_INT2_SELECT_SEL_MASK)
/*! @} */

/*! @name CPU2_ERR_INT2_EVENT_MASK - CPU2 ERR Interrupt 2 Event Mask */
/*! @{ */

#define CIU2_CPU2_ERR_INT2_EVENT_MASK_MASK_MASK  (0xFFFFFFFFU)
#define CIU2_CPU2_ERR_INT2_EVENT_MASK_MASK_SHIFT (0U)
/*! mask - Interrupt Event Mask for CPU2 ERR Interrupts 2
 */
#define CIU2_CPU2_ERR_INT2_EVENT_MASK_MASK(x)    (((uint32_t)(((uint32_t)(x)) << CIU2_CPU2_ERR_INT2_EVENT_MASK_MASK_SHIFT)) & CIU2_CPU2_ERR_INT2_EVENT_MASK_MASK_MASK)
/*! @} */

/*! @name CPU2_ERR_INT2_STATUS - CPU2 ERR Interrupt 2 Status */
/*! @{ */

#define CIU2_CPU2_ERR_INT2_STATUS_ERR_ISR_MASK   (0xFFFFFFFFU)
#define CIU2_CPU2_ERR_INT2_STATUS_ERR_ISR_SHIFT  (0U)
/*! err_isr - CPU1 ERR Interrupt 2 Status (ISR)
 */
#define CIU2_CPU2_ERR_INT2_STATUS_ERR_ISR(x)     (((uint32_t)(((uint32_t)(x)) << CIU2_CPU2_ERR_INT2_STATUS_ERR_ISR_SHIFT)) & CIU2_CPU2_ERR_INT2_STATUS_ERR_ISR_MASK)
/*! @} */

/*! @name CIU2_CPU_CPU2_MSG_CTRL - CPU2 message register */
/*! @{ */

#define CIU2_CIU2_CPU_CPU2_MSG_CTRL_CPU1_TO_CPU2_MSG_RDY_MASK (0x1U)
#define CIU2_CIU2_CPU_CPU2_MSG_CTRL_CPU1_TO_CPU2_MSG_RDY_SHIFT (0U)
/*! cpu1_to_cpu2_msg_rdy - CPU1 Message for CPU2 is ready. This is self clearing bit. The CPU1
 *    writes 1 to indicate that message for CPU2 is ready. This generates an Interrupt to CPU2 via APU.
 *    This is old schem and we should use IMU based scheme.
 */
#define CIU2_CIU2_CPU_CPU2_MSG_CTRL_CPU1_TO_CPU2_MSG_RDY(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CPU_CPU2_MSG_CTRL_CPU1_TO_CPU2_MSG_RDY_SHIFT)) & CIU2_CIU2_CPU_CPU2_MSG_CTRL_CPU1_TO_CPU2_MSG_RDY_MASK)

#define CIU2_CIU2_CPU_CPU2_MSG_CTRL_CPU3_TO_CPU2_MSG_RDY_MASK (0x2U)
#define CIU2_CIU2_CPU_CPU2_MSG_CTRL_CPU3_TO_CPU2_MSG_RDY_SHIFT (1U)
/*! cpu3_to_cpu2_msg_rdy - CPU3 Message for CPU2 is ready. This is self clearing bit. The CPU3
 *    writes 1 to indicate that message for CPU2 is ready. This generates an Interrupt to CPU2 via APU.
 *    This is old schem and we should use IMU based scheme.
 */
#define CIU2_CIU2_CPU_CPU2_MSG_CTRL_CPU3_TO_CPU2_MSG_RDY(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CPU_CPU2_MSG_CTRL_CPU3_TO_CPU2_MSG_RDY_SHIFT)) & CIU2_CIU2_CPU_CPU2_MSG_CTRL_CPU3_TO_CPU2_MSG_RDY_MASK)

#define CIU2_CIU2_CPU_CPU2_MSG_CTRL_CPU1_TO_CPU2_MSG_PROCESS_DONE_MASK (0x100U)
#define CIU2_CIU2_CPU_CPU2_MSG_CTRL_CPU1_TO_CPU2_MSG_PROCESS_DONE_SHIFT (8U)
/*! cpu1_to_cpu2_msg_process_done - CPU1 Message for CPU2 has been read by CPU2 and executed. This
 *    is self clearing bit. The CPU2 writes 1 to indicate that message send by CPU1 is executed. This
 *    generates an Interrupt to CPU1 via CIU1.
 */
#define CIU2_CIU2_CPU_CPU2_MSG_CTRL_CPU1_TO_CPU2_MSG_PROCESS_DONE(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CPU_CPU2_MSG_CTRL_CPU1_TO_CPU2_MSG_PROCESS_DONE_SHIFT)) & CIU2_CIU2_CPU_CPU2_MSG_CTRL_CPU1_TO_CPU2_MSG_PROCESS_DONE_MASK)

#define CIU2_CIU2_CPU_CPU2_MSG_CTRL_CPU3_TO_CPU2_MSG_PROCESS_DONE_MASK (0x200U)
#define CIU2_CIU2_CPU_CPU2_MSG_CTRL_CPU3_TO_CPU2_MSG_PROCESS_DONE_SHIFT (9U)
/*! cpu3_to_cpu2_msg_process_done - CPU3 Message for CPU2 has been read by CPU2 and executed. This
 *    is self clearing bit. The CPU2 writes 1 to indicate that message send by CPU3 is executed. This
 *    generates an Interrupt to CPU3 via CIU3.
 */
#define CIU2_CIU2_CPU_CPU2_MSG_CTRL_CPU3_TO_CPU2_MSG_PROCESS_DONE(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CPU_CPU2_MSG_CTRL_CPU3_TO_CPU2_MSG_PROCESS_DONE_SHIFT)) & CIU2_CIU2_CPU_CPU2_MSG_CTRL_CPU3_TO_CPU2_MSG_PROCESS_DONE_MASK)
/*! @} */

/*! @name CIU2_IMU_CPU1_WR_MSG_TO_CPU2 - CPU1 write message to CPU2 */
/*! @{ */

#define CIU2_CIU2_IMU_CPU1_WR_MSG_TO_CPU2_CPU1_WR_MSG_CPU2_MASK (0xFFFFFFFFU)
#define CIU2_CIU2_IMU_CPU1_WR_MSG_TO_CPU2_CPU1_WR_MSG_CPU2_SHIFT (0U)
/*! cpu1_wr_msg_cpu2 - Write CPU1 message data to CPU2 (push to FIFO)
 */
#define CIU2_CIU2_IMU_CPU1_WR_MSG_TO_CPU2_CPU1_WR_MSG_CPU2(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_IMU_CPU1_WR_MSG_TO_CPU2_CPU1_WR_MSG_CPU2_SHIFT)) & CIU2_CIU2_IMU_CPU1_WR_MSG_TO_CPU2_CPU1_WR_MSG_CPU2_MASK)
/*! @} */

/*! @name CIU2_IMU_CPU1_RD_MSG_FROM_CPU2 - CPU1 read message from CPU2 */
/*! @{ */

#define CIU2_CIU2_IMU_CPU1_RD_MSG_FROM_CPU2_CPU1_RD_MSG_CPU2_MASK (0xFFFFFFFFU)
#define CIU2_CIU2_IMU_CPU1_RD_MSG_FROM_CPU2_CPU1_RD_MSG_CPU2_SHIFT (0U)
/*! cpu1_rd_msg_cpu2 - CPU1 read message data from CPU2 (pop from FIFO)
 */
#define CIU2_CIU2_IMU_CPU1_RD_MSG_FROM_CPU2_CPU1_RD_MSG_CPU2(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_IMU_CPU1_RD_MSG_FROM_CPU2_CPU1_RD_MSG_CPU2_SHIFT)) & CIU2_CIU2_IMU_CPU1_RD_MSG_FROM_CPU2_CPU1_RD_MSG_CPU2_MASK)
/*! @} */

/*! @name CIU2_IMU_CPU1_CPU2_MSG_FIFO_STATUS - CPU1 to CPU2 message FIFO status */
/*! @{ */

#define CIU2_CIU2_IMU_CPU1_CPU2_MSG_FIFO_STATUS_CPU1_TO_CPU2_MSG_FIFO_LOCKED_MASK (0x1U)
#define CIU2_CIU2_IMU_CPU1_CPU2_MSG_FIFO_STATUS_CPU1_TO_CPU2_MSG_FIFO_LOCKED_SHIFT (0U)
/*! cpu1_to_cpu2_msg_fifo_locked - cpu1_to_cpu2_msg_fifo_locked
 */
#define CIU2_CIU2_IMU_CPU1_CPU2_MSG_FIFO_STATUS_CPU1_TO_CPU2_MSG_FIFO_LOCKED(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_IMU_CPU1_CPU2_MSG_FIFO_STATUS_CPU1_TO_CPU2_MSG_FIFO_LOCKED_SHIFT)) & CIU2_CIU2_IMU_CPU1_CPU2_MSG_FIFO_STATUS_CPU1_TO_CPU2_MSG_FIFO_LOCKED_MASK)

#define CIU2_CIU2_IMU_CPU1_CPU2_MSG_FIFO_STATUS_CPU1_TO_CPU2_MSG_FIFO_ALMOST_FULL_MASK (0x2U)
#define CIU2_CIU2_IMU_CPU1_CPU2_MSG_FIFO_STATUS_CPU1_TO_CPU2_MSG_FIFO_ALMOST_FULL_SHIFT (1U)
/*! cpu1_to_cpu2_msg_fifo_almost_full - cpu1_to_cpu2_msg_fifo_almost_full (based upon FIFO watermark)
 */
#define CIU2_CIU2_IMU_CPU1_CPU2_MSG_FIFO_STATUS_CPU1_TO_CPU2_MSG_FIFO_ALMOST_FULL(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_IMU_CPU1_CPU2_MSG_FIFO_STATUS_CPU1_TO_CPU2_MSG_FIFO_ALMOST_FULL_SHIFT)) & CIU2_CIU2_IMU_CPU1_CPU2_MSG_FIFO_STATUS_CPU1_TO_CPU2_MSG_FIFO_ALMOST_FULL_MASK)

#define CIU2_CIU2_IMU_CPU1_CPU2_MSG_FIFO_STATUS_CPU1_TO_CPU2_MSG_FIFO_FULL_MASK (0x4U)
#define CIU2_CIU2_IMU_CPU1_CPU2_MSG_FIFO_STATUS_CPU1_TO_CPU2_MSG_FIFO_FULL_SHIFT (2U)
/*! cpu1_to_cpu2_msg_fifo_full - cpu1_to_cpu2_msg_fifo_full (based upon FIFO depth)
 */
#define CIU2_CIU2_IMU_CPU1_CPU2_MSG_FIFO_STATUS_CPU1_TO_CPU2_MSG_FIFO_FULL(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_IMU_CPU1_CPU2_MSG_FIFO_STATUS_CPU1_TO_CPU2_MSG_FIFO_FULL_SHIFT)) & CIU2_CIU2_IMU_CPU1_CPU2_MSG_FIFO_STATUS_CPU1_TO_CPU2_MSG_FIFO_FULL_MASK)

#define CIU2_CIU2_IMU_CPU1_CPU2_MSG_FIFO_STATUS_CPU1_TO_CPU2_MSG_FIFO_EMPTY_MASK (0x8U)
#define CIU2_CIU2_IMU_CPU1_CPU2_MSG_FIFO_STATUS_CPU1_TO_CPU2_MSG_FIFO_EMPTY_SHIFT (3U)
/*! cpu1_to_cpu2_msg_fifo_empty - cpu1_to_cpu2_msg_fifo_empty
 */
#define CIU2_CIU2_IMU_CPU1_CPU2_MSG_FIFO_STATUS_CPU1_TO_CPU2_MSG_FIFO_EMPTY(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_IMU_CPU1_CPU2_MSG_FIFO_STATUS_CPU1_TO_CPU2_MSG_FIFO_EMPTY_SHIFT)) & CIU2_CIU2_IMU_CPU1_CPU2_MSG_FIFO_STATUS_CPU1_TO_CPU2_MSG_FIFO_EMPTY_MASK)

#define CIU2_CIU2_IMU_CPU1_CPU2_MSG_FIFO_STATUS_CPU1_TO_CPU2_MSG_COUNT_MASK (0x1F0U)
#define CIU2_CIU2_IMU_CPU1_CPU2_MSG_FIFO_STATUS_CPU1_TO_CPU2_MSG_COUNT_SHIFT (4U)
/*! cpu1_to_cpu2_msg_count - cpu1_to_cpu2_msg_count
 */
#define CIU2_CIU2_IMU_CPU1_CPU2_MSG_FIFO_STATUS_CPU1_TO_CPU2_MSG_COUNT(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_IMU_CPU1_CPU2_MSG_FIFO_STATUS_CPU1_TO_CPU2_MSG_COUNT_SHIFT)) & CIU2_CIU2_IMU_CPU1_CPU2_MSG_FIFO_STATUS_CPU1_TO_CPU2_MSG_COUNT_MASK)

#define CIU2_CIU2_IMU_CPU1_CPU2_MSG_FIFO_STATUS_CPU1_TO_CPU2_MSG_FIFO_WR_PTR_MASK (0xF0000U)
#define CIU2_CIU2_IMU_CPU1_CPU2_MSG_FIFO_STATUS_CPU1_TO_CPU2_MSG_FIFO_WR_PTR_SHIFT (16U)
/*! cpu1_to_cpu2_msg_fifo_wr_ptr - cpu1 to cpu2 msg fifo write pointer for debug
 */
#define CIU2_CIU2_IMU_CPU1_CPU2_MSG_FIFO_STATUS_CPU1_TO_CPU2_MSG_FIFO_WR_PTR(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_IMU_CPU1_CPU2_MSG_FIFO_STATUS_CPU1_TO_CPU2_MSG_FIFO_WR_PTR_SHIFT)) & CIU2_CIU2_IMU_CPU1_CPU2_MSG_FIFO_STATUS_CPU1_TO_CPU2_MSG_FIFO_WR_PTR_MASK)

#define CIU2_CIU2_IMU_CPU1_CPU2_MSG_FIFO_STATUS_CPU1_TO_CPU2_MSG_FIFO_RD_PTR_MASK (0xF00000U)
#define CIU2_CIU2_IMU_CPU1_CPU2_MSG_FIFO_STATUS_CPU1_TO_CPU2_MSG_FIFO_RD_PTR_SHIFT (20U)
/*! cpu1_to_cpu2_msg_fifo_rd_ptr - cpu1 to cpu2 msg fifo read pointer for debug
 */
#define CIU2_CIU2_IMU_CPU1_CPU2_MSG_FIFO_STATUS_CPU1_TO_CPU2_MSG_FIFO_RD_PTR(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_IMU_CPU1_CPU2_MSG_FIFO_STATUS_CPU1_TO_CPU2_MSG_FIFO_RD_PTR_SHIFT)) & CIU2_CIU2_IMU_CPU1_CPU2_MSG_FIFO_STATUS_CPU1_TO_CPU2_MSG_FIFO_RD_PTR_MASK)
/*! @} */

/*! @name CIU2_IMU_CPU1_CPU2_MSG_FIFO_CNTL - CPU1 to CPU2 message FIFO control */
/*! @{ */

#define CIU2_CIU2_IMU_CPU1_CPU2_MSG_FIFO_CNTL_CPU1_MSG_RDY_INT_CLR_MASK (0x1U)
#define CIU2_CIU2_IMU_CPU1_CPU2_MSG_FIFO_CNTL_CPU1_MSG_RDY_INT_CLR_SHIFT (0U)
/*! cpu1_msg_rdy_int_clr - Writing 1 to this bit will clear message ready interrupt to CPU1 (self clear bit)
 */
#define CIU2_CIU2_IMU_CPU1_CPU2_MSG_FIFO_CNTL_CPU1_MSG_RDY_INT_CLR(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_IMU_CPU1_CPU2_MSG_FIFO_CNTL_CPU1_MSG_RDY_INT_CLR_SHIFT)) & CIU2_CIU2_IMU_CPU1_CPU2_MSG_FIFO_CNTL_CPU1_MSG_RDY_INT_CLR_MASK)

#define CIU2_CIU2_IMU_CPU1_CPU2_MSG_FIFO_CNTL_CPU1_MSG_SP_AV_INT_CLR_MASK (0x100U)
#define CIU2_CIU2_IMU_CPU1_CPU2_MSG_FIFO_CNTL_CPU1_MSG_SP_AV_INT_CLR_SHIFT (8U)
/*! cpu1_msg_sp_av_int_clr - Writing 1 to this bit will clear message space available interrupt to CPU1 (self clear bit)
 */
#define CIU2_CIU2_IMU_CPU1_CPU2_MSG_FIFO_CNTL_CPU1_MSG_SP_AV_INT_CLR(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_IMU_CPU1_CPU2_MSG_FIFO_CNTL_CPU1_MSG_SP_AV_INT_CLR_SHIFT)) & CIU2_CIU2_IMU_CPU1_CPU2_MSG_FIFO_CNTL_CPU1_MSG_SP_AV_INT_CLR_MASK)

#define CIU2_CIU2_IMU_CPU1_CPU2_MSG_FIFO_CNTL_CPU1_TO_CPU2_MSG_FIFO_FLUSH_MASK (0x10000U)
#define CIU2_CIU2_IMU_CPU1_CPU2_MSG_FIFO_CNTL_CPU1_TO_CPU2_MSG_FIFO_FLUSH_SHIFT (16U)
/*! cpu1_to_cpu2_msg_fifo_flush - Writing 1 to this bit will flush cpu1_to_cpu2 message fifo
 */
#define CIU2_CIU2_IMU_CPU1_CPU2_MSG_FIFO_CNTL_CPU1_TO_CPU2_MSG_FIFO_FLUSH(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_IMU_CPU1_CPU2_MSG_FIFO_CNTL_CPU1_TO_CPU2_MSG_FIFO_FLUSH_SHIFT)) & CIU2_CIU2_IMU_CPU1_CPU2_MSG_FIFO_CNTL_CPU1_TO_CPU2_MSG_FIFO_FLUSH_MASK)

#define CIU2_CIU2_IMU_CPU1_CPU2_MSG_FIFO_CNTL_CPU1_WAIT_FOR_ACK_MASK (0x20000U)
#define CIU2_CIU2_IMU_CPU1_CPU2_MSG_FIFO_CNTL_CPU1_WAIT_FOR_ACK_SHIFT (17U)
#define CIU2_CIU2_IMU_CPU1_CPU2_MSG_FIFO_CNTL_CPU1_WAIT_FOR_ACK(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_IMU_CPU1_CPU2_MSG_FIFO_CNTL_CPU1_WAIT_FOR_ACK_SHIFT)) & CIU2_CIU2_IMU_CPU1_CPU2_MSG_FIFO_CNTL_CPU1_WAIT_FOR_ACK_MASK)

#define CIU2_CIU2_IMU_CPU1_CPU2_MSG_FIFO_CNTL_CPU1_CPU2_MSG_FIFO_FULL_WATERMARK_MASK (0xF00000U)
#define CIU2_CIU2_IMU_CPU1_CPU2_MSG_FIFO_CNTL_CPU1_CPU2_MSG_FIFO_FULL_WATERMARK_SHIFT (20U)
/*! cpu1_cpu2_msg_fifo_full_watermark - cpu1_to_cpu2 message fifo full watermark (space avail intr based upon it)
 */
#define CIU2_CIU2_IMU_CPU1_CPU2_MSG_FIFO_CNTL_CPU1_CPU2_MSG_FIFO_FULL_WATERMARK(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_IMU_CPU1_CPU2_MSG_FIFO_CNTL_CPU1_CPU2_MSG_FIFO_FULL_WATERMARK_SHIFT)) & CIU2_CIU2_IMU_CPU1_CPU2_MSG_FIFO_CNTL_CPU1_CPU2_MSG_FIFO_FULL_WATERMARK_MASK)
/*! @} */

/*! @name CIU2_IMU_CPU2_RD_MSG_FROM_CPU1_VAL_DBG - CPU2 last message read (from cpu1) */
/*! @{ */

#define CIU2_CIU2_IMU_CPU2_RD_MSG_FROM_CPU1_VAL_DBG_CPU2_RD_MSG_MASK (0xFFFFFFFFU)
#define CIU2_CIU2_IMU_CPU2_RD_MSG_FROM_CPU1_VAL_DBG_CPU2_RD_MSG_SHIFT (0U)
/*! cpu2_rd_msg - CPU2 last message read (from cpu1)
 */
#define CIU2_CIU2_IMU_CPU2_RD_MSG_FROM_CPU1_VAL_DBG_CPU2_RD_MSG(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_IMU_CPU2_RD_MSG_FROM_CPU1_VAL_DBG_CPU2_RD_MSG_SHIFT)) & CIU2_CIU2_IMU_CPU2_RD_MSG_FROM_CPU1_VAL_DBG_CPU2_RD_MSG_MASK)
/*! @} */

/*! @name CIU2_IMU_CPU2_WR_MSG_TO_CPU1 - CPU2 write message to CPU1 */
/*! @{ */

#define CIU2_CIU2_IMU_CPU2_WR_MSG_TO_CPU1_CPU2_WR_MSG_CPU1_MASK (0xFFFFFFFFU)
#define CIU2_CIU2_IMU_CPU2_WR_MSG_TO_CPU1_CPU2_WR_MSG_CPU1_SHIFT (0U)
/*! cpu2_wr_msg_cpu1 - Write CPU2 message data to CPU1 (push to FIFO)
 */
#define CIU2_CIU2_IMU_CPU2_WR_MSG_TO_CPU1_CPU2_WR_MSG_CPU1(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_IMU_CPU2_WR_MSG_TO_CPU1_CPU2_WR_MSG_CPU1_SHIFT)) & CIU2_CIU2_IMU_CPU2_WR_MSG_TO_CPU1_CPU2_WR_MSG_CPU1_MASK)
/*! @} */

/*! @name CIU2_IMU_CPU2_RD_MSG_FROM_CPU1 - CPU2 read message from CPU1 */
/*! @{ */

#define CIU2_CIU2_IMU_CPU2_RD_MSG_FROM_CPU1_CPU2_RD_MSG_CPU1_MASK (0xFFFFFFFFU)
#define CIU2_CIU2_IMU_CPU2_RD_MSG_FROM_CPU1_CPU2_RD_MSG_CPU1_SHIFT (0U)
/*! cpu2_rd_msg_cpu1 - CPU2 read message data from CPU1 (pop from FIFO)
 */
#define CIU2_CIU2_IMU_CPU2_RD_MSG_FROM_CPU1_CPU2_RD_MSG_CPU1(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_IMU_CPU2_RD_MSG_FROM_CPU1_CPU2_RD_MSG_CPU1_SHIFT)) & CIU2_CIU2_IMU_CPU2_RD_MSG_FROM_CPU1_CPU2_RD_MSG_CPU1_MASK)
/*! @} */

/*! @name CIU2_IMU_CPU2_CPU1_MSG_FIFO_STATUS - CPU2 to CPU1 message FIFO status */
/*! @{ */

#define CIU2_CIU2_IMU_CPU2_CPU1_MSG_FIFO_STATUS_CPU2_TO_CPU1_MSG_FIFO_LOCKED_MASK (0x1U)
#define CIU2_CIU2_IMU_CPU2_CPU1_MSG_FIFO_STATUS_CPU2_TO_CPU1_MSG_FIFO_LOCKED_SHIFT (0U)
/*! cpu2_to_cpu1_msg_fifo_locked - cpu2_to_cpu1_msg_fifo_locked
 */
#define CIU2_CIU2_IMU_CPU2_CPU1_MSG_FIFO_STATUS_CPU2_TO_CPU1_MSG_FIFO_LOCKED(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_IMU_CPU2_CPU1_MSG_FIFO_STATUS_CPU2_TO_CPU1_MSG_FIFO_LOCKED_SHIFT)) & CIU2_CIU2_IMU_CPU2_CPU1_MSG_FIFO_STATUS_CPU2_TO_CPU1_MSG_FIFO_LOCKED_MASK)

#define CIU2_CIU2_IMU_CPU2_CPU1_MSG_FIFO_STATUS_CPU2_TO_CPU1_MSG_FIFO_ALMOST_FULL_MASK (0x2U)
#define CIU2_CIU2_IMU_CPU2_CPU1_MSG_FIFO_STATUS_CPU2_TO_CPU1_MSG_FIFO_ALMOST_FULL_SHIFT (1U)
/*! cpu2_to_cpu1_msg_fifo_almost_full - cpu2_to_cpu1_msg_fifo_almost_full (based upon FIFO watermark)
 */
#define CIU2_CIU2_IMU_CPU2_CPU1_MSG_FIFO_STATUS_CPU2_TO_CPU1_MSG_FIFO_ALMOST_FULL(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_IMU_CPU2_CPU1_MSG_FIFO_STATUS_CPU2_TO_CPU1_MSG_FIFO_ALMOST_FULL_SHIFT)) & CIU2_CIU2_IMU_CPU2_CPU1_MSG_FIFO_STATUS_CPU2_TO_CPU1_MSG_FIFO_ALMOST_FULL_MASK)

#define CIU2_CIU2_IMU_CPU2_CPU1_MSG_FIFO_STATUS_CPU2_TO_CPU1_MSG_FIFO_FULL_MASK (0x4U)
#define CIU2_CIU2_IMU_CPU2_CPU1_MSG_FIFO_STATUS_CPU2_TO_CPU1_MSG_FIFO_FULL_SHIFT (2U)
/*! cpu2_to_cpu1_msg_fifo_full - cpu2_to_cpu1_msg_fifo_full (based upon FIFO depth)
 */
#define CIU2_CIU2_IMU_CPU2_CPU1_MSG_FIFO_STATUS_CPU2_TO_CPU1_MSG_FIFO_FULL(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_IMU_CPU2_CPU1_MSG_FIFO_STATUS_CPU2_TO_CPU1_MSG_FIFO_FULL_SHIFT)) & CIU2_CIU2_IMU_CPU2_CPU1_MSG_FIFO_STATUS_CPU2_TO_CPU1_MSG_FIFO_FULL_MASK)

#define CIU2_CIU2_IMU_CPU2_CPU1_MSG_FIFO_STATUS_CPU2_TO_CPU1_MSG_FIFO_EMPTY_MASK (0x8U)
#define CIU2_CIU2_IMU_CPU2_CPU1_MSG_FIFO_STATUS_CPU2_TO_CPU1_MSG_FIFO_EMPTY_SHIFT (3U)
/*! cpu2_to_cpu1_msg_fifo_empty - cpu2_to_cpu1_msg_fifo_empty
 */
#define CIU2_CIU2_IMU_CPU2_CPU1_MSG_FIFO_STATUS_CPU2_TO_CPU1_MSG_FIFO_EMPTY(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_IMU_CPU2_CPU1_MSG_FIFO_STATUS_CPU2_TO_CPU1_MSG_FIFO_EMPTY_SHIFT)) & CIU2_CIU2_IMU_CPU2_CPU1_MSG_FIFO_STATUS_CPU2_TO_CPU1_MSG_FIFO_EMPTY_MASK)

#define CIU2_CIU2_IMU_CPU2_CPU1_MSG_FIFO_STATUS_CPU2_TO_CPU1_MSG_COUNT_MASK (0x1F0U)
#define CIU2_CIU2_IMU_CPU2_CPU1_MSG_FIFO_STATUS_CPU2_TO_CPU1_MSG_COUNT_SHIFT (4U)
/*! cpu2_to_cpu1_msg_count - cpu2_to_cpu1_msg_count
 */
#define CIU2_CIU2_IMU_CPU2_CPU1_MSG_FIFO_STATUS_CPU2_TO_CPU1_MSG_COUNT(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_IMU_CPU2_CPU1_MSG_FIFO_STATUS_CPU2_TO_CPU1_MSG_COUNT_SHIFT)) & CIU2_CIU2_IMU_CPU2_CPU1_MSG_FIFO_STATUS_CPU2_TO_CPU1_MSG_COUNT_MASK)

#define CIU2_CIU2_IMU_CPU2_CPU1_MSG_FIFO_STATUS_CPU2_TO_CPU1_MSG_FIFO_WR_PTR_MASK (0xF0000U)
#define CIU2_CIU2_IMU_CPU2_CPU1_MSG_FIFO_STATUS_CPU2_TO_CPU1_MSG_FIFO_WR_PTR_SHIFT (16U)
/*! cpu2_to_cpu1_msg_fifo_wr_ptr - cpu1 to cpu2 msg fifo write pointer for debug
 */
#define CIU2_CIU2_IMU_CPU2_CPU1_MSG_FIFO_STATUS_CPU2_TO_CPU1_MSG_FIFO_WR_PTR(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_IMU_CPU2_CPU1_MSG_FIFO_STATUS_CPU2_TO_CPU1_MSG_FIFO_WR_PTR_SHIFT)) & CIU2_CIU2_IMU_CPU2_CPU1_MSG_FIFO_STATUS_CPU2_TO_CPU1_MSG_FIFO_WR_PTR_MASK)

#define CIU2_CIU2_IMU_CPU2_CPU1_MSG_FIFO_STATUS_CPU2_TO_CPU1_MSG_FIFO_RD_PTR_MASK (0xF00000U)
#define CIU2_CIU2_IMU_CPU2_CPU1_MSG_FIFO_STATUS_CPU2_TO_CPU1_MSG_FIFO_RD_PTR_SHIFT (20U)
/*! cpu2_to_cpu1_msg_fifo_rd_ptr - cpu1 to cpu2 msg fifo read pointer for debug
 */
#define CIU2_CIU2_IMU_CPU2_CPU1_MSG_FIFO_STATUS_CPU2_TO_CPU1_MSG_FIFO_RD_PTR(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_IMU_CPU2_CPU1_MSG_FIFO_STATUS_CPU2_TO_CPU1_MSG_FIFO_RD_PTR_SHIFT)) & CIU2_CIU2_IMU_CPU2_CPU1_MSG_FIFO_STATUS_CPU2_TO_CPU1_MSG_FIFO_RD_PTR_MASK)
/*! @} */

/*! @name CIU2_IMU_CPU2_CPU1_MSG_FIFO_CNTL - CPU2 to CPU1 message FIFO control */
/*! @{ */

#define CIU2_CIU2_IMU_CPU2_CPU1_MSG_FIFO_CNTL_CPU2_MSG_RDY_INT_CLR_MASK (0x1U)
#define CIU2_CIU2_IMU_CPU2_CPU1_MSG_FIFO_CNTL_CPU2_MSG_RDY_INT_CLR_SHIFT (0U)
/*! cpu2_msg_rdy_int_clr - Writing 1 to this bit will clear message ready interrupt to CPU2 (self clear bit)
 */
#define CIU2_CIU2_IMU_CPU2_CPU1_MSG_FIFO_CNTL_CPU2_MSG_RDY_INT_CLR(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_IMU_CPU2_CPU1_MSG_FIFO_CNTL_CPU2_MSG_RDY_INT_CLR_SHIFT)) & CIU2_CIU2_IMU_CPU2_CPU1_MSG_FIFO_CNTL_CPU2_MSG_RDY_INT_CLR_MASK)

#define CIU2_CIU2_IMU_CPU2_CPU1_MSG_FIFO_CNTL_CPU2_MSG_SP_AV_INT_CLR_MASK (0x100U)
#define CIU2_CIU2_IMU_CPU2_CPU1_MSG_FIFO_CNTL_CPU2_MSG_SP_AV_INT_CLR_SHIFT (8U)
/*! cpu2_msg_sp_av_int_clr - Writing 1 to this bit will clear message space available interrupt to CPU2 (self clear bit)
 */
#define CIU2_CIU2_IMU_CPU2_CPU1_MSG_FIFO_CNTL_CPU2_MSG_SP_AV_INT_CLR(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_IMU_CPU2_CPU1_MSG_FIFO_CNTL_CPU2_MSG_SP_AV_INT_CLR_SHIFT)) & CIU2_CIU2_IMU_CPU2_CPU1_MSG_FIFO_CNTL_CPU2_MSG_SP_AV_INT_CLR_MASK)

#define CIU2_CIU2_IMU_CPU2_CPU1_MSG_FIFO_CNTL_CPU2_TO_CPU1_MSG_FIFO_FLUSH_MASK (0x10000U)
#define CIU2_CIU2_IMU_CPU2_CPU1_MSG_FIFO_CNTL_CPU2_TO_CPU1_MSG_FIFO_FLUSH_SHIFT (16U)
/*! cpu2_to_cpu1_msg_fifo_flush - Writing 1 to this bit will flush cpu2_to_cpu1 message fifo
 */
#define CIU2_CIU2_IMU_CPU2_CPU1_MSG_FIFO_CNTL_CPU2_TO_CPU1_MSG_FIFO_FLUSH(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_IMU_CPU2_CPU1_MSG_FIFO_CNTL_CPU2_TO_CPU1_MSG_FIFO_FLUSH_SHIFT)) & CIU2_CIU2_IMU_CPU2_CPU1_MSG_FIFO_CNTL_CPU2_TO_CPU1_MSG_FIFO_FLUSH_MASK)

#define CIU2_CIU2_IMU_CPU2_CPU1_MSG_FIFO_CNTL_CPU2_WAIT_FOR_ACK_MASK (0x20000U)
#define CIU2_CIU2_IMU_CPU2_CPU1_MSG_FIFO_CNTL_CPU2_WAIT_FOR_ACK_SHIFT (17U)
#define CIU2_CIU2_IMU_CPU2_CPU1_MSG_FIFO_CNTL_CPU2_WAIT_FOR_ACK(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_IMU_CPU2_CPU1_MSG_FIFO_CNTL_CPU2_WAIT_FOR_ACK_SHIFT)) & CIU2_CIU2_IMU_CPU2_CPU1_MSG_FIFO_CNTL_CPU2_WAIT_FOR_ACK_MASK)

#define CIU2_CIU2_IMU_CPU2_CPU1_MSG_FIFO_CNTL_CPU2_CPU1_MSG_FIFO_FULL_WATERMARK_MASK (0xF00000U)
#define CIU2_CIU2_IMU_CPU2_CPU1_MSG_FIFO_CNTL_CPU2_CPU1_MSG_FIFO_FULL_WATERMARK_SHIFT (20U)
/*! cpu2_cpu1_msg_fifo_full_watermark - cpu2_to_cpu1 message fifo full watermark (space avail intr based upon it)
 */
#define CIU2_CIU2_IMU_CPU2_CPU1_MSG_FIFO_CNTL_CPU2_CPU1_MSG_FIFO_FULL_WATERMARK(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_IMU_CPU2_CPU1_MSG_FIFO_CNTL_CPU2_CPU1_MSG_FIFO_FULL_WATERMARK_SHIFT)) & CIU2_CIU2_IMU_CPU2_CPU1_MSG_FIFO_CNTL_CPU2_CPU1_MSG_FIFO_FULL_WATERMARK_MASK)
/*! @} */

/*! @name CIU2_IMU_CPU1_RD_MSG_FROM_CPU2_VAL_DBG - CPU1 last message read (from cpu2) */
/*! @{ */

#define CIU2_CIU2_IMU_CPU1_RD_MSG_FROM_CPU2_VAL_DBG_CPU1_RD_MSG_MASK (0xFFFFFFFFU)
#define CIU2_CIU2_IMU_CPU1_RD_MSG_FROM_CPU2_VAL_DBG_CPU1_RD_MSG_SHIFT (0U)
/*! cpu1_rd_msg - CPU1 last message read (from cpu2)
 */
#define CIU2_CIU2_IMU_CPU1_RD_MSG_FROM_CPU2_VAL_DBG_CPU1_RD_MSG(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_IMU_CPU1_RD_MSG_FROM_CPU2_VAL_DBG_CPU1_RD_MSG_SHIFT)) & CIU2_CIU2_IMU_CPU1_RD_MSG_FROM_CPU2_VAL_DBG_CPU1_RD_MSG_MASK)
/*! @} */

/*! @name CIU2_BCA1_CPU2_INT_MASK - BCA1 to CPU2 Interrupt Mask */
/*! @{ */

#define CIU2_CIU2_BCA1_CPU2_INT_MASK_IMR_MASK    (0xFFFFFFFFU)
#define CIU2_CIU2_BCA1_CPU2_INT_MASK_IMR_SHIFT   (0U)
/*! imr - Interrupt Mask for BCA1 to CPU2 Interrupts
 */
#define CIU2_CIU2_BCA1_CPU2_INT_MASK_IMR(x)      (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_BCA1_CPU2_INT_MASK_IMR_SHIFT)) & CIU2_CIU2_BCA1_CPU2_INT_MASK_IMR_MASK)
/*! @} */

/*! @name CIU2_BCA1_CPU2_INT_SELECT - BCA1 to CPU2 Interrupt Select */
/*! @{ */

#define CIU2_CIU2_BCA1_CPU2_INT_SELECT_RSR_MASK  (0xFFFFFFFFU)
#define CIU2_CIU2_BCA1_CPU2_INT_SELECT_RSR_SHIFT (0U)
/*! rsr - Interrupt Read/Write Clear for BCA1 to CPU2 Interrupts
 */
#define CIU2_CIU2_BCA1_CPU2_INT_SELECT_RSR(x)    (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_BCA1_CPU2_INT_SELECT_RSR_SHIFT)) & CIU2_CIU2_BCA1_CPU2_INT_SELECT_RSR_MASK)
/*! @} */

/*! @name CIU2_BCA1_CPU2_INT_EVENT_MASK - BCA1 to CPU2 Interrupt Event Mask */
/*! @{ */

#define CIU2_CIU2_BCA1_CPU2_INT_EVENT_MASK_SMR_MASK (0xFFFFFFFFU)
#define CIU2_CIU2_BCA1_CPU2_INT_EVENT_MASK_SMR_SHIFT (0U)
/*! smr - Interrupt Event Mask for BCA1 to CPU2 Interrupts
 */
#define CIU2_CIU2_BCA1_CPU2_INT_EVENT_MASK_SMR(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_BCA1_CPU2_INT_EVENT_MASK_SMR_SHIFT)) & CIU2_CIU2_BCA1_CPU2_INT_EVENT_MASK_SMR_MASK)
/*! @} */

/*! @name CIU2_BCA1_CPU2_INT_STATUS - BCA1 to CPU2 Interrupt Status */
/*! @{ */

#define CIU2_CIU2_BCA1_CPU2_INT_STATUS_ISR_MASK  (0xFFFFFFFFU)
#define CIU2_CIU2_BCA1_CPU2_INT_STATUS_ISR_SHIFT (0U)
/*! isr - BCA1 to CPU2 Interrupt Status
 */
#define CIU2_CIU2_BCA1_CPU2_INT_STATUS_ISR(x)    (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_BCA1_CPU2_INT_STATUS_ISR_SHIFT)) & CIU2_CIU2_BCA1_CPU2_INT_STATUS_ISR_MASK)
/*! @} */

/*! @name CIU2_APU_BYPASS1 - CIU2 APU Bypass Register 1 */
/*! @{ */

#define CIU2_CIU2_APU_BYPASS1_BRF_CLK_EN_BYPASS_EN_MASK (0x1U)
#define CIU2_CIU2_APU_BYPASS1_BRF_CLK_EN_BYPASS_EN_SHIFT (0U)
/*! brf_clk_en_bypass_en - Firmware Bypass BRF_Clk_En
 */
#define CIU2_CIU2_APU_BYPASS1_BRF_CLK_EN_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_APU_BYPASS1_BRF_CLK_EN_BYPASS_EN_SHIFT)) & CIU2_CIU2_APU_BYPASS1_BRF_CLK_EN_BYPASS_EN_MASK)

#define CIU2_CIU2_APU_BYPASS1_BRF_CLK_EN_BYPASS_VAL_MASK (0x2U)
#define CIU2_CIU2_APU_BYPASS1_BRF_CLK_EN_BYPASS_VAL_SHIFT (1U)
/*! brf_clk_en_bypass_val - Firmware Bypass Value for BRF_Clk_En (active high signal)
 */
#define CIU2_CIU2_APU_BYPASS1_BRF_CLK_EN_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_APU_BYPASS1_BRF_CLK_EN_BYPASS_VAL_SHIFT)) & CIU2_CIU2_APU_BYPASS1_BRF_CLK_EN_BYPASS_VAL_MASK)

#define CIU2_CIU2_APU_BYPASS1_BT_AES_CLK_EN_BYPASS_EN_MASK (0x4U)
#define CIU2_CIU2_APU_BYPASS1_BT_AES_CLK_EN_BYPASS_EN_SHIFT (2U)
/*! bt_aes_clk_en_bypass_en - Firmware Bypass for Btu_Aes_Clk
 */
#define CIU2_CIU2_APU_BYPASS1_BT_AES_CLK_EN_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_APU_BYPASS1_BT_AES_CLK_EN_BYPASS_EN_SHIFT)) & CIU2_CIU2_APU_BYPASS1_BT_AES_CLK_EN_BYPASS_EN_MASK)

#define CIU2_CIU2_APU_BYPASS1_BT_AES_CLK_EN_BYPASS_VAL_MASK (0x8U)
#define CIU2_CIU2_APU_BYPASS1_BT_AES_CLK_EN_BYPASS_VAL_SHIFT (3U)
/*! bt_aes_clk_en_bypass_val - Firmware Bypass Value for Btu_Aes_Clk
 */
#define CIU2_CIU2_APU_BYPASS1_BT_AES_CLK_EN_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_APU_BYPASS1_BT_AES_CLK_EN_BYPASS_VAL_SHIFT)) & CIU2_CIU2_APU_BYPASS1_BT_AES_CLK_EN_BYPASS_VAL_MASK)

#define CIU2_CIU2_APU_BYPASS1_SOC_CLK_EN2_T1_BYPASS_EN_MASK (0x10U)
#define CIU2_CIU2_APU_BYPASS1_SOC_CLK_EN2_T1_BYPASS_EN_SHIFT (4U)
/*! soc_clk_en2_T1_bypass_en - Firmware Bypass for SoC_Clk_En2
 */
#define CIU2_CIU2_APU_BYPASS1_SOC_CLK_EN2_T1_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_APU_BYPASS1_SOC_CLK_EN2_T1_BYPASS_EN_SHIFT)) & CIU2_CIU2_APU_BYPASS1_SOC_CLK_EN2_T1_BYPASS_EN_MASK)

#define CIU2_CIU2_APU_BYPASS1_SOC_CLK_EN2_T1_BYPASS_VAL_MASK (0x20U)
#define CIU2_CIU2_APU_BYPASS1_SOC_CLK_EN2_T1_BYPASS_VAL_SHIFT (5U)
/*! soc_clk_en2_T1_bypass_val - Firmware Bypass Value for SoC_Clk_En2(active high signal)
 */
#define CIU2_CIU2_APU_BYPASS1_SOC_CLK_EN2_T1_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_APU_BYPASS1_SOC_CLK_EN2_T1_BYPASS_VAL_SHIFT)) & CIU2_CIU2_APU_BYPASS1_SOC_CLK_EN2_T1_BYPASS_VAL_MASK)

#define CIU2_CIU2_APU_BYPASS1_TBG_BTU_CLK_EN_BYPASS_SEL_MASK (0xC0U)
#define CIU2_CIU2_APU_BYPASS1_TBG_BTU_CLK_EN_BYPASS_SEL_SHIFT (6U)
/*! tbg_btu_clk_en_bypass_sel - TBG512_320_176_BTU_Clk_En_Sel to TBG512_320_176 of CAU
 */
#define CIU2_CIU2_APU_BYPASS1_TBG_BTU_CLK_EN_BYPASS_SEL(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_APU_BYPASS1_TBG_BTU_CLK_EN_BYPASS_SEL_SHIFT)) & CIU2_CIU2_APU_BYPASS1_TBG_BTU_CLK_EN_BYPASS_SEL_MASK)

#define CIU2_CIU2_APU_BYPASS1_BT_AES_CLK_SEL_BYPASS_EN_MASK (0x100U)
#define CIU2_CIU2_APU_BYPASS1_BT_AES_CLK_SEL_BYPASS_EN_SHIFT (8U)
/*! bt_aes_clk_sel_bypass_en - Firmware Bypass for Btu_Aes_Clk_Sel
 */
#define CIU2_CIU2_APU_BYPASS1_BT_AES_CLK_SEL_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_APU_BYPASS1_BT_AES_CLK_SEL_BYPASS_EN_SHIFT)) & CIU2_CIU2_APU_BYPASS1_BT_AES_CLK_SEL_BYPASS_EN_MASK)

#define CIU2_CIU2_APU_BYPASS1_BT_AES_CLK_SEL_BYPASS_VAL_MASK (0x200U)
#define CIU2_CIU2_APU_BYPASS1_BT_AES_CLK_SEL_BYPASS_VAL_SHIFT (9U)
/*! bt_aes_clk_sel_bypass_val - Firmware Bypass Value for Btu_Aes_Clk_Sel
 */
#define CIU2_CIU2_APU_BYPASS1_BT_AES_CLK_SEL_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_APU_BYPASS1_BT_AES_CLK_SEL_BYPASS_VAL_SHIFT)) & CIU2_CIU2_APU_BYPASS1_BT_AES_CLK_SEL_BYPASS_VAL_MASK)

#define CIU2_CIU2_APU_BYPASS1_TBG_BTU_CLK_EN_BYPASS_VAL_MASK (0x400U)
#define CIU2_CIU2_APU_BYPASS1_TBG_BTU_CLK_EN_BYPASS_VAL_SHIFT (10U)
/*! tbg_btu_clk_en_bypass_val - TBG512_320_176_BTU_Clk_En Bypass Value
 */
#define CIU2_CIU2_APU_BYPASS1_TBG_BTU_CLK_EN_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_APU_BYPASS1_TBG_BTU_CLK_EN_BYPASS_VAL_SHIFT)) & CIU2_CIU2_APU_BYPASS1_TBG_BTU_CLK_EN_BYPASS_VAL_MASK)
/*! @} */

/*! @name CIU2_CPU2_LMU_STA_BYPASS0 - LMU static bank control byapss0 Register for CPU2 mem */
/*! @{ */

#define CIU2_CIU2_CPU2_LMU_STA_BYPASS0_LMU_STA_BANKS_ISO_EN_BP_EN_MASK (0xFFU)
#define CIU2_CIU2_CPU2_LMU_STA_BYPASS0_LMU_STA_BANKS_ISO_EN_BP_EN_SHIFT (0U)
/*! lmu_sta_banks_iso_en_bp_en - Firmware Bypass enable for lmu static banks iso_en
 */
#define CIU2_CIU2_CPU2_LMU_STA_BYPASS0_LMU_STA_BANKS_ISO_EN_BP_EN(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CPU2_LMU_STA_BYPASS0_LMU_STA_BANKS_ISO_EN_BP_EN_SHIFT)) & CIU2_CIU2_CPU2_LMU_STA_BYPASS0_LMU_STA_BANKS_ISO_EN_BP_EN_MASK)

#define CIU2_CIU2_CPU2_LMU_STA_BYPASS0_LMU_STA_BANKS_ISO_EN_BP_VAL_MASK (0xFF00U)
#define CIU2_CIU2_CPU2_LMU_STA_BYPASS0_LMU_STA_BANKS_ISO_EN_BP_VAL_SHIFT (8U)
/*! lmu_sta_banks_iso_en_bp_val - Firmware Bypass value for lmu static banks iso_en
 */
#define CIU2_CIU2_CPU2_LMU_STA_BYPASS0_LMU_STA_BANKS_ISO_EN_BP_VAL(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CPU2_LMU_STA_BYPASS0_LMU_STA_BANKS_ISO_EN_BP_VAL_SHIFT)) & CIU2_CIU2_CPU2_LMU_STA_BYPASS0_LMU_STA_BANKS_ISO_EN_BP_VAL_MASK)

#define CIU2_CIU2_CPU2_LMU_STA_BYPASS0_LMU_STA_BANKS_PSW_EN_BP_EN_MASK (0xFF0000U)
#define CIU2_CIU2_CPU2_LMU_STA_BYPASS0_LMU_STA_BANKS_PSW_EN_BP_EN_SHIFT (16U)
/*! lmu_sta_banks_psw_en_bp_en - Firmware Bypass enable for lmu static banks psw_en
 */
#define CIU2_CIU2_CPU2_LMU_STA_BYPASS0_LMU_STA_BANKS_PSW_EN_BP_EN(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CPU2_LMU_STA_BYPASS0_LMU_STA_BANKS_PSW_EN_BP_EN_SHIFT)) & CIU2_CIU2_CPU2_LMU_STA_BYPASS0_LMU_STA_BANKS_PSW_EN_BP_EN_MASK)

#define CIU2_CIU2_CPU2_LMU_STA_BYPASS0_LMU_STA_BANKS_PSW_EN_BP_VAL_MASK (0xFF000000U)
#define CIU2_CIU2_CPU2_LMU_STA_BYPASS0_LMU_STA_BANKS_PSW_EN_BP_VAL_SHIFT (24U)
/*! lmu_sta_banks_psw_en_bp_val - Firmware Bypass value for lmu static banks psw_en
 */
#define CIU2_CIU2_CPU2_LMU_STA_BYPASS0_LMU_STA_BANKS_PSW_EN_BP_VAL(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CPU2_LMU_STA_BYPASS0_LMU_STA_BANKS_PSW_EN_BP_VAL_SHIFT)) & CIU2_CIU2_CPU2_LMU_STA_BYPASS0_LMU_STA_BANKS_PSW_EN_BP_VAL_MASK)
/*! @} */

/*! @name CIU2_CPU2_LMU_STA_BYPASS1 - LMU static bank control byapss1 Register for CPU2 */
/*! @{ */

#define CIU2_CIU2_CPU2_LMU_STA_BYPASS1_LMU_STA_BANKS_SRAM_PD_BP_EN_MASK (0xFFU)
#define CIU2_CIU2_CPU2_LMU_STA_BYPASS1_LMU_STA_BANKS_SRAM_PD_BP_EN_SHIFT (0U)
/*! lmu_sta_banks_sram_pd_bp_en - Firmware Bypass enable for lmu static banks sram_pd
 */
#define CIU2_CIU2_CPU2_LMU_STA_BYPASS1_LMU_STA_BANKS_SRAM_PD_BP_EN(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CPU2_LMU_STA_BYPASS1_LMU_STA_BANKS_SRAM_PD_BP_EN_SHIFT)) & CIU2_CIU2_CPU2_LMU_STA_BYPASS1_LMU_STA_BANKS_SRAM_PD_BP_EN_MASK)

#define CIU2_CIU2_CPU2_LMU_STA_BYPASS1_LMU_STA_BANKS_SRAM_PD_BP_VAL_MASK (0xFF00U)
#define CIU2_CIU2_CPU2_LMU_STA_BYPASS1_LMU_STA_BANKS_SRAM_PD_BP_VAL_SHIFT (8U)
/*! lmu_sta_banks_sram_pd_bp_val - Firmware Bypass value for lmu static banks sram_pd
 */
#define CIU2_CIU2_CPU2_LMU_STA_BYPASS1_LMU_STA_BANKS_SRAM_PD_BP_VAL(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CPU2_LMU_STA_BYPASS1_LMU_STA_BANKS_SRAM_PD_BP_VAL_SHIFT)) & CIU2_CIU2_CPU2_LMU_STA_BYPASS1_LMU_STA_BANKS_SRAM_PD_BP_VAL_MASK)

#define CIU2_CIU2_CPU2_LMU_STA_BYPASS1_LMU_STA_BANKS_FNRST_BP_EN_MASK (0xFF0000U)
#define CIU2_CIU2_CPU2_LMU_STA_BYPASS1_LMU_STA_BANKS_FNRST_BP_EN_SHIFT (16U)
/*! lmu_sta_banks_fnrst_bp_en - Firmware Bypass enable for lmu static banks fnrst
 */
#define CIU2_CIU2_CPU2_LMU_STA_BYPASS1_LMU_STA_BANKS_FNRST_BP_EN(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CPU2_LMU_STA_BYPASS1_LMU_STA_BANKS_FNRST_BP_EN_SHIFT)) & CIU2_CIU2_CPU2_LMU_STA_BYPASS1_LMU_STA_BANKS_FNRST_BP_EN_MASK)

#define CIU2_CIU2_CPU2_LMU_STA_BYPASS1_LMU_STA_BANKS_FNRST_BP_VAL_MASK (0xFF000000U)
#define CIU2_CIU2_CPU2_LMU_STA_BYPASS1_LMU_STA_BANKS_FNRST_BP_VAL_SHIFT (24U)
/*! lmu_sta_banks_fnrst_bp_val - Firmware Bypass value for lmu static banks fnrst
 */
#define CIU2_CIU2_CPU2_LMU_STA_BYPASS1_LMU_STA_BANKS_FNRST_BP_VAL(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CPU2_LMU_STA_BYPASS1_LMU_STA_BANKS_FNRST_BP_VAL_SHIFT)) & CIU2_CIU2_CPU2_LMU_STA_BYPASS1_LMU_STA_BANKS_FNRST_BP_VAL_MASK)
/*! @} */

/*! @name CIU2_CPU2_LMU_STA_BYPASS2 - LMU static bank byapss2 Register for CPU2 */
/*! @{ */

#define CIU2_CIU2_CPU2_LMU_STA_BYPASS2_LMU_STA_BANKS_VDDMC_SW_PD_CTRL_BP_EN_MASK (0xFFU)
#define CIU2_CIU2_CPU2_LMU_STA_BYPASS2_LMU_STA_BANKS_VDDMC_SW_PD_CTRL_BP_EN_SHIFT (0U)
/*! lmu_sta_banks_vddmc_sw_pd_ctrl_bp_en - Firmware Bypass enable for lmu static banks vddmc_sw_pd_ctrl
 */
#define CIU2_CIU2_CPU2_LMU_STA_BYPASS2_LMU_STA_BANKS_VDDMC_SW_PD_CTRL_BP_EN(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CPU2_LMU_STA_BYPASS2_LMU_STA_BANKS_VDDMC_SW_PD_CTRL_BP_EN_SHIFT)) & CIU2_CIU2_CPU2_LMU_STA_BYPASS2_LMU_STA_BANKS_VDDMC_SW_PD_CTRL_BP_EN_MASK)

#define CIU2_CIU2_CPU2_LMU_STA_BYPASS2_LMU_STA_BANKS_VDDMC_SW_PD_CTRL_BP_VAL_MASK (0xFF00U)
#define CIU2_CIU2_CPU2_LMU_STA_BYPASS2_LMU_STA_BANKS_VDDMC_SW_PD_CTRL_BP_VAL_SHIFT (8U)
/*! lmu_sta_banks_vddmc_sw_pd_ctrl_bp_val - Firmware Bypass value for lmu static banks vddmc_sw_pd_ctrl
 */
#define CIU2_CIU2_CPU2_LMU_STA_BYPASS2_LMU_STA_BANKS_VDDMC_SW_PD_CTRL_BP_VAL(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CPU2_LMU_STA_BYPASS2_LMU_STA_BANKS_VDDMC_SW_PD_CTRL_BP_VAL_SHIFT)) & CIU2_CIU2_CPU2_LMU_STA_BYPASS2_LMU_STA_BANKS_VDDMC_SW_PD_CTRL_BP_VAL_MASK)
/*! @} */

/*! @name CIU2_CPU2_LMU_G2BIST_CTRL_BYPASS - LMU G2Bist control byapss Register for CPU2 */
/*! @{ */

#define CIU2_CIU2_CPU2_LMU_G2BIST_CTRL_BYPASS_LMU_CPU2_STA_PWRDMN_RPR_REQ_BP_EN_MASK (0x1U)
#define CIU2_CIU2_CPU2_LMU_G2BIST_CTRL_BYPASS_LMU_CPU2_STA_PWRDMN_RPR_REQ_BP_EN_SHIFT (0U)
/*! lmu_cpu2_sta_pwrdmn_rpr_req_bp_en - Firmware Bypass enable for CPU2 static banks lmu powerdomain repair request
 */
#define CIU2_CIU2_CPU2_LMU_G2BIST_CTRL_BYPASS_LMU_CPU2_STA_PWRDMN_RPR_REQ_BP_EN(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CPU2_LMU_G2BIST_CTRL_BYPASS_LMU_CPU2_STA_PWRDMN_RPR_REQ_BP_EN_SHIFT)) & CIU2_CIU2_CPU2_LMU_G2BIST_CTRL_BYPASS_LMU_CPU2_STA_PWRDMN_RPR_REQ_BP_EN_MASK)

#define CIU2_CIU2_CPU2_LMU_G2BIST_CTRL_BYPASS_LMU_CPU2_STA_PWRDMN_RPR_REQ_BP_VAL_MASK (0xFEU)
#define CIU2_CIU2_CPU2_LMU_G2BIST_CTRL_BYPASS_LMU_CPU2_STA_PWRDMN_RPR_REQ_BP_VAL_SHIFT (1U)
/*! lmu_cpu2_sta_pwrdmn_rpr_req_bp_val - Firmware Bypass value for CPU2 static banks lmu powerdomain repair request
 */
#define CIU2_CIU2_CPU2_LMU_G2BIST_CTRL_BYPASS_LMU_CPU2_STA_PWRDMN_RPR_REQ_BP_VAL(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CPU2_LMU_G2BIST_CTRL_BYPASS_LMU_CPU2_STA_PWRDMN_RPR_REQ_BP_VAL_SHIFT)) & CIU2_CIU2_CPU2_LMU_G2BIST_CTRL_BYPASS_LMU_CPU2_STA_PWRDMN_RPR_REQ_BP_VAL_MASK)
/*! @} */

/*! @name CIU2_APU_PWR_CTRL_BYPASS1 - APU power control Bypass Register 1 */
/*! @{ */

#define CIU2_CIU2_APU_PWR_CTRL_BYPASS1_BRF_PSW_BYPASS_VAL_MASK (0x1U)
#define CIU2_CIU2_APU_PWR_CTRL_BYPASS1_BRF_PSW_BYPASS_VAL_SHIFT (0U)
/*! brf_psw_bypass_val - brf Power Switch Control
 */
#define CIU2_CIU2_APU_PWR_CTRL_BYPASS1_BRF_PSW_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_APU_PWR_CTRL_BYPASS1_BRF_PSW_BYPASS_VAL_SHIFT)) & CIU2_CIU2_APU_PWR_CTRL_BYPASS1_BRF_PSW_BYPASS_VAL_MASK)

#define CIU2_CIU2_APU_PWR_CTRL_BYPASS1_BRF_PSW_BYPASS_EN_MASK (0x2U)
#define CIU2_CIU2_APU_PWR_CTRL_BYPASS1_BRF_PSW_BYPASS_EN_SHIFT (1U)
/*! brf_psw_bypass_en - brf Power Switch Control Enable
 */
#define CIU2_CIU2_APU_PWR_CTRL_BYPASS1_BRF_PSW_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_APU_PWR_CTRL_BYPASS1_BRF_PSW_BYPASS_EN_SHIFT)) & CIU2_CIU2_APU_PWR_CTRL_BYPASS1_BRF_PSW_BYPASS_EN_MASK)

#define CIU2_CIU2_APU_PWR_CTRL_BYPASS1_BRF_FWBAR_BYPASS_VAL_MASK (0x4U)
#define CIU2_CIU2_APU_PWR_CTRL_BYPASS1_BRF_FWBAR_BYPASS_VAL_SHIFT (2U)
/*! brf_fwbar_bypass_val - brf Firewallbar Control
 */
#define CIU2_CIU2_APU_PWR_CTRL_BYPASS1_BRF_FWBAR_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_APU_PWR_CTRL_BYPASS1_BRF_FWBAR_BYPASS_VAL_SHIFT)) & CIU2_CIU2_APU_PWR_CTRL_BYPASS1_BRF_FWBAR_BYPASS_VAL_MASK)

#define CIU2_CIU2_APU_PWR_CTRL_BYPASS1_BRF_FWBAR_BYPASS_EN_MASK (0x8U)
#define CIU2_CIU2_APU_PWR_CTRL_BYPASS1_BRF_FWBAR_BYPASS_EN_SHIFT (3U)
/*! brf_fwbar_bypass_en - brf Firewallbar Control Enable
 */
#define CIU2_CIU2_APU_PWR_CTRL_BYPASS1_BRF_FWBAR_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_APU_PWR_CTRL_BYPASS1_BRF_FWBAR_BYPASS_EN_SHIFT)) & CIU2_CIU2_APU_PWR_CTRL_BYPASS1_BRF_FWBAR_BYPASS_EN_MASK)

#define CIU2_CIU2_APU_PWR_CTRL_BYPASS1_BRF_ISO_EN_BYPASS_VAL_MASK (0x10U)
#define CIU2_CIU2_APU_PWR_CTRL_BYPASS1_BRF_ISO_EN_BYPASS_VAL_SHIFT (4U)
/*! brf_iso_en_bypass_val - brf Isolation Cell Control
 */
#define CIU2_CIU2_APU_PWR_CTRL_BYPASS1_BRF_ISO_EN_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_APU_PWR_CTRL_BYPASS1_BRF_ISO_EN_BYPASS_VAL_SHIFT)) & CIU2_CIU2_APU_PWR_CTRL_BYPASS1_BRF_ISO_EN_BYPASS_VAL_MASK)

#define CIU2_CIU2_APU_PWR_CTRL_BYPASS1_BRF_ISO_EN_BYPASS_EN_MASK (0x20U)
#define CIU2_CIU2_APU_PWR_CTRL_BYPASS1_BRF_ISO_EN_BYPASS_EN_SHIFT (5U)
/*! brf_iso_en_bypass_en - brf Isolation Cell Control Enable
 */
#define CIU2_CIU2_APU_PWR_CTRL_BYPASS1_BRF_ISO_EN_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_APU_PWR_CTRL_BYPASS1_BRF_ISO_EN_BYPASS_EN_SHIFT)) & CIU2_CIU2_APU_PWR_CTRL_BYPASS1_BRF_ISO_EN_BYPASS_EN_MASK)

#define CIU2_CIU2_APU_PWR_CTRL_BYPASS1_BRF_CLK_DIV_RSTB_BYPASS_VAL_MASK (0x40U)
#define CIU2_CIU2_APU_PWR_CTRL_BYPASS1_BRF_CLK_DIV_RSTB_BYPASS_VAL_SHIFT (6U)
/*! brf_clk_div_rstb_bypass_val - Firmware Bypass Value for brf Clk_Div_Rstb (active low signal)
 */
#define CIU2_CIU2_APU_PWR_CTRL_BYPASS1_BRF_CLK_DIV_RSTB_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_APU_PWR_CTRL_BYPASS1_BRF_CLK_DIV_RSTB_BYPASS_VAL_SHIFT)) & CIU2_CIU2_APU_PWR_CTRL_BYPASS1_BRF_CLK_DIV_RSTB_BYPASS_VAL_MASK)

#define CIU2_CIU2_APU_PWR_CTRL_BYPASS1_BRF_CLK_DIV_RSTB_BYPASS_EN_MASK (0x80U)
#define CIU2_CIU2_APU_PWR_CTRL_BYPASS1_BRF_CLK_DIV_RSTB_BYPASS_EN_SHIFT (7U)
/*! brf_clk_div_rstb_bypass_en - Firmware Bypass brf Clk_Div_Rstb from APU
 */
#define CIU2_CIU2_APU_PWR_CTRL_BYPASS1_BRF_CLK_DIV_RSTB_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_APU_PWR_CTRL_BYPASS1_BRF_CLK_DIV_RSTB_BYPASS_EN_SHIFT)) & CIU2_CIU2_APU_PWR_CTRL_BYPASS1_BRF_CLK_DIV_RSTB_BYPASS_EN_MASK)

#define CIU2_CIU2_APU_PWR_CTRL_BYPASS1_BRF_SRAM_PD_BYPASS_VAL_MASK (0x100U)
#define CIU2_CIU2_APU_PWR_CTRL_BYPASS1_BRF_SRAM_PD_BYPASS_VAL_SHIFT (8U)
/*! brf_sram_pd_bypass_val - Firmware Bypass Value for SRAM_PD (active high signal)
 */
#define CIU2_CIU2_APU_PWR_CTRL_BYPASS1_BRF_SRAM_PD_BYPASS_VAL(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_APU_PWR_CTRL_BYPASS1_BRF_SRAM_PD_BYPASS_VAL_SHIFT)) & CIU2_CIU2_APU_PWR_CTRL_BYPASS1_BRF_SRAM_PD_BYPASS_VAL_MASK)

#define CIU2_CIU2_APU_PWR_CTRL_BYPASS1_BRF_SRAM_PD_BYPASS_EN_MASK (0x200U)
#define CIU2_CIU2_APU_PWR_CTRL_BYPASS1_BRF_SRAM_PD_BYPASS_EN_SHIFT (9U)
/*! brf_sram_pd_bypass_en - Firmware Bypass SRAM_PD from APU
 */
#define CIU2_CIU2_APU_PWR_CTRL_BYPASS1_BRF_SRAM_PD_BYPASS_EN(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_APU_PWR_CTRL_BYPASS1_BRF_SRAM_PD_BYPASS_EN_SHIFT)) & CIU2_CIU2_APU_PWR_CTRL_BYPASS1_BRF_SRAM_PD_BYPASS_EN_MASK)
/*! @} */

/*! @name CIU2_AHB2AHB_BRIDGE_CTRL - AHB2AHB Bridge Control Register */
/*! @{ */

#define CIU2_CIU2_AHB2AHB_BRIDGE_CTRL_PREFETCH_HSEL_EN_MASK (0x1U)
#define CIU2_CIU2_AHB2AHB_BRIDGE_CTRL_PREFETCH_HSEL_EN_SHIFT (0U)
/*! prefetch_hsel_en - ahb2ahb bridge pre-fetch hsel enable
 */
#define CIU2_CIU2_AHB2AHB_BRIDGE_CTRL_PREFETCH_HSEL_EN(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_AHB2AHB_BRIDGE_CTRL_PREFETCH_HSEL_EN_SHIFT)) & CIU2_CIU2_AHB2AHB_BRIDGE_CTRL_PREFETCH_HSEL_EN_MASK)
/*! @} */

/*! @name CIU2_AHB1_AHB2_TO_CLEAR - AHB1 AHB2 timeout logic clear register */
/*! @{ */

#define CIU2_CIU2_AHB1_AHB2_TO_CLEAR_AHB2_TIMEOUT_CLEAR_MASK (0x100U)
#define CIU2_CIU2_AHB1_AHB2_TO_CLEAR_AHB2_TIMEOUT_CLEAR_SHIFT (8U)
/*! ahb2_timeout_clear - After the timeout happended on AHB2 bus, the cpu will read the ERR ISR and
 *    read the bus state which cause the timeout and then set this bit to 1 to clear the AHB2
 *    timeout logic to start recroding next transaction. This is self clearing bit
 */
#define CIU2_CIU2_AHB1_AHB2_TO_CLEAR_AHB2_TIMEOUT_CLEAR(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_AHB1_AHB2_TO_CLEAR_AHB2_TIMEOUT_CLEAR_SHIFT)) & CIU2_CIU2_AHB1_AHB2_TO_CLEAR_AHB2_TIMEOUT_CLEAR_MASK)

#define CIU2_CIU2_AHB1_AHB2_TO_CLEAR_CPU2_DCODE_INV_ADDR_CLR_MASK (0x200U)
#define CIU2_CIU2_AHB1_AHB2_TO_CLEAR_CPU2_DCODE_INV_ADDR_CLR_SHIFT (9U)
/*! cpu2_dcode_inv_addr_clr - After the invalid address int happended on CPU2 dcode bus, the cpu2
 *    will read the ERR ISR and read the bus state which cause the timeout and then set this bit to 1
 *    to clear the CPU2 Dcode invalid addr logic to start recroding next transaction. This is self
 *    clearing bit
 */
#define CIU2_CIU2_AHB1_AHB2_TO_CLEAR_CPU2_DCODE_INV_ADDR_CLR(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_AHB1_AHB2_TO_CLEAR_CPU2_DCODE_INV_ADDR_CLR_SHIFT)) & CIU2_CIU2_AHB1_AHB2_TO_CLEAR_CPU2_DCODE_INV_ADDR_CLR_MASK)

#define CIU2_CIU2_AHB1_AHB2_TO_CLEAR_CPU2_ICODE_INV_ADDR_CLR_MASK (0x400U)
#define CIU2_CIU2_AHB1_AHB2_TO_CLEAR_CPU2_ICODE_INV_ADDR_CLR_SHIFT (10U)
/*! cpu2_icode_inv_addr_clr - After the invalid address int happended on CPU2 icode bus, the cpu2
 *    will read the ERR ISR and read the bus state which cause the timeout and then set this bit to 1
 *    to clear the CPU2 Icode invalid addr logic to start recroding next transaction. This is self
 *    clearing bit
 */
#define CIU2_CIU2_AHB1_AHB2_TO_CLEAR_CPU2_ICODE_INV_ADDR_CLR(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_AHB1_AHB2_TO_CLEAR_CPU2_ICODE_INV_ADDR_CLR_SHIFT)) & CIU2_CIU2_AHB1_AHB2_TO_CLEAR_CPU2_ICODE_INV_ADDR_CLR_MASK)
/*! @} */

/*! @name CIU2_CPU_CPU2_DBG_STAT - CPU2 debug register */
/*! @{ */

#define CIU2_CIU2_CPU_CPU2_DBG_STAT_CPU2_RO_STATUS_MASK (0xFFFFFFFFU)
#define CIU2_CIU2_CPU_CPU2_DBG_STAT_CPU2_RO_STATUS_SHIFT (0U)
/*! cpu2_ro_status - cpu2 debug output
 */
#define CIU2_CIU2_CPU_CPU2_DBG_STAT_CPU2_RO_STATUS(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CPU_CPU2_DBG_STAT_CPU2_RO_STATUS_SHIFT)) & CIU2_CIU2_CPU_CPU2_DBG_STAT_CPU2_RO_STATUS_MASK)
/*! @} */

/*! @name CIU2_CPU_CPU1_CTRL - CPU1 control register */
/*! @{ */

#define CIU2_CIU2_CPU_CPU1_CTRL_CPU1_JTAG_CHAIN_BYPASS_MASK (0x20000U)
#define CIU2_CIU2_CPU_CPU1_CTRL_CPU1_JTAG_CHAIN_BYPASS_SHIFT (17U)
#define CIU2_CIU2_CPU_CPU1_CTRL_CPU1_JTAG_CHAIN_BYPASS(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CPU_CPU1_CTRL_CPU1_JTAG_CHAIN_BYPASS_SHIFT)) & CIU2_CIU2_CPU_CPU1_CTRL_CPU1_JTAG_CHAIN_BYPASS_MASK)

#define CIU2_CIU2_CPU_CPU1_CTRL_CPU1_CPU2_MSG_SCHEME_MASK (0x40000U)
#define CIU2_CIU2_CPU_CPU1_CTRL_CPU1_CPU2_MSG_SCHEME_SHIFT (18U)
#define CIU2_CIU2_CPU_CPU1_CTRL_CPU1_CPU2_MSG_SCHEME(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CPU_CPU1_CTRL_CPU1_CPU2_MSG_SCHEME_SHIFT)) & CIU2_CIU2_CPU_CPU1_CTRL_CPU1_CPU2_MSG_SCHEME_MASK)

#define CIU2_CIU2_CPU_CPU1_CTRL_CPU2_RESET_INT_MASK (0x80000000U)
#define CIU2_CIU2_CPU_CPU1_CTRL_CPU2_RESET_INT_SHIFT (31U)
/*! cpu2_reset_int - cpu1 fw reset cpu2
 */
#define CIU2_CIU2_CPU_CPU1_CTRL_CPU2_RESET_INT(x) (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_CPU_CPU1_CTRL_CPU2_RESET_INT_SHIFT)) & CIU2_CIU2_CPU_CPU1_CTRL_CPU2_RESET_INT_MASK)
/*! @} */

/*! @name CIU2_TESTBUS_CTRL - CPU2 debug register */
/*! @{ */

#define CIU2_CIU2_TESTBUS_CTRL_TESTBUS_SEL_MASK  (0xFU)
#define CIU2_CIU2_TESTBUS_CTRL_TESTBUS_SEL_SHIFT (0U)
/*! testbus_sel - Select testbus debug output
 */
#define CIU2_CIU2_TESTBUS_CTRL_TESTBUS_SEL(x)    (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_TESTBUS_CTRL_TESTBUS_SEL_SHIFT)) & CIU2_CIU2_TESTBUS_CTRL_TESTBUS_SEL_MASK)
/*! @} */

/*! @name CIU2_LBC_CTRL - LBC Control and Status */
/*! @{ */

#define CIU2_CIU2_LBC_CTRL_LBC_NCO_EN_MASK       (0x1U)
#define CIU2_CIU2_LBC_CTRL_LBC_NCO_EN_SHIFT      (0U)
/*! lbc_nco_en - LBC NCO Enable Signal
 */
#define CIU2_CIU2_LBC_CTRL_LBC_NCO_EN(x)         (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_LBC_CTRL_LBC_NCO_EN_SHIFT)) & CIU2_CIU2_LBC_CTRL_LBC_NCO_EN_MASK)

#define CIU2_CIU2_LBC_CTRL_LBC_DEBUG_CTRL_MASK   (0x60U)
#define CIU2_CIU2_LBC_CTRL_LBC_DEBUG_CTRL_SHIFT  (5U)
/*! lbc_debug_ctrl - LBC Debug Control Signal
 */
#define CIU2_CIU2_LBC_CTRL_LBC_DEBUG_CTRL(x)     (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_LBC_CTRL_LBC_DEBUG_CTRL_SHIFT)) & CIU2_CIU2_LBC_CTRL_LBC_DEBUG_CTRL_MASK)

#define CIU2_CIU2_LBC_CTRL_DEJIT_EN_MASK         (0x10000U)
#define CIU2_CIU2_LBC_CTRL_DEJIT_EN_SHIFT        (16U)
/*! dejit_en - De-jitter Enable
 */
#define CIU2_CIU2_LBC_CTRL_DEJIT_EN(x)           (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_LBC_CTRL_DEJIT_EN_SHIFT)) & CIU2_CIU2_LBC_CTRL_DEJIT_EN_MASK)

#define CIU2_CIU2_LBC_CTRL_AUTO_DEJIT_MASK       (0x20000U)
#define CIU2_CIU2_LBC_CTRL_AUTO_DEJIT_SHIFT      (17U)
/*! auto_dejit - Auto de-jitter
 */
#define CIU2_CIU2_LBC_CTRL_AUTO_DEJIT(x)         (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_LBC_CTRL_AUTO_DEJIT_SHIFT)) & CIU2_CIU2_LBC_CTRL_AUTO_DEJIT_MASK)

#define CIU2_CIU2_LBC_CTRL_MAN_SEL_NCO_MASK      (0x40000U)
#define CIU2_CIU2_LBC_CTRL_MAN_SEL_NCO_SHIFT     (18U)
/*! man_sel_nco - Manual select NCO
 */
#define CIU2_CIU2_LBC_CTRL_MAN_SEL_NCO(x)        (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_LBC_CTRL_MAN_SEL_NCO_SHIFT)) & CIU2_CIU2_LBC_CTRL_MAN_SEL_NCO_MASK)

#define CIU2_CIU2_LBC_CTRL_NCO_LPO_RAMP_DN_MASK  (0x800000U)
#define CIU2_CIU2_LBC_CTRL_NCO_LPO_RAMP_DN_SHIFT (23U)
/*! nco_lpo_ramp_dn - Status nco_lpo_ramp_dn
 */
#define CIU2_CIU2_LBC_CTRL_NCO_LPO_RAMP_DN(x)    (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_LBC_CTRL_NCO_LPO_RAMP_DN_SHIFT)) & CIU2_CIU2_LBC_CTRL_NCO_LPO_RAMP_DN_MASK)

#define CIU2_CIU2_LBC_CTRL_REF_LPO_CLK_GOOD_MASK (0x1000000U)
#define CIU2_CIU2_LBC_CTRL_REF_LPO_CLK_GOOD_SHIFT (24U)
/*! ref_lpo_clk_good - Status ref_lpo_clk_good
 */
#define CIU2_CIU2_LBC_CTRL_REF_LPO_CLK_GOOD(x)   (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_LBC_CTRL_REF_LPO_CLK_GOOD_SHIFT)) & CIU2_CIU2_LBC_CTRL_REF_LPO_CLK_GOOD_MASK)

#define CIU2_CIU2_LBC_CTRL_REF_LPO_RAMP_DN_MASK  (0x2000000U)
#define CIU2_CIU2_LBC_CTRL_REF_LPO_RAMP_DN_SHIFT (25U)
/*! ref_lpo_ramp_dn - Status ref_lpo_ramp_dn
 */
#define CIU2_CIU2_LBC_CTRL_REF_LPO_RAMP_DN(x)    (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_LBC_CTRL_REF_LPO_RAMP_DN_SHIFT)) & CIU2_CIU2_LBC_CTRL_REF_LPO_RAMP_DN_MASK)

#define CIU2_CIU2_LBC_CTRL_LPO_CLK_SEL_FSM_MASK  (0x4000000U)
#define CIU2_CIU2_LBC_CTRL_LPO_CLK_SEL_FSM_SHIFT (26U)
/*! lpo_clk_sel_fsm - Status lpo_clk_sel_fsm
 */
#define CIU2_CIU2_LBC_CTRL_LPO_CLK_SEL_FSM(x)    (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_LBC_CTRL_LPO_CLK_SEL_FSM_SHIFT)) & CIU2_CIU2_LBC_CTRL_LPO_CLK_SEL_FSM_MASK)

#define CIU2_CIU2_LBC_CTRL_LPO_CLK_3K2_CNT_MASK  (0xF8000000U)
#define CIU2_CIU2_LBC_CTRL_LPO_CLK_3K2_CNT_SHIFT (27U)
/*! lpo_clk_3k2_cnt - Status lpo_clk_3k2_cnt, 3.2KHz Count
 */
#define CIU2_CIU2_LBC_CTRL_LPO_CLK_3K2_CNT(x)    (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_LBC_CTRL_LPO_CLK_3K2_CNT_SHIFT)) & CIU2_CIU2_LBC_CTRL_LPO_CLK_3K2_CNT_MASK)
/*! @} */

/*! @name CIU2_LBC_SLPCLK_NCO - LBC NCO Step for Sleep Clock */
/*! @{ */

#define CIU2_CIU2_LBC_SLPCLK_NCO_STEP_MASK       (0xFFFFFFFFU)
#define CIU2_CIU2_LBC_SLPCLK_NCO_STEP_SHIFT      (0U)
/*! step - LBC NCO step for sleep clock. Please refer to design spreadsheet for more details.
 */
#define CIU2_CIU2_LBC_SLPCLK_NCO_STEP(x)         (((uint32_t)(((uint32_t)(x)) << CIU2_CIU2_LBC_SLPCLK_NCO_STEP_SHIFT)) & CIU2_CIU2_LBC_SLPCLK_NCO_STEP_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group CIU2_Register_Masks */


/* CIU2 - Peripheral instance base addresses */
#if (defined(__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE & 0x2))
  /** Peripheral CIU2 base address */
  #define CIU2_BASE                                (0x58948000u)
  /** Peripheral CIU2 base address */
  #define CIU2_BASE_NS                             (0x48948000u)
  /** Peripheral CIU2 base pointer */
  #define CIU2                                     ((CIU2_Type *)CIU2_BASE)
  /** Peripheral CIU2 base pointer */
  #define CIU2_NS                                  ((CIU2_Type *)CIU2_BASE_NS)
  /** Array initializer of CIU2 peripheral base addresses */
  #define CIU2_BASE_ADDRS                          { CIU2_BASE }
  /** Array initializer of CIU2 peripheral base pointers */
  #define CIU2_BASE_PTRS                           { CIU2 }
  /** Array initializer of CIU2 peripheral base addresses */
  #define CIU2_BASE_ADDRS_NS                       { CIU2_BASE_NS }
  /** Array initializer of CIU2 peripheral base pointers */
  #define CIU2_BASE_PTRS_NS                        { CIU2_NS }
#else
  /** Peripheral CIU2 base address */
  #define CIU2_BASE                                (0x48948000u)
  /** Peripheral CIU2 base pointer */
  #define CIU2                                     ((CIU2_Type *)CIU2_BASE)
  /** Array initializer of CIU2 peripheral base addresses */
  #define CIU2_BASE_ADDRS                          { CIU2_BASE }
  /** Array initializer of CIU2 peripheral base pointers */
  #define CIU2_BASE_PTRS                           { CIU2 }
#endif

/*!
 * @}
 */ /* end of group CIU2_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- CMC Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CMC_Peripheral_Access_Layer CMC Peripheral Access Layer
 * @{
 */

/** CMC - Register Layout Typedef */
typedef struct {
  __I  uint32_t VERID;                             /**< Version ID Register, offset: 0x0 */
       uint8_t RESERVED_0[12];
  __IO uint32_t CKCTRL;                            /**< Clock Control Register, offset: 0x10 */
  __IO uint32_t CKSTAT;                            /**< Clock Status Register, offset: 0x14 */
  __IO uint32_t PMPROT;                            /**< Power Mode Protection Register, offset: 0x18 */
  __O  uint32_t GPMCTRL;                           /**< Global Power Mode Control Register, offset: 0x1C */
  __IO uint32_t PMCTRL[2];                         /**< Power Mode Control Register, array offset: 0x20, array step: 0x4 */
       uint8_t RESERVED_1[88];
  __I  uint32_t SRS;                               /**< System Reset Status Register, offset: 0x80 */
  __IO uint32_t RPC;                               /**< Reset Pin Control Register, offset: 0x84 */
  __IO uint32_t SSRS;                              /**< Sticky System Reset Status Register, offset: 0x88 */
  __IO uint32_t SRIE;                              /**< System Reset Interrupt Enable Register, offset: 0x8C */
  __IO uint32_t SRIF;                              /**< System Reset Interrupt Flag Register, offset: 0x90 */
       uint8_t RESERVED_2[8];
  __I  uint32_t RSTCNT;                            /**< Reset Count Register, offset: 0x9C */
  __IO uint32_t MR[1];                             /**< Mode Register, array offset: 0xA0, array step: 0x4 */
       uint8_t RESERVED_3[12];
  __IO uint32_t FM[1];                             /**< Force Mode Register, array offset: 0xB0, array step: 0x4 */
       uint8_t RESERVED_4[12];
  __IO uint32_t SRAMDIS[1];                        /**< SRAM Disable Register, array offset: 0xC0, array step: 0x4 */
       uint8_t RESERVED_5[12];
  __IO uint32_t SRAMRET[1];                        /**< SRAM Retention Register, array offset: 0xD0, array step: 0x4 */
       uint8_t RESERVED_6[12];
  __IO uint32_t FLASHCR;                           /**< Flash Control Register, offset: 0xE0 */
       uint8_t RESERVED_7[28];
  __IO uint32_t BSR;                               /**< BootROM Status Register, offset: 0x100 */
       uint8_t RESERVED_8[8];
  __IO uint32_t BLR;                               /**< BootROM Lock Register, offset: 0x10C */
  __IO uint32_t CORECTL;                           /**< Core Control Register, offset: 0x110 */
       uint8_t RESERVED_9[12];
  __IO uint32_t DBGCTL;                            /**< Debug Control Register, offset: 0x120 */
} CMC_Type;

/* ----------------------------------------------------------------------------
   -- CMC Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CMC_Register_Masks CMC Register Masks
 * @{
 */

/*! @name VERID - Version ID Register */
/*! @{ */

#define CMC_VERID_FEATURE_MASK                   (0xFFFFU)
#define CMC_VERID_FEATURE_SHIFT                  (0U)
/*! FEATURE - Feature Specification Number
 */
#define CMC_VERID_FEATURE(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_VERID_FEATURE_SHIFT)) & CMC_VERID_FEATURE_MASK)

#define CMC_VERID_MINOR_MASK                     (0xFF0000U)
#define CMC_VERID_MINOR_SHIFT                    (16U)
/*! MINOR - Minor Version Number
 */
#define CMC_VERID_MINOR(x)                       (((uint32_t)(((uint32_t)(x)) << CMC_VERID_MINOR_SHIFT)) & CMC_VERID_MINOR_MASK)

#define CMC_VERID_MAJOR_MASK                     (0xFF000000U)
#define CMC_VERID_MAJOR_SHIFT                    (24U)
/*! MAJOR - Major Version Number
 */
#define CMC_VERID_MAJOR(x)                       (((uint32_t)(((uint32_t)(x)) << CMC_VERID_MAJOR_SHIFT)) & CMC_VERID_MAJOR_MASK)
/*! @} */

/*! @name CKCTRL - Clock Control Register */
/*! @{ */

#define CMC_CKCTRL_CKMODE_MASK                   (0xFU)
#define CMC_CKCTRL_CKMODE_SHIFT                  (0U)
/*! CKMODE - Clocking Mode
 *  0b0000..No clock gating.
 *  0b0001..Core clock is gated.
 *  0b0011..Core and platform clocks are gated.
 *  0b0111..Core, platform, and peripheral clocks are gated, but no change in low power mode.
 *  0b1111..Core, platform, and peripheral clocks are gated, and core enters low power mode.
 */
#define CMC_CKCTRL_CKMODE(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_CKCTRL_CKMODE_SHIFT)) & CMC_CKCTRL_CKMODE_MASK)

#define CMC_CKCTRL_LOCK_MASK                     (0x80000000U)
#define CMC_CKCTRL_LOCK_SHIFT                    (31U)
/*! LOCK - Lock Register
 *  0b0..Register writes are allowed.
 *  0b1..Register writes are blocked.
 */
#define CMC_CKCTRL_LOCK(x)                       (((uint32_t)(((uint32_t)(x)) << CMC_CKCTRL_LOCK_SHIFT)) & CMC_CKCTRL_LOCK_MASK)
/*! @} */

/*! @name CKSTAT - Clock Status Register */
/*! @{ */

#define CMC_CKSTAT_CKMODE_MASK                   (0xFU)
#define CMC_CKSTAT_CKMODE_SHIFT                  (0U)
/*! CKMODE - Low Power Status
 *  0b0000..Core clock not gated.
 *  0b0001..Core clock was gated
 *  0b0011..Core and platform clocks were gated
 *  0b0111..Core, platform, and peripheral clocks were gated
 *  0b1111..Core, platform, and peripheral clocks were gated, and power domain entered low power mode.
 */
#define CMC_CKSTAT_CKMODE(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_CKSTAT_CKMODE_SHIFT)) & CMC_CKSTAT_CKMODE_MASK)

#define CMC_CKSTAT_WAKEUP_MASK                   (0x7F00U)
#define CMC_CKSTAT_WAKEUP_SHIFT                  (8U)
/*! WAKEUP - Wakeup Source
 */
#define CMC_CKSTAT_WAKEUP(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_CKSTAT_WAKEUP_SHIFT)) & CMC_CKSTAT_WAKEUP_MASK)

#define CMC_CKSTAT_VALID_MASK                    (0x80000000U)
#define CMC_CKSTAT_VALID_SHIFT                   (31U)
/*! VALID - Clock Status Valid
 *  0b0..Core clock not gated.
 *  0b1..Core clock was gated due to low power mode entry.
 */
#define CMC_CKSTAT_VALID(x)                      (((uint32_t)(((uint32_t)(x)) << CMC_CKSTAT_VALID_SHIFT)) & CMC_CKSTAT_VALID_MASK)
/*! @} */

/*! @name PMPROT - Power Mode Protection Register */
/*! @{ */

#define CMC_PMPROT_LPMODE_MASK                   (0xFU)
#define CMC_PMPROT_LPMODE_SHIFT                  (0U)
/*! LPMODE - Low Power Mode
 */
#define CMC_PMPROT_LPMODE(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_PMPROT_LPMODE_SHIFT)) & CMC_PMPROT_LPMODE_MASK)

#define CMC_PMPROT_LOCK_MASK                     (0x80000000U)
#define CMC_PMPROT_LOCK_SHIFT                    (31U)
/*! LOCK - Lock Register
 *  0b0..Register writes are allowed.
 *  0b1..Register writes are blocked.
 */
#define CMC_PMPROT_LOCK(x)                       (((uint32_t)(((uint32_t)(x)) << CMC_PMPROT_LOCK_SHIFT)) & CMC_PMPROT_LOCK_MASK)
/*! @} */

/*! @name GPMCTRL - Global Power Mode Control Register */
/*! @{ */

#define CMC_GPMCTRL_LPMODE_MASK                  (0xFU)
#define CMC_GPMCTRL_LPMODE_SHIFT                 (0U)
/*! LPMODE - Low Power Mode
 */
#define CMC_GPMCTRL_LPMODE(x)                    (((uint32_t)(((uint32_t)(x)) << CMC_GPMCTRL_LPMODE_SHIFT)) & CMC_GPMCTRL_LPMODE_MASK)
/*! @} */

/*! @name PMCTRL - Power Mode Control Register */
/*! @{ */

#define CMC_PMCTRL_LPMODE_MASK                   (0xFU)
#define CMC_PMCTRL_LPMODE_SHIFT                  (0U)
/*! LPMODE - Low Power Mode
 *  0b0000..Active
 *  0b0001..Sleep
 *  0b0011..Deep Sleep
 *  0b0111..Power Down
 *  0b1111..Deep Power Down
 */
#define CMC_PMCTRL_LPMODE(x)                     (((uint32_t)(((uint32_t)(x)) << CMC_PMCTRL_LPMODE_SHIFT)) & CMC_PMCTRL_LPMODE_MASK)
/*! @} */

/* The count of CMC_PMCTRL */
#define CMC_PMCTRL_COUNT                         (2U)

/*! @name SRS - System Reset Status Register */
/*! @{ */

#define CMC_SRS_WAKEUP_MASK                      (0x1U)
#define CMC_SRS_WAKEUP_SHIFT                     (0U)
/*! WAKEUP - Wakeup Reset
 *  0b0..Reset not generated by wakeup from Power Down or Deep Power Down mode.
 *  0b1..Reset generated by wakeup from Power Down or Deep Power Down mode.
 */
#define CMC_SRS_WAKEUP(x)                        (((uint32_t)(((uint32_t)(x)) << CMC_SRS_WAKEUP_SHIFT)) & CMC_SRS_WAKEUP_MASK)

#define CMC_SRS_POR_MASK                         (0x2U)
#define CMC_SRS_POR_SHIFT                        (1U)
/*! POR - Power-on Reset
 *  0b0..Reset not generated by POR.
 *  0b1..Reset generated by POR.
 */
#define CMC_SRS_POR(x)                           (((uint32_t)(((uint32_t)(x)) << CMC_SRS_POR_SHIFT)) & CMC_SRS_POR_MASK)

#define CMC_SRS_LVD_MASK                         (0x4U)
#define CMC_SRS_LVD_SHIFT                        (2U)
/*! LVD - Low Voltage Detect Reset
 *  0b0..Reset not generated by LVD.
 *  0b1..Reset generated by LVD.
 */
#define CMC_SRS_LVD(x)                           (((uint32_t)(((uint32_t)(x)) << CMC_SRS_LVD_SHIFT)) & CMC_SRS_LVD_MASK)

#define CMC_SRS_HVD_MASK                         (0x8U)
#define CMC_SRS_HVD_SHIFT                        (3U)
/*! HVD - High Voltage Detect Reset
 *  0b0..Reset not generated by HVD.
 *  0b1..Reset generated by HVD.
 */
#define CMC_SRS_HVD(x)                           (((uint32_t)(((uint32_t)(x)) << CMC_SRS_HVD_SHIFT)) & CMC_SRS_HVD_MASK)

#define CMC_SRS_WARM_MASK                        (0x10U)
#define CMC_SRS_WARM_SHIFT                       (4U)
/*! WARM - Warm Reset
 *  0b0..Reset not generated by Warm Reset source.
 *  0b1..Reset generated by Warm Reset source.
 */
#define CMC_SRS_WARM(x)                          (((uint32_t)(((uint32_t)(x)) << CMC_SRS_WARM_SHIFT)) & CMC_SRS_WARM_MASK)

#define CMC_SRS_FATAL_MASK                       (0x20U)
#define CMC_SRS_FATAL_SHIFT                      (5U)
/*! FATAL - Fatal Reset
 *  0b0..Reset was not generated by a fatal reset source.
 *  0b1..Reset was generated by a fatal reset source.
 */
#define CMC_SRS_FATAL(x)                         (((uint32_t)(((uint32_t)(x)) << CMC_SRS_FATAL_SHIFT)) & CMC_SRS_FATAL_MASK)

#define CMC_SRS_PIN_MASK                         (0x100U)
#define CMC_SRS_PIN_SHIFT                        (8U)
/*! PIN - Pin Reset
 *  0b0..Reset was not generated from the assertion of RESET_b pin.
 *  0b1..Reset was generated from the assertion of RESET_b pin.
 */
#define CMC_SRS_PIN(x)                           (((uint32_t)(((uint32_t)(x)) << CMC_SRS_PIN_SHIFT)) & CMC_SRS_PIN_MASK)

#define CMC_SRS_DAP_MASK                         (0x200U)
#define CMC_SRS_DAP_SHIFT                        (9U)
/*! DAP - Debug Access Port Reset
 *  0b0..Reset was not generated from a DAP reset request.
 *  0b1..Reset was generated from a DAP reset request.
 */
#define CMC_SRS_DAP(x)                           (((uint32_t)(((uint32_t)(x)) << CMC_SRS_DAP_SHIFT)) & CMC_SRS_DAP_MASK)

#define CMC_SRS_RSTACK_MASK                      (0x400U)
#define CMC_SRS_RSTACK_SHIFT                     (10U)
/*! RSTACK - Reset Timeout
 *  0b0..Reset not generated from Reset Controller Timeout.
 *  0b1..Reset generated from Reset Controller Timeout.
 */
#define CMC_SRS_RSTACK(x)                        (((uint32_t)(((uint32_t)(x)) << CMC_SRS_RSTACK_SHIFT)) & CMC_SRS_RSTACK_MASK)

#define CMC_SRS_LPACK_MASK                       (0x800U)
#define CMC_SRS_LPACK_SHIFT                      (11U)
/*! LPACK - Low Power Acknowledge Timeout Reset
 *  0b0..Reset not generated by Low Power Acknowledge Timeout.
 *  0b1..Reset generated by Low Power Acknowledge Timeout.
 */
#define CMC_SRS_LPACK(x)                         (((uint32_t)(((uint32_t)(x)) << CMC_SRS_LPACK_SHIFT)) & CMC_SRS_LPACK_MASK)

#define CMC_SRS_SCG_MASK                         (0x1000U)
#define CMC_SRS_SCG_SHIFT                        (12U)
/*! SCG - System Clock Generation Reset
 *  0b0..Reset is not generated from an SCG loss of lock or loss of clock.
 *  0b1..Reset is generated from an SCG loss of lock or loss of clock.
 */
#define CMC_SRS_SCG(x)                           (((uint32_t)(((uint32_t)(x)) << CMC_SRS_SCG_SHIFT)) & CMC_SRS_SCG_MASK)

#define CMC_SRS_WDOG0_MASK                       (0x2000U)
#define CMC_SRS_WDOG0_SHIFT                      (13U)
/*! WDOG0 - Watchdog 0 Reset
 *  0b0..Reset is not generated from the WatchDog 0 timeout.
 *  0b1..Reset is generated from the WatchDog 0 timeout.
 */
#define CMC_SRS_WDOG0(x)                         (((uint32_t)(((uint32_t)(x)) << CMC_SRS_WDOG0_SHIFT)) & CMC_SRS_WDOG0_MASK)

#define CMC_SRS_SW_MASK                          (0x4000U)
#define CMC_SRS_SW_SHIFT                         (14U)
/*! SW - Software Reset
 *  0b0..Reset not generated by software request from core.
 *  0b1..Reset generated by software request from core.
 */
#define CMC_SRS_SW(x)                            (((uint32_t)(((uint32_t)(x)) << CMC_SRS_SW_SHIFT)) & CMC_SRS_SW_MASK)

#define CMC_SRS_LOCKUP_MASK                      (0x8000U)
#define CMC_SRS_LOCKUP_SHIFT                     (15U)
/*! LOCKUP - Lockup Reset
 *  0b0..Reset not generated by core lockup or exception.
 *  0b1..Reset generated by core lockup or exception.
 */
#define CMC_SRS_LOCKUP(x)                        (((uint32_t)(((uint32_t)(x)) << CMC_SRS_LOCKUP_SHIFT)) & CMC_SRS_LOCKUP_MASK)

#define CMC_SRS_WDOG1_MASK                       (0x2000000U)
#define CMC_SRS_WDOG1_SHIFT                      (25U)
/*! WDOG1 - Watchdog 1 Reset
 *  0b0..Reset is not generated from the WatchDog 1 timeout.
 *  0b1..Reset is generated from the WatchDog 1 timeout.
 */
#define CMC_SRS_WDOG1(x)                         (((uint32_t)(((uint32_t)(x)) << CMC_SRS_WDOG1_SHIFT)) & CMC_SRS_WDOG1_MASK)

#define CMC_SRS_SECVIO_MASK                      (0x40000000U)
#define CMC_SRS_SECVIO_SHIFT                     (30U)
/*! SECVIO - Security Violation Reset
 *  0b0..Reset not generated by security violation.
 *  0b1..Reset generated by security violation.
 */
#define CMC_SRS_SECVIO(x)                        (((uint32_t)(((uint32_t)(x)) << CMC_SRS_SECVIO_SHIFT)) & CMC_SRS_SECVIO_MASK)
/*! @} */

/*! @name RPC - Reset Pin Control Register */
/*! @{ */

#define CMC_RPC_FILTCFG_MASK                     (0x1FU)
#define CMC_RPC_FILTCFG_SHIFT                    (0U)
/*! FILTCFG - Reset Filter Configuration
 */
#define CMC_RPC_FILTCFG(x)                       (((uint32_t)(((uint32_t)(x)) << CMC_RPC_FILTCFG_SHIFT)) & CMC_RPC_FILTCFG_MASK)

#define CMC_RPC_FILTEN_MASK                      (0x100U)
#define CMC_RPC_FILTEN_SHIFT                     (8U)
/*! FILTEN - Filter Enable
 *  0b0..Slow clock reset pin filter disabled.
 *  0b1..Slow clock reset pin filter enabled in Active modes.
 */
#define CMC_RPC_FILTEN(x)                        (((uint32_t)(((uint32_t)(x)) << CMC_RPC_FILTEN_SHIFT)) & CMC_RPC_FILTEN_MASK)

#define CMC_RPC_LPFEN_MASK                       (0x200U)
#define CMC_RPC_LPFEN_SHIFT                      (9U)
/*! LPFEN - Low Power Filter Enable
 *  0b0..Low power reset pin filter disabled.
 *  0b1..Low power reset pin filter enabled in Active and Low Power modes.
 */
#define CMC_RPC_LPFEN(x)                         (((uint32_t)(((uint32_t)(x)) << CMC_RPC_LPFEN_SHIFT)) & CMC_RPC_LPFEN_MASK)
/*! @} */

/*! @name SSRS - Sticky System Reset Status Register */
/*! @{ */

#define CMC_SSRS_WAKEUP_MASK                     (0x1U)
#define CMC_SSRS_WAKEUP_SHIFT                    (0U)
/*! WAKEUP - Wakeup Reset
 *  0b0..Reset not generated by wakeup from VLLS mode.
 *  0b1..Reset generated by wakeup from VLLS mode.
 */
#define CMC_SSRS_WAKEUP(x)                       (((uint32_t)(((uint32_t)(x)) << CMC_SSRS_WAKEUP_SHIFT)) & CMC_SSRS_WAKEUP_MASK)

#define CMC_SSRS_POR_MASK                        (0x2U)
#define CMC_SSRS_POR_SHIFT                       (1U)
/*! POR - Power-on Reset
 *  0b0..Reset not generated by POR.
 *  0b1..Reset generated by POR.
 */
#define CMC_SSRS_POR(x)                          (((uint32_t)(((uint32_t)(x)) << CMC_SSRS_POR_SHIFT)) & CMC_SSRS_POR_MASK)

#define CMC_SSRS_LVD_MASK                        (0x4U)
#define CMC_SSRS_LVD_SHIFT                       (2U)
/*! LVD - Low Voltage Detect Reset
 *  0b0..Reset not generated by LVD.
 *  0b1..Reset generated by LVD.
 */
#define CMC_SSRS_LVD(x)                          (((uint32_t)(((uint32_t)(x)) << CMC_SSRS_LVD_SHIFT)) & CMC_SSRS_LVD_MASK)

#define CMC_SSRS_HVD_MASK                        (0x8U)
#define CMC_SSRS_HVD_SHIFT                       (3U)
/*! HVD - High Voltage Detect Reset
 *  0b0..Reset not generated by HVD.
 *  0b1..Reset generated by HVD.
 */
#define CMC_SSRS_HVD(x)                          (((uint32_t)(((uint32_t)(x)) << CMC_SSRS_HVD_SHIFT)) & CMC_SSRS_HVD_MASK)

#define CMC_SSRS_WARM_MASK                       (0x10U)
#define CMC_SSRS_WARM_SHIFT                      (4U)
/*! WARM - Warm Reset
 *  0b0..Reset not generated by warm reset source.
 *  0b1..Reset generated by warm reset source.
 */
#define CMC_SSRS_WARM(x)                         (((uint32_t)(((uint32_t)(x)) << CMC_SSRS_WARM_SHIFT)) & CMC_SSRS_WARM_MASK)

#define CMC_SSRS_FATAL_MASK                      (0x20U)
#define CMC_SSRS_FATAL_SHIFT                     (5U)
/*! FATAL - Fatal Reset
 *  0b0..Reset was not generated by a fatal reset source.
 *  0b1..Reset was generated by a fatal reset source.
 */
#define CMC_SSRS_FATAL(x)                        (((uint32_t)(((uint32_t)(x)) << CMC_SSRS_FATAL_SHIFT)) & CMC_SSRS_FATAL_MASK)

#define CMC_SSRS_PIN_MASK                        (0x100U)
#define CMC_SSRS_PIN_SHIFT                       (8U)
/*! PIN - Pin Reset
 *  0b0..Reset was not generated from the RESET_B pin.
 *  0b1..Reset was generated from the RESET_B pin.
 */
#define CMC_SSRS_PIN(x)                          (((uint32_t)(((uint32_t)(x)) << CMC_SSRS_PIN_SHIFT)) & CMC_SSRS_PIN_MASK)

#define CMC_SSRS_DAP_MASK                        (0x200U)
#define CMC_SSRS_DAP_SHIFT                       (9U)
/*! DAP - DAP Reset
 *  0b0..Reset was not generated from a DAP reset request.
 *  0b1..Reset was generated from a DAP reset request.
 */
#define CMC_SSRS_DAP(x)                          (((uint32_t)(((uint32_t)(x)) << CMC_SSRS_DAP_SHIFT)) & CMC_SSRS_DAP_MASK)

#define CMC_SSRS_RSTACK_MASK                     (0x400U)
#define CMC_SSRS_RSTACK_SHIFT                    (10U)
/*! RSTACK - Reset Timeout
 *  0b0..Reset not generated from Reset Controller Timeout.
 *  0b1..Reset generated from Reset Controller Timeout.
 */
#define CMC_SSRS_RSTACK(x)                       (((uint32_t)(((uint32_t)(x)) << CMC_SSRS_RSTACK_SHIFT)) & CMC_SSRS_RSTACK_MASK)

#define CMC_SSRS_LPACK_MASK                      (0x800U)
#define CMC_SSRS_LPACK_SHIFT                     (11U)
/*! LPACK - Low Power Acknowledge Timeout Reset
 *  0b0..Reset not generated by Low Power Acknowledge Timeout.
 *  0b1..Reset generated by Low Power Acknowledge Timeout.
 */
#define CMC_SSRS_LPACK(x)                        (((uint32_t)(((uint32_t)(x)) << CMC_SSRS_LPACK_SHIFT)) & CMC_SSRS_LPACK_MASK)

#define CMC_SSRS_SCG_MASK                        (0x1000U)
#define CMC_SSRS_SCG_SHIFT                       (12U)
/*! SCG - System Clock Generation Reset
 *  0b0..Reset is not generated from an SCG loss of lock or loss of clock.
 *  0b1..Reset is generated from an SCG loss of lock or loss of clock.
 */
#define CMC_SSRS_SCG(x)                          (((uint32_t)(((uint32_t)(x)) << CMC_SSRS_SCG_SHIFT)) & CMC_SSRS_SCG_MASK)

#define CMC_SSRS_WDOG0_MASK                      (0x2000U)
#define CMC_SSRS_WDOG0_SHIFT                     (13U)
/*! WDOG0 - Watchdog 0 Reset
 *  0b0..Reset is not generated from the WatchDog 0 timeout.
 *  0b1..Reset is generated from the WatchDog 0 timeout.
 */
#define CMC_SSRS_WDOG0(x)                        (((uint32_t)(((uint32_t)(x)) << CMC_SSRS_WDOG0_SHIFT)) & CMC_SSRS_WDOG0_MASK)

#define CMC_SSRS_SW_MASK                         (0x4000U)
#define CMC_SSRS_SW_SHIFT                        (14U)
/*! SW - Software Reset
 *  0b0..Reset not generated by software request from core.
 *  0b1..Reset generated by software request from core.
 */
#define CMC_SSRS_SW(x)                           (((uint32_t)(((uint32_t)(x)) << CMC_SSRS_SW_SHIFT)) & CMC_SSRS_SW_MASK)

#define CMC_SSRS_LOCKUP_MASK                     (0x8000U)
#define CMC_SSRS_LOCKUP_SHIFT                    (15U)
/*! LOCKUP - Lockup Reset
 *  0b0..Reset not generated by core lockup.
 *  0b1..Reset generated by core lockup.
 */
#define CMC_SSRS_LOCKUP(x)                       (((uint32_t)(((uint32_t)(x)) << CMC_SSRS_LOCKUP_SHIFT)) & CMC_SSRS_LOCKUP_MASK)

#define CMC_SSRS_WDOG1_MASK                      (0x2000000U)
#define CMC_SSRS_WDOG1_SHIFT                     (25U)
/*! WDOG1 - Watchdog 1 Reset
 *  0b0..Reset is not generated from the WatchDog 1 timeout.
 *  0b1..Reset is generated from the WatchDog 1 timeout.
 */
#define CMC_SSRS_WDOG1(x)                        (((uint32_t)(((uint32_t)(x)) << CMC_SSRS_WDOG1_SHIFT)) & CMC_SSRS_WDOG1_MASK)

#define CMC_SSRS_SECVIO_MASK                     (0x40000000U)
#define CMC_SSRS_SECVIO_SHIFT                    (30U)
/*! SECVIO - Security Violation Reset
 *  0b0..Reset not generated by Security Violation detection.
 *  0b1..Reset generated by Security Violation detection.
 */
#define CMC_SSRS_SECVIO(x)                       (((uint32_t)(((uint32_t)(x)) << CMC_SSRS_SECVIO_SHIFT)) & CMC_SSRS_SECVIO_MASK)
/*! @} */

/*! @name SRIE - System Reset Interrupt Enable Register */
/*! @{ */

#define CMC_SRIE_PIN_MASK                        (0x100U)
#define CMC_SRIE_PIN_SHIFT                       (8U)
/*! PIN - Pin Reset
 *  0b0..Interrupt disabled.
 *  0b1..Interrupt enabled.
 */
#define CMC_SRIE_PIN(x)                          (((uint32_t)(((uint32_t)(x)) << CMC_SRIE_PIN_SHIFT)) & CMC_SRIE_PIN_MASK)

#define CMC_SRIE_DAP_MASK                        (0x200U)
#define CMC_SRIE_DAP_SHIFT                       (9U)
/*! DAP - DAP Reset
 *  0b0..Interrupt disabled.
 *  0b1..Interrupt enabled.
 */
#define CMC_SRIE_DAP(x)                          (((uint32_t)(((uint32_t)(x)) << CMC_SRIE_DAP_SHIFT)) & CMC_SRIE_DAP_MASK)

#define CMC_SRIE_LPACK_MASK                      (0x800U)
#define CMC_SRIE_LPACK_SHIFT                     (11U)
/*! LPACK - Low Power Acknowledge Timeout Reset
 *  0b0..Interrupt disabled.
 *  0b1..Interrupt enabled.
 */
#define CMC_SRIE_LPACK(x)                        (((uint32_t)(((uint32_t)(x)) << CMC_SRIE_LPACK_SHIFT)) & CMC_SRIE_LPACK_MASK)

#define CMC_SRIE_WDOG0_MASK                      (0x2000U)
#define CMC_SRIE_WDOG0_SHIFT                     (13U)
/*! WDOG0 - Watchdog 0 Reset
 *  0b0..Interrupt disabled.
 *  0b1..Interrupt enabled.
 */
#define CMC_SRIE_WDOG0(x)                        (((uint32_t)(((uint32_t)(x)) << CMC_SRIE_WDOG0_SHIFT)) & CMC_SRIE_WDOG0_MASK)

#define CMC_SRIE_SW_MASK                         (0x4000U)
#define CMC_SRIE_SW_SHIFT                        (14U)
/*! SW - Software Reset
 *  0b0..Interrupt disabled.
 *  0b1..Interrupt enabled.
 */
#define CMC_SRIE_SW(x)                           (((uint32_t)(((uint32_t)(x)) << CMC_SRIE_SW_SHIFT)) & CMC_SRIE_SW_MASK)

#define CMC_SRIE_LOCKUP_MASK                     (0x8000U)
#define CMC_SRIE_LOCKUP_SHIFT                    (15U)
/*! LOCKUP - Lockup Reset
 *  0b0..Interrupt disabled.
 *  0b1..Interrupt enabled.
 */
#define CMC_SRIE_LOCKUP(x)                       (((uint32_t)(((uint32_t)(x)) << CMC_SRIE_LOCKUP_SHIFT)) & CMC_SRIE_LOCKUP_MASK)

#define CMC_SRIE_WDOG1_MASK                      (0x2000000U)
#define CMC_SRIE_WDOG1_SHIFT                     (25U)
/*! WDOG1 - Watchdog 1 Reset
 *  0b0..Interrupt disabled.
 *  0b1..Interrupt enabled.
 */
#define CMC_SRIE_WDOG1(x)                        (((uint32_t)(((uint32_t)(x)) << CMC_SRIE_WDOG1_SHIFT)) & CMC_SRIE_WDOG1_MASK)
/*! @} */

/*! @name SRIF - System Reset Interrupt Flag Register */
/*! @{ */

#define CMC_SRIF_PIN_MASK                        (0x100U)
#define CMC_SRIF_PIN_SHIFT                       (8U)
/*! PIN - Pin Reset
 *  0b0..Reset source not pending.
 *  0b1..Reset source pending.
 */
#define CMC_SRIF_PIN(x)                          (((uint32_t)(((uint32_t)(x)) << CMC_SRIF_PIN_SHIFT)) & CMC_SRIF_PIN_MASK)

#define CMC_SRIF_DAP_MASK                        (0x200U)
#define CMC_SRIF_DAP_SHIFT                       (9U)
/*! DAP - DAP Reset
 *  0b0..Reset source not pending.
 *  0b1..Reset source pending.
 */
#define CMC_SRIF_DAP(x)                          (((uint32_t)(((uint32_t)(x)) << CMC_SRIF_DAP_SHIFT)) & CMC_SRIF_DAP_MASK)

#define CMC_SRIF_LPACK_MASK                      (0x800U)
#define CMC_SRIF_LPACK_SHIFT                     (11U)
/*! LPACK - Low Power Acknowledge Timeout Reset
 *  0b0..Reset source not pending.
 *  0b1..Reset source pending.
 */
#define CMC_SRIF_LPACK(x)                        (((uint32_t)(((uint32_t)(x)) << CMC_SRIF_LPACK_SHIFT)) & CMC_SRIF_LPACK_MASK)

#define CMC_SRIF_WDOG0_MASK                      (0x2000U)
#define CMC_SRIF_WDOG0_SHIFT                     (13U)
/*! WDOG0 - Watchdog 0 Reset
 *  0b0..Reset source not pending.
 *  0b1..Reset source pending.
 */
#define CMC_SRIF_WDOG0(x)                        (((uint32_t)(((uint32_t)(x)) << CMC_SRIF_WDOG0_SHIFT)) & CMC_SRIF_WDOG0_MASK)

#define CMC_SRIF_SW_MASK                         (0x4000U)
#define CMC_SRIF_SW_SHIFT                        (14U)
/*! SW - Software Reset
 *  0b0..Reset source not pending.
 *  0b1..Reset source pending.
 */
#define CMC_SRIF_SW(x)                           (((uint32_t)(((uint32_t)(x)) << CMC_SRIF_SW_SHIFT)) & CMC_SRIF_SW_MASK)

#define CMC_SRIF_LOCKUP_MASK                     (0x8000U)
#define CMC_SRIF_LOCKUP_SHIFT                    (15U)
/*! LOCKUP - Lockup Reset
 *  0b0..Reset source not pending.
 *  0b1..Reset source pending.
 */
#define CMC_SRIF_LOCKUP(x)                       (((uint32_t)(((uint32_t)(x)) << CMC_SRIF_LOCKUP_SHIFT)) & CMC_SRIF_LOCKUP_MASK)

#define CMC_SRIF_WDOG1_MASK                      (0x2000000U)
#define CMC_SRIF_WDOG1_SHIFT                     (25U)
/*! WDOG1 - Watchdog 1 Reset
 *  0b0..Reset source not pending.
 *  0b1..Reset source pending.
 */
#define CMC_SRIF_WDOG1(x)                        (((uint32_t)(((uint32_t)(x)) << CMC_SRIF_WDOG1_SHIFT)) & CMC_SRIF_WDOG1_MASK)
/*! @} */

/*! @name RSTCNT - Reset Count Register */
/*! @{ */

#define CMC_RSTCNT_COUNT_MASK                    (0xFFU)
#define CMC_RSTCNT_COUNT_SHIFT                   (0U)
/*! COUNT - Count
 */
#define CMC_RSTCNT_COUNT(x)                      (((uint32_t)(((uint32_t)(x)) << CMC_RSTCNT_COUNT_SHIFT)) & CMC_RSTCNT_COUNT_MASK)
/*! @} */

/*! @name MR - Mode Register */
/*! @{ */

#define CMC_MR_ISPMODE_n_MASK                    (0x1U)
#define CMC_MR_ISPMODE_n_SHIFT                   (0U)
/*! ISPMODE_n - In System Programming Mode
 */
#define CMC_MR_ISPMODE_n(x)                      (((uint32_t)(((uint32_t)(x)) << CMC_MR_ISPMODE_n_SHIFT)) & CMC_MR_ISPMODE_n_MASK)
/*! @} */

/* The count of CMC_MR */
#define CMC_MR_COUNT                             (1U)

/*! @name FM - Force Mode Register */
/*! @{ */

#define CMC_FM_FORCECFG_MASK                     (0x1U)
#define CMC_FM_FORCECFG_SHIFT                    (0U)
/*! FORCECFG - Boot Configuration
 *  0b0..No effect.
 *  0b1..Assert corresponding bit in Mode Register on next system reset.
 */
#define CMC_FM_FORCECFG(x)                       (((uint32_t)(((uint32_t)(x)) << CMC_FM_FORCECFG_SHIFT)) & CMC_FM_FORCECFG_MASK)
/*! @} */

/* The count of CMC_FM */
#define CMC_FM_COUNT                             (1U)

/*! @name SRAMDIS - SRAM Disable Register */
/*! @{ */

#define CMC_SRAMDIS_DIS_MASK                     (0xFFU)
#define CMC_SRAMDIS_DIS_SHIFT                    (0U)
/*! DIS - SRAM Disable
 */
#define CMC_SRAMDIS_DIS(x)                       (((uint32_t)(((uint32_t)(x)) << CMC_SRAMDIS_DIS_SHIFT)) & CMC_SRAMDIS_DIS_MASK)
/*! @} */

/* The count of CMC_SRAMDIS */
#define CMC_SRAMDIS_COUNT                        (1U)

/*! @name SRAMRET - SRAM Retention Register */
/*! @{ */

#define CMC_SRAMRET_RET_MASK                     (0xFFU)
#define CMC_SRAMRET_RET_SHIFT                    (0U)
/*! RET - SRAM Retention
 */
#define CMC_SRAMRET_RET(x)                       (((uint32_t)(((uint32_t)(x)) << CMC_SRAMRET_RET_SHIFT)) & CMC_SRAMRET_RET_MASK)
/*! @} */

/* The count of CMC_SRAMRET */
#define CMC_SRAMRET_COUNT                        (1U)

/*! @name FLASHCR - Flash Control Register */
/*! @{ */

#define CMC_FLASHCR_FLASHDIS_MASK                (0x1U)
#define CMC_FLASHCR_FLASHDIS_SHIFT               (0U)
/*! FLASHDIS - Flash Disable
 *  0b0..No effect.
 *  0b1..Flash is disabled.
 */
#define CMC_FLASHCR_FLASHDIS(x)                  (((uint32_t)(((uint32_t)(x)) << CMC_FLASHCR_FLASHDIS_SHIFT)) & CMC_FLASHCR_FLASHDIS_MASK)

#define CMC_FLASHCR_FLASHDOZE_MASK               (0x2U)
#define CMC_FLASHCR_FLASHDOZE_SHIFT              (1U)
/*! FLASHDOZE - Flash Doze
 *  0b0..No effect.
 *  0b1..Flash is disabled while core is sleeping (CKMODE > 0).
 */
#define CMC_FLASHCR_FLASHDOZE(x)                 (((uint32_t)(((uint32_t)(x)) << CMC_FLASHCR_FLASHDOZE_SHIFT)) & CMC_FLASHCR_FLASHDOZE_MASK)

#define CMC_FLASHCR_FLASHWAKE_MASK               (0x4U)
#define CMC_FLASHCR_FLASHWAKE_SHIFT              (2U)
/*! FLASHWAKE - Flash Wake
 *  0b0..No effect.
 *  0b1..Flash is not disabled during Flash memory accesses.
 */
#define CMC_FLASHCR_FLASHWAKE(x)                 (((uint32_t)(((uint32_t)(x)) << CMC_FLASHCR_FLASHWAKE_SHIFT)) & CMC_FLASHCR_FLASHWAKE_MASK)
/*! @} */

/*! @name BSR - BootROM Status Register */
/*! @{ */

#define CMC_BSR_STAT_MASK                        (0xFFFFFFFFU)
#define CMC_BSR_STAT_SHIFT                       (0U)
/*! STAT - This register field provides status information written by the BootROM.
 */
#define CMC_BSR_STAT(x)                          (((uint32_t)(((uint32_t)(x)) << CMC_BSR_STAT_SHIFT)) & CMC_BSR_STAT_MASK)
/*! @} */

/*! @name BLR - BootROM Lock Register */
/*! @{ */

#define CMC_BLR_LOCK_MASK                        (0x7U)
#define CMC_BLR_LOCK_SHIFT                       (0U)
/*! LOCK - Lock
 *  0b010..BootROM Status and Lock Registers can be written
 *  0b101..BootROM Status and Lock Registers cannot be written
 */
#define CMC_BLR_LOCK(x)                          (((uint32_t)(((uint32_t)(x)) << CMC_BLR_LOCK_SHIFT)) & CMC_BLR_LOCK_MASK)
/*! @} */

/*! @name CORECTL - Core Control Register */
/*! @{ */

#define CMC_CORECTL_NPIE_MASK                    (0x1U)
#define CMC_CORECTL_NPIE_SHIFT                   (0U)
/*! NPIE - Non-maskable Pin Interrupt Enable
 *  0b0..Pin interrupt disabled
 *  0b1..Pin interrupt enabled
 */
#define CMC_CORECTL_NPIE(x)                      (((uint32_t)(((uint32_t)(x)) << CMC_CORECTL_NPIE_SHIFT)) & CMC_CORECTL_NPIE_MASK)
/*! @} */

/*! @name DBGCTL - Debug Control Register */
/*! @{ */

#define CMC_DBGCTL_SOD_MASK                      (0x1U)
#define CMC_DBGCTL_SOD_SHIFT                     (0U)
/*! SOD - Sleep Or Debug
 *  0b0..Debug remains enabled when Core is sleeping.
 *  0b1..Debug is disabled when Core is sleeping.
 */
#define CMC_DBGCTL_SOD(x)                        (((uint32_t)(((uint32_t)(x)) << CMC_DBGCTL_SOD_SHIFT)) & CMC_DBGCTL_SOD_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group CMC_Register_Masks */


/* CMC - Peripheral instance base addresses */
#if (defined(__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE & 0x2))
  /** Peripheral CMC0 base address */
  #define CMC0_BASE                                (0x50001000u)
  /** Peripheral CMC0 base address */
  #define CMC0_BASE_NS                             (0x40001000u)
  /** Peripheral CMC0 base pointer */
  #define CMC0                                     ((CMC_Type *)CMC0_BASE)
  /** Peripheral CMC0 base pointer */
  #define CMC0_NS                                  ((CMC_Type *)CMC0_BASE_NS)
  /** Array initializer of CMC peripheral base addresses */
  #define CMC_BASE_ADDRS                           { CMC0_BASE }
  /** Array initializer of CMC peripheral base pointers */
  #define CMC_BASE_PTRS                            { CMC0 }
  /** Array initializer of CMC peripheral base addresses */
  #define CMC_BASE_ADDRS_NS                        { CMC0_BASE_NS }
  /** Array initializer of CMC peripheral base pointers */
  #define CMC_BASE_PTRS_NS                         { CMC0_NS }
#else
  /** Peripheral CMC0 base address */
  #define CMC0_BASE                                (0x40001000u)
  /** Peripheral CMC0 base pointer */
  #define CMC0                                     ((CMC_Type *)CMC0_BASE)
  /** Array initializer of CMC peripheral base addresses */
  #define CMC_BASE_ADDRS                           { CMC0_BASE }
  /** Array initializer of CMC peripheral base pointers */
  #define CMC_BASE_PTRS                            { CMC0 }
#endif

/*!
 * @}
 */ /* end of group CMC_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- CRC Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CRC_Peripheral_Access_Layer CRC Peripheral Access Layer
 * @{
 */

/** CRC - Register Layout Typedef */
typedef struct {
  union {                                          /* offset: 0x0 */
    struct {                                         /* offset: 0x0 */
      __IO uint8_t DATALL;                             /**< CRC_DATALL register, offset: 0x0 */
      __IO uint8_t DATALU;                             /**< CRC_DATALU register, offset: 0x1 */
      __IO uint8_t DATAHL;                             /**< CRC_DATAHL register, offset: 0x2 */
      __IO uint8_t DATAHU;                             /**< CRC_DATAHU register, offset: 0x3 */
    } ACCESS8BIT;
    struct {                                         /* offset: 0x0 */
      __IO uint16_t DATAL;                             /**< CRC_DATAL register, offset: 0x0 */
      __IO uint16_t DATAH;                             /**< CRC_DATAH register, offset: 0x2 */
    } ACCESS16BIT;
    __IO uint32_t DATA;                              /**< CRC DATA register, offset: 0x0 */
  };
  union {                                          /* offset: 0x4 */
    struct {                                         /* offset: 0x4 */
      __IO uint8_t GPOLYLL;                            /**< CRC_GPOLYLL register, offset: 0x4 */
      __IO uint8_t GPOLYLU;                            /**< CRC_GPOLYLU register, offset: 0x5 */
      __IO uint8_t GPOLYHL;                            /**< CRC_GPOLYHL register, offset: 0x6 */
      __IO uint8_t GPOLYHU;                            /**< CRC_GPOLYHU register, offset: 0x7 */
    } GPOLY_ACCESS8BIT;
    struct {                                         /* offset: 0x4 */
      __IO uint16_t GPOLYL;                            /**< CRC_GPOLYL register, offset: 0x4 */
      __IO uint16_t GPOLYH;                            /**< CRC_GPOLYH register, offset: 0x6 */
    } GPOLY_ACCESS16BIT;
    __IO uint32_t GPOLY;                             /**< CRC Polynomial register, offset: 0x4 */
  };
  union {                                          /* offset: 0x8 */
    struct {                                         /* offset: 0x8 */
           uint8_t RESERVED_0[3];
      __IO uint8_t CTRLHU;                             /**< CRC_CTRLHU register, offset: 0xB */
    } CTRL_ACCESS8BIT;
    __IO uint32_t CTRL;                              /**< CRC Control register, offset: 0x8 */
  };
} CRC_Type;

/* ----------------------------------------------------------------------------
   -- CRC Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CRC_Register_Masks CRC Register Masks
 * @{
 */

/*! @name DATALL - CRC_DATALL register */
/*! @{ */

#define CRC_DATALL_DATALL_MASK                   (0xFFU)
#define CRC_DATALL_DATALL_SHIFT                  (0U)
#define CRC_DATALL_DATALL(x)                     (((uint8_t)(((uint8_t)(x)) << CRC_DATALL_DATALL_SHIFT)) & CRC_DATALL_DATALL_MASK)
/*! @} */

/*! @name DATALU - CRC_DATALU register */
/*! @{ */

#define CRC_DATALU_DATALU_MASK                   (0xFFU)
#define CRC_DATALU_DATALU_SHIFT                  (0U)
#define CRC_DATALU_DATALU(x)                     (((uint8_t)(((uint8_t)(x)) << CRC_DATALU_DATALU_SHIFT)) & CRC_DATALU_DATALU_MASK)
/*! @} */

/*! @name DATAHL - CRC_DATAHL register */
/*! @{ */

#define CRC_DATAHL_DATAHL_MASK                   (0xFFU)
#define CRC_DATAHL_DATAHL_SHIFT                  (0U)
#define CRC_DATAHL_DATAHL(x)                     (((uint8_t)(((uint8_t)(x)) << CRC_DATAHL_DATAHL_SHIFT)) & CRC_DATAHL_DATAHL_MASK)
/*! @} */

/*! @name DATAHU - CRC_DATAHU register */
/*! @{ */

#define CRC_DATAHU_DATAHU_MASK                   (0xFFU)
#define CRC_DATAHU_DATAHU_SHIFT                  (0U)
#define CRC_DATAHU_DATAHU(x)                     (((uint8_t)(((uint8_t)(x)) << CRC_DATAHU_DATAHU_SHIFT)) & CRC_DATAHU_DATAHU_MASK)
/*! @} */

/*! @name DATAL - CRC_DATAL register */
/*! @{ */

#define CRC_DATAL_DATAL_MASK                     (0xFFFFU)
#define CRC_DATAL_DATAL_SHIFT                    (0U)
#define CRC_DATAL_DATAL(x)                       (((uint16_t)(((uint16_t)(x)) << CRC_DATAL_DATAL_SHIFT)) & CRC_DATAL_DATAL_MASK)
/*! @} */

/*! @name DATAH - CRC_DATAH register */
/*! @{ */

#define CRC_DATAH_DATAH_MASK                     (0xFFFFU)
#define CRC_DATAH_DATAH_SHIFT                    (0U)
#define CRC_DATAH_DATAH(x)                       (((uint16_t)(((uint16_t)(x)) << CRC_DATAH_DATAH_SHIFT)) & CRC_DATAH_DATAH_MASK)
/*! @} */

/*! @name DATA - CRC DATA register */
/*! @{ */

#define CRC_DATA_LL_MASK                         (0xFFU)
#define CRC_DATA_LL_SHIFT                        (0U)
/*! LL - CRC Low Lower Byte
 */
#define CRC_DATA_LL(x)                           (((uint32_t)(((uint32_t)(x)) << CRC_DATA_LL_SHIFT)) & CRC_DATA_LL_MASK)

#define CRC_DATA_LU_MASK                         (0xFF00U)
#define CRC_DATA_LU_SHIFT                        (8U)
/*! LU - CRC Low Upper Byte
 */
#define CRC_DATA_LU(x)                           (((uint32_t)(((uint32_t)(x)) << CRC_DATA_LU_SHIFT)) & CRC_DATA_LU_MASK)

#define CRC_DATA_HL_MASK                         (0xFF0000U)
#define CRC_DATA_HL_SHIFT                        (16U)
/*! HL - CRC High Lower Byte
 */
#define CRC_DATA_HL(x)                           (((uint32_t)(((uint32_t)(x)) << CRC_DATA_HL_SHIFT)) & CRC_DATA_HL_MASK)

#define CRC_DATA_HU_MASK                         (0xFF000000U)
#define CRC_DATA_HU_SHIFT                        (24U)
/*! HU - CRC High Upper Byte
 */
#define CRC_DATA_HU(x)                           (((uint32_t)(((uint32_t)(x)) << CRC_DATA_HU_SHIFT)) & CRC_DATA_HU_MASK)
/*! @} */

/*! @name GPOLYLL - CRC_GPOLYLL register */
/*! @{ */

#define CRC_GPOLYLL_GPOLYLL_MASK                 (0xFFU)
#define CRC_GPOLYLL_GPOLYLL_SHIFT                (0U)
#define CRC_GPOLYLL_GPOLYLL(x)                   (((uint8_t)(((uint8_t)(x)) << CRC_GPOLYLL_GPOLYLL_SHIFT)) & CRC_GPOLYLL_GPOLYLL_MASK)
/*! @} */

/*! @name GPOLYLU - CRC_GPOLYLU register */
/*! @{ */

#define CRC_GPOLYLU_GPOLYLU_MASK                 (0xFFU)
#define CRC_GPOLYLU_GPOLYLU_SHIFT                (0U)
#define CRC_GPOLYLU_GPOLYLU(x)                   (((uint8_t)(((uint8_t)(x)) << CRC_GPOLYLU_GPOLYLU_SHIFT)) & CRC_GPOLYLU_GPOLYLU_MASK)
/*! @} */

/*! @name GPOLYHL - CRC_GPOLYHL register */
/*! @{ */

#define CRC_GPOLYHL_GPOLYHL_MASK                 (0xFFU)
#define CRC_GPOLYHL_GPOLYHL_SHIFT                (0U)
#define CRC_GPOLYHL_GPOLYHL(x)                   (((uint8_t)(((uint8_t)(x)) << CRC_GPOLYHL_GPOLYHL_SHIFT)) & CRC_GPOLYHL_GPOLYHL_MASK)
/*! @} */

/*! @name GPOLYHU - CRC_GPOLYHU register */
/*! @{ */

#define CRC_GPOLYHU_GPOLYHU_MASK                 (0xFFU)
#define CRC_GPOLYHU_GPOLYHU_SHIFT                (0U)
#define CRC_GPOLYHU_GPOLYHU(x)                   (((uint8_t)(((uint8_t)(x)) << CRC_GPOLYHU_GPOLYHU_SHIFT)) & CRC_GPOLYHU_GPOLYHU_MASK)
/*! @} */

/*! @name GPOLYL - CRC_GPOLYL register */
/*! @{ */

#define CRC_GPOLYL_GPOLYL_MASK                   (0xFFFFU)
#define CRC_GPOLYL_GPOLYL_SHIFT                  (0U)
#define CRC_GPOLYL_GPOLYL(x)                     (((uint16_t)(((uint16_t)(x)) << CRC_GPOLYL_GPOLYL_SHIFT)) & CRC_GPOLYL_GPOLYL_MASK)
/*! @} */

/*! @name GPOLYH - CRC_GPOLYH register */
/*! @{ */

#define CRC_GPOLYH_GPOLYH_MASK                   (0xFFFFU)
#define CRC_GPOLYH_GPOLYH_SHIFT                  (0U)
#define CRC_GPOLYH_GPOLYH(x)                     (((uint16_t)(((uint16_t)(x)) << CRC_GPOLYH_GPOLYH_SHIFT)) & CRC_GPOLYH_GPOLYH_MASK)
/*! @} */

/*! @name GPOLY - CRC Polynomial register */
/*! @{ */

#define CRC_GPOLY_LOW_MASK                       (0xFFFFU)
#define CRC_GPOLY_LOW_SHIFT                      (0U)
/*! LOW - Low Polynominal Half-word
 */
#define CRC_GPOLY_LOW(x)                         (((uint32_t)(((uint32_t)(x)) << CRC_GPOLY_LOW_SHIFT)) & CRC_GPOLY_LOW_MASK)

#define CRC_GPOLY_HIGH_MASK                      (0xFFFF0000U)
#define CRC_GPOLY_HIGH_SHIFT                     (16U)
/*! HIGH - High Polynominal Half-word
 */
#define CRC_GPOLY_HIGH(x)                        (((uint32_t)(((uint32_t)(x)) << CRC_GPOLY_HIGH_SHIFT)) & CRC_GPOLY_HIGH_MASK)
/*! @} */

/*! @name CTRLHU - CRC_CTRLHU register */
/*! @{ */

#define CRC_CTRLHU_TCRC_MASK                     (0x1U)
#define CRC_CTRLHU_TCRC_SHIFT                    (0U)
/*! TCRC - TCRC
 *  0b0..16-bit CRC protocol.
 *  0b1..32-bit CRC protocol.
 */
#define CRC_CTRLHU_TCRC(x)                       (((uint8_t)(((uint8_t)(x)) << CRC_CTRLHU_TCRC_SHIFT)) & CRC_CTRLHU_TCRC_MASK)

#define CRC_CTRLHU_WAS_MASK                      (0x2U)
#define CRC_CTRLHU_WAS_SHIFT                     (1U)
/*! WAS - Write CRC DATA register As Seed
 *  0b0..Writes to the CRC DATA register are data values.
 *  0b1..Writes to the CRC DATA register are seed values.
 */
#define CRC_CTRLHU_WAS(x)                        (((uint8_t)(((uint8_t)(x)) << CRC_CTRLHU_WAS_SHIFT)) & CRC_CTRLHU_WAS_MASK)

#define CRC_CTRLHU_FXOR_MASK                     (0x4U)
#define CRC_CTRLHU_FXOR_SHIFT                    (2U)
/*! FXOR - Complement Read Of CRC DATA register
 *  0b0..No XOR on reading.
 *  0b1..Invert or complement the read value of the CRC DATA register.
 */
#define CRC_CTRLHU_FXOR(x)                       (((uint8_t)(((uint8_t)(x)) << CRC_CTRLHU_FXOR_SHIFT)) & CRC_CTRLHU_FXOR_MASK)

#define CRC_CTRLHU_TOTR_MASK                     (0x30U)
#define CRC_CTRLHU_TOTR_SHIFT                    (4U)
/*! TOTR - Type Of Transpose For Read
 *  0b00..No transposition.
 *  0b01..Bits in bytes are transposed; bytes are not transposed.
 *  0b10..Both bits in bytes and bytes are transposed.
 *  0b11..Only bytes are transposed; no bits in a byte are transposed.
 */
#define CRC_CTRLHU_TOTR(x)                       (((uint8_t)(((uint8_t)(x)) << CRC_CTRLHU_TOTR_SHIFT)) & CRC_CTRLHU_TOTR_MASK)

#define CRC_CTRLHU_TOT_MASK                      (0xC0U)
#define CRC_CTRLHU_TOT_SHIFT                     (6U)
/*! TOT - Type Of Transpose For Writes
 *  0b00..No transposition.
 *  0b01..Bits in bytes are transposed; bytes are not transposed.
 *  0b10..Both bits in bytes and bytes are transposed.
 *  0b11..Only bytes are transposed; no bits in a byte are transposed.
 */
#define CRC_CTRLHU_TOT(x)                        (((uint8_t)(((uint8_t)(x)) << CRC_CTRLHU_TOT_SHIFT)) & CRC_CTRLHU_TOT_MASK)
/*! @} */

/*! @name CTRL - CRC Control register */
/*! @{ */

#define CRC_CTRL_TCRC_MASK                       (0x1000000U)
#define CRC_CTRL_TCRC_SHIFT                      (24U)
/*! TCRC - TCRC
 *  0b0..16-bit CRC protocol.
 *  0b1..32-bit CRC protocol.
 */
#define CRC_CTRL_TCRC(x)                         (((uint32_t)(((uint32_t)(x)) << CRC_CTRL_TCRC_SHIFT)) & CRC_CTRL_TCRC_MASK)

#define CRC_CTRL_WAS_MASK                        (0x2000000U)
#define CRC_CTRL_WAS_SHIFT                       (25U)
/*! WAS - Write CRC DATA register As Seed
 *  0b0..Writes to the CRC DATA register are data values.
 *  0b1..Writes to the CRC DATA register are seed values.
 */
#define CRC_CTRL_WAS(x)                          (((uint32_t)(((uint32_t)(x)) << CRC_CTRL_WAS_SHIFT)) & CRC_CTRL_WAS_MASK)

#define CRC_CTRL_FXOR_MASK                       (0x4000000U)
#define CRC_CTRL_FXOR_SHIFT                      (26U)
/*! FXOR - Complement Read Of CRC DATA register
 *  0b0..No XOR on reading.
 *  0b1..Invert or complement the read value of the CRC DATA register.
 */
#define CRC_CTRL_FXOR(x)                         (((uint32_t)(((uint32_t)(x)) << CRC_CTRL_FXOR_SHIFT)) & CRC_CTRL_FXOR_MASK)

#define CRC_CTRL_TOTR_MASK                       (0x30000000U)
#define CRC_CTRL_TOTR_SHIFT                      (28U)
/*! TOTR - Type Of Transpose For Read
 *  0b00..No transposition.
 *  0b01..Bits in bytes are transposed; bytes are not transposed.
 *  0b10..Both bits in bytes and bytes are transposed.
 *  0b11..Only bytes are transposed; no bits in a byte are transposed.
 */
#define CRC_CTRL_TOTR(x)                         (((uint32_t)(((uint32_t)(x)) << CRC_CTRL_TOTR_SHIFT)) & CRC_CTRL_TOTR_MASK)

#define CRC_CTRL_TOT_MASK                        (0xC0000000U)
#define CRC_CTRL_TOT_SHIFT                       (30U)
/*! TOT - Type Of Transpose For Writes
 *  0b00..No transposition.
 *  0b01..Bits in bytes are transposed; bytes are not transposed.
 *  0b10..Both bits in bytes and bytes are transposed.
 *  0b11..Only bytes are transposed; no bits in a byte are transposed.
 */
#define CRC_CTRL_TOT(x)                          (((uint32_t)(((uint32_t)(x)) << CRC_CTRL_TOT_SHIFT)) & CRC_CTRL_TOT_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group CRC_Register_Masks */


/* CRC - Peripheral instance base addresses */
#if (defined(__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE & 0x2))
  /** Peripheral CRC0 base address */
  #define CRC0_BASE                                (0x50023000u)
  /** Peripheral CRC0 base address */
  #define CRC0_BASE_NS                             (0x40023000u)
  /** Peripheral CRC0 base pointer */
  #define CRC0                                     ((CRC_Type *)CRC0_BASE)
  /** Peripheral CRC0 base pointer */
  #define CRC0_NS                                  ((CRC_Type *)CRC0_BASE_NS)
  /** Array initializer of CRC peripheral base addresses */
  #define CRC_BASE_ADDRS                           { CRC0_BASE }
  /** Array initializer of CRC peripheral base pointers */
  #define CRC_BASE_PTRS                            { CRC0 }
  /** Array initializer of CRC peripheral base addresses */
  #define CRC_BASE_ADDRS_NS                        { CRC0_BASE_NS }
  /** Array initializer of CRC peripheral base pointers */
  #define CRC_BASE_PTRS_NS                         { CRC0_NS }
#else
  /** Peripheral CRC0 base address */
  #define CRC0_BASE                                (0x40023000u)
  /** Peripheral CRC0 base pointer */
  #define CRC0                                     ((CRC_Type *)CRC0_BASE)
  /** Array initializer of CRC peripheral base addresses */
  #define CRC_BASE_ADDRS                           { CRC0_BASE }
  /** Array initializer of CRC peripheral base pointers */
  #define CRC_BASE_PTRS                            { CRC0 }
#endif

/*!
 * @}
 */ /* end of group CRC_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- DMA Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DMA_Peripheral_Access_Layer DMA Peripheral Access Layer
 * @{
 */

/** DMA - Register Layout Typedef */
typedef struct {
  __IO uint32_t MP_CSR;                            /**< Management Page Control, offset: 0x0 */
  __I  uint32_t MP_ES;                             /**< Management Page Error Status, offset: 0x4 */
  __I  uint32_t MP_INT;                            /**< Management Page Interrupt Request Status, offset: 0x8 */
  __I  uint32_t MP_HRS;                            /**< Management Page Hardware Request Status, offset: 0xC */
       uint8_t RESERVED_0[240];
  __IO uint32_t CH_GRPRI[16];                      /**< Channel Arbitration Group, array offset: 0x100, array step: 0x4 */
       uint8_t RESERVED_1[3776];
  struct {                                         /* offset: 0x1000, array step: 0x1000 */
    __IO uint32_t CH_CSR;                            /**< Channel Control and Status, array offset: 0x1000, array step: 0x1000 */
    __IO uint32_t CH_ES;                             /**< Channel Error Status, array offset: 0x1004, array step: 0x1000 */
    __IO uint32_t CH_INT;                            /**< Channel Interrupt Status, array offset: 0x1008, array step: 0x1000 */
    __IO uint32_t CH_SBR;                            /**< Channel System Bus, array offset: 0x100C, array step: 0x1000 */
    __IO uint32_t CH_PRI;                            /**< Channel Priority, array offset: 0x1010, array step: 0x1000 */
    __IO uint32_t CH_MUX;                            /**< Channel Multiplexor Configuration, array offset: 0x1014, array step: 0x1000 */
         uint8_t RESERVED_0[8];
    __IO uint32_t TCD_SADDR;                         /**< TCD Source Address, array offset: 0x1020, array step: 0x1000 */
    __IO uint16_t TCD_SOFF;                          /**< TCD Signed Source Address Offset, array offset: 0x1024, array step: 0x1000 */
    __IO uint16_t TCD_ATTR;                          /**< TCD Transfer Attributes, array offset: 0x1026, array step: 0x1000 */
    union {                                          /* offset: 0x1028, array step: 0x1000 */
      __IO uint32_t TCD_NBYTES_MLOFFNO;                /**< TCD Transfer Size Without Minor Loop Offsets, array offset: 0x1028, array step: 0x1000 */
      __IO uint32_t TCD_NBYTES_MLOFFYES;               /**< TCD Transfer Size with Minor Loop Offsets, array offset: 0x1028, array step: 0x1000 */
    };
    __IO uint32_t TCD_SLAST_SDA;                     /**< TCD Last Source Address Adjustment / Store DADDR Address, array offset: 0x102C, array step: 0x1000 */
    __IO uint32_t TCD_DADDR;                         /**< TCD Destination Address, array offset: 0x1030, array step: 0x1000 */
    __IO uint16_t TCD_DOFF;                          /**< TCD Signed Destination Address Offset, array offset: 0x1034, array step: 0x1000 */
    union {                                          /* offset: 0x1036, array step: 0x1000 */
      __IO uint16_t TCD_CITER_ELINKNO;                 /**< TCD Current Major Loop Count (Minor Loop Channel Linking Disabled), array offset: 0x1036, array step: 0x1000 */
      __IO uint16_t TCD_CITER_ELINKYES;                /**< TCD Current Major Loop Count (Minor Loop Channel Linking Enabled), array offset: 0x1036, array step: 0x1000 */
    };
    __IO uint32_t TCD_DLAST_SGA;                     /**< TCD Last Destination Address Adjustment / Scatter Gather Address, array offset: 0x1038, array step: 0x1000 */
    __IO uint16_t TCD_CSR;                           /**< TCD Control and Status, array offset: 0x103C, array step: 0x1000 */
    union {                                          /* offset: 0x103E, array step: 0x1000 */
      __IO uint16_t TCD_BITER_ELINKNO;                 /**< TCD Beginning Major Loop Count (Minor Loop Channel Linking Disabled), array offset: 0x103E, array step: 0x1000 */
      __IO uint16_t TCD_BITER_ELINKYES;                /**< TCD Beginning Major Loop Count (Minor Loop Channel Linking Enabled), array offset: 0x103E, array step: 0x1000 */
    };
         uint8_t RESERVED_1[4032];
  } CH[16];
} DMA_Type;

/* ----------------------------------------------------------------------------
   -- DMA Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DMA_Register_Masks DMA Register Masks
 * @{
 */

/*! @name MP_CSR - Management Page Control */
/*! @{ */

#define DMA_MP_CSR_EDBG_MASK                     (0x2U)
#define DMA_MP_CSR_EDBG_SHIFT                    (1U)
/*! EDBG - Enable Debug
 *  0b0..Debug mode disabled
 *  0b1..Debug mode is enabled.
 */
#define DMA_MP_CSR_EDBG(x)                       (((uint32_t)(((uint32_t)(x)) << DMA_MP_CSR_EDBG_SHIFT)) & DMA_MP_CSR_EDBG_MASK)

#define DMA_MP_CSR_ERCA_MASK                     (0x4U)
#define DMA_MP_CSR_ERCA_SHIFT                    (2U)
/*! ERCA - Enable Round Robin Channel Arbitration
 *  0b0..Round-robin channel arbitration disabled
 *  0b1..Round-robin channel arbitration enabled
 */
#define DMA_MP_CSR_ERCA(x)                       (((uint32_t)(((uint32_t)(x)) << DMA_MP_CSR_ERCA_SHIFT)) & DMA_MP_CSR_ERCA_MASK)

#define DMA_MP_CSR_HAE_MASK                      (0x10U)
#define DMA_MP_CSR_HAE_SHIFT                     (4U)
/*! HAE - Halt After Error
 *  0b0..Normal operation
 *  0b1..Any error causes the HALT field to be set to 1
 */
#define DMA_MP_CSR_HAE(x)                        (((uint32_t)(((uint32_t)(x)) << DMA_MP_CSR_HAE_SHIFT)) & DMA_MP_CSR_HAE_MASK)

#define DMA_MP_CSR_HALT_MASK                     (0x20U)
#define DMA_MP_CSR_HALT_SHIFT                    (5U)
/*! HALT - Halt DMA Operations
 *  0b0..Normal operation
 *  0b1..Stall the start of any new channels
 */
#define DMA_MP_CSR_HALT(x)                       (((uint32_t)(((uint32_t)(x)) << DMA_MP_CSR_HALT_SHIFT)) & DMA_MP_CSR_HALT_MASK)

#define DMA_MP_CSR_GCLC_MASK                     (0x40U)
#define DMA_MP_CSR_GCLC_SHIFT                    (6U)
/*! GCLC - Global Channel Linking Control
 *  0b0..Channel linking disabled for all channels
 *  0b1..Channel linking available and controlled by each channel's link settings
 */
#define DMA_MP_CSR_GCLC(x)                       (((uint32_t)(((uint32_t)(x)) << DMA_MP_CSR_GCLC_SHIFT)) & DMA_MP_CSR_GCLC_MASK)

#define DMA_MP_CSR_GMRC_MASK                     (0x80U)
#define DMA_MP_CSR_GMRC_SHIFT                    (7U)
/*! GMRC - Global Master ID Replication Control
 *  0b0..Master ID replication disabled for all channels
 *  0b1..Master ID replication available and controlled by each channel's CHn_SBR[EMI] setting
 */
#define DMA_MP_CSR_GMRC(x)                       (((uint32_t)(((uint32_t)(x)) << DMA_MP_CSR_GMRC_SHIFT)) & DMA_MP_CSR_GMRC_MASK)

#define DMA_MP_CSR_ECX_MASK                      (0x100U)
#define DMA_MP_CSR_ECX_SHIFT                     (8U)
/*! ECX - Cancel Transfer With Error
 *  0b0..Normal operation
 *  0b1..Cancel the remaining data transfer
 */
#define DMA_MP_CSR_ECX(x)                        (((uint32_t)(((uint32_t)(x)) << DMA_MP_CSR_ECX_SHIFT)) & DMA_MP_CSR_ECX_MASK)

#define DMA_MP_CSR_CX_MASK                       (0x200U)
#define DMA_MP_CSR_CX_SHIFT                      (9U)
/*! CX - Cancel Transfer
 *  0b0..Normal operation
 *  0b1..Cancel the remaining data transfer
 */
#define DMA_MP_CSR_CX(x)                         (((uint32_t)(((uint32_t)(x)) << DMA_MP_CSR_CX_SHIFT)) & DMA_MP_CSR_CX_MASK)

#define DMA_MP_CSR_ACTIVE_ID_MASK                (0xF000000U)
#define DMA_MP_CSR_ACTIVE_ID_SHIFT               (24U)
/*! ACTIVE_ID - Active Channel ID
 */
#define DMA_MP_CSR_ACTIVE_ID(x)                  (((uint32_t)(((uint32_t)(x)) << DMA_MP_CSR_ACTIVE_ID_SHIFT)) & DMA_MP_CSR_ACTIVE_ID_MASK)

#define DMA_MP_CSR_ACTIVE_MASK                   (0x80000000U)
#define DMA_MP_CSR_ACTIVE_SHIFT                  (31U)
/*! ACTIVE - DMA Active Status
 *  0b0..eDMA is idle
 *  0b1..eDMA is executing a channel
 */
#define DMA_MP_CSR_ACTIVE(x)                     (((uint32_t)(((uint32_t)(x)) << DMA_MP_CSR_ACTIVE_SHIFT)) & DMA_MP_CSR_ACTIVE_MASK)
/*! @} */

/*! @name MP_ES - Management Page Error Status */
/*! @{ */

#define DMA_MP_ES_DBE_MASK                       (0x1U)
#define DMA_MP_ES_DBE_SHIFT                      (0U)
/*! DBE - Destination Bus Error
 *  0b0..No destination bus error
 *  0b1..Last recorded error was a bus error on a destination write
 */
#define DMA_MP_ES_DBE(x)                         (((uint32_t)(((uint32_t)(x)) << DMA_MP_ES_DBE_SHIFT)) & DMA_MP_ES_DBE_MASK)

#define DMA_MP_ES_SBE_MASK                       (0x2U)
#define DMA_MP_ES_SBE_SHIFT                      (1U)
/*! SBE - Source Bus Error
 *  0b0..No source bus error
 *  0b1..Last recorded error was a bus error on a source read
 */
#define DMA_MP_ES_SBE(x)                         (((uint32_t)(((uint32_t)(x)) << DMA_MP_ES_SBE_SHIFT)) & DMA_MP_ES_SBE_MASK)

#define DMA_MP_ES_SGE_MASK                       (0x4U)
#define DMA_MP_ES_SGE_SHIFT                      (2U)
/*! SGE - Scatter/Gather Configuration Error
 *  0b0..No scatter/gather configuration error
 *  0b1..Last recorded error was a configuration error detected in the TCDn_DLAST_SGA field
 */
#define DMA_MP_ES_SGE(x)                         (((uint32_t)(((uint32_t)(x)) << DMA_MP_ES_SGE_SHIFT)) & DMA_MP_ES_SGE_MASK)

#define DMA_MP_ES_NCE_MASK                       (0x8U)
#define DMA_MP_ES_NCE_SHIFT                      (3U)
/*! NCE - NBYTES/CITER Configuration Error
 *  0b0..No NBYTES/CITER configuration error
 *  0b1..The last recorded error was NBYTES equal to zero or a CITER not equal to BITER error
 */
#define DMA_MP_ES_NCE(x)                         (((uint32_t)(((uint32_t)(x)) << DMA_MP_ES_NCE_SHIFT)) & DMA_MP_ES_NCE_MASK)

#define DMA_MP_ES_DOE_MASK                       (0x10U)
#define DMA_MP_ES_DOE_SHIFT                      (4U)
/*! DOE - Destination Offset Error
 *  0b0..No destination offset configuration error
 *  0b1..Last recorded error was a configuration error detected in the TCDn_DOFF field
 */
#define DMA_MP_ES_DOE(x)                         (((uint32_t)(((uint32_t)(x)) << DMA_MP_ES_DOE_SHIFT)) & DMA_MP_ES_DOE_MASK)

#define DMA_MP_ES_DAE_MASK                       (0x20U)
#define DMA_MP_ES_DAE_SHIFT                      (5U)
/*! DAE - Destination Address Error
 *  0b0..No destination address configuration error
 *  0b1..Last recorded error was a configuration error detected in the TCDn_DADDR field
 */
#define DMA_MP_ES_DAE(x)                         (((uint32_t)(((uint32_t)(x)) << DMA_MP_ES_DAE_SHIFT)) & DMA_MP_ES_DAE_MASK)

#define DMA_MP_ES_SOE_MASK                       (0x40U)
#define DMA_MP_ES_SOE_SHIFT                      (6U)
/*! SOE - Source Offset Error
 *  0b0..No source offset configuration error
 *  0b1..Last recorded error was a configuration error detected in the TCDn_SOFF field
 */
#define DMA_MP_ES_SOE(x)                         (((uint32_t)(((uint32_t)(x)) << DMA_MP_ES_SOE_SHIFT)) & DMA_MP_ES_SOE_MASK)

#define DMA_MP_ES_SAE_MASK                       (0x80U)
#define DMA_MP_ES_SAE_SHIFT                      (7U)
/*! SAE - Source Address Error
 *  0b0..No source address configuration error
 *  0b1..Last recorded error was a configuration error detected in the TCDn_SADDR field
 */
#define DMA_MP_ES_SAE(x)                         (((uint32_t)(((uint32_t)(x)) << DMA_MP_ES_SAE_SHIFT)) & DMA_MP_ES_SAE_MASK)

#define DMA_MP_ES_ECX_MASK                       (0x100U)
#define DMA_MP_ES_ECX_SHIFT                      (8U)
/*! ECX - Transfer Canceled
 *  0b0..No canceled transfers
 *  0b1..Last recorded entry was a canceled transfer by the error cancel transfer input
 */
#define DMA_MP_ES_ECX(x)                         (((uint32_t)(((uint32_t)(x)) << DMA_MP_ES_ECX_SHIFT)) & DMA_MP_ES_ECX_MASK)

#define DMA_MP_ES_ERRCHN_MASK                    (0xF000000U)
#define DMA_MP_ES_ERRCHN_SHIFT                   (24U)
/*! ERRCHN - Error Channel Number or Canceled Channel Number
 */
#define DMA_MP_ES_ERRCHN(x)                      (((uint32_t)(((uint32_t)(x)) << DMA_MP_ES_ERRCHN_SHIFT)) & DMA_MP_ES_ERRCHN_MASK)

#define DMA_MP_ES_VLD_MASK                       (0x80000000U)
#define DMA_MP_ES_VLD_SHIFT                      (31U)
/*! VLD - Valid
 *  0b0..No ERR fields are set to 1
 *  0b1..At least one ERR field is set to 1, indicating a valid error exists that software has not cleared
 */
#define DMA_MP_ES_VLD(x)                         (((uint32_t)(((uint32_t)(x)) << DMA_MP_ES_VLD_SHIFT)) & DMA_MP_ES_VLD_MASK)
/*! @} */

/*! @name MP_INT - Management Page Interrupt Request Status */
/*! @{ */

#define DMA_MP_INT_INT_MASK                      (0xFFFFU)
#define DMA_MP_INT_INT_SHIFT                     (0U)
/*! INT - Interrupt Request Status
 */
#define DMA_MP_INT_INT(x)                        (((uint32_t)(((uint32_t)(x)) << DMA_MP_INT_INT_SHIFT)) & DMA_MP_INT_INT_MASK)
/*! @} */

/*! @name MP_HRS - Management Page Hardware Request Status */
/*! @{ */

#define DMA_MP_HRS_HRS_MASK                      (0xFFFFFFFFU)
#define DMA_MP_HRS_HRS_SHIFT                     (0U)
/*! HRS - Hardware Request Status
 */
#define DMA_MP_HRS_HRS(x)                        (((uint32_t)(((uint32_t)(x)) << DMA_MP_HRS_HRS_SHIFT)) & DMA_MP_HRS_HRS_MASK)
/*! @} */

/*! @name CH_GRPRI - Channel Arbitration Group */
/*! @{ */

#define DMA_CH_GRPRI_GRPRI_MASK                  (0x1FU)
#define DMA_CH_GRPRI_GRPRI_SHIFT                 (0U)
/*! GRPRI - Arbitration Group For Channel n
 */
#define DMA_CH_GRPRI_GRPRI(x)                    (((uint32_t)(((uint32_t)(x)) << DMA_CH_GRPRI_GRPRI_SHIFT)) & DMA_CH_GRPRI_GRPRI_MASK)
/*! @} */

/* The count of DMA_CH_GRPRI */
#define DMA_CH_GRPRI_COUNT                       (16U)

/*! @name CH_CSR - Channel Control and Status */
/*! @{ */

#define DMA_CH_CSR_ERQ_MASK                      (0x1U)
#define DMA_CH_CSR_ERQ_SHIFT                     (0U)
/*! ERQ - Enable DMA Request
 *  0b0..DMA hardware request signal for corresponding channel disabled
 *  0b1..DMA hardware request signal for corresponding channel enabled
 */
#define DMA_CH_CSR_ERQ(x)                        (((uint32_t)(((uint32_t)(x)) << DMA_CH_CSR_ERQ_SHIFT)) & DMA_CH_CSR_ERQ_MASK)

#define DMA_CH_CSR_EARQ_MASK                     (0x2U)
#define DMA_CH_CSR_EARQ_SHIFT                    (1U)
/*! EARQ - Enable Asynchronous DMA Request
 *  0b0..Disable asynchronous DMA request for the channel
 *  0b1..Enable asynchronous DMA request for the channel
 */
#define DMA_CH_CSR_EARQ(x)                       (((uint32_t)(((uint32_t)(x)) << DMA_CH_CSR_EARQ_SHIFT)) & DMA_CH_CSR_EARQ_MASK)

#define DMA_CH_CSR_EEI_MASK                      (0x4U)
#define DMA_CH_CSR_EEI_SHIFT                     (2U)
/*! EEI - Enable Error Interrupt
 *  0b0..Error signal for corresponding channel does not generate error interrupt
 *  0b1..Assertion of error signal for corresponding channel generates error interrupt request
 */
#define DMA_CH_CSR_EEI(x)                        (((uint32_t)(((uint32_t)(x)) << DMA_CH_CSR_EEI_SHIFT)) & DMA_CH_CSR_EEI_MASK)

#define DMA_CH_CSR_EBW_MASK                      (0x8U)
#define DMA_CH_CSR_EBW_SHIFT                     (3U)
/*! EBW - Enable Buffered Writes
 *  0b0..Buffered writes on system bus disabled
 *  0b1..Buffered writes on system bus enabled
 */
#define DMA_CH_CSR_EBW(x)                        (((uint32_t)(((uint32_t)(x)) << DMA_CH_CSR_EBW_SHIFT)) & DMA_CH_CSR_EBW_MASK)

#define DMA_CH_CSR_DONE_MASK                     (0x40000000U)
#define DMA_CH_CSR_DONE_SHIFT                    (30U)
/*! DONE - Channel Done
 */
#define DMA_CH_CSR_DONE(x)                       (((uint32_t)(((uint32_t)(x)) << DMA_CH_CSR_DONE_SHIFT)) & DMA_CH_CSR_DONE_MASK)

#define DMA_CH_CSR_ACTIVE_MASK                   (0x80000000U)
#define DMA_CH_CSR_ACTIVE_SHIFT                  (31U)
/*! ACTIVE - Channel Active
 */
#define DMA_CH_CSR_ACTIVE(x)                     (((uint32_t)(((uint32_t)(x)) << DMA_CH_CSR_ACTIVE_SHIFT)) & DMA_CH_CSR_ACTIVE_MASK)
/*! @} */

/* The count of DMA_CH_CSR */
#define DMA_CH_CSR_COUNT                         (16U)

/*! @name CH_ES - Channel Error Status */
/*! @{ */

#define DMA_CH_ES_DBE_MASK                       (0x1U)
#define DMA_CH_ES_DBE_SHIFT                      (0U)
/*! DBE - Destination Bus Error
 *  0b0..No destination bus error
 *  0b1..Last recorded error was bus error on destination write
 */
#define DMA_CH_ES_DBE(x)                         (((uint32_t)(((uint32_t)(x)) << DMA_CH_ES_DBE_SHIFT)) & DMA_CH_ES_DBE_MASK)

#define DMA_CH_ES_SBE_MASK                       (0x2U)
#define DMA_CH_ES_SBE_SHIFT                      (1U)
/*! SBE - Source Bus Error
 *  0b0..No source bus error
 *  0b1..Last recorded error was bus error on source read
 */
#define DMA_CH_ES_SBE(x)                         (((uint32_t)(((uint32_t)(x)) << DMA_CH_ES_SBE_SHIFT)) & DMA_CH_ES_SBE_MASK)

#define DMA_CH_ES_SGE_MASK                       (0x4U)
#define DMA_CH_ES_SGE_SHIFT                      (2U)
/*! SGE - Scatter/Gather Configuration Error
 *  0b0..No scatter/gather configuration error
 *  0b1..Last recorded error was a configuration error detected in the TCDn_DLAST_SGA field
 */
#define DMA_CH_ES_SGE(x)                         (((uint32_t)(((uint32_t)(x)) << DMA_CH_ES_SGE_SHIFT)) & DMA_CH_ES_SGE_MASK)

#define DMA_CH_ES_NCE_MASK                       (0x8U)
#define DMA_CH_ES_NCE_SHIFT                      (3U)
/*! NCE - NBYTES/CITER Configuration Error
 *  0b0..No NBYTES/CITER configuration error
 *  0b1..Last recorded error was a configuration error detected in the TCDn_NBYTES or TCDn_CITER fields
 */
#define DMA_CH_ES_NCE(x)                         (((uint32_t)(((uint32_t)(x)) << DMA_CH_ES_NCE_SHIFT)) & DMA_CH_ES_NCE_MASK)

#define DMA_CH_ES_DOE_MASK                       (0x10U)
#define DMA_CH_ES_DOE_SHIFT                      (4U)
/*! DOE - Destination Offset Error
 *  0b0..No destination offset configuration error
 *  0b1..Last recorded error was a configuration error detected in the TCDn_DOFF field
 */
#define DMA_CH_ES_DOE(x)                         (((uint32_t)(((uint32_t)(x)) << DMA_CH_ES_DOE_SHIFT)) & DMA_CH_ES_DOE_MASK)

#define DMA_CH_ES_DAE_MASK                       (0x20U)
#define DMA_CH_ES_DAE_SHIFT                      (5U)
/*! DAE - Destination Address Error
 *  0b0..No destination address configuration error
 *  0b1..Last recorded error was a configuration error detected in the TCDn_DADDR field
 */
#define DMA_CH_ES_DAE(x)                         (((uint32_t)(((uint32_t)(x)) << DMA_CH_ES_DAE_SHIFT)) & DMA_CH_ES_DAE_MASK)

#define DMA_CH_ES_SOE_MASK                       (0x40U)
#define DMA_CH_ES_SOE_SHIFT                      (6U)
/*! SOE - Source Offset Error
 *  0b0..No source offset configuration error
 *  0b1..Last recorded error was a configuration error detected in the TCDn_SOFF field
 */
#define DMA_CH_ES_SOE(x)                         (((uint32_t)(((uint32_t)(x)) << DMA_CH_ES_SOE_SHIFT)) & DMA_CH_ES_SOE_MASK)

#define DMA_CH_ES_SAE_MASK                       (0x80U)
#define DMA_CH_ES_SAE_SHIFT                      (7U)
/*! SAE - Source Address Error
 *  0b0..No source address configuration error
 *  0b1..Last recorded error was a configuration error detected in the TCDn_SADDR field
 */
#define DMA_CH_ES_SAE(x)                         (((uint32_t)(((uint32_t)(x)) << DMA_CH_ES_SAE_SHIFT)) & DMA_CH_ES_SAE_MASK)

#define DMA_CH_ES_ERR_MASK                       (0x80000000U)
#define DMA_CH_ES_ERR_SHIFT                      (31U)
/*! ERR - Error In Channel
 *  0b0..An error in this channel has not occurred
 *  0b1..An error in this channel has occurred
 */
#define DMA_CH_ES_ERR(x)                         (((uint32_t)(((uint32_t)(x)) << DMA_CH_ES_ERR_SHIFT)) & DMA_CH_ES_ERR_MASK)
/*! @} */

/* The count of DMA_CH_ES */
#define DMA_CH_ES_COUNT                          (16U)

/*! @name CH_INT - Channel Interrupt Status */
/*! @{ */

#define DMA_CH_INT_INT_MASK                      (0x1U)
#define DMA_CH_INT_INT_SHIFT                     (0U)
/*! INT - Interrupt Request
 *  0b0..Interrupt request for corresponding channel cleared
 *  0b1..Interrupt request for corresponding channel active
 */
#define DMA_CH_INT_INT(x)                        (((uint32_t)(((uint32_t)(x)) << DMA_CH_INT_INT_SHIFT)) & DMA_CH_INT_INT_MASK)
/*! @} */

/* The count of DMA_CH_INT */
#define DMA_CH_INT_COUNT                         (16U)

/*! @name CH_SBR - Channel System Bus */
/*! @{ */

#define DMA_CH_SBR_MID_MASK                      (0x3FU)
#define DMA_CH_SBR_MID_SHIFT                     (0U)
/*! MID - Master ID
 */
#define DMA_CH_SBR_MID(x)                        (((uint32_t)(((uint32_t)(x)) << DMA_CH_SBR_MID_SHIFT)) & DMA_CH_SBR_MID_MASK)

#define DMA_CH_SBR_SEC_MASK                      (0x4000U)
#define DMA_CH_SBR_SEC_SHIFT                     (14U)
/*! SEC - Security Level
 *  0b0..Nonsecure protection level for DMA transfers
 *  0b1..Secure protection level for DMA transfers
 */
#define DMA_CH_SBR_SEC(x)                        (((uint32_t)(((uint32_t)(x)) << DMA_CH_SBR_SEC_SHIFT)) & DMA_CH_SBR_SEC_MASK)

#define DMA_CH_SBR_PAL_MASK                      (0x8000U)
#define DMA_CH_SBR_PAL_SHIFT                     (15U)
/*! PAL - Privileged Access Level
 *  0b0..User protection level for DMA transfers
 *  0b1..Privileged protection level for DMA transfers
 */
#define DMA_CH_SBR_PAL(x)                        (((uint32_t)(((uint32_t)(x)) << DMA_CH_SBR_PAL_SHIFT)) & DMA_CH_SBR_PAL_MASK)

#define DMA_CH_SBR_EMI_MASK                      (0x10000U)
#define DMA_CH_SBR_EMI_SHIFT                     (16U)
/*! EMI - Enable Master ID Replication
 *  0b0..Master ID replication is disabled
 *  0b1..Master ID replication is enabled
 */
#define DMA_CH_SBR_EMI(x)                        (((uint32_t)(((uint32_t)(x)) << DMA_CH_SBR_EMI_SHIFT)) & DMA_CH_SBR_EMI_MASK)

#define DMA_CH_SBR_ATTR_MASK                     (0x1E0000U)
#define DMA_CH_SBR_ATTR_SHIFT                    (17U)
/*! ATTR - Attribute Output
 */
#define DMA_CH_SBR_ATTR(x)                       (((uint32_t)(((uint32_t)(x)) << DMA_CH_SBR_ATTR_SHIFT)) & DMA_CH_SBR_ATTR_MASK)
/*! @} */

/* The count of DMA_CH_SBR */
#define DMA_CH_SBR_COUNT                         (16U)

/*! @name CH_PRI - Channel Priority */
/*! @{ */

#define DMA_CH_PRI_APL_MASK                      (0x7U)
#define DMA_CH_PRI_APL_SHIFT                     (0U)
/*! APL - Arbitration Priority Level
 */
#define DMA_CH_PRI_APL(x)                        (((uint32_t)(((uint32_t)(x)) << DMA_CH_PRI_APL_SHIFT)) & DMA_CH_PRI_APL_MASK)

#define DMA_CH_PRI_DPA_MASK                      (0x40000000U)
#define DMA_CH_PRI_DPA_SHIFT                     (30U)
/*! DPA - Disable Preempt Ability
 *  0b0..Channel can suspend a lower-priority channel
 *  0b1..Channel cannot suspend any other channel, regardless of channel priority
 */
#define DMA_CH_PRI_DPA(x)                        (((uint32_t)(((uint32_t)(x)) << DMA_CH_PRI_DPA_SHIFT)) & DMA_CH_PRI_DPA_MASK)

#define DMA_CH_PRI_ECP_MASK                      (0x80000000U)
#define DMA_CH_PRI_ECP_SHIFT                     (31U)
/*! ECP - Enable Channel Preemption
 *  0b0..Channel cannot be suspended by a higher-priority channel's service request
 *  0b1..Channel can be temporarily suspended by a higher-priority channel's service request
 */
#define DMA_CH_PRI_ECP(x)                        (((uint32_t)(((uint32_t)(x)) << DMA_CH_PRI_ECP_SHIFT)) & DMA_CH_PRI_ECP_MASK)
/*! @} */

/* The count of DMA_CH_PRI */
#define DMA_CH_PRI_COUNT                         (16U)

/*! @name CH_MUX - Channel Multiplexor Configuration */
/*! @{ */

#define DMA_CH_MUX_SRC_MASK                      (0x7FU)
#define DMA_CH_MUX_SRC_SHIFT                     (0U)
/*! SRC - Service Request Source
 */
#define DMA_CH_MUX_SRC(x)                        (((uint32_t)(((uint32_t)(x)) << DMA_CH_MUX_SRC_SHIFT)) & DMA_CH_MUX_SRC_MASK)
/*! @} */

/* The count of DMA_CH_MUX */
#define DMA_CH_MUX_COUNT                         (16U)

/*! @name TCD_SADDR - TCD Source Address */
/*! @{ */

#define DMA_TCD_SADDR_SADDR_MASK                 (0xFFFFFFFFU)
#define DMA_TCD_SADDR_SADDR_SHIFT                (0U)
/*! SADDR - Source Address
 */
#define DMA_TCD_SADDR_SADDR(x)                   (((uint32_t)(((uint32_t)(x)) << DMA_TCD_SADDR_SADDR_SHIFT)) & DMA_TCD_SADDR_SADDR_MASK)
/*! @} */

/* The count of DMA_TCD_SADDR */
#define DMA_TCD_SADDR_COUNT                      (16U)

/*! @name TCD_SOFF - TCD Signed Source Address Offset */
/*! @{ */

#define DMA_TCD_SOFF_SOFF_MASK                   (0xFFFFU)
#define DMA_TCD_SOFF_SOFF_SHIFT                  (0U)
/*! SOFF - Source Address Signed Offset
 */
#define DMA_TCD_SOFF_SOFF(x)                     (((uint16_t)(((uint16_t)(x)) << DMA_TCD_SOFF_SOFF_SHIFT)) & DMA_TCD_SOFF_SOFF_MASK)
/*! @} */

/* The count of DMA_TCD_SOFF */
#define DMA_TCD_SOFF_COUNT                       (16U)

/*! @name TCD_ATTR - TCD Transfer Attributes */
/*! @{ */

#define DMA_TCD_ATTR_DSIZE_MASK                  (0x7U)
#define DMA_TCD_ATTR_DSIZE_SHIFT                 (0U)
/*! DSIZE - Destination Data Transfer Size
 */
#define DMA_TCD_ATTR_DSIZE(x)                    (((uint16_t)(((uint16_t)(x)) << DMA_TCD_ATTR_DSIZE_SHIFT)) & DMA_TCD_ATTR_DSIZE_MASK)

#define DMA_TCD_ATTR_DMOD_MASK                   (0xF8U)
#define DMA_TCD_ATTR_DMOD_SHIFT                  (3U)
/*! DMOD - Destination Address Modulo
 */
#define DMA_TCD_ATTR_DMOD(x)                     (((uint16_t)(((uint16_t)(x)) << DMA_TCD_ATTR_DMOD_SHIFT)) & DMA_TCD_ATTR_DMOD_MASK)

#define DMA_TCD_ATTR_SSIZE_MASK                  (0x700U)
#define DMA_TCD_ATTR_SSIZE_SHIFT                 (8U)
/*! SSIZE - Source Data Transfer Size
 *  0b000..8-bit
 *  0b001..16-bit
 *  0b010..32-bit
 *  0b011..64-bit
 *  0b100..16-byte
 *  0b101..32-byte
 *  0b110..
 *  0b111..
 */
#define DMA_TCD_ATTR_SSIZE(x)                    (((uint16_t)(((uint16_t)(x)) << DMA_TCD_ATTR_SSIZE_SHIFT)) & DMA_TCD_ATTR_SSIZE_MASK)

#define DMA_TCD_ATTR_SMOD_MASK                   (0xF800U)
#define DMA_TCD_ATTR_SMOD_SHIFT                  (11U)
/*! SMOD - Source Address Modulo
 *  0b00000..Source address modulo feature disabled
 *  0b00001..Source address modulo feature enabled for any non-zero value [1-31]
 */
#define DMA_TCD_ATTR_SMOD(x)                     (((uint16_t)(((uint16_t)(x)) << DMA_TCD_ATTR_SMOD_SHIFT)) & DMA_TCD_ATTR_SMOD_MASK)
/*! @} */

/* The count of DMA_TCD_ATTR */
#define DMA_TCD_ATTR_COUNT                       (16U)

/*! @name TCD_NBYTES_MLOFFNO - TCD Transfer Size Without Minor Loop Offsets */
/*! @{ */

#define DMA_TCD_NBYTES_MLOFFNO_NBYTES_MASK       (0x3FFFFFFFU)
#define DMA_TCD_NBYTES_MLOFFNO_NBYTES_SHIFT      (0U)
/*! NBYTES - Number of Bytes To Transfer Per Service Request
 */
#define DMA_TCD_NBYTES_MLOFFNO_NBYTES(x)         (((uint32_t)(((uint32_t)(x)) << DMA_TCD_NBYTES_MLOFFNO_NBYTES_SHIFT)) & DMA_TCD_NBYTES_MLOFFNO_NBYTES_MASK)

#define DMA_TCD_NBYTES_MLOFFNO_DMLOE_MASK        (0x40000000U)
#define DMA_TCD_NBYTES_MLOFFNO_DMLOE_SHIFT       (30U)
/*! DMLOE - Destination Minor Loop Offset Enable
 *  0b0..Minor loop offset not applied to DADDR
 *  0b1..Minor loop offset applied to DADDR
 */
#define DMA_TCD_NBYTES_MLOFFNO_DMLOE(x)          (((uint32_t)(((uint32_t)(x)) << DMA_TCD_NBYTES_MLOFFNO_DMLOE_SHIFT)) & DMA_TCD_NBYTES_MLOFFNO_DMLOE_MASK)

#define DMA_TCD_NBYTES_MLOFFNO_SMLOE_MASK        (0x80000000U)
#define DMA_TCD_NBYTES_MLOFFNO_SMLOE_SHIFT       (31U)
/*! SMLOE - Source Minor Loop Offset Enable
 *  0b0..Minor loop offset not applied to SADDR
 *  0b1..Minor loop offset applied to SADDR
 */
#define DMA_TCD_NBYTES_MLOFFNO_SMLOE(x)          (((uint32_t)(((uint32_t)(x)) << DMA_TCD_NBYTES_MLOFFNO_SMLOE_SHIFT)) & DMA_TCD_NBYTES_MLOFFNO_SMLOE_MASK)
/*! @} */

/* The count of DMA_TCD_NBYTES_MLOFFNO */
#define DMA_TCD_NBYTES_MLOFFNO_COUNT             (16U)

/*! @name TCD_NBYTES_MLOFFYES - TCD Transfer Size with Minor Loop Offsets */
/*! @{ */

#define DMA_TCD_NBYTES_MLOFFYES_NBYTES_MASK      (0x3FFU)
#define DMA_TCD_NBYTES_MLOFFYES_NBYTES_SHIFT     (0U)
/*! NBYTES - Number of Bytes To Transfer Per Service Request
 */
#define DMA_TCD_NBYTES_MLOFFYES_NBYTES(x)        (((uint32_t)(((uint32_t)(x)) << DMA_TCD_NBYTES_MLOFFYES_NBYTES_SHIFT)) & DMA_TCD_NBYTES_MLOFFYES_NBYTES_MASK)

#define DMA_TCD_NBYTES_MLOFFYES_MLOFF_MASK       (0x3FFFFC00U)
#define DMA_TCD_NBYTES_MLOFFYES_MLOFF_SHIFT      (10U)
/*! MLOFF - Minor Loop Offset
 */
#define DMA_TCD_NBYTES_MLOFFYES_MLOFF(x)         (((uint32_t)(((uint32_t)(x)) << DMA_TCD_NBYTES_MLOFFYES_MLOFF_SHIFT)) & DMA_TCD_NBYTES_MLOFFYES_MLOFF_MASK)

#define DMA_TCD_NBYTES_MLOFFYES_DMLOE_MASK       (0x40000000U)
#define DMA_TCD_NBYTES_MLOFFYES_DMLOE_SHIFT      (30U)
/*! DMLOE - Destination Minor Loop Offset Enable
 *  0b0..Minor loop offset not applied to DADDR
 *  0b1..Minor loop offset applied to DADDR
 */
#define DMA_TCD_NBYTES_MLOFFYES_DMLOE(x)         (((uint32_t)(((uint32_t)(x)) << DMA_TCD_NBYTES_MLOFFYES_DMLOE_SHIFT)) & DMA_TCD_NBYTES_MLOFFYES_DMLOE_MASK)

#define DMA_TCD_NBYTES_MLOFFYES_SMLOE_MASK       (0x80000000U)
#define DMA_TCD_NBYTES_MLOFFYES_SMLOE_SHIFT      (31U)
/*! SMLOE - Source Minor Loop Offset Enable
 *  0b0..Minor loop offset not applied to SADDR
 *  0b1..Minor loop offset applied to SADDR
 */
#define DMA_TCD_NBYTES_MLOFFYES_SMLOE(x)         (((uint32_t)(((uint32_t)(x)) << DMA_TCD_NBYTES_MLOFFYES_SMLOE_SHIFT)) & DMA_TCD_NBYTES_MLOFFYES_SMLOE_MASK)
/*! @} */

/* The count of DMA_TCD_NBYTES_MLOFFYES */
#define DMA_TCD_NBYTES_MLOFFYES_COUNT            (16U)

/*! @name TCD_SLAST_SDA - TCD Last Source Address Adjustment / Store DADDR Address */
/*! @{ */

#define DMA_TCD_SLAST_SDA_SLAST_SDA_MASK         (0xFFFFFFFFU)
#define DMA_TCD_SLAST_SDA_SLAST_SDA_SHIFT        (0U)
/*! SLAST_SDA - Last Source Address Adjustment / Store DADDR Address
 */
#define DMA_TCD_SLAST_SDA_SLAST_SDA(x)           (((uint32_t)(((uint32_t)(x)) << DMA_TCD_SLAST_SDA_SLAST_SDA_SHIFT)) & DMA_TCD_SLAST_SDA_SLAST_SDA_MASK)
/*! @} */

/* The count of DMA_TCD_SLAST_SDA */
#define DMA_TCD_SLAST_SDA_COUNT                  (16U)

/*! @name TCD_DADDR - TCD Destination Address */
/*! @{ */

#define DMA_TCD_DADDR_DADDR_MASK                 (0xFFFFFFFFU)
#define DMA_TCD_DADDR_DADDR_SHIFT                (0U)
/*! DADDR - Destination Address
 */
#define DMA_TCD_DADDR_DADDR(x)                   (((uint32_t)(((uint32_t)(x)) << DMA_TCD_DADDR_DADDR_SHIFT)) & DMA_TCD_DADDR_DADDR_MASK)
/*! @} */

/* The count of DMA_TCD_DADDR */
#define DMA_TCD_DADDR_COUNT                      (16U)

/*! @name TCD_DOFF - TCD Signed Destination Address Offset */
/*! @{ */

#define DMA_TCD_DOFF_DOFF_MASK                   (0xFFFFU)
#define DMA_TCD_DOFF_DOFF_SHIFT                  (0U)
/*! DOFF - Destination Address Signed Offset
 */
#define DMA_TCD_DOFF_DOFF(x)                     (((uint16_t)(((uint16_t)(x)) << DMA_TCD_DOFF_DOFF_SHIFT)) & DMA_TCD_DOFF_DOFF_MASK)
/*! @} */

/* The count of DMA_TCD_DOFF */
#define DMA_TCD_DOFF_COUNT                       (16U)

/*! @name TCD_CITER_ELINKNO - TCD Current Major Loop Count (Minor Loop Channel Linking Disabled) */
/*! @{ */

#define DMA_TCD_CITER_ELINKNO_CITER_MASK         (0x7FFFU)
#define DMA_TCD_CITER_ELINKNO_CITER_SHIFT        (0U)
/*! CITER - Current Major Iteration Count
 */
#define DMA_TCD_CITER_ELINKNO_CITER(x)           (((uint16_t)(((uint16_t)(x)) << DMA_TCD_CITER_ELINKNO_CITER_SHIFT)) & DMA_TCD_CITER_ELINKNO_CITER_MASK)

#define DMA_TCD_CITER_ELINKNO_ELINK_MASK         (0x8000U)
#define DMA_TCD_CITER_ELINKNO_ELINK_SHIFT        (15U)
/*! ELINK - Enable Link
 *  0b0..Channel-to-channel linking disabled
 *  0b1..Channel-to-channel linking enabled
 */
#define DMA_TCD_CITER_ELINKNO_ELINK(x)           (((uint16_t)(((uint16_t)(x)) << DMA_TCD_CITER_ELINKNO_ELINK_SHIFT)) & DMA_TCD_CITER_ELINKNO_ELINK_MASK)
/*! @} */

/* The count of DMA_TCD_CITER_ELINKNO */
#define DMA_TCD_CITER_ELINKNO_COUNT              (16U)

/*! @name TCD_CITER_ELINKYES - TCD Current Major Loop Count (Minor Loop Channel Linking Enabled) */
/*! @{ */

#define DMA_TCD_CITER_ELINKYES_CITER_MASK        (0x1FFU)
#define DMA_TCD_CITER_ELINKYES_CITER_SHIFT       (0U)
/*! CITER - Current Major Iteration Count
 */
#define DMA_TCD_CITER_ELINKYES_CITER(x)          (((uint16_t)(((uint16_t)(x)) << DMA_TCD_CITER_ELINKYES_CITER_SHIFT)) & DMA_TCD_CITER_ELINKYES_CITER_MASK)

#define DMA_TCD_CITER_ELINKYES_LINKCH_MASK       (0x1E00U)
#define DMA_TCD_CITER_ELINKYES_LINKCH_SHIFT      (9U)
/*! LINKCH - Minor Loop Link Channel Number
 */
#define DMA_TCD_CITER_ELINKYES_LINKCH(x)         (((uint16_t)(((uint16_t)(x)) << DMA_TCD_CITER_ELINKYES_LINKCH_SHIFT)) & DMA_TCD_CITER_ELINKYES_LINKCH_MASK)

#define DMA_TCD_CITER_ELINKYES_ELINK_MASK        (0x8000U)
#define DMA_TCD_CITER_ELINKYES_ELINK_SHIFT       (15U)
/*! ELINK - Enable Link
 *  0b0..Channel-to-channel linking disabled
 *  0b1..Channel-to-channel linking enabled
 */
#define DMA_TCD_CITER_ELINKYES_ELINK(x)          (((uint16_t)(((uint16_t)(x)) << DMA_TCD_CITER_ELINKYES_ELINK_SHIFT)) & DMA_TCD_CITER_ELINKYES_ELINK_MASK)
/*! @} */

/* The count of DMA_TCD_CITER_ELINKYES */
#define DMA_TCD_CITER_ELINKYES_COUNT             (16U)

/*! @name TCD_DLAST_SGA - TCD Last Destination Address Adjustment / Scatter Gather Address */
/*! @{ */

#define DMA_TCD_DLAST_SGA_DLAST_SGA_MASK         (0xFFFFFFFFU)
#define DMA_TCD_DLAST_SGA_DLAST_SGA_SHIFT        (0U)
/*! DLAST_SGA - Last Destination Address Adjustment / Scatter Gather Address
 */
#define DMA_TCD_DLAST_SGA_DLAST_SGA(x)           (((uint32_t)(((uint32_t)(x)) << DMA_TCD_DLAST_SGA_DLAST_SGA_SHIFT)) & DMA_TCD_DLAST_SGA_DLAST_SGA_MASK)
/*! @} */

/* The count of DMA_TCD_DLAST_SGA */
#define DMA_TCD_DLAST_SGA_COUNT                  (16U)

/*! @name TCD_CSR - TCD Control and Status */
/*! @{ */

#define DMA_TCD_CSR_START_MASK                   (0x1U)
#define DMA_TCD_CSR_START_SHIFT                  (0U)
/*! START - Channel Start
 *  0b0..Channel not explicitly started
 *  0b1..Channel explicitly started via a software-initiated service request
 */
#define DMA_TCD_CSR_START(x)                     (((uint16_t)(((uint16_t)(x)) << DMA_TCD_CSR_START_SHIFT)) & DMA_TCD_CSR_START_MASK)

#define DMA_TCD_CSR_INTMAJOR_MASK                (0x2U)
#define DMA_TCD_CSR_INTMAJOR_SHIFT               (1U)
/*! INTMAJOR - Enable Interrupt If Major count complete
 *  0b0..End-of-major loop interrupt disabled
 *  0b1..End-of-major loop interrupt enabled
 */
#define DMA_TCD_CSR_INTMAJOR(x)                  (((uint16_t)(((uint16_t)(x)) << DMA_TCD_CSR_INTMAJOR_SHIFT)) & DMA_TCD_CSR_INTMAJOR_MASK)

#define DMA_TCD_CSR_INTHALF_MASK                 (0x4U)
#define DMA_TCD_CSR_INTHALF_SHIFT                (2U)
/*! INTHALF - Enable Interrupt If Major Counter Half-complete
 *  0b0..Halfway point interrupt disabled
 *  0b1..Halfway point interrupt enabled
 */
#define DMA_TCD_CSR_INTHALF(x)                   (((uint16_t)(((uint16_t)(x)) << DMA_TCD_CSR_INTHALF_SHIFT)) & DMA_TCD_CSR_INTHALF_MASK)

#define DMA_TCD_CSR_DREQ_MASK                    (0x8U)
#define DMA_TCD_CSR_DREQ_SHIFT                   (3U)
/*! DREQ - Disable Request
 *  0b0..No operation
 *  0b1..Clear the ERQ field to 0 upon major loop completion, thus disabling hardware service requests
 */
#define DMA_TCD_CSR_DREQ(x)                      (((uint16_t)(((uint16_t)(x)) << DMA_TCD_CSR_DREQ_SHIFT)) & DMA_TCD_CSR_DREQ_MASK)

#define DMA_TCD_CSR_ESG_MASK                     (0x10U)
#define DMA_TCD_CSR_ESG_SHIFT                    (4U)
/*! ESG - Enable Scatter/Gather Processing
 *  0b0..Current channel's TCD is normal format
 *  0b1..Current channel's TCD specifies scatter/gather format.
 */
#define DMA_TCD_CSR_ESG(x)                       (((uint16_t)(((uint16_t)(x)) << DMA_TCD_CSR_ESG_SHIFT)) & DMA_TCD_CSR_ESG_MASK)

#define DMA_TCD_CSR_MAJORELINK_MASK              (0x20U)
#define DMA_TCD_CSR_MAJORELINK_SHIFT             (5U)
/*! MAJORELINK - Enable Link When Major Loop Complete
 *  0b0..Channel-to-channel linking disabled
 *  0b1..Channel-to-channel linking enabled
 */
#define DMA_TCD_CSR_MAJORELINK(x)                (((uint16_t)(((uint16_t)(x)) << DMA_TCD_CSR_MAJORELINK_SHIFT)) & DMA_TCD_CSR_MAJORELINK_MASK)

#define DMA_TCD_CSR_EEOP_MASK                    (0x40U)
#define DMA_TCD_CSR_EEOP_SHIFT                   (6U)
/*! EEOP - Enable End-Of-Packet Processing
 *  0b0..End-of-packet operation disabled
 *  0b1..End-of-packet hardware input signal enabled
 */
#define DMA_TCD_CSR_EEOP(x)                      (((uint16_t)(((uint16_t)(x)) << DMA_TCD_CSR_EEOP_SHIFT)) & DMA_TCD_CSR_EEOP_MASK)

#define DMA_TCD_CSR_ESDA_MASK                    (0x80U)
#define DMA_TCD_CSR_ESDA_SHIFT                   (7U)
/*! ESDA - Enable Store Destination Address
 *  0b0..Ability to store destination address to system memory disabled
 *  0b1..Ability to store destination address to system memory enabled
 */
#define DMA_TCD_CSR_ESDA(x)                      (((uint16_t)(((uint16_t)(x)) << DMA_TCD_CSR_ESDA_SHIFT)) & DMA_TCD_CSR_ESDA_MASK)

#define DMA_TCD_CSR_MAJORLINKCH_MASK             (0xF00U)
#define DMA_TCD_CSR_MAJORLINKCH_SHIFT            (8U)
/*! MAJORLINKCH - Major Loop Link Channel Number
 */
#define DMA_TCD_CSR_MAJORLINKCH(x)               (((uint16_t)(((uint16_t)(x)) << DMA_TCD_CSR_MAJORLINKCH_SHIFT)) & DMA_TCD_CSR_MAJORLINKCH_MASK)

#define DMA_TCD_CSR_BWC_MASK                     (0xC000U)
#define DMA_TCD_CSR_BWC_SHIFT                    (14U)
/*! BWC - Bandwidth Control
 *  0b00..No eDMA engine stalls
 *  0b01..
 *  0b10..eDMA engine stalls for 4 cycles after each R/W
 *  0b11..eDMA engine stalls for 8 cycles after each R/W
 */
#define DMA_TCD_CSR_BWC(x)                       (((uint16_t)(((uint16_t)(x)) << DMA_TCD_CSR_BWC_SHIFT)) & DMA_TCD_CSR_BWC_MASK)
/*! @} */

/* The count of DMA_TCD_CSR */
#define DMA_TCD_CSR_COUNT                        (16U)

/*! @name TCD_BITER_ELINKNO - TCD Beginning Major Loop Count (Minor Loop Channel Linking Disabled) */
/*! @{ */

#define DMA_TCD_BITER_ELINKNO_BITER_MASK         (0x7FFFU)
#define DMA_TCD_BITER_ELINKNO_BITER_SHIFT        (0U)
/*! BITER - Starting Major Iteration Count
 */
#define DMA_TCD_BITER_ELINKNO_BITER(x)           (((uint16_t)(((uint16_t)(x)) << DMA_TCD_BITER_ELINKNO_BITER_SHIFT)) & DMA_TCD_BITER_ELINKNO_BITER_MASK)

#define DMA_TCD_BITER_ELINKNO_ELINK_MASK         (0x8000U)
#define DMA_TCD_BITER_ELINKNO_ELINK_SHIFT        (15U)
/*! ELINK - Enables Link
 *  0b0..Channel-to-channel linking disabled
 *  0b1..Channel-to-channel linking enabled
 */
#define DMA_TCD_BITER_ELINKNO_ELINK(x)           (((uint16_t)(((uint16_t)(x)) << DMA_TCD_BITER_ELINKNO_ELINK_SHIFT)) & DMA_TCD_BITER_ELINKNO_ELINK_MASK)
/*! @} */

/* The count of DMA_TCD_BITER_ELINKNO */
#define DMA_TCD_BITER_ELINKNO_COUNT              (16U)

/*! @name TCD_BITER_ELINKYES - TCD Beginning Major Loop Count (Minor Loop Channel Linking Enabled) */
/*! @{ */

#define DMA_TCD_BITER_ELINKYES_BITER_MASK        (0x1FFU)
#define DMA_TCD_BITER_ELINKYES_BITER_SHIFT       (0U)
/*! BITER - Starting Major Iteration Count
 */
#define DMA_TCD_BITER_ELINKYES_BITER(x)          (((uint16_t)(((uint16_t)(x)) << DMA_TCD_BITER_ELINKYES_BITER_SHIFT)) & DMA_TCD_BITER_ELINKYES_BITER_MASK)

#define DMA_TCD_BITER_ELINKYES_LINKCH_MASK       (0x1E00U)
#define DMA_TCD_BITER_ELINKYES_LINKCH_SHIFT      (9U)
/*! LINKCH - Link Channel Number
 */
#define DMA_TCD_BITER_ELINKYES_LINKCH(x)         (((uint16_t)(((uint16_t)(x)) << DMA_TCD_BITER_ELINKYES_LINKCH_SHIFT)) & DMA_TCD_BITER_ELINKYES_LINKCH_MASK)

#define DMA_TCD_BITER_ELINKYES_ELINK_MASK        (0x8000U)
#define DMA_TCD_BITER_ELINKYES_ELINK_SHIFT       (15U)
/*! ELINK - Enable Link
 *  0b0..Channel-to-channel linking disabled
 *  0b1..Channel-to-channel linking enabled
 */
#define DMA_TCD_BITER_ELINKYES_ELINK(x)          (((uint16_t)(((uint16_t)(x)) << DMA_TCD_BITER_ELINKYES_ELINK_SHIFT)) & DMA_TCD_BITER_ELINKYES_ELINK_MASK)
/*! @} */

/* The count of DMA_TCD_BITER_ELINKYES */
#define DMA_TCD_BITER_ELINKYES_COUNT             (16U)


/*!
 * @}
 */ /* end of group DMA_Register_Masks */


/* DMA - Peripheral instance base addresses */
#if (defined(__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE & 0x2))
  /** Peripheral DMA0 base address */
  #define DMA0_BASE                                (0x50002000u)
  /** Peripheral DMA0 base address */
  #define DMA0_BASE_NS                             (0x40002000u)
  /** Peripheral DMA0 base pointer */
  #define DMA0                                     ((DMA_Type *)DMA0_BASE)
  /** Peripheral DMA0 base pointer */
  #define DMA0_NS                                  ((DMA_Type *)DMA0_BASE_NS)
  /** Array initializer of DMA peripheral base addresses */
  #define DMA_BASE_ADDRS                           { DMA0_BASE }
  /** Array initializer of DMA peripheral base pointers */
  #define DMA_BASE_PTRS                            { DMA0 }
  /** Array initializer of DMA peripheral base addresses */
  #define DMA_BASE_ADDRS_NS                        { DMA0_BASE_NS }
  /** Array initializer of DMA peripheral base pointers */
  #define DMA_BASE_PTRS_NS                         { DMA0_NS }
#else
  /** Peripheral DMA0 base address */
  #define DMA0_BASE                                (0x40002000u)
  /** Peripheral DMA0 base pointer */
  #define DMA0                                     ((DMA_Type *)DMA0_BASE)
  /** Array initializer of DMA peripheral base addresses */
  #define DMA_BASE_ADDRS                           { DMA0_BASE }
  /** Array initializer of DMA peripheral base pointers */
  #define DMA_BASE_PTRS                            { DMA0 }
#endif
/** Interrupt vectors for the DMA peripheral type */
#define DMA_IRQS                                 { { DMA0_CH0_IRQn, DMA0_CH1_IRQn, DMA0_CH2_IRQn, DMA0_CH3_IRQn, DMA0_CH4_IRQn, DMA0_CH5_IRQn, DMA0_CH6_IRQn, DMA0_CH7_IRQn, DMA0_CH8_IRQn, DMA0_CH9_IRQn, DMA0_CH10_IRQn, DMA0_CH11_IRQn, DMA0_CH12_IRQn, DMA0_CH13_IRQn, DMA0_CH14_IRQn, DMA0_CH15_IRQn } }


/*!
 * @}
 */ /* end of group DMA_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- DSB Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DSB_Peripheral_Access_Layer DSB Peripheral Access Layer
 * @{
 */

/** DSB - Register Layout Typedef */
typedef struct {
  __IO uint32_t CSR;                               /**< Control Register, offset: 0x0 */
  __IO uint32_t INT;                               /**< Interrupt Request Status Register, offset: 0x4 */
  __IO uint32_t WMC;                               /**< Watermark Configuration Register, offset: 0x8 */
  __I  uint32_t RDATA;                             /**< FIFO Read Data Register, offset: 0xC */
  __IO uint32_t DADDR;                             /**< DMA Destination Address Register, offset: 0x10 */
  __IO uint32_t XCR;                               /**< DMA Transfer Count Register, offset: 0x14 */
} DSB_Type;

/* ----------------------------------------------------------------------------
   -- DSB Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DSB_Register_Masks DSB Register Masks
 * @{
 */

/*! @name CSR - Control Register */
/*! @{ */

#define DSB_CSR_SFTRST_MASK                      (0x1U)
#define DSB_CSR_SFTRST_SHIFT                     (0U)
/*! SFTRST - Soft Reset
 *  0b0..No operation.
 *  0b1..Reset the data stream buffer.
 */
#define DSB_CSR_SFTRST(x)                        (((uint32_t)(((uint32_t)(x)) << DSB_CSR_SFTRST_SHIFT)) & DSB_CSR_SFTRST_MASK)

#define DSB_CSR_DSB_EN_MASK                      (0x2U)
#define DSB_CSR_DSB_EN_SHIFT                     (1U)
/*! DSB_EN - Data Stream Buffer Enable
 *  0b0..Buffer is disabled.
 *  0b1..Buffer is enabled.
 */
#define DSB_CSR_DSB_EN(x)                        (((uint32_t)(((uint32_t)(x)) << DSB_CSR_DSB_EN_SHIFT)) & DSB_CSR_DSB_EN_MASK)

#define DSB_CSR_DMA_EN_MASK                      (0x4U)
#define DSB_CSR_DMA_EN_SHIFT                     (2U)
/*! DMA_EN - DMA Transfer Enable
 *  0b0..DMA transfers are disabled.
 *  0b1..DMA transfers are enabled.
 */
#define DSB_CSR_DMA_EN(x)                        (((uint32_t)(((uint32_t)(x)) << DSB_CSR_DMA_EN_SHIFT)) & DSB_CSR_DMA_EN_MASK)

#define DSB_CSR_INT_EN_MASK                      (0x8U)
#define DSB_CSR_INT_EN_SHIFT                     (3U)
/*! INT_EN - Interrupt Request Enable
 *  0b0..Interrupt requests on data ready or DMA done are disabled.
 *  0b1..Interrupt requests on data ready or DMA done are enabled.
 */
#define DSB_CSR_INT_EN(x)                        (((uint32_t)(((uint32_t)(x)) << DSB_CSR_INT_EN_SHIFT)) & DSB_CSR_INT_EN_MASK)

#define DSB_CSR_ERR_EN_MASK                      (0x10U)
#define DSB_CSR_ERR_EN_SHIFT                     (4U)
/*! ERR_EN - Error Interrupt Request Enable
 *  0b0..Error interrupt requests on overflow, underrun, or bus error are disabled.
 *  0b1..Error interrupt requests on overflow, underrun, or bus error are enabled.
 */
#define DSB_CSR_ERR_EN(x)                        (((uint32_t)(((uint32_t)(x)) << DSB_CSR_ERR_EN_SHIFT)) & DSB_CSR_ERR_EN_MASK)

#define DSB_CSR_CBT_EN_MASK                      (0x20U)
#define DSB_CSR_CBT_EN_SHIFT                     (5U)
/*! CBT_EN - Continuous Burst Transfer Enable
 *  0b0..Continuous burst transfer mode is disabled.
 *  0b1..Continuous burst transfer mode is enabled.
 */
#define DSB_CSR_CBT_EN(x)                        (((uint32_t)(((uint32_t)(x)) << DSB_CSR_CBT_EN_SHIFT)) & DSB_CSR_CBT_EN_MASK)
/*! @} */

/*! @name INT - Interrupt Request Status Register */
/*! @{ */

#define DSB_INT_DRDY_MASK                        (0x1U)
#define DSB_INT_DRDY_SHIFT                       (0U)
/*! DRDY - Data Ready
 *  0b0..No data to read (watermark has not been reached)
 *  0b1..Data is ready to read (watermark has been reached)
 */
#define DSB_INT_DRDY(x)                          (((uint32_t)(((uint32_t)(x)) << DSB_INT_DRDY_SHIFT)) & DSB_INT_DRDY_MASK)

#define DSB_INT_OVRF_MASK                        (0x2U)
#define DSB_INT_OVRF_SHIFT                       (1U)
/*! OVRF - Overflow Error
 *  0b0..No overflow error
 *  0b1..The last recorded error is a buffer overflow
 */
#define DSB_INT_OVRF(x)                          (((uint32_t)(((uint32_t)(x)) << DSB_INT_OVRF_SHIFT)) & DSB_INT_OVRF_MASK)

#define DSB_INT_UNDR_MASK                        (0x4U)
#define DSB_INT_UNDR_SHIFT                       (2U)
/*! UNDR - Underrun Error
 *  0b0..No underrun error
 *  0b1..The last recorded error is an underrun on a read
 */
#define DSB_INT_UNDR(x)                          (((uint32_t)(((uint32_t)(x)) << DSB_INT_UNDR_SHIFT)) & DSB_INT_UNDR_MASK)

#define DSB_INT_DBE_MASK                         (0x8U)
#define DSB_INT_DBE_SHIFT                        (3U)
/*! DBE - Destination Bus Error
 *  0b0..No destination bus error
 *  0b1..The last recorded error is bus error on a write
 */
#define DSB_INT_DBE(x)                           (((uint32_t)(((uint32_t)(x)) << DSB_INT_DBE_SHIFT)) & DSB_INT_DBE_MASK)

#define DSB_INT_DONE_MASK                        (0x10U)
#define DSB_INT_DONE_SHIFT                       (4U)
/*! DONE - DMA Packet Transfer Complete
 *  0b0..Packet transfer not done; CCNT less than TCNT
 *  0b1..Packet transfer is done; TCNT 32-bit words transferred
 */
#define DSB_INT_DONE(x)                          (((uint32_t)(((uint32_t)(x)) << DSB_INT_DONE_SHIFT)) & DSB_INT_DONE_MASK)
/*! @} */

/*! @name WMC - Watermark Configuration Register */
/*! @{ */

#define DSB_WMC_WMRK_MASK                        (0xFU)
#define DSB_WMC_WMRK_SHIFT                       (0U)
/*! WMRK - Watermark
 */
#define DSB_WMC_WMRK(x)                          (((uint32_t)(((uint32_t)(x)) << DSB_WMC_WMRK_SHIFT)) & DSB_WMC_WMRK_MASK)

#define DSB_WMC_CNT_MASK                         (0x1F0000U)
#define DSB_WMC_CNT_SHIFT                        (16U)
/*! CNT - FIFO Count
 */
#define DSB_WMC_CNT(x)                           (((uint32_t)(((uint32_t)(x)) << DSB_WMC_CNT_SHIFT)) & DSB_WMC_CNT_MASK)

#define DSB_WMC_SIZE_MASK                        (0x1F000000U)
#define DSB_WMC_SIZE_SHIFT                       (24U)
/*! SIZE - FIFO size
 */
#define DSB_WMC_SIZE(x)                          (((uint32_t)(((uint32_t)(x)) << DSB_WMC_SIZE_SHIFT)) & DSB_WMC_SIZE_MASK)
/*! @} */

/*! @name RDATA - FIFO Read Data Register */
/*! @{ */

#define DSB_RDATA_DATA_MASK                      (0xFFFFFFFFU)
#define DSB_RDATA_DATA_SHIFT                     (0U)
/*! DATA - FIFO Data
 */
#define DSB_RDATA_DATA(x)                        (((uint32_t)(((uint32_t)(x)) << DSB_RDATA_DATA_SHIFT)) & DSB_RDATA_DATA_MASK)
/*! @} */

/*! @name DADDR - DMA Destination Address Register */
/*! @{ */

#define DSB_DADDR_DADDR_MASK                     (0xFFFFFFFFU)
#define DSB_DADDR_DADDR_SHIFT                    (0U)
/*! DADDR - Destination Address
 */
#define DSB_DADDR_DADDR(x)                       (((uint32_t)(((uint32_t)(x)) << DSB_DADDR_DADDR_SHIFT)) & DSB_DADDR_DADDR_MASK)
/*! @} */

/*! @name XCR - DMA Transfer Count Register */
/*! @{ */

#define DSB_XCR_TCNT_MASK                        (0xFFFFU)
#define DSB_XCR_TCNT_SHIFT                       (0U)
/*! TCNT - Total Transfer Count
 */
#define DSB_XCR_TCNT(x)                          (((uint32_t)(((uint32_t)(x)) << DSB_XCR_TCNT_SHIFT)) & DSB_XCR_TCNT_MASK)

#define DSB_XCR_CCNT_MASK                        (0xFFFF0000U)
#define DSB_XCR_CCNT_SHIFT                       (16U)
/*! CCNT - Current Transfer Count
 */
#define DSB_XCR_CCNT(x)                          (((uint32_t)(((uint32_t)(x)) << DSB_XCR_CCNT_SHIFT)) & DSB_XCR_CCNT_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group DSB_Register_Masks */


/* DSB - Peripheral instance base addresses */
#if (defined(__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE & 0x2))
  /** Peripheral DSB0 base address */
  #define DSB0_BASE                                (0x50041000u)
  /** Peripheral DSB0 base address */
  #define DSB0_BASE_NS                             (0x40041000u)
  /** Peripheral DSB0 base pointer */
  #define DSB0                                     ((DSB_Type *)DSB0_BASE)
  /** Peripheral DSB0 base pointer */
  #define DSB0_NS                                  ((DSB_Type *)DSB0_BASE_NS)
  /** Array initializer of DSB peripheral base addresses */
  #define DSB_BASE_ADDRS                           { DSB0_BASE }
  /** Array initializer of DSB peripheral base pointers */
  #define DSB_BASE_PTRS                            { DSB0 }
  /** Array initializer of DSB peripheral base addresses */
  #define DSB_BASE_ADDRS_NS                        { DSB0_BASE_NS }
  /** Array initializer of DSB peripheral base pointers */
  #define DSB_BASE_PTRS_NS                         { DSB0_NS }
#else
  /** Peripheral DSB0 base address */
  #define DSB0_BASE                                (0x40041000u)
  /** Peripheral DSB0 base pointer */
  #define DSB0                                     ((DSB_Type *)DSB0_BASE)
  /** Array initializer of DSB peripheral base addresses */
  #define DSB_BASE_ADDRS                           { DSB0_BASE }
  /** Array initializer of DSB peripheral base pointers */
  #define DSB_BASE_PTRS                            { DSB0 }
#endif

/*!
 * @}
 */ /* end of group DSB_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- ELEMU Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ELEMU_Peripheral_Access_Layer ELEMU Peripheral Access Layer
 * @{
 */

/** ELEMU - Register Layout Typedef */
typedef struct {
  __I  uint32_t VER;                               /**< Version ID Register, offset: 0x0 */
  __I  uint32_t PAR;                               /**< Parameter Register, offset: 0x4 */
       uint32_t UNUSED0;                           /**< Unused Register 0, offset: 0x8 */
  __I  uint32_t SR;                                /**< Status Register, offset: 0xC */
       uint8_t RESERVED_0[272];
  __IO uint32_t TCR;                               /**< Transmit Control Register, offset: 0x120 */
  __I  uint32_t TSR;                               /**< Transmit Status Register, offset: 0x124 */
       uint8_t RESERVED_1[4];
  __I  uint32_t RSR;                               /**< Receive Status Register, offset: 0x12C */
       uint8_t RESERVED_2[204];
  __IO uint32_t UNUSED1;                           /**< Unused Register 1, offset: 0x1FC */
  __O  uint32_t TR[16];                            /**< Transmit Register, array offset: 0x200, array step: 0x4 */
       uint8_t RESERVED_3[64];
  __I  uint32_t RR[2];                             /**< Receive Register, array offset: 0x280, array step: 0x4 */
       uint8_t RESERVED_4[376];
  __I  uint32_t SEMA4_SR;                          /**< Semaphore Status Register, offset: 0x400 */
       uint8_t RESERVED_5[112];
  __I  uint32_t SEMA4_OWNR;                        /**< Semaphore Ownership Register, offset: 0x474 */
       uint8_t RESERVED_6[1312];
  __I  uint32_t SEMA4_ACQ;                         /**< Semaphore Acquire Register, offset: 0x998 */
       uint8_t RESERVED_7[304];
  __I  uint32_t SEMA4_REL;                         /**< Semaphore Release Register, offset: 0xACC */
       uint8_t RESERVED_8[212];
  __I  uint32_t SEMA4_FREL;                        /**< Semaphore Forced Release Register, offset: 0xBA4 */
} ELEMU_Type;

/* ----------------------------------------------------------------------------
   -- ELEMU Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ELEMU_Register_Masks ELEMU Register Masks
 * @{
 */

/*! @name VER - Version ID Register */
/*! @{ */

#define ELEMU_VER_FEATURE_MASK                   (0xFFFFU)
#define ELEMU_VER_FEATURE_SHIFT                  (0U)
/*! FEATURE - Feature Set Number
 *  0b0000000000000000..Standard features are implemented.
 */
#define ELEMU_VER_FEATURE(x)                     (((uint32_t)(((uint32_t)(x)) << ELEMU_VER_FEATURE_SHIFT)) & ELEMU_VER_FEATURE_MASK)

#define ELEMU_VER_MINOR_MASK                     (0xFF0000U)
#define ELEMU_VER_MINOR_SHIFT                    (16U)
/*! MINOR - Minor Version Number (0x00 )
 */
#define ELEMU_VER_MINOR(x)                       (((uint32_t)(((uint32_t)(x)) << ELEMU_VER_MINOR_SHIFT)) & ELEMU_VER_MINOR_MASK)

#define ELEMU_VER_MAJOR_MASK                     (0xFF000000U)
#define ELEMU_VER_MAJOR_SHIFT                    (24U)
/*! MAJOR - Major Version Number (0x01 )
 */
#define ELEMU_VER_MAJOR(x)                       (((uint32_t)(((uint32_t)(x)) << ELEMU_VER_MAJOR_SHIFT)) & ELEMU_VER_MAJOR_MASK)
/*! @} */

/*! @name PAR - Parameter Register */
/*! @{ */

#define ELEMU_PAR_TR_NUM_MASK                    (0xFFU)
#define ELEMU_PAR_TR_NUM_SHIFT                   (0U)
/*! TR_NUM - Number of Transmit (TRn) registers (8'd16)
 */
#define ELEMU_PAR_TR_NUM(x)                      (((uint32_t)(((uint32_t)(x)) << ELEMU_PAR_TR_NUM_SHIFT)) & ELEMU_PAR_TR_NUM_MASK)

#define ELEMU_PAR_RR_NUM_MASK                    (0xFF00U)
#define ELEMU_PAR_RR_NUM_SHIFT                   (8U)
/*! RR_NUM - Number of Receive (RRn) registers (8'd2)
 */
#define ELEMU_PAR_RR_NUM(x)                      (((uint32_t)(((uint32_t)(x)) << ELEMU_PAR_RR_NUM_SHIFT)) & ELEMU_PAR_RR_NUM_MASK)
/*! @} */

/*! @name SR - Status Register */
/*! @{ */

#define ELEMU_SR_TEP_MASK                        (0x20U)
#define ELEMU_SR_TEP_SHIFT                       (5U)
/*! TEP - Transmit Empty Pending
 */
#define ELEMU_SR_TEP(x)                          (((uint32_t)(((uint32_t)(x)) << ELEMU_SR_TEP_SHIFT)) & ELEMU_SR_TEP_MASK)

#define ELEMU_SR_RFP_MASK                        (0x40U)
#define ELEMU_SR_RFP_SHIFT                       (6U)
/*! RFP - Receive Full Pending Flag
 *  0b0..No data is ready to be read. All RSR[RFn] bits are clear.
 *  0b1..Data is ready to be read. One or more RSR[RFn] bits are set.
 */
#define ELEMU_SR_RFP(x)                          (((uint32_t)(((uint32_t)(x)) << ELEMU_SR_RFP_SHIFT)) & ELEMU_SR_RFP_MASK)
/*! @} */

/*! @name TCR - Transmit Control Register */
/*! @{ */

#define ELEMU_TCR_TEIEn_MASK                     (0xFFFFU)
#define ELEMU_TCR_TEIEn_SHIFT                    (0U)
/*! TEIEn - Transmit Register n Empty Interrupt Enable
 */
#define ELEMU_TCR_TEIEn(x)                       (((uint32_t)(((uint32_t)(x)) << ELEMU_TCR_TEIEn_SHIFT)) & ELEMU_TCR_TEIEn_MASK)
/*! @} */

/*! @name TSR - Transmit Status Register */
/*! @{ */

#define ELEMU_TSR_TEn_MASK                       (0xFFFFU)
#define ELEMU_TSR_TEn_SHIFT                      (0U)
/*! TEn - Transmit Register n Empty
 */
#define ELEMU_TSR_TEn(x)                         (((uint32_t)(((uint32_t)(x)) << ELEMU_TSR_TEn_SHIFT)) & ELEMU_TSR_TEn_MASK)
/*! @} */

/*! @name RSR - Receive Status Register */
/*! @{ */

#define ELEMU_RSR_RFn_MASK                       (0x3U)
#define ELEMU_RSR_RFn_SHIFT                      (0U)
/*! RFn - Receive Register n Full
 */
#define ELEMU_RSR_RFn(x)                         (((uint32_t)(((uint32_t)(x)) << ELEMU_RSR_RFn_SHIFT)) & ELEMU_RSR_RFn_MASK)
/*! @} */

/*! @name UNUSED1 - Unused Register 1 */
/*! @{ */

#define ELEMU_UNUSED1_DATA16_MASK                (0xFFFFU)
#define ELEMU_UNUSED1_DATA16_SHIFT               (0U)
/*! DATA16 - Unused 16-bit Register
 */
#define ELEMU_UNUSED1_DATA16(x)                  (((uint32_t)(((uint32_t)(x)) << ELEMU_UNUSED1_DATA16_SHIFT)) & ELEMU_UNUSED1_DATA16_MASK)
/*! @} */

/*! @name TR - Transmit Register */
/*! @{ */

#define ELEMU_TR_TR_DATA_MASK                    (0xFFFFFFFFU)
#define ELEMU_TR_TR_DATA_SHIFT                   (0U)
/*! TR_DATA - Transmit Data
 */
#define ELEMU_TR_TR_DATA(x)                      (((uint32_t)(((uint32_t)(x)) << ELEMU_TR_TR_DATA_SHIFT)) & ELEMU_TR_TR_DATA_MASK)
/*! @} */

/* The count of ELEMU_TR */
#define ELEMU_TR_COUNT                           (16U)

/*! @name RR - Receive Register */
/*! @{ */

#define ELEMU_RR_RR_DATA_MASK                    (0xFFFFFFFFU)
#define ELEMU_RR_RR_DATA_SHIFT                   (0U)
/*! RR_DATA - Receive Data
 */
#define ELEMU_RR_RR_DATA(x)                      (((uint32_t)(((uint32_t)(x)) << ELEMU_RR_RR_DATA_SHIFT)) & ELEMU_RR_RR_DATA_MASK)
/*! @} */

/* The count of ELEMU_RR */
#define ELEMU_RR_COUNT                           (2U)

/*! @name SEMA4_SR - Semaphore Status Register */
/*! @{ */

#define ELEMU_SEMA4_SR_OWNR16_MASK               (0xFFFFU)
#define ELEMU_SEMA4_SR_OWNR16_SHIFT              (0U)
/*! OWNR16 - Semaphore Owner
 */
#define ELEMU_SEMA4_SR_OWNR16(x)                 (((uint32_t)(((uint32_t)(x)) << ELEMU_SEMA4_SR_OWNR16_SHIFT)) & ELEMU_SEMA4_SR_OWNR16_MASK)

#define ELEMU_SEMA4_SR_SSS_CIP2_MASK             (0x10000U)
#define ELEMU_SEMA4_SR_SSS_CIP2_SHIFT            (16U)
/*! SSS_CIP2 - Security SubSystem (ELE) command group 2 in progress
 *  0b0..Service request group 2 not being processed by ELE
 *  0b1..Service request group 2 being processed by ELE
 */
#define ELEMU_SEMA4_SR_SSS_CIP2(x)               (((uint32_t)(((uint32_t)(x)) << ELEMU_SEMA4_SR_SSS_CIP2_SHIFT)) & ELEMU_SEMA4_SR_SSS_CIP2_MASK)

#define ELEMU_SEMA4_SR_SSS_CIP1_MASK             (0x20000U)
#define ELEMU_SEMA4_SR_SSS_CIP1_SHIFT            (17U)
/*! SSS_CIP1 - Security SubSystem (ELE) command group 1 in progress
 *  0b0..Service request group 1 not being processed by ELE
 *  0b1..Service request group 1 being processed by ELE
 */
#define ELEMU_SEMA4_SR_SSS_CIP1(x)               (((uint32_t)(((uint32_t)(x)) << ELEMU_SEMA4_SR_SSS_CIP1_SHIFT)) & ELEMU_SEMA4_SR_SSS_CIP1_MASK)

#define ELEMU_SEMA4_SR_SSS_LCK_MASK              (0x1000000U)
#define ELEMU_SEMA4_SR_SSS_LCK_SHIFT             (24U)
/*! SSS_LCK - Security SubSystem (ELE) lockup
 *  0b0..Edgelock enclave is not locked up
 *  0b1..Edgelock enclave is locked up in an unrecoverable state
 */
#define ELEMU_SEMA4_SR_SSS_LCK(x)                (((uint32_t)(((uint32_t)(x)) << ELEMU_SEMA4_SR_SSS_LCK_SHIFT)) & ELEMU_SEMA4_SR_SSS_LCK_MASK)

#define ELEMU_SEMA4_SR_MISC_BSY_MASK             (0x7E000000U)
#define ELEMU_SEMA4_SR_MISC_BSY_SHIFT            (25U)
/*! MISC_BSY - Miscellaneous ELE Busy Indicators
 */
#define ELEMU_SEMA4_SR_MISC_BSY(x)               (((uint32_t)(((uint32_t)(x)) << ELEMU_SEMA4_SR_MISC_BSY_SHIFT)) & ELEMU_SEMA4_SR_MISC_BSY_MASK)

#define ELEMU_SEMA4_SR_SSS_BSY_MASK              (0x80000000U)
#define ELEMU_SEMA4_SR_SSS_BSY_SHIFT             (31U)
/*! SSS_BSY - Security SubSystem (ELE) Busy
 *  0b0..Edgelock enclave is not busy
 *  0b1..Edgelock enclave CPU is busy
 */
#define ELEMU_SEMA4_SR_SSS_BSY(x)                (((uint32_t)(((uint32_t)(x)) << ELEMU_SEMA4_SR_SSS_BSY_SHIFT)) & ELEMU_SEMA4_SR_SSS_BSY_MASK)
/*! @} */

/*! @name SEMA4_OWNR - Semaphore Ownership Register */
/*! @{ */

#define ELEMU_SEMA4_OWNR_OWNR32_MASK             (0xFFFFFFFFU)
#define ELEMU_SEMA4_OWNR_OWNR32_SHIFT            (0U)
/*! OWNR32 - Semaphore Owner
 */
#define ELEMU_SEMA4_OWNR_OWNR32(x)               (((uint32_t)(((uint32_t)(x)) << ELEMU_SEMA4_OWNR_OWNR32_SHIFT)) & ELEMU_SEMA4_OWNR_OWNR32_MASK)
/*! @} */

/*! @name SEMA4_ACQ - Semaphore Acquire Register */
/*! @{ */

#define ELEMU_SEMA4_ACQ_OWNR32_MASK              (0xFFFFFFFFU)
#define ELEMU_SEMA4_ACQ_OWNR32_SHIFT             (0U)
/*! OWNR32 - Semaphore Owner
 */
#define ELEMU_SEMA4_ACQ_OWNR32(x)                (((uint32_t)(((uint32_t)(x)) << ELEMU_SEMA4_ACQ_OWNR32_SHIFT)) & ELEMU_SEMA4_ACQ_OWNR32_MASK)
/*! @} */

/*! @name SEMA4_REL - Semaphore Release Register */
/*! @{ */

#define ELEMU_SEMA4_REL_OWNR32_MASK              (0xFFFFFFFFU)
#define ELEMU_SEMA4_REL_OWNR32_SHIFT             (0U)
/*! OWNR32 - Semaphore Owner
 */
#define ELEMU_SEMA4_REL_OWNR32(x)                (((uint32_t)(((uint32_t)(x)) << ELEMU_SEMA4_REL_OWNR32_SHIFT)) & ELEMU_SEMA4_REL_OWNR32_MASK)
/*! @} */

/*! @name SEMA4_FREL - Semaphore Forced Release Register */
/*! @{ */

#define ELEMU_SEMA4_FREL_OWNR32_MASK             (0xFFFFFFFFU)
#define ELEMU_SEMA4_FREL_OWNR32_SHIFT            (0U)
/*! OWNR32 - Semaphore Owner
 */
#define ELEMU_SEMA4_FREL_OWNR32(x)               (((uint32_t)(((uint32_t)(x)) << ELEMU_SEMA4_FREL_OWNR32_SHIFT)) & ELEMU_SEMA4_FREL_OWNR32_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group ELEMU_Register_Masks */


/* ELEMU - Peripheral instance base addresses */
#if (defined(__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE & 0x2))
  /** Peripheral ELEMUA base address */
  #define ELEMUA_BASE                              (0x50024000u)
  /** Peripheral ELEMUA base address */
  #define ELEMUA_BASE_NS                           (0x40024000u)
  /** Peripheral ELEMUA base pointer */
  #define ELEMUA                                   ((ELEMU_Type *)ELEMUA_BASE)
  /** Peripheral ELEMUA base pointer */
  #define ELEMUA_NS                                ((ELEMU_Type *)ELEMUA_BASE_NS)
  /** Array initializer of ELEMU peripheral base addresses */
  #define ELEMU_BASE_ADDRS                         { ELEMUA_BASE }
  /** Array initializer of ELEMU peripheral base pointers */
  #define ELEMU_BASE_PTRS                          { ELEMUA }
  /** Array initializer of ELEMU peripheral base addresses */
  #define ELEMU_BASE_ADDRS_NS                      { ELEMUA_BASE_NS }
  /** Array initializer of ELEMU peripheral base pointers */
  #define ELEMU_BASE_PTRS_NS                       { ELEMUA_NS }
#else
  /** Peripheral ELEMUA base address */
  #define ELEMUA_BASE                              (0x40024000u)
  /** Peripheral ELEMUA base pointer */
  #define ELEMUA                                   ((ELEMU_Type *)ELEMUA_BASE)
  /** Array initializer of ELEMU peripheral base addresses */
  #define ELEMU_BASE_ADDRS                         { ELEMUA_BASE }
  /** Array initializer of ELEMU peripheral base pointers */
  #define ELEMU_BASE_PTRS                          { ELEMUA }
#endif

/*!
 * @}
 */ /* end of group ELEMU_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- EWM Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup EWM_Peripheral_Access_Layer EWM Peripheral Access Layer
 * @{
 */

/** EWM - Register Layout Typedef */
typedef struct {
  __IO uint8_t CTRL;                               /**< Control Register, offset: 0x0 */
  __O  uint8_t SERV;                               /**< Service Register, offset: 0x1 */
  __IO uint8_t CMPL;                               /**< Compare Low Register, offset: 0x2 */
  __IO uint8_t CMPH;                               /**< Compare High Register, offset: 0x3 */
       uint8_t RESERVED_0[1];
  __IO uint8_t CLKPRESCALER;                       /**< Clock Prescaler Register, offset: 0x5 */
} EWM_Type;

/* ----------------------------------------------------------------------------
   -- EWM Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup EWM_Register_Masks EWM Register Masks
 * @{
 */

/*! @name CTRL - Control Register */
/*! @{ */

#define EWM_CTRL_EWMEN_MASK                      (0x1U)
#define EWM_CTRL_EWMEN_SHIFT                     (0U)
/*! EWMEN - EWM enable.
 *  0b0..EWM module is disabled.
 *  0b1..EWM module is enabled.
 */
#define EWM_CTRL_EWMEN(x)                        (((uint8_t)(((uint8_t)(x)) << EWM_CTRL_EWMEN_SHIFT)) & EWM_CTRL_EWMEN_MASK)

#define EWM_CTRL_ASSIN_MASK                      (0x2U)
#define EWM_CTRL_ASSIN_SHIFT                     (1U)
/*! ASSIN - EWM_in's Assertion State Select.
 *  0b0..Default assert state of the EWM_in signal.
 *  0b1..Inverts the assert state of EWM_in signal.
 */
#define EWM_CTRL_ASSIN(x)                        (((uint8_t)(((uint8_t)(x)) << EWM_CTRL_ASSIN_SHIFT)) & EWM_CTRL_ASSIN_MASK)

#define EWM_CTRL_INEN_MASK                       (0x4U)
#define EWM_CTRL_INEN_SHIFT                      (2U)
/*! INEN - Input Enable.
 *  0b0..EWM_in port is disabled.
 *  0b1..EWM_in port is enabled.
 */
#define EWM_CTRL_INEN(x)                         (((uint8_t)(((uint8_t)(x)) << EWM_CTRL_INEN_SHIFT)) & EWM_CTRL_INEN_MASK)

#define EWM_CTRL_INTEN_MASK                      (0x8U)
#define EWM_CTRL_INTEN_SHIFT                     (3U)
/*! INTEN - Interrupt Enable.
 *  0b1..Generates an interrupt request, when EWM_OUT_b is asserted.
 *  0b0..Deasserts the interrupt request.
 */
#define EWM_CTRL_INTEN(x)                        (((uint8_t)(((uint8_t)(x)) << EWM_CTRL_INTEN_SHIFT)) & EWM_CTRL_INTEN_MASK)
/*! @} */

/*! @name SERV - Service Register */
/*! @{ */

#define EWM_SERV_SERVICE_MASK                    (0xFFU)
#define EWM_SERV_SERVICE_SHIFT                   (0U)
/*! SERVICE - SERVICE
 */
#define EWM_SERV_SERVICE(x)                      (((uint8_t)(((uint8_t)(x)) << EWM_SERV_SERVICE_SHIFT)) & EWM_SERV_SERVICE_MASK)
/*! @} */

/*! @name CMPL - Compare Low Register */
/*! @{ */

#define EWM_CMPL_COMPAREL_MASK                   (0xFFU)
#define EWM_CMPL_COMPAREL_SHIFT                  (0U)
/*! COMPAREL - COMPAREL
 */
#define EWM_CMPL_COMPAREL(x)                     (((uint8_t)(((uint8_t)(x)) << EWM_CMPL_COMPAREL_SHIFT)) & EWM_CMPL_COMPAREL_MASK)
/*! @} */

/*! @name CMPH - Compare High Register */
/*! @{ */

#define EWM_CMPH_COMPAREH_MASK                   (0xFFU)
#define EWM_CMPH_COMPAREH_SHIFT                  (0U)
/*! COMPAREH - COMPAREH
 */
#define EWM_CMPH_COMPAREH(x)                     (((uint8_t)(((uint8_t)(x)) << EWM_CMPH_COMPAREH_SHIFT)) & EWM_CMPH_COMPAREH_MASK)
/*! @} */

/*! @name CLKPRESCALER - Clock Prescaler Register */
/*! @{ */

#define EWM_CLKPRESCALER_CLK_DIV_MASK            (0xFFU)
#define EWM_CLKPRESCALER_CLK_DIV_SHIFT           (0U)
/*! CLK_DIV - CLK_DIV
 */
#define EWM_CLKPRESCALER_CLK_DIV(x)              (((uint8_t)(((uint8_t)(x)) << EWM_CLKPRESCALER_CLK_DIV_SHIFT)) & EWM_CLKPRESCALER_CLK_DIV_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group EWM_Register_Masks */


/* EWM - Peripheral instance base addresses */
#if (defined(__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE & 0x2))
  /** Peripheral EWM0 base address */
  #define EWM0_BASE                                (0x50013000u)
  /** Peripheral EWM0 base address */
  #define EWM0_BASE_NS                             (0x40013000u)
  /** Peripheral EWM0 base pointer */
  #define EWM0                                     ((EWM_Type *)EWM0_BASE)
  /** Peripheral EWM0 base pointer */
  #define EWM0_NS                                  ((EWM_Type *)EWM0_BASE_NS)
  /** Array initializer of EWM peripheral base addresses */
  #define EWM_BASE_ADDRS                           { EWM0_BASE }
  /** Array initializer of EWM peripheral base pointers */
  #define EWM_BASE_PTRS                            { EWM0 }
  /** Array initializer of EWM peripheral base addresses */
  #define EWM_BASE_ADDRS_NS                        { EWM0_BASE_NS }
  /** Array initializer of EWM peripheral base pointers */
  #define EWM_BASE_PTRS_NS                         { EWM0_NS }
#else
  /** Peripheral EWM0 base address */
  #define EWM0_BASE                                (0x40013000u)
  /** Peripheral EWM0 base pointer */
  #define EWM0                                     ((EWM_Type *)EWM0_BASE)
  /** Array initializer of EWM peripheral base addresses */
  #define EWM_BASE_ADDRS                           { EWM0_BASE }
  /** Array initializer of EWM peripheral base pointers */
  #define EWM_BASE_PTRS                            { EWM0 }
#endif

/*!
 * @}
 */ /* end of group EWM_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- FLEXIO Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FLEXIO_Peripheral_Access_Layer FLEXIO Peripheral Access Layer
 * @{
 */

/** FLEXIO - Register Layout Typedef */
typedef struct {
  __I  uint32_t VERID;                             /**< Version ID Register, offset: 0x0 */
  __I  uint32_t PARAM;                             /**< Parameter Register, offset: 0x4 */
  __IO uint32_t CTRL;                              /**< FlexIO Control Register, offset: 0x8 */
  __I  uint32_t PIN;                               /**< Pin State Register, offset: 0xC */
  __IO uint32_t SHIFTSTAT;                         /**< Shifter Status Register, offset: 0x10 */
  __IO uint32_t SHIFTERR;                          /**< Shifter Error Register, offset: 0x14 */
  __IO uint32_t TIMSTAT;                           /**< Timer Status Register, offset: 0x18 */
       uint8_t RESERVED_0[4];
  __IO uint32_t SHIFTSIEN;                         /**< Shifter Status Interrupt Enable, offset: 0x20 */
  __IO uint32_t SHIFTEIEN;                         /**< Shifter Error Interrupt Enable, offset: 0x24 */
  __IO uint32_t TIMIEN;                            /**< Timer Interrupt Enable Register, offset: 0x28 */
       uint8_t RESERVED_1[4];
  __IO uint32_t SHIFTSDEN;                         /**< Shifter Status DMA Enable, offset: 0x30 */
       uint8_t RESERVED_2[4];
  __IO uint32_t TIMERSDEN;                         /**< Timer Status DMA Enable, offset: 0x38 */
       uint8_t RESERVED_3[4];
  __IO uint32_t SHIFTSTATE;                        /**< Shifter State Register, offset: 0x40 */
       uint8_t RESERVED_4[4];
  __IO uint32_t TRGSTAT;                           /**< Trigger Status Register, offset: 0x48 */
  __IO uint32_t TRIGIEN;                           /**< External Trigger Interrupt Enable Register, offset: 0x4C */
  __IO uint32_t PINSTAT;                           /**< Pin Status Register, offset: 0x50 */
  __IO uint32_t PINIEN;                            /**< Pin Interrupt Enable Register, offset: 0x54 */
  __IO uint32_t PINREN;                            /**< Pin Rising Edge Enable Register, offset: 0x58 */
  __IO uint32_t PINFEN;                            /**< Pin Falling Edge Enable Register, offset: 0x5C */
  __IO uint32_t PINOUTD;                           /**< Pin Output Data Register, offset: 0x60 */
  __IO uint32_t PINOUTE;                           /**< Pin Output Enable Register, offset: 0x64 */
  __O  uint32_t PINOUTDIS;                         /**< Pin Output Disable Register, offset: 0x68 */
  __O  uint32_t PINOUTCLR;                         /**< Pin Output Clear Register, offset: 0x6C */
  __O  uint32_t PINOUTSET;                         /**< Pin Output Set Register, offset: 0x70 */
  __O  uint32_t PINOUTTOG;                         /**< Pin Output Toggle Register, offset: 0x74 */
       uint8_t RESERVED_5[8];
  __IO uint32_t SHIFTCTL[8];                       /**< Shifter Control N Register, array offset: 0x80, array step: 0x4 */
       uint8_t RESERVED_6[96];
  __IO uint32_t SHIFTCFG[8];                       /**< Shifter Configuration N Register, array offset: 0x100, array step: 0x4 */
       uint8_t RESERVED_7[224];
  __IO uint32_t SHIFTBUF[8];                       /**< Shifter Buffer N Register, array offset: 0x200, array step: 0x4 */
       uint8_t RESERVED_8[96];
  __IO uint32_t SHIFTBUFBIS[8];                    /**< Shifter Buffer N Bit Swapped Register, array offset: 0x280, array step: 0x4 */
       uint8_t RESERVED_9[96];
  __IO uint32_t SHIFTBUFBYS[8];                    /**< Shifter Buffer N Byte Swapped Register, array offset: 0x300, array step: 0x4 */
       uint8_t RESERVED_10[96];
  __IO uint32_t SHIFTBUFBBS[8];                    /**< Shifter Buffer N Bit Byte Swapped Register, array offset: 0x380, array step: 0x4 */
       uint8_t RESERVED_11[96];
  __IO uint32_t TIMCTL[8];                         /**< Timer Control N Register, array offset: 0x400, array step: 0x4 */
       uint8_t RESERVED_12[96];
  __IO uint32_t TIMCFG[8];                         /**< Timer Configuration N Register, array offset: 0x480, array step: 0x4 */
       uint8_t RESERVED_13[96];
  __IO uint32_t TIMCMP[8];                         /**< Timer Compare N Register, array offset: 0x500, array step: 0x4 */
       uint8_t RESERVED_14[352];
  __IO uint32_t SHIFTBUFNBS[8];                    /**< Shifter Buffer N Nibble Byte Swapped Register, array offset: 0x680, array step: 0x4 */
       uint8_t RESERVED_15[96];
  __IO uint32_t SHIFTBUFHWS[8];                    /**< Shifter Buffer N Half Word Swapped Register, array offset: 0x700, array step: 0x4 */
       uint8_t RESERVED_16[96];
  __IO uint32_t SHIFTBUFNIS[8];                    /**< Shifter Buffer N Nibble Swapped Register, array offset: 0x780, array step: 0x4 */
       uint8_t RESERVED_17[96];
  __IO uint32_t SHIFTBUFOES[8];                    /**< Shifter Buffer N Odd Even Swapped Register, array offset: 0x800, array step: 0x4 */
       uint8_t RESERVED_18[96];
  __IO uint32_t SHIFTBUFEOS[8];                    /**< Shifter Buffer N Even Odd Swapped Register, array offset: 0x880, array step: 0x4 */
       uint8_t RESERVED_19[96];
  __IO uint32_t SHIFTBUFHBS[8];                    /**< Shifter Buffer N Halfword Byte Swapped Register, array offset: 0x900, array step: 0x4 */
} FLEXIO_Type;

/* ----------------------------------------------------------------------------
   -- FLEXIO Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FLEXIO_Register_Masks FLEXIO Register Masks
 * @{
 */

/*! @name VERID - Version ID Register */
/*! @{ */

#define FLEXIO_VERID_FEATURE_MASK                (0xFFFFU)
#define FLEXIO_VERID_FEATURE_SHIFT               (0U)
/*! FEATURE - Feature Specification Number
 *  0b0000000000000000..Standard features implemented.
 *  0b0000000000000001..Supports state, logic and parallel modes.
 *  0b0000000000000010..Supports pin control registers.
 *  0b0000000000000011..Supports state, logic and parallel modes; plus pin control registers.
 */
#define FLEXIO_VERID_FEATURE(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_VERID_FEATURE_SHIFT)) & FLEXIO_VERID_FEATURE_MASK)

#define FLEXIO_VERID_MINOR_MASK                  (0xFF0000U)
#define FLEXIO_VERID_MINOR_SHIFT                 (16U)
/*! MINOR - Minor Version Number
 */
#define FLEXIO_VERID_MINOR(x)                    (((uint32_t)(((uint32_t)(x)) << FLEXIO_VERID_MINOR_SHIFT)) & FLEXIO_VERID_MINOR_MASK)

#define FLEXIO_VERID_MAJOR_MASK                  (0xFF000000U)
#define FLEXIO_VERID_MAJOR_SHIFT                 (24U)
/*! MAJOR - Major Version Number
 */
#define FLEXIO_VERID_MAJOR(x)                    (((uint32_t)(((uint32_t)(x)) << FLEXIO_VERID_MAJOR_SHIFT)) & FLEXIO_VERID_MAJOR_MASK)
/*! @} */

/*! @name PARAM - Parameter Register */
/*! @{ */

#define FLEXIO_PARAM_SHIFTER_MASK                (0xFFU)
#define FLEXIO_PARAM_SHIFTER_SHIFT               (0U)
/*! SHIFTER - Shifter Number
 */
#define FLEXIO_PARAM_SHIFTER(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_PARAM_SHIFTER_SHIFT)) & FLEXIO_PARAM_SHIFTER_MASK)

#define FLEXIO_PARAM_TIMER_MASK                  (0xFF00U)
#define FLEXIO_PARAM_TIMER_SHIFT                 (8U)
/*! TIMER - Timer Number
 */
#define FLEXIO_PARAM_TIMER(x)                    (((uint32_t)(((uint32_t)(x)) << FLEXIO_PARAM_TIMER_SHIFT)) & FLEXIO_PARAM_TIMER_MASK)

#define FLEXIO_PARAM_PIN_MASK                    (0xFF0000U)
#define FLEXIO_PARAM_PIN_SHIFT                   (16U)
/*! PIN - Pin Number
 */
#define FLEXIO_PARAM_PIN(x)                      (((uint32_t)(((uint32_t)(x)) << FLEXIO_PARAM_PIN_SHIFT)) & FLEXIO_PARAM_PIN_MASK)

#define FLEXIO_PARAM_TRIGGER_MASK                (0xFF000000U)
#define FLEXIO_PARAM_TRIGGER_SHIFT               (24U)
/*! TRIGGER - Trigger Number
 */
#define FLEXIO_PARAM_TRIGGER(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_PARAM_TRIGGER_SHIFT)) & FLEXIO_PARAM_TRIGGER_MASK)
/*! @} */

/*! @name CTRL - FlexIO Control Register */
/*! @{ */

#define FLEXIO_CTRL_FLEXEN_MASK                  (0x1U)
#define FLEXIO_CTRL_FLEXEN_SHIFT                 (0U)
/*! FLEXEN - FlexIO Enable
 *  0b0..FlexIO module is disabled.
 *  0b1..FlexIO module is enabled.
 */
#define FLEXIO_CTRL_FLEXEN(x)                    (((uint32_t)(((uint32_t)(x)) << FLEXIO_CTRL_FLEXEN_SHIFT)) & FLEXIO_CTRL_FLEXEN_MASK)

#define FLEXIO_CTRL_SWRST_MASK                   (0x2U)
#define FLEXIO_CTRL_SWRST_SHIFT                  (1U)
/*! SWRST - Software Reset
 *  0b0..Software reset is disabled
 *  0b1..Software reset is enabled, all FlexIO registers except the Control Register are reset.
 */
#define FLEXIO_CTRL_SWRST(x)                     (((uint32_t)(((uint32_t)(x)) << FLEXIO_CTRL_SWRST_SHIFT)) & FLEXIO_CTRL_SWRST_MASK)

#define FLEXIO_CTRL_FASTACC_MASK                 (0x4U)
#define FLEXIO_CTRL_FASTACC_SHIFT                (2U)
/*! FASTACC - Fast Access
 *  0b0..Configures for normal register accesses to FlexIO
 *  0b1..Configures for fast register accesses to FlexIO
 */
#define FLEXIO_CTRL_FASTACC(x)                   (((uint32_t)(((uint32_t)(x)) << FLEXIO_CTRL_FASTACC_SHIFT)) & FLEXIO_CTRL_FASTACC_MASK)

#define FLEXIO_CTRL_DBGE_MASK                    (0x40000000U)
#define FLEXIO_CTRL_DBGE_SHIFT                   (30U)
/*! DBGE - Debug Enable
 *  0b0..FlexIO is disabled in debug modes.
 *  0b1..FlexIO is enabled in debug modes
 */
#define FLEXIO_CTRL_DBGE(x)                      (((uint32_t)(((uint32_t)(x)) << FLEXIO_CTRL_DBGE_SHIFT)) & FLEXIO_CTRL_DBGE_MASK)

#define FLEXIO_CTRL_DOZEN_MASK                   (0x80000000U)
#define FLEXIO_CTRL_DOZEN_SHIFT                  (31U)
/*! DOZEN - Doze Enable
 *  0b0..FlexIO enabled in Doze modes.
 *  0b1..FlexIO disabled in Doze modes.
 */
#define FLEXIO_CTRL_DOZEN(x)                     (((uint32_t)(((uint32_t)(x)) << FLEXIO_CTRL_DOZEN_SHIFT)) & FLEXIO_CTRL_DOZEN_MASK)
/*! @} */

/*! @name PIN - Pin State Register */
/*! @{ */

#define FLEXIO_PIN_PDI_MASK                      (0xFFFFFFFFU)
#define FLEXIO_PIN_PDI_SHIFT                     (0U)
/*! PDI - Pin Data Input
 */
#define FLEXIO_PIN_PDI(x)                        (((uint32_t)(((uint32_t)(x)) << FLEXIO_PIN_PDI_SHIFT)) & FLEXIO_PIN_PDI_MASK)
/*! @} */

/*! @name SHIFTSTAT - Shifter Status Register */
/*! @{ */

#define FLEXIO_SHIFTSTAT_SSF_MASK                (0xFFU)
#define FLEXIO_SHIFTSTAT_SSF_SHIFT               (0U)
/*! SSF - Shifter Status Flag
 */
#define FLEXIO_SHIFTSTAT_SSF(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTSTAT_SSF_SHIFT)) & FLEXIO_SHIFTSTAT_SSF_MASK)
/*! @} */

/*! @name SHIFTERR - Shifter Error Register */
/*! @{ */

#define FLEXIO_SHIFTERR_SEF_MASK                 (0xFFU)
#define FLEXIO_SHIFTERR_SEF_SHIFT                (0U)
/*! SEF - Shifter Error Flags
 */
#define FLEXIO_SHIFTERR_SEF(x)                   (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTERR_SEF_SHIFT)) & FLEXIO_SHIFTERR_SEF_MASK)
/*! @} */

/*! @name TIMSTAT - Timer Status Register */
/*! @{ */

#define FLEXIO_TIMSTAT_TSF_MASK                  (0xFFU)
#define FLEXIO_TIMSTAT_TSF_SHIFT                 (0U)
/*! TSF - Timer Status Flags
 */
#define FLEXIO_TIMSTAT_TSF(x)                    (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMSTAT_TSF_SHIFT)) & FLEXIO_TIMSTAT_TSF_MASK)
/*! @} */

/*! @name SHIFTSIEN - Shifter Status Interrupt Enable */
/*! @{ */

#define FLEXIO_SHIFTSIEN_SSIE_MASK               (0xFFU)
#define FLEXIO_SHIFTSIEN_SSIE_SHIFT              (0U)
/*! SSIE - Shifter Status Interrupt Enable
 */
#define FLEXIO_SHIFTSIEN_SSIE(x)                 (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTSIEN_SSIE_SHIFT)) & FLEXIO_SHIFTSIEN_SSIE_MASK)
/*! @} */

/*! @name SHIFTEIEN - Shifter Error Interrupt Enable */
/*! @{ */

#define FLEXIO_SHIFTEIEN_SEIE_MASK               (0xFFU)
#define FLEXIO_SHIFTEIEN_SEIE_SHIFT              (0U)
/*! SEIE - Shifter Error Interrupt Enable
 */
#define FLEXIO_SHIFTEIEN_SEIE(x)                 (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTEIEN_SEIE_SHIFT)) & FLEXIO_SHIFTEIEN_SEIE_MASK)
/*! @} */

/*! @name TIMIEN - Timer Interrupt Enable Register */
/*! @{ */

#define FLEXIO_TIMIEN_TEIE_MASK                  (0xFFU)
#define FLEXIO_TIMIEN_TEIE_SHIFT                 (0U)
/*! TEIE - Timer Status Interrupt Enable
 */
#define FLEXIO_TIMIEN_TEIE(x)                    (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMIEN_TEIE_SHIFT)) & FLEXIO_TIMIEN_TEIE_MASK)
/*! @} */

/*! @name SHIFTSDEN - Shifter Status DMA Enable */
/*! @{ */

#define FLEXIO_SHIFTSDEN_SSDE_MASK               (0xFFU)
#define FLEXIO_SHIFTSDEN_SSDE_SHIFT              (0U)
/*! SSDE - Shifter Status DMA Enable
 */
#define FLEXIO_SHIFTSDEN_SSDE(x)                 (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTSDEN_SSDE_SHIFT)) & FLEXIO_SHIFTSDEN_SSDE_MASK)
/*! @} */

/*! @name TIMERSDEN - Timer Status DMA Enable */
/*! @{ */

#define FLEXIO_TIMERSDEN_TSDE_MASK               (0xFFU)
#define FLEXIO_TIMERSDEN_TSDE_SHIFT              (0U)
/*! TSDE - Timer Status DMA Enable
 */
#define FLEXIO_TIMERSDEN_TSDE(x)                 (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMERSDEN_TSDE_SHIFT)) & FLEXIO_TIMERSDEN_TSDE_MASK)
/*! @} */

/*! @name SHIFTSTATE - Shifter State Register */
/*! @{ */

#define FLEXIO_SHIFTSTATE_STATE_MASK             (0x7U)
#define FLEXIO_SHIFTSTATE_STATE_SHIFT            (0U)
/*! STATE - Current State Pointer
 */
#define FLEXIO_SHIFTSTATE_STATE(x)               (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTSTATE_STATE_SHIFT)) & FLEXIO_SHIFTSTATE_STATE_MASK)
/*! @} */

/*! @name TRGSTAT - Trigger Status Register */
/*! @{ */

#define FLEXIO_TRGSTAT_ETSF_MASK                 (0xFU)
#define FLEXIO_TRGSTAT_ETSF_SHIFT                (0U)
/*! ETSF - External Trigger Status Flags
 */
#define FLEXIO_TRGSTAT_ETSF(x)                   (((uint32_t)(((uint32_t)(x)) << FLEXIO_TRGSTAT_ETSF_SHIFT)) & FLEXIO_TRGSTAT_ETSF_MASK)
/*! @} */

/*! @name TRIGIEN - External Trigger Interrupt Enable Register */
/*! @{ */

#define FLEXIO_TRIGIEN_TRIE_MASK                 (0xFU)
#define FLEXIO_TRIGIEN_TRIE_SHIFT                (0U)
/*! TRIE - External Trigger Interrupt Enable
 */
#define FLEXIO_TRIGIEN_TRIE(x)                   (((uint32_t)(((uint32_t)(x)) << FLEXIO_TRIGIEN_TRIE_SHIFT)) & FLEXIO_TRIGIEN_TRIE_MASK)
/*! @} */

/*! @name PINSTAT - Pin Status Register */
/*! @{ */

#define FLEXIO_PINSTAT_PSF_MASK                  (0xFFFFFFFFU)
#define FLEXIO_PINSTAT_PSF_SHIFT                 (0U)
/*! PSF - Pin Status Flags
 */
#define FLEXIO_PINSTAT_PSF(x)                    (((uint32_t)(((uint32_t)(x)) << FLEXIO_PINSTAT_PSF_SHIFT)) & FLEXIO_PINSTAT_PSF_MASK)
/*! @} */

/*! @name PINIEN - Pin Interrupt Enable Register */
/*! @{ */

#define FLEXIO_PINIEN_PSIE_MASK                  (0xFFFFFFFFU)
#define FLEXIO_PINIEN_PSIE_SHIFT                 (0U)
/*! PSIE - Pin Status Interrupt Enable
 */
#define FLEXIO_PINIEN_PSIE(x)                    (((uint32_t)(((uint32_t)(x)) << FLEXIO_PINIEN_PSIE_SHIFT)) & FLEXIO_PINIEN_PSIE_MASK)
/*! @} */

/*! @name PINREN - Pin Rising Edge Enable Register */
/*! @{ */

#define FLEXIO_PINREN_PRE_MASK                   (0xFFFFFFFFU)
#define FLEXIO_PINREN_PRE_SHIFT                  (0U)
/*! PRE - Pin Rising Edge
 */
#define FLEXIO_PINREN_PRE(x)                     (((uint32_t)(((uint32_t)(x)) << FLEXIO_PINREN_PRE_SHIFT)) & FLEXIO_PINREN_PRE_MASK)
/*! @} */

/*! @name PINFEN - Pin Falling Edge Enable Register */
/*! @{ */

#define FLEXIO_PINFEN_PFE_MASK                   (0xFFFFFFFFU)
#define FLEXIO_PINFEN_PFE_SHIFT                  (0U)
/*! PFE - Pin Falling Edge
 */
#define FLEXIO_PINFEN_PFE(x)                     (((uint32_t)(((uint32_t)(x)) << FLEXIO_PINFEN_PFE_SHIFT)) & FLEXIO_PINFEN_PFE_MASK)
/*! @} */

/*! @name PINOUTD - Pin Output Data Register */
/*! @{ */

#define FLEXIO_PINOUTD_OUTD_MASK                 (0xFFFFFFFFU)
#define FLEXIO_PINOUTD_OUTD_SHIFT                (0U)
/*! OUTD - Output Data
 */
#define FLEXIO_PINOUTD_OUTD(x)                   (((uint32_t)(((uint32_t)(x)) << FLEXIO_PINOUTD_OUTD_SHIFT)) & FLEXIO_PINOUTD_OUTD_MASK)
/*! @} */

/*! @name PINOUTE - Pin Output Enable Register */
/*! @{ */

#define FLEXIO_PINOUTE_OUTE_MASK                 (0xFFFFFFFFU)
#define FLEXIO_PINOUTE_OUTE_SHIFT                (0U)
/*! OUTE - Output Enable
 */
#define FLEXIO_PINOUTE_OUTE(x)                   (((uint32_t)(((uint32_t)(x)) << FLEXIO_PINOUTE_OUTE_SHIFT)) & FLEXIO_PINOUTE_OUTE_MASK)
/*! @} */

/*! @name PINOUTDIS - Pin Output Disable Register */
/*! @{ */

#define FLEXIO_PINOUTDIS_OUTDIS_MASK             (0xFFFFFFFFU)
#define FLEXIO_PINOUTDIS_OUTDIS_SHIFT            (0U)
/*! OUTDIS - Output Disable
 */
#define FLEXIO_PINOUTDIS_OUTDIS(x)               (((uint32_t)(((uint32_t)(x)) << FLEXIO_PINOUTDIS_OUTDIS_SHIFT)) & FLEXIO_PINOUTDIS_OUTDIS_MASK)
/*! @} */

/*! @name PINOUTCLR - Pin Output Clear Register */
/*! @{ */

#define FLEXIO_PINOUTCLR_OUTCLR_MASK             (0xFFFFFFFFU)
#define FLEXIO_PINOUTCLR_OUTCLR_SHIFT            (0U)
/*! OUTCLR - Output Clear
 */
#define FLEXIO_PINOUTCLR_OUTCLR(x)               (((uint32_t)(((uint32_t)(x)) << FLEXIO_PINOUTCLR_OUTCLR_SHIFT)) & FLEXIO_PINOUTCLR_OUTCLR_MASK)
/*! @} */

/*! @name PINOUTSET - Pin Output Set Register */
/*! @{ */

#define FLEXIO_PINOUTSET_OUTSET_MASK             (0xFFFFFFFFU)
#define FLEXIO_PINOUTSET_OUTSET_SHIFT            (0U)
/*! OUTSET - Output Set
 */
#define FLEXIO_PINOUTSET_OUTSET(x)               (((uint32_t)(((uint32_t)(x)) << FLEXIO_PINOUTSET_OUTSET_SHIFT)) & FLEXIO_PINOUTSET_OUTSET_MASK)
/*! @} */

/*! @name PINOUTTOG - Pin Output Toggle Register */
/*! @{ */

#define FLEXIO_PINOUTTOG_OUTTOG_MASK             (0xFFFFFFFFU)
#define FLEXIO_PINOUTTOG_OUTTOG_SHIFT            (0U)
/*! OUTTOG - Output Toggle
 */
#define FLEXIO_PINOUTTOG_OUTTOG(x)               (((uint32_t)(((uint32_t)(x)) << FLEXIO_PINOUTTOG_OUTTOG_SHIFT)) & FLEXIO_PINOUTTOG_OUTTOG_MASK)
/*! @} */

/*! @name SHIFTCTL - Shifter Control N Register */
/*! @{ */

#define FLEXIO_SHIFTCTL_SMOD_MASK                (0x7U)
#define FLEXIO_SHIFTCTL_SMOD_SHIFT               (0U)
/*! SMOD - Shifter Mode
 *  0b000..Disabled.
 *  0b001..Receive mode. Captures the current Shifter content into the SHIFTBUF on expiration of the Timer.
 *  0b010..Transmit mode. Load SHIFTBUF contents into the Shifter on expiration of the Timer.
 *  0b011..Reserved.
 *  0b100..Match Store mode. Shifter data is compared to SHIFTBUF content on expiration of the Timer.
 *  0b101..Match Continuous mode. Shifter data is continuously compared to SHIFTBUF contents.
 *  0b110..State mode. SHIFTBUF contents are used for storing programmable state attributes.
 *  0b111..Logic mode. SHIFTBUF contents are used for implementing programmable logic look up table.
 */
#define FLEXIO_SHIFTCTL_SMOD(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTCTL_SMOD_SHIFT)) & FLEXIO_SHIFTCTL_SMOD_MASK)

#define FLEXIO_SHIFTCTL_PINPOL_MASK              (0x80U)
#define FLEXIO_SHIFTCTL_PINPOL_SHIFT             (7U)
/*! PINPOL - Shifter Pin Polarity
 *  0b0..Pin is active high
 *  0b1..Pin is active low
 */
#define FLEXIO_SHIFTCTL_PINPOL(x)                (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTCTL_PINPOL_SHIFT)) & FLEXIO_SHIFTCTL_PINPOL_MASK)

#define FLEXIO_SHIFTCTL_PINSEL_MASK              (0x1F00U)
#define FLEXIO_SHIFTCTL_PINSEL_SHIFT             (8U)
/*! PINSEL - Shifter Pin Select
 */
#define FLEXIO_SHIFTCTL_PINSEL(x)                (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTCTL_PINSEL_SHIFT)) & FLEXIO_SHIFTCTL_PINSEL_MASK)

#define FLEXIO_SHIFTCTL_PINCFG_MASK              (0x30000U)
#define FLEXIO_SHIFTCTL_PINCFG_SHIFT             (16U)
/*! PINCFG - Shifter Pin Configuration
 *  0b00..Shifter pin output disabled
 *  0b01..Shifter pin open drain or bidirectional output enable
 *  0b10..Shifter pin bidirectional output data
 *  0b11..Shifter pin output
 */
#define FLEXIO_SHIFTCTL_PINCFG(x)                (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTCTL_PINCFG_SHIFT)) & FLEXIO_SHIFTCTL_PINCFG_MASK)

#define FLEXIO_SHIFTCTL_TIMPOL_MASK              (0x800000U)
#define FLEXIO_SHIFTCTL_TIMPOL_SHIFT             (23U)
/*! TIMPOL - Timer Polarity
 *  0b0..Shift on posedge of Shift clock
 *  0b1..Shift on negedge of Shift clock
 */
#define FLEXIO_SHIFTCTL_TIMPOL(x)                (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTCTL_TIMPOL_SHIFT)) & FLEXIO_SHIFTCTL_TIMPOL_MASK)

#define FLEXIO_SHIFTCTL_TIMSEL_MASK              (0x7000000U)
#define FLEXIO_SHIFTCTL_TIMSEL_SHIFT             (24U)
/*! TIMSEL - Timer Select
 */
#define FLEXIO_SHIFTCTL_TIMSEL(x)                (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTCTL_TIMSEL_SHIFT)) & FLEXIO_SHIFTCTL_TIMSEL_MASK)
/*! @} */

/* The count of FLEXIO_SHIFTCTL */
#define FLEXIO_SHIFTCTL_COUNT                    (8U)

/*! @name SHIFTCFG - Shifter Configuration N Register */
/*! @{ */

#define FLEXIO_SHIFTCFG_SSTART_MASK              (0x3U)
#define FLEXIO_SHIFTCFG_SSTART_SHIFT             (0U)
/*! SSTART - Shifter Start bit
 *  0b00..Start bit disabled for transmitter/receiver/match store, transmitter loads data on enable
 *  0b01..Start bit disabled for transmitter/receiver/match store, transmitter loads data on first shift
 *  0b10..Transmitter outputs start bit value 0 before loading data on first shift, receiver/match store sets error flag if start bit is not 0
 *  0b11..Transmitter outputs start bit value 1 before loading data on first shift, receiver/match store sets error flag if start bit is not 1
 */
#define FLEXIO_SHIFTCFG_SSTART(x)                (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTCFG_SSTART_SHIFT)) & FLEXIO_SHIFTCFG_SSTART_MASK)

#define FLEXIO_SHIFTCFG_SSTOP_MASK               (0x30U)
#define FLEXIO_SHIFTCFG_SSTOP_SHIFT              (4U)
/*! SSTOP - Shifter Stop bit
 *  0b00..Stop bit disabled for transmitter/receiver/match store
 *  0b01..Stop bit disabled for transmitter/receiver/match store, receiver/match store will store receive data on
 *        the configured shift edge when timer in stop condition
 *  0b10..Transmitter outputs stop bit value 0 on store, receiver/match store sets error flag if stop bit is not
 *        0, receiver/match store will also store receive data on the configured shift edge when timer in stop
 *        condition
 *  0b11..Transmitter outputs stop bit value 1 on store, receiver/match store sets error flag if stop bit is not
 *        1, receiver/match store will also store receive data on the configured shift edge when timer in stop
 *        condition
 */
#define FLEXIO_SHIFTCFG_SSTOP(x)                 (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTCFG_SSTOP_SHIFT)) & FLEXIO_SHIFTCFG_SSTOP_MASK)

#define FLEXIO_SHIFTCFG_INSRC_MASK               (0x100U)
#define FLEXIO_SHIFTCFG_INSRC_SHIFT              (8U)
/*! INSRC - Input Source
 *  0b0..Pin
 *  0b1..Shifter N+1 Output
 */
#define FLEXIO_SHIFTCFG_INSRC(x)                 (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTCFG_INSRC_SHIFT)) & FLEXIO_SHIFTCFG_INSRC_MASK)

#define FLEXIO_SHIFTCFG_LATST_MASK               (0x200U)
#define FLEXIO_SHIFTCFG_LATST_SHIFT              (9U)
/*! LATST - Late Store
 *  0b0..Shift register stores the pre-shift register state.
 *  0b1..Shift register stores the post-shift register state.
 */
#define FLEXIO_SHIFTCFG_LATST(x)                 (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTCFG_LATST_SHIFT)) & FLEXIO_SHIFTCFG_LATST_MASK)

#define FLEXIO_SHIFTCFG_SSIZE_MASK               (0x1000U)
#define FLEXIO_SHIFTCFG_SSIZE_SHIFT              (12U)
/*! SSIZE - Shifter Size
 *  0b0..Shift register is 32-bit.
 *  0b1..Shift register is 24-bit.
 */
#define FLEXIO_SHIFTCFG_SSIZE(x)                 (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTCFG_SSIZE_SHIFT)) & FLEXIO_SHIFTCFG_SSIZE_MASK)

#define FLEXIO_SHIFTCFG_PWIDTH_MASK              (0x1F0000U)
#define FLEXIO_SHIFTCFG_PWIDTH_SHIFT             (16U)
/*! PWIDTH - Parallel Width
 */
#define FLEXIO_SHIFTCFG_PWIDTH(x)                (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTCFG_PWIDTH_SHIFT)) & FLEXIO_SHIFTCFG_PWIDTH_MASK)
/*! @} */

/* The count of FLEXIO_SHIFTCFG */
#define FLEXIO_SHIFTCFG_COUNT                    (8U)

/*! @name SHIFTBUF - Shifter Buffer N Register */
/*! @{ */

#define FLEXIO_SHIFTBUF_SHIFTBUF_MASK            (0xFFFFFFFFU)
#define FLEXIO_SHIFTBUF_SHIFTBUF_SHIFT           (0U)
/*! SHIFTBUF - Shift Buffer
 */
#define FLEXIO_SHIFTBUF_SHIFTBUF(x)              (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTBUF_SHIFTBUF_SHIFT)) & FLEXIO_SHIFTBUF_SHIFTBUF_MASK)
/*! @} */

/* The count of FLEXIO_SHIFTBUF */
#define FLEXIO_SHIFTBUF_COUNT                    (8U)

/*! @name SHIFTBUFBIS - Shifter Buffer N Bit Swapped Register */
/*! @{ */

#define FLEXIO_SHIFTBUFBIS_SHIFTBUFBIS_MASK      (0xFFFFFFFFU)
#define FLEXIO_SHIFTBUFBIS_SHIFTBUFBIS_SHIFT     (0U)
/*! SHIFTBUFBIS - Shift Buffer
 */
#define FLEXIO_SHIFTBUFBIS_SHIFTBUFBIS(x)        (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTBUFBIS_SHIFTBUFBIS_SHIFT)) & FLEXIO_SHIFTBUFBIS_SHIFTBUFBIS_MASK)
/*! @} */

/* The count of FLEXIO_SHIFTBUFBIS */
#define FLEXIO_SHIFTBUFBIS_COUNT                 (8U)

/*! @name SHIFTBUFBYS - Shifter Buffer N Byte Swapped Register */
/*! @{ */

#define FLEXIO_SHIFTBUFBYS_SHIFTBUFBYS_MASK      (0xFFFFFFFFU)
#define FLEXIO_SHIFTBUFBYS_SHIFTBUFBYS_SHIFT     (0U)
/*! SHIFTBUFBYS - Shift Buffer
 */
#define FLEXIO_SHIFTBUFBYS_SHIFTBUFBYS(x)        (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTBUFBYS_SHIFTBUFBYS_SHIFT)) & FLEXIO_SHIFTBUFBYS_SHIFTBUFBYS_MASK)
/*! @} */

/* The count of FLEXIO_SHIFTBUFBYS */
#define FLEXIO_SHIFTBUFBYS_COUNT                 (8U)

/*! @name SHIFTBUFBBS - Shifter Buffer N Bit Byte Swapped Register */
/*! @{ */

#define FLEXIO_SHIFTBUFBBS_SHIFTBUFBBS_MASK      (0xFFFFFFFFU)
#define FLEXIO_SHIFTBUFBBS_SHIFTBUFBBS_SHIFT     (0U)
/*! SHIFTBUFBBS - Shift Buffer
 */
#define FLEXIO_SHIFTBUFBBS_SHIFTBUFBBS(x)        (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTBUFBBS_SHIFTBUFBBS_SHIFT)) & FLEXIO_SHIFTBUFBBS_SHIFTBUFBBS_MASK)
/*! @} */

/* The count of FLEXIO_SHIFTBUFBBS */
#define FLEXIO_SHIFTBUFBBS_COUNT                 (8U)

/*! @name TIMCTL - Timer Control N Register */
/*! @{ */

#define FLEXIO_TIMCTL_TIMOD_MASK                 (0x7U)
#define FLEXIO_TIMCTL_TIMOD_SHIFT                (0U)
/*! TIMOD - Timer Mode
 *  0b000..Timer Disabled.
 *  0b001..Dual 8-bit counters baud mode.
 *  0b010..Dual 8-bit counters PWM high mode.
 *  0b011..Single 16-bit counter mode.
 *  0b100..Single 16-bit counter disable mode.
 *  0b101..Dual 8-bit counters word mode.
 *  0b110..Dual 8-bit counters PWM low mode.
 *  0b111..Single 16-bit input capture mode.
 */
#define FLEXIO_TIMCTL_TIMOD(x)                   (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMCTL_TIMOD_SHIFT)) & FLEXIO_TIMCTL_TIMOD_MASK)

#define FLEXIO_TIMCTL_ONETIM_MASK                (0x20U)
#define FLEXIO_TIMCTL_ONETIM_SHIFT               (5U)
/*! ONETIM - Timer One Time Operation
 *  0b0..The timer enable event is generated as normal.
 *  0b1..The timer enable event is blocked unless timer status flag is clear.
 */
#define FLEXIO_TIMCTL_ONETIM(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMCTL_ONETIM_SHIFT)) & FLEXIO_TIMCTL_ONETIM_MASK)

#define FLEXIO_TIMCTL_PININS_MASK                (0x40U)
#define FLEXIO_TIMCTL_PININS_SHIFT               (6U)
/*! PININS - Timer Pin Input Select
 *  0b0..Timer pin input and output are selected by PINSEL.
 *  0b1..Timer pin input is selected by PINSEL+1, timer pin output remains selected by PINSEL.
 */
#define FLEXIO_TIMCTL_PININS(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMCTL_PININS_SHIFT)) & FLEXIO_TIMCTL_PININS_MASK)

#define FLEXIO_TIMCTL_PINPOL_MASK                (0x80U)
#define FLEXIO_TIMCTL_PINPOL_SHIFT               (7U)
/*! PINPOL - Timer Pin Polarity
 *  0b0..Pin is active high
 *  0b1..Pin is active low
 */
#define FLEXIO_TIMCTL_PINPOL(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMCTL_PINPOL_SHIFT)) & FLEXIO_TIMCTL_PINPOL_MASK)

#define FLEXIO_TIMCTL_PINSEL_MASK                (0x1F00U)
#define FLEXIO_TIMCTL_PINSEL_SHIFT               (8U)
/*! PINSEL - Timer Pin Select
 */
#define FLEXIO_TIMCTL_PINSEL(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMCTL_PINSEL_SHIFT)) & FLEXIO_TIMCTL_PINSEL_MASK)

#define FLEXIO_TIMCTL_PINCFG_MASK                (0x30000U)
#define FLEXIO_TIMCTL_PINCFG_SHIFT               (16U)
/*! PINCFG - Timer Pin Configuration
 *  0b00..Timer pin output disabled
 *  0b01..Timer pin open drain or bidirectional output enable
 *  0b10..Timer pin bidirectional output data
 *  0b11..Timer pin output
 */
#define FLEXIO_TIMCTL_PINCFG(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMCTL_PINCFG_SHIFT)) & FLEXIO_TIMCTL_PINCFG_MASK)

#define FLEXIO_TIMCTL_TRGSRC_MASK                (0x400000U)
#define FLEXIO_TIMCTL_TRGSRC_SHIFT               (22U)
/*! TRGSRC - Trigger Source
 *  0b0..External trigger selected
 *  0b1..Internal trigger selected
 */
#define FLEXIO_TIMCTL_TRGSRC(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMCTL_TRGSRC_SHIFT)) & FLEXIO_TIMCTL_TRGSRC_MASK)

#define FLEXIO_TIMCTL_TRGPOL_MASK                (0x800000U)
#define FLEXIO_TIMCTL_TRGPOL_SHIFT               (23U)
/*! TRGPOL - Trigger Polarity
 *  0b0..Trigger active high
 *  0b1..Trigger active low
 */
#define FLEXIO_TIMCTL_TRGPOL(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMCTL_TRGPOL_SHIFT)) & FLEXIO_TIMCTL_TRGPOL_MASK)

#define FLEXIO_TIMCTL_TRGSEL_MASK                (0x3F000000U)
#define FLEXIO_TIMCTL_TRGSEL_SHIFT               (24U)
/*! TRGSEL - Trigger Select
 */
#define FLEXIO_TIMCTL_TRGSEL(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMCTL_TRGSEL_SHIFT)) & FLEXIO_TIMCTL_TRGSEL_MASK)
/*! @} */

/* The count of FLEXIO_TIMCTL */
#define FLEXIO_TIMCTL_COUNT                      (8U)

/*! @name TIMCFG - Timer Configuration N Register */
/*! @{ */

#define FLEXIO_TIMCFG_TSTART_MASK                (0x2U)
#define FLEXIO_TIMCFG_TSTART_SHIFT               (1U)
/*! TSTART - Timer Start Bit
 *  0b0..Start bit disabled
 *  0b1..Start bit enabled
 */
#define FLEXIO_TIMCFG_TSTART(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMCFG_TSTART_SHIFT)) & FLEXIO_TIMCFG_TSTART_MASK)

#define FLEXIO_TIMCFG_TSTOP_MASK                 (0x30U)
#define FLEXIO_TIMCFG_TSTOP_SHIFT                (4U)
/*! TSTOP - Timer Stop Bit
 *  0b00..Stop bit disabled
 *  0b01..Stop bit is enabled on timer compare
 *  0b10..Stop bit is enabled on timer disable
 *  0b11..Stop bit is enabled on timer compare and timer disable
 */
#define FLEXIO_TIMCFG_TSTOP(x)                   (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMCFG_TSTOP_SHIFT)) & FLEXIO_TIMCFG_TSTOP_MASK)

#define FLEXIO_TIMCFG_TIMENA_MASK                (0x700U)
#define FLEXIO_TIMCFG_TIMENA_SHIFT               (8U)
/*! TIMENA - Timer Enable
 *  0b000..Timer always enabled
 *  0b001..Timer enabled on Timer N-1 enable
 *  0b010..Timer enabled on Trigger high
 *  0b011..Timer enabled on Trigger high and Pin high
 *  0b100..Timer enabled on Pin rising edge
 *  0b101..Timer enabled on Pin rising edge and Trigger high
 *  0b110..Timer enabled on Trigger rising edge
 *  0b111..Timer enabled on Trigger rising or falling edge
 */
#define FLEXIO_TIMCFG_TIMENA(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMCFG_TIMENA_SHIFT)) & FLEXIO_TIMCFG_TIMENA_MASK)

#define FLEXIO_TIMCFG_TIMDIS_MASK                (0x7000U)
#define FLEXIO_TIMCFG_TIMDIS_SHIFT               (12U)
/*! TIMDIS - Timer Disable
 *  0b000..Timer never disabled
 *  0b001..Timer disabled on Timer N-1 disable
 *  0b010..Timer disabled on Timer compare (upper 8-bits match and decrement)
 *  0b011..Timer disabled on Timer compare (upper 8-bits match and decrement) and Trigger Low
 *  0b100..Timer disabled on Pin rising or falling edge
 *  0b101..Timer disabled on Pin rising or falling edge provided Trigger is high
 *  0b110..Timer disabled on Trigger falling edge
 *  0b111..Reserved
 */
#define FLEXIO_TIMCFG_TIMDIS(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMCFG_TIMDIS_SHIFT)) & FLEXIO_TIMCFG_TIMDIS_MASK)

#define FLEXIO_TIMCFG_TIMRST_MASK                (0x70000U)
#define FLEXIO_TIMCFG_TIMRST_SHIFT               (16U)
/*! TIMRST - Timer Reset
 *  0b000..Timer never reset
 *  0b001..Timer reset on Timer Output high.
 *  0b010..Timer reset on Timer Pin equal to Timer Output
 *  0b011..Timer reset on Timer Trigger equal to Timer Output
 *  0b100..Timer reset on Timer Pin rising edge
 *  0b101..Reserved
 *  0b110..Timer reset on Trigger rising edge
 *  0b111..Timer reset on Trigger rising or falling edge
 */
#define FLEXIO_TIMCFG_TIMRST(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMCFG_TIMRST_SHIFT)) & FLEXIO_TIMCFG_TIMRST_MASK)

#define FLEXIO_TIMCFG_TIMDEC_MASK                (0x700000U)
#define FLEXIO_TIMCFG_TIMDEC_SHIFT               (20U)
/*! TIMDEC - Timer Decrement
 *  0b000..Decrement counter on FlexIO clock, Shift clock equals Timer output.
 *  0b001..Decrement counter on Trigger input (both edges), Shift clock equals Timer output.
 *  0b010..Decrement counter on Pin input (both edges), Shift clock equals Pin input.
 *  0b011..Decrement counter on Trigger input (both edges), Shift clock equals Trigger input.
 *  0b100..Decrement counter on FlexIO clock divided by 16, Shift clock equals Timer output.
 *  0b101..Decrement counter on FlexIO clock divided by 256, Shift clock equals Timer output.
 *  0b110..Decrement counter on Pin input (rising edge), Shift clock equals Pin input.
 *  0b111..Decrement counter on Trigger input (rising edge), Shift clock equals Trigger input.
 */
#define FLEXIO_TIMCFG_TIMDEC(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMCFG_TIMDEC_SHIFT)) & FLEXIO_TIMCFG_TIMDEC_MASK)

#define FLEXIO_TIMCFG_TIMOUT_MASK                (0x3000000U)
#define FLEXIO_TIMCFG_TIMOUT_SHIFT               (24U)
/*! TIMOUT - Timer Output
 *  0b00..Timer output is logic one when enabled and is not affected by timer reset
 *  0b01..Timer output is logic zero when enabled and is not affected by timer reset
 *  0b10..Timer output is logic one when enabled and on timer reset
 *  0b11..Timer output is logic zero when enabled and on timer reset
 */
#define FLEXIO_TIMCFG_TIMOUT(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMCFG_TIMOUT_SHIFT)) & FLEXIO_TIMCFG_TIMOUT_MASK)
/*! @} */

/* The count of FLEXIO_TIMCFG */
#define FLEXIO_TIMCFG_COUNT                      (8U)

/*! @name TIMCMP - Timer Compare N Register */
/*! @{ */

#define FLEXIO_TIMCMP_CMP_MASK                   (0xFFFFU)
#define FLEXIO_TIMCMP_CMP_SHIFT                  (0U)
/*! CMP - Timer Compare Value
 */
#define FLEXIO_TIMCMP_CMP(x)                     (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMCMP_CMP_SHIFT)) & FLEXIO_TIMCMP_CMP_MASK)
/*! @} */

/* The count of FLEXIO_TIMCMP */
#define FLEXIO_TIMCMP_COUNT                      (8U)

/*! @name SHIFTBUFNBS - Shifter Buffer N Nibble Byte Swapped Register */
/*! @{ */

#define FLEXIO_SHIFTBUFNBS_SHIFTBUFNBS_MASK      (0xFFFFFFFFU)
#define FLEXIO_SHIFTBUFNBS_SHIFTBUFNBS_SHIFT     (0U)
/*! SHIFTBUFNBS - Shift Buffer
 */
#define FLEXIO_SHIFTBUFNBS_SHIFTBUFNBS(x)        (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTBUFNBS_SHIFTBUFNBS_SHIFT)) & FLEXIO_SHIFTBUFNBS_SHIFTBUFNBS_MASK)
/*! @} */

/* The count of FLEXIO_SHIFTBUFNBS */
#define FLEXIO_SHIFTBUFNBS_COUNT                 (8U)

/*! @name SHIFTBUFHWS - Shifter Buffer N Half Word Swapped Register */
/*! @{ */

#define FLEXIO_SHIFTBUFHWS_SHIFTBUFHWS_MASK      (0xFFFFFFFFU)
#define FLEXIO_SHIFTBUFHWS_SHIFTBUFHWS_SHIFT     (0U)
/*! SHIFTBUFHWS - Shift Buffer
 */
#define FLEXIO_SHIFTBUFHWS_SHIFTBUFHWS(x)        (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTBUFHWS_SHIFTBUFHWS_SHIFT)) & FLEXIO_SHIFTBUFHWS_SHIFTBUFHWS_MASK)
/*! @} */

/* The count of FLEXIO_SHIFTBUFHWS */
#define FLEXIO_SHIFTBUFHWS_COUNT                 (8U)

/*! @name SHIFTBUFNIS - Shifter Buffer N Nibble Swapped Register */
/*! @{ */

#define FLEXIO_SHIFTBUFNIS_SHIFTBUFNIS_MASK      (0xFFFFFFFFU)
#define FLEXIO_SHIFTBUFNIS_SHIFTBUFNIS_SHIFT     (0U)
/*! SHIFTBUFNIS - Shift Buffer
 */
#define FLEXIO_SHIFTBUFNIS_SHIFTBUFNIS(x)        (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTBUFNIS_SHIFTBUFNIS_SHIFT)) & FLEXIO_SHIFTBUFNIS_SHIFTBUFNIS_MASK)
/*! @} */

/* The count of FLEXIO_SHIFTBUFNIS */
#define FLEXIO_SHIFTBUFNIS_COUNT                 (8U)

/*! @name SHIFTBUFOES - Shifter Buffer N Odd Even Swapped Register */
/*! @{ */

#define FLEXIO_SHIFTBUFOES_SHIFTBUFOES_MASK      (0xFFFFFFFFU)
#define FLEXIO_SHIFTBUFOES_SHIFTBUFOES_SHIFT     (0U)
/*! SHIFTBUFOES - Shift Buffer
 */
#define FLEXIO_SHIFTBUFOES_SHIFTBUFOES(x)        (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTBUFOES_SHIFTBUFOES_SHIFT)) & FLEXIO_SHIFTBUFOES_SHIFTBUFOES_MASK)
/*! @} */

/* The count of FLEXIO_SHIFTBUFOES */
#define FLEXIO_SHIFTBUFOES_COUNT                 (8U)

/*! @name SHIFTBUFEOS - Shifter Buffer N Even Odd Swapped Register */
/*! @{ */

#define FLEXIO_SHIFTBUFEOS_SHIFTBUFEOS_MASK      (0xFFFFFFFFU)
#define FLEXIO_SHIFTBUFEOS_SHIFTBUFEOS_SHIFT     (0U)
/*! SHIFTBUFEOS - Shift Buffer
 */
#define FLEXIO_SHIFTBUFEOS_SHIFTBUFEOS(x)        (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTBUFEOS_SHIFTBUFEOS_SHIFT)) & FLEXIO_SHIFTBUFEOS_SHIFTBUFEOS_MASK)
/*! @} */

/* The count of FLEXIO_SHIFTBUFEOS */
#define FLEXIO_SHIFTBUFEOS_COUNT                 (8U)

/*! @name SHIFTBUFHBS - Shifter Buffer N Halfword Byte Swapped Register */
/*! @{ */

#define FLEXIO_SHIFTBUFHBS_SHIFTBUFHBS_MASK      (0xFFFFFFFFU)
#define FLEXIO_SHIFTBUFHBS_SHIFTBUFHBS_SHIFT     (0U)
/*! SHIFTBUFHBS - Shift Buffer
 */
#define FLEXIO_SHIFTBUFHBS_SHIFTBUFHBS(x)        (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTBUFHBS_SHIFTBUFHBS_SHIFT)) & FLEXIO_SHIFTBUFHBS_SHIFTBUFHBS_MASK)
/*! @} */

/* The count of FLEXIO_SHIFTBUFHBS */
#define FLEXIO_SHIFTBUFHBS_COUNT                 (8U)


/*!
 * @}
 */ /* end of group FLEXIO_Register_Masks */


/* FLEXIO - Peripheral instance base addresses */
#if (defined(__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE & 0x2))
  /** Peripheral FLEXIO0 base address */
  #define FLEXIO0_BASE                             (0x5003A000u)
  /** Peripheral FLEXIO0 base address */
  #define FLEXIO0_BASE_NS                          (0x4003A000u)
  /** Peripheral FLEXIO0 base pointer */
  #define FLEXIO0                                  ((FLEXIO_Type *)FLEXIO0_BASE)
  /** Peripheral FLEXIO0 base pointer */
  #define FLEXIO0_NS                               ((FLEXIO_Type *)FLEXIO0_BASE_NS)
  /** Array initializer of FLEXIO peripheral base addresses */
  #define FLEXIO_BASE_ADDRS                        { FLEXIO0_BASE }
  /** Array initializer of FLEXIO peripheral base pointers */
  #define FLEXIO_BASE_PTRS                         { FLEXIO0 }
  /** Array initializer of FLEXIO peripheral base addresses */
  #define FLEXIO_BASE_ADDRS_NS                     { FLEXIO0_BASE_NS }
  /** Array initializer of FLEXIO peripheral base pointers */
  #define FLEXIO_BASE_PTRS_NS                      { FLEXIO0_NS }
#else
  /** Peripheral FLEXIO0 base address */
  #define FLEXIO0_BASE                             (0x4003A000u)
  /** Peripheral FLEXIO0 base pointer */
  #define FLEXIO0                                  ((FLEXIO_Type *)FLEXIO0_BASE)
  /** Array initializer of FLEXIO peripheral base addresses */
  #define FLEXIO_BASE_ADDRS                        { FLEXIO0_BASE }
  /** Array initializer of FLEXIO peripheral base pointers */
  #define FLEXIO_BASE_PTRS                         { FLEXIO0 }
#endif
/** Interrupt vectors for the FLEXIO peripheral type */
#define FLEXIO_IRQS                              { FLEXIO0_IRQn }

/*!
 * @}
 */ /* end of group FLEXIO_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- FMU Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FMU_Peripheral_Access_Layer FMU Peripheral Access Layer
 * @{
 */

/** FMU - Register Layout Typedef */
typedef struct {
  __IO uint32_t FSTAT;                             /**< Flash Status Register, offset: 0x0 */
  __IO uint32_t FCNFG;                             /**< Flash Configuration Register, offset: 0x4 */
  __IO uint32_t FCTRL;                             /**< Flash Control Register, offset: 0x8 */
       uint8_t RESERVED_0[4];
  __IO uint32_t FCCOB[8];                          /**< Flash Common Command Object Registers, array offset: 0x10, array step: 0x4 */
} FMU_Type;

/* ----------------------------------------------------------------------------
   -- FMU Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FMU_Register_Masks FMU Register Masks
 * @{
 */

/*! @name FSTAT - Flash Status Register */
/*! @{ */

#define FMU_FSTAT_FAIL_MASK                      (0x1U)
#define FMU_FSTAT_FAIL_SHIFT                     (0U)
/*! FAIL - Command Fail Flag
 *  0b0..Error not detected
 *  0b1..Error detected
 */
#define FMU_FSTAT_FAIL(x)                        (((uint32_t)(((uint32_t)(x)) << FMU_FSTAT_FAIL_SHIFT)) & FMU_FSTAT_FAIL_MASK)

#define FMU_FSTAT_CMDABT_MASK                    (0x4U)
#define FMU_FSTAT_CMDABT_SHIFT                   (2U)
/*! CMDABT - Command Abort Flag
 *  0b0..No command abort detected
 *  0b1..Command abort detected
 */
#define FMU_FSTAT_CMDABT(x)                      (((uint32_t)(((uint32_t)(x)) << FMU_FSTAT_CMDABT_SHIFT)) & FMU_FSTAT_CMDABT_MASK)

#define FMU_FSTAT_PVIOL_MASK                     (0x10U)
#define FMU_FSTAT_PVIOL_SHIFT                    (4U)
/*! PVIOL - Command Protection Violation Flag
 *  0b0..No protection violation detected
 *  0b1..Protection violation detected
 */
#define FMU_FSTAT_PVIOL(x)                       (((uint32_t)(((uint32_t)(x)) << FMU_FSTAT_PVIOL_SHIFT)) & FMU_FSTAT_PVIOL_MASK)

#define FMU_FSTAT_ACCERR_MASK                    (0x20U)
#define FMU_FSTAT_ACCERR_SHIFT                   (5U)
/*! ACCERR - Command Access Error Flag
 *  0b0..No access error detected
 *  0b1..Access error detected
 */
#define FMU_FSTAT_ACCERR(x)                      (((uint32_t)(((uint32_t)(x)) << FMU_FSTAT_ACCERR_SHIFT)) & FMU_FSTAT_ACCERR_MASK)

#define FMU_FSTAT_CWSABT_MASK                    (0x40U)
#define FMU_FSTAT_CWSABT_SHIFT                   (6U)
/*! CWSABT - Command Write Sequence Abort Flag
 *  0b0..Command write sequence not aborted
 *  0b1..Command write sequence aborted
 */
#define FMU_FSTAT_CWSABT(x)                      (((uint32_t)(((uint32_t)(x)) << FMU_FSTAT_CWSABT_SHIFT)) & FMU_FSTAT_CWSABT_MASK)

#define FMU_FSTAT_CCIF_MASK                      (0x80U)
#define FMU_FSTAT_CCIF_SHIFT                     (7U)
/*! CCIF - Command Complete Interrupt Flag
 *  0b0..Flash command, initialization, or power mode recovery in progress
 *  0b1..Flash command, initialization, or power mode recovery has completed
 */
#define FMU_FSTAT_CCIF(x)                        (((uint32_t)(((uint32_t)(x)) << FMU_FSTAT_CCIF_SHIFT)) & FMU_FSTAT_CCIF_MASK)

#define FMU_FSTAT_CMDPRT_MASK                    (0x300U)
#define FMU_FSTAT_CMDPRT_SHIFT                   (8U)
/*! CMDPRT - Command protection level
 *  0b00..Secure, normal access
 *  0b01..Secure, privileged access
 *  0b10..Nonsecure, normal access
 *  0b11..Nonsecure, privileged access
 */
#define FMU_FSTAT_CMDPRT(x)                      (((uint32_t)(((uint32_t)(x)) << FMU_FSTAT_CMDPRT_SHIFT)) & FMU_FSTAT_CMDPRT_MASK)

#define FMU_FSTAT_CMDP_MASK                      (0x800U)
#define FMU_FSTAT_CMDP_SHIFT                     (11U)
/*! CMDP - Command protection status flag
 *  0b0..Command protection level and domain ID are stale
 *  0b1..Command protection level (CMDPRT) and domain ID (CMDDID) are set
 */
#define FMU_FSTAT_CMDP(x)                        (((uint32_t)(((uint32_t)(x)) << FMU_FSTAT_CMDP_SHIFT)) & FMU_FSTAT_CMDP_MASK)

#define FMU_FSTAT_CMDDID_MASK                    (0xF000U)
#define FMU_FSTAT_CMDDID_SHIFT                   (12U)
/*! CMDDID - Command domain ID
 */
#define FMU_FSTAT_CMDDID(x)                      (((uint32_t)(((uint32_t)(x)) << FMU_FSTAT_CMDDID_SHIFT)) & FMU_FSTAT_CMDDID_MASK)

#define FMU_FSTAT_DFDIF_MASK                     (0x10000U)
#define FMU_FSTAT_DFDIF_SHIFT                    (16U)
/*! DFDIF - Double Bit Fault Detect Interrupt Flag
 *  0b0..Double bit fault not detected during a valid flash read access
 *  0b1..Double bit fault detected (or FCTRL[FDFD] is set) during a valid flash read access
 */
#define FMU_FSTAT_DFDIF(x)                       (((uint32_t)(((uint32_t)(x)) << FMU_FSTAT_DFDIF_SHIFT)) & FMU_FSTAT_DFDIF_MASK)

#define FMU_FSTAT_SALV_USED_MASK                 (0x20000U)
#define FMU_FSTAT_SALV_USED_SHIFT                (17U)
/*! SALV_USED - Salvage Used for Erase operation
 *  0b0..Salvage not used during last operation
 *  0b1..Salvage used during the last erase operation
 */
#define FMU_FSTAT_SALV_USED(x)                   (((uint32_t)(((uint32_t)(x)) << FMU_FSTAT_SALV_USED_SHIFT)) & FMU_FSTAT_SALV_USED_MASK)

#define FMU_FSTAT_PEWEN_MASK                     (0x3000000U)
#define FMU_FSTAT_PEWEN_SHIFT                    (24U)
/*! PEWEN - Program-Erase Write Enable Control
 *  0b00..Writes are not enabled
 *  0b01..Writes are enabled for one flash or IFR phrase (phrase programming, sector erase)
 *  0b10..Writes are enabled for one flash or IFR page (page programming)
 *  0b11..Reserved
 */
#define FMU_FSTAT_PEWEN(x)                       (((uint32_t)(((uint32_t)(x)) << FMU_FSTAT_PEWEN_SHIFT)) & FMU_FSTAT_PEWEN_MASK)

#define FMU_FSTAT_PERDY_MASK                     (0x80000000U)
#define FMU_FSTAT_PERDY_SHIFT                    (31U)
/*! PERDY - Program-Erase Ready Control/Status Flag
 *  0b0..Program or sector erase command operation not stalled
 *  0b1..Program or sector erase command operation ready to execute
 */
#define FMU_FSTAT_PERDY(x)                       (((uint32_t)(((uint32_t)(x)) << FMU_FSTAT_PERDY_SHIFT)) & FMU_FSTAT_PERDY_MASK)
/*! @} */

/*! @name FCNFG - Flash Configuration Register */
/*! @{ */

#define FMU_FCNFG_CCIE_MASK                      (0x80U)
#define FMU_FCNFG_CCIE_SHIFT                     (7U)
/*! CCIE - Command Complete Interrupt Enable
 *  0b0..Command complete interrupt disabled
 *  0b1..Command complete interrupt enabled
 */
#define FMU_FCNFG_CCIE(x)                        (((uint32_t)(((uint32_t)(x)) << FMU_FCNFG_CCIE_SHIFT)) & FMU_FCNFG_CCIE_MASK)

#define FMU_FCNFG_ERSREQ_MASK                    (0x100U)
#define FMU_FCNFG_ERSREQ_SHIFT                   (8U)
/*! ERSREQ - Mass Erase Request
 *  0b0..No request or request complete
 *  0b1..Request to run the Mass Erase operation
 */
#define FMU_FCNFG_ERSREQ(x)                      (((uint32_t)(((uint32_t)(x)) << FMU_FCNFG_ERSREQ_SHIFT)) & FMU_FCNFG_ERSREQ_MASK)

#define FMU_FCNFG_DFDIE_MASK                     (0x10000U)
#define FMU_FCNFG_DFDIE_SHIFT                    (16U)
/*! DFDIE - Double Bit Fault Detect Interrupt Enable
 *  0b0..Double bit fault detect interrupt disabled
 *  0b1..Double bit fault detect interrupt enabled
 */
#define FMU_FCNFG_DFDIE(x)                       (((uint32_t)(((uint32_t)(x)) << FMU_FCNFG_DFDIE_SHIFT)) & FMU_FCNFG_DFDIE_MASK)

#define FMU_FCNFG_ERSIEN0_MASK                   (0xF000000U)
#define FMU_FCNFG_ERSIEN0_SHIFT                  (24U)
/*! ERSIEN0 - Erase IFR Sector Enable - Block 0
 *  0b0000..Block 0 IFR Sector X is protected from erase by ERSSCR command
 *  0b0001..Block 0 IFR Sector X is not protected from erase by ERSSCR command
 */
#define FMU_FCNFG_ERSIEN0(x)                     (((uint32_t)(((uint32_t)(x)) << FMU_FCNFG_ERSIEN0_SHIFT)) & FMU_FCNFG_ERSIEN0_MASK)

#define FMU_FCNFG_ERSIEN1_MASK                   (0xF0000000U)
#define FMU_FCNFG_ERSIEN1_SHIFT                  (28U)
/*! ERSIEN1 - Erase IFR Sector Enable - Block 1 (for dual block configs)
 *  0b0000..Block 1 IFR Sector X is protected from erase by ERSSCR command
 *  0b0001..Block 1 IFR Sector X is not protected from erase by ERSSCR command
 */
#define FMU_FCNFG_ERSIEN1(x)                     (((uint32_t)(((uint32_t)(x)) << FMU_FCNFG_ERSIEN1_SHIFT)) & FMU_FCNFG_ERSIEN1_MASK)
/*! @} */

/*! @name FCTRL - Flash Control Register */
/*! @{ */

#define FMU_FCTRL_RWSC_MASK                      (0xFU)
#define FMU_FCTRL_RWSC_SHIFT                     (0U)
/*! RWSC - Read Wait-State Control
 */
#define FMU_FCTRL_RWSC(x)                        (((uint32_t)(((uint32_t)(x)) << FMU_FCTRL_RWSC_SHIFT)) & FMU_FCTRL_RWSC_MASK)

#define FMU_FCTRL_LSACTIVE_MASK                  (0x100U)
#define FMU_FCTRL_LSACTIVE_SHIFT                 (8U)
/*! LSACTIVE - Low speed active mode
 *  0b0..Full speed active mode requested
 *  0b1..Low speed active mode requested
 */
#define FMU_FCTRL_LSACTIVE(x)                    (((uint32_t)(((uint32_t)(x)) << FMU_FCTRL_LSACTIVE_SHIFT)) & FMU_FCTRL_LSACTIVE_MASK)

#define FMU_FCTRL_FDFD_MASK                      (0x10000U)
#define FMU_FCTRL_FDFD_SHIFT                     (16U)
/*! FDFD - Force Double Bit Fault Detect
 *  0b0..FSTAT[DFDIF] sets only if a double bit fault is detected during a valid flash read access from the platform flash controller
 *  0b1..FSTAT[DFDIF] sets during any valid flash read access from the platform flash controller. An interrupt
 *       request is generated if the DFDIE bit is set.
 */
#define FMU_FCTRL_FDFD(x)                        (((uint32_t)(((uint32_t)(x)) << FMU_FCTRL_FDFD_SHIFT)) & FMU_FCTRL_FDFD_MASK)

#define FMU_FCTRL_ABTREQ_MASK                    (0x1000000U)
#define FMU_FCTRL_ABTREQ_SHIFT                   (24U)
/*! ABTREQ - Abort Request
 *  0b0..No request to abort a command write sequence
 *  0b1..Request to abort a command write sequence
 */
#define FMU_FCTRL_ABTREQ(x)                      (((uint32_t)(((uint32_t)(x)) << FMU_FCTRL_ABTREQ_SHIFT)) & FMU_FCTRL_ABTREQ_MASK)
/*! @} */

/*! @name FCCOB - Flash Common Command Object Registers */
/*! @{ */

#define FMU_FCCOB_CCOBn_MASK                     (0xFFFFFFFFU)
#define FMU_FCCOB_CCOBn_SHIFT                    (0U)
/*! CCOBn - CCOBn
 */
#define FMU_FCCOB_CCOBn(x)                       (((uint32_t)(((uint32_t)(x)) << FMU_FCCOB_CCOBn_SHIFT)) & FMU_FCCOB_CCOBn_MASK)
/*! @} */

/* The count of FMU_FCCOB */
#define FMU_FCCOB_COUNT                          (8U)


/*!
 * @}
 */ /* end of group FMU_Register_Masks */


/* FMU - Peripheral instance base addresses */
#if (defined(__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE & 0x2))
  /** Peripheral FMU0 base address */
  #define FMU0_BASE                                (0x50020000u)
  /** Peripheral FMU0 base address */
  #define FMU0_BASE_NS                             (0x40020000u)
  /** Peripheral FMU0 base pointer */
  #define FMU0                                     ((FMU_Type *)FMU0_BASE)
  /** Peripheral FMU0 base pointer */
  #define FMU0_NS                                  ((FMU_Type *)FMU0_BASE_NS)
  /** Peripheral RF_FMU base address */
  #define RF_FMU_BASE                              (0x58981000u)
  /** Peripheral RF_FMU base address */
  #define RF_FMU_BASE_NS                           (0x48981000u)
  /** Peripheral RF_FMU base pointer */
  #define RF_FMU                                   ((FMU_Type *)RF_FMU_BASE)
  /** Peripheral RF_FMU base pointer */
  #define RF_FMU_NS                                ((FMU_Type *)RF_FMU_BASE_NS)
  /** Array initializer of FMU peripheral base addresses */
  #define FMU_BASE_ADDRS                           { FMU0_BASE, RF_FMU_BASE }
  /** Array initializer of FMU peripheral base pointers */
  #define FMU_BASE_PTRS                            { FMU0, RF_FMU }
  /** Array initializer of FMU peripheral base addresses */
  #define FMU_BASE_ADDRS_NS                        { FMU0_BASE_NS, RF_FMU_BASE_NS }
  /** Array initializer of FMU peripheral base pointers */
  #define FMU_BASE_PTRS_NS                         { FMU0_NS, RF_FMU_NS }
#else
  /** Peripheral FMU0 base address */
  #define FMU0_BASE                                (0x40020000u)
  /** Peripheral FMU0 base pointer */
  #define FMU0                                     ((FMU_Type *)FMU0_BASE)
  /** Peripheral RF_FMU base address */
  #define RF_FMU_BASE                              (0x48981000u)
  /** Peripheral RF_FMU base pointer */
  #define RF_FMU                                   ((FMU_Type *)RF_FMU_BASE)
  /** Array initializer of FMU peripheral base addresses */
  #define FMU_BASE_ADDRS                           { FMU0_BASE, RF_FMU_BASE }
  /** Array initializer of FMU peripheral base pointers */
  #define FMU_BASE_PTRS                            { FMU0, RF_FMU }
#endif

/*!
 * @}
 */ /* end of group FMU_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- FRO192M Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FRO192M_Peripheral_Access_Layer FRO192M Peripheral Access Layer
 * @{
 */

/** FRO192M - Register Layout Typedef */
typedef struct {
  __IO uint32_t FROCCSR;                           /**< FRO192 Clock Control Status Register, offset: 0x0 */
  __IO uint32_t FRODIV;                            /**< FRO192 Divide Register, offset: 0x4 */
} FRO192M_Type;

/* ----------------------------------------------------------------------------
   -- FRO192M Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FRO192M_Register_Masks FRO192M Register Masks
 * @{
 */

/*! @name FROCCSR - FRO192 Clock Control Status Register */
/*! @{ */

#define FRO192M_FROCCSR_FRODIV_MASK              (0x3U)
#define FRO192M_FROCCSR_FRODIV_SHIFT             (0U)
/*! FRODIV - FRO Clock Divide
 *  0b00..Divide by 1
 *  0b01..Divide by 2
 *  0b10..Divide by 3
 *  0b11..Divide by 4
 */
#define FRO192M_FROCCSR_FRODIV(x)                (((uint32_t)(((uint32_t)(x)) << FRO192M_FROCCSR_FRODIV_SHIFT)) & FRO192M_FROCCSR_FRODIV_MASK)

#define FRO192M_FROCCSR_POSTDIV_SEL_MASK         (0x7000U)
#define FRO192M_FROCCSR_POSTDIV_SEL_SHIFT        (12U)
/*! POSTDIV_SEL - Post Divider Clock Select
 *  0b000..FRO 16MHz Range selected.
 *  0b001..FRO 24MHz Range selected
 *  0b010..FRO 32MHz Range selected
 *  0b011..FRO 48MHz Range selected
 *  0b100..FRO 64MHz Range selected
 *  0b101..RESERVED. Not Supported
 *  0b110..RESERVED. Not Supported
 *  0b111..RESERVED. Not Supported
 */
#define FRO192M_FROCCSR_POSTDIV_SEL(x)           (((uint32_t)(((uint32_t)(x)) << FRO192M_FROCCSR_POSTDIV_SEL_SHIFT)) & FRO192M_FROCCSR_POSTDIV_SEL_MASK)

#define FRO192M_FROCCSR_VALID_MASK               (0x1000000U)
#define FRO192M_FROCCSR_VALID_SHIFT              (24U)
/*! VALID - Clock Valid Flag
 *  0b0..FRO192 is not enabled or clock is not valid.
 *  0b1..FRO192 is enabled and output clock is valid.
 */
#define FRO192M_FROCCSR_VALID(x)                 (((uint32_t)(((uint32_t)(x)) << FRO192M_FROCCSR_VALID_SHIFT)) & FRO192M_FROCCSR_VALID_MASK)
/*! @} */

/*! @name FRODIV - FRO192 Divide Register */
/*! @{ */

#define FRO192M_FRODIV_FRODIV_MASK               (0x3U)
#define FRO192M_FRODIV_FRODIV_SHIFT              (0U)
/*! FRODIV - FRO Clock Divide
 *  0b00..Divide by 1
 *  0b01..Divide by 2
 *  0b10..Divide by 3
 *  0b11..Divide by 4
 */
#define FRO192M_FRODIV_FRODIV(x)                 (((uint32_t)(((uint32_t)(x)) << FRO192M_FRODIV_FRODIV_SHIFT)) & FRO192M_FRODIV_FRODIV_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group FRO192M_Register_Masks */


/* FRO192M - Peripheral instance base addresses */
#if (defined(__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE & 0x2))
  /** Peripheral FRO192M0 base address */
  #define FRO192M0_BASE                            (0x58980000u)
  /** Peripheral FRO192M0 base address */
  #define FRO192M0_BASE_NS                         (0x48980000u)
  /** Peripheral FRO192M0 base pointer */
  #define FRO192M0                                 ((FRO192M_Type *)FRO192M0_BASE)
  /** Peripheral FRO192M0 base pointer */
  #define FRO192M0_NS                              ((FRO192M_Type *)FRO192M0_BASE_NS)
  /** Array initializer of FRO192M peripheral base addresses */
  #define FRO192M_BASE_ADDRS                       { FRO192M0_BASE }
  /** Array initializer of FRO192M peripheral base pointers */
  #define FRO192M_BASE_PTRS                        { FRO192M0 }
  /** Array initializer of FRO192M peripheral base addresses */
  #define FRO192M_BASE_ADDRS_NS                    { FRO192M0_BASE_NS }
  /** Array initializer of FRO192M peripheral base pointers */
  #define FRO192M_BASE_PTRS_NS                     { FRO192M0_NS }
#else
  /** Peripheral FRO192M0 base address */
  #define FRO192M0_BASE                            (0x48980000u)
  /** Peripheral FRO192M0 base pointer */
  #define FRO192M0                                 ((FRO192M_Type *)FRO192M0_BASE)
  /** Array initializer of FRO192M peripheral base addresses */
  #define FRO192M_BASE_ADDRS                       { FRO192M0_BASE }
  /** Array initializer of FRO192M peripheral base pointers */
  #define FRO192M_BASE_PTRS                        { FRO192M0 }
#endif

/*!
 * @}
 */ /* end of group FRO192M_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- GEN4PHY Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup GEN4PHY_Peripheral_Access_Layer GEN4PHY Peripheral Access Layer
 * @{
 */

/** GEN4PHY - Register Layout Typedef */
typedef struct {
  __IO uint32_t FSK_PD_CFG0;                       /**< PHY Uncoded Preamble Detect Config 0, offset: 0x0 */
  __IO uint32_t FSK_PD_CFG1;                       /**< PHY Uncoded Preamble Detect Config 1, offset: 0x4 */
  __IO uint32_t FSK_PD_CFG2;                       /**< PHY Uncoded Preamble Detect Config 2, offset: 0x8 */
  __IO uint32_t FSK_PD_PH[2];                      /**< , array offset: 0xC, array step: 0x4 */
  __I  uint32_t FSK_PD_RO_PH[4];                   /**< , array offset: 0x14, array step: 0x4 */
  __IO uint32_t FSK_CFG0;                          /**< PHY Uncoded Config 0, offset: 0x24 */
  __IO uint32_t FSK_CFG1;                          /**< PHY Uncoded Config 1, offset: 0x28 */
  __IO uint32_t FSK_CFG2;                          /**< PHY Uncoded Config 2, offset: 0x2C */
       uint8_t RESERVED_0[4];
  __IO uint32_t FSK_PT;                            /**< PHY Uncoded Power Threshold Config, offset: 0x34 */
  __IO uint32_t FSK_FAD_CTRL;                      /**< PHY Uncoded FAD Control, offset: 0x38 */
  __IO uint32_t FSK_FAD_CFG;                       /**< PHY Uncoded FAD Config, offset: 0x3C */
  __I  uint32_t FSK_STAT;                          /**< PHY Uncoded Status, offset: 0x40 */
  __IO uint32_t LR_PD_CFG;                         /**< PHY Long Range Preamble Detect Config, offset: 0x44 */
  __IO uint32_t LR_PD_PH[4];                       /**< , array offset: 0x48, array step: 0x4 */
  __I  uint32_t LR_PD_RO_PH[13];                   /**< , array offset: 0x58, array step: 0x4 */
  __IO uint32_t LR_AA_CFG;                         /**< PHY Long Range AA Config, offset: 0x8C */
  __I  uint32_t LR_STAT;                           /**< PHY Long Range Status, offset: 0x90 */
  __IO uint32_t SM_CFG;                            /**< PHY State Machine Config, offset: 0x94 */
  __IO uint32_t MISC;                              /**< PHY Misc Config, offset: 0x98 */
  __I  uint32_t STAT0;                             /**< PHY Status 0, offset: 0x9C */
  __I  uint32_t STAT1;                             /**< PHY Status 1, offset: 0xA0 */
  __I  uint32_t STAT2;                             /**< PHY Status 2, offset: 0xA4 */
  __IO uint32_t PREPHY_MISC;                       /**< PHY PrePHY Misc Config, offset: 0xA8 */
  __IO uint32_t DMD_CTRL0;                         /**< PHY Demodulator Control 0, offset: 0xAC */
  __IO uint32_t DMD_CTRL1;                         /**< PHY Dmodulator Control 1, offset: 0xB0 */
  __IO uint32_t DMD_CTRL2;                         /**< PHY Demodulator Control 2, offset: 0xB4 */
  struct {                                         /* offset: 0xB8, array step: 0xC */
    __IO uint32_t DMD_WAVE_REG0;                     /**< , array offset: 0xB8, array step: 0xC */
    __IO uint32_t DMD_WAVE_REG1;                     /**< , array offset: 0xBC, array step: 0xC */
    __IO uint32_t DMD_WAVE_REG2;                     /**< , array offset: 0xC0, array step: 0xC */
  } DEMOD_WAVE[8];
       uint8_t RESERVED_1[76];
  __IO uint32_t DMDAA_CTRL;                        /**< PHY Demodulator Based SFD Confirmation control register., offset: 0x164 */
  __I  uint32_t RTT_STAT;                          /**< High resolution Time-Of-Flight calculation Status., offset: 0x168 */
  __IO uint32_t RTT_CTRL;                          /**< PHY RTT control register., offset: 0x16C */
  __IO uint32_t RTT_REF;                           /**< PHY RTT reference register., offset: 0x170 */
} GEN4PHY_Type;

/* ----------------------------------------------------------------------------
   -- GEN4PHY Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup GEN4PHY_Register_Masks GEN4PHY Register Masks
 * @{
 */

/*! @name FSK_PD_CFG0 - PHY Uncoded Preamble Detect Config 0 */
/*! @{ */

#define GEN4PHY_FSK_PD_CFG0_PREAMBLE_T_SCALE_MASK (0xFU)
#define GEN4PHY_FSK_PD_CFG0_PREAMBLE_T_SCALE_SHIFT (0U)
/*! PREAMBLE_T_SCALE - Scaling factor used for fractional time estimation during preamble search.
 */
#define GEN4PHY_FSK_PD_CFG0_PREAMBLE_T_SCALE(x)  (((uint32_t)(((uint32_t)(x)) << GEN4PHY_FSK_PD_CFG0_PREAMBLE_T_SCALE_SHIFT)) & GEN4PHY_FSK_PD_CFG0_PREAMBLE_T_SCALE_MASK)

#define GEN4PHY_FSK_PD_CFG0_PD_IIR_ALPHA_MASK    (0xFF00U)
#define GEN4PHY_FSK_PD_CFG0_PD_IIR_ALPHA_SHIFT   (8U)
/*! PD_IIR_ALPHA - Forgetting factor used by the complex correlations smoothing leaky integrator.
 */
#define GEN4PHY_FSK_PD_CFG0_PD_IIR_ALPHA(x)      (((uint32_t)(((uint32_t)(x)) << GEN4PHY_FSK_PD_CFG0_PD_IIR_ALPHA_SHIFT)) & GEN4PHY_FSK_PD_CFG0_PD_IIR_ALPHA_MASK)
/*! @} */

/*! @name FSK_PD_CFG1 - PHY Uncoded Preamble Detect Config 1 */
/*! @{ */

#define GEN4PHY_FSK_PD_CFG1_PREAMBLE_PATTERN_MASK (0xFFU)
#define GEN4PHY_FSK_PD_CFG1_PREAMBLE_PATTERN_SHIFT (0U)
/*! PREAMBLE_PATTERN - 8-bit preamble pattern used in FM-domain preamble detector.
 */
#define GEN4PHY_FSK_PD_CFG1_PREAMBLE_PATTERN(x)  (((uint32_t)(((uint32_t)(x)) << GEN4PHY_FSK_PD_CFG1_PREAMBLE_PATTERN_SHIFT)) & GEN4PHY_FSK_PD_CFG1_PREAMBLE_PATTERN_MASK)
/*! @} */

/*! @name FSK_PD_CFG2 - PHY Uncoded Preamble Detect Config 2 */
/*! @{ */

#define GEN4PHY_FSK_PD_CFG2_PD_THRESH_ACQ_1_3_1M_MASK (0xFFU)
#define GEN4PHY_FSK_PD_CFG2_PD_THRESH_ACQ_1_3_1M_SHIFT (0U)
/*! PD_THRESH_ACQ_1_3_1M - Preamble detect threshold for acq mode 1 and 3 at data rate 1Mbps
 */
#define GEN4PHY_FSK_PD_CFG2_PD_THRESH_ACQ_1_3_1M(x) (((uint32_t)(((uint32_t)(x)) << GEN4PHY_FSK_PD_CFG2_PD_THRESH_ACQ_1_3_1M_SHIFT)) & GEN4PHY_FSK_PD_CFG2_PD_THRESH_ACQ_1_3_1M_MASK)

#define GEN4PHY_FSK_PD_CFG2_PD_THRESH_ACQ_1_3_2M_MASK (0xFF0000U)
#define GEN4PHY_FSK_PD_CFG2_PD_THRESH_ACQ_1_3_2M_SHIFT (16U)
/*! PD_THRESH_ACQ_1_3_2M - Preamble detect threshold for acq mode 1 and 3 at data rate 2Mbps
 */
#define GEN4PHY_FSK_PD_CFG2_PD_THRESH_ACQ_1_3_2M(x) (((uint32_t)(((uint32_t)(x)) << GEN4PHY_FSK_PD_CFG2_PD_THRESH_ACQ_1_3_2M_SHIFT)) & GEN4PHY_FSK_PD_CFG2_PD_THRESH_ACQ_1_3_2M_MASK)
/*! @} */

/*! @name FSK_PD_PH -  */
/*! @{ */

#define GEN4PHY_FSK_PD_PH_REF0_MASK              (0x3FU)
#define GEN4PHY_FSK_PD_PH_REF0_SHIFT             (0U)
/*! REF0 - Uncoded preamble reference waveform sample 4 (sfix6en5)
 */
#define GEN4PHY_FSK_PD_PH_REF0(x)                (((uint32_t)(((uint32_t)(x)) << GEN4PHY_FSK_PD_PH_REF0_SHIFT)) & GEN4PHY_FSK_PD_PH_REF0_MASK)

#define GEN4PHY_FSK_PD_PH_REF1_MASK              (0x3F00U)
#define GEN4PHY_FSK_PD_PH_REF1_SHIFT             (8U)
/*! REF1 - Uncoded preamble reference waveform sample 5 (sfix6en5)
 */
#define GEN4PHY_FSK_PD_PH_REF1(x)                (((uint32_t)(((uint32_t)(x)) << GEN4PHY_FSK_PD_PH_REF1_SHIFT)) & GEN4PHY_FSK_PD_PH_REF1_MASK)

#define GEN4PHY_FSK_PD_PH_REF2_MASK              (0x3F0000U)
#define GEN4PHY_FSK_PD_PH_REF2_SHIFT             (16U)
/*! REF2 - Uncoded preamble reference waveform sample 6 (sfix6en5)
 */
#define GEN4PHY_FSK_PD_PH_REF2(x)                (((uint32_t)(((uint32_t)(x)) << GEN4PHY_FSK_PD_PH_REF2_SHIFT)) & GEN4PHY_FSK_PD_PH_REF2_MASK)

#define GEN4PHY_FSK_PD_PH_REF3_MASK              (0x3F000000U)
#define GEN4PHY_FSK_PD_PH_REF3_SHIFT             (24U)
/*! REF3 - Uncoded preamble reference waveform sample 7 (sfix6en5)
 */
#define GEN4PHY_FSK_PD_PH_REF3(x)                (((uint32_t)(((uint32_t)(x)) << GEN4PHY_FSK_PD_PH_REF3_SHIFT)) & GEN4PHY_FSK_PD_PH_REF3_MASK)
/*! @} */

/* The count of GEN4PHY_FSK_PD_PH */
#define GEN4PHY_FSK_PD_PH_COUNT                  (2U)

/*! @name FSK_PD_RO_PH -  */
/*! @{ */

#define GEN4PHY_FSK_PD_RO_PH_REF0_MASK           (0x3FU)
#define GEN4PHY_FSK_PD_RO_PH_REF0_SHIFT          (0U)
/*! REF0 - Uncoded preamble reference waveform sample 28 (sfix6en5)
 */
#define GEN4PHY_FSK_PD_RO_PH_REF0(x)             (((uint32_t)(((uint32_t)(x)) << GEN4PHY_FSK_PD_RO_PH_REF0_SHIFT)) & GEN4PHY_FSK_PD_RO_PH_REF0_MASK)

#define GEN4PHY_FSK_PD_RO_PH_REF1_MASK           (0x3F00U)
#define GEN4PHY_FSK_PD_RO_PH_REF1_SHIFT          (8U)
/*! REF1 - Uncoded preamble reference waveform sample 29 (sfix6en5)
 */
#define GEN4PHY_FSK_PD_RO_PH_REF1(x)             (((uint32_t)(((uint32_t)(x)) << GEN4PHY_FSK_PD_RO_PH_REF1_SHIFT)) & GEN4PHY_FSK_PD_RO_PH_REF1_MASK)

#define GEN4PHY_FSK_PD_RO_PH_REF2_MASK           (0x3F0000U)
#define GEN4PHY_FSK_PD_RO_PH_REF2_SHIFT          (16U)
/*! REF2 - Uncoded preamble reference waveform sample 30 (sfix6en5)
 */
#define GEN4PHY_FSK_PD_RO_PH_REF2(x)             (((uint32_t)(((uint32_t)(x)) << GEN4PHY_FSK_PD_RO_PH_REF2_SHIFT)) & GEN4PHY_FSK_PD_RO_PH_REF2_MASK)

#define GEN4PHY_FSK_PD_RO_PH_REF3_MASK           (0x3F000000U)
#define GEN4PHY_FSK_PD_RO_PH_REF3_SHIFT          (24U)
/*! REF3 - Uncoded preamble reference waveform sample 31 (sfix6en5)
 */
#define GEN4PHY_FSK_PD_RO_PH_REF3(x)             (((uint32_t)(((uint32_t)(x)) << GEN4PHY_FSK_PD_RO_PH_REF3_SHIFT)) & GEN4PHY_FSK_PD_RO_PH_REF3_MASK)
/*! @} */

/* The count of GEN4PHY_FSK_PD_RO_PH */
#define GEN4PHY_FSK_PD_RO_PH_COUNT               (4U)

/*! @name FSK_CFG0 - PHY Uncoded Config 0 */
/*! @{ */

#define GEN4PHY_FSK_CFG0_AA_OUT_SEL_MASK         (0x2U)
#define GEN4PHY_FSK_CFG0_AA_OUT_SEL_SHIFT        (1U)
/*! AA_OUT_SEL - Specifies which AA bits to be played-back to the LL:
 *  0b0..output the received AA bits
 *  0b1..output the programmed AA bits
 */
#define GEN4PHY_FSK_CFG0_AA_OUT_SEL(x)           (((uint32_t)(((uint32_t)(x)) << GEN4PHY_FSK_CFG0_AA_OUT_SEL_SHIFT)) & GEN4PHY_FSK_CFG0_AA_OUT_SEL_MASK)

#define GEN4PHY_FSK_CFG0_FSK_BIT_INVERT_MASK     (0x4U)
#define GEN4PHY_FSK_CFG0_FSK_BIT_INVERT_SHIFT    (2U)
/*! FSK_BIT_INVERT - This applies at the demodulator, so it affects both AA and the data portions of the packet.
 *  0b0..Normal demodulation
 *  0b1..Invert demodulated bits
 */
#define GEN4PHY_FSK_CFG0_FSK_BIT_INVERT(x)       (((uint32_t)(((uint32_t)(x)) << GEN4PHY_FSK_CFG0_FSK_BIT_INVERT_SHIFT)) & GEN4PHY_FSK_CFG0_FSK_BIT_INVERT_MASK)

#define GEN4PHY_FSK_CFG0_MSK_EN_MASK             (0x20U)
#define GEN4PHY_FSK_CFG0_MSK_EN_SHIFT            (5U)
/*! MSK_EN - Configures PHY for MSK decoding.
 */
#define GEN4PHY_FSK_CFG0_MSK_EN(x)               (((uint32_t)(((uint32_t)(x)) << GEN4PHY_FSK_CFG0_MSK_EN_SHIFT)) & GEN4PHY_FSK_CFG0_MSK_EN_MASK)

#define GEN4PHY_FSK_CFG0_MSK2FSK_SEED_MASK       (0x40U)
#define GEN4PHY_FSK_CFG0_MSK2FSK_SEED_SHIFT      (6U)
/*! MSK2FSK_SEED - Last bit of preamble.
 */
#define GEN4PHY_FSK_CFG0_MSK2FSK_SEED(x)         (((uint32_t)(((uint32_t)(x)) << GEN4PHY_FSK_CFG0_MSK2FSK_SEED_SHIFT)) & GEN4PHY_FSK_CFG0_MSK2FSK_SEED_MASK)

#define GEN4PHY_FSK_CFG0_AA_ACQ_1_2_3_THRESH_1M_MASK (0x1F00U)
#define GEN4PHY_FSK_CFG0_AA_ACQ_1_2_3_THRESH_1M_SHIFT (8U)
/*! AA_ACQ_1_2_3_THRESH_1M - For 1Mbps data rate, Correlation threshold applicable to AA detection; uses ufix5_En5 fixed-point format.
 */
#define GEN4PHY_FSK_CFG0_AA_ACQ_1_2_3_THRESH_1M(x) (((uint32_t)(((uint32_t)(x)) << GEN4PHY_FSK_CFG0_AA_ACQ_1_2_3_THRESH_1M_SHIFT)) & GEN4PHY_FSK_CFG0_AA_ACQ_1_2_3_THRESH_1M_MASK)

#define GEN4PHY_FSK_CFG0_HAMMING_AA_LOW_PWR_MASK (0xF0000U)
#define GEN4PHY_FSK_CFG0_HAMMING_AA_LOW_PWR_SHIFT (16U)
/*! HAMMING_AA_LOW_PWR - Maximum hamming distance from the given AA pattern that may still be
 *    accepted as a match; valid range [0,7]. This threshold value are performed on lower power case.
 */
#define GEN4PHY_FSK_CFG0_HAMMING_AA_LOW_PWR(x)   (((uint32_t)(((uint32_t)(x)) << GEN4PHY_FSK_CFG0_HAMMING_AA_LOW_PWR_SHIFT)) & GEN4PHY_FSK_CFG0_HAMMING_AA_LOW_PWR_MASK)

#define GEN4PHY_FSK_CFG0_BLE_NTW_ADR_THR_MASK    (0x700000U)
#define GEN4PHY_FSK_CFG0_BLE_NTW_ADR_THR_SHIFT   (20U)
/*! BLE_NTW_ADR_THR - Maximum hamming distance from the given AA pattern that may still be accepted
 *    as a match; valid range [0,7]. This threshold value are performed on lower power case.
 */
#define GEN4PHY_FSK_CFG0_BLE_NTW_ADR_THR(x)      (((uint32_t)(((uint32_t)(x)) << GEN4PHY_FSK_CFG0_BLE_NTW_ADR_THR_SHIFT)) & GEN4PHY_FSK_CFG0_BLE_NTW_ADR_THR_MASK)

#define GEN4PHY_FSK_CFG0_AA_ACQ_1_2_3_THRESH_2M_MASK (0x1F000000U)
#define GEN4PHY_FSK_CFG0_AA_ACQ_1_2_3_THRESH_2M_SHIFT (24U)
/*! AA_ACQ_1_2_3_THRESH_2M - For 2Mbps data rate, correlation threshold applicable to AA detection; uses ufix5_En5 fixed-point format.
 */
#define GEN4PHY_FSK_CFG0_AA_ACQ_1_2_3_THRESH_2M(x) (((uint32_t)(((uint32_t)(x)) << GEN4PHY_FSK_CFG0_AA_ACQ_1_2_3_THRESH_2M_SHIFT)) & GEN4PHY_FSK_CFG0_AA_ACQ_1_2_3_THRESH_2M_MASK)
/*! @} */

/*! @name FSK_CFG1 - PHY Uncoded Config 1 */
/*! @{ */

#define GEN4PHY_FSK_CFG1_OVERH_MASK              (0x1FFU)
#define GEN4PHY_FSK_CFG1_OVERH_SHIFT             (0U)
/*! OVERH - Modulation index; represented in ufix9_En6 format.
 */
#define GEN4PHY_FSK_CFG1_OVERH(x)                (((uint32_t)(((uint32_t)(x)) << GEN4PHY_FSK_CFG1_OVERH_SHIFT)) & GEN4PHY_FSK_CFG1_OVERH_MASK)

#define GEN4PHY_FSK_CFG1_OVERH_INV_MASK          (0xFF800U)
#define GEN4PHY_FSK_CFG1_OVERH_INV_SHIFT         (11U)
/*! OVERH_INV - Reciprocal of modulation index; represented in ufix9_En7 format.
 */
#define GEN4PHY_FSK_CFG1_OVERH_INV(x)            (((uint32_t)(((uint32_t)(x)) << GEN4PHY_FSK_CFG1_OVERH_INV_SHIFT)) & GEN4PHY_FSK_CFG1_OVERH_INV_MASK)

#define GEN4PHY_FSK_CFG1_SYNCTSCALE_MASK         (0xF000000U)
#define GEN4PHY_FSK_CFG1_SYNCTSCALE_SHIFT        (24U)
/*! SYNCTSCALE - Scaling factor used for fractional time estimation during AA search; represented in ufix4_En3 format.
 */
#define GEN4PHY_FSK_CFG1_SYNCTSCALE(x)           (((uint32_t)(((uint32_t)(x)) << GEN4PHY_FSK_CFG1_SYNCTSCALE_SHIFT)) & GEN4PHY_FSK_CFG1_SYNCTSCALE_MASK)
/*! @} */

/*! @name FSK_CFG2 - PHY Uncoded Config 2 */
/*! @{ */

#define GEN4PHY_FSK_CFG2_MAG_WIN_MASK            (0xF0000000U)
#define GEN4PHY_FSK_CFG2_MAG_WIN_SHIFT           (28U)
/*! MAG_WIN - Indicates the forgetting factor used in received signal level measurement;
 */
#define GEN4PHY_FSK_CFG2_MAG_WIN(x)              (((uint32_t)(((uint32_t)(x)) << GEN4PHY_FSK_CFG2_MAG_WIN_SHIFT)) & GEN4PHY_FSK_CFG2_MAG_WIN_MASK)
/*! @} */

/*! @name FSK_PT - PHY Uncoded Power Threshold Config */
/*! @{ */

#define GEN4PHY_FSK_PT_AGC_TIMEOUT_MASK          (0xFFFFU)
#define GEN4PHY_FSK_PT_AGC_TIMEOUT_SHIFT         (0U)
/*! AGC_TIMEOUT - Time-out, applicable to special conditioning of signal power detection in the
 *    Power threshold block, after each AGC gain adjustment. It is expressed in number of samples.
 */
#define GEN4PHY_FSK_PT_AGC_TIMEOUT(x)            (((uint32_t)(((uint32_t)(x)) << GEN4PHY_FSK_PT_AGC_TIMEOUT_SHIFT)) & GEN4PHY_FSK_PT_AGC_TIMEOUT_MASK)

#define GEN4PHY_FSK_PT_COND_SIG_PRST_EN_MASK     (0x10000U)
#define GEN4PHY_FSK_PT_COND_SIG_PRST_EN_SHIFT    (16U)
/*! COND_SIG_PRST_EN - Enables special conditioning of signal detection;
 *  0b0..disable.
 *  0b1..enable.
 */
#define GEN4PHY_FSK_PT_COND_SIG_PRST_EN(x)       (((uint32_t)(((uint32_t)(x)) << GEN4PHY_FSK_PT_COND_SIG_PRST_EN_SHIFT)) & GEN4PHY_FSK_PT_COND_SIG_PRST_EN_MASK)

#define GEN4PHY_FSK_PT_COND_AA_BUFF_EN_MASK      (0x20000U)
#define GEN4PHY_FSK_PT_COND_AA_BUFF_EN_SHIFT     (17U)
/*! COND_AA_BUFF_EN - Enables special condition for enabling AA detector buffer;
 *  0b0..disable.
 *  0b1..enable.
 */
#define GEN4PHY_FSK_PT_COND_AA_BUFF_EN(x)        (((uint32_t)(((uint32_t)(x)) << GEN4PHY_FSK_PT_COND_AA_BUFF_EN_SHIFT)) & GEN4PHY_FSK_PT_COND_AA_BUFF_EN_MASK)

#define GEN4PHY_FSK_PT_BYPASS_WITH_RSSI_MASK     (0x40000U)
#define GEN4PHY_FSK_PT_BYPASS_WITH_RSSI_SHIFT    (18U)
/*! BYPASS_WITH_RSSI - Bypass signal power measurement with RSSI measurement;
 *  0b0..no
 *  0b1..yes
 */
#define GEN4PHY_FSK_PT_BYPASS_WITH_RSSI(x)       (((uint32_t)(((uint32_t)(x)) << GEN4PHY_FSK_PT_BYPASS_WITH_RSSI_SHIFT)) & GEN4PHY_FSK_PT_BYPASS_WITH_RSSI_MASK)
/*! @} */

/*! @name FSK_FAD_CTRL - PHY Uncoded FAD Control */
/*! @{ */

#define GEN4PHY_FSK_FAD_CTRL_FAD_EN_MASK         (0x1U)
#define GEN4PHY_FSK_FAD_CTRL_FAD_EN_SHIFT        (0U)
/*! FAD_EN - Enables FAD;
 *  0b0..disable.
 *  0b1..enable.
 */
#define GEN4PHY_FSK_FAD_CTRL_FAD_EN(x)           (((uint32_t)(((uint32_t)(x)) << GEN4PHY_FSK_FAD_CTRL_FAD_EN_SHIFT)) & GEN4PHY_FSK_FAD_CTRL_FAD_EN_MASK)
/*! @} */

/*! @name FSK_FAD_CFG - PHY Uncoded FAD Config */
/*! @{ */

#define GEN4PHY_FSK_FAD_CFG_WIN_FAD_WAIT_SYNCH_MASK (0x7FU)
#define GEN4PHY_FSK_FAD_CFG_WIN_FAD_WAIT_SYNCH_SHIFT (0U)
/*! WIN_FAD_WAIT_SYNCH - Time-window to wait for clean samples, before transitioning to AA search
 *    PHY state, if PD was found after antenna switch (refered to as T3 in the PHY state-machine
 *    section).
 */
#define GEN4PHY_FSK_FAD_CFG_WIN_FAD_WAIT_SYNCH(x) (((uint32_t)(((uint32_t)(x)) << GEN4PHY_FSK_FAD_CFG_WIN_FAD_WAIT_SYNCH_SHIFT)) & GEN4PHY_FSK_FAD_CFG_WIN_FAD_WAIT_SYNCH_MASK)

#define GEN4PHY_FSK_FAD_CFG_WIN_FAD_WAIT_PD_MASK (0x7F00U)
#define GEN4PHY_FSK_FAD_CFG_WIN_FAD_WAIT_PD_SHIFT (8U)
/*! WIN_FAD_WAIT_PD - Time-window to wait for clean samples if PD was not found after antenna switch
 *    (refered to as T2 in the PHY state-machine section).
 */
#define GEN4PHY_FSK_FAD_CFG_WIN_FAD_WAIT_PD(x)   (((uint32_t)(((uint32_t)(x)) << GEN4PHY_FSK_FAD_CFG_WIN_FAD_WAIT_PD_SHIFT)) & GEN4PHY_FSK_FAD_CFG_WIN_FAD_WAIT_PD_MASK)

#define GEN4PHY_FSK_FAD_CFG_WIN_FAD_SEARCH_PD_MASK (0x7F0000U)
#define GEN4PHY_FSK_FAD_CFG_WIN_FAD_SEARCH_PD_SHIFT (16U)
/*! WIN_FAD_SEARCH_PD - Time-window to match preamble pattern on samples coming from the previously
 *    selected antenna (refered to as T1 in the PHY state-machine section).
 */
#define GEN4PHY_FSK_FAD_CFG_WIN_FAD_SEARCH_PD(x) (((uint32_t)(((uint32_t)(x)) << GEN4PHY_FSK_FAD_CFG_WIN_FAD_SEARCH_PD_SHIFT)) & GEN4PHY_FSK_FAD_CFG_WIN_FAD_SEARCH_PD_MASK)

#define GEN4PHY_FSK_FAD_CFG_WIN_SEARCH_PD_MASK   (0x7F000000U)
#define GEN4PHY_FSK_FAD_CFG_WIN_SEARCH_PD_SHIFT  (24U)
/*! WIN_SEARCH_PD - Time-window to match preamble pattern on samples coming from the currently
 *    selected antenna (refered to as T0 in the PHY state-machine section).
 */
#define GEN4PHY_FSK_FAD_CFG_WIN_SEARCH_PD(x)     (((uint32_t)(((uint32_t)(x)) << GEN4PHY_FSK_FAD_CFG_WIN_SEARCH_PD_SHIFT)) & GEN4PHY_FSK_FAD_CFG_WIN_SEARCH_PD_MASK)
/*! @} */

/*! @name FSK_STAT - PHY Uncoded Status */
/*! @{ */

#define GEN4PHY_FSK_STAT_AA_FOUND_MASK           (0x4U)
#define GEN4PHY_FSK_STAT_AA_FOUND_SHIFT          (2U)
/*! AA_FOUND - Indicates that a uncoded AA detect is active.
 */
#define GEN4PHY_FSK_STAT_AA_FOUND(x)             (((uint32_t)(((uint32_t)(x)) << GEN4PHY_FSK_STAT_AA_FOUND_SHIFT)) & GEN4PHY_FSK_STAT_AA_FOUND_MASK)

#define GEN4PHY_FSK_STAT_AA_MATCH_MASK           (0xF0U)
#define GEN4PHY_FSK_STAT_AA_MATCH_SHIFT          (4U)
/*! AA_MATCH - Indicates which non-coded AA has matched. This will clear when the PHY is re-initialized.
 */
#define GEN4PHY_FSK_STAT_AA_MATCH(x)             (((uint32_t)(((uint32_t)(x)) << GEN4PHY_FSK_STAT_AA_MATCH_SHIFT)) & GEN4PHY_FSK_STAT_AA_MATCH_MASK)

#define GEN4PHY_FSK_STAT_HAMM_DIST_MASK          (0x7F00U)
#define GEN4PHY_FSK_STAT_HAMM_DIST_SHIFT         (8U)
/*! HAMM_DIST - Indicates the hamming distance witnessed when AA match occurred.
 */
#define GEN4PHY_FSK_STAT_HAMM_DIST(x)            (((uint32_t)(((uint32_t)(x)) << GEN4PHY_FSK_STAT_HAMM_DIST_SHIFT)) & GEN4PHY_FSK_STAT_HAMM_DIST_MASK)

#define GEN4PHY_FSK_STAT_CORR_MAX_MASK           (0x1F0000U)
#define GEN4PHY_FSK_STAT_CORR_MAX_SHIFT          (16U)
/*! CORR_MAX - Indicates the correlation witnessed when AA match occurred
 */
#define GEN4PHY_FSK_STAT_CORR_MAX(x)             (((uint32_t)(((uint32_t)(x)) << GEN4PHY_FSK_STAT_CORR_MAX_SHIFT)) & GEN4PHY_FSK_STAT_CORR_MAX_MASK)

#define GEN4PHY_FSK_STAT_TOF_OFF_MASK            (0xF0000000U)
#define GEN4PHY_FSK_STAT_TOF_OFF_SHIFT           (28U)
/*! TOF_OFF - Timing offset for use in time-of-flight calculation.
 */
#define GEN4PHY_FSK_STAT_TOF_OFF(x)              (((uint32_t)(((uint32_t)(x)) << GEN4PHY_FSK_STAT_TOF_OFF_SHIFT)) & GEN4PHY_FSK_STAT_TOF_OFF_MASK)
/*! @} */

/*! @name LR_PD_CFG - PHY Long Range Preamble Detect Config */
/*! @{ */

#define GEN4PHY_LR_PD_CFG_CORR_TH_MASK           (0xFFU)
#define GEN4PHY_LR_PD_CFG_CORR_TH_SHIFT          (0U)
/*! CORR_TH - Correlation threshold applicable to preamble detection; uses (0,8,8) fixed-point format.
 */
#define GEN4PHY_LR_PD_CFG_CORR_TH(x)             (((uint32_t)(((uint32_t)(x)) << GEN4PHY_LR_PD_CFG_CORR_TH_SHIFT)) & GEN4PHY_LR_PD_CFG_CORR_TH_MASK)

#define GEN4PHY_LR_PD_CFG_FREQ_TH_MASK           (0x1F00U)
#define GEN4PHY_LR_PD_CFG_FREQ_TH_SHIFT          (8U)
/*! FREQ_TH - Threshold used to compare CFO estimates in the LR preamble detector; uses ufix5_En5 format.
 */
#define GEN4PHY_LR_PD_CFG_FREQ_TH(x)             (((uint32_t)(((uint32_t)(x)) << GEN4PHY_LR_PD_CFG_FREQ_TH_SHIFT)) & GEN4PHY_LR_PD_CFG_FREQ_TH_MASK)

#define GEN4PHY_LR_PD_CFG_NO_PEAKS_MASK          (0x30000U)
#define GEN4PHY_LR_PD_CFG_NO_PEAKS_SHIFT         (16U)
/*! NO_PEAKS - Number of consecutive correlation values that have to exceed the PD correlation
 *    threshold,for the same preamble phase, to assert preamble found;
 *  0b00..2 peaks;
 *  0b01..3 peaks;
 *  0b10..4 peaks;
 *  0b11..5 peaks;
 */
#define GEN4PHY_LR_PD_CFG_NO_PEAKS(x)            (((uint32_t)(((uint32_t)(x)) << GEN4PHY_LR_PD_CFG_NO_PEAKS_SHIFT)) & GEN4PHY_LR_PD_CFG_NO_PEAKS_MASK)
/*! @} */

/*! @name LR_PD_PH -  */
/*! @{ */

#define GEN4PHY_LR_PD_PH_REF0_MASK               (0x3FU)
#define GEN4PHY_LR_PD_PH_REF0_SHIFT              (0U)
/*! REF0 - Long range preamble reference waveform sample 12 (sfix6en5)
 */
#define GEN4PHY_LR_PD_PH_REF0(x)                 (((uint32_t)(((uint32_t)(x)) << GEN4PHY_LR_PD_PH_REF0_SHIFT)) & GEN4PHY_LR_PD_PH_REF0_MASK)

#define GEN4PHY_LR_PD_PH_REF1_MASK               (0x3F00U)
#define GEN4PHY_LR_PD_PH_REF1_SHIFT              (8U)
/*! REF1 - Long range preamble reference waveform sample 13 (sfix6en5)
 */
#define GEN4PHY_LR_PD_PH_REF1(x)                 (((uint32_t)(((uint32_t)(x)) << GEN4PHY_LR_PD_PH_REF1_SHIFT)) & GEN4PHY_LR_PD_PH_REF1_MASK)

#define GEN4PHY_LR_PD_PH_REF2_MASK               (0x3F0000U)
#define GEN4PHY_LR_PD_PH_REF2_SHIFT              (16U)
/*! REF2 - Long range preamble reference waveform sample 14 (sfix6en5)
 */
#define GEN4PHY_LR_PD_PH_REF2(x)                 (((uint32_t)(((uint32_t)(x)) << GEN4PHY_LR_PD_PH_REF2_SHIFT)) & GEN4PHY_LR_PD_PH_REF2_MASK)

#define GEN4PHY_LR_PD_PH_REF3_MASK               (0x3F000000U)
#define GEN4PHY_LR_PD_PH_REF3_SHIFT              (24U)
/*! REF3 - Long range preamble reference waveform sample 15 (sfix6en5)
 */
#define GEN4PHY_LR_PD_PH_REF3(x)                 (((uint32_t)(((uint32_t)(x)) << GEN4PHY_LR_PD_PH_REF3_SHIFT)) & GEN4PHY_LR_PD_PH_REF3_MASK)
/*! @} */

/* The count of GEN4PHY_LR_PD_PH */
#define GEN4PHY_LR_PD_PH_COUNT                   (4U)

/*! @name LR_PD_RO_PH -  */
/*! @{ */

#define GEN4PHY_LR_PD_RO_PH_REF0_MASK            (0x3FU)
#define GEN4PHY_LR_PD_RO_PH_REF0_SHIFT           (0U)
/*! REF0 - Long range preamble reference waveform sample 64 (sfix6en5)
 */
#define GEN4PHY_LR_PD_RO_PH_REF0(x)              (((uint32_t)(((uint32_t)(x)) << GEN4PHY_LR_PD_RO_PH_REF0_SHIFT)) & GEN4PHY_LR_PD_RO_PH_REF0_MASK)

#define GEN4PHY_LR_PD_RO_PH_REF1_MASK            (0x3F00U)
#define GEN4PHY_LR_PD_RO_PH_REF1_SHIFT           (8U)
/*! REF1 - Long range preamble reference waveform sample 65 (sfix6en5)
 */
#define GEN4PHY_LR_PD_RO_PH_REF1(x)              (((uint32_t)(((uint32_t)(x)) << GEN4PHY_LR_PD_RO_PH_REF1_SHIFT)) & GEN4PHY_LR_PD_RO_PH_REF1_MASK)

#define GEN4PHY_LR_PD_RO_PH_REF2_MASK            (0x3F0000U)
#define GEN4PHY_LR_PD_RO_PH_REF2_SHIFT           (16U)
/*! REF2 - Long range preamble reference waveform sample 66 (sfix6en5)
 */
#define GEN4PHY_LR_PD_RO_PH_REF2(x)              (((uint32_t)(((uint32_t)(x)) << GEN4PHY_LR_PD_RO_PH_REF2_SHIFT)) & GEN4PHY_LR_PD_RO_PH_REF2_MASK)

#define GEN4PHY_LR_PD_RO_PH_REF3_MASK            (0x3F000000U)
#define GEN4PHY_LR_PD_RO_PH_REF3_SHIFT           (24U)
/*! REF3 - Long range preamble reference waveform sample 67 (sfix6en5)
 */
#define GEN4PHY_LR_PD_RO_PH_REF3(x)              (((uint32_t)(((uint32_t)(x)) << GEN4PHY_LR_PD_RO_PH_REF3_SHIFT)) & GEN4PHY_LR_PD_RO_PH_REF3_MASK)
/*! @} */

/* The count of GEN4PHY_LR_PD_RO_PH */
#define GEN4PHY_LR_PD_RO_PH_COUNT                (13U)

/*! @name LR_AA_CFG - PHY Long Range AA Config */
/*! @{ */

#define GEN4PHY_LR_AA_CFG_AA_COR_THRESH_MASK     (0xFFU)
#define GEN4PHY_LR_AA_CFG_AA_COR_THRESH_SHIFT    (0U)
/*! AA_COR_THRESH - Threshold use to compare the correlation magnitude in the long-range AA correlator.
 */
#define GEN4PHY_LR_AA_CFG_AA_COR_THRESH(x)       (((uint32_t)(((uint32_t)(x)) << GEN4PHY_LR_AA_CFG_AA_COR_THRESH_SHIFT)) & GEN4PHY_LR_AA_CFG_AA_COR_THRESH_MASK)

#define GEN4PHY_LR_AA_CFG_AA_HAM_THRESH_MASK     (0x3F00U)
#define GEN4PHY_LR_AA_CFG_AA_HAM_THRESH_SHIFT    (8U)
/*! AA_HAM_THRESH - Threshold use to compare the Hamming distance, between reference coded sequence
 *    and received coded sequence, in the long-range AA correlator.
 */
#define GEN4PHY_LR_AA_CFG_AA_HAM_THRESH(x)       (((uint32_t)(((uint32_t)(x)) << GEN4PHY_LR_AA_CFG_AA_HAM_THRESH_SHIFT)) & GEN4PHY_LR_AA_CFG_AA_HAM_THRESH_MASK)

#define GEN4PHY_LR_AA_CFG_ACCESS_ADDR_HAM_MASK   (0x1F0000U)
#define GEN4PHY_LR_AA_CFG_ACCESS_ADDR_HAM_SHIFT  (16U)
/*! ACCESS_ADDR_HAM - Threshold use to compare the Hamming distance, between the reference AA
 *    sequence and the received Viterbi decoded AA sequence.
 */
#define GEN4PHY_LR_AA_CFG_ACCESS_ADDR_HAM(x)     (((uint32_t)(((uint32_t)(x)) << GEN4PHY_LR_AA_CFG_ACCESS_ADDR_HAM_SHIFT)) & GEN4PHY_LR_AA_CFG_ACCESS_ADDR_HAM_MASK)

#define GEN4PHY_LR_AA_CFG_AA_LR_CORR_GAIN_MASK   (0x3F000000U)
#define GEN4PHY_LR_AA_CFG_AA_LR_CORR_GAIN_SHIFT  (24U)
/*! AA_LR_CORR_GAIN - AA correlator gain. Format ufix6en3. This gain is applied to soft bits from
 *    the demodulator before they are used for address search synchronization.
 */
#define GEN4PHY_LR_AA_CFG_AA_LR_CORR_GAIN(x)     (((uint32_t)(((uint32_t)(x)) << GEN4PHY_LR_AA_CFG_AA_LR_CORR_GAIN_SHIFT)) & GEN4PHY_LR_AA_CFG_AA_LR_CORR_GAIN_MASK)
/*! @} */

/*! @name LR_STAT - PHY Long Range Status */
/*! @{ */

#define GEN4PHY_LR_STAT_DECODED_HAMM_DIST_MASK   (0x3FU)
#define GEN4PHY_LR_STAT_DECODED_HAMM_DIST_SHIFT  (0U)
/*! DECODED_HAMM_DIST - Hamming distance between the reference sequence and the Viterbi decoded received sequence
 */
#define GEN4PHY_LR_STAT_DECODED_HAMM_DIST(x)     (((uint32_t)(((uint32_t)(x)) << GEN4PHY_LR_STAT_DECODED_HAMM_DIST_SHIFT)) & GEN4PHY_LR_STAT_DECODED_HAMM_DIST_MASK)

#define GEN4PHY_LR_STAT_AA_FOUND_MASK            (0x40U)
#define GEN4PHY_LR_STAT_AA_FOUND_SHIFT           (6U)
/*! AA_FOUND - Indicates that a AA detect is active for both LR and uncoded.
 */
#define GEN4PHY_LR_STAT_AA_FOUND(x)              (((uint32_t)(((uint32_t)(x)) << GEN4PHY_LR_STAT_AA_FOUND_SHIFT)) & GEN4PHY_LR_STAT_AA_FOUND_MASK)

#define GEN4PHY_LR_STAT_CI_MASK                  (0x80U)
#define GEN4PHY_LR_STAT_CI_SHIFT                 (7U)
/*! CI - CI received.
 */
#define GEN4PHY_LR_STAT_CI(x)                    (((uint32_t)(((uint32_t)(x)) << GEN4PHY_LR_STAT_CI_SHIFT)) & GEN4PHY_LR_STAT_CI_MASK)

#define GEN4PHY_LR_STAT_CODED_HAMM_DIST_MASK     (0x7F00U)
#define GEN4PHY_LR_STAT_CODED_HAMM_DIST_SHIFT    (8U)
/*! CODED_HAMM_DIST - Hamming distance between the coded reference sequence and the coded received sequence.
 */
#define GEN4PHY_LR_STAT_CODED_HAMM_DIST(x)       (((uint32_t)(((uint32_t)(x)) << GEN4PHY_LR_STAT_CODED_HAMM_DIST_SHIFT)) & GEN4PHY_LR_STAT_CODED_HAMM_DIST_MASK)

#define GEN4PHY_LR_STAT_AA_CORR_MAX_MASK         (0xFF0000U)
#define GEN4PHY_LR_STAT_AA_CORR_MAX_SHIFT        (16U)
/*! AA_CORR_MAX - Indicates the AA correlation magnitude witnessed when AA match occurred
 */
#define GEN4PHY_LR_STAT_AA_CORR_MAX(x)           (((uint32_t)(((uint32_t)(x)) << GEN4PHY_LR_STAT_AA_CORR_MAX_SHIFT)) & GEN4PHY_LR_STAT_AA_CORR_MAX_MASK)

#define GEN4PHY_LR_STAT_CMAG_MAX_MASK            (0xFF000000U)
#define GEN4PHY_LR_STAT_CMAG_MAX_SHIFT           (24U)
/*! CMAG_MAX - Indicates the maximum preamble correlation magnitude during preamble found
 */
#define GEN4PHY_LR_STAT_CMAG_MAX(x)              (((uint32_t)(((uint32_t)(x)) << GEN4PHY_LR_STAT_CMAG_MAX_SHIFT)) & GEN4PHY_LR_STAT_CMAG_MAX_MASK)
/*! @} */

/*! @name SM_CFG - PHY State Machine Config */
/*! @{ */

#define GEN4PHY_SM_CFG_ACQ_MODE_MASK             (0x3U)
#define GEN4PHY_SM_CFG_ACQ_MODE_SHIFT            (0U)
/*! ACQ_MODE - Acquisition mode for non-coded reception
 *  0b00..Reserved
 *  0b01..Use preamble and verify a correlation peak, the synch at the symbol rate as symbol timing is established by the preamble acquisition
 *  0b10..Use synch only (which may incorporate part of the preamble)
 *  0b11..Use mainly the sync detection: Use a low threshold on the preamble detector and launch the synch
 *        detection only if the preamble has shown a recent peak
 */
#define GEN4PHY_SM_CFG_ACQ_MODE(x)               (((uint32_t)(((uint32_t)(x)) << GEN4PHY_SM_CFG_ACQ_MODE_SHIFT)) & GEN4PHY_SM_CFG_ACQ_MODE_MASK)

#define GEN4PHY_SM_CFG_EN_PHY_SM_EXT_RST_MASK    (0x4U)
#define GEN4PHY_SM_CFG_EN_PHY_SM_EXT_RST_SHIFT   (2U)
/*! EN_PHY_SM_EXT_RST - Enable PHY state-machine reset on the external reset port; Reserved, should keep 0.
 *  0b0..Reset is not allowed.
 *  0b1..Reset is allowed.
 */
#define GEN4PHY_SM_CFG_EN_PHY_SM_EXT_RST(x)      (((uint32_t)(((uint32_t)(x)) << GEN4PHY_SM_CFG_EN_PHY_SM_EXT_RST_SHIFT)) & GEN4PHY_SM_CFG_EN_PHY_SM_EXT_RST_MASK)

#define GEN4PHY_SM_CFG_AGC_FRZ_ON_PD_FOUND_ACQ1_LR_MASK (0x8U)
#define GEN4PHY_SM_CFG_AGC_FRZ_ON_PD_FOUND_ACQ1_LR_SHIFT (3U)
/*! AGC_FRZ_ON_PD_FOUND_ACQ1_LR - Specfies AGC freeze condition for non-coded acq.1 and Bluetooth LE long range.
 *  0b0..AGC freeze on AA found.
 *  0b1..AGC freeze asserted on PD found.
 */
#define GEN4PHY_SM_CFG_AGC_FRZ_ON_PD_FOUND_ACQ1_LR(x) (((uint32_t)(((uint32_t)(x)) << GEN4PHY_SM_CFG_AGC_FRZ_ON_PD_FOUND_ACQ1_LR_SHIFT)) & GEN4PHY_SM_CFG_AGC_FRZ_ON_PD_FOUND_ACQ1_LR_MASK)

#define GEN4PHY_SM_CFG_PH_BUFF_PTR_SYM_MASK      (0x30U)
#define GEN4PHY_SM_CFG_PH_BUFF_PTR_SYM_SHIFT     (4U)
/*! PH_BUFF_PTR_SYM - Phase buffer size to demodulator, long range only.
 */
#define GEN4PHY_SM_CFG_PH_BUFF_PTR_SYM(x)        (((uint32_t)(((uint32_t)(x)) << GEN4PHY_SM_CFG_PH_BUFF_PTR_SYM_SHIFT)) & GEN4PHY_SM_CFG_PH_BUFF_PTR_SYM_MASK)

#define GEN4PHY_SM_CFG_EARLY_PD_TIMEOUT_MASK     (0x3F00U)
#define GEN4PHY_SM_CFG_EARLY_PD_TIMEOUT_SHIFT    (8U)
/*! EARLY_PD_TIMEOUT - Time-out used to reset the AGC state-machine for the eventuality that an "PD
 *    found early" event occurs but it is not followed by an "PD found" event
 */
#define GEN4PHY_SM_CFG_EARLY_PD_TIMEOUT(x)       (((uint32_t)(((uint32_t)(x)) << GEN4PHY_SM_CFG_EARLY_PD_TIMEOUT_SHIFT)) & GEN4PHY_SM_CFG_EARLY_PD_TIMEOUT_MASK)

#define GEN4PHY_SM_CFG_AA_TIMEOUT_UNCODED_MASK   (0x3FF0000U)
#define GEN4PHY_SM_CFG_AA_TIMEOUT_UNCODED_SHIFT  (16U)
/*! AA_TIMEOUT_UNCODED - Time-out value for access address search for uncoded packets
 */
#define GEN4PHY_SM_CFG_AA_TIMEOUT_UNCODED(x)     (((uint32_t)(((uint32_t)(x)) << GEN4PHY_SM_CFG_AA_TIMEOUT_UNCODED_SHIFT)) & GEN4PHY_SM_CFG_AA_TIMEOUT_UNCODED_MASK)
/*! @} */

/*! @name MISC - PHY Misc Config */
/*! @{ */

#define GEN4PHY_MISC_RSSI_CORR_TH_MASK           (0xFFU)
#define GEN4PHY_MISC_RSSI_CORR_TH_SHIFT          (0U)
/*! RSSI_CORR_TH - Threshold use to compare a correlation magnitude value, computed in the
 *    acquisition block, in order to determine the correlation flag value provided by the PHY to the LQI
 *    computation block. Format is ufix8_En8
 */
#define GEN4PHY_MISC_RSSI_CORR_TH(x)             (((uint32_t)(((uint32_t)(x)) << GEN4PHY_MISC_RSSI_CORR_TH_SHIFT)) & GEN4PHY_MISC_RSSI_CORR_TH_MASK)

#define GEN4PHY_MISC_DMA_PAGE_SEL_MASK           (0x700U)
#define GEN4PHY_MISC_DMA_PAGE_SEL_SHIFT          (8U)
/*! DMA_PAGE_SEL - Select which DMA page is send out
 *  0b000..Select DMA PAGE 0 for M3C with cfo;
 *  0b001..Select DMA PAGE 1 for M3C with magnitude;
 *  0b010..Select DMA PAGE 2 for un-coded;
 *  0b011..Select DMA PAGE 3 for Long Range Preampble Detect;
 *  0b100..Select DMA PAGE 4 for Long Range AA Detect;
 */
#define GEN4PHY_MISC_DMA_PAGE_SEL(x)             (((uint32_t)(((uint32_t)(x)) << GEN4PHY_MISC_DMA_PAGE_SEL_SHIFT)) & GEN4PHY_MISC_DMA_PAGE_SEL_MASK)

#define GEN4PHY_MISC_ECO1_RSVD_MASK              (0xF800U)
#define GEN4PHY_MISC_ECO1_RSVD_SHIFT             (11U)
/*! ECO1_RSVD - Reserved. Must be programed as reset value 0.
 */
#define GEN4PHY_MISC_ECO1_RSVD(x)                (((uint32_t)(((uint32_t)(x)) << GEN4PHY_MISC_ECO1_RSVD_SHIFT)) & GEN4PHY_MISC_ECO1_RSVD_MASK)

#define GEN4PHY_MISC_PHY_CLK_CTRL_MASK           (0x3FF0000U)
#define GEN4PHY_MISC_PHY_CLK_CTRL_SHIFT          (16U)
/*! PHY_CLK_CTRL - Enables various clock gating features. Bits are individually decoded, so any combination is allowable.
 */
#define GEN4PHY_MISC_PHY_CLK_CTRL(x)             (((uint32_t)(((uint32_t)(x)) << GEN4PHY_MISC_PHY_CLK_CTRL_SHIFT)) & GEN4PHY_MISC_PHY_CLK_CTRL_MASK)

#define GEN4PHY_MISC_ECO2_RSVD_MASK              (0x3C000000U)
#define GEN4PHY_MISC_ECO2_RSVD_SHIFT             (26U)
/*! ECO2_RSVD - Reserved
 */
#define GEN4PHY_MISC_ECO2_RSVD(x)                (((uint32_t)(((uint32_t)(x)) << GEN4PHY_MISC_ECO2_RSVD_SHIFT)) & GEN4PHY_MISC_ECO2_RSVD_MASK)

#define GEN4PHY_MISC_DTEST_MUX_EN_MASK           (0x40000000U)
#define GEN4PHY_MISC_DTEST_MUX_EN_SHIFT          (30U)
/*! DTEST_MUX_EN - Reserved. Should be programed as reset value 0.
 */
#define GEN4PHY_MISC_DTEST_MUX_EN(x)             (((uint32_t)(((uint32_t)(x)) << GEN4PHY_MISC_DTEST_MUX_EN_SHIFT)) & GEN4PHY_MISC_DTEST_MUX_EN_MASK)

#define GEN4PHY_MISC_PHY_CLK_ON_MASK             (0x80000000U)
#define GEN4PHY_MISC_PHY_CLK_ON_SHIFT            (31U)
/*! PHY_CLK_ON - Force PHY clock ON
 */
#define GEN4PHY_MISC_PHY_CLK_ON(x)               (((uint32_t)(((uint32_t)(x)) << GEN4PHY_MISC_PHY_CLK_ON_SHIFT)) & GEN4PHY_MISC_PHY_CLK_ON_MASK)
/*! @} */

/*! @name STAT0 - PHY Status 0 */
/*! @{ */

#define GEN4PHY_STAT0_PD_FOUND_MASK              (0x1U)
#define GEN4PHY_STAT0_PD_FOUND_SHIFT             (0U)
/*! PD_FOUND - PD_FOUND for LR or uncoded
 */
#define GEN4PHY_STAT0_PD_FOUND(x)                (((uint32_t)(((uint32_t)(x)) << GEN4PHY_STAT0_PD_FOUND_SHIFT)) & GEN4PHY_STAT0_PD_FOUND_MASK)

#define GEN4PHY_STAT0_LR_DET_FLAG_MASK           (0x2U)
#define GEN4PHY_STAT0_LR_DET_FLAG_SHIFT          (1U)
/*! LR_DET_FLAG - Indicates Bluetooth LE long range was detected
 */
#define GEN4PHY_STAT0_LR_DET_FLAG(x)             (((uint32_t)(((uint32_t)(x)) << GEN4PHY_STAT0_LR_DET_FLAG_SHIFT)) & GEN4PHY_STAT0_LR_DET_FLAG_MASK)

#define GEN4PHY_STAT0_AA_MATCHED_MASK            (0x4U)
#define GEN4PHY_STAT0_AA_MATCHED_SHIFT           (2U)
/*! AA_MATCHED - Indicates AA was matched for LR or uncoded
 */
#define GEN4PHY_STAT0_AA_MATCHED(x)              (((uint32_t)(((uint32_t)(x)) << GEN4PHY_STAT0_AA_MATCHED_SHIFT)) & GEN4PHY_STAT0_AA_MATCHED_MASK)

#define GEN4PHY_STAT0_AA_FOUND_ID_MASK           (0x38U)
#define GEN4PHY_STAT0_AA_FOUND_ID_SHIFT          (3U)
/*! AA_FOUND_ID - Indicates which AA was matched for LR and uncode
 *  0b000..uncoded address 0 matched
 *  0b001..uncoded address 1 matched
 *  0b010..uncoded address 2 matched
 *  0b011..uncoded address 3 matched
 *  0b100..long range address matched
 */
#define GEN4PHY_STAT0_AA_FOUND_ID(x)             (((uint32_t)(((uint32_t)(x)) << GEN4PHY_STAT0_AA_FOUND_ID_SHIFT)) & GEN4PHY_STAT0_AA_FOUND_ID_MASK)

#define GEN4PHY_STAT0_DATA_RATE_MASK             (0xC0U)
#define GEN4PHY_STAT0_DATA_RATE_SHIFT            (6U)
/*! DATA_RATE - Indicates the data rate of received bit
 *  0b00..1Mbps
 *  0b01..2Mbps
 *  0b10..125kbps
 *  0b11..500kbps
 */
#define GEN4PHY_STAT0_DATA_RATE(x)               (((uint32_t)(((uint32_t)(x)) << GEN4PHY_STAT0_DATA_RATE_SHIFT)) & GEN4PHY_STAT0_DATA_RATE_MASK)

#define GEN4PHY_STAT0_FRAC_MASK                  (0x3F00U)
#define GEN4PHY_STAT0_FRAC_SHIFT                 (8U)
/*! FRAC - Indicates the fractional timing estimate determined in the acquisition block. Format is
 *    sfix6_en5(sign extend from sfix3_En2).
 */
#define GEN4PHY_STAT0_FRAC(x)                    (((uint32_t)(((uint32_t)(x)) << GEN4PHY_STAT0_FRAC_SHIFT)) & GEN4PHY_STAT0_FRAC_MASK)

#define GEN4PHY_STAT0_CFO_EST_MASK               (0x3FF0000U)
#define GEN4PHY_STAT0_CFO_EST_SHIFT              (16U)
/*! CFO_EST - Indicates the currently estimated CFO. Format is sfix10_en9(sign extend form sfix8_en9)
 */
#define GEN4PHY_STAT0_CFO_EST(x)                 (((uint32_t)(((uint32_t)(x)) << GEN4PHY_STAT0_CFO_EST_SHIFT)) & GEN4PHY_STAT0_CFO_EST_MASK)
/*! @} */

/*! @name STAT1 - PHY Status 1 */
/*! @{ */

#define GEN4PHY_STAT1_AA_BITS_MASK               (0xFFFFFFFFU)
#define GEN4PHY_STAT1_AA_BITS_SHIFT              (0U)
/*! AA_BITS - AA bits either received or programed
 */
#define GEN4PHY_STAT1_AA_BITS(x)                 (((uint32_t)(((uint32_t)(x)) << GEN4PHY_STAT1_AA_BITS_SHIFT)) & GEN4PHY_STAT1_AA_BITS_MASK)
/*! @} */

/*! @name STAT2 - PHY Status 2 */
/*! @{ */

#define GEN4PHY_STAT2_CNT_ANT_SW_MASK            (0x3U)
#define GEN4PHY_STAT2_CNT_ANT_SW_SHIFT           (0U)
/*! CNT_ANT_SW - Count of uncoded ANT switch event when FAD was enabled.
 */
#define GEN4PHY_STAT2_CNT_ANT_SW(x)              (((uint32_t)(((uint32_t)(x)) << GEN4PHY_STAT2_CNT_ANT_SW_SHIFT)) & GEN4PHY_STAT2_CNT_ANT_SW_MASK)

#define GEN4PHY_STAT2_CNT_UNCAA_TIMEOUT_MASK     (0xCU)
#define GEN4PHY_STAT2_CNT_UNCAA_TIMEOUT_SHIFT    (2U)
/*! CNT_UNCAA_TIMEOUT - Count of uncoded AA search timeout event
 */
#define GEN4PHY_STAT2_CNT_UNCAA_TIMEOUT(x)       (((uint32_t)(((uint32_t)(x)) << GEN4PHY_STAT2_CNT_UNCAA_TIMEOUT_SHIFT)) & GEN4PHY_STAT2_CNT_UNCAA_TIMEOUT_MASK)

#define GEN4PHY_STAT2_CNT_LRAA_TIMEOUT_MASK      (0x30U)
#define GEN4PHY_STAT2_CNT_LRAA_TIMEOUT_SHIFT     (4U)
/*! CNT_LRAA_TIMEOUT - Count of lang range AA search timeout event
 */
#define GEN4PHY_STAT2_CNT_LRAA_TIMEOUT(x)        (((uint32_t)(((uint32_t)(x)) << GEN4PHY_STAT2_CNT_LRAA_TIMEOUT_SHIFT)) & GEN4PHY_STAT2_CNT_LRAA_TIMEOUT_MASK)

#define GEN4PHY_STAT2_CNT_AACI_TIMEOUT_MASK      (0xC0U)
#define GEN4PHY_STAT2_CNT_AACI_TIMEOUT_SHIFT     (6U)
/*! CNT_AACI_TIMEOUT - Count of long range AACI detect timeout event
 */
#define GEN4PHY_STAT2_CNT_AACI_TIMEOUT(x)        (((uint32_t)(((uint32_t)(x)) << GEN4PHY_STAT2_CNT_AACI_TIMEOUT_SHIFT)) & GEN4PHY_STAT2_CNT_AACI_TIMEOUT_MASK)

#define GEN4PHY_STAT2_CNT_AGC_RST_MASK           (0x300U)
#define GEN4PHY_STAT2_CNT_AGC_RST_SHIFT          (8U)
/*! CNT_AGC_RST - Count of AGC soft reset event
 */
#define GEN4PHY_STAT2_CNT_AGC_RST(x)             (((uint32_t)(((uint32_t)(x)) << GEN4PHY_STAT2_CNT_AGC_RST_SHIFT)) & GEN4PHY_STAT2_CNT_AGC_RST_MASK)
/*! @} */

/*! @name PREPHY_MISC - PHY PrePHY Misc Config */
/*! @{ */

#define GEN4PHY_PREPHY_MISC_BUFF_PTR_LR_MASK     (0x1FU)
#define GEN4PHY_PREPHY_MISC_BUFF_PTR_LR_SHIFT    (0U)
/*! BUFF_PTR_LR - Pointer to the PrePHY IQ buffer for the reception of the long-range packets.
 */
#define GEN4PHY_PREPHY_MISC_BUFF_PTR_LR(x)       (((uint32_t)(((uint32_t)(x)) << GEN4PHY_PREPHY_MISC_BUFF_PTR_LR_SHIFT)) & GEN4PHY_PREPHY_MISC_BUFF_PTR_LR_MASK)

#define GEN4PHY_PREPHY_MISC_BUFF_PTR_GFSK_MASK   (0x1F00U)
#define GEN4PHY_PREPHY_MISC_BUFF_PTR_GFSK_SHIFT  (8U)
/*! BUFF_PTR_GFSK - Pointer to the PrePHY IQ buffer for the reception of the uncoded packets.
 */
#define GEN4PHY_PREPHY_MISC_BUFF_PTR_GFSK(x)     (((uint32_t)(((uint32_t)(x)) << GEN4PHY_PREPHY_MISC_BUFF_PTR_GFSK_SHIFT)) & GEN4PHY_PREPHY_MISC_BUFF_PTR_GFSK_MASK)
/*! @} */

/*! @name DMD_CTRL0 - PHY Demodulator Control 0 */
/*! @{ */

#define GEN4PHY_DMD_CTRL0_TED_ACT_WIN_MASK       (0x3U)
#define GEN4PHY_DMD_CTRL0_TED_ACT_WIN_SHIFT      (0U)
/*! TED_ACT_WIN - Active window size for the time tracking mechanism, expressed in symbols.
 */
#define GEN4PHY_DMD_CTRL0_TED_ACT_WIN(x)         (((uint32_t)(((uint32_t)(x)) << GEN4PHY_DMD_CTRL0_TED_ACT_WIN_SHIFT)) & GEN4PHY_DMD_CTRL0_TED_ACT_WIN_MASK)

#define GEN4PHY_DMD_CTRL0_FED_ACT_WIN_MASK       (0x300U)
#define GEN4PHY_DMD_CTRL0_FED_ACT_WIN_SHIFT      (8U)
/*! FED_ACT_WIN - Active window size for the frequency tracking mechanism, expressed in symbols.
 */
#define GEN4PHY_DMD_CTRL0_FED_ACT_WIN(x)         (((uint32_t)(((uint32_t)(x)) << GEN4PHY_DMD_CTRL0_FED_ACT_WIN_SHIFT)) & GEN4PHY_DMD_CTRL0_FED_ACT_WIN_MASK)

#define GEN4PHY_DMD_CTRL0_DREP_SCALE_FREQ_MASK   (0xF0000U)
#define GEN4PHY_DMD_CTRL0_DREP_SCALE_FREQ_SHIFT  (16U)
/*! DREP_SCALE_FREQ - Frequency domain signal scaling factor used by the de-repeater.
 */
#define GEN4PHY_DMD_CTRL0_DREP_SCALE_FREQ(x)     (((uint32_t)(((uint32_t)(x)) << GEN4PHY_DMD_CTRL0_DREP_SCALE_FREQ_SHIFT)) & GEN4PHY_DMD_CTRL0_DREP_SCALE_FREQ_MASK)

#define GEN4PHY_DMD_CTRL0_REPEAT_FACTOR_MASK     (0x700000U)
#define GEN4PHY_DMD_CTRL0_REPEAT_FACTOR_SHIFT    (20U)
/*! REPEAT_FACTOR - Repetition factor used by the de-repeater.
 */
#define GEN4PHY_DMD_CTRL0_REPEAT_FACTOR(x)       (((uint32_t)(((uint32_t)(x)) << GEN4PHY_DMD_CTRL0_REPEAT_FACTOR_SHIFT)) & GEN4PHY_DMD_CTRL0_REPEAT_FACTOR_MASK)

#define GEN4PHY_DMD_CTRL0_FED_ERR_SCALE_MASK     (0x3800000U)
#define GEN4PHY_DMD_CTRL0_FED_ERR_SCALE_SHIFT    (23U)
/*! FED_ERR_SCALE - Scaling factor used by the freqency tracking loop.
 */
#define GEN4PHY_DMD_CTRL0_FED_ERR_SCALE(x)       (((uint32_t)(((uint32_t)(x)) << GEN4PHY_DMD_CTRL0_FED_ERR_SCALE_SHIFT)) & GEN4PHY_DMD_CTRL0_FED_ERR_SCALE_MASK)

#define GEN4PHY_DMD_CTRL0_TERR_TRK_EN_MASK       (0x4000000U)
#define GEN4PHY_DMD_CTRL0_TERR_TRK_EN_SHIFT      (26U)
/*! TERR_TRK_EN - Enables time tracking in the demodulator.
 */
#define GEN4PHY_DMD_CTRL0_TERR_TRK_EN(x)         (((uint32_t)(((uint32_t)(x)) << GEN4PHY_DMD_CTRL0_TERR_TRK_EN_SHIFT)) & GEN4PHY_DMD_CTRL0_TERR_TRK_EN_MASK)

#define GEN4PHY_DMD_CTRL0_FERR_TRK_EN_MASK       (0x8000000U)
#define GEN4PHY_DMD_CTRL0_FERR_TRK_EN_SHIFT      (27U)
/*! FERR_TRK_EN - Enables frequency tracking in the demodulator.
 */
#define GEN4PHY_DMD_CTRL0_FERR_TRK_EN(x)         (((uint32_t)(((uint32_t)(x)) << GEN4PHY_DMD_CTRL0_FERR_TRK_EN_SHIFT)) & GEN4PHY_DMD_CTRL0_FERR_TRK_EN_MASK)

#define GEN4PHY_DMD_CTRL0_DREP_SINE_EN_MASK      (0x10000000U)
#define GEN4PHY_DMD_CTRL0_DREP_SINE_EN_SHIFT     (28U)
/*! DREP_SINE_EN - Flag used to enable the non-linear operation in the de-repeater.
 */
#define GEN4PHY_DMD_CTRL0_DREP_SINE_EN(x)        (((uint32_t)(((uint32_t)(x)) << GEN4PHY_DMD_CTRL0_DREP_SINE_EN_SHIFT)) & GEN4PHY_DMD_CTRL0_DREP_SINE_EN_MASK)

#define GEN4PHY_DMD_CTRL0_DEMOD_MOD_MASK         (0x60000000U)
#define GEN4PHY_DMD_CTRL0_DEMOD_MOD_SHIFT        (29U)
/*! DEMOD_MOD - Determines the number of taps used by the demodulator correlators;
 *  0b00..use 12 taps
 *  0b01..use 4 taps
 *  0b10..use 7 taps
 *  0b11..use 13 taps
 */
#define GEN4PHY_DMD_CTRL0_DEMOD_MOD(x)           (((uint32_t)(((uint32_t)(x)) << GEN4PHY_DMD_CTRL0_DEMOD_MOD_SHIFT)) & GEN4PHY_DMD_CTRL0_DEMOD_MOD_MASK)
/*! @} */

/*! @name DMD_CTRL1 - PHY Dmodulator Control 1 */
/*! @{ */

#define GEN4PHY_DMD_CTRL1_FED_IDLE_WIN_MASK      (0x3FFU)
#define GEN4PHY_DMD_CTRL1_FED_IDLE_WIN_SHIFT     (0U)
/*! FED_IDLE_WIN - Idle window size for the frequency tracking mechanism, expressed in symbols.
 */
#define GEN4PHY_DMD_CTRL1_FED_IDLE_WIN(x)        (((uint32_t)(((uint32_t)(x)) << GEN4PHY_DMD_CTRL1_FED_IDLE_WIN_SHIFT)) & GEN4PHY_DMD_CTRL1_FED_IDLE_WIN_MASK)

#define GEN4PHY_DMD_CTRL1_TED_ERR_SCALE_MASK     (0x3C00U)
#define GEN4PHY_DMD_CTRL1_TED_ERR_SCALE_SHIFT    (10U)
/*! TED_ERR_SCALE - Scaling factor used by the time tracking loop.
 */
#define GEN4PHY_DMD_CTRL1_TED_ERR_SCALE(x)       (((uint32_t)(((uint32_t)(x)) << GEN4PHY_DMD_CTRL1_TED_ERR_SCALE_SHIFT)) & GEN4PHY_DMD_CTRL1_TED_ERR_SCALE_MASK)

#define GEN4PHY_DMD_CTRL1_FED_IMM_MEAS_EN_MASK   (0x8000U)
#define GEN4PHY_DMD_CTRL1_FED_IMM_MEAS_EN_SHIFT  (15U)
/*! FED_IMM_MEAS_EN - Specifies whether the frequency tracking starts with an active window;
 *  0b0..start with idle window
 *  0b1..start with active window
 */
#define GEN4PHY_DMD_CTRL1_FED_IMM_MEAS_EN(x)     (((uint32_t)(((uint32_t)(x)) << GEN4PHY_DMD_CTRL1_FED_IMM_MEAS_EN_SHIFT)) & GEN4PHY_DMD_CTRL1_FED_IMM_MEAS_EN_MASK)

#define GEN4PHY_DMD_CTRL1_TED_IDLE_WIN_MASK      (0x3FF0000U)
#define GEN4PHY_DMD_CTRL1_TED_IDLE_WIN_SHIFT     (16U)
/*! TED_IDLE_WIN - Idle window size for the time tracking mechanism, expressed in symbols.
 */
#define GEN4PHY_DMD_CTRL1_TED_IDLE_WIN(x)        (((uint32_t)(((uint32_t)(x)) << GEN4PHY_DMD_CTRL1_TED_IDLE_WIN_SHIFT)) & GEN4PHY_DMD_CTRL1_TED_IDLE_WIN_MASK)

#define GEN4PHY_DMD_CTRL1_TTRK_INT_RANGE_MASK    (0x3C000000U)
#define GEN4PHY_DMD_CTRL1_TTRK_INT_RANGE_SHIFT   (26U)
/*! TTRK_INT_RANGE - Timing error correction interpolation range, expressed in samples. The value must equal or bigger than 1.
 */
#define GEN4PHY_DMD_CTRL1_TTRK_INT_RANGE(x)      (((uint32_t)(((uint32_t)(x)) << GEN4PHY_DMD_CTRL1_TTRK_INT_RANGE_SHIFT)) & GEN4PHY_DMD_CTRL1_TTRK_INT_RANGE_MASK)

#define GEN4PHY_DMD_CTRL1_TED_IMM_MEAS_EN_MASK   (0x80000000U)
#define GEN4PHY_DMD_CTRL1_TED_IMM_MEAS_EN_SHIFT  (31U)
/*! TED_IMM_MEAS_EN - Specifies whether the time tracking starts with an active window;
 *  0b0..start with idle window
 *  0b1..start with active window
 */
#define GEN4PHY_DMD_CTRL1_TED_IMM_MEAS_EN(x)     (((uint32_t)(((uint32_t)(x)) << GEN4PHY_DMD_CTRL1_TED_IMM_MEAS_EN_SHIFT)) & GEN4PHY_DMD_CTRL1_TED_IMM_MEAS_EN_MASK)
/*! @} */

/*! @name DMD_CTRL2 - PHY Demodulator Control 2 */
/*! @{ */

#define GEN4PHY_DMD_CTRL2_WAIT_DMD_LR_ADJ_MASK   (0xFU)
#define GEN4PHY_DMD_CTRL2_WAIT_DMD_LR_ADJ_SHIFT  (0U)
/*! WAIT_DMD_LR_ADJ - Reserved. Must be programed as reset value 1.
 */
#define GEN4PHY_DMD_CTRL2_WAIT_DMD_LR_ADJ(x)     (((uint32_t)(((uint32_t)(x)) << GEN4PHY_DMD_CTRL2_WAIT_DMD_LR_ADJ_SHIFT)) & GEN4PHY_DMD_CTRL2_WAIT_DMD_LR_ADJ_MASK)

#define GEN4PHY_DMD_CTRL2_WAIT_VIA_AFTER_AA_ADJ_MASK (0xF0U)
#define GEN4PHY_DMD_CTRL2_WAIT_VIA_AFTER_AA_ADJ_SHIFT (4U)
/*! WAIT_VIA_AFTER_AA_ADJ - Reserved. Must be programed as reset value 1.
 */
#define GEN4PHY_DMD_CTRL2_WAIT_VIA_AFTER_AA_ADJ(x) (((uint32_t)(((uint32_t)(x)) << GEN4PHY_DMD_CTRL2_WAIT_VIA_AFTER_AA_ADJ_SHIFT)) & GEN4PHY_DMD_CTRL2_WAIT_VIA_AFTER_AA_ADJ_MASK)

#define GEN4PHY_DMD_CTRL2_WAIT_DMD_CLKEN_ADJ_MASK (0xF00U)
#define GEN4PHY_DMD_CTRL2_WAIT_DMD_CLKEN_ADJ_SHIFT (8U)
/*! WAIT_DMD_CLKEN_ADJ - Reserved. Must be programed as reset value 1.
 */
#define GEN4PHY_DMD_CTRL2_WAIT_DMD_CLKEN_ADJ(x)  (((uint32_t)(((uint32_t)(x)) << GEN4PHY_DMD_CTRL2_WAIT_DMD_CLKEN_ADJ_SHIFT)) & GEN4PHY_DMD_CTRL2_WAIT_DMD_CLKEN_ADJ_MASK)
/*! @} */

/*! @name DMD_WAVE_REG0 -  */
/*! @{ */

#define GEN4PHY_DMD_WAVE_REG0_SMPL0_MASK         (0x3FU)
#define GEN4PHY_DMD_WAVE_REG0_SMPL0_SHIFT        (0U)
/*! SMPL0 - Demodulator waveform 7 sample 0 (sfix6en5)
 */
#define GEN4PHY_DMD_WAVE_REG0_SMPL0(x)           (((uint32_t)(((uint32_t)(x)) << GEN4PHY_DMD_WAVE_REG0_SMPL0_SHIFT)) & GEN4PHY_DMD_WAVE_REG0_SMPL0_MASK)

#define GEN4PHY_DMD_WAVE_REG0_SMPL1_MASK         (0xFC0U)
#define GEN4PHY_DMD_WAVE_REG0_SMPL1_SHIFT        (6U)
/*! SMPL1 - Demodulator waveform 7 sample 1 (sfix6en5)
 */
#define GEN4PHY_DMD_WAVE_REG0_SMPL1(x)           (((uint32_t)(((uint32_t)(x)) << GEN4PHY_DMD_WAVE_REG0_SMPL1_SHIFT)) & GEN4PHY_DMD_WAVE_REG0_SMPL1_MASK)

#define GEN4PHY_DMD_WAVE_REG0_SMPL2_MASK         (0x3F000U)
#define GEN4PHY_DMD_WAVE_REG0_SMPL2_SHIFT        (12U)
/*! SMPL2 - Demodulator waveform 7 sample 2 (sfix6en5)
 */
#define GEN4PHY_DMD_WAVE_REG0_SMPL2(x)           (((uint32_t)(((uint32_t)(x)) << GEN4PHY_DMD_WAVE_REG0_SMPL2_SHIFT)) & GEN4PHY_DMD_WAVE_REG0_SMPL2_MASK)

#define GEN4PHY_DMD_WAVE_REG0_SMPL3_MASK         (0xFC0000U)
#define GEN4PHY_DMD_WAVE_REG0_SMPL3_SHIFT        (18U)
/*! SMPL3 - Demodulator waveform 7 sample 3 (sfix6en5)
 */
#define GEN4PHY_DMD_WAVE_REG0_SMPL3(x)           (((uint32_t)(((uint32_t)(x)) << GEN4PHY_DMD_WAVE_REG0_SMPL3_SHIFT)) & GEN4PHY_DMD_WAVE_REG0_SMPL3_MASK)

#define GEN4PHY_DMD_WAVE_REG0_SMPL4_MASK         (0x3F000000U)
#define GEN4PHY_DMD_WAVE_REG0_SMPL4_SHIFT        (24U)
/*! SMPL4 - Demodulator waveform 7 sample 4 (sfix6en5)
 */
#define GEN4PHY_DMD_WAVE_REG0_SMPL4(x)           (((uint32_t)(((uint32_t)(x)) << GEN4PHY_DMD_WAVE_REG0_SMPL4_SHIFT)) & GEN4PHY_DMD_WAVE_REG0_SMPL4_MASK)
/*! @} */

/* The count of GEN4PHY_DMD_WAVE_REG0 */
#define GEN4PHY_DMD_WAVE_REG0_COUNT              (8U)

/*! @name DMD_WAVE_REG1 -  */
/*! @{ */

#define GEN4PHY_DMD_WAVE_REG1_SMPL5_MASK         (0x3FU)
#define GEN4PHY_DMD_WAVE_REG1_SMPL5_SHIFT        (0U)
/*! SMPL5 - Demodulator waveform 7 sample 5 (sfix6en5)
 */
#define GEN4PHY_DMD_WAVE_REG1_SMPL5(x)           (((uint32_t)(((uint32_t)(x)) << GEN4PHY_DMD_WAVE_REG1_SMPL5_SHIFT)) & GEN4PHY_DMD_WAVE_REG1_SMPL5_MASK)

#define GEN4PHY_DMD_WAVE_REG1_SMPL6_MASK         (0xFC0U)
#define GEN4PHY_DMD_WAVE_REG1_SMPL6_SHIFT        (6U)
/*! SMPL6 - Demodulator waveform 7 sample 6 (sfix6en5)
 */
#define GEN4PHY_DMD_WAVE_REG1_SMPL6(x)           (((uint32_t)(((uint32_t)(x)) << GEN4PHY_DMD_WAVE_REG1_SMPL6_SHIFT)) & GEN4PHY_DMD_WAVE_REG1_SMPL6_MASK)

#define GEN4PHY_DMD_WAVE_REG1_SMPL7_MASK         (0x3F000U)
#define GEN4PHY_DMD_WAVE_REG1_SMPL7_SHIFT        (12U)
/*! SMPL7 - Demodulator waveform 7 sample 7 (sfix6en5)
 */
#define GEN4PHY_DMD_WAVE_REG1_SMPL7(x)           (((uint32_t)(((uint32_t)(x)) << GEN4PHY_DMD_WAVE_REG1_SMPL7_SHIFT)) & GEN4PHY_DMD_WAVE_REG1_SMPL7_MASK)

#define GEN4PHY_DMD_WAVE_REG1_SMPL8_MASK         (0xFC0000U)
#define GEN4PHY_DMD_WAVE_REG1_SMPL8_SHIFT        (18U)
/*! SMPL8 - Demodulator waveform 7 sample 8 (sfix6en5)
 */
#define GEN4PHY_DMD_WAVE_REG1_SMPL8(x)           (((uint32_t)(((uint32_t)(x)) << GEN4PHY_DMD_WAVE_REG1_SMPL8_SHIFT)) & GEN4PHY_DMD_WAVE_REG1_SMPL8_MASK)

#define GEN4PHY_DMD_WAVE_REG1_SMPL9_MASK         (0x3F000000U)
#define GEN4PHY_DMD_WAVE_REG1_SMPL9_SHIFT        (24U)
/*! SMPL9 - Demodulator waveform 7 sample 9 (sfix6en5)
 */
#define GEN4PHY_DMD_WAVE_REG1_SMPL9(x)           (((uint32_t)(((uint32_t)(x)) << GEN4PHY_DMD_WAVE_REG1_SMPL9_SHIFT)) & GEN4PHY_DMD_WAVE_REG1_SMPL9_MASK)
/*! @} */

/* The count of GEN4PHY_DMD_WAVE_REG1 */
#define GEN4PHY_DMD_WAVE_REG1_COUNT              (8U)

/*! @name DMD_WAVE_REG2 -  */
/*! @{ */

#define GEN4PHY_DMD_WAVE_REG2_SMPL10_MASK        (0x3FU)
#define GEN4PHY_DMD_WAVE_REG2_SMPL10_SHIFT       (0U)
/*! SMPL10 - Demodulator waveform 7 sample 10 (sfix6en5)
 */
#define GEN4PHY_DMD_WAVE_REG2_SMPL10(x)          (((uint32_t)(((uint32_t)(x)) << GEN4PHY_DMD_WAVE_REG2_SMPL10_SHIFT)) & GEN4PHY_DMD_WAVE_REG2_SMPL10_MASK)

#define GEN4PHY_DMD_WAVE_REG2_SMPL11_MASK        (0xFC0U)
#define GEN4PHY_DMD_WAVE_REG2_SMPL11_SHIFT       (6U)
/*! SMPL11 - Demodulator waveform 7 sample 11 (sfix6en5)
 */
#define GEN4PHY_DMD_WAVE_REG2_SMPL11(x)          (((uint32_t)(((uint32_t)(x)) << GEN4PHY_DMD_WAVE_REG2_SMPL11_SHIFT)) & GEN4PHY_DMD_WAVE_REG2_SMPL11_MASK)

#define GEN4PHY_DMD_WAVE_REG2_SMPL12_MASK        (0x3F000U)
#define GEN4PHY_DMD_WAVE_REG2_SMPL12_SHIFT       (12U)
/*! SMPL12 - Demodulator waveform 7 sample 12 (sfix6en5)
 */
#define GEN4PHY_DMD_WAVE_REG2_SMPL12(x)          (((uint32_t)(((uint32_t)(x)) << GEN4PHY_DMD_WAVE_REG2_SMPL12_SHIFT)) & GEN4PHY_DMD_WAVE_REG2_SMPL12_MASK)
/*! @} */

/* The count of GEN4PHY_DMD_WAVE_REG2 */
#define GEN4PHY_DMD_WAVE_REG2_COUNT              (8U)

/*! @name DMDAA_CTRL - PHY Demodulator Based SFD Confirmation control register. */
/*! @{ */

#define GEN4PHY_DMDAA_CTRL_DMDAA_HAMM_LP_MASK    (0x7U)
#define GEN4PHY_DMDAA_CTRL_DMDAA_HAMM_LP_SHIFT   (0U)
/*! DMDAA_HAMM_LP - Maximum hamming distance from the given AA pattern that may still be accepted as
 *    a match in low power case; valid range [0,7].
 */
#define GEN4PHY_DMDAA_CTRL_DMDAA_HAMM_LP(x)      (((uint32_t)(((uint32_t)(x)) << GEN4PHY_DMDAA_CTRL_DMDAA_HAMM_LP_SHIFT)) & GEN4PHY_DMDAA_CTRL_DMDAA_HAMM_LP_MASK)

#define GEN4PHY_DMDAA_CTRL_DMDAA_HAMM_HP_MASK    (0x38U)
#define GEN4PHY_DMDAA_CTRL_DMDAA_HAMM_HP_SHIFT   (3U)
/*! DMDAA_HAMM_HP - Maximum hamming distance from the given AA pattern that may still be accepted as
 *    a match in high power case; valid range [0,7].
 */
#define GEN4PHY_DMDAA_CTRL_DMDAA_HAMM_HP(x)      (((uint32_t)(((uint32_t)(x)) << GEN4PHY_DMDAA_CTRL_DMDAA_HAMM_HP_SHIFT)) & GEN4PHY_DMDAA_CTRL_DMDAA_HAMM_HP_MASK)

#define GEN4PHY_DMDAA_CTRL_HIPOW_DIS_OVRD_MASK   (0x40U)
#define GEN4PHY_DMDAA_CTRL_HIPOW_DIS_OVRD_SHIFT  (6U)
/*! HIPOW_DIS_OVRD - Override the feature: disable DMDAA when power sensitivity is higher;
 *  0b0..disable override, DMDAA disabled when power is high
 *  0b1..enable override, DMDAA enabled when power is high
 */
#define GEN4PHY_DMDAA_CTRL_HIPOW_DIS_OVRD(x)     (((uint32_t)(((uint32_t)(x)) << GEN4PHY_DMDAA_CTRL_HIPOW_DIS_OVRD_SHIFT)) & GEN4PHY_DMDAA_CTRL_HIPOW_DIS_OVRD_MASK)

#define GEN4PHY_DMDAA_CTRL_DMDAA_EN_MASK         (0x80U)
#define GEN4PHY_DMDAA_CTRL_DMDAA_EN_SHIFT        (7U)
/*! DMDAA_EN - Enables Demodulator Based SFD Confirmation;
 *  0b0..disable
 *  0b1..enable
 */
#define GEN4PHY_DMDAA_CTRL_DMDAA_EN(x)           (((uint32_t)(((uint32_t)(x)) << GEN4PHY_DMDAA_CTRL_DMDAA_EN_SHIFT)) & GEN4PHY_DMDAA_CTRL_DMDAA_EN_MASK)
/*! @} */

/*! @name RTT_STAT - High resolution Time-Of-Flight calculation Status. */
/*! @{ */

#define GEN4PHY_RTT_STAT_RTT_CFO_MASK            (0xFFFFU)
#define GEN4PHY_RTT_STAT_RTT_CFO_SHIFT           (0U)
/*! RTT_CFO - The high accuracy CFO computed by the HARTT block through the CORDIC algorithm.
 */
#define GEN4PHY_RTT_STAT_RTT_CFO(x)              (((uint32_t)(((uint32_t)(x)) << GEN4PHY_RTT_STAT_RTT_CFO_SHIFT)) & GEN4PHY_RTT_STAT_RTT_CFO_MASK)

#define GEN4PHY_RTT_STAT_RTT_P_DELTA_MASK        (0x3FF0000U)
#define GEN4PHY_RTT_STAT_RTT_P_DELTA_SHIFT       (16U)
/*! RTT_P_DELTA - Difference between the squared correlation magnitude values, pm-pp provided by the HARTT block, format is sfix10En9.
 */
#define GEN4PHY_RTT_STAT_RTT_P_DELTA(x)          (((uint32_t)(((uint32_t)(x)) << GEN4PHY_RTT_STAT_RTT_P_DELTA_SHIFT)) & GEN4PHY_RTT_STAT_RTT_P_DELTA_MASK)

#define GEN4PHY_RTT_STAT_RTT_DIST_SAT_MASK       (0xC000000U)
#define GEN4PHY_RTT_STAT_RTT_DIST_SAT_SHIFT      (26U)
/*! RTT_DIST_SAT - Computed Hamming distance saturated to 2 bits, format is ufix2.
 */
#define GEN4PHY_RTT_STAT_RTT_DIST_SAT(x)         (((uint32_t)(((uint32_t)(x)) << GEN4PHY_RTT_STAT_RTT_DIST_SAT_SHIFT)) & GEN4PHY_RTT_STAT_RTT_DIST_SAT_MASK)

#define GEN4PHY_RTT_STAT_RTT_INT_ADJ_MASK        (0x30000000U)
#define GEN4PHY_RTT_STAT_RTT_INT_ADJ_SHIFT       (28U)
/*! RTT_INT_ADJ - An integer adjustment of the timing which takes a value different of 0 when the
 *    early-late mechanism in the HARTT block chooses a peak different of the one chosen in the
 *    acquisition module (possible values are {-1,0,+1}).
 */
#define GEN4PHY_RTT_STAT_RTT_INT_ADJ(x)          (((uint32_t)(((uint32_t)(x)) << GEN4PHY_RTT_STAT_RTT_INT_ADJ_SHIFT)) & GEN4PHY_RTT_STAT_RTT_INT_ADJ_MASK)

#define GEN4PHY_RTT_STAT_RTT_FOUND_MASK          (0x40000000U)
#define GEN4PHY_RTT_STAT_RTT_FOUND_SHIFT         (30U)
/*! RTT_FOUND - Flag that indicates that the HARTT operation is done and a valid PN pattern was detected.
 */
#define GEN4PHY_RTT_STAT_RTT_FOUND(x)            (((uint32_t)(((uint32_t)(x)) << GEN4PHY_RTT_STAT_RTT_FOUND_SHIFT)) & GEN4PHY_RTT_STAT_RTT_FOUND_MASK)
/*! @} */

/*! @name RTT_CTRL - PHY RTT control register. */
/*! @{ */

#define GEN4PHY_RTT_CTRL_HA_RTT_THRESHOLD_MASK   (0x1FFU)
#define GEN4PHY_RTT_CTRL_HA_RTT_THRESHOLD_SHIFT  (0U)
/*! HA_RTT_THRESHOLD - threshold used to validate a HA RTT result.
 */
#define GEN4PHY_RTT_CTRL_HA_RTT_THRESHOLD(x)     (((uint32_t)(((uint32_t)(x)) << GEN4PHY_RTT_CTRL_HA_RTT_THRESHOLD_SHIFT)) & GEN4PHY_RTT_CTRL_HA_RTT_THRESHOLD_MASK)

#define GEN4PHY_RTT_CTRL_FIRST_PDU_BIT_MASK      (0x1000U)
#define GEN4PHY_RTT_CTRL_FIRST_PDU_BIT_SHIFT     (12U)
/*! FIRST_PDU_BIT - is programmed by software - used for regular packets high accuracy RTT;
 */
#define GEN4PHY_RTT_CTRL_FIRST_PDU_BIT(x)        (((uint32_t)(((uint32_t)(x)) << GEN4PHY_RTT_CTRL_FIRST_PDU_BIT_SHIFT)) & GEN4PHY_RTT_CTRL_FIRST_PDU_BIT_MASK)

#define GEN4PHY_RTT_CTRL_RTT_SEQ_LEN_MASK        (0x2000U)
#define GEN4PHY_RTT_CTRL_RTT_SEQ_LEN_SHIFT       (13U)
/*! RTT_SEQ_LEN - can be either 32 (when 0) or 64 bits (when 1) depending on the RTT configuration;
 */
#define GEN4PHY_RTT_CTRL_RTT_SEQ_LEN(x)          (((uint32_t)(((uint32_t)(x)) << GEN4PHY_RTT_CTRL_RTT_SEQ_LEN_SHIFT)) & GEN4PHY_RTT_CTRL_RTT_SEQ_LEN_MASK)

#define GEN4PHY_RTT_CTRL_OVERRD_PROGR_AA_MASK    (0x4000U)
#define GEN4PHY_RTT_CTRL_OVERRD_PROGR_AA_SHIFT   (14U)
/*! OVERRD_PROGR_AA - Enables overriding the programmed AA bits with the PN sequence used by RTT;
 */
#define GEN4PHY_RTT_CTRL_OVERRD_PROGR_AA(x)      (((uint32_t)(((uint32_t)(x)) << GEN4PHY_RTT_CTRL_OVERRD_PROGR_AA_SHIFT)) & GEN4PHY_RTT_CTRL_OVERRD_PROGR_AA_MASK)

#define GEN4PHY_RTT_CTRL_EN_HIGH_ACC_RTT_MASK    (0x8000U)
#define GEN4PHY_RTT_CTRL_EN_HIGH_ACC_RTT_SHIFT   (15U)
/*! EN_HIGH_ACC_RTT - enables the use of the HA RTT block;
 */
#define GEN4PHY_RTT_CTRL_EN_HIGH_ACC_RTT(x)      (((uint32_t)(((uint32_t)(x)) << GEN4PHY_RTT_CTRL_EN_HIGH_ACC_RTT_SHIFT)) & GEN4PHY_RTT_CTRL_EN_HIGH_ACC_RTT_MASK)
/*! @} */

/*! @name RTT_REF - PHY RTT reference register. */
/*! @{ */

#define GEN4PHY_RTT_REF_FM_REF_010_MASK          (0xFFU)
#define GEN4PHY_RTT_REF_FM_REF_010_SHIFT         (0U)
/*! FM_REF_010 - Contextual values used to derive the FM reference ha_rtt_threshold .
 */
#define GEN4PHY_RTT_REF_FM_REF_010(x)            (((uint32_t)(((uint32_t)(x)) << GEN4PHY_RTT_REF_FM_REF_010_SHIFT)) & GEN4PHY_RTT_REF_FM_REF_010_MASK)

#define GEN4PHY_RTT_REF_FM_REF_110_MASK          (0xFF00U)
#define GEN4PHY_RTT_REF_FM_REF_110_SHIFT         (8U)
/*! FM_REF_110 - Contextual values used to derive the FM reference ha_rtt_threshold .
 */
#define GEN4PHY_RTT_REF_FM_REF_110(x)            (((uint32_t)(((uint32_t)(x)) << GEN4PHY_RTT_REF_FM_REF_110_SHIFT)) & GEN4PHY_RTT_REF_FM_REF_110_MASK)

#define GEN4PHY_RTT_REF_FM_REF_111_MASK          (0xFF0000U)
#define GEN4PHY_RTT_REF_FM_REF_111_SHIFT         (16U)
/*! FM_REF_111 - Contextual values used to derive the FM reference ha_rtt_threshold .
 */
#define GEN4PHY_RTT_REF_FM_REF_111(x)            (((uint32_t)(((uint32_t)(x)) << GEN4PHY_RTT_REF_FM_REF_111_SHIFT)) & GEN4PHY_RTT_REF_FM_REF_111_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group GEN4PHY_Register_Masks */


/* GEN4PHY - Peripheral instance base addresses */
#if (defined(__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE & 0x2))
  /** Peripheral XCVR_2P4GHZ_PHY base address */
  #define XCVR_2P4GHZ_PHY_BASE                     (0x58A07600u)
  /** Peripheral XCVR_2P4GHZ_PHY base address */
  #define XCVR_2P4GHZ_PHY_BASE_NS                  (0x48A07600u)
  /** Peripheral XCVR_2P4GHZ_PHY base pointer */
  #define XCVR_2P4GHZ_PHY                          ((GEN4PHY_Type *)XCVR_2P4GHZ_PHY_BASE)
  /** Peripheral XCVR_2P4GHZ_PHY base pointer */
  #define XCVR_2P4GHZ_PHY_NS                       ((GEN4PHY_Type *)XCVR_2P4GHZ_PHY_BASE_NS)
  /** Array initializer of GEN4PHY peripheral base addresses */
  #define GEN4PHY_BASE_ADDRS                       { XCVR_2P4GHZ_PHY_BASE }
  /** Array initializer of GEN4PHY peripheral base pointers */
  #define GEN4PHY_BASE_PTRS                        { XCVR_2P4GHZ_PHY }
  /** Array initializer of GEN4PHY peripheral base addresses */
  #define GEN4PHY_BASE_ADDRS_NS                    { XCVR_2P4GHZ_PHY_BASE_NS }
  /** Array initializer of GEN4PHY peripheral base pointers */
  #define GEN4PHY_BASE_PTRS_NS                     { XCVR_2P4GHZ_PHY_NS }
#else
  /** Peripheral XCVR_2P4GHZ_PHY base address */
  #define XCVR_2P4GHZ_PHY_BASE                     (0x48A07600u)
  /** Peripheral XCVR_2P4GHZ_PHY base pointer */
  #define XCVR_2P4GHZ_PHY                          ((GEN4PHY_Type *)XCVR_2P4GHZ_PHY_BASE)
  /** Array initializer of GEN4PHY peripheral base addresses */
  #define GEN4PHY_BASE_ADDRS                       { XCVR_2P4GHZ_PHY_BASE }
  /** Array initializer of GEN4PHY peripheral base pointers */
  #define GEN4PHY_BASE_PTRS                        { XCVR_2P4GHZ_PHY }
#endif

/*!
 * @}
 */ /* end of group GEN4PHY_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- GENFSK Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup GENFSK_Peripheral_Access_Layer GENFSK Peripheral Access Layer
 * @{
 */

/** GENFSK - Register Layout Typedef */
typedef struct {
  __IO uint32_t IRQ_CTRL;                          /**< IRQ CONTROL, offset: 0x0 */
  __I  uint32_t EVENT_TMR;                         /**< EVENT TIMER, offset: 0x4 */
  __IO uint32_t T1_CMP;                            /**< T1 COMPARE, offset: 0x8 */
  __IO uint32_t T2_CMP;                            /**< T2 COMPARE, offset: 0xC */
  __I  uint32_t TIMESTAMP;                         /**< TIMESTAMP, offset: 0x10 */
  __IO uint32_t XCVR_CTRL;                         /**< TRANSCEIVER CONTROL, offset: 0x14 */
  __I  uint32_t XCVR_STS;                          /**< TRANSCEIVER STATUS, offset: 0x18 */
  __IO uint32_t XCVR_CFG;                          /**< TRANSCEIVER CONFIGURATION, offset: 0x1C */
  __IO uint32_t CHANNEL_NUM0;                      /**< CHANNEL NUMBER 0, offset: 0x20 */
  __IO uint32_t TX_POWER;                          /**< TRANSMIT POWER, offset: 0x24 */
  __IO uint32_t NTW_ADR_CTRL;                      /**< NETWORK ADDRESS CONTROL, offset: 0x28 */
  __IO uint32_t NTW_ADR_0;                         /**< NETWORK ADDRESS 0, offset: 0x2C */
  __IO uint32_t NTW_ADR_1;                         /**< NETWORK ADDRESS 1, offset: 0x30 */
  __IO uint32_t NTW_ADR_2;                         /**< NETWORK ADDRESS 2, offset: 0x34 */
  __IO uint32_t NTW_ADR_3;                         /**< NETWORK ADDRESS 3, offset: 0x38 */
  __IO uint32_t RX_WATERMARK;                      /**< RECEIVE WATERMARK, offset: 0x3C */
  __IO uint32_t DSM_CTRL;                          /**< DSM CONTROL, offset: 0x40 */
  __I  uint32_t PART_ID;                           /**< PART ID, offset: 0x44 */
  __IO uint32_t SLOT_PRELOAD;                      /**< SLOT PRELOAD, offset: 0x48 */
  __IO uint32_t SLOT_TIME;                         /**< SLOT TIME, offset: 0x4C */
  __IO uint32_t TURNAROUND_TIME;                   /**< TURNAROUND TIME, offset: 0x50 */
  __IO uint32_t ACKDELAY;                          /**< ACK DELAY, offset: 0x54 */
  __IO uint32_t RXDELAY;                           /**< RX DELAY, offset: 0x58 */
  __IO uint32_t TXDELAY;                           /**< TX DELAY, offset: 0x5C */
  __IO uint32_t PACKET_CFG;                        /**< PACKET CONFIGURATION, offset: 0x60 */
  __IO uint32_t H0_CFG;                            /**< H0 CONFIGURATION, offset: 0x64 */
  __IO uint32_t H1_CFG;                            /**< H1 CONFIGURATION, offset: 0x68 */
  __IO uint32_t CRC_CFG;                           /**< CRC CONFIGURATION, offset: 0x6C */
  __IO uint32_t LENGTH_ADJ;                        /**< LENGTH ADJUSTMENT, offset: 0x70 */
  __I  uint32_t TIMESTAMP_RX_DONE;                 /**< TIMESTAMP_RX_DONE, offset: 0x74 */
  __I  uint32_t TIMESTAMP_TX_DONE;                 /**< TIMESTAMP_TX_DONE, offset: 0x78 */
  __IO uint32_t MULT_PKT_CTRL;                     /**< MULT_PKT_CTRL, offset: 0x7C */
  __IO uint32_t RPA_WL_STATUS;                     /**< RPA AND WHITE LIST STATUS, offset: 0x80 */
  __IO uint32_t LENGTH_MAX;                        /**< MAXIMUM LENGTH, offset: 0x84 */
  __O  uint32_t EVENT_TMR_LD;                      /**< EVENT TIMER LOAD, offset: 0x88 */
  __O  uint32_t EVENT_TMR_ADD;                     /**< EVENT TIMER ADD, offset: 0x8C */
  __IO uint32_t ENH_FEATURE;                       /**< ENHANCED FEATURES, offset: 0x90 */
  __IO uint32_t RX_FRAME_FILTER;                   /**< RECEIVE FRAME FILTER, offset: 0x94 */
  __IO uint32_t FILTERFAIL_CODE;                   /**< FILTER FAIL CODE, offset: 0x98 */
  union {                                          /* offset: 0x9C */
    __IO uint32_t LENIENCY_LSB;                      /**< LENIENCY LSB, offset: 0x9C */
    __IO uint32_t RPA_CTRL;                          /**< RPA CONTROL, offset: 0x9C */
  };
  union {                                          /* offset: 0xA0 */
    __IO uint32_t LENIENCY_MSB;                      /**< LENIENCY MSB, offset: 0xA0 */
    __IO uint32_t WL_CTRL;                           /**< WHITE LIST CONTROL, offset: 0xA0 */
  };
  __IO uint32_t DUAL_PAN_CTRL;                     /**< DUAL PAN CONTROL, offset: 0xA4 */
  union {                                          /* offset: 0xA8 */
    __IO uint32_t GTM_PDU;                           /**< GTM MODE PDU, offset: 0xA8 */
    __IO uint32_t MACSHORTADDRS1;                    /**< MAC SHORT ADDRESS FOR PAN1, offset: 0xA8 */
    __IO uint32_t WL_VALID_ENTRY1;                   /**< VALID ENTRY OF WHITE LIST 1, offset: 0xA8 */
  };
  union {                                          /* offset: 0xAC */
    __IO uint32_t DIRECT_PEER_ADDR_LSB;              /**< DIRECT_PEER_ADDR[31:0], offset: 0xAC */
    __IO uint32_t GTM_CFG;                           /**< GTM MODE CONFIGURATION, offset: 0xAC */
    __IO uint32_t MACLONGADDRS1_LSB;                 /**< MAC LONG ADDRESS 1 LSB, offset: 0xAC */
  };
  union {                                          /* offset: 0xB0 */
    __IO uint32_t DIRECT_PEER_ADDR_MSB;              /**< DIRECT_PEER_ADDR[47:32], offset: 0xB0 */
    __IO uint32_t GTM_IPD;                           /**< GTM MODE INTER-PACKET DURATION, offset: 0xB0 */
    __IO uint32_t MACLONGADDRS1_MSB;                 /**< MAC LONG ADDRESS 1 MSB, offset: 0xB0 */
  };
  __IO uint32_t CHANNEL_NUM1;                      /**< CHANNEL NUMBER 1, offset: 0xB4 */
  union {                                          /* offset: 0xB8 */
    __IO uint32_t MACSHORTADDRS0;                    /**< MAC SHORT ADDRESS 0, offset: 0xB8 */
    __IO uint32_t WL_VALID_ENTRY0;                   /**< VALID ENTRY OF WHITE LIST 0, offset: 0xB8 */
  };
  union {                                          /* offset: 0xBC */
    __IO uint32_t GTM_FIRST_SFD2WD;                  /**< GTM MODE TIME OF FIRST SFD FOUND TO FORCE RX WARMDOWN, offset: 0xBC */
    __IO uint32_t MACLONGADDRS0_LSB;                 /**< MAC LONG ADDRESS 0 LSB, offset: 0xBC */
    __IO uint32_t WL_SEARCH_ADDR_LSB;                /**< WL_SEARCH_ADDR[31:0], offset: 0xBC */
  };
  union {                                          /* offset: 0xC0 */
    __IO uint32_t GTM_RX_RECYCLE_TIME;               /**< GTM MODE RX RECYCLE TIME, offset: 0xC0 */
    __IO uint32_t MACLONGADDRS0_MSB;                 /**< MAC LONG ADDRESS 0 MSB, offset: 0xC0 */
    __IO uint32_t WL_SEARCH_ADDR_MSB;                /**< WL_SEARCH_ADDR[47:32], offset: 0xC0 */
  };
  __IO uint32_t CCA_LQI_CTRL;                      /**< CCA AND LQI CONTROL, offset: 0xC4 */
  __I  uint32_t WARMUP_TIME;                       /**< TX/RX WARMUP TIME, offset: 0xC8 */
  __IO uint32_t RXEN_DLY;                          /**< RX_EN Delay Time, offset: 0xCC */
       uint8_t RESERVED_0[4];
  __IO uint32_t SAM_CTRL;                          /**< SAM CONTROL, offset: 0xD4 */
  __IO uint32_t SAM_TABLE;                         /**< SOURCE ADDRESS MANAGEMENT TABLE, offset: 0xD8 */
  __I  uint32_t SAM_MATCH;                         /**< SOURCE ADDRESS MANAGEMENT MATCH, offset: 0xDC */
  __I  uint32_t SAM_FREE_IDX;                      /**< SAM FREE INDEX, offset: 0xE0 */
  __IO uint32_t MISC1;                             /**< MISCELLANEOUS(1), offset: 0xE4 */
  __I  uint32_t SEQ_STS;                           /**< SEQUENCE STATUS, offset: 0xE8 */
  __IO uint32_t PHR_MISC;                          /**< PHR MISCELLANEOUS, offset: 0xEC */
  __IO uint32_t GTM_CTRL;                          /**< GTM CONTROL, offset: 0xF0 */
  __I  uint32_t GTM_BAD_CNT;                       /**< GTM BAD PACKET COUNTER, offset: 0xF4 */
  __I  uint32_t GTM_GOOD_CNT;                      /**< GTM GOOD PACKET COUNTER, offset: 0xF8 */
  __I  uint32_t GTM_PKT_CNT;                       /**< GTM PACKET COUNTER, offset: 0xFC */
  __IO uint32_t COEX_CTRL;                         /**< COEXISTENCE CONTROL, offset: 0x100 */
  __IO uint32_t COEX_PRIORITY;                     /**< COEXISTENCE PRIORITY, offset: 0x104 */
  __IO uint32_t IRQ_CTRL2;                         /**< IRQ CONTROL 2, offset: 0x108 */
} GENFSK_Type;

/* ----------------------------------------------------------------------------
   -- GENFSK Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup GENFSK_Register_Masks GENFSK Register Masks
 * @{
 */

/*! @name IRQ_CTRL - IRQ CONTROL */
/*! @{ */

#define GENFSK_IRQ_CTRL_SEQ_END_IRQ_MASK         (0x1U)
#define GENFSK_IRQ_CTRL_SEQ_END_IRQ_SHIFT        (0U)
/*! SEQ_END_IRQ - Sequence End Interrupt
 *  0b0..Sequence End Interrupt is not asserted.
 *  0b1..Sequence End Interrupt is asserted.
 */
#define GENFSK_IRQ_CTRL_SEQ_END_IRQ(x)           (((uint32_t)(((uint32_t)(x)) << GENFSK_IRQ_CTRL_SEQ_END_IRQ_SHIFT)) & GENFSK_IRQ_CTRL_SEQ_END_IRQ_MASK)

#define GENFSK_IRQ_CTRL_TX_IRQ_MASK              (0x2U)
#define GENFSK_IRQ_CTRL_TX_IRQ_SHIFT             (1U)
/*! TX_IRQ - TX Interrupt
 *  0b0..TX Interrupt is not asserted.
 *  0b1..TX Interrupt is asserted.
 */
#define GENFSK_IRQ_CTRL_TX_IRQ(x)                (((uint32_t)(((uint32_t)(x)) << GENFSK_IRQ_CTRL_TX_IRQ_SHIFT)) & GENFSK_IRQ_CTRL_TX_IRQ_MASK)

#define GENFSK_IRQ_CTRL_RX_IRQ_MASK              (0x4U)
#define GENFSK_IRQ_CTRL_RX_IRQ_SHIFT             (2U)
/*! RX_IRQ - RX Interrupt
 *  0b0..RX Interrupt is not asserted.
 *  0b1..RX Interrupt is asserted.
 */
#define GENFSK_IRQ_CTRL_RX_IRQ(x)                (((uint32_t)(((uint32_t)(x)) << GENFSK_IRQ_CTRL_RX_IRQ_SHIFT)) & GENFSK_IRQ_CTRL_RX_IRQ_MASK)

#define GENFSK_IRQ_CTRL_NTW_ADR_IRQ_MASK         (0x8U)
#define GENFSK_IRQ_CTRL_NTW_ADR_IRQ_SHIFT        (3U)
/*! NTW_ADR_IRQ - Network Address Match Interrupt
 *  0b0..Network Address Match Interrupt is not asserted.
 *  0b1..Network Address Match Interrupt is asserted.
 */
#define GENFSK_IRQ_CTRL_NTW_ADR_IRQ(x)           (((uint32_t)(((uint32_t)(x)) << GENFSK_IRQ_CTRL_NTW_ADR_IRQ_SHIFT)) & GENFSK_IRQ_CTRL_NTW_ADR_IRQ_MASK)

#define GENFSK_IRQ_CTRL_T1_IRQ_MASK              (0x10U)
#define GENFSK_IRQ_CTRL_T1_IRQ_SHIFT             (4U)
/*! T1_IRQ - Timer1 (T1) Compare Interrupt
 *  0b0..Timer1 (T1) Compare Interrupt is not asserted.
 *  0b1..Timer1 (T1) Compare Interrupt is asserted.
 */
#define GENFSK_IRQ_CTRL_T1_IRQ(x)                (((uint32_t)(((uint32_t)(x)) << GENFSK_IRQ_CTRL_T1_IRQ_SHIFT)) & GENFSK_IRQ_CTRL_T1_IRQ_MASK)

#define GENFSK_IRQ_CTRL_T2_IRQ_MASK              (0x20U)
#define GENFSK_IRQ_CTRL_T2_IRQ_SHIFT             (5U)
/*! T2_IRQ - Timer2 (T2) Compare Interrupt
 *  0b0..Timer2 (T2) Compare Interrupt is not asserted.
 *  0b1..Timer2 (T2) Compare Interrupt is asserted.
 */
#define GENFSK_IRQ_CTRL_T2_IRQ(x)                (((uint32_t)(((uint32_t)(x)) << GENFSK_IRQ_CTRL_T2_IRQ_SHIFT)) & GENFSK_IRQ_CTRL_T2_IRQ_MASK)

#define GENFSK_IRQ_CTRL_PLL_UNLOCK_IRQ_MASK      (0x40U)
#define GENFSK_IRQ_CTRL_PLL_UNLOCK_IRQ_SHIFT     (6U)
/*! PLL_UNLOCK_IRQ - PLL Unlock Interrupt
 *  0b0..PLL Unlock Interrupt is not asserted.
 *  0b1..PLL Unlock Interrupt is asserted.
 */
#define GENFSK_IRQ_CTRL_PLL_UNLOCK_IRQ(x)        (((uint32_t)(((uint32_t)(x)) << GENFSK_IRQ_CTRL_PLL_UNLOCK_IRQ_SHIFT)) & GENFSK_IRQ_CTRL_PLL_UNLOCK_IRQ_MASK)

#define GENFSK_IRQ_CTRL_WAKE_IRQ_MASK            (0x80U)
#define GENFSK_IRQ_CTRL_WAKE_IRQ_SHIFT           (7U)
/*! WAKE_IRQ - Wake Interrrupt
 *  0b0..Wake Interrupt is not asserted.
 *  0b1..Wake Interrupt is asserted.
 */
#define GENFSK_IRQ_CTRL_WAKE_IRQ(x)              (((uint32_t)(((uint32_t)(x)) << GENFSK_IRQ_CTRL_WAKE_IRQ_SHIFT)) & GENFSK_IRQ_CTRL_WAKE_IRQ_MASK)

#define GENFSK_IRQ_CTRL_RX_WATERMARK_IRQ_MASK    (0x100U)
#define GENFSK_IRQ_CTRL_RX_WATERMARK_IRQ_SHIFT   (8U)
/*! RX_WATERMARK_IRQ - RX Watermark Interrupt
 *  0b0..RX Watermark Interrupt is not asserted.
 *  0b1..RX Watermark Interrupt is asserted.
 */
#define GENFSK_IRQ_CTRL_RX_WATERMARK_IRQ(x)      (((uint32_t)(((uint32_t)(x)) << GENFSK_IRQ_CTRL_RX_WATERMARK_IRQ_SHIFT)) & GENFSK_IRQ_CTRL_RX_WATERMARK_IRQ_MASK)

#define GENFSK_IRQ_CTRL_TSM_IRQ_MASK             (0x200U)
#define GENFSK_IRQ_CTRL_TSM_IRQ_SHIFT            (9U)
/*! TSM_IRQ - TSM Interrupt
 *  0b0..TSM0_IRQ and TSM1_IRQ are both clear.
 *  0b1..Indicates TSM0_IRQ or TSM1_IRQ is set in XCVR_STATUS.
 */
#define GENFSK_IRQ_CTRL_TSM_IRQ(x)               (((uint32_t)(((uint32_t)(x)) << GENFSK_IRQ_CTRL_TSM_IRQ_SHIFT)) & GENFSK_IRQ_CTRL_TSM_IRQ_MASK)

#define GENFSK_IRQ_CTRL_CRC_VALID_MASK           (0x400U)
#define GENFSK_IRQ_CTRL_CRC_VALID_SHIFT          (10U)
/*! CRC_VALID - CRC Valid
 */
#define GENFSK_IRQ_CTRL_CRC_VALID(x)             (((uint32_t)(((uint32_t)(x)) << GENFSK_IRQ_CTRL_CRC_VALID_SHIFT)) & GENFSK_IRQ_CTRL_CRC_VALID_MASK)

#define GENFSK_IRQ_CTRL_ACK_IRQ_MASK             (0x800U)
#define GENFSK_IRQ_CTRL_ACK_IRQ_SHIFT            (11U)
/*! ACK_IRQ - Auto ACK Interrupt
 *  0b0..Auto ACK Interrupt is not asserted.
 *  0b1..Auto ACK Interrupt is asserted.
 */
#define GENFSK_IRQ_CTRL_ACK_IRQ(x)               (((uint32_t)(((uint32_t)(x)) << GENFSK_IRQ_CTRL_ACK_IRQ_SHIFT)) & GENFSK_IRQ_CTRL_ACK_IRQ_MASK)

#define GENFSK_IRQ_CTRL_PHRFFAIL_IRQ_MASK        (0x1000U)
#define GENFSK_IRQ_CTRL_PHRFFAIL_IRQ_SHIFT       (12U)
/*! PHRFFAIL_IRQ - Received Frame PHR Fail Interrupt
 *  0b0..Received frame PHR Fail Interrupt is not asserted.
 *  0b1..Received frame PHR Fail Interrupt is asserted.
 */
#define GENFSK_IRQ_CTRL_PHRFFAIL_IRQ(x)          (((uint32_t)(((uint32_t)(x)) << GENFSK_IRQ_CTRL_PHRFFAIL_IRQ_SHIFT)) & GENFSK_IRQ_CTRL_PHRFFAIL_IRQ_MASK)

#define GENFSK_IRQ_CTRL_FILTERFAIL_IRQ_MASK      (0x2000U)
#define GENFSK_IRQ_CTRL_FILTERFAIL_IRQ_SHIFT     (13U)
/*! FILTERFAIL_IRQ - Received Frame Filter Fail Interrupt
 *  0b0..A Filter Fail Interrupt has not occurred.
 *  0b1..A Filter Fail Interrupt has occurred.
 */
#define GENFSK_IRQ_CTRL_FILTERFAIL_IRQ(x)        (((uint32_t)(((uint32_t)(x)) << GENFSK_IRQ_CTRL_FILTERFAIL_IRQ_SHIFT)) & GENFSK_IRQ_CTRL_FILTERFAIL_IRQ_MASK)

#define GENFSK_IRQ_CTRL_CCA_IRQ_MASK             (0x4000U)
#define GENFSK_IRQ_CTRL_CCA_IRQ_SHIFT            (14U)
/*! CCA_IRQ - CCA Interrupt
 *  0b0..A CCA Interrupt has not occurred
 *  0b1..A CCA Interrupt has occurred
 */
#define GENFSK_IRQ_CTRL_CCA_IRQ(x)               (((uint32_t)(((uint32_t)(x)) << GENFSK_IRQ_CTRL_CCA_IRQ_SHIFT)) & GENFSK_IRQ_CTRL_CCA_IRQ_MASK)

#define GENFSK_IRQ_CTRL_MS_IRQ_MASK              (0x8000U)
#define GENFSK_IRQ_CTRL_MS_IRQ_SHIFT             (15U)
/*! MS_IRQ - Mode Switch Interrupt
 *  0b0..A Mode Switch frame is not received
 *  0b1..A Mode Switch frame is received
 */
#define GENFSK_IRQ_CTRL_MS_IRQ(x)                (((uint32_t)(((uint32_t)(x)) << GENFSK_IRQ_CTRL_MS_IRQ_SHIFT)) & GENFSK_IRQ_CTRL_MS_IRQ_MASK)

#define GENFSK_IRQ_CTRL_SEQ_END_IRQ_EN_MASK      (0x10000U)
#define GENFSK_IRQ_CTRL_SEQ_END_IRQ_EN_SHIFT     (16U)
/*! SEQ_END_IRQ_EN - SEQ_END_IRQ Enable
 *  0b0..Sequence End Interrupt is not enabled.
 *  0b1..Sequence End Interrupt is enabled.
 */
#define GENFSK_IRQ_CTRL_SEQ_END_IRQ_EN(x)        (((uint32_t)(((uint32_t)(x)) << GENFSK_IRQ_CTRL_SEQ_END_IRQ_EN_SHIFT)) & GENFSK_IRQ_CTRL_SEQ_END_IRQ_EN_MASK)

#define GENFSK_IRQ_CTRL_TX_IRQ_EN_MASK           (0x20000U)
#define GENFSK_IRQ_CTRL_TX_IRQ_EN_SHIFT          (17U)
/*! TX_IRQ_EN - TX_IRQ Enable
 *  0b0..TX Interrupt is not enabled.
 *  0b1..TX Interrupt is enabled.
 */
#define GENFSK_IRQ_CTRL_TX_IRQ_EN(x)             (((uint32_t)(((uint32_t)(x)) << GENFSK_IRQ_CTRL_TX_IRQ_EN_SHIFT)) & GENFSK_IRQ_CTRL_TX_IRQ_EN_MASK)

#define GENFSK_IRQ_CTRL_RX_IRQ_EN_MASK           (0x40000U)
#define GENFSK_IRQ_CTRL_RX_IRQ_EN_SHIFT          (18U)
/*! RX_IRQ_EN - RX_IRQ Enable
 *  0b0..RX Interrupt is not enabled.
 *  0b1..RX Interrupt is enabled.
 */
#define GENFSK_IRQ_CTRL_RX_IRQ_EN(x)             (((uint32_t)(((uint32_t)(x)) << GENFSK_IRQ_CTRL_RX_IRQ_EN_SHIFT)) & GENFSK_IRQ_CTRL_RX_IRQ_EN_MASK)

#define GENFSK_IRQ_CTRL_NTW_ADR_IRQ_EN_MASK      (0x80000U)
#define GENFSK_IRQ_CTRL_NTW_ADR_IRQ_EN_SHIFT     (19U)
/*! NTW_ADR_IRQ_EN - NTW_ADR_IRQ Enable
 *  0b0..Network Address Match Interrupt is not enabled.
 *  0b1..Network Address Match Interrupt is enabled.
 */
#define GENFSK_IRQ_CTRL_NTW_ADR_IRQ_EN(x)        (((uint32_t)(((uint32_t)(x)) << GENFSK_IRQ_CTRL_NTW_ADR_IRQ_EN_SHIFT)) & GENFSK_IRQ_CTRL_NTW_ADR_IRQ_EN_MASK)

#define GENFSK_IRQ_CTRL_T1_IRQ_EN_MASK           (0x100000U)
#define GENFSK_IRQ_CTRL_T1_IRQ_EN_SHIFT          (20U)
/*! T1_IRQ_EN - T1_IRQ Enable
 *  0b0..Timer1 (T1) Compare Interrupt is not enabled.
 *  0b1..Timer1 (T1) Compare Interrupt is enabled.
 */
#define GENFSK_IRQ_CTRL_T1_IRQ_EN(x)             (((uint32_t)(((uint32_t)(x)) << GENFSK_IRQ_CTRL_T1_IRQ_EN_SHIFT)) & GENFSK_IRQ_CTRL_T1_IRQ_EN_MASK)

#define GENFSK_IRQ_CTRL_T2_IRQ_EN_MASK           (0x200000U)
#define GENFSK_IRQ_CTRL_T2_IRQ_EN_SHIFT          (21U)
/*! T2_IRQ_EN - T2_IRQ Enable
 *  0b0..Timer1 (T2) Compare Interrupt is not enabled.
 *  0b1..Timer1 (T2) Compare Interrupt is enabled.
 */
#define GENFSK_IRQ_CTRL_T2_IRQ_EN(x)             (((uint32_t)(((uint32_t)(x)) << GENFSK_IRQ_CTRL_T2_IRQ_EN_SHIFT)) & GENFSK_IRQ_CTRL_T2_IRQ_EN_MASK)

#define GENFSK_IRQ_CTRL_PLL_UNLOCK_IRQ_EN_MASK   (0x400000U)
#define GENFSK_IRQ_CTRL_PLL_UNLOCK_IRQ_EN_SHIFT  (22U)
/*! PLL_UNLOCK_IRQ_EN - PLL_UNLOCK_IRQ Enable
 *  0b0..PLL Unlock Interrupt is not enabled.
 *  0b1..PLL Unlock Interrupt is enabled.
 */
#define GENFSK_IRQ_CTRL_PLL_UNLOCK_IRQ_EN(x)     (((uint32_t)(((uint32_t)(x)) << GENFSK_IRQ_CTRL_PLL_UNLOCK_IRQ_EN_SHIFT)) & GENFSK_IRQ_CTRL_PLL_UNLOCK_IRQ_EN_MASK)

#define GENFSK_IRQ_CTRL_WAKE_IRQ_EN_MASK         (0x800000U)
#define GENFSK_IRQ_CTRL_WAKE_IRQ_EN_SHIFT        (23U)
/*! WAKE_IRQ_EN - WAKE_IRQ Enable
 *  0b0..Wake Interrupt is not enabled.
 *  0b1..Wake Interrupt is enabled.
 */
#define GENFSK_IRQ_CTRL_WAKE_IRQ_EN(x)           (((uint32_t)(((uint32_t)(x)) << GENFSK_IRQ_CTRL_WAKE_IRQ_EN_SHIFT)) & GENFSK_IRQ_CTRL_WAKE_IRQ_EN_MASK)

#define GENFSK_IRQ_CTRL_RX_WATERMARK_IRQ_EN_MASK (0x1000000U)
#define GENFSK_IRQ_CTRL_RX_WATERMARK_IRQ_EN_SHIFT (24U)
/*! RX_WATERMARK_IRQ_EN - RX_WATERMARK_IRQ Enable
 *  0b0..RX Watermark Interrupt is not enabled.
 *  0b1..RX Watermark Interrupt is enabled.
 */
#define GENFSK_IRQ_CTRL_RX_WATERMARK_IRQ_EN(x)   (((uint32_t)(((uint32_t)(x)) << GENFSK_IRQ_CTRL_RX_WATERMARK_IRQ_EN_SHIFT)) & GENFSK_IRQ_CTRL_RX_WATERMARK_IRQ_EN_MASK)

#define GENFSK_IRQ_CTRL_TSM_IRQ_EN_MASK          (0x2000000U)
#define GENFSK_IRQ_CTRL_TSM_IRQ_EN_SHIFT         (25U)
/*! TSM_IRQ_EN - TSM_IRQ Enable
 *  0b0..TSM Interrupt is not enabled.
 *  0b1..TSM Interrupt is enabled.
 */
#define GENFSK_IRQ_CTRL_TSM_IRQ_EN(x)            (((uint32_t)(((uint32_t)(x)) << GENFSK_IRQ_CTRL_TSM_IRQ_EN_SHIFT)) & GENFSK_IRQ_CTRL_TSM_IRQ_EN_MASK)

#define GENFSK_IRQ_CTRL_GENERIC_FSK_IRQ_EN_MASK  (0x4000000U)
#define GENFSK_IRQ_CTRL_GENERIC_FSK_IRQ_EN_SHIFT (26U)
/*! GENERIC_FSK_IRQ_EN - GENERIC_FSK_IRQ Master Enable
 *  0b0..All GENERIC_FSK Interrupts are disabled.
 *  0b1..All GENERIC_FSK Interrupts can be enabled.
 */
#define GENFSK_IRQ_CTRL_GENERIC_FSK_IRQ_EN(x)    (((uint32_t)(((uint32_t)(x)) << GENFSK_IRQ_CTRL_GENERIC_FSK_IRQ_EN_SHIFT)) & GENFSK_IRQ_CTRL_GENERIC_FSK_IRQ_EN_MASK)

#define GENFSK_IRQ_CTRL_ACK_IRQ_EN_MASK          (0x8000000U)
#define GENFSK_IRQ_CTRL_ACK_IRQ_EN_SHIFT         (27U)
/*! ACK_IRQ_EN - ACK_IRQ Enable
 *  0b0..Auto ACK Interrupt is not enabled.
 *  0b1..Auto ACK Interrupt is enabled.
 */
#define GENFSK_IRQ_CTRL_ACK_IRQ_EN(x)            (((uint32_t)(((uint32_t)(x)) << GENFSK_IRQ_CTRL_ACK_IRQ_EN_SHIFT)) & GENFSK_IRQ_CTRL_ACK_IRQ_EN_MASK)

#define GENFSK_IRQ_CTRL_PHRFAIL_IRQ_EN_MASK      (0x10000000U)
#define GENFSK_IRQ_CTRL_PHRFAIL_IRQ_EN_SHIFT     (28U)
/*! PHRFAIL_IRQ_EN - PHRFAIL_IRQ Enable
 *  0b0..PHRFAIL Interrupt is not enabled.
 *  0b1..PHRFAIL Interrupt is enabled.
 */
#define GENFSK_IRQ_CTRL_PHRFAIL_IRQ_EN(x)        (((uint32_t)(((uint32_t)(x)) << GENFSK_IRQ_CTRL_PHRFAIL_IRQ_EN_SHIFT)) & GENFSK_IRQ_CTRL_PHRFAIL_IRQ_EN_MASK)

#define GENFSK_IRQ_CTRL_FILTERFAIL_IRQ_EN_MASK   (0x20000000U)
#define GENFSK_IRQ_CTRL_FILTERFAIL_IRQ_EN_SHIFT  (29U)
/*! FILTERFAIL_IRQ_EN - FILTERFAIL_IRQ Enable
 *  0b0..FILTERFAIL Interrupt is not enabled.
 *  0b1..FILTERFAIL Interrupt is enabled.
 */
#define GENFSK_IRQ_CTRL_FILTERFAIL_IRQ_EN(x)     (((uint32_t)(((uint32_t)(x)) << GENFSK_IRQ_CTRL_FILTERFAIL_IRQ_EN_SHIFT)) & GENFSK_IRQ_CTRL_FILTERFAIL_IRQ_EN_MASK)

#define GENFSK_IRQ_CTRL_CCA_IRQ_EN_MASK          (0x40000000U)
#define GENFSK_IRQ_CTRL_CCA_IRQ_EN_SHIFT         (30U)
/*! CCA_IRQ_EN - CCA_IRQ Enable
 *  0b0..CCA Interrupt is not enabled.
 *  0b1..CCA Interrupt is enabled.
 */
#define GENFSK_IRQ_CTRL_CCA_IRQ_EN(x)            (((uint32_t)(((uint32_t)(x)) << GENFSK_IRQ_CTRL_CCA_IRQ_EN_SHIFT)) & GENFSK_IRQ_CTRL_CCA_IRQ_EN_MASK)

#define GENFSK_IRQ_CTRL_MS_IRQ_EN_MASK           (0x80000000U)
#define GENFSK_IRQ_CTRL_MS_IRQ_EN_SHIFT          (31U)
/*! MS_IRQ_EN - MS_IRQ Enable
 *  0b0..MS Interrupt is not enabled.
 *  0b1..MS Interrupt is enabled.
 */
#define GENFSK_IRQ_CTRL_MS_IRQ_EN(x)             (((uint32_t)(((uint32_t)(x)) << GENFSK_IRQ_CTRL_MS_IRQ_EN_SHIFT)) & GENFSK_IRQ_CTRL_MS_IRQ_EN_MASK)
/*! @} */

/*! @name EVENT_TMR - EVENT TIMER */
/*! @{ */

#define GENFSK_EVENT_TMR_EVENT_TMR_MASK          (0xFFFFFFFFU)
#define GENFSK_EVENT_TMR_EVENT_TMR_SHIFT         (0U)
/*! EVENT_TMR - Event Timer
 */
#define GENFSK_EVENT_TMR_EVENT_TMR(x)            (((uint32_t)(((uint32_t)(x)) << GENFSK_EVENT_TMR_EVENT_TMR_SHIFT)) & GENFSK_EVENT_TMR_EVENT_TMR_MASK)
/*! @} */

/*! @name T1_CMP - T1 COMPARE */
/*! @{ */

#define GENFSK_T1_CMP_T1_CMP_MASK                (0xFFFFFFFFU)
#define GENFSK_T1_CMP_T1_CMP_SHIFT               (0U)
/*! T1_CMP - Timer1 (T1) Compare Value
 */
#define GENFSK_T1_CMP_T1_CMP(x)                  (((uint32_t)(((uint32_t)(x)) << GENFSK_T1_CMP_T1_CMP_SHIFT)) & GENFSK_T1_CMP_T1_CMP_MASK)
/*! @} */

/*! @name T2_CMP - T2 COMPARE */
/*! @{ */

#define GENFSK_T2_CMP_T2_CMP_MASK                (0xFFFFFFFFU)
#define GENFSK_T2_CMP_T2_CMP_SHIFT               (0U)
/*! T2_CMP - Timer2 (T2) Compare Value
 */
#define GENFSK_T2_CMP_T2_CMP(x)                  (((uint32_t)(((uint32_t)(x)) << GENFSK_T2_CMP_T2_CMP_SHIFT)) & GENFSK_T2_CMP_T2_CMP_MASK)
/*! @} */

/*! @name TIMESTAMP - TIMESTAMP */
/*! @{ */

#define GENFSK_TIMESTAMP_TIMESTAMP_MASK          (0xFFFFFFFFU)
#define GENFSK_TIMESTAMP_TIMESTAMP_SHIFT         (0U)
/*! TIMESTAMP - Received Packet Timestamp
 */
#define GENFSK_TIMESTAMP_TIMESTAMP(x)            (((uint32_t)(((uint32_t)(x)) << GENFSK_TIMESTAMP_TIMESTAMP_SHIFT)) & GENFSK_TIMESTAMP_TIMESTAMP_MASK)
/*! @} */

/*! @name XCVR_CTRL - TRANSCEIVER CONTROL */
/*! @{ */

#define GENFSK_XCVR_CTRL_SEQCMD_MASK             (0x1FU)
#define GENFSK_XCVR_CTRL_SEQCMD_SHIFT            (0U)
/*! SEQCMD - Sequence Commands, also named as "XCVSEQ(Transceiver Sequence)"
 *  0b00000..Same as command ABORT
 *  0b00001..TX Start Now
 *  0b00010..TX Start @ T1 Timer Compare Match (EVENT_TMR = T1_CMP)
 *  0b00011..TX Start @ T2 Timer Compare Match (EVENT_TMR = T2_CMP)
 *  0b00100..TX Cancel -- Cancels pending TX events but do not abort a TX-in-progress
 *  0b00101..RX Start Now
 *  0b00110..RX Start @ T1 Timer Compare Match (EVENT_TMR = T1_CMP)
 *  0b00111..RX Start @ T2 Timer Compare Match (EVENT_TMR = T2_CMP)
 *  0b01000..RX Stop @ T1 Timer Compare Match (EVENT_TMR = T1_CMP)
 *  0b01001..RX Stop @ T2 Timer Compare Match (EVENT_TMR = T2_CMP)
 *  0b01010..RX Cancel -- Cancels pending RX events but do not abort a RX-in-progress
 *  0b01011..Abort All - Cancels all pending events and abort any sequence-in-progress
 *  0b01100..TR Start Now
 *  0b01101..TR Start @ T1 Timer Compare Match (EVENT_TMR = T1_CMP)
 *  0b01110..TR Start @ T2 Timer Compare Match (EVENT_TMR = T2_CMP)
 *  0b01111..TR Cancel -- Cancels pending TR events but do not abort a TR-in-progress
 *  0b10000..CCA Start Now
 *  0b10001..CCA Start @ T1 Timer Compare Match (EVENT_TMR = T1_CMP)
 *  0b10010..CCA Start @ T2 Timer Compare Match (EVENT_TMR = T2_CMP)
 *  0b10011..CCA Cancel -- Cancels pending CCA events but do not abort a CCA-in-progress
 */
#define GENFSK_XCVR_CTRL_SEQCMD(x)               (((uint32_t)(((uint32_t)(x)) << GENFSK_XCVR_CTRL_SEQCMD_SHIFT)) & GENFSK_XCVR_CTRL_SEQCMD_MASK)

#define GENFSK_XCVR_CTRL_LENGTH_EXT_MASK         (0x7FF00U)
#define GENFSK_XCVR_CTRL_LENGTH_EXT_SHIFT        (8U)
/*! LENGTH_EXT - Extracted Length Field
 */
#define GENFSK_XCVR_CTRL_LENGTH_EXT(x)           (((uint32_t)(((uint32_t)(x)) << GENFSK_XCVR_CTRL_LENGTH_EXT_SHIFT)) & GENFSK_XCVR_CTRL_LENGTH_EXT_MASK)

#define GENFSK_XCVR_CTRL_CMDDEC_CS_MASK          (0x1F000000U)
#define GENFSK_XCVR_CTRL_CMDDEC_CS_SHIFT         (24U)
/*! CMDDEC_CS - Command Decode
 */
#define GENFSK_XCVR_CTRL_CMDDEC_CS(x)            (((uint32_t)(((uint32_t)(x)) << GENFSK_XCVR_CTRL_CMDDEC_CS_SHIFT)) & GENFSK_XCVR_CTRL_CMDDEC_CS_MASK)

#define GENFSK_XCVR_CTRL_XCVR_BUSY_MASK          (0x80000000U)
#define GENFSK_XCVR_CTRL_XCVR_BUSY_SHIFT         (31U)
/*! XCVR_BUSY - Transceiver Busy
 *  0b0..IDLE
 *  0b1..BUSY
 */
#define GENFSK_XCVR_CTRL_XCVR_BUSY(x)            (((uint32_t)(((uint32_t)(x)) << GENFSK_XCVR_CTRL_XCVR_BUSY_SHIFT)) & GENFSK_XCVR_CTRL_XCVR_BUSY_MASK)
/*! @} */

/*! @name XCVR_STS - TRANSCEIVER STATUS */
/*! @{ */

#define GENFSK_XCVR_STS_LQI_MASK                 (0xFFU)
#define GENFSK_XCVR_STS_LQI_SHIFT                (0U)
/*! LQI - Link Quality Indicator
 */
#define GENFSK_XCVR_STS_LQI(x)                   (((uint32_t)(((uint32_t)(x)) << GENFSK_XCVR_STS_LQI_SHIFT)) & GENFSK_XCVR_STS_LQI_MASK)

#define GENFSK_XCVR_STS_LQI_VALID_MASK           (0x8000U)
#define GENFSK_XCVR_STS_LQI_VALID_SHIFT          (15U)
/*! LQI_VALID - LQI Valid Indicator
 *  0b0..LQI is not yet valid for RX packet.
 *  0b1..LQI is valid for RX packet.
 */
#define GENFSK_XCVR_STS_LQI_VALID(x)             (((uint32_t)(((uint32_t)(x)) << GENFSK_XCVR_STS_LQI_VALID_SHIFT)) & GENFSK_XCVR_STS_LQI_VALID_MASK)

#define GENFSK_XCVR_STS_RSSI_MASK                (0xFF0000U)
#define GENFSK_XCVR_STS_RSSI_SHIFT               (16U)
/*! RSSI - RSSI Value
 */
#define GENFSK_XCVR_STS_RSSI(x)                  (((uint32_t)(((uint32_t)(x)) << GENFSK_XCVR_STS_RSSI_SHIFT)) & GENFSK_XCVR_STS_RSSI_MASK)
/*! @} */

/*! @name XCVR_CFG - TRANSCEIVER CONFIGURATION */
/*! @{ */

#define GENFSK_XCVR_CFG_TX_WHITEN_DIS_MASK       (0x1U)
#define GENFSK_XCVR_CFG_TX_WHITEN_DIS_SHIFT      (0U)
/*! TX_WHITEN_DIS - TX Whitening Disable
 */
#define GENFSK_XCVR_CFG_TX_WHITEN_DIS(x)         (((uint32_t)(((uint32_t)(x)) << GENFSK_XCVR_CFG_TX_WHITEN_DIS_SHIFT)) & GENFSK_XCVR_CFG_TX_WHITEN_DIS_MASK)

#define GENFSK_XCVR_CFG_RX_DEWHITEN_DIS_MASK     (0x2U)
#define GENFSK_XCVR_CFG_RX_DEWHITEN_DIS_SHIFT    (1U)
/*! RX_DEWHITEN_DIS - RX De-Whitening Disable
 */
#define GENFSK_XCVR_CFG_RX_DEWHITEN_DIS(x)       (((uint32_t)(((uint32_t)(x)) << GENFSK_XCVR_CFG_RX_DEWHITEN_DIS_SHIFT)) & GENFSK_XCVR_CFG_RX_DEWHITEN_DIS_MASK)

#define GENFSK_XCVR_CFG_SW_CRC_EN_MASK           (0x4U)
#define GENFSK_XCVR_CFG_SW_CRC_EN_SHIFT          (2U)
/*! SW_CRC_EN - Software CRC Enable
 */
#define GENFSK_XCVR_CFG_SW_CRC_EN(x)             (((uint32_t)(((uint32_t)(x)) << GENFSK_XCVR_CFG_SW_CRC_EN_SHIFT)) & GENFSK_XCVR_CFG_SW_CRC_EN_MASK)

#define GENFSK_XCVR_CFG_STOP_POSTPONE_ON_AA_MASK (0x8U)
#define GENFSK_XCVR_CFG_STOP_POSTPONE_ON_AA_SHIFT (3U)
/*! STOP_POSTPONE_ON_AA - Postpone Stop Command Timeout On Access Address Match Enable
 *  0b0..STOP Abort will occur on RX_STOP_T1 or RX_STOP_T1 Event Timer match, regardless of NTW_ADR_MCH
 *  0b1..STOP Abort will be deferred on RX_STOP_T1 or RX_STOP_T1 Event Timer match, if NTW_ADR_MCH is asserted;
 *       otherwise the RX_STOP Abort will occur immediately
 */
#define GENFSK_XCVR_CFG_STOP_POSTPONE_ON_AA(x)   (((uint32_t)(((uint32_t)(x)) << GENFSK_XCVR_CFG_STOP_POSTPONE_ON_AA_SHIFT)) & GENFSK_XCVR_CFG_STOP_POSTPONE_ON_AA_MASK)

#define GENFSK_XCVR_CFG_PREAMBLE_SZ_MASK         (0x1FF0U)
#define GENFSK_XCVR_CFG_PREAMBLE_SZ_SHIFT        (4U)
/*! PREAMBLE_SZ - Preamble Size
 */
#define GENFSK_XCVR_CFG_PREAMBLE_SZ(x)           (((uint32_t)(((uint32_t)(x)) << GENFSK_XCVR_CFG_PREAMBLE_SZ_SHIFT)) & GENFSK_XCVR_CFG_PREAMBLE_SZ_MASK)

#define GENFSK_XCVR_CFG_GEN_PREAMBLE_MASK        (0xFF0000U)
#define GENFSK_XCVR_CFG_GEN_PREAMBLE_SHIFT       (16U)
/*! GEN_PREAMBLE - Preamble pattern
 */
#define GENFSK_XCVR_CFG_GEN_PREAMBLE(x)          (((uint32_t)(((uint32_t)(x)) << GENFSK_XCVR_CFG_GEN_PREAMBLE_SHIFT)) & GENFSK_XCVR_CFG_GEN_PREAMBLE_MASK)

#define GENFSK_XCVR_CFG_PREAMBLE_SEL_MASK        (0x7000000U)
#define GENFSK_XCVR_CFG_PREAMBLE_SEL_SHIFT       (24U)
/*! PREAMBLE_SEL - Preamble Select
 *  0b000..The controller hardware selects the preamble pattern based on the first transmitted bit of Network
 *         Address, such that the last bit of preamble is the opposite polarity from the first bit of Network Address,
 *         forcing a bit transition at this boundary.
 *  0b001..Preamble is programmed by register GEN_PREAMBLE[7:0]
 *  0b010..Preamble is 0b01
 *  0b011..Preamble is 0b10
 */
#define GENFSK_XCVR_CFG_PREAMBLE_SEL(x)          (((uint32_t)(((uint32_t)(x)) << GENFSK_XCVR_CFG_PREAMBLE_SEL_SHIFT)) & GENFSK_XCVR_CFG_PREAMBLE_SEL_MASK)

#define GENFSK_XCVR_CFG_T1_CMP_EN_MASK           (0x40000000U)
#define GENFSK_XCVR_CFG_T1_CMP_EN_SHIFT          (30U)
/*! T1_CMP_EN - Timer1 (T1) Compare Enable
 */
#define GENFSK_XCVR_CFG_T1_CMP_EN(x)             (((uint32_t)(((uint32_t)(x)) << GENFSK_XCVR_CFG_T1_CMP_EN_SHIFT)) & GENFSK_XCVR_CFG_T1_CMP_EN_MASK)

#define GENFSK_XCVR_CFG_T2_CMP_EN_MASK           (0x80000000U)
#define GENFSK_XCVR_CFG_T2_CMP_EN_SHIFT          (31U)
/*! T2_CMP_EN - Timer2 (T2) Compare Enable
 */
#define GENFSK_XCVR_CFG_T2_CMP_EN(x)             (((uint32_t)(((uint32_t)(x)) << GENFSK_XCVR_CFG_T2_CMP_EN_SHIFT)) & GENFSK_XCVR_CFG_T2_CMP_EN_MASK)
/*! @} */

/*! @name CHANNEL_NUM0 - CHANNEL NUMBER 0 */
/*! @{ */

#define GENFSK_CHANNEL_NUM0_CHANNEL_NUM0_MASK    (0x7FU)
#define GENFSK_CHANNEL_NUM0_CHANNEL_NUM0_SHIFT   (0U)
/*! CHANNEL_NUM0 - Channel Number for PAN0
 */
#define GENFSK_CHANNEL_NUM0_CHANNEL_NUM0(x)      (((uint32_t)(((uint32_t)(x)) << GENFSK_CHANNEL_NUM0_CHANNEL_NUM0_SHIFT)) & GENFSK_CHANNEL_NUM0_CHANNEL_NUM0_MASK)
/*! @} */

/*! @name TX_POWER - TRANSMIT POWER */
/*! @{ */

#define GENFSK_TX_POWER_TX_POWER_MASK            (0x3FU)
#define GENFSK_TX_POWER_TX_POWER_SHIFT           (0U)
/*! TX_POWER - Transmit Power
 */
#define GENFSK_TX_POWER_TX_POWER(x)              (((uint32_t)(((uint32_t)(x)) << GENFSK_TX_POWER_TX_POWER_SHIFT)) & GENFSK_TX_POWER_TX_POWER_MASK)
/*! @} */

/*! @name NTW_ADR_CTRL - NETWORK ADDRESS CONTROL */
/*! @{ */

#define GENFSK_NTW_ADR_CTRL_NTW_ADR_EN_MASK      (0xFU)
#define GENFSK_NTW_ADR_CTRL_NTW_ADR_EN_SHIFT     (0U)
/*! NTW_ADR_EN - Network Address Enable
 *  0b0001..Enable Network Address 0 for correlation
 *  0b0010..Enable Network Address 1 for correlation
 *  0b0100..Enable Network Address 2 for correlation
 *  0b1000..Enable Network Address 3 for correlation
 */
#define GENFSK_NTW_ADR_CTRL_NTW_ADR_EN(x)        (((uint32_t)(((uint32_t)(x)) << GENFSK_NTW_ADR_CTRL_NTW_ADR_EN_SHIFT)) & GENFSK_NTW_ADR_CTRL_NTW_ADR_EN_MASK)

#define GENFSK_NTW_ADR_CTRL_NTW_ADR_MCH_MASK     (0xF0U)
#define GENFSK_NTW_ADR_CTRL_NTW_ADR_MCH_SHIFT    (4U)
/*! NTW_ADR_MCH - Network Address Match
 *  0b0001..Network Address 0 has matched
 *  0b0010..Network Address 1 has matched
 *  0b0100..Network Address 2 has matched
 *  0b1000..Network Address 3 has matched
 */
#define GENFSK_NTW_ADR_CTRL_NTW_ADR_MCH(x)       (((uint32_t)(((uint32_t)(x)) << GENFSK_NTW_ADR_CTRL_NTW_ADR_MCH_SHIFT)) & GENFSK_NTW_ADR_CTRL_NTW_ADR_MCH_MASK)

#define GENFSK_NTW_ADR_CTRL_NTW_ADR_SZ_MASK      (0x300U)
#define GENFSK_NTW_ADR_CTRL_NTW_ADR_SZ_SHIFT     (8U)
/*! NTW_ADR_SZ - Network Address Size
 *  0b00..Network Address 0/1/2/3 requires a 8-bit correlation
 *  0b01..Network Address 0/1/2/3 requires a 16-bit correlation
 *  0b10..Network Address 0/1/2/3 requires a 24-bit correlation
 *  0b11..Network Address 0/1/2/3 requires a 32-bit correlation
 */
#define GENFSK_NTW_ADR_CTRL_NTW_ADR_SZ(x)        (((uint32_t)(((uint32_t)(x)) << GENFSK_NTW_ADR_CTRL_NTW_ADR_SZ_SHIFT)) & GENFSK_NTW_ADR_CTRL_NTW_ADR_SZ_MASK)

#define GENFSK_NTW_ADR_CTRL_NTW_ADR_THR_MASK     (0x70000U)
#define GENFSK_NTW_ADR_CTRL_NTW_ADR_THR_SHIFT    (16U)
/*! NTW_ADR_THR - Network Address Threshold
 */
#define GENFSK_NTW_ADR_CTRL_NTW_ADR_THR(x)       (((uint32_t)(((uint32_t)(x)) << GENFSK_NTW_ADR_CTRL_NTW_ADR_THR_SHIFT)) & GENFSK_NTW_ADR_CTRL_NTW_ADR_THR_MASK)
/*! @} */

/*! @name NTW_ADR_0 - NETWORK ADDRESS 0 */
/*! @{ */

#define GENFSK_NTW_ADR_0_NTW_ADR_0_MASK          (0xFFFFFFFFU)
#define GENFSK_NTW_ADR_0_NTW_ADR_0_SHIFT         (0U)
/*! NTW_ADR_0 - Network Address 0
 */
#define GENFSK_NTW_ADR_0_NTW_ADR_0(x)            (((uint32_t)(((uint32_t)(x)) << GENFSK_NTW_ADR_0_NTW_ADR_0_SHIFT)) & GENFSK_NTW_ADR_0_NTW_ADR_0_MASK)
/*! @} */

/*! @name NTW_ADR_1 - NETWORK ADDRESS 1 */
/*! @{ */

#define GENFSK_NTW_ADR_1_NTW_ADR_1_MASK          (0xFFFFFFFFU)
#define GENFSK_NTW_ADR_1_NTW_ADR_1_SHIFT         (0U)
/*! NTW_ADR_1 - Network Address 1
 */
#define GENFSK_NTW_ADR_1_NTW_ADR_1(x)            (((uint32_t)(((uint32_t)(x)) << GENFSK_NTW_ADR_1_NTW_ADR_1_SHIFT)) & GENFSK_NTW_ADR_1_NTW_ADR_1_MASK)
/*! @} */

/*! @name NTW_ADR_2 - NETWORK ADDRESS 2 */
/*! @{ */

#define GENFSK_NTW_ADR_2_NTW_ADR_2_MASK          (0xFFFFFFFFU)
#define GENFSK_NTW_ADR_2_NTW_ADR_2_SHIFT         (0U)
/*! NTW_ADR_2 - Network Address 2
 */
#define GENFSK_NTW_ADR_2_NTW_ADR_2(x)            (((uint32_t)(((uint32_t)(x)) << GENFSK_NTW_ADR_2_NTW_ADR_2_SHIFT)) & GENFSK_NTW_ADR_2_NTW_ADR_2_MASK)
/*! @} */

/*! @name NTW_ADR_3 - NETWORK ADDRESS 3 */
/*! @{ */

#define GENFSK_NTW_ADR_3_NTW_ADR_3_MASK          (0xFFFFFFFFU)
#define GENFSK_NTW_ADR_3_NTW_ADR_3_SHIFT         (0U)
/*! NTW_ADR_3 - Network Address 2
 */
#define GENFSK_NTW_ADR_3_NTW_ADR_3(x)            (((uint32_t)(((uint32_t)(x)) << GENFSK_NTW_ADR_3_NTW_ADR_3_SHIFT)) & GENFSK_NTW_ADR_3_NTW_ADR_3_MASK)
/*! @} */

/*! @name RX_WATERMARK - RECEIVE WATERMARK */
/*! @{ */

#define GENFSK_RX_WATERMARK_RX_WATERMARK_MASK    (0x1FFFU)
#define GENFSK_RX_WATERMARK_RX_WATERMARK_SHIFT   (0U)
/*! RX_WATERMARK - Receive Watermark
 */
#define GENFSK_RX_WATERMARK_RX_WATERMARK(x)      (((uint32_t)(((uint32_t)(x)) << GENFSK_RX_WATERMARK_RX_WATERMARK_SHIFT)) & GENFSK_RX_WATERMARK_RX_WATERMARK_MASK)

#define GENFSK_RX_WATERMARK_BYTE_COUNTER_MASK    (0x1FFF0000U)
#define GENFSK_RX_WATERMARK_BYTE_COUNTER_SHIFT   (16U)
/*! BYTE_COUNTER - Byte Counter
 */
#define GENFSK_RX_WATERMARK_BYTE_COUNTER(x)      (((uint32_t)(((uint32_t)(x)) << GENFSK_RX_WATERMARK_BYTE_COUNTER_SHIFT)) & GENFSK_RX_WATERMARK_BYTE_COUNTER_MASK)
/*! @} */

/*! @name DSM_CTRL - DSM CONTROL */
/*! @{ */

#define GENFSK_DSM_CTRL_GEN_SLEEP_REQUEST_MASK   (0x1U)
#define GENFSK_DSM_CTRL_GEN_SLEEP_REQUEST_SHIFT  (0U)
/*! GEN_SLEEP_REQUEST - GENERIC_FSK Deep Sleep Mode Request
 */
#define GENFSK_DSM_CTRL_GEN_SLEEP_REQUEST(x)     (((uint32_t)(((uint32_t)(x)) << GENFSK_DSM_CTRL_GEN_SLEEP_REQUEST_SHIFT)) & GENFSK_DSM_CTRL_GEN_SLEEP_REQUEST_MASK)
/*! @} */

/*! @name PART_ID - PART ID */
/*! @{ */

#define GENFSK_PART_ID_PART_ID_MASK              (0xFFU)
#define GENFSK_PART_ID_PART_ID_SHIFT             (0U)
/*! PART_ID - Part ID
 */
#define GENFSK_PART_ID_PART_ID(x)                (((uint32_t)(((uint32_t)(x)) << GENFSK_PART_ID_PART_ID_SHIFT)) & GENFSK_PART_ID_PART_ID_MASK)
/*! @} */

/*! @name SLOT_PRELOAD - SLOT PRELOAD */
/*! @{ */

#define GENFSK_SLOT_PRELOAD_SLOT_PRELOAD_MASK    (0xFFFFU)
#define GENFSK_SLOT_PRELOAD_SLOT_PRELOAD_SHIFT   (0U)
/*! SLOT_PRELOAD - Slotted Mode Preload
 */
#define GENFSK_SLOT_PRELOAD_SLOT_PRELOAD(x)      (((uint32_t)(((uint32_t)(x)) << GENFSK_SLOT_PRELOAD_SLOT_PRELOAD_SHIFT)) & GENFSK_SLOT_PRELOAD_SLOT_PRELOAD_MASK)
/*! @} */

/*! @name SLOT_TIME - SLOT TIME */
/*! @{ */

#define GENFSK_SLOT_TIME_SLOT_TIME_MASK          (0xFFFFU)
#define GENFSK_SLOT_TIME_SLOT_TIME_SHIFT         (0U)
/*! SLOT_TIME - Duration of the Backoff Slot
 */
#define GENFSK_SLOT_TIME_SLOT_TIME(x)            (((uint32_t)(((uint32_t)(x)) << GENFSK_SLOT_TIME_SLOT_TIME_SHIFT)) & GENFSK_SLOT_TIME_SLOT_TIME_MASK)
/*! @} */

/*! @name TURNAROUND_TIME - TURNAROUND TIME */
/*! @{ */

#define GENFSK_TURNAROUND_TIME_TURNAROUND_TIME_MASK (0xFFFFU)
#define GENFSK_TURNAROUND_TIME_TURNAROUND_TIME_SHIFT (0U)
/*! TURNAROUND_TIME - RX-to-TX or TX-to-RX turnaround time
 */
#define GENFSK_TURNAROUND_TIME_TURNAROUND_TIME(x) (((uint32_t)(((uint32_t)(x)) << GENFSK_TURNAROUND_TIME_TURNAROUND_TIME_SHIFT)) & GENFSK_TURNAROUND_TIME_TURNAROUND_TIME_MASK)
/*! @} */

/*! @name ACKDELAY - ACK DELAY */
/*! @{ */

#define GENFSK_ACKDELAY_ACKDELAY_MASK            (0x3FFU)
#define GENFSK_ACKDELAY_ACKDELAY_SHIFT           (0U)
/*! ACKDELAY - ACK Delay
 */
#define GENFSK_ACKDELAY_ACKDELAY(x)              (((uint32_t)(((uint32_t)(x)) << GENFSK_ACKDELAY_ACKDELAY_SHIFT)) & GENFSK_ACKDELAY_ACKDELAY_MASK)
/*! @} */

/*! @name RXDELAY - RX DELAY */
/*! @{ */

#define GENFSK_RXDELAY_RXDELAY_MASK              (0x3FFU)
#define GENFSK_RXDELAY_RXDELAY_SHIFT             (0U)
/*! RXDELAY - RX Delay
 */
#define GENFSK_RXDELAY_RXDELAY(x)                (((uint32_t)(((uint32_t)(x)) << GENFSK_RXDELAY_RXDELAY_SHIFT)) & GENFSK_RXDELAY_RXDELAY_MASK)
/*! @} */

/*! @name TXDELAY - TX DELAY */
/*! @{ */

#define GENFSK_TXDELAY_TXDELAY_MASK              (0x3FFU)
#define GENFSK_TXDELAY_TXDELAY_SHIFT             (0U)
/*! TXDELAY - TX Delay
 */
#define GENFSK_TXDELAY_TXDELAY(x)                (((uint32_t)(((uint32_t)(x)) << GENFSK_TXDELAY_TXDELAY_SHIFT)) & GENFSK_TXDELAY_TXDELAY_MASK)
/*! @} */

/*! @name PACKET_CFG - PACKET CONFIGURATION */
/*! @{ */

#define GENFSK_PACKET_CFG_LENGTH_SZ_MASK         (0x1FU)
#define GENFSK_PACKET_CFG_LENGTH_SZ_SHIFT        (0U)
/*! LENGTH_SZ - LENGTH Size
 */
#define GENFSK_PACKET_CFG_LENGTH_SZ(x)           (((uint32_t)(((uint32_t)(x)) << GENFSK_PACKET_CFG_LENGTH_SZ_SHIFT)) & GENFSK_PACKET_CFG_LENGTH_SZ_MASK)

#define GENFSK_PACKET_CFG_LENGTH_BIT_ORD_MASK    (0x20U)
#define GENFSK_PACKET_CFG_LENGTH_BIT_ORD_SHIFT   (5U)
/*! LENGTH_BIT_ORD - LENGTH Bit Order
 *  0b0..LS Bit First
 *  0b1..MS Bit First
 */
#define GENFSK_PACKET_CFG_LENGTH_BIT_ORD(x)      (((uint32_t)(((uint32_t)(x)) << GENFSK_PACKET_CFG_LENGTH_BIT_ORD_SHIFT)) & GENFSK_PACKET_CFG_LENGTH_BIT_ORD_MASK)

#define GENFSK_PACKET_CFG_SYNC_ADDR_SZ_MASK      (0xC0U)
#define GENFSK_PACKET_CFG_SYNC_ADDR_SZ_SHIFT     (6U)
/*! SYNC_ADDR_SZ - Sync Address Size
 */
#define GENFSK_PACKET_CFG_SYNC_ADDR_SZ(x)        (((uint32_t)(((uint32_t)(x)) << GENFSK_PACKET_CFG_SYNC_ADDR_SZ_SHIFT)) & GENFSK_PACKET_CFG_SYNC_ADDR_SZ_MASK)

#define GENFSK_PACKET_CFG_H0_SZ_MASK             (0x1F0000U)
#define GENFSK_PACKET_CFG_H0_SZ_SHIFT            (16U)
/*! H0_SZ - H0 Size
 */
#define GENFSK_PACKET_CFG_H0_SZ(x)               (((uint32_t)(((uint32_t)(x)) << GENFSK_PACKET_CFG_H0_SZ_SHIFT)) & GENFSK_PACKET_CFG_H0_SZ_MASK)

#define GENFSK_PACKET_CFG_AA_PLAYBACK_CNT_MASK   (0x400000U)
#define GENFSK_PACKET_CFG_AA_PLAYBACK_CNT_SHIFT  (22U)
/*! AA_PLAYBACK_CNT - AA PLAYBACK COUNT
 *  0b0..AA is not through CRC and not playback to Link layer.
 *  0b1..AA is through CRC and palyback to Link Layer.
 */
#define GENFSK_PACKET_CFG_AA_PLAYBACK_CNT(x)     (((uint32_t)(((uint32_t)(x)) << GENFSK_PACKET_CFG_AA_PLAYBACK_CNT_SHIFT)) & GENFSK_PACKET_CFG_AA_PLAYBACK_CNT_MASK)

#define GENFSK_PACKET_CFG_LL_FETCH_AA_MASK       (0x800000U)
#define GENFSK_PACKET_CFG_LL_FETCH_AA_SHIFT      (23U)
/*! LL_FETCH_AA - Link layer fetches AA from PHY
 *  0b0..Link layer does not fetch AA from PHY
 *  0b1..Link layer fetches AA from PHY when AA_PLAYBACK_CNT is 0
 */
#define GENFSK_PACKET_CFG_LL_FETCH_AA(x)         (((uint32_t)(((uint32_t)(x)) << GENFSK_PACKET_CFG_LL_FETCH_AA_SHIFT)) & GENFSK_PACKET_CFG_LL_FETCH_AA_MASK)

#define GENFSK_PACKET_CFG_H1_SZ_MASK             (0x1F000000U)
#define GENFSK_PACKET_CFG_H1_SZ_SHIFT            (24U)
/*! H1_SZ - H1 Size
 */
#define GENFSK_PACKET_CFG_H1_SZ(x)               (((uint32_t)(((uint32_t)(x)) << GENFSK_PACKET_CFG_H1_SZ_SHIFT)) & GENFSK_PACKET_CFG_H1_SZ_MASK)

#define GENFSK_PACKET_CFG_H1_FAIL_MASK           (0x20000000U)
#define GENFSK_PACKET_CFG_H1_FAIL_SHIFT          (29U)
/*! H1_FAIL - H1 Violated Status Bit
 */
#define GENFSK_PACKET_CFG_H1_FAIL(x)             (((uint32_t)(((uint32_t)(x)) << GENFSK_PACKET_CFG_H1_FAIL_SHIFT)) & GENFSK_PACKET_CFG_H1_FAIL_MASK)

#define GENFSK_PACKET_CFG_H0_FAIL_MASK           (0x40000000U)
#define GENFSK_PACKET_CFG_H0_FAIL_SHIFT          (30U)
/*! H0_FAIL - H0 Violated Status Bit
 */
#define GENFSK_PACKET_CFG_H0_FAIL(x)             (((uint32_t)(((uint32_t)(x)) << GENFSK_PACKET_CFG_H0_FAIL_SHIFT)) & GENFSK_PACKET_CFG_H0_FAIL_MASK)

#define GENFSK_PACKET_CFG_LENGTH_FAIL_MASK       (0x80000000U)
#define GENFSK_PACKET_CFG_LENGTH_FAIL_SHIFT      (31U)
/*! LENGTH_FAIL - Maximum Length Violated Status Bit
 */
#define GENFSK_PACKET_CFG_LENGTH_FAIL(x)         (((uint32_t)(((uint32_t)(x)) << GENFSK_PACKET_CFG_LENGTH_FAIL_SHIFT)) & GENFSK_PACKET_CFG_LENGTH_FAIL_MASK)
/*! @} */

/*! @name H0_CFG - H0 CONFIGURATION */
/*! @{ */

#define GENFSK_H0_CFG_H0_MATCH_MASK              (0xFFFFU)
#define GENFSK_H0_CFG_H0_MATCH_SHIFT             (0U)
/*! H0_MATCH - H0 Match Register
 */
#define GENFSK_H0_CFG_H0_MATCH(x)                (((uint32_t)(((uint32_t)(x)) << GENFSK_H0_CFG_H0_MATCH_SHIFT)) & GENFSK_H0_CFG_H0_MATCH_MASK)

#define GENFSK_H0_CFG_H0_MASK_MASK               (0xFFFF0000U)
#define GENFSK_H0_CFG_H0_MASK_SHIFT              (16U)
/*! H0_MASK - H0 Mask Register
 */
#define GENFSK_H0_CFG_H0_MASK(x)                 (((uint32_t)(((uint32_t)(x)) << GENFSK_H0_CFG_H0_MASK_SHIFT)) & GENFSK_H0_CFG_H0_MASK_MASK)
/*! @} */

/*! @name H1_CFG - H1 CONFIGURATION */
/*! @{ */

#define GENFSK_H1_CFG_H1_MATCH_MASK              (0xFFFFU)
#define GENFSK_H1_CFG_H1_MATCH_SHIFT             (0U)
/*! H1_MATCH - H1 Match Register
 */
#define GENFSK_H1_CFG_H1_MATCH(x)                (((uint32_t)(((uint32_t)(x)) << GENFSK_H1_CFG_H1_MATCH_SHIFT)) & GENFSK_H1_CFG_H1_MATCH_MASK)

#define GENFSK_H1_CFG_H1_MASK_MASK               (0xFFFF0000U)
#define GENFSK_H1_CFG_H1_MASK_SHIFT              (16U)
/*! H1_MASK - H1 Mask Register
 */
#define GENFSK_H1_CFG_H1_MASK(x)                 (((uint32_t)(((uint32_t)(x)) << GENFSK_H1_CFG_H1_MASK_SHIFT)) & GENFSK_H1_CFG_H1_MASK_MASK)
/*! @} */

/*! @name CRC_CFG - CRC CONFIGURATION */
/*! @{ */

#define GENFSK_CRC_CFG_CRC_IGNORE_MASK           (0x1000000U)
#define GENFSK_CRC_CFG_CRC_IGNORE_SHIFT          (24U)
/*! CRC_IGNORE - CRC Ignore
 *  0b0..RX_IRQ will not be asserted for a received packet which fails CRC verification.
 *  0b1..RX_IRQ will be asserted even for a received packet which fails CRC verification.
 */
#define GENFSK_CRC_CFG_CRC_IGNORE(x)             (((uint32_t)(((uint32_t)(x)) << GENFSK_CRC_CFG_CRC_IGNORE_SHIFT)) & GENFSK_CRC_CFG_CRC_IGNORE_MASK)

#define GENFSK_CRC_CFG_CRC_VALID_MASK            (0x10000000U)
#define GENFSK_CRC_CFG_CRC_VALID_SHIFT           (28U)
/*! CRC_VALID - CRC Valid
 *  0b0..CRC of RX packet is not valid.
 *  0b1..CRC of RX packet is valid.
 */
#define GENFSK_CRC_CFG_CRC_VALID(x)              (((uint32_t)(((uint32_t)(x)) << GENFSK_CRC_CFG_CRC_VALID_SHIFT)) & GENFSK_CRC_CFG_CRC_VALID_MASK)
/*! @} */

/*! @name LENGTH_ADJ - LENGTH ADJUSTMENT */
/*! @{ */

#define GENFSK_LENGTH_ADJ_LENGTH_ADJ_MASK        (0x7FFU)
#define GENFSK_LENGTH_ADJ_LENGTH_ADJ_SHIFT       (0U)
/*! LENGTH_ADJ - Length Adjustment
 */
#define GENFSK_LENGTH_ADJ_LENGTH_ADJ(x)          (((uint32_t)(((uint32_t)(x)) << GENFSK_LENGTH_ADJ_LENGTH_ADJ_SHIFT)) & GENFSK_LENGTH_ADJ_LENGTH_ADJ_MASK)
/*! @} */

/*! @name TIMESTAMP_RX_DONE - TIMESTAMP_RX_DONE */
/*! @{ */

#define GENFSK_TIMESTAMP_RX_DONE_TIMESTAMP_RX_DONE_MASK (0xFFFFFFFFU)
#define GENFSK_TIMESTAMP_RX_DONE_TIMESTAMP_RX_DONE_SHIFT (0U)
/*! TIMESTAMP_RX_DONE - Received Packet Timestamp. Captured at Rx done.
 */
#define GENFSK_TIMESTAMP_RX_DONE_TIMESTAMP_RX_DONE(x) (((uint32_t)(((uint32_t)(x)) << GENFSK_TIMESTAMP_RX_DONE_TIMESTAMP_RX_DONE_SHIFT)) & GENFSK_TIMESTAMP_RX_DONE_TIMESTAMP_RX_DONE_MASK)
/*! @} */

/*! @name TIMESTAMP_TX_DONE - TIMESTAMP_TX_DONE */
/*! @{ */

#define GENFSK_TIMESTAMP_TX_DONE_TIMESTAMP_TX_DONE_MASK (0xFFFFFFFFU)
#define GENFSK_TIMESTAMP_TX_DONE_TIMESTAMP_TX_DONE_SHIFT (0U)
/*! TIMESTAMP_TX_DONE - Received Packet Timestamp. Captured at Tx done.
 */
#define GENFSK_TIMESTAMP_TX_DONE_TIMESTAMP_TX_DONE(x) (((uint32_t)(((uint32_t)(x)) << GENFSK_TIMESTAMP_TX_DONE_TIMESTAMP_TX_DONE_SHIFT)) & GENFSK_TIMESTAMP_TX_DONE_TIMESTAMP_TX_DONE_MASK)
/*! @} */

/*! @name MULT_PKT_CTRL - MULT_PKT_CTRL */
/*! @{ */

#define GENFSK_MULT_PKT_CTRL_SEG_SZ_MASK         (0xFU)
#define GENFSK_MULT_PKT_CTRL_SEG_SZ_SHIFT        (0U)
/*! SEG_SZ - RAM Segment Size
 */
#define GENFSK_MULT_PKT_CTRL_SEG_SZ(x)           (((uint32_t)(((uint32_t)(x)) << GENFSK_MULT_PKT_CTRL_SEG_SZ_SHIFT)) & GENFSK_MULT_PKT_CTRL_SEG_SZ_MASK)

#define GENFSK_MULT_PKT_CTRL_PKT_INDEX_MASK      (0x7F00U)
#define GENFSK_MULT_PKT_CTRL_PKT_INDEX_SHIFT     (8U)
/*! PKT_INDEX - Packet Index
 */
#define GENFSK_MULT_PKT_CTRL_PKT_INDEX(x)        (((uint32_t)(((uint32_t)(x)) << GENFSK_MULT_PKT_CTRL_PKT_INDEX_SHIFT)) & GENFSK_MULT_PKT_CTRL_PKT_INDEX_MASK)

#define GENFSK_MULT_PKT_CTRL_SEG_BASE_ADDR_MASK  (0xFFF0000U)
#define GENFSK_MULT_PKT_CTRL_SEG_BASE_ADDR_SHIFT (16U)
/*! SEG_BASE_ADDR - Segment Offset Address
 */
#define GENFSK_MULT_PKT_CTRL_SEG_BASE_ADDR(x)    (((uint32_t)(((uint32_t)(x)) << GENFSK_MULT_PKT_CTRL_SEG_BASE_ADDR_SHIFT)) & GENFSK_MULT_PKT_CTRL_SEG_BASE_ADDR_MASK)

#define GENFSK_MULT_PKT_CTRL_RESET_PKT_IDX_MASK  (0x40000000U)
#define GENFSK_MULT_PKT_CTRL_RESET_PKT_IDX_SHIFT (30U)
/*! RESET_PKT_IDX - Reset the PKT_INDEX to zero
 */
#define GENFSK_MULT_PKT_CTRL_RESET_PKT_IDX(x)    (((uint32_t)(((uint32_t)(x)) << GENFSK_MULT_PKT_CTRL_RESET_PKT_IDX_SHIFT)) & GENFSK_MULT_PKT_CTRL_RESET_PKT_IDX_MASK)

#define GENFSK_MULT_PKT_CTRL_MULT_PKT_EN_MASK    (0x80000000U)
#define GENFSK_MULT_PKT_CTRL_MULT_PKT_EN_SHIFT   (31U)
/*! MULT_PKT_EN - Enable to send or receive multiple packets
 *  0b0..Send or receive multiple packets is not enabled.
 *  0b1..Send or receive multiple packets is enabled.
 */
#define GENFSK_MULT_PKT_CTRL_MULT_PKT_EN(x)      (((uint32_t)(((uint32_t)(x)) << GENFSK_MULT_PKT_CTRL_MULT_PKT_EN_SHIFT)) & GENFSK_MULT_PKT_CTRL_MULT_PKT_EN_MASK)
/*! @} */

/*! @name RPA_WL_STATUS - RPA AND WHITE LIST STATUS */
/*! @{ */

#define GENFSK_RPA_WL_STATUS_WL_MATCH_INDEX_MASK (0x3FU)
#define GENFSK_RPA_WL_STATUS_WL_MATCH_INDEX_SHIFT (0U)
/*! WL_MATCH_INDEX - The matched white list index of the identity address resolved(RPA is enabled)
 *    or peer address received(RPA is not enabled)
 */
#define GENFSK_RPA_WL_STATUS_WL_MATCH_INDEX(x)   (((uint32_t)(((uint32_t)(x)) << GENFSK_RPA_WL_STATUS_WL_MATCH_INDEX_SHIFT)) & GENFSK_RPA_WL_STATUS_WL_MATCH_INDEX_MASK)

#define GENFSK_RPA_WL_STATUS_PEER_RESOLVED_INDEX_MASK (0xF0000U)
#define GENFSK_RPA_WL_STATUS_PEER_RESOLVED_INDEX_SHIFT (16U)
/*! PEER_RESOLVED_INDEX - The matched RPA index of peer address
 */
#define GENFSK_RPA_WL_STATUS_PEER_RESOLVED_INDEX(x) (((uint32_t)(((uint32_t)(x)) << GENFSK_RPA_WL_STATUS_PEER_RESOLVED_INDEX_SHIFT)) & GENFSK_RPA_WL_STATUS_PEER_RESOLVED_INDEX_MASK)

#define GENFSK_RPA_WL_STATUS_LOCAL_RESOLVED_INDEX_MASK (0xF000000U)
#define GENFSK_RPA_WL_STATUS_LOCAL_RESOLVED_INDEX_SHIFT (24U)
/*! LOCAL_RESOLVED_INDEX - The matched RPA index of local address
 */
#define GENFSK_RPA_WL_STATUS_LOCAL_RESOLVED_INDEX(x) (((uint32_t)(((uint32_t)(x)) << GENFSK_RPA_WL_STATUS_LOCAL_RESOLVED_INDEX_SHIFT)) & GENFSK_RPA_WL_STATUS_LOCAL_RESOLVED_INDEX_MASK)

#define GENFSK_RPA_WL_STATUS_SEARCH_WL_MASK      (0x80000000U)
#define GENFSK_RPA_WL_STATUS_SEARCH_WL_SHIFT     (31U)
/*! SEARCH_WL - Search Identity Address in White List
 */
#define GENFSK_RPA_WL_STATUS_SEARCH_WL(x)        (((uint32_t)(((uint32_t)(x)) << GENFSK_RPA_WL_STATUS_SEARCH_WL_SHIFT)) & GENFSK_RPA_WL_STATUS_SEARCH_WL_MASK)
/*! @} */

/*! @name LENGTH_MAX - MAXIMUM LENGTH */
/*! @{ */

#define GENFSK_LENGTH_MAX_LENGTH_MAX_MASK        (0x7F0000U)
#define GENFSK_LENGTH_MAX_LENGTH_MAX_SHIFT       (16U)
/*! LENGTH_MAX - Maximum Length for Received Packets
 */
#define GENFSK_LENGTH_MAX_LENGTH_MAX(x)          (((uint32_t)(((uint32_t)(x)) << GENFSK_LENGTH_MAX_LENGTH_MAX_SHIFT)) & GENFSK_LENGTH_MAX_LENGTH_MAX_MASK)

#define GENFSK_LENGTH_MAX_REC_BAD_PKT_MASK       (0x800000U)
#define GENFSK_LENGTH_MAX_REC_BAD_PKT_SHIFT      (23U)
/*! REC_BAD_PKT - Receive Bad Packets
 *  0b0..packets which fail H0, H1, or LENGTH_MAX result in an automatic recycle after the header is received and parsed
 *  0b1..packets which fail H0, H1, or LENGTH_MAX are received in their entirety
 */
#define GENFSK_LENGTH_MAX_REC_BAD_PKT(x)         (((uint32_t)(((uint32_t)(x)) << GENFSK_LENGTH_MAX_REC_BAD_PKT_SHIFT)) & GENFSK_LENGTH_MAX_REC_BAD_PKT_MASK)
/*! @} */

/*! @name EVENT_TMR_LD - EVENT TIMER LOAD */
/*! @{ */

#define GENFSK_EVENT_TMR_LD_EVENT_TMR_LD_MASK    (0xFFFFFFFFU)
#define GENFSK_EVENT_TMR_LD_EVENT_TMR_LD_SHIFT   (0U)
/*! EVENT_TMR_LD - Event Timer Load
 */
#define GENFSK_EVENT_TMR_LD_EVENT_TMR_LD(x)      (((uint32_t)(((uint32_t)(x)) << GENFSK_EVENT_TMR_LD_EVENT_TMR_LD_SHIFT)) & GENFSK_EVENT_TMR_LD_EVENT_TMR_LD_MASK)
/*! @} */

/*! @name EVENT_TMR_ADD - EVENT TIMER ADD */
/*! @{ */

#define GENFSK_EVENT_TMR_ADD_EVENT_TMR_ADD_MASK  (0xFFFFFFFFU)
#define GENFSK_EVENT_TMR_ADD_EVENT_TMR_ADD_SHIFT (0U)
/*! EVENT_TMR_ADD - Event Timer Add
 */
#define GENFSK_EVENT_TMR_ADD_EVENT_TMR_ADD(x)    (((uint32_t)(((uint32_t)(x)) << GENFSK_EVENT_TMR_ADD_EVENT_TMR_ADD_SHIFT)) & GENFSK_EVENT_TMR_ADD_EVENT_TMR_ADD_MASK)
/*! @} */

/*! @name ENH_FEATURE - ENHANCED FEATURES */
/*! @{ */

#define GENFSK_ENH_FEATURE_GENLL_MODE_MASK       (0xFU)
#define GENFSK_ENH_FEATURE_GENLL_MODE_SHIFT      (0U)
/*! GENLL_MODE - Linklayer Mode Select
 *  0b0000..GLL Mode
 *  0b0001..PAN Mode
 *  0b0010..FAN Mode
 *  0b0011..Hybrid Dual PAN Mode
 *  0b0100..Reserved
 *  0b0101..Reserved
 *  0b0110..FCP Mode
 *  0b0111..Reserved
 *  0b1000..Reserved
 *  0b1001..Bluetooth LE Uncoded Mode
 *  0b1010..Bluetooth LE LR Mode
 *  0b1011..Bluetooth LE Concurrent Mode (RX configuration only; TX uses either Bluetooth LE UNCODED or Bluetooth LE LR configuration)
 *  0b1100..Reserved
 *  0b1101..Reserved
 *  0b1110..Reserved
 *  0b1111..GTM Mode
 */
#define GENFSK_ENH_FEATURE_GENLL_MODE(x)         (((uint32_t)(((uint32_t)(x)) << GENFSK_ENH_FEATURE_GENLL_MODE_SHIFT)) & GENFSK_ENH_FEATURE_GENLL_MODE_MASK)

#define GENFSK_ENH_FEATURE_SEL_RXIRQ_MASK        (0x20U)
#define GENFSK_ENH_FEATURE_SEL_RXIRQ_SHIFT       (5U)
/*! SEL_RXIRQ - Select the RX IRQ assert time
 *  0b0..RX_IRQ is asserted at the end of RX_PKT state.
 *  0b1..RX_IRQ is asserted at the end of RXEN_DLY state. This to be used for delaying RX_IRQ to accept TERM2 bits
 *       in Bluetooth LE-LR and CTE bits as needed.
 */
#define GENFSK_ENH_FEATURE_SEL_RXIRQ(x)          (((uint32_t)(((uint32_t)(x)) << GENFSK_ENH_FEATURE_SEL_RXIRQ_SHIFT)) & GENFSK_ENH_FEATURE_SEL_RXIRQ_MASK)

#define GENFSK_ENH_FEATURE_DATARATE_CONFIG_SEL_MASK (0x40U)
#define GENFSK_ENH_FEATURE_DATARATE_CONFIG_SEL_SHIFT (6U)
/*! DATARATE_CONFIG_SEL - Select the data rate configuration bank
 *  0b0..Select the data rate as per configuration bank 0
 *  0b1..Select the data rate as per configuration bank 1
 */
#define GENFSK_ENH_FEATURE_DATARATE_CONFIG_SEL(x) (((uint32_t)(((uint32_t)(x)) << GENFSK_ENH_FEATURE_DATARATE_CONFIG_SEL_SHIFT)) & GENFSK_ENH_FEATURE_DATARATE_CONFIG_SEL_MASK)

#define GENFSK_ENH_FEATURE_STAY_IN_RX_MASK       (0x80U)
#define GENFSK_ENH_FEATURE_STAY_IN_RX_SHIFT      (7U)
/*! STAY_IN_RX - Stay in receive
 *  0b0..Linklayer will warmdown after an RX_IRQ
 *  0b1..Linklayer will recycle and stay in receive even after an RX_IRQ.
 */
#define GENFSK_ENH_FEATURE_STAY_IN_RX(x)         (((uint32_t)(((uint32_t)(x)) << GENFSK_ENH_FEATURE_STAY_IN_RX_SHIFT)) & GENFSK_ENH_FEATURE_STAY_IN_RX_MASK)

#define GENFSK_ENH_FEATURE_PHR_TYPE_MASK         (0x700U)
#define GENFSK_ENH_FEATURE_PHR_TYPE_SHIFT        (8U)
/*! PHR_TYPE - PHR Type
 *  0b000..The packet type is GFSK
 *  0b001..The packet type is MSK
 *  0b010..The packet type is SUN FSK
 *  0b011..The packet type is LECIM FSK
 */
#define GENFSK_ENH_FEATURE_PHR_TYPE(x)           (((uint32_t)(((uint32_t)(x)) << GENFSK_ENH_FEATURE_PHR_TYPE_SHIFT)) & GENFSK_ENH_FEATURE_PHR_TYPE_MASK)

#define GENFSK_ENH_FEATURE_SW_BUILD_ACK_MASK     (0x800U)
#define GENFSK_ENH_FEATURE_SW_BUILD_ACK_SHIFT    (11U)
/*! SW_BUILD_ACK - Software builds the ACK packet in RAM
 *  0b0..Hardware builds part of or the whole of the auto ACK frame
 *  0b1..Software builds the whole auto ACK frame in RAM.
 */
#define GENFSK_ENH_FEATURE_SW_BUILD_ACK(x)       (((uint32_t)(((uint32_t)(x)) << GENFSK_ENH_FEATURE_SW_BUILD_ACK_SHIFT)) & GENFSK_ENH_FEATURE_SW_BUILD_ACK_MASK)

#define GENFSK_ENH_FEATURE_ACKBUF_SEL_MASK       (0x1000U)
#define GENFSK_ENH_FEATURE_ACKBUF_SEL_SHIFT      (12U)
/*! ACKBUF_SEL - ACK frame is in 64-byte dedicated RAM or TX buffer RAM
 *  0b0..ACK frame is in 64-byte dedicated RAM
 *  0b1..ACK frame is in TX buffer RAM
 */
#define GENFSK_ENH_FEATURE_ACKBUF_SEL(x)         (((uint32_t)(((uint32_t)(x)) << GENFSK_ENH_FEATURE_ACKBUF_SEL_SHIFT)) & GENFSK_ENH_FEATURE_ACKBUF_SEL_MASK)

#define GENFSK_ENH_FEATURE_AUTOACK_MASK          (0x2000U)
#define GENFSK_ENH_FEATURE_AUTOACK_SHIFT         (13U)
/*! AUTOACK - Auto Acknowledge Enable
 *  0b0..sequence manager will not follow a receive frame with a Tx Ack frame, under any conditions; the
 *       autosequence will terminate after the receive frame.
 *  0b1..sequence manager will follow a receive frame with an automatic hardware-generated Tx Ack frame, assuming other necessary conditions are met.
 */
#define GENFSK_ENH_FEATURE_AUTOACK(x)            (((uint32_t)(((uint32_t)(x)) << GENFSK_ENH_FEATURE_AUTOACK_SHIFT)) & GENFSK_ENH_FEATURE_AUTOACK_MASK)

#define GENFSK_ENH_FEATURE_RXACKRQD_MASK         (0x4000U)
#define GENFSK_ENH_FEATURE_RXACKRQD_SHIFT        (14U)
/*! RXACKRQD - Receive Acknowledge Frame required
 *  0b0..An ordinary receive frame (any type of frame) follows the transmit frame.
 *  0b1..A receive Ack frame is expected to follow the transmit frame (non-Ack frames are rejected).
 */
#define GENFSK_ENH_FEATURE_RXACKRQD(x)           (((uint32_t)(((uint32_t)(x)) << GENFSK_ENH_FEATURE_RXACKRQD_SHIFT)) & GENFSK_ENH_FEATURE_RXACKRQD_MASK)

#define GENFSK_ENH_FEATURE_SLOTTED_MASK          (0x8000U)
#define GENFSK_ENH_FEATURE_SLOTTED_SHIFT         (15U)
/*! SLOTTED - Slotted Mode
 */
#define GENFSK_ENH_FEATURE_SLOTTED(x)            (((uint32_t)(((uint32_t)(x)) << GENFSK_ENH_FEATURE_SLOTTED_SHIFT)) & GENFSK_ENH_FEATURE_SLOTTED_MASK)

#define GENFSK_ENH_FEATURE_LENGTH_ACK_MASK       (0x7FF0000U)
#define GENFSK_ENH_FEATURE_LENGTH_ACK_SHIFT      (16U)
/*! LENGTH_ACK - Length of the ACK frame(or part of the ACK frame) in RAM
 */
#define GENFSK_ENH_FEATURE_LENGTH_ACK(x)         (((uint32_t)(((uint32_t)(x)) << GENFSK_ENH_FEATURE_LENGTH_ACK_SHIFT)) & GENFSK_ENH_FEATURE_LENGTH_ACK_MASK)

#define GENFSK_ENH_FEATURE_BLE_V5P1_CTE_EN_MASK  (0x80000000U)
#define GENFSK_ENH_FEATURE_BLE_V5P1_CTE_EN_SHIFT (31U)
/*! BLE_V5P1_CTE_EN - Bluetooth LE version 5.1 CTE feature enable
 *  0b0..Do not support Bluetooth LE version 5.1 CTE feature.
 *  0b1..Support Bluetooth LE version 5.1 CTE feature, which means the link layer hardware can parse the CTE field
 *       length and extend the RX_EN signal accordingly.
 */
#define GENFSK_ENH_FEATURE_BLE_V5P1_CTE_EN(x)    (((uint32_t)(((uint32_t)(x)) << GENFSK_ENH_FEATURE_BLE_V5P1_CTE_EN_SHIFT)) & GENFSK_ENH_FEATURE_BLE_V5P1_CTE_EN_MASK)
/*! @} */

/*! @name RX_FRAME_FILTER - RECEIVE FRAME FILTER */
/*! @{ */

#define GENFSK_RX_FRAME_FILTER_BEACON_FT_MASK    (0x1U)
#define GENFSK_RX_FRAME_FILTER_BEACON_FT_SHIFT   (0U)
/*! BEACON_FT - Beacon Frame Type Enable
 *  0b0..reject all Beacon frames
 *  0b1..Beacon frame type enabled.
 */
#define GENFSK_RX_FRAME_FILTER_BEACON_FT(x)      (((uint32_t)(((uint32_t)(x)) << GENFSK_RX_FRAME_FILTER_BEACON_FT_SHIFT)) & GENFSK_RX_FRAME_FILTER_BEACON_FT_MASK)

#define GENFSK_RX_FRAME_FILTER_DATA_FT_MASK      (0x2U)
#define GENFSK_RX_FRAME_FILTER_DATA_FT_SHIFT     (1U)
/*! DATA_FT - Data Frame Type Enable
 *  0b0..reject all Beacon frames
 *  0b1..Data frame type enabled.
 */
#define GENFSK_RX_FRAME_FILTER_DATA_FT(x)        (((uint32_t)(((uint32_t)(x)) << GENFSK_RX_FRAME_FILTER_DATA_FT_SHIFT)) & GENFSK_RX_FRAME_FILTER_DATA_FT_MASK)

#define GENFSK_RX_FRAME_FILTER_ACK_FT_MASK       (0x4U)
#define GENFSK_RX_FRAME_FILTER_ACK_FT_SHIFT      (2U)
/*! ACK_FT - Ack Frame Type Enable
 *  0b0..reject all Acknowledge frames
 *  0b1..Acknowledge frame type enabled.
 */
#define GENFSK_RX_FRAME_FILTER_ACK_FT(x)         (((uint32_t)(((uint32_t)(x)) << GENFSK_RX_FRAME_FILTER_ACK_FT_SHIFT)) & GENFSK_RX_FRAME_FILTER_ACK_FT_MASK)

#define GENFSK_RX_FRAME_FILTER_CMD_FT_MASK       (0x8U)
#define GENFSK_RX_FRAME_FILTER_CMD_FT_SHIFT      (3U)
/*! CMD_FT - MAC Command Frame Type Enable
 *  0b0..reject all MAC Command frames
 *  0b1..MAC Command frame type enabled.
 */
#define GENFSK_RX_FRAME_FILTER_CMD_FT(x)         (((uint32_t)(((uint32_t)(x)) << GENFSK_RX_FRAME_FILTER_CMD_FT_SHIFT)) & GENFSK_RX_FRAME_FILTER_CMD_FT_MASK)

#define GENFSK_RX_FRAME_FILTER_LLDN_FT_MASK      (0x10U)
#define GENFSK_RX_FRAME_FILTER_LLDN_FT_SHIFT     (4U)
/*! LLDN_FT - LLDN Frame Type Enable
 *  0b0..reject all LLDN frames
 *  0b1..LLDN frame type enabled (Frame Type 4).
 */
#define GENFSK_RX_FRAME_FILTER_LLDN_FT(x)        (((uint32_t)(((uint32_t)(x)) << GENFSK_RX_FRAME_FILTER_LLDN_FT_SHIFT)) & GENFSK_RX_FRAME_FILTER_LLDN_FT_MASK)

#define GENFSK_RX_FRAME_FILTER_MULTIPURPOSE_FT_MASK (0x20U)
#define GENFSK_RX_FRAME_FILTER_MULTIPURPOSE_FT_SHIFT (5U)
/*! MULTIPURPOSE_FT - Multipurpose Frame Type Enable
 *  0b0..reject all Multipurpose frames
 *  0b1..Multipurpose frame type enabled (Frame Type 5).
 */
#define GENFSK_RX_FRAME_FILTER_MULTIPURPOSE_FT(x) (((uint32_t)(((uint32_t)(x)) << GENFSK_RX_FRAME_FILTER_MULTIPURPOSE_FT_SHIFT)) & GENFSK_RX_FRAME_FILTER_MULTIPURPOSE_FT_MASK)

#define GENFSK_RX_FRAME_FILTER_FRAGMENT_FT_MASK  (0x40U)
#define GENFSK_RX_FRAME_FILTER_FRAGMENT_FT_SHIFT (6U)
/*! FRAGMENT_FT - Fragment Frame Type Enable
 *  0b0..reject all Fragment frames
 *  0b1..Fragment frame type enabled (Frame Type 6).
 */
#define GENFSK_RX_FRAME_FILTER_FRAGMENT_FT(x)    (((uint32_t)(((uint32_t)(x)) << GENFSK_RX_FRAME_FILTER_FRAGMENT_FT_SHIFT)) & GENFSK_RX_FRAME_FILTER_FRAGMENT_FT_MASK)

#define GENFSK_RX_FRAME_FILTER_EXTENDED_FT_MASK  (0x80U)
#define GENFSK_RX_FRAME_FILTER_EXTENDED_FT_SHIFT (7U)
/*! EXTENDED_FT - Extended Frame Type Enable
 *  0b0..reject all Extended frames
 *  0b1..Extended frame type enabled (Frame Type 7).
 */
#define GENFSK_RX_FRAME_FILTER_EXTENDED_FT(x)    (((uint32_t)(((uint32_t)(x)) << GENFSK_RX_FRAME_FILTER_EXTENDED_FT_SHIFT)) & GENFSK_RX_FRAME_FILTER_EXTENDED_FT_MASK)

#define GENFSK_RX_FRAME_FILTER_NS_FT_MASK        (0x100U)
#define GENFSK_RX_FRAME_FILTER_NS_FT_SHIFT       (8U)
/*! NS_FT - "Not Specified" Frame Type Enable
 *  0b0..reject all "Not Specified" frames
 *  0b1..Not-specified (reserved) frame type enabled. Applies to Frame Type 6. No packet filtering is performed,
 *       except for frame length checking (FrameLength>=5 and FrameLength<=127). No AUTOACK is transmitted for this
 *       Frame Type
 */
#define GENFSK_RX_FRAME_FILTER_NS_FT(x)          (((uint32_t)(((uint32_t)(x)) << GENFSK_RX_FRAME_FILTER_NS_FT_SHIFT)) & GENFSK_RX_FRAME_FILTER_NS_FT_MASK)

#define GENFSK_RX_FRAME_FILTER_FRM_VER_FILTER_MASK (0x1E00U)
#define GENFSK_RX_FRAME_FILTER_FRM_VER_FILTER_SHIFT (9U)
/*! FRM_VER_FILTER - Frame Version selector.
 */
#define GENFSK_RX_FRAME_FILTER_FRM_VER_FILTER(x) (((uint32_t)(((uint32_t)(x)) << GENFSK_RX_FRAME_FILTER_FRM_VER_FILTER_SHIFT)) & GENFSK_RX_FRAME_FILTER_FRM_VER_FILTER_MASK)

#define GENFSK_RX_FRAME_FILTER_EXTENDED_FCS_CHK_MASK (0x8000U)
#define GENFSK_RX_FRAME_FILTER_EXTENDED_FCS_CHK_SHIFT (15U)
/*! EXTENDED_FCS_CHK - Verify FCS on Frame Type Extended
 *  0b0..Packet Processor will not check FCS for Frame Type EXTENDED (default)
 *  0b1..Packet Processor will check FCS at end-of-packet based on packet length derived from PHR, for Frame Type EXTENDED
 */
#define GENFSK_RX_FRAME_FILTER_EXTENDED_FCS_CHK(x) (((uint32_t)(((uint32_t)(x)) << GENFSK_RX_FRAME_FILTER_EXTENDED_FCS_CHK_SHIFT)) & GENFSK_RX_FRAME_FILTER_EXTENDED_FCS_CHK_MASK)

#define GENFSK_RX_FRAME_FILTER_FV2_BEACON_RECD_MASK (0x10000U)
#define GENFSK_RX_FRAME_FILTER_FV2_BEACON_RECD_SHIFT (16U)
/*! FV2_BEACON_RECD - Frame Version 2 Beacon Packet Received
 *  0b0..The last packet received was not Frame Type Beacon with Frame Version 2
 *  0b1..The last packet received was Frame Type Beacon with Frame Version 2, and FRM_VER_FILTER[2]=1 to allow such packets
 */
#define GENFSK_RX_FRAME_FILTER_FV2_BEACON_RECD(x) (((uint32_t)(((uint32_t)(x)) << GENFSK_RX_FRAME_FILTER_FV2_BEACON_RECD_SHIFT)) & GENFSK_RX_FRAME_FILTER_FV2_BEACON_RECD_MASK)

#define GENFSK_RX_FRAME_FILTER_FV2_DATA_RECD_MASK (0x20000U)
#define GENFSK_RX_FRAME_FILTER_FV2_DATA_RECD_SHIFT (17U)
/*! FV2_DATA_RECD - Frame Version 2 Data Packet Received
 *  0b0..The last packet received was not Frame Type Data with Frame Version 2
 *  0b1..The last packet received was Frame Type Data with Frame Version 2, and FRM_VER_FILTER[2]=1 to allow such packets
 */
#define GENFSK_RX_FRAME_FILTER_FV2_DATA_RECD(x)  (((uint32_t)(((uint32_t)(x)) << GENFSK_RX_FRAME_FILTER_FV2_DATA_RECD_SHIFT)) & GENFSK_RX_FRAME_FILTER_FV2_DATA_RECD_MASK)

#define GENFSK_RX_FRAME_FILTER_FV2_ACK_RECD_MASK (0x40000U)
#define GENFSK_RX_FRAME_FILTER_FV2_ACK_RECD_SHIFT (18U)
/*! FV2_ACK_RECD - Frame Version 2 Acknowledge Packet Received
 *  0b0..The last packet received was not Frame Type Ack with Frame Version 2
 *  0b1..The last packet received was Frame Type Ack with Frame Version 2, and FRM_VER_FILTER[2]=1 to allow such packets
 */
#define GENFSK_RX_FRAME_FILTER_FV2_ACK_RECD(x)   (((uint32_t)(((uint32_t)(x)) << GENFSK_RX_FRAME_FILTER_FV2_ACK_RECD_SHIFT)) & GENFSK_RX_FRAME_FILTER_FV2_ACK_RECD_MASK)

#define GENFSK_RX_FRAME_FILTER_FV2_CMD_RECD_MASK (0x80000U)
#define GENFSK_RX_FRAME_FILTER_FV2_CMD_RECD_SHIFT (19U)
/*! FV2_CMD_RECD - Frame Version 2 MAC Command Packet Received
 *  0b0..The last packet received was not Frame Type MAC Command with Frame Version 2
 *  0b1..The last packet received was Frame Type MAC Command with Frame Version 2, and FRM_VER_FILTER[2]=1 to allow such packets
 */
#define GENFSK_RX_FRAME_FILTER_FV2_CMD_RECD(x)   (((uint32_t)(((uint32_t)(x)) << GENFSK_RX_FRAME_FILTER_FV2_CMD_RECD_SHIFT)) & GENFSK_RX_FRAME_FILTER_FV2_CMD_RECD_MASK)

#define GENFSK_RX_FRAME_FILTER_LLDN_RECD_MASK    (0x100000U)
#define GENFSK_RX_FRAME_FILTER_LLDN_RECD_SHIFT   (20U)
/*! LLDN_RECD - LLDN Packet Received
 *  0b0..The last packet received was not Frame Type LLDN
 *  0b1..The last packet received was Frame Type LLDN, and LLDN_FT=1 to allow such packets.
 */
#define GENFSK_RX_FRAME_FILTER_LLDN_RECD(x)      (((uint32_t)(((uint32_t)(x)) << GENFSK_RX_FRAME_FILTER_LLDN_RECD_SHIFT)) & GENFSK_RX_FRAME_FILTER_LLDN_RECD_MASK)

#define GENFSK_RX_FRAME_FILTER_MULTIPURPOSE_RECD_MASK (0x200000U)
#define GENFSK_RX_FRAME_FILTER_MULTIPURPOSE_RECD_SHIFT (21U)
/*! MULTIPURPOSE_RECD - Multipurpose Packet Received
 *  0b0..last packet received was not Frame Type MULTIPURPOSE
 *  0b1..The last packet received was Frame Type MULTIPURPOSE, and MULTIPURPOSE_FT=1 to allow such packets.
 */
#define GENFSK_RX_FRAME_FILTER_MULTIPURPOSE_RECD(x) (((uint32_t)(((uint32_t)(x)) << GENFSK_RX_FRAME_FILTER_MULTIPURPOSE_RECD_SHIFT)) & GENFSK_RX_FRAME_FILTER_MULTIPURPOSE_RECD_MASK)

#define GENFSK_RX_FRAME_FILTER_FRAGMENT_RECD_MASK (0x400000U)
#define GENFSK_RX_FRAME_FILTER_FRAGMENT_RECD_SHIFT (22U)
/*! FRAGMENT_RECD - Fragment Packet Received
 *  0b0..last packet received was not Frame Type FRAGMENT
 *  0b1..The last packet received was Frame Type FRAGMENT, and FRAGMENT_FT=1 to allow such packets.
 */
#define GENFSK_RX_FRAME_FILTER_FRAGMENT_RECD(x)  (((uint32_t)(((uint32_t)(x)) << GENFSK_RX_FRAME_FILTER_FRAGMENT_RECD_SHIFT)) & GENFSK_RX_FRAME_FILTER_FRAGMENT_RECD_MASK)

#define GENFSK_RX_FRAME_FILTER_EXTENDED_RECD_MASK (0x800000U)
#define GENFSK_RX_FRAME_FILTER_EXTENDED_RECD_SHIFT (23U)
/*! EXTENDED_RECD - Extended Packet Received
 *  0b0..The last packet received was not Frame Type EXTENDED
 *  0b1..The last packet received was Frame Type EXTENDED, and EXTENDED_FT=1 to allow such packets.
 */
#define GENFSK_RX_FRAME_FILTER_EXTENDED_RECD(x)  (((uint32_t)(((uint32_t)(x)) << GENFSK_RX_FRAME_FILTER_EXTENDED_RECD_SHIFT)) & GENFSK_RX_FRAME_FILTER_EXTENDED_RECD_MASK)

#define GENFSK_RX_FRAME_FILTER_RXCYC_SEL_MASK    (0x10000000U)
#define GENFSK_RX_FRAME_FILTER_RXCYC_SEL_SHIFT   (28U)
/*! RXCYC_SEL - Rx Recycle Time Select
 *  0b0..Recycle when fail happens.
 *  0b1..Recycle when Rx done and fail happens.
 */
#define GENFSK_RX_FRAME_FILTER_RXCYC_SEL(x)      (((uint32_t)(((uint32_t)(x)) << GENFSK_RX_FRAME_FILTER_RXCYC_SEL_SHIFT)) & GENFSK_RX_FRAME_FILTER_RXCYC_SEL_MASK)

#define GENFSK_RX_FRAME_FILTER_FILTER_FAIL_IGNORE_MASK (0x20000000U)
#define GENFSK_RX_FRAME_FILTER_FILTER_FAIL_IGNORE_SHIFT (29U)
/*! FILTER_FAIL_IGNORE - Filter Fail Ignore
 *  0b0..RX_IRQ will not be asserted when filter fail.
 *  0b1..RX_IRQ will be asserted when filter fail.
 */
#define GENFSK_RX_FRAME_FILTER_FILTER_FAIL_IGNORE(x) (((uint32_t)(((uint32_t)(x)) << GENFSK_RX_FRAME_FILTER_FILTER_FAIL_IGNORE_SHIFT)) & GENFSK_RX_FRAME_FILTER_FILTER_FAIL_IGNORE_MASK)

#define GENFSK_RX_FRAME_FILTER_PROMISCUOUS_MASK  (0x40000000U)
#define GENFSK_RX_FRAME_FILTER_PROMISCUOUS_SHIFT (30U)
/*! PROMISCUOUS - Promiscuous Mode Enable
 *  0b0..normal mode
 *  0b1..all packet filtering except frame length checking (FrameLength>=5) is bypassed.
 */
#define GENFSK_RX_FRAME_FILTER_PROMISCUOUS(x)    (((uint32_t)(((uint32_t)(x)) << GENFSK_RX_FRAME_FILTER_PROMISCUOUS_SHIFT)) & GENFSK_RX_FRAME_FILTER_PROMISCUOUS_MASK)

#define GENFSK_RX_FRAME_FILTER_ENH_PKT_STATUS_MASK (0x80000000U)
#define GENFSK_RX_FRAME_FILTER_ENH_PKT_STATUS_SHIFT (31U)
/*! ENH_PKT_STATUS - Enhanced Packet Status
 *  0b0..The last packet received was not 2015-compliant
 *  0b1..The last packet received was 2015-compliant (RX_FRAME_FILTER register should be queried for additional status bits)
 */
#define GENFSK_RX_FRAME_FILTER_ENH_PKT_STATUS(x) (((uint32_t)(((uint32_t)(x)) << GENFSK_RX_FRAME_FILTER_ENH_PKT_STATUS_SHIFT)) & GENFSK_RX_FRAME_FILTER_ENH_PKT_STATUS_MASK)
/*! @} */

/*! @name FILTERFAIL_CODE - FILTER FAIL CODE */
/*! @{ */

#define GENFSK_FILTERFAIL_CODE_FILTERFAIL_CODE_PAN_MASK (0x3FFU)
#define GENFSK_FILTERFAIL_CODE_FILTERFAIL_CODE_PAN_SHIFT (0U)
/*! FILTERFAIL_CODE_PAN - Filter Fail Code When in PAN Mode
 */
#define GENFSK_FILTERFAIL_CODE_FILTERFAIL_CODE_PAN(x) (((uint32_t)(((uint32_t)(x)) << GENFSK_FILTERFAIL_CODE_FILTERFAIL_CODE_PAN_SHIFT)) & GENFSK_FILTERFAIL_CODE_FILTERFAIL_CODE_PAN_MASK)

#define GENFSK_FILTERFAIL_CODE_FILTERFAIL_CODE_FAN_MASK (0x30000U)
#define GENFSK_FILTERFAIL_CODE_FILTERFAIL_CODE_FAN_SHIFT (16U)
/*! FILTERFAIL_CODE_FAN - Filter Fail Code When in FAN Mode
 */
#define GENFSK_FILTERFAIL_CODE_FILTERFAIL_CODE_FAN(x) (((uint32_t)(((uint32_t)(x)) << GENFSK_FILTERFAIL_CODE_FILTERFAIL_CODE_FAN_SHIFT)) & GENFSK_FILTERFAIL_CODE_FILTERFAIL_CODE_FAN_MASK)

#define GENFSK_FILTERFAIL_CODE_FILTERFAIL_PAN_SEL_MASK (0x40000000U)
#define GENFSK_FILTERFAIL_CODE_FILTERFAIL_PAN_SEL_SHIFT (30U)
/*! FILTERFAIL_PAN_SEL - PAN Selector for Filter Fail Code
 *  0b0..FILTERFAIL_CODE_PAN/FILTERFAIL_CODE_FAN will report the FILTERFAIL status of PAN0
 *  0b1..FILTERFAIL_CODE_PAN/FILTERFAIL_CODE_FAN will report the FILTERFAIL status of PAN1
 */
#define GENFSK_FILTERFAIL_CODE_FILTERFAIL_PAN_SEL(x) (((uint32_t)(((uint32_t)(x)) << GENFSK_FILTERFAIL_CODE_FILTERFAIL_PAN_SEL_SHIFT)) & GENFSK_FILTERFAIL_CODE_FILTERFAIL_PAN_SEL_MASK)

#define GENFSK_FILTERFAIL_CODE_FILTERFAIL_FLAG_SEL_MASK (0x80000000U)
#define GENFSK_FILTERFAIL_CODE_FILTERFAIL_FLAG_SEL_SHIFT (31U)
/*! FILTERFAIL_FLAG_SEL - Consolidated Filter Fail Flag
 */
#define GENFSK_FILTERFAIL_CODE_FILTERFAIL_FLAG_SEL(x) (((uint32_t)(((uint32_t)(x)) << GENFSK_FILTERFAIL_CODE_FILTERFAIL_FLAG_SEL_SHIFT)) & GENFSK_FILTERFAIL_CODE_FILTERFAIL_FLAG_SEL_MASK)
/*! @} */

/*! @name LENIENCY_LSB - LENIENCY LSB */
/*! @{ */

#define GENFSK_LENIENCY_LSB_LENIENCY_LSB_MASK    (0xFFFFFFFFU)
#define GENFSK_LENIENCY_LSB_LENIENCY_LSB_SHIFT   (0U)
/*! LENIENCY_LSB - Leniency LSB Register
 */
#define GENFSK_LENIENCY_LSB_LENIENCY_LSB(x)      (((uint32_t)(((uint32_t)(x)) << GENFSK_LENIENCY_LSB_LENIENCY_LSB_SHIFT)) & GENFSK_LENIENCY_LSB_LENIENCY_LSB_MASK)
/*! @} */

/*! @name RPA_CTRL - RPA CONTROL */
/*! @{ */

#define GENFSK_RPA_CTRL_RPA_VALID_ENTRY_MASK     (0xFFU)
#define GENFSK_RPA_CTRL_RPA_VALID_ENTRY_SHIFT    (0U)
#define GENFSK_RPA_CTRL_RPA_VALID_ENTRY(x)       (((uint32_t)(((uint32_t)(x)) << GENFSK_RPA_CTRL_RPA_VALID_ENTRY_SHIFT)) & GENFSK_RPA_CTRL_RPA_VALID_ENTRY_MASK)

#define GENFSK_RPA_CTRL_IGNORE_RPA_FAIL_MASK     (0x8000000U)
#define GENFSK_RPA_CTRL_IGNORE_RPA_FAIL_SHIFT    (27U)
/*! IGNORE_RPA_FAIL
 *  0b0..link layer aborts the Rx process when LOCAL_RPA_FAIL_IRQ or PEER_RPA_FAIL_IRQ
 *  0b1..link layer ignores LOCAL_RPA_FAIL_IRQ and PEER_RPA_FAIL_IRQ.
 */
#define GENFSK_RPA_CTRL_IGNORE_RPA_FAIL(x)       (((uint32_t)(((uint32_t)(x)) << GENFSK_RPA_CTRL_IGNORE_RPA_FAIL_SHIFT)) & GENFSK_RPA_CTRL_IGNORE_RPA_FAIL_MASK)

#define GENFSK_RPA_CTRL_IGNORE_DIRECT_FAIL_MASK  (0x10000000U)
#define GENFSK_RPA_CTRL_IGNORE_DIRECT_FAIL_SHIFT (28U)
/*! IGNORE_DIRECT_FAIL
 *  0b0..link layer aborts the Rx process when DIRECT_ID_FAIL_IRQ
 *  0b1..link layer ignores DIRECT_ID_FAIL_IRQ.
 */
#define GENFSK_RPA_CTRL_IGNORE_DIRECT_FAIL(x)    (((uint32_t)(((uint32_t)(x)) << GENFSK_RPA_CTRL_IGNORE_DIRECT_FAIL_SHIFT)) & GENFSK_RPA_CTRL_IGNORE_DIRECT_FAIL_MASK)

#define GENFSK_RPA_CTRL_ADV_DIRECT_IND_SENT_MASK (0x20000000U)
#define GENFSK_RPA_CTRL_ADV_DIRECT_IND_SENT_SHIFT (29U)
#define GENFSK_RPA_CTRL_ADV_DIRECT_IND_SENT(x)   (((uint32_t)(((uint32_t)(x)) << GENFSK_RPA_CTRL_ADV_DIRECT_IND_SENT_SHIFT)) & GENFSK_RPA_CTRL_ADV_DIRECT_IND_SENT_MASK)

#define GENFSK_RPA_CTRL_RPA_EN_MASK              (0x40000000U)
#define GENFSK_RPA_CTRL_RPA_EN_SHIFT             (30U)
/*! RPA_EN
 *  0b0..The RPA check is disabled.
 *  0b1..The RPA check is enabled.
 */
#define GENFSK_RPA_CTRL_RPA_EN(x)                (((uint32_t)(((uint32_t)(x)) << GENFSK_RPA_CTRL_RPA_EN_SHIFT)) & GENFSK_RPA_CTRL_RPA_EN_MASK)

#define GENFSK_RPA_CTRL_ADV_CHANNEL_EN_MASK      (0x80000000U)
#define GENFSK_RPA_CTRL_ADV_CHANNEL_EN_SHIFT     (31U)
/*! ADV_CHANNEL_EN
 *  0b0..The packet to be received is in Data Channel PDU.
 *  0b1..The packet to be received is in Advertising Channel PDU.
 */
#define GENFSK_RPA_CTRL_ADV_CHANNEL_EN(x)        (((uint32_t)(((uint32_t)(x)) << GENFSK_RPA_CTRL_ADV_CHANNEL_EN_SHIFT)) & GENFSK_RPA_CTRL_ADV_CHANNEL_EN_MASK)
/*! @} */

/*! @name LENIENCY_MSB - LENIENCY MSB */
/*! @{ */

#define GENFSK_LENIENCY_MSB_LENIENCY_MSB_MASK    (0x1FFFU)
#define GENFSK_LENIENCY_MSB_LENIENCY_MSB_SHIFT   (0U)
/*! LENIENCY_MSB - Leniency MSB Register
 */
#define GENFSK_LENIENCY_MSB_LENIENCY_MSB(x)      (((uint32_t)(((uint32_t)(x)) << GENFSK_LENIENCY_MSB_LENIENCY_MSB_SHIFT)) & GENFSK_LENIENCY_MSB_LENIENCY_MSB_MASK)
/*! @} */

/*! @name WL_CTRL - WHITE LIST CONTROL */
/*! @{ */

#define GENFSK_WL_CTRL_WL_EN_MASK                (0x1U)
#define GENFSK_WL_CTRL_WL_EN_SHIFT               (0U)
/*! WL_EN
 *  0b0..White list search is not enabled
 *  0b1..White list search is enabled
 */
#define GENFSK_WL_CTRL_WL_EN(x)                  (((uint32_t)(((uint32_t)(x)) << GENFSK_WL_CTRL_WL_EN_SHIFT)) & GENFSK_WL_CTRL_WL_EN_MASK)

#define GENFSK_WL_CTRL_WL_SEL_MASK               (0x2U)
#define GENFSK_WL_CTRL_WL_SEL_SHIFT              (1U)
/*! WL_SEL
 *  0b0..Select white list 0
 *  0b1..Select white list 1
 */
#define GENFSK_WL_CTRL_WL_SEL(x)                 (((uint32_t)(((uint32_t)(x)) << GENFSK_WL_CTRL_WL_SEL_SHIFT)) & GENFSK_WL_CTRL_WL_SEL_MASK)

#define GENFSK_WL_CTRL_IGNORE_WL_FAIL_MASK       (0x8U)
#define GENFSK_WL_CTRL_IGNORE_WL_FAIL_SHIFT      (3U)
/*! IGNORE_WL_FAIL
 *  0b0..link layer aborts the Rx process when WL_FAIL_IRQ
 *  0b1..link layer ignores WL_FAIL_IRQ.
 */
#define GENFSK_WL_CTRL_IGNORE_WL_FAIL(x)         (((uint32_t)(((uint32_t)(x)) << GENFSK_WL_CTRL_IGNORE_WL_FAIL_SHIFT)) & GENFSK_WL_CTRL_IGNORE_WL_FAIL_MASK)
/*! @} */

/*! @name DUAL_PAN_CTRL - DUAL PAN CONTROL */
/*! @{ */

#define GENFSK_DUAL_PAN_CTRL_ACTIVE_NETWORK_MASK (0x1U)
#define GENFSK_DUAL_PAN_CTRL_ACTIVE_NETWORK_SHIFT (0U)
/*! ACTIVE_NETWORK - Active Network Selector
 *  0b0..Select PAN0
 *  0b1..Select PAN1
 */
#define GENFSK_DUAL_PAN_CTRL_ACTIVE_NETWORK(x)   (((uint32_t)(((uint32_t)(x)) << GENFSK_DUAL_PAN_CTRL_ACTIVE_NETWORK_SHIFT)) & GENFSK_DUAL_PAN_CTRL_ACTIVE_NETWORK_MASK)

#define GENFSK_DUAL_PAN_CTRL_DUAL_PAN_AUTO_MASK  (0x2U)
#define GENFSK_DUAL_PAN_CTRL_DUAL_PAN_AUTO_SHIFT (1U)
/*! DUAL_PAN_AUTO - Activates automatic Dual PAN operating mode
 */
#define GENFSK_DUAL_PAN_CTRL_DUAL_PAN_AUTO(x)    (((uint32_t)(((uint32_t)(x)) << GENFSK_DUAL_PAN_CTRL_DUAL_PAN_AUTO_SHIFT)) & GENFSK_DUAL_PAN_CTRL_DUAL_PAN_AUTO_MASK)

#define GENFSK_DUAL_PAN_CTRL_CURRENT_NETWORK_MASK (0x4U)
#define GENFSK_DUAL_PAN_CTRL_CURRENT_NETWORK_SHIFT (2U)
/*! CURRENT_NETWORK - Indicates which PAN is currently selected by hardware
 *  0b0..PAN0 is selected
 *  0b1..PAN1 is selected
 */
#define GENFSK_DUAL_PAN_CTRL_CURRENT_NETWORK(x)  (((uint32_t)(((uint32_t)(x)) << GENFSK_DUAL_PAN_CTRL_CURRENT_NETWORK_SHIFT)) & GENFSK_DUAL_PAN_CTRL_CURRENT_NETWORK_MASK)

#define GENFSK_DUAL_PAN_CTRL_DUAL_PAN_DWELL_MASK (0xFF00U)
#define GENFSK_DUAL_PAN_CTRL_DUAL_PAN_DWELL_SHIFT (8U)
/*! DUAL_PAN_DWELL - Dual PAN Channel Frequency Dwell Time
 */
#define GENFSK_DUAL_PAN_CTRL_DUAL_PAN_DWELL(x)   (((uint32_t)(((uint32_t)(x)) << GENFSK_DUAL_PAN_CTRL_DUAL_PAN_DWELL_SHIFT)) & GENFSK_DUAL_PAN_CTRL_DUAL_PAN_DWELL_MASK)

#define GENFSK_DUAL_PAN_CTRL_DUAL_PAN_REMAIN_MASK (0x3F0000U)
#define GENFSK_DUAL_PAN_CTRL_DUAL_PAN_REMAIN_SHIFT (16U)
/*! DUAL_PAN_REMAIN - Time Remaining before next PAN switch in auto Dual PAN mode
 */
#define GENFSK_DUAL_PAN_CTRL_DUAL_PAN_REMAIN(x)  (((uint32_t)(((uint32_t)(x)) << GENFSK_DUAL_PAN_CTRL_DUAL_PAN_REMAIN_SHIFT)) & GENFSK_DUAL_PAN_CTRL_DUAL_PAN_REMAIN_MASK)

#define GENFSK_DUAL_PAN_CTRL_MODE_PAN0_MASK      (0x1000000U)
#define GENFSK_DUAL_PAN_CTRL_MODE_PAN0_SHIFT     (24U)
/*! MODE_PAN0 - PAN0 Mode Select
 *  0b0..PAN0 is in PAN mode
 *  0b1..PAN0 is in FAN mode
 */
#define GENFSK_DUAL_PAN_CTRL_MODE_PAN0(x)        (((uint32_t)(((uint32_t)(x)) << GENFSK_DUAL_PAN_CTRL_MODE_PAN0_SHIFT)) & GENFSK_DUAL_PAN_CTRL_MODE_PAN0_MASK)

#define GENFSK_DUAL_PAN_CTRL_MODE_PAN1_MASK      (0x2000000U)
#define GENFSK_DUAL_PAN_CTRL_MODE_PAN1_SHIFT     (25U)
/*! MODE_PAN1 - PAN1 Mode Select
 *  0b0..PAN1 is in PAN mode
 *  0b1..PAN1 is in FAN mode
 */
#define GENFSK_DUAL_PAN_CTRL_MODE_PAN1(x)        (((uint32_t)(((uint32_t)(x)) << GENFSK_DUAL_PAN_CTRL_MODE_PAN1_SHIFT)) & GENFSK_DUAL_PAN_CTRL_MODE_PAN1_MASK)

#define GENFSK_DUAL_PAN_CTRL_DP_CHAN_OVRD_EN_MASK (0x4000000U)
#define GENFSK_DUAL_PAN_CTRL_DP_CHAN_OVRD_EN_SHIFT (26U)
/*! DP_CHAN_OVRD_EN - Dual PAN Channel Override Enable
 */
#define GENFSK_DUAL_PAN_CTRL_DP_CHAN_OVRD_EN(x)  (((uint32_t)(((uint32_t)(x)) << GENFSK_DUAL_PAN_CTRL_DP_CHAN_OVRD_EN_SHIFT)) & GENFSK_DUAL_PAN_CTRL_DP_CHAN_OVRD_EN_MASK)

#define GENFSK_DUAL_PAN_CTRL_DP_CHAN_OVRD_SEL_MASK (0x8000000U)
#define GENFSK_DUAL_PAN_CTRL_DP_CHAN_OVRD_SEL_SHIFT (27U)
/*! DP_CHAN_OVRD_SEL - Dual PAN Channel Override Selector
 */
#define GENFSK_DUAL_PAN_CTRL_DP_CHAN_OVRD_SEL(x) (((uint32_t)(((uint32_t)(x)) << GENFSK_DUAL_PAN_CTRL_DP_CHAN_OVRD_SEL_SHIFT)) & GENFSK_DUAL_PAN_CTRL_DP_CHAN_OVRD_SEL_MASK)

#define GENFSK_DUAL_PAN_CTRL_PANCORDNTR0_MASK    (0x10000000U)
#define GENFSK_DUAL_PAN_CTRL_PANCORDNTR0_SHIFT   (28U)
/*! PANCORDNTR0 - Device is a PAN Coordinator on PAN0
 */
#define GENFSK_DUAL_PAN_CTRL_PANCORDNTR0(x)      (((uint32_t)(((uint32_t)(x)) << GENFSK_DUAL_PAN_CTRL_PANCORDNTR0_SHIFT)) & GENFSK_DUAL_PAN_CTRL_PANCORDNTR0_MASK)

#define GENFSK_DUAL_PAN_CTRL_PANCORDNTR1_MASK    (0x20000000U)
#define GENFSK_DUAL_PAN_CTRL_PANCORDNTR1_SHIFT   (29U)
/*! PANCORDNTR1 - Device is a PAN Coordinator on PAN1
 */
#define GENFSK_DUAL_PAN_CTRL_PANCORDNTR1(x)      (((uint32_t)(((uint32_t)(x)) << GENFSK_DUAL_PAN_CTRL_PANCORDNTR1_SHIFT)) & GENFSK_DUAL_PAN_CTRL_PANCORDNTR1_MASK)

#define GENFSK_DUAL_PAN_CTRL_RECD_ON_PAN0_MASK   (0x40000000U)
#define GENFSK_DUAL_PAN_CTRL_RECD_ON_PAN0_SHIFT  (30U)
/*! RECD_ON_PAN0 - Last Packet was Received on PAN0
 */
#define GENFSK_DUAL_PAN_CTRL_RECD_ON_PAN0(x)     (((uint32_t)(((uint32_t)(x)) << GENFSK_DUAL_PAN_CTRL_RECD_ON_PAN0_SHIFT)) & GENFSK_DUAL_PAN_CTRL_RECD_ON_PAN0_MASK)

#define GENFSK_DUAL_PAN_CTRL_RECD_ON_PAN1_MASK   (0x80000000U)
#define GENFSK_DUAL_PAN_CTRL_RECD_ON_PAN1_SHIFT  (31U)
/*! RECD_ON_PAN1 - Last Packet was Received on PAN1
 */
#define GENFSK_DUAL_PAN_CTRL_RECD_ON_PAN1(x)     (((uint32_t)(((uint32_t)(x)) << GENFSK_DUAL_PAN_CTRL_RECD_ON_PAN1_SHIFT)) & GENFSK_DUAL_PAN_CTRL_RECD_ON_PAN1_MASK)
/*! @} */

/*! @name GTM_PDU - GTM MODE PDU */
/*! @{ */

#define GENFSK_GTM_PDU_GTM_PDU_MASK              (0xFFFFFFFFU)
#define GENFSK_GTM_PDU_GTM_PDU_SHIFT             (0U)
/*! GTM_PDU - GTM MODE PDU
 */
#define GENFSK_GTM_PDU_GTM_PDU(x)                (((uint32_t)(((uint32_t)(x)) << GENFSK_GTM_PDU_GTM_PDU_SHIFT)) & GENFSK_GTM_PDU_GTM_PDU_MASK)
/*! @} */

/*! @name MACSHORTADDRS1 - MAC SHORT ADDRESS FOR PAN1 */
/*! @{ */

#define GENFSK_MACSHORTADDRS1_MACPANID1_MASK     (0xFFFFU)
#define GENFSK_MACSHORTADDRS1_MACPANID1_SHIFT    (0U)
/*! MACPANID1 - MAC PAN ID for PAN1
 */
#define GENFSK_MACSHORTADDRS1_MACPANID1(x)       (((uint32_t)(((uint32_t)(x)) << GENFSK_MACSHORTADDRS1_MACPANID1_SHIFT)) & GENFSK_MACSHORTADDRS1_MACPANID1_MASK)

#define GENFSK_MACSHORTADDRS1_MACSHORTADDRS1_MASK (0xFFFF0000U)
#define GENFSK_MACSHORTADDRS1_MACSHORTADDRS1_SHIFT (16U)
/*! MACSHORTADDRS1 - MAC SHORT ADDRESS for PAN1
 */
#define GENFSK_MACSHORTADDRS1_MACSHORTADDRS1(x)  (((uint32_t)(((uint32_t)(x)) << GENFSK_MACSHORTADDRS1_MACSHORTADDRS1_SHIFT)) & GENFSK_MACSHORTADDRS1_MACSHORTADDRS1_MASK)
/*! @} */

/*! @name WL_VALID_ENTRY1 - VALID ENTRY OF WHITE LIST 1 */
/*! @{ */

#define GENFSK_WL_VALID_ENTRY1_WL_VALID_ENTRY1_MASK (0xFFFFFFFFU)
#define GENFSK_WL_VALID_ENTRY1_WL_VALID_ENTRY1_SHIFT (0U)
#define GENFSK_WL_VALID_ENTRY1_WL_VALID_ENTRY1(x) (((uint32_t)(((uint32_t)(x)) << GENFSK_WL_VALID_ENTRY1_WL_VALID_ENTRY1_SHIFT)) & GENFSK_WL_VALID_ENTRY1_WL_VALID_ENTRY1_MASK)
/*! @} */

/*! @name DIRECT_PEER_ADDR_LSB - DIRECT_PEER_ADDR[31:0] */
/*! @{ */

#define GENFSK_DIRECT_PEER_ADDR_LSB_DIRECT_PEER_ADDR_LSB_MASK (0xFFFFFFFFU)
#define GENFSK_DIRECT_PEER_ADDR_LSB_DIRECT_PEER_ADDR_LSB_SHIFT (0U)
#define GENFSK_DIRECT_PEER_ADDR_LSB_DIRECT_PEER_ADDR_LSB(x) (((uint32_t)(((uint32_t)(x)) << GENFSK_DIRECT_PEER_ADDR_LSB_DIRECT_PEER_ADDR_LSB_SHIFT)) & GENFSK_DIRECT_PEER_ADDR_LSB_DIRECT_PEER_ADDR_LSB_MASK)
/*! @} */

/*! @name GTM_CFG - GTM MODE CONFIGURATION */
/*! @{ */

#define GENFSK_GTM_CFG_GTM_PKT_NUM_MASK          (0xFFFU)
#define GENFSK_GTM_CFG_GTM_PKT_NUM_SHIFT         (0U)
/*! GTM_PKT_NUM - GTM MODE PACKET NUMBER
 */
#define GENFSK_GTM_CFG_GTM_PKT_NUM(x)            (((uint32_t)(((uint32_t)(x)) << GENFSK_GTM_CFG_GTM_PKT_NUM_SHIFT)) & GENFSK_GTM_CFG_GTM_PKT_NUM_MASK)

#define GENFSK_GTM_CFG_GTM_PDU_TYPE_MASK         (0xF000000U)
#define GENFSK_GTM_CFG_GTM_PDU_TYPE_SHIFT        (24U)
/*! GTM_PDU_TYPE - GTM MODE PDU TYPE SELECTION
 *  0b0000..PRBS9 Sequence
 *  0b0001..Programmable 8-bit Pattern (from register GTM_PDU[7:0], reused from MACSHORTADDRS1[7:0])
 *  0b0010..PRBS-13 Sequence
 *  0b0011..PRBS-15 Sequence
 *  0b0100..Programmable 32-bit Pattern (from register GTM_PDU[31:0], reused from {MACSHORTADDRS1,MACPANID1})
 *  0b0101..Programmable packet from Packet RAM (in this case, PKT_LEN is ignored)
 */
#define GENFSK_GTM_CFG_GTM_PDU_TYPE(x)           (((uint32_t)(((uint32_t)(x)) << GENFSK_GTM_CFG_GTM_PDU_TYPE_SHIFT)) & GENFSK_GTM_CFG_GTM_PDU_TYPE_MASK)

#define GENFSK_GTM_CFG_GTM_IPD_CHECK_DIS_MASK    (0x40000000U)
#define GENFSK_GTM_CFG_GTM_IPD_CHECK_DIS_SHIFT   (30U)
/*! GTM_IPD_CHECK_DIS - GTM MODE INTER-PACKET DURATION CHECK DISABLE
 */
#define GENFSK_GTM_CFG_GTM_IPD_CHECK_DIS(x)      (((uint32_t)(((uint32_t)(x)) << GENFSK_GTM_CFG_GTM_IPD_CHECK_DIS_SHIFT)) & GENFSK_GTM_CFG_GTM_IPD_CHECK_DIS_MASK)

#define GENFSK_GTM_CFG_GTM_PKT_COUNT_CHECK_DIS_MASK (0x80000000U)
#define GENFSK_GTM_CFG_GTM_PKT_COUNT_CHECK_DIS_SHIFT (31U)
/*! GTM_PKT_COUNT_CHECK_DIS - GTM MODE PACKET NUMBER CHECK DISABLE
 */
#define GENFSK_GTM_CFG_GTM_PKT_COUNT_CHECK_DIS(x) (((uint32_t)(((uint32_t)(x)) << GENFSK_GTM_CFG_GTM_PKT_COUNT_CHECK_DIS_SHIFT)) & GENFSK_GTM_CFG_GTM_PKT_COUNT_CHECK_DIS_MASK)
/*! @} */

/*! @name MACLONGADDRS1_LSB - MAC LONG ADDRESS 1 LSB */
/*! @{ */

#define GENFSK_MACLONGADDRS1_LSB_MACLONGADDRS1_LSB_MASK (0xFFFFFFFFU)
#define GENFSK_MACLONGADDRS1_LSB_MACLONGADDRS1_LSB_SHIFT (0U)
/*! MACLONGADDRS1_LSB - MAC LONG ADDRESS for PAN1 LSB
 */
#define GENFSK_MACLONGADDRS1_LSB_MACLONGADDRS1_LSB(x) (((uint32_t)(((uint32_t)(x)) << GENFSK_MACLONGADDRS1_LSB_MACLONGADDRS1_LSB_SHIFT)) & GENFSK_MACLONGADDRS1_LSB_MACLONGADDRS1_LSB_MASK)
/*! @} */

/*! @name DIRECT_PEER_ADDR_MSB - DIRECT_PEER_ADDR[47:32] */
/*! @{ */

#define GENFSK_DIRECT_PEER_ADDR_MSB_DIRECT_PEER_ADDR_MSB_MASK (0xFFFFU)
#define GENFSK_DIRECT_PEER_ADDR_MSB_DIRECT_PEER_ADDR_MSB_SHIFT (0U)
#define GENFSK_DIRECT_PEER_ADDR_MSB_DIRECT_PEER_ADDR_MSB(x) (((uint32_t)(((uint32_t)(x)) << GENFSK_DIRECT_PEER_ADDR_MSB_DIRECT_PEER_ADDR_MSB_SHIFT)) & GENFSK_DIRECT_PEER_ADDR_MSB_DIRECT_PEER_ADDR_MSB_MASK)

#define GENFSK_DIRECT_PEER_ADDR_MSB_DIRECT_PEER_ADDR_TYPE_MASK (0x80000000U)
#define GENFSK_DIRECT_PEER_ADDR_MSB_DIRECT_PEER_ADDR_TYPE_SHIFT (31U)
/*! DIRECT_PEER_ADDR_TYPE
 *  0b0..Direct peer device address type is public.
 *  0b1..Direct peer device address type is random.
 */
#define GENFSK_DIRECT_PEER_ADDR_MSB_DIRECT_PEER_ADDR_TYPE(x) (((uint32_t)(((uint32_t)(x)) << GENFSK_DIRECT_PEER_ADDR_MSB_DIRECT_PEER_ADDR_TYPE_SHIFT)) & GENFSK_DIRECT_PEER_ADDR_MSB_DIRECT_PEER_ADDR_TYPE_MASK)
/*! @} */

/*! @name GTM_IPD - GTM MODE INTER-PACKET DURATION */
/*! @{ */

#define GENFSK_GTM_IPD_GTM_IPD_MASK              (0xFFFFFU)
#define GENFSK_GTM_IPD_GTM_IPD_SHIFT             (0U)
/*! GTM_IPD - GTM MODE INTER-PACKET DURATION
 */
#define GENFSK_GTM_IPD_GTM_IPD(x)                (((uint32_t)(((uint32_t)(x)) << GENFSK_GTM_IPD_GTM_IPD_SHIFT)) & GENFSK_GTM_IPD_GTM_IPD_MASK)
/*! @} */

/*! @name MACLONGADDRS1_MSB - MAC LONG ADDRESS 1 MSB */
/*! @{ */

#define GENFSK_MACLONGADDRS1_MSB_MACLONGADDRS1_MSB_MASK (0xFFFFFFFFU)
#define GENFSK_MACLONGADDRS1_MSB_MACLONGADDRS1_MSB_SHIFT (0U)
/*! MACLONGADDRS1_MSB - MAC LONG ADDRESS for PAN1 MSB
 */
#define GENFSK_MACLONGADDRS1_MSB_MACLONGADDRS1_MSB(x) (((uint32_t)(((uint32_t)(x)) << GENFSK_MACLONGADDRS1_MSB_MACLONGADDRS1_MSB_SHIFT)) & GENFSK_MACLONGADDRS1_MSB_MACLONGADDRS1_MSB_MASK)
/*! @} */

/*! @name CHANNEL_NUM1 - CHANNEL NUMBER 1 */
/*! @{ */

#define GENFSK_CHANNEL_NUM1_CHANNEL_NUM1_MASK    (0x7FU)
#define GENFSK_CHANNEL_NUM1_CHANNEL_NUM1_SHIFT   (0U)
/*! CHANNEL_NUM1 - Channel Number for PAN1
 */
#define GENFSK_CHANNEL_NUM1_CHANNEL_NUM1(x)      (((uint32_t)(((uint32_t)(x)) << GENFSK_CHANNEL_NUM1_CHANNEL_NUM1_SHIFT)) & GENFSK_CHANNEL_NUM1_CHANNEL_NUM1_MASK)
/*! @} */

/*! @name MACSHORTADDRS0 - MAC SHORT ADDRESS 0 */
/*! @{ */

#define GENFSK_MACSHORTADDRS0_MACPANID0_MASK     (0xFFFFU)
#define GENFSK_MACSHORTADDRS0_MACPANID0_SHIFT    (0U)
/*! MACPANID0 - MAC PAN ID for PAN0
 */
#define GENFSK_MACSHORTADDRS0_MACPANID0(x)       (((uint32_t)(((uint32_t)(x)) << GENFSK_MACSHORTADDRS0_MACPANID0_SHIFT)) & GENFSK_MACSHORTADDRS0_MACPANID0_MASK)

#define GENFSK_MACSHORTADDRS0_MACSHORTADDRS0_MASK (0xFFFF0000U)
#define GENFSK_MACSHORTADDRS0_MACSHORTADDRS0_SHIFT (16U)
/*! MACSHORTADDRS0 - MAC SHORT ADDRESS FOR PAN0
 */
#define GENFSK_MACSHORTADDRS0_MACSHORTADDRS0(x)  (((uint32_t)(((uint32_t)(x)) << GENFSK_MACSHORTADDRS0_MACSHORTADDRS0_SHIFT)) & GENFSK_MACSHORTADDRS0_MACSHORTADDRS0_MASK)
/*! @} */

/*! @name WL_VALID_ENTRY0 - VALID ENTRY OF WHITE LIST 0 */
/*! @{ */

#define GENFSK_WL_VALID_ENTRY0_WL_VALID_ENTRY0_MASK (0xFFFFFFFFU)
#define GENFSK_WL_VALID_ENTRY0_WL_VALID_ENTRY0_SHIFT (0U)
#define GENFSK_WL_VALID_ENTRY0_WL_VALID_ENTRY0(x) (((uint32_t)(((uint32_t)(x)) << GENFSK_WL_VALID_ENTRY0_WL_VALID_ENTRY0_SHIFT)) & GENFSK_WL_VALID_ENTRY0_WL_VALID_ENTRY0_MASK)
/*! @} */

/*! @name GTM_FIRST_SFD2WD - GTM MODE TIME OF FIRST SFD FOUND TO FORCE RX WARMDOWN */
/*! @{ */

#define GENFSK_GTM_FIRST_SFD2WD_GTM_FIRST_SFD2WD_MASK (0xFFFFFU)
#define GENFSK_GTM_FIRST_SFD2WD_GTM_FIRST_SFD2WD_SHIFT (0U)
/*! GTM_FIRST_SFD2WD - GTM MODE TIME OF FIRST SFD FOUND TO FORCE RX WARMDOWN
 */
#define GENFSK_GTM_FIRST_SFD2WD_GTM_FIRST_SFD2WD(x) (((uint32_t)(((uint32_t)(x)) << GENFSK_GTM_FIRST_SFD2WD_GTM_FIRST_SFD2WD_SHIFT)) & GENFSK_GTM_FIRST_SFD2WD_GTM_FIRST_SFD2WD_MASK)
/*! @} */

/*! @name MACLONGADDRS0_LSB - MAC LONG ADDRESS 0 LSB */
/*! @{ */

#define GENFSK_MACLONGADDRS0_LSB_MACLONGADDRS0_LSB_MASK (0xFFFFFFFFU)
#define GENFSK_MACLONGADDRS0_LSB_MACLONGADDRS0_LSB_SHIFT (0U)
/*! MACLONGADDRS0_LSB - MAC LONG ADDRESS for PAN0 LSB
 */
#define GENFSK_MACLONGADDRS0_LSB_MACLONGADDRS0_LSB(x) (((uint32_t)(((uint32_t)(x)) << GENFSK_MACLONGADDRS0_LSB_MACLONGADDRS0_LSB_SHIFT)) & GENFSK_MACLONGADDRS0_LSB_MACLONGADDRS0_LSB_MASK)
/*! @} */

/*! @name WL_SEARCH_ADDR_LSB - WL_SEARCH_ADDR[31:0] */
/*! @{ */

#define GENFSK_WL_SEARCH_ADDR_LSB_WL_SEARCH_ADDR_LSB_MASK (0xFFFFFFFFU)
#define GENFSK_WL_SEARCH_ADDR_LSB_WL_SEARCH_ADDR_LSB_SHIFT (0U)
#define GENFSK_WL_SEARCH_ADDR_LSB_WL_SEARCH_ADDR_LSB(x) (((uint32_t)(((uint32_t)(x)) << GENFSK_WL_SEARCH_ADDR_LSB_WL_SEARCH_ADDR_LSB_SHIFT)) & GENFSK_WL_SEARCH_ADDR_LSB_WL_SEARCH_ADDR_LSB_MASK)
/*! @} */

/*! @name GTM_RX_RECYCLE_TIME - GTM MODE RX RECYCLE TIME */
/*! @{ */

#define GENFSK_GTM_RX_RECYCLE_TIME_GTM_RX_RECYCLE_TIME_MASK (0xFFFFFU)
#define GENFSK_GTM_RX_RECYCLE_TIME_GTM_RX_RECYCLE_TIME_SHIFT (0U)
/*! GTM_RX_RECYCLE_TIME - GTM MODE RX RECYCLE TIME
 */
#define GENFSK_GTM_RX_RECYCLE_TIME_GTM_RX_RECYCLE_TIME(x) (((uint32_t)(((uint32_t)(x)) << GENFSK_GTM_RX_RECYCLE_TIME_GTM_RX_RECYCLE_TIME_SHIFT)) & GENFSK_GTM_RX_RECYCLE_TIME_GTM_RX_RECYCLE_TIME_MASK)
/*! @} */

/*! @name MACLONGADDRS0_MSB - MAC LONG ADDRESS 0 MSB */
/*! @{ */

#define GENFSK_MACLONGADDRS0_MSB_MACLONGADDRS0_MSB_MASK (0xFFFFFFFFU)
#define GENFSK_MACLONGADDRS0_MSB_MACLONGADDRS0_MSB_SHIFT (0U)
/*! MACLONGADDRS0_MSB - MAC LONG ADDRESS for PAN0 MSB
 */
#define GENFSK_MACLONGADDRS0_MSB_MACLONGADDRS0_MSB(x) (((uint32_t)(((uint32_t)(x)) << GENFSK_MACLONGADDRS0_MSB_MACLONGADDRS0_MSB_SHIFT)) & GENFSK_MACLONGADDRS0_MSB_MACLONGADDRS0_MSB_MASK)
/*! @} */

/*! @name WL_SEARCH_ADDR_MSB - WL_SEARCH_ADDR[47:32] */
/*! @{ */

#define GENFSK_WL_SEARCH_ADDR_MSB_WL_SEARCH_ADDR_MSB_MASK (0xFFFFU)
#define GENFSK_WL_SEARCH_ADDR_MSB_WL_SEARCH_ADDR_MSB_SHIFT (0U)
#define GENFSK_WL_SEARCH_ADDR_MSB_WL_SEARCH_ADDR_MSB(x) (((uint32_t)(((uint32_t)(x)) << GENFSK_WL_SEARCH_ADDR_MSB_WL_SEARCH_ADDR_MSB_SHIFT)) & GENFSK_WL_SEARCH_ADDR_MSB_WL_SEARCH_ADDR_MSB_MASK)

#define GENFSK_WL_SEARCH_ADDR_MSB_WL_SEARCH_ADDR_TYPE_MASK (0x80000000U)
#define GENFSK_WL_SEARCH_ADDR_MSB_WL_SEARCH_ADDR_TYPE_SHIFT (31U)
/*! WL_SEARCH_ADDR_TYPE
 *  0b0..The address type is public.
 *  0b1..The address type is random.
 */
#define GENFSK_WL_SEARCH_ADDR_MSB_WL_SEARCH_ADDR_TYPE(x) (((uint32_t)(((uint32_t)(x)) << GENFSK_WL_SEARCH_ADDR_MSB_WL_SEARCH_ADDR_TYPE_SHIFT)) & GENFSK_WL_SEARCH_ADDR_MSB_WL_SEARCH_ADDR_TYPE_MASK)
/*! @} */

/*! @name CCA_LQI_CTRL - CCA AND LQI CONTROL */
/*! @{ */

#define GENFSK_CCA_LQI_CTRL_CCABFRTX_MASK        (0x1U)
#define GENFSK_CCA_LQI_CTRL_CCABFRTX_SHIFT       (0U)
/*! CCABFRTX - CCA Before TX
 *  0b0..no CCA required, transmit operation begins immediately.
 *  0b1..at least one CCA measurement is required prior to the transmit operation (see also SLOTTED).
 */
#define GENFSK_CCA_LQI_CTRL_CCABFRTX(x)          (((uint32_t)(((uint32_t)(x)) << GENFSK_CCA_LQI_CTRL_CCABFRTX_SHIFT)) & GENFSK_CCA_LQI_CTRL_CCABFRTX_MASK)

#define GENFSK_CCA_LQI_CTRL_SIMUL_CCA_RX_MASK    (0x2U)
#define GENFSK_CCA_LQI_CTRL_SIMUL_CCA_RX_SHIFT   (1U)
/*! SIMUL_CCA_RX - Simultaneous CCA and Receive Enable
 *  0b0..Packets can't be received during CCA measurement
 *  0b1..Packet reception is enabled during CCA measurement if preamble and SFD are detected
 */
#define GENFSK_CCA_LQI_CTRL_SIMUL_CCA_RX(x)      (((uint32_t)(((uint32_t)(x)) << GENFSK_CCA_LQI_CTRL_SIMUL_CCA_RX_SHIFT)) & GENFSK_CCA_LQI_CTRL_SIMUL_CCA_RX_MASK)

#define GENFSK_CCA_LQI_CTRL_CCA_MASK             (0x80U)
#define GENFSK_CCA_LQI_CTRL_CCA_SHIFT            (7U)
/*! CCA - CCA Status
 *  0b0..IDLE
 *  0b1..BUSY
 */
#define GENFSK_CCA_LQI_CTRL_CCA(x)               (((uint32_t)(((uint32_t)(x)) << GENFSK_CCA_LQI_CTRL_CCA_SHIFT)) & GENFSK_CCA_LQI_CTRL_CCA_MASK)

#define GENFSK_CCA_LQI_CTRL_CCA1_THRESH_MASK     (0xFF00U)
#define GENFSK_CCA_LQI_CTRL_CCA1_THRESH_SHIFT    (8U)
/*! CCA1_THRESH - CCA Mode 1 Threshold
 */
#define GENFSK_CCA_LQI_CTRL_CCA1_THRESH(x)       (((uint32_t)(((uint32_t)(x)) << GENFSK_CCA_LQI_CTRL_CCA1_THRESH_SHIFT)) & GENFSK_CCA_LQI_CTRL_CCA1_THRESH_MASK)

#define GENFSK_CCA_LQI_CTRL_CCA1_ED_FNL_MASK     (0xFF0000U)
#define GENFSK_CCA_LQI_CTRL_CCA1_ED_FNL_SHIFT    (16U)
/*! CCA1_ED_FNL - Final Result for CCA Mode 1 and Energy Detect
 */
#define GENFSK_CCA_LQI_CTRL_CCA1_ED_FNL(x)       (((uint32_t)(((uint32_t)(x)) << GENFSK_CCA_LQI_CTRL_CCA1_ED_FNL_SHIFT)) & GENFSK_CCA_LQI_CTRL_CCA1_ED_FNL_MASK)
/*! @} */

/*! @name WARMUP_TIME - TX/RX WARMUP TIME */
/*! @{ */

#define GENFSK_WARMUP_TIME_RX_WARMUP_MASK        (0xFFU)
#define GENFSK_WARMUP_TIME_RX_WARMUP_SHIFT       (0U)
/*! RX_WARMUP - Receive Warmup Time
 */
#define GENFSK_WARMUP_TIME_RX_WARMUP(x)          (((uint32_t)(((uint32_t)(x)) << GENFSK_WARMUP_TIME_RX_WARMUP_SHIFT)) & GENFSK_WARMUP_TIME_RX_WARMUP_MASK)

#define GENFSK_WARMUP_TIME_TX_WARMUP_MASK        (0xFF0000U)
#define GENFSK_WARMUP_TIME_TX_WARMUP_SHIFT       (16U)
/*! TX_WARMUP - Transmit Warmup Time
 */
#define GENFSK_WARMUP_TIME_TX_WARMUP(x)          (((uint32_t)(((uint32_t)(x)) << GENFSK_WARMUP_TIME_TX_WARMUP_SHIFT)) & GENFSK_WARMUP_TIME_TX_WARMUP_MASK)
/*! @} */

/*! @name RXEN_DLY - RX_EN Delay Time */
/*! @{ */

#define GENFSK_RXEN_DLY_RXEN_DLY_MASK            (0x3FFU)
#define GENFSK_RXEN_DLY_RXEN_DLY_SHIFT           (0U)
#define GENFSK_RXEN_DLY_RXEN_DLY(x)              (((uint32_t)(((uint32_t)(x)) << GENFSK_RXEN_DLY_RXEN_DLY_SHIFT)) & GENFSK_RXEN_DLY_RXEN_DLY_MASK)

#define GENFSK_RXEN_DLY_RXEN_DLY_OVERRIDE_MASK   (0x80000000U)
#define GENFSK_RXEN_DLY_RXEN_DLY_OVERRIDE_SHIFT  (31U)
/*! RXEN_DLY_OVERRIDE
 *  0b0..For Bluetooth LE case, RX_EN signal will delay to de-assert accroding to the length of TERM2 or CTE(when
 *       BLE_V5P1_CTE_EN is enabled) field parsed by hardware
 *  0b1..For all receive case, RX_EN signal will delay to de-assert accroding to register RXEN_DLY[9:0].
 */
#define GENFSK_RXEN_DLY_RXEN_DLY_OVERRIDE(x)     (((uint32_t)(((uint32_t)(x)) << GENFSK_RXEN_DLY_RXEN_DLY_OVERRIDE_SHIFT)) & GENFSK_RXEN_DLY_RXEN_DLY_OVERRIDE_MASK)
/*! @} */

/*! @name SAM_CTRL - SAM CONTROL */
/*! @{ */

#define GENFSK_SAM_CTRL_SAP0_EN_MASK             (0x1U)
#define GENFSK_SAM_CTRL_SAP0_EN_SHIFT            (0U)
/*! SAP0_EN - Enables SAP0 Partition of the SAM Table
 *  0b0..Disables SAP0 Partition
 *  0b1..Enables SAP0 Partition
 */
#define GENFSK_SAM_CTRL_SAP0_EN(x)               (((uint32_t)(((uint32_t)(x)) << GENFSK_SAM_CTRL_SAP0_EN_SHIFT)) & GENFSK_SAM_CTRL_SAP0_EN_MASK)

#define GENFSK_SAM_CTRL_SAA0_EN_MASK             (0x2U)
#define GENFSK_SAM_CTRL_SAA0_EN_SHIFT            (1U)
/*! SAA0_EN - Enables SAA0 Partition of the SAM Table
 *  0b0..Disables SAA0 Partition
 *  0b1..Enables SAA0 Partition
 */
#define GENFSK_SAM_CTRL_SAA0_EN(x)               (((uint32_t)(((uint32_t)(x)) << GENFSK_SAM_CTRL_SAA0_EN_SHIFT)) & GENFSK_SAM_CTRL_SAA0_EN_MASK)

#define GENFSK_SAM_CTRL_SAP1_EN_MASK             (0x4U)
#define GENFSK_SAM_CTRL_SAP1_EN_SHIFT            (2U)
/*! SAP1_EN - Enables SAP1 Partition of the SAM Table
 *  0b0..Disables SAP1 Partition
 *  0b1..Enables SAP1 Partition
 */
#define GENFSK_SAM_CTRL_SAP1_EN(x)               (((uint32_t)(((uint32_t)(x)) << GENFSK_SAM_CTRL_SAP1_EN_SHIFT)) & GENFSK_SAM_CTRL_SAP1_EN_MASK)

#define GENFSK_SAM_CTRL_SAA1_EN_MASK             (0x8U)
#define GENFSK_SAM_CTRL_SAA1_EN_SHIFT            (3U)
/*! SAA1_EN - Enables SAA1 Partition of the SAM Table
 *  0b0..Disables SAA1 Partition
 *  0b1..Enables SAA1 Partition
 */
#define GENFSK_SAM_CTRL_SAA1_EN(x)               (((uint32_t)(((uint32_t)(x)) << GENFSK_SAM_CTRL_SAA1_EN_SHIFT)) & GENFSK_SAM_CTRL_SAA1_EN_MASK)

#define GENFSK_SAM_CTRL_SAA0_START_MASK          (0xFF00U)
#define GENFSK_SAM_CTRL_SAA0_START_SHIFT         (8U)
/*! SAA0_START - First Index of SAA0 partition
 */
#define GENFSK_SAM_CTRL_SAA0_START(x)            (((uint32_t)(((uint32_t)(x)) << GENFSK_SAM_CTRL_SAA0_START_SHIFT)) & GENFSK_SAM_CTRL_SAA0_START_MASK)

#define GENFSK_SAM_CTRL_SAP1_START_MASK          (0xFF0000U)
#define GENFSK_SAM_CTRL_SAP1_START_SHIFT         (16U)
/*! SAP1_START - First Index of SAP1 partition
 */
#define GENFSK_SAM_CTRL_SAP1_START(x)            (((uint32_t)(((uint32_t)(x)) << GENFSK_SAM_CTRL_SAP1_START_SHIFT)) & GENFSK_SAM_CTRL_SAP1_START_MASK)

#define GENFSK_SAM_CTRL_SAA1_START_MASK          (0xFF000000U)
#define GENFSK_SAM_CTRL_SAA1_START_SHIFT         (24U)
/*! SAA1_START - First Index of SAA1 partition
 */
#define GENFSK_SAM_CTRL_SAA1_START(x)            (((uint32_t)(((uint32_t)(x)) << GENFSK_SAM_CTRL_SAA1_START_SHIFT)) & GENFSK_SAM_CTRL_SAA1_START_MASK)
/*! @} */

/*! @name SAM_TABLE - SOURCE ADDRESS MANAGEMENT TABLE */
/*! @{ */

#define GENFSK_SAM_TABLE_SAM_INDEX_MASK          (0x7FU)
#define GENFSK_SAM_TABLE_SAM_INDEX_SHIFT         (0U)
/*! SAM_INDEX - Contains the SAM table index to be enabled or invalidated
 */
#define GENFSK_SAM_TABLE_SAM_INDEX(x)            (((uint32_t)(((uint32_t)(x)) << GENFSK_SAM_TABLE_SAM_INDEX_SHIFT)) & GENFSK_SAM_TABLE_SAM_INDEX_MASK)

#define GENFSK_SAM_TABLE_SAM_INDEX_WR_MASK       (0x80U)
#define GENFSK_SAM_TABLE_SAM_INDEX_WR_SHIFT      (7U)
/*! SAM_INDEX_WR - Enables SAM Table Contents to be updated
 */
#define GENFSK_SAM_TABLE_SAM_INDEX_WR(x)         (((uint32_t)(((uint32_t)(x)) << GENFSK_SAM_TABLE_SAM_INDEX_WR_SHIFT)) & GENFSK_SAM_TABLE_SAM_INDEX_WR_MASK)

#define GENFSK_SAM_TABLE_SAM_CHECKSUM_MASK       (0xFFFF00U)
#define GENFSK_SAM_TABLE_SAM_CHECKSUM_SHIFT      (8U)
/*! SAM_CHECKSUM - Software-computed source address checksum, to be installed into a table index
 */
#define GENFSK_SAM_TABLE_SAM_CHECKSUM(x)         (((uint32_t)(((uint32_t)(x)) << GENFSK_SAM_TABLE_SAM_CHECKSUM_SHIFT)) & GENFSK_SAM_TABLE_SAM_CHECKSUM_MASK)

#define GENFSK_SAM_TABLE_SAM_INDEX_INV_MASK      (0x1000000U)
#define GENFSK_SAM_TABLE_SAM_INDEX_INV_SHIFT     (24U)
/*! SAM_INDEX_INV - Invalidate the SAM table index selected by SAM_INDEX
 */
#define GENFSK_SAM_TABLE_SAM_INDEX_INV(x)        (((uint32_t)(((uint32_t)(x)) << GENFSK_SAM_TABLE_SAM_INDEX_INV_SHIFT)) & GENFSK_SAM_TABLE_SAM_INDEX_INV_MASK)

#define GENFSK_SAM_TABLE_SAM_INDEX_EN_MASK       (0x2000000U)
#define GENFSK_SAM_TABLE_SAM_INDEX_EN_SHIFT      (25U)
/*! SAM_INDEX_EN - Enable the SAM table index selected by SAM_INDEX
 */
#define GENFSK_SAM_TABLE_SAM_INDEX_EN(x)         (((uint32_t)(((uint32_t)(x)) << GENFSK_SAM_TABLE_SAM_INDEX_EN_SHIFT)) & GENFSK_SAM_TABLE_SAM_INDEX_EN_MASK)

#define GENFSK_SAM_TABLE_ACK_FRM_PND_MASK        (0x4000000U)
#define GENFSK_SAM_TABLE_ACK_FRM_PND_SHIFT       (26U)
/*! ACK_FRM_PND - State of AutoTxAck FramePending field when SAM Accelleration is Disabled
 */
#define GENFSK_SAM_TABLE_ACK_FRM_PND(x)          (((uint32_t)(((uint32_t)(x)) << GENFSK_SAM_TABLE_ACK_FRM_PND_SHIFT)) & GENFSK_SAM_TABLE_ACK_FRM_PND_MASK)

#define GENFSK_SAM_TABLE_ACK_FRM_PND_CTRL_MASK   (0x8000000U)
#define GENFSK_SAM_TABLE_ACK_FRM_PND_CTRL_SHIFT  (27U)
/*! ACK_FRM_PND_CTRL - Manual Control for AutoTxAck FramePending field
 *  0b0..the FramePending field of the Frame Control Field of the next automatic TX acknowledge packet is determined by hardware
 *  0b1..the FramePending field of the Frame Control Field of the next automatic TX acknowledge packet tracks ACK_FRM_PEND
 */
#define GENFSK_SAM_TABLE_ACK_FRM_PND_CTRL(x)     (((uint32_t)(((uint32_t)(x)) << GENFSK_SAM_TABLE_ACK_FRM_PND_CTRL_SHIFT)) & GENFSK_SAM_TABLE_ACK_FRM_PND_CTRL_MASK)

#define GENFSK_SAM_TABLE_FIND_FREE_IDX_MASK      (0x10000000U)
#define GENFSK_SAM_TABLE_FIND_FREE_IDX_SHIFT     (28U)
/*! FIND_FREE_IDX - Find First Free Index
 */
#define GENFSK_SAM_TABLE_FIND_FREE_IDX(x)        (((uint32_t)(((uint32_t)(x)) << GENFSK_SAM_TABLE_FIND_FREE_IDX_SHIFT)) & GENFSK_SAM_TABLE_FIND_FREE_IDX_MASK)

#define GENFSK_SAM_TABLE_INVALIDATE_ALL_MASK     (0x20000000U)
#define GENFSK_SAM_TABLE_INVALIDATE_ALL_SHIFT    (29U)
/*! INVALIDATE_ALL - Invalidate Entire SAM Table
 */
#define GENFSK_SAM_TABLE_INVALIDATE_ALL(x)       (((uint32_t)(((uint32_t)(x)) << GENFSK_SAM_TABLE_INVALIDATE_ALL_SHIFT)) & GENFSK_SAM_TABLE_INVALIDATE_ALL_MASK)

#define GENFSK_SAM_TABLE_SRCADDR_MASK            (0x40000000U)
#define GENFSK_SAM_TABLE_SRCADDR_SHIFT           (30U)
/*! SRCADDR - Source Address Match Status
 */
#define GENFSK_SAM_TABLE_SRCADDR(x)              (((uint32_t)(((uint32_t)(x)) << GENFSK_SAM_TABLE_SRCADDR_SHIFT)) & GENFSK_SAM_TABLE_SRCADDR_MASK)

#define GENFSK_SAM_TABLE_SAM_BUSY_MASK           (0x80000000U)
#define GENFSK_SAM_TABLE_SAM_BUSY_SHIFT          (31U)
/*! SAM_BUSY - SAM Table Update Status Bit
 */
#define GENFSK_SAM_TABLE_SAM_BUSY(x)             (((uint32_t)(((uint32_t)(x)) << GENFSK_SAM_TABLE_SAM_BUSY_SHIFT)) & GENFSK_SAM_TABLE_SAM_BUSY_MASK)
/*! @} */

/*! @name SAM_MATCH - SOURCE ADDRESS MANAGEMENT MATCH */
/*! @{ */

#define GENFSK_SAM_MATCH_SAP0_MATCH_MASK         (0x7FU)
#define GENFSK_SAM_MATCH_SAP0_MATCH_SHIFT        (0U)
/*! SAP0_MATCH - Index in the SAP0 Partition of the SAM Table corresponding to the first checksum match
 */
#define GENFSK_SAM_MATCH_SAP0_MATCH(x)           (((uint32_t)(((uint32_t)(x)) << GENFSK_SAM_MATCH_SAP0_MATCH_SHIFT)) & GENFSK_SAM_MATCH_SAP0_MATCH_MASK)

#define GENFSK_SAM_MATCH_SAP0_ADDR_PRESENT_MASK  (0x80U)
#define GENFSK_SAM_MATCH_SAP0_ADDR_PRESENT_SHIFT (7U)
/*! SAP0_ADDR_PRESENT - A Checksum Match is Present in the SAP0 Partition of the SAM Table
 */
#define GENFSK_SAM_MATCH_SAP0_ADDR_PRESENT(x)    (((uint32_t)(((uint32_t)(x)) << GENFSK_SAM_MATCH_SAP0_ADDR_PRESENT_SHIFT)) & GENFSK_SAM_MATCH_SAP0_ADDR_PRESENT_MASK)

#define GENFSK_SAM_MATCH_SAA0_MATCH_MASK         (0x7F00U)
#define GENFSK_SAM_MATCH_SAA0_MATCH_SHIFT        (8U)
/*! SAA0_MATCH - Index in the SAA0 Partition of the SAM Table corresponding to the first checksum match
 */
#define GENFSK_SAM_MATCH_SAA0_MATCH(x)           (((uint32_t)(((uint32_t)(x)) << GENFSK_SAM_MATCH_SAA0_MATCH_SHIFT)) & GENFSK_SAM_MATCH_SAA0_MATCH_MASK)

#define GENFSK_SAM_MATCH_SAA0_ADDR_ABSENT_MASK   (0x8000U)
#define GENFSK_SAM_MATCH_SAA0_ADDR_ABSENT_SHIFT  (15U)
/*! SAA0_ADDR_ABSENT - A Checksum Match is Absent in the SAA0 Partition of the SAM Table
 */
#define GENFSK_SAM_MATCH_SAA0_ADDR_ABSENT(x)     (((uint32_t)(((uint32_t)(x)) << GENFSK_SAM_MATCH_SAA0_ADDR_ABSENT_SHIFT)) & GENFSK_SAM_MATCH_SAA0_ADDR_ABSENT_MASK)

#define GENFSK_SAM_MATCH_SAP1_MATCH_MASK         (0x7F0000U)
#define GENFSK_SAM_MATCH_SAP1_MATCH_SHIFT        (16U)
/*! SAP1_MATCH - Index in the SAP1 Partition of the SAM Table corresponding to the first checksum match
 */
#define GENFSK_SAM_MATCH_SAP1_MATCH(x)           (((uint32_t)(((uint32_t)(x)) << GENFSK_SAM_MATCH_SAP1_MATCH_SHIFT)) & GENFSK_SAM_MATCH_SAP1_MATCH_MASK)

#define GENFSK_SAM_MATCH_SAP1_ADDR_PRESENT_MASK  (0x800000U)
#define GENFSK_SAM_MATCH_SAP1_ADDR_PRESENT_SHIFT (23U)
/*! SAP1_ADDR_PRESENT - A Checksum Match is Present in the SAP1 Partition of the SAM Table
 */
#define GENFSK_SAM_MATCH_SAP1_ADDR_PRESENT(x)    (((uint32_t)(((uint32_t)(x)) << GENFSK_SAM_MATCH_SAP1_ADDR_PRESENT_SHIFT)) & GENFSK_SAM_MATCH_SAP1_ADDR_PRESENT_MASK)

#define GENFSK_SAM_MATCH_SAA1_MATCH_MASK         (0x7F000000U)
#define GENFSK_SAM_MATCH_SAA1_MATCH_SHIFT        (24U)
/*! SAA1_MATCH - Index in the SAA1 Partition of the SAM Table corresponding to the first checksum match
 */
#define GENFSK_SAM_MATCH_SAA1_MATCH(x)           (((uint32_t)(((uint32_t)(x)) << GENFSK_SAM_MATCH_SAA1_MATCH_SHIFT)) & GENFSK_SAM_MATCH_SAA1_MATCH_MASK)

#define GENFSK_SAM_MATCH_SAA1_ADDR_ABSENT_MASK   (0x80000000U)
#define GENFSK_SAM_MATCH_SAA1_ADDR_ABSENT_SHIFT  (31U)
/*! SAA1_ADDR_ABSENT - A Checksum Match is Absent in the SAP1 Partition of the SAM Table
 */
#define GENFSK_SAM_MATCH_SAA1_ADDR_ABSENT(x)     (((uint32_t)(((uint32_t)(x)) << GENFSK_SAM_MATCH_SAA1_ADDR_ABSENT_SHIFT)) & GENFSK_SAM_MATCH_SAA1_ADDR_ABSENT_MASK)
/*! @} */

/*! @name SAM_FREE_IDX - SAM FREE INDEX */
/*! @{ */

#define GENFSK_SAM_FREE_IDX_SAP0_1ST_FREE_IDX_MASK (0xFFU)
#define GENFSK_SAM_FREE_IDX_SAP0_1ST_FREE_IDX_SHIFT (0U)
/*! SAP0_1ST_FREE_IDX - First non-enabled (invalid) index in the SAP0 partition
 */
#define GENFSK_SAM_FREE_IDX_SAP0_1ST_FREE_IDX(x) (((uint32_t)(((uint32_t)(x)) << GENFSK_SAM_FREE_IDX_SAP0_1ST_FREE_IDX_SHIFT)) & GENFSK_SAM_FREE_IDX_SAP0_1ST_FREE_IDX_MASK)

#define GENFSK_SAM_FREE_IDX_SAA0_1ST_FREE_IDX_MASK (0xFF00U)
#define GENFSK_SAM_FREE_IDX_SAA0_1ST_FREE_IDX_SHIFT (8U)
/*! SAA0_1ST_FREE_IDX - First non-enabled (invalid) index in the SAA0 partition
 */
#define GENFSK_SAM_FREE_IDX_SAA0_1ST_FREE_IDX(x) (((uint32_t)(((uint32_t)(x)) << GENFSK_SAM_FREE_IDX_SAA0_1ST_FREE_IDX_SHIFT)) & GENFSK_SAM_FREE_IDX_SAA0_1ST_FREE_IDX_MASK)

#define GENFSK_SAM_FREE_IDX_SAP1_1ST_FREE_IDX_MASK (0xFF0000U)
#define GENFSK_SAM_FREE_IDX_SAP1_1ST_FREE_IDX_SHIFT (16U)
/*! SAP1_1ST_FREE_IDX - First non-enabled (invalid) index in the SAP1 partition
 */
#define GENFSK_SAM_FREE_IDX_SAP1_1ST_FREE_IDX(x) (((uint32_t)(((uint32_t)(x)) << GENFSK_SAM_FREE_IDX_SAP1_1ST_FREE_IDX_SHIFT)) & GENFSK_SAM_FREE_IDX_SAP1_1ST_FREE_IDX_MASK)

#define GENFSK_SAM_FREE_IDX_SAA1_1ST_FREE_IDX_MASK (0xFF000000U)
#define GENFSK_SAM_FREE_IDX_SAA1_1ST_FREE_IDX_SHIFT (24U)
/*! SAA1_1ST_FREE_IDX - First non-enabled (invalid) index in the SAA1 partition
 */
#define GENFSK_SAM_FREE_IDX_SAA1_1ST_FREE_IDX(x) (((uint32_t)(((uint32_t)(x)) << GENFSK_SAM_FREE_IDX_SAA1_1ST_FREE_IDX_SHIFT)) & GENFSK_SAM_FREE_IDX_SAA1_1ST_FREE_IDX_MASK)
/*! @} */

/*! @name MISC1 - MISCELLANEOUS(1) */
/*! @{ */

#define GENFSK_MISC1_SRC_ADDR_CHECKSUM_MASK      (0xFFFFU)
#define GENFSK_MISC1_SRC_ADDR_CHECKSUM_SHIFT     (0U)
/*! SRC_ADDR_CHECKSUM - Hardware-computed received source address checksum
 */
#define GENFSK_MISC1_SRC_ADDR_CHECKSUM(x)        (((uint32_t)(((uint32_t)(x)) << GENFSK_MISC1_SRC_ADDR_CHECKSUM_SHIFT)) & GENFSK_MISC1_SRC_ADDR_CHECKSUM_MASK)

#define GENFSK_MISC1_SW_ABORTED_MASK             (0x10000U)
#define GENFSK_MISC1_SW_ABORTED_SHIFT            (16U)
/*! SW_ABORTED - Autosequence has terminated due to a Software abort.
 */
#define GENFSK_MISC1_SW_ABORTED(x)               (((uint32_t)(((uint32_t)(x)) << GENFSK_MISC1_SW_ABORTED_SHIFT)) & GENFSK_MISC1_SW_ABORTED_MASK)

#define GENFSK_MISC1_PLL_ABORTED_MASK            (0x20000U)
#define GENFSK_MISC1_PLL_ABORTED_SHIFT           (17U)
/*! PLL_ABORTED - Autosequence has terminated due to an PLL unlock event.
 */
#define GENFSK_MISC1_PLL_ABORTED(x)              (((uint32_t)(((uint32_t)(x)) << GENFSK_MISC1_PLL_ABORTED_SHIFT)) & GENFSK_MISC1_PLL_ABORTED_MASK)

#define GENFSK_MISC1_EXT_ABORTED_MASK            (0x40000U)
#define GENFSK_MISC1_EXT_ABORTED_SHIFT           (18U)
/*! EXT_ABORTED - Autosequence has terminated due to a Wake-On-Radio command
 */
#define GENFSK_MISC1_EXT_ABORTED(x)              (((uint32_t)(((uint32_t)(x)) << GENFSK_MISC1_EXT_ABORTED_SHIFT)) & GENFSK_MISC1_EXT_ABORTED_MASK)

#define GENFSK_MISC1_ARB_GRANT_DEASSERTION_ABORTED_MASK (0x80000U)
#define GENFSK_MISC1_ARB_GRANT_DEASSERTION_ABORTED_SHIFT (19U)
/*! ARB_GRANT_DEASSERTION_ABORTED - Autosequence has terminated due to an arb_grant deassertion event
 */
#define GENFSK_MISC1_ARB_GRANT_DEASSERTION_ABORTED(x) (((uint32_t)(((uint32_t)(x)) << GENFSK_MISC1_ARB_GRANT_DEASSERTION_ABORTED_SHIFT)) & GENFSK_MISC1_ARB_GRANT_DEASSERTION_ABORTED_MASK)

#define GENFSK_MISC1_FAST_TX_WU_OVRD_MASK        (0x10000000U)
#define GENFSK_MISC1_FAST_TX_WU_OVRD_SHIFT       (28U)
/*! FAST_TX_WU_OVRD - FAST_TX_WU override
 *  0b0..If TSM enables Fast Warmup Capability, LL will request it when TX in RT or (CCA+TX)
 *  0b1..If TSM enables Fast Warmup Capability, LL will request it at every TX. User should insure channel is not changed since last sequence.
 */
#define GENFSK_MISC1_FAST_TX_WU_OVRD(x)          (((uint32_t)(((uint32_t)(x)) << GENFSK_MISC1_FAST_TX_WU_OVRD_SHIFT)) & GENFSK_MISC1_FAST_TX_WU_OVRD_MASK)

#define GENFSK_MISC1_FAST_RX_WU_OVRD_MASK        (0x20000000U)
#define GENFSK_MISC1_FAST_RX_WU_OVRD_SHIFT       (29U)
/*! FAST_RX_WU_OVRD - FAST_RX_WU override
 *  0b0..If TSM enables Fast Warmup Capability, LL will request it when RX in TR
 *  0b1..If TSM enables Fast Warmup Capability, LL will request it at every RX. User should insure channel is not changed since last sequence.
 */
#define GENFSK_MISC1_FAST_RX_WU_OVRD(x)          (((uint32_t)(((uint32_t)(x)) << GENFSK_MISC1_FAST_RX_WU_OVRD_SHIFT)) & GENFSK_MISC1_FAST_RX_WU_OVRD_MASK)

#define GENFSK_MISC1_PI_MASK                     (0x40000000U)
#define GENFSK_MISC1_PI_SHIFT                    (30U)
/*! PI - Poll Indication
 *  0b0..the received packet was not a data request
 *  0b1..the received packet was a data request, regardless of whether a Source Address table match occurred, or
 *       whether Source Address Management is enabled or not
 */
#define GENFSK_MISC1_PI(x)                       (((uint32_t)(((uint32_t)(x)) << GENFSK_MISC1_PI_SHIFT)) & GENFSK_MISC1_PI_MASK)

#define GENFSK_MISC1_RX_FRM_PEND_MASK            (0x80000000U)
#define GENFSK_MISC1_RX_FRM_PEND_SHIFT           (31U)
/*! RX_FRM_PEND - RX Frame Pending
 */
#define GENFSK_MISC1_RX_FRM_PEND(x)              (((uint32_t)(((uint32_t)(x)) << GENFSK_MISC1_RX_FRM_PEND_SHIFT)) & GENFSK_MISC1_RX_FRM_PEND_MASK)
/*! @} */

/*! @name SEQ_STS - SEQUENCE STATUS */
/*! @{ */

#define GENFSK_SEQ_STS_TX_START_T1_PEND_MASK     (0x1U)
#define GENFSK_SEQ_STS_TX_START_T1_PEND_SHIFT    (0U)
/*! TX_START_T1_PEND - TX T1 Start Pending Status
 */
#define GENFSK_SEQ_STS_TX_START_T1_PEND(x)       (((uint32_t)(((uint32_t)(x)) << GENFSK_SEQ_STS_TX_START_T1_PEND_SHIFT)) & GENFSK_SEQ_STS_TX_START_T1_PEND_MASK)

#define GENFSK_SEQ_STS_TX_START_T2_PEND_MASK     (0x2U)
#define GENFSK_SEQ_STS_TX_START_T2_PEND_SHIFT    (1U)
/*! TX_START_T2_PEND - TX T2 Start Pending Status
 */
#define GENFSK_SEQ_STS_TX_START_T2_PEND(x)       (((uint32_t)(((uint32_t)(x)) << GENFSK_SEQ_STS_TX_START_T2_PEND_SHIFT)) & GENFSK_SEQ_STS_TX_START_T2_PEND_MASK)

#define GENFSK_SEQ_STS_TX_IN_WARMUP_MASK         (0x4U)
#define GENFSK_SEQ_STS_TX_IN_WARMUP_SHIFT        (2U)
/*! TX_IN_WARMUP - TX Warmup Status
 */
#define GENFSK_SEQ_STS_TX_IN_WARMUP(x)           (((uint32_t)(((uint32_t)(x)) << GENFSK_SEQ_STS_TX_IN_WARMUP_SHIFT)) & GENFSK_SEQ_STS_TX_IN_WARMUP_MASK)

#define GENFSK_SEQ_STS_TX_IN_PROGRESS_MASK       (0x8U)
#define GENFSK_SEQ_STS_TX_IN_PROGRESS_SHIFT      (3U)
/*! TX_IN_PROGRESS - TX in Progress Status
 */
#define GENFSK_SEQ_STS_TX_IN_PROGRESS(x)         (((uint32_t)(((uint32_t)(x)) << GENFSK_SEQ_STS_TX_IN_PROGRESS_SHIFT)) & GENFSK_SEQ_STS_TX_IN_PROGRESS_MASK)

#define GENFSK_SEQ_STS_TX_IN_WARMDN_MASK         (0x10U)
#define GENFSK_SEQ_STS_TX_IN_WARMDN_SHIFT        (4U)
/*! TX_IN_WARMDN - TX Warmdown Status
 */
#define GENFSK_SEQ_STS_TX_IN_WARMDN(x)           (((uint32_t)(((uint32_t)(x)) << GENFSK_SEQ_STS_TX_IN_WARMDN_SHIFT)) & GENFSK_SEQ_STS_TX_IN_WARMDN_MASK)

#define GENFSK_SEQ_STS_RX_START_T1_PEND_MASK     (0x20U)
#define GENFSK_SEQ_STS_RX_START_T1_PEND_SHIFT    (5U)
/*! RX_START_T1_PEND - RX T1 Start Pending Status
 */
#define GENFSK_SEQ_STS_RX_START_T1_PEND(x)       (((uint32_t)(((uint32_t)(x)) << GENFSK_SEQ_STS_RX_START_T1_PEND_SHIFT)) & GENFSK_SEQ_STS_RX_START_T1_PEND_MASK)

#define GENFSK_SEQ_STS_RX_START_T2_PEND_MASK     (0x40U)
#define GENFSK_SEQ_STS_RX_START_T2_PEND_SHIFT    (6U)
/*! RX_START_T2_PEND - RX T2 Start Pending Status
 */
#define GENFSK_SEQ_STS_RX_START_T2_PEND(x)       (((uint32_t)(((uint32_t)(x)) << GENFSK_SEQ_STS_RX_START_T2_PEND_SHIFT)) & GENFSK_SEQ_STS_RX_START_T2_PEND_MASK)

#define GENFSK_SEQ_STS_RX_STOP_T1_PEND_MASK      (0x80U)
#define GENFSK_SEQ_STS_RX_STOP_T1_PEND_SHIFT     (7U)
/*! RX_STOP_T1_PEND - RX T1 Stop Pending Status
 */
#define GENFSK_SEQ_STS_RX_STOP_T1_PEND(x)        (((uint32_t)(((uint32_t)(x)) << GENFSK_SEQ_STS_RX_STOP_T1_PEND_SHIFT)) & GENFSK_SEQ_STS_RX_STOP_T1_PEND_MASK)

#define GENFSK_SEQ_STS_RX_STOP_T2_PEND_MASK      (0x100U)
#define GENFSK_SEQ_STS_RX_STOP_T2_PEND_SHIFT     (8U)
/*! RX_STOP_T2_PEND - RX T2 Start Pending Status
 */
#define GENFSK_SEQ_STS_RX_STOP_T2_PEND(x)        (((uint32_t)(((uint32_t)(x)) << GENFSK_SEQ_STS_RX_STOP_T2_PEND_SHIFT)) & GENFSK_SEQ_STS_RX_STOP_T2_PEND_MASK)

#define GENFSK_SEQ_STS_RX_IN_WARMUP_MASK         (0x200U)
#define GENFSK_SEQ_STS_RX_IN_WARMUP_SHIFT        (9U)
/*! RX_IN_WARMUP - RX Warmup Status
 */
#define GENFSK_SEQ_STS_RX_IN_WARMUP(x)           (((uint32_t)(((uint32_t)(x)) << GENFSK_SEQ_STS_RX_IN_WARMUP_SHIFT)) & GENFSK_SEQ_STS_RX_IN_WARMUP_MASK)

#define GENFSK_SEQ_STS_RX_IN_SEARCH_MASK         (0x400U)
#define GENFSK_SEQ_STS_RX_IN_SEARCH_SHIFT        (10U)
/*! RX_IN_SEARCH - RX Search Status
 */
#define GENFSK_SEQ_STS_RX_IN_SEARCH(x)           (((uint32_t)(((uint32_t)(x)) << GENFSK_SEQ_STS_RX_IN_SEARCH_SHIFT)) & GENFSK_SEQ_STS_RX_IN_SEARCH_MASK)

#define GENFSK_SEQ_STS_RX_IN_PROGRESS_MASK       (0x800U)
#define GENFSK_SEQ_STS_RX_IN_PROGRESS_SHIFT      (11U)
/*! RX_IN_PROGRESS - RX in Progress Status
 */
#define GENFSK_SEQ_STS_RX_IN_PROGRESS(x)         (((uint32_t)(((uint32_t)(x)) << GENFSK_SEQ_STS_RX_IN_PROGRESS_SHIFT)) & GENFSK_SEQ_STS_RX_IN_PROGRESS_MASK)

#define GENFSK_SEQ_STS_RX_IN_WARMDN_MASK         (0x1000U)
#define GENFSK_SEQ_STS_RX_IN_WARMDN_SHIFT        (12U)
/*! RX_IN_WARMDN - RX Warmdown Status
 */
#define GENFSK_SEQ_STS_RX_IN_WARMDN(x)           (((uint32_t)(((uint32_t)(x)) << GENFSK_SEQ_STS_RX_IN_WARMDN_SHIFT)) & GENFSK_SEQ_STS_RX_IN_WARMDN_MASK)

#define GENFSK_SEQ_STS_TR_START_T1_PEND_MASK     (0x2000U)
#define GENFSK_SEQ_STS_TR_START_T1_PEND_SHIFT    (13U)
/*! TR_START_T1_PEND - TR T1 Start Pending Status
 */
#define GENFSK_SEQ_STS_TR_START_T1_PEND(x)       (((uint32_t)(((uint32_t)(x)) << GENFSK_SEQ_STS_TR_START_T1_PEND_SHIFT)) & GENFSK_SEQ_STS_TR_START_T1_PEND_MASK)

#define GENFSK_SEQ_STS_TR_START_T2_PEND_MASK     (0x4000U)
#define GENFSK_SEQ_STS_TR_START_T2_PEND_SHIFT    (14U)
/*! TR_START_T2_PEND - TR T2 Start Pending Status
 */
#define GENFSK_SEQ_STS_TR_START_T2_PEND(x)       (((uint32_t)(((uint32_t)(x)) << GENFSK_SEQ_STS_TR_START_T2_PEND_SHIFT)) & GENFSK_SEQ_STS_TR_START_T2_PEND_MASK)

#define GENFSK_SEQ_STS_CCA_START_T1_PEND_MASK    (0x8000U)
#define GENFSK_SEQ_STS_CCA_START_T1_PEND_SHIFT   (15U)
/*! CCA_START_T1_PEND - CCA T1 Start Pending Status
 */
#define GENFSK_SEQ_STS_CCA_START_T1_PEND(x)      (((uint32_t)(((uint32_t)(x)) << GENFSK_SEQ_STS_CCA_START_T1_PEND_SHIFT)) & GENFSK_SEQ_STS_CCA_START_T1_PEND_MASK)

#define GENFSK_SEQ_STS_CCA_START_T2_PEND_MASK    (0x10000U)
#define GENFSK_SEQ_STS_CCA_START_T2_PEND_SHIFT   (16U)
/*! CCA_START_T2_PEND - CCA T2 Start Pending Status
 */
#define GENFSK_SEQ_STS_CCA_START_T2_PEND(x)      (((uint32_t)(((uint32_t)(x)) << GENFSK_SEQ_STS_CCA_START_T2_PEND_SHIFT)) & GENFSK_SEQ_STS_CCA_START_T2_PEND_MASK)

#define GENFSK_SEQ_STS_SEQ_T_STATUS_MASK         (0x1F000000U)
#define GENFSK_SEQ_STS_SEQ_T_STATUS_SHIFT        (24U)
/*! SEQ_T_STATUS - Status of the just-completed or ongoing Sequence T or Sequence TR
 */
#define GENFSK_SEQ_STS_SEQ_T_STATUS(x)           (((uint32_t)(((uint32_t)(x)) << GENFSK_SEQ_STS_SEQ_T_STATUS_SHIFT)) & GENFSK_SEQ_STS_SEQ_T_STATUS_MASK)
/*! @} */

/*! @name PHR_MISC - PHR MISCELLANEOUS */
/*! @{ */

#define GENFSK_PHR_MISC_SUNFSK_MS_MASK           (0x1U)
#define GENFSK_PHR_MISC_SUNFSK_MS_SHIFT          (0U)
/*! SUNFSK_MS - Mode Switch Bit
 */
#define GENFSK_PHR_MISC_SUNFSK_MS(x)             (((uint32_t)(((uint32_t)(x)) << GENFSK_PHR_MISC_SUNFSK_MS_SHIFT)) & GENFSK_PHR_MISC_SUNFSK_MS_MASK)

#define GENFSK_PHR_MISC_SUNFSK_MSP_MASK          (0x6U)
#define GENFSK_PHR_MISC_SUNFSK_MSP_SHIFT         (1U)
/*! SUNFSK_MSP - Mode Switch Parameter Bit
 */
#define GENFSK_PHR_MISC_SUNFSK_MSP(x)            (((uint32_t)(((uint32_t)(x)) << GENFSK_PHR_MISC_SUNFSK_MSP_SHIFT)) & GENFSK_PHR_MISC_SUNFSK_MSP_MASK)

#define GENFSK_PHR_MISC_SUNFSK_FEC_MASK          (0x8U)
#define GENFSK_PHR_MISC_SUNFSK_FEC_SHIFT         (3U)
/*! SUNFSK_FEC - New Mode FEC Bit
 */
#define GENFSK_PHR_MISC_SUNFSK_FEC(x)            (((uint32_t)(((uint32_t)(x)) << GENFSK_PHR_MISC_SUNFSK_FEC_SHIFT)) & GENFSK_PHR_MISC_SUNFSK_FEC_MASK)

#define GENFSK_PHR_MISC_SUNFSK_NM_MASK           (0x7F0U)
#define GENFSK_PHR_MISC_SUNFSK_NM_SHIFT          (4U)
/*! SUNFSK_NM - New Mode Bit
 */
#define GENFSK_PHR_MISC_SUNFSK_NM(x)             (((uint32_t)(((uint32_t)(x)) << GENFSK_PHR_MISC_SUNFSK_NM_SHIFT)) & GENFSK_PHR_MISC_SUNFSK_NM_MASK)

#define GENFSK_PHR_MISC_PHR_FAIL_IGNORE_MASK     (0x1000000U)
#define GENFSK_PHR_MISC_PHR_FAIL_IGNORE_SHIFT    (24U)
/*! PHR_FAIL_IGNORE - Ignore PHR Fail
 */
#define GENFSK_PHR_MISC_PHR_FAIL_IGNORE(x)       (((uint32_t)(((uint32_t)(x)) << GENFSK_PHR_MISC_PHR_FAIL_IGNORE_SHIFT)) & GENFSK_PHR_MISC_PHR_FAIL_IGNORE_MASK)
/*! @} */

/*! @name GTM_CTRL - GTM CONTROL */
/*! @{ */

#define GENFSK_GTM_CTRL_GTM_IN_RX_MASK           (0x1U)
#define GENFSK_GTM_CTRL_GTM_IN_RX_SHIFT          (0U)
/*! GTM_IN_RX - Enable GTM Receive Mode
 *  0b0..GTM receive mode is not enabled.
 *  0b1..GTM receive mode is enabled.
 */
#define GENFSK_GTM_CTRL_GTM_IN_RX(x)             (((uint32_t)(((uint32_t)(x)) << GENFSK_GTM_CTRL_GTM_IN_RX_SHIFT)) & GENFSK_GTM_CTRL_GTM_IN_RX_MASK)

#define GENFSK_GTM_CTRL_GTM_IN_TX_MASK           (0x2U)
#define GENFSK_GTM_CTRL_GTM_IN_TX_SHIFT          (1U)
/*! GTM_IN_TX - Enable GTM Transmit Mode
 *  0b0..GTM transmit mode is not enabled.
 *  0b1..GTM transmit mode is enabled.
 */
#define GENFSK_GTM_CTRL_GTM_IN_TX(x)             (((uint32_t)(((uint32_t)(x)) << GENFSK_GTM_CTRL_GTM_IN_TX_SHIFT)) & GENFSK_GTM_CTRL_GTM_IN_TX_MASK)
/*! @} */

/*! @name GTM_BAD_CNT - GTM BAD PACKET COUNTER */
/*! @{ */

#define GENFSK_GTM_BAD_CNT_GTM_BAD_PKT_COUNT_MASK (0x1FFFU)
#define GENFSK_GTM_BAD_CNT_GTM_BAD_PKT_COUNT_SHIFT (0U)
/*! GTM_BAD_PKT_COUNT - GTM Bad Packet Counter
 */
#define GENFSK_GTM_BAD_CNT_GTM_BAD_PKT_COUNT(x)  (((uint32_t)(((uint32_t)(x)) << GENFSK_GTM_BAD_CNT_GTM_BAD_PKT_COUNT_SHIFT)) & GENFSK_GTM_BAD_CNT_GTM_BAD_PKT_COUNT_MASK)
/*! @} */

/*! @name GTM_GOOD_CNT - GTM GOOD PACKET COUNTER */
/*! @{ */

#define GENFSK_GTM_GOOD_CNT_GTM_GOOD_PKT_COUNT_MASK (0x1FFFU)
#define GENFSK_GTM_GOOD_CNT_GTM_GOOD_PKT_COUNT_SHIFT (0U)
/*! GTM_GOOD_PKT_COUNT - GTM Good Packet Counter
 */
#define GENFSK_GTM_GOOD_CNT_GTM_GOOD_PKT_COUNT(x) (((uint32_t)(((uint32_t)(x)) << GENFSK_GTM_GOOD_CNT_GTM_GOOD_PKT_COUNT_SHIFT)) & GENFSK_GTM_GOOD_CNT_GTM_GOOD_PKT_COUNT_MASK)
/*! @} */

/*! @name GTM_PKT_CNT - GTM PACKET COUNTER */
/*! @{ */

#define GENFSK_GTM_PKT_CNT_GTM_PKT_COUNT_MASK    (0x1FFFU)
#define GENFSK_GTM_PKT_CNT_GTM_PKT_COUNT_SHIFT   (0U)
/*! GTM_PKT_COUNT - GTM Packet Counter
 */
#define GENFSK_GTM_PKT_CNT_GTM_PKT_COUNT(x)      (((uint32_t)(((uint32_t)(x)) << GENFSK_GTM_PKT_CNT_GTM_PKT_COUNT_SHIFT)) & GENFSK_GTM_PKT_CNT_GTM_PKT_COUNT_MASK)
/*! @} */

/*! @name COEX_CTRL - COEXISTENCE CONTROL */
/*! @{ */

#define GENFSK_COEX_CTRL_COEX_EN_MASK            (0x1U)
#define GENFSK_COEX_CTRL_COEX_EN_SHIFT           (0U)
/*! COEX_EN - Coexistence Enable
 *  0b0..Coexistence function is disabled.
 *  0b1..Coexistence function is enabled.
 */
#define GENFSK_COEX_CTRL_COEX_EN(x)              (((uint32_t)(((uint32_t)(x)) << GENFSK_COEX_CTRL_COEX_EN_SHIFT)) & GENFSK_COEX_CTRL_COEX_EN_MASK)

#define GENFSK_COEX_CTRL_COEX_REQ_DELAY_EN_MASK  (0x2U)
#define GENFSK_COEX_CTRL_COEX_REQ_DELAY_EN_SHIFT (1U)
/*! COEX_REQ_DELAY_EN - Coexistence Request Delay Enable
 *  0b0..arb_request is not delayed during R sequence.
 *  0b1..arb_request is delayed until preamble or Access Address is detected during R sequence.
 */
#define GENFSK_COEX_CTRL_COEX_REQ_DELAY_EN(x)    (((uint32_t)(((uint32_t)(x)) << GENFSK_COEX_CTRL_COEX_REQ_DELAY_EN_SHIFT)) & GENFSK_COEX_CTRL_COEX_REQ_DELAY_EN_MASK)

#define GENFSK_COEX_CTRL_COEX_REQ_ON_PD_MASK     (0x4U)
#define GENFSK_COEX_CTRL_COEX_REQ_ON_PD_SHIFT    (2U)
/*! COEX_REQ_ON_PD - Coexistence Request on Preamble detected
 *  0b0..arb_request is delayed until Access Address is detected during R sequence.
 *  0b1..arb_request is delayed until preamble is detected during R sequence.
 */
#define GENFSK_COEX_CTRL_COEX_REQ_ON_PD(x)       (((uint32_t)(((uint32_t)(x)) << GENFSK_COEX_CTRL_COEX_REQ_ON_PD_SHIFT)) & GENFSK_COEX_CTRL_COEX_REQ_ON_PD_MASK)

#define GENFSK_COEX_CTRL_COEX_TIMEOUT_MASK       (0xFF00U)
#define GENFSK_COEX_CTRL_COEX_TIMEOUT_SHIFT      (8U)
/*! COEX_TIMEOUT - Coexistence timeout value
 */
#define GENFSK_COEX_CTRL_COEX_TIMEOUT(x)         (((uint32_t)(((uint32_t)(x)) << GENFSK_COEX_CTRL_COEX_TIMEOUT_SHIFT)) & GENFSK_COEX_CTRL_COEX_TIMEOUT_MASK)
/*! @} */

/*! @name COEX_PRIORITY - COEXISTENCE PRIORITY */
/*! @{ */

#define GENFSK_COEX_PRIORITY_PRIORITY_T_MASK     (0x3U)
#define GENFSK_COEX_PRIORITY_PRIORITY_T_SHIFT    (0U)
/*! PRIORITY_T - PRIORITY_T
 */
#define GENFSK_COEX_PRIORITY_PRIORITY_T(x)       (((uint32_t)(((uint32_t)(x)) << GENFSK_COEX_PRIORITY_PRIORITY_T_SHIFT)) & GENFSK_COEX_PRIORITY_PRIORITY_T_MASK)

#define GENFSK_COEX_PRIORITY_PRIORITY_R_PRE_MASK (0xCU)
#define GENFSK_COEX_PRIORITY_PRIORITY_R_PRE_SHIFT (2U)
/*! PRIORITY_R_PRE - PRIORITY_R_PRE
 */
#define GENFSK_COEX_PRIORITY_PRIORITY_R_PRE(x)   (((uint32_t)(((uint32_t)(x)) << GENFSK_COEX_PRIORITY_PRIORITY_R_PRE_SHIFT)) & GENFSK_COEX_PRIORITY_PRIORITY_R_PRE_MASK)

#define GENFSK_COEX_PRIORITY_PRIORITY_R_PKT_MASK (0x30U)
#define GENFSK_COEX_PRIORITY_PRIORITY_R_PKT_SHIFT (4U)
/*! PRIORITY_R_PKT - PRIORITY_R_PKT
 */
#define GENFSK_COEX_PRIORITY_PRIORITY_R_PKT(x)   (((uint32_t)(((uint32_t)(x)) << GENFSK_COEX_PRIORITY_PRIORITY_R_PKT_SHIFT)) & GENFSK_COEX_PRIORITY_PRIORITY_R_PKT_MASK)

#define GENFSK_COEX_PRIORITY_PRIORITY_TACK_MASK  (0xC0U)
#define GENFSK_COEX_PRIORITY_PRIORITY_TACK_SHIFT (6U)
/*! PRIORITY_TACK - PRIORITY_TACK
 */
#define GENFSK_COEX_PRIORITY_PRIORITY_TACK(x)    (((uint32_t)(((uint32_t)(x)) << GENFSK_COEX_PRIORITY_PRIORITY_TACK_SHIFT)) & GENFSK_COEX_PRIORITY_PRIORITY_TACK_MASK)

#define GENFSK_COEX_PRIORITY_PRIORITY_CCA_MASK   (0x300U)
#define GENFSK_COEX_PRIORITY_PRIORITY_CCA_SHIFT  (8U)
/*! PRIORITY_CCA - PRIORITY_CCA
 */
#define GENFSK_COEX_PRIORITY_PRIORITY_CCA(x)     (((uint32_t)(((uint32_t)(x)) << GENFSK_COEX_PRIORITY_PRIORITY_CCA_SHIFT)) & GENFSK_COEX_PRIORITY_PRIORITY_CCA_MASK)

#define GENFSK_COEX_PRIORITY_PRIORITY_CTX_MASK   (0x3000U)
#define GENFSK_COEX_PRIORITY_PRIORITY_CTX_SHIFT  (12U)
/*! PRIORITY_CTX - PRIORITY_CT
 */
#define GENFSK_COEX_PRIORITY_PRIORITY_CTX(x)     (((uint32_t)(((uint32_t)(x)) << GENFSK_COEX_PRIORITY_PRIORITY_CTX_SHIFT)) & GENFSK_COEX_PRIORITY_PRIORITY_CTX_MASK)

#define GENFSK_COEX_PRIORITY_PRIORITY_RACK_PRE_MASK (0xC000U)
#define GENFSK_COEX_PRIORITY_PRIORITY_RACK_PRE_SHIFT (14U)
/*! PRIORITY_RACK_PRE - PRIORITY_RACK_PRE
 */
#define GENFSK_COEX_PRIORITY_PRIORITY_RACK_PRE(x) (((uint32_t)(((uint32_t)(x)) << GENFSK_COEX_PRIORITY_PRIORITY_RACK_PRE_SHIFT)) & GENFSK_COEX_PRIORITY_PRIORITY_RACK_PRE_MASK)

#define GENFSK_COEX_PRIORITY_PRIORITY_RACK_PKT_MASK (0x30000U)
#define GENFSK_COEX_PRIORITY_PRIORITY_RACK_PKT_SHIFT (16U)
/*! PRIORITY_RACK_PKT - PRIORITY_RACK_PKT
 */
#define GENFSK_COEX_PRIORITY_PRIORITY_RACK_PKT(x) (((uint32_t)(((uint32_t)(x)) << GENFSK_COEX_PRIORITY_PRIORITY_RACK_PKT_SHIFT)) & GENFSK_COEX_PRIORITY_PRIORITY_RACK_PKT_MASK)

#define GENFSK_COEX_PRIORITY_PRIORITY_OVRD_MASK  (0x60000000U)
#define GENFSK_COEX_PRIORITY_PRIORITY_OVRD_SHIFT (29U)
/*! PRIORITY_OVRD - PRIORITY_OVRD
 */
#define GENFSK_COEX_PRIORITY_PRIORITY_OVRD(x)    (((uint32_t)(((uint32_t)(x)) << GENFSK_COEX_PRIORITY_PRIORITY_OVRD_SHIFT)) & GENFSK_COEX_PRIORITY_PRIORITY_OVRD_MASK)

#define GENFSK_COEX_PRIORITY_PRIORITY_OVRD_EN_MASK (0x80000000U)
#define GENFSK_COEX_PRIORITY_PRIORITY_OVRD_EN_SHIFT (31U)
/*! PRIORITY_OVRD_EN - PRIORITY_OVRD_EN
 *  0b0..Disable overriding PRIORITY value.
 *  0b1..Enable overriding PRIORITY value.
 */
#define GENFSK_COEX_PRIORITY_PRIORITY_OVRD_EN(x) (((uint32_t)(((uint32_t)(x)) << GENFSK_COEX_PRIORITY_PRIORITY_OVRD_EN_SHIFT)) & GENFSK_COEX_PRIORITY_PRIORITY_OVRD_EN_MASK)
/*! @} */

/*! @name IRQ_CTRL2 - IRQ CONTROL 2 */
/*! @{ */

#define GENFSK_IRQ_CTRL2_ARB_GRANT_DEASSERTION_IRQ_MASK (0x1U)
#define GENFSK_IRQ_CTRL2_ARB_GRANT_DEASSERTION_IRQ_SHIFT (0U)
/*! ARB_GRANT_DEASSERTION_IRQ - arb_grant Deassertion IRQ
 *  0b0..An arb_grant Deassertion Interrupt has not occurred
 *  0b1..An arb_grant Deassertion Interrupt has occurred
 */
#define GENFSK_IRQ_CTRL2_ARB_GRANT_DEASSERTION_IRQ(x) (((uint32_t)(((uint32_t)(x)) << GENFSK_IRQ_CTRL2_ARB_GRANT_DEASSERTION_IRQ_SHIFT)) & GENFSK_IRQ_CTRL2_ARB_GRANT_DEASSERTION_IRQ_MASK)

#define GENFSK_IRQ_CTRL2_COEX_TIMEOUT_IRQ_MASK   (0x2U)
#define GENFSK_IRQ_CTRL2_COEX_TIMEOUT_IRQ_SHIFT  (1U)
/*! COEX_TIMEOUT_IRQ - Coexistence Timeout Interrupt
 */
#define GENFSK_IRQ_CTRL2_COEX_TIMEOUT_IRQ(x)     (((uint32_t)(((uint32_t)(x)) << GENFSK_IRQ_CTRL2_COEX_TIMEOUT_IRQ_SHIFT)) & GENFSK_IRQ_CTRL2_COEX_TIMEOUT_IRQ_MASK)

#define GENFSK_IRQ_CTRL2_EVENT_TIMER_OVER_FLOW_IRQ_MASK (0x4U)
#define GENFSK_IRQ_CTRL2_EVENT_TIMER_OVER_FLOW_IRQ_SHIFT (2U)
/*! EVENT_TIMER_OVER_FLOW_IRQ - Event Timer Overflow Interrupt
 */
#define GENFSK_IRQ_CTRL2_EVENT_TIMER_OVER_FLOW_IRQ(x) (((uint32_t)(((uint32_t)(x)) << GENFSK_IRQ_CTRL2_EVENT_TIMER_OVER_FLOW_IRQ_SHIFT)) & GENFSK_IRQ_CTRL2_EVENT_TIMER_OVER_FLOW_IRQ_MASK)

#define GENFSK_IRQ_CTRL2_WL_FAIL_IRQ_MASK        (0x8U)
#define GENFSK_IRQ_CTRL2_WL_FAIL_IRQ_SHIFT       (3U)
/*! WL_FAIL_IRQ - White List Check Fail Interrupt
 */
#define GENFSK_IRQ_CTRL2_WL_FAIL_IRQ(x)          (((uint32_t)(((uint32_t)(x)) << GENFSK_IRQ_CTRL2_WL_FAIL_IRQ_SHIFT)) & GENFSK_IRQ_CTRL2_WL_FAIL_IRQ_MASK)

#define GENFSK_IRQ_CTRL2_DIRECT_ID_FAIL_IRQ_MASK (0x10U)
#define GENFSK_IRQ_CTRL2_DIRECT_ID_FAIL_IRQ_SHIFT (4U)
/*! DIRECT_ID_FAIL_IRQ - Direct Case Check Fail Interrupt
 */
#define GENFSK_IRQ_CTRL2_DIRECT_ID_FAIL_IRQ(x)   (((uint32_t)(((uint32_t)(x)) << GENFSK_IRQ_CTRL2_DIRECT_ID_FAIL_IRQ_SHIFT)) & GENFSK_IRQ_CTRL2_DIRECT_ID_FAIL_IRQ_MASK)

#define GENFSK_IRQ_CTRL2_PEER_RPA_FAIL_IRQ_MASK  (0x20U)
#define GENFSK_IRQ_CTRL2_PEER_RPA_FAIL_IRQ_SHIFT (5U)
/*! PEER_RPA_FAIL_IRQ - Peer RPA Check Fail Interrupt
 */
#define GENFSK_IRQ_CTRL2_PEER_RPA_FAIL_IRQ(x)    (((uint32_t)(((uint32_t)(x)) << GENFSK_IRQ_CTRL2_PEER_RPA_FAIL_IRQ_SHIFT)) & GENFSK_IRQ_CTRL2_PEER_RPA_FAIL_IRQ_MASK)

#define GENFSK_IRQ_CTRL2_LOCAL_RPA_FAIL_IRQ_MASK (0x40U)
#define GENFSK_IRQ_CTRL2_LOCAL_RPA_FAIL_IRQ_SHIFT (6U)
/*! LOCAL_RPA_FAIL_IRQ - Local RPA Check Fail Interrupt
 */
#define GENFSK_IRQ_CTRL2_LOCAL_RPA_FAIL_IRQ(x)   (((uint32_t)(((uint32_t)(x)) << GENFSK_IRQ_CTRL2_LOCAL_RPA_FAIL_IRQ_SHIFT)) & GENFSK_IRQ_CTRL2_LOCAL_RPA_FAIL_IRQ_MASK)

#define GENFSK_IRQ_CTRL2_ARB_GRANT_DEASSERTION_IRQ_EN_MASK (0x10000U)
#define GENFSK_IRQ_CTRL2_ARB_GRANT_DEASSERTION_IRQ_EN_SHIFT (16U)
/*! ARB_GRANT_DEASSERTION_IRQ_EN - arb_grant Deassertion Interrupt enable
 *  0b1..allows arb_grant deassertion event to generate an interrupt
 *  0b0..An arb_grant deassertion event will set the ARB_GRANT_DEASSERTION_IRQ status bit, but no interrupt is not generated
 */
#define GENFSK_IRQ_CTRL2_ARB_GRANT_DEASSERTION_IRQ_EN(x) (((uint32_t)(((uint32_t)(x)) << GENFSK_IRQ_CTRL2_ARB_GRANT_DEASSERTION_IRQ_EN_SHIFT)) & GENFSK_IRQ_CTRL2_ARB_GRANT_DEASSERTION_IRQ_EN_MASK)

#define GENFSK_IRQ_CTRL2_COEX_TIMEOUT_IRQ_EN_MASK (0x20000U)
#define GENFSK_IRQ_CTRL2_COEX_TIMEOUT_IRQ_EN_SHIFT (17U)
/*! COEX_TIMEOUT_IRQ_EN - Coexistence Timeout Interrupt enable bit
 *  0b1..allows interrupt when coexistence timeout
 *  0b0..Interrupt generation is disabled, but a COEX_TIMEOUT_IRQ flag can be set
 */
#define GENFSK_IRQ_CTRL2_COEX_TIMEOUT_IRQ_EN(x)  (((uint32_t)(((uint32_t)(x)) << GENFSK_IRQ_CTRL2_COEX_TIMEOUT_IRQ_EN_SHIFT)) & GENFSK_IRQ_CTRL2_COEX_TIMEOUT_IRQ_EN_MASK)

#define GENFSK_IRQ_CTRL2_EVENT_TIMER_OVER_FLOW_IRQ_EN_MASK (0x40000U)
#define GENFSK_IRQ_CTRL2_EVENT_TIMER_OVER_FLOW_IRQ_EN_SHIFT (18U)
/*! EVENT_TIMER_OVER_FLOW_IRQ_EN - Event Timer Overflow Interrupt enable bit
 *  0b1..allows interrupt when Event Timer overflow
 *  0b0..Interrupt generation is disabled, but an EVENT_TIMER_OVER_FLOW_IRQ flag can be set
 */
#define GENFSK_IRQ_CTRL2_EVENT_TIMER_OVER_FLOW_IRQ_EN(x) (((uint32_t)(((uint32_t)(x)) << GENFSK_IRQ_CTRL2_EVENT_TIMER_OVER_FLOW_IRQ_EN_SHIFT)) & GENFSK_IRQ_CTRL2_EVENT_TIMER_OVER_FLOW_IRQ_EN_MASK)

#define GENFSK_IRQ_CTRL2_WL_FAIL_IRQ_EN_MASK     (0x80000U)
#define GENFSK_IRQ_CTRL2_WL_FAIL_IRQ_EN_SHIFT    (19U)
/*! WL_FAIL_IRQ_EN
 *  0b0..WL_FAIL Interrupt is not enabled.
 *  0b1..WL_FAIL Interrupt is enabled.
 */
#define GENFSK_IRQ_CTRL2_WL_FAIL_IRQ_EN(x)       (((uint32_t)(((uint32_t)(x)) << GENFSK_IRQ_CTRL2_WL_FAIL_IRQ_EN_SHIFT)) & GENFSK_IRQ_CTRL2_WL_FAIL_IRQ_EN_MASK)

#define GENFSK_IRQ_CTRL2_DIRECT_ID_FAIL_IRQ_EN_MASK (0x100000U)
#define GENFSK_IRQ_CTRL2_DIRECT_ID_FAIL_IRQ_EN_SHIFT (20U)
/*! DIRECT_ID_FAIL_IRQ_EN
 *  0b0..DIRECT_ID_FAIL Interrupt is not enabled.
 *  0b1..DIRECT_ID_FAIL Interrupt is enabled.
 */
#define GENFSK_IRQ_CTRL2_DIRECT_ID_FAIL_IRQ_EN(x) (((uint32_t)(((uint32_t)(x)) << GENFSK_IRQ_CTRL2_DIRECT_ID_FAIL_IRQ_EN_SHIFT)) & GENFSK_IRQ_CTRL2_DIRECT_ID_FAIL_IRQ_EN_MASK)

#define GENFSK_IRQ_CTRL2_PEER_RPA_FAIL_IRQ_EN_MASK (0x200000U)
#define GENFSK_IRQ_CTRL2_PEER_RPA_FAIL_IRQ_EN_SHIFT (21U)
/*! PEER_RPA_FAIL_IRQ_EN
 *  0b0..PEER_RPA_FAIL Interrupt is not enabled.
 *  0b1..PEER_RPA_FAIL Interrupt is enabled.
 */
#define GENFSK_IRQ_CTRL2_PEER_RPA_FAIL_IRQ_EN(x) (((uint32_t)(((uint32_t)(x)) << GENFSK_IRQ_CTRL2_PEER_RPA_FAIL_IRQ_EN_SHIFT)) & GENFSK_IRQ_CTRL2_PEER_RPA_FAIL_IRQ_EN_MASK)

#define GENFSK_IRQ_CTRL2_LOCAL_RPA_FAIL_IRQ_EN_MASK (0x400000U)
#define GENFSK_IRQ_CTRL2_LOCAL_RPA_FAIL_IRQ_EN_SHIFT (22U)
/*! LOCAL_RPA_FAIL_IRQ_EN
 *  0b0..LOCAL_RPA_FAIL Interrupt is not enabled.
 *  0b1..LOCAL_RPA_FAIL Interrupt is enabled.
 */
#define GENFSK_IRQ_CTRL2_LOCAL_RPA_FAIL_IRQ_EN(x) (((uint32_t)(((uint32_t)(x)) << GENFSK_IRQ_CTRL2_LOCAL_RPA_FAIL_IRQ_EN_SHIFT)) & GENFSK_IRQ_CTRL2_LOCAL_RPA_FAIL_IRQ_EN_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group GENFSK_Register_Masks */


/* GENFSK - Peripheral instance base addresses */
#if (defined(__ARM_FEATURE_CMSE) && (__ARM_FEATURE_CMSE & 0x2))
  /** Peripheral GENFSK base address */
  #define GENFSK_BASE                              (0x58A02000u)
  /** Peripheral GENFSK base address */
  #define GENFSK_BASE_NS                           (0x48A02000u)
  /** Peripheral GENFSK base pointer */
  #define GENFSK                                   ((GENFSK_Type *)GENFSK_BASE)
  /** Peripheral GENFSK base pointer */
  #define GENFSK_NS                                ((GENFSK_Type *)GENFSK_BASE_NS)
  /** Array initializer of GENFSK peripheral base addresses */
  #define GENFSK_BASE_ADDRS                        { GENFSK_BASE }
  /** Array initializer of GENFSK peripheral base pointers */
  #define GENFSK_BASE_PTRS                         { GENFSK }
  /** Array initializer of GENFSK peripheral base addresses */
  #define GENFSK_BASE_ADDRS_NS                     { GENFSK_BASE_NS }
  /** Array initializer of GENFSK peripheral base pointers */
  #define GENFSK_BASE_PTRS_NS                      { GENFSK_NS }
#else
  /** Peripheral GENFSK base address */
  #define GENFSK_BASE                              (0x48A02000u)
  /** Peripheral GENFSK base pointer */
  #define GENFSK                                   ((GENFSK_Type *)GENFSK_BASE)
  /** Array initializer of GENFSK peripheral base addresses */
  #define GENFSK_BASE_ADDRS                        { GENFSK_BASE }
  /** Array initializer of GENFSK peripheral base pointers */
  #define GENFSK_BASE_PTRS                         { GENFSK }
#endif

/*!
 * @}
 */ /* end of group GENFSK_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- GPIO Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup GPIO_Peripheral_Access_Layer GPIO Peripheral Access Layer
 * @{
 */

/** GPIO - Register Layout Typedef */
typedef struct {
  __I  uint32_t VERID;                             /**< Version ID, offset: 0x0 */
  __I  uint32_t PARAM;                             /**< Parameter, offset: 0x4 */
       uint8_t RESERVED_0[4];
  __IO uint32_t LOCK;                              /**< Lock, offset: 0xC */
  __IO uint32_t PCNS;                              /**< Pin Control Non-Secure, offset: 0x10 */
  __IO uint32_t ICNS;                              /**< Interrupt Control Non-Secure, offset: 0x14 */
  __IO uint32_t PCNP;                              /**< Pin Control Non-Privilege, offset: 0x18 */
  __IO uint32_t ICNP;                              /**< Interrupt Control Non-Privilege, offset: 0x1C */
       uint8_t RESERVED_1[32];
  __IO uint32_t PDOR;                              /**< Port Data Output Register, offset: 0x40 */
  __O  uint32_t PSOR;                              /**< Port Set Output Register, offset: 0x44 */
  __O  uint32_t PCOR;                              /**< Port Clear Output Register, offset: 0x48 */
  __O  uint32_t PTOR;                              /**< Port Toggle Output Register, offset: 0x4C */
  __I  uint32_t PDIR;                              /**< Port Data Input Register, offset: 0x50 */
  __IO uint32_t PDDR;                              /**< Port Data Direction Register, offset: 0x54 */
  __IO uint32_t PIDR;                              /**< Port Input Disable Register, offset: 0x58 */
       uint8_t RESERVED_2[4];
  __IO uint8_t PDR[32];                            /**< Pin Data Register a, array offset: 0x60, array step: 0x1 */
  __IO uint32_t ICR[32];                           /**< Interrupt Control Register 0..Interrupt Control Register 31, array offset: 0x80, array step: 0x4 */
  __O  uint32_t GICLR;                             /**< Global Interrupt Control Low Register, offset: 0x100 */
  __O  uint32_t GICHR;                             /**< Global Interrupt Control High Register, offset: 0x104 */
       uint8_t RESERVED_3[24];
  __IO uint32_t ISFR[2];                           /**< Interrupt Status Flag Register, array offset: 0x120, array step: 0x4 */
} GPIO_Type;

/* ----------------------------------------------------------------------------
   -- GPIO Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup GPIO_Register_Masks GPIO Register Masks
 * @{
 */

/*! @name VERID - Version ID */
/*! @{ */

#define GPIO_VERID_FEATURE_MASK                  (0xFFFFU)
#define GPIO_VERID_FEATURE_SHIFT                 (0U)
/*! FEATURE - Feature Specification Number
 *  0b0000000000000000..Basic implementation.
 *  0b0000000000000001..Protection registers implemented.
 */
#define GPIO_VERID_FEATURE(x)                    (((uint32_t)(((uint32_t)(x)) << GPIO_VERID_FEATURE_SHIFT)) & GPIO_VERID_FEATURE_MASK)

#define GPIO_VERID_MINOR_MASK                    (0xFF0000U)
#define GPIO_VERID_MINOR_SHIFT                   (16U)
/*! MINOR - Minor Version Number
 */
#define GPIO_VERID_MINOR(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_VERID_MINOR_SHIFT)) & GPIO_VERID_MINOR_MASK)

#define GPIO_VERID_MAJOR_MASK                    (0xFF000000U)
#define GPIO_VERID_MAJOR_SHIFT                   (24U)
/*! MAJOR - Major Version Number
 */
#define GPIO_VERID_MAJOR(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_VERID_MAJOR_SHIFT)) & GPIO_VERID_MAJOR_MASK)
/*! @} */

/*! @name PARAM - Parameter */
/*! @{ */

#define GPIO_PARAM_IRQNUM_MASK                   (0xFU)
#define GPIO_PARAM_IRQNUM_SHIFT                  (0U)
/*! IRQNUM - Interrupt Number
 */
#define GPIO_PARAM_IRQNUM(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_PARAM_IRQNUM_SHIFT)) & GPIO_PARAM_IRQNUM_MASK)
/*! @} */

/*! @name LOCK - Lock */
/*! @{ */

#define GPIO_LOCK_PCNS_MASK                      (0x1U)
#define GPIO_LOCK_PCNS_SHIFT                     (0U)
/*! PCNS - Lock PCNS
 *  0b0..PCNS register is writable by software in Secure-Privilege state.
 *  0b1..PCNS register is not writable until the next reset.
 */
#define GPIO_LOCK_PCNS(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_LOCK_PCNS_SHIFT)) & GPIO_LOCK_PCNS_MASK)

#define GPIO_LOCK_ICNS_MASK                      (0x2U)
#define GPIO_LOCK_ICNS_SHIFT                     (1U)
/*! ICNS - Lock ICNS
 *  0b0..ICNS register is writable by software in Secure-Privilege state.
 *  0b1..ICNS register is not writable until the next reset.
 */
#define GPIO_LOCK_ICNS(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_LOCK_ICNS_SHIFT)) & GPIO_LOCK_ICNS_MASK)

#define GPIO_LOCK_PCNP_MASK                      (0x4U)
#define GPIO_LOCK_PCNP_SHIFT                     (2U)
/*! PCNP - Lock PCNP
 *  0b0..PCNP register is writable by software in Secure-Privilege state.
 *  0b1..PCNP register is not writable until the next reset.
 */
#define GPIO_LOCK_PCNP(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_LOCK_PCNP_SHIFT)) & GPIO_LOCK_PCNP_MASK)

#define GPIO_LOCK_ICNP_MASK                      (0x8U)
#define GPIO_LOCK_ICNP_SHIFT                     (3U)
/*! ICNP - Lock ICNP
 *  0b0..ICNP register is writable by software in Secure-Privilege state.
 *  0b1..ICNP register is not writable until the next reset.
 */
#define GPIO_LOCK_ICNP(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_LOCK_ICNP_SHIFT)) & GPIO_LOCK_ICNP_MASK)
/*! @} */

/*! @name PCNS - Pin Control Non-Secure */
/*! @{ */

#define GPIO_PCNS_NSE0_MASK                      (0x1U)
#define GPIO_PCNS_NSE0_SHIFT                     (0U)
/*! NSE0 - Non-Secure Enable
 *  0b0..The pin is configured for Secure access. Read or write access to the corresponding pin's registers and
 *       bit fields is only allowed by software in Secure state. When the corresponding pin's registers are accessed
 *       by software in Non-Secure state, all bits in the registers related to that pin are read zero and write
 *       ignored.
 *  0b1..The pin is configured for Non-Secure access. Read or write access to the corresponding pin's registers
 *       and bit fields is only allowed by software in Non-Secure state. When the corresponding pin's registers are
 *       accessed by software in Secure state, all bits in the registers related to that pin are read zero and write
 *       ignored.
 */
#define GPIO_PCNS_NSE0(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PCNS_NSE0_SHIFT)) & GPIO_PCNS_NSE0_MASK)

#define GPIO_PCNS_NSE1_MASK                      (0x2U)
#define GPIO_PCNS_NSE1_SHIFT                     (1U)
/*! NSE1 - Non-Secure Enable
 *  0b0..The pin is configured for Secure access. Read or write access to the corresponding pin's registers and
 *       bit fields is only allowed by software in Secure state. When the corresponding pin's registers are accessed
 *       by software in Non-Secure state, all bits in the registers related to that pin are read zero and write
 *       ignored.
 *  0b1..The pin is configured for Non-Secure access. Read or write access to the corresponding pin's registers
 *       and bit fields is only allowed by software in Non-Secure state. When the corresponding pin's registers are
 *       accessed by software in Secure state, all bits in the registers related to that pin are read zero and write
 *       ignored.
 */
#define GPIO_PCNS_NSE1(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PCNS_NSE1_SHIFT)) & GPIO_PCNS_NSE1_MASK)

#define GPIO_PCNS_NSE2_MASK                      (0x4U)
#define GPIO_PCNS_NSE2_SHIFT                     (2U)
/*! NSE2 - Non-Secure Enable
 *  0b0..The pin is configured for Secure access. Read or write access to the corresponding pin's registers and
 *       bit fields is only allowed by software in Secure state. When the corresponding pin's registers are accessed
 *       by software in Non-Secure state, all bits in the registers related to that pin are read zero and write
 *       ignored.
 *  0b1..The pin is configured for Non-Secure access. Read or write access to the corresponding pin's registers
 *       and bit fields is only allowed by software in Non-Secure state. When the corresponding pin's registers are
 *       accessed by software in Secure state, all bits in the registers related to that pin are read zero and write
 *       ignored.
 */
#define GPIO_PCNS_NSE2(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PCNS_NSE2_SHIFT)) & GPIO_PCNS_NSE2_MASK)

#define GPIO_PCNS_NSE3_MASK                      (0x8U)
#define GPIO_PCNS_NSE3_SHIFT                     (3U)
/*! NSE3 - Non-Secure Enable
 *  0b0..The pin is configured for Secure access. Read or write access to the corresponding pin's registers and
 *       bit fields is only allowed by software in Secure state. When the corresponding pin's registers are accessed
 *       by software in Non-Secure state, all bits in the registers related to that pin are read zero and write
 *       ignored.
 *  0b1..The pin is configured for Non-Secure access. Read or write access to the corresponding pin's registers
 *       and bit fields is only allowed by software in Non-Secure state. When the corresponding pin's registers are
 *       accessed by software in Secure state, all bits in the registers related to that pin are read zero and write
 *       ignored.
 */
#define GPIO_PCNS_NSE3(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PCNS_NSE3_SHIFT)) & GPIO_PCNS_NSE3_MASK)

#define GPIO_PCNS_NSE4_MASK                      (0x10U)
#define GPIO_PCNS_NSE4_SHIFT                     (4U)
/*! NSE4 - Non-Secure Enable
 *  0b0..The pin is configured for Secure access. Read or write access to the corresponding pin's registers and
 *       bit fields is only allowed by software in Secure state. When the corresponding pin's registers are accessed
 *       by software in Non-Secure state, all bits in the registers related to that pin are read zero and write
 *       ignored.
 *  0b1..The pin is configured for Non-Secure access. Read or write access to the corresponding pin's registers
 *       and bit fields is only allowed by software in Non-Secure state. When the corresponding pin's registers are
 *       accessed by software in Secure state, all bits in the registers related to that pin are read zero and write
 *       ignored.
 */
#define GPIO_PCNS_NSE4(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PCNS_NSE4_SHIFT)) & GPIO_PCNS_NSE4_MASK)

#define GPIO_PCNS_NSE5_MASK                      (0x20U)
#define GPIO_PCNS_NSE5_SHIFT                     (5U)
/*! NSE5 - Non-Secure Enable
 *  0b0..The pin is configured for Secure access. Read or write access to the corresponding pin's registers and
 *       bit fields is only allowed by software in Secure state. When the corresponding pin's registers are accessed
 *       by software in Non-Secure state, all bits in the registers related to that pin are read zero and write
 *       ignored.
 *  0b1..The pin is configured for Non-Secure access. Read or write access to the corresponding pin's registers
 *       and bit fields is only allowed by software in Non-Secure state. When the corresponding pin's registers are
 *       accessed by software in Secure state, all bits in the registers related to that pin are read zero and write
 *       ignored.
 */
#define GPIO_PCNS_NSE5(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PCNS_NSE5_SHIFT)) & GPIO_PCNS_NSE5_MASK)

#define GPIO_PCNS_NSE6_MASK                      (0x40U)
#define GPIO_PCNS_NSE6_SHIFT                     (6U)
/*! NSE6 - Non-Secure Enable
 *  0b0..The pin is configured for Secure access. Read or write access to the corresponding pin's registers and
 *       bit fields is only allowed by software in Secure state. When the corresponding pin's registers are accessed
 *       by software in Non-Secure state, all bits in the registers related to that pin are read zero and write
 *       ignored.
 *  0b1..The pin is configured for Non-Secure access. Read or write access to the corresponding pin's registers
 *       and bit fields is only allowed by software in Non-Secure state. When the corresponding pin's registers are
 *       accessed by software in Secure state, all bits in the registers related to that pin are read zero and write
 *       ignored.
 */
#define GPIO_PCNS_NSE6(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PCNS_NSE6_SHIFT)) & GPIO_PCNS_NSE6_MASK)

#define GPIO_PCNS_NSE7_MASK                      (0x80U)
#define GPIO_PCNS_NSE7_SHIFT                     (7U)
/*! NSE7 - Non-Secure Enable
 *  0b0..The pin is configured for Secure access. Read or write access to the corresponding pin's registers and
 *       bit fields is only allowed by software in Secure state. When the corresponding pin's registers are accessed
 *       by software in Non-Secure state, all bits in the registers related to that pin are read zero and write
 *       ignored.
 *  0b1..The pin is configured for Non-Secure access. Read or write access to the corresponding pin's registers
 *       and bit fields is only allowed by software in Non-Secure state. When the corresponding pin's registers are
 *       accessed by software in Secure state, all bits in the registers related to that pin are read zero and write
 *       ignored.
 */
#define GPIO_PCNS_NSE7(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PCNS_NSE7_SHIFT)) & GPIO_PCNS_NSE7_MASK)

#define GPIO_PCNS_NSE8_MASK                      (0x100U)
#define GPIO_PCNS_NSE8_SHIFT                     (8U)
/*! NSE8 - Non-Secure Enable
 *  0b0..The pin is configured for Secure access. Read or write access to the corresponding pin's registers and
 *       bit fields is only allowed by software in Secure state. When the corresponding pin's registers are accessed
 *       by software in Non-Secure state, all bits in the registers related to that pin are read zero and write
 *       ignored.
 *  0b1..The pin is configured for Non-Secure access. Read or write access to the corresponding pin's registers
 *       and bit fields is only allowed by software in Non-Secure state. When the corresponding pin's registers are
 *       accessed by software in Secure state, all bits in the registers related to that pin are read zero and write
 *       ignored.
 */
#define GPIO_PCNS_NSE8(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PCNS_NSE8_SHIFT)) & GPIO_PCNS_NSE8_MASK)

#define GPIO_PCNS_NSE9_MASK                      (0x200U)
#define GPIO_PCNS_NSE9_SHIFT                     (9U)
/*! NSE9 - Non-Secure Enable
 *  0b0..The pin is configured for Secure access. Read or write access to the corresponding pin's registers and
 *       bit fields is only allowed by software in Secure state. When the corresponding pin's registers are accessed
 *       by software in Non-Secure state, all bits in the registers related to that pin are read zero and write
 *       ignored.
 *  0b1..The pin is configured for Non-Secure access. Read or write access to the corresponding pin's registers
 *       and bit fields is only allowed by software in Non-Secure state. When the corresponding pin's registers are
 *       accessed by software in Secure state, all bits in the registers related to that pin are read zero and write
 *       ignored.
 */
#define GPIO_PCNS_NSE9(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PCNS_NSE9_SHIFT)) & GPIO_PCNS_NSE9_MASK)

#define GPIO_PCNS_NSE10_MASK                     (0x400U)
#define GPIO_PCNS_NSE10_SHIFT                    (10U)
/*! NSE10 - Non-Secure Enable
 *  0b0..The pin is configured for Secure access. Read or write access to the corresponding pin's registers and
 *       bit fields is only allowed by software in Secure state. When the corresponding pin's registers are accessed
 *       by software in Non-Secure state, all bits in the registers related to that pin are read zero and write
 *       ignored.
 *  0b1..The pin is configured for Non-Secure access. Read or write access to the corresponding pin's registers
 *       and bit fields is only allowed by software in Non-Secure state. When the corresponding pin's registers are
 *       accessed by software in Secure state, all bits in the registers related to that pin are read zero and write
 *       ignored.
 */
#define GPIO_PCNS_NSE10(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PCNS_NSE10_SHIFT)) & GPIO_PCNS_NSE10_MASK)

#define GPIO_PCNS_NSE11_MASK                     (0x800U)
#define GPIO_PCNS_NSE11_SHIFT                    (11U)
/*! NSE11 - Non-Secure Enable
 *  0b0..The pin is configured for Secure access. Read or write access to the corresponding pin's registers and
 *       bit fields is only allowed by software in Secure state. When the corresponding pin's registers are accessed
 *       by software in Non-Secure state, all bits in the registers related to that pin are read zero and write
 *       ignored.
 *  0b1..The pin is configured for Non-Secure access. Read or write access to the corresponding pin's registers
 *       and bit fields is only allowed by software in Non-Secure state. When the corresponding pin's registers are
 *       accessed by software in Secure state, all bits in the registers related to that pin are read zero and write
 *       ignored.
 */
#define GPIO_PCNS_NSE11(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PCNS_NSE11_SHIFT)) & GPIO_PCNS_NSE11_MASK)

#define GPIO_PCNS_NSE12_MASK                     (0x1000U)
#define GPIO_PCNS_NSE12_SHIFT                    (12U)
/*! NSE12 - Non-Secure Enable
 *  0b0..The pin is configured for Secure access. Read or write access to the corresponding pin's registers and
 *       bit fields is only allowed by software in Secure state. When the corresponding pin's registers are accessed
 *       by software in Non-Secure state, all bits in the registers related to that pin are read zero and write
 *       ignored.
 *  0b1..The pin is configured for Non-Secure access. Read or write access to the corresponding pin's registers
 *       and bit fields is only allowed by software in Non-Secure state. When the corresponding pin's registers are
 *       accessed by software in Secure state, all bits in the registers related to that pin are read zero and write
 *       ignored.
 */
#define GPIO_PCNS_NSE12(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PCNS_NSE12_SHIFT)) & GPIO_PCNS_NSE12_MASK)

#define GPIO_PCNS_NSE13_MASK                     (0x2000U)
#define GPIO_PCNS_NSE13_SHIFT                    (13U)
/*! NSE13 - Non-Secure Enable
 *  0b0..The pin is configured for Secure access. Read or write access to the corresponding pin's registers and
 *       bit fields is only allowed by software in Secure state. When the corresponding pin's registers are accessed
 *       by software in Non-Secure state, all bits in the registers related to that pin are read zero and write
 *       ignored.
 *  0b1..The pin is configured for Non-Secure access. Read or write access to the corresponding pin's registers
 *       and bit fields is only allowed by software in Non-Secure state. When the corresponding pin's registers are
 *       accessed by software in Secure state, all bits in the registers related to that pin are read zero and write
 *       ignored.
 */
#define GPIO_PCNS_NSE13(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PCNS_NSE13_SHIFT)) & GPIO_PCNS_NSE13_MASK)

#define GPIO_PCNS_NSE14_MASK                     (0x4000U)
#define GPIO_PCNS_NSE14_SHIFT                    (14U)
/*! NSE14 - Non-Secure Enable
 *  0b0..The pin is configured for Secure access. Read or write access to the corresponding pin's registers and
 *       bit fields is only allowed by software in Secure state. When the corresponding pin's registers are accessed
 *       by software in Non-Secure state, all bits in the registers related to that pin are read zero and write
 *       ignored.
 *  0b1..The pin is configured for Non-Secure access. Read or write access to the corresponding pin's registers
 *       and bit fields is only allowed by software in Non-Secure state. When the corresponding pin's registers are
 *       accessed by software in Secure state, all bits in the registers related to that pin are read zero and write
 *       ignored.
 */
#define GPIO_PCNS_NSE14(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PCNS_NSE14_SHIFT)) & GPIO_PCNS_NSE14_MASK)

#define GPIO_PCNS_NSE15_MASK                     (0x8000U)
#define GPIO_PCNS_NSE15_SHIFT                    (15U)
/*! NSE15 - Non-Secure Enable
 *  0b0..The pin is configured for Secure access. Read or write access to the corresponding pin's registers and
 *       bit fields is only allowed by software in Secure state. When the corresponding pin's registers are accessed
 *       by software in Non-Secure state, all bits in the registers related to that pin are read zero and write
 *       ignored.
 *  0b1..The pin is configured for Non-Secure access. Read or write access to the corresponding pin's registers
 *       and bit fields is only allowed by software in Non-Secure state. When the corresponding pin's registers are
 *       accessed by software in Secure state, all bits in the registers related to that pin are read zero and write
 *       ignored.
 */
#define GPIO_PCNS_NSE15(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PCNS_NSE15_SHIFT)) & GPIO_PCNS_NSE15_MASK)

#define GPIO_PCNS_NSE16_MASK                     (0x10000U)
#define GPIO_PCNS_NSE16_SHIFT                    (16U)
/*! NSE16 - Non-Secure Enable
 *  0b0..The pin is configured for Secure access. Read or write access to the corresponding pin's registers and
 *       bit fields is only allowed by software in Secure state. When the corresponding pin's registers are accessed
 *       by software in Non-Secure state, all bits in the registers related to that pin are read zero and write
 *       ignored.
 *  0b1..The pin is configured for Non-Secure access. Read or write access to the corresponding pin's registers
 *       and bit fields is only allowed by software in Non-Secure state. When the corresponding pin's registers are
 *       accessed by software in Secure state, all bits in the registers related to that pin are read zero and write
 *       ignored.
 */
#define GPIO_PCNS_NSE16(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PCNS_NSE16_SHIFT)) & GPIO_PCNS_NSE16_MASK)

#define GPIO_PCNS_NSE17_MASK                     (0x20000U)
#define GPIO_PCNS_NSE17_SHIFT                    (17U)
/*! NSE17 - Non-Secure Enable
 *  0b0..The pin is configured for Secure access. Read or write access to the corresponding pin's registers and
 *       bit fields is only allowed by software in Secure state. When the corresponding pin's registers are accessed
 *       by software in Non-Secure state, all bits in the registers related to that pin are read zero and write
 *       ignored.
 *  0b1..The pin is configured for Non-Secure access. Read or write access to the corresponding pin's registers
 *       and bit fields is only allowed by software in Non-Secure state. When the corresponding pin's registers are
 *       accessed by software in Secure state, all bits in the registers related to that pin are read zero and write
 *       ignored.
 */
#define GPIO_PCNS_NSE17(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PCNS_NSE17_SHIFT)) & GPIO_PCNS_NSE17_MASK)

#define GPIO_PCNS_NSE18_MASK                     (0x40000U)
#define GPIO_PCNS_NSE18_SHIFT                    (18U)
/*! NSE18 - Non-Secure Enable
 *  0b0..The pin is configured for Secure access. Read or write access to the corresponding pin's registers and
 *       bit fields is only allowed by software in Secure state. When the corresponding pin's registers are accessed
 *       by software in Non-Secure state, all bits in the registers related to that pin are read zero and write
 *       ignored.
 *  0b1..The pin is configured for Non-Secure access. Read or write access to the corresponding pin's registers
 *       and bit fields is only allowed by software in Non-Secure state. When the corresponding pin's registers are
 *       accessed by software in Secure state, all bits in the registers related to that pin are read zero and write
 *       ignored.
 */
#define GPIO_PCNS_NSE18(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PCNS_NSE18_SHIFT)) & GPIO_PCNS_NSE18_MASK)

#define GPIO_PCNS_NSE19_MASK                     (0x80000U)
#define GPIO_PCNS_NSE19_SHIFT                    (19U)
/*! NSE19 - Non-Secure Enable
 *  0b0..The pin is configured for Secure access. Read or write access to the corresponding pin's registers and
 *       bit fields is only allowed by software in Secure state. When the corresponding pin's registers are accessed
 *       by software in Non-Secure state, all bits in the registers related to that pin are read zero and write
 *       ignored.
 *  0b1..The pin is configured for Non-Secure access. Read or write access to the corresponding pin's registers
 *       and bit fields is only allowed by software in Non-Secure state. When the corresponding pin's registers are
 *       accessed by software in Secure state, all bits in the registers related to that pin are read zero and write
 *       ignored.
 */
#define GPIO_PCNS_NSE19(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PCNS_NSE19_SHIFT)) & GPIO_PCNS_NSE19_MASK)

#define GPIO_PCNS_NSE20_MASK                     (0x100000U)
#define GPIO_PCNS_NSE20_SHIFT                    (20U)
/*! NSE20 - Non-Secure Enable
 *  0b0..The pin is configured for Secure access. Read or write access to the corresponding pin's registers and
 *       bit fields is only allowed by software in Secure state. When the corresponding pin's registers are accessed
 *       by software in Non-Secure state, all bits in the registers related to that pin are read zero and write
 *       ignored.
 *  0b1..The pin is configured for Non-Secure access. Read or write access to the corresponding pin's registers
 *       and bit fields is only allowed by software in Non-Secure state. When the corresponding pin's registers are
 *       accessed by software in Secure state, all bits in the registers related to that pin are read zero and write
 *       ignored.
 */
#define GPIO_PCNS_NSE20(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PCNS_NSE20_SHIFT)) & GPIO_PCNS_NSE20_MASK)

#define GPIO_PCNS_NSE21_MASK                     (0x200000U)
#define GPIO_PCNS_NSE21_SHIFT                    (21U)
/*! NSE21 - Non-Secure Enable
 *  0b0..The pin is configured for Secure access. Read or write access to the corresponding pin's registers and
 *       bit fields is only allowed by software in Secure state. When the corresponding pin's registers are accessed
 *       by software in Non-Secure state, all bits in the registers related to that pin are read zero and write
 *       ignored.
 *  0b1..The pin is configured for Non-Secure access. Read or write access to the corresponding pin's registers
 *       and bit fields is only allowed by software in Non-Secure state. When the corresponding pin's registers are
 *       accessed by software in Secure state, all bits in the registers related to that pin are read zero and write
 *       ignored.
 */
#define GPIO_PCNS_NSE21(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PCNS_NSE21_SHIFT)) & GPIO_PCNS_NSE21_MASK)

#define GPIO_PCNS_NSE22_MASK                     (0x400000U)
#define GPIO_PCNS_NSE22_SHIFT                    (22U)
/*! NSE22 - Non-Secure Enable
 *  0b0..The pin is configured for Secure access. Read or write access to the corresponding pin's registers and
 *       bit fields is only allowed by software in Secure state. When the corresponding pin's registers are accessed
 *       by software in Non-Secure state, all bits in the registers related to that pin are read zero and write
 *       ignored.
 *  0b1..The pin is configured for Non-Secure access. Read or write access to the corresponding pin's registers
 *       and bit fields is only allowed by software in Non-Secure state. When the corresponding pin's registers are
 *       accessed by software in Secure state, all bits in the registers related to that pin are read zero and write
 *       ignored.
 */
#define GPIO_PCNS_NSE22(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PCNS_NSE22_SHIFT)) & GPIO_PCNS_NSE22_MASK)

#define GPIO_PCNS_NSE23_MASK                     (0x800000U)
#define GPIO_PCNS_NSE23_SHIFT                    (23U)
/*! NSE23 - Non-Secure Enable
 *  0b0..The pin is configured for Secure access. Read or write access to the corresponding pin's registers and
 *       bit fields is only allowed by software in Secure state. When the corresponding pin's registers are accessed
 *       by software in Non-Secure state, all bits in the registers related to that pin are read zero and write
 *       ignored.
 *  0b1..The pin is configured for Non-Secure access. Read or write access to the corresponding pin's registers
 *       and bit fields is only allowed by software in Non-Secure state. When the corresponding pin's registers are
 *       accessed by software in Secure state, all bits in the registers related to that pin are read zero and write
 *       ignored.
 */
#define GPIO_PCNS_NSE23(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PCNS_NSE23_SHIFT)) & GPIO_PCNS_NSE23_MASK)

#define GPIO_PCNS_NSE24_MASK                     (0x1000000U)
#define GPIO_PCNS_NSE24_SHIFT                    (24U)
/*! NSE24 - Non-Secure Enable
 *  0b0..The pin is configured for Secure access. Read or write access to the corresponding pin's registers and
 *       bit fields is only allowed by software in Secure state. When the corresponding pin's registers are accessed
 *       by software in Non-Secure state, all bits in the registers related to that pin are read zero and write
 *       ignored.
 *  0b1..The pin is configured for Non-Secure access. Read or write access to the corresponding pin's registers
 *       and bit fields is only allowed by software in Non-Secure state. When the corresponding pin's registers are
 *       accessed by software in Secure state, all bits in the registers related to that pin are read zero and write
 *       ignored.
 */
#define GPIO_PCNS_NSE24(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PCNS_NSE24_SHIFT)) & GPIO_PCNS_NSE24_MASK)

#define GPIO_PCNS_NSE25_MASK                     (0x2000000U)
#define GPIO_PCNS_NSE25_SHIFT                    (25U)
/*! NSE25 - Non-Secure Enable
 *  0b0..The pin is configured for Secure access. Read or write access to the corresponding pin's registers and
 *       bit fields is only allowed by software in Secure state. When the corresponding pin's registers are accessed
 *       by software in Non-Secure state, all bits in the registers related to that pin are read zero and write
 *       ignored.
 *  0b1..The pin is configured for Non-Secure access. Read or write access to the corresponding pin's registers
 *       and bit fields is only allowed by software in Non-Secure state. When the corresponding pin's registers are
 *       accessed by software in Secure state, all bits in the registers related to that pin are read zero and write
 *       ignored.
 */
#define GPIO_PCNS_NSE25(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PCNS_NSE25_SHIFT)) & GPIO_PCNS_NSE25_MASK)

#define GPIO_PCNS_NSE26_MASK                     (0x4000000U)
#define GPIO_PCNS_NSE26_SHIFT                    (26U)
/*! NSE26 - Non-Secure Enable
 *  0b0..The pin is configured for Secure access. Read or write access to the corresponding pin's registers and
 *       bit fields is only allowed by software in Secure state. When the corresponding pin's registers are accessed
 *       by software in Non-Secure state, all bits in the registers related to that pin are read zero and write
 *       ignored.
 *  0b1..The pin is configured for Non-Secure access. Read or write access to the corresponding pin's registers
 *       and bit fields is only allowed by software in Non-Secure state. When the corresponding pin's registers are
 *       accessed by software in Secure state, all bits in the registers related to that pin are read zero and write
 *       ignored.
 */
#define GPIO_PCNS_NSE26(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PCNS_NSE26_SHIFT)) & GPIO_PCNS_NSE26_MASK)

#define GPIO_PCNS_NSE27_MASK                     (0x8000000U)
#define GPIO_PCNS_NSE27_SHIFT                    (27U)
/*! NSE27 - Non-Secure Enable
 *  0b0..The pin is configured for Secure access. Read or write access to the corresponding pin's registers and
 *       bit fields is only allowed by software in Secure state. When the corresponding pin's registers are accessed
 *       by software in Non-Secure state, all bits in the registers related to that pin are read zero and write
 *       ignored.
 *  0b1..The pin is configured for Non-Secure access. Read or write access to the corresponding pin's registers
 *       and bit fields is only allowed by software in Non-Secure state. When the corresponding pin's registers are
 *       accessed by software in Secure state, all bits in the registers related to that pin are read zero and write
 *       ignored.
 */
#define GPIO_PCNS_NSE27(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PCNS_NSE27_SHIFT)) & GPIO_PCNS_NSE27_MASK)

#define GPIO_PCNS_NSE28_MASK                     (0x10000000U)
#define GPIO_PCNS_NSE28_SHIFT                    (28U)
/*! NSE28 - Non-Secure Enable
 *  0b0..The pin is configured for Secure access. Read or write access to the corresponding pin's registers and
 *       bit fields is only allowed by software in Secure state. When the corresponding pin's registers are accessed
 *       by software in Non-Secure state, all bits in the registers related to that pin are read zero and write
 *       ignored.
 *  0b1..The pin is configured for Non-Secure access. Read or write access to the corresponding pin's registers
 *       and bit fields is only allowed by software in Non-Secure state. When the corresponding pin's registers are
 *       accessed by software in Secure state, all bits in the registers related to that pin are read zero and write
 *       ignored.
 */
#define GPIO_PCNS_NSE28(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PCNS_NSE28_SHIFT)) & GPIO_PCNS_NSE28_MASK)

#define GPIO_PCNS_NSE29_MASK                     (0x20000000U)
#define GPIO_PCNS_NSE29_SHIFT                    (29U)
/*! NSE29 - Non-Secure Enable
 *  0b0..The pin is configured for Secure access. Read or write access to the corresponding pin's registers and
 *       bit fields is only allowed by software in Secure state. When the corresponding pin's registers are accessed
 *       by software in Non-Secure state, all bits in the registers related to that pin are read zero and write
 *       ignored.
 *  0b1..The pin is configured for Non-Secure access. Read or write access to the corresponding pin's registers
 *       and bit fields is only allowed by software in Non-Secure state. When the corresponding pin's registers are
 *       accessed by software in Secure state, all bits in the registers related to that pin are read zero and write
 *       ignored.
 */
#define GPIO_PCNS_NSE29(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PCNS_NSE29_SHIFT)) & GPIO_PCNS_NSE29_MASK)

#define GPIO_PCNS_NSE30_MASK                     (0x40000000U)
#define GPIO_PCNS_NSE30_SHIFT                    (30U)
/*! NSE30 - Non-Secure Enable
 *  0b0..The pin is configured for Secure access. Read or write access to the corresponding pin's registers and
 *       bit fields is only allowed by software in Secure state. When the corresponding pin's registers are accessed
 *       by software in Non-Secure state, all bits in the registers related to that pin are read zero and write
 *       ignored.
 *  0b1..The pin is configured for Non-Secure access. Read or write access to the corresponding pin's registers
 *       and bit fields is only allowed by software in Non-Secure state. When the corresponding pin's registers are
 *       accessed by software in Secure state, all bits in the registers related to that pin are read zero and write
 *       ignored.
 */
#define GPIO_PCNS_NSE30(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PCNS_NSE30_SHIFT)) & GPIO_PCNS_NSE30_MASK)

#define GPIO_PCNS_NSE31_MASK                     (0x80000000U)
#define GPIO_PCNS_NSE31_SHIFT                    (31U)
/*! NSE31 - Non-Secure Enable
 *  0b0..The pin is configured for Secure access. Read or write access to the corresponding pin's registers and
 *       bit fields is only allowed by software in Secure state. When the corresponding pin's registers are accessed
 *       by software in Non-Secure state, all bits in the registers related to that pin are read zero and write
 *       ignored.
 *  0b1..The pin is configured for Non-Secure access. Read or write access to the corresponding pin's registers
 *       and bit fields is only allowed by software in Non-Secure state. When the corresponding pin's registers are
 *       accessed by software in Secure state, all bits in the registers related to that pin are read zero and write
 *       ignored.
 */
#define GPIO_PCNS_NSE31(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PCNS_NSE31_SHIFT)) & GPIO_PCNS_NSE31_MASK)
/*! @} */

/*! @name ICNS - Interrupt Control Non-Secure */
/*! @{ */

#define GPIO_ICNS_NSE0_MASK                      (0x1U)
#define GPIO_ICNS_NSE0_SHIFT                     (0U)
/*! NSE0 - Non-Secure Enable
 *  0b0..The interrupt or DMA request or output trigger is configured for Secure access. Only software in Secure
 *       state can configure a pin to use the corresponding interrupt or DMA request or output trigger or
 *       reconfigure a pin that is already configured to use the corresponding interrupt or DMA request or output trigger.
 *  0b1..The interrupt or DMA request or trigger output is configured for Non-Secure access. Only software in
 *       Non-Secure state can configure a pin to use the corresponding interrupt or DMA request or output trigger or
 *       reconfigure a pin that is already configured to use the corresponding interrupt or DMA request or output
 *       trigger.
 */
#define GPIO_ICNS_NSE0(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_ICNS_NSE0_SHIFT)) & GPIO_ICNS_NSE0_MASK)

#define GPIO_ICNS_NSE1_MASK                      (0x2U)
#define GPIO_ICNS_NSE1_SHIFT                     (1U)
/*! NSE1 - Non-Secure Enable
 *  0b0..The interrupt or DMA request or output trigger is configured for Secure access. Only software in Secure
 *       state can configure a pin to use the corresponding interrupt or DMA request or output trigger or
 *       reconfigure a pin that is already configured to use the corresponding interrupt or DMA request or output trigger.
 *  0b1..The interrupt or DMA request or trigger output is configured for Non-Secure access. Only software in
 *       Non-Secure state can configure a pin to use the corresponding interrupt or DMA request or output trigger or
 *       reconfigure a pin that is already configured to use the corresponding interrupt or DMA request or output
 *       trigger.
 */
#define GPIO_ICNS_NSE1(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_ICNS_NSE1_SHIFT)) & GPIO_ICNS_NSE1_MASK)
/*! @} */

/*! @name PCNP - Pin Control Non-Privilege */
/*! @{ */

#define GPIO_PCNP_NPE0_MASK                      (0x1U)
#define GPIO_PCNP_NPE0_SHIFT                     (0U)
/*! NPE0 - Non-Privilege Enable
 *  0b0..The pin is configured for Privilege access. Write access to the corresponding pin's registers and bit
 *       fields is allowed only by software in Privilege state. When the corresponding pin's registers and bit fields
 *       are accessed by software in Non-Privilege state, all bits related to that pin in this GPIO are readable
 *       but write ignored.
 *  0b1..The pin is configured for Non-Privilege access, Read or write access to the corresponding pin's registers
 *       is allowed by software in both Privilege or Non-Privilege state.
 */
#define GPIO_PCNP_NPE0(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PCNP_NPE0_SHIFT)) & GPIO_PCNP_NPE0_MASK)

#define GPIO_PCNP_NPE1_MASK                      (0x2U)
#define GPIO_PCNP_NPE1_SHIFT                     (1U)
/*! NPE1 - Non-Privilege Enable
 *  0b0..The pin is configured for Privilege access. Write access to the corresponding pin's registers and bit
 *       fields is allowed only by software in Privilege state. When the corresponding pin's registers and bit fields
 *       are accessed by software in Non-Privilege state, all bits related to that pin in this GPIO are readable
 *       but write ignored.
 *  0b1..The pin is configured for Non-Privilege access, Read or write access to the corresponding pin's registers
 *       is allowed by software in both Privilege or Non-Privilege state.
 */
#define GPIO_PCNP_NPE1(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PCNP_NPE1_SHIFT)) & GPIO_PCNP_NPE1_MASK)

#define GPIO_PCNP_NPE2_MASK                      (0x4U)
#define GPIO_PCNP_NPE2_SHIFT                     (2U)
/*! NPE2 - Non-Privilege Enable
 *  0b0..The pin is configured for Privilege access. Write access to the corresponding pin's registers and bit
 *       fields is allowed only by software in Privilege state. When the corresponding pin's registers and bit fields
 *       are accessed by software in Non-Privilege state, all bits related to that pin in this GPIO are readable
 *       but write ignored.
 *  0b1..The pin is configured for Non-Privilege access, Read or write access to the corresponding pin's registers
 *       is allowed by software in both Privilege or Non-Privilege state.
 */
#define GPIO_PCNP_NPE2(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PCNP_NPE2_SHIFT)) & GPIO_PCNP_NPE2_MASK)

#define GPIO_PCNP_NPE3_MASK                      (0x8U)
#define GPIO_PCNP_NPE3_SHIFT                     (3U)
/*! NPE3 - Non-Privilege Enable
 *  0b0..The pin is configured for Privilege access. Write access to the corresponding pin's registers and bit
 *       fields is allowed only by software in Privilege state. When the corresponding pin's registers and bit fields
 *       are accessed by software in Non-Privilege state, all bits related to that pin in this GPIO are readable
 *       but write ignored.
 *  0b1..The pin is configured for Non-Privilege access, Read or write access to the corresponding pin's registers
 *       is allowed by software in both Privilege or Non-Privilege state.
 */
#define GPIO_PCNP_NPE3(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PCNP_NPE3_SHIFT)) & GPIO_PCNP_NPE3_MASK)

#define GPIO_PCNP_NPE4_MASK                      (0x10U)
#define GPIO_PCNP_NPE4_SHIFT                     (4U)
/*! NPE4 - Non-Privilege Enable
 *  0b0..The pin is configured for Privilege access. Write access to the corresponding pin's registers and bit
 *       fields is allowed only by software in Privilege state. When the corresponding pin's registers and bit fields
 *       are accessed by software in Non-Privilege state, all bits related to that pin in this GPIO are readable
 *       but write ignored.
 *  0b1..The pin is configured for Non-Privilege access, Read or write access to the corresponding pin's registers
 *       is allowed by software in both Privilege or Non-Privilege state.
 */
#define GPIO_PCNP_NPE4(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PCNP_NPE4_SHIFT)) & GPIO_PCNP_NPE4_MASK)

#define GPIO_PCNP_NPE5_MASK                      (0x20U)
#define GPIO_PCNP_NPE5_SHIFT                     (5U)
/*! NPE5 - Non-Privilege Enable
 *  0b0..The pin is configured for Privilege access. Write access to the corresponding pin's registers and bit
 *       fields is allowed only by software in Privilege state. When the corresponding pin's registers and bit fields
 *       are accessed by software in Non-Privilege state, all bits related to that pin in this GPIO are readable
 *       but write ignored.
 *  0b1..The pin is configured for Non-Privilege access, Read or write access to the corresponding pin's registers
 *       is allowed by software in both Privilege or Non-Privilege state.
 */
#define GPIO_PCNP_NPE5(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PCNP_NPE5_SHIFT)) & GPIO_PCNP_NPE5_MASK)

#define GPIO_PCNP_NPE6_MASK                      (0x40U)
#define GPIO_PCNP_NPE6_SHIFT                     (6U)
/*! NPE6 - Non-Privilege Enable
 *  0b0..The pin is configured for Privilege access. Write access to the corresponding pin's registers and bit
 *       fields is allowed only by software in Privilege state. When the corresponding pin's registers and bit fields
 *       are accessed by software in Non-Privilege state, all bits related to that pin in this GPIO are readable
 *       but write ignored.
 *  0b1..The pin is configured for Non-Privilege access, Read or write access to the corresponding pin's registers
 *       is allowed by software in both Privilege or Non-Privilege state.
 */
#define GPIO_PCNP_NPE6(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PCNP_NPE6_SHIFT)) & GPIO_PCNP_NPE6_MASK)

#define GPIO_PCNP_NPE7_MASK                      (0x80U)
#define GPIO_PCNP_NPE7_SHIFT                     (7U)
/*! NPE7 - Non-Privilege Enable
 *  0b0..The pin is configured for Privilege access. Write access to the corresponding pin's registers and bit
 *       fields is allowed only by software in Privilege state. When the corresponding pin's registers and bit fields
 *       are accessed by software in Non-Privilege state, all bits related to that pin in this GPIO are readable
 *       but write ignored.
 *  0b1..The pin is configured for Non-Privilege access, Read or write access to the corresponding pin's registers
 *       is allowed by software in both Privilege or Non-Privilege state.
 */
#define GPIO_PCNP_NPE7(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PCNP_NPE7_SHIFT)) & GPIO_PCNP_NPE7_MASK)

#define GPIO_PCNP_NPE8_MASK                      (0x100U)
#define GPIO_PCNP_NPE8_SHIFT                     (8U)
/*! NPE8 - Non-Privilege Enable
 *  0b0..The pin is configured for Privilege access. Write access to the corresponding pin's registers and bit
 *       fields is allowed only by software in Privilege state. When the corresponding pin's registers and bit fields
 *       are accessed by software in Non-Privilege state, all bits related to that pin in this GPIO are readable
 *       but write ignored.
 *  0b1..The pin is configured for Non-Privilege access, Read or write access to the corresponding pin's registers
 *       is allowed by software in both Privilege or Non-Privilege state.
 */
#define GPIO_PCNP_NPE8(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PCNP_NPE8_SHIFT)) & GPIO_PCNP_NPE8_MASK)

#define GPIO_PCNP_NPE9_MASK                      (0x200U)
#define GPIO_PCNP_NPE9_SHIFT                     (9U)
/*! NPE9 - Non-Privilege Enable
 *  0b0..The pin is configured for Privilege access. Write access to the corresponding pin's registers and bit
 *       fields is allowed only by software in Privilege state. When the corresponding pin's registers and bit fields
 *       are accessed by software in Non-Privilege state, all bits related to that pin in this GPIO are readable
 *       but write ignored.
 *  0b1..The pin is configured for Non-Privilege access, Read or write access to the corresponding pin's registers
 *       is allowed by software in both Privilege or Non-Privilege state.
 */
#define GPIO_PCNP_NPE9(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PCNP_NPE9_SHIFT)) & GPIO_PCNP_NPE9_MASK)

#define GPIO_PCNP_NPE10_MASK                     (0x400U)
#define GPIO_PCNP_NPE10_SHIFT                    (10U)
/*! NPE10 - Non-Privilege Enable
 *  0b0..The pin is configured for Privilege access. Write access to the corresponding pin's registers and bit
 *       fields is allowed only by software in Privilege state. When the corresponding pin's registers and bit fields
 *       are accessed by software in Non-Privilege state, all bits related to that pin in this GPIO are readable
 *       but write ignored.
 *  0b1..The pin is configured for Non-Privilege access, Read or write access to the corresponding pin's registers
 *       is allowed by software in both Privilege or Non-Privilege state.
 */
#define GPIO_PCNP_NPE10(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PCNP_NPE10_SHIFT)) & GPIO_PCNP_NPE10_MASK)

#define GPIO_PCNP_NPE11_MASK                     (0x800U)
#define GPIO_PCNP_NPE11_SHIFT                    (11U)
/*! NPE11 - Non-Privilege Enable
 *  0b0..The pin is configured for Privilege access. Write access to the corresponding pin's registers and bit
 *       fields is allowed only by software in Privilege state. When the corresponding pin's registers and bit fields
 *       are accessed by software in Non-Privilege state, all bits related to that pin in this GPIO are readable
 *       but write ignored.
 *  0b1..The pin is configured for Non-Privilege access, Read or write access to the corresponding pin's registers
 *       is allowed by software in both Privilege or Non-Privilege state.
 */
#define GPIO_PCNP_NPE11(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PCNP_NPE11_SHIFT)) & GPIO_PCNP_NPE11_MASK)

#define GPIO_PCNP_NPE12_MASK                     (0x1000U)
#define GPIO_PCNP_NPE12_SHIFT                    (12U)
/*! NPE12 - Non-Privilege Enable
 *  0b0..The pin is configured for Privilege access. Write access to the corresponding pin's registers and bit
 *       fields is allowed only by software in Privilege state. When the corresponding pin's registers and bit fields
 *       are accessed by software in Non-Privilege state, all bits related to that pin in this GPIO are readable
 *       but write ignored.
 *  0b1..The pin is configured for Non-Privilege access, Read or write access to the corresponding pin's registers
 *       is allowed by software in both Privilege or Non-Privilege state.
 */
#define GPIO_PCNP_NPE12(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PCNP_NPE12_SHIFT)) & GPIO_PCNP_NPE12_MASK)

#define GPIO_PCNP_NPE13_MASK                     (0x2000U)
#define GPIO_PCNP_NPE13_SHIFT                    (13U)
/*! NPE13 - Non-Privilege Enable
 *  0b0..The pin is configured for Privilege access. Write access to the corresponding pin's registers and bit
 *       fields is allowed only by software in Privilege state. When the corresponding pin's registers and bit fields
 *       are accessed by software in Non-Privilege state, all bits related to that pin in this GPIO are readable
 *       but write ignored.
 *  0b1..The pin is configured for Non-Privilege access, Read or write access to the corresponding pin's registers
 *       is allowed by software in both Privilege or Non-Privilege state.
 */
#define GPIO_PCNP_NPE13(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PCNP_NPE13_SHIFT)) & GPIO_PCNP_NPE13_MASK)

#define GPIO_PCNP_NPE14_MASK                     (0x4000U)
#define GPIO_PCNP_NPE14_SHIFT                    (14U)
/*! NPE14 - Non-Privilege Enable
 *  0b0..The pin is configured for Privilege access. Write access to the corresponding pin's registers and bit
 *       fields is allowed only by software in Privilege state. When the corresponding pin's registers and bit fields
 *       are accessed by software in Non-Privilege state, all bits related to that pin in this GPIO are readable
 *       but write ignored.
 *  0b1..The pin is configured for Non-Privilege access, Read or write access to the corresponding pin's registers
 *       is allowed by software in both Privilege or Non-Privilege state.
 */
#define GPIO_PCNP_NPE14(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PCNP_NPE14_SHIFT)) & GPIO_PCNP_NPE14_MASK)

#define GPIO_PCNP_NPE15_MASK                     (0x8000U)
#define GPIO_PCNP_NPE15_SHIFT                    (15U)
/*! NPE15 - Non-Privilege Enable
 *  0b0..The pin is configured for Privilege access. Write access to the corresponding pin's registers and bit
 *       fields is allowed only by software in Privilege state. When the corresponding pin's registers and bit fields
 *       are accessed by software in Non-Privilege state, all bits related to that pin in this GPIO are readable
 *       but write ignored.
 *  0b1..The pin is configured for Non-Privilege access, Read or write access to the corresponding pin's registers
 *       is allowed by software in both Privilege or Non-Privilege state.
 */
#define GPIO_PCNP_NPE15(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PCNP_NPE15_SHIFT)) & GPIO_PCNP_NPE15_MASK)

#define GPIO_PCNP_NPE16_MASK                     (0x10000U)
#define GPIO_PCNP_NPE16_SHIFT                    (16U)
/*! NPE16 - Non-Privilege Enable
 *  0b0..The pin is configured for Privilege access. Write access to the corresponding pin's registers and bit
 *       fields is allowed only by software in Privilege state. When the corresponding pin's registers and bit fields
 *       are accessed by software in Non-Privilege state, all bits related to that pin in this GPIO are readable
 *       but write ignored.
 *  0b1..The pin is configured for Non-Privilege access, Read or write access to the corresponding pin's registers
 *       is allowed by software in both Privilege or Non-Privilege state.
 */
#define GPIO_PCNP_NPE16(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PCNP_NPE16_SHIFT)) & GPIO_PCNP_NPE16_MASK)

#define GPIO_PCNP_NPE17_MASK                     (0x20000U)
#define GPIO_PCNP_NPE17_SHIFT                    (17U)
/*! NPE17 - Non-Privilege Enable
 *  0b0..The pin is configured for Privilege access. Write access to the corresponding pin's registers and bit
 *       fields is allowed only by software in Privilege state. When the corresponding pin's registers and bit fields
 *       are accessed by software in Non-Privilege state, all bits related to that pin in this GPIO are readable
 *       but write ignored.
 *  0b1..The pin is configured for Non-Privilege access, Read or write access to the corresponding pin's registers
 *       is allowed by software in both Privilege or Non-Privilege state.
 */
#define GPIO_PCNP_NPE17(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PCNP_NPE17_SHIFT)) & GPIO_PCNP_NPE17_MASK)

#define GPIO_PCNP_NPE18_MASK                     (0x40000U)
#define GPIO_PCNP_NPE18_SHIFT                    (18U)
/*! NPE18 - Non-Privilege Enable
 *  0b0..The pin is configured for Privilege access. Write access to the corresponding pin's registers and bit
 *       fields is allowed only by software in Privilege state. When the corresponding pin's registers and bit fields
 *       are accessed by software in Non-Privilege state, all bits related to that pin in this GPIO are readable
 *       but write ignored.
 *  0b1..The pin is configured for Non-Privilege access, Read or write access to the corresponding pin's registers
 *       is allowed by software in both Privilege or Non-Privilege state.
 */
#define GPIO_PCNP_NPE18(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PCNP_NPE18_SHIFT)) & GPIO_PCNP_NPE18_MASK)

#define GPIO_PCNP_NPE19_MASK                     (0x80000U)
#define GPIO_PCNP_NPE19_SHIFT                    (19U)
/*! NPE19 - Non-Privilege Enable
 *  0b0..The pin is configured for Privilege access. Write access to the corresponding pin's registers and bit
 *       fields is allowed only by software in Privilege state. When the corresponding pin's registers and bit fields
 *       are accessed by software in Non-Privilege state, all bits related to that pin in this GPIO are readable
 *       but write ignored.
 *  0b1..The pin is configured for Non-Privilege access, Read or write access to the corresponding pin's registers
 *       is allowed by software in both Privilege or Non-Privilege state.
 */
#define GPIO_PCNP_NPE19(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PCNP_NPE19_SHIFT)) & GPIO_PCNP_NPE19_MASK)

#define GPIO_PCNP_NPE20_MASK                     (0x100000U)
#define GPIO_PCNP_NPE20_SHIFT                    (20U)
/*! NPE20 - Non-Privilege Enable
 *  0b0..The pin is configured for Privilege access. Write access to the corresponding pin's registers and bit
 *       fields is allowed only by software in Privilege state. When the corresponding pin's registers and bit fields
 *       are accessed by software in Non-Privilege state, all bits related to that pin in this GPIO are readable
 *       but write ignored.
 *  0b1..The pin is configured for Non-Privilege access, Read or write access to the corresponding pin's registers
 *       is allowed by software in both Privilege or Non-Privilege state.
 */
#define GPIO_PCNP_NPE20(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PCNP_NPE20_SHIFT)) & GPIO_PCNP_NPE20_MASK)

#define GPIO_PCNP_NPE21_MASK                     (0x200000U)
#define GPIO_PCNP_NPE21_SHIFT                    (21U)
/*! NPE21 - Non-Privilege Enable
 *  0b0..The pin is configured for Privilege access. Write access to the corresponding pin's registers and bit
 *       fields is allowed only by software in Privilege state. When the corresponding pin's registers and bit fields
 *       are accessed by software in Non-Privilege state, all bits related to that pin in this GPIO are readable
 *       but write ignored.
 *  0b1..The pin is configured for Non-Privilege access, Read or write access to the corresponding pin's registers
 *       is allowed by software in both Privilege or Non-Privilege state.
 */
#define GPIO_PCNP_NPE21(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PCNP_NPE21_SHIFT)) & GPIO_PCNP_NPE21_MASK)

#define GPIO_PCNP_NPE22_MASK                     (0x400000U)
#define GPIO_PCNP_NPE22_SHIFT                    (22U)
/*! NPE22 - Non-Privilege Enable
 *  0b0..The pin is configured for Privilege access. Write access to the corresponding pin's registers and bit
 *       fields is allowed only by software in Privilege state. When the corresponding pin's registers and bit fields
 *       are accessed by software in Non-Privilege state, all bits related to that pin in this GPIO are readable
 *       but write ignored.
 *  0b1..The pin is configured for Non-Privilege access, Read or write access to the corresponding pin's registers
 *       is allowed by software in both Privilege or Non-Privilege state.
 */
#define GPIO_PCNP_NPE22(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PCNP_NPE22_SHIFT)) & GPIO_PCNP_NPE22_MASK)

#define GPIO_PCNP_NPE23_MASK                     (0x800000U)
#define GPIO_PCNP_NPE23_SHIFT                    (23U)
/*! NPE23 - Non-Privilege Enable
 *  0b0..The pin is configured for Privilege access. Write access to the corresponding pin's registers and bit
 *       fields is allowed only by software in Privilege state. When the corresponding pin's registers and bit fields
 *       are accessed by software in Non-Privilege state, all bits related to that pin in this GPIO are readable
 *       but write ignored.
 *  0b1..The pin is configured for Non-Privilege access, Read or write access to the corresponding pin's registers
 *       is allowed by software in both Privilege or Non-Privilege state.
 */
#define GPIO_PCNP_NPE23(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PCNP_NPE23_SHIFT)) & GPIO_PCNP_NPE23_MASK)

#define GPIO_PCNP_NPE24_MASK                     (0x1000000U)
#define GPIO_PCNP_NPE24_SHIFT                    (24U)
/*! NPE24 - Non-Privilege Enable
 *  0b0..The pin is configured for Privilege access. Write access to the corresponding pin's registers and bit
 *       fields is allowed only by software in Privilege state. When the corresponding pin's registers and bit fields
 *       are accessed by software in Non-Privilege state, all bits related to that pin in this GPIO are readable
 *       but write ignored.
 *  0b1..The pin is configured for Non-Privilege access, Read or write access to the corresponding pin's registers
 *       is allowed by software in both Privilege or Non-Privilege state.
 */
#define GPIO_PCNP_NPE24(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PCNP_NPE24_SHIFT)) & GPIO_PCNP_NPE24_MASK)

#define GPIO_PCNP_NPE25_MASK                     (0x2000000U)
#define GPIO_PCNP_NPE25_SHIFT                    (25U)
/*! NPE25 - Non-Privilege Enable
 *  0b0..The pin is configured for Privilege access. Write access to the corresponding pin's registers and bit
 *       fields is allowed only by software in Privilege state. When the corresponding pin's registers and bit fields
 *       are accessed by software in Non-Privilege state, all bits related to that pin in this GPIO are readable
 *       but write ignored.
 *  0b1..The pin is configured for Non-Privilege access, Read or write access to the corresponding pin's registers
 *       is allowed by software in both Privilege or Non-Privilege state.
 */
#define GPIO_PCNP_NPE25(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PCNP_NPE25_SHIFT)) & GPIO_PCNP_NPE25_MASK)

#define GPIO_PCNP_NPE26_MASK                     (0x4000000U)
#define GPIO_PCNP_NPE26_SHIFT                    (26U)
/*! NPE26 - Non-Privilege Enable
 *  0b0..The pin is configured for Privilege access. Write access to the corresponding pin's registers and bit
 *       fields is allowed only by software in Privilege state. When the corresponding pin's registers and bit fields
 *       are accessed by software in Non-Privilege state, all bits related to that pin in this GPIO are readable
 *       but write ignored.
 *  0b1..The pin is configured for Non-Privilege access, Read or write access to the corresponding pin's registers
 *       is allowed by software in both Privilege or Non-Privilege state.
 */
#define GPIO_PCNP_NPE26(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PCNP_NPE26_SHIFT)) & GPIO_PCNP_NPE26_MASK)

#define GPIO_PCNP_NPE27_MASK                     (0x8000000U)
#define GPIO_PCNP_NPE27_SHIFT                    (27U)
/*! NPE27 - Non-Privilege Enable
 *  0b0..The pin is configured for Privilege access. Write access to the corresponding pin's registers and bit
 *       fields is allowed only by software in Privilege state. When the corresponding pin's registers and bit fields
 *       are accessed by software in Non-Privilege state, all bits related to that pin in this GPIO are readable
 *       but write ignored.
 *  0b1..The pin is configured for Non-Privilege access, Read or write access to the corresponding pin's registers
 *       is allowed by software in both Privilege or Non-Privilege state.
 */
#define GPIO_PCNP_NPE27(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PCNP_NPE27_SHIFT)) & GPIO_PCNP_NPE27_MASK)

#define GPIO_PCNP_NPE28_MASK                     (0x10000000U)
#define GPIO_PCNP_NPE28_SHIFT                    (28U)
/*! NPE28 - Non-Privilege Enable
 *  0b0..The pin is configured for Privilege access. Write access to the corresponding pin's registers and bit
 *       fields is allowed only by software in Privilege state. When the corresponding pin's registers and bit fields
 *       are accessed by software in Non-Privilege state, all bits related to that pin in this GPIO are readable
 *       but write ignored.
 *  0b1..The pin is configured for Non-Privilege access, Read or write access to the corresponding pin's registers
 *       is allowed by software in both Privilege or Non-Privilege state.
 */
#define GPIO_PCNP_NPE28(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PCNP_NPE28_SHIFT)) & GPIO_PCNP_NPE28_MASK)

#define GPIO_PCNP_NPE29_MASK                     (0x20000000U)
#define GPIO_PCNP_NPE29_SHIFT                    (29U)
/*! NPE29 - Non-Privilege Enable
 *  0b0..The pin is configured for Privilege access. Write access to the corresponding pin's registers and bit
 *       fields is allowed only by software in Privilege state. When the corresponding pin's registers and bit fields
 *       are accessed by software in Non-Privilege state, all bits related to that pin in this GPIO are readable
 *       but write ignored.
 *  0b1..The pin is configured for Non-Privilege access, Read or write access to the corresponding pin's registers
 *       is allowed by software in both Privilege or Non-Privilege state.
 */
#define GPIO_PCNP_NPE29(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PCNP_NPE29_SHIFT)) & GPIO_PCNP_NPE29_MASK)

#define GPIO_PCNP_NPE30_MASK                     (0x40000000U)
#define GPIO_PCNP_NPE30_SHIFT                    (30U)
/*! NPE30 - Non-Privilege Enable
 *  0b0..The pin is configured for Privilege access. Write access to the corresponding pin's registers and bit
 *       fields is allowed only by software in Privilege state. When the corresponding pin's registers and bit fields
 *       are accessed by software in Non-Privilege state, all bits related to that pin in this GPIO are readable
 *       but write ignored.
 *  0b1..The pin is configured for Non-Privilege access, Read or write access to the corresponding pin's registers
 *       is allowed by software in both Privilege or Non-Privilege state.
 */
#define GPIO_PCNP_NPE30(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PCNP_NPE30_SHIFT)) & GPIO_PCNP_NPE30_MASK)

#define GPIO_PCNP_NPE31_MASK                     (0x80000000U)
#define GPIO_PCNP_NPE31_SHIFT                    (31U)
/*! NPE31 - Non-Privilege Enable
 *  0b0..The pin is configured for Privilege access. Write access to the corresponding pin's registers and bit
 *       fields is allowed only by software in Privilege state. When the corresponding pin's registers and bit fields
 *       are accessed by software in Non-Privilege state, all bits related to that pin in this GPIO are readable
 *       but write ignored.
 *  0b1..The pin is configured for Non-Privilege access, Read or write access to the corresponding pin's registers
 *       is allowed by software in both Privilege or Non-Privilege state.
 */
#define GPIO_PCNP_NPE31(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PCNP_NPE31_SHIFT)) & GPIO_PCNP_NPE31_MASK)
/*! @} */

/*! @name ICNP - Interrupt Control Non-Privilege */
/*! @{ */

#define GPIO_ICNP_NPE0_MASK                      (0x1U)
#define GPIO_ICNP_NPE0_SHIFT                     (0U)
/*! NPE0 - Non-Privilege Enable
 *  0b0..The pin is configured for Privilege access. Only software in Privilege state can configure a pin to use
 *       the corresponding interrupt/DMA request/trigger output or reconfigure a pin that is already configured to
 *       use the corresponding interrupt/DMA request/trigger output.
 *  0b1..The pin is configured for Non-Privilege access. Software in either Privilege or Non-Privilege state can
 *       configure a pin to use the corresponding interrupt/DMA request/trigger output or reconfigure a pin that is
 *       already configured to use the corresponding interrupt/DMA request/trigger output.
 */
#define GPIO_ICNP_NPE0(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_ICNP_NPE0_SHIFT)) & GPIO_ICNP_NPE0_MASK)

#define GPIO_ICNP_NPE1_MASK                      (0x2U)
#define GPIO_ICNP_NPE1_SHIFT                     (1U)
/*! NPE1 - Non-Privilege Enable
 *  0b0..The pin is configured for Privilege access. Only software in Privilege state can configure a pin to use
 *       the corresponding interrupt/DMA request/trigger output or reconfigure a pin that is already configured to
 *       use the corresponding interrupt/DMA request/trigger output.
 *  0b1..The pin is configured for Non-Privilege access. Software in either Privilege or Non-Privilege state can
 *       configure a pin to use the corresponding interrupt/DMA request/trigger output or reconfigure a pin that is
 *       already configured to use the corresponding interrupt/DMA request/trigger output.
 */
#define GPIO_ICNP_NPE1(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_ICNP_NPE1_SHIFT)) & GPIO_ICNP_NPE1_MASK)
/*! @} */

/*! @name PDOR - Port Data Output Register */
/*! @{ */

#define GPIO_PDOR_PDO0_MASK                      (0x1U)
#define GPIO_PDOR_PDO0_SHIFT                     (0U)
/*! PDO0 - Port Data Output
 *  0b0..Logic level 0 is driven on pin, if the pin is configured for general-purpose output.
 *  0b1..Logic level 1 is driven on pin, if the pin is configured for general-purpose output.
 */
#define GPIO_PDOR_PDO0(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PDOR_PDO0_SHIFT)) & GPIO_PDOR_PDO0_MASK)

#define GPIO_PDOR_PDO1_MASK                      (0x2U)
#define GPIO_PDOR_PDO1_SHIFT                     (1U)
/*! PDO1 - Port Data Output
 *  0b0..Logic level 0 is driven on pin, if the pin is configured for general-purpose output.
 *  0b1..Logic level 1 is driven on pin, if the pin is configured for general-purpose output.
 */
#define GPIO_PDOR_PDO1(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PDOR_PDO1_SHIFT)) & GPIO_PDOR_PDO1_MASK)

#define GPIO_PDOR_PDO2_MASK                      (0x4U)
#define GPIO_PDOR_PDO2_SHIFT                     (2U)
/*! PDO2 - Port Data Output
 *  0b0..Logic level 0 is driven on pin, if the pin is configured for general-purpose output.
 *  0b1..Logic level 1 is driven on pin, if the pin is configured for general-purpose output.
 */
#define GPIO_PDOR_PDO2(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PDOR_PDO2_SHIFT)) & GPIO_PDOR_PDO2_MASK)

#define GPIO_PDOR_PDO3_MASK                      (0x8U)
#define GPIO_PDOR_PDO3_SHIFT                     (3U)
/*! PDO3 - Port Data Output
 *  0b0..Logic level 0 is driven on pin, if the pin is configured for general-purpose output.
 *  0b1..Logic level 1 is driven on pin, if the pin is configured for general-purpose output.
 */
#define GPIO_PDOR_PDO3(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PDOR_PDO3_SHIFT)) & GPIO_PDOR_PDO3_MASK)

#define GPIO_PDOR_PDO4_MASK                      (0x10U)
#define GPIO_PDOR_PDO4_SHIFT                     (4U)
/*! PDO4 - Port Data Output
 *  0b0..Logic level 0 is driven on pin, if the pin is configured for general-purpose output.
 *  0b1..Logic level 1 is driven on pin, if the pin is configured for general-purpose output.
 */
#define GPIO_PDOR_PDO4(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PDOR_PDO4_SHIFT)) & GPIO_PDOR_PDO4_MASK)

#define GPIO_PDOR_PDO5_MASK                      (0x20U)
#define GPIO_PDOR_PDO5_SHIFT                     (5U)
/*! PDO5 - Port Data Output
 *  0b0..Logic level 0 is driven on pin, if the pin is configured for general-purpose output.
 *  0b1..Logic level 1 is driven on pin, if the pin is configured for general-purpose output.
 */
#define GPIO_PDOR_PDO5(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PDOR_PDO5_SHIFT)) & GPIO_PDOR_PDO5_MASK)

#define GPIO_PDOR_PDO6_MASK                      (0x40U)
#define GPIO_PDOR_PDO6_SHIFT                     (6U)
/*! PDO6 - Port Data Output
 *  0b0..Logic level 0 is driven on pin, if the pin is configured for general-purpose output.
 *  0b1..Logic level 1 is driven on pin, if the pin is configured for general-purpose output.
 */
#define GPIO_PDOR_PDO6(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PDOR_PDO6_SHIFT)) & GPIO_PDOR_PDO6_MASK)

#define GPIO_PDOR_PDO7_MASK                      (0x80U)
#define GPIO_PDOR_PDO7_SHIFT                     (7U)
/*! PDO7 - Port Data Output
 *  0b0..Logic level 0 is driven on pin, if the pin is configured for general-purpose output.
 *  0b1..Logic level 1 is driven on pin, if the pin is configured for general-purpose output.
 */
#define GPIO_PDOR_PDO7(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PDOR_PDO7_SHIFT)) & GPIO_PDOR_PDO7_MASK)

#define GPIO_PDOR_PDO8_MASK                      (0x100U)
#define GPIO_PDOR_PDO8_SHIFT                     (8U)
/*! PDO8 - Port Data Output
 *  0b0..Logic level 0 is driven on pin, if the pin is configured for general-purpose output.
 *  0b1..Logic level 1 is driven on pin, if the pin is configured for general-purpose output.
 */
#define GPIO_PDOR_PDO8(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PDOR_PDO8_SHIFT)) & GPIO_PDOR_PDO8_MASK)

#define GPIO_PDOR_PDO9_MASK                      (0x200U)
#define GPIO_PDOR_PDO9_SHIFT                     (9U)
/*! PDO9 - Port Data Output
 *  0b0..Logic level 0 is driven on pin, if the pin is configured for general-purpose output.
 *  0b1..Logic level 1 is driven on pin, if the pin is configured for general-purpose output.
 */
#define GPIO_PDOR_PDO9(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PDOR_PDO9_SHIFT)) & GPIO_PDOR_PDO9_MASK)

#define GPIO_PDOR_PDO10_MASK                     (0x400U)
#define GPIO_PDOR_PDO10_SHIFT                    (10U)
/*! PDO10 - Port Data Output
 *  0b0..Logic level 0 is driven on pin, if the pin is configured for general-purpose output.
 *  0b1..Logic level 1 is driven on pin, if the pin is configured for general-purpose output.
 */
#define GPIO_PDOR_PDO10(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDOR_PDO10_SHIFT)) & GPIO_PDOR_PDO10_MASK)

#define GPIO_PDOR_PDO11_MASK                     (0x800U)
#define GPIO_PDOR_PDO11_SHIFT                    (11U)
/*! PDO11 - Port Data Output
 *  0b0..Logic level 0 is driven on pin, if the pin is configured for general-purpose output.
 *  0b1..Logic level 1 is driven on pin, if the pin is configured for general-purpose output.
 */
#define GPIO_PDOR_PDO11(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDOR_PDO11_SHIFT)) & GPIO_PDOR_PDO11_MASK)

#define GPIO_PDOR_PDO12_MASK                     (0x1000U)
#define GPIO_PDOR_PDO12_SHIFT                    (12U)
/*! PDO12 - Port Data Output
 *  0b0..Logic level 0 is driven on pin, if the pin is configured for general-purpose output.
 *  0b1..Logic level 1 is driven on pin, if the pin is configured for general-purpose output.
 */
#define GPIO_PDOR_PDO12(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDOR_PDO12_SHIFT)) & GPIO_PDOR_PDO12_MASK)

#define GPIO_PDOR_PDO13_MASK                     (0x2000U)
#define GPIO_PDOR_PDO13_SHIFT                    (13U)
/*! PDO13 - Port Data Output
 *  0b0..Logic level 0 is driven on pin, if the pin is configured for general-purpose output.
 *  0b1..Logic level 1 is driven on pin, if the pin is configured for general-purpose output.
 */
#define GPIO_PDOR_PDO13(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDOR_PDO13_SHIFT)) & GPIO_PDOR_PDO13_MASK)

#define GPIO_PDOR_PDO14_MASK                     (0x4000U)
#define GPIO_PDOR_PDO14_SHIFT                    (14U)
/*! PDO14 - Port Data Output
 *  0b0..Logic level 0 is driven on pin, if the pin is configured for general-purpose output.
 *  0b1..Logic level 1 is driven on pin, if the pin is configured for general-purpose output.
 */
#define GPIO_PDOR_PDO14(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDOR_PDO14_SHIFT)) & GPIO_PDOR_PDO14_MASK)

#define GPIO_PDOR_PDO15_MASK                     (0x8000U)
#define GPIO_PDOR_PDO15_SHIFT                    (15U)
/*! PDO15 - Port Data Output
 *  0b0..Logic level 0 is driven on pin, if the pin is configured for general-purpose output.
 *  0b1..Logic level 1 is driven on pin, if the pin is configured for general-purpose output.
 */
#define GPIO_PDOR_PDO15(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDOR_PDO15_SHIFT)) & GPIO_PDOR_PDO15_MASK)

#define GPIO_PDOR_PDO16_MASK                     (0x10000U)
#define GPIO_PDOR_PDO16_SHIFT                    (16U)
/*! PDO16 - Port Data Output
 *  0b0..Logic level 0 is driven on pin, if the pin is configured for general-purpose output.
 *  0b1..Logic level 1 is driven on pin, if the pin is configured for general-purpose output.
 */
#define GPIO_PDOR_PDO16(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDOR_PDO16_SHIFT)) & GPIO_PDOR_PDO16_MASK)

#define GPIO_PDOR_PDO17_MASK                     (0x20000U)
#define GPIO_PDOR_PDO17_SHIFT                    (17U)
/*! PDO17 - Port Data Output
 *  0b0..Logic level 0 is driven on pin, if the pin is configured for general-purpose output.
 *  0b1..Logic level 1 is driven on pin, if the pin is configured for general-purpose output.
 */
#define GPIO_PDOR_PDO17(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDOR_PDO17_SHIFT)) & GPIO_PDOR_PDO17_MASK)

#define GPIO_PDOR_PDO18_MASK                     (0x40000U)
#define GPIO_PDOR_PDO18_SHIFT                    (18U)
/*! PDO18 - Port Data Output
 *  0b0..Logic level 0 is driven on pin, if the pin is configured for general-purpose output.
 *  0b1..Logic level 1 is driven on pin, if the pin is configured for general-purpose output.
 */
#define GPIO_PDOR_PDO18(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDOR_PDO18_SHIFT)) & GPIO_PDOR_PDO18_MASK)

#define GPIO_PDOR_PDO19_MASK                     (0x80000U)
#define GPIO_PDOR_PDO19_SHIFT                    (19U)
/*! PDO19 - Port Data Output
 *  0b0..Logic level 0 is driven on pin, if the pin is configured for general-purpose output.
 *  0b1..Logic level 1 is driven on pin, if the pin is configured for general-purpose output.
 */
#define GPIO_PDOR_PDO19(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDOR_PDO19_SHIFT)) & GPIO_PDOR_PDO19_MASK)

#define GPIO_PDOR_PDO20_MASK                     (0x100000U)
#define GPIO_PDOR_PDO20_SHIFT                    (20U)
/*! PDO20 - Port Data Output
 *  0b0..Logic level 0 is driven on pin, if the pin is configured for general-purpose output.
 *  0b1..Logic level 1 is driven on pin, if the pin is configured for general-purpose output.
 */
#define GPIO_PDOR_PDO20(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDOR_PDO20_SHIFT)) & GPIO_PDOR_PDO20_MASK)

#define GPIO_PDOR_PDO21_MASK                     (0x200000U)
#define GPIO_PDOR_PDO21_SHIFT                    (21U)
/*! PDO21 - Port Data Output
 *  0b0..Logic level 0 is driven on pin, if the pin is configured for general-purpose output.
 *  0b1..Logic level 1 is driven on pin, if the pin is configured for general-purpose output.
 */
#define GPIO_PDOR_PDO21(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDOR_PDO21_SHIFT)) & GPIO_PDOR_PDO21_MASK)

#define GPIO_PDOR_PDO22_MASK                     (0x400000U)
#define GPIO_PDOR_PDO22_SHIFT                    (22U)
/*! PDO22 - Port Data Output
 *  0b0..Logic level 0 is driven on pin, if the pin is configured for general-purpose output.
 *  0b1..Logic level 1 is driven on pin, if the pin is configured for general-purpose output.
 */
#define GPIO_PDOR_PDO22(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDOR_PDO22_SHIFT)) & GPIO_PDOR_PDO22_MASK)

#define GPIO_PDOR_PDO23_MASK                     (0x800000U)
#define GPIO_PDOR_PDO23_SHIFT                    (23U)
/*! PDO23 - Port Data Output
 *  0b0..Logic level 0 is driven on pin, if the pin is configured for general-purpose output.
 *  0b1..Logic level 1 is driven on pin, if the pin is configured for general-purpose output.
 */
#define GPIO_PDOR_PDO23(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDOR_PDO23_SHIFT)) & GPIO_PDOR_PDO23_MASK)

#define GPIO_PDOR_PDO24_MASK                     (0x1000000U)
#define GPIO_PDOR_PDO24_SHIFT                    (24U)
/*! PDO24 - Port Data Output
 *  0b0..Logic level 0 is driven on pin, if the pin is configured for general-purpose output.
 *  0b1..Logic level 1 is driven on pin, if the pin is configured for general-purpose output.
 */
#define GPIO_PDOR_PDO24(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDOR_PDO24_SHIFT)) & GPIO_PDOR_PDO24_MASK)

#define GPIO_PDOR_PDO25_MASK                     (0x2000000U)
#define GPIO_PDOR_PDO25_SHIFT                    (25U)
/*! PDO25 - Port Data Output
 *  0b0..Logic level 0 is driven on pin, if the pin is configured for general-purpose output.
 *  0b1..Logic level 1 is driven on pin, if the pin is configured for general-purpose output.
 */
#define GPIO_PDOR_PDO25(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDOR_PDO25_SHIFT)) & GPIO_PDOR_PDO25_MASK)

#define GPIO_PDOR_PDO26_MASK                     (0x4000000U)
#define GPIO_PDOR_PDO26_SHIFT                    (26U)
/*! PDO26 - Port Data Output
 *  0b0..Logic level 0 is driven on pin, if the pin is configured for general-purpose output.
 *  0b1..Logic level 1 is driven on pin, if the pin is configured for general-purpose output.
 */
#define GPIO_PDOR_PDO26(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDOR_PDO26_SHIFT)) & GPIO_PDOR_PDO26_MASK)

#define GPIO_PDOR_PDO27_MASK                     (0x8000000U)
#define GPIO_PDOR_PDO27_SHIFT                    (27U)
/*! PDO27 - Port Data Output
 *  0b0..Logic level 0 is driven on pin, if the pin is configured for general-purpose output.
 *  0b1..Logic level 1 is driven on pin, if the pin is configured for general-purpose output.
 */
#define GPIO_PDOR_PDO27(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDOR_PDO27_SHIFT)) & GPIO_PDOR_PDO27_MASK)

#define GPIO_PDOR_PDO28_MASK                     (0x10000000U)
#define GPIO_PDOR_PDO28_SHIFT                    (28U)
/*! PDO28 - Port Data Output
 *  0b0..Logic level 0 is driven on pin, if the pin is configured for general-purpose output.
 *  0b1..Logic level 1 is driven on pin, if the pin is configured for general-purpose output.
 */
#define GPIO_PDOR_PDO28(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDOR_PDO28_SHIFT)) & GPIO_PDOR_PDO28_MASK)

#define GPIO_PDOR_PDO29_MASK                     (0x20000000U)
#define GPIO_PDOR_PDO29_SHIFT                    (29U)
/*! PDO29 - Port Data Output
 *  0b0..Logic level 0 is driven on pin, if the pin is configured for general-purpose output.
 *  0b1..Logic level 1 is driven on pin, if the pin is configured for general-purpose output.
 */
#define GPIO_PDOR_PDO29(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDOR_PDO29_SHIFT)) & GPIO_PDOR_PDO29_MASK)

#define GPIO_PDOR_PDO30_MASK                     (0x40000000U)
#define GPIO_PDOR_PDO30_SHIFT                    (30U)
/*! PDO30 - Port Data Output
 *  0b0..Logic level 0 is driven on pin, if the pin is configured for general-purpose output.
 *  0b1..Logic level 1 is driven on pin, if the pin is configured for general-purpose output.
 */
#define GPIO_PDOR_PDO30(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDOR_PDO30_SHIFT)) & GPIO_PDOR_PDO30_MASK)

#define GPIO_PDOR_PDO31_MASK                     (0x80000000U)
#define GPIO_PDOR_PDO31_SHIFT                    (31U)
/*! PDO31 - Port Data Output
 *  0b0..Logic level 0 is driven on pin, if the pin is configured for general-purpose output.
 *  0b1..Logic level 1 is driven on pin, if the pin is configured for general-purpose output.
 */
#define GPIO_PDOR_PDO31(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDOR_PDO31_SHIFT)) & GPIO_PDOR_PDO31_MASK)
/*! @} */

/*! @name PSOR - Port Set Output Register */
/*! @{ */

#define GPIO_PSOR_PTSO0_MASK                     (0x1U)
#define GPIO_PSOR_PTSO0_SHIFT                    (0U)
/*! PTSO0 - Port Set Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is set to logic 1.
 */
#define GPIO_PSOR_PTSO0(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PSOR_PTSO0_SHIFT)) & GPIO_PSOR_PTSO0_MASK)

#define GPIO_PSOR_PTSO1_MASK                     (0x2U)
#define GPIO_PSOR_PTSO1_SHIFT                    (1U)
/*! PTSO1 - Port Set Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is set to logic 1.
 */
#define GPIO_PSOR_PTSO1(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PSOR_PTSO1_SHIFT)) & GPIO_PSOR_PTSO1_MASK)

#define GPIO_PSOR_PTSO2_MASK                     (0x4U)
#define GPIO_PSOR_PTSO2_SHIFT                    (2U)
/*! PTSO2 - Port Set Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is set to logic 1.
 */
#define GPIO_PSOR_PTSO2(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PSOR_PTSO2_SHIFT)) & GPIO_PSOR_PTSO2_MASK)

#define GPIO_PSOR_PTSO3_MASK                     (0x8U)
#define GPIO_PSOR_PTSO3_SHIFT                    (3U)
/*! PTSO3 - Port Set Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is set to logic 1.
 */
#define GPIO_PSOR_PTSO3(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PSOR_PTSO3_SHIFT)) & GPIO_PSOR_PTSO3_MASK)

#define GPIO_PSOR_PTSO4_MASK                     (0x10U)
#define GPIO_PSOR_PTSO4_SHIFT                    (4U)
/*! PTSO4 - Port Set Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is set to logic 1.
 */
#define GPIO_PSOR_PTSO4(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PSOR_PTSO4_SHIFT)) & GPIO_PSOR_PTSO4_MASK)

#define GPIO_PSOR_PTSO5_MASK                     (0x20U)
#define GPIO_PSOR_PTSO5_SHIFT                    (5U)
/*! PTSO5 - Port Set Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is set to logic 1.
 */
#define GPIO_PSOR_PTSO5(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PSOR_PTSO5_SHIFT)) & GPIO_PSOR_PTSO5_MASK)

#define GPIO_PSOR_PTSO6_MASK                     (0x40U)
#define GPIO_PSOR_PTSO6_SHIFT                    (6U)
/*! PTSO6 - Port Set Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is set to logic 1.
 */
#define GPIO_PSOR_PTSO6(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PSOR_PTSO6_SHIFT)) & GPIO_PSOR_PTSO6_MASK)

#define GPIO_PSOR_PTSO7_MASK                     (0x80U)
#define GPIO_PSOR_PTSO7_SHIFT                    (7U)
/*! PTSO7 - Port Set Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is set to logic 1.
 */
#define GPIO_PSOR_PTSO7(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PSOR_PTSO7_SHIFT)) & GPIO_PSOR_PTSO7_MASK)

#define GPIO_PSOR_PTSO8_MASK                     (0x100U)
#define GPIO_PSOR_PTSO8_SHIFT                    (8U)
/*! PTSO8 - Port Set Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is set to logic 1.
 */
#define GPIO_PSOR_PTSO8(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PSOR_PTSO8_SHIFT)) & GPIO_PSOR_PTSO8_MASK)

#define GPIO_PSOR_PTSO9_MASK                     (0x200U)
#define GPIO_PSOR_PTSO9_SHIFT                    (9U)
/*! PTSO9 - Port Set Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is set to logic 1.
 */
#define GPIO_PSOR_PTSO9(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PSOR_PTSO9_SHIFT)) & GPIO_PSOR_PTSO9_MASK)

#define GPIO_PSOR_PTSO10_MASK                    (0x400U)
#define GPIO_PSOR_PTSO10_SHIFT                   (10U)
/*! PTSO10 - Port Set Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is set to logic 1.
 */
#define GPIO_PSOR_PTSO10(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PSOR_PTSO10_SHIFT)) & GPIO_PSOR_PTSO10_MASK)

#define GPIO_PSOR_PTSO11_MASK                    (0x800U)
#define GPIO_PSOR_PTSO11_SHIFT                   (11U)
/*! PTSO11 - Port Set Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is set to logic 1.
 */
#define GPIO_PSOR_PTSO11(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PSOR_PTSO11_SHIFT)) & GPIO_PSOR_PTSO11_MASK)

#define GPIO_PSOR_PTSO12_MASK                    (0x1000U)
#define GPIO_PSOR_PTSO12_SHIFT                   (12U)
/*! PTSO12 - Port Set Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is set to logic 1.
 */
#define GPIO_PSOR_PTSO12(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PSOR_PTSO12_SHIFT)) & GPIO_PSOR_PTSO12_MASK)

#define GPIO_PSOR_PTSO13_MASK                    (0x2000U)
#define GPIO_PSOR_PTSO13_SHIFT                   (13U)
/*! PTSO13 - Port Set Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is set to logic 1.
 */
#define GPIO_PSOR_PTSO13(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PSOR_PTSO13_SHIFT)) & GPIO_PSOR_PTSO13_MASK)

#define GPIO_PSOR_PTSO14_MASK                    (0x4000U)
#define GPIO_PSOR_PTSO14_SHIFT                   (14U)
/*! PTSO14 - Port Set Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is set to logic 1.
 */
#define GPIO_PSOR_PTSO14(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PSOR_PTSO14_SHIFT)) & GPIO_PSOR_PTSO14_MASK)

#define GPIO_PSOR_PTSO15_MASK                    (0x8000U)
#define GPIO_PSOR_PTSO15_SHIFT                   (15U)
/*! PTSO15 - Port Set Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is set to logic 1.
 */
#define GPIO_PSOR_PTSO15(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PSOR_PTSO15_SHIFT)) & GPIO_PSOR_PTSO15_MASK)

#define GPIO_PSOR_PTSO16_MASK                    (0x10000U)
#define GPIO_PSOR_PTSO16_SHIFT                   (16U)
/*! PTSO16 - Port Set Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is set to logic 1.
 */
#define GPIO_PSOR_PTSO16(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PSOR_PTSO16_SHIFT)) & GPIO_PSOR_PTSO16_MASK)

#define GPIO_PSOR_PTSO17_MASK                    (0x20000U)
#define GPIO_PSOR_PTSO17_SHIFT                   (17U)
/*! PTSO17 - Port Set Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is set to logic 1.
 */
#define GPIO_PSOR_PTSO17(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PSOR_PTSO17_SHIFT)) & GPIO_PSOR_PTSO17_MASK)

#define GPIO_PSOR_PTSO18_MASK                    (0x40000U)
#define GPIO_PSOR_PTSO18_SHIFT                   (18U)
/*! PTSO18 - Port Set Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is set to logic 1.
 */
#define GPIO_PSOR_PTSO18(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PSOR_PTSO18_SHIFT)) & GPIO_PSOR_PTSO18_MASK)

#define GPIO_PSOR_PTSO19_MASK                    (0x80000U)
#define GPIO_PSOR_PTSO19_SHIFT                   (19U)
/*! PTSO19 - Port Set Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is set to logic 1.
 */
#define GPIO_PSOR_PTSO19(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PSOR_PTSO19_SHIFT)) & GPIO_PSOR_PTSO19_MASK)

#define GPIO_PSOR_PTSO20_MASK                    (0x100000U)
#define GPIO_PSOR_PTSO20_SHIFT                   (20U)
/*! PTSO20 - Port Set Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is set to logic 1.
 */
#define GPIO_PSOR_PTSO20(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PSOR_PTSO20_SHIFT)) & GPIO_PSOR_PTSO20_MASK)

#define GPIO_PSOR_PTSO21_MASK                    (0x200000U)
#define GPIO_PSOR_PTSO21_SHIFT                   (21U)
/*! PTSO21 - Port Set Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is set to logic 1.
 */
#define GPIO_PSOR_PTSO21(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PSOR_PTSO21_SHIFT)) & GPIO_PSOR_PTSO21_MASK)

#define GPIO_PSOR_PTSO22_MASK                    (0x400000U)
#define GPIO_PSOR_PTSO22_SHIFT                   (22U)
/*! PTSO22 - Port Set Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is set to logic 1.
 */
#define GPIO_PSOR_PTSO22(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PSOR_PTSO22_SHIFT)) & GPIO_PSOR_PTSO22_MASK)

#define GPIO_PSOR_PTSO23_MASK                    (0x800000U)
#define GPIO_PSOR_PTSO23_SHIFT                   (23U)
/*! PTSO23 - Port Set Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is set to logic 1.
 */
#define GPIO_PSOR_PTSO23(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PSOR_PTSO23_SHIFT)) & GPIO_PSOR_PTSO23_MASK)

#define GPIO_PSOR_PTSO24_MASK                    (0x1000000U)
#define GPIO_PSOR_PTSO24_SHIFT                   (24U)
/*! PTSO24 - Port Set Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is set to logic 1.
 */
#define GPIO_PSOR_PTSO24(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PSOR_PTSO24_SHIFT)) & GPIO_PSOR_PTSO24_MASK)

#define GPIO_PSOR_PTSO25_MASK                    (0x2000000U)
#define GPIO_PSOR_PTSO25_SHIFT                   (25U)
/*! PTSO25 - Port Set Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is set to logic 1.
 */
#define GPIO_PSOR_PTSO25(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PSOR_PTSO25_SHIFT)) & GPIO_PSOR_PTSO25_MASK)

#define GPIO_PSOR_PTSO26_MASK                    (0x4000000U)
#define GPIO_PSOR_PTSO26_SHIFT                   (26U)
/*! PTSO26 - Port Set Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is set to logic 1.
 */
#define GPIO_PSOR_PTSO26(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PSOR_PTSO26_SHIFT)) & GPIO_PSOR_PTSO26_MASK)

#define GPIO_PSOR_PTSO27_MASK                    (0x8000000U)
#define GPIO_PSOR_PTSO27_SHIFT                   (27U)
/*! PTSO27 - Port Set Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is set to logic 1.
 */
#define GPIO_PSOR_PTSO27(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PSOR_PTSO27_SHIFT)) & GPIO_PSOR_PTSO27_MASK)

#define GPIO_PSOR_PTSO28_MASK                    (0x10000000U)
#define GPIO_PSOR_PTSO28_SHIFT                   (28U)
/*! PTSO28 - Port Set Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is set to logic 1.
 */
#define GPIO_PSOR_PTSO28(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PSOR_PTSO28_SHIFT)) & GPIO_PSOR_PTSO28_MASK)

#define GPIO_PSOR_PTSO29_MASK                    (0x20000000U)
#define GPIO_PSOR_PTSO29_SHIFT                   (29U)
/*! PTSO29 - Port Set Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is set to logic 1.
 */
#define GPIO_PSOR_PTSO29(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PSOR_PTSO29_SHIFT)) & GPIO_PSOR_PTSO29_MASK)

#define GPIO_PSOR_PTSO30_MASK                    (0x40000000U)
#define GPIO_PSOR_PTSO30_SHIFT                   (30U)
/*! PTSO30 - Port Set Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is set to logic 1.
 */
#define GPIO_PSOR_PTSO30(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PSOR_PTSO30_SHIFT)) & GPIO_PSOR_PTSO30_MASK)

#define GPIO_PSOR_PTSO31_MASK                    (0x80000000U)
#define GPIO_PSOR_PTSO31_SHIFT                   (31U)
/*! PTSO31 - Port Set Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is set to logic 1.
 */
#define GPIO_PSOR_PTSO31(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PSOR_PTSO31_SHIFT)) & GPIO_PSOR_PTSO31_MASK)
/*! @} */

/*! @name PCOR - Port Clear Output Register */
/*! @{ */

#define GPIO_PCOR_PTCO0_MASK                     (0x1U)
#define GPIO_PCOR_PTCO0_SHIFT                    (0U)
/*! PTCO0 - Port Clear Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is cleared to logic 0.
 */
#define GPIO_PCOR_PTCO0(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PCOR_PTCO0_SHIFT)) & GPIO_PCOR_PTCO0_MASK)

#define GPIO_PCOR_PTCO1_MASK                     (0x2U)
#define GPIO_PCOR_PTCO1_SHIFT                    (1U)
/*! PTCO1 - Port Clear Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is cleared to logic 0.
 */
#define GPIO_PCOR_PTCO1(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PCOR_PTCO1_SHIFT)) & GPIO_PCOR_PTCO1_MASK)

#define GPIO_PCOR_PTCO2_MASK                     (0x4U)
#define GPIO_PCOR_PTCO2_SHIFT                    (2U)
/*! PTCO2 - Port Clear Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is cleared to logic 0.
 */
#define GPIO_PCOR_PTCO2(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PCOR_PTCO2_SHIFT)) & GPIO_PCOR_PTCO2_MASK)

#define GPIO_PCOR_PTCO3_MASK                     (0x8U)
#define GPIO_PCOR_PTCO3_SHIFT                    (3U)
/*! PTCO3 - Port Clear Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is cleared to logic 0.
 */
#define GPIO_PCOR_PTCO3(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PCOR_PTCO3_SHIFT)) & GPIO_PCOR_PTCO3_MASK)

#define GPIO_PCOR_PTCO4_MASK                     (0x10U)
#define GPIO_PCOR_PTCO4_SHIFT                    (4U)
/*! PTCO4 - Port Clear Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is cleared to logic 0.
 */
#define GPIO_PCOR_PTCO4(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PCOR_PTCO4_SHIFT)) & GPIO_PCOR_PTCO4_MASK)

#define GPIO_PCOR_PTCO5_MASK                     (0x20U)
#define GPIO_PCOR_PTCO5_SHIFT                    (5U)
/*! PTCO5 - Port Clear Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is cleared to logic 0.
 */
#define GPIO_PCOR_PTCO5(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PCOR_PTCO5_SHIFT)) & GPIO_PCOR_PTCO5_MASK)

#define GPIO_PCOR_PTCO6_MASK                     (0x40U)
#define GPIO_PCOR_PTCO6_SHIFT                    (6U)
/*! PTCO6 - Port Clear Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is cleared to logic 0.
 */
#define GPIO_PCOR_PTCO6(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PCOR_PTCO6_SHIFT)) & GPIO_PCOR_PTCO6_MASK)

#define GPIO_PCOR_PTCO7_MASK                     (0x80U)
#define GPIO_PCOR_PTCO7_SHIFT                    (7U)
/*! PTCO7 - Port Clear Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is cleared to logic 0.
 */
#define GPIO_PCOR_PTCO7(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PCOR_PTCO7_SHIFT)) & GPIO_PCOR_PTCO7_MASK)

#define GPIO_PCOR_PTCO8_MASK                     (0x100U)
#define GPIO_PCOR_PTCO8_SHIFT                    (8U)
/*! PTCO8 - Port Clear Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is cleared to logic 0.
 */
#define GPIO_PCOR_PTCO8(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PCOR_PTCO8_SHIFT)) & GPIO_PCOR_PTCO8_MASK)

#define GPIO_PCOR_PTCO9_MASK                     (0x200U)
#define GPIO_PCOR_PTCO9_SHIFT                    (9U)
/*! PTCO9 - Port Clear Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is cleared to logic 0.
 */
#define GPIO_PCOR_PTCO9(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PCOR_PTCO9_SHIFT)) & GPIO_PCOR_PTCO9_MASK)

#define GPIO_PCOR_PTCO10_MASK                    (0x400U)
#define GPIO_PCOR_PTCO10_SHIFT                   (10U)
/*! PTCO10 - Port Clear Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is cleared to logic 0.
 */
#define GPIO_PCOR_PTCO10(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PCOR_PTCO10_SHIFT)) & GPIO_PCOR_PTCO10_MASK)

#define GPIO_PCOR_PTCO11_MASK                    (0x800U)
#define GPIO_PCOR_PTCO11_SHIFT                   (11U)
/*! PTCO11 - Port Clear Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is cleared to logic 0.
 */
#define GPIO_PCOR_PTCO11(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PCOR_PTCO11_SHIFT)) & GPIO_PCOR_PTCO11_MASK)

#define GPIO_PCOR_PTCO12_MASK                    (0x1000U)
#define GPIO_PCOR_PTCO12_SHIFT                   (12U)
/*! PTCO12 - Port Clear Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is cleared to logic 0.
 */
#define GPIO_PCOR_PTCO12(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PCOR_PTCO12_SHIFT)) & GPIO_PCOR_PTCO12_MASK)

#define GPIO_PCOR_PTCO13_MASK                    (0x2000U)
#define GPIO_PCOR_PTCO13_SHIFT                   (13U)
/*! PTCO13 - Port Clear Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is cleared to logic 0.
 */
#define GPIO_PCOR_PTCO13(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PCOR_PTCO13_SHIFT)) & GPIO_PCOR_PTCO13_MASK)

#define GPIO_PCOR_PTCO14_MASK                    (0x4000U)
#define GPIO_PCOR_PTCO14_SHIFT                   (14U)
/*! PTCO14 - Port Clear Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is cleared to logic 0.
 */
#define GPIO_PCOR_PTCO14(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PCOR_PTCO14_SHIFT)) & GPIO_PCOR_PTCO14_MASK)

#define GPIO_PCOR_PTCO15_MASK                    (0x8000U)
#define GPIO_PCOR_PTCO15_SHIFT                   (15U)
/*! PTCO15 - Port Clear Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is cleared to logic 0.
 */
#define GPIO_PCOR_PTCO15(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PCOR_PTCO15_SHIFT)) & GPIO_PCOR_PTCO15_MASK)

#define GPIO_PCOR_PTCO16_MASK                    (0x10000U)
#define GPIO_PCOR_PTCO16_SHIFT                   (16U)
/*! PTCO16 - Port Clear Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is cleared to logic 0.
 */
#define GPIO_PCOR_PTCO16(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PCOR_PTCO16_SHIFT)) & GPIO_PCOR_PTCO16_MASK)

#define GPIO_PCOR_PTCO17_MASK                    (0x20000U)
#define GPIO_PCOR_PTCO17_SHIFT                   (17U)
/*! PTCO17 - Port Clear Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is cleared to logic 0.
 */
#define GPIO_PCOR_PTCO17(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PCOR_PTCO17_SHIFT)) & GPIO_PCOR_PTCO17_MASK)

#define GPIO_PCOR_PTCO18_MASK                    (0x40000U)
#define GPIO_PCOR_PTCO18_SHIFT                   (18U)
/*! PTCO18 - Port Clear Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is cleared to logic 0.
 */
#define GPIO_PCOR_PTCO18(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PCOR_PTCO18_SHIFT)) & GPIO_PCOR_PTCO18_MASK)

#define GPIO_PCOR_PTCO19_MASK                    (0x80000U)
#define GPIO_PCOR_PTCO19_SHIFT                   (19U)
/*! PTCO19 - Port Clear Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is cleared to logic 0.
 */
#define GPIO_PCOR_PTCO19(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PCOR_PTCO19_SHIFT)) & GPIO_PCOR_PTCO19_MASK)

#define GPIO_PCOR_PTCO20_MASK                    (0x100000U)
#define GPIO_PCOR_PTCO20_SHIFT                   (20U)
/*! PTCO20 - Port Clear Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is cleared to logic 0.
 */
#define GPIO_PCOR_PTCO20(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PCOR_PTCO20_SHIFT)) & GPIO_PCOR_PTCO20_MASK)

#define GPIO_PCOR_PTCO21_MASK                    (0x200000U)
#define GPIO_PCOR_PTCO21_SHIFT                   (21U)
/*! PTCO21 - Port Clear Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is cleared to logic 0.
 */
#define GPIO_PCOR_PTCO21(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PCOR_PTCO21_SHIFT)) & GPIO_PCOR_PTCO21_MASK)

#define GPIO_PCOR_PTCO22_MASK                    (0x400000U)
#define GPIO_PCOR_PTCO22_SHIFT                   (22U)
/*! PTCO22 - Port Clear Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is cleared to logic 0.
 */
#define GPIO_PCOR_PTCO22(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PCOR_PTCO22_SHIFT)) & GPIO_PCOR_PTCO22_MASK)

#define GPIO_PCOR_PTCO23_MASK                    (0x800000U)
#define GPIO_PCOR_PTCO23_SHIFT                   (23U)
/*! PTCO23 - Port Clear Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is cleared to logic 0.
 */
#define GPIO_PCOR_PTCO23(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PCOR_PTCO23_SHIFT)) & GPIO_PCOR_PTCO23_MASK)

#define GPIO_PCOR_PTCO24_MASK                    (0x1000000U)
#define GPIO_PCOR_PTCO24_SHIFT                   (24U)
/*! PTCO24 - Port Clear Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is cleared to logic 0.
 */
#define GPIO_PCOR_PTCO24(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PCOR_PTCO24_SHIFT)) & GPIO_PCOR_PTCO24_MASK)

#define GPIO_PCOR_PTCO25_MASK                    (0x2000000U)
#define GPIO_PCOR_PTCO25_SHIFT                   (25U)
/*! PTCO25 - Port Clear Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is cleared to logic 0.
 */
#define GPIO_PCOR_PTCO25(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PCOR_PTCO25_SHIFT)) & GPIO_PCOR_PTCO25_MASK)

#define GPIO_PCOR_PTCO26_MASK                    (0x4000000U)
#define GPIO_PCOR_PTCO26_SHIFT                   (26U)
/*! PTCO26 - Port Clear Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is cleared to logic 0.
 */
#define GPIO_PCOR_PTCO26(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PCOR_PTCO26_SHIFT)) & GPIO_PCOR_PTCO26_MASK)

#define GPIO_PCOR_PTCO27_MASK                    (0x8000000U)
#define GPIO_PCOR_PTCO27_SHIFT                   (27U)
/*! PTCO27 - Port Clear Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is cleared to logic 0.
 */
#define GPIO_PCOR_PTCO27(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PCOR_PTCO27_SHIFT)) & GPIO_PCOR_PTCO27_MASK)

#define GPIO_PCOR_PTCO28_MASK                    (0x10000000U)
#define GPIO_PCOR_PTCO28_SHIFT                   (28U)
/*! PTCO28 - Port Clear Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is cleared to logic 0.
 */
#define GPIO_PCOR_PTCO28(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PCOR_PTCO28_SHIFT)) & GPIO_PCOR_PTCO28_MASK)

#define GPIO_PCOR_PTCO29_MASK                    (0x20000000U)
#define GPIO_PCOR_PTCO29_SHIFT                   (29U)
/*! PTCO29 - Port Clear Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is cleared to logic 0.
 */
#define GPIO_PCOR_PTCO29(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PCOR_PTCO29_SHIFT)) & GPIO_PCOR_PTCO29_MASK)

#define GPIO_PCOR_PTCO30_MASK                    (0x40000000U)
#define GPIO_PCOR_PTCO30_SHIFT                   (30U)
/*! PTCO30 - Port Clear Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is cleared to logic 0.
 */
#define GPIO_PCOR_PTCO30(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PCOR_PTCO30_SHIFT)) & GPIO_PCOR_PTCO30_MASK)

#define GPIO_PCOR_PTCO31_MASK                    (0x80000000U)
#define GPIO_PCOR_PTCO31_SHIFT                   (31U)
/*! PTCO31 - Port Clear Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is cleared to logic 0.
 */
#define GPIO_PCOR_PTCO31(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PCOR_PTCO31_SHIFT)) & GPIO_PCOR_PTCO31_MASK)
/*! @} */

/*! @name PTOR - Port Toggle Output Register */
/*! @{ */

#define GPIO_PTOR_PTTO0_MASK                     (0x1U)
#define GPIO_PTOR_PTTO0_SHIFT                    (0U)
/*! PTTO0 - Port Toggle Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is set to the inverse of its current logic state.
 */
#define GPIO_PTOR_PTTO0(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PTOR_PTTO0_SHIFT)) & GPIO_PTOR_PTTO0_MASK)

#define GPIO_PTOR_PTTO1_MASK                     (0x2U)
#define GPIO_PTOR_PTTO1_SHIFT                    (1U)
/*! PTTO1 - Port Toggle Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is set to the inverse of its current logic state.
 */
#define GPIO_PTOR_PTTO1(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PTOR_PTTO1_SHIFT)) & GPIO_PTOR_PTTO1_MASK)

#define GPIO_PTOR_PTTO2_MASK                     (0x4U)
#define GPIO_PTOR_PTTO2_SHIFT                    (2U)
/*! PTTO2 - Port Toggle Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is set to the inverse of its current logic state.
 */
#define GPIO_PTOR_PTTO2(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PTOR_PTTO2_SHIFT)) & GPIO_PTOR_PTTO2_MASK)

#define GPIO_PTOR_PTTO3_MASK                     (0x8U)
#define GPIO_PTOR_PTTO3_SHIFT                    (3U)
/*! PTTO3 - Port Toggle Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is set to the inverse of its current logic state.
 */
#define GPIO_PTOR_PTTO3(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PTOR_PTTO3_SHIFT)) & GPIO_PTOR_PTTO3_MASK)

#define GPIO_PTOR_PTTO4_MASK                     (0x10U)
#define GPIO_PTOR_PTTO4_SHIFT                    (4U)
/*! PTTO4 - Port Toggle Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is set to the inverse of its current logic state.
 */
#define GPIO_PTOR_PTTO4(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PTOR_PTTO4_SHIFT)) & GPIO_PTOR_PTTO4_MASK)

#define GPIO_PTOR_PTTO5_MASK                     (0x20U)
#define GPIO_PTOR_PTTO5_SHIFT                    (5U)
/*! PTTO5 - Port Toggle Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is set to the inverse of its current logic state.
 */
#define GPIO_PTOR_PTTO5(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PTOR_PTTO5_SHIFT)) & GPIO_PTOR_PTTO5_MASK)

#define GPIO_PTOR_PTTO6_MASK                     (0x40U)
#define GPIO_PTOR_PTTO6_SHIFT                    (6U)
/*! PTTO6 - Port Toggle Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is set to the inverse of its current logic state.
 */
#define GPIO_PTOR_PTTO6(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PTOR_PTTO6_SHIFT)) & GPIO_PTOR_PTTO6_MASK)

#define GPIO_PTOR_PTTO7_MASK                     (0x80U)
#define GPIO_PTOR_PTTO7_SHIFT                    (7U)
/*! PTTO7 - Port Toggle Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is set to the inverse of its current logic state.
 */
#define GPIO_PTOR_PTTO7(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PTOR_PTTO7_SHIFT)) & GPIO_PTOR_PTTO7_MASK)

#define GPIO_PTOR_PTTO8_MASK                     (0x100U)
#define GPIO_PTOR_PTTO8_SHIFT                    (8U)
/*! PTTO8 - Port Toggle Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is set to the inverse of its current logic state.
 */
#define GPIO_PTOR_PTTO8(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PTOR_PTTO8_SHIFT)) & GPIO_PTOR_PTTO8_MASK)

#define GPIO_PTOR_PTTO9_MASK                     (0x200U)
#define GPIO_PTOR_PTTO9_SHIFT                    (9U)
/*! PTTO9 - Port Toggle Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is set to the inverse of its current logic state.
 */
#define GPIO_PTOR_PTTO9(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PTOR_PTTO9_SHIFT)) & GPIO_PTOR_PTTO9_MASK)

#define GPIO_PTOR_PTTO10_MASK                    (0x400U)
#define GPIO_PTOR_PTTO10_SHIFT                   (10U)
/*! PTTO10 - Port Toggle Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is set to the inverse of its current logic state.
 */
#define GPIO_PTOR_PTTO10(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PTOR_PTTO10_SHIFT)) & GPIO_PTOR_PTTO10_MASK)

#define GPIO_PTOR_PTTO11_MASK                    (0x800U)
#define GPIO_PTOR_PTTO11_SHIFT                   (11U)
/*! PTTO11 - Port Toggle Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is set to the inverse of its current logic state.
 */
#define GPIO_PTOR_PTTO11(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PTOR_PTTO11_SHIFT)) & GPIO_PTOR_PTTO11_MASK)

#define GPIO_PTOR_PTTO12_MASK                    (0x1000U)
#define GPIO_PTOR_PTTO12_SHIFT                   (12U)
/*! PTTO12 - Port Toggle Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is set to the inverse of its current logic state.
 */
#define GPIO_PTOR_PTTO12(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PTOR_PTTO12_SHIFT)) & GPIO_PTOR_PTTO12_MASK)

#define GPIO_PTOR_PTTO13_MASK                    (0x2000U)
#define GPIO_PTOR_PTTO13_SHIFT                   (13U)
/*! PTTO13 - Port Toggle Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is set to the inverse of its current logic state.
 */
#define GPIO_PTOR_PTTO13(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PTOR_PTTO13_SHIFT)) & GPIO_PTOR_PTTO13_MASK)

#define GPIO_PTOR_PTTO14_MASK                    (0x4000U)
#define GPIO_PTOR_PTTO14_SHIFT                   (14U)
/*! PTTO14 - Port Toggle Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is set to the inverse of its current logic state.
 */
#define GPIO_PTOR_PTTO14(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PTOR_PTTO14_SHIFT)) & GPIO_PTOR_PTTO14_MASK)

#define GPIO_PTOR_PTTO15_MASK                    (0x8000U)
#define GPIO_PTOR_PTTO15_SHIFT                   (15U)
/*! PTTO15 - Port Toggle Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is set to the inverse of its current logic state.
 */
#define GPIO_PTOR_PTTO15(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PTOR_PTTO15_SHIFT)) & GPIO_PTOR_PTTO15_MASK)

#define GPIO_PTOR_PTTO16_MASK                    (0x10000U)
#define GPIO_PTOR_PTTO16_SHIFT                   (16U)
/*! PTTO16 - Port Toggle Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is set to the inverse of its current logic state.
 */
#define GPIO_PTOR_PTTO16(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PTOR_PTTO16_SHIFT)) & GPIO_PTOR_PTTO16_MASK)

#define GPIO_PTOR_PTTO17_MASK                    (0x20000U)
#define GPIO_PTOR_PTTO17_SHIFT                   (17U)
/*! PTTO17 - Port Toggle Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is set to the inverse of its current logic state.
 */
#define GPIO_PTOR_PTTO17(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PTOR_PTTO17_SHIFT)) & GPIO_PTOR_PTTO17_MASK)

#define GPIO_PTOR_PTTO18_MASK                    (0x40000U)
#define GPIO_PTOR_PTTO18_SHIFT                   (18U)
/*! PTTO18 - Port Toggle Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is set to the inverse of its current logic state.
 */
#define GPIO_PTOR_PTTO18(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PTOR_PTTO18_SHIFT)) & GPIO_PTOR_PTTO18_MASK)

#define GPIO_PTOR_PTTO19_MASK                    (0x80000U)
#define GPIO_PTOR_PTTO19_SHIFT                   (19U)
/*! PTTO19 - Port Toggle Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is set to the inverse of its current logic state.
 */
#define GPIO_PTOR_PTTO19(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PTOR_PTTO19_SHIFT)) & GPIO_PTOR_PTTO19_MASK)

#define GPIO_PTOR_PTTO20_MASK                    (0x100000U)
#define GPIO_PTOR_PTTO20_SHIFT                   (20U)
/*! PTTO20 - Port Toggle Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is set to the inverse of its current logic state.
 */
#define GPIO_PTOR_PTTO20(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PTOR_PTTO20_SHIFT)) & GPIO_PTOR_PTTO20_MASK)

#define GPIO_PTOR_PTTO21_MASK                    (0x200000U)
#define GPIO_PTOR_PTTO21_SHIFT                   (21U)
/*! PTTO21 - Port Toggle Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is set to the inverse of its current logic state.
 */
#define GPIO_PTOR_PTTO21(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PTOR_PTTO21_SHIFT)) & GPIO_PTOR_PTTO21_MASK)

#define GPIO_PTOR_PTTO22_MASK                    (0x400000U)
#define GPIO_PTOR_PTTO22_SHIFT                   (22U)
/*! PTTO22 - Port Toggle Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is set to the inverse of its current logic state.
 */
#define GPIO_PTOR_PTTO22(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PTOR_PTTO22_SHIFT)) & GPIO_PTOR_PTTO22_MASK)

#define GPIO_PTOR_PTTO23_MASK                    (0x800000U)
#define GPIO_PTOR_PTTO23_SHIFT                   (23U)
/*! PTTO23 - Port Toggle Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is set to the inverse of its current logic state.
 */
#define GPIO_PTOR_PTTO23(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PTOR_PTTO23_SHIFT)) & GPIO_PTOR_PTTO23_MASK)

#define GPIO_PTOR_PTTO24_MASK                    (0x1000000U)
#define GPIO_PTOR_PTTO24_SHIFT                   (24U)
/*! PTTO24 - Port Toggle Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is set to the inverse of its current logic state.
 */
#define GPIO_PTOR_PTTO24(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PTOR_PTTO24_SHIFT)) & GPIO_PTOR_PTTO24_MASK)

#define GPIO_PTOR_PTTO25_MASK                    (0x2000000U)
#define GPIO_PTOR_PTTO25_SHIFT                   (25U)
/*! PTTO25 - Port Toggle Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is set to the inverse of its current logic state.
 */
#define GPIO_PTOR_PTTO25(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PTOR_PTTO25_SHIFT)) & GPIO_PTOR_PTTO25_MASK)

#define GPIO_PTOR_PTTO26_MASK                    (0x4000000U)
#define GPIO_PTOR_PTTO26_SHIFT                   (26U)
/*! PTTO26 - Port Toggle Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is set to the inverse of its current logic state.
 */
#define GPIO_PTOR_PTTO26(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PTOR_PTTO26_SHIFT)) & GPIO_PTOR_PTTO26_MASK)

#define GPIO_PTOR_PTTO27_MASK                    (0x8000000U)
#define GPIO_PTOR_PTTO27_SHIFT                   (27U)
/*! PTTO27 - Port Toggle Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is set to the inverse of its current logic state.
 */
#define GPIO_PTOR_PTTO27(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PTOR_PTTO27_SHIFT)) & GPIO_PTOR_PTTO27_MASK)

#define GPIO_PTOR_PTTO28_MASK                    (0x10000000U)
#define GPIO_PTOR_PTTO28_SHIFT                   (28U)
/*! PTTO28 - Port Toggle Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is set to the inverse of its current logic state.
 */
#define GPIO_PTOR_PTTO28(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PTOR_PTTO28_SHIFT)) & GPIO_PTOR_PTTO28_MASK)

#define GPIO_PTOR_PTTO29_MASK                    (0x20000000U)
#define GPIO_PTOR_PTTO29_SHIFT                   (29U)
/*! PTTO29 - Port Toggle Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is set to the inverse of its current logic state.
 */
#define GPIO_PTOR_PTTO29(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PTOR_PTTO29_SHIFT)) & GPIO_PTOR_PTTO29_MASK)

#define GPIO_PTOR_PTTO30_MASK                    (0x40000000U)
#define GPIO_PTOR_PTTO30_SHIFT                   (30U)
/*! PTTO30 - Port Toggle Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is set to the inverse of its current logic state.
 */
#define GPIO_PTOR_PTTO30(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PTOR_PTTO30_SHIFT)) & GPIO_PTOR_PTTO30_MASK)

#define GPIO_PTOR_PTTO31_MASK                    (0x80000000U)
#define GPIO_PTOR_PTTO31_SHIFT                   (31U)
/*! PTTO31 - Port Toggle Output
 *  0b0..Corresponding field of PDOR[PDOn] does not change.
 *  0b1..Corresponding field of PDOR[PDOn] is set to the inverse of its current logic state.
 */
#define GPIO_PTOR_PTTO31(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_PTOR_PTTO31_SHIFT)) & GPIO_PTOR_PTTO31_MASK)
/*! @} */

/*! @name PDIR - Port Data Input Register */
/*! @{ */

#define GPIO_PDIR_PDI0_MASK                      (0x1U)
#define GPIO_PDIR_PDI0_SHIFT                     (0U)
/*! PDI0 - Port Data Input
 *  0b0..Pin logic level is logic 0, or is not configured for use by digital function.
 *  0b1..Pin logic level is logic 1.
 */
#define GPIO_PDIR_PDI0(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PDIR_PDI0_SHIFT)) & GPIO_PDIR_PDI0_MASK)

#define GPIO_PDIR_PDI1_MASK                      (0x2U)
#define GPIO_PDIR_PDI1_SHIFT                     (1U)
/*! PDI1 - Port Data Input
 *  0b0..Pin logic level is logic 0, or is not configured for use by digital function.
 *  0b1..Pin logic level is logic 1.
 */
#define GPIO_PDIR_PDI1(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PDIR_PDI1_SHIFT)) & GPIO_PDIR_PDI1_MASK)

#define GPIO_PDIR_PDI2_MASK                      (0x4U)
#define GPIO_PDIR_PDI2_SHIFT                     (2U)
/*! PDI2 - Port Data Input
 *  0b0..Pin logic level is logic 0, or is not configured for use by digital function.
 *  0b1..Pin logic level is logic 1.
 */
#define GPIO_PDIR_PDI2(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PDIR_PDI2_SHIFT)) & GPIO_PDIR_PDI2_MASK)

#define GPIO_PDIR_PDI3_MASK                      (0x8U)
#define GPIO_PDIR_PDI3_SHIFT                     (3U)
/*! PDI3 - Port Data Input
 *  0b0..Pin logic level is logic 0, or is not configured for use by digital function.
 *  0b1..Pin logic level is logic 1.
 */
#define GPIO_PDIR_PDI3(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PDIR_PDI3_SHIFT)) & GPIO_PDIR_PDI3_MASK)

#define GPIO_PDIR_PDI4_MASK                      (0x10U)
#define GPIO_PDIR_PDI4_SHIFT                     (4U)
/*! PDI4 - Port Data Input
 *  0b0..Pin logic level is logic 0, or is not configured for use by digital function.
 *  0b1..Pin logic level is logic 1.
 */
#define GPIO_PDIR_PDI4(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PDIR_PDI4_SHIFT)) & GPIO_PDIR_PDI4_MASK)

#define GPIO_PDIR_PDI5_MASK                      (0x20U)
#define GPIO_PDIR_PDI5_SHIFT                     (5U)
/*! PDI5 - Port Data Input
 *  0b0..Pin logic level is logic 0, or is not configured for use by digital function.
 *  0b1..Pin logic level is logic 1.
 */
#define GPIO_PDIR_PDI5(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PDIR_PDI5_SHIFT)) & GPIO_PDIR_PDI5_MASK)

#define GPIO_PDIR_PDI6_MASK                      (0x40U)
#define GPIO_PDIR_PDI6_SHIFT                     (6U)
/*! PDI6 - Port Data Input
 *  0b0..Pin logic level is logic 0, or is not configured for use by digital function.
 *  0b1..Pin logic level is logic 1.
 */
#define GPIO_PDIR_PDI6(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PDIR_PDI6_SHIFT)) & GPIO_PDIR_PDI6_MASK)

#define GPIO_PDIR_PDI7_MASK                      (0x80U)
#define GPIO_PDIR_PDI7_SHIFT                     (7U)
/*! PDI7 - Port Data Input
 *  0b0..Pin logic level is logic 0, or is not configured for use by digital function.
 *  0b1..Pin logic level is logic 1.
 */
#define GPIO_PDIR_PDI7(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PDIR_PDI7_SHIFT)) & GPIO_PDIR_PDI7_MASK)

#define GPIO_PDIR_PDI8_MASK                      (0x100U)
#define GPIO_PDIR_PDI8_SHIFT                     (8U)
/*! PDI8 - Port Data Input
 *  0b0..Pin logic level is logic 0, or is not configured for use by digital function.
 *  0b1..Pin logic level is logic 1.
 */
#define GPIO_PDIR_PDI8(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PDIR_PDI8_SHIFT)) & GPIO_PDIR_PDI8_MASK)

#define GPIO_PDIR_PDI9_MASK                      (0x200U)
#define GPIO_PDIR_PDI9_SHIFT                     (9U)
/*! PDI9 - Port Data Input
 *  0b0..Pin logic level is logic 0, or is not configured for use by digital function.
 *  0b1..Pin logic level is logic 1.
 */
#define GPIO_PDIR_PDI9(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PDIR_PDI9_SHIFT)) & GPIO_PDIR_PDI9_MASK)

#define GPIO_PDIR_PDI10_MASK                     (0x400U)
#define GPIO_PDIR_PDI10_SHIFT                    (10U)
/*! PDI10 - Port Data Input
 *  0b0..Pin logic level is logic 0, or is not configured for use by digital function.
 *  0b1..Pin logic level is logic 1.
 */
#define GPIO_PDIR_PDI10(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDIR_PDI10_SHIFT)) & GPIO_PDIR_PDI10_MASK)

#define GPIO_PDIR_PDI11_MASK                     (0x800U)
#define GPIO_PDIR_PDI11_SHIFT                    (11U)
/*! PDI11 - Port Data Input
 *  0b0..Pin logic level is logic 0, or is not configured for use by digital function.
 *  0b1..Pin logic level is logic 1.
 */
#define GPIO_PDIR_PDI11(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDIR_PDI11_SHIFT)) & GPIO_PDIR_PDI11_MASK)

#define GPIO_PDIR_PDI12_MASK                     (0x1000U)
#define GPIO_PDIR_PDI12_SHIFT                    (12U)
/*! PDI12 - Port Data Input
 *  0b0..Pin logic level is logic 0, or is not configured for use by digital function.
 *  0b1..Pin logic level is logic 1.
 */
#define GPIO_PDIR_PDI12(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDIR_PDI12_SHIFT)) & GPIO_PDIR_PDI12_MASK)

#define GPIO_PDIR_PDI13_MASK                     (0x2000U)
#define GPIO_PDIR_PDI13_SHIFT                    (13U)
/*! PDI13 - Port Data Input
 *  0b0..Pin logic level is logic 0, or is not configured for use by digital function.
 *  0b1..Pin logic level is logic 1.
 */
#define GPIO_PDIR_PDI13(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDIR_PDI13_SHIFT)) & GPIO_PDIR_PDI13_MASK)

#define GPIO_PDIR_PDI14_MASK                     (0x4000U)
#define GPIO_PDIR_PDI14_SHIFT                    (14U)
/*! PDI14 - Port Data Input
 *  0b0..Pin logic level is logic 0, or is not configured for use by digital function.
 *  0b1..Pin logic level is logic 1.
 */
#define GPIO_PDIR_PDI14(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDIR_PDI14_SHIFT)) & GPIO_PDIR_PDI14_MASK)

#define GPIO_PDIR_PDI15_MASK                     (0x8000U)
#define GPIO_PDIR_PDI15_SHIFT                    (15U)
/*! PDI15 - Port Data Input
 *  0b0..Pin logic level is logic 0, or is not configured for use by digital function.
 *  0b1..Pin logic level is logic 1.
 */
#define GPIO_PDIR_PDI15(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDIR_PDI15_SHIFT)) & GPIO_PDIR_PDI15_MASK)

#define GPIO_PDIR_PDI16_MASK                     (0x10000U)
#define GPIO_PDIR_PDI16_SHIFT                    (16U)
/*! PDI16 - Port Data Input
 *  0b0..Pin logic level is logic 0, or is not configured for use by digital function.
 *  0b1..Pin logic level is logic 1.
 */
#define GPIO_PDIR_PDI16(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDIR_PDI16_SHIFT)) & GPIO_PDIR_PDI16_MASK)

#define GPIO_PDIR_PDI17_MASK                     (0x20000U)
#define GPIO_PDIR_PDI17_SHIFT                    (17U)
/*! PDI17 - Port Data Input
 *  0b0..Pin logic level is logic 0, or is not configured for use by digital function.
 *  0b1..Pin logic level is logic 1.
 */
#define GPIO_PDIR_PDI17(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDIR_PDI17_SHIFT)) & GPIO_PDIR_PDI17_MASK)

#define GPIO_PDIR_PDI18_MASK                     (0x40000U)
#define GPIO_PDIR_PDI18_SHIFT                    (18U)
/*! PDI18 - Port Data Input
 *  0b0..Pin logic level is logic 0, or is not configured for use by digital function.
 *  0b1..Pin logic level is logic 1.
 */
#define GPIO_PDIR_PDI18(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDIR_PDI18_SHIFT)) & GPIO_PDIR_PDI18_MASK)

#define GPIO_PDIR_PDI19_MASK                     (0x80000U)
#define GPIO_PDIR_PDI19_SHIFT                    (19U)
/*! PDI19 - Port Data Input
 *  0b0..Pin logic level is logic 0, or is not configured for use by digital function.
 *  0b1..Pin logic level is logic 1.
 */
#define GPIO_PDIR_PDI19(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDIR_PDI19_SHIFT)) & GPIO_PDIR_PDI19_MASK)

#define GPIO_PDIR_PDI20_MASK                     (0x100000U)
#define GPIO_PDIR_PDI20_SHIFT                    (20U)
/*! PDI20 - Port Data Input
 *  0b0..Pin logic level is logic 0, or is not configured for use by digital function.
 *  0b1..Pin logic level is logic 1.
 */
#define GPIO_PDIR_PDI20(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDIR_PDI20_SHIFT)) & GPIO_PDIR_PDI20_MASK)

#define GPIO_PDIR_PDI21_MASK                     (0x200000U)
#define GPIO_PDIR_PDI21_SHIFT                    (21U)
/*! PDI21 - Port Data Input
 *  0b0..Pin logic level is logic 0, or is not configured for use by digital function.
 *  0b1..Pin logic level is logic 1.
 */
#define GPIO_PDIR_PDI21(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDIR_PDI21_SHIFT)) & GPIO_PDIR_PDI21_MASK)

#define GPIO_PDIR_PDI22_MASK                     (0x400000U)
#define GPIO_PDIR_PDI22_SHIFT                    (22U)
/*! PDI22 - Port Data Input
 *  0b0..Pin logic level is logic 0, or is not configured for use by digital function.
 *  0b1..Pin logic level is logic 1.
 */
#define GPIO_PDIR_PDI22(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDIR_PDI22_SHIFT)) & GPIO_PDIR_PDI22_MASK)

#define GPIO_PDIR_PDI23_MASK                     (0x800000U)
#define GPIO_PDIR_PDI23_SHIFT                    (23U)
/*! PDI23 - Port Data Input
 *  0b0..Pin logic level is logic 0, or is not configured for use by digital function.
 *  0b1..Pin logic level is logic 1.
 */
#define GPIO_PDIR_PDI23(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDIR_PDI23_SHIFT)) & GPIO_PDIR_PDI23_MASK)

#define GPIO_PDIR_PDI24_MASK                     (0x1000000U)
#define GPIO_PDIR_PDI24_SHIFT                    (24U)
/*! PDI24 - Port Data Input
 *  0b0..Pin logic level is logic 0, or is not configured for use by digital function.
 *  0b1..Pin logic level is logic 1.
 */
#define GPIO_PDIR_PDI24(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDIR_PDI24_SHIFT)) & GPIO_PDIR_PDI24_MASK)

#define GPIO_PDIR_PDI25_MASK                     (0x2000000U)
#define GPIO_PDIR_PDI25_SHIFT                    (25U)
/*! PDI25 - Port Data Input
 *  0b0..Pin logic level is logic 0, or is not configured for use by digital function.
 *  0b1..Pin logic level is logic 1.
 */
#define GPIO_PDIR_PDI25(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDIR_PDI25_SHIFT)) & GPIO_PDIR_PDI25_MASK)

#define GPIO_PDIR_PDI26_MASK                     (0x4000000U)
#define GPIO_PDIR_PDI26_SHIFT                    (26U)
/*! PDI26 - Port Data Input
 *  0b0..Pin logic level is logic 0, or is not configured for use by digital function.
 *  0b1..Pin logic level is logic 1.
 */
#define GPIO_PDIR_PDI26(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDIR_PDI26_SHIFT)) & GPIO_PDIR_PDI26_MASK)

#define GPIO_PDIR_PDI27_MASK                     (0x8000000U)
#define GPIO_PDIR_PDI27_SHIFT                    (27U)
/*! PDI27 - Port Data Input
 *  0b0..Pin logic level is logic 0, or is not configured for use by digital function.
 *  0b1..Pin logic level is logic 1.
 */
#define GPIO_PDIR_PDI27(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDIR_PDI27_SHIFT)) & GPIO_PDIR_PDI27_MASK)

#define GPIO_PDIR_PDI28_MASK                     (0x10000000U)
#define GPIO_PDIR_PDI28_SHIFT                    (28U)
/*! PDI28 - Port Data Input
 *  0b0..Pin logic level is logic 0, or is not configured for use by digital function.
 *  0b1..Pin logic level is logic 1.
 */
#define GPIO_PDIR_PDI28(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDIR_PDI28_SHIFT)) & GPIO_PDIR_PDI28_MASK)

#define GPIO_PDIR_PDI29_MASK                     (0x20000000U)
#define GPIO_PDIR_PDI29_SHIFT                    (29U)
/*! PDI29 - Port Data Input
 *  0b0..Pin logic level is logic 0, or is not configured for use by digital function.
 *  0b1..Pin logic level is logic 1.
 */
#define GPIO_PDIR_PDI29(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDIR_PDI29_SHIFT)) & GPIO_PDIR_PDI29_MASK)

#define GPIO_PDIR_PDI30_MASK                     (0x40000000U)
#define GPIO_PDIR_PDI30_SHIFT                    (30U)
/*! PDI30 - Port Data Input
 *  0b0..Pin logic level is logic 0, or is not configured for use by digital function.
 *  0b1..Pin logic level is logic 1.
 */
#define GPIO_PDIR_PDI30(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDIR_PDI30_SHIFT)) & GPIO_PDIR_PDI30_MASK)

#define GPIO_PDIR_PDI31_MASK                     (0x80000000U)
#define GPIO_PDIR_PDI31_SHIFT                    (31U)
/*! PDI31 - Port Data Input
 *  0b0..Pin logic level is logic 0, or is not configured for use by digital function.
 *  0b1..Pin logic level is logic 1.
 */
#define GPIO_PDIR_PDI31(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDIR_PDI31_SHIFT)) & GPIO_PDIR_PDI31_MASK)
/*! @} */

/*! @name PDDR - Port Data Direction Register */
/*! @{ */

#define GPIO_PDDR_PDD0_MASK                      (0x1U)
#define GPIO_PDDR_PDD0_SHIFT                     (0U)
/*! PDD0 - Port Data Direction
 *  0b0..Pin is configured as general-purpose input for the GPIO function.
 *  0b1..Pin is configured as general-purpose output for the GPIO function.
 */
#define GPIO_PDDR_PDD0(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PDDR_PDD0_SHIFT)) & GPIO_PDDR_PDD0_MASK)

#define GPIO_PDDR_PDD1_MASK                      (0x2U)
#define GPIO_PDDR_PDD1_SHIFT                     (1U)
/*! PDD1 - Port Data Direction
 *  0b0..Pin is configured as general-purpose input for the GPIO function.
 *  0b1..Pin is configured as general-purpose output for the GPIO function.
 */
#define GPIO_PDDR_PDD1(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PDDR_PDD1_SHIFT)) & GPIO_PDDR_PDD1_MASK)

#define GPIO_PDDR_PDD2_MASK                      (0x4U)
#define GPIO_PDDR_PDD2_SHIFT                     (2U)
/*! PDD2 - Port Data Direction
 *  0b0..Pin is configured as general-purpose input for the GPIO function.
 *  0b1..Pin is configured as general-purpose output for the GPIO function.
 */
#define GPIO_PDDR_PDD2(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PDDR_PDD2_SHIFT)) & GPIO_PDDR_PDD2_MASK)

#define GPIO_PDDR_PDD3_MASK                      (0x8U)
#define GPIO_PDDR_PDD3_SHIFT                     (3U)
/*! PDD3 - Port Data Direction
 *  0b0..Pin is configured as general-purpose input for the GPIO function.
 *  0b1..Pin is configured as general-purpose output for the GPIO function.
 */
#define GPIO_PDDR_PDD3(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PDDR_PDD3_SHIFT)) & GPIO_PDDR_PDD3_MASK)

#define GPIO_PDDR_PDD4_MASK                      (0x10U)
#define GPIO_PDDR_PDD4_SHIFT                     (4U)
/*! PDD4 - Port Data Direction
 *  0b0..Pin is configured as general-purpose input for the GPIO function.
 *  0b1..Pin is configured as general-purpose output for the GPIO function.
 */
#define GPIO_PDDR_PDD4(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PDDR_PDD4_SHIFT)) & GPIO_PDDR_PDD4_MASK)

#define GPIO_PDDR_PDD5_MASK                      (0x20U)
#define GPIO_PDDR_PDD5_SHIFT                     (5U)
/*! PDD5 - Port Data Direction
 *  0b0..Pin is configured as general-purpose input for the GPIO function.
 *  0b1..Pin is configured as general-purpose output for the GPIO function.
 */
#define GPIO_PDDR_PDD5(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PDDR_PDD5_SHIFT)) & GPIO_PDDR_PDD5_MASK)

#define GPIO_PDDR_PDD6_MASK                      (0x40U)
#define GPIO_PDDR_PDD6_SHIFT                     (6U)
/*! PDD6 - Port Data Direction
 *  0b0..Pin is configured as general-purpose input for the GPIO function.
 *  0b1..Pin is configured as general-purpose output for the GPIO function.
 */
#define GPIO_PDDR_PDD6(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PDDR_PDD6_SHIFT)) & GPIO_PDDR_PDD6_MASK)

#define GPIO_PDDR_PDD7_MASK                      (0x80U)
#define GPIO_PDDR_PDD7_SHIFT                     (7U)
/*! PDD7 - Port Data Direction
 *  0b0..Pin is configured as general-purpose input for the GPIO function.
 *  0b1..Pin is configured as general-purpose output for the GPIO function.
 */
#define GPIO_PDDR_PDD7(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PDDR_PDD7_SHIFT)) & GPIO_PDDR_PDD7_MASK)

#define GPIO_PDDR_PDD8_MASK                      (0x100U)
#define GPIO_PDDR_PDD8_SHIFT                     (8U)
/*! PDD8 - Port Data Direction
 *  0b0..Pin is configured as general-purpose input for the GPIO function.
 *  0b1..Pin is configured as general-purpose output for the GPIO function.
 */
#define GPIO_PDDR_PDD8(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PDDR_PDD8_SHIFT)) & GPIO_PDDR_PDD8_MASK)

#define GPIO_PDDR_PDD9_MASK                      (0x200U)
#define GPIO_PDDR_PDD9_SHIFT                     (9U)
/*! PDD9 - Port Data Direction
 *  0b0..Pin is configured as general-purpose input for the GPIO function.
 *  0b1..Pin is configured as general-purpose output for the GPIO function.
 */
#define GPIO_PDDR_PDD9(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PDDR_PDD9_SHIFT)) & GPIO_PDDR_PDD9_MASK)

#define GPIO_PDDR_PDD10_MASK                     (0x400U)
#define GPIO_PDDR_PDD10_SHIFT                    (10U)
/*! PDD10 - Port Data Direction
 *  0b0..Pin is configured as general-purpose input for the GPIO function.
 *  0b1..Pin is configured as general-purpose output for the GPIO function.
 */
#define GPIO_PDDR_PDD10(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDDR_PDD10_SHIFT)) & GPIO_PDDR_PDD10_MASK)

#define GPIO_PDDR_PDD11_MASK                     (0x800U)
#define GPIO_PDDR_PDD11_SHIFT                    (11U)
/*! PDD11 - Port Data Direction
 *  0b0..Pin is configured as general-purpose input for the GPIO function.
 *  0b1..Pin is configured as general-purpose output for the GPIO function.
 */
#define GPIO_PDDR_PDD11(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDDR_PDD11_SHIFT)) & GPIO_PDDR_PDD11_MASK)

#define GPIO_PDDR_PDD12_MASK                     (0x1000U)
#define GPIO_PDDR_PDD12_SHIFT                    (12U)
/*! PDD12 - Port Data Direction
 *  0b0..Pin is configured as general-purpose input for the GPIO function.
 *  0b1..Pin is configured as general-purpose output for the GPIO function.
 */
#define GPIO_PDDR_PDD12(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDDR_PDD12_SHIFT)) & GPIO_PDDR_PDD12_MASK)

#define GPIO_PDDR_PDD13_MASK                     (0x2000U)
#define GPIO_PDDR_PDD13_SHIFT                    (13U)
/*! PDD13 - Port Data Direction
 *  0b0..Pin is configured as general-purpose input for the GPIO function.
 *  0b1..Pin is configured as general-purpose output for the GPIO function.
 */
#define GPIO_PDDR_PDD13(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDDR_PDD13_SHIFT)) & GPIO_PDDR_PDD13_MASK)

#define GPIO_PDDR_PDD14_MASK                     (0x4000U)
#define GPIO_PDDR_PDD14_SHIFT                    (14U)
/*! PDD14 - Port Data Direction
 *  0b0..Pin is configured as general-purpose input for the GPIO function.
 *  0b1..Pin is configured as general-purpose output for the GPIO function.
 */
#define GPIO_PDDR_PDD14(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDDR_PDD14_SHIFT)) & GPIO_PDDR_PDD14_MASK)

#define GPIO_PDDR_PDD15_MASK                     (0x8000U)
#define GPIO_PDDR_PDD15_SHIFT                    (15U)
/*! PDD15 - Port Data Direction
 *  0b0..Pin is configured as general-purpose input for the GPIO function.
 *  0b1..Pin is configured as general-purpose output for the GPIO function.
 */
#define GPIO_PDDR_PDD15(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDDR_PDD15_SHIFT)) & GPIO_PDDR_PDD15_MASK)

#define GPIO_PDDR_PDD16_MASK                     (0x10000U)
#define GPIO_PDDR_PDD16_SHIFT                    (16U)
/*! PDD16 - Port Data Direction
 *  0b0..Pin is configured as general-purpose input for the GPIO function.
 *  0b1..Pin is configured as general-purpose output for the GPIO function.
 */
#define GPIO_PDDR_PDD16(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDDR_PDD16_SHIFT)) & GPIO_PDDR_PDD16_MASK)

#define GPIO_PDDR_PDD17_MASK                     (0x20000U)
#define GPIO_PDDR_PDD17_SHIFT                    (17U)
/*! PDD17 - Port Data Direction
 *  0b0..Pin is configured as general-purpose input for the GPIO function.
 *  0b1..Pin is configured as general-purpose output for the GPIO function.
 */
#define GPIO_PDDR_PDD17(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDDR_PDD17_SHIFT)) & GPIO_PDDR_PDD17_MASK)

#define GPIO_PDDR_PDD18_MASK                     (0x40000U)
#define GPIO_PDDR_PDD18_SHIFT                    (18U)
/*! PDD18 - Port Data Direction
 *  0b0..Pin is configured as general-purpose input for the GPIO function.
 *  0b1..Pin is configured as general-purpose output for the GPIO function.
 */
#define GPIO_PDDR_PDD18(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDDR_PDD18_SHIFT)) & GPIO_PDDR_PDD18_MASK)

#define GPIO_PDDR_PDD19_MASK                     (0x80000U)
#define GPIO_PDDR_PDD19_SHIFT                    (19U)
/*! PDD19 - Port Data Direction
 *  0b0..Pin is configured as general-purpose input for the GPIO function.
 *  0b1..Pin is configured as general-purpose output for the GPIO function.
 */
#define GPIO_PDDR_PDD19(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDDR_PDD19_SHIFT)) & GPIO_PDDR_PDD19_MASK)

#define GPIO_PDDR_PDD20_MASK                     (0x100000U)
#define GPIO_PDDR_PDD20_SHIFT                    (20U)
/*! PDD20 - Port Data Direction
 *  0b0..Pin is configured as general-purpose input for the GPIO function.
 *  0b1..Pin is configured as general-purpose output for the GPIO function.
 */
#define GPIO_PDDR_PDD20(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDDR_PDD20_SHIFT)) & GPIO_PDDR_PDD20_MASK)

#define GPIO_PDDR_PDD21_MASK                     (0x200000U)
#define GPIO_PDDR_PDD21_SHIFT                    (21U)
/*! PDD21 - Port Data Direction
 *  0b0..Pin is configured as general-purpose input for the GPIO function.
 *  0b1..Pin is configured as general-purpose output for the GPIO function.
 */
#define GPIO_PDDR_PDD21(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDDR_PDD21_SHIFT)) & GPIO_PDDR_PDD21_MASK)

#define GPIO_PDDR_PDD22_MASK                     (0x400000U)
#define GPIO_PDDR_PDD22_SHIFT                    (22U)
/*! PDD22 - Port Data Direction
 *  0b0..Pin is configured as general-purpose input for the GPIO function.
 *  0b1..Pin is configured as general-purpose output for the GPIO function.
 */
#define GPIO_PDDR_PDD22(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDDR_PDD22_SHIFT)) & GPIO_PDDR_PDD22_MASK)

#define GPIO_PDDR_PDD23_MASK                     (0x800000U)
#define GPIO_PDDR_PDD23_SHIFT                    (23U)
/*! PDD23 - Port Data Direction
 *  0b0..Pin is configured as general-purpose input for the GPIO function.
 *  0b1..Pin is configured as general-purpose output for the GPIO function.
 */
#define GPIO_PDDR_PDD23(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDDR_PDD23_SHIFT)) & GPIO_PDDR_PDD23_MASK)

#define GPIO_PDDR_PDD24_MASK                     (0x1000000U)
#define GPIO_PDDR_PDD24_SHIFT                    (24U)
/*! PDD24 - Port Data Direction
 *  0b0..Pin is configured as general-purpose input for the GPIO function.
 *  0b1..Pin is configured as general-purpose output for the GPIO function.
 */
#define GPIO_PDDR_PDD24(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDDR_PDD24_SHIFT)) & GPIO_PDDR_PDD24_MASK)

#define GPIO_PDDR_PDD25_MASK                     (0x2000000U)
#define GPIO_PDDR_PDD25_SHIFT                    (25U)
/*! PDD25 - Port Data Direction
 *  0b0..Pin is configured as general-purpose input for the GPIO function.
 *  0b1..Pin is configured as general-purpose output for the GPIO function.
 */
#define GPIO_PDDR_PDD25(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDDR_PDD25_SHIFT)) & GPIO_PDDR_PDD25_MASK)

#define GPIO_PDDR_PDD26_MASK                     (0x4000000U)
#define GPIO_PDDR_PDD26_SHIFT                    (26U)
/*! PDD26 - Port Data Direction
 *  0b0..Pin is configured as general-purpose input for the GPIO function.
 *  0b1..Pin is configured as general-purpose output for the GPIO function.
 */
#define GPIO_PDDR_PDD26(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDDR_PDD26_SHIFT)) & GPIO_PDDR_PDD26_MASK)

#define GPIO_PDDR_PDD27_MASK                     (0x8000000U)
#define GPIO_PDDR_PDD27_SHIFT                    (27U)
/*! PDD27 - Port Data Direction
 *  0b0..Pin is configured as general-purpose input for the GPIO function.
 *  0b1..Pin is configured as general-purpose output for the GPIO function.
 */
#define GPIO_PDDR_PDD27(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDDR_PDD27_SHIFT)) & GPIO_PDDR_PDD27_MASK)

#define GPIO_PDDR_PDD28_MASK                     (0x10000000U)
#define GPIO_PDDR_PDD28_SHIFT                    (28U)
/*! PDD28 - Port Data Direction
 *  0b0..Pin is configured as general-purpose input for the GPIO function.
 *  0b1..Pin is configured as general-purpose output for the GPIO function.
 */
#define GPIO_PDDR_PDD28(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDDR_PDD28_SHIFT)) & GPIO_PDDR_PDD28_MASK)

#define GPIO_PDDR_PDD29_MASK                     (0x20000000U)
#define GPIO_PDDR_PDD29_SHIFT                    (29U)
/*! PDD29 - Port Data Direction
 *  0b0..Pin is configured as general-purpose input for the GPIO function.
 *  0b1..Pin is configured as general-purpose output for the GPIO function.
 */
#define GPIO_PDDR_PDD29(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDDR_PDD29_SHIFT)) & GPIO_PDDR_PDD29_MASK)

#define GPIO_PDDR_PDD30_MASK                     (0x40000000U)
#define GPIO_PDDR_PDD30_SHIFT                    (30U)
/*! PDD30 - Port Data Direction
 *  0b0..Pin is configured as general-purpose input for the GPIO function.
 *  0b1..Pin is configured as general-purpose output for the GPIO function.
 */
#define GPIO_PDDR_PDD30(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDDR_PDD30_SHIFT)) & GPIO_PDDR_PDD30_MASK)

#define GPIO_PDDR_PDD31_MASK                     (0x80000000U)
#define GPIO_PDDR_PDD31_SHIFT                    (31U)
/*! PDD31 - Port Data Direction
 *  0b0..Pin is configured as general-purpose input for the GPIO function.
 *  0b1..Pin is configured as general-purpose output for the GPIO function.
 */
#define GPIO_PDDR_PDD31(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PDDR_PDD31_SHIFT)) & GPIO_PDDR_PDD31_MASK)
/*! @} */

/*! @name PIDR - Port Input Disable Register */
/*! @{ */

#define GPIO_PIDR_PID0_MASK                      (0x1U)
#define GPIO_PIDR_PID0_SHIFT                     (0U)
/*! PID0 - Port Input Disable
 *  0b0..Pin is configured for general-purpose input provided, the pin is configured for any digital function.
 *  0b1..Pin is disabled for general-purpose input.
 */
#define GPIO_PIDR_PID0(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PIDR_PID0_SHIFT)) & GPIO_PIDR_PID0_MASK)

#define GPIO_PIDR_PID1_MASK                      (0x2U)
#define GPIO_PIDR_PID1_SHIFT                     (1U)
/*! PID1 - Port Input Disable
 *  0b0..Pin is configured for general-purpose input provided, the pin is configured for any digital function.
 *  0b1..Pin is disabled for general-purpose input.
 */
#define GPIO_PIDR_PID1(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PIDR_PID1_SHIFT)) & GPIO_PIDR_PID1_MASK)

#define GPIO_PIDR_PID2_MASK                      (0x4U)
#define GPIO_PIDR_PID2_SHIFT                     (2U)
/*! PID2 - Port Input Disable
 *  0b0..Pin is configured for general-purpose input provided, the pin is configured for any digital function.
 *  0b1..Pin is disabled for general-purpose input.
 */
#define GPIO_PIDR_PID2(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PIDR_PID2_SHIFT)) & GPIO_PIDR_PID2_MASK)

#define GPIO_PIDR_PID3_MASK                      (0x8U)
#define GPIO_PIDR_PID3_SHIFT                     (3U)
/*! PID3 - Port Input Disable
 *  0b0..Pin is configured for general-purpose input provided, the pin is configured for any digital function.
 *  0b1..Pin is disabled for general-purpose input.
 */
#define GPIO_PIDR_PID3(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PIDR_PID3_SHIFT)) & GPIO_PIDR_PID3_MASK)

#define GPIO_PIDR_PID4_MASK                      (0x10U)
#define GPIO_PIDR_PID4_SHIFT                     (4U)
/*! PID4 - Port Input Disable
 *  0b0..Pin is configured for general-purpose input provided, the pin is configured for any digital function.
 *  0b1..Pin is disabled for general-purpose input.
 */
#define GPIO_PIDR_PID4(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PIDR_PID4_SHIFT)) & GPIO_PIDR_PID4_MASK)

#define GPIO_PIDR_PID5_MASK                      (0x20U)
#define GPIO_PIDR_PID5_SHIFT                     (5U)
/*! PID5 - Port Input Disable
 *  0b0..Pin is configured for general-purpose input provided, the pin is configured for any digital function.
 *  0b1..Pin is disabled for general-purpose input.
 */
#define GPIO_PIDR_PID5(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PIDR_PID5_SHIFT)) & GPIO_PIDR_PID5_MASK)

#define GPIO_PIDR_PID6_MASK                      (0x40U)
#define GPIO_PIDR_PID6_SHIFT                     (6U)
/*! PID6 - Port Input Disable
 *  0b0..Pin is configured for general-purpose input provided, the pin is configured for any digital function.
 *  0b1..Pin is disabled for general-purpose input.
 */
#define GPIO_PIDR_PID6(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PIDR_PID6_SHIFT)) & GPIO_PIDR_PID6_MASK)

#define GPIO_PIDR_PID7_MASK                      (0x80U)
#define GPIO_PIDR_PID7_SHIFT                     (7U)
/*! PID7 - Port Input Disable
 *  0b0..Pin is configured for general-purpose input provided, the pin is configured for any digital function.
 *  0b1..Pin is disabled for general-purpose input.
 */
#define GPIO_PIDR_PID7(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PIDR_PID7_SHIFT)) & GPIO_PIDR_PID7_MASK)

#define GPIO_PIDR_PID8_MASK                      (0x100U)
#define GPIO_PIDR_PID8_SHIFT                     (8U)
/*! PID8 - Port Input Disable
 *  0b0..Pin is configured for general-purpose input provided, the pin is configured for any digital function.
 *  0b1..Pin is disabled for general-purpose input.
 */
#define GPIO_PIDR_PID8(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PIDR_PID8_SHIFT)) & GPIO_PIDR_PID8_MASK)

#define GPIO_PIDR_PID9_MASK                      (0x200U)
#define GPIO_PIDR_PID9_SHIFT                     (9U)
/*! PID9 - Port Input Disable
 *  0b0..Pin is configured for general-purpose input provided, the pin is configured for any digital function.
 *  0b1..Pin is disabled for general-purpose input.
 */
#define GPIO_PIDR_PID9(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PIDR_PID9_SHIFT)) & GPIO_PIDR_PID9_MASK)

#define GPIO_PIDR_PID10_MASK                     (0x400U)
#define GPIO_PIDR_PID10_SHIFT                    (10U)
/*! PID10 - Port Input Disable
 *  0b0..Pin is configured for general-purpose input provided, the pin is configured for any digital function.
 *  0b1..Pin is disabled for general-purpose input.
 */
#define GPIO_PIDR_PID10(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PIDR_PID10_SHIFT)) & GPIO_PIDR_PID10_MASK)

#define GPIO_PIDR_PID11_MASK                     (0x800U)
#define GPIO_PIDR_PID11_SHIFT                    (11U)
/*! PID11 - Port Input Disable
 *  0b0..Pin is configured for general-purpose input provided, the pin is configured for any digital function.
 *  0b1..Pin is disabled for general-purpose input.
 */
#define GPIO_PIDR_PID11(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PIDR_PID11_SHIFT)) & GPIO_PIDR_PID11_MASK)

#define GPIO_PIDR_PID12_MASK                     (0x1000U)
#define GPIO_PIDR_PID12_SHIFT                    (12U)
/*! PID12 - Port Input Disable
 *  0b0..Pin is configured for general-purpose input provided, the pin is configured for any digital function.
 *  0b1..Pin is disabled for general-purpose input.
 */
#define GPIO_PIDR_PID12(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PIDR_PID12_SHIFT)) & GPIO_PIDR_PID12_MASK)

#define GPIO_PIDR_PID13_MASK                     (0x2000U)
#define GPIO_PIDR_PID13_SHIFT                    (13U)
/*! PID13 - Port Input Disable
 *  0b0..Pin is configured for general-purpose input provided, the pin is configured for any digital function.
 *  0b1..Pin is disabled for general-purpose input.
 */
#define GPIO_PIDR_PID13(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PIDR_PID13_SHIFT)) & GPIO_PIDR_PID13_MASK)

#define GPIO_PIDR_PID14_MASK                     (0x4000U)
#define GPIO_PIDR_PID14_SHIFT                    (14U)
/*! PID14 - Port Input Disable
 *  0b0..Pin is configured for general-purpose input provided, the pin is configured for any digital function.
 *  0b1..Pin is disabled for general-purpose input.
 */
#define GPIO_PIDR_PID14(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PIDR_PID14_SHIFT)) & GPIO_PIDR_PID14_MASK)

#define GPIO_PIDR_PID15_MASK                     (0x8000U)
#define GPIO_PIDR_PID15_SHIFT                    (15U)
/*! PID15 - Port Input Disable
 *  0b0..Pin is configured for general-purpose input provided, the pin is configured for any digital function.
 *  0b1..Pin is disabled for general-purpose input.
 */
#define GPIO_PIDR_PID15(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PIDR_PID15_SHIFT)) & GPIO_PIDR_PID15_MASK)

#define GPIO_PIDR_PID16_MASK                     (0x10000U)
#define GPIO_PIDR_PID16_SHIFT                    (16U)
/*! PID16 - Port Input Disable
 *  0b0..Pin is configured for general-purpose input provided, the pin is configured for any digital function.
 *  0b1..Pin is disabled for general-purpose input.
 */
#define GPIO_PIDR_PID16(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PIDR_PID16_SHIFT)) & GPIO_PIDR_PID16_MASK)

#define GPIO_PIDR_PID17_MASK                     (0x20000U)
#define GPIO_PIDR_PID17_SHIFT                    (17U)
/*! PID17 - Port Input Disable
 *  0b0..Pin is configured for general-purpose input provided, the pin is configured for any digital function.
 *  0b1..Pin is disabled for general-purpose input.
 */
#define GPIO_PIDR_PID17(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PIDR_PID17_SHIFT)) & GPIO_PIDR_PID17_MASK)

#define GPIO_PIDR_PID18_MASK                     (0x40000U)
#define GPIO_PIDR_PID18_SHIFT                    (18U)
/*! PID18 - Port Input Disable
 *  0b0..Pin is configured for general-purpose input provided, the pin is configured for any digital function.
 *  0b1..Pin is disabled for general-purpose input.
 */
#define GPIO_PIDR_PID18(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PIDR_PID18_SHIFT)) & GPIO_PIDR_PID18_MASK)

#define GPIO_PIDR_PID19_MASK                     (0x80000U)
#define GPIO_PIDR_PID19_SHIFT                    (19U)
/*! PID19 - Port Input Disable
 *  0b0..Pin is configured for general-purpose input provided, the pin is configured for any digital function.
 *  0b1..Pin is disabled for general-purpose input.
 */
#define GPIO_PIDR_PID19(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PIDR_PID19_SHIFT)) & GPIO_PIDR_PID19_MASK)

#define GPIO_PIDR_PID20_MASK                     (0x100000U)
#define GPIO_PIDR_PID20_SHIFT                    (20U)
/*! PID20 - Port Input Disable
 *  0b0..Pin is configured for general-purpose input provided, the pin is configured for any digital function.
 *  0b1..Pin is disabled for general-purpose input.
 */
#define GPIO_PIDR_PID20(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PIDR_PID20_SHIFT)) & GPIO_PIDR_PID20_MASK)

#define GPIO_PIDR_PID21_MASK                     (0x200000U)
#define GPIO_PIDR_PID21_SHIFT                    (21U)
/*! PID21 - Port Input Disable
 *  0b0..Pin is configured for general-purpose input provided, the pin is configured for any digital function.
 *  0b1..Pin is disabled for general-purpose input.
 */
#define GPIO_PIDR_PID21(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PIDR_PID21_SHIFT)) & GPIO_PIDR_PID21_MASK)

#define GPIO_PIDR_PID22_MASK                     (0x400000U)
#define GPIO_PIDR_PID22_SHIFT                    (22U)
/*! PID22 - Port Input Disable
 *  0b0..Pin is configured for general-purpose input provided, the pin is configured for any digital function.
 *  0b1..Pin is disabled for general-purpose input.
 */
#define GPIO_PIDR_PID22(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PIDR_PID22_SHIFT)) & GPIO_PIDR_PID22_MASK)

#define GPIO_PIDR_PID23_MASK                     (0x800000U)
#define GPIO_PIDR_PID23_SHIFT                    (23U)
/*! PID23 - Port Input Disable
 *  0b0..Pin is configured for general-purpose input provided, the pin is configured for any digital function.
 *  0b1..Pin is disabled for general-purpose input.
 */
#define GPIO_PIDR_PID23(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PIDR_PID23_SHIFT)) & GPIO_PIDR_PID23_MASK)

#define GPIO_PIDR_PID24_MASK                     (0x1000000U)
#define GPIO_PIDR_PID24_SHIFT                    (24U)
/*! PID24 - Port Input Disable
 *  0b0..Pin is configured for general-purpose input provided, the pin is configured for any digital function.
 *  0b1..Pin is disabled for general-purpose input.
 */
#define GPIO_PIDR_PID24(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PIDR_PID24_SHIFT)) & GPIO_PIDR_PID24_MASK)

#define GPIO_PIDR_PID25_MASK                     (0x2000000U)
#define GPIO_PIDR_PID25_SHIFT                    (25U)
/*! PID25 - Port Input Disable
 *  0b0..Pin is configured for general-purpose input provided, the pin is configured for any digital function.
 *  0b1..Pin is disabled for general-purpose input.
 */
#define GPIO_PIDR_PID25(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PIDR_PID25_SHIFT)) & GPIO_PIDR_PID25_MASK)

#define GPIO_PIDR_PID26_MASK                     (0x4000000U)
#define GPIO_PIDR_PID26_SHIFT                    (26U)
/*! PID26 - Port Input Disable
 *  0b0..Pin is configured for general-purpose input provided, the pin is configured for any digital function.
 *  0b1..Pin is disabled for general-purpose input.
 */
#define GPIO_PIDR_PID26(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PIDR_PID26_SHIFT)) & GPIO_PIDR_PID26_MASK)

#define GPIO_PIDR_PID27_MASK                     (0x8000000U)
#define GPIO_PIDR_PID27_SHIFT                    (27U)
/*! PID27 - Port Input Disable
 *  0b0..Pin is configured for general-purpose input provided, the pin is configured for any digital function.
 *  0b1..Pin is disabled for general-purpose input.
 */
#define GPIO_PIDR_PID27(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PIDR_PID27_SHIFT)) & GPIO_PIDR_PID27_MASK)

#define GPIO_PIDR_PID28_MASK                     (0x10000000U)
#define GPIO_PIDR_PID28_SHIFT                    (28U)
/*! PID28 - Port Input Disable
 *  0b0..Pin is configured for general-purpose input provided, the pin is configured for any digital function.
 *  0b1..Pin is disabled for general-purpose input.
 */
#define GPIO_PIDR_PID28(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PIDR_PID28_SHIFT)) & GPIO_PIDR_PID28_MASK)

#define GPIO_PIDR_PID29_MASK                     (0x20000000U)
#define GPIO_PIDR_PID29_SHIFT                    (29U)
/*! PID29 - Port Input Disable
 *  0b0..Pin is configured for general-purpose input provided, the pin is configured for any digital function.
 *  0b1..Pin is disabled for general-purpose input.
 */
#define GPIO_PIDR_PID29(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PIDR_PID29_SHIFT)) & GPIO_PIDR_PID29_MASK)

#define GPIO_PIDR_PID30_MASK                     (0x40000000U)
#define GPIO_PIDR_PID30_SHIFT                    (30U)
/*! PID30 - Port Input Disable
 *  0b0..Pin is configured for general-purpose input provided, the pin is configured for any digital function.
 *  0b1..Pin is disabled for general-purpose input.
 */
#define GPIO_PIDR_PID30(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PIDR_PID30_SHIFT)) & GPIO_PIDR_PID30_MASK)

#define GPIO_PIDR_PID31_MASK                     (0x80000000U)
#define GPIO_PIDR_PID31_SHIFT                    (31U)
/*! PID31 - Port Input Disable
 *  0b0..Pin is configured for general-purpose input provided, the pin is configured for any digital function.
 *  0b1..Pin is disabled for general-purpose input.
 */
#define GPIO_PIDR_PID31(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PIDR_PID31_SHIFT)) & GPIO_PIDR_PID31_MASK)
/*! @} */

/*! @name PDR - Pin Data Register a */
/*! @{ */

#define GPIO_PDR_PD_MASK                         (0x1U)
#define GPIO_PDR_PD_SHIFT                        (0U)
/*! PD - Pin Data (input and output)
 *  0b0..Pin logic level is logic zero or not configured for use by digital function.
 *  0b1..Pin logic level is logic one.
 */
#define GPIO_PDR_PD(x)                           (((uint8_t)(((uint8_t)(x)) << GPIO_PDR_PD_SHIFT)) & GPIO_PDR_PD_MASK)
/*! @} */

/* The count of GPIO_PDR */
#define GPIO_PDR_COUNT                           (32U)

/*! @name ICR - Interrupt Control Register 0..Interrupt Control Register 31 */
/*! @{ */

#define GPIO_ICR_IRQC_MASK                       (0xF0000U)
#define GPIO_ICR_IRQC_SHIFT                      (16U)
/*! IRQC - Interrupt Configuration
 *  0b0000..Interrupt Status Flag (ISF) is disabled.
 *  0b0001..ISF flag and DMA request on rising edge.
 *  0b0010..ISF flag and DMA request on falling edge.
 *  0b0011..ISF flag and DMA request on either edge.
 *  0b0100..Reserved.
 *  0b0101..ISF flag sets on rising edge.
 *  0b0110..ISF flag sets on falling edge.
 *  0b0111..ISF flag sets on either edge.
 *  0b1000..ISF flag and Interrupt when logic 0.
 *  0b1001..ISF flag and Interrupt on rising-edge.
 *  0b1010..ISF flag and Interrupt on falling-edge.
 *  0b1011..ISF flag and Interrupt on either edge.
 *  0b1100..ISF flag and Interrupt when logic 1.
 *  0b1101..Enable active high trigger output, ISF flag on rising edge. Pin state is ORed with other enabled
 *          triggers to generate the output trigger, for use by other peripherals.
 *  0b1110..Enable active low trigger output, ISF flag on falling edge. Pin state is inverted and ORed with other
 *          enabled triggers to generate the output trigger, for use by other peripherals.
 *  0b1111..Reserved.
 */
#define GPIO_ICR_IRQC(x)                         (((uint32_t)(((uint32_t)(x)) << GPIO_ICR_IRQC_SHIFT)) & GPIO_ICR_IRQC_MASK)

#define GPIO_ICR_IRQS_MASK                       (0x100000U)
#define GPIO_ICR_IRQS_SHIFT                      (20U)
/*! IRQS - Interrupt Select
 *  0b0..Interrupt/DMA request/trigger output 0.
 *  0b1..Interrupt/DMA request/trigger output 1.
 */
#define GPIO_ICR_IRQS(x)                         (((uint32_t)(((uint32_t)(x)) << GPIO_ICR_IRQS_SHIFT)) & GPIO_ICR_IRQS_MASK)

#define GPIO_ICR_LK_MASK                         (0x800000U)
#define GPIO_ICR_LK_SHIFT                        (23U)
/*! LK - Lock Register
 *  0b0..Interrupt configuration by ICR[23:0] is not locked and can be updated.
 *  0b1..Interrupt configuration by ICR[23:0] is locked and cannot be updated until next system reset.
 */
#define GPIO_ICR_LK(x)                           (((uint32_t)(((uint32_t)(x)) << GPIO_ICR_LK_SHIFT)) & GPIO_ICR_LK_MASK)

#define GPIO_ICR_ISF_MASK                        (0x1000000U)
#define GPIO_ICR_ISF_SHIFT                       (24U)
/*! ISF - Interrupt Status Flag
 *  0b0..Configured interrupt is not detected.
 *  0b1..Configured interrupt is detected. If the pin is configured to generate a DMA request, then the
 *       corresponding flag will be cleared automatically at the completion of the requested DMA transfer. Otherwise, the
 *       flag remains set until a logic 1 is written to the flag. If the pin is configured for a level sensitive
 *       interrupt and the pin remains asserted, then the flag is set again immediately after it is cleared.
 */
#define GPIO_ICR_ISF(x)                          (((uint32_t)(((uint32_t)(x)) << GPIO_ICR_ISF_SHIFT)) & GPIO_ICR_ISF_MASK)
/*! @} */

/* The count of GPIO_ICR */
#define GPIO_ICR_COUNT                           (32U)

/*! @name GICLR - Global Interrupt Control Low Register */
/*! @{ */

#define GPIO_GICLR_GIWE0_MASK                    (0x1U)
#define GPIO_GICLR_GIWE0_SHIFT                   (0U)
/*! GIWE0 - Global Interrupt Write Enable
 *  0b0..Upper 16-bit of corresponding Interrupt Control Register is not updated with the value in GIWD.
 *  0b1..Upper 16-bit of corresponding Interrupt Control Register is updated with the value in GIWD.
 */
#define GPIO_GICLR_GIWE0(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_GICLR_GIWE0_SHIFT)) & GPIO_GICLR_GIWE0_MASK)

#define GPIO_GICLR_GIWE1_MASK                    (0x2U)
#define GPIO_GICLR_GIWE1_SHIFT                   (1U)
/*! GIWE1 - Global Interrupt Write Enable
 *  0b0..Upper 16-bit of corresponding Interrupt Control Register is not updated with the value in GIWD.
 *  0b1..Upper 16-bit of corresponding Interrupt Control Register is updated with the value in GIWD.
 */
#define GPIO_GICLR_GIWE1(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_GICLR_GIWE1_SHIFT)) & GPIO_GICLR_GIWE1_MASK)

#define GPIO_GICLR_GIWE2_MASK                    (0x4U)
#define GPIO_GICLR_GIWE2_SHIFT                   (2U)
/*! GIWE2 - Global Interrupt Write Enable
 *  0b0..Upper 16-bit of corresponding Interrupt Control Register is not updated with the value in GIWD.
 *  0b1..Upper 16-bit of corresponding Interrupt Control Register is updated with the value in GIWD.
 */
#define GPIO_GICLR_GIWE2(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_GICLR_GIWE2_SHIFT)) & GPIO_GICLR_GIWE2_MASK)

#define GPIO_GICLR_GIWE3_MASK                    (0x8U)
#define GPIO_GICLR_GIWE3_SHIFT                   (3U)
/*! GIWE3 - Global Interrupt Write Enable
 *  0b0..Upper 16-bit of corresponding Interrupt Control Register is not updated with the value in GIWD.
 *  0b1..Upper 16-bit of corresponding Interrupt Control Register is updated with the value in GIWD.
 */
#define GPIO_GICLR_GIWE3(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_GICLR_GIWE3_SHIFT)) & GPIO_GICLR_GIWE3_MASK)

#define GPIO_GICLR_GIWE4_MASK                    (0x10U)
#define GPIO_GICLR_GIWE4_SHIFT                   (4U)
/*! GIWE4 - Global Interrupt Write Enable
 *  0b0..Upper 16-bit of corresponding Interrupt Control Register is not updated with the value in GIWD.
 *  0b1..Upper 16-bit of corresponding Interrupt Control Register is updated with the value in GIWD.
 */
#define GPIO_GICLR_GIWE4(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_GICLR_GIWE4_SHIFT)) & GPIO_GICLR_GIWE4_MASK)

#define GPIO_GICLR_GIWE5_MASK                    (0x20U)
#define GPIO_GICLR_GIWE5_SHIFT                   (5U)
/*! GIWE5 - Global Interrupt Write Enable
 *  0b0..Upper 16-bit of corresponding Interrupt Control Register is not updated with the value in GIWD.
 *  0b1..Upper 16-bit of corresponding Interrupt Control Register is updated with the value in GIWD.
 */
#define GPIO_GICLR_GIWE5(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_GICLR_GIWE5_SHIFT)) & GPIO_GICLR_GIWE5_MASK)

#define GPIO_GICLR_GIWE6_MASK                    (0x40U)
#define GPIO_GICLR_GIWE6_SHIFT                   (6U)
/*! GIWE6 - Global Interrupt Write Enable
 *  0b0..Upper 16-bit of corresponding Interrupt Control Register is not updated with the value in GIWD.
 *  0b1..Upper 16-bit of corresponding Interrupt Control Register is updated with the value in GIWD.
 */
#define GPIO_GICLR_GIWE6(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_GICLR_GIWE6_SHIFT)) & GPIO_GICLR_GIWE6_MASK)

#define GPIO_GICLR_GIWE7_MASK                    (0x80U)
#define GPIO_GICLR_GIWE7_SHIFT                   (7U)
/*! GIWE7 - Global Interrupt Write Enable
 *  0b0..Upper 16-bit of corresponding Interrupt Control Register is not updated with the value in GIWD.
 *  0b1..Upper 16-bit of corresponding Interrupt Control Register is updated with the value in GIWD.
 */
#define GPIO_GICLR_GIWE7(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_GICLR_GIWE7_SHIFT)) & GPIO_GICLR_GIWE7_MASK)

#define GPIO_GICLR_GIWE8_MASK                    (0x100U)
#define GPIO_GICLR_GIWE8_SHIFT                   (8U)
/*! GIWE8 - Global Interrupt Write Enable
 *  0b0..Upper 16-bit of corresponding Interrupt Control Register is not updated with the value in GIWD.
 *  0b1..Upper 16-bit of corresponding Interrupt Control Register is updated with the value in GIWD.
 */
#define GPIO_GICLR_GIWE8(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_GICLR_GIWE8_SHIFT)) & GPIO_GICLR_GIWE8_MASK)

#define GPIO_GICLR_GIWE9_MASK                    (0x200U)
#define GPIO_GICLR_GIWE9_SHIFT                   (9U)
/*! GIWE9 - Global Interrupt Write Enable
 *  0b0..Upper 16-bit of corresponding Interrupt Control Register is not updated with the value in GIWD.
 *  0b1..Upper 16-bit of corresponding Interrupt Control Register is updated with the value in GIWD.
 */
#define GPIO_GICLR_GIWE9(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_GICLR_GIWE9_SHIFT)) & GPIO_GICLR_GIWE9_MASK)

#define GPIO_GICLR_GIWE10_MASK                   (0x400U)
#define GPIO_GICLR_GIWE10_SHIFT                  (10U)
/*! GIWE10 - Global Interrupt Write Enable
 *  0b0..Upper 16-bit of corresponding Interrupt Control Register is not updated with the value in GIWD.
 *  0b1..Upper 16-bit of corresponding Interrupt Control Register is updated with the value in GIWD.
 */
#define GPIO_GICLR_GIWE10(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_GICLR_GIWE10_SHIFT)) & GPIO_GICLR_GIWE10_MASK)

#define GPIO_GICLR_GIWE11_MASK                   (0x800U)
#define GPIO_GICLR_GIWE11_SHIFT                  (11U)
/*! GIWE11 - Global Interrupt Write Enable
 *  0b0..Upper 16-bit of corresponding Interrupt Control Register is not updated with the value in GIWD.
 *  0b1..Upper 16-bit of corresponding Interrupt Control Register is updated with the value in GIWD.
 */
#define GPIO_GICLR_GIWE11(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_GICLR_GIWE11_SHIFT)) & GPIO_GICLR_GIWE11_MASK)

#define GPIO_GICLR_GIWE12_MASK                   (0x1000U)
#define GPIO_GICLR_GIWE12_SHIFT                  (12U)
/*! GIWE12 - Global Interrupt Write Enable
 *  0b0..Upper 16-bit of corresponding Interrupt Control Register is not updated with the value in GIWD.
 *  0b1..Upper 16-bit of corresponding Interrupt Control Register is updated with the value in GIWD.
 */
#define GPIO_GICLR_GIWE12(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_GICLR_GIWE12_SHIFT)) & GPIO_GICLR_GIWE12_MASK)

#define GPIO_GICLR_GIWE13_MASK                   (0x2000U)
#define GPIO_GICLR_GIWE13_SHIFT                  (13U)
/*! GIWE13 - Global Interrupt Write Enable
 *  0b0..Upper 16-bit of corresponding Interrupt Control Register is not updated with the value in GIWD.
 *  0b1..Upper 16-bit of corresponding Interrupt Control Register is updated with the value in GIWD.
 */
#define GPIO_GICLR_GIWE13(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_GICLR_GIWE13_SHIFT)) & GPIO_GICLR_GIWE13_MASK)

#define GPIO_GICLR_GIWE14_MASK                   (0x4000U)
#define GPIO_GICLR_GIWE14_SHIFT                  (14U)
/*! GIWE14 - Global Interrupt Write Enable
 *  0b0..Upper 16-bit of corresponding Interrupt Control Register is not updated with the value in GIWD.
 *  0b1..Upper 16-bit of corresponding Interrupt Control Register is updated with the value in GIWD.
 */
#define GPIO_GICLR_GIWE14(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_GICLR_GIWE14_SHIFT)) & GPIO_GICLR_GIWE14_MASK)

#define GPIO_GICLR_GIWE15_MASK                   (0x8000U)
#define GPIO_GICLR_GIWE15_SHIFT                  (15U)
/*! GIWE15 - Global Interrupt Write Enable
 *  0b0..Upper 16-bit of corresponding Interrupt Control Register is not updated with the value in GIWD.
 *  0b1..Upper 16-bit of corresponding Interrupt Control Register is updated with the value in GIWD.
 */
#define GPIO_GICLR_GIWE15(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_GICLR_GIWE15_SHIFT)) & GPIO_GICLR_GIWE15_MASK)

#define GPIO_GICLR_GIWD_MASK                     (0xFFFF0000U)
#define GPIO_GICLR_GIWD_SHIFT                    (16U)
/*! GIWD - Global Interrupt Write Data
 */
#define GPIO_GICLR_GIWD(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_GICLR_GIWD_SHIFT)) & GPIO_GICLR_GIWD_MASK)
/*! @} */

/*! @name GICHR - Global Interrupt Control High Register */
/*! @{ */

#define GPIO_GICHR_GIWE16_MASK                   (0x1U)
#define GPIO_GICHR_GIWE16_SHIFT                  (0U)
/*! GIWE16 - Global Interrupt Write Enable
 *  0b0..Upper 16-bit of corresponding Interrupt Control Register is not updated with the value in GIWD.
 *  0b1..Upper 16-bit of corresponding Interrupt Control Register is updated with the value in GIWD.
 */
#define GPIO_GICHR_GIWE16(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_GICHR_GIWE16_SHIFT)) & GPIO_GICHR_GIWE16_MASK)

#define GPIO_GICHR_GIWE17_MASK                   (0x2U)
#define GPIO_GICHR_GIWE17_SHIFT                  (1U)
/*! GIWE17 - Global Interrupt Write Enable
 *  0b0..Upper 16-bit of corresponding Interrupt Control Register is not updated with the value in GIWD.
 *  0b1..Upper 16-bit of corresponding Interrupt Control Register is updated with the value in GIWD.
 */
#define GPIO_GICHR_GIWE17(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_GICHR_GIWE17_SHIFT)) & GPIO_GICHR_GIWE17_MASK)

#define GPIO_GICHR_GIWE18_MASK                   (0x4U)
#define GPIO_GICHR_GIWE18_SHIFT                  (2U)
/*! GIWE18 - Global Interrupt Write Enable
 *  0b0..Upper 16-bit of corresponding Interrupt Control Register is not updated with the value in GIWD.
 *  0b1..Upper 16-bit of corresponding Interrupt Control Register is updated with the value in GIWD.
 */
#define GPIO_GICHR_GIWE18(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_GICHR_GIWE18_SHIFT)) & GPIO_GICHR_GIWE18_MASK)

#define GPIO_GICHR_GIWE19_MASK                   (0x8U)
#define GPIO_GICHR_GIWE19_SHIFT                  (3U)
/*! GIWE19 - Global Interrupt Write Enable
 *  0b0..Upper 16-bit of corresponding Interrupt Control Register is not updated with the value in GIWD.
 *  0b1..Upper 16-bit of corresponding Interrupt Control Register is updated with the value in GIWD.
 */
#define GPIO_GICHR_GIWE19(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_GICHR_GIWE19_SHIFT)) & GPIO_GICHR_GIWE19_MASK)

#define GPIO_GICHR_GIWE20_MASK                   (0x10U)
#define GPIO_GICHR_GIWE20_SHIFT                  (4U)
/*! GIWE20 - Global Interrupt Write Enable
 *  0b0..Upper 16-bit of corresponding Interrupt Control Register is not updated with the value in GIWD.
 *  0b1..Upper 16-bit of corresponding Interrupt Control Register is updated with the value in GIWD.
 */
#define GPIO_GICHR_GIWE20(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_GICHR_GIWE20_SHIFT)) & GPIO_GICHR_GIWE20_MASK)

#define GPIO_GICHR_GIWE21_MASK                   (0x20U)
#define GPIO_GICHR_GIWE21_SHIFT                  (5U)
/*! GIWE21 - Global Interrupt Write Enable
 *  0b0..Upper 16-bit of corresponding Interrupt Control Register is not updated with the value in GIWD.
 *  0b1..Upper 16-bit of corresponding Interrupt Control Register is updated with the value in GIWD.
 */
#define GPIO_GICHR_GIWE21(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_GICHR_GIWE21_SHIFT)) & GPIO_GICHR_GIWE21_MASK)

#define GPIO_GICHR_GIWE22_MASK                   (0x40U)
#define GPIO_GICHR_GIWE22_SHIFT                  (6U)
/*! GIWE22 - Global Interrupt Write Enable
 *  0b0..Upper 16-bit of corresponding Interrupt Control Register is not updated with the value in GIWD.
 *  0b1..Upper 16-bit of corresponding Interrupt Control Register is updated with the value in GIWD.
 */
#define GPIO_GICHR_GIWE22(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_GICHR_GIWE22_SHIFT)) & GPIO_GICHR_GIWE22_MASK)

#define GPIO_GICHR_GIWE23_MASK                   (0x80U)
#define GPIO_GICHR_GIWE23_SHIFT                  (7U)
/*! GIWE23 - Global Interrupt Write Enable
 *  0b0..Upper 16-bit of corresponding Interrupt Control Register is not updated with the value in GIWD.
 *  0b1..Upper 16-bit of corresponding Interrupt Control Register is updated with the value in GIWD.
 */
#define GPIO_GICHR_GIWE23(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_GICHR_GIWE23_SHIFT)) & GPIO_GICHR_GIWE23_MASK)

#define GPIO_GICHR_GIWE24_MASK                   (0x100U)
#define GPIO_GICHR_GIWE24_SHIFT                  (8U)
/*! GIWE24 - Global Interrupt Write Enable
 *  0b0..Upper 16-bit of corresponding Interrupt Control Register is not updated with the value in GIWD.
 *  0b1..Upper 16-bit of corresponding Interrupt Control Register is updated with the value in GIWD.
 */
#define GPIO_GICHR_GIWE24(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_GICHR_GIWE24_SHIFT)) & GPIO_GICHR_GIWE24_MASK)

#define GPIO_GICHR_GIWE25_MASK                   (0x200U)
#define GPIO_GICHR_GIWE25_SHIFT                  (9U)
/*! GIWE25 - Global Interrupt Write Enable
 *  0b0..Upper 16-bit of corresponding Interrupt Control Register is not updated with the value in GIWD.
 *  0b1..Upper 16-bit of corresponding Interrupt Control Register is updated with the value in GIWD.
 */
#define GPIO_GICHR_GIWE25(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_GICHR_GIWE25_SHIFT)) & GPIO_GICHR_GIWE25_MASK)

#define GPIO_GICHR_GIWE26_MASK                   (0x400U)
#define GPIO_GICHR_GIWE26_SHIFT                  (10U)
/*! GIWE26 - Global Interrupt Write Enable
 *  0b0..Upper 16-bit of corresponding Interrupt Control Register is not updated with the value in GIWD.
 *  0b1..Upper 16-bit of corresponding Interrupt Control Register is updated with the value in GIWD.
 */
#define GPIO_GICHR_GIWE26(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_GICHR_GIWE26_SHIFT)) & GPIO_GICHR_GIWE26_MASK)

#define GPIO_GICHR_GIWE27_MASK                   (0x800U)
#define GPIO_GICHR_GIWE27_SHIFT                  (11U)
/*! GIWE27 - Global Interrupt Write Enable
 *  0b0..Upper 16-bit of corresponding Interrupt Control Register is not updated with the value in GIWD.
 *  0b1..Upper 16-bit of corresponding Interrupt Control Register is updated with the value in GIWD.
 */
#define GPIO_GICHR_GIWE27(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_GICHR_GIWE27_SHIFT)) & GPIO_GICHR_GIWE27_MASK)

#define GPIO_GICHR_GIWE28_MASK                   (0x1000U)
#define GPIO_GICHR_GIWE28_SHIFT                  (12U)
/*! GIWE28 - Global Interrupt Write Enable
 *  0b0..Upper 16-bit of corresponding Interrupt Control Register is not updated with the value in GIWD.
 *  0b1..Upper 16-bit of corresponding Interrupt Control Register is updated with the value in GIWD.
 */
#define GPIO_GICHR_GIWE28(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_GICHR_GIWE28_SHIFT)) & GPIO_GICHR_GIWE28_MASK)

#define GPIO_GICHR_GIWE29_MASK                   (0x2000U)
#define GPIO_GICHR_GIWE29_SHIFT                  (13U)
/*! GIWE29 - Global Interrupt Write Enable
 *  0b0..Upper 16-bit of corresponding Interrupt Control Register is not updated with the value in GIWD.
 *  0b1..Upper 16-bit of corresponding Interrupt Control Register is updated with the value in GIWD.
 */
#define GPIO_GICHR_GIWE29(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_GICHR_GIWE29_SHIFT)) & GPIO_GICHR_GIWE29_MASK)

#define GPIO_GICHR_GIWE30_MASK                   (0x4000U)
#define GPIO_GICHR_GIWE30_SHIFT                  (14U)
/*! GIWE30 - Global Interrupt Write Enable
 *  0b0..Upper 16-bit of corresponding Interrupt Control Register is not updated with the value in GIWD.
 *  0b1..Upper 16-bit of corresponding Interrupt Control Register is updated with the value in GIWD.
 */
#define GPIO_GICHR_GIWE30(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_GICHR_GIWE30_SHIFT)) & GPIO_GICHR_GIWE30_MASK)

#define GPIO_GICHR_GIWE31_MASK                   (0x8000U)
#define GPIO_GICHR_GIWE31_SHIFT                  (15U)
/*! GIWE31 - Global Interrupt Write Enable
 *  0b0..Upper 16-bit of corresponding Interrupt Control Register is not updated with the value in GIWD.
 *  0b1..Upper 16-bit of corresponding Interrupt Control Register is updated with the value in GIWD.
 */
#define GPIO_GICHR_GIWE31(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_GICHR_GIWE31_SHIFT)) & GPIO_GICHR_GIWE31_MASK)

#define GPIO_GICHR_GIWD_MASK                     (0xFFFF0000U)
#define GPIO_GICHR_GIWD_SHIFT                    (16U)
/*! GIWD - Global Interrupt Write Data
 */
#define GPIO_GICHR_GIWD(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_GICHR_GIWD_SHIFT)) & GPIO_GICHR_GIWD_MASK)
/*! @} */

/*! @name ISFR - Interrupt Status Flag Register */
/*! @{ */

#define GPIO_ISFR_ISF0_MASK                      (0x1U)
#define GPIO_ISFR_ISF0_SHIFT                     (0U)
/*! ISF0 - Interrupt Status Flag
 *  0b0..Configured interrupt is not detected on the pin of the same number.
 *  0b1..Configured interrupt is detected on the pin of the same number. If the pin is configured to generate a
 *       DMA request, then the corresponding flag will be cleared automatically at the completion of the requested
 *       DMA transfer. Otherwise, the flag remains set until a logic 1 is written to the flag. If the pin is
 *       configured for a level sensitive interrupt and the pin remains asserted, then the flag is set again immediately
 *       after it is cleared.
 */
#define GPIO_ISFR_ISF0(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_ISFR_ISF0_SHIFT)) & GPIO_ISFR_ISF0_MASK)

#define GPIO_ISFR_ISF1_MASK                      (0x2U)
#define GPIO_ISFR_ISF1_SHIFT                     (1U)
/*! ISF1 - Interrupt Status Flag
 *  0b0..Configured interrupt is not detected on the pin of the same number.
 *  0b1..Configured interrupt is detected on the pin of the same number. If the pin is configured to generate a
 *       DMA request, then the corresponding flag will be cleared automatically at the completion of the requested
 *       DMA transfer. Otherwise, the flag remains set until a logic 1 is written to the flag. If the pin is
 *       configured for a level sensitive interrupt and the pin remains asserted, then the flag is set again immediately
 *       after it is cleared.
 */
#define GPIO_ISFR_ISF1(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_ISFR_ISF1_SHIFT)) & GPIO_ISFR_ISF1_MASK)

#define GPIO_ISFR_ISF2_MASK                      (0x4U)
#define GPIO_ISFR_ISF2_SHIFT                     (2U)
/*! ISF2 - Interrupt Status Flag
 *  0b0..Configured interrupt is not detected on the pin of the same number.
 *  0b1..Configured interrupt is detected on the pin of the same number. If the pin is configured to generate a
 *       DMA request, then the corresponding flag will be cleared automatically at the completion of the requested
 *       DMA transfer. Otherwise, the flag remains set until a logic 1 is written to the flag. If the pin is
 *       configured for a level sensitive interrupt and the pin remains asserted, then the flag is set again immediately
 *       after it is cleared.
 */
#define GPIO_ISFR_ISF2(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_ISFR_ISF2_SHIFT)) & GPIO_ISFR_ISF2_MASK)

#define GPIO_ISFR_ISF3_MASK                      (0x8U)
#define GPIO_ISFR_ISF3_SHIFT                     (3U)
/*! ISF3 - Interrupt Status Flag
 *  0b0..Configured interrupt is not detected on the pin of the same number.
 *  0b1..Configured interrupt is detected on the pin of the same number. If the pin is configured to generate a
 *       DMA request, then the corresponding flag will be cleared automatically at the completion of the requested
 *       DMA transfer. Otherwise, the flag remains set until a logic 1 is written to the flag. If the pin is
 *       configured for a level sensitive interrupt and the pin remains asserted, then the flag is set again immediately
 *       after it is cleared.
 */
#define GPIO_ISFR_ISF3(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_ISFR_ISF3_SHIFT)) & GPIO_ISFR_ISF3_MASK)

#define GPIO_ISFR_ISF4_MASK                      (0x10U)
#define GPIO_ISFR_ISF4_SHIFT                     (4U)
/*! ISF4 - Interrupt Status Flag
 *  0b0..Configured interrupt is not detected on the pin of the same number.
 *  0b1..Configured interrupt is detected on the pin of the same number. If the pin is configured to generate a
 *       DMA request, then the corresponding flag will be cleared automatically at the completion of the requested
 *       DMA transfer. Otherwise, the flag remains set until a logic 1 is written to the flag. If the pin is
 *       configured for a level sensitive interrupt and the pin remains asserted, then the flag is set again immediately
 *       after it is cleared.
 */
#define GPIO_ISFR_ISF4(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_ISFR_ISF4_SHIFT)) & GPIO_ISFR_ISF4_MASK)

#define GPIO_ISFR_ISF5_MASK                      (0x20U)
#define GPIO_ISFR_ISF5_SHIFT                     (5U)
/*! ISF5 - Interrupt Status Flag
 *  0b0..Configured interrupt is not detected on the pin of the same number.
 *  0b1..Configured interrupt is detected on the pin of the same number. If the pin is configured to generate a
 *       DMA request, then the corresponding flag will be cleared automatically at the completion of the requested
 *       DMA transfer. Otherwise, the flag remains set until a logic 1 is written to the flag. If the pin is
 *       configured for a level sensitive interrupt and the pin remains asserted, then the flag is set again immediately
 *       after it is cleared.
 */
#define GPIO_ISFR_ISF5(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_ISFR_ISF5_SHIFT)) & GPIO_ISFR_ISF5_MASK)

#define GPIO_ISFR_ISF6_MASK                      (0x40U)
#define GPIO_ISFR_ISF6_SHIFT                     (6U)
/*! ISF6 - Interrupt Status Flag
 *  0b0..Configured interrupt is not detected on the pin of the same number.
 *  0b1..Configured interrupt is detected on the pin of the same number. If the pin is configured to generate a
 *       DMA request, then the corresponding flag will be cleared automatically at the completion of the requested
 *       DMA transfer. Otherwise, the flag remains set until a logic 1 is written to the flag. If the pin is
 *       configured for a level sensitive interrupt and the pin remains asserted, then the flag is set again immediately
 *       after it is cleared.
 */
#define GPIO_ISFR_ISF6(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_ISFR_ISF6_SHIFT)) & GPIO_ISFR_ISF6_MASK)

#define GPIO_ISFR_ISF7_MASK                      (0x80U)
#define GPIO_ISFR_ISF7_SHIFT                     (7U)
/*! ISF7 - Interrupt Status Flag
 *  0b0..Configured interrupt is not detected on the pin of the same number.
 *  0b1..Configured interrupt is detected on the pin of the same number. If the pin is configured to generate a
 *       DMA request, then the corresponding flag will be cleared automatically at the completion of the requested
 *       DMA transfer. Otherwise, the flag remains set until a logic 1 is written to the flag. If the pin is
 *       configured for a level sensitive interrupt and the pin remains asserted, then the flag is set again immediately
 *       after it is cleared.
 */
#define GPIO_ISFR_ISF7(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_ISFR_ISF7_SHIFT)) & GPIO_ISFR_ISF7_MASK)

#define GPIO_ISFR_ISF8_MASK                      (0x100U)
#define GPIO_ISFR_ISF8_SHIFT                     (8U)
/*! ISF8 - Interrupt Status Flag
 *  0b0..Configured interrupt is not detected on the pin of the same number.
 *  0b1..Configured interrupt is detected on the pin of the same number. If the pin is configured to generate a
 *       DMA request, then the corresponding flag will be cleared automatically at the completion of the requested
 *       DMA transfer. Otherwise, the flag remains set until a logic 1 is written to the flag. If the pin is
 *       configured for a level sensitive interrupt and the pin remains asserted, then the flag is set again immediately
 *       after it is cleared.
 */
#define GPIO_ISFR_ISF8(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_ISFR_ISF8_SHIFT)) & GPIO_ISFR_ISF8_MASK)

#define GPIO_ISFR_ISF9_MASK                      (0x200U)
#define GPIO_ISFR_ISF9_SHIFT                     (9U)
/*! ISF9 - Interrupt Status Flag
 *  0b0..Configured interrupt is not detected on the pin of the same number.
 *  0b1..Configured interrupt is detected on the pin of the same number. If the pin is configured to generate a
 *       DMA request, then the corresponding flag will be cleared automatically at the completion of the requested
 *       DMA transfer. Otherwise, the flag remains set until a logic 1 is written to the flag. If the pin is
 *       configured for a level sensitive interrupt and the pin remains asserted, then the flag is set again immediately
 *       after it is cleared.
 */
#define GPIO_ISFR_ISF9(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_ISFR_ISF9_SHIFT)) & GPIO_ISFR_ISF9_MASK)

#define GPIO_ISFR_ISF10_MASK           