/*! *********************************************************************************
 * \defgroup app
 * @{
 ********************************************************************************** */
/*!
 * Copyright 2019, 2023 NXP
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * o Redistributions of source code must retain the above copyright notice, this list
 *   of conditions and the following disclaimer.
 *
 * o Redistributions in binary form must reproduce the above copyright notice, this
 *   list of conditions and the following disclaimer in the documentation and/or
 *   other materials provided with the distribution.
 *
 * o Neither the name of the copyright holder nor the names of its
 *   contributors may be used to endorse or promote products derived from this
 *   software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _APP_PREINCLUDE_H_
#define _APP_PREINCLUDE_H_

/*!
 *  Application specific configuration file only
 *  Board Specific Configuration shall be added to board.h file directly such as :
 *  - Number of button on the board,
 *  - Number of LEDs,
 *  - etc...
 */
/*! *********************************************************************************
 *     Board Configuration
 ********************************************************************************** */
/* Number of Buttons required by the application */
#define gAppButtonCnt_c                 2


/* Number of LEDs required by the application:
 * Beware! On KW45 PB0 is tied to SPI NOR Flash chip select and monochrome LED.
 * If external flash is to be used, avoid using monochrome LED.
 */
#define gAppLedCnt_c                    2
#define gAppRequireRgbLed_c             1

/*! Enable Debug Console (PRINTF) */
#define gDebugConsoleEnable_d           0

/*! *********************************************************************************
 *     App Configuration
 ********************************************************************************** */
#define gOtapClientAtt_d   1

/*! Enable/disable use of bonding capability */
#define gAppUseBonding_d   1

/*! Enable/disable use of pairing procedure */
#define gAppUsePairing_d   1

/*! Enable/disable use of privacy */
#define gAppUsePrivacy_d   0

#define gPasskeyValue_c                999999

/*! Repeated Attempts - Mitigation for pairing attacks */
#define gRepeatedAttempts_d             0

/*! Define as 1 to place OTA storage in external flash */
#define gAppOtaExternalStorage_c        (1U)

/*! Define the offset where to place the OTA partition storage in external flash */
#define gAppOtaStoragePartitionOffset_c   (0U)

/*! Define to 1 to post OTA transactions to a queue. The queue will be processed
 * in the idle task. This avoids blocking the system for too long in critical tasks
 * as the write to flash operations will be done during idle period. */
#define gAppOtaASyncFlashTransactions_c    1

/* Define max of consecutive OTA transactions processed during idle task (if gAppOtaASyncFlashTransactions_c is enabled)
 * This can be tuned accordingly to an acceptable block time in idle
 * More transactions means higher block time in idle (if the queue reaches this number of transactions) */
#define gAppOtaMaxConsecutiveTransactions_c (4U)

/*! If gAppOtaASyncFlashTransactions_c is enabled the queue of pending transactions
 *  must be dimensioned to store at least 4 operations to avoid buffer
 *  shortage */
#define gAppOtaNumberOfTransactions_c       (4U)

/*! *********************************************************************************
 *     Framework Configuration
 ********************************************************************************** */
/* enable NVM to be used as non volatile storage management by the host stack */
#define gAppUseNvm_d                    1

/*! The minimum heap size needed:
    6 blocks of 88
    2 blocks of 256
    3 blocks of 312
    1 block of 392
*/
#define MinimalHeapSize_c               2368

/* Defines number of timers needed by the application */
#if gRepeatedAttempts_d
#define gTmrApplicationTimers_c         5
#else
#define gTmrApplicationTimers_c         4
#endif

/* Enables / Disables the precision timers platform component */
#define TM_ENABLE_TIME_STAMP            0

/* Enable/Disable FSCI */
#define gFsciIncluded_c                 0

/* Enable/Disable FSCI 2 byte command length */
#define gFsciLenHas2Bytes_c             1

/* Enable/Disable the FSCI BLE OTAP module */
#define gFsciBleOtapEnabled_d           1

/* FSCI payload - set his high enough for long frames support */
#define gFsciMaxPayloadLen_c            520


/* Use Misra Compliant version of FSCI module */
#define gFsciUseDedicatedTask_c         1

#define gFsciTaskStackSize_c            1400



/*! *********************************************************************************
 *     BLE Stack Configuration
 ********************************************************************************** */
 /* Enable Serial Manager interface */
#define gAppUseSerialManager_c          1

#define gMaxServicesCount_d             5U
#define gMaxServiceCharCount_d          3U
#define gMaxCharDescriptorsCount_d      2U

/*! *********************************************************************************
 *     BLE LL Configuration
 ***********************************************************************************/
/*  ble_ll_config.h file lists the parameters with their default values. User can override
 *    the parameter here by defining the parameter to a user defined value. */

/*
 * Specific configuration of LL pools by block size and number of blocks for this application.
 * Optimized using the MEM_OPTIMIZE_BUFFER_POOL feature in MemManager,
 * we find that the most optimized combination for LL buffers.
 *
 * If LlPoolsDetails_c is not defined, default LL buffer configuration in app_preinclude_common.h
 * will be applied.
 */

/* Include common configuration file and board configuration file */
#include "app_preinclude_common.h"
#endif /* _APP_PREINCLUDE_H_ */

/*! *********************************************************************************
 * @}
 ********************************************************************************** */
