/*
 * Copyright 2020-2021 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

/***********************************************************************************************************************
 * This file was generated by the MCUXpresso Config Tools. Any manual edits made to this file
 * will be overwritten if the respective MCUXpresso Config Tools is used to update this file.
 **********************************************************************************************************************/

/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
!!GlobalInfo
product: Pins v9.0
processor: MIMXRT1176xxxxx
package_id: MIMXRT1176DVMAA
mcu_data: ksdk2_0
processor_version: 0.9.6
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */

#include "board_define.h"
#include "board.h"
#include "fsl_common.h"
#include "fsl_iomuxc.h"
#include "fsl_gpio.h"
#include "pin_mux.h"

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitBootPins
 * Description   : Calls initialization functions.
 *
 * END ****************************************************************************************************************/
void BOARD_InitBootPins(void)
{
#if TARGET_BOARD == BOARD_SMART_TLHMI
    BOARD_InitLpuartPins();
    BOARD_InitMipiPanelPins();
#ifdef ENABLE_CAMERA_DEV_MipiGc2145
    BOARD_InitMipiCameraPins();
#else
    BOARD_InitParallelCameraPins();
#endif

    BOARD_InitFlexioCameraPins();
#ifdef ENABLE_OUTPUT_DEV_RgbLed
    BOARD_InitRGBLedPins();
#endif /* ENABLE_OUTPUT_DEV_RgbLed */
#endif /* TARGET_BOARD == BOARD_SMART_TLHMI */

#if TARGET_BOARD == BOARD_1170EVK
    BOARD_InitLpuartPins();
    BOARD_InitMipiPanelPins();
    BOARD_InitMipiCameraPins();
#endif
    BOARD_InitPushButtonPins();
}


/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitRGBLedPins
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
void BOARD_InitRGBLedPins(void) {

#if TARGET_BOARD == BOARD_1170EVK
#elif TARGET_BOARD == BOARD_SMART_TLHMI
    /* Green LED */
    IOMUXC_SetPinMux(
        IOMUXC_GPIO_EMC_B2_01_GPIO_MUX2_IO11,   /* GPIO_EMC_B2_01 is configured as GPIO_MUX2_IO11 */
        0U);                                    /* Software Input On Field: Input Path is determined by functionality */

    /* Red LED */
    IOMUXC_SetPinMux(
        IOMUXC_GPIO_EMC_B2_00_GPIO_MUX2_IO10,   /* GPIO_EMC_B2_00 is configured as GPIO_MUX2_IO10 */
        0U);                                    /* Software Input On Field: Input Path is determined by functionality */

    /* Blue LED */
    IOMUXC_SetPinMux(
        IOMUXC_GPIO_EMC_B2_02_GPIO_MUX2_IO12,   /* GPIO_EMC_B2_02 is configured as GPIO_MUX2_IO12 */
        0U);                                    /* Software Input On Field: Input Path is determined by functionality */

    IOMUXC_GPR->GPR40 = ((IOMUXC_GPR->GPR40 &
      (~(IOMUXC_GPR_GPR40_GPIO_MUX2_GPIO_SEL_LOW_MASK))) /* Mask bits to zero which are setting */
        | IOMUXC_GPR_GPR40_GPIO_MUX2_GPIO_SEL_LOW(0x00U) /* GPIO2 and CM7_GPIO2 share same IO MUX function, GPIO_MUX2 selects one GPIO function: 0x00U */
      );
#endif
}
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_InitLpuartPins:
- options: {callFromInitBoot: 'true', coreID: cm7, enableClock: 'true'}
- pin_list:
  - {pin_num: M15, peripheral: LPUART1, signal: RXD, pin_signal: GPIO_AD_25, software_input_on: Enable,
pull_up_down_config: Pull_Down, pull_keeper_select: Keeper, open_drain: Disable, drive_strength: Normal, slew_rate:
Slow}
  - {pin_num: L13, peripheral: LPUART1, signal: TXD, pin_signal: GPIO_AD_24, pull_up_down_config: Pull_Down,
pull_keeper_select: Keeper, open_drain: Disable, drive_strength: Normal, slew_rate: Slow}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitLpuartPins, assigned for the Cortex-M7F core.
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
void BOARD_InitLpuartPins(void)
{
    CLOCK_EnableClock(kCLOCK_Iomuxc); /* LPCG on: LPCG is ON. */

#if DEBUG_CONSOLE_UART_INDEX == 1
    IOMUXC_SetPinMux(IOMUXC_GPIO_AD_24_LPUART1_TXD, /* GPIO_AD_24 is configured as LPUART1_TXD */
                     0U); /* Software Input On Field: Input Path is determined by functionality */
    IOMUXC_SetPinMux(IOMUXC_GPIO_AD_25_LPUART1_RXD,    /* GPIO_AD_25 is configured as LPUART1_RXD */
                     1U);                              /* Software Input On Field: Force input path of pad GPIO_AD_25 */
    IOMUXC_SetPinConfig(IOMUXC_GPIO_AD_24_LPUART1_TXD, /* GPIO_AD_24 PAD functional properties : */
                        0x00U);                        /* Slew Rate Field: Slow Slew Rate
                                                          Drive Strength Field: normal drive strength
                                                          Pull / Keep Select Field: Pull Disable, Highz
                                                          Pull Up / Down Config. Field: Weak pull down
                                                          Open Drain Field: Disabled
                                                          Domain write protection: Both cores are allowed
                                                          Domain write protection lock: Neither of DWP bits is locked */
    IOMUXC_SetPinConfig(IOMUXC_GPIO_AD_25_LPUART1_RXD, /* GPIO_AD_25 PAD functional properties : */
                        0x00U);                        /* Slew Rate Field: Slow Slew Rate
                                                          Drive Strength Field: normal drive strength
                                                          Pull / Keep Select Field: Pull Disable, Highz
                                                          Pull Up / Down Config. Field: Weak pull down
                                                          Open Drain Field: Disabled
                                                          Domain write protection: Both cores are allowed
                                                          Domain write protection lock: Neither of DWP bits is locked */
#elif DEBUG_CONSOLE_UART_INDEX == 12
    IOMUXC_SetPinConfig(IOMUXC_GPIO_LPSR_00_LPUART12_TXD, /* GPIO_AD_25 PAD functional properties : */
                           0x00U);                        /* Slew Rate Field: Slow Slew Rate
                                                             Drive Strength Field: normal drive strength
                                                             Pull / Keep Select Field: Pull Disable, Highz
                                                             Pull Up / Down Config. Field: Weak pull down
                                                             Open Drain Field: Disabled
                                                             Domain write protection: Both cores are allowed
                                                             Domain write protection lock: Neither of DWP bits is locked */
    IOMUXC_SetPinConfig(IOMUXC_GPIO_LPSR_01_LPUART12_RXD, /* GPIO_AD_25 PAD functional properties : */
                           0x00U);                        /* Slew Rate Field: Slow Slew Rate
                                                             Drive Strength Field: normal drive strength
                                                             Pull / Keep Select Field: Pull Disable, Highz
                                                             Pull Up / Down Config. Field: Weak pull down
                                                             Open Drain Field: Disabled
                                                             Domain write protection: Both cores are allowed
                                                             Domain write protection lock: Neither of DWP bits is locked */
    IOMUXC_SetPinMux(IOMUXC_GPIO_LPSR_00_LPUART12_TXD, /* GPIO_LPSR_00 is configured as LPUART12_TXD */
                     0U); /* Software Input On Field: Input Path is determined by functionality */
    IOMUXC_SetPinMux(IOMUXC_GPIO_LPSR_01_LPUART12_RXD, /* GPIO_LPSR_01 is configured as LPUART12_RXD */
                     1U); /* Software Input On Field: Force input path of pad GPIO_AD_25 */
#endif
}

/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_InitMipiPanelPins:
- options: {callFromInitBoot: 'false', coreID: cm7, enableClock: 'true'}
- pin_list:
  - {pin_num: A4, peripheral: GPIO11, signal: 'gpio_io, 16', pin_signal: GPIO_DISP_B2_15, software_input_on: Disable}
  - {pin_num: N8, peripheral: LPI2C5, signal: SCL, pin_signal: GPIO_LPSR_05, software_input_on: Enable,
pull_up_down_config: Pull_Down, pull_keeper_select: Keeper, open_drain: Enable, drive_strength: Normal, slew_rate: Slow}
  - {pin_num: N7, peripheral: LPI2C5, signal: SDA, pin_signal: GPIO_LPSR_04, software_input_on: Enable,
pull_up_down_config: Pull_Down, pull_keeper_select: Keeper, open_drain: Enable, drive_strength: Normal, slew_rate: Slow}
  - {pin_num: N12, peripheral: GPIO8, signal: 'gpio_io, 31', pin_signal: GPIO_AD_00, software_input_on: Enable,
pull_up_down_config: Pull_Down, pull_keeper_select: Keeper, open_drain: Disable, drive_strength: Normal, slew_rate:
Slow}
  - {pin_num: R14, peripheral: GPIO9, signal: 'gpio_io, 00', pin_signal: GPIO_AD_01, pull_up_down_config: Pull_Down,
pull_keeper_select: Keeper, open_drain: Disable, drive_strength: Normal, slew_rate: Slow}
  - {pin_num: R13, peripheral: GPIO9, signal: 'gpio_io, 01', pin_signal: GPIO_AD_02}
  - {pin_num: K17, peripheral: GPIO9, signal: 'gpio_io, 29', pin_signal: GPIO_AD_30}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitMipiPanelPins, assigned for the Cortex-M7F core.
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
void BOARD_InitMipiPanelPins(void)
{
    CLOCK_EnableClock(kCLOCK_Iomuxc);      /* LPCG on: LPCG is ON. */
    CLOCK_EnableClock(kCLOCK_Iomuxc_Lpsr); /* LPCG on: LPCG is ON. */

#if TARGET_BOARD == BOARD_1170EVK
    IOMUXC_SetPinMux(IOMUXC_GPIO_AD_00_GPIO8_IO31, /* GPIO_AD_00 is configured as GPIO8_IO31 */
                     1U);                          /* Software Input On Field: Force input path of pad GPIO_AD_00 */
    IOMUXC_SetPinMux(IOMUXC_GPIO_AD_01_GPIO9_IO00, /* GPIO_AD_01 is configured as GPIO9_IO00 */
                     0U); /* Software Input On Field: Input Path is determined by functionality */
    IOMUXC_SetPinMux(IOMUXC_GPIO_AD_02_GPIO9_IO01, /* GPIO_AD_02 is configured as GPIO9_IO01 */
                     0U); /* Software Input On Field: Input Path is determined by functionality */
    IOMUXC_SetPinMux(IOMUXC_GPIO_AD_30_GPIO9_IO29, /* GPIO_AD_30 is configured as GPIO9_IO29 */
                     0U); /* Software Input On Field: Input Path is determined by functionality */
    IOMUXC_SetPinMux(IOMUXC_GPIO_DISP_B2_15_GPIO11_IO16, /* GPIO_DISP_B2_15 is configured as GPIO11_IO16 */
                     0U); /* Software Input On Field: Input Path is determined by functionality */
    IOMUXC_SetPinMux(IOMUXC_GPIO_LPSR_04_LPI2C5_SDA, /* GPIO_LPSR_04 is configured as LPI2C5_SDA */
                     1U);                            /* Software Input On Field: Force input path of pad GPIO_LPSR_04 */
    IOMUXC_SetPinMux(IOMUXC_GPIO_LPSR_05_LPI2C5_SCL, /* GPIO_LPSR_05 is configured as LPI2C5_SCL */
                     1U);                            /* Software Input On Field: Force input path of pad GPIO_LPSR_05 */
    IOMUXC_SetPinConfig(IOMUXC_GPIO_AD_00_GPIO8_IO31,   /* GPIO_AD_00 PAD functional properties : */
                        0x00U);                         /* Slew Rate Field: Slow Slew Rate
                                                           Drive Strength Field: normal drive strength
                                                           Pull / Keep Select Field: Pull Disable, Highz
                                                           Pull Up / Down Config. Field: Weak pull down
                                                           Open Drain Field: Disabled
                                                           Domain write protection: Both cores are allowed
                                                           Domain write protection lock: Neither of DWP bits is locked */
    IOMUXC_SetPinConfig(IOMUXC_GPIO_AD_01_GPIO9_IO00,   /* GPIO_AD_01 PAD functional properties : */
                        0x00U);                         /* Slew Rate Field: Slow Slew Rate
                                                           Drive Strength Field: normal drive strength
                                                           Pull / Keep Select Field: Pull Disable, Highz
                                                           Pull Up / Down Config. Field: Weak pull down
                                                           Open Drain Field: Disabled
                                                           Domain write protection: Both cores are allowed
                                                           Domain write protection lock: Neither of DWP bits is locked */
    IOMUXC_SetPinConfig(IOMUXC_GPIO_LPSR_04_LPI2C5_SDA, /* GPIO_LPSR_04 PAD functional properties : */
                        0x20U);                         /* Slew Rate Field: Slow Slew Rate
                                                           Drive Strength Field: normal driver
                                                           Pull / Keep Select Field: Pull Disable
                                                           Pull Up / Down Config. Field: Weak pull down
                                                           Open Drain LPSR Field: Enabled
                                                           Domain write protection: Both cores are allowed
                                                           Domain write protection lock: Neither of DWP bits is locked */
    IOMUXC_SetPinConfig(IOMUXC_GPIO_LPSR_05_LPI2C5_SCL, /* GPIO_LPSR_05 PAD functional properties : */
                        0x20U);                         /* Slew Rate Field: Slow Slew Rate
                                                           Drive Strength Field: normal driver
                                                           Pull / Keep Select Field: Pull Disable
                                                           Pull Up / Down Config. Field: Weak pull down
                                                           Open Drain LPSR Field: Enabled
                                                           Domain write protection: Both cores are allowed
                                                           Domain write protection lock: Neither of DWP bits is locked */
#elif TARGET_BOARD == BOARD_SMART_TLHMI
    /*
     * MIPI Panel LCD Pins.
     */
    IOMUXC_SetPinMux(IOMUXC_GPIO_EMC_B2_12_GPIO8_IO22, 0);   // PANEL_RST
    IOMUXC_SetPinMux(IOMUXC_GPIO_DISP_B2_15_GPIO11_IO16, 0); // PANEL_POWER
    IOMUXC_SetPinMux(IOMUXC_GPIO_AD_06_GPIO9_IO05, 0U);      // PANEL_BACKLIGHT

    /*
     * MIPI Panel Touch Pins
     */
    IOMUXC_SetPinMux(IOMUXC_GPIO_EMC_B2_11_GPIO8_IO21, 0U); // TOUCH_RST
    IOMUXC_SetPinMux(IOMUXC_GPIO_EMC_B2_10_GPIO8_IO20, 0U); // TOUCH_INT

    IOMUXC_SetPinMux(IOMUXC_GPIO_LPSR_04_LPI2C5_SDA, 1U); // TOUCH_I2C
    IOMUXC_SetPinMux(IOMUXC_GPIO_LPSR_05_LPI2C5_SCL, 1U); // TOUCH_I2C

    IOMUXC_SetPinConfig(IOMUXC_GPIO_LPSR_04_LPI2C5_SDA, /* GPIO_LPSR_04 PAD functional properties : */
                        0x2EU);                         /* Slew Rate Field: Slow Slew Rate
                                                           Drive Strength Field: normal driver
                                                           Pull / Keep Select Field: Pull Disable
                                                           Pull Up / Down Config. Field: Weak pull up
                                                           Open Drain LPSR Field: Enabled
                                                           Domain write protection: Both cores are allowed
                                                           Domain write protection lock: Neither of DWP bits is locked */
    IOMUXC_SetPinConfig(IOMUXC_GPIO_LPSR_05_LPI2C5_SCL, /* GPIO_LPSR_05 PAD functional properties : */
                        0x2EU);                         /* Slew Rate Field: Slow Slew Rate
                                                           Drive Strength Field: normal driver
                                                           Pull / Keep Select Field: Pull Disable
                                                           Pull Up / Down Config. Field: Weak pull up
                                                           Open Drain LPSR Field: Enabled
                                                           Domain write protection: Both cores are allowed
                                                           Domain write protection lock: Neither of DWP bits is locked */
#endif
}

/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_InitMipiCameraPins:
- options: {callFromInitBoot: 'false', coreID: cm7, enableClock: 'true'}
- pin_list:
  - {pin_num: L14, peripheral: GPIO9, signal: 'gpio_io, 25', pin_signal: GPIO_AD_26, direction: OUTPUT}
  - {pin_num: A7, peripheral: GPIO11, signal: 'gpio_io, 15', pin_signal: GPIO_DISP_B2_14, direction: OUTPUT}
  - {pin_num: R8, peripheral: LPI2C6, signal: SCL, pin_signal: GPIO_LPSR_07, software_input_on: Enable}
  - {pin_num: P8, peripheral: LPI2C6, signal: SDA, pin_signal: GPIO_LPSR_06, software_input_on: Enable}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitMipiCameraPins, assigned for the Cortex-M7F core.
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
#if TARGET_BOARD == BOARD_1170EVK
void BOARD_InitMipiCameraPins(void)
{
    CLOCK_EnableClock(kCLOCK_Iomuxc);      /* LPCG on: LPCG is ON. */
    CLOCK_EnableClock(kCLOCK_Iomuxc_Lpsr); /* LPCG on: LPCG is ON. */

    /* GPIO configuration of CAMERA_PWDN on GPIO_AD_26 (pin L14) */
    gpio_pin_config_t CAMERA_PWDN_config = {
        .direction = kGPIO_DigitalOutput, .outputLogic = 0U, .interruptMode = kGPIO_NoIntmode};
    /* Initialize GPIO functionality on GPIO_AD_26 (pin L14) */
    GPIO_PinInit(GPIO9, 25U, &CAMERA_PWDN_config);

    /* GPIO configuration of CAMERA_RST on GPIO_DISP_B2_14 (pin A7) */
    gpio_pin_config_t CAMERA_RST_config = {
        .direction = kGPIO_DigitalOutput, .outputLogic = 0U, .interruptMode = kGPIO_NoIntmode};
    /* Initialize GPIO functionality on GPIO_DISP_B2_14 (pin A7) */
    GPIO_PinInit(GPIO11, 15U, &CAMERA_RST_config);

    IOMUXC_SetPinMux(IOMUXC_GPIO_AD_26_GPIO9_IO25, /* GPIO_AD_26 is configured as GPIO9_IO25 */
                     0U); /* Software Input On Field: Input Path is determined by functionality */
    IOMUXC_SetPinMux(IOMUXC_GPIO_DISP_B2_14_GPIO11_IO15, /* GPIO_DISP_B2_14 is configured as GPIO11_IO15 */
                     0U); /* Software Input On Field: Input Path is determined by functionality */
    IOMUXC_SetPinMux(IOMUXC_GPIO_LPSR_06_LPI2C6_SDA, /* GPIO_LPSR_06 is configured as LPI2C6_SDA */
                     1U);                            /* Software Input On Field: Force input path of pad GPIO_LPSR_06 */
    IOMUXC_SetPinMux(IOMUXC_GPIO_LPSR_07_LPI2C6_SCL, /* GPIO_LPSR_07 is configured as LPI2C6_SCL */
                     1U);                            /* Software Input On Field: Force input path of pad GPIO_LPSR_07 */
}
#elif TARGET_BOARD == BOARD_SMART_TLHMI
void BOARD_InitMipiCameraPins(void)
{
    CLOCK_EnableClock(kCLOCK_Iomuxc);      /* LPCG on: LPCG is ON. */
    CLOCK_EnableClock(kCLOCK_Iomuxc_Lpsr); /* LPCG on: LPCG is ON. */

    /* GPIO configuration of GC2145_RESET on GPIO_SNVS_02_DIG (pin L9) */
    gpio_pin_config_t CAMERA_RST_config = {
        .direction = kGPIO_DigitalOutput, .outputLogic = 0U, .interruptMode = kGPIO_NoIntmode};
    /* Initialize GPIO functionality on GPIO_SNVS_02_DIG (pin L9) */
    GPIO_PinInit(GPIO13, 5U, &CAMERA_RST_config);

    /* GPIO configuration of GC2145_PWDN on GPIO_SNVS_06_DIG (pin M9) */
    gpio_pin_config_t CAMERA_PWDN_config = {
        .direction = kGPIO_DigitalOutput, .outputLogic = 1U, .interruptMode = kGPIO_NoIntmode};
    /* Initialize GPIO functionality on GPIO_SNVS_06_DIG (pin M9) */
    GPIO_PinInit(GPIO13, 9U, &CAMERA_PWDN_config);

    /* GPIO configuration of PMIC_STBY_REQ(VDD_2V8 DCDC enable) on PMIC_STBY_REQ_DIG (pin T9) */
    gpio_pin_config_t PMIC_STBY_REQ_config = {
        .direction = kGPIO_DigitalOutput, .outputLogic = 1U, .interruptMode = kGPIO_NoIntmode};
    /* Initialize GPIO functionality on PMIC_STBY_REQ_DIG (pin T9) */
    GPIO_PinInit(GPIO13, 2U, &PMIC_STBY_REQ_config);
    /*VDD_2V8 DCDC enable*/
    IOMUXC_SetPinMux(IOMUXC_PMIC_STBY_REQ_DIG_GPIO13_IO02, /* PMIC_STBY_REQ_DIG is configured as GPIO13_IO02 */
                     0U); /* Software Input On Field: Input Path is determined by functionality */

    /* GC2145_RESET */
    IOMUXC_SetPinMux(IOMUXC_GPIO_SNVS_02_DIG_GPIO13_IO05, /* GPIO_SNVS_02_DIG is configured as GPIO13_IO05 */
                     0U); /* Software Input On Field: Input Path is determined by functionality */
    /* GC2145_PWDN */
    IOMUXC_SetPinMux(IOMUXC_GPIO_SNVS_06_DIG_GPIO13_IO09, /* GPIO_SNVS_06_DIG is configured as GPIO13_IO09 */
                     0U); /* Software Input On Field: Input Path is determined by functionality */
    /* I2C Setting Interface */
    IOMUXC_SetPinMux(IOMUXC_GPIO_LPSR_06_LPI2C6_SDA, /* GPIO_LPSR_06 is configured as LPI2C6_SDA */
                     1U);                            /* Software Input On Field: Force input path of pad GPIO_LPSR_06 */
    IOMUXC_SetPinMux(IOMUXC_GPIO_LPSR_07_LPI2C6_SCL, /* GPIO_LPSR_07 is configured as LPI2C6_SCL */
                     1U);                            /* Software Input On Field: Force input path of pad GPIO_LPSR_07 */
    /* MCLK */
    IOMUXC_SetPinMux(IOMUXC_GPIO_AD_13_VIDEO_MUX_CSI_MCLK, /* GPIO_AD_13 is configured as VIDEO_MUX_CSI_MCLK */
                     0U); /* Software Input On Field: Input Path is determined by functionality */

    /* Pin Config for SDA, SCL */
    IOMUXC_SetPinConfig(IOMUXC_GPIO_LPSR_06_LPI2C6_SDA, /* GPIO_LPSR_06 PAD functional properties : */
                        0x2EU);                         /* Slew Rate Field: Slow Slew Rate
                                                           Drive Strength Field: high driver
                                                           Pull / Keep Select Field: Pull Enable
                                                           Pull Up / Down Config. Field: Weak pull up
                                                           Open Drain LPSR Field: Enabled
                                                           Domain write protection: Both cores are allowed
                                                           Domain write protection lock: Neither of DWP bits is locked */
    IOMUXC_SetPinConfig(IOMUXC_GPIO_LPSR_07_LPI2C6_SCL, /* GPIO_LPSR_07 PAD functional properties : */
                        0x2EU);                         /* Slew Rate Field: Slow Slew Rate
                                                           Drive Strength Field: high driver
                                                           Pull / Keep Select Field: Pull Enable
                                                           Pull Up / Down Config. Field: Weak pull up
                                                           Open Drain LPSR Field: Enabled
                                                           Domain write protection: Both cores are allowed
                                                           Domain write protection lock: Neither of DWP bits is locked */
    /* MCLK */
    IOMUXC_SetPinConfig(IOMUXC_GPIO_AD_13_VIDEO_MUX_CSI_MCLK, /* GPIO_AD_13 PAD functional properties : */
                        0x04U);                               /* Slew Rate Field: Slow Slew Rate
                                                      Drive Strength Field: normal drive strength
                                                      Pull / Keep Select Field: Pull Enable
                                                      Pull Up / Down Config. Field: Weak pull down
                                                      Open Drain Field: Disabled
                                                      Domain write protection: Both cores are allowed
                                                      Domain write protection lock: Neither of DWP bits is locked */
}
#endif

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitParallelCameraPins
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
void BOARD_InitParallelCameraPins(void)
{
    CLOCK_EnableClock(kCLOCK_Iomuxc);      /* LPCG on: LPCG is ON. */
    CLOCK_EnableClock(kCLOCK_Iomuxc_Lpsr); /* LPCG on: LPCG is ON. */

    /* I2C Setting Interface */
    IOMUXC_SetPinMux(IOMUXC_GPIO_LPSR_06_LPI2C6_SDA, /* GPIO_LPSR_06 is configured as LPI2C6_SDA */
                     1U);                            /* Software Input On Field: Force input path of pad GPIO_LPSR_06 */
    IOMUXC_SetPinMux(IOMUXC_GPIO_LPSR_07_LPI2C6_SCL, /* GPIO_LPSR_07 is configured as LPI2C6_SCL */
                     1U);                            /* Software Input On Field: Force input path of pad GPIO_LPSR_07 */

    /*3DIC_PWR */
    IOMUXC_SetPinMux(IOMUXC_GPIO_SNVS_06_DIG_GPIO13_IO09, /* GPIO_SNVS_06_DIG is configured as GPIO13_IO09 */
                     0U);
    /* IR_RESET */
    IOMUXC_SetPinMux(IOMUXC_GPIO_EMC_B2_14_GPIO_MUX2_IO24, /* GPIO_EMC_B2_14 is configured as GPIO_MUX2_IO24*/
                     0U); /* Software Input On Field: Input Path is determined by functionality */
    IOMUXC_GPR->GPR41 =
        ((IOMUXC_GPR->GPR41 &
          (~(IOMUXC_GPR_GPR41_GPIO_MUX2_GPIO_SEL_HIGH_MASK))) /* Mask bits to zero which are setting */
         | IOMUXC_GPR_GPR41_GPIO_MUX2_GPIO_SEL_HIGH(
               0x00U) /* GPIO2 and CM7_GPIO2 share same IO MUX function, GPIO_MUX2 selects one GPIO function: 0x00U */
        );

    IOMUXC_SetPinMux(IOMUXC_GPIO_AD_12_VIDEO_MUX_CSI_PIXCLK, /* GPIO_AD_12 is configured as VIDEO_MUX_CSI_PIXCLK */
                     0U); /* Software Input On Field: Input Path is determined by functionality */
    IOMUXC_SetPinMux(IOMUXC_GPIO_AD_13_VIDEO_MUX_CSI_MCLK, /* GPIO_AD_13 is configured as VIDEO_MUX_CSI_MCLK */
                     0U); /* Software Input On Field: Input Path is determined by functionality */
    IOMUXC_SetPinMux(IOMUXC_GPIO_AD_14_VIDEO_MUX_CSI_VSYNC, /* GPIO_AD_14 is configured as VIDEO_MUX_CSI_VSYNC */
                     0U); /* Software Input On Field: Input Path is determined by functionality */
    IOMUXC_SetPinMux(IOMUXC_GPIO_AD_15_VIDEO_MUX_CSI_HSYNC, /* GPIO_AD_15 is configured as VIDEO_MUX_CSI_HSYNC */
                     0U); /* Software Input On Field: Input Path is determined by functionality */
    IOMUXC_SetPinMux(IOMUXC_GPIO_AD_16_VIDEO_MUX_CSI_DATA09, /* GPIO_AD_16 is configured as VIDEO_MUX_CSI_DATA09 */
                     0U); /* Software Input On Field: Input Path is determined by functionality */
    IOMUXC_SetPinMux(IOMUXC_GPIO_AD_17_VIDEO_MUX_CSI_DATA08, /* GPIO_AD_17 is configured as VIDEO_MUX_CSI_DATA08 */
                     0U); /* Software Input On Field: Input Path is determined by functionality */
    IOMUXC_SetPinMux(IOMUXC_GPIO_AD_18_VIDEO_MUX_CSI_DATA07, /* GPIO_AD_18 is configured as VIDEO_MUX_CSI_DATA07 */
                     0U); /* Software Input On Field: Input Path is determined by functionality */
    IOMUXC_SetPinMux(IOMUXC_GPIO_AD_19_VIDEO_MUX_CSI_DATA06, /* GPIO_AD_19 is configured as VIDEO_MUX_CSI_DATA06 */
                     0U); /* Software Input On Field: Input Path is determined by functionality */
    IOMUXC_SetPinMux(IOMUXC_GPIO_AD_20_VIDEO_MUX_CSI_DATA05, /* GPIO_AD_20 is configured as VIDEO_MUX_CSI_DATA05 */
                     0U); /* Software Input On Field: Input Path is determined by functionality */
    IOMUXC_SetPinMux(IOMUXC_GPIO_AD_21_VIDEO_MUX_CSI_DATA04, /* GPIO_AD_21 is configured as VIDEO_MUX_CSI_DATA04 */
                     0U); /* Software Input On Field: Input Path is determined by functionality */
    IOMUXC_SetPinMux(IOMUXC_GPIO_AD_22_VIDEO_MUX_CSI_DATA03, /* GPIO_AD_22 is configured as VIDEO_MUX_CSI_DATA03 */
                     0U); /* Software Input On Field: Input Path is determined by functionality */
    IOMUXC_SetPinMux(IOMUXC_GPIO_AD_23_VIDEO_MUX_CSI_DATA02, /* GPIO_AD_23 is configured as VIDEO_MUX_CSI_DATA02 */
                     0U); /* Software Input On Field: Input Path is determined by functionality */

    IOMUXC_SetPinConfig(IOMUXC_GPIO_LPSR_06_LPI2C6_SDA, /* GPIO_LPSR_06 PAD functional properties : */
                        0x20U);                         /* Slew Rate Field: Slow Slew Rate
                                                           Drive Strength Field: high driver
                                                           Pull / Keep Select Field: Pull Enable
                                                           Pull Up / Down Config. Field: Weak pull up
                                                           Open Drain LPSR Field: Enabled
                                                           Domain write protection: Both cores are allowed
                                                           Domain write protection lock: Neither of DWP bits is locked */

    IOMUXC_SetPinConfig(IOMUXC_GPIO_LPSR_07_LPI2C6_SCL, /* GPIO_LPSR_07 PAD functional properties : */
                        0x20U);                         /* Slew Rate Field: Slow Slew Rate
                                                           Drive Strength Field: high driver
                                                           Pull / Keep Select Field: Pull Enable
                                                           Pull Up / Down Config. Field: Weak pull up
                                                           Open Drain LPSR Field: Enabled
                                                           Domain write protection: Both cores are allowed
                                                           Domain write protection lock: Neither of DWP bits is locked */

    IOMUXC_SetPinConfig(IOMUXC_GPIO_SNVS_06_DIG_GPIO13_IO09, /* GPIO_SNVS_06_DIG PAD functional properties : */
                        0x0EU);                              /* Slew Rate Field: Slow Slew Rate
                                                                Drive Strength Field: high driver
                                                                Pull / Keep Select Field: Pull Enable
                                                                Pull Up / Down Config. Field: Weak pull up
                                                                Open Drain SNVS Field: Disabled
                                                                Domain write protection: Both cores are allowed
                                                                Domain write protection lock: Neither of DWP bits is locked */

    IOMUXC_SetPinConfig(IOMUXC_GPIO_EMC_B2_14_GPIO_MUX2_IO24, /* GPIO_SNVS_06_DIG PAD functional properties : */
                        0x0EU);                               /* Slew Rate Field: Slow Slew Rate
                                                                 Drive Strength Field: high driver
                                                                 Pull / Keep Select Field: Pull Enable
                                                                 Pull Up / Down Config. Field: Weak pull up
                                                                 Open Drain SNVS Field: Disabled
                                                                 Domain write protection: Both cores are allowed
                                                                 Domain write protection lock: Neither of DWP bits is locked */

    IOMUXC_SetPinConfig(IOMUXC_GPIO_AD_13_VIDEO_MUX_CSI_MCLK, /* GPIO_AD_13 PAD functional properties : */
                        0x04U);                               /* Slew Rate Field: Slow Slew Rate
                                                                 Drive Strength Field: normal drive strength
                                                                 Pull / Keep Select Field: Pull Enable
                                                                 Pull Up / Down Config. Field: Weak pull down
                                                                 Open Drain Field: Disabled
                                                                 Domain write protection: Both cores are allowed
                                                                 Domain write protection lock: Neither of DWP bits is locked */

    /* Set the pins for CSI reset and power down. */
    gpio_pin_config_t pinConfig = {
        kGPIO_DigitalOutput,
        0,
        kGPIO_NoIntmode,
    };

    /* GC0308 Sensor PWDN
     * 0: normal work,
     * 1: standby     */
    GPIO_PinInit(BOARD_CSI_CAMERA_PWDN_GPIO, BOARD_CSI_CAMERA_PWDN_PIN, &pinConfig);

    /* GC0308 Sensor Reset
     * 0: chip reset
     * 1: normal work. */
    pinConfig.outputLogic = 1;
    GPIO_PinInit(BOARD_CSI_CAMERA_RESET_GPIO, BOARD_CSI_CAMERA_RESET_PIN, &pinConfig);
}

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitFlexioCameraPins
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
void BOARD_InitFlexioCameraPins(void)
{
    CLOCK_EnableClock(kCLOCK_Iomuxc);      /* LPCG on: LPCG is ON. */
    CLOCK_EnableClock(kCLOCK_Iomuxc_Lpsr); /* LPCG on: LPCG is ON. */

    IOMUXC_SetPinMux(IOMUXC_GPIO_LPSR_04_LPI2C5_SDA, /* GPIO_LPSR_04 is configured as LPI2C5_SDA */
                     1U);                            /* Software Input On Field: Force input path of pad GPIO_LPSR_04 */
    IOMUXC_SetPinMux(IOMUXC_GPIO_LPSR_05_LPI2C5_SCL, /* GPIO_LPSR_05 is configured as LPI2C5_SCL */
                     1U);                            /* Software Input On Field: Force input path of pad GPIO_LPSR_05 */

    /* CSI Interface */
    /* DATA 0-7 */
    IOMUXC_SetPinMux(IOMUXC_GPIO_AD_24_FLEXIO2_D24, /* GPIO_AD_24 is configured as FLEXIO2_D24 */
                     0U); /* Software Input On Field: Input Path is determined by functionality */
    IOMUXC_SetPinMux(IOMUXC_GPIO_AD_25_FLEXIO2_D25, /* GPIO_AD_25 is configured as FLEXIO2_D25 */
                     0U); /* Software Input On Field: Input Path is determined by functionality */
    IOMUXC_SetPinMux(IOMUXC_GPIO_AD_26_FLEXIO2_D26,     /* GPIO_AD_26 is configured as FLEXIO2_D26 */
                     0U); /* Software Input On Field: Input Path is determined by functionality */
    IOMUXC_SetPinMux(IOMUXC_GPIO_AD_27_FLEXIO2_D27,     /* GPIO_AD_27 is configured as FLEXIO2_D27 */
                     0U); /* Software Input On Field: Input Path is determined by functionality */
    IOMUXC_SetPinMux(IOMUXC_GPIO_AD_28_FLEXIO2_D28, /* GPIO_AD_28 is configured as FLEXIO2_D28 */
                     0U); /* Software Input On Field: Input Path is determined by functionality */
    IOMUXC_SetPinMux(IOMUXC_GPIO_AD_29_FLEXIO2_D29, /* GPIO_AD_29 is configured as FLEXIO2_D29 */
                     0U); /* Software Input On Field: Input Path is determined by functionality */
    IOMUXC_SetPinMux(IOMUXC_GPIO_AD_30_FLEXIO2_D30,     /* GPIO_AD_30 is configured as FLEXIO2_D30 */
                     0U); /* Software Input On Field: Input Path is determined by functionality */
    IOMUXC_SetPinMux(IOMUXC_GPIO_AD_31_FLEXIO2_D31,     /* GPIO_AD_31 is configured as FLEXIO2_D31 */
                     0U); /* Software Input On Field: Input Path is determined by functionality */

    /* MCLK */
    IOMUXC_SetPinMux(IOMUXC_GPIO_AD_00_FLEXIO2_D00,     /* GPIO_AD_000 is configured as FLEXIO2_D00 */
                     0U); /* Software Input On Field: Input Path is determined by functionality */
    /* PIXCLK */
    IOMUXC_SetPinMux(IOMUXC_GPIO_AD_01_FLEXIO2_D01,     /* GPIO_AD_01 is configured as FLEXIO2_D01 */
                     0U); /* Software Input On Field: Input Path is determined by functionality */
    /* HSYNC */
    IOMUXC_SetPinMux(IOMUXC_GPIO_AD_02_FLEXIO2_D02,     /* GPIO_AD_02 is configured as FLEXIO2_D02 */
                     0U); /* Software Input On Field: Input Path is determined by functionality */
    /* VSYNC */
    IOMUXC_SetPinMux(IOMUXC_GPIO_AD_32_GPIO_MUX3_IO31, /* GPIO_AD_32 is configured as GPIO_MUX3_IO31 */
                     0U); /* Software Input On Field: Input Path is determined by functionality */
    /* PWDN */
    IOMUXC_SetPinMux(IOMUXC_GPIO_SD_B2_04_GPIO10_IO13,  /* GPIO_SD_B2_04 is configured as GPIO10_IO13 */
                     0U); /* Software Input On Field: Input Path is determined by functionality */
    /* RESET */
    IOMUXC_SetPinMux(IOMUXC_GPIO_EMC_B2_15_GPIO_MUX2_IO25, /* GPIO_SNVS_02 is configured as GPIO13_IO25 */
                     0U); /* Software Input On Field: Input Path is determined by functionality */
    IOMUXC_GPR->GPR41 = ((IOMUXC_GPR->GPR41 &
      (~(IOMUXC_GPR_GPR41_GPIO_MUX2_GPIO_SEL_HIGH_MASK))) /* Mask bits to zero which are setting */
        | IOMUXC_GPR_GPR41_GPIO_MUX2_GPIO_SEL_HIGH(0x00U) /* GPIO2 and CM7_GPIO2 share same IO MUX function, GPIO_MUX2 selects one GPIO function: 0x00U */
      );

    /* Software Input On Field: Input Path is determined by functionality */
    IOMUXC_SetPinConfig(IOMUXC_GPIO_LPSR_04_LPI2C5_SDA, /* GPIO_SD_B2_10 PAD functional properties : */
                        0x20U);                         /* PDRV Field: normal drive strength
                                                           Pull Down Pull Up Field: Internal pulldown resistor enabled
                                                           Open Drain Field: Disabled
                                                           Domain write protection: Both cores are allowed
                                                           Domain write protection lock: Neither of DWP bits is locked */
    IOMUXC_SetPinConfig(IOMUXC_GPIO_LPSR_05_LPI2C5_SCL, /* GPIO_SD_B2_11 PAD functional properties : */
                        0x20U);                         /* PDRV Field: normal drive strength
                                                           Pull Down Pull Up Field: Internal pulldown resistor enabled
                                                           Open Drain Field: Disabled
                                                           Domain write protection: Both cores are allowed
                                                           Domain write protection lock: Neither of DWP bits is locked */
    IOMUXC_SetPinConfig(
        IOMUXC_GPIO_AD_09_FLEXIO2_D09,          /* GPIO_AD_09 PAD functional properties : */
        0x04U);                                 /* Slew Rate Field: Slow Slew Rate
                                                   Drive Strength Field: normal drive strength
                                                   Pull / Keep Select Field: Pull Enable
                                                   Pull Up / Down Config. Field: Weak pull down
                                                   Open Drain Field: Disabled
                                                   Domain write protection: Both cores are allowed
                                                   Domain write protection lock: Neither of DWP bits is locked */

    /* Set the pins for CSI reset and power down. */
    gpio_pin_config_t pinConfig = {
        kGPIO_DigitalOutput,
        0,
        kGPIO_NoIntmode,
    };

    /* GC0308 Sensor PWDN
     * 0: normal work,
     * 1: standby     */
    GPIO_PinInit(BOARD_FLEXIO_CAMERA_PWDN_GPIO, BOARD_FLEXIO_CAMERA_PWDN_PIN, &pinConfig);

    /* GC0308 Sensor Reset
     * 0: chip reset
     * 1: normal work. */
    pinConfig.outputLogic = 1;
    GPIO_PinInit(BOARD_FLEXIO_CAMERA_RESET_GPIO, BOARD_FLEXIO_CAMERA_RESET_PIN, &pinConfig);
}

/* FUNCTION
 * ************************************************************************************************************
 *
 * Function Name : BOARD_InitButtonPins
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END
 * ****************************************************************************************************************/
void BOARD_InitPushButtonPins(void)
{
    CLOCK_EnableClock(kCLOCK_Iomuxc); /* LPCG on: LPCG is ON. */

    IOMUXC_SetPinMux(IOMUXC_GPIO_EMC_B2_05_GPIO_MUX2_IO15, /* GPIO_EMC_B2_05 is configured as GPIO_MUX2_IO15 */
                     0U); /* Software Input On Field: Input Path is determined by functionality */
    IOMUXC_SetPinConfig(IOMUXC_GPIO_EMC_B2_05_GPIO_MUX2_IO15, /* GPIO_EMC_B2_05 PAD functional properties : */
                        0x0CU);                               /* PDRV Field: high drive strength
                                                                 Pull Down Pull Up Field: No Pull
                                                                 Open Drain Field: Disabled
                                                                 Domain write protection: Both cores are allowed
                                                                 Domain write protection lock: Neither of DWP bits is locked */
    IOMUXC_SetPinMux(IOMUXC_GPIO_EMC_B2_06_GPIO_MUX2_IO16,    /* GPIO_EMC_B2_06 is configured as GPIO_MUX2_IO16 */
                     0U); /* Software Input On Field: Input Path is determined by functionality */
    IOMUXC_SetPinConfig(IOMUXC_GPIO_EMC_B2_06_GPIO_MUX2_IO16, /* GPIO_EMC_B2_06 PAD functional properties : */
                        0x0CU);                               /* PDRV Field: high drive strength
                                                                 Pull Down Pull Up Field: No Pull
                                                                 Open Drain Field: Disabled
                                                                 Domain write protection: Both cores are allowed
                                                                 Domain write protection lock: Neither of DWP bits is locked */

    IOMUXC_SetPinMux(IOMUXC_GPIO_EMC_B2_07_GPIO_MUX2_IO17, /* GPIO_EMC_B2_07 is configured as GPIO_MUX2_IO17 */
                     0U); /* Software Input On Field: Input Path is determined by functionality */

    IOMUXC_SetPinConfig(IOMUXC_GPIO_EMC_B2_07_GPIO_MUX2_IO17, /* GPIO_EMC_B2_07 PAD functional properties : */
                        0x0CU);                               /* PDRV Field: high drive strength
                                                                 Pull Down Pull Up Field: No Pull
                                                                 Open Drain Field: Disabled
                                                                 Domain write protection: Both cores are allowed
                                                                 Domain write protection lock: Neither of DWP bits is locked */

    IOMUXC_GPR->GPR40 =
        ((IOMUXC_GPR->GPR40 &
          (~(IOMUXC_GPR_GPR40_GPIO_MUX2_GPIO_SEL_LOW_MASK))) /* Mask bits to zero which are setting */
         | IOMUXC_GPR_GPR40_GPIO_MUX2_GPIO_SEL_LOW(
               0x00U) /* GPIO2 and CM7_GPIO2 share same IO MUX function, GPIO_MUX2 selects one GPIO function: 0x00U */
        );
    IOMUXC_GPR->GPR41 =
        ((IOMUXC_GPR->GPR41 &
          (~(IOMUXC_GPR_GPR41_GPIO_MUX2_GPIO_SEL_HIGH_MASK))) /* Mask bits to zero which are setting */
         | IOMUXC_GPR_GPR41_GPIO_MUX2_GPIO_SEL_HIGH(
               0x00U) /* GPIO2 and CM7_GPIO2 share same IO MUX function, GPIO_MUX2 selects one GPIO function: 0x00U */
        );
    /* PB_WAKEUP */
    IOMUXC_SetPinMux(IOMUXC_WAKEUP_DIG_GPIO13_IO00, /* WAKEUP_DIG is configured as GPIO13_IO00 */
                     1U);                           /* Software Input On Field: Force input path of pad WAKEUP_DIG */
}

/***********************************************************************************************************************
 * EOF
 **********************************************************************************************************************/
