/**
 * @file custom.c
 *
 */

/*********************
 *      INCLUDES
 *********************/
#include <stdio.h>
#include "lvgl.h"
#include "custom.h"
#if defined(RT_PLATFORM) & LVGL_MULTITHREAD_LOCK
#include "FreeRTOS.h"
#include "semphr.h"
#include "lvgl_images_internal.h"
#endif
/*********************
 *      DEFINES
 *********************/

/**********************
 *      TYPEDEFS
 **********************/

/**********************
 *  STATIC PROTOTYPES
 **********************/
#ifdef RT_PLATFORM
/* LVGL should be single thread. Get this mutex for multithread access */
static SemaphoreHandle_t s_LVGLMutex;
#endif /*RT_PLATFORM*/
/**********************
 *  STATIC VARIABLES
 **********************/

/**
 * Create a demo application
 */

void custom_init(lv_ui *ui)
{
    /* Add your codes here */
#ifdef RT_PLATFORM
    s_LVGLMutex = xSemaphoreCreateMutex();

    if (s_LVGLMutex == NULL)
    {
        while (1)
        {
        }
    }
#endif
}

#ifdef RT_PLATFORM
void _takeLVGLMutex()
{
    if (s_LVGLMutex)
    {
        xSemaphoreTake(s_LVGLMutex, portMAX_DELAY);
    }
}

void _giveLVGLMutex()
{
    if (s_LVGLMutex)
    {
        xSemaphoreGive(s_LVGLMutex);
    }
}

void setup_imgs(unsigned char *base)
{
    _scan_example_597x460.data = (base + 0);
}
#endif
