/*
 * Copyright 2021-2023 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

/***********************************************************************************************************************
 * This file was generated by the MCUXpresso Config Tools. Any manual edits made to this file
 * will be overwritten if the respective MCUXpresso Config Tools is used to update this file.
 **********************************************************************************************************************/

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
!!GlobalInfo
product: Pins v12.0
processor: KW45B41Z83xxxA
package_id: KW45B41Z83AFTA
mcu_data: ksdk2_0
processor_version: 0.12.6
pin_labels:
- {pin_num: '44', pin_signal: ADC0_A8/PTC6/WUU0_P11/LPSPI1_PCS1/TPM1_CH5/FLEXIO0_D22, label: SW3, identifier: SW3}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

#include "fsl_common.h"
#include "fsl_port.h"
#include "pin_mux.h"

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitBootPins
 * Description   : Calls initialization functions.
 *
 * END ****************************************************************************************************************/
void BOARD_InitBootPins(void)
{
    BOARD_InitPins();
}

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_InitPins:
- options: {callFromInitBoot: 'true', coreID: cm33, enableClock: 'true'}
- pin_list:
  - {pin_num: '39', peripheral: LPUART1, signal: RX, pin_signal: PTC2/WUU0_P9/LPSPI1_SOUT/LPUART1_RX/LPI2C1_SCLS/TPM1_CH2/I3C0_PUR/FLEXIO0_D18, pull_select: down,
    pull_enable: disable, slew_rate: fast, open_drain: disable, drive_strength: low}
  - {pin_num: '40', peripheral: LPUART1, signal: TX, pin_signal: PTC3/LPSPI1_SCK/LPUART1_TX/LPI2C1_SDAS/TPM1_CH3/FLEXIO0_D19, pull_select: down, pull_enable: disable,
    slew_rate: fast, open_drain: disable, drive_strength: low}
  - {pin_num: '44', peripheral: GPIOC, signal: 'GPIO, 6', pin_signal: ADC0_A8/PTC6/WUU0_P11/LPSPI1_PCS1/TPM1_CH5/FLEXIO0_D22, pull_select: up, pull_enable: enable,
    slew_rate: slow, open_drain: enable, drive_strength: low}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitPins
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
void BOARD_InitPins(void)
{
    /* Clock Configuration: Peripheral clocks are enabled; module does not stall low power mode entry */
    CLOCK_EnableClock(kCLOCK_PortC);

    const port_pin_config_t portc2_pin39_config = {/* Internal pull-up/down resistor is disabled */
                                                   (uint16_t)kPORT_PullDisable,
                                                   /* Low internal pull resistor value is selected. */
                                                   (uint16_t)kPORT_LowPullResistor,
                                                   /* Fast slew rate is configured */
                                                   (uint16_t)kPORT_FastSlewRate,
                                                   /* Passive input filter is disabled */
                                                   (uint16_t)kPORT_PassiveFilterDisable,
                                                   /* Open drain output is disabled */
                                                   (uint16_t)kPORT_OpenDrainDisable,
                                                   /* Low drive strength is configured */
                                                   (uint16_t)kPORT_LowDriveStrength,
                                                   /* Normal drive strength is configured */
                                                   (uint16_t)kPORT_NormalDriveStrength,
                                                   /* Pin is configured as LPUART1_RX */
                                                   (uint16_t)kPORT_MuxAlt3,
                                                   /* Pin Control Register fields [15:0] are not locked */
                                                   (uint16_t)kPORT_UnlockRegister};
    /* PORTC2 (pin 39) is configured as LPUART1_RX */
    PORT_SetPinConfig(PORTC, 2U, &portc2_pin39_config);

    const port_pin_config_t portc3_pin40_config = {/* Internal pull-up/down resistor is disabled */
                                                   (uint16_t)kPORT_PullDisable,
                                                   /* Low internal pull resistor value is selected. */
                                                   (uint16_t)kPORT_LowPullResistor,
                                                   /* Fast slew rate is configured */
                                                   (uint16_t)kPORT_FastSlewRate,
                                                   /* Passive input filter is disabled */
                                                   (uint16_t)kPORT_PassiveFilterDisable,
                                                   /* Open drain output is disabled */
                                                   (uint16_t)kPORT_OpenDrainDisable,
                                                   /* Low drive strength is configured */
                                                   (uint16_t)kPORT_LowDriveStrength,
                                                   /* Normal drive strength is configured */
                                                   (uint16_t)kPORT_NormalDriveStrength,
                                                   /* Pin is configured as LPUART1_TX */
                                                   (uint16_t)kPORT_MuxAlt3,
                                                   /* Pin Control Register fields [15:0] are not locked */
                                                   (uint16_t)kPORT_UnlockRegister};
    /* PORTC3 (pin 40) is configured as LPUART1_TX */
    PORT_SetPinConfig(PORTC, 3U, &portc3_pin40_config);

    const port_pin_config_t SW3 = {/* Internal pull-up resistor is enabled */
                                   (uint16_t)kPORT_PullUp,
                                   /* Low internal pull resistor value is selected. */
                                   (uint16_t)kPORT_LowPullResistor,
                                   /* Slow slew rate is configured */
                                   (uint16_t)kPORT_SlowSlewRate,
                                   /* Passive input filter is disabled */
                                   (uint16_t)kPORT_PassiveFilterDisable,
                                   /* Open drain output is enabled */
                                   (uint16_t)kPORT_OpenDrainEnable,
                                   /* Low drive strength is configured */
                                   (uint16_t)kPORT_LowDriveStrength,
                                   /* Normal drive strength is configured */
                                   (uint16_t)kPORT_NormalDriveStrength,
                                   /* Pin is configured as PTC6 */
                                   (uint16_t)kPORT_MuxAsGpio,
                                   /* Pin Control Register fields [15:0] are not locked */
                                   (uint16_t)kPORT_UnlockRegister};
    /* PORTC6 (pin 44) is configured as PTC6 */
    PORT_SetPinConfig(BOARD_INITPINS_SW3_PORT, BOARD_INITPINS_SW3_PIN, &SW3);
}


void BOARD_InitPinsRTC(void)
{
        const port_pin_config_t portd3_pin26_config = {/* Internal pull-up/down resistor is disabled */
                                                   (uint16_t)kPORT_PullUp,
                                                   /* Low internal pull resistor value is selected. */
                                                   (uint16_t)kPORT_LowPullResistor,
                                                   /* Fast slew rate is configured */
                                                   (uint16_t)kPORT_FastSlewRate,
                                                   /* Passive input filter is disabled */
                                                   (uint16_t)kPORT_PassiveFilterDisable,
                                                   /* Open drain output is disabled */
                                                   (uint16_t)kPORT_OpenDrainDisable,
                                                   /* Low drive strength is configured */
                                                   (uint16_t)kPORT_LowDriveStrength,
                                                   /* Normal drive strength is configured */
                                                   (uint16_t)kPORT_NormalDriveStrength,
                                                   /* Pin is configured as EXTAL32K */
                                                   (uint16_t)kPORT_MuxAlt3,
                                                   /* Pin Control Register fields [15:0] are not locked */
                                                   (uint16_t)kPORT_UnlockRegister};
    /* PORTD3 (pin 26) is configured as TAMPER1 */
    PORT_SetPinConfig(PORTD, 3U, &portd3_pin26_config);
}
/***********************************************************************************************************************
 * EOF
 **********************************************************************************************************************/
