/*
 * Copyright 2019, 2025 NXP
 * All rights reserved.
 *
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */
#ifndef _APP_H_
#define _APP_H_

/*******************************************************************************
 * Definitions
 ******************************************************************************/
/*${macro:start}*/
#define BOARD_FLEXIO_BASE   FLEXIO0
#define FLEXIO_QSPI_MOSI_PIN 12U
#define FLEXIO_QSPI_SCK_PIN  8U
#define FLEXIO_QSPI_PCS0_PIN 9U

#define CS_GPIO_BASE         GPIO
#define CS_GPIO_PORT         4
#define CS_GPIO_PIN          29

/* Select flexio clock source */
#define FLEXIO_CLOCK_FREQUENCY CLOCK_GetFlexioClkFreq()
#define TRANSFER_BAUDRATE 2500000U /*! Transfer baudrate */
/*${macro:end}*/

/*******************************************************************************
 * Prototypes
 ******************************************************************************/
/*${prototype:start}*/
void BOARD_InitHardware(void);
/*${prototype:end}*/

#endif /* _APP_H_ */
