/*
 * Copyright 2019, 2025 NXP
 * All rights reserved.
 *
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */
/*${header:start}*/
#include "pin_mux.h"
#include "clock_config.h"
#include "board.h"
#include "fsl_common.h"
#include "fsl_smartdma.h"
#include "fsl_power.h"
#include "app.h"
/*${header:end}*/

/*${function:start}*/
static void BOARD_InitSmartDMA(void)
{
    POWER_DisablePD(kPDRUNCFG_APD_SMARTDMA_SRAM);
    POWER_DisablePD(kPDRUNCFG_PPD_SMARTDMA_SRAM);
    POWER_ApplyPD();

    SMARTDMA_InitWithoutFirmware();
    NVIC_EnableIRQ(SDMA_IRQn);
}

void BOARD_InitHardware(void)
{
    BOARD_InitPins();
    BOARD_BootClockRUN();
    BOARD_InitDebugConsole();
    BOARD_InitSmartDMA();

    RESET_ClearPeripheralReset(kFLEXIO_RST_SHIFT_RSTn);
}
/*${function:end}*/
