/*
 * Copyright 2018-2020 NXP
 * All rights reserved.
 * SPDX-License-Identifier: BSD-3-Clause
 *
 * This software is owned or controlled by NXP and may only be used strictly
 * in accordance with the applicable license terms.  By expressly accepting
 * such terms or by downloading, installing, activating and/or otherwise using
 * the software, you are agreeing that you have read, and that you agree to
 * comply with and are bound by, such license terms.  If you do not agree to
 * be bound by the applicable license terms, then you may not retain, install,
 * activate or otherwise use the software.
 */

#ifndef USB_VOLUME_CONVERSION_H_
#define USB_VOLUME_CONVERSION_H_

#include <stdint.h>

#define USB_VOLUME_CONVERSION_LOW_BYTES(_vol)   ((_vol) & 0xFF)
#define USB_VOLUME_CONVERSION_HIGH_BYTES(_vol)  USB_VOLUME_CONVERSION_LOW_BYTES(_vol >> 8)

/**
 * Conversion of volume in Db-value to USB-value.
 * The returned value can be used in USB descriptors.
 * NOTE: Only valid for whole numbers between -128 and 127!
 *
 * @param volumeInDb volume value in decibel
 * @return Usb representation of decibel value
 */
uint16_t USB_VolumeConversion_ConvertVolumeToUsb(int8_t volumeInDb);

/**
 * Conversion of a resolution in Db-value to USB-value.
 * The returned value can be used in USB descriptors.
 * NOTE: Only valid for whole numbers between 1 and 127!
 *
 * @param resolutionInDb resolution in decibel
 * @return Usb representation of decibel value
 */
uint16_t USB_VolumeConversion_ConvertResolution(uint8_t resolutionInDb);


#endif /* USB_VOLUME_CONVERSION_H_ */
