/*
 * Copyright 2023 NXP
 * All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */
/***********************************************************************************************************************
 * This file was generated by the MCUXpresso Config Tools. Any manual edits made to this file
 * will be overwritten if the respective MCUXpresso Config Tools is used to update this file.
 **********************************************************************************************************************/

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
!!GlobalInfo
product: Pins v15.0
processor: MCXN236
package_id: MCXN236VDF
mcu_data: ksdk2_0
processor_version: 0.15.0
pin_labels:
- {pin_num: C5, pin_signal: PIO1_1/TRIG_IN1/FC3_P1/FC4_P5/CT_INP5/FLEXIO0_D9/SAI1_TX_FS/ADC0_A17/CMP1_IN0, label: COL1, identifier: COL1}
- {pin_num: C4, pin_signal: PIO1_2/TRIG_OUT0/FC3_P2/FC4_P6/CT1_MAT0/FLEXIO0_D10/SAI1_TXD0/CAN0_TXD/ADC0_A18, label: COL2, identifier: COL2}
- {pin_num: C6, pin_signal: PIO1_0/WUU0_IN6/LPTMR0_ALT3/TRIG_IN0/FC3_P0/FC4_P4/CT_INP4/FLEXIO0_D8/SAI1_TX_BCLK/ADC0_A16/CMP0_IN0, label: COL3, identifier: COL3}
- {pin_num: F4, pin_signal: PIO1_17/FC5_P1/FC3_P5/CT_INP13/FLEXIO0_D25/I3C1_SCL/ADC1_A17, label: COL4, identifier: COL4}
- {pin_num: P1, pin_signal: PIO4_0/WUU0_IN18/TRIG_IN6/FC2_P0/CT_INP16/ADC0_A0, label: ROW1, identifier: ROW1}
- {pin_num: P2, pin_signal: PIO4_1/TRIG_IN7/FC2_P1/CT_INP17/ADC0_B0, label: ROW2, identifier: ROW2}
- {pin_num: M12, pin_signal: PIO5_4/TRIG_OUT7/SPC_LPREQ/TAMPER2/ADC1_B12, label: ROW3, identifier: ROW3}
- {pin_num: K12, pin_signal: PIO5_5/TRIG_IN10/LPTMR0_ALT2/TAMPER3/ADC1_B13, label: ROW4, identifier: ROW4}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

#include "fsl_common.h"
#include "fsl_port.h"
#include "fsl_gpio.h"
#include "pin_mux.h"

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitBootPins
 * Description   : Calls initialization functions.
 *
 * END ****************************************************************************************************************/
void BOARD_InitBootPins(void)
{
    BOARD_InitPins();
}

/* clang-format off */
/*
 * TEXT BELOW IS USED AS SETTING FOR TOOLS *************************************
BOARD_InitPins:
- options: {callFromInitBoot: 'true', coreID: cm33_core0, enableClock: 'true'}
- pin_list:
  - {pin_num: B16, peripheral: SWD, signal: SWO, pin_signal: PIO0_2/TDO/SWO/FC1_P2/CT0_MAT0/UTICK_CAP0/I3C0_PUR, slew_rate: fast, open_drain: disable, drive_strength: high,
    pull_select: down, pull_enable: disable, input_buffer: enable, invert_input: normal}
  - {pin_num: A1, peripheral: LP_FLEXCOMM4, signal: LPFLEXCOMM_P0, pin_signal: PIO1_8/WUU0_IN10/LPTMR1_ALT3/TRACE_DATA0/FC4_P0/FC5_P4/CT_INP8/FLEXIO0_D16/I3C1_SDA/ADC1_A8,
    slew_rate: fast, open_drain: disable, drive_strength: low, pull_select: down, pull_enable: disable, passive_filter: disable, pull_value: low, input_buffer: enable,
    invert_input: normal}
  - {pin_num: B1, peripheral: LP_FLEXCOMM4, signal: LPFLEXCOMM_P1, pin_signal: PIO1_9/TRACE_DATA1/FC4_P1/FC5_P5/CT_INP9/FLEXIO0_D17/I3C1_SCL/ADC1_A9, slew_rate: fast,
    open_drain: disable, drive_strength: low, pull_select: down, pull_enable: disable, passive_filter: disable, input_buffer: enable, invert_input: normal}
  - {pin_num: C5, peripheral: GPIO1, signal: 'GPIO, 1', pin_signal: PIO1_1/TRIG_IN1/FC3_P1/FC4_P5/CT_INP5/FLEXIO0_D9/SAI1_TX_FS/ADC0_A17/CMP1_IN0, direction: OUTPUT,
    gpio_init_state: 'true'}
  - {pin_num: C4, peripheral: GPIO1, signal: 'GPIO, 2', pin_signal: PIO1_2/TRIG_OUT0/FC3_P2/FC4_P6/CT1_MAT0/FLEXIO0_D10/SAI1_TXD0/CAN0_TXD/ADC0_A18, direction: OUTPUT,
    gpio_init_state: 'true'}
  - {pin_num: C6, peripheral: GPIO1, signal: 'GPIO, 0', pin_signal: PIO1_0/WUU0_IN6/LPTMR0_ALT3/TRIG_IN0/FC3_P0/FC4_P4/CT_INP4/FLEXIO0_D8/SAI1_TX_BCLK/ADC0_A16/CMP0_IN0,
    direction: OUTPUT, gpio_init_state: 'true'}
  - {pin_num: F4, peripheral: GPIO1, signal: 'GPIO, 17', pin_signal: PIO1_17/FC5_P1/FC3_P5/CT_INP13/FLEXIO0_D25/I3C1_SCL/ADC1_A17, direction: OUTPUT, gpio_init_state: 'true'}
  - {pin_num: P1, peripheral: GPIO4, signal: 'GPIO, 0', pin_signal: PIO4_0/WUU0_IN18/TRIG_IN6/FC2_P0/CT_INP16/ADC0_A0, direction: INPUT}
  - {pin_num: P2, peripheral: GPIO4, signal: 'GPIO, 1', pin_signal: PIO4_1/TRIG_IN7/FC2_P1/CT_INP17/ADC0_B0, direction: INPUT}
  - {pin_num: M12, peripheral: GPIO5, signal: 'GPIO, 4', pin_signal: PIO5_4/TRIG_OUT7/SPC_LPREQ/TAMPER2/ADC1_B12, direction: INPUT}
  - {pin_num: K12, peripheral: GPIO5, signal: 'GPIO, 5', pin_signal: PIO5_5/TRIG_IN10/LPTMR0_ALT2/TAMPER3/ADC1_B13, direction: INPUT}
 * BE CAREFUL MODIFYING THIS COMMENT - IT IS YAML SETTINGS FOR TOOLS ***********
 */
/* clang-format on */

/* FUNCTION ************************************************************************************************************
 *
 * Function Name : BOARD_InitPins
 * Description   : Configures pin routing and optionally pin electrical features.
 *
 * END ****************************************************************************************************************/
void BOARD_InitPins(void)
{
    /* Enables the clock for GPIO1: Enables clock */
    CLOCK_EnableClock(kCLOCK_Gpio1);
    /* Enables the clock for GPIO4: Enables clock */
    CLOCK_EnableClock(kCLOCK_Gpio4);
    /* Enables the clock for PORT0 controller: Enables clock */
    CLOCK_EnableClock(kCLOCK_Port0);
    /* Enables the clock for PORT1: Enables clock */
    CLOCK_EnableClock(kCLOCK_Port1);
    /* Enables the clock for PORT4: Enables clock */
    CLOCK_EnableClock(kCLOCK_Port4);

    gpio_pin_config_t COL3_config = {
        .pinDirection = kGPIO_DigitalOutput,
        .outputLogic = 1U
    };
    /* Initialize GPIO functionality on pin PIO1_0 (pin C6)  */
    GPIO_PinInit(BOARD_INITPINS_COL3_GPIO, BOARD_INITPINS_COL3_PIN, &COL3_config);

    gpio_pin_config_t COL1_config = {
        .pinDirection = kGPIO_DigitalOutput,
        .outputLogic = 1U
    };
    /* Initialize GPIO functionality on pin PIO1_1 (pin C5)  */
    GPIO_PinInit(BOARD_INITPINS_COL1_GPIO, BOARD_INITPINS_COL1_PIN, &COL1_config);

    gpio_pin_config_t COL2_config = {
        .pinDirection = kGPIO_DigitalOutput,
        .outputLogic = 1U
    };
    /* Initialize GPIO functionality on pin PIO1_2 (pin C4)  */
    GPIO_PinInit(BOARD_INITPINS_COL2_GPIO, BOARD_INITPINS_COL2_PIN, &COL2_config);

    gpio_pin_config_t COL4_config = {
        .pinDirection = kGPIO_DigitalOutput,
        .outputLogic = 1U
    };
    /* Initialize GPIO functionality on pin PIO1_17 (pin F4)  */
    GPIO_PinInit(BOARD_INITPINS_COL4_GPIO, BOARD_INITPINS_COL4_PIN, &COL4_config);

    gpio_pin_config_t ROW1_config = {
        .pinDirection = kGPIO_DigitalInput,
        .outputLogic = 0U
    };
    /* Initialize GPIO functionality on pin PIO4_0 (pin P1)  */
    GPIO_PinInit(BOARD_INITPINS_ROW1_GPIO, BOARD_INITPINS_ROW1_PIN, &ROW1_config);

    gpio_pin_config_t ROW2_config = {
        .pinDirection = kGPIO_DigitalInput,
        .outputLogic = 0U
    };
    /* Initialize GPIO functionality on pin PIO4_1 (pin P2)  */
    GPIO_PinInit(BOARD_INITPINS_ROW2_GPIO, BOARD_INITPINS_ROW2_PIN, &ROW2_config);

    gpio_pin_config_t ROW3_config = {
        .pinDirection = kGPIO_DigitalInput,
        .outputLogic = 0U
    };
    /* Initialize GPIO functionality on pin PIO5_4 (pin M12)  */
    GPIO_PinInit(BOARD_INITPINS_ROW3_GPIO, BOARD_INITPINS_ROW3_PIN, &ROW3_config);

    gpio_pin_config_t ROW4_config = {
        .pinDirection = kGPIO_DigitalInput,
        .outputLogic = 0U
    };
    /* Initialize GPIO functionality on pin PIO5_5 (pin K12)  */
    GPIO_PinInit(BOARD_INITPINS_ROW4_GPIO, BOARD_INITPINS_ROW4_PIN, &ROW4_config);

    const port_pin_config_t port0_2_pinB16_config = {/* Internal pull-up/down resistor is disabled */
                                                     kPORT_PullDisable,
                                                     /* Low internal pull resistor value is selected. */
                                                     kPORT_LowPullResistor,
                                                     /* Fast slew rate is configured */
                                                     kPORT_FastSlewRate,
                                                     /* Passive input filter is disabled */
                                                     kPORT_PassiveFilterDisable,
                                                     /* Open drain output is disabled */
                                                     kPORT_OpenDrainDisable,
                                                     /* High drive strength is configured */
                                                     kPORT_HighDriveStrength,
                                                     /* Pin is configured as SWO */
                                                     kPORT_MuxAlt1,
                                                     /* Digital input enabled */
                                                     kPORT_InputBufferEnable,
                                                     /* Digital input is not inverted */
                                                     kPORT_InputNormal,
                                                     /* Pin Control Register fields [15:0] are not locked */
                                                     kPORT_UnlockRegister};
    /* PORT0_2 (pin B16) is configured as SWO */
    PORT_SetPinConfig(PORT0, 2U, &port0_2_pinB16_config);

    /* PORT1_0 (pin C6) is configured as PIO1_0 */
    PORT_SetPinMux(BOARD_INITPINS_COL3_PORT, BOARD_INITPINS_COL3_PIN, kPORT_MuxAlt0);

    PORT1->PCR[0] = ((PORT1->PCR[0] &
                      /* Mask bits to zero which are setting */
                      (~(PORT_PCR_IBE_MASK)))

                     /* Input Buffer Enable: Enables. */
                     | PORT_PCR_IBE(PCR_IBE_ibe1));

    /* PORT1_1 (pin C5) is configured as PIO1_1 */
    PORT_SetPinMux(BOARD_INITPINS_COL1_PORT, BOARD_INITPINS_COL1_PIN, kPORT_MuxAlt0);

    PORT1->PCR[1] = ((PORT1->PCR[1] &
                      /* Mask bits to zero which are setting */
                      (~(PORT_PCR_IBE_MASK)))

                     /* Input Buffer Enable: Enables. */
                     | PORT_PCR_IBE(PCR_IBE_ibe1));

    /* PORT1_17 (pin F4) is configured as PIO1_17 */
    PORT_SetPinMux(BOARD_INITPINS_COL4_PORT, BOARD_INITPINS_COL4_PIN, kPORT_MuxAlt0);

    PORT1->PCR[17] = ((PORT1->PCR[17] &
                       /* Mask bits to zero which are setting */
                       (~(PORT_PCR_IBE_MASK)))

                      /* Input Buffer Enable: Enables. */
                      | PORT_PCR_IBE(PCR_IBE_ibe1));

    /* PORT1_2 (pin C4) is configured as PIO1_2 */
    PORT_SetPinMux(BOARD_INITPINS_COL2_PORT, BOARD_INITPINS_COL2_PIN, kPORT_MuxAlt0);

    PORT1->PCR[2] = ((PORT1->PCR[2] &
                      /* Mask bits to zero which are setting */
                      (~(PORT_PCR_IBE_MASK)))

                     /* Input Buffer Enable: Enables. */
                     | PORT_PCR_IBE(PCR_IBE_ibe1));

    const port_pin_config_t port1_8_pinA1_config = {/* Internal pull-up/down resistor is disabled */
                                                    kPORT_PullDisable,
                                                    /* Low internal pull resistor value is selected. */
                                                    kPORT_LowPullResistor,
                                                    /* Fast slew rate is configured */
                                                    kPORT_FastSlewRate,
                                                    /* Passive input filter is disabled */
                                                    kPORT_PassiveFilterDisable,
                                                    /* Open drain output is disabled */
                                                    kPORT_OpenDrainDisable,
                                                    /* Low drive strength is configured */
                                                    kPORT_LowDriveStrength,
                                                    /* Pin is configured as FC4_P0 */
                                                    kPORT_MuxAlt2,
                                                    /* Digital input enabled */
                                                    kPORT_InputBufferEnable,
                                                    /* Digital input is not inverted */
                                                    kPORT_InputNormal,
                                                    /* Pin Control Register fields [15:0] are not locked */
                                                    kPORT_UnlockRegister};
    /* PORT1_8 (pin A1) is configured as FC4_P0 */
    PORT_SetPinConfig(PORT1, 8U, &port1_8_pinA1_config);

    const port_pin_config_t port1_9_pinB1_config = {/* Internal pull-up/down resistor is disabled */
                                                    kPORT_PullDisable,
                                                    /* Low internal pull resistor value is selected. */
                                                    kPORT_LowPullResistor,
                                                    /* Fast slew rate is configured */
                                                    kPORT_FastSlewRate,
                                                    /* Passive input filter is disabled */
                                                    kPORT_PassiveFilterDisable,
                                                    /* Open drain output is disabled */
                                                    kPORT_OpenDrainDisable,
                                                    /* Low drive strength is configured */
                                                    kPORT_LowDriveStrength,
                                                    /* Pin is configured as FC4_P1 */
                                                    kPORT_MuxAlt2,
                                                    /* Digital input enabled */
                                                    kPORT_InputBufferEnable,
                                                    /* Digital input is not inverted */
                                                    kPORT_InputNormal,
                                                    /* Pin Control Register fields [15:0] are not locked */
                                                    kPORT_UnlockRegister};
    /* PORT1_9 (pin B1) is configured as FC4_P1 */
    PORT_SetPinConfig(PORT1, 9U, &port1_9_pinB1_config);

    /* PORT4_0 (pin P1) is configured as PIO4_0 */
    PORT_SetPinMux(BOARD_INITPINS_ROW1_PORT, BOARD_INITPINS_ROW1_PIN, kPORT_MuxAlt0);

    PORT4->PCR[0] = ((PORT4->PCR[0] &
                      /* Mask bits to zero which are setting */
                      (~(PORT_PCR_IBE_MASK)))

                     /* Input Buffer Enable: Enables. */
                     | PORT_PCR_IBE(PCR_IBE_ibe1));

    /* PORT4_1 (pin P2) is configured as PIO4_1 */
    PORT_SetPinMux(BOARD_INITPINS_ROW2_PORT, BOARD_INITPINS_ROW2_PIN, kPORT_MuxAlt0);

    PORT4->PCR[1] = ((PORT4->PCR[1] &
                      /* Mask bits to zero which are setting */
                      (~(PORT_PCR_IBE_MASK)))

                     /* Input Buffer Enable: Enables. */
                     | PORT_PCR_IBE(PCR_IBE_ibe1));

    PORT5->PCR[4] = ((PORT5->PCR[4] &
                      /* Mask bits to zero which are setting */
                      (~(PORT_PCR_MUX_MASK | PORT_PCR_IBE_MASK)))

                     /* Pin Multiplex Control: PORT5_4 (pin M12) is configured as PIO5_4. */
                     | PORT_PCR_MUX(PORT5_PCR_MUX_mux00)

                     /* Input Buffer Enable: Enables. */
                     | PORT_PCR_IBE(PCR_IBE_ibe1));

    PORT5->PCR[5] = ((PORT5->PCR[5] &
                      /* Mask bits to zero which are setting */
                      (~(PORT_PCR_MUX_MASK | PORT_PCR_IBE_MASK)))

                     /* Pin Multiplex Control: PORT5_5 (pin K12) is configured as PIO5_5. */
                     | PORT_PCR_MUX(PORT5_PCR_MUX_mux00)

                     /* Input Buffer Enable: Enables. */
                     | PORT_PCR_IBE(PCR_IBE_ibe1));
}
/***********************************************************************************************************************
 * EOF
 **********************************************************************************************************************/
